<?php
/**
 * ClickSyncr Metrics - Signature
 *
 * @package ClickSyncr\Metrics\Security
 * @since 1.0.0
 */

/*
 * Copyright (C) 2010-2025, Renzo Johnson
 * License: GPL-2.0+
 */

namespace ClickSyncr\Metrics\Security;

defined( 'ABSPATH' ) || exit;

/**
 * Signature class
 */
class Signature {

	const PUBLIC_KEY = 'chimpmatic_lite_v1';

	/**
	 * @param string $install_id Install identifier.
	 * @param int    $timestamp Unix timestamp.
	 * @param string $payload_json JSON payload.
	 * @return string
	 */
	public static function generate( $install_id, $timestamp, $payload_json ) {
		$derived_secret = self::derive_secret( $install_id );
		$string_to_sign = $install_id . $timestamp . $payload_json;

		return hash_hmac( 'sha256', $string_to_sign, $derived_secret );
	}

	/**
	 * @param string $install_id Install identifier.
	 * @return string
	 */
	public static function derive_secret( $install_id ) {
		return hash( 'sha256', $install_id . self::PUBLIC_KEY );
	}

	/**
	 * @param string $signature Received signature.
	 * @param string $install_id Install identifier.
	 * @param int    $timestamp Unix timestamp.
	 * @param string $payload_json JSON payload.
	 * @return bool
	 */
	public static function validate( $signature, $install_id, $timestamp, $payload_json ) {
		$expected = self::generate( $install_id, $timestamp, $payload_json );
		return hash_equals( $expected, $signature );
	}

	/**
	 * @return string
	 */
	public static function get_public_key() {
		return self::PUBLIC_KEY;
	}
}
