<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


$modules = array(
	'activate.php',
	'services.php',
	'enqueue.php',
	'tools.php',
	'logger.php',
	'class-cmatic-news.php',
	'class-cmatic-header.php',
	'class-cmatic-plugin-links.php',
	'class-cmatic-api-panel.php',
	'class-cmatic-data-container.php',
	'class-cmatic-audiences.php',
	'handler.php',
	'events.php',
	'rest-api.php',
	'deactivation-survey-init.php',
);

// Dynamically require each module
foreach ( $modules as $module ) {
	$path = SPARTAN_MCE_PLUGIN_DIR . '/lib/' . $module;
	if ( file_exists( $path ) ) {
		require_once $path;
	}
}

// Initialize ClickSyncr Metrics (Telemetry System)
require_once SPARTAN_MCE_PLUGIN_DIR . '/lib/clicksyncr/autoload.php';

ClickSyncr\Metrics\Bootstrap::init(
	array(
		'plugin_basename' => SPARTAN_MCE_PLUGIN_BASENAME,
		'endpoint_url'    => 'https://ping.chimpmatic.com/wp-json/chimpmatic/v1/telemetry',
	)
);
