<?php
/**
 * Plugin Name: Contact Form 7 Extension For Mailchimp
 * Plugin URI: https://renzojohnson.com/contributions/contact-form-7-mailchimp-extension
 * Description: Connect Contact Form 7 to Mailchimp and automatically sync form submissions to your newsletter lists. Streamline your email marketing effortlessly.
 * Version: 0.9.44
 * Author: Renzo Johnson
 * Author URI: https://renzojohnson.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: chimpmatic-lite
 * Domain Path: /languages/
 * Requires at least: 6.4
 * Requires PHP: 7.4
 *
*/

/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

if ( ! function_exists( 'add_filter' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'SPARTAN_MCE_VERSION' ) ) {
	define( 'SPARTAN_MCE_VERSION', '0.9.44' );

	define( 'SPARTAN_MCE_PLUGIN_FILE', __FILE__ );
	define( 'SPARTAN_MCE_PLUGIN_BASENAME', plugin_basename( SPARTAN_MCE_PLUGIN_FILE ) );
	define( 'SPARTAN_MCE_PLUGIN_DIR', plugin_dir_path( SPARTAN_MCE_PLUGIN_FILE ) );
	define( 'SPARTAN_MCE_PLUGIN_URL', plugin_dir_url( SPARTAN_MCE_PLUGIN_FILE ) );
	define( 'CMATIC_LITE_MAX_FIELDS', 6 );

	if ( ! defined( 'CMATIC_LOG_OPTION' ) ) {
		define( 'CMATIC_LOG_OPTION', 'cmatic_log_on' );
	}
}


require_once SPARTAN_MCE_PLUGIN_DIR . 'lib/bootstrap.php';

// Register activation hook
register_activation_hook( __FILE__, 'cmatic_on_activation' );

// Register deactivation hook
register_deactivation_hook( __FILE__, 'cmatic_on_deactivation' );
