/**
 * Chimpmatic LITE - Promotional Form Injection & Auto-Population
 *
 * This script dynamically creates and injects a promotional form after page load
 * to bypass Contact Form 7's innerHTML monitoring which strips forms from notices.
 *
 * Features:
 * - Creates form elements programmatically (not via innerHTML)
 * - Auto-populates name and email fields for logged-in WordPress users
 * - Submits to remote Chimpmatic server for coupon distribution
 * - Includes CF7-compatible hidden fields for form processing
 *
 * User Auto-Population:
 * When a WordPress user is logged in, their display name and email are automatically
 * populated from the localized `chimpmaticUserData` object (set in enqueue.php).
 * Users can still edit these pre-filled values.
 *
 * @package Chimpmatic_Lite
 * @since 0.9.22 Initial promo form injection
 * @since 0.9.23 Added WordPress user auto-population
 * @see enqueue.php Lines 328-353 for user data localization
 */
(function () {
	'use strict';

	// Wait for DOM to be fully loaded and CF7 to finish processing
	if (document.readyState === 'loading') {
		document.addEventListener( 'DOMContentLoaded', injectPromoForm );
	} else {
		// DOM already loaded, wait a bit for CF7 JS to finish
		setTimeout( injectPromoForm, 100 );
	}

	function injectPromoForm() {
		const container = document.getElementById( 'promo-form-container' );
		if ( ! container) {
			return;
		}

		// Check if form already exists (prevent double injection)
		if (container.querySelector( 'form' )) {
			return;
		}

		// Create form element programmatically (bypasses CF7's innerHTML monitoring)
		const form = document.createElement( 'form' );
		form.setAttribute( 'action', 'https://chimpmatic.com/almost-there' );
		form.setAttribute( 'target', '_blank' );
		form.setAttribute( 'method', 'post' );
		form.className = 'cm-promo-form';

		// Create paragraph wrapper
		const p = document.createElement( 'p' );

		// Create name field
		const nameLabel       = document.createElement( 'label' );
		const nameSpan        = document.createElement( 'span' );
		nameSpan.className    = 'your-name';
		const nameInput       = document.createElement( 'input' );
		nameInput.type        = 'text';
		nameInput.name        = 'your-name';
		nameInput.size        = 40;
		nameInput.className   = 'cm-form-control cm-text';
		nameInput.placeholder = 'Your Name';
		nameInput.required    = true;

		/**
		 * Auto-populate name field for logged-in users
		 *
		 * Checks if WordPress user data is available (localized from PHP)
		 * and populates the name field with the current user's display name.
		 * This improves UX by pre-filling known data while remaining editable.
		 *
		 * Data source: chimpmaticUserData global (set in enqueue.php)
		 * @since 0.9.23
		 */
		if (typeof chimpmaticUserData !== 'undefined' && chimpmaticUserData.isLoggedIn && chimpmaticUserData.userName) {
			nameInput.value = chimpmaticUserData.userName;
			console.log( '[ChimpMatic Lite] Auto-populated name field:', chimpmaticUserData.userName );
		}

		nameSpan.appendChild( nameInput );
		nameLabel.appendChild( nameSpan );
		p.appendChild( nameLabel );
		p.appendChild( document.createElement( 'br' ) );

		// Create email field
		const emailLabel       = document.createElement( 'label' );
		const emailSpan        = document.createElement( 'span' );
		emailSpan.className    = 'your-email';
		const emailInput       = document.createElement( 'input' );
		emailInput.type        = 'email';
		emailInput.name        = 'your-email';
		emailInput.size        = 40;
		emailInput.className   = 'cm-form-control cm-email';
		emailInput.placeholder = 'Your Email';
		emailInput.required    = true;

		/**
		 * Auto-populate email field for logged-in users
		 *
		 * Checks if WordPress user data is available (localized from PHP)
		 * and populates the email field with the current user's email address.
		 * This improves UX by pre-filling known data while remaining editable.
		 *
		 * Data source: chimpmaticUserData global (set in enqueue.php)
		 * @since 0.9.23
		 */
		if (typeof chimpmaticUserData !== 'undefined' && chimpmaticUserData.isLoggedIn && chimpmaticUserData.userEmail) {
			emailInput.value = chimpmaticUserData.userEmail;
			console.log( '[ChimpMatic Lite] Auto-populated email field:', chimpmaticUserData.userEmail );
		}

		emailSpan.appendChild( emailInput );
		emailLabel.appendChild( emailSpan );
		p.appendChild( emailLabel );
		p.appendChild( document.createElement( 'br' ) );

		// Create submit button
		const submitButton     = document.createElement( 'input' );
		submitButton.type      = 'submit';
		submitButton.value     = 'Send me the coupon';
		submitButton.className = 'button cm-submit';
		p.appendChild( submitButton );

		// Add CF7 hidden fields that the remote server expects
		const hiddenFields = {
			'_wpcf7': '10181',
			'_wpcf7_version': '6.1.2',
			'_wpcf7_locale': 'en_US',
			'_wpcf7_unit_tag': 'wpcf7-f10181-p10182-o1',
			'_wpcf7_container_post': '10182'
		};

		for (const [name, value] of Object.entries( hiddenFields )) {
			const hidden = document.createElement( 'input' );
			hidden.type  = 'hidden';
			hidden.name  = name;
			hidden.value = value;
			form.appendChild( hidden );
		}

		// Assemble form
		form.appendChild( p );
		container.appendChild( form );

		// Add submit handler to debug
		form.addEventListener(
			'submit',
			function (e) {
				console.log( '[ChimpMatic Lite] Form submitting...' );
				console.log( 'Action:', this.action );
				console.log( 'Method:', this.method );
				console.log( 'Target:', this.target );
				console.log(
					'Form data:',
					{
						name: nameInput.value,
						email: emailInput.value
					}
				);
				// Let the form submit naturally - don't prevent default
			}
		);

		console.log( '[ChimpMatic Lite] Promotional form injected successfully' );
	}
})();
