<?php
/**
 * OrderResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * OrderResponse Class Doc Comment
 *
 * @category Class
 * @description order response
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order_response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amount' => 'int',
        'amount_refunded' => 'int',
        'channel' => '\Conekta\Model\OrderChannelResponse',
        'charges' => '\Conekta\Model\OrderChargesResponse',
        'checkout' => '\Conekta\Model\OrderResponseCheckout',
        'created_at' => 'int',
        'currency' => 'string',
        'customer_info' => '\Conekta\Model\OrderResponseCustomerInfo',
        'discount_lines' => '\Conekta\Model\OrderDiscountLinesResponse',
        'fiscal_entity' => '\Conekta\Model\OrderFiscalEntityResponse',
        'id' => 'string',
        'is_refundable' => 'bool',
        'line_items' => '\Conekta\Model\OrderResponseProducts',
        'livemode' => 'bool',
        'metadata' => 'array<string,mixed>',
        'next_action' => '\Conekta\Model\OrderNextActionResponse',
        'object' => 'string',
        'payment_status' => 'string',
        'processing_mode' => 'string',
        'shipping_contact' => '\Conekta\Model\OrderResponseShippingContact',
        'updated_at' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amount' => null,
        'amount_refunded' => null,
        'channel' => null,
        'charges' => null,
        'checkout' => null,
        'created_at' => 'int64',
        'currency' => null,
        'customer_info' => null,
        'discount_lines' => null,
        'fiscal_entity' => null,
        'id' => null,
        'is_refundable' => null,
        'line_items' => null,
        'livemode' => null,
        'metadata' => null,
        'next_action' => null,
        'object' => null,
        'payment_status' => null,
        'processing_mode' => null,
        'shipping_contact' => null,
        'updated_at' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'amount' => false,
        'amount_refunded' => false,
        'channel' => false,
        'charges' => false,
        'checkout' => false,
        'created_at' => false,
        'currency' => false,
        'customer_info' => false,
        'discount_lines' => false,
        'fiscal_entity' => true,
        'id' => false,
        'is_refundable' => false,
        'line_items' => false,
        'livemode' => false,
        'metadata' => false,
        'next_action' => false,
        'object' => false,
        'payment_status' => false,
        'processing_mode' => false,
        'shipping_contact' => false,
        'updated_at' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amount' => 'amount',
        'amount_refunded' => 'amount_refunded',
        'channel' => 'channel',
        'charges' => 'charges',
        'checkout' => 'checkout',
        'created_at' => 'created_at',
        'currency' => 'currency',
        'customer_info' => 'customer_info',
        'discount_lines' => 'discount_lines',
        'fiscal_entity' => 'fiscal_entity',
        'id' => 'id',
        'is_refundable' => 'is_refundable',
        'line_items' => 'line_items',
        'livemode' => 'livemode',
        'metadata' => 'metadata',
        'next_action' => 'next_action',
        'object' => 'object',
        'payment_status' => 'payment_status',
        'processing_mode' => 'processing_mode',
        'shipping_contact' => 'shipping_contact',
        'updated_at' => 'updated_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amount' => 'setAmount',
        'amount_refunded' => 'setAmountRefunded',
        'channel' => 'setChannel',
        'charges' => 'setCharges',
        'checkout' => 'setCheckout',
        'created_at' => 'setCreatedAt',
        'currency' => 'setCurrency',
        'customer_info' => 'setCustomerInfo',
        'discount_lines' => 'setDiscountLines',
        'fiscal_entity' => 'setFiscalEntity',
        'id' => 'setId',
        'is_refundable' => 'setIsRefundable',
        'line_items' => 'setLineItems',
        'livemode' => 'setLivemode',
        'metadata' => 'setMetadata',
        'next_action' => 'setNextAction',
        'object' => 'setObject',
        'payment_status' => 'setPaymentStatus',
        'processing_mode' => 'setProcessingMode',
        'shipping_contact' => 'setShippingContact',
        'updated_at' => 'setUpdatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amount' => 'getAmount',
        'amount_refunded' => 'getAmountRefunded',
        'channel' => 'getChannel',
        'charges' => 'getCharges',
        'checkout' => 'getCheckout',
        'created_at' => 'getCreatedAt',
        'currency' => 'getCurrency',
        'customer_info' => 'getCustomerInfo',
        'discount_lines' => 'getDiscountLines',
        'fiscal_entity' => 'getFiscalEntity',
        'id' => 'getId',
        'is_refundable' => 'getIsRefundable',
        'line_items' => 'getLineItems',
        'livemode' => 'getLivemode',
        'metadata' => 'getMetadata',
        'next_action' => 'getNextAction',
        'object' => 'getObject',
        'payment_status' => 'getPaymentStatus',
        'processing_mode' => 'getProcessingMode',
        'shipping_contact' => 'getShippingContact',
        'updated_at' => 'getUpdatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('amount_refunded', $data ?? [], null);
        $this->setIfExists('channel', $data ?? [], null);
        $this->setIfExists('charges', $data ?? [], null);
        $this->setIfExists('checkout', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('customer_info', $data ?? [], null);
        $this->setIfExists('discount_lines', $data ?? [], null);
        $this->setIfExists('fiscal_entity', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_refundable', $data ?? [], null);
        $this->setIfExists('line_items', $data ?? [], null);
        $this->setIfExists('livemode', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
        $this->setIfExists('next_action', $data ?? [], null);
        $this->setIfExists('object', $data ?? [], null);
        $this->setIfExists('payment_status', $data ?? [], null);
        $this->setIfExists('processing_mode', $data ?? [], null);
        $this->setIfExists('shipping_contact', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['metadata']) && (count($this->container['metadata']) > 100)) {
            $invalidProperties[] = "invalid value for 'metadata', number of items must be less than or equal to 100.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets amount
     *
     * @return int|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param int|null $amount The total amount to be collected in cents
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets amount_refunded
     *
     * @return int|null
     */
    public function getAmountRefunded()
    {
        return $this->container['amount_refunded'];
    }

    /**
     * Sets amount_refunded
     *
     * @param int|null $amount_refunded The total amount refunded in cents
     *
     * @return self
     */
    public function setAmountRefunded($amount_refunded)
    {
        if (is_null($amount_refunded)) {
            throw new \InvalidArgumentException('non-nullable amount_refunded cannot be null');
        }
        $this->container['amount_refunded'] = $amount_refunded;

        return $this;
    }

    /**
     * Gets channel
     *
     * @return \Conekta\Model\OrderChannelResponse|null
     */
    public function getChannel()
    {
        return $this->container['channel'];
    }

    /**
     * Sets channel
     *
     * @param \Conekta\Model\OrderChannelResponse|null $channel channel
     *
     * @return self
     */
    public function setChannel($channel)
    {
        if (is_null($channel)) {
            throw new \InvalidArgumentException('non-nullable channel cannot be null');
        }
        $this->container['channel'] = $channel;

        return $this;
    }

    /**
     * Gets charges
     *
     * @return \Conekta\Model\OrderChargesResponse|null
     */
    public function getCharges()
    {
        return $this->container['charges'];
    }

    /**
     * Sets charges
     *
     * @param \Conekta\Model\OrderChargesResponse|null $charges charges
     *
     * @return self
     */
    public function setCharges($charges)
    {
        if (is_null($charges)) {
            throw new \InvalidArgumentException('non-nullable charges cannot be null');
        }
        $this->container['charges'] = $charges;

        return $this;
    }

    /**
     * Gets checkout
     *
     * @return \Conekta\Model\OrderResponseCheckout|null
     */
    public function getCheckout()
    {
        return $this->container['checkout'];
    }

    /**
     * Sets checkout
     *
     * @param \Conekta\Model\OrderResponseCheckout|null $checkout checkout
     *
     * @return self
     */
    public function setCheckout($checkout)
    {
        if (is_null($checkout)) {
            throw new \InvalidArgumentException('non-nullable checkout cannot be null');
        }
        $this->container['checkout'] = $checkout;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return int|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param int|null $created_at The time at which the object was created in seconds since the Unix epoch
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency The three-letter ISO 4217 currency code. The currency of the order.
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets customer_info
     *
     * @return \Conekta\Model\OrderResponseCustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->container['customer_info'];
    }

    /**
     * Sets customer_info
     *
     * @param \Conekta\Model\OrderResponseCustomerInfo|null $customer_info customer_info
     *
     * @return self
     */
    public function setCustomerInfo($customer_info)
    {
        if (is_null($customer_info)) {
            throw new \InvalidArgumentException('non-nullable customer_info cannot be null');
        }
        $this->container['customer_info'] = $customer_info;

        return $this;
    }

    /**
     * Gets discount_lines
     *
     * @return \Conekta\Model\OrderDiscountLinesResponse|null
     */
    public function getDiscountLines()
    {
        return $this->container['discount_lines'];
    }

    /**
     * Sets discount_lines
     *
     * @param \Conekta\Model\OrderDiscountLinesResponse|null $discount_lines discount_lines
     *
     * @return self
     */
    public function setDiscountLines($discount_lines)
    {
        if (is_null($discount_lines)) {
            throw new \InvalidArgumentException('non-nullable discount_lines cannot be null');
        }
        $this->container['discount_lines'] = $discount_lines;

        return $this;
    }

    /**
     * Gets fiscal_entity
     *
     * @return \Conekta\Model\OrderFiscalEntityResponse|null
     */
    public function getFiscalEntity()
    {
        return $this->container['fiscal_entity'];
    }

    /**
     * Sets fiscal_entity
     *
     * @param \Conekta\Model\OrderFiscalEntityResponse|null $fiscal_entity fiscal_entity
     *
     * @return self
     */
    public function setFiscalEntity($fiscal_entity)
    {
        if (is_null($fiscal_entity)) {
            array_push($this->openAPINullablesSetToNull, 'fiscal_entity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fiscal_entity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fiscal_entity'] = $fiscal_entity;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_refundable
     *
     * @return bool|null
     */
    public function getIsRefundable()
    {
        return $this->container['is_refundable'];
    }

    /**
     * Sets is_refundable
     *
     * @param bool|null $is_refundable is_refundable
     *
     * @return self
     */
    public function setIsRefundable($is_refundable)
    {
        if (is_null($is_refundable)) {
            throw new \InvalidArgumentException('non-nullable is_refundable cannot be null');
        }
        $this->container['is_refundable'] = $is_refundable;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Conekta\Model\OrderResponseProducts|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Conekta\Model\OrderResponseProducts|null $line_items line_items
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        if (is_null($line_items)) {
            throw new \InvalidArgumentException('non-nullable line_items cannot be null');
        }
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets livemode
     *
     * @return bool|null
     */
    public function getLivemode()
    {
        return $this->container['livemode'];
    }

    /**
     * Sets livemode
     *
     * @param bool|null $livemode Whether the object exists in live mode or test mode
     *
     * @return self
     */
    public function setLivemode($livemode)
    {
        if (is_null($livemode)) {
            throw new \InvalidArgumentException('non-nullable livemode cannot be null');
        }
        $this->container['livemode'] = $livemode;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return array<string,mixed>|null
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param array<string,mixed>|null $metadata Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        if (is_null($metadata)) {
            throw new \InvalidArgumentException('non-nullable metadata cannot be null');
        }

        if ((count($metadata) > 100)) {
            throw new \InvalidArgumentException('invalid value for $metadata when calling OrderResponse., number of items must be less than or equal to 100.');
        }
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets next_action
     *
     * @return \Conekta\Model\OrderNextActionResponse|null
     */
    public function getNextAction()
    {
        return $this->container['next_action'];
    }

    /**
     * Sets next_action
     *
     * @param \Conekta\Model\OrderNextActionResponse|null $next_action next_action
     *
     * @return self
     */
    public function setNextAction($next_action)
    {
        if (is_null($next_action)) {
            throw new \InvalidArgumentException('non-nullable next_action cannot be null');
        }
        $this->container['next_action'] = $next_action;

        return $this;
    }

    /**
     * Gets object
     *
     * @return string|null
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     *
     * @param string|null $object String representing the object’s type. Objects of the same type share the same value.
     *
     * @return self
     */
    public function setObject($object)
    {
        if (is_null($object)) {
            throw new \InvalidArgumentException('non-nullable object cannot be null');
        }
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets payment_status
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['payment_status'];
    }

    /**
     * Sets payment_status
     *
     * @param string|null $payment_status The payment status of the order.
     *
     * @return self
     */
    public function setPaymentStatus($payment_status)
    {
        if (is_null($payment_status)) {
            throw new \InvalidArgumentException('non-nullable payment_status cannot be null');
        }
        $this->container['payment_status'] = $payment_status;

        return $this;
    }

    /**
     * Gets processing_mode
     *
     * @return string|null
     */
    public function getProcessingMode()
    {
        return $this->container['processing_mode'];
    }

    /**
     * Sets processing_mode
     *
     * @param string|null $processing_mode Indicates the processing mode for the order, either ecommerce, recurrent or validation.
     *
     * @return self
     */
    public function setProcessingMode($processing_mode)
    {
        if (is_null($processing_mode)) {
            throw new \InvalidArgumentException('non-nullable processing_mode cannot be null');
        }
        $this->container['processing_mode'] = $processing_mode;

        return $this;
    }

    /**
     * Gets shipping_contact
     *
     * @return \Conekta\Model\OrderResponseShippingContact|null
     */
    public function getShippingContact()
    {
        return $this->container['shipping_contact'];
    }

    /**
     * Sets shipping_contact
     *
     * @param \Conekta\Model\OrderResponseShippingContact|null $shipping_contact shipping_contact
     *
     * @return self
     */
    public function setShippingContact($shipping_contact)
    {
        if (is_null($shipping_contact)) {
            throw new \InvalidArgumentException('non-nullable shipping_contact cannot be null');
        }
        $this->container['shipping_contact'] = $shipping_contact;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return int|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param int|null $updated_at The time at which the object was last updated in seconds since the Unix epoch
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            throw new \InvalidArgumentException('non-nullable updated_at cannot be null');
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


