<?php
/**
 * LogResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * LogResponse Class Doc Comment
 *
 * @category Class
 * @description log model
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class LogResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'log_response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'created_at' => 'int',
        'id' => 'string',
        'ip_address' => 'string',
        'livemode' => 'bool',
        'loggable_id' => 'string',
        'loggable_type' => 'string',
        'method' => 'string',
        'oauth_token_id' => 'string',
        'query_string' => 'array<string,mixed>',
        'related' => 'string',
        'request_body' => 'object',
        'request_headers' => 'array<string,string>',
        'response_body' => 'object',
        'response_headers' => 'array<string,string>',
        'searchable_tags' => 'string[]',
        'status' => 'string',
        'updated_at' => 'string',
        'url' => 'string',
        'user_account_id' => 'string',
        'version' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'created_at' => 'int64',
        'id' => null,
        'ip_address' => 'ipv4',
        'livemode' => null,
        'loggable_id' => null,
        'loggable_type' => null,
        'method' => null,
        'oauth_token_id' => null,
        'query_string' => null,
        'related' => null,
        'request_body' => null,
        'request_headers' => null,
        'response_body' => null,
        'response_headers' => null,
        'searchable_tags' => null,
        'status' => null,
        'updated_at' => null,
        'url' => null,
        'user_account_id' => null,
        'version' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'created_at' => false,
        'id' => false,
        'ip_address' => false,
        'livemode' => false,
        'loggable_id' => true,
        'loggable_type' => true,
        'method' => false,
        'oauth_token_id' => true,
        'query_string' => false,
        'related' => false,
        'request_body' => false,
        'request_headers' => false,
        'response_body' => false,
        'response_headers' => false,
        'searchable_tags' => false,
        'status' => false,
        'updated_at' => false,
        'url' => false,
        'user_account_id' => false,
        'version' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'created_at' => 'created_at',
        'id' => 'id',
        'ip_address' => 'ip_address',
        'livemode' => 'livemode',
        'loggable_id' => 'loggable_id',
        'loggable_type' => 'loggable_type',
        'method' => 'method',
        'oauth_token_id' => 'oauth_token_id',
        'query_string' => 'query_string',
        'related' => 'related',
        'request_body' => 'request_body',
        'request_headers' => 'request_headers',
        'response_body' => 'response_body',
        'response_headers' => 'response_headers',
        'searchable_tags' => 'searchable_tags',
        'status' => 'status',
        'updated_at' => 'updated_at',
        'url' => 'url',
        'user_account_id' => 'user_account_id',
        'version' => 'version'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'created_at' => 'setCreatedAt',
        'id' => 'setId',
        'ip_address' => 'setIpAddress',
        'livemode' => 'setLivemode',
        'loggable_id' => 'setLoggableId',
        'loggable_type' => 'setLoggableType',
        'method' => 'setMethod',
        'oauth_token_id' => 'setOauthTokenId',
        'query_string' => 'setQueryString',
        'related' => 'setRelated',
        'request_body' => 'setRequestBody',
        'request_headers' => 'setRequestHeaders',
        'response_body' => 'setResponseBody',
        'response_headers' => 'setResponseHeaders',
        'searchable_tags' => 'setSearchableTags',
        'status' => 'setStatus',
        'updated_at' => 'setUpdatedAt',
        'url' => 'setUrl',
        'user_account_id' => 'setUserAccountId',
        'version' => 'setVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'created_at' => 'getCreatedAt',
        'id' => 'getId',
        'ip_address' => 'getIpAddress',
        'livemode' => 'getLivemode',
        'loggable_id' => 'getLoggableId',
        'loggable_type' => 'getLoggableType',
        'method' => 'getMethod',
        'oauth_token_id' => 'getOauthTokenId',
        'query_string' => 'getQueryString',
        'related' => 'getRelated',
        'request_body' => 'getRequestBody',
        'request_headers' => 'getRequestHeaders',
        'response_body' => 'getResponseBody',
        'response_headers' => 'getResponseHeaders',
        'searchable_tags' => 'getSearchableTags',
        'status' => 'getStatus',
        'updated_at' => 'getUpdatedAt',
        'url' => 'getUrl',
        'user_account_id' => 'getUserAccountId',
        'version' => 'getVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('ip_address', $data ?? [], null);
        $this->setIfExists('livemode', $data ?? [], null);
        $this->setIfExists('loggable_id', $data ?? [], null);
        $this->setIfExists('loggable_type', $data ?? [], null);
        $this->setIfExists('method', $data ?? [], null);
        $this->setIfExists('oauth_token_id', $data ?? [], null);
        $this->setIfExists('query_string', $data ?? [], null);
        $this->setIfExists('related', $data ?? [], null);
        $this->setIfExists('request_body', $data ?? [], null);
        $this->setIfExists('request_headers', $data ?? [], null);
        $this->setIfExists('response_body', $data ?? [], null);
        $this->setIfExists('response_headers', $data ?? [], null);
        $this->setIfExists('searchable_tags', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
        $this->setIfExists('user_account_id', $data ?? [], null);
        $this->setIfExists('version', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['livemode'] === null) {
            $invalidProperties[] = "'livemode' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets created_at
     *
     * @return int
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param int $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets ip_address
     *
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->container['ip_address'];
    }

    /**
     * Sets ip_address
     *
     * @param string|null $ip_address ip_address
     *
     * @return self
     */
    public function setIpAddress($ip_address)
    {
        if (is_null($ip_address)) {
            throw new \InvalidArgumentException('non-nullable ip_address cannot be null');
        }
        $this->container['ip_address'] = $ip_address;

        return $this;
    }

    /**
     * Gets livemode
     *
     * @return bool
     */
    public function getLivemode()
    {
        return $this->container['livemode'];
    }

    /**
     * Sets livemode
     *
     * @param bool $livemode livemode
     *
     * @return self
     */
    public function setLivemode($livemode)
    {
        if (is_null($livemode)) {
            throw new \InvalidArgumentException('non-nullable livemode cannot be null');
        }
        $this->container['livemode'] = $livemode;

        return $this;
    }

    /**
     * Gets loggable_id
     *
     * @return string|null
     */
    public function getLoggableId()
    {
        return $this->container['loggable_id'];
    }

    /**
     * Sets loggable_id
     *
     * @param string|null $loggable_id loggable_id
     *
     * @return self
     */
    public function setLoggableId($loggable_id)
    {
        if (is_null($loggable_id)) {
            array_push($this->openAPINullablesSetToNull, 'loggable_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('loggable_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['loggable_id'] = $loggable_id;

        return $this;
    }

    /**
     * Gets loggable_type
     *
     * @return string|null
     */
    public function getLoggableType()
    {
        return $this->container['loggable_type'];
    }

    /**
     * Sets loggable_type
     *
     * @param string|null $loggable_type loggable_type
     *
     * @return self
     */
    public function setLoggableType($loggable_type)
    {
        if (is_null($loggable_type)) {
            array_push($this->openAPINullablesSetToNull, 'loggable_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('loggable_type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['loggable_type'] = $loggable_type;

        return $this;
    }

    /**
     * Gets method
     *
     * @return string|null
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     *
     * @param string|null $method method
     *
     * @return self
     */
    public function setMethod($method)
    {
        if (is_null($method)) {
            throw new \InvalidArgumentException('non-nullable method cannot be null');
        }
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets oauth_token_id
     *
     * @return string|null
     */
    public function getOauthTokenId()
    {
        return $this->container['oauth_token_id'];
    }

    /**
     * Sets oauth_token_id
     *
     * @param string|null $oauth_token_id oauth_token_id
     *
     * @return self
     */
    public function setOauthTokenId($oauth_token_id)
    {
        if (is_null($oauth_token_id)) {
            array_push($this->openAPINullablesSetToNull, 'oauth_token_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('oauth_token_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['oauth_token_id'] = $oauth_token_id;

        return $this;
    }

    /**
     * Gets query_string
     *
     * @return array<string,mixed>|null
     */
    public function getQueryString()
    {
        return $this->container['query_string'];
    }

    /**
     * Sets query_string
     *
     * @param array<string,mixed>|null $query_string query_string
     *
     * @return self
     */
    public function setQueryString($query_string)
    {
        if (is_null($query_string)) {
            throw new \InvalidArgumentException('non-nullable query_string cannot be null');
        }
        $this->container['query_string'] = $query_string;

        return $this;
    }

    /**
     * Gets related
     *
     * @return string|null
     */
    public function getRelated()
    {
        return $this->container['related'];
    }

    /**
     * Sets related
     *
     * @param string|null $related related
     *
     * @return self
     */
    public function setRelated($related)
    {
        if (is_null($related)) {
            throw new \InvalidArgumentException('non-nullable related cannot be null');
        }
        $this->container['related'] = $related;

        return $this;
    }

    /**
     * Gets request_body
     *
     * @return object|null
     */
    public function getRequestBody()
    {
        return $this->container['request_body'];
    }

    /**
     * Sets request_body
     *
     * @param object|null $request_body request_body
     *
     * @return self
     */
    public function setRequestBody($request_body)
    {
        if (is_null($request_body)) {
            throw new \InvalidArgumentException('non-nullable request_body cannot be null');
        }
        $this->container['request_body'] = $request_body;

        return $this;
    }

    /**
     * Gets request_headers
     *
     * @return array<string,string>|null
     */
    public function getRequestHeaders()
    {
        return $this->container['request_headers'];
    }

    /**
     * Sets request_headers
     *
     * @param array<string,string>|null $request_headers request_headers
     *
     * @return self
     */
    public function setRequestHeaders($request_headers)
    {
        if (is_null($request_headers)) {
            throw new \InvalidArgumentException('non-nullable request_headers cannot be null');
        }
        $this->container['request_headers'] = $request_headers;

        return $this;
    }

    /**
     * Gets response_body
     *
     * @return object|null
     */
    public function getResponseBody()
    {
        return $this->container['response_body'];
    }

    /**
     * Sets response_body
     *
     * @param object|null $response_body response_body
     *
     * @return self
     */
    public function setResponseBody($response_body)
    {
        if (is_null($response_body)) {
            throw new \InvalidArgumentException('non-nullable response_body cannot be null');
        }
        $this->container['response_body'] = $response_body;

        return $this;
    }

    /**
     * Gets response_headers
     *
     * @return array<string,string>|null
     */
    public function getResponseHeaders()
    {
        return $this->container['response_headers'];
    }

    /**
     * Sets response_headers
     *
     * @param array<string,string>|null $response_headers response_headers
     *
     * @return self
     */
    public function setResponseHeaders($response_headers)
    {
        if (is_null($response_headers)) {
            throw new \InvalidArgumentException('non-nullable response_headers cannot be null');
        }
        $this->container['response_headers'] = $response_headers;

        return $this;
    }

    /**
     * Gets searchable_tags
     *
     * @return string[]|null
     */
    public function getSearchableTags()
    {
        return $this->container['searchable_tags'];
    }

    /**
     * Sets searchable_tags
     *
     * @param string[]|null $searchable_tags searchable_tags
     *
     * @return self
     */
    public function setSearchableTags($searchable_tags)
    {
        if (is_null($searchable_tags)) {
            throw new \InvalidArgumentException('non-nullable searchable_tags cannot be null');
        }
        $this->container['searchable_tags'] = $searchable_tags;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at updated_at
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            throw new \InvalidArgumentException('non-nullable updated_at cannot be null');
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url url
     *
     * @return self
     */
    public function setUrl($url)
    {
        if (is_null($url)) {
            throw new \InvalidArgumentException('non-nullable url cannot be null');
        }
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets user_account_id
     *
     * @return string|null
     */
    public function getUserAccountId()
    {
        return $this->container['user_account_id'];
    }

    /**
     * Sets user_account_id
     *
     * @param string|null $user_account_id user_account_id
     *
     * @return self
     */
    public function setUserAccountId($user_account_id)
    {
        if (is_null($user_account_id)) {
            throw new \InvalidArgumentException('non-nullable user_account_id cannot be null');
        }
        $this->container['user_account_id'] = $user_account_id;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version version
     *
     * @return self
     */
    public function setVersion($version)
    {
        if (is_null($version)) {
            throw new \InvalidArgumentException('non-nullable version cannot be null');
        }
        $this->container['version'] = $version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


