<?php
/**
 * CreateCompanyRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * CreateCompanyRequest Class Doc Comment
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateCompanyRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'create_company_request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'type_company' => 'string',
        'comercial_info' => '\Conekta\Model\CreateCompanyRequestComercialInfo',
        'fiscal_info' => '\Conekta\Model\CreateCompanyRequestFiscalInfo',
        'bank_account_info' => '\Conekta\Model\CreateCompanyRequestBankAccountInfo'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'type_company' => null,
        'comercial_info' => null,
        'fiscal_info' => null,
        'bank_account_info' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'type_company' => false,
        'comercial_info' => false,
        'fiscal_info' => false,
        'bank_account_info' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'type_company' => 'type_company',
        'comercial_info' => 'comercial_info',
        'fiscal_info' => 'fiscal_info',
        'bank_account_info' => 'bank_account_info'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'type_company' => 'setTypeCompany',
        'comercial_info' => 'setComercialInfo',
        'fiscal_info' => 'setFiscalInfo',
        'bank_account_info' => 'setBankAccountInfo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'type_company' => 'getTypeCompany',
        'comercial_info' => 'getComercialInfo',
        'fiscal_info' => 'getFiscalInfo',
        'bank_account_info' => 'getBankAccountInfo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('type_company', $data ?? [], null);
        $this->setIfExists('comercial_info', $data ?? [], null);
        $this->setIfExists('fiscal_info', $data ?? [], null);
        $this->setIfExists('bank_account_info', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the company.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type_company
     *
     * @return string|null
     */
    public function getTypeCompany()
    {
        return $this->container['type_company'];
    }

    /**
     * Sets type_company
     *
     * @param string|null $type_company The type of company, 'owner'
     *
     * @return self
     */
    public function setTypeCompany($type_company)
    {
        if (is_null($type_company)) {
            throw new \InvalidArgumentException('non-nullable type_company cannot be null');
        }
        $this->container['type_company'] = $type_company;

        return $this;
    }

    /**
     * Gets comercial_info
     *
     * @return \Conekta\Model\CreateCompanyRequestComercialInfo|null
     */
    public function getComercialInfo()
    {
        return $this->container['comercial_info'];
    }

    /**
     * Sets comercial_info
     *
     * @param \Conekta\Model\CreateCompanyRequestComercialInfo|null $comercial_info comercial_info
     *
     * @return self
     */
    public function setComercialInfo($comercial_info)
    {
        if (is_null($comercial_info)) {
            throw new \InvalidArgumentException('non-nullable comercial_info cannot be null');
        }
        $this->container['comercial_info'] = $comercial_info;

        return $this;
    }

    /**
     * Gets fiscal_info
     *
     * @return \Conekta\Model\CreateCompanyRequestFiscalInfo|null
     */
    public function getFiscalInfo()
    {
        return $this->container['fiscal_info'];
    }

    /**
     * Sets fiscal_info
     *
     * @param \Conekta\Model\CreateCompanyRequestFiscalInfo|null $fiscal_info fiscal_info
     *
     * @return self
     */
    public function setFiscalInfo($fiscal_info)
    {
        if (is_null($fiscal_info)) {
            throw new \InvalidArgumentException('non-nullable fiscal_info cannot be null');
        }
        $this->container['fiscal_info'] = $fiscal_info;

        return $this;
    }

    /**
     * Gets bank_account_info
     *
     * @return \Conekta\Model\CreateCompanyRequestBankAccountInfo|null
     */
    public function getBankAccountInfo()
    {
        return $this->container['bank_account_info'];
    }

    /**
     * Sets bank_account_info
     *
     * @param \Conekta\Model\CreateCompanyRequestBankAccountInfo|null $bank_account_info bank_account_info
     *
     * @return self
     */
    public function setBankAccountInfo($bank_account_info)
    {
        if (is_null($bank_account_info)) {
            throw new \InvalidArgumentException('non-nullable bank_account_info cannot be null');
        }
        $this->container['bank_account_info'] = $bank_account_info;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


