<?php
/**
 * CompanyResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * CompanyResponse Class Doc Comment
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CompanyResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'company_response';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'active' => 'bool',
        'account_status' => 'string',
        'parent_company_id' => 'string',
        'onboarding_status' => 'string',
        'documents' => '\Conekta\Model\CompanyResponseDocumentsInner[]',
        'created_at' => 'int',
        'object' => 'string',
        'three_ds_enabled' => 'bool',
        'three_ds_mode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'active' => null,
        'account_status' => null,
        'parent_company_id' => null,
        'onboarding_status' => null,
        'documents' => null,
        'created_at' => 'int64',
        'object' => null,
        'three_ds_enabled' => null,
        'three_ds_mode' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'name' => false,
        'active' => false,
        'account_status' => false,
        'parent_company_id' => true,
        'onboarding_status' => false,
        'documents' => false,
        'created_at' => false,
        'object' => false,
        'three_ds_enabled' => false,
        'three_ds_mode' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'active' => 'active',
        'account_status' => 'account_status',
        'parent_company_id' => 'parent_company_id',
        'onboarding_status' => 'onboarding_status',
        'documents' => 'documents',
        'created_at' => 'created_at',
        'object' => 'object',
        'three_ds_enabled' => 'three_ds_enabled',
        'three_ds_mode' => 'three_ds_mode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'active' => 'setActive',
        'account_status' => 'setAccountStatus',
        'parent_company_id' => 'setParentCompanyId',
        'onboarding_status' => 'setOnboardingStatus',
        'documents' => 'setDocuments',
        'created_at' => 'setCreatedAt',
        'object' => 'setObject',
        'three_ds_enabled' => 'setThreeDsEnabled',
        'three_ds_mode' => 'setThreeDsMode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'active' => 'getActive',
        'account_status' => 'getAccountStatus',
        'parent_company_id' => 'getParentCompanyId',
        'onboarding_status' => 'getOnboardingStatus',
        'documents' => 'getDocuments',
        'created_at' => 'getCreatedAt',
        'object' => 'getObject',
        'three_ds_enabled' => 'getThreeDsEnabled',
        'three_ds_mode' => 'getThreeDsMode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const THREE_DS_MODE_SMART = 'smart';
    public const THREE_DS_MODE_STRICT = 'strict';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getThreeDsModeAllowableValues()
    {
        return [
            self::THREE_DS_MODE_SMART,
            self::THREE_DS_MODE_STRICT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('account_status', $data ?? [], null);
        $this->setIfExists('parent_company_id', $data ?? [], null);
        $this->setIfExists('onboarding_status', $data ?? [], null);
        $this->setIfExists('documents', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('object', $data ?? [], null);
        $this->setIfExists('three_ds_enabled', $data ?? [], null);
        $this->setIfExists('three_ds_mode', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['active'] === null) {
            $invalidProperties[] = "'active' can't be null";
        }
        if ($this->container['account_status'] === null) {
            $invalidProperties[] = "'account_status' can't be null";
        }
        if ($this->container['onboarding_status'] === null) {
            $invalidProperties[] = "'onboarding_status' can't be null";
        }
        if ($this->container['documents'] === null) {
            $invalidProperties[] = "'documents' can't be null";
        }
        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['object'] === null) {
            $invalidProperties[] = "'object' can't be null";
        }
        $allowedValues = $this->getThreeDsModeAllowableValues();
        if (!is_null($this->container['three_ds_mode']) && !in_array($this->container['three_ds_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'three_ds_mode', must be one of '%s'",
                $this->container['three_ds_mode'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The unique identifier for the company.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the company.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool $active Indicates if the company is active.
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets account_status
     *
     * @return string
     */
    public function getAccountStatus()
    {
        return $this->container['account_status'];
    }

    /**
     * Sets account_status
     *
     * @param string $account_status The current status of the company's account.
     *
     * @return self
     */
    public function setAccountStatus($account_status)
    {
        if (is_null($account_status)) {
            throw new \InvalidArgumentException('non-nullable account_status cannot be null');
        }
        $this->container['account_status'] = $account_status;

        return $this;
    }

    /**
     * Gets parent_company_id
     *
     * @return string|null
     */
    public function getParentCompanyId()
    {
        return $this->container['parent_company_id'];
    }

    /**
     * Sets parent_company_id
     *
     * @param string|null $parent_company_id The identifier of the parent company, if any.
     *
     * @return self
     */
    public function setParentCompanyId($parent_company_id)
    {
        if (is_null($parent_company_id)) {
            array_push($this->openAPINullablesSetToNull, 'parent_company_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('parent_company_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['parent_company_id'] = $parent_company_id;

        return $this;
    }

    /**
     * Gets onboarding_status
     *
     * @return string
     */
    public function getOnboardingStatus()
    {
        return $this->container['onboarding_status'];
    }

    /**
     * Sets onboarding_status
     *
     * @param string $onboarding_status The current status of the company's onboarding process.
     *
     * @return self
     */
    public function setOnboardingStatus($onboarding_status)
    {
        if (is_null($onboarding_status)) {
            throw new \InvalidArgumentException('non-nullable onboarding_status cannot be null');
        }
        $this->container['onboarding_status'] = $onboarding_status;

        return $this;
    }

    /**
     * Gets documents
     *
     * @return \Conekta\Model\CompanyResponseDocumentsInner[]
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     *
     * @param \Conekta\Model\CompanyResponseDocumentsInner[] $documents A list of documents related to the company.
     *
     * @return self
     */
    public function setDocuments($documents)
    {
        if (is_null($documents)) {
            throw new \InvalidArgumentException('non-nullable documents cannot be null');
        }
        $this->container['documents'] = $documents;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return int
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param int $created_at Timestamp of when the company was created.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets object
     *
     * @return string
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     *
     * @param string $object The type of object, typically \"company\".
     *
     * @return self
     */
    public function setObject($object)
    {
        if (is_null($object)) {
            throw new \InvalidArgumentException('non-nullable object cannot be null');
        }
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets three_ds_enabled
     *
     * @return bool|null
     */
    public function getThreeDsEnabled()
    {
        return $this->container['three_ds_enabled'];
    }

    /**
     * Sets three_ds_enabled
     *
     * @param bool|null $three_ds_enabled Indicates if 3DS authentication is enabled for the company.
     *
     * @return self
     */
    public function setThreeDsEnabled($three_ds_enabled)
    {
        if (is_null($three_ds_enabled)) {
            throw new \InvalidArgumentException('non-nullable three_ds_enabled cannot be null');
        }
        $this->container['three_ds_enabled'] = $three_ds_enabled;

        return $this;
    }

    /**
     * Gets three_ds_mode
     *
     * @return string|null
     */
    public function getThreeDsMode()
    {
        return $this->container['three_ds_mode'];
    }

    /**
     * Sets three_ds_mode
     *
     * @param string|null $three_ds_mode The 3DS mode for the company, either 'smart' or 'strict'. This property is only applicable when three_ds_enabled is true. When three_ds_enabled is false, this field will be null.
     *
     * @return self
     */
    public function setThreeDsMode($three_ds_mode)
    {
        if (is_null($three_ds_mode)) {
            array_push($this->openAPINullablesSetToNull, 'three_ds_mode');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('three_ds_mode', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getThreeDsModeAllowableValues();
        if (!is_null($three_ds_mode) && !in_array($three_ds_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'three_ds_mode', must be one of '%s'",
                    $three_ds_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['three_ds_mode'] = $three_ds_mode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


