<?php
/**
 * CheckoutRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * CheckoutRequest Class Doc Comment
 *
 * @category Class
 * @description [Checkout](https://developers.conekta.com/v2.2.0/reference/payment-link) details
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CheckoutRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'checkout_request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'allowed_payment_methods' => 'string[]',
        'plan_ids' => 'string[]',
        'expires_at' => 'int',
        'failure_url' => 'string',
        'monthly_installments_enabled' => 'bool',
        'monthly_installments_options' => 'int[]',
        'max_failed_retries' => 'int',
        'name' => 'string',
        'on_demand_enabled' => 'bool',
        'redirection_time' => 'int',
        'success_url' => 'string',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'allowed_payment_methods' => null,
        'plan_ids' => null,
        'expires_at' => 'int64',
        'failure_url' => null,
        'monthly_installments_enabled' => null,
        'monthly_installments_options' => 'int8',
        'max_failed_retries' => 'int8',
        'name' => null,
        'on_demand_enabled' => null,
        'redirection_time' => 'int8',
        'success_url' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'allowed_payment_methods' => false,
        'plan_ids' => false,
        'expires_at' => false,
        'failure_url' => false,
        'monthly_installments_enabled' => false,
        'monthly_installments_options' => false,
        'max_failed_retries' => false,
        'name' => false,
        'on_demand_enabled' => false,
        'redirection_time' => false,
        'success_url' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allowed_payment_methods' => 'allowed_payment_methods',
        'plan_ids' => 'plan_ids',
        'expires_at' => 'expires_at',
        'failure_url' => 'failure_url',
        'monthly_installments_enabled' => 'monthly_installments_enabled',
        'monthly_installments_options' => 'monthly_installments_options',
        'max_failed_retries' => 'max_failed_retries',
        'name' => 'name',
        'on_demand_enabled' => 'on_demand_enabled',
        'redirection_time' => 'redirection_time',
        'success_url' => 'success_url',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allowed_payment_methods' => 'setAllowedPaymentMethods',
        'plan_ids' => 'setPlanIds',
        'expires_at' => 'setExpiresAt',
        'failure_url' => 'setFailureUrl',
        'monthly_installments_enabled' => 'setMonthlyInstallmentsEnabled',
        'monthly_installments_options' => 'setMonthlyInstallmentsOptions',
        'max_failed_retries' => 'setMaxFailedRetries',
        'name' => 'setName',
        'on_demand_enabled' => 'setOnDemandEnabled',
        'redirection_time' => 'setRedirectionTime',
        'success_url' => 'setSuccessUrl',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allowed_payment_methods' => 'getAllowedPaymentMethods',
        'plan_ids' => 'getPlanIds',
        'expires_at' => 'getExpiresAt',
        'failure_url' => 'getFailureUrl',
        'monthly_installments_enabled' => 'getMonthlyInstallmentsEnabled',
        'monthly_installments_options' => 'getMonthlyInstallmentsOptions',
        'max_failed_retries' => 'getMaxFailedRetries',
        'name' => 'getName',
        'on_demand_enabled' => 'getOnDemandEnabled',
        'redirection_time' => 'getRedirectionTime',
        'success_url' => 'getSuccessUrl',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ALLOWED_PAYMENT_METHODS_CASH = 'cash';
    public const ALLOWED_PAYMENT_METHODS_CARD = 'card';
    public const ALLOWED_PAYMENT_METHODS_BANK_TRANSFER = 'bank_transfer';
    public const ALLOWED_PAYMENT_METHODS_BNPL = 'bnpl';
    public const ALLOWED_PAYMENT_METHODS_PAY_BY_BANK = 'pay_by_bank';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAllowedPaymentMethodsAllowableValues()
    {
        return [
            self::ALLOWED_PAYMENT_METHODS_CASH,
            self::ALLOWED_PAYMENT_METHODS_CARD,
            self::ALLOWED_PAYMENT_METHODS_BANK_TRANSFER,
            self::ALLOWED_PAYMENT_METHODS_BNPL,
            self::ALLOWED_PAYMENT_METHODS_PAY_BY_BANK,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('allowed_payment_methods', $data ?? [], null);
        $this->setIfExists('plan_ids', $data ?? [], null);
        $this->setIfExists('expires_at', $data ?? [], null);
        $this->setIfExists('failure_url', $data ?? [], null);
        $this->setIfExists('monthly_installments_enabled', $data ?? [], null);
        $this->setIfExists('monthly_installments_options', $data ?? [], null);
        $this->setIfExists('max_failed_retries', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('on_demand_enabled', $data ?? [], null);
        $this->setIfExists('redirection_time', $data ?? [], null);
        $this->setIfExists('success_url', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['allowed_payment_methods'] === null) {
            $invalidProperties[] = "'allowed_payment_methods' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allowed_payment_methods
     *
     * @return string[]
     */
    public function getAllowedPaymentMethods()
    {
        return $this->container['allowed_payment_methods'];
    }

    /**
     * Sets allowed_payment_methods
     *
     * @param string[] $allowed_payment_methods Are the payment methods available for this link. For subscriptions, only 'card' is allowed due to the recurring nature of the payments.
     *
     * @return self
     */
    public function setAllowedPaymentMethods($allowed_payment_methods)
    {
        if (is_null($allowed_payment_methods)) {
            throw new \InvalidArgumentException('non-nullable allowed_payment_methods cannot be null');
        }
        $allowedValues = $this->getAllowedPaymentMethodsAllowableValues();
        if (array_diff($allowed_payment_methods, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'allowed_payment_methods', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['allowed_payment_methods'] = $allowed_payment_methods;

        return $this;
    }

    /**
     * Gets plan_ids
     *
     * @return string[]|null
     */
    public function getPlanIds()
    {
        return $this->container['plan_ids'];
    }

    /**
     * Sets plan_ids
     *
     * @param string[]|null $plan_ids List of plan IDs that will be available for subscription. This field is required for subscription payments.
     *
     * @return self
     */
    public function setPlanIds($plan_ids)
    {
        if (is_null($plan_ids)) {
            throw new \InvalidArgumentException('non-nullable plan_ids cannot be null');
        }
        $this->container['plan_ids'] = $plan_ids;

        return $this;
    }

    /**
     * Gets expires_at
     *
     * @return int|null
     */
    public function getExpiresAt()
    {
        return $this->container['expires_at'];
    }

    /**
     * Sets expires_at
     *
     * @param int|null $expires_at Unix timestamp of checkout expiration
     *
     * @return self
     */
    public function setExpiresAt($expires_at)
    {
        if (is_null($expires_at)) {
            throw new \InvalidArgumentException('non-nullable expires_at cannot be null');
        }
        $this->container['expires_at'] = $expires_at;

        return $this;
    }

    /**
     * Gets failure_url
     *
     * @return string|null
     */
    public function getFailureUrl()
    {
        return $this->container['failure_url'];
    }

    /**
     * Sets failure_url
     *
     * @param string|null $failure_url Redirection url back to the site in case of failed payment, applies only to HostedPayment.
     *
     * @return self
     */
    public function setFailureUrl($failure_url)
    {
        if (is_null($failure_url)) {
            throw new \InvalidArgumentException('non-nullable failure_url cannot be null');
        }
        $this->container['failure_url'] = $failure_url;

        return $this;
    }

    /**
     * Gets monthly_installments_enabled
     *
     * @return bool|null
     */
    public function getMonthlyInstallmentsEnabled()
    {
        return $this->container['monthly_installments_enabled'];
    }

    /**
     * Sets monthly_installments_enabled
     *
     * @param bool|null $monthly_installments_enabled monthly_installments_enabled
     *
     * @return self
     */
    public function setMonthlyInstallmentsEnabled($monthly_installments_enabled)
    {
        if (is_null($monthly_installments_enabled)) {
            throw new \InvalidArgumentException('non-nullable monthly_installments_enabled cannot be null');
        }
        $this->container['monthly_installments_enabled'] = $monthly_installments_enabled;

        return $this;
    }

    /**
     * Gets monthly_installments_options
     *
     * @return int[]|null
     */
    public function getMonthlyInstallmentsOptions()
    {
        return $this->container['monthly_installments_options'];
    }

    /**
     * Sets monthly_installments_options
     *
     * @param int[]|null $monthly_installments_options monthly_installments_options
     *
     * @return self
     */
    public function setMonthlyInstallmentsOptions($monthly_installments_options)
    {
        if (is_null($monthly_installments_options)) {
            throw new \InvalidArgumentException('non-nullable monthly_installments_options cannot be null');
        }
        $this->container['monthly_installments_options'] = $monthly_installments_options;

        return $this;
    }

    /**
     * Gets max_failed_retries
     *
     * @return int|null
     */
    public function getMaxFailedRetries()
    {
        return $this->container['max_failed_retries'];
    }

    /**
     * Sets max_failed_retries
     *
     * @param int|null $max_failed_retries Number of retries allowed before the checkout is marked as failed
     *
     * @return self
     */
    public function setMaxFailedRetries($max_failed_retries)
    {
        if (is_null($max_failed_retries)) {
            throw new \InvalidArgumentException('non-nullable max_failed_retries cannot be null');
        }
        $this->container['max_failed_retries'] = $max_failed_retries;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Reason for payment
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets on_demand_enabled
     *
     * @return bool|null
     */
    public function getOnDemandEnabled()
    {
        return $this->container['on_demand_enabled'];
    }

    /**
     * Sets on_demand_enabled
     *
     * @param bool|null $on_demand_enabled on_demand_enabled
     *
     * @return self
     */
    public function setOnDemandEnabled($on_demand_enabled)
    {
        if (is_null($on_demand_enabled)) {
            throw new \InvalidArgumentException('non-nullable on_demand_enabled cannot be null');
        }
        $this->container['on_demand_enabled'] = $on_demand_enabled;

        return $this;
    }

    /**
     * Gets redirection_time
     *
     * @return int|null
     */
    public function getRedirectionTime()
    {
        return $this->container['redirection_time'];
    }

    /**
     * Sets redirection_time
     *
     * @param int|null $redirection_time number of seconds to wait before redirecting to the success_url
     *
     * @return self
     */
    public function setRedirectionTime($redirection_time)
    {
        if (is_null($redirection_time)) {
            throw new \InvalidArgumentException('non-nullable redirection_time cannot be null');
        }
        $this->container['redirection_time'] = $redirection_time;

        return $this;
    }

    /**
     * Gets success_url
     *
     * @return string|null
     */
    public function getSuccessUrl()
    {
        return $this->container['success_url'];
    }

    /**
     * Sets success_url
     *
     * @param string|null $success_url Redirection url back to the site in case of successful payment, applies only to HostedPayment
     *
     * @return self
     */
    public function setSuccessUrl($success_url)
    {
        if (is_null($success_url)) {
            throw new \InvalidArgumentException('non-nullable success_url cannot be null');
        }
        $this->container['success_url'] = $success_url;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type This field represents the type of checkout
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


