<?php
/**
 * ChargeOrderResponsePaymentMethod
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Model;

use \ArrayAccess;
use \Conekta\ObjectSerializer;

/**
 * ChargeOrderResponsePaymentMethod Class Doc Comment
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ChargeOrderResponsePaymentMethod implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = 'object';

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'charge_order_response_payment_method';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'object' => 'string',
        'agreement' => 'string',
        'auth_code' => 'string',
        'cashier_id' => 'string',
        'reference' => 'string',
        'barcode_url' => 'string',
        'expires_at' => 'int',
        'product_type' => 'string',
        'service_name' => 'string',
        'store' => 'string',
        'store_name' => 'string',
        'customer_ip_address' => 'string',
        'account_type' => 'string',
        'brand' => 'string',
        'contract_id' => 'string',
        'country' => 'string',
        'exp_month' => 'string',
        'exp_year' => 'string',
        'fraud_indicators' => 'object[]',
        'issuer' => 'string',
        'last4' => 'string',
        'name' => 'string',
        'bank' => 'string',
        'clabe' => 'string',
        'description' => 'string',
        'executed_at' => 'string',
        'issuing_account_bank' => 'string',
        'issuing_account_number' => 'string',
        'issuing_account_holder_name' => 'string',
        'issuing_account_tax_id' => 'string',
        'payment_attempts' => 'object[]',
        'receiving_account_holder_name' => 'string',
        'receiving_account_number' => 'string',
        'receiving_account_bank' => 'string',
        'receiving_account_tax_id' => 'string',
        'reference_number' => 'string',
        'tracking_code' => 'string',
        'cancel_url' => 'string',
        'failure_url' => 'string',
        'redirect_url' => 'string',
        'success_url' => 'string',
        'deep_link' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'object' => null,
        'agreement' => null,
        'auth_code' => null,
        'cashier_id' => null,
        'reference' => null,
        'barcode_url' => null,
        'expires_at' => 'int64',
        'product_type' => null,
        'service_name' => null,
        'store' => null,
        'store_name' => null,
        'customer_ip_address' => null,
        'account_type' => null,
        'brand' => null,
        'contract_id' => null,
        'country' => null,
        'exp_month' => null,
        'exp_year' => null,
        'fraud_indicators' => null,
        'issuer' => null,
        'last4' => null,
        'name' => null,
        'bank' => null,
        'clabe' => null,
        'description' => null,
        'executed_at' => null,
        'issuing_account_bank' => null,
        'issuing_account_number' => null,
        'issuing_account_holder_name' => null,
        'issuing_account_tax_id' => null,
        'payment_attempts' => null,
        'receiving_account_holder_name' => null,
        'receiving_account_number' => null,
        'receiving_account_bank' => null,
        'receiving_account_tax_id' => null,
        'reference_number' => null,
        'tracking_code' => null,
        'cancel_url' => null,
        'failure_url' => null,
        'redirect_url' => null,
        'success_url' => null,
        'deep_link' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'type' => false,
        'object' => false,
        'agreement' => false,
        'auth_code' => false,
        'cashier_id' => true,
        'reference' => false,
        'barcode_url' => false,
        'expires_at' => false,
        'product_type' => false,
        'service_name' => false,
        'store' => true,
        'store_name' => false,
        'customer_ip_address' => false,
        'account_type' => false,
        'brand' => false,
        'contract_id' => false,
        'country' => false,
        'exp_month' => false,
        'exp_year' => false,
        'fraud_indicators' => false,
        'issuer' => false,
        'last4' => false,
        'name' => false,
        'bank' => false,
        'clabe' => false,
        'description' => true,
        'executed_at' => true,
        'issuing_account_bank' => true,
        'issuing_account_number' => true,
        'issuing_account_holder_name' => true,
        'issuing_account_tax_id' => true,
        'payment_attempts' => false,
        'receiving_account_holder_name' => true,
        'receiving_account_number' => false,
        'receiving_account_bank' => false,
        'receiving_account_tax_id' => true,
        'reference_number' => true,
        'tracking_code' => true,
        'cancel_url' => false,
        'failure_url' => false,
        'redirect_url' => false,
        'success_url' => false,
        'deep_link' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'type',
        'object' => 'object',
        'agreement' => 'agreement',
        'auth_code' => 'auth_code',
        'cashier_id' => 'cashier_id',
        'reference' => 'reference',
        'barcode_url' => 'barcode_url',
        'expires_at' => 'expires_at',
        'product_type' => 'product_type',
        'service_name' => 'service_name',
        'store' => 'store',
        'store_name' => 'store_name',
        'customer_ip_address' => 'customer_ip_address',
        'account_type' => 'account_type',
        'brand' => 'brand',
        'contract_id' => 'contract_id',
        'country' => 'country',
        'exp_month' => 'exp_month',
        'exp_year' => 'exp_year',
        'fraud_indicators' => 'fraud_indicators',
        'issuer' => 'issuer',
        'last4' => 'last4',
        'name' => 'name',
        'bank' => 'bank',
        'clabe' => 'clabe',
        'description' => 'description',
        'executed_at' => 'executed_at',
        'issuing_account_bank' => 'issuing_account_bank',
        'issuing_account_number' => 'issuing_account_number',
        'issuing_account_holder_name' => 'issuing_account_holder_name',
        'issuing_account_tax_id' => 'issuing_account_tax_id',
        'payment_attempts' => 'payment_attempts',
        'receiving_account_holder_name' => 'receiving_account_holder_name',
        'receiving_account_number' => 'receiving_account_number',
        'receiving_account_bank' => 'receiving_account_bank',
        'receiving_account_tax_id' => 'receiving_account_tax_id',
        'reference_number' => 'reference_number',
        'tracking_code' => 'tracking_code',
        'cancel_url' => 'cancel_url',
        'failure_url' => 'failure_url',
        'redirect_url' => 'redirect_url',
        'success_url' => 'success_url',
        'deep_link' => 'deep_link'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'object' => 'setObject',
        'agreement' => 'setAgreement',
        'auth_code' => 'setAuthCode',
        'cashier_id' => 'setCashierId',
        'reference' => 'setReference',
        'barcode_url' => 'setBarcodeUrl',
        'expires_at' => 'setExpiresAt',
        'product_type' => 'setProductType',
        'service_name' => 'setServiceName',
        'store' => 'setStore',
        'store_name' => 'setStoreName',
        'customer_ip_address' => 'setCustomerIpAddress',
        'account_type' => 'setAccountType',
        'brand' => 'setBrand',
        'contract_id' => 'setContractId',
        'country' => 'setCountry',
        'exp_month' => 'setExpMonth',
        'exp_year' => 'setExpYear',
        'fraud_indicators' => 'setFraudIndicators',
        'issuer' => 'setIssuer',
        'last4' => 'setLast4',
        'name' => 'setName',
        'bank' => 'setBank',
        'clabe' => 'setClabe',
        'description' => 'setDescription',
        'executed_at' => 'setExecutedAt',
        'issuing_account_bank' => 'setIssuingAccountBank',
        'issuing_account_number' => 'setIssuingAccountNumber',
        'issuing_account_holder_name' => 'setIssuingAccountHolderName',
        'issuing_account_tax_id' => 'setIssuingAccountTaxId',
        'payment_attempts' => 'setPaymentAttempts',
        'receiving_account_holder_name' => 'setReceivingAccountHolderName',
        'receiving_account_number' => 'setReceivingAccountNumber',
        'receiving_account_bank' => 'setReceivingAccountBank',
        'receiving_account_tax_id' => 'setReceivingAccountTaxId',
        'reference_number' => 'setReferenceNumber',
        'tracking_code' => 'setTrackingCode',
        'cancel_url' => 'setCancelUrl',
        'failure_url' => 'setFailureUrl',
        'redirect_url' => 'setRedirectUrl',
        'success_url' => 'setSuccessUrl',
        'deep_link' => 'setDeepLink'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'object' => 'getObject',
        'agreement' => 'getAgreement',
        'auth_code' => 'getAuthCode',
        'cashier_id' => 'getCashierId',
        'reference' => 'getReference',
        'barcode_url' => 'getBarcodeUrl',
        'expires_at' => 'getExpiresAt',
        'product_type' => 'getProductType',
        'service_name' => 'getServiceName',
        'store' => 'getStore',
        'store_name' => 'getStoreName',
        'customer_ip_address' => 'getCustomerIpAddress',
        'account_type' => 'getAccountType',
        'brand' => 'getBrand',
        'contract_id' => 'getContractId',
        'country' => 'getCountry',
        'exp_month' => 'getExpMonth',
        'exp_year' => 'getExpYear',
        'fraud_indicators' => 'getFraudIndicators',
        'issuer' => 'getIssuer',
        'last4' => 'getLast4',
        'name' => 'getName',
        'bank' => 'getBank',
        'clabe' => 'getClabe',
        'description' => 'getDescription',
        'executed_at' => 'getExecutedAt',
        'issuing_account_bank' => 'getIssuingAccountBank',
        'issuing_account_number' => 'getIssuingAccountNumber',
        'issuing_account_holder_name' => 'getIssuingAccountHolderName',
        'issuing_account_tax_id' => 'getIssuingAccountTaxId',
        'payment_attempts' => 'getPaymentAttempts',
        'receiving_account_holder_name' => 'getReceivingAccountHolderName',
        'receiving_account_number' => 'getReceivingAccountNumber',
        'receiving_account_bank' => 'getReceivingAccountBank',
        'receiving_account_tax_id' => 'getReceivingAccountTaxId',
        'reference_number' => 'getReferenceNumber',
        'tracking_code' => 'getTrackingCode',
        'cancel_url' => 'getCancelUrl',
        'failure_url' => 'getFailureUrl',
        'redirect_url' => 'getRedirectUrl',
        'success_url' => 'getSuccessUrl',
        'deep_link' => 'getDeepLink'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('object', $data ?? [], null);
        $this->setIfExists('agreement', $data ?? [], null);
        $this->setIfExists('auth_code', $data ?? [], null);
        $this->setIfExists('cashier_id', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('barcode_url', $data ?? [], null);
        $this->setIfExists('expires_at', $data ?? [], null);
        $this->setIfExists('product_type', $data ?? [], null);
        $this->setIfExists('service_name', $data ?? [], null);
        $this->setIfExists('store', $data ?? [], null);
        $this->setIfExists('store_name', $data ?? [], null);
        $this->setIfExists('customer_ip_address', $data ?? [], null);
        $this->setIfExists('account_type', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('contract_id', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('exp_month', $data ?? [], null);
        $this->setIfExists('exp_year', $data ?? [], null);
        $this->setIfExists('fraud_indicators', $data ?? [], null);
        $this->setIfExists('issuer', $data ?? [], null);
        $this->setIfExists('last4', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('bank', $data ?? [], null);
        $this->setIfExists('clabe', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('executed_at', $data ?? [], null);
        $this->setIfExists('issuing_account_bank', $data ?? [], null);
        $this->setIfExists('issuing_account_number', $data ?? [], null);
        $this->setIfExists('issuing_account_holder_name', $data ?? [], null);
        $this->setIfExists('issuing_account_tax_id', $data ?? [], null);
        $this->setIfExists('payment_attempts', $data ?? [], null);
        $this->setIfExists('receiving_account_holder_name', $data ?? [], null);
        $this->setIfExists('receiving_account_number', $data ?? [], null);
        $this->setIfExists('receiving_account_bank', $data ?? [], null);
        $this->setIfExists('receiving_account_tax_id', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('tracking_code', $data ?? [], null);
        $this->setIfExists('cancel_url', $data ?? [], null);
        $this->setIfExists('failure_url', $data ?? [], null);
        $this->setIfExists('redirect_url', $data ?? [], null);
        $this->setIfExists('success_url', $data ?? [], null);
        $this->setIfExists('deep_link', $data ?? [], null);

        // Initialize discriminator property with the model name.
        $this->container['object'] = static::$openAPIModelName;
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['object'] === null) {
            $invalidProperties[] = "'object' can't be null";
        }
        if ($this->container['reference'] === null) {
            $invalidProperties[] = "'reference' can't be null";
        }
        if ($this->container['expires_at'] === null) {
            $invalidProperties[] = "'expires_at' can't be null";
        }
        if (($this->container['expires_at'] <= 0)) {
            $invalidProperties[] = "invalid value for 'expires_at', must be bigger than 0.";
        }

        if ($this->container['product_type'] === null) {
            $invalidProperties[] = "'product_type' can't be null";
        }
        if ($this->container['redirect_url'] === null) {
            $invalidProperties[] = "'redirect_url' can't be null";
        }
        if ($this->container['deep_link'] === null) {
            $invalidProperties[] = "'deep_link' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets object
     *
     * @return string
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     *
     * @param string $object object
     *
     * @return self
     */
    public function setObject($object)
    {
        if (is_null($object)) {
            throw new \InvalidArgumentException('non-nullable object cannot be null');
        }
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets agreement
     *
     * @return string|null
     */
    public function getAgreement()
    {
        return $this->container['agreement'];
    }

    /**
     * Sets agreement
     *
     * @param string|null $agreement Agreement ID
     *
     * @return self
     */
    public function setAgreement($agreement)
    {
        if (is_null($agreement)) {
            throw new \InvalidArgumentException('non-nullable agreement cannot be null');
        }
        $this->container['agreement'] = $agreement;

        return $this;
    }

    /**
     * Gets auth_code
     *
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->container['auth_code'];
    }

    /**
     * Sets auth_code
     *
     * @param string|null $auth_code auth_code
     *
     * @return self
     */
    public function setAuthCode($auth_code)
    {
        if (is_null($auth_code)) {
            throw new \InvalidArgumentException('non-nullable auth_code cannot be null');
        }
        $this->container['auth_code'] = $auth_code;

        return $this;
    }

    /**
     * Gets cashier_id
     *
     * @return string|null
     */
    public function getCashierId()
    {
        return $this->container['cashier_id'];
    }

    /**
     * Sets cashier_id
     *
     * @param string|null $cashier_id cashier_id
     *
     * @return self
     */
    public function setCashierId($cashier_id)
    {
        if (is_null($cashier_id)) {
            array_push($this->openAPINullablesSetToNull, 'cashier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cashier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cashier_id'] = $cashier_id;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string $reference Reference for the payment
     *
     * @return self
     */
    public function setReference($reference)
    {
        if (is_null($reference)) {
            throw new \InvalidArgumentException('non-nullable reference cannot be null');
        }
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets barcode_url
     *
     * @return string|null
     */
    public function getBarcodeUrl()
    {
        return $this->container['barcode_url'];
    }

    /**
     * Sets barcode_url
     *
     * @param string|null $barcode_url barcode_url
     *
     * @return self
     */
    public function setBarcodeUrl($barcode_url)
    {
        if (is_null($barcode_url)) {
            throw new \InvalidArgumentException('non-nullable barcode_url cannot be null');
        }
        $this->container['barcode_url'] = $barcode_url;

        return $this;
    }

    /**
     * Gets expires_at
     *
     * @return int
     */
    public function getExpiresAt()
    {
        return $this->container['expires_at'];
    }

    /**
     * Sets expires_at
     *
     * @param int $expires_at Expiration date of the charge
     *
     * @return self
     */
    public function setExpiresAt($expires_at)
    {
        if (is_null($expires_at)) {
            throw new \InvalidArgumentException('non-nullable expires_at cannot be null');
        }

        if (($expires_at <= 0)) {
            throw new \InvalidArgumentException('invalid value for $expires_at when calling ChargeOrderResponsePaymentMethod., must be bigger than 0.');
        }

        $this->container['expires_at'] = $expires_at;

        return $this;
    }

    /**
     * Gets product_type
     *
     * @return string
     */
    public function getProductType()
    {
        return $this->container['product_type'];
    }

    /**
     * Sets product_type
     *
     * @param string $product_type Product type of the charge
     *
     * @return self
     */
    public function setProductType($product_type)
    {
        if (is_null($product_type)) {
            throw new \InvalidArgumentException('non-nullable product_type cannot be null');
        }
        $this->container['product_type'] = $product_type;

        return $this;
    }

    /**
     * Gets service_name
     *
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->container['service_name'];
    }

    /**
     * Sets service_name
     *
     * @param string|null $service_name service_name
     *
     * @return self
     */
    public function setServiceName($service_name)
    {
        if (is_null($service_name)) {
            throw new \InvalidArgumentException('non-nullable service_name cannot be null');
        }
        $this->container['service_name'] = $service_name;

        return $this;
    }

    /**
     * Gets store
     *
     * @return string|null
     */
    public function getStore()
    {
        return $this->container['store'];
    }

    /**
     * Sets store
     *
     * @param string|null $store store
     *
     * @return self
     */
    public function setStore($store)
    {
        if (is_null($store)) {
            array_push($this->openAPINullablesSetToNull, 'store');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('store', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['store'] = $store;

        return $this;
    }

    /**
     * Gets store_name
     *
     * @return string|null
     */
    public function getStoreName()
    {
        return $this->container['store_name'];
    }

    /**
     * Sets store_name
     *
     * @param string|null $store_name store_name
     *
     * @return self
     */
    public function setStoreName($store_name)
    {
        if (is_null($store_name)) {
            throw new \InvalidArgumentException('non-nullable store_name cannot be null');
        }
        $this->container['store_name'] = $store_name;

        return $this;
    }

    /**
     * Gets customer_ip_address
     *
     * @return string|null
     */
    public function getCustomerIpAddress()
    {
        return $this->container['customer_ip_address'];
    }

    /**
     * Sets customer_ip_address
     *
     * @param string|null $customer_ip_address customer_ip_address
     *
     * @return self
     */
    public function setCustomerIpAddress($customer_ip_address)
    {
        if (is_null($customer_ip_address)) {
            throw new \InvalidArgumentException('non-nullable customer_ip_address cannot be null');
        }
        $this->container['customer_ip_address'] = $customer_ip_address;

        return $this;
    }

    /**
     * Gets account_type
     *
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->container['account_type'];
    }

    /**
     * Sets account_type
     *
     * @param string|null $account_type Account type of the card
     *
     * @return self
     */
    public function setAccountType($account_type)
    {
        if (is_null($account_type)) {
            throw new \InvalidArgumentException('non-nullable account_type cannot be null');
        }
        $this->container['account_type'] = $account_type;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand Brand of the card
     *
     * @return self
     */
    public function setBrand($brand)
    {
        if (is_null($brand)) {
            throw new \InvalidArgumentException('non-nullable brand cannot be null');
        }
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets contract_id
     *
     * @return string|null
     */
    public function getContractId()
    {
        return $this->container['contract_id'];
    }

    /**
     * Sets contract_id
     *
     * @param string|null $contract_id Id sent for recurrent charges.
     *
     * @return self
     */
    public function setContractId($contract_id)
    {
        if (is_null($contract_id)) {
            throw new \InvalidArgumentException('non-nullable contract_id cannot be null');
        }
        $this->container['contract_id'] = $contract_id;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country Country of the card
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets exp_month
     *
     * @return string|null
     */
    public function getExpMonth()
    {
        return $this->container['exp_month'];
    }

    /**
     * Sets exp_month
     *
     * @param string|null $exp_month Expiration month of the card
     *
     * @return self
     */
    public function setExpMonth($exp_month)
    {
        if (is_null($exp_month)) {
            throw new \InvalidArgumentException('non-nullable exp_month cannot be null');
        }
        $this->container['exp_month'] = $exp_month;

        return $this;
    }

    /**
     * Gets exp_year
     *
     * @return string|null
     */
    public function getExpYear()
    {
        return $this->container['exp_year'];
    }

    /**
     * Sets exp_year
     *
     * @param string|null $exp_year Expiration year of the card
     *
     * @return self
     */
    public function setExpYear($exp_year)
    {
        if (is_null($exp_year)) {
            throw new \InvalidArgumentException('non-nullable exp_year cannot be null');
        }
        $this->container['exp_year'] = $exp_year;

        return $this;
    }

    /**
     * Gets fraud_indicators
     *
     * @return object[]|null
     */
    public function getFraudIndicators()
    {
        return $this->container['fraud_indicators'];
    }

    /**
     * Sets fraud_indicators
     *
     * @param object[]|null $fraud_indicators fraud_indicators
     *
     * @return self
     */
    public function setFraudIndicators($fraud_indicators)
    {
        if (is_null($fraud_indicators)) {
            throw new \InvalidArgumentException('non-nullable fraud_indicators cannot be null');
        }
        $this->container['fraud_indicators'] = $fraud_indicators;

        return $this;
    }

    /**
     * Gets issuer
     *
     * @return string|null
     */
    public function getIssuer()
    {
        return $this->container['issuer'];
    }

    /**
     * Sets issuer
     *
     * @param string|null $issuer Issuer of the card
     *
     * @return self
     */
    public function setIssuer($issuer)
    {
        if (is_null($issuer)) {
            throw new \InvalidArgumentException('non-nullable issuer cannot be null');
        }
        $this->container['issuer'] = $issuer;

        return $this;
    }

    /**
     * Gets last4
     *
     * @return string|null
     */
    public function getLast4()
    {
        return $this->container['last4'];
    }

    /**
     * Sets last4
     *
     * @param string|null $last4 Last 4 digits of the card
     *
     * @return self
     */
    public function setLast4($last4)
    {
        if (is_null($last4)) {
            throw new \InvalidArgumentException('non-nullable last4 cannot be null');
        }
        $this->container['last4'] = $last4;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Name of the cardholder
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets bank
     *
     * @return string|null
     */
    public function getBank()
    {
        return $this->container['bank'];
    }

    /**
     * Sets bank
     *
     * @param string|null $bank bank
     *
     * @return self
     */
    public function setBank($bank)
    {
        if (is_null($bank)) {
            throw new \InvalidArgumentException('non-nullable bank cannot be null');
        }
        $this->container['bank'] = $bank;

        return $this;
    }

    /**
     * Gets clabe
     *
     * @return string|null
     */
    public function getClabe()
    {
        return $this->container['clabe'];
    }

    /**
     * Sets clabe
     *
     * @param string|null $clabe clabe
     *
     * @return self
     */
    public function setClabe($clabe)
    {
        if (is_null($clabe)) {
            throw new \InvalidArgumentException('non-nullable clabe cannot be null');
        }
        $this->container['clabe'] = $clabe;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets executed_at
     *
     * @return string|null
     */
    public function getExecutedAt()
    {
        return $this->container['executed_at'];
    }

    /**
     * Sets executed_at
     *
     * @param string|null $executed_at executed_at
     *
     * @return self
     */
    public function setExecutedAt($executed_at)
    {
        if (is_null($executed_at)) {
            array_push($this->openAPINullablesSetToNull, 'executed_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('executed_at', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['executed_at'] = $executed_at;

        return $this;
    }

    /**
     * Gets issuing_account_bank
     *
     * @return string|null
     */
    public function getIssuingAccountBank()
    {
        return $this->container['issuing_account_bank'];
    }

    /**
     * Sets issuing_account_bank
     *
     * @param string|null $issuing_account_bank issuing_account_bank
     *
     * @return self
     */
    public function setIssuingAccountBank($issuing_account_bank)
    {
        if (is_null($issuing_account_bank)) {
            array_push($this->openAPINullablesSetToNull, 'issuing_account_bank');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('issuing_account_bank', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['issuing_account_bank'] = $issuing_account_bank;

        return $this;
    }

    /**
     * Gets issuing_account_number
     *
     * @return string|null
     */
    public function getIssuingAccountNumber()
    {
        return $this->container['issuing_account_number'];
    }

    /**
     * Sets issuing_account_number
     *
     * @param string|null $issuing_account_number issuing_account_number
     *
     * @return self
     */
    public function setIssuingAccountNumber($issuing_account_number)
    {
        if (is_null($issuing_account_number)) {
            array_push($this->openAPINullablesSetToNull, 'issuing_account_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('issuing_account_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['issuing_account_number'] = $issuing_account_number;

        return $this;
    }

    /**
     * Gets issuing_account_holder_name
     *
     * @return string|null
     */
    public function getIssuingAccountHolderName()
    {
        return $this->container['issuing_account_holder_name'];
    }

    /**
     * Sets issuing_account_holder_name
     *
     * @param string|null $issuing_account_holder_name issuing_account_holder_name
     *
     * @return self
     */
    public function setIssuingAccountHolderName($issuing_account_holder_name)
    {
        if (is_null($issuing_account_holder_name)) {
            array_push($this->openAPINullablesSetToNull, 'issuing_account_holder_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('issuing_account_holder_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['issuing_account_holder_name'] = $issuing_account_holder_name;

        return $this;
    }

    /**
     * Gets issuing_account_tax_id
     *
     * @return string|null
     */
    public function getIssuingAccountTaxId()
    {
        return $this->container['issuing_account_tax_id'];
    }

    /**
     * Sets issuing_account_tax_id
     *
     * @param string|null $issuing_account_tax_id issuing_account_tax_id
     *
     * @return self
     */
    public function setIssuingAccountTaxId($issuing_account_tax_id)
    {
        if (is_null($issuing_account_tax_id)) {
            array_push($this->openAPINullablesSetToNull, 'issuing_account_tax_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('issuing_account_tax_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['issuing_account_tax_id'] = $issuing_account_tax_id;

        return $this;
    }

    /**
     * Gets payment_attempts
     *
     * @return object[]|null
     */
    public function getPaymentAttempts()
    {
        return $this->container['payment_attempts'];
    }

    /**
     * Sets payment_attempts
     *
     * @param object[]|null $payment_attempts payment_attempts
     *
     * @return self
     */
    public function setPaymentAttempts($payment_attempts)
    {
        if (is_null($payment_attempts)) {
            throw new \InvalidArgumentException('non-nullable payment_attempts cannot be null');
        }
        $this->container['payment_attempts'] = $payment_attempts;

        return $this;
    }

    /**
     * Gets receiving_account_holder_name
     *
     * @return string|null
     */
    public function getReceivingAccountHolderName()
    {
        return $this->container['receiving_account_holder_name'];
    }

    /**
     * Sets receiving_account_holder_name
     *
     * @param string|null $receiving_account_holder_name receiving_account_holder_name
     *
     * @return self
     */
    public function setReceivingAccountHolderName($receiving_account_holder_name)
    {
        if (is_null($receiving_account_holder_name)) {
            array_push($this->openAPINullablesSetToNull, 'receiving_account_holder_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('receiving_account_holder_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['receiving_account_holder_name'] = $receiving_account_holder_name;

        return $this;
    }

    /**
     * Gets receiving_account_number
     *
     * @return string|null
     */
    public function getReceivingAccountNumber()
    {
        return $this->container['receiving_account_number'];
    }

    /**
     * Sets receiving_account_number
     *
     * @param string|null $receiving_account_number receiving_account_number
     *
     * @return self
     */
    public function setReceivingAccountNumber($receiving_account_number)
    {
        if (is_null($receiving_account_number)) {
            throw new \InvalidArgumentException('non-nullable receiving_account_number cannot be null');
        }
        $this->container['receiving_account_number'] = $receiving_account_number;

        return $this;
    }

    /**
     * Gets receiving_account_bank
     *
     * @return string|null
     */
    public function getReceivingAccountBank()
    {
        return $this->container['receiving_account_bank'];
    }

    /**
     * Sets receiving_account_bank
     *
     * @param string|null $receiving_account_bank receiving_account_bank
     *
     * @return self
     */
    public function setReceivingAccountBank($receiving_account_bank)
    {
        if (is_null($receiving_account_bank)) {
            throw new \InvalidArgumentException('non-nullable receiving_account_bank cannot be null');
        }
        $this->container['receiving_account_bank'] = $receiving_account_bank;

        return $this;
    }

    /**
     * Gets receiving_account_tax_id
     *
     * @return string|null
     */
    public function getReceivingAccountTaxId()
    {
        return $this->container['receiving_account_tax_id'];
    }

    /**
     * Sets receiving_account_tax_id
     *
     * @param string|null $receiving_account_tax_id receiving_account_tax_id
     *
     * @return self
     */
    public function setReceivingAccountTaxId($receiving_account_tax_id)
    {
        if (is_null($receiving_account_tax_id)) {
            array_push($this->openAPINullablesSetToNull, 'receiving_account_tax_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('receiving_account_tax_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['receiving_account_tax_id'] = $receiving_account_tax_id;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number reference_number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            array_push($this->openAPINullablesSetToNull, 'reference_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reference_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets tracking_code
     *
     * @return string|null
     */
    public function getTrackingCode()
    {
        return $this->container['tracking_code'];
    }

    /**
     * Sets tracking_code
     *
     * @param string|null $tracking_code tracking_code
     *
     * @return self
     */
    public function setTrackingCode($tracking_code)
    {
        if (is_null($tracking_code)) {
            array_push($this->openAPINullablesSetToNull, 'tracking_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tracking_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tracking_code'] = $tracking_code;

        return $this;
    }

    /**
     * Gets cancel_url
     *
     * @return string|null
     */
    public function getCancelUrl()
    {
        return $this->container['cancel_url'];
    }

    /**
     * Sets cancel_url
     *
     * @param string|null $cancel_url URL to redirect the customer after a canceled payment
     *
     * @return self
     */
    public function setCancelUrl($cancel_url)
    {
        if (is_null($cancel_url)) {
            throw new \InvalidArgumentException('non-nullable cancel_url cannot be null');
        }
        $this->container['cancel_url'] = $cancel_url;

        return $this;
    }

    /**
     * Gets failure_url
     *
     * @return string|null
     */
    public function getFailureUrl()
    {
        return $this->container['failure_url'];
    }

    /**
     * Sets failure_url
     *
     * @param string|null $failure_url URL to redirect the customer after a failed payment
     *
     * @return self
     */
    public function setFailureUrl($failure_url)
    {
        if (is_null($failure_url)) {
            throw new \InvalidArgumentException('non-nullable failure_url cannot be null');
        }
        $this->container['failure_url'] = $failure_url;

        return $this;
    }

    /**
     * Gets redirect_url
     *
     * @return string
     */
    public function getRedirectUrl()
    {
        return $this->container['redirect_url'];
    }

    /**
     * Sets redirect_url
     *
     * @param string $redirect_url URL to redirect the customer to complete the payment
     *
     * @return self
     */
    public function setRedirectUrl($redirect_url)
    {
        if (is_null($redirect_url)) {
            throw new \InvalidArgumentException('non-nullable redirect_url cannot be null');
        }
        $this->container['redirect_url'] = $redirect_url;

        return $this;
    }

    /**
     * Gets success_url
     *
     * @return string|null
     */
    public function getSuccessUrl()
    {
        return $this->container['success_url'];
    }

    /**
     * Sets success_url
     *
     * @param string|null $success_url URL to redirect the customer after a successful payment
     *
     * @return self
     */
    public function setSuccessUrl($success_url)
    {
        if (is_null($success_url)) {
            throw new \InvalidArgumentException('non-nullable success_url cannot be null');
        }
        $this->container['success_url'] = $success_url;

        return $this;
    }

    /**
     * Gets deep_link
     *
     * @return string
     */
    public function getDeepLink()
    {
        return $this->container['deep_link'];
    }

    /**
     * Sets deep_link
     *
     * @param string $deep_link Deep link for the payment, use for mobile apps/flows
     *
     * @return self
     */
    public function setDeepLink($deep_link)
    {
        if (is_null($deep_link)) {
            throw new \InvalidArgumentException('non-nullable deep_link cannot be null');
        }
        $this->container['deep_link'] = $deep_link;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


