<?php
/**
 * ShippingContactsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Conekta\ApiException;
use Conekta\Configuration;
use Conekta\HeaderSelector;
use Conekta\ObjectSerializer;

/**
 * ShippingContactsApi Class Doc Comment
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShippingContactsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createCustomerShippingContacts' => [
            'application/json',
        ],
        'deleteCustomerShippingContacts' => [
            'application/json',
        ],
        'updateCustomerShippingContacts' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCustomerShippingContacts
     *
     * Create a shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\CustomerShippingContacts $customer_shipping_contacts requested field for customer shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function createCustomerShippingContacts($id, $customer_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['createCustomerShippingContacts'][0])
    {
        list($response) = $this->createCustomerShippingContactsWithHttpInfo($id, $customer_shipping_contacts, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation createCustomerShippingContactsWithHttpInfo
     *
     * Create a shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\CustomerShippingContacts $customer_shipping_contacts requested field for customer shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerShippingContactsWithHttpInfo($id, $customer_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['createCustomerShippingContacts'][0])
    {
        $request = $this->createCustomerShippingContactsRequest($id, $customer_shipping_contacts, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\CustomerShippingContactsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\CustomerShippingContactsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\CustomerShippingContactsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\CustomerShippingContactsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCustomerShippingContactsAsync
     *
     * Create a shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\CustomerShippingContacts $customer_shipping_contacts requested field for customer shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerShippingContactsAsync($id, $customer_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['createCustomerShippingContacts'][0])
    {
        return $this->createCustomerShippingContactsAsyncWithHttpInfo($id, $customer_shipping_contacts, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerShippingContactsAsyncWithHttpInfo
     *
     * Create a shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\CustomerShippingContacts $customer_shipping_contacts requested field for customer shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerShippingContactsAsyncWithHttpInfo($id, $customer_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['createCustomerShippingContacts'][0])
    {
        $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
        $request = $this->createCustomerShippingContactsRequest($id, $customer_shipping_contacts, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomerShippingContacts'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\CustomerShippingContacts $customer_shipping_contacts requested field for customer shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomerShippingContactsRequest($id, $customer_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['createCustomerShippingContacts'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling createCustomerShippingContacts'
            );
        }

        // verify the required parameter 'customer_shipping_contacts' is set
        if ($customer_shipping_contacts === null || (is_array($customer_shipping_contacts) && count($customer_shipping_contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_shipping_contacts when calling createCustomerShippingContacts'
            );
        }




        $resourcePath = '/customers/{id}/shipping_contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (isset($customer_shipping_contacts)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer_shipping_contacts));
            } else {
                $httpBody = $customer_shipping_contacts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCustomerShippingContacts
     *
     * Delete shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function deleteCustomerShippingContacts($id, $shipping_contacts_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['deleteCustomerShippingContacts'][0])
    {
        list($response) = $this->deleteCustomerShippingContactsWithHttpInfo($id, $shipping_contacts_id, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteCustomerShippingContactsWithHttpInfo
     *
     * Delete shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomerShippingContactsWithHttpInfo($id, $shipping_contacts_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['deleteCustomerShippingContacts'][0])
    {
        $request = $this->deleteCustomerShippingContactsRequest($id, $shipping_contacts_id, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\CustomerShippingContactsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\CustomerShippingContactsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\CustomerShippingContactsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\CustomerShippingContactsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCustomerShippingContactsAsync
     *
     * Delete shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerShippingContactsAsync($id, $shipping_contacts_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['deleteCustomerShippingContacts'][0])
    {
        return $this->deleteCustomerShippingContactsAsyncWithHttpInfo($id, $shipping_contacts_id, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCustomerShippingContactsAsyncWithHttpInfo
     *
     * Delete shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerShippingContactsAsyncWithHttpInfo($id, $shipping_contacts_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['deleteCustomerShippingContacts'][0])
    {
        $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
        $request = $this->deleteCustomerShippingContactsRequest($id, $shipping_contacts_id, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCustomerShippingContacts'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCustomerShippingContactsRequest($id, $shipping_contacts_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['deleteCustomerShippingContacts'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteCustomerShippingContacts'
            );
        }

        // verify the required parameter 'shipping_contacts_id' is set
        if ($shipping_contacts_id === null || (is_array($shipping_contacts_id) && count($shipping_contacts_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_contacts_id when calling deleteCustomerShippingContacts'
            );
        }




        $resourcePath = '/customers/{id}/shipping_contacts/{shipping_contacts_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_contacts_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_contacts_id' . '}',
                ObjectSerializer::toPathValue($shipping_contacts_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCustomerShippingContacts
     *
     * Update shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  \Conekta\Model\CustomerUpdateShippingContacts $customer_update_shipping_contacts requested field for customer update shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function updateCustomerShippingContacts($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['updateCustomerShippingContacts'][0])
    {
        list($response) = $this->updateCustomerShippingContactsWithHttpInfo($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation updateCustomerShippingContactsWithHttpInfo
     *
     * Update shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  \Conekta\Model\CustomerUpdateShippingContacts $customer_update_shipping_contacts requested field for customer update shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\CustomerShippingContactsResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomerShippingContactsWithHttpInfo($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['updateCustomerShippingContacts'][0])
    {
        $request = $this->updateCustomerShippingContactsRequest($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\CustomerShippingContactsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\CustomerShippingContactsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\CustomerShippingContactsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\CustomerShippingContactsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateCustomerShippingContactsAsync
     *
     * Update shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  \Conekta\Model\CustomerUpdateShippingContacts $customer_update_shipping_contacts requested field for customer update shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerShippingContactsAsync($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['updateCustomerShippingContacts'][0])
    {
        return $this->updateCustomerShippingContactsAsyncWithHttpInfo($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCustomerShippingContactsAsyncWithHttpInfo
     *
     * Update shipping contacts
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  \Conekta\Model\CustomerUpdateShippingContacts $customer_update_shipping_contacts requested field for customer update shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerShippingContactsAsyncWithHttpInfo($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['updateCustomerShippingContacts'][0])
    {
        $returnType = '\Conekta\Model\CustomerShippingContactsResponse';
        $request = $this->updateCustomerShippingContactsRequest($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCustomerShippingContacts'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $shipping_contacts_id identifier (required)
     * @param  \Conekta\Model\CustomerUpdateShippingContacts $customer_update_shipping_contacts requested field for customer update shippings contacts (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomerShippingContacts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCustomerShippingContactsRequest($id, $shipping_contacts_id, $customer_update_shipping_contacts, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['updateCustomerShippingContacts'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateCustomerShippingContacts'
            );
        }

        // verify the required parameter 'shipping_contacts_id' is set
        if ($shipping_contacts_id === null || (is_array($shipping_contacts_id) && count($shipping_contacts_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_contacts_id when calling updateCustomerShippingContacts'
            );
        }

        // verify the required parameter 'customer_update_shipping_contacts' is set
        if ($customer_update_shipping_contacts === null || (is_array($customer_update_shipping_contacts) && count($customer_update_shipping_contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_update_shipping_contacts when calling updateCustomerShippingContacts'
            );
        }




        $resourcePath = '/customers/{id}/shipping_contacts/{shipping_contacts_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_contacts_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_contacts_id' . '}',
                ObjectSerializer::toPathValue($shipping_contacts_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (isset($customer_update_shipping_contacts)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer_update_shipping_contacts));
            } else {
                $httpBody = $customer_update_shipping_contacts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }
        $options[RequestOptions::SSL_KEY] = dirname(__DIR__, 1) . '/ssl_data/ca_bundle.crt';

        return $options;
    }
}
