<?php
/**
 * DiscountsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Conekta API
 *
 * Conekta sdk
 *
 * The version of the OpenAPI document: 2.2.0
 * Contact: engineering@conekta.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Conekta\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Conekta\ApiException;
use Conekta\Configuration;
use Conekta\HeaderSelector;
use Conekta\ObjectSerializer;

/**
 * DiscountsApi Class Doc Comment
 *
 * @category Class
 * @package  Conekta
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DiscountsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'ordersCreateDiscountLine' => [
            'application/json',
        ],
        'ordersDeleteDiscountLines' => [
            'application/json',
        ],
        'ordersGetDiscountLine' => [
            'application/json',
        ],
        'ordersGetDiscountLines' => [
            'application/json',
        ],
        'ordersUpdateDiscountLines' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation ordersCreateDiscountLine
     *
     * Create Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\OrderDiscountLinesRequest $order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersCreateDiscountLine'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function ordersCreateDiscountLine($id, $order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersCreateDiscountLine'][0])
    {
        list($response) = $this->ordersCreateDiscountLineWithHttpInfo($id, $order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation ordersCreateDiscountLineWithHttpInfo
     *
     * Create Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\OrderDiscountLinesRequest $order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersCreateDiscountLine'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersCreateDiscountLineWithHttpInfo($id, $order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersCreateDiscountLine'][0])
    {
        $request = $this->ordersCreateDiscountLineRequest($id, $order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\DiscountLinesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\DiscountLinesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\DiscountLinesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\DiscountLinesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\DiscountLinesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersCreateDiscountLineAsync
     *
     * Create Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\OrderDiscountLinesRequest $order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersCreateDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersCreateDiscountLineAsync($id, $order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersCreateDiscountLine'][0])
    {
        return $this->ordersCreateDiscountLineAsyncWithHttpInfo($id, $order_discount_lines_request, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersCreateDiscountLineAsyncWithHttpInfo
     *
     * Create Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\OrderDiscountLinesRequest $order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersCreateDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersCreateDiscountLineAsyncWithHttpInfo($id, $order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersCreateDiscountLine'][0])
    {
        $returnType = '\Conekta\Model\DiscountLinesResponse';
        $request = $this->ordersCreateDiscountLineRequest($id, $order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersCreateDiscountLine'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  \Conekta\Model\OrderDiscountLinesRequest $order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersCreateDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function ordersCreateDiscountLineRequest($id, $order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersCreateDiscountLine'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling ordersCreateDiscountLine'
            );
        }

        // verify the required parameter 'order_discount_lines_request' is set
        if ($order_discount_lines_request === null || (is_array($order_discount_lines_request) && count($order_discount_lines_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_discount_lines_request when calling ordersCreateDiscountLine'
            );
        }




        $resourcePath = '/orders/{id}/discount_lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (isset($order_discount_lines_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_discount_lines_request));
            } else {
                $httpBody = $order_discount_lines_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersDeleteDiscountLines
     *
     * Delete Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersDeleteDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function ordersDeleteDiscountLines($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersDeleteDiscountLines'][0])
    {
        list($response) = $this->ordersDeleteDiscountLinesWithHttpInfo($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation ordersDeleteDiscountLinesWithHttpInfo
     *
     * Delete Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersDeleteDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersDeleteDiscountLinesWithHttpInfo($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersDeleteDiscountLines'][0])
    {
        $request = $this->ordersDeleteDiscountLinesRequest($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\DiscountLinesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\DiscountLinesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\DiscountLinesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\DiscountLinesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\DiscountLinesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersDeleteDiscountLinesAsync
     *
     * Delete Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersDeleteDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersDeleteDiscountLinesAsync($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersDeleteDiscountLines'][0])
    {
        return $this->ordersDeleteDiscountLinesAsyncWithHttpInfo($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersDeleteDiscountLinesAsyncWithHttpInfo
     *
     * Delete Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersDeleteDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersDeleteDiscountLinesAsyncWithHttpInfo($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersDeleteDiscountLines'][0])
    {
        $returnType = '\Conekta\Model\DiscountLinesResponse';
        $request = $this->ordersDeleteDiscountLinesRequest($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersDeleteDiscountLines'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersDeleteDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function ordersDeleteDiscountLinesRequest($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersDeleteDiscountLines'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling ordersDeleteDiscountLines'
            );
        }

        // verify the required parameter 'discount_lines_id' is set
        if ($discount_lines_id === null || (is_array($discount_lines_id) && count($discount_lines_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $discount_lines_id when calling ordersDeleteDiscountLines'
            );
        }




        $resourcePath = '/orders/{id}/discount_lines/{discount_lines_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($discount_lines_id !== null) {
            $resourcePath = str_replace(
                '{' . 'discount_lines_id' . '}',
                ObjectSerializer::toPathValue($discount_lines_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersGetDiscountLine
     *
     * Get Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLine'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function ordersGetDiscountLine($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersGetDiscountLine'][0])
    {
        list($response) = $this->ordersGetDiscountLineWithHttpInfo($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation ordersGetDiscountLineWithHttpInfo
     *
     * Get Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLine'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersGetDiscountLineWithHttpInfo($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersGetDiscountLine'][0])
    {
        $request = $this->ordersGetDiscountLineRequest($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\DiscountLinesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\DiscountLinesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\DiscountLinesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\DiscountLinesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\DiscountLinesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersGetDiscountLineAsync
     *
     * Get Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersGetDiscountLineAsync($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersGetDiscountLine'][0])
    {
        return $this->ordersGetDiscountLineAsyncWithHttpInfo($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersGetDiscountLineAsyncWithHttpInfo
     *
     * Get Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersGetDiscountLineAsyncWithHttpInfo($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersGetDiscountLine'][0])
    {
        $returnType = '\Conekta\Model\DiscountLinesResponse';
        $request = $this->ordersGetDiscountLineRequest($id, $discount_lines_id, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersGetDiscountLine'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function ordersGetDiscountLineRequest($id, $discount_lines_id, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersGetDiscountLine'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling ordersGetDiscountLine'
            );
        }

        // verify the required parameter 'discount_lines_id' is set
        if ($discount_lines_id === null || (is_array($discount_lines_id) && count($discount_lines_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $discount_lines_id when calling ordersGetDiscountLine'
            );
        }




        $resourcePath = '/orders/{id}/discount_lines/{discount_lines_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($discount_lines_id !== null) {
            $resourcePath = str_replace(
                '{' . 'discount_lines_id' . '}',
                ObjectSerializer::toPathValue($discount_lines_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersGetDiscountLines
     *
     * Get a List of Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  int $limit The numbers of items to return, the maximum value is 250 (optional, default to 20)
     * @param  string $search General order search, e.g. by mail, reference etc. (optional)
     * @param  string $next next page (optional)
     * @param  string $previous previous page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\GetOrderDiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function ordersGetDiscountLines($id, $accept_language = 'es', $x_child_company_id = null, $limit = 20, $search = null, $next = null, $previous = null, string $contentType = self::contentTypes['ordersGetDiscountLines'][0])
    {
        list($response) = $this->ordersGetDiscountLinesWithHttpInfo($id, $accept_language, $x_child_company_id, $limit, $search, $next, $previous, $contentType);
        return $response;
    }

    /**
     * Operation ordersGetDiscountLinesWithHttpInfo
     *
     * Get a List of Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  int $limit The numbers of items to return, the maximum value is 250 (optional, default to 20)
     * @param  string $search General order search, e.g. by mail, reference etc. (optional)
     * @param  string $next next page (optional)
     * @param  string $previous previous page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\GetOrderDiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersGetDiscountLinesWithHttpInfo($id, $accept_language = 'es', $x_child_company_id = null, $limit = 20, $search = null, $next = null, $previous = null, string $contentType = self::contentTypes['ordersGetDiscountLines'][0])
    {
        $request = $this->ordersGetDiscountLinesRequest($id, $accept_language, $x_child_company_id, $limit, $search, $next, $previous, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\GetOrderDiscountLinesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\GetOrderDiscountLinesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\GetOrderDiscountLinesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\GetOrderDiscountLinesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\GetOrderDiscountLinesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersGetDiscountLinesAsync
     *
     * Get a List of Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  int $limit The numbers of items to return, the maximum value is 250 (optional, default to 20)
     * @param  string $search General order search, e.g. by mail, reference etc. (optional)
     * @param  string $next next page (optional)
     * @param  string $previous previous page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersGetDiscountLinesAsync($id, $accept_language = 'es', $x_child_company_id = null, $limit = 20, $search = null, $next = null, $previous = null, string $contentType = self::contentTypes['ordersGetDiscountLines'][0])
    {
        return $this->ordersGetDiscountLinesAsyncWithHttpInfo($id, $accept_language, $x_child_company_id, $limit, $search, $next, $previous, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersGetDiscountLinesAsyncWithHttpInfo
     *
     * Get a List of Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  int $limit The numbers of items to return, the maximum value is 250 (optional, default to 20)
     * @param  string $search General order search, e.g. by mail, reference etc. (optional)
     * @param  string $next next page (optional)
     * @param  string $previous previous page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersGetDiscountLinesAsyncWithHttpInfo($id, $accept_language = 'es', $x_child_company_id = null, $limit = 20, $search = null, $next = null, $previous = null, string $contentType = self::contentTypes['ordersGetDiscountLines'][0])
    {
        $returnType = '\Conekta\Model\GetOrderDiscountLinesResponse';
        $request = $this->ordersGetDiscountLinesRequest($id, $accept_language, $x_child_company_id, $limit, $search, $next, $previous, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersGetDiscountLines'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  int $limit The numbers of items to return, the maximum value is 250 (optional, default to 20)
     * @param  string $search General order search, e.g. by mail, reference etc. (optional)
     * @param  string $next next page (optional)
     * @param  string $previous previous page (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersGetDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function ordersGetDiscountLinesRequest($id, $accept_language = 'es', $x_child_company_id = null, $limit = 20, $search = null, $next = null, $previous = null, string $contentType = self::contentTypes['ordersGetDiscountLines'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling ordersGetDiscountLines'
            );
        }



        if ($limit !== null && $limit > 250) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling DiscountsApi.ordersGetDiscountLines, must be smaller than or equal to 250.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling DiscountsApi.ordersGetDiscountLines, must be bigger than or equal to 1.');
        }
        




        $resourcePath = '/orders/{id}/discount_lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $next,
            'next', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $previous,
            'previous', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersUpdateDiscountLines
     *
     * Update Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  \Conekta\Model\UpdateOrderDiscountLinesRequest $update_order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersUpdateDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error
     */
    public function ordersUpdateDiscountLines($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersUpdateDiscountLines'][0])
    {
        list($response) = $this->ordersUpdateDiscountLinesWithHttpInfo($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);
        return $response;
    }

    /**
     * Operation ordersUpdateDiscountLinesWithHttpInfo
     *
     * Update Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  \Conekta\Model\UpdateOrderDiscountLinesRequest $update_order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersUpdateDiscountLines'] to see the possible values for this operation
     *
     * @throws \Conekta\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Conekta\Model\DiscountLinesResponse|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error|\Conekta\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersUpdateDiscountLinesWithHttpInfo($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersUpdateDiscountLines'][0])
    {
        $request = $this->ordersUpdateDiscountLinesRequest($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Conekta\Model\DiscountLinesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\DiscountLinesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\DiscountLinesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Conekta\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Conekta\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Conekta\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Conekta\Model\DiscountLinesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\DiscountLinesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Conekta\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersUpdateDiscountLinesAsync
     *
     * Update Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  \Conekta\Model\UpdateOrderDiscountLinesRequest $update_order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersUpdateDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersUpdateDiscountLinesAsync($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersUpdateDiscountLines'][0])
    {
        return $this->ordersUpdateDiscountLinesAsyncWithHttpInfo($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language, $x_child_company_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersUpdateDiscountLinesAsyncWithHttpInfo
     *
     * Update Discount
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  \Conekta\Model\UpdateOrderDiscountLinesRequest $update_order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersUpdateDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function ordersUpdateDiscountLinesAsyncWithHttpInfo($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersUpdateDiscountLines'][0])
    {
        $returnType = '\Conekta\Model\DiscountLinesResponse';
        $request = $this->ordersUpdateDiscountLinesRequest($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language, $x_child_company_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersUpdateDiscountLines'
     *
     * @param  string $id Identifier of the resource (required)
     * @param  string $discount_lines_id discount line id identifier (required)
     * @param  \Conekta\Model\UpdateOrderDiscountLinesRequest $update_order_discount_lines_request requested field for a discount lines (required)
     * @param  string $accept_language Use for knowing which language to use (optional, default to 'es')
     * @param  string $x_child_company_id In the case of a holding company, the company id of the child company to which will process the request. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['ordersUpdateDiscountLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function ordersUpdateDiscountLinesRequest($id, $discount_lines_id, $update_order_discount_lines_request, $accept_language = 'es', $x_child_company_id = null, string $contentType = self::contentTypes['ordersUpdateDiscountLines'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling ordersUpdateDiscountLines'
            );
        }

        // verify the required parameter 'discount_lines_id' is set
        if ($discount_lines_id === null || (is_array($discount_lines_id) && count($discount_lines_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $discount_lines_id when calling ordersUpdateDiscountLines'
            );
        }

        // verify the required parameter 'update_order_discount_lines_request' is set
        if ($update_order_discount_lines_request === null || (is_array($update_order_discount_lines_request) && count($update_order_discount_lines_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_order_discount_lines_request when calling ordersUpdateDiscountLines'
            );
        }




        $resourcePath = '/orders/{id}/discount_lines/{discount_lines_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($accept_language !== null) {
            $headerParams['Accept-Language'] = ObjectSerializer::toHeaderValue($accept_language);
        }
        // header params
        if ($x_child_company_id !== null) {
            $headerParams['X-Child-Company-Id'] = ObjectSerializer::toHeaderValue($x_child_company_id);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($discount_lines_id !== null) {
            $resourcePath = str_replace(
                '{' . 'discount_lines_id' . '}',
                ObjectSerializer::toPathValue($discount_lines_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.conekta-v2.2.0+json', ],
            $contentType,
            $multipart
        );
        $headers = array_merge(
            $this->headerSelector->getConektaUserAgent(),
            $headers
        );

        // for model (json/xml)
        if (isset($update_order_discount_lines_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_order_discount_lines_request));
            } else {
                $httpBody = $update_order_discount_lines_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }
        $options[RequestOptions::SSL_KEY] = dirname(__DIR__, 1) . '/ssl_data/ca_bundle.crt';

        return $options;
    }
}
