import{loadWASM,createOnigScanner,createOnigString}from"vscode-oniguruma";import{INITIAL,Registry as Registry$1}from"vscode-textmate";const themes=["css-variables","dark-plus","dracula-soft","dracula","github-dark-dimmed","github-dark","github-light","light-plus","material-theme-darker","material-theme-lighter","material-theme-ocean","material-theme-palenight","material-theme","min-dark","min-light","monokai","nord","one-dark-pro","poimandres","rose-pine-dawn","rose-pine-moon","rose-pine","slack-dark","slack-ochin","solarized-dark","solarized-light","vitesse-black","vitesse-dark","vitesse-light"],languages=[{id:"abap",scopeName:"source.abap",path:"abap.tmLanguage.json",displayName:"ABAP",samplePath:"abap.sample"},{id:"actionscript-3",scopeName:"source.actionscript.3",path:"actionscript-3.tmLanguage.json",displayName:"ActionScript",samplePath:"actionscript-3.sample"},{id:"ada",scopeName:"source.ada",path:"ada.tmLanguage.json",displayName:"Ada",samplePath:"ada.sample"},{id:"apache",scopeName:"source.apacheconf",path:"apache.tmLanguage.json",displayName:"Apache Conf",samplePath:"apache.sample"},{id:"apex",scopeName:"source.apex",path:"apex.tmLanguage.json",displayName:"Apex",samplePath:"apex.sample"},{id:"apl",scopeName:"source.apl",path:"apl.tmLanguage.json",displayName:"APL",samplePath:"apl.sample",embeddedLangs:["html","xml","css","javascript","json"]},{id:"applescript",scopeName:"source.applescript",path:"applescript.tmLanguage.json",displayName:"AppleScript",samplePath:"applescript.sample"},{id:"ara",scopeName:"source.ara",path:"ara.tmLanguage.json",displayName:"Ara",samplePath:"ara.sample"},{id:"asm",scopeName:"source.asm.x86_64",path:"asm.tmLanguage.json",displayName:"Assembly",samplePath:"asm.sample"},{id:"astro",scopeName:"source.astro",path:"astro.tmLanguage.json",displayName:"Astro",samplePath:"astro.sample",embeddedLangs:["json","javascript","typescript","stylus","sass","css","scss","less","postcss","tsx"]},{id:"awk",scopeName:"source.awk",path:"awk.tmLanguage.json",displayName:"AWK",samplePath:"awk.sample"},{id:"ballerina",scopeName:"source.ballerina",path:"ballerina.tmLanguage.json",displayName:"Ballerina",samplePath:"ballerina.sample"},{id:"bat",scopeName:"source.batchfile",path:"bat.tmLanguage.json",displayName:"Batch",samplePath:"bat.sample",aliases:["batch"]},{id:"beancount",scopeName:"text.beancount",path:"beancount.tmLanguage.json",displayName:"Beancount",samplePath:"beancount.sample"},{id:"berry",scopeName:"source.berry",path:"berry.tmLanguage.json",displayName:"Berry",samplePath:"berry.sample",aliases:["be"]},{id:"bibtex",scopeName:"text.bibtex",path:"bibtex.tmLanguage.json",displayName:"BibTeX",samplePath:"bibtex.sample"},{id:"bicep",scopeName:"source.bicep",path:"bicep.tmLanguage.json",displayName:"Bicep",samplePath:"bicep.sample"},{id:"blade",scopeName:"text.html.php.blade",path:"blade.tmLanguage.json",displayName:"Blade",samplePath:"blade.sample",embeddedLangs:["html","xml","sql","javascript","json","css"]},{id:"c",scopeName:"source.c",path:"c.tmLanguage.json",displayName:"C",samplePath:"c.sample"},{id:"cadence",scopeName:"source.cadence",path:"cadence.tmLanguage.json",displayName:"Cadence",samplePath:"cadence.sample",aliases:["cdc"]},{id:"clarity",scopeName:"source.clar",path:"clarity.tmLanguage.json",displayName:"Clarity",samplePath:"clarity.sample"},{id:"clojure",scopeName:"source.clojure",path:"clojure.tmLanguage.json",displayName:"Clojure",samplePath:"clojure.sample",aliases:["clj"]},{id:"cmake",scopeName:"source.cmake",path:"cmake.tmLanguage.json",displayName:"CMake",samplePath:"cmake.sample"},{id:"cobol",scopeName:"source.cobol",path:"cobol.tmLanguage.json",displayName:"COBOL",samplePath:"cobol.sample",embeddedLangs:["sql","html","java"]},{id:"codeql",scopeName:"source.ql",path:"codeql.tmLanguage.json",displayName:"CodeQL",samplePath:"codeql.sample",aliases:["ql"]},{id:"coffee",scopeName:"source.coffee",path:"coffee.tmLanguage.json",displayName:"CoffeeScript",samplePath:"coffee.sample",embeddedLangs:["javascript"]},{id:"cpp",scopeName:"source.cpp",path:"cpp.tmLanguage.json",displayName:"C++",samplePath:"cpp.sample",aliases:["c++"],embeddedLangs:["glsl","sql"]},{id:"crystal",scopeName:"source.crystal",path:"crystal.tmLanguage.json",displayName:"Crystal",samplePath:"crystal.sample",embeddedLangs:["html","sql","css","c","javascript","shellscript"]},{id:"csharp",scopeName:"source.cs",path:"csharp.tmLanguage.json",displayName:"C#",samplePath:"csharp.sample",aliases:["c#","cs"]},{id:"css",scopeName:"source.css",path:"css.tmLanguage.json",displayName:"CSS",samplePath:"css.sample"},{id:"csv",scopeName:"text.csv",path:"csv.tmLanguage.json",displayName:"csv syntax",samplePath:"csv.sample"},{id:"cue",scopeName:"source.cue",path:"cue.tmLanguage.json",displayName:"CUE",samplePath:"cue.sample"},{id:"cypher",scopeName:"source.cypher",path:"cypher.tmLanguage.json",displayName:"Cypher",samplePath:"cypher.sample",aliases:["cql"]},{id:"d",scopeName:"source.d",path:"d.tmLanguage.json",displayName:"D",samplePath:"d.sample"},{id:"dart",scopeName:"source.dart",path:"dart.tmLanguage.json",displayName:"Dart",samplePath:"dart.sample"},{id:"dax",scopeName:"source.dax",path:"dax.tmLanguage.json",displayName:"DAX",samplePath:"dax.sample"},{id:"diff",scopeName:"source.diff",path:"diff.tmLanguage.json",displayName:"Diff",samplePath:"diff.sample"},{id:"docker",scopeName:"source.dockerfile",path:"docker.tmLanguage.json",displayName:"Docker",samplePath:"docker.sample",aliases:["dockerfile"]},{id:"dream-maker",scopeName:"source.dm",path:"dream-maker.tmLanguage.json",displayName:"Dream Maker",samplePath:"dream-maker.sample"},{id:"elixir",scopeName:"source.elixir",path:"elixir.tmLanguage.json",displayName:"Elixir",samplePath:"elixir.sample",embeddedLangs:["html"]},{id:"elm",scopeName:"source.elm",path:"elm.tmLanguage.json",displayName:"Elm",samplePath:"elm.sample",embeddedLangs:["glsl"]},{id:"erb",scopeName:"text.html.erb",path:"erb.tmLanguage.json",displayName:"ERB",samplePath:"erb.sample",embeddedLangs:["html","ruby"]},{id:"erlang",scopeName:"source.erlang",path:"erlang.tmLanguage.json",displayName:"Erlang",samplePath:"erlang.sample",aliases:["erl"]},{id:"fish",scopeName:"source.fish",path:"fish.tmLanguage.json",displayName:"Fish",samplePath:"fish.sample"},{id:"fsharp",scopeName:"source.fsharp",path:"fsharp.tmLanguage.json",displayName:"F#",samplePath:"fsharp.sample",aliases:["f#","fs"],embeddedLangs:["markdown"]},{id:"gdresource",scopeName:"source.gdresource",path:"gdresource.tmLanguage.json",displayName:"GDResource",samplePath:"gdresource.sample",embeddedLangs:["gdshader","gdscript"]},{id:"gdscript",scopeName:"source.gdscript",path:"gdscript.tmLanguage.json",displayName:"GDScript",samplePath:"gdscript.sample"},{id:"gdshader",scopeName:"source.gdshader",path:"gdshader.tmLanguage.json",displayName:"GDShader",samplePath:"gdshader.sample"},{id:"gherkin",scopeName:"text.gherkin.feature",path:"gherkin.tmLanguage.json",displayName:"Gherkin",samplePath:"gherkin.sample"},{id:"git-commit",scopeName:"text.git-commit",path:"git-commit.tmLanguage.json",displayName:"Git Commit Message",embeddedLangs:["diff"]},{id:"git-rebase",scopeName:"text.git-rebase",path:"git-rebase.tmLanguage.json",displayName:"Git Rebase Message",embeddedLangs:["shellscript"]},{id:"glimmer-js",scopeName:"source.gjs",path:"glimmer-js.tmLanguage.json",displayName:"Glimmer JS",aliases:["gjs"],embeddedLangs:["javascript","handlebars"]},{id:"glimmer-ts",scopeName:"source.gts",path:"glimmer-ts.tmLanguage.json",displayName:"Glimmer TS",aliases:["gts"],embeddedLangs:["typescript","handlebars"]},{id:"glsl",scopeName:"source.glsl",path:"glsl.tmLanguage.json",displayName:"GLSL",samplePath:"glsl.sample",embeddedLangs:["c"]},{id:"gnuplot",scopeName:"source.gnuplot",path:"gnuplot.tmLanguage.json",displayName:"Gnuplot",samplePath:"gnuplot.sample"},{id:"go",scopeName:"source.go",path:"go.tmLanguage.json",displayName:"Go",samplePath:"go.sample"},{id:"graphql",scopeName:"source.graphql",path:"graphql.tmLanguage.json",displayName:"GraphQL",samplePath:"graphql.sample",aliases:["gql"],embeddedLangs:["javascript","typescript","jsx","tsx"]},{id:"groovy",scopeName:"source.groovy",path:"groovy.tmLanguage.json",displayName:"Groovy",samplePath:"groovy.sample"},{id:"hack",scopeName:"source.hack",path:"hack.tmLanguage.json",displayName:"Hack",samplePath:"hack.sample",embeddedLangs:["html","sql"]},{id:"haml",scopeName:"text.haml",path:"haml.tmLanguage.json",displayName:"Ruby Haml",samplePath:"haml.sample",embeddedLangs:["ruby","javascript","sass","coffee","markdown","css"]},{id:"handlebars",scopeName:"text.html.handlebars",path:"handlebars.tmLanguage.json",displayName:"Handlebars",samplePath:"handlebars.sample",aliases:["hbs"],embeddedLangs:["html","css","javascript","yaml"]},{id:"haskell",scopeName:"source.haskell",path:"haskell.tmLanguage.json",displayName:"Haskell",samplePath:"haskell.sample",aliases:["hs"]},{id:"hcl",scopeName:"source.hcl",path:"hcl.tmLanguage.json",displayName:"HashiCorp HCL",samplePath:"hcl.sample"},{id:"hjson",scopeName:"source.hjson",path:"hjson.tmLanguage.json",displayName:"Hjson",samplePath:"hjson.sample"},{id:"hlsl",scopeName:"source.hlsl",path:"hlsl.tmLanguage.json",displayName:"HLSL",samplePath:"hlsl.sample"},{id:"html",scopeName:"text.html.basic",path:"html.tmLanguage.json",displayName:"HTML",samplePath:"html.sample",embeddedLangs:["javascript","css"]},{id:"http",scopeName:"source.http",path:"http.tmLanguage.json",displayName:"HTTP",samplePath:"http.sample",embeddedLangs:["shellscript","json","xml","graphql"]},{id:"imba",scopeName:"source.imba",path:"imba.tmLanguage.json",displayName:"Imba",samplePath:"imba.sample"},{id:"ini",scopeName:"source.ini",path:"ini.tmLanguage.json",displayName:"INI",samplePath:"ini.sample",aliases:["properties"]},{id:"java",scopeName:"source.java",path:"java.tmLanguage.json",displayName:"Java",samplePath:"java.sample"},{id:"javascript",scopeName:"source.js",path:"javascript.tmLanguage.json",displayName:"JavaScript",samplePath:"javascript.sample",aliases:["js"]},{id:"jinja-html",scopeName:"text.html.jinja",path:"jinja-html.tmLanguage.json",displayName:"Jinja",samplePath:"jinja-html.sample",embeddedLangs:["html"]},{id:"jison",scopeName:"source.jison",path:"jison.tmLanguage.json",displayName:"Jison",samplePath:"jison.sample",embeddedLangs:["javascript"]},{id:"json",scopeName:"source.json",path:"json.tmLanguage.json",displayName:"JSON",samplePath:"json.sample"},{id:"json5",scopeName:"source.json5",path:"json5.tmLanguage.json",displayName:"JSON5",samplePath:"json5.sample"},{id:"jsonc",scopeName:"source.json.comments",path:"jsonc.tmLanguage.json",displayName:"JSON with Comments",samplePath:"jsonc.sample"},{id:"jsonl",scopeName:"source.json.lines",path:"jsonl.tmLanguage.json",displayName:"JSON Lines",samplePath:"jsonl.sample"},{id:"jsonnet",scopeName:"source.jsonnet",path:"jsonnet.tmLanguage.json",displayName:"Jsonnet",samplePath:"jsonnet.sample"},{id:"jssm",scopeName:"source.jssm",path:"jssm.tmLanguage.json",displayName:"JSSM",samplePath:"jssm.sample",aliases:["fsl"]},{id:"jsx",scopeName:"source.js.jsx",path:"jsx.tmLanguage.json",displayName:"JSX",samplePath:"jsx.sample"},{id:"julia",scopeName:"source.julia",path:"julia.tmLanguage.json",displayName:"Julia",samplePath:"julia.sample",embeddedLangs:["cpp","python","javascript","r","sql"]},{id:"kotlin",scopeName:"source.kotlin",path:"kotlin.tmLanguage.json",displayName:"Kotlin",samplePath:"kotlin.sample",aliases:["kt","kts"]},{id:"kusto",scopeName:"source.kusto",path:"kusto.tmLanguage.json",displayName:"Kusto",samplePath:"kusto.sample",aliases:["kql"]},{id:"latex",scopeName:"text.tex.latex",path:"latex.tmLanguage.json",displayName:"LaTeX",samplePath:"latex.sample",embeddedLangs:["tex","css","haskell","html","xml","java","lua","julia","ruby","javascript","typescript","python","yaml","rust","scala","gnuplot"]},{id:"less",scopeName:"source.css.less",path:"less.tmLanguage.json",displayName:"Less",samplePath:"less.sample"},{id:"liquid",scopeName:"text.html.liquid",path:"liquid.tmLanguage.json",displayName:"Liquid",samplePath:"liquid.sample",embeddedLangs:["html","css","json","javascript"]},{id:"lisp",scopeName:"source.lisp",path:"lisp.tmLanguage.json",displayName:"Lisp",samplePath:"lisp.sample"},{id:"logo",scopeName:"source.logo",path:"logo.tmLanguage.json",displayName:"Logo",samplePath:"logo.sample"},{id:"lua",scopeName:"source.lua",path:"lua.tmLanguage.json",displayName:"Lua",samplePath:"lua.sample",embeddedLangs:["c"]},{id:"make",scopeName:"source.makefile",path:"make.tmLanguage.json",displayName:"Makefile",samplePath:"make.sample",aliases:["makefile"]},{id:"markdown",scopeName:"text.html.markdown",path:"markdown.tmLanguage.json",displayName:"Markdown",samplePath:"markdown.sample",aliases:["md"],embeddedLangs:["css","html","ini","java","lua","make","perl","r","ruby","php","sql","vb","xml","xsl","yaml","bat","clojure","coffee","c","cpp","diff","docker","git-commit","git-rebase","go","groovy","pug","javascript","json","jsonc","less","objective-c","swift","scss","raku","powershell","python","julia","rust","scala","shellscript","typescript","tsx","csharp","fsharp","dart","handlebars","erlang","elixir","latex","bibtex"]},{id:"marko",scopeName:"text.marko",path:"marko.tmLanguage.json",displayName:"Marko",samplePath:"marko.sample",embeddedLangs:["css","less","scss","javascript"]},{id:"matlab",scopeName:"source.matlab",path:"matlab.tmLanguage.json",displayName:"MATLAB",samplePath:"matlab.sample"},{id:"mdc",scopeName:"text.markdown.mdc",path:"mdc.tmLanguage.json",displayName:"mdc",samplePath:"mdc.sample",embeddedLangs:["markdown","yaml"]},{id:"mdx",scopeName:"source.mdx",path:"mdx.tmLanguage.json",displayName:"MDX",samplePath:"mdx.sample",embeddedLangs:["tsx","toml","yaml","c","clojure","coffee","cpp","csharp","css","diff","docker","elixir","elm","erlang","go","graphql","haskell","html","ini","java","javascript","json","julia","kotlin","less","lua","make","markdown","objective-c","perl","python","r","ruby","rust","scala","scss","shellscript","shellsession","sql","xml","swift","typescript"]},{id:"mermaid",scopeName:"source.mermaid",path:"mermaid.tmLanguage.json",displayName:"Mermaid",samplePath:"mermaid.sample"},{id:"mojo",scopeName:"source.mojo",path:"mojo.tmLanguage.json",displayName:"MagicPython",samplePath:"mojo.sample"},{id:"narrat",scopeName:"source.narrat",path:"narrat.tmLanguage.json",displayName:"Narrat Language",samplePath:"narrat.sample",aliases:["nar"]},{id:"nextflow",scopeName:"source.nextflow",path:"nextflow.tmLanguage.json",displayName:"Nextflow",samplePath:"nextflow.sample",aliases:["nf"]},{id:"nginx",scopeName:"source.nginx",path:"nginx.tmLanguage.json",displayName:"Nginx",samplePath:"nginx.sample",embeddedLangs:["lua"]},{id:"nim",scopeName:"source.nim",path:"nim.tmLanguage.json",displayName:"Nim",samplePath:"nim.sample",embeddedLangs:["c","html","xml","javascript","css","glsl","markdown"]},{id:"nix",scopeName:"source.nix",path:"nix.tmLanguage.json",displayName:"Nix",samplePath:"nix.sample"},{id:"nushell",scopeName:"source.nushell",path:"nushell.tmLanguage.json",displayName:"nushell",samplePath:"nushell.sample",aliases:["nu"]},{id:"objective-c",scopeName:"source.objc",path:"objective-c.tmLanguage.json",displayName:"Objective-C",samplePath:"objective-c.sample",aliases:["objc"]},{id:"objective-cpp",scopeName:"source.objcpp",path:"objective-cpp.tmLanguage.json",displayName:"Objective-C++",samplePath:"objective-cpp.sample"},{id:"ocaml",scopeName:"source.ocaml",path:"ocaml.tmLanguage.json",displayName:"OCaml",samplePath:"ocaml.sample"},{id:"pascal",scopeName:"source.pascal",path:"pascal.tmLanguage.json",displayName:"Pascal",samplePath:"pascal.sample"},{id:"perl",scopeName:"source.perl",path:"perl.tmLanguage.json",displayName:"Perl",samplePath:"perl.sample",embeddedLangs:["html","xml","css","javascript","sql"]},{id:"php",scopeName:"source.php",path:"php.tmLanguage.json",displayName:"PHP",samplePath:"php.sample",embeddedLangs:["html","xml","sql","javascript","json","css"]},{id:"plsql",scopeName:"source.plsql.oracle",path:"plsql.tmLanguage.json",displayName:"PL/SQL",samplePath:"plsql.sample"},{id:"postcss",scopeName:"source.css.postcss",path:"postcss.tmLanguage.json",displayName:"PostCSS",samplePath:"postcss.sample"},{id:"powerquery",scopeName:"source.powerquery",path:"powerquery.tmLanguage.json",displayName:"PowerQuery",samplePath:"powerquery.sample"},{id:"powershell",scopeName:"source.powershell",path:"powershell.tmLanguage.json",displayName:"PowerShell",samplePath:"powershell.sample",aliases:["ps","ps1"]},{id:"prisma",scopeName:"source.prisma",path:"prisma.tmLanguage.json",displayName:"Prisma",samplePath:"prisma.sample"},{id:"prolog",scopeName:"source.prolog",path:"prolog.tmLanguage.json",displayName:"Prolog",samplePath:"prolog.sample"},{id:"proto",scopeName:"source.proto",path:"proto.tmLanguage.json",displayName:"Protocol Buffer 3",samplePath:"proto.sample"},{id:"pug",scopeName:"text.pug",path:"pug.tmLanguage.json",displayName:"Pug",samplePath:"pug.sample",aliases:["jade"],embeddedLangs:["javascript","css","sass","scss","stylus","coffee","html"]},{id:"puppet",scopeName:"source.puppet",path:"puppet.tmLanguage.json",displayName:"Puppet",samplePath:"puppet.sample"},{id:"purescript",scopeName:"source.purescript",path:"purescript.tmLanguage.json",displayName:"PureScript",samplePath:"purescript.sample"},{id:"python",scopeName:"source.python",path:"python.tmLanguage.json",displayName:"Python",samplePath:"python.sample",aliases:["py"]},{id:"r",scopeName:"source.r",path:"r.tmLanguage.json",displayName:"R",samplePath:"r.sample"},{id:"raku",scopeName:"source.perl.6",path:"raku.tmLanguage.json",displayName:"Raku",samplePath:"raku.sample",aliases:["perl6"]},{id:"razor",scopeName:"text.aspnetcorerazor",path:"razor.tmLanguage.json",displayName:"ASP.NET Razor",samplePath:"razor.sample",embeddedLangs:["html","csharp"]},{id:"reg",scopeName:"source.reg",path:"reg.tmLanguage.json",displayName:"Windows Registry Script",samplePath:"reg.sample"},{id:"rel",scopeName:"source.rel",path:"rel.tmLanguage.json",displayName:"Rel",samplePath:"rel.sample"},{id:"riscv",scopeName:"source.riscv",path:"riscv.tmLanguage.json",displayName:"RISC-V",samplePath:"riscv.sample"},{id:"rst",scopeName:"source.rst",path:"rst.tmLanguage.json",displayName:"reStructuredText",samplePath:"rst.sample",embeddedLangs:["cpp","python","javascript","shellscript","yaml","cmake","ruby"]},{id:"ruby",scopeName:"source.ruby",path:"ruby.tmLanguage.json",displayName:"Ruby",samplePath:"ruby.sample",aliases:["rb"],embeddedLangs:["html","xml","sql","css","c","javascript","shellscript","lua"]},{id:"rust",scopeName:"source.rust",path:"rust.tmLanguage.json",displayName:"Rust",samplePath:"rust.sample",aliases:["rs"]},{id:"sas",scopeName:"source.sas",path:"sas.tmLanguage.json",displayName:"SAS",samplePath:"sas.sample",embeddedLangs:["sql"]},{id:"sass",scopeName:"source.sass",path:"sass.tmLanguage.json",displayName:"Sass",samplePath:"sass.sample"},{id:"scala",scopeName:"source.scala",path:"scala.tmLanguage.json",displayName:"Scala",samplePath:"scala.sample"},{id:"scheme",scopeName:"source.scheme",path:"scheme.tmLanguage.json",displayName:"Scheme",samplePath:"scheme.sample"},{id:"scss",scopeName:"source.css.scss",path:"scss.tmLanguage.json",displayName:"SCSS",samplePath:"scss.sample",embeddedLangs:["css"]},{id:"shaderlab",scopeName:"source.shaderlab",path:"shaderlab.tmLanguage.json",displayName:"ShaderLab",samplePath:"shaderlab.sample",aliases:["shader"],embeddedLangs:["hlsl"]},{id:"shellscript",scopeName:"source.shell",path:"shellscript.tmLanguage.json",displayName:"Shell",samplePath:"shellscript.sample",aliases:["bash","sh","shell","zsh"]},{id:"shellsession",scopeName:"text.shell-session",path:"shellsession.tmLanguage.json",displayName:"Shell Session",samplePath:"shellsession.sample",aliases:["console"],embeddedLangs:["shellscript"]},{id:"smalltalk",scopeName:"source.smalltalk",path:"smalltalk.tmLanguage.json",displayName:"Smalltalk",samplePath:"smalltalk.sample"},{id:"solidity",scopeName:"source.solidity",path:"solidity.tmLanguage.json",displayName:"Solidity",samplePath:"solidity.sample"},{id:"sparql",scopeName:"source.sparql",path:"sparql.tmLanguage.json",displayName:"SPARQL",samplePath:"sparql.sample",embeddedLangs:["turtle"]},{id:"splunk",scopeName:"source.splunk_search",path:"splunk.tmLanguage.json",displayName:"Splunk Query Language",samplePath:"splunk.sample",aliases:["spl"]},{id:"sql",scopeName:"source.sql",path:"sql.tmLanguage.json",displayName:"SQL",samplePath:"sql.sample"},{id:"ssh-config",scopeName:"source.ssh-config",path:"ssh-config.tmLanguage.json",displayName:"SSH Config",samplePath:"ssh-config.sample"},{id:"stata",scopeName:"source.stata",path:"stata.tmLanguage.json",displayName:"Stata",samplePath:"stata.sample",embeddedLangs:["sql"]},{id:"stylus",scopeName:"source.stylus",path:"stylus.tmLanguage.json",displayName:"Stylus",samplePath:"stylus.sample",aliases:["styl"]},{id:"svelte",scopeName:"source.svelte",path:"svelte.tmLanguage.json",displayName:"Svelte",samplePath:"svelte.sample",embeddedLangs:["javascript","typescript","coffee","stylus","sass","css","scss","less","postcss","pug","markdown"]},{id:"swift",scopeName:"source.swift",path:"swift.tmLanguage.json",displayName:"Swift",samplePath:"swift.sample"},{id:"system-verilog",scopeName:"source.systemverilog",path:"system-verilog.tmLanguage.json",displayName:"SystemVerilog",samplePath:"system-verilog.sample"},{id:"tasl",scopeName:"source.tasl",path:"tasl.tmLanguage.json",displayName:"Tasl",samplePath:"tasl.sample"},{id:"tcl",scopeName:"source.tcl",path:"tcl.tmLanguage.json",displayName:"Tcl",samplePath:"tcl.sample"},{id:"tex",scopeName:"text.tex",path:"tex.tmLanguage.json",displayName:"TeX",samplePath:"tex.sample",embeddedLangs:["r"]},{id:"toml",scopeName:"source.toml",path:"toml.tmLanguage.json",displayName:"TOML",samplePath:"toml.sample"},{id:"tsx",scopeName:"source.tsx",path:"tsx.tmLanguage.json",displayName:"TSX",samplePath:"tsx.sample"},{id:"turtle",scopeName:"source.turtle",path:"turtle.tmLanguage.json",displayName:"Turtle",samplePath:"turtle.sample"},{id:"twig",scopeName:"text.html.twig",path:"twig.tmLanguage.json",displayName:"Twig",samplePath:"twig.sample",embeddedLangs:["css","javascript","scss","php","python","ruby"]},{id:"typescript",scopeName:"source.ts",path:"typescript.tmLanguage.json",displayName:"TypeScript",samplePath:"typescript.sample",aliases:["ts"]},{id:"v",scopeName:"source.v",path:"v.tmLanguage.json",displayName:"V",samplePath:"v.sample"},{id:"vb",scopeName:"source.asp.vb.net",path:"vb.tmLanguage.json",displayName:"Visual Basic",samplePath:"vb.sample",aliases:["cmd"]},{id:"verilog",scopeName:"source.verilog",path:"verilog.tmLanguage.json",displayName:"Verilog",samplePath:"verilog.sample"},{id:"vhdl",scopeName:"source.vhdl",path:"vhdl.tmLanguage.json",displayName:"VHDL",samplePath:"vhdl.sample"},{id:"viml",scopeName:"source.viml",path:"viml.tmLanguage.json",displayName:"Vim Script",samplePath:"viml.sample",aliases:["vim","vimscript"]},{id:"vue-html",scopeName:"text.html.vue-html",path:"vue-html.tmLanguage.json",displayName:"Vue HTML",samplePath:"vue-html.sample",embeddedLangs:["vue","javascript"]},{id:"vue",scopeName:"source.vue",path:"vue.tmLanguage.json",displayName:"Vue",samplePath:"vue.sample",embeddedLangs:["html","markdown","pug","stylus","sass","css","scss","less","javascript","typescript","jsx","tsx","json","jsonc","json5","yaml","toml","graphql"]},{id:"vyper",scopeName:"source.vyper",path:"vyper.tmLanguage.json",displayName:"Vyper",samplePath:"vyper.sample",aliases:["vy"]},{id:"wasm",scopeName:"source.wat",path:"wasm.tmLanguage.json",displayName:"WebAssembly",samplePath:"wasm.sample"},{id:"wenyan",scopeName:"source.wenyan",path:"wenyan.tmLanguage.json",displayName:"Wenyan",samplePath:"wenyan.sample",aliases:["文言"]},{id:"wgsl",scopeName:"source.wgsl",path:"wgsl.tmLanguage.json",displayName:"WGSL",samplePath:"wgsl.sample"},{id:"wolfram",scopeName:"source.wolfram",path:"wolfram.tmLanguage.json",displayName:"Wolfram",samplePath:"wolfram.sample",aliases:["wl"]},{id:"xml",scopeName:"text.xml",path:"xml.tmLanguage.json",displayName:"XML",samplePath:"xml.sample",embeddedLangs:["java"]},{id:"xsl",scopeName:"text.xml.xsl",path:"xsl.tmLanguage.json",displayName:"XSL",samplePath:"xsl.sample",embeddedLangs:["xml"]},{id:"yaml",scopeName:"source.yaml",path:"yaml.tmLanguage.json",displayName:"YAML",samplePath:"yaml.sample",aliases:["yml"]},{id:"zenscript",scopeName:"source.zenscript",path:"zenscript.tmLanguage.json",displayName:"ZenScript",samplePath:"zenscript.sample"},{id:"zig",scopeName:"source.zig",path:"zig.tmLanguage.json",displayName:"zig",samplePath:"zig.sample"}];var CharacterCodes,ParseOptions,ScanError,SyntaxKind,FontStyle=(e=>(e[e.NotSet=-1]="NotSet",e[e.None=0]="None",e[e.Italic=1]="Italic",e[e.Bold=2]="Bold",e[e.Underline=4]="Underline",e))(FontStyle||{});class StackElementMetadata{static toBinaryStr(e){let a=e.toString(2);for(;a.length<32;)a="0"+a;return a}static printMetadata(e){let a=StackElementMetadata.getLanguageId(e),s=StackElementMetadata.getTokenType(e),t=StackElementMetadata.getFontStyle(e),n=StackElementMetadata.getForeground(e),o=StackElementMetadata.getBackground(e);console.log({languageId:a,tokenType:s,fontStyle:t,foreground:n,background:o})}static getLanguageId(e){return(255&e)>>>0}static getTokenType(e){return(768&e)>>>8}static getFontStyle(e){return(14336&e)>>>11}static getForeground(e){return(8372224&e)>>>15}static getBackground(e){return(4286578688&e)>>>24}static containsBalancedBrackets(e){return!!(1024&e)}static set(e,a,s,t,n,o){let l=StackElementMetadata.getLanguageId(e),r=StackElementMetadata.getTokenType(e),i=StackElementMetadata.getFontStyle(e),m=StackElementMetadata.getForeground(e),p=StackElementMetadata.getBackground(e);return 0!==a&&(l=a),0!==s&&(r=8===s?0:s),-1!==t&&(i=t),0!==n&&(m=n),0!==o&&(p=o),(l|r<<8|i<<11|(StackElementMetadata.containsBalancedBrackets(e)?1:0)<<10|m<<15|p<<24)>>>0}}function trimEndSlash(e){return e.endsWith("/")||e.endsWith("\\")?e.slice(0,-1):e}function trimStartDot(e){return e.startsWith("./")?e.slice(2):e}function dirpathparts(e){const a=e.split(/[\/\\]/g);return a.slice(0,a.length-1)}function join(...e){return e.map(trimEndSlash).map(trimStartDot).join("/")}function groupBy(e,a){const s=new Map;for(const t of e){const e=a(t);s.has(e)?s.get(e).push(t):s.set(e,[t])}return s}function createScanner(e,a=!1){const s=e.length;let t=0,n="",o=0,l=16,r=0,i=0,m=0,p=0,c=0;function d(a,s){let n=0,o=0;for(;n<a||!s;){let a=e.charCodeAt(t);if(a>=48&&a<=57)o=16*o+a-48;else if(a>=65&&a<=70)o=16*o+a-65+10;else{if(!(a>=97&&a<=102))break;o=16*o+a-97+10}t++,n++}return n<a&&(o=-1),o}function g(){if(n="",c=0,o=t,i=r,p=m,t>=s)return o=s,l=17;let a=e.charCodeAt(t);if(isWhiteSpace(a)){do{t++,n+=String.fromCharCode(a),a=e.charCodeAt(t)}while(isWhiteSpace(a));return l=15}if(isLineBreak(a))return t++,n+=String.fromCharCode(a),13===a&&10===e.charCodeAt(t)&&(t++,n+="\n"),r++,m=t,l=14;switch(a){case 123:return t++,l=1;case 125:return t++,l=2;case 91:return t++,l=3;case 93:return t++,l=4;case 58:return t++,l=6;case 44:return t++,l=5;case 34:return t++,n=function(){let a="",n=t;for(;;){if(t>=s){a+=e.substring(n,t),c=2;break}const o=e.charCodeAt(t);if(34===o){a+=e.substring(n,t),t++;break}if(92!==o){if(o>=0&&o<=31){if(isLineBreak(o)){a+=e.substring(n,t),c=2;break}c=6}t++}else{if(a+=e.substring(n,t),t++,t>=s){c=2;break}switch(e.charCodeAt(t++)){case 34:a+='"';break;case 92:a+="\\";break;case 47:a+="/";break;case 98:a+="\b";break;case 102:a+="\f";break;case 110:a+="\n";break;case 114:a+="\r";break;case 116:a+="\t";break;case 117:const e=d(4,!0);e>=0?a+=String.fromCharCode(e):c=4;break;default:c=5}n=t}}return a}(),l=10;case 47:const i=t-1;if(47===e.charCodeAt(t+1)){for(t+=2;t<s&&!isLineBreak(e.charCodeAt(t));)t++;return n=e.substring(i,t),l=12}if(42===e.charCodeAt(t+1)){t+=2;const a=s-1;let o=!1;for(;t<a;){const a=e.charCodeAt(t);if(42===a&&47===e.charCodeAt(t+1)){t+=2,o=!0;break}t++,isLineBreak(a)&&(13===a&&10===e.charCodeAt(t)&&t++,r++,m=t)}return o||(t++,c=1),n=e.substring(i,t),l=13}return n+=String.fromCharCode(a),t++,l=16;case 45:if(n+=String.fromCharCode(a),t++,t===s||!isDigit(e.charCodeAt(t)))return l=16;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return n+=function(){let a=t;if(48===e.charCodeAt(t))t++;else for(t++;t<e.length&&isDigit(e.charCodeAt(t));)t++;if(t<e.length&&46===e.charCodeAt(t)){if(t++,!(t<e.length&&isDigit(e.charCodeAt(t))))return c=3,e.substring(a,t);for(t++;t<e.length&&isDigit(e.charCodeAt(t));)t++}let s=t;if(t<e.length&&(69===e.charCodeAt(t)||101===e.charCodeAt(t)))if(t++,(t<e.length&&43===e.charCodeAt(t)||45===e.charCodeAt(t))&&t++,t<e.length&&isDigit(e.charCodeAt(t))){for(t++;t<e.length&&isDigit(e.charCodeAt(t));)t++;s=t}else c=3;return e.substring(a,s)}(),l=11;default:for(;t<s&&u(a);)t++,a=e.charCodeAt(t);if(o!==t){switch(n=e.substring(o,t),n){case"true":return l=8;case"false":return l=9;case"null":return l=7}return l=16}return n+=String.fromCharCode(a),t++,l=16}}function u(e){if(isWhiteSpace(e)||isLineBreak(e))return!1;switch(e){case 125:case 93:case 123:case 91:case 34:case 58:case 44:case 47:return!1}return!0}return{setPosition:function(e){t=e,n="",o=0,l=16,c=0},getPosition:()=>t,scan:a?function(){let e;do{e=g()}while(e>=12&&e<=15);return e}:g,getToken:()=>l,getTokenValue:()=>n,getTokenOffset:()=>o,getTokenLength:()=>t-o,getTokenStartLine:()=>i,getTokenStartCharacter:()=>o-p,getTokenError:()=>c}}function isWhiteSpace(e){return 32===e||9===e}function isLineBreak(e){return 10===e||13===e}function isDigit(e){return e>=48&&e<=57}function parse$1(e,a=[],s=ParseOptions.DEFAULT){let t=null,n=[];const o=[];function l(e){Array.isArray(n)?n.push(e):null!==t&&(n[t]=e)}return visit(e,{onObjectBegin:()=>{const e={};l(e),o.push(n),n=e,t=null},onObjectProperty:e=>{t=e},onObjectEnd:()=>{n=o.pop()},onArrayBegin:()=>{const e=[];l(e),o.push(n),n=e,t=null},onArrayEnd:()=>{n=o.pop()},onLiteralValue:l,onError:(e,s,t)=>{a.push({error:e,offset:s,length:t})}},s),n[0]}function visit(e,a,s=ParseOptions.DEFAULT){const t=createScanner(e,!1),n=[];function o(e){return e?()=>e(t.getTokenOffset(),t.getTokenLength(),t.getTokenStartLine(),t.getTokenStartCharacter()):()=>!0}function l(e){return e?()=>e(t.getTokenOffset(),t.getTokenLength(),t.getTokenStartLine(),t.getTokenStartCharacter(),(()=>n.slice())):()=>!0}function r(e){return e?a=>e(a,t.getTokenOffset(),t.getTokenLength(),t.getTokenStartLine(),t.getTokenStartCharacter()):()=>!0}function i(e){return e?a=>e(a,t.getTokenOffset(),t.getTokenLength(),t.getTokenStartLine(),t.getTokenStartCharacter(),(()=>n.slice())):()=>!0}const m=l(a.onObjectBegin),p=i(a.onObjectProperty),c=o(a.onObjectEnd),d=l(a.onArrayBegin),g=o(a.onArrayEnd),u=i(a.onLiteralValue),h=r(a.onSeparator),f=o(a.onComment),N=r(a.onError),y=s&&s.disallowComments,b=s&&s.allowTrailingComma;function L(){for(;;){const e=t.scan();switch(t.getTokenError()){case 4:j(14);break;case 5:j(15);break;case 3:j(13);break;case 1:y||j(11);break;case 2:j(12);break;case 6:j(16)}switch(e){case 12:case 13:y?j(10):f();break;case 16:j(1);break;case 15:case 14:break;default:return e}}}function j(e,a=[],s=[]){if(N(e),a.length+s.length>0){let e=t.getToken();for(;17!==e;){if(-1!==a.indexOf(e)){L();break}if(-1!==s.indexOf(e))break;e=L()}}}function k(e){const a=t.getTokenValue();return e?u(a):(p(a),n.push(a)),L(),!0}return L(),17===t.getToken()?!!s.allowEmptyContent||(j(4,[],[]),!1):function e(){switch(t.getToken()){case 3:return function(){d(),L();let a=!0,s=!1;for(;4!==t.getToken()&&17!==t.getToken();){if(5===t.getToken()){if(s||j(4,[],[]),h(","),L(),4===t.getToken()&&b)break}else s&&j(6,[],[]);a?(n.push(0),a=!1):n[n.length-1]++,e()||j(4,[],[4,5]),s=!0}return g(),a||n.pop(),4!==t.getToken()?j(8,[4],[]):L(),!0}();case 1:return function(){m(),L();let a=!1;for(;2!==t.getToken()&&17!==t.getToken();){if(5===t.getToken()){if(a||j(4,[],[]),h(","),L(),2===t.getToken()&&b)break}else a&&j(6,[],[]);(10!==t.getToken()?(j(3,[],[2,5]),0):(k(!1),6===t.getToken()?(h(":"),L(),e()||j(4,[],[2,5])):j(5,[],[2,5]),n.pop(),1))||j(4,[],[2,5]),a=!0}return c(),2!==t.getToken()?j(7,[2],[]):L(),!0}();case 10:return k(!0);default:return function(){switch(t.getToken()){case 11:const e=t.getTokenValue();let a=Number(e);isNaN(a)&&(j(2),a=0),u(a);break;case 7:u(null);break;case 8:u(!0);break;case 9:u(!1);break;default:return!1}return L(),!0}()}}()?(17!==t.getToken()&&j(9,[],[]),!0):(j(4,[],[]),!1)}!function(e){e[e.lineFeed=10]="lineFeed",e[e.carriageReturn=13]="carriageReturn",e[e.space=32]="space",e[e._0=48]="_0",e[e._1=49]="_1",e[e._2=50]="_2",e[e._3=51]="_3",e[e._4=52]="_4",e[e._5=53]="_5",e[e._6=54]="_6",e[e._7=55]="_7",e[e._8=56]="_8",e[e._9=57]="_9",e[e.a=97]="a",e[e.b=98]="b",e[e.c=99]="c",e[e.d=100]="d",e[e.e=101]="e",e[e.f=102]="f",e[e.g=103]="g",e[e.h=104]="h",e[e.i=105]="i",e[e.j=106]="j",e[e.k=107]="k",e[e.l=108]="l",e[e.m=109]="m",e[e.n=110]="n",e[e.o=111]="o",e[e.p=112]="p",e[e.q=113]="q",e[e.r=114]="r",e[e.s=115]="s",e[e.t=116]="t",e[e.u=117]="u",e[e.v=118]="v",e[e.w=119]="w",e[e.x=120]="x",e[e.y=121]="y",e[e.z=122]="z",e[e.A=65]="A",e[e.B=66]="B",e[e.C=67]="C",e[e.D=68]="D",e[e.E=69]="E",e[e.F=70]="F",e[e.G=71]="G",e[e.H=72]="H",e[e.I=73]="I",e[e.J=74]="J",e[e.K=75]="K",e[e.L=76]="L",e[e.M=77]="M",e[e.N=78]="N",e[e.O=79]="O",e[e.P=80]="P",e[e.Q=81]="Q",e[e.R=82]="R",e[e.S=83]="S",e[e.T=84]="T",e[e.U=85]="U",e[e.V=86]="V",e[e.W=87]="W",e[e.X=88]="X",e[e.Y=89]="Y",e[e.Z=90]="Z",e[e.asterisk=42]="asterisk",e[e.backslash=92]="backslash",e[e.closeBrace=125]="closeBrace",e[e.closeBracket=93]="closeBracket",e[e.colon=58]="colon",e[e.comma=44]="comma",e[e.dot=46]="dot",e[e.doubleQuote=34]="doubleQuote",e[e.minus=45]="minus",e[e.openBrace=123]="openBrace",e[e.openBracket=91]="openBracket",e[e.plus=43]="plus",e[e.slash=47]="slash",e[e.formFeed=12]="formFeed",e[e.tab=9]="tab"}(CharacterCodes||(CharacterCodes={})),function(e){e.DEFAULT={allowTrailingComma:!1}}(ParseOptions||(ParseOptions={})),function(e){e[e.None=0]="None",e[e.UnexpectedEndOfComment=1]="UnexpectedEndOfComment",e[e.UnexpectedEndOfString=2]="UnexpectedEndOfString",e[e.UnexpectedEndOfNumber=3]="UnexpectedEndOfNumber",e[e.InvalidUnicode=4]="InvalidUnicode",e[e.InvalidEscapeCharacter=5]="InvalidEscapeCharacter",e[e.InvalidCharacter=6]="InvalidCharacter"}(ScanError||(ScanError={})),function(e){e[e.OpenBraceToken=1]="OpenBraceToken",e[e.CloseBraceToken=2]="CloseBraceToken",e[e.OpenBracketToken=3]="OpenBracketToken",e[e.CloseBracketToken=4]="CloseBracketToken",e[e.CommaToken=5]="CommaToken",e[e.ColonToken=6]="ColonToken",e[e.NullKeyword=7]="NullKeyword",e[e.TrueKeyword=8]="TrueKeyword",e[e.FalseKeyword=9]="FalseKeyword",e[e.StringLiteral=10]="StringLiteral",e[e.NumericLiteral=11]="NumericLiteral",e[e.LineCommentTrivia=12]="LineCommentTrivia",e[e.BlockCommentTrivia=13]="BlockCommentTrivia",e[e.LineBreakTrivia=14]="LineBreakTrivia",e[e.Trivia=15]="Trivia",e[e.Unknown=16]="Unknown",e[e.EOF=17]="EOF"}(SyntaxKind||(SyntaxKind={}));const parse=parse$1;var ParseErrorCode;!function(e){e[e.InvalidSymbol=1]="InvalidSymbol",e[e.InvalidNumberFormat=2]="InvalidNumberFormat",e[e.PropertyNameExpected=3]="PropertyNameExpected",e[e.ValueExpected=4]="ValueExpected",e[e.ColonExpected=5]="ColonExpected",e[e.CommaExpected=6]="CommaExpected",e[e.CloseBraceExpected=7]="CloseBraceExpected",e[e.CloseBracketExpected=8]="CloseBracketExpected",e[e.EndOfFileExpected=9]="EndOfFileExpected",e[e.InvalidCommentToken=10]="InvalidCommentToken",e[e.UnexpectedEndOfComment=11]="UnexpectedEndOfComment",e[e.UnexpectedEndOfString=12]="UnexpectedEndOfString",e[e.UnexpectedEndOfNumber=13]="UnexpectedEndOfNumber",e[e.InvalidUnicode=14]="InvalidUnicode",e[e.InvalidEscapeCharacter=15]="InvalidEscapeCharacter",e[e.InvalidCharacter=16]="InvalidCharacter"}(ParseErrorCode||(ParseErrorCode={}));const isWebWorker="undefined"!=typeof self&&void 0!==self.WorkerGlobalScope,isNode="process"in globalThis&&"undefined"!=typeof process&&void 0!==process.release&&"node"===process.release.name,isBun="process"in globalThis&&"undefined"!=typeof process&&void 0!==process.release&&"bun"===process.release.name,isBrowser=isWebWorker||!isNode&&!isBun;let CDN_ROOT="",WASM="";const WASM_PATH="dist/";function setCDN(e){CDN_ROOT=e.endsWith("/")?e:e+"/"}function setWasm(e){WASM=e}let _onigurumaPromise=null;async function getOniguruma(e){if(!_onigurumaPromise){let a;if(isBrowser)a=loadWASM("string"==typeof WASM?{data:await fetch(_resolvePath(join(...dirpathparts(e),"onig.wasm")))}:{data:WASM});else{const e=require("path").join(require.resolve("vscode-oniguruma"),"../onig.wasm"),s=require("fs").readFileSync(e).buffer;a=loadWASM(s)}_onigurumaPromise=a.then((()=>({createOnigScanner:e=>createOnigScanner(e),createOnigString:e=>createOnigString(e)})))}return _onigurumaPromise}function _resolvePath(e){if(isBrowser)return`${CDN_ROOT}${e}`;{const a=require("path");return a.isAbsolute(e)?e:a.resolve(__dirname,"..",e)}}async function _fetchAssets(e){const a=_resolvePath(e);if(isBrowser)return await fetch(a).then((e=>e.text()));{const e=require("fs");return await e.promises.readFile(a,"utf-8")}}async function _fetchJSONAssets(e){const a=[],s=await _fetchAssets(e);let t;try{t=JSON.parse(s)}catch(e){if(t=parse(s,a,{allowTrailingComma:!0}),a.length)throw a[0]}return t}async function fetchTheme(e){const a=toShikiTheme(await _fetchJSONAssets(e));if(a.include){const s=await fetchTheme(join(...dirpathparts(e),a.include));s.settings&&(a.settings=s.settings.concat(a.settings)),s.bg&&!a.bg&&(a.bg=s.bg),s.colors&&(a.colors={...s.colors,...a.colors}),delete a.include}return a}async function fetchGrammar(e){return await _fetchJSONAssets(e)}function repairTheme(e){e.settings||(e.settings=[]),e.settings[0]&&e.settings[0].settings&&!e.settings[0].scope||e.settings.unshift({settings:{foreground:e.fg,background:e.bg}})}function toShikiTheme(e){const a=e.type||"dark",s={name:e.name,type:a,...e,...getThemeDefaultColors(e)};return e.include&&(s.include=e.include),e.tokenColors&&(s.settings=e.tokenColors,delete s.tokenColors),repairTheme(s),s}const VSCODE_FALLBACK_EDITOR_FG={light:"#333333",dark:"#bbbbbb"},VSCODE_FALLBACK_EDITOR_BG={light:"#fffffe",dark:"#1e1e1e"};function getThemeDefaultColors(e){let a,s,t=e.settings?e.settings:e.tokenColors;const n=t?t.find((e=>!e.name&&!e.scope)):void 0;return n?.settings?.foreground&&(a=n.settings.foreground),n?.settings?.background&&(s=n.settings.background),!a&&e?.colors?.["editor.foreground"]&&(a=e.colors["editor.foreground"]),!s&&e?.colors?.["editor.background"]&&(s=e.colors["editor.background"]),a||(a="light"===e.type?VSCODE_FALLBACK_EDITOR_FG.light:VSCODE_FALLBACK_EDITOR_FG.dark),s||(s="light"===e.type?VSCODE_FALLBACK_EDITOR_BG.light:VSCODE_FALLBACK_EDITOR_BG.dark),{fg:a,bg:s}}class Resolver{constructor(e,a){this.languagesPath="languages/",this.languageMap={},this.scopeToLangMap={},this._onigLibPromise=e,this._onigLibName=a}get onigLib(){return this._onigLibPromise}getOnigLibName(){return this._onigLibName}getLangRegistration(e){return this.languageMap[e]}async loadGrammar(e){const a=this.scopeToLangMap[e];if(!a)return null;if(a.grammar)return a.grammar;const s=await fetchGrammar(languages.includes(a)?`${this.languagesPath}${a.path}`:a.path);return a.grammar=s,s}addLanguage(e){this.languageMap[e.id]=e,e.aliases&&e.aliases.forEach((a=>{this.languageMap[a]=e})),this.scopeToLangMap[e.scopeName]=e}}function tokenizeWithTheme(e,a,s,t,n){let o=s.split(/\r\n|\r|\n/),l=INITIAL,r=[],i=[];for(let s=0,m=o.length;s<m;s++){let m,p,c,d=o[s];if(""===d){r=[],i.push([]);continue}n.includeExplanation&&(m=t.tokenizeLine(d,l),p=m.tokens,c=0);let g=t.tokenizeLine2(d,l),u=g.tokens.length/2;for(let s=0;s<u;s++){let t=g.tokens[2*s],o=s+1<u?g.tokens[2*s+2]:d.length;if(t===o)continue;let l=g.tokens[2*s+1],i=a[StackElementMetadata.getForeground(l)],m=StackElementMetadata.getFontStyle(l),h=[];if(n.includeExplanation){let a=0;for(;t+a<o;){let s=p[c],t=d.substring(s.startIndex,s.endIndex);a+=t.length,h.push({content:t,scopes:explainThemeScopes(e,s.scopes)}),c++}}r.push({content:d.substring(t,o),color:i,fontStyle:m,explanation:h})}i.push(r),r=[],l=g.ruleStack}return i}function explainThemeScopes(e,a){let s=[];for(let t=0,n=a.length;t<n;t++){let n=a.slice(0,t),o=a[t];s[t]={scopeName:o,themeMatches:explainThemeScope(e,o,n)}}return s}function matchesOne(e,a){let s=e+".";return e===a||a.substring(0,s.length)===s}function matches(e,a,s,t){if(!matchesOne(e,s))return!1;let n=a.length-1,o=t.length-1;for(;n>=0&&o>=0;)matchesOne(a[n],t[o])&&n--,o--;return-1===n}function explainThemeScope(e,a,s){let t=[],n=0;for(let o=0,l=e.settings.length;o<l;o++){let l,r=e.settings[o];if("string"==typeof r.scope)l=r.scope.split(/,/).map((e=>e.trim()));else{if(!Array.isArray(r.scope))continue;l=r.scope}for(let e=0,o=l.length;e<o;e++){let i=l[e].split(/ /);matches(i[i.length-1],i.slice(0,i.length-1),a,s)&&(t[n++]=r,e=o)}}return t}var namedColors=["black","red","green","yellow","blue","magenta","cyan","white","brightBlack","brightRed","brightGreen","brightYellow","brightBlue","brightMagenta","brightCyan","brightWhite"],decorations={1:"bold",2:"dim",3:"italic",4:"underline",7:"reverse",9:"strikethrough"};function findSequence(e,a){const s=e.indexOf("",a);if(-1!==s&&"["===e[s+1]){const a=e.indexOf("m",s);return{sequence:e.substring(s+2,a).split(";"),startPosition:s,position:a+1}}return{position:e.length}}function parseColor(e){const a=e.shift();if("2"===a){const a=e.splice(0,3).map((e=>Number.parseInt(e)));if(3!==a.length||a.some((e=>Number.isNaN(e))))return;return{type:"rgb",rgb:a}}if("5"===a){const a=e.shift();if(a)return{type:"table",index:Number(a)}}}function parseSequence(e){const a=[];for(;e.length>0;){const s=e.shift();if(!s)continue;const t=Number.parseInt(s);if(!Number.isNaN(t))if(0===t)a.push({type:"resetAll"});else if(t<=9)decorations[t]&&a.push({type:"setDecoration",value:decorations[t]});else if(t<=29){const e=decorations[t-20];e&&a.push({type:"resetDecoration",value:e})}else if(t<=37)a.push({type:"setForegroundColor",value:{type:"named",name:namedColors[t-30]}});else if(38===t){const s=parseColor(e);s&&a.push({type:"setForegroundColor",value:s})}else if(39===t)a.push({type:"resetForegroundColor"});else if(t<=47)a.push({type:"setBackgroundColor",value:{type:"named",name:namedColors[t-40]}});else if(48===t){const s=parseColor(e);s&&a.push({type:"setBackgroundColor",value:s})}else 49===t?a.push({type:"resetBackgroundColor"}):t>=90&&t<=97?a.push({type:"setForegroundColor",value:{type:"named",name:namedColors[t-90+8]}}):t>=100&&t<=107&&a.push({type:"setBackgroundColor",value:{type:"named",name:namedColors[t-100+8]}})}return a}function createAnsiSequenceParser(){let e=null,a=null,s=new Set;return{parse(t){const n=[];let o=0;do{const l=findSequence(t,o),r=l.sequence?t.substring(o,l.startPosition):t.substring(o);if(r.length>0&&n.push({value:r,foreground:e,background:a,decorations:new Set(s)}),l.sequence){const t=parseSequence(l.sequence);for(const n of t)"resetAll"===n.type?(e=null,a=null,s.clear()):"resetForegroundColor"===n.type?e=null:"resetBackgroundColor"===n.type?a=null:"resetDecoration"===n.type&&s.delete(n.value);for(const n of t)"setForegroundColor"===n.type?e=n.value:"setBackgroundColor"===n.type?a=n.value:"setDecoration"===n.type&&s.add(n.value)}o=l.position}while(o<t.length);return n}}}var defaultNamedColorsMap={black:"#000000",red:"#bb0000",green:"#00bb00",yellow:"#bbbb00",blue:"#0000bb",magenta:"#ff00ff",cyan:"#00bbbb",white:"#eeeeee",brightBlack:"#555555",brightRed:"#ff5555",brightGreen:"#00ff00",brightYellow:"#ffff55",brightBlue:"#5555ff",brightMagenta:"#ff55ff",brightCyan:"#55ffff",brightWhite:"#ffffff"};function createColorPalette(e=defaultNamedColorsMap){function a(a){return e[a]}function s(e){return`#${e.map((e=>Math.max(0,Math.min(e,255)).toString(16).padStart(2,"0"))).join("")}`}let t;return{value:function(e){switch(e.type){case"named":return a(e.name);case"rgb":return s(e.rgb);case"table":return n=e.index,function(){if(t)return t;t=[];for(let e=0;e<namedColors.length;e++)t.push(a(namedColors[e]));let e=[0,95,135,175,215,255];for(let a=0;a<6;a++)for(let n=0;n<6;n++)for(let o=0;o<6;o++)t.push(s([e[a],e[n],e[o]]));let n=8;for(let e=0;e<24;e++,n+=10)t.push(s([n,n,n]));return t}()[n]}var n}}}function tokenizeAnsiWithTheme(e,a){const s=a.split(/\r?\n/),t=createColorPalette(Object.fromEntries(namedColors.map((a=>[a,e.colors[`terminal.ansi${a[0].toUpperCase()}${a.substring(1)}`]])))),n=createAnsiSequenceParser();return s.map((a=>n.parse(a).map((a=>{let s;s=a.decorations.has("reverse")?a.background?t.value(a.background):e.bg:a.foreground?t.value(a.foreground):e.fg,a.decorations.has("dim")&&(s=dimColor(s));let n=FontStyle.None;return a.decorations.has("bold")&&(n|=FontStyle.Bold),a.decorations.has("italic")&&(n|=FontStyle.Italic),a.decorations.has("underline")&&(n|=FontStyle.Underline),{content:a.value,color:s,fontStyle:n}}))))}function dimColor(e){const a=e.match(/#([0-9a-f]{3})([0-9a-f]{3})?([0-9a-f]{2})?/);if(a){if(a[3]){const e=Math.round(Number.parseInt(a[3],16)/2).toString(16).padStart(2,"0");return`#${a[1]}${a[2]}${e}`}return a[2]?`#${a[1]}${a[2]}80`:`#${Array.from(a[1]).map((e=>`${e}${e}`)).join("")}80`}const s=e.match(/var\((--shiki-color-ansi-[\w-]+)\)/);return s?`var(${s[1]}-dim)`:e}const defaultElements={pre:({className:e,style:a,children:s})=>`<pre class="${e}" style="${a}" tabindex="0">${s}</pre>`,code:({children:e})=>`<code>${e}</code>`,line:({className:e,children:a})=>`<span class="${e}">${a}</span>`,token:({style:e,children:a})=>`<span style="${e}">${a}</span>`};function renderToHtml(e,a={}){const s=a.bg||"#fff",t=groupBy(a.lineOptions??[],(e=>e.line)),n=a.elements||{};function o(e="",a={},s){const t=n[e]||defaultElements[e];return t?(s=s.filter(Boolean),t({...a,children:"code"===e?s.join("\n"):s.join("")})):""}return o("pre",{className:"shiki "+(a.themeName||""),style:`background-color: ${s}`},[a.langId?`<div class="language-id">${a.langId}</div>`:"",o("code",{},e.map(((s,n)=>{const l=n+1;return o("line",{className:getLineClasses(t.get(l)??[]).join(" "),lines:e,line:s,index:n},s.map(((e,t)=>{const n=[`color: ${e.color||a.fg}`];return e.fontStyle&FontStyle.Italic&&n.push("font-style: italic"),e.fontStyle&FontStyle.Bold&&n.push("font-weight: bold"),e.fontStyle&FontStyle.Underline&&n.push("text-decoration: underline"),o("token",{style:n.join("; "),tokens:s,token:e,index:t},[escapeHtml(e.content)])})))})))])}const htmlEscapes={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"};function escapeHtml(e){return e.replace(/[&<>"']/g,(e=>htmlEscapes[e]))}function getLineClasses(e){const a=new Set(["line"]);for(const s of e)for(const e of s.classes??[])a.add(e);return Array.from(a)}class Registry extends Registry$1{constructor(e){super(e),this._resolver=e,this.themesPath="themes/",this._resolvedThemes={},this._resolvedGrammars={},this._langGraph=new Map,this._langMap=languages.reduce(((e,a)=>(e[a.id]=a,e)),{})}getTheme(e){return"string"==typeof e?this._resolvedThemes[e]:e}async loadTheme(e){return"string"==typeof e?(this._resolvedThemes[e]||(this._resolvedThemes[e]=await fetchTheme(`${this.themesPath}${e}.json`)),this._resolvedThemes[e]):((e=toShikiTheme(e)).name&&(this._resolvedThemes[e.name]=e),e)}async loadThemes(e){return await Promise.all(e.map((e=>this.loadTheme(e))))}getLoadedThemes(){return Object.keys(this._resolvedThemes)}getGrammar(e){return this._resolvedGrammars[e]}async loadLanguage(e){const a=e.embeddedLangs?.reduce((async(e,a,s)=>{if(!this.getLoadedLanguages().includes(a)&&this._resolver.getLangRegistration(a))return await this._resolver.loadGrammar(this._resolver.getLangRegistration(a).scopeName),e[this._resolver.getLangRegistration(a).scopeName]=s+2,e}),{}),s={embeddedLanguages:a,balancedBracketSelectors:e.balancedBracketSelectors||["*"],unbalancedBracketSelectors:e.unbalancedBracketSelectors||[]},t=await this.loadGrammarWithConfiguration(e.scopeName,1,s);this._resolvedGrammars[e.id]=t,e.aliases&&e.aliases.forEach((e=>{this._resolvedGrammars[e]=t}))}async loadLanguages(e){for(const a of e)this.resolveEmbeddedLanguages(a);const a=Array.from(this._langGraph.values());for(const e of a)this._resolver.addLanguage(e);for(const e of a)await this.loadLanguage(e)}getLoadedLanguages(){return Object.keys(this._resolvedGrammars)}resolveEmbeddedLanguages(e){if(this._langGraph.has(e.id)||this._langGraph.set(e.id,e),e.embeddedLangs)for(const a of e.embeddedLangs)this._langGraph.set(a,this._langMap[a])}}function resolveLang(e){return"string"==typeof e?languages.find((a=>a.id===e||a.aliases?.includes(e))):e}function resolveOptions(e){let a=languages,s=e.themes||[],t=e.paths?.wasm?e.paths.wasm.endsWith("/")?e.paths.wasm:e.paths.wasm+"/":"dist/";return e.langs&&(a=e.langs.map(resolveLang)),e.theme&&s.unshift(e.theme),s.length||(s=["nord"]),{_languages:a,_themes:s,_wasmPath:t}}function generateDefaultColorReplacements(){const e={"#000001":"var(--shiki-color-text)","#000002":"var(--shiki-color-background)","#000004":"var(--shiki-token-constant)","#000005":"var(--shiki-token-string)","#000006":"var(--shiki-token-comment)","#000007":"var(--shiki-token-keyword)","#000008":"var(--shiki-token-parameter)","#000009":"var(--shiki-token-function)","#000010":"var(--shiki-token-string-expression)","#000011":"var(--shiki-token-punctuation)","#000012":"var(--shiki-token-link)"};for(let a=0;a<namedColors.length;a++){const s=`#A${a.toString().padStart(5,"0")}`,t=namedColors[a].replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();e[s]=`var(--shiki-color-ansi-${t})`}return e}async function getHighlighter(e){const{_languages:a,_themes:s,_wasmPath:t}=resolveOptions(e),n=new Resolver(getOniguruma(t),"vscode-oniguruma"),o=new Registry(n);e.paths?.themes&&(o.themesPath=e.paths.themes.endsWith("/")?e.paths.themes:e.paths.themes+"/"),e.paths?.languages&&(n.languagesPath=e.paths.languages.endsWith("/")?e.paths.languages:e.paths.languages+"/");const l=(await o.loadThemes(s))[0];let r;await o.loadLanguages(a);let i=generateDefaultColorReplacements();function m(e){const a=e?o.getTheme(e):l;if(!a)throw Error(`No theme registration for ${e}`);r&&r.name===a.name||(o.setTheme(a),r=a);const s=o.getColorMap();return"css"===a.type&&function(e,a){e.bg=i[e.bg]||e.bg,e.fg=i[e.fg]||e.fg,Object.entries(e.colors).forEach((([a,s])=>{e.colors[a]=i[s]||s})),a.forEach(((e,s)=>{a[s]=i[e]||e}))}(a,s),{_theme:a,_colorMap:s}}function p(e,a="text",s,t={includeExplanation:!0}){if(isPlaintext(a))return[...e.split(/\r\n|\r|\n/).map((e=>[{content:e}]))];const{_grammar:n}=function(e){const a=o.getGrammar(e);if(!a)throw Error(`No language registration for ${e}`);return{_grammar:a}}(a),{_theme:l,_colorMap:r}=m(s);return tokenizeWithTheme(l,r,e,n,t)}function c(e,a){const{_theme:s}=m(a);return tokenizeAnsiWithTheme(s,e)}return{codeToThemedTokens:p,codeToHtml:function(e,a="text",s){let t;t="object"==typeof a?a:{lang:a,theme:s};const n=p(e,t.lang,t.theme,{includeExplanation:!1}),{_theme:o}=m(t.theme);return renderToHtml(n,{fg:o.fg,bg:o.bg,lineOptions:t?.lineOptions,themeName:o.name})},ansiToThemedTokens:c,ansiToHtml:function(e,a){const s=c(e,a?.theme),{_theme:t}=m(a?.theme);return renderToHtml(s,{fg:t.fg,bg:t.bg,lineOptions:a?.lineOptions,themeName:t.name})},getTheme:e=>m(e)._theme,loadTheme:async function(e){await o.loadTheme(e)},loadLanguage:async function(e){const a=resolveLang(e);n.addLanguage(a),await o.loadLanguage(a)},getBackgroundColor:function(e){const{_theme:a}=m(e);return a.bg},getForegroundColor:function(e){const{_theme:a}=m(e);return a.fg},getLoadedThemes:function(){return o.getLoadedThemes()},getLoadedLanguages:function(){return o.getLoadedLanguages()},setColorReplacements:function(e){i=e}}}function isPlaintext(e){return!e||["plaintext","txt","text"].includes(e)}function setOnigasmWASM(e){setWasm(e)}export{languages as BUNDLED_LANGUAGES,themes as BUNDLED_THEMES,FontStyle,getHighlighter,fetchTheme as loadTheme,renderToHtml,setCDN,setOnigasmWASM,setWasm,toShikiTheme};