<?php

$MediaId = get_option('news_25_media_id');

$content = '<p>Lorem ipsum dolor sit amet, consectetur adipiscing mollis dolor facilisis porttitor.</p><!--more--><p>This is the rest of the content that will appear only on single post view.</p>';

// Define blog post categories
$blog_categories = array(
    'latest' => 'Latest',
    'featured' => 'Featured',
    'popular' => 'Popular',
    'trending' => 'Trending',
    'sport-1' => 'Sport',
    'sport-2' => 'Sport2',    
);

// Create blog post categories if they don't exist
$created_blog_cats = [];
foreach ($blog_categories as $slug => $name) {
    $result = wp_insert_term($name, 'category', ['slug' => $slug]);
    $created_blog_cats[$slug] = !is_wp_error($result)
        ? $result['term_id']
        : get_term_by('slug', $slug, 'category')->term_id;
}

// Blog post data with multiple categories
$posts = [
    [
        'post_title' => 'Green Hydrogen: Fueling a Sustainable Tomorrow',
        'post_category_slugs' => [ 'latest'], // Multiple categories
        'tags' => ['Green'],
    ],
    [
        'post_title' => 'Quantum Computing: The Next Tech Frontier',
        'post_category_slugs' => [ 'latest'], 
        'tags' => ['Computing'],
    ],
    [
        'post_title' => 'AI-Powered Healthcare: Revolutionizing Patient Care',
        'post_category_slugs' => ['latest'], 
        'tags' => ['AI'],
    ],
	[
        'post_title' => 'Apple Unveils iPhone 17 with Groundbreaking AI Features and Battery Life',
        'post_category_slugs' => [ 'popular'], 
        'tags' => ['Apple'],
    ],
    [
        'post_title' => 'NASA Confirms Water on the Moon’s South Pole, Plans Crewed Mission by 2028',
        'post_category_slugs' => [ 'popular'], 
        'tags' => ['Nasa'],
    ],
    [
        'post_title' => 'Global Markets Rally After US Fed Signals End to Rate Hikes',
        'post_category_slugs' => ['popular'], 
        'tags' => ['Rally'],
    ],
    [
        'post_title' => 'Economy Surge: Global Markets See Unprecedented Growth Post-Recession',
        'post_category_slugs' => [ 'featured'], 
        'tags' => ['Computing'],
    ],
    [
        'post_title' => 'Space Exploration: Mars Mission Reveals Evidence of Ancient Life',
        'post_category_slugs' => [ 'featured'], 
        'tags' => ['AI'],
    ],
    [
        'post_title' => 'Climate Action Milestone: UN Achieves Global Agreement on Carbon Emission Reductions',
        'post_category_slugs' => ['featured'], 
        'tags' => ['Nasa'],
    ],
	[
        'post_title' => 'Apple Unveils iPhone 17 with Groundbreaking AI Features and Battery Life',
        'post_category_slugs' => [ 'trending'], 
        'tags' => ['Rally'],
    ],
    [
        'post_title' => 'NASA Confirms Water on the Moon’s South Pole, Plans Crewed Mission by 2028',
        'post_category_slugs' => [ 'trending'], 
        'tags' => ['Green'],
    ],
    [
        'post_title' => 'Global Markets Rally After US Fed Signals End to Rate Hikes',
        'post_category_slugs' => ['trending'], 
        'tags' => ['Computing'],
    ],
    [
        'post_title' => 'Economy Surge: Global Markets See Unprecedented Growth Post-Recession',
        'post_category_slugs' => [ 'trending'], 
        'tags' => ['AI'],
    ],
    [
        'post_title' => 'Space Exploration: Mars Mission Reveals Evidence of Ancient Life',
        'post_category_slugs' => ['trending'], 
        'tags' => ['Nasa'],
    ],
    [
        'post_title' => 'Climate Action Milestone: UN Achieves Global Agreement on Carbon Emission Reductions',
        'post_category_slugs' => [ 'trending'], 
        'tags' => ['Rally'],
    ],
    [
        'post_title' => 'VAR Controversy in Football: Fairness or Flaw?',
        'post_category_slugs' => [ 'sport-1'], 
        'tags' => ['Green'],
    ],
    [
        'post_title' => 'Sprinting in 2025: New Records, New Rivalries',
        'post_category_slugs' => ['sport-1'], 
        'tags' => ['Apple'],
    ],
	[
        'post_title' => 'Cricket’s T20 Evolution: Entertainment Over Tradition',
        'post_category_slugs' => [ 'sport-1'], 
        'tags' => ['AI'],
    ],
    [
        'post_title' => 'FIFA Women’s World Cup 2025: The Rise of Underdog Teams and Unforgettable Matches',
        'post_category_slugs' => [ 'sport-2'], 
        'tags' => ['Nasa'],
    ],
    [
        'post_title' => 'Record-Breaking Performance: Usain Bolt’s Legacy in the 2025 World Athletics Championships',
        'post_category_slugs' => ['sport-2'], 
        'tags' => ['Computing'],
    ],
    [
        'post_title' => 'NBA Finals 2025: LeBron James’ Final Championship Run Sparks Excitement',
        'post_category_slugs' => ['sport-2'], 
        'tags' => ['Rally'],
    ],
];

foreach ($posts as $index => $data) {
    // Convert category slugs to category IDs
    $category_ids = [];
    foreach ($data['post_category_slugs'] as $slug) {
        if (isset($created_blog_cats[$slug])) {
            $category_ids[] = $created_blog_cats[$slug];
        }
    }

    // Create the post
    $post_args = [
        'post_title'   => $data['post_title'],
        'post_status'  => 'publish',
        'post_content' => $content,
        'post_author'  => 1,
        'post_type'    => 'post',
        'post_category'=> $category_ids, // Assign multiple categories
        'tax_input'    => ['post_tag' => $data['tags']],
    ];

    $post_id = wp_insert_post($post_args);

    // Assign featured image if exists
    if (!is_wp_error($post_id) && isset($MediaId[$index + 1])) {
        set_post_thumbnail($post_id, $MediaId[$index + 1]);
    }

}
?>
