/*!
 * # Semantic UI 2.1.7 - Form Validation
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */!function(e,t,n,r){"use strict";e.fn.form=function(t){var i,a=e(this),o=a.selector||"",l=new Date().getTime(),s=[],u=arguments[0],c=arguments[1],f="string"==typeof u,d=[].slice.call(arguments,1);return a.each(function(){var p,m,g,h,v,b,$,y,_,x,k,E,C,w,V,S,R,A,F=e(this),z=this,L=[],O=!1;(A={initialize:function(){A.get.settings(),f?(R===r&&A.instantiate(),A.invoke(u)):(A.verbose("Initializing form validation",F,y),A.bindEvents(),A.set.defaults(),A.instantiate())},instantiate:function(){A.verbose("Storing instance of module",A),R=A,F.data(V,A)},destroy:function(){A.verbose("Destroying previous module",R),A.removeEvents(),F.removeData(V)},refresh:function(){A.verbose("Refreshing selector cache"),p=F.find(k.field),m=F.find(k.group),g=F.find(k.message),h=F.find(k.prompt),v=F.find(k.submit),b=F.find(k.clear),$=F.find(k.reset)},submit:function(){A.verbose("Submitting form",F),F.submit()},attachEvents:function(t,n){n=n||"submit",e(t).on("click"+S,function(e){A[n](),e.preventDefault()})},bindEvents:function(){A.verbose("Attaching form events"),F.on("submit"+S,A.validate.form).on("blur"+S,k.field,A.event.field.blur).on("click"+S,k.submit,A.submit).on("click"+S,k.reset,A.reset).on("click"+S,k.clear,A.clear),y.keyboardShortcuts&&F.on("keydown"+S,k.field,A.event.field.keydown),p.each(function(){var t=e(this),n=t.prop("type"),r=A.get.changeEvent(n,t);e(this).on(r+S,A.event.field.change)})},clear:function(){p.each(function(){var t=e(this),n=t.parent(),r=t.closest(m),i=r.find(k.prompt),a=t.data(x.defaultValue)||"",o=n.is(k.uiCheckbox),l=n.is(k.uiDropdown);r.hasClass(E.error)&&(A.verbose("Resetting error on field",r),r.removeClass(E.error),i.remove()),l?(A.verbose("Resetting dropdown value",n,a),n.dropdown("clear")):o?t.prop("checked",!1):(A.verbose("Resetting field value",t,a),t.val(""))})},reset:function(){p.each(function(){var t=e(this),n=t.parent(),i=t.closest(m),a=i.find(k.prompt),o=t.data(x.defaultValue),l=n.is(k.uiCheckbox),s=n.is(k.uiDropdown),u=i.hasClass(E.error);o!==r&&(u&&(A.verbose("Resetting error on field",i),i.removeClass(E.error),a.remove()),s?(A.verbose("Resetting dropdown value",n,o),n.dropdown("restore defaults")):l?(A.verbose("Resetting checkbox value",n,o),t.prop("checked",o)):(A.verbose("Resetting field value",t,o),t.val(o)))})},is:{bracketedRule:function(e){return e.type&&e.type.match(y.regExp.bracket)},valid:function(){var t=!0;return A.verbose("Checking if form is valid"),e.each(_,function(e,n){A.validate.field(n,e)||(t=!1)}),t}},removeEvents:function(){F.off(S),p.off(S),v.off(S),p.off(S)},event:{field:{keydown:function(t){var n=e(this),r=t.which,i={enter:13,escape:27};r==i.escape&&(A.verbose("Escape key pressed blurring field"),n.blur()),!t.ctrlKey&&r==i.enter&&n.is(k.input)&&n.not(k.checkbox).length>0&&(O||(n.one("keyup"+S,A.event.field.keyup),A.submit(),A.debug("Enter pressed on input submitting form")),O=!0)},keyup:function(){O=!1},blur:function(t){var n=e(this),r=n.closest(m),i=A.get.validation(n);r.hasClass(E.error)?(A.debug("Revalidating field",n,i),A.validate.form.call(A,t,!0)):("blur"==y.on||"change"==y.on)&&i&&A.validate.field(i)},change:function(t){var n=e(this),r=n.closest(m);("change"==y.on||r.hasClass(E.error)&&y.revalidate)&&(clearTimeout(A.timer),A.timer=setTimeout(function(){A.debug("Revalidating field",n,A.get.validation(n)),A.validate.form.call(A,t,!0)},y.delay))}}},get:{ancillaryValue:function(e){return!!(e.type&&A.is.bracketedRule(e))&&e.type.match(y.regExp.bracket)[1]+""},ruleName:function(e){return A.is.bracketedRule(e)?e.type.replace(e.type.match(y.regExp.bracket)[0],""):e.type},changeEvent:function(e,t){return"checkbox"==e||"radio"==e||"hidden"==e||t.is("select")?"change":A.get.inputEvent()},inputEvent:function(){return r!==n.createElement("input").oninput?"input":r!==n.createElement("input").onpropertychange?"propertychange":"keyup"},prompt:function(e,t){var n,r,i,a=A.get.ruleName(e),o=A.get.ancillaryValue(e),l=e.prompt||y.prompt[a]||y.text.unspecifiedRule,s=-1!==l.search("{value}"),u=-1!==l.search("{name}");return(u||s)&&(r=A.get.field(t.identifier)),s&&(l=l.replace("{value}",r.val())),u&&(i=1==(n=r.closest(k.group).find("label").eq(0)).size()?n.text():r.prop("placeholder")||y.text.unspecifiedField,l=l.replace("{name}",i)),l=(l=l.replace("{identifier}",t.identifier)).replace("{ruleValue}",o),e.prompt||A.verbose("Using default validation prompt for type",l,a),l},settings:function(){if(e.isPlainObject(t)){var n,i=Object.keys(t);i.length>0&&r!==t[i[0]].identifier&&r!==t[i[0]].rules?(y=e.extend(!0,{},e.fn.form.settings,c),_=e.extend({},e.fn.form.settings.defaults,t),A.error(y.error.oldSyntax,z),A.verbose("Extending settings from legacy parameters",_,y)):(t.fields&&(n=Object.keys(t.fields),("string"==typeof t.fields[n[0]]||e.isArray(t.fields[n[0]]))&&e.each(t.fields,function(n,r){"string"==typeof r&&(r=[r]),t.fields[n]={rules:[]},e.each(r,function(e,r){t.fields[n].rules.push({type:r})})})),y=e.extend(!0,{},e.fn.form.settings,t),_=e.extend({},e.fn.form.settings.defaults,y.fields),A.verbose("Extending settings",_,y))}else y=e.fn.form.settings,_=e.fn.form.settings.defaults,A.verbose("Using default form validation",_,y);w=y.namespace,x=y.metadata,k=y.selector,E=y.className,C=y.error,V="module-"+w,S="."+w,R=F.data(V),A.refresh()},field:function(t){return(A.verbose("Finding field with identifier",t),p.filter("#"+t).length>0)?p.filter("#"+t):p.filter('[name="'+t+'"]').length>0?p.filter('[name="'+t+'"]'):p.filter('[name="'+t+'[]"]').length>0?p.filter('[name="'+t+'[]"]'):p.filter("[data-"+x.validate+'="'+t+'"]').length>0?p.filter("[data-"+x.validate+'="'+t+'"]'):e("<input/>")},fields:function(t){var n=e();return e.each(t,function(e,t){n=n.add(A.get.field(t))}),n},validation:function(t){var n,r;return!!_&&(e.each(_,function(e,i){r=i.identifier||e,A.get.field(r)[0]==t[0]&&(i.identifier=r,n=i)}),n||!1)},value:function(e){var t,n=[];return n.push(e),(t=A.get.values.call(z,n))[e]},values:function(t){var n=e.isArray(t)?A.get.fields(t):p,r={};return n.each(function(t,n){var i=e(n),a=(i.prop("type"),i.prop("name")),o=i.val(),l=i.is(k.checkbox),s=i.is(k.radio),u=-1!==a.indexOf("[]"),c=!!l&&i.is(":checked");a&&(u?(r[a=a.replace("[]","")]||(r[a]=[]),l?c?r[a].push(o||!0):r[a].push(!1):r[a].push(o)):s?c&&(r[a]=o):l?c?r[a]=o||!0:r[a]=!1:r[a]=o)}),r}},has:{field:function(e){return A.verbose("Checking for existence of a field with identifier",e),"string"!=typeof e&&A.error(C.identifier,e),!!(p.filter("#"+e).length>0)||!!(p.filter('[name="'+e+'"]').length>0)||!!(p.filter("[data-"+x.validate+'="'+e+'"]').length>0)}},add:{prompt:function(t,n){var i=A.get.field(t).closest(m),a=i.children(k.prompt),o=0!==a.length;n="string"==typeof n?[n]:n,A.verbose("Adding field error state",t),i.addClass(E.error),y.inline&&(o||(a=y.templates.prompt(n)).appendTo(i),a.html(n[0]),o?A.verbose("Inline errors are disabled, no inline error added",t):y.transition&&r!==e.fn.transition&&F.transition("is supported")?(A.verbose("Displaying error with css transition",y.transition),a.transition(y.transition+" in",y.duration)):(A.verbose("Displaying error with fallback javascript animation"),a.fadeIn(y.duration)))},errors:function(e){A.debug("Adding form error messages",e),A.set.error(),g.html(y.templates.error(e))}},remove:{prompt:function(t){var n=A.get.field(t).closest(m),i=n.children(k.prompt);n.removeClass(E.error),y.inline&&i.is(":visible")&&(A.verbose("Removing prompt for field",t),y.transition&&r!==e.fn.transition&&F.transition("is supported")?i.transition(y.transition+" out",y.duration,function(){i.remove()}):i.fadeOut(y.duration,function(){i.remove()}))}},set:{success:function(){F.removeClass(E.error).addClass(E.success)},defaults:function(){p.each(function(){var t=e(this),n=t.filter(k.checkbox).length>0?t.is(":checked"):t.val();t.data(x.defaultValue,n)})},error:function(){F.removeClass(E.success).addClass(E.error)},value:function(e,t){var n={};return n[e]=t,A.set.values.call(z,n)},values:function(t){!e.isEmptyObject(t)&&e.each(t,function(t,n){var r,i=A.get.field(t),a=i.parent(),o=e.isArray(n),l=a.is(k.uiCheckbox),s=a.is(k.uiDropdown),u=i.is(k.radio)&&l;i.length>0&&(o&&l?(A.verbose("Selecting multiple",n,i),a.checkbox("uncheck"),e.each(n,function(e,t){a=(r=i.filter('[value="'+t+'"]')).parent(),r.length>0&&a.checkbox("check")})):u?(A.verbose("Selecting radio value",n,i),i.filter('[value="'+n+'"]').parent(k.uiCheckbox).checkbox("check")):l?(A.verbose("Setting checkbox value",n,a),!0===n?a.checkbox("check"):a.checkbox("uncheck")):s?(A.verbose("Setting dropdown value",n,a),a.dropdown("set selected",n)):(A.verbose("Setting field value",n,i),i.val(n)))})}},validate:{form:function(e,t){var n=A.get.values();if(O)return!1;if(L=[],A.is.valid()){if(A.debug("Form has no validation errors, submitting"),A.set.success(),!0!==t)return y.onSuccess.call(z,e,n)}else if(A.debug("Form has errors"),A.set.error(),y.inline||A.add.errors(L),r!==F.data("moduleApi")&&e.stopImmediatePropagation(),!0!==t)return y.onFailure.call(z,L,n)},field:function(t,n){var i=t.identifier||n,a=A.get.field(i),o=!0,l=[];return(t.identifier||(A.debug("Using field name as identifier",i),t.identifier=i),a.prop("disabled")?(A.debug("Field is disabled. Skipping",i),o=!0):t.optional&&""===e.trim(a.val())?(A.debug("Field is optional and empty. Skipping",i),o=!0):r!==t.rules&&e.each(t.rules,function(e,n){A.has.field(i)&&!A.validate.rule(t,n)&&(A.debug("Field is invalid",i,n.type),l.push(A.get.prompt(n,t)),o=!1)}),o)?(A.remove.prompt(i,l),y.onValid.call(a),!0):(L=L.concat(l),A.add.prompt(i,l),y.onInvalid.call(a,l),!1)},rule:function(t,n){var i=A.get.field(t.identifier),a=(n.type,i.val()),o=A.get.ancillaryValue(n),l=A.get.ruleName(n),s=y.rules[l];if(!e.isFunction(s)){A.error(C.noRule,l);return}return a=a===r||""===a||null===a?"":e.trim(a+""),s.call(i,a,o)}},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,y,t);else{if(n===r)return y[t];y[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,A,t);else{if(n===r)return A[t];A[t]=n}},debug:function(){y.debug&&(y.performance?A.performance.log(arguments):(A.debug=Function.prototype.bind.call(console.info,console,y.name+":"),A.debug.apply(console,arguments)))},verbose:function(){y.verbose&&y.debug&&(y.performance?A.performance.log(arguments):(A.verbose=Function.prototype.bind.call(console.info,console,y.name+":"),A.verbose.apply(console,arguments)))},error:function(){A.error=Function.prototype.bind.call(console.error,console,y.name+":"),A.error.apply(console,arguments)},performance:{log:function(e){var t,n,r;y.performance&&(t=new Date().getTime(),r=l||t,n=t-r,l=t,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:z,"Execution Time":n})),clearTimeout(A.performance.timer),A.performance.timer=setTimeout(A.performance.display,500)},display:function(){var t=y.name+":",n=0;l=!1,clearTimeout(A.performance.timer),e.each(s,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",o&&(t+=" '"+o+"'"),a.length>1&&(t+=" ("+a.length+")"),(r!==console.group||r!==console.table)&&s.length>0&&(console.groupCollapsed(t),console.table?console.table(s):e.each(s,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(t,n,a){var o,l,s,u=R;return n=n||d,a=z||a,"string"==typeof t&&u!==r&&(o=(t=t.split(/[\. ]/)).length-1,e.each(t,function(n,i){var a=n!=o?i+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(u[a])&&n!=o)u=u[a];else if(r!==u[a])return l=u[a],!1;else if(e.isPlainObject(u[i])&&n!=o)u=u[i];else if(r!==u[i])return l=u[i],!1;else return!1})),e.isFunction(l)?s=l.apply(a,n):l!==r&&(s=l),e.isArray(i)?i.push(s):i!==r?i=[i,s]:s!==r&&(i=s),l}}).initialize()}),i!==r?i:this},e.fn.form.settings={name:"Form",namespace:"form",debug:!1,verbose:!1,performance:!0,fields:!1,keyboardShortcuts:!0,on:"submit",inline:!1,delay:200,revalidate:!0,transition:"scale",duration:200,onValid:function(){},onInvalid:function(){},onSuccess:function(){return!0},onFailure:function(){return!1},metadata:{defaultValue:"default",validate:"validate"},regExp:{bracket:/\[(.*)\]/i,decimal:/^\d*(\.)\d+/,email:"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?",escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,flags:/^\/(.*)\/(.*)?/,integer:/^\-?\d+$/,number:/^\-?\d*(\.\d+)?$/,url:/(https?:\/\/(?:www\.|(?!www))[^\s\.]+\.[^\s]{2,}|www\.[^\s]+\.[^\s]{2,})/i},text:{unspecifiedRule:"Please enter a valid value",unspecifiedField:"This field"},prompt:{empty:"{name} must have a value",checked:"{name} must be checked",email:"{name} must be a valid e-mail",url:"{name} must be a valid url",regExp:"{name} is not formatted correctly",integer:"{name} must be an integer",decimal:"{name} must be a decimal number",number:"{name} must be set to a number",is:'{name} must be "{ruleValue}"',isExactly:'{name} must be exactly "{ruleValue}"',not:'{name} cannot be set to "{ruleValue}"',notExactly:'{name} cannot be set to exactly "{ruleValue}"',contain:'{name} cannot contain "{ruleValue}"',containExactly:'{name} cannot contain exactly "{ruleValue}"',doesntContain:'{name} must contain  "{ruleValue}"',doesntContainExactly:'{name} must contain exactly "{ruleValue}"',minLength:"{name} must be at least {ruleValue} characters",length:"{name} must be at least {ruleValue} characters",exactLength:"{name} must be exactly {ruleValue} characters",maxLength:"{name} cannot be longer than {ruleValue} characters",match:"{name} must match {ruleValue} field",different:"{name} must have a different value than {ruleValue} field",creditCard:"{name} must be a valid credit card number",minCount:"{name} must have at least {ruleValue} choices",exactCount:"{name} must have exactly {ruleValue} choices",maxCount:"{name} must have {ruleValue} or less choices"},selector:{checkbox:'input[type="checkbox"], input[type="radio"]',clear:".clear",field:"input, textarea, select",group:".field",input:"input",message:".error.message",prompt:".prompt.label",radio:'input[type="radio"]',reset:'.reset:not([type="reset"])',submit:'.submit:not([type="submit"])',uiCheckbox:".ui.checkbox",uiDropdown:".ui.dropdown"},className:{error:"error",label:"ui prompt label",pressed:"down",success:"success"},error:{identifier:"You must specify a string identifier for each field",method:"The method you called is not defined.",noRule:"There is no rule matching the one you specified",oldSyntax:"Starting in 2.0 forms now only take a single settings object. Validation settings converted to new syntax automatically."},templates:{error:function(t){var n='<ul class="list">';return e.each(t,function(e,t){n+="<li>"+t+"</li>"}),e(n+="</ul>")},prompt:function(t){return e("<div/>").addClass("ui basic red pointing prompt label").html(t[0])}},rules:{empty:function(t){return!(t===r||""===t||e.isArray(t)&&0===t.length)},checked:function(){return e(this).filter(":checked").length>0},email:function(t){return RegExp(e.fn.form.settings.regExp.email,"i").test(t)},url:function(t){return e.fn.form.settings.regExp.url.test(t)},regExp:function(t,n){var r,i=n.match(e.fn.form.settings.regExp.flags);return i&&(n=i.length>=2?i[1]:n,r=i.length>=3?i[2]:""),t.match(RegExp(n,r))},integer:function(t,n){var i,a,o,l=e.fn.form.settings.regExp.integer;return n&&-1===["",".."].indexOf(n)&&(-1==n.indexOf("..")?l.test(n)&&(i=a=n-0):(o=n.split("..",2),l.test(o[0])&&(i=o[0]-0),l.test(o[1])&&(a=o[1]-0))),l.test(t)&&(i===r||t>=i)&&(a===r||t<=a)},decimal:function(t){return e.fn.form.settings.regExp.decimal.test(t)},number:function(t){return e.fn.form.settings.regExp.number.test(t)},is:function(e,t){return t="string"==typeof t?t.toLowerCase():t,(e="string"==typeof e?e.toLowerCase():e)==t},isExactly:function(e,t){return e==t},not:function(e,t){return(e="string"==typeof e?e.toLowerCase():e)!=(t="string"==typeof t?t.toLowerCase():t)},notExactly:function(e,t){return e!=t},contains:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1!==t.search(RegExp(n,"i"))},containsExactly:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1!==t.search(RegExp(n))},doesntContain:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1===t.search(RegExp(n,"i"))},doesntContainExactly:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1===t.search(RegExp(n))},minLength:function(e,t){return e!==r&&e.length>=t},length:function(e,t){return e!==r&&e.length>=t},exactLength:function(e,t){return e!==r&&e.length==t},maxLength:function(e,t){return e!==r&&e.length<=t},match:function(t,n){var i;return e(this),e('[data-validate="'+n+'"]').length>0?i=e('[data-validate="'+n+'"]').val():e("#"+n).length>0?i=e("#"+n).val():e('[name="'+n+'"]').length>0?i=e('[name="'+n+'"]').val():e('[name="'+n+'[]"]').length>0&&(i=e('[name="'+n+'[]"]')),i!==r&&t.toString()==i.toString()},different:function(t,n){var i;return e(this),e('[data-validate="'+n+'"]').length>0?i=e('[data-validate="'+n+'"]').val():e("#"+n).length>0?i=e("#"+n).val():e('[name="'+n+'"]').length>0?i=e('[name="'+n+'"]').val():e('[name="'+n+'[]"]').length>0&&(i=e('[name="'+n+'[]"]')),i!==r&&t.toString()!==i.toString()},creditCard:function(t,n){var r,i,a={visa:{pattern:/^4/,length:[16]},amex:{pattern:/^3[47]/,length:[15]},mastercard:{pattern:/^5[1-5]/,length:[16]},discover:{pattern:/^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)/,length:[16]},unionPay:{pattern:/^(62|88)/,length:[16,17,18,19]},jcb:{pattern:/^35(2[89]|[3-8][0-9])/,length:[16]},maestro:{pattern:/^(5018|5020|5038|6304|6759|676[1-3])/,length:[12,13,14,15,16,17,18,19]},dinersClub:{pattern:/^(30[0-5]|^36)/,length:[14]},laser:{pattern:/^(6304|670[69]|6771)/,length:[16,17,18,19]},visaElectron:{pattern:/^(4026|417500|4508|4844|491(3|7))/,length:[16]}},o={},l=!1,s="string"==typeof n&&n.split(",");if("string"==typeof t&&0!==t.length){if(s&&(e.each(s,function(n,r){(i=a[r])&&(o={length:-1!==e.inArray(t.length,i.length),pattern:-1!==t.search(i.pattern)}).length&&o.pattern&&(l=!0)}),!l))return!1;if((r={number:-1!==e.inArray(t.length,a.unionPay.length),pattern:-1!==t.search(a.unionPay.pattern)}).number&&r.pattern)return!0;for(var u=t.length,c=0,f=[[0,1,2,3,4,5,6,7,8,9],[0,2,4,6,8,1,3,5,7,9]],d=0;u--;)d+=f[c][parseInt(t.charAt(u),10)],c^=1;return d%10==0&&d>0}},minCount:function(e,t){return 0==t||(1==t?""!==e:e.split(",").length>=t)},exactCount:function(e,t){return 0==t?""===e:1==t?""!==e&&-1===e.search(","):e.split(",").length==t},maxCount:function(e,t){return 0!=t&&(1==t?-1===e.search(","):e.split(",").length<=t)}}}}(jQuery,window,document);