/*!
 * # Semantic UI 2.1.7 - Checkbox
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */!function(e,n,t,i){"use strict";e.fn.checkbox=function(a){var r,c=e(this),o=c.selector||"",d=new Date().getTime(),l=[],s=arguments[0],u="string"==typeof s,b=[].slice.call(arguments,1);return c.each(function(){var c,h,g=e.extend(!0,{},e.fn.checkbox.settings,a),f=g.className,p=g.namespace,k=g.selector,m=g.error,v="."+p,y="module-"+p,C=e(this),x=e(this).children(k.label),_=e(this).children(k.input),$=_[0],w=!1,I=!1,S=C.data(y),D=this;h={initialize:function(){h.verbose("Initializing checkbox",g),h.create.label(),h.bind.events(),h.set.tabbable(),h.hide.input(),h.observeChanges(),h.instantiate(),h.setup()},instantiate:function(){h.verbose("Storing instance of module",h),S=h,C.data(y,h)},destroy:function(){h.verbose("Destroying module"),h.unbind.events(),h.show.input(),C.removeData(y)},fix:{reference:function(){C.is(k.input)&&(h.debug("Behavior called on <input> adjusting invoked element"),C=C.closest(k.checkbox),h.refresh())}},setup:function(){h.set.initialLoad(),h.is.indeterminate()?(h.debug("Initial value is indeterminate"),h.indeterminate()):h.is.checked()?(h.debug("Initial value is checked"),h.check()):(h.debug("Initial value is unchecked"),h.uncheck()),h.remove.initialLoad()},refresh:function(){x=C.children(k.label),$=(_=C.children(k.input))[0]},hide:{input:function(){h.verbose("Modfying <input> z-index to be unselectable"),_.addClass(f.hidden)}},show:{input:function(){h.verbose("Modfying <input> z-index to be selectable"),_.removeClass(f.hidden)}},observeChanges:function(){"MutationObserver"in n&&((c=new MutationObserver(function(e){h.debug("DOM tree modified, updating selector cache"),h.refresh()})).observe(D,{childList:!0,subtree:!0}),h.debug("Setting up mutation observer",c))},attachEvents:function(n,t){var i=e(n);t=e.isFunction(h[t])?h[t]:h.toggle,i.length>0?(h.debug("Attaching checkbox events to element",n,t),i.on("click"+v,t)):h.error(m.notFound)},event:{click:function(n){var t=e(n.target);if(t.is(k.input)){h.verbose("Using default check action on initialized checkbox");return}if(t.is(k.link)){h.debug("Clicking link inside checkbox, skipping toggle");return}h.toggle(),_.focus(),n.preventDefault()},keydown:function(e){var n=e.which,t={enter:13,space:32,escape:27};n==t.escape?(h.verbose("Escape key pressed blurring field"),_.blur(),I=!0):e.ctrlKey||n!=t.space&&n!=t.enter?I=!1:(h.verbose("Enter/space key pressed, toggling checkbox"),h.toggle(),I=!0)},keyup:function(e){I&&e.preventDefault()}},check:function(){h.should.allowCheck()&&(h.debug("Checking checkbox",_),h.set.checked(),h.should.ignoreCallbacks()||(g.onChecked.call($),g.onChange.call($)))},uncheck:function(){h.should.allowUncheck()&&(h.debug("Unchecking checkbox"),h.set.unchecked(),h.should.ignoreCallbacks()||(g.onUnchecked.call($),g.onChange.call($)))},indeterminate:function(){if(h.should.allowIndeterminate()){h.debug("Checkbox is already indeterminate");return}h.debug("Making checkbox indeterminate"),h.set.indeterminate(),h.should.ignoreCallbacks()||(g.onIndeterminate.call($),g.onChange.call($))},determinate:function(){if(h.should.allowDeterminate()){h.debug("Checkbox is already determinate");return}h.debug("Making checkbox determinate"),h.set.determinate(),h.should.ignoreCallbacks()||(g.onDeterminate.call($),g.onChange.call($))},enable:function(){if(h.is.enabled()){h.debug("Checkbox is already enabled");return}h.debug("Enabling checkbox"),h.set.enabled(),g.onEnabled.call($)},disable:function(){if(h.is.disabled()){h.debug("Checkbox is already disabled");return}h.debug("Disabling checkbox"),h.set.disabled(),g.onDisabled.call($)},get:{radios:function(){return e('input[name="'+h.get.name()+'"]').closest(k.checkbox)},otherRadios:function(){return h.get.radios().not(C)},name:function(){return _.attr("name")}},is:{initialLoad:function(){return w},radio:function(){return _.hasClass(f.radio)||"radio"==_.attr("type")},indeterminate:function(){return i!==_.prop("indeterminate")&&_.prop("indeterminate")},checked:function(){return i!==_.prop("checked")&&_.prop("checked")},disabled:function(){return i!==_.prop("disabled")&&_.prop("disabled")},enabled:function(){return!h.is.disabled()},determinate:function(){return!h.is.indeterminate()},unchecked:function(){return!h.is.checked()}},should:{allowCheck:function(){return h.is.determinate()&&h.is.checked()&&!h.should.forceCallbacks()?(h.debug("Should not allow check, checkbox is already checked"),!1):!1!==g.beforeChecked.apply($)||(h.debug("Should not allow check, beforeChecked cancelled"),!1)},allowUncheck:function(){return h.is.determinate()&&h.is.unchecked()&&!h.should.forceCallbacks()?(h.debug("Should not allow uncheck, checkbox is already unchecked"),!1):!1!==g.beforeUnchecked.apply($)||(h.debug("Should not allow uncheck, beforeUnchecked cancelled"),!1)},allowIndeterminate:function(){return h.is.indeterminate()&&!h.should.forceCallbacks()?(h.debug("Should not allow indeterminate, checkbox is already indeterminate"),!1):!1!==g.beforeIndeterminate.apply($)||(h.debug("Should not allow indeterminate, beforeIndeterminate cancelled"),!1)},allowDeterminate:function(){return h.is.determinate()&&!h.should.forceCallbacks()?(h.debug("Should not allow determinate, checkbox is already determinate"),!1):!1!==g.beforeDeterminate.apply($)||(h.debug("Should not allow determinate, beforeDeterminate cancelled"),!1)},forceCallbacks:function(){return h.is.initialLoad()&&g.fireOnInit},ignoreCallbacks:function(){return w&&!g.fireOnInit}},can:{change:function(){return!(C.hasClass(f.disabled)||C.hasClass(f.readOnly)||_.prop("disabled")||_.prop("readonly"))},uncheck:function(){return"boolean"==typeof g.uncheckable?g.uncheckable:!h.is.radio()}},set:{initialLoad:function(){w=!0},checked:function(){if(h.verbose("Setting class to checked"),C.removeClass(f.indeterminate).addClass(f.checked),h.is.radio()&&h.uncheckOthers(),!h.is.indeterminate()&&h.is.checked()){h.debug("Input is already checked, skipping input property change");return}h.verbose("Setting state to checked",$),_.prop("indeterminate",!1).prop("checked",!0),h.trigger.change()},unchecked:function(){if(h.verbose("Removing checked class"),C.removeClass(f.indeterminate).removeClass(f.checked),!h.is.indeterminate()&&h.is.unchecked()){h.debug("Input is already unchecked");return}h.debug("Setting state to unchecked"),_.prop("indeterminate",!1).prop("checked",!1),h.trigger.change()},indeterminate:function(){if(h.verbose("Setting class to indeterminate"),C.addClass(f.indeterminate),h.is.indeterminate()){h.debug("Input is already indeterminate, skipping input property change");return}h.debug("Setting state to indeterminate"),_.prop("indeterminate",!0),h.trigger.change()},determinate:function(){if(h.verbose("Removing indeterminate class"),C.removeClass(f.indeterminate),h.is.determinate()){h.debug("Input is already determinate, skipping input property change");return}h.debug("Setting state to determinate"),_.prop("indeterminate",!1)},disabled:function(){if(h.verbose("Setting class to disabled"),C.addClass(f.disabled),h.is.disabled()){h.debug("Input is already disabled, skipping input property change");return}h.debug("Setting state to disabled"),_.prop("disabled","disabled"),h.trigger.change()},enabled:function(){if(h.verbose("Removing disabled class"),C.removeClass(f.disabled),h.is.enabled()){h.debug("Input is already enabled, skipping input property change");return}h.debug("Setting state to enabled"),_.prop("disabled",!1),h.trigger.change()},tabbable:function(){h.verbose("Adding tabindex to checkbox"),i===_.attr("tabindex")&&_.attr("tabindex",0)}},remove:{initialLoad:function(){w=!1}},trigger:{change:function(){var e=t.createEvent("HTMLEvents"),n=_[0];n&&(h.verbose("Triggering native change event"),e.initEvent("change",!0,!1),n.dispatchEvent(e))}},create:{label:function(){_.prevAll(k.label).length>0?(_.prev(k.label).detach().insertAfter(_),h.debug("Moving existing label",x)):h.has.label()||(x=e("<label>").insertAfter(_),h.debug("Creating label",x))}},has:{label:function(){return x.length>0}},bind:{events:function(){h.verbose("Attaching checkbox events"),C.on("click"+v,h.event.click).on("keydown"+v,k.input,h.event.keydown).on("keyup"+v,k.input,h.event.keyup)}},unbind:{events:function(){h.debug("Removing events"),C.off(v)}},uncheckOthers:function(){var e=h.get.otherRadios();h.debug("Unchecking other radios",e),e.removeClass(f.checked)},toggle:function(){if(!h.can.change()){h.is.radio()||h.debug("Checkbox is read-only or disabled, ignoring toggle");return}h.is.indeterminate()||h.is.unchecked()?(h.debug("Currently unchecked"),h.check()):h.is.checked()&&h.can.uncheck()&&(h.debug("Currently checked"),h.uncheck())},setting:function(n,t){if(h.debug("Changing setting",n,t),e.isPlainObject(n))e.extend(!0,g,n);else{if(t===i)return g[n];g[n]=t}},internal:function(n,t){if(e.isPlainObject(n))e.extend(!0,h,n);else{if(t===i)return h[n];h[n]=t}},debug:function(){g.debug&&(g.performance?h.performance.log(arguments):(h.debug=Function.prototype.bind.call(console.info,console,g.name+":"),h.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?h.performance.log(arguments):(h.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),h.verbose.apply(console,arguments)))},error:function(){h.error=Function.prototype.bind.call(console.error,console,g.name+":"),h.error.apply(console,arguments)},performance:{log:function(e){var n,t,i;g.performance&&(n=new Date().getTime(),i=d||n,t=n-i,d=n,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:D,"Execution Time":t})),clearTimeout(h.performance.timer),h.performance.timer=setTimeout(h.performance.display,500)},display:function(){var n=g.name+":",t=0;d=!1,clearTimeout(h.performance.timer),e.each(l,function(e,n){t+=n["Execution Time"]}),n+=" "+t+"ms",o&&(n+=" '"+o+"'"),(i!==console.group||i!==console.table)&&l.length>0&&(console.groupCollapsed(n),console.table?console.table(l):e.each(l,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(n,t,a){var c,o,d,l=S;return t=t||b,a=D||a,"string"==typeof n&&l!==i&&(c=(n=n.split(/[\. ]/)).length-1,e.each(n,function(t,a){var r=t!=c?a+n[t+1].charAt(0).toUpperCase()+n[t+1].slice(1):n;if(e.isPlainObject(l[r])&&t!=c)l=l[r];else if(i!==l[r])return o=l[r],!1;else if(e.isPlainObject(l[a])&&t!=c)l=l[a];else if(i!==l[a])return o=l[a],!1;else return h.error(m.method,n),!1})),e.isFunction(o)?d=o.apply(a,t):o!==i&&(d=o),e.isArray(r)?r.push(d):r!==i?r=[r,d]:d!==i&&(r=d),o}},u?(S===i&&h.initialize(),h.invoke(s)):(S!==i&&S.invoke("destroy"),h.initialize())}),r!==i?r:this},e.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",debug:!1,verbose:!0,performance:!0,uncheckable:"auto",fireOnInit:!1,onChange:function(){},beforeChecked:function(){},beforeUnchecked:function(){},beforeDeterminate:function(){},beforeIndeterminate:function(){},onChecked:function(){},onUnchecked:function(){},onDeterminate:function(){},onIndeterminate:function(){},onEnable:function(){},onDisable:function(){},className:{checked:"checked",indeterminate:"indeterminate",disabled:"disabled",hidden:"hidden",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined"},selector:{checkbox:".vi-ui.checkbox",label:"label, .box",input:'input[type="checkbox"], input[type="radio"]',link:"a[href]"}}}(jQuery,window,document);