<?php

/**
 * List of cities for: United States
 * Source: https://simplemaps.com/data/us-cities
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['US'];

$country_cities = [
	'WA' => [
		'US1840042075' => 'South Creek',
		'US1840019842' => 'Roslyn',
		'US1840021107' => 'Sprague',
		'US1840019855' => 'Gig Harbor',
		'US1840041959' => 'Lake Cassidy',
		'US1840021144' => 'Tenino',
		'US1840037668' => 'Jamestown',
		'US1840018375' => 'Three Lakes',
		'US1840043278' => 'Curlew Lake',
		'US1840041915' => 'Chain Lake',
		'US1840019763' => 'Pateros',
		'US1840023878' => 'Rosburg',
		'US1840018453' => 'Parkland',
		'US1840017289' => 'Birch Bay',
		'US1840017363' => 'Ashford',
		'US1840018407' => 'Navy Yard City',
		'US1840019761' => 'Omak',
		'US1840021140' => 'Farmington',
		'US1840018455' => 'Buckley',
		'US1840017324' => 'Cathcart',
		'US1840019822' => 'Poulsbo',
		'US1840018366' => 'Anacortes',
		'US1840037569' => 'Maplewood',
		'US1840021109' => 'Creston',
		'US1840021095' => 'Rockford',
		'US1840018528' => 'Wishram',
		'US1840018471' => 'Centralia',
		'US1840037886' => 'South Hill',
		'US1840037874' => 'Longview Heights',
		'US1840073915' => 'Erlands Point-Kitsap Lake',
		'US1840017396' => 'Amboy',
		'US1840021139' => 'St. John',
		'US1840018525' => 'Dallesport',
		'US1840037558' => 'Ketron Island',
		'US1840019887' => 'Mesa',
		'US1840019853' => 'Fife',
		'US1840074436' => 'Moses Lake North',
		'US1840018360' => 'Chewelah',
		'US1840017360' => 'Grayland',
		'US1840019843' => 'Kittitas',
		'US1840037492' => 'Camano',
		'US1840042006' => 'Monroe North',
		'US1840019903' => 'North Bonneville',
		'US1840017404' => 'Klickitat',
		'US1840023998' => 'Loon Lake',
		'US1840019765' => 'Newport',
		'US1840023786' => 'Mead',
		'US1840018368' => 'Cashmere',
		'US1840037845' => 'Aberdeen Gardens',
		'US1840019849' => 'Ocean Shores',
		'US1840017379' => 'Basin City',
		'US1840022310' => 'Wilkeson',
		'US1840018517' => 'Meadow Glade',
		'US1840037743' => 'Arlington Heights',
		'US1840022316' => 'Uniontown',
		'US1840022314' => 'Oakesdale',
		'US1840037246' => 'West Side Highway',
		'US1840022269' => 'Conconully',
		'US1840021097' => 'Latah',
		'US1840019844' => 'Elma',
		'US1840022319' => 'Tieton',
		'US1840023800' => 'Southworth',
		'US1840037761' => 'Danville',
		'US1840021151' => 'Toppenish',
		'US1840037861' => 'River Road',
		'US1840017291' => 'Geneva',
		'US1840021154' => 'Yakima',
		'US1840037381' => 'Moxee',
		'US1840037645' => 'Edmonds',
		'US1840018502' => 'Kalama',
		'US1840026092' => 'Laurier',
		'US1840018414' => 'Vashon',
		'US1840017334' => 'Country Homes',
		'US1840021081' => 'Darrington',
		'US1840022277' => 'Metaline Falls',
		'US1840017402' => 'Lyle',
		'US1840037865' => 'Cascade Valley',
		'US1840022290' => 'Spangle',
		'US1840025237' => 'Methow',
		'US1840022287' => 'Waterville',
		'US1840037853' => 'Lake Roesiger',
		'US1840019857' => 'Milton',
		'US1840074934' => 'Krupp',
		'US1840037523' => 'Alderton',
		'US1840018457' => 'DuPont',
		'US1840019852' => 'Edgewood',
		'US1840037690' => 'North Puyallup',
		'US1840023817' => 'Pacific Beach',
		'US1840025246' => 'Manson',
		'US1840018359' => 'Brewster',
		'US1840018523' => 'Battle Ground',
		'US1840021118' => 'Shoreline',
		'US1840018448' => 'Cosmopolis',
		'US1840018399' => 'Airway Heights',
		'US1840019871' => 'Grandview',
		'US1840017307' => 'Inchelium',
		'US1840019815' => 'Grand Coulee',
		'US1840025253' => 'Union',
		'US1840026090' => 'Torboy',
		'US1840018503' => 'Kelso',
		'US1840021124' => 'Westport',
		'US1840017362' => 'Junction City',
		'US1840037852' => 'Lake Ketchum',
		'US1840037891' => 'West Pasco',
		'US1840018426' => 'Des Moines',
		'US1840018404' => 'Davenport',
		'US1840021117' => 'Seattle',
		'US1840037894' => 'Lake Stickney',
		'US1840018421' => 'Carnation',
		'US1840019785' => 'Everett',
		'US1840021103' => 'Warden',
		'US1840019863' => 'Palouse',
		'US1840018465' => 'Terrace Heights',
		'US1840018499' => 'Clarkston',
		'US1840021058' => 'Elmer City',
		'US1840019883' => 'Mossyrock',
		'US1840042106' => 'Summit View',
		'US1840018411' => 'Suquamish',
		'US1840019831' => 'Newcastle',
		'US1840021079' => 'Stanwood',
		'US1840023832' => 'Kapowsin',
		'US1840023853' => 'Donald',
		'US1840023875' => 'Altoona',
		'US1840022308' => 'South Prairie',
		'US1840017369' => 'Eschbach',
		'US1840017337' => 'Indianola',
		'US1840021110' => 'Reardan',
		'US1840023852' => 'Cowiche',
		'US1840042107' => 'Sunday Lake',
		'US1840037507' => 'Rocky Point',
		'US1840017383' => 'Burbank',
		'US1840074254' => 'Lakeland North',
		'US1840019787' => 'Granite Falls',
		'US1840018524' => 'Camas',
		'US1840018433' => 'Skokomish',
		'US1840021060' => 'Cusick',
		'US1840021138' => 'Rosalia',
		'US1840023835' => 'Longbranch',
		'US1840019872' => 'Granger',
		'US1840042007' => 'North Fort Lewis',
		'US1840023857' => 'Tampico',
		'US1840021120' => 'Tukwila',
		'US1840022327' => 'Cathlamet',
		'US1840021074' => 'Wenatchee',
		'US1840018388' => 'Port Ludlow',
		'US1840018501' => 'Castle Rock',
		'US1840017292' => 'Glacier',
		'US1840021082' => 'Index',
		'US1840019766' => 'Republic',
		'US1840018417' => 'Bellevue',
		'US1840026093' => 'Malo',
		'US1840041888' => 'Anderson Island',
		'US1840021130' => 'University Place',
		'US1840019847' => 'Montesano',
		'US1840021147' => 'Rainier',
		'US1840017377' => 'Fords Prairie',
		'US1840019856' => 'Roy',
		'US1840018374' => 'Oso',
		'US1840017315' => 'Marblemount',
		'US1840037546' => 'Elk Plain',
		'US1840018367' => 'Burlington',
		'US1840036750' => 'Bangor Base',
		'US1840019838' => 'Beaux Arts Village',
		'US1840042014' => 'Port Gamble Tribal Community',
		'US1840019865' => 'Olympia',
		'US1840019795' => 'East Wenatchee',
		'US1840025238' => 'Addy',
		'US1840018518' => 'Minnehaha',
		'US1840037012' => 'Bryn Mawr-Skyway',
		'US1840018445' => 'Satsop',
		'US1840037860' => 'Riverbend',
		'US1840017354' => 'Easton',
		'US1840018406' => 'Silverdale',
		'US1840019884' => 'Napavine',
		'US1840037500' => 'Lochsloy',
		'US1840019841' => 'Ellensburg',
		'US1840023836' => 'McKenna',
		'US1840021096' => 'Fairfield',
		'US1840042009' => 'Northwest Stanwood',
		'US1840022286' => 'Mansfield',
		'US1840018427' => 'Duvall',
		'US1840017359' => 'Markham',
		'US1840037889' => 'Waller',
		'US1840019904' => 'Longview',
		'US1840019889' => 'Richland',
		'US1840023839' => 'Rosedale',
		'US1840021189' => 'Vancouver',
		'US1840023792' => 'Bethel',
		'US1840018344' => 'Custer',
		'US1840023798' => 'Lofall',
		'US1840037517' => 'Fairwood',
		'US1840021164' => 'Winlock',
		'US1840021128' => 'Sumner',
		'US1840037848' => 'Cottage Lake',
		'US1840042033' => 'Puget Island',
		'US1840037864' => 'Woods Creek',
		'US1840021190' => 'Washougal',
		'US1840037510' => 'Sisco Heights',
		'US1840037842' => 'Canterwood',
		'US1840021153' => 'Wapato',
		'US1840041981' => 'Lower Elochoman',
		'US1840037872' => 'Lake Goodwin',
		'US1840034884' => 'Banks Lake South',
		'US1840018424' => 'Kent',
		'US1840017400' => 'Bickleton',
		'US1840025275' => 'Ryderwood',
		'US1840041913' => 'Cavalero',
		'US1840021068' => 'La Conner',
		'US1840037875' => 'Martha Lake',
		'US1840019814' => 'George',
		'US1840021078' => 'Snohomish',
		'US1840021131' => 'Eatonville',
		'US1840017391' => 'Carson',
		'US1840021108' => 'Almira',
		'US1840019753' => 'Nooksack',
		'US1840037858' => 'Mount Vista',
		'US1840041937' => 'High Bridge',
		'US1840074270' => 'Lakeland South',
		'US1840018423' => 'Kenmore',
		'US1840023937' => 'Neah Bay',
		'US1840023851' => 'Cliffdell',
		'US1840074570' => 'Port Angeles East',
		'US1840018420' => 'Burien',
		'US1840018447' => 'Taholah',
		'US1840023842' => 'Wauna',
		'US1840018479' => 'Connell',
		'US1840023755' => 'Disautel',
		'US1840042040' => 'Santiago',
		'US1840019858' => 'Orting',
		'US1840018361' => 'Colville',
		'US1840019789' => 'Marysville',
		'US1840021174' => 'Walla Walla',
		'US1840021155' => 'Zillah',
		'US1840025242' => 'Curlew',
		'US1840023833' => 'Key Center',
		'US1840025233' => 'Hoodsport',
		'US1840018451' => 'Spanaway',
		'US1840022292' => 'Mattawa',
		'US1840025247' => 'Clallam Bay',
		'US1840037882' => 'Prairie Ridge',
		'US1840018365' => 'Rockport',
		'US1840042090' => 'Stansberry Lake',
		'US1840017356' => 'Copalis Beach',
		'US1840037551' => 'Frederickson',
		'US1840018500' => 'Asotin',
		'US1840019790' => 'Mill Creek',
		'US1840037847' => 'Bell Hill',
		'US1840023785' => 'Green Bluff',
		'US1840025239' => 'Clayton',
		'US1840019859' => 'Puyallup',
		'US1840017399' => 'Hockinson',
		'US1840037893' => 'Lake McMurray',
		'US1840021143' => 'Bucoda',
		'US1840018422' => 'Issaquah',
		'US1840022295' => 'Odessa',
		'US1840037662' => 'Hazel Dell',
		'US1840023837' => 'McMillin',
		'US1840022296' => 'Wilbur',
		'US1840042053' => 'Skamokawa Valley',
		'US1840017401' => 'Centerville',
		'US1840023854' => 'Nile',
		'US1840021094' => 'Spokane Valley',
		'US1840021181' => 'Woodland',
		'US1840037855' => 'Lewisville',
		'US1840018441' => 'Vantage',
		'US1840023795' => 'Gorst',
		'US1840074253' => 'Lake Morton-Berrydale',
		'US1840021061' => 'Ione',
		'US1840041906' => 'Bothell West',
		'US1840023841' => 'Vaughn',
		'US1840018418' => 'Black Diamond',
		'US1840019751' => 'Ferndale',
		'US1840017288' => 'Acme',
		'US1840037727' => 'White Center',
		'US1840073916' => 'Fairchild AFB',
		'US1840019834' => 'Pacific',
		'US1840037769' => 'Glenwood',
		'US1840018458' => 'Colfax',
		'US1840018373' => 'Silvana',
		'US1840019781' => 'Forks',
		'US1840019836' => 'Kirkland',
		'US1840019760' => 'Okanogan',
		'US1840041938' => 'Kayak Point',
		'US1840074663' => 'Union Hill-Novelty Hill',
		'US1840023855' => 'Outlook',
		'US1840041971' => 'Lake Tapps',
		'US1840017355' => 'Cohassett Beach',
		'US1840021057' => 'Tonasket',
		'US1840021150' => 'Sunnyside',
		'US1840136062' => 'Lakeview',
		'US1840022307' => 'Carbonado',
		'US1840019864' => 'Pullman',
		'US1840017318' => 'Blyn',
		'US1840017329' => 'Brinnon',
		'US1840021065' => 'Friday Harbor',
		'US1840018519' => 'Orchards',
		'US1840023838' => 'Purdy',
		'US1840021135' => 'Tekoa',
		'US1840037824' => 'Tanner',
		'US1840018439' => 'Thorp',
		'US1840037617' => 'Artondale',
		'US1840037678' => 'Liberty Lake',
		'US1840018398' => 'Cheney',
		'US1840021115' => 'Sammamish',
		'US1840018440' => 'Cle Elum',
		'US1840023890' => 'Fern Prairie',
		'US1840022291' => 'Waverly',
		'US1840019860' => 'Lakewood',
		'US1840074241' => 'Lake Marcel-Stillwater',
		'US1840017358' => 'Central Park',
		'US1840018387' => 'Bridgeport',
		'US1840042039' => 'Raft Island',
		'US1840041976' => 'Larch Way',
		'US1840037850' => 'Lake Bosworth',
		'US1840017397' => 'Barberton',
		'US1840025248' => 'Sekiu',
		'US1840018379' => 'Brier',
		'US1840021093' => 'Spokane',
		'US1840017342' => 'Fall City',
		'US1840019888' => 'Pasco',
		'US1840021069' => 'Lyman',
		'US1840019848' => 'Oakville',
		'US1840037637' => 'Dash Point',
		'US1840041931' => 'Herron Island',
		'US1840074702' => 'West Clarkston-Highland',
		'US1840019816' => 'Royal City',
		'US1840018521' => 'Venersborg',
		'US1840019845' => 'Hoquiam',
		'US1840025262' => 'Willapa',
		'US1840018389' => 'Quilcene',
		'US1840017317' => 'Freeland',
		'US1840019846' => 'McCleary',
		'US1840136623' => 'Roosevelt',
		'US1840019880' => 'Long Beach',
		'US1840024000' => 'Trout Lake',
		'US1840022270' => 'Coulee Dam',
		'US1840037821' => 'Swede Heaven',
		'US1840043279' => 'Pine Grove',
		'US1840019780' => 'Langley',
		'US1840021066' => 'Sedro-Woolley',
		'US1840021133' => 'Hatton',
		'US1840019777' => 'Entiat',
		'US1840018409' => 'Bainbridge Island',
		'US1840018416' => 'Auburn',
		'US1840018444' => 'Ocean City',
		'US1840018464' => 'White Swan',
		'US1840037495' => 'Felida',
		'US1840019866' => 'Lacey',
		'US1840019786' => 'Gold Bar',
		'US1840018413' => 'Clyde Hill',
		'US1840042136' => 'Upper Elochoman',
		'US1840022273' => 'Marcus',
		'US1840074181' => 'Canyon Creek',
		'US1840026097' => 'Malone',
		'US1840041892' => 'Bothell East',
		'US1840022300' => 'Yarrow Point',
		'US1840025258' => 'Steptoe',
		'US1840021168' => 'West Richland',
		'US1840025243' => 'Orient',
		'US1840019826' => 'Federal Way',
		'US1840022321' => 'Pe Ell',
		'US1840023929' => 'Deep River',
		'US1840018419' => 'Bothell',
		'US1840037106' => 'South Wenatchee',
		'US1840037862' => 'Snoqualmie Pass',
		'US1840021105' => 'Hartline',
		'US1840019837' => 'Lake Forest Park',
		'US1840041924' => 'Crocker',
		'US1840017364' => 'Elbe',
		'US1840018412' => 'Ravensdale',
		'US1840018378' => 'Arlington',
		'US1840073929' => 'McChord AFB',
		'US1840017376' => 'Lebam',
		'US1840019752' => 'Lynden',
		'US1840021075' => 'Coupeville',
		'US1840021175' => 'Prescott',
		'US1840021161' => 'South Bend',
		'US1840019873' => 'Mabton',
		'US1840019833' => 'North Bend',
		'US1840037554' => 'Grapeview',
		'US1840021141' => 'Garfield',
		'US1840018459' => 'Rochester',
		'US1840018486' => 'Dayton',
		'US1840018415' => 'Algona',
		'US1840025263' => 'Mineral',
		'US1840026089' => 'Barstow',
		'US1840018442' => 'Moclips',
		'US1840018346' => 'Bellingham',
		'US1840021163' => 'Vader',
		'US1840037895' => 'North Lynnwood',
		'US1840018408' => 'Tracyton',
		'US1840021191' => 'White Salmon',
		'US1840037896' => 'Peaceful Valley',
		'US1840037866' => 'East Renton Highlands',
		'US1840022276' => 'Metaline',
		'US1840018345' => 'Deming',
		'US1840019804' => 'Medical Lake',
		'US1840018446' => 'Aberdeen',
		'US1840018472' => 'Chehalis',
		'US1840025264' => 'Onalaska',
		'US1840021162' => 'Toledo',
		'US1840019750' => 'Everson',
		'US1840025252' => 'Belfair',
		'US1840019788' => 'Lynnwood',
		'US1840022315' => 'Colton',
		'US1840022313' => 'Malden',
		'US1840037846' => 'Ames Lake',
		'US1840022294' => 'Wilson Creek',
		'US1840037880' => 'North Yelm',
		'US1840037876' => 'Mirrormont',
		'US1840073897' => 'Whidbey Island Station',
		'US1840037888' => 'Town and Country',
		'US1840018469' => 'Tokeland',
		'US1840021119' => 'Snoqualmie',
		'US1840018410' => 'Bremerton',
		'US1840037849' => 'East Cathlamet',
		'US1840073933' => 'Fort Lewis',
		'US1840018520' => 'Salmon Creek',
		'US1840022299' => 'Skykomish',
		'US1840021129' => 'Tacoma',
		'US1840019791' => 'Monroe',
		'US1840025235' => 'Loomis',
		'US1840019891' => 'Pomeroy',
		'US1840017398' => 'Brush Prairie',
		'US1840037898' => 'Silver Firs',
		'US1840022268' => 'Nespelem',
		'US1840023774' => 'Meadowdale',
		'US1840042051' => 'Shadow Lake',
		'US1840037498' => 'LaCrosse',
		'US1840022283' => 'Concrete',
		'US1840021045' => 'Sumas',
		'US1840021132' => 'Ruston',
		'US1840019910' => 'La Center',
		'US1840037856' => 'Marrowstone',
		'US1840025245' => 'Chelan Falls',
		'US1840037851' => 'Lake Cavanaugh',
		'US1840140854' => 'Duluth',
		'US1840021076' => 'Sequim',
		'US1840018480' => 'Benton City',
		'US1840019817' => 'Moses Lake',
		'US1840019854' => 'Fircrest',
		'US1840019862' => 'Othello',
		'US1840019830' => 'Mercer Island',
		'US1840019825' => 'Enumclaw',
		'US1840037630' => 'Chico',
		'US1840023794' => 'Enetai',
		'US1840021122' => 'Hunts Point',
		'US1840037632' => 'Clinton',
		'US1840041926' => 'Hat Island',
		'US1840073928' => 'Marietta-Alderwood',
		'US1840021173' => 'Waitsburg',
		'US1840136960' => 'Sunnyslope',
		'US1840022304' => 'South Cle Elum',
		'US1840021149' => 'Selah',
		'US1840021134' => 'Lind',
		'US1840037869' => 'Five Corners',
		'US1840022272' => 'Winthrop',
		'US1840019832' => 'Normandy Park',
		'US1840023831' => 'Home',
		'US1840017365' => 'Graham',
		'US1840022333' => 'Yacolt',
		'US1840025265' => 'Packwood',
		'US1840037807' => 'Queets',
		'US1840017380' => 'Finley',
		'US1840022274' => 'Northport',
		'US1840019829' => 'Medina',
		'US1840037624' => 'Browns Point',
		'US1840018456' => 'Summit',
		'US1840021136' => 'Albion',
		'US1840037740' => 'Sudden Valley',
		'US1840041912' => 'Bunk Foss',
		'US1840017370' => 'Gleed',
		'US1840017403' => 'Maryhill',
		'US1840037697' => 'Oyehut',
		'US1840023829' => 'Alder',
		'US1840019909' => 'Ridgefield',
		'US1840023772' => 'Bryant',
		'US1840074509' => 'Nisqually Indian Community',
		'US1840023818' => 'Porter',
		'US1840019764' => 'Kettle Falls',
		'US1840018369' => 'Chelan',
		'US1840017314' => 'Edison',
		'US1840018443' => 'Neilton',
		'US1840037870' => 'Fox Island',
		'US1840019827' => 'Renton',
		'US1840017339' => 'Baring',
		'US1840017344' => 'Hobart',
		'US1840018489' => 'Wallula',
		'US1840018488' => 'Touchet',
		'US1840019778' => 'Leavenworth',
		'US1840037736' => 'Fobes Hill',
		'US1840019819' => 'Harrington',
		'US1840019821' => 'Port Orchard',
		'US1840017323' => 'Alderwood Manor',
		'US1840018481' => 'Kennewick',
		'US1840017368' => 'Ahtanum',
		'US1840042145' => 'Wilderness Rim',
		'US1840017325' => 'Machias',
		'US1840018529' => 'Bingen',
		'US1840023784' => 'Four Lakes',
		'US1840022275' => 'Springdale',
		'US1840022312' => 'Washtucna',
		'US1840018425' => 'Covington',
		'US1840025251' => 'Allyn',
		'US1840037859' => 'North Sultan',
		'US1840021152' => 'Union Gap',
		'US1840021123' => 'Shelton',
		'US1840017374' => 'Chinook',
		'US1840018347' => 'Blaine',
		'US1840074571' => 'Port Hadlock-Irondale',
		'US1840023793' => 'Burley',
		'US1840019774' => 'Mount Vernon',
		'US1840021104' => 'Electric City',
		'US1840018438' => 'Ronald',
		'US1840037116' => 'Nespelem Community',
		'US1840023816' => 'Amanda Park',
		'US1840073891' => 'Clarkston Heights-Vineland',
		'US1840037519' => 'Boulevard Park',
		'US1840017313' => 'Big Lake',
		'US1840026091' => 'Boyds',
		'US1840037518' => 'Parkwood',
		'US1840018400' => 'Deer Park',
		'US1840017361' => 'Humptulips',
		'US1840021116' => 'SeaTac',
		'US1840019828' => 'Maple Valley',
		'US1840022289' => 'Millwood',
		'US1840025234' => 'Point Roberts',
		'US1840018487' => 'Dixie',
		'US1840037838' => 'East Port Orchard',
		'US1840019882' => 'Morton',
		'US1840017312' => 'Alger',
		'US1840018478' => 'Kahlotus',
		'US1840037653' => 'Fife Heights',
		'US1840037538' => 'Cherry Grove',
		'US1840023773' => 'Clearview',
		'US1840017343' => 'Greenwater',
		'US1840037897' => 'Picnic Point',
		'US1840017293' => 'Kendall',
		'US1840023799' => 'Seabeck',
		'US1840018380' => 'Startup',
		'US1840022309' => 'Steilacoom',
		'US1840021142' => 'Lamont',
		'US1840037745' => 'Bay View',
		'US1840025241' => 'Valley',
		'US1840037878' => 'North Marysville',
		'US1840017357' => 'Brady',
		'US1840037857' => 'May Creek',
		'US1840023932' => 'Clear Lake',
		'US1840023756' => 'Keller',
		'US1840019835' => 'Redmond',
		'US1840018470' => 'Ilwaco',
		'US1840019792' => 'Mountlake Terrace',
		'US1840023856' => 'Parker',
		'US1840021102' => 'Soap Lake',
		'US1840017366' => 'Grand Mound',
		'US1840017336' => 'Manchester',
		'US1840042027' => 'Prairie Heights',
		'US1840018376' => 'Verlot',
		'US1840037879' => 'North Omak',
		'US1840022318' => 'Naches',
		'US1840037863' => 'Summitview',
		'US1840041920' => 'Clover Creek',
		'US1840019890' => 'Prosser',
		'US1840018467' => 'Naselle',
		'US1840019796' => 'Rock Island',
		'US1840019911' => 'Goldendale',
		'US1840017326' => 'Maltby',
		'US1840019779' => 'Oak Harbor',
		'US1840037899' => 'Tanglewilde',
		'US1840021137' => 'Endicott',
		'US1840041996' => 'Mill Creek East',
		'US1840073925' => 'Maple Heights-Lake Desire',
		'US1840018452' => 'Midland',
		'US1840017338' => 'Kingston',
		'US1840037867' => 'Esperance',
		'US1840023877' => 'Grays River',
		'US1840021080' => 'Sultan',
		'US1840023834' => 'La Grande',
		'US1840019861' => 'Ritzville',
		'US1840025236' => 'Malott',
		'US1840022293' => 'Coulee City',
		'US1840019881' => 'Raymond',
		'US1840023843' => 'Wollochet',
		'US1840019818' => 'Quincy',
		'US1840074693' => 'Walla Walla East',
		'US1840021067' => 'Hamilton',
		'US1840021121' => 'Woodinville',
		'US1840017375' => 'Bay Center',
		'US1840019797' => 'Port Townsend',
		'US1840021059' => 'Riverside',
		'US1840037730' => 'Woodway',
		'US1840042034' => 'Qui-nai-elt Village',
		'US1840021180' => 'Stevenson',
		'US1840018468' => 'Ocean Park',
		'US1840019782' => 'Port Angeles',
		'US1840018454' => 'Bonney Lake',
		'US1840019762' => 'Oroville',
		'US1840017384' => 'Garrett',
		'US1840037126' => 'Otis Orchards-East Farms',
		'US1840018377' => 'Warm Beach',
		'US1840042118' => 'Twin Lakes',
		'US1840017311' => 'Conway',
		'US1840018490' => 'College Place',
		'US1840139116' => 'Eastmont',
		'US1840017290' => 'Maple Falls',
		'US1840019813' => 'Ephrata',
		'US1840023850' => 'Buena',
		'US1840021145' => 'Tumwater',
		'US1840037611' => 'Desert Aire',
		'US1840041966' => 'Lake Holm',
		'US1840019793' => 'Mukilteo',
		'US1840022271' => 'Twisp',
		'US1840037873' => 'Lake Shore',
		'US1840023797' => 'Keyport',
		'US1840019794' => 'Lake Stevens',
		'US1840022325' => 'Starbuck',
		'US1840021156' => 'Harrah',
		'US1840023796' => 'Hansville',
		'US1840017319' => 'Carlsborg',
		'US1840021146' => 'Yelm',
	],
	'DE' => [
		'US1840006063' => 'Fenwick Island',
		'US1840006077' => 'Delmar',
		'US1840005586' => 'Ardencroft',
		'US1840005805' => 'Farmington',
		'US1840005806' => 'Felton',
		'US1840005808' => 'Hartly',
		'US1840028618' => 'Pike Creek',
		'US1840006080' => 'Millville',
		'US1840028616' => 'Highland Acres',
		'US1840073664' => 'Rising Sun-Lebanon',
		'US1840005818' => 'Little Creek',
		'US1840005819' => 'Magnolia',
		'US1840005572' => 'Greenville',
		'US1840005574' => 'Elsmere',
		'US1840005811' => 'Harrington',
		'US1840006071' => 'Seaford',
		'US1840073616' => 'Dover Base Housing',
		'US1840006076' => 'Dagsboro',
		'US1840006069' => 'Milford',
		'US1840006075' => 'Bridgeville',
		'US1840005580' => 'Bellefonte',
		'US1840005820' => 'Smyrna',
		'US1840005575' => 'Wilmington Manor',
		'US1840005577' => 'New Castle',
		'US1840073749' => 'Bowers',
		'US1840006073' => 'Bethel',
		'US1840006083' => 'Selbyville',
		'US1840005809' => 'Houston',
		'US1840073744' => 'Woodside East',
		'US1840003807' => 'Viola',
		'US1840006061' => 'Dewey Beach',
		'US1840005582' => 'Newport',
		'US1840006072' => 'Bethany Beach',
		'US1840028608' => 'Edgemoor',
		'US1840005584' => 'Townsend',
		'US1840006065' => 'Georgetown',
		'US1840005816' => 'Kenton',
		'US1840006066' => 'Greenwood',
		'US1840028615' => 'North Star',
		'US1840006084' => 'Slaughter Beach',
		'US1840005581' => 'Middletown',
		'US1840006074' => 'Blades',
		'US1840005807' => 'Frederica',
		'US1840006070' => 'Rehoboth Beach',
		'US1840006081' => 'Milton',
		'US1840005821' => 'Woodside',
		'US1840005568' => 'Bear',
		'US1840005579' => 'Wilmington',
		'US1840028614' => 'Pike Creek Valley',
		'US1840005804' => 'Rodney Village',
		'US1840006067' => 'Henlopen Acres',
		'US1840006064' => 'Frankford',
		'US1840006079' => 'Millsboro',
		'US1840005571' => 'Glasgow',
		'US1840005815' => 'Clayton',
		'US1840005814' => 'Cheswold',
		'US1840005583' => 'Odessa',
		'US1840028609' => 'Kent Acres',
		'US1840028612' => 'St. Georges',
		'US1840005587' => 'Ardentown',
		'US1840005585' => 'Arden',
		'US1840006062' => 'Ellendale',
		'US1840006068' => 'Lewes',
		'US1840006078' => 'Laurel',
		'US1840005569' => 'Brookside',
		'US1840005822' => 'Wyoming',
		'US1840005570' => 'Claymont',
		'US1840005578' => 'Newark',
		'US1840028617' => 'Long Neck',
		'US1840005813' => 'Camden',
		'US1840005817' => 'Leipsic',
		'US1840005576' => 'Delaware City',
		'US1840006082' => 'Ocean View',
		'US1840006085' => 'South Bethany',
		'US1840005573' => 'Hockessin',
		'US1840028613' => 'Riverview',
		'US1840005810' => 'Dover',
	],
	'DC' => [
		'US1840006060' => 'Washington',
	],
	'WI' => [
		'US1840025282' => 'Stone Lake',
		'US1840002382' => 'Nelson',
		'US1840002968' => 'Fennimore',
		'US1840003016' => 'Chenequa',
		'US1840004348' => 'Helenville',
		'US1840006920' => 'Tichigan',
		'US1840002735' => 'Kekoskee',
		'US1840002225' => 'Wonewoc',
		'US1840024009' => 'St. Peter',
		'US1840002397' => 'Black River Falls',
		'US1840002401' => 'Shiocton',
		'US1840025294' => 'Three Lakes',
		'US1840002617' => 'Waldo',
		'US1840003026' => 'North Prairie',
		'US1840002265' => 'Mattoon',
		'US1840002323' => 'Almond',
		'US1840002110' => 'New Auburn',
		'US1840002732' => 'Hustisford',
		'US1840002408' => 'Little Chute',
		'US1840002262' => 'Birnamwood',
		'US1840002710' => 'Lodi',
		'US1840002386' => 'Whitehall',
		'US1840002716' => 'West Baraboo',
		'US1840002740' => 'Lomira',
		'US1840002736' => 'Brownsville',
		'US1840002106' => 'Bloomer',
		'US1840025287' => 'Wabeno',
		'US1840002476' => 'Whitewater',
		'US1840002216' => 'Reedsville',
		'US1840002324' => 'Amherst',
		'US1840002920' => 'Monona',
		'US1840002289' => 'River Falls',
		'US1840002483' => 'Delavan',
		'US1840003038' => 'Greendale',
		'US1840001999' => 'Couderay',
		'US1840002590' => 'Berlin',
		'US1840001995' => 'Grantsburg',
		'US1840024126' => 'Burnett',
		'US1840025312' => 'Lakewood',
		'US1840002163' => 'Wausau',
		'US1840002976' => 'Livingston',
		'US1840002691' => 'Hillsboro',
		'US1840001998' => 'Exeland',
		'US1840002208' => 'Whitelaw',
		'US1840002484' => 'East Troy',
		'US1840001575' => 'Oconto',
		'US1840002480' => 'Elkhorn',
		'US1840003024' => 'Nashotah',
		'US1840002962' => 'Rewey',
		'US1840002885' => 'Ferryville',
		'US1840002255' => 'Neillsville',
		'US1840002902' => 'Sun Prairie',
		'US1840002568' => 'Wilton',
		'US1840002389' => 'Eleva',
		'US1840037988' => 'Menomonie',
		'US1840003007' => 'Wales',
		'US1840002213' => 'Manitowoc',
		'US1840025434' => 'Ashippun',
		'US1840002232' => 'New Lisbon',
		'US1840042189' => 'New Odanah',
		'US1840002729' => 'Sauk City',
		'US1840023924' => 'Pulcifer',
		'US1840003025' => 'New Berlin',
		'US1840002337' => 'Milladore',
		'US1840003915' => 'Mason',
		'US1840003028' => 'Oconomowoc Lake',
		'US1840002388' => 'Independence',
		'US1840002214' => 'Maribel',
		'US1840003047' => 'Oak Creek',
		'US1840025421' => 'Van Dyne',
		'US1840025272' => 'Pence',
		'US1840002827' => 'Saukville',
		'US1840002739' => 'Clyman',
		'US1840002236' => 'Wild Rose',
		'US1840002727' => 'Reedsburg',
		'US1840002980' => 'Patch Grove',
		'US1840003162' => 'Paddock Lake',
		'US1840002522' => 'New Holstein',
		'US1840000279' => 'Lake Hallie',
		'US1840002334' => 'Hewitt',
		'US1840003020' => 'Menomonee Falls',
		'US1840002887' => 'Eastman',
		'US1840023923' => 'Pella',
		'US1840002593' => 'Princeton',
		'US1840002572' => 'Melvina',
		'US1840003932' => 'Peshtigo',
		'US1840025292' => 'Lake Tomahawk',
		'US1840025289' => 'Long Lake',
		'US1840002916' => 'Maple Bluff',
		'US1840002215' => 'Mishicot',
		'US1840002733' => 'Iron Ridge',
		'US1840003002' => 'Johnson Creek',
		'US1840002734' => 'Juneau',
		'US1840002620' => 'Kohler',
		'US1840023925' => 'Thornton',
		'US1840002410' => 'Seymour',
		'US1840002601' => 'Brandon',
		'US1840002228' => 'Camp Douglas',
		'US1840002164' => 'Hatley',
		'US1840004351' => 'Lake Ripley',
		'US1840024102' => 'Bruce',
		'US1840002134' => 'Hammond',
		'US1840002286' => 'Maiden Rock',
		'US1840002489' => 'Wind Point',
		'US1840002004' => 'Minong',
		'US1840025299' => 'Lewis',
		'US1840025380' => 'Arkdale',
		'US1840002235' => 'Wautoma',
		'US1840002907' => 'Black Earth',
		'US1840002364' => 'Kewaunee',
		'US1840002072' => 'Cumberland',
		'US1840002492' => 'North Bay',
		'US1840023926' => 'Tilleda',
		'US1840025270' => 'Iron Belt',
		'US1840002913' => 'Deerfield',
		'US1840037935' => 'DeForest',
		'US1840002378' => 'Fountain City',
		'US1840024098' => 'Bancroft',
		'US1840002172' => 'Rothschild',
		'US1840023995' => 'Poy Sippi',
		'US1840002361' => 'New London',
		'US1840002287' => 'Plum City',
		'US1840002969' => 'Lancaster',
		'US1840002923' => 'Rockdale',
		'US1840002709' => 'Doylestown',
		'US1840002569' => 'Wyeville',
		'US1840002973' => 'Cassville',
		'US1840003033' => 'Wauwatosa',
		'US1840042155' => 'Diaperville',
		'US1840002365' => 'Casco',
		'US1840002730' => 'Theresa',
		'US1840002051' => 'Centuria',
		'US1840010091' => 'Caledonia',
		'US1840026104' => 'Mole Lake',
		'US1840002169' => 'Edgar',
		'US1840002338' => 'Nekoosa',
		'US1840002998' => 'Sullivan',
		'US1840025357' => 'Greenleaf',
		'US1840002077' => 'Tony',
		'US1840002322' => 'Junction City',
		'US1840004481' => 'Bohners Lake',
		'US1840002580' => 'Rockland',
		'US1840002972' => 'Boscobel',
		'US1840025324' => 'Chili',
		'US1840002008' => 'Kennan',
		'US1840002328' => 'Plover',
		'US1840024191' => 'Hatfield',
		'US1840002886' => 'Bell Center',
		'US1840001565' => 'Antigo',
		'US1840004352' => 'Rome',
		'US1840002161' => 'Spencer',
		'US1840002718' => 'Lake Delton',
		'US1840002395' => 'Hixton',
		'US1840002107' => 'Cadott',
		'US1840025424' => 'Hingham',
		'US1840002109' => 'Cornell',
		'US1840026072' => 'Port Wing',
		'US1840002574' => 'Oakdale',
		'US1840003006' => 'Sussex',
		'US1840002387' => 'Galesville',
		'US1840025381' => 'Dellwood',
		'US1840038094' => 'Middle Village',
		'US1840002380' => 'Cochrane',
		'US1840003023' => 'Muskego',
		'US1840002250' => 'Greenwood',
		'US1840003036' => 'Whitefish Bay',
		'US1840002295' => 'Altoona',
		'US1840002332' => 'Vesper',
		'US1840002075' => 'Rice Lake',
		'US1840002708' => 'Columbus',
		'US1840002604' => 'Campbellsport',
		'US1840004010' => 'New Post',
		'US1840002567' => 'Warrens',
		'US1840002917' => 'Marshall',
		'US1840024031' => 'Allenton',
		'US1840002460' => 'Brodhead',
		'US1840002143' => 'Elk Mound',
		'US1840026073' => 'Clam Lake',
		'US1840002830' => 'Germantown',
		'US1840002970' => 'Bloomington',
		'US1840003929' => 'Crivitz',
		'US1840002259' => 'Wittenberg',
		'US1840025281' => 'Danbury',
		'US1840026068' => 'Drummond',
		'US1840037953' => 'Gilmanton',
		'US1840002918' => 'Mazomanie',
		'US1840002713' => 'Poynette',
		'US1840002293' => 'Fairchild',
		'US1840003011' => 'Elm Grove',
		'US1840025285' => 'Laona',
		'US1840002626' => 'Plymouth',
		'US1840002826' => 'Port Washington',
		'US1840023911' => 'Krakow',
		'US1840002619' => 'Howards Grove',
		'US1840002715' => 'Spring Green',
		'US1840002978' => 'Mount Hope',
		'US1840002245' => 'Omro',
		'US1840002403' => 'Kaukauna',
		'US1840002966' => 'Woodman',
		'US1840000308' => 'Bellevue',
		'US1840025433' => 'Bluffview',
		'US1840004029' => 'Legend Lake',
		'US1840002707' => 'Cambria',
		'US1840003004' => 'Fort Atkinson',
		'US1840002285' => 'Bay City',
		'US1840003048' => 'River Hills',
		'US1840002254' => 'Loyal',
		'US1840002905' => 'Fitchburg',
		'US1840002573' => 'Norwalk',
		'US1840002108' => 'Chippewa Falls',
		'US1840002491' => 'Burlington',
		'US1840002400' => 'Appleton',
		'US1840002468' => 'Edgerton',
		'US1840002363' => 'Scandinavia',
		'US1840002486' => 'Sturtevant',
		'US1840025323' => 'Knowlton',
		'US1840002227' => 'Elroy',
		'US1840002329' => 'Rosholt',
		'US1840002521' => 'Chilton',
		'US1840002957' => 'Barneveld',
		'US1840002383' => 'Arcadia',
		'US1840002694' => 'Coon Valley',
		'US1840003043' => 'Franklin',
		'US1840002971' => 'Blue River',
		'US1840001953' => 'Montreal',
		'US1840002829' => 'West Bend',
		'US1840002490' => 'Elmwood Park',
		'US1840002160' => 'Athens',
		'US1840002138' => 'New Richmond',
		'US1840026083' => 'Baileys Harbor',
		'US1840002723' => 'Merrimac',
		'US1840002922' => 'Oregon',
		'US1840002145' => 'Downing',
		'US1840002009' => 'Catawba',
		'US1840000295' => 'Bowler',
		'US1840002333' => 'Wisconsin Rapids',
		'US1840025387' => 'Tustin',
		'US1840002974' => 'Cuba City',
		'US1840001994' => 'Webster',
		'US1840002819' => 'Lone Rock',
		'US1840002339' => 'Pittsville',
		'US1840002900' => 'Shorewood Hills',
		'US1840003042' => 'Fox Point',
		'US1840001996' => 'Winter',
		'US1840002479' => 'Lake Geneva',
		'US1840003928' => 'Coleman',
		'US1840025478' => 'Springfield',
		'US1840026075' => 'Marengo',
		'US1840001993' => 'Siren',
		'US1840025284' => 'Argonne',
		'US1840025402' => 'Packwaukee',
		'US1840002959' => 'Dodgeville',
		'US1840037983' => 'Marathon City',
		'US1840025399' => 'St. Joseph',
		'US1840002623' => 'Cascade',
		'US1840002066' => 'Turtle Lake',
		'US1840023920' => 'Green Valley',
		'US1840002471' => 'Beloit',
		'US1840002405' => 'Bear Creek',
		'US1840025448' => 'Glen Haven',
		'US1840003032' => 'South Milwaukee',
		'US1840025343' => 'Hager City',
		'US1840025273' => 'Saxon',
		'US1840002344' => 'Green Bay',
		'US1840002462' => 'Browntown',
		'US1840002069' => 'Barron',
		'US1840002726' => 'Prairie du Sac',
		'US1840000309' => 'Suamico',
		'US1840002237' => 'Hancock',
		'US1840002390' => 'Ettrick',
		'US1840002147' => 'Ridgeland',
		'US1840002350' => 'Stockholm',
		'US1840002354' => 'Weyauwega',
		'US1840002911' => 'Cross Plains',
		'US1840002832' => 'Jackson',
		'US1840025301' => 'Barronett',
		'US1840004353' => 'Okauchee Lake',
		'US1840002958' => 'Cobb',
		'US1840003019' => 'Eagle',
		'US1840004480' => 'Eagle Lake',
		'US1840042154' => 'Birch Hill',
		'US1840001561' => 'Tomahawk',
		'US1840002609' => 'Ripon',
		'US1840026065' => 'Gordon',
		'US1840001562' => 'Merrill',
		'US1840002523' => 'Potter',
		'US1840003010' => 'Lac La Belle',
		'US1840002910' => 'Cottage Grove',
		'US1840002342' => 'Ashwaubenon',
		'US1840002050' => 'Balsam Lake',
		'US1840002252' => 'Curtiss',
		'US1840025450' => 'Sandy Hook',
		'US1840002618' => 'Glenbeulah',
		'US1840024010' => 'Taycheedah',
		'US1840002831' => 'Hartford',
		'US1840002611' => 'St. Cloud',
		'US1840002473' => 'Milton',
		'US1840002575' => 'West Salem',
		'US1840002258' => 'Tigerton',
		'US1840003913' => 'Washburn',
		'US1840002622' => 'Adell',
		'US1840003927' => 'Wausaukee',
		'US1840002011' => 'Phillips',
		'US1840026081' => 'Goodman',
		'US1840003001' => 'Jefferson',
		'US1840002282' => 'Spring Valley',
		'US1840001566' => 'White Lake',
		'US1840002903' => 'Verona',
		'US1840002737' => 'Fox Lake',
		'US1840002207' => 'Valders',
		'US1840002883' => 'Wauzeka',
		'US1840001952' => 'Hurley',
		'US1840002915' => 'Madison',
		'US1840003034' => 'West Allis',
		'US1840038104' => 'Maine',
		'US1840002226' => 'Hustler',
		'US1840002049' => 'Amery',
		'US1840023919' => 'Caroline',
		'US1840002745' => 'Reeseville',
		'US1840026071' => 'Iron River',
		'US1840002964' => 'Bagley',
		'US1840002499' => 'Gratiot',
		'US1840002057' => 'Osceola',
		'US1840004030' => 'Neopit',
		'US1840002466' => 'New Glarus',
		'US1840002105' => 'Stanley',
		'US1840001568' => 'Stetsonville',
		'US1840002595' => 'Montello',
		'US1840002012' => 'Prentice',
		'US1840002381' => 'Mondovi',
		'US1840026070' => 'Herbster',
		'US1840002052' => 'Clayton',
		'US1840004478' => 'Como',
		'US1840003041' => 'Brown Deer',
		'US1840025295' => 'Woodruff',
		'US1840002817' => 'Boaz',
		'US1840002592' => 'Marquette',
		'US1840000335' => 'Endeavor',
		'US1840002230' => 'Mauston',
		'US1840003911' => 'Oliver',
		'US1840002345' => 'Howard',
		'US1840002340' => 'Port Edwards',
		'US1840038105' => 'Fox Crossing',
		'US1840025309' => 'Westboro',
		'US1840002884' => 'Gays Mills',
		'US1840025314' => 'Sobieski',
		'US1840002002' => 'Spooner',
		'US1840002165' => 'Elderon',
		'US1840003015' => 'Big Bend',
		'US1840003014' => 'Lannon',
		'US1840024189' => 'Glen Flora',
		'US1840025389' => 'Eureka',
		'US1840003912' => 'Poplar',
		'US1840003935' => 'Sturgeon Bay',
		'US1840004024' => 'Tainter Lake',
		'US1840002168' => 'Abbotsford',
		'US1840038103' => 'Harrison',
		'US1840002482' => 'Darien',
		'US1840026074' => 'Glidden',
		'US1840002076' => 'Sheldon',
		'US1840002404' => 'Kimberly',
		'US1840025423' => 'Greenbush',
		'US1840002356' => 'Iola',
		'US1840002816' => 'Yuba',
		'US1840002607' => 'North Fond du Lac',
		'US1840002346' => 'Allouez',
		'US1840026080' => 'Dunbar',
		'US1840002331' => 'Auburndale',
		'US1840002881' => 'Soldiers Grove',
		'US1840002692' => 'La Farge',
		'US1840002914' => 'McFarland',
		'US1840025360' => 'Waumandee',
		'US1840002982' => 'Potosi',
		'US1840002706' => 'Fall River',
		'US1840002909' => 'Cambridge',
		'US1840002260' => 'Gresham',
		'US1840006753' => 'Zoar',
		'US1840002343' => 'Wrightstown',
		'US1840002206' => 'Two Rivers',
		'US1840002129' => 'Somerset',
		'US1840004479' => 'Delavan Lake',
		'US1840002358' => 'Clintonville',
		'US1840002687' => 'Stoddard',
		'US1840003096' => 'Benton',
		'US1840002703' => 'Wisconsin Dells',
		'US1840002046' => 'Rhinelander',
		'US1840002241' => 'Redgranite',
		'US1840002394' => 'Taylor',
		'US1840025442' => 'Sextonville',
		'US1840002728' => 'Rock Springs',
		'US1840023918' => 'Angelica',
		'US1840042159' => 'Franks Field',
		'US1840002238' => 'Coloma',
		'US1840002603' => 'Fond du Lac',
		'US1840003018' => 'Dousman',
		'US1840002176' => 'Thorp',
		'US1840002070' => 'Cameron',
		'US1840001572' => 'Rib Lake',
		'US1840024306' => 'Richland Center',
		'US1840038024' => 'Somers',
		'US1840002392' => 'Osseo',
		'US1840002048' => 'Frederic',
		'US1840002608' => 'Oakfield',
		'US1840002379' => 'Alma',
		'US1840026066' => 'Cable',
		'US1840004477' => 'Potter Lake',
		'US1840002578' => 'Bangor',
		'US1840003160' => 'Kenosha',
		'US1840002360' => 'Marion',
		'US1840002210' => 'Kiel',
		'US1840002975' => 'Dickeyville',
		'US1840025401' => 'Dalton',
		'US1840002292' => 'Augusta',
		'US1840000291' => 'Boyceville',
		'US1840003097' => 'Blanchardville',
		'US1840002399' => 'Merrillan',
		'US1840002056' => 'Milltown',
		'US1840002627' => 'Random Lake',
		'US1840002493' => 'Racine',
		'US1840002074' => 'Prairie Farm',
		'US1840003163' => 'Pleasant Prairie',
		'US1840002953' => 'Arena',
		'US1840024171' => 'Conrath',
		'US1840002908' => 'Blue Mounds',
		'US1840003035' => 'West Milwaukee',
		'US1840002055' => 'Luck',
		'US1840025396' => 'Cataract',
		'US1840025288' => 'Florence',
		'US1840004028' => 'Keshena',
		'US1840023954' => 'Chain O Lakes',
		'US1840002960' => 'Linden',
		'US1840002139' => 'North Hudson',
		'US1840002478' => 'Genoa City',
		'US1840002178' => 'Withee',
		'US1840002954' => 'Avoca',
		'US1840002610' => 'Rosendale',
		'US1840003936' => 'Egg Harbor',
		'US1840002605' => 'Eden',
		'US1840002888' => 'Lynxville',
		'US1840023996' => 'Forest Junction',
		'US1840003931' => 'Niagara',
		'US1840025277' => 'Sayner',
		'US1840003909' => 'Solon Springs',
		'US1840025276' => 'Boulder Junction',
		'US1840004158' => 'Brice Prairie',
		'US1840025308' => 'Jump River',
		'US1840002209' => 'Kellnersville',
		'US1840023922' => 'Navarino',
		'US1840002833' => 'Kewaskum',
		'US1840002496' => 'Argyle',
		'US1840002693' => 'Chaseburg',
		'US1840003098' => 'Darlington',
		'US1840003046' => 'Milwaukee',
		'US1840002921' => 'Mount Horeb',
		'US1840002402' => 'Hortonville',
		'US1840003003' => 'Lake Mills',
		'US1840025447' => 'Edmund',
		'US1840002741' => 'Lowell',
		'US1840002597' => 'Oxford',
		'US1840003049' => 'St. Francis',
		'US1840002621' => 'Elkhart Lake',
		'US1840002130' => 'Star Prairie',
		'US1840002690' => 'Genoa',
		'US1840002233' => 'Friendship',
		'US1840001571' => 'Medford',
		'US1840002711' => 'Pardeeville',
		'US1840002744' => 'Randolph',
		'US1840003937' => 'Forestville',
		'US1840002738' => 'Beaver Dam',
		'US1840025449' => 'Kieler',
		'US1840025302' => 'Elcho',
		'US1840002906' => 'Belleville',
		'US1840025303' => 'Post Lake',
		'US1840026085' => 'Little Sturgeon',
		'US1840026084' => 'Ellison Bay',
		'US1840038102' => 'Mount Pleasant',
		'US1840004347' => 'Hebron',
		'US1840002702' => 'Arlington',
		'US1840023955' => 'King',
		'US1840002142' => 'Knapp',
		'US1840002288' => 'Prescott',
		'US1840002912' => 'Dane',
		'US1840042467' => 'Lake Sherwood',
		'US1840002377' => 'Buffalo City',
		'US1840003017' => 'Delafield',
		'US1840025363' => 'Millston',
		'US1840025313' => 'Mountain',
		'US1840002131' => 'Wilson',
		'US1840002494' => 'Rochester',
		'US1840002133' => 'Glenwood City',
		'US1840002697' => 'Readstown',
		'US1840002247' => 'Sherwood',
		'US1840002353' => 'Waupaca',
		'US1840002461' => 'Brooklyn',
		'US1840024030' => 'Waubeka',
		'US1840002588' => 'Green Lake',
		'US1840002000' => 'Radisson',
		'US1840025291' => 'Ogema',
		'US1840002818' => 'Cazenovia',
		'US1840002606' => 'Mount Calvary',
		'US1840002171' => 'Mosinee',
		'US1840025322' => 'Downsville',
		'US1840024275' => 'Tunnel City',
		'US1840002967' => 'Hazel Green',
		'US1840002251' => 'Colby',
		'US1840024196' => 'Ingram',
		'US1840025286' => 'Newald',
		'US1840002384' => 'Strum',
		'US1840042465' => 'Lake Ivanhoe',
		'US1840002229' => 'Lyndon Station',
		'US1840002242' => 'Winneconne',
		'US1840002136' => 'Baldwin',
		'US1840025342' => 'Diamond Bluff',
		'US1840025382' => 'Grand Marsh',
		'US1840026082' => 'Pembine',
		'US1840002487' => 'Union Grove',
		'US1840003040' => 'Hales Corners',
		'US1840025391' => 'Winchester',
		'US1840002625' => 'Oostburg',
		'US1840004349' => 'Ixonia',
		'US1840002231' => 'Necedah',
		'US1840002834' => 'Newburg',
		'US1840002705' => 'Friesland',
		'US1840003031' => 'Shorewood',
		'US1840002253' => 'Dorchester',
		'US1840002141' => 'Wheeler',
		'US1840002010' => 'Park Falls',
		'US1840002520' => 'Brillion',
		'US1840002359' => 'Manawa',
		'US1840024435' => 'Weyerhaeuser',
		'US1840002882' => 'Steuben',
		'US1840002005' => 'Crandon',
		'US1840002067' => 'Haugen',
		'US1840003933' => 'Pound',
		'US1840002731' => 'Horicon',
		'US1840002256' => 'Owen',
		'US1840003095' => 'Belmont',
		'US1840002714' => 'Rio',
		'US1840001567' => 'Algoma',
		'US1840002464' => 'Monroe',
		'US1840002463' => 'Albany',
		'US1840002261' => 'Eland',
		'US1840026064' => 'Brule',
		'US1840002815' => 'Viola',
		'US1840002366' => 'Luxemburg',
		'US1840002956' => 'Hollandale',
		'US1840002391' => 'Blair',
		'US1840002465' => 'Monticello',
		'US1840002477' => 'Williams Bay',
		'US1840002628' => 'Sheboygan',
		'US1840002341' => 'Rudolph',
		'US1840038097' => 'Rib Mountain',
		'US1840002058' => 'St. Croix Falls',
		'US1840002320' => 'Stevens Point',
		'US1840002565' => 'Sparta',
		'US1840002240' => 'Plainfield',
		'US1840002355' => 'Fremont',
		'US1840002566' => 'Tomah',
		'US1840003008' => 'Waukesha',
		'US1840002234' => 'Adams',
		'US1840025359' => 'Dyckesville',
		'US1840002577' => 'La Crosse',
		'US1840002385' => 'Trempealeau',
		'US1840003012' => 'Brookfield',
		'US1840001573' => 'Suring',
		'US1840002249' => 'Hilbert',
		'US1840002688' => 'Viroqua',
		'US1840002472' => 'Clinton',
		'US1840003039' => 'Greenfield',
		'US1840002919' => 'Middleton',
		'US1840002696' => 'Ontario',
		'US1840002979' => 'Muscoda',
		'US1840004482' => 'Browns Lake',
		'US1840042463' => 'Lake Arrowhead',
		'US1840000280' => 'Boyd',
		'US1840025436' => 'Lebanon',
		'US1840002981' => 'Platteville',
		'US1840003045' => 'Cudahy',
		'US1840002721' => 'Lime Ridge',
		'US1840025307' => 'Chelsea',
		'US1840002467' => 'Janesville',
		'US1840025311' => 'Abrams',
		'US1840004157' => 'French Island',
		'US1840042476' => 'Lauderdale Lakes',
		'US1840003918' => 'Mellen',
		'US1840001997' => 'Hayward',
		'US1840025364' => 'Dale',
		'US1840000277' => 'Lena',
		'US1840002144' => 'Colfax',
		'US1840023956' => 'Northport',
		'US1840002724' => 'North Freedom',
		'US1840033457' => 'Fontana-on-Geneva Lake',
		'US1840025474' => 'Hanover',
		'US1840002719' => 'La Valle',
		'US1840003000' => 'Watertown',
		'US1840072793' => 'Summit',
		'US1840004011' => 'Reserve',
		'US1840002889' => 'Mount Sterling',
		'US1840002321' => 'Whiting',
		'US1840004085' => 'Lake Wazeecha',
		'US1840001982' => 'Eagle River',
		'US1840025271' => 'Mercer',
		'US1840001576' => 'Oconto Falls',
		'US1840025293' => 'Minocqua',
		'US1840003930' => 'Marinette',
		'US1840026079' => 'Amberg',
		'US1840002717' => 'Ironton',
		'US1840002257' => 'Aniwa',
		'US1840002488' => 'Waterford',
		'US1840002001' => 'Shell Lake',
		'US1840002330' => 'Arpin',
		'US1840002497' => 'Shullsburg',
		'US1840002409' => 'Nichols',
		'US1840001844' => 'Ephraim',
		'US1840025473' => 'Juda',
		'US1840038028' => 'Springbrook',
		'US1840002362' => 'Ogdensburg',
		'US1840002357' => 'Big Falls',
		'US1840026069' => 'Grand View',
		'US1840002248' => 'Stockbridge',
		'US1840025377' => 'Collins',
		'US1840002246' => 'Oshkosh',
		'US1840025283' => 'Trego',
		'US1840038100' => 'Hobart',
		'US1840002722' => 'Loganville',
		'US1840003916' => 'Ashland',
		'US1840002695' => 'De Soto',
		'US1840002629' => 'Sheboygan Falls',
		'US1840002576' => 'Holmen',
		'US1840002135' => 'Hudson',
		'US1840003013' => 'Butler',
		'US1840025386' => 'Pine River',
		'US1840006921' => 'Wind Lake',
		'US1840002689' => 'Westby',
		'US1840026067' => 'Cornucopia',
		'US1840002352' => 'Pepin',
		'US1840038054' => 'Wiota',
		'US1840002712' => 'Portage',
		'US1840002239' => 'Lohrville',
		'US1840025388' => 'Butte des Morts',
		'US1840002822' => 'Fredonia',
		'US1840025317' => 'Holcombe',
		'US1840002296' => 'Eau Claire',
		'US1840003917' => 'Butternut',
		'US1840038034' => 'Superior',
		'US1840002137' => 'Deer Park',
		'US1840025441' => 'Gotham',
		'US1840002071' => 'Chetek',
		'US1840003021' => 'Merton',
		'US1840002961' => 'Mineral Point',
		'US1840025320' => 'Emerald',
		'US1840002173' => 'Schofield',
		'US1840002243' => 'Menasha',
		'US1840002284' => 'Elmwood',
		'US1840025358' => 'Arkansaw',
		'US1840025304' => 'Summit Lake',
		'US1840002167' => 'Fenwood',
		'US1840002600' => 'Waupun',
		'US1840025356' => 'Babcock',
		'US1840037989' => 'Mequon',
		'US1840000310' => 'Embarrass',
		'US1840002348' => 'De Pere',
		'US1840002999' => 'Waterloo',
		'US1840002326' => 'Nelsonville',
		'US1840002335' => 'Biron',
		'US1840002570' => 'Kendall',
		'US1840002591' => 'Markesan',
		'US1840033459' => 'Pewaukee',
		'US1840002485' => 'Sharon',
		'US1840003914' => 'Bayfield',
		'US1840002179' => 'Granton',
		'US1840002469' => 'Evansville',
		'US1840025315' => 'Townsend',
		'US1840003009' => 'Hartland',
		'US1840002244' => 'Neenah',
		'US1840002475' => 'Walworth',
		'US1840001570' => 'Lublin',
		'US1840025318' => 'Jim Falls',
		'US1840002211' => 'Francis Creek',
		'US1840025481' => 'Woodford',
		'US1840002140' => 'Roberts',
		'US1840002053' => 'Clear Lake',
		'US1840002264' => 'Cecil',
		'US1840004021' => 'Lake Wissota',
		'US1840002890' => 'Prairie du Chien',
		'US1840002073' => 'Dallas',
		'US1840002349' => 'Pulaski',
		'US1840004537' => 'Powers Lake',
		'US1840002396' => 'Alma Center',
		'US1840004007' => 'Lac du Flambeau',
		'US1840004009' => 'Little Round Lake',
		'US1840002393' => 'Pigeon Falls',
		'US1840002825' => 'Cedarburg',
		'US1840002266' => 'Shawano',
		'US1840001569' => 'Gilman',
		'US1840002294' => 'Fall Creek',
		'US1840002351' => 'Durand',
		'US1840004012' => 'Chief Lake',
		'US1840025361' => 'Dodge',
		'US1840002336' => 'Marshfield',
		'US1840002901' => 'Stoughton',
		'US1840001574' => 'Gillett',
		'US1840002704' => 'Wyocena',
		'US1840002347' => 'Denmark',
		'US1840003037' => 'Glendale',
		'US1840002003' => 'Birchwood',
		'US1840025390' => 'Waukau',
		'US1840003027' => 'Oconomowoc',
		'US1840003934' => 'Sister Bay',
		'US1840003910' => 'Lake Nebagamon',
		'US1840002398' => 'Melrose',
		'US1840002217' => 'St. Nazianz',
		'US1840002977' => 'Montfort',
		'US1840037916' => 'Bristol',
		'US1840002955' => 'Highland',
		'US1840004203' => 'Lake Wisconsin',
		'US1840002283' => 'Ellsworth',
		'US1840002080' => 'Hawkins',
		'US1840002835' => 'Richfield',
		'US1840002474' => 'Orfordville',
		'US1840002470' => 'Footville',
		'US1840002725' => 'Plain',
		'US1840002571' => 'Cashton',
		'US1840002904' => 'Waunakee',
		'US1840002742' => 'Mayville',
		'US1840002407' => 'Combined Locks',
		'US1840003044' => 'Bayside',
		'US1840002596' => 'Neshkoro',
		'US1840002177' => 'Unity',
		'US1840006867' => 'Windsor',
		'US1840002823' => 'Grafton',
		'US1840002720' => 'Baraboo',
		'US1840002963' => 'Ridgeway',
		'US1840043424' => 'Bloomfield',
		'US1840002579' => 'Onalaska',
		'US1840002068' => 'Almena',
		'US1840006564' => 'Odanah',
		'US1840002828' => 'Slinger',
		'US1840002602' => 'Fairwater',
		'US1840042464' => 'Lake Camelot',
		'US1840002824' => 'Belgium',
		'US1840025321' => 'Houlton',
		'US1840002965' => 'Tennyson',
		'US1840002082' => 'Ladysmith',
		'US1840002624' => 'Cedar Grove',
		'US1840023921' => 'Leopolis',
		'US1840002132' => 'Woodville',
		'US1840042466' => 'Lake Lorraine',
		'US1840002212' => 'Cleveland',
		'US1840002224' => 'Union Center',
		'US1840025422' => 'Gibbsville',
		'US1840002406' => 'Black Creek',
		'US1840003159' => 'Twin Lakes',
		'US1840002498' => 'South Wayne',
		'US1840003022' => 'Mukwonago',
		'US1840002821' => 'Thiensville',
		'US1840002162' => 'Stratford',
		'US1840002743' => 'Neosho',
		'US1840002325' => 'Amherst Junction',
		'US1840002589' => 'Kingston',
		'US1840038093' => 'Weston',
		'US1840002327' => 'Park Ridge',
		'US1840003005' => 'Palmyra',
		'US1840002054' => 'Dresser',
		'US1840025325' => 'Humbird',
		'US1840038099' => 'Kronenwetter',
		'US1840002263' => 'Bonduel',
		'US1840025310' => 'Whittlesey',
		'US1840025355' => 'Polonia',
		'US1840004350' => 'Lake Koshkonong',
		'US1840002594' => 'Westfield',
	],
	'WV' => [
		'US1840038214' => 'Arbovale',
		'US1840038223' => 'Bruno',
		'US1840006227' => 'Summersville',
		'US1840025590' => 'Aurora',
		'US1840006382' => 'Oceana',
		'US1840006191' => 'Pinch',
		'US1840025736' => 'Roderfield',
		'US1840006183' => 'Poca',
		'US1840025731' => 'Berwind',
		'US1840005883' => 'Philippi',
		'US1840006383' => 'Pineville',
		'US1840005478' => 'Wellsburg',
		'US1840025734' => 'Maybeury',
		'US1840005730' => 'Farmington',
		'US1840025609' => 'Middleway',
		'US1840025610' => 'Shannondale',
		'US1840006422' => 'Welch',
		'US1840005788' => 'Williamstown',
		'US1840006271' => 'Hamlin',
		'US1840005789' => 'North Hills',
		'US1840005477' => 'Follansbee',
		'US1840005775' => 'West Milford',
		'US1840005646' => 'Granville',
		'US1840006155' => 'Hillsboro',
		'US1840005929' => 'Elizabeth',
		'US1840005886' => 'Hambleton',
		'US1840006263' => 'Kenova',
		'US1840005780' => 'West Union',
		'US1840005512' => 'Triadelphia',
		'US1840005747' => 'Middlebourne',
		'US1840005732' => 'Fairmont',
		'US1840038300' => 'West Logan',
		'US1840006050' => 'Mason',
		'US1840006353' => 'Rhodell',
		'US1840005740' => 'Inwood',
		'US1840005673' => 'Smithfield',
		'US1840025663' => 'Salt Rock',
		'US1840005931' => 'Jane Lew',
		'US1840025660' => 'Rand',
		'US1840006355' => 'Chattaroy',
		'US1840025687' => 'Greenview',
		'US1840005791' => 'Harrisville',
		'US1840006306' => 'Danville',
		'US1840005733' => 'Mannington',
		'US1840006402' => 'Princeton',
		'US1840006357' => 'Gilbert Creek',
		'US1840005660' => 'Tunnelton',
		'US1840025631' => 'Dailey',
		'US1840005764' => 'Enterprise',
		'US1840006356' => 'Red Jacket',
		'US1840025661' => 'Shrewsbury',
		'US1840025601' => 'Falling Waters',
		'US1840025634' => 'Pickens',
		'US1840025685' => 'Scarbro',
		'US1840006401' => 'Bluefield',
		'US1840006204' => 'Chesapeake',
		'US1840005884' => 'Belington',
		'US1840025676' => 'Beards Fork',
		'US1840006115' => 'Burnsville',
		'US1840006352' => 'Mabscott',
		'US1840025684' => 'Prince',
		'US1840006184' => 'Winfield',
		'US1840006385' => 'Peterstown',
		'US1840038206' => 'St. George',
		'US1840025640' => 'Apple Grove',
		'US1840006308' => 'Whitesville',
		'US1840005653' => 'Brandonville',
		'US1840006386' => 'Union',
		'US1840005904' => 'Moorefield',
		'US1840025670' => 'Tioga',
		'US1840005731' => 'Grant Town',
		'US1840006202' => 'Belle',
		'US1840006362' => 'Matewan',
		'US1840005654' => 'Bruceton Mills',
		'US1840038156' => 'Omar',
		'US1840005998' => 'Glenville',
		'US1840005905' => 'Wardensville',
		'US1840006110' => 'Spencer',
		'US1840006190' => 'Cross Lanes',
		'US1840005784' => 'Lubeck',
		'US1840005722' => 'Wiley Ford',
		'US1840006114' => 'Gassaway',
		'US1840005735' => 'Barrackville',
		'US1840005723' => 'Keyser',
		'US1840025643' => 'Brandywine',
		'US1840073754' => 'Womelsdorf',
		'US1840025706' => 'Verdunville',
		'US1840006051' => 'New Haven',
		'US1840025707' => 'Bolt',
		'US1840025616' => 'Wolf Summit',
		'US1840073280' => 'Bath',
		'US1840006421' => 'War',
		'US1840025633' => 'Helvetia',
		'US1840006046' => 'Hartford City',
		'US1840006296' => 'Mount Hope',
		'US1840005481' => 'Beech Bottom',
		'US1840038236' => 'Deep Water',
		'US1840025677' => 'Boomer',
		'US1840025596' => 'Burlington',
		'US1840006381' => 'Mullens',
		'US1840025641' => 'Gallipolis Ferry',
		'US1840005658' => 'Rowlesburg',
		'US1840005724' => 'Carpendale',
		'US1840005651' => 'Kingwood',
		'US1840005790' => 'Ellenboro',
		'US1840006195' => 'Sissonville',
		'US1840006087' => 'Franklin',
		'US1840006154' => 'Durbin',
		'US1840006335' => 'Switzer',
		'US1840038218' => 'Big Sandy',
		'US1840006403' => 'Athens',
		'US1840038284' => 'New Richmond',
		'US1840006194' => 'Handley',
		'US1840025720' => 'Glen Fork',
		'US1840006368' => 'Hinton',
		'US1840005652' => 'Albright',
		'US1840025597' => 'Carolina',
		'US1840005671' => 'Paden City',
		'US1840006426' => 'Iaeger',
		'US1840025605' => 'Springfield',
		'US1840025721' => 'Kopperston',
		'US1840025650' => 'Bartow',
		'US1840006287' => 'White Sulphur Springs',
		'US1840006338' => 'Man',
		'US1840006288' => 'Alderson',
		'US1840038140' => 'Hilltop',
		'US1840025686' => 'Comfort',
		'US1840005721' => 'Elk Garden',
		'US1840038183' => 'Wallace',
		'US1840025669' => 'Nettie',
		'US1840038182' => 'Twilight',
		'US1840006044' => 'Grantsville',
		'US1840005794' => 'Cairo',
		'US1840006345' => 'Bradley',
		'US1840025704' => 'Monaville',
		'US1840005649' => 'Blacksville',
		'US1840006008' => 'Ripley',
		'US1840006205' => 'Clendenin',
		'US1840006302' => 'Thurmond',
		'US1840006196' => 'Charleston',
		'US1840006424' => 'Bradshaw',
		'US1840005778' => 'Flemington',
		'US1840006333' => 'Holden',
		'US1840006294' => 'Gauley Bridge',
		'US1840006212' => 'Milton',
		'US1840006159' => 'Cowen',
		'US1840005787' => 'Vienna',
		'US1840006354' => 'Sophia',
		'US1840005757' => 'Capon Bridge',
		'US1840006347' => 'Prosperity',
		'US1840005742' => 'Martinsburg',
		'US1840133782' => 'Tornado',
		'US1840038252' => 'Hometown',
		'US1840073632' => 'Mount Gay-Shamrock',
		'US1840006305' => 'Madison',
		'US1840006201' => 'St. Albans',
		'US1840005769' => 'Shinnston',
		'US1840005729' => 'Fairview',
		'US1840005999' => 'Sand Fork',
		'US1840006361' => 'Kermit',
		'US1840025683' => 'Page',
		'US1840005994' => 'Mill Creek',
		'US1840006284' => 'Falling Spring',
		'US1840005862' => 'Bayard',
		'US1840005648' => 'Westover',
		'US1840005782' => 'Boaz',
		'US1840005655' => 'Masontown',
		'US1840005553' => 'Benwood',
		'US1840005785' => 'Washington',
		'US1840006344' => 'Beaver',
		'US1840006301' => 'Pax',
		'US1840005670' => 'New Martinsville',
		'US1840006349' => 'Stanaford',
		'US1840038310' => 'Jefferson',
		'US1840006290' => 'Rainelle',
		'US1840038146' => 'Kimberly',
		'US1840025711' => 'Helen',
		'US1840025712' => 'Justice',
		'US1840005557' => 'Moundsville',
		'US1840038266' => 'MacArthur',
		'US1840038243' => 'Fairlea',
		'US1840006185' => 'Clay',
		'US1840005992' => 'Beverly',
		'US1840006116' => 'Sutton',
		'US1840006197' => 'Dunbar',
		'US1840005657' => 'Reedsville',
		'US1840038297' => 'Vivian',
		'US1840006406' => 'Oakvale',
		'US1840005795' => 'Pullman',
		'US1840005772' => 'Lost Creek',
		'US1840038269' => 'Matheny',
		'US1840038289' => 'Raysal',
		'US1840006334' => 'Mallory',
		'US1840005768' => 'Salem',
		'US1840006113' => 'Flatwoods',
		'US1840038311' => 'Pea Ridge',
		'US1840005888' => 'Parsons',
		'US1840038307' => 'Glen Dale',
		'US1840025732' => 'Crumpler',
		'US1840005554' => 'Cameron',
		'US1840006419' => 'Gary',
		'US1840025662' => 'Lesage',
		'US1840025618' => 'Waverly',
		'US1840025593' => 'Reader',
		'US1840006156' => 'Marlinton',
		'US1840005766' => 'Bridgeport',
		'US1840006350' => 'Beckley',
		'US1840005513' => 'West Liberty',
		'US1840005993' => 'Huttonsville',
		'US1840006289' => 'Quinwood',
		'US1840025680' => 'Hico',
		'US1840006423' => 'Anawalt',
		'US1840025688' => 'Racine',
		'US1840025598' => 'Idamay',
		'US1840025651' => 'Cass',
		'US1840006213' => 'Barboursville',
		'US1840038170' => 'Rossmore',
		'US1840025611' => 'Shenandoah Junction',
		'US1840006272' => 'West Hamlin',
		'US1840005719' => 'Paw Paw',
		'US1840025635' => 'Valley Bend',
		'US1840005861' => 'Petersburg',
		'US1840006047' => 'Henderson',
		'US1840038161' => 'Piney View',
		'US1840038308' => 'Ranson',
		'US1840025653' => 'Green Bank',
		'US1840005793' => 'Auburn',
		'US1840006336' => 'Logan',
		'US1840006198' => 'Marmet',
		'US1840006337' => 'Chapmanville',
		'US1840038107' => 'Accoville',
		'US1840025604' => 'Green Spring',
		'US1840006405' => 'Matoaka',
		'US1840006179' => 'Eleanor',
		'US1840006292' => 'Powellton',
		'US1840006307' => 'Sylvester',
		'US1840005672' => 'Pine Grove',
		'US1840005762' => 'Belmont',
		'US1840006286' => 'Ronceverte',
		'US1840005669' => 'Hundred',
		'US1840005726' => 'Piedmont',
		'US1840006298' => 'Smithers',
		'US1840005402' => 'Newell',
		'US1840038275' => 'Mitchell Heights',
		'US1840005990' => 'Harman',
		'US1840006270' => 'Harts',
		'US1840025730' => 'Bartley',
		'US1840005792' => 'Pennsboro',
		'US1840005511' => 'Valley Grove',
		'US1840005403' => 'Chester',
		'US1840006189' => 'Coal Fork',
		'US1840006285' => 'Lewisburg',
		'US1840005889' => 'Thomas',
		'US1840005759' => 'Charles Town',
		'US1840025701' => 'Big Creek',
		'US1840006264' => 'Wayne',
		'US1840006200' => 'South Charleston',
		'US1840005771' => 'Anmoore',
		'US1840038221' => 'Brenton',
		'US1840025678' => 'Glen Ferris',
		'US1840005510' => 'Wheeling',
		'US1840005758' => 'Harpers Ferry',
		'US1840005514' => 'Bethlehem',
		'US1840025708' => 'Eccles',
		'US1840005479' => 'Bethany',
		'US1840006300' => 'Meadow Bridge',
		'US1840038147' => 'Lashmeet',
		'US1840005734' => 'Pleasant Valley',
		'US1840025710' => 'Glen White',
		'US1840038277' => 'Mount Carbon',
		'US1840006049' => 'Leon',
		'US1840005656' => 'Newburg',
		'US1840005760' => 'Bolivar',
		'US1840005647' => 'Morgantown',
		'US1840025702' => 'Henlawson',
		'US1840025623' => 'Century',
		'US1840025703' => 'Kistler',
		'US1840006428' => 'Northfork',
		'US1840025733' => 'Cucumber',
		'US1840038312' => 'Teays Valley',
		'US1840025719' => 'Corinne',
		'US1840006351' => 'Lester',
		'US1840006181' => 'Bancroft',
		'US1840038205' => 'Robinette',
		'US1840005767' => 'Clarksburg',
		'US1840005480' => 'Windsor Heights',
		'US1840006193' => 'Glasgow',
		'US1840005997' => 'Buckhannon',
		'US1840005515' => 'Clearview',
		'US1840006404' => 'Bramwell',
		'US1840006203' => 'Cedar Grove',
		'US1840006360' => 'Delbarton',
		'US1840005781' => 'Blennerhassett',
		'US1840005643' => 'Brookhaven',
		'US1840038227' => 'Chauncey',
		'US1840005885' => 'Junior',
		'US1840038286' => 'Parcoal',
		'US1840038220' => 'Bluewell',
		'US1840025637' => 'Whitmer',
		'US1840005773' => 'Lumberport',
		'US1840006291' => 'Rupert',
		'US1840025632' => 'East Dailey',
		'US1840025665' => 'Belva',
		'US1840006293' => 'Fayetteville',
		'US1840006182' => 'Buffalo',
		'US1840025679' => 'Glen Jean',
		'US1840005745' => 'Friendly',
		'US1840025673' => 'Crum',
		'US1840005736' => 'Monongah',
		'US1840025614' => 'Hepzibah',
		'US1840025666' => 'Birch River',
		'US1840005770' => 'Stonewood',
		'US1840025709' => 'Ghent',
		'US1840005645' => 'Cheat Lake',
		'US1840005741' => 'Hedgesville',
		'US1840006111' => 'Reedy',
		'US1840006297' => 'Oak Hill',
		'US1840025658' => 'Big Chimney',
		'US1840025674' => 'Lavalette',
		'US1840006187' => 'Elkview',
		'US1840038119' => 'Charlton Heights',
		'US1840006348' => 'Shady Spring',
		'US1840006048' => 'Point Pleasant',
		'US1840005739' => 'Worthington',
		'US1840038256' => 'Itmann',
		'US1840006007' => 'Ravenswood',
		'US1840025667' => 'Dixie',
		'US1840006261' => 'Fort Gay',
		'US1840005783' => 'Mineralwells',
		'US1840006211' => 'Huntington',
		'US1840006210' => 'Culloden',
		'US1840025652' => 'Frank',
		'US1840005765' => 'Despard',
		'US1840005890' => 'Davis',
		'US1840038235' => 'Covel',
		'US1840006192' => 'East Bank',
		'US1840006199' => 'Nitro',
		'US1840005405' => 'Weirton',
		'US1840073750' => 'Camden-on-Gauley',
		'US1840005659' => 'Terra Alta',
		'US1840025654' => 'Huntersville',
		'US1840006359' => 'Williamson',
		'US1840038179' => 'Stollings',
		'US1840006206' => 'Pratt',
		'US1840005786' => 'Parkersburg',
		'US1840038276' => 'Montgomery',
		'US1840025589' => 'Pentress',
		'US1840025615' => 'Spelter',
		'US1840006262' => 'Ceredo',
		'US1840005644' => 'Cassville',
		'US1840025592' => 'Littleton',
		'US1840006346' => 'Crab Orchard',
		'US1840025675' => 'Prichard',
		'US1840025735' => 'Pageton',
		'US1840025700' => 'Amherstdale',
		'US1840005404' => 'New Cumberland',
		'US1840006299' => 'Ansted',
		'US1840005761' => 'Shepherdstown',
		'US1840006225' => 'Craigsville',
		'US1840025630' => 'Bowden',
		'US1840006188' => 'Alum Creek',
		'US1840025659' => 'Chelyan',
		'US1840006226' => 'Richwood',
		'US1840006358' => 'Gilbert',
		'US1840038126' => 'Daniels',
		'US1840038155' => 'Neibert',
		'US1840005476' => 'Hooverson Heights',
		'US1840025655' => 'Bergoo',
		'US1840006427' => 'Kimball',
		'US1840025599' => 'Rachel',
		'US1840005727' => 'Ridgeley',
		'US1840005887' => 'Hendricks',
		'US1840005991' => 'Elkins',
		'US1840005774' => 'Nutter Fort',
		'US1840005779' => 'Grafton',
		'US1840025681' => 'Kincaid',
		'US1840005720' => 'Fort Ashby',
		'US1840005650' => 'Star City',
		'US1840038271' => 'McConnell',
		'US1840025613' => 'Gypsy',
		'US1840025624' => 'Galloway',
		'US1840006400' => 'Montcalm',
		'US1840006180' => 'Hurricane',
		'US1840006420' => 'Keystone',
		'US1840025636' => 'Valley Head',
		'US1840005738' => 'White Hall',
		'US1840025594' => 'Great Cacapon',
		'US1840005556' => 'McMechen',
		'US1840005763' => 'St. Marys',
		'US1840025689' => 'Van',
		'US1840038232' => 'Coal City',
		'US1840025705' => 'Sarah Ann',
		'US1840025718' => 'Bud',
		'US1840038244' => 'Falls View',
		'US1840073748' => 'Addison',
		'US1840005756' => 'Romney',
		'US1840005930' => 'Weston',
		'US1840005746' => 'Sistersville',
		'US1840025591' => 'Jacksonburg',
		'US1840025668' => 'Fenwick',
		'US1840005737' => 'Rivesville',
		'US1840006425' => 'Davy',
		'US1840005995' => 'Montrose',
		'US1840038224' => 'Brush Fork',
	],
	'HI' => [
		'US1840029536' => 'Paauilo',
		'US1840029592' => 'Discovery Harbour',
		'US1840029566' => 'Haena',
		'US1840029548' => 'Ualapue',
		'US1840029555' => 'Waikane',
		'US1840029583' => 'Kapalua',
		'US1840029531' => 'Nanakuli',
		'US1840029544' => 'Puhi',
		'US1840039268' => 'West Loch Estate',
		'US1840029577' => 'Ewa Gentry',
		'US1840029503' => 'Keaau',
		'US1840023208' => 'Puako',
		'US1840029479' => 'Hauula',
		'US1840029533' => 'Omao',
		'US1840137080' => 'Makakilo',
		'US1840075052' => 'Schofield Barracks',
		'US1840029578' => 'Ewa Villages',
		'US1840029487' => 'Kaaawa',
		'US1840029481' => 'Heeia',
		'US1840023258' => 'Waipahu',
		'US1840023232' => 'Kahului',
		'US1840029491' => 'Kahuku',
		'US1840023251' => 'Pearl City',
		'US1840029468' => 'Ahuimanu',
		'US1840029492' => 'Kalaheo',
		'US1840023227' => 'Maunaloa',
		'US1840023191' => 'Captain Cook',
		'US1840029500' => 'Kapaau',
		'US1840074990' => 'Haiku-Pauwela',
		'US1840029480' => 'Hawi',
		'US1840023249' => 'Mililani Town',
		'US1840029567' => 'Wainiha',
		'US1840029542' => 'Papaikou',
		'US1840029584' => 'Kawela Bay',
		'US1840023197' => 'Honomu',
		'US1840029490' => 'Kahaluu',
		'US1840029579' => 'Halawa',
		'US1840029537' => 'Pahala',
		'US1840023234' => 'Lahaina',
		'US1840023213' => 'Hanalei',
		'US1840029483' => 'Honokaa',
		'US1840023209' => 'Volcano',
		'US1840029586' => 'Pupukea',
		'US1840029514' => 'Laie',
		'US1840023193' => 'Hilo',
		'US1840029580' => 'Hawaiian Beaches',
		'US1840023226' => 'Kaunakakai',
		'US1840137122' => 'Waimea',
		'US1840137106' => 'Punaluu',
		'US1840029585' => 'Makaha Valley',
		'US1840029513' => 'Kurtistown',
		'US1840137116' => 'Wailua',
		'US1840029499' => 'Kapaa',
		'US1840075025' => 'Kaneohe Station',
		'US1840029540' => 'Pakala Village',
		'US1840013305' => 'Honolulu',
		'US1840025210' => 'Wailea',
		'US1840029474' => 'Haleiwa',
		'US1840029571' => 'Fern Forest',
		'US1840075021' => 'Kahaluu-Keauhou',
		'US1840029588' => 'Waimalu',
		'US1840029539' => 'Paia',
		'US1840023223' => 'Princeville',
		'US1840029561' => 'Waiohinu',
		'US1840029512' => 'Kukuihaele',
		'US1840025211' => 'Kapolei',
		'US1840029471' => 'Eleele',
		'US1840023206' => 'Paukaa',
		'US1840042830' => 'Kalaeloa',
		'US1840029564' => 'Whitmore Village',
		'US1840029470' => 'Ewa Beach',
		'US1840029538' => 'Pahoa',
		'US1840029519' => 'Lihue',
		'US1840075054' => 'Wheeler AFB',
		'US1840029552' => 'Waianae',
		'US1840029570' => 'Fern Acres',
		'US1840029488' => 'Kaanapali',
		'US1840029475' => 'Haliimaile',
		'US1840029569' => 'Eden Roc',
		'US1840023195' => 'Honalo',
		'US1840029520' => 'Maalaea',
		'US1840029516' => 'Launiupoko',
		'US1840039259' => 'Waikele',
		'US1840029469' => 'Aiea',
		'US1840029506' => 'Keokea',
		'US1840029574' => 'Nanawale Estates',
		'US1840029510' => 'Koloa',
		'US1840039182' => 'Ko Olina',
		'US1840029581' => 'Hawaiian Ocean View',
		'US1840029556' => 'Waikapu',
		'US1840029558' => 'Waimanalo',
		'US1840075010' => 'Honaunau-Napoopoo',
		'US1840039181' => 'East Honolulu',
		'US1840029478' => 'Hanapepe',
		'US1840029476' => 'Hana',
		'US1840029582' => 'Hawaiian Paradise Park',
		'US1840029530' => 'Naalehu',
		'US1840029589' => 'Waipio',
		'US1840023218' => 'Kekaha',
		'US1840029511' => 'Kualapuu',
		'US1840029507' => 'Kihei',
		'US1840029529' => 'Mountain View',
		'US1840029501' => 'Kaumakani',
		'US1840025209' => 'Olowalu',
		'US1840029591' => 'Wailua Homesteads',
		'US1840023236' => 'Makawao',
		'US1840029545' => 'Pukalani',
		'US1840039207' => 'Manele',
		'US1840029575' => 'Orchidlands Estates',
		'US1840039188' => 'Kula',
		'US1840137108' => 'Royal Kunia',
		'US1840029523' => 'Makaha',
		'US1840039224' => 'Mililani Mauka',
		'US1840029528' => 'Mokuleia',
		'US1840029525' => 'Makena',
		'US1840037549' => 'Waihee-Waiehu',
		'US1840039242' => 'Ocean Pointe',
		'US1840029559' => 'Waimanalo Beach',
		'US1840029482' => 'Holualoa',
		'US1840039244' => 'Olinda',
		'US1840029493' => 'Kalaoa',
		'US1840029504' => 'Kealakekua',
		'US1840029495' => 'Kalihiwai',
		'US1840023207' => 'Pepeekeo',
		'US1840023244' => 'Kailua',
		'US1840029498' => 'Kaneohe',
		'US1840075038' => 'Napili-Honokowai',
		'US1840029560' => 'Wainaku',
		'US1840075009' => 'Hickam Housing',
		'US1840029572' => 'Hawaiian Acres',
		'US1840029517' => 'Laupahoehoe',
		'US1840023239' => 'Wailuku',
		'US1840023255' => 'Waialua',
		'US1840029573' => 'Leilani Estates',
		'US1840029473' => 'Halaula',
		'US1840029543' => 'Poipu',
		'US1840029518' => 'Lawai',
		'US1840029522' => 'Maili',
		'US1840023211' => 'Anahola',
		'US1840029562' => 'Waipio Acres',
		'US1840029590' => 'Iroquois Point',
		'US1840029550' => 'Wahiawa',
		'US1840029568' => 'Ainaloa',
		'US1840029515' => 'Lanai City',
		'US1840029526' => 'Maunawili',
		'US1840039205' => 'Mahinahina',
		'US1840029508' => 'Kilauea',
		'US1840029477' => 'Hanamaulu',
		'US1840029587' => 'Waikoloa Village',
	],
	'FL' => [
		'US1840029060' => 'North Key Largo',
		'US1840015945' => 'Trenton',
		'US1840016004' => 'Wilton Manors',
		'US1840025111' => 'Chumuckla',
		'US1840015958' => 'Sanford',
		'US1840017215' => 'Micanopy',
		'US1840016001' => 'Tamarac',
		'US1840029019' => 'Asbury Lake',
		'US1840017179' => 'Wausau',
		'US1840015902' => 'Mary Esther',
		'US1840029088' => 'Timber Pines',
		'US1840017278' => 'Surfside',
		'US1840015943' => 'Waldo',
		'US1840029073' => 'Sawgrass',
		'US1840014078' => 'Mims',
		'US1840029001' => 'Royal Palm Estates',
		'US1840025119' => 'Roeville',
		'US1840015140' => 'Parkland',
		'US1840029062' => 'Oak Ridge',
		'US1840027008' => 'Fidelis',
		'US1840015009' => 'Niceville',
		'US1840014113' => 'Crystal Springs',
		'US1840015010' => 'Laurel Hill',
		'US1840025115' => 'Munson',
		'US1840029105' => 'High Point',
		'US1840028798' => 'Beacon Square',
		'US1840014159' => 'Ruskin',
		'US1840014247' => 'Olympia Heights',
		'US1840015021' => 'Midway',
		'US1840029024' => 'Brownsville',
		'US1840015125' => 'Palm Beach Gardens',
		'US1840015897' => 'Marianna',
		'US1840026004' => 'Aucilla',
		'US1840014070' => 'Heathrow',
		'US1840029006' => 'South Highpoint',
		'US1840015929' => 'Live Oak',
		'US1840073271' => 'West Vero Corridor',
		'US1840014179' => 'Fruitville',
		'US1840014097' => 'Pine Castle',
		'US1840028917' => 'Progress Village',
		'US1840026031' => 'Panacea',
		'US1840015938' => 'Wewahitchka',
		'US1840014181' => 'Vamo',
		'US1840015982' => 'Tampa',
		'US1840014194' => 'Rio',
		'US1840013957' => 'Laguna Beach',
		'US1840015070' => 'DeBary',
		'US1840015133' => 'Cooper City',
		'US1840073844' => 'Inverness Highlands South',
		'US1840013917' => 'Myrtle Grove',
		'US1840026044' => 'Raleigh',
		'US1840028991' => 'Lely Resort',
		'US1840017244' => 'Kenneth City',
		'US1840015900' => 'Campbellton',
		'US1840015086' => 'Center Hill',
		'US1840014185' => 'Nokomis',
		'US1840029095' => 'West DeLand',
		'US1840015999' => 'Margate',
		'US1840014209' => 'Harlem',
		'US1840014095' => 'Lockhart',
		'US1840014182' => 'Venice Gardens',
		'US1840015142' => 'Plantation',
		'US1840015127' => 'Lake Worth',
		'US1840025109' => 'Berrydale',
		'US1840017253' => 'Hypoluxo',
		'US1840014064' => 'Lecanto',
		'US1840014058' => 'Hernando',
		'US1840014041' => 'Glencoe',
		'US1840028974' => 'Buenaventura Lakes',
		'US1840014046' => 'Astor',
		'US1840014128' => 'Bartow',
		'US1840029083' => 'Suncoast Estates',
		'US1840029046' => 'Kensington Park',
		'US1840015132' => 'Coconut Creek',
		'US1840016007' => 'Sunny Isles Beach',
		'US1840015005' => 'Pensacola',
		'US1840017279' => 'Horseshoe Beach',
		'US1840017164' => 'Ponce de Leon',
		'US1840014211' => 'St. James City',
		'US1840073835' => 'Fort Pierce South',
		'US1840015151' => 'Miami Gardens',
		'US1840015114' => 'Largo',
		'US1840042855' => 'Cabana Colony',
		'US1840029029' => 'Country Club',
		'US1840029110' => 'St. Augustine South',
		'US1840014066' => 'Lake Panasoffkee',
		'US1840017230' => 'Montverde',
		'US1840029070' => 'Ridge Wood Heights',
		'US1840029034' => 'Feather Sound',
		'US1840014145' => 'Gulfport',
		'US1840015144' => 'Hollywood',
		'US1840018305' => 'South Palm Beach',
		'US1840014069' => 'Geneva',
		'US1840013920' => 'Gulf Breeze',
		'US1840015109' => 'Kissimmee',
		'US1840013122' => 'Elfers',
		'US1840014248' => 'Princeton',
		'US1840014107' => 'Lake Lindsey',
		'US1840017274' => 'Medley',
		'US1840029050' => 'Lake Sarasota',
		'US1840017161' => 'Esto',
		'US1840028993' => 'Manatee Road',
		'US1840073889' => 'Indian Creek',
		'US1840014151' => 'Brandon',
		'US1840028995' => 'Pebble Creek',
		'US1840015155' => 'North Miami Beach',
		'US1840014094' => 'Lake Hart',
		'US1840018337' => 'Virginia Gardens',
		'US1840013115' => 'East Palatka',
		'US1840018212' => 'Shalimar',
		'US1840018304' => 'Sewalls Point',
		'US1840015006' => 'Milton',
		'US1840014131' => 'Medulla',
		'US1840029009' => 'The Hammocks',
		'US1840014076' => 'Merritt Island',
		'US1840029074' => 'Silver Lake',
		'US1840013911' => 'Goulding',
		'US1840027016' => 'Mulat',
		'US1840026030' => 'Steinhatchee',
		'US1840029104' => 'Franklin Park',
		'US1840014089' => 'Tildenville',
		'US1840017178' => 'Ebro',
		'US1840014116' => 'Jasmine Estates',
		'US1840014096' => 'Orlovista',
		'US1840029056' => 'Manasota Key',
		'US1840026008' => 'Waukeenah',
		'US1840014233' => 'Naples Park',
		'US1840017225' => 'McIntosh',
		'US1840015994' => 'Haverhill',
		'US1840015906' => 'Vernon',
		'US1840013119' => 'Doctor Phillips',
		'US1840015998' => 'Lighthouse Point',
		'US1840014036' => 'Bunnell',
		'US1840014149' => 'Apollo Beach',
		'US1840014038' => 'Fanning Springs',
		'US1840014037' => 'Williston Highlands',
		'US1840014204' => 'Lake Harbor',
		'US1840029111' => 'St. George Island',
		'US1840014138' => 'Celebration',
		'US1840025157' => 'Homeland',
		'US1840015992' => 'South Bay',
		'US1840015102' => 'New Port Richey',
		'US1840038852' => 'Black Hammock',
		'US1840025144' => 'Seville',
		'US1840015139' => 'Oakland Park',
		'US1840015104' => 'Davenport',
		'US1840014132' => 'Poinciana',
		'US1840014043' => 'Edgewater',
		'US1840015991' => 'Briny Breezes',
		'US1840042918' => 'Windsor',
		'US1840014221' => 'Matlacha',
		'US1840015098' => 'Ocoee',
		'US1840017233' => 'Melbourne Beach',
		'US1840014112' => 'Brooksville',
		'US1840014223' => 'Pine Island Center',
		'US1840013118' => 'De Leon Springs',
		'US1840015091' => 'Cape Canaveral',
		'US1840028779' => 'South Apopka',
		'US1840014035' => 'Flagler Beach',
		'US1840017280' => 'Cross City',
		'US1840014137' => 'Campbell',
		'US1840038917' => 'Heritage Pines',
		'US1840014252' => 'Tavernier',
		'US1840014249' => 'Richmond Heights',
		'US1840013943' => 'Gretna',
		'US1840013921' => 'Wright',
		'US1840029038' => 'Gladeview',
		'US1840028650' => 'Charlotte Park',
		'US1840017202' => 'Mayo',
		'US1840018330' => 'Bal Harbour',
		'US1840042858' => 'Lake Mystic',
		'US1840013915' => 'West Pensacola',
		'US1840013924' => 'Bonifay',
		'US1840016005' => 'Bay Harbor Islands',
		'US1840015099' => 'Orlando',
		'US1840015977' => 'St. Petersburg',
		'US1840028977' => 'Cheval',
		'US1840014139' => 'Yeehaw Junction',
		'US1840014045' => 'Altoona',
		'US1840014217' => 'Captiva',
		'US1840029086' => 'Taylor Creek',
		'US1840015976' => 'St. Pete Beach',
		'US1840028968' => 'Siesta Key',
		'US1840015962' => 'Titusville',
		'US1840014238' => 'Glenvar Heights',
		'US1840014084' => 'Christmas',
		'US1840015079' => 'Lake Helen',
		'US1840014237' => 'Hallandale Beach',
		'US1840014246' => 'Naranja',
		'US1840015007' => 'Crestview',
		'US1840028705' => 'Ives Estates',
		'US1840014074' => 'June Park',
		'US1840025118' => 'Point Baker',
		'US1840014193' => 'Port Salerno',
		'US1840015062' => 'Palatka',
		'US1840013104' => 'Ensley',
		'US1840017267' => 'Palm Beach',
		'US1840015084' => 'Crystal River',
		'US1840015068' => 'Daytona Beach',
		'US1840018308' => 'Palm Springs',
		'US1840017227' => 'Ponce Inlet',
		'US1840014216' => 'Buckingham',
		'US1840015117' => 'Holmes Beach',
		'US1840015116' => 'Palmetto',
		'US1840014212' => 'Fort Myers Shores',
		'US1840017255' => 'Jupiter',
		'US1840028982' => 'Fish Hawk',
		'US1840018289' => 'Highland Park',
		'US1840018334' => 'Miami Shores',
		'US1840014158' => 'Riverview',
		'US1840017247' => 'Orchid',
		'US1840015969' => 'San Antonio',
		'US1840014127' => 'Auburndale',
		'US1840014199' => 'Solana',
		'US1840039118' => 'Viera East',
		'US1840017240' => 'Lake Hamilton',
		'US1840014122' => 'Highland City',
		'US1840014226' => 'Fort Myers',
		'US1840015989' => 'Venice',
		'US1840038939' => 'Island Walk',
		'US1840039045' => 'Oakleaf Plantation',
		'US1840014090' => 'Union Park',
		'US1840015953' => 'Tavares',
		'US1840015968' => 'Zephyrhills',
		'US1840015115' => 'Plant City',
		'US1840014197' => 'Harbour Heights',
		'US1840017259' => 'Lantana',
		'US1840017269' => 'Fort Myers Beach',
		'US1840029081' => 'South Sarasota',
		'US1840017177' => 'Caryville',
		'US1840073827' => 'East Williston',
		'US1840015069' => 'Daytona Beach Shores',
		'US1840018310' => 'Tequesta',
		'US1840017223' => 'Yankeetown',
		'US1840042854' => 'Acacia Villas',
		'US1840028994' => 'Paradise Heights',
		'US1840026007' => 'Wacissa',
		'US1840017235' => 'Grant-Valkaria',
		'US1840073269' => 'Egypt Lake-Leto',
		'US1840029078' => 'Southgate',
		'US1840014240' => 'South Miami Heights',
		'US1840014135' => 'Frostproof',
		'US1840014065' => 'The Villages',
		'US1840014187' => 'Arcadia',
		'US1840014103' => 'Istachatta',
		'US1840013124' => 'Ellenton',
		'US1840014230' => 'Immokalee',
		'US1840025112' => 'East Milton',
		'US1840014054' => 'Eustis',
		'US1840017165' => 'Paxton',
		'US1840042878' => 'San Castle',
		'US1840015930' => 'Branford',
		'US1840029032' => 'Cypress Lake',
		'US1840014075' => 'Sharpes',
		'US1840028796' => 'Westwood Lakes',
		'US1840029098' => 'Westview',
		'US1840014162' => 'Wabasso',
		'US1840017266' => 'Ocean Ridge',
		'US1840017206' => 'Orange Park',
		'US1840018275' => 'Reddick',
		'US1840014186' => 'Osprey',
		'US1840015966' => 'Winter Park',
		'US1840015955' => 'Webster',
		'US1840073890' => 'Islamorada, Village of Islands',
		'US1840014072' => 'Altamonte Springs',
		'US1840015972' => 'Madeira Beach',
		'US1840073826' => 'East Lake-Orient Park',
		'US1840013958' => 'Callaway',
		'US1840025125' => 'Crawfordville',
		'US1840014040' => 'Belleview',
		'US1840014055' => 'Fruitland Park',
		'US1840015087' => 'Coleman',
		'US1840015923' => 'Springfield',
		'US1840015936' => 'St. Augustine Beach',
		'US1840014142' => 'Tierra Verde',
		'US1840073823' => 'Dade City North',
		'US1840029052' => 'Lely',
		'US1840013929' => 'Fernandina Beach',
		'US1840014082' => 'Azalea Park',
		'US1840014157' => 'Mango',
		'US1840013923' => 'Fort Walton Beach',
		'US1840028633' => 'Belleair Shore',
		'US1840014105' => 'Spring Hill',
		'US1840038846' => 'Bear Creek',
		'US1840014251' => 'Big Pine Key',
		'US1840013129' => 'Estero',
		'US1840027007' => 'Cobbtown',
		'US1840027010' => 'Wallace',
		'US1840029040' => 'Gulf Gate Estates',
		'US1840014049' => 'Mount Plymouth',
		'US1840025152' => 'Trilby',
		'US1840014180' => 'South Venice',
		'US1840013126' => 'Cypress Quarters',
		'US1840028825' => 'Forest City',
		'US1840013112' => 'Eastpoint',
		'US1840017268' => 'Palm Beach Shores',
		'US1840014098' => 'Pine Hills',
		'US1840017221' => 'Marineland',
		'US1840014220' => 'Lehigh Acres',
		'US1840015975' => 'Safety Harbor',
		'US1840015089' => 'Oviedo',
		'US1840029000' => 'Ridgecrest',
		'US1840014206' => 'Belle Glade',
		'US1840016000' => 'Sunrise',
		'US1840013910' => 'Gonzalez',
		'US1840018309' => 'Royal Palm Beach',
		'US1840043095' => 'Pea Ridge',
		'US1840015987' => 'Wauchula',
		'US1840014144' => 'Dunedin',
		'US1840015158' => 'Hialeah Gardens',
		'US1840014125' => 'Wahneta',
		'US1840017232' => 'Malabar',
		'US1840025170' => 'Ona',
		'US1840029114' => 'Westlake',
		'US1840015112' => 'Pinellas Park',
		'US1840017229' => 'Lady Lake',
		'US1840028981' => 'Fisher Island',
		'US1840018335' => 'Palmetto Bay',
		'US1840029035' => 'Florida Ridge',
		'US1840017237' => 'Eatonville',
		'US1840017180' => 'Hilliard',
		'US1840014178' => 'Fort Pierce',
		'US1840014146' => 'Belleair Beach',
		'US1840015077' => 'Port Orange',
		'US1840028992' => 'Limestone Creek',
		'US1840015058' => 'Newberry',
		'US1840017152' => 'Greenwood',
		'US1840017189' => 'White Springs',
		'US1840017231' => 'Indialantic',
		'US1840015075' => 'Orange City',
		'US1840016010' => 'Marathon',
		'US1840015110' => 'Clearwater',
		'US1840013108' => 'Crescent Beach',
		'US1840014091' => 'Wedgefield',
		'US1840015048' => 'Port St. Joe',
		'US1840028790' => 'Valrico',
		'US1840029092' => 'Villas',
		'US1840015922' => 'Lynn Haven',
		'US1840073270' => 'Richmond West',
		'US1840015030' => 'Neptune Beach',
		'US1840029084' => 'Sunset',
		'US1840013125' => 'Cortez',
		'US1840015917' => 'Madison',
		'US1840015035' => 'Panama City Beach',
		'US1840014071' => 'Chuluota',
		'US1840014243' => 'Aventura',
		'US1840015949' => 'Williston',
		'US1840025156' => 'Fuller Heights',
		'US1840015153' => 'North Bay Village',
		'US1840015011' => 'DeFuniak Springs',
		'US1840038903' => 'Greenbriar',
		'US1840015095' => 'Rockledge',
		'US1840018333' => 'Key Biscayne',
		'US1840015159' => 'Homestead',
		'US1840028983' => 'Fountainebleau',
		'US1840029108' => 'Roosevelt Gardens',
		'US1840029112' => 'Dickerson City',
		'US1840014083' => 'Bithlo',
		'US1840028988' => 'Lake Belvedere Estates',
		'US1840018256' => 'Raiford',
		'US1840035778' => 'Southeast Arcadia',
		'US1840029069' => 'Pretty Bayou',
		'US1840017254' => 'Juno Beach',
		'US1840015067' => 'Ocala',
		'US1840015120' => 'North Port',
		'US1840011791' => 'Bay Lake',
		'US1840028980' => 'East Lake',
		'US1840017243' => 'Indian Shores',
		'US1840029082' => 'Stock Island',
		'US1840073842' => 'Hutchinson Island South',
		'US1840027022' => 'Cedar Grove',
		'US1840013925' => 'Miramar Beach',
		'US1840073870' => 'Nassau Village-Ratliff',
		'US1840073825' => 'East Bronson',
		'US1840017250' => 'Longboat Key',
		'US1840001841' => 'Sun City Center',
		'US1840029093' => 'Weeki Wachee Gardens',
		'US1840014228' => 'Golden Gate',
		'US1840014218' => 'San Carlos Park',
		'US1840073860' => 'Lake Mack-Forest Hills',
		'US1840015126' => 'Riviera Beach',
		'US1840014121' => 'Odessa',
		'US1840029106' => 'Hillsboro Pines',
		'US1840016002' => 'West Park',
		'US1840014166' => 'Avon Park',
		'US1840035801' => 'Zephyrhills West',
		'US1840014214' => 'Alva',
		'US1840028841' => 'Olga',
		'US1840015049' => 'Keystone Heights',
		'US1840029076' => 'South Bradenton',
		'US1840016008' => 'Sweetwater',
		'US1840015008' => 'Destin',
		'US1840025110' => 'Brownsdale',
		'US1840029055' => 'McGregor',
		'US1840028949' => 'Silver Springs Shores',
		'US1840014156' => 'Lutz',
		'US1840029049' => 'Lake Magdalene',
		'US1840025153' => 'Alturas',
		'US1840015973' => 'Belleair',
		'US1840029020' => 'Bay Hill',
		'US1840029021' => 'Big Coppitt Key',
		'US1840015094' => 'Palm Bay',
		'US1840134894' => 'Whitfield',
		'US1840013123' => 'Dover',
		'US1840015160' => 'Key Colony Beach',
		'US1840038926' => 'Horizon West',
		'US1840028916' => 'Hill n Dale',
		'US1840017150' => 'Cottondale',
		'US1840015920' => 'Baldwin',
		'US1840015940' => 'Starke',
		'US1840039133' => 'Viera West',
		'US1840029011' => 'Three Oaks',
		'US1840025168' => 'Lemon Grove',
		'US1840014093' => 'Apopka',
		'US1840038864' => 'Fleming Island',
		'US1840014044' => 'Ferndale',
		'US1840013127' => 'Englewood',
		'US1840014196' => 'Grove City',
		'US1840029103' => 'Boulevard Gardens',
		'US1840015121' => 'Moore Haven',
		'US1840039134' => 'West Lealman',
		'US1840015979' => 'South Pasadena',
		'US1840025165' => 'Fort Green Springs',
		'US1840039063' => 'Pioneer',
		'US1840017275' => 'Miami Lakes',
		'US1840015154' => 'North Miami',
		'US1840017276' => 'Cutler Bay',
		'US1840017188' => 'Jennings',
		'US1840015100' => 'Lake Buena Vista',
		'US1840015970' => 'Winter Haven',
		'US1840015985' => 'Vero Beach',
		'US1840014136' => 'Haines City',
		'US1840014225' => 'Punta Rassa',
		'US1840015028' => 'Jasper',
		'US1840014042' => 'Ormond-by-the-Sea',
		'US1840018328' => 'Southwest Ranches',
		'US1840017264' => 'Glen Ridge',
		'US1840017224' => 'Otter Creek',
		'US1840073828' => 'Eglin AFB',
		'US1840013914' => 'Warrington',
		'US1840017277' => 'Golden Beach',
		'US1840028919' => 'Willow Oak',
		'US1840014195' => 'Buckhead Ridge',
		'US1840014061' => 'Beverly Hills',
		'US1840028997' => 'Pine Ridge',
		'US1840015090' => 'Lake Mary',
		'US1840013955' => 'Watertown',
		'US1840025108' => 'Allentown',
		'US1840029077' => 'South Brooksville',
		'US1840013998' => 'Middleburg',
		'US1840015935' => 'St. Augustine',
		'US1840015059' => 'Hawthorne',
		'US1840015912' => 'Havana',
		'US1840015964' => 'Maitland',
		'US1840036141' => 'Marco Island',
		'US1840015161' => 'Key West',
		'US1840018331' => 'Biscayne Park',
		'US1840014126' => 'Waverly',
		'US1840017207' => 'Penney Farms',
		'US1840015020' => 'Chattahoochee',
		'US1840015096' => 'Indian Harbour Beach',
		'US1840013956' => 'Atlantic Beach',
		'US1840014123' => 'Inwood',
		'US1840039091' => 'Rio Pinar',
		'US1840029043' => 'Holden Heights',
		'US1840013926' => 'Freeport',
		'US1840015157' => 'Hialeah',
		'US1840014092' => 'Zellwood',
		'US1840029107' => 'Northdale',
		'US1840017187' => 'Greenville',
		'US1840015988' => 'Sarasota',
		'US1840028972' => 'Andrews',
		'US1840014148' => 'Gibsonton',
		'US1840015150' => 'Miami Beach',
		'US1840073845' => 'Bellair-Meadowbrook Terrace',
		'US1840042909' => 'Westgate',
		'US1840014120' => 'Land O Lakes',
		'US1840013912' => 'Bellview',
		'US1840015978' => 'Seminole',
		'US1840073857' => 'Zephyrhills North',
		'US1840015085' => 'Inverness',
		'US1840014109' => 'Nobleton',
		'US1840017234' => 'Melbourne Village',
		'US1840038841' => 'Bardmoor',
		'US1840039030' => 'Navarre Beach',
		'US1840014087' => 'Tangelo Park',
		'US1840028976' => 'Charleston Park',
		'US1840029028' => 'Coral Terrace',
		'US1840015903' => 'Valparaiso',
		'US1840042856' => 'Kenwood Estates',
		'US1840014253' => 'Key Largo',
		'US1840015124' => 'Pahokee',
		'US1840014190' => 'Jensen Beach',
		'US1840025149' => 'Aripeka',
		'US1840014133' => 'Eagle Lake',
		'US1840014250' => 'Florida City',
		'US1840043092' => 'Garcon Point',
		'US1840015130' => 'Cape Coral',
		'US1840029066' => 'Pinewood',
		'US1840014062' => 'Citrus Springs',
		'US1840018336' => 'Pinecrest',
		'US1840015956' => 'Wildwood',
		'US1840015913' => 'Tallahassee',
		'US1840013972' => 'St. Augustine Shores',
		'US1840015015' => 'Chipley',
		'US1840018288' => 'St. Leo',
		'US1840014020' => 'Alachua',
		'US1840013922' => 'Ocean City',
		'US1840014068' => 'Fern Park',
		'US1840014153' => 'Seffner',
		'US1840028978' => 'Citrus Hills',
		'US1840036152' => 'Jupiter Inlet Colony',
		'US1840029075' => 'South Beach',
		'US1840013928' => 'Yulee',
		'US1840014053' => 'Pittman',
		'US1840029013' => 'University Park',
		'US1840015898' => 'Alford',
		'US1840029072' => 'Sarasota Springs',
		'US1840017149' => 'Malone',
		'US1840134890' => 'White City',
		'US1840029097' => 'West Samoset',
		'US1840014086' => 'Taft',
		'US1840015072' => 'Deltona',
		'US1840014160' => 'Gifford',
		'US1840028632' => 'Bee Ridge',
		'US1840015046' => 'Perry',
		'US1840015022' => 'Quincy',
		'US1840015088' => 'Casselberry',
		'US1840014060' => 'Homosassa Springs',
		'US1840073847' => 'Cocoa West',
		'US1840015947' => 'Beverly Beach',
		'US1840015967' => 'Weeki Wachee',
		'US1840014154' => 'Thonotosassa',
		'US1840038863' => 'Flagler Estates',
		'US1840015123' => 'Delray Beach',
		'US1840025169' => 'Limestone',
		'US1840017236' => 'Palm Shores',
		'US1840017163' => 'Noma',
		'US1840014169' => 'Samoset',
		'US1840029002' => 'Schall Circle',
		'US1840015033' => 'Mexico Beach',
		'US1840073877' => 'Everglades',
		'US1840015984' => 'Sebastian',
		'US1840029099' => 'Whiskey Creek',
		'US1840018311' => 'Wellington',
		'US1840015146' => 'Lauderhill',
		'US1840017251' => 'Jupiter Island',
		'US1840029085' => 'Tamiami',
		'US1840014164' => 'Roseland',
		'US1840015965' => 'Winter Garden',
		'US1840014130' => 'Loughman',
		'US1840027011' => 'Woodlawn Beach',
		'US1840029061' => 'North Sarasota',
		'US1840038904' => 'Grenelefe',
		'US1840014168' => 'Bayshore Gardens',
		'US1840014191' => 'North River Shores',
		'US1840029047' => 'Lakeland Highlands',
		'US1840018306' => 'Golf',
		'US1840028986' => 'Hunters Creek',
		'US1840014119' => 'Lacoochee',
		'US1840029036' => 'Fussels Corner',
		'US1840017258' => 'Lake Park',
		'US1840029015' => 'Washington Park',
		'US1840028660' => 'Cypress Gardens',
		'US1840017257' => 'Lake Clarke Shores',
		'US1840038986' => 'Key Vista',
		'US1840015101' => 'Dade City',
		'US1840073824' => 'DeLand Southwest',
		'US1840014077' => 'Micco',
		'US1840028859' => 'Howey-in-the-Hills',
		'US1840015939' => 'Brooker',
		'US1840015954' => 'Umatilla',
		'US1840014161' => 'Wabasso Beach',
		'US1840017238' => 'Windermere',
		'US1840017162' => 'Westville',
		'US1840015907' => 'Callahan',
		'US1840014184' => 'Laurel',
		'US1840014051' => 'Paisley',
		'US1840014245' => 'Leisure City',
		'US1840015129' => 'LaBelle',
		'US1840015141' => 'Pembroke Pines',
		'US1840018307' => 'North Palm Beach',
		'US1840015944' => 'Bell',
		'US1840014047' => 'Sorrento',
		'US1840039051' => 'Pasadena Hills',
		'US1840015122' => 'Punta Gorda',
		'US1840014222' => 'North Fort Myers',
		'US1840015963' => 'West Melbourne',
		'US1840018207' => 'Sneads',
		'US1840043096' => 'Springhill',
		'US1840013919' => 'Pace',
		'US1840015983' => 'Temple Terrace',
		'US1840017155' => 'Century',
		'US1840015051' => 'Lawtey',
		'US1840014165' => 'Fellsmere',
		'US1840015081' => 'Minneola',
		'US1840014108' => 'Masaryktown',
		'US1840014234' => 'Orangetree',
		'US1840029058' => 'North Brooksville',
		'US1840017239' => 'Hillcrest Heights',
		'US1840029027' => 'Combee Settlement',
		'US1840028987' => 'Juno Ridge',
		'US1840015961' => 'Satellite Beach',
		'US1840015118' => 'Okeechobee',
		'US1840015025' => 'Monticello',
		'US1840015138' => 'North Lauderdale',
		'US1840014048' => 'Yalaha',
		'US1840015080' => 'Clermont',
		'US1840014057' => 'Floral City',
		'US1840017203' => 'Hastings',
		'US1840014063' => 'Sugarmill Woods',
		'US1840038857' => 'Connerton',
		'US1840015959' => 'Winter Springs',
		'US1840028959' => 'St. Lucie Village',
		'US1840015148' => 'Doral',
		'US1840018332' => 'El Portal',
		'US1840038865' => 'Fort Denaud',
		'US1840014202' => 'Canal Point',
		'US1840015055' => 'Carrabelle',
		'US1840028922' => 'Palmona Park',
		'US1840025147' => 'Garden Grove',
		'US1840015952' => 'Astatula',
		'US1840014118' => 'Wesley Chapel',
		'US1840029039' => 'Golden Glades',
		'US1840015031' => 'Jacksonville',
		'US1840026043' => 'Morriston',
		'US1840029018' => 'West Perrine',
		'US1840015986' => 'Sebring',
		'US1840017214' => 'La Crosse',
		'US1840015103' => 'Port Richey',
		'US1840014110' => 'Pine Island',
		'US1840013916' => 'Molino',
		'US1840013913' => 'Brent',
		'US1840017222' => 'Inglis',
		'US1840014189' => 'Indiantown',
		'US1840025114' => 'Mount Carmel',
		'US1840028918' => 'Broadview Park',
		'US1840015933' => 'St. Marks',
		'US1840015960' => 'Melbourne',
		'US1840015990' => 'Stuart',
		'US1840015061' => 'Crescent City',
		'US1840015934' => 'Sopchoppy',
		'US1840014039' => 'Dunnellon',
		'US1840015029' => 'Lake City',
		'US1840014200' => 'Port Charlotte',
		'US1840014129' => 'Kathleen',
		'US1840014106' => 'Spring Lake',
		'US1840014155' => 'Wimauma',
		'US1840014203' => 'Atlantis',
		'US1840015105' => 'Mulberry',
		'US1840015060' => 'High Springs',
		'US1840042894' => 'Spring Ridge',
		'US1840029003' => 'Seminole Manor',
		'US1840039089' => 'Quail Ridge',
		'US1840015957' => 'Longwood',
		'US1840029005' => 'Southchase',
		'US1840017273' => 'Pembroke Park',
		'US1840039004' => 'Montura',
		'US1840013906' => 'Graceville',
		'US1840042859' => 'Patrick AFB',
		'US1840015034' => 'Panama City',
		'US1840015145' => 'Lauderdale Lakes',
		'US1840015134' => 'Coral Springs',
		'US1840025145' => 'Clarcona',
		'US1840014022' => 'Gainesville',
		'US1840026011' => 'Hosford',
		'US1840026061' => 'The Acreage',
		'US1840029079' => 'South Gate Ridge',
		'US1840017218' => 'Interlachen',
		'US1840014015' => 'Apalachicola',
		'US1840042907' => 'Watergate',
		'US1840014006' => 'Hampton',
		'US1840013999' => 'Green Cove Springs',
		'US1840014056' => 'Groveland',
		'US1840015052' => 'Lake Butler',
		'US1840035805' => 'Kendall West',
		'US1840029059' => 'North DeLand',
		'US1840035478' => 'Samsula-Spruce Creek',
		'US1840017158' => 'Cinco Bayou',
		'US1840073872' => 'North Weeki Wachee',
		'US1840043091' => 'Avalon',
		'US1840017191' => 'Glen St. Mary',
		'US1840015066' => 'Chiefland',
		'US1840073843' => 'Inverness Highlands North',
		'US1840029094' => 'West Bradenton',
		'US1840014150' => 'Bloomingdale',
		'US1840039008' => 'Moon Lake',
		'US1840029044' => 'Indian River Estates',
		'US1840028973' => 'Black Diamond',
		'US1840017263' => 'Cloud Lake',
		'US1840015076' => 'Ormond Beach',
		'US1840018294' => 'Redington Beach',
		'US1840015064' => 'Palm Coast',
		'US1840013130' => 'Duck Key',
		'US1840014059' => 'Homosassa',
		'US1840017186' => 'Lee',
		'US1840028702' => 'Iona',
		'US1840013120' => 'Fairview Shores',
		'US1840073834' => 'Fort Pierce North',
		'US1840015996' => 'Sanibel',
		'US1840015071' => 'DeLand',
		'US1840015919' => 'Altha',
		'US1840014224' => 'Pineland',
		'US1840029087' => 'The Meadows',
		'US1840014213' => 'Gateway',
		'US1840038992' => 'Meadow Oaks',
		'US1840014163' => 'Winter Beach',
		'US1840017213' => 'Worthington Springs',
		'US1840014115' => 'Hudson',
		'US1840013970' => 'Fruit Cove',
		'US1840017252' => 'Ocean Breeze Park',
		'US1840036116' => 'Jacob City',
		'US1840029054' => 'Lower Grand Lagoon',
		'US1840014099' => 'Edgewood',
		'US1840014141' => 'Bay Pines',
		'US1840014088' => 'Tangerine',
		'US1840029016' => 'Wekiwa Springs',
		'US1840014111' => 'Ridge Manor',
		'US1840014239' => 'Goulds',
		'US1840014021' => 'Archer',
		'US1840028708' => 'Jan Phyl Village',
		'US1840029113' => 'Dixonville',
		'US1840029102' => 'Alafaya',
		'US1840017265' => 'Gulf Stream',
		'US1840017271' => 'Lauderdale-by-the-Sea',
		'US1840017248' => 'Lake Placid',
		'US1840015074' => 'Oak Hill',
		'US1840015147' => 'Coral Gables',
		'US1840014067' => 'Bushnell',
		'US1840029100' => 'Williamsburg',
		'US1840073873' => 'Palm River-Clair Mel',
		'US1840014208' => 'Boynton Beach',
		'US1840013918' => 'Bagdad',
		'US1840025167' => 'Gardner',
		'US1840029089' => 'Town n Country',
		'US1840029014' => 'Vineyards',
		'US1840027009' => 'Floridatown',
		'US1840017183' => 'Greensboro',
		'US1840029022' => 'Brookridge',
		'US1840017262' => 'Mangonia Park',
		'US1840015951' => 'Mascotte',
		'US1840015106' => 'Lake Alfred',
		'US1840073858' => 'Zephyrhills South',
		'US1840013121' => 'Conway',
		'US1840038991' => 'Lake Mary Jane',
		'US1840029017' => 'Westchase',
		'US1840014114' => 'Holiday',
		'US1840073852' => 'University',
		'US1840014085' => 'Sky Lake',
		'US1840026032' => 'Day',
		'US1840015092' => 'Cocoa',
		'US1840014080' => 'Goldenrod',
		'US1840028975' => 'Burnt Store Marina',
		'US1840029026' => 'Carrollwood',
		'US1840029031' => 'Cudjoe Key',
		'US1840073853' => 'Vero Beach South',
		'US1840073841' => 'Homestead Base',
		'US1840029010' => 'Three Lakes',
		'US1840029091' => 'Villano Beach',
		'US1840017190' => 'Fort White',
		'US1840025113' => 'Harold',
		'US1840014198' => 'Charlotte Harbor',
		'US1840013971' => 'Palm Valley',
		'US1840014134' => 'Fort Meade',
		'US1840073871' => 'New Port Richey East',
		'US1840014117' => 'Bayonet Point',
		'US1840017272' => 'Davie',
		'US1840042877' => 'Pine Air',
		'US1840015119' => 'Port St. Lucie',
		'US1840014244' => 'Kendall',
		'US1840018295' => 'Redington Shores',
		'US1840026013' => 'Sumatra',
		'US1840017270' => 'Hillsboro Beach',
		'US1840015083' => 'Leesburg',
		'US1840029053' => 'Lochmoor Waterway Estates',
		'US1840026005' => 'Lamont',
		'US1840029057' => 'Meadow Woods',
		'US1840017242' => 'Polk City',
		'US1840029004' => 'Shady Hills',
		'US1840013954' => 'Five Points',
		'US1840028657' => 'Crooked Lake Park',
		'US1840015107' => 'Lake Wales',
		'US1840015135' => 'Dania Beach',
		'US1840029007' => 'Stacey Street',
		'US1840028935' => 'Lisbon',
		'US1840015162' => 'Layton',
		'US1840015113' => 'Indian Rocks Beach',
		'US1840028755' => 'Pine Manor',
		'US1840029096' => 'West Little River',
		'US1840028990' => 'Lake Kathryn',
		'US1840017246' => 'Indian River Shores',
		'US1840014124' => 'Babson Park',
		'US1840029101' => 'Tiger Point',
		'US1840015921' => 'Macclenny',
		'US1840015899' => 'Bascom',
		'US1840017260' => 'Loxahatchee Groves',
		'US1840015036' => 'Parker',
		'US1840028996' => 'Pelican Bay',
		'US1840039162' => 'World Golf Village',
		'US1840026006' => 'Lloyd',
		'US1840015128' => 'Clewiston',
		'US1840017156' => 'Jay',
		'US1840014210' => 'Port LaBelle',
		'US1840018329' => 'Sea Ranch Lakes',
		'US1840015032' => 'Jacksonville Beach',
		'US1840014241' => 'Westchester',
		'US1840014231' => 'Chokoloskee',
		'US1840014173' => 'Bradenton',
		'US1840014143' => 'Palm Harbor',
		'US1840028742' => 'Ojus',
		'US1840027017' => 'Navarre',
		'US1840015111' => 'Oldsmar',
		'US1840014079' => 'Port St. John',
		'US1840015971' => 'St. Cloud',
		'US1840035791' => 'Tyndall AFB',
		'US1840014147' => 'Belleair Bluffs',
		'US1840014236' => 'Fort Lauderdale',
		'US1840027018' => 'Oriole Beach',
		'US1840017241' => 'Dundee',
		'US1840029033' => 'Desoto Lakes',
		'US1840028718' => 'Lazy Lake',
		'US1840025148' => 'Wiscon',
		'US1840014140' => 'Harbor Bluffs',
		'US1840029080' => 'South Patrick Shores',
		'US1840013953' => 'Bristol',
		'US1840025154' => 'Bradley Junction',
		'US1840039052' => 'Pine Level',
		'US1840015948' => 'Bronson',
		'US1840014102' => 'Hernando Beach',
		'US1840015097' => 'Oakland',
		'US1840036057' => 'Greenacres',
		'US1840014215' => 'Bokeelia',
		'US1840015131' => 'Naples',
		'US1840029012' => 'Trinity',
		'US1840015082' => 'Mount Dora',
		'US1840017151' => 'Grand Ridge',
		'US1840015156' => 'Opa-locka',
		'US1840028759' => 'Plantation Island',
		'US1840025166' => 'Fort Green',
		'US1840014167' => 'Bowling Green',
		'US1840014152' => 'Citrus Park',
		'US1840028985' => 'Harlem Heights',
		'US1840015152' => 'Miami Springs',
		'US1840029051' => 'Lakeside',
		'US1840029030' => 'Crystal Lake',
		'US1840014081' => 'Gotha',
		'US1840015980' => 'Tarpon Springs',
		'US1840029008' => 'The Crossings',
		'US1840025162' => 'Balm',
		'US1840014050' => 'Okahumpka',
		'US1840029045' => 'Kendale Lakes',
		'US1840029063' => 'Palmetto Estates',
		'US1840015073' => 'New Smyrna Beach',
		'US1840014171' => 'Anna Maria',
		'US1840015078' => 'Holly Hill',
		'US1840014052' => 'Pine Lakes',
		'US1840015981' => 'Treasure Island',
		'US1840015137' => 'Miramar',
		'US1840014219' => 'Tice',
		'US1840028958' => 'River Park',
		'US1840015149' => 'Miami',
		'US1840013952' => 'Blountstown',
		'US1840039098' => 'River Ridge',
		'US1840014201' => 'Rotonda',
		'US1840013944' => 'Woodville',
		'US1840029048' => 'Lake Lorraine',
		'US1840013909' => 'Ferry Pass',
		'US1840013128' => 'Cleveland',
		'US1840027015' => 'Holley',
		'US1840016009' => 'West Miami',
		'US1840015993' => 'West Palm Beach',
		'US1840028914' => 'Keystone',
		'US1840028984' => 'Gun Club Estates',
		'US1840015065' => 'Cedar Key',
		'US1840017219' => 'Welaka',
		'US1840015995' => 'Highland Beach',
		'US1840014183' => 'Warm Mineral Springs',
		'US1840014229' => 'Goodland',
		'US1840014207' => 'Boca Raton',
		'US1840014174' => 'Bradenton Beach',
		'US1840028979' => 'Country Walk',
		'US1840015143' => 'Pompano Beach',
		'US1840014188' => 'Hobe Sound',
		'US1840047821' => 'Palm Springs North',
		'US1840017245' => 'North Redington Beach',
		'US1840029025' => 'Butler Beach',
		'US1840015136' => 'Deerfield Beach',
		'US1840014172' => 'Memphis',
		'US1840015950' => 'South Daytona',
		'US1840014232' => 'Naples Manor',
		'US1840015093' => 'Cocoa Beach',
		'US1840014177' => 'Lakewood Park',
		'US1840017220' => 'Pomona Park',
		'US1840073863' => 'Matlacha Isles-Matlacha Shores',
		'US1840014227' => 'Bonita Springs',
		'US1840016003' => 'Weston',
		'US1840025161' => 'Lealman',
		'US1840028749' => 'Page Park',
		'US1840029090' => 'Upper Grand Lagoon',
		'US1840017249' => 'Zolfo Springs',
		'US1840017261' => 'Manalapan',
		'US1840014192' => 'Palm City',
		'US1840028805' => 'Nocatee',
		'US1840014101' => 'Belle Isle',
		'US1840015108' => 'Lakeland',
		'US1840016006' => 'South Miami',
		'US1840039117' => 'Verona Walk',
		'US1840014104' => 'Bayport',
		'US1840017226' => 'Pierson',
		'US1840042432' => 'Jupiter Farms',
	],
	'WY' => [
		'US1840038392' => 'Whiting',
		'US1840017459' => 'Hawk Springs',
		'US1840020096' => 'Laramie',
		'US1840017482' => 'Lonetree',
		'US1840018595' => 'Cody',
		'US1840038439' => 'Y-O Ranch',
		'US1840021291' => 'Afton',
		'US1840018662' => 'Kemmerer',
		'US1840021238' => 'Burlington',
		'US1840022358' => 'Midwest',
		'US1840017436' => 'Fort Washakie',
		'US1840038422' => 'Antelope Hills',
		'US1840038425' => 'Boulder Flats',
		'US1840018691' => 'North Rock Springs',
		'US1840017466' => 'James Town',
		'US1840022361' => 'Pinedale',
		'US1840021289' => 'Edgerton',
		'US1840021292' => 'Alpine',
		'US1840018661' => 'Turnerville',
		'US1840022347' => 'Pine Haven',
		'US1840017455' => 'Grover',
		'US1840018686' => 'Slater',
		'US1840017429' => 'Alta',
		'US1840021287' => 'Glenrock',
		'US1840022357' => 'Van Tassell',
		'US1840021270' => 'Hudson',
		'US1840018714' => 'Robertson',
		'US1840020027' => 'Lander',
		'US1840021286' => 'Rolling Hills',
		'US1840017445' => 'Alcova',
		'US1840022363' => 'Cokeville',
		'US1840038423' => 'Arrowhead Springs',
		'US1840017451' => 'Bedford',
		'US1840017465' => 'Farson',
		'US1840038435' => 'Purple Sage',
		'US1840018629' => 'Osage',
		'US1840022370' => 'Medicine Bow',
		'US1840021288' => 'Lost Springs',
		'US1840022348' => 'Sundance',
		'US1840018690' => 'Little America',
		'US1840018660' => 'Smoot',
		'US1840021246' => 'Hulett',
		'US1840020123' => 'Bear River',
		'US1840020102' => 'Bairoil',
		'US1840021315' => 'Rock River',
		'US1840017450' => 'Auburn',
		'US1840022372' => 'Sinclair',
		'US1840074973' => 'Superior',
		'US1840037121' => 'Oakley',
		'US1840021240' => 'Deaver',
		'US1840018713' => 'Cheyenne',
		'US1840020061' => 'Big Piney',
		'US1840018596' => 'Parkman',
		'US1840021313' => 'Encampment',
		'US1840017428' => 'Big Horn',
		'US1840021303' => 'Fort Laramie',
		'US1840021258' => 'Jackson',
		'US1840018655' => 'Douglas',
		'US1840018659' => 'Daniel',
		'US1840017435' => 'Ethete',
		'US1840017454' => 'Fontenelle',
		'US1840017437' => 'Jeffrey City',
		'US1840018631' => 'Owl Creek',
		'US1840021302' => 'Torrington',
		'US1840026207' => 'Arlington',
		'US1840038430' => 'Hill View Heights',
		'US1840017431' => 'Lucerne',
		'US1840022374' => 'Wamsutter',
		'US1840018597' => 'Story',
		'US1840024145' => 'Urie',
		'US1840022354' => 'Pavillion',
		'US1840021290' => 'Evansville',
		'US1840038424' => 'Bessemer Bend',
		'US1840026119' => 'Shell',
		'US1840018685' => 'Veteran',
		'US1840022341' => 'Meeteetse',
		'US1840021308' => 'Hartville',
		'US1840022366' => 'Yoder',
		'US1840017426' => 'Hyattville',
		'US1840024100' => 'Ryan Park',
		'US1840038431' => 'Homa Hills',
		'US1840018612' => 'Wilson',
		'US1840038427' => 'Chugcreek',
		'US1840022359' => 'Mills',
		'US1840017446' => 'Brookhurst',
		'US1840018692' => 'Reliance',
		'US1840038437' => 'Washam',
		'US1840038433' => 'Meadow Acres',
		'US1840022356' => 'Manville',
		'US1840021314' => 'Hanna',
		'US1840017460' => 'Huntley',
		'US1840023927' => 'Mammoth',
		'US1840038381' => 'Point of Rocks',
		'US1840022367' => 'Chugwater',
		'US1840022352' => 'Ten Sleep',
		'US1840022353' => 'Thermopolis',
		'US1840038429' => 'Hartrandt',
		'US1840021267' => 'East Thermopolis',
		'US1840017449' => 'Boulder',
		'US1840018594' => 'Ralston',
		'US1840017453' => 'Fairview',
		'US1840017443' => 'Lance Creek',
		'US1840022365' => 'Thayne',
		'US1840017434' => 'Atlantic City',
		'US1840022343' => 'Byron',
		'US1840038441' => 'Ranchettes',
		'US1840021245' => 'Ranchester',
		'US1840038438' => 'Westview Circle',
		'US1840021266' => 'Worland',
		'US1840017481' => 'Carter',
		'US1840017452' => 'Etna',
		'US1840022371' => 'Saratoga',
		'US1840021293' => 'Diamondville',
		'US1840022362' => 'Opal',
		'US1840024140' => 'Hillsdale',
		'US1840022345' => 'Clearmont',
		'US1840022342' => 'Manderson',
		'US1840021239' => 'Cowley',
		'US1840022368' => 'Wheatland',
		'US1840026161' => 'Orin',
		'US1840019978' => 'Gillette',
		'US1840021242' => 'Lovell',
		'US1840019977' => 'Basin',
		'US1840020060' => 'Bar Nunn',
		'US1840020100' => 'Green River',
		'US1840021243' => 'Sheridan',
		'US1840022355' => 'Shoshoni',
		'US1840017463' => 'Eden',
		'US1840021285' => 'Lusk',
		'US1840017462' => 'Centennial',
		'US1840017461' => 'Albany',
		'US1840021241' => 'Greybull',
		'US1840019976' => 'Powell',
		'US1840018657' => 'Powder River',
		'US1840021339' => 'Albin',
		'US1840141272' => 'Nordic',
		'US1840021307' => 'Guernsey',
		'US1840026121' => 'Kelly',
		'US1840073896' => 'Alpine Northeast',
		'US1840021305' => 'Lingle',
		'US1840021294' => 'La Barge',
		'US1840021311' => 'Elk Mountain',
		'US1840038324' => 'Casper',
		'US1840022351' => 'Upton',
		'US1840022388' => 'Mountain View',
		'US1840020122' => 'Evanston',
		'US1840022344' => 'Wright',
		'US1840021310' => 'Dixon',
		'US1840021312' => 'Riverside',
		'US1840022360' => 'Marbleton',
		'US1840021268' => 'Kirby',
		'US1840020012' => 'Newcastle',
		'US1840017433' => 'Arapahoe',
		'US1840021338' => 'Burns',
		'US1840022346' => 'Moorcroft',
		'US1840073950' => 'Fox Farm-College',
		'US1840074698' => 'Warren AFB',
		'US1840074768' => 'Woods Landing-Jelm',
		'US1840038443' => 'South Greeley',
		'US1840038434' => 'Moose Wilson Road',
		'US1840074280' => 'Lakeview North',
		'US1840021244' => 'Dayton',
		'US1840038444' => 'Vista West',
		'US1840017432' => 'Crowheart',
		'US1840038428' => 'Clearview Acres',
		'US1840017447' => 'Cora',
		'US1840018613' => 'Teton Village',
		'US1840038432' => 'Johnstown',
		'US1840021340' => 'Lyman',
		'US1840026171' => 'Freedom',
		'US1840038426' => 'Casper Mountain',
		'US1840038436' => 'South Park',
		'US1840017448' => 'Bondurant',
		'US1840021269' => 'Dubois',
		'US1840036652' => 'Alpine Northwest',
		'US1840024048' => 'Osmond',
		'US1840020095' => 'Baggs',
		'US1840021237' => 'Frannie',
		'US1840017427' => 'Arvada',
		'US1840021304' => 'La Grange',
		'US1840017444' => 'Esterbrook',
		'US1840018693' => 'Table Rock',
		'US1840038442' => 'Sleepy Hollow',
		'US1840021317' => 'Granger',
		'US1840020094' => 'Rawlins',
		'US1840038440' => 'Rafter J Ranch',
		'US1840020026' => 'Riverton',
		'US1840017430' => 'Hoback',
		'US1840021306' => 'Glendo',
		'US1840021260' => 'Kaycee',
		'US1840037361' => 'Taylor',
		'US1840017464' => 'McKinnon',
		'US1840022387' => 'Pine Bluffs',
		'US1840020101' => 'Rock Springs',
		'US1840017483' => 'Fort Bridger',
		'US1840017425' => 'Garland',
		'US1840024139' => 'Carpenter',
		'US1840018658' => 'Red Butte',
		'US1840023930' => 'Beulah',
		'US1840022364' => 'Star Valley Ranch',
		'US1840018615' => 'Buffalo',
	],
	'NH' => [
		'US1840002810' => 'Somersworth',
		'US1840003050' => 'Keene',
		'US1840073462' => 'Tilton Northfield',
		'US1840002749' => 'Contoocook',
		'US1840026181' => 'North Walpole',
		'US1840002748' => 'Franklin',
		'US1840002100' => 'Berlin',
		'US1840003054' => 'West Swanzey',
		'US1840002222' => 'North Conway',
		'US1840026176' => 'Seabrook Beach',
		'US1840043121' => 'Suissevale',
		'US1840002804' => 'Suncook',
		'US1840026132' => 'Center Ossipee',
		'US1840002683' => 'Laconia',
		'US1840002747' => 'Concord',
		'US1840026130' => 'North Woodstock',
		'US1840026174' => 'Hampton Beach',
		'US1840026134' => 'Melvin Village',
		'US1840026133' => 'Center Sandwich',
		'US1840002932' => 'Portsmouth',
		'US1840002809' => 'Rochester',
		'US1840002805' => 'Claremont',
		'US1840002991' => 'Pinardville',
		'US1840002808' => 'Dover',
		'US1840002983' => 'Manchester',
		'US1840033211' => 'East Merrimack',
		'US1840026108' => 'West Stewartstown',
		'US1840026137' => 'Union',
		'US1840026159' => 'Milton Mills',
		'US1840002803' => 'South Hooksett',
		'US1840002192' => 'Lebanon',
		'US1840026152' => 'Blodgett Landing',
		'US1840033204' => 'North Haverhill',
		'US1840002984' => 'Nashua',
		'US1840002199' => 'Woodsville',
		'US1840002102' => 'Groveton',
		'US1840026135' => 'Sanbornville',
		'US1840026129' => 'Mountain Lakes',
	],
	'NJ' => [
		'US1840000895' => 'Carlstadt',
		'US1840039970' => 'Upper Pohatcong',
		'US1840024282' => 'Zarephath',
		'US1840001383' => 'Trenton',
		'US1840005866' => 'North Cape May',
		'US1840000906' => 'Montvale',
		'US1840005420' => 'Laurence Harbor',
		'US1840033442' => 'White House Station',
		'US1840005192' => 'Beattystown',
		'US1840033473' => 'Plainsboro Center',
		'US1840033220' => 'Audubon Park',
		'US1840033460' => 'Green Knoll',
		'US1840005454' => 'West Freehold',
		'US1840005417' => 'Port Reading',
		'US1840003551' => 'Alpine',
		'US1840033212' => 'Leisure Village East',
		'US1840005475' => 'White Horse',
		'US1840000893' => 'Bergenfield',
		'US1840001336' => 'Spotswood',
		'US1840003535' => 'Lodi',
		'US1840000836' => 'North Haledon',
		'US1840033268' => 'Ellisburg',
		'US1840003675' => 'Matawan',
		'US1840001495' => 'Tuckerton',
		'US1840024255' => 'Upper Montclair',
		'US1840001487' => 'Seaside Heights',
		'US1840001531' => 'Woodstown',
		'US1840005409' => 'Fords',
		'US1840000914' => 'Oradell',
		'US1840005355' => 'Essex Fells',
		'US1840003561' => 'Ho-Ho-Kus',
		'US1840001505' => 'Berlin',
		'US1840039977' => 'Vernon Center',
		'US1840000911' => 'Norwood',
		'US1840001524' => 'Swedesboro',
		'US1840003755' => 'Barnegat Light',
		'US1840016638' => 'Egg Harbor City',
		'US1840005752' => 'Laurel Lake',
		'US1840005411' => 'Colonia',
		'US1840033366' => 'New Village',
		'US1840003613' => 'Elizabeth',
		'US1840003775' => 'Audubon',
		'US1840003793' => 'Margate City',
		'US1840001538' => 'Northfield',
		'US1840005537' => 'Waretown',
		'US1840001057' => 'South Bound Brook',
		'US1840024493' => 'Burleigh',
		'US1840033487' => 'Vernon Valley',
		'US1840001037' => 'Bloomsbury',
		'US1840024281' => 'Skillman',
		'US1840003779' => 'Haddon Heights',
		'US1840001530' => 'Penns Grove',
		'US1840005594' => 'Elwood',
		'US1840039875' => 'East Rocky Hill',
		'US1840003672' => 'Loch Arbour',
		'US1840005865' => 'Diamond Beach',
		'US1840001493' => 'Ocean Gate',
		'US1840003677' => 'Neptune City',
		'US1840003676' => 'Avon-by-the-Sea',
		'US1840003597' => 'Guttenberg',
		'US1840024231' => 'Marksboro',
		'US1840003539' => 'Cresskill',
		'US1840005452' => 'Wanamassa',
		'US1840003552' => 'Fort Lee',
		'US1840001381' => 'Princeton',
		'US1840024227' => 'Hainesburg',
		'US1840003634' => 'Dunellen',
		'US1840001512' => 'Somerdale',
		'US1840005522' => 'Marlton',
		'US1840033476' => 'Beckett',
		'US1840000910' => 'Northvale',
		'US1840003577' => 'Morristown',
		'US1840000943' => 'Belvidere',
		'US1840003609' => 'High Bridge',
		'US1840024254' => 'Brookdale',
		'US1840003581' => 'Dover',
		'US1840001363' => 'Shrewsbury',
		'US1840005439' => 'Belford',
		'US1840000832' => 'Bloomingdale',
		'US1840000786' => 'Newton',
		'US1840002792' => 'East Orange',
		'US1840042853' => 'Silver Lake',
		'US1840039889' => 'Franklin Park',
		'US1840000953' => 'Lincoln Park',
		'US1840001489' => 'Ship Bottom',
		'US1840003555' => 'Glen Rock',
		'US1840005415' => 'Monmouth Junction',
		'US1840001597' => 'North Wildwood',
		'US1840033486' => 'Society Hill',
		'US1840005473' => 'Lawrenceville',
		'US1840003560' => 'Hillsdale',
		'US1840004954' => 'Crandon Lakes',
		'US1840001508' => 'Chesilhurst',
		'US1840003534' => 'Little Ferry',
		'US1840000905' => 'Midland Park',
		'US1840000899' => 'Ridgewood',
		'US1840003687' => 'Freehold',
		'US1840003681' => 'Fair Haven',
		'US1840001480' => 'Pemberton',
		'US1840033491' => 'Leisure Village West',
		'US1840001059' => 'North Plainfield',
		'US1840003543' => 'Edgewater',
		'US1840024225' => 'Great Meadows',
		'US1840001600' => 'West Cape May',
		'US1840003673' => 'Long Branch',
		'US1840003800' => 'Hammonton',
		'US1840005440' => 'Cliffwood Beach',
		'US1840024272' => 'Blawenburg',
		'US1840005753' => 'Seabrook Farms',
		'US1840000950' => 'Riverdale',
		'US1840024353' => 'Roebling',
		'US1840003576' => 'Morris Plains',
		'US1840003753' => 'Fieldsboro',
		'US1840001056' => 'Somerville',
		'US1840001509' => 'Pine Hill',
		'US1840003482' => 'Hopatcong',
		'US1840001332' => 'Sayreville',
		'US1840000789' => 'Sussex',
		'US1840005518' => 'Country Lake Estates',
		'US1840005198' => 'White Meadow Lake',
		'US1840003794' => 'Corbin City',
		'US1840001486' => 'Point Pleasant Beach',
		'US1840003678' => 'Deal',
		'US1840005193' => 'Brass Castle',
		'US1840003600' => 'Jersey City',
		'US1840056421' => 'Woodland Park',
		'US1840001091' => 'Rahway',
		'US1840003682' => 'Allenhurst',
		'US1840033304' => 'Hutchinson',
		'US1840000951' => 'Rockaway',
		'US1840024216' => 'Anderson',
		'US1840005868' => 'Strathmere',
		'US1840003536' => 'Maywood',
		'US1840001599' => 'Stone Harbor',
		'US1840005453' => 'West Belmar',
		'US1840003636' => 'Highland Park',
		'US1840001052' => 'Bernardsville',
		'US1840003797' => 'Absecon',
		'US1840005532' => 'North Beach Haven',
		'US1840005529' => 'Dover Beaches South',
		'US1840001340' => 'Perth Amboy',
		'US1840003537' => 'Cliffside Park',
		'US1840003776' => 'Gibbsboro',
		'US1840002791' => 'Newark',
		'US1840005354' => 'Caldwell',
		'US1840003777' => 'Gloucester City',
		'US1840001477' => 'Burlington',
		'US1840001367' => 'Spring Lake Heights',
		'US1840024224' => 'Finesville',
		'US1840000955' => 'Wharton',
		'US1840005446' => 'Ocean Grove',
		'US1840003580' => 'Netcong',
		'US1840000837' => 'Passaic',
		'US1840000731' => 'Bellmawr',
		'US1840003792' => 'Longport',
		'US1840003480' => 'Franklin',
		'US1840001042' => 'Stockton',
		'US1840003544' => 'Elmwood Park',
		'US1840001594' => 'Cape May',
		'US1840001041' => 'Milford',
		'US1840005526' => 'Beach Haven West',
		'US1840003556' => 'Hackensack',
		'US1840003512' => 'Haledon',
		'US1840005520' => 'Presidential Lakes Estates',
		'US1840001550' => 'Millville',
		'US1840000946' => 'Boonton',
		'US1840005519' => 'Pemberton Heights',
		'US1840033477' => 'Cedar Glen Lakes',
		'US1840000901' => 'Rockleigh',
		'US1840001513' => 'Laurel Springs',
		'US1840000954' => 'Victory Gardens',
		'US1840024235' => 'Succasunna',
		'US1840001547' => 'Fairton',
		'US1840003558' => 'Hasbrouck Heights',
		'US1840003604' => 'Clinton',
		'US1840000952' => 'Kinnelon',
		'US1840001368' => 'Tinton Falls',
		'US1840033317' => 'Lake Como',
		'US1840001334' => 'South Plainfield',
		'US1840003616' => 'Kenilworth',
		'US1840039879' => 'Franklin Center',
		'US1840003758' => 'Island Heights',
		'US1840033475' => 'Vista Center',
		'US1840005195' => 'Budd Lake',
		'US1840003612' => 'Mountainside',
		'US1840039973' => 'Upper Stewartsville',
		'US1840003605' => 'Flemington',
		'US1840005421' => 'Madison Park',
		'US1840003771' => 'Barrington',
		'US1840003690' => 'Keansburg',
		'US1840003798' => 'Atlantic City',
		'US1840039942' => 'Panther Valley',
		'US1840024233' => 'Vienna',
		'US1840005419' => 'Kendall Park',
		'US1840003540' => 'Demarest',
		'US1840003772' => 'Mount Ephraim',
		'US1840033488' => 'Yorketown',
		'US1840003610' => 'Manville',
		'US1840024374' => 'Pedricktown',
		'US1840026523' => 'Yardville',
		'US1840000924' => 'Woodcliff Lake',
		'US1840003599' => 'Hoboken',
		'US1840003574' => 'Madison',
		'US1840000944' => 'Phillipsburg',
		'US1840005447' => 'Port Monmouth',
		'US1840003752' => 'Medford Lakes',
		'US1840033466' => 'Silver Ridge',
		'US1840001527' => 'Woodbury',
		'US1840005535' => 'Manahawkin',
		'US1840003549' => 'Fairview',
		'US1840003557' => 'Harrington Park',
		'US1840001525' => 'Wenonah',
		'US1840005527' => 'Crestwood Village',
		'US1840003780' => 'Hi-Nella',
		'US1840033411' => 'Singac',
		'US1840033482' => 'Leisure Knoll',
		'US1840001520' => 'Clayton',
		'US1840005196' => 'Lake Telemark',
		'US1840000915' => 'Palisades Park',
		'US1840024217' => 'Asbury',
		'US1840003607' => 'Glen Gardner',
		'US1840033478' => 'Clearbrook Park',
		'US1840005592' => 'Olivet',
		'US1840000909' => 'North Arlington',
		'US1840005449' => 'Lincroft',
		'US1840000921' => 'Waldwick',
		'US1840000835' => 'Ringwood',
		'US1840043406' => 'Barclay',
		'US1840024384' => 'Smithville',
		'US1840000907' => 'Moonachie',
		'US1840001055' => 'Rocky Hill',
		'US1840000904' => 'Leonia',
		'US1840003547' => 'Englewood Cliffs',
		'US1840001604' => 'Woodbine',
		'US1840001551' => 'Vineland',
		'US1840003598' => 'Harrison',
		'US1840005530' => 'Mystic Island',
		'US1840005410' => 'Avenel',
		'US1840001521' => 'Pitman',
		'US1840000834' => 'Prospect Park',
		'US1840003770' => 'Merchantville',
		'US1840033448' => 'Woodlynne',
		'US1840003637' => 'Jamesburg',
		'US1840003546' => 'Englewood',
		'US1840001490' => 'South Toms River',
		'US1840003686' => 'Farmingdale',
		'US1840001475' => 'Beverly',
		'US1840001040' => 'Lebanon',
		'US1840003578' => 'Mountain Lakes',
		'US1840003541' => 'Dumont',
		'US1840033232' => 'Bradley Gardens',
		'US1840001481' => 'Wrightstown',
		'US1840005356' => 'Glen Ridge',
		'US1840005375' => 'Somerset',
		'US1840003542' => 'East Rutherford',
		'US1840001529' => 'Salem',
		'US1840033388' => 'Port Colden',
		'US1840001337' => 'Middlesex',
		'US1840003683' => 'Allentown',
		'US1840001491' => 'Lakehurst',
		'US1840003513' => 'Hawthorne',
		'US1840005422' => 'Sewaren',
		'US1840004955' => 'Lake Mohawk',
		'US1840024221' => 'Buttzville',
		'US1840001356' => 'Bradley Beach',
		'US1840016611' => 'Collingswood',
		'US1840033462' => 'Ten Mile Run',
		'US1840005450' => 'Shark River Hills',
		'US1840016785' => 'Williamstown',
		'US1840003788' => 'National Park',
		'US1840000833' => 'Pompton Lakes',
		'US1840024323' => 'Groveville',
		'US1840001035' => 'West New York',
		'US1840033443' => 'Whitesboro',
		'US1840000925' => 'Wood-Ridge',
		'US1840005528' => 'Dover Beaches North',
		'US1840003573' => 'Hackettstown',
		'US1840001522' => 'Newfield',
		'US1840001603' => 'Wildwood Crest',
		'US1840003769' => 'Magnolia',
		'US1840001338' => 'Milltown',
		'US1840003614' => 'Fanwood',
		'US1840001483' => 'Beachwood',
		'US1840033389' => 'Port Murray',
		'US1840039869' => 'East Franklin',
		'US1840003579' => 'Mount Arlington',
		'US1840001333' => 'South Amboy',
		'US1840000898' => 'Ridgefield Park',
		'US1840073737' => 'Whittingham',
		'US1840001054' => 'Raritan',
		'US1840001357' => 'Brielle',
		'US1840001602' => 'Wildwood',
		'US1840000838' => 'Paterson',
		'US1840001094' => 'Linden',
		'US1840003633' => 'Metuchen',
		'US1840001510' => 'Pine Valley',
		'US1840001359' => 'Roosevelt',
		'US1840005451' => 'Strathmore',
		'US1840000788' => 'Stanhope',
		'US1840005516' => 'Fort Dix',
		'US1840005864' => 'Cape May Court House',
		'US1840001093' => 'Roselle Park',
		'US1840005443' => 'Navesink',
		'US1840000919' => 'Teterboro',
		'US1840000839' => 'Totowa',
		'US1840024220' => 'Broadway',
		'US1840001364' => 'Monmouth Beach',
		'US1840001598' => 'Ocean City',
		'US1840039908' => 'Lopatcong Overlook',
		'US1840005566' => 'Victory Lakes',
		'US1840033383' => 'Pleasant Plains',
		'US1840024280' => 'Middlebush',
		'US1840016699' => 'Haddonfield',
		'US1840033286' => 'Glendora',
		'US1840003575' => 'Mendham',
		'US1840033393' => 'Ramtown',
		'US1840005448' => 'Leonardo',
		'US1840003548' => 'Fair Lawn',
		'US1840001355' => 'Belmar',
		'US1840005438' => 'Allenwood',
		'US1840001339' => 'New Brunswick',
		'US1840033356' => 'Mount Hermon',
		'US1840001061' => 'Watchung',
		'US1840003554' => 'Garfield',
		'US1840000998' => 'Roseland',
		'US1840024278' => 'Harlingen',
		'US1840005414' => 'Dayton',
		'US1840003572' => 'Alpha',
		'US1840005197' => 'Long Valley',
		'US1840033469' => 'Cherry Hill Mall',
		'US1840005531' => 'New Egypt',
		'US1840000949' => 'Chester',
		'US1840001331' => 'Carteret',
		'US1840033472' => 'Greentree',
		'US1840003606' => 'Frenchtown',
		'US1840001039' => 'Lambertville',
		'US1840001092' => 'Roselle',
		'US1840003538' => 'Closter',
		'US1840001506' => 'Brooklawn',
		'US1840033468' => 'Brownville',
		'US1840033471' => 'Golden Triangle',
		'US1840033215' => 'Annandale',
		'US1840001526' => 'Westville',
		'US1840001058' => 'Millstone',
		'US1840003635' => 'Helmetta',
		'US1840005565' => 'Turnersville',
		'US1840005595' => 'Collings Lakes',
		'US1840016610' => 'Bridgeton',
		'US1840001369' => 'Union Beach',
		'US1840033484' => 'Pine Ridge at Crestwood',
		'US1840002793' => 'North Caldwell',
		'US1840005751' => 'Rosenhayn',
		'US1840003773' => 'Clementon',
		'US1840033470' => 'Echelon',
		'US1840003596' => 'East Newark',
		'US1840005560' => 'Blackwood',
		'US1840024234' => 'Kenvil',
		'US1840003757' => 'Harvey Cedars',
		'US1840024324' => 'Hamilton Square',
		'US1840003796' => 'Estell Manor',
		'US1840001090' => 'Plainfield',
		'US1840003595' => 'Bayonne',
		'US1840005863' => 'Erma',
		'US1840033483' => 'Ocean Acres',
		'US1840001053' => 'Bound Brook',
		'US1840024373' => 'Hancocks Bridge',
		'US1840033464' => 'Brookfield',
		'US1840005442' => 'Morganville',
		'US1840001517' => 'Tavistock',
		'US1840003601' => 'Kearny',
		'US1840003550' => 'Allendale',
		'US1840000916' => 'Paramus',
		'US1840003611' => 'Far Hills',
		'US1840003799' => 'Folsom',
		'US1840001361' => 'Sea Bright',
		'US1840033455' => 'Blackwells Mills',
		'US1840001366' => 'Spring Lake',
		'US1840003559' => 'Haworth',
		'US1840024181' => 'Ross Corner',
		'US1840024273' => 'East Millstone',
		'US1840001478' => 'Riverton',
		'US1840000900' => 'River Edge',
		'US1840005444' => 'North Middletown',
		'US1840005564' => 'Gibbstown',
		'US1840005749' => 'Cedarville',
		'US1840005534' => 'Leisure Village',
		'US1840001335' => 'South River',
		'US1840003671' => 'Little Silver',
		'US1840001360' => 'Rumson',
		'US1840000903' => 'Saddle River',
		'US1840001515' => 'Oaklyn',
		'US1840000999' => 'Summit',
		'US1840003608' => 'Hampton',
		'US1840000923' => 'Westwood',
		'US1840024219' => 'Brainards',
		'US1840039968' => 'Six Mile Run',
		'US1840003808' => 'Avalon',
		'US1840039868' => 'Delaware Park',
		'US1840000897' => 'Ridgefield',
		'US1840001514' => 'Lawnside',
		'US1840056420' => 'Peapack and Gladstone',
		'US1840000902' => 'Rutherford',
		'US1840001476' => 'Bordentown',
		'US1840000894' => 'Bogota',
		'US1840026666' => 'Belleplain',
		'US1840000787' => 'Ogdensburg',
		'US1840005412' => 'Concordia',
		'US1840033298' => 'Highland Lakes',
		'US1840026509' => 'Robertsville',
		'US1840001536' => 'Port Republic',
		'US1840000896' => 'Ramsey',
		'US1840033481' => 'Holiday Heights',
		'US1840024279' => 'Martinsville',
		'US1840033467' => 'Ashland',
		'US1840001362' => 'Sea Girt',
		'US1840033344' => 'Mercerville',
		'US1840039933' => 'Mountain Lake',
		'US1840003789' => 'Glassboro',
		'US1840133731' => 'Springdale',
		'US1840000947' => 'Butler',
		'US1840005418' => 'Iselin',
		'US1840001494' => 'Surf City',
		'US1840033235' => 'Bridgeville',
		'US1840033371' => 'Oak Valley',
		'US1840003582' => 'Florham Park',
		'US1840001038' => 'Califon',
		'US1840003545' => 'Emerson',
		'US1840005597' => 'Mays Landing',
		'US1840001095' => 'New Providence',
		'US1840001382' => 'Pennington',
		'US1840024277' => 'Griggstown',
		'US1840003688' => 'Highlands',
		'US1840001492' => 'Lavallette',
		'US1840073621' => 'McGuire AFB',
		'US1840005869' => 'Villas',
		'US1840016703' => 'Mullica Hill',
		'US1840001485' => 'Point Pleasant',
		'US1840024232' => 'Stewartsville',
		'US1840001034' => 'Union City',
		'US1840001537' => 'Somers Point',
		'US1840000945' => 'Washington',
		'US1840033314' => 'Kingston Estates',
		'US1840005596' => 'Pomona',
		'US1840001507' => 'Camden',
		'US1840001534' => 'Buena',
		'US1840001539' => 'Ventnor City',
		'US1840024230' => 'Johnsonburg',
		'US1840001596' => 'Sea Isle City',
		'US1840003684' => 'Asbury Park',
		'US1840005521' => 'Leisuretowne',
		'US1840000948' => 'Chatham',
		'US1840003754' => 'Mantoloking',
		'US1840005472' => 'Princeton Junction',
		'US1840005441' => 'East Freehold',
		'US1840033465' => 'Cedar Glen West',
		'US1840001601' => 'West Wildwood',
		'US1840003708' => 'Hightstown',
		'US1840001033' => 'Secaucus',
		'US1840001358' => 'Red Bank',
		'US1840005867' => 'Rio Grande',
		'US1840003679' => 'Eatontown',
		'US1840024271' => 'Belle Mead',
		'US1840001528' => 'Woodbury Heights',
		'US1840005750' => 'Port Norris',
		'US1840024354' => 'Pine Lake Park',
		'US1840003689' => 'Interlaken',
		'US1840001488' => 'Seaside Park',
		'US1840005517' => 'Browns Mills',
		'US1840003479' => 'Andover',
		'US1840005474' => 'Twin Rivers',
		'US1840033399' => 'Richwood',
		'US1840003709' => 'Hopewell',
		'US1840033408' => 'Short Hills',
		'US1840003756' => 'Bay Head',
		'US1840033392' => 'Ramblewood',
		'US1840000912' => 'Oakland',
		'US1840003791' => 'Elmer',
		'US1840026546' => 'Juliustown',
		'US1840003481' => 'Hamburg',
		'US1840003680' => 'Englishtown',
		'US1840001595' => 'Cape May Point',
		'US1840073689' => 'Holiday City-Berkeley',
		'US1840024222' => 'Columbia',
		'US1840005524' => 'Forked River',
		'US1840016701' => 'Linwood',
		'US1840000920' => 'Upper Saddle River',
		'US1840039864' => 'Byram Center',
		'US1840000785' => 'Branchville',
		'US1840001535' => 'Pleasantville',
		'US1840001549' => 'Shiloh',
		'US1840005445' => 'Oakhurst',
		'US1840000913' => 'Old Tappan',
		'US1840033249' => 'Clyde',
		'US1840033474' => 'Princeton Meadows',
		'US1840000922' => 'Wallington',
		'US1840000908' => 'New Milford',
		'US1840001511' => 'Runnemede',
		'US1840033485' => 'Rossmoor',
		'US1840001482' => 'Beach Haven',
		'US1840035113' => 'Moorestown-Lenola',
		'US1840001523' => 'Paulsboro',
		'US1840003685' => 'Atlantic Highlands',
		'US1840073688' => 'Holiday City South',
		'US1840003511' => 'Clifton',
		'US1840001516' => 'Stratford',
		'US1840003553' => 'Franklin Lakes',
		'US1840003615' => 'Garwood',
		'US1840001365' => 'Oceanport',
		'US1840003674' => 'Manasquan',
		'US1840000730' => 'Lindenwold',
		'US1840000918' => 'Tenafly',
		'US1840033313' => 'Kingston',
		'US1840033440' => 'Weston',
		'US1840000917' => 'Park Ridge',
		'US1840001479' => 'Palmyra',
		'US1840001370' => 'West Long Branch',
		'US1840024274' => 'Finderne',
		'US1840001533' => 'Brigantine',
		'US1840000840' => 'Wanaque',
		'US1840003691' => 'Keyport',
		'US1840001484' => 'Pine Beach',
		'US1840033480' => 'Heathcote',
		'US1840001096' => 'Westfield',
	],
	'NM' => [
		'US1840043409' => 'El Cerro Mission',
		'US1840021630' => 'Red River',
		'US1840022686' => 'Roy',
		'US1840022837' => 'Causey',
		'US1840022681' => 'Corrales',
		'US1840024924' => 'Sena',
		'US1840040038' => 'Glen Acres',
		'US1840040001' => 'Cuyamungue Grant',
		'US1840033707' => 'Carnuel',
		'US1840024822' => 'Cañones',
		'US1840043001' => 'Conchas Dam',
		'US1840033728' => 'Rio Communities',
		'US1840033720' => 'North Acomita Village',
		'US1840017870' => 'Encinal',
		'US1840040084' => 'Keeler Farm',
		'US1840018991' => 'Newcomb',
		'US1840024837' => 'Los Luceros',
		'US1840040180' => 'Pueblo',
		'US1840033551' => 'Taos Ski Valley',
		'US1840017775' => 'La Puebla',
		'US1840025009' => 'Chamizal',
		'US1840033722' => 'Ojo Amarillo',
		'US1840019410' => 'Mesquite',
		'US1840018994' => 'Bloomfield',
		'US1840042456' => 'South Acomita Village',
		'US1840022840' => 'Magdalena',
		'US1840023010' => 'Santa Clara',
		'US1840017779' => 'Los Alamos',
		'US1840040195' => 'Rivers',
		'US1840019012' => 'Rio Lucio',
		'US1840024905' => 'San Luis',
		'US1840019095' => 'Zuni Pueblo',
		'US1840024971' => 'Paradise Hills',
		'US1840026909' => 'Arroyo Seco',
		'US1840020388' => 'Bernalillo',
		'US1840017763' => 'Crownpoint',
		'US1840024996' => 'Pueblitos',
		'US1840022871' => 'Capitan',
		'US1840026932' => 'Watrous',
		'US1840025097' => 'Whites City',
		'US1840024827' => 'Cordova',
		'US1840018992' => 'Sanostee',
		'US1840020353' => 'Raton',
		'US1840138621' => 'Young Place',
		'US1840025075' => 'Pinos Altos',
		'US1840017765' => 'Chupadero',
		'US1840019099' => 'Cuyamungue',
		'US1840020615' => 'Eunice',
		'US1840019176' => 'Albuquerque',
		'US1840019100' => 'Sombrillo',
		'US1840024823' => 'Canova',
		'US1840022838' => 'Dora',
		'US1840017766' => 'Agua Fria',
		'US1840020387' => 'Rio Rancho',
		'US1840022962' => 'Tatum',
		'US1840033711' => 'El Valle de Arroyo Seco',
		'US1840025089' => 'San Miguel',
		'US1840024832' => 'Ensenada',
		'US1840020349' => 'Farmington',
		'US1840021995' => 'Truth or Consequences',
		'US1840019417' => 'White Sands',
		'US1840021821' => 'Santa Rosa',
		'US1840033703' => 'Sandia Knolls',
		'US1840024993' => 'Chical',
		'US1840025071' => 'Hachita',
		'US1840025012' => 'Las Nutrias',
		'US1840024825' => 'Chamita',
		'US1840025080' => 'Berino',
		'US1840025027' => 'Pleasanton',
		'US1840021834' => 'Estancia',
		'US1840033685' => 'Lemitar',
		'US1840026931' => 'Mora',
		'US1840023033' => 'Loving',
		'US1840074899' => 'Edgewood',
		'US1840025052' => 'Winston',
		'US1840018986' => 'Santa Clara Pueblo',
		'US1840040161' => 'Peak Place',
		'US1840025048' => 'Hot Springs Landing',
		'US1840022839' => 'Floyd',
		'US1840017902' => 'Casa Colorada',
		'US1840138493' => 'Coyote',
		'US1840019190' => 'Tajique',
		'US1840033723' => 'Sandia Heights',
		'US1840017772' => 'Glorieta',
		'US1840042447' => 'Anzac Village',
		'US1840024972' => 'Ponderosa Pine',
		'US1840025066' => 'Buckhorn',
		'US1840024904' => 'Cochiti Lake',
		'US1840019011' => 'Ranchos de Taos',
		'US1840025095' => 'Loco Hills',
		'US1840025058' => 'Bent',
		'US1840024979' => 'Pastura',
		'US1840040145' => 'Lower Frisco',
		'US1840019096' => 'Thoreau',
		'US1840040211' => 'Rosedale',
		'US1840022975' => 'Williamsburg',
		'US1840033694' => 'Manzano Springs',
		'US1840017776' => 'Lamy',
		'US1840025047' => 'Hillsboro',
		'US1840033659' => 'Llano del Medio',
		'US1840019402' => 'Timberon',
		'US1840019171' => 'Paguate',
		'US1840024831' => 'El Rito',
		'US1840040215' => 'Sausal',
		'US1840024846' => 'Youngsville',
		'US1840021934' => 'Hagerman',
		'US1840018082' => 'La Huerta',
		'US1840025102' => 'Playas',
		'US1840024852' => 'Spencerville',
		'US1840033727' => 'Monterey Park',
		'US1840033710' => 'Brimhall Nizhoni',
		'US1840024835' => 'La Mesilla',
		'US1840019091' => 'Tohatchi',
		'US1840022806' => 'Mountainair',
		'US1840025090' => 'San Pablo',
		'US1840022729' => 'Logan',
		'US1840025014' => 'Luis Lopez',
		'US1840019411' => 'Radium Springs',
		'US1840024976' => 'Anton Chico',
		'US1840017741' => 'Cochiti',
		'US1840019088' => 'Navajo',
		'US1840019103' => 'Santa Cruz',
		'US1840024923' => 'Ribera',
		'US1840017671' => 'Kirtland',
		'US1840025007' => 'Abeytas',
		'US1840024927' => 'Tecolotito',
		'US1840040160' => 'Pajarito Mesa',
		'US1840026912' => 'Talpa',
		'US1840040082' => 'Homestead',
		'US1840019415' => 'University Park',
		'US1840025029' => 'Nogal',
		'US1840025023' => 'Datil',
		'US1840022641' => 'Angel Fire',
		'US1840039998' => 'City of the Sun',
		'US1840024968' => 'San Rafael',
		'US1840017767' => 'Cañada de los Alamos',
		'US1840019013' => 'Vadito',
		'US1840019401' => 'Mescalero',
		'US1840033726' => 'Las Maravillas',
		'US1840018990' => 'Naschitti',
		'US1840022728' => 'House',
		'US1840022615' => 'Chama',
		'US1840033721' => 'North Valley',
		'US1840033699' => 'San Felipe Pueblo',
		'US1840022633' => 'Folsom',
		'US1840024975' => 'Sedillo',
		'US1840033714' => 'Rio en Medio',
		'US1840019416' => 'Vado',
		'US1840024850' => 'La Plata',
		'US1840025073' => 'Mimbres',
		'US1840022638' => 'Taos',
		'US1840040190' => 'Rancho Grande',
		'US1840033662' => 'Puerto de Luna',
		'US1840025050' => 'Las Palomas',
		'US1840018988' => 'Shiprock',
		'US1840025051' => 'Oasis',
		'US1840025011' => 'La Joya',
		'US1840020683' => 'Las Cruces',
		'US1840026908' => 'Arroyo Hondo',
		'US1840017890' => 'Manzano',
		'US1840073920' => 'Los Cerrillos',
		'US1840138478' => 'Gallina',
		'US1840023009' => 'Silver City',
		'US1840040168' => 'Pecan Park',
		'US1840024978' => 'Newkirk',
		'US1840020627' => 'Elephant Butte',
		'US1840020549' => 'Roswell',
		'US1840033706' => 'San Ildefonso Pueblo',
		'US1840022816' => 'Grady',
		'US1840040157' => 'Morningside',
		'US1840018038' => 'Boles Acres',
		'US1840020617' => 'Lovington',
		'US1840073903' => 'Cannon AFB',
		'US1840024836' => 'La Villita',
		'US1840026937' => 'Rowe',
		'US1840019458' => 'Deming',
		'US1840020469' => 'Moriarty',
		'US1840040081' => 'Highland Meadows',
		'US1840040219' => 'Ventura',
		'US1840138523' => 'La Cueva',
		'US1840022035' => 'Hurley',
		'US1840033713' => 'Pueblo of Sandia Village',
		'US1840025021' => 'Aragon',
		'US1840024966' => 'San Fidel',
		'US1840037076' => 'Holloman AFB',
		'US1840017770' => 'Madrid',
		'US1840025024' => 'Glenwood',
		'US1840025083' => 'Garfield',
		'US1840022872' => 'Corona',
		'US1840017669' => 'Beclabito',
		'US1840019090' => 'Ramah',
		'US1840040152' => 'Middle Frisco',
		'US1840024847' => 'Blanco',
		'US1840019403' => 'Alamogordo',
		'US1840023025' => 'Hatch',
		'US1840026936' => 'East Pecos',
		'US1840019087' => 'Nakaibito',
		'US1840019064' => 'Placitas',
		'US1840019094' => 'Yah-ta-hey',
		'US1840022873' => 'Ruidoso',
		'US1840019014' => 'Taos Pueblo',
		'US1840021840' => 'Texico',
		'US1840017904' => 'Jarales',
		'US1840026910' => 'Costilla',
		'US1840025041' => 'Nadine',
		'US1840024964' => 'Fence Lake',
		'US1840024928' => 'Villanueva',
		'US1840025065' => 'Arenas Valley',
		'US1840025068' => 'Cobre',
		'US1840017774' => 'La Cienega',
		'US1840025045' => 'Arrey',
		'US1840018050' => 'Chaparral',
		'US1840025061' => 'Orogrande',
		'US1840138585' => 'San Antonito',
		'US1840019068' => 'Santa Ana Pueblo',
		'US1840024841' => 'Pueblito',
		'US1840019342' => 'Jal',
		'US1840022807' => 'Encino',
		'US1840017876' => 'Cedar Crest',
		'US1840019063' => 'Peña Blanca',
		'US1840023032' => 'Hope',
		'US1840024921' => 'North San Ysidro',
		'US1840033712' => 'Lake Sumner',
		'US1840019409' => 'Doña Ana',
		'US1840022682' => 'Cuba',
		'US1840026913' => 'Ute Park',
		'US1840022642' => 'Cimarron',
		'US1840025088' => 'Rodey',
		'US1840022643' => 'Eagle Nest',
		'US1840025020' => 'Apache Creek',
		'US1840017871' => 'Laguna',
		'US1840020534' => 'Ruidoso Downs',
		'US1840025086' => 'Organ',
		'US1840136422' => 'Ohkay Owingeh',
		'US1840039992' => 'Bluewater Village',
		'US1840026965' => 'McIntosh',
		'US1840020740' => 'Lordsburg',
		'US1840033624' => 'Pinon',
		'US1840024962' => 'Bibo',
		'US1840018993' => 'Aztec',
		'US1840021933' => 'Dexter',
		'US1840022813' => 'Bosque Farms',
		'US1840019071' => 'Zia Pueblo',
		'US1840024963' => 'Cubero',
		'US1840033719' => 'Eldorado at Santa Fe',
		'US1840022808' => 'Willard',
		'US1840024944' => 'Nara Visa',
		'US1840022817' => 'Melrose',
		'US1840019408' => 'Bayard',
		'US1840019089' => 'Pueblo Pintado',
		'US1840025079' => 'White Signal',
		'US1840024994' => 'El Cerro',
		'US1840022631' => 'Clayton',
		'US1840033725' => 'Nenahnezad',
		'US1840024820' => 'Brazos',
		'US1840025010' => 'Escondida',
		'US1840024829' => 'Dixon',
		'US1840024819' => 'Abiquiu',
		'US1840022639' => 'Questa',
		'US1840040031' => 'Faywood',
		'US1840024851' => 'Navajo Dam',
		'US1840020397' => 'Las Vegas',
		'US1840033565' => 'Lee Acres',
		'US1840025046' => 'Caballo',
		'US1840025028' => 'Quemado',
		'US1840024970' => 'Cedro',
		'US1840022814' => 'Los Lunas',
		'US1840040018' => 'Escudilla Bonita',
		'US1840040078' => 'Happy Valley',
		'US1840025085' => 'La Union',
		'US1840021739' => 'Tucumcari',
		'US1840024849' => 'Lake Valley',
		'US1840025078' => 'Tyrone',
		'US1840025081' => 'Chamberino',
		'US1840025084' => 'La Mesa',
		'US1840020616' => 'Hobbs',
		'US1840136740' => 'Torreon',
		'US1840017762' => 'Church Rock',
		'US1840022795' => 'Los Ranchos de Albuquerque',
		'US1840024833' => 'Hernandez',
		'US1840019105' => 'White Rock',
		'US1840074474' => 'Napi Headquarters',
		'US1840019412' => 'Rincon',
		'US1840040012' => 'Indian Hills',
		'US1840022870' => 'Carrizozo',
		'US1840024826' => 'Chili',
		'US1840025093' => 'Atoka',
		'US1840017666' => 'Alcalde',
		'US1840040217' => 'Twin Forks',
		'US1840024853' => 'Waterflow',
		'US1840019413' => 'Salem',
		'US1840021935' => 'Lake Arthur',
		'US1840024989' => 'Duran',
		'US1840022632' => 'Des Moines',
		'US1840138606' => 'Tecolote',
		'US1840024903' => 'Cañon',
		'US1840017877' => 'Chilili',
		'US1840025008' => 'Alamillo',
		'US1840019192' => 'Meadow Lake',
		'US1840019065' => 'Ponderosa',
		'US1840021898' => 'Socorro',
		'US1840024967' => 'San Mateo',
		'US1840024915' => 'Nambe',
		'US1840019172' => 'Paraje',
		'US1840017771' => 'Galisteo',
		'US1840025015' => 'Polvadera',
		'US1840024992' => 'Adelino',
		'US1840033724' => 'South Valley',
		'US1840025063' => 'Sacramento',
		'US1840025064' => 'Weed',
		'US1840022679' => 'Wagon Mound',
		'US1840040159' => 'North Light Plant',
		'US1840025096' => 'Malaga',
		'US1840033696' => 'Jemez Pueblo',
		'US1840022796' => 'Tijeras',
		'US1840026984' => 'Midway',
		'US1840019194' => 'Belen',
		'US1840039982' => 'Bluewater Acres',
		'US1840040137' => 'Livingston Wheeler',
		'US1840040220' => 'West Hammond',
		'US1840024830' => 'El Duende',
		'US1840018987' => 'Sheep Springs',
		'US1840017903' => 'Los Chaves',
		'US1840025026' => 'Pie Town',
		'US1840024844' => 'Truchas',
		'US1840033717' => 'Upper Fruitland',
		'US1840023024' => 'Mesilla',
		'US1840022797' => 'Vaughn',
		'US1840033665' => 'Mountain View',
		'US1840017773' => 'Jaconita',
		'US1840024913' => 'Golden',
		'US1840024839' => 'Lumberton',
		'US1840019195' => 'Clovis',
		'US1840040014' => 'Edith Endave',
		'US1840025016' => 'San Acacia',
		'US1840017678' => 'Chamisal',
		'US1840026911' => 'San Cristobal',
		'US1840019009' => 'Peñasco',
		'US1840019174' => 'Seama',
		'US1840033664' => 'Sunland Park',
		'US1840019414' => 'Santa Teresa',
		'US1840074409' => 'Skyline-Ganipa',
		'US1840018039' => 'La Luz',
		'US1840043200' => 'North Hobbs',
		'US1840017667' => 'Chimayo',
		'US1840019443' => 'Artesia',
		'US1840017670' => 'Flora Vista',
		'US1840017932' => 'Alamo',
		'US1840020452' => 'Grants',
		'US1840017768' => 'Cedar Grove',
		'US1840022730' => 'San Jon',
		'US1840022684' => 'San Ysidro',
		'US1840019104' => 'Tesuque',
		'US1840022640' => 'Springer',
		'US1840019069' => 'Santo Domingo Pueblo',
		'US1840025019' => 'Veguita',
		'US1840024834' => 'La Madera',
		'US1840019444' => 'Carlsbad',
		'US1840024838' => 'Los Ojos',
		'US1840022683' => 'Jemez Springs',
		'US1840022717' => 'Pecos',
		'US1840017744' => 'La Jara',
		'US1840024974' => 'Sandia Park',
		'US1840042455' => 'McCartys Village',
		'US1840074353' => 'Cuartelez',
		'US1840023048' => 'Columbus',
		'US1840022685' => 'Mosquero',
		'US1840025060' => 'Mayhill',
		'US1840019093' => 'Twin Lakes',
		'US1840025070' => 'Gila',
		'US1840040182' => 'Pulpotio Bareas',
		'US1840017764' => 'Black Rock',
		'US1840040127' => 'Lake Roberts Heights',
		'US1840018989' => 'Nageezi',
		'US1840017769' => 'El Rancho',
		'US1840025059' => 'High Rolls',
		'US1840023002' => 'Tularosa',
		'US1840025103' => 'Rodeo',
		'US1840019101' => 'Pojoaque',
		'US1840025082' => 'Fairacres',
		'US1840022827' => 'Fort Sumner',
		'US1840024848' => 'Cedar Hill',
		'US1840020529' => 'Portales',
		'US1840022644' => 'Maxwell',
		'US1840024925' => 'Soham',
		'US1840025025' => 'Luna',
		'US1840073262' => 'Isleta Village Proper',
		'US1840019173' => 'Pinehill',
		'US1840024854' => 'Capulin',
		'US1840023001' => 'Cloudcroft',
		'US1840025104' => 'Windmill',
		'US1840033718' => 'Acomita Lake',
		'US1840022781' => 'Milan',
		'US1840019193' => 'Valencia',
		'US1840025072' => 'Hanover',
		'US1840040085' => 'La Hacienda',
		'US1840022634' => 'Grenville',
		'US1840025049' => 'Kingston',
		'US1840018985' => 'Dulce',
		'US1840024914' => 'Jacona',
		'US1840020395' => 'Gallup',
		'US1840020348' => 'Española',
		'US1840024845' => 'Velarde',
		'US1840024843' => 'Tierra Amarilla',
		'US1840017742' => 'Algodones',
		'US1840025074' => 'North Hurley',
		'US1840021897' => 'Elida',
		'US1840019098' => 'Cundiyo',
		'US1840021707' => 'Santa Fe',
		'US1840022815' => 'Peralta',
		'US1840017668' => 'Crystal',
		'US1840025077' => 'San Lorenzo',
		'US1840026991' => 'Monument',
		'US1840024840' => 'Lyden',
		'US1840024965' => 'Moquino',
		'US1840025022' => 'Cruzville',
		'US1840019170' => 'Mesita',
		'US1840033708' => 'Tesuque Pueblo',
		'US1840024821' => 'Canjilon',
		'US1840019092' => 'Tse Bonito',
		'US1840040216' => 'Trout Valley',
		'US1840033715' => 'Rock Springs',
		'US1840024995' => 'Madrone',
		'US1840026966' => 'Tome',
		'US1840025017' => 'San Antonio',
		'US1840023041' => 'Virden',
		'US1840025107' => 'Sunshine',
		'US1840138591' => 'San Jose',
		'US1840025100' => 'Animas',
		'US1840019066' => 'Regina',
		'US1840019010' => 'Picuris Pueblo',
		'US1840024969' => 'Seboyeta',
		'US1840024916' => 'San Pedro',
		'US1840025067' => 'Cliff',
		'US1840018049' => 'Anthony',
		'US1840040111' => 'Lake Roberts',
		'US1840025101' => 'Cotton City',
		'US1840022841' => 'Reserve',
	],
	'TX' => [
		'US1840021973' => 'Trenton',
		'US1840036212' => 'Cuevitas',
		'US1840022996' => 'Union Valley',
		'US1840019673' => 'Brazoria',
		'US1840022039' => 'Strawn',
		'US1840017998' => 'Lake Kiowa',
		'US1840073263' => 'Homestead Meadows South',
		'US1840037041' => 'Del Mar Heights',
		'US1840022707' => 'Sanford',
		'US1840019459' => 'Oak Trail Shores',
		'US1840020594' => 'Paris',
		'US1840023129' => 'San Saba',
		'US1840019723' => 'Zapata',
		'US1840020850' => 'Hearne',
		'US1840020691' => 'Hudson Oaks',
		'US1840020980' => 'Lake Jackson',
		'US1840037060' => 'Los Alvarez',
		'US1840022090' => 'Stanton',
		'US1840023253' => 'Normanna',
		'US1840022133' => 'Blanket',
		'US1840041140' => 'Martinez',
		'US1840040668' => 'Casas',
		'US1840020978' => 'Oyster Creek',
		'US1840019580' => 'Alpine',
		'US1840022178' => 'Roman Forest',
		'US1840026059' => 'Sarita',
		'US1840041136' => 'Manuel Garcia',
		'US1840020771' => 'Eustace',
		'US1840019548' => 'Burke',
		'US1840021916' => 'Edmonson',
		'US1840023050' => 'Venus',
		'US1840020883' => 'Presidio',
		'US1840020569' => 'Nocona',
		'US1840026027' => 'McDade',
		'US1840022184' => 'Round Mountain',
		'US1840019581' => 'Sanderson',
		'US1840022007' => 'DISH',
		'US1840020765' => 'Gorman',
		'US1840023128' => 'Melvin',
		'US1840020789' => 'Reklaw',
		'US1840026050' => 'Port OConnor',
		'US1840022121' => 'Blum',
		'US1840022115' => 'Blooming Grove',
		'US1840020965' => 'Liberty',
		'US1840026019' => 'Hull',
		'US1840037059' => 'Llano Grande',
		'US1840018145' => 'Gardendale',
		'US1840020769' => 'New London',
		'US1840019584' => 'Porter Heights',
		'US1840021981' => 'Shallowater',
		'US1840020913' => 'Hempstead',
		'US1840020570' => 'Avery',
		'US1840020745' => 'Gladewater',
		'US1840019611' => 'China',
		'US1840018235' => 'Harper',
		'US1840020848' => 'Fort Stockton',
		'US1840037110' => 'Loma Grande',
		'US1840022107' => 'Tatum',
		'US1840020977' => 'Manvel',
		'US1840040893' => 'Juarez',
		'US1840040840' => 'Garza-Salinas II',
		'US1840023109' => 'Wortham',
		'US1840037075' => 'Ratamosa',
		'US1840037072' => 'Rancho Banquete',
		'US1840020717' => 'Rockwall',
		'US1840023214' => 'Payne Springs',
		'US1840037077' => 'Solis',
		'US1840041379' => 'Paloma Creek',
		'US1840020862' => 'Midway',
		'US1840019743' => 'Brownsville',
		'US1840019468' => 'Joshua',
		'US1840020948' => 'Rosenberg',
		'US1840019384' => 'Bridgeport',
		'US1840040868' => 'Jardin de San Julian',
		'US1840021037' => 'Los Fresnos',
		'US1840019274' => 'Amherst',
		'US1840020729' => 'Moran',
		'US1840019741' => 'Tierra Bonita',
		'US1840025888' => 'Welch',
		'US1840020788' => 'Gallatin',
		'US1840019052' => 'Dalhart',
		'US1840041341' => 'Olmito and Olmito',
		'US1840020749' => 'Granbury',
		'US1840019700' => 'Asherton',
		'US1840020960' => 'Live Oak',
		'US1840020726' => 'Hamlin',
		'US1840019724' => 'Salineño',
		'US1840019551' => 'Kempner',
		'US1840037040' => 'Coyote Acres',
		'US1840020657' => 'McKinney',
		'US1840018252' => 'Barrett',
		'US1840019547' => 'Crockett',
		'US1840022234' => 'Texas City',
		'US1840019689' => 'Quemado',
		'US1840020776' => 'Murchison',
		'US1840022264' => 'Laguna Vista',
		'US1840018323' => 'Lasara',
		'US1840041132' => 'Los Lobos',
		'US1840022016' => 'Wolfe City',
		'US1840022087' => 'Westbrook',
		'US1840020923' => 'Hedwig Village',
		'US1840018247' => 'Central Gardens',
		'US1840022020' => 'St. Paul',
		'US1840018276' => 'Blessing',
		'US1840020530' => 'Quanah',
		'US1840023143' => 'Briarcliff',
		'US1840019535' => 'Cushing',
		'US1840019570' => 'College Station',
		'US1840018037' => 'Elbert',
		'US1840020905' => 'Mountain City',
		'US1840037043' => 'Doolittle',
		'US1840020783' => 'Hillsboro',
		'US1840020914' => 'Pattison',
		'US1840025867' => 'Montague',
		'US1840020703' => 'North Richland Hills',
		'US1840037100' => 'West Odessa',
		'US1840041133' => 'Los Minerales',
		'US1840021341' => 'New Braunfels',
		'US1840021880' => 'Tulia',
		'US1840023169' => 'Rangerville',
		'US1840023146' => 'The Hills',
		'US1840037108' => 'Amaya',
		'US1840023026' => 'Yantis',
		'US1840020936' => 'Lockhart',
		'US1840021961' => 'Lindsay',
		'US1840022124' => 'Walnut Springs',
		'US1840022199' => 'South Houston',
		'US1840027020' => 'Hornsby Bend',
		'US1840022193' => 'Vidor',
		'US1840020462' => 'Hereford',
		'US1840073268' => 'Rosita',
		'US1840020674' => 'ODonnell',
		'US1840025939' => 'Redfield',
		'US1840019460' => 'Pecan Plantation',
		'US1840020705' => 'Lake Worth',
		'US1840019368' => 'Bryson',
		'US1840037026' => 'Timbercreek Canyon',
		'US1840023145' => 'San Leanna',
		'US1840019250' => 'Childress',
		'US1840022088' => 'Loraine',
		'US1840021982' => 'Slaton',
		'US1840020811' => 'Lorena',
		'US1840020895' => 'Giddings',
		'US1840021951' => 'Detroit',
		'US1840020886' => 'Oak Ridge North',
		'US1840021884' => 'Estelline',
		'US1840135494' => 'Brushy Creek',
		'US1840037018' => 'Rose Hill Acres',
		'US1840037080' => 'South Point',
		'US1840018146' => 'Lake Brownwood',
		'US1840019545' => 'Milam',
		'US1840018314' => 'Falcon Village',
		'US1840040950' => 'La Loma de Falcon',
		'US1840022011' => 'Hackberry',
		'US1840019628' => 'Bulverde',
		'US1840020841' => 'Golinda',
		'US1840020945' => 'New Berlin',
		'US1840022144' => 'Kosse',
		'US1840020872' => 'Mason',
		'US1840037141' => 'Edgewater Estates',
		'US1840040842' => 'Gutierrez',
		'US1840020889' => 'Rollingwood',
		'US1840040781' => 'Falconaire',
		'US1840019506' => 'Abbott',
		'US1840073284' => 'Circle D-KC Estates',
		'US1840019406' => 'Daingerfield',
		'US1840022207' => 'Round Top',
		'US1840019665' => 'Jamaica Beach',
		'US1840021032' => 'La Joya',
		'US1840037070' => 'Ranchitos Las Lomas',
		'US1840019709' => 'Ingleside',
		'US1840025893' => 'Elmo',
		'US1840022054' => 'Seagoville',
		'US1840042640' => 'Tierra Verde',
		'US1840019591' => 'Jonestown',
		'US1840040786' => 'Flor del Rio',
		'US1840019316' => 'Bogata',
		'US1840021034' => 'Lyford',
		'US1840022265' => 'Los Indios',
		'US1840036333' => 'Scissors',
		'US1840041567' => 'Tierra Dorada',
		'US1840022032' => 'Bloomburg',
		'US1840023003' => 'Plains',
		'US1840040705' => 'El Brazil',
		'US1840020946' => 'Fulshear',
		'US1840019607' => 'Del Rio',
		'US1840020809' => 'Hewitt',
		'US1840026053' => 'Holiday Beach',
		'US1840022111' => 'Tool',
		'US1840041320' => 'Olivia Lopez de Gutierrez',
		'US1840020879' => 'Round Rock',
		'US1840041548' => 'South La Paloma',
		'US1840019634' => 'Beach City',
		'US1840020656' => 'Lucas',
		'US1840020904' => 'Hays',
		'US1840041577' => 'Valle Verde',
		'US1840020663' => 'Princeton',
		'US1840023168' => 'South Padre Island',
		'US1840141549' => 'Coyote Flats',
		'US1840022160' => 'Buckholts',
		'US1840019556' => 'Belton',
		'US1840019533' => 'Chireno',
		'US1840020833' => 'Grapeland',
		'US1840023200' => 'Citrus City',
		'US1840019637' => 'McQueeney',
		'US1840023132' => 'Corrigan',
		'US1840022131' => 'Frankston',
		'US1840020870' => 'Marble Falls',
		'US1840037032' => 'Alice Acres',
		'US1840020648' => 'Bartonville',
		'US1840019273' => 'Spade',
		'US1840022009' => 'Ponder',
		'US1840019085' => 'Cactus',
		'US1840019705' => 'Oilton',
		'US1840023117' => 'Thornton',
		'US1840022255' => 'San Diego',
		'US1840021024' => 'McAllen',
		'US1840019699' => 'Cotulla',
		'US1840019334' => 'Archer City',
		'US1840020808' => 'Hallsburg',
		'US1840022192' => 'Rocksprings',
		'US1840022130' => 'Elkhart',
		'US1840040812' => 'Fronton Ranchettes',
		'US1840022093' => 'Tye',
		'US1840019573' => 'Hutto',
		'US1840023106' => 'Wells',
		'US1840023044' => 'Victoria',
		'US1840041565' => 'Tanquecitos South Acres II',
		'US1840019736' => 'Santa Monica',
		'US1840022156' => 'Rogers',
		'US1840022986' => 'Rosharon',
		'US1840023096' => 'Mildred',
		'US1840019598' => 'Daisetta',
		'US1840037143' => 'Owl Ranch',
		'US1840020988' => 'Pleasanton',
		'US1840019275' => 'Earth',
		'US1840019554' => 'Calvert',
		'US1840022077' => 'Whitehouse',
		'US1840019442' => 'Duncanville',
		'US1840019674' => 'Brookside Village',
		'US1840019610' => 'Brookshire',
		'US1840018270' => 'Louise',
		'US1840019181' => 'Claude',
		'US1840020698' => 'Haltom City',
		'US1840037071' => 'Rancho Alegre',
		'US1840022198' => 'Shoreacres',
		'US1840022946' => 'Whiteface',
		'US1840020781' => 'Rice',
		'US1840018250' => 'Aldine',
		'US1840023112' => 'Vinton',
		'US1840020963' => 'Hondo',
		'US1840019552' => 'Iraan',
		'US1840025040' => 'Guthrie',
		'US1840037051' => 'K-Bar Ranch',
		'US1840023151' => 'San Felipe',
		'US1840022210' => 'Wallis',
		'US1840020599' => 'Goree',
		'US1840022746' => 'Skellytown',
		'US1840074629' => 'Sandy Hollow-Escondidas',
		'US1840021984' => 'Ransom Canyon',
		'US1840018299' => 'Falcon Mesa',
		'US1840040778' => 'Eugenio Saenz',
		'US1840022181' => 'Lexington',
		'US1840023174' => 'Navasota',
		'US1840019653' => 'Alamo Heights',
		'US1840040738' => 'El Quiote',
		'US1840022109' => 'Seven Points',
		'US1840020706' => 'Farmers Branch',
		'US1840019473' => 'Blackwell',
		'US1840037124' => 'Los Ebanos',
		'US1840018297' => 'Guerra',
		'US1840022232' => 'Spofford',
		'US1840040662' => 'Casa Blanca',
		'US1840025172' => 'Ramireno',
		'US1840020714' => 'Lancaster',
		'US1840021923' => 'Wichita Falls',
		'US1840020859' => 'Rockdale',
		'US1840022185' => 'Kenefick',
		'US1840020842' => 'Lott',
		'US1840019546' => 'Kennard',
		'US1840020658' => 'Melissa',
		'US1840022023' => 'Winfield',
		'US1840022939' => 'Pampa',
		'US1840020520' => 'Quitaque',
		'US1840026054' => 'Lamar',
		'US1840022589' => 'Latexo',
		'US1840020637' => 'Lake Bridgeport',
		'US1840021912' => 'Vernon',
		'US1840023056' => 'Carbon',
		'US1840021954' => 'Southmayd',
		'US1840037139' => 'McKinney Acres',
		'US1840019703' => 'Austwell',
		'US1840036367' => 'Baileys Prairie',
		'US1840020837' => 'Mertzon',
		'US1840019606' => 'Dripping Springs',
		'US1840019318' => 'Callisburg',
		'US1840020596' => 'Honey Grove',
		'US1840037115' => 'Sunset Acres',
		'US1840020967' => 'Hallettsville',
		'US1840020752' => 'Grandview',
		'US1840020857' => 'Goodrich',
		'US1840037056' => 'Las Lomitas',
		'US1840019180' => 'Canyon',
		'US1840019620' => 'Jersey Village',
		'US1840021013' => 'Kingsville',
		'US1840020979' => 'Pearland',
		'US1840020968' => 'Sabinal',
		'US1840020909' => 'Rose City',
		'US1840019601' => 'Devers',
		'US1840025870' => 'Preston',
		'US1840019523' => 'San Elizario',
		'US1840020711' => 'Rowlett',
		'US1840019438' => 'Irving',
		'US1840020961' => 'Olmos Park',
		'US1840037067' => 'Olivarez',
		'US1840020693' => 'Euless',
		'US1840019394' => 'Commerce',
		'US1840037082' => 'Tradewinds',
		'US1840040694' => 'Colorado Acres',
		'US1840019582' => 'Redford',
		'US1840018199' => 'Fort Davis',
		'US1840036243' => 'Heidelberg',
		'US1840023036' => 'Oak Ridge',
		'US1840020756' => 'Maypearl',
		'US1840019249' => 'Dimmitt',
		'US1840022256' => 'San Juan',
		'US1840023114' => 'Tenaha',
		'US1840019681' => 'Van Vleck',
		'US1840021030' => 'Pharr',
		'US1840040722' => 'Elias-Fela Solis',
		'US1840023147' => 'Volente',
		'US1840018263' => 'Kingsbury',
		'US1840019440' => 'Dallas',
		'US1840041134' => 'Los Nopalitos',
		'US1840018245' => 'Lake View',
		'US1840040654' => 'Box Canyon',
		'US1840020542' => 'Electra',
		'US1840020690' => 'Mingus',
		'US1840020572' => 'Bells',
		'US1840022247' => 'Seadrift',
		'US1840037133' => 'Morgan Farm',
		'US1840019702' => 'Carrizo Springs',
		'US1840019592' => 'Creedmoor',
		'US1840021020' => 'Edinburg',
		'US1840020926' => 'Humble',
		'US1840020907' => 'Kyle',
		'US1840023252' => 'El Paso',
		'US1840021017' => 'Roma',
		'US1840020540' => 'Olton',
		'US1840019664' => 'Bayou Vista',
		'US1840022748' => 'McLean',
		'US1840018234' => 'Hudson Bend',
		'US1840019712' => 'Benavides',
		'US1840020855' => 'Newton',
		'US1840019272' => 'Abernathy',
		'US1840019393' => 'Campbell',
		'US1840022171' => 'Somerville',
		'US1840020912' => 'Pinehurst',
		'US1840019390' => 'Denton',
		'US1840022217' => 'Sugar Land',
		'US1840041465' => 'Ramirez-Perez',
		'US1840019083' => 'Borger',
		'US1840022051' => 'White Settlement',
		'US1840019315' => 'Clarksville',
		'US1840019425' => 'Benbrook',
		'US1840019156' => 'Amarillo',
		'US1840022117' => 'Emhouse',
		'US1840020669' => 'Newcastle',
		'US1840022119' => 'Retreat',
		'US1840040975' => 'Loma Linda West',
		'US1840019714' => 'Alice',
		'US1840019732' => 'Alamo',
		'US1840020538' => 'Plainview',
		'US1840020754' => 'Ennis',
		'US1840020822' => 'Mexia',
		'US1840018287' => 'Catarina',
		'US1840019623' => 'Boerne',
		'US1840019284' => 'Dean',
		'US1840019549' => 'Diboll',
		'US1840019472' => 'Colorado City',
		'US1840037123' => 'Loma Vista',
		'US1840019426' => 'Blue Mound',
		'US1840020920' => 'Port Neches',
		'US1840019356' => 'Cooper',
		'US1840019558' => 'South Toledo Bend',
		'US1840018286' => 'Brundage',
		'US1840019432' => 'Dalworthington Gardens',
		'US1840018327' => 'Laureles',
		'US1840022146' => 'San Angelo',
		'US1840042658' => 'Westwood Shores',
		'US1840019629' => 'Columbus',
		'US1840040951' => 'La Minita',
		'US1840023047' => 'Winona',
		'US1840020812' => 'Riesel',
		'US1840020667' => 'Post',
		'US1840019385' => 'Decatur',
		'US1840019737' => 'Sebastian',
		'US1840023103' => 'Bynum',
		'US1840019669' => 'Clute',
		'US1840022180' => 'West Lake Hills',
		'US1840037119' => 'West Alto Bonito',
		'US1840020747' => 'Kilgore',
		'US1840020954' => 'Nixon',
		'US1840020660' => 'Nevada',
		'US1840022173' => 'Shenandoah',
		'US1840022226' => 'Windcrest',
		'US1840020671' => 'Haskell',
		'US1840020888' => 'Patton Village',
		'US1840074867' => 'Spring Valley Village',
		'US1840020824' => 'Goldthwaite',
		'US1840020867' => 'Granite Shoals',
		'US1840018282' => 'Batesville',
		'US1840022373' => 'Anderson',
		'US1840019464' => 'Cleburne',
		'US1840021881' => 'Happy',
		'US1840020992' => 'Pearsall',
		'US1840019675' => 'Danbury',
		'US1840019655' => 'Converse',
		'US1840022214' => 'Seguin',
		'US1840020681' => 'Avinger',
		'US1840020876' => 'Granger',
		'US1840020678' => 'Hughes Springs',
		'US1840019400' => 'Jayton',
		'US1840037019' => 'Morgans Point Resort',
		'US1840022169' => 'Todd Mission',
		'US1840074237' => 'Lackland AFB',
		'US1840022243' => 'Yorktown',
		'US1840020655' => 'Lowry Crossing',
		'US1840022188' => 'San Marcos',
		'US1840022058' => 'Highland Park',
		'US1840019685' => 'Moore',
		'US1840073919' => 'Loma Linda East',
		'US1840022995' => 'Neylandville',
		'US1840019450' => 'Kaufman',
		'US1840037039' => 'Cinco Ranch',
		'US1840022230' => 'Shiner',
		'US1840037053' => 'Laredo Ranchettes',
		'US1840020598' => 'Ravenna',
		'US1840022943' => 'Windthorst',
		'US1840040845' => 'H. Cuellar Estates',
		'US1840019519' => 'Brownwood',
		'US1840020930' => 'Pasadena',
		'US1840020680' => 'Queen City',
		'US1840019677' => 'Lolita',
		'US1840022220' => 'San Antonio',
		'US1840037127' => 'Evergreen',
		'US1840020891' => 'Mustang Ridge',
		'US1840021035' => 'Raymondville',
		'US1840019281' => 'Bellevue',
		'US1840020707' => 'Garland',
		'US1840040855' => 'Hillside Acres',
		'US1840020868' => 'Highland Haven',
		'US1840036411' => 'Coupland',
		'US1840019640' => 'Zuehl',
		'US1840022231' => 'Uvalde',
		'US1840019682' => 'Bay City',
		'US1840026058' => 'Riviera',
		'US1840020652' => 'Quinlan',
		'US1840026055' => 'Banquete',
		'US1840042592' => 'Lake Cherokee',
		'US1840020758' => 'Oak Leaf',
		'US1840023110' => 'Van Horn',
		'US1840019713' => 'Sandia',
		'US1840020826' => 'Oglesby',
		'US1840019392' => 'Caddo Mills',
		'US1840019086' => 'Dumas',
		'US1840019643' => 'Mission Bend',
		'US1840020944' => 'Marion',
		'US1840022612' => 'Liberty Hill',
		'US1840020635' => 'Newark',
		'US1840040882' => 'J.F. Villareal',
		'US1840019578' => 'Caldwell',
		'US1840041531' => 'Santel',
		'US1840020537' => 'Petersburg',
		'US1840020767' => 'Henderson',
		'US1840020932' => 'La Porte',
		'US1840019735' => 'Port Mansfield',
		'US1840023093' => 'Von Ormy',
		'US1840022229' => 'Wharton',
		'US1840037135' => 'Las Quintas Fronterizas',
		'US1840022172' => 'Sonora',
		'US1840019419' => 'Cool',
		'US1840020547' => 'Henrietta',
		'US1840021914' => 'Roaring Springs',
		'US1840019389' => 'Corinth',
		'US1840020601' => 'Holliday',
		'US1840019663' => 'Clear Lake Shores',
		'US1840025053' => 'Lantana',
		'US1840023004' => 'Meadow',
		'US1840022066' => 'Post Oak Bend City',
		'US1840026049' => 'Seco Mines',
		'US1840020892' => 'Pflugerville',
		'US1840022062' => 'Stamford',
		'US1840020632' => 'Rhome',
		'US1840018035' => 'Briar',
		'US1840019544' => 'Barstow',
		'US1840037086' => 'Westdale',
		'US1840020916' => 'Groves',
		'US1840019647' => 'Beasley',
		'US1840037047' => 'Falcon Lake Estates',
		'US1840020921' => 'El Lago',
		'US1840019522' => 'Dell City',
		'US1840023247' => 'Tira',
		'US1840022167' => 'Weir',
		'US1840019282' => 'Byers',
		'US1840041468' => 'Ranchitos East',
		'US1840025177' => 'Los Barreras',
		'US1840020744' => 'Easton',
		'US1840022125' => 'Alto',
		'US1840040710' => 'El Castillo',
		'US1840019082' => 'Canadian',
		'US1840020634' => 'New Fairview',
		'US1840019478' => 'Dublin',
		'US1840020574' => 'Muenster',
		'US1840019641' => 'Cumings',
		'US1840019518' => 'Bangs',
		'US1840020849' => 'Franklin',
		'US1840022067' => 'Kemp',
		'US1840019278' => 'Burkburnett',
		'US1840020650' => 'Hawk Cove',
		'US1840037131' => 'La Paloma Addition',
		'US1840026039' => 'Macdona',
		'US1840020902' => 'Plum Grove',
		'US1840025912' => 'Sand Springs',
		'US1840040863' => 'Indio',
		'US1840040757' => 'El Socio',
		'US1840020712' => 'Sachse',
		'US1840020733' => 'Big Sandy',
		'US1840022112' => 'Trinidad',
		'US1840022989' => 'Northlake',
		'US1840019053' => 'Lipscomb',
		'US1840019500' => 'Athens',
		'US1840020803' => 'Fairfield',
		'US1840019624' => 'Bellville',
		'US1840022881' => 'Matador',
		'US1840023051' => 'Milford',
		'US1840020702' => 'Mansfield',
		'US1840041378' => 'Palo Blanco',
		'US1840018277' => 'Markham',
		'US1840022060' => 'Seagraves',
		'US1840020763' => 'Roscoe',
		'US1840020709' => 'Grand Prairie',
		'US1840042591' => 'Horseshoe Bend',
		'US1840020607' => 'Ropesville',
		'US1840020782' => 'Glen Rose',
		'US1840021755' => 'Vega',
		'US1840022195' => 'Waller',
		'US1840022204' => 'Webster',
		'US1840017761' => 'Hartley',
		'US1840018150' => 'Fort Hancock',
		'US1840022249' => 'Fulton',
		'US1840019725' => 'San Isidro',
		'US1840020984' => 'Edna',
		'US1840020928' => 'Hermleigh',
		'US1840019593' => 'Stonewall',
		'US1840020746' => 'Longview',
		'US1840022120' => 'Richland',
		'US1840020604' => 'Lubbock',
		'US1840019727' => 'Monte Alto',
		'US1840019383' => 'Aurora',
		'US1840019676' => 'Cuero',
		'US1840041487' => 'Sammy Martinez',
		'US1840019516' => 'Coleman',
		'US1840022240' => 'Stockdale',
		'US1840019257' => 'Chillicothe',
		'US1840022092' => 'Tuscola',
		'US1840023267' => 'Coldspring',
		'US1840022259' => 'San Perlita',
		'US1840020463' => 'Hedley',
		'US1840019479' => 'Clyde',
		'US1840019557' => 'Deweyville',
		'US1840022203' => 'Tomball',
		'US1840019517' => 'Ballinger',
		'US1840020854' => 'Killeen',
		'US1840040749' => 'El Rancho Vela',
		'US1840020840' => 'Lufkin',
		'US1840019572' => 'Cedar Park',
		'US1840022048' => 'Southlake',
		'US1840018281' => 'Hilltop',
		'US1840022021' => 'Fairview',
		'US1840018257' => 'Comfort',
		'US1840019399' => 'Josephine',
		'US1840019612' => 'Beaumont',
		'US1840023149' => 'Bear Creek',
		'US1840020956' => 'Grey Forest',
		'US1840027028' => 'La Casita',
		'US1840037081' => 'Tierra Grande',
		'US1840020519' => 'Kress',
		'US1840022940' => 'Windom',
		'US1840022037' => 'Winnsboro',
		'US1840019716' => 'Agua Dulce',
		'US1840019340' => 'De Kalb',
		'US1840019441' => 'DeSoto',
		'US1840037037' => 'César Chávez',
		'US1840020786' => 'Meridian',
		'US1840022034' => 'Douglassville',
		'US1840037128' => 'B and E',
		'US1840019446' => 'Anson',
		'US1840020801' => 'Hamilton',
		'US1840025179' => 'Abram',
		'US1840021012' => 'Port Aransas',
		'US1840018268' => 'Cross Mountain',
		'US1840018264' => 'Fifth Street',
		'US1840019587' => 'Shady Hollow',
		'US1840019466' => 'Briaroaks',
		'US1840021019' => 'Edcouch',
		'US1840037033' => 'Blue Berry Hill',
		'US1840023130' => 'Salado',
		'US1840023029' => 'Pantego',
		'US1840026062' => 'Hargill',
		'US1840019251' => 'Bovina',
		'US1840019691' => 'Skidmore',
		'US1840022098' => 'Cross Plains',
		'US1840018316' => 'Garceno',
		'US1840019471' => 'Big Spring',
		'US1840022049' => 'Watauga',
		'US1840042590' => 'Holly Lake Ranch',
		'US1840020953' => 'Gonzales',
		'US1840020730' => 'East Mountain',
		'US1840020966' => 'El Campo',
		'US1840025880' => 'Perrin',
		'US1840022500' => 'DHanis',
		'US1840020651' => 'Lone Oak',
		'US1840019470' => 'Bardwell',
		'US1840037073' => 'Rancho Chico',
		'US1840022159' => 'Livingston',
		'US1840020687' => 'Gordon',
		'US1840041112' => 'Los Corralitos',
		'US1840037114' => 'San Carlos I',
		'US1840021038' => 'Rio Hondo',
		'US1840022237' => 'West Columbia',
		'US1840037144' => 'Siesta Acres',
		'US1840022150' => 'Grandfalls',
		'US1840022994' => 'Westlake',
		'US1840022005' => 'The Colony',
		'US1840037023' => 'Los Ybanez',
		'US1840020633' => 'Runaway Bay',
		'US1840037052' => 'Lago',
		'US1840025163' => 'Alfred',
		'US1840021670' => 'Darrouzett',
		'US1840020983' => 'Nordheim',
		'US1840020751' => 'Godley',
		'US1840037034' => 'Butterfield',
		'US1840018278' => 'Bloomington',
		'US1840139817' => 'Redland',
		'US1840019336' => 'Crosbyton',
		'US1840020982' => 'La Vernia',
		'US1840019566' => 'Bertram',
		'US1840020536' => 'Hale Center',
		'US1840023165' => 'Woodsboro',
		'US1840037074' => 'Ranchos Penitas West',
		'US1840020882' => 'Marfa',
		'US1840019404' => 'Brownfield',
		'US1840020592' => 'Reno',
		'US1840020713' => 'Mesquite',
		'US1840022029' => 'Denver City',
		'US1840019396' => 'Allen',
		'US1840018225' => 'Marathon',
		'US1840020931' => 'Piney Point Village',
		'US1840018152' => 'Fabens',
		'US1840022128' => 'Wink',
		'US1840019454' => 'Canton',
		'US1840019449' => 'Jefferson',
		'US1840020950' => 'Missouri City',
		'US1840022727' => 'Nazareth',
		'US1840019331' => 'Bailey',
		'US1840018248' => 'Cloverleaf',
		'US1840020779' => 'Frost',
		'US1840019728' => 'North Alamo',
		'US1840021953' => 'Sherman',
		'US1840020830' => 'Rankin',
		'US1840019619' => 'Jacinto City',
		'US1840020689' => 'Mineral Wells',
		'US1840003907' => 'Little River-Academy',
		'US1840018151' => 'Canutillo',
		'US1840022132' => 'Winters',
		'US1840041108' => 'Los Arrieros',
		'US1840022095' => 'Lawn',
		'US1840020773' => 'Log Cabin',
		'US1840019731' => 'Linn',
		'US1840022113' => 'Enchanted Oaks',
		'US1840025869' => 'Sunset',
		'US1840040600' => 'Airport Heights',
		'US1840019437' => 'Hutchins',
		'US1840020626' => 'Pecan Gap',
		'US1840022155' => 'Troy',
		'US1840019730' => 'San Carlos',
		'US1840020723' => 'Roby',
		'US1840042593' => 'Lake Colorado City',
		'US1840020981' => 'Floresville',
		'US1840019498' => 'Beckville',
		'US1840020856' => 'Kirbyville',
		'US1840020602' => 'Lorenzo',
		'US1840041137' => 'Manuel Garcia II',
		'US1840021971' => 'Toco',
		'US1840023054' => 'Merkel',
		'US1840041619' => 'Zarate',
		'US1840019051' => 'Morse',
		'US1840019738' => 'Olmito',
		'US1840042533' => 'Cedar Point',
		'US1840020800' => 'Miles',
		'US1840074271' => 'Lakeshore Gardens-Hidden Acres',
		'US1840018271' => 'Hungerford',
		'US1840021703' => 'Stinnett',
		'US1840019510' => 'Comanche',
		'US1840020999' => 'Rockport',
		'US1840021041' => 'La Feria',
		'US1840020796' => 'Kermit',
		'US1840022041' => 'Weatherford',
		'US1840022208' => 'Flatonia',
		'US1840020694' => 'Everman',
		'US1840021950' => 'Annona',
		'US1840022239' => 'Holiday Lakes',
		'US1840020927' => 'Hunters Creek Village',
		'US1840018283' => 'La Pryor',
		'US1840019531' => 'Bellmead',
		'US1840019615' => 'Spring',
		'US1840022215' => 'Simonton',
		'US1840023008' => 'Marietta',
		'US1840023006' => 'Como',
		'US1840019461' => 'Brazos Bend',
		'US1840022174' => 'Splendora',
		'US1840037129' => 'Buena Vista',
		'US1840020750' => 'Lipan',
		'US1840073267' => 'Chula Vista',
		'US1840023318' => 'Barton Creek',
		'US1840018303' => 'Flowella',
		'US1840023034' => 'Mabank',
		'US1840020760' => 'Pecan Hill',
		'US1840022177' => 'Cut and Shoot',
		'US1840023138' => 'Iola',
		'US1840021883' => 'Turkey',
		'US1840020922' => 'Galena Park',
		'US1840020877' => 'Leander',
		'US1840019503' => 'Barry',
		'US1840021005' => 'Odem',
		'US1840019718' => 'Corpus Christi',
		'US1840020794' => 'Odessa',
		'US1840019524' => 'Tornillo',
		'US1840023155' => 'Weston Lakes',
		'US1840023137' => 'Millican',
		'US1840037452' => 'Texhoma',
		'US1840037013' => 'Morgans Point',
		'US1840018262' => 'Geronimo',
		'US1840019654' => 'Balcones Heights',
		'US1840020761' => 'Red Oak',
		'US1840019431' => 'Crowley',
		'US1840020903' => 'Elgin',
		'US1840019688' => 'Crystal City',
		'US1840041486' => 'Salineño North',
		'US1840018273' => 'Bacliff',
		'US1840022089' => 'Sweetwater',
		'US1840020642' => 'Oak Point',
		'US1840022151' => 'Zavalla',
		'US1840018265' => 'Four Corners',
		'US1840020816' => 'McGregor',
		'US1840022147' => 'Broaddus',
		'US1840019539' => 'Centerville',
		'US1840022135' => 'Kirvin',
		'US1840023124' => 'Oakwood',
		'US1840022213' => 'Schertz',
		'US1840020989' => 'Poteet',
		'US1840018301' => 'Airport Road Addition',
		'US1840020919' => 'Port Arthur',
		'US1840020672' => 'OBrien',
		'US1840022244' => 'Runge',
		'US1840040675' => 'Chapeno',
		'US1840019434' => 'Cockrell Hill',
		'US1840020996' => 'Port Lavaca',
		'US1840022081' => 'Tolar',
		'US1840022129' => 'Bronte',
		'US1840020639' => 'Lewisville',
		'US1840019463' => 'DeCordova',
		'US1840025986' => 'Indian Springs',
		'US1840019369' => 'Jacksboro',
		'US1840019435' => 'Balch Springs',
		'US1840027023' => 'Driftwood',
		'US1840022123' => 'Valley Mills',
		'US1840021822' => 'Wellington',
		'US1840022114' => 'Poynor',
		'US1840022202' => 'Taylor Lake Village',
		'US1840019658' => 'East Bernard',
		'US1840023031' => 'Sunnyvale',
		'US1840018198' => 'Evadale',
		'US1840022096' => 'Rising Star',
		'US1840037134' => 'Del Sol',
		'US1840020548' => 'Petrolia',
		'US1840019279' => 'Iowa Park',
		'US1840019614' => 'Sheldon',
		'US1840019314' => 'Bowie',
		'US1840019588' => 'Wells Branch',
		'US1840022031' => 'Sulphur Springs',
		'US1840021823' => 'Dodson',
		'US1840019577' => 'Bedias',
		'US1840020464' => 'Howardwick',
		'US1840019721' => 'New Falcon',
		'US1840020825' => 'Gatesville',
		'US1840020814' => 'Ross',
		'US1840020962' => 'Kirby',
		'US1840022221' => 'Selma',
		'US1840019520' => 'Early',
		'US1840019436' => 'Carrollton',
		'US1840021955' => 'Tom Bean',
		'US1840025897' => 'Myrtle Springs',
		'US1840037035' => 'Cantu Addition',
		'US1840040644' => 'Bonanza Hills',
		'US1840023164' => 'Christine',
		'US1840023122' => 'South Mountain',
		'US1840020753' => 'Rio Vista',
		'US1840037085' => 'Villa Verde',
		'US1840020701' => 'River Oaks',
		'US1840019433' => 'Cedar Hill',
		'US1840022190' => 'Wimberley',
		'US1840019477' => 'Cisco',
		'US1840020682' => 'Pittsburg',
		'US1840019701' => 'Big Wells',
		'US1840020735' => 'Edom',
		'US1840022200' => 'Southside Place',
		'US1840019427' => 'Hurst',
		'US1840023140' => 'Stagecoach',
		'US1840020806' => 'Pecos',
		'US1840021917' => 'Sudan',
		'US1840021007' => 'Freer',
		'US1840022175' => 'Willis',
		'US1840074430' => 'Morales-Sanchez',
		'US1840022782' => 'New Deal',
		'US1840020684' => 'Hawkins',
		'US1840022149' => 'Pyote',
		'US1840037103' => 'Arroyo Colorado Estates',
		'US1840021949' => 'St. Jo',
		'US1840019475' => 'Potosi',
		'US1840141563' => 'Sandy Point',
		'US1840019626' => 'Industry',
		'US1840019604' => 'Brenham',
		'US1840022141' => 'West',
		'US1840021003' => 'Gregory',
		'US1840020708' => 'Glenn Heights',
		'US1840020394' => 'Fritch',
		'US1840019501' => 'Brownsboro',
		'US1840020985' => 'Ganado',
		'US1840022074' => 'Bullard',
		'US1840025872' => 'Powderly',
		'US1840023102' => 'Penelope',
		'US1840073285' => 'Taft Southwest',
		'US1840021885' => 'Lakeview',
		'US1840019560' => 'Jasper',
		'US1840022187' => 'Burton',
		'US1840020380' => 'Follett',
		'US1840021023' => 'Hidalgo',
		'US1840020815' => 'Mart',
		'US1840020571' => 'Gunter',
		'US1840020755' => 'Ferris',
		'US1840019605' => 'Buda',
		'US1840019448' => 'Breckenridge',
		'US1840022223' => 'Somerset',
		'US1840022246' => 'Three Rivers',
		'US1840040904' => 'La Coma',
		'US1840020378' => 'Gruver',
		'US1840020613' => 'New Boston',
		'US1840022947' => 'Opdyke West',
		'US1840025984' => 'Sam Rayburn',
		'US1840040673' => 'Chaparrito',
		'US1840020790' => 'Rusk',
		'US1840034871' => 'La Feria North',
		'US1840022143' => 'Crawford',
		'US1840019532' => 'Beverly Hills',
		'US1840037142' => 'Falman',
		'US1840025815' => 'Boys Ranch',
		'US1840041298' => 'Netos',
		'US1840022165' => 'Taylor',
		'US1840022934' => 'Collinsville',
		'US1840021008' => 'Orange Grove',
		'US1840020935' => 'Leakey',
		'US1840019717' => 'Bishop',
		'US1840020799' => 'Novice',
		'US1840020645' => 'Krum',
		'US1840042595' => 'Lake Medina Shores',
		'US1840019565' => 'Huntsville',
		'US1840019690' => 'Eagle Pass',
		'US1840037027' => 'Millers Cove',
		'US1840019693' => 'Pawnee',
		'US1840022260' => 'San Benito',
		'US1840019636' => 'Cove',
		'US1840018197' => 'Buna',
		'US1840018322' => 'Havana',
		'US1840020964' => 'Natalia',
		'US1840021015' => 'Escobares',
		'US1840021756' => 'Groom',
		'US1840022082' => 'Cross Timber',
		'US1840041191' => 'Mi Ranchito Estate',
		'US1840019179' => 'Samnorwood',
		'US1840021669' => 'Booker',
		'US1840019635' => 'Stowell',
		'US1840073286' => 'Encantada-Ranchito-El Calaboz',
		'US1840022209' => 'Sealy',
		'US1840037140' => 'Arroyo Gardens',
		'US1840037137' => 'Amargosa',
		'US1840019657' => 'Devine',
		'US1840019562' => 'Cameron',
		'US1840018298' => 'Hebbronville',
		'US1840023115' => 'Coolidge',
		'US1840037055' => 'Lasana',
		'US1840020685' => 'Mineola',
		'US1840021497' => 'Palo Pinto',
		'US1840021033' => 'La Villa',
		'US1840022136' => 'Socorro',
		'US1840040620' => 'Amada Acres',
		'US1840021957' => 'Whitesboro',
		'US1840026046' => 'Matagorda',
		'US1840040643' => 'Benjamin Perez',
		'US1840022084' => 'Alma',
		'US1840020381' => 'Higgins',
		'US1840019502' => 'Angus',
		'US1840042587' => 'Fabrica',
		'US1840022045' => 'Annetta South',
		'US1840040782' => 'Fernando Salinas',
		'US1840023144' => 'Point Venture',
		'US1840020974' => 'Freeport',
		'US1840019711' => 'Realitos',
		'US1840019631' => 'Bandera',
		'US1840019452' => 'Cottonwood',
		'US1840020802' => 'Hico',
		'US1840020884' => 'Magnolia',
		'US1840022091' => 'Buffalo Gap',
		'US1840020649' => 'Greenville',
		'US1840022015' => 'West Tawakoni',
		'US1840020911' => 'Pine Forest',
		'US1840022236' => 'Sweeny',
		'US1840022999' => 'Throckmorton',
		'US1840040612' => 'Alto Bonito Heights',
		'US1840020641' => 'Roanoke',
		'US1840020659' => 'Murphy',
		'US1840019639' => 'Cibolo',
		'US1840020766' => 'Ranger',
		'US1840037094' => 'Mila Doce',
		'US1840019474' => 'Andrews',
		'US1840041163' => 'Miguel Barrera',
		'US1840022013' => 'Hickory Creek',
		'US1840036514' => 'Monahans',
		'US1840023152' => 'Thompsons',
		'US1840023037' => 'Scurry',
		'US1840025871' => 'Sherwood Shores',
		'US1840041466' => 'Ramos',
		'US1840023040' => 'Nesbitt',
		'US1840023116' => 'Tehuacana',
		'US1840022052' => 'Edgecliff Village',
		'US1840020991' => 'Falls City',
		'US1840018312' => 'El Refugio',
		'US1840018300' => 'Lopeño',
		'US1840019672' => 'Angleton',
		'US1840020874' => 'Florence',
		'US1840020851' => 'Harker Heights',
		'US1840022162' => 'Wixon Valley',
		'US1840022176' => 'Woodbranch',
		'US1840023107' => 'Santa Anna',
		'US1840022061' => 'Seminole',
		'US1840020777' => 'Berryville',
		'US1840020679' => 'Linden',
		'US1840022228' => 'Hollywood Park',
		'US1840020597' => 'Leonard',
		'US1840022993' => 'Trophy Club',
		'US1840020834' => 'Lovelady',
		'US1840022593' => 'Leming',
		'US1840041588' => 'Valle Vista',
		'US1840022042' => 'Willow Park',
		'US1840023192' => 'Redwater',
		'US1840022191' => 'Woodcreek',
		'US1840020609' => 'Leary',
		'US1840019424' => 'Bedford',
		'US1840023042' => 'Valley View',
		'US1840020836' => 'Eden',
		'US1840019421' => 'Rendon',
		'US1840020958' => 'Hill Country Village',
		'US1840036731' => 'Nina',
		'US1840018326' => 'Laguna Heights',
		'US1840022163' => 'Kurten',
		'US1840020787' => 'Morgan',
		'US1840020727' => 'Hawley',
		'US1840022134' => 'Teague',
		'US1840020924' => 'Hilshire Village',
		'US1840022006' => 'Cross Roads',
		'US1840021668' => 'Spearman',
		'US1840021987' => 'Texarkana',
		'US1840022038' => 'Alba',
		'US1840019395' => 'Celina',
		'US1840020829' => 'McCamey',
		'US1840040696' => 'East Alto Bonito',
		'US1840020813' => 'Robinson',
		'US1840022211' => 'Weimar',
		'US1840022179' => 'Sunset Valley',
		'US1840023111' => 'Clint',
		'US1840019595' => 'Johnson City',
		'US1840034872' => 'Midway North',
		'US1840018324' => 'Lozano',
		'US1840019398' => 'Blue Ridge',
		'US1840020915' => 'Grand Saline',
		'US1840037036' => 'Carrizo Hill',
		'US1840019337' => 'Idalou',
		'US1840036718' => 'Laguna Seca',
		'US1840019630' => 'Eagle Lake',
		'US1840037062' => 'Los Veteranos II',
		'US1840020662' => 'Plano',
		'US1840023121' => 'Mullin',
		'US1840019439' => 'Coppell',
		'US1840019550' => 'Brady',
		'US1840020952' => 'Orchard',
		'US1840020379' => 'Perryton',
		'US1840020810' => 'Leroy',
		'US1840020929' => 'Nassau Bay',
		'US1840020843' => 'Rosebud',
		'US1840043421' => 'Providence Village',
		'US1840020791' => 'New Summerfield',
		'US1840022263' => 'Indian Lake',
		'US1840026014' => 'Wildwood',
		'US1840040932' => 'La Esperanza',
		'US1840019571' => 'Serenada',
		'US1840019386' => 'Argyle',
		'US1840019625' => 'Brazos Country',
		'US1840021026' => 'Mission',
		'US1840019600' => 'Dayton Lakes',
		'US1840023158' => 'Moulton',
		'US1840022056' => 'Wilmer',
		'US1840020724' => 'Rotan',
		'US1840022235' => 'Surfside Beach',
		'US1840042639' => 'Thunderbird Bay',
		'US1840022139' => 'Timpson',
		'US1840026057' => 'Ricardo',
		'US1840041568' => 'Travis Ranch',
		'US1840041420' => 'Pena',
		'US1840022055' => 'University Park',
		'US1840041618' => 'Villarreal',
		'US1840037025' => 'Lake Tanglewood',
		'US1840019668' => 'Damon',
		'US1840027027' => 'Staples',
		'US1840019569' => 'Bryan',
		'US1840018243' => 'Camp Swift',
		'US1840020595' => 'Ector',
		'US1840042564' => 'China Spring',
		'US1840023100' => 'Malone',
		'US1840020940' => 'Garden Ridge',
		'US1840022252' => 'Taft',
		'US1840040931' => 'La Escondida',
		'US1840042574' => 'Country Acres',
		'US1840021006' => 'Portland',
		'US1840020521' => 'Hart',
		'US1840023108' => 'Streetman',
		'US1840020741' => 'Hideaway',
		'US1840019332' => 'Bonham',
		'US1840019617' => 'Bellaire',
		'US1840019283' => 'Jolly',
		'US1840019698' => 'Beeville',
		'US1840022183' => 'Sour Lake',
		'US1840020699' => 'Haslet',
		'US1840019333' => 'Benjamin',
		'US1840020942' => 'Mont Belvieu',
		'US1840019504' => 'Kerens',
		'US1840023166' => 'Combes',
		'US1840025143' => 'Iago',
		'US1840019514' => 'Cranfills Gap',
		'US1840019638' => 'Redwood',
		'US1840020972' => 'La Marque',
		'US1840037130' => 'Paisano Park',
		'US1840041485' => 'Rivereno',
		'US1840040735' => 'El Mesquite',
		'US1840019687' => 'Dilley',
		'US1840019521' => 'Sierra Blanca',
		'US1840020666' => 'Mount Pleasant',
		'US1840023133' => 'Valentine',
		'US1840022012' => 'Hebron',
		'US1840020821' => 'Groesbeck',
		'US1840019660' => 'Uvalde Estates',
		'US1840022212' => 'Santa Clara',
		'US1840037079' => 'South Fork Estates',
		'US1840020918' => 'Nome',
		'US1840019329' => 'Blossom',
		'US1840019422' => 'Arlington',
		'US1840020720' => 'East Tawakoni',
		'US1840020638' => 'Highland Village',
		'US1840020731' => 'Gilmer',
		'US1840022189' => 'Uhland',
		'US1840022205' => 'West University Place',
		'US1840040962' => 'Las Haciendas',
		'US1840018182' => 'Coyanosa',
		'US1840025171' => 'Las Palmas',
		'US1840022152' => 'Richland Springs',
		'US1840019651' => 'Timberwood Park',
		'US1840022674' => 'Texline',
		'US1840022936' => 'Whitewright',
		'US1840020739' => 'Marshall',
		'US1840020831' => 'Hemphill',
		'US1840022227' => 'Utopia',
		'US1840019430' => 'Colleyville',
		'US1840020646' => 'Lake Dallas',
		'US1840020819' => 'Garrison',
		'US1840019679' => 'Charlotte',
		'US1840023055' => 'Trent',
		'US1840018233' => 'Garfield',
		'US1840020768' => 'Mount Enterprise',
		'US1840020778' => 'Eureka',
		'US1840019642' => 'Sienna Plantation',
		'US1840022028' => 'Wilson',
		'US1840022025' => 'Rochester',
		'US1840020647' => 'Lakewood Village',
		'US1840019594' => 'Blanco',
		'US1840021977' => 'Scotland',
		'US1840073264' => 'Midway South',
		'US1840019633' => 'Anahuac',
		'US1840037064' => 'Morning Glory',
		'US1840018318' => 'Las Lomas',
		'US1840021036' => 'Harlingen',
		'US1840020993' => 'Goliad',
		'US1840019599' => 'Dayton',
		'US1840018296' => 'Concepcion',
		'US1840023141' => 'Woodloch',
		'US1840023134' => 'Chester',
		'US1840025142' => 'Boling',
		'US1840020654' => 'Frisco',
		'US1840022094' => 'Impact',
		'US1840020832' => 'Pineland',
		'US1840019729' => 'Relampago',
		'US1840019622' => 'Carmine',
		'US1840022168' => 'Shepherd',
		'US1840019645' => 'Pecan Grove',
		'US1840019608' => 'Ingram',
		'US1840041441' => 'Quesada',
		'US1840018325' => 'La Paloma',
		'US1840019462' => 'Cresson',
		'US1840019429' => 'Kennedale',
		'US1840020899' => 'Hardin',
		'US1840037066' => 'North Escobares',
		'US1840022008' => 'Double Oak',
		'US1840020866' => 'New Waverly',
		'US1840020673' => 'New Home',
		'US1840022030' => 'Wellman',
		'US1840020897' => 'Kountze',
		'US1840025965' => 'Hilltop Lakes',
		'US1840022250' => 'San Patricio',
		'US1840019455' => 'Arp',
		'US1840020994' => 'George West',
		'US1840022027' => 'Tahoka',
		'US1840003906' => 'Bruceville-Eddy',
		'US1840019567' => 'Burnet',
		'US1840019271' => 'Seth Ward',
		'US1840020901' => 'North Cleveland',
		'US1840026034' => 'Glidden',
		'US1840022576' => 'Knippa',
		'US1840018216' => 'Buchanan Dam',
		'US1840020959' => 'Leon Valley',
		'US1840037087' => 'West Sharyland',
		'US1840019678' => 'Vanderbilt',
		'US1840022158' => 'Seven Oaks',
		'US1840023095' => 'Coffee City',
		'US1840019586' => 'Conroe',
		'US1840019696' => 'Tulsita',
		'US1840022047' => 'Sansom Park',
		'US1840023053' => 'Coahoma',
		'US1840021040' => 'Port Isabel',
		'US1840022224' => 'Terrell Hills',
		'US1840041440' => 'Pueblo East',
		'US1840023163' => 'Jones Creek',
		'US1840020722' => 'Point',
		'US1840019391' => 'Celeste',
		'US1840020896' => 'Lumberton',
		'US1840018284' => 'El Indio',
		'US1840023125' => 'Thorntonville',
		'US1840022073' => 'Waskom',
		'US1840023113' => 'Toyah',
		'US1840023127' => 'Paint Rock',
		'US1840019499' => 'Chandler',
		'US1840022057' => 'Addison',
		'US1840021958' => 'Dorchester',
		'US1840021021' => 'Elsa',
		'US1840040969' => 'Las Palmas II',
		'US1840023105' => 'Whitney',
		'US1840019330' => 'Deport',
		'US1840020865' => 'Riverside',
		'US1840037088' => 'Yznaga',
		'US1840020971' => 'Hitchcock',
		'US1840022072' => 'Uncertain',
		'US1840022078' => 'Lindale',
		'US1840037407' => 'Point Blank',
		'US1840025889' => 'Loop',
		'US1840022590' => 'Lefors',
		'US1840020873' => 'Llano',
		'US1840025885' => 'Western Lake',
		'US1840020432' => 'Mobeetie',
		'US1840021975' => 'Ladonia',
		'US1840021758' => 'Shamrock',
		'US1840019178' => 'Quail',
		'US1840139772' => 'Cape Royale',
		'US1840019447' => 'Albany',
		'US1840022086' => 'Italy',
		'US1840041230' => 'Moraida',
		'US1840037046' => 'Elm Creek',
		'US1840074188' => 'La Paloma-Lost Creek',
		'US1840037078' => 'South Alamo',
		'US1840042522' => 'Canyon Creek',
		'US1840023027' => 'Millsap',
		'US1840019555' => 'Bartlett',
		'US1840020686' => 'Quitman',
		'US1840020908' => 'Kerrville',
		'US1840019476' => 'Abilene',
		'US1840019525' => 'Westway',
		'US1840021960' => 'Howe',
		'US1840020827' => 'Leona',
		'US1840020797' => 'Robert Lee',
		'US1840019671' => 'Alvin',
		'US1840037480' => 'Gary City',
		'US1840036257' => 'La Blanca',
		'US1840025120' => 'Study Butte',
		'US1840018285' => 'Fowlerton',
		'US1840019722' => 'San Ygnacio',
		'US1840041467' => 'Ranchitos del Norte',
		'US1840022937' => 'Knollwood',
		'US1840019317' => 'Denison',
		'US1840022099' => 'Putnam',
		'US1840021983' => 'Wolfforth',
		'US1840023162' => 'Iowa Colony',
		'US1840023030' => 'Westover Hills',
		'US1840037038' => 'Cienegas Terrace',
		'US1840019515' => 'Jacksonville',
		'US1840020817' => 'Moody',
		'US1840019680' => 'Jourdanton',
		'US1840022046' => 'Saginaw',
		'US1840020844' => 'Marlin',
		'US1840019734' => 'Donna',
		'US1840020725' => 'Lamesa',
		'US1840020828' => 'Marquez',
		'US1840020670' => 'Olney',
		'US1840034867' => 'Homestead Meadows North',
		'US1840018036' => 'Girard',
		'US1840022990' => 'Copper Canyon',
		'US1840041098' => 'Longoria',
		'US1840021956' => 'Van Alstyne',
		'US1840023150' => 'Pine Island',
		'US1840019618' => 'Bunker Hill Village',
		'US1840023097' => 'Mustang',
		'US1840019445' => 'Ackerly',
		'US1840025181' => 'Bluetown',
		'US1840020774' => 'Malakoff',
		'US1840037058' => 'La Victoria',
		'US1840019704' => 'Mirando City',
		'US1840022127' => 'Sterling City',
		'US1840025121' => 'Terlingua',
		'US1840019694' => 'Pettus',
		'US1840022154' => 'Temple',
		'US1840019397' => 'Anna',
		'US1840037045' => 'El Camino Angosto',
		'US1840025158' => 'Aguilares',
		'US1840022257' => 'Sullivan City',
		'US1840019662' => 'San Leon',
		'US1840020525' => 'Friona',
		'US1840023052' => 'Palmer',
		'US1840037112' => 'Los Altos',
		'US1840022745' => 'Panhandle',
		'US1840018246' => 'Mauriceville',
		'US1840020764' => 'Eastland',
		'US1840019656' => 'Castroville',
		'US1840018251' => 'Atascocita',
		'US1840019382' => 'Chico',
		'US1840020738' => 'Hallsville',
		'US1840022253' => 'Lake City',
		'US1840026041' => 'Fort Clark Springs',
		'US1840021027' => 'Palmhurst',
		'US1840020898' => 'Fredericksburg',
		'US1840020612' => 'Nash',
		'US1840019538' => 'Copperas Cove',
		'US1840019697' => 'Tynan',
		'US1840019568' => 'Cottonwood Shores',
		'US1840019719' => 'Driscoll',
		'US1840019695' => 'Tuleta',
		'US1840042575' => 'Emerald Bay',
		'US1840021959' => 'Pottsboro',
		'US1840022040' => 'Springtown',
		'US1840020934' => 'La Grange',
		'US1840022002' => 'Boyd',
		'US1840036161' => 'Amistad',
		'US1840019666' => 'Kemah',
		'US1840019542' => 'Crane',
		'US1840020677' => 'Omaha',
		'US1840022882' => 'Paducah',
		'US1840022233' => 'Santa Fe',
		'US1840037125' => 'Murillo',
		'US1840018293' => 'Edroy',
		'US1840022945' => 'Buffalo Springs',
		'US1840022079' => 'Warren City',
		'US1840018302' => 'Encino',
		'US1840037065' => 'Muniz',
		'US1840019507' => 'Aquilla',
		'US1840043403' => 'Randolph AFB',
		'US1840019553' => 'Bremond',
		'US1840037050' => 'Indian Hills',
		'US1840019720' => 'Siesta Shores',
		'US1840020603' => 'Ralls',
		'US1840022798' => 'Palisades',
		'US1840020939' => 'Fair Oaks Ranch',
		'US1840020668' => 'Graham',
		'US1840037069' => 'Ranchette Estates',
		'US1840022251' => 'Sinton',
		'US1840018321' => 'Faysville',
		'US1840020573' => 'Gainesville',
		'US1840139791' => 'Lake Bryan',
		'US1840020820' => 'Nacogdoches',
		'US1840074884' => 'Westworth Village',
		'US1840021009' => 'Premont',
		'US1840023126' => 'Wickett',
		'US1840022218' => 'Smiley',
		'US1840136274' => 'Medina',
		'US1840020643' => 'Pilot Point',
		'US1840019276' => 'Crowell',
		'US1840022050' => 'St. Hedwig',
		'US1840020716' => 'Heath',
		'US1840020770' => 'Overton',
		'US1840020762' => 'Forsan',
		'US1840022080' => 'White Oak',
		'US1840020933' => 'Fayetteville',
		'US1840019540' => 'Buffalo',
		'US1840019648' => 'Katy',
		'US1840020608' => 'Hooks',
		'US1840023028' => 'Sanctuary',
		'US1840020606' => 'Levelland',
		'US1840040713' => 'El Chaparral',
		'US1840022182' => 'Silsbee',
		'US1840019613' => 'Bevil Oaks',
		'US1840022948' => 'Smyer',
		'US1840036177' => 'Bixby',
		'US1840019529' => 'Huxley',
		'US1840020688' => 'Graford',
		'US1840020894' => 'Lakeway',
		'US1840019667' => 'Dickinson',
		'US1840040642' => 'Barrera',
		'US1840021978' => 'Lakeside City',
		'US1840019457' => 'Clarksville City',
		'US1840022186' => 'Smithville',
		'US1840020997' => 'Encinal',
		'US1840037048' => 'Grape Creek',
		'US1840019277' => 'Cashion Community',
		'US1840022935' => 'Tioga',
		'US1840041111' => 'Los Centenarios',
		'US1840023035' => 'Oak Grove',
		'US1840021004' => 'Mathis',
		'US1840022083' => 'Waxahachie',
		'US1840037089' => 'Zapata Ranch',
		'US1840041099' => 'Los Arcos',
		'US1840023148' => 'Webberville',
		'US1840041264' => 'Narciso Pena',
		'US1840018274' => 'Bolivar Peninsula',
		'US1840022010' => 'Flower Mound',
		'US1840041490' => 'San Carlos II',
		'US1840019469' => 'Keene',
		'US1840018315' => 'Fronton',
		'US1840023154' => 'Pleak',
		'US1840019627' => 'Camp Wood',
		'US1840020951' => 'Needville',
		'US1840022018' => 'Wylie',
		'US1840019497' => 'Carthage',
		'US1840020653' => 'Farmersville',
		'US1840019338' => 'Anton',
		'US1840073932' => 'Fort Hood',
		'US1840020947' => 'Richmond',
		'US1840037010' => 'Goodlow',
		'US1840022065' => 'Terrell',
		'US1840022126' => 'Cuney',
		'US1840037083' => 'Val Verde Park',
		'US1840019177' => 'Clarendon',
		'US1840020728' => 'Lueders',
		'US1840020433' => 'Bishop Hills',
		'US1840019467' => 'Burleson',
		'US1840020957' => 'Helotes',
		'US1840041497' => 'Sandoval',
		'US1840020736' => 'Fruitvale',
		'US1840020969' => 'Friendswood',
		'US1840022122' => 'Gustine',
		'US1840022248' => 'Refugio',
		'US1840040960' => 'La Paloma Ranchettes',
		'US1840020955' => 'Elmendorf',
		'US1840025968' => 'Chilton',
		'US1840018249' => 'Crosby',
		'US1840021976' => 'Knox City',
		'US1840020838' => 'Hudson',
		'US1840021988' => 'Wake Village',
		'US1840018279' => 'Inez',
		'US1840019509' => 'Covington',
		'US1840003908' => 'Tiki Island',
		'US1840020757' => 'Midlothian',
		'US1840022170' => 'Snook',
		'US1840022070' => 'Edgewood',
		'US1840020995' => 'Point Comfort',
		'US1840018261' => 'Lakehills',
		'US1840023099' => 'Oak Valley',
		'US1840022216' => 'Stafford',
		'US1840020524' => 'Farwell',
		'US1840022991' => 'Corral City',
		'US1840018292' => 'La Presa',
		'US1840020664' => 'Lavon',
		'US1840022194' => 'West Orange',
		'US1840037011' => 'Ingleside on the Bay',
		'US1840022164' => 'Sunrise Beach Village',
		'US1840022166' => 'Thrall',
		'US1840020600' => 'Munday',
		'US1840019453' => 'Crandall',
		'US1840019465' => 'Alvarado',
		'US1840023005' => 'Mount Vernon',
		'US1840021001' => 'Rio Bravo',
		'US1840025160' => 'Pueblo Nuevo',
		'US1840025994' => 'Buchanan Lake Village',
		'US1840021972' => 'Savoy',
		'US1840041351' => 'Pablo Pena',
		'US1840021029' => 'Penitas',
		'US1840020772' => 'Gun Barrel City',
		'US1840026038' => 'Lake Dunlap',
		'US1840041572' => 'Valle Hermoso',
		'US1840020845' => 'Lometa',
		'US1840018254' => 'Highlands',
		'US1840018317' => 'La Puerta',
		'US1840042627' => 'Pine Harbor',
		'US1840022261' => 'Primera',
		'US1840019480' => 'Baird',
		'US1840025924' => 'Laguna Park',
		'US1840018313' => 'Falcon Heights',
		'US1840020970' => 'Galveston',
		'US1840020925' => 'Houston',
		'US1840020695' => 'Forest Hill',
		'US1840022024' => 'Weinert',
		'US1840020871' => 'Meadowlakes',
		'US1840020938' => 'Martindale',
		'US1840022262' => 'Rancho Viejo',
		'US1840041516' => 'San Fernando',
		'US1840037095' => 'North San Pedro',
		'US1840025989' => 'Warren',
		'US1840020718' => 'Royse City',
		'US1840019686' => 'North Pearsall',
		'US1840019543' => 'Big Lake',
		'US1840023000' => 'Woodson',
		'US1840022076' => 'Tyler',
		'US1840020910' => 'Orange',
		'US1840019621' => 'Deer Park',
		'US1840019564' => 'Colmesneil',
		'US1840023254' => 'Paradise',
		'US1840020743' => 'Noonday',
		'US1840022019' => 'Prosper',
		'US1840019579' => 'Junction',
		'US1840023039' => 'Rosser',
		'US1840019742' => 'Villa del Sol',
		'US1840023202' => 'Delmita',
		'US1840037132' => 'Loma Linda',
		'US1840020990' => 'Palacios',
		'US1840020793' => 'Goldsmith',
		'US1840018253' => 'Channelview',
		'US1840037042' => 'Doffing',
		'US1840037096' => 'Pinewood Estates',
		'US1840022097' => 'Stephenville',
		'US1840019511' => 'De Leon',
		'US1840021974' => 'Dodd City',
		'US1840020839' => 'Huntington',
		'US1840020605' => 'Morton',
		'US1840022196' => 'Taylor Landing',
		'US1840021882' => 'Silverton',
		'US1840022110' => 'Star Harbor',
		'US1840021039' => 'Palm Valley',
		'US1840022206' => 'Schulenburg',
		'US1840020987' => 'Lytle',
		'US1840022068' => 'Van',
		'US1840019585' => 'The Woodlands',
		'US1840022201' => 'Tilden',
		'US1840073265' => 'Palmview South',
		'US1840021698' => 'Prairie View',
		'US1840019155' => 'Adrian',
		'US1840019590' => 'Austin',
		'US1840022145' => 'Evant',
		'US1840019574' => 'Jarrell',
		'US1840019684' => 'Kenedy',
		'US1840023161' => 'Hillcrest',
		'US1840019603' => 'Bastrop',
		'US1840018183' => 'Imperial',
		'US1840023160' => 'Bonney',
		'US1840036481' => 'LaCoste',
		'US1840003905' => 'McLendon-Chisholm',
		'US1840042606' => 'Lake Meredith Estates',
		'US1840037105' => 'Cameron Park',
		'US1840020887' => 'Panorama Village',
		'US1840020853' => 'Nolanville',
		'US1840020748' => 'Lakeport',
		'US1840022241' => 'Poth',
		'US1840020798' => 'Palestine',
		'US1840020875' => 'Georgetown',
		'US1840021980' => 'Seymour',
		'US1840022997' => 'New Hope',
		'US1840021014' => 'Falfurrias',
		'US1840026048' => 'Quail Creek',
		'US1840020869' => 'Horseshoe Bay',
		'US1840022157' => 'Holland',
		'US1840022043' => 'Annetta',
		'US1840042635' => 'Shadybrook',
		'US1840020644' => 'Krugerville',
		'US1840036772' => 'Thompsonville',
		'US1840037084' => 'Villa Pancho',
		'US1840018174' => 'Christoval',
		'US1840022883' => 'Springlake',
		'US1840022044' => 'Annetta North',
		'US1840022071' => 'Scottsville',
		'US1840021985' => 'Sundown',
		'US1840020805' => 'Horizon City',
		'US1840019428' => 'Keller',
		'US1840020719' => 'Mobile City',
		'US1840040974' => 'Las Pilas',
		'US1840019609' => 'Bridge City',
		'US1840019405' => 'Cumby',
		'US1840020885' => 'Montgomery',
		'US1840025176' => 'Garciasville',
		'US1840042516' => 'Big Thicket Lake Estates',
		'US1840026033' => 'Fannett',
		'US1840020890' => 'Manor',
		'US1840019733' => 'Alton',
		'US1840036260' => 'La Tina Ranch',
		'US1840041472' => 'Regino Ramirez',
		'US1840025987' => 'Pleasant Hill',
		'US1840041551' => 'Tanquecitos South Acres',
		'US1840020539' => 'Littlefield',
		'US1840020860' => 'Milano',
		'US1840026037' => 'Oak Island',
		'US1840042609' => 'Los Angeles',
		'US1840022238' => 'Quintana',
		'US1840073266' => 'Radar Base',
		'US1840020661' => 'Parker',
		'US1840020704' => 'Pelican Bay',
		'US1840040841' => 'Guadalupe Guerra',
		'US1840037093' => 'La Homa',
		'US1840019508' => 'Itasca',
		'US1840022069' => 'Wills Point',
		'US1840018290' => 'Botines',
		'US1840019661' => 'Brackettville',
		'US1840037097' => 'Sparks',
		'US1840020893' => 'Lago Vista',
		'US1840018266' => 'Fresno',
		'US1840020541' => 'Muleshoe',
		'US1840022063' => 'Union Grove',
		'US1840019456' => 'Liberty City',
		'US1840019616' => 'Baytown',
		'US1840019420' => 'Pecan Acres',
		'US1840037068' => 'Prado Verde',
		'US1840021666' => 'Stratford',
		'US1840021979' => 'Spur',
		'US1840021924' => 'Pleasant Valley',
		'US1840021010' => 'Robstown',
		'US1840026052' => 'Tivoli',
		'US1840022197' => 'Seabrook',
		'US1840023098' => 'Navarro',
		'US1840018217' => 'Kingsland',
		'US1840023153' => 'Fairchilds',
		'US1840020700' => 'Richland Hills',
		'US1840021025' => 'Mercedes',
		'US1840019561' => 'West Livingston',
		'US1840020949' => 'Meadows Place',
		'US1840021028' => 'Palmview',
		'US1840023167' => 'Santa Rosa',
		'US1840020986' => 'La Ward',
		'US1840020861' => 'Madisonville',
		'US1840025180' => 'Perezville',
		'US1840041135' => 'Los Veteranos I',
		'US1840021031' => 'Progreso',
		'US1840037090' => 'Laughlin AFB',
		'US1840018291' => 'Bruni',
		'US1840042520' => 'Callender Lake',
		'US1840020976' => 'Richwood',
		'US1840019597' => 'Ames',
		'US1840023142' => 'Bee Cave',
		'US1840019708' => 'Aransas Pass',
		'US1840020943' => 'Old River-Winfree',
		'US1840027001' => 'Mentone',
		'US1840025909' => 'Bristol',
		'US1840023156' => 'China Grove',
		'US1840022003' => 'Alvord',
		'US1840037146' => 'Sandy Oaks',
		'US1840020535' => 'Floydada',
		'US1840037020' => 'Sun Valley',
		'US1840022004' => 'Sanger',
		'US1840020614' => 'Red Lick',
		'US1840019683' => 'Karnes City',
		'US1840020792' => 'Midland',
		'US1840020676' => 'Naples',
		'US1840022153' => 'Trinity',
		'US1840020975' => 'Liverpool',
		'US1840019387' => 'Aubrey',
		'US1840019559' => 'Browndell',
		'US1840019513' => 'Iredell',
		'US1840019407' => 'Atlanta',
		'US1840027021' => 'Manchaca',
		'US1840021704' => 'Sunray',
		'US1840020611' => 'Maud',
		'US1840020900' => 'Garden City',
		'US1840021042' => 'Bayview',
		'US1840020973' => 'League City',
		'US1840040961' => 'Laredo Ranchettes West',
		'US1840022053' => 'Lakeside',
		'US1840021011' => 'Petronila',
		'US1840019423' => 'Azle',
		'US1840037054' => 'La Rosita',
		'US1840020807' => 'Gholson',
		'US1840037787' => 'Ivanhoe',
		'US1840023123' => 'Normangee',
		'US1840020998' => 'Bayside',
		'US1840020784' => 'Hubbard',
		'US1840020732' => 'Ore City',
		'US1840040621' => 'Anacua',
		'US1840020640' => 'Little Elm',
		'US1840019726' => 'Santa Cruz',
		'US1840019335' => 'Dickens',
		'US1840022118' => 'Powell',
		'US1840019652' => 'Castle Hills',
		'US1840040896' => 'La Chuparosa',
		'US1840021915' => 'Lockney',
		'US1840022747' => 'White Deer',
		'US1840026047' => 'Placedo',
		'US1840020742' => 'New Chapel Hill',
		'US1840037111' => 'Four Points',
		'US1840020906' => 'Niederwald',
		'US1840019528' => 'Center',
		'US1840020665' => 'Aspermont',
		'US1840019602' => 'Wyldwood',
		'US1840041547' => 'Savannah',
		'US1840019650' => 'Scenic Oaks',
		'US1840023094' => 'Caney City',
		'US1840020858' => 'Onalaska',
		'US1840019418' => 'Aledo',
		'US1840020759' => 'Ovilla',
		'US1840025996' => 'Oakhurst',
		'US1840020864' => 'Eldorado',
		'US1840019632' => 'Winnie',
		'US1840022225' => 'Universal City',
		'US1840019451' => 'Combine',
		'US1840019646' => 'Arcola',
		'US1840022142' => 'Woodway',
		'US1840022022' => 'Talco',
		'US1840023038' => 'Grays Prairie',
		'US1840021000' => 'El Cenizo',
		'US1840020715' => 'Fate',
		'US1840041447' => 'Rafael Pena',
		'US1840037145' => 'Spring Gardens',
		'US1840019541' => 'Jewett',
		'US1840020393' => 'Miami',
		'US1840020863' => 'Menard',
		'US1840041114' => 'Los Huisaches',
		'US1840037028' => 'Progreso Lakes',
		'US1840019563' => 'Ozona',
		'US1840022242' => 'Yoakum',
		'US1840023135' => 'Woodville',
		'US1840019596' => 'Cleveland',
		'US1840019527' => 'Balmorhea',
		'US1840019505' => 'Corsicana',
		'US1840025954' => 'Carlsbad',
		'US1840019740' => 'Santa Maria',
		'US1840022219' => 'Waelder',
		'US1840022085' => 'Garrett',
		'US1840020675' => 'Lone Star',
		'US1840022075' => 'Troup',
		'US1840022161' => 'Thorndale',
		'US1840019649' => 'Kendleton',
		'US1840019670' => 'Wild Peach Village',
		'US1840020734' => 'Forney',
		'US1840037044' => 'Eidson Road',
		'US1840041593' => 'Victoria Vera',
		'US1840037102' => 'Reid Hope King',
		'US1840019534' => 'Appleby',
		'US1840041177' => 'Mikes',
		'US1840022222' => 'Shavano Park',
		'US1840019388' => 'Justin',
		'US1840037107' => 'Iglesia Antigua',
		'US1840020696' => 'Fort Worth',
		'US1840022148' => 'San Augustine',
		'US1840022036' => 'Rocky Mound',
		'US1840036275' => 'Lopezville',
		'US1840040660' => 'Camargito',
		'US1840136677' => 'San Pedro',
		'US1840021016' => 'Rio Grande City',
		'US1840019084' => 'Channing',
		'US1840020785' => 'Mount Calm',
		'US1840019512' => 'Clifton',
		'US1840021952' => 'Sadler',
		'US1840020846' => 'Lampasas',
		'US1840021018' => 'La Grulla',
		'US1840040894' => 'La Carla',
		'US1840022140' => 'Waco',
		'US1840020721' => 'Emory',
		'US1840020697' => 'Grapevine',
		'US1840022059' => 'Snyder',
		'US1840021022' => 'Granjeno',
		'US1840019530' => 'Joaquin',
		'US1840021002' => 'Laredo',
		'US1840020917' => 'Nederland',
		'US1840037049' => 'Green Valley Farms',
		'US1840025098' => 'Gail',
		'US1840020523' => 'Memphis',
		'US1840041381' => 'Paloma Creek South',
		'US1840022992' => 'Shady Shores',
		'US1840073931' => 'Fort Bliss',
		'US1840020847' => 'Groveton',
		'US1840022033' => 'Domino',
		'US1840020818' => 'Lacy-Lakeview',
		'US1840022017' => 'Weston',
		'US1840020937' => 'Luling',
		'US1840022116' => 'Dawson',
		'US1840022258' => 'Weslaco',
		'US1840037101' => 'Orason',
		'US1840018280' => 'Bigfoot',
		'US1840025881' => 'Westminster',
		'US1840025868' => 'Nocona Hills',
		'US1840022942' => 'Megargel',
		'US1840018260' => 'Canyon Lake',
		'US1840023101' => 'Mertens',
		'US1840021759' => 'Wheeler',
		'US1840020775' => 'Moore Station',
		'US1840022138' => 'Anthony',
		'US1840023219' => 'Talty',
		'US1840022026' => 'Rule',
		'US1840020593' => 'Roxton',
		'US1840040661' => 'Campo Verde',
		'US1840020710' => 'Richardson',
	],
	'LA' => [
		'US1840013983' => 'Norco',
		'US1840016937' => 'Homer',
		'US1840013987' => 'Avondale',
		'US1840025133' => 'Glencoe',
		'US1840015053' => 'New Iberia',
		'US1840025138' => 'Triumph',
		'US1840025974' => 'Pitkin',
		'US1840017193' => 'White Castle',
		'US1840013981' => 'Montz',
		'US1840014963' => 'Pineville',
		'US1840018154' => 'Sicily Island',
		'US1840025949' => 'Spokane',
		'US1840013852' => 'Midway',
		'US1840025900' => 'Brownsville',
		'US1840013100' => 'Eastwood',
		'US1840017075' => 'Ferriday',
		'US1840017147' => 'Franklinton',
		'US1840018214' => 'Norwood',
		'US1840015869' => 'Boyce',
		'US1840014011' => 'Paincourtville',
		'US1840025990' => 'Ventress',
		'US1840027024' => 'Siracusaville',
		'US1840015837' => 'Winnfield',
		'US1840017145' => 'Livonia',
		'US1840015043' => 'Carencro',
		'US1840013113' => 'Cut Off',
		'US1840025899' => 'Bawcomville',
		'US1840017184' => 'Livingston',
		'US1840017167' => 'Elizabeth',
		'US1840018227' => 'Albany',
		'US1840018137' => 'Sikes',
		'US1840013988' => 'Barataria',
		'US1840018094' => 'Ringgold',
		'US1840015014' => 'Opelousas',
		'US1840039435' => 'Pleasure Bend',
		'US1840001839' => 'New Orleans',
		'US1840017194' => 'Iowa',
		'US1840013116' => 'Dulac',
		'US1840013793' => 'Bastrop',
		'US1840018164' => 'Creola',
		'US1840015942' => 'Berwick',
		'US1840014018' => 'Charenton',
		'US1840025998' => 'Oretta',
		'US1840015038' => 'DeQuincy',
		'US1840031149' => 'Brownfields',
		'US1840015026' => 'Port Allen',
		'US1840013995' => 'River Ridge',
		'US1840018143' => 'Provencal',
		'US1840018073' => 'Bonita',
		'US1840017166' => 'Kinder',
		'US1840039396' => 'Bayou Country Club',
		'US1840018208' => 'Roseland',
		'US1840017182' => 'Pearl River',
		'US1840018244' => 'Sorrento',
		'US1840014878' => 'Ruston',
		'US1840026028' => 'Lemannville',
		'US1840018204' => 'Chataignier',
		'US1840013908' => 'Hammond',
		'US1840025136' => 'Kraemer',
		'US1840025999' => 'Singer',
		'US1840014005' => 'Abbeville',
		'US1840013969' => 'Reserve',
		'US1840013974' => 'Hahnville',
		'US1840013997' => 'Harahan',
		'US1840027026' => 'Buras',
		'US1840014004' => 'Poydras',
		'US1840025123' => 'Milton',
		'US1840017195' => 'Vinton',
		'US1840013959' => 'Cecilia',
		'US1840026010' => 'Watson',
		'US1840014029' => 'Port Sulphur',
		'US1840018063' => 'Doyline',
		'US1840017200' => 'Church Point',
		'US1840013961' => 'Carlyss',
		'US1840013927' => 'Eunice',
		'US1840018064' => 'Dubberly',
		'US1840013880' => 'Bunkie',
		'US1840013984' => 'Paradis',
		'US1840025131' => 'Union',
		'US1840018237' => 'Grosse Tete',
		'US1840018121' => 'South Mansfield',
		'US1840018068' => 'Junction City',
		'US1840018076' => 'Oak Ridge',
		'US1840016967' => 'Dubach',
		'US1840025941' => 'Fort Jesup',
		'US1840014026' => 'Mathews',
		'US1840014017' => 'Bayou Vista',
		'US1840018236' => 'Parks',
		'US1840013996' => 'Gretna',
		'US1840025130' => 'St. James',
		'US1840026026' => 'Egan',
		'US1840015012' => 'Oakdale',
		'US1840013941' => 'Baton Rouge',
		'US1840018113' => 'Hodge',
		'US1840014032' => 'Chauvin',
		'US1840018060' => 'Sarepta',
		'US1840017172' => 'Melville',
		'US1840026001' => 'Lawtell',
		'US1840013964' => 'Broussard',
		'US1840018157' => 'Converse',
		'US1840013103' => 'Deville',
		'US1840018222' => 'Palmetto',
		'US1840015773' => 'Bernice',
		'US1840018077' => 'Epps',
		'US1840014974' => 'Leesville',
		'US1840031109' => 'Village St. George',
		'US1840017121' => 'Evergreen',
		'US1840025132' => 'Welcome',
		'US1840013976' => 'Bayou Gauche',
		'US1840018185' => 'Anacoco',
		'US1840017052' => 'Jonesville',
		'US1840015767' => 'Blanchard',
		'US1840016933' => 'Oil City',
		'US1840016938' => 'Marion',
		'US1840017217' => 'Golden Meadow',
		'US1840026024' => 'Roanoke',
		'US1840016984' => 'Mount Lebanon',
		'US1840015925' => 'Henderson',
		'US1840031021' => 'Vienna Bend',
		'US1840017210' => 'Delcambre',
		'US1840031150' => 'Eden Isle',
		'US1840017197' => 'Elton',
		'US1840014012' => 'Pierre Part',
		'US1840018153' => 'Harrisonburg',
		'US1840014008' => 'Belle Rose',
		'US1840017173' => 'Grand Coteau',
		'US1840017001' => 'Jonesboro',
		'US1840015838' => 'Campti',
		'US1840017170' => 'Krotz Springs',
		'US1840017192' => 'Maringouin',
		'US1840018067' => 'Athens',
		'US1840017176' => 'Port Barre',
		'US1840015821' => 'Mansfield',
		'US1840014016' => 'Amelia',
		'US1840018112' => 'East Hodge',
		'US1840018238' => 'Rosedale',
		'US1840018226' => 'Springfield',
		'US1840017204' => 'Jean Lafitte',
		'US1840017029' => 'Coushatta',
		'US1840015814' => 'Winnsboro',
		'US1840015916' => 'Brusly',
		'US1840025124' => 'Ossun',
		'US1840013994' => 'Metairie',
		'US1840017148' => 'Mamou',
		'US1840018070' => 'Downsville',
		'US1840015063' => 'Houma',
		'US1840015937' => 'Westwego',
		'US1840017057' => 'Jena',
		'US1840017159' => 'Jackson',
		'US1840013965' => 'Gonzales',
		'US1840018079' => 'Kilbourne',
		'US1840013111' => 'Estelle',
		'US1840013940' => 'Merrydale',
		'US1840015928' => 'Westlake',
		'US1840017028' => 'Newellton',
		'US1840025126' => 'Convent',
		'US1840017154' => 'Kentwood',
		'US1840025925' => 'Jordan Hill',
		'US1840016931' => 'Greenwood',
		'US1840014031' => 'Bayou Cane',
		'US1840030991' => 'Prospect',
		'US1840017110' => 'Hornbeck',
		'US1840018097' => 'Castor',
		'US1840013986' => 'Jefferson',
		'US1840018114' => 'North Hodge',
		'US1840017059' => 'Urania',
		'US1840031107' => 'Oak Hills Place',
		'US1840017174' => 'Sunset',
		'US1840015808' => 'Tallulah',
		'US1840017101' => 'Glenmora',
		'US1840013985' => 'Harvey',
		'US1840017100' => 'Cheneyville',
		'US1840015932' => 'Scott',
		'US1840018122' => 'Stanley',
		'US1840018062' => 'Dixie Inn',
		'US1840015795' => 'West Monroe',
		'US1840018165' => 'Dry Prong',
		'US1840018180' => 'McNary',
		'US1840017058' => 'Tullos',
		'US1840015772' => 'Haynesville',
		'US1840018085' => 'Simsboro',
		'US1840017169' => 'Merryville',
		'US1840017175' => 'Washington',
		'US1840025976' => 'Center Point',
		'US1840026021' => 'Hayes',
		'US1840015041' => 'Crowley',
		'US1840017063' => 'Many',
		'US1840018102' => 'Mound',
		'US1840018066' => 'Shongaloo',
		'US1840031019' => 'Lakeshore',
		'US1840015909' => 'Mandeville',
		'US1840017013' => 'Logansport',
		'US1840018119' => 'Grand Cane',
		'US1840018160' => 'Noble',
		'US1840018188' => 'Simmesport',
		'US1840016936' => 'Cullen',
		'US1840031148' => 'Woodmere',
		'US1840018059' => 'Rodessa',
		'US1840018117' => 'Baskin',
		'US1840015941' => 'Baldwin',
		'US1840018136' => 'Dodson',
		'US1840015771' => 'Springhill',
		'US1840013975' => 'Ama',
		'US1840013811' => 'Claiborne',
		'US1840018210' => 'Tickfaw',
		'US1840018201' => 'Morganza',
		'US1840017216' => 'Lockport',
		'US1840017069' => 'Colfax',
		'US1840018189' => 'Hessmer',
		'US1840018080' => 'Pioneer',
		'US1840018055' => 'Belcher',
		'US1840016935' => 'Cotton Valley',
		'US1840016932' => 'Vivian',
		'US1840015040' => 'Jennings',
		'US1840018213' => 'Slaughter',
		'US1840018065' => 'Heflin',
		'US1840023139' => 'Central',
		'US1840025902' => 'Start',
		'US1840026035' => 'Sorrel',
		'US1840017010' => 'Wisner',
		'US1840014000' => 'Arabi',
		'US1840014013' => 'Hackberry',
		'US1840025992' => 'Reddell',
		'US1840013790' => 'Bossier City',
		'US1840017205' => 'Grand Isle',
		'US1840026020' => 'Gillis',
		'US1840031153' => 'South Vacherie',
		'US1840025948' => 'Monterey',
		'US1840014014' => 'Cameron',
		'US1840025129' => 'Romeville',
		'US1840014864' => 'Minden',
		'US1840018071' => 'Lillie',
		'US1840017153' => 'Independence',
		'US1840031154' => 'Timberlane',
		'US1840018139' => 'Clarence',
		'US1840018088' => 'Rayville',
		'US1840018224' => 'Sun',
		'US1840018241' => 'Mermentau',
		'US1840025947' => 'Minorca',
		'US1840013873' => 'Alexandria',
		'US1840013982' => 'New Sarpy',
		'US1840025127' => 'Grand Point',
		'US1840017070' => 'Pollock',
		'US1840025997' => 'Longville',
		'US1840018230' => 'Port Vincent',
		'US1840016930' => 'Mooringsport',
		'US1840018095' => 'Bienville',
		'US1840018124' => 'Clarks',
		'US1840018169' => 'Ridgecrest',
		'US1840015931' => 'Youngsville',
		'US1840015056' => 'Morgan City',
		'US1840017003' => 'Eros',
		'US1840018072' => 'Spearsville',
		'US1840018191' => 'Plaucheville',
		'US1840013991' => 'Waggaman',
		'US1840018200' => 'St. Francisville',
		'US1840025122' => 'Cade',
		'US1840013978' => 'Taft',
		'US1840013905' => 'Bogalusa',
		'US1840013109' => 'Des Allemands',
		'US1840017076' => 'Vidalia',
		'US1840018118' => 'Gilbert',
		'US1840015908' => 'Zachary',
		'US1840025917' => 'Gloster',
		'US1840016945' => 'Lake Providence',
		'US1840026017' => 'Crescent',
		'US1840073836' => 'Fort Polk North',
		'US1840018215' => 'Wilson',
		'US1840014025' => 'Larose',
		'US1840015057' => 'Patterson',
		'US1840039418' => 'Moonshine',
		'US1840015770' => 'Haughton',
		'US1840015927' => 'Sulphur',
		'US1840017027' => 'Waterproof',
		'US1840014925' => 'Natchitoches',
		'US1840014034' => 'Montegut',
		'US1840018127' => 'Edgefield',
		'US1840031059' => 'Inniswold',
		'US1840018069' => 'Lisbon',
		'US1840018202' => 'Angie',
		'US1840013789' => 'Red Chute',
		'US1840015924' => 'St. Martinville',
		'US1840015910' => 'Abita Springs',
		'US1840013979' => 'Killona',
		'US1840017209' => 'Gramercy',
		'US1840031020' => 'Point Place',
		'US1840015001' => 'New Roads',
		'US1840073837' => 'Fort Polk South',
		'US1840015946' => 'Thibodaux',
		'US1840017060' => 'Olla',
		'US1840017168' => 'Oberlin',
		'US1840026022' => 'Starks',
		'US1840015037' => 'Plaquemine',
		'US1840013990' => 'Terrytown',
		'US1840015805' => 'Arcadia',
		'US1840015878' => 'Marksville',
		'US1840014033' => 'Schriever',
		'US1840025940' => 'Belmont',
		'US1840018135' => 'Calvin',
		'US1840018140' => 'Goldonna',
		'US1840014881' => 'Monroe',
		'US1840018100' => 'Saline',
		'US1840017099' => 'Lecompte',
		'US1840015045' => 'Donaldsonville',
		'US1840039401' => 'Hester',
		'US1840016976' => 'Mangham',
		'US1840014019' => 'Franklin',
		'US1840016977' => 'Delhi',
		'US1840031106' => 'Monticello',
		'US1840031100' => 'Choctaw',
		'US1840018115' => 'Quitman',
		'US1840039417' => 'Lafourche Crossing',
		'US1840013977' => 'Boutte',
		'US1840018075' => 'Mer Rouge',
		'US1840015047' => 'Kenner',
		'US1840013807' => 'Grambling',
		'US1840013993' => 'Marrero',
		'US1840015911' => 'Slidell',
		'US1840017120' => 'Cottonport',
		'US1840017198' => 'Welsh',
		'US1840018184' => 'Rosepine',
		'US1840017146' => 'Fordoche',
		'US1840018129' => 'Martin',
		'US1840025141' => 'Presquille',
		'US1840017014' => 'Stonewall',
		'US1840018058' => 'Ida',
		'US1840025934' => 'Wallace Ridge',
		'US1840017160' => 'Clinton',
		'US1840018211' => 'Montpelier',
		'US1840018223' => 'Folsom',
		'US1840015905' => 'Arnaudville',
		'US1840014001' => 'Chalmette',
		'US1840016968' => 'Vienna',
		'US1840026009' => 'Erwinville',
		'US1840014007' => 'Lydia',
		'US1840018101' => 'Delta',
		'US1840027025' => 'Boothville',
		'US1840026015' => 'Catahoula',
		'US1840026000' => 'Sugartown',
		'US1840014010' => 'Labadieville',
		'US1840013968' => 'Laplace',
		'US1840025137' => 'Lockport Heights',
		'US1840025977' => 'Fifth Ward',
		'US1840018229' => 'Killian',
		'US1840018259' => 'Napoleonville',
		'US1840017171' => 'Leonville',
		'US1840031152' => 'Shenandoah',
		'US1840018158' => 'Fisher',
		'US1840018144' => 'Robeline',
		'US1840013960' => 'Breaux Bridge',
		'US1840016939' => 'Farmerville',
		'US1840015044' => 'Lafayette',
		'US1840017185' => 'Walker',
		'US1840013963' => 'Prien',
		'US1840025139' => 'Venice',
		'US1840018209' => 'Tangipahoa',
		'US1840018203' => 'Varnado',
		'US1840016944' => 'Oak Grove',
		'US1840013938' => 'Gardere',
		'US1840018258' => 'Loreauville',
		'US1840013962' => 'Moss Bluff',
		'US1840015895' => 'Basile',
		'US1840018242' => 'Morse',
		'US1840018103' => 'Richmond',
		'US1840016985' => 'Gibsland',
		'US1840015004' => 'Ponchatoula',
		'US1840018138' => 'Ashland',
		'US1840039382' => 'Bayou Blue',
		'US1840015769' => 'Benton',
		'US1840015019' => 'Covington',
		'US1840018096' => 'Bryceland',
		'US1840014003' => 'Meraux',
		'US1840017201' => 'Duson',
		'US1840014027' => 'Raceland',
		'US1840018142' => 'Powhatan',
		'US1840018228' => 'French Settlement',
		'US1840018078' => 'Forest',
		'US1840014024' => 'Chackbay',
		'US1840018190' => 'Moreauville',
		'US1840018179' => 'Forest Hill',
		'US1840017211' => 'Erath',
		'US1840039400' => 'Bayou LOurse',
		'US1840025883' => 'Lakeview',
		'US1840018084' => 'Choudrant',
		'US1840031147' => 'Elmwood',
		'US1840018098' => 'Jamestown',
		'US1840016934' => 'Plain Dealing',
		'US1840015768' => 'Shreveport',
		'US1840017208' => 'Lutcher',
		'US1840017002' => 'Chatham',
		'US1840018205' => 'Pine Prairie',
		'US1840018255' => 'Maurice',
		'US1840017199' => 'Iota',
		'US1840018166' => 'Georgetown',
		'US1840017111' => 'New Llano',
		'US1840018057' => 'Hosston',
		'US1840013973' => 'St. Rose',
		'US1840013989' => 'Bridge City',
		'US1840017068' => 'Montgomery',
		'US1840013942' => 'Lacombe',
		'US1840015050' => 'Kaplan',
		'US1840015013' => 'DeRidder',
		'US1840018161' => 'Pleasant Hill',
		'US1840015926' => 'St. Gabriel',
		'US1840015039' => 'Lake Charles',
		'US1840018099' => 'Lucky',
		'US1840025921' => 'Banks Springs',
		'US1840013992' => 'Lafitte',
		'US1840014030' => 'Gray',
		'US1840025916' => 'Frierson',
		'US1840017212' => 'Gueydan',
		'US1840018125' => 'Grayson',
		'US1840014002' => 'Violet',
		'US1840018061' => 'Sibley',
		'US1840017181' => 'Madisonville',
		'US1840026023' => 'Lacassine',
		'US1840018159' => 'Florien',
		'US1840018074' => 'Collinston',
		'US1840025105' => 'Calhoun',
		'US1840025140' => 'Bourg',
		'US1840018240' => 'Estherwood',
		'US1840018087' => 'Richwood',
		'US1840025975' => 'Bordelonville',
		'US1840015915' => 'Addis',
		'US1840013967' => 'Wallace',
		'US1840017074' => 'Clayton',
		'US1840073882' => 'Keachi',
		'US1840018120' => 'Longstreet',
		'US1840031146' => 'Pointe a la Hache',
		'US1840025946' => 'Rock Hill',
		'US1840018134' => 'Atlanta',
		'US1840018220' => 'Reeves',
		'US1840018221' => 'Cankton',
		'US1840014028' => 'Belle Chasse',
		'US1840017064' => 'Zwolle',
		'US1840018141' => 'Natchez',
		'US1840017196' => 'Lake Arthur',
		'US1840025927' => 'St. Maurice',
		'US1840018206' => 'Turkey Creek',
		'US1840025926' => 'Joyce',
		'US1840015868' => 'Ball',
		'US1840017022' => 'Columbia',
		'US1840018126' => 'St. Joseph',
		'US1840031110' => 'Westminster',
		'US1840017157' => 'Greensburg',
		'US1840013110' => 'Destrehan',
		'US1840014023' => 'Galliano',
		'US1840015027' => 'Denham Springs',
		'US1840017102' => 'Woodworth',
		'US1840018056' => 'Gilliam',
		'US1840025128' => 'Paulina',
		'US1840013114' => 'Empire',
		'US1840026016' => 'Bayou Goula',
		'US1840013812' => 'Swartz',
		'US1840013907' => 'Natalbany',
		'US1840031151' => 'North Vacherie',
		'US1840030903' => 'Bayou Corne',
		'US1840018239' => 'Fenton',
		'US1840014009' => 'Supreme',
		'US1840013966' => 'Garyville',
		'US1840026029' => 'Prairieville',
		'US1840013980' => 'Luling',
		'US1840018128' => 'Hall Summit',
		'US1840031108' => 'Old Jefferson',
		'US1840015896' => 'Ville Platte',
		'US1840017119' => 'Mansura',
		'US1840026025' => 'Branch',
		'US1840036149' => 'Amite City',
		'US1840015042' => 'Rayne',
		'US1840015054' => 'Jeanerette',
		'US1840013107' => 'Edgard',
		'US1840016971' => 'Sterlington',
		'US1840013939' => 'Baker',
		'US1840018186' => 'Simpson',
	],
	'AK' => [
		'US1840023344' => 'Oscarville',
		'US1840023522' => 'Kasaan',
		'US1840023327' => 'Mountain Village',
		'US1840023437' => 'Tanana',
		'US1840023438' => 'Rampart',
		'US1840023408' => 'Moose Pass',
		'US1840075067' => 'Deltana',
		'US1840023262' => 'Atka',
		'US1840023319' => 'Sitka',
		'US1840023308' => 'Petersburg',
		'US1840023352' => 'Aniak',
		'US1840023491' => 'Kiana',
		'US1840023521' => 'Hydaburg',
		'US1840023388' => 'Gulkana',
		'US1840023504' => 'Brevig Mission',
		'US1840000481' => 'False Pass',
		'US1840023570' => 'Northway Village',
		'US1840023675' => 'Hobart Bay',
		'US1840023427' => 'Livengood',
		'US1840023624' => 'Nelson Lagoon',
		'US1840023512' => 'Savoonga',
		'US1840023426' => 'Lake Minchumina',
		'US1840000416' => 'Wrangell',
		'US1840023329' => 'Pilot Station',
		'US1840023471' => 'Tanacross',
		'US1840023659' => 'Point MacKenzie',
		'US1840075197' => 'Mertarvik',
		'US1840023374' => 'Susitna',
		'US1840023686' => 'Port Protection',
		'US1840023436' => 'Coldfoot',
		'US1840023683' => 'Mosquito Lake',
		'US1840023362' => 'Napaskiak',
		'US1840023479' => 'Anaktuvuk Pass',
		'US1840023348' => 'Tuluksak',
		'US1840023682' => 'Mendeltna',
		'US1840023508' => 'Golovin',
		'US1840023459' => 'Shageluk',
		'US1840023495' => 'Noorvik',
		'US1840023423' => 'Seward',
		'US1840023618' => 'Nikolaevsk',
		'US1840037713' => 'Susitna North',
		'US1840023604' => 'Salamatof',
		'US1840023588' => 'Tazlina',
		'US1840023284' => 'Iliamna',
		'US1840023507' => 'Gambell',
		'US1840023364' => 'Nunapitchuk',
		'US1840023414' => 'Cooper Landing',
		'US1840023516' => 'Naukati Bay',
		'US1840075181' => 'Farmers Loop',
		'US1840023376' => 'Trapper Creek',
		'US1840023466' => 'Dot Lake',
		'US1840023393' => 'Chistochina',
		'US1840023382' => 'Denali Park',
		'US1840023452' => 'Kaltag',
		'US1840023387' => 'Glennallen',
		'US1840023411' => 'Beluga',
		'US1840023272' => 'King Salmon',
		'US1840075202' => 'Point Possession',
		'US1840023464' => 'North Pole',
		'US1840023324' => 'Hooper Bay',
		'US1840023692' => 'Ferry',
		'US1840023375' => 'Talkeetna',
		'US1840023264' => 'St. Paul',
		'US1840023325' => 'Kotlik',
		'US1840023288' => 'Chignik Lagoon',
		'US1840023519' => 'Coffman Cove',
		'US1840023503' => 'White Mountain',
		'US1840023681' => 'Meadow Lakes',
		'US1840023305' => 'Port Lions',
		'US1840023353' => 'Bethel',
		'US1840075108' => 'Sutton-Alpine',
		'US1840023484' => 'Point Hope',
		'US1840023336' => 'Kwigillingok',
		'US1840075080' => 'Knik-Fairview',
		'US1840023615' => 'Nikiski',
		'US1840023269' => 'Sand Point',
		'US1840023301' => 'Kodiak',
		'US1840037714' => 'Kachemak',
		'US1840075075' => 'Farm Loop',
		'US1840023378' => 'Houston',
		'US1840023268' => 'King Cove',
		'US1840023506' => 'Elim',
		'US1840023677' => 'Klukwan',
		'US1840075079' => 'Knik River',
		'US1840023650' => 'Bear Creek',
		'US1840023655' => 'Lake Louise',
		'US1840023359' => 'Lower Kalskag',
		'US1840023668' => 'Covenant Life',
		'US1840023454' => 'McGrath',
		'US1840023498' => 'Shishmaref',
		'US1840023474' => 'Delta Junction',
		'US1840023463' => 'Fairbanks',
		'US1840023666' => 'Big Lake',
		'US1840023441' => 'Venetie',
		'US1840023502' => 'Wales',
		'US1840023398' => 'Paxson',
		'US1840023448' => 'Grayling',
		'US1840023333' => 'Kasigluk',
		'US1840023649' => 'Aleneva',
		'US1840023361' => 'Napakiak',
		'US1840023660' => 'Portage Creek',
		'US1840023500' => 'Teller',
		'US1840023403' => 'Nabesna',
		'US1840023517' => 'Thorne Bay',
		'US1840023339' => 'Akiachak',
		'US1840023515' => 'Hollis',
		'US1840023392' => 'Chisana',
		'US1840023439' => 'Stevens Village',
		'US1840023642' => 'Kupreanof',
		'US1840075086' => 'Alcan Border',
		'US1840023347' => 'Stony River',
		'US1840023513' => 'Metlakatla',
		'US1840023691' => 'Chignik Lake',
		'US1840023447' => 'Galena',
		'US1840023358' => 'Kwethluk',
		'US1840023608' => 'Sunrise',
		'US1840023390' => 'McCarthy',
		'US1840023396' => 'Valdez',
		'US1840023371' => 'Wasilla',
		'US1840023476' => 'Wainwright',
		'US1840023475' => 'Eagle',
		'US1840023282' => 'New Stuyahok',
		'US1840023271' => 'Saxman',
		'US1840023467' => 'Eagle Village',
		'US1840023501' => 'Unalakleet',
		'US1840023346' => 'Sleetmute',
		'US1840023397' => 'Whittier',
		'US1840023488' => 'Ambler',
		'US1840075076' => 'Four Mile Road',
		'US1840023478' => 'Prudhoe Bay',
		'US1840023330' => 'Russian Mission',
		'US1840023259' => 'Nikolski',
		'US1840023315' => 'Pelican',
		'US1840023446' => 'Fort Yukon',
		'US1840023313' => 'Gustavus',
		'US1840023673' => 'Game Creek',
		'US1840023275' => 'Koliganek',
		'US1840075196' => 'Goldstream',
		'US1840075081' => 'Kodiak Station',
		'US1840023684' => 'Northway Junction',
		'US1840023492' => 'Kivalina',
		'US1840023510' => 'Nome',
		'US1840023340' => 'Atmautluak',
		'US1840023671' => 'Fox River',
		'US1840023473' => 'Tok',
		'US1840023428' => 'Manley Hot Springs',
		'US1840023644' => 'Whale Pass',
		'US1840023546' => 'Evansville',
		'US1840023285' => 'Ivanof Bay',
		'US1840023290' => 'Perryville',
		'US1840023317' => 'Haines',
		'US1840023270' => 'Ketchikan',
		'US1840023295' => 'Newhalen',
		'US1840037568' => 'Eielson AFB',
		'US1840023281' => 'Manokotak',
		'US1840023482' => 'Kaktovik',
		'US1840023578' => 'Port Clarence',
		'US1840023280' => 'Ekwok',
		'US1840023462' => 'College',
		'US1840075218' => 'Whitestone',
		'US1840023456' => 'Nikolai',
		'US1840023453' => 'Koyukuk',
		'US1840023470' => 'Northway',
		'US1840023520' => 'Craig',
		'US1840023303' => 'Old Harbor',
		'US1840075078' => 'Harding-Birch Lakes',
		'US1840023360' => 'Mekoryuk',
		'US1840023306' => 'Juneau',
		'US1840023277' => 'Aleknagik',
		'US1840023487' => 'Red Dog Mine',
		'US1840023328' => 'Nunam Iqua',
		'US1840023357' => 'Goodnews Bay',
		'US1840023337' => 'Lime Village',
		'US1840023645' => 'Halibut Cove',
		'US1840023394' => 'Chitina',
		'US1840023429' => 'Minto',
		'US1840023672' => 'Fritz Creek',
		'US1840023434' => 'Chalkyitsik',
		'US1840023321' => 'Alakanuk',
		'US1840023373' => 'Skwentna',
		'US1840023616' => 'Twin Hills',
		'US1840075084' => 'Lakes',
		'US1840023260' => 'Unalaska',
		'US1840023380' => 'Eureka Roadhouse',
		'US1840023518' => 'Point Baker',
		'US1840023291' => 'Port Alsworth',
		'US1840023469' => 'Chicken',
		'US1840023299' => 'Karluk',
		'US1840023444' => 'Anvik',
		'US1840023435' => 'Circle',
		'US1840023430' => 'Alatna',
		'US1840023405' => 'Hope',
		'US1840023307' => 'Kake',
		'US1840023678' => 'Lazy Mountain',
		'US1840023410' => 'Anchor Point',
		'US1840023401' => 'Tonsina',
		'US1840023651' => 'Diamond Ridge',
		'US1840075105' => 'Silver Springs',
		'US1840023402' => 'Cordova',
		'US1840023667' => 'Chiniak',
		'US1840023688' => 'Whitestone Logging Camp',
		'US1840023505' => 'Diomede',
		'US1840037687' => 'Salcha',
		'US1840023555' => 'Kokhanok',
		'US1840023283' => 'Igiugig',
		'US1840037586' => 'Fort Greely',
		'US1840023407' => 'Kasilof',
		'US1840023409' => 'Ninilchik',
		'US1840023400' => 'Tatitlek',
		'US1840023265' => 'Akutan',
		'US1840023638' => 'Port Alexander',
		'US1840025214' => 'Loring',
		'US1840023656' => 'Lowell Point',
		'US1840023351' => 'Akiak',
		'US1840023685' => 'Pleasant Valley',
		'US1840023690' => 'Badger',
		'US1840023424' => 'Yakutat',
		'US1840023689' => 'Womens Bay',
		'US1840023304' => 'Ouzinkie',
		'US1840023530' => 'Birch Creek',
		'US1840023368' => 'Butte',
		'US1840023445' => 'Bettles',
		'US1840023377' => 'Willow',
		'US1840023415' => 'Soldotna',
		'US1840023332' => 'Scammon Bay',
		'US1840023263' => 'St. George',
		'US1840023406' => 'Kalifornsky',
		'US1840023391' => 'Mentasta Lake',
		'US1840023381' => 'Healy',
		'US1840023494' => 'Kotzebue',
		'US1840037578' => 'Fishhook',
		'US1840000307' => 'Platinum',
		'US1840023413' => 'Cohoe',
		'US1840023320' => 'Pitkas Point',
		'US1840023499' => 'Stebbins',
		'US1840075216' => 'Steele Creek',
		'US1840023556' => 'Upper Kalskag',
		'US1840023458' => 'Ruby',
		'US1840023419' => 'Homer',
		'US1840023300' => 'Akhiok',
		'US1840023450' => 'Hughes',
		'US1840023294' => 'Egegik',
		'US1840000464' => 'Cold Bay',
		'US1840023363' => 'Nightmute',
		'US1840023354' => 'Chefornak',
		'US1840023296' => 'Nondalton',
		'US1840023432' => 'Beaver',
		'US1840023486' => 'Noatak',
		'US1840023369' => 'Chase',
		'US1840023334' => 'Kipnuk',
		'US1840023652' => 'Dot Lake Village',
		'US1840023537' => 'Clarks Point',
		'US1840023460' => 'Ester',
		'US1840023412' => 'Clam Gulch',
		'US1840023468' => 'Big Delta',
		'US1840023417' => 'Sterling',
		'US1840023524' => 'Hyder',
		'US1840023490' => 'Deering',
		'US1840023657' => 'Mud Bay',
		'US1840023687' => 'Ridgeway',
		'US1840023342' => 'Toksook Bay',
		'US1840023653' => 'Funny River',
		'US1840137228' => 'Chenega',
		'US1840023350' => 'Tununak',
		'US1840023493' => 'Kobuk',
		'US1840023338' => 'Newtok',
		'US1840023680' => 'Lutak',
		'US1840037676' => 'Pope-Vannoy Landing',
		'US1840023483' => 'Nuiqsut',
		'US1840023457' => 'Nulato',
		'US1840000514' => 'Edna Bay',
		'US1840023442' => 'Wiseman',
		'US1840023455' => 'Nenana',
		'US1840023302' => 'Larsen Bay',
		'US1840023274' => 'South Naknek',
		'US1840023349' => 'Tuntutuliak',
		'US1840023314' => 'Hoonah',
		'US1840023418' => 'Tyonek',
		'US1840023322' => 'Chevak',
		'US1840023663' => 'Tolsona',
		'US1840023356' => 'Eek',
		'US1840023323' => 'Emmonak',
		'US1840023335' => 'Kongiganak',
		'US1840023422' => 'Seldovia',
		'US1840075206' => 'South Van Horn',
		'US1840023449' => 'Holy Cross',
		'US1840023662' => 'Tanaina',
		'US1840023404' => 'Happy Valley',
		'US1840023289' => 'Pedro Bay',
		'US1840023461' => 'Fox',
		'US1840023489' => 'Buckland',
		'US1840023654' => 'Gateway',
		'US1840023617' => 'Crown Point',
		'US1840023480' => 'Atqasuk',
		'US1840023379' => 'Palmer',
		'US1840023597' => 'Willow Creek',
		'US1840137265' => 'Primrose',
		'US1840023433' => 'Central',
		'US1840023276' => 'Togiak',
		'US1840023472' => 'Tetlin',
		'US1840023385' => 'Anchorage',
		'US1840023279' => 'Dillingham',
		'US1840023293' => 'Chignik',
		'US1840023326' => 'Marshall',
		'US1840023389' => 'Kenny Lake',
		'US1840023511' => 'St. Michael',
		'US1840023431' => 'Arctic Village',
		'US1840023372' => 'Petersville',
		'US1840023292' => 'Ugashik',
		'US1840023525' => 'Two Rivers',
		'US1840023345' => 'Red Devil',
		'US1840023485' => 'Shungnak',
		'US1840023384' => 'Anderson',
		'US1840023355' => 'Chuathbaluk',
		'US1840023661' => 'Seldovia Village',
		'US1840023496' => 'Selawik',
		'US1840023440' => 'Takotna',
		'US1840037663' => 'Attu Station',
		'US1840023386' => 'Gakona',
		'US1840023395' => 'Copper Center',
		'US1840023569' => 'Moose Creek',
		'US1840023523' => 'Klawock',
		'US1840023416' => 'Port Graham',
		'US1840023273' => 'Naknek',
		'US1840075179' => 'Chena Ridge',
		'US1840023658' => 'Nelchina',
		'US1840023477' => 'Point Lay',
		'US1840023425' => 'Flat',
		'US1840023309' => 'Elfin Cove',
		'US1840023287' => 'Levelock',
		'US1840023670' => 'Dry Creek',
		'US1840075101' => 'Buffalo Soapstone',
		'US1840000498' => 'Port Heiden',
		'US1840023443' => 'Allakaket',
		'US1840023310' => 'Tenakee Springs',
		'US1840075077' => 'Glacier View',
		'US1840023366' => 'Quinhagak',
		'US1840023383' => 'Cantwell',
		'US1840023370' => 'Chickaloon',
		'US1840023316' => 'Excursion Inlet',
		'US1840023451' => 'Huslia',
		'US1840023693' => 'Healy Lake',
		'US1840075119' => 'St. Marys',
		'US1840000190' => 'Pilot Point',
		'US1840023599' => 'Nanwalek',
		'US1840023312' => 'Angoon',
		'US1840023399' => 'Slana',
		'US1840023421' => 'Kenai',
		'US1840023497' => 'Shaktoolik',
		'US1840023509' => 'Koyuk',
		'US1840023341' => 'Crooked Creek',
		'US1840023311' => 'Skagway',
		'US1840023261' => 'Adak',
	],
	'NC' => [
		'US1840016445' => 'Trenton',
		'US1840016365' => 'Stanfield',
		'US1840015421' => 'Sanford',
		'US1840017704' => 'Cofield',
		'US1840015361' => 'Thomasville',
		'US1840015398' => 'Aurora',
		'US1840016333' => 'Casar',
		'US1840015328' => 'Mebane',
		'US1840016357' => 'Vass',
		'US1840001769' => 'Forest Hills',
		'US1840015498' => 'Cape Carteret',
		'US1840025761' => 'Lowgap',
		'US1840016469' => 'Greenevers',
		'US1840016326' => 'Lillington',
		'US1840013363' => 'Gorman',
		'US1840016149' => 'Colerain',
		'US1840016252' => 'Liberty',
		'US1840015345' => 'Bakersville',
		'US1840016366' => 'New London',
		'US1840014479' => 'High Point',
		'US1840016354' => 'Pineville',
		'US1840033009' => 'Grandfather',
		'US1840022708' => 'Midway',
		'US1840017829' => 'Snow Hill',
		'US1840015423' => 'Angier',
		'US1840016266' => 'East Spencer',
		'US1840024909' => 'Advance',
		'US1840016118' => 'Franklinton',
		'US1840016367' => 'Norwood',
		'US1840016277' => 'Grifton',
		'US1840016336' => 'Grover',
		'US1840016492' => 'Nags Head',
		'US1840013436' => 'Lowesville',
		'US1840016195' => 'Morrisville',
		'US1840013558' => 'Piney Green',
		'US1840016687' => 'Navassa',
		'US1840016275' => 'Farmville',
		'US1840014560' => 'Kannapolis',
		'US1840025766' => 'South Mills',
		'US1840013632' => 'Myrtle Grove',
		'US1840017883' => 'Rose Hill',
		'US1840015321' => 'Bunn',
		'US1840025836' => 'Davis',
		'US1840013559' => 'Pumpkin Center',
		'US1840015392' => 'Black Mountain',
		'US1840016194' => 'Knightdale',
		'US1840024951' => 'Denver',
		'US1840014617' => 'Rockingham',
		'US1840017901' => 'Richlands',
		'US1840017905' => 'Proctorville',
		'US1840014559' => 'Concord',
		'US1840016052' => 'Stovall',
		'US1840016538' => 'Fairmont',
		'US1840016313' => 'Hookerton',
		'US1840025784' => 'Manns Harbor',
		'US1840016689' => 'Ocean Isle Beach',
		'US1840016394' => 'McAdenville',
		'US1840033014' => 'Barker Ten Mile',
		'US1840013357' => 'Glen Raven',
		'US1840016230' => 'Hildebran',
		'US1840016029' => 'West Jefferson',
		'US1840025822' => 'Glenville',
		'US1840016500' => 'East Laurinburg',
		'US1840017756' => 'Cedar Rock',
		'US1840016174' => 'Leggett',
		'US1840016502' => 'Wagram',
		'US1840025778' => 'Efland',
		'US1840016279' => 'Winterville',
		'US1840013337' => 'Hays',
		'US1840017793' => 'Princeton',
		'US1840017781' => 'Seagrove',
		'US1840016441' => 'Godwin',
		'US1840016353' => 'Davidson',
		'US1840013315' => 'Elizabeth City',
		'US1840025858' => 'Hallsboro',
		'US1840016281' => 'Maiden',
		'US1840016395' => 'Cramerton',
		'US1840016400' => 'Dover',
		'US1840024956' => 'Hoopers Creek',
		'US1840024957' => 'Horse Shoe',
		'US1840013407' => 'Greenville',
		'US1840014561' => 'Hendersonville',
		'US1840017738' => 'Roxobel',
		'US1840016446' => 'Pollocksville',
		'US1840017926' => 'St. Helena',
		'US1840032901' => 'Silver Lake',
		'US1840014551' => 'Polkville',
		'US1840016217' => 'Troutman',
		'US1840016334' => 'Earl',
		'US1840015360' => 'Lexington',
		'US1840016338' => 'Patterson Springs',
		'US1840016165' => 'Dortches',
		'US1840016349' => 'Huntersville',
		'US1840024991' => 'Old Hundred',
		'US1840015353' => 'Burnsville',
		'US1840013370' => 'Wanchese',
		'US1840016475' => 'Ellerbe',
		'US1840017857' => 'Flat Rock',
		'US1840015567' => 'Boardman',
		'US1840013489' => 'Vander',
		'US1840033013' => 'Prospect',
		'US1840017736' => 'Alamance',
		'US1840013432' => 'Goldsboro',
		'US1840016438' => 'Hope Mills',
		'US1840016369' => 'Laurel Park',
		'US1840017778' => 'Roper',
		'US1840025767' => 'Ruffin',
		'US1840016397' => 'Dellview',
		'US1840016532' => 'Swansboro',
		'US1840015400' => 'Belhaven',
		'US1840013435' => 'Westport',
		'US1840013505' => 'Bowmore',
		'US1840016188' => 'Gamewell',
		'US1840016141' => 'Oak Ridge',
		'US1840016030' => 'Dobson',
		'US1840016359' => 'Mount Gilead',
		'US1840015424' => 'Belwood',
		'US1840016216' => 'Harmony',
		'US1840025824' => 'Gerton',
		'US1840016453' => 'Indian Trail',
		'US1840013556' => 'Half Moon',
		'US1840014434' => 'Creedmoor',
		'US1840016295' => 'Maggie Valley',
		'US1840025794' => 'Moncure',
		'US1840024898' => 'Germanton',
		'US1840017787' => 'Spencer',
		'US1840043448' => 'Fontana Dam',
		'US1840014523' => 'Newton',
		'US1840017864' => 'Ranlo',
		'US1840016440' => 'Falcon',
		'US1840017759' => 'Rolesville',
		'US1840017852' => 'Pinehurst',
		'US1840016223' => 'Denton',
		'US1840016253' => 'Franklinville',
		'US1840134907' => 'Woodlawn',
		'US1840016688' => 'Oak Island',
		'US1840016565' => 'Tar Heel',
		'US1840016302' => 'Chocowinity',
		'US1840016685' => 'Sunset Beach',
		'US1840016166' => 'Whitakers',
		'US1840013431' => 'Brogden',
		'US1840016209' => 'Hot Springs',
		'US1840015277' => 'Ahoskie',
		'US1840016404' => 'Columbus',
		'US1840024931' => 'Stokes',
		'US1840016484' => 'Emerald Isle',
		'US1840016189' => 'Granite Falls',
		'US1840015399' => 'Bath',
		'US1840016450' => 'Wadesboro',
		'US1840016682' => 'Holden Beach',
		'US1840015384' => 'Salisbury',
		'US1840024902' => 'Valle Crucis',
		'US1840014590' => 'Mount Holly',
		'US1840016424' => 'Grantsboro',
		'US1840016676' => 'Kure Beach',
		'US1840015579' => 'Bolivia',
		'US1840016358' => 'Pinebluff',
		'US1840016034' => 'Danbury',
		'US1840016422' => 'Mesic',
		'US1840016297' => 'Waynesville',
		'US1840016242' => 'Plymouth',
		'US1840015413' => 'Bryson City',
		'US1840017777' => 'Rutherford College',
		'US1840016056' => 'Wentworth',
		'US1840015485' => 'Beulaville',
		'US1840016442' => 'Stedman',
		'US1840016143' => 'Elon',
		'US1840015548' => 'Burgaw',
		'US1840016274' => 'Falkland',
		'US1840025857' => 'Evergreen',
		'US1840016432' => 'Garland',
		'US1840014558' => 'Robbins',
		'US1840013388' => 'Welcome',
		'US1840016114' => 'Elk Park',
		'US1840016474' => 'Dobbins Heights',
		'US1840016486' => 'Peletier',
		'US1840016454' => 'Marshville',
		'US1840016110' => 'Jonesville',
		'US1840016487' => 'Pine Knoll Shores',
		'US1840015422' => 'Bostic',
		'US1840015372' => 'Marion',
		'US1840013362' => 'Burlington',
		'US1840016224' => 'Wallburg',
		'US1840014433' => 'Henderson',
		'US1840016232' => 'Drexel',
		'US1840013447' => 'Valley Hill',
		'US1840025818' => 'Henrietta',
		'US1840017862' => 'Rosman',
		'US1840033010' => 'Cajahs Mountain',
		'US1840017907' => 'Red Springs',
		'US1840013071' => 'Elroy',
		'US1840015311' => 'Hertford',
		'US1840016258' => 'Goldston',
		'US1840017906' => 'Raynham',
		'US1840013308' => 'South Henderson',
		'US1840015539' => 'Bladenboro',
		'US1840016470' => 'Teachey',
		'US1840015393' => 'Benson',
		'US1840016283' => 'Montreat',
		'US1840016561' => 'Clarkton',
		'US1840016562' => 'Dublin',
		'US1840016421' => 'Franklin',
		'US1840013470' => 'Bessemer City',
		'US1840016449' => 'Morven',
		'US1840016231' => 'Connelly Springs',
		'US1840016175' => 'Macclesfield',
		'US1840013364' => 'Durham',
		'US1840013445' => 'Balfour',
		'US1840025810' => 'Fairfield',
		'US1840016452' => 'Polkton',
		'US1840016282' => 'Catawba',
		'US1840024997' => 'Wakulla',
		'US1840016262' => 'Stantonsburg',
		'US1840016178' => 'Pinetops',
		'US1840016043' => 'Gaston',
		'US1840017952' => 'Sandy Creek',
		'US1840014493' => 'Lenoir',
		'US1840013480' => 'Ingold',
		'US1840014504' => 'Morganton',
		'US1840015427' => 'Lincolnton',
		'US1840015389' => 'Bethel',
		'US1840016176' => 'Conetoe',
		'US1840016346' => 'Dillsboro',
		'US1840017754' => 'Rhodhiss',
		'US1840013074' => 'Etowah',
		'US1840016352' => 'Cornelius',
		'US1840017720' => 'Ronda',
		'US1840015355' => 'Apex',
		'US1840042919' => 'Jackson Heights',
		'US1840016211' => 'Marshall',
		'US1840016320' => 'Forest City',
		'US1840013629' => 'Sea Breeze',
		'US1840013507' => 'Rockfish',
		'US1840016204' => 'Hamilton',
		'US1840016032' => 'Pilot Mountain',
		'US1840014524' => 'Hickory',
		'US1840016233' => 'Glen Alpine',
		'US1840015578' => 'Belville',
		'US1840017851' => 'Foxfire',
		'US1840016304' => 'Pantego',
		'US1840016196' => 'Cary',
		'US1840013448' => 'Mountain Home',
		'US1840014497' => 'Raleigh',
		'US1840016036' => 'Macon',
		'US1840016210' => 'Mars Hill',
		'US1840033020' => 'Neuse Forest',
		'US1840013484' => 'Vann Crossroads',
		'US1840017727' => 'Rural Hall',
		'US1840017950' => 'Sandyfield',
		'US1840016605' => 'Watha',
		'US1840017739' => 'Southern Shores',
		'US1840015391' => 'Biltmore Forest',
		'US1840016198' => 'Garner',
		'US1840016661' => 'Lake Waccamaw',
		'US1840032999' => 'Skippers Corner',
		'US1840016057' => 'Milton',
		'US1840016327' => 'Coats',
		'US1840016150' => 'Windsor',
		'US1840016472' => 'Warsaw',
		'US1840015333' => 'Aulander',
		'US1840016370' => 'Mills River',
		'US1840015395' => 'Canton',
		'US1840013400' => 'Asheboro',
		'US1840016027' => 'Jefferson',
		'US1840015344' => 'Bailey',
		'US1840016566' => 'White Lake',
		'US1840013406' => 'Fearrington Village',
		'US1840016476' => 'Norman',
		'US1840017910' => 'St. Pauls',
		'US1840015358' => 'Statesville',
		'US1840016053' => 'Madison',
		'US1840025779' => 'Rougemont',
		'US1840016319' => 'Ellenboro',
		'US1840016147' => 'Kelford',
		'US1840016361' => 'Troy',
		'US1840013481' => 'Ivanhoe',
		'US1840017858' => 'Robbinsville',
		'US1840016263' => 'Landis',
		'US1840025793' => 'Gulf',
		'US1840013079' => 'Dundarrach',
		'US1840016028' => 'Lansing',
		'US1840016115' => 'Newland',
		'US1840013409' => 'Bent Creek',
		'US1840025785' => 'Rodanthe',
		'US1840016207' => 'Oak City',
		'US1840016045' => 'Murfreesboro',
		'US1840016456' => 'Fairview',
		'US1840025765' => 'Pinnacle',
		'US1840016483' => 'Cedar Point',
		'US1840016058' => 'Yanceyville',
		'US1840016398' => 'Stanley',
		'US1840016259' => 'Pittsboro',
		'US1840017880' => 'Marvin',
		'US1840016290' => 'Clayton',
		'US1840016347' => 'Sylva',
		'US1840016535' => 'Marietta',
		'US1840016046' => 'Como',
		'US1840016112' => 'Yadkinville',
		'US1840032909' => 'Cove Creek',
		'US1840016402' => 'Vanceboro',
		'US1840016260' => 'Lucama',
		'US1840024929' => 'Bell Arthur',
		'US1840016434' => 'Turkey',
		'US1840017784' => 'Saratoga',
		'US1840013561' => 'Raemon',
		'US1840016100' => 'Winfall',
		'US1840013504' => 'Ashley Heights',
		'US1840014437' => 'Roanoke Rapids',
		'US1840013433' => 'Buies Creek',
		'US1840017745' => 'Red Oak',
		'US1840016117' => 'Centerville',
		'US1840016234' => 'Valdese',
		'US1840016356' => 'Taylortown',
		'US1840033023' => 'St. Stephens',
		'US1840013361' => 'Graham',
		'US1840016044' => 'Woodland',
		'US1840016482' => 'Morehead City',
		'US1840016124' => 'Lewisville',
		'US1840016324' => 'Pikeville',
		'US1840040276' => 'Blue Clay Farms',
		'US1840017865' => 'Spencer Mountain',
		'US1840016293' => 'Pine Level',
		'US1840016537' => 'McDonald',
		'US1840033019' => 'Mountain View',
		'US1840032987' => 'Swan Quarter',
		'US1840015486' => 'Calypso',
		'US1840017955' => 'Bald Head Island',
		'US1840017794' => 'Selma',
		'US1840016061' => 'Hobgood',
		'US1840015469' => 'Arapahoe',
		'US1840017837' => 'Walnut Creek',
		'US1840015334' => 'Carrboro',
		'US1840016049' => 'Kittrell',
		'US1840017856' => 'Misenheimer',
		'US1840016405' => 'Tryon',
		'US1840022665' => 'Butner',
		'US1840014430' => 'Mount Airy',
		'US1840015309' => 'Blowing Rock',
		'US1840025789' => 'Southmont',
		'US1840016485' => 'Newport',
		'US1840015576' => 'Wilmington',
		'US1840016244' => 'Old Fort',
		'US1840015459' => 'Saluda',
		'US1840017747' => 'Spring Hope',
		'US1840016684' => 'Caswell Beach',
		'US1840024949' => 'Bunnlevel',
		'US1840024950' => 'Mamers',
		'US1840024952' => 'Millingport',
		'US1840073862' => 'Lake Norman of Catawba',
		'US1840016443' => 'Wade',
		'US1840016093' => 'Wilkesboro',
		'US1840016455' => 'Mineral Springs',
		'US1840016163' => 'Momeyer',
		'US1840016214' => 'Love Valley',
		'US1840016138' => 'Stokesdale',
		'US1840013633' => 'Ogden',
		'US1840016125' => 'Walkertown',
		'US1840013392' => 'Salem',
		'US1840015308' => 'Beech Mountain',
		'US1840016162' => 'Middlesex',
		'US1840016202' => 'Jamesville',
		'US1840016050' => 'Middleburg',
		'US1840015310' => 'Boone',
		'US1840015568' => 'Bolton',
		'US1840025783' => 'Hatteras',
		'US1840015434' => 'Cameron',
		'US1840017850' => 'Southern Pines',
		'US1840016151' => 'Hillsborough',
		'US1840013072' => 'Cullowhee',
		'US1840016276' => 'Fountain',
		'US1840017729' => 'Tobaccoville',
		'US1840016144' => 'Green Level',
		'US1840015495' => 'Atlantic Beach',
		'US1840017795' => 'Smithfield',
		'US1840014432' => 'Roxboro',
		'US1840025819' => 'Iron Station',
		'US1840016348' => 'Webster',
		'US1840016037' => 'Warrenton',
		'US1840016390' => 'Pink Hill',
		'US1840016433' => 'Harrells',
		'US1840033012' => 'JAARS',
		'US1840014585' => 'Kinston',
		'US1840017881' => 'Wesley Chapel',
		'US1840016467' => 'Magnolia',
		'US1840013444' => 'Albemarle',
		'US1840016065' => 'Weldon',
		'US1840016197' => 'Fuquay-Varina',
		'US1840033011' => 'Brices Creek',
		'US1840015425' => 'Boiling Springs',
		'US1840016318' => 'Lake Lure',
		'US1840016536' => 'Maxton',
		'US1840016177' => 'Tarboro',
		'US1840017735' => 'Sedalia',
		'US1840015575' => 'Carolina Beach',
		'US1840015569' => 'Brunswick',
		'US1840016439' => 'Linden',
		'US1840016473' => 'Hoffman',
		'US1840013411' => 'Asheville',
		'US1840013628' => 'Castle Hayne',
		'US1840033017' => 'Light Oak',
		'US1840017954' => 'St. James',
		'US1840016206' => 'Williamston',
		'US1840013309' => 'Eden',
		'US1840016278' => 'Grimesland',
		'US1840025832' => 'Marble',
		'US1840016468' => 'Faison',
		'US1840015323' => 'Bethania',
		'US1840016199' => 'Wake Forest',
		'US1840016423' => 'Minnesott Beach',
		'US1840013410' => 'Swannanoa',
		'US1840016119' => 'Youngsville',
		'US1840022794' => 'Eastover',
		'US1840026933' => 'Waves',
		'US1840017834' => 'Rutherfordton',
		'US1840014592' => 'Havelock',
		'US1840024901' => 'Foscoe',
		'US1840017874' => 'Salemburg',
		'US1840016481' => 'Indian Beach',
		'US1840013338' => 'Millers Creek',
		'US1840015420' => 'Broadway',
		'US1840017752' => 'Princeville',
		'US1840013073' => 'East Flat Rock',
		'US1840015454' => 'Lowell',
		'US1840017751' => 'Spruce Pine',
		'US1840016368' => 'Oakboro',
		'US1840014435' => 'Oxford',
		'US1840013065' => 'Fairplains',
		'US1840017755' => 'Sawmills',
		'US1840016289' => 'Micro',
		'US1840013627' => 'Hightsville',
		'US1840016035' => 'Walnut Cove',
		'US1840016201' => 'Zebulon',
		'US1840024955' => 'Fruitland',
		'US1840017780' => 'Ramseur',
		'US1840013434' => 'Dunn',
		'US1840016331' => 'Lawndale',
		'US1840016167' => 'Nashville',
		'US1840016350' => 'Matthews',
		'US1840015433' => 'Aberdeen',
		'US1840016284' => 'Weaverville',
		'US1840016363' => 'Mount Pleasant',
		'US1840016111' => 'East Bend',
		'US1840013076' => 'Fairfield Harbour',
		'US1840016048' => 'Winton',
		'US1840025792' => 'Bennett',
		'US1840017701' => 'Rich Square',
		'US1840014431' => 'King',
		'US1840033022' => 'River Road',
		'US1840016435' => 'Newton Grove',
		'US1840024953' => 'Dana',
		'US1840013397' => 'West Marion',
		'US1840016322' => 'Eureka',
		'US1840015383' => 'Wilson',
		'US1840017953' => 'Shallotte',
		'US1840025816' => 'Caroleen',
		'US1840032896' => 'Wilsons Mills',
		'US1840013310' => 'South Weldon',
		'US1840016291' => 'Four Oaks',
		'US1840017728' => 'Clemmons',
		'US1840016116' => 'Louisburg',
		'US1840013085' => 'Elrod',
		'US1840016540' => 'Parkton',
		'US1840016155' => 'Kitty Hawk',
		'US1840016448' => 'McFarlan',
		'US1840016038' => 'Norlina',
		'US1840013382' => 'Bethlehem',
		'US1840015491' => 'Hayesville',
		'US1840013506' => 'Silver City',
		'US1840016426' => 'Vandemere',
		'US1840025837' => 'Gloucester',
		'US1840016205' => 'Hassell',
		'US1840015436' => 'Candor',
		'US1840017853' => 'Whispering Pines',
		'US1840033021' => 'Northlakes',
		'US1840015456' => 'Bridgeton',
		'US1840014557' => 'Charlotte',
		'US1840016665' => 'Tabor City',
		'US1840016094' => 'North Wilkesboro',
		'US1840013359' => 'Saxapahaw',
		'US1840025856' => 'Delco',
		'US1840025763' => 'Coinjock',
		'US1840025833' => 'Potters Hill',
		'US1840024990' => 'Laurel Hill',
		'US1840015581' => 'Carolina Shores',
		'US1840013391' => 'Icard',
		'US1840016683' => 'Leland',
		'US1840015570' => 'Whiteville',
		'US1840016213' => 'Cooleemee',
		'US1840013469' => 'Belmont',
		'US1840014613' => 'Monroe',
		'US1840015455' => 'High Shoals',
		'US1840016686' => 'Varnamtown',
		'US1840017760' => 'Robersonville',
		'US1840017833' => 'Ruth',
		'US1840016241' => 'Creswell',
		'US1840033024' => 'South Rosemary',
		'US1840015582' => 'Southport',
		'US1840015426' => 'Shelby',
		'US1840026949' => 'Cherokee',
		'US1840024930' => 'Belvoir',
		'US1840017785' => 'Sims',
		'US1840025786' => 'Salvo',
		'US1840015438' => 'Badin',
		'US1840040280' => 'Lake Royale',
		'US1840033007' => 'Long View',
		'US1840016564' => 'Elizabethtown',
		'US1840017700' => 'Sparta',
		'US1840016323' => 'Fremont',
		'US1840013486' => 'Plain View',
		'US1840014653' => 'Jacksonville',
		'US1840017878' => 'Stallings',
		'US1840013523' => 'Harkers Island',
		'US1840025835' => 'Broad Creek',
		'US1840016158' => 'Duck',
		'US1840016148' => 'Lewiston Woodville',
		'US1840025817' => 'Cliffside',
		'US1840014552' => 'Kings Mountain',
		'US1840015474' => 'Andrews',
		'US1840016051' => 'Stem',
		'US1840016267' => 'Faith',
		'US1840016425' => 'Stonewall',
		'US1840014605' => 'Clinton',
		'US1840016335' => 'Fallston',
		'US1840013446' => 'Barker Heights',
		'US1840017875' => 'Spring Lake',
		'US1840001770' => 'Lake Santeetlah',
		'US1840016389' => 'La Grange',
		'US1840016220' => 'Taylorsville',
		'US1840014522' => 'Conover',
		'US1840013567' => 'Butters',
		'US1840016437' => 'Murphy',
		'US1840025809' => 'Engelhard',
		'US1840025831' => 'Hobucken',
		'US1840013340' => 'Mulberry',
		'US1840015496' => 'Beaufort',
		'US1840025838' => 'Marshallberg',
		'US1840032902' => 'Kings Grant',
		'US1840017909' => 'Rowland',
		'US1840016212' => 'Mocksville',
		'US1840016265' => 'Cleveland',
		'US1840016208' => 'Parmele',
		'US1840015319' => 'Boonville',
		'US1840016371' => 'Fletcher',
		'US1840016156' => 'Manteo',
		'US1840016457' => 'Unionville',
		'US1840013568' => 'White Oak',
		'US1840013490' => 'Fayetteville',
		'US1840016662' => 'Cerro Gordo',
		'US1840016534' => 'Lumber Bridge',
		'US1840017782' => 'Staley',
		'US1840033018' => 'Mar-Mac',
		'US1840016103' => 'Edenton',
		'US1840017835' => 'Spindale',
		'US1840014436' => 'Reidsville',
		'US1840015473' => 'Autryville',
		'US1840016033' => 'Gatesville',
		'US1840025782' => 'Frisco',
		'US1840016164' => 'Castalia',
		'US1840015435' => 'Biscoe',
		'US1840033015' => 'Bayshore',
		'US1840024981' => 'Cordova',
		'US1840013306' => 'Toast',
		'US1840017866' => 'River Bend',
		'US1840016401' => 'Trent Woods',
		'US1840013307' => 'White Plains',
		'US1840016444' => 'Maysville',
		'US1840015470' => 'Bayboro',
		'US1840016329' => 'Kingstown',
		'US1840016187' => 'Hudson',
		'US1840016113' => 'Crossnore',
		'US1840016604' => 'Topsail Beach',
		'US1840013415' => 'West Canton',
		'US1840016603' => 'Surf City',
		'US1840025764' => 'Moyock',
		'US1840016332' => 'Mooresboro',
		'US1840016152' => 'Chapel Hill',
		'US1840013482' => 'Bonnetsville',
		'US1840016328' => 'Erwin',
		'US1840017879' => 'Lake Park',
		'US1840013630' => 'Wrightsboro',
		'US1840017854' => 'Red Cross',
		'US1840016460' => 'Wingate',
		'US1840016303' => 'Washington Park',
		'US1840015356' => 'Bear Grass',
		'US1840013467' => 'Brevard',
		'US1840013383' => 'Stony Point',
		'US1840025807' => 'Pinetown',
		'US1840015467' => 'Highlands',
		'US1840017783' => 'Siler City',
		'US1840016458' => 'Waxhaw',
		'US1840025848' => 'Rocky Point',
		'US1840016531' => 'Holly Ridge',
		'US1840013081' => 'East Rockingham',
		'US1840025859' => 'Riegelwood',
		'US1840015479' => 'Ansonville',
		'US1840015332' => 'Askewville',
		'US1840017726' => 'Sugar Mountain',
		'US1840016364' => 'Harrisburg',
		'US1840016663' => 'Chadbourn',
		'US1840015480' => 'Hemby Bridge',
		'US1840016677' => 'Wrightsville Beach',
		'US1840013562' => 'Rex',
		'US1840016427' => 'Oriental',
		'US1840016136' => 'Jamestown',
		'US1840015324' => 'Winston-Salem',
		'US1840017725' => 'Seven Devils',
		'US1840013635' => 'Boiling Spring Lakes',
		'US1840016137' => 'Gibsonville',
		'US1840025769' => 'Hollister',
		'US1840016451' => 'Peachland',
		'US1840016268' => 'Granite Quarry',
		'US1840017786' => 'Rockwell',
		'US1840016200' => 'Wendell',
		'US1840013427' => 'Ocracoke',
		'US1840013503' => 'Five Points',
		'US1840025823' => 'Aquadale',
		'US1840013485' => 'Keener',
		'US1840016664' => 'Fair Bluff',
		'US1840013339' => 'Moravian Falls',
		'US1840016396' => 'Dallas',
		'US1840016042' => 'Garysburg',
		'US1840016399' => 'Cove City',
		'US1840013569' => 'Kelly',
		'US1840014521' => 'Claremont',
		'US1840013341' => 'Pleasant Hill',
		'US1840015388' => 'Ayden',
		'US1840016541' => 'Pembroke',
		'US1840033016' => 'Forest Oaks',
		'US1840015437' => 'Locust',
		'US1840016285' => 'Woodfin',
		'US1840016321' => 'Mount Olive',
		'US1840013516' => 'Hamlet',
		'US1840016351' => 'Mint Hill',
		'US1840013416' => 'Lake Junaluska',
		'US1840013408' => 'Avery Creek',
		'US1840016123' => 'Kernersville',
		'US1840016261' => 'Elm City',
		'US1840015329' => 'Haw River',
		'US1840025797' => 'Archer Lodge',
		'US1840016062' => 'Littleton',
		'US1840025780' => 'Avon',
		'US1840013355' => 'McLeansville',
		'US1840040283' => 'Northchase',
		'US1840014589' => 'Cherryville',
		'US1840016501' => 'Gibson',
		'US1840016563' => 'East Arcadia',
		'US1840025834' => 'Atlantic',
		'US1840016330' => 'Lattimore',
		'US1840017703' => 'Severn',
		'US1840013412' => 'Royal Pines',
		'US1840013631' => 'Murraysville',
		'US1840024912' => 'Tyro',
		'US1840017753' => 'Speed',
		'US1840017702' => 'Seaboard',
		'US1840016314' => 'Walstonburg',
		'US1840013399' => 'Archdale',
		'US1840016471' => 'Wallace',
		'US1840016264' => 'China Grove',
		'US1840016040' => 'Lasker',
		'US1840013358' => 'Altamahaw',
		'US1840016031' => 'Elkin',
		'US1840017737' => 'Powellsville',
		'US1840016047' => 'Harrellsville',
		'US1840013442' => 'Cashiers',
		'US1840016362' => 'Midland',
		'US1840014591' => 'New Bern',
		'US1840033006' => 'Chimney Rock Village',
		'US1840015374' => 'Trinity',
		'US1840017855' => 'Richfield',
		'US1840015390' => 'Brookford',
		'US1840016539' => 'Orrum',
		'US1840013443' => 'Seven Lakes',
		'US1840025806' => 'Bayview',
		'US1840024899' => 'Camden',
		'US1840017873' => 'Roseboro',
		'US1840017836' => 'Seven Springs',
		'US1840016054' => 'Mayodan',
		'US1840014706' => 'Northwest',
		'US1840016239' => 'Columbia',
		'US1840025762' => 'Sunbury',
		'US1840015497' => 'Bogue',
		'US1840016288' => 'Kenly',
		'US1840016533' => 'North Topsail Beach',
		'US1840015531' => 'Lumberton',
		'US1840016296' => 'Clyde',
		'US1840025781' => 'Buxton',
		'US1840016063' => 'Enfield',
		'US1840013069' => 'Enochville',
		'US1840043083' => 'Scotch Meadows',
		'US1840016154' => 'Kill Devil Hills',
		'US1840016447' => 'Lilesville',
		'US1840013468' => 'Gastonia',
		'US1840017908' => 'Rennert',
		'US1840013471' => 'James City',
		'US1840015320' => 'Banner Elk',
		'US1840040293' => 'Porters Neck',
		'US1840016064' => 'Halifax',
		'US1840016466' => 'Kenansville',
		'US1840014512' => 'Randleman',
		'US1840015382' => 'Black Creek',
		'US1840025788' => 'Hiddenite',
		'US1840016203' => 'Everetts',
		'US1840014490' => 'Rocky Mount',
		'US1840016145' => 'Swepsonville',
		'US1840025847' => 'Hampstead',
		'US1840016146' => 'Ossipee',
		'US1840013356' => 'Greensboro',
		'US1840043056' => 'Deercroft',
		'US1840015468' => 'Alliance',
		'US1840016041' => 'Conway',
		'US1840015401' => 'Washington',
		'US1840016459' => 'Weddington',
		'US1840016337' => 'Waco',
		'US1840015547' => 'Atkinson',
		'US1840016142' => 'Pleasant Garden',
		'US1840016055' => 'Stoneville',
		'US1840013336' => 'Cricket',
		'US1840014631' => 'Laurinburg',
		'US1840016193' => 'Holly Springs',
		'US1840017746' => 'Sharpsburg',
		'US1840016355' => 'Carthage',
		'US1840013077' => 'Delway',
		'US1840025813' => 'Maury',
		'US1840013557' => 'Sneads Ferry',
		'US1840017705' => 'Scotland Neck',
		'US1840013560' => 'Shannon',
		'US1840016140' => 'Whitsett',
		'US1840016360' => 'Star',
		'US1840014612' => 'Raeford',
		'US1840015357' => 'Bermuda Run',
		'US1840016039' => 'Jackson',
		'US1840015580' => 'Calabash',
		'US1840024954' => 'Edneyville',
		'US1840016215' => 'Mooresville',
		'US1840016139' => 'Summerfield',
		'US1840017788' => 'Simpson',
	],
	'ND' => [
		'US1840000027' => 'Langdon',
		'US1840091411' => 'Devils Lake',
		'US1840001881' => 'Wolford',
		'US1840001884' => 'Churchs Ferry',
		'US1840000203' => 'Leith',
		'US1840000194' => 'Richardton',
		'US1840000113' => 'Mercer',
		'US1840023807' => 'Jessie',
		'US1840001926' => 'Bismarck',
		'US1840023801' => 'Heimdal',
		'US1840023780' => 'East Fairview',
		'US1840000046' => 'Burlington',
		'US1840000098' => 'Petersburg',
		'US1840000192' => 'Dickinson',
		'US1840000159' => 'Regan',
		'US1840016555' => 'Calio',
		'US1840000170' => 'Amenia',
		'US1840000026' => 'Hannah',
		'US1840023879' => 'De Lamere',
		'US1840000148' => 'Golva',
		'US1840000039' => 'Lignite',
		'US1840001854' => 'Willow City',
		'US1840001850' => 'Rolette',
		'US1840000175' => 'Casselton',
		'US1840000032' => 'Osnabrock',
		'US1840000099' => 'Emerado',
		'US1840000220' => 'Marion',
		'US1840033127' => 'Shell Valley',
		'US1840000102' => 'Inkster',
		'US1840001931' => 'Sanborn',
		'US1840033094' => 'Springbrook',
		'US1840033126' => 'East Dunseith',
		'US1840000131' => 'Hannaford',
		'US1840001987' => 'Wishek',
		'US1840016544' => 'Alsen',
		'US1840000019' => 'Egeland',
		'US1840000232' => 'Hankinson',
		'US1840000195' => 'Almont',
		'US1840000084' => 'Minto',
		'US1840000243' => 'Hettinger',
		'US1840000117' => 'Fessenden',
		'US1840000173' => 'Briarwood',
		'US1840000207' => 'Hazelton',
		'US1840001874' => 'Bantry',
		'US1840000184' => 'Kindred',
		'US1840000090' => 'Leeds',
		'US1840016556' => 'Loma',
		'US1840000104' => 'Manvel',
		'US1840003996' => 'Fort Totten',
		'US1840000139' => 'Glenfield',
		'US1840001856' => 'Bathgate',
		'US1840000025' => 'Calvin',
		'US1840000001' => 'Mylo',
		'US1840000251' => 'Ellendale',
		'US1840001877' => 'White Earth',
		'US1840000230' => 'Fairmount',
		'US1840033125' => 'Reiles Acres',
		'US1840000226' => 'Fort Ransom',
		'US1840000034' => 'Crosby',
		'US1840000254' => 'Ludden',
		'US1840001906' => 'Clifford',
		'US1840000138' => 'Carrington',
		'US1840000053' => 'Minot',
		'US1840000122' => 'McClusky',
		'US1840001861' => 'Sarles',
		'US1840001934' => 'Ayr',
		'US1840001890' => 'Tolna',
		'US1840000185' => 'Leonard',
		'US1840000106' => 'Northwood',
		'US1840000154' => 'Kensal',
		'US1840001944' => 'Berlin',
		'US1840001901' => 'Cathay',
		'US1840000228' => 'Wahpeton',
		'US1840000161' => 'Dazey',
		'US1840023761' => 'Foxholm',
		'US1840000158' => 'Lincoln',
		'US1840000048' => 'Des Lacs',
		'US1840000193' => 'Gladstone',
		'US1840000133' => 'Galesburg',
		'US1840000037' => 'Bowbells',
		'US1840023874' => 'Porcupine',
		'US1840000055' => 'Epping',
		'US1840000105' => 'Niagara',
		'US1840001909' => 'Stanton',
		'US1840000107' => 'Reynolds',
		'US1840001904' => 'Binford',
		'US1840000100' => 'Gilby',
		'US1840000225' => 'Enderlin',
		'US1840001968' => 'Solen',
		'US1840000151' => 'Robinson',
		'US1840001852' => 'St. John',
		'US1840000064' => 'Granville',
		'US1840001916' => 'Beach',
		'US1840000135' => 'Hillsboro',
		'US1840000103' => 'Larimore',
		'US1840000179' => 'Gardner',
		'US1840001923' => 'Courtenay',
		'US1840001947' => 'Barney',
		'US1840000101' => 'Grand Forks',
		'US1840023859' => 'Harmon',
		'US1840000134' => 'Hatton',
		'US1840059041' => 'Canton City',
		'US1840000233' => 'Lidgerwood',
		'US1840001897' => 'Turtle Lake',
		'US1840000209' => 'Fredonia',
		'US1840023768' => 'Auburn',
		'US1840023762' => 'Logan',
		'US1840000096' => 'McVille',
		'US1840000020' => 'Hansboro',
		'US1840000125' => 'Dunn Center',
		'US1840001894' => 'Wilton',
		'US1840023846' => 'Brooktree Park',
		'US1840001905' => 'Cooperstown',
		'US1840006615' => 'White Shield',
		'US1840000016' => 'Neche',
		'US1840000183' => 'Hunter',
		'US1840000014' => 'Hamilton',
		'US1840001851' => 'Rolla',
		'US1840000044' => 'Loraine',
		'US1840000186' => 'Mapleton',
		'US1840023765' => 'Barton',
		'US1840000063' => 'Drake',
		'US1840003990' => 'Belcourt',
		'US1840001985' => 'Rutland',
		'US1840001902' => 'Sykeston',
		'US1840000197' => 'Glen Ullin',
		'US1840000137' => 'Portland',
		'US1840000052' => 'Makoti',
		'US1840000050' => 'Douglas',
		'US1840001853' => 'Westhope',
		'US1840000206' => 'Hague',
		'US1840000066' => 'Kief',
		'US1840000112' => 'Max',
		'US1840000177' => 'Fargo',
		'US1840000153' => 'Jamestown',
		'US1840023870' => 'Englevale',
		'US1840000187' => 'North River',
		'US1840000142' => 'Golden Valley',
		'US1840000078' => 'Fairdale',
		'US1840000007' => 'Lansford',
		'US1840001888' => 'York',
		'US1840000257' => 'Bowman',
		'US1840001984' => 'Cogswell',
		'US1840000182' => 'Horace',
		'US1840023864' => 'Raleigh',
		'US1840000045' => 'Mohall',
		'US1840001933' => 'Oxbow',
		'US1840000116' => 'Bowdon',
		'US1840000168' => 'Pillsbury',
		'US1840000198' => 'Hebron',
		'US1840001908' => 'Zap',
		'US1840001903' => 'Sharon',
		'US1840000166' => 'Nome',
		'US1840001893' => 'Benedict',
		'US1840000086' => 'Pisek',
		'US1840000000' => 'Dunseith',
		'US1840000201' => 'Carson',
		'US1840001920' => 'Tuttle',
		'US1840001988' => 'Zeeland',
		'US1840000073' => 'Edmore',
		'US1840000029' => 'Milton',
		'US1840000074' => 'Hampden',
		'US1840025250' => 'Manning',
		'US1840000091' => 'Maddock',
		'US1840000013' => 'Drayton',
		'US1840000060' => 'Velva',
		'US1840001857' => 'Cavalier',
		'US1840000196' => 'Flasher',
		'US1840000111' => 'Garrison',
		'US1840000178' => 'Frontier',
		'US1840000056' => 'Grenora',
		'US1840000126' => 'Halliday',
		'US1840001866' => 'Berthold',
		'US1840000256' => 'Oakes',
		'US1840001855' => 'Souris',
		'US1840023769' => 'Nash',
		'US1840001899' => 'Washburn',
		'US1840000057' => 'Ray',
		'US1840000015' => 'Mountain',
		'US1840000208' => 'Linton',
		'US1840001864' => 'Sherwood',
		'US1840023767' => 'Selz',
		'US1840000041' => 'Powers Lake',
		'US1840003997' => 'Mandaree',
		'US1840001858' => 'St. Thomas',
		'US1840000059' => 'Upham',
		'US1840000214' => 'Verona',
		'US1840000143' => 'Hazen',
		'US1840000180' => 'Grandin',
		'US1840000204' => 'New Leipzig',
		'US1840000083' => 'Lankin',
		'US1840000249' => 'Venturia',
		'US1840023808' => 'Sutton',
		'US1840000115' => 'New Rockford',
		'US1840001927' => 'Wing',
		'US1840000097' => 'Pekin',
		'US1840073766' => 'Minot AFB',
		'US1840001869' => 'Surrey',
		'US1840000144' => 'Pick City',
		'US1840000215' => 'Dickey',
		'US1840000250' => 'Lehr',
		'US1840001871' => 'Williston',
		'US1840000248' => 'Milnor',
		'US1840001892' => 'Watford City',
		'US1840023758' => 'Larson',
		'US1840000253' => 'Fullerton',
		'US1840001925' => 'Streeter',
		'US1840001891' => 'Thompson',
		'US1840000005' => 'Kramer',
		'US1840000129' => 'Hope',
		'US1840000124' => 'Dodge',
		'US1840000212' => 'Amidon',
		'US1840000157' => 'Pingree',
		'US1840000141' => 'McHenry',
		'US1840023778' => 'Dahlen',
		'US1840000130' => 'Luverne',
		'US1840000067' => 'New Town',
		'US1840001896' => 'Ruso',
		'US1840000246' => 'Gwinner',
		'US1840006628' => 'Wheatland',
		'US1840001876' => 'Towner',
		'US1840001860' => 'Bisbee',
		'US1840000227' => 'Lisbon',
		'US1840001879' => 'Stanley',
		'US1840000160' => 'Valley City',
		'US1840001932' => 'Sibley',
		'US1840000069' => 'Parshall',
		'US1840000119' => 'Harvey',
		'US1840000071' => 'Brocket',
		'US1840023809' => 'Blanchard',
		'US1840000017' => 'Pembina',
		'US1840000002' => 'Antler',
		'US1840001895' => 'Coleharbor',
		'US1840001885' => 'Starkweather',
		'US1840000088' => 'Esmond',
		'US1840000150' => 'Pettibone',
		'US1840000118' => 'Hamberg',
		'US1840001898' => 'Underwood',
		'US1840000108' => 'Alexander',
		'US1840000110' => 'Butte',
		'US1840023810' => 'Caledonia',
		'US1840000241' => 'Bucyrus',
		'US1840000036' => 'Noonan',
		'US1840000087' => 'Brinsmade',
		'US1840000075' => 'Lawton',
		'US1840023763' => 'Ruthville',
		'US1840000255' => 'Monango',
		'US1840000223' => 'Regent',
		'US1840000121' => 'Goodrich',
		'US1840001918' => 'Steele',
		'US1840000242' => 'Haynes',
		'US1840000047' => 'Carpio',
		'US1840000009' => 'Newburg',
		'US1840000095' => 'Lakota',
		'US1840001889' => 'Warwick',
		'US1840000181' => 'Harwood',
		'US1840000244' => 'Reeder',
		'US1840001865' => 'Tolley',
		'US1840000051' => 'Kenmare',
		'US1840001882' => 'Rugby',
		'US1840001862' => 'Wales',
		'US1840000211' => 'Napoleon',
		'US1840000093' => 'Oberon',
		'US1840000171' => 'Argusville',
		'US1840033113' => 'Four Bears Village',
		'US1840000176' => 'Davenport',
		'US1840001948' => 'Wyndmere',
		'US1840000202' => 'Elgin',
		'US1840001900' => 'Sheyenne',
		'US1840000008' => 'Maxbass',
		'US1840000136' => 'Mayville',
		'US1840000221' => 'Mott',
		'US1840059042' => 'Michigan City',
		'US1840000149' => 'Dawson',
		'US1840001917' => 'Sentinel Butte',
		'US1840000162' => 'Fingal',
		'US1840000127' => 'Killdeer',
		'US1840001919' => 'Tappen',
		'US1840000224' => 'Elliott',
		'US1840000043' => 'Grano',
		'US1840001929' => 'Wimbledon',
		'US1840000081' => 'Grafton',
		'US1840025256' => 'Driscoll',
		'US1840000040' => 'Portal',
		'US1840000062' => 'Deering',
		'US1840001986' => 'Ashley',
		'US1840001928' => 'Center',
		'US1840000077' => 'Edinburg',
		'US1840023766' => 'Orrin',
		'US1840000114' => 'Riverdale',
		'US1840001935' => 'West Fargo',
		'US1840000231' => 'Great Bend',
		'US1840000258' => 'Gascoyne',
		'US1840000152' => 'Buchanan',
		'US1840000079' => 'Fordville',
		'US1840001943' => 'Strasburg',
		'US1840000216' => 'Edgeley',
		'US1840059043' => 'Rocklake',
		'US1840001945' => 'Sheldon',
		'US1840000042' => 'Glenburn',
		'US1840004000' => 'Erie',
		'US1840000252' => 'Forbes',
		'US1840000021' => 'Perth',
		'US1840000132' => 'Buxton',
		'US1840000076' => 'Ardoch',
		'US1840000199' => 'Mandan',
		'US1840001878' => 'Ross',
		'US1840001872' => 'Tioga',
		'US1840001983' => 'Cayuga',
		'US1840000205' => 'Braddock',
		'US1840000030' => 'Munich',
		'US1840000089' => 'Knox',
		'US1840000245' => 'Forman',
		'US1840000035' => 'Fortuna',
		'US1840000068' => 'Palermo',
		'US1840000033' => 'Ambrose',
		'US1840000236' => 'Fort Yates',
		'US1840001886' => 'Adams',
		'US1840001949' => 'Christine',
		'US1840000169' => 'Alice',
		'US1840000054' => 'Alamo',
		'US1840000172' => 'Arthur',
		'US1840004004' => 'Cannon Ball',
		'US1840000123' => 'Martin',
		'US1840000018' => 'Cando',
		'US1840001921' => 'Woodworth',
		'US1840000188' => 'Page',
		'US1840000058' => 'Anamoose',
		'US1840023844' => 'Spiritwood',
		'US1840001859' => 'Walhalla',
		'US1840001922' => 'Cleveland',
		'US1840000189' => 'Prairie Rose',
		'US1840001950' => 'Colfax',
		'US1840023871' => 'McLeod',
		'US1840000010' => 'Overly',
		'US1840000164' => 'Leal',
		'US1840000094' => 'Aneta',
		'US1840000234' => 'Mantador',
		'US1840000147' => 'Medora',
		'US1840001946' => 'Abercrombie',
		'US1840001863' => 'Columbus',
		'US1840000038' => 'Flaxton',
		'US1840001924' => 'Spiritwood Lake',
		'US1840000222' => 'New England',
		'US1840000070' => 'Plaza',
		'US1840040312' => 'Green Acres',
		'US1840001937' => 'Belfield',
		'US1840000229' => 'Dwight',
		'US1840001887' => 'Conway',
		'US1840000031' => 'Nekoma',
		'US1840000156' => 'Montpelier',
		'US1840000006' => 'Landa',
		'US1840000049' => 'Donnybrook',
		'US1840001875' => 'Bergen',
		'US1840000003' => 'Bottineau',
		'US1840023847' => 'Embden',
		'US1840023845' => 'Ypsilanti',
		'US1840000140' => 'Grace City',
		'US1840000219' => 'LaMoure',
		'US1840000200' => 'New Salem',
		'US1840001936' => 'Tower City',
		'US1840001880' => 'Balta',
		'US1840000109' => 'Arnegard',
		'US1840000217' => 'Jud',
		'US1840001951' => 'Walcott',
		'US1840023802' => 'Denhoff',
		'US1840001930' => 'Rogers',
		'US1840000213' => 'Marmarth',
		'US1840023863' => 'Heil',
		'US1840000012' => 'Crystal',
		'US1840000167' => 'Oriska',
		'US1840001939' => 'Taylor',
		'US1840000210' => 'Gackle',
		'US1840000163' => 'Kathryn',
		'US1840073759' => 'Grand Forks AFB',
		'US1840025257' => 'Menoken',
		'US1840000072' => 'Crary',
		'US1840001868' => 'Sawyer',
		'US1840001967' => 'Selfridge',
		'US1840001870' => 'Wildrose',
		'US1840000218' => 'Kulm',
		'US1840000061' => 'Voltaire',
		'US1840000082' => 'Hoople',
		'US1840001873' => 'Balfour',
		'US1840000085' => 'Park River',
		'US1840000128' => 'Finley',
		'US1840000065' => 'Karlsruhe',
		'US1840000235' => 'Mooreton',
		'US1840000080' => 'Forest River',
		'US1840000120' => 'Hurdsfield',
		'US1840000155' => 'Medina',
		'US1840000259' => 'Rhame',
		'US1840001907' => 'Beulah',
		'US1840000092' => 'Minnewaukan',
		'US1840000165' => 'Litchville',
		'US1840000247' => 'Havana',
		'US1840001989' => 'Scranton',
		'US1840001867' => 'Ryder',
		'US1840000004' => 'Gardena',
		'US1840000174' => 'Buffalo',
		'US1840001938' => 'South Heart',
	],
	'NE' => [
		'US1840010211' => 'Ansley',
		'US1840007049' => 'Albion',
		'US1840011732' => 'Hampton',
		'US1840024198' => 'La Platte',
		'US1840008324' => 'Nebraska City',
		'US1840011626' => 'Rising City',
		'US1840011844' => 'Bennet',
		'US1840011642' => 'Dalton',
		'US1840011364' => 'Halsey',
		'US1840010271' => 'Abie',
		'US1840006922' => 'Bassett',
		'US1840011063' => 'Santee',
		'US1840011853' => 'Sprague',
		'US1840006893' => 'Chadron',
		'US1840012272' => 'Nora',
		'US1840011186' => 'Foster',
		'US1840011425' => 'Petersburg',
		'US1840007166' => 'Henderson',
		'US1840012060' => 'Deweese',
		'US1840009192' => 'Stanton',
		'US1840007144' => 'Aurora',
		'US1840011634' => 'Malmo',
		'US1840011033' => 'Lynch',
		'US1840012167' => 'Cook',
		'US1840011218' => 'Rosalie',
		'US1840012054' => 'Strang',
		'US1840011640' => 'Gurley',
		'US1840011470' => 'Mason City',
		'US1840007037' => 'Burwell',
		'US1840008136' => 'Norfolk',
		'US1840001384' => 'Alma',
		'US1840004795' => 'Bridgeport',
		'US1840011396' => 'Morrill',
		'US1840010092' => 'Wakefield',
		'US1840012043' => 'Smithfield',
		'US1840011073' => 'Magnet',
		'US1840011656' => 'Dix',
		'US1840024163' => 'Roscoe',
		'US1840010390' => 'Wilber',
		'US1840073804' => 'Greeley Center',
		'US1840012286' => 'Daykin',
		'US1840011359' => 'Mullen',
		'US1840011834' => 'Miller',
		'US1840011828' => 'Farnam',
		'US1840007215' => 'Crete',
		'US1840009445' => 'Red Cloud',
		'US1840012303' => 'Stamford',
		'US1840011098' => 'Maskell',
		'US1840012277' => 'Edison',
		'US1840012163' => 'Filley',
		'US1840011836' => 'Beaver Crossing',
		'US1840011457' => 'Inglewood',
		'US1840011852' => 'Panama',
		'US1840011966' => 'Otoe',
		'US1840012161' => 'Liberty',
		'US1840024167' => 'Archer',
		'US1840011839' => 'Cordova',
		'US1840011737' => 'Stockham',
		'US1840009196' => 'Oshkosh',
		'US1840008250' => 'Ogallala',
		'US1840011657' => 'Palmer',
		'US1840012291' => 'Steele City',
		'US1840024304' => 'Holmesville',
		'US1840011527' => 'Kennard',
		'US1840011473' => 'Gandy',
		'US1840024170' => 'Venice',
		'US1840010325' => 'Weeping Water',
		'US1840011222' => 'Walthill',
		'US1840011370' => 'Taylor',
		'US1840010212' => 'Arcadia',
		'US1840011658' => 'Silver Creek',
		'US1840011666' => 'Litchfield',
		'US1840008141' => 'Mitchell',
		'US1840012052' => 'Ohiowa',
		'US1840012348' => 'Stella',
		'US1840003710' => 'Franklin',
		'US1840007132' => 'Ashland',
		'US1840012271' => 'Ruskin',
		'US1840009356' => 'Seward',
		'US1840012049' => 'Exeter',
		'US1840009311' => 'Stromsburg',
		'US1840010475' => 'Alexandria',
		'US1840011065' => 'Winnetoon',
		'US1840012269' => 'Hardy',
		'US1840010176' => 'Cedar Rapids',
		'US1840010332' => 'Amherst',
		'US1840011366' => 'Thedford',
		'US1840003454' => 'David City',
		'US1840006918' => 'Hartington',
		'US1840024326' => 'Max',
		'US1840008336' => 'Fairfield',
		'US1840012281' => 'Hubbell',
		'US1840009427' => 'Peru',
		'US1840011848' => 'Firth',
		'US1840010116' => 'Brunswick',
		'US1840012036' => 'Ayr',
		'US1840011041' => 'Merriman',
		'US1840008287' => 'Milford',
		'US1840011465' => 'Scotia',
		'US1840012338' => 'Lewiston',
		'US1840012164' => 'Odell',
		'US1840011035' => 'Naper',
		'US1840008369' => 'McCook',
		'US1840011809' => 'Avoca',
		'US1840011664' => 'Farwell',
		'US1840011462' => 'Uehling',
		'US1840011662' => 'Dannebrog',
		'US1840012160' => 'Barneston',
		'US1840011731' => 'Big Springs',
		'US1840011096' => 'Emerson',
		'US1840011835' => 'Shelton',
		'US1840011392' => 'Henry',
		'US1840009313' => 'St. Paul',
		'US1840000458' => 'Neligh',
		'US1840011466' => 'Spalding',
		'US1840010333' => 'Waverly',
		'US1840012284' => 'Harbine',
		'US1840010122' => 'Carroll',
		'US1840012274' => 'Haigler',
		'US1840011653' => 'Wellfleet',
		'US1840011369' => 'Dunning',
		'US1840011734' => 'Giltner',
		'US1840007168' => 'Hickman',
		'US1840011661' => 'Cushing',
		'US1840011448' => 'Richland',
		'US1840009309' => 'Sidney',
		'US1840010284' => 'Bushnell',
		'US1840009400' => 'Syracuse',
		'US1840008251' => 'North Platte',
		'US1840011044' => 'Inman',
		'US1840009316' => 'Ralston',
		'US1840009354' => 'Louisville',
		'US1840024287' => 'Enders',
		'US1840012300' => 'Ragan',
		'US1840012349' => 'Verdon',
		'US1840011460' => 'Winslow',
		'US1840010286' => 'Clarks',
		'US1840012345' => 'Rulo',
		'US1840009327' => 'Springfield',
		'US1840024157' => 'Sunol',
		'US1840011220' => 'Winnebago',
		'US1840011472' => 'Oconto',
		'US1840011667' => 'Hazard',
		'US1840005176' => 'Chalco',
		'US1840011188' => 'Hemingford',
		'US1840011071' => 'Fordyce',
		'US1840007085' => 'Clarkson',
		'US1840011191' => 'Orchard',
		'US1840008289' => 'Grant',
		'US1840010285' => 'Chapman',
		'US1840011034' => 'Monowi',
		'US1840011627' => 'Octavia',
		'US1840011043' => 'Wood Lake',
		'US1840006892' => 'Crawford',
		'US1840011660' => 'Cotesfield',
		'US1840011830' => 'Sumner',
		'US1840011838' => 'Goehner',
		'US1840010079' => 'Anoka',
		'US1840011846' => 'Davey',
		'US1840011450' => 'Lindsay',
		'US1840010471' => 'Bruning',
		'US1840011446' => 'Leigh',
		'US1840011221' => 'Thurston',
		'US1840011040' => 'Crookston',
		'US1840025514' => 'Raeville',
		'US1840011815' => 'Murray',
		'US1840007232' => 'Auburn',
		'US1840006975' => 'Alliance',
		'US1840009446' => 'Superior',
		'US1840011652' => 'Wallace',
		'US1840024236' => 'Willow Island',
		'US1840011468' => 'Berwyn',
		'US1840000567' => 'Scribner',
		'US1840008337' => 'Minden',
		'US1840012287' => 'Diller',
		'US1840007213' => 'Curtis',
		'US1840024168' => 'St. Libory',
		'US1840011529' => 'Washington',
		'US1840011362' => 'Meadow Grove',
		'US1840024169' => 'King Lake',
		'US1840024199' => 'Richfield',
		'US1840011397' => 'Terrytown',
		'US1840012262' => 'Guide Rock',
		'US1840010209' => 'Callaway',
		'US1840012278' => 'Oxford',
		'US1840012265' => 'Hildreth',
		'US1840012279' => 'Wilsonville',
		'US1840003466' => 'Central City',
		'US1840024237' => 'Poole',
		'US1840011077' => 'Newport',
		'US1840011635' => 'Mead',
		'US1840010274' => 'Ceresco',
		'US1840011850' => 'Roca',
		'US1840011589' => 'Belgrade',
		'US1840011094' => 'Concord',
		'US1840010330' => 'Cairo',
		'US1840012050' => 'Fairmont',
		'US1840012042' => 'Elwood',
		'US1840003225' => 'Newman Grove',
		'US1840011813' => 'Manley',
		'US1840011812' => 'Elmwood',
		'US1840003222' => 'West Point',
		'US1840011101' => 'Jackson',
		'US1840008286' => 'Gibbon',
		'US1840007167' => 'Cozad',
		'US1840011964' => 'Douglas',
		'US1840011074' => 'Obert',
		'US1840011670' => 'Waterloo',
		'US1840011628' => 'Surprise',
		'US1840011475' => 'Elyria',
		'US1840011811' => 'Eagle',
		'US1840012270' => 'Lawrence',
		'US1840011358' => 'Hyannis',
		'US1840009197' => 'Scottsbluff',
		'US1840010434' => 'Wymore',
		'US1840009254' => 'Ord',
		'US1840010210' => 'Anselmo',
		'US1840011826' => 'Doniphan',
		'US1840011452' => 'Creston',
		'US1840025513' => 'Loretto',
		'US1840008019' => 'Gordon',
		'US1840011459' => 'Nickerson',
		'US1840024238' => 'Tamora',
		'US1840007086' => 'Humphrey',
		'US1840011631' => 'Leshara',
		'US1840024159' => 'Belmar',
		'US1840009193' => 'Lyons',
		'US1840007256' => 'Humboldt',
		'US1840012276' => 'Holbrook',
		'US1840011643' => 'Potter',
		'US1840012063' => 'Ong',
		'US1840010081' => 'Valentine',
		'US1840007250' => 'Hebron',
		'US1840011820' => 'Bradshaw',
		'US1840011651' => 'Sutherland',
		'US1840039774' => 'Woodland Hills',
		'US1840010432' => 'Brock',
		'US1840011663' => 'Elba',
		'US1840010435' => 'Clatonia',
		'US1840011819' => 'Benedict',
		'US1840011526' => 'Arlington',
		'US1840011391' => 'Lewellen',
		'US1840007137' => 'Bennington',
		'US1840009253' => 'Sargent',
		'US1840012051' => 'Milligan',
		'US1840008367' => 'Nelson',
		'US1840008334' => 'Friend',
		'US1840008333' => 'Geneva',
		'US1840012059' => 'Western',
		'US1840009314' => 'Loup City',
		'US1840011823' => 'McCool Junction',
		'US1840011810' => 'Greenwood',
		'US1840024288' => 'Inland',
		'US1840011648' => 'Brady',
		'US1840011837' => 'Bee',
		'US1840011625' => 'Garrison',
		'US1840011871' => 'Venango',
		'US1840011062' => 'Bazile Mills',
		'US1840012292' => 'Bartley',
		'US1840000566' => 'North Bend',
		'US1840012147' => 'Julian',
		'US1840012344' => 'Preston',
		'US1840011649' => 'Hershey',
		'US1840011816' => 'Nehawka',
		'US1840011845' => 'Hallam',
		'US1840011824' => 'Thayer',
		'US1840010093' => 'Allen',
		'US1840008368' => 'Fairbury',
		'US1840011064' => 'Niobrara',
		'US1840011831' => 'Elm Creek',
		'US1840012341' => 'Table Rock',
		'US1840024089' => 'Lindy',
		'US1840012261' => 'Bladen',
		'US1840011424' => 'Primrose',
		'US1840011655' => 'Shelby',
		'US1840011822' => 'Lushton',
		'US1840011097' => 'Martinsburg',
		'US1840024327' => 'Parks',
		'US1840011736' => 'Phillips',
		'US1840010117' => 'Clearwater',
		'US1840011368' => 'Ericson',
		'US1840012280' => 'Belvidere',
		'US1840012037' => 'Juniata',
		'US1840000956' => 'Grand Island',
		'US1840012067' => 'Norman',
		'US1840024064' => 'Brownlee',
		'US1840003263' => 'Tekamah',
		'US1840012047' => 'Wauneta',
		'US1840003455' => 'Wahoo',
		'US1840012064' => 'Trumbull',
		'US1840011528' => 'Herman',
		'US1840011842' => 'Staplehurst',
		'US1840003224' => 'Tilden',
		'US1840003618' => 'Sutton',
		'US1840011833' => 'Riverdale',
		'US1840012068' => 'Wilcox',
		'US1840012148' => 'Nemaha',
		'US1840011449' => 'Rogers',
		'US1840012299' => 'Huntley',
		'US1840010273' => 'Cedar Bluffs',
		'US1840010474' => 'Chester',
		'US1840012039' => 'Holstein',
		'US1840009191' => 'Madison',
		'US1840024137' => 'Westerville',
		'US1840012044' => 'Hamlet',
		'US1840011832' => 'Pleasanton',
		'US1840033182' => 'White Clay',
		'US1840012302' => 'Orleans',
		'US1840011453' => 'Duncan',
		'US1840000638' => 'Fullerton',
		'US1840024138' => 'Fontanelle',
		'US1840010121' => 'Wayne',
		'US1840024156' => 'Lorenzo',
		'US1840010272' => 'Yutan',
		'US1840010331' => 'Alda',
		'US1840010270' => 'Bruno',
		'US1840011458' => 'Dodge',
		'US1840011476' => 'North Loup',
		'US1840011029' => 'Hay Springs',
		'US1840011072' => 'St. Helena',
		'US1840012295' => 'Culbertson',
		'US1840007087' => 'Hooper',
		'US1840012168' => 'Crab Orchard',
		'US1840011045' => 'Emmet',
		'US1840010326' => 'Cedar Creek',
		'US1840011474' => 'Stapleton',
		'US1840006968' => 'Dakota City',
		'US1840008285' => 'Lexington',
		'US1840009312' => 'Osceola',
		'US1840012040' => 'Prosser',
		'US1840010433' => 'Brownville',
		'US1840024325' => 'Inavale',
		'US1840011633' => 'Prague',
		'US1840010472' => 'Byron',
		'US1840011070' => 'Coleridge',
		'US1840010089' => 'Chambers',
		'US1840011037' => 'Springview',
		'US1840007036' => 'Battle Creek',
		'US1840010150' => 'Brewster',
		'US1840012289' => 'Plymouth',
		'US1840011969' => 'Unadilla',
		'US1840007044' => 'Bayard',
		'US1840024090' => 'Aten',
		'US1840012046' => 'Lamar',
		'US1840011622' => 'Brainard',
		'US1840011669' => 'Boys Town',
		'US1840000406' => 'ONeill',
		'US1840012058' => 'Tobias',
		'US1840010328' => 'York',
		'US1840007216' => 'Harvard',
		'US1840010078' => 'Butte',
		'US1840026263' => 'Ames',
		'US1840012057' => 'Swanton',
		'US1840011215' => 'Winside',
		'US1840010077' => 'Bristow',
		'US1840008335' => 'Edgar',
		'US1840012263' => 'Cowles',
		'US1840012297' => 'Stratton',
		'US1840073770' => 'Offutt AFB',
		'US1840012288' => 'Endicott',
		'US1840011365' => 'Seneca',
		'US1840012035' => 'Stockville',
		'US1840011851' => 'Malcolm',
		'US1840011647' => 'Paxton',
		'US1840011827' => 'Eddyville',
		'US1840011632' => 'Colon',
		'US1840011735' => 'Marquette',
		'US1840012290' => 'Reynolds',
		'US1840000501' => 'Oakland',
		'US1840011621' => 'Bellwood',
		'US1840008380' => 'Falls City',
		'US1840011393' => 'Lyman',
		'US1840012076' => 'Bertrand',
		'US1840011841' => 'Pleasant Dale',
		'US1840011389' => 'Craig',
		'US1840009203' => 'St. Edward',
		'US1840011637' => 'Morse Bluff',
		'US1840012034' => 'Moorefield',
		'US1840011451' => 'Cornlea',
		'US1840012056' => 'Dorchester',
		'US1840011100' => 'Waterbury',
		'US1840011031' => 'Whitney',
		'US1840012075' => 'Atlanta',
		'US1840012078' => 'Funk',
		'US1840011102' => 'Homer',
		'US1840009135' => 'Pierce',
		'US1840003347' => 'Broken Bow',
		'US1840011363' => 'Pilger',
		'US1840011467' => 'Arnold',
		'US1840010327' => 'Alvo',
		'US1840009315' => 'Omaha',
		'US1840012282' => 'Davenport',
		'US1840010473' => 'Carleton',
		'US1840008252' => 'Kimball',
		'US1840008088' => 'Elgin',
		'US1840011629' => 'Ulysses',
		'US1840012169' => 'Elk Creek',
		'US1840012275' => 'Hendley',
		'US1840009355' => 'Plattsmouth',
		'US1840042682' => 'Lakeview',
		'US1840011454' => 'Monroe',
		'US1840073808' => 'Howard City',
		'US1840012077' => 'Loomis',
		'US1840011103' => 'Hubbard',
		'US1840009428' => 'Tecumseh',
		'US1840010163' => 'Broadwater',
		'US1840011843' => 'Utica',
		'US1840012170' => 'Sterling',
		'US1840011849' => 'Raymond',
		'US1840011623' => 'Linwood',
		'US1840012048' => 'Grafton',
		'US1840007094' => 'Blair',
		'US1840011968' => 'Talmage',
		'US1840006919' => 'Ainsworth',
		'US1840011471' => 'Merna',
		'US1840007249' => 'Beaver City',
		'US1840011367' => 'Bartlett',
		'US1840010090' => 'Center',
		'US1840004835' => 'Harrisburg',
		'US1840011817' => 'South Bend',
		'US1840024091' => 'Bow Valley',
		'US1840008196' => 'Fort Calhoun',
		'US1840011455' => 'Platte Center',
		'US1840009328' => 'Papillion',
		'US1840009454' => 'Pawnee City',
		'US1840007141' => 'Chappell',
		'US1840011036' => 'Spencer',
		'US1840011733' => 'Hordville',
		'US1840001130' => 'Hastings',
		'US1840011187' => 'McLean',
		'US1840009069' => 'Rushville',
		'US1840002459' => 'Crofton',
		'US1840011469' => 'Comstock',
		'US1840009129' => 'South Sioux City',
		'US1840000415' => 'Bloomfield',
		'US1840011360' => 'Bancroft',
		'US1840012347' => 'Shubert',
		'US1840011028' => 'Harrison',
		'US1840010470' => 'Campbell',
		'US1840008042' => 'Laurel',
		'US1840011630' => 'Ithaca',
		'US1840010283' => 'Brule',
		'US1840007143' => 'Gretna',
		'US1840011847' => 'Denton',
		'US1840007251' => 'Deshler',
		'US1840011641' => 'Lodgepole',
		'US1840011189' => 'Royal',
		'US1840011216' => 'Sholes',
		'US1840003617' => 'Clay Center',
		'US1840011075' => 'Wynot',
		'US1840011095' => 'Dixon',
		'US1840012162' => 'Cortland',
		'US1840008140' => 'Minatare',
		'US1840011190' => 'Oakdale',
		'US1840008139' => 'Gering',
		'US1840003346' => 'Fremont',
		'US1840012166' => 'Virginia',
		'US1840012041' => 'Roseland',
		'US1840011099' => 'Newcastle',
		'US1840007248' => 'Arapahoe',
		'US1840009357' => 'Lincoln',
		'US1840010436' => 'Adams',
		'US1840011447' => 'Howells',
		'US1840011668' => 'Rockville',
		'US1840011463' => 'Arthur',
		'US1840011219' => 'Pender',
		'US1840009136' => 'Plainview',
		'US1840024162' => 'Martin',
		'US1840024155' => 'Wann',
		'US1840000957' => 'Kearney',
		'US1840011047' => 'Page',
		'US1840002458' => 'Creighton',
		'US1840011870' => 'Madrid',
		'US1840012293' => 'Lebanon',
		'US1840011456' => 'Tarnov',
		'US1840007245' => 'Blue Hill',
		'US1840008370' => 'Indianola',
		'US1840011032' => 'Gross',
		'US1840011965' => 'Dunbar',
		'US1840011654' => 'Polk',
		'US1840011068' => 'Wausa',
		'US1840011039' => 'Cody',
		'US1840012062' => 'Saronville',
		'US1840024160' => 'Keystone',
		'US1840024164' => 'Sarben',
		'US1840011814' => 'Murdock',
		'US1840012301' => 'Republican City',
		'US1840012340' => 'Steinauer',
		'US1840003345' => 'Columbus',
		'US1840024286' => 'Champion',
		'US1840042699' => 'Woodland Park',
	],
	'TN' => [
		'US1840012298' => 'Trenton',
		'US1840024206' => 'Overland',
		'US1840025537' => 'Odessa',
		'US1840004693' => 'Macy',
		'US1840010374' => 'Burr',
		'US1840012165' => 'Pickrell',
		'US1840010329' => 'Wood River',
		'US1840011390' => 'Decatur',
		'US1840012061' => 'Glenvil',
		'US1840011076' => 'Johnstown',
		'US1840000639' => 'Genoa',
		'US1840012296' => 'Palisade',
		'US1840012342' => 'Barada',
		'US1840001131' => 'Holdrege',
		'US1840011818' => 'Union',
		'US1840011395' => 'Melbeta',
		'US1840011048' => 'Stuart',
		'US1840011038' => 'Kilgore',
		'US1840011624' => 'Dwight',
		'US1840007247' => 'Cambridge',
		'US1840011030' => 'Clinton',
		'US1840008263' => 'La Vista',
		'US1840011650' => 'Maxwell',
		'US1840011821' => 'Gresham',
		'US1840009252' => 'Schuyler',
		'US1840009134' => 'Osmond',
		'US1840012032' => 'Eustis',
		'US1840010080' => 'Burton',
		'US1840012268' => 'Upland',
		'US1840007234' => 'Blue Springs',
		'US1840024161' => 'Lemoyne',
		'US1840012053' => 'Shickley',
		'US1840011825' => 'Waco',
		'US1840000422' => 'Ponca',
		'US1840011461' => 'Snyder',
		'US1840009093' => 'Long Pine',
		'US1840007214' => 'Imperial',
		'US1840006917' => 'Atkinson',
		'US1840024136' => 'Tryon',
		'US1840012264' => 'Bloomington',
		'US1840010287' => 'Valley',
		'US1840011046' => 'Ewing',
		'US1840012294' => 'Danbury',
		'US1840011464' => 'Wolbach',
		'US1840012066' => 'Heartwell',
		'US1840033155' => 'Lisco',
		'US1840003223' => 'Wisner',
		'US1840012045' => 'Hayes Center',
		'US1840012033' => 'Maywood',
		'US1840011636' => 'Memphis',
		'US1840011963' => 'Lorton',
		'US1840012267' => 'Naponee',
		'US1840011394' => 'McGrew',
		'US1840012266' => 'Riverton',
		'US1840011361' => 'Beemer',
		'US1840042680' => 'Glenwood',
		'US1840008284' => 'Gothenburg',
		'US1840011042' => 'Nenzel',
		'US1840001352' => 'Beatrice',
		'US1840011639' => 'Weston',
		'US1840024099' => 'Berea',
		'US1840012346' => 'Salem',
		'US1840007246' => 'Benkelman',
		'US1840012343' => 'Dawson',
		'US1840011967' => 'Palmyra',
		'US1840012339' => 'Du Bois',
		'US1840000958' => 'Ravenna',
		'US1840009092' => 'Randolph',
		'US1840012273' => 'Oak',
		'US1840012038' => 'Kenesaw',
		'US1840012283' => 'Gilead',
		'US1840011067' => 'Verdigre',
		'US1840011638' => 'Valparaiso',
		'US1840012065' => 'Axtell',
		'US1840010493' => 'Burchard',
		'US1840012146' => 'Johnson',
		'US1840007142' => 'Bellevue',
		'US1840011829' => 'Overton',
		'US1840011840' => 'Garland',
		'US1840024239' => 'Walton',
		'US1840011665' => 'Ashton',
		'US1840011214' => 'Hoskins',
		'US1840011069' => 'Belden',
		'US1840011066' => 'Verdel',
		'US1840011185' => 'Hadar',
		'US1840011869' => 'Elsie',
		'US1840033202' => 'Yankee Hill',
		'US1840012285' => 'Jansen',
		'US1840012055' => 'De Witt',
		'US1840015343' => 'Trenton',
		'US1840015432' => 'Beersheba Springs',
		'US1840016221' => 'Oliver Springs',
		'US1840014438' => 'Paris',
		'US1840013377' => 'Walterhill',
		'US1840016287' => 'Stanton',
		'US1840013344' => 'Forest Hills',
		'US1840015385' => 'McMinnville',
		'US1840013347' => 'Berry Hill',
		'US1840016169' => 'White Pine',
		'US1840017698' => 'Sneedville',
		'US1840014473' => 'Oak Ridge',
		'US1840013413' => 'Brownsville',
		'US1840016386' => 'Hornsby',
		'US1840035990' => 'Soddy-Daisy',
		'US1840014549' => 'Niota',
		'US1840013295' => 'Gallatin',
		'US1840025756' => 'Robbins',
		'US1840016095' => 'Luttrell',
		'US1840014517' => 'Rockford',
		'US1840017872' => 'Powells Crossroads',
		'US1840015283' => 'Henry',
		'US1840014546' => 'Hohenwald',
		'US1840015379' => 'Louisville',
		'US1840016026' => 'Surgoinsville',
		'US1840025811' => 'Hillsboro',
		'US1840036150' => 'La Follette',
		'US1840015394' => 'Medon',
		'US1840014596' => 'Piperton',
		'US1840013300' => 'Bluff City',
		'US1840017721' => 'South Carthage',
		'US1840016271' => 'Viola',
		'US1840014468' => 'Dickson',
		'US1840014487' => 'Newport',
		'US1840013394' => 'Bells',
		'US1840014483' => 'Milan',
		'US1840016315' => 'Mason',
		'US1840016301' => 'Decatur',
		'US1840013478' => 'Sewanee',
		'US1840025814' => 'Riceville',
		'US1840013373' => 'Baneberry',
		'US1840013303' => 'Harrogate',
		'US1840016373' => 'Ethridge',
		'US1840040578' => 'Mowbray Mountain',
		'US1840016067' => 'Kenton',
		'US1840016014' => 'Greenbrier',
		'US1840013464' => 'Grand Junction',
		'US1840016180' => 'Huntingdon',
		'US1840014425' => 'Kingsport',
		'US1840016344' => 'Tracy City',
		'US1840014467' => 'Morristown',
		'US1840013401' => 'Greenback',
		'US1840015342' => 'Bradford',
		'US1840014601' => 'Decherd',
		'US1840013293' => 'Dover',
		'US1840014419' => 'Hendersonville',
		'US1840016184' => 'Liberty',
		'US1840015307' => 'Tusculum',
		'US1840015418' => 'Burlison',
		'US1840014527' => 'Lexington',
		'US1840024960' => 'Sale Creek',
		'US1840013475' => 'Finger',
		'US1840016018' => 'Winfield',
		'US1840016105' => 'Vanleer',
		'US1840014571' => 'Red Bank',
		'US1840016310' => 'Normandy',
		'US1840016235' => 'Maury City',
		'US1840013453' => 'Ardmore',
		'US1840015341' => 'Yorkville',
		'US1840014421' => 'Clarksville',
		'US1840015416' => 'Atoka',
		'US1840015380' => 'Maryville',
		'US1840016168' => 'Dandridge',
		'US1840016098' => 'Mosheim',
		'US1840013350' => 'Green Hill',
		'US1840025787' => 'Bowman',
		'US1840017790' => 'Spencer',
		'US1840017868' => 'Somerville',
		'US1840016286' => 'Graysville',
		'US1840015316' => 'Burns',
		'US1840015431' => 'Altamont',
		'US1840016101' => 'Oakdale',
		'US1840024893' => 'Graball',
		'US1840015368' => 'Alamo',
		'US1840073879' => 'Plainview',
		'US1840036101' => 'South Cleveland',
		'US1840013385' => 'Harriman',
		'US1840013430' => 'Etowah',
		'US1840015359' => 'Sevierville',
		'US1840016066' => 'Hornbeak',
		'US1840015276' => 'Bulls Gap',
		'US1840013351' => 'Rural Hill',
		'US1840016246' => 'Halls',
		'US1840036154' => 'Wildwood Lake',
		'US1840013068' => 'Eagleton Village',
		'US1840016316' => 'Garland',
		'US1840014572' => 'Ridgeside',
		'US1840016181' => 'McLemoresville',
		'US1840040591' => 'Tellico Village',
		'US1840016222' => 'Pittman Center',
		'US1840016413' => 'Petersburg',
		'US1840016430' => 'Monteagle',
		'US1840016170' => 'New Market',
		'US1840015387' => 'Lobelville',
		'US1840014602' => 'Charleston',
		'US1840017859' => 'Signal Mountain',
		'US1840025772' => 'Telford',
		'US1840016024' => 'Caryville',
		'US1840036097' => 'Parkers Crossroads',
		'US1840014472' => 'Norris',
		'US1840024897' => 'Walnut Grove',
		'US1840016015' => 'Westmoreland',
		'US1840015439' => 'Waynesboro',
		'US1840013380' => 'Franklin',
		'US1840016270' => 'Centertown',
		'US1840025795' => 'Chesterfield',
		'US1840013075' => 'Fairmount',
		'US1840024888' => 'Bethpage',
		'US1840014470' => 'Cookeville',
		'US1840015314' => 'Big Sandy',
		'US1840024891' => 'Cottontown',
		'US1840013429' => 'Athens',
		'US1840024892' => 'Fairfield',
		'US1840014556' => 'Coalmont',
		'US1840025758' => 'Mooresburg',
		'US1840013374' => 'Mascot',
		'US1840017740' => 'Rutherford',
		'US1840017758' => 'Smyrna',
		'US1840013342' => 'Bean Station',
		'US1840024896' => 'Shackle Island',
		'US1840015273' => 'Springfield',
		'US1840014500' => 'Pigeon Forge',
		'US1840013334' => 'Spurgeon',
		'US1840016411' => 'Guys',
		'US1840015386' => 'Spring Hill',
		'US1840014416' => 'Millersville',
		'US1840016060' => 'Gainesboro',
		'US1840014413' => 'Cross Plains',
		'US1840015412' => 'Shelbyville',
		'US1840015278' => 'Watauga',
		'US1840013450' => 'Middle Valley',
		'US1840014528' => 'Jackson',
		'US1840014428' => 'Church Hill',
		'US1840016419' => 'Huntland',
		'US1840025820' => 'Lone Oak',
		'US1840016072' => 'Tiptonville',
		'US1840013404' => 'Alcoa',
		'US1840016059' => 'Livingston',
		'US1840015440' => 'Loretto',
		'US1840013474' => 'Gallaway',
		'US1840016073' => 'Cottage Grove',
		'US1840013386' => 'Seymour',
		'US1840014595' => 'Moscow',
		'US1840013384' => 'Midtown',
		'US1840013299' => 'Walnut Hill',
		'US1840014414' => 'Orlinda',
		'US1840016071' => 'Gleason',
		'US1840017792' => 'Scotts Hill',
		'US1840025774' => 'Coalfield',
		'US1840025791' => 'Wildwood',
		'US1840013353' => 'Banner Hill',
		'US1840017710' => 'Ridgely',
		'US1840016022' => 'New Tazewell',
		'US1840016068' => 'Troy',
		'US1840015461' => 'Williston',
		'US1840025768' => 'Dodson Branch',
		'US1840014495' => 'Murfreesboro',
		'US1840016243' => 'Woodbury',
		'US1840013379' => 'Fairview',
		'US1840025812' => 'New Union',
		'US1840014422' => 'Red Boiling Springs',
		'US1840015281' => 'Woodland Mills',
		'US1840016183' => 'Trezevant',
		'US1840015460' => 'Braden',
		'US1840015410' => 'Tullahoma',
		'US1840014486' => 'Knoxville',
		'US1840025759' => 'Clarkrange',
		'US1840025821' => 'Pelham',
		'US1840016375' => 'Walden',
		'US1840025828' => 'Olivet',
		'US1840016410' => 'Eastview',
		'US1840014588' => 'Crump',
		'US1840024959' => 'Falling Water',
		'US1840025755' => 'Elgin',
		'US1840015415' => 'Sweetwater',
		'US1840015449' => 'Hickory Valley',
		'US1840015350' => 'Smithville',
		'US1840016240' => 'Centerville',
		'US1840014439' => 'Puryear',
		'US1840036153' => 'Three Way',
		'US1840013451' => 'Ooltewah',
		'US1840016023' => 'Jacksboro',
		'US1840016219' => 'Nolensville',
		'US1840016245' => 'Gates',
		'US1840017723' => 'Slayden',
		'US1840014485' => 'Jefferson City',
		'US1840016408' => 'Michie',
		'US1840013449' => 'Harrison',
		'US1840016409' => 'Milledgeville',
		'US1840016345' => 'Palmer',
		'US1840013372' => 'Dyersburg',
		'US1840016311' => 'Tellico Plains',
		'US1840016317' => 'Englewood',
		'US1840013294' => 'Adams',
		'US1840014412' => 'Cedar Hill',
		'US1840014466' => 'Lebanon',
		'US1840025757' => 'Fincastle',
		'US1840016070' => 'Dresden',
		'US1840015417' => 'Brighton',
		'US1840013312' => 'Central',
		'US1840016428' => 'Jasper',
		'US1840015373' => 'Henning',
		'US1840016269' => 'Morrison',
		'US1840016013' => 'Coopertown',
		'US1840015313' => 'Wartburg',
		'US1840025777' => 'Andersonville',
		'US1840014415' => 'Ridgetop',
		'US1840013476' => 'Fayetteville',
		'US1840014520' => 'Parsons',
		'US1840013371' => 'Dyer',
		'US1840015275' => 'Byrdstown',
		'US1840016097' => 'Gordonsville',
		'US1840040576' => 'Flat Top Mountain',
		'US1840013345' => 'Goodlettsville',
		'US1840014597' => 'Ramer',
		'US1840015331' => 'Waverly',
		'US1840016099' => 'Greeneville',
		'US1840015471' => 'South Pittsburg',
		'US1840013314' => 'Elizabethton',
		'US1840024919' => 'Lyles',
		'US1840013387' => 'Gatlinburg',
		'US1840036143' => 'Pine Crest',
		'US1840015346' => 'McKenzie',
		'US1840025790' => 'Walland',
		'US1840015349' => 'Alexandria',
		'US1840015317' => 'Algood',
		'US1840013298' => 'Blountville',
		'US1840017869' => 'Selmer',
		'US1840015463' => 'Bethel Springs',
		'US1840016273' => 'Linden',
		'US1840014550' => 'Henderson',
		'US1840014424' => 'Celina',
		'US1840014462' => 'Johnson City',
		'US1840016312' => 'Vonore',
		'US1840016012' => 'Cumberland City',
		'US1840015348' => 'Bruceton',
		'US1840013311' => 'Hunter',
		'US1840036055' => 'Iron City',
		'US1840016131' => 'Unicoi',
		'US1840013393' => 'Friendship',
		'US1840014418' => 'Portland',
		'US1840016307' => 'Cornersville',
		'US1840016092' => 'Jonesborough',
		'US1840014484' => 'Humboldt',
		'US1840014519' => 'Mount Pleasant',
		'US1840015475' => 'Benton',
		'US1840014489' => 'Crossville',
		'US1840015458' => 'Arlington',
		'US1840013428' => 'Gilt Edge',
		'US1840016254' => 'Loudon',
		'US1840017863' => 'Saltillo',
		'US1840017708' => 'Samburg',
		'US1840014569' => 'Chattanooga',
		'US1840016179' => 'Hollow Rock',
		'US1840016104' => 'Charlotte',
		'US1840016019' => 'Oneida',
		'US1840014574' => 'Minor Hill',
		'US1840014525' => 'Dayton',
		'US1840016236' => 'Gadsden',
		'US1840013378' => 'Eagleville',
		'US1840014544' => 'Lewisburg',
		'US1840016431' => 'Orme',
		'US1840015453' => 'Savannah',
		'US1840014600' => 'Cowan',
		'US1840025830' => 'Flintville',
		'US1840017707' => 'Rives',
		'US1840016387' => 'Toone',
		'US1840036155' => 'Nashville',
		'US1840014514' => 'Lenoir City',
		'US1840017791' => 'Sardis',
		'US1840025776' => 'Eva',
		'US1840013454' => 'Elkton',
		'US1840013465' => 'Bolivar',
		'US1840016172' => 'Parrottsville',
		'US1840016388' => 'Whiteville',
		'US1840015411' => 'Bell Buckle',
		'US1840015371' => 'Auburntown',
		'US1840016161' => 'Newbern',
		'US1840013064' => 'Fall Branch',
		'US1840016021' => 'Tazewell',
		'US1840013472' => 'Bartlett',
		'US1840013346' => 'Belle Meade',
		'US1840015354' => 'Sparta',
		'US1840016182' => 'Clarksburg',
		'US1840016376' => 'Lynnville',
		'US1840015462' => 'Adamsville',
		'US1840016218' => 'Thompsons Station',
		'US1840015304' => 'Ashland City',
		'US1840015279' => 'South Fulton',
		'US1840016025' => 'Mount Carmel',
		'US1840013067' => 'Fairfield Glade',
		'US1840016420' => 'Estill Springs',
		'US1840017699' => 'Rogersville',
		'US1840015472' => 'Whitwell',
		'US1840014471' => 'Clinton',
		'US1840013316' => 'Greenfield',
		'US1840014584' => 'Middleton',
		'US1840016171' => 'Farragut',
		'US1840016406' => 'La Grange',
		'US1840016309' => 'Wartrace',
		'US1840014480' => 'New Johnsonville',
		'US1840024890' => 'Castalian Springs',
		'US1840015340' => 'Medina',
		'US1840016403' => 'Collierville',
		'US1840015315' => 'Watertown',
		'US1840014423' => 'Lafayette',
		'US1840016108' => 'Monterey',
		'US1840013437' => 'Dunlap',
		'US1840013441' => 'Gruetli-Laager',
		'US1840013335' => 'Oak Grove',
		'US1840016069' => 'Obion',
		'US1840024894' => 'New Deal',
		'US1840013297' => 'Bloomingdale',
		'US1840016096' => 'Carthage',
		'US1840016272' => 'Decaturville',
		'US1840013452' => 'East Ridge',
		'US1840014547' => 'Covington',
		'US1840015305' => 'Maynardville',
		'US1840015312' => 'Sunbright',
		'US1840016306' => 'Chapel Hill',
		'US1840016130' => 'Erwin',
		'US1840036119' => 'Jellico',
		'US1840013343' => 'Blaine',
		'US1840014496' => 'La Vergne',
		'US1840014464' => 'Oak Hill',
		'US1840014573' => 'Lakesite',
		'US1840016102' => 'Tennessee Ridge',
		'US1840017722' => 'Rutledge',
		'US1840014488' => 'Crab Orchard',
		'US1840024958' => 'Apison',
		'US1840015280' => 'Union City',
		'US1840017861' => 'Silerton',
		'US1840036031' => 'East Cleveland',
		'US1840024920' => 'Wrigley',
		'US1840013405' => 'Friendsville',
		'US1840016412' => 'Stantonville',
		'US1840015318' => 'Baxter',
		'US1840016160' => 'Trimble',
		'US1840013063' => 'Colonial Heights',
		'US1840014429' => 'Jamestown',
		'US1840014461' => 'Pleasant View',
		'US1840015330' => 'McEwen',
		'US1840013375' => 'Lake Tansi',
		'US1840036144' => 'Lynchburg',
		'US1840013488' => 'Ducktown',
		'US1840016020' => 'Cumberland Gap',
		'US1840014513' => 'Philadelphia',
		'US1840017709' => 'Sharon',
		'US1840024961' => 'Park City',
		'US1840014604' => 'New Hope',
		'US1840016016' => 'Mountain City',
		'US1840014575' => 'Pulaski',
		'US1840016173' => 'Pleasant Hill',
		'US1840025775' => 'Petros',
		'US1840013473' => 'Germantown',
		'US1840014417' => 'Mitchellville',
		'US1840015347' => 'Atwood',
		'US1840016325' => 'Enville',
		'US1840015409' => 'Manchester',
		'US1840025826' => 'Summertown',
		'US1840017867' => 'Rossville',
		'US1840024918' => 'Bon Aqua Junction',
		'US1840013333' => 'Gray',
		'US1840014509' => 'Ripley',
		'US1840025796' => 'Darden',
		'US1840016159' => 'Gibson',
		'US1840024945' => 'Unionville',
		'US1840015414' => 'Madisonville',
		'US1840017789' => 'Spring City',
		'US1840015419' => 'Calhoun',
		'US1840014570' => 'Collegedale',
		'US1840013381' => 'Brentwood',
		'US1840025760' => 'Grimsley',
		'US1840016106' => 'White Bluff',
		'US1840013479' => 'Hopewell',
		'US1840013301' => 'Bristol',
		'US1840014532' => 'Pikeville',
		'US1840015274' => 'White House',
		'US1840014568' => 'Lawrenceburg',
		'US1840016407' => 'Oakland',
		'US1840016017' => 'Huntsville',
		'US1840016090' => 'Kingston Springs',
		'US1840016429' => 'Kimball',
		'US1840013302' => 'Helenwood',
		'US1840036036' => 'Fairgarden',
		'US1840016185' => 'Dowelltown',
		'US1840015306' => 'Baileyton',
		'US1840014563' => 'Collinwood',
		'US1840014498' => 'Rockwood',
		'US1840014518' => 'Columbia',
		'US1840013304' => 'Allardt',
		'US1840014465' => 'Mount Juliet',
		'US1840017860' => 'Saulsbury',
		'US1840015441' => 'St. Joseph',
		'US1840015466' => 'Winchester',
		'US1840016192' => 'Doyle',
		'US1840016374' => 'Lookout Mountain',
		'US1840015282' => 'Martin',
		'US1840073881' => 'Hartsville',
		'US1840014548' => 'Munford',
		'US1840014603' => 'Cleveland',
		'US1840014562' => 'Clifton',
		'US1840014593' => 'Millington',
		'US1840013349' => 'Camden',
		'US1840036091' => 'Rockvale',
		'US1840015381' => 'Townsend',
		'US1840015457' => 'Memphis',
		'US1840024889' => 'Bransford',
		'US1840016091' => 'Pegram',
		'US1840014594' => 'Lakeland',
		'US1840040577' => 'Lakewood Park',
		'US1840014499' => 'Kingston',
		'US1840013348' => 'Erin',
		'US1840014611' => 'Copperhill',
		'US1840036020' => 'Christiana',
		'US1840013313' => 'Roan Mountain',
	],
	'NY' => [
		'US1840000587' => 'Port Jervis',
		'US1840004888' => 'Brewster Hill',
		'US1840004295' => 'Sodus',
		'US1840005321' => 'Roslyn',
		'US1840024028' => 'Washington Mills',
		'US1840004691' => 'Wellsburg',
		'US1840004642' => 'Palenville',
		'US1840000586' => 'Newburgh',
		'US1840004244' => 'Aurora',
		'US1840024065' => 'Byersville',
		'US1840005267' => 'Inwood',
		'US1840000296' => 'Plattsburgh',
		'US1840026162' => 'Sanborn',
		'US1840004609' => 'Almond',
		'US1840004069' => 'Tupper Lake',
		'US1840005060' => 'North Sea',
		'US1840004584' => 'Odessa',
		'US1840004569' => 'Panama',
		'US1840004790' => 'Liberty',
		'US1840005293' => 'Hempstead',
		'US1840005029' => 'Cold Spring Harbor',
		'US1840026120' => 'Paul Smiths',
		'US1840000371' => 'Niagara Falls',
		'US1840004459' => 'Cherry Valley',
		'US1840004130' => 'Ellisburg',
		'US1840005105' => 'Terryville',
		'US1840004430' => 'Dansville',
		'US1840040254' => 'Groveland Station',
		'US1840025505' => 'Chenango Bridge',
		'US1840034052' => 'Hillside Lake',
		'US1840004935' => 'Mamaroneck',
		'US1840025341' => 'St. Regis Falls',
		'US1840005145' => 'Brightwaters',
		'US1840005314' => 'North Hills',
		'US1840004376' => 'Clarence Center',
		'US1840004977' => 'Kaser',
		'US1840004287' => 'Brockport',
		'US1840004989' => 'Wesley Hills',
		'US1840004551' => 'Painted Post',
		'US1840004060' => 'Norwood',
		'US1840004541' => 'South Hill',
		'US1840005234' => 'Carle Place',
		'US1840023979' => 'Felts Mills',
		'US1840004862' => 'Scotchtown',
		'US1840004425' => 'Livonia',
		'US1840005338' => 'Brookville',
		'US1840005048' => 'Moriches',
		'US1840004567' => 'Lakewood',
		'US1840004495' => 'Colonie',
		'US1840024062' => 'Grandyle Village',
		'US1840004176' => 'Granville',
		'US1840073684' => 'Greenport West',
		'US1840005135' => 'Saltaire',
		'US1840026187' => 'Crystal Beach',
		'US1840024081' => 'Scottsburg',
		'US1840005100' => 'South Huntington',
		'US1840004594' => 'Portville',
		'US1840004975' => 'Haverstraw',
		'US1840004382' => 'Town Line',
		'US1840024080' => 'Retsof',
		'US1840024141' => 'Salisbury Mills',
		'US1840005265' => 'Hewlett',
		'US1840004440' => 'Castleton-on-Hudson',
		'US1840005319' => 'Port Washington North',
		'US1840004988' => 'Upper Nyack',
		'US1840004549' => 'Hammondsport',
		'US1840004949' => 'Bronxville',
		'US1840005129' => 'Patchogue',
		'US1840000378' => 'Syracuse',
		'US1840005136' => 'Shoreham',
		'US1840004860' => 'Pine Bush',
		'US1840004174' => 'Fort Ann',
		'US1840024178' => 'Bedford Hills',
		'US1840024105' => 'Rhinecliff',
		'US1840005273' => 'Manhasset',
		'US1840004152' => 'Newport',
		'US1840004395' => 'Angola',
		'US1840004509' => 'New Berlin',
		'US1840004365' => 'Le Roy',
		'US1840000417' => 'Albany',
		'US1840005014' => 'Amagansett',
		'US1840005134' => 'Sagaponack',
		'US1840004141' => 'Croghan',
		'US1840005034' => 'Deer Park',
		'US1840004855' => 'Fort Montgomery',
		'US1840004282' => 'Honeoye Falls',
		'US1840004189' => 'Hannibal',
		'US1840073662' => 'Remsenburg-Speonk',
		'US1840005316' => 'Old Westbury',
		'US1840005242' => 'North Merrick',
		'US1840004363' => 'Earlville',
		'US1840004704' => 'Cragsmoor',
		'US1840073655' => 'Plattsburgh West',
		'US1840005026' => 'Centereach',
		'US1840004133' => 'Harrisville',
		'US1840004314' => 'Nedrow',
		'US1840005041' => 'East Quogue',
		'US1840004124' => 'Cape Vincent',
		'US1840024047' => 'North Gates',
		'US1840004068' => 'Saranac Lake',
		'US1840004574' => 'Bemus Point',
		'US1840000393' => 'Geneva',
		'US1840005079' => 'Holtsville',
		'US1840033982' => 'Water Mill',
		'US1840004856' => 'Balmville',
		'US1840005104' => 'Stony Brook',
		'US1840004632' => 'Valatie',
		'US1840004045' => 'Dannemora',
		'US1840005146' => 'Dering Harbor',
		'US1840004153' => 'Poland',
		'US1840005290' => 'Great Neck',
		'US1840004585' => 'Watkins Glen',
		'US1840024078' => 'Livonia Center',
		'US1840004598' => 'Cattaraugus',
		'US1840004793' => 'Wurtsboro',
		'US1840004204' => 'Clark Mills',
		'US1840004041' => 'Lyon Mountain',
		'US1840004059' => 'Morristown',
		'US1840040241' => 'Gilgo',
		'US1840005066' => 'Port Jefferson Station',
		'US1840004055' => 'Hammond',
		'US1840004953' => 'Elmsford',
		'US1840004438' => 'Schaghticoke',
		'US1840024063' => 'Wanakah',
		'US1840004309' => 'Mayfield',
		'US1840004219' => 'Boonville',
		'US1840004755' => 'Wappingers Falls',
		'US1840025456' => 'Port Gibson',
		'US1840004441' => 'East Nassau',
		'US1840005047' => 'Montauk',
		'US1840005233' => 'Bethpage',
		'US1840004064' => 'Waddington',
		'US1840004215' => 'Waterville',
		'US1840005009' => 'Farmingville',
		'US1840005083' => 'Islip Terrace',
		'US1840004288' => 'Churchville',
		'US1840004112' => 'Glen Park',
		'US1840005089' => 'Mastic Beach',
		'US1840005286' => 'Floral Park',
		'US1840004508' => 'Greene',
		'US1840005122' => 'Lindenhurst',
		'US1840000783' => 'Peekskill',
		'US1840004753' => 'Rhinebeck',
		'US1840000418' => 'Cohoes',
		'US1840004720' => 'Lincoln Park',
		'US1840004418' => 'Lodi',
		'US1840005276' => 'South Farmingdale',
		'US1840005022' => 'Bridgehampton',
		'US1840004387' => 'Lancaster',
		'US1840004893' => 'Brewster',
		'US1840005232' => 'Bellmore',
		'US1840004180' => 'Whitehall',
		'US1840004916' => 'Chappaqua',
		'US1840004413' => 'Shortsville',
		'US1840004978' => 'Montebello',
		'US1840004702' => 'Accord',
		'US1840005054' => 'North Babylon',
		'US1840004331' => 'Camillus',
		'US1840004214' => 'Vernon',
		'US1840026219' => 'Watchtower',
		'US1840005244' => 'North Valley Stream',
		'US1840004547' => 'Dryden',
		'US1840004939' => 'Pelham Manor',
		'US1840004240' => 'Moravia',
		'US1840004217' => 'Yorkville',
		'US1840005013' => 'Fort Salonga',
		'US1840005282' => 'West Hempstead',
		'US1840033948' => 'Saddle Rock',
		'US1840004238' => 'Fair Haven',
		'US1840004252' => 'Stillwater',
		'US1840004742' => 'Myers Corner',
		'US1840025491' => 'Smithville Flats',
		'US1840025501' => 'Davenport Center',
		'US1840004976' => 'Hillburn',
		'US1840004578' => 'Cherry Creek',
		'US1840004105' => 'Calcium',
		'US1840004794' => 'Bloomingburg',
		'US1840005270' => 'Levittown',
		'US1840004925' => 'Scotts Corners',
		'US1840004960' => 'Congers',
		'US1840004191' => 'Mexico',
		'US1840000348' => 'Oswego',
		'US1840000472' => 'Elmira',
		'US1840073604' => 'Carmel Hamlet',
		'US1840004250' => 'Schuylerville',
		'US1840005141' => 'Asharoken',
		'US1840004192' => 'Parish',
		'US1840004149' => 'Ilion',
		'US1840023988' => 'Thousand Island Park',
		'US1840004662' => 'Windsor',
		'US1840000445' => 'Dunkirk',
		'US1840004237' => 'Melrose Park',
		'US1840004546' => 'Cayuga Heights',
		'US1840005084' => 'Jamesport',
		'US1840004669' => 'Spencer',
		'US1840004733' => 'Ellenville',
		'US1840073579' => 'Fort Drum',
		'US1840004930' => 'Yorktown Heights',
		'US1840000585' => 'Middletown',
		'US1840005064' => 'Orient',
		'US1840005125' => 'North Haven',
		'US1840004875' => 'Montgomery',
		'US1840004194' => 'Pulaski',
		'US1840004177' => 'Greenwich',
		'US1840004589' => 'Franklinville',
		'US1840004372' => 'Elma Center',
		'US1840005103' => 'St. James',
		'US1840005116' => 'Yaphank',
		'US1840004923' => 'Lake Mohegan',
		'US1840004494' => 'Altamont',
		'US1840000419' => 'Cortland',
		'US1840042758' => 'Stony Brook University',
		'US1840005063' => 'Oakdale',
		'US1840034067' => 'Beaver Dam Lake',
		'US1840004943' => 'Scarsdale',
		'US1840004711' => 'Port Ewen',
		'US1840004043' => 'Rouses Point',
		'US1840004373' => 'Angola on the Lake',
		'US1840005250' => 'Plainview',
		'US1840026215' => 'Pine Valley',
		'US1840004327' => 'Skaneateles',
		'US1840024074' => 'Hunt',
		'US1840005280' => 'University Gardens',
		'US1840005107' => 'Wading River',
		'US1840004870' => 'Harriman',
		'US1840024107' => 'Titusville',
		'US1840004197' => 'Central Square',
		'US1840073710' => 'Setauket-East Setauket',
		'US1840073642' => 'Northeast Ithaca',
		'US1840004263' => 'Lyndonville',
		'US1840004750' => 'Millerton',
		'US1840004108' => 'Redwood',
		'US1840005032' => 'Coram',
		'US1840005110' => 'West Bay Shore',
		'US1840005258' => 'Garden City South',
		'US1840005304' => 'Lynbrook',
		'US1840073670' => 'Rosendale Hamlet',
		'US1840004559' => 'Bath',
		'US1840005318' => 'Plandome',
		'US1840005255' => 'Salisbury',
		'US1840000391' => 'Amsterdam',
		'US1840004439' => 'Valley Falls',
		'US1840026146' => 'Bolton Landing',
		'US1840004401' => 'Fort Johnson',
		'US1840004600' => 'East Randolph',
		'US1840005051' => 'Nesconset',
		'US1840034049' => 'Eatons Neck',
		'US1840000452' => 'Olean',
		'US1840005254' => 'Roslyn Heights',
		'US1840004938' => 'Pelham',
		'US1840005230' => 'Bay Park',
		'US1840004866' => 'West Point',
		'US1840025430' => 'Chestertown',
		'US1840004730' => 'Zena',
		'US1840005019' => 'Blue Point',
		'US1840023980' => 'Fishers Landing',
		'US1840004728' => 'West Hurley',
		'US1840004751' => 'Pawling',
		'US1840073692' => 'Horseheads North',
		'US1840026197' => 'Coopers Plains',
		'US1840004623' => 'Walton',
		'US1840004040' => 'Redford',
		'US1840004865' => 'Washington Heights',
		'US1840004754' => 'Tivoli',
		'US1840004657' => 'Endwell',
		'US1840004332' => 'East Syracuse',
		'US1840005057' => 'North Great River',
		'US1840024068' => 'Cuylerville',
		'US1840004890' => 'Lake Carmel',
		'US1840005031' => 'Copiague',
		'US1840004116' => 'Sackets Harbor',
		'US1840004184' => 'West Glens Falls',
		'US1840005272' => 'Locust Valley',
		'US1840034051' => 'Haviland',
		'US1840004788' => 'South Fallsburg',
		'US1840026142' => 'Old Forge',
		'US1840005073' => 'Great River',
		'US1840004564' => 'Falconer',
		'US1840004947' => 'Ardsley',
		'US1840004209' => 'Oriskany',
		'US1840000987' => 'Glen Cove',
		'US1840005128' => 'Old Field',
		'US1840004732' => 'Saugerties',
		'US1840004255' => 'Corinth',
		'US1840005035' => 'Dix Hills',
		'US1840026189' => 'Keuka Park',
		'US1840004622' => 'Stamford',
		'US1840005344' => 'East Williston',
		'US1840000988' => 'Long Beach',
		'US1840004121' => 'Antwerp',
		'US1840005226' => 'Elmont',
		'US1840000349' => 'Rome',
		'US1840005025' => 'Center Moriches',
		'US1840004297' => 'Wolcott',
		'US1840033949' => 'Saddle Rock Estates',
		'US1840005039' => 'East Northport',
		'US1840035108' => 'East Hampton North',
		'US1840004626' => 'Niverville',
		'US1840004148' => 'Herkimer',
		'US1840004617' => 'Franklin',
		'US1840005275' => 'Seaford',
		'US1840000377' => 'Fairmount',
		'US1840004134' => 'Lowville',
		'US1840034058' => 'Peach Lake',
		'US1840073698' => 'Jamestown West',
		'US1840004496' => 'Munsons Corners',
		'US1840004649' => 'Athens',
		'US1840004703' => 'Clintondale',
		'US1840004362' => 'DeRuyter',
		'US1840004741' => 'Dover Plains',
		'US1840005309' => 'Mill Neck',
		'US1840004212' => 'Remsen',
		'US1840034041' => 'Seneca Knolls',
		'US1840005117' => 'Greenport',
		'US1840000345' => 'Glens Falls',
		'US1840004254' => 'Ballston Spa',
		'US1840004135' => 'Lyons Falls',
		'US1840004690' => 'Van Etten',
		'US1840004785' => 'Roscoe',
		'US1840005296' => 'Hewlett Neck',
		'US1840004063' => 'Richville',
		'US1840004286' => 'Webster',
		'US1840000347' => 'Fulton',
		'US1840004512' => 'Smyrna',
		'US1840025482' => 'Blodgett Mills',
		'US1840004195' => 'Sandy Creek',
		'US1840004937' => 'Ossining',
		'US1840004390' => 'Sloan',
		'US1840040222' => 'Conesus Lake',
		'US1840005329' => 'Thomaston',
		'US1840005302' => 'Laurel Hollow',
		'US1840034048' => 'East Shoreham',
		'US1840004322' => 'Liverpool',
		'US1840024084' => 'Wadsworth',
		'US1840024073' => 'Hemlock',
		'US1840034044' => 'Crown Heights',
		'US1840004427' => 'Nunda',
		'US1840004663' => 'Deposit',
		'US1840004863' => 'Vails Gate',
		'US1840004745' => 'Red Oaks Mill',
		'US1840005053' => 'North Amityville',
		'US1840004388' => 'North Collins',
		'US1840004990' => 'West Haverstraw',
		'US1840005229' => 'Baldwin Harbor',
		'US1840004239' => 'Meridian',
		'US1840004444' => 'East Glenville',
		'US1840004393' => 'Akron',
		'US1840004618' => 'Hancock',
		'US1840004511' => 'Sherburne',
		'US1840026145' => 'North Creek',
		'US1840005077' => 'Hauppauge',
		'US1840034042' => 'Barnum Island',
		'US1840040262' => 'Springwater Hamlet',
		'US1840004280' => 'Fairport',
		'US1840073610' => 'Claverack-Red Mills',
		'US1840004106' => 'Depauville',
		'US1840004616' => 'Fleischmanns',
		'US1840005052' => 'New Suffolk',
		'US1840005249' => 'Plainedge',
		'US1840005287' => 'Flower Hill',
		'US1840005042' => 'Eastport',
		'US1840004475' => 'Castile',
		'US1840005033' => 'Cutchogue',
		'US1840023985' => 'Pierrepont Manor',
		'US1840004196' => 'Altmar',
		'US1840026341' => 'Sparkill',
		'US1840004409' => 'Canajoharie',
		'US1840004036' => 'Au Sable Forks',
		'US1840004358' => 'Wampsville',
		'US1840024079' => 'Piffard',
		'US1840004557' => 'Arkport',
		'US1840023989' => 'Three Mile Bay',
		'US1840005045' => 'Middle Island',
		'US1840033975' => 'Valhalla',
		'US1840004602' => 'Fillmore',
		'US1840004553' => 'Savona',
		'US1840004608' => 'Alfred',
		'US1840073682' => 'Glens Falls North',
		'US1840040223' => 'Fort Covington Hamlet',
		'US1840000443' => 'Corning',
		'US1840005097' => 'Shirley',
		'US1840026123' => 'Schroon Lake',
		'US1840004275' => 'Youngstown',
		'US1840023959' => 'Mineville',
		'US1840004740' => 'Brinckerhoff',
		'US1840004986' => 'Spring Valley',
		'US1840004386' => 'Kenmore',
		'US1840004117' => 'Theresa',
		'US1840004607' => 'Wellsville',
		'US1840004952' => 'Dobbs Ferry',
		'US1840004333' => 'Elbridge',
		'US1840004498' => 'Marathon',
		'US1840004471' => 'Warsaw',
		'US1840005257' => 'Garden City Park',
		'US1840004416' => 'Clifton Springs',
		'US1840004570' => 'Sherman',
		'US1840034002' => 'Queens',
		'US1840004554' => 'South Corning',
		'US1840004457' => 'Richfield Springs',
		'US1840004270' => 'Gasport',
		'US1840004460' => 'Cooperstown',
		'US1840004731' => 'New Paltz',
		'US1840005143' => 'Belle Terre',
		'US1840005037' => 'East Marion',
		'US1840004355' => 'Madison',
		'US1840004423' => 'Leicester',
		'US1840003087' => 'Troy',
		'US1840004951' => 'Croton-on-Hudson',
		'US1840034066' => 'West End',
		'US1840004544' => 'Lansing',
		'US1840004854' => 'Firthcliffe',
		'US1840004876' => 'Otisville',
		'US1840043236' => 'University at Buffalo',
		'US1840005241' => 'North Massapequa',
		'US1840132690' => 'Fairview',
		'US1840004917' => 'Crompond',
		'US1840004470' => 'Silver Springs',
		'US1840004747' => 'Staatsburg',
		'US1840004545' => 'Trumansburg',
		'US1840033996' => 'New Hempstead',
		'US1840005299' => 'Kings Point',
		'US1840034053' => 'Lorenz Park',
		'US1840004592' => 'Little Valley',
		'US1840004936' => 'Mount Kisco',
		'US1840025455' => 'Hall',
		'US1840004129' => 'Dexter',
		'US1840005121' => 'Lake Grove',
		'US1840005245' => 'North Wantagh',
		'US1840005261' => 'Greenvale',
		'US1840004871' => 'Highland Falls',
		'US1840004929' => 'Verplanck',
		'US1840005030' => 'Commack',
		'US1840004127' => 'Clayton',
		'US1840004253' => 'Waterford',
		'US1840004065' => 'Canton',
		'US1840004407' => 'St. Johnsville',
		'US1840005268' => 'Jericho',
		'US1840004873' => 'Maybrook',
		'US1840004428' => 'Avon',
		'US1840017087' => 'Winthrop',
		'US1840004659' => 'Lisle',
		'US1840025480' => 'Central Bridge',
		'US1840004318' => 'Westvale',
		'US1840004403' => 'Fultonville',
		'US1840004885' => 'Cornwall-on-Hudson',
		'US1840005058' => 'North Lindenhurst',
		'US1840004689' => 'Millport',
		'US1840005331' => 'Valley Stream',
		'US1840005024' => 'Calverton',
		'US1840005240' => 'North Bellmore',
		'US1840005266' => 'Hicksville',
		'US1840024076' => 'Lakeville',
		'US1840004992' => 'Chestnut Ridge',
		'US1840005055' => 'North Bay Shore',
		'US1840004540' => 'Forest Home',
		'US1840005247' => 'Old Bethpage',
		'US1840004631' => 'Philmont',
		'US1840005322' => 'Roslyn Estates',
		'US1840005339' => 'Cedarhurst',
		'US1840005246' => 'Oceanside',
		'US1840004942' => 'Rye Brook',
		'US1840043451' => 'Copake Hamlet',
		'US1840004560' => 'Canisteo',
		'US1840033999' => 'Bronx',
		'US1840004488' => 'Cobleskill',
		'US1840004151' => 'Mohawk',
		'US1840005284' => 'Woodmere',
		'US1840005277' => 'South Hempstead',
		'US1840005279' => 'Uniondale',
		'US1840026188' => 'Honeoye',
		'US1840040260' => 'Merritt Park',
		'US1840005341' => 'Cove Neck',
		'US1840004548' => 'Gang Mills',
		'US1840005307' => 'Massapequa Park',
		'US1840004946' => 'Tuckahoe',
		'US1840004122' => 'Black River',
		'US1840004931' => 'Harrison',
		'US1840005228' => 'Baldwin',
		'US1840005325' => 'Sands Point',
		'US1840005086' => 'Lake Ronkonkoma',
		'US1840033908' => 'Loch Sheldrake',
		'US1840005236' => 'East Meadow',
		'US1840004412' => 'Phelps',
		'US1840024103' => 'Freedom Plains',
		'US1840004246' => 'Cayuga',
		'US1840004624' => 'Delhi',
		'US1840004119' => 'Adams',
		'US1840004222' => 'Clayville',
		'US1840034000' => 'Manhattan',
		'US1840005285' => 'Farmingdale',
		'US1840004722' => 'Marlboro',
		'US1840004668' => 'Owego',
		'US1840034061' => 'Sand Ridge',
		'US1840000370' => 'Lockport',
		'US1840004396' => 'Blasdell',
		'US1840005251' => 'Point Lookout',
		'US1840005312' => 'Muttontown',
		'US1840004505' => 'Dresden',
		'US1840004109' => 'Great Bend',
		'US1840000460' => 'Binghamton',
		'US1840004053' => 'Star Lake',
		'US1840034039' => 'North Lynbrook',
		'US1840026208' => 'Glen Aubrey',
		'US1840034035' => 'Heritage Hills',
		'US1840004294' => 'Red Creek',
		'US1840004178' => 'Hudson Falls',
		'US1840004182' => 'Cambridge',
		'US1840005281' => 'Wantagh',
		'US1840005269' => 'Lakeview',
		'US1840004137' => 'Turin',
		'US1840004368' => 'Bergen',
		'US1840004241' => 'Port Byron',
		'US1840004115' => 'Philadelphia',
		'US1840004245' => 'Cato',
		'US1840005065' => 'Peconic',
		'US1840004630' => 'Kinderhook',
		'US1840005274' => 'Massapequa',
		'US1840004881' => 'Warwick',
		'US1840004944' => 'Sleepy Hollow',
		'US1840024027' => 'Chadwicks',
		'US1840005243' => 'North New Hyde Park',
		'US1840005008' => 'Elwood',
		'US1840004590' => 'Gowanda',
		'US1840005328' => 'Stewart Manor',
		'US1840004269' => 'Rapids',
		'US1840004611' => 'Angelica',
		'US1840004317' => 'Mattydale',
		'US1840026167' => 'North Rose',
		'US1840005142' => 'Babylon',
		'US1840004922' => 'Hawthorne',
		'US1840005271' => 'Lido Beach',
		'US1840023928' => 'Brasher Falls',
		'US1840005111' => 'West Islip',
		'US1840000386' => 'Buffalo',
		'US1840026166' => 'Pultneyville',
		'US1840004417' => 'Interlaken',
		'US1840004984' => 'Sloatsburg',
		'US1840004718' => 'Kerhonkson',
		'US1840004577' => 'Celoron',
		'US1840005099' => 'Sound Beach',
		'US1840004472' => 'Wyoming',
		'US1840005310' => 'Mineola',
		'US1840004670' => 'Waverly',
		'US1840004216' => 'Whitesboro',
		'US1840005335' => 'Atlantic Beach',
		'US1840004614' => 'Canaseraga',
		'US1840033857' => 'Bridgeport',
		'US1840004113' => 'Herrings',
		'US1840004651' => 'Coxsackie',
		'US1840035087' => 'Cortland West',
		'US1840004687' => 'West Elmira',
		'US1840005252' => 'Port Washington',
		'US1840023983' => 'Oxbow',
		'US1840004972' => 'Viola',
		'US1840005144' => 'Bellport',
		'US1840004107' => 'Natural Bridge',
		'US1840004208' => 'Oneida Castle',
		'US1840004315' => 'Galeville',
		'US1840025502' => 'Downsville',
		'US1840004991' => 'Airmont',
		'US1840004146' => 'Speculator',
		'US1840005294' => 'Hewlett Bay Park',
		'US1840000424' => 'Norwich',
		'US1840005114' => 'Wheatley Heights',
		'US1840040263' => 'York Hamlet',
		'US1840005074' => 'Greenlawn',
		'US1840004883' => 'Woodbury',
		'US1840004310' => 'Northville',
		'US1840034050' => 'Hampton Manor',
		'US1840004914' => 'Armonk',
		'US1840033874' => 'East Ithaca',
		'US1840000499' => 'Beacon',
		'US1840004271' => 'South Lockport',
		'US1840004859' => 'Orange Lake',
		'US1840004110' => 'La Fargeville',
		'US1840005093' => 'Selden',
		'US1840004571' => 'Silver Creek',
		'US1840004725' => 'Tillson',
		'US1840004044' => 'Champlain',
		'US1840005308' => 'Matinecock',
		'US1840000387' => 'Lackawanna',
		'US1840004276' => 'Barker',
		'US1840033988' => 'Keeseville',
		'US1840026200' => 'Sunset Bay',
		'US1840004377' => 'North Boston',
		'US1840004933' => 'Irvington',
		'US1840005096' => 'Shinnecock Hills',
		'US1840004325' => 'Minoa',
		'US1840005010' => 'Fire Island',
		'US1840005231' => 'Bellerose Terrace',
		'US1840004448' => 'Scotia',
		'US1840004490' => 'Green Island',
		'US1840004558' => 'Avoca',
		'US1840004397' => 'Depew',
		'US1840004328' => 'Solvay',
		'US1840004312' => 'Brewerton',
		'US1840005263' => 'Harbor Isle',
		'US1840000333' => 'Little Falls',
		'US1840004205' => 'Holland Patent',
		'US1840004644' => 'Jefferson Heights',
		'US1840004273' => 'Middleport',
		'US1840023984' => 'Pamelia Center',
		'US1840004369' => 'Corfu',
		'US1840005264' => 'Herricks',
		'US1840025472' => 'Strykersville',
		'US1840004658' => 'Johnson City',
		'US1840000350' => 'Sherrill',
		'US1840004864' => 'Walton Park',
		'US1840004210' => 'Oriskany Falls',
		'US1840000500' => 'Poughkeepsie',
		'US1840004435' => 'Wynantskill',
		'US1840004503' => 'Penn Yan',
		'US1840004561' => 'Cohocton',
		'US1840004272' => 'Lewiston',
		'US1840005119' => 'Huntington Bay',
		'US1840004596' => 'South Dayton',
		'US1840004181' => 'Argyle',
		'US1840004456' => 'Otego',
		'US1840000367' => 'Auburn',
		'US1840033907' => 'Limestone',
		'US1840004709' => 'Pine Hill',
		'US1840024108' => 'Hortonville',
		'US1840002495' => 'Watervliet',
		'US1840000453' => 'Salamanca',
		'US1840004647' => 'Hunter',
		'US1840005320' => 'Rockville Centre',
		'US1840004449' => 'Delanson',
		'US1840004510' => 'Oxford',
		'US1840004267' => 'Olcott',
		'US1840004067' => 'Malone',
		'US1840005317' => 'Oyster Bay Cove',
		'US1840005043' => 'Medford',
		'US1840005124' => 'Nissequogue',
		'US1840004311' => 'Broadalbin',
		'US1840004469' => 'Perry',
		'US1840004739' => 'Arlington',
		'US1840004565' => 'Forestville',
		'US1840005298' => 'Kensington',
		'US1840004491' => 'Menands',
		'US1840004980' => 'New Square',
		'US1840000782' => 'New Rochelle',
		'US1840005305' => 'Malverne',
		'US1840005303' => 'Lawrence',
		'US1840004724' => 'Stone Ridge',
		'US1840005333' => 'Williston Park',
		'US1840004330' => 'Baldwinsville',
		'US1840005278' => 'Syosset',
		'US1840005108' => 'Wainscott',
		'US1840004985' => 'South Nyack',
		'US1840004283' => 'Pittsford',
		'US1840004543' => 'Groton',
		'US1840004612' => 'Belmont',
		'US1840004071' => 'Burke',
		'US1840023978' => 'Belleville',
		'US1840004370' => 'Elba',
		'US1840005028' => 'Central Islip',
		'US1840024180' => 'Montrose',
		'US1840005050' => 'Napeague',
		'US1840004366' => 'Oakfield',
		'US1840034040' => 'Parc',
		'US1840005078' => 'Holbrook',
		'US1840005239' => 'New Cassel',
		'US1840005075' => 'Halesite',
		'US1840004321' => 'Jordan',
		'US1840024075' => 'Kysorville',
		'US1840004604' => 'Houghton',
		'US1840004485' => 'Richmondville',
		'US1840000394' => 'Rensselaer',
		'US1840024106' => 'Salt Point',
		'US1840026118' => 'West Chazy',
		'US1840005295' => 'Hewlett Harbor',
		'US1840023958' => 'Witherbee',
		'US1840004274' => 'Wilson',
		'US1840000373' => 'Rochester',
		'US1840004452' => 'Gilbertsville',
		'US1840004426' => 'Mount Morris',
		'US1840034030' => 'Brooklyn',
		'US1840005137' => 'Southampton',
		'US1840004248' => 'Galway',
		'US1840024072' => 'Greigsville',
		'US1840004360' => 'Cazenovia',
		'US1840003478' => 'Yonkers',
		'US1840004572' => 'Sinclairville',
		'US1840034031' => 'West Hills',
		'US1840004884' => 'Chester',
		'US1840004139' => 'Constableville',
		'US1840034060' => 'St. Bonaventure',
		'US1840034036' => 'Hillside',
		'US1840004789' => 'Jeffersonville',
		'US1840004563' => 'Frewsburg',
		'US1840004054' => 'Gouverneur',
		'US1840004783' => 'Narrowsburg',
		'US1840005112' => 'West Sayville',
		'US1840034027' => 'Bloomfield',
		'US1840004367' => 'Alexander',
		'US1840004207' => 'New York Mills',
		'US1840004150' => 'Middleville',
		'US1840004966' => 'Pearl River',
		'US1840004123' => 'Brownville',
		'US1840004296' => 'Sodus Point',
		'US1840005076' => 'Hampton Bays',
		'US1840000372' => 'North Tonawanda',
		'US1840004941' => 'Port Chester',
		'US1840004971' => 'Valley Cottage',
		'US1840025470' => 'Bliss',
		'US1840004357' => 'Munnsville',
		'US1840005049' => 'Mount Sinai',
		'US1840024086' => 'Woodsville',
		'US1840004671' => 'Candor',
		'US1840004705' => 'East Kingston',
		'US1840004882' => 'Washingtonville',
		'US1840005087' => 'Laurel',
		'US1840004927' => 'Shrub Oak',
		'US1840005088' => 'Manorville',
		'US1840004576' => 'Cassadaga',
		'US1840004454' => 'Milford',
		'US1840005340' => 'Centre Island',
		'US1840005012' => 'Flanders',
		'US1840004973' => 'West Nyack',
		'US1840004889' => 'Putnam Lake',
		'US1840004156' => 'Dolgeville',
		'US1840004613' => 'Bolivar',
		'US1840004556' => 'Addison',
		'US1840073681' => 'Oak Beach-Captree',
		'US1840026214' => 'Breesport',
		'US1840004070' => 'Brushton',
		'US1840073636' => 'Newfield Hamlet',
		'US1840004874' => 'Monroe',
		'US1840040221' => 'Conesus Hamlet',
		'US1840004601' => 'Ellicottville',
		'US1840004436' => 'Hoosick Falls',
		'US1840004384' => 'Farnham',
		'US1840005120' => 'Islandia',
		'US1840004791' => 'Monticello',
		'US1840004378' => 'Harris Hill',
		'US1840024069' => 'Dalton',
		'US1840023986' => 'Plessis',
		'US1840005130' => 'Poquott',
		'US1840004721' => 'Malden-on-Hudson',
		'US1840004504' => 'Rushville',
		'US1840004950' => 'Buchanan',
		'US1840005133' => 'Sag Harbor',
		'US1840004723' => 'Shokan',
		'US1840004555' => 'Wayland',
		'US1840024082' => 'South Lima',
		'US1840004660' => 'Port Dickinson',
		'US1840043282' => 'SUNY Oswego',
		'US1840024070' => 'East Avon',
		'US1840004605' => 'Stannards',
		'US1840004155' => 'Cold Brook',
		'US1840033934' => 'Plandome Heights',
		'US1840004752' => 'Red Hook',
		'US1840004665' => 'Apalachin',
		'US1840025495' => 'Kennedy',
		'US1840004719' => 'Lake Katrine',
		'US1840004499' => 'McGraw',
		'US1840005044' => 'Melville',
		'US1840004361' => 'Chittenango',
		'US1840004474' => 'Attica',
		'US1840034055' => 'Manhasset Hills',
		'US1840005040' => 'East Patchogue',
		'US1840034064' => 'Village Green',
		'US1840004784' => 'Rock Hill',
		'US1840024061' => 'Eggertsville',
		'US1840005297' => 'Island Park',
		'US1840000395' => 'Schenectady',
		'US1840004292' => 'Newark',
		'US1840005238' => 'Merrick',
		'US1840005081' => 'Huntington Station',
		'US1840034011' => 'Village of the Branch',
		'US1840000376' => 'Johnstown',
		'US1840004406' => 'Palatine Bridge',
		'US1840004948' => 'Briarcliff Manor',
		'US1840034045' => 'Cumberland Head',
		'US1840033866' => 'Copake Falls',
		'US1840005324' => 'Russell Gardens',
		'US1840004223' => 'Clinton',
		'US1840005132' => 'Quogue',
		'US1840004104' => 'Adams Center',
		'US1840034054' => 'Lyncourt',
		'US1840004319' => 'Fabius',
		'US1840024071' => 'Fowlerville',
		'US1840005036' => 'East Islip',
		'US1840004473' => 'Arcade',
		'US1840004062' => 'Rensselaer Falls',
		'US1840025500' => 'Bloomville',
		'US1840004126' => 'Chaumont',
		'US1840004289' => 'East Rochester',
		'US1840004550' => 'North Hornell',
		'US1840004399' => 'Tribes Hill',
		'US1840034033' => 'East Atlantic Beach',
		'US1840004869' => 'Greenwood Lake',
		'US1840004575' => 'Brocton',
		'US1840034062' => 'South Valley Stream',
		'US1840004251' => 'South Glens Falls',
		'US1840034047' => 'East Massapequa',
		'US1840004038' => 'Morrisonville',
		'US1840004962' => 'Mount Ivy',
		'US1840004175' => 'Fort Edward',
		'US1840033892' => 'Goldens Bridge',
		'US1840004326' => 'North Syracuse',
		'US1840025338' => 'Hailesboro',
		'US1840004468' => 'Gainesville',
		'US1840004708' => 'Phoenicia',
		'US1840004061' => 'Potsdam',
		'US1840004982' => 'Piermont',
		'US1840004285' => 'Spencerport',
		'US1840004792' => 'Woodridge',
		'US1840005126' => 'Northport',
		'US1840004264' => 'Medina',
		'US1840133415' => 'Greenville',
		'US1840004712' => 'Rifton',
		'US1840005091' => 'Mattituck',
		'US1840004154' => 'West Winfield',
		'US1840002200' => 'Watertown',
		'US1840005095' => 'Shelter Island Heights',
		'US1840004320' => 'Fayetteville',
		'US1840004987' => 'Suffern',
		'US1840004265' => 'Albion',
		'US1840005140' => 'Amityville',
		'US1840004513' => 'Afton',
		'US1840004206' => 'New Hartford',
		'US1840005071' => 'Ronkonkoma',
		'US1840004447' => 'Mariaville Lake',
		'US1840005017' => 'Bay Shore',
		'US1840004918' => 'Crugers',
		'US1840004402' => 'Fort Plain',
		'US1840004394' => 'Alden',
		'US1840004667' => 'Nichols',
		'US1840004138' => 'Castorland',
		'US1840005059' => 'North Patchogue',
		'US1840004389' => 'Orchard Park',
		'US1840004193' => 'Phoenix',
		'US1840004242' => 'Union Springs',
		'US1840024096' => 'Lime Lake',
		'US1840004140' => 'Copenhagen',
		'US1840004414' => 'Victor',
		'US1840004964' => 'New City',
		'US1840000297' => 'Ogdensburg',
		'US1840005262' => 'Harbor Hills',
		'US1840034046' => 'East Farmingdale',
		'US1840004487' => 'Sharon Springs',
		'US1840004323' => 'Manlius',
		'US1840004619' => 'Hobart',
		'US1840005315' => 'Old Brookville',
		'US1840005123' => 'Lloyd Harbor',
		'US1840003477' => 'White Plains',
		'US1840004926' => 'Shenorock',
		'US1840034037' => 'Malverne Park Oaks',
		'US1840004650' => 'Catskill',
		'US1840004857' => 'Mechanicstown',
		'US1840004424' => 'Lima',
		'US1840000454' => 'Hudson',
		'US1840005102' => 'Springs',
		'US1840005291' => 'Great Neck Estates',
		'US1840000368' => 'Mechanicville',
		'US1840004381' => 'Tonawanda',
		'US1840034032' => 'Staten Island',
		'US1840004969' => 'Tappan',
		'US1840004281' => 'Hilton',
		'US1840004089' => 'Lake Placid',
		'US1840004961' => 'Monsey',
		'US1840005056' => 'North Bellport',
		'US1840005127' => 'Ocean Beach',
		'US1840025337' => 'Cranberry Lake',
		'US1840000781' => 'Mount Vernon',
		'US1840004983' => 'Pomona',
		'US1840034063' => 'Spackenkill',
		'US1840004746' => 'Hopewell Junction',
		'US1840026173' => 'Caroga Lake',
		'US1840005147' => 'East Hampton',
		'US1840004621' => 'Sidney',
		'US1840004928' => 'Thornwood',
		'US1840005256' => 'Franklin Square',
		'US1840005062' => 'Noyack',
		'US1840004213' => 'Sylvan Beach',
		'US1840004868' => 'Goshen',
		'US1840004648' => 'Tannersville',
		'US1840004566' => 'Fredonia',
		'US1840005070' => 'Rocky Point',
		'US1840005311' => 'Munsey Park',
		'US1840004514' => 'Bainbridge',
		'US1840004583' => 'Montour Falls',
		'US1840004587' => 'Weston Mills',
		'US1840004629' => 'Stottville',
		'US1840024067' => 'Cumminsville',
		'US1840005300' => 'Lake Success',
		'US1840004599' => 'Delevan',
		'US1840004877' => 'South Blooming Grove',
		'US1840005118' => 'Head of the Harbor',
		'US1840024085' => 'Websters Crossing',
		'US1840004455' => 'Morris',
		'US1840004489' => 'Westmere',
		'US1840004374' => 'Billington Heights',
		'US1840004787' => 'Smallwood',
		'US1840005313' => 'New Hyde Park',
		'US1840000446' => 'Jamestown',
		'US1840004329' => 'Tully',
		'US1840004633' => 'Chatham',
		'US1840004421' => 'Waterloo',
		'US1840004892' => 'Nelsonville',
		'US1840004356' => 'Morrisville',
		'US1840004867' => 'Florida',
		'US1840005253' => 'Roosevelt',
		'US1840005085' => 'Kings Park',
		'US1840004190' => 'Lacona',
		'US1840004967' => 'Hillcrest',
		'US1840034057' => 'Northwest Harbor',
		'US1840004981' => 'Nyack',
		'US1840004586' => 'Burdett',
		'US1840034016' => 'New York',
		'US1840034068' => 'Taconic Shores',
		'US1840035216' => 'Saugerties South',
		'US1840043235' => 'Binghamton University',
		'US1840005092' => 'Sayville',
		'US1840004861' => 'Gardnertown',
		'US1840034019' => 'Hannawa Falls',
		'US1840004405' => 'Nelliston',
		'US1840034029' => 'West Hampton Dunes',
		'US1840024077' => 'Linwood',
		'US1840005332' => 'Westbury',
		'US1840004284' => 'Scottsville',
		'US1840004786' => 'Livingston Manor',
		'US1840004880' => 'Walden',
		'US1840005323' => 'Roslyn Harbor',
		'US1840004959' => 'Blauvelt',
		'US1840034028' => 'Baywood',
		'US1840000784' => 'Rye',
		'US1840005020' => 'Bohemia',
		'US1840005259' => 'Glen Head',
		'US1840004965' => 'Orangeburg',
		'US1840005109' => 'West Babylon',
		'US1840004453' => 'Laurens',
		'US1840005038' => 'East Moriches',
		'US1840004249' => 'Round Lake',
		'US1840004934' => 'Larchmont',
		'US1840004458' => 'Unadilla',
		'US1840000369' => 'Saratoga Springs',
		'US1840004410' => 'Manchester',
		'US1840073644' => 'Northwest Ithaca',
		'US1840004437' => 'Nassau',
		'US1840004118' => 'West Carthage',
		'US1840033957' => 'Searingtown',
		'US1840033970' => 'Thendara',
		'US1840005139' => 'Westhampton Beach',
		'US1840005343' => 'East Rockaway',
		'US1840004434' => 'West Sand Lake',
		'US1840004615' => 'Cuba',
		'US1840026204' => 'West Valley',
		'US1840004442' => 'Duane Lake',
		'US1840004128' => 'Deferiet',
		'US1840004645' => 'Leeds',
		'US1840005016' => 'Baiting Hollow',
		'US1840004714' => 'Glasco',
		'US1840004542' => 'Freeville',
		'US1840004610' => 'Andover',
		'US1840005327' => 'South Floral Park',
		'US1840004879' => 'Unionville',
		'US1840024179' => 'Katonah',
		'US1840004419' => 'Ovid',
		'US1840004147' => 'Frankfort',
		'US1840004506' => 'Dundee',
		'US1840004058' => 'Massena',
		'US1840004057' => 'Heuvelton',
		'US1840005021' => 'Brentwood',
		'US1840004726' => 'Walker Valley',
		'US1840004408' => 'Ames',
		'US1840004974' => 'Grand View-on-Hudson',
		'US1840004716' => 'Highland',
		'US1840005011' => 'Fishers Island',
		'US1840004120' => 'Alexandria Bay',
		'US1840004664' => 'Endicott',
		'US1840004451' => 'Schenevus',
		'US1840000385' => 'Batavia',
		'US1840000405' => 'Oneonta',
		'US1840004392' => 'Williamsville',
		'US1840004429' => 'Caledonia',
		'US1840005301' => 'Lattingtown',
		'US1840004398' => 'East Aurora',
		'US1840004484' => 'Middleburgh',
		'US1840004666' => 'Newark Valley',
		'US1840004411' => 'Naples',
		'US1840004324' => 'Marcellus',
		'US1840004492' => 'Ravena',
		'US1840004894' => 'Cold Spring',
		'US1840004385' => 'Hamburg',
		'US1840004497' => 'Homer',
		'US1840004211' => 'Prospect',
		'US1840005306' => 'Manorhaven',
		'US1840004483' => 'Esperance',
		'US1840005288' => 'Freeport',
		'US1840005289' => 'Garden City',
		'US1840004493' => 'Voorheesville',
		'US1840004620' => 'Margaretville',
		'US1840005067' => 'Quiogue',
		'US1840073640' => 'North Ballston Spa',
		'US1840004400' => 'Fonda',
		'US1840004359' => 'Canastota',
		'US1840004568' => 'Mayville',
		'US1840005260' => 'Glenwood Landing',
		'US1840000375' => 'Gloversville',
		'US1840005342' => 'East Hills',
		'US1840004293' => 'Palmyra',
		'US1840005336' => 'Bayville',
		'US1840002746' => 'Utica',
		'US1840004878' => 'Tuxedo Park',
		'US1840034034' => 'Great Neck Gardens',
		'US1840004872' => 'Kiryas Joel',
		'US1840004597' => 'Allegany',
		'US1840000384' => 'Oneida',
		'US1840004185' => 'Lake George',
		'US1840004354' => 'Hamilton',
		'US1840005090' => 'Mastic',
		'US1840073699' => 'Jefferson Valley-Yorktown',
		'US1840004422' => 'Geneseo',
		'US1840004940' => 'Pleasantville',
		'US1840004298' => 'Clyde',
		'US1840004552' => 'Riverside',
		'US1840005015' => 'Aquebogue',
		'US1840004891' => 'Mahopac',
		'US1840000444' => 'Hornell',
		'US1840073658' => 'Preston-Potter Hollow',
		'US1840004963' => 'Nanuet',
		'US1840004661' => 'Whitney Point',
		'US1840026151' => 'Durhamville',
		'US1840005330' => 'Upper Brookville',
		'US1840004707' => 'Napanoch',
		'US1840004136' => 'Port Leyden',
		'US1840004692' => 'Elmira Heights',
		'US1840005046' => 'Miller Place',
		'US1840004198' => 'Cleveland',
		'US1840004404' => 'Hagaman',
		'US1840005326' => 'Sea Cliff',
		'US1840004262' => 'Holley',
		'US1840004243' => 'Weedsport',
		'US1840004486' => 'Schoharie',
		'US1840004625' => 'Copake Lake',
		'US1840004111' => 'Evans Mills',
		'US1840004268' => 'Ransomville',
		'US1840004970' => 'Thiells',
		'US1840000442' => 'Ithaca',
		'US1840004749' => 'Millbrook',
		'US1840033846' => 'Baxter Estates',
		'US1840005337' => 'Bellerose',
		'US1840005113' => 'Westhampton',
		'US1840004380' => 'Lake Erie Beach',
		'US1840004688' => 'Horseheads',
		'US1840000392' => 'Canandaigua',
		'US1840005237' => 'East Norwich',
		'US1840004221' => 'Camden',
		'US1840005068' => 'Ridge',
		'US1840005292' => 'Great Neck Plaza',
		'US1840033935' => 'Plandome Manor',
		'US1840004391' => 'Springville',
		'US1840005131' => 'Port Jefferson',
		'US1840004125' => 'Carthage',
		'US1840026299' => 'Mountain Lodge Park',
		'US1840005027' => 'Centerport',
		'US1840005072' => 'Gordon Heights',
		'US1840004958' => 'Bardonia',
		'US1840004072' => 'Chateaugay',
		'US1840026144' => 'Pottersville',
		'US1840004921' => 'Hartsdale',
		'US1840000493' => 'Kingston',
		'US1840004748' => 'Fishkill',
		'US1840004932' => 'Hastings-on-Hudson',
		'US1840004431' => 'Averill Park',
		'US1840034043' => 'Country Knolls',
		'US1840005115' => 'Wyandanch',
		'US1840005227' => 'Albertson',
		'US1840004114' => 'Mannsville',
		'US1840004715' => 'High Falls',
		'US1840004945' => 'Tarrytown',
		'US1840005334' => 'Woodsburgh',
		'US1840004316' => 'Lakeland',
		'US1840005018' => 'Bayport',
		'US1840004606' => 'Richburg',
		'US1840004573' => 'Westfield',
		'US1840004924' => 'Lincolndale',
	],
	'PA' => [
		'US1840043360' => 'Cheyney University',
		'US1840003696' => 'Collegeville',
		'US1840026363' => 'Saylorsburg',
		'US1840001050' => 'Macungie',
		'US1840035023' => 'Houserville',
		'US1840001235' => 'Green Tree',
		'US1840035453' => 'Toftrees',
		'US1840001423' => 'Avondale',
		'US1840001232' => 'Forest Hills',
		'US1840003499' => 'Mahaffey',
		'US1840000578' => 'Meshoppen',
		'US1840001500' => 'Brownsville',
		'US1840026296' => 'Chinchilla',
		'US1840005485' => 'New Kingstown',
		'US1840002782' => 'Tremont',
		'US1840003469' => 'Brookville',
		'US1840024264' => 'Granville',
		'US1840001426' => 'Elverson',
		'US1840001170' => 'Bechtelsville',
		'US1840024346' => 'Stevens',
		'US1840000811' => 'Bloomsburg',
		'US1840003457' => 'Hawthorn',
		'US1840000627' => 'Matamoras',
		'US1840000760' => 'Luzerne',
		'US1840003593' => 'McVeytown',
		'US1840004695' => 'Avonia',
		'US1840003468' => 'Brockway',
		'US1840000853' => 'Watsontown',
		'US1840001172' => 'Birdsboro',
		'US1840000669' => 'Smithfield',
		'US1840005155' => 'Clarence',
		'US1840003484' => 'Berwick',
		'US1840024334' => 'Fivepointville',
		'US1840001258' => 'Rosslyn Farms',
		'US1840003628' => 'Delmont',
		'US1840001132' => 'Lower Burrell',
		'US1840034974' => 'Foundryville',
		'US1840003462' => 'Shippenville',
		'US1840004807' => 'Geneva',
		'US1840001430' => 'Modena',
		'US1840001278' => 'Wilkinsburg',
		'US1840001051' => 'Slatington',
		'US1840004811' => 'Lincolnville',
		'US1840001312' => 'Riegelsville',
		'US1840000751' => 'Freeland',
		'US1840001264' => 'Swissvale',
		'US1840001026' => 'New Brighton',
		'US1840024268' => 'Siglerville',
		'US1840001193' => 'Wernersville',
		'US1840035451' => 'Wallenpaupack Lake Estates',
		'US1840000523' => 'Bradford',
		'US1840002796' => 'Freeburg',
		'US1840026448' => 'Hereford',
		'US1840001199' => 'Aspinwall',
		'US1840000995' => 'Glen Campbell',
		'US1840035428' => 'Lower Allen',
		'US1840035279' => 'Churchville',
		'US1840026304' => 'Kersey',
		'US1840001166' => 'Youngstown',
		'US1840001138' => 'Hunker',
		'US1840001024' => 'Glasgow',
		'US1840026319' => 'Lamar',
		'US1840026524' => 'Defiance',
		'US1840003522' => 'North Apollo',
		'US1840003594' => 'Newton Hamilton',
		'US1840034845' => 'Ancient Oaks',
		'US1840001448' => 'Goldsboro',
		'US1840003440' => 'Sandy Lake',
		'US1840003446' => 'Wheatland',
		'US1840026435' => 'Calumet',
		'US1840005486' => 'Plainfield',
		'US1840035235' => 'Shanor-Northvue',
		'US1840035148' => 'Pennville',
		'US1840026437' => 'North Vandergrift',
		'US1840000691' => 'Chester Heights',
		'US1840026402' => 'Graceton',
		'US1840003701' => 'Hatfield',
		'US1840000866' => 'Harmony',
		'US1840001188' => 'Shillington',
		'US1840073727' => 'Village Green-Green Ridge',
		'US1840001063' => 'Birmingham',
		'US1840026312' => 'Masthope',
		'US1840001290' => 'Hummelstown',
		'US1840001424' => 'Coatesville',
		'US1840001249' => 'Oakdale',
		'US1840026593' => 'Wind Ridge',
		'US1840001282' => 'Lykens',
		'US1840000969' => 'East Bangor',
		'US1840026327' => 'Crown',
		'US1840001080' => 'Altoona',
		'US1840035458' => 'Greenfields',
		'US1840005173' => 'Pocono Pines',
		'US1840026234' => 'Millerton',
		'US1840026373' => 'Kiskimere',
		'US1840001150' => 'New Florence',
		'US1840035431' => 'Nixon',
		'US1840024314' => 'Southview',
		'US1840024335' => 'Goodville',
		'US1840000522' => 'Wyalusing',
		'US1840001300' => 'Duncannon',
		'US1840005172' => 'Mountainhome',
		'US1840043365' => 'Haverford College',
		'US1840001077' => 'Shade Gap',
		'US1840005371' => 'Highland Park',
		'US1840003302' => 'Roseville',
		'US1840035037' => 'Kapp Heights',
		'US1840034928' => 'Devon',
		'US1840035029' => 'Inkerman',
		'US1840001379' => 'Trappe',
		'US1840000757' => 'Laflin',
		'US1840000977' => 'Pen Argyl',
		'US1840003623' => 'Adamsburg',
		'US1840000511' => 'Burlington',
		'US1840003670' => 'West Middletown',
		'US1840005217' => 'Klingerstown',
		'US1840000744' => 'Courtdale',
		'US1840001389' => 'Mount Holly Springs',
		'US1840035222' => 'Telford',
		'US1840001028' => 'Ohioville',
		'US1840001243' => 'McKeesport',
		'US1840000672' => 'Vanderbilt',
		'US1840003730' => 'Benson',
		'US1840005363' => 'Port Trevorton',
		'US1840035143' => 'Park Forest Village',
		'US1840000846' => 'Mount Carmel',
		'US1840035437' => 'Rutherford',
		'US1840000822' => 'Bellefonte',
		'US1840026434' => 'Webster',
		'US1840026305' => 'Weedville',
		'US1840043363' => 'Messiah College',
		'US1840001375' => 'Rockledge',
		'US1840000989' => 'Armagh',
		'US1840073600' => 'Brittany Farms-The Highlands',
		'US1840026430' => 'Hostetter',
		'US1840026472' => 'Clinton',
		'US1840001211' => 'Bradford Woods',
		'US1840003447' => 'Avis',
		'US1840001464' => 'Spring Grove',
		'US1840003711' => 'Akron',
		'US1840003667' => 'Twilight',
		'US1840024311' => 'Hickory',
		'US1840003722' => 'Millersville',
		'US1840005005' => 'Slabtown',
		'US1840133638' => 'Marshallton',
		'US1840000766' => 'Pittston',
		'US1840024143' => 'Hannasville',
		'US1840043344' => 'Pocono Woodland Lakes',
		'US1840001247' => 'Munhall',
		'US1840004796' => 'Sheffield',
		'US1840001459' => 'North York',
		'US1840001102' => 'Carrolltown',
		'US1840002761' => 'Gordon',
		'US1840001184' => 'Mount Penn',
		'US1840001260' => 'Sewickley Heights',
		'US1840026508' => 'West Alexander',
		'US1840026330' => 'Vowinckel',
		'US1840000872' => 'Prospect',
		'US1840003700' => 'Hatboro',
		'US1840000667' => 'Perryopolis',
		'US1840000677' => 'Bendersville',
		'US1840001303' => 'Marysville',
		'US1840002797' => 'McClure',
		'US1840001144' => 'Madison',
		'US1840035270' => 'Wyncote',
		'US1840035271' => 'Wyndmoor',
		'US1840003331' => 'Bear Lake',
		'US1840001408' => 'Woodbury',
		'US1840026500' => 'Eighty Four',
		'US1840024340' => 'Landisville',
		'US1840001086' => 'Roaring Spring',
		'US1840000474' => 'Corry',
		'US1840003619' => 'Mifflin',
		'US1840026321' => 'Rauchtown',
		'US1840034953' => 'Espy',
		'US1840001071' => 'Mill Creek',
		'US1840000678' => 'Biglerville',
		'US1840000769' => 'Shickshinny',
		'US1840000753' => 'Hazleton',
		'US1840003721' => 'Marietta',
		'US1840003506' => 'Westover',
		'US1840035022' => 'Horsham',
		'US1840026379' => 'New Bedford',
		'US1840001387' => 'Lemoyne',
		'US1840001011' => 'Baden',
		'US1840035206' => 'Springmont',
		'US1840026526' => 'Earlston',
		'US1840001210' => 'Braddock Hills',
		'US1840002759' => 'Gilberton',
		'US1840005549' => 'Broomall',
		'US1840000625' => 'Driftwood',
		'US1840001021' => 'Frankfort Springs',
		'US1840035443' => 'Whitfield',
		'US1840005170' => 'Zion',
		'US1840001111' => 'Ferndale',
		'US1840003520' => 'Leechburg',
		'US1840034906' => 'Clay',
		'US1840001347' => 'Lebanon',
		'US1840073660' => 'Pymatuning South',
		'US1840005361' => 'Paxtonville',
		'US1840005187' => 'Tresckow',
		'US1840003586' => 'Industry',
		'US1840003647' => 'Coal Center',
		'US1840024284' => 'St. Michael',
		'US1840005497' => 'Davidsville',
		'US1840005493' => 'Maytown',
		'US1840000693' => 'Collingdale',
		'US1840003472' => 'Reynoldsville',
		'US1840040532' => 'Tyler Run',
		'US1840026424' => 'Dunlo',
		'US1840000852' => 'Turbotville',
		'US1840003389' => 'Scranton',
		'US1840035417' => 'Wilburton Number Two',
		'US1840001401' => 'Manns Choice',
		'US1840001123' => 'Sankertown',
		'US1840003508' => 'Mount Pocono',
		'US1840000876' => 'West Liberty',
		'US1840001349' => 'Myerstown',
		'US1840000701' => 'Marcus Hook',
		'US1840003653' => 'Elco',
		'US1840005559' => 'Nemacolin',
		'US1840003739' => 'Jennerstown',
		'US1840034876' => 'Brickerville',
		'US1840024352' => 'Stonybrook',
		'US1840034965' => 'Fernville',
		'US1840003473' => 'Summerville',
		'US1840000842' => 'Kulpmont',
		'US1840035320' => 'Upper Exeter',
		'US1840001078' => 'Shirleysburg',
		'US1840005489' => 'Rheems',
		'US1840035340' => 'Flora Dale',
		'US1840034945' => 'Eddington',
		'US1840001149' => 'New Alexandria',
		'US1840035094' => 'McKean',
		'US1840000742' => 'Avoca',
		'US1840000764' => 'Nuangola',
		'US1840005492' => 'Leola',
		'US1840001438' => 'Cross Roads',
		'US1840005504' => 'Thorndale',
		'US1840024197' => 'South Philipsburg',
		'US1840026470' => 'Bakerstown',
		'US1840002765' => 'Middleport',
		'US1840003666' => 'Stockdale',
		'US1840026534' => 'State Line',
		'US1840035032' => 'Jamison City',
		'US1840035448' => 'Eagle Lake',
		'US1840003571' => 'New Beaver',
		'US1840026583' => 'Gardners',
		'US1840001146' => 'Monessen',
		'US1840001372' => 'Pennsburg',
		'US1840000741' => 'Ashley',
		'US1840001380' => 'West Conshohocken',
		'US1840035306' => 'Smoketown',
		'US1840005368' => 'Belleville',
		'US1840001294' => 'Penbrook',
		'US1840001183' => 'Mohnton',
		'US1840026570' => 'Lemont Furnace',
		'US1840004906' => 'Castanea',
		'US1840001106' => 'Daisytown',
		'US1840003505' => 'Wallaceton',
		'US1840003448' => 'Beech Creek',
		'US1840003304' => 'Wellsboro',
		'US1840000685' => 'McSherrystown',
		'US1840003735' => 'Confluence',
		'US1840026594' => 'Mount Morris',
		'US1840035384' => 'Towamensing Trails',
		'US1840034962' => 'Farmersville',
		'US1840003374' => 'Archbald',
		'US1840001239' => 'Ingram',
		'US1840001105' => 'Cresson',
		'US1840005397' => 'Upper St. Clair',
		'US1840000694' => 'Colwyn',
		'US1840000482' => 'Mill Village',
		'US1840024289' => 'East Salem',
		'US1840004994' => 'Aristes',
		'US1840024262' => 'Allensville',
		'US1840003521' => 'Manorville',
		'US1840001081' => 'Bellwood',
		'US1840034921' => 'Cumbola',
		'US1840026471' => 'Boston',
		'US1840000483' => 'North East',
		'US1840026338' => 'Crenshaw',
		'US1840026374' => 'Templeton',
		'US1840034897' => 'Chase',
		'US1840000681' => 'East Berlin',
		'US1840003376' => 'Carbondale',
		'US1840035435' => 'Pottsgrove',
		'US1840035387' => 'Hickory Hills',
		'US1840002771' => 'Palo Alto',
		'US1840005169' => 'Woodward',
		'US1840003727' => 'Strasburg',
		'US1840003716' => 'Elizabethtown',
		'US1840000580' => 'Tunkhannock',
		'US1840003303' => 'Tioga',
		'US1840002766' => 'Minersville',
		'US1840001410' => 'Chambersburg',
		'US1840026559' => 'Arnold City',
		'US1840000779' => 'Yatesville',
		'US1840000971' => 'Freemansburg',
		'US1840000856' => 'Bruin',
		'US1840000479' => 'Girard',
		'US1840005178' => 'Trevorton',
		'US1840005152' => 'Aaronsburg',
		'US1840005392' => 'Temple',
		'US1840005466' => 'Skippack',
		'US1840001240' => 'Leetsdale',
		'US1840003748' => 'Stoystown',
		'US1840026591' => 'Rogersville',
		'US1840026577' => 'Cashtown',
		'US1840005216' => 'Hometown',
		'US1840026489' => 'Spinnerstown',
		'US1840001159' => 'Smithton',
		'US1840005388' => 'Herminie',
		'US1840035123' => 'New Castle Northwest',
		'US1840004803' => 'Atlantic',
		'US1840003592' => 'Lewistown',
		'US1840035438' => 'Schlusser',
		'US1840001316' => 'Tullytown',
		'US1840035061' => 'Lime Ridge',
		'US1840000683' => 'Gettysburg',
		'US1840000991' => 'Cherry Tree',
		'US1840002779' => 'Shenandoah',
		'US1840001179' => 'Laureldale',
		'US1840001208' => 'Brackenridge',
		'US1840001442' => 'Dover',
		'US1840026580' => 'Heidlersburg',
		'US1840003491' => 'Coalport',
		'US1840005547' => 'Hampton',
		'US1840035303' => 'West Hamburg',
		'US1840035457' => 'Colony Park',
		'US1840005457' => 'Montgomeryville',
		'US1840001267' => 'Turtle Creek',
		'US1840005546' => 'Orrtanna',
		'US1840001181' => 'Lenhartsville',
		'US1840001046' => 'Coopersburg',
		'US1840005150' => 'Hyde',
		'US1840034942' => 'East Waterford',
		'US1840003587' => 'Koppel',
		'US1840001234' => 'Glenfield',
		'US1840034874' => 'Branchdale',
		'US1840005158' => 'North Philipsburg',
		'US1840001213' => 'Bridgeville',
		'US1840001169' => 'Bally',
		'US1840001122' => 'Portage',
		'US1840002757' => 'Deer Lake',
		'US1840003657' => 'Houston',
		'US1840000658' => 'Fredonia',
		'US1840003638' => 'Allenport',
		'US1840000563' => 'Townville',
		'US1840035175' => 'Ronks',
		'US1840000863' => 'Eau Claire',
		'US1840003334' => 'Warren',
		'US1840001087' => 'Tyrone',
		'US1840001308' => 'Penndel',
		'US1840001288' => 'Harrisburg',
		'US1840004907' => 'Dunnstown',
		'US1840001010' => 'Ambridge',
		'US1840026431' => 'Millwood',
		'US1840001498' => 'McConnellsburg',
		'US1840005406' => 'Croydon',
		'US1840000734' => 'Jamestown',
		'US1840035156' => 'Pleasant View',
		'US1840003698' => 'East Greenville',
		'US1840003297' => 'Elkland',
		'US1840073659' => 'Pymatuning North',
		'US1840001266' => 'Thornburg',
		'US1840003441' => 'Sharon',
		'US1840002800' => 'Shamokin Dam',
		'US1840000777' => 'Wilkes-Barre',
		'US1840005471' => 'Willow Grove',
		'US1840003747' => 'Somerset',
		'US1840026237' => 'Roulette',
		'US1840035099' => 'Milford Square',
		'US1840000517' => 'Sayre',
		'US1840001473' => 'Yorkana',
		'US1840001145' => 'Manor',
		'US1840035153' => 'Pleasant Hill',
		'US1840003639' => 'Beallsville',
		'US1840001207' => 'Blawnox',
		'US1840000815' => 'Orangeville',
		'US1840003649' => 'Deemston',
		'US1840001457' => 'New Freedom',
		'US1840001344' => 'Cleona',
		'US1840002758' => 'Frackville',
		'US1840003751' => 'Windber',
		'US1840000632' => 'Montoursville',
		'US1840000831' => 'Unionville',
		'US1840043391' => 'Arcadia University',
		'US1840001437' => 'West Grove',
		'US1840001139' => 'Hyde Park',
		'US1840000850' => 'Snydertown',
		'US1840001318' => 'Bristol',
		'US1840035052' => 'Lavelle',
		'US1840026459' => 'Alsace Manor',
		'US1840026501' => 'Joffre',
		'US1840003390' => 'Taylor',
		'US1840003327' => 'Oakland',
		'US1840001126' => 'Southmont',
		'US1840001376' => 'Royersford',
		'US1840003588' => 'Midland',
		'US1840003504' => 'Troutville',
		'US1840035283' => 'Faxon',
		'US1840003310' => 'Shinglehouse',
		'US1840005394' => 'Curtisville',
		'US1840040467' => 'Cedar Crest',
		'US1840003715' => 'East Petersburg',
		'US1840003336' => 'Tidioute',
		'US1840003387' => 'Old Forge',
		'US1840003713' => 'Columbia',
		'US1840001085' => 'Newry',
		'US1840035195' => 'Shiloh',
		'US1840001167' => 'Youngwood',
		'US1840001137' => 'Greensburg',
		'US1840000560' => 'Spartansburg',
		'US1840004911' => 'Mountain Top',
		'US1840026410' => 'Trexlertown',
		'US1840005207' => 'Brandonville',
		'US1840003332' => 'Clarendon',
		'US1840003471' => 'Punxsutawney',
		'US1840000634' => 'Picture Rocks',
		'US1840002781' => 'Tower City',
		'US1840001286' => 'Gratz',
		'US1840001329' => 'Newtown',
		'US1840001393' => 'Shiremanstown',
		'US1840001385' => 'Camp Hill',
		'US1840000993' => 'Creekside',
		'US1840002764' => 'Mechanicsville',
		'US1840003314' => 'Honesdale',
		'US1840005209' => 'McKeansburg',
		'US1840001223' => 'Dravosburg',
		'US1840000756' => 'Kingston',
		'US1840026333' => 'Weston',
		'US1840001350' => 'Palmyra',
		'US1840001161' => 'Southwest Greensburg',
		'US1840024338' => 'Kirkwood',
		'US1840003325' => 'Montrose',
		'US1840026592' => 'West Waynesburg',
		'US1840005367' => 'Troxelville',
		'US1840026337' => 'West Nanticoke',
		'US1840000619' => 'Tionesta',
		'US1840003702' => 'Jenkintown',
		'US1840001307' => 'Fairless Hills',
		'US1840034881' => 'Buck Run',
		'US1840001276' => 'Whitehall',
		'US1840003726' => 'Quarryville',
		'US1840035430' => 'Newtown Grant',
		'US1840035445' => 'Fox Chase',
		'US1840003659' => 'Marianna',
		'US1840035378' => 'Marianne',
		'US1840000997' => 'Indiana',
		'US1840003704' => 'Narberth',
		'US1840003719' => 'Lititz',
		'US1840026589' => 'Mather',
		'US1840003488' => 'Burnside',
		'US1840000813' => 'Centralia',
		'US1840003492' => 'Curwensville',
		'US1840005398' => 'Colonial Park',
		'US1840000513' => 'Le Raysville',
		'US1840000666' => 'Ohiopyle',
		'US1840001173' => 'Boyertown',
		'US1840003714' => 'Denver',
		'US1840001164' => 'West Leechburg',
		'US1840026394' => 'Martins Creek',
		'US1840035112' => 'Mount Gretna Heights',
		'US1840001451' => 'Jacobus',
		'US1840003589' => 'Burnham',
		'US1840003533' => 'New Berlin',
		'US1840035364' => 'Swartzville',
		'US1840035432' => 'Oak Hills',
		'US1840001346' => 'Jonestown',
		'US1840001163' => 'Vandergrift',
		'US1840026588' => 'Mapletown',
		'US1840005460' => 'Fort Washington',
		'US1840005483' => 'Enola',
		'US1840001271' => 'West Elizabeth',
		'US1840005505' => 'Toughkenamon',
		'US1840005349' => 'Dicksonville',
		'US1840035191' => 'Seltzer',
		'US1840024267' => 'Mattawana',
		'US1840002776' => 'Ringtown',
		'US1840001205' => 'Ben Avon Heights',
		'US1840000630' => 'Jersey Shore',
		'US1840035213' => 'Strodes Mills',
		'US1840003316' => 'Starrucca',
		'US1840003384' => 'Mayfield',
		'US1840005459' => 'Plymouth Meeting',
		'US1840024310' => 'Hendersonville',
		'US1840001463' => 'Shrewsbury',
		'US1840001171' => 'Bernville',
		'US1840001411' => 'Greencastle',
		'US1840026329' => 'Tylersburg',
		'US1840000746' => 'Dupont',
		'US1840000883' => 'Applewold',
		'US1840026361' => 'West Decatur',
		'US1840001320' => 'Doylestown',
		'US1840035091' => 'Meadowlands',
		'US1840024333' => 'Falmouth',
		'US1840026415' => 'Grazierville',
		'US1840000626' => 'Emporium',
		'US1840034894' => 'Cementon',
		'US1840000526' => 'Lewis Run',
		'US1840005214' => 'Friedensburg',
		'US1840000747' => 'Duryea',
		'US1840035115' => 'Muir',
		'US1840003645' => 'Charleroi',
		'US1840035383' => 'Lake Wynonah',
		'US1840000484' => 'Platea',
		'US1840001398' => 'Everett',
		'US1840005429' => 'Quentin',
		'US1840026436' => 'Loyalhanna',
		'US1840001371' => 'North Wales',
		'US1840001025' => 'Monaca',
		'US1840001421' => 'Exton',
		'US1840026467' => 'Gibsonia',
		'US1840001453' => 'Lewisberry',
		'US1840026413' => 'Lakemont',
		'US1840003461' => 'St. Petersburg',
		'US1840005380' => 'Salix',
		'US1840035280' => 'Dryville',
		'US1840000565' => 'Woodcock',
		'US1840000738' => 'Callensburg',
		'US1840000562' => 'Titusville',
		'US1840026241' => 'Columbus',
		'US1840000843' => 'McEwensville',
		'US1840026401' => 'Coral',
		'US1840035111' => 'Mount Eagle',
		'US1840001422' => 'Atglen',
		'US1840001135' => 'East Vandergrift',
		'US1840001256' => 'Port Vue',
		'US1840003460' => 'Rimersburg',
		'US1840035121' => 'New Berlinville',
		'US1840000767' => 'Plymouth',
		'US1840003621' => 'Port Royal',
		'US1840000715' => 'Yeadon',
		'US1840000579' => 'Nicholson',
		'US1840001203' => 'Bellevue',
		'US1840001108' => 'East Conemaugh',
		'US1840026315' => 'Lake Latonka',
		'US1840000981' => 'Tatamy',
		'US1840003426' => 'Oil City',
		'US1840001230' => 'Emsworth',
		'US1840003379' => 'Dalton',
		'US1840001413' => 'Mont Alto',
		'US1840035414' => 'Renningers',
		'US1840035396' => 'New Market',
		'US1840001455' => 'Manchester',
		'US1840026586' => 'Brave',
		'US1840034979' => 'Garden View',
		'US1840026451' => 'Morgantown',
		'US1840003425' => 'Franklin',
		'US1840001295' => 'Pillow',
		'US1840024212' => 'Vicksburg',
		'US1840002790' => 'Smicksburg',
		'US1840003301' => 'Mansfield',
		'US1840002787' => 'Plumville',
		'US1840003669' => 'West Brownsville',
		'US1840001225' => 'East McKeesport',
		'US1840001351' => 'Richland',
		'US1840003724' => 'Mountville',
		'US1840066074' => 'Economy',
		'US1840001140' => 'Irwin',
		'US1840001315' => 'Trumbauersville',
		'US1840003444' => 'Stoneboro',
		'US1840005381' => 'Spring Hill',
		'US1840000657' => 'Farrell',
		'US1840035399' => 'Union Deposit',
		'US1840026446' => 'Douglassville',
		'US1840001101' => 'Brownstown',
		'US1840035253' => 'West Lawn',
		'US1840003737' => 'Hooversville',
		'US1840000525' => 'Kane',
		'US1840000829' => 'Snow Shoe',
		'US1840003497' => 'Irvona',
		'US1840003516' => 'Ford City',
		'US1840005366' => 'Kreamer',
		'US1840000739' => 'Clarion',
		'US1840003734' => 'Central City',
		'US1840000520' => 'Towanda',
		'US1840035187' => 'Sand Hill',
		'US1840035051' => 'Laurys Station',
		'US1840001254' => 'Pittsburgh',
		'US1840001345' => 'Cornwall',
		'US1840001153' => 'North Belle Vernon',
		'US1840003585' => 'Hookstown',
		'US1840026416' => 'Greenwood',
		'US1840001219' => 'Clairton',
		'US1840001221' => 'Crafton',
		'US1840005161' => 'Pleasant Gap',
		'US1840001468' => 'Windsor',
		'US1840005462' => 'Glenside',
		'US1840001257' => 'Rankin',
		'US1840002770' => 'Orwigsburg',
		'US1840003640' => 'Bentleyville',
		'US1840000776' => 'White Haven',
		'US1840003382' => 'Jermyn',
		'US1840003329' => 'Thompson',
		'US1840000475' => 'Cranesville',
		'US1840000865' => 'Fairview',
		'US1840003494' => 'Glen Hope',
		'US1840003459' => 'New Bethlehem',
		'US1840066072' => 'Glen Osborne',
		'US1840001016' => 'Darlington',
		'US1840035449' => 'Big Bass Lake',
		'US1840035013' => 'Herndon',
		'US1840026571' => 'Ronco',
		'US1840035322' => 'Wiconsico',
		'US1840026316' => 'Reynolds Heights',
		'US1840005000' => 'Iola',
		'US1840005540' => 'Oliver',
		'US1840024309' => 'Elrama',
		'US1840001283' => 'Berrysburg',
		'US1840000664' => 'Masontown',
		'US1840003296' => 'Blossburg',
		'US1840024285' => 'Sidman',
		'US1840026302' => 'Force',
		'US1840035004' => 'Harleigh',
		'US1840024345' => 'Schoeneck',
		'US1840003566' => 'Summit Hill',
		'US1840001070' => 'Marklesburg',
		'US1840001400' => 'Hyndman',
		'US1840001012' => 'Beaver',
		'US1840024348' => 'Washington Boro',
		'US1840000702' => 'Media',
		'US1840001289' => 'Highspire',
		'US1840001292' => 'Millersburg',
		'US1840035197' => 'Skyline View',
		'US1840026488' => 'Plumsteadville',
		'US1840001404' => 'Rainsburg',
		'US1840000629' => 'Hughesville',
		'US1840005541' => 'Republic',
		'US1840003443' => 'Sheakleyville',
		'US1840073686' => 'Guilford',
		'US1840035264' => 'Witmer',
		'US1840003489' => 'Chester Hill',
		'US1840024120' => 'North Warren',
		'US1840005370' => 'Reedsville',
		'US1840001444' => 'Fawn Grove',
		'US1840000617' => 'Ridgway',
		'US1840035301' => 'Yorklyn',
		'US1840003656' => 'Green Hills',
		'US1840001296' => 'Royalton',
		'US1840000875' => 'Valencia',
		'US1840003423' => 'Clintonville',
		'US1840026439' => 'Collinsburg',
		'US1840001471' => 'Yoe',
		'US1840026466' => 'Walnuttown',
		'US1840073707' => 'Lynnwood-Pricedale',
		'US1840024266' => 'Maitland',
		'US1840001501' => 'Connellsville',
		'US1840026535' => 'Cairnbrook',
		'US1840000620' => 'Emlenton',
		'US1840026301' => 'Byrnedale',
		'US1840002773' => 'Port Carbon',
		'US1840000778' => 'Wyoming',
		'US1840001298' => 'Williamstown',
		'US1840026298' => 'Waverly',
		'US1840000774' => 'West Pittston',
		'US1840003694' => 'Bridgeport',
		'US1840003452' => 'Mill Hall',
		'US1840043343' => 'New Schaefferstown',
		'US1840003518' => 'Freeport',
		'US1840024265' => 'Longfellow',
		'US1840001297' => 'Steelton',
		'US1840005508' => 'Spry',
		'US1840035284' => 'Feasterville',
		'US1840003750' => 'Wellersburg',
		'US1840034840' => 'Ackermanville',
		'US1840035214' => 'Strong',
		'US1840001075' => 'Rockhill',
		'US1840035419' => 'Chesterbrook',
		'US1840024356' => 'Rowes Run',
		'US1840000713' => 'Trainer',
		'US1840026474' => 'Glenshaw',
		'US1840026409' => 'Breinigsville',
		'US1840001317' => 'Yardley',
		'US1840034998' => 'Grill',
		'US1840133810' => 'Valley View',
		'US1840026320' => 'McElhattan',
		'US1840003507' => 'East Stroudsburg',
		'US1840000509' => 'Alba',
		'US1840001217' => 'Cheswick',
		'US1840000938' => 'New Castle',
		'US1840035221' => 'Taylorstown',
		'US1840000675' => 'Abbottstown',
		'US1840000871' => 'Portersville',
		'US1840005220' => 'Tuscarora',
		'US1840003723' => 'Mount Joy',
		'US1840002754' => 'Auburn',
		'US1840043346' => 'Tharptown',
		'US1840026569' => 'Edenborn',
		'US1840005348' => 'Commodore',
		'US1840003567' => 'McAdoo',
		'US1840001083' => 'Hollidaysburg',
		'US1840003622' => 'Thompsontown',
		'US1840024209' => 'Allenwood',
		'US1840005433' => 'McGovern',
		'US1840034973' => 'Forestville',
		'US1840026564' => 'Smock',
		'US1840000933' => 'Lehighton',
		'US1840026455' => 'Schubert',
		'US1840035011' => 'Hebron',
		'US1840034984' => 'Gibraltar',
		'US1840001280' => 'Jefferson Hills',
		'US1840002756' => 'Cressona',
		'US1840035266' => 'Woodlyn',
		'US1840005435' => 'Gastonville',
		'US1840001449' => 'Hallam',
		'US1840026531' => 'Scotland',
		'US1840035386' => 'West Hills',
		'US1840034937' => 'Eagleville',
		'US1840000722' => 'Waynesburg',
		'US1840002760' => 'Girardville',
		'US1840133907' => 'Woodside',
		'US1840026476' => 'Harwick',
		'US1840024210' => 'Laurelton',
		'US1840002769' => 'New Ringgold',
		'US1840000986' => 'Bethlehem',
		'US1840026555' => 'Needmore',
		'US1840005545' => 'Aspers',
		'US1840000771' => 'Swoyersville',
		'US1840026438' => 'Norvelt',
		'US1840026331' => 'Mocanaqua',
		'US1840035136' => 'Oberlin',
		'US1840026441' => 'Yukon',
		'US1840001390' => 'Newburg',
		'US1840003627' => 'Bolivar',
		'US1840043364' => 'Shippensburg University',
		'US1840001177' => 'Kenhorst',
		'US1840000637' => 'Williamsport',
		'US1840026452' => 'Mount Aetna',
		'US1840026239' => 'Gouldsboro',
		'US1840001165' => 'West Newton',
		'US1840035159' => 'Pomeroy',
		'US1840003496' => 'Houtzdale',
		'US1840001299' => 'Blain',
		'US1840026243' => 'Starbrick',
		'US1840000973' => 'Hellertown',
		'US1840001441' => 'Dillsburg',
		'US1840035252' => 'West Fairview',
		'US1840035203' => 'South Temple',
		'US1840026332' => 'Pardeesville',
		'US1840003502' => 'Osceola Mills',
		'US1840005494' => 'Willow Street',
		'US1840026364' => 'Sun Valley',
		'US1840035250' => 'Wescosville',
		'US1840001116' => 'Johnstown',
		'US1840073713' => 'South Park Township',
		'US1840005430' => 'Fredericksburg',
		'US1840026504' => 'Slovan',
		'US1840005501' => 'Paoli',
		'US1840000878' => 'Zelienople',
		'US1840001425' => 'Downingtown',
		'US1840004999' => 'Rupert',
		'US1840005431' => 'Schaefferstown',
		'US1840000689' => 'Brookhaven',
		'US1840001450' => 'Hanover',
		'US1840003531' => 'Lewisburg',
		'US1840001277' => 'White Oak',
		'US1840005495' => 'Fayetteville',
		'US1840004996' => 'Mifflinville',
		'US1840024261' => 'Alfarata',
		'US1840003315' => 'Prompton',
		'US1840000711' => 'Sharon Hill',
		'US1840000936' => 'Weissport',
		'US1840001407' => 'Schellsburg',
		'US1840026463' => 'Kempton',
		'US1840001160' => 'South Greensburg',
		'US1840001279' => 'Wilmerding',
		'US1840003590' => 'Juniata Terrace',
		'US1840026356' => 'Grassflat',
		'US1840035227' => 'Trucksville',
		'US1840000814' => 'Millville',
		'US1840004997' => 'Numidia',
		'US1840001305' => 'New Buffalo',
		'US1840000864' => 'Evans City',
		'US1840005215' => 'Heckscherville',
		'US1840003430' => 'Sugarcreek',
		'US1840001454' => 'Loganville',
		'US1840000680' => 'Carroll Valley',
		'US1840000656' => 'Clark',
		'US1840001275' => 'Whitaker',
		'US1840000480' => 'Lake City',
		'US1840035069' => 'Locustdale',
		'US1840035031' => 'Jacksonwald',
		'US1840001215' => 'Castle Shannon',
		'US1840001470' => 'Wrightsville',
		'US1840005362' => 'Penns Creek',
		'US1840005374' => 'Schnecksville',
		'US1840035070' => 'Lorane',
		'US1840000941' => 'Volant',
		'US1840001348' => 'Mount Gretna',
		'US1840000759' => 'Laurel Run',
		'US1840001409' => 'Adamstown',
		'US1840001414' => 'Orrstown',
		'US1840026432' => 'Fellsburg',
		'US1840026469' => 'Bairdford',
		'US1840005401' => 'Linglestown',
		'US1840024328' => 'Bainbridge',
		'US1840000992' => 'Clymer',
		'US1840043349' => 'University of Pittsburgh Johnstown',
		'US1840000972' => 'Glendon',
		'US1840003319' => 'Friendsville',
		'US1840000704' => 'Morton',
		'US1840005149' => 'Sandy',
		'US1840005407' => 'Richboro',
		'US1840005385' => 'McAlisterville',
		'US1840034852' => 'Audubon',
		'US1840003306' => 'Austin',
		'US1840003742' => 'New Centerville',
		'US1840000934' => 'Nesquehoning',
		'US1840026461' => 'Gouglersville',
		'US1840005436' => 'Thompsonville',
		'US1840001152' => 'New Stanton',
		'US1840005163' => 'Julian',
		'US1840026395' => 'Reinerton',
		'US1840001252' => 'Pennsbury Village',
		'US1840026306' => 'Wilcox',
		'US1840034993' => 'Gordonville',
		'US1840003523' => 'Parker',
		'US1840000882' => 'Apollo',
		'US1840000695' => 'Darby',
		'US1840035078' => 'Cecil-Bishop',
		'US1840003391' => 'Throop',
		'US1840026450' => 'Mohrsville',
		'US1840001202' => 'Bell Acres',
		'US1840034901' => 'Cherryville',
		'US1840005389' => 'Lawson Heights',
		'US1840001435' => 'Spring City',
		'US1840003584' => 'Homewood',
		'US1840000706' => 'Parkside',
		'US1840026590' => 'New Freeport',
		'US1840005157' => 'Monument',
		'US1840026468' => 'Allison Park',
		'US1840001168' => 'Trafford',
		'US1840000985' => 'Wind Gap',
		'US1840003464' => 'Strattanville',
		'US1840000823' => 'Centre Hall',
		'US1840005382' => 'Vinco',
		'US1840001176' => 'Hamburg',
		'US1840034946' => 'Edenburg',
		'US1840003732' => 'Boswell',
		'US1840003744' => 'Rockwood',
		'US1840035450' => 'The Hideout',
		'US1840035067' => 'Linwood',
		'US1840004808' => 'Guys Mills',
		'US1840003517' => 'Ford Cliff',
		'US1840002789' => 'Shelocta',
		'US1840003427' => 'Pleasantville',
		'US1840005167' => 'Spring Mills',
		'US1840034975' => 'Fountain Springs',
		'US1840026377' => 'Albrightsville',
		'US1840000848' => 'Riverside',
		'US1840001269' => 'Versailles',
		'US1840001104' => 'Chest Springs',
		'US1840000527' => 'Mount Jewett',
		'US1840026412' => 'McConnellstown',
		'US1840001242' => 'Lincoln',
		'US1840035059' => 'Lightstreet',
		'US1840026318' => 'Rote',
		'US1840026458' => 'Stouchsburg',
		'US1840005465' => 'Kulpsville',
		'US1840001157' => 'Scottdale',
		'US1840073703' => 'Leith-Hatfield',
		'US1840003568' => 'Bessemer',
		'US1840005469' => 'Stowe',
		'US1840001129' => 'Wilmore',
		'US1840024251' => 'Hegins',
		'US1840003668' => 'Washington',
		'US1840026477' => 'Imperial',
		'US1840001186' => 'Robesonia',
		'US1840003438' => 'Laporte',
		'US1840001446' => 'Franklintown',
		'US1840035407' => 'Laurel Mountain',
		'US1840000478' => 'Erie',
		'US1840034896' => 'Cetronia',
		'US1840001443' => 'East Prospect',
		'US1840026297' => 'Simpson',
		'US1840034995' => 'Grapeville',
		'US1840000939' => 'New Wilmington',
		'US1840003467' => 'Big Run',
		'US1840001224' => 'Duquesne',
		'US1840026502' => 'Langeloth',
		'US1840026359' => 'Morrisdale',
		'US1840003655' => 'Finleyville',
		'US1840002780' => 'Tamaqua',
		'US1840001402' => 'New Paris',
		'US1840034841' => 'Alleghenyville',
		'US1840024192' => 'Mingoville',
		'US1840034888' => 'Caln',
		'US1840003731' => 'Berlin',
		'US1840000705' => 'Norwood',
		'US1840026453' => 'Oley',
		'US1840004995' => 'Buckhorn',
		'US1840005159' => 'Pine Glen',
		'US1840001079' => 'Three Springs',
		'US1840003450' => 'Lock Haven',
		'US1840035421' => 'East Uniontown',
		'US1840026408' => 'Slatedale',
		'US1840035056' => 'Lenkerville',
		'US1840000758' => 'Larksville',
		'US1840001309' => 'Perkasie',
		'US1840003424' => 'Cooperstown',
		'US1840003650' => 'Donora',
		'US1840000628' => 'Duboistown',
		'US1840001236' => 'Haysville',
		'US1840005004' => 'Mainville',
		'US1840026378' => 'Frizzleburg',
		'US1840000770' => 'Sugar Notch',
		'US1840000849' => 'Shamokin',
		'US1840035142' => 'Park Crest',
		'US1840034849' => 'Arlington Heights',
		'US1840035243' => 'Wanamie',
		'US1840026478' => 'Noblestown',
		'US1840026440' => 'Wyano',
		'US1840003631' => 'Monroeville',
		'US1840001427' => 'Honey Brook',
		'US1840000867' => 'Harrisville',
		'US1840001392' => 'Newville',
		'US1840026381' => 'Chewton',
		'US1840026587' => 'Crucible',
		'US1840035155' => 'Pymatuning Central',
		'US1840005369' => 'Milroy',
		'US1840001416' => 'Callimont',
		'US1840001134' => 'Donegal',
		'US1840043397' => 'St. Vincent College',
		'US1840005364' => 'Hummels Wharf',
		'US1840026420' => 'Mundys Corner',
		'US1840000762' => 'Nescopeck',
		'US1840000844' => 'Marion Heights',
		'US1840005437' => 'Wolfdale',
		'US1840034924' => 'Dauberville',
		'US1840026236' => 'Foster Brook',
		'US1840001198' => 'Franklin Park',
		'US1840035439' => 'Susquehanna Trails',
		'US1840001447' => 'Glen Rock',
		'US1840026480' => 'Sturgeon',
		'US1840003718' => 'Lancaster',
		'US1840024331' => 'Churchtown',
		'US1840001394' => 'Wormleysburg',
		'US1840024214' => 'Winfield',
		'US1840001065' => 'Cassville',
		'US1840040526' => 'Queens Gate',
		'US1840003381' => 'Dunmore',
		'US1840003495' => 'Grampian',
		'US1840005455' => 'Ardmore',
		'US1840003378' => 'Clarks Summit',
		'US1840035200' => 'Soudersburg',
		'US1840024316' => 'Van Voorhis',
		'US1840000768' => 'Pringle',
		'US1840001032' => 'West Mayfield',
		'US1840005408' => 'Levittown',
		'US1840005384' => 'Mexico',
		'US1840001103' => 'Cassandra',
		'US1840035418' => 'Amity Gardens',
		'US1840026370' => 'Dewart',
		'US1840000516' => 'Rome',
		'US1840001434' => 'South Coatesville',
		'US1840001047' => 'Coplay',
		'US1840001084' => 'Martinsburg',
		'US1840073702' => 'Lebanon South',
		'US1840005204' => 'Belfast',
		'US1840000718' => 'Clarksville',
		'US1840001452' => 'Jefferson',
		'US1840034842' => 'Altamont',
		'US1840001378' => 'Souderton',
		'US1840035391' => 'Conashaugh Lakes',
		'US1840000555' => 'Conneautville',
		'US1840001461' => 'Red Lion',
		'US1840034956' => 'Eyers Grove',
		'US1840001377' => 'Schwenksville',
		'US1840003745' => 'Salisbury',
		'US1840001204' => 'Ben Avon',
		'US1840026505' => 'Wylandville',
		'US1840035433' => 'Old Orchard',
		'US1840000712' => 'Swarthmore',
		'US1840024307' => 'Avella',
		'US1840004886' => 'Seneca',
		'US1840005428' => 'Newmanstown',
		'US1840000755' => 'Jeddo',
		'US1840026507' => 'Muse',
		'US1840000879' => 'Rural Valley',
		'US1840004696' => 'Lawrence Park',
		'US1840003437' => 'Forksville',
		'US1840001074' => 'Petersburg',
		'US1840001073' => 'Orbisonia',
		'US1840026355' => 'Bigler',
		'US1840000826' => 'Millheim',
		'US1840000970' => 'Easton',
		'US1840001314' => 'Silverdale',
		'US1840003388' => 'Olyphant',
		'US1840000735' => 'Mercer',
		'US1840000515' => 'New Albany',
		'US1840001066' => 'Coalmont',
		'US1840005160' => 'Pine Grove Mills',
		'US1840003740' => 'Meyersdale',
		'US1840026362' => 'Effort',
		'US1840000687' => 'York Springs',
		'US1840000518' => 'South Waverly',
		'US1840024211' => 'New Columbia',
		'US1840005006' => 'Waller',
		'US1840001319' => 'Chalfont',
		'US1840001412' => 'Mercersburg',
		'US1840043404' => 'Greens Landing',
		'US1840026443' => 'Bethel',
		'US1840026336' => 'Silkworth',
		'US1840000975' => 'Northampton',
		'US1840034880' => 'Browntown',
		'US1840000663' => 'Markleysburg',
		'US1840001386' => 'Carlisle',
		'US1840000551' => 'Cambridge Springs',
		'US1840024144' => 'Kennerdell',
		'US1840003642' => 'California',
		'US1840001119' => 'Loretto',
		'US1840001182' => 'Lyons',
		'US1840025529' => 'Plains',
		'US1840001141' => 'Jeannette',
		'US1840005156' => 'Coburn',
		'US1840035392' => 'Pocono Springs',
		'US1840003386' => 'Moscow',
		'US1840000698' => 'Folcroft',
		'US1840043361' => 'Lincoln University',
		'US1840000564' => 'Venango',
		'US1840034861' => 'Beaverdale',
		'US1840000880' => 'West Kittanning',
		'US1840000996' => 'Homer City',
		'US1840035012' => 'Hemlock Farms',
		'US1840001291' => 'Middletown',
		'US1840000512' => 'Canton',
		'US1840001268' => 'Verona',
		'US1840000714' => 'Upland',
		'US1840026233' => 'Arnot',
		'US1840001220' => 'Coraopolis',
		'US1840026541' => 'Cochranville',
		'US1840000717' => 'Carmichaels',
		'US1840005211' => 'Nuremberg',
		'US1840024194' => 'Nittany',
		'US1840001124' => 'Scalp Level',
		'US1840005387' => 'Harrison City',
		'US1840073606' => 'Carnot-Moon',
		'US1840005399' => 'Paxtonia',
		'US1840003663' => 'North Charleroi',
		'US1840001185' => 'Reading',
		'US1840000868' => 'Karns City',
		'US1840001395' => 'Shippensburg',
		'US1840003565' => 'Parryville',
		'US1840005509' => 'Weigelstown',
		'US1840000869' => 'Mars',
		'US1840035149' => 'Pennwyn',
		'US1840000990' => 'Blairsville',
		'US1840002795' => 'Beavertown',
		'US1840042767' => 'Potlicker Flats',
		'US1840035173' => 'Riverview Park',
		'US1840003648' => 'Cokeburg',
		'US1840005001' => 'Jerseytown',
		'US1840073691' => 'Homeacre-Lyndora',
		'US1840003311' => 'Ulysses',
		'US1840000780' => 'Falls Creek',
		'US1840035082' => 'Maple Glen',
		'US1840000633' => 'Muncy',
		'US1840001030' => 'Shippingport',
		'US1840001261' => 'Sewickley Hills',
		'US1840000980' => 'Stockertown',
		'US1840034989' => 'Glenburn',
		'US1840000707' => 'Prospect Park',
		'US1840001313' => 'Sellersville',
		'US1840024344' => 'Reinholds',
		'US1840003725' => 'New Holland',
		'US1840002786' => 'Marion Center',
		'US1840001460' => 'Railroad',
		'US1840034951' => 'Englewood',
		'US1840004802' => 'Adamsville',
		'US1840035066' => 'Linntown',
		'US1840034938' => 'East Berwick',
		'US1840001462' => 'Seven Valleys',
		'US1840035049' => 'Lattimer',
		'US1840026414' => 'Foot of Ten',
		'US1840035429' => 'Meadowood',
		'US1840005386' => 'Crabtree',
		'US1840001436' => 'West Chester',
		'US1840001049' => 'Fountain Hill',
		'US1840000616' => 'Johnsonburg',
		'US1840000874' => 'Slippery Rock',
		'US1840000697' => 'Eddystone',
		'US1840000825' => 'Milesburg',
		'US1840000487' => 'Wattsburg',
		'US1840035456' => 'Pine Ridge',
		'US1840035139' => 'Orwin',
		'US1840000873' => 'Saxonburg',
		'US1840000488' => 'Wesleyville',
		'US1840026532' => 'Blue Ridge Summit',
		'US1840001044' => 'Allentown',
		'US1840026328' => 'Leeper',
		'US1840000772' => 'Warrior Run',
		'US1840000473' => 'Albion',
		'US1840024190' => 'Hublersburg',
		'US1840001445' => 'Felton',
		'US1840000733' => 'Jackson Center',
		'US1840026445' => 'Bowers',
		'US1840003503' => 'Ramey',
		'US1840000966' => 'Bangor',
		'US1840004805' => 'Riceville',
		'US1840026422' => 'Revloc',
		'US1840035412' => 'Lake Heritage',
		'US1840003451' => 'Loganton',
		'US1840000703' => 'Millbourne',
		'US1840001143' => 'Ligonier',
		'US1840035017' => 'Hokendauqua',
		'US1840005484' => 'Boiling Springs',
		'US1840001062' => 'Alexandria',
		'US1840035389' => 'Gold Key Lake',
		'US1840035168' => 'Ranshaw',
		'US1840024330' => 'Bowmansville',
		'US1840005164' => 'Lemont',
		'US1840026400' => 'Robinson',
		'US1840001121' => 'Patton',
		'US1840003749' => 'Ursina',
		'US1840002755' => 'Coaldale',
		'US1840001474' => 'York Haven',
		'US1840003335' => 'Youngsville',
		'US1840003476' => 'Worthville',
		'US1840026423' => 'Blandburg',
		'US1840001156' => 'Penn',
		'US1840024317' => 'Westland',
		'US1840035016' => 'Hilldale',
		'US1840003519' => 'Kittanning',
		'US1840001431' => 'Oxford',
		'US1840001113' => 'Gallitzin',
		'US1840026584' => 'Idaville',
		'US1840000553' => 'Cochranton',
		'US1840005488' => 'Reamstown',
		'US1840000978' => 'Portland',
		'US1840005470' => 'Trooper',
		'US1840024312' => 'Lawrence',
		'US1840003564' => 'Palmerton',
		'US1840002772' => 'Pine Grove',
		'US1840003474' => 'Sykesville',
		'US1840001076' => 'Saltillo',
		'US1840000854' => 'Danville',
		'US1840000665' => 'Newell',
		'US1840000940' => 'South New Castle',
		'US1840005360' => 'Mount Pleasant Mills',
		'US1840026354' => 'Allport',
		'US1840001097' => 'Northern Cambria',
		'US1840000885' => 'Dayton',
		'US1840001013' => 'Beaver Falls',
		'US1840000576' => 'Factoryville',
		'US1840001031' => 'South Heights',
		'US1840026442' => 'Mammoth',
		'US1840000690' => 'Chester',
		'US1840073577' => 'Fairview-Ferndale',
		'US1840034977' => 'Fullerton',
		'US1840003651' => 'Dunlevy',
		'US1840026238' => 'Sweden Valley',
		'US1840035053' => 'Lawnton',
		'US1840003312' => 'Bethany',
		'US1840005347' => 'Black Lick',
		'US1840035324' => 'Cornwells Heights',
		'US1840001014' => 'Bridgewater',
		'US1840001231' => 'Etna',
		'US1840003377' => 'Clarks Green',
		'US1840001353' => 'McDonald',
		'US1840026380' => 'West Pittsburg',
		'US1840000765' => 'Penn Lake Park',
		'US1840066084' => 'Susquehanna Depot',
		'US1840001068' => 'Huntingdon',
		'US1840003729' => 'Addison',
		'US1840003383' => 'Jessup',
		'US1840000775' => 'West Wyoming',
		'US1840035158' => 'Pocono Mountain Lake Estates',
		'US1840001082' => 'Duncansville',
		'US1840001293' => 'Paxtang',
		'US1840066079' => 'Monroe',
		'US1840000554' => 'Conneaut Lake',
		'US1840035434' => 'Plymptonville',
		'US1840001429' => 'Malvern',
		'US1840035379' => 'Saw Creek',
		'US1840001115' => 'Hastings',
		'US1840002778' => 'Schuylkill Haven',
		'US1840005359' => 'Beaver Springs',
		'US1840034875' => 'Bressler',
		'US1840001222' => 'Dormont',
		'US1840035454' => 'Penn Estates',
		'US1840001237' => 'Heidelberg',
		'US1840035075' => 'Lumber City',
		'US1840001406' => 'Saxton',
		'US1840003453' => 'Renovo',
		'US1840026595' => 'Dry Tavern',
		'US1840026433' => 'Level Green',
		'US1840034968' => 'Flourtown',
		'US1840001191' => 'Strausstown',
		'US1840005496' => 'Rouzerville',
		'US1840034868' => 'Blue Bell',
		'US1840035024' => 'Hudson',
		'US1840035040' => 'Kelayres',
		'US1840034970' => 'Folsom',
		'US1840000519' => 'Sylvania',
		'US1840035416' => 'Timber Hills',
		'US1840001110' => 'Ehrenfeld',
		'US1840001180' => 'Leesport',
		'US1840026429' => 'Bradenville',
		'US1840043382' => 'Penn State Erie',
		'US1840026565' => 'Star Junction',
		'US1840035202' => 'South Renovo',
		'US1840003475' => 'Timblin',
		'US1840000670' => 'South Connellsville',
		'US1840001458' => 'New Salem',
		'US1840005162' => 'Rebersburg',
		'US1840003309' => 'Oswayo',
		'US1840026464' => 'New Jerusalem',
		'US1840026542' => 'Westwood',
		'US1840000486' => 'Waterford',
		'US1840034851' => 'Atlas',
		'US1840001117' => 'Lilly',
		'US1840001200' => 'Avalon',
		'US1840000932' => 'Lansford',
		'US1840025531' => 'Baileyville',
		'US1840035395' => 'Pocono Ranch Lands',
		'US1840034952' => 'Enhaut',
		'US1840005434' => 'McMurray',
		'US1840003625' => 'Arona',
		'US1840024195' => 'Orviston',
		'US1840035315' => 'Mount Cobb',
		'US1840002753' => 'Ashland',
		'US1840003515' => 'Elderton',
		'US1840026313' => 'Oval',
		'US1840035413' => 'Lake Meade',
		'US1840035060' => 'Lima',
		'US1840001263' => 'Springdale',
		'US1840000857' => 'Butler',
		'US1840001048' => 'Emmaus',
		'US1840000752' => 'Harveys Lake',
		'US1840000847' => 'Northumberland',
		'US1840001285' => 'Elizabethville',
		'US1840001088' => 'Williamsburg',
		'US1840005219' => 'Summit Station',
		'US1840024332' => 'Conestoga',
		'US1840026303' => 'James City',
		'US1840024142' => 'Marienville',
		'US1840026240' => 'White Mills',
		'US1840035394' => 'Fawn Lake Forest',
		'US1840000881' => 'Worthington',
		'US1840000485' => 'Union City',
		'US1840000661' => 'Fairchance',
		'US1840002775' => 'Pottsville',
		'US1840002762' => 'Landingville',
		'US1840001064' => 'Broad Top City',
		'US1840001127' => 'Vintondale',
		'US1840000635' => 'Salladasburg',
		'US1840000684' => 'Littlestown',
		'US1840024341' => 'Little Britain',
		'US1840001253' => 'Pitcairn',
		'US1840026235' => 'Rew',
		'US1840001009' => 'Aliquippa',
		'US1840005548' => 'Boothwyn',
		'US1840026581' => 'Hunterstown',
		'US1840035294' => 'South Bethlehem',
		'US1840000673' => 'Philadelphia',
		'US1840003375' => 'Blakely',
		'US1840001023' => 'Georgetown',
		'US1840001328' => 'New Hope',
		'US1840003697' => 'Conshohocken',
		'US1840001189' => 'Shoemakersville',
		'US1840001456' => 'Mount Wolf',
		'US1840001029' => 'Patterson Heights',
		'US1840003324' => 'Little Meadows',
		'US1840035193' => 'Sheatown',
		'US1840000745' => 'Dallas',
		'US1840000631' => 'Montgomery',
		'US1840000884' => 'Atwood',
		'US1840034943' => 'East York',
		'US1840000858' => 'Callery',
		'US1840026529' => 'Fort Loudon',
		'US1840001114' => 'Geistown',
		'US1840001248' => 'North Braddock',
		'US1840003746' => 'Shanksville',
		'US1840005218' => 'Sheppton',
		'US1840001391' => 'New Cumberland',
		'US1840003483' => 'Benton',
		'US1840034955' => 'Evansburg',
		'US1840040475' => 'Eagleview',
		'US1840035164' => 'Progress',
		'US1840024313' => 'Millsboro',
		'US1840001212' => 'Brentwood',
		'US1840000696' => 'East Lansdowne',
		'US1840001399' => 'Hopewell',
		'US1840001323' => 'Ivyland',
		'US1840003654' => 'Ellsworth',
		'US1840003435' => 'Dushore',
		'US1840035170' => 'Richfield',
		'US1840000524' => 'Eldred',
		'US1840035447' => 'Beech Mountain Lakes',
		'US1840000692' => 'Clifton Heights',
		'US1840003299' => 'Lawrenceville',
		'US1840001417' => 'Seven Springs',
		'US1840000851' => 'Sunbury',
		'US1840003456' => 'Foxburg',
		'US1840003620' => 'Mifflintown',
		'US1840035423' => 'Flying Hills',
		'US1840005213' => 'Ravine',
		'US1840073731' => 'Weissport East',
		'US1840024269' => 'Wagner',
		'US1840066083' => 'Bloomfield',
		'US1840001100' => 'Ashville',
		'US1840003741' => 'New Baltimore',
		'US1840005372' => 'Yeagertown',
		'US1840005379' => 'Colver',
		'US1840026407' => 'New Tripoli',
		'US1840005463' => 'Harleysville',
		'US1840024308' => 'Cross Creek',
		'US1840001287' => 'Halifax',
		'US1840005151' => 'Treasure Lake',
		'US1840003736' => 'Garrett',
		'US1840035410' => 'Beurys Lake',
		'US1840003321' => 'Hallstead',
		'US1840001151' => 'New Kensington',
		'US1840003510' => 'Delaware Water Gap',
		'US1840001015' => 'Conway',
		'US1840035398' => 'DuBois',
		'US1840035305' => 'Penn Wynne',
		'US1840001262' => 'Sharpsburg',
		'US1840001072' => 'Mount Union',
		'US1840001206' => 'Bethel Park',
		'US1840026527' => 'Blue Ball',
		'US1840035240' => 'Virginville',
		'US1840026457' => 'Stony Creek Mills',
		'US1840005400' => 'Hershey',
		'US1840001502' => 'Dawson',
		'US1840001301' => 'Landisburg',
		'US1840003712' => 'Christiana',
		'US1840003322' => 'Hop Bottom',
		'US1840003305' => 'Westfield',
		'US1840001467' => 'West York',
		'US1840026503' => 'Paris',
		'US1840005456' => 'Bryn Mawr',
		'US1840026475' => 'Greenock',
		'US1840003530' => 'Hartleton',
		'US1840001241' => 'Liberty',
		'US1840001284' => 'Dauphin',
		'US1840000859' => 'Cherry Valley',
		'US1840003591' => 'Kistler',
		'US1840003660' => 'Midway',
		'US1840000749' => 'Exeter',
		'US1840000930' => 'East Side',
		'US1840035194' => 'Shenandoah Heights',
		'US1840000994' => 'Ernest',
		'US1840000662' => 'Fayette City',
		'US1840026585' => 'Bobtown',
		'US1840001043' => 'Alburtis',
		'US1840024296' => 'Trevose',
		'US1840026525' => 'Stonerstown',
		'US1840000979' => 'Roseto',
		'US1840043348' => 'Slippery Rock University',
		'US1840001229' => 'Elizabeth',
		'US1840005353' => 'Lucerne Mines',
		'US1840000761' => 'Nanticoke',
		'US1840026568' => 'Allison',
		'US1840001433' => 'Phoenixville',
		'US1840000557' => 'Linesville',
		'US1840003436' => 'Eagles Mere',
		'US1840001306' => 'Newport',
		'US1840035408' => 'Big Beaver',
		'US1840000716' => 'Fairdale',
		'US1840000671' => 'Uniontown',
		'US1840003693' => 'Ambler',
		'US1840003307' => 'Coudersport',
		'US1840000709' => 'Rose Valley',
		'US1840005205' => 'Palmer Heights',
		'US1840024193' => 'Moshannon',
		'US1840005426' => 'Annville',
		'US1840005498' => 'Friedens',
		'US1840024250' => 'Grier City',
		'US1840000736' => 'New Lebanon',
		'US1840000550' => 'Blooming Valley',
		'US1840002774' => 'Port Clinton',
		'US1840024263' => 'Atkinson Mills',
		'US1840000699' => 'Glenolden',
		'US1840003705' => 'Norristown',
		'US1840043383' => 'DeSales University',
		'US1840003323' => 'Lanesboro',
		'US1840005502' => 'Lionville',
		'US1840005391' => 'Reiffton',
		'US1840073612' => 'Conneaut Lakeshore',
		'US1840003733' => 'Casselman',
		'US1840035425' => 'Halfway House',
		'US1840000816' => 'Stillwater',
		'US1840001469' => 'Winterstown',
		'US1840026533' => 'Pen Mar',
		'US1840026499' => 'Bulger',
		'US1840035321' => 'West Falls',
		'US1840003658' => 'Long Branch',
		'US1840000476' => 'Edinboro',
		'US1840001226' => 'East Pittsburgh',
		'US1840005395' => 'Russellton',
		'US1840001255' => 'Pleasant Hills',
		'US1840000732' => 'Hermitage',
		'US1840001195' => 'Womelsdorf',
		'US1840003643' => 'Canonsburg',
		'US1840000929' => 'Bowmanstown',
		'US1840005208' => 'Donaldson',
		'US1840066082' => 'Nanty-Glo',
		'US1840003632' => 'Plum',
		'US1840026357' => 'Hawk Run',
		'US1840003422' => 'Barkeyville',
		'US1840001439' => 'Dallastown',
		'US1840005464' => 'King of Prussia',
		'US1840000679' => 'Bonneauville',
		'US1840003646' => 'Claysville',
		'US1840001125' => 'South Fork',
		'US1840005506' => 'Emigsville',
		'US1840000721' => 'Rices Landing',
		'US1840024355' => 'Buffington',
		'US1840026417' => 'East Freedom',
		'US1840000559' => 'Saegertown',
		'US1840035147' => 'Pennside',
		'US1840026530' => 'Marion',
		'US1840035385' => 'Holiday Pocono',
		'US1840000561' => 'Springboro',
		'US1840001396' => 'Bedford',
		'US1840000877' => 'West Sunbury',
		'US1840001415' => 'Waynesboro',
		'US1840001321' => 'Dublin',
		'US1840000748' => 'Edwardsville',
		'US1840001158' => 'Seward',
		'US1840035380' => 'Emerald Lakes',
		'US1840026242' => 'Russell',
		'US1840000510' => 'Athens',
		'US1840003434' => 'Milford',
		'US1840003664' => 'Roscoe',
		'US1840003333' => 'Sugar Grove',
		'US1840001162' => 'Sutersville',
		'US1840035287' => 'Kenmar',
		'US1840001216' => 'Chalfant',
		'US1840000686' => 'New Oxford',
		'US1840001310' => 'Quakertown',
		'US1840001175' => 'Fleetwood',
		'US1840000558' => 'Meadville',
		'US1840002777' => 'St. Clair',
		'US1840035296' => 'Warminster Heights',
		'US1840005181' => 'Meridian',
		'US1840003318' => 'Forest City',
		'US1840000967' => 'Bath',
		'US1840001499' => 'Belle Vernon',
		'US1840035042' => 'Kenilworth',
		'US1840034939' => 'East Earl',
		'US1840024337' => 'Intercourse',
		'US1840001155' => 'Oklahoma',
		'US1840034904' => 'Church Hill',
		'US1840001098' => 'Summerhill',
		'US1840000676' => 'Arendtsville',
		'US1840003652' => 'East Washington',
		'US1840003442' => 'Sharpsville',
		'US1840026456' => 'Shartlesville',
		'US1840003449' => 'Flemington',
		'US1840035026' => 'Indian Mountain Lake',
		'US1840000845' => 'Milton',
		'US1840001466' => 'Wellsville',
		'US1840003665' => 'Speers',
		'US1840001196' => 'Wyomissing',
		'US1840026582' => 'Table Rock',
		'US1840001273' => 'West Mifflin',
		'US1840000974' => 'Nazareth',
		'US1840001244' => 'McKees Rocks',
		'US1840003738' => 'Indian Lake',
		'US1840026479' => 'Rennerdale',
		'US1840000521' => 'Troy',
		'US1840035261' => 'Wilburton Number One',
		'US1840000528' => 'Port Allegany',
		'US1840005468' => 'Spring Mount',
		'US1840005542' => 'Hiller',
		'US1840001238' => 'Homestead',
		'US1840005154' => 'Boalsburg',
		'US1840000529' => 'Smethport',
		'US1840005177' => 'Elysburg',
		'US1840003298' => 'Knoxville',
		'US1840003661' => 'Monongahela',
		'US1840003428' => 'Polk',
		'US1840000824' => 'Howard',
		'US1840034864' => 'Bird-in-Hand',
		'US1840024342' => 'Penryn',
		'US1840003624' => 'Arnold',
		'US1840001154' => 'North Irwin',
		'US1840000477' => 'Elgin',
		'US1840003644' => 'Centerville',
		'US1840005190' => 'Oakwood',
		'US1840001259' => 'Sewickley',
		'US1840035455' => 'Sierra View',
		'US1840035436' => 'Ramblewood',
		'US1840026454' => 'Rehrersburg',
		'US1840000636' => 'South Williamsport',
		'US1840024213' => 'West Milton',
		'US1840001201' => 'Baldwin',
		'US1840000870' => 'Petrolia',
		'US1840026371' => 'Dalmatia',
		'US1840000855' => 'Washingtonville',
		'US1840005503' => 'South Pottstown',
		'US1840001209' => 'Braddock',
		'US1840000660' => 'Grove City',
		'US1840001503' => 'Dunbar',
		'US1840001067' => 'Dudley',
		'US1840004887' => 'Woodland Heights',
		'US1840001190' => 'Sinking Spring',
		'US1840035424' => 'Grantley',
		'US1840005168' => 'Stormstown',
		'US1840001118' => 'Lorain',
		'US1840034999' => 'Grindstone',
		'US1840001246' => 'Mount Oliver',
		'US1840003470' => 'Corsica',
		'US1840001272' => 'West Homestead',
		'US1840000688' => 'Aldan',
		'US1840001311' => 'Richlandtown',
		'US1840005377' => 'Tipton',
		'US1840004998' => 'Rohrsburg',
		'US1840026295' => 'Noxen',
		'US1840035442' => 'Village Shires',
		'US1840003429' => 'Rouseville',
		'US1840034931' => 'Dorneyville',
		'US1840002798' => 'Middleburg',
		'US1840001214' => 'Carnegie',
		'US1840004993' => 'Almedia',
		'US1840005499' => 'Jerome',
		'US1840026563' => 'Farmington',
		'US1840000740' => 'East Brady',
		'US1840001228' => 'Edgeworth',
		'US1840003330' => 'Union Dale',
		'US1840132814' => 'Blanchard',
		'US1840000754' => 'Hughestown',
		'US1840000928' => 'Beaver Meadows',
		'US1840001018' => 'Eastvale',
		'US1840000659' => 'Greenville',
		'US1840005458' => 'Oreland',
		'US1840001374' => 'Red Hill',
		'US1840000976' => 'North Catasauqua',
		'US1840005490' => 'Rothsville',
		'US1840005183' => 'Orchard Hills',
		'US1840003313' => 'Hawley',
		'US1840003490' => 'Clearfield',
		'US1840003570' => 'Enon Valley',
		'US1840002799' => 'Selinsgrove',
		'US1840001324' => 'Langhorne',
		'US1840000828' => 'Port Matilda',
		'US1840035440' => 'Valley Green',
		'US1840003465' => 'Bear Creek Village',
		'US1840026566' => 'South Uniontown',
		'US1840035256' => 'West Wyomissing',
		'US1840001069' => 'Mapleton',
		'US1840035209' => 'Stiles',
		'US1840003380' => 'Dickson City',
		'US1840035248' => 'Weatherly',
		'US1840000830' => 'State College',
		'US1840024347' => 'Wakefield',
		'US1840005487' => 'Paradise',
		'US1840024339' => 'Lampeter',
		'US1840001109' => 'Ebensburg',
		'US1840001147' => 'Mount Pleasant',
		'US1840003743' => 'Paint',
		'US1840026334' => 'Shavertown',
		'US1840001405' => 'St. Clairsville',
		'US1840035444' => 'Muhlenberg Park',
		'US1840035185' => 'Salunga',
		'US1840000984' => 'Wilson',
		'US1840001008' => 'Rochester',
		'US1840026562' => 'Fairhope',
		'US1840005461' => 'Gilbertsville',
		'US1840004912' => 'Glen Lyon',
		'US1840001497' => 'Valley-Hi',
		'US1840001142' => 'Latrobe',
		'US1840000556' => 'Hydetown',
		'US1840001133' => 'Derry',
		'US1840000708' => 'Ridley Park',
		'US1840003569' => 'Ellport',
		'US1840001027' => 'New Galilee',
		'US1840026449' => 'Mertztown',
		'US1840000983' => 'West Easton',
		'US1840000827' => 'Philipsburg',
		'US1840035169' => 'Raubsville',
		'US1840005350' => 'Rossiter',
		'US1840001504' => 'Everson',
		'US1840002767' => 'Mount Carbon',
		'US1840005467' => 'Spring House',
		'US1840001325' => 'Langhorne Manor',
		'US1840024205' => 'Montandon',
		'US1840001197' => 'Fox Chapel',
		'US1840001322' => 'Hulmeville',
		'US1840026256' => 'Kerrtown',
		'US1840001089' => 'Tunnelhill',
		'US1840000860' => 'Chicora',
		'US1840003501' => 'New Washington',
		'US1840003320' => 'Great Bend',
		'US1840001218' => 'Churchill',
		'US1840035063' => 'Lincoln Park',
		'US1840035446' => 'Montrose Manor',
		'US1840003720' => 'Manheim',
		'US1840005390' => 'Slickville',
		'US1840000763' => 'New Columbus',
		'US1840003317' => 'Waymart',
		'US1840005352' => 'Jacksonville',
		'US1840035083' => 'Marlin',
		'US1840000773' => 'West Hazleton',
		'US1840043333' => 'Kutztown University',
		'US1840003326' => 'New Milford',
		'US1840001432' => 'Parkesburg',
		'US1840026506' => 'Fredericktown',
		'US1840026358' => 'Kylertown',
		'US1840001020' => 'Fallston',
		'US1840000682' => 'Fairfield',
		'US1840026498' => 'Atlasburg',
		'US1840000982' => 'Walnutport',
		'US1840035427' => 'Lenape Heights',
		'US1840034863' => 'Birchwood Lakes',
		'US1840001017' => 'East Rochester',
		'US1840005507' => 'Parkville',
		'US1840001148' => 'Murrysville',
		'US1840035415' => 'Spring Ridge',
		'US1840001440' => 'Delta',
		'US1840000861' => 'Connoquenessing',
		'US1840001136' => 'Export',
		'US1840005376' => 'Claysburg',
		'US1840003463' => 'Sligo',
		'US1840001274' => 'West View',
		'US1840001107' => 'Dale',
		'US1840002788' => 'Saltsburg',
		'US1840026294' => 'Lake Winola',
		'US1840005378' => 'Belmont',
		'US1840001128' => 'Westmont',
		'US1840035452' => 'Lake Arthur Estates',
		'US1840001265' => 'Tarentum',
		'US1840026473' => 'Enlow',
		'US1840003487' => 'Brisbin',
		'US1840003728' => 'Terre Hill',
		'US1840003392' => 'Vandling',
		'US1840035426' => 'Hasson Heights',
		'US1840024343' => 'Refton',
		'US1840035118' => 'Naomi',
		'US1840001245' => 'Millvale',
		'US1840001250' => 'Oakmont',
		'US1840001233' => 'Glassport',
		'US1840003641' => 'Burgettstown',
		'US1840026406' => 'Egypt',
		'US1840035359' => 'Pikes Creek',
		'US1840034925' => 'Delano',
		'US1840003532' => 'Mifflinburg',
		'US1840001227' => 'Edgewood',
		'US1840026418' => 'Northwood',
		'US1840001045' => 'Catasauqua',
		'US1840003695' => 'Bryn Athyn',
		'US1840001022' => 'Freedom',
		'US1840005427' => 'Campbelltown',
		'US1840005432' => 'Baidland',
		'US1840000942' => 'Wampum',
		'US1840035269' => 'Woxall',
		'US1840004810' => 'Hartstown',
		'US1840000710' => 'Rutledge',
		'US1840000968' => 'Chapman',
		'US1840001428' => 'Kennett Square',
		'US1840035422' => 'Elim',
		'US1840003699' => 'Green Lane',
		'US1840024351' => 'Berwyn',
		'US1840003385' => 'Moosic',
		'US1840005550' => 'Drexel Hill',
		'US1840026536' => 'Edie',
		'US1840000810' => 'Briar Creek',
		'US1840035304' => 'Chevy Chase Heights',
		'US1840000862' => 'East Butler',
		'US1840001472' => 'York',
		'US1840001187' => 'St. Lawrence',
		'US1840002768' => 'New Philadelphia',
		'US1840001326' => 'Morrisville',
		'US1840000931' => 'Jim Thorpe',
		'US1840003445' => 'West Middlesex',
		'US1840026567' => 'Bear Rocks',
		'US1840026447' => 'Frystown',
		'US1840005543' => 'Hopwood',
		'US1840001178' => 'Kutztown',
		'US1840003662' => 'New Eagle',
		'US1840001304' => 'Millerstown',
		'US1840035247' => 'Wayne Heights',
		'US1840001194' => 'West Reading',
		'US1840005165' => 'Madisonburg',
		'US1840003626' => 'Avonmore',
		'US1840005365' => 'Kratzerville',
		'US1840034858' => 'Barrville',
		'US1840000812' => 'Catawissa',
		'US1840000937' => 'Ellwood City',
		'US1840026560' => 'Chalkhill',
		'US1840001388' => 'Mechanicsburg',
		'US1840026578' => 'McKnightstown',
		'US1840003630' => 'New Morgan',
		'US1840034853' => 'Avon',
		'US1840005166' => 'Sandy Ridge',
		'US1840001270' => 'Wall',
		'US1840035146' => 'Northwest Harborcreek',
		'US1840073738' => 'Wickerham Manor-Fisher',
		'US1840003703' => 'Lansdale',
		'US1840004809' => 'Harmonsburg',
		'US1840001302' => 'Liverpool',
		'US1840026460' => 'Baumstown',
		'US1840003509' => 'Stroudsburg',
		'US1840003431' => 'Utica',
		'US1840035390' => 'Sunrise Lake',
		'US1840005212' => 'Oneida',
		'US1840000750' => 'Forty Fort',
		'US1840000743' => 'Conyngham',
		'US1840005351' => 'Heilwood',
		'US1840001192' => 'Topton',
		'US1840035186' => 'Sanatoga',
		'US1840003458' => 'Knox',
		'US1840000668' => 'Point Marion',
		'US1840000700' => 'Lansdowne',
		'US1840026444' => 'Blandon',
		'US1840001327' => 'New Britain',
		'US1840003308' => 'Galeton',
		'US1840001465' => 'Stewartstown',
		'US1840001373' => 'Pottstown',
		'US1840035291' => 'Palmdale',
		'US1840035420' => 'Eastlawn Gardens',
		'US1840005171' => 'Brodheadsville',
		'US1840000719' => 'Greensboro',
		'US1840000618' => 'St. Marys',
		'US1840035267' => 'S.N.P.J.',
		'US1840035411' => 'Fort Indiantown Gap',
		'US1840003717' => 'Ephrata',
		'US1840004804' => 'Canadohta Lake',
		'US1840002763' => 'Mahanoy City',
		'US1840001174' => 'Centerport',
		'US1840003514' => 'Seven Fields',
		'US1840000577' => 'Laceyville',
		'US1840024336' => 'Hopeland',
		'US1840005491' => 'Gap',
		'US1840035367' => 'Woodbourne',
	],
	'RI' => [
		'US1840003364' => 'Hope Valley',
		'US1840026292' => 'Watch Hill',
		'US1840026289' => 'Carolina',
		'US1840003286' => 'Central Falls',
		'US1840026291' => 'Quonochontaug',
		'US1840026230' => 'Clayville',
		'US1840003355' => 'Newport',
		'US1840003356' => 'Melville',
		'US1840026288' => 'Wyoming',
		'US1840073472' => 'Wakefield-Peacedale',
		'US1840003288' => 'East Providence',
		'US1840026290' => 'Misquamicut',
		'US1840026257' => 'Greene',
		'US1840003292' => 'Greenville',
		'US1840003289' => 'Providence',
		'US1840003287' => 'Cranston',
		'US1840003293' => 'Harrisville',
		'US1840003291' => 'Cumberland Hill',
		'US1840003295' => 'Valley Falls',
		'US1840003294' => 'Pascoag',
		'US1840003344' => 'Warwick',
		'US1840003363' => 'Bradford',
		'US1840003365' => 'Kingston',
		'US1840026293' => 'Weekapaug',
		'US1840026229' => 'Chepachet',
		'US1840003290' => 'Woonsocket',
		'US1840003285' => 'Pawtucket',
		'US1840003362' => 'Ashaway',
		'US1840026228' => 'Harmony',
		'US1840026231' => 'Foster Center',
		'US1840003366' => 'Narragansett Pier',
		'US1840073469' => 'Newport East',
	],
	'NV' => [
		'US1840024116' => 'Lamoille',
		'US1840033755' => 'Humboldt River Ranch',
		'US1840020361' => 'Henderson',
		'US1840018826' => 'Minden',
		'US1840020363' => 'North Las Vegas',
		'US1840024129' => 'Gerlach',
		'US1840024652' => 'Pioche',
		'US1840024243' => 'Crescent Valley',
		'US1840017687' => 'Goodsprings',
		'US1840039822' => 'Fish Springs',
		'US1840024113' => 'Paradise Valley',
		'US1840039823' => 'Fort McDermitt',
		'US1840021334' => 'Winnemucca',
		'US1840033820' => 'Zephyr Cove',
		'US1840024118' => 'Oasis',
		'US1840024562' => 'Walker Lake',
		'US1840024651' => 'Panaca',
		'US1840017686' => 'Cal-Nev-Ari',
		'US1840033825' => 'Moapa Town',
		'US1840019027' => 'Searchlight',
		'US1840033809' => 'Incline Village',
		'US1840026677' => 'Gabbs',
		'US1840033827' => 'Enterprise',
		'US1840024654' => 'Ursine',
		'US1840017563' => 'Gardnerville',
		'US1840021336' => 'West Wendover',
		'US1840039790' => 'Bennett Springs',
		'US1840039841' => 'Logan Creek',
		'US1840024559' => 'Topaz Lake',
		'US1840039849' => 'Ruhenstroth',
		'US1840018705' => 'Owyhee',
		'US1840026641' => 'Virginia City',
		'US1840033828' => 'Gardnerville Ranchos',
		'US1840024555' => 'Genoa',
		'US1840033824' => 'Cold Springs',
		'US1840018828' => 'Schurz',
		'US1840033743' => 'Paradise',
		'US1840033784' => 'Golden Valley',
		'US1840073918' => 'Fallon Station',
		'US1840017561' => 'Beatty',
		'US1840039848' => 'Round Hill Village',
		'US1840033764' => 'Silver City',
		'US1840024245' => 'Austin',
		'US1840024653' => 'Rachel',
		'US1840043162' => 'Washoe Valley',
		'US1840024650' => 'Hiko',
		'US1840024561' => 'Mina',
		'US1840024358' => 'Preston',
		'US1840074790' => 'Summerlin South',
		'US1840020121' => 'Reno',
		'US1840020362' => 'Mesquite',
		'US1840033832' => 'Spring Valley',
		'US1840033826' => 'Spanish Springs',
		'US1840017531' => 'McGill',
		'US1840018796' => 'Dayton',
		'US1840021335' => 'Wells',
		'US1840018704' => 'Spring Creek',
		'US1840024119' => 'Osino',
		'US1840017689' => 'Laughlin',
		'US1840021337' => 'Sparks',
		'US1840018822' => 'Tonopah',
		'US1840017497' => 'Battle Mountain',
		'US1840039850' => 'Topaz Ranch Estates',
		'US1840018797' => 'Silver Springs',
		'US1840017684' => 'Blue Diamond',
		'US1840024249' => 'Imlay',
		'US1840020154' => 'Lovelock',
		'US1840024115' => 'Jackpot',
		'US1840033798' => 'Unionville',
		'US1840024556' => 'Glenbrook',
		'US1840024117' => 'Montello',
		'US1840018712' => 'Sutcliffe',
		'US1840020364' => 'Las Vegas',
		'US1840017479' => 'McDermitt',
		'US1840024110' => 'Denio',
		'US1840033785' => 'Lemmon Valley',
		'US1840024111' => 'Golconda',
		'US1840019025' => 'Mount Charleston',
		'US1840037104' => 'Smith Valley',
		'US1840020183' => 'Ely',
		'US1840017685' => 'Bunkerville',
		'US1840033831' => 'Moapa Valley',
		'US1840024246' => 'Kingston',
		'US1840033834' => 'Whitney',
		'US1840024130' => 'Mogul',
		'US1840020191' => 'Fallon',
		'US1840019026' => 'Sandy Valley',
		'US1840020214' => 'Fernley',
		'US1840033833' => 'Sunrise Manor',
		'US1840024127' => 'Crystal Bay',
		'US1840033778' => 'Kingsbury',
		'US1840024558' => 'Skyland',
		'US1840039799' => 'Dry Valley',
		'US1840026574' => 'Ruth',
		'US1840074502' => 'Nellis AFB',
		'US1840017688' => 'Indian Springs',
		'US1840024244' => 'Eureka',
		'US1840018856' => 'Caliente',
		'US1840021443' => 'Yerington',
		'US1840024557' => 'Lakeridge',
		'US1840024128' => 'Empire',
		'US1840033830' => 'Johnson Lane',
		'US1840033770' => 'Winchester',
		'US1840018711' => 'Sun Valley',
		'US1840039791' => 'Carter Springs',
		'US1840024649' => 'Alamo',
		'US1840018827' => 'Stateline',
		'US1840026616' => 'Stagecoach',
		'US1840020120' => 'Elko',
		'US1840024114' => 'Valmy',
		'US1840018821' => 'Pahrump',
		'US1840017564' => 'Hawthorne',
		'US1840024690' => 'Silver Peak',
		'US1840018709' => 'Nixon',
		'US1840024357' => 'Lund',
		'US1840018710' => 'Wadsworth',
		'US1840039798' => 'Double Spring',
		'US1840039843' => 'Mount Wilson',
		'US1840039807' => 'East Valley',
		'US1840039828' => 'Grass Valley',
		'US1840024131' => 'Verdi',
		'US1840033829' => 'Indian Hills',
		'US1840024689' => 'Goldfield',
		'US1840024112' => 'Orovada',
		'US1840024863' => 'Nelson',
		'US1840003826' => 'Carson City',
		'US1840039775' => 'Beaverdam',
		'US1840019028' => 'Boulder City',
		'US1840026573' => 'Baker',
		'US1840018706' => 'Carlin',
		'US1840024688' => 'Dyer',
	],
	'VA' => [
		'US1840006094' => 'Dale City',
		'US1840043275' => 'County Center',
		'US1840006392' => 'Lakeside',
		'US1840026837' => 'Montvale',
		'US1840024743' => 'Sanford',
		'US1840024792' => 'Riner',
		'US1840006002' => 'Mount Jackson',
		'US1840024731' => 'Lee Mont',
		'US1840024742' => 'Quinby',
		'US1840005876' => 'Round Hill',
		'US1840006014' => 'Burke',
		'US1840001650' => 'Fairfax',
		'US1840024810' => 'Clover',
		'US1840024700' => 'Hollymead',
		'US1840003877' => 'Galax',
		'US1840041752' => 'Franklin Farm',
		'US1840006103' => 'Haymarket',
		'US1840041864' => 'South Run',
		'US1840006101' => 'Loch Lomond',
		'US1840024751' => 'Central Garage',
		'US1840006477' => 'Westlake Corner',
		'US1840006374' => 'Blue Ridge',
		'US1840006483' => 'Pound',
		'US1840024815' => 'Ebony',
		'US1840006525' => 'Cana',
		'US1840024799' => 'Allisonia',
		'US1840006550' => 'Fieldale',
		'US1840006495' => 'Hurt',
		'US1840005893' => 'Boyce',
		'US1840006484' => 'St. Paul',
		'US1840006366' => 'Iron Gate',
		'US1840006500' => 'Waverly',
		'US1840024747' => 'Temperanceville',
		'US1840133323' => 'Rose Hill',
		'US1840006506' => 'Scottsburg',
		'US1840006416' => 'Cape Charles',
		'US1840006530' => 'Damascus',
		'US1840026707' => 'Buckhall',
		'US1840026844' => 'Enon',
		'US1840006454' => 'Richlands',
		'US1840024786' => 'Meadowbrook',
		'US1840006486' => 'Rushmere',
		'US1840024859' => 'Bracey',
		'US1840006327' => 'Onley',
		'US1840026857' => 'Concord',
		'US1840006412' => 'Appomattox',
		'US1840003872' => 'Portsmouth',
		'US1840006487' => 'Smithfield',
		'US1840006449' => 'Claypool Hill',
		'US1840006455' => 'Tazewell',
		'US1840006497' => 'Kenbridge',
		'US1840041878' => 'Thynedale',
		'US1840006241' => 'Crimora',
		'US1840006372' => 'Madison Heights',
		'US1840006531' => 'Dryden',
		'US1840024497' => 'Brambleton',
		'US1840023873' => 'Catlett',
		'US1840003875' => 'Emporia',
		'US1840041712' => 'Cascades',
		'US1840006247' => 'Stuarts Draft',
		'US1840003878' => 'Danville',
		'US1840024573' => 'Hayfield',
		'US1840006375' => 'Cloverdale',
		'US1840006514' => 'Chilhowie',
		'US1840073580' => 'Fort Lee',
		'US1840006481' => 'Big Stone Gap',
		'US1840006321' => 'Belle Haven',
		'US1840024721' => 'Boston',
		'US1840006326' => 'Onancock',
		'US1840043127' => 'Marumsco',
		'US1840043215' => 'Lake Wilderness',
		'US1840006437' => 'Timberlake',
		'US1840026886' => 'Blairs',
		'US1840006388' => 'East Highland Park',
		'US1840041713' => 'Crosspointe',
		'US1840003864' => 'Radford',
		'US1840006216' => 'Aquia Harbour',
		'US1840006312' => 'Louisa',
		'US1840026795' => 'Heathsville',
		'US1840006239' => 'Stanardsville',
		'US1840003856' => 'Vinton',
		'US1840024684' => 'Deerfield',
		'US1840006438' => 'Altavista',
		'US1840006390' => 'Glen Allen',
		'US1840006504' => 'Wytheville',
		'US1840006451' => 'Bluefield',
		'US1840003874' => 'Chesapeake',
		'US1840024717' => 'Wintergreen',
		'US1840006517' => 'Boykins',
		'US1840024805' => 'Snowville',
		'US1840026775' => 'Free Union',
		'US1840026826' => 'Sandston',
		'US1840006215' => 'Falmouth',
		'US1840024730' => 'Horntown',
		'US1840006282' => 'Colonial Beach',
		'US1840006527' => 'Woodlawn',
		'US1840024683' => 'Churchville',
		'US1840024749' => 'Whitesville',
		'US1840006556' => 'Laurel Park',
		'US1840026696' => 'Apple Mountain Lake',
		'US1840006478' => 'Boones Mill',
		'US1840026719' => 'Belmont Estates',
		'US1840006533' => 'Keokee',
		'US1840024574' => 'Kings Park',
		'US1840006396' => 'Wyndham',
		'US1840001721' => 'Fairlawn',
		'US1840006314' => 'Warsaw',
		'US1840026890' => 'Sussex',
		'US1840006139' => 'Timberville',
		'US1840006408' => 'Bensley',
		'US1840006001' => 'Edinburg',
		'US1840024789' => 'Elliston',
		'US1840003860' => 'Colonial Heights',
		'US1840006005' => 'Toms Brook',
		'US1840024814' => 'Riverdale',
		'US1840073661' => 'Quantico Base',
		'US1840006554' => 'Oak Level',
		'US1840006493' => 'Gretna',
		'US1840006539' => 'Clarksville',
		'US1840006555' => 'Horse Pasture',
		'US1840006323' => 'Chincoteague',
		'US1840043222' => 'Lake Caroline',
		'US1840026779' => 'Hot Springs',
		'US1840006417' => 'Cheriton',
		'US1840006414' => 'Eastville',
		'US1840024592' => 'Marshall',
		'US1840041846' => 'Moorefield Station',
		'US1840024724' => 'Chase Crossing',
		'US1840024501' => 'Dulles Town Center',
		'US1840006397' => 'New Castle',
		'US1840006444' => 'Yorktown',
		'US1840026885' => 'Dante',
		'US1840006304' => 'Port Royal',
		'US1840006000' => 'Basye',
		'US1840006528' => 'Glade Spring',
		'US1840006536' => 'St. Charles',
		'US1840003850' => 'Urbanna',
		'US1840006038' => 'Seven Corners',
		'US1840037353' => 'Riverview',
		'US1840041768' => 'George Mason',
		'US1840006169' => 'Culpeper',
		'US1840037463' => 'Troutdale',
		'US1840005777' => 'Stephens City',
		'US1840006464' => 'Drakes Branch',
		'US1840006534' => 'Jonesville',
		'US1840006042' => 'Wolf Trap',
		'US1840006515' => 'Marion',
		'US1840041774' => 'Long Branch',
		'US1840024686' => 'Mount Sidney',
		'US1840003844' => 'Harrisonburg',
		'US1840024569' => 'Floris',
		'US1840006003' => 'New Market',
		'US1840003867' => 'Wakefield',
		'US1840026891' => 'Ivanhoe',
		'US1840006022' => 'North Springfield',
		'US1840024785' => 'Manchester',
		'US1840024504' => 'Lowes Island',
		'US1840006377' => 'Laymantown',
		'US1840026717' => 'Sperryville',
		'US1840006544' => 'Gate City',
		'US1840003848' => 'Waynesboro',
		'US1840006095' => 'Montclair',
		'US1840006468' => 'Dublin',
		'US1840041693' => 'Camptown',
		'US1840024746' => 'Tasley',
		'US1840024723' => 'Cats Bridge',
		'US1840006498' => 'Jarratt',
		'US1840003876' => 'Franklin',
		'US1840005871' => 'Hillsboro',
		'US1840037349' => 'Merrimac',
		'US1840006322' => 'Bloxom',
		'US1840024594' => 'New Baltimore',
		'US1840006443' => 'Farmville',
		'US1840006513' => 'Sugar Grove',
		'US1840006018' => 'McLean',
		'US1840006039' => 'Springfield',
		'US1840026778' => 'Warm Springs',
		'US1840005872' => 'Leesburg',
		'US1840024584' => 'Woodburn',
		'US1840006245' => 'Lyndhurst',
		'US1840024808' => 'Carrollton',
		'US1840001665' => 'Fairview Beach',
		'US1840006104' => 'Sudley',
		'US1840003868' => 'Virgilina',
		'US1840003862' => 'Newport News',
		'US1840006107' => 'Yorkshire',
		'US1840041769' => 'Kings Park West',
		'US1840006472' => 'Surry',
		'US1840005870' => 'Hamilton',
		'US1840024737' => 'Nelsonia',
		'US1840006035' => 'Lorton',
		'US1840037472' => 'Pantops',
		'US1840006365' => 'Clifton Forge',
		'US1840006246' => 'Sherando',
		'US1840006462' => 'Crewe',
		'US1840006099' => 'Lake Ridge',
		'US1840024738' => 'New Church',
		'US1840006376' => 'Daleville',
		'US1840024589' => 'Bealeton',
		'US1840024494' => 'Arcola',
		'US1840006467' => 'Phenix',
		'US1840006033' => 'Lake Barcroft',
		'US1840024750' => 'Callaghan',
		'US1840026669' => 'Shenandoah Retreat',
		'US1840003839' => 'Manassas',
		'US1840003829' => 'Vienna',
		'US1840006373' => 'Amherst',
		'US1840003835' => 'Falls Church',
		'US1840006096' => 'Nokesville',
		'US1840006100' => 'Linton Hall',
		'US1840006138' => 'Mount Crawford',
		'US1840005776' => 'Middletown',
		'US1840006244' => 'Jolivue',
		'US1840006248' => 'Verona',
		'US1840006006' => 'Woodstock',
		'US1840024718' => 'Atlantic',
		'US1840006331' => 'Tangier',
		'US1840026797' => 'Palmyra',
		'US1840026869' => 'Prince George',
		'US1840006432' => 'Narrows',
		'US1840024572' => 'Greenbriar',
		'US1840024860' => 'Fairview',
		'US1840006032' => 'Idylwood',
		'US1840001699' => 'Ettrick',
		'US1840026711' => 'Potomac Mills',
		'US1840037380' => 'Hampden-Sydney',
		'US1840026712' => 'Cherry Hill',
		'US1840006546' => 'Nickelsville',
		'US1840026698' => 'Shenandoah Shores',
		'US1840006548' => 'Patrick Springs',
		'US1840006329' => 'Parksley',
		'US1840006143' => 'Stanley',
		'US1840006186' => 'Madison',
		'US1840006037' => 'Herndon',
		'US1840006435' => 'Rich Creek',
		'US1840006516' => 'Saltville',
		'US1840024739' => 'Oak Hall',
		'US1840003851' => 'Buena Vista',
		'US1840026848' => 'Gwynn',
		'US1840043173' => 'Bethel Manor',
		'US1840006102' => 'Dumfries',
		'US1840006457' => 'Haysi',
		'US1840041851' => 'Piney Mountain',
		'US1840006526' => 'Hillsville',
		'US1840024816' => 'Gasburg',
		'US1840024498' => 'Broadlands',
		'US1840006130' => 'Washington',
		'US1840006045' => 'Front Royal',
		'US1840037404' => 'Shawneeland',
		'US1840026776' => 'Ivy',
		'US1840041682' => 'Buckingham Courthouse',
		'US1840026690' => 'Maurertown',
		'US1840005892' => 'Berryville',
		'US1840006512' => 'Atkins',
		'US1840006394' => 'Short Pump',
		'US1840026786' => 'Blue Ridge Shores',
		'US1840006395' => 'Tuckahoe',
		'US1840006109' => 'Quantico',
		'US1840024790' => 'Lafayette',
		'US1840006280' => 'Crozet',
		'US1840006492' => 'Lebanon',
		'US1840026697' => 'Skyland Estates',
		'US1840006557' => 'Sandy Level',
		'US1840006537' => 'Boydton',
		'US1840026816' => 'Saluda',
		'US1840006476' => 'Union Hall',
		'US1840024862' => 'Union Level',
		'US1840006418' => 'Nassawadox',
		'US1840024510' => 'Sugarland Run',
		'US1840041775' => 'Loudoun Valley Estates',
		'US1840006106' => 'Woodbridge',
		'US1840026796' => 'Hanover',
		'US1840001726' => 'Ewing',
		'US1840026750' => 'Ruckersville',
		'US1840006490' => 'Honaker',
		'US1840006529' => 'Abingdon',
		'US1840006553' => 'Collinsville',
		'US1840001719' => 'Salem',
		'US1840005874' => 'Middleburg',
		'US1840041683' => 'Burke Centre',
		'US1840006019' => 'Merrifield',
		'US1840006240' => 'Fishersville',
		'US1840024806' => 'Benns Church',
		'US1840006267' => 'Gordonsville',
		'US1840006551' => 'Bassett',
		'US1840006108' => 'Occoquan',
		'US1840026810' => 'Goochland',
		'US1840006508' => 'Alberta',
		'US1840041865' => 'Southside Chesconessex',
		'US1840006441' => 'Hollins',
		'US1840006384' => 'Dillwyn',
		'US1840003869' => 'Norfolk',
		'US1840024735' => 'Metompkin',
		'US1840006058' => 'Warrenton',
		'US1840005875' => 'Purcellville',
		'US1840006243' => 'Greenville',
		'US1840024713' => 'Lovingston',
		'US1840026859' => 'Glenvar',
		'US1840003858' => 'Roanoke',
		'US1840006538' => 'Chase City',
		'US1840003837' => 'Alexandria',
		'US1840006520' => 'Courtland',
		'US1840006429' => 'Grundy',
		'US1840006369' => 'Irvington',
		'US1840026817' => 'Deltaville',
		'US1840006559' => 'Villa Heights',
		'US1840006547' => 'Weber City',
		'US1840006496' => 'Floyd',
		'US1840001713' => 'Bedford',
		'US1840006281' => 'Scottsville',
		'US1840006502' => 'Max Meadows',
		'US1840001670' => 'Staunton',
		'US1840037448' => 'Yogaville',
		'US1840024500' => 'Countryside',
		'US1840006325' => 'Melfa',
		'US1840026752' => 'Harriston',
		'US1840026868' => 'Gratton',
		'US1840006342' => 'Lake Monticello',
		'US1840006136' => 'Broadway',
		'US1840006266' => 'Dahlgren',
		'US1840037427' => 'Powhatan',
		'US1840024740' => 'Pastoria',
		'US1840001678' => 'Charlottesville',
		'US1840006134' => 'Grottoes',
		'US1840026887' => 'Motley',
		'US1840026851' => 'Charles City',
		'US1840006511' => 'Adwolf',
		'US1840006303' => 'Bowling Green',
		'US1840024566' => 'Fairfax Station',
		'US1840005873' => 'Lovettsville',
		'US1840041868' => 'Stone Ridge',
		'US1840026716' => 'Flint Hill',
		'US1840006488' => 'Windsor',
		'US1840006021' => 'Newington',
		'US1840026871' => 'Bland',
		'US1840003863' => 'Poquoson',
		'US1840006112' => 'Arlington',
		'US1840024748' => 'Wattsville',
		'US1840006041' => 'West Springfield',
		'US1840024801' => 'Draper',
		'US1840041770' => 'Kingstowne',
		'US1840024720' => 'Bobtown',
		'US1840024813' => 'Nathalie',
		'US1840006522' => 'Newsoms',
		'US1840026888' => 'Mount Hermon',
		'US1840026876' => 'Scotland',
		'US1840006137' => 'Dayton',
		'US1840043136' => 'Neabsco',
		'US1840024725' => 'Deep Creek',
		'US1840024809' => 'Carrsville',
		'US1840073578' => 'Fort Belvoir',
		'US1840006463' => 'McKenney',
		'US1840006499' => 'Stony Creek',
		'US1840041858' => 'Rockwood',
		'US1840006482' => 'Coeburn',
		'US1840026872' => 'Nottoway Court House',
		'US1840024685' => 'Middlebrook',
		'US1840041848' => 'Newington Forest',
		'US1840026850' => 'Amelia Court House',
		'US1840006411' => 'Matoaca',
		'US1840006367' => 'West Point',
		'US1840006011' => 'Annandale',
		'US1840024733' => 'Mappsburg',
		'US1840006135' => 'Bridgewater',
		'US1840024784' => 'Brandermill',
		'US1840024803' => 'New River',
		'US1840024712' => 'Arrington',
		'US1840026774' => 'Esmont',
		'US1840006393' => 'Laurel',
		'US1840006458' => 'Clinchco',
		'US1840026877' => 'Henry Fork',
		'US1840024508' => 'Sterling',
		'US1840024729' => 'Harborton',
		'US1840024811' => 'Cluster Springs',
		'US1840006407' => 'Bellwood',
		'US1840024817' => 'Warfield',
		'US1840006319' => 'Hallwood',
		'US1840006410' => 'Chester',
		'US1840006117' => 'West Falls Church',
		'US1840025639' => 'Laurel Hill',
		'US1840006543' => 'Dungannon',
		'US1840026870' => 'Templeton',
		'US1840024496' => 'Belmont',
		'US1840006466' => 'Keysville',
		'US1840006545' => 'Clinchport',
		'US1840006509' => 'Brodnax',
		'US1840024744' => 'Savage Town',
		'US1840006371' => 'White Stone',
		'US1840006031' => 'Hybla Valley',
		'US1840006364' => 'Selma',
		'US1840041837' => 'Meadow View',
		'US1840006399' => 'Gloucester Point',
		'US1840006379' => 'Buchanan',
		'US1840026889' => 'Lunenburg',
		'US1840003873' => 'Suffolk',
		'US1840006004' => 'Strasburg',
		'US1840026699' => 'Shenandoah Farms',
		'US1840006024' => 'Pimmit Hills',
		'US1840024736' => 'Modest Town',
		'US1840026758' => 'King George',
		'US1840006540' => 'La Crosse',
		'US1840037468' => 'Gloucester Courthouse',
		'US1840037327' => 'Baileys Crossroads',
		'US1840006480' => 'Appalachia',
		'US1840006391' => 'Highland Springs',
		'US1840006016' => 'Chantilly',
		'US1840003865' => 'Victoria',
		'US1840006027' => 'Franconia',
		'US1840006549' => 'Stuart',
		'US1840003845' => 'Fredericksburg',
		'US1840024741' => 'Pungoteague',
		'US1840006313' => 'Mineral',
		'US1840006023' => 'Oakton',
		'US1840006561' => 'Fries',
		'US1840024511' => 'University Center',
		'US1840024590' => 'Calverton',
		'US1840043221' => 'Lake LandOr',
		'US1840024734' => 'Mappsville',
		'US1840024568' => 'Fair Oaks',
		'US1840006098' => 'Gainesville',
		'US1840042948' => 'Lake of the Woods',
		'US1840024682' => 'Augusta Springs',
		'US1840024745' => 'Savageville',
		'US1840006142' => 'Shenandoah',
		'US1840006214' => 'Monterey',
		'US1840006524' => 'Fancy Gap',
		'US1840006552' => 'Chatmoss',
		'US1840006562' => 'Independence',
		'US1840024728' => 'Greenbush',
		'US1840006542' => 'Duffield',
		'US1840003866' => 'Hampton',
		'US1840026906' => 'Sedley',
		'US1840140574' => 'University of Virginia',
		'US1840026899' => 'McMullin',
		'US1840037461' => 'South Boston',
		'US1840006025' => 'Reston',
		'US1840041862' => 'Southern Gateway',
		'US1840024506' => 'Oak Grove',
		'US1840006445' => 'Shawsville',
		'US1840006433' => 'Pearisburg',
		'US1840006465' => 'Charlotte Court House',
		'US1840006034' => 'Lincolnia',
		'US1840006311' => 'Tappahannock',
		'US1840001698' => 'Richmond',
		'US1840026751' => 'Twin Lakes',
		'US1840006269' => 'Spotsylvania Courthouse',
		'US1840026820' => 'Cumberland',
		'US1840006535' => 'Pennington Gap',
		'US1840001727' => 'Martinsville',
		'US1840006436' => 'Rustburg',
		'US1840006341' => 'Ashland',
		'US1840026720' => 'Massanetta Springs',
		'US1840024726' => 'Gargatha',
		'US1840006141' => 'Luray',
		'US1840001688' => 'Covington',
		'US1840024507' => 'South Riding',
		'US1840006453' => 'Pocahontas',
		'US1840037417' => 'Pamplin City',
		'US1840006249' => 'Weyers Cave',
		'US1840026845' => 'Woodlake',
		'US1840006439' => 'Brookneal',
		'US1840006446' => 'Blacksburg',
		'US1840041817' => 'Mason Neck',
		'US1840006093' => 'Bull Run',
		'US1840006105' => 'Triangle',
		'US1840001720' => 'Williamsburg',
		'US1840006398' => 'Forest',
		'US1840006519' => 'Capron',
		'US1840006020' => 'Mount Vernon',
		'US1840006461' => 'Burkeville',
		'US1840003861' => 'Petersburg',
		'US1840006503' => 'Rural Retreat',
		'US1840006470' => 'Dendron',
		'US1840006017' => 'Dunn Loring',
		'US1840006316' => 'Goshen',
		'US1840006242' => 'Dooms',
		'US1840006452' => 'Cedar Bluff',
		'US1840024716' => 'Shipman',
		'US1840006440' => 'Cave Spring',
		'US1840006378' => 'Fincastle',
		'US1840006268' => 'Orange',
		'US1840006409' => 'Bon Air',
		'US1840041677' => 'Belview',
		'US1840026759' => 'Passapatanzy',
		'US1840003855' => 'Lynchburg',
		'US1840006541' => 'South Hill',
		'US1840006057' => 'The Plains',
		'US1840006521' => 'Ivor',
		'US1840006415' => 'Exmore',
		'US1840037471' => 'Plum Creek',
		'US1840041867' => 'Stafford Courthouse',
		'US1840003870' => 'Norton',
		'US1840024687' => 'New Hope',
		'US1840024495' => 'Ashburn',
		'US1840006459' => 'Clintwood',
		'US1840024791' => 'Prices Fork',
		'US1840024804' => 'Parrott',
		'US1840003849' => 'Wachapreague',
		'US1840006324' => 'Keller',
		'US1840026738' => 'Brightwood',
		'US1840026835' => 'New Kent',
		'US1840006469' => 'Pulaski',
		'US1840037426' => 'Lancaster',
		'US1840006471' => 'Claremont',
		'US1840006036' => 'Mantua',
		'US1840006434' => 'Pembroke',
		'US1840024714' => 'Nellysford',
		'US1840026718' => 'Chester Gap',
		'US1840006474' => 'North Shore',
		'US1840006010' => 'Fort Hunt',
		'US1840024858' => 'Baskerville',
		'US1840037378' => 'Fort Chiswell',
		'US1840006370' => 'Kilmarnock',
		'US1840006485' => 'Wise',
		'US1840041794' => 'McNair',
		'US1840024565' => 'Dranesville',
		'US1840006315' => 'Glasgow',
		'US1840006363' => 'Low Moor',
		'US1840006430' => 'Vansant',
		'US1840042829' => 'Innsbrook',
		'US1840006250' => 'Craigsville',
		'US1840037466' => 'Chamberlayne',
		'US1840006330' => 'Saxis',
		'US1840003838' => 'Manassas Park',
		'US1840003859' => 'Hopewell',
		'US1840003879' => 'Bristol',
		'US1840024593' => 'Midland',
		'US1840006380' => 'Troutville',
		'US1840006558' => 'Stanleytown',
		'US1840026849' => 'Mathews',
		'US1840003871' => 'Virginia Beach',
		'US1840006328' => 'Painter',
		'US1840001689' => 'Lexington',
		'US1840006447' => 'Christiansburg',
		'US1840006431' => 'Glen Lyn',
		'US1840006510' => 'Lawrenceville',
		'US1840041853' => 'Rivanna',
		'US1840024800' => 'Belspring',
		'US1840006028' => 'Great Falls',
		'US1840024581' => 'Ravensworth',
		'US1840024719' => 'Bayside',
		'US1840006473' => 'Ferrum',
		'US1840006343' => 'Columbia',
		'US1840043223' => 'Lake Holiday',
		'US1840024732' => 'Makemie Park',
		'US1840006560' => 'Ridgeway',
		'US1840006132' => 'Massanutten',
		'US1840006518' => 'Branchville',
		'US1840026708' => 'Independent Hill',
		'US1840001623' => 'Winchester',
		'US1840006015' => 'Centreville',
		'US1840006450' => 'Raven',
		'US1840006056' => 'Remington',
		'US1840026706' => 'Bull Run Mountain Estates',
		'US1840024722' => 'Captains Cove',
		'US1840024812' => 'Mountain Road',
		'US1840024595' => 'Opal',
		'US1840041773' => 'Lansdowne',
		'US1840026792' => 'East Lexington',
		'US1840006491' => 'Cleveland',
		'US1840006505' => 'Halifax',
		'US1840006460' => 'Blackstone',
		'US1840006133' => 'Elkton',
		'US1840006479' => 'Rocky Mount',
		'US1840006043' => 'Clifton',
		'US1840024715' => 'Schuyler',
		'US1840026804' => 'King and Queen Court House',
		'US1840024727' => 'Greenbackville',
		'US1840024856' => 'Emory',
		'US1840006475' => 'Penhook',
		'US1840026809' => 'King William',
		'US1840026867' => 'Springville',
		'US1840026836' => 'Big Island',
		'US1840006340' => 'Mechanicsville',
		'US1840006489' => 'Castlewood',
		'US1840006029' => 'Groveton',
		'US1840043194' => 'Dahlgren Center',
		'US1840026900' => 'Seven Mile Ford',
		'US1840006030' => 'Huntington',
		'US1840006320' => 'Accomac',
		'US1840006283' => 'Montross',
		'US1840041732' => 'Fair Lakes',
		'US1840006387' => 'Dumbarton',
		'US1840006494' => 'Chatham',
		'US1840024802' => 'Hiwassee',
		'US1840006389' => 'Montrose',
	],
	'CO' => [
		'US1840022567' => 'Sanford',
		'US1840018794' => 'Aurora',
		'US1840017588' => 'Avondale',
		'US1840024757' => 'Alpine',
		'US1840022470' => 'Pitkin',
		'US1840028464' => 'Smeltertown',
		'US1840020221' => 'Bethune',
		'US1840020197' => 'Golden',
		'US1840024550' => 'Divide',
		'US1840074894' => 'City of Creede',
		'US1840024283' => 'Amherst',
		'US1840022426' => 'Ward',
		'US1840022533' => 'Norwood',
		'US1840021367' => 'Grover',
		'US1840024705' => 'La Junta Gardens',
		'US1840020193' => 'Bennett',
		'US1840024349' => 'Sugarloaf',
		'US1840022554' => 'Walsh',
		'US1840026646' => 'Elbert',
		'US1840020179' => 'Louisville',
		'US1840021449' => 'Elizabeth',
		'US1840024350' => 'Valmont',
		'US1840024704' => 'Hasty',
		'US1840020164' => 'Holyoke',
		'US1840018789' => 'Denver',
		'US1840028527' => 'St. Ann Highlands',
		'US1840028578' => 'Gleneagle',
		'US1840135257' => 'Columbine',
		'US1840022396' => 'Mead',
		'US1840021370' => 'Keenesburg',
		'US1840024707' => 'Cathedral',
		'US1840028444' => 'Columbine Valley',
		'US1840022402' => 'Oak Creek',
		'US1840022511' => 'Ordway',
		'US1840024763' => 'Segundo',
		'US1840020230' => 'Grand Junction',
		'US1840021422' => 'Thornton',
		'US1840024659' => 'Brandon',
		'US1840022502' => 'Coal Creek',
		'US1840024759' => 'El Moro',
		'US1840021464' => 'Crested Butte',
		'US1840018785' => 'Commerce City',
		'US1840020270' => 'La Junta',
		'US1840026647' => 'Guffey',
		'US1840024769' => 'Lewis',
		'US1840021379' => 'Fleming',
		'US1840021541' => 'Rico',
		'US1840024318' => 'Idalia',
		'US1840021410' => 'Kremmling',
		'US1840022435' => 'Montezuma',
		'US1840024660' => 'Towner',
		'US1840028437' => 'Leyner',
		'US1840021470' => 'Green Mountain Falls',
		'US1840021371' => 'Kersey',
		'US1840018743' => 'Red Feather Lakes',
		'US1840028582' => 'Stratmoor',
		'US1840028570' => 'Stonegate',
		'US1840020267' => 'Lamar',
		'US1840021510' => 'Saguache',
		'US1840024322' => 'Vernon',
		'US1840028523' => 'Seven Hills',
		'US1840022434' => 'Vail',
		'US1840038713' => 'Floyd Hill',
		'US1840028436' => 'Crisman',
		'US1840028525' => 'Hidden Lake',
		'US1840022545' => 'Cokedale',
		'US1840028435' => 'Sunshine',
		'US1840021440' => 'Sheridan',
		'US1840028588' => 'Cherry Creek',
		'US1840024241' => 'Maybell',
		'US1840020196' => 'Edgewater',
		'US1840036508' => 'Air Force Academy',
		'US1840017526' => 'Allenspark',
		'US1840021547' => 'Kim',
		'US1840022550' => 'Campo',
		'US1840028481' => 'Stonewall Gap',
		'US1840036558' => 'Alamosa East',
		'US1840028568' => 'Roxborough Park',
		'US1840017587' => 'Colorado City',
		'US1840021578' => 'La Jara',
		'US1840021448' => 'Larkspur',
		'US1840021468' => 'Woodland Park',
		'US1840022467' => 'Snowmass Village',
		'US1840021546' => 'Aguilar',
		'US1840021412' => 'Wray',
		'US1840028571' => 'Todd Creek',
		'US1840021469' => 'Ramah',
		'US1840017556' => 'Clifton',
		'US1840024363' => 'Dotsero',
		'US1840017496' => 'Atwood',
		'US1840028433' => 'Altona',
		'US1840022455' => 'Castle Rock',
		'US1840022544' => 'South Fork',
		'US1840018927' => 'Towaoc',
		'US1840021521' => 'Holly',
		'US1840017539' => 'Evergreen',
		'US1840018793' => 'Cherry Hills Village',
		'US1840028586' => 'Shaw Heights',
		'US1840022532' => 'Mountain Village',
		'US1840028526' => 'Mountain Meadows',
		'US1840024360' => 'Cattle Creek',
		'US1840021535' => 'Walsenburg',
		'US1840020258' => 'Ouray',
		'US1840018806' => 'Burlington',
		'US1840018823' => 'Cripple Creek',
		'US1840020192' => 'Northglenn',
		'US1840020150' => 'Ault',
		'US1840022466' => 'Collbran',
		'US1840021482' => 'Kit Carson',
		'US1840024484' => 'Norrie',
		'US1840022535' => 'Sawpit',
		'US1840018825' => 'Colorado Springs',
		'US1840022506' => 'Olathe',
		'US1840026737' => 'Redvale',
		'US1840022468' => 'Marble',
		'US1840021427' => 'Blue River',
		'US1840022397' => 'Milliken',
		'US1840038703' => 'Fairmount',
		'US1840028590' => 'Holly Hills',
		'US1840021545' => 'Trinidad',
		'US1840021361' => 'Raymer',
		'US1840021369' => 'Johnstown',
		'US1840022421' => 'Winter Park',
		'US1840028566' => 'North Washington',
		'US1840022516' => 'Moffat',
		'US1840022465' => 'Palisade',
		'US1840024364' => 'Fulford',
		'US1840021381' => 'Julesburg',
		'US1840038683' => 'Dakota Ridge',
		'US1840022551' => 'Springfield',
		'US1840038805' => 'Southern Ute',
		'US1840028452' => 'Grand View Estates',
		'US1840022512' => 'Sugar City',
		'US1840020237' => 'Manitou Springs',
		'US1840021452' => 'Hugo',
		'US1840074359' => 'Downieville-Lawson-Dumont',
		'US1840022405' => 'Merino',
		'US1840028585' => 'No Name',
		'US1840028565' => 'Meridian',
		'US1840017538' => 'Aspen Park',
		'US1840021415' => 'Akron',
		'US1840028592' => 'Mulford',
		'US1840022536' => 'Telluride',
		'US1840028573' => 'Applewood',
		'US1840024764' => 'Valdez',
		'US1840020235' => 'Gunnison',
		'US1840021424' => 'Eagle',
		'US1840024587' => 'Johnson Village',
		'US1840022528' => 'Swink',
		'US1840022423' => 'Lyons',
		'US1840018786' => 'Central City',
		'US1840022451' => 'Seibert',
		'US1840021409' => 'Hot Sulphur Springs',
		'US1840022436' => 'Silverthorne',
		'US1840024486' => 'Woody Creek',
		'US1840020229' => 'Fruita',
		'US1840038781' => 'Saddle Ridge',
		'US1840018741' => 'Craig',
		'US1840018813' => 'Aspen',
		'US1840022407' => 'Ovid',
		'US1840018928' => 'Cortez',
		'US1840021473' => 'Salida',
		'US1840020153' => 'Berthoud',
		'US1840022433' => 'Minturn',
		'US1840022422' => 'Otis',
		'US1840021474' => 'Poncha Springs',
		'US1840024677' => 'Blende',
		'US1840021548' => 'Hooper',
		'US1840021372' => 'La Salle',
		'US1840017528' => 'Eldorado Springs',
		'US1840024551' => 'Florissant',
		'US1840024305' => 'Parshall',
		'US1840021363' => 'Firestone',
		'US1840038727' => 'Jackson Lake',
		'US1840017529' => 'Gold Hill',
		'US1840021413' => 'Yuma',
		'US1840021542' => 'Del Norte',
		'US1840020299' => 'Monte Vista',
		'US1840021455' => 'Fairplay',
		'US1840021472' => 'Buena Vista',
		'US1840024303' => 'Weldona',
		'US1840022404' => 'Walden',
		'US1840024695' => 'Colona',
		'US1840024645' => 'Howard',
		'US1840021428' => 'Breckenridge',
		'US1840021465' => 'Crawford',
		'US1840022505' => 'Nucla',
		'US1840017540' => 'Indian Hills',
		'US1840028560' => 'Aristocrat Ranchettes',
		'US1840021502' => 'Crowley',
		'US1840021377' => 'Sterling',
		'US1840038650' => 'Comanche Creek',
		'US1840022410' => 'Timnath',
		'US1840024678' => 'Vineland',
		'US1840022411' => 'Wellington',
		'US1840018861' => 'Salt Creek',
		'US1840022438' => 'Mountain View',
		'US1840028581' => 'Sherrelwood',
		'US1840022504' => 'Naturita',
		'US1840018811' => 'Orchard Mesa',
		'US1840020211' => 'Englewood',
		'US1840022456' => 'Castle Pines',
		'US1840022420' => 'Wiggins',
		'US1840021495' => 'Eads',
		'US1840022471' => 'Orchard City',
		'US1840021512' => 'Ridgway',
		'US1840018784' => 'Brighton',
		'US1840038588' => 'Aetna Estates',
		'US1840024553' => 'Midland',
		'US1840024768' => 'San Acacio',
		'US1840028453' => 'Ponderosa Park',
		'US1840021393' => 'Haxtun',
		'US1840021520' => 'Hartman',
		'US1840022437' => 'Morrison',
		'US1840022534' => 'Ophir',
		'US1840028524' => 'Bark Ranch',
		'US1840022526' => 'Manzanola',
		'US1840024321' => 'Laird',
		'US1840021466' => 'Hotchkiss',
		'US1840028522' => 'Tall Timber',
		'US1840038615' => 'Blue Sky',
		'US1840021509' => 'Crestone',
		'US1840022525' => 'Westcliffe',
		'US1840021500' => 'Boone',
		'US1840018929' => 'Durango',
		'US1840028584' => 'Woodmoor',
		'US1840020198' => 'Lakewood',
		'US1840022439' => 'Silver Plume',
		'US1840020255' => 'Pueblo',
		'US1840021454' => 'Alma',
		'US1840024758' => 'Gerrard',
		'US1840021376' => 'Dinosaur',
		'US1840021450' => 'Kiowa',
		'US1840022398' => 'Nunn',
		'US1840022549' => 'San Luis',
		'US1840028489' => 'Rock Creek Park',
		'US1840018742' => 'Padroni',
		'US1840017541' => 'Kittredge',
		'US1840026665' => 'Loma',
		'US1840021461' => 'De Beque',
		'US1840018807' => 'Sedalia',
		'US1840024760' => 'Hoehne',
		'US1840021380' => 'Iliff',
		'US1840021453' => 'Limon',
		'US1840020250' => 'Florence',
		'US1840022524' => 'Silver Cliff',
		'US1840026689' => 'Ellicott',
		'US1840018787' => 'Black Hawk',
		'US1840028579' => 'Highlands Ranch',
		'US1840028591' => 'Inverness',
		'US1840017543' => 'Byers',
		'US1840018740' => 'Dacono',
		'US1840022427' => 'Meeker',
		'US1840020212' => 'Greenwood Village',
		'US1840020149' => 'Greeley',
		'US1840021441' => 'Deer Trail',
		'US1840022429' => 'New Castle',
		'US1840021501' => 'Rye',
		'US1840024643' => 'Coaldale',
		'US1840028589' => 'Dove Valley',
		'US1840022523' => 'Wiley',
		'US1840021414' => 'Eckley',
		'US1840024301' => 'Orchard',
		'US1840020184' => 'Glenwood Springs',
		'US1840021406' => 'Fraser',
		'US1840018921' => 'Alamosa',
		'US1840024706' => 'North La Junta',
		'US1840022546' => 'Starkville',
		'US1840021451' => 'Genoa',
		'US1840028521' => 'Pine Brook Hill',
		'US1840021425' => 'Red Cliff',
		'US1840024696' => 'Portland',
		'US1840021375' => 'Hayden',
		'US1840020236' => 'Fountain',
		'US1840028562' => 'Beulah Valley',
		'US1840021536' => 'La Veta',
		'US1840020269' => 'Rocky Ford',
		'US1840022507' => 'Sheridan Lake',
		'US1840020185' => 'Rifle',
		'US1840021373' => 'Lochbuie',
		'US1840024586' => 'Garfield',
		'US1840021556' => 'Pritchett',
		'US1840021555' => 'Blanca',
		'US1840022408' => 'Sedgwick',
		'US1840024644' => 'Cotopaxi',
		'US1840021430' => 'Frisco',
		'US1840038747' => 'Piedra',
		'US1840022510' => 'Olney Springs',
		'US1840018774' => 'Boulder',
		'US1840022432' => 'Silt',
		'US1840017626' => 'Fort Garland',
		'US1840028593' => 'Castle Pines Village',
		'US1840024240' => 'Phippsburg',
		'US1840021544' => 'Branson',
		'US1840022453' => 'Vona',
		'US1840028561' => 'Berkley',
		'US1840021447' => 'Flagler',
		'US1840021439' => 'Bow Mar',
		'US1840021442' => 'Foxfield',
		'US1840022399' => 'Pierce',
		'US1840020178' => 'Longmont',
		'US1840018792' => 'Centennial',
		'US1840021558' => 'Ignacio',
		'US1840022431' => 'Carbondale',
		'US1840038739' => 'Morgan Heights',
		'US1840018812' => 'Redlands',
		'US1840022566' => 'Manassa',
		'US1840018795' => 'Strasburg',
		'US1840018853' => 'Lincoln Park',
		'US1840020228' => 'Leadville',
		'US1840020223' => 'Arriba',
		'US1840017551' => 'Louviers',
		'US1840073905' => 'Cascade-Chipita Park',
		'US1840026862' => 'Conejos',
		'US1840021407' => 'Granby',
		'US1840017532' => 'Battlement Mesa',
		'US1840018855' => 'Cañon City',
		'US1840024485' => 'Redstone',
		'US1840038833' => 'Upper Bear Creek',
		'US1840017562' => 'Black Forest',
		'US1840021417' => 'Rangely',
		'US1840038822' => 'Trail Side',
		'US1840021528' => 'Lake City',
		'US1840028528' => 'Bonanza Mountain Estates',
		'US1840021360' => 'Platteville',
		'US1840018820' => 'Delta',
		'US1840022413' => 'Paoli',
		'US1840021404' => 'Hillrose',
		'US1840021374' => 'Steamboat Springs',
		'US1840028583' => 'The Pinery',
		'US1840024362' => 'Rollinsville',
		'US1840021519' => 'Granada',
		'US1840017535' => 'Edwards',
		'US1840024320' => 'Kirk',
		'US1840018790' => 'Idaho Springs',
		'US1840028569' => 'St. Marys',
		'US1840018781' => 'Broomfield',
		'US1840028567' => 'Perry Park',
		'US1840022481' => 'Cheyenne Wells',
		'US1840018773' => 'Niwot',
		'US1840021408' => 'Grand Lake',
		'US1840020180' => 'Lafayette',
		'US1840024761' => 'Jansen',
		'US1840028580' => 'Ken Caryl',
		'US1840074635' => 'Security-Widefield',
		'US1840022565' => 'Pagosa Springs',
		'US1840024367' => 'Heeney',
		'US1840024554' => 'Peyton',
		'US1840028564' => 'Loghill Village',
		'US1840024319' => 'Joes',
		'US1840017527' => 'Eldora',
		'US1840021378' => 'Crook',
		'US1840021467' => 'Victor',
		'US1840028520' => 'Lazy Acres',
		'US1840028576' => 'Derby',
		'US1840020268' => 'Las Animas',
		'US1840017557' => 'Fruitvale',
		'US1840021382' => 'Estes Park',
		'US1840024588' => 'Maysville',
		'US1840028425' => 'Federal Heights',
		'US1840021368' => 'Hudson',
		'US1840020195' => 'Basalt',
		'US1840022430' => 'Parachute',
		'US1840028442' => 'Paragon Estates',
		'US1840021493' => 'Brookside',
		'US1840074311' => 'Leadville North',
		'US1840022503' => 'Williamsburg',
		'US1840020222' => 'Lone Tree',
		'US1840028424' => 'Gunbarrel',
		'US1840022425' => 'Superior',
		'US1840022476' => 'Calhan',
		'US1840024365' => 'McCoy',
		'US1840073909' => 'East Pleasant View',
		'US1840021494' => 'Rockvale',
		'US1840021405' => 'Log Lane Village',
		'US1840022540' => 'Silverton',
		'US1840021416' => 'Jamestown',
		'US1840022403' => 'Yampa',
		'US1840020152' => 'Loveland',
		'US1840020147' => 'Evans',
		'US1840022472' => 'Paonia',
		'US1840020309' => 'Bayfield',
		'US1840021433' => 'Georgetown',
		'US1840024383' => 'Peoria',
		'US1840021540' => 'Dove Creek',
		'US1840018854' => 'Penrose',
		'US1840021508' => 'Bonanza',
		'US1840022469' => 'Mount Crested Butte',
		'US1840021364' => 'Frederick',
		'US1840021522' => 'Fowler',
		'US1840028557' => 'Fort Carson',
		'US1840022454' => 'Parker',
		'US1840021366' => 'Gilcrest',
		'US1840074740' => 'West Pleasant View',
		'US1840024366' => 'Wolcott',
		'US1840022552' => 'Two Buttes',
		'US1840020148' => 'Fort Lupton',
		'US1840020213' => 'Littleton',
		'US1840028450' => 'Glendale',
		'US1840038625' => 'Brick Center',
		'US1840021429' => 'Dillon',
		'US1840018759' => 'Tabernash',
		'US1840020194' => 'Avon',
		'US1840022475' => 'Palmer Lake',
		'US1840024368' => 'Idledale',
		'US1840018860' => 'Pueblo West',
		'US1840022452' => 'Stratton',
		'US1840021576' => 'Antonito',
		'US1840028451' => 'Watkins',
		'US1840021496' => 'Haswell',
		'US1840018788' => 'Arvada',
		'US1840021359' => 'Eaton',
		'US1840021365' => 'Garden City',
		'US1840028574' => 'Cimarron Hills',
		'US1840028558' => 'Lakeside',
		'US1840017536' => 'El Jebel',
		'US1840028559' => 'Acres Green',
		'US1840022401' => 'Windsor',
		'US1840021577' => 'Romeo',
		'US1840022553' => 'Vilas',
		'US1840022517' => 'Center',
		'US1840028577' => 'Genesee',
		'US1840024361' => 'Chacra',
		'US1840020175' => 'Fort Morgan',
		'US1840021432' => 'Empire',
		'US1840022400' => 'Severance',
		'US1840022555' => 'Mancos',
		'US1840017537' => 'Keystone',
		'US1840136771' => 'Twin Lakes',
		'US1840021426' => 'Gypsum',
		'US1840024359' => 'Catherine',
		'US1840018758' => 'Brush',
		'US1840017552' => 'Franktown',
		'US1840018808' => 'Westcreek',
		'US1840024302' => 'Snyder',
		'US1840021557' => 'Dolores',
		'US1840024788' => 'Capulin',
		'US1840022424' => 'Nederland',
		'US1840028449' => 'Welby',
		'US1840017646' => 'Arboles',
		'US1840024762' => 'Lynn',
		'US1840020151' => 'Fort Collins',
		'US1840017498' => 'Laporte',
		'US1840022406' => 'Peetz',
		'US1840022457' => 'Simla',
		'US1840022474' => 'Monument',
		'US1840028519' => 'Copper Mountain',
		'US1840024765' => 'Weston',
		'US1840022527' => 'Cheraw',
		'US1840021362' => 'Erie',
		'US1840024552' => 'Goldfield',
		'US1840021423' => 'Westminster',
		'US1840020251' => 'Montrose',
		'US1840021431' => 'Wheat Ridge',
		'US1840022473' => 'Cedaredge',
	],
	'CA' => [
		'US1840017565' => 'El Dorado Hills',
		'US1840074315' => 'Lemon Cove',
		'US1840018883' => 'Dillon Beach',
		'US1840042286' => 'Patterson Tract',
		'US1840026325' => 'Redcrest',
		'US1840020300' => 'Madera',
		'US1840028317' => 'Brooktrails',
		'US1840024616' => 'Geyserville',
		'US1840018930' => 'Delhi',
		'US1840021966' => 'Stanton',
		'US1840017546' => 'Cobb',
		'US1840018850' => 'Amador City',
		'US1840021499' => 'Vallejo',
		'US1840021580' => 'Scotts Valley',
		'US1840024753' => 'Fish Camp',
		'US1840018014' => 'Alpine',
		'US1840019211' => 'Rowland Heights',
		'US1840025619' => 'Alta',
		'US1840026654' => 'North San Juan',
		'US1840019135' => 'Mountain Mesa',
		'US1840021735' => 'Shafter',
		'US1840018033' => 'Bombay Beach',
		'US1840021516' => 'Fairfax',
		'US1840018732' => 'Round Mountain',
		'US1840028318' => 'Avocado Heights',
		'US1840024600' => 'Dunnigan',
		'US1840019042' => 'Strathmore',
		'US1840019237' => 'Inglewood',
		'US1840019139' => 'Randsburg',
		'US1840028377' => 'Granite Hills',
		'US1840018925' => 'Burlingame',
		'US1840017523' => 'Keddie',
		'US1840020263' => 'Lodi',
		'US1840025001' => 'Saticoy',
		'US1840017591' => 'Avery',
		'US1840019017' => 'Spreckels',
		'US1840019209' => 'South Whittier',
		'US1840017811' => 'Boron',
		'US1840017983' => 'Cherry Valley',
		'US1840020329' => 'Milpitas',
		'US1840075804' => 'El Sobrante',
		'US1840020365' => 'Exeter',
		'US1840028309' => 'Whitewater',
		'US1840017820' => 'Inyokern',
		'US1840042826' => 'Rackerby',
		'US1840076018' => 'Pajaro Dunes',
		'US1840022383' => 'Adin',
		'US1840017808' => 'Lake Nacimiento',
		'US1840020234' => 'Live Oak',
		'US1840020104' => 'Fort Jones',
		'US1840020248' => 'Rancho Cordova',
		'US1840036851' => 'Black Point-Green Point',
		'US1840020496' => 'Manhattan Beach',
		'US1840019182' => 'Montecito',
		'US1840020480' => 'El Monte',
		'US1840018018' => 'Bostonia',
		'US1840018731' => 'Palo Cedro',
		'US1840018924' => 'Belmont',
		'US1840024526' => 'Robbins',
		'US1840018889' => 'Woodacre',
		'US1840028280' => 'Sugarloaf Mountain Park',
		'US1840019220' => 'Willowbrook',
		'US1840075962' => 'Mather',
		'US1840024939' => 'Los Berros',
		'US1840026771' => 'Waterloo',
		'US1840028058' => 'Callender',
		'US1840022487' => 'Carmet',
		'US1840018920' => 'Yosemite Lakes',
		'US1840025656' => 'Buckhorn',
		'US1840026943' => 'Edmundson Acres',
		'US1840017472' => 'Grenada',
		'US1840020408' => 'Montclair',
		'US1840022542' => 'Buck Meadows',
		'US1840024468' => 'Grimes',
		'US1840017487' => 'Hayfork',
		'US1840019304' => 'Indio',
		'US1840024380' => 'Sierra City',
		'US1840028388' => 'Mission Hills',
		'US1840019143' => 'Valley Acres',
		'US1840020499' => 'Montebello',
		'US1840024125' => 'Newell',
		'US1840028393' => 'Parksdale',
		'US1840017577' => 'Graton',
		'US1840020311' => 'Livingston',
		'US1840019040' => 'Traver',
		'US1840025608' => 'Floriston',
		'US1840020105' => 'Montague',
		'US1840074418' => 'Mesa',
		'US1840024795' => 'Lompico',
		'US1840028378' => 'Hidden Meadows',
		'US1840026813' => 'La Vina',
		'US1840020367' => 'Lindsay',
		'US1840025723' => 'Bass Lake',
		'US1840019300' => 'Calimesa',
		'US1840019291' => 'Thousand Palms',
		'US1840020287' => 'Modesto',
		'US1840020506' => 'Pico Rivera',
		'US1840028368' => 'East Rancho Dominguez',
		'US1840020418' => 'Maricopa',
		'US1840018848' => 'Wilton',
		'US1840019372' => 'Ocotillo',
		'US1840017480' => 'Klamath',
		'US1840019326' => 'Costa Mesa',
		'US1840019123' => 'Oceano',
		'US1840042828' => 'Robinson Mill',
		'US1840018810' => 'Colusa',
		'US1840075971' => 'Meadowbrook',
		'US1840017549' => 'Hidden Valley Lake',
		'US1840017632' => 'Caruthers',
		'US1840026995' => 'Potrero',
		'US1840017637' => 'Laton',
		'US1840025510' => 'Hiouchi',
		'US1840026944' => 'Fuller Acres',
		'US1840024626' => 'Herald',
		'US1840028343' => 'Furnace Creek',
		'US1840025800' => 'Lucerne Valley',
		'US1840024640' => 'Volcano',
		'US1840020141' => 'Redding',
		'US1840018905' => 'Concord',
		'US1840074716' => 'West Modesto',
		'US1840017819' => 'Golden Hills',
		'US1840021865' => 'Santa Fe Springs',
		'US1840017816' => 'Fellows',
		'US1840017575' => 'Forestville',
		'US1840017505' => 'Los Molinos',
		'US1840019297' => 'Banning',
		'US1840021491' => 'Sacramento',
		'US1840017644' => 'Independence',
		'US1840024936' => 'Spring Valley Lake',
		'US1840024622' => 'Valley Ford',
		'US1840028419' => 'Plumas Eureka',
		'US1840028052' => 'Westside',
		'US1840028364' => 'Country Club',
		'US1840017517' => 'East Quincy',
		'US1840019347' => 'Rancho San Diego',
		'US1840017488' => 'Lewiston',
		'US1840036903' => 'Bonadelle Ranchos-Madera Ranchos',
		'US1840042314' => 'Teviston',
		'US1840074238' => 'Lagunitas-Forest Knolls',
		'US1840020333' => 'Palo Alto',
		'US1840028301' => 'Pearsonville',
		'US1840018015' => 'Bonita',
		'US1840028341' => 'Del Rio',
		'US1840021532' => 'Danville',
		'US1840073904' => 'Casa de Oro-Mount Helix',
		'US1840018838' => 'Cloverdale',
		'US1840020559' => 'La Quinta',
		'US1840028326' => 'Roseland',
		'US1840017797' => 'Big Bear City',
		'US1840017598' => 'Chinese Camp',
		'US1840026657' => 'Washington',
		'US1840021936' => 'San Jacinto',
		'US1840028338' => 'Carrick',
		'US1840018815' => 'Meadow Vista',
		'US1840076004' => 'Old Fig Garden',
		'US1840024123' => 'Likely',
		'US1840028303' => 'Sugarloaf Saw Mill',
		'US1840028351' => 'Riverdale Park',
		'US1840021318' => 'Tulelake',
		'US1840136071' => 'Las Flores',
		'US1840017629' => 'Biola',
		'US1840075936' => 'Los Ranchos',
		'US1840021551' => 'San Mateo',
		'US1840020294' => 'Livermore',
		'US1840028423' => 'Diablo Grande',
		'US1840074173' => 'Idyllwild-Pine Cove',
		'US1840019110' => 'Morongo Valley',
		'US1840026770' => 'Thornton',
		'US1840021990' => 'San Diego',
		'US1840017981' => 'Bermuda Dunes',
		'US1840017589' => 'Copperopolis',
		'US1840074182' => 'La Crescenta-Montrose',
		'US1840076064' => 'Pine Canyon',
		'US1840022569' => 'Brookdale',
		'US1840021868' => 'Signal Hill',
		'US1840025574' => 'Stirling City',
		'US1840017544' => 'Loma Rica',
		'US1840074828' => 'Tamalpais-Homestead Valley',
		'US1840024775' => 'Tuttle',
		'US1840026842' => 'West Park',
		'US1840020298' => 'Pleasanton',
		'US1840073926' => 'March ARB',
		'US1840025518' => 'Big Lagoon',
		'US1840028097' => 'Muscoy',
		'US1840021876' => 'West Covina',
		'US1840019230' => 'Bellflower',
		'US1840024864' => 'Allensworth',
		'US1840075922' => 'Lemon Hill',
		'US1840027997' => 'Fort Dick',
		'US1840020411' => 'Rancho Cucamonga',
		'US1840028179' => 'Rio del Mar',
		'US1840019221' => 'Agoura Hills',
		'US1840021486' => 'St. Helena',
		'US1840018696' => 'Dorris',
		'US1840017804' => 'Lenwood',
		'US1840009251' => 'Garberville',
		'US1840017579' => 'Carmichael',
		'US1840025573' => 'Richvale',
		'US1840024984' => 'New Cuyama',
		'US1840018888' => 'Tomales',
		'US1840022905' => 'Anza',
		'US1840042291' => 'Rodriguez Camp',
		'US1840022803' => 'Ballard',
		'US1840025044' => 'Jacumba',
		'US1840018911' => 'Westley',
		'US1840019289' => 'Romoland',
		'US1840021964' => 'Santa Ana',
		'US1840018915' => 'Sunol',
		'US1840020516' => 'Lancaster',
		'US1840020472' => 'Moorpark',
		'US1840017518' => 'Graeagle',
		'US1840022970' => 'Descanso',
		'US1840018849' => 'Isleton',
		'US1840020322' => 'Orange Cove',
		'US1840018831' => 'Pollock Pines',
		'US1840017468' => 'Macdoel',
		'US1840021874' => 'Vernon',
		'US1840021483' => 'West Sacramento',
		'US1840018886' => 'San Geronimo',
		'US1840020323' => 'Parlier',
		'US1840024691' => 'Long Barn',
		'US1840019379' => 'Calexico',
		'US1840028108' => 'Fairhaven',
		'US1840019240' => 'Compton',
		'US1840018868' => 'San Andreas',
		'US1840022492' => 'Courtland',
		'US1840024201' => 'Herlong',
		'US1840022907' => 'Desert Edge',
		'US1840017516' => 'Chester',
		'US1840020189' => 'Fort Bragg',
		'US1840017621' => 'Bootjack',
		'US1840021446' => 'Wheatland',
		'US1840019114' => 'Chino',
		'US1840028354' => 'Valley Ranch',
		'US1840019349' => 'Valley Center',
		'US1840019020' => 'Prunedale',
		'US1840019150' => 'Taft Heights',
		'US1840018770' => 'Twain',
		'US1840042931' => 'Grizzly Flats',
		'US1840024175' => 'Junction City',
		'US1840021731' => 'Victorville',
		'US1840074823' => 'Taft Mosswood',
		'US1840022386' => 'Cedarville',
		'US1840042852' => 'West Goshen',
		'US1840019138' => 'Onyx',
		'US1840024376' => 'Downieville',
		'US1840020493' => 'Rolling Hills',
		'US1840028260' => 'Mesa Verde',
		'US1840024513' => 'Sheridan',
		'US1840017617' => 'Hickman',
		'US1840028348' => 'Mission Canyon',
		'US1840019112' => 'Running Springs',
		'US1840022570' => 'Davenport',
		'US1840026827' => 'La Honda',
		'US1840024877' => 'Posey',
		'US1840018021' => 'Jamul',
		'US1840028381' => 'Ladera Heights',
		'US1840028399' => 'Searles Valley',
		'US1840020325' => 'Kingsburg',
		'US1840025004' => 'Leona Valley',
		'US1840024612' => 'Oakville',
		'US1840017585' => 'Elmira',
		'US1840028321' => 'Auburn Lake Trails',
		'US1840028418' => 'Lake Almanor Peninsula',
		'US1840017574' => 'Eldridge',
		'US1840018952' => 'Shoshone',
		'US1840019294' => 'Coachella',
		'US1840028353' => 'Toro Canyon',
		'US1840017471' => 'Greenview',
		'US1840021968' => 'Villa Park',
		'US1840022969' => 'Campo',
		'US1840020331' => 'Morgan Hill',
		'US1840019353' => 'Imperial Beach',
		'US1840020554' => 'Norco',
		'US1840018942' => 'Riverdale',
		'US1840020328' => 'Los Altos',
		'US1840020494' => 'Rolling Hills Estates',
		'US1840018802' => 'Middletown',
		'US1840076298' => 'Sun Village',
		'US1840020416' => 'Pismo Beach',
		'US1840018949' => 'Campbell',
		'US1840020575' => 'Fountain Valley',
		'US1840076398' => 'Trona',
		'US1840017645' => 'Keeler',
		'US1840028359' => 'Carmel Valley Village',
		'US1840020630' => 'El Centro',
		'US1840021873' => 'Torrance',
		'US1840020289' => 'Oakdale',
		'US1840021631' => 'San Juan Bautista',
		'US1840020631' => 'Holtville',
		'US1840019033' => 'East Orosi',
		'US1840024512' => 'Newcastle',
		'US1840075664' => 'Clearlake Riviera',
		'US1840021498' => 'Vacaville',
		'US1840019210' => 'Quartz Hill',
		'US1840017679' => 'Chualar',
		'US1840018777' => 'Palermo',
		'US1840018803' => 'Nice',
		'US1840021634' => 'Seaside',
		'US1840021843' => 'Simi Valley',
		'US1840024876' => 'Plainview',
		'US1840017511' => 'Beckwourth',
		'US1840021438' => 'Willows',
		'US1840020305' => 'Menlo Park',
		'US1840024711' => 'Valley Home',
		'US1840018841' => 'North Highlands',
		'US1840026322' => 'Indianola',
		'US1840020580' => 'Mission Viejo',
		'US1840017609' => 'Alamo',
		'US1840018866' => 'Rail Road Flat',
		'US1840018780' => 'Thermalito',
		'US1840020489' => 'Lomita',
		'US1840026601' => 'Potter Valley',
		'US1840019303' => 'Indian Wells',
		'US1840017547' => 'Lower Lake',
		'US1840019233' => 'Burbank',
		'US1840017912' => 'Casa Conejo',
		'US1840019141' => 'Rosedale',
		'US1840019354' => 'Coronado',
		'US1840076411' => 'Warm Springs',
		'US1840019129' => 'Dustin Acres',
		'US1840022726' => 'Yucca Valley',
		'US1840024470' => 'Maxwell',
		'US1840028300' => 'Patton Village',
		'US1840021730' => 'Upland',
		'US1840020275' => 'El Cerrito',
		'US1840018728' => 'Shingletown',
		'US1840018733' => 'Anderson',
		'US1840017799' => 'Bloomington',
		'US1840020556' => 'Palm Springs',
		'US1840020308' => 'Atherton',
		'US1840020409' => 'Needles',
		'US1840025566' => 'Clipper Mills',
		'US1840019145' => 'Weldon',
		'US1840017918' => 'Altadena',
		'US1840020622' => 'National City',
		'US1840017558' => 'Foresthill',
		'US1840028148' => 'Daphnedale Park',
		'US1840018834' => 'American Canyon',
		'US1840020249' => 'Plymouth',
		'US1840020407' => 'Rialto',
		'US1840020243' => 'Rohnert Park',
		'US1840019044' => 'Dinuba',
		'US1840020359' => 'Pacific Grove',
		'US1840019140' => 'Rosamond',
		'US1840020233' => 'Roseville',
		'US1840074780' => 'Angels',
		'US1840018837' => 'Occidental',
		'US1840021994' => 'Vista',
		'US1840025798' => 'Phelan',
		'US1840024781' => 'Sunnyside',
		'US1840024202' => 'Johnstonville',
		'US1840017602' => 'Inverness',
		'US1840017917' => 'Acton',
		'US1840020505' => 'Pasadena',
		'US1840022445' => 'Alleghany',
		'US1840024855' => 'Tres Pinos',
		'US1840022826' => 'Castaic',
		'US1840024472' => 'Stonyford',
		'US1840017533' => 'Covelo',
		'US1840019185' => 'Vandenberg Village',
		'US1840017806' => 'Cambria',
		'US1840009298' => 'Miranda',
		'US1840076237' => 'Silverado Resort',
		'US1840028334' => 'Amesti',
		'US1840018932' => 'Planada',
		'US1840024174' => 'Hyampom',
		'US1840038257' => 'Gold Mountain',
		'US1840028339' => 'China Lake Acres',
		'US1840019292' => 'Valle Vista',
		'US1840017886' => 'Los Alamos',
		'US1840024875' => 'Pine Flat',
		'US1840020295' => 'Newark',
		'US1840021992' => 'Santee',
		'US1840018879' => 'Mi-Wuk Village',
		'US1840076217' => 'Sereno del Mar',
		'US1840019218' => 'Walnut Park',
		'US1840021842' => 'Santa Paula',
		'US1840019021' => 'San Ardo',
		'US1840018938' => 'Del Rey',
		'US1840018880' => 'Mono Vista',
		'US1840020591' => 'Lake Forest',
		'US1840021511' => 'Sonora',
		'US1840022450' => 'Dobbins',
		'US1840020581' => 'Newport Beach',
		'US1840024698' => 'Peters',
		'US1840021571' => 'Santa Clara',
		'US1840019344' => 'Pine Valley',
		'US1840020590' => 'Laguna Woods',
		'US1840024619' => 'Penngrove',
		'US1840075741' => 'Elizabeth Lake',
		'US1840018922' => 'Montara',
		'US1840017923' => 'Lennox',
		'US1840019118' => 'Barstow',
		'US1840018847' => 'Walnut Grove',
		'US1840018717' => 'Redway',
		'US1840043016' => 'Desert Palms',
		'US1840019019' => 'Pajaro',
		'US1840028411' => 'Mesa Vista',
		'US1840019226' => 'Azusa',
		'US1840020303' => 'Half Moon Bay',
		'US1840021575' => 'Los Gatos',
		'US1840020281' => 'Pinole',
		'US1840010406' => 'Hoopa',
		'US1840022520' => 'San Anselmo',
		'US1840018948' => 'San Martin',
		'US1840017628' => 'Auberry',
		'US1840025034' => 'Sky Valley',
		'US1840017633' => 'Easton',
		'US1840017485' => 'McKinleyville',
		'US1840027992' => 'Alto',
		'US1840021514' => 'Sausalito',
		'US1840074119' => 'Highlands-Baywood Park',
		'US1840022509' => 'Allendale',
		'US1840018844' => 'Rosemont',
		'US1840018916' => 'Dublin',
		'US1840024782' => 'Tarpey Village',
		'US1840018912' => 'San Lorenzo',
		'US1840028365' => 'Day Valley',
		'US1840018766' => 'Paxton',
		'US1840024867' => 'Cedar Slope',
		'US1840028410' => 'Seacliff',
		'US1840021517' => 'Stockton',
		'US1840017570' => 'Angwin',
		'US1840018956' => 'Tecopa',
		'US1840018775' => 'Durham',
		'US1840019183' => 'Orcutt',
		'US1840028374' => 'Emerald Lake Hills',
		'US1840026714' => 'Guinda',
		'US1840019375' => 'Salton Sea Beach',
		'US1840020253' => 'Fairfield',
		'US1840018846' => 'Vineyard',
		'US1840075577' => 'Acalanes Ridge',
		'US1840019136' => 'North Edwards',
		'US1840020495' => 'Rosemead',
		'US1840026366' => 'Milford',
		'US1840025570' => 'Honcut',
		'US1840020262' => 'Escalon',
		'US1840019320' => 'Rossmoor',
		'US1840020473' => 'Ojai',
		'US1840020238' => 'Placerville',
		'US1840021869' => 'South El Monte',
		'US1840018729' => 'Millville',
		'US1840043023' => 'Temescal Valley',
		'US1840018896' => 'Diablo',
		'US1840139203' => 'Panorama Heights',
		'US1840024615' => 'Fulton',
		'US1840020558' => 'Rancho Mirage',
		'US1840021463' => 'Yuba City',
		'US1840028398' => 'San Diego Country Estates',
		'US1840018959' => 'Capitola',
		'US1840017636' => 'Lanare',
		'US1840028422' => 'Contra Costa Centre',
		'US1840042238' => 'Kennedy Meadows',
		'US1840020584' => 'Rancho Santa Margarita',
		'US1840038388' => 'North Shore',
		'US1840017653' => 'Interlaken',
		'US1840043055' => 'Homestead Valley',
		'US1840022498' => 'Coleville',
		'US1840017614' => 'Knightsen',
		'US1840018782' => 'Mendocino',
		'US1840018697' => 'Dunsmuir',
		'US1840017560' => 'Kings Beach',
		'US1840025523' => 'Myers Flat',
		'US1840019305' => 'Corona',
		'US1840028342' => 'East Shore',
		'US1840021320' => 'Yreka',
		'US1840019298' => 'Beaumont',
		'US1840026834' => 'Bear Creek',
		'US1840021529' => 'San Pablo',
		'US1840028412' => 'Alpine Village',
		'US1840018862' => 'Dorrington',
		'US1840025511' => 'Smith River',
		'US1840020279' => 'Oakley',
		'US1840022825' => 'Agua Dulce',
		'US1840017493' => 'McArthur',
		'US1840074539' => 'Oroville East',
		'US1840024523' => 'Meridian',
		'US1840074358' => 'Dixon Lane-Meadow Creek',
		'US1840019115' => 'Chino Hills',
		'US1840018016' => 'Bonsall',
		'US1840020246' => 'Folsom',
		'US1840021348' => 'Susanville',
		'US1840021513' => 'San Rafael',
		'US1840019234' => 'Calabasas',
		'US1840022805' => 'Cuyama',
		'US1840024756' => 'Wawona',
		'US1840028362' => 'Concow',
		'US1840037458' => 'Westlake Village',
		'US1840024985' => 'Sisquoc',
		'US1840018852' => 'Jackson',
		'US1840024527' => 'Trowbridge',
		'US1840018835' => 'Calistoga',
		'US1840028333' => 'Ladera Ranch',
		'US1840025584' => 'Cleone',
		'US1840017817' => 'Ford City',
		'US1840042938' => 'University of California-Davis',
		'US1840026987' => 'Oasis',
		'US1840020357' => 'Marina',
		'US1840021962' => 'San Clemente',
		'US1840021878' => 'Whittier',
		'US1840028305' => 'Mono City',
		'US1840020587' => 'Laguna Beach',
		'US1840017822' => 'Kernville',
		'US1840024880' => 'Silver City',
		'US1840020264' => 'Ripon',
		'US1840026945' => 'Mexican Colony',
		'US1840022392' => 'Bella Vista',
		'US1840017486' => 'Hydesville',
		'US1840019371' => 'Niland',
		'US1840017571' => 'Bodega Bay',
		'US1840022446' => 'Calpine',
		'US1840028323' => 'Hat Creek',
		'US1840022968' => 'Boulevard',
		'US1840019214' => 'Carson',
		'US1840020467' => 'Guadalupe',
		'US1840017683' => 'Elkhorn',
		'US1840018763' => 'Delleker',
		'US1840020578' => 'Huntington Beach',
		'US1840021460' => 'Williams',
		'US1840021831' => 'Solvang',
		'US1840021489' => 'Sebastopol',
		'US1840020245' => 'Elk Grove',
		'US1840025033' => 'Ripley',
		'US1840018762' => 'Corning',
		'US1840026942' => 'Cherokee Strip',
		'US1840017796' => 'Crestline',
		'US1840075635' => 'Blacklake',
		'US1840019325' => 'Irvine',
		'US1840021863' => 'San Marino',
		'US1840028361' => 'Cherryland',
		'US1840019227' => 'Baldwin Park',
		'US1840036786' => 'Bertsch-Oceanview',
		'US1840017580' => 'Fair Oaks',
		'US1840019125' => 'Arroyo Grande',
		'US1840037346' => 'Sunnyside-Tahoe City',
		'US1840020209' => 'Orland',
		'US1840075603' => 'Alhambra Valley',
		'US1840020285' => 'Hughson',
		'US1840076205' => 'Santa Nella',
		'US1840020321' => 'Mendota',
		'US1840024798' => 'Zayante',
		'US1840022568' => 'Bonny Doon',
		'US1840020219' => 'Marysville',
		'US1840021518' => 'Tracy',
		'US1840021484' => 'Winters',
		'US1840075983' => 'Rose Hills',
		'US1840021737' => 'Tehachapi',
		'US1840025548' => 'Mabie',
		'US1840019205' => 'East Whittier',
		'US1840037057' => 'Florence-Graham',
		'US1840020579' => 'Los Alamitos',
		'US1840024176' => 'Mad River',
		'US1840024602' => 'Madison',
		'US1840018908' => 'Salida',
		'US1840017694' => 'Ivanhoe',
		'US1840021550' => 'San Carlos',
		'US1840021738' => 'Wasco',
		'US1840017530' => 'Magalia',
		'US1840024709' => 'North Richmond',
		'US1840025534' => 'Cassel',
		'US1840020404' => 'Hesperia',
		'US1840019142' => 'Tupman',
		'US1840018767' => 'Prattville',
		'US1840017717' => 'Home Garden',
		'US1840028375' => 'Fairview',
		'US1840018771' => 'Storrie',
		'US1840075917' => 'Homewood Canyon',
		'US1840017510' => 'Almanor',
		'US1840021991' => 'San Marcos',
		'US1840020481' => 'El Segundo',
		'US1840024878' => 'Poso Park',
		'US1840017618' => 'Keyes',
		'US1840018760' => 'Mineral',
		'US1840020586' => 'La Palma',
		'US1840019196' => 'Meiners Oaks',
		'US1840017623' => 'Broadmoor',
		'US1840018951' => 'Darwin',
		'US1840028087' => 'Little Valley',
		'US1840009359' => 'Weott',
		'US1840028357' => 'August',
		'US1840020318' => 'Fowler',
		'US1840021487' => 'Yountville',
		'US1840021421' => 'Willits',
		'US1840019119' => 'Big Bear Lake',
		'US1840018901' => 'Clayton',
		'US1840019201' => 'Camarillo',
		'US1840028387' => 'Mayflower Village',
		'US1840019200' => 'Piru',
		'US1840022499' => 'Buena Vista',
		'US1840021572' => 'Saratoga',
		'US1840022486' => 'Bodega',
		'US1840018023' => 'La Presa',
		'US1840028360' => 'Channel Islands Beach',
		'US1840028367' => 'Del Aire',
		'US1840018939' => 'Shaver Lake',
		'US1840018891' => 'Stinson Beach',
		'US1840020474' => 'Oxnard',
		'US1840018870' => 'Valley Springs',
		'US1840021734' => 'San Luis Obispo',
		'US1840021732' => 'Yucaipa',
		'US1840020327' => 'Gilroy',
		'US1840021937' => 'Temecula',
		'US1840024618' => 'Kenwood',
		'US1840020625' => 'La Mesa',
		'US1840020620' => 'Escondido',
		'US1840074136' => 'Hilmar-Irwin',
		'US1840024382' => 'Verdi',
		'US1840026667' => 'Penryn',
		'US1840017590' => 'Arnold',
		'US1840028358' => 'Blackhawk',
		'US1840024754' => 'Greeley Hill',
		'US1840020360' => 'King City',
		'US1840024693' => 'Sierra Village',
		'US1840075981' => 'North Gate',
		'US1840017553' => 'Alta Sierra',
		'US1840022563' => 'Centerville',
		'US1840024885' => 'Wilsonia',
		'US1840021485' => 'Woodland',
		'US1840022521' => 'Tiburon',
		'US1840026323' => 'Manila',
		'US1840024942' => 'Santa Margarita',
		'US1840024866' => 'Camp Nelson',
		'US1840020623' => 'Oceanside',
		'US1840019208' => 'South San Jose Hills',
		'US1840021319' => 'Weed',
		'US1840026768' => 'Mountain House',
		'US1840017490' => 'Big Bend',
		'US1840017572' => 'Boyes Hot Springs',
		'US1840017525' => 'Lake Davis',
		'US1840018708' => 'Alturas',
		'US1840024872' => 'Monson',
		'US1840018926' => 'Daly City',
		'US1840028319' => 'Sierra Brooks',
		'US1840017692' => 'London',
		'US1840009558' => 'Eureka',
		'US1840019321' => 'Aliso Viejo',
		'US1840021573' => 'Sunnyvale',
		'US1840024461' => 'Soda Bay',
		'US1840019293' => 'Cathedral City',
		'US1840028372' => 'East Richmond Heights',
		'US1840020487' => 'Hermosa Beach',
		'US1840028417' => 'Lake Almanor Country Club',
		'US1840028147' => 'Brisbane',
		'US1840019215' => 'Cerritos',
		'US1840022519' => 'Corte Madera',
		'US1840076147' => 'Reliez Valley',
		'US1840018769' => 'Tobin',
		'US1840020332' => 'Mountain View',
		'US1840074532' => 'Pleasure Point',
		'US1840021515' => 'Ross',
		'US1840028302' => 'Ponderosa',
		'US1840020317' => 'Firebaugh',
		'US1840021567' => 'Selma',
		'US1840021553' => 'Portola Valley',
		'US1840024469' => 'Lodoga',
		'US1840028304' => 'Sugarloaf Village',
		'US1840021531' => 'Walnut Creek',
		'US1840020125' => 'Ferndale',
		'US1840009553' => 'Fortuna',
		'US1840019224' => 'Artesia',
		'US1840028346' => 'Kennedy',
		'US1840021632' => 'Salinas',
		'US1840019348' => 'Rancho Santa Fe',
		'US1840022390' => 'Burnt Ranch',
		'US1840022491' => 'Clay',
		'US1840020254' => 'Rio Vista',
		'US1840020293' => 'Hayward',
		'US1840042807' => 'Butte Creek Canyon',
		'US1840017600' => 'Jamestown',
		'US1840076163' => 'San Miguel',
		'US1840022464' => 'College City',
		'US1840018818' => 'Colfax',
		'US1840024629' => 'June Lake',
		'US1840025575' => 'Yankee Hill',
		'US1840073922' => 'Lucas Valley-Marinwood',
		'US1840024173' => 'Douglas City',
		'US1840024638' => 'Pioneer',
		'US1840026996' => 'Eucalyptus Hills',
		'US1840017650' => 'Boulder Creek',
		'US1840020419' => 'McFarland',
		'US1840026986' => 'Mountain Center',
		'US1840024882' => 'Tonyville',
		'US1840074847' => 'El Paso de Robles',
		'US1840020502' => 'Palmdale',
		'US1840026766' => 'Nicasio',
		'US1840038292' => 'McClellan Park',
		'US1840019236' => 'Industry',
		'US1840073908' => 'Chilcoot-Vinton',
		'US1840026985' => 'Garnet',
		'US1840075921' => 'Lake Riverside',
		'US1840017990' => 'Lakeview',
		'US1840019246' => 'Duarte',
		'US1840021963' => 'San Juan Capistrano',
		'US1840019146' => 'Wofford Heights',
		'US1840019147' => 'Arvin',
		'US1840020500' => 'Monterey Park',
		'US1840021533' => 'Turlock',
		'US1840025030' => 'Indio Hills',
		'US1840019285' => 'Mecca',
		'US1840019245' => 'Downey',
		'US1840018913' => 'Alameda',
		'US1840019038' => 'Three Rivers',
		'US1840028071' => 'Pine Mountain Club',
		'US1840028113' => 'Pasatiempo',
		'US1840019374' => 'Salton City',
		'US1840140381' => 'Sleepy Hollow',
		'US1840075920' => 'Lake Mathews',
		'US1840075938' => 'McGee Creek',
		'US1840042936' => 'Rouse',
		'US1840026811' => 'Hornitos',
		'US1840019039' => 'Tipton',
		'US1840028400' => 'Stanford',
		'US1840019231' => 'Beverly Hills',
		'US1840022495' => 'Benton',
		'US1840136945' => 'Strawberry',
		'US1840021574' => 'Los Altos Hills',
		'US1840026598' => 'Little River',
		'US1840028336' => 'Bucks Lake',
		'US1840018919' => 'Chowchilla',
		'US1840018955' => 'Bishop',
		'US1840076405' => 'University of California-Merced',
		'US1840024675' => 'Hartley',
		'US1840019213' => 'Valinda',
		'US1840019239' => 'Commerce',
		'US1840074669' => 'Vandenberg AFB',
		'US1840025035' => 'Thermal',
		'US1840025006' => 'Topanga',
		'US1840018839' => 'Temelec',
		'US1840075914' => 'Hasley Canyon',
		'US1840026515' => 'Paynes Creek',
		'US1840017634' => 'Malaga',
		'US1840020486' => 'Hawthorne',
		'US1840017631' => 'Cantua Creek',
		'US1840018761' => 'Rancho Tehama Reserve',
		'US1840019343' => 'Spring Valley',
		'US1840017512' => 'Belden',
		'US1840028161' => 'Lakehead',
		'US1840028271' => 'San Pasqual',
		'US1840021829' => 'Santa Barbara',
	],
	'SC' => [
		'US1840017986' => 'Highgrove',
		'US1840026814' => 'Nipinnawasee',
		'US1840017613' => 'Kensington',
		'US1840022488' => 'Cazadero',
		'US1840018933' => 'Winton',
		'US1840024982' => 'Garey',
		'US1840026694' => 'Tahoma',
		'US1840028329' => 'Rancho Murieta',
		'US1840019132' => 'Stallion Springs',
		'US1840019133' => 'Mettler',
		'US1840020242' => 'Healdsburg',
		'US1840017605' => 'Farmington',
		'US1840075970' => 'Mayfair',
		'US1840075705' => 'Coronita',
		'US1840017651' => 'Felton',
		'US1840021554' => 'Hillsborough',
		'US1840018885' => 'Point Reyes Station',
		'US1840018943' => 'Tranquillity',
		'US1840025572' => 'Nord',
		'US1840020511' => 'La Habra Heights',
		'US1840028386' => 'Madera Acres',
		'US1840028340' => 'Crest',
		'US1840020515' => 'Lakewood',
		'US1840022428' => 'Paradise',
		'US1840028352' => 'Rollingwood',
		'US1840022496' => 'Bridgeport',
		'US1840025562' => 'Bangor',
		'US1840024934' => 'Oak Hills',
		'US1840024625' => 'Freeport',
		'US1840026326' => 'Samoa',
		'US1840017489' => 'Cottonwood',
		'US1840024177' => 'Trinity Center',
		'US1840020492' => 'Lynwood',
		'US1840026514' => 'Paskenta',
		'US1840139955' => 'Clear Creek',
		'US1840028421' => 'Eastvale',
		'US1840017519' => 'Greenville',
		'US1840018814' => 'Dollar Point',
		'US1840021638' => 'Tulare',
		'US1840076293' => 'Sunny Slopes',
		'US1840020501' => 'Norwalk',
		'US1840017690' => 'Alpaugh',
		'US1840020190' => 'Point Arena',
		'US1840028363' => 'Coto de Caza',
		'US1840019187' => 'Carpinteria',
		'US1840018914' => 'Berkeley',
		'US1840018034' => 'Heber',
		'US1840075978' => 'Airport',
		'US1840021736' => 'Taft',
		'US1840028337' => 'Bystrom',
		'US1840018897' => 'Discovery Bay',
		'US1840022385' => 'Canby',
		'US1840019235' => 'Huntington Park',
		'US1840001783' => 'Goleta',
		'US1840026519' => 'Gerber',
		'US1840075898' => 'Fruitridge Pocket',
		'US1840018923' => 'Moss Beach',
		'US1840028330' => 'Good Hope',
		'US1840020320' => 'Reedley',
		'US1840019350' => 'Chula Vista',
		'US1840018893' => 'Linden',
		'US1840009321' => 'Scotia',
		'US1840019346' => 'Ramona',
		'US1840073902' => 'Camp Pendleton South',
		'US1840025517' => 'Benbow',
		'US1840018907' => 'East Oakdale',
		'US1840020286' => 'Riverbank',
		'US1840025547' => 'Flournoy',
		'US1840020490' => 'Long Beach',
		'US1840020244' => 'Petaluma',
		'US1840017810' => 'Bodfish',
		'US1840025000' => 'Santa Susana',
		'US1840020260' => 'Novato',
		'US1840020226' => 'Nevada City',
		'US1840019144' => 'Weedpatch',
		'US1840026767' => 'Marin City',
		'US1840018851' => 'Ione',
		'US1840026368' => 'Mountain Gate',
		'US1840024796' => 'Mount Hermon',
		'US1840017616' => 'Grayson',
		'US1840019024' => 'Del Rey Oaks',
		'US1840022804' => 'Casmalia',
		'US1840020417' => 'Ridgecrest',
		'US1840018902' => 'Vine Hill',
		'US1840018941' => 'Raisin City',
		'US1840135862' => 'Green Valley',
		'US1840018819' => 'Sutter',
		'US1840020557' => 'Perris',
		'US1840019225' => 'Avalon',
		'US1840017718' => 'Kettleman City',
		'US1840018910' => 'Ceres',
		'US1840019121' => 'Shandon',
		'US1840024381' => 'Sierraville',
		'US1840019306' => 'Desert Hot Springs',
		'US1840074745' => 'West Whittier-Los Nietos',
		'US1840010231' => 'Auburn',
		'US1840018721' => 'Weaverville',
		'US1840019370' => 'Desert Shores',
		'US1840025582' => 'Calpella',
		'US1840024124' => 'Lookout',
		'US1840021729' => 'Twentynine Palms',
		'US1840021581' => 'Watsonville',
		'US1840017603' => 'Kentfield',
		'US1840022547' => 'Colma',
		'US1840024937' => 'Edna',
		'US1840024870' => 'Idlewild',
		'US1840042847' => 'Lake Don Pedro',
		'US1840021871' => 'South Pasadena',
		'US1840074566' => 'Poplar-Cotton Center',
		'US1840019116' => 'Wrightwood',
		'US1840021862' => 'San Gabriel',
		'US1840026773' => 'Woodbridge',
		'US1840021635' => 'Soledad',
		'US1840026369' => 'Old Station',
		'US1840024783' => 'Three Rocks',
		'US1840024752' => 'El Portal',
		'US1840018872' => 'West Point',
		'US1840075644' => 'Camanche North Shore',
		'US1840020484' => 'Glendora',
		'US1840026769' => 'Terminous',
		'US1840024627' => 'Hood',
		'US1840018934' => 'Atwater',
		'US1840021867' => 'Sierra Madre',
		'US1840017508' => 'Crescent Mills',
		'US1840018903' => 'Antioch',
		'US1840038463' => 'Warner Valley',
		'US1840024779' => 'Minkler',
		'US1840024635' => 'Fiddletown',
		'US1840019229' => 'Bell Gardens',
		'US1840024637' => 'Pine Grove',
		'US1840022484' => 'Windsor',
		'US1840028409' => 'West Puente Valley',
		'US1840021866' => 'Santa Monica',
		'US1840017642' => 'Lone Pine',
		'US1840024694' => 'Tuttletown',
		'US1840025724' => 'Coarsegold',
		'US1840028394' => 'Parkwood',
		'US1840017548' => 'Lucerne',
		'US1840026653' => 'Kingvale',
		'US1840024881' => 'Sultana',
		'US1840020517' => 'Lawndale',
		'US1840075867' => 'French Valley',
		'US1840020297' => 'Piedmont',
		'US1840020510' => 'La Cañada Flintridge',
		'US1840025588' => 'Elk Creek',
		'US1840028099' => 'Las Lomas',
		'US1840024377' => 'Goodyears Bar',
		'US1840018865' => 'Murphys',
		'US1840021471' => 'South Lake Tahoe',
		'US1840026597' => 'Leggett',
		'US1840042236' => 'El Rancho',
		'US1840009422' => 'Arcata',
		'US1840017534' => 'Laytonville',
		'US1840075708' => 'Crowley Lake',
		'US1840024935' => 'Silver Lakes',
		'US1840019319' => 'North Tustin',
		'US1840020247' => 'Galt',
		'US1840024774' => 'Stevinson',
		'US1840075818' => 'Fort Washington',
		'US1840028370' => 'East Hemet',
		'US1840025565' => 'Cherokee',
		'US1840020583' => 'Placentia',
		'US1840021830' => 'Santa Maria',
		'US1840018944' => 'Clovis',
		'US1840019376' => 'Seeley',
		'US1840020290' => 'Patterson',
		'US1840028316' => 'Bay Point',
		'US1840025638' => 'Cold Springs',
		'US1840019204' => 'Littlerock',
		'US1840073898' => 'Beale AFB',
		'US1840021549' => 'San Bruno',
		'US1840020177' => 'Portola',
		'US1840017635' => 'Friant',
		'US1840019207' => 'South San Gabriel',
		'US1840042288' => 'Pierpoint',
		'US1840025512' => 'Eagleville',
		'US1840018953' => 'Olancha',
		'US1840022902' => 'Wildomar',
		'US1840020261' => 'Larkspur',
		'US1840020589' => 'Laguna Niguel',
		'US1840021530' => 'San Ramon',
		'US1840042928' => 'Cowan',
		'US1840025546' => 'Bend',
		'US1840042311' => 'Sequoia Crest',
		'US1840020383' => 'Lemoore',
		'US1840042932' => 'Lake California',
		'US1840020403' => 'Grand Terrace',
		'US1840025567' => 'Cohasset',
		'US1840028403' => 'West Athens',
		'US1840017542' => 'Hamilton City',
		'US1840018829' => 'Diamond Springs',
		'US1840018863' => 'Mokelumne Hill',
		'US1840019197' => 'Mira Monte',
		'US1840017887' => 'Isla Vista',
		'US1840019016' => 'Del Monte Forest',
		'US1840026518' => 'Vina',
		'US1840018020' => 'Harbison Canyon',
		'US1840017611' => 'Byron',
		'US1840026652' => 'Graniteville',
		'US1840017648' => 'Aptos',
		'US1840028234' => 'East Pasadena',
		'US1840026516' => 'Proberta',
		'US1840073930' => 'Fetters Hot Springs-Agua Caliente',
		'US1840019373' => 'Palo Verde',
		'US1840019035' => 'Orosi',
		'US1840019238' => 'Irwindale',
		'US1840017491' => 'Burney',
		'US1840020402' => 'Fontana',
		'US1840017610' => 'Bethel Island',
		'US1840022384' => 'California Pines',
		'US1840017507' => 'Clio',
		'US1840018840' => 'Cotati',
		'US1840028098' => 'West Hollywood',
		'US1840009621' => 'Loleta',
		'US1840020103' => 'Etna',
		'US1840021728' => 'San Bernardino',
		'US1840043419' => 'Jurupa Valley',
		'US1840075652' => 'Castle Hill',
		'US1840042934' => 'Parklawn',
		'US1840135917' => 'Valley Wells',
		'US1840019120' => 'Colton',
		'US1840018887' => 'Santa Venetia',
		'US1840020210' => 'Loyalton',
		'US1840073901' => 'Camp Pendleton North',
		'US1840020176' => 'Red Bluff',
		'US1840024379' => 'Sattley',
		'US1840019228' => 'Bell',
		'US1840026655' => 'Rough and Ready',
		'US1840021411' => 'Tehama',
		'US1840022483' => 'Clarksburg',
		'US1840025583' => 'Caspar',
		'US1840025620' => 'Carnelian Bay',
		'US1840020512' => 'La Mirada',
		'US1840019113' => 'San Antonio Heights',
		'US1840019223' => 'Arcadia',
		'US1840025003' => 'Lake Hughes',
		'US1840017818' => 'Frazier Park',
		'US1840021565' => 'San Joaquin',
		'US1840018867' => 'Rancho Calaveras',
		'US1840017649' => 'Ben Lomond',
		'US1840026365' => 'Litchfield',
		'US1840020368' => 'Porterville',
		'US1840019127' => 'Templeton',
		'US1840019032' => 'Earlimart',
		'US1840024620' => 'Salmon Creek',
		'US1840028414' => 'Vista Santa Rosa',
		'US1840017800' => 'Bluewater',
		'US1840021462' => 'Loomis',
		'US1840024933' => 'Oak Glen',
		'US1840020621' => 'Lemon Grove',
		'US1840073907' => 'Challenge-Brownsville',
		'US1840076281' => 'Stevenson Ranch',
		'US1840028299' => 'Coffee Creek',
		'US1840026339' => 'Ruth',
		'US1840019188' => 'Summerland',
		'US1840075835' => 'Franklin',
		'US1840018842' => 'Orangevale',
		'US1840017640' => 'Big Pine',
		'US1840042276' => 'Matheny',
		'US1840021420' => 'Ukiah',
		'US1840018801' => 'Olivehurst',
		'US1840020412' => 'Redlands',
		'US1840020588' => 'Laguna Hills',
		'US1840025526' => 'Shelter Cove',
		'US1840028407' => 'West Menlo Park',
		'US1840024636' => 'Martell',
		'US1840020232' => 'Rocklin',
		'US1840025771' => 'Grangeville',
		'US1840021552' => 'South San Francisco',
		'US1840020276' => 'Hercules',
		'US1840028390' => 'North Auburn',
		'US1840020304' => 'Redwood City',
		'US1840021492' => 'Sutter Creek',
		'US1840024770' => 'Dos Palos Y',
		'US1840018859' => 'Dixon',
		'US1840017988' => 'Homeland',
		'US1840024630' => 'Lee Vining',
		'US1840022543' => 'Catheys Valley',
		'US1840025621' => 'Dutch Flat',
		'US1840017982' => 'Cabazon',
		'US1840018695' => 'Tennant',
		'US1840042261' => 'Linnell Camp',
		'US1840018869' => 'Vallecito',
		'US1840020577' => 'Garden Grove',
		'US1840020292' => 'Fremont',
		'US1840028413' => 'Fruitdale',
		'US1840020266' => 'Lathrop',
		'US1840017513' => 'Blairsden',
		'US1840018945' => 'Coalinga',
		'US1840028376' => 'Garden Acres',
		'US1840028088' => 'Coulterville',
		'US1840020552' => 'Moreno Valley',
		'US1840024522' => 'East Nicolaus',
		'US1840017989' => 'Lakeland Village',
		'US1840028406' => 'West Rancho Dominguez',
		'US1840028262' => 'Pala',
		'US1840024456' => 'Plumas Lake',
		'US1840019126' => 'Atascadero',
		'US1840019149' => 'California City',
		'US1840010444' => 'Trinidad',
		'US1840018858' => 'Benicia',
		'US1840024601' => 'Knights Landing',
		'US1840017494' => 'French Gulch',
		'US1840026994' => 'Mount Laguna',
		'US1840024797' => 'Paradise Park',
		'US1840019287' => 'Nuevo',
		'US1840021993' => 'Solana Beach',
		'US1840076002' => 'Oak Shores',
		'US1840028324' => 'Ladera',
		'US1840020306' => 'Millbrae',
		'US1840019243' => 'Culver City',
		'US1840017682' => 'Castroville',
		'US1840024868' => 'Delft Colony',
		'US1840018778' => 'Chico',
		'US1840020618' => 'El Cajon',
		'US1840024525' => 'Rio Oso',
		'US1840018707' => 'Crescent City',
		'US1840022462' => 'Truckee',
		'US1840020356' => 'Greenfield',
		'US1840020278' => 'Martinez',
		'US1840043043' => 'South Monrovia Island',
		'US1840020475' => 'Port Hueneme',
		'US1840025519' => 'Fieldbrook',
		'US1840020410' => 'Ontario',
		'US1840042264' => 'McClenney Tract',
		'US1840017620' => 'Castro Valley',
		'US1840020553' => 'Murrieta',
		'US1840025509' => 'Gasquet',
		'US1840020282' => 'Pittsburg',
		'US1840026596' => 'Hopland',
		'US1840020513' => 'La Puente',
		'US1840017921' => 'Hacienda Heights',
		'US1840028314' => 'Montalvin Manor',
		'US1840018772' => 'Taylorsville',
		'US1840019232' => 'Bradbury',
		'US1840019242' => 'Cudahy',
		'US1840020225' => 'Grass Valley',
		'US1840017798' => 'Big River',
		'US1840018716' => 'Myrtletown',
		'US1840017568' => 'Markleeville',
		'US1840018776' => 'South Oroville',
		'US1840020503' => 'Palos Verdes Estates',
		'US1840042933' => 'Monterey Park Tract',
		'US1840025533' => 'Janesville',
		'US1840018906' => 'Denair',
		'US1840020280' => 'Orinda',
		'US1840018946' => 'Huron',
		'US1840019345' => 'Rainbow',
		'US1840019015' => 'Ridgemark',
		'US1840018845' => 'Citrus Heights',
		'US1840017824' => 'Lake of the Woods',
		'US1840019199' => 'Oak View',
		'US1840018931' => 'South Dos Palos',
		'US1840025580' => 'Anchor Bay',
		'US1840025581' => 'Boonville',
		'US1840020514' => 'La Verne',
		'US1840025579' => 'Albion',
		'US1840019137' => 'Oildale',
		'US1840028408' => 'Westmont',
		'US1840024794' => 'La Selva Beach',
		'US1840022522' => 'Collierville',
		'US1840020284' => 'Lafayette',
		'US1840024633' => 'Walker',
		'US1840017515' => 'Caribou',
		'US1840020358' => 'Monterey',
		'US1840019206' => 'East Los Angeles',
		'US1840021490' => 'Sonoma',
		'US1840026755' => 'Groveland',
		'US1840020313' => 'Merced',
		'US1840022494' => 'Aspen Springs',
		'US1840024941' => 'San Simeon',
		'US1840017627' => 'Le Grand',
		'US1840018727' => 'Westwood',
		'US1840026656' => 'Soda Springs',
		'US1840019023' => 'Carmel-by-the-Sea',
		'US1840019355' => 'Del Mar',
		'US1840028320' => 'Desert View Highlands',
		'US1840018864' => 'Mountain Ranch',
		'US1840010232' => 'Blue Lake',
		'US1840021534' => 'Waterford',
		'US1840017638' => 'Alum Rock',
		'US1840037120' => 'North Lakeport',
		'US1840022903' => 'Menifee',
		'US1840017630' => 'Bowles',
		'US1840028335' => 'Boronda',
		'US1840017919' => 'Charter Oak',
		'US1840025729' => 'Big Creek',
		'US1840038332' => 'Monument Hills',
		'US1840028073' => 'Avila Beach',
		'US1840024865' => 'California Hot Springs',
		'US1840017821' => 'Keene',
		'US1840021633' => 'Sand City',
		'US1840024613' => 'Rutherford',
		'US1840017514' => 'Canyondam',
		'US1840021967' => 'Tustin',
		'US1840024699' => 'Victor',
		'US1840042820' => 'Kelly Ridge',
		'US1840019212' => 'Val Verde',
		'US1840020366' => 'Farmersville',
		'US1840024710' => 'Saranap',
		'US1840020277' => 'Richmond',
		'US1840021579' => 'Santa Cruz',
		'US1840025508' => 'Happy Camp',
		'US1840017473' => 'Hornbrook',
		'US1840017647' => 'Corralitos',
		'US1840074765' => 'Wilkerson',
		'US1840024755' => 'Midpines',
		'US1840028200' => 'Twin Lakes',
		'US1840019222' => 'Alhambra',
		'US1840028115' => 'Suisun City',
		'US1840042315' => 'Tooleville',
		'US1840024628' => 'Parkway',
		'US1840022562' => 'Calwa',
		'US1840019148' => 'Bakersfield',
		'US1840026324' => 'Phillipsville',
		'US1840074319' => 'Lemoore Station',
		'US1840017922' => 'Lake Los Angeles',
		'US1840017680' => 'Aromas',
		'US1840073911' => 'Edwards AFB',
		'US1840019351' => 'Winter Gardens',
		'US1840022493' => 'Mammoth Lakes',
		'US1840020576' => 'Fullerton',
		'US1840020310' => 'Gustine',
		'US1840019151' => 'Delano',
		'US1840021543' => 'San Francisco',
		'US1840017599' => 'East Sonora',
		'US1840017582' => 'Foothill Farms',
		'US1840024122' => 'Lake City',
		'US1840019043' => 'Terra Bella',
		'US1840026756' => 'Phoenix Lake',
		'US1840017467' => 'Edgewood',
		'US1840024378' => 'Pike',
		'US1840018884' => 'Muir Beach',
		'US1840021640' => 'Woodlake',
		'US1840019328' => 'Dana Point',
		'US1840024857' => 'Lockwood',
		'US1840020106' => 'Mount Shasta',
		'US1840019296' => 'Woodcrest',
		'US1840022548' => 'Woodside',
		'US1840017573' => 'El Verano',
		'US1840019131' => 'Squirrel Mountain Valley',
		'US1840038491' => 'Woodlands',
		'US1840018881' => 'Tuolumne City',
		'US1840024879' => 'Seville',
		'US1840024204' => 'Shasta',
		'US1840021861' => 'San Fernando',
		'US1840020468' => 'Lompoc',
		'US1840021870' => 'South Gate',
		'US1840017601' => 'Bolinas',
		'US1840038347' => 'Norris Canyon',
		'US1840020550' => 'Hemet',
		'US1840075653' => 'Chalfant',
		'US1840076249' => 'Spaulding',
		'US1840017520' => 'Hamilton Branch',
		'US1840017555' => 'Arbuckle',
		'US1840026600' => 'Philo',
		'US1840028383' => 'Lexington Hills',
		'US1840017470' => 'Gazelle',
		'US1840025568' => 'Forbestown',
		'US1840026828' => 'Loma Mar',
		'US1840028415' => 'Little Grass Valley',
		'US1840017693' => 'Goshen',
		'US1840022490' => 'Antelope',
		'US1840028380' => 'Humboldt Hill',
		'US1840017578' => 'Guerneville',
		'US1840020319' => 'Fresno',
		'US1840028369' => 'East Foothills',
		'US1840028391' => 'North El Monte',
		'US1840021539' => 'Union City',
		'US1840021875' => 'Walnut',
		'US1840017624' => 'El Granada',
		'US1840020582' => 'Orange',
		'US1840028366' => 'Deer Park',
		'US1840017681' => 'Bradley',
		'US1840019324' => 'Buena Park',
		'US1840024121' => 'Fort Bidwell',
		'US1840017916' => 'Citrus',
		'US1840022477' => 'Camino',
		'US1840020288' => 'Newman',
		'US1840020406' => 'Loma Linda',
		'US1840025657' => 'River Pines',
		'US1840024938' => 'Garden Farms',
		'US1840028257' => 'Moskowite Corner',
		'US1840020507' => 'Pomona',
		'US1840019055' => 'Stratford',
		'US1840020560' => 'Lake Elsinore',
		'US1840019241' => 'Covina',
		'US1840074293' => 'Larkfield-Wikiup',
		'US1840017807' => 'Cayucos',
		'US1840028140' => 'Albany',
		'US1840018019' => 'Fallbrook',
		'US1840018017' => 'Borrego Springs',
		'US1840020504' => 'Paramount',
		'US1840019377' => 'Winterhaven',
		'US1840018935' => 'Dos Palos',
		'US1840018024' => 'Lake San Marcos',
		'US1840020265' => 'Manteca',
		'US1840020324' => 'Kerman',
		'US1840019122' => 'Nipomo',
		'US1840021860' => 'San Dimas',
		'US1840028385' => 'Loyola',
		'US1840017812' => 'Buttonwillow',
		'US1840024203' => 'Keswick',
		'US1840017920' => 'Marina del Rey',
		'US1840074687' => 'Vincent',
		'US1840028344' => 'Greenhorn',
		'US1840042299' => 'Santa Rosa Valley',
		'US1840074748' => 'Westhaven-Moonstone',
		'US1840025803' => 'Creston',
		'US1840017606' => 'French Camp',
		'US1840017592' => 'Forest Meadows',
		'US1840018833' => 'Davis',
		'US1840020354' => 'Hollister',
		'US1840017913' => 'El Rio',
		'US1840020415' => 'Morro Bay',
		'US1840018836' => 'Monte Rio',
		'US1840028322' => 'Cameron Park',
		'US1840020220' => 'Lakeport',
		'US1840018805' => 'Upper Lake',
		'US1840017566' => 'Georgetown',
		'US1840028310' => 'Malibu',
		'US1840024869' => 'Hartland',
		'US1840020509' => 'Redondo Beach',
		'US1840028298' => 'Lake Almanor West',
		'US1840017825' => 'Lamont',
		'US1840022391' => 'Bieber',
		'US1840019018' => 'Moss Landing',
		'US1840019322' => 'Anaheim',
		'US1840019134' => 'Mojave',
		'US1840022501' => 'Camanche Village',
		'US1840018022' => 'Julian',
		'US1840042214' => 'Bell Canyon',
		'US1840018779' => 'Biggs',
		'US1840017581' => 'Florin',
		'US1840018783' => 'Talmage',
		'US1840018800' => 'Linda',
		'US1840042817' => 'Butte Valley',
		'US1840028405' => 'West Carson',
		'US1840017492' => 'Fall River Mills',
		'US1840019216' => 'Claremont',
		'US1840020283' => 'Pleasant Hill',
		'US1840019184' => 'Santa Ynez',
		'US1840021864' => 'Santa Clarita',
		'US1840019128' => 'Derby Acres',
		'US1840020382' => 'Hanford',
		'US1840028139' => 'Clearlake',
		'US1840028389' => 'Morada',
		'US1840019323' => 'Brea',
		'US1840017803' => 'Lake Arrowhead',
		'US1840024634' => 'Drytown',
		'US1840020491' => 'Los Angeles',
		'US1840026640' => 'Smartsville',
		'US1840019380' => 'Calipatria',
		'US1840017569' => 'Esparto',
		'US1840026599' => 'Manchester',
		'US1840026841' => 'Monmouth',
		'US1840020127' => 'Rio Dell',
		'US1840024471' => 'Princeton',
		'US1840019111' => 'Mountain View Acres',
		'US1840017554' => 'Lake of the Pines',
		'US1840024603' => 'Yolo',
		'US1840028395' => 'Penn Valley',
		'US1840017815' => 'McKittrick',
		'US1840018878' => 'Soulsbyville',
		'US1840021844' => 'Thousand Oaks',
		'US1840024767' => 'Fairmead',
		'US1840020414' => 'Grover Beach',
		'US1840022001' => 'Westmorland',
		'US1840028404' => 'West Bishop',
		'US1840017826' => 'Lebec',
		'US1840022539' => 'Crows Landing',
		'US1840026930' => 'Hardwick',
		'US1840028396' => 'Pine Hills',
		'US1840017583' => 'Gold River',
		'US1840020259' => 'Mill Valley',
		'US1840024632' => 'Topaz',
		'US1840020483' => 'Glendale',
		'US1840019036' => 'Pixley',
		'US1840021488' => 'Santa Rosa',
		'US1840024943' => 'Whitley Gardens',
		'US1840019037' => 'Richgrove',
		'US1840020312' => 'Los Banos',
		'US1840024776' => 'Volta',
		'US1840020471' => 'Fillmore',
		'US1840036997' => 'Bret Harte',
		'US1840018904' => 'Brentwood',
		'US1840021349' => 'Shasta Lake',
		'US1840018715' => 'Cutten',
		'US1840028331' => 'Mead Valley',
		'US1840024524' => 'Nicolaus',
		'US1840025802' => 'Fort Irwin',
		'US1840017622' => 'Mariposa',
		'US1840018871' => 'Wallace',
		'US1840026772' => 'Acampo',
		'US1840019109' => 'Mentone',
		'US1840024884' => 'Waukena',
		'US1840022906' => 'Desert Center',
		'US1840018899' => 'Port Costa',
		'US1840017509' => 'Cromberg',
		'US1840020405' => 'Highland',
		'US1840020488' => 'Hidden Hills',
		'US1840017805' => 'Los Osos',
		'US1840020619' => 'Encinitas',
		'US1840024983' => 'Los Olivos',
		'US1840017522' => 'Johnsville',
		'US1840025799' => 'Piñon Hills',
		'US1840021566' => 'Sanger',
		'US1840020296' => 'Oakland',
		'US1840076228' => 'Shell Ridge',
		'US1840026940' => 'Greenacres',
		'US1840018894' => 'Lockeford',
		'US1840017524' => 'La Porte',
		'US1840074686' => 'View Park-Windsor Hills',
		'US1840017521' => 'Indian Falls',
		'US1840028315' => 'Tara Hills',
		'US1840028311' => 'East San Gabriel',
		'US1840026517' => 'Richfield',
		'US1840024621' => 'Sea Ranch',
		'US1840042247' => 'Lake Sherwood',
		'US1840019327' => 'Cypress',
		'US1840018890' => 'Belvedere',
		'US1840025585' => 'Comptche',
		'US1840017559' => 'Granite Bay',
		'US1840025569' => 'Forest Ranch',
		'US1840020624' => 'Poway',
		'US1840022556' => 'Ballico',
		'US1840020498' => 'Monrovia',
		'US1840025524' => 'Orick',
		'US1840017823' => 'Lake Isabella',
		'US1840017484' => 'Bayview',
		'US1840026367' => 'Nubieber',
		'US1840018025' => 'Lakeside',
		'US1840019244' => 'Diamond Bar',
		'US1840021639' => 'Visalia',
		'US1840024871' => 'Lindcove',
		'US1840028382' => 'La Riviera',
		'US1840024617' => 'Jenner',
		'US1840017987' => 'Home Gardens',
		'US1840022538' => 'Moraga',
		'US1840017550' => 'Kelseyville',
		'US1840025563' => 'Berry Creek',
		'US1840020485' => 'Hawaiian Gardens',
		'US1840018765' => 'Meadow Valley',
		'US1840024886' => 'Yettem',
		'US1840017597' => 'Columbia',
		'US1840024932' => 'Lytle Creek',
		'US1840074769' => 'Yosemite Valley',
		'US1840019198' => 'Oak Park',
		'US1840020301' => 'East Palo Alto',
		'US1840018768' => 'Quincy',
		'US1840018940' => 'Squaw Valley',
		'US1840076383' => 'Timber Cove',
		'US1840017608' => 'Crockett',
		'US1840018950' => 'Cupertino',
		'US1840022485' => 'Bloomfield',
		'US1840021965' => 'Seal Beach',
		'US1840019295' => 'Winchester',
		'US1840028420' => 'Camino Tassajara',
		'US1840018918' => 'Oakhurst',
		'US1840020181' => 'Gridley',
		'US1840017469' => 'McCloud',
		'US1840017607' => 'Clyde',
		'US1840042218' => 'East Tulare Villa',
		'US1840017716' => 'Armona',
		'US1840017576' => 'Glen Ellen',
		'US1840020551' => 'Riverside',
		'US1840028345' => 'Iron Horse',
		'US1840028356' => 'Alondra Park',
		'US1840028313' => 'Lake Wildwood',
		'US1840024200' => 'Doyle',
		'US1840017691' => 'East Porterville',
		'US1840018730' => 'Montgomery Creek',
		'US1840020231' => 'Lincoln',
		'US1840018898' => 'Pacheco',
		'US1840017802' => 'Joshua Tree',
		'US1840020291' => 'Emeryville',
		'US1840026602' => 'Redwood Valley',
		'US1840024771' => 'El Nido',
		'US1840028349' => 'Mohawk Vista',
		'US1840017801' => 'Johannesburg',
		'US1840073894' => 'C-Road',
		'US1840025600' => 'Camptonville',
		'US1840021970' => 'Yorba Linda',
		'US1840019041' => 'Woodville',
		'US1840037414' => 'San Buenaventura',
		'US1840025037' => 'Midway City',
		'US1840020182' => 'Oroville',
		'US1840017615' => 'Empire',
		'US1840019352' => 'Carlsbad',
		'US1840022904' => 'Aguanga',
		'US1840019030' => 'Cutler',
		'US1840017639' => 'Cambrian Park',
		'US1840019022' => 'San Lucas',
		'US1840028355' => 'Whitehawk',
		'US1840024773' => 'Snelling',
		'US1840137638' => 'Bear Valley',
		'US1840025722' => 'Ahwahnee',
		'US1840021872' => 'Temple City',
		'US1840018718' => 'Willow Creek',
		'US1840025587' => 'Artois',
		'US1840019299' => 'Blythe',
		'US1840022478' => 'Coloma',
		'US1840017652' => 'Freedom',
		'US1840020497' => 'Maywood',
		'US1840028332' => 'Green Acres',
		'US1840135662' => 'Fairbanks Ranch',
		'US1840018900' => 'Rodeo',
		'US1840019054' => 'Avenal',
		'US1840076099' => 'Pine Mountain Lake',
		'US1840009839' => 'Alderpoint',
		'US1840028163' => 'Lincoln Village',
		'US1840024623' => 'Elverta',
		'US1840021570' => 'San Jose',
		'US1840019130' => 'South Taft',
		'US1840036690' => 'Arden-Arcade',
		'US1840017641' => 'Cartago',
		'US1840020330' => 'Monte Sereno',
		'US1840017814' => 'Lost Hills',
		'US1840019381' => 'Imperial',
		'US1840019117' => 'Adelanto',
		'US1840018694' => 'Mount Hebron',
		'US1840038303' => 'McSwain',
		'US1840020585' => 'La Habra',
		'US1840018830' => 'Shingle Springs',
		'US1840019378' => 'Brawley',
		'US1840026946' => 'Smith Corner',
		'US1840020241' => 'Napa',
		'US1840019034' => 'Springville',
		'US1840021733' => 'Apple Valley',
		'US1840018954' => 'Round Valley',
		'US1840025530' => 'Trinity Village',
		'US1840018843' => 'Rio Linda',
		'US1840018817' => 'Tahoe Vista',
		'US1840017809' => 'Bear Valley Springs',
		'US1840019031' => 'Ducor',
		'US1840018957' => 'Soquel',
		'US1840020555' => 'Palm Desert',
		'US1840018764' => 'Spring Garden',
		'US1840076141' => 'Red Corral',
		'US1840017545' => 'Clearlake Oaks',
		'US1840018882' => 'Twain Harte',
		'US1840021538' => 'San Leandro',
		'US1840017506' => 'Manton',
		'US1840076346' => 'Swall Meadows',
		'US1840025564' => 'Butte Meadows',
		'US1840028325' => 'North Fair Oaks',
		'US1840022518' => 'Cedar Ridge',
		'US1840036659' => 'Aptos Hills-Larkin Valley',
		'US1840020508' => 'Rancho Palos Verdes',
		'US1840021969' => 'Westminster',
		'US1840024697' => 'Dogtown',
		'US1840020307' => 'Pacifica',
		'US1840019186' => 'Buellton',
		'US1840137757' => 'New Pine Creek',
		'US1840019301' => 'Canyon Lake',
		'US1840019056' => 'Corcoran',
		'US1840017584' => 'Kirkwood',
		'US1840022557' => 'Cressey',
		'US1840025528' => 'Fields Landing',
		'US1840017619' => 'Ashland',
		'US1840025801' => 'Baker',
		'US1840020482' => 'Gardena',
		'US1840020302' => 'Foster City',
		'US1840020355' => 'Gonzales',
		'US1840026829' => 'Pescadero',
	],
	'AL' => [
		'US1840013547' => 'Moores Mill',
		'US1840018178' => 'Sanford',
		'US1840015849' => 'Thomasville',
		'US1840013654' => 'Smoke Rise',
		'US1840016916' => 'Kellyton',
		'US1840016591' => 'Town Creek',
		'US1840003257' => 'Glencoe',
		'US1840016830' => 'Waldo',
		'US1840000737' => 'Ashford',
		'US1840016696' => 'Gu-Win',
		'US1840014780' => 'Oxford',
		'US1840014797' => 'Irondale',
		'US1840017131' => 'Cowarts',
		'US1840023043' => 'Holtville',
		'US1840023016' => 'Hackneyville',
		'US1840006563' => 'Anniston',
		'US1840013886' => 'Gulf Shores',
		'US1840013753' => 'Holt',
		'US1840008076' => 'Lineville',
		'US1840005393' => 'Rockford',
		'US1840015640' => 'Sumiton',
		'US1840003500' => 'Grimes',
		'US1840016969' => 'Loachapoka',
		'US1840003367' => 'Gordo',
		'US1840005605' => 'Scottsboro',
		'US1840023022' => 'Stewartville',
		'US1840003795' => 'Louisville',
		'US1840005153' => 'Livingston',
		'US1840016589' => 'Hillsboro',
		'US1840006413' => 'Gordon',
		'US1840016768' => 'Nauvoo',
		'US1840016842' => 'Vance',
		'US1840005924' => 'Grove Hill',
		'US1840016620' => 'Grant',
		'US1840017095' => 'Lockhart',
		'US1840017079' => 'Castleberry',
		'US1840017141' => 'Dauphin Island',
		'US1840014827' => 'Helena',
		'US1840016851' => 'Wilton',
		'US1840025944' => 'Uriah',
		'US1840008329' => 'Selma',
		'US1840025228' => 'Lillian',
		'US1840017049' => 'Coffeeville',
		'US1840013094' => 'Concord',
		'US1840014988' => 'Creola',
		'US1840015672' => 'Trussville',
		'US1840016722' => 'Walnut Grove',
		'US1840015537' => 'Sheffield',
		'US1840022963' => 'Brantleyville',
		'US1840006158' => 'Columbiana',
		'US1840016805' => 'West Jefferson',
		'US1840006456' => 'Guntersville',
		'US1840035626' => 'Selmont-West Selmont',
		'US1840016524' => 'Langston',
		'US1840016522' => 'Hollywood',
		'US1840003161' => 'Geneva',
		'US1840017085' => 'Napier Field',
		'US1840013757' => 'Calera',
		'US1840014949' => 'Headland',
		'US1840023019' => 'Hissop',
		'US1840015879' => 'Spanish Fort',
		'US1840001548' => 'Enterprise',
		'US1840017899' => 'Section',
		'US1840037844' => 'Redland',
		'US1840014825' => 'Montevallo',
		'US1840005839' => 'Glen Allen',
		'US1840017124' => 'Magnolia Springs',
		'US1840016504' => 'Lexington',
		'US1840037812' => 'Dunnavant',
		'US1840023011' => 'Cusseta',
		'US1840016719' => 'County Line',
		'US1840027632' => 'Rock Creek',
		'US1840015587' => 'Winfield',
		'US1840015674' => 'Warrior',
		'US1840037831' => 'Morrison Crossroads',
		'US1840005189' => 'McIntosh',
		'US1840014771' => 'Pell City',
		'US1840005593' => 'Vernon',
		'US1840026992' => 'Macedonia',
		'US1840016590' => 'Courtland',
		'US1840015515' => 'Ardmore',
		'US1840017006' => 'Mosses',
		'US1840013640' => 'Guin',
		'US1840013725' => 'McDonald Chapel',
		'US1840014858' => 'Lanett',
		'US1840016909' => 'Union',
		'US1840025979' => 'Axis',
		'US1840002820' => 'Gardendale',
		'US1840015792' => 'Smiths Station',
		'US1840016970' => 'Orrville',
		'US1840007127' => 'Double Springs',
		'US1840017093' => 'Horn Hill',
		'US1840014960' => 'Opp',
		'US1840016839' => 'Lake View',
		'US1840016767' => 'Eldridge',
		'US1840013895' => 'Theodore',
		'US1840001838' => 'Eutaw',
		'US1840016920' => 'Thorsby',
		'US1840016803' => 'Sylvan Springs',
		'US1840017020' => 'Midway',
		'US1840013548' => 'New Market',
		'US1840007089' => 'Centreville',
		'US1840017088' => 'Newton',
		'US1840006507' => 'Birmingham',
		'US1840008353' => 'Montgomery',
		'US1840004313' => 'Somerville',
		'US1840016895' => 'Woodstock',
		'US1840007433' => 'Jacksonville',
		'US1840014770' => 'Moody',
		'US1840013600' => 'Arab',
		'US1840016700' => 'Dodge City',
		'US1840014897' => 'Demopolis',
		'US1840017134' => 'Webb',
		'US1840037800' => 'Bristow Cove',
		'US1840000720' => 'Altoona',
		'US1840015602' => 'Highland Lake',
		'US1840001403' => 'Decatur',
		'US1840016525' => 'Dutton',
		'US1840016697' => 'Hackleburg',
		'US1840006309' => 'Flomaton',
		'US1840015513' => 'Anderson',
		'US1840016829' => 'Talladega Springs',
		'US1840013889' => 'East Brewton',
		'US1840016913' => 'Daviston',
		'US1840014826' => 'Pelham',
		'US1840005138' => 'Linden',
		'US1840017055' => 'McKenzie',
		'US1840023045' => 'Marbury',
		'US1840004979' => 'Excel',
		'US1840001354' => 'Cullman',
		'US1840001842' => 'Evergreen',
		'US1840014813' => 'Childersburg',
		'US1840016769' => 'Oakman',
		'US1840015524' => 'Madison',
		'US1840015599' => 'Allgood',
		'US1840014834' => 'Roanoke',
		'US1840016942' => 'Moundville',
		'US1840025919' => 'Cullomburg',
		'US1840018176' => 'Red Level',
		'US1840016721' => 'Nectar',
		'US1840013644' => 'Haleyville',
		'US1840015671' => 'Tarrant',
		'US1840017892' => 'St. Florian',
		'US1840016994' => 'Myrtlewood',
		'US1840073855' => 'West End-Cobb Town',
		'US1840016999' => 'Hurtsboro',
		'US1840016547' => 'Littleville',
		'US1840015586' => 'Brilliant',
		'US1840016980' => 'Franklin',
		'US1840017098' => 'Onycha',
		'US1840025922' => 'Boykin',
		'US1840027498' => 'Stockton',
		'US1840014862' => 'Jemison',
		'US1840015667' => 'Lipscomb',
		'US1840000935' => 'Athens',
		'US1840001883' => 'Fairfield',
		'US1840015882' => 'Black',
		'US1840013708' => 'Saks',
		'US1840017045' => 'Petrey',
		'US1840017089' => 'Pinckard',
		'US1840004591' => 'Andalusia',
		'US1840013697' => 'Ashville',
		'US1840000552' => 'Abbeville',
		'US1840013788' => 'Alexander City',
		'US1840073838' => 'Fort Rucker',
		'US1840002425' => 'Fulton',
		'US1840006157' => 'Clanton',
		'US1840016774' => 'Odenville',
		'US1840016998' => 'Thomaston',
		'US1840017005' => 'Lowndesboro',
		'US1840016636' => 'Leesburg',
		'US1840013758' => 'Aliceville',
		'US1840015585' => 'Bear Creek',
		'US1840015866' => 'Carolina',
		'US1840003629' => 'Hamilton',
		'US1840015775' => 'Akron',
		'US1840014935' => 'Jackson',
		'US1840014791' => 'Midfield',
		'US1840015668' => 'Argo',
		'US1840016592' => 'North Courtland',
		'US1840014955' => 'Daleville',
		'US1840006026' => 'Goldville',
		'US1840027518' => 'Mignon',
		'US1840016847' => 'Harpersville',
		'US1840025964' => 'Vinegar Bend',
		'US1840006013' => 'Wetumpka',
		'US1840014987' => 'Citronelle',
		'US1840013892' => 'Hartford',
		'US1840005563' => 'Tuscaloosa',
		'US1840000959' => 'Bay Minette',
		'US1840003774' => 'Hayneville',
		'US1840025845' => 'Hatton',
		'US1840014795' => 'Hoover',
		'US1840016757' => 'Detroit',
		'US1840013546' => 'Meridianville',
		'US1840014658' => 'Rainsville',
		'US1840005558' => 'Troy',
		'US1840073851' => 'Underwood-Petersville',
		'US1840016511' => 'Elkmont',
		'US1840015711' => 'Brookwood',
		'US1840014657' => 'Muscle Shoals',
		'US1840002078' => 'Fairview',
		'US1840015604' => 'Southside',
		'US1840004042' => 'Luverne',
		'US1840016709' => 'Lynn',
		'US1840017900' => 'Skyline',
		'US1840017081' => 'Millry',
		'US1840002170' => 'Fruithurst',
		'US1840001835' => 'Eunola',
		'US1840017959' => 'South Vinemont',
		'US1840013787' => 'Huguley',
		'US1840001251' => 'Clayton',
		'US1840005829' => 'Dora',
		'US1840017125' => 'Elberta',
		'US1840025982' => 'Gulfcrest',
		'US1840015661' => 'Berry',
		'US1840073883' => 'Colony',
		'US1840013602' => 'Boaz',
		'US1840022874' => 'Twin',
		'US1840017094' => 'Libertyville',
		'US1840016841' => 'Coker',
		'US1840017072' => 'Haleburg',
		'US1840016756' => 'Millport',
		'US1840014792' => 'Mountain Brook',
		'US1840016770' => 'Parrish',
		'US1840014789' => 'Center Point',
		'US1840004247' => 'Russellville',
		'US1840027633' => 'Meadowbrook',
		'US1840016866' => 'Woodland',
		'US1840025959' => 'Hobson',
		'US1840002554' => 'Gantt',
		'US1840015700' => 'Sylacauga',
		'US1840023723' => 'Cottondale',
		'US1840022930' => 'Choccolocco',
		'US1840017963' => 'Rosa',
		'US1840027631' => 'Grayson Valley',
		'US1840018171' => 'Repton',
		'US1840016799' => 'Kimberly',
		'US1840025961' => 'Malcolm',
		'US1840023017' => 'Our Town',
		'US1840018196' => 'Riverview',
		'US1840004806' => 'Carrollton',
		'US1840015759' => 'Boligee',
		'US1840016755' => 'Kennedy',
		'US1840013724' => 'Adamsville',
		'US1840027002' => 'Rockville',
		'US1840014790' => 'Clay',
		'US1840025886' => 'Bellamy',
		'US1840017128' => 'Madrid',
		'US1840003300' => 'Glenwood',
		'US1840007380' => 'Heflin',
		'US1840013734' => 'Brighton',
		'US1840027517' => 'McMullen',
		'US1840003778' => 'Jasper',
		'US1840017996' => 'Ranburne',
		'US1840017086' => 'Clayhatchee',
		'US1840015760' => 'Valley',
		'US1840016800' => 'Maytown',
		'US1840017008' => 'Gordonville',
		'US1840015812' => 'Benton',
		'US1840017025' => 'Pine Apple',
		'US1840017133' => 'Taylor',
		'US1840023015' => 'Standing Rock',
		'US1840016560' => 'Pine Ridge',
		'US1840016553' => 'Collinsville',
		'US1840013544' => 'Harvest',
		'US1840014793' => 'Pleasant Grove',
		'US1840016782' => 'Ohatchee',
		'US1840025910' => 'Nanafalia',
		'US1840015884' => 'Slocomb',
		'US1840025963' => 'Tibbie',
		'US1840016919' => 'Maplesville',
		'US1840014659' => 'Henagar',
		'US1840013888' => 'Atmore',
		'US1840002081' => 'Faunsdale',
		'US1840018177' => 'River Falls',
		'US1840017015' => 'Lisman',
		'US1840016911' => 'Waverly',
		'US1840016624' => 'Hodges',
		'US1840015790' => 'Tallassee',
		'US1840018194' => 'Silverhill',
		'US1840022891' => 'Whitesboro',
		'US1840001007' => 'Bridgeport',
		'US1840008188' => 'Marion',
		'US1840015794' => 'Valley Grande',
		'US1840016711' => 'Natural Bridge',
		'US1840017130' => 'Cottonwood',
		'US1840015673' => 'Vestavia Hills',
		'US1840017090' => 'Kinston',
		'US1840003498' => 'Greenville',
		'US1840005106' => 'Leeds',
		'US1840013897' => 'Bayou La Batre',
		'US1840027551' => 'Brook Highland',
		'US1840014682' => 'Red Bay',
		'US1840013707' => 'Alexandria',
		'US1840016959' => 'Uniontown',
		'US1840002083' => 'Florence',
		'US1840003328' => 'Good Hope',
		'US1840017043' => 'Dozier',
		'US1840013726' => 'Minor',
		'US1840008339' => 'La Fayette',
		'US1840007209' => 'Florala',
		'US1840025980' => 'Bucks',
		'US1840016849' => 'Westover',
		'US1840013806' => 'Blue Ridge',
		'US1840017964' => 'Snead',
		'US1840025960' => 'Leroy',
		'US1840015841' => 'Banks',
		'US1840013810' => 'Auburn',
		'US1840017026' => 'Pine Hill',
		'US1840008190' => 'Moulton',
		'US1840013093' => 'Edgewater',
		'US1840016519' => 'Gurley',
		'US1840075147' => 'Coats Bend',
		'US1840025850' => 'Spruce Pine',
		'US1840027005' => 'Sims Chapel',
		'US1840023131' => 'Perdido Beach',
		'US1840017023' => 'Yellow Bluff',
		'US1840015886' => 'Saraland',
		'US1840025861' => 'East Point',
		'US1840016550' => 'Ider',
		'US1840016704' => 'West Point',
		'US1840016619' => 'Douglas',
		'US1840015601' => 'Hayden',
		'US1840016626' => 'Phil Campbell',
		'US1840023023' => 'Weogufka',
		'US1840001532' => 'Elba',
		'US1840013723' => 'Forestdale',
		'US1840016781' => 'Hobson City',
		'US1840015646' => 'Weaver',
		'US1840022843' => 'Broomtown',
		'US1840017073' => 'Newville',
		'US1840016554' => 'Crossville',
		'US1840016546' => 'Leighton',
		'US1840014781' => 'Piedmont',
		'US1840006012' => 'Phenix City',
		'US1840013896' => 'Tillmans Corner',
		'US1840014980' => 'Orange Beach',
		'US1840016966' => 'Elmore',
		'US1840075164' => 'Shoal Creek',
		'US1840016894' => 'West Blocton',
		'US1840016548' => 'Cherokee',
		'US1840002039' => 'Fairhope',
		'US1840013655' => 'Attalla',
		'US1840016995' => 'Dayton',
		'US1840014796' => 'Hueytown',
		'US1840006178' => 'Daphne',
		'US1840006332' => 'Gadsden',
		'US1840006009' => 'Mobile',
		'US1840004830' => 'Fyffe',
		'US1840017017' => 'Toxey',
		'US1840017127' => 'Kinsey',
		'US1840017018' => 'Needham',
		'US1840022933' => 'Hollis Crossroads',
		'US1840037805' => 'Carlisle-Rockledge',
		'US1840027497' => 'Stapleton',
		'US1840025943' => 'Peterman',
		'US1840004920' => 'Ariton',
		'US1840005210' => 'Opelika',
		'US1840002481' => 'Fultondale',
		'US1840016625' => 'Vina',
		'US1840022887' => 'Ballplay',
		'US1840015798' => 'Billingsley',
		'US1840014981' => 'Robertsdale',
		'US1840016621' => 'Union Grove',
		'US1840014732' => 'Rainbow City',
		'US1840017123' => 'Loxley',
		'US1840005612' => 'Belgreen',
		'US1840015660' => 'Belk',
		'US1840016523' => 'Hytop',
		'US1840025887' => 'Panola',
		'US1840016773' => 'Steele',
		'US1840017966' => 'Ridgeville',
		'US1840025957' => 'Fairford',
		'US1840015589' => 'Addison',
		'US1840015844' => 'Brantley',
		'US1840005283' => 'Ozark',
		'US1840004086' => 'Prattville',
		'US1840022967' => 'Vandiver',
		'US1840018092' => 'Shorter',
		'US1840007129' => 'Edwardsville',
		'US1840016943' => 'Newbern',
		'US1840017000' => 'Pike Road',
		'US1840005191' => 'Monroeville',
		'US1840017137' => 'Malvern',
		'US1840023014' => 'Penton',
		'US1840022965' => 'Shelby',
		'US1840013599' => 'Albertville',
		'US1840016509' => 'Lester',
		'US1840001112' => 'Chatom',
		'US1840016915' => 'New Site',
		'US1840022888' => 'Egypt',
		'US1840013828' => 'Ladonia',
		'US1840025222' => 'Jacksons Gap',
		'US1840025911' => 'Putnam',
		'US1840002079' => 'Falkville',
		'US1840025958' => 'Fruitdale',
		'US1840016717' => 'Locust Fork',
		'US1840003209' => 'Gilbertown',
		'US1840013781' => 'Brent',
		'US1840018105' => 'Providence',
		'US1840002084' => 'Foley',
		'US1840016981' => 'Notasulga',
		'US1840015635' => 'Beaverton',
		'US1840017891' => 'Rogersville',
		'US1840016802' => 'Mulga',
		'US1840015636' => 'Sulligent',
		'US1840015670' => 'Cardiff',
		'US1840016558' => 'Sylvania',
		'US1840025932' => 'Carlton',
		'US1840017992' => 'Sipsey',
		'US1840016864' => 'Wadley',
		'US1840035873' => 'Redstone Arsenal',
		'US1840022966' => 'Sterrett',
		'US1840017994' => 'Ragland',
		'US1840013593' => 'Hartselle',
		'US1840025920' => 'Fitzpatrick',
		'US1840022972' => 'Delta',
		'US1840022890' => 'Ivalee',
		'US1840017084' => 'Midland City',
		'US1840022952' => 'Munford',
		'US1840014823' => 'Chelsea',
		'US1840025933' => 'Whatley',
		'US1840005567' => 'Tuscumbia',
		'US1840022971' => 'Graham',
		'US1840015887' => 'Satsuma',
		'US1840017091' => 'New Brockton',
		'US1840006339' => 'Gainesville',
		'US1840014766' => 'Carbon Hill',
		'US1840016948' => 'Emelle',
		'US1840016766' => 'Kansas',
		'US1840014819' => 'Northport',
		'US1840025981' => 'Chunchula',
		'US1840004919' => 'Geraldine',
		'US1840015867' => 'Heath',
		'US1840022953' => 'Fayetteville',
		'US1840016520' => 'Triana',
		'US1840003191' => 'Georgiana',
		'US1840016831' => 'Oak Grove',
		'US1840001518' => 'Dothan',
		'US1840016559' => 'Valley Head',
		'US1840001840' => 'Eva',
		'US1840017965' => 'Reece City',
		'US1840013642' => 'Hanceville',
		'US1840017927' => 'Priceville',
		'US1840025955' => 'Calvert',
		'US1840013732' => 'Bessemer',
		'US1840016521' => 'Owens Cross Roads',
		'US1840014767' => 'Cordova',
		'US1840075149' => 'Highland Lakes',
		'US1840025862' => 'Joppa',
		'US1840016528' => 'Paint Rock',
		'US1840013545' => 'Hazel Green',
		'US1840013894' => 'Grand Bay',
		'US1840022932' => 'White Plains',
		'US1840022931' => 'Nances Creek',
		'US1840013883' => 'Point Clear',
		'US1840015823' => 'Butler',
		'US1840006295' => 'Fayette',
		'US1840015797' => 'Autaugaville',
		'US1840016964' => 'Deatsville',
		'US1840017126' => 'Summerdale',
		'US1840016997' => 'Sweet Water',
		'US1840004822' => 'Fort Payne',
		'US1840015669' => 'Brookside',
		'US1840006641' => 'Arley',
		'US1840027556' => 'Bakerhill',
		'US1840017024' => 'Oak Hill',
		'US1840002987' => 'Gaylesville',
		'US1840022941' => 'Pinson',
		'US1840017138' => 'Coffee Springs',
		'US1840017140' => 'Mount Vernon',
		'US1840017019' => 'Pennington',
		'US1840005396' => 'Rutledge',
		'US1840006146' => 'Brewton',
		'US1840003403' => 'Goshen',
		'US1840023013' => 'Fredonia',
		'US1840005812' => 'Cedar Bluff',
		'US1840016850' => 'Wilsonville',
		'US1840016529' => 'Pisgah',
		'US1840016551' => 'Lakeview',
		'US1840014986' => 'Chickasaw',
		'US1840016801' => 'Morris',
		'US1840015699' => 'Bon Air',
		'US1840017083' => 'Level Plains',
		'US1840017941' => 'Sand Rock',
		'US1840015865' => 'Babbie',
		'US1840018195' => 'Rehobeth',
		'US1840015778' => 'York',
		'US1840016848' => 'Vincent',
		'US1840016505' => 'Waterloo',
		'US1840023018' => 'Reeltown',
		'US1840001617' => 'Ethelsville',
		'US1840002097' => 'Forkland',
		'US1840014646' => 'New Hope',
		'US1840027557' => 'Bon Secour',
		'US1840005373' => 'Pickensville',
		'US1840016910' => 'Five Points',
		'US1840013848' => 'Brundidge',
		'US1840014926' => 'Clio',
		'US1840001685' => 'Eufaula',
		'US1840037820' => 'Emerald Mountain',
		'US1840023021' => 'Ray',
		'US1840001099' => 'Centre',
		'US1840013727' => 'Mount Olive',
		'US1840013762' => 'Rock Mills',
		'US1840015600' => 'Blountsville',
		'US1840023012' => 'Abanda',
		'US1840025983' => 'Movico',
		'US1840003493' => 'Graysville',
		'US1840014828' => 'Indian Springs Village',
		'US1840016947' => 'Cuba',
		'US1840018123' => 'Silas',
		'US1840013756' => 'Alabaster',
		'US1840014990' => 'Prichard',
		'US1840027534' => 'Perdido',
		'US1840018010' => 'Reform',
		'US1840014794' => 'Homewood',
		'US1840014733' => 'Hokes Bluff',
		'US1840016720' => 'Susan Moore',
		'US1840004337' => 'Tuskegee',
		'US1840015881' => 'Avon',
		'US1840016552' => 'Mentone',
		'US1840004299' => 'St. Stephens',
		'US1840075158' => 'New Union',
		'US1840023046' => 'Pine Level',
		'US1840005206' => 'Oneonta',
		'US1840016698' => 'Holly Pond',
		'US1840001397' => 'Dadeville',
		'US1840016612' => 'Trinity',
		'US1840015858' => 'Beatrice',
		'US1840005061' => 'Huntsville',
		'US1840022974' => 'Millerville',
		'US1840016963' => 'Coosada',
		'US1840017067' => 'Vredenburgh',
		'US1840002685' => 'Garden City',
		'US1840073888' => 'Pleasant Groves',
		'US1840025956' => 'Deer Park',
		'US1840015588' => 'Baileyton',
		'US1840002146' => 'Fort Deposit',
		'US1840016965' => 'Eclectic',
		'US1840015883' => 'Samson',
		'US1840017914' => 'Powell',
		'US1840017129' => 'Columbia',
		'US1840022973' => 'Hollins',
		'US1840017967' => 'Sardis City',
		'US1840016503' => 'Killen',
		'US1840017915' => 'Shiloh',
		'US1840027491' => 'Semmes',
		'US1840017995' => 'Riverside',
		'US1840005602' => 'Wedowee',
		'US1840025942' => 'Megargel',
		'US1840075152' => 'Lookout Mountain',
		'US1840015698' => 'Lincoln',
		'US1840005003' => 'Frisco City',
		'US1840007377' => 'Goodwater',
		'US1840016526' => 'Stevenson',
		'US1840016527' => 'Woodville',
		'US1840016718' => 'Cleveland',
		'US1840004074' => 'Pollard',
		'US1840004415' => 'Union Springs',
		'US1840014877' => 'Millbrook',
		'US1840017009' => 'White Hall',
		'US1840006738' => 'Ashland',
		'US1840006442' => 'Greensboro',
		'US1840025923' => 'Catherine',
		'US1840008244' => 'Talladega',
		'US1840001060' => 'Camden',
		'US1840015839' => 'Blue Springs',
		'US1840075168' => 'Tidmore Bend',
		'US1840023701' => 'Belle Fontaine',
		'US1840015642' => 'Springville',
		'US1840016852' => 'Memphis',
		'US1840015761' => 'Camp Hill',
		'US1840016804' => 'Trafford',
		'US1840022844' => 'Spring Garden',
		'US1840003029' => 'Geiger',
		'US1840016557' => 'Hammondville',
		'US1840016949' => 'Epes',
		'US1840022889' => 'Gallant',
		'US1840016840' => 'Coaling',
		'US1840016772' => 'Margaret',
		'US1840016806' => 'North Johns',
		'US1840016510' => 'Mooresville',
	],
	'AR' => [
		'US1840016086' => 'McDougal',
		'US1840013538' => 'McAlmont',
		'US1840014586' => 'Paris',
		'US1840016383' => 'Crawfordsville',
		'US1840013318' => 'Gravette',
		'US1840016226' => 'Dell',
		'US1840016081' => 'Lead Hill',
		'US1840015337' => 'Tontitown',
		'US1840015729' => 'Waldo',
		'US1840014554' => 'Judsonia',
		'US1840016384' => 'Edmondson',
		'US1840013438' => 'Bald Knob',
		'US1840014446' => 'Cherokee Village',
		'US1840015296' => 'Alpena',
		'US1840015428' => 'McRae',
		'US1840014578' => 'Cherry Valley',
		'US1840016129' => 'Pineville',
		'US1840016652' => 'Midway',
		'US1840015534' => 'Marianna',
		'US1840013541' => 'Brinkley',
		'US1840013455' => 'Barling',
		'US1840014579' => 'Parkin',
		'US1840015652' => 'Cale',
		'US1840015504' => 'Ward',
		'US1840015619' => 'Sparkman',
		'US1840015366' => 'Burdette',
		'US1840013331' => 'Briarcliff',
		'US1840013083' => 'College Station',
		'US1840015727' => 'McNeil',
		'US1840015339' => 'Winslow',
		'US1840013320' => 'Bethel Heights',
		'US1840015287' => 'Bella Vista',
		'US1840014530' => 'Charleston',
		'US1840013606' => 'Gillett',
		'US1840014624' => 'Des Arc',
		'US1840016764' => 'Patmos',
		'US1840015402' => 'London',
		'US1840014698' => 'Rockport',
		'US1840015653' => 'Wilton',
		'US1840014700' => 'Redfield',
		'US1840016294' => 'Damascus',
		'US1840015630' => 'McGehee',
		'US1840013424' => 'Greers Ferry',
		'US1840015684' => 'Wilmar',
		'US1840016380' => 'Horseshoe Lake',
		'US1840014543' => 'Heber Springs',
		'US1840013396' => 'Bono',
		'US1840014821' => 'Lake Village',
		'US1840022909' => 'New Edinburg',
		'US1840015608' => 'Ben Lomond',
		'US1840025875' => 'Reader',
		'US1840017757' => 'St. Joe',
		'US1840013665' => 'Grady',
		'US1840015563' => 'Malvern',
		'US1840016763' => 'Ozan',
		'US1840014606' => 'Danville',
		'US1840016190' => 'Gilbert',
		'US1840013477' => 'Greenbrier',
		'US1840016107' => 'Hindsville',
		'US1840016078' => 'Williford',
		'US1840015682' => 'Thornton',
		'US1840016229' => 'Victoria',
		'US1840015288' => 'Siloam Springs',
		'US1840015465' => 'Vilonia',
		'US1840014581' => 'Cotton Plant',
		'US1840013440' => 'Bradford',
		'US1840014444' => 'Rogers',
		'US1840014555' => 'Kensett',
		'US1840013423' => 'Dover',
		'US1840015675' => 'Stephens',
		'US1840016735' => 'Gillham',
		'US1840014459' => 'Rector',
		'US1840015549' => 'Mena',
		'US1840015294' => 'Blue Eye',
		'US1840015631' => 'Watson',
		'US1840015443' => 'Wynne',
		'US1840013395' => 'Bay',
		'US1840013439' => 'Beebe',
		'US1840015500' => 'Waldron',
		'US1840013754' => 'Eudora',
		'US1840014537' => 'Mountainburg',
		'US1840014440' => 'Cave Springs',
		'US1840016497' => 'Coy',
		'US1840015556' => 'Stuttgart',
		'US1840013766' => 'Buckner',
		'US1840014533' => 'Clarksville',
		'US1840015536' => 'Haynes',
		'US1840015733' => 'Strong',
		'US1840014844' => 'Junction City',
		'US1840016248' => 'Moorefield',
		'US1840027800' => 'Yarborough Landing',
		'US1840014565' => 'Oppelo',
		'US1840015565' => 'Sheridan',
		'US1840016694' => 'Okolona',
		'US1840016607' => 'Hatfield',
		'US1840036137' => 'Lake View',
		'US1840022810' => 'Roland',
		'US1840013735' => 'Bearden',
		'US1840014710' => 'Delight',
		'US1840014840' => 'Parkdale',
		'US1840016381' => 'Jennette',
		'US1840016089' => 'Nimmons',
		'US1840014449' => 'Reyno',
		'US1840015697' => 'Hermitage',
		'US1840014699' => 'Pine Bluff',
		'US1840013456' => 'Fort Smith',
		'US1840016082' => 'Everton',
		'US1840015650' => 'Bluff City',
		'US1840073878' => 'Fifty-Six',
		'US1840014609' => 'Plainview',
		'US1840013369' => 'Greenland',
		'US1840014580' => 'Hickory Ridge',
		'US1840015327' => 'Walnut Ridge',
		'US1840014442' => 'Decatur',
		'US1840016690' => 'Tollette',
		'US1840015450' => 'Magazine',
		'US1840016228' => 'Etowah',
		'US1840014820' => 'Dermott',
		'US1840015352' => 'Marshall',
		'US1840013571' => 'Haskell',
		'US1840013398' => 'Batesville',
		'US1840014453' => 'Norfork',
		'US1840016257' => 'Weldon',
		'US1840013664' => 'Gould',
		'US1840013696' => 'Blevins',
		'US1840075576' => 'Woodlawn',
		'US1840015370' => 'Brookland',
		'US1840016692' => 'Gum Springs',
		'US1840015509' => 'Little Rock',
		'US1840013458' => 'Hackett',
		'US1840013389' => 'Gosnell',
		'US1840015541' => 'Shannon Hills',
		'US1840013524' => 'Adona',
		'US1840013535' => 'Sweet Home',
		'US1840014505' => 'Caraway',
		'US1840014785' => 'Ogden',
		'US1840013588' => 'Lake Hamilton',
		'US1840017893' => 'Roe',
		'US1840013683' => 'Dumas',
		'US1840015407' => 'Tyronza',
		'US1840015493' => 'Caldwell',
		'US1840017838' => 'Rose Bud',
		'US1840014445' => 'Cave City',
		'US1840015683' => 'Tillar',
		'US1840014670' => 'Hot Springs',
		'US1840015444' => 'McCrory',
		'US1840014629' => 'Humnoke',
		'US1840016436' => 'Corinth',
		'US1840016416' => 'Guy',
		'US1840016480' => 'Widener',
		'US1840015542' => 'Traskwood',
		'US1840013711' => 'Ashdown',
		'US1840017724' => 'St. Paul',
		'US1840016127' => 'Franklin',
		'US1840015724' => 'Stamps',
		'US1840017714' => 'South Lead Hill',
		'US1840015708' => 'Texarkana',
		'US1840016393' => 'Subiaco',
		'US1840016609' => 'Wickes',
		'US1840015442' => 'Mansfield',
		'US1840015297' => 'Bellefonte',
		'US1840016418' => 'Wooster',
		'US1840016761' => 'Fulton',
		'US1840015378' => 'Tuckerman',
		'US1840017712' => 'Sidney',
		'US1840015583' => 'Antoine',
		'US1840014669' => 'Mountain Pine',
		'US1840014632' => 'North Little Rock',
		'US1840014482' => 'Johnson',
		'US1840027774' => 'Prairie Creek',
		'US1840013324' => 'Ash Flat',
		'US1840016120' => 'Lafe',
		'US1840027751' => 'Lost Bridge Village',
		'US1840014451' => 'Cotter',
		'US1840017911' => 'Rondo',
		'US1840016657' => 'Tull',
		'US1840025805' => 'Hagarville',
		'US1840013639' => 'Gurdon',
		'US1840015322' => 'Marmaduke',
		'US1840015290' => 'Highfill',
		'US1840013765' => 'Bradley',
		'US1840014838' => 'Crossett',
		'US1840013390' => 'Blytheville',
		'US1840014628' => 'Carlisle',
		'US1840016506' => 'Fargo',
		'US1840014452' => 'Mountain Home',
		'US1840016087' => 'Datto',
		'US1840014443' => 'Pea Ridge',
		'US1840014474' => 'Paragould',
		'US1840014534' => 'Coal Hill',
		'US1840014458' => 'Pollard',
		'US1840016378' => 'Central City',
		'US1840015446' => 'Anthonyville',
		'US1840013459' => 'Hartford',
		'US1840014455' => 'Corning',
		'US1840017827' => 'Shirley',
		'US1840013457' => 'Greenwood',
		'US1840015540' => 'Bauxite',
		'US1840014799' => 'Chidester',
		'US1840015365' => 'Birdsong',
		'US1840014502' => 'Keiser',
		'US1840014441' => 'Centerton',
		'US1840016251' => 'Pleasant Plains',
		'US1840013352' => 'Calico Rock',
		'US1840016601' => 'Norman',
		'US1840014538' => 'Mulberry',
		'US1840016385' => 'Sunset',
		'US1840015492' => 'Madison',
		'US1840016134' => 'Minturn',
		'US1840016608' => 'Vandervoort',
		'US1840014711' => 'Murfreesboro',
		'US1840027852' => 'Southside',
		'US1840014501' => 'Osceola',
		'US1840014539' => 'Kibler',
		'US1840015377' => 'Swifton',
		'US1840016299' => 'Knoxville',
		'US1840016651' => 'Magnet Cove',
		'US1840015300' => 'Yellville',
		'US1840016382' => 'Jericho',
		'US1840016083' => 'Valley Springs',
		'US1840027850' => 'LaGrange',
		'US1840015404' => 'Higden',
		'US1840016602' => 'Oden',
		'US1840014621' => 'Hughes',
		'US1840016489' => 'Casa',
		'US1840016237' => 'Cash',
		'US1840016342' => 'Griffithville',
		'US1840017734' => 'Smithville',
		'US1840015293' => 'Beaver',
		'US1840017715' => 'Pyatt',
		'US1840014541' => 'Russellville',
		'US1840014736' => 'Horatio',
		'US1840013530' => 'Cabot',
		'US1840014478' => 'Hoxie',
		'US1840014835' => 'Lewisville',
		'US1840013422' => 'Atkins',
		'US1840013461' => 'Augusta',
		'US1840013327' => 'Harrison',
		'US1840014491' => 'Mountain View',
		'US1840015289' => 'Sulphur Springs',
		'US1840013462' => 'Earle',
		'US1840014566' => 'Plumerville',
		'US1840014545' => 'Lepanto',
		'US1840013636' => 'Glenwood',
		'US1840013463' => 'Gilmore',
		'US1840016838' => 'Garland',
		'US1840015494' => 'Wheatley',
		'US1840013354' => 'Black Rock',
		'US1840015584' => 'Caddo Valley',
		'US1840014540' => 'Pottsville',
		'US1840016340' => 'Garner',
		'US1840014454' => 'Lakeview',
		'US1840014492' => 'Jasper',
		'US1840016810' => 'Harrell',
		'US1840016807' => 'Louann',
		'US1840016305' => 'Concord',
		'US1840014708' => 'Mineral Springs',
		'US1840013419' => 'Hartman',
		'US1840013572' => 'Benton',
		'US1840016135' => 'Strawberry',
		'US1840015728' => 'Taylor',
		'US1840015292' => 'Salem',
		'US1840016606' => 'Cove',
		'US1840016132' => 'Imboden',
		'US1840014610' => 'Havana',
		'US1840015452' => 'Scranton',
		'US1840016249' => 'Sulphur Rock',
		'US1840013421' => 'Dyer',
		'US1840027649' => 'DeWitt',
		'US1840017997' => 'Rosston',
		'US1840016084' => 'Zinc',
		'US1840016812' => 'Jerome',
		'US1840015364' => 'Bassett',
		'US1840013367' => 'Farmington',
		'US1840016490' => 'Fourche',
		'US1840015651' => 'Bodcaw',
		'US1840013420' => 'Alma',
		'US1840013592' => 'Grannis',
		'US1840015445' => 'Marion',
		'US1840027747' => 'Joiner',
		'US1840015726' => 'Magnolia',
		'US1840014515' => 'Diaz',
		'US1840015429' => 'Searcy',
		'US1840016653' => 'Donaldson',
		'US1840016545' => 'Moro',
		'US1840015510' => 'Maumelle',
		'US1840013323' => 'Berryville',
		'US1840017934' => 'St. Charles',
		'US1840015286' => 'Avoca',
		'US1840015397' => 'Van Buren',
		'US1840016656' => 'Leola',
		'US1840015502' => 'Lonoke',
		'US1840015362' => 'Luxora',
		'US1840015376' => 'Beedeville',
		'US1840022910' => 'Rye',
		'US1840014450' => 'Diamond City',
		'US1840017828' => 'Rudy',
		'US1840016759' => 'McCaskill',
		'US1840015695' => 'Banks',
		'US1840013527' => 'Scott',
		'US1840013522' => 'Forrest City',
		'US1840013773' => 'El Dorado',
		'US1840014623' => 'De Valls Bluff',
		'US1840015285' => 'Lowell',
		'US1840015363' => 'Manila',
		'US1840016379' => 'Hunter',
		'US1840013403' => 'Campbell Station',
		'US1840014475' => 'Oxford',
		'US1840013402' => 'Grubbs',
		'US1840015301' => 'Big Flat',
		'US1840032229' => 'St. Francis',
		'US1840016654' => 'Friendship',
		'US1840013529' => 'England',
		'US1840014841' => 'Portland',
		'US1840016343' => 'West Point',
		'US1840016491' => 'Perry',
		'US1840022809' => 'Natural Steps',
		'US1840016808' => 'East Camden',
		'US1840014506' => 'Monette',
		'US1840013539' => 'Cammack Village',
		'US1840013487' => 'Belleville',
		'US1840016122' => 'Oak Grove Heights',
		'US1840016691' => 'Daisy',
		'US1840016126' => 'Mount Pleasant',
		'US1840015375' => 'Amagon',
		'US1840015302' => 'Salesville',
		'US1840015396' => 'Wiederkehr Village',
		'US1840014784' => 'Prescott',
		'US1840015503' => 'Allport',
		'US1840016074' => 'Garfield',
		'US1840015499' => 'Bigelow',
		'US1840015555' => 'Almyra',
		'US1840013321' => 'Eureka Springs',
		'US1840015367' => 'Wilson',
		'US1840015511' => 'Sherwood',
		'US1840017730' => 'Portia',
		'US1840014582' => 'Patterson',
		'US1840016085' => 'Omaha',
		'US1840016765' => 'Perrytown',
		'US1840016300' => 'Chester',
		'US1840016811' => 'Tinsman',
		'US1840013771' => 'North Crossett',
		'US1840015298' => 'Bergman',
		'US1840013086' => 'East End',
		'US1840014707' => 'Dierks',
		'US1840016415' => 'Enola',
		'US1840015326' => 'Alicia',
		'US1840013537' => 'Alexander',
		'US1840017713' => 'Ravenden Springs',
		'US1840014503' => 'Leachville',
		'US1840013366' => 'Elm Springs',
		'US1840013322' => 'Green Forest',
		'US1840015464' => 'Mayflower',
		'US1840014709' => 'Nashville',
		'US1840025843' => 'Avilla',
		'US1840015447' => 'Turrell',
		'US1840014531' => 'Ozark',
		'US1840014635' => 'Holly Grove',
		'US1840016308' => 'Waldenburg',
		'US1840014457' => 'Piggott',
		'US1840025860' => 'Kirby',
		'US1840014805' => 'Monticello',
		'US1840014542' => 'Quitman',
		'US1840027803' => 'Landmark',
		'US1840013417' => 'Altus',
		'US1840014842' => 'Norphlet',
		'US1840014507' => 'Jonesboro',
		'US1840014633' => 'Jacksonville',
		'US1840022675' => 'Cherokee City',
		'US1840015408' => 'Weiner',
		'US1840013712' => 'Foreman',
		'US1840013325' => 'Evening Shade',
		'US1840017839' => 'Russell',
		'US1840014511' => 'Newark',
		'US1840014564' => 'Morrilton',
		'US1840014577' => 'Lavaca',
		'US1840014529' => 'Clinton',
		'US1840016076' => 'Viola',
		'US1840016225' => 'Marie',
		'US1840016614' => 'Lexa',
		'US1840017711' => 'Springtown',
		'US1840014460' => 'Knobel',
		'US1840017978' => 'Reed',
		'US1840013587' => 'Hot Springs Village',
		'US1840015654' => 'Winthrop',
		'US1840014735' => 'De Queen',
		'US1840014456' => 'Peach Orchard',
		'US1840014536' => 'Cedarville',
		'US1840025804' => 'Dennard',
		'US1840014553' => 'Pangburn',
		'US1840013414' => 'Fairfield Bay',
		'US1840016597' => 'Lonsdale',
		'US1840016598' => 'Fountain Lake',
		'US1840013425' => 'Fisher',
		'US1840016080' => 'OKean',
		'US1840016247' => 'Magness',
		'US1840015299' => 'Summit',
		'US1840013368' => 'Fayetteville',
		'US1840013329' => 'Bull Shoals',
		'US1840013741' => 'Hampton',
		'US1840015284' => 'Little Flock',
		'US1840014671' => 'Mount Ida',
		'US1840025827' => 'New Blaine',
		'US1840017949' => 'Sherrill',
		'US1840016372' => 'Menifee',
		'US1840014607' => 'Dardanelle',
		'US1840013332' => 'Greenway',
		'US1840073887' => 'Oak Grove',
		'US1840013573' => 'Bryant',
		'US1840014747' => 'Carthage',
		'US1840014516' => 'Newport',
		'US1840016493' => 'Ulm',
		'US1840015566' => 'White Hall',
		'US1840016227' => 'Dyess',
		'US1840015406' => 'Trumann',
		'US1840016238' => 'Egypt',
		'US1840013326' => 'Hardy',
		'US1840022677' => 'Maysville',
		'US1840015451' => 'Blue Mountain',
		'US1840016075' => 'Gateway',
		'US1840015336' => 'Springdale',
		'US1840014508' => 'Lake City',
		'US1840014448' => 'Pocahontas',
		'US1840016871' => 'Emerson',
		'US1840015512' => 'Wrightsville',
		'US1840025825' => 'Center Ridge',
		'US1840017731' => 'Powhatan',
		'US1840016414' => 'Mount Vernon',
		'US1840027858' => 'Helena-West Helena',
		'US1840015325' => 'Melbourne',
		'US1840013534' => 'Hensley',
		'US1840013679' => 'Fordyce',
		'US1840027804' => 'Holiday Island',
		'US1840016760' => 'McNab',
		'US1840015607' => 'Lockesburg',
		'US1840015338' => 'West Fork',
		'US1840016153' => 'Goshen',
		'US1840016488' => 'Houston',
		'US1840014476' => 'Horseshoe Bend',
		'US1840073884' => 'Fredonia',
		'US1840013615' => 'Altheimer',
		'US1840015448' => 'West Memphis',
		'US1840013536' => 'Woodson',
		'US1840016693' => 'Whelen Springs',
		'US1840022911' => 'Staves',
		'US1840013426' => 'Harrisburg',
		'US1840015546' => 'Black Springs',
		'US1840014843' => 'Huttig',
		'US1840014576' => 'Huntington',
		'US1840016186' => 'Western Grove',
		'US1840016762' => 'Oakhaven',
		'US1840016255' => 'Jacksonport',
		'US1840013466' => 'Booneville',
		'US1840025808' => 'Tumbling Shoals',
		'US1840013328' => 'Flippin',
		'US1840014685' => 'Humphrey',
		'US1840013528' => 'Austin',
		'US1840013589' => 'Piney',
		'US1840013330' => 'Gassville',
		'US1840016392' => 'Caulksville',
		'US1840014620' => 'Palestine',
		'US1840014622' => 'Perryville',
		'US1840016341' => 'Georgetown',
		'US1840027857' => 'Rockwell',
		'US1840014587' => 'Ratcliff',
		'US1840014599' => 'Holland',
		'US1840014494' => 'Leslie',
		'US1840016256' => 'Tupelo',
		'US1840015731' => 'Wilmot',
		'US1840014481' => 'Prairie Grove',
		'US1840013460' => 'Bonanza',
		'US1840014510' => 'Cushman',
		'US1840014625' => 'Hazen',
		'US1840014751' => 'Mitchellville',
		'US1840016655' => 'Perla',
		'US1840015403' => 'Hector',
		'US1840014619' => 'Colt',
		'US1840014765' => 'Hope',
		'US1840015552' => 'Marvell',
		'US1840015430' => 'Higginson',
		'US1840013682' => 'Arkansas City',
		'US1840016121' => 'Delaplaine',
		'US1840016128' => 'Guion',
		'US1840013710' => 'Emmet',
		'US1840014761' => 'Rison',
		'US1840014762' => 'Kingsland',
		'US1840013774' => 'Calion',
		'US1840013533' => 'Gibson',
		'US1840014535' => 'Lamar',
		'US1840016079' => 'Maynard',
		'US1840015405' => 'Marked Tree',
		'US1840015696' => 'Warren',
		'US1840016496' => 'Keo',
		'US1840015732' => 'Smackover',
		'US1840016191' => 'Pindall',
		'US1840016298' => 'Denning',
		'US1840014447' => 'Highland',
		'US1840013752' => 'Fouke',
		'US1840013317' => 'Gentry',
		'US1840016658' => 'Wabbaseka',
		'US1840017947' => 'Poyen',
		'US1840016377' => 'Midland',
		'US1840015535' => 'Aubrey',
		'US1840014469' => 'Huntsville',
		'US1840013772' => 'Hamburg',
		'US1840014583' => 'Clarkedale',
		'US1840015295' => 'Biggers',
		'US1840015369' => 'Black Oak',
		'US1840013365' => 'Elkins',
		'US1840016391' => 'Morrison Bluff',
		'US1840016339' => 'Letona',
		'US1840016786' => 'Willisville',
		'US1840017733' => 'Sedgwick',
		'US1840016878' => 'Felsenthal',
		'US1840015611' => 'Star City',
		'US1840017948' => 'Prattsville',
		'US1840016813' => 'Winchester',
		'US1840013770' => 'West Crossett',
		'US1840015335' => 'Lincoln',
		'US1840016088' => 'Success',
		'US1840016250' => 'Oil Trough',
		'US1840014634' => 'Clarendon',
		'US1840014598' => 'Conway',
		'US1840015639' => 'Washington',
		'US1840013736' => 'Camden',
		'US1840017732' => 'Ravenden',
		'US1840013637' => 'Amity',
		'US1840016877' => 'Fountain Hill',
		'US1840014608' => 'Ola',
		'US1840016133' => 'Lynn',
		'US1840016417' => 'Twin Groves',
		'US1840013319' => 'Bentonville',
		'US1840013418' => 'Branch',
		'US1840013638' => 'Arkadelphia',
		'US1840014839' => 'Montrose',
		'US1840013594' => 'Elaine',
		'US1840015291' => 'Mammoth Spring',
	],
	'VT' => [
		'US1840037484' => 'North Westminster',
		'US1840004302' => 'Old Bennington',
		'US1840002310' => 'Burlington',
		'US1840025408' => 'North Springfield',
		'US1840025334' => 'Newport Center',
		'US1840002218' => 'Vergennes',
		'US1840004049' => 'Derby Line',
		'US1840023975' => 'Websterville',
		'US1840004082' => 'West Burke',
		'US1840002311' => 'South Burlington',
		'US1840004166' => 'Poultney',
		'US1840004079' => 'Johnson',
		'US1840004163' => 'Wilder',
		'US1840004050' => 'North Troy',
		'US1840025403' => 'Ascutney',
		'US1840004047' => 'Barton',
		'US1840002270' => 'Newport',
		'US1840002632' => 'Rutland',
		'US1840004335' => 'Jacksonville',
		'US1840025347' => 'East Burke',
		'US1840025413' => 'South Royalton',
		'US1840004080' => 'Morrisville',
		'US1840004160' => 'Perkinsville',
		'US1840004048' => 'Derby Center',
		'US1840004032' => 'Enosburg Falls',
		'US1840023973' => 'Graniteville',
		'US1840004301' => 'North Bennington',
		'US1840002941' => 'West Brattleboro',
		'US1840004336' => 'Newfane',
		'US1840004300' => 'Manchester',
		'US1840002899' => 'Manchester Center',
		'US1840004051' => 'Orleans',
		'US1840004078' => 'Jeffersonville',
		'US1840004101' => 'Marshfield',
		'US1840004083' => 'Essex Junction',
		'US1840004132' => 'Wells River',
		'US1840004334' => 'Bellows Falls',
		'US1840002267' => 'St. Albans',
		'US1840004077' => 'Hyde Park',
		'US1840004033' => 'Swanton',
		'US1840004084' => 'Jericho',
		'US1840025407' => 'North Hartland',
		'US1840002186' => 'Barre',
		'US1840004131' => 'Newbury',
		'US1840004103' => 'Waterbury',
		'US1840025410' => 'Proctorsville',
		'US1840025331' => 'Greensboro Bend',
		'US1840004046' => 'Albany',
		'US1840002188' => 'South Barre',
		'US1840004162' => 'White River Junction',
		'US1840004338' => 'Saxtons River',
		'US1840025411' => 'Quechee',
		'US1840004161' => 'Woodstock',
		'US1840004303' => 'South Shaftsbury',
		'US1840023971' => 'East Barre',
		'US1840004081' => 'Lyndonville',
		'US1840002312' => 'Winooski',
		'US1840004076' => 'Cambridge',
		'US1840002187' => 'Montpelier',
		'US1840025378' => 'East Middlebury',
		'US1840004159' => 'Ludlow',
		'US1840025316' => 'Beecher Falls',
		'US1840004339' => 'Westminster',
		'US1840002269' => 'Island Pond',
	],
	'IL' => [
		'US1840010764' => 'Trenton',
		'US1840011789' => 'Strawn',
		'US1840012188' => 'Tilton',
		'US1840012910' => 'Bluford',
		'US1840008489' => 'Gillespie',
		'US1840024531' => 'West York',
		'US1840010321' => 'Wenona',
		'US1840009542' => 'Paris',
		'US1840025691' => 'Mulkeytown',
		'US1840012736' => 'St. Peter',
		'US1840011782' => 'Cullom',
		'US1840007034' => 'Aurora',
		'US1840007309' => 'Chrisman',
		'US1840011279' => 'Glencoe',
		'US1840025538' => 'Twin Grove',
		'US1840011989' => 'Mackinaw',
		'US1840011679' => 'North Henderson',
		'US1840011243' => 'Arlington Heights',
		'US1840011308' => 'Olympia Fields',
		'US1840012889' => 'Bone Gap',
		'US1840008449' => 'Mattoon',
		'US1840012876' => 'New Athens',
		'US1840011484' => 'Crete',
		'US1840011878' => 'Melvin',
		'US1840011926' => 'Princeville',
		'US1840012643' => 'Panama',
		'US1840012363' => 'Liberty',
		'US1840011582' => 'Sheffield',
		'US1840029748' => 'Hanaford',
		'US1840026205' => 'Apple Canyon Lake',
		'US1840008327' => 'East Peoria',
		'US1840011993' => 'South Pekin',
		'US1840011857' => 'Loda',
		'US1840011121' => 'Rockton',
		'US1840013008' => 'Dongola',
		'US1840010599' => 'Bulpitt',
		'US1840010106' => 'Cherry Valley',
		'US1840004635' => 'Pistakee Highlands',
		'US1840011691' => 'Bonfield',
		'US1840011171' => 'Round Lake Beach',
		'US1840013001' => 'Eddyville',
		'US1840026704' => 'Mitchell',
		'US1840012879' => 'Summerfield',
		'US1840010337' => 'Buckley',
		'US1840012565' => 'Exeter',
		'US1840011304' => 'Northbrook',
		'US1840012589' => 'Moweaqua',
		'US1840006974' => 'Highwood',
		'US1840011107' => 'Nora',
		'US1840007208' => 'Delavan',
		'US1840010865' => 'Buncombe',
		'US1840011787' => 'Odell',
		'US1840011288' => 'Robbins',
		'US1840012440' => 'Berlin',
		'US1840011409' => 'Willowbrook',
		'US1840009271' => 'Streator',
		'US1840010803' => 'Waterloo',
		'US1840009132' => 'Rockford',
		'US1840013002' => 'Belknap',
		'US1840008579' => 'Flora',
		'US1840011928' => 'Norwood',
		'US1840011184' => 'Wauconda',
		'US1840011764' => 'Rio',
		'US1840007465' => 'Centralia',
		'US1840011318' => 'Worth',
		'US1840007162' => 'Henry',
		'US1840010214' => 'Channahon',
		'US1840012987' => 'Freeman Spur',
		'US1840010590' => 'Waverly',
		'US1840011977' => 'Danvers',
		'US1840011703' => 'Manteno',
		'US1840011587' => 'Orion',
		'US1840007050' => 'Amboy',
		'US1840012909' => 'Belle Rive',
		'US1840011306' => 'Oak Lawn',
		'US1840011162' => 'Lincolnshire',
		'US1840012759' => 'Rose Hill',
		'US1840011342' => 'Big Rock',
		'US1840012812' => 'Louisville',
		'US1840011684' => 'Granville',
		'US1840011119' => 'Winslow',
		'US1840007364' => 'Hillsboro',
		'US1840012975' => 'Raleigh',
		'US1840011105' => 'Elizabeth',
		'US1840012647' => 'Walshville',
		'US1840011771' => 'La Rose',
		'US1840008341' => 'Nauvoo',
		'US1840008488' => 'Nokomis',
		'US1840012926' => 'Norris City',
		'US1840010783' => 'Alorton',
		'US1840011172' => 'Round Lake Heights',
		'US1840010320' => 'Toluca',
		'US1840011305' => 'Northfield',
		'US1840010833' => 'West Frankfort',
		'US1840012656' => 'Modesto',
		'US1840012714' => 'Fidelity',
		'US1840012794' => 'East Alton',
		'US1840012733' => 'Bingham',
		'US1840025612' => 'West Union',
		'US1840011978' => 'Downs',
		'US1840012227' => 'Rantoul',
		'US1840012365' => 'Loraine',
		'US1840010324' => 'Alexis',
		'US1840012510' => 'Concord',
		'US1840004636' => 'Forest Lake',
		'US1840004817' => 'Fairmont',
		'US1840011485' => 'Elwood',
		'US1840008082' => 'Galena',
		'US1840010144' => 'Burnham',
		'US1840012451' => 'New Berlin',
		'US1840008325' => 'Le Roy',
		'US1840010451' => 'Urbana',
		'US1840011863' => 'Onarga',
		'US1840011859' => 'Danforth',
		'US1840009688' => 'Mason',
		'US1840012316' => 'Wapella',
		'US1840012018' => 'Smithfield',
		'US1840011351' => 'North Aurora',
		'US1840011689' => 'Standard',
		'US1840011403' => 'Hinsdale',
		'US1840011788' => 'Saunemin',
		'US1840011118' => 'Pearl City',
		'US1840011422' => 'Lyndon',
		'US1840007025' => 'Country Club Hills',
		'US1840007030' => 'Hickory Hills',
		'US1840012320' => 'Bement',
		'US1840011433' => 'Steward',
		'US1840012898' => 'Valmeyer',
		'US1840011701' => 'St. Anne',
		'US1840008197' => 'Earlville',
		'US1840007466' => 'Carlyle',
		'US1840012650' => 'Hettick',
		'US1840011232' => 'Leaf River',
		'US1840007235' => 'Danville',
		'US1840008135' => 'Geneva',
		'US1840012779' => 'Donnellson',
		'US1840010765' => 'Albers',
		'US1840011412' => 'Villa Park',
		'US1840012946' => 'St. Johns',
		'US1840141570' => 'Candlewick Lake',
		'US1840011439' => 'Coal Valley',
		'US1840012843' => 'Iuka',
		'US1840009276' => 'Princeton',
		'US1840012560' => 'Bethany',
		'US1840004640' => 'Long Lake',
		'US1840010166' => 'Wheaton',
		'US1840010818' => 'Burnt Prairie',
		'US1840011920' => 'Bartonville',
		'US1840012761' => 'Willow Hill',
		'US1840011330' => 'Thornton',
		'US1840006971' => 'Belvidere',
		'US1840012321' => 'Hammond',
		'US1840011769' => 'Victoria',
		'US1840011879' => 'Piper City',
		'US1840011729' => 'Bradford',
		'US1840011259' => 'Lincolnwood',
		'US1840011406' => 'Glendale Heights',
		'US1840011573' => 'Dover',
		'US1840010143' => 'Buffalo Grove',
		'US1840012911' => 'Bonnie',
		'US1840008565' => 'Granite City',
		'US1840009452' => 'Rushville',
		'US1840012867' => 'Dupo',
		'US1840012989' => 'Spillertown',
		'US1840011347' => 'Elburn',
		'US1840009841' => 'Red Bud',
		'US1840011971' => 'Bellflower',
		'US1840010852' => 'Bush',
		'US1840011127' => 'Greenwood',
		'US1840009485' => 'Macon',
		'US1840011167' => 'Deerfield',
		'US1840007239' => 'Champaign',
		'US1840012743' => 'Watson',
		'US1840007542' => 'Christopher',
		'US1840010559' => 'Cantrall',
		'US1840013020' => 'Tamms',
		'US1840012851' => 'Aviston',
		'US1840011164' => 'Long Grove',
		'US1840011163' => 'Lindenhurst',
		'US1840011278' => 'Franklin Park',
		'US1840010727' => 'Clay City',
		'US1840008086' => 'North Chicago',
		'US1840011488' => 'Rockdale',
		'US1840011973' => 'Heyworth',
		'US1840011410' => 'Winfield',
		'US1840012566' => 'Glasgow',
		'US1840011130' => 'Lakemoor',
		'US1840012849' => 'Vernon',
		'US1840006970' => 'Harvard',
		'US1840013005' => 'New Burnside',
		'US1840007365' => 'Bunker Hill',
		'US1840011179' => 'Third Lake',
		'US1840010111' => 'Caledonia',
		'US1840012754' => 'Flat Rock',
		'US1840011341' => 'Waterman',
		'US1840012430' => 'Niantic',
		'US1840011357' => 'West Dundee',
		'US1840011429' => 'Compton',
		'US1840011438' => 'Hillsdale',
		'US1840012930' => 'Macedonia',
		'US1840011781' => 'Cornell',
		'US1840011271' => 'Elk Grove Village',
		'US1840012640' => 'Fillmore',
		'US1840010835' => 'Buckner',
		'US1840009552' => 'Sullivan',
		'US1840012228' => 'Royal',
		'US1840010216' => 'Yorkville',
		'US1840012914' => 'Woodlawn',
		'US1840010107' => 'Woodstock',
		'US1840012548' => 'Owaneco',
		'US1840008143' => 'Naperville',
		'US1840012884' => 'Johnsonville',
		'US1840011145' => 'Union',
		'US1840012667' => 'Rockbridge',
		'US1840011613' => 'Coal City',
		'US1840012221' => 'Ivesdale',
		'US1840012844' => 'Junction City',
		'US1840011922' => 'Hanna City',
		'US1840012901' => 'Du Bois',
		'US1840012231' => 'Ludlow',
		'US1840011408' => 'Oak Brook',
		'US1840012637' => 'Irving',
		'US1840029820' => 'St. Rose',
		'US1840011303' => 'North Riverside',
		'US1840010505' => 'Camp Point',
		'US1840011540' => 'Sheridan',
		'US1840012801' => 'Maryville',
		'US1840007367' => 'Benld',
		'US1840025595' => 'Westervelt',
		'US1840011175' => 'Mundelein',
		'US1840012655' => 'Medora',
		'US1840010376' => 'Anchor',
		'US1840009180' => 'Savanna',
		'US1840011864' => 'Papineau',
		'US1840011508' => 'Oswego',
		'US1840011339' => 'Shabbona',
		'US1840012657' => 'Mount Clare',
		'US1840012783' => 'Pierron',
		'US1840011876' => 'Elliott',
		'US1840010400' => 'Warsaw',
		'US1840008127' => 'Mount Carroll',
		'US1840011296' => 'Melrose Park',
		'US1840009181' => 'Palos Heights',
		'US1840009352' => 'Pontiac',
		'US1840011331' => 'Tinley Park',
		'US1840012398' => 'Greenview',
		'US1840012020' => 'Vermont',
		'US1840012545' => 'Edinburg',
		'US1840010781' => 'Cahokia',
		'US1840008293' => 'El Paso',
		'US1840005203' => 'Rome',
		'US1840011297' => 'Merrionette Park',
		'US1840011286' => 'Riverdale',
		'US1840011157' => 'Lake Barrington',
		'US1840011980' => 'McLean',
		'US1840012361' => 'Golden',
		'US1840008328' => 'Marquette Heights',
		'US1840008550' => 'Newton',
		'US1840012685' => 'Kampsville',
		'US1840012845' => 'Kell',
		'US1840010240' => 'Cherry',
		'US1840008129' => 'Evanston',
		'US1840007402' => 'Altamont',
		'US1840009189' => 'Cortland',
		'US1840012905' => 'Oakdale',
		'US1840011282' => 'Posen',
		'US1840008775' => 'Mounds',
		'US1840011987' => 'Creve Coeur',
		'US1840011481' => 'Beecher',
		'US1840011140' => 'McCullom Lake',
		'US1840011619' => 'South Wilmington',
		'US1840011856' => 'Iroquois',
		'US1840011494' => 'Peotone',
		'US1840012425' => 'Blue Mound',
		'US1840010804' => 'Addieville',
		'US1840007206' => 'Chenoa',
		'US1840012178' => 'Indianola',
		'US1840012971' => 'New Haven',
		'US1840011620' => 'Verona',
		'US1840008198' => 'Marseilles',
		'US1840012367' => 'Columbus',
		'US1840007576' => 'Herrin',
		'US1840010711' => 'Wood River',
		'US1840012512' => 'Lynnville',
		'US1840024658' => 'Rentchler',
		'US1840011432' => 'Paw Paw',
		'US1840007022' => 'Burbank',
		'US1840012799' => 'St. Jacob',
		'US1840008493' => 'Marshall',
		'US1840012205' => 'Bath',
		'US1840012805' => 'South Roxana',
		'US1840012967' => 'Vergennes',
		'US1840010476' => 'Broadwell',
		'US1840011356' => 'Virgil',
		'US1840011237' => 'Monroe Center',
		'US1840011267' => 'Crestwood',
		'US1840007207' => 'Bloomington',
		'US1840012784' => 'Smithboro',
		'US1840012734' => 'Farina',
		'US1840004819' => 'Lakewood Shores',
		'US1840010288' => 'Buckingham',
		'US1840012318' => 'Weldon',
		'US1840011294' => 'Maywood',
		'US1840025503' => 'Chemung',
		'US1840010650' => 'Shipman',
		'US1840011423' => 'Tampico',
		'US1840011542' => 'Troy Grove',
		'US1840012317' => 'Waynesville',
		'US1840012105' => 'Plymouth',
		'US1840011773' => 'Sparland',
		'US1840010108' => 'Bull Valley',
		'US1840009894' => 'Rosiclare',
		'US1840012187' => 'Sidell',
		'US1840006973' => 'Highland Park',
		'US1840011539' => 'Seneca',
		'US1840011800' => 'Roseville',
		'US1840012665' => 'Hillview',
		'US1840011144' => 'Trout Valley',
		'US1840010319' => 'Altona',
		'US1840010170' => 'Clarendon Hills',
		'US1840011698' => 'Hopkins Park',
		'US1840007023' => 'Calumet City',
		'US1840012209' => 'San Jose',
		'US1840010853' => 'Cambria',
		'US1840011790' => 'Biggsville',
		'US1840012233' => 'Ogden',
		'US1840011141' => 'Oakwood Hills',
		'US1840009272' => 'Ottawa',
		'US1840011988' => 'Deer Creek',
		'US1840012542' => 'Time',
		'US1840010375' => 'Carlock',
		'US1840011320' => 'Schiller Park',
		'US1840012514' => 'Murrayville',
		'US1840008200' => 'Oglesby',
		'US1840012811' => 'Sailor Springs',
		'US1840029894' => 'Channel Lake',
		'US1840012505' => 'Vermilion',
		'US1840008712' => 'Marion',
		'US1840011944' => 'Roanoke',
		'US1840010710' => 'Venice',
		'US1840012874' => 'Marissa',
		'US1840012896' => 'Fults',
		'US1840073810' => 'Eagarville',
		'US1840010148' => 'Burlington',
		'US1840012368' => 'Mendon',
		'US1840012011' => 'London Mills',
		'US1840012502' => 'Hume',
		'US1840010785' => 'Cisne',
		'US1840012564' => 'Bluffs',
		'US1840011981' => 'Saybrook',
		'US1840008087' => 'Lake Forest',
		'US1840011285' => 'River Grove',
		'US1840012234' => 'Pesotum',
		'US1840011268' => 'Dixmoor',
		'US1840012369' => 'Payson',
		'US1840012913' => 'Dix',
		'US1840012432' => 'Warrensburg',
		'US1840008204' => 'Galva',
		'US1840012762' => 'Yale',
		'US1840010605' => 'Alsey',
		'US1840025554' => 'Beason',
		'US1840010588' => 'Villa Grove',
		'US1840008279' => 'Lacon',
		'US1840009184' => 'Prospect Heights',
		'US1840010602' => 'Allenville',
		'US1840011994' => 'Tremont',
		'US1840012207' => 'Easton',
		'US1840011939' => 'Benson',
		'US1840011289' => 'Rosemont',
		'US1840008564' => 'Edwardsville',
		'US1840012511' => 'Franklin',
		'US1840009368' => 'Paxton',
		'US1840010649' => 'Chesterfield',
		'US1840011767' => 'Williamsfield',
		'US1840012785' => 'Sorento',
		'US1840012179' => 'Fairmount',
		'US1840011109' => 'Stockton',
		'US1840011272' => 'Elmwood Park',
		'US1840008631' => 'Mascoutah',
		'US1840008131' => 'Northlake',
		'US1840010591' => 'Chapin',
		'US1840007262' => 'Athens',
		'US1840007269' => 'Decatur',
		'US1840006153' => 'Breese',
		'US1840011940' => 'Goodfield',
		'US1840009273' => 'Peru',
		'US1840011862' => 'Milford',
		'US1840011129' => 'Lake in the Hills',
		'US1840009177' => 'Oregon',
		'US1840007370' => 'Casey',
		'US1840008376' => 'Farmer City',
		'US1840012323' => 'Mansfield',
		'US1840029810' => 'Reddick',
		'US1840011295' => 'McCook',
		'US1840010192' => 'Andalusia',
		'US1840008130' => 'Markham',
		'US1840011122' => 'Roscoe',
		'US1840012902' => 'Radom',
		'US1840011793' => 'Gladstone',
		'US1840008148' => 'Fulton',
		'US1840008128' => 'Lanark',
		'US1840012222' => 'Longview',
		'US1840008081' => 'East Dubuque',
		'US1840012236' => 'Savoy',
		'US1840012237' => 'Sidney',
		'US1840004812' => 'Coyne Center',
		'US1840007174' => 'Chillicothe',
		'US1840009517' => 'Springfield',
		'US1840011702' => 'Sammons Point',
		'US1840008084' => 'Marengo',
		'US1840025551' => 'Penfield',
		'US1840010834' => 'Zeigler',
		'US1840026206' => 'Knollwood',
		'US1840012948' => 'Tamaroa',
		'US1840011427' => 'Harmon',
		'US1840012653' => 'East Gillespie',
		'US1840010850' => 'Carrier Mills',
		'US1840011695' => 'Irwin',
		'US1840009852' => 'Sesser',
		'US1840009781' => 'Sumner',
		'US1840011135' => 'Fox River Grove',
		'US1840011985' => 'Green Valley',
		'US1840024614' => 'Whiteash',
		'US1840012900' => 'Hoyleton',
		'US1840012984' => 'Colp',
		'US1840012781' => 'Mulberry Grove',
		'US1840012103' => 'Elvaston',
		'US1840011796' => 'Oquawka',
		'US1840011855' => 'Beaverville',
		'US1840012928' => 'Springerton',
		'US1840011143' => 'Spring Grove',
		'US1840011325' => 'Steger',
		'US1840012208' => 'Forest City',
		'US1840009603' => 'Nilwood',
		'US1840011420' => 'Deer Grove',
		'US1840010140' => 'Bridgeview',
		'US1840007220' => 'Hamilton',
		'US1840011948' => 'Spring Bay',
		'US1840012969' => 'Equality',
		'US1840010694' => 'Brownstown',
		'US1840011588' => 'Woodhull',
		'US1840010290' => 'Chebanse',
		'US1840007633' => 'Cairo',
		'US1840012664' => 'Kane',
		'US1840011693' => 'Bradley',
		'US1840012956' => 'Valier',
		'US1840009568' => 'Shelbyville',
		'US1840011254' => 'Kenilworth',
		'US1840011349' => 'Maple Park',
		'US1840011274' => 'Flossmoor',
		'US1840011181' => 'Vernon Hills',
		'US1840012206' => 'Kilbourne',
		'US1840011126' => 'Winnebago',
		'US1840010109' => 'Cary',
		'US1840012531' => 'Hull',
		'US1840011482' => 'Bolingbrook',
		'US1840012800' => 'Marine',
		'US1840007218' => 'Dallas City',
		'US1840012791' => 'Hamel',
		'US1840011970' => 'Arrowsmith',
		'US1840012793' => 'Livingston',
		'US1840007324' => 'Charleston',
		'US1840011160' => 'Lake Zurich',
		'US1840011292' => 'Lyons',
		'US1840012848' => 'Patoka',
		'US1840011585' => 'Bishop Hill',
		'US1840011945' => 'Metamora',
		'US1840010759' => 'Central City',
		'US1840011262' => 'Hodgkins',
		'US1840011983' => 'Towanda',
		'US1840011142' => 'Wonder Lake',
		'US1840008701' => 'Murphysboro',
		'US1840012563' => 'Lovington',
		'US1840009867' => 'Shawneetown',
		'US1840012185' => 'Muncie',
		'US1840006448' => 'Brookport',
		'US1840011537' => 'Lostant',
		'US1840011487' => 'Godley',
		'US1840012308' => 'Elkhart',
		'US1840012661' => 'Scottville',
		'US1840012846' => 'Sandoval',
		'US1840012792' => 'Hartford',
		'US1840008295' => 'Minonk',
		'US1840012662' => 'Standard City',
		'US1840012535' => 'Milton',
		'US1840012646' => 'Waggoner',
		'US1840011244' => 'Barrington',
		'US1840010482' => 'Browning',
		'US1840012008' => 'Banner',
		'US1840011784' => 'Emington',
		'US1840008545' => 'Effingham',
		'US1840012013' => 'Ellisville',
		'US1840010353' => 'Brimfield',
		'US1840012536' => 'Nebo',
		'US1840012310' => 'Middletown',
		'US1840011338' => 'Malta',
		'US1840007212' => 'Canton',
		'US1840009275' => 'Spring Valley',
		'US1840029744' => 'Gulf Port',
		'US1840009401' => 'Normal',
		'US1840008199' => 'Mendota',
		'US1840012455' => 'Sherman',
		'US1840011168' => 'Fox Lake',
		'US1840012182' => 'Rankin',
		'US1840012940' => 'Steeleville',
		'US1840011405' => 'Glen Ellyn',
		'US1840012427' => 'Long Creek',
		'US1840011169' => 'Riverwoods',
		'US1840024656' => 'Floraville',
		'US1840009716' => 'Madison',
		'US1840012939' => 'Percy',
		'US1840010709' => 'Troy',
		'US1840012180' => 'Fithian',
		'US1840025671' => 'Opdyke',
		'US1840029830' => 'Tower Lakes',
		'US1840008512' => 'Neoga',
		'US1840011257' => 'Lansing',
		'US1840008774' => 'Mound City',
		'US1840011692' => 'Bourbonnais',
		'US1840012014' => 'Fairview',
		'US1840011493' => 'New Lenox',
		'US1840009185' => 'Rolling Meadows',
		'US1840012225' => 'Foosland',
		'US1840012636' => 'Harvel',
		'US1840010233' => 'Cedar Point',
		'US1840009548' => 'Pana',
		'US1840011774' => 'Varna',
		'US1840010167' => 'Wood Dale',
		'US1840012648' => 'Wenonah',
		'US1840011235' => 'Davis Junction',
		'US1840012400' => 'Tallula',
		'US1840011685' => 'Hennepin',
		'US1840013009' => 'Mill Creek',
		'US1840011277' => 'Forest View',
		'US1840007029' => 'Harvey',
		'US1840008278' => 'Knoxville',
		'US1840011697' => 'Herscher',
		'US1840025535' => 'Gilson',
		'US1840011276' => 'Forest Park',
		'US1840010506' => 'Clayton',
		'US1840012016' => 'Marietta',
		'US1840007315' => 'Griggsville',
		'US1840026246' => 'Como',
		'US1840012426' => 'Harristown',
		'US1840011578' => 'New Bedford',
		'US1840011772' => 'Hopewell',
		'US1840011133' => 'Holiday Hills',
		'US1840012642' => 'Ohlman',
		'US1840011161' => 'Libertyville',
		'US1840007098' => 'Colona',
		'US1840012810' => 'Iola',
		'US1840009178' => 'Polo',
		'US1840025556' => 'Cornland',
		'US1840025545' => 'Olivet',
		'US1840007314' => 'Barry',
		'US1840011687' => 'Mark',
		'US1840011401' => 'Lisle',
		'US1840026611' => 'Langleyville',
		'US1840012934' => 'Ellis Grove',
		'US1840010452' => 'Broadlands',
		'US1840011941' => 'Kappa',
		'US1840010377' => 'Washington',
		'US1840011139' => 'Ringwood',
		'US1840011323' => 'South Chicago Heights',
		'US1840073807' => 'La Fayette',
		'US1840009182' => 'Palos Hills',
		'US1840008134' => 'Elgin',
		'US1840012544' => 'Kincaid',
		'US1840025717' => 'Crab Orchard',
		'US1840012832' => 'Russellville',
		'US1840012186' => 'Oakwood',
		'US1840011795' => 'Media',
		'US1840024530' => 'Annapolis',
		'US1840010147' => 'Alsip',
		'US1840009200' => 'Sterling',
		'US1840012833' => 'Noble',
		'US1840007088' => 'Crest Hill',
		'US1840008673' => 'Du Quoin',
		'US1840004634' => 'Lake Summerset',
		'US1840024657' => 'Paderborn',
		'US1840011868' => 'Wellington',
		'US1840008294' => 'Eureka',
		'US1840011696' => 'Limestone',
		'US1840073774' => 'Scott AFB',
		'US1840011173' => 'Round Lake Park',
		'US1840011492' => 'Monee',
		'US1840025713' => 'Harrison',
		'US1840011340' => 'Somonauk',
		'US1840011240' => 'Milledgeville',
		'US1840012931' => 'Baldwin',
		'US1840007045' => 'Darien',
		'US1840011866' => 'Sheldon',
		'US1840011275' => 'Ford Heights',
		'US1840012895' => 'Hecker',
		'US1840011245' => 'Barrington Hills',
		'US1840012429' => 'Mount Zion',
		'US1840008629' => 'East St. Louis',
		'US1840011569' => 'Ladd',
		'US1840013018' => 'East Cape Girardeau',
		'US1840010114' => 'Zion',
		'US1840010528' => 'Virginia',
		'US1840012311' => 'New Holland',
		'US1840012886' => 'Mount Erie',
		'US1840007368' => 'Carrollton',
		'US1840010529' => 'Chandlerville',
		'US1840013023' => 'Karnak',
		'US1840011927' => 'Mapleton',
		'US1840012314' => 'Kenney',
		'US1840012924' => 'Maunie',
		'US1840011115' => 'Ridott',
		'US1840010104' => 'Apple River',
		'US1840010485' => 'Cisco',
		'US1840012988' => 'Pittsburg',
		'US1840012742' => 'Teutopolis',
		'US1840012445' => 'Curran',
		'US1840008633' => 'Lebanon',
		'US1840011281' => 'Glenwood',
		'US1840012532' => 'Detroit',
		'US1840009256' => 'Lockport',
		'US1840011921' => 'Bellevue',
		'US1840011975' => 'Colfax',
		'US1840011327' => 'Stone Park',
		'US1840011314' => 'Phoenix',
		'US1840012543' => 'Jeisyville',
		'US1840011762' => 'Henderson',
		'US1840012802' => 'New Douglas',
		'US1840026220' => 'Prestbury',
		'US1840004821' => 'Boulder Hill',
		'US1840011336' => 'Kirkland',
		'US1840008773' => 'Metropolis',
		'US1840007268' => 'Beardstown',
		'US1840012882' => 'Golden Gate',
		'US1840012970' => 'Ridgway',
		'US1840012101' => 'Basco',
		'US1840010648' => 'Brighton',
		'US1840013025' => 'New Grand Chain',
		'US1840012111' => 'Industry',
		'US1840012211' => 'Topeka',
		'US1840012904' => 'New Minden',
		'US1840010243' => 'Cambridge',
		'US1840011699' => 'Essex',
		'US1840012758' => 'Hidalgo',
		'US1840011441' => 'Port Byron',
		'US1840012954' => 'Royalton',
		'US1840012104' => 'Ferris',
		'US1840010238' => 'Buda',
		'US1840012177' => 'Henning',
		'US1840012578' => 'Ashmore',
		'US1840012452' => 'Pawnee',
		'US1840008149' => 'Morrison',
		'US1840010645' => 'Witt',
		'US1840011104' => 'Hanover',
		'US1840008257' => 'New Boston',
		'US1840012530' => 'Kinderhook',
		'US1840012953' => 'Ewing',
		'US1840011583' => 'Tiskilwa',
		'US1840011353' => 'Sleepy Hollow',
		'US1840012790' => 'Grantfork',
		'US1840011982' => 'Stanford',
		'US1840011444' => 'Milan',
		'US1840011612' => 'Kinsman',
		'US1840007161' => 'Abingdon',
		'US1840007423' => 'Collinsville',
		'US1840026556' => 'Lake Petersburg',
		'US1840009789' => 'Salem',
		'US1840026300' => 'Lake Holiday',
		'US1840011290' => 'Sauk Village',
		'US1840008530' => 'Jerseyville',
		'US1840029901' => 'Heritage Lake',
		'US1840012888' => 'Wayne City',
		'US1840010647' => 'Virden',
		'US1840011765' => 'St. Augustine',
		'US1840008671' => 'McLeansboro',
		'US1840012666' => 'Eldred',
		'US1840007238' => 'Havana',
		'US1840011324' => 'South Holland',
		'US1840011431' => 'Nelson',
		'US1840025577' => 'Boody',
		'US1840011280' => 'Glenview',
		'US1840012229' => 'Sadorus',
		'US1840012649' => 'Lake Ka-Ho',
		'US1840012442' => 'Jerome',
		'US1840073773' => 'Rock Island Arsenal',
		'US1840011570' => 'Hollowayville',
		'US1840012176' => 'Bismarck',
		'US1840008330' => 'Farmington',
		'US1840010304' => 'Wyoming',
		'US1840011854' => 'Ashkum',
		'US1840011131' => 'Lakewood',
		'US1840012322' => 'De Land',
		'US1840012587' => 'Cowden',
		'US1840010760' => 'Alma',
		'US1840012804' => 'Worden',
		'US1840006131' => 'Bridgeport',
		'US1840012113' => 'Sciota',
		'US1840012715' => 'Fieldon',
		'US1840011860' => 'Donovan',
		'US1840012239' => 'Tolono',
		'US1840009844' => 'Pinckneyville',
		'US1840009201' => 'Prophetstown',
		'US1840012431' => 'Oreana',
		'US1840011291' => 'Lynwood',
		'US1840012966' => 'Makanda',
		'US1840011688' => 'McNabb',
		'US1840012682' => 'Batchtown',
		'US1840011686' => 'Magnolia',
		'US1840011763' => 'East Galesburg',
		'US1840008563' => 'Greenville',
		'US1840013007' => 'Cobden',
		'US1840011283' => 'Richton Park',
		'US1840011867' => 'Thawville',
		'US1840011249' => 'Berkeley',
		'US1840011611' => 'Braceville',
		'US1840012533' => 'El Dara',
		'US1840012964' => 'Dowell',
		'US1840011794' => 'Raritan',
		'US1840011581' => 'Seatonville',
		'US1840012456' => 'Southern View',
		'US1840012109' => 'Blandinsville',
		'US1840012899' => 'Irvington',
		'US1840008632' => 'OFallon',
		'US1840012534' => 'Florence',
		'US1840012110' => 'Good Hope',
		'US1840011128' => 'Johnsburg',
		'US1840008397' => 'Maroa',
		'US1840012508' => 'Hindsboro',
		'US1840012538' => 'Pearl',
		'US1840009469' => 'Petersburg',
		'US1840025555' => 'Chestnut',
		'US1840010169' => 'Carol Stream',
		'US1840011614' => 'Diamond',
		'US1840009190' => 'St. Charles',
		'US1840011266' => 'Inverness',
		'US1840012854' => 'Hoffman',
		'US1840009411' => 'Macomb',
		'US1840011309' => 'Orland Hills',
		'US1840011258' => 'Lemont',
		'US1840013021' => 'Thebes',
		'US1840012238' => 'Thomasboro',
		'US1840025559' => 'White Heath',
		'US1840007028' => 'Blue Island',
		'US1840009691' => 'Robinson',
		'US1840011299' => 'Morton Grove',
		'US1840007486' => 'Belleville',
		'US1840010788' => 'Browns',
		'US1840011571' => 'Dalzell',
		'US1840012713' => 'Elsah',
		'US1840009188' => 'Sandwich',
		'US1840010164' => 'Warrenville',
		'US1840007026' => 'Countryside',
		'US1840011404' => 'Downers Grove',
		'US1840009258' => 'Plano',
		'US1840011875' => 'Kempton',
		'US1840008132' => 'Oak Forest',
		'US1840011992' => 'North Pekin',
		'US1840011865' => 'Woodland',
		'US1840007301' => 'Auburn',
		'US1840011580' => 'Wyanet',
		'US1840011334' => 'Wheeling',
		'US1840011242' => 'Thomson',
		'US1840011106' => 'Menominee',
		'US1840011445' => 'Oak Grove',
		'US1840013026' => 'Olmsted',
		'US1840012958' => 'West City',
		'US1840012580' => 'Humboldt',
		'US1840011337' => 'Hinckley',
		'US1840009782' => 'St. Francisville',
		'US1840012847' => 'Odin',
		'US1840000494' => 'Chicago',
		'US1840012453' => 'Pleasant Plains',
		'US1840011568' => 'La Moille',
		'US1840011618' => 'Minooka',
		'US1840012663' => 'White City',
		'US1840011536' => 'Rutland',
		'US1840008133' => 'Genoa',
		'US1840024655' => 'Darmstadt',
		'US1840012986' => 'Energy',
		'US1840011348' => 'Gilberts',
		'US1840012226' => 'Gifford',
		'US1840012985' => 'Crainville',
		'US1840011260' => 'Hazel Crest',
		'US1840009851' => 'Orient',
		'US1840012107' => 'West Point',
		'US1840012539' => 'Perry',
		'US1840009466' => 'Quincy',
		'US1840012873' => 'Sauget',
		'US1840010141' => 'Broadview',
		'US1840012690' => 'Greenup',
		'US1840011678' => 'Matherville',
		'US1840009687' => 'St. Elmo',
		'US1840008630' => 'Fairview Heights',
		'US1840010115' => 'Antioch',
		'US1840008700' => 'Grand Tower',
		'US1840012513' => 'Meredosia',
		'US1840011929' => 'Peoria Heights',
		'US1840004639' => 'Grandwood Park',
		'US1840012932' => 'Kaskaskia',
		'US1840012551' => 'Tovey',
		'US1840012591' => 'Stewardson',
		'US1840011132' => 'Hebron',
		'US1840007574' => 'Creal Springs',
		'US1840012922' => 'Crossville',
		'US1840011567' => 'Arlington',
		'US1840007316' => 'Assumption',
		'US1840011768' => 'Yates City',
		'US1840012102' => 'Bowen',
		'US1840011315' => 'Willow Springs',
		'US1840026218' => 'Grand Detour',
		'US1840011151' => 'Green Oaks',
		'US1840012019' => 'Table Grove',
		'US1840011136' => 'Port Barrington',
		'US1840011531' => 'Kangley',
		'US1840011270' => 'East Hazel Crest',
		'US1840012907' => 'Venedy',
		'US1840011534' => 'Dana',
		'US1840008736' => 'Golconda',
		'US1840010847' => 'Campbell Hill',
		'US1840012789' => 'Bethalto',
		'US1840011785' => 'Flanagan',
		'US1840008713' => 'Johnston City',
		'US1840008280' => 'Fairbury',
		'US1840010758' => 'Wamac',
		'US1840012638' => 'Coalton',
		'US1840012449' => 'Rochester',
		'US1840012579' => 'Lerna',
		'US1840011976' => 'Cooksville',
		'US1840011442' => 'Rapids City',
		'US1840025515' => 'Dayton',
		'US1840011238' => 'Mount Morris',
		'US1840010780' => 'Brooklyn',
		'US1840010245' => 'Alpha',
		'US1840011352' => 'Pingree Grove',
		'US1840012973' => 'Omaha',
		'US1840012017' => 'Norris',
		'US1840011134' => 'Huntley',
		'US1840009402' => 'Pekin',
		'US1840007529' => 'Chester',
		'US1840011250' => 'Golf',
		'US1840011261' => 'Hillside',
		'US1840010241' => 'Annawan',
		'US1840012183' => 'Ridge Farm',
		'US1840011407' => 'Roselle',
		'US1840011253' => 'Justice',
		'US1840011413' => 'Wayne',
		'US1840029895' => 'Lake Catherine',
		'US1840011402' => 'Lombard',
		'US1840012881' => 'Washington Park',
		'US1840029738' => 'Gibson City',
		'US1840010589' => 'Camargo',
		'US1840011797' => 'Stronghurst',
		'US1840008085' => 'McHenry',
		'US1840012309' => 'Emden',
		'US1840012684' => 'Hardin',
		'US1840025549' => 'Goofy Ridge',
		'US1840012798' => 'Roxana',
		'US1840012220' => 'Bondville',
		'US1840029893' => 'Lost Nation',
		'US1840009187' => 'Sycamore',
		'US1840007021' => 'Byron',
		'US1840011112' => 'Dakota',
		'US1840012189' => 'Westville',
		'US1840011504' => 'Lisbon',
		'US1840012458' => 'Thayer',
		'US1840011137' => 'Prairie Grove',
		'US1840012541' => 'Valley City',
		'US1840011498' => 'Symerton',
		'US1840012965' => 'Elkville',
		'US1840012424' => 'Argenta',
		'US1840012880' => 'Swansea',
		'US1840011316' => 'Wilmette',
		'US1840008651' => 'Nashville',
		'US1840012012' => 'Dunfermline',
		'US1840010819' => 'Broughton',
		'US1840011123' => 'Machesney Park',
		'US1840009353' => 'Chatsworth',
		'US1840008260' => 'Kankakee',
		'US1840010110' => 'Algonquin',
		'US1840011574' => 'Malden',
		'US1840012428' => 'Forsyth',
		'US1840011483' => 'Homer Glen',
		'US1840012112' => 'Prairie City',
		'US1840011491' => 'Mokena',
		'US1840011946' => 'Panola',
		'US1840012114' => 'Tennessee',
		'US1840011248' => 'Bellwood',
		'US1840011174' => 'Mettawa',
		'US1840011496' => 'Shorewood',
		'US1840012651' => 'Dorchester',
		'US1840009545' => 'Pittsfield',
		'US1840011301' => 'Niles',
		'US1840012763' => 'Wheeler',
		'US1840012593' => 'Tower Hill',
		'US1840008494' => 'Martinsville',
		'US1840011153' => 'Hainesville',
		'US1840011532' => 'Leland',
		'US1840011615' => 'East Brooklyn',
		'US1840010145' => 'Calumet Park',
		'US1840025642' => 'Holiday Shores',
		'US1840011923' => 'Kingston Mines',
		'US1840012399' => 'Oakford',
		'US1840011149' => 'Beach Park',
		'US1840011792' => 'Lomax',
		'US1840012516' => 'South Jacksonville',
		'US1840010175' => 'Albany',
		'US1840012738' => 'Dieterich',
		'US1840012778' => 'Keyesport',
		'US1840011683' => 'Viola',
		'US1840007560' => 'Carbondale',
		'US1840010336' => 'Watseka',
		'US1840008377' => 'Monticello',
		'US1840011246' => 'Bartlett',
		'US1840011256' => 'La Grange Park',
		'US1840010664' => 'Brussels',
		'US1840007024' => 'Chicago Heights',
		'US1840010146' => 'Chicago Ridge',
		'US1840011165' => 'Indian Creek',
		'US1840012887' => 'Sims',
		'US1840011269' => 'Dolton',
		'US1840008614' => 'Kinmundy',
		'US1840012592' => 'Strasburg',
		'US1840011786' => 'Forrest',
		'US1840013000' => 'Elizabethtown',
		'US1840009840' => 'Sparta',
		'US1840010303' => 'Toulon',
		'US1840011239' => 'Stillman Valley',
		'US1840011495' => 'Plainfield',
		'US1840007051' => 'Dixon',
		'US1840012855' => 'Huey',
		'US1840012927' => 'Phillipstown',
		'US1840008737' => 'Jonesboro',
		'US1840008438' => 'Jacksonville',
		'US1840012933' => 'Coulterville',
		'US1840012506' => 'Arthur',
		'US1840009783' => 'Olney',
		'US1840008490' => 'Girard',
		'US1840010289' => 'Cabery',
		'US1840012760' => 'Ste. Marie',
		'US1840008181' => 'Moline',
		'US1840011770' => 'Wataga',
		'US1840011154' => 'Hawthorn Woods',
		'US1840024793' => 'Olive Branch',
		'US1840011704' => 'Union Hill',
		'US1840011507' => 'Newark',
		'US1840004820' => 'Preston Heights',
		'US1840010142' => 'Brookfield',
		'US1840007602' => 'Anna',
		'US1840012549' => 'Palmer',
		'US1840010789' => 'Allendale',
		'US1840008643' => 'Mount Carmel',
		'US1840011302' => 'Norridge',
		'US1840011158' => 'Lake Bluff',
		'US1840011858' => 'Crescent City',
		'US1840011783' => 'Dwight',
		'US1840007255' => 'Clinton',
		'US1840008492' => 'Greenfield',
		'US1840011430' => 'Franklin Grove',
		'US1840007031' => 'Hometown',
		'US1840010352' => 'West Peoria',
		'US1840008641' => 'Fairfield',
		'US1840012878' => 'Smithton',
		'US1840012366' => 'Coatsburg',
		'US1840010864' => 'Vienna',
		'US1840011255' => 'La Grange',
		'US1840012869' => 'Fairmont City',
		'US1840012504' => 'Metcalf',
		'US1840011284' => 'River Forest',
		'US1840011263' => 'Hoffman Estates',
		'US1840012972' => 'Old Shawneetown',
		'US1840013019' => 'McClure',
		'US1840008331' => 'Lewistown',
		'US1840011576' => 'Mineral',
		'US1840025539' => 'Adair',
		'US1840012448' => 'Riverton',
		'US1840010586' => 'Brocton',
		'US1840025558' => 'LaPlace',
		'US1840007577' => 'Hurst',
		'US1840012546' => 'Morrisonville',
		'US1840011293' => 'Matteson',
		'US1840006972' => 'Venetian Village',
		'US1840010244' => 'Cleveland',
		'US1840011984' => 'Armington',
		'US1840010105' => 'Cedarville',
		'US1840012644' => 'Schram City',
		'US1840012547' => 'Mount Auburn',
		'US1840029736' => 'Garden Prairie',
		'US1840029898' => 'Lake of the Woods',
		'US1840010269' => 'Carbon Hill',
		'US1840011411' => 'Woodridge',
		'US1840011490' => 'Manhattan',
		'US1840011111' => 'Lena',
		'US1840008283' => 'Monmouth',
		'US1840012501' => 'Kansas',
		'US1840010113' => 'Waukegan',
		'US1840012224' => 'Fisher',
		'US1840012537' => 'New Salem',
		'US1840012210' => 'Manito',
		'US1840012741' => 'Shumway',
		'US1840012871' => 'Freeburg',
		'US1840011414' => 'Westmont',
		'US1840011346' => 'East Dundee',
		'US1840011329' => 'Summit',
		'US1840011426' => 'Ashton',
		'US1840012870' => 'Fayetteville',
		'US1840010484' => 'Cerro Gordo',
		'US1840010558' => 'Buffalo',
		'US1840012509' => 'Garrett',
		'US1840007490' => 'Albion',
		'US1840011437' => 'Hampton',
		'US1840008395' => 'Mount Sterling',
		'US1840073801' => 'Alvan',
		'US1840012529' => 'Baylis',
		'US1840008180' => 'East Moline',
		'US1840011148' => 'Bannockburn',
		'US1840008655' => 'Nason',
		'US1840073809' => 'De Pue',
		'US1840009602' => 'Staunton',
		'US1840029849' => 'University Park',
		'US1840009627' => 'Otterville',
		'US1840009604' => 'Roodhouse',
		'US1840011924' => 'Dunlap',
		'US1840012929' => 'Dahlgren',
		'US1840010386' => 'Bryant',
		'US1840012108' => 'Bardolph',
		'US1840008259' => 'Momence',
		'US1840012890' => 'West Salem',
		'US1840011682' => 'Sherrard',
		'US1840011399' => 'Bloomingdale',
		'US1840011116' => 'Rock City',
		'US1840012875' => 'Millstadt',
		'US1840007219' => 'Carthage',
		'US1840012639' => 'Farmersville',
		'US1840011138' => 'Richmond',
		'US1840012370' => 'Plainville',
		'US1840011322' => 'South Barrington',
		'US1840012868' => 'East Carondelet',
		'US1840011345' => 'Lily Lake',
		'US1840012371' => 'Ursa',
		'US1840011440' => 'Cordova',
		'US1840011428' => 'Lee',
		'US1840012362' => 'La Prairie',
		'US1840012797' => 'Pontoon Beach',
		'US1840010712' => 'Alhambra',
		'US1840013017' => 'Joppa',
		'US1840012735' => 'Ramsey',
		'US1840011575' => 'Manlius',
		'US1840012906' => 'Okawville',
		'US1840009601' => 'Litchfield',
		'US1840011310' => 'Orland Park',
		'US1840073806' => 'Jeffersonville',
		'US1840012415' => 'Ashland',
		'US1840012963' => 'De Soto',
		'US1840011182' => 'Volo',
		'US1840011617' => 'Mazon',
		'US1840012364' => 'Lima',
		'US1840011419' => 'Coleta',
		'US1840011974' => 'Hudson',
		'US1840010646' => 'Butler',
		'US1840011298' => 'Midlothian',
		'US1840012739' => 'Edgewood',
		'US1840012891' => 'Bellmont',
		'US1840012006' => 'Astoria',
		'US1840012106' => 'Pontoosuc',
		'US1840025536' => 'Oak Run',
		'US1840012780' => 'Pocahontas',
		'US1840012658' => 'Palmyra',
		'US1840011766' => 'Maquon',
		'US1840007033' => 'DeKalb',
		'US1840011443' => 'Reynolds',
		'US1840012757' => 'Stoy',
		'US1840011434' => 'Sublette',
		'US1840011251' => 'Hanover Park',
		'US1840007221' => 'Bushnell',
		'US1840011541' => 'Tonica',
		'US1840011343' => 'Hampshire',
		'US1840011236' => 'Forreston',
		'US1840011947' => 'Secor',
		'US1840010112' => 'Capron',
		'US1840008654' => 'Mount Vernon',
		'US1840011681' => 'Seaton',
		'US1840007236' => 'Hoopeston',
		'US1840011616' => 'Gardner',
		'US1840012457' => 'Spaulding',
		'US1840012782' => 'Old Ripley',
		'US1840011333' => 'Western Springs',
		'US1840010614' => 'Sigel',
		'US1840000495' => 'Campton Hills',
		'US1840012447' => 'Divernon',
		'US1840012737' => 'Beecher City',
		'US1840011861' => 'Martinton',
		'US1840011538' => 'Naplate',
		'US1840004638' => 'Gages Lake',
		'US1840011398' => 'Bensenville',
		'US1840011110' => 'Warren',
		'US1840008342' => 'La Harpe',
		'US1840011159' => 'Lake Villa',
		'US1840007027' => 'Berwyn',
		'US1840012515' => 'Woodson',
		'US1840011584' => 'Walnut',
		'US1840011166' => 'Deer Park',
		'US1840011435' => 'West Brooklyn',
		'US1840011328' => 'Streamwood',
		'US1840012968' => 'Junction',
		'US1840012872' => 'St. Libory',
		'US1840011690' => 'Aroma Park',
		'US1840008437' => 'Newman',
		'US1840007570' => 'Harrisburg',
		'US1840007222' => 'Colchester',
		'US1840012659' => 'Wilsonville',
		'US1840012561' => 'Dalton City',
		'US1840008243' => 'Morris',
		'US1840012307' => 'Latham',
		'US1840009410' => 'Bentley',
		'US1840013003' => 'Goreville',
		'US1840008326' => 'Lexington',
		'US1840009547' => 'Taylorville',
		'US1840009133' => 'Park City',
		'US1840010587' => 'Tuscola',
		'US1840011991' => 'Morton',
		'US1840008291' => 'Elmwood',
		'US1840011241' => 'Shannon',
		'US1840012915' => 'Waltonville',
		'US1840010168' => 'Burr Ridge',
		'US1840012181' => 'Potomac',
		'US1840011147' => 'Timberlane',
		'US1840011319' => 'Schaumburg',
		'US1840012755' => 'Oblong',
		'US1840011183' => 'Wadsworth',
		'US1840012015' => 'St. David',
		'US1840012974' => 'Galatia',
		'US1840010560' => 'Chatham',
		'US1840010693' => 'Vandalia',
		'US1840012941' => 'Tilden',
		'US1840012796' => 'Godfrey',
		'US1840011234' => 'Creston',
		'US1840012645' => 'Taylor Springs',
		'US1840007366' => 'Carlinville',
		'US1840012232' => 'Mahomet',
		'US1840011113' => 'Davis',
		'US1840011533' => 'Leonore',
		'US1840009130' => 'Loves Park',
		'US1840012306' => 'Hartsburg',
		'US1840011233' => 'Hillcrest',
		'US1840010437' => 'Catlin',
		'US1840029873' => 'Cave-In-Rock',
		'US1840013564' => 'South Elgin',
		'US1840012756' => 'Palestine',
		'US1840010338' => 'Cissna Park',
		'US1840012935' => 'Evansville',
		'US1840008356' => 'Georgetown',
		'US1840008144' => 'Oakbrook Terrace',
		'US1840025552' => 'Seymour',
		'US1840009373' => 'Peoria',
		'US1840012503' => 'Redmon',
		'US1840011344' => 'Kaneville',
		'US1840012590' => 'Oconee',
		'US1840007525' => 'Carmi',
		'US1840012852' => 'Bartelso',
		'US1840012753' => 'Hutsonville',
		'US1840011877' => 'Roberts',
		'US1840012813' => 'Xenia',
		'US1840012562' => 'Gays',
		'US1840012957' => 'Thompsonville',
		'US1840012903' => 'Richview',
		'US1840012009' => 'Ipava',
		'US1840010561' => 'Clear Lake',
		'US1840011321' => 'Skokie',
		'US1840011152' => 'Gurnee',
		'US1840012885' => 'Keenes',
		'US1840012834' => 'Parkersburg',
		'US1840011350' => 'Montgomery',
		'US1840013024' => 'Pulaski',
		'US1840007575' => 'Carterville',
		'US1840011150' => 'Grayslake',
		'US1840029710' => 'Allerton',
		'US1840011942' => 'Congerville',
		'US1840007424' => 'Alton',
		'US1840010755' => 'Claremont',
		'US1840012540' => 'Pleasant Hill',
		'US1840012857' => 'Germantown',
		'US1840009131' => 'South Beloit',
		'US1840012977' => 'Stonefort',
		'US1840012507' => 'Atwood',
		'US1840008491' => 'Mount Olive',
		'US1840011705' => 'Sun River Terrace',
		'US1840011170' => 'Round Lake',
		'US1840012858' => 'New Baden',
		'US1840010139' => 'Chadwick',
		'US1840011117' => 'Orangeville',
		'US1840012443' => 'Loami',
		'US1840011326' => 'Stickney',
		'US1840029896' => 'Crystal Lawns',
		'US1840012567' => 'Manchester',
		'US1840011400' => 'Itasca',
		'US1840011986' => 'Hopedale',
		'US1840011178' => 'Winthrop Harbor',
		'US1840008288' => 'Gilman',
		'US1840011943' => 'Germantown Hills',
		'US1840011120' => 'Durand',
		'US1840012184' => 'Rossville',
		'US1840007211' => 'Cuba',
		'US1840012692' => 'Toledo',
		'US1840011925' => 'Glasford',
		'US1840012319' => 'Littleton',
		'US1840012660' => 'Sawyerville',
		'US1840011577' => 'Neponset',
		'US1840011332' => 'Westchester',
		'US1840012892' => 'Keensburg',
		'US1840011780' => 'Long Point',
		'US1840012795' => 'Glen Carbon',
		'US1840007090' => 'Braidwood',
		'US1840009186' => 'Cicero',
		'US1840010213' => 'Wilmington',
		'US1840012421' => 'Ripley',
		'US1840011579' => 'Ohio',
		'US1840010149' => 'Carpentersville',
		'US1840004818' => 'Ingalls Park',
		'US1840009233' => 'Rock Island',
		'US1840011114' => 'German Valley',
		'US1840007543' => 'Benton',
		'US1840010246' => 'Andover',
		'US1840011155' => 'Island Lake',
		'US1840012450' => 'Mechanicsburg',
		'US1840012850' => 'Walnut Hill',
		'US1840011880' => 'Sibley',
		'US1840011486' => 'Frankfort',
		'US1840012586' => 'Herrick',
		'US1840011264' => 'Homewood',
		'US1840010754' => 'Calhoun',
		'US1840011313' => 'Park Forest',
		'US1840011677' => 'Joy',
		'US1840011125' => 'Pecatonica',
		'US1840010866' => 'Alto Pass',
		'US1840012007' => 'Avon',
		'US1840029897' => 'Frankfort Square',
		'US1840007032' => 'Des Plaines',
		'US1840012853' => 'Beckemeyer',
		'US1840008373' => 'Mount Pulaski',
		'US1840007425' => 'Highland',
		'US1840029891' => 'LaSalle',
		'US1840007035' => 'Batavia',
		'US1840011156' => 'Kildeer',
		'US1840012454' => 'Williamsville',
		'US1840008450' => 'Oakland',
		'US1840011979' => 'Ellsworth',
		'US1840073814' => 'Royal Lakes',
		'US1840012938' => 'Ruma',
		'US1840012976' => 'Muddy',
		'US1840012856' => 'Damiansville',
		'US1840009179' => 'Rochelle',
		'US1840008258' => 'Keithsburg',
		'US1840039281' => 'The Galena Territory',
		'US1840009232' => 'Silvis',
		'US1840009555' => 'Naples',
		'US1840012010' => 'Liverpool',
		'US1840011108' => 'Scales Mound',
		'US1840013004' => 'Cypress',
		'US1840011530' => 'Grand Ridge',
		'US1840011146' => 'Poplar Grove',
		'US1840008142' => 'Elmhurst',
		'US1840012683' => 'Hamburg',
		'US1840011252' => 'Harwood Heights',
		'US1840007252' => 'Atlanta',
		'US1840012223' => 'Homer',
		'US1840008357' => 'Mason City',
		'US1840073802' => 'Bay View Gardens',
		'US1840008083' => 'Freeport',
		'US1840012100' => 'Augusta',
		'US1840008669' => 'Grayville',
		'US1840011489' => 'Romeoville',
		'US1840008206' => 'Kewanee',
		'US1840008606' => 'Lawrenceville',
		'US1840006969' => 'Crystal Lake',
		'US1840009834' => 'Belle Prairie City',
		'US1840011317' => 'Winnetka',
		'US1840007561' => 'Ava',
		'US1840011535' => 'Ransom',
		'US1840011312' => 'Palos Park',
		'US1840010782' => 'Caseyville',
		'US1840011176' => 'North Barrington',
		'US1840012937' => 'Rockwood',
		'US1840011799' => 'Little York',
		'US1840010322' => 'Campus',
		'US1840012550' => 'Stonington',
		'US1840007502' => 'Columbia',
		'US1840012641' => 'Raymond',
		'US1840010613' => 'Windsor',
		'US1840010138' => 'Adeline',
		'US1840008529' => 'Grafton',
		'US1840011307' => 'Oak Park',
		'US1840007503' => 'Ashley',
		'US1840012235' => 'Philo',
		'US1840009351' => 'Oneida',
		'US1840012947' => 'Willisville',
		'US1840011355' => 'Sugar Grove',
		'US1840004637' => 'Fox Lake Hills',
		'US1840073817' => 'North City',
		'US1840073818' => 'North Utica',
		'US1840008205' => 'Geneseo',
		'US1840010191' => 'Carbon Cliff',
		'US1840012877' => 'Shiloh',
		'US1840012441' => 'Grandview',
		'US1840012230' => 'St. Joseph',
		'US1840007139' => 'Aledo',
		'US1840010604' => 'Winchester',
		'US1840008708' => 'Eldorado',
		'US1840011972' => 'Gridley',
		'US1840013027' => 'Ullin',
		'US1840012923' => 'Enfield',
		'US1840011287' => 'Riverside',
		'US1840009202' => 'Rock Falls',
		'US1840007485' => 'Centreville',
		'US1840012423' => 'Versailles',
		'US1840029900' => 'Lake Camelot',
		'US1840011694' => 'Grant Park',
		'US1840012175' => 'Belgium',
		'US1840008192' => 'Joliet',
		'US1840012691' => 'Jewett',
		'US1840009447' => 'Lincoln',
		'US1840006059' => 'Rosewood Heights',
		'US1840012945' => 'Cutler',
		'US1840011124' => 'New Milford',
		'US1840011509' => 'Plattville',
		'US1840012414' => 'Arenzville',
		'US1840011505' => 'Millbrook',
		'US1840010651' => 'White Hall',
		'US1840073816' => 'Mound Station',
		'US1840010165' => 'West Chicago',
		'US1840011990' => 'Minier',
		'US1840010339' => 'Clifton',
		'US1840011506' => 'Millington',
		'US1840012925' => 'Mill Shoals',
		'US1840010483' => 'Camden',
		'US1840011247' => 'Bedford Park',
		'US1840010242' => 'Atkinson',
		'US1840011311' => 'Palatine',
		'US1840011300' => 'Mount Prospect',
		'US1840012588' => 'Findlay',
		'US1840012803' => 'Williamson',
		'US1840012444' => 'Illiopolis',
		'US1840011273' => 'Evergreen Park',
		'US1840011265' => 'Indian Head Park',
		'US1840011949' => 'Washburn',
		'US1840011177' => 'Old Mill Creek',
		'US1840011586' => 'Hooppole',
		'US1840010171' => 'Addison',
		'US1840012936' => 'Prairie du Rocher',
		'US1840011335' => 'Kingston',
		'US1840009183' => 'Park Ridge',
		'US1840012446' => 'Dawson',
		'US1840011421' => 'Erie',
		'US1840012912' => 'Ina',
		'US1840007363' => 'Coffeen',
		'US1840007310' => 'Arcola',
		'US1840008432' => 'Leland Grove',
		'US1840009546' => 'New Canton',
		'US1840012866' => 'Lenzburg',
		'US1840011798' => 'Kirkwood',
		'US1840012673' => 'Westfield',
		'US1840012897' => 'Maeystown',
		'US1840012740' => 'Montrose',
		'US1840012962' => 'Gorham',
		'US1840008277' => 'Galesburg',
		'US1840012315' => 'De Witt',
		'US1840013006' => 'Simpson',
	],
	'GA' => [
		'US1840015529' => 'Trenton',
		'US1840013695' => 'Arnoldsville',
		'US1840014722' => 'Hoschton',
		'US1840015893' => 'Thomasville',
		'US1840043457' => 'McRae-Helena',
		'US1840014691' => 'Royston',
		'US1840014914' => 'Pooler',
		'US1840015742' => 'Waynesboro',
		'US1840013616' => 'Gillsville',
		'US1840017972' => 'Rest Haven',
		'US1840015623' => 'Winder',
		'US1840013554' => 'Fort Oglethorpe',
		'US1840015840' => 'Walthourville',
		'US1840025846' => 'Yonah',
		'US1840013780' => 'Avera',
		'US1840016758' => 'Maxeys',
		'US1840029456' => 'Irondale',
		'US1840014929' => 'Midway',
		'US1840013740' => 'Lithia Springs',
		'US1840014910' => 'Claxton',
		'US1840014775' => 'Chamblee',
		'US1840016861' => 'Turin',
		'US1840013858' => 'Broxton',
		'US1840013882' => 'Berlin',
		'US1840015527' => 'Tunnel Hill',
		'US1840014818' => 'Norwood',
		'US1840014992' => 'Climax',
		'US1840015643' => 'Lincolnton',
		'US1840016507' => 'Mountain City',
		'US1840015735' => 'Louisville',
		'US1840013792' => 'Gordon',
		'US1840013805' => 'Adrian',
		'US1840029447' => 'Peachtree Corners',
		'US1840014679' => 'Menlo',
		'US1840013749' => 'Harlem',
		'US1840015616' => 'Suwanee',
		'US1840014961' => 'Damascus',
		'US1840025953' => 'Rockingham',
		'US1840016771' => 'Tignall',
		'US1840015819' => 'Santa Claus',
		'US1840015875' => 'Willacoochee',
		'US1840015528' => 'Varnell',
		'US1840015736' => 'Bartow',
		'US1840014853' => 'Concord',
		'US1840014922' => 'Milan',
		'US1840014810' => 'Porterdale',
		'US1840018011' => 'Shady Dale',
		'US1840029263' => 'Gumbranch',
		'US1840015692' => 'Sharon',
		'US1840015738' => 'Wadley',
		'US1840035817' => 'Kings Bay Base',
		'US1840015679' => 'Villa Rica',
		'US1840014752' => 'Cedartown',
		'US1840013663' => 'Hapeville',
		'US1840025890' => 'Perkins',
		'US1840014804' => 'Douglasville',
		'US1840015892' => 'Meigs',
		'US1840016957' => 'Geneva',
		'US1840014666' => 'Helen',
		'US1840013829' => 'Eastman',
		'US1840013575' => 'Ellijay',
		'US1840015854' => 'Sycamore',
		'US1840014867' => 'Millen',
		'US1840013902' => 'Boston',
		'US1840015559' => 'Lula',
		'US1840014778' => 'Doraville',
		'US1840017993' => 'Rayle',
		'US1840015834' => 'Lumber City',
		'US1840013574' => 'East Ellijay',
		'US1840017041' => 'Pineview',
		'US1840013819' => 'Fort Valley',
		'US1840014913' => 'Richmond Hill',
		'US1840025895' => 'Norristown',
		'US1840014915' => 'Port Wentworth',
		'US1840014971' => 'Pearson',
		'US1840015746' => 'Sandersville',
		'US1840014898' => 'Montezuma',
		'US1840014764' => 'Lexington',
		'US1840016623' => 'Trion',
		'US1840013834' => 'Hagan',
		'US1840014662' => 'Demorest',
		'US1840014677' => 'Dawsonville',
		'US1840013831' => 'Ailey',
		'US1840014833' => 'Newnan',
		'US1840013678' => 'Buford',
		'US1840013097' => 'East Newnan',
		'US1840014729' => 'Ila',
		'US1840014958' => 'Offerman',
		'US1840013699' => 'Belvedere Park',
		'US1840013841' => 'Americus',
		'US1840014976' => 'Doerun',
		'US1840016956' => 'Junction City',
		'US1840014720' => 'Commerce',
		'US1840014899' => 'Oglethorpe',
		'US1840015747' => 'Tennille',
		'US1840029409' => 'Edge Hill',
		'US1840014975' => 'Cecil',
		'US1840013652' => 'Bowman',
		'US1840016978' => 'Portal',
		'US1840013901' => 'Barwick',
		'US1840014681' => 'Rome',
		'US1840014815' => 'Riverdale',
		'US1840014966' => 'Newton',
		'US1840029395' => 'Cusseta',
		'US1840015811' => 'Soperton',
		'US1840014909' => 'Pinehurst',
		'US1840014936' => 'Denton',
		'US1840015574' => 'Woodstock',
		'US1840014755' => 'Powder Springs',
		'US1840015824' => 'Alamo',
		'US1840013687' => 'Vinings',
		'US1840013611' => 'Flowery Branch',
		'US1840140880' => 'Sautee-Nacoochee',
		'US1840014950' => 'Ocilla',
		'US1840018116' => 'Rhine',
		'US1840014887' => 'Columbus',
		'US1840015662' => 'Tallapoosa',
		'US1840013846' => 'Allenhurst',
		'US1840015645' => 'Stone Mountain',
		'US1840013879' => 'Adel',
		'US1840015750' => 'Warm Springs',
		'US1840013870' => 'Blackshear',
		'US1840015709' => 'Camak',
		'US1840025839' => 'Tate City',
		'US1840014875' => 'Nunez',
		'US1840013767' => 'Flovilla',
		'US1840014740' => 'Palmetto',
		'US1840013875' => 'Brunswick',
		'US1840013620' => 'Adairsville',
		'US1840014727' => 'Danielsville',
		'US1840039168' => 'Talahi Island',
		'US1840014721' => 'Nicholson',
		'US1840015648' => 'Bogart',
		'US1840029459' => 'Sunnyside',
		'US1840013855' => 'Fitzgerald',
		'US1840014742' => 'Johns Creek',
		'US1840014957' => 'Omega',
		'US1840013623' => 'Ball Ground',
		'US1840139859' => 'Crooked Creek',
		'US1840013092' => 'Druid Hills',
		'US1840014651' => 'Dalton',
		'US1840137955' => 'Henderson',
		'US1840015832' => 'Lumpkin',
		'US1840015891' => 'Whigham',
		'US1840015749' => 'Manchester',
		'US1840016876' => 'Centralhatchee',
		'US1840014882' => 'Rentz',
		'US1840015659' => 'Walnut Grove',
		'US1840013837' => 'Isle of Hope',
		'US1840013677' => 'Berkeley Lake',
		'US1840015514' => 'Sky Valley',
		'US1840013795' => 'Hannahs Mill',
		'US1840014890' => 'Cochran',
		'US1840013813' => 'Dublin',
		'US1840017122' => 'Ellenton',
		'US1840015785' => 'Stillmore',
		'US1840013769' => 'Franklin',
		'US1840016628' => 'Talking Rock',
		'US1840014993' => 'Morven',
		'US1840025978' => 'Boykin',
		'US1840013595' => 'Fairmount',
		'US1840014725' => 'Colbert',
		'US1840014934' => 'Cordele',
		'US1840017112' => 'Lenox',
		'US1840014777' => 'Decatur',
		'US1840013835' => 'Bellville',
		'US1840014942' => 'Odum',
		'US1840015691' => 'Mansfield',
		'US1840013737' => 'Bostwick',
		'US1840013845' => 'Abbeville',
		'US1840014650' => 'Cohutta',
		'US1840013689' => 'Austell',
		'US1840013651' => 'Elberton',
		'US1840014916' => 'Richland',
		'US1840015831' => 'Tybee Island',
		'US1840014811' => 'Crawfordville',
		'US1840014649' => 'Morganton',
		'US1840015776' => 'Thomaston',
		'US1840027003' => 'Coleman',
		'US1840015803' => 'Springfield',
		'US1840014940' => 'Leesburg',
		'US1840029450' => 'Hilltop',
		'US1840017062' => 'Sumner',
		'US1840018001' => 'Roopville',
		'US1840015703' => 'Thomson',
		'US1840014906' => 'Cobbtown',
		'US1840029454' => 'Gresham Park',
		'US1840022892' => 'Chattahoochee Hills',
		'US1840013785' => 'Hardwick',
		'US1840013701' => 'Tucker',
		'US1840013803' => 'Hamilton',
		'US1840013747' => 'Martinez',
		'US1840013690' => 'Mableton',
		'US1840014931' => 'Hinesville',
		'US1840013823' => 'Guyton',
		'US1840013903' => 'Folkston',
		'US1840015686' => 'Union Point',
		'US1840015788' => 'Twin City',
		'US1840014836' => 'Jackson',
		'US1840013893' => 'Fargo',
		'US1840029466' => 'Stonecrest',
		'US1840017929' => 'Ranger',
		'US1840014728' => 'Hull',
		'US1840015714' => 'Brooks',
		'US1840015774' => 'Toomsboro',
		'US1840016898' => 'Lone Oak',
		'US1840043455' => 'Macon',
		'US1840015818' => 'Lyons',
		'US1840014741' => 'Roswell',
		'US1840014972' => 'Nahunta',
		'US1840013760' => 'Grantville',
		'US1840013847' => 'Flemington',
		'US1840014965' => 'Ray City',
		'US1840014918' => 'Plains',
		'US1840015572' => 'White',
		'US1840013874' => 'St. Simons',
		'US1840017103' => 'Enigma',
		'US1840013840' => 'Bloomingdale',
		'US1840015822' => 'Manassas',
		'US1840013684' => 'Aragon',
		'US1840015815' => 'Alston',
		'US1840014703' => 'Canton',
		'US1840014900' => 'Ideal',
		'US1840014723' => 'Jefferson',
		'US1840013904' => 'Hahira',
		'US1840014973' => 'Hoboken',
		'US1840018155' => 'Sasser',
		'US1840013876' => 'Baconton',
		'US1840014652' => 'Ringgold',
		'US1840015676' => 'Madison',
		'US1840029310' => 'Phillipsburg',
		'US1840015828' => 'Unadilla',
		'US1840014846' => 'Midville',
		'US1840013084' => 'Fairview',
		'US1840029452' => 'Country Club Estates',
		'US1840014852' => 'Hogansville',
		'US1840014672' => 'Dahlonega',
		'US1840017930' => 'Resaca',
		'US1840017021' => 'Dooling',
		'US1840016973' => 'Dexter',
		'US1840026999' => 'Knoxville',
		'US1840013705' => 'Panthersville',
		'US1840015657' => 'Between',
		'US1840013750' => 'Forest Park',
		'US1840014636' => 'Clayton',
		'US1840015633' => 'Marietta',
		'US1840014967' => 'Pelham',
		'US1840014726' => 'Comer',
		'US1840025854' => 'Eagle Grove',
		'US1840029147' => 'LaGrange',
		'US1840014863' => 'Oliver',
		'US1840025844' => 'Cherry Log',
		'US1840014806' => 'Conyers',
		'US1840013865' => 'Putney',
		'US1840013555' => 'Blairsville',
		'US1840016508' => 'Tiger',
		'US1840014866' => 'Ivey',
		'US1840015677' => 'Buckhead',
		'US1840014758' => 'Hiram',
		'US1840014689' => 'Canon',
		'US1840014884' => 'Centerville',
		'US1840014697' => 'Oakwood',
		'US1840015781' => 'Woodland',
		'US1840017030' => 'Thunderbolt',
		'US1840073846' => 'Candler-McAfee',
		'US1840013552' => 'Indian Springs',
		'US1840015889' => 'Woodbine',
		'US1840014645' => 'Hiawassee',
		'US1840013827' => 'Buena Vista',
		'US1840014809' => 'Oxford',
		'US1840016897' => 'Harrison',
		'US1840025841' => 'Mineral Bluff',
		'US1840014857' => 'Milledgeville',
		'US1840014802' => 'Mount Zion',
		'US1840014801' => 'Carrollton',
		'US1840029460' => 'Whitemarsh Island',
		'US1840018156' => 'Rebecca',
		'US1840013659' => 'Alpharetta',
		'US1840016872' => 'Jenkinsburg',
		'US1840016946' => 'Yatesville',
		'US1840015621' => 'Carl',
		'US1840029458' => 'Skidaway Island',
		'US1840013833' => 'Glenwood',
		'US1840016567' => 'Mount Airy',
		'US1840013702' => 'Avondale Estates',
		'US1840013842' => 'Andersonville',
		'US1840013814' => 'Dudley',
		'US1840029453' => 'Dock Junction',
		'US1840029373' => 'Chattanooga Valley',
		'US1840013850' => 'Baxley',
		'US1840025898' => 'Howard',
		'US1840013553' => 'Lakeview',
		'US1840014687' => 'Jasper',
		'US1840014999' => 'Remerton',
		'US1840015856' => 'Warwick',
		'US1840015614' => 'Snellville',
		'US1840014763' => 'Crawford',
		'US1840013622' => 'Euharlee',
		'US1840015847' => 'Arabi',
		'US1840029451' => 'Salem',
		'US1840015647' => 'Bishop',
		'US1840013715' => 'Bremen',
		'US1840036023' => 'Robins AFB',
		'US1840014937' => 'Hazlehurst',
		'US1840015564' => 'Bowersville',
		'US1840025935' => 'Satilla',
		'US1840014686' => 'Nelson',
		'US1840013776' => 'Griffin',
		'US1840014996' => 'Coolidge',
		'US1840029461' => 'Wilmington Island',
		'US1840015680' => 'Whitesburg',
		'US1840016859' => 'Moreland',
		'US1840015706' => 'McDonough',
		'US1840014850' => 'Davisboro',
		'US1840013863' => 'Alma',
		'US1840015863' => 'Tifton',
		'US1840014984' => 'Homerville',
		'US1840015710' => 'Warrenton',
		'US1840014661' => 'Cornelia',
		'US1840014997' => 'Donalsonville',
		'US1840013782' => 'Greenville',
		'US1840015751' => 'Woodbury',
		'US1840015554' => 'Summerville',
		'US1840016568' => 'Tallulah Falls',
		'US1840014776' => 'Clarkston',
		'US1840014854' => 'Molena',
		'US1840016783' => 'North High Shoals',
		'US1840013613' => 'Reed Creek',
		'US1840014737' => 'College Park',
		'US1840013713' => 'Good Hope',
		'US1840029455' => 'Gumlog',
		'US1840039167' => 'Heron Bay',
		'US1840014745' => 'Lawrenceville',
		'US1840015796' => 'Cadwell',
		'US1840014954' => 'Leary',
		'US1840014953' => 'Morgan',
		'US1840015855' => 'Sylvester',
		'US1840015852' => 'Smithville',
		'US1840013748' => 'Grovetown',
		'US1840015748' => 'Luthersville',
		'US1840013551' => 'Blue Ridge',
		'US1840025918' => 'Mendes',
		'US1840015894' => 'Valdosta',
		'US1840018089' => 'Register',
		'US1840015885' => 'Argyle',
		'US1840022929' => 'Dunwoody',
		'US1840013550' => 'Eton',
		'US1840013738' => 'Bowdon',
		'US1840013796' => 'Sunset Village',
		'US1840014779' => 'Pine Lake',
		'US1840014756' => 'Kennesaw',
		'US1840013797' => 'Lincoln Park',
		'US1840017143' => 'Iron City',
		'US1840014977' => 'Moultrie',
		'US1840013661' => 'East Point',
		'US1840015752' => 'West Point',
		'US1840014885' => 'Perry',
		'US1840016860' => 'Haralson',
		'US1840014946' => 'Douglas',
		'US1840013706' => 'Redan',
		'US1840014690' => 'Carnesville',
		'US1840013783' => 'Barnesville',
		'US1840014911' => 'Daisy',
		'US1840016922' => 'Newington',
		'US1840073868' => 'Moody AFB',
		'US1840013866' => 'Arlington',
		'US1840013704' => 'North Decatur',
		'US1840015820' => 'Vidalia',
		'US1840018051' => 'Rocky Ford',
		'US1840016955' => 'Danville',
		'US1840016846' => 'Woolsey',
		'US1840013680' => 'Auburn',
		'US1840014939' => 'Cuthbert',
		'US1840013662' => 'Fairburn',
		'US1840013804' => 'Garfield',
		'US1840015526' => 'McCaysville',
		'US1840015836' => 'Scotland',
		'US1840014753' => 'Rockmart',
		'US1840014959' => 'Patterson',
		'US1840014962' => 'Jakin',
		'US1840013608' => 'Franklin Springs',
		'US1840017004' => 'Chester',
		'US1840014978' => 'Norman Park',
		'US1840029224' => 'Brookhaven',
		'US1840016941' => 'McIntyre',
		'US1840013815' => 'East Dublin',
		'US1840015810' => 'Marshallville',
		'US1840015638' => 'Winterville',
		'US1840013099' => 'Experiment',
		'US1840015000' => 'Lake Park',
		'US1840015737' => 'Stapleton',
		'US1840017142' => 'Ochlocknee',
		'US1840013820' => 'Byron',
		'US1840017031' => 'Vernonburg',
		'US1840014919' => 'Leslie',
		'US1840015620' => 'Bethlehem',
		'US1840013576' => 'Baldwin',
		'US1840014952' => 'Darien',
		'US1840014743' => 'Dacula',
		'US1840015859' => 'Bluffton',
		'US1840014964' => 'Nashville',
		'US1840013768' => 'Ephesus',
		'US1840014648' => 'Chatsworth',
		'US1840015754' => 'Zebulon',
		'US1840025894' => 'Canoochee',
		'US1840015740' => 'Sardis',
		'US1840013784' => 'Forsyth',
		'US1840015801' => 'Statesboro',
		'US1840016816' => 'Newborn',
		'US1840014738' => 'Milton',
		'US1840016890' => 'Girard',
		'US1840029280' => 'Lakeview Estates',
		'US1840015817' => 'Higgston',
		'US1840025092' => 'The Rock',
		'US1840015543' => 'Alto',
		'US1840016899' => 'Gay',
		'US1840025840' => 'Epworth',
		'US1840013577' => 'Raoul',
		'US1840013604' => 'Lindale',
		'US1840029449' => 'North Druid Hills',
		'US1840016889' => 'Mitchell',
		'US1840016896' => 'Deepstep',
		'US1840014847' => 'Keysville',
		'US1840014786' => 'Monroe',
		'US1840013864' => 'Albany',
		'US1840016921' => 'Hiltonia',
		'US1840014712' => 'Cumming',
		'US1840014832' => 'Monticello',
		'US1840014654' => 'Chickamauga',
		'US1840014995' => 'Quitman',
		'US1840016648' => 'Clermont',
		'US1840014855' => 'Milner',
		'US1840014814' => 'Morrow',
		'US1840013716' => 'Buchanan',
		'US1840015725' => 'Sparta',
		'US1840014998' => 'Homeland',
		'US1840015787' => 'Swainsboro',
		'US1840014816' => 'Jonesboro',
		'US1840015870' => 'Alapaha',
		'US1840014947' => 'Nicholls',
		'US1840014924' => 'Jacksonville',
		'US1840013857' => 'Ambrose',
		'US1840025863' => 'Dewy Rose',
		'US1840013675' => 'Duluth',
		'US1840014692' => 'Lavonia',
		'US1840013859' => 'Fort Gaines',
		'US1840025882' => 'Matthews',
		'US1840015678' => 'Temple',
		'US1840013877' => 'Camilla',
		'US1840029463' => 'Athens',
		'US1840015763' => 'Sylvania',
		'US1840014724' => 'Carlton',
		'US1840073839' => 'Fort Stewart',
		'US1840029444' => 'Deenwood',
		'US1840013650' => 'Arcade',
		'US1840014808' => 'Covington',
		'US1840014903' => 'Chauncey',
		'US1840016671' => 'Taylorsville',
		'US1840013096' => 'Conley',
		'US1840017139' => 'Du Pont',
		'US1840013098' => 'East Griffin',
		'US1840013849' => 'Graham',
		'US1840025914' => 'Empire',
		'US1840013091' => 'Fair Oaks',
		'US1840014829' => 'Hephzibah',
		'US1840013612' => 'Gainesville',
		'US1840017144' => 'Dasher',
		'US1840015848' => 'Ludowici',
		'US1840014656' => 'LaFayette',
		'US1840013755' => 'Fayetteville',
		'US1840013751' => 'Hampton',
		'US1840015705' => 'Locust Grove',
		'US1840015871' => 'Waycross',
		'US1840018046' => 'Riddleville',
		'US1840016715' => 'Pendergrass',
		'US1840012722' => 'Watkinsville',
		'US1840015826' => 'Lilly',
		'US1840013898' => 'Attapulgus',
		'US1840015550' => 'Avalon',
		'US1840014908' => 'Reidsville',
		'US1840013867' => 'Edison',
		'US1840013821' => 'Brooklet',
		'US1840014675' => 'Plainville',
		'US1840015707' => 'Stockbridge',
		'US1840014907' => 'Collins',
		'US1840015551' => 'Toccoa',
		'US1840013881' => 'Funston',
		'US1840015890' => 'Brinson',
		'US1840015704' => 'Lovejoy',
		'US1840018004' => 'Siloam',
		'US1840015656' => 'Loganville',
		'US1840015596' => 'Braselton',
		'US1840015687' => 'White Plains',
		'US1840029398' => 'De Soto',
		'US1840016660' => 'Maysville',
		'US1840014817' => 'Lake City',
		'US1840015857' => 'Screven',
		'US1840013809' => 'Butler',
		'US1840029376' => 'Appling',
		'US1840014930' => 'Riceboro',
		'US1840015634' => 'Smyrna',
		'US1840015715' => 'Blythe',
		'US1840017053' => 'Parrott',
		'US1840015829' => 'Vienna',
		'US1840013621' => 'Emerson',
		'US1840015789' => 'Wrightsville',
		'US1840015615' => 'Sugar Hill',
		'US1840014879' => 'Reynolds',
		'US1840014701' => 'Cartersville',
		'US1840015632' => 'Braswell',
		'US1840014905' => 'Mount Vernon',
		'US1840015739' => 'Wrens',
		'US1840014800' => 'Rutledge',
		'US1840013614' => 'Hartwell',
		'US1840013676' => 'Grayson',
		'US1840015613' => 'Lilburn',
		'US1840015610' => 'Union City',
		'US1840016845' => 'Tyrone',
		'US1840016884' => 'Orchard Hill',
		'US1840015523' => 'Young Harris',
		'US1840014871' => 'Jeffersonville',
		'US1840015888' => 'St. Marys',
		'US1840016961' => 'Pine Mountain',
		'US1840025988' => 'Calvary',
		'US1840013095' => 'Evans',
		'US1840014943' => 'Jesup',
		'US1840013872' => 'Blakely',
		'US1840014904' => 'Hawkinsville',
		'US1840134450' => 'Georgetown',
		'US1840014637' => 'Dillard',
		'US1840015753' => 'Meansville',
		'US1840014822' => 'Peachtree City',
		'US1840013854' => 'Ashburn',
		'US1840014851' => 'Oconee',
		'US1840014874' => 'Roberta',
		'US1840015573' => 'Waleska',
		'US1840016960' => 'Waverly Hall',
		'US1840025929' => 'Seville',
		'US1840015644' => 'Lithonia',
		'US1840014896' => 'Metter',
		'US1840016622' => 'Lyerly',
		'US1840015800' => 'Warner Robins',
		'US1840014757' => 'Dallas',
		'US1840014665' => 'Cleveland',
		'US1840013838' => 'Montgomery',
		'US1840018104' => 'Pulaski',
		'US1840029445' => 'Bonanza',
		'US1840016714' => 'Talmo',
		'US1840014912' => 'Pembroke',
		'US1840015658' => 'Social Circle',
		'US1840016837' => 'Dearing',
		'US1840014744' => 'Norcross',
		'US1840013832' => 'Glennville',
		'US1840014876' => 'Kite',
		'US1840014680' => 'Cave Spring',
		'US1840015786' => 'Summertown',
		'US1840018187' => 'Sparks',
		'US1840015850' => 'Bronwood',
		'US1840013688' => 'Acworth',
		'US1840014655' => 'Rossville',
		'US1840014994' => 'Pavo',
		'US1840015622' => 'Statham',
		'US1840013786' => 'Gray',
		'US1840014991' => 'Kingsland',
		'US1840013779' => 'Gibson',
		'US1840015872' => 'Sale City',
		'US1840013899' => 'Bainbridge',
		'US1840029357' => 'Unionville',
		'US1840014941' => 'Poulan',
		'US1840013596' => 'Calhoun',
		'US1840014739' => 'Mountain Park',
		'US1840015827' => 'Byromville',
		'US1840025967' => 'Cedar Springs',
		'US1840015864' => 'Ty Ty',
		'US1840014787' => 'Jersey',
		'US1840013830' => 'Ellaville',
		'US1840015756' => 'Aldora',
		'US1840014928' => 'Rochelle',
		'US1840018091' => 'Rincon',
		'US1840013660' => 'Atlanta',
		'US1840016659' => 'Homer',
		'US1840015851' => 'Shellman',
		'US1840029462' => 'Augusta',
		'US1840013839' => 'Garden City',
		'US1840017054' => 'Surrency',
		'US1840013681' => 'Russell',
		'US1840015780' => 'Talbotton',
		'US1840016962' => 'Oak Park',
		'US1840013791' => 'Allentown',
		'US1840039166' => 'Dutch Island',
		'US1840015830' => 'Savannah',
		'US1840015609' => 'Sandy Springs',
		'US1840015784' => 'Shiloh',
		'US1840015530' => 'Lookout Mountain',
		'US1840014983' => 'Colquitt',
		'US1840016613' => 'Martin',
		'US1840015688' => 'Woodville',
		'US1840014660' => 'Clarkesville',
		'US1840015734' => 'Sunny Side',
		'US1840013764' => 'Eatonton',
		'US1840013700' => 'Scottdale',
		'US1840015719' => 'Senoia',
		'US1840014865' => 'Irwinton',
		'US1840015816' => 'Uvalda',
		'US1840013744' => 'Greensboro',
		'US1840015641' => 'Washington',
		'US1840014856' => 'Culloden',
		'US1840015663' => 'Waco',
		'US1840015741' => 'Vidette',
		'US1840013900' => 'Cairo',
		'US1840015755' => 'Williamson',
		'US1840014704' => 'Holly Springs',
		'US1840018012' => 'Sharpsburg',
		'US1840014927' => 'Pitts',
		'US1840014702' => 'Kingston',
		'US1840014938' => 'Dawson',
		'US1840013603' => 'Shannon',
		'US1840017011' => 'Tarrytown',
		'US1840016972' => 'Montrose',
		'US1840012921' => 'Lakeland',
	],
	'IN' => [
		'US1840007261' => 'Crawfordsville',
		'US1840025649' => 'Kent',
		'US1840013709' => 'Aurora',
		'US1840005148' => 'Collegeville',
		'US1840010247' => 'St. Joe',
		'US1840010621' => 'Seelyville',
		'US1840005743' => 'North Terre Haute',
		'US1840010577' => 'Wynnedale',
		'US1840013860' => 'Liberty',
		'US1840010823' => 'Griffin',
		'US1840010194' => 'Wakarusa',
		'US1840010548' => 'Whitewater',
		'US1840004815' => 'New Paris',
		'US1840026384' => 'Laketon',
		'US1840009736' => 'Cannelburg',
		'US1840026783' => 'St. Meinrad',
		'US1840009248' => 'Michiana Shores',
		'US1840009301' => 'Culver',
		'US1840010575' => 'Warren Park',
		'US1840010254' => 'Wolcottville',
		'US1840010250' => 'Waterloo',
		'US1840010381' => 'Flora',
		'US1840009483' => 'Mooreland',
		'US1840010657' => 'St. Paul',
		'US1840007260' => 'Carmel',
		'US1840010200' => 'Kingsbury',
		'US1840009793' => 'Livonia',
		'US1840009594' => 'Brookville',
		'US1840042714' => 'Lake Santee',
		'US1840010343' => 'Amboy',
		'US1840010221' => 'St. John',
		'US1840009536' => 'Brownsburg',
		'US1840026346' => 'Harlan',
		'US1840010793' => 'Winslow',
		'US1840010464' => 'Hillsboro',
		'US1840010675' => 'Sunman',
		'US1840010812' => 'Elizabeth',
		'US1840009788' => 'Scottsburg',
		'US1840007307' => 'Beech Grove',
		'US1840010223' => 'Schneider',
		'US1840024292' => 'Landess',
		'US1840009848' => 'Rockport',
		'US1840009366' => 'Denver',
		'US1840009622' => 'Osgood',
		'US1840009318' => 'Churubusco',
		'US1840009820' => 'Corydon',
		'US1840010826' => 'Santa Claus',
		'US1840014205' => 'Rockville',
		'US1840009825' => 'New Amsterdam',
		'US1840005882' => 'Bright',
		'US1840007084' => 'Angola',
		'US1840024609' => 'Dover Hill',
		'US1840010356' => 'Poneto',
		'US1840008364' => 'Elwood',
		'US1840006265' => 'Galena',
		'US1840010827' => 'Gentryville',
		'US1840010296' => 'Grabill',
		'US1840014664' => 'Rising Sun',
		'US1840014463' => 'Winamac',
		'US1840009440' => 'Markleville',
		'US1840009539' => 'Danville',
		'US1840009544' => 'Cloverdale',
		'US1840010354' => 'Geneva',
		'US1840010569' => 'Wilkinson',
		'US1840009571' => 'Bethany',
		'US1840026614' => 'Milroy',
		'US1840009492' => 'Boston',
		'US1840010732' => 'Shoals',
		'US1840009484' => 'Mount Summit',
		'US1840024604' => 'Emison',
		'US1840009326' => 'Mount Ayr',
		'US1840004816' => 'Simonton Lake',
		'US1840009451' => 'Parker City',
		'US1840009562' => 'Morristown',
		'US1840008187' => 'Elkhart',
		'US1840007092' => 'Hammond',
		'US1840030008' => 'River Forest',
		'US1840026260' => 'Hanna',
		'US1840024294' => 'Point Isabel',
		'US1840007528' => 'Boonville',
		'US1840009733' => 'Oaktown',
		'US1840008439' => 'Greencastle',
		'US1840009532' => 'Cumberland',
		'US1840006207' => 'Henryville',
		'US1840009521' => 'Bloomingdale',
		'US1840010544' => 'Fountain City',
		'US1840010279' => 'Silver Lake',
		'US1840009450' => 'Modoc',
		'US1840010308' => 'Kewanna',
		'US1840009524' => 'Montezuma',
		'US1840010725' => 'Dupont',
		'US1840009674' => 'Clay City',
		'US1840026630' => 'Waldron',
		'US1840010800' => 'Somerville',
		'US1840013728' => 'Delphi',
		'US1840010532' => 'Kennard',
		'US1840009424' => 'Battle Ground',
		'US1840010622' => 'West Terre Haute',
		'US1840009734' => 'Loogootee',
		'US1840010431' => 'Shadeland',
		'US1840010695' => 'Vernon',
		'US1840009364' => 'Bunker Hill',
		'US1840009672' => 'Carbon',
		'US1840010358' => 'Vera Cruz',
		'US1840009538' => 'Coatesville',
		'US1840010596' => 'Fillmore',
		'US1840009628' => 'Sullivan',
		'US1840030014' => 'St. Mary of the Woods',
		'US1840010731' => 'Wheatland',
		'US1840009302' => 'La Paz',
		'US1840024297' => 'Americus',
		'US1840010579' => 'Plainfield',
		'US1840010291' => 'South Whitley',
		'US1840009265' => 'Beverly Shores',
		'US1840010421' => 'Pennville',
		'US1840009465' => 'New Ross',
		'US1840009711' => 'Medora',
		'US1840073799' => 'State Line City',
		'US1840005199' => 'Mexico',
		'US1840009824' => 'Mauckport',
		'US1840026642' => 'Tecumseh',
		'US1840010515' => 'Zionsville',
		'US1840008351' => 'Dunkirk',
		'US1840010299' => 'Zanesville',
		'US1840009757' => 'Chrisney',
		'US1840010251' => 'Rome City',
		'US1840010655' => 'Spencer',
		'US1840009482' => 'Middletown',
		'US1840009448' => 'Losantville',
		'US1840009665' => 'Clarksville',
		'US1840009358' => 'La Fontaine',
		'US1840010763' => 'Hardinsburg',
		'US1840010501' => 'Alamo',
		'US1840007332' => 'Greenwood',
		'US1840010275' => 'Pierceton',
		'US1840010615' => 'Princes Lakes',
		'US1840008262' => 'New Haven',
		'US1840009277' => 'Corunna',
		'US1840026784' => 'Hatfield',
		'US1840013714' => 'Columbus',
		'US1840010443' => 'West Lebanon',
		'US1840010564' => 'Rosedale',
		'US1840010277' => 'Warsaw',
		'US1840009522' => 'Marshall',
		'US1840010398' => 'Upland',
		'US1840009608' => 'New Point',
		'US1840007242' => 'Anderson',
		'US1840007376' => 'Bloomington',
		'US1840009365' => 'Converse',
		'US1840009438' => 'Country Club Heights',
		'US1840010618' => 'Whiteland',
		'US1840004834' => 'South Haven',
		'US1840010623' => 'Harmony',
		'US1840007231' => 'Hartford City',
		'US1840009631' => 'Merom',
		'US1840010248' => 'Altona',
		'US1840010499' => 'Sheridan',
		'US1840010820' => 'Elberfeld',
		'US1840009425' => 'Clarks Hill',
		'US1840026261' => 'Fish Lake',
		'US1840008208' => 'Kendallville',
		'US1840009362' => 'Mount Etna',
		'US1840010670' => 'Jonesville',
		'US1840010396' => 'Swayzee',
		'US1840010340' => 'Roanoke',
		'US1840026705' => 'Avoca',
		'US1840009406' => 'Burlington',
		'US1840022449' => 'Fairland',
		'US1840009404' => 'Otterbein',
		'US1840030063' => 'La Porte',
		'US1840008549' => 'North Vernon',
		'US1840009463' => 'New Market',
		'US1840026258' => 'Rolling Prairie',
		'US1840010429' => 'Greentown',
		'US1840010573' => 'Rocky Ripple',
		'US1840030032' => 'Town of Pines',
		'US1840026347' => 'Hoagland',
		'US1840014695' => 'Mishawaka',
		'US1840010828' => 'Grandview',
		'US1840010202' => 'Wanatah',
		'US1840009729' => 'Brooksburg',
		'US1840009669' => 'Morgantown',
		'US1840010497' => 'Arcadia',
		'US1840009379' => 'Chalmers',
		'US1840009495' => 'Dublin',
		'US1840009437' => 'Chesterfield',
		'US1840010394' => 'Fairmount',
		'US1840025625' => 'Butlerville',
		'US1840009670' => 'Paragon',
		'US1840010198' => 'Pottawattamie Park',
		'US1840008662' => 'New Albany',
		'US1840009269' => 'Kouts',
		'US1840007177' => 'Decatur',
		'US1840009464' => 'New Richmond',
		'US1840009363' => 'Peru',
		'US1840010503' => 'Waynetown',
		'US1840007521' => 'Cannelton',
		'US1840009307' => 'Milford',
		'US1840010778' => 'French Lick',
		'US1840026259' => 'Hudson Lake',
		'US1840009731' => 'Decker',
		'US1840010307' => 'Fulton',
		'US1840010460' => 'Gaston',
		'US1840009360' => 'North Manchester',
		'US1840030085' => 'Painted Hills',
		'US1840075131' => 'Richland',
		'US1840010278' => 'Sidney',
		'US1840009443' => 'Mellott',
		'US1840010543' => 'Economy',
		'US1840013729' => 'Edinburgh',
		'US1840009818' => 'Marengo',
		'US1840009305' => 'Leesburg',
		'US1840005007' => 'Tri-Lakes',
		'US1840030026' => 'Spring Hill',
		'US1840008195' => 'Lake Station',
		'US1840010467' => 'Wallace',
		'US1840005345' => 'Norway',
		'US1840010547' => 'Spring Grove',
		'US1840010309' => 'Akron',
		'US1840009709' => 'Brownstown',
		'US1840010779' => 'West Baden Springs',
		'US1840013891' => 'Noblesville',
		'US1840009561' => 'Shelbyville',
		'US1840009629' => 'Carlisle',
		'US1840010458' => 'Summitville',
		'US1840039286' => 'Notre Dame',
		'US1840010511' => 'Advance',
		'US1840010449' => 'Sharpsville',
		'US1840009442' => 'Daleville',
		'US1840009461' => 'Ladoga',
		'US1840009694' => 'Lyons',
		'US1840009804' => 'Patoka',
		'US1840025606' => 'Metamora',
		'US1840008365' => 'Muncie',
		'US1840009261' => 'Merrillville',
		'US1840024596' => 'Williams',
		'US1840009695' => 'Newberry',
		'US1840010567' => 'Shirley',
		'US1840009496' => 'Milton',
		'US1840009250' => 'Orland',
		'US1840010361' => 'Royal Center',
		'US1840007176' => 'Berne',
		'US1840010363' => 'Walton',
		'US1840010196' => 'Indian Village',
		'US1840009728' => 'Madison',
		'US1840009657' => 'Orleans',
		'US1840030079' => 'Granger',
		'US1840024290' => 'Herbst',
		'US1840010817' => 'Troy',
		'US1840007318' => 'Connersville',
		'US1840010201' => 'Trail Creek',
		'US1840010578' => 'Pittsboro',
		'US1840009376' => 'Ossian',
		'US1840010298' => 'Woodburn',
		'US1840009245' => 'Osceola',
		'US1840005179' => 'Star City',
		'US1840008551' => 'Jasonville',
		'US1840006310' => 'Melody Hill',
		'US1840026558' => 'Blanford',
		'US1840024532' => 'Owensburg',
		'US1840010463' => 'Yorktown',
		'US1840009523' => 'Mecca',
		'US1840010422' => 'Redkey',
		'US1840014170' => 'Plymouth',
		'US1840010796' => 'Fort Branch',
		'US1840010799' => 'Hazleton',
		'US1840004832' => 'Lake Dalecarlia',
		'US1840009537' => 'Clayton',
		'US1840009791' => 'Campbellsburg',
		'US1840009732' => 'Monroe City',
		'US1840010478' => 'Saratoga',
		'US1840009595' => 'Cedar Grove',
		'US1840009755' => 'Tell City',
		'US1840009533' => 'Meridian Hills',
		'US1840009540' => 'Lizton',
		'US1840006209' => 'New Washington',
		'US1840010574' => 'Speedway',
		'US1840013861' => 'Logansport',
		'US1840009242' => 'Lakeville',
		'US1840013869' => 'Michigan City',
		'US1840010595' => 'Russellville',
		'US1840009526' => 'McCordsville',
		'US1840009240' => 'Millersburg',
		'US1840009481' => 'Lewisville',
		'US1840009241' => 'South Bend',
		'US1840010357' => 'Uniondale',
		'US1840073761' => 'Grissom AFB',
		'US1840008460' => 'Franklin',
		'US1840024298' => 'Buck Creek',
		'US1840030028' => 'Stockwell',
		'US1840008523' => 'Lawrenceburg',
		'US1840004909' => 'San Pierre',
		'US1840010536' => 'Sulphur Springs',
		'US1840010580' => 'Amo',
		'US1840010462' => 'Selma',
		'US1840026314' => 'Kimmell',
		'US1840013851' => 'Lagrange',
		'US1840008387' => 'Lebanon',
		'US1840010427' => 'Shamrock Lakes',
		'US1840010603' => 'Glenwood',
		'US1840009431' => 'Colfax',
		'US1840008261' => 'Fort Wayne',
		'US1840009472' => 'Newport',
		'US1840010229' => 'Porter',
		'US1840004910' => 'Bass Lake',
		'US1840010514' => 'Whitestown',
		'US1840009308' => 'North Webster',
		'US1840009377' => 'Brookston',
		'US1840010677' => 'St. Leon',
		'US1840010208' => 'Topeka',
		'US1840008646' => 'Jasper',
		'US1840008194' => 'Gary',
		'US1840010696' => 'Switz City',
		'US1840024607' => 'Westphalia',
		'US1840005174' => 'Lake Village',
		'US1840010594' => 'Roachdale',
		'US1840007489' => 'Charlestown',
		'US1840010448' => 'Tipton',
		'US1840009620' => 'Milan',
		'US1840009826' => 'New Middletown',
		'US1840010512' => 'Thorntown',
		'US1840026545' => 'Lake Holiday',
		'US1840009239' => 'Middlebury',
		'US1840009300' => 'Bremen',
		'US1840026610' => 'Heritage Lake',
		'US1840009439' => 'Lapel',
		'US1840030042' => 'West Point',
		'US1840043144' => 'Salt Creek Commons',
		'US1840010654' => 'Gosport',
		'US1840004814' => 'Dunlap',
		'US1840010224' => 'Dyer',
		'US1840010722' => 'Vevay',
		'US1840030082' => 'Country Squire Lakes',
		'US1840009331' => 'Monterey',
		'US1840014684' => 'Newburgh',
		'US1840030064' => 'De Motte',
		'US1840025626' => 'Hayden',
		'US1840013885' => 'Napoleon',
		'US1840009838' => 'Cynthiana',
		'US1840009263' => 'New Chicago',
		'US1840009630' => 'Dugger',
		'US1840024291' => 'Jalapa',
		'US1840030041' => 'West Harrison',
		'US1840010280' => 'Syracuse',
		'US1840010608' => 'West College Corner',
		'US1840013868' => 'Marion',
		'US1840009673' => 'Center Point',
		'US1840005881' => 'Hidden Valley',
		'US1840009667' => 'Monrovia',
		'US1840010814' => 'Greenville',
		'US1840009819' => 'Milltown',
		'US1840009278' => 'Ligonier',
		'US1840010341' => 'Andrews',
		'US1840009805' => 'Birdseye',
		'US1840010666' => 'Stinesville',
		'US1840009433' => 'Michigantown',
		'US1840010798' => 'Haubstadt',
		'US1840007241' => 'Alexandria',
		'US1840025646' => 'Florence',
		'US1840009617' => 'Clifford',
		'US1840039288' => 'Smithville-Sanders',
		'US1840009799' => 'Petersburg',
		'US1840009462' => 'Linden',
		'US1840010399' => 'Van Buren',
		'US1840029976' => 'Long Beach',
		'US1840014674' => 'Valparaiso',
		'US1840009494' => 'Centerville',
		'US1840008396' => 'New Castle',
		'US1840010792' => 'Spurgeon',
		'US1840010730' => 'Vincennes',
		'US1840009304' => 'Claypool',
		'US1840025645' => 'East Enterprise',
		'US1840007100' => 'Auburn',
		'US1840026615' => 'Manilla',
		'US1840009460' => 'Darlington',
		'US1840026692' => 'Vallonia',
		'US1840009260' => 'Lowell',
		'US1840014073' => 'Oxford',
		'US1840024253' => 'Idaville',
		'US1840009767' => 'Darmstadt',
		'US1840014175' => 'Portland',
		'US1840026274' => 'Shorewood Forest',
		'US1840030086' => 'Cordry Sweetwater Lakes',
		'US1840030044' => 'Woodlawn Heights',
		'US1840008434' => 'Lawrence',
		'US1840009409' => 'Matthews',
		'US1840008338' => 'Gas City',
		'US1840009480' => 'Knightstown',
		'US1840010230' => 'Hebron',
		'US1840010513' => 'Ulen',
		'US1840026613' => 'Arlington',
		'US1840009322' => 'Leo-Cedarville',
		'US1840010761' => 'Saltillo',
		'US1840010682' => 'Farmersburg',
		'US1840009320' => 'Rensselaer',
		'US1840009471' => 'Dana',
		'US1840014647' => 'Lagro',
		'US1840009329' => 'Rochester',
		'US1840010195' => 'Roseland',
		'US1840024533' => 'Scotland',
		'US1840025607' => 'New Trenton',
		'US1840009426' => 'Dayton',
		'US1840009794' => 'New Pekin',
		'US1840009367' => 'Macy',
		'US1840009666' => 'Brooklyn',
		'US1840009529' => 'Southport',
		'US1840013890' => 'New Harmony',
		'US1840008642' => 'Jeffersonville',
		'US1840010380' => 'Ambia',
		'US1840139852' => 'Scipio',
		'US1840010457' => 'Ingalls',
		'US1840010617' => 'Trafalgar',
		'US1840010334' => 'Roann',
		'US1840024300' => 'Montmorenci',
		'US1840009303' => 'Burket',
		'US1840010734' => 'Elnora',
		'US1840030083' => 'Aberdeen',
		'US1840009730' => 'Bruceville',
		'US1840026557' => 'St. Bernice',
		'US1840007178' => 'Bluffton',
		'US1840013887' => 'Nashville',
		'US1840014567' => 'Greensburg',
		'US1840010477' => 'Ridgeville',
		'US1840014100' => 'Pendleton',
		'US1840030030' => 'Toad Hop',
		'US1840009246' => 'Kingsford Heights',
		'US1840009835' => 'Chandler',
		'US1840026273' => 'Wheeler',
		'US1840014427' => 'Williamsport',
		'US1840026691' => 'Freetown',
		'US1840008461' => 'Martinsville',
		'US1840014406' => 'Versailles',
		'US1840008567' => 'Mitchell',
		'US1840009375' => 'Monroe',
		'US1840010461' => 'Albany',
		'US1840010674' => 'Holton',
		'US1840009470' => 'Cayuga',
		'US1840010456' => 'Frankton',
		'US1840009267' => 'Chesterton',
		'US1840004833' => 'Lakes of the Four Seasons',
		'US1840030084' => 'Indianapolis',
		'US1840008296' => 'Monticello',
		'US1840009310' => 'North Judson',
		'US1840009323' => 'Monroeville',
		'US1840010197' => 'Walkerton',
		'US1840009530' => 'Clermont',
		'US1840008193' => 'East Chicago',
		'US1840007426' => 'Bedford',
		'US1840013798' => 'Howe',
		'US1840007437' => 'Bicknell',
		'US1840024295' => 'Sims',
		'US1840014235' => 'Rushville',
		'US1840010667' => 'Elizabethtown',
		'US1840010395' => 'Fowlerton',
		'US1840025648' => 'Deputy',
		'US1840025617' => 'Clarksburg',
		'US1840013844' => 'Kokomo',
		'US1840010786' => 'Sellersburg',
		'US1840026643' => 'Coalmont',
		'US1840010204' => 'Fremont',
		'US1840010378' => 'Earl Park',
		'US1840010665' => 'Ellettsville',
		'US1840008340' => 'Jonesboro',
		'US1840009836' => 'Lynnville',
		'US1840007244' => 'Attica',
		'US1840010535' => 'Straughn',
		'US1840009247' => 'La Crosse',
		'US1840010276' => 'Etna Green',
		'US1840007091' => 'Crown Point',
		'US1840009738' => 'Odon',
		'US1840009597' => 'Mount Carmel',
		'US1840010533' => 'Spiceland',
		'US1840009623' => 'Dillsboro',
		'US1840007263' => 'Clinton',
		'US1840014673' => 'Greenfield',
		'US1840010207' => 'Shipshewana',
		'US1840010762' => 'Fredericksburg',
		'US1840008352' => 'Montpelier',
		'US1840008522' => 'Greendale',
		'US1840029952' => 'Homecroft',
		'US1840010568' => 'Spring Lake',
		'US1840009607' => 'Millhousen',
		'US1840005823' => 'Taylorsville',
		'US1840009434' => 'Mulberry',
		'US1840009735' => 'Crane',
		'US1840073800' => 'Windfall City',
		'US1840009726' => 'Patriot',
		'US1840014683' => 'Paoli',
		'US1840009803' => 'Owensville',
		'US1840009325' => 'Morocco',
		'US1840009541' => 'North Salem',
		'US1840010228' => 'Winfield',
		'US1840009497' => 'Mount Auburn',
		'US1840010684' => 'Shelburn',
		'US1840007140' => 'Columbia City',
		'US1840009758' => 'Dale',
		'US1840009432' => 'Kirklin',
		'US1840013778' => 'Hanover',
		'US1840005175' => 'Roselawn',
		'US1840010546' => 'Hagerstown',
		'US1840008354' => 'Lafayette',
		'US1840005346' => 'Buffalo',
		'US1840008207' => 'Garrett',
		'US1840010252' => 'Albion',
		'US1840010227' => 'Whiting',
		'US1840009266' => 'Burns Harbor',
		'US1840010306' => 'Kentland',
		'US1840010624' => 'Staunton',
		'US1840010822' => 'Poseyville',
		'US1840010447' => 'Kempton',
		'US1840010502' => 'Waveland',
		'US1840009423' => 'Bryant',
		'US1840010293' => 'Wheatfield',
		'US1840010736' => 'Alfordsville',
		'US1840009493' => 'Cambridge City',
		'US1840010683' => 'Hymera',
		'US1840009554' => 'Carthage',
		'US1840014176' => 'Richmond',
		'US1840010733' => 'Plainville',
		'US1840010253' => 'Avilla',
		'US1840007093' => 'Hobart',
		'US1840024605' => 'Freelandville',
		'US1840013731' => 'Fortville',
		'US1840009817' => 'Leavenworth',
		'US1840009378' => 'Burnettsville',
		'US1840010206' => 'Hudson',
		'US1840007243' => 'Covington',
		'US1840007099' => 'Butler',
		'US1840010455' => 'Edgewood',
		'US1840009441' => 'Orestes',
		'US1840010545' => 'Greens Fork',
		'US1840024487' => 'Harrodsburg',
		'US1840010542' => 'East Germantown',
		'US1840010359' => 'Reynolds',
		'US1840010504' => 'Wingate',
		'US1840009821' => 'Crandall',
		'US1840010801' => 'Ferdinand',
		'US1840013884' => 'Mount Vernon',
		'US1840030022' => 'Shepardsville',
		'US1840026782' => 'Parkers Settlement',
		'US1840009264' => 'Portage',
		'US1840013733' => 'Goshen',
		'US1840010430' => 'West Lafayette',
		'US1840009543' => 'Bainbridge',
		'US1840010697' => 'Worthington',
		'US1840010342' => 'Warren',
		'US1840009710' => 'Crothersville',
		'US1840009324' => 'Brook',
		'US1840010382' => 'Yeoman',
		'US1840010735' => 'Washington',
		'US1840010581' => 'Stilesville',
		'US1840007496' => 'Huntingburg',
		'US1840010292' => 'Remington',
		'US1840009822' => 'Laconia',
		'US1840009270' => 'Ogden Dunes',
		'US1840009671' => 'Terre Haute',
		'US1840007169' => 'Huntington',
		'US1840009330' => 'Medaryville',
		'US1840010510' => 'Jamestown',
		'US1840009279' => 'Cromwell',
		'US1840009823' => 'Lanesville',
		'US1840009624' => 'Moores Hill',
		'US1840004908' => 'Koontz Lake',
		'US1840010479' => 'Farmland',
		'US1840009479' => 'Cadiz',
		'US1840010757' => 'Austin',
		'US1840010465' => 'Kingman',
		'US1840013730' => 'Evansville',
		'US1840010813' => 'Georgetown',
		'US1840009708' => 'Seymour',
		'US1840010268' => 'Argos',
		'US1840009570' => 'New Whiteland',
		'US1840026385' => 'Somerset',
		'US1840010802' => 'Holland',
		'US1840010203' => 'Westville',
		'US1840010466' => 'Veedersburg',
		'US1840009802' => 'Mackey',
		'US1840010519' => 'Perrysville',
		'US1840009664' => 'Borden',
		'US1840009244' => 'North Liberty',
		'US1840009249' => 'Clear Lake',
		'US1840009534' => 'North Crows Nest',
		'US1840009268' => 'Dune Acres',
		'US1840024610' => 'Raglesville',
		'US1840024299' => 'Colburn',
		'US1840009692' => 'Linton',
		'US1840009737' => 'Montgomery',
		'US1840005744' => 'Brazil',
		'US1840010811' => 'Alton',
		'US1840010728' => 'Sandborn',
		'US1840007379' => 'Batesville',
		'US1840009717' => 'Oolitic',
		'US1840010379' => 'Fowler',
		'US1840010530' => 'Dunreith',
		'US1840024458' => 'New Goshen',
		'US1840010362' => 'Galveston',
		'US1840009478' => 'Blountsville',
		'US1840010199' => 'Hamlet',
		'US1840010360' => 'Wolcott',
		'US1840010534' => 'Springport',
		'US1840009801' => 'Princeton',
		'US1840026272' => 'Shelby',
		'US1840009299' => 'Bourbon',
		'US1840010669' => 'Hope',
		'US1840010446' => 'Rossville',
		'US1840009459' => 'Cicero',
		'US1840009380' => 'Monon',
		'US1840009527' => 'New Palestine',
		'US1840009598' => 'Oldenburg',
		'US1840008358' => 'Frankfort',
		'US1840010335' => 'Wabash',
		'US1840024293' => 'Mier',
		'US1840009259' => 'Cedar Lake',
		'US1840010310' => 'Francesville',
		'US1840010423' => 'Salamonia',
		'US1840026740' => 'Otwell',
		'US1840009535' => 'Avon',
		'US1840024608' => 'Burns City',
		'US1840010297' => 'Huntertown',
		'US1840009306' => 'Mentone',
		'US1840009238' => 'Bristol',
		'US1840010226' => 'Highland',
		'US1840010480' => 'Union City',
		'US1840009569' => 'Bargersville',
		'US1840010496' => 'Fishers',
		'US1840010498' => 'Atlanta',
		'US1840009790' => 'Salem',
		'US1840010459' => 'Eaton',
		'US1840009403' => 'Boswell',
		'US1840026609' => 'Van Bibber Lake',
		'US1840010397' => 'Sweetser',
		'US1840009361' => 'Markle',
		'US1840009792' => 'Little York',
		'US1840010787' => 'Utica',
		'US1840010222' => 'Schererville',
		'US1840010520' => 'Fairview Park',
		'US1840010249' => 'Ashley',
		'US1840010810' => 'English',
		'US1840010205' => 'Hamilton',
		'US1840009531' => 'Crows Nest',
		'US1840009693' => 'Bloomfield',
		'US1840009596' => 'Laurel',
		'US1840010225' => 'Griffith',
		'US1840014526' => 'Winchester',
		'US1840009382' => 'Onward',
		'US1840010729' => 'Edwardsport',
		'US1840013836' => 'Knox',
		'US1840010821' => 'Tennyson',
		'US1840010668' => 'Hartsville',
		'US1840010576' => 'Williams Creek',
		'US1840024457' => 'Fontanet',
		'US1840024606' => 'Ragsdale',
		'US1840010305' => 'Goodland',
		'US1840010531' => 'Greensboro',
		'US1840026741' => 'Dubois',
		'US1840025647' => 'Canaan',
		'US1840009407' => 'Camden',
		'US1840010441' => 'Pine Village',
		'US1840009262' => 'Munster',
		'US1840010281' => 'Winona Lake',
		'US1840009675' => 'Knightsville',
		'US1840010658' => 'Westport',
		'US1840009444' => 'Newtown',
		'US1840006208' => 'Memphis',
		'US1840009449' => 'Lynn',
		'US1840010620' => 'Riley',
		'US1840008189' => 'Nappanee',
		'US1840010428' => 'Russiaville',
		'US1840010521' => 'Universal',
		'US1840009319' => 'Larwill',
		'US1840009827' => 'Palmyra',
		'US1840008645' => 'Oakland City',
		'US1840039282' => 'Dresser',
		'US1840010797' => 'Francisco',
		'US1840026757' => 'New Salisbury',
		'US1840009243' => 'New Carlisle',
		'US1840009668' => 'Mooresville',
		'US1840010500' => 'Westfield',
	],
	'IA' => [
		'US1840009161' => 'Lidderdale',
		'US1840000396' => 'Sioux Rapids',
		'US1840008003' => 'Marble Rock',
		'US1840007994' => 'Gillett Grove',
		'US1840007101' => 'Crawfordsville',
		'US1840006987' => 'Alburnett',
		'US1840006937' => 'Callender',
		'US1840009345' => 'Stanton',
		'US1840006943' => 'Aurora',
		'US1840008074' => 'Knierim',
		'US1840024035' => 'Sexton',
		'US1840008222' => 'East Peru',
		'US1840008098' => 'Fairfax',
		'US1840008178' => 'Jamaica',
		'US1840009050' => 'Sanborn',
		'US1840010084' => 'Washta',
		'US1840024056' => 'Miller',
		'US1840009056' => 'Rodman',
		'US1840008268' => 'Eldon',
		'US1840001003' => 'Mount Ayr',
		'US1840007968' => 'Melvin',
		'US1840007984' => 'Ireton',
		'US1840009215' => 'Panama',
		'US1840006873' => 'Hull',
		'US1840008266' => 'New London',
		'US1840009068' => 'St. Olaf',
		'US1840007980' => 'Jackson Junction',
		'US1840009167' => 'Luther',
		'US1840009030' => 'Stacyville',
		'US1840009169' => 'Pilot Mound',
		'US1840007102' => 'Ainsworth',
		'US1840008231' => 'Neola',
		'US1840009344' => 'Pacific Junction',
		'US1840008210' => 'Kalona',
		'US1840007114' => 'Bussey',
		'US1840008018' => 'Monona',
		'US1840009162' => 'Templeton',
		'US1840010057' => 'Whittemore',
		'US1840010131' => 'Turin',
		'US1840024207' => 'Mineola',
		'US1840007126' => 'Griswold',
		'US1840000440' => 'Waterloo',
		'US1840009061' => 'Rockford',
		'US1840010058' => 'Wahpeton',
		'US1840008077' => 'Kamrar',
		'US1840009111' => 'Sergeant Bluff',
		'US1840009399' => 'St. Paul',
		'US1840007068' => 'Grimes',
		'US1840007048' => 'Bennett',
		'US1840006949' => 'Cushing',
		'US1840007192' => 'Bonaparte',
		'US1840007981' => 'Granville',
		'US1840007147' => 'Hillsboro',
		'US1840008176' => 'Lambs Grove',
		'US1840008218' => 'Keota',
		'US1840006913' => 'Allison',
		'US1840008177' => 'Menlo',
		'US1840008270' => 'Murray',
		'US1840009055' => 'Mallard',
		'US1840010237' => 'Wilton',
		'US1840009212' => 'Redfield',
		'US1840006916' => 'Denver',
		'US1840008309' => 'Ellston',
		'US1840000890' => 'Chariton',
		'US1840006911' => 'Hansell',
		'US1840009143' => 'Luzerne',
		'US1840009204' => 'Little Sioux',
		'US1840009392' => 'Redding',
		'US1840009065' => 'Luana',
		'US1840006946' => 'Cedar Falls',
		'US1840009096' => 'Peosta',
		'US1840008313' => 'Le Roy',
		'US1840009285' => 'South English',
		'US1840007042' => 'DeWitt',
		'US1840009398' => 'Rathbun',
		'US1840008115' => 'Le Grand',
		'US1840007083' => 'Donahue',
		'US1840010282' => 'Wapello',
		'US1840007973' => 'Inwood',
		'US1840006984' => 'Coggon',
		'US1840008058' => 'Independence',
		'US1840007047' => 'Clarence',
		'US1840010236' => 'West Liberty',
		'US1840010136' => 'Westside',
		'US1840006929' => 'Balltown',
		'US1840008225' => 'Keomah Village',
		'US1840006891' => 'Guttenberg',
		'US1840007976' => 'Elma',
		'US1840008173' => 'Mingo',
		'US1840009160' => 'St. Anthony',
		'US1840007096' => 'Conesville',
		'US1840009333' => 'Maharishi Vedic City',
		'US1840008153' => 'Mondamin',
		'US1840009047' => 'Sutherland',
		'US1840009336' => 'Olds',
		'US1840009059' => 'Rossie',
		'US1840007165' => 'Danville',
		'US1840008122' => 'Gilbert',
		'US1840024054' => 'Hayfield',
		'US1840008035' => 'Geneva',
		'US1840007205' => 'Donnellson',
		'US1840010160' => 'Toronto',
		'US1840009236' => 'Princeton',
		'US1840009067' => 'Osterdock',
		'US1840008056' => 'Lehigh',
		'US1840000439' => 'Fort Dodge',
		'US1840008121' => 'Grand Junction',
		'US1840008151' => 'Missouri Valley',
		'US1840009332' => 'Lockridge',
		'US1840009081' => 'Livermore',
		'US1840007107' => 'Harper',
		'US1840010067' => 'Thornton',
		'US1840009054' => 'Rockwell',
		'US1840006944' => 'Brandon',
		'US1840009166' => 'Schleswig',
		'US1840008168' => 'Elkhart',
		'US1840007181' => 'Coin',
		'US1840024087' => 'Bradford',
		'US1840009142' => 'St. Donatus',
		'US1840007967' => 'Kensett',
		'US1840008236' => 'Lewis',
		'US1840009393' => 'Pleasanton',
		'US1840008062' => 'Elk Run Heights',
		'US1840010137' => 'Zearing',
		'US1840008125' => 'Nevada',
		'US1840008202' => 'Muscatine',
		'US1840009026' => 'Orleans',
		'US1840010061' => 'Waterville',
		'US1840008237' => 'Fontanelle',
		'US1840008157' => 'Ladora',
		'US1840008091' => 'La Motte',
		'US1840007160' => 'Arispe',
		'US1840010182' => 'Woodward',
		'US1840000470' => 'Vinton',
		'US1840008167' => 'Montezuma',
		'US1840008315' => 'Exline',
		'US1840009234' => 'Long Grove',
		'US1840008038' => 'Greene',
		'US1840008161' => 'Elk Horn',
		'US1840007959' => 'Okoboji',
		'US1840006992' => 'Center Junction',
		'US1840007969' => 'Ocheyedan',
		'US1840009116' => 'Manson',
		'US1840008155' => 'North English',
		'US1840010315' => 'Winfield',
		'US1840006998' => 'Haverhill',
		'US1840007058' => 'Defiance',
		'US1840008069' => 'Odebolt',
		'US1840007157' => 'Carbon',
		'US1840026213' => 'Stone City',
		'US1840008117' => 'Lanesboro',
		'US1840009120' => 'Rockwell City',
		'US1840010260' => 'What Cheer',
		'US1840009295' => 'Macedonia',
		'US1840008318' => 'Moravia',
		'US1840007038' => 'Calamus',
		'US1840026201' => 'Climbing Hill',
		'US1840010135' => 'Vail',
		'US1840006914' => 'Aplington',
		'US1840010095' => 'Zwingle',
		'US1840010162' => 'Wheatland',
		'US1840006915' => 'Aredale',
		'US1840010101' => 'Union',
		'US1840008306' => 'Keosauqua',
		'US1840007115' => 'Hamilton',
		'US1840009063' => 'Randalia',
		'US1840010186' => 'Windsor Heights',
		'US1840006957' => 'Ida Grove',
		'US1840006951' => 'Anthon',
		'US1840007069' => 'Des Moines',
		'US1840010103' => 'Wellsburg',
		'US1840006881' => 'Cylinder',
		'US1840009078' => 'Plover',
		'US1840010181' => 'Waukee',
		'US1840008109' => 'Moorhead',
		'US1840008070' => 'Lake View',
		'US1840008182' => 'Eldridge',
		'US1840009176' => 'Roland',
		'US1840008274' => 'Elliott',
		'US1840010189' => 'Tiffin',
		'US1840026160' => 'Burr Oak',
		'US1840008164' => 'Exira',
		'US1840007962' => 'Estherville',
		'US1840006862' => 'Calmar',
		'US1840009340' => 'Lucas',
		'US1840009337' => 'Rome',
		'US1840009237' => 'Riverdale',
		'US1840000381' => 'Spencer',
		'US1840008171' => 'Newton',
		'US1840007191' => 'Birmingham',
		'US1840009283' => 'Sandyville',
		'US1840007077' => 'Hills',
		'US1840024033' => 'St. Benedict',
		'US1840009060' => 'Royal',
		'US1840006912' => 'Clarksville',
		'US1840006952' => 'Hornick',
		'US1840008097' => 'Ely',
		'US1840009225' => 'Reasnor',
		'US1840000449' => 'Webster City',
		'US1840007054' => 'Bouton',
		'US1840008137' => 'Goose Lake',
		'US1840009066' => 'Strawberry Point',
		'US1840009199' => 'Stanwood',
		'US1840007201' => 'Allerton',
		'US1840010070' => 'Webb',
		'US1840024032' => 'Irvington',
		'US1840010130' => 'Wyoming',
		'US1840009110' => 'Salix',
		'US1840007065' => 'Altoona',
		'US1840006932' => 'Holy Cross',
		'US1840024040' => 'New Haven',
		'US1840009173' => 'Sheldahl',
		'US1840008314' => 'Millerton',
		'US1840006847' => 'Burt',
		'US1840008016' => 'North Buena Vista',
		'US1840007053' => 'Adel',
		'US1840008123' => 'Maxwell',
		'US1840008031' => 'Dows',
		'US1840009292' => 'Swan',
		'US1840006864' => 'Decorah',
		'US1840024256' => 'Anderson',
		'US1840009217' => 'Malcom',
		'US1840008052' => 'Masonville',
		'US1840009150' => 'Tama',
		'US1840006902' => 'Aurelia',
		'US1840010368' => 'Weldon',
		'US1840006950' => 'Danbury',
		'US1840009226' => 'Panora',
		'US1840009391' => 'Maloy',
		'US1840008158' => 'Granger',
		'US1840010365' => 'Yorktown',
		'US1840009052' => 'Plymouth',
		'US1840008057' => 'Fairbank',
		'US1840009348' => 'Lorimor',
		'US1840024042' => 'Toeterville',
		'US1840009034' => 'Little Rock',
		'US1840008169' => 'Mitchellville',
		'US1840024057' => 'Roseville',
		'US1840009165' => 'Ricketts',
		'US1840009112' => 'Lytton',
		'US1840008159' => 'Minburn',
		'US1840000648' => 'Indianola',
		'US1840009394' => 'Lineville',
		'US1840006981' => 'Bellevue',
		'US1840010261' => 'Truro',
		'US1840026255' => 'Frytown',
		'US1840007979' => 'Fort Atkinson',
		'US1840008120' => 'Ogden',
		'US1840006894' => 'Brunsville',
		'US1840010367' => 'Van Wert',
		'US1840007982' => 'Matlock',
		'US1840008152' => 'Modale',
		'US1840007203' => 'Cincinnati',
		'US1840024037' => 'Little Cedar',
		'US1840007183' => 'Blanchard',
		'US1840008103' => 'Garwin',
		'US1840008099' => 'Marion',
		'US1840008214' => 'Milo',
		'US1840007043' => 'Delmar',
		'US1840008213' => 'Norwalk',
		'US1840007097' => 'Atalissa',
		'US1840007164' => 'Burlington',
		'US1840007154' => 'Henderson',
		'US1840009119' => 'Rinard',
		'US1840009019' => 'Scarville',
		'US1840008063' => 'Gilbertville',
		'US1840008301' => 'New Market',
		'US1840006927' => 'Centralia',
		'US1840008071' => 'Galva',
		'US1840010188' => 'Yale',
		'US1840024051' => 'Burchinal',
		'US1840009064' => 'St. Lucas',
		'US1840007118' => 'Crescent',
		'US1840008246' => 'Grandview',
		'US1840007990' => 'Emmetsburg',
		'US1840008211' => 'Martensdale',
		'US1840004813' => 'Park View',
		'US1840008146' => 'Durant',
		'US1840008009' => 'Elkader',
		'US1840007000' => 'Arcadia',
		'US1840006958' => 'Blairsburg',
		'US1840006899' => 'Alta',
		'US1840008322' => 'Franklin',
		'US1840009274' => 'Stockton',
		'US1840010056' => 'West Bend',
		'US1840000471' => 'Cedar Rapids',
		'US1840009022' => 'Swea City',
		'US1840008040' => 'Frederika',
		'US1840008302' => 'Lenox',
		'US1840024088' => 'Chapin',
		'US1840000887' => 'Fairfield',
		'US1840008026' => 'Meriden',
		'US1840006897' => 'Hinton',
		'US1840024038' => 'Meyer',
		'US1840007190' => 'Cantril',
		'US1840007960' => 'Milford',
		'US1840009072' => 'Remsen',
		'US1840001036' => 'Keokuk',
		'US1840000469' => 'Shellsburg',
		'US1840008039' => 'New Hartford',
		'US1840007987' => 'Goodell',
		'US1840007999' => 'North Washington',
		'US1840010054' => 'Titonka',
		'US1840010259' => 'Webster',
		'US1840009020' => 'Lone Rock',
		'US1840000490' => 'Carroll',
		'US1840006933' => 'Colesburg',
		'US1840010085' => 'Varina',
		'US1840009287' => 'Richland',
		'US1840009383' => 'Sidney',
		'US1840000650' => 'Oskaloosa',
		'US1840010059' => 'West Okoboji',
		'US1840000398' => 'Rolfe',
		'US1840009335' => 'Pleasant Plain',
		'US1840007148' => 'Chillicothe',
		'US1840008154' => 'Marengo',
		'US1840009051' => 'Swaledale',
		'US1840009291' => 'Rose Hill',
		'US1840008162' => 'Irwin',
		'US1840009043' => 'Sioux Center',
		'US1840006926' => 'Cascade',
		'US1840000403' => 'Sumner',
		'US1840007120' => 'Carter Lake',
		'US1840009281' => 'Spring Hill',
		'US1840007136' => 'Cotter',
		'US1840009058' => 'Peterson',
		'US1840006871' => 'Hawarden',
		'US1840009071' => 'Oyens',
		'US1840010180' => 'Van Meter',
		'US1840007179' => 'Imogene',
		'US1840007953' => 'Forest City',
		'US1840006991' => 'Chelsea',
		'US1840009018' => 'Rake',
		'US1840010098' => 'Wall Lake',
		'US1840006896' => 'Akron',
		'US1840007122' => 'Hancock',
		'US1840009151' => 'Olin',
		'US1840007991' => 'Graettinger',
		'US1840007997' => 'Nashua',
		'US1840007104' => 'Carlisle',
		'US1840009062' => 'Rudd',
		'US1840007198' => 'Decatur City',
		'US1840024208' => 'Kent',
		'US1840000402' => 'Sheffield',
		'US1840007013' => 'Boxholm',
		'US1840006960' => 'Ackley',
		'US1840000649' => 'Winterset',
		'US1840008065' => 'Moville',
		'US1840006904' => 'Clarion',
		'US1840009343' => 'Silver City',
		'US1840000530' => 'Harlan',
		'US1840008020' => 'Merrill',
		'US1840007200' => 'Corydon',
		'US1840006986' => 'Central City',
		'US1840007061' => 'Hartwick',
		'US1840009137' => 'Maquoketa',
		'US1840007988' => 'Kanawha',
		'US1840008048' => 'New Vienna',
		'US1840026217' => 'Green Mountain',
		'US1840007972' => 'George',
		'US1840007119' => 'Carson',
		'US1840007155' => 'Coburg',
		'US1840007193' => 'Beaconsfield',
		'US1840010100' => 'Williams',
		'US1840010069' => 'Woden',
		'US1840007106' => 'Hartford',
		'US1840007156' => 'Corning',
		'US1840008305' => 'Milton',
		'US1840006988' => 'Bertram',
		'US1840010068' => 'Ventura',
		'US1840026382' => 'Beaverdale',
		'US1840009389' => 'Stockport',
		'US1840009209' => 'Parnell',
		'US1840009216' => 'Portsmouth',
		'US1840006874' => 'Calumet',
		'US1840009044' => 'Orange City',
		'US1840006895' => 'Craig',
		'US1840009140' => 'Preston',
		'US1840026195' => 'Washburn',
		'US1840009074' => 'Marathon',
		'US1840008217' => 'Martinsburg',
		'US1840000492' => 'Jefferson',
		'US1840005358' => 'Douds',
		'US1840008227' => 'Marysville',
		'US1840010263' => 'Treynor',
		'US1840008312' => 'Grand River',
		'US1840024055' => 'Hutchins',
		'US1840007195' => 'Delphos',
		'US1840006880' => 'Curlew',
		'US1840006846' => 'Buffalo Center',
		'US1840007978' => 'Lansing',
		'US1840009017' => 'Thompson',
		'US1840008271' => 'Melrose',
		'US1840008119' => 'Fraser',
		'US1840009041' => 'Ossian',
		'US1840008307' => 'Drakesville',
		'US1840010316' => 'Woodburn',
		'US1840007073' => 'Bagley',
		'US1840026254' => 'Homestead',
		'US1840010183' => 'Westphalia',
		'US1840000889' => 'Osceola',
		'US1840008089' => 'Miles',
		'US1840009097' => 'Rickardsville',
		'US1840009036' => 'Lime Springs',
		'US1840009102' => 'Stanley',
		'US1840007057' => 'Dexter',
		'US1840006955' => 'Battle Creek',
		'US1840007116' => 'Harvey',
		'US1840008229' => 'Knoxville',
		'US1840007074' => 'Bayard',
		'US1840006945' => 'Hazleton',
		'US1840006890' => 'Clayton',
		'US1840009103' => 'Quasqueton',
		'US1840024039' => 'Mona',
		'US1840009159' => 'Rhodes',
		'US1840008066' => 'Lawton',
		'US1840008032' => 'Eagle Grove',
		'US1840006928' => 'Asbury',
		'US1840008264' => 'Libertyville',
		'US1840008014' => 'Marquette',
		'US1840029701' => 'Holiday Lake',
		'US1840024036' => 'Bolan',
		'US1840007957' => 'Lakota',
		'US1840007039' => 'Camanche',
		'US1840026247' => 'Amana',
		'US1840006979' => 'Andrew',
		'US1840009037' => 'Protivin',
		'US1840009170' => 'Paton',
		'US1840006985' => 'Center Point',
		'US1840009346' => 'Red Oak',
		'US1840009075' => 'Rembrandt',
		'US1840008005' => 'Elgin',
		'US1840008015' => 'McGregor',
		'US1840007010' => 'Beaver',
		'US1840001006' => 'Centerville',
		'US1840008156' => 'Millersburg',
		'US1840007009' => 'Dow City',
		'US1840006889' => 'Hawkeye',
		'US1840006855' => 'Harris',
		'US1840008093' => 'Mount Auburn',
		'US1840008027' => 'Larrabee',
		'US1840009141' => 'Sabula',
		'US1840010177' => 'Woodbine',
		'US1840004701' => 'Breda',
		'US1840007060' => 'Guernsey',
		'US1840009098' => 'Sageville',
		'US1840008160' => 'Earling',
		'US1840006980' => 'Baldwin',
		'US1840009148' => 'Robins',
		'US1840008116' => 'Glidden',
		'US1840007112' => 'Barnes City',
		'US1840009218' => 'Searsboro',
		'US1840008310' => 'Kellerton',
		'US1840008163' => 'Kirkman',
		'US1840007145' => 'Batavia',
		'US1840008067' => 'Early',
		'US1840006994' => 'Castana',
		'US1840007150' => 'Blakesburg',
		'US1840009168' => 'Madrid',
		'US1840004340' => 'Britt',
		'US1840008273' => 'Glenwood',
		'US1840010161' => 'Welton',
		'US1840010086' => 'Woolstock',
		'US1840007070' => 'Colfax',
		'US1840009083' => 'Pioneer',
		'US1840007958' => 'Ledyard',
		'US1840026249' => 'High Amana',
		'US1840008228' => 'Melcher-Dallas',
		'US1840006965' => 'Grundy Center',
		'US1840008037' => 'Dumont',
		'US1840004897' => 'Brighton',
		'US1840009101' => 'Otho',
		'US1840010124' => 'Van Horne',
		'US1840008170' => 'Johnston',
		'US1840007067' => 'Bondurant',
		'US1840007016' => 'Cambridge',
		'US1840007963' => 'Fertile',
		'US1840010257' => 'West Chester',
		'US1840007111' => 'Bevington',
		'US1840008022' => 'Le Mars',
		'US1840008298' => 'Essex',
		'US1840007986' => 'Garner',
		'US1840008172' => 'Oakland Acres',
		'US1840008080' => 'Morrison',
		'US1840006851' => 'Gruver',
		'US1840008054' => 'Gowrie',
		'US1840010193' => 'Walcott',
		'US1840006882' => 'Ayrshire',
		'US1840010173' => 'Tipton',
		'US1840008234' => 'Marne',
		'US1840007194' => 'Benton',
		'US1840009157' => 'Liscomb',
		'US1840009021' => 'Lu Verne',
		'US1840009338' => 'Salem',
		'US1840009384' => 'Randolph',
		'US1840009223' => 'Sully',
		'US1840008105' => 'Montour',
		'US1840006856' => 'Carpenter',
		'US1840000438' => 'Dubuque',
		'US1840009195' => 'Low Moor',
		'US1840008021' => 'Kingsley',
		'US1840006854' => 'Ashton',
		'US1840010369' => 'Udell',
		'US1840008220' => 'Kinross',
		'US1840009172' => 'Scranton',
		'US1840026253' => 'East Amana',
		'US1840007974' => 'Larchwood',
		'US1840010123' => 'Urbana',
		'US1840008043' => 'Durango',
		'US1840008304' => 'Mount Sterling',
		'US1840007993' => 'Fostoria',
		'US1840006885' => 'Bassett',
		'US1840008303' => 'Farmington',
		'US1840008221' => 'Earlham',
		'US1840000441' => 'Evansdale',
		'US1840009175' => 'Story City',
		'US1840010074' => 'Waucoma',
		'US1840000404' => 'Waverly',
		'US1840009117' => 'Somers',
		'US1840006886' => 'Colwell',
		'US1840010128' => 'Traer',
		'US1840008233' => 'Minden',
		'US1840008108' => 'Morley',
		'US1840007135' => 'Columbus Junction',
		'US1840006996' => 'Clemons',
		'US1840009038' => 'Riceville',
		'US1840006872' => 'Hospers',
		'US1840009206' => 'Magnolia',
		'US1840007995' => 'Greenville',
		'US1840007117' => 'Council Bluffs',
		'US1840007113' => 'Beacon',
		'US1840008230' => 'McClelland',
		'US1840026251' => 'South Amana',
		'US1840008247' => 'Oakville',
		'US1840009155' => 'Soldier',
		'US1840006964' => 'Beaman',
		'US1840009349' => 'Shannon City',
		'US1840010060' => 'Wallingford',
		'US1840007007' => 'Deloit',
		'US1840009152' => 'Onslow',
		'US1840009210' => 'Linden',
		'US1840009290' => 'St. Charles',
		'US1840010129' => 'Vining',
		'US1840008002' => 'Floyd',
		'US1840006858' => 'Doon',
		'US1840007121' => 'Avoca',
		'US1840007188' => 'Bedford',
		'US1840008051' => 'Greeley',
		'US1840009121' => 'Stanhope',
		'US1840007064' => 'Alleman',
		'US1840007186' => 'Clearfield',
		'US1840009284' => 'Sigourney',
		'US1840009086' => 'Popejoy',
		'US1840006940' => 'Barnum',
		'US1840008317' => 'Numa',
		'US1840009397' => 'Plano',
		'US1840008073' => 'Jolley',
		'US1840006903' => 'Havelock',
		'US1840009031' => 'Orchard',
		'US1840009147' => 'Prairieburg',
		'US1840007134' => 'Columbus City',
		'US1840006948' => 'Correctionville',
		'US1840009114' => 'Schaller',
		'US1840006953' => 'Auburn',
		'US1840009164' => 'Manilla',
		'US1840009205' => 'Logan',
		'US1840007998' => 'New Hampton',
		'US1840009045' => 'Rock Valley',
		'US1840008319' => 'Moulton',
		'US1840006983' => 'Blairstown',
		'US1840007954' => 'Lake Mills',
		'US1840008106' => 'Martelle',
		'US1840010262' => 'University Park',
		'US1840024133' => 'River Sioux',
		'US1840008044' => 'Dyersville',
		'US1840009231' => 'Oxford',
		'US1840008025' => 'Marcus',
		'US1840009154' => 'Mapleton',
		'US1840009085' => 'Rutland',
		'US1840000382' => 'Charles City',
		'US1840000468' => 'Belle Plaine',
		'US1840009286' => 'Ollie',
		'US1840009090' => 'Readlyn',
		'US1840008050' => 'Earlville',
		'US1840024052' => 'Portland',
		'US1840006876' => 'Hartley',
		'US1840009297' => 'Orient',
		'US1840009087' => 'Shell Rock',
		'US1840008201' => 'Fruitland',
		'US1840010373' => 'West Point',
		'US1840009211' => 'Perry',
		'US1840007062' => 'Deep River',
		'US1840009106' => 'Sloan',
		'US1840007189' => 'Blockton',
		'US1840007005' => 'Arion',
		'US1840009082' => 'Ottosen',
		'US1840009235' => 'Panorama Park',
		'US1840007185' => 'Hepburn',
		'US1840009084' => 'Renwick',
		'US1840009123' => 'Randall',
		'US1840008001' => 'Lawler',
		'US1840007108' => 'Hayesville',
		'US1840006909' => 'Coulter',
		'US1840000400' => 'Humboldt',
		'US1840009070' => 'Struble',
		'US1840000888' => 'Mount Pleasant',
		'US1840008079' => 'Iowa Falls',
		'US1840006888' => 'Arlington',
		'US1840010174' => 'West Branch',
		'US1840008226' => 'Leighton',
		'US1840006982' => 'Atkins',
		'US1840008023' => 'Newell',
		'US1840007204' => 'Houghton',
		'US1840008248' => 'Morning Sun',
		'US1840008011' => 'Farmersburg',
		'US1840007080' => 'Blue Grass',
		'US1840009347' => 'Prescott',
		'US1840008092' => 'Garrison',
		'US1840007015' => 'Dana',
		'US1840008033' => 'Galt',
		'US1840007040' => 'Charlotte',
		'US1840026245' => 'Rochester',
		'US1840009213' => 'Shelby',
		'US1840006901' => 'Cherokee',
		'US1840009289' => 'Patterson',
		'US1840006942' => 'Dayton',
		'US1840000352' => 'Algona',
		'US1840004799' => 'Brooklyn',
		'US1840006860' => 'Chester',
		'US1840006907' => 'Bradgate',
		'US1840006995' => 'Blencoe',
		'US1840024053' => 'Duncan',
		'US1840009027' => 'Ringsted',
		'US1840010190' => 'University Heights',
		'US1840007961' => 'Lake Park',
		'US1840006930' => 'Bankston',
		'US1840006910' => 'Alexander',
		'US1840007075' => 'Guthrie Center',
		'US1840010125' => 'Walford',
		'US1840010256' => 'Wellman',
		'US1840010096' => 'Vincent',
		'US1840007109' => 'Hedrick',
		'US1840009194' => 'Lost Nation',
		'US1840007983' => 'Maurice',
		'US1840006861' => 'Harpers Ferry',
		'US1840029702' => 'Lake Panorama',
		'US1840000491' => 'Manning',
		'US1840009028' => 'Manly',
		'US1840009144' => 'Lisbon',
		'US1840009350' => 'Thayer',
		'US1840008029' => 'Gilmore City',
		'US1840010127' => 'Toledo',
		'US1840007180' => 'Clarinda',
		'US1840026248' => 'Conroy',
		'US1840008185' => 'New Liberty',
		'US1840006868' => 'Chatsworth',
		'US1840010087' => 'Thor',
		'US1840007011' => 'Berkley',
		'US1840010099' => 'Yetter',
		'US1840009224' => 'Prairie City',
		'US1840009198' => 'Lowden',
		'US1840001005' => 'Leon',
		'US1840008267' => 'Eddyville',
		'US1840007985' => 'Meservey',
		'US1840008118' => 'Kiron',
		'US1840008045' => 'Epworth',
		'US1840009040' => 'Spillville',
		'US1840009057' => 'Ruthven',
		'US1840024132' => 'California Junction',
		'US1840007955' => 'Leland',
		'US1840009033' => 'St. Ansgar',
		'US1840008316' => 'Mystic',
		'US1840006959' => 'Buckeye',
		'US1840006905' => 'Belmond',
		'US1840008174' => 'Monroe',
		'US1840009118' => 'Pomeroy',
		'US1840008275' => 'Grant',
		'US1840000390' => 'West Union',
		'US1840007103' => 'Cumming',
		'US1840009094' => 'Luxemburg',
		'US1840006936' => 'Delhi',
		'US1840009048' => 'Paullina',
		'US1840008107' => 'Monticello',
		'US1840024259' => 'Athelstan',
		'US1840024257' => 'Bartlett',
		'US1840000891' => 'Malvern',
		'US1840006887' => 'Clermont',
		'US1840009339' => 'Ottumwa',
		'US1840007153' => 'Hastings',
		'US1840008101' => 'Dysart',
		'US1840009025' => 'Terril',
		'US1840010083' => 'Truesdale',
		'US1840007975' => 'Lester',
		'US1840006848' => 'Bancroft',
		'US1840010313' => 'Wayland',
		'US1840009089' => 'Plainfield',
		'US1840007082' => 'Dixon',
		'US1840007008' => 'Denison',
		'US1840007182' => 'College Springs',
		'US1840008311' => 'Garden Grove',
		'US1840008223' => 'Fremont',
		'US1840007977' => 'New Albin',
		'US1840024135' => 'Jacksonville',
		'US1840010364' => 'Thurman',
		'US1840010102' => 'Whitten',
		'US1840006954' => 'Arthur',
		'US1840009222' => 'Lynnville',
		'US1840008007' => 'Oelwein',
		'US1840006999' => 'Coon Rapids',
		'US1840009146' => 'Palo',
		'US1840006934' => 'Hopkinton',
		'US1840026250' => 'Middle Amana',
		'US1840001001' => 'Tabor',
		'US1840009077' => 'Palmer',
		'US1840008299' => 'Northboro',
		'US1840009076' => 'Quimby',
		'US1840008113' => 'Melbourne',
		'US1840007002' => 'Dedham',
		'US1840009296' => 'Stuart',
		'US1840006947' => 'Hudson',
		'US1840000507' => 'Clinton',
		'US1840008238' => 'Greenfield',
		'US1840000397' => 'Storm Lake',
		'US1840007996' => 'Fredericksburg',
		'US1840008297' => 'Farragut',
		'US1840010366' => 'Tingley',
		'US1840009288' => 'Macksburg',
		'US1840000447' => 'Sioux City',
		'US1840007125' => 'Atlantic',
		'US1840007110' => 'Delta',
		'US1840009073' => 'Linn Grove',
		'US1840010132' => 'Ute',
		'US1840029594' => 'Adair',
		'US1840009385' => 'Riverton',
		'US1840009113' => 'Sac City',
		'US1840010097' => 'Winthrop',
		'US1840006850' => 'Armstrong',
		'US1840010134' => 'Willey',
		'US1840009334' => 'Packwood',
		'US1840009035' => 'Rock Rapids',
		'US1840008012' => 'Garber',
		'US1840008090' => 'Monmouth',
		'US1840009387' => 'Shenandoah',
		'US1840004800' => 'Saylorville',
		'US1840007072' => 'Casey',
		'US1840008184' => 'McCausland',
		'US1840010126' => 'Walker',
		'US1840006941' => 'Harcourt',
		'US1840007078' => 'Buffalo',
		'US1840006997' => 'Albion',
		'US1840000401' => 'Hampton',
		'US1840010133' => 'Whiting',
		'US1840010314' => 'Westwood',
		'US1840024041' => 'Otranto',
		'US1840009079' => 'Pocahontas',
		'US1840008055' => 'Moorland',
		'US1840007159' => 'Afton',
		'US1840008094' => 'Newhall',
		'US1840008219' => 'Keswick',
		'US1840006990' => 'Clutier',
		'US1840009095' => 'Sherrill',
		'US1840008150' => 'Dunlap',
		'US1840006961' => 'Alden',
		'US1840008203' => 'Nichols',
		'US1840006859' => 'Cresco',
		'US1840009100' => 'Ryan',
		'US1840000450' => 'Eldora',
		'US1840007052' => 'Dallas Center',
		'US1840009139' => 'Springbrook',
		'US1840010178' => 'Victor',
		'US1840008249' => 'Letts',
		'US1840006863' => 'Castalia',
		'US1840007017' => 'Collins',
		'US1840007014' => 'Churdan',
		'US1840004539' => 'Coalville',
		'US1840008321' => 'Fort Madison',
		'US1840010264' => 'Underwood',
		'US1840009104' => 'Rowley',
		'US1840009174' => 'Slater',
		'US1840006906' => 'Bode',
		'US1840007123' => 'Cumberland',
		'US1840010076' => 'Volga',
		'US1840007151' => 'Derby',
		'US1840007056' => 'De Soto',
		'US1840006938' => 'Clare',
		'US1840009214' => 'Tennant',
		'US1840000531' => 'Grinnell',
		'US1840006908' => 'Hardy',
		'US1840008183' => 'Maysville',
		'US1840007006' => 'Aspinwall',
		'US1840000448' => 'Lake City',
		'US1840008104' => 'Gladbrook',
		'US1840007079' => 'Bettendorf',
		'US1840008008' => 'Edgewood',
		'US1840000389' => 'Fayette',
		'US1840007965' => 'Northwood',
		'US1840007184' => 'Braddyville',
		'US1840006877' => 'Dougherty',
		'US1840007020' => 'Huxley',
		'US1840008272' => 'Emerson',
		'US1840006875' => 'Archer',
		'US1840007066' => 'Ankeny',
		'US1840009126' => 'Radcliffe',
		'US1840008186' => 'Le Claire',
		'US1840010266' => 'Wiota',
		'US1840009230' => 'Swisher',
		'US1840007992' => 'Everly',
		'US1840009115' => 'Lohrville',
		'US1840007081' => 'Davenport',
		'US1840008078' => 'New Providence',
		'US1840008100' => 'Mount Vernon',
		'US1840009227' => 'Lone Tree',
		'US1840008281' => 'Mediapolis',
		'US1840009229' => 'Solon',
		'US1840007966' => 'Joice',
		'US1840009158' => 'State Center',
		'US1840006989' => 'Hiawatha',
		'US1840008245' => 'Fredonia',
		'US1840010179' => 'Williamsburg',
		'US1840042316' => 'Sun Valley Lake',
		'US1840010094' => 'Worthington',
		'US1840006939' => 'Badger',
		'US1840009024' => 'Superior',
		'US1840010265' => 'Walnut',
		'US1840007971' => 'Mitchell',
		'US1840006967' => 'Dike',
		'US1840008110' => 'Ferguson',
		'US1840004798' => 'Brayton',
		'US1840007001' => 'Halbur',
		'US1840010185' => 'West Des Moines',
		'US1840009208' => 'Pisgah',
		'US1840000489' => 'Onawa',
		'US1840009207' => 'Persia',
		'US1840007071' => 'Baxter',
		'US1840024146' => 'Bentley',
		'US1840004898' => 'Bridgewater',
		'US1840007158' => 'Cromwell',
		'US1840007003' => 'Buck Grove',
		'US1840007196' => 'Diagonal',
		'US1840006852' => 'Dolliver',
		'US1840000892' => 'Creston',
		'US1840006853' => 'Hanlontown',
		'US1840024147' => 'Loveland',
		'US1840008072' => 'Farnhamville',
		'US1840007059' => 'Audubon',
		'US1840008000' => 'Ionia',
		'US1840007124' => 'Anita',
		'US1840008215' => 'Lacona',
		'US1840008059' => 'Jesup',
		'US1840010258' => 'Thornburg',
		'US1840009293' => 'Pella',
		'US1840009395' => 'Seymour',
		'US1840008060' => 'Lamont',
		'US1840010318' => 'Villisca',
		'US1840001004' => 'Lamoni',
		'US1840008124' => 'McCallsburg',
		'US1840009220' => 'Polk City',
		'US1840006966' => 'Holland',
		'US1840007105' => 'Ackworth',
		'US1840010075' => 'Westgate',
		'US1840008179' => 'North Liberty',
		'US1840000379' => 'Clear Lake',
		'US1840006884' => 'Alta Vista',
		'US1840007199' => 'Clio',
		'US1840008126' => 'Kelley',
		'US1840009088' => 'Parkersburg',
		'US1840007149' => 'Agency',
		'US1840008300' => 'Gravity',
		'US1840009390' => 'Pulaski',
		'US1840008166' => 'Kimballton',
		'US1840008308' => 'Floris',
		'US1840006869' => 'Alton',
		'US1840009219' => 'Pleasant Hill',
		'US1840008030' => 'Laurens',
		'US1840007063' => 'Clive',
		'US1840009153' => 'Oxford Junction',
		'US1840009221' => 'Runnells',
		'US1840006956' => 'Holstein',
		'US1840008138' => 'Grand Mound',
		'US1840009099' => 'Manchester',
		'US1840008111' => 'Gilman',
		'US1840006931' => 'Bernard',
		'US1840009342' => 'Lovilia',
		'US1840008102' => 'Elberon',
		'US1840009163' => 'Ralston',
		'US1840008036' => 'Latimer',
		'US1840008046' => 'Farley',
		'US1840008165' => 'Gray',
		'US1840007018' => 'Colo',
		'US1840000399' => 'Dakota City',
		'US1840026405' => 'Denmark',
		'US1840008276' => 'Nodaway',
		'US1840008216' => 'Gibson',
		'US1840008047' => 'Graf',
		'US1840007989' => 'Klemme',
		'US1840008269' => 'Kirkville',
		'US1840007202' => 'Humeston',
		'US1840007041' => 'Andover',
		'US1840010370' => 'Unionville',
		'US1840009029' => 'Sibley',
		'US1840008006' => 'Maynard',
		'US1840008068' => 'Nemaha',
		'US1840008282' => 'Middletown',
		'US1840008049' => 'Dundee',
		'US1840029700' => 'Diamondhead Lake',
		'US1840009080' => 'Rowan',
		'US1840008235' => 'Massena',
		'US1840008053' => 'Duncombe',
		'US1840008212' => 'New Virginia',
		'US1840007019' => 'Ames',
		'US1840007197' => 'Davis City',
		'US1840010062' => 'Waukon',
		'US1840004450' => 'Bristow',
		'US1840006857' => 'Alvord',
		'US1840009156' => 'Rodney',
		'US1840004579' => 'Bronson',
		'US1840008224' => 'New Sharon',
		'US1840008232' => 'Oakland',
		'US1840008075' => 'Ellsworth',
		'US1840026212' => 'Watkins',
		'US1840026252' => 'West Amana',
		'US1840006993' => 'Anamosa',
		'US1840008010' => 'Elkport',
		'US1840006870' => 'Boyden',
		'US1840009108' => 'Oto',
		'US1840010073' => 'Wadena',
		'US1840009124' => 'Steamboat Rock',
		'US1840001000' => 'Hamburg',
		'US1840000380' => 'Mason City',
		'US1840008095' => 'Norway',
		'US1840026202' => 'Garden City',
		'US1840008024' => 'Lakeside',
		'US1840008028' => 'Fonda',
		'US1840006879' => 'Crystal Lake',
		'US1840000532' => 'Iowa City',
		'US1840009032' => 'Osage',
		'US1840006962' => 'Hubbard',
		'US1840009341' => 'Russell',
		'US1840010088' => 'Tripoli',
		'US1840006883' => 'Dickens',
		'US1840008064' => 'La Porte City',
		'US1840009105' => 'Raymond',
		'US1840008004' => 'Nora Springs',
		'US1840007964' => 'Grafton',
		'US1840010187' => 'Valeria',
		'US1840009042' => 'Ridgeway',
		'US1840007152' => 'Albia',
		'US1840009046' => 'Sheldon',
		'US1840007004' => 'Charter Oak',
		'US1840009127' => 'Stout',
		'US1840001002' => 'Bloomfield',
		'US1840009294' => 'Pleasantville',
		'US1840008114' => 'Laurel',
		'US1840024034' => 'St. Joseph',
		'US1840009396' => 'Promise City',
		'US1840009039' => 'Postville',
		'US1840007076' => 'Coralville',
		'US1840009280' => 'Riverside',
		'US1840009053' => 'Rock Falls',
		'US1840008061' => 'Dunkerton',
		'US1840007970' => 'McIntire',
		'US1840008175' => 'Kellogg',
		'US1840009128' => 'Reinbeck',
		'US1840009149' => 'Lincoln',
		'US1840009138' => 'Spragueville',
		'US1840006963' => 'Conrad',
		'US1840008041' => 'Janesville',
		'US1840006935' => 'Delaware',
		'US1840008096' => 'Keystone',
		'US1840008112' => 'Marshalltown',
		'US1840009228' => 'Shueyville',
		'US1840029703' => 'Twin Lakes',
		'US1840010055' => 'Wesley',
		'US1840009171' => 'Rippey',
		'US1840010323' => 'West Burlington',
		'US1840007187' => 'Conway',
		'US1840010255' => 'Washington',
		'US1840009122' => 'Stratford',
		'US1840009282' => 'St. Marys',
		'US1840024134' => 'Corley',
		'US1840009125' => 'Owasa',
		'US1840010317' => 'Williamson',
		'US1840006900' => 'Cleghorn',
		'US1840009388' => 'Sharpsburg',
		'US1840009145' => 'Springville',
		'US1840008265' => 'Mount Union',
		'US1840008147' => 'Mechanicsville',
		'US1840007956' => 'Fenton',
		'US1840024258' => 'Percival',
		'US1840007146' => 'Coppock',
		'US1840006898' => 'Albert City',
		'US1840024148' => 'Weston',
		'US1840009049' => 'Primghar',
		'US1840010184' => 'Urbandale',
		'US1840007055' => 'Dawson',
		'US1840008034' => 'Goldfield',
		'US1840009109' => 'Pierson',
		'US1840005357' => 'Leando',
		'US1840006878' => 'Corwith',
		'US1840007012' => 'Boone',
		'US1840009386' => 'Shambaugh',
		'US1840008013' => 'Garnavillo',
		'US1840008323' => 'Montrose',
		'US1840006849' => 'Arnolds Park',
		'US1840009107' => 'Smithland',
		'US1840009023' => 'Spirit Lake',
		'US1840010082' => 'Westfield',
	],
	'MA' => [
		'US1840003245' => 'West Falmouth',
		'US1840000414' => 'Peabody',
		'US1840003166' => 'Amherst Center',
		'US1840024166' => 'Siasconset',
		'US1840004765' => 'South Dennis',
		'US1840031195' => 'Methuen Town',
		'US1840004517' => 'Shelburne Falls',
		'US1840003133' => 'West Concord',
		'US1840004680' => 'North Scituate',
		'US1840003203' => 'White Island Shores',
		'US1840000465' => 'Holyoke',
		'US1840004580' => 'North Amherst',
		'US1840000412' => 'Gloucester',
		'US1840000455' => 'Boston',
		'US1840026192' => 'Devens',
		'US1840031242' => 'North Lakeville',
		'US1840004763' => 'Sagamore',
		'US1840002450' => 'Haverhill',
		'US1840003241' => 'Forestdale',
		'US1840053453' => 'West Springfield Town',
		'US1840053605' => 'Southbridge Town',
		'US1840000425' => 'Everett',
		'US1840003124' => 'Woburn',
		'US1840000433' => 'Newton',
		'US1840003123' => 'Somerville',
		'US1840004521' => 'Pinehurst',
		'US1840003247' => 'Woods Hole',
		'US1840003129' => 'Cochituate',
		'US1840004756' => 'Monument Beach',
		'US1840000437' => 'Leominster',
		'US1840073418' => 'Harwich Center',
		'US1840073524' => 'Northwest Harwich',
		'US1840004679' => 'North Plymouth',
		'US1840073525' => 'Norton Center',
		'US1840000435' => 'Fitchburg',
		'US1840004531' => 'South Ashburnham',
		'US1840003202' => 'West Wareham',
		'US1840039566' => 'The Pinehills',
		'US1840003208' => 'Marshfield Hills',
		'US1840004734' => 'Ocean Grove',
		'US1840053563' => 'Winthrop Town',
		'US1840039565' => 'Southfield',
		'US1840003220' => 'Taunton',
		'US1840053526' => 'Amesbury Town',
		'US1840053443' => 'Agawam Town',
		'US1840003237' => 'East Falmouth',
		'US1840000466' => 'Springfield',
		'US1840000451' => 'Northampton',
		'US1840000457' => 'Revere',
		'US1840073515' => 'Millis-Clicquot',
		'US1840004518' => 'South Deerfield',
		'US1840000434' => 'Worcester',
		'US1840003246' => 'West Yarmouth',
		'US1840003221' => 'Bliss Corner',
		'US1840003139' => 'Littleton Common',
		'US1840004757' => 'New Seabury',
		'US1840000427' => 'Marlborough',
		'US1840043425' => 'Hanscom AFB',
		'US1840031249' => 'Popponesset Island',
		'US1840003219' => 'New Bedford',
		'US1840073506' => 'Mansfield Center',
		'US1840031247' => 'Monomoscoy Island',
		'US1840073527' => 'Ocean Bluff-Brant Rock',
		'US1840004735' => 'Raynham Center',
		'US1840003243' => 'West Chatham',
		'US1840073508' => 'Marion Center',
		'US1840031198' => 'Watertown Town',
		'US1840000497' => 'Fall River',
		'US1840000423' => 'North Adams',
		'US1840004761' => 'Pocasset',
		'US1840031251' => 'Seconsett Island',
		'US1840000410' => 'Salem',
		'US1840053458' => 'Easthampton Town',
		'US1840073415' => 'Green Harbor-Cedar Crest',
		'US1840003242' => 'Harwich Port',
		'US1840004532' => 'South Lancaster',
		'US1840053431' => 'Greenfield Town',
		'US1840053497' => 'Barnstable Town',
		'US1840031248' => 'Popponesset',
		'US1840000408' => 'Lawrence',
		'US1840024165' => 'Madaket',
		'US1840003147' => 'East Douglas',
		'US1840004736' => 'Smith Mills',
		'US1840000426' => 'Lowell',
		'US1840004758' => 'North Eastham',
		'US1840000431' => 'Medford',
		'US1840004675' => 'Randolph',
		'US1840000461' => 'Quincy',
		'US1840004581' => 'South Amherst',
		'US1840004759' => 'North Falmouth',
		'US1840004519' => 'Turners Falls',
		'US1840004681' => 'Onset',
		'US1840003142' => 'Baldwinville',
		'US1840003145' => 'Cordaville',
		'US1840003131' => 'Framingham',
		'US1840003199' => 'Bridgewater',
		'US1840000496' => 'Attleboro',
		'US1840004766' => 'South Yarmouth',
		'US1840000430' => 'Malden',
		'US1840003116' => 'Pittsfield',
		'US1840000467' => 'Brockton',
		'US1840003119' => 'Housatonic',
		'US1840073510' => 'Mattapoisett Center',
		'US1840003239' => 'East Sandwich',
		'US1840003238' => 'East Harwich',
		'US1840000411' => 'Beverly',
		'US1840053677' => 'Weymouth Town',
		'US1840031245' => 'Weweantic',
		'US1840003153' => 'Whitinsville',
		'US1840000456' => 'Chelsea',
		'US1840053627' => 'Palmer Town',
		'US1840031244' => 'North Westport',
		'US1840000462' => 'Chicopee',
		'US1840031243' => 'North Seekonk',
		'US1840073517' => 'Monson Center',
		'US1840073388' => 'Acushnet Center',
		'US1840004895' => 'Vineyard Haven',
		'US1840000436' => 'Gardner',
		'US1840000429' => 'Cambridge',
		'US1840053550' => 'Franklin Town',
		'US1840003235' => 'Dennis Port',
		'US1840003232' => 'Buzzards Bay',
		'US1840053545' => 'Braintree Town',
		'US1840031246' => 'Mashpee Neck',
		'US1840003244' => 'West Dennis',
		'US1840003236' => 'East Dennis',
		'US1840073513' => 'Middleborough Center',
		'US1840004678' => 'North Pembroke',
		'US1840031250' => 'Seabrook',
		'US1840000432' => 'Melrose',
		'US1840004767' => 'Teaticket',
		'US1840004684' => 'South Duxbury',
		'US1840000428' => 'Waltham',
		'US1840003248' => 'Yarmouth Port',
		'US1840000413' => 'Newburyport',
		'US1840031229' => 'Wareham Center',
		'US1840003130' => 'East Pepperell',
		'US1840003148' => 'Fiskdale',
		'US1840000409' => 'Lynn',
		'US1840003122' => 'Millers Falls',
		'US1840000463' => 'Westfield',
	],
	'AZ' => [
		'US1840027968' => 'Freedom Acres',
		'US1840019007' => 'Teec Nos Pos',
		'US1840023176' => 'Crozier',
		'US1840019310' => 'Avondale',
		'US1840022617' => 'Alpine',
		'US1840023086' => 'Elfrida',
		'US1840075412' => 'North Fork',
		'US1840017664' => 'Kaibito',
		'US1840042769' => 'Lower Santan Village',
		'US1840019493' => 'St. David',
		'US1840017844' => 'Ash Fork',
		'US1840019268' => 'Poston',
		'US1840075320' => 'Drysdale',
		'US1840074050' => 'Heber-Overgaard',
		'US1840019486' => 'Three Points',
		'US1840019164' => 'Seligman',
		'US1840042772' => 'Sacate Village',
		'US1840027977' => 'Burnside',
		'US1840018972' => 'Tuba City',
		'US1840022866' => 'Roosevelt',
		'US1840021583' => 'Winslow',
		'US1840075284' => 'Crystal Beach',
		'US1840021940' => 'Scottsdale',
		'US1840020566' => 'Mesa',
		'US1840022621' => 'Greer',
		'US1840022865' => 'Kohls Ranch',
		'US1840021943' => 'Tolleson',
		'US1840020629' => 'Maricopa',
		'US1840017945' => 'Canyon Day',
		'US1840023067' => 'Chiawuli Tak',
		'US1840017847' => 'Black Canyon City',
		'US1840023178' => 'Hackberry',
		'US1840037118' => 'New Kingman-Butler',
		'US1840018107' => 'Ajo',
		'US1840021941' => 'Surprise',
		'US1840019312' => 'Sun City West',
		'US1840019744' => 'Dolan Springs',
		'US1840023057' => 'Marana',
		'US1840023076' => 'San Miguel',
		'US1840018973' => 'Tusayan',
		'US1840020334' => 'Holbrook',
		'US1840027934' => 'Seven Mile',
		'US1840042806' => 'Wet Camp Village',
		'US1840021947' => 'Gilbert',
		'US1840022859' => 'Winkelman',
		'US1840019001' => 'Round Rock',
		'US1840021622' => 'St. Johns',
		'US1840075490' => 'Six Shooter Canyon',
		'US1840022977' => 'Aztec',
		'US1840022961' => 'Solomon',
		'US1840027978' => 'First Mesa',
		'US1840038092' => 'Rock House',
		'US1840022616' => 'Springerville',
		'US1840019006' => 'Steamboat',
		'US1840022924' => 'Morristown',
		'US1840022572' => 'Snowflake',
		'US1840018106' => 'Corona de Tucson',
		'US1840018028' => 'Chuichu',
		'US1840023092' => 'Sunizona',
		'US1840075372' => 'Fort Valley',
		'US1840019162' => 'Paulden',
		'US1840021584' => 'Sedona',
		'US1840022922' => 'Kaka',
		'US1840027970' => 'Flowing Springs',
		'US1840036808' => 'Village of Oak Creek',
		'US1840027972' => 'Bear Flat',
		'US1840022618' => 'Concho',
		'US1840019360' => 'Queen Valley',
		'US1840018964' => 'Pinon',
		'US1840075250' => 'Beaver Valley',
		'US1840022629' => 'Vernon',
		'US1840027956' => 'Pinal',
		'US1840021044' => 'Lake Havasu City',
		'US1840075316' => 'Dripping Springs',
		'US1840019487' => 'Vail',
		'US1840022591' => 'Tolani Lake',
		'US1840019267' => 'Parker Strip',
		'US1840022588' => 'Woodruff',
		'US1840019536' => 'Sonoita',
		'US1840023062' => 'Ali Molina',
		'US1840019357' => 'Tacna',
		'US1840018966' => 'Whiteriver',
		'US1840017665' => 'Leupp',
		'US1840019270' => 'Wenden',
		'US1840023079' => 'Topawa',
		'US1840023118' => 'Patagonia',
		'US1840022104' => 'Tombstone',
		'US1840027983' => 'Top-of-the-World',
		'US1840038089' => 'Rincon Valley',
		'US1840023059' => 'Ak Chin',
		'US1840074666' => 'Valencia West',
		'US1840023083' => 'Willow Canyon',
		'US1840023072' => 'Ko Vaya',
		'US1840021771' => 'Dewey-Humboldt',
		'US1840023088' => 'Mescal',
		'US1840027931' => 'Del Muerto',
		'US1840023170' => 'Colorado City',
		'US1840019339' => 'Morenci',
		'US1840022575' => 'Fort Apache',
		'US1840018997' => 'Nazlini',
		'US1840022957' => 'Bylas',
		'US1840019482' => 'Picture Rocks',
		'US1840022928' => 'Wittmann',
		'US1840075566' => 'Wheatfields',
		'US1840019311' => 'Sun City',
		'US1840022101' => 'Tucson',
		'US1840021913' => 'Quartzsite',
		'US1840020628' => 'Eloy',
		'US1840027979' => 'Hotevilla-Bacavi',
		'US1840018965' => 'Second Mesa',
		'US1840001823' => 'Cactus Flats',
		'US1840019002' => 'St. Michaels',
		'US1840020568' => 'Phoenix',
		'US1840023173' => 'Cane Beds',
		'US1840017660' => 'Kykotsmovi Village',
		'US1840017842' => 'Cornville',
		'US1840075310' => 'Doney Park',
		'US1840075296' => 'Deer Creek',
		'US1840018109' => 'Catalina',
		'US1840020564' => 'Goodyear',
		'US1840022917' => 'Youngtown',
		'US1840042961' => 'Fort Mohave',
		'US1840022857' => 'Payson',
		'US1840023081' => 'Wahak Hotrontk',
		'US1840136204' => 'Shongopovi',
		'US1840019262' => 'Pine',
		'US1840022577' => 'Indian Wells',
		'US1840019494' => 'Benson',
		'US1840022950' => 'Franklin',
		'US1840019167' => 'Yarnell',
		'US1840018031' => 'Blackwater',
		'US1840022880' => 'Vicksburg',
		'US1840022581' => 'Low Mountain',
		'US1840023189' => 'Wikieup',
		'US1840023183' => 'Moccasin',
		'US1840022592' => 'Valle',
		'US1840019492' => 'Pirtleville',
		'US1840027881' => 'Whitecone',
		'US1840018111' => 'Green Valley',
		'US1840023119' => 'Beyerville',
		'US1840019537' => 'Tubac',
		'US1840019362' => 'San Manuel',
		'US1840017675' => 'Fort Defiance',
		'US1840022863' => 'Cutter',
		'US1840022868' => 'Tonto Village',
		'US1840019364' => 'Casa Grande',
		'US1840022858' => 'Star Valley',
		'US1840025877' => 'Casa Blanca',
		'US1840022619' => 'Cornfields',
		'US1840075233' => 'Avenue B and C',
		'US1840020562' => 'El Mirage',
		'US1840022983' => 'Kohatk',
		'US1840023078' => 'Summerhaven',
		'US1840018995' => 'Dennehotso',
		'US1840075388' => 'Hard Rock',
		'US1840021948' => 'Guadalupe',
		'US1840021585' => 'Williams',
		'US1840019165' => 'Wilhoit',
		'US1840017663' => 'Kachina Village',
		'US1840022878' => 'La Paz Valley',
		'US1840022925' => 'Theba',
		'US1840017656' => 'Greasewood',
		'US1840019484' => 'Santa Rosa',
		'US1840075398' => 'Icehouse Canyon',
		'US1840019485' => 'Sells',
		'US1840075355' => 'El Prado Estates',
		'US1840017848' => 'Mayer',
		'US1840019161' => 'Spring Valley',
		'US1840027929' => 'Tucson Estates',
		'US1840019263' => 'San Carlos',
		'US1840021944' => 'Queen Creek',
		'US1840022978' => 'Dateland',
		'US1840017849' => 'Lake Montezuma',
		'US1840042786' => 'Sacaton Flats Village',
		'US1840023080' => 'Ventana',
		'US1840022861' => 'Cedar Creek',
		'US1840022954' => 'Pima',
		'US1840023091' => 'San Simon',
		'US1840042796' => 'Stotonic Village',
		'US1840022864' => 'Jakes Corner',
		'US1840022585' => 'Tees Toh',
		'US1840021998' => 'Yuma',
		'US1840018996' => 'McNary',
		'US1840027985' => 'Avra Valley',
		'US1840018029' => 'Ak-Chin Village',
		'US1840017843' => 'Verde Village',
		'US1840020823' => 'Nogales',
		'US1840038121' => 'Sunwest',
		'US1840018173' => 'Elgin',
		'US1840019005' => 'Window Rock',
		'US1840022956' => 'Bryce',
		'US1840018960' => 'Dilkon',
		'US1840023084' => 'Bowie',
		'US1840023065' => 'Arivaca Junction',
		'US1840018030' => 'Arizona City',
		'US1840023182' => 'Meadview',
		'US1840075545' => 'Walnut Creek',
		'US1840022959' => 'Fort Thomas',
		'US1840019313' => 'Sun Lakes',
		'US1840022960' => 'San Jose',
		'US1840075411' => 'Mead Ranch',
		'US1840022958' => 'Central',
		'US1840022587' => 'White Mountain Lake',
		'US1840017676' => 'Ganado',
		'US1840023120' => 'Kino Springs',
		'US1840017654' => 'Cibecue',
		'US1840075311' => 'Donovan Estates',
		'US1840019269' => 'Salome',
		'US1840019489' => 'Tanque Verde',
		'US1840022984' => 'Picacho',
		'US1840018110' => 'Catalina Foothills',
		'US1840022573' => 'Taylor',
		'US1840017840' => 'Congress',
		'US1840019341' => 'Swift Trail Junction',
		'US1840019359' => 'Oracle',
		'US1840018974' => 'Supai',
		'US1840023186' => 'Truxton',
		'US1840137559' => 'Nelson',
		'US1840019366' => 'Stanfield',
		'US1840075397' => 'Hunter Creek',
		'US1840017662' => 'Cameron',
		'US1840021773' => 'Jerome',
		'US1840075227' => 'Alamo Lake',
		'US1840019367' => 'Coolidge',
		'US1840022914' => 'Carefree',
		'US1840022582' => 'Pinedale',
		'US1840022106' => 'Huachuca City',
		'US1840023185' => 'Topock',
		'US1840027982' => 'Mojave Ranch Estates',
		'US1840075510' => 'Wagon Wheel',
		'US1840021996' => 'San Luis',
		'US1840019168' => 'Cottonwood',
		'US1840018339' => 'Golden Valley',
		'US1840022913' => 'Paradise Valley',
		'US1840023090' => 'Palominas',
		'US1840027932' => 'Oak Springs',
		'US1840075337' => 'East Verde Estates',
		'US1840022955' => 'Thatcher',
		'US1840021999' => 'Florence',
		'US1840023066' => 'Charco',
		'US1840022580' => 'Linden',
		'US1840075493' => 'So-Hi',
		'US1840075499' => 'Valle Vista',
		'US1840023075' => 'Rillito',
		'US1840021989' => 'Safford',
		'US1840022867' => 'Rye',
		'US1840017946' => 'Gisela',
		'US1840017944' => 'Claypool',
		'US1840022100' => 'South Tucson',
		'US1840017655' => 'Chilchinbito',
		'US1840017672' => 'Chinle',
		'US1840018999' => 'Rock Point',
		'US1840025878' => 'Santa Cruz',
		'US1840019163' => 'Peeples Valley',
		'US1840022752' => 'Camp Verde',
		'US1840019496' => 'Douglas',
		'US1840023172' => 'Beaver Dam',
		'US1840017674' => 'Many Farms',
		'US1840021911' => 'Hayden',
		'US1840017956' => 'Cibola',
		'US1840022571' => 'Pinetop-Lakeside',
		'US1840075424' => 'Pine Lake',
		'US1840075340' => 'El Capitan',
		'US1840019491' => 'Naco',
		'US1840023187' => 'Valentine',
		'US1840023061' => 'Ali Chukson',
		'US1840022920' => 'Arlington',
		'US1840037122' => 'Oljato-Monument Valley',
		'US1840018998' => 'Red Mesa',
		'US1840027991' => 'Whetstone',
		'US1840136753' => 'Tsaile',
		'US1840019745' => 'Mohave Valley',
		'US1840020436' => 'Prescott',
		'US1840022574' => 'Clay Springs',
		'US1840075441' => 'Pinetop Country Club',
		'US1840075272' => 'Centennial Park',
		'US1840021997' => 'Somerton',
		'US1840018027' => 'Gadsden',
		'US1840017658' => 'Kayenta',
		'US1840022980' => 'Mammoth',
		'US1840022919' => 'Anthem',
		'US1840022862' => 'Christopher Creek',
		'US1840021986' => 'Duncan',
		'US1840042768' => 'Goodyear Village',
		'US1840022879' => 'Utting',
		'US1840075484' => 'Saddlebrooke',
		'US1840075422' => 'Padre Ranchitos',
		'US1840017657' => 'Jeddito',
		'US1840022624' => 'Nutrioso',
		'US1840019307' => 'New River',
		'US1840023063' => 'Anegam',
		'US1840022578' => 'Joseph City',
		'US1840027969' => 'Whispering Pines',
		'US1840019264' => 'Tonto Basin',
		'US1840019309' => 'Chandler',
		'US1840022626' => 'Sanders',
		'US1840022754' => 'Clarkdale',
		'US1840075344' => 'Elephant Head',
		'US1840023179' => 'Katherine',
		'US1840018967' => 'Moenkopi',
		'US1840023077' => 'South Komelik',
		'US1840027971' => 'Oxbow Estates',
		'US1840023184' => 'Oatman',
		'US1840022753' => 'Chino Valley',
		'US1840021939' => 'Buckeye',
		'US1840022918' => 'Aguila',
		'US1840027986' => 'Bluewater',
		'US1840022622' => 'Klagetoh',
		'US1840023190' => 'Yucca',
		'US1840075384' => 'Haigler Creek',
		'US1840075541' => 'Wall Lane',
		'US1840023070' => 'Gu Oidak',
		'US1840019748' => 'Bullhead City',
		'US1840018032' => 'Gold Canyon',
		'US1840027989' => 'Fortuna Foothills',
		'US1840022988' => 'Vaiva Vo',
		'US1840019483' => 'Pisinemo',
		'US1840023087' => 'McNeal',
		'US1840023060' => 'Ali Chuk',
		'US1840017957' => 'Bouse',
		'US1840022000' => 'Kearny',
		'US1840017958' => 'Ehrenberg',
		'US1840018172' => 'Amado',
		'US1840022915' => 'Cave Creek',
		'US1840022630' => 'Wide Ruins',
		'US1840075328' => 'East Globe',
		'US1840020565' => 'Litchfield Park',
		'US1840025866' => 'Gila Crossing',
		'US1840018340' => 'Kaibab',
		'US1840023071' => 'Haivana Nakya',
		'US1840017677' => 'Houck',
		'US1840027004' => 'Rio Rico',
		'US1840022916' => 'Wickenburg',
		'US1840075263' => 'Buckshot',
		'US1840022579' => 'Lake of the Woods',
		'US1840022105' => 'Willcox',
		'US1840023171' => 'Antares',
		'US1840023089' => 'Miracle Valley',
		'US1840019488' => 'Summit',
		'US1840022877' => 'Cienega Springs',
		'US1840023058' => 'Oro Valley',
		'US1840019265' => 'Young',
		'US1840018969' => 'Munds Park',
		'US1840019746' => 'Peach Springs',
		'US1840027990' => 'San Tan Valley',
		'US1840019261' => 'Peridot',
		'US1840023069' => 'Cowlic',
		'US1840075379' => 'Golden Shores',
		'US1840023064' => 'Arivaca',
		'US1840019358' => 'Dudleyville',
		'US1840075406' => 'Lazy Y U',
		'US1840023175' => 'Chloride',
		'US1840027981' => 'Mesquite Creek',
		'US1840022869' => 'Washington Park',
		'US1840027939' => 'Campo Bonito',
		'US1840023074' => 'Nolic',
		'US1840017845' => 'Bagdad',
		'US1840022927' => 'Wintersburg',
		'US1840022923' => 'Komatke',
		'US1840027980' => 'LeChee',
		'US1840021586' => 'Fredonia',
		'US1840017673' => 'Lukachukai',
		'US1840023068' => 'Comobabi',
		'US1840017841' => 'Cordes Lakes',
		'US1840075488' => 'Scenic',
		'US1840022627' => 'Sehili',
		'US1840022976' => 'Wellton',
		'US1840020533' => 'Globe',
		'US1840022102' => 'Sahuarita',
		'US1840023188' => 'White Hills',
		'US1840021942' => 'Tempe',
		'US1840018338' => 'Arizona Village',
		'US1840022951' => 'York',
		'US1840022987' => 'Tat Momoli',
		'US1840019495' => 'Bisbee',
		'US1840021043' => 'Kingman',
		'US1840027987' => 'Desert Hills',
		'US1840020567' => 'Peoria',
		'US1840042802' => 'Upper Santan Village',
		'US1840074025' => 'Grand Canyon Village',
		'US1840019166' => 'Williamson',
		'US1840019308' => 'Rio Verde',
		'US1840021772' => 'Prescott Valley',
		'US1840017659' => 'Keams Canyon',
		'US1840018970' => 'Parks',
		'US1840019003' => 'Sawmill',
		'US1840074659' => 'Tumacacori-Carmen',
		'US1840017661' => 'Bitter Springs',
		'US1840023082' => 'Why',
		'US1840023180' => 'Littlefield',
		'US1840022860' => 'Carrizo',
		'US1840021945' => 'Fountain Hills',
		'US1840022875' => 'Parker',
		'US1840075391' => 'Hondah',
		'US1840022876' => 'Brenda',
		'US1840022583' => 'Seba Dalkai',
		'US1840019000' => 'Rough Rock',
		'US1840022926' => 'Tonopah',
		'US1840075442' => 'Pinion Pines',
		'US1840021582' => 'Show Low',
		'US1840027984' => 'Winslow West',
		'US1840075276' => 'Clacks Canyon',
		'US1840018971' => 'Tonalea',
		'US1840020563' => 'Glendale',
		'US1840023181' => 'McConnico',
		'US1840019365' => 'Apache Junction',
		'US1840019266' => 'Strawberry',
		'US1840075410' => 'Martinez Lake',
		'US1840075383' => 'Grand Canyon West',
		'US1840042801' => 'Sweet Water Village',
		'US1840022981' => 'Superior',
		'US1840022985' => 'Red Rock',
		'US1840022103' => 'Sierra Vista',
		'US1840038035' => 'Rainbow City',
		'US1840074401' => 'Sierra Vista Southeast',
		'US1840019747' => 'Willow Valley',
		'US1840022982' => 'Cactus Forest',
		'US1840018961' => 'East Fork',
		'US1840022623' => 'Lupton',
		'US1840021946' => 'Gila Bend',
		'US1840075560' => 'Wellton Hills',
		'US1840022921' => 'Citrus Park',
		'US1840018108' => 'Casas Adobes',
		'US1840075498' => 'Turkey Creek',
		'US1840018968' => 'Mountainaire',
		'US1840027928' => 'Drexel Heights',
		'US1840073906' => 'Central Heights-Midland City',
		'US1840023073' => 'Maish Vaya',
		'US1840022628' => 'Toyei',
		'US1840019361' => 'Sacaton',
		'US1840022856' => 'Miami',
		'US1840022584' => 'Sun Valley',
		'US1840038041' => 'Rancho Mesa Verde',
		'US1840020336' => 'Page',
		'US1840027975' => 'Pimaco Two',
		'US1840018963' => 'Shonto',
		'US1840137528' => 'Geronimo Estates',
		'US1840022949' => 'Clifton',
		'US1840027988' => 'Flowing Wells',
		'US1840042770' => 'Maricopa Colony',
		'US1840021623' => 'Eagar',
		'US1840027967' => 'Mesa del Caballo',
		'US1840075483' => 'Round Valley',
		'US1840020335' => 'Flagstaff',
		'US1840023085' => 'Dragoon',
		'US1840027973' => 'Copper Hill',
	],
	'ID' => [
		'US1840018682' => 'Albion',
		'US1840024023' => 'Groveland',
		'US1840019771' => 'Ponderay',
		'US1840021297' => 'Soda Springs',
		'US1840018680' => 'Jerome',
		'US1840019772' => 'Priest River',
		'US1840020092' => 'Paris',
		'US1840019869' => 'Onaway',
		'US1840021256' => 'Teton',
		'US1840020070' => 'McCammon',
		'US1840018462' => 'Kendrick',
		'US1840019876' => 'Orofino',
		'US1840024024' => 'Moreland',
		'US1840019805' => 'Fernan Lake Village',
		'US1840019851' => 'Plummer',
		'US1840018642' => 'Eagle',
		'US1840020067' => 'Minidoka',
		'US1840019995' => 'Newdale',
		'US1840018483' => 'Cottonwood',
		'US1840020048' => 'Grand View',
		'US1840018621' => 'Crouch',
		'US1840019809' => 'Hayden Lake',
		'US1840020044' => 'Fairfield',
		'US1840019755' => 'Moyie Springs',
		'US1840019945' => 'Leadore',
		'US1840023828' => 'De Smet',
		'US1840018635' => 'Driggs',
		'US1840021064' => 'Sandpoint',
		'US1840020097' => 'Franklin',
		'US1840019870' => 'Potlatch',
		'US1840018665' => 'Acequia',
		'US1840020043' => 'Parma',
		'US1840019893' => 'Grangeville',
		'US1840021282' => 'Shelley',
		'US1840020016' => 'Glenns Ferry',
		'US1840023865' => 'Elk City',
		'US1840042421' => 'Hidden Springs',
		'US1840020051' => 'Firth',
		'US1840021309' => 'St. Charles',
		'US1840018649' => 'Basalt',
		'US1840020006' => 'Placerville',
		'US1840020014' => 'New Plymouth',
		'US1840020049' => 'Homedale',
		'US1840020085' => 'Eden',
		'US1840020081' => 'Hansen',
		'US1840025254' => 'Parkline',
		'US1840019985' => 'Mackay',
		'US1840019807' => 'Hauser',
		'US1840018645' => 'Iona',
		'US1840018584' => 'Council',
		'US1840074878' => 'State Line',
		'US1840018683' => 'Burley',
		'US1840018663' => 'Dietrich',
		'US1840020028' => 'Hailey',
		'US1840018627' => 'Arco',
		'US1840018646' => 'Irwin',
		'US1840018352' => 'Bonners Ferry',
		'US1840018585' => 'Cascade',
		'US1840019811' => 'Post Falls',
		'US1840020093' => 'Malad City',
		'US1840019773' => 'Kootenai',
		'US1840018679' => 'Buhl',
		'US1840021090' => 'Wallace',
		'US1840021278' => 'Wilder',
		'US1840020089' => 'Oakley',
		'US1840019901' => 'Reubens',
		'US1840020029' => 'Ketchum',
		'US1840020098' => 'Oxford',
		'US1840019892' => 'Ferdinand',
		'US1840019964' => 'McCall',
		'US1840020046' => 'Meridian',
		'US1840018678' => 'Castleford',
		'US1840021100' => 'Worley',
		'US1840019875' => 'Elk River',
		'US1840020013' => 'Fruitland',
		'US1840020042' => 'Notus',
		'US1840019808' => 'Hayden',
		'US1840019894' => 'Riggins',
		'US1840020017' => 'Mountain Home',
		'US1840019800' => 'Pinehurst',
		'US1840018648' => 'Atomic City',
		'US1840020018' => 'Hamer',
		'US1840020047' => 'Kuna',
		'US1840020082' => 'Hollister',
		'US1840019897' => 'Lewiston',
		'US1840020023' => 'Menan',
		'US1840020005' => 'Horseshoe Bend',
		'US1840018643' => 'Ammon',
		'US1840021255' => 'St. Anthony',
		'US1840024095' => 'Bennington',
		'US1840019986' => 'Midvale',
		'US1840018670' => 'Downey',
		'US1840021250' => 'Weiser',
		'US1840021296' => 'Wendell',
		'US1840019868' => 'Moscow',
		'US1840018644' => 'Idaho Falls',
		'US1840019898' => 'Peck',
		'US1840020073' => 'Grace',
		'US1840021171' => 'White Bird',
		'US1840023849' => 'Princeton',
		'US1840020022' => 'Roberts',
		'US1840023789' => 'Rockford Bay',
		'US1840020015' => 'Payette',
		'US1840021170' => 'Stites',
		'US1840020000' => 'Emmett',
		'US1840019810' => 'Huetter',
		'US1840029706' => 'Georgetown',
		'US1840020099' => 'Preston',
		'US1840021295' => 'Shoshone',
		'US1840036681' => 'Arbon Valley',
		'US1840023788' => 'Conkling Park',
		'US1840020088' => 'Malta',
		'US1840021273' => 'Victor',
		'US1840018461' => 'Juliaetta',
		'US1840019768' => 'East Hope',
		'US1840018650' => 'Blackfoot',
		'US1840023990' => 'Banks',
		'US1840021126' => 'St. Maries',
		'US1840019798' => 'Mullan',
		'US1840018628' => 'Butte City',
		'US1840018689' => 'Dayton',
		'US1840018364' => 'Dover',
		'US1840019996' => 'Parker',
		'US1840020064' => 'Hagerman',
		'US1840020050' => 'Marsing',
		'US1840019902' => 'Nezperce',
		'US1840018664' => 'Bliss',
		'US1840020041' => 'Nampa',
		'US1840019769' => 'Hope',
		'US1840024026' => 'Rockford',
		'US1840020065' => 'Heyburn',
		'US1840020086' => 'Hazelton',
		'US1840021281' => 'Ucon',
		'US1840018402' => 'Coeur dAlene',
		'US1840019770' => 'Oldtown',
		'US1840021249' => 'Stanley',
		'US1840018647' => 'Aberdeen',
		'US1840023760' => 'Blanchard',
		'US1840019812' => 'Rathdrum',
		'US1840027142' => 'Boise',
		'US1840020037' => 'Rexburg',
		'US1840074437' => 'Mountain Home AFB',
		'US1840018600' => 'Clayton',
		'US1840021089' => 'Smelterville',
		'US1840020024' => 'Mud Lake',
		'US1840018641' => 'Caldwell',
		'US1840023991' => 'Garden Valley',
		'US1840023992' => 'Lowman',
		'US1840018497' => 'Kamiah',
		'US1840020038' => 'Greenleaf',
		'US1840018667' => 'Chubbuck',
		'US1840020063' => 'Gooding',
		'US1840020062' => 'Richfield',
		'US1840020084' => 'Kimberly',
		'US1840018460' => 'Bovill',
		'US1840020069' => 'Rockland',
		'US1840018401' => 'Athol',
		'US1840021098' => 'Spirit Lake',
		'US1840019984' => 'Lost River',
		'US1840019877' => 'Pierce',
		'US1840013376' => 'Pocatello',
		'US1840020045' => 'Garden City',
		'US1840021148' => 'Troy',
		'US1840018586' => 'Donnelly',
		'US1840023869' => 'Sweetwater',
		'US1840018498' => 'Craigmont',
		'US1840021277' => 'Sugar City',
		'US1840019899' => 'Lapwai',
		'US1840018363' => 'Clark Fork',
		'US1840020020' => 'Rigby',
		'US1840020019' => 'Lewisville',
		'US1840018669' => 'Inkom',
		'US1840019895' => 'Kooskia',
		'US1840021301' => 'Twin Falls',
		'US1840021259' => 'Spencer',
		'US1840020083' => 'Murtaugh',
		'US1840019867' => 'Genesee',
		'US1840018671' => 'Bancroft',
		'US1840019806' => 'Harrison',
		'US1840020068' => 'Paul',
		'US1840021091' => 'Wardner',
		'US1840018463' => 'Deary',
		'US1840021179' => 'Winchester',
		'US1840024025' => 'Riverside',
		'US1840020072' => 'Lava Hot Springs',
		'US1840021158' => 'Weippe',
		'US1840021127' => 'Tensed',
		'US1840018392' => 'Kellogg',
		'US1840024022' => 'Lincoln',
		'US1840021271' => 'Sun Valley',
		'US1840018485' => 'Culdesac',
		'US1840025319' => 'Yellow Pine',
		'US1840021279' => 'Star',
		'US1840018608' => 'Island Park',
		'US1840021213' => 'Salmon',
		'US1840021280' => 'Swan Valley',
		'US1840021272' => 'Tetonia',
		'US1840018601' => 'Cambridge',
		'US1840018614' => 'Dubois',
		'US1840018688' => 'Clifton',
		'US1840020091' => 'Montpelier',
		'US1840018634' => 'Carey',
		'US1840020040' => 'Middleton',
		'US1840018403' => 'Dalton Gardens',
		'US1840018687' => 'Bloomington',
		'US1840020080' => 'Filer',
		'US1840018668' => 'Arimo',
		'US1840024021' => 'Murphy',
		'US1840018609' => 'Drummond',
		'US1840042429' => 'Robie Creek',
		'US1840018684' => 'Declo',
		'US1840020021' => 'Ririe',
		'US1840019963' => 'New Meadows',
		'US1840020011' => 'Moore',
		'US1840018599' => 'Challis',
		'US1840021316' => 'Weston',
		'US1840020066' => 'Rupert',
		'US1840029704' => 'Fort Hall',
		'US1840018666' => 'American Falls',
		'US1840023912' => 'Smiths Ferry',
		'US1840018633' => 'Bellevue',
		'US1840019799' => 'Osburn',
		'US1840018620' => 'Idaho City',
		'US1840020039' => 'Melba',
		'US1840018607' => 'Ashton',
		'US1840021257' => 'Warm River',
	],
	'CT' => [
		'US1840003278' => 'North Grosvenor Dale',
		'US1840028595' => 'Plantsville',
		'US1840034967' => 'Simsbury Center',
		'US1840004839' => 'Norwalk',
		'US1840028597' => 'Coventry Lake',
		'US1840028604' => 'Terramuggus',
		'US1840004836' => 'Bridgeport',
		'US1840004841' => 'Stamford',
		'US1840000504' => 'Hazardville',
		'US1840004827' => 'New London',
		'US1840073290' => 'Deep River Center',
		'US1840004769' => 'Litchfield',
		'US1840003260' => 'Oakville',
		'US1840004847' => 'Derby',
		'US1840003354' => 'Poquonock Bridge',
		'US1840073295' => 'Essex Village',
		'US1840026284' => 'Old Greenwich',
		'US1840028601' => 'South Coventry',
		'US1840004848' => 'Meriden',
		'US1840043233' => 'Wilton Center',
		'US1840003268' => 'Weatogue',
		'US1840004840' => 'Shelton',
		'US1840003283' => 'Wauregan',
		'US1840073557' => 'Branford Center',
		'US1840003265' => 'North Granby',
		'US1840004777' => 'Canton Valley',
		'US1840000583' => 'Higganum',
		'US1840073556' => 'Bethlehem Village',
		'US1840026270' => 'Baltic',
		'US1840028596' => 'Lake Pocotopaug',
		'US1840004826' => 'Jewett City',
		'US1840003273' => 'Mansfield Center',
		'US1840073562' => 'Cheshire Village',
		'US1840028603' => 'Suffield Depot',
		'US1840003274' => 'Rockville',
		'US1840003270' => 'West Simsbury',
		'US1840003348' => 'Long Hill',
		'US1840000505' => 'Kensington',
		'US1840028600' => 'Sherwood Manor',
		'US1840004828' => 'Norwich',
		'US1840004853' => 'Woodmont',
		'US1840004770' => 'Torrington',
		'US1840004824' => 'Groton',
		'US1840028599' => 'Salmon Brook',
		'US1840043322' => 'Mashantucket',
		'US1840026285' => 'Pemberwick',
		'US1840000575' => 'Georgetown',
		'US1840004846' => 'Ansonia',
		'US1840034972' => 'Woodbury Center',
		'US1840003267' => 'Thompsonville',
		'US1840004844' => 'Middletown',
		'US1840004776' => 'Broad Brook',
		'US1840004849' => 'Naugatuck',
		'US1840073296' => 'Guilford Center',
		'US1840026279' => 'Cannondale',
		'US1840003284' => 'Willimantic',
		'US1840026280' => 'Byram',
		'US1840004773' => 'Hartford',
		'US1840073563' => 'Chester Center',
		'US1840028602' => 'Southwood Acres',
		'US1840003353' => 'Pawcatuck',
		'US1840003282' => 'South Woodstock',
		'US1840073306' => 'Plainfield Village',
		'US1840004775' => 'Blue Hills',
		'US1840003350' => 'Niantic',
		'US1840003276' => 'Storrs',
		'US1840004772' => 'Bristol',
		'US1840073303' => 'Old Saybrook Center',
		'US1840004774' => 'New Britain',
		'US1840003277' => 'Moosup',
		'US1840073288' => 'Conning Towers Nautilus Park',
		'US1840004851' => 'Waterbury',
		'US1840073297' => 'Madison Center',
		'US1840000508' => 'East Brooklyn',
		'US1840003349' => 'Mystic',
		'US1840000506' => 'Crystal Lake',
		'US1840003261' => 'Terryville',
		'US1840026222' => 'Lakeville',
		'US1840004829' => 'Stonington',
		'US1840003369' => 'Moodus',
		'US1840026282' => 'Glenville',
		'US1840026287' => 'Southport',
		'US1840003371' => 'Saybrook Manor',
		'US1840004825' => 'Groton Long Point',
		'US1840073313' => 'Westbrook Center',
		'US1840073312' => 'Wallingford Center',
		'US1840026281' => 'Cos Cob',
		'US1840026271' => 'Gales Ferry',
		'US1840026286' => 'Riverside',
		'US1840003266' => 'Tariffville',
		'US1840000503' => 'Glastonbury Center',
		'US1840003352' => 'Old Mystic',
		'US1840004768' => 'Bantam',
		'US1840004850' => 'New Haven',
		'US1840003259' => 'New Preston',
		'US1840003351' => 'Noank',
		'US1840003280' => 'Quinebaug',
		'US1840003275' => 'Stafford Springs',
		'US1840073298' => 'New Hartford Center',
		'US1840003262' => 'Winsted',
		'US1840004852' => 'West Haven',
		'US1840073305' => 'Oxoboxo River',
		'US1840004837' => 'Danbury',
		'US1840004838' => 'Newtown',
		'US1840004781' => 'Danielson',
		'US1840028598' => 'Heritage Village',
		'US1840004779' => 'Collinsville',
		'US1840026221' => 'Falls Village',
		'US1840004843' => 'Fenwick',
		'US1840003281' => 'South Windham',
		'US1840028605' => 'Milford city ',
		'US1840073302' => 'Northwest Harwinton',
	],
	'ME' => [
		'US1840002672' => 'Sanford',
		'US1840000329' => 'Westbrook',
		'US1840024002' => 'Cousins Island',
		'US1840002189' => 'Lisbon Falls',
		'US1840000303' => 'Gardiner',
		'US1840024008' => 'Steep Falls',
		'US1840000320' => 'Lewiston',
		'US1840000305' => 'Waterville',
		'US1840000322' => 'Rockland',
		'US1840000239' => 'Brewer',
		'US1840002665' => 'Cape Neddick',
		'US1840000304' => 'Hallowell',
		'US1840000300' => 'Belfast',
		'US1840000332' => 'Bath',
		'US1840002677' => 'York Harbor',
		'US1840001583' => 'South Paris',
		'US1840000271' => 'Calais',
		'US1840031522' => 'Little Falls',
		'US1840000272' => 'Eastport',
		'US1840002673' => 'South Eliot',
		'US1840002551' => 'Falmouth Foreside',
		'US1840000240' => 'Old Town',
		'US1840000328' => 'South Portland',
		'US1840002550' => 'Cumberland Center',
		'US1840002669' => 'Kittery Point',
		'US1840000145' => 'Caribou',
		'US1840000238' => 'Bangor',
		'US1840000302' => 'Augusta',
		'US1840073325' => 'Brunswick Station',
		'US1840024005' => 'Littlejohn Island',
		'US1840002676' => 'West Kennebunk',
		'US1840000319' => 'Auburn',
		'US1840000327' => 'Portland',
		'US1840000146' => 'Presque Isle',
		'US1840000342' => 'Biddeford',
		'US1840002553' => 'North Windham',
		'US1840000343' => 'Saco',
		'US1840002061' => 'Chisholm',
		'US1840002670' => 'Lake Arrowhead',
		'US1840000281' => 'Ellsworth',
		'US1840026140' => 'South Windham',
	],
	'MD' => [
		'US1840024395' => 'Dargan',
		'US1840005600' => 'Mount Aetna',
		'US1840005599' => 'Chewsville',
		'US1840005919' => 'Jessup',
		'US1840005843' => 'Garrett Park',
		'US1840024443' => 'Gorman',
		'US1840024647' => 'Cobb Island',
		'US1840006260' => 'Snow Hill',
		'US1840005921' => 'Linthicum',
		'US1840031498' => 'South Laurel',
		'US1840006258' => 'Berlin',
		'US1840024436' => 'Spring Gap',
		'US1840005902' => 'Queenstown',
		'US1840005609' => 'Funkstown',
		'US1840005700' => 'Taneytown',
		'US1840024394' => 'Charlton',
		'US1840024528' => 'Edgewater',
		'US1840005977' => 'Mount Rainier',
		'US1840005937' => 'Hillsboro',
		'US1840006257' => 'Pocomoke City',
		'US1840024442' => 'Finzel',
		'US1840005945' => 'Beltsville',
		'US1840024667' => 'Nanticoke',
		'US1840006223' => 'Sharptown',
		'US1840005627' => 'Westernport',
		'US1840024549' => 'Westphalia',
		'US1840005832' => 'Damascus',
		'US1840005973' => 'Glenarden',
		'US1840005849' => 'Rockville',
		'US1840005623' => 'Barton',
		'US1840005828' => 'Cabin John',
		'US1840031313' => 'Brookmont',
		'US1840031485' => 'Lake Arbor',
		'US1840005796' => 'Galena',
		'US1840024455' => 'Urbana',
		'US1840026687' => 'Lanham',
		'US1840005965' => 'Fairmount Heights',
		'US1840024441' => 'Crellin',
		'US1840005642' => 'Rising Sun',
		'US1840035183' => 'Frenchtown-Rumbly',
		'US1840024420' => 'Danville',
		'US1840026722' => 'Calvert Beach',
		'US1840031333' => 'Detmold',
		'US1840005953' => 'Fort Washington',
		'US1840006255' => 'West Ocean City',
		'US1840005616' => 'Keedysville',
		'US1840005989' => 'Riverdale Park',
		'US1840024642' => 'Fishing Creek',
		'US1840005962' => 'Marlton',
		'US1840005707' => 'Braddock Heights',
		'US1840026623' => 'Lutherville',
		'US1840005688' => 'Randallstown',
		'US1840024539' => 'Aquasco',
		'US1840006147' => 'Huntingtown',
		'US1840024548' => 'Silver Hill',
		'US1840005964' => 'Edmonston',
		'US1840005608' => 'Maugansville',
		'US1840005621' => 'Cumberland',
		'US1840024414' => 'Barrelville',
		'US1840024406' => 'Pecktonville',
		'US1840005798' => 'Chestertown',
		'US1840005674' => 'Edgemere',
		'US1840006168' => 'Secretary',
		'US1840005687' => 'Pikesville',
		'US1840006167' => 'Church Creek',
		'US1840005944' => 'Adelphi',
		'US1840024385' => 'Antietam',
		'US1840005955' => 'Glenn Dale',
		'US1840005630' => 'Accident',
		'US1840006253' => 'Girdletree',
		'US1840005934' => 'Goldsboro',
		'US1840005693' => 'Kingsville',
		'US1840026745' => 'St. George Island',
		'US1840005800' => 'Rock Hall',
		'US1840026735' => 'Bryantown',
		'US1840005622' => 'Frostburg',
		'US1840005968' => 'West Laurel',
		'US1840024428' => 'Midlothian',
		'US1840024439' => 'Zihlman',
		'US1840026617' => 'Mount Briar',
		'US1840024641' => 'Elliott',
		'US1840006144' => 'Dunkirk',
		'US1840005895' => 'Grasonville',
		'US1840026688' => 'Oxon Hill',
		'US1840005620' => 'La Vale',
		'US1840005948' => 'Chillum',
		'US1840003828' => 'Upper Marlboro',
		'US1840031386' => 'Ocean',
		'US1840005909' => 'Crofton',
		'US1840005932' => 'Denton',
		'US1840005912' => 'Odenton',
		'US1840024474' => 'Edesville',
		'US1840031472' => 'Pleasant Hills',
		'US1840005923' => 'Mayo',
		'US1840005946' => 'Brandywine',
		'US1840026672' => 'Galesville',
		'US1840073671' => 'Leisure World',
		'US1840006224' => 'Willards',
		'US1840005699' => 'Hampstead',
		'US1840005974' => 'Greenbelt',
		'US1840024407' => 'Pinesburg',
		'US1840005690' => 'Rosedale',
		'US1840005901' => 'Queen Anne',
		'US1840006219' => 'Salisbury',
		'US1840024440' => 'Bloomington',
		'US1840024535' => 'West Denton',
		'US1840005975' => 'Hyattsville',
		'US1840005689' => 'Reisterstown',
		'US1840031323' => 'Chevy Chase',
		'US1840005697' => 'Woodlawn',
		'US1840024434' => 'Rawlings',
		'US1840024404' => 'Mapleville',
		'US1840005922' => 'Maryland City',
		'US1840006091' => 'St. Michaels',
		'US1840024425' => 'Klondike',
		'US1840026744' => 'Piney Point',
		'US1840073583' => 'Aberdeen Proving Ground',
		'US1840026627' => 'Linganore',
		'US1840006092' => 'Trappe',
		'US1840006220' => 'Delmar',
		'US1840006251' => 'Newark',
		'US1840005632' => 'Loch Lynn Heights',
		'US1840024403' => 'Jugtown',
		'US1840005846' => 'Travilah',
		'US1840005801' => 'Elkridge',
		'US1840073739' => 'Wilson-Conococheague',
		'US1840005824' => 'Forest Glen',
		'US1840005667' => 'Havre de Grace',
		'US1840005715' => 'New Market',
		'US1840026619' => 'Eckhart Mines',
		'US1840005698' => 'Eldersburg',
		'US1840005984' => 'Cheverly',
		'US1840006089' => 'Easton',
		'US1840005712' => 'Rosemont',
		'US1840039492' => 'Marlboro Village',
		'US1840031340' => 'Franklin',
		'US1840005898' => 'Barclay',
		'US1840005704' => 'New Windsor',
		'US1840006254' => 'Stockton',
		'US1840039512' => 'Melwood',
		'US1840005940' => 'Ridgely',
		'US1840024480' => 'Fulton',
		'US1840006222' => 'Pittsville',
		'US1840031500' => 'Peppermill Village',
		'US1840039458' => 'Fairwood',
		'US1840005831' => 'Colesville',
		'US1840005679' => 'Catonsville',
		'US1840005664' => 'Jarrettsville',
		'US1840005949' => 'Clinton',
		'US1840005852' => 'Brookeville',
		'US1840073753' => 'Port Tobacco Village',
		'US1840031492' => 'Mays Chapel',
		'US1840031490' => 'Ballenger Creek',
		'US1840031497' => 'South Kensington',
		'US1840005629' => 'Grantsville',
		'US1840005610' => 'Hancock',
		'US1840024418' => 'Clarysville',
		'US1840024390' => 'Big Spring',
		'US1840005978' => 'New Carrollton',
		'US1840024449' => 'Bartonsville',
		'US1840005900' => 'Church Hill',
		'US1840006228' => 'California',
		'US1840006232' => 'Leonardtown',
		'US1840005985' => 'Colmar Manor',
		'US1840005716' => 'Thurmont',
		'US1840026746' => 'Tall Timbers',
		'US1840024388' => 'Beaver Creek',
		'US1840005678' => 'Carney',
		'US1840006166' => 'Brookview',
		'US1840005802' => 'Ellicott City',
		'US1840024411' => 'Sandy Hook',
		'US1840026723' => 'Chesapeake Ranch Estates',
		'US1840024429' => 'Moscow',
		'US1840005838' => 'Redland',
		'US1840005718' => 'Woodsboro',
		'US1840005939' => 'Preston',
		'US1840024664' => 'Allen',
		'US1840005987' => 'Landover Hills',
		'US1840024451' => 'Jefferson',
		'US1840005911' => 'Deale',
		'US1840024648' => 'Rock Point',
		'US1840024413' => 'Yarrowsburg',
		'US1840005844' => 'Glen Echo',
		'US1840005854' => 'Chevy Chase Village',
		'US1840024410' => 'Ringgold',
		'US1840026730' => 'Madison',
		'US1840024536' => 'Williston',
		'US1840005967' => 'Temple Hills',
		'US1840005725' => 'Kitzmiller',
		'US1840031338' => 'Fairview',
		'US1840005676' => 'Arbutus',
		'US1840006172' => 'Bryans Road',
		'US1840005695' => 'Towson',
		'US1840026621' => 'Darlington',
		'US1840005833' => 'Darnestown',
		'US1840005708' => 'Emmitsburg',
		'US1840024419' => 'Corriganville',
		'US1840024399' => 'Fairplay',
		'US1840024540' => 'Baden',
		'US1840005680' => 'Cockeysville',
		'US1840005972' => 'District Heights',
		'US1840005917' => 'Glen Burnie',
		'US1840043284' => 'Eakles Mill',
		'US1840024444' => 'Hutton',
		'US1840005916' => 'Riviera Beach',
		'US1840024542' => 'Cedarville',
		'US1840005956' => 'Landover',
		'US1840005927' => 'Shady Side',
		'US1840005979' => 'Seat Pleasant',
		'US1840024668' => 'Nanticoke Acres',
		'US1840005907' => 'Arnold',
		'US1840026731' => 'Taylors Island',
		'US1840024489' => 'Four Corners',
		'US1840005981' => 'Bladensburg',
		'US1840005969' => 'Woodmore',
		'US1840005928' => 'Annapolis',
		'US1840024438' => 'Woodland',
		'US1840005941' => 'Templeville',
		'US1840024402' => 'Indian Springs',
		'US1840005925' => 'Severn',
		'US1840024412' => 'Tilghmanton',
		'US1840006174' => 'Hughesville',
		'US1840005970' => 'Bowie',
		'US1840031470' => 'Martins Additions',
		'US1840026736' => 'Pomfret',
		'US1840005914' => 'Pasadena',
		'US1840024671' => 'Quantico',
		'US1840005906' => 'Ferndale',
		'US1840024477' => 'Kennedyville',
		'US1840024400' => 'Gapland',
		'US1840073591' => 'Bel Air North',
		'US1840031494' => 'North Bethesda',
		'US1840024391' => 'Breathedsville',
		'US1840005841' => 'Hillandale',
		'US1840014982' => 'Prince Frederick',
		'US1840024445' => 'Jennings',
		'US1840024541' => 'Brock Hall',
		'US1840024405' => 'Mercersville',
		'US1840024417' => 'Carlos',
		'US1840006165' => 'Cambridge',
		'US1840005675' => 'Essex',
		'US1840024450' => 'Buckeystown',
		'US1840005859' => 'Somerset',
		'US1840024646' => 'Benedict',
		'US1840006230' => 'Golden Beach',
		'US1840073261' => 'Highfield-Cascade',
		'US1840031390' => 'Pleasant Grove',
		'US1840024397' => 'Edgemont',
		'US1840031295' => 'Wheaton',
		'US1840031284' => 'Middleburg',
		'US1840005682' => 'Middle River',
		'US1840138164' => 'Queensland',
		'US1840005942' => 'Forestville',
		'US1840024446' => 'Swanton',
		'US1840024534' => 'Choptank',
		'US1840039519' => 'Shaft',
		'US1840005686' => 'Perry Hall',
		'US1840005960' => 'Largo',
		'US1840031477' => 'Bowmans Addition',
		'US1840026724' => 'Drum Point',
		'US1840005842' => 'Kemp Mill',
		'US1840005959' => 'Langley Park',
		'US1840005636' => 'Cecilton',
		'US1840073592' => 'Bel Air South',
		'US1840024491' => 'Layhill',
		'US1840024387' => 'Bakersville',
		'US1840024669' => 'Parsonsburg',
		'US1840005971' => 'College Park',
		'US1840005910' => 'Crownsville',
		'US1840006145' => 'Owings',
		'US1840005709' => 'Brunswick',
		'US1840001593' => 'Fairland',
		'US1840024490' => 'Glenmont',
		'US1840039564' => 'Trego-Rohrersville Station',
		'US1840006276' => 'Eden',
		'US1840026725' => 'Long Beach',
		'US1840005936' => 'Henderson',
		'US1840005851' => 'Barnesville',
		'US1840031486' => 'Smith Island',
		'US1840005847' => 'White Oak',
		'US1840024392' => 'Brownsville',
		'US1840031267' => 'Cloverly',
		'US1840006149' => 'Solomons',
		'US1840005717' => 'Walkersville',
		'US1840073587' => 'Andrews AFB',
		'US1840006259' => 'Ocean City',
		'US1840003827' => 'University Park',
		'US1840006090' => 'Oxford',
		'US1840005696' => 'White Marsh',
		'US1840026671' => 'Friendship',
		'US1840006218' => 'Fruitland',
		'US1840026624' => 'Timonium',
		'US1840005856' => 'Kensington',
		'US1840024670' => 'Powellville',
		'US1840006229' => 'Charlotte Hall',
		'US1840005705' => 'Sykesville',
		'US1840005607' => 'Leitersburg',
		'US1840006217' => 'Hebron',
		'US1840005606' => 'Halfway',
		'US1840005637' => 'Charlestown',
		'US1840005691' => 'Garrison',
		'US1840005908' => 'Cape St. Claire',
		'US1840005926' => 'Severna Park',
		'US1840024422' => 'Ellerslie',
		'US1840006176' => 'Indian Head',
		'US1840024396' => 'Downsville',
		'US1840005625' => 'Luke',
		'US1840026721' => 'Broomes Island',
		'US1840024478' => 'Worton',
		'US1840024545' => 'Glassmanor',
		'US1840005666' => 'Aberdeen',
		'US1840005611' => 'St. James',
		'US1840006278' => 'Crisfield',
		'US1840005947' => 'Camp Springs',
		'US1840039517' => 'National Harbor',
		'US1840005618' => 'Smithsburg',
		'US1840006163' => 'Galestown',
		'US1840031443' => 'Algonquin',
		'US1840031484' => 'Kent Narrows',
		'US1840001592' => 'Baltimore',
		'US1840031493' => 'Milford Mill',
		'US1840031480' => 'Robinwood',
		'US1840031481' => 'Greensburg',
		'US1840006164' => 'Hurlock',
		'US1840005825' => 'Aspen Hill',
		'US1840005706' => 'Union Bridge',
		'US1840026753' => 'Bishopville',
		'US1840005635' => 'Elkton',
		'US1840024673' => 'Waterview',
		'US1840026620' => 'Cresaptown',
		'US1840031344' => 'Grahamtown',
		'US1840005639' => 'North East',
		'US1840005619' => 'Williamsport',
		'US1840031482' => 'East Riverdale',
		'US1840005603' => 'Rohrersville',
		'US1840073595' => 'Bensville',
		'US1840005957' => 'Hillcrest Heights',
		'US1840005826' => 'Bethesda',
		'US1840006161' => 'East New Market',
		'US1840005986' => 'Cottage City',
		'US1840001668' => 'Fairmount',
		'US1840039445' => 'Annapolis Neck',
		'US1840005933' => 'Federalsburg',
		'US1840005836' => 'Olney',
		'US1840005943' => 'Accokeek',
		'US1840006152' => 'North Beach',
		'US1840005684' => 'Owings Mills',
		'US1840026664' => 'Savage',
		'US1840005980' => 'Berwyn Heights',
		'US1840005638' => 'Chesapeake City',
		'US1840005711' => 'Burkittsville',
		'US1840005896' => 'Kingstown',
		'US1840005662' => 'Fallston',
		'US1840031474' => 'Arden on the Severn',
		'US1840005624' => 'Lonaconing',
		'US1840003842' => 'Vienna',
		'US1840005685' => 'Parkville',
		'US1840031475' => 'Spring Ridge',
		'US1840005966' => 'Forest Heights',
		'US1840024437' => 'Vale Summit',
		'US1840005601' => 'Mount Lena',
		'US1840031445' => 'Calverton',
		'US1840005703' => 'Mount Airy',
		'US1840005894' => 'Chester',
		'US1840005714' => 'Myersville',
		'US1840005613' => 'Hagerstown',
		'US1840005692' => 'Hampton',
		'US1840005848' => 'Gaithersburg',
		'US1840073677' => 'Friendship Heights Village',
		'US1840005954' => 'Friendly',
		'US1840005903' => 'Sudlersville',
		'US1840024672' => 'Tyaskin',
		'US1840031312' => 'Brooklyn Park',
		'US1840024401' => 'Garretts Mill',
		'US1840005897' => 'Stevensville',
		'US1840005665' => 'Joppatowne',
		'US1840024543' => 'Croom',
		'US1840005963' => 'Eagle Harbor',
		'US1840006088' => 'Cordova',
		'US1840005983' => 'Capitol Heights',
		'US1840006221' => 'Mardela Springs',
		'US1840005915' => 'Riva',
		'US1840024674' => 'Whitehaven',
		'US1840006279' => 'Princess Anne',
		'US1840006231' => 'Lexington Park',
		'US1840024488' => 'Derwood',
		'US1840005845' => 'Silver Spring',
		'US1840024408' => 'Pondsville',
		'US1840031499' => 'Walker Mill',
		'US1840031487' => 'Springdale',
		'US1840005661' => 'Edgewood',
		'US1840073633' => 'Naval Academy',
		'US1840005958' => 'Kettering',
		'US1840031382' => 'North Kensington',
		'US1840026622' => 'Pylesville',
		'US1840073650' => 'Paramount-Long Meadow',
		'US1840039491' => 'Konterra',
		'US1840024448' => 'Adamstown',
		'US1840024424' => 'Gilmore',
		'US1840005988' => 'Morningside',
		'US1840005683' => 'Overlea',
		'US1840005631' => 'Deer Park',
		'US1840005853' => 'Chevy Chase View',
		'US1840005858' => 'Poolesville',
		'US1840005918' => 'Herald Harbor',
		'US1840005628' => 'Friendsville',
		'US1840073588' => 'Ashton-Sandy Spring',
		'US1840006277' => 'Mount Vernon',
		'US1840005938' => 'Marydel',
		'US1840031495' => 'North Laurel',
		'US1840005837' => 'Potomac',
		'US1840005855' => 'North Chevy Chase',
		'US1840073581' => 'Fort Meade',
		'US1840006274' => 'Dames Quarter',
		'US1840005961' => 'Marlow Heights',
		'US1840039472' => 'Kemps Mill',
		'US1840005641' => 'Port Deposit',
		'US1840024529' => 'Gambrills',
		'US1840005640' => 'Perryville',
		'US1840024476' => 'Georgetown',
		'US1840006177' => 'La Plata',
		'US1840024666' => 'Jesterville',
		'US1840026626' => 'Sabillasville',
		'US1840031488' => 'Tilghman Island',
		'US1840005860' => 'Washington Grove',
		'US1840005617' => 'Sharpsburg',
		'US1840005840' => 'Germantown',
		'US1840005710' => 'Frederick',
		'US1840005951' => 'Mitchellville',
		'US1840006175' => 'Waldorf',
		'US1840024433' => 'Potomac Park',
		'US1840005702' => 'Manchester',
		'US1840024415' => 'Bier',
		'US1840031489' => 'West Pocomoke',
		'US1840005950' => 'Coral Hills',
		'US1840031398' => 'Rossville',
		'US1840005952' => 'Rosaryville',
		'US1840024547' => 'Seabrook',
		'US1840024409' => 'Reid',
		'US1840024447' => 'Baltimore Highlands',
		'US1840024398' => 'Ernstville',
		'US1840031379' => 'National',
		'US1840024432' => 'Oldtown',
		'US1840006150' => 'St. Leonard',
		'US1840005615' => 'Clear Spring',
		'US1840005713' => 'Middletown',
		'US1840005982' => 'Brentwood',
		'US1840024473' => 'Butlertown',
		'US1840005834' => 'Montgomery Village',
		'US1840024386' => 'Bagtown',
		'US1840024481' => 'Highland',
		'US1840005850' => 'Takoma Park',
		'US1840031456' => 'North Brentwood',
		'US1840031466' => 'Suitland',
		'US1840005668' => 'Bel Air',
		'US1840005827' => 'Burtonsville',
		'US1840005634' => 'Oakland',
		'US1840005633' => 'Mountain Lake Park',
		'US1840006256' => 'Whaleyville',
		'US1840005626' => 'Midland',
		'US1840024423' => 'Flintstone',
		'US1840024454' => 'Point of Rocks',
		'US1840024416' => 'Bowling Green',
		'US1840024453' => 'Monrovia',
		'US1840006148' => 'Lusby',
		'US1840031483' => 'Marlboro Meadows',
		'US1840031469' => 'Chevy Chase Section Three',
		'US1840006275' => 'Deal Island',
		'US1840006151' => 'Chesapeake Beach',
		'US1840005803' => 'Columbia',
		'US1840024426' => 'Little Orleans',
		'US1840073582' => 'Fort Ritchie',
		'US1840031471' => 'Chevy Chase Section Five',
		'US1840024483' => 'Scaggsville',
		'US1840005976' => 'Laurel',
		'US1840005857' => 'Laytonsville',
		'US1840006162' => 'Eldorado',
		'US1840024475' => 'Fairlee',
		'US1840024452' => 'Libertytown',
		'US1840031473' => 'Riverside',
		'US1840005899' => 'Centreville',
		'US1840024393' => 'Cearfoss',
		'US1840005614' => 'Boonsboro',
		'US1840005797' => 'Betterton',
		'US1840005830' => 'Clarksburg',
		'US1840005681' => 'Dundalk',
		'US1840024430' => 'Mount Savage',
		'US1840026625' => 'Lansdowne',
		'US1840005694' => 'Lochearn',
		'US1840006273' => 'Chance',
		'US1840014944' => 'Highland Beach',
		'US1840005935' => 'Greensboro',
		'US1840005799' => 'Millington',
		'US1840005663' => 'Perryman',
		'US1840005835' => 'North Potomac',
		'US1840024482' => 'Ilchester',
		'US1840005677' => 'Bowleys Quarters',
		'US1840006252' => 'Ocean Pines',
		'US1840024492' => 'Spencerville',
		'US1840026743' => 'Mechanicsville',
		'US1840005604' => 'San Mar',
		'US1840005920' => 'Lake Shore',
		'US1840024421' => 'Dawson',
		'US1840024427' => 'McCoole',
		'US1840005701' => 'Westminster',
		'US1840005598' => 'Cavetown',
		'US1840006173' => 'Potomac Heights',
		'US1840073674' => 'Fountainhead-Orchard Hills',
		'US1840024389' => 'Big Pool',
		'US1840024431' => 'Nikep',
		'US1840024665' => 'Bivalve',
		'US1840039531' => 'Summerfield',
		'US1840031441' => 'Tolchester',
		'US1840005913' => 'Parole',
	],
	'OK' => [
		'US1840022776' => 'Wister',
		'US1840022831' => 'Caney',
		'US1840021719' => 'Council Hill',
		'US1840034582' => 'Remy',
		'US1840021653' => 'Fargo',
		'US1840021678' => 'Glencoe',
		'US1840021717' => 'Boynton',
		'US1840022846' => 'Tatums',
		'US1840021592' => 'Fairfax',
		'US1840021742' => 'The Village',
		'US1840034584' => 'Scraper',
		'US1840020518' => 'Lehigh',
		'US1840026980' => 'Blue',
		'US1840022771' => 'Panama',
		'US1840021673' => 'Liberty',
		'US1840021927' => 'Achille',
		'US1840021660' => 'Disney',
		'US1840021748' => 'Luther',
		'US1840040388' => 'Old Green',
		'US1840022601' => 'Welch',
		'US1840022811' => 'Byng',
		'US1840021595' => 'Waynoka',
		'US1840034622' => 'Hoot Owl',
		'US1840021854' => 'Indiahoma',
		'US1840017831' => 'Brushy',
		'US1840022845' => 'Springer',
		'US1840022645' => 'Mooreland',
		'US1840022609' => 'Carmen',
		'US1840022595' => 'Wann',
		'US1840019062' => 'Cushing',
		'US1840021628' => 'Gate',
		'US1840026979' => 'Albany',
		'US1840021743' => 'Warr Acres',
		'US1840021791' => 'Keota',
		'US1840021895' => 'Hollister',
		'US1840022751' => 'Cement',
		'US1840022660' => 'Shattuck',
		'US1840021614' => 'Tonkawa',
		'US1840022603' => 'Copan',
		'US1840020478' => 'Lindsay',
		'US1840034601' => 'Zeb',
		'US1840021610' => 'Helena',
		'US1840021785' => 'Shawnee',
		'US1840017749' => 'Christie',
		'US1840019107' => 'Beggs',
		'US1840024887' => 'Kenwood',
		'US1840019059' => 'Broken Arrow',
		'US1840034655' => 'Tenkiller',
		'US1840021612' => 'Lambert',
		'US1840021900' => 'Dickson',
		'US1840021803' => 'Alex',
		'US1840021782' => 'Rocky',
		'US1840019154' => 'Del City',
		'US1840022895' => 'Mead',
		'US1840034657' => 'McCord',
		'US1840022733' => 'Smith Village',
		'US1840021599' => 'Vinita',
		'US1840022666' => 'Pensacola',
		'US1840022801' => 'Cooperton',
		'US1840020351' => 'Hooker',
		'US1840020426' => 'Nichols Hills',
		'US1840022710' => 'Strong City',
		'US1840020345' => 'Ponca City',
		'US1840021594' => 'Grainola',
		'US1840034543' => 'Greasy',
		'US1840074625' => 'Sand Hill',
		'US1840034428' => 'Clarita',
		'US1840020386' => 'Perkins',
		'US1840021683' => 'Langston',
		'US1840020373' => 'Enid',
		'US1840021710' => 'Agra',
		'US1840021905' => 'Ravia',
		'US1840021891' => 'Sulphur',
		'US1840022773' => 'Shady Point',
		'US1840034591' => 'Sycamore',
		'US1840022897' => 'Calera',
		'US1840019153' => 'Bethany',
		'US1840017748' => 'Eldon',
		'US1840021792' => 'Kinta',
		'US1840020392' => 'Oilton',
		'US1840021603' => 'Renfrow',
		'US1840022885' => 'Sugden',
		'US1840021651' => 'Kremlin',
		'US1840021894' => 'Davidson',
		'US1840021850' => 'Headrick',
		'US1840022833' => 'Tushka',
		'US1840019078' => 'Park Hill',
		'US1840021761' => 'Hanna',
		'US1840020369' => 'Grove',
		'US1840020543' => 'Madill',
		'US1840021626' => 'Hardesty',
		'US1840022854' => 'Valliant',
		'US1840021679' => 'Dover',
		'US1840017750' => 'Chewey',
		'US1840034610' => 'Le Flore',
		'US1840034631' => 'Cloud Creek',
		'US1840034431' => 'Connerville',
		'US1840022672' => 'Meno',
		'US1840034541' => 'Gideon',
		'US1840021753' => 'Boley',
		'US1840020390' => 'Guthrie',
		'US1840019260' => 'Idabel',
		'US1840021788' => 'St. Louis',
		'US1840022663' => 'Terlton',
		'US1840021760' => 'Rentiesville',
		'US1840020391' => 'Geary',
		'US1840018980' => 'Blackwell',
		'US1840021613' => 'Braman',
		'US1840021857' => 'Erin Springs',
		'US1840022770' => 'Whitefield',
		'US1840021783' => 'Foss',
		'US1840020445' => 'Poteau',
		'US1840022725' => 'Webbers Falls',
		'US1840021820' => 'Lamar',
		'US1840022678' => 'Sperry',
		'US1840021886' => 'Bray',
		'US1840034632' => 'Dripping Springs',
		'US1840019258' => 'Ardmore',
		'US1840040357' => 'Deer Lick',
		'US1840021879' => 'Tupelo',
		'US1840022664' => 'Westport',
		'US1840021701' => 'Hulbert',
		'US1840034659' => 'Nescatunga',
		'US1840022832' => 'Stringtown',
		'US1840019254' => 'Atoka',
		'US1840021675' => 'Stillwater',
		'US1840021795' => 'Pocola',
		'US1840018984' => 'Commerce',
		'US1840020389' => 'Kingfisher',
		'US1840021696' => 'Wagoner',
		'US1840022649' => 'Colcord',
		'US1840019057' => 'Turley',
		'US1840021711' => 'Davenport',
		'US1840022789' => 'Savanna',
		'US1840022908' => 'Thackerville',
		'US1840021836' => 'Allen',
		'US1840021617' => 'Quapaw',
		'US1840021786' => 'Tecumseh',
		'US1840034502' => 'Wardville',
		'US1840026902' => 'Nardin',
		'US1840021750' => 'Roland',
		'US1840021784' => 'Brooksville',
		'US1840020430' => 'Bearden',
		'US1840021774' => 'Sayre',
		'US1840020400' => 'Okmulgee',
		'US1840021741' => 'Spencer',
		'US1840021856' => 'Elmore City',
		'US1840022819' => 'Olustee',
		'US1840040360' => 'Drowning Creek',
		'US1840022767' => 'Wanette',
		'US1840021904' => 'Tishomingo',
		'US1840017706' => 'Mazie',
		'US1840073923' => 'Lyons Switch',
		'US1840022700' => 'Mounds',
		'US1840022693' => 'Okeene',
		'US1840020453' => 'Newcastle',
		'US1840020460' => 'Holdenville',
		'US1840022692' => 'Cimarron City',
		'US1840020338' => 'Hominy',
		'US1840022691' => 'Orlando',
		'US1840019152' => 'Choctaw',
		'US1840021814' => 'Indianola',
		'US1840020451' => 'Norman',
		'US1840074573' => 'Pump Back',
		'US1840019060' => 'Jenks',
		'US1840022761' => 'Corn',
		'US1840022852' => 'Millerton',
		'US1840021688' => 'Seiling',
		'US1840022734' => 'Valley Brook',
		'US1840021809' => 'Rosedale',
		'US1840021807' => 'Etowah',
		'US1840021627' => 'Forgan',
		'US1840022689' => 'Marshall',
		'US1840026926' => 'Lucien',
		'US1840021722' => 'Haskell',
		'US1840021919' => 'Addington',
		'US1840021609' => 'Goltry',
		'US1840037403' => 'New Cordell',
		'US1840021647' => 'Drummond',
		'US1840020370' => 'Bernice',
		'US1840040363' => 'Elm Grove',
		'US1840021835' => 'Gould',
		'US1840020449' => 'Moore',
		'US1840034602' => 'Zena',
		'US1840074975' => 'Texhoma',
		'US1840020479' => 'Pauls Valley',
		'US1840024948' => 'Nicut',
		'US1840021918' => 'Waurika',
		'US1840026903' => 'Felt',
		'US1840019048' => 'Catoosa',
		'US1840021907' => 'Devol',
		'US1840021746' => 'Jones',
		'US1840021681' => 'Loyal',
		'US1840020437' => 'Elk City',
		'US1840021608' => 'Amorita',
		'US1840019175' => 'Blanchard',
		'US1840022736' => 'Marble City',
		'US1840034654' => 'Tagg Flats',
		'US1840020375' => 'Arnett',
		'US1840020398' => 'Henryetta',
		'US1840021606' => 'Burlington',
		'US1840021618' => 'Fairland',
		'US1840021932' => 'Fort Towson',
		'US1840021676' => 'Yale',
		'US1840021852' => 'Fletcher',
		'US1840021593' => 'Foraker',
		'US1840034585' => 'Sequoyah',
		'US1840019073' => 'Crescent',
		'US1840022716' => 'Wellston',
		'US1840022696' => 'Camargo',
		'US1840021827' => 'Lone Wolf',
		'US1840022774' => 'Spiro',
		'US1840021798' => 'Fort Coffee',
		'US1840022648' => 'Oaks',
		'US1840021607' => 'Aline',
		'US1840021763' => 'Apache',
		'US1840034577' => 'Pin Oak Acres',
		'US1840021762' => 'Hitchita',
		'US1840021816' => 'Wetumka',
		'US1840024947' => 'Box',
		'US1840021744' => 'Arcadia',
		'US1840022788' => 'Canadian',
		'US1840021929' => 'Kemp',
		'US1840020531' => 'Healdton',
		'US1840021671' => 'Sand Springs',
		'US1840034637' => 'Fairfield',
		'US1840021910' => 'Haworth',
		'US1840021768' => 'Hinton',
		'US1840034536' => 'Dodge',
		'US1840022596' => 'Osage',
		'US1840019169' => 'Chickasha',
		'US1840021589' => 'Burbank',
		'US1840020440' => 'Bessie',
		'US1840034535' => 'Dennis',
		'US1840022765' => 'Pink',
		'US1840021656' => 'Ralston',
		'US1840034430' => 'Coleman',
		'US1840022614' => 'May',
		'US1840034462' => 'Longtown',
		'US1840034458' => 'Latta',
		'US1840021908' => 'Randlett',
		'US1840040368' => 'Grandview',
		'US1840021855' => 'Wynnewood',
		'US1840021789' => 'Johnson',
		'US1840021811' => 'Alderson',
		'US1840020340' => 'Avant',
		'US1840022784' => 'Cole',
		'US1840022594' => 'South Coffeyville',
		'US1840021685' => 'Greenfield',
		'US1840022802' => 'Willow',
		'US1840021596' => 'Dacoma',
		'US1840026905' => 'Turpin',
		'US1840022709' => 'Cheyenne',
		'US1840022690' => 'Meridian',
		'US1840021600' => 'Ketchum',
		'US1840020423' => 'Edmond',
		'US1840040405' => 'Steely Hollow',
		'US1840020427' => 'Nicoma Park',
		'US1840021893' => 'Hickory',
		'US1840021800' => 'Bradley',
		'US1840034630' => 'Carlisle',
		'US1840022848' => 'Milburn',
		'US1840022705' => 'Watts',
		'US1840026983' => 'Swink',
		'US1840022712' => 'Carney',
		'US1840022893' => 'New Woodville',
		'US1840020545' => 'Bennington',
		'US1840021802' => 'Tuttle',
		'US1840026981' => 'Cartwright',
		'US1840021765' => 'Eakly',
		'US1840074909' => 'Redbird',
		'US1840022731' => 'Calumet',
		'US1840021714' => 'Dewar',
		'US1840021725' => 'Weatherford',
		'US1840022694' => 'Canton',
		'US1840022828' => 'Phillips',
		'US1840021604' => 'Jefferson',
		'US1840022651' => 'Marland',
		'US1840019008' => 'Boise City',
		'US1840020447' => 'Minco',
		'US1840074410' => 'Sour John',
		'US1840019081' => 'Rocky Mountain',
		'US1840021887' => 'Empire City',
		'US1840020458' => 'Krebs',
		'US1840020377' => 'Fairview',
		'US1840026927' => 'Bison',
		'US1840021624' => 'Keyes',
		'US1840019252' => 'Comanche',
		'US1840022775' => 'Talihina',
		'US1840022849' => 'Mill Creek',
		'US1840021747' => 'Lake Aluma',
		'US1840021590' => 'Shidler',
		'US1840021654' => 'Gage',
		'US1840034556' => 'Lost City',
		'US1840021838' => 'Fitzhugh',
		'US1840021745' => 'Forest Park',
		'US1840022834' => 'Clayton',
		'US1840020561' => 'Marietta',
		'US1840022697' => 'Taloga',
		'US1840020477' => 'Lawton',
		'US1840026971' => 'Tuskahoma',
		'US1840022760' => 'Colony',
		'US1840021591' => 'Prue',
		'US1840018975' => 'Barnsdall',
		'US1840034419' => 'Breckenridge',
		'US1840022835' => 'Manitou',
		'US1840026929' => 'Isabella',
		'US1840021665' => 'Ringwood',
		'US1840021853' => 'Geronimo',
		'US1840022759' => 'Canute',
		'US1840021833' => 'Red Oak',
		'US1840018976' => 'Alva',
		'US1840040406' => 'White Water',
		'US1840020428' => 'Oklahoma City',
		'US1840020476' => 'Elgin',
		'US1840022756' => 'Sweetwater',
		'US1840022853' => 'Smithville',
		'US1840020352' => 'Beaver',
		'US1840021909' => 'Garvin',
		'US1840022695' => 'Oakwood',
		'US1840022822' => 'Sterling',
		'US1840020450' => 'Noble',
		'US1840022670' => 'Sportsmen Acres',
		'US1840022741' => 'Paden',
		'US1840021705' => 'Reydon',
		'US1840022800' => 'Mountain View',
		'US1840021652' => 'Lahoma',
		'US1840034515' => 'Briggs',
		'US1840034603' => 'Zion',
		'US1840018977' => 'Bartlesville',
		'US1840021726' => 'Arapaho',
		'US1840021700' => 'Tahlequah',
		'US1840022714' => 'Tryon',
		'US1840026978' => 'Lebanon',
		'US1840022762' => 'Sentinel',
		'US1840019076' => 'Drumright',
		'US1840021663' => 'Locust Grove',
		'US1840022610' => 'North Miami',
		'US1840034629' => 'Bull Hollow',
		'US1840021806' => 'Rush Springs',
		'US1840021697' => 'Porter',
		'US1840022635' => 'Optima',
		'US1840021658' => 'Jennings',
		'US1840021839' => 'Francis',
		'US1840021794' => 'Cowlington',
		'US1840034640' => 'Gregory',
		'US1840021804' => 'Amber',
		'US1840022661' => 'Maramec',
		'US1840021903' => 'Bromide',
		'US1840022652' => 'Morrison',
		'US1840017697' => 'Leach',
		'US1840021930' => 'Kenefic',
		'US1840021752' => 'Gore',
		'US1840020343' => 'Pond Creek',
		'US1840021648' => 'Fairmont',
		'US1840022836' => 'Tipton',
		'US1840021621' => 'Laverne',
		'US1840021637' => 'Fort Supply',
		'US1840022768' => 'McCurtain',
		'US1840019061' => 'Collinsville',
		'US1840034649' => 'Salem',
		'US1840021720' => 'Porum',
		'US1840019159' => 'Anadarko',
		'US1840021602' => 'Deer Creek',
		'US1840019045' => 'Twin Oaks',
		'US1840021770' => 'Lookeba',
		'US1840022750' => 'Carnegie',
		'US1840022656' => 'Verdigris',
		'US1840034480' => 'Platter',
		'US1840021598' => 'Bluejacket',
		'US1840021751' => 'Gans',
		'US1840021620' => 'Rosston',
		'US1840021646' => 'Douglas',
		'US1840022772' => 'Cameron',
		'US1840021858' => 'Foster',
		'US1840022604' => 'Vera',
		'US1840022671' => 'Strang',
		'US1840026951' => 'Whitesboro',
		'US1840019160' => 'Bridgeport',
		'US1840021815' => 'Kiowa',
		'US1840019247' => 'Centrahoma',
		'US1840021832' => 'Wilburton',
		'US1840037410' => 'Pryor Creek',
		'US1840022699' => 'Mannford',
		'US1840020466' => 'Mangum',
		'US1840022769' => 'Tamaha',
		'US1840019077' => 'Coweta',
		'US1840022659' => 'Waukomis',
		'US1840022900' => 'Sawyer',
		'US1840021793' => 'Bokoshe',
		'US1840022737' => 'Moffett',
		'US1840021776' => 'Seminole',
		'US1840021826' => 'Gotebo',
		'US1840021601' => 'Ramona',
		'US1840021780' => 'Burns Flat',
		'US1840021716' => 'Hoffman',
		'US1840022763' => 'Macomb',
		'US1840021692' => 'Depew',
		'US1840021825' => 'Roosevelt',
		'US1840022711' => 'Meeker',
		'US1840034532' => 'Copeland',
		'US1840020546' => 'Hugo',
		'US1840022703' => 'Okay',
		'US1840021662' => 'Langley',
		'US1840034651' => 'Short',
		'US1840020526' => 'Marlow',
		'US1840021812' => 'Crowder',
		'US1840021819' => 'Horntown',
		'US1840021643' => 'Foyil',
		'US1840022704' => 'Tullahassee',
		'US1840021928' => 'Hendrix',
		'US1840034621' => 'Valley Park',
		'US1840020455' => 'Haileyville',
		'US1840021650' => 'Hunter',
		'US1840021690' => 'Leedey',
		'US1840020442' => 'Asher',
		'US1840021766' => 'Fort Cobb',
		'US1840021777' => 'Wewoka',
		'US1840021849' => 'Friendship',
		'US1840020342' => 'Medford',
		'US1840022722' => 'Taft',
		'US1840020376' => 'Pawnee',
		'US1840037117' => 'New Eucha',
		'US1840022673' => 'Cleo Springs',
		'US1840020371' => 'Perry',
		'US1840022850' => 'Wapanucka',
		'US1840021920' => 'Ringling',
		'US1840020444' => 'Heavener',
		'US1840034645' => 'Old Eucha',
		'US1840022742' => 'Castle',
		'US1840034643' => 'Limestone',
		'US1840021611' => 'Jet',
		'US1840022602' => 'Ochelata',
		'US1840020422' => 'Piedmont',
		'US1840034594' => 'Teresita',
		'US1840034648' => 'Rocky Ford',
		'US1840020425' => 'Midwest City',
		'US1840022740' => 'Vian',
		'US1840018983' => 'Narcissa',
		'US1840021657' => 'Hallett',
		'US1840021625' => 'Goodwell',
		'US1840026904' => 'Kenton',
		'US1840021899' => 'Wilson',
		'US1840034416' => 'Blanco',
		'US1840018979' => 'Cherokee',
		'US1840034569' => 'Notchietown',
		'US1840018981' => 'Kaw City',
		'US1840022669' => 'Spavinaw',
		'US1840022653' => 'Oologah',
		'US1840022723' => 'Wainwright',
		'US1840026928' => 'Chester',
		'US1840034479' => 'Pinhook Corner',
		'US1840021674' => 'Lotsee',
		'US1840021724' => 'Thomas',
		'US1840021902' => 'Gene Autry',
		'US1840024946' => 'Blackgum',
		'US1840019253' => 'Duncan',
		'US1840034642' => 'Justice',
		'US1840022786' => 'Wayne',
		'US1840024900' => 'Rose',
		'US1840034656' => 'Woodall',
		'US1840022901' => 'Soper',
		'US1840022793' => 'Yeager',
		'US1840022655' => 'Talala',
		'US1840034641' => 'Iron Post',
		'US1840021817' => 'Dustin',
		'US1840022758' => 'Sasakwa',
		'US1840020396' => 'Prague',
		'US1840022608' => 'Byron',
		'US1840022598' => 'Webb City',
		'US1840022706' => 'Westville',
		'US1840022780' => 'Slaughterville',
		'US1840021810' => 'Goldsby',
		'US1840021790' => 'Stigler',
		'US1840021837' => 'Roff',
		'US1840034510' => 'Bell',
		'US1840034475' => 'Panola',
		'US1840021938' => 'Leon',
		'US1840021740' => 'Yukon',
		'US1840021808' => 'Dibble',
		'US1840034646' => 'Peavine',
		'US1840034626' => 'Belfonte',
		'US1840021702' => 'Stilwell',
		'US1840020439' => 'Konawa',
		'US1840021686' => 'Hitchcock',
		'US1840020429' => 'Okemah',
		'US1840021682' => 'Coyle',
		'US1840022687' => 'Okarche',
		'US1840040352' => 'Badger Lee',
		'US1840020337' => 'Nowata',
		'US1840021721' => 'Fort Gibson',
		'US1840022757' => 'Texola',
		'US1840022701' => 'Shamrock',
		'US1840034468' => 'Monroe',
		'US1840022668' => 'Salina',
		'US1840026982' => 'Grant',
		'US1840034525' => 'Cayuga',
		'US1840022886' => 'Terral',
		'US1840026952' => 'Arpelar',
		'US1840034457' => 'Keys',
		'US1840021845' => 'Blair',
		'US1840021687' => 'Longdale',
		'US1840034653' => 'Stoney Point',
		'US1840021799' => 'Howe',
		'US1840021922' => 'Hastings',
		'US1840021636' => 'Woodward',
		'US1840019202' => 'Altus',
		'US1840021689' => 'Putnam',
		'US1840022884' => 'Cornish',
		'US1840022743' => 'Clearview',
		'US1840020339' => 'Pawhuska',
		'US1840034636' => 'Evening Shade',
		'US1840020421' => 'Mustang',
		'US1840034627' => 'Brent',
		'US1840022688' => 'Cashion',
		'US1840019080' => 'Welling',
		'US1840022851' => 'Temple',
		'US1840037469' => 'East Duke',
		'US1840021655' => 'Blackburn',
		'US1840021926' => 'Bokchito',
		'US1840022812' => 'Stonewall',
		'US1840022792' => 'Stuart',
		'US1840019108' => 'Clinton',
		'US1840021712' => 'Fallis',
		'US1840021859' => 'Katie',
		'US1840021754' => 'IXL',
		'US1840022787' => 'Pittsburg',
		'US1840017832' => 'Long',
		'US1840021706' => 'Hammon',
		'US1840022735' => 'Woodlawn Park',
		'US1840022823' => 'Paoli',
		'US1840020438' => 'Erick',
		'US1840021659' => 'Adair',
		'US1840022830' => 'Velma',
		'US1840022654' => 'Chelsea',
		'US1840020454' => 'Purcell',
		'US1840020544' => 'Armstrong',
		'US1840022599' => 'Wynona',
		'US1840021699' => 'Fair Oaks',
		'US1840021801' => 'Bridge Creek',
		'US1840021901' => 'Ratliff City',
		'US1840026950' => 'Dale',
		'US1840034446' => 'Gowen',
		'US1840034527' => 'Cherry Tree',
		'US1840020374' => 'Garber',
		'US1840021641' => 'Kansas',
		'US1840019079' => 'Pettit',
		'US1840026970' => 'Lane',
		'US1840021684' => 'Watonga',
		'US1840022779' => 'Verden',
		'US1840022698' => 'Vici',
		'US1840021644' => 'Inola',
		'US1840022721' => 'Summit',
		'US1840024818' => 'White Oak',
		'US1840022606' => 'Nash',
		'US1840021619' => 'Buffalo',
		'US1840021889' => 'Albion',
		'US1840021587' => 'Delaware',
		'US1840022702' => 'Slick',
		'US1840021775' => 'Bowlegs',
		'US1840019058' => 'Bixby',
		'US1840021616' => 'Afton',
		'US1840021680' => 'Hennessey',
		'US1840034647' => 'Redbird Smith',
		'US1840024907' => 'Proctor',
		'US1840021672' => 'Tulsa',
		'US1840022764' => 'McLoud',
		'US1840021709' => 'Stroud',
		'US1840034623' => 'Oak Grove',
		'US1840034638' => 'Flint Creek',
		'US1840021921' => 'Ryan',
		'US1840020384' => 'Glenpool',
		'US1840034634' => 'Duchess Landing',
		'US1840022755' => 'Carter',
		'US1840024908' => 'Titanic',
		'US1840020443' => 'Bethel Acres',
		'US1840021713' => 'Kendrick',
		'US1840022667' => 'Chouteau',
		'US1840020465' => 'Hobart',
		'US1840024906' => 'Peggs',
		'US1840022790' => 'Calvin',
		'US1840021890' => 'Rattan',
		'US1840020459' => 'Ashland',
		'US1840022829' => 'Central High',
		'US1840074958' => 'New Alluwe',
		'US1840034465' => 'Maysville',
		'US1840021779' => 'Lima',
		'US1840020350' => 'Guymon',
		'US1840021645' => 'Covington',
		'US1840021723' => 'Butler',
		'US1840020435' => 'Binger',
		'US1840021769' => 'Hydro',
		'US1840021892' => 'Dougherty',
		'US1840022738' => 'Muldrow',
		'US1840021888' => 'Loco',
		'US1840022855' => 'Wright City',
		'US1840020344' => 'Newkirk',
		'US1840019158' => 'Texanna',
		'US1840022600' => 'Capron',
		'US1840020528' => 'Grandfield',
		'US1840020385' => 'Owasso',
		'US1840022791' => 'Spaulding',
		'US1840020372' => 'Billings',
		'US1840022749' => 'Stidham',
		'US1840020401' => 'Muskogee',
		'US1840021715' => 'Grayson',
		'US1840022732' => 'Union City',
		'US1840022637' => 'Tyrone',
		'US1840022899' => 'Silo',
		'US1840034424' => 'Cedar Crest',
		'US1840022785' => 'Washington',
		'US1840022662' => 'Skedee',
		'US1840021805' => 'Pocasset',
		'US1840020470' => 'Hollis',
		'US1840020399' => 'Morris',
		'US1840021797' => 'Fanshawe',
		'US1840022724' => 'Warner',
		'US1840020448' => 'Lexington',
		'US1840020420' => 'El Reno',
		'US1840021778' => 'Cromwell',
		'US1840022777' => 'Ninnekah',
		'US1840021896' => 'Loveland',
		'US1840022613' => 'Wyandotte',
		'US1840019256' => 'Davis',
		'US1840021615' => 'Kildare',
		'US1840034578' => 'Piney',
		'US1840021824' => 'Snyder',
		'US1840022647' => 'Sharon',
		'US1840022611' => 'Peoria',
		'US1840021605' => 'Lamont',
		'US1840020341' => 'Big Cabin',
		'US1840018982' => 'Dotyville',
		'US1840021629' => 'Knowles',
		'US1840034635' => 'Dwight Mission',
		'US1840034639' => 'Flute Springs',
		'US1840021718' => 'Braggs',
		'US1840019157' => 'Checotah',
		'US1840020434' => 'Eufaula',
		'US1840022720' => 'Oktaha',
		'US1840022818' => 'Martha',
		'US1840022744' => 'Weleetka',
		'US1840019072' => 'Cedar Valley',
		'US1840020527' => 'Frederick',
		'US1840020461' => 'Atwood',
		'US1840022718' => 'Schulter',
		'US1840021727' => 'Custer City',
		'US1840019049' => 'Claremore',
		'US1840022605' => 'Manchester',
		'US1840034652' => 'Snake Creek',
		'US1840019248' => 'Coalgate',
		'US1840019280' => 'Durant',
		'US1840021764' => 'Cyril',
		'US1840019046' => 'Jay',
		'US1840022713' => 'Sparks',
		'US1840019203' => 'Cache',
		'US1840022898' => 'Colbert',
		'US1840034469' => 'Mulhall',
		'US1840020456' => 'Hartshorne',
		'US1840021694' => 'Kiefer',
		'US1840034628' => 'Brush Creek',
		'US1840021818' => 'Gerty',
		'US1840021677' => 'Ripley',
		'US1840021796' => 'Rock Island',
		'US1840026975' => 'Eagletown',
		'US1840034597' => 'Wauhillau',
		'US1840020532' => 'Lone Grove',
		'US1840017696' => 'Cleora',
		'US1840021767' => 'Gracemont',
		'US1840034660' => 'Simms',
		'US1840022799' => 'Mountain Park',
		'US1840021642' => 'Red Rock',
		'US1840021664' => 'Ames',
		'US1840026974' => 'Bee',
		'US1840074577' => 'River Bottom',
		'US1840019075' => 'Bristow',
		'US1840022778' => 'Norge',
		'US1840021691' => 'Sapulpa',
		'US1840022739' => 'Paradise Hill',
		'US1840022650' => 'West Siloam Springs',
		'US1840074749' => 'Wickliffe',
		'US1840136191' => 'Shady Grove',
		'US1840022894' => 'Oakland',
		'US1840021693' => 'Kellyville',
		'US1840021848' => 'Elmer',
		'US1840021851' => 'Faxon',
		'US1840022715' => 'Warwick',
		'US1840019255' => 'Antlers',
		'US1840022657' => 'North Enid',
		'US1840022896' => 'Caddo',
		'US1840019259' => 'Broken Bow',
		'US1840034661' => 'West Peavine',
		'US1840020441' => 'Maud',
		'US1840021931' => 'Boswell',
		'US1840034568' => 'Murphy',
		'US1840021649' => 'Hillsdale',
		'US1840034422' => 'Burneyville',
		'US1840021749' => 'Sallisaw',
		'US1840021588' => 'Lenapah',
		'US1840017830' => 'Akins',
		'US1840040387' => 'Mulberry',
		'US1840022821' => 'Chattanooga',
		'US1840022719' => 'Winchester',
		'US1840021781' => 'Dill City',
		'US1840019074' => 'Oakhurst',
		'US1840021847' => 'Eldorado',
		'US1840019191' => 'Ada',
		'US1840022607' => 'Wakita',
		'US1840022597' => 'Skiatook',
		'US1840020346' => 'Miami',
		'US1840022766' => 'Tribbey',
		'US1840019050' => 'Cleveland',
		'US1840034625' => 'Ballou',
		'US1840022783' => 'Byars',
		'US1840021787' => 'Earlsboro',
		'US1840018081' => 'Carlton Landing',
		'US1840019047' => 'Tiawah',
		'US1840034460' => 'Lequire',
		'US1840021597' => 'Freedom',
		'US1840020446' => 'Arkoma',
		'US1840022658' => 'Carrier',
		'US1840021813' => 'Quinton',
		'US1840022824' => 'Stratford',
		'US1840020457' => 'McAlester',
		'US1840034521' => 'Bushyhead',
		'US1840020424' => 'Harrah',
		'US1840019106' => 'Chandler',
		'US1840022820' => 'Medicine Park',
		'US1840021925' => 'Kingston',
		'US1840021695' => 'Lawrence Creek',
		'US1840034633' => 'Dry Creek',
		'US1840021906' => 'Walters',
		'US1840022646' => 'Mutual',
		'US1840021828' => 'Granite',
		'US1840022847' => 'Mannsville',
		'US1840021661' => 'Grand Lake Towne',
		'US1840018978' => 'Dewey',
	],
	'OH' => [
		'US1840003805' => 'Trenton',
		'US1840000611' => 'Maple Heights',
		'US1840010640' => 'Amesville',
		'US1840012464' => 'Belle Valley',
		'US1840000614' => 'Middleburg Heights',
		'US1840005424' => 'Brilliant',
		'US1840034162' => 'Turpin Hills',
		'US1840003692' => 'Coshocton',
		'US1840026668' => 'Miamiville',
		'US1840000806' => 'Aurora',
		'US1840012438' => 'South Vienna',
		'US1840026548' => 'Glencoe',
		'US1840012031' => 'Waldo',
		'US1840026317' => 'Ridgeville Corners',
		'US1840003811' => 'Arlington Heights',
		'US1840012701' => 'Fairfax',
		'US1840009467' => 'Piqua',
		'US1840000798' => 'Munroe Falls',
		'US1840024517' => 'Miamitown',
		'US1840003400' => 'North Olmsted',
		'US1840008390' => 'Gahanna',
		'US1840012127' => 'Wintersville',
		'US1840034399' => 'Chippewa Park',
		'US1840012333' => 'St. Paris',
		'US1840012329' => 'Kirkersville',
		'US1840001607' => 'Mount Healthy',
		'US1840011712' => 'Lodi',
		'US1840003764' => 'Whitehall',
		'US1840034385' => 'Green Meadows',
		'US1840005728' => 'Devola',
		'US1840011553' => 'Custar',
		'US1840005201' => 'Perry Heights',
		'US1840012119' => 'Irondale',
		'US1840012416' => 'Midway',
		'US1840026537' => 'Brownsville',
		'US1840012496' => 'New Paris',
		'US1840034123' => 'Northbrook',
		'US1840026349' => 'Flat Rock',
		'US1840011996' => 'Dellroy',
		'US1840012382' => 'Belmont',
		'US1840012172' => 'Magnetic Springs',
		'US1840026481' => 'Berlin',
		'US1840011892' => 'Creston',
		'US1840012002' => 'Rockford',
		'US1840001610' => 'Norwood',
		'US1840034379' => 'Blacklick Estates',
		'US1840011722' => 'Grover Hill',
		'US1840012473' => 'Stoutsville',
		'US1840034369' => 'Waverly',
		'US1840011607' => 'Florida',
		'US1840005562' => 'Brookville',
		'US1840000964' => 'Louisville',
		'US1840011599' => 'Lindsey',
		'US1840012324' => 'Granville',
		'US1840000533' => 'Eastlake',
		'US1840007375' => 'Hillsboro',
		'US1840034362' => 'Logan Elm Village',
		'US1840012149' => 'Belle Center',
		'US1840003761' => 'Grandview Heights',
		'US1840012437' => 'South Charleston',
		'US1840003823' => 'Lockland',
		'US1840000655' => 'Orangeville',
		'US1840000799' => 'Northfield',
		'US1840012093' => 'Newcomerstown',
		'US1840010349' => 'Apple Creek',
		'US1840012406' => 'Minerva Park',
		'US1840026544' => 'Kimbolton',
		'US1840012249' => 'Gettysburg',
		'US1840000674' => 'London',
		'US1840012485' => 'Shawnee',
		'US1840000535' => 'Kirtland',
		'US1840012686' => 'Hamden',
		'US1840026376' => 'Damascus',
		'US1840003408' => 'Pepper Pike',
		'US1840001342' => 'Fredericktown',
		'US1840012254' => 'Osgood',
		'US1840012128' => 'Smithfield',
		'US1840003405' => 'Orange',
		'US1840012523' => 'Woodsfield',
		'US1840012383' => 'Bethesda',
		'US1840011514' => 'Metamora',
		'US1840000537' => 'Lakeline',
		'US1840011873' => 'North Robinson',
		'US1840011957' => 'Dunkirk',
		'US1840000796' => 'Lakemore',
		'US1840012838' => 'Proctorville',
		'US1840026703' => 'Minford',
		'US1840010384' => 'Burkettsville',
		'US1840012839' => 'South Point',
		'US1840011545' => 'Milan',
		'US1840012202' => 'Galena',
		'US1840007312' => 'Beavercreek',
		'US1840000791' => 'Akron',
		'US1840010488' => 'Urbana',
		'US1840012788' => 'South Webster',
		'US1840000607' => 'Independence',
		'US1840005202' => 'Uniontown',
		'US1840026264' => 'Neapolis',
		'US1840012418' => 'Plain City',
		'US1840012466' => 'Sarahsville',
		'US1840007175' => 'Columbiana',
		'US1840012084' => 'Baltic',
		'US1840026651' => 'Stewart',
		'US1840009528' => 'Pickerington',
		'US1840026554' => 'Trinway',
		'US1840000624' => 'Rossford',
		'US1840011751' => 'Columbus Grove',
		'US1840012420' => 'West Jefferson',
		'US1840012197' => 'Conesville',
		'US1840012609' => 'Seven Mile',
		'US1840012770' => 'Peebles',
		'US1840011908' => 'Venedocia',
		'US1840034387' => 'Lake Darby',
		'US1840012139' => 'Danville',
		'US1840011750' => 'Cloverdale',
		'US1840008320' => 'Kenton',
		'US1840011644' => 'Hicksville',
		'US1840012097' => 'Strasburg',
		'US1840034246' => 'Blue Jay',
		'US1840026428' => 'St. Johns',
		'US1840012724' => 'Mount Orab',
		'US1840010407' => 'Toronto',
		'US1840012611' => 'Harveysburg',
		'US1840011889' => 'Sycamore',
		'US1840011777' => 'Poland',
		'US1840042997' => 'Lake Tomahawk',
		'US1840007173' => 'Canal Fulton',
		'US1840000544' => 'Timberlake',
		'US1840012387' => 'Morristown',
		'US1840012555' => 'New Holland',
		'US1840003394' => 'Bay Village',
		'US1840011915' => 'Meyers Lake',
		'US1840001420' => 'Pataskala',
		'US1840011552' => 'Hoytville',
		'US1840012372' => 'Bradford',
		'US1840011933' => 'Rogers',
		'US1840012527' => 'Yellow Springs',
		'US1840012087' => 'Dennison',
		'US1840095037' => 'Hartford',
		'US1840007217' => 'Dover',
		'US1840003763' => 'Westerville',
		'US1840012491' => 'New Lebanon',
		'US1840009257' => 'Port Clinton',
		'US1840001605' => 'Madeira',
		'US1840011888' => 'Nevada',
		'US1840042995' => 'Lake Lorelei',
		'US1840012354' => 'Cumberland',
		'US1840000595' => 'Chagrin Falls',
		'US1840011479' => 'Waterville',
		'US1840007421' => 'West Portsmouth',
		'US1840012777' => 'Vinton',
		'US1840011740' => 'Jenera',
		'US1840010469' => 'Ansonia',
		'US1840000802' => 'Silver Lake',
		'US1840011913' => 'East Canton',
		'US1840012259' => 'Versailles',
		'US1840011746' => 'Vanlue',
		'US1840034377' => 'Beckett Ridge',
		'US1840012490' => 'Riverside',
		'US1840012001' => 'Fort Recovery',
		'US1840012005' => 'Montezuma',
		'US1840011807' => 'Perrysville',
		'US1840010756' => 'Chesapeake',
		'US1840011882' => 'Lexington',
		'US1840011753' => 'Dupont',
		'US1840012389' => 'Shadyside',
		'US1840011709' => 'New London',
		'US1840000805' => 'Twinsburg',
		'US1840034254' => 'Dry Ridge',
		'US1840003781' => 'Lancaster',
		'US1840010351' => 'Brewster',
		'US1840012610' => 'Somerville',
		'US1840011894' => 'Doylestown',
		'US1840026268' => 'Pettisville',
		'US1840000609' => 'Linndale',
		'US1840010653' => 'Adelphi',
		'US1840009429' => 'Sidney',
		'US1840026663' => 'Buford',
		'US1840034315' => 'Sixteen Mile Stand',
		'US1840012837' => 'Coal Grove',
		'US1840010389' => 'Caledonia',
		'US1840012570' => 'Stockport',
		'US1840005186' => 'Boardman',
		'US1840011515' => 'Swanton',
		'US1840000797' => 'Macedonia',
		'US1840011418' => 'Orwell',
		'US1840011676' => 'Windham',
		'US1840012120' => 'Dillonvale',
		'US1840012394' => 'New Concord',
		'US1840012388' => 'Yorkville',
		'US1840003562' => 'Struthers',
		'US1840001646' => 'Portsmouth',
		'US1840012337' => 'Woodstock',
		'US1840034153' => 'Highpoint',
		'US1840010215' => 'Clay Center',
		'US1840010583' => 'Union',
		'US1840012192' => 'Kettlersville',
		'US1840012477' => 'Junction City',
		'US1840012616' => 'South Lebanon',
		'US1840012174' => 'Unionville Center',
		'US1840012360' => 'Senecaville',
		'US1840010680' => 'Chilo',
		'US1840012000' => 'Coldwater',
		'US1840042327' => 'Concorde Hills',
		'US1840012572' => 'Bloomingburg',
		'US1840012024' => 'Mount Gilead',
		'US1840009371' => 'Orrville',
		'US1840012475' => 'Thurston',
		'US1840012554' => 'Darbyville',
		'US1840010524' => 'Canal Winchester',
		'US1840000821' => 'Tiffin',
		'US1840001496' => 'Zanesville',
		'US1840024151' => 'Hessville',
		'US1840012584' => 'Laurelville',
		'US1840011883' => 'Lucas',
		'US1840005755' => 'The Plains',
		'US1840073813' => 'Rome',
		'US1840011760' => 'Pandora',
		'US1840008290' => 'North Canton',
		'US1840011715' => 'Spencer',
		'US1840026552' => 'Duncan Falls',
		'US1840012619' => 'Port William',
		'US1840012142' => 'Martinsburg',
		'US1840000926' => 'Campbell',
		'US1840012518' => 'Graysville',
		'US1840026486' => 'Sandyville',
		'US1840011706' => 'Greenwich',
		'US1840010631' => 'Clarksville',
		'US1840007128' => 'Cortland',
		'US1840010468' => 'Castine',
		'US1840004899' => 'Mineral Ridge',
		'US1840011517' => 'South Russell',
		'US1840003410' => 'Rocky River',
		'US1840011524' => 'Stryker',
		'US1840011711' => 'Wakeman',
		'US1840012484' => 'New Straitsville',
		'US1840007355' => 'Athens',
		'US1840012085' => 'Barnhill',
		'US1840011995' => 'Leesville',
		'US1840042385' => 'Taylor Creek',
		'US1840139259' => 'New Haven',
		'US1840011716' => 'Westfield Center',
		'US1840012497' => 'Verona',
		'US1840011546' => 'Bairdstown',
		'US1840010507' => 'Tipp City',
		'US1840012775' => 'Gallipolis',
		'US1840003760' => 'Columbus',
		'US1840001544' => 'Belpre',
		'US1840011911' => 'Limaville',
		'US1840010348' => 'Burbank',
		'US1840000803' => 'Stow',
		'US1840026649' => 'Millfield',
		'US1840011778' => 'Lowellville',
		'US1840010409' => 'Amsterdam',
		'US1840012408' => 'Obetz',
		'US1840024149' => 'McKinley Heights',
		'US1840034124' => 'Northridge',
		'US1840011672' => 'Peninsula',
		'US1840026310' => 'Stony Ridge',
		'US1840000568' => 'Harbor View',
		'US1840073815' => 'Matamoras',
		'US1840000965' => 'Massillon',
		'US1840012250' => 'Rossburg',
		'US1840003407' => 'Parma Heights',
		'US1840001618' => 'Woodlawn',
		'US1840012089' => 'Port Washington',
		'US1840012029' => 'Morral',
		'US1840012081' => 'Glenmont',
		'US1840012393' => 'Roseville',
		'US1840005880' => 'Dent',
		'US1840012483' => 'New Lexington',
		'US1840009317' => 'Ravenna',
		'US1840012465' => 'Dexter City',
		'US1840011720' => 'Republic',
		'US1840012072' => 'New Knoxville',
		'US1840011521' => 'Edon',
		'US1840000654' => 'Bellevue',
		'US1840011591' => 'Kipton',
		'US1840011758' => 'Ottawa',
		'US1840010350' => 'Van Wert',
		'US1840012096' => 'Stone Creek',
		'US1840011744' => 'Mount Cory',
		'US1840025603' => 'Kings Mills',
		'US1840011713' => 'Gloria Glens Park',
		'US1840010234' => 'Vermilion',
		'US1840012373' => 'Laura',
		'US1840008332' => 'Marion',
		'US1840000792' => 'Barberton',
		'US1840043000' => 'Lake Waynoka',
		'US1840000817' => 'Norwalk',
		'US1840003393' => 'Highland Hills',
		'US1840010565' => 'Caldwell',
		'US1840034148' => 'Crystal Lakes',
		'US1840012073' => 'Uniopolis',
		'US1840006140' => 'Burlington',
		'US1840010486' => 'Buckeye Lake',
		'US1840009573' => 'Springboro',
		'US1840012026' => 'Green Camp',
		'US1840000594' => 'Brook Park',
		'US1840042970' => 'Cinnamon Lake',
		'US1840011890' => 'Wharton',
		'US1840011520' => 'Edgerton',
		'US1840034253' => 'Drexel',
		'US1840024153' => 'Whites Landing',
		'US1840012439' => 'Tremont City',
		'US1840034109' => 'Finneytown',
		'US1840012435' => 'Enon',
		'US1840012152' => 'De Graff',
		'US1840012672' => 'South Salem',
		'US1840011885' => 'Harpster',
		'US1840005200' => 'Greentown',
		'US1840012253' => 'North Star',
		'US1840001622' => 'Wellston',
		'US1840024518' => 'New Baltimore',
		'US1840012203' => 'Ostrander',
		'US1840010302' => 'Antwerp',
		'US1840012215' => 'Hopedale',
		'US1840005184' => 'Maple Ridge',
		'US1840012469' => 'Lithopolis',
		'US1840012080' => 'Holmesville',
		'US1840008209' => 'Oberlin',
		'US1840010312' => 'Arcadia',
		'US1840000593' => 'Brooklyn Heights',
		'US1840008389' => 'Dublin',
		'US1840012717' => 'Higginsport',
		'US1840008466' => 'Franklin',
		'US1840012401' => 'Groveport',
		'US1840012556' => 'Orient',
		'US1840004904' => 'Churchill',
		'US1840034360' => 'The Village of Indian Hill',
		'US1840024247' => 'Kidron',
		'US1840010627' => 'Butlerville',
		'US1840003406' => 'Parma',
		'US1840012481' => 'Glenford',
		'US1840003784' => 'Moraine',
		'US1840026540' => 'Rosewood',
		'US1840012094' => 'Parral',
		'US1840026397' => 'Homeworth',
		'US1840012407' => 'New Albany',
		'US1840011610' => 'New Bavaria',
		'US1840010387' => 'Cardington',
		'US1840003802' => 'Fairfield',
		'US1840034242' => 'Bellville',
		'US1840003825' => 'Milford',
		'US1840000570' => 'Oregon',
		'US1840000960' => 'Mansfield',
		'US1840010538' => 'Catawba',
		'US1840012404' => 'Riverlea',
		'US1840011904' => 'Ohio City',
		'US1840026634' => 'Rockbridge',
		'US1840012607' => 'Millville',
		'US1840012474' => 'Sugar Grove',
		'US1840012155' => 'Russells Point',
		'US1840000598' => 'Cuyahoga Heights',
		'US1840001613' => 'Sharonville',
		'US1840026392' => 'Richville',
		'US1840012212' => 'Bowerston',
		'US1840026277' => 'Pulaski',
		'US1840005538' => 'North Zanesville',
		'US1840003404' => 'Olmsted Falls',
		'US1840012480' => 'Crooksville',
		'US1840011525' => 'West Unity',
		'US1840011516' => 'Middlefield',
		'US1840011563' => 'Walbridge',
		'US1840012403' => 'Lockbourne',
		'US1840012615' => 'Pleasant Plain',
		'US1840007369' => 'Chillicothe',
		'US1840003765' => 'Springfield',
		'US1840012705' => 'Bethel',
		'US1840012023' => 'Marengo',
		'US1840004902' => 'South Canal',
		'US1840010372' => 'Alger',
		'US1840003418' => 'Walton Hills',
		'US1840011724' => 'Latty',
		'US1840012478' => 'Hemlock',
		'US1840003820' => 'Golf Manor',
		'US1840012836' => 'Hanging Rock',
		'US1840034372' => 'Hilltop',
		'US1840026632' => 'Haydenville',
		'US1840011775' => 'Beloit',
		'US1840012436' => 'North Hampton',
		'US1840012117' => 'Bergholz',
		'US1840034397' => 'Lake Lakengren',
		'US1840012257' => 'Yorkshire',
		'US1840012499' => 'West Elkton',
		'US1840010582' => 'Trotwood',
		'US1840034084' => 'Parkman',
		'US1840026490' => 'Pottery Addition',
		'US1840012159' => 'West Mansfield',
		'US1840010355' => 'Cairo',
		'US1840026484' => 'Winesburg',
		'US1840010295' => 'Chippewa Lake',
		'US1840007345' => 'Carlisle',
		'US1840008548' => 'Jackson',
		'US1840011518' => 'Blakeslee',
		'US1840026520' => 'Kilbourne',
		'US1840026547' => 'Bannock',
		'US1840008256' => 'Kent',
		'US1840026635' => 'Little Hocking',
		'US1840011936' => 'Summitville',
		'US1840000646' => 'Sheffield',
		'US1840011674' => 'Hiram',
		'US1840003819' => 'Glendale',
		'US1840003338' => 'North Kingsville',
		'US1840003813' => 'Cheviot',
		'US1840012246' => 'Gordon',
		'US1840003817' => 'Evendale',
		'US1840012122' => 'Rayland',
		'US1840000808' => 'Streetsboro',
		'US1840011513' => 'Lyons',
		'US1840012090' => 'Roswell',
		'US1840034180' => 'Nettle Lake',
		'US1840011723' => 'Haviland',
		'US1840007265' => 'Hilliard',
		'US1840001609' => 'North College Hill',
		'US1840011806' => 'Mifflin',
		'US1840012707' => 'Moscow',
		'US1840003816' => 'Elmwood Place',
		'US1840012479' => 'Corning',
		'US1840012118' => 'Bloomingdale',
		'US1840007171' => 'Crestline',
		'US1840073787' => 'Vienna Center',
		'US1840003563' => 'Youngstown',
		'US1840000549' => 'Willowick',
		'US1840012196' => 'Russia',
		'US1840012028' => 'Prospect',
		'US1840011897' => 'Mount Eaton',
		'US1840000640' => 'Amherst',
		'US1840011900' => 'West Salem',
		'US1840026639' => 'Reno',
		'US1840073783' => 'Champion Heights',
		'US1840002784' => 'Wellsville',
		'US1840012200' => 'Warsaw',
		'US1840001616' => 'Terrace Park',
		'US1840003804' => 'Middletown',
		'US1840012568' => 'Malta',
		'US1840000963' => 'Canton',
		'US1840005544' => 'Huber Ridge',
		'US1840011415' => 'Jefferson',
		'US1840003821' => 'Greenhills',
		'US1840012528' => 'Spring Valley',
		'US1840011955' => 'Fort Shawnee',
		'US1840034386' => 'Howland Center',
		'US1840008355' => 'Marysville',
		'US1840024516' => 'Hooven',
		'US1840012625' => 'Coolville',
		'US1840003801' => 'Washington Court House',
		'US1840012612' => 'Corwin',
		'US1840012569' => 'McConnelsville',
		'US1840003398' => 'Bentleyville',
		'US1840000538' => 'Madison',
		'US1840012492' => 'Phillipsburg',
		'US1840011901' => 'Convoy',
		'US1840007172' => 'Delphos',
		'US1840010508' => 'Troy',
		'US1840011600' => 'Helena',
		'US1840012375' => 'Fletcher',
		'US1840012071' => 'New Bremen',
		'US1840012251' => 'New Madison',
		'US1840026267' => 'Williston',
		'US1840003409' => 'Richmond Heights',
		'US1840011550' => 'Haskins',
		'US1840011961' => 'Mount Victory',
		'US1840026550' => 'Lansing',
		'US1840011999' => 'Sherrodsville',
		'US1840026700' => 'Kanauga',
		'US1840011547' => 'Bloomdale',
		'US1840012355' => 'Fairview',
		'US1840034107' => 'Delhi Hills',
		'US1840012325' => 'Gratiot',
		'US1840012711' => 'Owensville',
		'US1840010708' => 'Cheshire',
		'US1840000807' => 'Garrettsville',
		'US1840010572' => 'Amanda',
		'US1840008254' => 'Green',
		'US1840000647' => 'Sheffield Lake',
		'US1840026389' => 'New Pittsburg',
		'US1840000600' => 'Euclid',
		'US1840000818' => 'Willard',
		'US1840042971' => 'Holiday Lakes',
		'US1840001611' => 'Reading',
		'US1840004901' => 'Masury',
		'US1840012696' => 'Mowrystown',
		'US1840003818' => 'Forest Park',
		'US1840010584' => 'Clayton',
		'US1840011887' => 'Marseilles',
		'US1840012553' => 'Commercial Point',
		'US1840008240' => 'Newton Falls',
		'US1840026399' => 'Negley',
		'US1840001545' => 'Marietta',
		'US1840012381' => 'Bellaire',
		'US1840000539' => 'Mentor',
		'US1840034279' => 'LaGrange',
		'US1840010219' => 'Chardon',
		'US1840012079' => 'Killbuck',
		'US1840026493' => 'Howard',
		'US1840034154' => 'Kenwood',
		'US1840034119' => 'Lake Milton',
		'US1840012476' => 'West Rushville',
		'US1840003399' => 'Newburgh Heights',
		'US1840012595' => 'Lowell',
		'US1840011721' => 'New Riegel',
		'US1840011899' => 'Smithville',
		'US1840012751' => 'Beaver',
		'US1840007308' => 'Centerville',
		'US1840012721' => 'Russellville',
		'US1840008255' => 'New Franklin',
		'US1840003785' => 'Oakwood',
		'US1840011754' => 'Fort Jennings',
		'US1840007046' => 'Ashtabula',
		'US1840026390' => 'Sterling',
		'US1840012082' => 'Millersburg',
		'US1840012520' => 'Lewisville',
		'US1840000790' => 'Mogadore',
		'US1840011595' => 'Wellington',
		'US1840000801' => 'Reminderville',
		'US1840011759' => 'Ottoville',
		'US1840034132' => 'Sawyerwood',
		'US1840012379' => 'West Milton',
		'US1840011565' => 'West Millgrove',
		'US1840007381' => 'Harrison',
		'US1840000589' => 'Bratenahl',
		'US1840011937' => 'Washingtonville',
		'US1840011606' => 'Deshler',
		'US1840011596' => 'McDonald',
		'US1840012216' => 'Deersville',
		'US1840010383' => 'Carrollton',
		'US1840008435' => 'Englewood',
		'US1840007264' => 'Grove City',
		'US1840010518' => 'Adamsville',
		'US1840011502' => 'Marblehead',
		'US1840012594' => 'Beverly',
		'US1840034382' => 'Day Heights',
		'US1840012004' => 'Mendon',
		'US1840026553' => 'East Fultonham',
		'US1840001546' => 'Lebanon',
		'US1840026388' => 'McCutchenville',
		'US1840026391' => 'North Lawrence',
		'US1840011935' => 'New Waterford',
		'US1840011562' => 'Tontogany',
		'US1840034224' => 'West Hill',
		'US1840011804' => 'Polk',
		'US1840012772' => 'Seaman',
		'US1840011523' => 'Pioneer',
		'US1840034082' => 'New California',
		'US1840140501' => 'Newport',
		'US1840012697' => 'Sinking Spring',
		'US1840034384' => 'Dry Run',
		'US1840012390' => 'Dresden',
		'US1840026353' => 'Old Fort',
		'US1840011905' => 'Willshire',
		'US1840012193' => 'Lockington',
		'US1840042992' => 'Lake Buckhorn',
		'US1840000644' => 'Lorain',
		'US1840012397' => 'South Zanesville',
		'US1840012482' => 'Rendville',
		'US1840034390' => 'Northgate',
		'US1840005877' => 'Grandview',
		'US1840007259' => 'Cambridge',
		'US1840000569' => 'Maumee',
		'US1840010347' => 'Carey',
		'US1840012095' => 'Zoar',
		'US1840012150' => 'Lakeview',
		'US1840026265' => 'Curtice',
		'US1840010218' => 'Burton',
		'US1840012519' => 'Jerusalem',
		'US1840011749' => 'Leipsic',
		'US1840026633' => 'Hide-A-Way Hills',
		'US1840012486' => 'Somerset',
		'US1840011604' => 'Liberty Center',
		'US1840006052' => 'Franklin Furnace',
		'US1840001645' => 'New Boston',
		'US1840012358' => 'Old Washington',
		'US1840002783' => 'East Liverpool',
		'US1840034400' => 'Rocky Fork Point',
		'US1840026510' => 'Canal Lewisville',
		'US1840000645' => 'North Ridgeville',
		'US1840000605' => 'Highland Heights',
		'US1840011779' => 'New Middletown',
		'US1840026308' => 'Crystal Rock',
		'US1840009374' => 'Salem',
		'US1840005539' => 'Pleasant Grove',
		'US1840010570' => 'Bremen',
		'US1840003402' => 'North Royalton',
		'US1840011891' => 'Congress',
		'US1840012525' => 'Bowersville',
		'US1840026419' => 'Lake Mohawk',
		'US1840026375' => 'Vaughnsville',
		'US1840024460' => 'Darrtown',
		'US1840026551' => 'Wolfhurst',
		'US1840034110' => 'Forestville',
		'US1840011608' => 'Malinta',
		'US1840034233' => 'Miami Heights',
		'US1840042321' => 'Coldstream',
		'US1840012526' => 'Jamestown',
		'US1840042965' => 'Candlewood Lake',
		'US1840003814' => 'Cincinnati',
		'US1840008467' => 'Mason',
		'US1840000820' => 'Fostoria',
		'US1840010408' => 'Adena',
		'US1840010267' => 'Burgoon',
		'US1840001619' => 'Wyoming',
		'US1840010388' => 'Chesterville',
		'US1840026675' => 'Cynthiana',
		'US1840011743' => 'Mount Blanchard',
		'US1840012191' => 'Jackson Center',
		'US1840000608' => 'Lakewood',
		'US1840011544' => 'Berlin Heights',
		'US1840000603' => 'Gates Mills',
		'US1840012750' => 'Syracuse',
		'US1840010516' => 'Bridgeport',
		'US1840012585' => 'Murray City',
		'US1840012158' => 'West Liberty',
		'US1840000613' => 'Mayfield Heights',
		'US1840026386' => 'Oceola',
		'US1840011893' => 'Dalton',
		'US1840003810' => 'Amberley',
		'US1840026549' => 'Lafferty',
		'US1840011707' => 'Plymouth',
		'US1840073812' => 'Gann',
		'US1840011997' => 'Magnolia',
		'US1840008366' => 'Greenville',
		'US1840003395' => 'Beachwood',
		'US1840012747' => 'Racine',
		'US1840008292' => 'East Palestine',
		'US1840034351' => 'Rose Farm',
		'US1840000606' => 'Hunting Valley',
		'US1840011519' => 'Holiday City',
		'US1840011930' => 'Hanoverton',
		'US1840012626' => 'Glouster',
		'US1840006055' => 'Sciotodale',
		'US1840010487' => 'Alexandria',
		'US1840011902' => 'Elgin',
		'US1840011909' => 'Beach City',
		'US1840012126' => 'New Alexandria',
		'US1840011501' => 'Rocky Ridge',
		'US1840005891' => 'Mount Repose',
		'US1840026266' => 'Lakeside',
		'US1840011558' => 'Millbury',
		'US1840003485' => 'Brunswick',
		'US1840012099' => 'Tuscarawas',
		'US1840007311' => 'Wilberforce',
		'US1840012613' => 'Maineville',
		'US1840034146' => 'Landen',
		'US1840010495' => 'Byesville',
		'US1840003396' => 'Bedford',
		'US1840003417' => 'Valley View',
		'US1840003822' => 'Lincoln Heights',
		'US1840011745' => 'Van Buren',
		'US1840026427' => 'New Hampshire',
		'US1840012786' => 'Rarden',
		'US1840011557' => 'Luckey',
		'US1840012774' => 'Crown City',
		'US1840012252' => 'New Weston',
		'US1840003762' => 'Upper Arlington',
		'US1840007210' => 'Celina',
		'US1840004905' => 'Ballville',
		'US1840012749' => 'Middleport',
		'US1840026676' => 'Stockdale',
		'US1840000541' => 'North Perry',
		'US1840012620' => 'Sabina',
		'US1840011898' => 'Shreve',
		'US1840012689' => 'Wilkesville',
		'US1840011742' => 'McComb',
		'US1840025622' => 'Camp Dennison',
		'US1840026607' => 'Hannibal',
		'US1840012074' => 'Waynesfield',
		'US1840034135' => 'Summerside',
		'US1840012256' => 'Pitsburg',
		'US1840009566' => 'Logan',
		'US1840011907' => 'Scott',
		'US1840012154' => 'Rushsylvania',
		'US1840012575' => 'Octa',
		'US1840034373' => 'Hunter',
		'US1840011952' => 'Harrod',
		'US1840009572' => 'Oxford',
		'US1840059955' => 'West Carrollton',
		'US1840000573' => 'Bryan',
		'US1840026352' => 'Melmore',
		'US1840012748' => 'Rutland',
		'US1840011500' => 'Genoa',
		'US1840026701' => 'Friendship',
		'US1840026674' => 'Tuppers Plains',
		'US1840034265' => 'Fruit Hill',
		'US1840003414' => 'South Euclid',
		'US1840012688' => 'Zaleski',
		'US1840000588' => 'Berea',
		'US1840040317' => 'Kinsman Center',
		'US1840012434' => 'Donnelsville',
		'US1840000543' => 'Perry',
		'US1840034078' => 'Loveland Park',
		'US1840012153' => 'Quincy',
		'US1840004896' => 'Eaton Estates',
		'US1840012204' => 'Shawnee Hills',
		'US1840011590' => 'Grafton',
		'US1840012395' => 'Norwich',
		'US1840010593' => 'Antioch',
		'US1840010606' => 'Chesterhill',
		'US1840012380' => 'Barnesville',
		'US1840012213' => 'Harrisville',
		'US1840012125' => 'Mount Pleasant',
		'US1840012330' => 'Hebron',
		'US1840005878' => 'Groesbeck',
		'US1840003411' => 'Seven Hills',
		'US1840012746' => 'Pomeroy',
		'US1840011738' => 'Arlington',
		'US1840003433' => 'Sandusky',
		'US1840009468' => 'St. Clairsville',
		'US1840011755' => 'Gilboa',
		'US1840012027' => 'La Rue',
		'US1840011597' => 'Yankee Lake',
		'US1840034161' => 'Salem Heights',
		'US1840012702' => 'North Bend',
		'US1840011499' => 'Elmore',
		'US1840008253' => 'Fairlawn',
		'US1840012522' => 'Wilson',
		'US1840012744' => 'Coalton',
		'US1840011593' => 'Rochester',
		'US1840008145' => 'Geneva',
		'US1840011748' => 'Kalida',
		'US1840011646' => 'Sherwood',
		'US1840010346' => 'Upper Sandusky',
		'US1840012558' => 'South Bloomfield',
		'US1840011549' => 'Grand Rapids',
		'US1840011962' => 'Patterson',
		'US1840034249' => 'Dayton',
		'US1840034389' => 'Mount Healthy Heights',
		'US1840073790' => 'Wright-Patterson AFB',
		'US1840000592' => 'Brooklyn',
		'US1840026494' => 'East Liberty',
		'US1840012248' => 'Hollansburg',
		'US1840010235' => 'Castalia',
		'US1840012494' => 'Lewisburg',
		'US1840000591' => 'Broadview Heights',
		'US1840011477' => 'Berkey',
		'US1840001612' => 'St. Bernard',
		'US1840011919' => 'Waynesburg',
		'US1840034134' => 'Skyline Acres',
		'US1840011645' => 'Ney',
		'US1840012377' => 'Ludlow Falls',
		'US1840012573' => 'Jeffersonville',
		'US1840011564' => 'Wayne',
		'US1840003416' => 'University Heights',
		'US1840011934' => 'Salineville',
		'US1840012493' => 'Gratis',
		'US1840012623' => 'New Vienna',
		'US1840003339' => 'Roaming Shores',
		'US1840012723' => 'Sardinia',
		'US1840024466' => 'Andersonville',
		'US1840140541' => 'Vincent',
		'US1840011884' => 'Shiloh',
		'US1840011932' => 'Lisbon',
		'US1840010685' => 'Aberdeen',
		'US1840012574' => 'Milledgeville',
		'US1840008436' => 'Miamisburg',
		'US1840000572' => 'Toledo',
		'US1840034394' => 'Pleasant Run Farm',
		'US1840011951' => 'Bluffton',
		'US1840011561' => 'Pemberville',
		'US1840003397' => 'Bedford Heights',
		'US1840012353' => 'Lore City',
		'US1840012083' => 'Nashville',
		'US1840026650' => 'New Marshfield',
		'US1840000547' => 'Willoughby',
		'US1840026307' => 'Beulah Beach',
		'US1840008440' => 'Fairborn',
		'US1840026539' => 'Etna',
		'US1840010300' => 'Broughton',
		'US1840012098' => 'Sugarcreek',
		'US1840007170' => 'Bucyrus',
		'US1840026275' => 'Alvordton',
		'US1840011761' => 'West Leipsic',
		'US1840026608' => 'Sardis',
		'US1840012218' => 'New Athens',
		'US1840000642' => 'Avon Lake',
		'US1840012468' => 'Baltimore',
		'US1840026658' => 'Bourneville',
		'US1840010217' => 'Wauseon',
		'US1840026387' => 'Sulphur Springs',
		'US1840012716' => 'Hamersville',
		'US1840034375' => 'Olde West Chester',
		'US1840012086' => 'Bolivar',
		'US1840011548' => 'Bradner',
		'US1840012092' => 'Mineral City',
		'US1840008241' => 'Niles',
		'US1840010571' => 'Carroll',
		'US1840012557' => 'Williamsport',
		'US1840011950' => 'Beaverdam',
		'US1840004823' => 'Chesterland',
		'US1840073767' => 'Montrose-Ghent',
		'US1840012693' => 'Leesburg',
		'US1840034381' => 'Choctaw Lake',
		'US1840005748' => 'Ross',
		'US1840006054' => 'Rosemount',
		'US1840012003' => 'St. Henry',
		'US1840034100' => 'Bridgetown',
		'US1840011554' => 'Cygnet',
		'US1840012359' => 'Pleasant City',
		'US1840010639' => 'Albany',
		'US1840012194' => 'Fort Loramie',
		'US1840073760' => 'Granville South',
		'US1840011886' => 'Kirby',
		'US1840026576' => 'Plumwood',
		'US1840012773' => 'West Union',
		'US1840024150' => 'Morgandale',
		'US1840003421' => 'Woodmere',
		'US1840011708' => 'Monroeville',
		'US1840011998' => 'Malvern',
		'US1840000809' => 'Sugar Bush Knolls',
		'US1840010509' => 'Casstown',
		'US1840011872' => 'New Washington',
		'US1840011601' => 'Gibsonburg',
		'US1840012614' => 'Morrow',
		'US1840012140' => 'Gambier',
		'US1840012471' => 'Rushville',
		'US1840010637' => 'Buchtel',
		'US1840012500' => 'West Manchester',
		'US1840010391' => 'Wapakoneta',
		'US1840034151' => 'Elizabethtown',
		'US1840011217' => 'Put-in-Bay',
		'US1840011503' => 'Oak Harbor',
		'US1840012025' => 'Sparta',
		'US1840026276' => 'Kunkle',
		'US1840010652' => 'Clarksburg',
		'US1840026483' => 'Walnut Creek',
		'US1840012199' => 'Plainfield',
		'US1840011556' => 'Risingsun',
		'US1840000623' => 'Perrysburg',
		'US1840011916' => 'Minerva',
		'US1840000653' => 'Fremont',
		'US1840034183' => 'St. Martin',
		'US1840012624' => 'Jacksonville',
		'US1840011560' => 'North Baltimore',
		'US1840012130' => 'Tiltonsville',
		'US1840000927' => 'Sebring',
		'US1840011717' => 'Attica',
		'US1840000651' => 'Lordstown',
		'US1840008239' => 'Girard',
		'US1840004900' => 'Leavittsburg',
		'US1840026340' => 'Atwater',
		'US1840000571' => 'Ottawa Hills',
		'US1840003782' => 'Huber Heights',
		'US1840010393' => 'Uhrichsville',
		'US1840010392' => 'Buckland',
		'US1840001419' => 'Newark',
		'US1840012521' => 'Miltonsburg',
		'US1840000804' => 'Tallmadge',
		'US1840034401' => 'Highland Holiday',
		'US1840010440' => 'Anna',
		'US1840011559' => 'Milton Center',
		'US1840011739' => 'Benton Ridge',
		'US1840034326' => 'Mount Carmel',
		'US1840012328' => 'Johnstown',
		'US1840011605' => 'Holgate',
		'US1840011417' => 'Rock Creek',
		'US1840003812' => 'Blue Ash',
		'US1840012356' => 'Quaker City',
		'US1840026572' => 'Darbydale',
		'US1840000794' => 'Clinton',
		'US1840008513' => 'Greenfield',
		'US1840011895' => 'Fredericksburg',
		'US1840011522' => 'Montpelier',
		'US1840009255' => 'Sylvania',
		'US1840012405' => 'Marble Cliff',
		'US1840012487' => 'Thornville',
		'US1840009370' => 'Ontario',
		'US1840034079' => 'Mack',
		'US1840012597' => 'Macksburg',
		'US1840010638' => 'Chauncey',
		'US1840011719' => 'Bloomville',
		'US1840026396' => 'East Rochester',
		'US1840026404' => 'Dola',
		'US1840012618' => 'Blanchester',
		'US1840011609' => 'McClure',
		'US1840007233' => 'Bellefontaine',
		'US1840026495' => 'Lewistown',
		'US1840026629' => 'Pancoastburg',
		'US1840012498' => 'West Alexandria',
		'US1840034160' => 'Pleasant Run',
		'US1840007390' => 'Withamsville',
		'US1840010220' => 'Aquilla',
		'US1840004797' => 'Edgewood',
		'US1840010597' => 'Cedarville',
		'US1840026606' => 'Thornport',
		'US1840007095' => 'Huron',
		'US1840000612' => 'Mayfield',
		'US1840012835' => 'Athalia',
		'US1840012376' => 'Potsdam',
		'US1840034142' => 'Williamsdale',
		'US1840026351' => 'Kansas',
		'US1840003486' => 'Medina',
		'US1840012326' => 'Hanover',
		'US1840012467' => 'Summerfield',
		'US1840005222' => 'Glenmoor',
		'US1840026269' => 'Tedrow',
		'US1840001418' => 'Heath',
		'US1840011511' => 'Delta',
		'US1840011953' => 'Lafayette',
		'US1840004903' => 'Brookfield Center',
		'US1840034164' => 'White Oak',
		'US1840012718' => 'Fayetteville',
		'US1840026543' => 'Buffalo',
		'US1840012417' => 'Mount Sterling',
		'US1840009473' => 'Reynoldsburg',
		'US1840026342' => 'Celeryville',
		'US1840011896' => 'Marshallville',
		'US1840010681' => 'Amelia',
		'US1840008607' => 'Ironton',
		'US1840026638' => 'Waterford',
		'US1840012472' => 'Millersport',
		'US1840034226' => 'Covedale',
		'US1840011741' => 'Rawson',
		'US1840024515' => 'Dunlap',
		'US1840012706' => 'Felicity',
		'US1840012608' => 'New Miami',
		'US1840026612' => 'Derby',
		'US1840012088' => 'Gnadenhutten',
		'US1840034376' => 'Wetherington',
		'US1840011912' => 'Hills and Dales',
		'US1840012357' => 'Salesville',
		'US1840042360' => 'Delshire',
		'US1840000615' => 'Moreland Hills',
		'US1840034145' => 'Holiday Valley',
		'US1840012021' => 'Edison',
		'US1840011480' => 'Whitehouse',
		'US1840012488' => 'Farmersville',
		'US1840012123' => 'Richmond',
		'US1840034159' => 'Plainville',
		'US1840026343' => 'Collins',
		'US1840010344' => 'Chatfield',
		'US1840026393' => 'Robertsville',
		'US1840034374' => 'Maplewood Park',
		'US1840012710' => 'Newtonsville',
		'US1840012621' => 'Martinsville',
		'US1840008388' => 'Martins Ferry',
		'US1840012022' => 'Fulton',
		'US1840003759' => 'Bexley',
		'US1840002751' => 'Ashland',
		'US1840000590' => 'Brecksville',
		'US1840003337' => 'Conneaut',
		'US1840002785' => 'Lima',
		'US1840001615' => 'Springdale',
		'US1840007138' => 'Hudson',
		'US1840008401' => 'New Carlisle',
		'US1840012374' => 'Covington',
		'US1840010345' => 'Butler',
		'US1840010672' => 'Cleves',
		'US1840003415' => 'Strongsville',
		'US1840011512' => 'Fayette',
		'US1840000622' => 'Northwood',
		'US1840011728' => 'Payne',
		'US1840003783' => 'Kettering',
		'US1840012524' => 'Stafford',
		'US1840000819' => 'Green Springs',
		'US1840011710' => 'North Fairfield',
		'US1840010517' => 'Brookside',
		'US1840012745' => 'Oak Hill',
		'US1840012712' => 'Williamsburg',
		'US1840011958' => 'Forest',
		'US1840007163' => 'Canfield',
		'US1840012124' => 'Mingo Junction',
		'US1840001343' => 'Mount Vernon',
		'US1840011436' => 'Fairport Harbor',
		'US1840034287' => 'Mitiwanga',
		'US1840034325' => 'Monfort Heights',
		'US1840012331' => 'St. Louisville',
		'US1840034392' => 'Park Layne',
		'US1840003413' => 'Solon',
		'US1840012069' => 'Cridersville',
		'US1840011954' => 'Elida',
		'US1840011555' => 'Portage',
		'US1840000599' => 'East Cleveland',
		'US1840034113' => 'Goshen',
		'US1840012201' => 'West Lafayette',
		'US1840012156' => 'Zanesfield',
		'US1840026496' => 'Raymond',
		'US1840012245' => 'Arcanum',
		'US1840012669' => 'Bainbridge',
		'US1840010522' => 'Worthington',
		'US1840012258' => 'Union City',
		'US1840003815' => 'Deer Park',
		'US1840034396' => 'Stony Prairie',
		'US1840012402' => 'Harrisburg',
		'US1840024520' => 'Remington',
		'US1840010385' => 'Chickasaw',
		'US1840139258' => 'New Burlington',
		'US1840012752' => 'Piketon',
		'US1840003432' => 'Kelleys Island',
		'US1840012386' => 'Powhatan Point',
		'US1840012190' => 'Botkins',
		'US1840012627' => 'Trimble',
		'US1840026492' => 'Bladensburg',
		'US1840011757' => 'Miller City',
		'US1840012385' => 'Flushing',
		'US1840011747' => 'Belmore',
		'US1840012391' => 'Frazeysburg',
		'US1840010294' => 'Wadsworth',
		'US1840006053' => 'Lucasville',
		'US1840003786' => 'Vandalia',
		'US1840005879' => 'Cherry Grove',
		'US1840012695' => 'Lynchburg',
		'US1840001281' => 'New Philadelphia',
		'US1840010445' => 'Cadiz',
		'US1840008482' => 'Nelsonville',
		'US1840003809' => 'Loveland',
		'US1840024152' => 'Vickery',
		'US1840005224' => 'Calcutta',
		'US1840026521' => 'Radnor',
		'US1840012091' => 'Midvale',
		'US1840010706' => 'Cherry Fork',
		'US1840011931' => 'Leetonia',
		'US1840012255' => 'Palestine',
		'US1840000800' => 'Norton',
		'US1840012719' => 'Georgetown',
		'US1840011805' => 'Loudonville',
		'US1840002752' => 'Galion',
		'US1840026522' => 'Tippecanoe',
		'US1840011543' => 'Bay View',
		'US1840011910' => 'Hartville',
		'US1840011478' => 'Holland',
		'US1840011960' => 'McGuffey',
		'US1840034393' => 'Pigeon Creek',
		'US1840034075' => 'Five Points',
		'US1840000610' => 'Lyndhurst',
		'US1840003790' => 'Xenia',
		'US1840012070' => 'Minster',
		'US1840005223' => 'La Croft',
		'US1840010420' => 'Centerburg',
		'US1840011714' => 'Seville',
		'US1840010301' => 'Cecil',
		'US1840004801' => 'North Madison',
		'US1840011918' => 'Wilmot',
		'US1840011802' => 'Hayesville',
		'US1840008521' => 'Montgomery',
		'US1840034130' => 'Pleasant Hills',
		'US1840003420' => 'Westlake',
		'US1840011756' => 'Glandorf',
		'US1840012378' => 'Pleasant Hill',
		'US1840034185' => 'Wayne Lakes',
		'US1840011675' => 'Mantua',
		'US1840012489' => 'Germantown',
		'US1840012463' => 'Batesville',
		'US1840001606' => 'Mariemont',
		'US1840012776' => 'Rio Grande',
		'US1840012517' => 'Beallsville',
		'US1840026348' => 'Bascom',
		'US1840034072' => 'Clarktown',
		'US1840011603' => 'Hamler',
		'US1840012769' => 'Manchester',
		'US1840011776' => 'Craig Beach',
		'US1840034380' => 'Bolindale',
		'US1840012709' => 'New Richmond',
		'US1840011874' => 'Tiro',
		'US1840012606' => 'College Corner',
		'US1840009369' => 'Shelby',
		'US1840026648' => 'Hockingport',
		'US1840000961' => 'Wooster',
		'US1840000793' => 'Boston Heights',
		'US1840043288' => 'Pheasant Run',
		'US1840010592' => 'Clarington',
		'US1840012384' => 'Holloway',
		'US1840010630' => 'Wilmington',
		'US1840026244' => 'Austinburg',
		'US1840012720' => 'Ripley',
		'US1840003419' => 'Warrensville Heights',
		'US1840011917' => 'Navarre',
		'US1840011956' => 'Spencerville',
		'US1840005500' => 'Harbor Hills',
		'US1840010172' => 'Andover',
		'US1840012334' => 'Mechanicsburg',
		'US1840005185' => 'Austintown',
		'US1840011416' => 'Geneva-on-the-Lake',
		'US1840012559' => 'Tarlton',
		'US1840012671' => 'Frankfort',
		'US1840026485' => 'Dundee',
		'US1840001341' => 'Steubenville',
		'US1840011725' => 'Melrose',
		'US1840000652' => 'Warren',
		'US1840007422' => 'Wheelersburg',
		'US1840026628' => 'Good Hope',
		'US1840012171' => 'Richwood',
		'US1840000641' => 'Avon',
		'US1840034378' => 'Beechwood Trails',
		'US1840012129' => 'Stratton',
		'US1840012694' => 'Highland',
		'US1840012596' => 'Lower Salem',
		'US1840007133' => 'Defiance',
		'US1840012704' => 'Batavia',
		'US1840034321' => 'Valley City',
		'US1840000546' => 'Wickliffe',
		'US1840012687' => 'McArthur',
		'US1840012622' => 'Midland',
		'US1840024514' => 'Brecon',
		'US1840012198' => 'Nellie',
		'US1840026631' => 'Carbon Hill',
		'US1840034306' => 'Rossmoyne',
		'US1840011671' => 'Richfield',
		'US1840012151' => 'Huntsville',
		'US1840000545' => 'Waite Hill',
		'US1840000542' => 'Painesville',
		'US1840034291' => 'Mulberry',
		'US1840008242' => 'Napoleon',
		'US1840000536' => 'Kirtland Hills',
		'US1840012217' => 'Freeport',
		'US1840000621' => 'Bowling Green',
		'US1840004956' => 'Portage Lakes',
		'US1840001519' => 'Eaton',
		'US1840026350' => 'Fort Seneca',
		'US1840000795' => 'Cuyahoga Falls',
		'US1840011718' => 'Bettsville',
		'US1840012409' => 'Urbancrest',
		'US1840026659' => 'Richmond Dale',
		'US1840011914' => 'East Sparta',
		'US1840034156' => 'Mentor-on-the-Lake',
		'US1840034188' => 'Bailey Lakes',
		'US1840007130' => 'Hubbard',
		'US1840012157' => 'Valley Hi',
		'US1840009372' => 'Rittman',
		'US1840026702' => 'McDermott',
		'US1840011510' => 'Archbold',
		'US1840012332' => 'Utica',
		'US1840009430' => 'Powell',
		'US1840012419' => 'South Solon',
		'US1840011594' => 'South Amherst',
		'US1840000643' => 'Elyria',
		'US1840140435' => 'Connorville',
		'US1840003707' => 'Sunbury',
		'US1840026511' => 'Fresno',
		'US1840000604' => 'Glenwillow',
		'US1840026278' => 'Lake Seneca',
		'US1840011903' => 'Middle Point',
		'US1840000601' => 'Fairview Park',
		'US1840012787' => 'Otway',
		'US1840003706' => 'Ashley',
		'US1840011959' => 'Ridgeway',
		'US1840012396' => 'Philo',
		'US1840003401' => 'North Randall',
		'US1840003803' => 'Hamilton',
		'US1840012173' => 'Milford Center',
		'US1840004957' => 'Brimfield',
		'US1840011808' => 'Savannah',
		'US1840011906' => 'Wren',
		'US1840012470' => 'Pleasantville',
		'US1840012552' => 'Ashville',
		'US1840011551' => 'Jerry City',
		'US1840010673' => 'Addyston',
		'US1840012771' => 'Winchester',
		'US1840000602' => 'Garfield Heights',
		'US1840012392' => 'Fultonham',
		'US1840012495' => 'Eldorado',
		'US1840007131' => 'Clyde',
		'US1840010371' => 'Ada',
		'US1840034258' => 'East Springfield',
		'US1840000534' => 'Grand River',
		'US1840012214' => 'Jewett',
		'US1840026426' => 'Iberia',
		'US1840012030' => 'New Bloomington',
		'US1840011602' => 'Woodville',
		'US1840073822' => 'Valleyview',
		'US1840011673' => 'Brady Lake',
		'US1840005523' => 'Neffs',
		'US1840000548' => 'Willoughby Hills',
		'US1840000596' => 'Cleveland',
		'US1840012121' => 'Empire',
		'US1840007237' => 'Delaware',
		'US1840012247' => 'Ithaca',
		'US1840034398' => 'Twinsburg Heights',
		'US1840007317' => 'Circleville',
		'US1840026538' => 'Marne',
		'US1840012708' => 'Neville',
		'US1840003412' => 'Shaker Heights',
		'US1840000962' => 'Alliance',
		'US1840034388' => 'Lincoln Village',
		'US1840010598' => 'Clifton',
		'US1840010585' => 'Camden',
		'US1840040315' => 'Four Bridges',
		'US1840009408' => 'St. Marys',
		'US1840026309' => 'Rudolph',
		'US1840011598' => 'West Farmington',
		'US1840000597' => 'Cleveland Heights',
		'US1840011752' => 'Continental',
		'US1840008465' => 'Monroe',
		'US1840010523' => 'Brice',
		'US1840000886' => 'Findlay',
		'US1840026491' => 'Apple Valley',
		'US1840001608' => 'Newtown',
		'US1840012195' => 'Port Jefferson',
		'US1840012336' => 'North Lewisburg',
		'US1840012670' => 'Kingston',
		'US1840012617' => 'Waynesville',
		'US1840011566' => 'Weston',
		'US1840010489' => 'Christiansburg',
		'US1840012335' => 'Mutual',
		'US1840012605' => 'Jacksonburg',
		'US1840011727' => 'Paulding',
		'US1840026695' => 'Bentonville',
		'US1840034219' => 'Westminster',
		'US1840011803' => 'Jeromesville',
		'US1840012219' => 'Scio',
		'US1840007313' => 'Bellbrook',
		'US1840034179' => 'Marlboro',
		'US1840001614' => 'Silverton',
		'US1840024154' => 'Wightmans Grove',
		'US1840005561' => 'Fairfield Beach',
	],
	'UT' => [
		'US1840022379' => 'Trenton',
		'US1840018745' => 'Bluffdale',
		'US1840020132' => 'Roy',
		'US1840024185' => 'Marion',
		'US1840018947' => 'Kanab',
		'US1840020115' => 'Providence',
		'US1840020142' => 'Farmington',
		'US1840020111' => 'Mendon',
		'US1840018752' => 'Spring Lake',
		'US1840026403' => 'Jensen',
		'US1840018832' => 'Aurora',
		'US1840022376' => 'Paradise',
		'US1840021353' => 'West Bountiful',
		'US1840021397' => 'Saratoga Springs',
		'US1840018701' => 'Bear River City',
		'US1840021352' => 'Syracuse',
		'US1840021481' => 'Koosharem',
		'US1840017593' => 'Aneth',
		'US1840022418' => 'Cedar Fort',
		'US1840020172' => 'Payson',
		'US1840020137' => 'Pleasant View',
		'US1840022459' => 'Meadow',
		'US1840020273' => 'Enoch',
		'US1840022458' => 'Lynndyl',
		'US1840021343' => 'Washington Terrace',
		'US1840020109' => 'Richmond',
		'US1840021350' => 'South Weber',
		'US1840037250' => 'Timber Lakes',
		'US1840018749' => 'Whiterocks',
		'US1840022515' => 'Torrey',
		'US1840018723' => 'Coalville',
		'US1840021564' => 'Leeds',
		'US1840020134' => 'North Ogden',
		'US1840022463' => 'Castle Valley',
		'US1840018722' => 'Samak',
		'US1840037177' => 'White City',
		'US1840018750' => 'Neola',
		'US1840020165' => 'Midway',
		'US1840037016' => 'Cache',
		'US1840022377' => 'Clarkston',
		'US1840022394' => 'Stockton',
		'US1840024372' => 'Spring Glen',
		'US1840020155' => 'Herriman',
		'US1840024109' => 'Thatcher',
		'US1840020110' => 'River Heights',
		'US1840022389' => 'Uintah',
		'US1840018746' => 'Cottonwood Heights',
		'US1840020200' => 'Helper',
		'US1840022559' => 'Springdale',
		'US1840021418' => 'Rocky Ridge',
		'US1840020174' => 'Provo',
		'US1840021401' => 'Fairfield',
		'US1840022419' => 'Vineyard',
		'US1840020272' => 'Panguitch',
		'US1840020113' => 'Nibley',
		'US1840020252' => 'Milford',
		'US1840021437' => 'Fayette',
		'US1840021388' => 'West Jordan',
		'US1840020144' => 'North Salt Lake',
		'US1840018877' => 'Blanding',
		'US1840021477' => 'Elsinore',
		'US1840026838' => 'Central',
		'US1840022412' => 'Tabiona',
		'US1840022416' => 'Hideout',
		'US1840024158' => 'Eden',
		'US1840018753' => 'Palmyra',
		'US1840020112' => 'Millville',
		'US1840026839' => 'Pine Valley',
		'US1840020162' => 'Roosevelt',
		'US1840021419' => 'Levan',
		'US1840020326' => 'Big Water',
		'US1840020138' => 'Morgan',
		'US1840037181' => 'Boulder',
		'US1840018739' => 'Dugway',
		'US1840018735' => 'Clearfield',
		'US1840021331' => 'Portage',
		'US1840037252' => 'White Mesa',
		'US1840018937' => 'Ivins',
		'US1840018757' => 'Eagle Mountain',
		'US1840026748' => 'Teasdale',
		'US1840021328' => 'Deweyville',
		'US1840022480' => 'Sigurd',
		'US1840018703' => 'Corinne',
		'US1840024270' => 'Bluebell',
		'US1840022460' => 'Oak City',
		'US1840021403' => 'Goshen',
		'US1840022530' => 'Cannonville',
		'US1840020108' => 'Logan',
		'US1840021383' => 'Salt Lake City',
		'US1840037176' => 'Stansbury Park',
		'US1840020166' => 'Elk Ridge',
		'US1840020204' => 'Fountain Green',
		'US1840021323' => 'Amalga',
		'US1840020139' => 'Oakley',
		'US1840022444' => 'Wales',
		'US1840018755' => 'Alpine',
		'US1840021456' => 'Hinckley',
		'US1840021561' => 'Washington',
		'US1840020170' => 'Mapleton',
		'US1840020146' => 'Grantsville',
		'US1840021357' => 'Wendover',
		'US1840021402' => 'Genola',
		'US1840021505' => 'Hanksville',
		'US1840022560' => 'Toquerville',
		'US1840024184' => 'Hoytsville',
		'US1840021329' => 'Elwood',
		'US1840037247' => 'Navajo Mountain',
		'US1840020217' => 'Huntington',
		'US1840020116' => 'Randolph',
		'US1840024371' => 'Kenilworth',
		'US1840037422' => 'Sandy',
		'US1840021354' => 'West Point',
		'US1840020119' => 'Perry',
		'US1840037251' => 'Tselakai Dezza',
		'US1840021394' => 'Daniel',
		'US1840037159' => 'Gunnison',
		'US1840021321' => 'Smithfield',
		'US1840022417' => 'Independence',
		'US1840024186' => 'Peoa',
		'US1840017503' => 'Benjamin',
		'US1840018748' => 'Randlett',
		'US1840021503' => 'Junction',
		'US1840024464' => 'Oasis',
		'US1840020215' => 'Ferron',
		'US1840037255' => 'Interlaken',
		'US1840022414' => 'Charleston',
		'US1840020107' => 'Lewiston',
		'US1840017594' => 'Bluff',
		'US1840021444' => 'Elmo',
		'US1840020208' => 'Mount Pleasant',
		'US1840020158' => 'Midvale',
		'US1840024465' => 'Sutherland',
		'US1840021400' => 'Woodland Hills',
		'US1840021560' => 'Santa Clara',
		'US1840020129' => 'Harrisville',
		'US1840020227' => 'Moab',
		'US1840021480' => 'Joseph',
		'US1840037254' => 'Dammeron Valley',
		'US1840020140' => 'Park City',
		'US1840026789' => 'Summit',
		'US1840021457' => 'Holden',
		'US1840018747' => 'Draper',
		'US1840020168' => 'Lehi',
		'US1840020156' => 'Holladay',
		'US1840020161' => 'Ballard',
		'US1840018875' => 'Montezuma Creek',
		'US1840021358' => 'Rush Valley',
		'US1840021436' => 'Spring City',
		'US1840020145' => 'Layton',
		'US1840021322' => 'Wellsville',
		'US1840021478' => 'Redmond',
		'US1840024260' => 'Bonanza',
		'US1840021325' => 'Laketown',
		'US1840021524' => 'Hatch',
		'US1840020114' => 'North Logan',
		'US1840021568' => 'Alton',
		'US1840020201' => 'Price',
		'US1840021342' => 'South Ogden',
		'US1840021399' => 'Springville',
		'US1840022381' => 'Mantua',
		'US1840018874' => 'Mexican Hat',
		'US1840026840' => 'Veyo',
		'US1840022441' => 'Mayfield',
		'US1840021351' => 'Sunset',
		'US1840020314' => 'Enterprise',
		'US1840021398' => 'Spanish Fork',
		'US1840021525' => 'Henrieville',
		'US1840020169' => 'Lindon',
		'US1840022558' => 'New Harmony',
		'US1840020218' => 'Orangeville',
		'US1840018809' => 'Delta',
		'US1840037164' => 'Liberty',
		'US1840018799' => 'Castle Dale',
		'US1840001674' => 'Bryce Canyon City',
		'US1840022531' => 'Tropic',
		'US1840022461' => 'Scipio',
		'US1840022447' => 'Clawson',
		'US1840037249' => 'Spanish Valley',
		'US1840021526' => 'Brian Head',
		'US1840020143' => 'Fruit Heights',
		'US1840020203' => 'Fairview',
		'US1840020130' => 'Hooper',
		'US1840021459' => 'Leamington',
		'US1840018702' => 'Brigham City',
		'US1840021386' => 'South Salt Lake',
		'US1840041657' => 'Flaming Gorge',
		'US1840041658' => 'Silver Summit',
		'US1840021396' => 'Santaquin',
		'US1840018738' => 'Kaysville',
		'US1840021569' => 'Glendale',
		'US1840074515' => 'Oljato-Monument Valley',
		'US1840024369' => 'Carbonville',
		'US1840021523' => 'Antimony',
		'US1840021327' => 'Willard',
		'US1840021347' => 'Henefer',
		'US1840018698' => 'Hyde Park',
		'US1840022395' => 'Vernon',
		'US1840017475' => 'Avon',
		'US1840017478' => 'Garden',
		'US1840022442' => 'Centerfield',
		'US1840073914' => 'Elberta',
		'US1840021559' => 'St. George',
		'US1840020167' => 'Highland',
		'US1840020224' => 'Fillmore',
		'US1840017499' => 'Magna',
		'US1840024252' => 'Copperton',
		'US1840074861' => 'Heber',
		'US1840021507' => 'Lyman',
		'US1840022537' => 'Paragonah',
		'US1840021344' => 'West Haven',
		'US1840020315' => 'Hildale',
		'US1840037245' => 'Halchita',
		'US1840017476' => 'Benson',
		'US1840020160' => 'Naples',
		'US1840021504' => 'Kingston',
		'US1840021345' => 'Huntsville',
		'US1840022380' => 'Woodruff',
		'US1840020159' => 'Murray',
		'US1840020216' => 'Green River',
		'US1840018699' => 'Hyrum',
		'US1840020187' => 'Mona',
		'US1840024172' => 'Mountain Green',
		'US1840021385' => 'South Jordan',
		'US1840020271' => 'Escalante',
		'US1840021324' => 'Garden City',
		'US1840021391' => 'Vernal',
		'US1840021332' => 'Fielding',
		'US1840021355' => 'Woods Cross',
		'US1840021390' => 'Alta',
		'US1840018857' => 'Beaver',
		'US1840018734' => 'Centerville',
		'US1840017596' => 'La Sal',
		'US1840020240' => 'Monroe',
		'US1840020173' => 'Pleasant Grove',
		'US1840021475' => 'Salina',
		'US1840018724' => 'Woodland',
		'US1840024463' => 'Deseret',
		'US1840022409' => 'Manila',
		'US1840022443' => 'Sterling',
		'US1840020136' => 'Plain City',
		'US1840026747' => 'Fremont',
		'US1840020257' => 'Monticello',
		'US1840022479' => 'Central Valley',
		'US1840037162' => 'La Verkin',
		'US1840018726' => 'Kamas',
		'US1840021435' => 'Wellington',
		'US1840020186' => 'Eureka',
		'US1840020256' => 'Bicknell',
		'US1840020131' => 'Riverdale',
		'US1840024242' => 'Dutch John',
		'US1840022375' => 'Newton',
		'US1840022382' => 'Snowville',
		'US1840020207' => 'Moroni',
		'US1840020274' => 'Parowan',
		'US1840021389' => 'West Valley City',
		'US1840018744' => 'Millcreek',
		'US1840021392' => 'Altamont',
		'US1840018700' => 'Riverside',
		'US1840022378' => 'Cornish',
		'US1840022508' => 'Minersville',
		'US1840021356' => 'Tooele',
		'US1840037156' => 'Granite',
		'US1840018756' => 'American Fork',
		'US1840020163' => 'Myton',
		'US1840018754' => 'Cedar Hills',
		'US1840018895' => 'Cedar City',
		'US1840018751' => 'Duchesne',
		'US1840021333' => 'Howell',
		'US1840022415' => 'Wallsburg',
		'US1840018725' => 'Summit Park',
		'US1840021479' => 'Glenwood',
		'US1840022448' => 'Cleveland',
		'US1840074547' => 'Peter',
		'US1840026787' => 'Beryl Junction',
		'US1840017502' => 'Fort Duchesne',
		'US1840018936' => 'Hurricane',
		'US1840022564' => 'Orderville',
		'US1840022440' => 'Scofield',
		'US1840020133' => 'Marriott-Slaterville',
		'US1840020202' => 'Ephraim',
		'US1840022514' => 'Circleville',
		'US1840017500' => 'Kearns',
		'US1840020206' => 'Manti',
		'US1840041676' => 'West Wood',
		'US1840021346' => 'Francis',
		'US1840020171' => 'Orem',
		'US1840024467' => 'Thompson Springs',
		'US1840018736' => 'Clinton',
		'US1840018737' => 'Bountiful',
		'US1840021506' => 'Loa',
		'US1840017595' => 'Halls Crossing',
		'US1840022561' => 'Virgin',
		'US1840024187' => 'Snyderville',
		'US1840021387' => 'Taylorsville',
		'US1840037253' => 'West Mountain',
		'US1840021563' => 'Rockville',
		'US1840021562' => 'Apple Valley',
		'US1840021458' => 'Kanosh',
		'US1840020157' => 'Riverton',
		'US1840022393' => 'Ophir',
		'US1840020188' => 'Nephi',
		'US1840021330' => 'Plymouth',
		'US1840020239' => 'Richfield',
		'US1840017495' => 'Erda',
		'US1840021527' => 'Kanarraville',
		'US1840021395' => 'Salem',
		'US1840017504' => 'Lake Shore',
		'US1840022513' => 'Marysvale',
		'US1840024183' => 'Echo',
		'US1840024370' => 'Clear Creek',
		'US1840024188' => 'Wanship',
		'US1840037239' => 'Wolf Creek',
		'US1840026788' => 'Newcastle',
		'US1840020117' => 'Garland',
		'US1840037248' => 'South Willard',
		'US1840021476' => 'Annabella',
		'US1840017474' => 'Cove',
		'US1840017501' => 'Maeser',
		'US1840020118' => 'Honeyville',
		'US1840020135' => 'Ogden',
		'US1840021445' => 'Emery',
		'US1840021326' => 'Tremonton',
		'US1840041631' => 'Emigration Canyon',
		'US1840020128' => 'Farr West',
	],
	'MO' => [
		'US1840010490' => 'Trenton',
		'US1840008539' => 'Levasy',
		'US1840010718' => 'West Alton',
		'US1840008589' => 'Green Park',
		'US1840010891' => 'Grand Falls Plaza',
		'US1840008537' => 'Lake Tapawingo',
		'US1840008679' => 'Edgar Springs',
		'US1840009565' => 'Paris',
		'US1840008514' => 'Farber',
		'US1840007473' => 'Hermann',
		'US1840012145' => 'Worth',
		'US1840008653' => 'Kimmswick',
		'US1840009893' => 'Summersville',
		'US1840007636' => 'Aurora',
		'US1840010626' => 'Annada',
		'US1840007371' => 'Avondale',
		'US1840007672' => 'Homestown',
		'US1840025753' => 'Wasola',
		'US1840012766' => 'Windsor Place',
		'US1840013045' => 'Dennis Acres',
		'US1840007357' => 'Houston Lake',
		'US1840008347' => 'Fairfax',
		'US1840013016' => 'Duquesne',
		'US1840008781' => 'Miller',
		'US1840008659' => 'Eldon',
		'US1840073756' => 'Fort Leonard Wood',
		'US1840009713' => 'Pilot Grove',
		'US1840008502' => 'Liberty',
		'US1840008689' => 'Leadwood',
		'US1840007667' => 'Hornersville',
		'US1840025743' => 'South Fork',
		'US1840009946' => 'Pineville',
		'US1840008790' => 'East Prairie',
		'US1840008686' => 'Farmington',
		'US1840007596' => 'Bunker',
		'US1840008796' => 'Exeter',
		'US1840010860' => 'Whitewater',
		'US1840008660' => 'Lake Ozark',
		'US1840010886' => 'Anniston',
		'US1840008391' => 'Gallatin',
		'US1840009934' => 'Seligman',
		'US1840025715' => 'Brewer',
		'US1840007372' => 'Holt',
		'US1840010889' => 'Ritchey',
		'US1840008745' => 'Norwood',
		'US1840007392' => 'Centralia',
		'US1840012583' => 'Stoutsville',
		'US1840007272' => 'Bevier',
		'US1840009679' => 'Lone Jack',
		'US1840025542' => 'Phelps City',
		'US1840012132' => 'Livonia',
		'US1840073797' => 'St. John',
		'US1840009417' => 'Skidmore',
		'US1840007660' => 'Hollister',
		'US1840010410' => 'Unionville',
		'US1840006237' => 'Barnhart',
		'US1840009678' => 'McBaine',
		'US1840010771' => 'Westphalia',
		'US1840010876' => 'Fidelity',
		'US1840009945' => 'Rockaway Beach',
		'US1840012144' => 'Denver',
		'US1840025727' => 'Cherokee Pass',
		'US1840012242' => 'Osgood',
		'US1840013035' => 'Lambert',
		'US1840007266' => 'Coffey',
		'US1840025695' => 'Doe Run',
		'US1840010687' => 'Hartsburg',
		'US1840009812' => 'Rockville',
		'US1840006126' => 'Concord',
		'US1840032227' => 'Cobalt',
		'US1840008361' => 'Milan',
		'US1840008794' => 'Galena',
		'US1840025586' => 'Dawn',
		'US1840008572' => 'Lake St. Louis',
		'US1840032155' => 'Lees Summit',
		'US1840010851' => 'Urbana',
		'US1840007668' => 'Cooter',
		'US1840008534' => 'Independence',
		'US1840009796' => 'Taos',
		'US1840007304' => 'Clarence',
		'US1840007441' => 'Country Club Hills',
		'US1840032036' => 'Country Club',
		'US1840013030' => 'Hoberg',
		'US1840025737' => 'Montier',
		'US1840007306' => 'Hannibal',
		'US1840008348' => 'Elmo',
		'US1840012820' => 'Glen Echo Park',
		'US1840012863' => 'Parkway',
		'US1840010414' => 'Quitman',
		'US1840009591' => 'Platte City',
		'US1840009888' => 'Burgess',
		'US1840025629' => 'Danville',
		'US1840009487' => 'Linneus',
		'US1840009944' => 'Catron',
		'US1840009785' => 'Peculiar',
		'US1840009415' => 'Princeton',
		'US1840007230' => 'Bethany',
		'US1840007356' => 'Camden Point',
		'US1840008734' => 'Ellington',
		'US1840007385' => 'Concordia',
		'US1840008687' => 'Iron Mountain Lake',
		'US1840012700' => 'Vandiver',
		'US1840008554' => 'Jonesburg',
		'US1840007386' => 'Corder',
		'US1840008540' => 'Elsberry',
		'US1840010411' => 'Westboro',
		'US1840007420' => 'Boonville',
		'US1840012864' => 'Freeburg',
		'US1840009626' => 'Dover',
		'US1840008486' => 'Fleming',
		'US1840009741' => 'Shrewsbury',
		'US1840008690' => 'Nevada',
		'US1840073793' => 'Greencastle',
		'US1840010403' => 'Wyaconda',
		'US1840007406' => 'Bellflower',
		'US1840008714' => 'Fair Play',
		'US1840009753' => 'Stoutland',
		'US1840008574' => 'Green Ridge',
		'US1840008800' => 'Gideon',
		'US1840012138' => 'Blythedale',
		'US1840009486' => 'Macon',
		'US1840009932' => 'Blue Eye',
		'US1840012960' => 'Deerfield',
		'US1840012136' => 'Watson',
		'US1840032057' => 'Glen Allen',
		'US1840008400' => 'La Plata',
		'US1840008528' => 'Lexington',
		'US1840009892' => 'Licking',
		'US1840007448' => 'Bella Villa',
		'US1840007664' => 'Cardwell',
		'US1840012680' => 'Oakwood Park',
		'US1840008448' => 'New London',
		'US1840009632' => 'Sturgeon',
		'US1840012991' => 'Goodnight',
		'US1840009519' => 'Shelbina',
		'US1840008346' => 'Lancaster',
		'US1840013054' => 'Arrow Point',
		'US1840010690' => 'Winfield',
		'US1840007654' => 'Cassville',
		'US1840008519' => 'Glasgow',
		'US1840008727' => 'Lamar',
		'US1840007544' => 'Bloomsdale',
		'US1840007572' => 'Altenburg',
		'US1840010825' => 'Caledonia',
		'US1840012818' => 'Hillsdale',
		'US1840008592' => 'Normandy',
		'US1840010537' => 'Ethel',
		'US1840008394' => 'Fillmore',
		'US1840009643' => 'Sullivan',
		'US1840007273' => 'Bucklin',
		'US1840007450' => 'Berkeley',
		'US1840012729' => 'Fountain N Lakes',
		'US1840010840' => 'Wheatland',
		'US1840007436' => 'Clarksburg',
		'US1840006119' => 'Lemay',
		'US1840007428' => 'Dardenne Prairie',
		'US1840010402' => 'Wayland',
		'US1840010769' => 'Union',
		'US1840013034' => 'Kelso',
		'US1840008808' => 'Noel',
		'US1840009557' => 'Plattsburg',
		'US1840012996' => 'Junction City',
		'US1840008536' => 'Lake Lotawana',
		'US1840007417' => 'Holts Summit',
		'US1840013036' => 'Commerce',
		'US1840010425' => 'Sheridan',
		'US1840008349' => 'Maryville',
		'US1840012571' => 'Turney',
		'US1840009943' => 'Risco',
		'US1840009890' => 'Oak Ridge',
		'US1840009809' => 'Olympian Village',
		'US1840008515' => 'Mexico',
		'US1840009680' => 'Sugar Creek',
		'US1840012633' => 'Elmira',
		'US1840012634' => 'Excelsior Estates',
		'US1840012840' => 'Baldwin Park',
		'US1840010896' => 'Washburn',
		'US1840025698' => 'Wortham',
		'US1840007519' => 'Belle',
		'US1840008581' => 'Ellisville',
		'US1840009923' => 'Scott City',
		'US1840012979' => 'Lithium',
		'US1840008674' => 'Irondale',
		'US1840008535' => 'Kansas City',
		'US1840012908' => 'Parkdale',
		'US1840013033' => 'Haywood City',
		'US1840025560' => 'Edinburg',
		'US1840010412' => 'South Lineville',
		'US1840010887' => 'West Plains',
		'US1840008393' => 'Jamesport',
		'US1840008578' => 'Leeton',
		'US1840025745' => 'Golden',
		'US1840009697' => 'Middletown',
		'US1840008739' => 'Everton',
		'US1840007223' => 'Alexandria',
		'US1840012674' => 'Birmingham',
		'US1840007663' => 'Campbell',
		'US1840009769' => 'Richmond Heights',
		'US1840008744' => 'Mountain Grove',
		'US1840009850' => 'St. James',
		'US1840007342' => 'Clarksville',
		'US1840010526' => 'Altamont',
		'US1840009615' => 'Malta Bend',
		'US1840009942' => 'Portageville',
		'US1840007554' => 'Hermitage',
		'US1840007443' => 'Creve Coeur',
		'US1840042719' => 'Grayhawk',
		'US1840009436' => 'Stanberry',
		'US1840007455' => 'Dellwood',
		'US1840007461' => 'Creighton',
		'US1840007616' => 'Battlefield',
		'US1840012765' => 'Lake Mykee Town',
		'US1840010898' => 'Butterfield',
		'US1840010854' => 'Aldrich',
		'US1840010742' => 'Vinita Park',
		'US1840012815' => 'Bel-Nor',
		'US1840008622' => 'New Haven',
		'US1840012981' => 'Umber View Heights',
		'US1840013058' => 'Merriam Woods',
		'US1840007640' => 'Bell City',
		'US1840006118' => 'Glasgow Village',
		'US1840007670' => 'Hayti',
		'US1840010871' => 'Winona',
		'US1840009940' => 'Tallapoosa',
		'US1840008501' => 'Kearney',
		'US1840008552' => 'New Florence',
		'US1840009421' => 'Mount Moriah',
		'US1840009490' => 'Osborn',
		'US1840009453' => 'Spickard',
		'US1840025750' => 'Kissee Mills',
		'US1840008509' => 'Marshall',
		'US1840010717' => 'Wentzville',
		'US1840009559' => 'Salisbury',
		'US1840007513' => 'Amsterdam',
		'US1840007343' => 'Curryville',
		'US1840010609' => 'Triplett',
		'US1840007661' => 'Anderson',
		'US1840007442' => 'Crestwood',
		'US1840032135' => 'Jane',
		'US1840010743' => 'Warson Woods',
		'US1840012116' => 'Granger',
		'US1840009714' => 'Prairie Home',
		'US1840007322' => 'Brunswick',
		'US1840009816' => 'Olean',
		'US1840009927' => 'Seneca',
		'US1840008729' => 'Liberal',
		'US1840007334' => 'Bogard',
		'US1840013051' => 'Indian Point',
		'US1840009740' => 'Maplewood',
		'US1840012944' => 'Vista',
		'US1840009681' => 'Raytown',
		'US1840010413' => 'Pickering',
		'US1840009906' => 'Republic',
		'US1840009935' => 'Poplar Bluff',
		'US1840007438' => 'Clarkson Valley',
		'US1840012821' => 'Riverview',
		'US1840009412' => 'Queen City',
		'US1840012982' => 'Evergreen',
		'US1840010862' => 'Raymondville',
		'US1840012462' => 'Leonard',
		'US1840008789' => 'Nixa',
		'US1840010904' => 'Wardell',
		'US1840007358' => 'Dearborn',
		'US1840008402' => 'Marceline',
		'US1840010642' => 'Weatherby Lake',
		'US1840013029' => 'Halltown',
		'US1840025697' => 'Terre du Lac',
		'US1840009560' => 'Dalton',
		'US1840012961' => 'Milo',
		'US1840009810' => 'Pevely',
		'US1840007360' => 'Crystal Lakes',
		'US1840008446' => 'Mendon',
		'US1840013052' => 'Coney Island',
		'US1840007552' => 'Desloge',
		'US1840008483' => 'Edgerton',
		'US1840008608' => 'Drexel',
		'US1840013040' => 'Penermon',
		'US1840007362' => 'Henrietta',
		'US1840008527' => 'Lake Lafayette',
		'US1840012581' => 'Holliday',
		'US1840007267' => 'Bolckow',
		'US1840073788' => 'Whiteman AFB',
		'US1840009592' => 'Platte Woods',
		'US1840010698' => 'Rhineland',
		'US1840007418' => 'Bunceton',
		'US1840009815' => 'Brumley',
		'US1840010745' => 'Wellston',
		'US1840010861' => 'Allenville',
		'US1840010869' => 'Walnut Grove',
		'US1840012677' => 'Oaks',
		'US1840006523' => 'Shell Knob',
		'US1840009813' => 'Passaic',
		'US1840007335' => 'Bosworth',
		'US1840007431' => 'Houstonia',
		'US1840008441' => 'Easton',
		'US1840010691' => 'Chain of Rocks',
		'US1840012727' => 'Sibley',
		'US1840009914' => 'Brooklyn Heights',
		'US1840007557' => 'Dixon',
		'US1840009720' => 'St. Paul',
		'US1840008518' => 'Franklin',
		'US1840009634' => 'Centertown',
		'US1840007446' => 'Chesterfield',
		'US1840032081' => 'Montreal',
		'US1840009873' => 'Stockton',
		'US1840009941' => 'Parma',
		'US1840013057' => 'Kirbyville',
		'US1840007650' => 'Brandsville',
		'US1840008593' => 'Northwoods',
		'US1840007419' => 'Blackwater',
		'US1840013061' => 'Theodosia',
		'US1840012995' => 'Milford',
		'US1840009456' => 'Oregon',
		'US1840012631' => 'Ridgely',
		'US1840009898' => 'Mansfield',
		'US1840025664' => 'Hartwell',
		'US1840007374' => 'Blackburn',
		'US1840005482' => 'Brashear',
		'US1840008496' => 'Gladstone',
		'US1840008809' => 'Kennett',
		'US1840007274' => 'Clarksdale',
		'US1840008726' => 'Mindenmines',
		'US1840009865' => 'Richland',
		'US1840007302' => 'Chillicothe',
		'US1840009904' => 'Springfield',
		'US1840012461' => 'Bethel',
		'US1840009872' => 'Longtown',
		'US1840010716' => 'Weldon Spring',
		'US1840025726' => 'Irwin',
		'US1840012816' => 'Bel-Ridge',
		'US1840010610' => 'Sumner',
		'US1840008730' => 'Fredericktown',
		'US1840010843' => 'Stotesbury',
		'US1840012998' => 'Dutchtown',
		'US1840008403' => 'Meadville',
		'US1840013013' => 'Dadeville',
		'US1840012949' => 'Leasburg',
		'US1840012632' => 'Homestead',
		'US1840008381' => 'Forest City',
		'US1840012825' => 'Uplands Park',
		'US1840012807' => 'Pendleton',
		'US1840007508' => 'Hillsboro',
		'US1840010401' => 'Revere',
		'US1840009842' => 'Lowry City',
		'US1840010619' => 'Cairo',
		'US1840025628' => 'Big Spring',
		'US1840012817' => 'Hanley Hills',
		'US1840010824' => 'Gerster',
		'US1840009520' => 'Shelbyville',
		'US1840008735' => 'Jackson',
		'US1840013031' => 'Freistatt',
		'US1840010540' => 'Union Star',
		'US1840007435' => 'California',
		'US1840007639' => 'Advance',
		'US1840013032' => 'Blodgett',
		'US1840007648' => 'Charleston',
		'US1840012994' => 'Des Arc',
		'US1840012993' => 'Flemington',
		'US1840008591' => 'Maryland Heights',
		'US1840009696' => 'McKittrick',
		'US1840007434' => 'Holden',
		'US1840008553' => 'Montgomery City',
		'US1840007505' => 'Crystal City',
		'US1840013037' => 'Diehlstadt',
		'US1840009457' => 'Corning',
		'US1840007397' => 'Greenwood',
		'US1840007254' => 'Hurdland',
		'US1840005552' => 'Browning',
		'US1840009718' => 'Portage Des Sioux',
		'US1840010805' => 'Scotsdale',
		'US1840007257' => 'Craig',
		'US1840010838' => 'Preston',
		'US1840010699' => 'Wellsville',
		'US1840010527' => 'Amazonia',
		'US1840010791' => 'Windsor',
		'US1840010795' => 'Warsaw',
		'US1840009618' => 'Martinsburg',
		'US1840007258' => 'Canton',
		'US1840010901' => 'Goodman',
		'US1840008499' => 'Missouri City',
		'US1840007388' => 'Bates City',
		'US1840010883' => 'Verona',
		'US1840010641' => 'Tracy',
		'US1840007653' => 'Hurley',
		'US1840009564' => 'Madison',
		'US1840012983' => 'Phillipsburg',
		'US1840010744' => 'Webster Groves',
		'US1840007398' => 'Hawk Point',
		'US1840010689' => 'Troy',
		'US1840039631' => 'LaBarque Creek',
		'US1840008757' => 'Fair Grove',
		'US1840008797' => 'Monett',
		'US1840008382' => 'Mound City',
		'US1840007447' => 'Ballwin',
		'US1840012823' => 'Marlborough',
		'US1840010890' => 'Fairview',
		'US1840007389' => 'Higginsville',
		'US1840007600' => 'Cabool',
		'US1840009843' => 'Osceola',
		'US1840007507' => 'Herculaneum',
		'US1840012831' => 'Wilbur Park',
		'US1840008586' => 'Florissant',
		'US1840007449' => 'Bellefontaine Neighbors',
		'US1840007305' => 'Hunnewell',
		'US1840012918' => 'St. Elizabeth',
		'US1840007643' => 'Dexter',
		'US1840009905' => 'Strafford',
		'US1840010870' => 'Willard',
		'US1840042715' => 'Blanchard',
		'US1840013043' => 'Wilson City',
		'US1840006127' => 'Breckenridge Hills',
		'US1840009930' => 'Newtonia',
		'US1840010663' => 'Arrow Rock',
		'US1840007439' => 'Clayton',
		'US1840007541' => 'Doolittle',
		'US1840008451' => 'Monroe City',
		'US1840010644' => 'Wood Heights',
		'US1840009771' => 'St. Ann',
		'US1840007601' => 'Houston',
		'US1840009931' => 'Reeds Spring',
		'US1840009919' => 'Stotts City',
		'US1840007632' => 'Asbury',
		'US1840009556' => 'Polo',
		'US1840010839' => 'Weaubleau',
		'US1840007427' => 'Cottleville',
		'US1840012143' => 'Irena',
		'US1840010720' => 'Weldon Spring Heights',
		'US1840012305' => 'Millard',
		'US1840005589' => 'Breckenridge',
		'US1840008526' => 'Odessa',
		'US1840008562' => 'Mokane',
		'US1840008570' => 'New Melle',
		'US1840042195' => 'Peaceful Village',
		'US1840007416' => 'Auxvasse',
		'US1840007506' => 'Arnold',
		'US1840008768' => 'Duenweg',
		'US1840007476' => 'Chamois',
		'US1840025557' => 'Plevna',
		'US1840013062' => 'Ginger Blue',
		'US1840009605' => 'Smithville',
		'US1840007597' => 'Centerville',
		'US1840008688' => 'Leadington',
		'US1840009797' => 'Russellville',
		'US1840008520' => 'New Franklin',
		'US1840012679' => 'Oakwood',
		'US1840007583' => 'Annapolis',
		'US1840013011' => 'Sedgewickville',
		'US1840010737' => 'Grantwood Village',
		'US1840010893' => 'Shoal Creek Estates',
		'US1840007453' => 'Hazelwood',
		'US1840042728' => 'La Tour',
		'US1840010453' => 'Harris',
		'US1840012732' => 'Whiteside',
		'US1840010679' => 'Wellington',
		'US1840008399' => 'New Cambria',
		'US1840008615' => 'Jefferson City',
		'US1840012809' => 'Hughesville',
		'US1840012992' => 'Halfway',
		'US1840009858' => 'Sheldon',
		'US1840008791' => 'Mountain View',
		'US1840010417' => 'Guilford',
		'US1840007333' => 'Carrollton',
		'US1840013048' => 'Shoal Creek Drive',
		'US1840009474' => 'Pattonsburg',
		'US1840007270' => 'Callao',
		'US1840032256' => 'Village of Four Seasons',
		'US1840006238' => 'Cedar Hill',
		'US1840008599' => 'Ladue',
		'US1840008711' => 'Lebanon',
		'US1840009644' => 'Pacific',
		'US1840012131' => 'Glenwood',
		'US1840042726' => 'Lake Viking',
		'US1840008784' => 'Dudley',
		'US1840008596' => 'Jennings',
		'US1840009846' => 'Potosi',
		'US1840008709' => 'Frohna',
		'US1840007228' => 'Hopkins',
		'US1840025714' => 'Biehle',
		'US1840009879' => 'Pilot Knob',
		'US1840008371' => 'Novinger',
		'US1840008771' => 'Joplin',
		'US1840010688' => 'Huntsdale',
		'US1840007475' => 'Berger',
		'US1840008398' => 'Elmer',
		'US1840008785' => 'Essex',
		'US1840008770' => 'Jasper',
		'US1840009938' => 'Koshkonong',
		'US1840012681' => 'Grand Pass',
		'US1840009924' => 'Puxico',
		'US1840008575' => 'La Monte',
		'US1840012951' => 'West Sullivan',
		'US1840008585' => 'Flordell Hills',
		'US1840008620' => 'Morrison',
		'US1840008383' => 'Ewing',
		'US1840010748' => 'Woodson Terrace',
		'US1840009742' => 'Sunset Hills',
		'US1840010724' => 'Tipton',
		'US1840007451' => 'Beverly Hills',
		'US1840007638' => 'Benton',
		'US1840009518' => 'Ludlow',
		'US1840007551' => 'Bonne Terre',
		'US1840009878' => 'Salem',
		'US1840007615' => 'Ash Grove',
		'US1840010894' => 'Stark City',
		'US1840009933' => 'Purdy',
		'US1840010897' => 'Wheaton',
		'US1840012675' => 'Prathersville',
		'US1840012827' => 'Twin Oaks',
		'US1840008561' => 'New Bloomfield',
		'US1840009455' => 'Maitland',
		'US1840012731' => 'Truxton',
		'US1840008511' => 'Nelson',
		'US1840009922' => 'Oran',
		'US1840007452' => 'Black Jack',
		'US1840008542' => 'Moscow Mills',
		'US1840008524' => 'Mayview',
		'US1840039632' => 'Old Jamestown',
		'US1840007321' => 'Cameron',
		'US1840008600' => 'Lakeshire',
		'US1840007550' => 'Bismarck',
		'US1840007520' => 'Camdenton',
		'US1840007662' => 'Clarkton',
		'US1840012916' => 'Foster',
		'US1840010678' => 'Waverly',
		'US1840009650' => 'Syracuse',
		'US1840007387' => 'Alma',
		'US1840008783' => 'Morley',
		'US1840009936' => 'Qulin',
		'US1840013053' => 'McCord Bend',
		'US1840010714' => 'Warrenton',
		'US1840007463' => 'Belton',
		'US1840007432' => 'Centerview',
		'US1840010719' => 'Augusta',
		'US1840012635' => 'Rayville',
		'US1840008776' => 'Greenville',
		'US1840006123' => 'Spanish Lake',
		'US1840006501' => 'Spokane',
		'US1840006236' => 'Murphy',
		'US1840008779' => 'Marionville',
		'US1840006121' => 'Oakville',
		'US1840010895' => 'Stella',
		'US1840009724' => 'Sedalia',
		'US1840015793' => 'Goss',
		'US1840009419' => 'Conception Junction',
		'US1840012703' => 'Aullville',
		'US1840009751' => 'Linn Creek',
		'US1840008571' => 'OFallon',
		'US1840008363' => 'King City',
		'US1840012240' => 'Humphreys',
		'US1840012241' => 'Pollock',
		'US1840013050' => 'Wentworth',
		'US1840009928' => 'Diamond',
		'US1840009719' => 'St. Charles',
		'US1840009476' => 'Rosendale',
		'US1840010884' => 'Van Buren',
		'US1840007456' => 'Des Peres',
		'US1840010807' => 'Hume',
		'US1840007631' => 'Alba',
		'US1840008769' => 'Neck City',
		'US1840009413' => 'Tarkio',
		'US1840009874' => 'Pleasant Hope',
		'US1840012842' => 'West Line',
		'US1840007504' => 'Byrnes Mill',
		'US1840009712' => 'Otterville',
		'US1840073821' => 'South Gifford',
		'US1840009773' => 'Norwood Court',
		'US1840007646' => 'Highlandville',
		'US1840009642' => 'Rosebud',
		'US1840008531' => 'Grain Valley',
		'US1840010746' => 'Wildwood',
		'US1840025716' => 'Bennett Springs',
		'US1840007227' => 'Barnard',
		'US1840010772' => 'Argyle',
		'US1840008350' => 'New Hampton',
		'US1840012243' => 'Darlington',
		'US1840007493' => 'Blairstown',
		'US1840008621' => 'Gerald',
		'US1840012808' => 'Josephville',
		'US1840009811' => 'Rich Hill',
		'US1840009677' => 'Rocheport',
		'US1840025540' => 'St. Francisville',
		'US1840025741' => 'Hunter',
		'US1840009866' => 'St. Robert',
		'US1840006317' => 'Bronaugh',
		'US1840008500' => 'Mosby',
		'US1840008568' => 'Flint Hill',
		'US1840005588' => 'Braymer',
		'US1840008743' => 'Niangua',
		'US1840008798' => 'Fisk',
		'US1840012822' => 'Mackenzie',
		'US1840008580' => 'Edmundson',
		'US1840008772' => 'La Russell',
		'US1840012676' => 'Randolph',
		'US1840009563' => 'Perry',
		'US1840007637' => 'Chaffee',
		'US1840025744' => 'Eagle Rock',
		'US1840010721' => 'Warrensburg',
		'US1840009814' => 'Bagnell',
		'US1840010418' => 'Arkoe',
		'US1840007495' => 'Cole Camp',
		'US1840008802' => 'Matthews',
		'US1840009768' => 'Pine Lawn',
		'US1840007658' => 'Doniphan',
		'US1840010541' => 'Weatherby',
		'US1840012917' => 'Merwin',
		'US1840008447' => 'Keytesville',
		'US1840007472' => 'Bland',
		'US1840012134' => 'Lucerne',
		'US1840008442' => 'Kidder',
		'US1840009916' => 'Piedmont',
		'US1840009616' => 'Mount Leonard',
		'US1840012730' => 'Silex',
		'US1840007225' => 'Burlington Junction',
		'US1840010888' => 'Willow Springs',
		'US1840012577' => 'Rensselaer',
		'US1840006120' => 'Mehlville',
		'US1840008378' => 'Galt',
		'US1840025728' => 'Mine La Motte',
		'US1840012351' => 'Bigelow',
		'US1840008582' => 'Eureka',
		'US1840009683' => 'Cave',
		'US1840012767' => 'Wooldridge',
		'US1840012841' => 'Gunn City',
		'US1840012980' => 'Jerico Springs',
		'US1840010766' => 'St. Thomas',
		'US1840008795' => 'Kimberling City',
		'US1840008787' => 'Grandin',
		'US1840008710' => 'El Dorado Springs',
		'US1840010855' => 'Viburnum',
		'US1840010419' => 'Eagleville',
		'US1840010739' => 'University City',
		'US1840009891' => 'Old Appleton',
		'US1840008613' => 'Lake Winnebago',
		'US1840035406' => 'South Gorin',
		'US1840007454' => 'Huntleigh',
		'US1840013041' => 'Saddlebrooke',
		'US1840012978' => 'Louisburg',
		'US1840010900' => 'Bull Creek',
		'US1840008372' => 'Kirksville',
		'US1840010902' => 'Rives',
		'US1840010562' => 'Wheeling',
		'US1840010878' => 'Webb City',
		'US1840008801' => 'Marston',
		'US1840012860' => 'Leslie',
		'US1840009937' => 'Thayer',
		'US1840007659' => 'Branson',
		'US1840007627' => 'Carl Junction',
		'US1840026644' => 'St. Clement',
		'US1840009606' => 'Pleasant Valley',
		'US1840042209' => 'Lake Tekakwitha',
		'US1840010899' => 'Chain-O-Lakes',
		'US1840025553' => 'Winigan',
		'US1840007226' => 'Clearmont',
		'US1840009948' => 'Malden',
		'US1840008806' => 'Forsyth',
		'US1840006129' => 'Bridgeton',
		'US1840009950' => 'Steele',
		'US1840007407' => 'High Hill',
		'US1840009613' => 'Slater',
		'US1840025739' => 'Grayridge',
		'US1840007649' => 'Bertrand',
		'US1840012604' => 'Tarrants',
		'US1840032056' => 'Gilman City',
		'US1840008805' => 'Naylor',
		'US1840007578' => 'Bolivar',
		'US1840012115' => 'Luray',
		'US1840008597' => 'Kinloch',
		'US1840007584' => 'Arcadia',
		'US1840009926' => 'Ozark',
		'US1840007494' => 'Deepwater',
		'US1840025693' => 'Ozora',
		'US1840025544' => 'Conception',
		'US1840010885' => 'Wyatt',
		'US1840012826' => 'Sycamore Hills',
		'US1840025746' => 'Harviell',
		'US1840006233' => 'High Ridge',
		'US1840008590' => 'Greendale',
		'US1840012725' => 'Pierpont',
		'US1840009649' => 'Stover',
		'US1840007240' => 'Albany',
		'US1840012862' => 'Oak Grove Village',
		'US1840010775' => 'Gravois Mills',
		'US1840010749' => 'Calverton Park',
		'US1840008609' => 'East Lynne',
		'US1840012352' => 'Monticello',
		'US1840012764' => 'Kingdom City',
		'US1840073803' => 'Bellerive Acres',
		'US1840010892' => 'Cliff Village',
		'US1840009859' => 'Schell City',
		'US1840010600' => 'Rushville',
		'US1840010713' => 'Truesdale',
		'US1840009784' => 'Strasburg',
		'US1840008362' => 'McFall',
		'US1840009925' => 'Sparta',
		'US1840008462' => 'Norborne',
		'US1840007579' => 'Humansville',
		'US1840009551' => 'Lewis and Clark Village',
		'US1840012576' => 'Rothville',
		'US1840025740' => 'Fremont',
		'US1840008508' => 'Emma',
		'US1840008445' => 'Lathrop',
		'US1840012600' => 'Jacksonville',
		'US1840008792' => 'Granby',
		'US1840013047' => 'Saginaw',
		'US1840001651' => 'St. Louis',
		'US1840008738' => 'Marble Hill',
		'US1840007553' => 'Cross Timbers',
		'US1840008652' => 'Festus',
		'US1840012824' => 'Pasadena Park',
		'US1840013042' => 'Pinhook',
		'US1840008788' => 'Fremont Hills',
		'US1840009949' => 'Senath',
		'US1840009770' => 'Rock Hill',
		'US1840010424' => 'Grant City',
		'US1840012698' => 'Benton City',
		'US1840012313' => 'Novelty',
		'US1840012312' => 'Newark',
		'US1840005551' => 'Brookfield',
		'US1840008728' => 'Lamar Heights',
		'US1840008541' => 'Foley',
		'US1840010426' => 'Allendale',
		'US1840007444' => 'Crystal Lake Park',
		'US1840009854' => 'Ste. Genevieve',
		'US1840009633' => 'St. Martins',
		'US1840009754' => 'Osage Beach',
		'US1840009897' => 'Rogersville',
		'US1840025747' => 'Thomasville',
		'US1840009920' => 'Pierce City',
		'US1840007394' => 'Hallsville',
		'US1840007492' => 'Clinton',
		'US1840008740' => 'Greenfield',
		'US1840009849' => 'Rolla',
		'US1840009723' => 'Smithton',
		'US1840007665' => 'Arbyrd',
		'US1840010525' => 'Jameson',
		'US1840042745' => 'Leisure Lake',
		'US1840013010' => 'Zalma',
		'US1840010816' => 'Vienna',
		'US1840008385' => 'La Grange',
		'US1840009590' => 'Parkville',
		'US1840010492' => 'Tindall',
		'US1840009646' => 'Linn',
		'US1840007599' => 'Delta',
		'US1840008741' => 'Fordland',
		'US1840009458' => 'Lewistown',
		'US1840007651' => 'Crane',
		'US1840009641' => 'Owensville',
		'US1840032259' => 'Charmwood',
		'US1840009911' => 'Purcell',
		'US1840009857' => 'Park Hills',
		'US1840007378' => 'Armstrong',
		'US1840009744' => 'Overland',
		'US1840010809' => 'Tuscumbia',
		'US1840012819' => 'Country Life Acres',
		'US1840010416' => 'Graham',
		'US1840025748' => 'Fairdealing',
		'US1840008807' => 'Gainesville',
		'US1840013046' => 'Redings Mill',
		'US1840008484' => 'Northmoor',
		'US1840007474' => 'Villa Ridge',
		'US1840025773' => 'Hayward',
		'US1840013055' => 'Emerald Beach',
		'US1840008498' => 'North Kansas City',
		'US1840008444' => 'Gower',
		'US1840012861' => 'Miramiguoa Park',
		'US1840010656' => 'Claycomo',
		'US1840007224' => 'Downing',
		'US1840010842' => 'Walker',
		'US1840007571' => 'Buffalo',
		'US1840012630' => 'Ferrelview',
		'US1840008782' => 'Miner',
		'US1840006160' => 'Gray Summit',
		'US1840012830' => 'Westwood',
		'US1840009416' => 'Mercer',
		'US1840010740' => 'Valley Park',
		'US1840008716' => 'Ironton',
		'US1840012829' => 'Vinita Terrace',
		'US1840008345' => 'Greentop',
		'US1840008566' => 'Marthasville',
		'US1840008485' => 'Lake Waukomis',
		'US1840012919' => 'Climax Springs',
		'US1840007319' => 'Cowgill',
		'US1840008533' => 'Oak Grove',
		'US1840012943' => 'Roscoe',
		'US1840007641' => 'Bernie',
		'US1840008374' => 'Edina',
		'US1840009798' => 'Brownington',
		'US1840009912' => 'Sarcoxie',
		'US1840012412' => 'Winston',
		'US1840009599' => 'Orrick',
		'US1840012628' => 'Iatan',
		'US1840007629' => 'Carthage',
		'US1840009600' => 'Richmond',
		'US1840012942' => 'Collins',
		'US1840012726' => 'River Bend',
		'US1840008343' => 'Kahoka',
		'US1840007253' => 'Baring',
		'US1840009913' => 'Avilla',
		'US1840009895' => 'Lockwood',
		'US1840013060' => 'Bakersfield',
		'US1840008560' => 'Fulton',
		'US1840007393' => 'Ashland',
		'US1840007652' => 'Branson West',
		'US1840007509' => 'De Soto',
		'US1840007338' => 'Clark',
		'US1840008405' => 'Maysville',
		'US1840010875' => 'Reeds',
		'US1840009682' => 'Old Monroe',
		'US1840008375' => 'Knox City',
		'US1840007510' => 'Butler',
		'US1840007644' => 'Clever',
		'US1840008804' => 'Morehouse',
		'US1840008517' => 'Fayette',
		'US1840010859' => 'Pocahontas',
		'US1840009743' => 'Olivette',
		'US1840024597' => 'Defiance',
		'US1840012601' => 'Renick',
		'US1840007556' => 'Crocker',
		'US1840009752' => 'Macks Creek',
		'US1840010494' => 'Fortescue',
		'US1840008516' => 'Laddonia',
		'US1840010415' => 'Ravenwood',
		'US1840010715' => 'Wright City',
		'US1840008780' => 'Mount Vernon',
		'US1840025742' => 'Pomona',
		'US1840012999' => 'Plato',
		'US1840007645' => 'Billings',
		'US1840010404' => 'Rutledge',
		'US1840008731' => 'Marquand',
		'US1840012865' => 'Laurie',
		'US1840007666' => 'Holcomb',
		'US1840012135' => 'Worthington',
		'US1840009489' => 'Stewartsville',
		'US1840012678' => 'Oakview',
		'US1840008610' => 'Freeman',
		'US1840010686' => 'Harrisburg',
		'US1840013056' => 'North Lilbourn',
		'US1840009929' => 'Loma Linda',
		'US1840007361' => 'Hardin',
		'US1840012920' => 'Sunrise Beach',
		'US1840012893' => 'La Due',
		'US1840007229' => 'Cainsville',
		'US1840022489' => 'Riverview Estates',
		'US1840025738' => 'Chesapeake',
		'US1840008495' => 'Excelsior Springs',
		'US1840007598' => 'Cape Girardeau',
		'US1840009860' => 'Metz',
		'US1840010607' => 'Trimble',
		'US1840008623' => 'Meta',
		'US1840013014' => 'South Greenfield',
		'US1840007671' => 'Hayti Heights',
		'US1840007339' => 'Clifton Hill',
		'US1840010723' => 'Jamestown',
		'US1840009475' => 'Rea',
		'US1840009861' => 'Moundville',
		'US1840025749' => 'Oxly',
		'US1840009947' => 'Lanagan',
		'US1840010671' => 'Vandalia',
		'US1840009875' => 'Morrisville',
		'US1840012582' => 'Florida',
		'US1840008612' => 'Lake Annette',
		'US1840007511' => 'Adrian',
		'US1840010879' => 'Airport Drive',
		'US1840010794' => 'Ionia',
		'US1840007440' => 'Cool Valley',
		'US1840009921' => 'Sikeston',
		'US1840008758' => 'Eminence',
		'US1840012411' => 'Lock Springs',
		'US1840007336' => 'Hale',
		'US1840009871' => 'Perryville',
		'US1840009896' => 'Seymour',
		'US1840009745' => 'Pagedale',
		'US1840010625' => 'Ashburn',
		'US1840007603' => 'Hartville',
		'US1840008463' => 'Moberly',
		'US1840010903' => 'Holland',
		'US1840007464' => 'Harrisonville',
		'US1840009488' => 'Purdin',
		'US1840012894' => 'Tightwad',
		'US1840025752' => 'Sundown',
		'US1840037780' => 'Three Creeks',
		'US1840025694' => 'Weingarten',
		'US1840010601' => 'Agency',
		'US1840007628' => 'Carterville',
		'US1840012413' => 'Cosby',
		'US1840007655' => 'Alton',
		'US1840009786' => 'Pleasant Hill',
		'US1840009614' => 'Sweet Springs',
		'US1840007669' => 'Caruthersville',
		'US1840032257' => 'Loch Lloyd',
		'US1840012997' => 'Gordonville',
		'US1840008725' => 'Golden City',
		'US1840009721' => 'St. Peters',
		'US1840007532' => 'Bourbon',
		'US1840013066' => 'Pascola',
		'US1840008742' => 'Marshfield',
		'US1840007531' => 'Cuba',
		'US1840012828' => 'Velda Village Hills',
		'US1840012859' => 'Wardsville',
		'US1840010750' => 'Champ',
		'US1840012629' => 'Farley',
		'US1840010841' => 'Richards',
		'US1840008799' => 'Neelyville',
		'US1840006125' => 'Castle Point',
		'US1840009414' => 'Rock Port',
		'US1840010405' => 'Arbela',
		'US1840008588' => 'Glendale',
		'US1840009795' => 'Lohman',
		'US1840012950' => 'St. Cloud',
		'US1840008359' => 'Green City',
		'US1840009418' => 'Parnell',
		'US1840009787' => 'Raymore',
		'US1840009910' => 'Oronogo',
		'US1840012806' => 'Innsbrook',
		'US1840013059' => 'Taneyville',
		'US1840007491' => 'Calhoun',
		'US1840025543' => 'Ravanna',
		'US1840009939' => 'Lilbourn',
		'US1840008464' => 'Frankford',
		'US1840006234' => 'Horine',
		'US1840008595' => 'Moline Acres',
		'US1840006128' => 'Brentwood',
		'US1840008786' => 'Ellsinore',
		'US1840032251' => 'Velda City',
		'US1840025696' => 'Frankclay',
		'US1840008384' => 'La Belle',
		'US1840012350' => 'Big Lake',
		'US1840012244' => 'Gentry',
		'US1840012728' => 'Unity Village',
		'US1840010882' => 'Williamsville',
		'US1840008594' => 'Oakland',
		'US1840012137' => 'Clyde',
		'US1840012602' => 'Eolia',
		'US1840008587' => 'Frontenac',
		'US1840007656' => 'Canalou',
		'US1840012959' => 'Harwood',
		'US1840009676' => 'Louisiana',
		'US1840007341' => 'Huntsville',
		'US1840009645' => 'St. Clair',
		'US1840007445' => 'Charlack',
		'US1840009847' => 'Mineral Point',
		'US1840007271' => 'Atlanta',
		'US1840008404' => 'Laclede',
		'US1840008525' => 'Napoleon',
		'US1840007344' => 'Bowling Green',
		'US1840008611' => 'Garden City',
		'US1840007462' => 'Archie',
		'US1840008569' => 'Foristell',
		'US1840008661' => 'Lakeside',
		'US1840007647' => 'Ava',
		'US1840013015' => 'Diggins',
		'US1840013038' => 'Vanduser',
		'US1840025578' => 'Excello',
		'US1840006124' => 'Affton',
		'US1840025751' => 'Pontiac',
		'US1840012460' => 'Utica',
		'US1840012304' => 'Gibbs',
		'US1840007391' => 'Columbia',
		'US1840008584' => 'Ferguson',
		'US1840010790' => 'Urich',
		'US1840009727' => 'Lupus',
		'US1840025602' => 'Ashley',
		'US1840007323' => 'Center',
		'US1840009420' => 'Ridgeway',
		'US1840007320' => 'Hamilton',
		'US1840009477' => 'Savannah',
		'US1840010806' => 'Cedar Hill Lakes',
		'US1840007642' => 'Bloomfield',
		'US1840012603' => 'Paynesville',
		'US1840008532' => 'Grandview',
		'US1840009549' => 'St. Joseph',
		'US1840007340' => 'Higbee',
		'US1840010747' => 'Winchester',
		'US1840007395' => 'Buckner',
		'US1840013044' => 'Leawood',
		'US1840009593' => 'Riverside',
		'US1840009725' => 'Chilhowee',
		'US1840010776' => 'Versailles',
		'US1840009800' => 'Lincoln',
		'US1840007515' => 'Iberia',
		'US1840008510' => 'Miami',
		'US1840008487' => 'Lawson',
		'US1840012699' => 'Rush Hill',
		'US1840010662' => 'Gilliam',
		'US1840007512' => 'Amoret',
		'US1840008577' => 'Knob Noster',
		'US1840009853' => 'St. Mary',
		'US1840007460' => 'Cleveland',
		'US1840006122' => 'Sappington',
		'US1840009746' => 'Pasadena Hills',
		'US1840032254' => 'Southwest City',
		'US1840008576' => 'Kingsville',
		'US1840008680' => 'Newburg',
		'US1840009845' => 'Steelville',
		'US1840013028' => 'Mill Spring',
		'US1840008598' => 'Kirkwood',
		'US1840007573' => 'Conway',
		'US1840010770' => 'Washington',
		'US1840007303' => 'Chula',
		'US1840007359' => 'Camden',
		'US1840008803' => 'New Madrid',
		'US1840007657' => 'Howardville',
		'US1840007396' => 'Blue Springs',
		'US1840010877' => 'Waco',
		'US1840009951' => 'Bragg City',
		'US1840006235' => 'Imperial',
		'US1840007630' => 'Carytown',
		'US1840008379' => 'Laredo',
		'US1840007480' => 'Barnett',
		'US1840012599' => 'Tina',
		'US1840009550' => 'De Kalb',
		'US1840010539' => 'Amity',
		'US1840009435' => 'Newtown',
		'US1840008344' => 'Memphis',
		'US1840008497' => 'Glenaire',
		'US1840008793' => 'Neosho',
		'US1840008583' => 'Fenton',
		'US1840013039' => 'Baker',
		'US1840008619' => 'Gasconade',
		'US1840008443' => 'Kingston',
		'US1840010846' => 'Waynesville',
		'US1840010643' => 'Weston',
		'US1840009525' => 'Palmyra',
		'US1840010738' => 'Town and Country',
		'US1840007530' => 'Appleton City',
		'US1840013012' => 'Arcola',
		'US1840010491' => 'Brimson',
		'US1840007617' => 'Birch Tree',
		'US1840009739' => 'Manchester',
		'US1840008644' => 'Montrose',
		'US1840012459' => 'Mooresville',
		'US1840012133' => 'Powersville',
		'US1840007337' => 'De Witt',
	],
	'MN' => [
		'US1840073791' => 'Birchwood Village',
		'US1840008911' => 'Regal',
		'US1840008972' => 'St. Peter',
		'US1840006590' => 'Aurora',
		'US1840007845' => 'Glencoe',
		'US1840007860' => 'Fairfax',
		'US1840006638' => 'Aitkin',
		'US1840008963' => 'Sanborn',
		'US1840006712' => 'Columbia Heights',
		'US1840009968' => 'Wolf Lake',
		'US1840006800' => 'Currie',
		'US1840007868' => 'New Auburn',
		'US1840007801' => 'New London',
		'US1840006792' => 'Hanska',
		'US1840008838' => 'Remer',
		'US1840009011' => 'Ostrander',
		'US1840007706' => 'Mentor',
		'US1840007738' => 'Fort Ripley',
		'US1840039628' => 'Riverland',
		'US1840042944' => 'Midway',
		'US1840006832' => 'Brownsville',
		'US1840000294' => 'Clara City',
		'US1840006690' => 'Donnelly',
		'US1840008844' => 'Manhattan Beach',
		'US1840006621' => 'Chickamaw Beach',
		'US1840006842' => 'Delavan',
		'US1840008937' => 'Maplewood',
		'US1840006599' => 'Holt',
		'US1840025306' => 'Martin Lake',
		'US1840008900' => 'Rockford',
		'US1840010025' => 'Vernon Center',
		'US1840007928' => 'Kinbrae',
		'US1840006607' => 'Clearbrook',
		'US1840008998' => 'Lismore',
		'US1840008864' => 'Pierz',
		'US1840008940' => 'St. Paul',
		'US1840006725' => 'Danvers',
		'US1840006603' => 'Climax',
		'US1840007832' => 'Minnetonka Beach',
		'US1840006795' => 'Amboy',
		'US1840008985' => 'Stewartville',
		'US1840008922' => 'Loretto',
		'US1840010028' => 'West Concord',
		'US1840006805' => 'Blooming Prairie',
		'US1840007745' => 'Elizabeth',
		'US1840006820' => 'Adrian',
		'US1840006784' => 'Arco',
		'US1840010023' => 'Wabasha',
		'US1840009995' => 'Willmar',
		'US1840007687' => 'Eveleth',
		'US1840023848' => 'Baker',
		'US1840007833' => 'Minnetrista',
		'US1840007891' => 'Northfield',
		'US1840006717' => 'Anoka',
		'US1840008953' => 'Renville',
		'US1840042945' => 'West Roy Lake',
		'US1840009009' => 'Mabel',
		'US1840009959' => 'Wilton',
		'US1840008924' => 'Maple Plain',
		'US1840000237' => 'Pine City',
		'US1840008877' => 'Rockville',
		'US1840007811' => 'Newport',
		'US1840007763' => 'Grasston',
		'US1840006679' => 'Carlos',
		'US1840007808' => 'Forest Lake',
		'US1840007950' => 'Fairmont',
		'US1840007836' => 'Milan',
		'US1840010046' => 'Truman',
		'US1840009976' => 'Urbank',
		'US1840007936' => 'Le Roy',
		'US1840007834' => 'Independence',
		'US1840008947' => 'Lilydale',
		'US1840007930' => 'Freeborn',
		'US1840010040' => 'Wykoff',
		'US1840008827' => 'Shevlin',
		'US1840140386' => 'South End',
		'US1840009964' => 'Zemple',
		'US1840006771' => 'Buffalo Lake',
		'US1840007921' => 'Lewiston',
		'US1840008933' => 'St. Anthony',
		'US1840000270' => 'Rush City',
		'US1840008949' => 'Sunfish Lake',
		'US1840007749' => 'Foxhome',
		'US1840026096' => 'Inger',
		'US1840006807' => 'Hayfield',
		'US1840007688' => 'Floodwood',
		'US1840007931' => 'Geneva',
		'US1840007726' => 'Ogema',
		'US1840004167' => 'Leota',
		'US1840008954' => 'Sacred Heart',
		'US1840006610' => 'Cohasset',
		'US1840008869' => 'Princeton',
		'US1840008823' => 'Tenstrike',
		'US1840007871' => 'Milroy',
		'US1840025267' => 'Mahtowa',
		'US1840008921' => 'Long Lake',
		'US1840006791' => 'Comfrey',
		'US1840008982' => 'Slayton',
		'US1840006598' => 'Grygla',
		'US1840007892' => 'Morristown',
		'US1840007841' => 'New Brighton',
		'US1840006794' => 'Hammond',
		'US1840010043' => 'Wells',
		'US1840010007' => 'Victoria',
		'US1840007814' => 'Lake Elmo',
		'US1840007704' => 'Fosston',
		'US1840008932' => 'Rogers',
		'US1840008885' => 'St. Stephen',
		'US1840009002' => 'Lyle',
		'US1840006782' => 'Belview',
		'US1840006693' => 'Braham',
		'US1840008843' => 'Sebeka',
		'US1840006810' => 'Dover',
		'US1840008814' => 'Roseau',
		'US1840006837' => 'Chatfield',
		'US1840010021' => 'Waterville',
		'US1840007948' => 'Kiester',
		'US1840008872' => 'Rice',
		'US1840006811' => 'Bingham Lake',
		'US1840008917' => 'St. Paul Park',
		'US1840007908' => 'Fulda',
		'US1840008944' => 'Plato',
		'US1840010003' => 'Watson',
		'US1840008942' => 'Silver Lake',
		'US1840007838' => 'Falcon Heights',
		'US1840007800' => 'Lexington',
		'US1840008845' => 'Pequot Lakes',
		'US1840007885' => 'Kilkenny',
		'US1840007910' => 'Lake Wilson',
		'US1840006670' => 'Bowlus',
		'US1840023787' => 'Ebro',
		'US1840007783' => 'New Munich',
		'US1840006720' => 'Ham Lake',
		'US1840007680' => 'Lancaster',
		'US1840006658' => 'Doran',
		'US1840006766' => 'Burnsville',
		'US1840007691' => 'Meadowlands',
		'US1840007705' => 'McIntosh',
		'US1840006833' => 'Caledonia',
		'US1840007940' => 'Lanesboro',
		'US1840025297' => 'Fairhaven',
		'US1840006793' => 'Courtland',
		'US1840008834' => 'Perley',
		'US1840006691' => 'Cyrus',
		'US1840009991' => 'Westport',
		'US1840006637' => 'Dilworth',
		'US1840006815' => 'Darfur',
		'US1840007844' => 'Lauderdale',
		'US1840008914' => 'Stillwater',
		'US1840006582' => 'Halma',
		'US1840006600' => 'Bemidji',
		'US1840008948' => 'South St. Paul',
		'US1840006668' => 'Hewitt',
		'US1840006797' => 'Hatfield',
		'US1840006642' => 'Cuyuna',
		'US1840007905' => 'Lake Crystal',
		'US1840007731' => 'Moorhead',
		'US1840006838' => 'Harmony',
		'US1840004013' => 'Browns Valley',
		'US1840006646' => 'Cloquet',
		'US1840007932' => 'Glenville',
		'US1840009965' => 'Waubun',
		'US1840008960' => 'Lucan',
		'US1840008970' => 'Sleepy Eye',
		'US1840031784' => 'Crosslake',
		'US1840006657' => 'Campbell',
		'US1840006755' => 'Biscay',
		'US1840006819' => 'Hills',
		'US1840008994' => 'St. James',
		'US1840010027' => 'Woodstock',
		'US1840006764' => 'Hanley Falls',
		'US1840009974' => 'Wright',
		'US1840007686' => 'Ely',
		'US1840010039' => 'Whalan',
		'US1840009956' => 'Viking',
		'US1840007813' => 'Oakdale',
		'US1840008854' => 'Rothsay',
		'US1840008850' => 'Parkers Prairie',
		'US1840008829' => 'Red Lake Falls',
		'US1840006740' => 'Dellwood',
		'US1840008986' => 'Oronoco',
		'US1840008973' => 'Plainview',
		'US1840007683' => 'Mizpah',
		'US1840006594' => 'Hibbing',
		'US1840007818' => 'Landfall',
		'US1840006814' => 'Butterfield',
		'US1840006639' => 'Aldrich',
		'US1840008897' => 'Maple Lake',
		'US1840007918' => 'Jeffers',
		'US1840007673' => 'Baudette',
		'US1840007685' => 'Duluth',
		'US1840007707' => 'Nielsville',
		'US1840023821' => 'Pine Bend',
		'US1840032021' => 'Rice Lake',
		'US1840006713' => 'Columbus',
		'US1840007805' => 'Kerkhoven',
		'US1840010034' => 'Winona',
		'US1840007798' => 'Fridley',
		'US1840006626' => 'Hackensack',
		'US1840006756' => 'Hutchinson',
		'US1840008842' => 'Palisade',
		'US1840025244' => 'Soudan',
		'US1840007949' => 'Dunnell',
		'US1840007851' => 'Granite Falls',
		'US1840007879' => 'Marshall',
		'US1840008983' => 'Owatonna',
		'US1840007716' => 'Nashwauk',
		'US1840006619' => 'Halstad',
		'US1840008871' => 'Osakis',
		'US1840008909' => 'Prinsburg',
		'US1840007894' => 'New Ulm',
		'US1840006667' => 'Grey Eagle',
		'US1840006734' => 'Cedar Mills',
		'US1840007952' => 'Northrop',
		'US1840008898' => 'South Haven',
		'US1840007765' => 'Mora',
		'US1840006745' => 'Crystal',
		'US1840008929' => 'Plymouth',
		'US1840006731' => 'Cosmos',
		'US1840032019' => 'Little Rock',
		'US1840008939' => 'Roseville',
		'US1840004169' => 'Brownsdale',
		'US1840007767' => 'Norcross',
		'US1840008956' => 'Prior Lake',
		'US1840007839' => 'Gem Lake',
		'US1840006652' => 'Battle Lake',
		'US1840006672' => 'Hillman',
		'US1840007742' => 'Jenkins',
		'US1840007914' => 'New Richland',
		'US1840009984' => 'Wahkon',
		'US1840010047' => 'Welcome',
		'US1840009962' => 'Winger',
		'US1840003993' => 'Ponemah',
		'US1840006655' => 'Deer Creek',
		'US1840007886' => 'Le Center',
		'US1840000268' => 'Center City',
		'US1840006651' => 'Dalton',
		'US1840004005' => 'Brook Park',
		'US1840007837' => 'Montevideo',
		'US1840006726' => 'Appleton',
		'US1840007906' => 'Edgerton',
		'US1840006589' => 'Cook',
		'US1840006661' => 'Henriette',
		'US1840006723' => 'Blomkest',
		'US1840006729' => 'De Graff',
		'US1840007755' => 'Elmdale',
		'US1840008828' => 'Plummer',
		'US1840006674' => 'Bock',
		'US1840007785' => 'Lake Henry',
		'US1840006588' => 'Chisholm',
		'US1840006762' => 'Clarkfield',
		'US1840007929' => 'Emmons',
		'US1840008990' => 'Rollingstone',
		'US1840010017' => 'Walnut Grove',
		'US1840009015' => 'Rushford Village',
		'US1840008993' => 'Ormsby',
		'US1840010031' => 'Westbrook',
		'US1840007746' => 'Erhard',
		'US1840007682' => 'Northome',
		'US1840008822' => 'Solway',
		'US1840007944' => 'Easton',
		'US1840006727' => 'Benson',
		'US1840007725' => 'Frazee',
		'US1840007861' => 'Franklin',
		'US1840008935' => 'St. Louis Park',
		'US1840008989' => 'Stockton',
		'US1840008967' => 'Taunton',
		'US1840006780' => 'Dennison',
		'US1840008984' => 'Mantorville',
		'US1840008968' => 'Russell',
		'US1840007890' => 'Nerstrand',
		'US1840010016' => 'Wabasso',
		'US1840010018' => 'Wanda',
		'US1840008902' => 'Lino Lakes',
		'US1840007900' => 'Millville',
		'US1840008853' => 'Richville',
		'US1840025372' => 'Searles',
		'US1840003994' => 'Red Lake',
		'US1840007925' => 'Kenneth',
		'US1840008889' => 'Lowry',
		'US1840025266' => 'Esko',
		'US1840009970' => 'Verndale',
		'US1840010045' => 'Trimont',
		'US1840008821' => 'Oslo',
		'US1840008858' => 'Sandstone',
		'US1840007913' => 'Kasson',
		'US1840008971' => 'Springfield',
		'US1840007766' => 'Elbow Lake',
		'US1840006718' => 'Bethel',
		'US1840009993' => 'Zimmerman',
		'US1840007793' => 'Johnson',
		'US1840010010' => 'Wood Lake',
		'US1840006721' => 'Hilltop',
		'US1840008815' => 'Littlefork',
		'US1840008811' => 'St. Vincent',
		'US1840009012' => 'Peterson',
		'US1840008855' => 'Sturgeon Lake',
		'US1840008824' => 'Silver Bay',
		'US1840010032' => 'Windom',
		'US1840007773' => 'Miltona',
		'US1840007923' => 'La Salle',
		'US1840008979' => 'St. Clair',
		'US1840009008' => 'Spring Grove',
		'US1840000269' => 'Chisago City',
		'US1840006689' => 'Hancock',
		'US1840008863' => 'Swanville',
		'US1840008962' => 'Revere',
		'US1840007750' => 'Nashua',
		'US1840010006' => 'Winsted',
		'US1840008836' => 'Pillager',
		'US1840007933' => 'Myrtle',
		'US1840007753' => 'Kerrick',
		'US1840007942' => 'Jackson',
		'US1840007947' => 'Minnesota Lake',
		'US1840007751' => 'Kent',
		'US1840022338' => 'Nowthen',
		'US1840009989' => 'Waite Park',
		'US1840008899' => 'Otsego',
		'US1840008817' => 'Orr',
		'US1840003998' => 'Brooks',
		'US1840007823' => 'Excelsior',
		'US1840004001' => 'Pine Point',
		'US1840008812' => 'Strathcona',
		'US1840008826' => 'St. Hilaire',
		'US1840008849' => 'Ottertail',
		'US1840007843' => 'North St. Paul',
		'US1840006817' => 'Beaver Creek',
		'US1840006735' => 'Cottage Grove',
		'US1840006751' => 'Deephaven',
		'US1840006630' => 'White Earth',
		'US1840006622' => 'Cass Lake',
		'US1840010905' => 'Williams',
		'US1840006675' => 'Ashby',
		'US1840008903' => 'Spring Lake Park',
		'US1840006747' => 'Bloomington',
		'US1840007789' => 'Isanti',
		'US1840006748' => 'Greenwood',
		'US1840010008' => 'Waconia',
		'US1840006822' => 'Clarks Grove',
		'US1840007781' => 'Meire Grove',
		'US1840006609' => 'Calumet',
		'US1840009013' => 'Preston',
		'US1840025368' => 'Warsaw',
		'US1840006836' => 'Canton',
		'US1840006704' => 'Clearwater',
		'US1840007847' => 'Mayer',
		'US1840009010' => 'Spring Valley',
		'US1840007747' => 'Fergus Falls',
		'US1840008816' => 'Ranier',
		'US1840007854' => 'Mendota',
		'US1840008980' => 'Pipestone',
		'US1840010020' => 'Tracy',
		'US1840006625' => 'Boy River',
		'US1840008918' => 'Scandia',
		'US1840008920' => 'Madison',
		'US1840007874' => 'Ivanhoe',
		'US1840009016' => 'Sherburn',
		'US1840025429' => 'Lansing',
		'US1840009998' => 'Woodbury',
		'US1840008995' => 'Luverne',
		'US1840006608' => 'Bagley',
		'US1840007734' => 'Menahga',
		'US1840008977' => 'Skyline',
		'US1840008938' => 'Shoreview',
		'US1840006757' => 'Cologne',
		'US1840008931' => 'Robbinsdale',
		'US1840006831' => 'Dexter',
		'US1840007679' => 'Lake Bronson',
		'US1840007840' => 'Mounds View',
		'US1840007819' => 'Marietta',
		'US1840007846' => 'Lester Prairie',
		'US1840004171' => 'Bricelyn',
		'US1840006765' => 'Hazel Run',
		'US1840007761' => 'Milaca',
		'US1840006697' => 'Barry',
		'US1840004003' => 'Breckenridge',
		'US1840007792' => 'Odessa',
		'US1840006781' => 'Clements',
		'US1840007828' => 'Mound',
		'US1840007898' => 'Elgin',
		'US1840008862' => 'Sobieski',
		'US1840007859' => 'Lakeville',
		'US1840007733' => 'McGregor',
		'US1840006715' => 'Centerville',
		'US1840026094' => 'Nett Lake',
		'US1840007877' => 'Garvin',
		'US1840006602' => 'Beaver Bay',
		'US1840010001' => 'Woodland',
		'US1840007802' => 'Kandiyohi',
		'US1840007762' => 'Isle',
		'US1840006775' => 'Belle Plaine',
		'US1840007709' => 'Goodridge',
		'US1840007889' => 'Faribault',
		'US1840007924' => 'Lewisville',
		'US1840006694' => 'Harris',
		'US1840006613' => 'Bovey',
		'US1840006760' => 'Chaska',
		'US1840006673' => 'Vineland',
		'US1840007881' => 'Elysian',
		'US1840025298' => 'Stanchfield',
		'US1840007701' => 'Erskine',
		'US1840010012' => 'West St. Paul',
		'US1840009990' => 'Villard',
		'US1840008926' => 'Spring Park',
		'US1840009000' => 'Rushmore',
		'US1840006783' => 'Delhi',
		'US1840009954' => 'Virginia',
		'US1840009006' => 'Rose Creek',
		'US1840007681' => 'Greenbush',
		'US1840006829' => 'Adams',
		'US1840007678' => 'Kennedy',
		'US1840000278' => 'Grove City',
		'US1840006714' => 'Coon Rapids',
		'US1840008958' => 'Pine Island',
		'US1840009953' => 'Tower',
		'US1840006605' => 'Beltrami',
		'US1840039629' => 'The Ranch',
		'US1840007788' => 'Glenwood',
		'US1840009958' => 'Turtle River',
		'US1840006772' => 'Danube',
		'US1840039609' => 'Fish Lake',
		'US1840007904' => 'Good Thunder',
		'US1840008945' => 'Porter',
		'US1840007769' => 'Forada',
		'US1840023822' => 'Roy Lake',
		'US1840007775' => 'Dumont',
		'US1840007684' => 'International Falls',
		'US1840003992' => 'Brookston',
		'US1840006749' => 'Hopkins',
		'US1840009952' => 'Warroad',
		'US1840000306' => 'Zumbrota',
		'US1840007698' => 'Funkley',
		'US1840007893' => 'Evan',
		'US1840006623' => 'Backus',
		'US1840006692' => 'Cambridge',
		'US1840007702' => 'Fertile',
		'US1840008867' => 'Onamia',
		'US1840008901' => 'St. Michael',
		'US1840007719' => 'Gary',
		'US1840008866' => 'Royalton',
		'US1840007869' => 'Goodhue',
		'US1840008833' => 'Shelly',
		'US1840006654' => 'Henning',
		'US1840008892' => 'Lindstrom',
		'US1840008974' => 'Madison Lake',
		'US1840009977' => 'Vergas',
		'US1840007935' => 'Grand Meadow',
		'US1840006758' => 'Carver',
		'US1840007710' => 'Gonvick',
		'US1840026063' => 'Lutsen',
		'US1840007830' => 'Minneapolis',
		'US1840006612' => 'Bigfork',
		'US1840008950' => 'Randolph',
		'US1840007713' => 'Effie',
		'US1840007697' => 'Middle River',
		'US1840008810' => 'Grand Marais',
		'US1840009967' => 'Walker',
		'US1840007866' => 'Gibbon',
		'US1840006703' => 'Buffalo',
		'US1840008893' => 'Shafer',
		'US1840025261' => 'Merrifield',
		'US1840006591' => 'Babbitt',
		'US1840007771' => 'Nelson',
		'US1840007887' => 'Le Sueur',
		'US1840009014' => 'Rushford',
		'US1840007736' => 'Emily',
		'US1840006823' => 'Conger',
		'US1840007853' => 'Farmington',
		'US1840009992' => 'Wyoming',
		'US1840007728' => 'Felton',
		'US1840006688' => 'Alberta',
		'US1840009994' => 'Waverly',
		'US1840008928' => 'Osseo',
		'US1840007695' => 'Leonidas',
		'US1840007875' => 'Lake Benton',
		'US1840007943' => 'Lakefield',
		'US1840006700' => 'Becker',
		'US1840007938' => 'La Crescent',
		'US1840006786' => 'Cottonwood',
		'US1840007842' => 'North Oaks',
		'US1840006808' => 'Dodge Center',
		'US1840008996' => 'Magnolia',
		'US1840009005' => 'Racine',
		'US1840006790' => 'Cobden',
		'US1840025305' => 'Silver Creek',
		'US1840006763' => 'Canby',
		'US1840007911' => 'Ellendale',
		'US1840009997' => 'Willernie',
		'US1840006680' => 'Alexandria',
		'US1840007863' => 'Elko New Market',
		'US1840007876' => 'Florence',
		'US1840006584' => 'Donaldson',
		'US1840008961' => 'Redwood Falls',
		'US1840009004' => 'Taopi',
		'US1840008991' => 'St. Charles',
		'US1840009978' => 'Vining',
		'US1840006678' => 'Hoffman',
		'US1840007711' => 'Leonard',
		'US1840006802' => 'Avoca',
		'US1840007870' => 'Kenyon',
		'US1840008835' => 'Longville',
		'US1840008813' => 'Roosevelt',
		'US1840008831' => 'Taconite',
		'US1840008888' => 'Long Beach',
		'US1840007872' => 'Morgan',
		'US1840006635' => 'Hawley',
		'US1840007856' => 'New Trier',
		'US1840006777' => 'Henderson',
		'US1840007715' => 'Marble',
		'US1840008861' => 'Little Falls',
		'US1840007909' => 'Iona',
		'US1840007708' => 'Lengby',
		'US1840006739' => 'Hugo',
		'US1840006649' => 'Barnum',
		'US1840008975' => 'Mankato',
		'US1840010044' => 'Winnebago',
		'US1840007780' => 'Greenwald',
		'US1840007903' => 'Eagle Lake',
		'US1840007694' => 'Kinney',
		'US1840008943' => 'Stewart',
		'US1840006597' => 'Argyle',
		'US1840006604' => 'Crookston',
		'US1840008946' => 'St. Leo',
		'US1840007799' => 'Oak Grove',
		'US1840008964' => 'Seaforth',
		'US1840008819' => 'Stephen',
		'US1840009999' => 'Tonka Bay',
		'US1840007758' => 'Motley',
		'US1840026098' => 'Whipholt',
		'US1840009983' => 'Upsala',
		'US1840008952' => 'Olivia',
		'US1840006629' => 'Callaway',
		'US1840006633' => 'Comstock',
		'US1840007922' => 'Odin',
		'US1840008860' => 'Staples',
		'US1840008976' => 'Mapleton',
		'US1840008905' => 'St. Francis',
		'US1840007912' => 'Medford',
		'US1840006650' => 'Clitherall',
		'US1840009986' => 'Tintah',
		'US1840006664' => 'Burtrum',
		'US1840007774' => 'Kensington',
		'US1840007939' => 'Fountain',
		'US1840006722' => 'Atwater',
		'US1840006592' => 'Biwabik',
		'US1840007824' => 'Golden Valley',
		'US1840007815' => 'Lake St. Croix Beach',
		'US1840003999' => 'Naytahwaush',
		'US1840007693' => 'Iron Junction',
		'US1840008865' => 'Randall',
		'US1840006724' => 'Clontarf',
		'US1840025249' => 'Finland',
		'US1840006634' => 'Barnesville',
		'US1840008852' => 'Perham',
		'US1840007849' => 'Norwood Young America',
		'US1840006583' => 'Humboldt',
		'US1840010041' => 'Wilder',
		'US1840008830' => 'Squaw Lake',
		'US1840006662' => 'Hinckley',
		'US1840009969' => 'Ulen',
		'US1840007919' => 'Elba',
		'US1840006776' => 'Arlington',
		'US1840006746' => 'Champlin',
		'US1840006711' => 'Circle Pines',
		'US1840010014' => 'Wanamingo',
		'US1840007864' => 'Jordan',
		'US1840009955' => 'Winton',
		'US1840006841' => 'Blue Earth',
		'US1840006618' => 'Borup',
		'US1840007739' => 'Garrison',
		'US1840006581' => 'Hallock',
		'US1840007720' => 'East Gull Lake',
		'US1840032018' => 'The Lakes',
		'US1840007770' => 'Garfield',
		'US1840006821' => 'Bigelow',
		'US1840008987' => 'Rochester',
		'US1840007888' => 'Dundas',
		'US1840008820' => 'Strandquist',
		'US1840006750' => 'Dayton',
		'US1840006839' => 'Alpha',
		'US1840008868' => 'Pease',
		'US1840006741' => 'Bellingham',
		'US1840006778' => 'Cannon Falls',
		'US1840007941' => 'Okabena',
		'US1840006732' => 'Darwin',
		'US1840007727' => 'Lake Park',
		'US1840008919' => 'Louisburg',
		'US1840007748' => 'New York Mills',
		'US1840008981' => 'Ruthton',
		'US1840007752' => 'Finlayson',
		'US1840007817' => 'Lakeland Shores',
		'US1840006813' => 'Altura',
		'US1840006809' => 'Byron',
		'US1840007896' => 'North Mankato',
		'US1840010000' => 'Wayzata',
		'US1840006653' => 'Bluffton',
		'US1840008886' => 'Sartell',
		'US1840008880' => 'St. Augusta',
		'US1840006682' => 'Cold Spring',
		'US1840007754' => 'Eagle Bend',
		'US1840008895' => 'Taylors Falls',
		'US1840007882' => 'New Prague',
		'US1840008925' => 'Shorewood',
		'US1840007717' => 'Keewatin',
		'US1840006779' => 'Bellechester',
		'US1840007945' => 'Elmore',
		'US1840008951' => 'Rosemount',
		'US1840006683' => 'Albany',
		'US1840007809' => 'Grant',
		'US1840009982' => 'West Union',
		'US1840006828' => 'Hollandale',
		'US1840006687' => 'Chokio',
		'US1840007795' => 'Monticello',
		'US1840008894' => 'Stacy',
		'US1840009973' => 'Wrenshall',
		'US1840008851' => 'Pelican Rapids',
		'US1840007718' => 'La Prairie',
		'US1840006706' => 'Albertville',
		'US1840006770' => 'Hastings',
		'US1840006681' => 'Brandon',
		'US1840007797' => 'East Bethel',
		'US1840000326' => 'Minnesota City',
		'US1840006789' => 'Heidelberg',
		'US1840007865' => 'Gaylord',
		'US1840008883' => 'St. Martin',
		'US1840007778' => 'Elrosa',
		'US1840025296' => 'Ronneby',
		'US1840007917' => 'Mountain Lake',
		'US1840010015' => 'Vesta',
		'US1840004006' => 'Browerville',
		'US1840008957' => 'Savage',
		'US1840007776' => 'Foley',
		'US1840008832' => 'Mahnomen',
		'US1840026095' => 'Ball Club',
		'US1840006632' => 'Detroit Lakes',
		'US1840008856' => 'Rock Creek',
		'US1840010026' => 'Trosky',
		'US1840006695' => 'Clinton',
		'US1840007825' => 'Greenfield',
		'US1840006648' => 'Carlton',
		'US1840007692' => 'Mountain Iron',
		'US1840006742' => 'Boyd',
		'US1840007946' => 'Frost',
		'US1840006620' => 'Hendrum',
		'US1840010024' => 'Zumbro Falls',
		'US1840007848' => 'New Germany',
		'US1840006601' => 'Blackduck',
		'US1840008846' => 'Riverton',
		'US1840009981' => 'Willow River',
		'US1840006686' => 'Holdingford',
		'US1840010013' => 'Winthrop',
		'US1840007915' => 'Janesville',
		'US1840008839' => 'Park Rapids',
		'US1840007791' => 'Graceville',
		'US1840007951' => 'Granada',
		'US1840008969' => 'Lonsdale',
		'US1840006827' => 'Hayward',
		'US1840010004' => 'Vadnais Heights',
		'US1840007827' => 'Medina',
		'US1840007826' => 'Medicine Lake',
		'US1840007744' => 'Kettle River',
		'US1840007703' => 'Fisher',
		'US1840006708' => 'Hanover',
		'US1840006840' => 'Heron Lake',
		'US1840006834' => 'Hokah',
		'US1840010009' => 'Watertown',
		'US1840007897' => 'Lafayette',
		'US1840009966' => 'Twin Valley',
		'US1840006769' => 'Hampton',
		'US1840007884' => 'Kasota',
		'US1840007858' => 'Inver Grove Heights',
		'US1840006636' => 'Hitterdal',
		'US1840006663' => 'Denham',
		'US1840007696' => 'Newfolden',
		'US1840006736' => 'Afton',
		'US1840007741' => 'Ironton',
		'US1840008825' => 'Thief River Falls',
		'US1840008818' => 'Proctor',
		'US1840008840' => 'Sabin',
		'US1840006825' => 'Alden',
		'US1840008878' => 'Roscoe',
		'US1840004023' => 'Brooklyn Park',
		'US1840007822' => 'Edina',
		'US1840008859' => 'Long Prairie',
		'US1840006804' => 'Dovray',
		'US1840006586' => 'Big Falls',
		'US1840008876' => 'Richmond',
		'US1840007895' => 'Nicollet',
		'US1840008992' => 'Madelia',
		'US1840007760' => 'Foreston',
		'US1840008915' => 'Pine Springs',
		'US1840009975' => 'Underwood',
		'US1840008904' => 'Ramsey',
		'US1840007878' => 'Ghent',
		'US1840008912' => 'Litchfield',
		'US1840006767' => 'Coates',
		'US1840008906' => 'Spicer',
		'US1840004017' => 'Brooten',
		'US1840009960' => 'Two Harbors',
		'US1840025259' => 'Osage',
		'US1840006710' => 'Delano',
		'US1840006640' => 'Crosby',
		'US1840007699' => 'Kelliher',
		'US1840007855' => 'Mendota Heights',
		'US1840000321' => 'Lake City',
		'US1840008837' => 'Pine River',
		'US1840009961' => 'Trail',
		'US1840007803' => 'Lake Lillian',
		'US1840007787' => 'Farwell',
		'US1840006624' => 'Bena',
		'US1840006719' => 'Blaine',
		'US1840006803' => 'Hadley',
		'US1840006596' => 'Alvarado',
		'US1840006671' => 'Harding',
		'US1840008857' => 'Rutledge',
		'US1840007743' => 'Moose Lake',
		'US1840006754' => 'Brownton',
		'US1840006665' => 'Clarissa',
		'US1840006835' => 'Houston',
		'US1840003995' => 'Redby',
		'US1840008959' => 'Red Wing',
		'US1840007677' => 'Karlstad',
		'US1840007732' => 'McGrath',
		'US1840010036' => 'Worthington',
		'US1840009957' => 'Warren',
		'US1840006587' => 'Buhl',
		'US1840006701' => 'Big Lake',
		'US1840025353' => 'Frontenac',
		'US1840010019' => 'Tyler',
		'US1840006698' => 'Beardsley',
		'US1840007786' => 'Morris',
		'US1840007723' => 'Nevis',
		'US1840006614' => 'Deer River',
		'US1840007757' => 'Genola',
		'US1840007907' => 'Jasper',
		'US1840006643' => 'Baxter',
		'US1840006685' => 'Belgrade',
		'US1840007862' => 'Morton',
		'US1840007794' => 'Elk River',
		'US1840006799' => 'Ihlen',
		'US1840006709' => 'Howard Lake',
		'US1840006843' => 'Ceylon',
		'US1840006647' => 'Cromwell',
		'US1840007810' => 'Marine on St. Croix',
		'US1840000191' => 'Hill City',
		'US1840006631' => 'Audubon',
		'US1840006830' => 'Austin',
		'US1840007756' => 'Flensburg',
		'US1840007850' => 'Echo',
		'US1840007768' => 'Evansville',
		'US1840007729' => 'Georgetown',
		'US1840006826' => 'Hartland',
		'US1840009985' => 'Wendell',
		'US1840006660' => 'Askov',
		'US1840007829' => 'New Hope',
		'US1840006707' => 'Annandale',
		'US1840010005' => 'White Bear Lake',
		'US1840008997' => 'Steen',
		'US1840006798' => 'Holland',
		'US1840008884' => 'St. Rosa',
		'US1840007857' => 'Miesville',
		'US1840006699' => 'Clear Lake',
		'US1840008978' => 'Pemberton',
		'US1840006666' => 'Bertha',
		'US1840007883' => 'Montgomery',
		'US1840006806' => 'Claremont',
		'US1840007812' => 'Oak Park Heights',
		'US1840008891' => 'Sedan',
		'US1840006677' => 'Herman',
		'US1840006656' => 'Dent',
		'US1840010029' => 'Waldorf',
		'US1840004168' => 'Brewster',
		'US1840007821' => 'Eden Prairie',
		'US1840008999' => 'Round Lake',
		'US1840008841' => 'Tamarack',
		'US1840009001' => 'Manchester',
		'US1840010011' => 'Vermillion',
		'US1840007777' => 'Gilman',
		'US1840004002' => 'Breezy Point',
		'US1840007740' => 'Nisswa',
		'US1840008874' => 'Spring Hill',
		'US1840008936' => 'Little Canada',
		'US1840006774' => 'Hector',
		'US1840007759' => 'Lastrup',
		'US1840009979' => 'Wolverton',
		'US1840006728' => 'Holloway',
		'US1840006818' => 'Hardwick',
		'US1840023820' => 'Beaulieu',
		'US1840006716' => 'Andover',
		'US1840008881' => 'St. Cloud',
		'US1840007835' => 'Maynard',
		'US1840007926' => 'Dundee',
		'US1840006759' => 'Chanhassen',
		'US1840007782' => 'Melrose',
		'US1840006659' => 'Bruno',
		'US1840006585' => 'Badger',
		'US1840007916' => 'Eyota',
		'US1840007899' => 'Mazeppa',
		'US1840006684' => 'Avon',
		'US1840006676' => 'Barrett',
		'US1840008916' => 'St. Marys Point',
		'US1840008934' => 'St. Bonifacius',
		'US1840007689' => 'Gilbert',
		'US1840006593' => 'Hermantown',
		'US1840009003' => 'Mapleview',
		'US1840006787' => 'Balaton',
		'US1840007927' => 'Ellsworth',
		'US1840009996' => 'Watkins',
		'US1840008923' => 'Maple Grove',
		'US1840008887' => 'Sauk Centre',
		'US1840008930' => 'Richfield',
		'US1840007807' => 'Kingston',
		'US1840009971' => 'Wadena',
		'US1840007772' => 'Millerville',
		'US1840007690' => 'McKinley',
		'US1840006761' => 'Hamburg',
		'US1840006824' => 'Albert Lea',
		'US1840025395' => 'Homer',
		'US1840007779' => 'Freeport',
		'US1840025379' => 'Garden City',
		'US1840007784' => 'Kimball',
		'US1840007806' => 'Eden Valley',
		'US1840010033' => 'Utica',
		'US1840006785' => 'Hendricks',
		'US1840008910' => 'Raymond',
		'US1840008873' => 'Sauk Rapids',
		'US1840008988' => 'Storden',
		'US1840008955' => 'Shakopee',
		'US1840008907' => 'Sunburg',
		'US1840007700' => 'East Grand Forks',
		'US1840007714' => 'Grand Rapids',
		'US1840025255' => 'Lake George',
		'US1840007721' => 'Federal Dam',
		'US1840006606' => 'Gully',
		'US1840009972' => 'Trommald',
		'US1840009987' => 'Wheaton',
		'US1840008875' => 'Paynesville',
		'US1840006812' => 'Dakota',
		'US1840008882' => 'St. Joseph',
		'US1840010030' => 'Waseca',
		'US1840008848' => 'Scanlon',
		'US1840004022' => 'Brooklyn Center',
		'US1840006617' => 'Ada',
		'US1840007831' => 'Minnetonka',
		'US1840007902' => 'Kellogg',
		'US1840006627' => 'Akeley',
		'US1840006611' => 'Coleraine',
		'US1840007735' => 'Nimrod',
		'US1840006733' => 'Dassel',
		'US1840006645' => 'Deerwood',
		'US1840010038' => 'Waltham',
		'US1840006644' => 'Brainerd',
		'US1840007730' => 'Glyndon',
		'US1840009963' => 'Warba',
		'US1840006788' => 'Cleveland',
		'US1840007873' => 'Lamberton',
		'US1840008908' => 'Pennock',
		'US1840007804' => 'Murdock',
		'US1840010035' => 'Wilmont',
		'US1840010037' => 'Twin Lakes',
		'US1840007934' => 'Elkton',
		'US1840007790' => 'North Branch',
		'US1840007712' => 'Oklee',
		'US1840007764' => 'Ogilvie',
		'US1840007920' => 'Goodview',
		'US1840006696' => 'Correll',
		'US1840027030' => 'Angle Inlet',
		'US1840007867' => 'Green Isle',
		'US1840006595' => 'Hoyt Lakes',
		'US1840007852' => 'Eagan',
		'US1840008870' => 'Quamba',
		'US1840007901' => 'Minneiska',
		'US1840006768' => 'Apple Valley',
		'US1840007820' => 'Nassau',
		'US1840006616' => 'Bejou',
		'US1840006773' => 'Bird Island',
		'US1840007724' => 'Laporte',
		'US1840008966' => 'Lynd',
		'US1840006801' => 'Chandler',
		'US1840006705' => 'Cokato',
		'US1840007737' => 'Fifty Lakes',
		'US1840007722' => 'Lake Shore',
		'US1840006743' => 'Dawson',
		'US1840008913' => 'Mahtomedi',
		'US1840006669' => 'Buckman',
		'US1840010042' => 'Walters',
		'US1840009007' => 'Sargeant',
		'US1840008927' => 'Orono',
		'US1840008890' => 'Starbuck',
		'US1840007937' => 'Eitzen',
		'US1840006744' => 'Corcoran',
		'US1840006752' => 'Arden Hills',
		'US1840007880' => 'Minneota',
		'US1840007796' => 'Montrose',
		'US1840007816' => 'Lakeland',
		'US1840006737' => 'Bayport',
		'US1840008896' => 'Ortonville',
	],
	'MI' => [
		'US1840003966' => 'Trenton',
		'US1840010955' => 'Sanford',
		'US1840002875' => 'Stanton',
		'US1840025197' => 'Glen Arbor',
		'US1840023934' => 'Rapid City',
		'US1840003254' => 'Sturgis',
		'US1840003983' => 'Inkster',
		'US1840025260' => 'White Pine',
		'US1840002873' => 'Norton Shores',
		'US1840006865' => 'Wolf Lake',
		'US1840004341' => 'Lake Fenton',
		'US1840010065' => 'Almont',
		'US1840003925' => 'Escanaba',
		'US1840003947' => 'Alpena',
		'US1840011225' => 'Grand Beach',
		'US1840011080' => 'Dansville',
		'US1840024092' => 'Delton',
		'US1840025507' => 'Jasper',
		'US1840010022' => 'Buckley',
		'US1840006567' => 'Gwinn',
		'US1840000374' => 'Wyoming',
		'US1840025194' => 'Walloon Lake',
		'US1840004656' => 'Eastwood',
		'US1840000316' => 'Whittemore',
		'US1840013150' => 'Port Hope',
		'US1840004501' => 'Holt',
		'US1840002924' => 'Rockford',
		'US1840025193' => 'Norwood',
		'US1840025370' => 'Lupton',
		'US1840003172' => 'Ann Arbor',
		'US1840001966' => 'Manistique',
		'US1840011210' => 'Climax',
		'US1840003985' => 'Livonia',
		'US1840011192' => 'Barton Hills',
		'US1840002951' => 'Grand Blanc',
		'US1840006574' => 'Ossineke',
		'US1840073811' => 'Eastlake',
		'US1840002512' => 'Cadillac',
		'US1840002869' => 'Montague',
		'US1840003989' => 'Luna Pier',
		'US1840002681' => 'Grant',
		'US1840013138' => 'Boyne Falls',
		'US1840004697' => 'Fair Plain',
		'US1840011087' => 'Vermontville',
		'US1840011027' => 'Westphalia',
		'US1840010985' => 'Merrill',
		'US1840011016' => 'Lake Odessa',
		'US1840039574' => 'Caberfae',
		'US1840003971' => 'Detroit',
		'US1840023946' => 'Nessen City',
		'US1840011197' => 'Concord',
		'US1840011054' => 'Lake Orion',
		'US1840003170' => 'Milan',
		'US1840002814' => 'Frankenmuth',
		'US1840010950' => 'Le Roy',
		'US1840003077' => 'DeWitt',
		'US1840003104' => 'Mason',
		'US1840002446' => 'Keego Harbor',
		'US1840010998' => 'Perrinton',
		'US1840007674' => 'West Ishpeming',
		'US1840004025' => 'Lewiston',
		'US1840002449' => 'Madison Heights',
		'US1840011202' => 'Tekonsha',
		'US1840002290' => 'Harrisville',
		'US1840010957' => 'New Era',
		'US1840003076' => 'St. Johns',
		'US1840006580' => 'Detroit Beach',
		'US1840010918' => 'Powers',
		'US1840004224' => 'Freeland',
		'US1840010964' => 'Barryton',
		'US1840010980' => 'Melvin',
		'US1840039585' => 'Hardwood Acres',
		'US1840002546' => 'Scottville',
		'US1840023962' => 'Filer City',
		'US1840031566' => 'Bay View',
		'US1840003094' => 'Sterling Heights',
		'US1840026078' => 'Dollar Bay',
		'US1840011014' => 'New Lothrop',
		'US1840004008' => 'Quinnesec',
		'US1840003949' => 'Standish',
		'US1840011203' => 'Bloomingdale',
		'US1840003217' => 'Buchanan',
		'US1840002440' => 'Clawson',
		'US1840011373' => 'Deerfield',
		'US1840002878' => 'St. Louis',
		'US1840004095' => 'Au Sable',
		'US1840003101' => 'East Lansing',
		'US1840002995' => 'Grand Haven',
		'US1840010976' => 'Lexington',
		'US1840010120' => 'Breedsville',
		'US1840031727' => 'Mackinaw City',
		'US1840004700' => 'Benton Heights',
		'US1840013149' => 'Port Austin',
		'US1840011381' => 'Waldron',
		'US1840003939' => 'Mackinac Island',
		'US1840004096' => 'Skidway Lake',
		'US1840004226' => 'Shields',
		'US1840011015' => 'Vernon',
		'US1840010066' => 'Caledonia',
		'US1840003973' => 'Flat Rock',
		'US1840003252' => 'Hillsdale',
		'US1840011000' => 'Dryden',
		'US1840011007' => 'Goodrich',
		'US1840025195' => 'St. James',
		'US1840002518' => 'Rose City',
		'US1840013132' => 'Lake Linden',
		'US1840003250' => 'Coldwater',
		'US1840002947' => 'Davison',
		'US1840010995' => 'Sheridan',
		'US1840003228' => 'Tecumseh',
		'US1840011084' => 'Dimondale',
		'US1840010157' => 'Burr Oak',
		'US1840002427' => 'Pontiac',
		'US1840003970' => 'Dearborn Heights',
		'US1840023964' => 'Parkdale',
		'US1840000383' => 'Zeeland',
		'US1840002929' => 'Grandville',
		'US1840010972' => 'Reese',
		'US1840002438' => 'Birmingham',
		'US1840010072' => 'Clarksville',
		'US1840025186' => 'Levering',
		'US1840010920' => 'Posen',
		'US1840004655' => 'Brownlee Park',
		'US1840010967' => 'Stanwood',
		'US1840004343' => 'Beecher',
		'US1840025203' => 'Grawn',
		'US1840003227' => 'Morenci',
		'US1840011223' => 'Baroda',
		'US1840011051' => 'New Haven',
		'US1840003070' => 'Corunna',
		'US1840013152' => 'Pigeon',
		'US1840004229' => 'Burt',
		'US1840002699' => 'Brown City',
		'US1840011086' => 'Sunfield',
		'US1840011206' => 'Decatur',
		'US1840010956' => 'Rothbury',
		'US1840003177' => 'Marshall',
		'US1840003963' => 'Romulus',
		'US1840011049' => 'Armada',
		'US1840002423' => 'Novi',
		'US1840013143' => 'Fife Lake',
		'US1840003946' => 'Traverse City',
		'US1840003941' => 'Petoskey',
		'US1840003178' => 'South Haven',
		'US1840010941' => 'Harrietta',
		'US1840031756' => 'Edgemont Park',
		'US1840010940' => 'Onekama',
		'US1840003959' => 'Plymouth',
		'US1840002448' => 'Lathrup Village',
		'US1840013153' => 'Sebewaing',
		'US1840002435' => 'Walled Lake',
		'US1840003092' => 'Roseville',
		'US1840011003' => 'Otter Lake',
		'US1840003945' => 'East Jordan',
		'US1840010989' => 'Ravenna',
		'US1840024093' => 'Dowling',
		'US1840013136' => 'De Tour Village',
		'US1840010927' => 'Hillman',
		'US1840011056' => 'Holly',
		'US1840011083' => 'Bellevue',
		'US1840003969' => 'Dearborn',
		'US1840010932' => 'Lake Ann',
		'US1840011052' => 'Beverly Hills',
		'US1840004091' => 'Houghton Lake',
		'US1840011378' => 'Jonesville',
		'US1840002516' => 'Tawas City',
		'US1840010952' => 'Marion',
		'US1840031757' => 'South Gull Lake',
		'US1840013151' => 'Owendale',
		'US1840003988' => 'Petersburg',
		'US1840011384' => 'Mendon',
		'US1840025452' => 'Henderson',
		'US1840003976' => 'Grosse Pointe',
		'US1840025188' => 'Ponshewaing',
		'US1840002870' => 'Muskegon',
		'US1840010053' => 'Chesaning',
		'US1840001940' => 'Wakefield',
		'US1840001992' => 'Kingsford',
		'US1840011012' => 'Lennon',
		'US1840003952' => 'Harbor Beach',
		'US1840010926' => 'Vanderbilt',
		'US1840023960' => 'Arcadia',
		'US1840010925' => 'Mancelona',
		'US1840004173' => 'Canadian Lakes',
		'US1840011057' => 'Franklin',
		'US1840003967' => 'Allen Park',
		'US1840002431' => 'Southfield',
		'US1840010923' => 'Elk Rapids',
		'US1840011200' => 'Athens',
		'US1840023913' => 'Alba',
		'US1840011213' => 'Vicksburg',
		'US1840011058' => 'Milford',
		'US1840001971' => 'Gaastra',
		'US1840010953' => 'Tustin',
		'US1840003926' => 'Gladstone',
		'US1840003938' => 'Sault Ste. Marie',
		'US1840011211' => 'Richland',
		'US1840013146' => 'Twining',
		'US1840002661' => 'Coleman',
		'US1840003174' => 'Springfield',
		'US1840004225' => 'Hemlock',
		'US1840003948' => 'Omer',
		'US1840003072' => 'Laingsburg',
		'US1840010949' => 'Luther',
		'US1840010986' => 'Oakley',
		'US1840003954' => 'St. Clair',
		'US1840001990' => 'Norway',
		'US1840011374' => 'Onsted',
		'US1840013133' => 'Laurium',
		'US1840002949' => 'Flint',
		'US1840010050' => 'Akron',
		'US1840024058' => 'Bath',
		'US1840003920' => 'Hancock',
		'US1840002701' => 'Marlette',
		'US1840010970' => 'Fairgrove',
		'US1840025204' => 'Interlochen',
		'US1840003173' => 'Jackson',
		'US1840011022' => 'Eagle',
		'US1840023915' => 'Eastport',
		'US1840003111' => 'Otsego',
		'US1840010048' => 'Caro',
		'US1840011017' => 'Hubbardston',
		'US1840003960' => 'River Rouge',
		'US1840025189' => 'Advance',
		'US1840009988' => 'Carney',
		'US1840011019' => 'Lyons',
		'US1840002445' => 'Huntington Woods',
		'US1840011001' => 'Metamora',
		'US1840010913' => 'Ontonagon',
		'US1840002930' => 'Kentwood',
		'US1840010916' => 'Newberry',
		'US1840003181' => 'Hartford',
		'US1840010982' => 'Peck',
		'US1840004500' => 'Haslett',
		'US1840003986' => 'Melvindale',
		'US1840010993' => 'McBride',
		'US1840003964' => 'Southgate',
		'US1840010907' => 'Calumet',
		'US1840010156' => 'Allen',
		'US1840013145' => 'Turner',
		'US1840004305' => 'Northview',
		'US1840004364' => 'Middletown',
		'US1840010987' => 'Lakewood Club',
		'US1840003957' => 'Marysville',
		'US1840025182' => 'Brutus',
		'US1840011026' => 'Ovid',
		'US1840002434' => 'Troy',
		'US1840004304' => 'Forest Hills',
		'US1840010936' => 'Bear Lake',
		'US1840013154' => 'Ubly',
		'US1840003102' => 'Lansing',
		'US1840013157' => 'Estral Beach',
		'US1840010968' => 'Hesperia',
		'US1840011009' => 'Otisville',
		'US1840001972' => 'Iron River',
		'US1840073764' => 'Level Park-Oak Park',
		'US1840006579' => 'Temperance',
		'US1840011193' => 'Dexter',
		'US1840003176' => 'Battle Creek',
		'US1840006568' => 'Harvey',
		'US1840004073' => 'Lost Lake Woods',
		'US1840003251' => 'Reading',
		'US1840007675' => 'West Monroe',
		'US1840010153' => 'Clayton',
		'US1840011079' => 'Pinckney',
		'US1840004228' => 'Buena Vista',
		'US1840025191' => 'Horton Bay',
		'US1840010934' => 'Elberta',
		'US1840011205' => 'Lawton',
		'US1840003982' => 'Highland Park',
		'US1840003923' => 'Marquette',
		'US1840003105' => 'Olivet',
		'US1840025187' => 'Oden',
		'US1840010997' => 'Breckenridge',
		'US1840010914' => 'Baraga',
		'US1840002895' => 'Imlay City',
		'US1840002419' => 'Center Line',
		'US1840011091' => 'Woodland',
		'US1840003108' => 'Eaton Rapids',
		'US1840013144' => 'Sterling',
		'US1840010921' => 'Millersburg',
		'US1840011207' => 'Mattawan',
		'US1840004016' => 'Indian River',
		'US1840003940' => 'St. Ignace',
		'US1840024060' => 'Wacousta',
		'US1840002562' => 'Harrison',
		'US1840010910' => 'Caseville',
		'US1840002880' => 'Ithaca',
		'US1840000351' => 'Zilwaukee',
		'US1840002874' => 'Roosevelt Park',
		'US1840006570' => 'Republic',
		'US1840011231' => 'Three Oaks',
		'US1840002513' => 'Manton',
		'US1840003961' => 'Riverview',
		'US1840002443' => 'Ferndale',
		'US1840003256' => 'Dowagiac',
		'US1840003115' => 'Fennville',
		'US1840023965' => 'Stronach',
		'US1840002876' => 'Carson City',
		'US1840002700' => 'Croswell',
		'US1840073782' => 'Barnes Lake-Millers Lake',
		'US1840010152' => 'Cement City',
		'US1840026100' => 'Zeba',
		'US1840023970' => 'Jennings',
		'US1840006571' => 'Trowbridge Park',
		'US1840003099' => 'Brighton',
		'US1840011092' => 'Hopkins',
		'US1840011380' => 'North Adams',
		'US1840002583' => 'Bay City',
		'US1840002945' => 'Burton',
		'US1840002511' => 'Manistee',
		'US1840010977' => 'Deckerville',
		'US1840010962' => 'Rosebush',
		'US1840025432' => 'Snover',
		'US1840006844' => 'Weidman',
		'US1840003965' => 'Taylor',
		'US1840011212' => 'Schoolcraft',
		'US1840011224' => 'Berrien Springs',
		'US1840011382' => 'Colon',
		'US1840026086' => 'Bay Port',
		'US1840013142' => 'Kingsley',
		'US1840010906' => 'Ahmeek',
		'US1840025268' => 'Marenisco',
		'US1840010942' => 'Mesick',
		'US1840010922' => 'Bellaire',
		'US1840025431' => 'Fostoria',
		'US1840002441' => 'Farmington',
		'US1840007676' => 'Woodland Beach',
		'US1840002064' => 'Onaway',
		'US1840006924' => 'Waverly',
		'US1840011013' => 'Morrice',
		'US1840002686' => 'Vassar',
		'US1840002879' => 'Alma',
		'US1840010966' => 'Morley',
		'US1840004227' => 'Bridgeport',
		'US1840010049' => 'Cass City',
		'US1840003179' => 'Bangor',
		'US1840003950' => 'Au Gres',
		'US1840013158' => 'Maybee',
		'US1840002442' => 'Farmington Hills',
		'US1840002877' => 'Greenville',
		'US1840003958' => 'Northville',
		'US1840004027' => 'Canada Creek Ranch',
		'US1840004502' => 'Okemos',
		'US1840039607' => 'Wedgewood',
		'US1840010988' => 'Fruitport',
		'US1840011061' => 'Wolverine Lake',
		'US1840010064' => 'Clifford',
		'US1840002994' => 'Ferrysburg',
		'US1840011208' => 'Paw Paw',
		'US1840006923' => 'Whitmore Lake',
		'US1840010119' => 'Burlington',
		'US1840002952' => 'Linden',
		'US1840010984' => 'St. Charles',
		'US1840011055' => 'Leonard',
		'US1840010979' => 'Port Sanilac',
		'US1840000420' => 'Williamston',
		'US1840073805' => 'Village of Grosse Pointe Shores',
		'US1840003944' => 'Charlevoix',
		'US1840003184' => 'Galesburg',
		'US1840010999' => 'Columbiaville',
		'US1840003951' => 'Bad Axe',
		'US1840011227' => 'Galien',
		'US1840025190' => 'Bay Shore',
		'US1840010983' => 'Birch Run',
		'US1840003112' => 'Plainwell',
		'US1840011228' => 'Michiana',
		'US1840006573' => 'Greilickville',
		'US1840002421' => 'Fraser',
		'US1840002582' => 'Auburn',
		'US1840002560' => 'Evart',
		'US1840002006' => 'Menominee',
		'US1840013134' => 'Copper City',
		'US1840003922' => 'Ishpeming',
		'US1840003214' => 'Watervliet',
		'US1840004342' => 'Argentine',
		'US1840002931' => 'Lowell',
		'US1840006572' => 'Big Bay',
		'US1840001847' => 'Westland',
		'US1840011060' => 'Oxford',
		'US1840010909' => 'Alanson',
		'US1840000407' => 'Wixom',
		'US1840011386' => 'Edwardsburg',
		'US1840003073' => 'Portland',
		'US1840002662' => 'Hart',
		'US1840003069' => 'Perry',
		'US1840011375' => 'Quincy',
		'US1840010978' => 'Forestville',
		'US1840006925' => 'Douglas',
		'US1840010919' => 'Wolverine',
		'US1840010946' => 'Fountain',
		'US1840011204' => 'Lawrence',
		'US1840001845' => 'Yale',
		'US1840003953' => 'Port Huron',
		'US1840002515' => 'McBain',
		'US1840003968' => 'Belleville',
		'US1840004092' => 'Prudenville',
		'US1840002944' => 'Swartz Creek',
		'US1840002663' => 'Mount Pleasant',
		'US1840002698' => 'Sandusky',
		'US1840000317' => 'West Branch',
		'US1840003975' => 'Gibraltar',
		'US1840011005' => 'Sand Lake',
		'US1840010992' => 'Edmore',
		'US1840003919' => 'Houghton',
		'US1840011089' => 'Middleville',
		'US1840002432' => 'South Lyon',
		'US1840002993' => 'Coopersville',
		'US1840010944' => 'Prescott',
		'US1840003107' => 'Charlotte',
		'US1840003090' => 'New Baltimore',
		'US1840010938' => 'Copemish',
		'US1840002428' => 'Rochester',
		'US1840011376' => 'Sherwood',
		'US1840002928' => 'Grand Rapids',
		'US1840010937' => 'Kaleva',
		'US1840004093' => 'St. Helen',
		'US1840002943' => 'Mount Morris',
		'US1840010118' => 'Brooklyn',
		'US1840009980' => 'Alpha',
		'US1840002872' => 'North Muskegon',
		'US1840001848' => 'Woodhaven',
		'US1840003074' => 'Belding',
		'US1840006576' => 'Lambertville',
		'US1840010991' => 'Howard City',
		'US1840010915' => 'LAnse',
		'US1840025199' => 'Leland',
		'US1840001846' => 'Wayne',
		'US1840010963' => 'Shepherd',
		'US1840000366' => 'Whitehall',
		'US1840010951' => 'Hersey',
		'US1840003185' => 'Kalamazoo',
		'US1840025183' => 'Carp Lake',
		'US1840010071' => 'Byron',
		'US1840003103' => 'Leslie',
		'US1840010948' => 'Baldwin',
		'US1840011090' => 'Nashville',
		'US1840002437' => 'Berkley',
		'US1840004308' => 'Cutlerville',
		'US1840001942' => 'Ironwood',
		'US1840003921' => 'Negaunee',
		'US1840004172' => 'Beal City',
		'US1840003212' => 'Niles',
		'US1840023947' => 'Pilgrim',
		'US1840025274' => 'Amasa',
		'US1840010947' => 'Free Soil',
		'US1840010945' => 'Custer',
		'US1840003987' => 'Monroe',
		'US1840003171' => 'Saline',
		'US1840026143' => 'Loomis',
		'US1840011229' => 'Shoreham',
		'US1840010063' => 'Casnovia',
		'US1840002420' => 'Eastpointe',
		'US1840010959' => 'Shelby',
		'US1840011025' => 'Maple Rapids',
		'US1840002679' => 'Newaygo',
		'US1840003110' => 'Hastings',
		'US1840011011' => 'Bancroft',
		'US1840003984' => 'Lincoln Park',
		'US1840003943' => 'Boyne City',
		'US1840003180' => 'Gobles',
		'US1840011006' => 'Sparta',
		'US1840000421' => 'Wayland',
		'US1840039592' => 'Presque Isle Harbor',
		'US1840002148' => 'Gaylord',
		'US1840002871' => 'Muskegon Heights',
		'US1840002680' => 'Fremont',
		'US1840011198' => 'Parma',
		'US1840002813' => 'Saginaw',
		'US1840002447' => 'Lake Angelus',
		'US1840003100' => 'Howell',
		'US1840002429' => 'Rochester Hills',
		'US1840010917' => 'Daggett',
		'US1840025444' => 'Attica',
		'US1840001969' => 'Caspian',
		'US1840025269' => 'Watersmeet',
		'US1840003956' => 'Marine City',
		'US1840023945' => 'Bendon',
		'US1840006569' => 'Palmer',
		'US1840004345' => 'Allendale',
		'US1840002563' => 'Beaverton',
		'US1840073772' => 'Robin Glen-Indiantown',
		'US1840002514' => 'Lake City',
		'US1840011372' => 'Clinton',
		'US1840010151' => 'Britton',
		'US1840011004' => 'Kent City',
		'US1840011010' => 'Spring Lake',
		'US1840010929' => 'Kalkaska',
		'US1840039593' => 'Vineyard Lake',
		'US1840003215' => 'Benton Harbor',
		'US1840031758' => 'K. I. Sawyer',
		'US1840006976' => 'Chelsea',
		'US1840025201' => 'Omena',
		'US1840023961' => 'Brethren',
		'US1840023935' => 'South Boardman',
		'US1840004236' => 'Twin Lake',
		'US1840002439' => 'Bloomfield Hills',
		'US1840013140' => 'Northport',
		'US1840003109' => 'Grand Ledge',
		'US1840025198' => 'Lake Leelanau',
		'US1840011196' => 'Hanover',
		'US1840039589' => 'Manistee Lake',
		'US1840002925' => 'Walker',
		'US1840003175' => 'Albion',
		'US1840027031' => 'Eagle River',
		'US1840006978' => 'Westwood',
		'US1840025192' => 'Ironton',
		'US1840003114' => 'Allegan',
		'US1840013135' => 'Garden',
		'US1840023914' => 'Alden',
		'US1840138223' => 'Lakes of the North',
		'US1840003980' => 'Hamtramck',
		'US1840003978' => 'Grosse Pointe Park',
		'US1840011082' => 'Webberville',
		'US1840011230' => 'Stevensville',
		'US1840002997' => 'Hudsonville',
		'US1840003211' => 'New Buffalo',
		'US1840004306' => 'Byron Center',
		'US1840026077' => 'Eagle Harbor',
		'US1840003091' => 'Richmond',
		'US1840011081' => 'Stockbridge',
		'US1840011018' => 'Saranac',
		'US1840003253' => 'Litchfield',
		'US1840010933' => 'Honor',
		'US1840002561' => 'Clare',
		'US1840003979' => 'Grosse Pointe Woods',
		'US1840003229' => 'Hudson',
		'US1840025200' => 'Maple City',
		'US1840006565' => 'Hubbell',
		'US1840010981' => 'Minden City',
		'US1840002433' => 'Sylvan Lake',
		'US1840003113' => 'Saugatuck',
		'US1840010954' => 'Farwell',
		'US1840004652' => 'Michigan Center',
		'US1840073785' => 'Comstock Northwest',
		'US1840004654' => 'Spring Arbor',
		'US1840002678' => 'Big Rapids',
		'US1840023963' => 'Oak Hill',
		'US1840003183' => 'Portage',
		'US1840003093' => 'St. Clair Shores',
		'US1840006578' => 'Stony Point',
		'US1840010943' => 'Roscommon',
		'US1840011021' => 'Pewamo',
		'US1840039583' => 'Crystal Mountain',
		'US1840073780' => 'Shorewood-Tower Hills-Harbert',
		'US1840011226' => 'Eau Claire',
		'US1840002418' => 'Warren',
		'US1840025185' => 'Cross Village',
		'US1840025184' => 'Conway',
		'US1840011377' => 'Union City',
		'US1840025202' => 'Chums Corner',
		'US1840002291' => 'Grayling',
		'US1840003981' => 'Harper Woods',
		'US1840010990' => 'Lakeview',
		'US1840003106' => 'Potterville',
		'US1840039582' => 'Crystal Downs Country Club',
		'US1840002950' => 'Flushing',
		'US1840003972' => 'Ecorse',
		'US1840000459' => 'Ypsilanti',
		'US1840010930' => 'Benzonia',
		'US1840011388' => 'Vandalia',
		'US1840010971' => 'Gagetown',
		'US1840001849' => 'Wyandotte',
		'US1840003226' => 'Adrian',
		'US1840003075' => 'Ionia',
		'US1840072998' => 'Orchard Lake Village',
		'US1840010911' => 'Capac',
		'US1840002996' => 'Holland',
		'US1840003255' => 'Three Rivers',
		'US1840010935' => 'Thompsonville',
		'US1840013155' => 'Emmett',
		'US1840011020' => 'Muir',
		'US1840006977' => 'Vandercook Lake',
		'US1840002946' => 'Clio',
		'US1840004075' => 'Mio',
		'US1840011379' => 'Montgomery',
		'US1840006566' => 'Michigamme',
		'US1840002444' => 'Hazel Park',
		'US1840002927' => 'East Grand Rapids',
		'US1840010002' => 'Central Lake',
		'US1840039588' => 'Lake Victoria',
		'US1840011024' => 'Fowler',
		'US1840003068' => 'Owosso',
		'US1840013141' => 'Suttons Bay',
		'US1840011194' => 'Manchester',
		'US1840003942' => 'Harbor Springs',
		'US1840002564' => 'Gladwin',
		'US1840011199' => 'Springport',
		'US1840003071' => 'Durand',
		'US1840001991' => 'Iron Mountain',
		'US1840010975' => 'Unionville',
		'US1840002304' => 'Frankfort',
		'US1840002436' => 'Auburn Hills',
		'US1840013156' => 'Dundee',
		'US1840002547' => 'Ludington',
		'US1840010960' => 'Walkerville',
		'US1840010958' => 'Pentwater',
		'US1840002896' => 'Lapeer',
		'US1840002926' => 'Cedar Springs',
		'US1840073796' => 'Village of Clarkston',
		'US1840011383' => 'Constantine',
		'US1840003249' => 'Bronson',
		'US1840010051' => 'Carsonville',
		'US1840010924' => 'Ellsworth',
		'US1840039591' => 'Maple Grove',
		'US1840002660' => 'Midland',
		'US1840002065' => 'Rogers City',
		'US1840025506' => 'New Troy',
		'US1840004094' => 'Oscoda',
		'US1840011387' => 'Marcellus',
		'US1840002426' => 'Pleasant Ridge',
		'US1840004026' => 'Atlanta',
		'US1840004653' => 'Napoleon',
		'US1840011201' => 'Homer',
		'US1840004699' => 'Paw Paw Lake',
		'US1840003955' => 'Algonac',
		'US1840011088' => 'Freeport',
		'US1840011209' => 'Augusta',
		'US1840010961' => 'Lake Isabella',
		'US1840003974' => 'Garden City',
		'US1840010912' => 'Carleton',
		'US1840024094' => 'Hickory Corners',
		'US1840010973' => 'Mayville',
		'US1840013137' => 'Pellston',
		'US1840011371' => 'Blissfield',
		'US1840003962' => 'Rockwood',
		'US1840002417' => 'Utica',
		'US1840000344' => 'White Cloud',
		'US1840011050' => 'Romeo',
		'US1840002424' => 'Oak Park',
		'US1840010996' => 'Ashley',
		'US1840013131' => 'South Range',
		'US1840004346' => 'Beechwood',
		'US1840003213' => 'St. Joseph',
		'US1840003182' => 'Parchment',
		'US1840010158' => 'Centreville',
		'US1840010965' => 'Mecosta',
		'US1840025196' => 'Cedar',
		'US1840073765' => 'Manitou Beach-Devils Lake',
		'US1840001970' => 'Crystal Falls',
		'US1840010928' => 'Lincoln',
		'US1840011085' => 'Mulliken',
		'US1840011385' => 'White Pigeon',
		'US1840011093' => 'Martin',
		'US1840011053' => 'Bingham Farms',
		'US1840013139' => 'Empire',
		'US1840003977' => 'Grosse Pointe Farms',
		'US1840003924' => 'Munising',
		'US1840011078' => 'Fowlerville',
		'US1840004344' => 'Jenison',
		'US1840006575' => 'Pearl Beach',
		'US1840001941' => 'Bessemer',
		'US1840013148' => 'Elkton',
		'US1840011002' => 'North Branch',
		'US1840023966' => 'Wellston',
		'US1840003218' => 'Coloma',
		'US1840002007' => 'Stephenson',
		'US1840004307' => 'Comstock Park',
		'US1840013159' => 'South Rockwood',
		'US1840011008' => 'Gaines',
		'US1840026076' => 'Copper Harbor',
		'US1840010931' => 'Beulah',
		'US1840003089' => 'Mount Clemens',
		'US1840002584' => 'Essexville',
		'US1840006577' => 'South Monroe',
		'US1840010974' => 'Millington',
		'US1840010155' => 'Camden',
		'US1840002581' => 'Pinconning',
		'US1840133994' => 'Hubbard Lake',
		'US1840010052' => 'Applegate',
		'US1840010159' => 'Cassopolis',
		'US1840002559' => 'Reed City',
		'US1840003216' => 'Bridgman',
		'US1840023969' => 'Haring',
		'US1840002422' => 'Memphis',
		'US1840002047' => 'Cheboygan',
		'US1840002430' => 'Royal Oak',
		'US1840002948' => 'Fenton',
		'US1840002517' => 'East Tawas',
		'US1840010154' => 'Addison',
		'US1840010969' => 'Kingston',
		'US1840004698' => 'Lake Michigan Beach',
		'US1840011195' => 'Grass Lake',
		'US1840023967' => 'Boon',
		'US1840011023' => 'Elsie',
		'US1840010908' => 'Chatham',
		'US1840013147' => 'Kinde',
		'US1840002942' => 'Montrose',
		'US1840010994' => 'Pierson',
		'US1840011059' => 'Ortonville',
	],
	'KS' => [
		'US1840007457' => 'Holyrood',
		'US1840030355' => 'Parkerfield',
		'US1840001705' => 'Caney',
		'US1840001648' => 'Council Grove',
		'US1840003832' => 'Mission Hills',
		'US1840007326' => 'Aurora',
		'US1840009639' => 'Rantoul',
		'US1840008453' => 'Miltonvale',
		'US1840010704' => 'Waldo',
		'US1840008428' => 'Morrill',
		'US1840008640' => 'Lehigh',
		'US1840008763' => 'Liberty',
		'US1840001687' => 'Pratt',
		'US1840009909' => 'Protection',
		'US1840026673' => 'Wakarusa',
		'US1840009511' => 'Summerfield',
		'US1840009690' => 'Paxico',
		'US1840010837' => 'Whitewater',
		'US1840009662' => 'Peabody',
		'US1840008695' => 'Moran',
		'US1840007518' => 'Burdett',
		'US1840007295' => 'Hamlin',
		'US1840007592' => 'Arma',
		'US1840008767' => 'Labette',
		'US1840007382' => 'Culver',
		'US1840010832' => 'Willowbrook',
		'US1840009661' => 'Tampa',
		'US1840008423' => 'Kirwin',
		'US1840007297' => 'Centralia',
		'US1840008639' => 'Goessel',
		'US1840009887' => 'St. Paul',
		'US1840007535' => 'Climax',
		'US1840008418' => 'Norcatur',
		'US1840006086' => 'Brookville',
		'US1840008429' => 'Goff',
		'US1840009856' => 'Rose Hill',
		'US1840007349' => 'Cawker City',
		'US1840009832' => 'St. John',
		'US1840009585' => 'Louisville',
		'US1840001661' => 'Hillsboro',
		'US1840009766' => 'Pretty Prairie',
		'US1840009656' => 'Rush Center',
		'US1840008474' => 'Green',
		'US1840008470' => 'Menlo',
		'US1840010815' => 'Westphalia',
		'US1840007481' => 'Claflin',
		'US1840001641' => 'Shawnee',
		'US1840001635' => 'Fairway',
		'US1840009864' => 'Redfield',
		'US1840007527' => 'Hanston',
		'US1840008472' => 'Downs',
		'US1840007613' => 'Hardtner',
		'US1840024537' => 'Detroit',
		'US1840008547' => 'McFarland',
		'US1840007568' => 'Haysville',
		'US1840010549' => 'Webber',
		'US1840008430' => 'Elwood',
		'US1840001716' => 'Galena',
		'US1840001708' => 'Independence',
		'US1840007608' => 'Conway Springs',
		'US1840010845' => 'Uniontown',
		'US1840009508' => 'Long Island',
		'US1840009889' => 'Longton',
		'US1840007353' => 'Belvue',
		'US1840007291' => 'Agra',
		'US1840001652' => 'Emporia',
		'US1840007621' => 'Danville',
		'US1840007482' => 'Albert',
		'US1840008703' => 'Eastborough',
		'US1840008624' => 'Leoti',
		'US1840001628' => 'Hays',
		'US1840026739' => 'Roxbury',
		'US1840008715' => 'Iuka',
		'US1840009638' => 'Princeton',
		'US1840009704' => 'Solomon',
		'US1840026807' => 'Fort Dodge',
		'US1840009659' => 'Lincolnville',
		'US1840001541' => 'Concordia',
		'US1840001710' => 'Harper',
		'US1840008751' => 'Meade',
		'US1840008506' => 'Nortonville',
		'US1840010702' => 'Victoria',
		'US1840009762' => 'South Hutchinson',
		'US1840008747' => 'Mayfield',
		'US1840008556' => 'Enterprise',
		'US1840008694' => 'Mildred',
		'US1840009513' => 'Reserve',
		'US1840007477' => 'Dighton',
		'US1840008685' => 'Lewis',
		'US1840009748' => 'Pleasanton',
		'US1840010552' => 'Waterville',
		'US1840007522' => 'Deerfield',
		'US1840010661' => 'Tonganoxie',
		'US1840009685' => 'Silver Lake',
		'US1840008656' => 'New Strawn',
		'US1840007609' => 'Argonia',
		'US1840008698' => 'Montezuma',
		'US1840001694' => 'Chanute',
		'US1840009831' => 'Radium',
		'US1840010873' => 'Waldron',
		'US1840008459' => 'Lancaster',
		'US1840007275' => 'Bird City',
		'US1840008558' => 'Eudora',
		'US1840005754' => 'Brewster',
		'US1840009778' => 'Overbrook',
		'US1840007412' => 'Bunker Hill',
		'US1840026728' => 'Hillsdale',
		'US1840007281' => 'Courtland',
		'US1840009588' => 'St. George',
		'US1840007562' => 'Bucklin',
		'US1840008415' => 'Greenleaf',
		'US1840026732' => 'Healy',
		'US1840026808' => 'Wright',
		'US1840001620' => 'Junction City',
		'US1840009584' => 'Riley',
		'US1840007280' => 'Athol',
		'US1840009582' => 'Scottsville',
		'US1840007624' => 'Coldwater',
		'US1840007467' => 'Bushong',
		'US1840003857' => 'Oswego',
		'US1840000728' => 'Sabetha',
		'US1840009512' => 'Powhattan',
		'US1840009647' => 'Scott City',
		'US1840010831' => 'Turon',
		'US1840007278' => 'Burr Oak',
		'US1840001626' => 'Kansas City',
		'US1840009776' => 'Lyndon',
		'US1840009610' => 'Ozawkie',
		'US1840009705' => 'Lucas',
		'US1840008543' => 'Grandview Plaza',
		'US1840008754' => 'Medicine Lodge',
		'US1840003846' => 'Newton',
		'US1840045965' => 'Bel Aire',
		'US1840007300' => 'Denton',
		'US1840001554' => 'Clay Center',
		'US1840007625' => 'Altamont',
		'US1840001630' => 'Herington',
		'US1840009764' => 'Partridge',
		'US1840007488' => 'Burns',
		'US1840001684' => 'Dodge City',
		'US1840007623' => 'Bluff City',
		'US1840007373' => 'Basehor',
		'US1840007517' => 'Blue Mound',
		'US1840007588' => 'Altoona',
		'US1840009505' => 'Mahaska',
		'US1840001715' => 'Columbus',
		'US1840001673' => 'Hutchinson',
		'US1840010773' => 'Tribune',
		'US1840009575' => 'Palco',
		'US1840010830' => 'Virgil',
		'US1840008702' => 'Ford',
		'US1840001717' => 'Scammon',
		'US1840009899' => 'South Haven',
		'US1840009903' => 'Sun City',
		'US1840000729' => 'Seneca',
		'US1840001704' => 'Liberal',
		'US1840008759' => 'Elkhart',
		'US1840008426' => 'Everest',
		'US1840008706' => 'Mount Hope',
		'US1840009502' => 'Republic',
		'US1840009654' => 'Liebenthal',
		'US1840007414' => 'Collyer',
		'US1840026686' => 'Munjor',
		'US1840010829' => 'Walton',
		'US1840008479' => 'Ogden',
		'US1840009722' => 'Smolan',
		'US1840007405' => 'Harveyville',
		'US1840008762' => 'Elk City',
		'US1840009625' => 'Tescott',
		'US1840008766' => 'Mound Valley',
		'US1840003843' => 'Marion',
		'US1840001702' => 'Caldwell',
		'US1840001664' => 'Burlington',
		'US1840001634' => 'Edgerton',
		'US1840007585' => 'Cunningham',
		'US1840010632' => 'Wakefield',
		'US1840008634' => 'Galva',
		'US1840008647' => 'Elmdale',
		'US1840026852' => 'Milton',
		'US1840007413' => 'Dorrance',
		'US1840008704' => 'Garden Plain',
		'US1840003766' => 'Oberlin',
		'US1840003833' => 'Olathe',
		'US1840008507' => 'Easton',
		'US1840010700' => 'Winona',
		'US1840007591' => 'Arcadia',
		'US1840001625' => 'Edwardsville',
		'US1840026831' => 'Franklin',
		'US1840009833' => 'Seward',
		'US1840001679' => 'Yates Center',
		'US1840007429' => 'Assaria',
		'US1840009574' => 'Stockton',
		'US1840008638' => 'Durham',
		'US1840008720' => 'New Albany',
		'US1840001631' => 'Russell',
		'US1840008505' => 'Meriden',
		'US1840009917' => 'Peru',
		'US1840008544' => 'Milford',
		'US1840073792' => 'Gove City',
		'US1840008724' => 'McCune',
		'US1840008670' => 'Jetmore',
		'US1840008696' => 'Fulton',
		'US1840008765' => 'Edna',
		'US1840030354' => 'Linn Valley',
		'US1840008675' => 'North Newton',
		'US1840007523' => 'Holcomb',
		'US1840009660' => 'Lost Springs',
		'US1840008616' => 'Neosho Rapids',
		'US1840003806' => 'Osborne',
		'US1840007545' => 'Cassoday',
		'US1840001642' => 'Spring Hill',
		'US1840001588' => 'Beloit',
		'US1840010701' => 'Wallace',
		'US1840010784' => 'Windom',
		'US1840008420' => 'Edmond',
		'US1840007536' => 'Hamilton',
		'US1840007549' => 'Belpre',
		'US1840008681' => 'Elbing',
		'US1840010857' => 'Zenda',
		'US1840007458' => 'Burlingame',
		'US1840008477' => 'Glen Elder',
		'US1840001662' => 'Lyons',
		'US1840001691' => 'Haviland',
		'US1840010836' => 'Towanda',
		'US1840026662' => 'Grantville',
		'US1840007383' => 'Bennington',
		'US1840009901' => 'Plains',
		'US1840008760' => 'Moscow',
		'US1840007471' => 'Hartford',
		'US1840007296' => 'Corning',
		'US1840007581' => 'Coats',
		'US1840007329' => 'Delia',
		'US1840001640' => 'Roeland Park',
		'US1840009876' => 'Preston',
		'US1840008409' => 'Jewell',
		'US1840010767' => 'Wellsville',
		'US1840007469' => 'Allen',
		'US1840008457' => 'Effingham',
		'US1840009750' => 'Rozel',
		'US1840007487' => 'Canton',
		'US1840007563' => 'Clearwater',
		'US1840001667' => 'Larned',
		'US1840003768' => 'Marysville',
		'US1840007538' => 'Abbyville',
		'US1840026791' => 'Rosalia',
		'US1840009503' => 'Scandia',
		'US1840009760' => 'Madison',
		'US1840000725' => 'Phillipsburg',
		'US1840007384' => 'Delphos',
		'US1840010555' => 'Troy',
		'US1840010777' => 'Timken',
		'US1840007298' => 'Bern',
		'US1840001590' => 'Lansing',
		'US1840009655' => 'Otis',
		'US1840008665' => 'Mound City',
		'US1840007328' => 'Hoyt',
		'US1840009652' => 'Olmitz',
		'US1840008427' => 'Fairview',
		'US1840008469' => 'Gem',
		'US1840007566' => 'Andale',
		'US1840007498' => 'Cedar Point',
		'US1840009862' => 'Savonburg',
		'US1840007484' => 'Bison',
		'US1840008755' => 'Isabel',
		'US1840007611' => 'Hunnewell',
		'US1840009774' => 'Parkerville',
		'US1840007607' => 'Dexter',
		'US1840007277' => 'Herndon',
		'US1840010692' => 'Willard',
		'US1840009684' => 'Sylvan Grove',
		'US1840009636' => 'Reading',
		'US1840007289' => 'Clayton',
		'US1840008416' => 'Morrowville',
		'US1840009698' => 'Russell Springs',
		'US1840007346' => 'Damar',
		'US1840007516' => 'Colony',
		'US1840001681' => 'Iola',
		'US1840009777' => 'Olivet',
		'US1840007595' => 'Howard',
		'US1840010634' => 'Wamego',
		'US1840009580' => 'Longford',
		'US1840008777' => 'Elgin',
		'US1840009765' => 'Plevna',
		'US1840010856' => 'Ulysses',
		'US1840007348' => 'Hoxie',
		'US1840001663' => 'Sterling',
		'US1840007610' => 'Belle Plaine',
		'US1840039292' => 'Kickapoo Site 1',
		'US1840009651' => 'Susank',
		'US1840008668' => 'Lakin',
		'US1840039303' => 'Kickapoo Site 5',
		'US1840026763' => 'Harris',
		'US1840010703' => 'Woodbine',
		'US1840001703' => 'Wellington',
		'US1840009761' => 'Severy',
		'US1840001672' => 'Eureka',
		'US1840008573' => 'New Cambria',
		'US1840009509' => 'Speed',
		'US1840008406' => 'McDonald',
		'US1840008473' => 'Natoma',
		'US1840006318' => 'Bronson',
		'US1840001637' => 'Lake Quivira',
		'US1840008752' => 'Englewood',
		'US1840007400' => 'Beverly',
		'US1840001697' => 'Pittsburg',
		'US1840008412' => 'Lebanon',
		'US1840008635' => 'Marquette',
		'US1840001666' => 'Garnett',
		'US1840008692' => 'Elsmore',
		'US1840001627' => 'Ellis',
		'US1840010553' => 'Willis',
		'US1840008761' => 'Kismet',
		'US1840008417' => 'Dresden',
		'US1840008407' => 'Esbon',
		'US1840007582' => 'Cullison',
		'US1840001714' => 'Baxter Springs',
		'US1840007605' => 'Cambridge',
		'US1840008778' => 'Niotaze',
		'US1840009885' => 'Stark',
		'US1840009870' => 'Park City',
		'US1840007287' => 'Hanover',
		'US1840010633' => 'Tipton',
		'US1840008749' => 'Milan',
		'US1840009807' => 'Little River',
		'US1840003824' => 'Minneapolis',
		'US1840003840' => 'Ottawa',
		'US1840010636' => 'Wheaton',
		'US1840010868' => 'Udall',
		'US1840007619' => 'Havana',
		'US1840009780' => 'Scranton',
		'US1840001712' => 'Parsons',
		'US1840030179' => 'Wilroads Gardens',
		'US1840008677' => 'Langdon',
		'US1840026794' => 'Piqua',
		'US1840010612' => 'Whiting',
		'US1840007555' => 'Bassett',
		'US1840007524' => 'Coolidge',
		'US1840007565' => 'Cheney',
		'US1840030285' => 'Mission Woods',
		'US1840010808' => 'Waverly',
		'US1840026715' => 'Vassar',
		'US1840009756' => 'Syracuse',
		'US1840007403' => 'Alma',
		'US1840009806' => 'Strong City',
		'US1840008756' => 'Kiowa',
		'US1840007593' => 'Hepler',
		'US1840010848' => 'Valley Center',
		'US1840003853' => 'Neodesha',
		'US1840007293' => 'Beattie',
		'US1840008413' => 'Munden',
		'US1840010556' => 'Wathena',
		'US1840008719' => 'Norwich',
		'US1840009567' => 'Soldier',
		'US1840001660' => 'Florence',
		'US1840010659' => 'Valley Falls',
		'US1840010705' => 'WaKeeney',
		'US1840009663' => 'Ramona',
		'US1840010550' => 'Vining',
		'US1840007497' => 'Cottonwood Falls',
		'US1840008627' => 'McCracken',
		'US1840010635' => 'Westmoreland',
		'US1840007580' => 'Byers',
		'US1840008723' => 'Galesburg',
		'US1840008663' => 'Greeley',
		'US1840008746' => 'Geuda Springs',
		'US1840009514' => 'Robinson',
		'US1840003836' => 'Osage City',
		'US1840007559' => 'Copeland',
		'US1840073794' => 'Johnson City',
		'US1840026764' => 'Welda',
		'US1840009499' => 'Mankato',
		'US1840008658' => 'LeRoy',
		'US1840007399' => 'Barnard',
		'US1840003831' => 'Mission',
		'US1840007401' => 'Auburn',
		'US1840009507' => 'Logan',
		'US1840073757' => 'Fort Riley',
		'US1840001676' => 'El Dorado',
		'US1840008408' => 'Formoso',
		'US1840026866' => 'Lowell',
		'US1840024462' => 'Asherville',
		'US1840007634' => 'Cedar Vale',
		'US1840007350' => 'Hunter',
		'US1840009883' => 'Spivey',
		'US1840003830' => 'Merriam',
		'US1840009900' => 'Oxford',
		'US1840026734' => 'Odin',
		'US1840009863' => 'Mapleton',
		'US1840009498' => 'St. Francis',
		'US1840010751' => 'White City',
		'US1840039297' => 'Kickapoo Site 2',
		'US1840039348' => 'Kickapoo Site 7',
		'US1840009583' => 'Randolph',
		'US1840008748' => 'Mulvane',
		'US1840039307' => 'Kickapoo Site 6',
		'US1840009611' => 'Perry',
		'US1840008411' => 'Kensington',
		'US1840008546' => 'Eskridge',
		'US1840009707' => 'Paradise',
		'US1840001632' => 'Lawrence',
		'US1840009500' => 'Randall',
		'US1840007589' => 'Benedict',
		'US1840000723' => 'Belleville',
		'US1840007539' => 'Arlington',
		'US1840007294' => 'Blue Rapids',
		'US1840001680' => 'Humboldt',
		'US1840001621' => 'Topeka',
		'US1840003847' => 'Nickerson',
		'US1840024599' => 'Kipp',
		'US1840009701' => 'Park',
		'US1840008636' => 'Moundridge',
		'US1840009749' => 'Prescott',
		'US1840008667' => 'Garfield',
		'US1840010753' => 'Wilson',
		'US1840009915' => 'Roseland',
		'US1840001629' => 'Abilene',
		'US1840007590' => 'Cherokee',
		'US1840007533' => 'Burrton',
		'US1840009501' => 'Smith Center',
		'US1840001671' => 'Halstead',
		'US1840009578' => 'Portis',
		'US1840009759' => 'Sedgwick',
		'US1840001686' => 'Wichita',
		'US1840010554' => 'Wetmore',
		'US1840009586' => 'Olsburg',
		'US1840001553' => 'Colby',
		'US1840007548' => 'Douglass',
		'US1840010844' => 'Toronto',
		'US1840008699' => 'Ingalls',
		'US1840001543' => 'Atchison',
		'US1840007534' => 'Hesston',
		'US1840001653' => 'Louisburg',
		'US1840007483' => 'Alexander',
		'US1840008707' => 'Kechi',
		'US1840007499' => 'Bushton',
		'US1840009855' => 'Potwin',
		'US1840001657' => 'Hoisington',
		'US1840001707' => 'Coffeyville',
		'US1840008618' => 'Fontana',
		'US1840008455' => 'Mayetta',
		'US1840008458' => 'Muscotah',
		'US1840008478' => 'Morland',
		'US1840008718' => 'Nashville',
		'US1840026685' => 'Catharine',
		'US1840026727' => 'Bucyrus',
		'US1840008648' => 'Matfield Green',
		'US1840010557' => 'White Cloud',
		'US1840009579' => 'Selden',
		'US1840008683' => 'Leon',
		'US1840007430' => 'Gypsum',
		'US1840007325' => 'Clyde',
		'US1840009706' => 'Luray',
		'US1840008693' => 'Gas',
		'US1840026684' => 'Weskan',
		'US1840009702' => 'Quinter',
		'US1840001709' => 'Anthony',
		'US1840007468' => 'Admire',
		'US1840008753' => 'Minneola',
		'US1840007500' => 'Chase',
		'US1840001647' => 'Salina',
		'US1840007285' => 'Barnes',
		'US1840001542' => 'Holton',
		'US1840010849' => 'Viola',
		'US1840007459' => 'Carbondale',
		'US1840000727' => 'Horton',
		'US1840007635' => 'Chautauqua',
		'US1840073795' => 'Lincoln Center',
		'US1840007626' => 'Bartlett',
		'US1840008431' => 'Leona',
		'US1840026733' => 'Marienthal',
		'US1840001656' => 'Great Bend',
		'US1840008666' => 'La Cygne',
		'US1840007330' => 'Denison',
		'US1840008691' => 'Neosho Falls',
		'US1840008410' => 'Gaylord',
		'US1840007537' => 'Buhler',
		'US1840007622' => 'Attica',
		'US1840007354' => 'Havensville',
		'US1840001696' => 'Girard',
		'US1840008732' => 'Elk Falls',
		'US1840008628' => 'La Crosse',
		'US1840008733' => 'Moline',
		'US1840007351' => 'Bogue',
		'US1840009775' => 'Lorraine',
		'US1840008476' => 'Morganville',
		'US1840009506' => 'Palmer',
		'US1840001718' => 'Weir',
		'US1840007564' => 'Colwich',
		'US1840008602' => 'Dwight',
		'US1840007526' => 'Hudson',
		'US1840009908' => 'Rolla',
		'US1840007409' => 'Carlton',
		'US1840026645' => 'Levant',
		'US1840007288' => 'Hollenberg',
		'US1840024598' => 'Falun',
		'US1840009504' => 'Linn',
		'US1840003854' => 'Mulberry',
		'US1840026865' => 'Riverton',
		'US1840001654' => 'Paola',
		'US1840001711' => 'Chetopa',
		'US1840009700' => 'Schoenchen',
		'US1840007331' => 'Huron',
		'US1840006170' => 'Brownell',
		'US1840001589' => 'Manhattan',
		'US1840008617' => 'Lane',
		'US1840009877' => 'Sawyer',
		'US1840007586' => 'Buffalo',
		'US1840008555' => 'Grainfield',
		'US1840008605' => 'Melvern',
		'US1840001658' => 'Lindsborg',
		'US1840001643' => 'Westwood',
		'US1840008480' => 'Leonardville',
		'US1840008601' => 'Dunlap',
		'US1840007501' => 'Alden',
		'US1840009587' => 'Onaga',
		'US1840008604' => 'Kanopolis',
		'US1840008504' => 'McLouth',
		'US1840026604' => 'Baileyville',
		'US1840026832' => 'Chicopee',
		'US1840009640' => 'Richmond',
		'US1840009576' => 'Plainville',
		'US1840007614' => 'Hazelton',
		'US1840007286' => 'Haddam',
		'US1840008419' => 'Jennings',
		'US1840009699' => 'Sharon Springs',
		'US1840001591' => 'Leavenworth',
		'US1840007569' => 'Derby',
		'US1840007612' => 'Ashland',
		'US1840001633' => 'De Soto',
		'US1840008697' => 'Ensign',
		'US1840007408' => 'Grinnell',
		'US1840007594' => 'Grenola',
		'US1840009868' => 'Spearville',
		'US1840008625' => 'Ness City',
		'US1840009830' => 'Stafford',
		'US1840008676' => 'Fall River',
		'US1840003834' => 'Overland Park',
		'US1840008421' => 'Lenora',
		'US1840009881' => 'Sublette',
		'US1840008475' => 'Oak Hill',
		'US1840010768' => 'Williamsburg',
		'US1840008637' => 'Inman',
		'US1840009637' => 'Pomona',
		'US1840010628' => 'Woodston',
		'US1840001636' => 'Gardner',
		'US1840009828' => 'Lone Elm',
		'US1840007410' => 'Chapman',
		'US1840000726' => 'Hiawatha',
		'US1840007283' => 'Agenda',
		'US1840030286' => 'Westwood Hills',
		'US1840001693' => 'Fredonia',
		'US1840009609' => 'Oskaloosa',
		'US1840001682' => 'La Harpe',
		'US1840007415' => 'Baldwin City',
		'US1840009779' => 'Quenemo',
		'US1840010858' => 'Walnut',
		'US1840001695' => 'Frontenac',
		'US1840009653' => 'Pawnee Rock',
		'US1840001655' => 'Ellinwood',
		'US1840000724' => 'Washington',
		'US1840008682' => 'Latham',
		'US1840007567' => 'Bentley',
		'US1840008456' => 'Netawaka',
		'US1840008454' => 'Jamestown',
		'US1840008626' => 'Galatia',
		'US1840007352' => 'Hill City',
		'US1840009510' => 'Prairie View',
		'US1840007478' => 'Horace',
		'US1840009829' => 'Macksville',
		'US1840008468' => 'Kanorado',
		'US1840001692' => 'Kingman',
		'US1840009902' => 'Sharon',
		'US1840003767' => 'Norton',
		'US1840007540' => 'Haven',
		'US1840026785' => 'Yoder',
		'US1840008481' => 'Emmett',
		'US1840039349' => 'Kickapoo Tribal Center',
		'US1840007404' => 'Alta Vista',
		'US1840009886' => 'Thayer',
		'US1840008721' => 'Earlton',
		'US1840024538' => 'Talmage',
		'US1840001624' => 'Bonner Springs',
		'US1840007347' => 'Alton',
		'US1840009918' => 'Sedan',
		'US1840007620' => 'Dearing',
		'US1840008649' => 'Frederick',
		'US1840007276' => 'Atwood',
		'US1840008750' => 'Fowler',
		'US1840009747' => 'Parker',
		'US1840009703' => 'Manchester',
		'US1840010551' => 'Vermillion',
		'US1840009763' => 'Sylvia',
		'US1840007411' => 'Hope',
		'US1840009686' => 'Rossville',
		'US1840001701' => 'Winfield',
		'US1840007282' => 'Cuba',
		'US1840008603' => 'Latimer',
		'US1840001700' => 'Arkansas City',
		'US1840007558' => 'Cimarron',
		'US1840007547' => 'Benton',
		'US1840007546' => 'Andover',
		'US1840008684' => 'Offerle',
		'US1840008705' => 'Goddard',
		'US1840008452' => 'Glasco',
		'US1840008424' => 'Frankfort',
		'US1840010872' => 'Tyro',
		'US1840007479' => 'Bazine',
		'US1840001677' => 'Kinsley',
		'US1840008657' => 'Lebo',
		'US1840008664' => 'Kincaid',
		'US1840007299' => 'Highland',
		'US1840010881' => 'West Mineral',
		'US1840008471' => 'Oakley',
		'US1840001649' => 'Ellsworth',
		'US1840007587' => 'Coyville',
		'US1840009907' => 'Richfield',
		'US1840003841' => 'Osawatomie',
		'US1840010752' => 'Wilsey',
		'US1840007606' => 'Atlanta',
		'US1840007618' => 'Hugoton',
		'US1840035328' => 'Oaklawn-Sunview',
		'US1840008764' => 'Freeport',
		'US1840001675' => 'Augusta',
		'US1840001669' => 'Garden City',
		'US1840001706' => 'Cherryvale',
		'US1840009689' => 'Maple Hill',
		'US1840009648' => 'Ransom',
		'US1840010774' => 'Utica',
		'US1840009808' => 'Raymond',
		'US1840009612' => 'Linwood',
		'US1840001659' => 'McPherson',
		'US1840009515' => 'Oneida',
		'US1840008414' => 'Narka',
		'US1840008650' => 'Geneseo',
		'US1840009577' => 'Rexford',
		'US1840009635' => 'Olpe',
		'US1840007290' => 'Almena',
		'US1840010660' => 'Winchester',
		'US1840001690' => 'Greensburg',
		'US1840007514' => 'Gridley',
		'US1840009880' => 'Manter',
		'US1840001638' => 'Leawood',
		'US1840024521' => 'Ada',
		'US1840008425' => 'Oketo',
		'US1840007279' => 'Cedar',
		'US1840007604' => 'Burden',
		'US1840026603' => 'Home',
		'US1840009516' => 'Severance',
		'US1840007327' => 'Circleville',
		'US1840007470' => 'Americus',
		'US1840008559' => 'Lecompton',
		'US1840001639' => 'Lenexa',
		'US1840026605' => 'Bendena',
		'US1840008422' => 'Glade',
		'US1840001552' => 'Goodland',
		'US1840010874' => 'Wilmore',
		'US1840007284' => 'Clifton',
		'US1840009589' => 'St. Marys',
		'US1840009869' => 'Maize',
		'US1840010629' => 'Zurich',
		'US1840001683' => 'Fort Scott',
		'US1840003852' => 'Mullinville',
		'US1840039354' => 'McConnell AFB',
		'US1840009884' => 'Penalosa',
		'US1840001644' => 'Prairie Village',
		'US1840008722' => 'Erie',
		'US1840007292' => 'Axtell',
		'US1840009882' => 'Satanta',
		'US1840008557' => 'Gorham',
		'US1840009581' => 'Simpson',
	],
	'MT' => [
		'US1840023883' => 'Cooke City',
		'US1840023803' => 'Roy',
		'US1840023740' => 'Marion',
		'US1840018357' => 'Lodge Pole',
		'US1840017301' => 'Fortine',
		'US1840021056' => 'Flaxville',
		'US1840023806' => 'Stockett',
		'US1840021177' => 'Broadview',
		'US1840019801' => 'Ronan',
		'US1840023748' => 'Sylvanite',
		'US1840017405' => 'Crow Agency',
		'US1840023813' => 'Huson',
		'US1840017327' => 'Lonepine',
		'US1840019802' => 'Polson',
		'US1840018495' => 'Worden',
		'US1840023737' => 'Hinsdale',
		'US1840018509' => 'Bozeman',
		'US1840018506' => 'Big Timber',
		'US1840017316' => 'Heart Butte',
		'US1840017320' => 'Carter',
		'US1840022324' => 'Stevensville',
		'US1840023862' => 'Shawmut',
		'US1840074775' => 'Anaconda',
		'US1840018484' => 'Victor',
		'US1840032827' => 'Beaver Creek',
		'US1840018351' => 'Columbia Falls',
		'US1840022326' => 'Whitehall',
		'US1840023746' => 'Pioneer Junction',
		'US1840018429' => 'Ulm',
		'US1840017409' => 'Alder',
		'US1840023749' => 'Trego',
		'US1840018358' => 'Chinook',
		'US1840017321' => 'Loma',
		'US1840032832' => 'Jette',
		'US1840017385' => 'Clancy',
		'US1840019839' => 'Great Falls',
		'US1840017371' => 'Ashland',
		'US1840017392' => 'Greycliff',
		'US1840017294' => 'Frazer',
		'US1840023743' => 'Whitewater',
		'US1840021172' => 'Darby',
		'US1840032750' => 'Orchard Homes',
		'US1840023742' => 'West Glacier',
		'US1840021198' => 'Lima',
		'US1840019784' => 'Big Sandy',
		'US1840023805' => 'Sand Coulee',
		'US1840023888' => 'Springdale',
		'US1840021088' => 'Fairfield',
		'US1840017330' => 'Arlee',
		'US1840017381' => 'Corvallis',
		'US1840022279' => 'Sunburst',
		'US1840018475' => 'Winston',
		'US1840017303' => 'Inverness',
		'US1840017349' => 'Lolo',
		'US1840022282' => 'Westby',
		'US1840017332' => 'Charlo',
		'US1840032831' => 'Herron',
		'US1840039679' => 'Hebgen Lake Estates',
		'US1840017388' => 'Jefferson City',
		'US1840032848' => 'South Browning',
		'US1840018356' => 'Rudyard',
		'US1840023861' => 'Maxville',
		'US1840021167' => 'Lavina',
		'US1840019824' => 'Glendive',
		'US1840023899' => 'Pony',
		'US1840022322' => 'Melstone',
		'US1840032837' => 'Riverbend',
		'US1840018432' => 'Sun River',
		'US1840021085' => 'Sidney',
		'US1840023745' => 'Happys Inn',
		'US1840039687' => 'Little Browning',
		'US1840039745' => 'The Silos',
		'US1840019783' => 'Fort Benton',
		'US1840018496' => 'Billings',
		'US1840021157' => 'White Sulphur Springs',
		'US1840023811' => 'Carlton',
		'US1840032824' => 'King Arthur Park',
		'US1840023872' => 'Elkhorn',
		'US1840018474' => 'Toston',
		'US1840022302' => 'Cascade',
		'US1840019759' => 'Harlem',
		'US1840017309' => 'Antelope',
		'US1840032844' => 'East Glacier Park Village',
		'US1840032838' => 'Rocky Point',
		'US1840017348' => 'Evaro',
		'US1840023881' => 'Logan',
		'US1840074064' => 'Helena Valley Northwest',
		'US1840136955' => 'Sun Prairie',
		'US1840017352' => 'Elliston',
		'US1840018492' => 'Lockwood',
		'US1840022305' => 'Superior',
		'US1840019757' => 'Libby',
		'US1840017333' => 'Elmo',
		'US1840018437' => 'Deer Lodge',
		'US1840023867' => 'Conner',
		'US1840019896' => 'Hamilton',
		'US1840017372' => 'Birney',
		'US1840023751' => 'Yaak',
		'US1840019840' => 'Missoula',
		'US1840039735' => 'South Hills',
		'US1840018508' => 'Belgrade',
		'US1840021092' => 'St. Ignatius',
		'US1840022266' => 'Nashua',
		'US1840018394' => 'Pablo',
		'US1840018436' => 'Ovando',
		'US1840023750' => 'White Haven',
		'US1840022284' => 'Valier',
		'US1840023783' => 'Swan Lake',
		'US1840021192' => 'Lodge Grass',
		'US1840017393' => 'Big Sky',
		'US1840039737' => 'Spokane Creek',
		'US1840039667' => 'Gallatin River Ranch',
		'US1840018493' => 'Custer',
		'US1840018476' => 'Musselshell',
		'US1840021111' => 'East Helena',
		'US1840018385' => 'Paradise',
		'US1840018531' => 'Pryor',
		'US1840023868' => 'Sula',
		'US1840017394' => 'Gardiner',
		'US1840018450' => 'St. Regis',
		'US1840022323' => 'Pinesdale',
		'US1840019906' => 'Livingston',
		'US1840032680' => 'Savage',
		'US1840019878' => 'Miles City',
		'US1840021049' => 'Saco',
		'US1840021047' => 'Whitefish',
		'US1840032841' => 'West Glendive',
		'US1840026101' => 'Amsterdam',
		'US1840018494' => 'Shepherd',
		'US1840023880' => 'Gallatin Gateway',
		'US1840042461' => 'Rocky Boy West',
		'US1840018532' => 'St. Xavier',
		'US1840022329' => 'West Yellowstone',
		'US1840023900' => 'Biddle',
		'US1840018515' => 'Reed Point',
		'US1840018349' => 'Somers',
		'US1840021101' => 'Jordan',
		'US1840023781' => 'Bynum',
		'US1840017306' => 'Hays',
		'US1840021114' => 'Richey',
		'US1840022267' => 'Opheim',
		'US1840032847' => 'North Browning',
		'US1840021053' => 'Browning',
		'US1840023904' => 'Roberts',
		'US1840021165' => 'Townsend',
		'US1840017353' => 'Garrison',
		'US1840023790' => 'Craig',
		'US1840022298' => 'Winifred',
		'US1840018354' => 'Cut Bank',
		'US1840032826' => 'Forest Hill Village',
		'US1840023754' => 'Turner',
		'US1840021063' => 'Kevin',
		'US1840073924' => 'Malmstrom AFB',
		'US1840026103' => 'Jardine',
		'US1840017346' => 'Fort Shaw',
		'US1840019756' => 'Malta',
		'US1840017407' => 'Fort Smith',
		'US1840017304' => 'Kremlin',
		'US1840017406' => 'Busby',
		'US1840032830' => 'Fox Lake',
		'US1840018382' => 'Niarada',
		'US1840019886' => 'Harlowton',
		'US1840023791' => 'Marysville',
		'US1840018473' => 'Radersburg',
		'US1840032840' => 'Turtle Lake',
		'US1840017390' => 'Huntley',
		'US1840074581' => 'Rocky Boys Agency',
		'US1840022278' => 'Chester',
		'US1840032795' => 'Box Elder',
		'US1840032842' => 'West Havre',
		'US1840017350' => 'Frenchtown',
		'US1840023906' => 'Silesia',
		'US1840021073' => 'Froid',
		'US1840021050' => 'Troy',
		'US1840017331' => 'Big Arm',
		'US1840019850' => 'Hobson',
		'US1840026099' => 'Geyser',
		'US1840032846' => 'Kicking Horse',
		'US1840023770' => 'Brady',
		'US1840023753' => 'Santa Rita',
		'US1840021176' => 'Boulder',
		'US1840017378' => 'Klein',
		'US1840018449' => 'De Borgia',
		'US1840023744' => 'Zortman',
		'US1840074081' => 'Helena Valley West Central',
		'US1840021086' => 'Fairview',
		'US1840022337' => 'Virginia City',
		'US1840019912' => 'Hardin',
		'US1840019820' => 'Helena',
		'US1840018386' => 'Trout Creek',
		'US1840017387' => 'Cardwell',
		'US1840023759' => 'Sweet Grass',
		'US1840018384' => 'Old Agency',
		'US1840032834' => 'Kings Point',
		'US1840021051' => 'Rexford',
		'US1840023814' => 'Piltzville',
		'US1840021159' => 'Ismay',
		'US1840018539' => 'Dillon',
		'US1840022320' => 'Philipsburg',
		'US1840017297' => 'Evergreen',
		'US1840023887' => 'Silver Gate',
		'US1840032776' => 'Lindisfarne',
		'US1840023905' => 'Roscoe',
		'US1840018428' => 'Simms',
		'US1840022311' => 'Wibaux',
		'US1840019754' => 'Glasgow',
		'US1840023889' => 'Alzada',
		'US1840021214' => 'Bridger',
		'US1840039765' => 'Wineglass',
		'US1840022331' => 'Walkerville',
		'US1840021184' => 'Three Forks',
		'US1840023804' => 'Gibson Flats',
		'US1840021071' => 'Wolf Point',
		'US1840032850' => 'Butte',
		'US1840017351' => 'Avon',
		'US1840074061' => 'Helena Valley Northeast',
		'US1840023885' => 'Emigrant',
		'US1840032735' => 'Lake Mary Ronan',
		'US1840039686' => 'Little Bitterroot Lake',
		'US1840017389' => 'Ballantine',
		'US1840021202' => 'Broadus',
		'US1840019767' => 'Plentywood',
		'US1840023903' => 'Edgar',
		'US1840018435' => 'Seeley Lake',
		'US1840023886' => 'Pray',
		'US1840019879' => 'Forsyth',
		'US1840017328' => 'Heron',
		'US1840039682' => 'Helena Flats',
		'US1840032772' => 'Batavia',
		'US1840019776' => 'Bainville',
		'US1840023777' => 'Weeksville',
		'US1840039764' => 'Wheatland',
		'US1840018348' => 'St. Marie',
		'US1840018431' => 'Belt',
		'US1840018530' => 'Muddy',
		'US1840017386' => 'Basin',
		'US1840017373' => 'Lame Deer',
		'US1840036941' => 'Bonner-West Riverside',
		'US1840021070' => 'Brockton',
		'US1840032854' => 'South Glastonbury',
		'US1840022335' => 'Sheridan',
		'US1840017305' => 'Fort Belknap Agency',
		'US1840017367' => 'Fallon',
		'US1840017335' => 'Augusta',
		'US1840022288' => 'Circle',
		'US1840021215' => 'Fromberg',
		'US1840017345' => 'Black Eagle',
		'US1840021169' => 'Plevna',
		'US1840017300' => 'Lakeside',
		'US1840022301' => 'Neihart',
		'US1840032809' => 'Four Corners',
		'US1840039748' => 'West Kootenai',
		'US1840018350' => 'Kalispell',
		'US1840019758' => 'Havre',
		'US1840017302' => 'Gildford',
		'US1840018491' => 'Montana City',
		'US1840017418' => 'Belfry',
		'US1840032835' => 'Lewistown Heights',
		'US1840032853' => 'Sangrey',
		'US1840039684' => 'Indian Springs',
		'US1840032852' => 'St. Pierre',
		'US1840021166' => 'Ryegate',
		'US1840021062' => 'Shelby',
		'US1840021052' => 'Eureka',
		'US1840021178' => 'Hysham',
		'US1840032843' => 'Wye',
		'US1840019775' => 'Poplar',
		'US1840023815' => 'Turah',
		'US1840032828' => 'Boneau',
		'US1840039703' => 'Rader Creek',
		'US1840021072' => 'Culbertson',
		'US1840017410' => 'Harrison',
		'US1840019900' => 'Laurel',
		'US1840022285' => 'Plains',
		'US1840032845' => 'Finley Point',
		'US1840021112' => 'Denton',
		'US1840021054' => 'Hingham',
		'US1840021048' => 'Dodson',
		'US1840023882' => 'Sedan',
		'US1840018381' => 'Dixon',
		'US1840032825' => 'Springhill',
		'US1840022336' => 'Twin Bridges',
		'US1840018430' => 'Vaughn',
		'US1840021113' => 'Grass Range',
		'US1840017298' => 'Martin City',
		'US1840021216' => 'Joliet',
		'US1840018383' => 'Noxon',
		'US1840018395' => 'Ravalli',
		'US1840018353' => 'Starr School',
		'US1840021083' => 'Thompson Falls',
		'US1840023741' => 'Olney',
		'US1840018371' => 'Conrad',
		'US1840021201' => 'Ennis',
		'US1840023747' => 'Stryker',
		'US1840023771' => 'Dupuyer',
		'US1840032833' => 'Kerr',
		'US1840018397' => 'Woods Bay',
		'US1840023775' => 'Belknap',
		'US1840032839' => 'Saddle Butte',
		'US1840023752' => 'Babb',
		'US1840018393' => 'Dayton',
		'US1840021125' => 'Alberton',
		'US1840021084' => 'Hot Springs',
		'US1840022332' => 'Columbus',
		'US1840018390' => 'Power',
		'US1840021188' => 'Ekalaka',
		'US1840017382' => 'Florence',
		'US1840021046' => 'Fort Peck',
		'US1840017322' => 'Highwood',
		'US1840018507' => 'Willow Creek',
		'US1840019885' => 'Roundup',
		'US1840032829' => 'Camp Three',
		'US1840017295' => 'Coram',
		'US1840022330' => 'Clyde Park',
		'US1840021087' => 'Dutton',
		'US1840017308' => 'Joplin',
		'US1840022281' => 'Outlook',
		'US1840017347' => 'Clinton',
		'US1840022317' => 'Terry',
		'US1840032836' => 'Parker School',
		'US1840074087' => 'Helena West Side',
		'US1840018477' => 'Judith Gap',
		'US1840022303' => 'Winnett',
		'US1840018514' => 'Park City',
		'US1840018466' => 'Colstrip',
		'US1840023902' => 'Boyd',
		'US1840018362' => 'Reserve',
		'US1840018391' => 'Choteau',
		'US1840023860' => 'Rosebud',
		'US1840032851' => 'Azure',
		'US1840021160' => 'Drummond',
		'US1840019823' => 'Lewistown',
		'US1840023779' => 'Crane',
		'US1840018538' => 'Wisdom',
		'US1840022306' => 'Stanford',
		'US1840074035' => 'Havre North',
		'US1840023738' => 'Kila',
		'US1840074075' => 'Helena Valley Southeast',
		'US1840019947' => 'Bearcreek',
		'US1840018482' => 'Baker',
		'US1840022297' => 'Moore',
		'US1840023884' => 'Corwin Springs',
		'US1840018510' => 'Wilsall',
		'US1840018434' => 'East Missoula',
		'US1840023782' => 'Bear Dance',
		'US1840017299' => 'Hungry Horse',
		'US1840017296' => 'Bigfork',
		'US1840039688' => 'Ponderosa Pines',
		'US1840023776' => 'Camas',
		'US1840026102' => 'Churchill',
		'US1840021055' => 'Scobey',
		'US1840017395' => 'Absarokee',
		'US1840022328' => 'Manhattan',
		'US1840019946' => 'Red Lodge',
		'US1840023866' => 'Charlos Heights',
		'US1840018396' => 'Rollins',
		'US1840022280' => 'Medicine Lake',
		'US1840018405' => 'Lincoln',
		'US1840023812' => 'Condon',
		'US1840023858' => 'Martinsdale',
		'US1840021077' => 'Geraldine',
		'US1840018533' => 'Wyola',
	],
	'MS' => [
		'US1840014932' => 'Crystal Springs',
		'US1840016844' => 'Sturgis',
		'US1840017113' => 'Liberty',
		'US1840013698' => 'Drew',
		'US1840013948' => 'Biloxi',
		'US1840014759' => 'Okolona',
		'US1840013933' => 'Big Point',
		'US1840016514' => 'Golden',
		'US1840015624' => 'Alligator',
		'US1840013105' => 'Escatawpa',
		'US1840016958' => 'Flora',
		'US1840015845' => 'Magee',
		'US1840013717' => 'Grenada',
		'US1840016670' => 'Tremont',
		'US1840018043' => 'Silver City',
		'US1840015745' => 'Louisville',
		'US1840025903' => 'Hillsboro',
		'US1840073848' => 'Columbus AFB',
		'US1840016836' => 'North Carrollton',
		'US1840014746' => 'Charleston',
		'US1840017107' => 'New Augusta',
		'US1840017034' => 'Pachuta',
		'US1840013931' => 'Helena',
		'US1840016843' => 'Maben',
		'US1840017105' => 'McLain',
		'US1840016644' => 'Lambert',
		'US1840014642' => 'Hernando',
		'US1840016732' => 'Coffeeville',
		'US1840018133' => 'Sylvarena',
		'US1840018181' => 'Richton',
		'US1840016887' => 'Isola',
		'US1840016639' => 'Jonestown',
		'US1840013947' => 'Gulfport',
		'US1840025950' => 'Cloverdale',
		'US1840014639' => 'Iuka',
		'US1840013800' => 'Pearl River',
		'US1840018167' => 'Seminary',
		'US1840016640' => 'Lula',
		'US1840013825' => 'Brandon',
		'US1840015617' => 'Bruce',
		'US1840017032' => 'Enterprise',
		'US1840014773' => 'Ruleville',
		'US1840016888' => 'Louise',
		'US1840016879' => 'Cruger',
		'US1840016883' => 'Pickens',
		'US1840015762' => 'Anguilla',
		'US1840018132' => 'Polkville',
		'US1840018162' => 'Sandersville',
		'US1840014845' => 'Lexington',
		'US1840015860' => 'Bassfield',
		'US1840016856' => 'French Camp',
		'US1840017897' => 'Snow Lake Shores',
		'US1840013878' => 'Hattiesburg',
		'US1840015517' => 'Burnsville',
		'US1840015717' => 'Ackerman',
		'US1840013801' => 'Standing Pine',
		'US1840015690' => 'Caledonia',
		'US1840016630' => 'Courtland',
		'US1840016893' => 'Ethel',
		'US1840032475' => 'Gulf Park Estates',
		'US1840016515' => 'Tishomingo',
		'US1840016989' => 'Union',
		'US1840025864' => 'Hamilton',
		'US1840025906' => 'Lauderdale',
		'US1840016596' => 'Coldwater',
		'US1840014772' => 'Moorhead',
		'US1840032564' => 'West Hattiesburg',
		'US1840025873' => 'Elliott',
		'US1840015744' => 'Brooksville',
		'US1840015023' => 'DIberville',
		'US1840014892' => 'Newton',
		'US1840025853' => 'Mooreville',
		'US1840016817' => 'Mathiston',
		'US1840016777' => 'Sunflower',
		'US1840013826' => 'Nellieburg',
		'US1840016748' => 'Winstonville',
		'US1840016742' => 'Webb',
		'US1840016832' => 'Kilmichael',
		'US1840017106' => 'Sumrall',
		'US1840014774' => 'Indianola',
		'US1840015562' => 'Verona',
		'US1840014807' => 'Columbus',
		'US1840015702' => 'Winona',
		'US1840016988' => 'Decatur',
		'US1840014750' => 'Rosedale',
		'US1840025851' => 'Farrell',
		'US1840016599' => 'Jumpertown',
		'US1840013932' => 'Hurley',
		'US1840042510' => 'Mississippi Valley State University',
		'US1840017117' => 'Osyka',
		'US1840016516' => 'Dumas',
		'US1840015558' => 'Marks',
		'US1840016953' => 'Walnut Grove',
		'US1840018093' => 'Puckett',
		'US1840025971' => 'Arnold Line',
		'US1840015853' => 'Waynesboro',
		'US1840018148' => 'Beauregard',
		'US1840018168' => 'Prentiss',
		'US1840139473' => 'Morgantown',
		'US1840014678' => 'New Albany',
		'US1840015802' => 'Vicksburg',
		'US1840015545' => 'Senatobia',
		'US1840015846' => 'Mendenhall',
		'US1840016892' => 'McCool',
		'US1840015557' => 'Abbeville',
		'US1840013619' => 'Fulton',
		'US1840014895' => 'Jackson',
		'US1840017033' => 'Stonewall',
		'US1840014696' => 'Clarksdale',
		'US1840014889' => 'Richland',
		'US1840017980' => 'Gattman',
		'US1840025874' => 'Holcomb',
		'US1840013106' => 'Diamondhead',
		'US1840017104' => 'Leakesville',
		'US1840016740' => 'Sumner',
		'US1840015874' => 'Beaumont',
		'US1840014893' => 'Clinton',
		'US1840017092' => 'Meadville',
		'US1840015901' => 'Lucedale',
		'US1840014891' => 'Meridian',
		'US1840013799' => 'Tucker',
		'US1840015806' => 'Hickory',
		'US1840013937' => 'Gautier',
		'US1840018003' => 'Sidon',
		'US1840014873' => 'Ridgeland',
		'US1840017048' => 'DLo',
		'US1840016618' => 'Myrtle',
		'US1840016747' => 'Gunnison',
		'US1840016918' => 'Cary',
		'US1840016643' => 'Friars Point',
		'US1840015743' => 'Macon',
		'US1840018090' => 'Sebastopol',
		'US1840013739' => 'Greenwood',
		'US1840015618' => 'Calhoun City',
		'US1840025907' => 'Toomsuba',
		'US1840073864' => 'Meridian Station',
		'US1840014803' => 'Itta Bena',
		'US1840018054' => 'Satartia',
		'US1840013856' => 'Ellisville',
		'US1840014872' => 'Canton',
		'US1840016880' => 'Goodman',
		'US1840018175' => 'Roxie',
		'US1840017942' => 'Sledge',
		'US1840017951' => 'Sherman',
		'US1840013945' => 'Saucier',
		'US1840023049' => 'Byram',
		'US1840015782' => 'Madison',
		'US1840016649' => 'Guntown',
		'US1840015873' => 'Lumberton',
		'US1840015627' => 'Boyle',
		'US1840015521' => 'Hickory Flat',
		'US1840017975' => 'Pittsboro',
		'US1840013686' => 'Amory',
		'US1840016600' => 'Marietta',
		'US1840013950' => 'Pearlington',
		'US1840016650' => 'Plantersville',
		'US1840016629' => 'Como',
		'US1840016891' => 'Noxapater',
		'US1840013946' => 'Lyman',
		'US1840016882' => 'West',
		'US1840016815' => 'Crawford',
		'US1840015625' => 'Benoit',
		'US1840025865' => 'New Hamilton',
		'US1840017979' => 'Smithville',
		'US1840013824' => 'Flowood',
		'US1840015877' => 'McComb',
		'US1840017991' => 'Woodland',
		'US1840017896' => 'Paden',
		'US1840013949' => 'Kiln',
		'US1840013565' => 'North Tunica',
		'US1840016834' => 'Carrollton',
		'US1840014860' => 'Rolling Fork',
		'US1840015689' => 'Artesia',
		'US1840025904' => 'Beechwood',
		'US1840073886' => 'New Houlka',
		'US1840015904' => 'Wiggins',
		'US1840015713' => 'Starkville',
		'US1840016517' => 'Falkner',
		'US1840014869' => 'Philadelphia',
		'US1840015862' => 'Bude',
		'US1840017118' => 'Tylertown',
		'US1840025970' => 'Rawls Springs',
		'US1840017935' => 'Taylor',
		'US1840013101' => 'Collinsville',
		'US1840014933' => 'Hazlehurst',
		'US1840015626' => 'Beulah',
		'US1840016992' => 'Terry',
		'US1840015807' => 'Bolton',
		'US1840016512' => 'Farmington',
		'US1840018006' => 'Walthall',
		'US1840025852' => 'Darling',
		'US1840017035' => 'Louin',
		'US1840016986' => 'Marion',
		'US1840016776' => 'Doddsville',
		'US1840015519' => 'Southaven',
		'US1840032300' => 'DeLisle',
		'US1840015876' => 'Magnolia',
		'US1840013759' => 'Greenville',
		'US1840016990' => 'Learned',
		'US1840016983' => 'Pelahatchie',
		'US1840042492' => 'Alcorn State University',
		'US1840018170' => 'Silver Creek',
		'US1840017898' => 'Potts Camp',
		'US1840016987' => 'Chunky',
		'US1840016982' => 'Florence',
		'US1840014888' => 'Pearl',
		'US1840013951' => 'Bay St. Louis',
		'US1840016775' => 'Inverness',
		'US1840013802' => 'Redwater',
		'US1840134614' => 'Bogue Chitto',
		'US1840018053' => 'Eden',
		'US1840015914' => 'Long Beach',
		'US1840017061' => 'State Line',
		'US1840016743' => 'Derma',
		'US1840016809' => 'Morgan City',
		'US1840016646' => 'Crowder',
		'US1840032567' => 'Tunica Resorts',
		'US1840001788' => 'Walls',
		'US1840014688' => 'Oxford',
		'US1840013930' => 'Gulf Hills',
		'US1840016678' => 'Ecru',
		'US1840014638' => 'Corinth',
		'US1840015681' => 'West Point',
		'US1840017973' => 'Glendora',
		'US1840015016' => 'Moss Point',
		'US1840013590' => 'Baldwyn',
		'US1840015560' => 'Saltillo',
		'US1840018083' => 'Scooba',
		'US1840017115' => 'Gloster',
		'US1840016680' => 'Toccopola',
		'US1840025972' => 'Foxworth',
		'US1840015629' => 'Shelby',
		'US1840016744' => 'Vardaman',
		'US1840013862' => 'Brookhaven',
		'US1840016549' => 'Tunica',
		'US1840017974' => 'Big Creek',
		'US1840016746' => 'Duncan',
		'US1840014945' => 'Laurel',
		'US1840013685' => 'Aberdeen',
		'US1840042511' => 'Robinhood',
		'US1840016642' => 'Coahoma',
		'US1840017936' => 'Sardis',
		'US1840016979' => 'Lake',
		'US1840016835' => 'Vaiden',
		'US1840013934' => 'Vancleave',
		'US1840016645' => 'Crenshaw',
		'US1840016749' => 'Pace',
		'US1840014831' => 'Leland',
		'US1840014968' => 'Petal',
		'US1840015516' => 'Belmont',
		'US1840015577' => 'Algoma',
		'US1840015628' => 'Shaw',
		'US1840014830' => 'Hollandale',
		'US1840017077' => 'Monticello',
		'US1840014920' => 'Quitman',
		'US1840025905' => 'Cleary',
		'US1840016881' => 'Tchula',
		'US1840015833' => 'Heidelberg',
		'US1840032563' => 'St. Martin',
		'US1840016647' => 'Falcon',
		'US1840017977' => 'Renova',
		'US1840016750' => 'Hatley',
		'US1840017047' => 'Wesson',
		'US1840016857' => 'Weir',
		'US1840014754' => 'Nettleton',
		'US1840017038' => 'Taylorsville',
		'US1840014705' => 'Pontotoc',
		'US1840016991' => 'Edwards',
		'US1840016952' => 'Lena',
		'US1840014848' => 'Kosciusko',
		'US1840018005' => 'Mantee',
		'US1840018045' => 'Sallis',
		'US1840017116' => 'Summit',
		'US1840025842' => 'White Oak',
		'US1840017937' => 'Pope',
		'US1840013746' => 'Eupora',
		'US1840015918' => 'Waveland',
		'US1840014870' => 'Carthage',
		'US1840013843' => 'Bay Springs',
		'US1840016940' => 'Mayersville',
		'US1840014948' => 'Collins',
		'US1840014643' => 'Horn Lake',
		'US1840015520' => 'Ashland',
		'US1840032566' => 'Hide-A-Way Lake',
		'US1840025937' => 'Clara',
		'US1840017114' => 'Crosby',
		'US1840015518' => 'Blue Mountain',
		'US1840014641' => 'Olive Branch',
		'US1840013853' => 'Fayette',
		'US1840015017' => 'Ocean Springs',
		'US1840015024' => 'Pass Christian',
		'US1840017895' => 'Kossuth',
		'US1840042496' => 'Bridgetown',
		'US1840013822' => 'Forest',
		'US1840015766' => 'Yazoo City',
		'US1840014760' => 'Houston',
		'US1840073885' => 'Glen',
		'US1840015765' => 'Bentonia',
		'US1840016518' => 'Walnut',
		'US1840032487' => 'University',
		'US1840015522' => 'Byhalia',
		'US1840014749' => 'Mound Bayou',
		'US1840013935' => 'Wade',
		'US1840017943' => 'Shannon',
		'US1840018149' => 'Braxton',
		'US1840013543' => 'Lynchburg',
		'US1840015018' => 'Pascagoula',
		'US1840042497' => 'Mississippi State',
		'US1840013591' => 'Booneville',
		'US1840036330' => 'Slate Springs',
		'US1840018163' => 'Soso',
		'US1840025945' => 'Sharon',
		'US1840016745' => 'Merigold',
		'US1840026003' => 'Henderson Point',
		'US1840017046' => 'Georgetown',
		'US1840013745' => 'New Hope',
		'US1840014921' => 'Port Gibson',
		'US1840016679' => 'Thaxton',
		'US1840015561' => 'Tupelo',
		'US1840013102' => 'Conehatta',
		'US1840018044' => 'Shuqualak',
		'US1840013607' => 'Batesville',
		'US1840017078' => 'New Hebron',
		'US1840025991' => 'Nicholson',
		'US1840017071' => 'Mount Olive',
		'US1840018131' => 'Raleigh',
		'US1840013775' => 'Durant',
		'US1840014969' => 'Purvis',
		'US1840013936' => 'Latimer',
		'US1840014640' => 'Ripley',
		'US1840025969' => 'Glendale',
		'US1840018130' => 'Shubuta',
		'US1840016641' => 'Lyon',
		'US1840025936' => 'Buckatunna',
		'US1840015606' => 'Water Valley',
		'US1840016833' => 'Duck Hill',
		'US1840016734' => 'Oakland',
		'US1840016741' => 'Tutwiler',
		'US1840014951' => 'Natchez',
		'US1840017894' => 'Rienzi',
		'US1840016993' => 'Utica',
		'US1840014970' => 'Columbia',
		'US1840014894' => 'Raymond',
		'US1840015002' => 'Picayune',
		'US1840015003' => 'Poplarville',
		'US1840017108' => 'Centreville',
		'US1840017109' => 'Woodville',
		'US1840014748' => 'Cleveland',
		'US1840016858' => 'Metcalfe',
		'US1840016669' => 'Mantachie',
		'US1840018002' => 'Schlater',
		'US1840013777' => 'Belzoni',
		'US1840017931' => 'Blue Springs',
		'US1840016954' => 'De Kalb',
		'US1840014644' => 'Holly Springs',
		'US1840017037' => 'Mize',
		'US1840025892' => 'Kearney Park',
		'US1840014886' => 'Morton',
		'US1840015718' => 'Arcola',
		'US1840017036' => 'Montrose',
		'US1840016733' => 'Tillatoba',
	],
	'PR' => [
		'US1630023535' => 'María Antonia',
		'US1630027038' => 'Las Croabas',
		'US1630023528' => 'Aguada',
		'US1630035651' => 'Comunas',
		'US1630035487' => 'Parcelas La Milagrosa',
		'US1630023635' => 'San Sebastián',
		'US1630027032' => 'El Tumbao',
		'US1630035532' => 'Pájaros',
		'US1630025232' => 'Candelero Abajo',
		'US1630023682' => 'Yabucoa',
		'US1630035672' => 'Garrochales',
		'US1630025228' => 'Monte Verde',
		'US1630035537' => 'Palo Seco',
		'US1630035643' => 'Ceiba',
		'US1630025217' => 'La Liga',
		'US1630023675' => 'Santa Clara',
		'US1630027040' => 'Palmas del Mar',
		'US1630035531' => 'Orocovis',
		'US1630023692' => 'Luquillo',
		'US1630023729' => 'La Fermina',
		'US1630035653' => 'Corazón',
		'US1630025231' => 'Tibes',
		'US1630023621' => 'Indios',
		'US1630023640' => 'Mucarabones',
		'US1630023629' => 'Las Ochenta',
		'US1630035547' => 'Piedra Gorda',
		'US1630035664' => 'El Ojo',
		'US1630023612' => 'Barahona',
		'US1630023615' => 'Stella',
		'US1630025215' => 'Bairoa La Veinticinco',
		'US1630026087' => 'Cerrillos Hoyos',
		'US1630035645' => 'Central Aguirre',
		'US1630035603' => 'Adjuntas',
		'US1630023586' => 'Jayuya',
		'US1630035614' => 'Las Carolinas',
		'US1630035704' => 'El Combate',
		'US1630035681' => 'Hato Candal',
		'US1630035525' => 'Mora',
		'US1630023556' => 'Peñuelas',
		'US1630023552' => 'Quebrada',
		'US1630023657' => 'Olimpo',
		'US1630023636' => 'Hato Arriba',
		'US1630023668' => 'Ciales',
		'US1630035657' => 'Coto Norte',
		'US1630137130' => 'Palomas',
		'US1630023731' => 'Esperanza',
		'US1630023590' => 'Añasco',
		'US1630023610' => 'Patillas',
		'US1630035700' => 'Rodríguez Hevia',
		'US1630023648' => 'Florida',
		'US1630035631' => 'Campo Rico',
		'US1630023532' => 'Carrizales',
		'US1630023678' => 'Maricao',
		'US1630035509' => 'Lomas',
		'US1630035685' => 'Ingenio',
		'US1630035662' => 'El Mangó',
		'US1630035480' => 'Fránquez',
		'US1630035545' => 'Peña Pobre',
		'US1630035679' => 'Hatillo',
		'US1630025221' => 'Parcelas de Navarro',
		'US1630035565' => 'Sabana',
		'US1630035508' => 'Loíza',
		'US1630023549' => 'Lluveras',
		'US1630035611' => 'Animas',
		'US1630023684' => 'El Negro',
		'US1630035647' => 'Cidra',
		'US1630035586' => 'Tallaboa',
		'US1630035481' => 'G. L. García',
		'US1630023710' => 'Las Piedras',
		'US1630023623' => 'Utuado',
		'US1630023566' => 'Arecibo',
		'US1630035632' => 'Camuy',
		'US1630023526' => 'San Germán',
		'US1630023691' => 'Culebra',
		'US1630026088' => 'Vayas',
		'US1630023709' => 'Duque',
		'US1630035467' => 'Palmarejo',
		'US1630035597' => 'Vieques',
		'US1630023583' => 'Juana Díaz',
		'US1630023699' => 'Emajagua',
		'US1630035699' => 'El Paraiso',
		'US1630023667' => 'Villalba',
		'US1630023663' => 'Los Llanos',
		'US1630035475' => 'Benítez',
		'US1630035648' => 'Coamo',
		'US1630023587' => 'Vega Alta',
		'US1630023541' => 'Comerío',
		'US1630023694' => 'Ramos',
		'US1630023578' => 'Luis Lloréns Torres',
		'US1630023598' => 'Lajas',
		'US1630023697' => 'Maunabo',
		'US1630023701' => 'Río Grande',
		'US1630035659' => 'Daguao',
		'US1630035620' => 'Bartolo',
		'US1630035558' => 'Quebradillas',
		'US1630023604' => 'Pole Ojea',
		'US1630035556' => 'Punta Santiago',
		'US1630023579' => 'Potala Pastillo',
		'US1630035609' => 'Aibonito',
		'US1630035562' => 'Río Cañas Abajo',
		'US1630023558' => 'Tallaboa Alta',
		'US1630035622' => 'Bayamón',
		'US1630023544' => 'Playita Cortada',
		'US1630025218' => 'Los Panes',
		'US1630035624' => 'Boquerón',
		'US1630035461' => 'Breñas',
		'US1630035695' => 'La Dolores',
		'US1630035606' => 'Aguas Buenas',
		'US1630035528' => 'Naguabo',
		'US1630035630' => 'Campanilla',
		'US1630035501' => 'Las Marías',
		'US1630023647' => 'Pajonal',
		'US1630023672' => 'Hormigueros',
		'US1630035707' => 'Maguayo',
		'US1630023707' => 'Río Blanco',
		'US1630025220' => 'Parcelas Viejas Borinquen',
		'US1630035618' => 'Barceloneta',
		'US1630035692' => 'Juncal',
		'US1630023689' => 'Candelaria',
		'US1630035615' => 'Bajadero',
		'US1630035466' => 'Marueño',
		'US1630027034' => 'Piedra Aguza',
		'US1630035637' => 'Carolina',
		'US1630035568' => 'Sabana Hoyos',
		'US1630035667' => 'Espino',
		'US1630027037' => 'Pueblito del Carmen',
		'US1630025227' => 'La Yuca',
		'US1630035588' => 'Tierras Nuevas Poniente',
		'US1630023561' => 'La Luisa',
		'US1630035569' => 'Sabana Seca',
		'US1630023696' => 'Suárez',
		'US1630023562' => 'Manatí',
		'US1630023577' => 'Jagual',
		'US1630035655' => 'Corozal',
		'US1630025225' => 'Corral Viejo',
		'US1630035600' => 'Yauco',
		'US1630023540' => 'Caguas',
		'US1630035575' => 'San Isidro',
		'US1630023603' => 'Monte Grande',
		'US1630023656' => 'Trujillo Alto',
		'US1630023545' => 'Santa Isabel',
		'US1630035500' => 'Lares',
		'US1630035566' => 'Sabana Eneas',
		'US1630035626' => 'Buena Vista',
		'US1630035489' => 'Rafael González',
		'US1630023554' => 'Cataño',
		'US1630023527' => 'Luyando',
		'US1630023619' => 'Magas Arriba',
		'US1630035605' => 'Aguadilla',
		'US1630035478' => 'Cabán',
		'US1630035570' => 'Salinas',
		'US1630035520' => 'Mayagüez',
		'US1630023594' => 'Yaurel',
		'US1630023584' => 'Celada',
		'US1630035578' => 'San Lorenzo',
		'US1630035616' => 'Bajandas',
		'US1630035641' => 'Cayuco',
		'US1630025229' => 'Parcelas Mandry',
		'US1630023609' => 'Lamboglia',
		'US1630023652' => 'Búfalo',
		'US1630035495' => 'La Parguera',
		'US1630035506' => 'Levittown',
		'US1630023633' => 'Coco',
		'US1630023581' => 'Aguilita',
		'US1630035577' => 'San Juan',
		'US1630035675' => 'Guayama',
		'US1630023572' => 'Vega Baja',
		'US1630035541' => 'Parcelas Nuevas',
		'US1630023649' => 'Naranjito',
		'US1630023593' => 'Palmas',
		'US1630023718' => 'Luis M. Cintrón',
		'US1630035564' => 'Río Lajas',
		'US1630025230' => 'Quebrada del Agua',
		'US1630035497' => 'La Plena',
		'US1630035690' => 'Jobos',
		'US1630035523' => 'Monserrate',
		'US1630035697' => 'Calzada',
		'US1630023650' => 'Tiburones',
		'US1630023631' => 'Vázquez',
		'US1630023717' => 'Canóvanas',
		'US1630023537' => 'Guánica',
		'US1630027033' => 'Alianza',
		'US1630035619' => 'Barranquitas',
		'US1630035526' => 'Morovis',
		'US1630035496' => 'La Playa',
		'US1630035464' => 'Imbéry',
		'US1630023681' => 'Rosa Sánchez',
		'US1630035488' => 'Pueblito del Río',
		'US1630025223' => 'Anon Raices',
		'US1630023733' => 'San Antonio',
		'US1630035469' => 'Rafael Capó',
		'US1630035504' => 'Las Ollas',
		'US1630035635' => 'Candelero Arriba',
		'US1630023722' => 'Aguas Claras',
		'US1630035674' => 'Guayabal',
		'US1630035459' => 'Antón Ruíz',
		'US1630035482' => 'H. Rivera Colón',
		'US1630023550' => 'Sabana Grande',
		'US1630035694' => 'La Alianza',
		'US1630023721' => 'Juncos',
		'US1630035652' => 'Coquí',
		'US1630035678' => 'Gurabo',
		'US1630035538' => 'Palmer',
		'US1630023608' => 'Cabo Rojo',
		'US1630023533' => 'Corcovado',
		'US1630023679' => 'Martorell',
		'US1630035548' => 'Playa Fortuna',
		'US1630035490' => 'Rafael Hernández',
		'US1630035542' => 'Parcelas Peñuelas',
		'US1630025219' => 'Los Prados',
		'US1630023620' => 'Guayanilla',
		'US1630035668' => 'Fajardo',
		'US1630035462' => 'Capitanejo',
		'US1630023664' => 'Mariano Colón',
		'US1630035670' => 'Fuig',
		'US1630035582' => 'Santo Domingo',
		'US1630035683' => 'Humacao',
		'US1630025216' => 'Hacienda San José',
		'US1630023674' => 'Isabela',
		'US1630023669' => 'Ponce',
		'US1630023602' => 'Aceitunas',
		'US1630035656' => 'Coto Laurel',
		'US1630023575' => 'Guaynabo',
		'US1630023736' => 'Dorado',
		'US1630023735' => 'Toa Baja',
		'US1630023547' => 'Jauca',
		'US1630023642' => 'Toa Alta',
		'US1630023606' => 'Betances',
		'US1630023646' => 'Cacao',
		'US1630023599' => 'Pastos',
		'US1630035522' => 'Moca',
		'US1630035555' => 'Puerto Real',
		'US1630035560' => 'Rincón',
		'US1630023734' => 'San José',
		'US1630035633' => 'Candelaria Arenas',
		'US1630035521' => 'Miranda',
		'US1630023548' => 'Liborio Negrón Torres',
		'US1630035613' => 'Arroyo',
		'US1630035640' => 'Cayey',
		'US1630023680' => 'Playita',
		'US1630035671' => 'Galateo',
		'US1630023714' => 'Santa Bárbara',
		'US1840016780' => 'Trenton',
		'US1840016736' => 'Monetta',
		'US1840035800' => 'Wade Hampton',
		'US1840013719' => 'Gloverville',
		'US1840016822' => 'Elloree',
		'US1840016904' => 'Fairfax',
		'US1840026954' => 'Ware Place',
		'US1840015553' => 'Bethune',
		'US1840026958' => 'Cross Anchor',
		'US1840016667' => 'Donalds',
		'US1840018341' => 'Ravenel',
		'US1840016635' => 'Pomaria',
		'US1840014714' => 'Johnsonville',
		'US1840016588' => 'Tatum',
		'US1840017882' => 'Reidville',
		'US1840016571' => 'Great Falls',
		'US1840015666' => 'Burnettown',
		'US1840016737' => 'Ward',
		'US1840026955' => 'Arcadia',
		'US1840013761' => 'Goose Creek',
		'US1840017962' => 'Sellers',
		'US1840016824' => 'Vance',
		'US1840014254' => 'Ladson',
		'US1840013502' => 'Greer',
		'US1840016543' => 'Lockhart',
		'US1840013653' => 'Forest Acres',
		'US1840015477' => 'Simpsonville',
		'US1840013763' => 'Barnwell',
		'US1840016925' => 'Furman',
		'US1840013526' => 'Easley',
		'US1840014734' => 'Cayce',
		'US1840018342' => 'Rockville',
		'US1840013583' => 'Bennettsville',
		'US1840017884' => 'Sharon',
		'US1840016712' => 'Surfside Beach',
		'US1840016577' => 'Pelzer',
		'US1840016787' => 'Summerton',
		'US1840026998' => 'Jacksonboro',
		'US1840016011' => 'Awendaw',
		'US1840017281' => 'Hollywood',
		'US1840013493' => 'Golden Grove',
		'US1840013586' => 'Princeton',
		'US1840016705' => 'Coward',
		'US1840016905' => 'Sycamore',
		'US1840017283' => 'Lincolnville',
		'US1840016570' => 'Fort Lawn',
		'US1840016906' => 'Ulmer',
		'US1840026961' => 'Fingerville',
		'US1840014255' => 'Folly Beach',
		'US1840015507' => 'Walhalla',
		'US1840035795' => 'Brookdale',
		'US1840013609' => 'North Hartsville',
		'US1840015164' => 'North Charleston',
		'US1840015501' => 'Liberty',
		'US1840024986' => 'Fair Play',
		'US1840016900' => 'Lodge',
		'US1840014627' => 'Pickens',
		'US1840013693' => 'Modoc',
		'US1840016724' => 'Lexington',
		'US1840016708' => 'Pamplico',
		'US1840016707' => 'Olanta',
		'US1840014630' => 'Lancaster',
		'US1840015597' => 'Arcadia Lakes',
		'US1840025042' => 'Bonneau Beach',
		'US1840016631' => 'Lamar',
		'US1840017938' => 'Society Hill',
		'US1840013669' => 'Stateburg',
		'US1840018042' => 'St. George',
		'US1840035839' => 'Lake Secession',
		'US1840013692' => 'Willington',
		'US1840015533' => 'Union',
		'US1840015544' => 'Blenheim',
		'US1840015484' => 'Woodruff',
		'US1840013672' => 'Oswego',
		'US1840016863' => 'Moncks Corner',
		'US1840016615' => 'Lake View',
		'US1840016789' => 'Paxville',
		'US1840017285' => 'Meggett',
		'US1840035843' => 'Edisto',
		'US1840013817' => 'Laurel Bay',
		'US1840026960' => 'Fairforest',
		'US1840015594' => 'Briarcliffe Acres',
		'US1840013513' => 'Mayo',
		'US1840013491' => 'Five Forks',
		'US1840016706' => 'Timmonsville',
		'US1840016462' => 'Central Pacolet',
		'US1840013494' => 'Judson',
		'US1840026963' => 'Gramling',
		'US1840035792' => 'Sangaree',
		'US1840013579' => 'Anderson',
		'US1840026956' => 'Clifton',
		'US1840015483' => 'Wellford',
		'US1840016975' => 'Port Royal',
		'US1840013521' => 'Riverview',
		'US1840013691' => 'Clarks Hill',
		'US1840016723' => 'Irmo',
		'US1840013499' => 'Welcome',
		'US1840043446' => 'James Island',
		'US1840016542' => 'Jonesville',
		'US1840016675' => 'Ninety Six',
		'US1840018008' => 'Santee',
		'US1840016576' => 'Williamston',
		'US1840016632' => 'Little Mountain',
		'US1840014788' => 'North Augusta',
		'US1840016495' => 'Norris',
		'US1840026997' => 'Islandton',
		'US1840013581' => 'Powdersville',
		'US1840014812' => 'Orangeburg',
		'US1840017284' => 'McClellanville',
		'US1840026972' => 'Boykin',
		'US1840016751' => 'McCormick',
		'US1840035847' => 'Northlake',
		'US1840016725' => 'Chapin',
		'US1840013673' => 'Privateer',
		'US1840026964' => 'Catawba',
		'US1840015481' => 'Campobello',
		'US1840013618' => 'Abbeville',
		'US1840016463' => 'Cowpens',
		'US1840016726' => 'Gaston',
		'US1840017885' => 'Smyrna',
		'US1840013078' => 'Dunean',
		'US1840026953' => 'Tigerville',
		'US1840013585' => 'Mountville',
		'US1840018009' => 'Springfield',
		'US1840016616' => 'Latta',
		'US1840013531' => 'Irwin',
		'US1840024987' => 'Newry',
		'US1840026967' => 'Wallace',
		'US1840016627' => 'Winnsboro',
		'US1840013510' => 'Saxon',
		'US1840016828' => 'Norway',
		'US1840018086' => 'Ridgeland',
		'US1840016826' => 'Neeses',
		'US1840013624' => 'Bradley',
		'US1840026990' => 'Warrenville',
		'US1840015593' => 'Aynor',
		'US1840015532' => 'Carlisle',
		'US1840016794' => 'Jackson',
		'US1840013617' => 'Antreville',
		'US1840016478' => 'Clover',
		'US1840016819' => 'Livingston',
		'US1840015163' => 'Charleston',
		'US1840015605' => 'West Columbia',
		'US1840016586' => 'McColl',
		'US1840015478' => 'Travelers Rest',
		'US1840016903' => 'Williams',
		'US1840035794' => 'Shell Point',
		'US1840016820' => 'Cope',
		'US1840014694' => 'Newberry',
		'US1840013626' => 'Greenwood',
		'US1840016581' => 'Mount Croghan',
		'US1840015505' => 'Heath Springs',
		'US1840015165' => 'Isle of Palms',
		'US1840013742' => 'Murrells Inlet',
		'US1840016796' => 'Windsor',
		'US1840017939' => 'Prosperity',
		'US1840013721' => 'Clearwater',
		'US1840016579' => 'Jefferson',
		'US1840026957' => 'Converse',
		'US1840013670' => 'Wedgefield',
		'US1840016823' => 'Eutawville',
		'US1840014718' => 'North Myrtle Beach',
		'US1840016668' => 'Due West',
		'US1840018047' => 'Smoaks',
		'US1840013646' => 'Bucksport',
		'US1840016673' => 'Troy',
		'US1840016870' => 'Williston',
		'US1840017940' => 'Silverstreet',
		'US1840073867' => 'Monarch Mill',
		'US1840022842' => 'Jenkinsville',
		'US1840013088' => 'Coronaca',
		'US1840015591' => 'Loris',
		'US1840015488' => 'Tega Cay',
		'US1840013492' => 'Gantt',
		'US1840015506' => 'Seneca',
		'US1840013518' => 'Lake Wylie',
		'US1840016461' => 'Lyman',
		'US1840013087' => 'Cokesbury',
		'US1840016617' => 'Elgin',
		'US1840016573' => 'Iva',
		'US1840134659' => 'Centerville',
		'US1840016929' => 'Yemassee',
		'US1840026993' => 'Russellville',
		'US1840016575' => 'West Pelzer',
		'US1840035796' => 'Wilkinson Heights',
		'US1840013497' => 'Sans Souci',
		'US1840013597' => 'Lugoff',
		'US1840016585' => 'Patrick',
		'US1840013515' => 'Gaffney',
		'US1840035853' => 'Woodfield',
		'US1840073854' => 'Watts Mills',
		'US1840017971' => 'Saluda',
		'US1840016494' => 'Central',
		'US1840026977' => 'Hopkins',
		'US1840016594' => 'Gray Court',
		'US1840018000' => 'Salley',
		'US1840013517' => 'India Hook',
		'US1840016778' => 'Johnston',
		'US1840016738' => 'Mayesville',
		'US1840013514' => 'Roebuck',
		'US1840016974' => 'Hilton Head Island',
		'US1840013816' => 'Burton',
		'US1840013519' => 'Lesslie',
		'US1840016574' => 'Starr',
		'US1840016790' => 'Kingstree',
		'US1840013648' => 'Little River',
		'US1840035828' => 'Pine Ridge',
		'US1840017889' => 'Salem',
		'US1840016666' => 'Lowndesville',
		'US1840016873' => 'Ehrhardt',
		'US1840016634' => 'Peak',
		'US1840017961' => 'Scranton',
		'US1840017968' => 'South Congaree',
		'US1840015665' => 'Cameron',
		'US1840017925' => 'Ruby',
		'US1840018343' => 'Seabrook Island',
		'US1840035851' => 'Southern Shops',
		'US1840035840' => 'Lakewood',
		'US1840016672' => 'Hodges',
		'US1840015592' => 'Atlantic Beach',
		'US1840015595' => 'Marion',
		'US1840013582' => 'Belton',
		'US1840013501' => 'Greenville',
		'US1840016569' => 'Lowrys',
		'US1840015685' => 'Andrews',
		'US1840016886' => 'Summerville',
		'US1840013509' => 'Boiling Springs',
		'US1840013643' => 'Florence',
		'US1840016797' => 'New Ellenton',
		'US1840013512' => 'Valley Falls',
		'US1840018052' => 'Scotia',
		'US1840013500' => 'Fountain Inn',
		'US1840016793' => 'Stuckey',
		'US1840013090' => 'Dalzell',
		'US1840003900' => 'Batesburg-Leesville',
		'US1840025039' => 'Langley',
		'US1840025043' => 'Pinopolis',
		'US1840016716' => 'Eastover',
		'US1840016928' => 'Varnville',
		'US1840016739' => 'Pinewood',
		'US1840014693' => 'Darlington',
		'US1840013525' => 'Arial',
		'US1840016477' => 'McConnells',
		'US1840013647' => 'Socastee',
		'US1840016926' => 'Gifford',
		'US1840013495' => 'Berea',
		'US1840016798' => 'Perry',
		'US1840017999' => 'St. Matthews',
		'US1840013649' => 'Red Hill',
		'US1840017286' => 'Mount Pleasant',
		'US1840013520' => 'Newport',
		'US1840013089' => 'Dentsville',
		'US1840013580' => 'Piedmont',
		'US1840015490' => 'Hickory Grove',
		'US1840016868' => 'Kline',
		'US1840026976' => 'Gadsden',
		'US1840014663' => 'Chester',
		'US1840013496' => 'City View',
		'US1840016464' => 'Duncan',
		'US1840013508' => 'Inman Mills',
		'US1840073861' => 'Lake Murray of Richland',
		'US1840016779' => 'Edgefield',
		'US1840026989' => 'Graniteville',
		'US1840015655' => 'Manning',
		'US1840017888' => 'Six Mile',
		'US1840017282' => 'Kiawah Island',
		'US1840016729' => 'Swansea',
		'US1840015799' => 'Bluffton',
		'US1840016593' => 'Cross Hill',
		'US1840035850' => 'Seven Oaks',
		'US1840013674' => 'Rembert',
		'US1840018041' => 'Ridgeville',
		'US1840013634' => 'Bishopville',
		'US1840016578' => 'Pendleton',
		'US1840016923' => 'Luray',
		'US1840017960' => 'Quinby',
		'US1840016479' => 'Fort Mill',
		'US1840016499' => 'West Union',
		'US1840018026' => 'Snelling',
		'US1840016583' => 'Chesterfield',
		'US1840016465' => 'Pacolet',
		'US1840015571' => 'Calhoun Falls',
		'US1840016814' => 'Pawleys Island',
		'US1840016792' => 'Greeleyville',
		'US1840016572' => 'Honea Path',
		'US1840013694' => 'Mount Carmel',
		'US1840014667' => 'Clinton',
		'US1840015664' => 'Hemingway',
		'US1840026959' => 'Enoree',
		'US1840016674' => 'Ware Shoals',
		'US1840016869' => 'Elko',
		'US1840035846' => 'Mulberry',
		'US1840026973' => 'Lydia',
		'US1840013818' => 'Beaufort',
		'US1840016874' => 'Govan',
		'US1840016924' => 'Estill',
		'US1840015720' => 'Bonneau',
		'US1840016791' => 'Lane',
		'US1840016728' => 'Summit',
		'US1840013563' => 'Buffalo',
		'US1840016927' => 'Hampton',
		'US1840016867' => 'Hilda',
		'US1840016795' => 'Wagener',
		'US1840015612' => 'Sumter',
		'US1840016713' => 'Nichols',
		'US1840135088' => 'Oak Grove',
		'US1840016875' => 'Olar',
		'US1840035844' => 'Eureka Mill',
		'US1840016498' => 'Kershaw',
		'US1840016821' => 'Cordova',
		'US1840035725' => 'Slater-Marietta',
		'US1840016633' => 'Whitmire',
		'US1840017969' => 'Springdale',
		'US1840014715' => 'Lake City',
		'US1840015482' => 'Spartanburg',
		'US1840013511' => 'Startex',
		'US1840015487' => 'Blacksburg',
		'US1840013625' => 'Promised Land',
		'US1840014615' => 'Inman',
		'US1840013498' => 'Taylors',
		'US1840013722' => 'Aiken',
		'US1840018040' => 'Reevesville',
		'US1840015598' => 'Blythewood',
		'US1840016885' => 'Harleyville',
		'US1840013605' => 'Winnsboro Mills',
		'US1840013598' => 'Camden',
		'US1840014256' => 'Hanahan',
		'US1840035799' => 'South Sumter',
		'US1840016862' => 'Jamestown',
		'US1840015489' => 'York',
		'US1840035841' => 'Murphys Estates',
		'US1840016681' => 'Lynchburg',
		'US1840016595' => 'Waterloo',
		'US1840015693' => 'Bowman',
		'US1840013743' => 'Georgetown',
		'US1840018013' => 'St. Stephen',
		'US1840016825' => 'Woodford',
		'US1840035797' => 'Forestbrook',
		'US1840014626' => 'Clemson',
		'US1840016587' => 'Clio',
		'US1840013808' => 'Hardeeville',
		'US1840013658' => 'Red Bank',
		'US1840014668' => 'Laurens',
		'US1840016730' => 'Pelion',
		'US1840035848' => 'Parker',
		'US1840016901' => 'Cottageville',
		'US1840013666' => 'Cane Savannah',
		'US1840014837' => 'Denmark',
		'US1840026962' => 'Glendale',
		'US1840013584' => 'Joanna',
		'US1840014614' => 'Chesnee',
		'US1840014676' => 'Dillon',
		'US1840016753' => 'Plum Branch',
		'US1840016727' => 'Gilbert',
		'US1840016902' => 'Edisto Beach',
		'US1840013671' => 'Oakland',
		'US1840035842' => 'East Sumter',
		'US1840014719' => 'Mullins',
		'US1840015758' => 'Allendale',
		'US1840014618' => 'Rock Hill',
		'US1840013578' => 'Homeland Park',
		'US1840013720' => 'Belvedere',
		'US1840015764' => 'Brunson',
		'US1840015730' => 'Bamberg',
		'US1840013645' => 'Garden City',
		'US1840013667' => 'Cherryvale',
		'US1840014616' => 'Landrum',
		'US1840015476' => 'Mauldin',
		'US1840018007' => 'Rowesville',
		'US1840014717' => 'Myrtle Beach',
		'US1840013532' => 'Utica',
		'US1840017970' => 'Ridge Spring',
		'US1840014730' => 'Columbia',
		'US1840013080' => 'East Gaffney',
		'US1840017933' => 'Ridgeway',
		'US1840015723' => 'Blackville',
		'US1840015694' => 'Branchville',
		'US1840013668' => 'Shiloh',
		'US1840016818' => 'Holly Hill',
		'US1840035845' => 'Gayle Mill',
		'US1840035787' => 'Sullivans Island',
		'US1840013610' => 'Hartsville',
		'US1840016584' => 'Pageland',
		'US1840016580' => 'McBee',
		'US1840014716' => 'Conway',
		'US1840135211' => 'St. Andrews',
		'US1840026988' => 'Alcolu',
		'US1840016827' => 'North',
		'US1840016788' => 'Turbeville',
		'US1840016582' => 'Cheraw',
		'US1840015757' => 'Walterboro',
		'US1840015508' => 'Westminster',
		'US1840016752' => 'Parksville',
		'US1840017924' => 'Richburg',
	],
	'KY' => [
		'US1840015263' => 'Trenton',
		'US1840014315' => 'Paris',
		'US1840013199' => 'Audubon Park',
		'US1840014325' => 'Hillview',
		'US1840014373' => 'Hindman',
		'US1840013175' => 'Glencoe',
		'US1840013202' => 'Forest Hills',
		'US1840015227' => 'Sturgis',
		'US1840026915' => 'Pleasant View',
		'US1840026884' => 'Gracey',
		'US1840014282' => 'Pleasureville',
		'US1840015247' => 'Liberty',
		'US1840013167' => 'Elsmere',
		'US1840014407' => 'Pineville',
		'US1840030796' => 'Fox Chase',
		'US1840014260' => 'Mentor',
		'US1840014318' => 'Midway',
		'US1840013255' => 'Brownsville',
		'US1840015179' => 'Williamstown',
		'US1840030514' => 'McKinney',
		'US1840014307' => 'Hollyvilla',
		'US1840026679' => 'Francisville',
		'US1840013254' => 'Burnside',
		'US1840014298' => 'Norwood',
		'US1840013245' => 'Buckhorn',
		'US1840014363' => 'Hustonville',
		'US1840013233' => 'Bradfordsville',
		'US1840015222' => 'Stanton',
		'US1840014405' => 'Corbin',
		'US1840026922' => 'Symsonia',
		'US1840015236' => 'Loretto',
		'US1840013204' => 'Goose Creek',
		'US1840015190' => 'Stamping Ground',
		'US1840026830' => 'Beech Grove',
		'US1840030801' => 'Manor Creek',
		'US1840014297' => 'Northfield',
		'US1840014410' => 'Murray',
		'US1840015258' => 'London',
		'US1840014350' => 'Rockport',
		'US1840015206' => 'Simpsonville',
		'US1840026898' => 'Pathfork',
		'US1840014300' => 'Plantation',
		'US1840015196' => 'Shively',
		'US1840026861' => 'Dunmor',
		'US1840030691' => 'McCarr',
		'US1840014261' => 'Newport',
		'US1840026875' => 'Payne Gap',
		'US1840014279' => 'Concord',
		'US1840014351' => 'Hodgenville',
		'US1840015188' => 'Smithfield',
		'US1840014267' => 'Independence',
		'US1840013258' => 'Fleming-Neon',
		'US1840015228' => 'Uniontown',
		'US1840014354' => 'Danville',
		'US1840026897' => 'Kenvir',
		'US1840015266' => 'Wallins Creek',
		'US1840014382' => 'Princeton',
		'US1840030815' => 'Louisville',
		'US1840013236' => 'Annville',
		'US1840026800' => 'Boston',
		'US1840015237' => 'Livermore',
		'US1840014370' => 'Nortonville',
		'US1840015264' => 'Loyall',
		'US1840030408' => 'Cleaton',
		'US1840015268' => 'Mayfield',
		'US1840026821' => 'Freeburn',
		'US1840026895' => 'Cawood',
		'US1840013180' => 'Dover',
		'US1840013292' => 'Gamaliel',
		'US1840015209' => 'Louisa',
		'US1840014286' => 'River Bluff',
		'US1840014308' => 'Hurstbourne',
		'US1840013273' => 'Guthrie',
		'US1840013260' => 'Barlow',
		'US1840015211' => 'Lexington',
		'US1840014273' => 'Prestonville',
		'US1840013288' => 'Burkesville',
		'US1840013179' => 'Dry Ridge',
		'US1840014345' => 'Lancaster',
		'US1840043099' => 'Farley',
		'US1840013268' => 'Glasgow',
		'US1840013173' => 'Falmouth',
		'US1840030456' => 'Glenview Manor',
		'US1840014380' => 'Morgantown',
		'US1840026790' => 'Ezel',
		'US1840013192' => 'Buckner',
		'US1840015223' => 'Whitesville',
		'US1840024676' => 'Westport',
		'US1840014356' => 'Junction City',
		'US1840014344' => 'Irvine',
		'US1840015271' => 'Scottsville',
		'US1840015186' => 'Wurtland',
		'US1840030807' => 'Spring Mill',
		'US1840014327' => 'Cloverport',
		'US1840026858' => 'Burna',
		'US1840013178' => 'Brooksville',
		'US1840015238' => 'Sacramento',
		'US1840015191' => 'Lyndon',
		'US1840026918' => 'Farmington',
		'US1840015204' => 'Worthington Hills',
		'US1840014288' => 'Catlettsburg',
		'US1840014396' => 'Crofton',
		'US1840013266' => 'Edmonton',
		'US1840015243' => 'McKee',
		'US1840015172' => 'Woodlawn',
		'US1840013217' => 'Hardinsburg',
		'US1840026920' => 'Pryorsburg',
		'US1840014334' => 'New Haven',
		'US1840026896' => 'Coldiron',
		'US1840030479' => 'Ironville',
		'US1840014409' => 'Columbus',
		'US1840013216' => 'Frenchburg',
		'US1840030816' => 'Doe Valley',
		'US1840013285' => 'Pine Knot',
		'US1840013278' => 'South Wallins',
		'US1840013241' => 'Brodhead',
		'US1840030366' => 'Anthoston',
		'US1840013224' => 'Masonville',
		'US1840014284' => 'Crestwood',
		'US1840026822' => 'Virgie',
		'US1840015218' => 'Vine Grove',
		'US1840073833' => 'Fort Knox',
		'US1840015207' => 'Salt Lick',
		'US1840014343' => 'Ravenna',
		'US1840014385' => 'Jenkins',
		'US1840015175' => 'Taylor Mill',
		'US1840013164' => 'Bellevue',
		'US1840013264' => 'Reidland',
		'US1840014399' => 'Hopkinsville',
		'US1840015192' => 'Lynnview',
		'US1840026860' => 'Beechmont',
		'US1840030432' => 'Druid Hills',
		'US1840015248' => 'Marion',
		'US1840030793' => 'Poplar Hills',
		'US1840013160' => 'Burlington',
		'US1840026681' => 'Petersburg',
		'US1840014337' => 'Henderson',
		'US1840014394' => 'Cave City',
		'US1840014352' => 'Raywick',
		'US1840013185' => 'Bedford',
		'US1840013277' => 'Barbourville',
		'US1840015265' => 'Lynch',
		'US1840015217' => 'Sonora',
		'US1840030425' => 'Cunningham',
		'US1840014270' => 'Corinth',
		'US1840030417' => 'Coxton',
		'US1840015169' => 'Silver Grove',
		'US1840013290' => 'Franklin',
		'US1840014349' => 'Centertown',
		'US1840026854' => 'Hardyville',
		'US1840030803' => 'Meadow Vale',
		'US1840014275' => 'Russell',
		'US1840013220' => 'Fairfield',
		'US1840013283' => 'Stearns',
		'US1840014314' => 'North Middletown',
		'US1840014258' => 'Crestview',
		'US1840015256' => 'Science Hill',
		'US1840013184' => 'Bellefonte',
		'US1840013296' => 'Fulton',
		'US1840015197' => 'Thornhill',
		'US1840014292' => 'Lakeview Heights',
		'US1840015225' => 'Springfield',
		'US1840030812' => 'Breckinridge Center',
		'US1840026833' => 'Onton',
		'US1840014408' => 'Clinton',
		'US1840026853' => 'Summersville',
		'US1840030472' => 'Hickory',
		'US1840013207' => 'Beechwood Village',
		'US1840015250' => 'Vicco',
		'US1840013228' => 'Phelps',
		'US1840015205' => 'Shelbyville',
		'US1840014290' => 'Carlisle',
		'US1840014357' => 'Jackson',
		'US1840013165' => 'California',
		'US1840013287' => 'Bardwell',
		'US1840015214' => 'Shepherdsville',
		'US1840015249' => 'Livingston',
		'US1840013280' => 'Harlan',
		'US1840015241' => 'Wheatcroft',
		'US1840015184' => 'South Shore',
		'US1840014335' => 'Corydon',
		'US1840014378' => 'Central City',
		'US1840026923' => 'Marrowbone',
		'US1840015210' => 'Sandy Hook',
		'US1840030584' => 'South Park View',
		'US1840013231' => 'Hartford',
		'US1840014276' => 'Milton',
		'US1840015170' => 'Southgate',
		'US1840014301' => 'Prospect',
		'US1840030361' => 'Allen',
		'US1840014386' => 'Kevil',
		'US1840015178' => 'Warsaw',
		'US1840014369' => 'Nebo',
		'US1840026678' => 'Belleview',
		'US1840014295' => 'Middletown',
		'US1840013252' => 'Eubank',
		'US1840030478' => 'Houston Acres',
		'US1840030808' => 'Spring Valley',
		'US1840026823' => 'Rosine',
		'US1840015193' => 'Meadowview Estates',
		'US1840030798' => 'Hills and Dales',
		'US1840013210' => 'Frankfort',
		'US1840014336' => 'Robards',
		'US1840015254' => 'Woodbury',
		'US1840015262' => 'Woodburn',
		'US1840013169' => 'Fairview',
		'US1840015240' => 'Slaughters',
		'US1840014268' => 'Kenton Vale',
		'US1840013239' => 'Dycusburg',
		'US1840026924' => 'Dexter',
		'US1840013237' => 'Earlington',
		'US1840013188' => 'Campbellsburg',
		'US1840014391' => 'Russell Springs',
		'US1840013189' => 'Berry',
		'US1840013022' => 'East Bernstadt',
		'US1840030805' => 'Old Brownsboro Place',
		'US1840013246' => 'Ledbetter',
		'US1840030576' => 'Seneca Gardens',
		'US1840026843' => 'Manitou',
		'US1840030689' => 'Maryhill Estates',
		'US1840026812' => 'Hazel Green',
		'US1840013209' => 'Blue Ridge Manor',
		'US1840026879' => 'Lovelaceville',
		'US1840026873' => 'Mayking',
		'US1840036079' => 'Middlesborough',
		'US1840014401' => 'Russellville',
		'US1840013262' => 'Hendron',
		'US1840013261' => 'Blandville',
		'US1840014313' => 'Millersburg',
		'US1840014383' => 'Hyden',
		'US1840014348' => 'Pikeville',
		'US1840015199' => 'Wellington',
		'US1840013172' => 'Bromley',
		'US1840026881' => 'Summer Shade',
		'US1840015235' => 'Upton',
		'US1840014271' => 'Crittenden',
		'US1840026925' => 'Cayce',
		'US1840014272' => 'Carrollton',
		'US1840014400' => 'LaFayette',
		'US1840013163' => 'Fort Thomas',
		'US1840014359' => 'Clay',
		'US1840014353' => 'Lebanon',
		'US1840015233' => 'Wheelwright',
		'US1840013201' => 'Fincastle',
		'US1840015167' => 'Walton',
		'US1840014358' => 'Island',
		'US1840014264' => 'Crescent Springs',
		'US1840014280' => 'Mount Olivet',
		'US1840030398' => 'Cambridge',
		'US1840014379' => 'Powderly',
		'US1840030806' => 'Orchard Grass Hills',
		'US1840014303' => 'Rolling Fields',
		'US1840014291' => 'Morehead',
		'US1840014395' => 'Park City',
		'US1840015257' => 'Somerset',
		'US1840013190' => 'Ewing',
		'US1840014317' => 'Muldraugh',
		'US1840015242' => 'Stanford',
		'US1840013275' => 'Benton',
		'US1840015173' => 'Ludlow',
		'US1840014309' => 'Hurstbourne Acres',
		'US1840015251' => 'Salem',
		'US1840013182' => 'Flatwoods',
		'US1840013250' => 'Bremen',
		'US1840030814' => 'Oakbrook',
		'US1840014312' => 'Kingsley',
		'US1840043109' => 'Maytown',
		'US1840030795' => 'Coldstream',
		'US1840013203' => 'Glenview',
		'US1840015259' => 'Whitesburg',
		'US1840014283' => 'Cynthiana',
		'US1840015229' => 'Waverly',
		'US1840030499' => 'Lincolnshire',
		'US1840030406' => 'Claryville',
		'US1840014375' => 'Horse Cave',
		'US1840013248' => 'Drakesboro',
		'US1840015215' => 'West Liberty',
		'US1840013291' => 'Fountain Run',
		'US1840013208' => 'Bellemeade',
		'US1840013183' => 'Greenup',
		'US1840026825' => 'Magnolia',
		'US1840013249' => 'Greenville',
		'US1840014322' => 'Mount Washington',
		'US1840026726' => 'Mays Lick',
		'US1840026921' => 'Sedalia',
		'US1840013162' => 'Alexandria',
		'US1840013212' => 'Ekron',
		'US1840015224' => 'Mackville',
		'US1840014328' => 'Irvington',
		'US1840013161' => 'Florence',
		'US1840014285' => 'Pewee Valley',
		'US1840025690' => 'Elk Creek',
		'US1840013263' => 'Massac',
		'US1840015245' => 'St. Charles',
		'US1840013276' => 'Calvert City',
		'US1840026846' => 'Crayne',
		'US1840013219' => 'Bardstown',
		'US1840014281' => 'New Castle',
		'US1840030368' => 'Arjay',
		'US1840013193' => 'Goshen',
		'US1840026880' => 'Plano',
		'US1840013259' => 'Blackey',
		'US1840030422' => 'Crossgate',
		'US1840015183' => 'Worthville',
		'US1840015201' => 'Wildwood',
		'US1840013270' => 'Auburn',
		'US1840013191' => 'Flemingsburg',
		'US1840014265' => 'Crestview Hills',
		'US1840015176' => 'Villa Hills',
		'US1840014332' => 'Hawesville',
		'US1840026916' => 'Rockholds',
		'US1840013225' => 'Berea',
		'US1840015219' => 'West Point',
		'US1840026819' => 'Betsy Layne',
		'US1840013232' => 'Beaver Dam',
		'US1840014302' => 'Riverwood',
		'US1840015194' => 'St. Matthews',
		'US1840015189' => 'Sadieville',
		'US1840013171' => 'Fort Wright',
		'US1840013269' => 'Adairville',
		'US1840030396' => 'Brownsboro Village',
		'US1840013256' => 'North Corbin',
		'US1840015171' => 'Wilder',
		'US1840013206' => 'Green Spring',
		'US1840026680' => 'Hebron',
		'US1840013286' => 'Arlington',
		'US1840015253' => 'South Carrollton',
		'US1840026729' => 'Garrison',
		'US1840030359' => 'Ages',
		'US1840014381' => 'Rochester',
		'US1840026892' => 'Gilbertsville',
		'US1840026803' => 'Spottsville',
		'US1840014259' => 'Dayton',
		'US1840014377' => 'Carrsville',
		'US1840014402' => 'Lewisburg',
		'US1840026855' => 'Diablock',
		'US1840014305' => 'Heritage Creek',
		'US1840026893' => 'Artemus',
		'US1840013221' => 'Bloomfield',
		'US1840013214' => 'Camargo',
		'US1840015234' => 'McHenry',
		'US1840013274' => 'Hardin',
		'US1840026917' => 'Fancy Farm',
		'US1840030436' => 'Dwale',
		'US1840030809' => 'Sycamore',
		'US1840013281' => 'Benham',
		'US1840030799' => 'Hunters Hollow',
		'US1840014367' => 'Dawson Springs',
		'US1840030527' => 'Mockingbird Valley',
		'US1840013234' => 'Beattyville',
		'US1840030804' => 'Murray Hill',
		'US1840014257' => 'Cold Spring',
		'US1840014269' => 'Lakeside Park',
		'US1840015181' => 'Sardis',
		'US1840015200' => 'West Buechel',
		'US1840026914' => 'Emlyn',
		'US1840026856' => 'Jeff',
		'US1840013267' => 'Eddyville',
		'US1840015221' => 'Warfield',
		'US1840013272' => 'Elkton',
		'US1840015182' => 'Sanders',
		'US1840015239' => 'Sebree',
		'US1840013289' => 'Albany',
		'US1840026805' => 'Salvisa',
		'US1840013229' => 'Elkhorn City',
		'US1840073832' => 'Fort Campbell North',
		'US1840026749' => 'Cannonsburg',
		'US1840030382' => 'Belfry',
		'US1840014404' => 'Monticello',
		'US1840014324' => 'Hebron Estates',
		'US1840026864' => 'Oneida',
		'US1840026919' => 'Lowes',
		'US1840014403' => 'Cumberland',
		'US1840015230' => 'Salyersville',
		'US1840014374' => 'Munfordville',
		'US1840030811' => 'Bancroft',
		'US1840013218' => 'Elizabethtown',
		'US1840015177' => 'Sparta',
		'US1840014331' => 'Paintsville',
		'US1840015232' => 'Wayland',
		'US1840014360' => 'Dixon',
		'US1840015270' => 'Wingo',
		'US1840015187' => 'Vanceburg',
		'US1840026798' => 'Cecilia',
		'US1840014361' => 'Providence',
		'US1840015231' => 'Martin',
		'US1840015168' => 'Melbourne',
		'US1840026761' => 'Farmers',
		'US1840014287' => 'La Grange',
		'US1840015213' => 'Taylorsville',
		'US1840013168' => 'Erlanger',
		'US1840030619' => 'Woodlawn Park',
		'US1840014388' => 'Paducah',
		'US1840014266' => 'Park Hills',
		'US1840014310' => 'Indian Hills',
		'US1840030393' => 'Briarwood',
		'US1840026882' => 'Hiseville',
		'US1840026683' => 'Verona',
		'US1840013244' => 'Bonnieville',
		'US1840013238' => 'Hanson',
		'US1840014262' => 'Highland Heights',
		'US1840014372' => 'Pippa Passes',
		'US1840013257' => 'McRoberts',
		'US1840014289' => 'Olive Hill',
		'US1840026824' => 'Buffalo',
		'US1840014277' => 'Monterey',
		'US1840014319' => 'Mount Sterling',
		'US1840014342' => 'Morganfield',
		'US1840015202' => 'Windy Hills',
		'US1840030612' => 'Westwood',
		'US1840014296' => 'Moorland',
		'US1840015272' => 'Tompkinsville',
		'US1840014397' => 'Oak Grove',
		'US1840013247' => 'Grand Rivers',
		'US1840026847' => 'Tolu',
		'US1840014341' => 'Richmond',
		'US1840014323' => 'Pioneer Village',
		'US1840013181' => 'Ghent',
		'US1840015195' => 'St. Regis Park',
		'US1840013195' => 'Ashland',
		'US1840015246' => 'White Plains',
		'US1840014387' => 'La Center',
		'US1840015180' => 'Maysville',
		'US1840014338' => 'Inez',
		'US1840014263' => 'Covington',
		'US1840013174' => 'Butler',
		'US1840014299' => 'Parkway Village',
		'US1840013166' => 'Edgewood',
		'US1840030590' => 'Strathmoor Village',
		'US1840014304' => 'Rolling Hills',
		'US1840013222' => 'Harrodsburg',
		'US1840013271' => 'Allensville',
		'US1840013211' => 'Blaine',
		'US1840014420' => 'Hickman',
		'US1840015226' => 'Willisburg',
		'US1840013223' => 'Burgin',
		'US1840030791' => 'Glenview Hills',
		'US1840015267' => 'Williamsburg',
		'US1840026874' => 'Millstone',
		'US1840014371' => 'Mount Vernon',
		'US1840026818' => 'Auxier',
		'US1840015203' => 'Woodland Hills',
		'US1840014365' => 'Clarkson',
		'US1840013251' => 'Fredonia',
		'US1840013205' => 'Graymoor-Devondale',
		'US1840014362' => 'Crab Orchard',
		'US1840013196' => 'Grayson',
		'US1840026894' => 'Flat Lick',
		'US1840013279' => 'Evarts',
		'US1840013253' => 'Ferguson',
		'US1840014320' => 'Jeffersonville',
		'US1840014311' => 'Jeffersontown',
		'US1840030558' => 'Poole',
		'US1840014364' => 'Caneyville',
		'US1840013230' => 'Fordsville',
		'US1840013284' => 'Whitley City',
		'US1840014392' => 'Jamestown',
		'US1840013282' => 'Cadiz',
		'US1840013240' => 'Booneville',
		'US1840013187' => 'Eminence',
		'US1840014355' => 'Perryville',
		'US1840013197' => 'Georgetown',
		'US1840013170' => 'Fort Mitchell',
		'US1840026802' => 'New Hope',
		'US1840030800' => 'Langdon Place',
		'US1840030802' => 'Meadowbrook Farm',
		'US1840030797' => 'Hickory Hill',
		'US1840026799' => 'High Bridge',
		'US1840030589' => 'Strathmoor Manor',
		'US1840014368' => 'Mortons Gap',
		'US1840014411' => 'Hazel',
		'US1840030395' => 'Brownsboro Farm',
		'US1840014347' => 'Coal Run Village',
		'US1840013177' => 'Germantown',
		'US1840014398' => 'Pembroke',
		'US1840026742' => 'Elizaville',
		'US1840015261' => 'Smiths Grove',
		'US1840015255' => 'Manchester',
		'US1840030810' => 'Ten Broeck',
		'US1840030413' => 'Combs',
		'US1840030387' => 'Big Clifty',
		'US1840013200' => 'Barbourmeade',
		'US1840026878' => 'Bandana',
		'US1840013242' => 'Campbellsville',
		'US1840030383' => 'Bellewood',
		'US1840014393' => 'Kuttawa',
		'US1840015244' => 'Madisonville',
		'US1840015185' => 'Worthington',
		'US1840013235' => 'Calhoun',
		'US1840015269' => 'Water Valley',
		'US1840030585' => 'South Williamson',
		'US1840030513' => 'McDowell',
		'US1840014316' => 'Owingsville',
		'US1840014329' => 'Radcliff',
		'US1840026801' => 'Chaplin',
		'US1840014321' => 'Lawrenceburg',
		'US1840014340' => 'Owensboro',
		'US1840015260' => 'Wickliffe',
		'US1840014389' => 'Oakland',
		'US1840026806' => 'Maceo',
		'US1840013265' => 'Bowling Green',
		'US1840013176' => 'Augusta',
		'US1840030569' => 'Rineyville',
		'US1840030542' => 'Norbourne Estates',
		'US1840030566' => 'Richlawn',
		'US1840030601' => 'Utica',
		'US1840014306' => 'Hollow Creek',
		'US1840014384' => 'Columbia',
		'US1840014278' => 'Owenton',
		'US1840014376' => 'Hazard',
		'US1840015216' => 'Winchester',
		'US1840013243' => 'Greensburg',
		'US1840014294' => 'Douglass Hills',
		'US1840015212' => 'Versailles',
		'US1840014366' => 'Leitchfield',
		'US1840013215' => 'Brooks',
		'US1840014333' => 'Lewisport',
		'US1840030794' => 'Broeck Pointe',
		'US1840014339' => 'Clay City',
		'US1840013198' => 'Anchorage',
		'US1840014274' => 'Raceland',
		'US1840015166' => 'Union',
		'US1840015220' => 'Wilmore',
		'US1840014326' => 'Lebanon Junction',
		'US1840026682' => 'Rabbit Hash',
		'US1840015174' => 'Ryland Heights',
		'US1840013186' => 'Gratz',
		'US1840015208' => 'Sharpsburg',
		'US1840014346' => 'Prestonsburg',
		'US1840014293' => 'Creekside',
		'US1840026901' => 'Cerulean',
		'US1840014390' => 'Plum Springs',
		'US1840013226' => 'Campton',
		'US1840013213' => 'Brandenburg',
		'US1840014330' => 'Nicholasville',
		'US1840015198' => 'Watterson Park',
		'US1840015252' => 'Smithland',
	],
	'OR' => [
		'US1840023940' => 'Crawfordsville',
		'US1840018542' => 'Irrigon',
		'US1840018578' => 'Aurora',
		'US1840020035' => 'Myrtle Creek',
		'US1840023948' => 'Alpine',
		'US1840019956' => 'McMinnville',
		'US1840019944' => 'Mosier',
		'US1840021248' => 'Dayville',
		'US1840019972' => 'Fossil',
		'US1840019973' => 'Mitchell',
		'US1840018606' => 'Brownsville',
		'US1840018603' => 'Culver',
		'US1840018559' => 'Odell',
		'US1840021197' => 'Wallowa',
		'US1840018548' => 'Neskowin',
		'US1840021223' => 'St. Paul',
		'US1840019932' => 'Hillsboro',
		'US1840040419' => 'Eagle Crest',
		'US1840025290' => 'Umapine',
		'US1840019921' => 'Heppner',
		'US1840017439' => 'Green',
		'US1840018544' => 'Island City',
		'US1840021203' => 'Tillamook',
		'US1840019992' => 'Lyons',
		'US1840019927' => 'Rockaway Beach',
		'US1840018571' => 'Damascus',
		'US1840020007' => 'Eugene',
		'US1840025487' => 'Selma',
		'US1840019918' => 'Pilot Rock',
		'US1840020078' => 'Gold Beach',
		'US1840025488' => 'Takilma',
		'US1840018582' => 'Detroit',
		'US1840019975' => 'Newport',
		'US1840018543' => 'Imbler',
		'US1840022349' => 'Canyon City',
		'US1840019942' => 'Hood River',
		'US1840019916' => 'Milton-Freewater',
		'US1840018589' => 'Independence',
		'US1840025418' => 'Gardiner',
		'US1840034754' => 'Beatty',
		'US1840034755' => 'Black Butte Ranch',
		'US1840019920' => 'Lostine',
		'US1840023952' => 'Kings Valley',
		'US1840019923' => 'North Powder',
		'US1840040420' => 'Pronghorn',
		'US1840017411' => 'Cloverdale',
		'US1840019966' => 'Haines',
		'US1840034671' => 'Bethany',
		'US1840020058' => 'Powers',
		'US1840025415' => 'Days Creek',
		'US1840073958' => 'Garden Home-Whitford',
		'US1840018593' => 'Depoe Bay',
		'US1840021252' => 'Sodaville',
		'US1840019919' => 'Enterprise',
		'US1840018563' => 'Rowena',
		'US1840025466' => 'Pistol River',
		'US1840020025' => 'Hines',
		'US1840025438' => 'Silver Lake',
		'US1840034812' => 'Barlow',
		'US1840021199' => 'Lexington',
		'US1840021276' => 'Yoncalla',
		'US1840025419' => 'Lookingglass',
		'US1840025416' => 'Dillard',
		'US1840017413' => 'Hebo',
		'US1840025440' => 'Glasgow',
		'US1840040438' => 'Seventh Mountain',
		'US1840017442' => 'Bunker Hill',
		'US1840018540' => 'Boardman',
		'US1840018587' => 'Baker City',
		'US1840034826' => 'Deschutes River Woods',
		'US1840019980' => 'Long Creek',
		'US1840019950' => 'Happy Valley',
		'US1840021200' => 'Union',
		'US1840025278' => 'Westport',
		'US1840018623' => 'Junction City',
		'US1840021210' => 'Wood Village',
		'US1840021220' => 'Sheridan',
		'US1840034839' => 'Neahkahnie',
		'US1840034748' => 'West Scio',
		'US1840019960' => 'Gervais',
		'US1840018565' => 'Wamic',
		'US1840018560' => 'Parkdale',
		'US1840017440' => 'Altamont',
		'US1840018632' => 'Burns',
		'US1840025465' => 'Nesika Beach',
		'US1840021182' => 'Seaside',
		'US1840040452' => 'Tetherow',
		'US1840018583' => 'Donald',
		'US1840018652' => 'Bandon',
		'US1840021209' => 'Troutdale',
		'US1840018598' => 'John Day',
		'US1840018602' => 'Warm Springs',
		'US1840018561' => 'Cascade Locks',
		'US1840019953' => 'Molalla',
		'US1840034732' => 'Labish Village',
		'US1840018537' => 'Joseph',
		'US1840017441' => 'Barview',
		'US1840034837' => 'Oatfield',
		'US1840017417' => 'Chenoweth',
		'US1840025459' => 'Foots Creek',
		'US1840021247' => 'Seneca',
		'US1840021236' => 'Yachats',
		'US1840020077' => 'Phoenix',
		'US1840018552' => 'Bay City',
		'US1840019908' => 'Rainier',
		'US1840034716' => 'Cedar Hills',
		'US1840017422' => 'Marion',
		'US1840023949' => 'Alsea',
		'US1840018677' => 'Brookings',
		'US1840021254' => 'Tangent',
		'US1840018558' => 'Durham',
		'US1840025464' => 'Langlois',
		'US1840025374' => 'Brogan',
		'US1840034715' => 'Cayuse',
		'US1840018611' => 'Corvallis',
		'US1840018536' => 'Athena',
		'US1840025463' => 'Wimer',
		'US1840018654' => 'Coquille',
		'US1840023944' => 'Shedd',
		'US1840019949' => 'Gladstone',
		'US1840018554' => 'West Slope',
		'US1840019931' => 'Gaston',
		'US1840021275' => 'Winston',
		'US1840018551' => 'Pacific City',
		'US1840019969' => 'Richland',
		'US1840020087' => 'Grants Pass',
		'US1840021263' => 'Springfield',
		'US1840074715' => 'West Haven-Sylvan',
		'US1840023977' => 'Tumalo',
		'US1840019999' => 'Prineville',
		'US1840021207' => 'Tualatin',
		'US1840018557' => 'Cornelius',
		'US1840025300' => 'Mount Hood',
		'US1840025376' => 'Juntura',
		'US1840018651' => 'Chiloquin',
		'US1840034828' => 'Mount Hood Village',
		'US1840019933' => 'North Plains',
		'US1840018581' => 'Keizer',
		'US1840025461' => 'Ruch',
		'US1840017420' => 'Brooks',
		'US1840020002' => 'Ontario',
		'US1840023951' => 'Blodgett',
		'US1840020053' => 'Merrill',
		'US1840018624' => 'Cottage Grove',
		'US1840019925' => 'Lonerock',
		'US1840018622' => 'Coburg',
		'US1840025489' => 'Williams',
		'US1840034836' => 'Kirkpatrick',
		'US1840040459' => 'Wallowa Lake',
		'US1840020054' => 'Klamath Falls',
		'US1840025460' => 'Prospect',
		'US1840021229' => 'Turner',
		'US1840018580' => 'Jefferson',
		'US1840018577' => 'Aumsville',
		'US1840025484' => 'Merlin',
		'US1840019914' => 'Helix',
		'US1840021230' => 'Woodburn',
		'US1840019938' => 'Fairview',
		'US1840019988' => 'Metolius',
		'US1840020034' => 'Roseburg',
		'US1840020074' => 'Gold Hill',
		'US1840021208' => 'Wasco',
		'US1840025279' => 'Deer Island',
		'US1840020033' => 'Riddle',
		'US1840018639' => 'Canyonville',
		'US1840025483' => 'Kerby',
		'US1840034833' => 'Rockcreek',
		'US1840034678' => 'Cedar Mill',
		'US1840019922' => 'Elgin',
		'US1840019934' => 'King City',
		'US1840018576' => 'Mehama',
		'US1840034722' => 'Four Corners',
		'US1840017412' => 'Beaver',
		'US1840025486' => 'OBrien',
		'US1840019994' => 'Millersburg',
		'US1840018550' => 'Oceanside',
		'US1840023936' => 'Camp Sherman',
		'US1840018640' => 'Drain',
		'US1840019959' => 'Gates',
		'US1840020001' => 'Nyssa',
		'US1840019967' => 'Halfway',
		'US1840018535' => 'Adams',
		'US1840020075' => 'Rogue River',
		'US1840019991' => 'Lebanon',
		'US1840021235' => 'Waldport',
		'US1840018626' => 'Dunes City',
		'US1840021222' => 'Yamhill',
		'US1840021264' => 'Veneta',
		'US1840023939' => 'Crabtree',
		'US1840021228' => 'Sublimity',
		'US1840034819' => 'Sunriver',
		'US1840019998' => 'Philomath',
		'US1840019939' => 'Gresham',
		'US1840021284' => 'Lakeview',
		'US1840034834' => 'Three Rivers',
		'US1840018604' => 'South Lebanon',
		'US1840034713' => 'Beavercreek',
		'US1840021224' => 'Salem',
		'US1840040416' => 'Bull Mountain',
		'US1840023953' => 'Summit',
		'US1840025373' => 'Annex',
		'US1840020010' => 'Oakridge',
		'US1840023908' => 'Government Camp',
		'US1840021193' => 'Stanfield',
		'US1840023938' => 'Cascadia',
		'US1840021187' => 'Vernonia',
		'US1840019989' => 'Halsey',
		'US1840019926' => 'Garibaldi',
		'US1840018681' => 'Cave Junction',
		'US1840034830' => 'Oak Hills',
		'US1840021183' => 'Warrenton',
		'US1840023950' => 'Bellfountain',
		'US1840025437' => 'Plush',
		'US1840018619' => 'Terrebonne',
		'US1840021261' => 'Vale',
		'US1840022334' => 'Summerville',
		'US1840018512' => 'Clatskanie',
		'US1840018569' => 'Canby',
		'US1840019970' => 'Falls City',
		'US1840020008' => 'Florence',
		'US1840019937' => 'Moro',
		'US1840019954' => 'Oregon City',
		'US1840017416' => 'Biggs Junction',
		'US1840073994' => 'Gopher Flats',
		'US1840018541' => 'Ione',
		'US1840018570' => 'Johnson City',
		'US1840021221' => 'Willamina',
		'US1840021218' => 'West Linn',
		'US1840034831' => 'Redwood',
		'US1840034758' => 'Cape Meares',
		'US1840018555' => 'Banks',
		'US1840019905' => 'Gearhart',
		'US1840018534' => 'Mission',
		'US1840017438' => 'Glide',
		'US1840021298' => 'Butte Falls',
		'US1840020009' => 'Lowell',
		'US1840020004' => 'La Pine',
		'US1840018673' => 'White City',
		'US1840018591' => 'Lincoln Beach',
		'US1840020076' => 'Medford',
		'US1840034811' => 'Idaville',
		'US1840019941' => 'Portland',
		'US1840018505' => 'Cannon Beach',
		'US1840017423' => 'Eola',
		'US1840021274' => 'Sutherlin',
		'US1840018562' => 'Pine Grove',
		'US1840018546' => 'Arlington',
		'US1840018637' => 'Tri-City',
		'US1840019930' => 'Forest Grove',
		'US1840019907' => 'Prescott',
		'US1840020057' => 'North Bend',
		'US1840042766' => 'Jeffers Gardens',
		'US1840019915' => 'Hermiston',
		'US1840021205' => 'Sherwood',
		'US1840018574' => 'Dayton',
		'US1840018547' => 'Condon',
		'US1840018618' => 'Bend',
		'US1840021195' => 'Umatilla',
		'US1840034726' => 'Hayesville',
		'US1840021234' => 'Toledo',
		'US1840023942' => 'Lacomb',
		'US1840020055' => 'Paisley',
		'US1840021225' => 'Scotts Mills',
		'US1840022339' => 'Spray',
		'US1840017421' => 'Butteville',
		'US1840019983' => 'Prairie City',
		'US1840020030' => 'Elkton',
		'US1840019917' => 'Pendleton',
		'US1840140052' => 'New Pine Creek',
		'US1840021204' => 'Wheeler',
		'US1840018617' => 'Jordan Valley',
		'US1840019997' => 'Monroe',
		'US1840018605' => 'Albany',
		'US1840019957' => 'Newberg',
		'US1840018625' => 'Creswell',
		'US1840021194' => 'Ukiah',
		'US1840034825' => 'Pine Hollow',
		'US1840025375' => 'Harper',
		'US1840017414' => 'Aloha',
		'US1840034810' => 'Raleigh Hills',
		'US1840018675' => 'Jacksonville',
		'US1840018672' => 'Central Point',
		'US1840018610' => 'Adair Village',
		'US1840021299' => 'Shady Cove',
		'US1840020056' => 'Myrtle Point',
		'US1840018556' => 'Beaverton',
		'US1840018573' => 'Carlton',
		'US1840021265' => 'Westfir',
		'US1840034711' => 'Bayside Gardens',
		'US1840019935' => 'Grass Valley',
		'US1840025400' => 'Crane',
		'US1840019955' => 'Lake Oswego',
		'US1840020052' => 'Malin',
		'US1840018653' => 'Coos Bay',
		'US1840019951' => 'Rivergrove',
		'US1840025417' => 'Fair Oaks',
		'US1840018513' => 'Columbia City',
		'US1840019971' => 'Monmouth',
		'US1840019948' => 'Estacada',
		'US1840019958' => 'Lafayette',
		'US1840034835' => 'Tutuilla',
		'US1840018549' => 'Netarts',
		'US1840018568' => 'Oak Grove',
		'US1840017458' => 'Harbor',
		'US1840018592' => 'Rose Lodge',
		'US1840021300' => 'Talent',
		'US1840019936' => 'Rufus',
		'US1840021206' => 'Tigard',
		'US1840018553' => 'Metzger',
		'US1840018567' => 'Dufur',
		'US1840018504' => 'Astoria',
		'US1840025462' => 'Trail',
		'US1840023910' => 'Stafford',
		'US1840019982' => 'Mount Vernon',
		'US1840021233' => 'Siletz',
		'US1840018566' => 'Antelope',
		'US1840021185' => 'St. Helens',
		'US1840025280' => 'Warren',
		'US1840019940' => 'Maywood Park',
		'US1840026116' => 'Fort Hill',
		'US1840019990' => 'Harrisburg',
		'US1840021219' => 'Wilsonville',
		'US1840019993' => 'Mill City',
		'US1840019968' => 'Huntington',
		'US1840021217' => 'Sandy',
		'US1840021226' => 'Silverton',
		'US1840018676' => 'Eagle Point',
		'US1840019965' => 'Greenhorn',
		'US1840022350' => 'Waterloo',
		'US1840018616' => 'Adrian',
		'US1840019913' => 'Echo',
		'US1840021253' => 'Sweet Home',
		'US1840023943' => 'Peoria',
		'US1840025485' => 'New Hope',
		'US1840021211' => 'Shaniko',
		'US1840021231' => 'Sumpter',
		'US1840018590' => 'Dallas',
		'US1840021283' => 'Bonanza',
		'US1840019952' => 'Milwaukie',
		'US1840019928' => 'Manzanita',
		'US1840017419' => 'Jennings Lodge',
		'US1840020031' => 'Glendale',
		'US1840018579' => 'Idanha',
		'US1840021227' => 'Stayton',
		'US1840019987' => 'Madras',
		'US1840018575' => 'Dundee',
		'US1840025420' => 'Melrose',
		'US1840018588' => 'Rickreall',
		'US1840074590' => 'Roseburg North',
		'US1840019929' => 'Nehalem',
		'US1840017424' => 'Grand Ronde',
		'US1840018564' => 'Tygh Valley',
		'US1840020032' => 'Reedsport',
		'US1840020036' => 'Oakland',
		'US1840020059' => 'Lakeside',
		'US1840019924' => 'La Grande',
		'US1840019961' => 'Hubbard',
		'US1840021232' => 'Unity',
		'US1840021212' => 'The Dalles',
		'US1840018638' => 'Winchester Bay',
		'US1840021262' => 'Sisters',
		'US1840021186' => 'Scappoose',
		'US1840136607' => 'Riverside',
		'US1840019974' => 'Lincoln City',
		'US1840023941' => 'Holley',
		'US1840018545' => 'Cove',
		'US1840019943' => 'Maupin',
		'US1840020079' => 'Port Orford',
		'US1840020003' => 'Redmond',
		'US1840018572' => 'Amity',
		'US1840019981' => 'Monument',
		'US1840021196' => 'Weston',
		'US1840023909' => 'Mulino',
		'US1840019979' => 'Granite',
		'US1840021251' => 'Scio',
		'US1840019962' => 'Mount Angel',
		'US1840018674' => 'Ashland',
	],
	'SD' => [
		'US1840006866' => 'White Horse',
		'US1840002856' => 'Marion',
		'US1840002094' => 'Roslyn',
		'US1840006702' => 'Whitehorse',
		'US1840026138' => 'Winfred',
		'US1840004014' => 'Little Eagle',
		'US1840000265' => 'New Effington',
		'US1840002525' => 'Presho',
		'US1840000266' => 'Ortley',
		'US1840026115' => 'Waverly',
		'US1840002852' => 'Lake Andes',
		'US1840002868' => 'Hot Springs',
		'US1840002509' => 'Aurora',
		'US1840002297' => 'Bryant',
		'US1840001563' => 'Timber Lake',
		'US1840004165' => 'Aurora Center',
		'US1840002174' => 'Sturgis',
		'US1840002640' => 'Hermosa',
		'US1840002370' => 'Yale',
		'US1840000365' => 'Oelrichs',
		'US1840002864' => 'Fairfax',
		'US1840008941' => 'Summerset',
		'US1840004098' => 'Rapid Valley',
		'US1840002281' => 'Miller',
		'US1840004201' => 'Pine Ridge',
		'US1840002368' => 'Wessington',
		'US1840002531' => 'Trent',
		'US1840004100' => 'Colonial Pine Hills',
		'US1840002847' => 'Lennox',
		'US1840002544' => 'Carthage',
		'US1840006796' => 'Vivian',
		'US1840002638' => 'Buffalo Gap',
		'US1840004231' => 'Milltown',
		'US1840002036' => 'Rosholt',
		'US1840002506' => 'Brookings',
		'US1840002121' => 'Tulare',
		'US1840000288' => 'Northville',
		'US1840035310' => 'Manderson-White Horse Creek',
		'US1840026113' => 'Vale',
		'US1840002529' => 'Alpena',
		'US1840002095' => 'Waubay',
		'US1840004031' => 'Blackhawk',
		'US1840001586' => 'Strandburg',
		'US1840026114' => 'Crocker',
		'US1840000314' => 'De Smet',
		'US1840002029' => 'Verdon',
		'US1840002087' => 'Glenham',
		'US1840000284' => 'Onaka',
		'US1840002504' => 'Volga',
		'US1840002615' => 'Pukwana',
		'US1840024046' => 'Soldier Creek',
		'US1840002303' => 'Fort Pierre',
		'US1840002085' => 'Selby',
		'US1840002643' => 'Alexandria',
		'US1840000292' => 'Clark',
		'US1840003080' => 'Elk Point',
		'US1840002157' => 'Florence',
		'US1840000315' => 'Oldham',
		'US1840002044' => 'Lake City',
		'US1840002891' => 'Batesland',
		'US1840001557' => 'Butler',
		'US1840002539' => 'Wentworth',
		'US1840002538' => 'Ramona',
		'US1840002274' => 'Astoria',
		'US1840002532' => 'Ward',
		'US1840025451' => 'Running Water',
		'US1840024017' => 'Pine Lakes Addition',
		'US1840002043' => 'Eden',
		'US1840002279' => 'Ree Heights',
		'US1840002091' => 'Roscoe',
		'US1840002416' => 'Erwin',
		'US1840002158' => 'Henry',
		'US1840001555' => 'Webster',
		'US1840002026' => 'Leola',
		'US1840002646' => 'Fulton',
		'US1840004202' => 'Porcupine',
		'US1840004015' => 'Bullhead',
		'US1840002527' => 'Kennebec',
		'US1840002089' => 'Lowry',
		'US1840001558' => 'Andover',
		'US1840000388' => 'North Sioux City',
		'US1840000324' => 'Colman',
		'US1840026186' => 'Richland',
		'US1840002508' => 'Bushnell',
		'US1840026122' => 'St. Onge',
		'US1840000338' => 'Mount Vernon',
		'US1840003064' => 'Springfield',
		'US1840000361' => 'Parkston',
		'US1840026185' => 'Dakota Dunes',
		'US1840003058' => 'Yankton',
		'US1840040547' => 'Blucksberg Mountain',
		'US1840023957' => 'Morningside',
		'US1840002022' => 'Herreid',
		'US1840002863' => 'Bonesteel',
		'US1840004258' => 'Rosebud',
		'US1840000264' => 'Corona',
		'US1840000325' => 'Nunda',
		'US1840004097' => 'Green Valley',
		'US1840004261' => 'Antelope',
		'US1840002113' => 'Tolstoy',
		'US1840040549' => 'Cow Creek',
		'US1840002894' => 'Mission',
		'US1840003060' => 'Irene',
		'US1840002414' => 'Badger',
		'US1840002155' => 'Wallace',
		'US1840002120' => 'Redfield',
		'US1840004145' => 'Okaton',
		'US1840035985' => 'Brant Lake',
		'US1840002645' => 'Farmer',
		'US1840002093' => 'Ipswich',
		'US1840002117' => 'Rockham',
		'US1840002859' => 'Freeman',
		'US1840002034' => 'Groton',
		'US1840023893' => 'Bath Corner',
		'US1840002845' => 'Harrisburg',
		'US1840002842' => 'Worthing',
		'US1840002893' => 'St. Francis',
		'US1840040574' => 'Long Hollow',
		'US1840004164' => 'Storla',
		'US1840001585' => 'Stockholm',
		'US1840002299' => 'Estelline',
		'US1840002030' => 'Warner',
		'US1840002127' => 'Belle Fourche',
		'US1840002152' => 'Bradley',
		'US1840002276' => 'Goodwin',
		'US1840000285' => 'Orient',
		'US1840035984' => 'Buffalo Chip',
		'US1840000337' => 'Custer',
		'US1840002612' => 'Plankinton',
		'US1840000287' => 'Doland',
		'US1840002037' => 'Sisseton',
		'US1840002862' => 'Burke',
		'US1840002045' => 'Langford',
		'US1840002184' => 'Hill City',
		'US1840000301' => 'Philip',
		'US1840002124' => 'Ashton',
		'US1840003061' => 'Lesterville',
		'US1840000356' => 'Davis',
		'US1840002651' => 'Baltic',
		'US1840000312' => 'Deadwood',
		'US1840023898' => 'Kidder',
		'US1840002654' => 'Humboldt',
		'US1840002154' => 'South Shore',
		'US1840000311' => 'Central City',
		'US1840000363' => 'Delmont',
		'US1840004200' => 'Oglala',
		'US1840002413' => 'Arlington',
		'US1840003083' => 'Wakonda',
		'US1840000275' => 'Eagle Butte',
		'US1840040544' => 'Anderson',
		'US1840002841' => 'Tea',
		'US1840002505' => 'White',
		'US1840002099' => 'Milbank',
		'US1840022340' => 'Piedmont',
		'US1840000330' => 'Draper',
		'US1840004020' => 'North Eagle Butte',
		'US1840000289' => 'Newell',
		'US1840002653' => 'Hartford',
		'US1840000323' => 'Oacoma',
		'US1840002271' => 'Toronto',
		'US1840002016' => 'McLaughlin',
		'US1840000276' => 'Dupree',
		'US1840002123' => 'Brentford',
		'US1840003062' => 'Mission Hill',
		'US1840004232' => 'Kaylor',
		'US1840002280' => 'St. Lawrence',
		'US1840002180' => 'Rapid City',
		'US1840002648' => 'Sioux Falls',
		'US1840002027' => 'Long Lake',
		'US1840000354' => 'Pickstown',
		'US1840000298' => 'Clear Lake',
		'US1840004199' => 'Kyle',
		'US1840002535' => 'Woonsocket',
		'US1840002090' => 'Mobridge',
		'US1840004256' => 'Allen',
		'US1840002040' => 'Wilmot',
		'US1840003066' => 'Tyndall',
		'US1840002032' => 'Aberdeen',
		'US1840003063' => 'Scotland',
		'US1840002650' => 'Brandon',
		'US1840002017' => 'Morristown',
		'US1840003081' => 'Jefferson',
		'US1840002586' => 'Interior',
		'US1840004234' => 'New Holland',
		'US1840001560' => 'Lily',
		'US1840002585' => 'Belvidere',
		'US1840000273' => 'Bowdle',
		'US1840002502' => 'Lake Preston',
		'US1840002658' => 'Canistota',
		'US1840002507' => 'Bruce',
		'US1840000261' => 'Claremont',
		'US1840002647' => 'Sherman',
		'US1840002042' => 'Britton',
		'US1840035951' => 'Caputa',
		'US1840000334' => 'Cottonwood',
		'US1840002855' => 'Hurley',
		'US1840002033' => 'Frederick',
		'US1840002019' => 'Camp Crook',
		'US1840023999' => 'Chester',
		'US1840002183' => 'Box Elder',
		'US1840002540' => 'Madison',
		'US1840000358' => 'Parker',
		'US1840002613' => 'Stickney',
		'US1840002652' => 'Garretson',
		'US1840003082' => 'Vermillion',
		'US1840004257' => 'Parmelee',
		'US1840026124' => 'Johnson Siding',
		'US1840002682' => 'Winner',
		'US1840000260' => 'Mound City',
		'US1840002631' => 'Wood',
		'US1840002537' => 'Letcher',
		'US1840002641' => 'Ethan',
		'US1840000318' => 'New Underwood',
		'US1840000336' => 'Chamberlain',
		'US1840002114' => 'Gettysburg',
		'US1840040539' => 'Agency Village',
		'US1840002041' => 'Veblen',
		'US1840002844' => 'Fairview',
		'US1840006730' => 'Big Stone City',
		'US1840002848' => 'Platte',
		'US1840002119' => 'Faulkton',
		'US1840000353' => 'Dante',
		'US1840002013' => 'Bison',
		'US1840040550' => 'Gann Valley',
		'US1840001564' => 'Isabel',
		'US1840002630' => 'White River',
		'US1840002125' => 'Frankfort',
		'US1840002866' => 'Herrick',
		'US1840002657' => 'Bridgewater',
		'US1840002092' => 'Hosmer',
		'US1840004142' => 'Lower Brule',
		'US1840002035' => 'Hecla',
		'US1840023894' => 'Ferney',
		'US1840002015' => 'McIntosh',
		'US1840002098' => 'Marvin',
		'US1840066312' => 'La Bolt',
		'US1840000286' => 'Conde',
		'US1840003067' => 'Avon',
		'US1840003059' => 'Gayville',
		'US1840004230' => 'Marty',
		'US1840073768' => 'North Spearfish',
		'US1840000339' => 'Colton',
		'US1840001556' => 'Bristol',
		'US1840002849' => 'Ravinia',
		'US1840002536' => 'Artesian',
		'US1840002181' => 'Wall',
		'US1840002846' => 'Hudson',
		'US1840002649' => 'Valley Springs',
		'US1840002519' => 'Quinn',
		'US1840006845' => 'Wounded Knee',
		'US1840002510' => 'Elkton',
		'US1840002088' => 'Java',
		'US1840000360' => 'Olivet',
		'US1840002309' => 'Midland',
		'US1840002545' => 'Howard',
		'US1840026105' => 'Mansfield',
		'US1840002541' => 'Roswell',
		'US1840002851' => 'Geddes',
		'US1840002031' => 'Westport',
		'US1840000293' => 'Naples',
		'US1840002182' => 'Wasta',
		'US1840000299' => 'Onida',
		'US1840002122' => 'Turton',
		'US1840002639' => 'Fairburn',
		'US1840002637' => 'Pringle',
		'US1840000290' => 'Nisland',
		'US1840004186' => 'Hamill',
		'US1840002369' => 'Wolsey',
		'US1840002372' => 'Hitchcock',
		'US1840003079' => 'Beresford',
		'US1840001587' => 'Twin Brooks',
		'US1840002277' => 'Agar',
		'US1840003057' => 'Volin',
		'US1840002153' => 'Garden City',
		'US1840002642' => 'Mitchell',
		'US1840002021' => 'Artas',
		'US1840002616' => 'Kimball',
		'US1840024016' => 'Meadow View Addition',
		'US1840002023' => 'Wetonka',
		'US1840000274' => 'Pierpont',
		'US1840006816' => 'Wanblee',
		'US1840002020' => 'Pollock',
		'US1840002587' => 'Kadoka',
		'US1840066313' => 'New Witten',
		'US1840002854' => 'Centerville',
		'US1840002857' => 'Monroe',
		'US1840004170' => 'Loomis',
		'US1840026139' => 'Fedora',
		'US1840004019' => 'La Plant',
		'US1840001584' => 'Revillo',
		'US1840003056' => 'Utica',
		'US1840000262' => 'Columbia',
		'US1840002149' => 'Raymond',
		'US1840024011' => 'Bijou Hills',
		'US1840024014' => 'Norris',
		'US1840024018' => 'Renner Corner',
		'US1840002542' => 'Vilas',
		'US1840002528' => 'Wessington Springs',
		'US1840000364' => 'Dallas',
		'US1840002024' => 'Eureka',
		'US1840024013' => 'Corn Creek',
		'US1840000331' => 'Murdo',
		'US1840004260' => 'Two Strike',
		'US1840002371' => 'Cavour',
		'US1840002656' => 'Spencer',
		'US1840002861' => 'Armour',
		'US1840002850' => 'Wagner',
		'US1840002415' => 'Bancroft',
		'US1840000357' => 'Dolton',
		'US1840004233' => 'Harrison',
		'US1840002375' => 'Whitewood',
		'US1840002843' => 'Canton',
		'US1840023891' => 'Prairie City',
		'US1840000341' => 'Dell Rapids',
		'US1840002273' => 'Altamont',
		'US1840002278' => 'Highmore',
		'US1840002534' => 'Flandreau',
		'US1840002533' => 'Egan',
		'US1840002860' => 'Menno',
		'US1840000355' => 'Chancellor',
		'US1840002128' => 'Fruitdale',
		'US1840002115' => 'Hoven',
		'US1840002853' => 'Viborg',
		'US1840002411' => 'Blunt',
		'US1840000267' => 'Peever',
		'US1840004099' => 'Ashland Heights',
		'US1840002614' => 'White Lake',
		'US1840002892' => 'Martin',
		'US1840002501' => 'Iroquois',
		'US1840024012' => 'Ola',
		'US1840002159' => 'Kranzburg',
		'US1840002116' => 'Lebanon',
		'US1840000313' => 'Pierre',
		'US1840040554' => 'Lake Madison',
		'US1840002543' => 'Canova',
		'US1840002412' => 'Harrold',
		'US1840002376' => 'Lead',
		'US1840002185' => 'Keystone',
		'US1840008965' => 'Broadland',
		'US1840002301' => 'Hazel',
		'US1840003065' => 'Tabor',
		'US1840000340' => 'Crooks',
		'US1840002300' => 'Hayti',
		'US1840040570' => 'Lake Poinsett',
		'US1840024043' => 'Shindler',
		'US1840004259' => 'Spring Creek',
		'US1840002175' => 'Faith',
		'US1840004143' => 'Fort Thompson',
		'US1840002096' => 'Albee',
		'US1840002865' => 'Gregory',
		'US1840000283' => 'Cresbard',
		'US1840023892' => 'Bath',
		'US1840002028' => 'Stratford',
		'US1840002275' => 'Gary',
		'US1840000362' => 'Corsica',
		'US1840004018' => 'Green Grass',
		'US1840002526' => 'Reliance',
		'US1840002367' => 'Virgil',
		'US1840003078' => 'Alcester',
		'US1840002272' => 'Brandt',
		'US1840002503' => 'Sinai',
		'US1840002150' => 'Vienna',
		'US1840002014' => 'Lemmon',
		'US1840001559' => 'Grenville',
		'US1840002500' => 'Hetland',
		'US1840000263' => 'Claire City',
		'US1840023896' => 'Goodwill',
		'US1840023997' => 'Forestburg',
		'US1840002126' => 'Mellette',
		'US1840002298' => 'Castlewood',
		'US1840000282' => 'Chelsea',
		'US1840002858' => 'Tripp',
		'US1840002118' => 'Seneca',
		'US1840000359' => 'Dimock',
		'US1840002086' => 'Akaska',
		'US1840002025' => 'Hillsview',
		'US1840002655' => 'Salem',
		'US1840002373' => 'Huron',
		'US1840002867' => 'Edgemont',
		'US1840004235' => 'St. Charles',
		'US1840020692' => 'White Rock',
		'US1840002302' => 'Lake Norden',
		'US1840002038' => 'Summit',
		'US1840000346' => 'Colome',
		'US1840024045' => 'Okreek',
		'US1840002530' => 'Lane',
		'US1840002151' => 'Willow Lake',
		'US1840002659' => 'Montrose',
		'US1840002374' => 'Spearfish',
		'US1840002644' => 'Emery',
		'US1840002156' => 'Watertown',
		'US1840002018' => 'Buffalo',
	]
];
