<?php

/**
 * List of cities for: Ukraine
 * Source: http://www.statoids.com/yua.html
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'UACK' => 'Cherkasy',
	'UACH' => 'Chernihiv',
	'UACV' => 'Chernivtsi',
	'UAKR' => 'Crimea',
	'UADP' => 'Dnipropetrovsk',
	'UADT' => 'Donetsk',
	'UAIF' => 'Ivano-Frankivsk',
	'UAKK' => 'Kharkiv',
	'UAKS' => 'Kherson',
	'UAKM' => 'Khmelnytskyy',
	'UAKV' => 'Kiev',
	'UAKC' => 'Kiev City',
	'UAKH' => 'Kirovohrad',
	'UALH' => 'Luhansk',
	'UALV' => 'Lviv',
	'UAMY' => 'Mykolayiv',
	'UAOD' => 'Odessa',
	'UAPL' => 'Poltava',
	'UARV' => 'Rivne',
	'UASC' => 'Sevastopol City',
	'UASM' => 'Sumy',
	'UATP' => 'Ternopil',
	'UAZK' => 'Transcarpathia',
	'UAVI' => 'Vinnytsya',
	'UAVO' => 'Volyn',
	'UAZP' => 'Zaporizhzhya',
	'UAZT' => 'Zhytomyr',
];

$country_cities = [
	'UACH' => [
		'UACHBA' => 'Bakhmatskyi',
		'UACHBB' => 'Bobrovytskyi',
		'UACHBZ' => 'Borznianskyi',
		'UACHCM' => 'Chernihivska',
		'UACHCR' => 'Chernihivskyi',
		'UACHHO' => 'Horodnianskyi',
		'UACHIC' => 'Ichnianskyi',
		'UACHKK' => 'Koriukivskyi',
		'UACHKP' => 'Koropskyi',
		'UACHKU' => 'Kulykivskyi',
		'UACHKZ' => 'Kozeletskyi',
		'UACHME' => 'Menskyi',
		'UACHNM' => 'Nizhynska',
		'UACHNO' => 'Nosivskyi',
		'UACHNR' => 'Nizhynskyi',
		'UACHNS' => 'Novhorod-Siverskyi',
		'UACHPM' => 'Prylutska',
		'UACHPR' => 'Prylutskyi',
		'UACHRI' => 'Ripkynskyi',
		'UACHSE' => 'Semenivskyi',
		'UACHSH' => 'Shchorskyi',
		'UACHSO' => 'Sosnytskyi',
		'UACHSR' => 'Sribnianskyi',
		'UACHTA' => 'Talalaïvskyi',
		'UACHVA' => 'Varvynskyi',
	],
	'UACK' => [
		'UACKCB' => 'Chornobaivskyi',
		'UACKCM' => 'Cherkaska',
		'UACKCR' => 'Cherkaskyi',
		'UACKCY' => 'Chyhyrynskyi',
		'UACKDR' => 'Drabivskyi',
		'UACKHO' => 'Horodyshchenskyi',
		'UACKKH' => 'Khrystynivskyi',
		'UACKKM' => 'Kanivska',
		'UACKKN' => 'Kamianskyi',
		'UACKKO' => 'Korsun-Shevchenkivskyi',
		'UACKKR' => 'Kanivskyi',
		'UACKKT' => 'Katerynopilskyi',
		'UACKLY' => 'Lysianskyi',
		'UACKMA' => 'Mankivskyi',
		'UACKMO' => 'Monastyryshchenskyi',
		'UACKSH' => 'Shpolianskyi',
		'UACKSM' => 'Smilianska',
		'UACKSR' => 'Smilianskyi',
		'UACKTA' => 'Talnivskyi',
		'UACKUM' => 'Umanska',
		'UACKUR' => 'Umanskyi',
		'UACKVA' => 'Vatutinska',
		'UACKZH' => 'Zhashkivskyi',
		'UACKZM' => 'Zolotoniska',
		'UACKZR' => 'Zolotoniskyi',
		'UACKZV' => 'Zvenyhorodskyi',
	],
	'UACV' => [
		'UACVCH' => 'Chernivetska',
		'UACVHE' => 'Hertsaïvskyi',
		'UACVHL' => 'Hlybotskyi',
		'UACVKE' => 'Kelmenetskyi',
		'UACVKH' => 'Khotynskyi',
		'UACVKI' => 'Kitsmanskyi',
		'UACVNO' => 'Novodnistrovska',
		'UACVNS' => 'Novoselitskyi',
		'UACVPU' => 'Putylskyi',
		'UACVSO' => 'Sokyrianskyi',
		'UACVST' => 'Storozhynetskyi',
		'UACVVY' => 'Vyzhnytskyi',
		'UACVZA' => 'Zastavnetskyi',
	],
	'UADP' => [
		'UADPAP' => 'Apostolivskyi',
		'UADPDD' => 'Dniprodzerzhynska',
		'UADPDM' => 'Dnipropetrovska',
		'UADPDR' => 'Dnipropetrovskyi',
		'UADPIU' => 'Iurïvskyi',
		'UADPKC' => 'Krynychanskyi',
		'UADPKM' => 'Kryvorizka',
		'UADPKR' => 'Kryvorizkyi',
		'UADPMD' => 'Mahdalynivskyi',
		'UADPME' => 'Mezhivskyi',
		'UADPMR' => 'Marhanetska',
		'UADPNK' => 'Nikopolskyi',
		'UADPNM' => 'Novomoskovska',
		'UADPNP' => 'Nikopolska',
		'UADPNV' => 'Novomoskovskyi',
		'UADPOR' => 'Ordzhonikidzevska',
		'UADPPE' => 'Pershotravenska',
		'UADPPI' => 'Piatykhatskyi',
		'UADPPK' => 'Petrykivskyi',
		'UADPPM' => 'Pavlohradska',
		'UADPPO' => 'Pokrovskyi',
		'UADPPP' => 'Petropavlivskyi',
		'UADPPR' => 'Pavlohradskyi',
		'UADPSF' => 'Sofiïvskyi',
		'UADPSH' => 'Shyrokivskyi',
		'UADPSL' => 'Solonianskyi',
		'UADPSM' => 'Synelnykivska',
		'UADPSR' => 'Synelnykivskyi',
		'UADPTE' => 'Ternivska',
		'UADPTO' => 'Tomakivskyi',
		'UADPTS' => 'Tsarychanskyi',
		'UADPVA' => 'Vasylkivskyi',
		'UADPVE' => 'Verkhnodniprovskyi',
		'UADPVI' => 'Vilnohirska',
		'UADPZH' => 'Zhovtovodska',
	],
	'UADT' => [
		'UADTAM' => 'Artemivska',
		'UADTAR' => 'Artemivskyi',
		'UADTAS' => 'Amvrosiïvskyi',
		'UADTAV' => 'Avdiïvska',
		'UADTDC' => 'Dokuchaievska',
		'UADTDE' => 'Debaltsevska',
		'UADTDK' => 'Druzhkivska',
		'UADTDM' => 'Dobropilska',
		'UADTDN' => 'Donetska',
		'UADTDR' => 'Dobropilskyi',
		'UADTDY' => 'Dymytrivska',
		'UADTDZ' => 'Dzerzhynska',
		'UADTHO' => 'Horlivska',
		'UADTIE' => 'Ienakiievska',
		'UADTIM' => 'Iasynuvatska',
		'UADTIR' => 'Iasynuvatskyi',
		'UADTKA' => 'Krasnoarmiiska',
		'UADTKH' => 'Khartsyzka',
		'UADTKI' => 'Kirovska',
		'UADTKL' => 'Krasnolymanskyi',
		'UADTKM' => 'Kramatorska',
		'UADTKR' => 'Krasnoarmiiskyi',
		'UADTKS' => 'Kostiantynivskyi',
		'UADTKT' => 'Kostiantynivska',
		'UADTKY' => 'Krasnolymanska',
		'UADTMK' => 'Makiïvska',
		'UADTMN' => 'Marïnskyi',
		'UADTMP' => 'Mariupolska',
		'UADTNA' => 'Novoazovskyi',
		'UADTNH' => 'Novohrodivska',
		'UADTOL' => 'Oleksandrivskyi',
		'UADTPE' => 'Pershotravnevyi',
		'UADTSE' => 'Selydovska',
		'UADTSH' => 'Shakhtarskyi',
		'UADTSK' => 'Shakhtarska',
		'UADTSL' => 'Slovianskyi',
		'UADTSN' => 'Snizhnenska',
		'UADTST' => 'Starobeshivskyi',
		'UADTSV' => 'Slovianska',
		'UADTTE' => 'Telmanivskyi',
		'UADTTO' => 'Torezka',
		'UADTVD' => 'Volodarskyi',
		'UADTVE' => 'Velykonovosilkivskyi',
		'UADTVU' => 'Vuhledarska',
		'UADTVV' => 'Volnovaskyi',
		'UADTZH' => 'Zhdanivska',
	],
	'UAIF' => [
		'UAIFBH' => 'Bohorodchanskyi',
		'UAIFBL' => 'Bolekhivska',
		'UAIFDO' => 'Dolynskyi',
		'UAIFHA' => 'Halytskyi',
		'UAIFHO' => 'Horodenkivskyi',
		'UAIFIA' => 'Iaremchanska',
		'UAIFIV' => 'Ivano-Frankivska',
		'UAIFKL' => 'Kaluskyi',
		'UAIFKM' => 'Kolomyiska',
		'UAIFKO' => 'Kosivskyi',
		'UAIFKR' => 'Kolomyiskyi',
		'UAIFKS' => 'Kaluska',
		'UAIFNA' => 'Nadvirnianskyi',
		'UAIFRH' => 'Rohatynskyi',
		'UAIFRZ' => 'Rozhniativskyi',
		'UAIFSN' => 'Sniatynskyi',
		'UAIFTL' => 'Tlumatskyi',
		'UAIFTY' => 'Tysmenytskyi',
		'UAIFVE' => 'Verkhovynskyi',
	],
	'UAKC' => [
		'UAKCDA' => 'Darnytskyi',
		'UAKCDE' => 'Desnianskyi',
		'UAKCDN' => 'Dniprovskyi',
		'UAKCHO' => 'Holosiïvskyi',
		'UAKCOB' => 'Obolonskyi',
		'UAKCPE' => 'Pecherskyi',
		'UAKCPO' => 'Podilskyi',
		'UAKCSH' => 'Shevchenkivskyi',
		'UAKCSO' => 'Solomianskyi',
		'UAKCSV' => 'Sviatoshynskyi',
	],
	'UAKH' => [
		'UAKHBO' => 'Bobrynetskyi',
		'UAKHDB' => 'Dobrovelychkivskyi',
		'UAKHDL' => 'Dolynskyi',
		'UAKHHA' => 'Haivoronskyi',
		'UAKHHO' => 'Holovanivskyi',
		'UAKHKM' => 'Kirovohradska',
		'UAKHKO' => 'Kompaniïvskyi',
		'UAKHKR' => 'Kirovohradskyi',
		'UAKHMA' => 'Malovyskivskyi',
		'UAKHNA' => 'Novoarkhanhelskyi',
		'UAKHNH' => 'Novhorodkivskyi',
		'UAKHNM' => 'Novomyrhorodskyi',
		'UAKHNU' => 'Novoukraïnskyi',
		'UAKHOM' => 'Oleksandriiska',
		'UAKHON' => 'Onufriïvskyi',
		'UAKHOR' => 'Oleksandriiskyi',
		'UAKHOV' => 'Oleksandrivskyi',
		'UAKHPE' => 'Petrivskyi',
		'UAKHSM' => 'Svitlovodska',
		'UAKHSR' => 'Svitlovodskyi',
		'UAKHUL' => 'Ulianovskyi',
		'UAKHUS' => 'Ustynivskyi',
		'UAKHVI' => 'Vilshanskyi',
		'UAKHZM' => 'Znamianska',
		'UAKHZR' => 'Znamianskyi',
	],
	'UAKK' => [
		'UAKKBH' => 'Bohodukhivskyi',
		'UAKKBL' => 'Balakliiskyi',
		'UAKKBO' => 'Borivskyi',
		'UAKKBR' => 'Barvinkivskyi',
		'UAKKBZ' => 'Blyzniukivskyi',
		'UAKKCM' => 'Chuhuïvska',
		'UAKKCR' => 'Chuhuïvskyi',
		'UAKKDE' => 'Derhachivskyi',
		'UAKKDV' => 'Dvorichanskyi',
		'UAKKIM' => 'Iziumska',
		'UAKKIR' => 'Iziumskyi',
		'UAKKKE' => 'Kehychivskyi',
		'UAKKKH' => 'Krasnohradskyi',
		'UAKKKK' => 'Krasnokutskyi',
		'UAKKKM' => 'Kharkivska',
		'UAKKKO' => 'Kolomatskyi',
		'UAKKKP' => 'Kupianska',
		'UAKKKR' => 'Kharkivskyi',
		'UAKKKU' => 'Kupianskyi',
		'UAKKLI' => 'Liubotynska',
		'UAKKLM' => 'Lozivska',
		'UAKKLR' => 'Lozivskyi',
		'UAKKNO' => 'Novovodolazkyi',
		'UAKKPC' => 'Pechenizkyi',
		'UAKKPM' => 'Pervomaiska',
		'UAKKPR' => 'Pervomaiskyi',
		'UAKKSA' => 'Sakhnovshchynskyi',
		'UAKKSH' => 'Shevchenkivskyi',
		'UAKKVA' => 'Valkivskyi',
		'UAKKVE' => 'Velykoburlutskyi',
		'UAKKVO' => 'Vovchanskyi',
		'UAKKZA' => 'Zachepylivskyi',
		'UAKKZM' => 'Zmiïvskyi',
		'UAKKZO' => 'Zolochivskyi',
	],
	'UAKM' => [
		'UAKMBI' => 'Bilohirskyi',
		'UAKMCH' => 'Chemerovetskyi',
		'UAKMDE' => 'Derazhnianskyi',
		'UAKMDU' => 'Dunaievetskyi',
		'UAKMHO' => 'Horodotskyi',
		'UAKMIA' => 'Iarmolynetskyi',
		'UAKMIZ' => 'Iziaslavskyi',
		'UAKMKA' => 'Kamianets-Podilska',
		'UAKMKL' => 'Krasylivskyi',
		'UAKMKM' => 'Khmelnytska',
		'UAKMKP' => 'Kamianets-Podilskyi',
		'UAKMKR' => 'Khmelnytskyi',
		'UAKMLE' => 'Letychivskyi',
		'UAKMNE' => 'Netishynska',
		'UAKMNO' => 'Novoushytskyi',
		'UAKMPO' => 'Polonskyi',
		'UAKMSH' => 'Shepetivskyi',
		'UAKMSK' => 'Starokostiantynivskyi',
		'UAKMSL' => 'Slavutskyi',
		'UAKMSP' => 'Shepetivska',
		'UAKMSS' => 'Starosyniavskyi',
		'UAKMST' => 'Starokostiantynivska',
		'UAKMSV' => 'Slavutska',
		'UAKMTE' => 'Teofipolskyi',
		'UAKMVI' => 'Vinkovetskyi',
		'UAKMVO' => 'Volochyskyi',
	],
	'UAKR' => [
		'UAKRAL' => 'Alushtynska',
		'UAKRAR' => 'Armianska',
		'UAKRBA' => 'Bakhchysaraiskyi',
		'UAKRBI' => 'Bilohirskyi',
		'UAKRCH' => 'Chornomorskyi',
		'UAKRDM' => 'Dzhankoiska',
		'UAKRDR' => 'Dzhankoiskyi',
		'UAKRFE' => 'Feodosiiska',
		'UAKRIA' => 'Ialtynska',
		'UAKRIE' => 'Ievpatoriiska',
		'UAKRKE' => 'Kerchenska',
		'UAKRKH' => 'Krasnohvardiiskyi',
		'UAKRKI' => 'Kirovskyi',
		'UAKRKM' => 'Krasnoperekopska',
		'UAKRKR' => 'Krasnoperekopskyi',
		'UAKRLE' => 'Leninskyi',
		'UAKRNY' => 'Nyzhnohirskyi',
		'UAKRPE' => 'Pervomaiskyi',
		'UAKRRO' => 'Rozdolnenskyi',
		'UAKRSK' => 'Sakskyi',
		'UAKRSM' => 'Simferopolska',
		'UAKRSO' => 'Sovietskyi',
		'UAKRSR' => 'Simferopolskyi',
		'UAKRSS' => 'Sakska',
		'UAKRSU' => 'Sudatska',
	],
	'UAKS' => [
		'UAKSBE' => 'Beryslavskyi',
		'UAKSBI' => 'Bilozerskyi',
		'UAKSCH' => 'Chaplynskyi',
		'UAKSHE' => 'Henicheskyi',
		'UAKSHL' => 'Holoprystanskyi',
		'UAKSHR' => 'Hornostaïvskyi',
		'UAKSIV' => 'Ivanivskyi',
		'UAKSKC' => 'Kalanchatskyi',
		'UAKSKH' => 'Khersonska',
		'UAKSKM' => 'Kakhovska',
		'UAKSKR' => 'Kakhovskyi',
		'UAKSNK' => 'Novokahovska',
		'UAKSNT' => 'Novotroïtskyi',
		'UAKSNV' => 'Novovorontsovskyi',
		'UAKSNY' => 'Nyzhnosirohozkyi',
		'UAKSSK' => 'Skadovskyi',
		'UAKSTS' => 'Tsiurupynskyi',
		'UAKSVL' => 'Velykolepetyskyi',
		'UAKSVO' => 'Velykooleksandrivskyi',
		'UAKSVR' => 'Verkhnorohachytskyi',
		'UAKSVY' => 'Vysokopilskyi',
	],
	'UAKV' => [
		'UAKVBA' => 'Baryshivskyi',
		'UAKVBD' => 'Borodianskyi',
		'UAKVBE' => 'Berezanska',
		'UAKVBH' => 'Bohuslavskyi',
		'UAKVBI' => 'Bilotserkivskyi',
		'UAKVBO' => 'Brovarska',
		'UAKVBR' => 'Boryspilskyi',
		'UAKVBS' => 'Boryspilska',
		'UAKVBT' => 'Bilotserkivska',
		'UAKVBV' => 'Brovarskyi',
		'UAKVFM' => 'Fastivska',
		'UAKVFR' => 'Fastivskyi',
		'UAKVIA' => 'Iahotynskyi',
		'UAKVIR' => 'Irpinska',
		'UAKVIV' => 'Ivankivskyi',
		'UAKVKA' => 'Kaharlytskyi',
		'UAKVKY' => 'Kyievo-Sviatoshynskyi',
		'UAKVMA' => 'Makarivskyi',
		'UAKVMY' => 'Myronivskyi',
		'UAKVOB' => 'Obukhivskyi',
		'UAKVPM' => 'Pereiaslav-Khmelnytska',
		'UAKVPO' => 'Poliskyi',
		'UAKVPP' => 'Prypiatska (1)',
		'UAKVPR' => 'Pereiaslav-Khmelnytskyi',
		'UAKVRO' => 'Rokytnianskyi',
		'UAKVRZ' => 'Rzhyshchivska',
		'UAKVSK' => 'Skvyrskyi',
		'UAKVSL' => 'Slavutytska',
		'UAKVST' => 'Stavyshchenskyi',
		'UAKVTA' => 'Tarashchanskyi',
		'UAKVTE' => 'Tetiïvskyi',
		'UAKVVM' => 'Vasylkivska',
		'UAKVVO' => 'Volodarskyi',
		'UAKVVR' => 'Vasylkivskyi',
		'UAKVVY' => 'Vyshhorodskyi',
		'UAKVZG' => 'Zgurivskyi',
	],
	'UALH' => [
		'UALHAL' => 'Alchevska',
		'UALHAM' => 'Antratsitivska',
		'UALHAR' => 'Antratsytivskyi',
		'UALHBK' => 'Bilokurakynskyi',
		'UALHBR' => 'Briankivska',
		'UALHBV' => 'Bilovodskyi',
		'UALHKI' => 'Kirovska',
		'UALHKL' => 'Krasnolutska',
		'UALHKM' => 'Krasnodonska',
		'UALHKN' => 'Kreminskyi',
		'UALHKR' => 'Krasnodonskyi',
		'UALHLH' => 'Luhanska',
		'UALHLT' => 'Lutuhynskyi',
		'UALHLY' => 'Lysychanska',
		'UALHMA' => 'Markivskyi',
		'UALHMI' => 'Milovskyi',
		'UALHNA' => 'Novoaidarskyi',
		'UALHNP' => 'Novopskovskyi',
		'UALHPL' => 'Perevalskyi',
		'UALHPM' => 'Pervomaiska',
		'UALHPO' => 'Popasnianskyi',
		'UALHRO' => 'Rovenkivska',
		'UALHRU' => 'Rubezhanska',
		'UALHSB' => 'Starobilskyi',
		'UALHSI' => 'Sieverodonetska',
		'UALHSK' => 'Stakhanivska',
		'UALHSL' => 'Stanychno-Luhanskyi',
		'UALHSM' => 'Sverdlovska',
		'UALHSR' => 'Sverdlovskyi',
		'UALHSS' => 'Slovianoserbskyi',
		'UALHSV' => 'Svativskyi',
		'UALHTR' => 'Troïtskyi',
	],
	'UALV' => [
		'UALVBO' => 'Boryslavska',
		'UALVBR' => 'Brodivskyi',
		'UALVBU' => 'Buskyi',
		'UALVCH' => 'Chervonohradska',
		'UALVDM' => 'Drohobytska',
		'UALVDR' => 'Drohobytskyi',
		'UALVHO' => 'Horodotskyi',
		'UALVIA' => 'Iavorivskyi',
		'UALVKA' => 'Kamianka-Buzkyi',
		'UALVLV' => 'Lvivska',
		'UALVMR' => 'Morshynska',
		'UALVMS' => 'Mostyskyi',
		'UALVMY' => 'Mykolaïvskyi',
		'UALVNO' => 'Novorozdolska',
		'UALVPE' => 'Peremyshlianskyi',
		'UALVPU' => 'Pustomytivskyi',
		'UALVRA' => 'Radekhivskyi',
		'UALVSK' => 'Skolivskyi',
		'UALVSM' => 'Sambirska',
		'UALVSO' => 'Sokalskyi',
		'UALVSR' => 'Sambirskyi',
		'UALVSS' => 'Starosambirskyi',
		'UALVST' => 'Stryiskyi',
		'UALVSY' => 'Stryiska',
		'UALVTR' => 'Truskavetska',
		'UALVTU' => 'Turkivskyi',
		'UALVZD' => 'Zhydachivskyi',
		'UALVZO' => 'Zolochivskyi',
		'UALVZV' => 'Zhovkivskyi',
	],
	'UAMY' => [
		'UAMYAR' => 'Arbuzynskyi',
		'UAMYBA' => 'Bashtanskyi',
		'UAMYBE' => 'Berezanskyi',
		'UAMYBH' => 'Bereznehuvatskyi',
		'UAMYBR' => 'Bratskyi',
		'UAMYDO' => 'Domanivskyi',
		'UAMYIE' => 'Ielanetskyi',
		'UAMYIU' => 'Iuzhnoukraïnska',
		'UAMYKA' => 'Kazankivskyi',
		'UAMYKR' => 'Kryvoozerskyi',
		'UAMYMM' => 'Mykolaïvska',
		'UAMYMR' => 'Mykolaïvskyi',
		'UAMYNB' => 'Novobuzkyi',
		'UAMYNO' => 'Novoodeskyi',
		'UAMYOM' => 'Ochakivska',
		'UAMYOR' => 'Ochakivskyi',
		'UAMYPM' => 'Pervomaiska',
		'UAMYPR' => 'Pervomaiskyi',
		'UAMYSN' => 'Snihurivskyi',
		'UAMYVD' => 'Vradiïvskyi',
		'UAMYVE' => 'Veselynivskyi',
		'UAMYVM' => 'Voznesenska',
		'UAMYVR' => 'Voznesenskyi',
		'UAMYZH' => 'Zhovtnevyi',
	],
	'UAOD' => [
		'UAODAN' => 'Ananïvskyi',
		'UAODAR' => 'Artsyzkyi',
		'UAODBA' => 'Baltskyi',
		'UAODBE' => 'Berezivskyi',
		'UAODBL' => 'Biliaïvskyi',
		'UAODBM' => 'Bilhorod-Dnistrovska',
		'UAODBO' => 'Bolhradskyi',
		'UAODBR' => 'Bilhorod-Dnistrovskyi',
		'UAODFR' => 'Frunzivskyi',
		'UAODIL' => 'Illichivska',
		'UAODIM' => 'Izmaïlska',
		'UAODIR' => 'Izmaïlskyi',
		'UAODIU' => 'Iuzhnenska',
		'UAODIV' => 'Ivanivskyi',
		'UAODKD' => 'Kodymskyi',
		'UAODKI' => 'Kominternivskyi',
		'UAODKL' => 'Kiliiskyi',
		'UAODKM' => 'Kotovska',
		'UAODKO' => 'Krasnooknianskyi',
		'UAODKR' => 'Kotovskyi',
		'UAODLI' => 'Liubashivskyi',
		'UAODMY' => 'Mykolaïvskyi',
		'UAODOD' => 'Odeska',
		'UAODOV' => 'Ovidiopolskyi',
		'UAODRE' => 'Reniiskyi',
		'UAODRO' => 'Rozdilniaskyi',
		'UAODSH' => 'Shyriaïvskyi',
		'UAODSR' => 'Saratskyi',
		'UAODSV' => 'Savranskyi',
		'UAODTE' => 'Teplodarska',
		'UAODTR' => 'Tarutynskyi',
		'UAODTT' => 'Tatarbunarskyi',
		'UAODVE' => 'Velykomykhailivskyi',
	],
	'UAPL' => [
		'UAPLCR' => 'Chornukhynskyi',
		'UAPLCT' => 'Chutivskyi',
		'UAPLDY' => 'Dykanskyi',
		'UAPLHA' => 'Hadiatskyi',
		'UAPLHL' => 'Hlobynskyi',
		'UAPLHR' => 'Hrebinkivskyi',
		'UAPLKA' => 'Karlivskyi',
		'UAPLKB' => 'Kobeliatskyi',
		'UAPLKH' => 'Khorolskyi',
		'UAPLKM' => 'Kremenchutska',
		'UAPLKR' => 'Kremenchutskyi',
		'UAPLKS' => 'Komsomolska',
		'UAPLKT' => 'Kotelevskyi',
		'UAPLKZ' => 'Kozelshchynskyi',
		'UAPLLM' => 'Lubenska',
		'UAPLLO' => 'Lokhvytskyi',
		'UAPLLR' => 'Lubenskyi',
		'UAPLMA' => 'Mashivskyi',
		'UAPLMM' => 'Myrhorodska',
		'UAPLMR' => 'Myrhorodskyi',
		'UAPLNO' => 'Novosanzharskyi',
		'UAPLOR' => 'Orzhytskyi',
		'UAPLPM' => 'Poltavska',
		'UAPLPR' => 'Poltavskyi',
		'UAPLPY' => 'Pyriatynskyi',
		'UAPLRE' => 'Reshetylivskyi',
		'UAPLSE' => 'Semenivskyi',
		'UAPLSH' => 'Shyshatskyi',
		'UAPLVE' => 'Velykobahachanskyi',
		'UAPLZI' => 'Zinkivskyi',
	],
	'UARV' => [
		'UARVBE' => 'Bereznivskyi',
		'UARVDB' => 'Dubenskyi',
		'UARVDE' => 'Demydivskyi',
		'UARVDR' => 'Dubrovytskyi',
		'UARVDU' => 'Dubnivska',
		'UARVHO' => 'Hoshchanskyi',
		'UARVKP' => 'Kostopilskyi',
		'UARVKR' => 'Koretskyi',
		'UARVKU' => 'Kuznetsovska',
		'UARVML' => 'Mlynivskyi',
		'UARVOM' => 'Ostrozka',
		'UARVOR' => 'Ostrozkyi',
		'UARVRA' => 'Radyvylivskyi',
		'UARVRM' => 'Rivnenska',
		'UARVRO' => 'Rokytnivskyi',
		'UARVRR' => 'Rivnenskyi',
		'UARVSA' => 'Sarnenskyi',
		'UARVVO' => 'Volodymyretskyi',
		'UARVZA' => 'Zarichnenskyi',
		'UARVZD' => 'Zdolbunivskyi',
	],
	'UASC' => [
		'UASCBA' => 'Balaklavskyi',
		'UASCHA' => 'Haharinskyi',
		'UASCLE' => 'Leninskyi',
		'UASCNA' => 'Nakhimovskyi',
	],
	'UASM' => [
		'UASMBI' => 'Bilopilskyi',
		'UASMBU' => 'Burynskyi',
		'UASMHM' => 'Hlukhivska',
		'UASMHR' => 'Hlukhivskyi',
		'UASMIA' => 'Iampilskyi',
		'UASMKM' => 'Konotopska',
		'UASMKP' => 'Krasnopilskyi',
		'UASMKR' => 'Konotopskyi',
		'UASMKV' => 'Krolevetskyi',
		'UASMLM' => 'Lebedynska',
		'UASMLR' => 'Lebedynskyi',
		'UASMLY' => 'Lypovodolynskyi',
		'UASMNE' => 'Nedryhailivskyi',
		'UASMOM' => 'Okhtyrska',
		'UASMOR' => 'Okhtyrskyi',
		'UASMPU' => 'Putyvlskyi',
		'UASMRM' => 'Romenska',
		'UASMRR' => 'Romenskyi',
		'UASMSE' => 'Seredyno-Budskyi',
		'UASMSH' => 'Shostkinskyi',
		'UASMSK' => 'Shostkinska',
		'UASMSM' => 'Sumska',
		'UASMSR' => 'Sumskyi',
		'UASMTR' => 'Trostianetskyi',
		'UASMVE' => 'Velykopysarivskyi',
	],
	'UATP' => [
		'UATPBE' => 'Berezhanskyi',
		'UATPBO' => 'Borshchivskyi',
		'UATPBU' => 'Buchatskyi',
		'UATPCH' => 'Chortkivskyi',
		'UATPHU' => 'Husiatynskyi',
		'UATPKO' => 'Kozivskyi',
		'UATPKR' => 'Kremenetskyi',
		'UATPLA' => 'Lanovetskyi',
		'UATPMO' => 'Monastyryskyi',
		'UATPPH' => 'Pidhaietskyi',
		'UATPPV' => 'Pidvolochyskyi',
		'UATPSH' => 'Shumskyi',
		'UATPTB' => 'Terebovlianskyi',
		'UATPTM' => 'Ternopilska',
		'UATPTR' => 'Ternopilskyi',
		'UATPZA' => 'Zalishchytskyi',
		'UATPZV' => 'Zborivskyi',
		'UATPZZ' => 'Zbarazkyi',
	],
	'UAVI' => [
		'UAVIBA' => 'Barskyi',
		'UAVIBE' => 'Bershadskyi',
		'UAVICC' => 'Chechelnytskyi',
		'UAVICR' => 'Chernivetskyi',
		'UAVIHA' => 'Haisynskyi',
		'UAVIIA' => 'Iampilskyi',
		'UAVIIL' => 'Illinetskyi',
		'UAVIKA' => 'Kalynivskyi',
		'UAVIKH' => 'Khmilnytskyi',
		'UAVIKM' => 'Koziatynska',
		'UAVIKN' => 'Khmilnytska',
		'UAVIKR' => 'Koziatynskyi',
		'UAVIKZ' => 'Kryzhopilskyi',
		'UAVILA' => 'Ladyzhynska',
		'UAVILI' => 'Litynskyi',
		'UAVILY' => 'Lypovetskyi',
		'UAVIMM' => 'Mohyliv-Podilska',
		'UAVIMR' => 'Mohyliv-Podilskyi',
		'UAVIMU' => 'Murovano-Kurylovetskyi',
		'UAVINE' => 'Nemyrivskyi',
		'UAVIOR' => 'Orativskyi',
		'UAVIPI' => 'Pishchanskyi',
		'UAVIPO' => 'Pohrebyshchenskyi',
		'UAVISH' => 'Sharhorodskyi',
		'UAVITE' => 'Teplytskyi',
		'UAVITO' => 'Tomashpilskyi',
		'UAVITR' => 'Trostianetskyi',
		'UAVITU' => 'Tulchynskyi',
		'UAVITY' => 'Tyvrivskyi',
		'UAVIVM' => 'Vinnytska',
		'UAVIVR' => 'Vinnytskyi',
		'UAVIZM' => 'Zhmerynska',
		'UAVIZR' => 'Zhmerynskyi',
	],
	'UAVO' => [
		'UAVOHO' => 'Horokhivskyi',
		'UAVOIV' => 'Ivanychivskyi',
		'UAVOKA' => 'Kamin-Kashyrskyi',
		'UAVOKI' => 'Kivertsivskyi',
		'UAVOKM' => 'Kovelska',
		'UAVOKR' => 'Kovelskyi',
		'UAVOLL' => 'Liubomlskyi',
		'UAVOLM' => 'Lutska',
		'UAVOLO' => 'Lokachynskyi',
		'UAVOLR' => 'Lutskyi',
		'UAVOLS' => 'Liubeshivskyi',
		'UAVOMA' => 'Manevytskyi',
		'UAVONO' => 'Novovolynska',
		'UAVORA' => 'Ratnivskyi',
		'UAVORO' => 'Rozhyshchenskyi',
		'UAVOSH' => 'Shatskyi',
		'UAVOST' => 'Starovyzhivskyi',
		'UAVOTU' => 'Turiiskyi',
		'UAVOVM' => 'Volodymyr-Volynska',
		'UAVOVR' => 'Volodymyr-Volynskyi',
	],
	'UAZK' => [
		'UAZKBM' => 'Berehivska',
		'UAZKBR' => 'Berehivskyi',
		'UAZKCH' => 'Chopska',
		'UAZKIR' => 'Irshavskyi',
		'UAZKKM' => 'Khustska',
		'UAZKKR' => 'Khustskyi',
		'UAZKMI' => 'Mizhhirskyi',
		'UAZKMM' => 'Mukachivska',
		'UAZKMR' => 'Mukachivskyi',
		'UAZKPE' => 'Perechynskyi',
		'UAZKRA' => 'Rakhivskyi',
		'UAZKSV' => 'Svaliavskyi',
		'UAZKTI' => 'Tiachivskyi',
		'UAZKUM' => 'Uzhhorodska',
		'UAZKUR' => 'Uzhhorodskyi',
		'UAZKVE' => 'Velykobereznianskyi',
		'UAZKVO' => 'Volovetskyi',
		'UAZKVY' => 'Vynohradivskyi',
	],
	'UAZP' => [
		'UAZPBM' => 'Berdianska',
		'UAZPBR' => 'Berdianskyi',
		'UAZPCH' => 'Chernihivskyi',
		'UAZPEN' => 'Enerhodarska',
		'UAZPHU' => 'Huliaipilskyi',
		'UAZPIA' => 'Iakymivskyi',
		'UAZPKA' => 'Kamiansko-Dniprovskyi',
		'UAZPKU' => 'Kuibyshevskyi',
		'UAZPMM' => 'Melitopolska',
		'UAZPMR' => 'Melitopolskyi',
		'UAZPMY' => 'Mykhailivskyi',
		'UAZPNO' => 'Novomykolaïvskyi',
		'UAZPOR' => 'Orikhivskyi',
		'UAZPPM' => 'Prymorskyi',
		'UAZPPO' => 'Polohivskyi',
		'UAZPPZ' => 'Pryazovskyi',
		'UAZPRO' => 'Rozivskyi',
		'UAZPTM' => 'Tokmatska',
		'UAZPTR' => 'Tokmatskyi',
		'UAZPVA' => 'Vasylivskyi',
		'UAZPVB' => 'Velykobilozerskyi',
		'UAZPVI' => 'Vilnianskyi',
		'UAZPVS' => 'Veselivskyi',
		'UAZPZM' => 'Zaporizka',
		'UAZPZR' => 'Zaporizkyi',
	],
	'UAZT' => [
		'UAZTAN' => 'Andrushivskyi',
		'UAZTBA' => 'Baranivskyi',
		'UAZTBM' => 'Berdychivska',
		'UAZTBR' => 'Berdychivskyi',
		'UAZTBS' => 'Brusylivskyi',
		'UAZTCA' => 'Chervonoarmiiskyi',
		'UAZTCD' => 'Chudnivskyi',
		'UAZTCK' => 'Cherniakhivskyi',
		'UAZTIE' => 'Iemilchynskyi',
		'UAZTKM' => 'Korostenska',
		'UAZTKR' => 'Korostenskyi',
		'UAZTKS' => 'Korostyshivskyi',
		'UAZTLI' => 'Liubarskyi',
		'UAZTLU' => 'Luhynskyi',
		'UAZTMA' => 'Malynskyi',
		'UAZTNA' => 'Narodytskyi',
		'UAZTNM' => 'Novohrad-Volynska',
		'UAZTNR' => 'Novohrad-Volynskyi',
		'UAZTOL' => 'Olevskyi',
		'UAZTOV' => 'Ovrutskyi',
		'UAZTPO' => 'Popilnianskyi',
		'UAZTRA' => 'Radomyshlskyi',
		'UAZTRO' => 'Romanivskyi',
		'UAZTRU' => 'Ruzhynskyi',
		'UAZTVO' => 'Volodarsko-Volynskyi',
		'UAZTZM' => 'Zhytomyrska',
		'UAZTZR' => 'Zhytomyrskyi',
	]
];
