<?php

/**
 * List of cities for: Portugal
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'PT010103' => 'Aguada de Cima',
	'PT010109' => 'Fermentelos',
	'PT010112' => 'Macinhata do Vouga',
	'PT010119' => 'Valongo do Vouga',
	'PT010121' => 'Águeda e Borralha',
	'PT010122' => 'Barrô e Aguada de Baixo',
	'PT010123' => 'Belazaima do Chão, Castanheira do Vouga e Agadão',
	'PT010124' => 'Recardães e Espinhel',
	'PT010125' => 'Travassô e Óis da Ribeira',
	'PT010126' => 'Trofa, Segadães e Lamas do Vouga',
	'PT010127' => 'União das freguesias do Préstimo e Macieira de Alcoba',
	'PT010202' => 'Alquerubim',
	'PT010203' => 'Angeja',
	'PT010204' => 'Branca',
	'PT010206' => 'Ribeira de Fráguas',
	'PT010209' => 'Albergaria-a-Velha e Valmaior',
	'PT010210' => 'São João de Loure e Frossos',
	'PT010304' => 'Avelãs de Caminho',
	'PT010305' => 'Avelãs de Cima',
	'PT010307' => 'Moita',
	'PT010309' => 'Sangalhos',
	'PT010310' => 'São Lourenço do Bairro',
	'PT010312' => 'Vila Nova de Monsarros',
	'PT010313' => 'Vilarinho do Bairro',
	'PT010316' => 'Amoreira da Gândara, Paredes do Bairro e Ancas',
	'PT010317' => 'Arcos e Mogofores',
	'PT010318' => 'Tamengos, Aguim e Óis do Bairro',
	'PT010402' => 'Alvarenga',
	'PT010407' => 'Chave',
	'PT010409' => 'Escariz',
	'PT010411' => 'Fermedo',
	'PT010413' => 'Mansores',
	'PT010414' => 'Moldes',
	'PT010415' => 'Rossas',
	'PT010416' => 'Santa Eulália',
	'PT010417' => 'São Miguel do Mato',
	'PT010418' => 'Tropeço',
	'PT010419' => 'Urrô',
	'PT010420' => 'Várzea',
	'PT010421' => 'Arouca e Burgo',
	'PT010422' => 'Cabreiros e Albergaria da Serra',
	'PT010423' => 'Canelas e Espiunca',
	'PT010424' => 'Covelo de Paivó e Janarde',
	'PT010501' => 'Aradas',
	'PT010502' => 'Cacia',
	'PT010505' => 'Esgueira',
	'PT010508' => 'Oliveirinha',
	'PT010510' => 'São Bernardo',
	'PT010511' => 'São Jacinto',
	'PT010513' => 'Santa Joana',
	'PT010515' => 'Eixo e Eirol',
	'PT010516' => 'Requeixo, Nossa Senhora de Fátima e Nariz',
	'PT010517' => 'Glória e Vera Cruz',
	'PT010602' => 'Fornos',
	'PT010606' => 'Real',
	'PT010607' => 'Santa Maria de Sardoura',
	'PT010608' => 'São Martinho de Sardoura',
	'PT010610' => 'Raiva, Pedorido e Paraíso',
	'PT010611' => 'Sobrado e Bairros',
	'PT010702' => 'Espinho',
	'PT010704' => 'Paramos',
	'PT010705' => 'Silvalde',
	'PT010706' => 'Anta e Guetim',
	'PT010801' => 'Avanca',
	'PT010805' => 'Pardilhó',
	'PT010806' => 'Salreu',
	'PT010808' => 'Beduído e Veiros',
	'PT010809' => 'Canelas e Fermelã',
	'PT010901' => 'Argoncilhe',
	'PT010902' => 'Arrifana',
	'PT010904' => 'Escapães',
	'PT010907' => 'Fiães',
	'PT010908' => 'Fornos',
	'PT010913' => 'Lourosa',
	'PT010914' => 'Milheirós de Poiares',
	'PT010916' => 'Mozelos',
	'PT010917' => 'Nogueira da Regedoura',
	'PT010918' => 'São Paio de Oleiros',
	'PT010919' => 'Paços de Brandão',
	'PT010921' => 'Rio Meão',
	'PT010922' => 'Romariz',
	'PT010924' => 'Sanguedo',
	'PT010925' => 'Santa Maria de Lamas',
	'PT010926' => 'São João de Ver',
	'PT010932' => 'Caldas de São Jorge e Pigeiros',
	'PT010933' => 'Canedo, Vale e Vila Maior',
	'PT010934' => 'Lobão, Gião, Louredo e Guisande',
	'PT010935' => 'Santa Maria da Feira, Travanca, Sanfins e Espargo',
	'PT010936' => 'São Miguel do Souto e Mosteirô',
	'PT011005' => 'Gafanha da Encarnação',
	'PT011006' => 'Gafanha da Nazaré',
	'PT011007' => 'Gafanha do Carmo',
	'PT011008' => 'Ílhavo (São Salvador)',
	'PT011102' => 'Barcouço',
	'PT011103' => 'Casal Comba',
	'PT011104' => 'Luso',
	'PT011106' => 'Pampilhosa',
	'PT011107' => 'Vacariça',
	'PT011109' => 'União das freguesias da Mealhada, Ventosa do Bairro e Antes',
	'PT011201' => 'Bunheiro',
	'PT011202' => 'Monte',
	'PT011203' => 'Murtosa',
	'PT011204' => 'Torreira',
	'PT011301' => 'Carregosa',
	'PT011302' => 'Cesar',
	'PT011303' => 'Fajões',
	'PT011304' => 'Loureiro',
	'PT011305' => 'Macieira de Sarnes',
	'PT011310' => 'Ossela',
	'PT011315' => 'São Martinho da Gândara',
	'PT011318' => 'São Roque',
	'PT011319' => 'Vila de Cucujães',
	'PT011320' => 'Nogueira do Cravo e Pindelo',
	'PT011321' => 'Oliveira de Azeméis, Santiago de Riba-Ul, Ul, Macinhata da Seixa e Madail',
	'PT011322' => 'Pinheiro da Bemposta, Travanca e Palmaz',
	'PT011403' => 'Oiã',
	'PT011404' => 'Oliveira do Bairro',
	'PT011405' => 'Palhaça',
	'PT011407' => 'Bustos, Troviscal e Mamarrosa',
	'PT011502' => 'Cortegaça',
	'PT011503' => 'Esmoriz',
	'PT011504' => 'Maceda',
	'PT011507' => 'Válega',
	'PT011509' => 'Ovar, São João, Arada e São Vicente de Pereira Jusã',
	'PT011601' => 'São João da Madeira',
	'PT011702' => 'Couto de Esteves',
	'PT011704' => 'Pessegueiro do Vouga',
	'PT011705' => 'Rocas do Vouga',
	'PT011706' => 'Sever do Vouga',
	'PT011708' => 'Talhadas',
	'PT011710' => 'Cedrim e Paradela',
	'PT011711' => 'Silva Escura e Dornelas',
	'PT011801' => 'Calvão',
	'PT011804' => 'Gafanha da Boa Hora',
	'PT011805' => 'Ouca',
	'PT011807' => 'Sosa',
	'PT011810' => 'Santo André de Vagos',
	'PT011812' => 'Fonte de Angeão e Covão do Lobo',
	'PT011813' => 'Ponte de Vagos e Santa Catarina',
	'PT011814' => 'Vagos e Santo António',
	'PT011901' => 'Arões',
	'PT011902' => 'São Pedro de Castelões',
	'PT011903' => 'Cepelos',
	'PT011905' => 'Junqueira',
	'PT011906' => 'Macieira de Cambra',
	'PT011907' => 'Roge',
	'PT011910' => 'Vila Chã, Codal e Vila Cova de Perrinho',
	'PT020102' => 'Ervidel',
	'PT020103' => 'Messejana',
	'PT020104' => 'São João de Negrilhos',
	'PT020106' => 'Aljustrel e Rio de Moinhos',
	'PT020203' => 'Rosário',
	'PT020205' => 'Santa Cruz',
	'PT020206' => 'São Barnabé',
	'PT020208' => 'Aldeia dos Fernandes',
	'PT020209' => 'Almodôvar e Graça dos Padrões',
	'PT020210' => 'Santa Clara-a-Nova e Gomes Aires',
	'PT020301' => 'Alvito',
	'PT020302' => 'Vila Nova da Baronia',
	'PT020401' => 'Barrancos',
	'PT020502' => 'Baleizão',
	'PT020503' => 'Beringel',
	'PT020504' => 'Cabeça Gorda',
	'PT020506' => 'Nossa Senhora das Neves',
	'PT020510' => 'Santa Clara de Louredo',
	'PT020516' => 'São Matias',
	'PT020519' => 'Albernoa e Trindade',
	'PT020520' => 'Beja (Salvador e Santa Maria da Feira)',
	'PT020521' => 'Beja (Santiago Maior e São João Baptista)',
	'PT020522' => 'Salvada e Quintos',
	'PT020523' => 'Santa Vitória e Mombeja',
	'PT020524' => 'Trigaches e São Brissos',
	'PT020603' => 'Entradas',
	'PT020604' => 'Santa Bárbara de Padrões',
	'PT020605' => 'São Marcos da Ataboeira',
	'PT020606' => 'Castro Verde e Casével',
	'PT020701' => 'Cuba',
	'PT020702' => 'Faro do Alentejo',
	'PT020703' => 'Vila Alva',
	'PT020704' => 'Vila Ruiva',
	'PT020803' => 'Figueira dos Cavaleiros',
	'PT020804' => 'Odivelas',
	'PT020807' => 'Alfundão e Peroguarda',
	'PT020808' => 'Ferreira do Alentejo e Canhestros',
	'PT020901' => 'Alcaria Ruiva',
	'PT020902' => 'Corte do Pinto',
	'PT020903' => 'Espírito Santo',
	'PT020904' => 'Mértola',
	'PT020905' => 'Santana de Cambas',
	'PT020906' => 'São João dos Caldeireiros',
	'PT020910' => 'São Miguel do Pinheiro, São Pedro de Solis e São Sebastião dos Carros',
	'PT021001' => 'Amareleja',
	'PT021002' => 'Póvoa de São Miguel',
	'PT021008' => 'Sobral da Adiça',
	'PT021009' => 'Moura (Santo Agostinho e São João Baptista) e Santo Amador',
	'PT021010' => 'Safara e Santo Aleixo da Restauração',
	'PT021102' => 'Relíquias',
	'PT021103' => 'Sabóia',
	'PT021106' => 'São Luís',
	'PT021107' => 'São Martinho das Amoreiras',
	'PT021111' => 'Vila Nova de Milfontes',
	'PT021115' => 'Luzianes-Gare',
	'PT021116' => 'Boavista dos Pinheiros',
	'PT021117' => 'Longueira/Almograve',
	'PT021118' => 'Colos',
	'PT021119' => 'Santa Clara-a-Velha',
	'PT021120' => 'São Salvador e Santa Maria',
	'PT021121' => 'São Teotónio',
	'PT021122' => 'Vale de Santiago',
	'PT021203' => 'Ourique',
	'PT021206' => 'Santana da Serra',
	'PT021207' => 'Garvão e Santa Luzia',
	'PT021208' => 'Panoias e Conceição',
	'PT021302' => 'Brinches',
	'PT021303' => 'Pias',
	'PT021307' => 'Vila Verde de Ficalho',
	'PT021308' => 'Serpa (Salvador e Santa Maria)',
	'PT021309' => 'Vila Nova de São Bento e Vale de Vargo',
	'PT021401' => 'Pedrógão',
	'PT021402' => 'Selmes',
	'PT021403' => 'Vidigueira',
	'PT021404' => 'Vila de Frades',
	'PT030102' => 'Barreiros',
	'PT030104' => 'Bico',
	'PT030105' => 'Caires',
	'PT030107' => 'Carrazedo',
	'PT030108' => 'Dornelas',
	'PT030111' => 'Fiscal',
	'PT030112' => 'Goães',
	'PT030113' => 'Lago',
	'PT030118' => 'Rendufe',
	'PT030119' => 'Bouro (Santa Maria)',
	'PT030120' => 'Bouro (Santa Marta)',
	'PT030125' => 'Amares e Figueiredo',
	'PT030126' => 'Caldelas, Sequeiros e Paranhos',
	'PT030127' => 'Ferreiros, Prozelo e Besteiros',
	'PT030128' => 'Torre e Portela',
	'PT030129' => 'Vilela, Seramil e Paredes Secas',
	'PT030201' => 'Abade de Neiva',
	'PT030202' => 'Aborim',
	'PT030203' => 'Adães',
	'PT030205' => 'Airó',
	'PT030206' => 'Aldreu',
	'PT030208' => 'Alvelos',
	'PT030209' => 'Arcozelo',
	'PT030210' => 'Areias',
	'PT030212' => 'Balugães',
	'PT030213' => 'Barcelinhos',
	'PT030215' => 'Barqueiros',
	'PT030216' => 'Cambeses',
	'PT030218' => 'Carapeços',
	'PT030220' => 'Carvalhal',
	'PT030221' => 'Carvalhas',
	'PT030224' => 'Cossourado',
	'PT030228' => 'Cristelo',
	'PT030234' => 'Fornelos',
	'PT030235' => 'Fragoso',
	'PT030237' => 'Gilmonde',
	'PT030242' => 'Lama',
	'PT030243' => 'Lijó',
	'PT030244' => 'Macieira de Rates',
	'PT030245' => 'Manhente',
	'PT030247' => 'Martim',
	'PT030252' => 'Moure',
	'PT030254' => 'Oliveira',
	'PT030255' => 'Palme',
	'PT030256' => 'Panque',
	'PT030257' => 'Paradela',
	'PT030259' => 'Pereira',
	'PT030260' => 'Perelhal',
	'PT030261' => 'Pousa',
	'PT030263' => 'Remelhe',
	'PT030264' => 'Roriz',
	'PT030265' => 'Rio Covo (Santa Eugénia)',
	'PT030268' => 'Galegos (Santa Maria)',
	'PT030272' => 'Galegos (São Martinho)',
	'PT030277' => 'Tamel (São Veríssimo)',
	'PT030279' => 'Silva',
	'PT030282' => 'Ucha',
	'PT030283' => 'Várzea',
	'PT030287' => 'Vila Seca',
	'PT030290' => 'Alheira e Igreja Nova',
	'PT030291' => 'Alvito (São Pedro e São Martinho) e Couto',
	'PT030292' => 'Areias de Vilar e Encourados',
	'PT030293' => 'Barcelos, Vila Boa e Vila Frescainha (São Martinho e São Pedro)',
	'PT030294' => 'Campo e Tamel (São Pedro Fins)',
	'PT030295' => 'Carreira e Fonte Coberta',
	'PT030296' => 'Chorente, Góios, Courel, Pedra Furada e Gueral',
	'PT030297' => 'Creixomil e Mariz',
	'PT030298' => 'Durrães e Tregosa',
	'PT030299' => 'Gamil e Midões',
	'PT0302FA' => 'Milhazes, Vilar de Figos e Faria',
	'PT0302FB' => 'Negreiros e Chavão',
	'PT0302FC' => 'Quintiães e Aguiar',
	'PT0302FD' => 'Sequeade e Bastuço (São João e Santo Estevão)',
	'PT0302FE' => 'Silveiros e Rio Covo (Santa Eulália)',
	'PT0302FF' => 'Tamel (Santa Leocádia) e Vilar do Monte',
	'PT0302FG' => 'Viatodos, Grimancelos, Minhotães e Monte de Fralães',
	'PT0302FH' => 'Vila Cova e Feitos',
	'PT030301' => 'Adaúfe',
	'PT030312' => 'Espinho',
	'PT030313' => 'Esporões',
	'PT030315' => 'Figueiredo',
	'PT030319' => 'Gualtar',
	'PT030322' => 'Lamas',
	'PT030325' => 'Mire de Tibães',
	'PT030330' => 'Padim da Graça',
	'PT030331' => 'Palmeira',
	'PT030334' => 'Pedralva',
	'PT030336' => 'Priscos',
	'PT030338' => 'Ruilhe',
	'PT030349' => 'Braga (São Vicente)',
	'PT030351' => 'Braga (São Vítor)',
	'PT030354' => 'Sequeira',
	'PT030355' => 'Sobreposta',
	'PT030356' => 'Tadim',
	'PT030357' => 'Tebosa',
	'PT030363' => 'Arentim e Cunha',
	'PT030364' => 'Braga (Maximinos, Sé e Cividade)',
	'PT030365' => 'Braga (São José de São Lázaro e São João do Souto)',
	'PT030366' => 'Cabreiros e Passos (São Julião)',
	'PT030367' => 'Celeirós, Aveleda e Vimieiro',
	'PT030368' => 'Crespos e Pousada',
	'PT030369' => 'Escudeiros e Penso (Santo Estêvão e São Vicente)',
	'PT030370' => 'Este (São Pedro e São Mamede)',
	'PT030371' => 'Ferreiros e Gondizalves',
	'PT030372' => 'Guisande e Oliveira (São Pedro)',
	'PT030373' => 'Lomar e Arcos',
	'PT030374' => 'Merelim (São Paio), Panoias e Parada de Tibães',
	'PT030375' => 'Merelim (São Pedro) e Frossos',
	'PT030376' => 'Morreira e Trandeiras',
	'PT030377' => 'Nogueira, Fraião e Lamaçães',
	'PT030378' => 'Nogueiró e Tenões',
	'PT030379' => 'Real, Dume e Semelhe',
	'PT030380' => 'Santa Lucrécia de Algeriz e Navarra',
	'PT030381' => 'Vilaça e Fradelos',
	'PT030401' => 'Abadim',
	'PT030404' => 'Basto',
	'PT030405' => 'Bucos',
	'PT030406' => 'Cabeceiras de Basto',
	'PT030407' => 'Cavez',
	'PT030408' => 'Faia',
	'PT030413' => 'Pedraça',
	'PT030415' => 'Rio Douro',
	'PT030418' => 'Alvite e Passos',
	'PT030419' => 'Arco de Baúlhe e Vila Nune',
	'PT030420' => 'Gondiães e Vilar de Cunhas',
	'PT030421' => 'Refojos de Basto, Outeiro e Painzela',
	'PT030501' => 'Agilde',
	'PT030502' => 'Arnóia',
	'PT030503' => 'Borba de Montanha',
	'PT030508' => 'Codeçoso',
	'PT030510' => 'Fervença',
	'PT030515' => 'Moreira do Castelo',
	'PT030517' => 'Rego',
	'PT030518' => 'Ribas',
	'PT030520' => 'Basto (São Clemente)',
	'PT030521' => 'Vale de Bouro',
	'PT030523' => 'Britelo, Gémeos e Ourilhe',
	'PT030524' => 'Caçarilhe e Infesta',
	'PT030525' => 'Canedo de Basto e Corgo',
	'PT030526' => 'Carvalho e Basto (Santa Tecla)',
	'PT030527' => 'Veade, Gagos e Molares',
	'PT030601' => 'Antas',
	'PT030608' => 'Forjães',
	'PT030610' => 'Gemeses',
	'PT030615' => 'Vila Chã',
	'PT030616' => 'Apúlia e Fão',
	'PT030617' => 'Belinho e Mar',
	'PT030618' => 'Esposende, Marinhas e Gandra',
	'PT030619' => 'Fonte Boa e Rio Tinto',
	'PT030620' => 'Palmeira de Faro e Curvos',
	'PT030705' => 'Armil',
	'PT030708' => 'Estorãos',
	'PT030709' => 'Fafe',
	'PT030712' => 'Fornelos',
	'PT030714' => 'Golães',
	'PT030716' => 'Medelo',
	'PT030719' => 'Passos',
	'PT030722' => 'Quinchães',
	'PT030723' => 'Regadas',
	'PT030724' => 'Revelhe',
	'PT030725' => 'Ribeiros',
	'PT030726' => 'Arões (Santa Cristina)',
	'PT030728' => 'São Gens',
	'PT030729' => 'Silvares (São Martinho)',
	'PT030730' => 'Arões (São Romão)',
	'PT030733' => 'Travassós',
	'PT030736' => 'Vinhós',
	'PT030737' => 'União de freguesias de Aboim, Felgueiras, Gontim e Pedraído',
	'PT030738' => 'União de freguesias de Agrela e Serafão',
	'PT030739' => 'União de freguesias de Antime e Silvares (São Clemente)',
	'PT030740' => 'União de freguesias de Ardegão, Arnozela e Seidões',
	'PT030741' => 'União de freguesias de Cepães e Fareja',
	'PT030742' => 'União de freguesias de Freitas e Vila Cova',
	'PT030743' => 'União de freguesias de Monte e Queimadela',
	'PT030744' => 'União de freguesias de Moreira do Rei e Várzea Cova',
	'PT030801' => 'Aldão',
	'PT030804' => 'Azurém',
	'PT030806' => 'Barco',
	'PT030807' => 'Brito',
	'PT030808' => 'Caldelas',
	'PT030812' => 'Costa',
	'PT030813' => 'Creixomil',
	'PT030815' => 'Fermentões',
	'PT030820' => 'Gonça',
	'PT030821' => 'Gondar',
	'PT030823' => 'Guardizela',
	'PT030824' => 'Infantas',
	'PT030827' => 'Longos',
	'PT030828' => 'Lordelo',
	'PT030830' => 'Mesão Frio',
	'PT030831' => 'Moreira de Cónegos',
	'PT030832' => 'Nespereira',
	'PT030835' => 'Pencelo',
	'PT030836' => 'Pinheiro',
	'PT030837' => 'Polvoreira',
	'PT030838' => 'Ponte',
	'PT030840' => 'Ronfe',
	'PT030842' => 'Prazins (Santa Eufémia)',
	'PT030850' => 'Selho (São Cristóvão)',
	'PT030854' => 'Selho (São Jorge)',
	'PT030857' => 'Candoso (São Martinho)',
	'PT030858' => 'Sande (São Martinho)',
	'PT030865' => 'São Torcato',
	'PT030866' => 'Serzedelo',
	'PT030868' => 'Silvares',
	'PT030871' => 'Urgezes',
	'PT030875' => 'Abação e Gémeos',
	'PT030876' => 'Airão Santa Maria, Airão São João e Vermil',
	'PT030877' => 'Arosa e Castelões',
	'PT030878' => 'Atães e Rendufe',
	'PT030879' => 'Briteiros Santo Estêvão e Donim',
	'PT030880' => 'Briteiros São Salvador e Briteiros Santa Leocádia',
	'PT030881' => 'Candoso São Tiago e Mascotelos',
	'PT030882' => 'Conde e Gandarela',
	'PT030883' => 'Leitões, Oleiros e Figueiredo',
	'PT030884' => 'Oliveira, São Paio e São Sebastião',
	'PT030885' => 'Prazins Santo Tirso e Corvite',
	'PT030886' => 'Sande São Lourenço e Balazar',
	'PT030887' => 'Sande Vila Nova e Sande São Clemente',
	'PT030888' => 'Selho São Lourenço e Gominhães',
	'PT030889' => 'Serzedo e Calvos',
	'PT030890' => 'Souto Santa Maria, Souto São Salvador e Gondomar',
	'PT030891' => 'Tabuadelo e São Faustino',
	'PT030906' => 'Covelas',
	'PT030908' => 'Ferreiros',
	'PT030912' => 'Galegos',
	'PT030913' => 'Garfe',
	'PT030914' => 'Geraz do Minho',
	'PT030915' => 'Lanhoso',
	'PT030917' => 'Monsul',
	'PT030919' => 'Póvoa de Lanhoso (Nossa Senhora do Amparo)',
	'PT030921' => 'Rendufinho',
	'PT030922' => 'Santo Emilião',
	'PT030923' => 'São João de Rei',
	'PT030924' => 'Serzedelo',
	'PT030925' => 'Sobradelo da Goma',
	'PT030926' => 'Taíde',
	'PT030927' => 'Travassos',
	'PT030929' => 'Vilela',
	'PT030930' => 'Águas Santas e Moure',
	'PT030931' => 'Calvos e Frades',
	'PT030932' => 'Campos e Louredo',
	'PT030933' => 'Esperança e Brunhais',
	'PT030934' => 'Fonte Arcada e Oliveira',
	'PT030935' => 'Verim, Friande e Ajude',
	'PT031001' => 'Balança',
	'PT031003' => 'Campo do Gerês',
	'PT031004' => 'Carvalheira',
	'PT031008' => 'Covide',
	'PT031009' => 'Gondoriz',
	'PT031010' => 'Moimenta',
	'PT031012' => 'Ribeira',
	'PT031013' => 'Rio Caldo',
	'PT031014' => 'Souto',
	'PT031015' => 'Valdosende',
	'PT031017' => 'Vilar da Veiga',
	'PT031018' => 'Chamoim e Vilar',
	'PT031019' => 'Chorense e Monte',
	'PT031020' => 'Cibões e Brufe',
	'PT031105' => 'Cantelães',
	'PT031107' => 'Eira Vedra',
	'PT031108' => 'Guilhofrei',
	'PT031109' => 'Louredo',
	'PT031110' => 'Mosteiro',
	'PT031111' => 'Parada do Bouro',
	'PT031112' => 'Pinheiro',
	'PT031113' => 'Rossas',
	'PT031115' => 'Salamonde',
	'PT031118' => 'Tabuaças',
	'PT031120' => 'Vieira do Minho',
	'PT031122' => 'Anissó e Soutelo',
	'PT031123' => 'Anjos e Vilar do Chão',
	'PT031124' => 'Caniçada e Soengas',
	'PT031125' => 'Ruivães e Campos',
	'PT031126' => 'Ventosa e Cova',
	'PT031204' => 'Bairro',
	'PT031206' => 'Brufe',
	'PT031210' => 'Castelões',
	'PT031212' => 'Cruz',
	'PT031213' => 'Delães',
	'PT031215' => 'Fradelos',
	'PT031216' => 'Gavião',
	'PT031219' => 'Joane',
	'PT031221' => 'Landim',
	'PT031223' => 'Louro',
	'PT031224' => 'Lousado',
	'PT031225' => 'Mogege',
	'PT031227' => 'Nine',
	'PT031230' => 'Pedome',
	'PT031232' => 'Pousada de Saramagos',
	'PT031233' => 'Requião',
	'PT031234' => 'Riba de Ave',
	'PT031235' => 'Ribeirão',
	'PT031239' => 'Oliveira (Santa Maria)',
	'PT031241' => 'Vale (São Martinho)',
	'PT031242' => 'Oliveira (São Mateus)',
	'PT031247' => 'Vermoim',
	'PT031249' => 'Vilarinho das Cambas',
	'PT031250' => 'Antas e Abade de Vermoim',
	'PT031251' => 'Arnoso (Santa Maria e Santa Eulália) e Sezures',
	'PT031252' => 'Avidos e Lagoa',
	'PT031253' => 'Carreira e Bente',
	'PT031254' => 'Esmeriz e Cabeçudos',
	'PT031255' => 'Gondifelos, Cavalões e Outiz',
	'PT031256' => 'Lemenhe, Mouquim e Jesufrei',
	'PT031257' => 'Ruivães e Novais',
	'PT031258' => 'Seide',
	'PT031259' => 'Vale (São Cosme), Telhado e Portela',
	'PT031260' => 'Vila Nova de Famalicão e Calendário',
	'PT031304' => 'Atiães',
	'PT031308' => 'Cabanelas',
	'PT031309' => 'Cervães',
	'PT031311' => 'Coucieiro',
	'PT031313' => 'Dossãos',
	'PT031316' => 'Freiriz',
	'PT031317' => 'Gême',
	'PT031323' => 'Lage',
	'PT031324' => 'Lanhas',
	'PT031325' => 'Loureira',
	'PT031328' => 'Moure',
	'PT031330' => 'Oleiros',
	'PT031331' => 'Parada de Gatim',
	'PT031335' => 'Pico',
	'PT031337' => 'Ponte',
	'PT031340' => 'Sabariz',
	'PT031342' => 'Vila de Prado',
	'PT031350' => 'Prado (São Miguel)',
	'PT031352' => 'Soutelo',
	'PT031354' => 'Turiz',
	'PT031355' => 'Valdreu',
	'PT031359' => 'Aboim da Nóbrega e Gondomar',
	'PT031360' => 'União das freguesias da Ribeira do Neiva',
	'PT031361' => 'Carreiras (São Miguel) e Carreiras (Santiago)',
	'PT031362' => 'Escariz (São Mamede) e Escariz (São Martinho)',
	'PT031363' => 'Esqueiros, Nevogilde e Travassós',
	'PT031364' => 'Marrancos e Arcozelo',
	'PT031365' => 'Oriz (Santa Marinha) e Oriz (São Miguel)',
	'PT031366' => 'Pico de Regalados, Gondiães e Mós',
	'PT031367' => 'Sande, Vilarinho, Barros e Gomide',
	'PT031368' => 'Valbom (São Pedro), Passô e Valbom (São Martinho)',
	'PT031369' => 'União das freguesias do Vade',
	'PT031370' => 'Vila Verde e Barbudo',
	'PT031401' => 'Santa Eulália',
	'PT031404' => 'Infias',
	'PT031406' => 'Vizela (Santo Adrião)',
	'PT031408' => 'Caldas de Vizela (São Miguel e São João)',
	'PT031409' => 'Tagilde e Vizela (São Paio)',
	'PT040102' => 'Alfândega da Fé',
	'PT040103' => 'Cerejais',
	'PT040111' => 'Sambade',
	'PT040118' => 'Vilar Chão',
	'PT040119' => 'Vilarelhos',
	'PT040120' => 'Vilares de Vilariça',
	'PT040121' => 'Agrobom, Saldonha e Vale Pereiro',
	'PT040122' => 'Eucisia, Gouveia e Valverde',
	'PT040123' => 'Ferradosa e Sendim da Serra',
	'PT040124' => 'Gebelim e Soeima',
	'PT040125' => 'Parada e Sendim da Ribeira',
	'PT040126' => 'Pombal e Vales',
	'PT040201' => 'Alfaião',
	'PT040203' => 'Babe',
	'PT040204' => 'Baçal',
	'PT040206' => 'Carragosa',
	'PT040209' => 'Castro de Avelãs',
	'PT040210' => 'Coelhoso',
	'PT040212' => 'Donai',
	'PT040213' => 'Espinhosela',
	'PT040215' => 'França',
	'PT040216' => 'Gimonde',
	'PT040217' => 'Gondesende',
	'PT040218' => 'Gostei',
	'PT040219' => 'Grijó de Parada',
	'PT040221' => 'Macedo do Mato',
	'PT040224' => 'Mós',
	'PT040225' => 'Nogueira',
	'PT040226' => 'Outeiro',
	'PT040229' => 'Parâmio',
	'PT040230' => 'Pinela',
	'PT040232' => 'Quintanilha',
	'PT040233' => 'Quintela de Lampaças',
	'PT040234' => 'Rabal',
	'PT040236' => 'Rebordãos',
	'PT040239' => 'Salsas',
	'PT040240' => 'Samil',
	'PT040241' => 'Santa Comba de Rossas',
	'PT040244' => 'São Pedro de Sarracenos',
	'PT040246' => 'Sendas',
	'PT040247' => 'Serapicos',
	'PT040248' => 'Sortes',
	'PT040249' => 'Zoio',
	'PT040250' => 'Aveleda e Rio de Onor',
	'PT040251' => 'Castrelos e Carrazedo',
	'PT040252' => 'Izeda, Calvelhe e Paradinha Nova',
	'PT040253' => 'Parada e Faílde',
	'PT040254' => 'Rebordainhos e Pombares',
	'PT040255' => 'Rio Frio e Milhão',
	'PT040256' => 'São Julião de Palácios e Deilão',
	'PT040257' => 'Sé, Santa Maria e Meixedo',
	'PT040304' => 'Carrazeda de Ansiães',
	'PT040306' => 'Fonte Longa',
	'PT040308' => 'Linhares',
	'PT040309' => 'Marzagão',
	'PT040311' => 'Parambos',
	'PT040312' => 'Pereiros',
	'PT040313' => 'Pinhal do Norte',
	'PT040314' => 'Pombal',
	'PT040316' => 'Seixo de Ansiães',
	'PT040318' => 'Vilarinho da Castanheira',
	'PT040320' => 'Amedo e Zedes',
	'PT040321' => 'Belver e Mogo de Malta',
	'PT040322' => 'Castanheiro do Norte e Ribalonga',
	'PT040323' => 'Lavandeira, Beira Grande e Selores',
	'PT040404' => 'Ligares',
	'PT040406' => 'Poiares',
	'PT040407' => 'Freixo de Espada à Cinta e Mazouco',
	'PT040408' => 'Lagoaça e Fornos',
	'PT040502' => 'Amendoeira',
	'PT040503' => 'Arcas',
	'PT040507' => 'Carrapatas',
	'PT040509' => 'Chacim',
	'PT040510' => 'Cortiços',
	'PT040511' => 'Corujas',
	'PT040514' => 'Ferreira',
	'PT040515' => 'Grijó',
	'PT040516' => 'Lagoa',
	'PT040517' => 'Lamalonga',
	'PT040518' => 'Lamas',
	'PT040519' => 'Lombo',
	'PT040520' => 'Macedo de Cavaleiros',
	'PT040521' => 'Morais',
	'PT040523' => 'Olmos',
	'PT040524' => 'Peredo',
	'PT040526' => 'Salselas',
	'PT040528' => 'Sezulfe',
	'PT040530' => 'Talhas',
	'PT040532' => 'Vale Benfeito',
	'PT040533' => 'Vale da Porca',
	'PT040534' => 'Vale de Prados',
	'PT040536' => 'Vilarinho de Agrochão',
	'PT040538' => 'Vinhas',
	'PT040539' => 'Ala e Vilarinho do Monte',
	'PT040540' => 'Bornes e Burga',
	'PT040541' => 'Castelãos e Vilar do Monte',
	'PT040542' => 'Espadanedo, Edroso, Murçós e Soutelo Mourisco',
	'PT040543' => 'Podence e Santa Combinha',
	'PT040544' => 'Talhinhas e Bagueixe',
	'PT040604' => 'Duas Igrejas',
	'PT040605' => 'Genísio',
	'PT040607' => 'Malhadas',
	'PT040608' => 'Miranda do Douro',
	'PT040609' => 'Palaçoulo',
	'PT040611' => 'Picote',
	'PT040612' => 'Póvoa',
	'PT040613' => 'São Martinho de Angueira',
	'PT040616' => 'Vila Chã de Braciosa',
	'PT040618' => 'Constantim e Cicouro',
	'PT040619' => 'Ifanes e Paradela',
	'PT040620' => 'Sendim e Atenor',
	'PT040621' => 'Silva e Águas Vivas',
	'PT040701' => 'Abambres',
	'PT040702' => 'Abreiro',
	'PT040703' => 'Aguieiras',
	'PT040704' => 'Alvites',
	'PT040708' => 'Bouça',
	'PT040709' => 'Cabanelas',
	'PT040710' => 'Caravelas',
	'PT040711' => 'Carvalhais',
	'PT040712' => 'Cedães',
	'PT040713' => 'Cobro',
	'PT040714' => 'Fradizela',
	'PT040716' => 'Frechas',
	'PT040718' => 'Lamas de Orelhão',
	'PT040720' => 'Mascarenhas',
	'PT040721' => 'Mirandela',
	'PT040722' => 'Múrias',
	'PT040724' => 'Passos',
	'PT040727' => 'São Pedro Velho',
	'PT040728' => 'São Salvador',
	'PT040729' => 'Suçães',
	'PT040730' => 'Torre de Dona Chama',
	'PT040731' => 'Vale de Asnes',
	'PT040732' => 'Vale de Gouvinhas',
	'PT040733' => 'Vale de Salgueiro',
	'PT040734' => 'Vale de Telhas',
	'PT040738' => 'Avantos e Romeu',
	'PT040739' => 'Avidagos, Navalho e Pereira',
	'PT040740' => 'Barcel, Marmelos e Valverde da Gestosa',
	'PT040741' => 'Franco e Vila Boa',
	'PT040742' => 'Freixeda e Vila Verde',
	'PT040801' => 'Azinhoso',
	'PT040802' => 'Bemposta',
	'PT040803' => 'Bruçó',
	'PT040804' => 'Brunhoso',
	'PT040807' => 'Castelo Branco',
	'PT040808' => 'Castro Vicente',
	'PT040809' => 'Meirinhos',
	'PT040811' => 'Paradela',
	'PT040812' => 'Penas Roias',
	'PT040813' => 'Peredo da Bemposta',
	'PT040815' => 'Saldanha',
	'PT040817' => 'São Martinho do Peso',
	'PT040819' => 'Tó',
	'PT040820' => 'Travanca',
	'PT040821' => 'Urrós',
	'PT040822' => 'Vale da Madre',
	'PT040826' => 'Vila de Ala',
	'PT040829' => 'Brunhozinho, Castanheira e Sanhoane',
	'PT040830' => 'Mogadouro, Valverde, Vale de Porco e Vilar de Rei',
	'PT040831' => 'Remondes e Soutelo',
	'PT040832' => 'Vilarinho dos Galegos e Ventozelo',
	'PT040901' => 'Açoreira',
	'PT040903' => 'Cabeça Boa',
	'PT040905' => 'Carviçais',
	'PT040906' => 'Castedo',
	'PT040909' => 'Horta da Vilariça',
	'PT040910' => 'Larinho',
	'PT040911' => 'Lousa',
	'PT040913' => 'Mós',
	'PT040916' => 'Torre de Moncorvo',
	'PT040918' => 'Adeganha e Cardanha',
	'PT040919' => 'Felgar e Souto da Velha',
	'PT040920' => 'Felgueiras e Maçores',
	'PT040921' => 'Urros e Peredo dos Castelhanos',
	'PT041002' => 'Benlhevai',
	'PT041005' => 'Freixiel',
	'PT041009' => 'Roios',
	'PT041010' => 'Samões',
	'PT041011' => 'Sampaio',
	'PT041012' => 'Santa Comba de Vilariça',
	'PT041013' => 'Seixo de Manhoses',
	'PT041014' => 'Trindade',
	'PT041015' => 'Vale Frechoso',
	'PT041020' => 'Assares e Lodões',
	'PT041021' => 'Candoso e Carvalho de Egas',
	'PT041022' => 'Valtorno e Mourão',
	'PT041023' => 'Vila Flor e Nabo',
	'PT041024' => 'Vilas Boas e Vilarinho das Azenhas',
	'PT041103' => 'Argozelo',
	'PT041107' => 'Carção',
	'PT041108' => 'Matela',
	'PT041109' => 'Pinelo',
	'PT041110' => 'Santulhão',
	'PT041113' => 'Vilar Seco',
	'PT041114' => 'Vimioso',
	'PT041115' => 'Algoso, Campo de Víboras e Uva',
	'PT041116' => 'Caçarelhos e Angueira',
	'PT041117' => 'Vale de Frades e Avelanoso',
	'PT041201' => 'Agrochão',
	'PT041203' => 'Candedo',
	'PT041204' => 'Celas',
	'PT041206' => 'Edral',
	'PT041207' => 'Edrosa',
	'PT041208' => 'Ervedosa',
	'PT041215' => 'Paçó',
	'PT041216' => 'Penhas Juntas',
	'PT041219' => 'Rebordelo',
	'PT041221' => 'Santalha',
	'PT041226' => 'Tuizelo',
	'PT041227' => 'Vale das Fontes',
	'PT041229' => 'Vila Boa de Ousilhão',
	'PT041230' => 'Vila Verde',
	'PT041232' => 'Vilar de Ossos',
	'PT041233' => 'Vilar de Peregrinos',
	'PT041234' => 'Vilar Seco de Lomba',
	'PT041235' => 'Vinhais',
	'PT041236' => 'Curopos e Vale de Janeiro',
	'PT041237' => 'Moimenta e Montouto',
	'PT041238' => 'Nunes e Ousilhão',
	'PT041239' => 'Quirás e Pinheiro Novo',
	'PT041240' => 'Sobreiro de Baixo e Alvaredos',
	'PT041241' => 'Soeira, Fresulfe e Mofreita',
	'PT041242' => 'Travanca e Santa Cruz',
	'PT041243' => 'Vilar de Lomba e São Jomil',
	'PT050102' => 'Caria',
	'PT050104' => 'Inguias',
	'PT050105' => 'Maçainhas',
	'PT050106' => 'Belmonte e Colmeal da Torre',
	'PT050201' => 'Alcains',
	'PT050202' => 'Almaceda',
	'PT050203' => 'Benquerenças',
	'PT050205' => 'Castelo Branco',
	'PT050211' => 'Lardosa',
	'PT050212' => 'Louriçal do Campo',
	'PT050214' => 'Malpica do Tejo',
	'PT050216' => 'Monforte da Beira',
	'PT050220' => 'Salgueiro do Campo',
	'PT050221' => 'Santo André das Tojeiras',
	'PT050222' => 'São Vicente da Beira',
	'PT050223' => 'Sarzedas',
	'PT050225' => 'Tinalhas',
	'PT050226' => 'Cebolais de Cima e Retaxo',
	'PT050227' => 'Escalos de Baixo e Mata',
	'PT050228' => 'Escalos de Cima e Lousa',
	'PT050229' => 'Freixial e Juncal do Campo',
	'PT050230' => 'Ninho do Açor e Sobral do Campo',
	'PT050231' => 'Póvoa de Rio de Moinhos e Cafede',
	'PT050302' => 'Aldeia de São Francisco de Assis',
	'PT050305' => 'Boidobra',
	'PT050308' => 'Cortes do Meio',
	'PT050309' => 'Dominguizo',
	'PT050310' => 'Erada',
	'PT050311' => 'Ferro',
	'PT050312' => 'Orjais',
	'PT050314' => 'Paul',
	'PT050315' => 'Peraboa',
	'PT050318' => 'São Jorge da Beira',
	'PT050322' => 'Sobral de São Miguel',
	'PT050324' => 'Tortosendo',
	'PT050325' => 'Unhais da Serra',
	'PT050327' => 'Verdelhos',
	'PT050332' => 'Barco e Coutada',
	'PT050333' => 'Cantar-Galo e Vila do Carvalho',
	'PT050334' => 'Casegas e Ourondo',
	'PT050335' => 'Covilhã e Canhoso',
	'PT050336' => 'Peso e Vales do Rio',
	'PT050337' => 'Teixoso e Sarzedo',
	'PT050338' => 'Vale Formoso e Aldeia do Souto',
	'PT050401' => 'Alcaide',
	'PT050402' => 'Alcaria',
	'PT050403' => 'Alcongosta',
	'PT050406' => 'Alpedrinha',
	'PT050408' => 'Barroca',
	'PT050410' => 'Bogas de Cima',
	'PT050411' => 'Capinha',
	'PT050412' => 'Castelejo',
	'PT050413' => 'Castelo Novo',
	'PT050416' => 'Fatela',
	'PT050419' => 'Lavacolhos',
	'PT050420' => 'Orca',
	'PT050421' => 'Pêro Viseu',
	'PT050424' => 'Silvares',
	'PT050425' => 'Soalheira',
	'PT050426' => 'Souto da Casa',
	'PT050427' => 'Telhado',
	'PT050431' => 'Enxames',
	'PT050432' => 'Três Povos',
	'PT050433' => 'Janeiro de Cima e Bogas de Baixo',
	'PT050434' => 'Fundão, Valverde, Donas, Aldeia de Joanes e Aldeia Nova do Cabo',
	'PT050435' => 'Póvoa de Atalaia e Atalaia do Campo',
	'PT050436' => 'Vale de Prazeres e Mata da Rainha',
	'PT050502' => 'Aldeia de Santa Margarida',
	'PT050505' => 'Ladoeiro',
	'PT050506' => 'Medelim',
	'PT050509' => 'Oledo',
	'PT050510' => 'Penha Garcia',
	'PT050511' => 'Proença-a-Velha',
	'PT050512' => 'Rosmaninhal',
	'PT050514' => 'São Miguel de Acha',
	'PT050516' => 'Toulões',
	'PT050518' => 'Idanha-a-Nova e Alcafozes',
	'PT050519' => 'Monfortinho e Salvaterra do Extremo',
	'PT050520' => 'Monsanto e Idanha-a-Velha',
	'PT050521' => 'Zebreira e Segura',
	'PT050601' => 'Álvaro',
	'PT050603' => 'Cambas',
	'PT050605' => 'Isna',
	'PT050606' => 'Madeirã',
	'PT050607' => 'Mosteiro',
	'PT050609' => 'Orvalho',
	'PT050610' => 'Sarnadas de São Simão',
	'PT050611' => 'Sobral',
	'PT050613' => 'Estreito-Vilar Barroco',
	'PT050614' => 'Oleiros-Amieira',
	'PT050704' => 'Aranhas',
	'PT050706' => 'Benquerença',
	'PT050707' => 'Meimão',
	'PT050708' => 'Meimoa',
	'PT050710' => 'Penamacor',
	'PT050711' => 'Salvador',
	'PT050712' => 'Vale da Senhora da Póvoa',
	'PT050713' => 'Aldeia do Bispo, Águas e Aldeia de João Pires',
	'PT050714' => 'Pedrógão de São Pedro e Bemposta',
	'PT050802' => 'Montes da Senhora',
	'PT050805' => 'São Pedro do Esteval',
	'PT050807' => 'Proença-a-Nova e Peral',
	'PT050808' => 'Sobreira Formosa e Alvito da Beira',
	'PT050901' => 'Cabeçudo',
	'PT050902' => 'Carvalhal',
	'PT050903' => 'Castelo',
	'PT050911' => 'Pedrógão Pequeno',
	'PT050912' => 'Sertã',
	'PT050913' => 'Troviscal',
	'PT050914' => 'Várzea dos Cavaleiros',
	'PT050915' => 'Cernache do Bonjardim, Nesperal e Palhais',
	'PT050916' => 'Cumeada e Marmeleiro',
	'PT050917' => 'Ermida e Figueiredo',
	'PT051001' => 'Fundada',
	'PT051002' => 'São João do Peso',
	'PT051003' => 'Vila de Rei',
	'PT051101' => 'Fratel',
	'PT051102' => 'Perais',
	'PT051103' => 'Sarnadas de Ródão',
	'PT051104' => 'Vila Velha de Ródão',
	'PT060102' => 'Arganil',
	'PT060104' => 'Benfeita',
	'PT060105' => 'Celavisa',
	'PT060109' => 'Folques',
	'PT060111' => 'Piódão',
	'PT060112' => 'Pomares',
	'PT060113' => 'Pombeiro da Beira',
	'PT060114' => 'São Martinho da Cortiça',
	'PT060115' => 'Sarzedo',
	'PT060116' => 'Secarias',
	'PT060119' => 'Cepos e Teixeira',
	'PT060120' => 'Cerdeira e Moura da Serra',
	'PT060121' => 'Côja e Barril de Alva',
	'PT060122' => 'Vila Cova de Alva e Anseriz',
	'PT060201' => 'Ançã',
	'PT060203' => 'Cadima',
	'PT060205' => 'Cordinhã',
	'PT060207' => 'Febres',
	'PT060208' => 'Murtede',
	'PT060209' => 'Ourentã',
	'PT060214' => 'Tocha',
	'PT060215' => 'São Caetano',
	'PT060218' => 'Sanguinheira',
	'PT060220' => 'Cantanhede e Pocariça',
	'PT060221' => 'Covões e Camarneira',
	'PT060222' => 'Portunhos e Outil',
	'PT060223' => 'Sepins e Bolho',
	'PT060224' => 'Vilamar e Corticeiro de Cima',
	'PT060301' => 'Almalaguês',
	'PT060309' => 'Brasfemes',
	'PT060311' => 'Ceira',
	'PT060312' => 'Cernache',
	'PT060318' => 'Santo António dos Olivais',
	'PT060320' => 'São João do Campo',
	'PT060324' => 'São Silvestre',
	'PT060329' => 'Torres do Mondego',
	'PT060332' => 'Antuzede e Vil de Matos',
	'PT060333' => 'Assafarge e Antanhol',
	'PT060334' => 'Coimbra (Sé Nova, Santa Cruz, Almedina e São Bartolomeu)',
	'PT060335' => 'Eiras e São Paulo de Frades',
	'PT060336' => 'Santa Clara e Castelo Viegas',
	'PT060337' => 'São Martinho de Árvore e Lamarosa',
	'PT060338' => 'São Martinho do Bispo e Ribeira de Frades',
	'PT060339' => 'Souselas e Botão',
	'PT060340' => 'Taveiro, Ameal e Arzila',
	'PT060341' => 'Trouxemil e Torre de Vilela',
	'PT060401' => 'Anobra',
	'PT060406' => 'Ega',
	'PT060407' => 'Furadouro',
	'PT060410' => 'Zambujal',
	'PT060411' => 'Condeixa-a-Velha e Condeixa-a-Nova',
	'PT060412' => 'Sebal e Belide',
	'PT060413' => 'Vila Seca e Bem da Fé',
	'PT060502' => 'Alqueidão',
	'PT060507' => 'Maiorca',
	'PT060508' => 'Marinha das Ondas',
	'PT060512' => 'Tavarede',
	'PT060513' => 'Vila Verde',
	'PT060514' => 'São Pedro',
	'PT060515' => 'Bom Sucesso',
	'PT060518' => 'Moinhos da Gândara',
	'PT060519' => 'Alhadas',
	'PT060520' => 'Buarcos',
	'PT060521' => 'Ferreira-a-Nova',
	'PT060522' => 'Lavos',
	'PT060523' => 'Paião',
	'PT060524' => 'Quiaios',
	'PT060601' => 'Alvares',
	'PT060604' => 'Góis',
	'PT060605' => 'Vila Nova do Ceira',
	'PT060606' => 'Cadafaz e Colmeal',
	'PT060704' => 'Serpins',
	'PT060706' => 'Gândaras',
	'PT060707' => 'Foz de Arouce e Casal de Ermio',
	'PT060708' => 'Lousã e Vilarinho',
	'PT060801' => 'Mira',
	'PT060802' => 'Seixo',
	'PT060803' => 'Carapelhos',
	'PT060804' => 'Praia de Mira',
	'PT060901' => 'Lamas',
	'PT060902' => 'Miranda do Corvo',
	'PT060905' => 'Vila Nova',
	'PT060906' => 'Semide e Rio Vide',
	'PT061002' => 'Arazede',
	'PT061003' => 'Carapinheira',
	'PT061005' => 'Liceia',
	'PT061006' => 'Meãs do Campo',
	'PT061008' => 'Pereira',
	'PT061009' => 'Santo Varão',
	'PT061010' => 'Seixo de Gatões',
	'PT061011' => 'Tentúgal',
	'PT061014' => 'Ereira',
	'PT061015' => 'Abrunheira, Verride e Vila Nova da Barca',
	'PT061016' => 'Montemor-o-Velho e Gatões',
	'PT061101' => 'Aldeia das Dez',
	'PT061102' => 'Alvoco das Várzeas',
	'PT061103' => 'Avô',
	'PT061104' => 'Bobadela',
	'PT061106' => 'Lagares',
	'PT061109' => 'Lourosa',
	'PT061110' => 'Meruge',
	'PT061111' => 'Nogueira do Cravo',
	'PT061115' => 'São Gião',
	'PT061118' => 'Seixo da Beira',
	'PT061119' => 'Travanca de Lagos',
	'PT061122' => 'Ervedal e Vila Franca da Beira',
	'PT061123' => 'Lagos da Beira e Lajeosa',
	'PT061124' => 'Oliveira do Hospital e São Paio de Gramaços',
	'PT061125' => 'Penalva de Alva e São Sebastião da Feira',
	'PT061126' => 'Santa Ovaia e Vila Pouca da Beira',
	'PT061201' => 'Cabril',
	'PT061202' => 'Dornelas do Zêzere',
	'PT061204' => 'Janeiro de Baixo',
	'PT061206' => 'Pampilhosa da Serra',
	'PT061207' => 'Pessegueiro',
	'PT061209' => 'Unhais-o-Velho',
	'PT061211' => 'Fajão-Vidual',
	'PT061212' => 'Portela do Fojo-Machio',
	'PT061301' => 'Carvalho',
	'PT061302' => 'Figueira de Lorvão',
	'PT061304' => 'Lorvão',
	'PT061307' => 'Penacova',
	'PT061310' => 'Sazes do Lorvão',
	'PT061312' => 'Friúmes e Paradela',
	'PT061313' => 'Oliveira do Mondego e Travanca do Mondego',
	'PT061314' => 'São Pedro de Alva e São Paio de Mondego',
	'PT061401' => 'Cumeeira',
	'PT061402' => 'Espinhal',
	'PT061403' => 'Podentes',
	'PT061407' => 'São Miguel, Santa Eufémia e Rabaçal',
	'PT061501' => 'Alfarelos',
	'PT061504' => 'Figueiró do Campo',
	'PT061506' => 'Granja do Ulmeiro',
	'PT061508' => 'Samuel',
	'PT061509' => 'Soure',
	'PT061510' => 'Tapéus',
	'PT061511' => 'Vila Nova de Anços',
	'PT061512' => 'Vinha da Rainha',
	'PT061513' => 'Degracias e Pombalinho',
	'PT061514' => 'Gesteira e Brunhós',
	'PT061602' => 'Candosa',
	'PT061603' => 'Carapinha',
	'PT061608' => 'Midões',
	'PT061609' => 'Mouronho',
	'PT061611' => 'Póvoa de Midões',
	'PT061612' => 'São João da Boa Vista',
	'PT061614' => 'Tábua',
	'PT061616' => 'Ázere e Covelo',
	'PT061617' => 'Covas e Vila Nova de Oliveirinha',
	'PT061618' => 'Espariz e Sinde',
	'PT061619' => 'Pinheiro de Coja e Meda de Mouros',
	'PT061701' => 'Arrifana',
	'PT061702' => 'Lavegadas',
	'PT061703' => 'Poiares (Santo André)',
	'PT061704' => 'São Miguel de Poiares',
	'PT070103' => 'Santiago Maior',
	'PT070104' => 'Capelins (Santo António)',
	'PT070105' => 'Terena (São Pedro)',
	'PT070107' => 'Alandroal (Nossa Senhora da Conceição), São Brás dos Matos (Mina do Bugalho) e Juromenha (Nossa Senhora do Loreto)',
	'PT070201' => 'Arraiolos',
	'PT070202' => 'Igrejinha',
	'PT070206' => 'Vimieiro',
	'PT070208' => 'Gafanhoeira (São Pedro) e Sabugueiro',
	'PT070209' => 'São Gregório e Santa Justa',
	'PT070301' => 'Borba (Matriz)',
	'PT070302' => 'Orada',
	'PT070303' => 'Rio de Moinhos',
	'PT070304' => 'Borba (São Bartolomeu)',
	'PT070401' => 'Arcos',
	'PT070402' => 'Glória',
	'PT070404' => 'Évora Monte (Santa Maria)',
	'PT070411' => 'São Domingos de Ana Loura',
	'PT070413' => 'Veiros',
	'PT070414' => 'Estremoz (Santa Maria e Santo André)',
	'PT070415' => 'São Bento do Cortiço e Santo Estêvão',
	'PT070416' => 'São Lourenço de Mamporcão e São Bento de Ana Loura',
	'PT070417' => 'União das freguesias do Ameixial (Santa Vitória e São Bento)',
	'PT070502' => 'Nossa Senhora da Graça do Divor',
	'PT070503' => 'Nossa Senhora de Machede',
	'PT070506' => 'São Bento do Mato',
	'PT070509' => 'São Miguel de Machede',
	'PT070513' => 'Torre de Coelheiros',
	'PT070515' => 'Canaviais',
	'PT070522' => 'Bacelo e Senhora da Saúde',
	'PT070523' => 'Évora (São Mamede, Sé, São Pedro e Santo Antão)',
	'PT070524' => 'Malagueira e Horta das Figueiras',
	'PT070525' => 'Nossa Senhora da Tourega e Nossa Senhora de Guadalupe',
	'PT070526' => 'São Manços e São Vicente do Pigeiro',
	'PT070527' => 'São Sebastião da Giesteira e Nossa Senhora da Boa Fé',
	'PT070601' => 'Cabrela',
	'PT070605' => 'Santiago do Escoural',
	'PT070606' => 'São Cristóvão',
	'PT070607' => 'Ciborro',
	'PT070610' => 'Foros de Vale de Figueira',
	'PT070611' => 'Cortiçadas de Lavre e Lavre',
	'PT070612' => 'Nossa Senhora da Vila, Nossa Senhora do Bispo e Silveiras',
	'PT070701' => 'Brotas',
	'PT070702' => 'Cabeção',
	'PT070703' => 'Mora',
	'PT070704' => 'Pavia',
	'PT070801' => 'Granja',
	'PT070802' => 'Luz',
	'PT070803' => 'Mourão',
	'PT070903' => 'Monte do Trigo',
	'PT070905' => 'Portel',
	'PT070906' => 'Santana',
	'PT070908' => 'Vera Cruz',
	'PT070909' => 'Amieira e Alqueva',
	'PT070910' => 'São Bartolomeu do Outeiro e Oriola',
	'PT071001' => 'Montoito',
	'PT071002' => 'Redondo',
	'PT071102' => 'Corval',
	'PT071103' => 'Monsaraz',
	'PT071104' => 'Reguengos de Monsaraz',
	'PT071106' => 'Campo e Campinho',
	'PT071201' => 'Vendas Novas',
	'PT071202' => 'Landeira',
	'PT071301' => 'Alcáçovas',
	'PT071302' => 'Viana do Alentejo',
	'PT071303' => 'Aguiar',
	'PT071401' => 'Bencatel',
	'PT071402' => 'Ciladas',
	'PT071404' => 'Pardais',
	'PT071406' => 'Nossa Senhora da Conceição e São Bartolomeu',
	'PT080102' => 'Guia',
	'PT080103' => 'Paderne',
	'PT080104' => 'Ferreiras',
	'PT080106' => 'Albufeira e Olhos de Água',
	'PT080202' => 'Giões',
	'PT080203' => 'Martim Longo',
	'PT080205' => 'Vaqueiros',
	'PT080206' => 'Alcoutim e Pereiro',
	'PT080301' => 'Aljezur',
	'PT080302' => 'Bordeira',
	'PT080303' => 'Odeceixe',
	'PT080304' => 'Rogil',
	'PT080401' => 'Azinhal',
	'PT080402' => 'Castro Marim',
	'PT080403' => 'Odeleite',
	'PT080404' => 'Altura',
	'PT080503' => 'Santa Bárbara de Nexe',
	'PT080506' => 'Montenegro',
	'PT080507' => 'Conceição e Estoi',
	'PT080508' => 'Faro (Sé e São Pedro)',
	'PT080602' => 'Ferragudo',
	'PT080604' => 'Porches',
	'PT080607' => 'Estômbar e Parchal',
	'PT080608' => 'Lagoa e Carvoeiro',
	'PT080703' => 'Luz',
	'PT080704' => 'Odiáxere',
	'PT080707' => 'Bensafrim e Barão de São João',
	'PT080708' => 'Lagos (São Sebastião e Santa Maria)',
	'PT080801' => 'Almancil',
	'PT080802' => 'Alte',
	'PT080803' => 'Ameixial',
	'PT080804' => 'Boliqueime',
	'PT080805' => 'Quarteira',
	'PT080807' => 'Salir',
	'PT080808' => 'Loulé (São Clemente)',
	'PT080809' => 'Loulé (São Sebastião)',
	'PT080812' => 'União de freguesias de Querença, Tôr e Benafim',
	'PT080901' => 'Alferce',
	'PT080902' => 'Marmelete',
	'PT080903' => 'Monchique',
	'PT081003' => 'Olhão',
	'PT081004' => 'Pechão',
	'PT081005' => 'Quelfes',
	'PT081006' => 'Moncarapacho e Fuseta',
	'PT081101' => 'Alvor',
	'PT081102' => 'Mexilhoeira Grande',
	'PT081103' => 'Portimão',
	'PT081201' => 'São Brás de Alportel',
	'PT081303' => 'Armação de Pêra',
	'PT081305' => 'São Bartolomeu de Messines',
	'PT081306' => 'São Marcos da Serra',
	'PT081307' => 'Silves',
	'PT081309' => 'Alcantarilha e Pêra',
	'PT081310' => 'Algoz e Tunes',
	'PT081401' => 'Cachopo',
	'PT081404' => 'Santa Catarina da Fonte do Bispo',
	'PT081408' => 'Santa Luzia',
	'PT081410' => 'Conceição e Cabanas de Tavira',
	'PT081411' => 'Luz de Tavira e Santo Estêvão',
	'PT081412' => 'Tavira (Santa Maria e Santiago)',
	'PT081501' => 'Barão de São Miguel',
	'PT081502' => 'Budens',
	'PT081504' => 'Sagres',
	'PT081506' => 'Vila do Bispo e Raposeira',
	'PT081601' => 'Vila Nova de Cacela',
	'PT081602' => 'Vila Real de Santo António',
	'PT081603' => 'Monte Gordo',
	'PT090102' => 'Carapito',
	'PT090103' => 'Cortiçada',
	'PT090105' => 'Dornelas',
	'PT090106' => 'Eirado',
	'PT090107' => 'Forninhos',
	'PT090109' => 'Pena Verde',
	'PT090110' => 'Pinheiro',
	'PT090114' => 'Aguiar da Beira e Coruche',
	'PT090115' => 'Sequeiros e Gradiz',
	'PT090116' => 'Souto de Aguiar da Beira e Valverde',
	'PT090203' => 'Almeida',
	'PT090207' => 'Castelo Bom',
	'PT090209' => 'Freineda',
	'PT090210' => 'Freixo',
	'PT090213' => 'Malhada Sorda',
	'PT090219' => 'Nave de Haver',
	'PT090224' => 'São Pedro de Rio Seco',
	'PT090227' => 'Vale da Mula',
	'PT090229' => 'Vilar Formoso',
	'PT090230' => 'Amoreira, Parada e Cabreira',
	'PT090231' => 'Azinhal, Peva e Valverde',
	'PT090232' => 'Castelo Mendo, Ade, Monteperobolso e Mesquitela',
	'PT090233' => 'Junça e Naves',
	'PT090234' => 'Leomil, Mido, Senouras e Aldeia Nova',
	'PT090235' => 'Malpartida e Vale de Coelha',
	'PT090236' => 'Miuzela e Porto de Ovelha',
	'PT090302' => 'Baraçal',
	'PT090304' => 'Carrapichana',
	'PT090306' => 'Forno Telheiro',
	'PT090307' => 'Lajeosa do Mondego',
	'PT090308' => 'Linhares',
	'PT090309' => 'Maçal do Chão',
	'PT090310' => 'Mesquitela',
	'PT090311' => 'Minhocal',
	'PT090312' => 'Prados',
	'PT090314' => 'Ratoeira',
	'PT090318' => 'Vale de Azares',
	'PT090322' => 'Casas do Soeiro',
	'PT090323' => 'Açores e Velosa',
	'PT090324' => 'Celorico (São Pedro e Santa Maria) e Vila Boa do Mondego',
	'PT090325' => 'Cortiçô da Serra, Vide entre Vinhas e Salgueirais',
	'PT090326' => 'Rapa e Cadafaz',
	'PT090403' => 'Castelo Rodrigo',
	'PT090406' => 'Escalhão',
	'PT090408' => 'Figueira de Castelo Rodrigo',
	'PT090410' => 'Mata de Lobos',
	'PT090415' => 'Vermiosa',
	'PT090418' => 'Algodres, Vale de Afonsinho e Vilar de Amargo',
	'PT090419' => 'Almofala e Escarigo',
	'PT090420' => 'Cinco Vilas e Reigada',
	'PT090421' => 'Freixeda do Torrão, Quintã de Pêro Martins e Penha de Águia',
	'PT090422' => 'União das freguesias do Colmeal e Vilar Torpim',
	'PT090501' => 'Algodres',
	'PT090502' => 'Casal Vasco',
	'PT090504' => 'Figueiró da Granja',
	'PT090505' => 'Fornos de Algodres',
	'PT090507' => 'Infias',
	'PT090509' => 'Maceira',
	'PT090510' => 'Matança',
	'PT090511' => 'Muxagata',
	'PT090512' => 'Queiriz',
	'PT090517' => 'Cortiçô e Vila Chã',
	'PT090518' => 'Juncais, Vila Ruiva e Vila Soeiro do Chão',
	'PT090519' => 'Sobral Pichorro e Fuinhas',
	'PT090602' => 'Arcozelo',
	'PT090603' => 'Cativelos',
	'PT090605' => 'Folgosinho',
	'PT090612' => 'Nespereira',
	'PT090613' => 'Paços da Serra',
	'PT090614' => 'Ribamondego',
	'PT090617' => 'São Paio',
	'PT090619' => 'Vila Cortês da Serra',
	'PT090620' => 'Vila Franca da Serra',
	'PT090621' => 'Vila Nova de Tazem',
	'PT090623' => 'Aldeias e Mangualde da Serra',
	'PT090624' => 'Figueiró da Serra e Freixo da Serra',
	'PT090625' => 'Gouveia',
	'PT090626' => 'Melo e Nabais',
	'PT090627' => 'Moimenta da Serra e Vinhó',
	'PT090628' => 'Rio Torto e Lagarinhos',
	'PT090703' => 'Aldeia do Bispo',
	'PT090704' => 'Aldeia Viçosa',
	'PT090705' => 'Alvendre',
	'PT090706' => 'Arrifana',
	'PT090708' => 'Avelãs da Ribeira',
	'PT090709' => 'Benespera',
	'PT090711' => 'Casal de Cinza',
	'PT090712' => 'Castanheira',
	'PT090713' => 'Cavadoude',
	'PT090714' => 'Codesseiro',
	'PT090716' => 'Faia',
	'PT090717' => 'Famalicão',
	'PT090718' => 'Fernão Joanes',
	'PT090721' => 'Gonçalo Bocas',
	'PT090722' => 'João Antão',
	'PT090723' => 'Maçainhas',
	'PT090724' => 'Marmeleiro',
	'PT090725' => 'Meios',
	'PT090728' => 'Panoias de Cima',
	'PT090729' => 'Pega',
	'PT090730' => 'Pêra do Moço',
	'PT090732' => 'Porto da Carne',
	'PT090734' => 'Ramela',
	'PT090738' => 'Santana da Azinha',
	'PT090744' => 'Sobral da Serra',
	'PT090746' => 'Vale de Estrela',
	'PT090747' => 'Valhelhas',
	'PT090748' => 'Vela',
	'PT090749' => 'Videmonte',
	'PT090750' => 'Vila Cortês do Mondego',
	'PT090751' => 'Vila Fernando',
	'PT090752' => 'Vila Franca do Deão',
	'PT090753' => 'Vila Garcia',
	'PT090757' => 'Gonçalo',
	'PT090758' => 'Guarda',
	'PT090759' => 'Jarmelo São Miguel',
	'PT090760' => 'Jarmelo São Pedro',
	'PT090761' => 'União de freguesias de Avelãs de Ambom e Rocamondo',
	'PT090762' => 'União de freguesias de Corujeira e Trinta',
	'PT090763' => 'União de freguesias de Mizarela, Pêro Soares e Vila Soeiro',
	'PT090764' => 'União de freguesias de Pousade e Albardo',
	'PT090765' => 'União de freguesias de Rochoso e Monte Margarida',
	'PT090766' => 'Adão',
	'PT090801' => 'Sameiro',
	'PT090802' => 'Manteigas (Santa Maria)',
	'PT090803' => 'Manteigas (São Pedro)',
	'PT090804' => 'Vale de Amoreira',
	'PT090901' => 'Aveloso',
	'PT090902' => 'Barreira',
	'PT090905' => 'Coriscada',
	'PT090907' => 'Longroiva',
	'PT090908' => 'Marialva',
	'PT090912' => 'Poço do Canto',
	'PT090914' => 'Rabaçal',
	'PT090915' => 'Ranhados',
	'PT090917' => 'Mêda, Outeiro de Gatos e Fonte Longa',
	'PT090918' => 'Prova e Casteição',
	'PT090919' => 'Vale Flor, Carvalhal e Pai Penela',
	'PT091009' => 'Ervedosa',
	'PT091010' => 'Freixedas',
	'PT091012' => 'Lamegal',
	'PT091013' => 'Lameiras',
	'PT091014' => 'Manigoto',
	'PT091015' => 'Pala',
	'PT091017' => 'Pinhel',
	'PT091018' => 'Pínzio',
	'PT091024' => 'Souro Pires',
	'PT091027' => 'Vascoveiro',
	'PT091028' => 'Agregação das freguesias Sul de Pinhel',
	'PT091029' => 'Alverca da Beira/Bouça Cova',
	'PT091030' => 'Terras de Massueime',
	'PT091031' => 'Valbom/Bogalhal',
	'PT091032' => 'Alto do Palurdo',
	'PT091033' => 'Vale do Côa',
	'PT091034' => 'Vale do Massueime',
	'PT091035' => 'Atalaia e Safurdão',
	'PT091101' => 'Águas Belas',
	'PT091102' => 'Aldeia do Bispo',
	'PT091103' => 'Aldeia da Ponte',
	'PT091106' => 'Aldeia Velha',
	'PT091107' => 'Alfaiates',
	'PT091109' => 'Baraçal',
	'PT091110' => 'Bendada',
	'PT091111' => 'Bismula',
	'PT091112' => 'Casteleiro',
	'PT091113' => 'Cerdeira',
	'PT091114' => 'Fóios',
	'PT091118' => 'Malcata',
	'PT091120' => 'Nave',
	'PT091123' => 'Quadrazais',
	'PT091124' => 'Quintas de São Bartolomeu',
	'PT091125' => 'Rapoula do Côa',
	'PT091126' => 'Rebolosa',
	'PT091127' => 'Rendo',
	'PT091133' => 'Sortelha',
	'PT091134' => 'Souto',
	'PT091136' => 'Vale de Espinho',
	'PT091138' => 'Vila Boa',
	'PT091139' => 'Vila do Touro',
	'PT091141' => 'Aldeia da Ribeira, Vilar Maior e Badamalos',
	'PT091142' => 'Lajeosa e Forcalhos',
	'PT091143' => 'Pousafoles do Bispo, Pena Lobo e Lomba',
	'PT091144' => 'Ruvina, Ruivós e Vale das Éguas',
	'PT091145' => 'União das freguesias do Sabugal e Aldeia de Santo António',
	'PT091146' => 'Santo Estêvão e Moita',
	'PT091147' => 'Seixo do Côa e Vale Longo',
	'PT091201' => 'Alvoco da Serra',
	'PT091205' => 'Girabolhos',
	'PT091207' => 'Loriga',
	'PT091208' => 'Paranhos',
	'PT091209' => 'Pinhanços',
	'PT091210' => 'Sabugueiro',
	'PT091212' => 'Sandomil',
	'PT091213' => 'Santa Comba',
	'PT091216' => 'Santiago',
	'PT091219' => 'Sazes da Beira',
	'PT091221' => 'Teixeira',
	'PT091224' => 'Travancinha',
	'PT091225' => 'Valezim',
	'PT091228' => 'Vila Cova à Coelheira',
	'PT091230' => 'Carragozela e Várzea de Meruge',
	'PT091231' => 'Sameice e Santa Eulália',
	'PT091232' => 'Santa Marinha e São Martinho',
	'PT091233' => 'Seia, São Romão e Lapa dos Dinheiros',
	'PT091234' => 'Torrozelo e Folhadosa',
	'PT091235' => 'Tourais e Lajes',
	'PT091236' => 'Vide e Cabeça',
	'PT091301' => 'Aldeia Nova',
	'PT091303' => 'Castanheira',
	'PT091304' => 'Cogula',
	'PT091305' => 'Cótimos',
	'PT091307' => 'Fiães',
	'PT091309' => 'Granja',
	'PT091310' => 'Guilheiro',
	'PT091311' => 'Moimentinha',
	'PT091312' => 'Moreira de Rei',
	'PT091313' => 'Palhais',
	'PT091314' => 'Póvoa do Concelho',
	'PT091315' => 'Reboleiro',
	'PT091316' => 'Rio de Mel',
	'PT091321' => 'Tamanhos',
	'PT091325' => 'Valdujo',
	'PT091330' => 'Freches e Torres',
	'PT091331' => 'Torre do Terrenho, Sebadelhe da Serra e Terrenho',
	'PT091332' => 'Trancoso (São Pedro e Santa Maria) e Souto Maior',
	'PT091333' => 'Vale do Seixo e Vila Garcia',
	'PT091334' => 'Vila Franca das Naves e Feital',
	'PT091335' => 'Vilares e Carnicães',
	'PT091401' => 'Almendra',
	'PT091402' => 'Castelo Melhor',
	'PT091403' => 'Cedovim',
	'PT091404' => 'Chãs',
	'PT091405' => 'Custóias',
	'PT091407' => 'Horta',
	'PT091410' => 'Muxagata',
	'PT091411' => 'Numão',
	'PT091412' => 'Santa Comba',
	'PT091414' => 'Sebadelhe',
	'PT091415' => 'Seixas',
	'PT091416' => 'Touça',
	'PT091418' => 'Freixo de Numão',
	'PT091419' => 'Vila Nova de Foz Côa',
	'PT100102' => 'Alfeizerão',
	'PT100104' => 'Bárrio',
	'PT100105' => 'Benedita',
	'PT100106' => 'Cela',
	'PT100108' => 'Évora de Alcobaça',
	'PT100109' => 'Maiorga',
	'PT100112' => 'São Martinho do Porto',
	'PT100114' => 'Turquel',
	'PT100116' => 'Vimeiro',
	'PT100120' => 'Aljubarrota',
	'PT100121' => 'Alcobaça e Vestiaria',
	'PT100122' => 'Coz, Alpedriz e Montes',
	'PT100123' => 'Pataias e Martingança',
	'PT100201' => 'Almoster',
	'PT100204' => 'Maçãs de Dona Maria',
	'PT100205' => 'Pelmá',
	'PT100208' => 'Alvaiázere',
	'PT100209' => 'Pussos São Pedro',
	'PT100301' => 'Alvorge',
	'PT100303' => 'Avelar',
	'PT100304' => 'Chão de Couce',
	'PT100306' => 'Pousaflores',
	'PT100307' => 'Santiago da Guarda',
	'PT100309' => 'Ansião',
	'PT100401' => 'Batalha',
	'PT100402' => 'Reguengo do Fetal',
	'PT100403' => 'São Mamede',
	'PT100404' => 'Golpilheira',
	'PT100502' => 'Carvalhal',
	'PT100503' => 'Roliça',
	'PT100505' => 'Pó',
	'PT100506' => 'União das freguesias do Bombarral e Vale Covo',
	'PT100601' => 'A dos Francos',
	'PT100602' => 'Alvorninha',
	'PT100604' => 'Carvalhal Benfeito',
	'PT100606' => 'Foz do Arelho',
	'PT100607' => 'Landal',
	'PT100608' => 'Nadadouro',
	'PT100609' => 'Salir de Matos',
	'PT100611' => 'Santa Catarina',
	'PT100615' => 'Vidais',
	'PT100617' => 'Caldas da Rainha - Nossa Senhora do Pópulo, Coto e São Gregório',
	'PT100618' => 'Caldas da Rainha - Santo Onofre e Serra do Bouro',
	'PT100619' => 'Tornada e Salir do Porto',
	'PT100703' => 'Castanheira de Pêra e Coentral',
	'PT100801' => 'Aguda',
	'PT100802' => 'Arega',
	'PT100803' => 'Campelo',
	'PT100806' => 'Figueiró dos Vinhos e Bairradas',
	'PT100901' => 'Amor',
	'PT100902' => 'Arrabal',
	'PT100907' => 'Caranguejeira',
	'PT100909' => 'Coimbrão',
	'PT100913' => 'Maceira',
	'PT100915' => 'Milagres',
	'PT100921' => 'Regueira de Pontes',
	'PT100925' => 'Bajouca',
	'PT100926' => 'Bidoeira de Cima',
	'PT100932' => 'Colmeias e Memória',
	'PT100933' => 'Leiria, Pousos, Barreira e Cortes',
	'PT100934' => 'Marrazes e Barosa',
	'PT100935' => 'Monte Real e Carvide',
	'PT100936' => 'Monte Redondo e Carreira',
	'PT100937' => 'Parceiros e Azoia',
	'PT100938' => 'Santa Catarina da Serra e Chainça',
	'PT100939' => 'Santa Eufémia e Boa Vista',
	'PT100940' => 'Souto da Carpalhosa e Ortigosa',
	'PT101001' => 'Marinha Grande',
	'PT101002' => 'Vieira de Leiria',
	'PT101003' => 'Moita',
	'PT101101' => 'Famalicão',
	'PT101102' => 'Nazaré',
	'PT101103' => 'Valado dos Frades',
	'PT101201' => 'A dos Negros',
	'PT101202' => 'Amoreira',
	'PT101203' => 'Olho Marinho',
	'PT101207' => 'Vau',
	'PT101208' => 'Gaeiras',
	'PT101209' => 'Usseira',
	'PT101210' => 'Santa Maria, São Pedro e Sobral da Lagoa',
	'PT101301' => 'Graça',
	'PT101302' => 'Pedrógão Grande',
	'PT101303' => 'Vila Facaia',
	'PT101402' => 'Atouguia da Baleia',
	'PT101405' => 'Serra dEl-Rei',
	'PT101406' => 'Ferrel',
	'PT101407' => 'Peniche',
	'PT101501' => 'Abiul',
	'PT101503' => 'Almagreira',
	'PT101504' => 'Carnide',
	'PT101505' => 'Carriço',
	'PT101506' => 'Louriçal',
	'PT101508' => 'Pelariga',
	'PT101509' => 'Pombal',
	'PT101510' => 'Redinha',
	'PT101513' => 'Vermoil',
	'PT101514' => 'Vila Cã',
	'PT101515' => 'Meirinhas',
	'PT101518' => 'Guia, Ilha e Mata Mourisca',
	'PT101519' => 'Santiago e São Simão de Litém e Albergaria dos Doze',
	'PT101602' => 'Alqueidão da Serra',
	'PT101605' => 'Calvaria de Cima',
	'PT101606' => 'Juncal',
	'PT101608' => 'Mira de Aire',
	'PT101609' => 'Pedreiras',
	'PT101610' => 'São Bento',
	'PT101613' => 'Serro Ventoso',
	'PT101614' => 'Porto de Mós - São João Baptista e São Pedro',
	'PT101615' => 'Alvados e Alcaria',
	'PT101616' => 'Arrimal e Mendiga',
	'PT110106' => 'Carnota',
	'PT110107' => 'Meca',
	'PT110108' => 'Olhalvo',
	'PT110109' => 'Ota',
	'PT110113' => 'Ventosa',
	'PT110114' => 'Vila Verde dos Francos',
	'PT110117' => 'Abrigada e Cabanas de Torres',
	'PT110118' => 'Aldeia Galega da Merceana e Aldeia Gavinha',
	'PT110119' => 'Alenquer (Santo Estêvão e Triana)',
	'PT110120' => 'Carregado e Cadafais',
	'PT110121' => 'Ribafria e Pereiro de Palhacana',
	'PT110201' => 'Arranhó',
	'PT110202' => 'Arruda dos Vinhos',
	'PT110203' => 'Cardosas',
	'PT110204' => 'Santiago dos Velhos',
	'PT110301' => 'Alcoentre',
	'PT110302' => 'Aveiras de Baixo',
	'PT110303' => 'Aveiras de Cima',
	'PT110304' => 'Azambuja',
	'PT110306' => 'Vale do Paraíso',
	'PT110307' => 'Vila Nova da Rainha',
	'PT110310' => 'Manique do Intendente, Vila Nova de São Pedro e Maçussa',
	'PT110401' => 'Alguber',
	'PT110407' => 'Peral',
	'PT110409' => 'Vermelha',
	'PT110410' => 'Vilar',
	'PT110411' => 'União das freguesias do Cadaval e Pêro Moniz',
	'PT110412' => 'Lamas e Cercal',
	'PT110413' => 'Painho e Figueiros',
	'PT110501' => 'Alcabideche',
	'PT110506' => 'São Domingos de Rana',
	'PT110507' => 'Carcavelos e Parede',
	'PT110508' => 'Cascais e Estoril',
	'PT110601' => 'Ajuda',
	'PT110602' => 'Alcântara',
	'PT110607' => 'Beato',
	'PT110608' => 'Benfica',
	'PT110610' => 'Campolide',
	'PT110611' => 'Carnide',
	'PT110618' => 'Lumiar',
	'PT110621' => 'Marvila',
	'PT110633' => 'Olivais',
	'PT110639' => 'São Domingos de Benfica',
	'PT110654' => 'Alvalade',
	'PT110655' => 'Areeiro',
	'PT110656' => 'Arroios',
	'PT110657' => 'Avenidas Novas',
	'PT110658' => 'Belém',
	'PT110659' => 'Campo de Ourique',
	'PT110660' => 'Estrela',
	'PT110661' => 'Misericórdia',
	'PT110662' => 'Parque das Nações',
	'PT110663' => 'Penha de França',
	'PT110664' => 'Santa Clara',
	'PT110665' => 'Santa Maria Maior',
	'PT110666' => 'Santo António',
	'PT110667' => 'São Vicente',
	'PT110702' => 'Bucelas',
	'PT110705' => 'Fanhões',
	'PT110707' => 'Loures',
	'PT110708' => 'Lousa',
	'PT110726' => 'Moscavide e Portela',
	'PT110727' => 'Sacavém e Prior Velho',
	'PT110728' => 'Santa Iria de Azoia, São João da Talha e Bobadela',
	'PT110729' => 'Santo Antão e São Julião do Tojal',
	'PT110730' => 'Santo António dos Cavaleiros e Frielas',
	'PT110731' => 'Camarate, Unhos e Apelação',
	'PT110803' => 'Moita dos Ferreiros',
	'PT110805' => 'Reguengo Grande',
	'PT110806' => 'Santa Bárbara',
	'PT110808' => 'Vimeiro',
	'PT110810' => 'Ribamar',
	'PT110812' => 'Lourinhã e Atalaia',
	'PT110813' => 'Miragaia e Marteleira',
	'PT110814' => 'São Bartolomeu dos Galegos e Moledo',
	'PT110902' => 'Carvoeira',
	'PT110904' => 'Encarnação',
	'PT110906' => 'Ericeira',
	'PT110909' => 'Mafra',
	'PT110911' => 'Milharado',
	'PT110913' => 'Santo Isidoro',
	'PT110918' => 'Azueira e Sobral da Abelheira',
	'PT110919' => 'Enxara do Bispo, Gradil e Vila Franca do Rosário',
	'PT110920' => 'Igreja Nova e Cheleiros',
	'PT110921' => 'Malveira e São Miguel de Alcainça',
	'PT110922' => 'Venda do Pinheiro e Santo Estêvão das Galés',
	'PT111002' => 'Barcarena',
	'PT111009' => 'Porto Salvo',
	'PT111012' => 'Algés, Linda-a-Velha e Cruz Quebrada-Dafundo',
	'PT111013' => 'Carnaxide e Queijas',
	'PT111014' => 'Oeiras e São Julião da Barra, Paço de Arcos e Caxias',
	'PT111102' => 'Algueirão-Mem Martins',
	'PT111105' => 'Colares',
	'PT111108' => 'Rio de Mouro',
	'PT111115' => 'Casal de Cambra',
	'PT111122' => 'Agualva e Mira-Sintra',
	'PT111123' => 'Almargem do Bispo, Pêro Pinheiro e Montelavar',
	'PT111124' => 'União das freguesias do Cacém e São Marcos',
	'PT111125' => 'Massamá e Monte Abraão',
	'PT111126' => 'Queluz e Belas',
	'PT111127' => 'São João das Lampas e Terrugem',
	'PT111128' => 'Sintra (Santa Maria e São Miguel, São Martinho e São Pedro de Penaferrim)',
	'PT111201' => 'Santo Quintino',
	'PT111202' => 'Sapataria',
	'PT111203' => 'Sobral de Monte Agraço',
	'PT111306' => 'Freiria',
	'PT111310' => 'Ponte do Rol',
	'PT111311' => 'Ramalhal',
	'PT111314' => 'São Pedro da Cadeira',
	'PT111316' => 'Silveira',
	'PT111317' => 'Turcifal',
	'PT111318' => 'Ventosa',
	'PT111321' => 'A dos Cunhados e Maceira',
	'PT111322' => 'Campelos e Outeiro da Cabeça',
	'PT111323' => 'Carvoeira e Carmões',
	'PT111324' => 'Dois Portos e Runa',
	'PT111325' => 'Maxial e Monte Redondo',
	'PT111326' => 'Torres Vedras (São Pedro, Santiago, Santa Maria do Castelo e São Miguel) e Matacães',
	'PT111408' => 'Vialonga',
	'PT111409' => 'Vila Franca de Xira',
	'PT111412' => 'Alhandra, São João dos Montes e Calhandriz',
	'PT111413' => 'Alverca do Ribatejo e Sobralinho',
	'PT111414' => 'Castanheira do Ribatejo e Cachoeiras',
	'PT111415' => 'Póvoa de Santa Iria e Forte da Casa',
	'PT111512' => 'Alfragide',
	'PT111513' => 'Águas Livres',
	'PT111514' => 'Encosta do Sol',
	'PT111515' => 'Falagueira-Venda Nova',
	'PT111516' => 'Mina de Água',
	'PT111517' => 'Venteira',
	'PT111603' => 'Odivelas',
	'PT111608' => 'Pontinha e Famões',
	'PT111609' => 'Póvoa de Santo Adrião e Olival Basto',
	'PT111610' => 'Ramada e Caneças',
	'PT120101' => 'Alter do Chão',
	'PT120102' => 'Chancelaria',
	'PT120103' => 'Seda',
	'PT120104' => 'Cunheira',
	'PT120201' => 'Assunção',
	'PT120202' => 'Esperança',
	'PT120203' => 'Mosteiros',
	'PT120302' => 'Aldeia Velha',
	'PT120303' => 'Avis',
	'PT120305' => 'Ervedal',
	'PT120306' => 'Figueira e Barros',
	'PT120309' => 'Alcórrego e Maranhão',
	'PT120310' => 'Benavila e Valongo',
	'PT120401' => 'Nossa Senhora da Expectação',
	'PT120402' => 'Nossa Senhora da Graça dos Degolados',
	'PT120403' => 'São João Baptista',
	'PT120501' => 'Nossa Senhora da Graça de Póvoa e Meadas',
	'PT120502' => 'Santa Maria da Devesa',
	'PT120503' => 'Santiago Maior',
	'PT120504' => 'São João Baptista',
	'PT120601' => 'Aldeia da Mata',
	'PT120604' => 'Gáfete',
	'PT120605' => 'Monte da Pedra',
	'PT120607' => 'Crato e Mártires, Flor da Rosa e Vale do Peso',
	'PT120706' => 'Santa Eulália',
	'PT120707' => 'São Brás e São Lourenço',
	'PT120708' => 'São Vicente e Ventosa',
	'PT120712' => 'Assunção, Ajuda, Salvador e Santo Ildefonso',
	'PT120713' => 'Caia, São Pedro e Alcáçova',
	'PT120714' => 'Barbacena e Vila Fernando',
	'PT120715' => 'Terrugem e Vila Boim',
	'PT120801' => 'Cabeço de Vide',
	'PT120802' => 'Fronteira',
	'PT120803' => 'São Saturnino',
	'PT120902' => 'Belver',
	'PT120903' => 'Comenda',
	'PT120905' => 'Margem',
	'PT120906' => 'Gavião e Atalaia',
	'PT121001' => 'Beirã',
	'PT121002' => 'Santa Maria de Marvão',
	'PT121003' => 'Santo António das Areias',
	'PT121004' => 'São Salvador da Aramenha',
	'PT121101' => 'Assumar',
	'PT121102' => 'Monforte',
	'PT121103' => 'Santo Aleixo',
	'PT121104' => 'Vaiamonte',
	'PT121201' => 'Alpalhão',
	'PT121205' => 'Montalvão',
	'PT121207' => 'Santana',
	'PT121208' => 'São Matias',
	'PT121210' => 'Tolosa',
	'PT121211' => 'Arez e Amieira do Tejo',
	'PT121212' => 'Espírito Santo, Nossa Senhora da Graça e São Simão',
	'PT121301' => 'Galveias',
	'PT121302' => 'Montargil',
	'PT121304' => 'Foros de Arrão',
	'PT121305' => 'Longomel',
	'PT121308' => 'Ponte de Sor, Tramaga e Vale de Açor',
	'PT121401' => 'Alagoa',
	'PT121402' => 'Alegrete',
	'PT121404' => 'Fortios',
	'PT121410' => 'Urra',
	'PT121411' => 'União das freguesias da Sé e São Lourenço',
	'PT121412' => 'Reguengo e São Julião',
	'PT121413' => 'Ribeira de Nisa e Carreiras',
	'PT121501' => 'Cano',
	'PT121502' => 'Casa Branca',
	'PT121503' => 'Santo Amaro',
	'PT121504' => 'Sousel',
	'PT130103' => 'Ansiães',
	'PT130107' => 'Candemil',
	'PT130112' => 'Fregim',
	'PT130115' => 'Fridão',
	'PT130117' => 'Gondar',
	'PT130118' => 'Jazente',
	'PT130119' => 'Lomba',
	'PT130120' => 'Louredo',
	'PT130121' => 'Lufrei',
	'PT130123' => 'Mancelos',
	'PT130126' => 'Padronelo',
	'PT130128' => 'Rebordelo',
	'PT130129' => 'Salvador do Monte',
	'PT130134' => 'Gouveia (São Simão)',
	'PT130135' => 'Telões',
	'PT130136' => 'Travanca',
	'PT130138' => 'Vila Caiz',
	'PT130139' => 'Vila Chã do Marão',
	'PT130141' => 'Aboadela, Sanche e Várzea',
	'PT130142' => 'Amarante (São Gonçalo), Madalena, Cepelos e Gatão',
	'PT130143' => 'Bustelo, Carneiro e Carvalho de Rei',
	'PT130144' => 'Figueiró (Santiago e Santa Cristina)',
	'PT130145' => 'Freixo de Cima e de Baixo',
	'PT130146' => 'Olo e Canadelo',
	'PT130147' => 'Real, Ataíde e Oliveira',
	'PT130148' => 'Vila Garcia, Aboim e Chapa',
	'PT130204' => 'Frende',
	'PT130205' => 'Gestaçô',
	'PT130206' => 'Gove',
	'PT130207' => 'Grilo',
	'PT130208' => 'Loivos do Monte',
	'PT130215' => 'Santa Marinha do Zêzere',
	'PT130219' => 'Valadares',
	'PT130220' => 'Viariz',
	'PT130221' => 'Ancede e Ribadouro',
	'PT130222' => 'Baião (Santa Leocádia) e Mesquinhata',
	'PT130223' => 'Campelo e Ovil',
	'PT130224' => 'Loivos da Ribeira e Tresouras',
	'PT130225' => 'Santa Cruz do Douro e São Tomé de Covelas',
	'PT130226' => 'Teixeira e Teixeiró',
	'PT130301' => 'Aião',
	'PT130302' => 'Airães',
	'PT130305' => 'Friande',
	'PT130306' => 'Idães',
	'PT130307' => 'Jugueiros',
	'PT130313' => 'Penacova',
	'PT130314' => 'Pinheiro',
	'PT130315' => 'Pombeiro de Ribavizela',
	'PT130317' => 'Refontoura',
	'PT130318' => 'Regilde',
	'PT130319' => 'Revinhade',
	'PT130324' => 'Sendim',
	'PT130334' => 'Macieira da Lixa e Caramos',
	'PT130335' => 'Margaride (Santa Eulália), Várzea, Lagares, Varziela e Moure',
	'PT130336' => 'Pedreira, Rande e Sernande',
	'PT130337' => 'Torrados e Sousa',
	'PT130338' => 'Unhão e Lordelo',
	'PT130339' => 'Vila Cova da Lixa e Borba de Godim',
	'PT130340' => 'Vila Fria e Vizela (São Jorge)',
	'PT130341' => 'Vila Verde e Santão',
	'PT130405' => 'Lomba',
	'PT130408' => 'Rio Tinto',
	'PT130412' => 'Baguim do Monte (Rio Tinto)',
	'PT130413' => 'Fânzeres e São Pedro da Cova',
	'PT130414' => 'Foz do Sousa e Covelo',
	'PT130415' => 'Gondomar (São Cosme), Valbom e Jovim',
	'PT130416' => 'Melres e Medas',
	'PT130502' => 'Aveleda',
	'PT130504' => 'Caíde de Rei',
	'PT130510' => 'Lodares',
	'PT130512' => 'Macieira',
	'PT130513' => 'Meinedo',
	'PT130515' => 'Nevogilde',
	'PT130524' => 'Sousela',
	'PT130525' => 'Torno',
	'PT130526' => 'Vilar do Torno e Alentém',
	'PT130527' => 'Cernadelo e Lousada (São Miguel e Santa Margarida)',
	'PT130528' => 'Cristelos, Boim e Ordem',
	'PT130529' => 'Figueiras e Covas',
	'PT130530' => 'Lustosa e Barrosas (Santo Estêvão)',
	'PT130531' => 'Nespereira e Casais',
	'PT130532' => 'Silvares, Pias, Nogueira e Alvarenga',
	'PT130601' => 'Águas Santas',
	'PT130603' => 'Folgosa',
	'PT130608' => 'Milheirós',
	'PT130609' => 'Moreira',
	'PT130613' => 'São Pedro Fins',
	'PT130616' => 'Vila Nova da Telha',
	'PT130617' => 'Pedrouços',
	'PT130618' => 'Castêlo da Maia',
	'PT130619' => 'Cidade da Maia',
	'PT130620' => 'Nogueira e Silva Escura',
	'PT130704' => 'Banho e Carvalhosa',
	'PT130705' => 'Constance',
	'PT130722' => 'Soalhães',
	'PT130723' => 'Sobretâmega',
	'PT130724' => 'Tabuado',
	'PT130730' => 'Vila Boa do Bispo',
	'PT130732' => 'Alpendorada, Várzea e Torrão',
	'PT130733' => 'Avessadas e Rosém',
	'PT130734' => 'Bem Viver',
	'PT130735' => 'Santo Isidoro e Livração',
	'PT130736' => 'Marco',
	'PT130737' => 'Paredes de Viadores e Manhuncelos',
	'PT130738' => 'Penhalonga e Paços de Gaiolo',
	'PT130739' => 'Sande e São Lourenço do Douro',
	'PT130740' => 'Várzea, Aliviada e Folhada',
	'PT130741' => 'Vila Boa de Quires e Maureles',
	'PT130811' => 'Custóias, Leça do Balio e Guifões',
	'PT130812' => 'Matosinhos e Leça da Palmeira',
	'PT130813' => 'Perafita, Lavra e Santa Cruz do Bispo',
	'PT130814' => 'São Mamede de Infesta e Senhora da Hora',
	'PT130902' => 'Carvalhosa',
	'PT130904' => 'Eiriz',
	'PT130905' => 'Ferreira',
	'PT130906' => 'Figueiró',
	'PT130908' => 'Freamunde',
	'PT130910' => 'Meixomil',
	'PT130913' => 'Penamaior',
	'PT130914' => 'Raimonda',
	'PT130916' => 'Seroa',
	'PT130917' => 'Frazão Arreigada',
	'PT130918' => 'Paços de Ferreira',
	'PT130919' => 'Sanfins Lamoso Codessos',
	'PT131001' => 'Aguiar de Sousa',
	'PT131002' => 'Astromil',
	'PT131003' => 'Baltar',
	'PT131004' => 'Beire',
	'PT131008' => 'Cete',
	'PT131009' => 'Cristelo',
	'PT131010' => 'Duas Igrejas',
	'PT131011' => 'Gandra',
	'PT131013' => 'Lordelo',
	'PT131014' => 'Louredo',
	'PT131017' => 'Parada de Todeia',
	'PT131018' => 'Rebordosa',
	'PT131019' => 'Recarei',
	'PT131020' => 'Sobreira',
	'PT131021' => 'Sobrosa',
	'PT131022' => 'Vandoma',
	'PT131024' => 'Vilela',
	'PT131025' => 'Paredes',
	'PT131101' => 'Abragão',
	'PT131102' => 'Boelhe',
	'PT131103' => 'Bustelo',
	'PT131104' => 'Cabeça Santa',
	'PT131105' => 'Canelas',
	'PT131106' => 'Capela',
	'PT131107' => 'Castelões',
	'PT131108' => 'Croca',
	'PT131109' => 'Duas Igrejas',
	'PT131110' => 'Eja',
	'PT131112' => 'Fonte Arcada',
	'PT131113' => 'Galegos',
	'PT131115' => 'Irivo',
	'PT131121' => 'Oldrões',
	'PT131122' => 'Paço de Sousa',
	'PT131125' => 'Perozelo',
	'PT131128' => 'Rans',
	'PT131129' => 'Rio de Moinhos',
	'PT131132' => 'Recezinhos (São Mamede)',
	'PT131133' => 'Recezinhos (São Martinho)',
	'PT131134' => 'Sebolido',
	'PT131136' => 'Valpedre',
	'PT131138' => 'Rio Mau',
	'PT131139' => 'Penafiel',
	'PT131140' => 'Luzim e Vila Cova',
	'PT131141' => 'Guilhufe e Urrô',
	'PT131142' => 'Lagares e Figueira',
	'PT131143' => 'Termas de São Vicente',
	'PT131202' => 'Bonfim',
	'PT131203' => 'Campanhã',
	'PT131210' => 'Paranhos',
	'PT131211' => 'Ramalde',
	'PT131216' => 'Aldoar, Foz do Douro e Nevogilde',
	'PT131217' => 'Cedofeita, Santo Ildefonso, Sé, Miragaia, São Nicolau e Vitória',
	'PT131218' => 'Lordelo do Ouro e Massarelos',
	'PT131305' => 'Balazar',
	'PT131307' => 'Estela',
	'PT131308' => 'Laundos',
	'PT131311' => 'Rates',
	'PT131313' => 'Aver-o-Mar, Amorim e Terroso',
	'PT131314' => 'Aguçadoura e Navais',
	'PT131315' => 'União das freguesias da Póvoa de Varzim, Beiriz e Argivai',
	'PT131401' => 'Agrela',
	'PT131402' => 'Água Longa',
	'PT131405' => 'Aves',
	'PT131413' => 'Monte Córdova',
	'PT131416' => 'Rebordões',
	'PT131418' => 'Reguenga',
	'PT131419' => 'Roriz',
	'PT131430' => 'Negrelos (São Tomé)',
	'PT131432' => 'Vilarinho',
	'PT131433' => 'Areias, Sequeiró, Lama e Palmeira',
	'PT131434' => 'Campo (São Martinho), São Salvador do Campo e Negrelos (São Mamede)',
	'PT131435' => 'Carreira e Refojos de Riba de Ave',
	'PT131436' => 'Lamelas e Guimarei',
	'PT131437' => 'Santo Tirso, Couto (Santa Cristina e São Miguel) e Burgães',
	'PT131501' => 'Alfena',
	'PT131503' => 'Ermesinde',
	'PT131505' => 'Valongo',
	'PT131506' => 'Campo e Sobrado',
	'PT131602' => 'Árvore',
	'PT131603' => 'Aveleda',
	'PT131604' => 'Azurara',
	'PT131607' => 'Fajozes',
	'PT131610' => 'Gião',
	'PT131611' => 'Guilhabreu',
	'PT131612' => 'Junqueira',
	'PT131613' => 'Labruge',
	'PT131614' => 'Macieira da Maia',
	'PT131616' => 'Mindelo',
	'PT131617' => 'Modivas',
	'PT131627' => 'Vila Chã',
	'PT131628' => 'Vila do Conde',
	'PT131630' => 'Vilar de Pinheiro',
	'PT131631' => 'Bagunte, Ferreiró, Outeiro Maior e Parada',
	'PT131632' => 'Fornelo e Vairão',
	'PT131633' => 'Malta e Canidelo',
	'PT131634' => 'Retorta e Tougues',
	'PT131635' => 'Rio Mau e Arcos',
	'PT131636' => 'Touguinha e Touguinhó',
	'PT131637' => 'Vilar e Mosteiró',
	'PT131701' => 'Arcozelo',
	'PT131702' => 'Avintes',
	'PT131703' => 'Canelas',
	'PT131704' => 'Canidelo',
	'PT131709' => 'Madalena',
	'PT131712' => 'Oliveira do Douro',
	'PT131717' => 'São Félix da Marinha',
	'PT131723' => 'Vilar de Andorinho',
	'PT131725' => 'Grijó e Sermonde',
	'PT131726' => 'Gulpilhares e Valadares',
	'PT131727' => 'Mafamude e Vilar do Paraíso',
	'PT131728' => 'Pedroso e Seixezelo',
	'PT131729' => 'Sandim, Olival, Lever e Crestuma',
	'PT131730' => 'Santa Marinha e São Pedro da Afurada',
	'PT131731' => 'Serzedo e Perosinho',
	'PT131806' => 'Covelas',
	'PT131808' => 'Muro',
	'PT131809' => 'Alvarelhos e Guidões',
	'PT131810' => 'Bougado (São Martinho e Santiago)',
	'PT131811' => 'Coronado (São Romão e São Mamede)',
	'PT140104' => 'Bemposta',
	'PT140105' => 'Martinchel',
	'PT140106' => 'Mouriscas',
	'PT140107' => 'Pego',
	'PT140108' => 'Rio de Moinhos',
	'PT140115' => 'Tramagal',
	'PT140118' => 'Fontes',
	'PT140119' => 'Carvalhal',
	'PT140120' => 'Abrantes (São Vicente e São João) e Alferrarede',
	'PT140121' => 'Aldeia do Mato e Souto',
	'PT140122' => 'Alvega e Concavada',
	'PT140123' => 'São Facundo e Vale das Mós',
	'PT140124' => 'São Miguel do Rio Torto e Rossio ao Sul do Tejo',
	'PT140202' => 'Bugalhos',
	'PT140206' => 'Minde',
	'PT140207' => 'Moitas Venda',
	'PT140208' => 'Monsanto',
	'PT140209' => 'Serra de Santo António',
	'PT140211' => 'Alcanena e Vila Moreira',
	'PT140212' => 'Malhou, Louriceira e Espinheiro',
	'PT140301' => 'Almeirim',
	'PT140302' => 'Benfica do Ribatejo',
	'PT140303' => 'Fazendas de Almeirim',
	'PT140304' => 'Raposa',
	'PT140401' => 'Alpiarça',
	'PT140501' => 'Benavente',
	'PT140502' => 'Samora Correia',
	'PT140503' => 'Santo Estêvão',
	'PT140504' => 'Barrosa',
	'PT140604' => 'Pontével',
	'PT140605' => 'Valada',
	'PT140607' => 'Vila Chã de Ourique',
	'PT140608' => 'Vale da Pedra',
	'PT140609' => 'União das freguesias do Cartaxo e Vale da Pinta',
	'PT140610' => 'Ereira e Lapa',
	'PT140704' => 'Ulme',
	'PT140705' => 'Vale de Cavalos',
	'PT140707' => 'Carregueira',
	'PT140708' => 'União das freguesias da Chamusca e Pinheiro Grande',
	'PT140709' => 'Parreira e Chouto',
	'PT140801' => 'Constância',
	'PT140802' => 'Montalvo',
	'PT140803' => 'Santa Margarida da Coutada',
	'PT140902' => 'Couço',
	'PT140903' => 'São José da Lamarosa',
	'PT140905' => 'Branca',
	'PT140907' => 'Biscainho',
	'PT140908' => 'Santana do Mato',
	'PT140909' => 'Coruche, Fajarda e Erra',
	'PT141001' => 'São João Baptista',
	'PT141002' => 'Nossa Senhora de Fátima',
	'PT141101' => 'Águas Belas',
	'PT141103' => 'Beco',
	'PT141104' => 'Chãos',
	'PT141106' => 'Ferreira do Zêzere',
	'PT141107' => 'Igreja Nova do Sobral',
	'PT141110' => 'Nossa Senhora do Pranto',
	'PT141111' => 'Areias e Pias',
	'PT141201' => 'Azinhaga',
	'PT141202' => 'Golegã',
	'PT141203' => 'Pombalinho',
	'PT141302' => 'Amêndoa',
	'PT141303' => 'Cardigos',
	'PT141304' => 'Carvoeiro',
	'PT141305' => 'Envendos',
	'PT141307' => 'Ortiga',
	'PT141309' => 'Mação, Penhascoso e Aboboreira',
	'PT141401' => 'Alcobertas',
	'PT141402' => 'Arrouquelas',
	'PT141405' => 'Fráguas',
	'PT141408' => 'Rio Maior',
	'PT141410' => 'Asseiceira',
	'PT141411' => 'São Sebastião',
	'PT141415' => 'Azambujeira e Malaqueijo',
	'PT141416' => 'Marmeleira e Assentiz',
	'PT141417' => 'Outeiro da Cortiçada e Arruda dos Pisões',
	'PT141418' => 'São João da Ribeira e Ribeira de São João',
	'PT141502' => 'Marinhais',
	'PT141503' => 'Muge',
	'PT141507' => 'Glória do Ribatejo e Granho',
	'PT141508' => 'Salvaterra de Magos e Foros de Salvaterra',
	'PT141601' => 'Abitureiras',
	'PT141602' => 'Abrã',
	'PT141604' => 'Alcanede',
	'PT141605' => 'Alcanhões',
	'PT141606' => 'Almoster',
	'PT141607' => 'Amiais de Baixo',
	'PT141608' => 'Arneiro das Milhariças',
	'PT141613' => 'Moçarria',
	'PT141614' => 'Pernes',
	'PT141616' => 'Póvoa da Isenta',
	'PT141625' => 'Vale de Santarém',
	'PT141628' => 'Gançaria',
	'PT141629' => 'Achete, Azoia de Baixo e Póvoa de Santarém',
	'PT141630' => 'Azoia de Cima e Tremês',
	'PT141631' => 'Casével e Vaqueiros',
	'PT141632' => 'Romeira e Várzea',
	'PT141633' => 'Santarém (Marvila), Santa Iria da Ribeira de Santarém, Santarém (São Salvador) e Santarém (São Nicolau)',
	'PT141634' => 'São Vicente do Paul e Vale de Figueira',
	'PT141701' => 'Alcaravela',
	'PT141702' => 'Santiago de Montalegre',
	'PT141703' => 'Sardoal',
	'PT141704' => 'Valhascos',
	'PT141802' => 'Asseiceira',
	'PT141804' => 'Carregueiros',
	'PT141808' => 'Olalhas',
	'PT141809' => 'Paialvo',
	'PT141813' => 'São Pedro de Tomar',
	'PT141814' => 'Sabacheira',
	'PT141817' => 'Além da Ribeira e Pedreira',
	'PT141818' => 'Casais e Alviobeira',
	'PT141819' => 'Madalena e Beselga',
	'PT141820' => 'Serra e Junceira',
	'PT141821' => 'Tomar (São João Baptista) e Santa Maria dos Olivais',
	'PT141902' => 'Assentiz',
	'PT141904' => 'Chancelaria',
	'PT141909' => 'Pedrógão',
	'PT141910' => 'Riachos',
	'PT141916' => 'Zibreira',
	'PT141917' => 'Meia Via',
	'PT141918' => 'Brogueira, Parceiros de Igreja e Alcorochel',
	'PT141919' => 'Olaia e Paço',
	'PT141920' => 'Torres Novas (Santa Maria, Salvador e Santiago)',
	'PT141921' => 'Torres Novas (São Pedro), Lapas e Ribeira Branca',
	'PT142001' => 'Atalaia',
	'PT142002' => 'Praia do Ribatejo',
	'PT142003' => 'Tancos',
	'PT142006' => 'Vila Nova da Barquinha',
	'PT142101' => 'Alburitel',
	'PT142102' => 'Atouguia',
	'PT142104' => 'Caxarias',
	'PT142105' => 'Espite',
	'PT142106' => 'Fátima',
	'PT142111' => 'Nossa Senhora das Misericórdias',
	'PT142113' => 'Seiça',
	'PT142114' => 'Urqueira',
	'PT142115' => 'Nossa Senhora da Piedade',
	'PT142119' => 'Freixianda, Ribeira do Fárrio e Formigais',
	'PT142120' => 'Gondemaria e Olival',
	'PT142121' => 'Matas e Cercal',
	'PT142122' => 'Rio de Couros e Casal dos Bernardos',
	'PT150104' => 'Torrão',
	'PT150105' => 'São Martinho',
	'PT150106' => 'Comporta',
	'PT150107' => 'Alcácer do Sal (Santa Maria do Castelo e Santiago) e Santa Susana',
	'PT150201' => 'Alcochete',
	'PT150202' => 'Samouco',
	'PT150203' => 'São Francisco',
	'PT150303' => 'Costa da Caparica',
	'PT150312' => 'Almada, Cova da Piedade, Pragal e Cacilhas',
	'PT150313' => 'Caparica e Trafaria',
	'PT150314' => 'Charneca de Caparica e Sobreda',
	'PT150315' => 'Laranjeiro e Feijó',
	'PT150407' => 'Santo António da Charneca',
	'PT150409' => 'Alto do Seixalinho, Santo André e Verderena',
	'PT150410' => 'Barreiro e Lavradio',
	'PT150411' => 'Palhais e Coina',
	'PT150501' => 'Azinheira dos Barros e São Mamede do Sádão',
	'PT150503' => 'Melides',
	'PT150505' => 'Carvalhal',
	'PT150506' => 'Grândola e Santa Margarida da Serra',
	'PT150601' => 'Alhos Vedros',
	'PT150603' => 'Moita',
	'PT150607' => 'Baixa da Banheira e Vale da Amoreira',
	'PT150608' => 'Gaio-Rosário e Sarilhos Pequenos',
	'PT150701' => 'Canha',
	'PT150704' => 'Sarilhos Grandes',
	'PT150709' => 'Atalaia e Alto Estanqueiro-Jardia',
	'PT150710' => 'Montijo e Afonsoeiro',
	'PT150711' => 'Pegões',
	'PT150802' => 'Palmela',
	'PT150803' => 'Pinhal Novo',
	'PT150804' => 'Quinta do Anjo',
	'PT150806' => 'Poceirão e Marateca',
	'PT150901' => 'Abela',
	'PT150902' => 'Alvalade',
	'PT150903' => 'Cercal',
	'PT150904' => 'Ermidas-Sado',
	'PT150907' => 'Santo André',
	'PT150910' => 'São Francisco da Serra',
	'PT150912' => 'Santiago do Cacém, Santa Cruz e São Bartolomeu da Serra',
	'PT150913' => 'São Domingos e Vale de Água',
	'PT151002' => 'Amora',
	'PT151005' => 'Corroios',
	'PT151006' => 'Fernão Ferro',
	'PT151007' => 'União das freguesias do Seixal, Arrentela e Aldeia de Paio Pires',
	'PT151101' => 'Sesimbra (Castelo)',
	'PT151102' => 'Sesimbra (Santiago)',
	'PT151103' => 'Quinta do Conde',
	'PT151205' => 'Setúbal (São Sebastião)',
	'PT151207' => 'Gâmbia-Pontes-Alto da Guerra',
	'PT151208' => 'Sado',
	'PT151209' => 'Azeitão (São Lourenço e São Simão)',
	'PT151210' => 'Setúbal (São Julião, Nossa Senhora da Anunciada e Santa Maria da Graça)',
	'PT151301' => 'Sines',
	'PT151302' => 'Porto Covo',
	'PT160101' => 'Aboim das Choças',
	'PT160102' => 'Aguiã',
	'PT160104' => 'Ázere',
	'PT160105' => 'Cabana Maior',
	'PT160106' => 'Cabreiro',
	'PT160108' => 'Cendufe',
	'PT160109' => 'Couto',
	'PT160113' => 'Gavieira',
	'PT160115' => 'Gondoriz',
	'PT160121' => 'Miranda',
	'PT160122' => 'Monte Redondo',
	'PT160123' => 'Oliveira',
	'PT160124' => 'Paçô',
	'PT160125' => 'Padroso',
	'PT160128' => 'Prozelo',
	'PT160130' => 'Rio Frio',
	'PT160131' => 'Rio de Moinhos',
	'PT160133' => 'Sabadim',
	'PT160142' => 'Jolda (São Paio)',
	'PT160144' => 'Senharei',
	'PT160145' => 'Sistelo',
	'PT160146' => 'Soajo',
	'PT160149' => 'Vale',
	'PT160152' => 'Alvora e Loureda',
	'PT160153' => 'Arcos de Valdevez (São Paio) e Giela',
	'PT160154' => 'Arcos de Valdevez (Salvador), Vila Fonche e Parada',
	'PT160155' => 'Eiras e Mei',
	'PT160156' => 'Grade e Carralcova',
	'PT160157' => 'Guilhadeses e Santar',
	'PT160158' => 'Jolda (Madalena) e Rio Cabrão',
	'PT160159' => 'Padreiro (Salvador e Santa Cristina)',
	'PT160160' => 'Portela e Extremo',
	'PT160161' => 'São Jorge e Ermelo',
	'PT160162' => 'Souto e Tabaçô',
	'PT160163' => 'Távora (Santa Maria e São Vicente)',
	'PT160164' => 'Vilela, São Cosme e São Damião e Sá',
	'PT160201' => 'Âncora',
	'PT160205' => 'Argela',
	'PT160209' => 'Dem',
	'PT160211' => 'Lanhelas',
	'PT160214' => 'Riba de Âncora',
	'PT160215' => 'Seixas',
	'PT160217' => 'Vila Praia de Âncora',
	'PT160218' => 'Vilar de Mouros',
	'PT160220' => 'Vile',
	'PT160221' => 'Arga (Baixo, Cima e São João)',
	'PT160222' => 'Caminha (Matriz) e Vilarelho',
	'PT160223' => 'Gondar e Orbacém',
	'PT160224' => 'Moledo e Cristelo',
	'PT160225' => 'Venade e Azevedo',
	'PT160301' => 'Alvaredo',
	'PT160304' => 'Cousso',
	'PT160305' => 'Cristoval',
	'PT160307' => 'Fiães',
	'PT160308' => 'Gave',
	'PT160311' => 'Paderne',
	'PT160313' => 'Penso',
	'PT160317' => 'São Paio',
	'PT160319' => 'Castro Laboreiro e Lamas de Mouro',
	'PT160320' => 'Chaviães e Paços',
	'PT160321' => 'Parada do Monte e Cubalhão',
	'PT160322' => 'Prado e Remoães',
	'PT160323' => 'Vila e Roussas',
	'PT160401' => 'Abedim',
	'PT160404' => 'Barbeita',
	'PT160405' => 'Barroças e Taias',
	'PT160406' => 'Bela',
	'PT160407' => 'Cambeses',
	'PT160410' => 'Lara',
	'PT160411' => 'Longos Vales',
	'PT160415' => 'Merufe',
	'PT160418' => 'Moreira',
	'PT160420' => 'Pias',
	'PT160421' => 'Pinheiros',
	'PT160422' => 'Podame',
	'PT160423' => 'Portela',
	'PT160424' => 'Riba de Mouro',
	'PT160427' => 'Segude',
	'PT160428' => 'Tangil',
	'PT160431' => 'Trute',
	'PT160434' => 'Anhões e Luzio',
	'PT160435' => 'Ceivães e Badim',
	'PT160436' => 'Mazedo e Cortes',
	'PT160437' => 'Messegães, Valadares e Sá',
	'PT160438' => 'Monção e Troviscoso',
	'PT160439' => 'Sago, Lordelo e Parada',
	'PT160440' => 'Troporiz e Lapela',
	'PT160501' => 'Agualonga',
	'PT160503' => 'Castanheira',
	'PT160505' => 'Coura',
	'PT160507' => 'Cunha',
	'PT160510' => 'Infesta',
	'PT160513' => 'Mozelos',
	'PT160514' => 'Padornelo',
	'PT160515' => 'Parada',
	'PT160519' => 'Romarigães',
	'PT160520' => 'Rubiães',
	'PT160521' => 'Vascões',
	'PT160522' => 'Bico e Cristelo',
	'PT160523' => 'Cossourado e Linhares',
	'PT160524' => 'Formariz e Ferreira',
	'PT160525' => 'Insalde e Porreiras',
	'PT160526' => 'Paredes de Coura e Resende',
	'PT160601' => 'Azias',
	'PT160602' => 'Boivães',
	'PT160603' => 'Bravães',
	'PT160604' => 'Britelo',
	'PT160606' => 'Cuide de Vila Verde',
	'PT160611' => 'Lavradas',
	'PT160612' => 'Lindoso',
	'PT160613' => 'Nogueira',
	'PT160614' => 'Oleiros',
	'PT160619' => 'Sampriz',
	'PT160623' => 'Vade (São Pedro)',
	'PT160624' => 'Vade (São Tomé)',
	'PT160626' => 'Crasto, Ruivos e Grovelas',
	'PT160627' => 'Entre Ambos-os-Rios, Ermida e Germil',
	'PT160628' => 'Ponte da Barca, Vila Nova de Muía e Paço Vedro de Magalhães',
	'PT160629' => 'Touvedo (São Lourenço e Salvador)',
	'PT160630' => 'Vila Chã (São João Baptista e Santiago)',
	'PT160701' => 'Anais',
	'PT160703' => 'São Pedro dArcos',
	'PT160704' => 'Arcozelo',
	'PT160707' => 'Beiral do Lima',
	'PT160708' => 'Bertiandos',
	'PT160709' => 'Boalhosa',
	'PT160710' => 'Brandara',
	'PT160713' => 'Calheiros',
	'PT160714' => 'Calvelo',
	'PT160716' => 'Correlhã',
	'PT160717' => 'Estorãos',
	'PT160718' => 'Facha',
	'PT160719' => 'Feitosa',
	'PT160721' => 'Fontão',
	'PT160724' => 'Friastelas',
	'PT160726' => 'Gandra',
	'PT160727' => 'Gemieira',
	'PT160728' => 'Gondufe',
	'PT160729' => 'Labruja',
	'PT160734' => 'Poiares',
	'PT160737' => 'Refóios do Lima',
	'PT160739' => 'Ribeira',
	'PT160740' => 'Sá',
	'PT160742' => 'Santa Comba',
	'PT160743' => 'Santa Cruz do Lima',
	'PT160744' => 'Rebordões (Santa Maria)',
	'PT160745' => 'Seara',
	'PT160746' => 'Serdedelo',
	'PT160747' => 'Rebordões (Souto)',
	'PT160750' => 'Vitorino das Donas',
	'PT160752' => 'Arca e Ponte de Lima',
	'PT160753' => 'Ardegão, Freixo e Mato',
	'PT160754' => 'Associação de freguesias do Vale do Neiva',
	'PT160755' => 'Bárrio e Cepões',
	'PT160756' => 'Cabaços e Fojo Lobal',
	'PT160757' => 'Cabração e Moreira do Lima',
	'PT160758' => 'Fornelos e Queijada',
	'PT160759' => 'Labrujó, Rendufe e Vilar do Monte',
	'PT160760' => 'Navió e Vitorino dos Piães',
	'PT160802' => 'Boivão',
	'PT160803' => 'Cerdal',
	'PT160805' => 'Fontoura',
	'PT160806' => 'Friestas',
	'PT160808' => 'Ganfei',
	'PT160812' => 'São Pedro da Torre',
	'PT160816' => 'Verdoejo',
	'PT160817' => 'Gandra e Taião',
	'PT160818' => 'Gondomil e Sanfins',
	'PT160819' => 'São Julião e Silva',
	'PT160820' => 'Valença, Cristelo Covo e Arão',
	'PT160901' => 'Afife',
	'PT160902' => 'Alvarães',
	'PT160903' => 'Amonde',
	'PT160904' => 'Anha',
	'PT160905' => 'Areosa',
	'PT160908' => 'Carreço',
	'PT160910' => 'Castelo do Neiva',
	'PT160911' => 'Darque',
	'PT160914' => 'Freixieiro de Soutelo',
	'PT160915' => 'Lanheses',
	'PT160920' => 'Montaria',
	'PT160922' => 'Mujães',
	'PT160923' => 'São Romão de Neiva',
	'PT160925' => 'Outeiro',
	'PT160926' => 'Perre',
	'PT160928' => 'Santa Marta de Portuzelo',
	'PT160935' => 'Vila Franca',
	'PT160938' => 'Vila de Punhe',
	'PT160940' => 'Chafé',
	'PT160941' => 'Barroselas e Carvoeiro',
	'PT160942' => 'Cardielos e Serreleis',
	'PT160943' => 'Geraz do Lima (Santa Maria, Santa Leocádia e Moreira) e Deão',
	'PT160944' => 'Mazarefes e Vila Fria',
	'PT160945' => 'Nogueira, Meixedo e Vilar de Murteda',
	'PT160946' => 'Subportela, Deocriste e Portela Susã',
	'PT160947' => 'Torre e Vila Mou',
	'PT160948' => 'Viana do Castelo (Santa Maria Maior e Monserrate) e Meadela',
	'PT161003' => 'Cornes',
	'PT161004' => 'Covas',
	'PT161006' => 'Gondarém',
	'PT161007' => 'Loivo',
	'PT161009' => 'Mentrestido',
	'PT161012' => 'Sapardos',
	'PT161013' => 'Sopo',
	'PT161016' => 'Campos e Vila Meã',
	'PT161017' => 'Candemil e Gondar',
	'PT161018' => 'Reboreda e Nogueira',
	'PT161019' => 'Vila Nova de Cerveira e Lovelhe',
	'PT170101' => 'Alijó',
	'PT170107' => 'Favaios',
	'PT170108' => 'Pegarinhos',
	'PT170109' => 'Pinhão',
	'PT170112' => 'Sanfins do Douro',
	'PT170113' => 'Santa Eugénia',
	'PT170114' => 'São Mamede de Ribatua',
	'PT170116' => 'Vila Chã',
	'PT170117' => 'Vila Verde',
	'PT170118' => 'Vilar de Maçada',
	'PT170120' => 'Carlão e Amieiro',
	'PT170121' => 'Castedo e Cotas',
	'PT170122' => 'Pópulo e Ribalonga',
	'PT170123' => 'Vale de Mendiz, Casal de Loivos e Vilarinho de Cotas',
	'PT170203' => 'Beça',
	'PT170208' => 'Covas do Barroso',
	'PT170210' => 'Dornelas',
	'PT170213' => 'Pinho',
	'PT170215' => 'Sapiãos',
	'PT170217' => 'Alturas do Barroso e Cerdedo',
	'PT170218' => 'Ardãos e Bobadela',
	'PT170219' => 'Boticas e Granja',
	'PT170220' => 'Codessoso, Curros e Fiães do Tâmega',
	'PT170221' => 'Vilar e Viveiro',
	'PT170301' => 'Águas Frias',
	'PT170302' => 'Anelhe',
	'PT170305' => 'Bustelo',
	'PT170309' => 'Cimo de Vila da Castanheira',
	'PT170310' => 'Curalha',
	'PT170312' => 'Ervededo',
	'PT170313' => 'Faiões',
	'PT170314' => 'Lama de Arcos',
	'PT170316' => 'Mairos',
	'PT170317' => 'Moreiras',
	'PT170318' => 'Nogueira da Montanha',
	'PT170320' => 'Oura',
	'PT170321' => 'Outeiro Seco',
	'PT170322' => 'Paradela',
	'PT170324' => 'Redondelo',
	'PT170327' => 'Sanfins',
	'PT170329' => 'Santa Leocádia',
	'PT170330' => 'Santo António de Monforte',
	'PT170331' => 'Santo Estêvão',
	'PT170333' => 'São Pedro de Agostém',
	'PT170334' => 'São Vicente',
	'PT170340' => 'Tronco',
	'PT170341' => 'Vale de Anta',
	'PT170343' => 'Vila Verde da Raia',
	'PT170344' => 'Vilar de Nantes',
	'PT170345' => 'Vilarelho da Raia',
	'PT170347' => 'Vilas Boas',
	'PT170348' => 'Vilela Seca',
	'PT170349' => 'Vilela do Tâmega',
	'PT170350' => 'Santa Maria Maior',
	'PT170353' => 'Planalto de Monforte (Oucidres e Bobadela)',
	'PT170354' => 'União das freguesias da Madalena e Samaiões',
	'PT170355' => 'União das freguesias das Eiras, São Julião de Montenegro e Cela',
	'PT170356' => 'Calvão e Soutelinho da Raia',
	'PT170357' => 'Loivos e Póvoa de Agrações',
	'PT170358' => 'Santa Cruz/Trindade e Sanjurge',
	'PT170359' => 'Soutelo e Seara Velha',
	'PT170360' => 'Travancas e Roriz',
	'PT170361' => 'Vidago (Vidago, Arcossó, Selhariz e Vilarinho das Paranheiras)',
	'PT170401' => 'Barqueiros',
	'PT170402' => 'Cidadelhe',
	'PT170403' => 'Oliveira',
	'PT170407' => 'Vila Marim',
	'PT170408' => 'Mesão Frio (Santo André)',
	'PT170501' => 'Atei',
	'PT170502' => 'Bilhó',
	'PT170505' => 'Mondim de Basto',
	'PT170508' => 'Vilar de Ferreiros',
	'PT170509' => 'Campanhó e Paradança',
	'PT170510' => 'Ermelo e Pardelhas',
	'PT170601' => 'Cabril',
	'PT170603' => 'Cervos',
	'PT170604' => 'Chã',
	'PT170607' => 'Covelo do Gerês',
	'PT170609' => 'Ferral',
	'PT170612' => 'Gralhas',
	'PT170616' => 'Morgade',
	'PT170618' => 'Negrões',
	'PT170619' => 'Outeiro',
	'PT170623' => 'Pitões das Junias',
	'PT170625' => 'Reigoso',
	'PT170626' => 'Salto',
	'PT170627' => 'Santo André',
	'PT170629' => 'Sarraquinhos',
	'PT170631' => 'Solveira',
	'PT170632' => 'Tourém',
	'PT170635' => 'Vila da Ponte',
	'PT170636' => 'Cambeses do Rio, Donões e Mourilhe',
	'PT170637' => 'Meixedo e Padornelos',
	'PT170638' => 'Montalegre e Padroso',
	'PT170639' => 'Paradela, Contim e Fiães',
	'PT170640' => 'Sezelhe e Covelães',
	'PT170641' => 'Venda Nova e Pondras',
	'PT170642' => 'Viade de Baixo e Fervidelas',
	'PT170643' => 'Vilar de Perdizes e Meixide',
	'PT170701' => 'Candedo',
	'PT170703' => 'Fiolhoso',
	'PT170704' => 'Jou',
	'PT170705' => 'Murça',
	'PT170708' => 'Valongo de Milhais',
	'PT170710' => 'Carva e Vilares',
	'PT170711' => 'Noura e Palheiros',
	'PT170802' => 'Fontelas',
	'PT170805' => 'Loureiro',
	'PT170809' => 'Sedielos',
	'PT170810' => 'Vilarinho dos Freires',
	'PT170813' => 'Galafura e Covelinhas',
	'PT170814' => 'Moura Morta e Vinhós',
	'PT170815' => 'Peso da Régua e Godim',
	'PT170816' => 'Poiares e Canelas',
	'PT170901' => 'Alvadia',
	'PT170902' => 'Canedo',
	'PT170906' => 'Santa Marinha',
	'PT170908' => 'Cerva e Limões',
	'PT170909' => 'Ribeira de Pena (Salvador) e Santo Aleixo de Além-Tâmega',
	'PT171001' => 'Celeirós',
	'PT171002' => 'Covas do Douro',
	'PT171004' => 'Gouvinhas',
	'PT171005' => 'Parada de Pinhão',
	'PT171007' => 'Paços',
	'PT171009' => 'Sabrosa',
	'PT171011' => 'São Lourenço de Ribapinhão',
	'PT171013' => 'Souto Maior',
	'PT171014' => 'Torre do Pinhão',
	'PT171015' => 'Vilarinho de São Romão',
	'PT171016' => 'Provesende, Gouvães do Douro e São Cristóvão do Douro',
	'PT171017' => 'São Martinho de Antas e Paradela de Guiães',
	'PT171101' => 'Alvações do Corgo',
	'PT171102' => 'Cumieira',
	'PT171103' => 'Fontes',
	'PT171106' => 'Medrões',
	'PT171110' => 'Sever',
	'PT171111' => 'Lobrigos (São Miguel e São João Baptista) e Sanhoane',
	'PT171112' => 'Louredo e Fornelos',
	'PT171201' => 'Água Revés e Crasto',
	'PT171203' => 'Algeriz',
	'PT171205' => 'Bouçoães',
	'PT171206' => 'Canaveses',
	'PT171209' => 'Ervões',
	'PT171211' => 'Fornos do Pinhal',
	'PT171212' => 'Friões',
	'PT171215' => 'Padrela e Tazem',
	'PT171216' => 'Possacos',
	'PT171217' => 'Rio Torto',
	'PT171219' => 'Santa Maria de Emeres',
	'PT171220' => 'Santa Valha',
	'PT171221' => 'Santiago da Ribeira de Alhariz',
	'PT171222' => 'São João da Corveira',
	'PT171223' => 'São Pedro de Veiga de Lila',
	'PT171224' => 'Serapicos',
	'PT171227' => 'Vales',
	'PT171229' => 'Vassal',
	'PT171230' => 'Veiga de Lila',
	'PT171231' => 'Vilarandelo',
	'PT171232' => 'Carrazedo de Montenegro e Curros',
	'PT171233' => 'Lebução, Fiães e Nozelos',
	'PT171234' => 'Sonim e Barreiros',
	'PT171235' => 'Tinhela e Alvarelhos',
	'PT171236' => 'Valpaços e Sanfins',
	'PT171302' => 'Alfarela de Jales',
	'PT171303' => 'Bornes de Aguiar',
	'PT171304' => 'Bragado',
	'PT171305' => 'Capeludos',
	'PT171310' => 'Soutelo de Aguiar',
	'PT171311' => 'Telões',
	'PT171312' => 'Tresminas',
	'PT171313' => 'Valoura',
	'PT171314' => 'Vila Pouca de Aguiar',
	'PT171315' => 'Vreia de Bornes',
	'PT171316' => 'Vreia de Jales',
	'PT171317' => 'Sabroso de Aguiar',
	'PT171319' => 'Alvão',
	'PT171320' => 'Pensalvos e Parada de Monteiros',
	'PT171401' => 'Abaças',
	'PT171403' => 'Andrães',
	'PT171404' => 'Arroios',
	'PT171406' => 'Campeã',
	'PT171409' => 'Folhadela',
	'PT171410' => 'Guiães',
	'PT171414' => 'Lordelo',
	'PT171415' => 'Mateus',
	'PT171416' => 'Mondrões',
	'PT171420' => 'Parada de Cunhos',
	'PT171426' => 'Torgueda',
	'PT171429' => 'Vila Marim',
	'PT171431' => 'Adoufe e Vilarinho de Samardã',
	'PT171432' => 'Borbela e Lamas de Olo',
	'PT171433' => 'Constantim e Vale de Nogueiras',
	'PT171434' => 'Mouçós e Lamares',
	'PT171435' => 'Nogueira e Ermida',
	'PT171436' => 'Pena, Quintã e Vila Cova',
	'PT171437' => 'São Tomé do Castelo e Justes',
	'PT171438' => 'Vila Real (Nossa Senhora da Conceição, São Pedro e São Dinis)',
	'PT180101' => 'Aldeias',
	'PT180104' => 'Cimbres',
	'PT180106' => 'Folgosa',
	'PT180107' => 'Fontelo',
	'PT180109' => 'Queimada',
	'PT180110' => 'Queimadela',
	'PT180111' => 'Santa Cruz',
	'PT180114' => 'São Cosmado',
	'PT180115' => 'São Martinho das Chãs',
	'PT180118' => 'Vacalar',
	'PT180120' => 'Armamar',
	'PT180121' => 'Aricera e Goujoim',
	'PT180122' => 'São Romão e Santiago',
	'PT180123' => 'Vila Seca e Santo Adrião',
	'PT180201' => 'Beijós',
	'PT180202' => 'Cabanas de Viriato',
	'PT180204' => 'Oliveira do Conde',
	'PT180206' => 'Parada',
	'PT180208' => 'Currelos, Papízios e Sobral',
	'PT180301' => 'Almofala',
	'PT180303' => 'Cabril',
	'PT180304' => 'Castro Daire',
	'PT180305' => 'Cujó',
	'PT180309' => 'Gosende',
	'PT180312' => 'Mões',
	'PT180313' => 'Moledo',
	'PT180314' => 'Monteiras',
	'PT180317' => 'Pepim',
	'PT180319' => 'Pinheiro',
	'PT180322' => 'São Joaninho',
	'PT180323' => 'Mamouros, Alva e Ribolhos',
	'PT180324' => 'Mezio e Moura Morta',
	'PT180325' => 'Parada de Ester e Ester',
	'PT180326' => 'Picão e Ermida',
	'PT180327' => 'Reriz e Gafanhão',
	'PT180403' => 'Cinfães',
	'PT180404' => 'Espadanedo',
	'PT180405' => 'Ferreiros de Tendais',
	'PT180406' => 'Fornelos',
	'PT180408' => 'Moimenta',
	'PT180409' => 'Nespereira',
	'PT180410' => 'Oliveira do Douro',
	'PT180412' => 'Santiago de Piães',
	'PT180413' => 'São Cristóvão de Nogueira',
	'PT180414' => 'Souselo',
	'PT180415' => 'Tarouquela',
	'PT180416' => 'Tendais',
	'PT180417' => 'Travanca',
	'PT180418' => 'Alhões, Bustelo, Gralheira e Ramires',
	'PT180502' => 'Avões',
	'PT180504' => 'Britiande',
	'PT180505' => 'Cambres',
	'PT180507' => 'Ferreirim',
	'PT180508' => 'Ferreiros de Avões',
	'PT180509' => 'Figueira',
	'PT180510' => 'Lalim',
	'PT180511' => 'Lazarim',
	'PT180516' => 'Penajóia',
	'PT180517' => 'Penude',
	'PT180519' => 'Samodães',
	'PT180520' => 'Sande',
	'PT180523' => 'Várzea de Abrunhais',
	'PT180524' => 'Vila Nova de Souto dEl-Rei',
	'PT180525' => 'Lamego (Almacave e Sé)',
	'PT180526' => 'Bigorne, Magueija e Pretarouca',
	'PT180527' => 'Cepões, Meijinhos e Melcões',
	'PT180528' => 'Parada do Bispo e Valdigem',
	'PT180601' => 'Abrunhosa-a-Velha',
	'PT180602' => 'Alcafache',
	'PT180605' => 'Cunha Baixa',
	'PT180606' => 'Espinho',
	'PT180607' => 'Fornos de Maceira Dão',
	'PT180608' => 'Freixiosa',
	'PT180614' => 'Quintela de Azurara',
	'PT180616' => 'São João da Fresta',
	'PT180619' => 'Mangualde, Mesquitela e Cunha Alta',
	'PT180620' => 'Moimenta de Maceira Dão e Lobelhe do Mato',
	'PT180621' => 'Santiago de Cassurrães e Póvoa de Cervães',
	'PT180622' => 'Tavares (Chãs, Várzea e Travanca)',
	'PT180702' => 'Alvite',
	'PT180703' => 'Arcozelos',
	'PT180705' => 'Baldos',
	'PT180706' => 'Cabaços',
	'PT180707' => 'Caria',
	'PT180708' => 'Castelo',
	'PT180709' => 'Leomil',
	'PT180710' => 'Moimenta da Beira',
	'PT180713' => 'Passô',
	'PT180716' => 'Rua',
	'PT180717' => 'Sarzedo',
	'PT180719' => 'Sever',
	'PT180720' => 'Vilar',
	'PT180721' => 'Paradinha e Nagosa',
	'PT180722' => 'Pêra Velha, Aldeia de Nacomba e Ariz',
	'PT180723' => 'Peva e Segões',
	'PT180802' => 'Cercosa',
	'PT180804' => 'Espinho',
	'PT180805' => 'Marmeleira',
	'PT180807' => 'Pala',
	'PT180808' => 'Sobral',
	'PT180809' => 'Trezói',
	'PT180811' => 'Mortágua, Vale de Remígio, Cortegaça e Almaça',
	'PT180901' => 'Canas de Senhorim',
	'PT180903' => 'Nelas',
	'PT180905' => 'Senhorim',
	'PT180906' => 'Vilar Seco',
	'PT180908' => 'Lapa do Lobo',
	'PT180910' => 'Carvalhal Redondo e Aguieira',
	'PT180911' => 'Santar e Moreira',
	'PT181002' => 'Arcozelo das Maias',
	'PT181005' => 'Pinheiro',
	'PT181007' => 'Ribeiradio',
	'PT181008' => 'São João da Serra',
	'PT181009' => 'São Vicente de Lafões',
	'PT181013' => 'Arca e Varzielas',
	'PT181014' => 'Destriz e Reigoso',
	'PT181015' => 'Oliveira de Frades, Souto de Lafões e Sejães',
	'PT181102' => 'Castelo de Penalva',
	'PT181103' => 'Esmolfe',
	'PT181104' => 'Germil',
	'PT181105' => 'Ínsua',
	'PT181106' => 'Lusinde',
	'PT181109' => 'Pindo',
	'PT181110' => 'Real',
	'PT181111' => 'Sezures',
	'PT181112' => 'Trancozelos',
	'PT181114' => 'Antas e Matela',
	'PT181115' => 'Vila Cova do Covelo/Mareco',
	'PT181202' => 'Beselga',
	'PT181203' => 'Castainço',
	'PT181207' => 'Penela da Beira',
	'PT181208' => 'Póvoa de Penela',
	'PT181209' => 'Souto',
	'PT181210' => 'Antas e Ourozinho',
	'PT181211' => 'Penedono e Granja',
	'PT181302' => 'Barrô',
	'PT181303' => 'Cárquere',
	'PT181310' => 'Paus',
	'PT181311' => 'Resende',
	'PT181312' => 'São Cipriano',
	'PT181313' => 'São João de Fontoura',
	'PT181314' => 'São Martinho de Mouros',
	'PT181316' => 'Anreade e São Romão de Aregos',
	'PT181317' => 'Felgueiras e Feirão',
	'PT181318' => 'Freigil e Miomães',
	'PT181319' => 'Ovadas e Panchorra',
	'PT181403' => 'Pinheiro de Ázere',
	'PT181405' => 'São Joaninho',
	'PT181406' => 'São João de Areias',
	'PT181410' => 'Ovoa e Vimieiro',
	'PT181411' => 'Santa Comba Dão e Couto do Mosteiro',
	'PT181412' => 'Treixedo e Nagozela',
	'PT181501' => 'Castanheiro do Sul',
	'PT181502' => 'Ervedosa do Douro',
	'PT181504' => 'Nagozelo do Douro',
	'PT181505' => 'Paredes da Beira',
	'PT181507' => 'Riodades',
	'PT181509' => 'Soutelo do Douro',
	'PT181511' => 'Vale de Figueira',
	'PT181512' => 'Valongo dos Azeites',
	'PT181515' => 'São João da Pesqueira e Várzea de Trevões',
	'PT181516' => 'Trevões e Espinhosa',
	'PT181517' => 'Vilarouco e Pereiros',
	'PT181602' => 'Bordonhos',
	'PT181606' => 'Figueiredo de Alva',
	'PT181607' => 'Manhouce',
	'PT181608' => 'Pindelo dos Milagres',
	'PT181609' => 'Pinho',
	'PT181612' => 'São Félix',
	'PT181615' => 'Serrazes',
	'PT181616' => 'Sul',
	'PT181617' => 'Valadares',
	'PT181619' => 'Vila Maior',
	'PT181620' => 'Carvalhais e Candal',
	'PT181621' => 'Santa Cruz da Trapa e São Cristóvão de Lafões',
	'PT181622' => 'São Martinho das Moitas e Covas do Rio',
	'PT181623' => 'São Pedro do Sul, Várzea e Baiões',
	'PT181702' => 'Avelal',
	'PT181704' => 'Ferreira de Aves',
	'PT181706' => 'Mioma',
	'PT181707' => 'Rio de Moinhos',
	'PT181709' => 'São Miguel de Vila Boa',
	'PT181710' => 'Sátão',
	'PT181711' => 'Silvã de Cima',
	'PT181713' => 'Águas Boas e Forles',
	'PT181714' => 'Romãs, Decermilo e Vila Longa',
	'PT181801' => 'Arnas',
	'PT181802' => 'Carregal',
	'PT181803' => 'Chosendo',
	'PT181804' => 'Cunha',
	'PT181806' => 'Faia',
	'PT181810' => 'Granjal',
	'PT181811' => 'Lamosa',
	'PT181814' => 'Quintela',
	'PT181817' => 'Vila da Ponte',
	'PT181818' => 'Ferreirim e Macieira',
	'PT181819' => 'Fonte Arcada e Escurquela',
	'PT181820' => 'Penso e Freixinho',
	'PT181821' => 'Sernancelhe e Sarzeda',
	'PT181901' => 'Adorigo',
	'PT181902' => 'Arcos',
	'PT181904' => 'Chavães',
	'PT181905' => 'Desejosa',
	'PT181906' => 'Granja do Tedo',
	'PT181908' => 'Longa',
	'PT181913' => 'Sendim',
	'PT181914' => 'Tabuaço',
	'PT181917' => 'Valença do Douro',
	'PT181918' => 'Barcos e Santa Leocádia',
	'PT181919' => 'Paradela e Granjinha',
	'PT181920' => 'Pinheiros e Vale de Figueira',
	'PT181921' => 'Távora e Pereiro',
	'PT182004' => 'Mondim da Beira',
	'PT182005' => 'Salzedas',
	'PT182006' => 'São João de Tarouca',
	'PT182009' => 'Várzea da Serra',
	'PT182011' => 'Gouviães e Ucanha',
	'PT182012' => 'Granja Nova e Vila Chã da Beira',
	'PT182013' => 'Tarouca e Dálvares',
	'PT182102' => 'Campo de Besteiros',
	'PT182103' => 'Canas de Santa Maria',
	'PT182105' => 'Castelões',
	'PT182106' => 'Dardavaz',
	'PT182107' => 'Ferreirós do Dão',
	'PT182108' => 'Guardão',
	'PT182109' => 'Lajeosa do Dão',
	'PT182110' => 'Lobão da Beira',
	'PT182111' => 'Molelos',
	'PT182116' => 'Parada de Gonta',
	'PT182118' => 'Santiago de Besteiros',
	'PT182122' => 'Tonda',
	'PT182127' => 'Barreiro de Besteiros e Tourigo',
	'PT182128' => 'Caparrosa e Silvares',
	'PT182129' => 'Mouraz e Vila Nova da Rainha',
	'PT182130' => 'São João do Monte e Mosteirinho',
	'PT182131' => 'São Miguel do Outeiro e Sabugosa',
	'PT182132' => 'Tondela e Nandufe',
	'PT182133' => 'Vilar de Besteiros e Mosteiro de Fráguas',
	'PT182203' => 'Pendilhe',
	'PT182204' => 'Queiriga',
	'PT182205' => 'Touro',
	'PT182206' => 'Vila Cova à Coelheira',
	'PT182208' => 'Vila Nova de Paiva, Alhais e Fráguas',
	'PT182301' => 'Abraveses',
	'PT182304' => 'Bodiosa',
	'PT182305' => 'Calde',
	'PT182306' => 'Campo',
	'PT182307' => 'Cavernães',
	'PT182310' => 'Cota',
	'PT182315' => 'Fragosela',
	'PT182316' => 'Lordosa',
	'PT182317' => 'Silgueiros',
	'PT182318' => 'Mundão',
	'PT182319' => 'Orgens',
	'PT182320' => 'Povolide',
	'PT182321' => 'Ranhados',
	'PT182322' => 'Ribafeita',
	'PT182323' => 'Rio de Loba',
	'PT182325' => 'Santos Evos',
	'PT182327' => 'São João de Lourosa',
	'PT182329' => 'São Pedro de France',
	'PT182335' => 'Barreiros e Cepões',
	'PT182336' => 'Boa Aldeia, Farminhão e Torredeita',
	'PT182337' => 'Couto de Baixo e Couto de Cima',
	'PT182338' => 'Faíl e Vila Chã de Sá',
	'PT182339' => 'Repeses e São Salvador',
	'PT182340' => 'São Cipriano e Vil de Souto',
	'PT182341' => 'Viseu',
	'PT182401' => 'Alcofra',
	'PT182403' => 'Campia',
	'PT182407' => 'Fornelo do Monte',
	'PT182409' => 'Queirã',
	'PT182410' => 'São Miguel do Mato',
	'PT182411' => 'Ventosa',
	'PT182413' => 'Cambra e Carvalhal de Vermilhas',
	'PT182414' => 'Fataunços e Figueiredo das Donas',
	'PT182415' => 'Vouzela e Paços de Vilharigues',
	'PT310101' => 'Arco da Calheta',
	'PT310102' => 'Calheta',
	'PT310103' => 'Estreito da Calheta',
	'PT310104' => 'Fajã da Ovelha',
	'PT310105' => 'Jardim do Mar',
	'PT310106' => 'Paul do Mar',
	'PT310107' => 'Ponta do Pargo',
	'PT310108' => 'Prazeres',
	'PT310201' => 'Câmara de Lobos',
	'PT310202' => 'Curral das Freiras',
	'PT310203' => 'Estreito de Câmara de Lobos',
	'PT310204' => 'Quinta Grande',
	'PT310205' => 'Jardim da Serra',
	'PT310301' => 'Imaculado Coração de Maria',
	'PT310302' => 'Monte',
	'PT310303' => 'Funchal (Santa Luzia)',
	'PT310304' => 'Funchal (Santa Maria Maior)',
	'PT310305' => 'Santo António',
	'PT310306' => 'São Gonçalo',
	'PT310307' => 'São Martinho',
	'PT310308' => 'Funchal (São Pedro)',
	'PT310309' => 'São Roque',
	'PT310310' => 'Funchal (Sé)',
	'PT310401' => 'Água de Pena',
	'PT310402' => 'Caniçal',
	'PT310403' => 'Machico',
	'PT310404' => 'Porto da Cruz',
	'PT310405' => 'Santo António da Serra',
	'PT310501' => 'Canhas',
	'PT310502' => 'Madalena do Mar',
	'PT310503' => 'Ponta do Sol',
	'PT310601' => 'Achadas da Cruz',
	'PT310602' => 'Porto Moniz',
	'PT310603' => 'Ribeira da Janela',
	'PT310604' => 'Seixal',
	'PT310701' => 'Campanário',
	'PT310702' => 'Ribeira Brava',
	'PT310703' => 'Serra de Água',
	'PT310704' => 'Tábua',
	'PT310802' => 'Camacha',
	'PT310803' => 'Caniço',
	'PT310804' => 'Gaula',
	'PT310805' => 'Santa Cruz',
	'PT310806' => 'Santo António da Serra',
	'PT310901' => 'Arco de São Jorge',
	'PT310902' => 'Faial',
	'PT310903' => 'Santana',
	'PT310904' => 'São Jorge',
	'PT310905' => 'São Roque do Faial',
	'PT310906' => 'Ilha',
	'PT311001' => 'Boa Ventura',
	'PT311002' => 'Ponta Delgada',
	'PT311003' => 'São Vicente',
	'PT320101' => 'Porto Santo',
	'PT410101' => 'Almagreira',
	'PT410102' => 'Santa Bárbara',
	'PT410103' => 'Santo Espírito',
	'PT410104' => 'São Pedro',
	'PT410105' => 'Vila do Porto',
	'PT420101' => 'Água de Pau',
	'PT420102' => 'Cabouco',
	'PT420103' => 'Lagoa (Nossa Senhora do Rosário)',
	'PT420104' => 'Lagoa (Santa Cruz)',
	'PT420105' => 'Ribeira Chã',
	'PT420201' => 'Achada',
	'PT420202' => 'Achadinha',
	'PT420203' => 'Lomba da Fazenda',
	'PT420204' => 'Nordeste',
	'PT420206' => 'Salga',
	'PT420207' => 'Santana',
	'PT420208' => 'Algarvia',
	'PT420209' => 'Santo António de Nordestinho',
	'PT420210' => 'São Pedro de Nordestinho',
	'PT420301' => 'Arrifes',
	'PT420303' => 'Candelária',
	'PT420304' => 'Capelas',
	'PT420305' => 'Covoada',
	'PT420306' => 'Fajã de Baixo',
	'PT420307' => 'Fajã de Cima',
	'PT420308' => 'Fenais da Luz',
	'PT420309' => 'Feteiras',
	'PT420310' => 'Ginetes',
	'PT420311' => 'Mosteiros',
	'PT420312' => 'Ponta Delgada (São Sebastião)',
	'PT420313' => 'Ponta Delgada (São José)',
	'PT420314' => 'Ponta Delgada (São Pedro)',
	'PT420315' => 'Relva',
	'PT420316' => 'Remédios',
	'PT420317' => 'Rosto do Cão (Livramento)',
	'PT420318' => 'Rosto do Cão (São Roque)',
	'PT420319' => 'Santa Bárbara',
	'PT420320' => 'Santo António',
	'PT420321' => 'São Vicente Ferreira',
	'PT420322' => 'Sete Cidades',
	'PT420323' => 'Ajuda da Bretanha',
	'PT420324' => 'Pilar da Bretanha',
	'PT420325' => 'Santa Clara',
	'PT420401' => 'Água Retorta',
	'PT420402' => 'Faial da Terra',
	'PT420403' => 'Furnas',
	'PT420404' => 'Nossa Senhora dos Remédios',
	'PT420405' => 'Povoação',
	'PT420406' => 'Ribeira Quente',
	'PT420501' => 'Calhetas',
	'PT420502' => 'Fenais da Ajuda',
	'PT420503' => 'Lomba da Maia',
	'PT420504' => 'Lomba de São Pedro',
	'PT420505' => 'Maia',
	'PT420506' => 'Pico da Pedra',
	'PT420507' => 'Porto Formoso',
	'PT420508' => 'Rabo de Peixe',
	'PT420509' => 'Ribeira Grande (Conceição)',
	'PT420510' => 'Ribeira Grande (Matriz)',
	'PT420511' => 'Ribeira Seca',
	'PT420512' => 'Ribeirinha',
	'PT420513' => 'Santa Bárbara',
	'PT420514' => 'São Brás',
	'PT420601' => 'Água de Alto',
	'PT420602' => 'Ponta Garça',
	'PT420603' => 'Ribeira das Tainhas',
	'PT420604' => 'Vila Franca do Campo (São Miguel)',
	'PT420605' => 'Vila Franca do Campo (São Pedro)',
	'PT420606' => 'Ribeira Seca',
	'PT430101' => 'Altares',
	'PT430102' => 'Angra (Nossa Senhora da Conceição)',
	'PT430103' => 'Angra (Santa Luzia)',
	'PT430104' => 'Angra (São Pedro)',
	'PT430105' => 'Angra (Sé)',
	'PT430106' => 'Cinco Ribeiras',
	'PT430107' => 'Doze Ribeiras',
	'PT430108' => 'Feteira',
	'PT430109' => 'Porto Judeu',
	'PT430110' => 'Posto Santo',
	'PT430111' => 'Raminho',
	'PT430112' => 'Ribeirinha',
	'PT430113' => 'Santa Bárbara',
	'PT430114' => 'São Bartolomeu de Regatos',
	'PT430115' => 'São Bento',
	'PT430116' => 'São Mateus da Calheta',
	'PT430117' => 'Serreta',
	'PT430118' => 'Terra Chã',
	'PT430119' => 'Vila de São Sebastião',
	'PT430201' => 'Agualva',
	'PT430202' => 'Biscoitos',
	'PT430203' => 'Cabo da Praia',
	'PT430204' => 'Fonte do Bastardo',
	'PT430205' => 'Fontinhas',
	'PT430206' => 'Lajes',
	'PT430207' => 'Praia da Vitória (Santa Cruz)',
	'PT430208' => 'Quatro Ribeiras',
	'PT430209' => 'São Brás',
	'PT430210' => 'Vila Nova',
	'PT430211' => 'Porto Martins',
	'PT440101' => 'Guadalupe',
	'PT440102' => 'Luz',
	'PT440103' => 'São Mateus',
	'PT440104' => 'Santa Cruz da Graciosa',
	'PT450101' => 'Calheta',
	'PT450102' => 'Norte Pequeno',
	'PT450103' => 'Ribeira Seca',
	'PT450104' => 'Santo Antão',
	'PT450105' => 'Topo (Nossa Senhora do Rosário)',
	'PT450201' => 'Manadas (Santa Bárbara)',
	'PT450202' => 'Norte Grande (Neves)',
	'PT450203' => 'Rosais',
	'PT450204' => 'Santo Amaro',
	'PT450205' => 'Urzelina (São Mateus)',
	'PT450206' => 'Velas (São Jorge)',
	'PT460101' => 'Calheta de Nesquim',
	'PT460102' => 'Lajes do Pico',
	'PT460103' => 'Piedade',
	'PT460104' => 'Ribeiras',
	'PT460105' => 'Ribeirinha',
	'PT460106' => 'São João',
	'PT460201' => 'Bandeiras',
	'PT460202' => 'Candelária',
	'PT460203' => 'Criação Velha',
	'PT460204' => 'Madalena',
	'PT460205' => 'São Caetano',
	'PT460206' => 'São Mateus',
	'PT460301' => 'Prainha',
	'PT460302' => 'Santa Luzia',
	'PT460303' => 'Santo Amaro',
	'PT460304' => 'Santo António',
	'PT460305' => 'São Roque do Pico',
	'PT470101' => 'Capelo',
	'PT470102' => 'Castelo Branco',
	'PT470103' => 'Cedros',
	'PT470104' => 'Feteira',
	'PT470105' => 'Flamengos',
	'PT470106' => 'Horta (Angústias)',
	'PT470107' => 'Horta (Conceição)',
	'PT470108' => 'Horta (Matriz)',
	'PT470109' => 'Pedro Miguel',
	'PT470110' => 'Praia do Almoxarife',
	'PT470111' => 'Praia do Norte',
	'PT470112' => 'Ribeirinha',
	'PT470113' => 'Salão',
	'PT480101' => 'Fajã Grande',
	'PT480102' => 'Fajãzinha',
	'PT480103' => 'Fazenda',
	'PT480104' => 'Lajedo',
	'PT480105' => 'Lajes das Flores',
	'PT480106' => 'Lomba',
	'PT480107' => 'Mosteiro',
	'PT480201' => 'Caveira',
	'PT480202' => 'Cedros',
	'PT480203' => 'Ponta Delgada',
	'PT480204' => 'Santa Cruz das Flores',
	'PT490101' => 'Corvo',
];
