<?php

/**
 * List of cities for: Palestine
 * Source: http://www.pcbs.gov.ps/pcbs_2012/Publications.aspx
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'PSJN' => _x( 'Jenin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSTB' => _x( 'Tubas & Northern Valleys', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSTK' => _x( 'Tulkarm', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSNB' => _x( 'Nablus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSQL' => _x( 'Qalqiliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSSL' => _x( 'Salfit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSRL' => _x( 'Ramallah & Al Bireh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSJR' => _x( 'Jericho & Al Aghwar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSJS' => _x( 'Jerusalem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSBL' => _x( 'Bethlehem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSHB' => _x( 'Hebron', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSNG' => _x( 'North Gaza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSGZ' => _x( 'Gaza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSDB' => _x( 'Dier Al Balah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSKY' => _x( 'Khan Yunis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	'PSRF' => _x( 'Rafah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'PSJN' => [
		'PS10005' => _x( 'Zububa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10010' => _x( 'Rummana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10015' => _x( 'Tiinnik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10020' => _x( 'At Tayba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10025' => _x( 'Arabbuna', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10030' => _x( 'Al Jalama', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10035' => _x( 'Silat al Harithiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10040' => _x( 'As Saaida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10045' => _x( 'Anin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10050' => _x( 'Arrana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10055' => _x( 'Deir Ghazala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10060' => _x( 'Faqqua', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10070' => _x( 'Khirbet Suruj', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10080' => _x( 'Al Yamun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10085' => _x( 'Umm ar Rihan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10095' => _x( 'Kafr Dan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10105' => _x( 'Khirbet Abdallah al Yunis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10110' => _x( 'Mashru Beit Qad (Ash Shamali)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10115' => _x( 'Dhaher al Malih', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10120' => _x( 'Bartaa ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10125' => _x( 'Al Araqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10135' => _x( 'Al Jameelat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10140' => _x( 'Beit Qad (Al Janubi)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10145' => _x( 'Tura al Gharbiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10150' => _x( 'Tura ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10155' => _x( 'Al Hashimiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10165' => _x( 'Nazlat ash Sheikh Zeid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10170' => _x( 'At Tarem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10175' => _x( 'Khirbet al Muntar al Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10180' => _x( 'Jenin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10185' => _x( 'Jenin Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10190' => _x( 'Jalbun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10195' => _x( 'Aba (Al Gharbiya)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10205' => _x( 'Khirbet al Muntar al Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10210' => _x( 'Kafr Qud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10215' => _x( 'Deir Abu Daif', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10220' => _x( 'Birqin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10225' => _x( 'Umm Dar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10230' => _x( 'Al Khuljan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10235' => _x( 'Wad ad Dabi (Aba ash Sharqiya)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10240' => _x( 'Dhaher al Abed', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10245' => _x( 'Zabda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10265' => _x( 'Yabad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10275' => _x( 'Kufeirit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10285' => _x( 'Imreiha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10286' => _x( 'Firasin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10287' => _x( 'Kherbet Al Hamam', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10295' => _x( 'Umm at Tut', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10300' => _x( 'Ash Shuhada (Mothalth Ash Shuhada)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10305' => _x( 'Jalqamus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10310' => _x( 'Al Mughayyir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10315' => _x( 'Al Mutilla', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10320' => _x( 'Bir al Basha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10325' => _x( 'Tannin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10335' => _x( 'Al Hafira (Hafirat Arraba)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10340' => _x( 'Qabatiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10365' => _x( 'Ad Damayra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10370' => _x( 'Arraba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10385' => _x( 'Telfit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10395' => _x( 'Mirka', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10400' => _x( 'Wadi Duoq', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10401' => _x( 'Fahma al Jadida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10405' => _x( 'Raba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10410' => _x( 'Al Mansura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10415' => _x( 'Misliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10430' => _x( 'Al Jarba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10435' => _x( 'AZ Zababida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10445' => _x( 'Fahma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10460' => _x( 'AZ Zawiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10465' => _x( 'Kafr Rai', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10485' => _x( 'Al Kufeir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10495' => _x( 'Sir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10500' => _x( 'Ajja', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10505' => _x( 'Anza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10510' => _x( 'Sanur', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10515' => _x( 'Ar Rama', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10520' => _x( 'Meithalun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10565' => _x( 'Al Judeida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10585' => _x( 'Al Asaasa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10590' => _x( 'Al Attara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10600' => _x( 'Siris', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10605' => _x( 'Jaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10615' => _x( 'Al Fandaqumiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS10625' => _x( 'Silat adh Dhahr', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSTB' => [
		'PS50420' => _x( 'Bardala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50450' => _x( 'Ein el Beida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50455' => _x( 'Kardala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50470' => _x( 'Khirbet Tell el Himma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50490' => _x( 'Ibziq', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50525' => _x( 'Salhab', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50535' => _x( 'Aqqaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50550' => _x( 'Tayasir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50551' => _x( 'Al Farisiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50560' => _x( 'Al Aqaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50580' => _x( 'Al Malih', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50610' => _x( 'Tubas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50614' => _x( 'Ein El- Hilua', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50650' => _x( 'Kashda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50656' => _x( 'Khirbet Yarza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50670' => _x( 'Ras al Fara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50700' => _x( 'El Faraa Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50720' => _x( 'Khirbet ar Ras al Ahmar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50740' => _x( 'Wadi al Faraa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50755' => _x( 'Tammun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50790' => _x( 'Khirbet Atuf', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS50871' => _x( 'Al Hadidiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSTK' => [
		'PS100250' => _x( 'Akkaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100290' => _x( 'Qaffin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100330' => _x( 'Nazlat Isa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100345' => _x( 'An Nazla ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100350' => _x( 'Baqa ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100355' => _x( 'An Nazla al Wusta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100380' => _x( 'An Nazla al Gharbiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100425' => _x( 'Zeita', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100440' => _x( 'Seida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100475' => _x( 'Illar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100480' => _x( 'Attil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100530' => _x( 'Deir al Ghusun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100545' => _x( 'Al Jarushiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100555' => _x( 'Al Masqufa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100570' => _x( 'Balaa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100595' => _x( 'Iktaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100620' => _x( 'Nur Shams Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100635' => _x( 'Tulkarm Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100645' => _x( 'Tulkarm', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100655' => _x( 'Izbat Abu Khameish', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100665' => _x( 'Anabta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100685' => _x( 'Izbat al Khilal', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100690' => _x( 'Kafr al Labad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100710' => _x( 'Kafa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100715' => _x( 'Al Haffasi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100725' => _x( 'Izbat Shufa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100730' => _x( 'Ramin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100735' => _x( 'Farun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100760' => _x( 'Shufa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100780' => _x( 'Khirbet Jubara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100795' => _x( 'Saffarin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100800' => _x( 'Beit Lid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100815' => _x( 'Ar Ras', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100845' => _x( 'Kafr Sur', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100870' => _x( 'Kur', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100895' => _x( 'Kafr Zibad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100900' => _x( 'Kafr Jammal', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS100915' => _x( 'Kafr Abbush', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSNB' => [
		'PS150660' => _x( 'Bazzariya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150680' => _x( 'Burqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150695' => _x( 'Yasid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150705' => _x( 'Beit Imrin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150745' => _x( 'Nisf Jubeil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150765' => _x( 'Sabastiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150770' => _x( 'Ijnisinya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150775' => _x( 'Talluza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150785' => _x( 'An Naqura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150805' => _x( 'Al Badhan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150810' => _x( 'Deir Sharaf', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150820' => _x( 'Asira ash Shamaliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150825' => _x( 'An Nassariya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150835' => _x( 'Zawata', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150840' => _x( 'Al Aqrabaniya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150855' => _x( 'Qusin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150860' => _x( 'Beit Iba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150865' => _x( 'Beit Hasan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150875' => _x( 'Beit Wazan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150880' => _x( 'Ein Beit el Ma Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150885' => _x( 'Ein Shibli', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150910' => _x( 'Azmut', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150920' => _x( 'Nablus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150930' => _x( 'Askar Camp (al Qadeem)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150931' => _x( 'Askar Camp (al Jadeed)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150935' => _x( 'Deir al Hatab', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150950' => _x( 'Sarra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150955' => _x( 'Salim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150960' => _x( 'Balata Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150975' => _x( 'Iraq Burin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS150990' => _x( 'Tell', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151000' => _x( 'Beit Dajan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151010' => _x( 'Rujeib', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151025' => _x( 'Kafr Qallil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151030' => _x( 'Furush Beit Dajan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151050' => _x( 'Madama', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151080' => _x( 'Burin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151090' => _x( 'Beit Furik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151095' => _x( 'Asira al Qibliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151135' => _x( 'Awarta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151160' => _x( 'Urif', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151176' => _x( 'Khirbet Tana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151180' => _x( 'Odala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151185' => _x( 'Huwwara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151195' => _x( 'Einabus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151200' => _x( 'Yanun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151215' => _x( 'Beita', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151220' => _x( 'Ar Rajman and Ad Dawa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151230' => _x( 'Zeita Jammain', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151245' => _x( 'Jammain', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151265' => _x( 'Osarin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151270' => _x( 'Aqraba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151285' => _x( 'Zatara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151311' => _x( 'Alttawel and Tall al Khashaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151325' => _x( 'Yatma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151335' => _x( 'Qabalan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151345' => _x( 'Jurish', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151365' => _x( 'Qusra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151375' => _x( 'Talfit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151380' => _x( 'As Sawiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151385' => _x( 'Majdal Bani Fadil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151405' => _x( 'Al Lubban ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151410' => _x( 'Qaryut', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151420' => _x( 'Jalud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151435' => _x( 'Ammuriya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151445' => _x( 'Duma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS151450' => _x( 'Khirbet Sarra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSQL' => [
		'PS200905' => _x( 'Falamya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200925' => _x( 'Kafr Qaddum', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200945' => _x( 'Jit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200965' => _x( 'Baqat al Hatab', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200970' => _x( 'Hajja', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200985' => _x( 'Jayyus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS200995' => _x( 'Khirbet Sir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201005' => _x( 'Arab ar Ramadin ash Shamali', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201015' => _x( 'Farata', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201020' => _x( 'Immatin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201035' => _x( 'Al Funduq', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201040' => _x( 'Qalqiliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201055' => _x( 'An Nabi Elyas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201065' => _x( 'Kafr Laqif', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201070' => _x( 'Arab Abu Farda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201075' => _x( 'Izbat at Tabib', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201085' => _x( 'Jinsafut', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201100' => _x( 'Azzun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201105' => _x( 'Arab ar Ramadin al Janubi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201115' => _x( 'Isla', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201116' => _x( 'Arab Al-Khouleh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201120' => _x( 'Wadi ar Rasha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201125' => _x( 'Habla', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201130' => _x( 'Ras at Tira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201155' => _x( 'Ras Atiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201170' => _x( 'Ad Dabaa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201175' => _x( 'Kafr Thulth', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201190' => _x( 'Izbat Jalud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201205' => _x( 'Al Mudawwar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201210' => _x( 'Izbat Salman', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201225' => _x( 'Izbat al Ashqar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201255' => _x( 'Beit Amin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201260' => _x( 'Sanniriya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS201280' => _x( 'Azzun Atma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSSL' => [
		'PS251250' => _x( 'Deir Istiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251275' => _x( 'Qarawat Bani Hassan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251290' => _x( 'Qira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251295' => _x( 'Kifl Haris', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251300' => _x( 'Marda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251305' => _x( 'Biddya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251310' => _x( 'Haris', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251315' => _x( 'Yasuf', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251320' => _x( 'Mas-ha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251330' => _x( 'Iskaka', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251340' => _x( 'Sarta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251355' => _x( 'Izbat Abu Adam', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251360' => _x( 'Az Zawiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251370' => _x( 'Salfit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251395' => _x( 'Rafat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251400' => _x( 'Bruqin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251415' => _x( 'Farkha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251425' => _x( 'Kafr ad Dik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251430' => _x( 'Deir Ballut', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS251440' => _x( 'Khirbet Qeis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSRL' => [
		'PS301455' => _x( 'Qarawat Bani Zeid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301460' => _x( 'Mazari an Nubani', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301470' => _x( 'Kafr Ein', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301471' => _x( 'Beit Reema', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301472' => _x( 'Deir Ghassana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301475' => _x( 'Arura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301485' => _x( 'Abwein', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301490' => _x( 'Turmusayya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301495' => _x( 'Al Lubban al Gharbi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301500' => _x( 'Sinjil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301505' => _x( 'Deir as Sudan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301515' => _x( 'Rantis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301520' => _x( 'Jilijliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301525' => _x( 'Ajjul', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301530' => _x( 'Al Mughayyir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301535' => _x( 'Abud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301540' => _x( 'An Nabi Salih', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301545' => _x( 'Khirbet Abu Falah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301546' => _x( 'Rawabi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301550' => _x( 'Umm Safa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301555' => _x( 'Al Mazraa ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301560' => _x( 'Deir Nidham', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301565' => _x( 'Atara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301570' => _x( 'Deir Abu Mashaal', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301575' => _x( 'Jibiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301585' => _x( 'Burham', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301590' => _x( 'Kafr Malik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301595' => _x( 'Shuqba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301600' => _x( 'Kobar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301605' => _x( 'Qibya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301610' => _x( 'Silwad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301615' => _x( 'Yabrud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301620' => _x( 'Beitillu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301625' => _x( 'Shabtin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301630' => _x( 'Jammala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301635' => _x( 'Birzeit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301636' => _x( 'Ad Doha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301640' => _x( 'Ein Siniya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301645' => _x( 'Silwad Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301650' => _x( 'Deir Jarir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301655' => _x( 'Deir Ammar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301660' => _x( 'Deir Ammar Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301665' => _x( 'Budrus', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301670' => _x( 'Abu Shukheidim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301675' => _x( 'Jifna', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301680' => _x( 'Dura al Qar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301685' => _x( 'At Tayba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301695' => _x( 'Al Mazraa al Qibliya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301700' => _x( 'Al Jalazun Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301705' => _x( 'Abu Qash', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301710' => _x( 'Deir Qaddis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301715' => _x( 'Nilin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301720' => _x( 'Ein Yabrud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301725' => _x( 'Kharbatha Bani Harith', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301730' => _x( 'Ras Karkar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301735' => _x( 'Surda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301740' => _x( 'Al Janiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301745' => _x( 'Al Midya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301750' => _x( 'Rammun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301755' => _x( 'Kafr Nima', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301760' => _x( 'Bilin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301765' => _x( 'Beitin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301770' => _x( 'Ein Qiniya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301775' => _x( 'Badiw al Muarrajat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301780' => _x( 'Deir Ibzi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301785' => _x( 'Deir Dibwan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301790' => _x( 'Al Bireh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301800' => _x( 'Ein Arik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301805' => _x( 'Saffa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301810' => _x( 'Ramallah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301815' => _x( 'Burqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301820' => _x( 'Beit Ur at Tahta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301825' => _x( 'Beituniya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301830' => _x( 'Al Amari Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301835' => _x( 'Qaddura Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301850' => _x( 'Beit Sira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301855' => _x( 'Kharbatha al Misbah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301860' => _x( 'Beit Ur al Fauqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301890' => _x( 'At Tira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS301895' => _x( 'Beit Liqya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSJR' => [
		'PS351045' => _x( 'Marj Naja', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351110' => _x( 'Az Zubeidat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351116' => _x( 'Marj al Ghazal', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351140' => _x( 'Al Jiftlik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351510' => _x( 'Fasayil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351690' => _x( 'Al Auja', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351840' => _x( 'An Nuweima', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351845' => _x( 'Ein ad Duyuk al Fauqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351865' => _x( 'Ein as Sultan Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351920' => _x( 'Jericho (Ariha)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351970' => _x( 'Deir al Qilt', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS351975' => _x( 'Aqbat Jaber Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS352021' => _x( 'Deir Hajla', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS352075' => _x( 'An Nabi Musa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSJS' => [
		'PS401870' => _x( 'Rafat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401885' => _x( 'Mikhmas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401900' => _x( 'Qalandiya Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401915' => _x( 'Qalandiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401930' => _x( 'Beit Duqqu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401935' => _x( 'Jaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401940' => _x( 'Al Judeira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401945' => _x( 'Ar Ram & Dahiyat al Bareed', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401950' => _x( 'Beit Anan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401955' => _x( 'Al Jib', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401960' => _x( 'Bir Nabala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401965' => _x( 'Beit Ijza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401980' => _x( 'Al Qubeiba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401985' => _x( 'Kharayib Umm al Lahim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS401995' => _x( 'Biddu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402000' => _x( 'An Nabi Samwil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402005' => _x( 'Hizma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402010' => _x( 'Beit Hanina al Balad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402015' => _x( 'Qatanna', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402020' => _x( 'Beit Surik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402025' => _x( 'Beit Iksa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402040' => _x( 'Anata', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402045' => _x( 'Al Kaabina (Tajammu Badawi)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402065' => _x( 'Az Zaayyem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402100' => _x( 'Al Eizariya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402120' => _x( 'Abu Dis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402125' => _x( 'Arab al Jahalin (Salamat)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402145' => _x( 'As Sawahira ash Sharqiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS402160' => _x( 'Ash Sheikh Sad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSBL' => [
		'PS452170' => _x( 'Al Walaja', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452175' => _x( 'Battir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452180' => _x( 'Al Ubeidiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452185' => _x( 'Ayda Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452190' => _x( 'Khallet an Numan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452195' => _x( 'Al Aza Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452200' => _x( 'Al Khas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452205' => _x( 'Al Haddadiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452208' => _x( 'Khallet Hamameh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452209' => _x( 'Bir Onah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452210' => _x( 'Beit Jala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452225' => _x( 'DarSalah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452230' => _x( 'Husan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452235' => _x( 'Wadi Fukin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452240' => _x( 'Bethlehem (Beit Lahm)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452255' => _x( 'Beit Sahur', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452265' => _x( 'Ad Doha', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452270' => _x( 'Al Khadr', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452275' => _x( 'Ad Duheisha Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452280' => _x( 'Hindaza and Bureidaa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452285' => _x( 'Ash Shawawra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452300' => _x( 'Artas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452325' => _x( 'Nahhalin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452335' => _x( 'Beit Tamir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452345' => _x( 'Khallet al Louza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452355' => _x( 'Al Jaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452360' => _x( 'Zatara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452375' => _x( 'Al Fureidis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452385' => _x( 'Jannatah (Badd Falouh)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452390' => _x( 'Khallet al Balluta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452400' => _x( 'Wadi Rahhal', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452405' => _x( 'Jub adh Dhib', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452415' => _x( 'Khallet Sakariya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452430' => _x( 'Khallet al Haddad', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452440' => _x( 'Al Masara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452445' => _x( 'Wadi an Nis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452455' => _x( 'Khirbet ad Deir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452460' => _x( 'Jurat ash Shama', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452465' => _x( 'Khallet Afana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452470' => _x( 'Marah Maalla', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452475' => _x( 'Al Halqum', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452480' => _x( 'Umm Salamuna', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452490' => _x( 'Al Manshiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452495' => _x( 'Tuqu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452500' => _x( 'Marah Rabah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452510' => _x( 'WadiImmhamid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452520' => _x( 'Khirbet Tuqu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452525' => _x( 'Beit Fajjar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452535' => _x( 'Al Maniya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452565' => _x( 'Kisan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS452660' => _x( 'Arab ar Rashayida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSHB' => [
		'PS502435' => _x( 'Khirbet ad Deir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502450' => _x( 'Surif', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502530' => _x( 'Al Arrub Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502540' => _x( 'Beit Ummar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502545' => _x( 'Jala', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502550' => _x( 'Hitta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502555' => _x( 'Shuyukh al Arrub', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502560' => _x( 'Kharas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502575' => _x( 'Umm al Butm', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502580' => _x( 'Hamrush', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502585' => _x( 'Nuba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502595' => _x( 'Kuziba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502615' => _x( 'Beit Ula', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502620' => _x( 'Sair', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502625' => _x( 'Khirbet Jamrura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502630' => _x( 'Halhul', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502635' => _x( 'Ash Shuyukh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502640' => _x( 'Tarqumiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502655' => _x( 'Beit Kahil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502680' => _x( 'Beit Einun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502681' => _x( 'Qlaa Zeta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502685' => _x( 'Idhna', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502725' => _x( 'Wadi ar Rim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502730' => _x( 'Suba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502735' => _x( 'Qinan an Namir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502750' => _x( 'Taffuh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502765' => _x( 'Beit Maqdum', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502770' => _x( 'El Kaum', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502778' => _x( 'Al Bouaierah (Al Baqaa)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502780' => _x( 'Hebron (Al Khalil)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502781' => _x( 'Al Bouaierah (Aqabat Injeleh)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502782' => _x( 'Khallet Edar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502785' => _x( 'Humsa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502795' => _x( 'Al Muwarraq', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502800' => _x( 'Tarusa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502810' => _x( 'Deir Samit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502815' => _x( 'Bani Naim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502830' => _x( 'Masafer Bani Naim (Khallet Al Masafer)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502835' => _x( 'Beit Awwa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502840' => _x( 'Dura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502855' => _x( 'Qalqas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502860' => _x( 'Sikka', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502870' => _x( 'Wadi Ubeid', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502880' => _x( 'Birin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502881' => _x( 'Alen', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502890' => _x( 'Tawas', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502895' => _x( 'Khursa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502900' => _x( 'Tarrama', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502905' => _x( 'Al Fawwar Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502910' => _x( 'Al Majd', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502915' => _x( 'Marah al Baqqar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502920' => _x( 'Hadab al Fawwar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502925' => _x( 'Deir al Asal at Tahta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502940' => _x( 'Wadi ash Shajina', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502950' => _x( 'As Sura', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502955' => _x( 'Deir Razih', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502960' => _x( 'Ar Rihiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502965' => _x( 'Zif', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502970' => _x( 'Deir al Asal al Fauqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502980' => _x( 'Imreish', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS502985' => _x( 'Iskeik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503005' => _x( 'Al Buweib', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503006' => _x( 'Toba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503010' => _x( 'Beit ar Rush at Tahta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503075' => _x( 'Beit Mirsim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503090' => _x( 'Beit ar Rush al Fauqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503095' => _x( 'Karma', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503100' => _x( 'Beit Amra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503105' => _x( 'Al Kaabneh -Om Adaraj (Alzoyedeen)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503110' => _x( 'Wadi al Kilab', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503111' => _x( 'Umm Ashoqhan', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503115' => _x( 'Khallet al Maiyya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503117' => _x( 'Umm Al Amad (Sahel Wadi Elma)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503120' => _x( 'Yatta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503125' => _x( 'Ar Rifaiyya and Ad Deirat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503126' => _x( 'Khashem Adaraj (Al-Hathaleen)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503130' => _x( 'Khashem al Karem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503135' => _x( 'Kurza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503145' => _x( 'Rabud', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503150' => _x( 'Umm Lasafa and Abu Shabban', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503170' => _x( 'Al Burj and Al Bira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503210' => _x( 'Umm al Khair', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503211' => _x( 'Sadit athaleh', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503215' => _x( 'Al Karmil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503217' => _x( 'Majd AlBa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503220' => _x( 'Qinan Jaber', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503235' => _x( 'Somara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503245' => _x( 'Adh Dhahiriya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503246' => _x( 'Iqtet', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503248' => _x( 'Kafr Jul', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503249' => _x( 'Abu Alhana', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503255' => _x( 'At Tuwani', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503256' => _x( 'Sosya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503265' => _x( 'An Najada', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503270' => _x( 'Khirbet Deir Shams', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503280' => _x( 'Ar Rakeez', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503281' => _x( 'Almefqara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503285' => _x( 'Khirbet Shuweika', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503295' => _x( 'Anab al Kabir', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503300' => _x( 'Khirbet Asafi (Al Fauqa and Al Tahta)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503305' => _x( 'Al Maqora', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503310' => _x( 'Shib al Batim', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503315' => _x( 'Qawawis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503320' => _x( 'As Samu', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503324' => _x( 'Khirbet Alrthem', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503325' => _x( 'Edqeqa (Khirbet Tawil ash Shih)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503335' => _x( 'Ar Ramadin', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503345' => _x( 'Maghayir al Abeed', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503350' => _x( 'Khirbet al Fakheit', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503360' => _x( 'Khirbet Bir al Idd', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503365' => _x( 'Haribat an Nabi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503375' => _x( 'Khirbet Zanuta', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503380' => _x( 'Imneizil', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503385' => _x( 'Khirbet al Kharaba', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503395' => _x( 'Khirbet Ghuwein al Fauqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503400' => _x( 'Khirbet ar Rahwa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS503405' => _x( 'Arab al Fureijat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSNG' => [
		'PS552681' => _x( 'Um Al-Nnaser (Al Qaraya al Badawiya)', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS552695' => _x( 'Beit Lahiya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS552740' => _x( 'Beit Hanun', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS552755' => _x( 'Jabalya Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS552790' => _x( 'Jabalya', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSGZ' => [
		'PS602775' => _x( 'Ash Shati Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS602825' => _x( 'Gaza', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS602900' => _x( 'Madinat Ezahra', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS602945' => _x( 'Al Mughraqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS603045' => _x( 'Juhor ad Dik', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSDB' => [
		'PS653065' => _x( 'An Nuseirat Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653070' => _x( 'An Nuseirat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653140' => _x( 'Al Bureij Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653145' => _x( 'Al Bureij', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653180' => _x( 'Az Zawayda', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653200' => _x( 'Deir Al Balah Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653210' => _x( 'Al Maghazi Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653215' => _x( 'Al Maghazi', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653240' => _x( 'Deir al Balah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653250' => _x( 'Al Musaddar', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS653275' => _x( 'Wadi as Salqa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSKY' => [
		'PS703370' => _x( 'Al Qarara', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703410' => _x( 'Khan Yunis Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703420' => _x( 'Khan Yunis', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703425' => _x( 'Bani Suheila', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703430' => _x( 'Abasan al Jadida', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703445' => _x( 'Abasan al Kabira', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703470' => _x( 'Khuzaa', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS703485' => _x( 'Al Fukhkhari', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'PSRF' => [
		'PS753490' => _x( 'Rafah', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS753495' => _x( 'Rafah Camp', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS753500' => _x( 'Al-Nnaser', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
		'PS753505' => _x( 'Al Shokat', 'PS-cities', 'cities-shipping-zones-for-woocommerce' ),
	]
];
