<?php

/**
 * List of cities for: Pakistan
 * Source: http://www.pbs.gov.pk/sites/default/files/PAKISTAN%20TEHSIL%20WISE%20FOR%20WEB%20CENSUS_2017.pdf
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['PK'];

$country_cities = [
	'IS' => [
		'PKICT1' => 'Islamabad',
	],
	'KP' => [
		'PKKP1' => 'Chitral',
		'PKKP2' => 'Mastuj',
		'PKKP3' => 'Dir',
		'PKKP4' => 'Shringal',
		'PKKP5' => 'Wari',
		'PKKP6' => 'Temergara',
		'PKKP7' => 'Adenzai',
		'PKKP8' => 'Lal Qilla',
		'PKKP9' => 'Samarbagh (Barwa)',
		'PKKP10' => 'Daggar/Buner',
		'PKKP11' => 'Gagra',
		'PKKP12' => 'Khado Khel',
		'PKKP13' => 'Mandanr',
		'PKKP14' => 'Babuzai (Swat)',
		'PKKP15' => 'Bari Kot',
		'PKKP16' => 'Kabal',
		'PKKP17' => 'Matta',
		'PKKP18' => 'Khawaza Khela',
		'PKKP19' => 'Charbagh',
		'PKKP20' => 'Behrain',
		'PKKP21' => 'Alpuri',
		'PKKP22' => 'Besham',
		'PKKP23' => 'Puran',
		'PKKP24' => 'Swat Ranizai',
		'PKKP25' => 'Sam Ranizai',
		'PKKP26' => 'Dassu',
		'PKKP27' => 'Pattan',
		'PKKP28' => 'Palas',
		'PKKP29' => 'Kandia',
		'PKKP30' => 'Batagram',
		'PKKP31' => 'Allai',
		'PKKP32' => 'Mansehra',
		'PKKP33' => 'Oghi',
		'PKKP34' => 'Balakot',
		'PKKP35' => 'Judba',
		'PKKP36' => 'Khander',
		'PKKP37' => 'Abbottabad',
		'PKKP38' => 'Havelian',
		'PKKP39' => 'Haripur',
		'PKKP40' => 'Ghazi',
		'PKKP41' => 'Mardan',
		'PKKP42' => 'Katlang',
		'PKKP43' => 'Takht Bhai',
		'PKKP44' => 'Swabi',
		'PKKP45' => 'Topi',
		'PKKP46' => 'Lahor',
		'PKKP47' => 'Rzzar',
		'PKKP48' => 'Charsadda',
		'PKKP49' => 'Tangi',
		'PKKP50' => 'Shabqadar',
		'PKKP51' => 'Peshawar',
		'PKKP52' => 'Nowshera',
		'PKKP53' => 'Jehangira',
		'PKKP54' => 'Pabbi',
		'PKKP55' => 'Kohat',
		'PKKP56' => 'Lachi',
		'PKKP57' => 'Hangu',
		'PKKP58' => 'Tall',
		'PKKP59' => 'Karak',
		'PKKP60' => 'Banda Daud Shah',
		'PKKP61' => 'Takht-e-Nasriti',
		'PKKP62' => 'Bannu',
		'PKKP63' => 'Domel',
		'PKKP64' => 'Lakki Marwat',
		'PKKP65' => 'Naurang',
		'PKKP66' => 'D.I.Khan',
		'PKKP67' => 'Daraban',
		'PKKP68' => 'Pahar Pur',
		'PKKP69' => 'Kulachi',
		'PKKP70' => 'Paroa',
		'PKKP71' => 'Tank',
	],
	'TA' => [
		'PKFT1' => 'Barang',
		'PKFT2' => 'Bar Chamer Kand',
		'PKFT3' => 'Khar Bajaur',
		'PKFT4' => 'Mamund',
		'PKFT5' => 'Salarzai',
		'PKFT6' => 'Utmankhel (Qzafi)',
		'PKFT7' => 'Nawagai',
		'PKFT8' => 'Halimzai',
		'PKFT9' => 'Pindiali',
		'PKFT10' => 'Safi',
		'PKFT11' => 'Upper Mohmand',
		'PKFT12' => 'Utman Khel (Ambar)',
		'PKFT13' => 'Yake Ghund',
		'PKFT14' => 'Pringhar',
		'PKFT15' => 'Bara',
		'PKFT16' => 'Jamrud',
		'PKFT17' => 'Landi Kotal',
		'PKFT18' => 'Mula Ghori',
		'PKFT19' => 'Upper Kurram',
		'PKFT20' => 'Lower Kurram',
		'PKFT21' => 'Central Kurram F.R.',
		'PKFT22' => 'Central',
		'PKFT23' => 'Lower',
		'PKFT24' => 'Upper',
		'PKFT25' => 'Ismailzai',
		'PKFT26' => 'Datta Khel',
		'PKFT27' => 'Dossali',
		'PKFT28' => 'Garyum',
		'PKFT29' => 'Ghulam Khan',
		'PKFT30' => 'Mir Ali',
		'PKFT31' => 'Miran Shah',
		'PKFT32' => 'Razmak',
		'PKFT33' => 'Spinwam',
		'PKFT34' => 'Shewa',
		'PKFT35' => 'Ladha',
		'PKFT36' => 'Makin (Charlai)',
		'PKFT37' => 'Sararogha',
		'PKFT38' => 'Sarwekai',
		'PKFT39' => 'Tiarza',
		'PKFT40' => 'Wana',
		'PKFT41' => 'Toi Khullah',
		'PKFT42' => 'Birmal',
		'PKFT43' => 'T.A.ADJ.PESHAWAR',
		'PKFT44' => 'T.A.ADJ.KOHAT',
		'PKFT45' => 'T.A.ADJ.BANNU',
		'PKFT46' => 'T.A.ADJ.LAKKI MARWAT',
		'PKFT47' => 'T.A.ADJ.D.I.KHAN',
		'PKFT48' => 'T.A.ADJ.TANK',
	],
	'PB' => [
		'PKPJ1' => 'Attock',
		'PKPJ2' => 'Hassan Abdal',
		'PKPJ3' => 'Fateh Jang',
		'PKPJ4' => 'Pindi Gheb',
		'PKPJ5' => 'Jand',
		'PKPJ6' => 'Hazro',
		'PKPJ7' => 'Rawalpindi',
		'PKPJ8' => 'Gujar Khan',
		'PKPJ9' => 'Kahuta',
		'PKPJ10' => 'Taxila',
		'PKPJ11' => 'Murree',
		'PKPJ12' => 'Kotli Sattian',
		'PKPJ13' => 'Kallar Sayyedan',
		'PKPJ14' => 'Jhelum',
		'PKPJ15' => 'Pind Dadan Khan',
		'PKPJ16' => 'Sohawa',
		'PKPJ17' => 'Dina',
		'PKPJ18' => 'Chakwal',
		'PKPJ19' => 'Choa Saidan Shah',
		'PKPJ20' => 'Talagang',
		'PKPJ21' => 'Lawa',
		'PKPJ22' => 'Kallar Kahar',
		'PKPJ23' => 'Sargodha',
		'PKPJ24' => 'Sillanwali',
		'PKPJ25' => 'Shahpur',
		'PKPJ24' => 'Sahiwal',
		'PKPJ27' => 'Bhalwal',
		'PKPJ28' => 'Bhera',
		'PKPJ29' => 'Kot Momin',
		'PKPJ30' => 'Mankera',
		'PKPJ31' => 'Kalur Kot',
		'PKPJ32' => 'Bhakkar',
		'PKPJ33' => 'Darya Khan',
		'PKPJ34' => 'Khushab',
		'PKPJ35' => 'Nowshera',
		'PKPJ36' => 'Nurpur',
		'PKPJ37' => 'Quaidabad',
		'PKPJ38' => 'Mianwali',
		'PKPJ39' => 'Piplan',
		'PKPJ40' => 'Isa Khel',
		'PKPJ41' => 'Faisalabad City',
		'PKPJ42' => 'Faisalabad Saddar',
		'PKPJ43' => 'Chak Jhumra',
		'PKPJ44' => 'Sammundri',
		'PKPJ45' => 'Tandlianwala',
		'PKPJ46' => 'Jaranwala',
		'PKPJ47' => 'Jhang',
		'PKPJ48' => '18 Hazari',
		'PKPJ49' => 'Shorkot',
		'PKPJ50' => 'Ahmadpur Sial',
		'PKPJ51' => 'Chiniot',
		'PKPJ52' => 'Lalian',
		'PKPJ53' => 'Bhawana',
		'PKPJ54' => 'Toba Tek Singh',
		'PKPJ55' => 'Gojra',
		'PKPJ56' => 'Kamalia',
		'PKPJ57' => 'Pir Mahal',
		'PKPJ58' => 'Gujranwala City',
		'PKPJ59' => 'Gujranwal Saddar',
		'PKPJ60' => 'Kamoki',
		'PKPJ61' => 'Nowshera Virkan',
		'PKPJ62' => 'Wazirabad',
		'PKPJ63' => 'Hafizabad',
		'PKPJ64' => 'Pindi Bhattian',
		'PKPJ65' => 'Gujrat',
		'PKPJ66' => 'Kharian',
		'PKPJ67' => 'Sarai Alamgir',
		'PKPJ68' => 'Mandi Bahauddin',
		'PKPJ69' => 'Phalia',
		'PKPJ70' => 'Malakwal',
		'PKPJ71' => 'Sialkot',
		'PKPJ72' => 'Daska',
		'PKPJ73' => 'Pasrur',
		'PKPJ74' => 'Sambrial',
		'PKPJ75' => 'Narowal',
		'PKPJ76' => 'Shakargarh',
		'PKPJ77' => 'Zafarwal',
		'PKPJ78' => 'Lahore City',
		'PKPJ79' => 'Lahore Cantt.',
		'PKPJ80' => 'Model Town',
		'PKPJ81' => 'Shalimar',
		'PKPJ82' => 'Riawand',
		'PKPJ83' => 'Kasur',
		'PKPJ84' => 'Chunian',
		'PKPJ85' => 'Pattoki',
		'PKPJ86' => 'Kot Radha Kishan',
		'PKPJ87' => 'Ferozewala',
		'PKPJ88' => 'Muridke',
		'PKPJ89' => 'Sheikhupura',
		'PKPJ90' => 'Safdarabad',
		'PKPJ91' => 'Sharkpur',
		'PKPJ92' => 'Nankana Sahib',
		'PKPJ93' => 'Sangla Hill',
		'PKPJ94' => 'Shahkot',
		'PKPJ95' => 'Sahiwal',
		'PKPJ96' => 'Chichawatni',
		'PKPJ97' => 'Pakpattan',
		'PKPJ98' => 'Arifwala',
		'PKPJ99' => 'Okara',
		'PKPJ100' => 'Renala Khurd',
		'PKPJ101' => 'Depalpur',
		'PKPJ102' => 'Vehari',
		'PKPJ103' => 'Burewala',
		'PKPJ104' => 'Mailsi',
		'PKPJ105' => 'Multan Saddar',
		'PKPJ106' => 'Multan City',
		'PKPJ107' => 'Shujabad',
		'PKPJ108' => 'Jalalpur Pirwala',
		'PKPJ109' => 'Lodhran',
		'PKPJ110' => 'Kahror Pacca',
		'PKPJ111' => 'Dunyapur',
		'PKPJ112' => 'Khanewal',
		'PKPJ113' => 'Jehanian',
		'PKPJ114' => 'Mian Channu',
		'PKPJ115' => 'Kabirwala',
		'PKPJ116' => 'Dera Ghazi Khan',
		'PKPJ117' => 'Kot Chutta',
		'PKPJ118' => 'Taunsa',
		'PKPJ119' => 'De-excluded area of D.G.Khan',
		'PKPJ120' => 'Rajanpur',
		'PKPJ121' => 'Rojhan',
		'PKPJ122' => 'Jampur',
		'PKPJ123' => 'De-excluded area of Rajanpur',
		'PKPJ124' => 'Layyah',
		'PKPJ125' => 'Karor Lal Esan',
		'PKPJ126' => 'Chaubara',
		'PKPJ127' => 'Muzaffargarh',
		'PKPJ128' => 'Alipur',
		'PKPJ129' => 'Jatoi',
		'PKPJ130' => 'Kot Addu',
		'PKPJ131' => 'Hasilpur',
		'PKPJ132' => 'Khairpur Tamewali',
		'PKPJ133' => 'Yazman',
		'PKPJ134' => 'Ahmadpur East',
		'PKPJ135' => 'Bahawalpur City',
		'PKPJ136' => 'Bahawalpur Saddar',
		'PKPJ137' => 'Bahawalnagar',
		'PKPJ138' => 'Chishtian',
		'PKPJ139' => 'Haroonabad',
		'PKPJ140' => 'Fort Abbas',
		'PKPJ141' => 'Minchinabad',
		'PKPJ142' => 'Rahim Yar Khan',
		'PKPJ143' => 'Sadiqabad',
		'PKPJ144' => 'Liaquatpur',
		'PKPJ145' => 'Khanpur',
	],
	'SD' => [
		'PKSN1' => 'BADIN',
		'PKSN2' => 'GOLARCHI (S.F.RAHU)',
		'PKSN3' => 'MATLI',
		'PKSN4' => 'TALHAR',
		'PKSN5' => 'TANDO BAGO',
		'PKSN6' => 'DADU',
		'PKSN7' => 'JOHI',
		'PKSN8' => 'KHAIRPUR NATHAN SHAH',
		'PKSN9' => 'MEHAR',
		'PKSN10' => 'KOTRI',
		'PKSN11' => 'MANJHAND',
		'PKSN12' => 'SEHWAN',
		'PKSN13' => 'THANO BULA KHAN',
		'PKSN14' => 'HYDERABAD CITY',
		'PKSN15' => 'LATIFABAD',
		'PKSN16' => 'HYDERABAD',
		'PKSN17' => 'QASIMABAD',
		'PKSN18' => 'HALA',
		'PKSN19' => 'MATIARI',
		'PKSN20' => 'SAEEDABAD',
		'PKSN21' => 'CHAMBER',
		'PKSN22' => 'JHANDO MARI',
		'PKSN23' => 'TANDO ALLAH YAR',
		'PKSN24' => 'BULRI SHAH KARIM',
		'PKSN25' => 'TANDO GHULAM HYDER',
		'PKSN26' => 'TANDO MUHAMMAD KHAN',
		'PKSN27' => 'GHORABARI',
		'PKSN28' => 'KETI BUNDER',
		'PKSN29' => 'MIRPUR SAKRO',
		'PKSN30' => 'THATTA',
		'PKSN31' => 'JATI',
		'PKSN32' => 'KHARO CHAN',
		'PKSN33' => 'MIRPUR BATHORO',
		'PKSN34' => 'SHAH BUNDER',
		'PKSN35' => 'SUJAWAL',
		'PKSN36' => 'BALDIA',
		'PKSN37' => 'S.I.T.E',
		'PKSN38' => 'MOMINABAD',
		'PKSN39' => 'ORANGI',
		'PKSN40' => 'MANGO PIR',
		'PKSN41' => 'HARBOUR',
		'PKSN42' => 'MAURIPUR',
		'PKSN43' => 'LYARI',
		'PKSN44' => 'GARDEN',
		'PKSN45' => 'ARAM BAGH',
		'PKSN46' => 'SADDAR',
		'PKSN47' => 'CIVIL LINE',
		'PKSN48' => 'NORTH NAZIMABAD',
		'PKSN49' => 'NEW KARACHI',
		'PKSN50' => 'GULBERG',
		'PKSN51' => 'LIAQUATABAD',
		'PKSN52' => 'NAZIMABAD',
		'PKSN53' => 'BIN QASIM',
		'PKSN54' => 'IBRAHIM HYDERI',
		'PKSN55' => 'GADAP',
		'PKSN56' => 'SHAH MUREED',
		'PKSN57' => 'AIRPORT',
		'PKSN58' => 'MURAD MEMON',
		'PKSN59' => 'SHAH FAISAL',
		'PKSN60' => 'MODEL COLONY',
		'PKSN61' => 'LANDHI',
		'PKSN62' => 'KORANGI',
		'PKSN63' => 'FEROZABAD',
		'PKSN64' => 'JAMSHED QUARTERS',
		'PKSN65' => 'GULSHAN-E-IQBAL',
		'PKSN66' => 'GULZAR-E-HIJRI',
		'PKSN67' => 'GARHI KHAIRO',
		'PKSN68' => 'JACOBABAD',
		'PKSN69' => 'THUL',
		'PKSN70' => 'KANDHKOT',
		'PKSN71' => 'KASHMOR',
		'PKSN72' => 'TANGWANI',
		'PKSN73' => 'BAKRANI',
		'PKSN74' => 'DOKRI',
		'PKSN75' => 'LARKANA',
		'PKSN76' => 'RATODERO',
		'PKSN77' => 'KAMBAR ALI KHAN',
		'PKSN78' => 'MIRO KHAN',
		'PKSN79' => 'NASIRABAD',
		'PKSN80' => 'QUBO SAEED KHAN',
		'PKSN81' => 'SHAHDADKOT',
		'PKSN82' => 'SUJAWAL JUNEJO',
		'PKSN83' => 'WARAH',
		'PKSN84' => 'GARHI YASIN',
		'PKSN85' => 'KHANPUR',
		'PKSN86' => 'LAKHI',
		'PKSN87' => 'SHIKARPUR',
		'PKSN88' => 'DIGRI',
		'PKSN89' => 'HUSSAIN BUX MARI',
		'PKSN90' => 'JHUDO',
		'PKSN91' => 'KOT GHULAM MUHAMMAD',
		'PKSN92' => 'MIRPUR KHAS',
		'PKSN93' => 'SHUJAABAD',
		'PKSN94' => 'SINDHRI',
		'PKSN95' => 'CHACHRO',
		'PKSN96' => 'DIPLO',
		'PKSN97' => 'DAHLI',
		'PKSN98' => 'ISLAMKOT',
		'PKSN99' => 'KALOI',
		'PKSN100' => 'MITHI',
		'PKSN101' => 'NAGAR PARKAR',
		'PKSN102' => 'KUNRI',
		'PKSN103' => 'PITHORO',
		'PKSN104' => 'SAMARO',
		'PKSN105' => 'UMER KOT',
		'PKSN106' => 'JAM NAWAZ ALI',
		'PKSN107' => 'KHIPRO',
		'PKSN108' => 'SANGHAR',
		'PKSN109' => 'SHAHDADPUR',
		'PKSN110' => 'SINJHORO',
		'PKSN111' => 'TANDO ADAM',
		'PKSN112' => 'BHIRIA',
		'PKSN113' => 'KANDIARO',
		'PKSN114' => 'MEHRABPUR',
		'PKSN115' => 'MORO',
		'PKSN116' => 'NAUSHAHRO FEROZE',
		'PKSN117' => 'DAUR',
		'PKSN118' => 'NAWABSHAH',
		'PKSN119' => 'KAZI AHMED',
		'PKSN120' => 'SAKRAND',
		'PKSN121' => 'DAHARKI',
		'PKSN122' => 'GHOTKI',
		'PKSN123' => 'KHANGARH',
		'PKSN124' => 'MIRPUR MATHELO',
		'PKSN125' => 'UBAURO',
		'PKSN126' => 'FAIZ GANJ',
		'PKSN127' => 'GAMBAT',
		'PKSN128' => 'KHAIRPUR',
		'PKSN129' => 'KINGRI',
		'PKSN130' => 'KOT DIJI',
		'PKSN131' => 'MIRWAH',
		'PKSN132' => 'NARA',
		'PKSN133' => 'SOBHO DERO',
		'PKSN134' => 'SUKKUR CITY',
		'PKSN135' => 'NEW SUKKUR',
		'PKSN136' => 'PANO AQIL',
		'PKSN137' => 'ROHRI',
		'PKSN138' => 'SALEHPAT',
	],
	'BA' => [
		'PKBL1' => 'Quetta City',
		'PKBL2' => 'Panj Pai',
		'PKBL3' => 'Quetta Sadar',
		'PKBL4' => 'Pishin',
		'PKBL5' => 'Hurramzai',
		'PKBL6' => 'Barshore',
		'PKBL7' => 'Karezat',
		'PKBL8' => 'Saranan',
		'PKBL9' => 'Chaman',
		'PKBL10' => 'Dobandi',
		'PKBL11' => 'Gulistan',
		'PKBL12' => 'Killa Abdullah',
		'PKBL13' => 'Dalbandin',
		'PKBL14' => 'Chagai',
		'PKBL15' => 'Nokundi',
		'PKBL16' => 'Taftan',
		'PKBL17' => 'Nushki',
		'PKBL18' => 'Bori',
		'PKBL19' => 'Loralai',
		'PKBL20' => 'Mekhtar',
		'PKBL21' => 'Duki',
		'PKBL22' => 'Musakhel',
		'PKBL23' => 'Kingri',
		'PKBL24' => 'Drug',
		'PKBL25' => 'Barkhan',
		'PKBL26' => 'Killa Saifullah',
		'PKBL27' => 'Muslim Bagh',
		'PKBL28' => 'Loiband',
		'PKBL29' => 'Baddini',
		'PKBL30' => 'Kan Mehtarzai Sub-',
		'PKBL31' => 'Shinki Sub-',
		'PKBL32' => 'Zhob',
		'PKBL33' => 'Sambaza',
		'PKBL34' => 'Qamar Din Karez',
		'PKBL35' => 'Ashwat',
		'PKBL36' => 'Kashatoo Sub-',
		'PKBL37' => 'Sherani Sub-Division',
		'PKBL38' => 'Sibi',
		'PKBL39' => 'Sangan',
		'PKBL40' => 'Kotmandai',
		'PKBL41' => 'Ziarat',
		'PKBL42' => 'Sinjawi',
		'PKBL43' => 'Kohlu',
		'PKBL44' => 'Kahan',
		'PKBL45' => 'Mawand',
		'PKBL46' => 'Grisani',
		'PKBL47' => 'Tamboo',
		'PKBL48' => 'Dera Bugti',
		'PKBL49' => 'Sangsillah',
		'PKBL50' => 'Phelawagh',
		'PKBL51' => 'Baiker',
		'PKBL52' => 'Malam',
		'PKBL53' => 'Pir Koh',
		'PKBL54' => 'Sui',
		'PKBL55' => 'Loti',
		'PKBL56' => 'Harnai',
		'PKBL57' => 'Khoast',
		'PKBL58' => 'Shahrig',
		'PKBL59' => 'Bhag',
		'PKBL60' => 'Lehri',
		'PKBL61' => 'Jhat Pat',
		'PKBL62' => 'Usta Muhammad',
		'PKBL63' => 'Gandhaka',
		'PKBL64' => 'Tamboo',
		'PKBL65' => 'D.M.Jamali',
		'PKBL66' => 'Chattar',
		'PKBL67' => 'Baba Kot',
		'PKBL68' => 'Gandawa',
		'PKBL69' => 'Mirpur',
		'PKBL70' => 'Jhal Magsi',
		'PKBL71' => 'Dhadar',
		'PKBL72' => 'Sanni',
		'PKBL73' => 'Balanari',
		'PKBL74' => 'Khattan',
		'PKBL75' => 'Mach',
		'PKBL76' => 'Faridabad',
		'PKBL77' => 'Sanhri',
		'PKBL78' => 'Sohbatpur',
		'PKBL79' => 'Kalat',
		'PKBL80' => 'Mangochar',
		'PKBL81' => 'Johan',
		'PKBL82' => 'Surab',
		'PKBL83' => 'Gazg',
		'PKBL84' => 'Besima',
		'PKBL85' => 'Musakhel',
		'PKBL86' => 'Nag',
		'PKBL87' => 'Shahoo Garhi',
		'PKBL88' => 'Washuk',
		'PKBL89' => 'Mastung',
		'PKBL90' => 'Kirdgap',
		'PKBL91' => 'Dasht',
		'PKBL92' => 'Khad Koocha',
		'PKBL93' => 'Khuzdar',
		'PKBL94' => 'Zehri',
		'PKBL95' => 'Moola',
		'PKBL96' => 'Karakh',
		'PKBL97' => 'Nal',
		'PKBL98' => 'Wadh',
		'PKBL99' => 'Ornach',
		'PKBL100' => 'Saroona',
		'PKBL101' => 'Aranji',
		'PKBL102' => 'Awaran',
		'PKBL103' => 'Mashkai',
		'PKBL104' => 'Jhal Jao',
		'PKBL105' => 'Gishkore Sub',
		'PKBL106' => 'Kharan',
		'PKBL107' => 'Sar Kharan',
		'PKBL108' => 'TohMulk Sub',
		'PKBL109' => 'Bela',
		'PKBL110' => 'Uthal',
		'PKBL111' => 'Gadani',
		'PKBL112' => 'Hub',
		'PKBL113' => 'Lakhra',
		'PKBL114' => 'Liari',
		'PKBL115' => 'Sonmiani/Winder',
		'PKBL116' => 'Dureji',
		'PKBL117' => 'Kanraj',
		'PKBL118' => 'Kech (Turbat)',
		'PKBL119' => 'Buleda',
		'PKBL120' => 'Zamuran',
		'PKBL121' => 'Hoshab',
		'PKBL122' => 'Balnigor',
		'PKBL123' => 'Dasht',
		'PKBL124' => 'Tump',
		'PKBL125' => 'Mand',
		'PKBL126' => 'Gwadar',
		'PKBL127' => 'Pasni',
		'PKBL128' => 'Ormara',
		'PKBL129' => 'Jiwani',
		'PKBL130' => 'Suntsar',
		'PKBL131' => 'Panjgur',
		'PKBL132' => 'Parome',
		'PKBL133' => 'Gichk',
		'PKBL134' => 'Gowargo',
	]
];
