<?php

/**
 * List of cities for: Philippines
 * Source: https://psa.gov.ph/classification/psgc/
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'PH010000000'	=> 'ILOCOS',
	'PH020000000'	=> 'CAGAYAN VALLEY',
	'PH030000000'	=> 'CENTRAL LUZON',
	'PH040000000'	=> 'CALABARZON',
	'PH050000000'	=> 'BICOL',
	'PH060000000'	=> 'WESTERN VISAYAS',
	'PH070000000'	=> 'CENTRAL VISAYAS',
	'PH080000000'	=> 'EASTERN VISAYAS',
	'PH090000000'	=> 'ZAMBOANGA PENINSULA',
	'PH100000000'	=> 'NORTHERN MINDANAO',
	'PH110000000'	=> 'DAVAO',
	'PH120000000'	=> 'SOCCSKSARGEN',
	'PH130000000'	=> 'NATIONAL CAPITAL REGION',
	'PH140000000'	=> 'CORDILLERA ADMINISTRATIVE REGION',
	'PH150000000'	=> 'AUTONOMOUS REGION IN MUSLIM MINDANAO',
	'PH160000000'	=> 'Caraga',
	'PH170000000'	=> 'MIMAROPA',
];

$country_cities = [
	'PH010000000' => [
		'PH012801000' => 'ADAMS',
		'PH012802000' => 'BACARRA',
		'PH012803000' => 'BADOC',
		'PH012804000' => 'BANGUI',
		'PH012805000' => 'BATAC',
		'PH012806000' => 'BURGOS',
		'PH012807000' => 'CARASI',
		'PH012808000' => 'CURRIMAO',
		'PH012809000' => 'DINGRAS',
		'PH012810000' => 'DUMALNEG',
		'PH012811000' => 'BANNA (ESPIRITU)',
		'PH012812000' => 'LAOAG',
		'PH012813000' => 'MARCOS',
		'PH012814000' => 'NUEVA ERA',
		'PH012815000' => 'PAGUDPUD',
		'PH012816000' => 'PAOAY',
		'PH012817000' => 'PASUQUIN',
		'PH012818000' => 'PIDDIG',
		'PH012819000' => 'PINILI',
		'PH012820000' => 'SAN NICOLAS',
		'PH012821000' => 'SARRAT',
		'PH012822000' => 'SOLSONA',
		'PH012823000' => 'VINTAR',
		'PH012901000' => 'ALILEM',
		'PH012902000' => 'BANAYOYO',
		'PH012903000' => 'BANTAY',
		'PH012904000' => 'BURGOS',
		'PH012905000' => 'CABUGAO',
		'PH012906000' => 'CANDON',
		'PH012907000' => 'CAOAYAN',
		'PH012908000' => 'CERVANTES',
		'PH012909000' => 'GALIMUYOD',
		'PH012910000' => 'GREGORIO DEL PILAR (CONCEPCION)',
		'PH012911000' => 'LIDLIDDA',
		'PH012912000' => 'MAGSINGAL',
		'PH012913000' => 'NAGBUKEL',
		'PH012914000' => 'NARVACAN',
		'PH012915000' => 'QUIRINO (ANGKAKI)',
		'PH012916000' => 'SALCEDO (BAUGEN)',
		'PH012917000' => 'SAN EMILIO',
		'PH012918000' => 'SAN ESTEBAN',
		'PH012919000' => 'SAN ILDEFONSO',
		'PH012920000' => 'SAN JUAN (LAPOG)',
		'PH012921000' => 'SAN VICENTE',
		'PH012922000' => 'SANTA',
		'PH012923000' => 'SANTA CATALINA',
		'PH012924000' => 'SANTA CRUZ',
		'PH012925000' => 'SANTA LUCIA',
		'PH012926000' => 'SANTA MARIA',
		'PH012927000' => 'SANTIAGO',
		'PH012928000' => 'SANTO DOMINGO',
		'PH012929000' => 'SIGAY',
		'PH012930000' => 'SINAIT',
		'PH012931000' => 'SUGPON',
		'PH012932000' => 'SUYO',
		'PH012933000' => 'TAGUDIN',
		'PH012934000' => 'VIGAN',
		'PH013301000' => 'AGOO',
		'PH013302000' => 'ARINGAY',
		'PH013303000' => 'BACNOTAN',
		'PH013304000' => 'BAGULIN',
		'PH013305000' => 'BALAOAN',
		'PH013306000' => 'BANGAR',
		'PH013307000' => 'BAUANG',
		'PH013308000' => 'BURGOS',
		'PH013309000' => 'CABA',
		'PH013310000' => 'LUNA',
		'PH013311000' => 'NAGUILIAN',
		'PH013312000' => 'PUGO',
		'PH013313000' => 'ROSARIO',
		'PH013314000' => 'SAN FERNANDO',
		'PH013315000' => 'SAN GABRIEL',
		'PH013316000' => 'SAN JUAN',
		'PH013317000' => 'SANTO TOMAS',
		'PH013318000' => 'SANTOL',
		'PH013319000' => 'SUDIPEN',
		'PH013320000' => 'TUBAO',
		'PH015501000' => 'AGNO',
		'PH015502000' => 'AGUILAR',
		'PH015503000' => 'ALAMINOS',
		'PH015504000' => 'ALCALA',
		'PH015505000' => 'ANDA',
		'PH015506000' => 'ASINGAN',
		'PH015507000' => 'BALUNGAO',
		'PH015508000' => 'BANI',
		'PH015509000' => 'BASISTA',
		'PH015510000' => 'BAUTISTA',
		'PH015511000' => 'BAYAMBANG',
		'PH015512000' => 'BINALONAN',
		'PH015513000' => 'BINMALEY',
		'PH015514000' => 'BOLINAO',
		'PH015515000' => 'BUGALLON',
		'PH015516000' => 'BURGOS',
		'PH015517000' => 'CALASIAO',
		'PH015518000' => 'DAGUPAN',
		'PH015519000' => 'DASOL',
		'PH015520000' => 'INFANTA',
		'PH015521000' => 'LABRADOR',
		'PH015522000' => 'LINGAYEN',
		'PH015523000' => 'MABINI',
		'PH015524000' => 'MALASIQUI',
		'PH015525000' => 'MANAOAG',
		'PH015526000' => 'MANGALDAN',
		'PH015527000' => 'MANGATAREM',
		'PH015528000' => 'MAPANDAN',
		'PH015529000' => 'NATIVIDAD',
		'PH015530000' => 'POZORRUBIO',
		'PH015531000' => 'ROSALES',
		'PH015532000' => 'SAN CARLOS',
		'PH015533000' => 'SAN FABIAN',
		'PH015534000' => 'SAN JACINTO',
		'PH015535000' => 'SAN MANUEL',
		'PH015536000' => 'SAN NICOLAS',
		'PH015537000' => 'SAN QUINTIN',
		'PH015538000' => 'SANTA BARBARA',
		'PH015539000' => 'SANTA MARIA',
		'PH015540000' => 'SANTO TOMAS',
		'PH015541000' => 'SISON',
		'PH015542000' => 'SUAL',
		'PH015543000' => 'TAYUG',
		'PH015544000' => 'UMINGAN',
		'PH015545000' => 'URBIZTONDO',
		'PH015546000' => 'URDANETA',
		'PH015547000' => 'VILLASIS',
		'PH015548000' => 'LAOAC',
	],
	'PH020000000' => [
		'PH020901000' => 'BASCO',
		'PH020902000' => 'ITBAYAT',
		'PH020903000' => 'IVANA',
		'PH020904000' => 'MAHATAO',
		'PH020905000' => 'SABTANG',
		'PH020906000' => 'UYUGAN',
		'PH021501000' => 'ABULUG',
		'PH021502000' => 'ALCALA',
		'PH021503000' => 'ALLACAPAN',
		'PH021504000' => 'AMULUNG',
		'PH021505000' => 'APARRI',
		'PH021506000' => 'BAGGAO',
		'PH021507000' => 'BALLESTEROS',
		'PH021508000' => 'BUGUEY',
		'PH021509000' => 'CALAYAN',
		'PH021510000' => 'CAMALANIUGAN',
		'PH021511000' => 'CLAVERIA',
		'PH021512000' => 'ENRILE',
		'PH021513000' => 'GATTARAN',
		'PH021514000' => 'GONZAGA',
		'PH021515000' => 'IGUIG',
		'PH021516000' => 'LAL-LO',
		'PH021517000' => 'LASAM',
		'PH021518000' => 'PAMPLONA',
		'PH021519000' => 'PEÑABLANCA',
		'PH021520000' => 'PIAT',
		'PH021521000' => 'RIZAL',
		'PH021522000' => 'SANCHEZ-MIRA',
		'PH021523000' => 'SANTA ANA',
		'PH021524000' => 'SANTA PRAXEDES',
		'PH021525000' => 'SANTA TERESITA',
		'PH021526000' => 'SANTO NIÑO (FAIRE)',
		'PH021527000' => 'SOLANA',
		'PH021528000' => 'TUAO',
		'PH021529000' => 'TUGUEGARAO CITY',
		'PH023101000' => 'ALICIA',
		'PH023102000' => 'ANGADANAN',
		'PH023103000' => 'AURORA',
		'PH023104000' => 'BENITO SOLIVEN',
		'PH023105000' => 'BURGOS',
		'PH023106000' => 'CABAGAN',
		'PH023107000' => 'CABATUAN',
		'PH023108000' => 'CAUAYAN',
		'PH023109000' => 'CORDON',
		'PH023110000' => 'DINAPIGUE',
		'PH023111000' => 'DIVILACAN',
		'PH023112000' => 'ECHAGUE',
		'PH023113000' => 'GAMU',
		'PH023114000' => 'ILAGAN',
		'PH023115000' => 'JONES',
		'PH023116000' => 'LUNA',
		'PH023117000' => 'MACONACON',
		'PH023118000' => 'DELFIN ALBANO (MAGSAYSAY)',
		'PH023119000' => 'MALLIG',
		'PH023120000' => 'NAGUILIAN',
		'PH023121000' => 'PALANAN',
		'PH023122000' => 'QUEZON',
		'PH023123000' => 'QUIRINO',
		'PH023124000' => 'RAMON',
		'PH023125000' => 'REINA MERCEDES',
		'PH023126000' => 'ROXAS',
		'PH023127000' => 'SAN AGUSTIN',
		'PH023128000' => 'SAN GUILLERMO',
		'PH023129000' => 'SAN ISIDRO',
		'PH023130000' => 'SAN MANUEL',
		'PH023131000' => 'SAN MARIANO',
		'PH023132000' => 'SAN MATEO',
		'PH023133000' => 'SAN PABLO',
		'PH023134000' => 'SANTA MARIA',
		'PH023135000' => 'SANTIAGO',
		'PH023136000' => 'SANTO TOMAS',
		'PH023137000' => 'TUMAUINI',
		'PH025001000' => 'AMBAGUIO',
		'PH025002000' => 'ARITAO',
		'PH025003000' => 'BAGABAG',
		'PH025004000' => 'BAMBANG',
		'PH025005000' => 'BAYOMBONG',
		'PH025006000' => 'DIADI',
		'PH025007000' => 'DUPAX DEL NORTE',
		'PH025008000' => 'DUPAX DEL SUR',
		'PH025009000' => 'KASIBU',
		'PH025010000' => 'KAYAPA',
		'PH025011000' => 'QUEZON',
		'PH025012000' => 'SANTA FE',
		'PH025013000' => 'SOLANO',
		'PH025014000' => 'VILLAVERDE',
		'PH025015000' => 'ALFONSO CASTANEDA',
		'PH025701000' => 'AGLIPAY',
		'PH025702000' => 'CABARROGUIS',
		'PH025703000' => 'DIFFUN',
		'PH025704000' => 'MADDELA',
		'PH025705000' => 'SAGUDAY',
		'PH025706000' => 'NAGTIPUNAN',
	],
	'PH030000000' => [
		'PH030801000' => 'ABUCAY',
		'PH030802000' => 'BAGAC',
		'PH030803000' => 'BALANGA',
		'PH030804000' => 'DINALUPIHAN',
		'PH030805000' => 'HERMOSA',
		'PH030806000' => 'LIMAY',
		'PH030807000' => 'MARIVELES',
		'PH030808000' => 'MORONG',
		'PH030809000' => 'ORANI',
		'PH030810000' => 'ORION',
		'PH030811000' => 'PILAR',
		'PH030812000' => 'SAMAL',
		'PH031401000' => 'ANGAT',
		'PH031402000' => 'BALAGTAS (BIGAA)',
		'PH031403000' => 'BALIUAG',
		'PH031404000' => 'BOCAUE',
		'PH031405000' => 'BULACAN',
		'PH031406000' => 'BUSTOS',
		'PH031407000' => 'CALUMPIT',
		'PH031408000' => 'GUIGUINTO',
		'PH031409000' => 'HAGONOY',
		'PH031410000' => 'MALOLOS',
		'PH031411000' => 'MARILAO',
		'PH031412000' => 'MEYCAUAYAN',
		'PH031413000' => 'NORZAGARAY',
		'PH031414000' => 'OBANDO',
		'PH031415000' => 'PANDI',
		'PH031416000' => 'PAOMBONG',
		'PH031417000' => 'PLARIDEL',
		'PH031418000' => 'PULILAN',
		'PH031419000' => 'SAN ILDEFONSO',
		'PH031420000' => 'SAN JOSE DEL MONTE',
		'PH031421000' => 'SAN MIGUEL',
		'PH031422000' => 'SAN RAFAEL',
		'PH031423000' => 'SANTA MARIA',
		'PH031424000' => 'DOÑA REMEDIOS TRINIDAD',
		'PH034901000' => 'ALIAGA',
		'PH034902000' => 'BONGABON',
		'PH034903000' => 'CABANATUAN',
		'PH034904000' => 'CABIAO',
		'PH034905000' => 'CARRANGLAN',
		'PH034906000' => 'CUYAPO',
		'PH034907000' => 'GABALDON (BITULOK & SABANI)',
		'PH034908000' => 'GAPAN',
		'PH034909000' => 'GENERAL MAMERTO NATIVIDAD',
		'PH034910000' => 'GENERAL TINIO (PAPAYA)',
		'PH034911000' => 'GUIMBA',
		'PH034912000' => 'JAEN',
		'PH034913000' => 'LAUR',
		'PH034914000' => 'LICAB',
		'PH034915000' => 'LLANERA',
		'PH034916000' => 'LUPAO',
		'PH034917000' => 'SCIENCE MUÑOZ',
		'PH034918000' => 'NAMPICUAN',
		'PH034919000' => 'PALAYAN',
		'PH034920000' => 'PANTABANGAN',
		'PH034921000' => 'PEÑARANDA',
		'PH034922000' => 'QUEZON',
		'PH034923000' => 'RIZAL',
		'PH034924000' => 'SAN ANTONIO',
		'PH034925000' => 'SAN ISIDRO',
		'PH034926000' => 'SAN JOSE CITY',
		'PH034927000' => 'SAN LEONARDO',
		'PH034928000' => 'SANTA ROSA',
		'PH034929000' => 'SANTO DOMINGO',
		'PH034930000' => 'TALAVERA',
		'PH034931000' => 'TALUGTUG',
		'PH034932000' => 'ZARAGOZA',
		'PH035401000' => 'ANGELES',
		'PH035402000' => 'APALIT',
		'PH035403000' => 'ARAYAT',
		'PH035404000' => 'BACOLOR',
		'PH035405000' => 'CANDABA',
		'PH035406000' => 'FLORIDABLANCA',
		'PH035407000' => 'GUAGUA',
		'PH035408000' => 'LUBAO',
		'PH035409000' => 'MABALACAT CITY',
		'PH035410000' => 'MACABEBE',
		'PH035411000' => 'MAGALANG',
		'PH035412000' => 'MASANTOL',
		'PH035413000' => 'MEXICO',
		'PH035414000' => 'MINALIN',
		'PH035415000' => 'PORAC',
		'PH035416000' => 'SAN FERNANDO',
		'PH035417000' => 'SAN LUIS',
		'PH035418000' => 'SAN SIMON',
		'PH035419000' => 'SANTA ANA',
		'PH035420000' => 'SANTA RITA',
		'PH035421000' => 'SANTO TOMAS',
		'PH035422000' => 'SASMUAN (Sexmoan)',
		'PH036901000' => 'ANAO',
		'PH036902000' => 'BAMBAN',
		'PH036903000' => 'CAMILING',
		'PH036904000' => 'CAPAS',
		'PH036905000' => 'CONCEPCION',
		'PH036906000' => 'GERONA',
		'PH036907000' => 'LA PAZ',
		'PH036908000' => 'MAYANTOC',
		'PH036909000' => 'MONCADA',
		'PH036910000' => 'PANIQUI',
		'PH036911000' => 'PURA',
		'PH036912000' => 'RAMOS',
		'PH036913000' => 'SAN CLEMENTE',
		'PH036914000' => 'SAN MANUEL',
		'PH036915000' => 'SANTA IGNACIA',
		'PH036916000' => 'TARLAC',
		'PH036917000' => 'VICTORIA',
		'PH036918000' => 'SAN JOSE',
		'PH037101000' => 'BOTOLAN',
		'PH037102000' => 'CABANGAN',
		'PH037103000' => 'CANDELARIA',
		'PH037104000' => 'CASTILLEJOS',
		'PH037105000' => 'IBA',
		'PH037106000' => 'MASINLOC',
		'PH037107000' => 'OLONGAPO',
		'PH037108000' => 'PALAUIG',
		'PH037109000' => 'SAN ANTONIO',
		'PH037110000' => 'SAN FELIPE',
		'PH037111000' => 'SAN MARCELINO',
		'PH037112000' => 'SAN NARCISO',
		'PH037113000' => 'SANTA CRUZ',
		'PH037114000' => 'SUBIC',
		'PH037701000' => 'BALER',
		'PH037702000' => 'CASIGURAN',
		'PH037703000' => 'DILASAG',
		'PH037704000' => 'DINALUNGAN',
		'PH037705000' => 'DINGALAN',
		'PH037706000' => 'DIPACULAO',
		'PH037707000' => 'MARIA AURORA',
		'PH037708000' => 'SAN LUIS',
	],
	'PH040000000' => [
		'PH041001000' => 'AGONCILLO',
		'PH041002000' => 'ALITAGTAG',
		'PH041003000' => 'BALAYAN',
		'PH041004000' => 'BALETE',
		'PH041005000' => 'BATANGAS CITY',
		'PH041006000' => 'BAUAN',
		'PH041007000' => 'CALACA',
		'PH041008000' => 'CALATAGAN',
		'PH041009000' => 'CUENCA',
		'PH041010000' => 'IBAAN',
		'PH041011000' => 'LAUREL',
		'PH041012000' => 'LEMERY',
		'PH041013000' => 'LIAN',
		'PH041014000' => 'LIPA',
		'PH041015000' => 'LOBO',
		'PH041016000' => 'MABINI',
		'PH041017000' => 'MALVAR',
		'PH041018000' => 'MATAASNAKAHOY',
		'PH041019000' => 'NASUGBU',
		'PH041020000' => 'PADRE GARCIA',
		'PH041021000' => 'ROSARIO',
		'PH041022000' => 'SAN JOSE',
		'PH041023000' => 'SAN JUAN',
		'PH041024000' => 'SAN LUIS',
		'PH041025000' => 'SAN NICOLAS',
		'PH041026000' => 'SAN PASCUAL',
		'PH041027000' => 'SANTA TERESITA',
		'PH041028000' => 'STO. TOMAS',
		'PH041029000' => 'TAAL',
		'PH041030000' => 'TALISAY',
		'PH041031000' => 'TANAUAN',
		'PH041032000' => 'TAYSAN',
		'PH041033000' => 'TINGLOY',
		'PH041034000' => 'TUY',
		'PH042101000' => 'ALFONSO',
		'PH042102000' => 'AMADEO',
		'PH042103000' => 'BACOOR',
		'PH042104000' => 'CARMONA',
		'PH042105000' => 'CAVITE',
		'PH042106000' => 'DASMARIÑAS',
		'PH042107000' => 'GENERAL EMILIO AGUINALDO',
		'PH042108000' => 'GENERAL TRIAS',
		'PH042109000' => 'IMUS',
		'PH042110000' => 'INDANG',
		'PH042111000' => 'KAWIT',
		'PH042112000' => 'MAGALLANES',
		'PH042113000' => 'MARAGONDON',
		'PH042114000' => 'MENDEZ (MENDEZ-NUÑEZ)',
		'PH042115000' => 'NAIC',
		'PH042116000' => 'NOVELETA',
		'PH042117000' => 'ROSARIO',
		'PH042118000' => 'SILANG',
		'PH042119000' => 'TAGAYTAY',
		'PH042120000' => 'TANZA',
		'PH042121000' => 'TERNATE',
		'PH042122000' => 'TRECE MARTIRES',
		'PH042123000' => 'GEN. MARIANO ALVAREZ',
		'PH043401000' => 'ALAMINOS',
		'PH043402000' => 'BAY',
		'PH043403000' => 'BIÑAN',
		'PH043404000' => 'CABUYAO',
		'PH043405000' => 'CALAMBA',
		'PH043406000' => 'CALAUAN',
		'PH043407000' => 'CAVINTI',
		'PH043408000' => 'FAMY',
		'PH043409000' => 'KALAYAAN',
		'PH043410000' => 'LILIW',
		'PH043411000' => 'LOS BAÑOS',
		'PH043412000' => 'LUISIANA',
		'PH043413000' => 'LUMBAN',
		'PH043414000' => 'MABITAC',
		'PH043415000' => 'MAGDALENA',
		'PH043416000' => 'MAJAYJAY',
		'PH043417000' => 'NAGCARLAN',
		'PH043418000' => 'PAETE',
		'PH043419000' => 'PAGSANJAN',
		'PH043420000' => 'PAKIL',
		'PH043421000' => 'PANGIL',
		'PH043422000' => 'PILA',
		'PH043423000' => 'RIZAL',
		'PH043424000' => 'SAN PABLO',
		'PH043425000' => 'SAN PEDRO',
		'PH043426000' => 'SANTA CRUZ',
		'PH043427000' => 'SANTA MARIA',
		'PH043428000' => 'SANTA ROSA',
		'PH043429000' => 'SINILOAN',
		'PH043430000' => 'VICTORIA',
		'PH045601000' => 'AGDANGAN',
		'PH045602000' => 'ALABAT',
		'PH045603000' => 'ATIMONAN',
		'PH045605000' => 'BUENAVISTA',
		'PH045606000' => 'BURDEOS',
		'PH045607000' => 'CALAUAG',
		'PH045608000' => 'CANDELARIA',
		'PH045610000' => 'CATANAUAN',
		'PH045615000' => 'DOLORES',
		'PH045616000' => 'GENERAL LUNA',
		'PH045617000' => 'GENERAL NAKAR',
		'PH045618000' => 'GUINAYANGAN',
		'PH045619000' => 'GUMACA',
		'PH045620000' => 'INFANTA',
		'PH045621000' => 'JOMALIG',
		'PH045622000' => 'LOPEZ',
		'PH045623000' => 'LUCBAN',
		'PH045624000' => 'LUCENA',
		'PH045625000' => 'MACALELON',
		'PH045627000' => 'MAUBAN',
		'PH045628000' => 'MULANAY',
		'PH045629000' => 'PADRE BURGOS',
		'PH045630000' => 'PAGBILAO',
		'PH045631000' => 'PANUKULAN',
		'PH045632000' => 'PATNANUNGAN',
		'PH045633000' => 'PEREZ',
		'PH045634000' => 'PITOGO',
		'PH045635000' => 'PLARIDEL',
		'PH045636000' => 'POLILLO',
		'PH045637000' => 'QUEZON',
		'PH045638000' => 'REAL',
		'PH045639000' => 'SAMPALOC',
		'PH045640000' => 'SAN ANDRES',
		'PH045641000' => 'SAN ANTONIO',
		'PH045642000' => 'SAN FRANCISCO (AURORA)',
		'PH045644000' => 'SAN NARCISO',
		'PH045645000' => 'SARIAYA',
		'PH045646000' => 'TAGKAWAYAN',
		'PH045647000' => 'TAYABAS',
		'PH045648000' => 'TIAONG',
		'PH045649000' => 'UNISAN',
		'PH045801000' => 'ANGONO',
		'PH045802000' => 'ANTIPOLO',
		'PH045803000' => 'BARAS',
		'PH045804000' => 'BINANGONAN',
		'PH045805000' => 'CAINTA',
		'PH045806000' => 'CARDONA',
		'PH045807000' => 'JALA-JALA',
		'PH045808000' => 'RODRIGUEZ (MONTALBAN)',
		'PH045809000' => 'MORONG',
		'PH045810000' => 'PILILLA',
		'PH045811000' => 'SAN MATEO',
		'PH045812000' => 'TANAY',
		'PH045813000' => 'TAYTAY',
		'PH045814000' => 'TERESA',
	],
	'PH170000000' => [
		'PH174001000' => 'BOAC',
		'PH174002000' => 'BUENAVISTA',
		'PH174003000' => 'GASAN',
		'PH174004000' => 'MOGPOG',
		'PH174005000' => 'SANTA CRUZ',
		'PH174006000' => 'TORRIJOS',
		'PH175101000' => 'ABRA DE ILOG',
		'PH175102000' => 'CALINTAAN',
		'PH175103000' => 'LOOC',
		'PH175104000' => 'LUBANG',
		'PH175105000' => 'MAGSAYSAY',
		'PH175106000' => 'MAMBURAO',
		'PH175107000' => 'PALUAN',
		'PH175108000' => 'RIZAL',
		'PH175109000' => 'SABLAYAN',
		'PH175110000' => 'SAN JOSE',
		'PH175111000' => 'SANTA CRUZ',
		'PH175201000' => 'BACO',
		'PH175202000' => 'BANSUD',
		'PH175203000' => 'BONGABONG',
		'PH175204000' => 'BULALACAO (SAN PEDRO)',
		'PH175205000' => 'CALAPAN',
		'PH175206000' => 'GLORIA',
		'PH175207000' => 'MANSALAY',
		'PH175208000' => 'NAUJAN',
		'PH175209000' => 'PINAMALAYAN',
		'PH175210000' => 'POLA',
		'PH175211000' => 'PUERTO GALERA',
		'PH175212000' => 'ROXAS',
		'PH175213000' => 'SAN TEODORO',
		'PH175214000' => 'SOCORRO',
		'PH175215000' => 'VICTORIA',
		'PH175301000' => 'ABORLAN',
		'PH175302000' => 'AGUTAYA',
		'PH175303000' => 'ARACELI',
		'PH175304000' => 'BALABAC',
		'PH175305000' => 'BATARAZA',
		'PH175306000' => 'BROOKES POINT',
		'PH175307000' => 'BUSUANGA',
		'PH175308000' => 'CAGAYANCILLO',
		'PH175309000' => 'CORON',
		'PH175310000' => 'CUYO',
		'PH175311000' => 'DUMARAN',
		'PH175312000' => 'EL NIDO (BACUIT)',
		'PH175313000' => 'LINAPACAN',
		'PH175314000' => 'MAGSAYSAY',
		'PH175315000' => 'NARRA',
		'PH175316000' => 'PUERTO PRINCESA',
		'PH175317000' => 'QUEZON',
		'PH175318000' => 'ROXAS',
		'PH175319000' => 'SAN VICENTE',
		'PH175320000' => 'TAYTAY',
		'PH175321000' => 'KALAYAAN',
		'PH175322000' => 'CULION',
		'PH175323000' => 'RIZAL (MARCOS)',
		'PH175324000' => 'SOFRONIO ESPAÑOLA',
		'PH175901000' => 'ALCANTARA',
		'PH175902000' => 'BANTON',
		'PH175903000' => 'CAJIDIOCAN',
		'PH175904000' => 'CALATRAVA',
		'PH175905000' => 'CONCEPCION',
		'PH175906000' => 'CORCUERA',
		'PH175907000' => 'LOOC',
		'PH175908000' => 'MAGDIWANG',
		'PH175909000' => 'ODIONGAN',
		'PH175910000' => 'ROMBLON',
		'PH175911000' => 'SAN AGUSTIN',
		'PH175912000' => 'SAN ANDRES',
		'PH175913000' => 'SAN FERNANDO',
		'PH175914000' => 'SAN JOSE',
		'PH175915000' => 'SANTA FE',
		'PH175916000' => 'FERROL',
		'PH175917000' => 'SANTA MARIA (IMELDA)',
	],
	'PH050000000' => [
		'PH050501000' => 'BACACAY',
		'PH050502000' => 'CAMALIG',
		'PH050503000' => 'DARAGA (LOCSIN)',
		'PH050504000' => 'GUINOBATAN',
		'PH050505000' => 'JOVELLAR',
		'PH050506000' => 'LEGAZPI',
		'PH050507000' => 'LIBON',
		'PH050508000' => 'LIGAO',
		'PH050509000' => 'MALILIPOT',
		'PH050510000' => 'MALINAO',
		'PH050511000' => 'MANITO',
		'PH050512000' => 'OAS',
		'PH050513000' => 'PIO DURAN',
		'PH050514000' => 'POLANGUI',
		'PH050515000' => 'RAPU-RAPU',
		'PH050516000' => 'SANTO DOMINGO (LIBOG)',
		'PH050517000' => 'TABACO',
		'PH050518000' => 'TIWI',
		'PH051601000' => 'BASUD',
		'PH051602000' => 'CAPALONGA',
		'PH051603000' => 'DAET',
		'PH051604000' => 'SAN LORENZO RUIZ (IMELDA)',
		'PH051605000' => 'JOSE PANGANIBAN',
		'PH051606000' => 'LABO',
		'PH051607000' => 'MERCEDES',
		'PH051608000' => 'PARACALE',
		'PH051609000' => 'SAN VICENTE',
		'PH051610000' => 'SANTA ELENA',
		'PH051611000' => 'TALISAY',
		'PH051612000' => 'VINZONS',
		'PH051701000' => 'BAAO',
		'PH051702000' => 'BALATAN',
		'PH051703000' => 'BATO',
		'PH051704000' => 'BOMBON',
		'PH051705000' => 'BUHI',
		'PH051706000' => 'BULA',
		'PH051707000' => 'CABUSAO',
		'PH051708000' => 'CALABANGA',
		'PH051709000' => 'CAMALIGAN',
		'PH051710000' => 'CANAMAN',
		'PH051711000' => 'CARAMOAN',
		'PH051712000' => 'DEL GALLEGO',
		'PH051713000' => 'GAINZA',
		'PH051714000' => 'GARCHITORENA',
		'PH051715000' => 'GOA',
		'PH051716000' => 'IRIGA',
		'PH051717000' => 'LAGONOY',
		'PH051718000' => 'LIBMANAN',
		'PH051719000' => 'LUPI',
		'PH051720000' => 'MAGARAO',
		'PH051721000' => 'MILAOR',
		'PH051722000' => 'MINALABAC',
		'PH051723000' => 'NABUA',
		'PH051724000' => 'NAGA',
		'PH051725000' => 'OCAMPO',
		'PH051726000' => 'PAMPLONA',
		'PH051727000' => 'PASACAO',
		'PH051728000' => 'PILI',
		'PH051729000' => 'PRESENTACION (PARUBCAN)',
		'PH051730000' => 'RAGAY',
		'PH051731000' => 'SAGÑAY',
		'PH051732000' => 'SAN FERNANDO',
		'PH051733000' => 'SAN JOSE',
		'PH051734000' => 'SIPOCOT',
		'PH051735000' => 'SIRUMA',
		'PH051736000' => 'TIGAON',
		'PH051737000' => 'TINAMBAC',
		'PH052001000' => 'BAGAMANOC',
		'PH052002000' => 'BARAS',
		'PH052003000' => 'BATO',
		'PH052004000' => 'CARAMORAN',
		'PH052005000' => 'GIGMOTO',
		'PH052006000' => 'PANDAN',
		'PH052007000' => 'PANGANIBAN (PAYO)',
		'PH052008000' => 'SAN ANDRES (CALOLBON)',
		'PH052009000' => 'SAN MIGUEL',
		'PH052010000' => 'VIGA',
		'PH052011000' => 'VIRAC',
		'PH054101000' => 'AROROY',
		'PH054102000' => 'BALENO',
		'PH054103000' => 'BALUD',
		'PH054104000' => 'BATUAN',
		'PH054105000' => 'CATAINGAN',
		'PH054106000' => 'CAWAYAN',
		'PH054107000' => 'CLAVERIA',
		'PH054108000' => 'DIMASALANG',
		'PH054109000' => 'ESPERANZA',
		'PH054110000' => 'MANDAON',
		'PH054111000' => 'MASBATE',
		'PH054112000' => 'MILAGROS',
		'PH054113000' => 'MOBO',
		'PH054114000' => 'MONREAL',
		'PH054115000' => 'PALANAS',
		'PH054116000' => 'PIO V. CORPUZ (LIMBUHAN)',
		'PH054117000' => 'PLACER',
		'PH054118000' => 'SAN FERNANDO',
		'PH054119000' => 'SAN JACINTO',
		'PH054120000' => 'SAN PASCUAL',
		'PH054121000' => 'USON',
		'PH056202000' => 'BARCELONA',
		'PH056203000' => 'BULAN',
		'PH056204000' => 'BULUSAN',
		'PH056205000' => 'CASIGURAN',
		'PH056206000' => 'CASTILLA',
		'PH056207000' => 'DONSOL',
		'PH056208000' => 'GUBAT',
		'PH056209000' => 'IROSIN',
		'PH056210000' => 'JUBAN',
		'PH056211000' => 'MAGALLANES',
		'PH056212000' => 'MATNOG',
		'PH056213000' => 'PILAR',
		'PH056214000' => 'PRIETO DIAZ',
		'PH056215000' => 'SANTA MAGDALENA',
		'PH056216000' => 'SORSOGON',
	],
	'PH060000000' => [
		'PH060401000' => 'ALTAVAS',
		'PH060402000' => 'BALETE',
		'PH060403000' => 'BANGA',
		'PH060404000' => 'BATAN',
		'PH060405000' => 'BURUANGA',
		'PH060406000' => 'IBAJAY',
		'PH060407000' => 'KALIBO',
		'PH060408000' => 'LEZO',
		'PH060409000' => 'LIBACAO',
		'PH060410000' => 'MADALAG',
		'PH060411000' => 'MAKATO',
		'PH060412000' => 'MALAY',
		'PH060413000' => 'MALINAO',
		'PH060414000' => 'NABAS',
		'PH060415000' => 'NEW WASHINGTON',
		'PH060416000' => 'NUMANCIA',
		'PH060417000' => 'TANGALAN',
		'PH060601000' => 'ANINI-Y',
		'PH060602000' => 'BARBAZA',
		'PH060603000' => 'BELISON',
		'PH060604000' => 'BUGASONG',
		'PH060605000' => 'CALUYA',
		'PH060606000' => 'CULASI',
		'PH060607000' => 'TOBIAS FORNIER (DAO)',
		'PH060608000' => 'HAMTIC',
		'PH060609000' => 'LAUA-AN',
		'PH060610000' => 'LIBERTAD',
		'PH060611000' => 'PANDAN',
		'PH060612000' => 'PATNONGON',
		'PH060613000' => 'SAN JOSE',
		'PH060614000' => 'SAN REMIGIO',
		'PH060615000' => 'SEBASTE',
		'PH060616000' => 'SIBALOM',
		'PH060617000' => 'TIBIAO',
		'PH060618000' => 'VALDERRAMA',
		'PH061901000' => 'CUARTERO',
		'PH061902000' => 'DAO',
		'PH061903000' => 'DUMALAG',
		'PH061904000' => 'DUMARAO',
		'PH061905000' => 'IVISAN',
		'PH061906000' => 'JAMINDAN',
		'PH061907000' => 'MA-AYON',
		'PH061908000' => 'MAMBUSAO',
		'PH061909000' => 'PANAY',
		'PH061910000' => 'PANITAN',
		'PH061911000' => 'PILAR',
		'PH061912000' => 'PONTEVEDRA',
		'PH061913000' => 'PRESIDENT ROXAS',
		'PH061914000' => 'ROXAS',
		'PH061915000' => 'SAPI-AN',
		'PH061916000' => 'SIGMA',
		'PH061917000' => 'TAPAZ',
		'PH063001000' => 'AJUY',
		'PH063002000' => 'ALIMODIAN',
		'PH063003000' => 'ANILAO',
		'PH063004000' => 'BADIANGAN',
		'PH063005000' => 'BALASAN',
		'PH063006000' => 'BANATE',
		'PH063007000' => 'BAROTAC NUEVO',
		'PH063008000' => 'BAROTAC VIEJO',
		'PH063009000' => 'BATAD',
		'PH063010000' => 'BINGAWAN',
		'PH063012000' => 'CABATUAN',
		'PH063013000' => 'CALINOG',
		'PH063014000' => 'CARLES',
		'PH063015000' => 'CONCEPCION',
		'PH063016000' => 'DINGLE',
		'PH063017000' => 'DUEÑAS',
		'PH063018000' => 'DUMANGAS',
		'PH063019000' => 'ESTANCIA',
		'PH063020000' => 'GUIMBAL',
		'PH063021000' => 'IGBARAS',
		'PH063022000' => 'ILOILO',
		'PH063023000' => 'JANIUAY',
		'PH063025000' => 'LAMBUNAO',
		'PH063026000' => 'LEGANES',
		'PH063027000' => 'LEMERY',
		'PH063028000' => 'LEON',
		'PH063029000' => 'MAASIN',
		'PH063030000' => 'MIAGAO',
		'PH063031000' => 'MINA',
		'PH063032000' => 'NEW LUCENA',
		'PH063034000' => 'OTON',
		'PH063035000' => 'PASSI',
		'PH063036000' => 'PAVIA',
		'PH063037000' => 'POTOTAN',
		'PH063038000' => 'SAN DIONISIO',
		'PH063039000' => 'SAN ENRIQUE',
		'PH063040000' => 'SAN JOAQUIN',
		'PH063041000' => 'SAN MIGUEL',
		'PH063042000' => 'SAN RAFAEL',
		'PH063043000' => 'SANTA BARBARA',
		'PH063044000' => 'SARA',
		'PH063045000' => 'TIGBAUAN',
		'PH063046000' => 'TUBUNGAN',
		'PH063047000' => 'ZARRAGA',
		'PH064501000' => 'BACOLOD',
		'PH064502000' => 'BAGO',
		'PH064503000' => 'BINALBAGAN',
		'PH064504000' => 'CADIZ',
		'PH064505000' => 'CALATRAVA',
		'PH064506000' => 'CANDONI',
		'PH064507000' => 'CAUAYAN',
		'PH064508000' => 'ENRIQUE B. MAGALONA (SARAVIA)',
		'PH064509000' => 'ESCALANTE',
		'PH064510000' => 'HIMAMAYLAN',
		'PH064511000' => 'HINIGARAN',
		'PH064512000' => 'HINOBA-AN (ASIA)',
		'PH064513000' => 'ILOG',
		'PH064514000' => 'ISABELA',
		'PH064515000' => 'KABANKALAN',
		'PH064516000' => 'LA CARLOTA',
		'PH064517000' => 'LA CASTELLANA',
		'PH064518000' => 'MANAPLA',
		'PH064519000' => 'MOISES PADILLA (MAGALLON)',
		'PH064520000' => 'MURCIA',
		'PH064521000' => 'PONTEVEDRA',
		'PH064522000' => 'PULUPANDAN',
		'PH064523000' => 'SAGAY',
		'PH064524000' => 'SAN CARLOS',
		'PH064525000' => 'SAN ENRIQUE',
		'PH064526000' => 'SILAY',
		'PH064527000' => 'SIPALAY',
		'PH064528000' => 'TALISAY',
		'PH064529000' => 'TOBOSO',
		'PH064530000' => 'VALLADOLID',
		'PH064531000' => 'VICTORIAS',
		'PH064532000' => 'SALVADOR BENEDICTO',
		'PH067901000' => 'BUENAVISTA',
		'PH067902000' => 'JORDAN',
		'PH067903000' => 'NUEVA VALENCIA',
		'PH067904000' => 'SAN LORENZO',
		'PH067905000' => 'SIBUNAG',
	],
	'PH070000000' => [
		'PH071201000' => 'ALBURQUERQUE',
		'PH071202000' => 'ALICIA',
		'PH071203000' => 'ANDA',
		'PH071204000' => 'ANTEQUERA',
		'PH071205000' => 'BACLAYON',
		'PH071206000' => 'BALILIHAN',
		'PH071207000' => 'BATUAN',
		'PH071208000' => 'BILAR',
		'PH071209000' => 'BUENAVISTA',
		'PH071210000' => 'CALAPE',
		'PH071211000' => 'CANDIJAY',
		'PH071212000' => 'CARMEN',
		'PH071213000' => 'CATIGBIAN',
		'PH071214000' => 'CLARIN',
		'PH071215000' => 'CORELLA',
		'PH071216000' => 'CORTES',
		'PH071217000' => 'DAGOHOY',
		'PH071218000' => 'DANAO',
		'PH071219000' => 'DAUIS',
		'PH071220000' => 'DIMIAO',
		'PH071221000' => 'DUERO',
		'PH071222000' => 'GARCIA HERNANDEZ',
		'PH071223000' => 'GUINDULMAN',
		'PH071224000' => 'INABANGA',
		'PH071225000' => 'JAGNA',
		'PH071226000' => 'GETAFE',
		'PH071227000' => 'LILA',
		'PH071228000' => 'LOAY',
		'PH071229000' => 'LOBOC',
		'PH071230000' => 'LOON',
		'PH071231000' => 'MABINI',
		'PH071232000' => 'MARIBOJOC',
		'PH071233000' => 'PANGLAO',
		'PH071234000' => 'PILAR',
		'PH071235000' => 'PRES. CARLOS P. GARCIA (PITOGO)',
		'PH071236000' => 'SAGBAYAN (BORJA)',
		'PH071237000' => 'SAN ISIDRO',
		'PH071238000' => 'SAN MIGUEL',
		'PH071239000' => 'SEVILLA',
		'PH071240000' => 'SIERRA BULLONES',
		'PH071241000' => 'SIKATUNA',
		'PH071242000' => 'TAGBILARAN',
		'PH071243000' => 'TALIBON',
		'PH071244000' => 'TRINIDAD',
		'PH071245000' => 'TUBIGON',
		'PH071246000' => 'UBAY',
		'PH071247000' => 'VALENCIA',
		'PH071248000' => 'BIEN UNIDO',
		'PH072201000' => 'ALCANTARA',
		'PH072202000' => 'ALCOY',
		'PH072203000' => 'ALEGRIA',
		'PH072204000' => 'ALOGUINSAN',
		'PH072205000' => 'ARGAO',
		'PH072206000' => 'ASTURIAS',
		'PH072207000' => 'BADIAN',
		'PH072208000' => 'BALAMBAN',
		'PH072209000' => 'BANTAYAN',
		'PH072210000' => 'BARILI',
		'PH072211000' => 'BOGO',
		'PH072212000' => 'BOLJOON',
		'PH072213000' => 'BORBON',
		'PH072214000' => 'CARCAR',
		'PH072215000' => 'CARMEN',
		'PH072216000' => 'CATMON',
		'PH072217000' => 'CEBU',
		'PH072218000' => 'COMPOSTELA',
		'PH072219000' => 'CONSOLACION',
		'PH072220000' => 'CORDOVA',
		'PH072221000' => 'DAANBANTAYAN',
		'PH072222000' => 'DALAGUETE',
		'PH072223000' => 'DANAO CITY',
		'PH072224000' => 'DUMANJUG',
		'PH072225000' => 'GINATILAN',
		'PH072226000' => 'LAPU-LAPU (OPON)',
		'PH072227000' => 'LILOAN',
		'PH072228000' => 'MADRIDEJOS',
		'PH072229000' => 'MALABUYOC',
		'PH072230000' => 'MANDAUE',
		'PH072231000' => 'MEDELLIN',
		'PH072232000' => 'MINGLANILLA',
		'PH072233000' => 'MOALBOAL',
		'PH072234000' => 'NAGA',
		'PH072235000' => 'OSLOB',
		'PH072236000' => 'PILAR',
		'PH072237000' => 'PINAMUNGAJAN',
		'PH072238000' => 'PORO',
		'PH072239000' => 'RONDA',
		'PH072240000' => 'SAMBOAN',
		'PH072241000' => 'SAN FERNANDO',
		'PH072242000' => 'SAN FRANCISCO',
		'PH072243000' => 'SAN REMIGIO',
		'PH072244000' => 'SANTA FE',
		'PH072245000' => 'SANTANDER',
		'PH072246000' => 'SIBONGA',
		'PH072247000' => 'SOGOD',
		'PH072248000' => 'TABOGON',
		'PH072249000' => 'TABUELAN',
		'PH072250000' => 'TALISAY',
		'PH072251000' => 'TOLEDO',
		'PH072252000' => 'TUBURAN',
		'PH072253000' => 'TUDELA',
		'PH074601000' => 'AMLAN (AYUQUITAN)',
		'PH074602000' => 'AYUNGON',
		'PH074603000' => 'BACONG',
		'PH074604000' => 'BAIS',
		'PH074605000' => 'BASAY',
		'PH074606000' => 'BAYAWAN (TULONG)',
		'PH074607000' => 'BINDOY (PAYABON)',
		'PH074608000' => 'CANLAON',
		'PH074609000' => 'DAUIN',
		'PH074610000' => 'DUMAGUETE',
		'PH074611000' => 'GUIHULNGAN',
		'PH074612000' => 'JIMALALUD',
		'PH074613000' => 'LA LIBERTAD',
		'PH074614000' => 'MABINAY',
		'PH074615000' => 'MANJUYOD',
		'PH074616000' => 'PAMPLONA',
		'PH074617000' => 'SAN JOSE',
		'PH074618000' => 'SANTA CATALINA',
		'PH074619000' => 'SIATON',
		'PH074620000' => 'SIBULAN',
		'PH074621000' => 'TANJAY',
		'PH074622000' => 'TAYASAN',
		'PH074623000' => 'VALENCIA (LUZURRIAGA)',
		'PH074624000' => 'VALLEHERMOSO',
		'PH074625000' => 'ZAMBOANGUITA',
		'PH076101000' => 'ENRIQUE VILLANUEVA',
		'PH076102000' => 'LARENA',
		'PH076103000' => 'LAZI',
		'PH076104000' => 'MARIA',
		'PH076105000' => 'SAN JUAN',
		'PH076106000' => 'SIQUIJOR',
	],
	'PH080000000' => [
		'PH082601000' => 'ARTECHE',
		'PH082602000' => 'BALANGIGA',
		'PH082603000' => 'BALANGKAYAN',
		'PH082604000' => 'BORONGAN',
		'PH082605000' => 'CAN-AVID',
		'PH082606000' => 'DOLORES',
		'PH082607000' => 'GENERAL MACARTHUR',
		'PH082608000' => 'GIPORLOS',
		'PH082609000' => 'GUIUAN',
		'PH082610000' => 'HERNANI',
		'PH082611000' => 'JIPAPAD',
		'PH082612000' => 'LAWAAN',
		'PH082613000' => 'LLORENTE',
		'PH082614000' => 'MASLOG',
		'PH082615000' => 'MAYDOLONG',
		'PH082616000' => 'MERCEDES',
		'PH082617000' => 'ORAS',
		'PH082618000' => 'QUINAPONDAN',
		'PH082619000' => 'SALCEDO',
		'PH082620000' => 'SAN JULIAN',
		'PH082621000' => 'SAN POLICARPO',
		'PH082622000' => 'SULAT',
		'PH082623000' => 'TAFT',
		'PH083701000' => 'ABUYOG',
		'PH083702000' => 'ALANGALANG',
		'PH083703000' => 'ALBUERA',
		'PH083705000' => 'BABATNGON',
		'PH083706000' => 'BARUGO',
		'PH083707000' => 'BATO',
		'PH083708000' => 'BAYBAY',
		'PH083710000' => 'BURAUEN',
		'PH083713000' => 'CALUBIAN',
		'PH083714000' => 'CAPOOCAN',
		'PH083715000' => 'CARIGARA',
		'PH083717000' => 'DAGAMI',
		'PH083718000' => 'DULAG',
		'PH083719000' => 'HILONGOS',
		'PH083720000' => 'HINDANG',
		'PH083721000' => 'INOPACAN',
		'PH083722000' => 'ISABEL',
		'PH083723000' => 'JARO',
		'PH083724000' => 'JAVIER (BUGHO)',
		'PH083725000' => 'JULITA',
		'PH083726000' => 'KANANGA',
		'PH083728000' => 'LA PAZ',
		'PH083729000' => 'LEYTE',
		'PH083730000' => 'MACARTHUR',
		'PH083731000' => 'MAHAPLAG',
		'PH083733000' => 'MATAG-OB',
		'PH083734000' => 'MATALOM',
		'PH083735000' => 'MAYORGA',
		'PH083736000' => 'MERIDA',
		'PH083738000' => 'ORMOC CITY',
		'PH083739000' => 'PALO',
		'PH083740000' => 'PALOMPON',
		'PH083741000' => 'PASTRANA',
		'PH083742000' => 'SAN ISIDRO',
		'PH083743000' => 'SAN MIGUEL',
		'PH083744000' => 'SANTA FE',
		'PH083745000' => 'TABANGO',
		'PH083746000' => 'TABONTABON',
		'PH083747000' => 'TACLOBAN',
		'PH083748000' => 'TANAUAN',
		'PH083749000' => 'TOLOSA',
		'PH083750000' => 'TUNGA',
		'PH083751000' => 'VILLABA',
		'PH084801000' => 'ALLEN',
		'PH084802000' => 'BIRI',
		'PH084803000' => 'BOBON',
		'PH084804000' => 'CAPUL',
		'PH084805000' => 'CATARMAN',
		'PH084806000' => 'CATUBIG',
		'PH084807000' => 'GAMAY',
		'PH084808000' => 'LAOANG',
		'PH084809000' => 'LAPINIG',
		'PH084810000' => 'LAS NAVAS',
		'PH084811000' => 'LAVEZARES',
		'PH084812000' => 'MAPANAS',
		'PH084813000' => 'MONDRAGON',
		'PH084814000' => 'PALAPAG',
		'PH084815000' => 'PAMBUJAN',
		'PH084816000' => 'ROSARIO',
		'PH084817000' => 'SAN ANTONIO',
		'PH084818000' => 'SAN ISIDRO',
		'PH084819000' => 'SAN JOSE',
		'PH084820000' => 'SAN ROQUE',
		'PH084821000' => 'SAN VICENTE',
		'PH084822000' => 'SILVINO LOBOS',
		'PH084823000' => 'VICTORIA',
		'PH084824000' => 'LOPE DE VEGA',
		'PH086001000' => 'ALMAGRO',
		'PH086002000' => 'BASEY',
		'PH086003000' => 'CALBAYOG',
		'PH086004000' => 'CALBIGA',
		'PH086005000' => 'CATBALOGAN',
		'PH086006000' => 'DARAM',
		'PH086007000' => 'GANDARA',
		'PH086008000' => 'HINABANGAN',
		'PH086009000' => 'JIABONG',
		'PH086010000' => 'MARABUT',
		'PH086011000' => 'MATUGUINAO',
		'PH086012000' => 'MOTIONG',
		'PH086013000' => 'PINABACDAO',
		'PH086014000' => 'SAN JOSE DE BUAN',
		'PH086015000' => 'SAN SEBASTIAN',
		'PH086016000' => 'SANTA MARGARITA',
		'PH086017000' => 'SANTA RITA',
		'PH086018000' => 'SANTO NIÑO',
		'PH086019000' => 'TALALORA',
		'PH086020000' => 'TARANGNAN',
		'PH086021000' => 'VILLAREAL',
		'PH086022000' => 'PARANAS (WRIGHT)',
		'PH086023000' => 'ZUMARRAGA',
		'PH086024000' => 'TAGAPUL-AN',
		'PH086025000' => 'SAN JORGE',
		'PH086026000' => 'PAGSANGHAN',
		'PH086401000' => 'ANAHAWAN',
		'PH086402000' => 'BONTOC',
		'PH086403000' => 'HINUNANGAN',
		'PH086404000' => 'HINUNDAYAN',
		'PH086405000' => 'LIBAGON',
		'PH086406000' => 'LILOAN',
		'PH086407000' => 'MAASIN',
		'PH086408000' => 'MACROHON',
		'PH086409000' => 'MALITBOG',
		'PH086410000' => 'PADRE BURGOS',
		'PH086411000' => 'PINTUYAN',
		'PH086412000' => 'SAINT BERNARD',
		'PH086413000' => 'SAN FRANCISCO',
		'PH086414000' => 'SAN JUAN (CABALIAN)',
		'PH086415000' => 'SAN RICARDO',
		'PH086416000' => 'SILAGO',
		'PH086417000' => 'SOGOD',
		'PH086418000' => 'TOMAS OPPUS',
		'PH086419000' => 'LIMASAWA',
		'PH087801000' => 'ALMERIA',
		'PH087802000' => 'BILIRAN',
		'PH087803000' => 'CABUCGAYAN',
		'PH087804000' => 'CAIBIRAN',
		'PH087805000' => 'CULABA',
		'PH087806000' => 'KAWAYAN',
		'PH087807000' => 'MARIPIPI',
		'PH087808000' => 'NAVAL',
	],
	'PH090000000' => [
		'PH097201000' => 'DAPITAN',
		'PH097202000' => 'DIPOLOG',
		'PH097203000' => 'KATIPUNAN',
		'PH097204000' => 'LA LIBERTAD',
		'PH097205000' => 'LABASON',
		'PH097206000' => 'LILOY',
		'PH097207000' => 'MANUKAN',
		'PH097208000' => 'MUTIA',
		'PH097209000' => 'PIÑAN (NEW PIÑAN)',
		'PH097210000' => 'POLANCO',
		'PH097211000' => 'PRES. MANUEL A. ROXAS',
		'PH097212000' => 'RIZAL',
		'PH097213000' => 'SALUG',
		'PH097214000' => 'SERGIO OSMEÑA SR.',
		'PH097215000' => 'SIAYAN',
		'PH097216000' => 'SIBUCO',
		'PH097217000' => 'SIBUTAD',
		'PH097218000' => 'SINDANGAN',
		'PH097219000' => 'SIOCON',
		'PH097220000' => 'SIRAWAI',
		'PH097221000' => 'TAMPILISAN',
		'PH097222000' => 'JOSE DALMAN (PONOT)',
		'PH097223000' => 'GUTALAC',
		'PH097224000' => 'BALIGUIAN',
		'PH097225000' => 'GODOD',
		'PH097226000' => 'BACUNGAN (Leon T. Postigo)',
		'PH097227000' => 'KALAWIT',
		'PH097302000' => 'AURORA',
		'PH097303000' => 'BAYOG',
		'PH097305000' => 'DIMATALING',
		'PH097306000' => 'DINAS',
		'PH097307000' => 'DUMALINAO',
		'PH097308000' => 'DUMINGAG',
		'PH097311000' => 'KUMALARANG',
		'PH097312000' => 'LABANGAN',
		'PH097313000' => 'LAPUYAN',
		'PH097315000' => 'MAHAYAG',
		'PH097317000' => 'MARGOSATUBIG',
		'PH097318000' => 'MIDSALIP',
		'PH097319000' => 'MOLAVE',
		'PH097322000' => 'PAGADIAN',
		'PH097323000' => 'RAMON MAGSAYSAY (LIARGO)',
		'PH097324000' => 'SAN MIGUEL',
		'PH097325000' => 'SAN PABLO',
		'PH097327000' => 'TABINA',
		'PH097328000' => 'TAMBULIG',
		'PH097330000' => 'TUKURAN',
		'PH097332000' => 'ZAMBOANGA',
		'PH097333000' => 'LAKEWOOD',
		'PH097337000' => 'JOSEFINA',
		'PH097338000' => 'PITOGO',
		'PH097340000' => 'SOMINOT (DON MARIANO MARCOS)',
		'PH097341000' => 'VINCENZO A. SAGUN',
		'PH097343000' => 'GUIPOS',
		'PH097344000' => 'TIGBAO',
		'PH098301000' => 'ALICIA',
		'PH098302000' => 'BUUG',
		'PH098303000' => 'DIPLAHAN',
		'PH098304000' => 'IMELDA',
		'PH098305000' => 'IPIL',
		'PH098306000' => 'KABASALAN',
		'PH098307000' => 'MABUHAY',
		'PH098308000' => 'MALANGAS',
		'PH098309000' => 'NAGA',
		'PH098310000' => 'OLUTANGA',
		'PH098311000' => 'PAYAO',
		'PH098312000' => 'ROSELLER LIM',
		'PH098313000' => 'SIAY',
		'PH098314000' => 'TALUSAN',
		'PH098315000' => 'TITAY',
		'PH098316000' => 'TUNGAWAN',
		'PH099701000' => 'ISABELA',
	],
	'PH100000000' => [
		'PH101301000' => 'BAUNGON',
		'PH101302000' => 'DAMULOG',
		'PH101303000' => 'DANGCAGAN',
		'PH101304000' => 'DON CARLOS',
		'PH101305000' => 'IMPASUG-ONG',
		'PH101306000' => 'KADINGILAN',
		'PH101307000' => 'KALILANGAN',
		'PH101308000' => 'KIBAWE',
		'PH101309000' => 'KITAOTAO',
		'PH101310000' => 'LANTAPAN',
		'PH101311000' => 'LIBONA',
		'PH101312000' => 'MALAYBALAY',
		'PH101313000' => 'MALITBOG',
		'PH101314000' => 'MANOLO FORTICH',
		'PH101315000' => 'MARAMAG',
		'PH101316000' => 'PANGANTUCAN',
		'PH101317000' => 'QUEZON',
		'PH101318000' => 'SAN FERNANDO',
		'PH101319000' => 'SUMILAO',
		'PH101320000' => 'TALAKAG',
		'PH101321000' => 'VALENCIA',
		'PH101322000' => 'CABANGLASAN',
		'PH101801000' => 'CATARMAN',
		'PH101802000' => 'GUINSILIBAN',
		'PH101803000' => 'MAHINOG',
		'PH101804000' => 'MAMBAJAO',
		'PH101805000' => 'SAGAY',
		'PH103501000' => 'BACOLOD',
		'PH103502000' => 'BALOI',
		'PH103503000' => 'BAROY',
		'PH103504000' => 'ILIGAN',
		'PH103505000' => 'KAPATAGAN',
		'PH103506000' => 'SULTAN NAGA DIMAPORO (KAROMATAN)',
		'PH103507000' => 'KAUSWAGAN',
		'PH103508000' => 'KOLAMBUGAN',
		'PH103509000' => 'LALA',
		'PH103510000' => 'LINAMON',
		'PH103511000' => 'MAGSAYSAY',
		'PH103512000' => 'MAIGO',
		'PH103513000' => 'MATUNGAO',
		'PH103514000' => 'MUNAI',
		'PH103515000' => 'NUNUNGAN',
		'PH103516000' => 'PANTAO RAGAT',
		'PH103517000' => 'POONA PIAGAPO',
		'PH103518000' => 'SALVADOR',
		'PH103519000' => 'SAPAD',
		'PH103520000' => 'TAGOLOAN',
		'PH103521000' => 'TANGCAL',
		'PH103522000' => 'TUBOD',
		'PH103523000' => 'PANTAR',
		'PH104201000' => 'ALORAN',
		'PH104202000' => 'BALIANGAO',
		'PH104203000' => 'BONIFACIO',
		'PH104204000' => 'CALAMBA',
		'PH104205000' => 'CLARIN',
		'PH104206000' => 'CONCEPCION',
		'PH104207000' => 'JIMENEZ',
		'PH104208000' => 'LOPEZ JAENA',
		'PH104209000' => 'OROQUIETA',
		'PH104210000' => 'OZAMIZ',
		'PH104211000' => 'PANAON',
		'PH104212000' => 'PLARIDEL',
		'PH104213000' => 'SAPANG DALAGA',
		'PH104214000' => 'SINACABAN',
		'PH104215000' => 'TANGUB',
		'PH104216000' => 'TUDELA',
		'PH104217000' => 'DON VICTORIANO CHIONGBIAN (DON MARIANO MARCOS)',
		'PH104301000' => 'ALUBIJID',
		'PH104302000' => 'BALINGASAG',
		'PH104303000' => 'BALINGOAN',
		'PH104304000' => 'BINUANGAN',
		'PH104305000' => 'CAGAYAN DE ORO',
		'PH104306000' => 'CLAVERIA',
		'PH104307000' => 'EL SALVADOR',
		'PH104308000' => 'GINGOOG',
		'PH104309000' => 'GITAGUM',
		'PH104310000' => 'INITAO',
		'PH104311000' => 'JASAAN',
		'PH104312000' => 'KINOGUITAN',
		'PH104313000' => 'LAGONGLONG',
		'PH104314000' => 'LAGUINDINGAN',
		'PH104315000' => 'LIBERTAD',
		'PH104316000' => 'LUGAIT',
		'PH104317000' => 'MAGSAYSAY (LINUGOS)',
		'PH104318000' => 'MANTICAO',
		'PH104319000' => 'MEDINA',
		'PH104320000' => 'NAAWAN',
		'PH104321000' => 'OPOL',
		'PH104322000' => 'SALAY',
		'PH104323000' => 'SUGBONGCOGON',
		'PH104324000' => 'TAGOLOAN',
		'PH104325000' => 'TALISAYAN',
		'PH104326000' => 'VILLANUEVA',
	],
	'PH110000000' => [
		'PH112301000' => 'ASUNCION (SAUG)',
		'PH112303000' => 'CARMEN',
		'PH112305000' => 'KAPALONG',
		'PH112314000' => 'NEW CORELLA',
		'PH112315000' => 'PANABO',
		'PH112317000' => 'ISLAND GARDEN SAMAL',
		'PH112318000' => 'SANTO TOMAS',
		'PH112319000' => 'TAGUM',
		'PH112322000' => 'TALAINGOD',
		'PH112323000' => 'BRAULIO E. DUJALI',
		'PH112324000' => 'SAN ISIDRO',
		'PH112401000' => 'BANSALAN',
		'PH112402000' => 'DAVAO',
		'PH112403000' => 'DIGOS',
		'PH112404000' => 'HAGONOY',
		'PH112406000' => 'KIBLAWAN',
		'PH112407000' => 'MAGSAYSAY',
		'PH112408000' => 'MALALAG',
		'PH112410000' => 'MATANAO',
		'PH112411000' => 'PADADA',
		'PH112412000' => 'SANTA CRUZ',
		'PH112414000' => 'SULOP',
		'PH112501000' => 'BAGANGA',
		'PH112502000' => 'BANAYBANAY',
		'PH112503000' => 'BOSTON',
		'PH112504000' => 'CARAGA',
		'PH112505000' => 'CATEEL',
		'PH112506000' => 'GOVERNOR GENEROSO',
		'PH112507000' => 'LUPON',
		'PH112508000' => 'MANAY',
		'PH112509000' => 'MATI',
		'PH112510000' => 'SAN ISIDRO',
		'PH112511000' => 'TARRAGONA',
		'PH118201000' => 'COMPOSTELA',
		'PH118202000' => 'LAAK (SAN VICENTE)',
		'PH118203000' => 'MABINI (DOÑA ALICIA)',
		'PH118204000' => 'MACO',
		'PH118205000' => 'MARAGUSAN (SAN MARIANO)',
		'PH118206000' => 'MAWAB',
		'PH118207000' => 'MONKAYO',
		'PH118208000' => 'MONTEVISTA',
		'PH118209000' => 'NABUNTURAN',
		'PH118210000' => 'NEW BATAAN',
		'PH118211000' => 'PANTUKAN',
		'PH118601000' => 'DON MARCELINO',
		'PH118602000' => 'JOSE ABAD SANTOS (TRINIDAD)',
		'PH118603000' => 'MALITA',
		'PH118604000' => 'SANTA MARIA',
		'PH118605000' => 'SARANGANI',
	],
	'PH120000000' => [
		'PH124701000' => 'ALAMADA',
		'PH124702000' => 'CARMEN',
		'PH124703000' => 'KABACAN',
		'PH124704000' => 'KIDAPAWAN',
		'PH124705000' => 'LIBUNGAN',
		'PH124706000' => 'MAGPET',
		'PH124707000' => 'MAKILALA',
		'PH124708000' => 'MATALAM',
		'PH124709000' => 'MIDSAYAP',
		'PH124710000' => 'MLANG',
		'PH124711000' => 'PIGKAWAYAN',
		'PH124712000' => 'PIKIT',
		'PH124713000' => 'PRESIDENT ROXAS',
		'PH124714000' => 'TULUNAN',
		'PH124715000' => 'ANTIPAS',
		'PH124716000' => 'BANISILAN',
		'PH124717000' => 'ALEOSAN',
		'PH124718000' => 'ARAKAN',
		'PH126302000' => 'BANGA',
		'PH126303000' => 'GENERAL SANTOS (DADIANGAS)',
		'PH126306000' => 'KORONADAL',
		'PH126311000' => 'NORALA',
		'PH126312000' => 'POLOMOLOK',
		'PH126313000' => 'SURALLAH',
		'PH126314000' => 'TAMPAKAN',
		'PH126315000' => 'TANTANGAN',
		'PH126316000' => 'TBOLI',
		'PH126317000' => 'TUPI',
		'PH126318000' => 'SANTO NIÑO',
		'PH126319000' => 'LAKE SEBU',
		'PH126501000' => 'BAGUMBAYAN',
		'PH126502000' => 'COLUMBIO',
		'PH126503000' => 'ESPERANZA',
		'PH126504000' => 'ISULAN',
		'PH126505000' => 'KALAMANSIG',
		'PH126506000' => 'LEBAK',
		'PH126507000' => 'LUTAYAN',
		'PH126508000' => 'LAMBAYONG (MARIANO MARCOS)',
		'PH126509000' => 'PALIMBANG',
		'PH126510000' => 'PRESIDENT QUIRINO',
		'PH126511000' => 'TACURONG',
		'PH126512000' => 'SEN. NINOY AQUINO',
		'PH128001000' => 'ALABEL',
		'PH128002000' => 'GLAN',
		'PH128003000' => 'KIAMBA',
		'PH128004000' => 'MAASIM',
		'PH128005000' => 'MAITUM',
		'PH128006000' => 'MALAPATAN',
		'PH128007000' => 'MALUNGON',
		'PH129804000' => 'COTABATO',
	],
	'PH130000000' => [
		'PH133900000' => 'MANILA',
		'PH137401000' => 'MANDALUYONG',
		'PH137402000' => 'MARIKINA',
		'PH137403000' => 'PASIG',
		'PH137404000' => 'QUEZON CITY',
		'PH137405000' => 'SAN JUAN',
		'PH137501000' => 'CALOOCAN',
		'PH137502000' => 'MALABON',
		'PH137503000' => 'NAVOTAS',
		'PH137504000' => 'VALENZUELA',
		'PH137601000' => 'LAS PIÑAS',
		'PH137602000' => 'MAKATI',
		'PH137603000' => 'MUNTINLUPA',
		'PH137604000' => 'PARAÑAQUE',
		'PH137605000' => 'PASAY CITY',
		'PH137606000' => 'PATEROS',
		'PH137607000' => 'TAGUIG',
	],
	'PH140000000' => [
		'PH140101000' => 'BANGUED',
		'PH140102000' => 'BOLINEY',
		'PH140103000' => 'BUCAY',
		'PH140104000' => 'BUCLOC',
		'PH140105000' => 'DAGUIOMAN',
		'PH140106000' => 'DANGLAS',
		'PH140107000' => 'DOLORES',
		'PH140108000' => 'LA PAZ',
		'PH140109000' => 'LACUB',
		'PH140110000' => 'LAGANGILANG',
		'PH140111000' => 'LAGAYAN',
		'PH140112000' => 'LANGIDEN',
		'PH140113000' => 'LICUAN-BAAY (LICUAN)',
		'PH140114000' => 'LUBA',
		'PH140115000' => 'MALIBCONG',
		'PH140116000' => 'MANABO',
		'PH140117000' => 'PEÑARRUBIA',
		'PH140118000' => 'PIDIGAN',
		'PH140119000' => 'PILAR',
		'PH140120000' => 'SALLAPADAN',
		'PH140121000' => 'SAN ISIDRO',
		'PH140122000' => 'SAN JUAN',
		'PH140123000' => 'SAN QUINTIN',
		'PH140124000' => 'TAYUM',
		'PH140125000' => 'TINEG',
		'PH140126000' => 'TUBO',
		'PH140127000' => 'VILLAVICIOSA',
		'PH141101000' => 'ATOK',
		'PH141102000' => 'BAGUIO',
		'PH141103000' => 'BAKUN',
		'PH141104000' => 'BOKOD',
		'PH141105000' => 'BUGUIAS',
		'PH141106000' => 'ITOGON',
		'PH141107000' => 'KABAYAN',
		'PH141108000' => 'KAPANGAN',
		'PH141109000' => 'KIBUNGAN',
		'PH141110000' => 'LA TRINIDAD',
		'PH141111000' => 'MANKAYAN',
		'PH141112000' => 'SABLAN',
		'PH141113000' => 'TUBA',
		'PH141114000' => 'TUBLAY',
		'PH142701000' => 'BANAUE',
		'PH142702000' => 'HUNGDUAN',
		'PH142703000' => 'KIANGAN',
		'PH142704000' => 'LAGAWE',
		'PH142705000' => 'LAMUT',
		'PH142706000' => 'MAYOYAO',
		'PH142707000' => 'ALFONSO LISTA (POTIA)',
		'PH142708000' => 'AGUINALDO',
		'PH142709000' => 'HINGYON',
		'PH142710000' => 'TINOC',
		'PH142711000' => 'ASIPULO',
		'PH143201000' => 'BALBALAN',
		'PH143206000' => 'LUBUAGAN',
		'PH143208000' => 'PASIL',
		'PH143209000' => 'PINUKPUK',
		'PH143211000' => 'RIZAL (LIWAN)',
		'PH143213000' => 'TABUK',
		'PH143214000' => 'TANUDAN',
		'PH143215000' => 'TINGLAYAN',
		'PH144401000' => 'BARLIG',
		'PH144402000' => 'BAUKO',
		'PH144403000' => 'BESAO',
		'PH144404000' => 'BONTOC',
		'PH144405000' => 'NATONIN',
		'PH144406000' => 'PARACELIS',
		'PH144407000' => 'SABANGAN',
		'PH144408000' => 'SADANGA',
		'PH144409000' => 'SAGADA',
		'PH144410000' => 'TADIAN',
		'PH148101000' => 'CALANASAN (BAYAG)',
		'PH148102000' => 'CONNER',
		'PH148103000' => 'FLORA',
		'PH148104000' => 'KABUGAO',
		'PH148105000' => 'LUNA',
		'PH148106000' => 'PUDTOL',
		'PH148107000' => 'SANTA MARCELA',
	],
	'PH150000000' => [
		'PH150702000' => 'LAMITAN',
		'PH150703000' => 'LANTAWAN',
		'PH150704000' => 'MALUSO',
		'PH150705000' => 'SUMISIP',
		'PH150706000' => 'TIPO-TIPO',
		'PH150707000' => 'TUBURAN',
		'PH150708000' => 'AKBAR',
		'PH150709000' => 'AL-BARKA',
		'PH150710000' => 'HADJI MOHAMMAD AJUL',
		'PH150711000' => 'UNGKAYA PUKAN',
		'PH150712000' => 'HADJI MUHTAMAD',
		'PH150713000' => 'TABUAN-LASA',
		'PH153601000' => 'BACOLOD-KALAWI (BACOLOD GRANDE)',
		'PH153602000' => 'BALABAGAN',
		'PH153603000' => 'BALINDONG (WATU)',
		'PH153604000' => 'BAYANG',
		'PH153605000' => 'BINIDAYAN',
		'PH153606000' => 'BUBONG',
		'PH153607000' => 'BUTIG',
		'PH153609000' => 'GANASSI',
		'PH153610000' => 'KAPAI',
		'PH153611000' => 'LUMBA-BAYABAO (MAGUING)',
		'PH153612000' => 'LUMBATAN',
		'PH153613000' => 'MADALUM',
		'PH153614000' => 'MADAMBA',
		'PH153615000' => 'MALABANG',
		'PH153616000' => 'MARANTAO',
		'PH153617000' => 'MARAWI',
		'PH153618000' => 'MASIU',
		'PH153619000' => 'MULONDO',
		'PH153620000' => 'PAGAYAWAN (TATARIKAN)',
		'PH153621000' => 'PIAGAPO',
		'PH153622000' => 'POONA BAYABAO (GATA)',
		'PH153623000' => 'PUALAS',
		'PH153624000' => 'DITSAAN-RAMAIN',
		'PH153625000' => 'SAGUIARAN',
		'PH153626000' => 'TAMPARAN',
		'PH153627000' => 'TARAKA',
		'PH153628000' => 'TUBARAN',
		'PH153629000' => 'TUGAYA',
		'PH153630000' => 'WAO',
		'PH153631000' => 'MAROGONG',
		'PH153632000' => 'CALANOGAS',
		'PH153633000' => 'BUADIPOSO-BUNTONG',
		'PH153634000' => 'MAGUING',
		'PH153635000' => 'PICONG (SULTAN GUMANDER)',
		'PH153636000' => 'LUMBAYANAGUE',
		'PH153637000' => 'AMAI MANABILANG (BUMBARAN)',
		'PH153638000' => 'TAGOLOAN II',
		'PH153639000' => 'KAPATAGAN',
		'PH153640000' => 'SULTAN DUMALONDONG',
		'PH153641000' => 'LUMBACA-UNAYAN',
		'PH153801000' => 'AMPATUAN',
		'PH153802000' => 'BULDON',
		'PH153803000' => 'BULUAN',
		'PH153805000' => 'DATU PAGLAS',
		'PH153806000' => 'DATU PIANG',
		'PH153807000' => 'DATU ODIN SINSUAT (DINAIG)',
		'PH153808000' => 'SHARIFF AGUAK (MAGANOY)',
		'PH153809000' => 'MATANOG',
		'PH153810000' => 'PAGALUNGAN',
		'PH153811000' => 'PARANG',
		'PH153812000' => 'SULTAN KUDARAT (NULING)',
		'PH153813000' => 'SULTAN SA BARONGIS (LAMBAYONG)',
		'PH153814000' => 'KABUNTALAN (TUMBAO)',
		'PH153815000' => 'UPI',
		'PH153816000' => 'TALAYAN',
		'PH153817000' => 'SOUTH UPI',
		'PH153818000' => 'BARIRA',
		'PH153819000' => 'GEN. S.K. PENDATUN',
		'PH153820000' => 'MAMASAPANO',
		'PH153821000' => 'TALITAY',
		'PH153822000' => 'PAGAGAWAN',
		'PH153823000' => 'PAGLAT',
		'PH153824000' => 'SULTAN MASTURA',
		'PH153825000' => 'GUINDULUNGAN',
		'PH153826000' => 'DATU SAUDI-AMPATUAN',
		'PH153827000' => 'DATU UNSAY',
		'PH153828000' => 'DATU ABDULLAH SANGKI',
		'PH153829000' => 'RAJAH BUAYAN',
		'PH153830000' => 'DATU BLAH T. SINSUAT',
		'PH153831000' => 'DATU ANGGAL MIDTIMBANG',
		'PH153832000' => 'MANGUDADATU',
		'PH153833000' => 'PANDAG',
		'PH153834000' => 'NORTHERN KABUNTALAN',
		'PH153835000' => 'DATU HOFFER AMPATUAN',
		'PH153836000' => 'DATU SALIBO',
		'PH153837000' => 'SHARIFF SAYDONA MUSTAPHA',
		'PH156601000' => 'INDANAN',
		'PH156602000' => 'JOLO',
		'PH156603000' => 'KALINGALAN CALUANG',
		'PH156604000' => 'LUUK',
		'PH156605000' => 'MAIMBUNG',
		'PH156606000' => 'HADJI PANGLIMA TAHIL (MARUNGGAS)',
		'PH156607000' => 'OLD PANAMAO',
		'PH156608000' => 'PANGUTARAN',
		'PH156609000' => 'PARANG',
		'PH156610000' => 'PATA',
		'PH156611000' => 'PATIKUL',
		'PH156612000' => 'SIASI',
		'PH156613000' => 'TALIPAO',
		'PH156614000' => 'TAPUL',
		'PH156615000' => 'TONGKIL',
		'PH156616000' => 'PANGLIMA ESTINO (NEW PANAMAO)',
		'PH156617000' => 'LUGUS',
		'PH156618000' => 'PANDAMI',
		'PH156619000' => 'OMAR',
		'PH157001000' => 'PANGLIMA SUGALA (BALIMBING)',
		'PH157002000' => 'BONGAO',
		'PH157003000' => 'MAPUN (CAGAYAN DE TAWI-TAWI)',
		'PH157004000' => 'SIMUNUL',
		'PH157005000' => 'SITANGKAI',
		'PH157006000' => 'SOUTH UBIAN',
		'PH157007000' => 'TANDUBAS',
		'PH157008000' => 'TURTLE ISLANDS',
		'PH157009000' => 'LANGUYAN',
		'PH157010000' => 'SAPA-SAPA',
		'PH157011000' => 'SIBUTU',
	],
	'PH160000000' => [
		'PH160201000' => 'BUENAVISTA',
		'PH160202000' => 'BUTUAN',
		'PH160203000' => 'CABADBARAN',
		'PH160204000' => 'CARMEN',
		'PH160205000' => 'JABONGA',
		'PH160206000' => 'KITCHARAO',
		'PH160207000' => 'LAS NIEVES',
		'PH160208000' => 'MAGALLANES',
		'PH160209000' => 'NASIPIT',
		'PH160210000' => 'SANTIAGO',
		'PH160211000' => 'TUBAY',
		'PH160212000' => 'REMEDIOS T. ROMUALDEZ',
		'PH160301000' => 'BAYUGAN',
		'PH160302000' => 'BUNAWAN',
		'PH160303000' => 'ESPERANZA',
		'PH160304000' => 'LA PAZ',
		'PH160305000' => 'LORETO',
		'PH160306000' => 'PROSPERIDAD',
		'PH160307000' => 'ROSARIO',
		'PH160308000' => 'SAN FRANCISCO',
		'PH160309000' => 'SAN LUIS',
		'PH160310000' => 'SANTA JOSEFA',
		'PH160311000' => 'TALACOGON',
		'PH160312000' => 'TRENTO',
		'PH160313000' => 'VERUELA',
		'PH160314000' => 'SIBAGAT',
		'PH166701000' => 'ALEGRIA',
		'PH166702000' => 'BACUAG',
		'PH166704000' => 'BURGOS',
		'PH166706000' => 'CLAVER',
		'PH166707000' => 'DAPA',
		'PH166708000' => 'DEL CARMEN',
		'PH166710000' => 'GENERAL LUNA',
		'PH166711000' => 'GIGAQUIT',
		'PH166714000' => 'MAINIT',
		'PH166715000' => 'MALIMONO',
		'PH166716000' => 'PILAR',
		'PH166717000' => 'PLACER',
		'PH166718000' => 'SAN BENITO',
		'PH166719000' => 'SAN FRANCISCO (ANAO-AON)',
		'PH166720000' => 'SAN ISIDRO',
		'PH166721000' => 'SANTA MONICA (SAPAO)',
		'PH166722000' => 'SISON',
		'PH166723000' => 'SOCORRO',
		'PH166724000' => 'SURIGAO',
		'PH166725000' => 'TAGANA-AN',
		'PH166727000' => 'TUBOD',
		'PH166801000' => 'BAROBO',
		'PH166802000' => 'BAYABAS',
		'PH166803000' => 'BISLIG',
		'PH166804000' => 'CAGWAIT',
		'PH166805000' => 'CANTILAN',
		'PH166806000' => 'CARMEN',
		'PH166807000' => 'CARRASCAL',
		'PH166808000' => 'CORTES',
		'PH166809000' => 'HINATUAN',
		'PH166810000' => 'LANUZA',
		'PH166811000' => 'LIANGA',
		'PH166812000' => 'LINGIG',
		'PH166813000' => 'MADRID',
		'PH166814000' => 'MARIHATAG',
		'PH166815000' => 'SAN AGUSTIN',
		'PH166816000' => 'SAN MIGUEL',
		'PH166817000' => 'TAGBINA',
		'PH166818000' => 'TAGO',
		'PH166819000' => 'TANDAG',
		'PH168501000' => 'BASILISA (RIZAL)',
		'PH168502000' => 'CAGDIANAO',
		'PH168503000' => 'DINAGAT',
		'PH168504000' => 'LIBJO (ALBOR)',
		'PH168505000' => 'LORETO',
		'PH168506000' => 'SAN JOSE',
		'PH168507000' => 'TUBAJON',
	]
];
