<?php

/**
 * List of cities for: Peru
 * Source: https://www.datosabiertos.gob.pe/dataset/codigos-equivalentes-de-ubigeo-del-peru
 * Version: 1.2
 * Author: Condless
 * Editor: @PavelValencis
 * Author URI: https://en.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['PE'];

$country_cities = [
	'AMA' => [
		'PE010101' => 'Chachapoyas',
		'PE010102' => 'Asuncion',
		'PE010103' => 'Balsas',
		'PE010104' => 'Cheto',
		'PE010105' => 'Chiliquin',
		'PE010106' => 'Chuquibamba',
		'PE010107' => 'Granada',
		'PE010108' => 'Huancas',
		'PE010109' => 'La Jalca',
		'PE010110' => 'Leimebamba',
		'PE010111' => 'Levanto',
		'PE010112' => 'Magdalena',
		'PE010113' => 'Mariscal Castilla',
		'PE010114' => 'Molinopampa',
		'PE010115' => 'Montevideo',
		'PE010116' => 'Olleros',
		'PE010117' => 'Quinjalca',
		'PE010118' => 'San Francisco de Daguas',
		'PE010119' => 'San Isidro de Maino',
		'PE010120' => 'Soloco',
		'PE010121' => 'Sonche',
		'PE010205' => 'Bagua',
		'PE010202' => 'Aramango',
		'PE010203' => 'Copallin',
		'PE010204' => 'El Parco',
		'PE010206' => 'Imaza',
		'PE010201' => 'La Peca',
		'PE010301' => 'Jumbilla',
		'PE010304' => 'Chisquilla',
		'PE010305' => 'Churuja',
		'PE010302' => 'Corosha',
		'PE010303' => 'Cuispes',
		'PE010306' => 'Florida',
		'PE010312' => 'Jazan',
		'PE010307' => 'Recta',
		'PE010308' => 'San Carlos',
		'PE010309' => 'Shipasbamba',
		'PE010310' => 'Valera',
		'PE010311' => 'Yambrasbamba',
		'PE010601' => 'Nieva',
		'PE010603' => 'El Cenepa',
		'PE010602' => 'Rio Santiago',
		'PE010401' => 'Lamud',
		'PE010402' => 'Camporredondo',
		'PE010403' => 'Cocabamba',
		'PE010404' => 'Colcamar',
		'PE010405' => 'Conila',
		'PE010406' => 'Inguilpata',
		'PE010407' => 'Longuita',
		'PE010408' => 'Lonya Chico',
		'PE010409' => 'Luya',
		'PE010410' => 'Luya Viejo',
		'PE010411' => 'Maria',
		'PE010412' => 'Ocalli',
		'PE010413' => 'Ocumal',
		'PE010414' => 'Pisuquia',
		'PE010423' => 'Providencia',
		'PE010415' => 'San Cristobal',
		'PE010416' => 'San Francisco del Yeso',
		'PE010417' => 'San Jeronimo',
		'PE010418' => 'San Juan de Lopecancha',
		'PE010419' => 'Santa Catalina',
		'PE010420' => 'Santo Tomas',
		'PE010421' => 'Tingo',
		'PE010422' => 'Trita',
		'PE010501' => 'San Nicolas',
		'PE010503' => 'Chirimoto',
		'PE010502' => 'Cochamal',
		'PE010504' => 'Huambo',
		'PE010505' => 'Limabamba',
		'PE010506' => 'Longar',
		'PE010508' => 'Mariscal Benavides',
		'PE010507' => 'Milpuc',
		'PE010509' => 'Omia',
		'PE010510' => 'Santa Rosa',
		'PE010511' => 'Totora',
		'PE010512' => 'Vista Alegre',
		'PE010701' => 'Bagua Grande',
		'PE010702' => 'Cajaruro',
		'PE010703' => 'Cumba',
		'PE010704' => 'El Milagro',
		'PE010705' => 'Jamalca',
		'PE010706' => 'Lonya Grande',
		'PE010707' => 'Yamon',
	],
	'ANC' => [
		'PE020101' => 'Huaraz',
		'PE020103' => 'Cochabamba',
		'PE020104' => 'Colcabamba',
		'PE020105' => 'Huanchay',
		'PE020102' => 'Independencia',
		'PE020106' => 'Jangas',
		'PE020107' => 'La Libertad',
		'PE020108' => 'Olleros',
		'PE020109' => 'Pampas',
		'PE020110' => 'Pariacoto',
		'PE020111' => 'Pira',
		'PE020112' => 'Tarica',
		'PE020201' => 'Aija',
		'PE020203' => 'Coris',
		'PE020205' => 'Huacllan',
		'PE020206' => 'La Merced',
		'PE020208' => 'Succha',
		'PE021601' => 'Llamellin',
		'PE021602' => 'Aczo',
		'PE021603' => 'Chaccho',
		'PE021604' => 'Chingas',
		'PE021605' => 'Mirgas',
		'PE021606' => 'San Juan de Rontoy',
		'PE021801' => 'Chacas',
		'PE021802' => 'Acochaca',
		'PE020301' => 'Chiquian',
		'PE020302' => 'Abelardo Pardo Lezameta',
		'PE020321' => 'Antonio Raymondi',
		'PE020304' => 'Aquia',
		'PE020305' => 'Cajacay',
		'PE020322' => 'Canis',
		'PE020323' => 'Colquioc',
		'PE020325' => 'Huallanca',
		'PE020311' => 'Huasta',
		'PE020310' => 'Huayllacayan',
		'PE020324' => 'La Primavera',
		'PE020313' => 'Mangas',
		'PE020315' => 'Pacllon',
		'PE020317' => 'San Miguel de Corpanqui',
		'PE020320' => 'Ticllos',
		'PE020401' => 'Carhuaz',
		'PE020402' => 'Acopampa',
		'PE020403' => 'Amashca',
		'PE020404' => 'Anta',
		'PE020405' => 'Ataquero',
		'PE020406' => 'Marcara',
		'PE020407' => 'Pariahuanca',
		'PE020408' => 'San Miguel de Aco',
		'PE020409' => 'Shilla',
		'PE020410' => 'Tinco',
		'PE020411' => 'Yungar',
		'PE021701' => 'San Luis',
		'PE021703' => 'San Nicolas',
		'PE021702' => 'Yauya',
		'PE020501' => 'Casma',
		'PE020502' => 'Buena Vista Alta',
		'PE020503' => 'Comandante Noel',
		'PE020505' => 'Yautan',
		'PE020601' => 'Corongo',
		'PE020602' => 'Aco',
		'PE020603' => 'Bambas',
		'PE020604' => 'Cusca',
		'PE020605' => 'La Pampa',
		'PE020606' => 'Yanac',
		'PE020607' => 'Yupan',
		'PE020801' => 'Huari',
		'PE020816' => 'Anra',
		'PE020802' => 'Cajay',
		'PE020803' => 'Chavin de Huantar',
		'PE020804' => 'Huacachi',
		'PE020806' => 'Huacchis',
		'PE020805' => 'Huachis',
		'PE020807' => 'Huantar',
		'PE020808' => 'Masin',
		'PE020809' => 'Paucas',
		'PE020810' => 'Ponto',
		'PE020811' => 'Rahuapampa',
		'PE020812' => 'Rapayan',
		'PE020813' => 'San Marcos',
		'PE020814' => 'San Pedro de Chana',
		'PE020815' => 'Uco',
		'PE021901' => 'Huarmey',
		'PE021902' => 'Cochapeti',
		'PE021905' => 'Culebras',
		'PE021903' => 'Huayan',
		'PE021904' => 'Malvas',
		'PE020701' => 'Caraz',
		'PE020702' => 'Huallanca',
		'PE020703' => 'Huata',
		'PE020704' => 'Huaylas',
		'PE020705' => 'Mato',
		'PE020706' => 'Pamparomas',
		'PE020707' => 'Pueblo Libre',
		'PE020708' => 'Santa Cruz',
		'PE020710' => 'Santo Toribio',
		'PE020709' => 'Yuracmarca',
		'PE020901' => 'Piscobamba',
		'PE020902' => 'Casca',
		'PE020908' => 'Eleazar Guzman Barron',
		'PE020904' => 'Fidel Olivas Escudero',
		'PE020905' => 'Llama',
		'PE020906' => 'Llumpa',
		'PE020903' => 'Lucma',
		'PE020907' => 'Musga',
		'PE022007' => 'Ocros',
		'PE022001' => 'Acas',
		'PE022002' => 'Cajamarquilla',
		'PE022003' => 'Carhuapampa',
		'PE022004' => 'Cochas',
		'PE022005' => 'Congas',
		'PE022006' => 'Llipa',
		'PE022008' => 'San Cristobal de Rajan',
		'PE022009' => 'San Pedro',
		'PE022010' => 'Santiago de Chilcas',
		'PE021001' => 'Cabana',
		'PE021002' => 'Bolognesi',
		'PE021003' => 'Conchucos',
		'PE021004' => 'Huacaschuque',
		'PE021005' => 'Huandoval',
		'PE021006' => 'Lacabamba',
		'PE021007' => 'Llapo',
		'PE021008' => 'Pallasca',
		'PE021009' => 'Pampas',
		'PE021010' => 'Santa Rosa',
		'PE021011' => 'Tauca',
		'PE021101' => 'Pomabamba',
		'PE021102' => 'Huayllan',
		'PE021103' => 'Parobamba',
		'PE021104' => 'Quinuabamba',
		'PE021201' => 'Recuay',
		'PE021210' => 'Catac',
		'PE021202' => 'Cotaparaco',
		'PE021203' => 'Huayllapampa',
		'PE021209' => 'Llacllin',
		'PE021204' => 'Marca',
		'PE021205' => 'Pampas Chico',
		'PE021206' => 'Pararin',
		'PE021207' => 'Tapacocha',
		'PE021208' => 'Ticapampa',
		'PE021301' => 'Chimbote',
		'PE021302' => 'Caceres del Peru',
		'PE021308' => 'Coishco',
		'PE021303' => 'Macate',
		'PE021304' => 'Moro',
		'PE021305' => 'Nepena',
		'PE021306' => 'Samanco',
		'PE021307' => 'Santa',
		'PE021309' => 'Nuevo Chimbote',
		'PE021401' => 'Sihuas',
		'PE021407' => 'Acobamba',
		'PE021402' => 'Alfonso Ugarte',
		'PE021408' => 'Cashapampa',
		'PE021403' => 'Chingalpo',
		'PE021404' => 'Huayllabamba',
		'PE021405' => 'Quiches',
		'PE021409' => 'Ragash',
		'PE021410' => 'San Juan',
		'PE021406' => 'Sicsibamba',
		'PE021501' => 'Yungay',
		'PE021502' => 'Cascapara',
		'PE021503' => 'Mancos',
		'PE021504' => 'Matacoto',
		'PE021505' => 'Quillo',
		'PE021506' => 'Ranrahirca',
		'PE021507' => 'Shupluy',
		'PE021508' => 'Yanama',
	],
	'APU' => [
		'PE030101' => 'Abancay',
		'PE030104' => 'Chacoche',
		'PE030102' => 'Circa',
		'PE030103' => 'Curahuasi',
		'PE030105' => 'Huanipaca',
		'PE030106' => 'Lambrama',
		'PE030107' => 'Pichirhua',
		'PE030108' => 'San Pedro de Cachora',
		'PE030109' => 'Tamburco',
		'PE030301' => 'Andahuaylas',
		'PE030302' => 'Andarapa',
		'PE030303' => 'Chiara',
		'PE030304' => 'Huancarama',
		'PE030305' => 'Huancaray',
		'PE030317' => 'Huayana',
		'PE030306' => 'Kishuara',
		'PE030307' => 'Pacobamba',
		'PE030313' => 'Pacucha',
		'PE030308' => 'Pampachiri',
		'PE030314' => 'Pomacocha',
		'PE030309' => 'San Antonio de Cachi',
		'PE030310' => 'San Jeronimo',
		'PE030318' => 'San Miguel de Chaccrampa',
		'PE030315' => 'Santa Maria de Chicmo',
		'PE030311' => 'Talavera',
		'PE030316' => 'Tumay Huaraca',
		'PE030312' => 'Turpo',
		'PE030319' => 'Kaquiabamba',
		'PE030320' => 'Jose Maria Arguedas',
		'PE030401' => 'Antabamba',
		'PE030402' => 'El Oro',
		'PE030403' => 'Huaquirca',
		'PE030404' => 'Juan Espinoza Medrano',
		'PE030405' => 'Oropesa',
		'PE030406' => 'Pachaconas',
		'PE030407' => 'Sabaino',
		'PE030201' => 'Chalhuanca',
		'PE030202' => 'Capaya',
		'PE030203' => 'Caraybamba',
		'PE030206' => 'Chapimarca',
		'PE030204' => 'Colcabamba',
		'PE030205' => 'Cotaruse',
		'PE030207' => 'Huayllo',
		'PE030217' => 'Justo Apu Sahuaraura',
		'PE030208' => 'Lucre',
		'PE030209' => 'Pocohuanca',
		'PE030216' => 'San Juan de Chacna',
		'PE030210' => 'Sanayca',
		'PE030211' => 'Soraya',
		'PE030212' => 'Tapairihua',
		'PE030213' => 'Tintay',
		'PE030214' => 'Toraya',
		'PE030215' => 'Yanaca',
		'PE030501' => 'Tambobamba',
		'PE030503' => 'Cotabambas',
		'PE030502' => 'Coyllurqui',
		'PE030504' => 'Haquira',
		'PE030505' => 'Mara',
		'PE030506' => 'Challhuahuacho',
		'PE030701' => 'Chincheros',
		'PE030705' => 'Anco-Huallo',
		'PE030704' => 'Cocharcas',
		'PE030706' => 'Huaccana',
		'PE030703' => 'Ocobamba',
		'PE030702' => 'Ongoy',
		'PE030707' => 'Uranmarca',
		'PE030708' => 'Ranracancha',
		'PE030709' => 'Rocchacc',
		'PE030710' => 'El Porvenir',
		'PE030711' => 'Los Chankas',
		'PE030601' => 'Chuquibambilla',
		'PE030602' => 'Curpahuasi',
		'PE030605' => 'Gamarra',
		'PE030603' => 'Huayllati',
		'PE030604' => 'Mamara',
		'PE030606' => 'Micaela Bastidas',
		'PE030608' => 'Pataypampa',
		'PE030607' => 'Progreso',
		'PE030609' => 'San Antonio',
		'PE030613' => 'Santa Rosa',
		'PE030610' => 'Turpay',
		'PE030611' => 'Vilcabamba',
		'PE030612' => 'Virundo',
		'PE030614' => 'Curasco',
		'PE030712' => 'Ahuayro',
	],
	'ARE' => [
		'PE040101' => 'Arequipa',
		'PE040128' => 'Alto Selva Alegre',
		'PE040102' => 'Cayma',
		'PE040103' => 'Cerro Colorado',
		'PE040104' => 'Characato',
		'PE040105' => 'Chiguata',
		'PE040127' => 'Jacobo Hunter',
		'PE040106' => 'La Joya',
		'PE040126' => 'Mariano Melgar',
		'PE040107' => 'Miraflores',
		'PE040108' => 'Mollebaya',
		'PE040109' => 'Paucarpata',
		'PE040110' => 'Pocsi',
		'PE040111' => 'Polobaya',
		'PE040112' => 'Quequena',
		'PE040113' => 'Sabandia',
		'PE040114' => 'Sachaca',
		'PE040115' => 'San Juan de Siguas',
		'PE040116' => 'San Juan de Tarucani',
		'PE040117' => 'Santa Isabel de Siguas',
		'PE040118' => 'Santa Rita de Siguas',
		'PE040119' => 'Socabaya',
		'PE040120' => 'Tiabaya',
		'PE040121' => 'Uchumayo',
		'PE040122' => 'Vitor',
		'PE040123' => 'Yanahuara',
		'PE040124' => 'Yarabamba',
		'PE040125' => 'Yura',
		'PE040129' => 'Jose Luis Bustamante Y Rivero',
		'PE040301' => 'Camana',
		'PE040302' => 'Jose Maria Quimper',
		'PE040303' => 'Mariano Nicolas Valcarcel',
		'PE040304' => 'Mariscal Caceres',
		'PE040305' => 'Nicolas de Pierola',
		'PE040306' => 'Ocona',
		'PE040307' => 'Quilca',
		'PE040308' => 'Samuel Pastor',
		'PE040401' => 'Caraveli',
		'PE040402' => 'Acari',
		'PE040403' => 'Atico',
		'PE040404' => 'Atiquipa',
		'PE040405' => 'Bella Union',
		'PE040406' => 'Cahuacho',
		'PE040407' => 'Chala',
		'PE040408' => 'Chaparra',
		'PE040409' => 'Huanuhuanu',
		'PE040410' => 'Jaqui',
		'PE040411' => 'Lomas',
		'PE040412' => 'Quicacha',
		'PE040413' => 'Yauca',
		'PE040501' => 'Aplao',
		'PE040502' => 'Andagua',
		'PE040503' => 'Ayo',
		'PE040504' => 'Chachas',
		'PE040505' => 'Chilcaymarca',
		'PE040506' => 'Choco',
		'PE040507' => 'Huancarqui',
		'PE040508' => 'Machaguay',
		'PE040509' => 'Orcopampa',
		'PE040510' => 'Pampacolca',
		'PE040511' => 'Tipan',
		'PE040513' => 'Unon',
		'PE040512' => 'Uraca',
		'PE040514' => 'Viraco',
		'PE040201' => 'Chivay',
		'PE040202' => 'Achoma',
		'PE040203' => 'Cabanaconde',
		'PE040205' => 'Callalli',
		'PE040204' => 'Caylloma',
		'PE040206' => 'Coporaque',
		'PE040207' => 'Huambo',
		'PE040208' => 'Huanca',
		'PE040209' => 'Ichupampa',
		'PE040210' => 'Lari',
		'PE040211' => 'Lluta',
		'PE040212' => 'Maca',
		'PE040213' => 'Madrigal',
		'PE040214' => 'San Antonio de Chuca',
		'PE040215' => 'Sibayo',
		'PE040216' => 'Tapay',
		'PE040217' => 'Tisco',
		'PE040218' => 'Tuti',
		'PE040219' => 'Yanque',
		'PE040220' => 'Majes',
		'PE040601' => 'Chuquibamba',
		'PE040602' => 'Andaray',
		'PE040603' => 'Cayarani',
		'PE040604' => 'Chichas',
		'PE040605' => 'Iray',
		'PE040608' => 'Rio Grande',
		'PE040606' => 'Salamanca',
		'PE040607' => 'Yanaquihua',
		'PE040701' => 'Mollendo',
		'PE040702' => 'Cocachacra',
		'PE040703' => 'Dean Valdivia',
		'PE040704' => 'Islay',
		'PE040705' => 'Mejia',
		'PE040706' => 'Punta de Bombon',
		'PE040801' => 'Cotahuasi',
		'PE040802' => 'Alca',
		'PE040803' => 'Charcana',
		'PE040804' => 'Huaynacotas',
		'PE040805' => 'Pampamarca',
		'PE040806' => 'Puyca',
		'PE040807' => 'Quechualla',
		'PE040808' => 'Sayla',
		'PE040809' => 'Tauria',
		'PE040810' => 'Tomepampa',
		'PE040811' => 'Toro',
	],
	'AYA' => [
		'PE050101' => 'Ayacucho',
		'PE050111' => 'Acocro',
		'PE050102' => 'Acos Vinchos',
		'PE050103' => 'Carmen Alto',
		'PE050104' => 'Chiara',
		'PE050113' => 'Ocros',
		'PE050114' => 'Pacaycasa',
		'PE050105' => 'Quinua',
		'PE050106' => 'San Jose de Ticllas',
		'PE050107' => 'San Juan Bautista',
		'PE050108' => 'Santiago de Pischa',
		'PE050112' => 'Socos',
		'PE050110' => 'Tambillo',
		'PE050109' => 'Vinchos',
		'PE050115' => 'Jesus Nazareno',
		'PE050116' => 'Andres Avelino Caceres Dorregaray',
		'PE050201' => 'Cangallo',
		'PE050204' => 'Chuschi',
		'PE050206' => 'Los Morochucos',
		'PE050211' => 'Maria Parado de Bellido',
		'PE050207' => 'Paras',
		'PE050208' => 'Totos',
		'PE050801' => 'Sancos',
		'PE050804' => 'Carapo',
		'PE050802' => 'Sacsamarca',
		'PE050803' => 'Santiago de Lucanamarca',
		'PE050301' => 'Huanta',
		'PE050302' => 'Ayahuanco',
		'PE050303' => 'Huamanguilla',
		'PE050304' => 'Iguain',
		'PE050305' => 'Luricocha',
		'PE050307' => 'Santillana',
		'PE050308' => 'Sivia',
		'PE050309' => 'Llochegua',
		'PE050310' => 'Canayre',
		'PE050311' => 'Uchuraccay',
		'PE050312' => 'Pucacolpa',
		'PE050313' => 'Chaca',
		'PE050401' => 'San Miguel',
		'PE050402' => 'Anco',
		'PE050403' => 'Ayna',
		'PE050404' => 'Chilcas',
		'PE050405' => 'Chungui',
		'PE050407' => 'Luis Carranza',
		'PE050408' => 'Santa Rosa',
		'PE050406' => 'Tambo',
		'PE050409' => 'Samugari',
		'PE050410' => 'Anchihuay',
		'PE050411' => 'Oronccoy',
		'PE050501' => 'Puquio',
		'PE050502' => 'Aucara',
		'PE050503' => 'Cabana',
		'PE050504' => 'Carmen Salcedo',
		'PE050506' => 'Chavina',
		'PE050508' => 'Chipao',
		'PE050510' => 'Huac-Huas',
		'PE050511' => 'Laramate',
		'PE050512' => 'Leoncio Prado',
		'PE050514' => 'Llauta',
		'PE050513' => 'Lucanas',
		'PE050516' => 'Ocana',
		'PE050517' => 'Otoca',
		'PE050529' => 'Saisa',
		'PE050532' => 'San Cristobal',
		'PE050521' => 'San Juan',
		'PE050522' => 'San Pedro',
		'PE050531' => 'San Pedro de Palco',
		'PE050520' => 'Sancos',
		'PE050524' => 'Santa Ana de Huaycahuacho',
		'PE050525' => 'Santa Lucia',
		'PE050601' => 'Coracora',
		'PE050605' => 'Chumpi',
		'PE050604' => 'Coronel Castaneda',
		'PE050608' => 'Pacapausa',
		'PE050611' => 'Pullo',
		'PE050612' => 'Puyusca',
		'PE050615' => 'San Francisco de Ravacayco',
		'PE050616' => 'Upahuacho',
		'PE051001' => 'Pausa',
		'PE051002' => 'Colta',
		'PE051003' => 'Corculla',
		'PE051004' => 'Lampa',
		'PE051005' => 'Marcabamba',
		'PE051006' => 'Oyolo',
		'PE051007' => 'Pararca',
		'PE051008' => 'San Javier de Alpabamba',
		'PE051009' => 'San Jose de Ushua',
		'PE051010' => 'Sara Sara',
		'PE051101' => 'Querobamba',
		'PE051102' => 'Belen',
		'PE051103' => 'Chalcos',
		'PE051110' => 'Chilcayoc',
		'PE051109' => 'Huacana',
		'PE051111' => 'Morcolla',
		'PE051105' => 'Paico',
		'PE051107' => 'San Pedro de Larcay',
		'PE051104' => 'San Salvador de Quije',
		'PE051106' => 'Santiago de Paucaray',
		'PE051108' => 'Soras',
		'PE050701' => 'Huancapi',
		'PE050702' => 'Alcamenca',
		'PE050703' => 'Apongo',
		'PE050715' => 'Asquipata',
		'PE050704' => 'Canaria',
		'PE050706' => 'Cayara',
		'PE050707' => 'Colca',
		'PE050709' => 'Huamanquiquia',
		'PE050710' => 'Huancaraylla',
		'PE050708' => 'Huaya',
		'PE050713' => 'Sarhua',
		'PE050714' => 'Vilcanchos',
		'PE050901' => 'Vilcas Huaman',
		'PE050903' => 'Accomarca',
		'PE050904' => 'Carhuanca',
		'PE050905' => 'Concepcion',
		'PE050906' => 'Huambalpa',
		'PE050908' => 'Independencia',
		'PE050907' => 'Saurama',
		'PE050902' => 'Vischongo',
		'PE050314' => 'Putis',
		'PE050412' => 'Union Progreso',
		'PE050415' => 'Rio Magdalena',
		'PE050414' => 'Ninabamba',
		'PE050413' => 'Patibamba',
	],
	'CAJ' => [
		'PE060101' => 'Cajamarca',
		'PE060102' => 'Asuncion',
		'PE060104' => 'Chetilla',
		'PE060103' => 'Cospan',
		'PE060105' => 'Encanada',
		'PE060106' => 'Jesus',
		'PE060108' => 'Llacanora',
		'PE060107' => 'Los Banos del Inca',
		'PE060109' => 'Magdalena',
		'PE060110' => 'Matara',
		'PE060111' => 'Namora',
		'PE060112' => 'San Juan',
		'PE060201' => 'Cajabamba',
		'PE060202' => 'Cachachi',
		'PE060203' => 'Condebamba',
		'PE060205' => 'Sitacocha',
		'PE060301' => 'Celendin',
		'PE060303' => 'Chumuch',
		'PE060302' => 'Cortegana',
		'PE060304' => 'Huasmin',
		'PE060305' => 'Jorge Chavez',
		'PE060306' => 'Jose Galvez',
		'PE060307' => 'Miguel Iglesias',
		'PE060308' => 'Oxamarca',
		'PE060309' => 'Sorochuco',
		'PE060310' => 'Sucre',
		'PE060311' => 'Utco',
		'PE060312' => 'La Libertad de Pallan',
		'PE060601' => 'Chota',
		'PE060602' => 'Anguia',
		'PE060605' => 'Chadin',
		'PE060606' => 'Chiguirip',
		'PE060607' => 'Chimban',
		'PE060618' => 'Choropampa',
		'PE060603' => 'Cochabamba',
		'PE060604' => 'Conchan',
		'PE060608' => 'Huambos',
		'PE060609' => 'Lajas',
		'PE060610' => 'Llama',
		'PE060611' => 'Miracosta',
		'PE060612' => 'Paccha',
		'PE060613' => 'Pion',
		'PE060614' => 'Querocoto',
		'PE060617' => 'San Juan de Licupis',
		'PE060615' => 'Tacabamba',
		'PE060616' => 'Tocmoche',
		'PE060619' => 'Chalamarca',
		'PE060401' => 'Contumaza',
		'PE060403' => 'Chilete',
		'PE060406' => 'Cupisnique',
		'PE060404' => 'Guzmango',
		'PE060405' => 'San Benito',
		'PE060409' => 'Santa Cruz de Toledo',
		'PE060407' => 'Tantarica',
		'PE060408' => 'Yonan',
		'PE060501' => 'Cutervo',
		'PE060502' => 'Callayuc',
		'PE060504' => 'Choros',
		'PE060503' => 'Cujillo',
		'PE060505' => 'La Ramada',
		'PE060506' => 'Pimpingos',
		'PE060507' => 'Querocotillo',
		'PE060508' => 'San Andres de Cutervo',
		'PE060509' => 'San Juan de Cutervo',
		'PE060510' => 'San Luis de Lucma',
		'PE060511' => 'Santa Cruz',
		'PE060512' => 'Santo Domingo de la Capilla',
		'PE060513' => 'Santo Tomas',
		'PE060514' => 'Socota',
		'PE060515' => 'Toribio Casanova',
		'PE060701' => 'Bambamarca',
		'PE060702' => 'Chugur',
		'PE060703' => 'Hualgayoc',
		'PE060801' => 'Jaen',
		'PE060802' => 'Bellavista',
		'PE060804' => 'Chontali',
		'PE060803' => 'Colasay',
		'PE060812' => 'Huabal',
		'PE060811' => 'Las Pirias',
		'PE060805' => 'Pomahuaca',
		'PE060806' => 'Pucara',
		'PE060807' => 'Sallique',
		'PE060808' => 'San Felipe',
		'PE060809' => 'San Jose del Alto',
		'PE060810' => 'Santa Rosa',
		'PE061101' => 'San Ignacio',
		'PE061102' => 'Chirinos',
		'PE061103' => 'Huarango',
		'PE061105' => 'La Coipa',
		'PE061104' => 'Namballe',
		'PE061106' => 'San Jose de Lourdes',
		'PE061107' => 'Tabaconas',
		'PE061201' => 'Pedro Galvez',
		'PE061207' => 'Chancay',
		'PE061205' => 'Eduardo Villanueva',
		'PE061203' => 'Gregorio Pita',
		'PE061202' => 'Ichocan',
		'PE061204' => 'Jose Manuel Quiroz',
		'PE061206' => 'Jose Sabogal',
		'PE061001' => 'San Miguel',
		'PE061013' => 'Bolivar',
		'PE061002' => 'Calquis',
		'PE061012' => 'Catilluc',
		'PE061009' => 'El Prado',
		'PE061003' => 'La Florida',
		'PE061004' => 'Llapa',
		'PE061005' => 'Nanchoc',
		'PE061006' => 'Niepos',
		'PE061007' => 'San Gregorio',
		'PE061008' => 'San Silvestre de Cochan',
		'PE061011' => 'Tongod',
		'PE061010' => 'Union Agua Blanca',
		'PE061301' => 'San Pablo',
		'PE061302' => 'San Bernardino',
		'PE061303' => 'San Luis',
		'PE061304' => 'Tumbaden',
		'PE060901' => 'Santa Cruz',
		'PE060910' => 'Andabamba',
		'PE060902' => 'Catache',
		'PE060903' => 'Chancaybanos',
		'PE060904' => 'La Esperanza',
		'PE060905' => 'Ninabamba',
		'PE060906' => 'Pulan',
		'PE060911' => 'Saucepampa',
		'PE060907' => 'Sexi',
		'PE060908' => 'Uticyacu',
		'PE060909' => 'Yauyucan',
	],
	'CAL' => [
		'PE240101' => 'Callao',
		'PE240102' => 'Bellavista',
		'PE240104' => 'Carmen de la Legua Reynoso',
		'PE240105' => 'La Perla',
		'PE240103' => 'La Punta',
		'PE240106' => 'Ventanilla',
		'PE240107' => 'Mi Peru',
	],
	'CUS' => [
		'PE070101' => 'Cusco',
		'PE070102' => 'Ccorca',
		'PE070103' => 'Poroy',
		'PE070104' => 'San Jeronimo',
		'PE070105' => 'San Sebastian',
		'PE070106' => 'Santiago',
		'PE070107' => 'Saylla',
		'PE070108' => 'Wanchaq',
		'PE070201' => 'Acomayo',
		'PE070202' => 'Acopia',
		'PE070203' => 'Acos',
		'PE070207' => 'Mosoc Llacta',
		'PE070204' => 'Pomacanchi',
		'PE070205' => 'Rondocan',
		'PE070206' => 'Sangarara',
		'PE070301' => 'Anta',
		'PE070309' => 'Ancahuasi',
		'PE070308' => 'Cachimayo',
		'PE070302' => 'Chinchaypujio',
		'PE070303' => 'Huarocondo',
		'PE070304' => 'Limatambo',
		'PE070305' => 'Mollepata',
		'PE070306' => 'Pucyura',
		'PE070307' => 'Zurite',
		'PE070401' => 'Calca',
		'PE070402' => 'Coya',
		'PE070403' => 'Lamay',
		'PE070404' => 'Lares',
		'PE070405' => 'Pisac',
		'PE070406' => 'San Salvador',
		'PE070407' => 'Taray',
		'PE070408' => 'Yanatile',
		'PE070501' => 'Yanaoca',
		'PE070502' => 'Checca',
		'PE070503' => 'Kunturkanki',
		'PE070504' => 'Langui',
		'PE070505' => 'Layo',
		'PE070506' => 'Pampamarca',
		'PE070507' => 'Quehue',
		'PE070508' => 'Tupac Amaru',
		'PE070601' => 'Sicuani',
		'PE070603' => 'Checacupe',
		'PE070602' => 'Combapata',
		'PE070604' => 'Marangani',
		'PE070605' => 'Pitumarca',
		'PE070606' => 'San Pablo',
		'PE070607' => 'San Pedro',
		'PE070608' => 'Tinta',
		'PE070701' => 'Santo Tomas',
		'PE070702' => 'Capacmarca',
		'PE070704' => 'Chamaca',
		'PE070703' => 'Colquemarca',
		'PE070705' => 'Livitaca',
		'PE070706' => 'Llusco',
		'PE070707' => 'Quinota',
		'PE070708' => 'Velille',
		'PE070801' => 'Espinar',
		'PE070802' => 'Condoroma',
		'PE070803' => 'Coporaque',
		'PE070804' => 'Ocoruro',
		'PE070805' => 'Pallpata',
		'PE070806' => 'Pichigua',
		'PE070807' => 'Suyckutambo',
		'PE070808' => 'Alto Pichigua',
		'PE070901' => 'Santa Ana',
		'PE070902' => 'Echarate',
		'PE070903' => 'Huayopata',
		'PE070904' => 'Maranura',
		'PE070905' => 'Ocobamba',
		'PE070908' => 'Quellouno',
		'PE070909' => 'Quimbiri',
		'PE070906' => 'Santa Teresa',
		'PE070907' => 'Vilcabamba',
		'PE070910' => 'Pichari',
		'PE070911' => 'Inkawasi',
		'PE070912' => 'Villa Virgen',
		'PE070913' => 'Villa Kintiarina',
		'PE070915' => 'Megantoni',
		'PE071001' => 'Paruro',
		'PE071002' => 'Accha',
		'PE071003' => 'Ccapi',
		'PE071004' => 'Colcha',
		'PE071005' => 'Huanoquite',
		'PE071006' => 'Omacha',
		'PE071008' => 'Paccaritambo',
		'PE071009' => 'Pillpinto',
		'PE071007' => 'Yaurisque',
		'PE071101' => 'Paucartambo',
		'PE071102' => 'Caicay',
		'PE071104' => 'Challabamba',
		'PE071103' => 'Colquepata',
		'PE071106' => 'Huancarani',
		'PE071105' => 'Kosnipata',
		'PE071201' => 'Urcos',
		'PE071202' => 'Andahuaylillas',
		'PE071203' => 'Camanti',
		'PE071204' => 'Ccarhuayo',
		'PE071205' => 'Ccatca',
		'PE071206' => 'Cusipata',
		'PE071207' => 'Huaro',
		'PE071208' => 'Lucre',
		'PE071209' => 'Marcapata',
		'PE071210' => 'Ocongate',
		'PE071211' => 'Oropesa',
		'PE071212' => 'Quiquijana',
		'PE071301' => 'Urubamba',
		'PE071302' => 'Chinchero',
		'PE071303' => 'Huayllabamba',
		'PE071304' => 'Machupicchu',
		'PE071305' => 'Maras',
		'PE071306' => 'Ollantaytambo',
		'PE071307' => 'Yucay',
		'PE070916' => 'Kumpirushiato',
		'PE070917' => 'Cielo Punco',
		'PE070918' => 'Manitea',
		'PE070919' => 'Union Ashaninka',
	],
	'HUV' => [
		'PE080101' => 'Huancavelica',
		'PE080102' => 'Acobambilla',
		'PE080103' => 'Acoria',
		'PE080104' => 'Conayca',
		'PE080105' => 'Cuenca',
		'PE080106' => 'Huachocolpa',
		'PE080108' => 'Huayllahuara',
		'PE080109' => 'Izcuchaca',
		'PE080110' => 'Laria',
		'PE080111' => 'Manta',
		'PE080112' => 'Mariscal Caceres',
		'PE080113' => 'Moya',
		'PE080114' => 'Nuevo Occoro',
		'PE080115' => 'Palca',
		'PE080116' => 'Pilchaca',
		'PE080117' => 'Vilca',
		'PE080118' => 'Yauli',
		'PE080119' => 'Ascension',
		'PE080120' => 'Huando',
		'PE080201' => 'Acobamba',
		'PE080203' => 'Andabamba',
		'PE080202' => 'Anta',
		'PE080204' => 'Caja',
		'PE080205' => 'Marcas',
		'PE080206' => 'Paucara',
		'PE080207' => 'Pomacocha',
		'PE080208' => 'Rosario',
		'PE080301' => 'Lircay',
		'PE080302' => 'Anchonga',
		'PE080303' => 'Callanmarca',
		'PE080312' => 'Ccochaccasa',
		'PE080305' => 'Chincho',
		'PE080304' => 'Congalla',
		'PE080307' => 'Huanca-Huanca',
		'PE080306' => 'Huayllay Grande',
		'PE080308' => 'Julcamarca',
		'PE080309' => 'San Antonio de Antaparco',
		'PE080310' => 'Santo Tomas de Pata',
		'PE080311' => 'Secclla',
		'PE080401' => 'Castrovirreyna',
		'PE080402' => 'Arma',
		'PE080403' => 'Aurahua',
		'PE080405' => 'Capillas',
		'PE080408' => 'Chupamarca',
		'PE080406' => 'Cocas',
		'PE080409' => 'Huachos',
		'PE080410' => 'Huamatambo',
		'PE080414' => 'Mollepampa',
		'PE080422' => 'San Juan',
		'PE080429' => 'Santa Ana',
		'PE080427' => 'Tantara',
		'PE080428' => 'Ticrapo',
		'PE080701' => 'Churcampa',
		'PE080702' => 'Anco',
		'PE080703' => 'Chinchihuasi',
		'PE080704' => 'El Carmen',
		'PE080705' => 'La Merced',
		'PE080706' => 'Locroja',
		'PE080707' => 'Paucarbamba',
		'PE080708' => 'San Miguel de Mayocc',
		'PE080709' => 'San Pedro de Coris',
		'PE080710' => 'Pachamarca',
		'PE080711' => 'Cosme',
		'PE080604' => 'Huaytara',
		'PE080601' => 'Ayavi',
		'PE080602' => 'Cordova',
		'PE080603' => 'Huayacundo Arma',
		'PE080605' => 'Laramarca',
		'PE080606' => 'Ocoyo',
		'PE080607' => 'Pilpichaca',
		'PE080608' => 'Querco',
		'PE080609' => 'Quito-Arma',
		'PE080610' => 'San Antonio de Cusicancha',
		'PE080611' => 'San Francisco de Sangayaico',
		'PE080612' => 'San Isidro',
		'PE080613' => 'Santiago de Chocorvos',
		'PE080614' => 'Santiago de Quirahuara',
		'PE080615' => 'Santo Domingo de Capillas',
		'PE080616' => 'Tambo',
		'PE080501' => 'Pampas',
		'PE080502' => 'Acostambo',
		'PE080503' => 'Acraquia',
		'PE080504' => 'Ahuaycha',
		'PE080506' => 'Colcabamba',
		'PE080509' => 'Daniel Hernandez',
		'PE080511' => 'Huachocolpa',
		'PE080512' => 'Huaribamba',
		'PE080515' => 'Nahuimpuquio',
		'PE080517' => 'Pazos',
		'PE080518' => 'Quishuar',
		'PE080519' => 'Salcabamba',
		'PE080526' => 'Salcahuasi',
		'PE080520' => 'San Marcos de Rocchac',
		'PE080523' => 'Surcubamba',
		'PE080525' => 'Tintay Puncu',
		'PE080528' => 'Quichuas',
		'PE080529' => 'Andaymarca',
		'PE080530' => 'Roble',
		'PE080531' => 'Pichos',
		'PE080532' => 'Santiago de Tucuma',
		'PE080533' => 'Lambras',
		'PE080534' => 'Cochabamba',
	],
	'HUC' => [
		'PE090101' => 'Huanuco',
		'PE090110' => 'Amarilis',
		'PE090102' => 'Chinchao',
		'PE090103' => 'Churubamba',
		'PE090104' => 'Margos',
		'PE090105' => 'Quisqui',
		'PE090106' => 'San Francisco de Cayran',
		'PE090107' => 'San Pedro de Chaulan',
		'PE090108' => 'Santa Maria del Valle',
		'PE090109' => 'Yarumayo',
		'PE090111' => 'Pillco Marca',
		'PE090112' => 'Yacus',
		'PE090113' => 'San Pablo de Pillao',
		'PE090201' => 'Ambo',
		'PE090202' => 'Cayna',
		'PE090203' => 'Colpas',
		'PE090204' => 'Conchamarca',
		'PE090205' => 'Huacar',
		'PE090206' => 'San Francisco',
		'PE090207' => 'San Rafael',
		'PE090208' => 'Tomay Kichwa',
		'PE090301' => 'La Union',
		'PE090307' => 'Chuquis',
		'PE090312' => 'Marias',
		'PE090314' => 'Pachas',
		'PE090316' => 'Quivilla',
		'PE090317' => 'Ripan',
		'PE090321' => 'Shunqui',
		'PE090322' => 'Sillapata',
		'PE090323' => 'Yanas',
		'PE090901' => 'Huacaybamba',
		'PE090903' => 'Canchabamba',
		'PE090904' => 'Cochabamba',
		'PE090902' => 'Pinra',
		'PE090401' => 'Llata',
		'PE090402' => 'Arancay',
		'PE090403' => 'Chavin de Pariarca',
		'PE090404' => 'Jacas Grande',
		'PE090405' => 'Jircan',
		'PE090406' => 'Miraflores',
		'PE090407' => 'Monzon',
		'PE090408' => 'Punchao',
		'PE090409' => 'Punos',
		'PE090410' => 'Singa',
		'PE090411' => 'Tantamayo',
		'PE090601' => 'Rupa-Rupa',
		'PE090602' => 'Daniel Alomias Robles',
		'PE090603' => 'Hermilio Valdizan',
		'PE090606' => 'Jose Crespo Y Castillo',
		'PE090604' => 'Luyando',
		'PE090605' => 'Mariano Damaso Beraun',
		'PE090607' => 'Pucayacu',
		'PE090608' => 'Castillo Grande',
		'PE090609' => 'Pueblo Nuevo',
		'PE090610' => 'Santo Domingo de Anda',
		'PE090501' => 'Huacrachuco',
		'PE090502' => 'Cholon',
		'PE090505' => 'San Buenaventura',
		'PE090506' => 'La Morada',
		'PE090507' => 'Santa Rosa de Alto Yanajanca',
		'PE090701' => 'Panao',
		'PE090702' => 'Chaglla',
		'PE090704' => 'Molino',
		'PE090706' => 'Umari',
		'PE090802' => 'Puerto Inca',
		'PE090803' => 'Codo del Pozuzo',
		'PE090801' => 'Honoria',
		'PE090804' => 'Tournavista',
		'PE090805' => 'Yuyapichis',
		'PE091001' => 'Jesus',
		'PE091002' => 'Banos',
		'PE091007' => 'Jivia',
		'PE091004' => 'Queropalca',
		'PE091006' => 'Rondos',
		'PE091003' => 'San Francisco de Asis',
		'PE091005' => 'San Miguel de Cauri',
		'PE091101' => 'Chavinillo',
		'PE091103' => 'Cahuac',
		'PE091104' => 'Chacabamba',
		'PE091102' => 'Aparicio Pomares',
		'PE091105' => 'Jacas Chico',
		'PE091106' => 'Obas',
		'PE091107' => 'Pampamarca',
		'PE091108' => 'Choras',
	],
	'ICA' => [
		'PE100101' => 'Ica',
		'PE100102' => 'La Tinguina',
		'PE100103' => 'Los Aquijes',
		'PE100114' => 'Ocucaje',
		'PE100113' => 'Pachacutec',
		'PE100104' => 'Parcona',
		'PE100105' => 'Pueblo Nuevo',
		'PE100106' => 'Salas',
		'PE100107' => 'San Jose de Los Molinos',
		'PE100108' => 'San Juan Bautista',
		'PE100109' => 'Santiago',
		'PE100110' => 'Subtanjalla',
		'PE100112' => 'Tate',
		'PE100111' => 'Yauca del Rosario',
		'PE100201' => 'Chincha Alta',
		'PE100209' => 'Alto Laran',
		'PE100202' => 'Chavin',
		'PE100203' => 'Chincha Baja',
		'PE100204' => 'El Carmen',
		'PE100205' => 'Grocio Prado',
		'PE100210' => 'Pueblo Nuevo',
		'PE100211' => 'San Juan de Yanac',
		'PE100206' => 'San Pedro de Huacarpana',
		'PE100207' => 'Sunampe',
		'PE100208' => 'Tambo de Mora',
		'PE100301' => 'Nazca',
		'PE100302' => 'Changuillo',
		'PE100303' => 'El Ingenio',
		'PE100304' => 'Marcona',
		'PE100305' => 'Vista Alegre',
		'PE100501' => 'Palpa',
		'PE100502' => 'Llipata',
		'PE100503' => 'Rio Grande',
		'PE100504' => 'Santa Cruz',
		'PE100505' => 'Tibillo',
		'PE100401' => 'Pisco',
		'PE100402' => 'Huancano',
		'PE100403' => 'Humay',
		'PE100404' => 'Independencia',
		'PE100405' => 'Paracas',
		'PE100406' => 'San Andres',
		'PE100407' => 'San Clemente',
		'PE100408' => 'Tupac Amaru Inca',
	],
	'JUN' => [
		'PE110101' => 'Huancayo',
		'PE110103' => 'Carhuacallanga',
		'PE110106' => 'Chacapampa',
		'PE110107' => 'Chicche',
		'PE110108' => 'Chilca',
		'PE110109' => 'Chongos Alto',
		'PE110112' => 'Chupuro',
		'PE110104' => 'Colca',
		'PE110105' => 'Cullhuas',
		'PE110113' => 'El Tambo',
		'PE110114' => 'Huacrapuquio',
		'PE110116' => 'Hualhuas',
		'PE110118' => 'Huancan',
		'PE110119' => 'Huasicancha',
		'PE110120' => 'Huayucachi',
		'PE110121' => 'Ingenio',
		'PE110122' => 'Pariahuanca',
		'PE110123' => 'Pilcomayo',
		'PE110124' => 'Pucara',
		'PE110125' => 'Quichuay',
		'PE110126' => 'Quilcas',
		'PE110127' => 'San Agustin',
		'PE110128' => 'San Jeronimo de Tunan',
		'PE110132' => 'Sano',
		'PE110133' => 'Sapallanga',
		'PE110134' => 'Sicaya',
		'PE110131' => 'Santo Domingo de Acobamba',
		'PE110136' => 'Viques',
		'PE110201' => 'Concepcion',
		'PE110202' => 'Aco',
		'PE110203' => 'Andamarca',
		'PE110206' => 'Chambara',
		'PE110205' => 'Cochas',
		'PE110204' => 'Comas',
		'PE110207' => 'Heroinas Toledo',
		'PE110208' => 'Manzanares',
		'PE110209' => 'Mariscal Castilla',
		'PE110210' => 'Matahuasi',
		'PE110211' => 'Mito',
		'PE110212' => 'Nueve de Julio',
		'PE110213' => 'Orcotuna',
		'PE110215' => 'San Jose de Quero',
		'PE110214' => 'Santa Rosa de Ocopa',
		'PE110801' => 'Chanchamayo',
		'PE110806' => 'Perene',
		'PE110805' => 'Pichanaqui',
		'PE110804' => 'San Luis de Shuaro',
		'PE110802' => 'San Ramon',
		'PE110803' => 'Vitoc',
		'PE110301' => 'Jauja',
		'PE110302' => 'Acolla',
		'PE110303' => 'Apata',
		'PE110304' => 'Ataura',
		'PE110305' => 'Canchayllo',
		'PE110331' => 'Curicaca',
		'PE110306' => 'El Mantaro',
		'PE110307' => 'Huamali',
		'PE110308' => 'Huaripampa',
		'PE110309' => 'Huertas',
		'PE110310' => 'Janjaillo',
		'PE110311' => 'Julcan',
		'PE110312' => 'Leonor Ordonez',
		'PE110313' => 'Llocllapampa',
		'PE110314' => 'Marco',
		'PE110315' => 'Masma',
		'PE110332' => 'Masma Chicche',
		'PE110316' => 'Molinos',
		'PE110317' => 'Monobamba',
		'PE110318' => 'Muqui',
		'PE110319' => 'Muquiyauyo',
		'PE110320' => 'Paca',
		'PE110321' => 'Paccha',
		'PE110322' => 'Pancan',
		'PE110323' => 'Parco',
		'PE110324' => 'Pomacancha',
		'PE110325' => 'Ricran',
		'PE110326' => 'San Lorenzo',
		'PE110327' => 'San Pedro de Chunan',
		'PE110333' => 'Sausa',
		'PE110328' => 'Sincos',
		'PE110329' => 'Tunan Marca',
		'PE110330' => 'Yauli',
		'PE110334' => 'Yauyos',
		'PE110401' => 'Junin',
		'PE110402' => 'Carhuamayo',
		'PE110403' => 'Ondores',
		'PE110404' => 'Ulcumayo',
		'PE110701' => 'Satipo',
		'PE110702' => 'Coviriali',
		'PE110703' => 'Llaylla',
		'PE110704' => 'Mazamari',
		'PE110705' => 'Pampa Hermosa',
		'PE110706' => 'Pangoa',
		'PE110707' => 'Rio Negro',
		'PE110708' => 'Rio Tambo',
		'PE110709' => 'Vizcatan del Ene',
		'PE110501' => 'Tarma',
		'PE110502' => 'Acobamba',
		'PE110503' => 'Huaricolca',
		'PE110504' => 'Huasahuasi',
		'PE110505' => 'La Union',
		'PE110506' => 'Palca',
		'PE110507' => 'Palcamayo',
		'PE110508' => 'San Pedro de Cajas',
		'PE110509' => 'Tapo',
		'PE110601' => 'La Oroya',
		'PE110602' => 'Chacapalpa',
		'PE110603' => 'Huay-Huay',
		'PE110604' => 'Marcapomacocha',
		'PE110605' => 'Morococha',
		'PE110606' => 'Paccha',
		'PE110607' => 'Santa Barbara de Carhuacayan',
		'PE110610' => 'Santa Rosa de Sacco',
		'PE110608' => 'Suitucancha',
		'PE110609' => 'Yauli',
		'PE110901' => 'Chupaca',
		'PE110902' => 'Ahuac',
		'PE110903' => 'Chongos Bajo',
		'PE110904' => 'Huachac',
		'PE110905' => 'Huamancaca Chico',
		'PE110906' => 'San Juan de Yscos',
		'PE110907' => 'San Juan de Jarpa',
		'PE110908' => 'Tres de Diciembre',
		'PE110909' => 'Yanacancha',
	],
	'LAL' => [
		'PE120101' => 'Trujillo',
		'PE120110' => 'El Porvenir',
		'PE120112' => 'Florencia de Mora',
		'PE120102' => 'Huanchaco',
		'PE120111' => 'La Esperanza',
		'PE120103' => 'Laredo',
		'PE120104' => 'Moche',
		'PE120109' => 'Poroto',
		'PE120105' => 'Salaverry',
		'PE120106' => 'Simbal',
		'PE120107' => 'Victor Larco Herrera',
		'PE120801' => 'Ascope',
		'PE120802' => 'Chicama',
		'PE120803' => 'Chocope',
		'PE120805' => 'Magdalena de Cao',
		'PE120806' => 'Paijan',
		'PE120807' => 'Razuri',
		'PE120804' => 'Santiago de Cao',
		'PE120808' => 'Casa Grande',
		'PE120201' => 'Bolivar',
		'PE120202' => 'Bambamarca',
		'PE120203' => 'Condormarca',
		'PE120204' => 'Longotea',
		'PE120206' => 'Uchumarca',
		'PE120205' => 'Ucuncha',
		'PE120901' => 'Chepen',
		'PE120902' => 'Pacanga',
		'PE120903' => 'Pueblo Nuevo',
		'PE121001' => 'Julcan',
		'PE121003' => 'Calamarca',
		'PE121002' => 'Carabamba',
		'PE121004' => 'Huaso',
		'PE120401' => 'Otuzco',
		'PE120402' => 'Agallpampa',
		'PE120403' => 'Charat',
		'PE120404' => 'Huaranchal',
		'PE120405' => 'La Cuesta',
		'PE120413' => 'Mache',
		'PE120408' => 'Paranday',
		'PE120409' => 'Salpo',
		'PE120410' => 'Sinsicap',
		'PE120411' => 'Usquil',
		'PE120501' => 'San Pedro de Lloc',
		'PE120503' => 'Guadalupe',
		'PE120504' => 'Jequetepeque',
		'PE120506' => 'Pacasmayo',
		'PE120508' => 'San Jose',
		'PE120601' => 'Tayabamba',
		'PE120602' => 'Buldibuyo',
		'PE120603' => 'Chillia',
		'PE120605' => 'Huancaspata',
		'PE120604' => 'Huaylillas',
		'PE120606' => 'Huayo',
		'PE120607' => 'Ongon',
		'PE120608' => 'Parcoy',
		'PE120609' => 'Pataz',
		'PE120610' => 'Pias',
		'PE120613' => 'Santiago de Challas',
		'PE120611' => 'Taurija',
		'PE120612' => 'Urpay',
		'PE120301' => 'Huamachuco',
		'PE120304' => 'Chugay',
		'PE120302' => 'Cochorco',
		'PE120303' => 'Curgos',
		'PE120305' => 'Marcabal',
		'PE120306' => 'Sanagoran',
		'PE120307' => 'Sarin',
		'PE120308' => 'Sartimbamba',
		'PE120701' => 'Santiago de Chuco',
		'PE120708' => 'Angasmarca',
		'PE120702' => 'Cachicadan',
		'PE120703' => 'Mollebamba',
		'PE120704' => 'Mollepata',
		'PE120705' => 'Quiruvilca',
		'PE120706' => 'Santa Cruz de Chuca',
		'PE120707' => 'Sitabamba',
		'PE121101' => 'Cascas',
		'PE121102' => 'Lucma',
		'PE121103' => 'Marmot',
		'PE121104' => 'Sayapullo',
		'PE121201' => 'Viru',
		'PE121202' => 'Chao',
		'PE121203' => 'Guadalupito',
	],
	'LAM' => [
		'PE130101' => 'Chiclayo',
		'PE130102' => 'Chongoyape',
		'PE130103' => 'Eten',
		'PE130104' => 'Eten Puerto',
		'PE130112' => 'Jose Leonardo Ortiz',
		'PE130115' => 'La Victoria',
		'PE130105' => 'Lagunas',
		'PE130106' => 'Monsefu',
		'PE130107' => 'Nueva Arica',
		'PE130108' => 'Oyotun',
		'PE130109' => 'Picsi',
		'PE130110' => 'Pimentel',
		'PE130111' => 'Reque',
		'PE130113' => 'Santa Rosa',
		'PE130114' => 'Sana',
		'PE130116' => 'Cayalti',
		'PE130117' => 'Patapo',
		'PE130118' => 'Pomalca',
		'PE130119' => 'Pucala',
		'PE130120' => 'Tuman',
		'PE130201' => 'Ferrenafe',
		'PE130203' => 'Canaris',
		'PE130202' => 'Incahuasi',
		'PE130206' => 'Manuel Antonio Mesones Muro',
		'PE130204' => 'Pitipo',
		'PE130205' => 'Pueblo Nuevo',
		'PE130301' => 'Lambayeque',
		'PE130302' => 'Chochope',
		'PE130303' => 'Illimo',
		'PE130304' => 'Jayanca',
		'PE130305' => 'Mochumi',
		'PE130306' => 'Morrope',
		'PE130307' => 'Motupe',
		'PE130308' => 'Olmos',
		'PE130309' => 'Pacora',
		'PE130310' => 'Salas',
		'PE130311' => 'San Jose',
		'PE130312' => 'Tucume',
	],
	'LMA' => [
		'PE140101' => 'Lima Cercado',
		'PE140102' => 'Ancon',
		'PE140103' => 'Ate',
		'PE140125' => 'Barranco',
		'PE140104' => 'Brena',
		'PE140105' => 'Carabayllo',
		'PE140107' => 'Chaclacayo',
		'PE140108' => 'Chorrillos',
		'PE140139' => 'Cieneguilla',
		'PE140106' => 'Comas',
		'PE140135' => 'El Agustino',
		'PE140134' => 'Independencia',
		'PE140133' => 'Jesus Maria',
		'PE140110' => 'La Molina',
		'PE140109' => 'La Victoria',
		'PE140111' => 'Lince',
		'PE140142' => 'Los Olivos',
		'PE140112' => 'Lurigancho',
		'PE140113' => 'Lurin',
		'PE140114' => 'Magdalena del Mar',
		'PE140117' => 'Pueblo Libre',
		'PE140115' => 'Miraflores',
		'PE140116' => 'Pachacamac',
		'PE140118' => 'Pucusana',
		'PE140119' => 'Puente Piedra',
		'PE140120' => 'Punta Hermosa',
		'PE140121' => 'Punta Negra',
		'PE140122' => 'Rimac',
		'PE140123' => 'San Bartolo',
		'PE140140' => 'San Borja',
		'PE140124' => 'San Isidro',
		'PE140137' => 'San Juan de Lurigancho',
		'PE140136' => 'San Juan de Miraflores',
		'PE140138' => 'San Luis',
		'PE140126' => 'San Martin de Porres',
		'PE140127' => 'San Miguel',
		'PE140143' => 'Santa Anita',
		'PE140128' => 'Santa Maria del Mar',
		'PE140129' => 'Santa Rosa',
		'PE140130' => 'Santiago de Surco',
		'PE140131' => 'Surquillo',
		'PE140141' => 'Villa El Salvador',
		'PE140132' => 'Villa Maria del Triunfo',
	],
	'LIM' => [
		'PE140901' => 'Barranca',
		'PE140902' => 'Paramonga',
		'PE140903' => 'Pativilca',
		'PE140904' => 'Supe',
		'PE140905' => 'Supe Puerto',
		'PE140201' => 'Cajatambo',
		'PE140205' => 'Copa',
		'PE140206' => 'Gorgor',
		'PE140207' => 'Huancapon',
		'PE140208' => 'Manas',
		'PE140301' => 'Canta',
		'PE140302' => 'Arahuay',
		'PE140303' => 'Huamantanga',
		'PE140304' => 'Huaros',
		'PE140305' => 'Lachaqui',
		'PE140306' => 'San Buenaventura',
		'PE140307' => 'Santa Rosa de Quives',
		'PE140401' => 'San Vicente de Canete',
		'PE140416' => 'Asia',
		'PE140402' => 'Calango',
		'PE140403' => 'Cerro Azul',
		'PE140405' => 'Chilca',
		'PE140404' => 'Coayllo',
		'PE140406' => 'Imperial',
		'PE140407' => 'Lunahuana',
		'PE140408' => 'Mala',
		'PE140409' => 'Nuevo Imperial',
		'PE140410' => 'Pacaran',
		'PE140411' => 'Quilmana',
		'PE140412' => 'San Antonio',
		'PE140413' => 'San Luis',
		'PE140414' => 'Santa Cruz de Flores',
		'PE140415' => 'Zuniga',
		'PE140801' => 'Huaral',
		'PE140802' => 'Atavillos Alto',
		'PE140803' => 'Atavillos Bajo',
		'PE140804' => 'Aucallama',
		'PE140805' => 'Chancay',
		'PE140806' => 'Ihuari',
		'PE140807' => 'Lampian',
		'PE140808' => 'Pacaraos',
		'PE140809' => 'San Miguel de Acos',
		'PE140811' => 'Santa Cruz de Andamarca',
		'PE140812' => 'Sumbilca',
		'PE140810' => 'Veintisiete de Noviembre',
		'PE140601' => 'Matucana',
		'PE140602' => 'Antioquia',
		'PE140603' => 'Callahuanca',
		'PE140604' => 'Carampoma',
		'PE140607' => 'Chicla',
		'PE140606' => 'Cuenca',
		'PE140630' => 'Huachupampa',
		'PE140608' => 'Huanza',
		'PE140609' => 'Huarochiri',
		'PE140610' => 'Lahuaytambo',
		'PE140611' => 'Langa',
		'PE140631' => 'Laraos',
		'PE140612' => 'Mariatana',
		'PE140613' => 'Ricardo Palma',
		'PE140614' => 'San Andres de Tupicocha',
		'PE140615' => 'San Antonio',
		'PE140616' => 'San Bartolome',
		'PE140617' => 'San Damian',
		'PE140632' => 'San Juan de Iris',
		'PE140619' => 'San Juan de Tantaranche',
		'PE140620' => 'San Lorenzo de Quinti',
		'PE140621' => 'San Mateo',
		'PE140622' => 'San Mateo de Otao',
		'PE140605' => 'San Pedro de Casta',
		'PE140623' => 'San Pedro de Huancayre',
		'PE140618' => 'Sangallaya',
		'PE140624' => 'Santa Cruz de Cocachacra',
		'PE140625' => 'Santa Eulalia',
		'PE140626' => 'Santiago de Anchucaya',
		'PE140627' => 'Santiago de Tuna',
		'PE140628' => 'Santo Domingo de Los Olleros',
		'PE140629' => 'Surco',
		'PE140501' => 'Huacho',
		'PE140502' => 'Ambar',
		'PE140504' => 'Caleta de Carquin',
		'PE140505' => 'Checras',
		'PE140506' => 'Hualmay',
		'PE140507' => 'Huaura',
		'PE140508' => 'Leoncio Prado',
		'PE140509' => 'Paccho',
		'PE140511' => 'Santa Leonor',
		'PE140512' => 'Santa Maria',
		'PE140513' => 'Sayan',
		'PE140516' => 'Vegueta',
		'PE141001' => 'Oyon',
		'PE141004' => 'Andajes',
		'PE141003' => 'Caujul',
		'PE141006' => 'Cochamarca',
		'PE141002' => 'Navan',
		'PE141005' => 'Pachangara',
		'PE140701' => 'Yauyos',
		'PE140702' => 'Alis',
		'PE140703' => 'Ayauca',
		'PE140704' => 'Ayaviri',
		'PE140705' => 'Azangaro',
		'PE140706' => 'Cacra',
		'PE140707' => 'Carania',
		'PE140733' => 'Catahuasi',
		'PE140710' => 'Chocos',
		'PE140708' => 'Cochas',
		'PE140709' => 'Colonia',
		'PE140730' => 'Hongos',
		'PE140711' => 'Huampara',
		'PE140712' => 'Huancaya',
		'PE140713' => 'Huangascar',
		'PE140714' => 'Huantan',
		'PE140715' => 'Huanec',
		'PE140716' => 'Laraos',
		'PE140717' => 'Lincha',
		'PE140731' => 'Madean',
		'PE140718' => 'Miraflores',
		'PE140719' => 'Omas',
		'PE140732' => 'Putinza',
		'PE140720' => 'Quinches',
		'PE140721' => 'Quinocay',
		'PE140722' => 'San Joaquin',
		'PE140723' => 'San Pedro de Pilas',
		'PE140724' => 'Tanta',
		'PE140725' => 'Tauripampa',
		'PE140727' => 'Tomas',
		'PE140726' => 'Tupe',
		'PE140728' => 'Vinac',
		'PE140729' => 'Vitis',
	],
	'LOR' => [
		'PE150101' => 'Iquitos',
		'PE150102' => 'Alto Nanay',
		'PE150103' => 'Fernando Lores',
		'PE150110' => 'Indiana',
		'PE150104' => 'Las Amazonas',
		'PE150105' => 'Mazan',
		'PE150106' => 'Napo',
		'PE150111' => 'Punchana',
		'PE150108' => 'Torres Causana',
		'PE150112' => 'Belen',
		'PE150113' => 'San Juan Bautista',
		'PE150201' => 'Yurimaguas',
		'PE150202' => 'Balsapuerto',
		'PE150205' => 'Jeberos',
		'PE150206' => 'Lagunas',
		'PE150107' => 'Putumayo',
		'PE150114' => 'Teniente Manuel Clavero',
		'PE150210' => 'Santa Cruz',
		'PE150211' => 'Teniente Cesar Lopez Rojas',
		'PE150301' => 'Nauta',
		'PE150302' => 'Parinari',
		'PE150303' => 'Tigre',
		'PE150305' => 'Trompeteros',
		'PE150304' => 'Urarinas',
		'PE150601' => 'Ramon Castilla',
		'PE150602' => 'Pebas',
		'PE150603' => 'Yavari',
		'PE150604' => 'San Pablo',
		'PE150401' => 'Requena',
		'PE150402' => 'Alto Tapiche',
		'PE150403' => 'Capelo',
		'PE150404' => 'Emilio San Martin',
		'PE150405' => 'Maquia',
		'PE150406' => 'Puinahua',
		'PE150407' => 'Saquena',
		'PE150408' => 'Soplin',
		'PE150409' => 'Tapiche',
		'PE150410' => 'Jenaro Herrera',
		'PE150411' => 'Yaquerana',
		'PE150501' => 'Contamana',
		'PE150506' => 'Inahuaya',
		'PE150503' => 'Padre Marquez',
		'PE150504' => 'Pampa Hermosa',
		'PE150505' => 'Sarayacu',
		'PE150502' => 'Vargas Guerra',
		'PE150701' => 'Barranca',
		'PE150703' => 'Cahuapanas',
		'PE150704' => 'Manseriche',
		'PE150705' => 'Morona',
		'PE150706' => 'Pastaza',
		'PE150702' => 'Andoas',
		'PE150901' => 'Putumayo',
		'PE150902' => 'Rosa Panduro',
		'PE150903' => 'Teniente Manuel Clavero',
		'PE150904' => 'Yaguas',
	],
	'MDD' => [
		'PE160101' => 'Tambopata',
		'PE160102' => 'Inambari',
		'PE160103' => 'Las Piedras',
		'PE160104' => 'Laberinto',
		'PE160201' => 'Manu',
		'PE160202' => 'Fitzcarrald',
		'PE160203' => 'Madre de Dios',
		'PE160204' => 'Huepetuhe',
		'PE160301' => 'Inapari',
		'PE160302' => 'Iberia',
		'PE160303' => 'Tahuamanu',
	],
	'MOQ' => [
		'PE170107' => 'San Antonio',
		'PE170101' => 'Moquegua',
		'PE170102' => 'Carumas',
		'PE170103' => 'Cuchumbaya',
		'PE170106' => 'Samegua',
		'PE170104' => 'San Cristobal',
		'PE170105' => 'Torata',
		'PE170201' => 'Omate',
		'PE170203' => 'Chojata',
		'PE170202' => 'Coalaque',
		'PE170204' => 'Ichuna',
		'PE170205' => 'La Capilla',
		'PE170206' => 'Lloque',
		'PE170207' => 'Matalaque',
		'PE170208' => 'Puquina',
		'PE170209' => 'Quinistaquillas',
		'PE170210' => 'Ubinas',
		'PE170211' => 'Yunga',
		'PE170301' => 'Ilo',
		'PE170302' => 'El Algarrobal',
		'PE170303' => 'Pacocha',
	],
	'PAS' => [
		'PE180101' => 'Chaupimarca',
		'PE180103' => 'Huachon',
		'PE180104' => 'Huariaca',
		'PE180105' => 'Huayllay',
		'PE180106' => 'Ninacaca',
		'PE180107' => 'Pallanchacra',
		'PE180108' => 'Paucartambo',
		'PE180109' => 'San Francisco de Asis de Yarusyacan',
		'PE180110' => 'Simon Bolivar',
		'PE180111' => 'Ticlacayan',
		'PE180112' => 'Tinyahuarco',
		'PE180113' => 'Vicco',
		'PE180114' => 'Yanacancha',
		'PE180201' => 'Yanahuanca',
		'PE180202' => 'Chacayan',
		'PE180203' => 'Goyllarisquizga',
		'PE180204' => 'Paucar',
		'PE180205' => 'San Pedro de Pillao',
		'PE180206' => 'Santa Ana de Tusi',
		'PE180207' => 'Tapuc',
		'PE180208' => 'Vilcabamba',
		'PE180301' => 'Oxapampa',
		'PE180302' => 'Chontabamba',
		'PE180303' => 'Huancabamba',
		'PE180307' => 'Palcazu',
		'PE180306' => 'Pozuzo',
		'PE180304' => 'Puerto Bermudez',
		'PE180305' => 'Villa Rica',
		'PE180308' => 'Constitucion',
	],
	'PIU' => [
		'PE190101' => 'Piura',
		'PE190103' => 'Castilla',
		'PE190104' => 'Catacaos',
		'PE190113' => 'Cura Mori',
		'PE190114' => 'El Tallan',
		'PE190105' => 'La Arena',
		'PE190106' => 'La Union',
		'PE190107' => 'Las Lomas',
		'PE190109' => 'Tambo Grande',
		'PE190115' => 'Veintiseis de Octubre',
		'PE190201' => 'Ayabaca',
		'PE190202' => 'Frias',
		'PE190209' => 'Jilili',
		'PE190203' => 'Lagunas',
		'PE190204' => 'Montero',
		'PE190205' => 'Pacaipampa',
		'PE190210' => 'Paimas',
		'PE190206' => 'Sapillica',
		'PE190207' => 'Sicchez',
		'PE190208' => 'Suyo',
		'PE190301' => 'Huancabamba',
		'PE190302' => 'Canchaque',
		'PE190306' => 'El Carmen de la Frontera',
		'PE190303' => 'Huarmaca',
		'PE190308' => 'Lalaquiz',
		'PE190307' => 'San Miguel de El Faique',
		'PE190304' => 'Sondor',
		'PE190305' => 'Sondorillo',
		'PE190401' => 'Chulucanas',
		'PE190402' => 'Buenos Aires',
		'PE190403' => 'Chalaco',
		'PE190408' => 'La Matanza',
		'PE190404' => 'Morropon',
		'PE190405' => 'Salitral',
		'PE190410' => 'San Juan de Bigote',
		'PE190406' => 'Santa Catalina de Mossa',
		'PE190407' => 'Santo Domingo',
		'PE190409' => 'Yamango',
		'PE190501' => 'Paita',
		'PE190502' => 'Amotape',
		'PE190503' => 'Arenal',
		'PE190505' => 'Colan',
		'PE190504' => 'La Huaca',
		'PE190506' => 'Tamarindo',
		'PE190507' => 'Vichayal',
		'PE190601' => 'Sullana',
		'PE190602' => 'Bellavista',
		'PE190608' => 'Ignacio Escudero',
		'PE190603' => 'Lancones',
		'PE190604' => 'Marcavelica',
		'PE190605' => 'Miguel Checa',
		'PE190606' => 'Querecotillo',
		'PE190607' => 'Salitral',
		'PE190701' => 'Parinas',
		'PE190702' => 'El Alto',
		'PE190703' => 'La Brea',
		'PE190704' => 'Lobitos',
		'PE190706' => 'Los Organos',
		'PE190705' => 'Mancora',
		'PE190801' => 'Sechura',
		'PE190804' => 'Bellavista de la Union',
		'PE190803' => 'Bernal',
		'PE190805' => 'Cristo Nos Valga',
		'PE190802' => 'Vice',
		'PE190806' => 'Rinconada Llicuar',
	],
	'PUN' => [
		'PE200101' => 'Puno',
		'PE200102' => 'Acora',
		'PE200115' => 'Amantani',
		'PE200103' => 'Atuncolla',
		'PE200104' => 'Capachica',
		'PE200106' => 'Chucuito',
		'PE200105' => 'Coata',
		'PE200107' => 'Huata',
		'PE200108' => 'Manazo',
		'PE200109' => 'Paucarcolla',
		'PE200110' => 'Pichacani',
		'PE200114' => 'Plateria',
		'PE200111' => 'San Antonio',
		'PE200112' => 'Tiquillaca',
		'PE200113' => 'Vilque',
		'PE200201' => 'Azangaro',
		'PE200202' => 'Achaya',
		'PE200203' => 'Arapa',
		'PE200204' => 'Asillo',
		'PE200205' => 'Caminaca',
		'PE200206' => 'Chupa',
		'PE200207' => 'Jose Domingo Choquehuanca',
		'PE200208' => 'Munani',
		'PE200210' => 'Potoni',
		'PE200212' => 'Saman',
		'PE200213' => 'San Anton',
		'PE200214' => 'San Jose',
		'PE200215' => 'San Juan de Salinas',
		'PE200216' => 'Santiago de Pupuja',
		'PE200217' => 'Tirapata',
		'PE200301' => 'Macusani',
		'PE200302' => 'Ajoyani',
		'PE200303' => 'Ayapata',
		'PE200304' => 'Coasa',
		'PE200305' => 'Corani',
		'PE200306' => 'Crucero',
		'PE200307' => 'Ituata',
		'PE200308' => 'Ollachea',
		'PE200309' => 'San Gaban',
		'PE200310' => 'Usicayos',
		'PE200401' => 'Juli',
		'PE200402' => 'Desaguadero',
		'PE200403' => 'Huacullani',
		'PE200412' => 'Kelluyo',
		'PE200406' => 'Pisacoma',
		'PE200407' => 'Pomata',
		'PE200410' => 'Zepita',
		'PE201201' => 'Ilave',
		'PE201204' => 'Capazo',
		'PE201202' => 'Pilcuyo',
		'PE201203' => 'Santa Rosa',
		'PE201205' => 'Conduriri',
		'PE200501' => 'Huancane',
		'PE200502' => 'Cojata',
		'PE200511' => 'Huatasani',
		'PE200504' => 'Inchupalla',
		'PE200506' => 'Pusi',
		'PE200507' => 'Rosaspata',
		'PE200508' => 'Taraco',
		'PE200509' => 'Vilque Chico',
		'PE200601' => 'Lampa',
		'PE200602' => 'Cabanilla',
		'PE200603' => 'Calapuja',
		'PE200604' => 'Nicasio',
		'PE200605' => 'Ocuviri',
		'PE200606' => 'Palca',
		'PE200607' => 'Paratia',
		'PE200608' => 'Pucara',
		'PE200609' => 'Santa Lucia',
		'PE200610' => 'Vilavila',
		'PE200701' => 'Ayaviri',
		'PE200702' => 'Antauta',
		'PE200703' => 'Cupi',
		'PE200704' => 'Llalli',
		'PE200705' => 'Macari',
		'PE200706' => 'Nunoa',
		'PE200707' => 'Orurillo',
		'PE200708' => 'Santa Rosa',
		'PE200709' => 'Umachiri',
		'PE201301' => 'Moho',
		'PE201302' => 'Conima',
		'PE201304' => 'Huayrapata',
		'PE201303' => 'Tilali',
		'PE201101' => 'Putina',
		'PE201104' => 'Ananea',
		'PE201102' => 'Pedro Vilca Apaza',
		'PE201103' => 'Quilcapuncu',
		'PE201105' => 'Sina',
		'PE200901' => 'Juliaca',
		'PE200902' => 'Cabana',
		'PE200903' => 'Cabanillas',
		'PE200904' => 'Caracoto',
		'PE200905' => 'San Miguel',
		'PE200801' => 'Sandia',
		'PE200803' => 'Cuyocuyo',
		'PE200804' => 'Limbani',
		'PE200806' => 'Patambuco',
		'PE200805' => 'Phara',
		'PE200807' => 'Quiaca',
		'PE200808' => 'San Juan del Oro',
		'PE200810' => 'Yanahuaya',
		'PE200811' => 'Alto Inambari',
		'PE200812' => 'San Pedro de Putina Punco',
		'PE201001' => 'Yunguyo',
		'PE201003' => 'Anapia',
		'PE201004' => 'Copani',
		'PE201005' => 'Cuturapi',
		'PE201006' => 'Ollaraya',
		'PE201007' => 'Tinicachi',
		'PE201002' => 'Unicachi',
	],
	'SAM' => [
		'PE210806' => 'Santa Lucia',
		'PE210101' => 'Moyobamba',
		'PE210102' => 'Calzada',
		'PE210103' => 'Habana',
		'PE210104' => 'Jepelacio',
		'PE210105' => 'Soritor',
		'PE210106' => 'Yantalo',
		'PE210701' => 'Bellavista',
		'PE210704' => 'Alto Biavo',
		'PE210706' => 'Bajo Biavo',
		'PE210705' => 'Huallaga',
		'PE210703' => 'San Pablo',
		'PE210702' => 'San Rafael',
		'PE211001' => 'San Jose de Sisa',
		'PE211002' => 'Agua Blanca',
		'PE211004' => 'San Martin',
		'PE211005' => 'Santa Rosa',
		'PE211003' => 'Shatoja',
		'PE210201' => 'Saposoa',
		'PE210205' => 'Alto Saposoa',
		'PE210206' => 'El Eslabon',
		'PE210202' => 'Piscoyacu',
		'PE210203' => 'Sacanche',
		'PE210204' => 'Tingo de Saposoa',
		'PE210301' => 'Lamas',
		'PE210315' => 'Alonso de Alvarado',
		'PE210303' => 'Barranquita',
		'PE210304' => 'Caynarachi',
		'PE210305' => 'Cunumbuqui',
		'PE210306' => 'Pinto Recodo',
		'PE210307' => 'Rumisapa',
		'PE210316' => 'San Roque de Cumbaza',
		'PE210311' => 'Shanao',
		'PE210313' => 'Tabalosos',
		'PE210314' => 'Zapatero',
		'PE210401' => 'Juanjui',
		'PE210402' => 'Campanilla',
		'PE210403' => 'Huicungo',
		'PE210404' => 'Pachiza',
		'PE210405' => 'Pajarillo',
		'PE210901' => 'Picota',
		'PE210902' => 'Buenos Aires',
		'PE210903' => 'Caspisapa',
		'PE210904' => 'Pilluana',
		'PE210905' => 'Pucacaca',
		'PE210906' => 'San Cristobal',
		'PE210907' => 'San Hilarion',
		'PE210910' => 'Shamboyacu',
		'PE210908' => 'Tingo de Ponasa',
		'PE210909' => 'Tres Unidos',
		'PE210501' => 'Rioja',
		'PE210509' => 'Awajun',
		'PE210506' => 'Elias Soplin Vargas',
		'PE210505' => 'Nueva Cajamarca',
		'PE210508' => 'Pardo Miguel',
		'PE210502' => 'Posic',
		'PE210507' => 'San Fernando',
		'PE210503' => 'Yorongos',
		'PE210504' => 'Yuracyacu',
		'PE210601' => 'Tarapoto',
		'PE210602' => 'Alberto Leveau',
		'PE210604' => 'Cacatachi',
		'PE210606' => 'Chazuta',
		'PE210607' => 'Chipurana',
		'PE210608' => 'El Porvenir',
		'PE210609' => 'Huimbayoc',
		'PE210610' => 'Juan Guerra',
		'PE210621' => 'La Banda de Shilcayo',
		'PE210611' => 'Morales',
		'PE210612' => 'Papaplaya',
		'PE210616' => 'San Antonio',
		'PE210619' => 'Sauce',
		'PE210620' => 'Shapaja',
		'PE210801' => 'Tocache',
		'PE210802' => 'Nuevo Progreso',
		'PE210803' => 'Polvora',
		'PE210804' => 'Shunte',
		'PE210805' => 'Uchiza',
	],
	'TAC' => [
		'PE220101' => 'Tacna',
		'PE220111' => 'Alto de la Alianza',
		'PE220102' => 'Calana',
		'PE220112' => 'Ciudad Nueva',
		'PE220104' => 'Inclan',
		'PE220107' => 'Pachia',
		'PE220108' => 'Palca',
		'PE220109' => 'Pocollay',
		'PE220110' => 'Sama',
		'PE220113' => 'Coronel Gregorio Albarracin Lanchip',
		'PE220114' => 'La Yarada Los Palos',
		'PE220401' => 'Candarave',
		'PE220402' => 'Cairani',
		'PE220406' => 'Camilaca',
		'PE220403' => 'Curibaya',
		'PE220404' => 'Huanuara',
		'PE220405' => 'Quilahuani',
		'PE220301' => 'Locumba',
		'PE220303' => 'Ilabaya',
		'PE220302' => 'Ite',
		'PE220201' => 'Tarata',
		'PE220205' => 'Chucatamani',
		'PE220206' => 'Estique',
		'PE220207' => 'Estique-Pampa',
		'PE220210' => 'Sitajara',
		'PE220211' => 'Susapaya',
		'PE220212' => 'Tarucachi',
		'PE220213' => 'Ticaco',
	],
	'TUM' => [
		'PE230201' => 'Zorritos',
		'PE230202' => 'Casitas',
		'PE230203' => 'Canoas de Punta Sal',
		'PE230301' => 'Zarumilla',
		'PE230304' => 'Aguas Verdes',
		'PE230302' => 'Matapalo',
		'PE230303' => 'Papayal',
		'PE230101' => 'Tumbes',
		'PE230102' => 'Corrales',
		'PE230103' => 'La Cruz',
		'PE230104' => 'Pampas de Hospital',
		'PE230105' => 'San Jacinto',
		'PE230106' => 'San Juan de la Virgen',
	],
	'UCA' => [
		'PE250101' => 'Calleria',
		'PE250104' => 'Campoverde',
		'PE250105' => 'Iparia',
		'PE250103' => 'Masisea',
		'PE250102' => 'Yarinacocha',
		'PE250106' => 'Nueva Requena',
		'PE250107' => 'Manantay',
		'PE250301' => 'Raymondi',
		'PE250304' => 'Sepahua',
		'PE250302' => 'Tahuania',
		'PE250303' => 'Yurua',
		'PE250201' => 'Padre Abad',
		'PE250202' => 'Irazola',
		'PE250203' => 'Curimana',
		'PE250204' => 'Neshuya',
		'PE250205' => 'Alexander Von Humboldt',
		'PE250401' => 'Purus',
		'PE250207' => 'Huipoca',
		'PE250206' => 'Boqueron',
	]
];
