<?php

/**
 * List of cities for: Nigeria
 * Source: http://www.statoids.com/yng.html
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['NG'];

$country_cities = [
	'AB' => [
		'NGABAN' => 'Aba North',
		'NGABAR' => 'Arochukwu',
		'NGABAS' => 'Aba South',
		'NGABBE' => 'Bende',
		'NGABIK' => 'Ikwuano',
		'NGABIN' => 'Isiala-Ngwa North',
		'NGABIS' => 'Isiala-Ngwa South',
		'NGABIT' => 'Isuikwato',
		'NGABOB' => 'Obi Ngwa',
		'NGABOH' => 'Ohafia',
		'NGABOS' => 'Osisioma Ngwa',
		'NGABUE' => 'Ukwa East',
		'NGABUG' => 'Ugwunagbo',
		'NGABUM' => 'Umu-Nneochi',
		'NGABUN' => 'Umuahia North',
		'NGABUS' => 'Umuahia South',
		'NGABUW' => 'Ukwa West',
	],
	'AD' => [
		'NGADDE' => 'Demsa',
		'NGADFU' => 'Fufore',
		'NGADGA' => 'Ganye',
		'NGADGI' => 'Girie',
		'NGADGO' => 'Gombi',
		'NGADGU' => 'Guyuk',
		'NGADHO' => 'Hong',
		'NGADJA' => 'Jada',
		'NGADLA' => 'Lamurde',
		'NGADMB' => 'Mayo-Belwa',
		'NGADMD' => 'Madagali',
		'NGADMH' => 'Maiha',
		'NGADMI' => 'Michika',
		'NGADMN' => 'Mubi North',
		'NGADMS' => 'Mubi South',
		'NGADNU' => 'Numan',
		'NGADSH' => 'Shelleng',
		'NGADSO' => 'Song',
		'NGADTE' => 'Toungo',
		'NGADYN' => 'Yola North',
		'NGADYS' => 'Yola South',
	],
	'AK' => [
		'NGAKAB' => 'Abak',
		'NGAKEK' => 'Eket',
		'NGAKEO' => 'Eastern Obolo',
		'NGAKEP' => 'Etim Ekpo',
		'NGAKES' => 'Esit Eket',
		'NGAKET' => 'Etinan',
		'NGAKEU' => 'Essien Udim',
		'NGAKIA' => 'Ikot Abasi',
		'NGAKIB' => 'Ibeno',
		'NGAKIE' => 'Ikot Ekpene',
		'NGAKII' => 'Ibiono Ibom',
		'NGAKIK' => 'Ika',
		'NGAKIN' => 'Ini',
		'NGAKIO' => 'Ikono',
		'NGAKIP' => 'Ibesikpo Asutan',
		'NGAKIT' => 'Itu',
		'NGAKMB' => 'Mbo',
		'NGAKME' => 'Mkpat Enin',
		'NGAKNA' => 'Nsit Atai',
		'NGAKNI' => 'Nsit Ibom',
		'NGAKNU' => 'Nsit Ubium',
		'NGAKOA' => 'Oruk Anam',
		'NGAKOB' => 'Obot Akara',
		'NGAKOK' => 'Okobo',
		'NGAKON' => 'Onna',
		'NGAKOR' => 'Oron',
		'NGAKUK' => 'Ukanafun',
		'NGAKUO' => 'Urue-Offong/Oruko',
		'NGAKUR' => 'Uruan',
		'NGAKUU' => 'Udung Uko',
		'NGAKUY' => 'Uyo',
	],
	'AN' => [
		'NGANAC' => 'Anaocha',
		'NGANAE' => 'Anambra East',
		'NGANAG' => 'Aguata',
		'NGANAN' => 'Awka North',
		'NGANAS' => 'Awka South',
		'NGANAW' => 'Anambra West',
		'NGANAY' => 'Ayamelum',
		'NGANDU' => 'Dunukofia',
		'NGANEK' => 'Ekwusigo',
		'NGANIH' => 'Ihiala',
		'NGANIN' => 'Idemili North',
		'NGANIS' => 'Idemili south',
		'NGANNJ' => 'Njikoka',
		'NGANNN' => 'Nnewi North',
		'NGANNS' => 'Nnewi South',
		'NGANOB' => 'Orumba South',
		'NGANOG' => 'Ogbaru',
		'NGANON' => 'Onitsha North',
		'NGANOR' => 'Orumba North',
		'NGANOS' => 'Onitsha South',
		'NGANOY' => 'Oyi',
	],
	'BA' => [
		'NGBAAL' => 'Alkaleri',
		'NGBABA' => 'Bauchi',
		'NGBABO' => 'Bogoro',
		'NGBADB' => 'Damban',
		'NGBADS' => 'Dass',
		'NGBADZ' => 'Darazo',
		'NGBAGI' => 'Giade',
		'NGBAGM' => 'Gamawa',
		'NGBAGN' => 'Ganjuwa',
		'NGBAIG' => 'Itas/Gadau',
		'NGBAJA' => 'Jama’are',
		'NGBAKA' => 'Katagum',
		'NGBAKI' => 'Kirfi',
		'NGBAMI' => 'Misau',
		'NGBANI' => 'Ningi',
		'NGBASH' => 'Shira',
		'NGBATB' => 'Tafawa-Balewa',
		'NGBATO' => 'Toro',
		'NGBAWA' => 'Warji',
		'NGBAZA' => 'Zaki',
	],
	'BE' => [
		'NGBEAA' => 'Apa',
		'NGBEAG' => 'Agatu',
		'NGBEAO' => 'Ado',
		'NGBEBU' => 'Buruku',
		'NGBEGB' => 'Gboko',
		'NGBEGE' => 'Gwer East',
		'NGBEGU' => 'Guma',
		'NGBEGW' => 'Gwer West',
		'NGBEKA' => 'Katsina-Ala',
		'NGBEKO' => 'Konshisha',
		'NGBEKW' => 'Kwande',
		'NGBELO' => 'Logo',
		'NGBEMA' => 'Makurdi',
		'NGBEOB' => 'Obi',
		'NGBEOG' => 'Ogbadibo',
		'NGBEOH' => 'Ohimini',
		'NGBEOJ' => 'Oju',
		'NGBEOK' => 'Okpokwu',
		'NGBEOT' => 'Oturkpo',
		'NGBETA' => 'Tarka',
		'NGBEUK' => 'Ukum',
		'NGBEUS' => 'Ushongo',
		'NGBEVA' => 'Vandeikya',
	],
	'BO' => [
		'NGBOAB' => 'Abadam',
		'NGBOAU' => 'Askira/Uba',
		'NGBOBI' => 'Biu',
		'NGBOBM' => 'Bama',
		'NGBOBY' => 'Bayo',
		'NGBOCH' => 'Chibok',
		'NGBODA' => 'Damboa',
		'NGBODI' => 'Dikwa',
		'NGBOGB' => 'Gubio',
		'NGBOGM' => 'Guzamala',
		'NGBOGW' => 'Gwoza',
		'NGBOHA' => 'Hawul',
		'NGBOJE' => 'Jere',
		'NGBOKA' => 'Kaga',
		'NGBOKB' => 'Kala/Balge',
		'NGBOKK' => 'Kwaya Kusar',
		'NGBOKO' => 'Konduga',
		'NGBOKU' => 'Kukawa',
		'NGBOMB' => 'Mobbar',
		'NGBOMD' => 'Maiduguri',
		'NGBOMF' => 'Mafa',
		'NGBOMM' => 'Magumeri',
		'NGBOMN' => 'Monguno',
		'NGBOMT' => 'Marte',
		'NGBONL' => 'Ngala',
		'NGBONZ' => 'Nganzai',
		'NGBOSH' => 'Shani',
	],
	'BY' => [
		'NGBYBR' => 'Brass',
		'NGBYEK' => 'Ekeremor',
		'NGBYKO' => 'Kolokuma/Opokuma',
		'NGBYNE' => 'Nembe',
		'NGBYOG' => 'Ogbia',
		'NGBYSA' => 'Sagbama',
		'NGBYSI' => 'Southern Ijaw',
		'NGBYYE' => 'Yenegoa',
	],
	'CR' => [
		'NGCRAB' => 'Abi',
		'NGCRAM' => 'Akamkpa',
		'NGCRAY' => 'Akpabuyo',
		'NGCRBA' => 'Bakassi',
		'NGCRBE' => 'Bekwarra',
		'NGCRBI' => 'Biase',
		'NGCRBO' => 'Boki',
		'NGCRCM' => 'Calabar-Municipal',
		'NGCRCS' => 'Calabar South',
		'NGCRET' => 'Etung',
		'NGCRIK' => 'Ikom',
		'NGCROB' => 'Obubra',
		'NGCROG' => 'Ogoja',
		'NGCROL' => 'Obanliku',
		'NGCROP' => 'Odukpani',
		'NGCROU' => 'Obudu',
		'NGCRYK' => 'Yakurr',
		'NGCRYL' => 'Yala',
	],
	'DE' => [
		'NGDEAN' => 'Aniocha North',
		'NGDEAS' => 'Aniocha South',
		'NGDEBO' => 'Bomadi',
		'NGDEBU' => 'Burutu',
		'NGDEEE' => 'Ethiope East',
		'NGDEEW' => 'Ethiope West',
		'NGDEIE' => 'Ika North East',
		'NGDEIK' => 'Ika South',
		'NGDEIN' => 'Isoko North',
		'NGDEIS' => 'Isoko South',
		'NGDENE' => 'Ndokwa East',
		'NGDENW' => 'Ndokwa West',
		'NGDEOK' => 'Okpe',
		'NGDEON' => 'Oshimili North',
		'NGDEOS' => 'Oshimili South',
		'NGDEPA' => 'Patani',
		'NGDESA' => 'Sapele',
		'NGDEUD' => 'Udu',
		'NGDEUK' => 'Ukwuani',
		'NGDEUN' => 'Ughelli North',
		'NGDEUS' => 'Ughelli South',
		'NGDEUV' => 'Uvwie',
		'NGDEWN' => 'Warri North',
		'NGDEWS' => 'Warri South',
		'NGDEWW' => 'Warri South West',
	],
	'EB' => [
		'NGEBAB' => 'Abakaliki',
		'NGEBAN' => 'Afikpo North',
		'NGEBAS' => 'Afikpo South',
		'NGEBEB' => 'Ebonyi',
		'NGEBEN' => 'Ezza North',
		'NGEBES' => 'Ezza South',
		'NGEBIK' => 'Ikwo',
		'NGEBIS' => 'Ishielu',
		'NGEBIV' => 'Ivo',
		'NGEBIZ' => 'Izzi',
		'NGEBOK' => 'Ohaukwu',
		'NGEBON' => 'Onicha',
		'NGEBOZ' => 'Ohaozara',
	],
	'ED' => [
		'NGEDAE' => 'Akoko-Edo',
		'NGEDEC' => 'Esan Central',
		'NGEDEG' => 'Egor',
		'NGEDEK' => 'Etsako East',
		'NGEDEN' => 'Esan North East',
		'NGEDEO' => 'Etsako West',
		'NGEDES' => 'Esan South East',
		'NGEDET' => 'Etsako Central',
		'NGEDEW' => 'Esan West',
		'NGEDIG' => 'Igueben',
		'NGEDIO' => 'Ikpoba-Okha',
		'NGEDOE' => 'Owan East',
		'NGEDOH' => 'Orhionmwon',
		'NGEDON' => 'Ovia North East',
		'NGEDOR' => 'Oredo',
		'NGEDOS' => 'Ovia South West',
		'NGEDOW' => 'Owan West',
		'NGEDUH' => 'Uhunmwonde',
	],
	'EK' => [
		'NGEKAE' => 'Ado Ekiti',
		'NGEKAI' => 'Aiyekire',
		'NGEKEE' => 'Ekiti East',
		'NGEKEF' => 'Efon',
		'NGEKEM' => 'Emure',
		'NGEKES' => 'Ekiti South West',
		'NGEKEW' => 'Ekiti West',
		'NGEKID' => 'Idosi-Osi',
		'NGEKII' => 'Irepodun/Ifelodun',
		'NGEKIJ' => 'Ijero',
		'NGEKIK' => 'Ikole',
		'NGEKIL' => 'Ilejemeje',
		'NGEKIO' => 'Ise/Orun',
		'NGEKIR' => 'Ikere',
		'NGEKMO' => 'Moba',
		'NGEKOY' => 'Oye',
	],
	'EN' => [
		'NGENAN' => 'Aninri',
		'NGENAW' => 'Awgu',
		'NGENEE' => 'Enugu East',
		'NGENEN' => 'Enugu North',
		'NGENES' => 'Enugu South',
		'NGENEZ' => 'Ezeagu',
		'NGENIE' => 'Igbo-Etiti',
		'NGENIN' => 'Igbo-Eze North',
		'NGENIS' => 'Igbo-Eze South',
		'NGENIU' => 'Isi-Uzo',
		'NGENNE' => 'Nkanu East',
		'NGENNS' => 'Nsukka',
		'NGENNW' => 'Nkanu West',
		'NGENOR' => 'Oji-River',
		'NGENUD' => 'Udi',
		'NGENUN' => 'Udenu',
		'NGENUU' => 'Uzo-Uwani',
	],
	'FC' => [
		'NGFCAB' => 'Abaji',
		'NGFCAC' => 'Abuja Municipal Area Council (AMAC)',
		'NGFCBW' => 'Bwari',
		'NGFCGW' => 'Gwagwalada',
		'NGFCKU' => 'Kuje',
		'NGFCKW' => 'Kwali',
	],
	'GO' => [
		'NGGOAK' => 'Akko',
		'NGGOBA' => 'Balanga',
		'NGGOBI' => 'Billiri',
		'NGGODU' => 'Dukku',
		'NGGOFU' => 'Funakaye',
		'NGGOGO' => 'Gombe',
		'NGGOKA' => 'Kaltungo',
		'NGGOKW' => 'Kwami',
		'NGGONA' => 'Nafada',
		'NGGOSH' => 'Shomgom',
		'NGGOYD' => 'Yamaltu/Deba',
	],
	'IM' => [
		'NGIMAB' => 'Aboh-Mbaise',
		'NGIMAZ' => 'Ahiazu-Mbaise',
		'NGIMEM' => 'Ehime-Mbano',
		'NGIMEZ' => 'Ezinihitte',
		'NGIMID' => 'Ideato South',
		'NGIMIK' => 'Ikeduru',
		'NGIMIM' => 'Isiala Mbano',
		'NGIMIN' => 'Ideato North',
		'NGIMIS' => 'Isu',
		'NGIMIU' => 'Ihitte/Uboma',
		'NGIMMB' => 'Mbaitoli',
		'NGIMNJ' => 'Njaba',
		'NGIMNK' => 'Nkwerre',
		'NGIMNO' => 'Ngor-Okpala',
		'NGIMNW' => 'Nwangele',
		'NGIMOB' => 'Obowo',
		'NGIMOE' => 'Oru East',
		'NGIMOG' => 'Oguta',
		'NGIMOJ' => 'Ohaji/Egbema',
		'NGIMOK' => 'Okigwe',
		'NGIMOL' => 'Orlu',
		'NGIMOM' => 'Owerri-Municipal',
		'NGIMON' => 'Owerri North',
		'NGIMOR' => 'Orsu',
		'NGIMOU' => 'Oru West',
		'NGIMOW' => 'Owerri West',
		'NGIMUN' => 'Unuimo',
	],
	'JI' => [
		'NGJIAU' => 'Auyo',
		'NGJIBA' => 'Babura',
		'NGJIBI' => 'Biriniwa',
		'NGJIBK' => 'Birnin Kudu',
		'NGJIBU' => 'Buji',
		'NGJIDU' => 'Dutse',
		'NGJIGG' => 'Gagarawa',
		'NGJIGK' => 'Garki',
		'NGJIGL' => 'Gumel',
		'NGJIGM' => 'Gwaram',
		'NGJIGU' => 'Guri',
		'NGJIGW' => 'Gwiwa',
		'NGJIHA' => 'Hadejia',
		'NGJIJA' => 'Jahun',
		'NGJIKG' => 'Kaugama',
		'NGJIKH' => 'Kafin Hausa',
		'NGJIKI' => 'Kiyawa',
		'NGJIKK' => 'Kiri Kasama',
		'NGJIKZ' => 'Kazaure',
		'NGJIMA' => 'Maigatari',
		'NGJIMI' => 'Miga',
		'NGJIMM' => 'Malam Madori',
		'NGJIRI' => 'Ringim',
		'NGJIRO' => 'Roni',
		'NGJIST' => 'Sule Tankarkar',
		'NGJITA' => 'Taura',
		'NGJIYA' => 'Yankwashi',
	],
	'KD' => [
		'NGKDBG' => 'Birnin-Gwari',
		'NGKDCH' => 'Chikun',
		'NGKDGI' => 'Giwa',
		'NGKDIG' => 'Igabi',
		'NGKDIK' => 'Ikara',
		'NGKDJA' => 'Jaba',
		'NGKDJE' => 'Jemaa',
		'NGKDKA' => 'Kaura',
		'NGKDKB' => 'Kubau',
		'NGKDKC' => 'Kachia',
		'NGKDKG' => 'Kagarko',
		'NGKDKJ' => 'Kajuru',
		'NGKDKN' => 'Kaduna North',
		'NGKDKR' => 'Kauru',
		'NGKDKS' => 'Kaduna South',
		'NGKDKU' => 'Kudan',
		'NGKDLE' => 'Lere',
		'NGKDMA' => 'Makarfi',
		'NGKDSA' => 'Sanga',
		'NGKDSG' => 'Sabon-Gari',
		'NGKDSO' => 'Soba',
		'NGKDZA' => 'Zarki',
		'NGKDZK' => 'Zangon-Kataf',
	],
	'KE' => [
		'NGKEAD' => 'Arewa-Dandi',
		'NGKEAL' => 'Aleiro',
		'NGKEAR' => 'Argungu',
		'NGKEAU' => 'Augie',
		'NGKEBA' => 'Bagudo',
		'NGKEBK' => 'Birnin Kebbi',
		'NGKEBU' => 'Bunza',
		'NGKEDA' => 'Dandi',
		'NGKEFA' => 'Fakai',
		'NGKEGW' => 'Gwandu',
		'NGKEJE' => 'Jega',
		'NGKEKA' => 'Kalgo',
		'NGKEKB' => 'Koko/Besse',
		'NGKEMA' => 'Maiyama',
		'NGKENG' => 'Ngaski',
		'NGKESA' => 'Sakaba',
		'NGKESH' => 'Shanga',
		'NGKESU' => 'Suru',
		'NGKEWD' => 'Wasagu/Danko',
		'NGKEYA' => 'Yauri',
		'NGKEZU' => 'Zuru',
	],
	'KN' => [
		'NGKNAJ' => 'Ajingi',
		'NGKNAL' => 'Albasu',
		'NGKNBA' => 'Bagwai',
		'NGKNBE' => 'Bebeji',
		'NGKNBI' => 'Bichi',
		'NGKNBU' => 'Bunkure',
		'NGKNDK' => 'Dawakin Kudu',
		'NGKNDL' => 'Dala',
		'NGKNDM' => 'Dambatta',
		'NGKNDO' => 'Doguwa',
		'NGKNDT' => 'Dawakin Tofa',
		'NGKNFA' => 'Fagge',
		'NGKNGB' => 'Gabasawa',
		'NGKNGE' => 'Gezawa',
		'NGKNGK' => 'Garko',
		'NGKNGL' => 'Gwale',
		'NGKNGM' => 'Garum Mallam',
		'NGKNGW' => 'Gwarzo',
		'NGKNGY' => 'Gaya',
		'NGKNKB' => 'Kabo',
		'NGKNKI' => 'Kibiya',
		'NGKNKM' => 'Kano Municipal',
		'NGKNKN' => 'Kunchi',
		'NGKNKR' => 'Kiru',
		'NGKNKT' => 'Kumbotso',
		'NGKNKU' => 'Kura',
		'NGKNKY' => 'Karaye',
		'NGKNMD' => 'Madobi',
		'NGKNMI' => 'Minjibir',
		'NGKNMK' => 'Makoda',
		'NGKNNA' => 'Nassarawa',
		'NGKNRA' => 'Rano',
		'NGKNRG' => 'Rimin Gado',
		'NGKNRO' => 'Rogo',
		'NGKNSH' => 'Shanono',
		'NGKNSU' => 'Sumaila',
		'NGKNTK' => 'Takai',
		'NGKNTO' => 'Tofa',
		'NGKNTR' => 'Tarauni',
		'NGKNTS' => 'Tsanyawa',
		'NGKNTW' => 'Tudun Wada',
		'NGKNUN' => 'Ungogo',
		'NGKNWA' => 'Warawa',
		'NGKNWU' => 'Wudil',
	],
	'KO' => [
		'NGKOAD' => 'Adavi',
		'NGKOAJ' => 'Ajaokuta',
		'NGKOAN' => 'Ankpa',
		'NGKOBA' => 'Bassa',
		'NGKODE' => 'Dekina',
		'NGKOIB' => 'Ibaji',
		'NGKOID' => 'Idah',
		'NGKOIJ' => 'Ijumu',
		'NGKOIO' => 'Igalamela-Odolu',
		'NGKOKB' => 'Kabba/Bunu',
		'NGKOKO' => 'Kogi',
		'NGKOLO' => 'Lokoja',
		'NGKOMM' => 'Mopa-Muro',
		'NGKOOB' => 'Olamabolo',
		'NGKOOF' => 'Ofu',
		'NGKOOH' => 'Okehi',
		'NGKOOL' => 'Omala',
		'NGKOOM' => 'Ogori/Magongo',
		'NGKOON' => 'Okene',
		'NGKOYE' => 'Yagba East',
		'NGKOYW' => 'Yagba West',
	],
	'KT' => [
		'NGKTBG' => 'Batagarawa',
		'NGKTBI' => 'Bindawa',
		'NGKTBK' => 'Bakori',
		'NGKTBS' => 'Batsari',
		'NGKTBU' => 'Baure',
		'NGKTCH' => 'Charanchi',
		'NGKTDD' => 'Dandume',
		'NGKTDJ' => 'Danja',
		'NGKTDM' => 'Dan Musa',
		'NGKTDR' => 'Daura',
		'NGKTDT' => 'Dutsin-Ma',
		'NGKTDU' => 'Dutsi',
		'NGKTFA' => 'Faskari',
		'NGKTFU' => 'Funtua',
		'NGKTIN' => 'Ingawa',
		'NGKTJI' => 'Jibia',
		'NGKTKA' => 'Katsina',
		'NGKTKD' => 'Kusada',
		'NGKTKF' => 'Kafur',
		'NGKTKK' => 'Kankia',
		'NGKTKN' => 'Kankara',
		'NGKTKR' => 'Kurfi',
		'NGKTKT' => 'Kaita',
		'NGKTMD' => 'Mai’adua',
		'NGKTMF' => 'Malumfashi',
		'NGKTMN' => 'Mani',
		'NGKTMS' => 'Mashi',
		'NGKTMU' => 'Musawa',
		'NGKTMZ' => 'Matazu',
		'NGKTRI' => 'Rimi',
		'NGKTSB' => 'Sabuwa',
		'NGKTSF' => 'Safana',
		'NGKTSN' => 'Sandamu',
		'NGKTZA' => 'Zango',
	],
	'KW' => [
		'NGKWAS' => 'Asa',
		'NGKWBA' => 'Baruten',
		'NGKWED' => 'Edu',
		'NGKWEK' => 'Ekiti',
		'NGKWIE' => 'Ilorin East',
		'NGKWIF' => 'Ifelodun',
		'NGKWIN' => 'Isin',
		'NGKWIR' => 'Irepodun',
		'NGKWIS' => 'Ilorin South',
		'NGKWIW' => 'Ilorin West',
		'NGKWKA' => 'Kaiama',
		'NGKWMO' => 'Moro',
		'NGKWOF' => 'Offa',
		'NGKWOO' => 'Oke-Ero',
		'NGKWOY' => 'Oyun',
		'NGKWPA' => 'Pategi',
	],
	'LA' => [
		'NGLAAG' => 'Agege',
		'NGLAAI' => 'Ajeromi-Ifelodun',
		'NGLAAL' => 'Alimosho',
		'NGLAAO' => 'Amuwo-Odofin',
		'NGLAAP' => 'Apapa',
		'NGLABA' => 'Badagry',
		'NGLAEO' => 'Eti-Osa',
		'NGLAEP' => 'Epe',
		'NGLAID' => 'Ikorodu',
		'NGLAII' => 'Ifako-Ijaye',
		'NGLAIJ' => 'Ikeja',
		'NGLAIL' => 'Ibeju/Lekki',
		'NGLAKO' => 'Kosofe',
		'NGLALI' => 'Lagos Island',
		'NGLALM' => 'Lagos Mainland',
		'NGLAMU' => 'Mushin',
		'NGLAOI' => 'Oshodi-Isolo',
		'NGLAOJ' => 'Ojo',
		'NGLASH' => 'Shomolu',
		'NGLASU' => 'Surulere',
	],
	'NA' => [
		'NGNAAK' => 'Akwanga',
		'NGNAAW' => 'Awe',
		'NGNADO' => 'Doma',
		'NGNAKA' => 'Karu',
		'NGNAKF' => 'Keffi',
		'NGNAKN' => 'Keana',
		'NGNAKO' => 'Kokona',
		'NGNALA' => 'Lafia',
		'NGNANA' => 'Nassarawa',
		'NGNANE' => 'Nassarawa Egon',
		'NGNAOB' => 'Obi',
		'NGNATO' => 'Toto',
		'NGNAWA' => 'Wamba',
	],
	'NI' => [
		'NGNIAA' => 'Agaie',
		'NGNIAW' => 'Agwara',
		'NGNIBI' => 'Bida',
		'NGNIBR' => 'Borgu',
		'NGNIBS' => 'Bosso',
		'NGNICH' => 'Chanchaga',
		'NGNIED' => 'Edati',
		'NGNIGB' => 'Gbako',
		'NGNIGU' => 'Gurara',
		'NGNIKA' => 'Katcha',
		'NGNIKO' => 'Kontagora',
		'NGNILP' => 'Lapai',
		'NGNILV' => 'Lavun',
		'NGNIMM' => 'Magama',
		'NGNIMO' => 'Mokwa',
		'NGNIMR' => 'Mariga',
		'NGNIMS' => 'Mashegu',
		'NGNIMU' => 'Muya',
		'NGNIPA' => 'Paikoro',
		'NGNIRA' => 'Rafi',
		'NGNIRI' => 'Rijau',
		'NGNISH' => 'Shiroro',
		'NGNISU' => 'Suleja',
		'NGNITA' => 'Tafa',
		'NGNIWU' => 'Wushishi',
	],
	'OG' => [
		'NGOGAN' => 'Abeokuta North',
		'NGOGAO' => 'Ado-Odo/Ota',
		'NGOGAS' => 'Abeokuta South',
		'NGOGEN' => 'Egbado North',
		'NGOGES' => 'Egbado South',
		'NGOGEW' => 'Ewekoro',
		'NGOGIA' => 'Imeko-Afon',
		'NGOGIE' => 'Ijebu East',
		'NGOGIF' => 'Ifo',
		'NGOGIJ' => 'Ijebu North',
		'NGOGIK' => 'Ikenne',
		'NGOGIN' => 'Ijebu North East',
		'NGOGIO' => 'Ijebu Ode',
		'NGOGIP' => 'Ipokia',
		'NGOGOB' => 'Odogbolu',
		'NGOGOD' => 'Odeda',
		'NGOGOO' => 'Obafemi-Owode',
		'NGOGOW' => 'Ogun Waterside',
		'NGOGRN' => 'Remo North',
		'NGOGSH' => 'Shagamu',
	],
	'ON' => [
		'NGONAE' => 'Akoko South East',
		'NGONAK' => 'Akure North',
		'NGONAN' => 'Akoko North East',
		'NGONAR' => 'Akure South',
		'NGONAS' => 'Akoko South West',
		'NGONAW' => 'Akoko North West',
		'NGONEO' => 'Ese-Odo',
		'NGONID' => 'Idanre',
		'NGONIF' => 'Ifedore',
		'NGONIL' => 'Ilaje',
		'NGONIO' => 'Ile-Oluji-Okeigbo',
		'NGONIR' => 'Irele',
		'NGONOD' => 'Odigbo',
		'NGONOE' => 'Ondo East',
		'NGONOK' => 'Okitipupa',
		'NGONOO' => 'Owo',
		'NGONOS' => 'Ose',
		'NGONOW' => 'Ondo West',
	],
	'OS' => [
		'NGOSAD' => 'Aiyedade',
		'NGOSAE' => 'Atakunmosa East',
		'NGOSAI' => 'Aiyedire',
		'NGOSAW' => 'Atakunmosa West',
		'NGOSBL' => 'Boluwaduro',
		'NGOSBP' => 'Boripe',
		'NGOSEG' => 'Egbedore',
		'NGOSEJ' => 'Ejigbo',
		'NGOSEN' => 'Ede North',
		'NGOSES' => 'Ede South',
		'NGOSIC' => 'Ife Central',
		'NGOSID' => 'Ifelodun',
		'NGOSIE' => 'Ife East',
		'NGOSIF' => 'Ifedayo',
		'NGOSIH' => 'Ilesha East',
		'NGOSIK' => 'Isokan',
		'NGOSIL' => 'Ila',
		'NGOSIN' => 'Ife North',
		'NGOSIO' => 'Iwo',
		'NGOSIP' => 'Irepodun',
		'NGOSIR' => 'Irewole',
		'NGOSIS' => 'Ife South',
		'NGOSIW' => 'Ilesha West',
		'NGOSOB' => 'Obokun',
		'NGOSOD' => 'Oriade',
		'NGOSOL' => 'Ola-Oluwa',
		'NGOSON' => 'Olorunda',
		'NGOSOO' => 'Odo-Otin',
		'NGOSOR' => 'Orolu',
		'NGOSOS' => 'Osogbo',
	],
	'OY' => [
		'NGOYAF' => 'Afijio',
		'NGOYAK' => 'Akinyele',
		'NGOYAS' => 'Atisbo',
		'NGOYAT' => 'Atiba',
		'NGOYEG' => 'Egbeda',
		'NGOYIA' => 'Ibarapa East',
		'NGOYIB' => 'Ibadan North',
		'NGOYIC' => 'Ibarapa Central',
		'NGOYID' => 'Ido',
		'NGOYIE' => 'Ibadan South East',
		'NGOYIJ' => 'Iwajowa',
		'NGOYIN' => 'Ibadan North East',
		'NGOYIP' => 'Ibarapa North',
		'NGOYIR' => 'Irepo',
		'NGOYIS' => 'Ibadan South West',
		'NGOYIT' => 'Itesiwaju',
		'NGOYIW' => 'Ibadan North West',
		'NGOYIY' => 'Iseyin',
		'NGOYKA' => 'Kajola',
		'NGOYLA' => 'Lagelu',
		'NGOYOA' => 'Ona-Ara',
		'NGOYOE' => 'Oyo East',
		'NGOYOI' => 'Ori Ire',
		'NGOYOL' => 'Olorunsogo',
		'NGOYON' => 'Ogbomosho North',
		'NGOYOO' => 'Ogo Oluwa',
		'NGOYOR' => 'Orelope',
		'NGOYOS' => 'Ogbmosho South',
		'NGOYOW' => 'Oyo West',
		'NGOYOY' => 'Oluyole',
		'NGOYSE' => 'Saki East',
		'NGOYSU' => 'Surulere',
		'NGOYSW' => 'Saki West',
	],
	'PL' => [
		'NGPLBA' => 'Bassa',
		'NGPLBL' => 'Barkin Ladi',
		'NGPLBO' => 'Bokkos',
		'NGPLJE' => 'Jos East',
		'NGPLJN' => 'Jos North',
		'NGPLJS' => 'Jos South',
		'NGPLKK' => 'Kanke',
		'NGPLKM' => 'Kanam',
		'NGPLLN' => 'Langtang North',
		'NGPLLS' => 'Langtang South',
		'NGPLMA' => 'Mangu',
		'NGPLMI' => 'Mikang',
		'NGPLPA' => 'Pankshin',
		'NGPLQP' => 'Qua’an Pan',
		'NGPLRI' => 'Riyom',
		'NGPLSH' => 'Shendam',
		'NGPLWA' => 'Wase',
	],
	'RI' => [
		'NGRIAE' => 'Ahoada East',
		'NGRIAN' => 'Andoni',
		'NGRIAO' => 'Abua/Odual',
		'NGRIAT' => 'Asari-Toru',
		'NGRIAU' => 'Akuku Toru',
		'NGRIAW' => 'Ahoada West',
		'NGRIBO' => 'Bonny',
		'NGRIDE' => 'Degema',
		'NGRIEL' => 'Eleme',
		'NGRIEM' => 'Emuoha',
		'NGRIET' => 'Etche',
		'NGRIGO' => 'Gokana',
		'NGRIIK' => 'Ikwerre',
		'NGRIKH' => 'Khana',
		'NGRIOA' => 'Obio/Akpor',
		'NGRIOB' => 'Ogu/Bolo',
		'NGRIOE' => 'Ogba/Egbema/Ndoni',
		'NGRIOK' => 'Okrika',
		'NGRIOM' => 'Omumma',
		'NGRION' => 'Opobo/Nkoro',
		'NGRIOY' => 'Oyigbo',
		'NGRIPH' => 'Port-Harcourt',
		'NGRITA' => 'Tai',
	],
	'SO' => [
		'NGSOBI' => 'Binji',
		'NGSOBO' => 'Bodinga',
		'NGSODS' => 'Dange-Shuni',
		'NGSOGA' => 'Gada',
		'NGSOGO' => 'Goronyo',
		'NGSOGU' => 'Gudu',
		'NGSOGW' => 'Gwadabawa',
		'NGSOIL' => 'Illela',
		'NGSOIS' => 'Isa',
		'NGSOKE' => 'Kebbe',
		'NGSOKW' => 'Kware',
		'NGSORA' => 'Rabah',
		'NGSOSB' => 'Sabon Birni',
		'NGSOSH' => 'Shagari',
		'NGSOSI' => 'Silame',
		'NGSOSN' => 'Sokoto North',
		'NGSOSS' => 'Sokoto South',
		'NGSOTT' => 'Tureta',
		'NGSOTW' => 'Tambuwal',
		'NGSOTZ' => 'Tangaza',
		'NGSOWA' => 'Wamako',
		'NGSOWU' => 'Wurno',
		'NGSOYA' => 'Yabo',
	],
	'TA' => [
		'NGTAAK' => 'Ardo-Kola',
		'NGTABA' => 'Bali',
		'NGTADA' => 'Disputed Areas',
		'NGTADO' => 'Donga',
		'NGTAGK' => 'Gashaka',
		'NGTAGS' => 'Gassol',
		'NGTAIB' => 'Ibi',
		'NGTAJA' => 'Jalingo',
		'NGTAKL' => 'Karim-Lamido',
		'NGTAKU' => 'Kurmi',
		'NGTALA' => 'Lau',
		'NGTASA' => 'Sardauna',
		'NGTATA' => 'Takum',
		'NGTAUS' => 'Ussa',
		'NGTAWU' => 'Wukari',
		'NGTAYO' => 'Yorro',
		'NGTAZI' => 'Zing',
	],
	'YO' => [
		'NGYOBA' => 'Barde',
		'NGYOBO' => 'Bursari',
		'NGYODA' => 'Damaturu',
		'NGYOFI' => 'Fika',
		'NGYOFU' => 'Fune',
		'NGYOGE' => 'Geidam',
		'NGYOGJ' => 'Gujba',
		'NGYOGL' => 'Gulani',
		'NGYOJA' => 'Jakusko',
		'NGYOKA' => 'Karasuwa',
		'NGYOMA' => 'Machina',
		'NGYONA' => 'Nangere',
		'NGYONG' => 'Nguru',
		'NGYOPO' => 'Potiskum',
		'NGYOTA' => 'Tarmua',
		'NGYOYF' => 'Yusufari',
		'NGYOYN' => 'Yunusari',
	],
	'ZA' => [
		'NGZAAN' => 'Anka',
		'NGZABA' => 'Bakura',
		'NGZABD' => 'Bungudu',
		'NGZABM' => 'Birnin Magaji/Kiyaw',
		'NGZABY' => 'Bukkuyum',
		'NGZAGM' => 'Gummi',
		'NGZAGS' => 'Gusau',
		'NGZAKN' => 'Kauran Namoda',
		'NGZAMD' => 'Maradun',
		'NGZAMU' => 'Maru',
		'NGZASH' => 'Shinkafi',
		'NGZATM' => 'Talata Mafara',
		'NGZATS' => 'Tsafe',
		'NGZAZU' => 'Zurmi',
	],
];
