<?php

/**
 * List of cities for: Moldova
 * Source: https://date.gov.md/ckan/en/dataset/5192-clasificatorul-unitatilor-administrativ-teritoriale-cuatm/resource/23854810-8c4b-4866-8a0e-5e53813f726d
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'MD100' => 'MUN.CHISINAU',
	'MD110' => 'SEC.BOTANICA',
	'MD111' => 'OR.SINGERA',
	'MD112' => 'DOBROGEA',
	'MD113' => 'REVACA',
	'MD5511' => 'BACIOI',
	'MD5514' => 'BRAILA',
	'MD5512' => 'FRUMUSICA',
	'MD5513' => 'STRAISTENI',
	'MD120' => 'SEC.BUIUCANI',
	'MD121' => 'OR.DURLESTI',
	'MD122' => 'OR.VATRA',
	'MD123' => 'CONDRITA',
	'MD124' => 'GHIDIGHICI',
	'MD8039' => 'TRUSENI',
	'MD125' => 'DUMBRAVA',
	'MD130' => 'SEC.CENTRU',
	'MD131' => 'OR.CODRU',
	'MD140' => 'SEC.CIOCANA',
	'MD141' => 'OR.VADUL LUI VODA',
	'MD3121' => 'VADULENI',
	'MD142' => 'BUBUIECI',
	'MD143' => 'BIC',
	'MD1033' => 'HUMULESTI',
	'MD3120' => 'BUDESTI',
	'MD149' => 'COLONITA',
	'MD144' => 'CRUZESTI',
	'MD145' => 'CEROBORTA',
	'MD146' => 'TOHATIN',
	'MD147' => 'BUNETI',
	'MD148' => 'CHELTUITORI',
	'MD150' => 'SEC.RISCANI',
	'MD151' => 'OR.CRICOVA',
	'MD152' => 'CIORESCU',
	'MD153' => 'FAURESTI',
	'MD154' => 'GOIAN',
	'MD155' => 'GRATIESTI',
	'MD156' => 'HULBOACA',
	'MD3153' => 'STAUCENI',
	'MD3154' => 'GOIANUL NOU',
	'MD300' => 'MUN.BALTI',
	'MD301' => 'ELIZAVETA',
	'MD4839' => 'SADOVOE',
	'MD500' => 'MUN.BENDER',
	'MD501' => 'PROTEAGAILOVCA',
	'MD1000' => 'R-UL ANENII NOI',
	'MD1001' => 'OR.ANENII NOI',
	'MD1040' => 'ALBINITA',
	'MD1010' => 'BERIOZCHI',
	'MD1011' => 'HIRBOVATUL NOU',
	'MD1039' => 'RUSENI',
	'MD1022' => 'SOCOLENI',
	'MD1012' => 'BOTNARESTI',
	'MD1013' => 'SALCIA',
	'MD1014' => 'BULBOACA',
	'MD1015' => 'CALFA',
	'MD1016' => 'CALFA NOUA',
	'MD1017' => 'CHETROSU',
	'MD1046' => 'TODIRESTI',
	'MD1018' => 'CHIRCA',
	'MD1019' => 'BOTNARESTII NOI',
	'MD1020' => 'CIOBANOVCA',
	'MD1048' => 'BALMAZ',
	'MD1049' => 'MIRNOE',
	'MD1047' => 'TROITA NOUA',
	'MD1021' => 'COBUSCA NOUA',
	'MD1023' => 'COBUSCA VECHE',
	'MD1024' => 'FLORESTI',
	'MD1026' => 'DELACAU',
	'MD1027' => 'FLORENI',
	'MD1028' => 'GEAMANA',
	'MD1029' => 'BATIC',
	'MD1030' => 'GURA BICULUI',
	'MD1031' => 'HIRBOVAT',
	'MD1032' => 'MAXIMOVCA',
	'MD1034' => 'MERENI',
	'MD1036' => 'MERENII NOI',
	'MD2328' => 'OCHIUL ROS',
	'MD2329' => 'PICUS',
	'MD1037' => 'PUHACENI',
	'MD1038' => 'ROSCANI',
	'MD1041' => 'SPEIA',
	'MD1042' => 'SERPENI',
	'MD1043' => 'TELITA',
	'MD1044' => 'TELITA NOUA',
	'MD1050' => 'TINTARENI',
	'MD1025' => 'CRETOAIA',
	'MD502' => 'VARNITA',
	'MD2338' => 'ZOLOTIEVCA',
	'MD2339' => 'LARGA',
	'MD2340' => 'NICOLAEVCA',
	'MD1200' => 'R-UL BASARABEASCA',
	'MD1201' => 'OR.BASARABEASCA',
	'MD1210' => 'ABACLIA',
	'MD1211' => 'BASCALIA',
	'MD1212' => 'CARABETOVCA',
	'MD1213' => 'IORDANOVCA',
	'MD1214' => 'ISERLIA',
	'MD1215' => 'BOGDANOVCA',
	'MD1216' => 'CARABIBER',
	'MD1217' => 'IVANOVCA',
	'MD1218' => 'SADACLIA',
	'MD1400' => 'R-UL BRICENI',
	'MD1401' => 'OR.BRICENI',
	'MD1402' => 'OR.LIPCANI',
	'MD1410' => 'BALASINESTI',
	'MD1427' => 'BELEAVINTI',
	'MD1411' => 'BALCAUTI',
	'MD1412' => 'BOCICAUTI',
	'MD1413' => 'BERLINTI',
	'MD1418' => 'CARACUSENII NOI',
	'MD1414' => 'BOGDANESTI',
	'MD1415' => 'BEZEDA',
	'MD1416' => 'GRIMESTI',
	'MD1417' => 'BULBOACA',
	'MD1419' => 'CARACUSENII VECHI',
	'MD1420' => 'COLICAUTI',
	'MD1421' => 'TRESTIENI',
	'MD1422' => 'CORJEUTI',
	'MD1423' => 'COTEALA',
	'MD1424' => 'COTIUJENI',
	'MD1425' => 'CRIVA',
	'MD1426' => 'DREPCAUTI',
	'MD1428' => 'GRIMANCAUTI',
	'MD1429' => 'HALAHORA DE SUS',
	'MD1430' => 'CHIRILOVCA',
	'MD1431' => 'HALAHORA DE JOS',
	'MD1432' => 'HLINA',
	'MD1433' => 'LARGA',
	'MD1434' => 'PAVLOVCA',
	'MD1435' => 'MARCAUTI',
	'MD1436' => 'MARCAUTII NOI',
	'MD1437' => 'MEDVEJA',
	'MD1438' => 'SLOBOZIA-MEDVEJA',
	'MD1439' => 'MIHAILENI',
	'MD1440' => 'GROZNITA',
	'MD1441' => 'PERERITA',
	'MD1443' => 'SLOBOZIA-SIRAUTI',
	'MD1442' => 'SIRAUTI',
	'MD1444' => 'TABANI',
	'MD1445' => 'TETCANI',
	'MD1446' => 'TREBISAUTI',
	'MD1700' => 'R-UL CAHUL',
	'MD1701' => 'MUN.CAHUL',
	'MD1719' => 'COTIHANA',
	'MD9414' => 'ALEXANDERFELD',
	'MD9410' => 'ALEXANDRU IOAN CUZA',
	'MD1710' => 'ANDRUSUL DE JOS',
	'MD1711' => 'ANDRUSUL DE SUS',
	'MD1712' => 'BADICUL MOLDOVENESC',
	'MD1713' => 'BAURCI-MOLDOVENI',
	'MD8718' => 'BORCEAG',
	'MD9411' => 'BRINZA',
	'MD1714' => 'BUCURIA',
	'MD1716' => 'BURLACU',
	'MD1717' => 'SPICOASA',
	'MD9412' => 'BURLACENI',
	'MD9413' => 'GRECENI',
	'MD1718' => 'CHIOSELIA MARE',
	'MD1723' => 'FRUMUSICA',
	'MD9415' => 'CISLITA-PRUT',
	'MD9416' => 'COLIBASI',
	'MD1720' => 'CRIHANA VECHE',
	'MD1721' => 'CUCOARA',
	'MD1722' => 'CHIRCANI',
	'MD2130' => 'DOINA',
	'MD2131' => 'IASNAIA POLEANA',
	'MD2150' => 'RUMEANTEV',
	'MD9417' => 'GAVANOASA',
	'MD9418' => 'NICOLAEVCA',
	'MD9419' => 'VLADIMIROVCA',
	'MD9420' => 'GIURGIULESTI',
	'MD1724' => 'HULUBOAIA',
	'MD9421' => 'IUJNOE',
	'MD1725' => 'LARGA NOUA',
	'MD1726' => 'LARGA VECHE',
	'MD1727' => 'LEBEDENCO',
	'MD1728' => 'HUTULU',
	'MD1729' => 'URSOAIA',
	'MD1730' => 'LOPATICA',
	'MD1731' => 'LUCESTI',
	'MD1732' => 'MANTA',
	'MD1733' => 'PASCANI',
	'MD1734' => 'MOSCOVEI',
	'MD1735' => 'TRIFESTII NOI',
	'MD1736' => 'PELINEI',
	'MD1737' => 'SATUC',
	'MD1738' => 'ROSU',
	'MD9422' => 'SLOBOZIA MARE',
	'MD1739' => 'TARACLIA DE SALCIE',
	'MD1740' => 'TARTAUL DE SALCIE',
	'MD1715' => 'TUDORESTI',
	'MD1741' => 'TATARESTI',
	'MD9423' => 'VADUL LUI ISAC',
	'MD9424' => 'VALENI',
	'MD1742' => 'ZIRNESTI',
	'MD1743' => 'PAICU',
	'MD1744' => 'TRETESTI',
	'MD2100' => 'R-UL CANTEMIR',
	'MD2101' => 'OR.CANTEMIR',
	'MD2110' => 'ANTONESTI',
	'MD2111' => 'LECA',
	'MD2112' => 'BAIMACLIA',
	'MD2113' => 'ACUI',
	'MD2126' => 'SUHAT',
	'MD2114' => 'CANIA',
	'MD2115' => 'IEPURENI',
	'MD2116' => 'CAPACLIA',
	'MD2117' => 'CHIOSELIA',
	'MD2118' => 'TARANCUTA',
	'MD2119' => 'CIOBALACCIA',
	'MD2120' => 'FLOCOASA',
	'MD2121' => 'VICTOROVCA',
	'MD2122' => 'CIIETU',
	'MD2123' => 'DIMITROVA',
	'MD2124' => 'CIRPESTI',
	'MD2125' => 'CISLA',
	'MD2127' => 'SOFRANOVCA',
	'MD2128' => 'COCIULIA',
	'MD2129' => 'COSTANGALIA',
	'MD2132' => 'ENICHIOI',
	'MD2133' => 'BOBOCICA',
	'MD2134' => 'FLORICICA',
	'MD2135' => 'TOLICA',
	'MD2136' => 'GOTESTI',
	'MD2151' => 'CONSTANTINESTI',
	'MD2137' => 'HARAGIS',
	'MD2138' => 'LARGUTA',
	'MD2139' => 'LINGURA',
	'MD2140' => 'CRACIUN',
	'MD2141' => 'POPOVCA',
	'MD2142' => 'PLESENI',
	'MD2143' => 'HANASENI',
	'MD2144' => 'TATARASENI',
	'MD2145' => 'PLOPI',
	'MD2146' => 'ALEXANDROVCA',
	'MD2147' => 'HIRTOP',
	'MD2148' => 'TARACLIA',
	'MD2149' => 'PORUMBESTI',
	'MD2152' => 'SADIC',
	'MD2153' => 'TARACLIA',
	'MD2154' => 'STOIANOVCA',
	'MD2155' => 'SAMALIA',
	'MD2156' => 'TARTAUL',
	'MD2157' => 'TOCENI',
	'MD2162' => 'VILCELE',
	'MD2158' => 'TIGANCA',
	'MD2159' => 'GHIOLTOSU',
	'MD2160' => 'TIGANCA NOUA',
	'MD2161' => 'VISNIOVCA',
	'MD2500' => 'R-UL CALARASI',
	'MD2501' => 'OR.CALARASI',
	'MD2510' => 'ORICOVA',
	'MD2511' => 'BAHMUT',
	'MD2552' => 'BAHMUT LOC.C.F.',
	'MD2513' => 'BRAVICEA',
	'MD2514' => 'BUDA',
	'MD2515' => 'URSARI',
	'MD2516' => 'CABAIESTI',
	'MD2517' => 'DERENEU',
	'MD2518' => 'BULARDA',
	'MD2519' => 'DUMA',
	'MD2520' => 'FRUMOASA',
	'MD2521' => 'HIROVA',
	'MD2522' => 'HIRJAUCA',
	'MD2523' => 'LEORDOAIA',
	'MD2524' => 'MINDRA',
	'MD2525' => 'PALANCA',
	'MD2526' => 'HOGINESTI',
	'MD2527' => 'HORODISTE',
	'MD2528' => 'MELESENI',
	'MD2529' => 'NISCANI',
	'MD2530' => 'ONISCANI',
	'MD2531' => 'HIRBOVAT',
	'MD2532' => 'SVERIDA',
	'MD2533' => 'PAULESTI',
	'MD2534' => 'PITUSCA',
	'MD2535' => 'PIRJOLTENI',
	'MD2536' => 'RACIULA',
	'MD2537' => 'PARCANI',
	'MD2538' => 'RADENI',
	'MD2539' => 'SADOVA',
	'MD2540' => 'SASENI',
	'MD2512' => 'BAHU',
	'MD2541' => 'SIPOTENI',
	'MD2542' => 'PODUL LUNG',
	'MD2543' => 'TEMELEUTI',
	'MD2544' => 'TUZARA',
	'MD2545' => 'NOVACI',
	'MD2547' => 'SELISTEA NOUA',
	'MD2546' => 'PETICENI',
	'MD2548' => 'TIBIRICA',
	'MD2553' => 'SCHINOASA',
	'MD2549' => 'VALCINET',
	'MD2550' => 'VARZARESTII NOI',
	'MD2700' => 'R-UL CAUSENI',
	'MD2701' => 'OR.CAUSENI',
	'MD2301' => 'OR.CAINARI',
	'MD2341' => 'CAINARI LOC.C.F.',
	'MD2710' => 'BACCEALIA',
	'MD2711' => 'TRICOLICI',
	'MD2333' => 'FLORICA',
	'MD2332' => 'PLOP',
	'MD2310' => 'BAIMACLIA',
	'MD2311' => 'SURCHICENI',
	'MD2712' => 'CHIRCAIESTI',
	'MD2314' => 'CHIRCAIESTII NOI',
	'MD2315' => 'BAURCI',
	'MD7612' => 'CHITCANI',
	'MD7613' => 'MERENESTI',
	'MD7614' => 'ZAHORNA',
	'MD2317' => 'CIUFLESTI',
	'MD2713' => 'CIRNATENI',
	'MD2318' => 'CIRNATENII NOI',
	'MD2319' => 'SALCUTA NOUA',
	'MD7616' => 'COPANCA',
	'MD2323' => 'COSCALIA',
	'MD703' => 'CREMENCIUG',
	'MD2714' => 'FIRLADENI',
	'MD2724' => 'FIRLADENII NOI',
	'MD2715' => 'GISCA',
	'MD8521' => 'GRADINITA',
	'MD8522' => 'LEUNTEA',
	'MD8523' => 'VALEA VERDE',
	'MD2716' => 'GRIGORIEVCA',
	'MD2717' => 'HAGIMUS',
	'MD2718' => 'OPACI',
	'MD2330' => 'PERVOMAISC',
	'MD2331' => 'CONSTANTINOVCA',
	'MD2719' => 'PLOPI-STIUBEI',
	'MD2720' => 'SAITI',
	'MD2721' => 'SALCUTA',
	'MD2336' => 'TARACLIA',
	'MD2722' => 'TANATARI',
	'MD2723' => 'TANATARII NOI',
	'MD2725' => 'STEFANESTI',
	'MD2726' => 'URSOAIA NOUA',
	'MD2727' => 'TOCUZ',
	'MD2728' => 'UCRAINCA',
	'MD2729' => 'ZVIOZDOCICA',
	'MD2730' => 'URSOAIA',
	'MD2731' => 'ZAIM',
	'MD2732' => 'MARIANCA DE SUS',
	'MD2733' => 'ZAIM LOC.C.F.',
	'MD2900' => 'R-UL CIMISLIA',
	'MD2901' => 'OR.CIMISLIA',
	'MD2912' => 'BOGDANOVCA NOUA',
	'MD2913' => 'BOGDANOVCA VECHE',
	'MD2941' => 'DIMITROVCA',
	'MD2910' => 'ALBINA',
	'MD2911' => 'FETITA',
	'MD2934' => 'MERENI',
	'MD2312' => 'BATIR',
	'MD2914' => 'CENAC',
	'MD2915' => 'CIUCUR-MINGIR',
	'MD2320' => 'CODRENI',
	'MD2322' => 'ZLOTI LOC.ST.CF.',
	'MD2917' => 'ECATERINOVCA',
	'MD2916' => 'COSTANGALIA',
	'MD2918' => 'GRADISTE',
	'MD2925' => 'IURIEVCA',
	'MD2919' => 'GURA GALBENEI',
	'MD2920' => 'HIRTOP',
	'MD2921' => 'IALPUG',
	'MD2922' => 'PRISACA',
	'MD2923' => 'IALPUGENI',
	'MD2924' => 'MARIENFELD',
	'MD2927' => 'IVANOVCA NOUA',
	'MD2928' => 'JAVGUR',
	'MD2929' => 'ARTIMONOVCA',
	'MD2930' => 'MAXIMENI',
	'MD2931' => 'LIPOVENI',
	'MD2932' => 'MUNTENI',
	'MD2933' => 'SCHINOSICA',
	'MD2935' => 'MIHAILOVCA',
	'MD2926' => 'PORUMBREI',
	'MD2321' => 'SAGAIDACUL NOU',
	'MD2936' => 'SAGAIDAC',
	'MD2937' => 'SATUL NOU',
	'MD2938' => 'SELEMET',
	'MD2939' => 'SURIC',
	'MD2940' => 'TOPALA',
	'MD1219' => 'TROITCOE',
	'MD2942' => 'VALEA PERJEI',
	'MD3100' => 'R-UL CRIULENI',
	'MD3101' => 'OR.CRIULENI',
	'MD3145' => 'OHRINCEA',
	'MD3110' => 'ZOLONCENI',
	'MD3111' => 'BALABANESTI',
	'MD3112' => 'MALAIESTI',
	'MD3113' => 'MALAIESTII NOI',
	'MD3114' => 'BALTATA',
	'MD3115' => 'BALTATA DE SUS',
	'MD3116' => 'SAGAIDAC',
	'MD3117' => 'SAGAIDACUL DE SUS',
	'MD3118' => 'BOSCANA',
	'MD3119' => 'MARDAREUCA',
	'MD3122' => 'CIMISENI',
	'MD3123' => 'CORJOVA',
	'MD3124' => 'COSERNITA',
	'MD3125' => 'CRUGLIC',
	'MD3126' => 'DOLINNOE',
	'MD3127' => 'VALEA COLONITEI',
	'MD3128' => 'VALEA SATULUI',
	'MD3129' => 'DRASLICENI',
	'MD3130' => 'LOGANESTI',
	'MD3132' => 'RATUS',
	'MD3133' => 'DUBASARII VECHI',
	'MD3134' => 'HIRTOPUL MARE',
	'MD3135' => 'HIRTOPUL MIC',
	'MD3136' => 'HRUSOVA',
	'MD3137' => 'CHETROASA',
	'MD3138' => 'CIOPLENI',
	'MD3139' => 'ISNOVAT',
	'MD3140' => 'IZBISTE',
	'MD3141' => 'JEVRENI',
	'MD3142' => 'MASCAUTI',
	'MD3131' => 'MAGDACESTI',
	'MD3143' => 'MICLESTI',
	'MD3144' => 'STETCANI',
	'MD3146' => 'ONITCANI',
	'MD3147' => 'PASCANI',
	'MD3148' => 'PORUMBENI',
	'MD3149' => 'RACULESTI',
	'MD3150' => 'BALASESTI',
	'MD3151' => 'RISCOVA',
	'MD3152' => 'SLOBOZIA-DUSCA',
	'MD3155' => 'ZAICANA',
	'MD3400' => 'R-UL DONDUSENI',
	'MD3401' => 'OR.DONDUSENI',
	'MD3410' => 'ARIONESTI',
	'MD3411' => 'BARABOI',
	'MD3412' => 'BRICENI',
	'MD3413' => 'CERNOLEUCA',
	'MD3414' => 'CLIMAUTI',
	'MD3415' => 'CORBU',
	'MD3416' => 'CRISCAUTI',
	'MD3417' => 'DONDUSENI',
	'MD3418' => 'ELIZAVETOVCA',
	'MD3419' => 'BOROSENI',
	'MD3422' => 'FRASIN',
	'MD3423' => 'CARAIMAN',
	'MD3424' => 'CODRENII NOI',
	'MD3425' => 'HORODISTE',
	'MD3428' => 'MOSANA',
	'MD3429' => 'OCTEABRISCOE',
	'MD3432' => 'PIVNICENI',
	'MD3433' => 'PLOP',
	'MD3434' => 'POCROVCA',
	'MD3435' => 'REDIUL MARE',
	'MD3437' => 'SCAIENI',
	'MD3438' => 'SUDARCA',
	'MD3439' => 'BRAICAU',
	'MD3444' => 'TELESEUCA',
	'MD3445' => 'TELESEUCA NOUA',
	'MD3446' => 'TIRNOVA',
	'MD3447' => 'BRICEVA',
	'MD3448' => 'ELENOVCA',
	'MD3449' => 'TAUL',
	'MD3600' => 'R-UL DROCHIA',
	'MD3601' => 'OR.DROCHIA',
	'MD3610' => 'ANTONEUCA',
	'MD3612' => 'BARONCEA',
	'MD3613' => 'BARONCEA NOUA',
	'MD3614' => 'CHETROSU',
	'MD3615' => 'COTOVA',
	'MD3616' => 'MACAREUCA',
	'MD3617' => 'DOMINTENI',
	'MD3618' => 'DROCHIA',
	'MD3619' => 'GRIBOVA',
	'MD3420' => 'FINTINITA',
	'MD3421' => 'GHIZDITA LOC.C.F.',
	'MD3620' => 'HASNASENII MARI',
	'MD3621' => 'HASNASENII NOI',
	'MD3622' => 'LAZO',
	'MD3426' => 'MARAMONOVCA',
	'MD3623' => 'MICIURIN',
	'MD3427' => 'MINDIC',
	'MD3624' => 'MOARA DE PIATRA',
	'MD3625' => 'NICORENI',
	'MD3626' => 'OCHIUL ALB',
	'MD3627' => 'PALANCA',
	'MD3628' => 'HOLOSNITA NOUA',
	'MD3629' => 'SALVIRII NOI',
	'MD7135' => 'PELINIA',
	'MD7165' => 'PELINIA LOC.C.F.',
	'MD3630' => 'PERVOMAISCOE',
	'MD3611' => 'SERGHEUCA',
	'MD3631' => 'PETRENI',
	'MD3632' => 'POPESTII NOI',
	'MD3633' => 'POPESTII DE JOS',
	'MD3634' => 'POPESTII DE SUS',
	'MD3635' => 'SOFIA',
	'MD3636' => 'SALVIRII VECHI',
	'MD3637' => 'CEAPAEVCA',
	'MD3638' => 'ILICIOVCA',
	'MD3639' => 'SURI',
	'MD3640' => 'SURII NOI',
	'MD3641' => 'TARIGRAD',
	'MD3642' => 'ZGURITA',
	'MD3800' => 'R-UL DUBASARI',
	'MD3810' => 'COCIERI',
	'MD3811' => 'VASILIEVCA',
	'MD3816' => 'CORJOVA',
	'MD3817' => 'MAHALA',
	'MD3818' => 'COSNITA',
	'MD3819' => 'POHREBEA',
	'MD3828' => 'DOROTCAIA',
	'MD3835' => 'HOLERCANI',
	'MD3837' => 'MARCAUTI',
	'MD3838' => 'MOLOVATA',
	'MD3839' => 'MOLOVATA NOUA',
	'MD3840' => 'ROGHI',
	'MD3841' => 'OXENTEA',
	'MD3842' => 'PIRITA',
	'MD3844' => 'USTIA',
	'MD4100' => 'R-UL EDINET',
	'MD4101' => 'MUN.EDINET',
	'MD4111' => 'ALEXANDRENI',
	'MD4136' => 'GORDINESTII NOI',
	'MD4102' => 'OR.CUPCINI',
	'MD4110' => 'CHETROSICA VECHE',
	'MD4123' => 'CHIURT',
	'MD4153' => 'ALEXEEVCA',
	'MD4117' => 'BADRAGII NOI',
	'MD4118' => 'BADRAGII VECHI',
	'MD4112' => 'BLESTENI',
	'MD4113' => 'VOLODENI',
	'MD4114' => 'BRATUSENI',
	'MD4115' => 'BRATUSENII NOI',
	'MD4116' => 'BRINZENI',
	'MD4120' => 'BURLANESTI',
	'MD4121' => 'BUZDUGENI',
	'MD6216' => 'CEPELEUTI',
	'MD6217' => 'RINGACI',
	'MD6218' => 'VANCICAUTI',
	'MD4122' => 'CHETROSICA NOUA',
	'MD4149' => 'CONSTANTINOVCA',
	'MD4150' => 'IACHIMENI',
	'MD4124' => 'CORPACI',
	'MD4125' => 'CUCONESTII NOI',
	'MD4126' => 'CUCONESTII VECHI',
	'MD4127' => 'FETESTI',
	'MD4128' => 'GASPAR',
	'MD4129' => 'GOLENI',
	'MD4130' => 'GORDINESTI',
	'MD4131' => 'HANCAUTI',
	'MD4132' => 'HINCAUTI',
	'MD4133' => 'CLISCAUTI',
	'MD4134' => 'POIANA',
	'MD4135' => 'HLINAIA',
	'MD4137' => 'LOPATNIC',
	'MD4138' => 'PARCOVA',
	'MD4139' => 'FINTINA ALBA',
	'MD4140' => 'ROTUNDA',
	'MD4141' => 'HLINAIA MICA',
	'MD4142' => 'RUSENI',
	'MD4143' => 'SLOBODCA',
	'MD4144' => 'STOLNICENI',
	'MD4145' => 'SOFRINCANI',
	'MD4146' => 'TEREBNA',
	'MD4147' => 'TIRNOVA',
	'MD4148' => 'TRINCA',
	'MD4151' => 'VIISOARA',
	'MD4152' => 'ZABRICENI',
	'MD4154' => 'ONESTI',
	'MD4300' => 'R-UL FALESTI',
	'MD4301' => 'OR.FALESTI',
	'MD4384' => 'FABRICA DE ZAHAR',
	'MD4310' => 'ALBINETUL VECHI',
	'MD4311' => 'ALBINETUL NOU',
	'MD4312' => 'REDIUL DE JOS',
	'MD4313' => 'REDIUL DE SUS',
	'MD4314' => 'BOCANI',
	'MD4341' => 'CATRANIC',
	'MD4315' => 'CALINESTI',
	'MD4319' => 'CALUGAR',
	'MD4320' => 'FRUMUSICA',
	'MD4321' => 'SOCII NOI',
	'MD4322' => 'SOCII VECHI',
	'MD4316' => 'CHETRIS',
	'MD4317' => 'CHETRISUL NOU',
	'MD4323' => 'CIOLACU NOU',
	'MD4324' => 'CIOLACU VECHI',
	'MD4325' => 'FAGADAU',
	'MD4326' => 'POCROVCA',
	'MD4327' => 'SOLTОAIA',
	'MD4328' => 'EGOROVCA',
	'MD4383' => 'CATRANIC LOC.ST.C.F.',
	'MD4329' => 'CIULUC',
	'MD4330' => 'FALESTII NOI',
	'MD4331' => 'PIETROSUL NOU',
	'MD4332' => 'GLINJENI',
	'MD4333' => 'HILIUTI',
	'MD4334' => 'RAUTELUL NOU',
	'MD4318' => 'HINCESTI',
	'MD4335' => 'HORESTI',
	'MD4336' => 'LUCACENI',
	'MD4337' => 'UNTENI',
	'MD4338' => 'ILENUTA',
	'MD4339' => 'ISCALAU',
	'MD4340' => 'BURGHELEA',
	'MD4342' => 'DOLTU',
	'MD4343' => 'IZVOARE',
	'MD4344' => 'LOGOFTENI',
	'MD4360' => 'MOLDOVEANCA',
	'MD4345' => 'MARANDENI',
	'MD4346' => 'MUSTEATA',
	'MD4347' => 'NATALIEVCA',
	'MD4348' => 'BELEUTI',
	'MD4349' => 'COMAROVCA',
	'MD4350' => 'IVANOVCA',
	'MD4351' => 'POPOVCA',
	'MD4352' => 'TAPOC',
	'MD4353' => 'NAVIRNET',
	'MD4354' => 'OBREJA VECHE',
	'MD4355' => 'OBREJA NOUA',
	'MD4356' => 'PIETROSU',
	'MD4357' => 'MAGURA',
	'MD4358' => 'MAGURA NOUA',
	'MD4359' => 'PINZARENI',
	'MD4361' => 'PINZARENII NOI',
	'MD4362' => 'PIRLITA',
	'MD4363' => 'POMPA',
	'MD4364' => 'PERVOMAISC',
	'MD4365' => 'SUVOROVCA',
	'MD4366' => 'PRUTENI',
	'MD4367' => 'CUZMENII VECHI',
	'MD4368' => 'DRUJINENI',
	'MD4369' => 'VALEA RUSULUI',
	'MD4370' => 'RAUTEL',
	'MD4371' => 'RISIPENI',
	'MD4372' => 'BOCSA',
	'MD4373' => 'SARATA VECHE',
	'MD4374' => 'HITRESTI',
	'MD4375' => 'SARATA NOUA',
	'MD4376' => 'SCUMPIA',
	'MD4377' => 'HIRTOP',
	'MD4378' => 'MAGUREANCA',
	'MD4379' => 'NICOLAEVCA',
	'MD4380' => 'TAXOBENI',
	'MD4381' => 'HRUBNA NOUA',
	'MD4382' => 'S VRANESTI',
	'MD4500' => 'R-UL FLORESTI',
	'MD4501' => 'OR.FLORESTI',
	'MD4502' => 'OR.GHINDESTI',
	'MD4503' => 'OR.MARCULESTI',
	'MD4510' => 'ALEXEEVCA',
	'MD4511' => 'CHIRILOVCA',
	'MD4512' => 'DUMITRENI',
	'MD4513' => 'RADULENII NOI',
	'MD4514' => 'BAHRINESTI',
	'MD4515' => 'CASUNCA',
	'MD4516' => 'CERNITA',
	'MD4517' => 'CIRIPCAU',
	'MD4518' => 'CIUTULESTI',
	'MD4519' => 'ION VODA',
	'MD4520' => 'MARINESTI',
	'MD4521' => 'SIRBESTI',
	'MD4522' => 'COSERNITA',
	'MD1916' => 'CUHURESTII DE JOS',
	'MD1917' => 'TIPORDEI',
	'MD1918' => 'CUHURESTII DE SUS',
	'MD1919' => 'NICOLAEVCA',
	'MD1920' => 'UNCHITESTI',
	'MD1951' => 'UNCHITESTI LOC.C.F.',
	'MD1921' => 'CUNICEA',
	'MD4523' => 'DOMULGENI',
	'MD4524' => 'FRUMUSICA',
	'MD4525' => 'FRUMUSICA NOUA',
	'MD4527' => 'GHINDESTI',
	'MD4528' => 'HIRTOP',
	'MD4529' => 'TIRA',
	'MD4563' => 'TIRA LOC.C.F.',
	'MD4530' => 'GURA CAMENCII',
	'MD4531' => 'BOBULESTI',
	'MD4532' => 'GVOZDOVA',
	'MD4533' => 'GURA CAINARULUI',
	'MD4534' => 'ZAROJENI',
	'MD4535' => 'ILICIOVCA',
	'MD4536' => 'MAISCOE',
	'MD4537' => 'IZVOARE',
	'MD4538' => 'BEZENI',
	'MD4539' => 'SCAIENI',
	'MD1927' => 'JAPCA',
	'MD1928' => 'BURSUC',
	'MD4540' => 'LUNGA',
	'MD4541' => 'MARCULESTI',
	'MD1929' => 'NAPADOVA',
	'MD4542' => 'NICOLAEVCA',
	'MD4543' => 'VALEA RADOAIEI',
	'MD4544' => 'PRAJILA',
	'MD4545' => 'ANTONOVCA',
	'MD4546' => 'FRUNZESTI',
	'MD4547' => 'MIHAILOVCA',
	'MD4548' => 'PRODANESTI',
	'MD4549' => 'CAPRESTI',
	'MD4550' => 'PUTINESTI',
	'MD4551' => 'RADULENII VECHI',
	'MD4552' => 'ROSIETICI',
	'MD4553' => 'CENUSA',
	'MD4554' => 'ROSIETICII VECHI',
	'MD1939' => 'SANATAUCA',
	'MD4555' => 'SEVIROVA',
	'MD4556' => 'IVANOVCA',
	'MD4557' => 'STEFANESTI',
	'MD4558' => 'PRODANESTII VECHI',
	'MD1942' => 'TEMELEUTI',
	'MD1943' => 'TIRGUL-VERTIUJENI',
	'MD4559' => 'TRIFANESTI',
	'MD4560' => 'ALEXANDROVCA',
	'MD4561' => 'VARVAREUCA',
	'MD4562' => 'STIRCENI',
	'MD1946' => 'VASCAUTI',
	'MD1947' => 'FAGADAU',
	'MD1948' => 'OCTEABRISCOE',
	'MD1949' => 'VERTIUJENI',
	'MD1950' => 'ZALUCENI',
	'MD4800' => 'R-UL GLODENI',
	'MD4801' => 'OR.GLODENI',
	'MD4810' => 'STIRCEA',
	'MD4811' => 'BALATINA',
	'MD4812' => 'CLOCOCENII VECHI',
	'MD4813' => 'LIPOVAT',
	'MD4814' => 'TOMESTII NOI',
	'MD4815' => 'TOMESTII VECHI',
	'MD4816' => 'CAJBA',
	'MD4817' => 'CAMENCA',
	'MD4818' => 'BRINZENI',
	'MD4819' => 'BUTESTI',
	'MD4820' => 'MOLESTI',
	'MD4821' => 'CIUCIULEA',
	'MD4822' => 'COBANI',
	'MD4823' => 'CUHNESTI',
	'MD4824' => 'BISERICANI',
	'MD4825' => 'COT',
	'MD4844' => 'MOVILENI',
	'MD4826' => 'SERGHIENI',
	'MD4827' => 'DANU',
	'MD4828' => 'CAMENCUTA',
	'MD4829' => 'NICOLAEVCA',
	'MD4830' => 'DUSMANI',
	'MD4831' => 'FUNDURII NOI',
	'MD4832' => 'FUNDURII VECHI',
	'MD4833' => 'HIJDIENI',
	'MD4834' => 'IABLOANA',
	'MD4835' => 'SOROCA',
	'MD4836' => 'LIMBENII NOI',
	'MD4837' => 'LIMBENII VECHI',
	'MD4838' => 'PETRUNEA',
	'MD4840' => 'STURZOVCA',
	'MD4841' => 'USTIA',
	'MD4842' => 'VIISOARA',
	'MD4843' => 'MOARA DOMNEASCA',
	'MD5300' => 'R-UL HINCESTI',
	'MD5301' => 'MUN.HINCESTI',
	'MD5310' => 'BALCEANA',
	'MD5311' => 'BOBEICA',
	'MD5312' => 'DAHNOVICI',
	'MD5313' => 'DRAGUSENI',
	'MD5314' => 'BOGHICENI',
	'MD5315' => 'BOZIENI',
	'MD5316' => 'DUBOVCA',
	'MD5317' => 'BUJOR',
	'MD5318' => 'BUTENI',
	'MD5319' => 'CARACUI',
	'MD5320' => 'CALMATUI',
	'MD5324' => 'CARPINENI',
	'MD5325' => 'HORJESTI',
	'MD6023' => 'CATELENI',
	'MD5326' => 'CIOARA',
	'MD6026' => 'CIUCIULENI',
	'MD5327' => 'COTUL MORII',
	'MD5336' => 'SARATENI',
	'MD5328' => 'CRASNOARMEISCOE',
	'MD5329' => 'TALAIESTI',
	'MD5330' => 'DANCU',
	'MD6031' => 'DRAGUSENII NOI',
	'MD6032' => 'HORODCA',
	'MD5331' => 'FIRLADENI',
	'MD5332' => 'FUNDUL GALBENEI',
	'MD5333' => 'IVANOVCA',
	'MD5334' => 'COSTESTI',
	'MD5335' => 'FRASIN',
	'MD5337' => 'LAPUSNA',
	'MD5338' => 'ANINI',
	'MD5339' => 'RUSCA',
	'MD5340' => 'LEUSENI',
	'MD5341' => 'FETEASCA',
	'MD5342' => 'LOGANESTI',
	'MD5343' => 'MERESENI',
	'MD5344' => 'SARATA-MERESENI',
	'MD5345' => 'MINGIR',
	'MD5346' => 'SEMIONOVCA',
	'MD5347' => 'MIRESTI',
	'MD5348' => 'CHETROSENI',
	'MD5349' => 'NEGREA',
	'MD5350' => 'NEMTENI',
	'MD5351' => 'OBILENI',
	'MD5352' => 'ONESTI',
	'MD5353' => 'STRIMBENI',
	'MD5354' => 'PASCANI',
	'MD5355' => 'PERENI',
	'MD5356' => 'PERVOMAISCOE',
	'MD5357' => 'POGANESTI',
	'MD5358' => 'MARCHET',
	'MD5359' => 'SARATA-GALBENA',
	'MD5360' => 'BRATIANOVCA',
	'MD5321' => 'CARPINEANCA',
	'MD5322' => 'COROLIOVCA',
	'MD5323' => 'VALEA FLORII',
	'MD5361' => 'SECARENI',
	'MD5362' => 'CORNESTI',
	'MD5363' => 'SECARENII NOI',
	'MD5364' => 'SOFIA',
	'MD5365' => 'STOLNICENI',
	'MD5366' => 'SIPOTENI',
	'MD5367' => 'VOINESCU',
	'MD5500' => 'R-UL IALOVENI',
	'MD5501' => 'OR.IALOVENI',
	'MD5510' => 'BARDAR',
	'MD2313' => 'CARBUNA',
	'MD2316' => 'CIGIRLENI',
	'MD5515' => 'COSTESTI',
	'MD2324' => 'GANGURA',
	'MD2325' => 'ALEXANDROVCA',
	'MD2326' => 'HOMUTEANOVCA',
	'MD2327' => 'MISOVCA',
	'MD5516' => 'DANCENI',
	'MD5517' => 'HANSCA',
	'MD5518' => 'HORESTI',
	'MD5519' => 'HORODCA',
	'MD5520' => 'MALCOCI',
	'MD5521' => 'MILESTII MICI',
	'MD5522' => 'PIATRA ALBA',
	'MD5523' => 'MOLESTI',
	'MD5524' => 'NIMORENI',
	'MD5525' => 'POJARENI',
	'MD5526' => 'PUHOI',
	'MD2334' => 'RAZENI',
	'MD2335' => 'MILESTII NOI',
	'MD5527' => 'RUSESTII NOI',
	'MD5528' => 'RUSESTII VECHI',
	'MD5529' => 'SOCITENI',
	'MD5530' => 'SURUCENI',
	'MD5531' => 'TIPALA',
	'MD5532' => 'BALTATI',
	'MD5533' => 'BUDAI',
	'MD5534' => 'ULMU',
	'MD2337' => 'VARATIC',
	'MD5535' => 'VASIENI',
	'MD5536' => 'ZIMBRENI',
	'MD5537' => 'GAURENI',
	'MD5700' => 'R-UL LEOVA',
	'MD5701' => 'OR.LEOVA',
	'MD5702' => 'OR.IARGARA',
	'MD5710' => 'MESENI',
	'MD5711' => 'BAIUS',
	'MD5712' => 'COCIULIA NOUA',
	'MD5713' => 'HIRTOP',
	'MD5714' => 'BESTEMAC',
	'MD5715' => 'PITESTI',
	'MD5716' => 'BOROGANI',
	'MD5717' => 'CAZANGIC',
	'MD5718' => 'FRUMUSICA',
	'MD5719' => 'SELISTE',
	'MD5720' => 'CEADIR',
	'MD5721' => 'CNEAZEVCA',
	'MD5722' => 'CIZLAR',
	'MD5723' => 'COLIBABOVCA',
	'MD5724' => 'COVURLUI',
	'MD5725' => 'CUPCUI',
	'MD5726' => 'FILIPENI',
	'MD5728' => 'HANASENII NOI',
	'MD5729' => 'NICOLAEVCA',
	'MD5730' => 'ORAC',
	'MD5727' => 'ROMANOVCA',
	'MD5731' => 'SARATA NOUA',
	'MD5747' => '. BULGĂRICA',
	'MD5732' => 'SARATA-RAZESI',
	'MD5733' => 'SARATENI',
	'MD5734' => 'VICTORIA',
	'MD5735' => 'SARATICA NOUA',
	'MD5736' => 'CIMPUL DREPT',
	'MD5737' => 'SIRMA',
	'MD5738' => 'TIGHECI',
	'MD5739' => 'CUPORANI',
	'MD5740' => 'TOCHILE-RADUCANI',
	'MD5741' => 'TOMAI',
	'MD5742' => 'TOMAIUL NOU',
	'MD5743' => 'SARATICA VECHE',
	'MD5744' => 'VOZNESENI',
	'MD5745' => 'TROIAN',
	'MD5746' => 'TROITA',
	'MD6000' => 'R-UL NISPORENI',
	'MD6001' => 'OR.NISPORENI',
	'MD6010' => 'BALANESTI',
	'MD6011' => 'GAURENI',
	'MD6012' => 'BALAURESTI',
	'MD6013' => 'BARBOIENI',
	'MD6014' => 'BOLDURESTI',
	'MD6015' => 'BACSENI',
	'MD6016' => 'CHILISOAIA',
	'MD6017' => 'BOLTUN',
	'MD6019' => 'BRATULENI',
	'MD6020' => 'CIRNESTI',
	'MD6021' => 'BURSUC',
	'MD6022' => 'CALIMANESTI',
	'MD6024' => 'CIORESTI',
	'MD6025' => 'VULCANESTI',
	'MD6027' => 'CIUTESTI',
	'MD6028' => 'VALEA NIRNOVEI',
	'MD6029' => 'CRISTESTI',
	'MD6034' => 'GROZESTI',
	'MD6035' => 'IURCENI',
	'MD6036' => 'MIRZOAIA',
	'MD6037' => 'MARINICI',
	'MD6038' => 'HELESTENI',
	'MD6041' => 'MILESTI',
	'MD6042' => 'SELISTE',
	'MD6043' => 'PARUCENI',
	'MD6044' => 'SOLTANESTI',
	'MD6045' => 'SISCANI',
	'MD6033' => 'DROJDIENI',
	'MD6046' => 'ODAIA',
	'MD6047' => 'VALEA-TRESTIENI',
	'MD6048' => 'ISAICANI',
	'MD6049' => 'LUMINITA',
	'MD6050' => 'ODOBESTI',
	'MD6051' => 'SELISTENI',
	'MD6052' => 'VARZARESTI',
	'MD6053' => 'SENDRENI',
	'MD6054' => 'VINATORI',
	'MD6055' => 'ZBEROAIA',
	'MD6200' => 'R-UL OCNITA',
	'MD6201' => 'OR.OCNITA',
	'MD6202' => 'OR.FRUNZA',
	'MD6203' => 'OR.OTACI',
	'MD6210' => 'BIRLADENI',
	'MD6211' => 'PALADEA',
	'MD6212' => 'RUJNITA',
	'MD6213' => 'BIRNOVA',
	'MD6214' => 'CALARASOVCA',
	'MD6215' => 'BEREZOVCA',
	'MD6219' => 'CLOCUSNA',
	'MD6220' => 'CORESTAUTI',
	'MD6221' => 'STALINESTI',
	'MD6222' => 'DINGENI',
	'MD6223' => 'GRINAUTI',
	'MD6224' => 'GIRBOVA',
	'MD6226' => 'GRINAUTI-MOLDOVA',
	'MD6225' => 'GRINAUTI-RAIA',
	'MD6227' => 'REDIUL MARE',
	'MD6228' => 'HADARAUTI',
	'MD6229' => 'LENCAUTI',
	'MD6230' => 'VEREJENI',
	'MD6231' => 'LIPNIC',
	'MD6232' => 'PAUSTOVA',
	'MD6233' => 'MERESEUCA',
	'MD6234' => 'MIHALASENI',
	'MD6235' => 'GRINAUTI',
	'MD6236' => 'NASLAVCEA',
	'MD6237' => 'OCNITA',
	'MD6238' => 'MAIOVCA',
	'MD6239' => 'SAUCA',
	'MD6240' => 'UNGURI',
	'MD6241' => 'VALCINET',
	'MD6242' => 'CODRENI',
	'MD6400' => 'R-UL ORHEI',
	'MD6401' => 'MUN.ORHEI',
	'MD6410' => 'BEREZLOGI',
	'MD6411' => 'HIJDIENI',
	'MD6412' => 'BIESTI',
	'MD6413' => 'CIHORENI',
	'MD6414' => 'SLOBOZIA-HODOROGEA',
	'MD6415' => 'BOLOHAN',
	'MD6416' => 'BRAVICENI',
	'MD6417' => 'BULAIESTI',
	'MD6420' => 'CHIPERCENI',
	'MD6421' => 'ANDREEVCA',
	'MD6422' => 'VOROTET',
	'MD6423' => 'CIOCILTENI',
	'MD6427' => 'CLISOVA NOUA',
	'MD6424' => 'FEDOREUCA',
	'MD6426' => 'CLISOVA',
	'MD6428' => 'CRIHANA',
	'MD6429' => 'CUCURUZENII DE SUS',
	'MD6430' => 'SIROTA',
	'MD6431' => 'CUCURUZENI',
	'MD6481' => 'OCNITA-RAZESI',
	'MD6432' => 'DONICI',
	'MD6433' => 'CAMENCEA',
	'MD6434' => 'POCSESTI',
	'MD6435' => 'GHETLOVA',
	'MD6436' => 'HULBOACA',
	'MD6437' => 'NOROCENI',
	'MD6438' => 'ISACOVA',
	'MD6440' => 'IVANCEA',
	'MD6441' => 'BRANESTI',
	'MD6442' => 'FURCENI',
	'MD6443' => 'JORA DE MIJLOC',
	'MD6444' => 'JORA DE JOS',
	'MD6445' => 'JORA DE SUS',
	'MD6446' => 'LOPATNA',
	'MD6447' => 'MALAIESTI',
	'MD6448' => 'TIRZIENI',
	'MD6449' => 'MITOC',
	'MD6419' => 'MIRZESTI',
	'MD6418' => 'MIRZACI',
	'MD6450' => 'MOROZENI',
	'MD6451' => 'BREANOVA',
	'MD6439' => 'NECULAIEUCA',
	'MD6452' => 'PELIVAN',
	'MD6425' => 'CISMEA',
	'MD6453' => 'PERESECINA',
	'MD6454' => 'PIATRA',
	'MD6455' => 'JELOBOC',
	'MD6456' => 'PODGORENI',
	'MD6457' => 'POHORNICENI',
	'MD6458' => 'POHREBENI',
	'MD6459' => 'IZVOARE',
	'MD6460' => 'SERCANI',
	'MD6461' => 'PUTINTEI',
	'MD6462' => 'DISCOVA',
	'MD6463' => 'VIPROVA',
	'MD6471' => 'SAMANANCA',
	'MD6464' => 'SELISTE',
	'MD6465' => 'LUCASEUCA',
	'MD6466' => 'MANA',
	'MD6467' => 'STEP-SOCI',
	'MD6468' => 'BUDAI',
	'MD6469' => 'SUSLENI',
	'MD6470' => 'TELESEU',
	'MD6472' => 'TREBUJENI',
	'MD6473' => 'BUTUCENI',
	'MD6474' => 'MOROVAIA',
	'MD6475' => 'VATICI',
	'MD6476' => 'CURCHI',
	'MD6477' => 'TABARA',
	'MD6478' => 'VISCAUTI',
	'MD6749' => 'ZAHORENI',
	'MD6479' => 'ZORILE',
	'MD6480' => 'INCULET',
	'MD6482' => 'OCNITA-TARANI',
	'MD6700' => 'R-UL REZINA',
	'MD6701' => 'OR.REZINA',
	'MD6710' => 'BOSERNITA',
	'MD6711' => 'CIORNA',
	'MD6750' => 'STOHNAIA',
	'MD6712' => 'BUSAUCA',
	'MD6713' => 'CINISEUTI',
	'MD6714' => 'COGILNICENI',
	'MD6715' => 'CUIZAUCA',
	'MD6716' => 'ECHIMAUTI',
	'MD6717' => 'GHIDULENI',
	'MD6718' => 'ROSCANII DE JOS',
	'MD6719' => 'ROSCANII DE SUS',
	'MD6720' => 'GORDINESTI',
	'MD6721' => 'HORODISTE',
	'MD6722' => 'SLOBOZIA-HORODISTE',
	'MD6723' => 'IGNATEI',
	'MD6724' => 'LALOVA',
	'MD6725' => 'NISTRENI',
	'MD6726' => 'TIPOVA',
	'MD6733' => 'LIPCENI',
	'MD6727' => 'MATEUTI',
	'MD6728' => 'MESENI',
	'MD6729' => 'MINCENII DE JOS',
	'MD6730' => 'MINCENII DE SUS',
	'MD6731' => 'OTAC',
	'MD6732' => 'PAPAUTI',
	'MD6734' => 'PECISTE',
	'MD6735' => 'PERENI',
	'MD6736' => 'ROSCANI',
	'MD6738' => 'PRIPICENI-RAZESI',
	'MD6739' => 'PRIPICENI-CURCHI',
	'MD6740' => 'SAHARNA NOUA',
	'MD6741' => 'BUCIUSCA',
	'MD6742' => 'SAHARNA',
	'MD6743' => 'SIRCOVA',
	'MD6737' => 'PISCARESTI',
	'MD6744' => 'SOLONCENI',
	'MD6745' => 'TARASOVA',
	'MD6746' => 'TRIFESTI',
	'MD6747' => 'TAREUCA',
	'MD6748' => 'TAHNAUTI',
	'MD7100' => 'R-UL RISCANI',
	'MD7101' => 'OR.RISCANI',
	'MD7110' => 'BALANUL NOU',
	'MD7144' => 'RAMAZAN',
	'MD7122' => 'OR.COSTESTI',
	'MD7124' => 'DAMASCANI',
	'MD7123' => 'DURUITOAREA',
	'MD7137' => 'PASCAUTI',
	'MD7125' => 'PROSCURENI',
	'MD7111' => 'ALEXANDRESTI',
	'MD7112' => 'CUCUIETII NOI',
	'MD7113' => 'CUCUIETII VECHI',
	'MD7114' => 'IVANESTI',
	'MD7115' => 'ALUNIS',
	'MD7116' => 'BOROSENII NOI',
	'MD7117' => 'BRANISTE',
	'MD7118' => 'AVRAMENI',
	'MD7119' => 'RETENI',
	'MD7120' => 'RETENI-VASILEUTI',
	'MD7121' => 'CORLATENI',
	'MD7162' => 'DURUITOAREA NOUA',
	'MD7161' => 'DUMENI',
	'MD7126' => 'GALASENI',
	'MD7127' => 'MALAIESTI',
	'MD7128' => 'GRINAUTI',
	'MD7129' => 'CIOBANOVCA',
	'MD7130' => 'HILIUTI',
	'MD7131' => 'HORODISTE',
	'MD7132' => 'MALINOVSCOE',
	'MD7133' => 'LUPARIA',
	'MD7134' => 'MIHAILENI',
	'MD7164' => 'NIHORENI',
	'MD7136' => 'PETRUSENI',
	'MD7138' => 'PIRJOTA',
	'MD7141' => 'POCIUMBAUTI',
	'MD7139' => 'POCUIMBENI',
	'MD7140' => 'DRUTA',
	'MD7142' => 'RACARIA',
	'MD7143' => 'USUREI',
	'MD7145' => 'RECEA',
	'MD7146' => 'SLOBOZIA-RECEA',
	'MD7147' => 'SVERDIAC',
	'MD7148' => 'SINGURENI',
	'MD7149' => 'STURZENI',
	'MD7150' => 'SAPTEBANI',
	'MD7151' => 'SUMNA',
	'MD7152' => 'BULHAC',
	'MD7153' => 'CEPARIA',
	'MD7154' => 'VASILEUTI',
	'MD7155' => 'ARMANCA',
	'MD7156' => 'CIUBARA',
	'MD7157' => 'MIHAILENII NOI',
	'MD7158' => 'MOSENI',
	'MD7159' => 'STIUBEIENI',
	'MD7160' => 'VARATIC',
	'MD7163' => 'ZAICANI',
	'MD7400' => 'R-UL SINGEREI',
	'MD7401' => 'OR.SINGEREI',
	'MD7410' => 'VRANESTI',
	'MD7402' => 'OR.BIRUINTA',
	'MD7411' => 'ALEXANDRENI',
	'MD7412' => 'GRIGORESTI',
	'MD7413' => 'HECIUL VECHI',
	'MD7414' => 'TIPLESTI',
	'MD7415' => 'TIPLETESTI',
	'MD7416' => 'BALASESTI',
	'MD7464' => 'SLOVEANCA',
	'MD7417' => 'BILICENII NOI',
	'MD7418' => 'LIPOVANCA',
	'MD7419' => 'MINDRESTII NOI',
	'MD7420' => 'BILICENII VECHI',
	'MD7421' => 'COADA IAZULUI',
	'MD7422' => 'BURSUCENI',
	'MD7423' => 'SLOBOZIA-MAGURA',
	'MD7424' => 'CHISCARENI',
	'MD7425' => 'NICOLAEVCA',
	'MD7426' => 'SLOBOZIA-CHISCARENI',
	'MD7427' => 'CIUCIUIENI',
	'MD7428' => 'BREJENI',
	'MD7429' => 'COPACENI',
	'MD7430' => 'ANTONOVCA',
	'MD7431' => 'EVGHENIEVCA',
	'MD7432' => 'GAVRILOVCA',
	'MD7434' => 'PETROVCA',
	'MD7435' => 'VLADIMIREUCA',
	'MD7436' => 'COSCODENI',
	'MD7437' => 'BOBLETICI',
	'MD7438' => 'FLAMINZENI',
	'MD7439' => 'COTIUJENII MICI',
	'MD7440' => 'ALEXEUCA',
	'MD7441' => 'GURA-OITUZ',
	'MD7442' => 'CUBOLTA',
	'MD4526' => 'MARASESTI',
	'MD7443' => 'DOBROGEA VECHE',
	'MD7444' => 'COTOVCA',
	'MD7445' => 'DOBROGEA NOUA',
	'MD7446' => 'DRAGANESTI',
	'MD7447' => 'CHIRILENI',
	'MD7448' => 'SACAROVCA',
	'MD7449' => 'DUMBRAVITA',
	'MD7450' => 'BOCANCEA-SCHIT',
	'MD7451' => 'VALEA LUI VLAD',
	'MD7433' => 'GRIGORAUCA',
	'MD8963' => 'COZESTI',
	'MD7459' => 'PETROPAVLOVCA',
	'MD7452' => 'HECIUL NOU',
	'MD7453' => 'TRIFANESTI',
	'MD7454' => 'IEZARENII VECHI',
	'MD7455' => 'IEZARENII NOI',
	'MD7456' => 'IZVOARE',
	'MD7457' => 'VALEA NOROCULUI',
	'MD7460' => 'PEPENI',
	'MD7461' => 'PEPENII NOI',
	'MD7462' => 'RAZALAI',
	'MD7463' => 'ROMANOVCA',
	'MD7465' => 'PREPELITA',
	'MD7466' => 'CLISCAUTI',
	'MD7458' => 'MIHAILOVCA',
	'MD7467' => 'SESTACI',
	'MD7468' => 'RADOAIA',
	'MD7471' => 'TAURA VECHE',
	'MD7472' => 'TAURA NOUA',
	'MD7469' => 'SINGEREII NOI',
	'MD7470' => 'MARINESTI',
	'MD7473' => 'TAMBULA',
	'MD7474' => 'OCTEABRISCOE',
	'MD7475' => 'PALARIA',
	'MD7800' => 'R-UL SOROCA',
	'MD7801' => 'MUN.SOROCA',
	'MD7810' => 'BADICENI',
	'MD7811' => 'GRIGORAUCA',
	'MD7812' => 'BAXANI',
	'MD7813' => 'BULBOCI',
	'MD7814' => 'BULBOCII NOI',
	'MD7815' => 'CAINARII VECHI',
	'MD7816' => 'FLORICENI',
	'MD7817' => 'COSAUTI',
	'MD7818' => 'IORJNITA',
	'MD7819' => 'CREMENCIUG',
	'MD7820' => 'LIVEZI',
	'MD7822' => 'SOBARI',
	'MD7823' => 'VALEA',
	'MD7824' => 'DARCAUTI',
	'MD7825' => 'DARCAUTII NOI',
	'MD7826' => 'MALCAUTI',
	'MD7827' => 'DUBNA',
	'MD7828' => 'EGORENI',
	'MD7829' => 'HOLOSNITA',
	'MD7830' => 'CURESNITA',
	'MD7831' => 'HRISTICI',
	'MD7832' => 'IAROVA',
	'MD7833' => 'BALINTI',
	'MD7834' => 'BALINTII NOI',
	'MD1930' => 'NIMEREUCA',
	'MD1913' => 'CERLINA',
	'MD7821' => 'OCLANDA',
	'MD7835' => 'OCOLINA',
	'MD7836' => 'TEPILOVA',
	'MD7837' => 'PARCANI',
	'MD7863' => 'VOLOAVE',
	'MD7838' => 'PIRLITA',
	'MD7839' => 'VANTINA',
	'MD7840' => 'VANTINA MICA',
	'MD7841' => 'RACOVAT',
	'MD7842' => 'REDI-CERESNOVAT',
	'MD7843' => 'REGINA MARIA',
	'MD7844' => 'LUGOVOE',
	'MD7845' => 'RUBLENITA',
	'MD7846' => 'RUBLENITA NOUA',
	'MD3436' => 'RUDI',
	'MD7847' => 'SCHINENI',
	'MD7848' => 'SCHINENII NOI',
	'MD7852' => 'STOICANI',
	'MD7853' => 'SOLONET',
	'MD7854' => 'SEPTELICI',
	'MD7855' => 'SOLCANI',
	'MD7856' => 'CURESNITA NOUA',
	'MD3440' => 'TATARAUCA VECHE',
	'MD3441' => 'DECEBAL',
	'MD3430' => 'NIORCANI',
	'MD3442' => 'SLOBOZIA NOUA',
	'MD3443' => 'TATARAUCA NOUA',
	'MD3431' => 'TOLOCANESTI',
	'MD7860' => 'TRIFAUTI',
	'MD7857' => 'VASILCAU',
	'MD7858' => 'INUNDENI',
	'MD7859' => 'RUSLANOVCA',
	'MD7861' => 'VADENI',
	'MD7862' => 'DUMBRAVENI',
	'MD7851' => 'VARANCAU',
	'MD7849' => 'SLOBOZIA-CREMENE',
	'MD7850' => 'SLOBOZIA-VARANCAU',
	'MD3450' => 'VISOCA',
	'MD7864' => 'VOLOVITA',
	'MD7865' => 'ALEXANDRU CEL BUN',
	'MD7866' => 'ZASTINCA',
	'MD8000' => 'R-UL STRASENI',
	'MD8001' => 'MUN.STRASENI',
	'MD8010' => 'FAGURENI',
	'MD8002' => 'OR.BUCOVATI',
	'MD2551' => 'RASSVET',
	'MD8011' => 'CAPRIANA',
	'MD8012' => 'CHIRIANCA',
	'MD8013' => 'CODREANCA',
	'MD8014' => 'LUPA-RECEA',
	'MD8015' => 'COJUSNA',
	'MD6030' => 'DOLNA',
	'MD8016' => 'GALESTI',
	'MD8017' => 'GALESTII NOI',
	'MD8018' => 'GHELAUZA',
	'MD8019' => 'SACA',
	'MD8020' => 'GREBLESTI',
	'MD8021' => 'MARTINESTI',
	'MD8022' => 'LOZOVA',
	'MD8023' => 'STEJARENI',
	'MD8024' => 'MICAUTI',
	'MD8025' => 'GORNOE',
	'MD6039' => 'MICLEUSENI',
	'MD6040' => 'HUZUN',
	'MD8026' => 'NEGRESTI',
	'MD8027' => 'ONESTI',
	'MD8028' => 'PANASESTI',
	'MD8029' => 'CIOBANCA',
	'MD8030' => 'RADENI',
	'MD8031' => 'DRAGUSENI',
	'MD8033' => 'ZAMCIOGI',
	'MD8034' => 'RECEA',
	'MD8032' => 'ROMANESTI',
	'MD8035' => 'ROSCANI',
	'MD8036' => 'SCORENI',
	'MD8037' => 'SIRETI',
	'MD8038' => 'TATARESTI',
	'MD8040' => 'TIGANESTI',
	'MD8041' => 'VOINOVA',
	'MD8042' => 'VORNICENI',
	'MD8043' => 'ZUBRESTI',
	'MD8300' => 'R-UL SOLDANESTI',
	'MD8301' => 'OR.SOLDANESTI',
	'MD8310' => 'ALCEDAR',
	'MD8311' => 'CURATURA',
	'MD8312' => 'ODAIA',
	'MD8313' => 'CHIPESCA',
	'MD8314' => 'CLIMAUTII DE JOS',
	'MD8315' => 'COT',
	'MD8316' => 'COBILEA',
	'MD8317' => 'COTIUJENII MARI',
	'MD8340' => 'COBILEA LOC.ST.C.F.',
	'MD8318' => 'CUSELAUCA',
	'MD8319' => 'CUSMIRCA',
	'MD8330' => 'DOBRUSA',
	'MD8329' => 'RECESTI',
	'MD8331' => 'ZAHORNA',
	'MD8320' => 'FUZAUCA',
	'MD8321' => 'GAUZENI',
	'MD8322' => 'GLINJENI',
	'MD8323' => 'MIHULENI',
	'MD8324' => 'OLISCANI',
	'MD8325' => 'PARCANI',
	'MD8326' => 'POHOARNA',
	'MD8327' => 'POIANA',
	'MD8328' => 'RASPOPENI',
	'MD8332' => 'ROGOJENI',
	'MD8341' => 'ROGOJENI LOC.ST.C.F.',
	'MD8333' => 'SALCIA',
	'MD8334' => 'LELINA',
	'MD8335' => 'SAMASCANI',
	'MD8336' => 'SESTACI',
	'MD8337' => 'SIPCA',
	'MD8338' => 'VADUL-RASCOV',
	'MD8339' => 'SOCOLA',
	'MD8500' => 'R-UL STEFAN VODA',
	'MD8501' => 'OR.STEFAN VODA',
	'MD8510' => 'ALAVA',
	'MD8511' => 'LAZO',
	'MD8512' => 'ANTONESTI',
	'MD8513' => 'BREZOAIA',
	'MD8514' => 'CARAHASANI',
	'MD8515' => 'CAPLANI',
	'MD8516' => 'CIOBURCIU',
	'MD8517' => 'COPCEAC',
	'MD8518' => 'CROCMAZ',
	'MD8519' => 'ERMOCLIA',
	'MD8520' => 'FESTELITA',
	'MD8524' => 'MARIANCA DE JOS',
	'MD8525' => 'OLANESTI',
	'MD8526' => 'PALANCA',
	'MD8527' => 'POPEASCA',
	'MD8528' => 'PURCARI',
	'MD8529' => 'VIISOARA',
	'MD8530' => 'RASCAIETI',
	'MD8531' => 'RASCAIETII NOI',
	'MD8532' => 'SEMIONOVCA',
	'MD8533' => 'SLOBOZIA',
	'MD8534' => 'STEFANESTI',
	'MD8535' => 'TALMAZA',
	'MD8536' => 'TUDORA',
	'MD8537' => 'VOLINTIRI',
	'MD8700' => 'R-UL TARACLIA',
	'MD8701' => 'OR.TARACLIA',
	'MD8728' => 'OR. TVARDIŢA',
	'MD8710' => 'ALBOTA DE JOS',
	'MD8711' => 'HAGICHIOI',
	'MD8712' => 'HIRTOP',
	'MD8713' => 'ALBOTA DE SUS',
	'MD8714' => 'ROSITA',
	'MD8715' => 'SOFIEVCA',
	'MD8716' => 'ALUATU',
	'MD8717' => 'BALABANU',
	'MD8719' => 'BUDAI',
	'MD8735' => 'DERMENGI',
	'MD8720' => 'CAIRACLIA',
	'MD8721' => 'CEALIC',
	'MD8734' => 'CORTENUL NOU',
	'MD8722' => 'SAMURZA',
	'MD8723' => 'CORTEN',
	'MD8724' => 'MUSAITU',
	'MD8725' => 'NOVOSIOLOVCA',
	'MD8726' => 'SALCIA',
	'MD8727' => 'OREHOVCA',
	'MD8729' => 'VALEA PERJEI',
	'MD8730' => 'VINOGRADOVCA',
	'MD8731' => 'CHIRILOVCA',
	'MD8732' => 'CIUMAI',
	'MD8733' => 'MIRNOE',
	'MD8900' => 'R-UL TELENESTI',
	'MD8901' => 'OR.TELENESTI',
	'MD8910' => 'MIHALASA',
	'MD8911' => 'MIHALASA NOUA',
	'MD8912' => 'BANESTI',
	'MD8913' => 'BANESTII NOI',
	'MD8914' => 'BOGZESTI',
	'MD8915' => 'BRINZENII NOI',
	'MD8916' => 'BRINZENII VECHI',
	'MD8917' => 'BUDAI',
	'MD8918' => 'CAZANESTI',
	'MD8919' => 'VADUL-LECA',
	'MD8920' => 'VADUL-LECA NOU',
	'MD8921' => 'CHISTELNITA',
	'MD8922' => 'CHITCANII VECHI',
	'MD8923' => 'CHITCANII NOI',
	'MD8924' => 'CIULUCANI',
	'MD8925' => 'CISLA',
	'MD8926' => 'CODRUL NOU',
	'MD8927' => 'COROPCENI',
	'MD8928' => 'CRASNASENI',
	'MD8929' => 'GHILICENI',
	'MD8930' => 'CUCIOAIA',
	'MD8931' => 'CUCIOAIA NOUA',
	'MD8932' => 'HIRISENI',
	'MD8933' => 'INESTI',
	'MD8934' => 'LEUSENI',
	'MD8935' => 'MINDRESTI',
	'MD8936' => 'CODRU',
	'MD8937' => 'NEGURENI',
	'MD8938' => 'CHERSAC',
	'MD8939' => 'DOBRUSA',
	'MD8940' => 'NUCARENI',
	'MD8941' => 'ORDASEI',
	'MD8942' => 'PISTRUIENI',
	'MD8943' => 'HIRTOP',
	'MD8944' => 'PISTRUIENII NOI',
	'MD8945' => 'RATUS',
	'MD8946' => 'MINDRA',
	'MD8947' => 'SARATENII NOI',
	'MD8948' => 'ZAICANI',
	'MD8949' => 'ZAICANII NOI',
	'MD8950' => 'SARATENII VECHI',
	'MD8951' => 'ZAHAREUCA',
	'MD8952' => 'SCORTENI',
	'MD8953' => 'SUHULUCENI',
	'MD8954' => 'GHERMANESTI',
	'MD8955' => 'TIRSITEI',
	'MD8956' => 'FLUTURA',
	'MD8957' => 'TINTARENI',
	'MD8958' => 'VASIENI',
	'MD8959' => 'VEREJENI',
	'MD8960' => 'ZGARDESTI',
	'MD8961' => 'BONDAREUCA',
	'MD8962' => 'CIOFU',
	'MD9200' => 'R-UL UNGHENI',
	'MD9201' => 'MUN.UNGHENI',
	'MD9202' => 'OR.CORNESTI',
	'MD9210' => 'ROMANOVCA',
	'MD9211' => 'AGRONOMOVCA',
	'MD9212' => 'NEGURENII NOI',
	'MD9213' => 'ZAZULENII NOI',
	'MD9214' => 'ALEXEEVCA',
	'MD9215' => 'LIDOVCA',
	'MD9216' => 'SAGHIENI',
	'MD9217' => 'BOGHENII NOI',
	'MD9218' => 'BOGHENII VECHI',
	'MD9219' => 'IZVORENI',
	'MD9220' => 'MIRCESTI',
	'MD9221' => 'POIANA',
	'MD9222' => 'BUCIUMENI',
	'MD9280' => 'BUCIUMENI LOC.ST.C.F.',
	'MD9223' => 'FLORESTI',
	'MD9224' => 'BUMBATA',
	'MD9225' => 'BUSILA',
	'MD9226' => 'CETIRENI',
	'MD9227' => 'CHIRILENI',
	'MD9228' => 'CIOROPCANI',
	'MD9229' => 'BULHAC',
	'MD9230' => 'STOLNICENI',
	'MD9231' => 'CONDRATESTI',
	'MD9232' => 'CURTOAIA',
	'MD9233' => 'CORNESTI',
	'MD9234' => 'CORNOVA',
	'MD9235' => 'COSTULENI',
	'MD9236' => 'FLORITOAIA VECHE',
	'MD9237' => 'FLORITOAIA NOUA',
	'MD9238' => 'GROZASCA',
	'MD9239' => 'HIRCESTI',
	'MD9240' => 'DRUJBA',
	'MD9241' => 'LEORDOAIA',
	'MD9242' => 'MINZATESTI',
	'MD9243' => 'VEVERITA',
	'MD9244' => 'MACARESTI',
	'MD9245' => 'FRASINESTI',
	'MD9246' => 'MAGURELE',
	'MD9247' => 'MANOILESTI',
	'MD9248' => 'NOVAIA NICOLAEVCA',
	'MD9249' => 'REZINA',
	'MD9250' => 'VULPESTI',
	'MD9251' => 'MORENII NOI',
	'MD9253' => 'SICOVAT',
	'MD9254' => 'NAPADENI',
	'MD9255' => 'NEGURENII VECHI',
	'MD9256' => 'COSENI',
	'MD9257' => 'TIGHIRA',
	'MD9258' => 'ZAZULENII VECHI',
	'MD9259' => 'PETRESTI',
	'MD9260' => 'MEDELENI',
	'MD9281' => 'PETRESTI LOC.ST.C.F.',
	'MD9261' => 'PIRLITA',
	'MD9270' => 'HRISTOFOROVCA',
	'MD9262' => 'RADENII VECHI',
	'MD9263' => 'SCULENI',
	'MD9264' => 'BLINDESTI',
	'MD9265' => 'FLORENI',
	'MD9266' => 'GHERMAN',
	'MD9267' => 'SINESTI',
	'MD9268' => 'POJARNA',
	'MD9269' => 'TESCURENI',
	'MD9271' => 'TODIRESTI',
	'MD9272' => 'GRASENI',
	'MD9273' => 'UNTESTI',
	'MD9274' => 'VALEA MARE',
	'MD9275' => 'BUZDUGANII DE JOS',
	'MD9276' => 'BUZDUGANII DE SUS',
	'MD9252' => 'MORENII VECHI',
	'MD9277' => 'ZAGARANCEA',
	'MD9278' => 'ELIZAVETOVCA',
	'MD9279' => 'SEMENI',
	'MD9600' => 'GAGAUZIA',
	'MD9601' => 'MUN.COMRAT',
	'MD9602' => 'MUN.CEADIR-LUNGA',
	'MD9603' => 'OR.VULCANESTI',
	'MD9637' => 'VULCANESTI LOC.ST.C.F.',
	'MD9610' => 'AVDARMA',
	'MD9611' => 'BAURCI',
	'MD9612' => 'BESALMA',
	'MD9613' => 'BESGHIOZ',
	'MD9614' => 'BUGEAC',
	'MD9615' => 'CARBALIA',
	'MD9616' => 'CAZACLIA',
	'MD9617' => 'CHIOSELIA RUSA',
	'MD9618' => 'CHIRIET-LUNGA',
	'MD9619' => 'CHIRSOVA',
	'MD9620' => 'CIOC-MAIDAN',
	'MD9621' => 'CISMICHIOI',
	'MD9622' => 'CONGAZ',
	'MD9624' => 'CONGAZCICUL DE SUS',
	'MD9623' => 'CONGAZCICUL DE JOS',
	'MD9625' => 'DUDULESTI',
	'MD9626' => 'COPCEAC',
	'MD9627' => 'COTOVSCOE',
	'MD9628' => 'DEZGHINGEA',
	'MD9629' => 'ETULIA',
	'MD9639' => 'ETULIA LOC.ST.C.F.',
	'MD9630' => 'ETULIA NOUA',
	'MD9631' => 'FERAPONTIEVCA',
	'MD9632' => 'GAIDAR',
	'MD9633' => 'JOLTAI',
	'MD9634' => 'SVETLII',
	'MD9635' => 'ALEXEEVCA',
	'MD9636' => 'TOMAI',
	'MD9800' => 'TDS NISTRULUI',
	'MD700' => 'MUN.TIRASPOL',
	'MD1901' => 'OR.CAMENCA',
	'MD1910' => 'SOLNECINOE',
	'MD7602' => 'OR.CRASNOE',
	'MD701' => 'OR.DNESTROVSC',
	'MD3801' => 'OR.DUBASARI',
	'MD5001' => 'OR.GRIGORIOPOL',
	'MD5010' => 'CRASNOE',
	'MD5002' => 'OR.MAIAC',
	'MD6901' => 'OR.RIBNITA',
	'MD7601' => 'OR.SLOBOZIA',
	'MD702' => 'OR.TIRASPOLUL NOU',
	'MD6910' => 'ANDREEVCA',
	'MD6911' => 'PICALOVA',
	'MD6912' => 'SMALENA',
	'MD6913' => 'BELOCI',
	'MD5011' => 'BICIOC',
	'MD5012' => 'NOVOVLADIMIROVCA',
	'MD7610' => 'BLIJNII HUTOR',
	'MD6914' => 'BROSTENI',
	'MD5013' => 'BUTOR',
	'MD5014' => 'INDIA',
	'MD6915' => 'BUTUCENI',
	'MD7611' => 'CARAGAS',
	'MD5015' => 'CARMANOVA',
	'MD5016' => 'COTOVCA',
	'MD5017' => 'FEDOSEEVCA',
	'MD5018' => 'MOCEAROVCA',
	'MD1911' => 'CATERINOVCA',
	'MD1912' => 'SADCHI',
	'MD7615' => 'CIOBURCIU',
	'MD6916' => 'COBASNA',
	'MD6955' => 'COBASNA LOC.ST.C.F.',
	'MD6917' => 'SUHAIA RIBNITA',
	'MD5019' => 'COLOSOVA',
	'MD5020' => 'CRASNAIA BESARABIA',
	'MD5021' => 'POBEDA',
	'MD3812' => 'COMISAROVCA NOUA',
	'MD3813' => 'BOSCA',
	'MD3814' => 'COSNITA NOUA',
	'MD3815' => 'POHREBEA NOUA',
	'MD7617' => 'COROTNA',
	'MD6918' => 'CRASNENCOE',
	'MD6919' => 'DIMITROVA',
	'MD6920' => 'IVANOVCA',
	'MD1914' => 'CRASNII OCTEABRI',
	'MD1915' => 'ALEXANDROVCA',
	'MD3820' => 'CRASNII VINOGRADARI',
	'MD3821' => 'AFANASIEVCA',
	'MD3822' => 'ALEXANDROVCA NOUA',
	'MD3823' => 'CALINOVCA',
	'MD3824' => 'LUNGA NOUA',
	'MD5022' => 'CRASNOGORCA',
	'MD1922' => 'CUZMIN',
	'MD1923' => 'VOITOVCA',
	'MD5023' => 'DELACAU',
	'MD5024' => 'CRASNAIA GORCA',
	'MD3825' => 'DOIBANI I',
	'MD3826' => 'COICOVA',
	'MD3827' => 'DOIBANI II',
	'MD3829' => 'DUBAU',
	'MD3830' => 'GOIANUL NOU',
	'MD3831' => 'DZERJINSCOE',
	'MD7618' => 'FRUNZA',
	'MD7619' => 'ANDRIASEVCA NOUA',
	'MD7620' => 'ANDRIASEVCA VECHE',
	'MD7621' => 'NOVOCOTOVSC',
	'MD7622' => 'NOVOSAVITCAIA LOC.ST.C.F.',
	'MD7623' => 'PRIOZIORNOE',
	'MD7624' => 'UIUTNOE',
	'MD6921' => 'GHIDIRIM',
	'MD3832' => 'GOIAN',
	'MD3833' => 'IAGORLIC',
	'MD6922' => 'HARABA',
	'MD3834' => 'HARMATCA',
	'MD6923' => 'HIRJAU',
	'MD6924' => 'MIHAILOVCA NOUA',
	'MD6925' => 'SARATEI',
	'MD5025' => 'HIRTOP',
	'MD5026' => 'BRUSLACHI',
	'MD5027' => 'MARIAN',
	'MD5028' => 'MOCREACHI',
	'MD5029' => 'HLINAIA',
	'MD7625' => 'HLINAIA',
	'MD1924' => 'HRISTOVAIA',
	'MD1925' => 'HRUSCA',
	'MD1926' => 'FRUNZAUCA',
	'MD6926' => 'JURA',
	'MD6927' => 'LENIN',
	'MD6928' => 'PERVOMAISC',
	'MD6929' => 'POBEDA',
	'MD6930' => 'STANISLAVCA',
	'MD3836' => 'LUNGA',
	'MD5030' => 'MALAIESTI',
	'MD5031' => 'CERNITA',
	'MD6931' => 'MIHAILOVCA',
	'MD6932' => 'MOCRA',
	'MD6933' => 'BASARABCA',
	'MD6934' => 'SEVCENCO',
	'MD6935' => 'ZAPOROJET',
	'MD6936' => 'MOLOCHISUL MARE',
	'MD7626' => 'NEZAVERTAILOVCA',
	'MD1931' => 'OCNITA',
	'MD6937' => 'OFATINTI',
	'MD6938' => 'NOVAIA JIZNI',
	'MD7627' => 'PARCANI',
	'MD7628' => 'PERVOMAISC',
	'MD6939' => 'PLOPI',
	'MD1932' => 'PODOIMA',
	'MD1933' => 'PODOIMITA',
	'MD6940' => 'POPENCU',
	'MD6941' => 'CHIROV',
	'MD6942' => 'VLADIMIROVCA',
	'MD6943' => 'ZAZULENI',
	'MD1934' => 'RASCOV',
	'MD1935' => 'IANTARNOE',
	'MD1936' => 'ROTARI',
	'MD1937' => 'BODENI',
	'MD1938' => 'SOCOLOVCA',
	'MD1940' => 'SEVERINOVCA',
	'MD1941' => 'SLOBOZIA-RASCOV',
	'MD6944' => 'SOVIETSCOE',
	'MD6945' => 'VASILIEVCA',
	'MD5032' => 'SPEIA',
	'MD6946' => 'STROIESTI',
	'MD7629' => 'SUCLEIA',
	'MD5033' => 'SIPCA',
	'MD5034' => 'VESIOLOE',
	'MD5035' => 'TASLIC',
	'MD5036' => 'TEIU',
	'MD5037' => 'TOCMAGIU',
	'MD7630' => 'TIRNAUCA',
	'MD3843' => 'TIBULEUCA',
	'MD6947' => 'ULMU',
	'MD6948' => 'LISAIA GORA',
	'MD6949' => 'ULMUL MIC',
	'MD6950' => 'VADUL TURCULUI',
	'MD6951' => 'MOLOCHISUL MIC',
	'MD1944' => 'VALEA ADINCA',
	'MD1945' => 'CONSTANTINOVCA',
	'MD6952' => 'VARANCAU',
	'MD6953' => 'BUSCHI',
	'MD6954' => 'GHERSUNOVCA',
	'MD5038' => 'VINOGRADNOE',
	'MD7631' => 'VLADIMIROVCA',
	'MD7632' => 'CONSTANTINOVCA',
	'MD7633' => 'NICOLSCOE',
];
