<?php

/**
 * List of cities for: Morocco
 * Source: https://www.hcp.ma/downloads/RGPH-2014_t17441.html
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'MA01' => 'Tanger-Tetouan-Al Hoceima',
	'MA02' => 'Oriental',
	'MA03' => 'Fès-Meknès',
	'MA04' => 'Rabat-Salé-Kénitra',
	'MA05' => 'Béni Mellal-Khénifra',
	'MA06' => 'Grand Casablanca-Settat',
	'MA07' => 'Marrakech-Safi',
	'MA08' => 'Drâa-Tafilalet',
	'MA09' => 'Souss-Massa',
	'MA10' => 'Guelmim-Oued Noun',
	'MA11' => 'Laayoune-Sakia El Hamra',
	'MA12' => 'Eddakhla-Oued Eddahab',
];

$country_cities = [
	'MA01'	=> [
		'MA010510101' => 'Al Hoceima',
		'MA010510103' => 'Bni Bouayach',
		'MA010510105' => 'Imzouren',
		'MA010510107' => 'Targuist',
		'MA010510109' => 'Ajdir',
		'MA010510301' => 'Bni Boufrah',
		'MA010510303' => 'Bni Gmil',
		'MA010510305' => 'Bni Gmil Maksouline',
		'MA010510307' => 'Senada',
		'MA010510501' => 'Ait Kamra',
		'MA010510503' => 'Ait Youssef Ou Ali',
		'MA010510505' => 'Arbaa Taourirt',
		'MA010510507' => 'Bni Abdallah',
		'MA010510509' => 'Bni Hadifa',
		'MA010510511' => 'Chakrane',
		'MA010510513' => 'Imrabten',
		'MA010510515' => 'Izemmouren',
		'MA010510517' => 'Louta',
		'MA010510519' => 'Nekkour',
		'MA010510521' => 'Rouadi',
		'MA010510523' => 'Tifarouine',
		'MA010510525' => 'Zaouiat Sidi Abdelkader',
		'MA010510703' => 'Bni Ahmed Imoukzan',
		'MA010510705' => 'Bni Ammart',
		'MA010510707' => 'Bni Bchir',
		'MA010510711' => 'Bni Bounsar',
		'MA010510719' => 'Sidi Boutmim',
		'MA010510721' => 'Sidi Bouzineb',
		'MA010510727' => 'Zarkt',
		'MA010510901' => 'Abdelghaya Souahel',
		'MA010510909' => 'Bni Bouchibet',
		'MA010510913' => 'Issaguen',
		'MA010510915' => 'Ketama',
		'MA010510917' => 'Moulay Ahmed Cherif',
		'MA010510923' => 'Taghzout',
		'MA010510925' => 'Tamsaout',
		'MA011510101' => 'Chefchaouen',
		'MA011510303' => 'Bab Berred',
		'MA011510313' => 'Iounane',
		'MA011510323' => 'Tamorot',
		'MA011510501' => 'Bab Taza',
		'MA011510503' => 'Bni Darkoul',
		'MA011510505' => 'Bni Faghloum',
		'MA011510507' => 'Bni Salah',
		'MA011510509' => 'Derdara',
		'MA011510511' => 'Fifi',
		'MA011510513' => 'Laghdir',
		'MA011510515' => 'Tanaqoub',
		'MA011510605' => 'Bni Ahmed Cherqia',
		'MA011510607' => 'Bni Ahmed Gharbia',
		'MA011510615' => 'Mansoura',
		'MA011510621' => 'Oued Malha',
		'MA011510701' => 'Bni Bouzra',
		'MA011510703' => 'Bni Mansour',
		'MA011510705' => 'Bni Selmane',
		'MA011510707' => 'Steha',
		'MA011510709' => 'Talambote',
		'MA011510711' => 'Tassift',
		'MA011510713' => 'Tizgane',
		'MA011510901' => 'Amtar',
		'MA011510909' => 'Bni Rzine',
		'MA011510911' => 'Bni Smih',
		'MA011510917' => 'Mtioua',
		'MA011510919' => 'Ouaouzgane',
		'MA012270305' => 'Anjra',
		'MA012270311' => 'Jouamaa',
		'MA012270313' => 'Ksar El Majaz',
		'MA012270321' => 'Taghramt',
		'MA012270501' => 'Al Bahraoyine',
		'MA012270505' => 'Ksar Sghir',
		'MA012270509' => 'Malloussa',
		'MA013310101' => 'Ksar El Kebir',
		'MA013310103' => 'Larache',
		'MA013310701' => 'Bou Jedyane',
		'MA013310703' => 'Ksar Bjir',
		'MA013310705' => 'Laouamra',
		'MA013310711' => 'Souk LQolla',
		'MA013310715' => 'Tatoft',
		'MA013310717' => 'Zouada',
		'MA013310901' => 'Ayacha',
		'MA013310903' => 'Bni Arouss',
		'MA013310905' => 'Bni Garfett',
		'MA013310913' => 'Tazroute',
		'MA013310915' => 'Zaaroura',
		'MA013311103' => 'Oulad Ouchih',
		'MA013311107' => 'Rissana Chamalia',
		'MA013311109' => 'Rissana Janoubia',
		'MA013311111' => 'Sahel',
		'MA013311112' => 'Souaken',
		'MA013311113' => 'Souk Tolba',
		'MA014050109' => 'Ouezzane',
		'MA014050701' => 'Bni Quolla',
		'MA014050703' => 'Lamjaara',
		'MA014050705' => 'Masmouda',
		'MA014050707' => 'Mzefroune',
		'MA014050709' => 'Ounnana',
		'MA014050711' => 'Sidi Ahmed Cherif',
		'MA014050713' => 'Sidi Bousber',
		'MA014050715' => 'Sidi Redouane',
		'MA014050717' => 'Teroual',
		'MA014050719' => 'Zghira',
		'MA014050901' => 'Ain Beida',
		'MA014050903' => 'Asjen',
		'MA014050905' => 'Brikcha',
		'MA014050909' => 'Moqrisset',
		'MA014051107' => 'Kalaat Bouqorra',
		'MA014051111' => 'Zoumi',
		'MA015110101' => 'Assilah',
		'MA015110103' => 'Bni Makada',
		'MA015110105' => 'Charf-Mghogha',
		'MA015110106' => 'Charf-Souani',
		'MA015110107' => 'Tanger-Médina',
		'MA015110109' => 'Gueznaia',
		'MA015110301' => 'Al Manzla',
		'MA015110303' => 'Aquouass Briech',
		'MA015110305' => 'Sebt Azzinate',
		'MA015110307' => 'Dar Chaoui',
		'MA015110311' => 'Sahel Chamali',
		'MA015110313' => 'Sidi Lyamani',
		'MA015110315' => 'Had Al Gharbia',
		'MA015110317' => 'Laaouama',
		'MA015118105' => 'HJAR ENNHAL',
		'MA015710107' => 'Oued Laou',
		'MA015710111' => 'Tétouan',
		'MA015710301' => 'Ain Lahsan',
		'MA015710303' => 'AL Kharroub',
		'MA015710305' => 'Bghaghza',
		'MA015710307' => 'Bni Harchen',
		'MA015710309' => 'Jbel Lahbib',
		'MA015710311' => 'Bni Idder',
		'MA015710315' => 'Mallalienne',
		'MA015710317' => 'Saddina',
		'MA015710319' => 'Souk Kdim',
		'MA015710321' => 'Sahtryine',
		'MA015710501' => 'Al Hamra',
		'MA015710505' => 'Al Oued',
		'MA015710507' => 'Azla',
		'MA015710513' => 'Bni Leit',
		'MA015710515' => 'Bni Said',
		'MA015710517' => 'Dar Bni Karrich',
		'MA015710519' => 'Oulad Ali Mansour',
		'MA015710523' => 'Zaitoune',
		'MA015710525' => 'Zaouiat Sidi Kacem',
		'MA015710527' => 'Zinat',
		'MA015730101' => 'Fnideq',
		'MA015730103' => 'Martil',
		'MA015730105' => 'MDiq',
		'MA015730303' => 'Allyene',
		'MA015730305' => 'Belyounech',
	],
	'MA02' => [
		'MA021130101' => 'Ahfir',
		'MA021130105' => 'Ain Erreggada',
		'MA021130107' => 'Aklim',
		'MA021130109' => 'Berkane',
		'MA021130125' => 'Saidia',
		'MA021130129' => 'Sidi Slimane Echcharraa',
		'MA021130301' => 'Aghbal',
		'MA021130307' => 'Fezouane',
		'MA021130309' => 'Laatamna',
		'MA021130311' => 'Madagh',
		'MA021130503' => 'Boughriba',
		'MA021130505' => 'Chouihia',
		'MA021130513' => 'Rislane',
		'MA021130515' => 'Sidi Bouhria',
		'MA021130517' => 'Tafoughalt',
		'MA021130519' => 'Zegzel',
		'MA021670103' => 'Ben Taieb',
		'MA021670109' => 'Driouch',
		'MA021670113' => 'Midar',
		'MA021670301' => 'Ain Zohra',
		'MA021670303' => 'Ait Mait',
		'MA021670305' => 'Amejjaou',
		'MA021670307' => 'Dar El Kebdani',
		'MA021670309' => 'Mtalssa',
		'MA021670311' => 'Oulad Boubker',
		'MA021670313' => 'Tazaghine',
		'MA021670901' => 'Azlaf',
		'MA021670905' => 'Bni Marghnine',
		'MA021670907' => 'Boudinar',
		'MA021670909' => 'Iferni',
		'MA021670911' => 'Ijermaouas',
		'MA021670915' => 'MHajer',
		'MA021670917' => 'Ouardana',
		'MA021670919' => 'Oulad Amghar',
		'MA021670921' => 'Tafersit',
		'MA021670923' => 'Talilit',
		'MA021670925' => 'Temsamane',
		'MA021670927' => 'Trougout',
		'MA021670929' => 'Tsaft',
		'MA022510101' => 'Bouarfa',
		'MA022510103' => 'Figuig',
		'MA022510301' => 'Ain Chouater',
		'MA022510303' => 'Bni Tadjite',
		'MA022510305' => 'Bouanane',
		'MA022510307' => 'Bouchaouene',
		'MA022510309' => 'Boumerieme',
		'MA022510311' => 'Talsint',
		'MA022510313' => 'Ain Chair',
		'MA022510501' => 'Abbou Lakhal',
		'MA022510503' => 'Bni Guil',
		'MA022510505' => 'Maatarka',
		'MA022510507' => 'Tendrara',
		'MA022650103' => 'Guercif',
		'MA022650501' => 'Assebbab',
		'MA022650503' => 'Barkine',
		'MA022650505' => 'Houara Oulad Raho',
		'MA022650507' => 'Lamrija',
		'MA022650515' => 'Saka',
		'MA022650709' => 'Mazguitam',
		'MA022650711' => 'Oulad Bourima',
		'MA022650713' => 'Ras Laksar',
		'MA022650717' => 'Taddart',
		'MA022750103' => 'Ain Bni Mathar',
		'MA022750117' => 'Jerada',
		'MA022750135' => 'Touissit',
		'MA022750303' => 'Gafait',
		'MA022750305' => 'Guenfouda',
		'MA022750307' => 'Laaouinate',
		'MA022750309' => 'Lebkhata',
		'MA022750313' => 'Ras Asfour',
		'MA022750315' => 'Sidi Boubker',
		'MA022750321' => 'Tiouli',
		'MA022750501' => 'Bni Mathar',
		'MA022750511' => 'Mrija',
		'MA022750513' => 'Oulad Ghziyel',
		'MA022750515' => 'Oulad Sidi Abdelhakem',
		'MA023810101' => 'Al Aaroui',
		'MA023810103' => 'Bni Ansar',
		'MA023810105' => 'Nador',
		'MA023810107' => 'Zaio',
		'MA023810109' => 'Zeghanghane',
		'MA023810115' => 'Ras El Ma',
		'MA023810119' => 'Selouane',
		'MA023810501' => 'Bni Bouifrour',
		'MA023810503' => 'Bni Chiker',
		'MA023810505' => 'Bni Sidel Jbel',
		'MA023810507' => 'Bni Sidel Louta',
		'MA023810509' => 'Bouarg',
		'MA023810513' => 'Iaazzanene',
		'MA023810515' => 'Ihaddadene',
		'MA023810517' => 'Iksane',
		'MA023810701' => 'Afsou',
		'MA023810703' => 'Al Barkanyene',
		'MA023810705' => 'Arekmane',
		'MA023810707' => 'Bni Oukil Oulad MHand',
		'MA023810709' => 'Hassi Berkane',
		'MA023810711' => 'Oulad Daoud Zkhanine',
		'MA023810713' => 'Oulad Settout',
		'MA023810717' => 'Tiztoutine',
		'MA024110111' => 'Bni Drar',
		'MA024110119' => 'Naima',
		'MA024110123' => 'Oujda',
		'MA024110301' => 'Ahl Angad',
		'MA024110303' => 'Ain Sfa',
		'MA024110305' => 'Bni Khaled',
		'MA024110307' => 'Bsara',
		'MA024110509' => 'Isly',
		'MA024110511' => 'Mestferki',
		'MA024110517' => 'Sidi Boulenouar',
		'MA024110519' => 'Sidi Moussa Lemhaya',
		'MA025330113' => 'Debdou',
		'MA025330115' => 'El Aioun Sidi Mellouk',
		'MA025330133' => 'Taourirt',
		'MA025330305' => 'El Atef',
		'MA025330315' => 'Oulad Mhammed',
		'MA025330317' => 'Sidi Ali Bel Quassem',
		'MA025330319' => 'Sidi Lahsen',
		'MA025330703' => 'Ain Lehjer',
		'MA025330709' => 'Mechraa Hammadi',
		'MA025330713' => 'Mestegmer',
		'MA025330721' => 'Tancherfi',
		'MA025330901' => 'Ahl Oued Za',
		'MA025330907' => 'Gteter',
		'MA025330911' => 'Melg El Ouidane',
	],
	'MA03' => [
		'MA030610101' => 'Meknès',
		'MA030610103' => 'Al Machouar - Stinia',
		'MA030610105' => 'Boufakrane',
		'MA030610107' => 'Toulal',
		'MA030610109' => 'Moulay Driss Zerhoun',
		'MA030610111' => 'Ouislane',
		'MA030610301' => 'Ain Jemaa',
		'MA030610302' => 'Ain Karma- Oued Rommane',
		'MA030610305' => 'Ain Orma',
		'MA030610307' => 'Ait Ouallal',
		'MA030610309' => 'Dar Oum Soltane',
		'MA030610501' => 'Dkhissa',
		'MA030610503' => 'Majjate',
		'MA030610505' => 'Mhaya',
		'MA030610507' => 'Oued Jdida',
		'MA030610509' => 'Sidi Slimane Moul Al Kifane',
		'MA030610701' => 'Charqaoua',
		'MA030610705' => 'MRhassiyine',
		'MA030610707' => 'Nzalat Bni Amar',
		'MA030610709' => 'Oualili',
		'MA030610711' => 'Sidi Abdallah Al Khayat',
		'MA031310101' => 'Boulemane',
		'MA031310102' => 'Imouzzer Marmoucha',
		'MA031310103' => 'Missour',
		'MA031310105' => 'Outat El Haj',
		'MA031310301' => 'Ait Bazza',
		'MA031310303' => 'Ait El Mane',
		'MA031310305' => 'Almis Marmoucha',
		'MA031310307' => 'El Mers',
		'MA031310309' => 'Enjil',
		'MA031310311' => 'Guigou',
		'MA031310313' => 'Serghina',
		'MA031310315' => 'Skoura MDaz',
		'MA031310317' => 'Talzemt',
		'MA031310501' => 'Ksabi Moulouya',
		'MA031310503' => 'Ouizeght',
		'MA031310505' => 'Sidi Boutayeb',
		'MA031310701' => 'El Orjane',
		'MA031310703' => 'Ermila',
		'MA031310705' => 'Fritissa',
		'MA031310707' => 'Oulad Ali Youssef',
		'MA031310709' => 'Tissaf',
		'MA031710101' => 'Agourai',
		'MA031710103' => 'Ain Taoujdate',
		'MA031710105' => 'El Hajeb',
		'MA031710107' => 'Sabaa Aiyoun',
		'MA031710301' => 'Ait Ouikhalfen',
		'MA031710303' => 'Ait Yaazem',
		'MA031710305' => 'Jahjouh',
		'MA031710307' => 'Ras Ijerri',
		'MA031710309' => 'Tamchachate',
		'MA031710501' => 'Ait Boubidmane',
		'MA031710503' => 'Ait Harz Allah',
		'MA031710505' => 'Bitit',
		'MA031710507' => 'Laqsir',
		'MA031710701' => 'Ait Bourzouine',
		'MA031710703' => 'Ait Naamane',
		'MA031710705' => 'Iqaddar',
		'MA032310101' => 'Agdal',
		'MA032310103' => 'Méchouar Fès Jdid',
		'MA032310105' => 'Saiss',
		'MA032310107' => 'Fès-Médina',
		'MA032310109' => 'Jnan El Ouard',
		'MA032310111' => 'El Mariniyine',
		'MA032310113' => 'Zouagha',
		'MA032318101' => 'Oulad Tayeb',
		'MA032318103' => 'Ain Bida',
		'MA032318105' => 'Sidi Harazem',
		'MA032710101' => 'Azrou',
		'MA032710103' => 'Ifrane',
		'MA032710301' => 'Ain Leuh',
		'MA032710303' => 'Ben Smim',
		'MA032710305' => 'Oued Ifrane',
		'MA032710307' => 'Sidi El Makhfi',
		'MA032710309' => 'Tigrigra',
		'MA032710311' => 'Timahdite',
		'MA032718101' => 'Dayat Aoua',
		'MA032718103' => 'Tizguite',
		'MA034510101' => 'Bhalil',
		'MA034510103' => 'El Menzel',
		'MA034510105' => 'Imouzzer Kandar',
		'MA034510107' => 'Ribate El Kheir',
		'MA034510109' => 'Sefrou',
		'MA034510301' => 'Adrej',
		'MA034510303' => 'Ain Timguenai',
		'MA034510305' => 'Bir Tam Tam',
		'MA034510307' => 'Dar El Hamra',
		'MA034510309' => 'Ighzrane',
		'MA034510311' => 'Mtarnagha',
		'MA034510313' => 'Oulad Mkoudou',
		'MA034510315' => 'Ras Tabouda',
		'MA034510317' => 'Tafajight',
		'MA034510501' => 'Ain Cheggag',
		'MA034510503' => 'Ait Sebaa Lajrouf',
		'MA034510701' => 'Aghbalou Aqorar',
		'MA034510703' => 'Ahl Sidi Lahcen',
		'MA034510705' => 'Azzaba',
		'MA034510707' => 'Kandar Sidi Khiar',
		'MA034510709' => 'Laanoussar',
		'MA034510711' => 'Sidi YoussefBen Ahmed',
		'MA034510713' => 'Tazouta',
		'MA035310101' => 'Ghafsai',
		'MA035310103' => 'Karia Ba Mohamed',
		'MA035310105' => 'Taounate',
		'MA035310107' => 'Thar Es-souk',
		'MA035310109' => 'Tissa',
		'MA035310301' => 'El Bibane',
		'MA035310303' => 'Galaz',
		'MA035310305' => 'Kissane',
		'MA035310307' => 'Oudka',
		'MA035310309' => 'Ouartzagh',
		'MA035310311' => 'Ratba',
		'MA035310313' => 'Sidi Haj Mhamed',
		'MA035310315' => 'Sidi Mokhfi',
		'MA035310317' => 'Sidi YahyaBni Zeroual',
		'MA035310319' => 'Tabouda',
		'MA035310321' => 'Tafrant',
		'MA035310323' => 'Timezgana',
		'MA035310501' => 'Bni Snous',
		'MA035310503' => 'Bouchabel',
		'MA035310505' => 'Rhouazi',
		'MA035310507' => 'Jbabra',
		'MA035310509' => 'Loulja',
		'MA035310511' => 'Mkansa',
		'MA035310513' => 'Moulay Abdelkrim',
		'MA035310515' => 'Moulay Bouchta',
		'MA035310517' => 'Sidi El Abed',
		'MA035310701' => 'Ain Mediouna',
		'MA035310703' => 'Bni Oulid',
		'MA035310705' => 'Bni Ounjel Tafraout',
		'MA035310707' => 'Bouadel',
		'MA035310709' => 'Bouhouda',
		'MA035310711' => 'Fennassa Bab El Hit',
		'MA035310713' => 'Khlalfa',
		'MA035310715' => 'Mezraoua',
		'MA035310717' => 'Rghioua',
		'MA035310719' => 'Tamedit',
		'MA035310721' => 'Zrizer',
		'MA035310901' => 'Ain Aicha',
		'MA035310903' => 'Ain Legdah',
		'MA035310905' => 'Ain Maatouf',
		'MA035310907' => 'Bouarouss',
		'MA035310909' => 'El Bsabsa',
		'MA035310911' => 'Messassa',
		'MA035310913' => 'Oued Jemaa',
		'MA035310915' => 'Oulad Ayyad',
		'MA035310917' => 'Oulad Daoud',
		'MA035310919' => 'Outabouabane',
		'MA035310921' => 'Ras El Oued',
		'MA035310923' => 'Sidi MHamedBen Lahcen',
		'MA035610101' => 'Aknoul',
		'MA035610105' => 'Oued Amlil',
		'MA035610107' => 'Tahla',
		'MA035610111' => 'Taza',
		'MA035610301' => 'Ajdir',
		'MA035610303' => 'Bourd',
		'MA035610305' => 'Gzenaya Al Janoubia',
		'MA035610307' => 'Jbarna',
		'MA035610309' => 'Sidi Ali Bourakba',
		'MA035610311' => 'Tizi Ouasli',
		'MA035610701' => 'Bni Frassen',
		'MA035610703' => 'Bouchfaa',
		'MA035610705' => 'Bouhlou',
		'MA035610707' => 'Ghiata Al Gharbia',
		'MA035610709' => 'Oulad Zbair',
		'MA035610711' => 'Rbaa El Fouki',
		'MA035610901' => 'Ait Saghrouchen',
		'MA035610903' => 'Bouyablane',
		'MA035610907' => 'Matmata',
		'MA035610909' => 'Smià',
		'MA035610911' => 'Tazarine',
		'MA035610913' => 'Zrarda',
		'MA035611101' => 'Bni Ftah',
		'MA035611103' => 'Brarha',
		'MA035611105' => 'El Gouzate',
		'MA035611107' => 'Kaf El Ghar',
		'MA035611109' => 'Msila',
		'MA035611111' => 'Taifa',
		'MA035611113' => 'Tainaste',
		'MA035611115' => 'Traiba',
		'MA035611301' => 'Bab Boudir',
		'MA035611303' => 'Bab Marzouka',
		'MA035611305' => 'Bni Lent',
		'MA035611307' => 'Galdamane',
		'MA035611309' => 'Meknassa Acharqia',
		'MA035611311' => 'Meknassa Al Gharbia',
		'MA035611313' => 'Oulad Chrif',
		'MA035611315' => 'Maghraoua',
		'MA035910101' => 'Moulay Yacoub',
		'MA035910301' => 'Ain Chkef',
		'MA035910303' => 'Mikkes',
		'MA035910305' => 'Sebaa Rouadi',
		'MA035910307' => 'Sebt Loudaya',
		'MA035910501' => 'Ain Bou Ali',
		'MA035910502' => 'Ain Kansra',
		'MA035910503' => 'Laajajra',
		'MA035910505' => 'Louadaine',
		'MA035910507' => 'Oulad Mimoun',
		'MA035910509' => 'Sidi Daoud',
	],
	'MA04' => [
		'MA042810101' => 'Kénitra',
		'MA042810105' => 'Mehdya',
		'MA042810111' => 'Souk El Arbaa',
		'MA042810301' => 'Ameur Seflia',
		'MA042810305' => 'Haddada',
		'MA042810311' => 'Ouled Slama',
		'MA042810313' => 'Sidi Taibi',
		'MA042810503' => 'Ben Mansour',
		'MA042810507' => 'Mnasra',
		'MA042810509' => 'Mograne',
		'MA042810511' => 'Sidi Mohamed Ben Mansour',
		'MA042810701' => 'Arbaoua',
		'MA042810703' => 'Beni Malek',
		'MA042810705' => 'Kariat Ben Aouda',
		'MA042810707' => 'Oued El Makhazine',
		'MA042810901' => 'Bahhara Ouled Ayad',
		'MA042810909' => 'Sidi Allal Tazi',
		'MA042810913' => 'Sidi Mohamed Lahmar',
		'MA042810915' => 'Souk Tlet El Gharb',
		'MA042811103' => 'Chouafaa',
		'MA042811105' => 'Lalla Mimouna',
		'MA042811107' => 'Moulay Bousselham',
		'MA042811111' => 'Sidi Boubker El Haj',
		'MA042910101' => 'Khémisset',
		'MA042910103' => 'Rommani',
		'MA042910105' => 'Tiflet',
		'MA042910117' => 'Sidi Allal El Bahraoui',
		'MA042910301' => 'Ait Mimoune',
		'MA042910303' => 'Ait Ouribel',
		'MA042910305' => 'Ait Siberne',
		'MA042910307' => 'Ait Yadine',
		'MA042910309' => 'El Ganzra',
		'MA042910311' => 'Majmaa Tolba',
		'MA042910313' => 'Sfassif',
		'MA042910315' => 'Sidi Allal Lamsadder',
		'MA042910317' => 'Sidi El Ghandour',
		'MA042910501' => 'Ait Ichou',
		'MA042910503' => 'Ait Ikkou',
		'MA042910505' => 'Bouqachmir',
		'MA042910507' => 'Houderrane',
		'MA042910509' => 'Maaziz',
		'MA042910511' => 'Oulmes',
		'MA042910513' => 'Tiddas',
		'MA042910701' => 'Ain Sbit',
		'MA042910705' => 'Brachoua',
		'MA042910707' => 'Ezzhiliga',
		'MA042910709' => 'Jemaat Moul Blad',
		'MA042910711' => 'Laghoualem',
		'MA042910713' => 'Marchouch',
		'MA042910715' => 'Moulay Driss Aghbal',
		'MA042910902' => 'Ain Johra -Sidi Boukhalkhal',
		'MA042910903' => 'Ait Belkacem',
		'MA042910905' => 'Ait Buyahya El Hajjama',
		'MA042910907' => 'Ait Malek',
		'MA042910909' => 'Khemis Sidi Yahya',
		'MA042910911' => 'Mqam Tolba',
		'MA042910913' => 'Sidi Abderrazak',
		'MA042910919' => 'Ait Ali ou Lahcen',
		'MA044210101' => 'Agdal Riyad',
		'MA044210103' => 'El Youssoufia',
		'MA044210105' => 'Hassan',
		'MA044210106' => 'Souissi',
		'MA044210107' => 'Touarga',
		'MA044210109' => 'Yacoub El Mansour',
		'MA044410103' => 'Bab Lamrissa',
		'MA044410105' => 'Bettana',
		'MA044410106' => 'Hssaine',
		'MA044410107' => 'Layayda',
		'MA044410108' => 'Sidi Bouknadel',
		'MA044410109' => 'Tabriquet',
		'MA044410301' => 'Shoul',
		'MA044410305' => 'Ameur',
		'MA044810101' => 'Dar Gueddari',
		'MA044810103' => 'Had Kourt',
		'MA044810105' => 'Jorf El Melha',
		'MA044810107' => 'Mechraa Bel Ksiri',
		'MA044810111' => 'Sidi Kacem',
		'MA044810301' => 'Ain Dfali',
		'MA044810303' => 'Bni Oual',
		'MA044810309' => 'Moulay Abdelkader',
		'MA044810313' => 'Sidi Ahmed Benaissa',
		'MA044810315' => 'Sidi Ameur Al Hadi',
		'MA044810317' => 'Sidi Azzouz',
		'MA044810501' => 'Al Haouafate',
		'MA044810507' => 'Nouirate',
		'MA044810509' => 'Sefsaf',
		'MA044810705' => 'Khnichet',
		'MA044810707' => 'Lamrabih',
		'MA044810711' => 'Oulad Nouel',
		'MA044810719' => 'Sidi MHamed Chelh',
		'MA044810721' => 'Taoughilt',
		'MA044810901' => 'Bab Tiouka',
		'MA044810903' => 'Bir Taleb',
		'MA044810905' => 'Chbanate',
		'MA044810907' => 'Selfat',
		'MA044810909' => 'Tekna',
		'MA044810911' => 'Zaggota',
		'MA044810913' => 'Zirara',
		'MA044811103' => 'Dar Laaslouji',
		'MA044811105' => 'Rmilat',
		'MA044811111' => 'Sidi Al Kamel',
		'MA044910107' => 'Sidi Slimane',
		'MA044910109' => 'Sidi Yahya El Gharb',
		'MA044910307' => 'Kceibya',
		'MA044910315' => 'Sfafaa',
		'MA044910317' => 'Ameur Chamalia',
		'MA044910501' => 'Azghar',
		'MA044910503' => 'Boumaiz',
		'MA044910505' => 'Dar Bel Amri',
		'MA044910509' => 'Msaada',
		'MA044910511' => 'Ouled Ben Hammadi',
		'MA044910513' => 'Ouled HCine',
		'MA045010101' => 'Ain El Aouda',
		'MA045010103' => 'Harhoura',
		'MA045010105' => 'Skhirate',
		'MA045010107' => 'Témara',
		'MA045010109' => 'Ain Attig',
		'MA045010301' => 'El Menzeh',
		'MA045010303' => 'Oumazza',
		'MA045010311' => 'Sidi Yahya Zaer',
		'MA045010503' => 'Mers El Kheir',
		'MA045010505' => 'Sabbah',
	],
	'MA05' => [		
		'MA050810101' => 'Azilal',
		'MA050810103' => 'Demnate',
		'MA050810301' => 'Agoudi NLkhair',
		'MA050810303' => 'Ait Abbas',
		'MA050810305' => 'Ait Bou Oulli',
		'MA050810307' => 'Ait MHamed',
		'MA050810309' => 'Tabant',
		'MA050810311' => 'Tamda Noumercid',
		'MA050810313' => 'Zaouiat Ahansal',
		'MA050810501' => 'Ait Taguella',
		'MA050810505' => 'Bni Hassane',
		'MA050810507' => 'Bzou',
		'MA050810509' => 'Foum Jemaa',
		'MA050810511' => 'Moulay Aissa Ben Driss',
		'MA050810513' => 'Rfala',
		'MA050810515' => 'Tabia',
		'MA050810517' => 'Tanant',
		'MA050810519' => 'Taounza',
		'MA050810521' => 'Tisqi',
		'MA050810903' => 'Ait Mazigh',
		'MA050810907' => 'Ait Ouqabli',
		'MA050810909' => 'Anergui',
		'MA050810911' => 'Bin El Ouidane',
		'MA050810913' => 'Isseksi',
		'MA050810915' => 'Ouaouizeght',
		'MA050810917' => 'Tabaroucht',
		'MA050810919' => 'Tagleft',
		'MA050810921' => 'Tiffert NAit Hamza',
		'MA050810923' => 'Tilougguite',
		'MA050811101' => 'Afourar',
		'MA050811103' => 'Bni Ayat',
		'MA050811105' => 'Ait Ouaarda',
		'MA050811125' => 'Timoulilt',
		'MA050811305' => 'Ait Oumdis',
		'MA050811307' => 'Ait Tamlil',
		'MA050811309' => 'Anzou',
		'MA050811317' => 'Sidi Yacoub',
		'MA050811319' => 'Tidili Fetouaka',
		'MA050811501' => 'Ait Blal',
		'MA050811503' => 'Ait Majden',
		'MA050811511' => 'Imlil',
		'MA050811513' => 'Ouaoula',
		'MA050811515' => 'Sidi Boulkhalf',
		'MA050811521' => 'Tifni',
		'MA050910101' => 'Béni Mellal',
		'MA050910103' => 'El Ksiba',
		'MA050910107' => 'Kasba Tadla',
		'MA050910113' => 'Zaouiat Cheikh',
		'MA050910301' => 'Foum Oudi',
		'MA050910303' => 'Ouled Gnaou',
		'MA050910305' => 'Ouled MBarek',
		'MA050910307' => 'Ouled Yaich',
		'MA050910309' => 'Sidi Jaber',
		'MA050910311' => 'Foum El Anceur',
		'MA050910501' => 'Aghbala',
		'MA050910505' => 'Boutferda',
		'MA050910517' => 'Tizi NIsly',
		'MA050910703' => 'Ait Oum El Bekht',
		'MA050910707' => 'Dir El Ksiba',
		'MA050910711' => 'Naour',
		'MA050910713' => 'Taghzirt',
		'MA050910715' => 'Tanougha',
		'MA050911101' => 'Guettaya',
		'MA050911103' => 'Ouled Youssef',
		'MA050911105' => 'Ouled Said LOued',
		'MA050911107' => 'Semguet',
		'MA052550105' => 'Fquih Ben Salah',
		'MA052550109' => 'Ouled Ayad',
		'MA052550111' => 'Souk Sebt Ouled Nemma',
		'MA052550505' => 'Ouled Bourahmoune',
		'MA052550509' => 'Ouled Zmam',
		'MA052550511' => 'Sidi Aissa Ben Ali',
		'MA052550513' => 'Sidi Hammadi',
		'MA052550901' => 'Khalfia',
		'MA052550903' => 'Bni Chegdale',
		'MA052550905' => 'Bni Oukil',
		'MA052550907' => 'Bradia',
		'MA052550909' => 'Hel Merbaa',
		'MA052550911' => 'Krifate',
		'MA052551101' => 'Dar Ould Zidouh',
		'MA052551103' => 'Had Boumoussa',
		'MA052551107' => 'Ouled Nacer',
		'MA053010101' => 'Khenifra',
		'MA053010105' => 'MRirt',
		'MA053010301' => 'Ait Ishaq',
		'MA053010303' => 'Ait Saadelli',
		'MA053010305' => 'El Kbab',
		'MA053010307' => 'Kerrouchen',
		'MA053010309' => 'Ouaoumana',
		'MA053010311' => 'Sidi Yahya Ou Saad',
		'MA053010313' => 'Tighassaline',
		'MA053010501' => 'Aguelmam Azegza',
		'MA053010505' => 'El Borj',
		'MA053010511' => 'Lehri',
		'MA053010513' => 'Moha Ou Hammou Zayani',
		'MA053010521' => 'Sidi Amar',
		'MA053010525' => 'Sidi Lamine',
		'MA053010703' => 'Aguelmous',
		'MA053010707' => 'El Hammam',
		'MA053010709' => 'Had Bouhssoussen',
		'MA053010715' => 'Moulay Bouazza',
		'MA053010717' => 'Oum Rabia',
		'MA053010719' => 'Sebt Ait Rahou',
		'MA053010723' => 'Sidi Hcine',
		'MA053110101' => 'Bejaad',
		'MA053110103' => 'Boujniba',
		'MA053110105' => 'Hattane',
		'MA053110107' => 'Khouribga',
		'MA053110109' => 'Oued Zem',
		'MA053110301' => 'Ain Kaicher',
		'MA053110303' => 'Bni Bataou',
		'MA053110305' => 'Bni Zrantel',
		'MA053110307' => 'Boukhrisse',
		'MA053110309' => 'Chougrane',
		'MA053110311' => 'Oulad Gouaouch',
		'MA053110313' => 'Rouached',
		'MA053110315' => 'Tachraft',
		'MA053110501' => 'Bir Mezoui',
		'MA053110503' => 'Bni Ykhlef',
		'MA053110505' => 'Bulanouare',
		'MA053110507' => 'Lagfaf',
		'MA053110509' => 'El Foqra',
		'MA053110511' => 'MFassis',
		'MA053110513' => 'Oulad Abdoune',
		'MA053110515' => 'Oulad Azzouz',
		'MA053110701' => 'Ait Ammar',
		'MA053110703' => 'Bni Smir',
		'MA053110705' => 'Braksa',
		'MA053110707' => 'Kasbat Troch',
		'MA053110709' => 'Lagnadiz',
		'MA053110711' => 'Maadna',
		'MA053110713' => 'Oulad Aissa',
		'MA053110715' => 'Oulad Boughadi',
		'MA053110717' => 'Oulad Fennane',
		'MA053110719' => 'Oulad Ftata',
	],
	'MA06' => [
		'MA061110101' => 'Benslimane',
		'MA061110103' => 'Bouznika',
		'MA061110105' => 'El Mansouria',
		'MA061110301' => 'Ahlaf',
		'MA061110303' => 'Ain Tizgha',
		'MA061110305' => 'Fdalate',
		'MA061110307' => 'Mellila',
		'MA061110311' => 'Moualine El Oued',
		'MA061110313' => 'Oulad Ali Toualaa',
		'MA061110315' => 'Oulad Yahya Louta',
		'MA061110317' => 'Rdadna Oulad Malek',
		'MA061110319' => 'Ziaida',
		'MA061110501' => 'Bir Ennasr',
		'MA061110504' => 'Sidi Bettache',
		'MA061110505' => 'Charrate',
		'MA061170103' => 'Berrechid',
		'MA061170105' => 'Deroua',
		'MA061170107' => 'El Gara',
		'MA061170109' => 'Had Soualem',
		'MA061170111' => 'Oulad Abbou',
		'MA061170113' => 'Sidi Rahal Chatai',
		'MA061170501' => 'Ben Maachou',
		'MA061170511' => 'Laghnimyine',
		'MA061170513' => 'Lahsasna',
		'MA061170525' => 'Sahel Oulad HRiz',
		'MA061170527' => 'Sidi Abdelkhaleq',
		'MA061170529' => 'Sidi El Mekki',
		'MA061170533' => 'Soualem Trifiya',
		'MA061170535' => 'Zaouiat Sidi Ben Hamdoun',
		'MA061170805' => 'Foqra Oulad Aameur',
		'MA061170807' => 'Jaqma',
		'MA061170809' => 'Kasbat Ben Mchich',
		'MA061170817' => 'Lambarkiyine',
		'MA061170819' => 'Ouled Cebbah',
		'MA061170820' => 'Oulad Ziyane',
		'MA061170821' => 'Ouled Zidane',
		'MA061170823' => 'Riah',
		'MA061410101' => 'Anfa',
		'MA061410103' => 'El Maarif',
		'MA061410107' => 'Sidi Belyout',
		'MA061410111' => 'Al-Fida',
		'MA061410113' => 'Mers-Sultan',
		'MA061410121' => 'Aîn-Sebaâ',
		'MA061410123' => 'Assoukhour Assawda',
		'MA061410125' => 'Hay Mohammadi',
		'MA061410131' => 'Hay-Hassani',
		'MA061410141' => 'Aîn-Chock',
		'MA061410151' => 'Sidi Bernoussi',
		'MA061410153' => 'Sidi Moumen',
		'MA061410161' => 'Ben MSick',
		'MA061410163' => 'Sbata',
		'MA061410171' => 'Moulay Rachid',
		'MA061410173' => 'Sidi Othmane',
		'MA061410181' => 'Mechouar de Casablanca',
		'MA061810101' => 'Azemmour',
		'MA061810103' => 'El Jadida',
		'MA061810105' => 'Lbir Jdid',
		'MA061810301' => 'Chtouka',
		'MA061810305' => 'Laghdira',
		'MA061810307' => 'Lamharza Essahel',
		'MA061810311' => 'Sidi Ali Ben Hamdouche',
		'MA061810501' => 'My Abdellah',
		'MA061810503' => 'Oulad Aissa',
		'MA061810505' => 'Ouled Ghanem',
		'MA061810507' => 'Ouled Hcine',
		'MA061810509' => 'Sidi Abed',
		'MA061810511' => 'Sidi MHamed Akhdim',
		'MA061810703' => 'Haouzia',
		'MA061810709' => 'Oulad Rahmoune',
		'MA061810901' => 'Boulaouane',
		'MA061810903' => 'Chaibate',
		'MA061810905' => 'Mettouh',
		'MA061810907' => 'Mogress',
		'MA061810909' => 'Oulad Hamdane',
		'MA061810911' => 'Oulad Sidi Ali Ben Youssef',
		'MA061810913' => 'Ouled Frej',
		'MA061810915' => 'Sebt Saiss',
		'MA061810917' => 'Si Hsaien Ben Abderrahmane',
		'MA061810919' => 'Sidi Smail',
		'MA061810921' => 'Zaouiat Saiss',
		'MA061810923' => 'Zaouiat Lakouacem',
		'MA063550101' => 'Lahraouyine',
		'MA063550103' => 'Mediouna',
		'MA063550105' => 'Tit Mellil',
		'MA063550301' => 'Al Majjatia Oulad Taleb',
		'MA063550305' => 'Sidi Hajjaj Oued Hassar',
		'MA063710101' => 'Mohammadia',
		'MA063710103' => 'Ain Harrouda',
		'MA063710301' => 'Bni Yakhlef',
		'MA063710303' => 'Ech-challalate',
		'MA063710305' => 'Sidi Moussa Ben Ali',
		'MA063710307' => 'Sidi Moussa Majdoub',
		'MA063850101' => 'Bouskoura',
		'MA063850102' => 'Dar Bouazza',
		'MA063850103' => 'Nouaceur',
		'MA063850303' => 'Oulad Azzouz',
		'MA063850305' => 'Oulad Salah',
		'MA064610101' => 'Ben Ahmed',
		'MA064610105' => 'El Borouj',
		'MA064610109' => 'Loulad',
		'MA064610113' => 'Oulad MRah',
		'MA064610115' => 'Settat',
		'MA064610302' => 'Ain Dorbane-Lahlaf',
		'MA064610303' => 'Bouguargouh',
		'MA064610307' => 'Lakhzazra',
		'MA064610309' => 'Mniaa',
		'MA064610311' => 'Mrizigue',
		'MA064610313' => 'MGarto',
		'MA064610315' => 'NKhila',
		'MA064610317' => 'Oued Naanaa',
		'MA064610319' => 'Oulad Chbana',
		'MA064610321' => 'Oulad Fares',
		'MA064610323' => 'Oulad MHamed',
		'MA064610325' => 'Ras El Ain Chaouia',
		'MA064610327' => 'Sgamna',
		'MA064610329' => 'Sidi Abdelkrim',
		'MA064610331' => 'Sidi Dahbi',
		'MA064610333' => 'Sidi Hajjaj',
		'MA064610701' => 'Ain Blal',
		'MA064610703' => 'Bni Khloug',
		'MA064610705' => 'Dar Chaffai',
		'MA064610707' => 'Laqraqra',
		'MA064610709' => 'Meskoura',
		'MA064610711' => 'Oulad Amer',
		'MA064610713' => 'Oulad Bouali Nouaja',
		'MA064610715' => 'Oulad Fares El Halla',
		'MA064610717' => 'Oulad Freiha',
		'MA064610719' => 'Sidi Ahmed El Khadir',
		'MA064610721' => 'Sidi Boumehdi',
		'MA064610903' => 'Bni Yagrine',
		'MA064610905' => 'Gdana',
		'MA064610907' => 'Guisser',
		'MA064610909' => 'Khemisset Chaouia',
		'MA064610911' => 'Lahouaza',
		'MA064610913' => 'Machraa Ben Abbou',
		'MA064610914' => 'Mzamza Janoubia',
		'MA064610915' => 'Mzoura',
		'MA064610919' => 'Oulad Said',
		'MA064610921' => 'Oulad Sghir',
		'MA064610923' => 'Rima',
		'MA064610925' => 'Sidi El Aidi',
		'MA064610927' => 'Sidi Mohammed Ben Rahal',
		'MA064610931' => 'Toualet',
		'MA064670107' => 'Sidi Bennour',
		'MA064670109' => 'Zemamra',
		'MA064670701' => 'Bni Hilal',
		'MA064670703' => 'Bni Tsiriss',
		'MA064670705' => 'Bouhmame',
		'MA064670707' => 'Jabria',
		'MA064670709' => 'Khmis Ksiba',
		'MA064670711' => 'Koudiat Bni Dghough',
		'MA064670713' => 'Kridid',
		'MA064670715' => 'Laagagcha',
		'MA064670717' => 'Laamria',
		'MA064670719' => 'Laaounate',
		'MA064670721' => 'Laatatra',
		'MA064670723' => 'Lmechrek',
		'MA064670725' => 'Metrane',
		'MA064670727' => 'MTal',
		'MA064670729' => 'Oulad Amrane',
		'MA064670731' => 'Oulad Boussaken',
		'MA064670733' => 'Oulad Si Bouhya',
		'MA064670735' => 'Tamda',
		'MA064671101' => 'Laghnadra',
		'MA064671103' => 'Lgharbia',
		'MA064671105' => 'Loualidia',
		'MA064671107' => 'Oulad Sbaita',
		'MA064671109' => 'Saniat Berguig',
	],
	'MA07' => [		
		'MA070410101' => 'Ait Ourir',
		'MA070410103' => 'Amizmiz',
		'MA070410109' => 'Tahannaout',
		'MA070410305' => 'Ait Faska',
		'MA070410309' => 'Ait Sidi Daoud',
		'MA070410311' => 'Ghmate',
		'MA070410313' => 'Iguerferouane',
		'MA070410315' => 'Sidi Abdallah Ghiat',
		'MA070410319' => 'Tamazouzte',
		'MA070410323' => 'Tidili Mesfioua',
		'MA070410501' => 'Amghras',
		'MA070410505' => 'Anougal',
		'MA070410507' => 'Azgour',
		'MA070410509' => 'Dar Jamaa',
		'MA070410511' => 'Lalla Takarkoust',
		'MA070410513' => 'Ouazguita',
		'MA070410515' => 'Oulad Mtaa',
		'MA070410517' => 'Sidi Badhaj',
		'MA070410519' => 'Tizguine',
		'MA070410701' => 'Aghbar',
		'MA070410703' => 'Asni',
		'MA070410705' => 'Ighil',
		'MA070410707' => 'Ijoukak',
		'MA070410709' => 'Imgdal',
		'MA070410711' => 'Ouirgane',
		'MA070410713' => 'Talat NYaaqoub',
		'MA070410901' => 'Moulay Brahim',
		'MA070410903' => 'Oukaimden',
		'MA070410905' => 'Ourika',
		'MA070410907' => 'Sti Fadma',
		'MA070410911' => 'Tameslohte',
		'MA070410913' => 'Aghouatim',
		'MA070411101' => 'Abadou',
		'MA070411103' => 'Ait Aadel',
		'MA070411107' => 'Ait Hkim-Ait Yzid',
		'MA070411117' => 'Tamaguert',
		'MA070411121' => 'Tazart',
		'MA070411125' => 'Tighedouine',
		'MA070411127' => 'Touama',
		'MA070411129' => 'Zerkten',
		'MA071610101' => 'Chichaoua',
		'MA071610103' => 'Imintanoute',
		'MA071610301' => 'Ahdil',
		'MA071610303' => 'Ait Hadi',
		'MA071610305' => 'Lamzoudia',
		'MA071610307' => 'Oulad Moumna',
		'MA071610309' => 'Saidate',
		'MA071610311' => 'Sid LMokhtar',
		'MA071610313' => 'Sidi Bouzid Arragragui',
		'MA071610315' => 'Sidi MHamed Dalil',
		'MA071610501' => 'Afalla Issen',
		'MA071610503' => 'Ain Tazitounte',
		'MA071610505' => 'Ait Haddou Youssef',
		'MA071610507' => 'Irohalen',
		'MA071610509' => 'Lalla Aaziza',
		'MA071610511' => 'Nfifa',
		'MA071610513' => 'Ouad Lbour',
		'MA071610515' => 'Sidi Ghanem',
		'MA071610517' => 'Timezgadiouine',
		'MA071610701' => 'Adassil',
		'MA071610703' => 'Assif El Mal',
		'MA071610705' => 'Douirane',
		'MA071610707' => 'Gmassa',
		'MA071610709' => 'Imindounit',
		'MA071610711' => 'Majjat',
		'MA071610713' => 'MZouda',
		'MA071610715' => 'Zaouia Annahlia',
		'MA071610901' => 'Bouabout',
		'MA071610903' => 'Bouabout Amdlane',
		'MA071610905' => 'Ichamraren',
		'MA071610907' => 'Kouzemt',
		'MA071610909' => 'Rahhala',
		'MA071610911' => 'Sidi Abdelmoumen',
		'MA071610913' => 'Taouloukoult',
		'MA071610915' => 'Timlilt',
		'MA071910103' => 'El Kelaâ des Sraghna',
		'MA071910105' => 'Laattaouia',
		'MA071910107' => 'Sidi Rahhal',
		'MA071910109' => 'Tamallalt',
		'MA071910301' => 'Chtaiba',
		'MA071910303' => 'Eddachra',
		'MA071910305' => 'El Aamria',
		'MA071910307' => 'El Marbouh',
		'MA071910309' => 'Errafiaya',
		'MA071910311' => 'Hiadna',
		'MA071910313' => 'Lounasda',
		'MA071910315' => 'Mayate',
		'MA071910317' => 'Oulad Aamer',
		'MA071910319' => 'Oulad Bouali Loued',
		'MA071910321' => 'Oulad Cherki',
		'MA071910323' => 'Oulad El Garne',
		'MA071910325' => 'Oulad Massaoud',
		'MA071910327' => 'Oulad Msabbel',
		'MA071910329' => 'Oulad Sbih',
		'MA071910331' => 'Oulad Yaacoub',
		'MA071910333' => 'Oulad Zarrad',
		'MA071910335' => 'Sidi El Hattab',
		'MA071910337' => 'Sidi Moussa',
		'MA071910339' => 'Taouzint',
		'MA071910341' => 'Znada',
		'MA071910501' => 'Assahrij',
		'MA071910503' => 'Bouya Omar',
		'MA071910505' => 'Choara',
		'MA071910507' => 'Dzouz',
		'MA071910509' => 'Fraita',
		'MA071910515' => 'Laatamna',
		'MA071910516' => 'Laattaouia Ech-chaibia',
		'MA071910517' => 'Louad Lakhdar',
		'MA071910519' => 'MZem Sanhaja',
		'MA071910521' => 'Ouargui',
		'MA071910523' => 'Oulad Aarrad',
		'MA071910525' => 'Oulad Khallouf',
		'MA071910527' => 'Sidi Aissa Ben Slimane',
		'MA071910529' => 'Sour El Aaz',
		'MA071910711' => 'Jbiel',
		'MA071910713' => 'Jouala',
		'MA071910731' => 'Zemrane',
		'MA071910733' => 'Zemrane Charqia',
		'MA072110101' => 'Ait Daoud',
		'MA072110103' => 'El Hanchane',
		'MA072110105' => 'Essaouira',
		'MA072110107' => 'Talmest',
		'MA072110109' => 'Tamanar',
		'MA072110301' => 'Ait Said',
		'MA072110303' => 'Aquermoud',
		'MA072110305' => 'Had Dra',
		'MA072110307' => 'Kechoula',
		'MA072110309' => 'Korimate',
		'MA072110311' => 'Lagdadra',
		'MA072110313' => 'Lahsinate',
		'MA072110315' => 'Mejji',
		'MA072110317' => 'Meskala',
		'MA072110319' => 'Mouarid',
		'MA072110321' => 'Moulay Bouzarqtoune',
		'MA072110323' => 'Mzilate',
		'MA072110325' => 'MKhalif',
		'MA072110327' => 'MRamer',
		'MA072110329' => 'Oulad MRabet',
		'MA072110331' => 'Ounagha',
		'MA072110333' => 'Sidi Abdeljalil',
		'MA072110335' => 'Sidi Aissa Regragui',
		'MA072110337' => 'Sidi Ali El Korati',
		'MA072110339' => 'Sidi Boulaalam',
		'MA072110341' => 'Sidi Ishaq',
		'MA072110343' => 'Sidi Laaroussi',
		'MA072110345' => 'Sidi MHamed Ou Marzouq',
		'MA072110347' => 'Tafetachte',
		'MA072110349' => 'Takate',
		'MA072110351' => 'Zaouiat Ben Hmida',
		'MA072110501' => 'Adaghas',
		'MA072110503' => 'Aglif',
		'MA072110505' => 'Aguerd',
		'MA072110507' => 'Ait Aissi Ihahane',
		'MA072110509' => 'Assais',
		'MA072110511' => 'Bizdad',
		'MA072110513' => 'Bouzemmour',
		'MA072110515' => 'Ezzaouite',
		'MA072110517' => 'Ida Ou Aazza',
		'MA072110519' => 'Ida Ou Guelloul',
		'MA072110521' => 'Ida Ou Kazzou',
		'MA072110523' => 'Imgrade',
		'MA072110525' => 'Imi NTlit',
		'MA072110527' => 'Sidi Ahmed Essayeh',
		'MA072110529' => 'Sidi El Jazouli',
		'MA072110531' => 'Sidi Ghaneme',
		'MA072110533' => 'Sidi HMad Ou MBarek',
		'MA072110535' => 'Sidi Hmad Ou Hamed',
		'MA072110537' => 'Sidi Kaouki',
		'MA072110539' => 'Smimou',
		'MA072110541' => 'Tafedna',
		'MA072110543' => 'Tahelouante',
		'MA072110545' => 'Takoucht',
		'MA072110547' => 'Targante',
		'MA072110549' => 'Tidzi',
		'MA072110551' => 'Timizguida-Ouftas',
		'MA073510101' => 'Méchouar-Kasba',
		'MA073510103' => 'Annakhil',
		'MA073510105' => 'Gueliz',
		'MA073510107' => 'Marrakech-Médina',
		'MA073510109' => 'Ménara',
		'MA073510111' => 'Sidi Youssef Ben Ali',
		'MA073510201' => 'Alouidane',
		'MA073510207' => 'Ouahat Sidi Brahim',
		'MA073510209' => 'Oulad Hassoune',
		'MA073510303' => 'Harbil',
		'MA073510305' => 'MNabha',
		'MA073510311' => 'Ouled Dlim',
		'MA073510501' => 'Agafay',
		'MA073510503' => 'Ait Imour',
		'MA073510505' => 'Loudaya',
		'MA073510509' => 'Sid Zouine',
		'MA073510707' => 'Saada',
		'MA073510711' => 'Souihla',
		'MA073510713' => 'Tassoultante',
		'MA074270101' => 'Ben Guerir',
		'MA074270117' => 'Sidi Bou Othmane',
		'MA074270701' => 'Ait Hammou',
		'MA074270703' => 'Ait Taleb',
		'MA074270705' => 'Bouchane',
		'MA074270707' => 'Jaafra',
		'MA074270709' => 'Labrikiyne',
		'MA074270711' => 'Oulad Aamer Tizmarine',
		'MA074270713' => 'Oulad Hassoune Hamri',
		'MA074270715' => 'Sidi Abdallah',
		'MA074270717' => 'Sidi Ali Labrahla',
		'MA074270719' => 'Sidi Ghanem',
		'MA074270721' => 'Sidi Mansour',
		'MA074270723' => 'Skhour Rehamna',
		'MA074270725' => 'Skoura Lhadra',
		'MA074270901' => 'Akarma',
		'MA074270903' => 'Bourrous',
		'MA074270905' => 'Jaidate',
		'MA074270906' => 'Jbilate',
		'MA074270907' => 'Lamharra',
		'MA074270909' => 'Nzalat Laadam',
		'MA074270911' => 'Oulad Imloul',
		'MA074270913' => 'Ras Ain Rhamna',
		'MA074270915' => 'Sidi Boubker',
		'MA074270919' => 'Tlauh',
		'MA074310103' => 'Safi',
		'MA074310109' => 'Jamaat Shaim',
		'MA074310111' => 'Sebt Gzoula',
		'MA074310301' => 'Bouguedra',
		'MA074310302' => 'Chahda',
		'MA074310303' => 'El Gouraani',
		'MA074310305' => 'Labkhati',
		'MA074310307' => 'Lahdar',
		'MA074310309' => 'Lamrasla',
		'MA074310311' => 'Lamsabih',
		'MA074310313' => 'Sidi Aissa',
		'MA074310315' => 'Sidi Ettiji',
		'MA074310701' => 'Atouabet',
		'MA074310703' => 'El Ghiate',
		'MA074310705' => 'Khatazakane',
		'MA074310707' => 'Laamamra',
		'MA074310709' => 'Lamaachate',
		'MA074310711' => 'Nagga',
		'MA074310713' => 'Ouled Salmane',
		'MA074310901' => 'Ayir',
		'MA074310903' => 'Dar Si Aissa',
		'MA074310905' => 'El Beddouza',
		'MA074310907' => 'Hrara',
		'MA074310909' => 'Moul El Bergui',
		'MA074310915' => 'Saadla',
		'MA075850107' => 'Echemmaia',
		'MA075850113' => 'Youssoufia',
		'MA075850507' => 'Ighoud',
		'MA075850509' => 'Jdour',
		'MA075850511' => 'Jnane Bouih',
		'MA075850517' => 'Sidi Chiker',
		'MA075850701' => 'Atiamim',
		'MA075850703' => 'El Gantour',
		'MA075850705' => 'Esbiaat',
		'MA075850713' => 'Lakhoualqa',
		'MA075850715' => 'Ras El Ain',
	],
	'MA08' => [
		'MA082010101' => 'Arfoud',
		'MA082010103' => 'Boudnib',
		'MA082010105' => 'Errachidia',
		'MA082010109' => 'Goulmima',
		'MA082010111' => 'Jorf',
		'MA082010113' => 'Moulay Ali Cherif',
		'MA082010115' => 'Tinejdad',
		'MA082010301' => 'Aarab Sebbah Gheris',
		'MA082010303' => 'Aarab Sebbah Ziz',
		'MA082010307' => 'Es-sifa',
		'MA082010309' => 'Fezna',
		'MA082010701' => 'Aoufous',
		'MA082010703' => 'Chorfa MDaghra',
		'MA082010705' => 'Er-rteb',
		'MA082010707' => 'Lkheng',
		'MA082010709' => 'Oued Naam',
		'MA082011101' => 'Bni MHamed-Sijelmassa',
		'MA082011103' => 'Er-rissani',
		'MA082011105' => 'Es-sfalat',
		'MA082011107' => 'Et-taous',
		'MA082011109' => 'Sidi Ali',
		'MA082011301' => 'Aghbalou NKerdous',
		'MA082011302' => 'Amellagou',
		'MA082011303' => 'Ferkla El Oulia',
		'MA082011305' => 'Ferkla Es-soufla',
		'MA082011307' => 'Gheris El Ouloui',
		'MA082011309' => 'Gheris Es-soufli',
		'MA082011311' => 'Melaab',
		'MA082011313' => 'Tadighoust',
		'MA083630103' => 'Midelt',
		'MA083630107' => 'Er-rich',
		'MA083630501' => 'Aghbalou',
		'MA083630503' => 'Agoudim',
		'MA083630513' => 'Anemzi',
		'MA083630515' => 'Boumia',
		'MA083630521' => 'Sidi Yahya Ou Youssef',
		'MA083630523' => 'Tanourdi',
		'MA083630525' => 'Tizi NGhachou',
		'MA083630527' => 'Tounfite',
		'MA083630705' => 'Ait Ayach',
		'MA083630707' => 'Ait Ben Yacoub',
		'MA083630709' => 'Ait Izdeg',
		'MA083630711' => 'Amersid',
		'MA083630717' => 'Itzer',
		'MA083630719' => 'Mibladen',
		'MA083630729' => 'Zaida',
		'MA083630901' => 'En-nzala',
		'MA083630903' => 'Gourrama',
		'MA083630905' => 'Guers Tiaallaline',
		'MA083630907' => 'Guir',
		'MA083630909' => 'MZizel',
		'MA083630911' => 'Sidi Aayad',
		'MA083630913' => 'Zaouiat Sidi Hamza',
		'MA083631501' => 'Ait Yahya',
		'MA083631503' => 'Amouguer',
		'MA083631505' => 'Bou Azmou',
		'MA083631507' => 'Imilchil',
		'MA083631509' => 'Outerbat',
		'MA084010107' => 'Ouarzazate',
		'MA084010109' => 'Taznakht',
		'MA084010301' => 'Ait Zineb',
		'MA084010303' => 'Amerzgane',
		'MA084010305' => 'Iznaguen',
		'MA084010307' => 'Ighrem NOugdal',
		'MA084010309' => 'Khouzama',
		'MA084010311' => 'Ouisselsate',
		'MA084010313' => 'Siroua',
		'MA084010315' => 'Telouet',
		'MA084010317' => 'Tidli',
		'MA084010701' => 'Ghassate',
		'MA084010703' => 'Idelsane',
		'MA084010705' => 'Imi NOulaoune',
		'MA084010707' => 'Skoura Ahl El Oust',
		'MA084010709' => 'Tarmigt',
		'MA084010711' => 'Toundoute',
		'MA085770103' => 'Boumalne Dades',
		'MA085770105' => 'Kalaat MGouna',
		'MA085770111' => 'Tinghir',
		'MA085770205' => 'Alnif',
		'MA085770211' => 'HSsyia',
		'MA085770221' => 'MSsici',
		'MA085770301' => 'Ait Hani',
		'MA085770305' => 'Assoul',
		'MA085770503' => 'Ait Ouassif',
		'MA085770505' => 'Ait Sedrate JbelEl Oulia',
		'MA085770507' => 'Ait Sedrate JbelEL Soufla',
		'MA085770509' => 'Ait Sedrate Sahl Charkia',
		'MA085770511' => 'Ait Sedrate Sahl El Gharbia',
		'MA085770513' => 'Ait Youl',
		'MA085770515' => 'Ighil NOumgoun',
		'MA085770517' => 'Ikniouen',
		'MA085770521' => 'MSemrir',
		'MA085770525' => 'Souk Lakhmis Dades',
		'MA085770529' => 'Tilmi',
		'MA085770701' => 'Ait El Farsi',
		'MA085770719' => 'Imider',
		'MA085770723' => 'Ouaklim',
		'MA085770727' => 'Taghzoute NAit Atta',
		'MA085770731' => 'Toudgha El Oulia',
		'MA085770733' => 'Toudgha Essoufla',
		'MA085870101' => 'Agdz',
		'MA085870113' => 'Zagora',
		'MA085870301' => 'Afella NDra',
		'MA085870303' => 'Afra',
		'MA085870305' => 'Ait Boudaoud',
		'MA085870307' => 'Ait Ouallal',
		'MA085870321' => 'Mezguita',
		'MA085870325' => 'NKob',
		'MA085870327' => 'Oulad Yahia Lagraire',
		'MA085870331' => 'Taghbalte',
		'MA085870337' => 'Tamezmoute',
		'MA085870339' => 'Tansifte',
		'MA085870341' => 'Tazarine',
		'MA085870709' => 'Bleida',
		'MA085870711' => 'Bni Zoli',
		'MA085870713' => 'Bouzeroual',
		'MA085870715' => 'Errouha',
		'MA085870729' => 'Taftechna',
		'MA085870743' => 'Ternata',
		'MA085870745' => 'Tinzouline',
		'MA085870917' => 'Fezouata',
		'MA085870919' => 'Ktaoua',
		'MA085870923' => 'MHamid El Ghizlane',
		'MA085870933' => 'Tagounite',
		'MA085870935' => 'Tamegroute',
	],
	'MA09' => [
		'MA090010101' => 'Agadir',
		'MA090010501' => 'Amskroud',
		'MA090010509' => 'Drargua',
		'MA090010511' => 'Idmine',
		'MA090010703' => 'Aourir',
		'MA090010705' => 'Aqesri',
		'MA090010707' => 'Aziar',
		'MA090010713' => 'Imouzzer',
		'MA090010715' => 'Imsouane',
		'MA090010721' => 'Tadrart',
		'MA090010723' => 'Taghazout',
		'MA090010725' => 'Tamri',
		'MA090010729' => 'Tiqqi',
		'MA091630103' => 'Ait Baha',
		'MA091630111' => 'Biougra',
		'MA091630305' => 'Ait Mzal',
		'MA091630307' => 'Ait Ouadrim',
		'MA091630309' => 'Aouguenz',
		'MA091630313' => 'Hilala',
		'MA091630315' => 'Ida Ougnidif',
		'MA091630325' => 'Sidi AbdallahEl Bouchouari',
		'MA091630333' => 'Tanalt',
		'MA091630335' => 'Targua Ntouchka',
		'MA091630337' => 'Tassegdelt',
		'MA091630339' => 'Tizi Ntakoucht',
		'MA091630503' => 'Ait Milk',
		'MA091630511' => 'Belfaa',
		'MA091630519' => 'Inchaden',
		'MA091630521' => 'Massa',
		'MA091630531' => 'Sidi Ouassay',
		'MA091630701' => 'Ait Amira',
		'MA091630717' => 'Imi Mqourn',
		'MA091630723' => 'Ouad Essafa',
		'MA091630727' => 'Sidi Bibi',
		'MA091630729' => 'Sidi Boushab',
		'MA092730105' => 'Ait Melloul',
		'MA092730113' => 'Dcheira El Jihadia',
		'MA092730115' => 'Inezgane',
		'MA092730117' => 'Lqliaa',
		'MA092730519' => 'Oulad Dahou',
		'MA092730527' => 'Temsia',
		'MA095410101' => 'Ait Iaaza',
		'MA095410102' => 'Aoulouz',
		'MA095410103' => 'El Guerdane',
		'MA095410105' => 'Irherm',
		'MA095410107' => 'Oulad Berhil',
		'MA095410109' => 'Oulad Teima',
		'MA095410111' => 'Taliouine',
		'MA095410113' => 'Taroudannt',
		'MA095410301' => 'Adar',
		'MA095410303' => 'Ait Abdallah',
		'MA095410305' => 'Amalou',
		'MA095410307' => 'Azaghar NIrs',
		'MA095410309' => 'Imaouen',
		'MA095410311' => 'Imi NTayart',
		'MA095410313' => 'Nihit',
		'MA095410315' => 'Oualqadi',
		'MA095410317' => 'Sidi Boaal',
		'MA095410319' => 'Sidi Mzal',
		'MA095410321' => 'Tabia',
		'MA095410323' => 'Tataoute',
		'MA095410325' => 'Tindine',
		'MA095410327' => 'Tisfane',
		'MA095410329' => 'Toufelaazt',
		'MA095410331' => 'Toumliline',
		'MA095410409' => 'Arazane',
		'MA095410413' => 'El Faid',
		'MA095410417' => 'Ida Ou Gailal',
		'MA095410421' => 'Ida Ougoummad',
		'MA095410423' => 'Igli',
		'MA095410425' => 'Igoudar Mnabha',
		'MA095410429' => 'Lamhara',
		'MA095410433' => 'Oulad Aissa',
		'MA095410435' => 'Ouneine',
		'MA095410439' => 'Sidi Abdellah Ou Said',
		'MA095410447' => 'Sidi Ouaaziz',
		'MA095410449' => 'Tafingoult',
		'MA095410453' => 'Talgjount',
		'MA095410459' => 'Tigouga',
		'MA095410461' => 'Tinzart',
		'MA095410467' => 'Tizi NTest',
		'MA095410469' => 'Toughmart',
		'MA095410501' => 'Ahl Ramel',
		'MA095410503' => 'Argana',
		'MA095410505' => 'Assads',
		'MA095410507' => 'Bigoudine',
		'MA095410509' => 'Eddir',
		'MA095410511' => 'El Koudia El Beida',
		'MA095410513' => 'Imilmaiss',
		'MA095410515' => 'Issen',
		'MA095410517' => 'Lagfifat',
		'MA095410519' => 'Lakhnafif',
		'MA095410521' => 'Lamhadi',
		'MA095410523' => 'Machraa El Ain',
		'MA095410525' => 'Sidi Ahmed Ou Amar',
		'MA095410527' => 'Sidi Boumoussa',
		'MA095410529' => 'Sidi Moussa Lhamri',
		'MA095410531' => 'Talmakante',
		'MA095410533' => 'Tidsi Nissendalene',
		'MA095410701' => 'Agadir Melloul',
		'MA095410703' => 'Ahl Tifnoute',
		'MA095410705' => 'Askaouen',
		'MA095410707' => 'Assaisse',
		'MA095410709' => 'Assaki',
		'MA095410711' => 'Azrar',
		'MA095410713' => 'Iguidi',
		'MA095410715' => 'Sidi Hsaine',
		'MA095410717' => 'Taouyalte',
		'MA095410719' => 'Tassousfi',
		'MA095410721' => 'Tizgzaouine',
		'MA095410723' => 'Toubkal',
		'MA095410725' => 'Zagmouzen',
		'MA095410737' => 'Ouzioua',
		'MA095410765' => 'Tisrasse',
		'MA095410901' => 'Ahmar Laglalcha',
		'MA095410903' => 'Ait Igas',
		'MA095410905' => 'Ait Makhlouf',
		'MA095410911' => 'Bounrar',
		'MA095410915' => 'Freija',
		'MA095410919' => 'Ida Ou Moumen',
		'MA095410927' => 'Imoulass',
		'MA095410931' => 'Lamnizla',
		'MA095410941' => 'Sidi Ahmed Ou Abdallah',
		'MA095410943' => 'Sidi Borja',
		'MA095410945' => 'Sidi Dahmane',
		'MA095410951' => 'Tafraouten',
		'MA095410955' => 'Tamaloukte',
		'MA095410957' => 'Tazemmourt',
		'MA095410963' => 'Tiout',
		'MA095410971' => 'Zaouia Sidi Tahar',
		'MA095510101' => 'Akka',
		'MA095510103' => 'Fam El Hisn',
		'MA095510105' => 'Foum Zguid',
		'MA095510107' => 'Tata',
		'MA095510301' => 'Ait Ouabelli',
		'MA095510303' => 'Kasbat Sidi Abdellah Ben MBarek',
		'MA095510305' => 'Tamanarte',
		'MA095510307' => 'Tizounine',
		'MA095510501' => 'Aguinane',
		'MA095510503' => 'Akka Ighane',
		'MA095510505' => 'Allougoum',
		'MA095510507' => 'Ibn Yacoub',
		'MA095510509' => 'Tissint',
		'MA095510511' => 'Tlite',
		'MA095510701' => 'Adis',
		'MA095510703' => 'Issafen',
		'MA095510705' => 'Oum El Guerdane',
		'MA095510707' => 'Tagmout',
		'MA095510709' => 'Tigzmerte',
		'MA095510711' => 'Tizaghte',
		'MA095810105' => 'Tafraout',
		'MA095810107' => 'Tiznit',
		'MA095810301' => 'Ait Issafen',
		'MA095810303' => 'Anzi',
		'MA095810305' => 'Arbaa Ait Ahmed',
		'MA095810307' => 'Ida Ou Gougmar',
		'MA095810309' => 'Sidi Ahmed Ou Moussa',
		'MA095810311' => 'Tafraout El Mouloud',
		'MA095810313' => 'Tighmi',
		'MA095810315' => 'Tizoughrane',
		'MA095810317' => 'Tnine Aday',
		'MA095810901' => 'Afella Ighir',
		'MA095810903' => 'Ait Ouafqa',
		'MA095810905' => 'Ammelne',
		'MA095810907' => 'Irigh NTahala',
		'MA095810909' => 'Tarsouat',
		'MA095810911' => 'Tassrirt',
		'MA095811101' => 'Arbaa Rasmouka',
		'MA095811103' => 'Arbaa Sahel',
		'MA095811105' => 'Bounaamane',
		'MA095811107' => 'El Maader El Kabir',
		'MA095811109' => 'Ouijjane',
		'MA095811111' => 'Reggada',
		'MA095811113' => 'Sidi Bouabdelli',
		'MA095811115' => 'Tnine Aglou',
	],
	'MA10' => [		
		'MA100710101' => 'Assa',
		'MA100710103' => 'Zag',
		'MA100710301' => 'Aouint Lahna',
		'MA100710303' => 'Aouint Yghomane',
		'MA100710305' => 'Touizgui',
		'MA100710501' => 'Al Mahbass',
		'MA100710503' => 'Labouirat',
		'MA102610101' => 'Bouizakarne',
		'MA102610103' => 'Guelmim',
		'MA102610301' => 'Aday',
		'MA102610303' => 'Ait Boufoulen',
		'MA102610305' => 'Amtdi',
		'MA102610307' => 'Ifrane Atlas Saghir',
		'MA102610309' => 'Tagante',
		'MA102610311' => 'Taghjijt',
		'MA102610313' => 'Timoulay',
		'MA102610503' => 'Aferkat',
		'MA102610505' => 'Asrir',
		'MA102610509' => 'Fask',
		'MA102610521' => 'Tiglit',
		'MA102610701' => 'Abaynou',
		'MA102610707' => 'Echatea El Abied',
		'MA102610711' => 'Labyar',
		'MA102610713' => 'Laqsabi Tagoust',
		'MA102610715' => 'Rass Oumlil',
		'MA102610717' => 'Taliouine Assaka',
		'MA102610719' => 'Targa Wassay',
		'MA104730101' => 'Lakhsas',
		'MA104730103' => 'Sidi Ifni',
		'MA104730501' => 'Arbaa Ait Abdellah',
		'MA104730503' => 'Imi NFast',
		'MA104730505' => 'Mesti',
		'MA104730507' => 'Mirleft',
		'MA104730509' => 'Sbouya',
		'MA104730511' => 'Tangarfa',
		'MA104730513' => 'Tioughza',
		'MA104730515' => 'Tnine Amellou',
		'MA104730701' => 'Ait Erkha',
		'MA104730703' => 'Anfeg',
		'MA104730705' => 'Boutrouch',
		'MA104730707' => 'Ibdar',
		'MA104730709' => 'Sebt Ennabour',
		'MA104730711' => 'Sidi AbdallahOu Belaid',
		'MA104730713' => 'Sidi HSaine Ou Ali',
		'MA104730715' => 'Sidi MBark',
		'MA104730717' => 'Tighirt',
		'MA105210101' => 'Tan Tan',
		'MA105210103' => 'El Ouatia',
		'MA105210301' => 'Msied',
		'MA105210303' => 'Tilemzoun',
		'MA105210501' => 'Abteh',
		'MA105210503' => 'Ben Khlil',
		'MA105210505' => 'Chbika',
	],
	'MA11' => [
		'MA111210101' => 'Boujdour',
		'MA111210301' => 'Gueltat Zemmour',
		'MA111210303' => 'Jraifia',
		'MA111210305' => 'Lamssid',
		'MA112210101' => 'Es-semara',
		'MA112210301' => 'Amgala',
		'MA112210303' => 'Haouza',
		'MA112210305' => 'Jdiriya',
		'MA112210307' => 'Sidi Ahmed Laaroussi',
		'MA112210309' => 'Tifariti',
		'MA113210101' => 'El Marsa',
		'MA113210103' => 'Laayoune',
		'MA113210301' => 'Boukraa',
		'MA113210303' => 'Dcheira',
		'MA113210305' => 'Foum El Oued',
		'MA115370105' => 'Tarfaya',
		'MA115370303' => 'Daoura',
		'MA115370305' => 'El Hagounia',
		'MA115370501' => 'Akhfennir',
		'MA115370507' => 'Tah',
	],
	'MA12' => [
		'MA120660103' => 'Lagouira',
		'MA120660303' => 'Aghouinite',
		'MA120660305' => 'Aousserd',
		'MA120660307' => 'Tichla',
		'MA120660309' => 'Zoug',
		'MA120660503' => 'Bir Gandouz',
		'MA123910101' => 'Dakhla',
		'MA123910501' => 'Bir Anzarane',
		'MA123910503' => 'Gleibat El Foula',
		'MA123910505' => 'Mijik',
		'MA123910507' => 'Oum Dreyga',
		'MA123910901' => 'El Argoub',
		'MA123910903' => 'Imlili',
	]
];
