<?php

/**
 * List of cities for: Lebanon
 * Source: https://www.libandata.org/en/article/list-lebanese-municipalities-may-2016
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'LBAK' => _x( 'Aakkâr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBBH' => _x( 'Baalbek-Hermel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBBI' => _x( 'Béqaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBAS' => _x( 'Liban-Nord', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBJA' => _x( 'Liban-Sud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBJL' => _x( 'Mont-Liban', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	'LBNA' => _x( 'Nabatîyé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'LBAK' => [
		'LBAABBOUDIYEH' => _x( 'Aabboudiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADBIL' => _x( 'Aadbil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAIDAMOUN_-_CHIKHLAR' => _x( 'Aaidamoun - Chikhlar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAIYAT' => _x( 'Aaiyat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAKKAR_EL_AATIQA' => _x( 'Aakkar El Aatiqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAMAIR_-_RAJM_AISSI' => _x( 'Aamair - Rajm Aissi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAMARET_EL_BAYKAT' => _x( 'Aamaret El Baykat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANDQET' => _x( 'Aandqet', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAOUADEH' => _x( 'Aaouadeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAOUAINAT_(AAKKAR)' => _x( 'Aaouainat (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARQA' => _x( 'Aarqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYOUN_(AAKKAR)' => _x( 'Aayoun (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYOUN_EL_GHIZLANE' => _x( 'Aayoun El Ghizlane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EL_ZEHAB' => _x( 'Ain El Zehab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EZ_ZAYT' => _x( 'Ain Ez Zayt', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_YAAQOUB' => _x( 'Ain Yaaqoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAKROUM' => _x( 'Akroum', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBANI_SAKHR' => _x( 'Bani Sakhr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEBNINE_-_AABDÉ' => _x( 'Bebnine - Aabdé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEINO_-_QBOULA' => _x( 'Beino - Qboula', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_AYOUB' => _x( 'Beit Ayoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_EL_HAJJ' => _x( 'Beit El Hajj', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_MELLAT' => _x( 'Beit Mellat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_YOUNES' => _x( 'Beit Younes', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBERBARA_(AAKKAR)' => _x( 'Berbara (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBERQAYEL' => _x( 'Berqayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEZBINA_(AAKKAR)' => _x( 'Bezbina (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBIREH_(AAKKAR)' => _x( 'Bireh (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_(AAKKAR)' => _x( 'Borj (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_EL_AARAB' => _x( 'Borj El Aarab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQERZLA' => _x( 'Bqerzla', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBZAL' => _x( 'Bzal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHADRA' => _x( 'Chadra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHANE' => _x( 'Chane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAQDOUF_(AAKKAR)' => _x( 'Chaqdouf (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHARBILA' => _x( 'Charbila', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEIKH_AAYACHE' => _x( 'Cheikh Aayache', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEIKH_MOHAMMAD' => _x( 'Cheikh Mohammad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEIKH_TABA' => _x( 'Cheikh Taba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAGHLEH' => _x( 'Daghleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAHR_EL_QANBAR' => _x( 'Dahr El Qanbar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAHR_LAISSINEH' => _x( 'Dahr Laissineh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAOURA_(AAKKAR)' => _x( 'Daoura (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAOUSSA_-_BAGHDADI' => _x( 'Daoussa - Baghdadi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_DALLOUM_-_ZOUQ_EL_MOQACHRINE' => _x( 'Deir Dalloum - Zouq El Moqachrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_JANNINE' => _x( 'Deir Jannine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDIBBABIYEH' => _x( 'Dibbabiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDOUAIR_AADOUIYEH' => _x( 'Douair Aadouiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFARDH' => _x( 'Fardh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFNAYDEQ' => _x( 'Fnaydeq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFSAQINE_-_AIN_AACHMA_-_AIN_TINTA' => _x( 'Fsaqine - Ain Aachma - Ain Tinta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHZAYLEH' => _x( 'Ghzayleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHALBA' => _x( 'Halba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAYSSA' => _x( 'Hayssa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAYTLA' => _x( 'Haytla', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAYZOUQ' => _x( 'Hayzouq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHICHI' => _x( 'Hichi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHMAIREH_(AAKKAR)' => _x( 'Hmaireh (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOUAICH' => _x( 'Houaich', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHRAR' => _x( 'Hrar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBILAT' => _x( 'Ilat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDET_(AAKKAR)' => _x( 'Jdaidet (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDET_EL_QAYTEAA' => _x( 'Jdaidet El Qayteaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJEBRAYEL' => _x( 'Jebrayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJERMNAIYA_-_EL_RAM' => _x( 'Jermnaiya - El Ram', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKARM_AASFOUR_-_BEIT_GHATTAS' => _x( 'Karm Aasfour - Beit Ghattas', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_TOUN' => _x( 'Kfar Toun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHAT_EL_BATROL' => _x( 'Khat El Batrol', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIRBET_CHAR' => _x( 'Khirbet Char', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIRBET_DAOUD_(AAKKAR)' => _x( 'Khirbet Daoud (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHREIBET_EJ_JINDI' => _x( 'Khreibet Ej Jindi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUACHRA' => _x( 'Kouachra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUCHA' => _x( 'Koucha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUEIKHAT' => _x( 'Koueikhat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKROUM_AARAB' => _x( 'Kroum Aarab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMACHHA' => _x( 'Machha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMACHTA_HAMMOUD' => _x( 'Machta Hammoud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMACHTA_HASSAN' => _x( 'Machta Hassan', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDALA' => _x( 'Majdala', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAR_TOUMA' => _x( 'Mar Touma', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMASSAAOUDIYEH' => _x( 'Massaaoudiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_BALDEH' => _x( 'Mazraat Baldeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMCHAYLHA' => _x( 'Mchaylha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMECHMECH_(AAKKAR)' => _x( 'Mechmech (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEMNEAA' => _x( 'Memneaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMHAMMARA_(AAKKAR)' => _x( 'Mhammara (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMINYARA' => _x( 'Minyara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMOUNJEZ' => _x( 'Mounjez', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMOUNSEH' => _x( 'Mounseh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMQAITAA_-_QAABRINE_-_KFAR_MELKI_-_RMOUL' => _x( 'Mqaitaa - Qaabrine - Kfar Melki - Rmoul', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMQAYBLEH' => _x( 'Mqaybleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAHRIYEH_-_BOUSTANE_EL_HERCH' => _x( 'Nahriyeh - Boustane El Herch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAOURA' => _x( 'Naoura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNFISSEH' => _x( 'Nfisseh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_EJ_JAMOUS' => _x( 'Ouadi Ej Jamous', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_EL_HAOUR' => _x( 'Ouadi El Haour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_KHALED' => _x( 'Ouadi Khaled', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQABAAIT' => _x( 'Qabaait', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQACHLAQ' => _x( 'Qachlaq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQANTARA_(AAKKAR)' => _x( 'Qantara (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARQAF' => _x( 'Qarqaf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQBAIYAT_(AAKKAR)' => _x( 'Qbaiyat (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQENIA' => _x( 'Qenia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQLEIAAT_(AAKKAR)' => _x( 'Qleiaat (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQORNEH_(AAKKAR)' => _x( 'Qorneh (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQOUBBET_CHAMRA' => _x( 'Qoubbet Chamra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQRAIYAT' => _x( 'Qraiyat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAHBEH' => _x( 'Rahbeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIHANIYEH_(AAKKAR)' => _x( 'Rihaniyeh (Aakkar)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRMAH' => _x( 'Rmah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAHLÉ' => _x( 'Sahlé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAYSSOUQ' => _x( 'Sayssouq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSFINET_ED_DRAYB' => _x( 'Sfinet Ed Drayb', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSFINET_EL_QAYTEAA' => _x( 'Sfinet El Qayteaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSINDIANET_ZEIDANE' => _x( 'Sindianet Zeidane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOUAISSET_AAKKAR' => _x( 'Souaisset Aakkar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTACHEAA' => _x( 'Tacheaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALL_AABBAS_ECH_CHARQI' => _x( 'Tall Aabbas Ech Charqi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALL_AABBAS_EL_GHARBI' => _x( 'Tall Aabbas El Gharbi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALL_BIREH' => _x( 'Tall Bireh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALL_MEAAYANE' => _x( 'Tall Meaayane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALLEH_-_CHATTAHA' => _x( 'Talleh - Chattaha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTIKRIT' => _x( 'Tikrit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTLEIL' => _x( 'Tleil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZOUARIB' => _x( 'Zouarib', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZOUQ_EL_HASSINEH' => _x( 'Zouq El Hassineh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZOUQ_HADDARA' => _x( 'Zouq Haddara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBBH' => [
		'LBAANSAR' => _x( 'Aansar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARSAL' => _x( 'Aarsal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYNATA_(BAALBEK)' => _x( 'Aaynata (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_(BAALBEK)' => _x( 'Ain (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAALBEK' => _x( 'Baalbek', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARQA' => _x( 'Barqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBECHOUAT' => _x( 'Bechouat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEDNAYEL_(BAALBEK)' => _x( 'Bednayel (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_CHAMA_-_AAQIDIYEH' => _x( 'Beit Chama - Aaqidiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_MCHAIKH' => _x( 'Beit Mchaikh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOUDAY_-_AALLAQ_ET_TELL' => _x( 'Bouday - Aallaq Et Tell', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBRITAL' => _x( 'Brital', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTEDAAI' => _x( 'Btedaai', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAAT' => _x( 'Chaat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHLIFA' => _x( 'Chlifa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHMISTAR_-_GHARBEH_BAALBEK' => _x( 'Chmistar - Gharbeh Baalbek', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EL_AHMAR' => _x( 'Deir El Ahmar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDOURIS' => _x( 'Douris', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFEKEHEH' => _x( 'Fekeheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFLAOUEH' => _x( 'Flaoueh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHADATH_(BAALBEK)' => _x( 'Hadath (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_BARADA' => _x( 'Haouch Barada', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_EN_NABI' => _x( 'Haouch En Nabi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_ER_RAFQA' => _x( 'Haouch Er Rafqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_SNAID' => _x( 'Haouch Snaid', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_TALL_SAFIYEH' => _x( 'Haouch Tall Safiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUR_TAALA_' => _x( 'Haour Taala ', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARBATA' => _x( 'Harbata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHIZZINE' => _x( 'Hizzine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHLABTA' => _x( 'Hlabta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIAAT' => _x( 'Iaat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJABBOULEH' => _x( 'Jabbouleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJEBAA' => _x( 'Jebaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJENTA' => _x( 'Jenta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_DANE_' => _x( 'Kfar Dane ', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHODR_(BAALBEK)' => _x( 'Khodr (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHREIBEH_(BAALBEK)' => _x( 'Khreibeh (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKNEISSEH_(BAALBEK)' => _x( 'Kneisseh (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLABOUEH' => _x( 'Laboueh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAARABOUN' => _x( 'Maaraboun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDALOUN' => _x( 'Majdaloun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAQNEH' => _x( 'Maqneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMASNAA_EZ_ZOHR' => _x( 'Masnaa Ez Zohr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_AL_SOUAYDANE' => _x( 'Mazraat Al Souaydane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_ER_REMASSA' => _x( 'Mazraat Er Remassa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_ET_TOUT' => _x( 'Mazraat Et Tout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_QOLD_ES_SABAAH' => _x( 'Mazraat Qold Es Sabaah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMOQRAQ' => _x( 'Moqraq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABHA_ED_DAMDOUM' => _x( 'Nabha Ed Damdoum', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABHA_EL_MEHFARA' => _x( 'Nabha El Mehfara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABHA_EL_QEDDAM' => _x( 'Nabha El Qeddam', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABHA_QLAYLEH_-_NABHA_HARFOUCH_' => _x( 'Nabha Qlayleh - Nabha Harfouch ', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABI_CHIT' => _x( 'Nabi Chit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABI_OSMANE' => _x( 'Nabi Osmane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAHLEH' => _x( 'Nahleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_FAARA' => _x( 'Ouadi Faara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAA_BAALBEK' => _x( 'Qaa Baalbek', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARHA_(BAALBEK)' => _x( 'Qarha (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQSARNABA' => _x( 'Qsarnaba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAM_-_JABANIYÉ' => _x( 'Ram - Jabaniyé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_BAALBEK' => _x( 'Ras Baalbek', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAAIDEH' => _x( 'Saaideh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSERRAAINE_EL_FAOUQA' => _x( 'Serraaine El Faouqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSERRAINE_ET_TAHTA' => _x( 'Serraine Et Tahta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALIA' => _x( 'Talia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAOUFIQIYEH' => _x( 'Taoufiqiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTARAYA' => _x( 'Taraya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAYBEH_(BAALBEK)' => _x( 'Taybeh (Baalbek)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTEMNINE_EL_FAOUQA' => _x( 'Temnine El Faouqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTEMNINE_ET_TAHTA' => _x( 'Temnine Et Tahta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYAMMOUNEH' => _x( 'Yammouneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYOUNINE' => _x( 'Younine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZABBOUD' => _x( 'Zabboud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZRAZIR' => _x( 'Zrazir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHARBINE_EL_HERMEL_' => _x( 'Charbine El Hermel ', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUAGHIR_ET_TAHTA_-_CHOUAGHIR_EL_FAOUQA' => _x( 'Chouaghir Et Tahta - Chouaghir El Faouqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFISSANE' => _x( 'Fissane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHERMEL' => _x( 'Hermel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUAR_EL_HACHICH' => _x( 'Jouar el Hachich', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUAKH' => _x( 'Kouakh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_SEJOUD_(HERMEL)' => _x( 'Mazraat Sejoud (Hermel)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQASR_(HERMEL)' => _x( 'Qasr (Hermel)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBBI' => [
		'LBAAMMIQ_(BEQAA_OUEST)' => _x( 'Aammiq (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANA' => _x( 'Aana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTANIT' => _x( 'Aaytanit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ET_TINEH_(BEQAA_OUEST)' => _x( 'Ain Et Tineh (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ZEBDEH' => _x( 'Ain Zebdeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAALOUL_(BEQAA_OUEST)' => _x( 'Baaloul (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAB_MAREAA' => _x( 'Bab Mareaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHAZZEH' => _x( 'Ghazzeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_EL_HARIMEH' => _x( 'Haouch El Harimeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUBB_JANNINE' => _x( 'Joubb Jannine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAMED_EL_LAOUZ' => _x( 'Kamed El Laouz', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKEFRAIYA_(BEQAA_OUEST)' => _x( 'Kefraiya (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIARA' => _x( 'Khiara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIRBET_QANAFAR' => _x( 'Khirbet Qanafar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLALA' => _x( 'Lala', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLIBBAYA' => _x( 'Libbaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMACHGHARA' => _x( 'Machghara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMANARA_-_HAMMARA' => _x( 'Manara - Hammara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMANSOURA_(BEQAA_OUEST)' => _x( 'Mansoura (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMARJ_(BEQAA_OUEST)' => _x( 'Marj (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAYDOUN_-_LOUSSIA' => _x( 'Maydoun - Loussia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARAAOUN' => _x( 'Qaraaoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQELAYA' => _x( 'Qelaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAOUDA' => _x( 'Raouda', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAGHBINE' => _x( 'Saghbine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAOUIRI' => _x( 'Saouiri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOHMOR' => _x( 'Sohmor', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOULTAN_YAAQOUB' => _x( 'Soultan Yaaqoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALL_ZNOUB' => _x( 'Tall Znoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYOHMOR_(BEQAA_OUEST)' => _x( 'Yohmor (Beqaa Ouest)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZILAYA' => _x( 'Zilaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAQABET_RACHAIYA' => _x( 'Aaqabet Rachaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYHA' => _x( 'Aayha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTA_EL_FOUKHAR' => _x( 'Aayta El Foukhar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_AARAB_(RACHAIYA)' => _x( 'Ain Aarab (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_AATA' => _x( 'Ain Aata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_HORCHEH' => _x( 'Ain Horcheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAKKA' => _x( 'Bakka', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAKKIFA_(RACHAIYA)' => _x( 'Bakkifa (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_LAHIA' => _x( 'Beit Lahia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBIREH_(RACHAIYA)' => _x( 'Bireh (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAHR_EL_AHMAR' => _x( 'Dahr El Ahmar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EL_AACHAYER' => _x( 'Deir El Aachayer', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAOUCH_EL_QINNAABEH_(RACHAIYA)' => _x( 'Haouch El Qinnaabeh (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHELOUEH_(RACHAIYA)' => _x( 'Heloueh (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAOUKABA_BOU_AARAB' => _x( 'Kaoukaba Bou Aarab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_DENIS' => _x( 'Kfar Denis', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_MICHKI' => _x( 'Kfar Michki', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_QOUQ' => _x( 'Kfar Qouq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIRBET_ROUHA' => _x( 'Khirbet Rouha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_BALHIS' => _x( 'Majdel Balhis', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMDOUKHA' => _x( 'Mdoukha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMHAIYDSEH_(RACHAIYA)' => _x( 'Mhaiydseh (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRACHAIYA' => _x( 'Rachaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAFID_(RACHAIYA)' => _x( 'Rafid (Rachaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTANNOURA' => _x( 'Tannoura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYANTA' => _x( 'Yanta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALI_EN_NAHRI' => _x( 'Aali en Nahri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANJAR_(HAOUCH_MOUSSA)' => _x( 'Aanjar (Haouch Moussa)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBABLAH' => _x( 'Ablah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_KFAR_ZABAD' => _x( 'Ain Kfar Zabad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARR_ELIAS' => _x( 'Barr Elias', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOUAREJ' => _x( 'Bouarej', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHTAURA' => _x( 'Chtaura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EL_GHAZAL' => _x( 'Deir El Ghazal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFOURZOL' => _x( 'Fourzol', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_EL_FIKANI' => _x( 'Haret El Fikani', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAZERTA' => _x( 'Hazerta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDITA' => _x( 'Jdita', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_ZABAD' => _x( 'Kfar Zabad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_AANJAR' => _x( 'Majdel Aanjar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAKSEH' => _x( 'Makseh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMASSA' => _x( 'Massa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMRAYJAT_(ZAHLEH)' => _x( 'Mrayjat (Zahleh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABI_AYLA' => _x( 'Nabi Ayla', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNASSRIYEH' => _x( 'Nassriyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNIHA_(ZAHLEH)' => _x( 'Niha (Zahleh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAA_ER_RIM' => _x( 'Qaa Er Rim', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQABB_ELIAS_-_OUADI_ED_DELM' => _x( 'Qabb Elias - Ouadi Ed Delm', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQOUSSAYA' => _x( 'Qoussaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAAIT' => _x( 'Raait', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIYAQ_-_HAOUCH_HALA' => _x( 'Riyaq - Haouch Hala', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAADNAYEL' => _x( 'Saadnayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAALABAYA' => _x( 'Taalabaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTERBOL_(ZAHLEH)' => _x( 'Terbol (Zahleh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAHLEH_-_MAALLAQA_-_TAANAYEL' => _x( 'Zahleh - Maallaqa - Taanayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIRUT' => _x( 'Beirut', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBJL' => [
		'LBAABEY_-_AIN_DRAFIL' => _x( 'Aabey - Ain Drafil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALEY' => _x( 'Aaley', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAMOUN_(AALEY)' => _x( 'Aaramoun (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYNAB' => _x( 'Aaynab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTAT' => _x( 'Aaytat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_AANOUB' => _x( 'Ain Aanoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_DARA' => _x( 'Ain Dara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EJ_JDIDEH_(AALEY)' => _x( 'Ain Ej Jdideh (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ER_ROUMMANEH_(AALEY)' => _x( 'Ain Er Roummaneh (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ES_SAYDEH' => _x( 'Ain Es Saydeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_KSOUR' => _x( 'Ain Ksour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAAOUERTA' => _x( 'Baaouerta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAYSSOUR_(AALEY)' => _x( 'Bayssour (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBCHAMOUN' => _x( 'Bchamoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBDADOUN' => _x( 'Bdadoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEDGHANE_-_OUADI_BEDGHANE' => _x( 'Bedghane - Ouadi Bedghane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBHAMDOUN_EL_BALADAT' => _x( 'Bhamdoun El Baladat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBHAMDOUN_EL_MHATTA' => _x( 'Bhamdoun El Mhatta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBINNAY' => _x( 'Binnay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBKHICHTAY' => _x( 'Bkhichtay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBLAYBEL' => _x( 'Blaybel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBMAHRAY' => _x( 'Bmahray', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBMAKINE' => _x( 'Bmakine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSATINE_(AALEY)' => _x( 'Bsatine (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSOUS' => _x( 'Bsous', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTALLOUN' => _x( 'Btalloun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTATER' => _x( 'Btater', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHANAY' => _x( 'Chanay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAROUN' => _x( 'Charoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHARTOUN' => _x( 'Chartoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHIMLANE' => _x( 'Chimlane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUEIFAT' => _x( 'Choueifat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAQQOUN' => _x( 'Daqqoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_QOUBEL' => _x( 'Deir Qoubel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDFOUN' => _x( 'Dfoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHABOUN' => _x( 'Ghaboun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOUMAL' => _x( 'Houmal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIGHMID' => _x( 'Ighmid', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAHHALEH' => _x( 'Kahhaleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKEYFOUN' => _x( 'Keyfoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_AAMMAY' => _x( 'Kfar Aammay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_MATTA' => _x( 'Kfar Matta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_BAANA' => _x( 'Majdel Baana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMANSOURIYET_-_AIN_EL_MARJ' => _x( 'Mansouriyet - Ain El Marj', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMECHERFEH' => _x( 'Mecherfeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEJDLAIYA_(AALEY)' => _x( 'Mejdlaiya (Aaley)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQMATIYEH' => _x( 'Qmatiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAMLIEH' => _x( 'Ramlieh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRICHMAIYA' => _x( 'Richmaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIJMEH' => _x( 'Rijmeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIMHALA' => _x( 'Rimhala', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBROUAYSSET_EN_NAAMANE' => _x( 'Rouaysset En Naamane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAOUFAR' => _x( 'Saoufar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSARHMOUL' => _x( 'Sarhmoul', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSELFAYA' => _x( 'Selfaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOUQ_EL_GHARB' => _x( 'Souq El Gharb', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAAZANIYEH' => _x( 'Taazaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABADIYEH' => _x( 'Aabadiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAIYA' => _x( 'Aaraiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARBANIYÉ_-_DLAYBÉ' => _x( 'Aarbaniyé - Dlaybé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBARSOUN' => _x( 'Arsoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAABDA_-_LOUAYZÉ' => _x( 'Baabda - Louayzé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAALCHMAY' => _x( 'Baalchmay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBMARYAM' => _x( 'Bmaryam', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_EL_BRAJNEH' => _x( 'Borj El Brajneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOUTCHAY_-_MERDACHEH' => _x( 'Boutchay - Merdacheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSABA_(BAABDA)' => _x( 'Bsaba (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTEKHNAY' => _x( 'Btekhnay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBZEBDINE' => _x( 'Bzebdine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHBANIYEH' => _x( 'Chbaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHIYAH' => _x( 'Chiyah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUIT' => _x( 'Chouit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EL_HARF' => _x( 'Deir El Harf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFALOUGHA_-_KHALOUAT' => _x( 'Falougha - Khalouat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFURN_ECH_CHEBBAK_-_AIN_EL_REMMANÉ_-_TAHOU' => _x( 'Furn Ech Chebbak - Ain El Remmané - Tahouitat el Nahr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHBAYREH' => _x( 'Ghbayreh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHADATH_BEIRUT_-_HARET_EL_BOTM_-_SIBNÉ' => _x( 'Hadath Beirut - Haret el Botm - Sibné', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAMMANA' => _x( 'Hammana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_ES_SITT' => _x( 'Haret es Sitt', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_HREIK' => _x( 'Haret Hreik', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHASBAIYA_EL_MATN' => _x( 'Hasbaiya El Matn', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAZMIYEH_(BAABDA)' => _x( 'Hazmiyeh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHLALIYEH_(BAABDA)' => _x( 'Hlaliyeh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUAR_EL_HAOUZ' => _x( 'Jouar El Haouz', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOURET_ARSOUN' => _x( 'Jouret Arsoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_CHIMA' => _x( 'Kfar Chima', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_SELOUANE' => _x( 'Kfar Selouane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHREIBEH_(BAABDA)' => _x( 'Khreibeh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKNEISSEH_(BAABDA)' => _x( 'Kneisseh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMREIJÉ_(BAABDA)_-_TAHOUITAT_EL_GHADIR_-_L' => _x( 'Mreijé (Baabda) - Tahouitat El Ghadir - Laylaké', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_CHAHROUR_EL_AAOULIA' => _x( 'Ouadi Chahrour El Aaoulia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_CHAHROUR_ES_SOUFLA' => _x( 'Ouadi Chahrour Es Soufla', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQALAA_(BAABDA)' => _x( 'Qalaa (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQOBBAYAA' => _x( 'Qobbayaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQORNAYEL' => _x( 'Qornayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQORTADA' => _x( 'Qortada', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQRAYEH_(BAABDA)' => _x( 'Qrayeh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQSAIBEH_(BAABDA)' => _x( 'Qsaibeh (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_EL_HARF' => _x( 'Ras El Harf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_EL_MATN' => _x( 'Ras El Matn', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBROUAYSSET_EL_BALLOUT' => _x( 'Rouaysset El Ballout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSALIMA_(BAABDA)' => _x( 'Salima (Baabda)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTARCHICH' => _x( 'Tarchich', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALMANE_-_BARGHOUTIYEH' => _x( 'Aalmane - Barghoutiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAMMATOUR' => _x( 'Aammatour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAMMIQ_(CHOUF)' => _x( 'Aammiq (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANOUT' => _x( 'Aanout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAATHRINE' => _x( 'Aathrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EL_HAOUR' => _x( 'Ain El Haour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_OUZAIN' => _x( 'Ain Ouzain', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_QANI' => _x( 'Ain Qani', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ZHALTA' => _x( 'Ain Zhalta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAINBAL' => _x( 'Ainbal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAADARANE' => _x( 'Baadarane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAAQLINE' => _x( 'Baaqline', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAASSIR_-_HARET_BAASSIR' => _x( 'Baassir - Haret Baassir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARJA' => _x( 'Barja', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAROUK_-_FRAYDIS_(CHOUF)' => _x( 'Barouk - Fraydis (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATER' => _x( 'Bater', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATLOUN' => _x( 'Batloun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBCHETFINE' => _x( 'Bchetfine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_ED_DINE' => _x( 'Beit Ed Dine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBIREH_(CHOUF)' => _x( 'Bireh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOTMEH' => _x( 'Botmeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOURJEIN_-_MARJIYAT_(CHOUF)' => _x( 'Bourjein - Marjiyat (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBRIH' => _x( 'Brih', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSABA_(CHOUF)' => _x( 'Bsaba (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHHIM' => _x( 'Chhim', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAHR_EL_MGHARA' => _x( 'Dahr El Mghara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDALHOUN' => _x( 'Dalhoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAMOUR' => _x( 'Damour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDARAIYA_(CHOUF)' => _x( 'Daraiya (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_DOURIT' => _x( 'Deir Dourit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EL_QAMAR' => _x( 'Deir El Qamar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_KOUCHEH' => _x( 'Deir Koucheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDIBBIYEH' => _x( 'Dibbiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDMIT' => _x( 'Dmit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFAOUARAT_JAAFAR' => _x( 'Faouarat Jaafar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHARIFEH' => _x( 'Gharifeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_JANDAL' => _x( 'Haret Jandal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHASROUT' => _x( 'Hasrout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJADRA_-_OUADI_EZ_ZAYNI' => _x( 'Jadra - Ouadi Ez Zayni', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJAHLIYEH' => _x( 'Jahliyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJBAA_(CHOUF)' => _x( 'Jbaa (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDEH_(CHOUF)' => _x( 'Jdaideh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJIYEH' => _x( 'Jiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUN' => _x( 'Joun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAHLOUNIYEH_(CHOUF)' => _x( 'Kahlouniyeh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKETERMAYA' => _x( 'Ketermaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_FAQOUD' => _x( 'Kfar Faqoud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HIM' => _x( 'Kfar Him', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_MATTA' => _x( 'Kfar Matta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_NABRAKH' => _x( 'Kfar Nabrakh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_NISS' => _x( 'Kfar Niss', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_QATRA' => _x( 'Kfar Qatra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHREIBEH_(CHOUF)' => _x( 'Khreibeh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKNEISSEH_(CHOUF)' => _x( 'Kneisseh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAASSER_BEIT_ED_DINE' => _x( 'Maasser Beit Ed Dine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAASSER_ECH_CHOUF' => _x( 'Maasser ech Chouf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_EL_MEOUCH' => _x( 'Majdel El Meouch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZBOUD' => _x( 'Mazboud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAA_(CHOUF)' => _x( 'Mazraa (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_ED_DAHR' => _x( 'Mazraat ed Dahr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMECHREF' => _x( 'Mechref', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMGHAYRIYEH_(CHOUF)' => _x( 'Mghayriyeh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMOUKHTARA' => _x( 'Moukhtara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMRISTI' => _x( 'Mristi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMTOLLEH_-_BZINA' => _x( 'Mtolleh - Bzina', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAAMEH_-_HARET_EN_NAAMEH' => _x( 'Naameh - Haret En Naameh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNIHA_(CHOUF)' => _x( 'Niha (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_ES_SITT' => _x( 'Ouadi Es Sitt', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUARDANIYEH' => _x( 'Ouardaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUARHANIYEH' => _x( 'Ouarhaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRMEILEH_(CHOUF)' => _x( 'Rmeileh (Chouf)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSEMQANIYEH' => _x( 'Semqaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSIBLINE' => _x( 'Sibline', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSIRJBAL' => _x( 'Sirjbal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAAROURIYEH' => _x( 'Zaarouriyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALMAT_-_SOUANEH' => _x( 'Aalmat - Souaneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAMCHIT' => _x( 'Aamchit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANNAYA_-_KFAR_BAAL' => _x( 'Aannaya - Kfar Baal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAQOURA_(JBEIL)' => _x( 'Aaqoura (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAFQA_(JBEIL)' => _x( 'Afqa (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EL_GHOUAYBEH' => _x( 'Ain El Ghouaybeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEJJEH' => _x( 'Bejjeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBERBARA' => _x( 'Berbara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBICHTILDA' => _x( 'Bichtilda', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBLAT_(JBEIL)' => _x( 'Blat (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBEDDEH_(JBEIL)' => _x( 'Eddeh (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBEHMEJ' => _x( 'Ehmej', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFATREH' => _x( 'Fatreh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFIDAR' => _x( 'Fidar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHABAT_-_ROUAYS' => _x( 'Ghabat - Rouays', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHALBOUN' => _x( 'Ghalboun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHALATE' => _x( 'Halate', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHJOULA' => _x( 'Hjoula', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOSRAYEL' => _x( 'Hosrayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHSARAT' => _x( 'Hsarat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHSOUN' => _x( 'Hsoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJAJ' => _x( 'Jaj', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJBEIL_(BYBLOS)' => _x( 'Jbeil (Byblos)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJEDDAYEL_(JBEIL)' => _x( 'Jeddayel (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLAQLOUQ_(AAQOURA)' => _x( 'Laqlouq (Aaqoura)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLASSA' => _x( 'Lassa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLEHFED' => _x( 'Lehfed', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_EL_AAQOURA' => _x( 'Majdel El Aaqoura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAYFOUQ_-_QOTTARA' => _x( 'Mayfouq - Qottara', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_ES_SIYAD' => _x( 'Mazraat Es Siyad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMCHANE' => _x( 'Mchane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMECHMECH_(JBEIL)' => _x( 'Mechmech (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMGHAYREH_(JBEIL)' => _x( 'Mghayreh (Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMOUNSEF' => _x( 'Mounsef', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMZARIB_-_AARASTA' => _x( 'Mzarib - Aarasta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAHR_IBRAHIM' => _x( 'Nahr Ibrahim', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARTABA' => _x( 'Qartaba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_OSTA' => _x( 'Ras Osta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTARTIJ' => _x( 'Tartij', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYANOUH_-_HDINÉ' => _x( 'Yanouh - Hdiné', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAMMOURA_-_KFAR_JRAYF' => _x( 'Nammoura - Kfar Jrayf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAACHQOUT' => _x( 'Aachqout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAJALTOUN' => _x( 'Aajaltoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAQAYBEH_(KESROUANE)' => _x( 'Aaqaybeh (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAMOUN_(KESROUANE)' => _x( 'Aaramoun (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAZRA_OUEL_AAZR' => _x( 'Aazra Ouel Aazr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBADMA_OUA_DAFNEH' => _x( 'Adma Oua Dafneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ER_RIHANEH_(KESROUANE)' => _x( 'Ain Er Rihaneh (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAINTOURA_(KESROUANE)' => _x( 'Aintoura (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBALLOUNEH' => _x( 'Ballouneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATHA' => _x( 'Batha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEQAATET_AACHQOUT' => _x( 'Beqaatet Aachqout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEQAATET_KANAANE' => _x( 'Beqaatet Kanaane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOUAR' => _x( 'Bouar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQAATOUTA' => _x( 'Bqaatouta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBZOUMMAR' => _x( 'Bzoummar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAHTOUL_-_JOURET_MHAD' => _x( 'Chahtoul - Jouret Mhad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHNANAIR' => _x( 'Chnanair', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDARAIYA_(KESROUANE)' => _x( 'Daraiya (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDARAOUN_-_HARISSA' => _x( 'Daraoun - Harissa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDLEBTA' => _x( 'Dlebta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFARAYA' => _x( 'Faraya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFATQA' => _x( 'Fatqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFAYTROUN' => _x( 'Faytroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHAZIR' => _x( 'Ghazir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHBALEH' => _x( 'Ghbaleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHIDRAS' => _x( 'Ghidras', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHINEH' => _x( 'Ghineh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHOSTA' => _x( 'Ghosta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAYATA' => _x( 'Hayata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHRAJEL' => _x( 'Hrajel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHSAYN' => _x( 'Hsayn', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJAAITA' => _x( 'Jaaita', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDET_GHAZIR_-_HARHARAYA_-_QATTINE' => _x( 'Jdaidet Ghazir - Harharaya - Qattine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUNIEH' => _x( 'Jounieh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOURET_BEDRANE' => _x( 'Jouret Bedrane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOURET_ET_TERMOS' => _x( 'Jouret Et Termos', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_DIBIANE' => _x( 'Kfar Dibiane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_TAY_(KESROUANE)' => _x( 'Kfar Tay (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFOUR_(KESROUANE)' => _x( 'Kfour (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAAYSRA_(KESROUANE)' => _x( 'Maaysra (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAYROUBA' => _x( 'Mayrouba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUATA_EJ_JAOUZ' => _x( 'Ouata Ej Jaouz', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQLEIAAT_(KESROUANE)' => _x( 'Qleiaat (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAACHINE' => _x( 'Raachine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAYFOUN' => _x( 'Rayfoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAFRA_(KESROUANE)' => _x( 'Safra (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSEHAYLEH_(KESROUANE)' => _x( 'Sehayleh (Kesrouane)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTABARJA_-_KFAR_YASSINE' => _x( 'Tabarja - Kfar Yassine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYAHCHOUCH' => _x( 'Yahchouch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAAITREH' => _x( 'Zaaitreh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAITOUN' => _x( 'Zaitoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZOUK_MKAYEL' => _x( 'Zouk Mkayel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZOUK_MOSBEH' => _x( 'Zouk Mosbeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAATCHANEH' => _x( 'Aatchaneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYOUN_(MATN)' => _x( 'Aayoun (Matn)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYROUN' => _x( 'Aayroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ES_SOFSAF_-_MAR_MIKHAYEL_BNABIL' => _x( 'Ain Es Sofsaf - Mar Mikhayel Bnabil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_SAADEH' => _x( 'Ain Saadeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAINTOURA_(MATN)' => _x( 'Aintoura (Matn)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBANTELIAS_-_NAQQACH' => _x( 'Antelias - Naqqach', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAABDAT' => _x( 'Baabdat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBASKINTA' => _x( 'Baskinta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_CHAAR_-_MAZRAAT_EL_HADIRA' => _x( 'Beit Chaar - Mazraat El Hadira', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_CHABAB_-_CHAOUIYEH_EL_QNAYTRA' => _x( 'Beit Chabab - Chaouiyeh El Qnaytra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_MERI' => _x( 'Beit Meri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBIKFAYA_-_MHAIYDSEH' => _x( 'Bikfaya - Mhaiydseh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_HAMMOUD' => _x( 'Borj Hammoud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBROUMMANA' => _x( 'Broummana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSALIM_-_MAJZOUB_-_MEZHER' => _x( 'Bsalim - Majzoub - Mezher', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTEGHRINE' => _x( 'Bteghrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBYAQOUT' => _x( 'Byaqout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUEIR_-_AIN_EL_SINDIANE' => _x( 'Choueir - Ain El Sindiane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAHR_ES_SOUANE_(MATN)' => _x( 'Dahr Es Souane (Matn)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDBAYÉ_-_ZOUQ_EL_KHARAB_-_MAR_YOUSSEF_-_AA' => _x( 'Dbayé - Zouq El Kharab - Mar Youssef - Aaoukar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEKOUANEH_-_DEIR_MAR_ROUKOZ_-_DAHR_EL_HOS' => _x( 'Dekouaneh - Deir Mar Roukoz - Dahr El Hossein', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDIK_EL_MEHDI_-_DEIR_TAMISH' => _x( 'Dik El Mehdi - Deir Tamish', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDOUAR_(MATN)' => _x( 'Douar (Matn)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFANAR' => _x( 'Fanar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHABEH' => _x( 'Ghabeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHIMLAYA' => _x( 'Himlaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJALL_ED_DIB_-_BQENNAYA' => _x( 'Jall Ed Dib - Bqennaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDET_EL_MATN_-_BAOUCHRIYEH_-_SADD_EL_B' => _x( 'Jdaidet El Matn - Baouchriyeh - Sadd El Baouchriyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_AAQAB' => _x( 'Kfar Aaqab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_TAY_(MATN)' => _x( 'Kfar Tay (Matn)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHINCHARA_-_JOUAR' => _x( 'Khinchara - Jouar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_TARCHICH' => _x( 'Majdel Tarchich', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMANSOURIYEH_-_MKALLES_-_DAYCHOUNIYEH' => _x( 'Mansouriyeh - Mkalles - Daychouniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAR_CHAAYA_-_MZAKKEH' => _x( 'Mar Chaaya - Mzakkeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAR_MOUSSA_-_ED_DOUAR' => _x( 'Mar Moussa - Ed Douar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMARJABA' => _x( 'Marjaba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_YACHOUAA' => _x( 'Mazraat Yachouaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMROUJ' => _x( 'Mrouj', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMTAIN_-_MCHIKHA' => _x( 'Mtain - Mchikha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMTAYLEB' => _x( 'Mtayleb', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABAY' => _x( 'Nabay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUATA_EL_MROUJ_-_GHABET_BOLONIA' => _x( 'Ouata El Mrouj - Ghabet Bolonia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAAQOUR' => _x( 'Qaaqour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQENNABET_BROUMMANA' => _x( 'Qennabet Broummana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQORNET_CHAHOUANE_-_AIN_AAR_-_BEIT_EL_KEKK' => _x( 'Qornet Chahouane - Ain Aar - Beit El Kekko - Hbous', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQORNET_EL_HAMRA' => _x( 'Qornet El Hamra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRABIYEH' => _x( 'Rabiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBROUMIEH' => _x( 'Roumieh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAQIET_EL_MISK_-_BHERSAF' => _x( 'Saqiet El Misk - Bhersaf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSINN_EL_FIL' => _x( 'Sinn El Fil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAKRIT' => _x( 'Zakrit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZALQA_-_AAMARET_CHALHOUB' => _x( 'Zalqa - Aamaret Chalhoub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZARAAOUN' => _x( 'Zaraaoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBNA' => [
		'LBAAYNATA_(BENT_JBEIL)' => _x( 'Aaynata (Bent Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTA_ECH_CHAAB' => _x( 'Aayta Ech Chaab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTA_EJ_JABAL_(ZOTT)' => _x( 'Aayta Ej Jabal (Zott)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTAROUN' => _x( 'Aaytaroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EBEL' => _x( 'Ain Ebel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARAACHIT' => _x( 'Baraachit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_LIF' => _x( 'Beit Lif', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_YAHOUN' => _x( 'Beit Yahoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBENT_JBEIL' => _x( 'Bent Jbeil', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_QALAOUIYEH' => _x( 'Borj Qalaouiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAQRA_-_DOUBAY' => _x( 'Chaqra - Doubay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEBL' => _x( 'Debl', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_NTAR' => _x( 'Deir Ntar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFROUN' => _x( 'Froun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHANDOURIYEH_(BENT_JBEIL)' => _x( 'Ghandouriyeh (Bent Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHADDATHA' => _x( 'Haddatha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHANINE' => _x( 'Hanine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARISS' => _x( 'Hariss', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJMAIJMEH' => _x( 'Jmaijmeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAFRA_(BENT_JBEIL)' => _x( 'Kafra (Bent Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_DOUNINE' => _x( 'Kfar Dounine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIRBET_SELM' => _x( 'Khirbet Selm', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUNINE' => _x( 'Kounine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAROUN_ER_RAS' => _x( 'Maroun Er Ras', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQALAOUIYEH' => _x( 'Qalaouiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAOUZAH' => _x( 'Qaouzah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRACHAF' => _x( 'Rachaf', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAMIYEH_(BENT_JBEIL)' => _x( 'Ramiyeh (Bent Jbeil)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRMAYCH' => _x( 'Rmaych', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAFAD_EL_BATTIKH' => _x( 'Safad El Battikh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOULTANIYEH' => _x( 'Soultaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSROBBINE' => _x( 'Srobbine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTIBNINE' => _x( 'Tibnine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTIRI' => _x( 'Tiri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYAROUN' => _x( 'Yaroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYATER' => _x( 'Yater', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_QINIA' => _x( 'Ain Qinia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEBAA_(HASBAIYA)' => _x( 'Chebaa (Hasbaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUAYA_(HASBAIYA)' => _x( 'Chouaya (Hasbaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDELLAFI' => _x( 'Dellafi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFARDIS' => _x( 'Fardis', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHASBAIYA' => _x( 'Hasbaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHEBBARIYEH' => _x( 'Hebbariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAOUKABA_(HASBAIYA)' => _x( 'Kaoukaba (Hasbaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_CHOUBA' => _x( 'Kfar Chouba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HAMAM' => _x( 'Kfar Hamam', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAYR_EZ_ZAIT' => _x( 'Kfayr Ez Zait', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHALOUAT_(HASBAIYA)' => _x( 'Khalouat (Hasbaiya)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJIDIYEH_-_MERI' => _x( 'Majidiyeh - Meri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMARJ_EZ_ZOUHOUR_(DNAIBEH)' => _x( 'Marj Ez Zouhour (Dnaibeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMIMESS' => _x( 'Mimess', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRACHAIYA_EL_FOUKHAR' => _x( 'Rachaiya El Foukhar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADAYSSEH_(MARJAAYOUN)' => _x( 'Aadaysseh (Marjaayoun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADCHIT_(QOUSSAIR)' => _x( 'Aadchit (Qoussair)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBANI_HAIYANE' => _x( 'Bani Haiyane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBLAT' => _x( 'Blat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBLIDA' => _x( 'Blida', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_EL_MLOUK' => _x( 'Borj El Mlouk', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_MIMAS' => _x( 'Deir Mimas', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_SIRIANE' => _x( 'Deir Siriane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDIBBINE' => _x( 'Dibbine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOULA' => _x( 'Houla', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIBL_ES_SAQI' => _x( 'Ibl Es Saqi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJDAIDEH_(MARJAAYOUN)' => _x( 'Jdaideh (Marjaayoun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_KILA' => _x( 'Kfar Kila', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHIYAM' => _x( 'Khiyam', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_SELM' => _x( 'Majdel Selm', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMARKABA' => _x( 'Markaba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEISS_EJ_JABAL' => _x( 'Meiss Ej Jabal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUAZZANI' => _x( 'Ouazzani', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQABRIKHA' => _x( 'Qabrikha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQANTARA_(MARJAAYOUN)' => _x( 'Qantara (Marjaayoun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQLAIAA' => _x( 'Qlaiaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRABB_ET_TALATINE' => _x( 'Rabb Et Talatine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOUANEH_(MARJAAYOUN)' => _x( 'Souaneh (Marjaayoun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTALLOUSSA' => _x( 'Talloussa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAYBEH_(MARJAAYOUN)' => _x( 'Taybeh (Marjaayoun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTOULINE' => _x( 'Touline', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABBA' => _x( 'Aabba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADCHIT_ECH_CHQIF' => _x( 'Aadchit Ech Chqif', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAB_SALIM' => _x( 'Aarab Salim', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAZZI' => _x( 'Aazzi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_QANA' => _x( 'Ain Qana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBARNOUN' => _x( 'Arnoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBRAIQEAA' => _x( 'Braiqeaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHARQIYEH' => _x( 'Charqiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHOUKINE' => _x( 'Choukine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_EZ_ZAHRANI' => _x( 'Deir Ez Zahrani', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDOUAIR_(NABATIYEH)' => _x( 'Douair (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHABBOUCH' => _x( 'Habbouch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAROUF_(NABATIYEH)' => _x( 'Harouf (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOUMINE_EL_FAOUQA' => _x( 'Houmine El Faouqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOUMINE_ET_TAHTA' => _x( 'Houmine Et Tahta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBINSAR' => _x( 'Insar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJARJOUAA' => _x( 'Jarjouaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJBAA_(NABATIYEH)_-_AIN_BOU_SOUAR' => _x( 'Jbaa (Nabatiyeh) - Ain Bou Souar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJIBCHIT' => _x( 'Jibchit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_FILA' => _x( 'Kfar Fila', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_ROUMMANE' => _x( 'Kfar Roummane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_SIR' => _x( 'Kfar Sir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_TIBNIT' => _x( 'Kfar Tibnit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFOUR_(NABATIYEH)' => _x( 'Kfour (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAYFADOUN' => _x( 'Mayfadoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABATIYEH_EL_FAOUQA' => _x( 'Nabatiyeh El Faouqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNABATIYEH_ET_TAHTA' => _x( 'Nabatiyeh Et Tahta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNMAIRIYEH' => _x( 'Nmairiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAAQAIYET_EJ_JISR' => _x( 'Qaaqaiyet Ej Jisr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQSAIBEH_(NABATIYEH)' => _x( 'Qsaibeh (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBROUMINE' => _x( 'Roumine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSARBA_(NABATIYEH)' => _x( 'Sarba (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSINEH' => _x( 'Sineh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSIR_EL_GHARBIYEH' => _x( 'Sir el Gharbiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYOHMOR_(NABATIYEH)' => _x( 'Yohmor (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAOUTAR_ECH_CHARQIYEH' => _x( 'Zaoutar Ech Charqiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAOUTAR_EL_GHARBIYEH' => _x( 'Zaoutar El Gharbiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZEFTA' => _x( 'Zefta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZIBDINE_(NABATIYEH)' => _x( 'Zibdine (Nabatiyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBAS' => [
		'LBAABRINE' => _x( 'Aabrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBASSIA' => _x( 'Assia', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATROUN' => _x( 'Batroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBCHEAALI' => _x( 'Bcheaali', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_CHLALA' => _x( 'Beit Chlala', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOQSMAIYA' => _x( 'Boqsmaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHATINE' => _x( 'Chatine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEKKA' => _x( 'Chekka', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHIBTINE' => _x( 'Chibtine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_BILLA' => _x( 'Deir Billa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDOUMA' => _x( 'Douma', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBEDDEH_(BATROUN)' => _x( 'Eddeh (Batroun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAMAT' => _x( 'Hamat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARDINE_-_BEIT_KESSAB' => _x( 'Hardine - Beit Kessab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHERI' => _x( 'Heri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIJDABRA' => _x( 'Ijdabra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJRANE' => _x( 'Jrane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_AABIDA' => _x( 'Kfar Aabida', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HAY_(BATROUN)' => _x( 'Kfar Hay (Batroun)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HILDA' => _x( 'Kfar Hilda', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFOUR_EL_AARBI' => _x( 'Kfour El Aarbi', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUBBA' => _x( 'Koubba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUR' => _x( 'Kour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEHMARCH' => _x( 'Mehmarch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_NAHHACH' => _x( 'Ras Nahhach', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSELAATA' => _x( 'Selaata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTANNOURINE_EL_TAHTA_-_TANNOURINE_EL_FAOUQ' => _x( 'Tannourine El Tahta - Tannourine El Faouqa - Ouata Houb', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTHOUM' => _x( 'Thoum', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZANE' => _x( 'Zane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABDINE_(BCHARREH)' => _x( 'Aabdine (Bcharreh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBANE' => _x( 'Bane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAZAAOUN' => _x( 'Bazaaoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBCHARREH' => _x( 'Bcharreh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBERHALIOUN' => _x( 'Berhalioun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQAA_KAFRA' => _x( 'Bqaa Kafra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQERQACHA' => _x( 'Bqerqacha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHADATH_EJ_JOUBBEH' => _x( 'Hadath Ej Joubbeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHADCHIT' => _x( 'Hadchit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHASROUN' => _x( 'Hasroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQNAT' => _x( 'Qnat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTOURZA' => _x( 'Tourza', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABA' => _x( 'Aaba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAFSDIQ' => _x( 'Aafsdiq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_AAKRINE' => _x( 'Ain Aakrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAMIOUN' => _x( 'Amioun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARSA' => _x( 'Barsa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATROUMINE' => _x( 'Batroumine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBDEBBA' => _x( 'Bdebba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBECHMIZZINE' => _x( 'Bechmizzine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEDNAYEL_(KOURA)' => _x( 'Bednayel (Koura)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBKEFTINE' => _x( 'Bkeftine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBSARMA' => _x( 'Bsarma', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTAABOURA' => _x( 'Btaaboura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTERRAM' => _x( 'Bterram', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTOURATIJ' => _x( 'Btouratij', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBZIZA' => _x( 'Bziza', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAR_BAAECHTAR' => _x( 'Dar Baaechtar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDAR_CHMIZZINE' => _x( 'Dar Chmizzine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEDDEH' => _x( 'Deddeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBENFEH' => _x( 'Enfeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBFIAA' => _x( 'Fiaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIJDAABRINE' => _x( 'Ijdaabrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAFTOUN' => _x( 'Kaftoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKEFRAIYA_(KOURA)' => _x( 'Kefraiya (Koura)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_AAQQA' => _x( 'Kfar Aaqqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HATA_(KOURA)' => _x( 'Kfar Hata (Koura)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HAZIR' => _x( 'Kfar Hazir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_QAHEL' => _x( 'Kfar Qahel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_SAROUN_(KOURA)' => _x( 'Kfar Saroun (Koura)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKOUSBA' => _x( 'Kousba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_-_ZAKZOUK_-_OUATA_FARES' => _x( 'Majdel - Zakzouk - Ouata Fares', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMETRIT' => _x( 'Metrit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAKHLEH' => _x( 'Nakhleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQALHAT' => _x( 'Qalhat', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_MASQA' => _x( 'Ras Masqa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRECHDIBBINE' => _x( 'Rechdibbine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZAKROUN' => _x( 'Zakroun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAASSOUN' => _x( 'Aassoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYMAR' => _x( 'Aaymar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAZQAI' => _x( 'Aazqai', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ET_TINEH_(MINIEH-DANNIYEH)' => _x( 'Ain Et Tineh (Minieh-Danniyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAKHAOUN' => _x( 'Bakhaoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEDDAOUI' => _x( 'Beddaoui', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEHOUAITA_-_AFQA_-_BCHENNATA' => _x( 'Behouaita - Afqa - Bchennata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEIT_EL_FAQS' => _x( 'Beit El Faqs', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBHANINE_-_MAZRAAT_ARTOUSSI_-_RIHANIYÉ' => _x( 'Bhanine - Mazraat Artoussi - Rihaniyé', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_EL_YAHOUDIYEH' => _x( 'Borj El Yahoudiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQAA_SAFRINE' => _x( 'Bqaa Safrine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQARSOUNA' => _x( 'Bqarsouna', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTERMAZ' => _x( 'Btermaz', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_AAMMAR' => _x( 'Deir Aammar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_NBOUH' => _x( 'Deir Nbouh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAQL_EL_AAZIMEH' => _x( 'Haql El Aazimeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARF_ES_SYAD' => _x( 'Harf Es Syad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAZMIYEH_(MINIEH-DANNIYEH)' => _x( 'Hazmiyeh (Minieh-Danniyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIZAL' => _x( 'Izal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKARM_EL_MOHR' => _x( 'Karm El Mohr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_BEBNINE' => _x( 'Kfar Bebnine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_CHELLANE' => _x( 'Kfar Chellane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HABOU' => _x( 'Kfar Habou', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMARKEBTA' => _x( 'Markebta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMINIEH_-_NABI_YOUCHEAA' => _x( 'Minieh - Nabi Youcheaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMRAH_ES_SRAYJ' => _x( 'Mrah Es Srayj', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNIMRINE_-_BAKOUZA' => _x( 'Nimrine - Bakouza', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_EN_NAHLEH' => _x( 'Ouadi En Nahleh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARSAITA' => _x( 'Qarsaita', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQATTINE_(MINIEH-DANNIYEH)' => _x( 'Qattine (Minieh-Danniyeh)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSFIREH' => _x( 'Sfireh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSIR' => _x( 'Sir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTARANE' => _x( 'Tarane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMINA' => _x( 'Mina', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQALAMOUN' => _x( 'Qalamoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTRIPOLI' => _x( 'Tripoli', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAACHACH' => _x( 'Aachach', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAINTOURINE' => _x( 'Aaintourine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALMA' => _x( 'Aalma', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARBET_QOUZHAIYA' => _x( 'Aarbet Qouzhaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARJES' => _x( 'Aarjes', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBARDÉ_-_HARF_ARDEN_-_BEIT_OKAR_-_BEIT_ABID' => _x( 'Ardé - Harf Arden - Beit Okar - Beit Abid', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAYTOU' => _x( 'Aytou', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBASLOUQIT' => _x( 'Baslouqit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBHAYRI_(ZGHARTA)' => _x( 'Bhayri (Zgharta)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBNESHAAI' => _x( 'Bneshaai', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDARAIYA_-_BCHANNINE' => _x( 'Daraiya - Bchannine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_EL_FOUAR' => _x( 'Haret el Fouar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBIAAL' => _x( 'Iaal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKARM_SADDEH' => _x( 'Karm Saddeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_DLAQOUS' => _x( 'Kfar Dlaqous', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_FOU' => _x( 'Kfar Fou', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HATA_(ZGHARTA)' => _x( 'Kfar Hata (Zgharta)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_SGHAB' => _x( 'Kfar Sghab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_YACHIT_-_BESEBAAL' => _x( 'Kfar Yachit - Besebaal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_ZEINA' => _x( 'Kfar Zeina', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_ET_TEFFAH' => _x( 'Mazraat Et Teffah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEJDLAIYA_(ZGHARTA)' => _x( 'Mejdlaiya (Zgharta)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMIRIATA_-_QADRIYEH' => _x( 'Miriata - Qadriyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMIZIARA_-_HARF_-_HMAISS_-_SAKHRA' => _x( 'Miziara - Harf - Hmaiss - Sakhra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQARAH_BACH' => _x( 'Qarah Bach', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRACHAAINE' => _x( 'Rachaaine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRAS_KIFA' => _x( 'Ras Kifa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSEBAAL_(ZGHARTA)' => _x( 'Sebaal (Zgharta)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSERAAL' => _x( 'Seraal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTOULA_-_ASLOUT' => _x( 'Toula - Aslout', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZGHARTA_-_EHDEN' => _x( 'Zgharta - Ehden', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LBJA' => [
		'LBAARAMTA' => _x( 'Aaramta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAY' => _x( 'Aaray', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYCHIYEH' => _x( 'Aaychiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAZOUR' => _x( 'Aazour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_EL_MIR' => _x( 'Ain El Mir', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBANANE' => _x( 'Anane', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBENOUATI_(JEZZINE)' => _x( 'Benouati (Jezzine)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBKASSINE' => _x( 'Bkassine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBTEDDINE_EL_LIQCH' => _x( 'Bteddine El Liqch', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAYTOURA' => _x( 'Haytoura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHOMSIYEH' => _x( 'Homsiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJARMAQ' => _x( 'Jarmaq', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJERNAYA' => _x( 'Jernaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJEZZINE_-_AIN_MAJDALAYNE' => _x( 'Jezzine - Ain Majdalayne', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKARKHA' => _x( 'Karkha', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_FALOUS' => _x( 'Kfar Falous', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HOUNEH' => _x( 'Kfar Houneh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_JARRA' => _x( 'Kfar Jarra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLEBAA' => _x( 'Lebaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLOUAYZEH_(JEZZINE)' => _x( 'Louayzeh (Jezzine)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMACHMOUCHEH' => _x( 'Machmoucheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAKNOUNIYEH' => _x( 'Maknouniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMIDANE_(JEZZINE)' => _x( 'Midane (Jezzine)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMJEYDIL_(JEZZINE)' => _x( 'Mjeydil (Jezzine)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMLIKH' => _x( 'Mlikh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBOUADI_JEZZINE' => _x( 'Ouadi Jezzine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQATINE_-_HIDAB' => _x( 'Qatine - Hidab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAYTOULI' => _x( 'Qaytouli', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIHANE_(JEZZINE)' => _x( 'Rihane (Jezzine)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRIMAT_-_CHQEDIF' => _x( 'Rimat - Chqedif', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBROUM' => _x( 'Roum', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSABBAH' => _x( 'Sabbah', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAYDOUN' => _x( 'Saydoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSEJOUD' => _x( 'Sejoud', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSFARAY' => _x( 'Sfaray', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSNAIYA' => _x( 'Snaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZHILTA' => _x( 'Zhilta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABRA' => _x( 'Aabra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADDOUSSIYEH' => _x( 'Aaddoussiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAADLOUN' => _x( 'Aadloun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAANQOUN' => _x( 'Aanqoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAQTANIT' => _x( 'Aaqtanit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAARAB_TABBAYA' => _x( 'Aarab Tabbaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_ED_DELB' => _x( 'Ain Ed Delb', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBARZAI' => _x( 'Arzai', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBABLIYEH' => _x( 'Babliyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARTI' => _x( 'Barti', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBISSARIYEH' => _x( 'Bissariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBNAAFOUL' => _x( 'Bnaafoul', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBQOSTA' => _x( 'Bqosta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBRAMIYEH' => _x( 'Bramiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDARB_ES_SIM' => _x( 'Darb es Sim', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBERKAY' => _x( 'Erkay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHASSANIYEH' => _x( 'Ghassaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBGHAZIYEH' => _x( 'Ghaziyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHAJJEH' => _x( 'Hajjeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHARET_SAIDA' => _x( 'Haret Saida', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHLALIYEH_(SAIDA)' => _x( 'Hlaliyeh (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBINSARIYEH' => _x( 'Insariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKAOUTHARIYET_ES_SIYAD' => _x( 'Kaouthariyet Es Siyad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_BEIT' => _x( 'Kfar Beit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_CHELLAL_(SAIDA)' => _x( 'Kfar Chellal (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_HATTA' => _x( 'Kfar Hatta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKFAR_MELKI_(SAIDA)' => _x( 'Kfar Melki (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHARAYEB_(SAIDA)' => _x( 'Kharayeb (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKHARTOUM' => _x( 'Khartoum', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBLOUBIEH' => _x( 'Loubieh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAAMARIYEH' => _x( 'Maamariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAGHDOUCHEH' => _x( 'Maghdoucheh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDELYOUN' => _x( 'Majdelyoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEROUANIYEH' => _x( 'Merouaniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMIYEH_OU_MIYEH' => _x( 'Miyeh ou Miyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAJJARIYEH' => _x( 'Najjariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQAAQAAIYET_ES_SNAOUBAR' => _x( 'Qaaqaaiyet Es Snaoubar', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQENNARIT' => _x( 'Qennarit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQRAIYEH_(SAIDA)' => _x( 'Qraiyeh (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAIDA_(SIDON)' => _x( 'Saida (Sidon)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSAKSAKIYEH' => _x( 'Saksakiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSALHIYEH_(SAIDA)' => _x( 'Salhiyeh (Saida)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSARAFAND' => _x( 'Sarafand', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTANBOURIT' => _x( 'Tanbourit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTEFFAHTA' => _x( 'Teffahta', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZEITA' => _x( 'Zeita', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZRARIYEH' => _x( 'Zrariyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAABBASSIYEH_(SOUR)' => _x( 'Aabbassiyeh (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAALMA_ECH_CHAAB' => _x( 'Aalma ech Chaab', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAAYTIT' => _x( 'Aaytit', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBAIN_BAAL_(SOUR)' => _x( 'Ain Baal (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBARZOUN' => _x( 'Arzoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAFLAY' => _x( 'Baflay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBARICH' => _x( 'Barich', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBATOULAY' => _x( 'Batoulay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBAZOURIYEH' => _x( 'Bazouriyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBEDIAS' => _x( 'Bedias', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBIYAD' => _x( 'Biyad', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_ECH_CHEMALI' => _x( 'Borj Ech Chemali', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBORJ_RAHHAL_-_AIN_ABOU_ABDALLAH_-_AIN_ZAR' => _x( 'Borj Rahhal - Ain Abou Abdallah - Ain Zarka', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOURGHELIYEH' => _x( 'Bourgheliyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBBOUSTANE_(SOUR)' => _x( 'Boustane (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAITIYÉ_-_MALKIYET_ES_SAHEL' => _x( 'Chaitiyé - Malkiyet Es Sahel', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHAMAA' => _x( 'Chamaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEHABIYEH' => _x( 'Chehabiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHEHOUR' => _x( 'Chehour', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBCHIHINE' => _x( 'Chihine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEBAAL' => _x( 'Debaal', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_AAMES' => _x( 'Deir Aames', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_KIFA_(SOUR)' => _x( 'Deir Kifa (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_QANOUN_EL_AIN' => _x( 'Deir Qanoun El Ain', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDEIR_QANOUN_EN_NAHR' => _x( 'Deir Qanoun En Nahr', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDERDGHAYA' => _x( 'Derdghaya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBDHAYRA' => _x( 'Dhayra', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHALLOUSSIYEH' => _x( 'Halloussiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHANAOUAY' => _x( 'Hanaouay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHENNIYEH' => _x( 'Henniyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBHMAIRI_(SOUR)' => _x( 'Hmairi (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJBAL_EL_BOTM' => _x( 'Jbal El Botm', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJENNATA' => _x( 'Jennata', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJIBBAIN' => _x( 'Jibbain', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBJOUAIYA' => _x( 'Jouaiya', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBKNEISSEH_(SOUR)' => _x( 'Kneisseh (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAARAKEH' => _x( 'Maarakeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAAROUB' => _x( 'Maaroub', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAHROUNA' => _x( 'Mahrouna', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAJDEL_ZOUN' => _x( 'Majdel Zoun', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMANSOURI' => _x( 'Mansouri', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_EL_MECHREF' => _x( 'Mazraat El Mechref', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMAZRAAT_EZ_ZALLOUTIEH' => _x( 'Mazraat Ez Zalloutieh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMEROUAHINE' => _x( 'Merouahine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBMJADEL_(TYR)' => _x( 'Mjadel (Tyr)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAFFAKHIYEH' => _x( 'Naffakhiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBNAQOURA' => _x( 'Naqoura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQANA' => _x( 'Qana', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBQLAILEH_(SOUR)' => _x( 'Qlaileh (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRECHEKNANAY' => _x( 'Recheknanay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBRMADIYEH' => _x( 'Rmadiyeh', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSADDIQINE' => _x( 'Saddiqine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSELAA' => _x( 'Selaa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSOUR_(TYR)' => _x( 'Sour (Tyr)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBSRIFA' => _x( 'Srifa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAYR_DEBBA' => _x( 'Tayr Debba', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAYR_FALSAY' => _x( 'Tayr Falsay', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTAYR_HARFA' => _x( 'Tayr Harfa', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBTOURA' => _x( 'Toura', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYANOUH_(SOUR)' => _x( 'Yanouh (Sour)', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBYARINE' => _x( 'Yarine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
		'LBZEBQINE' => _x( 'Zebqine', 'LB-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
