<?php

/**
 * List of cities for: Kuwait
 * Source: https://www.csb.gov.kw/Pages/Statistics_en?ID=18&ParentCatID=2
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'KWCAPITAL' => _x( 'CAPITAL', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	'KWHAWALLI' => _x( 'HAWALLI', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	'KWAL-AHMADI' => _x( 'AL-AHMADI', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	'KWAL-JAHRA' => _x( 'AL-JAHRA', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	'KWAL-FARWANIYA' => _x( 'AL-FARWANIYA', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	'KWMUBARAK_AL-KABEER' => _x( 'MUBARAK AL-KABEER', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'KWCAPITAL'=> [
		'KWTHE_GREEN_BELT' => _x( 'the green belt', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-KHALDIYA' => _x( 'al-khaldiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-DASMAH' => _x( 'al-dasmah', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-DAIYA' => _x( 'al-daiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-DOHA' => _x( 'al-doha', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-RAWDA' => _x( 'al-rawda', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SURRA' => _x( 'al-surra', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SHAMIYA' => _x( 'al-shamiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SHUWAIKH' => _x( 'al-shuwaikh', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SULAIBIKHAT' => _x( 'al-sulaibikhat', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ADEILIA' => _x( 'al-adeilia', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FAIHA' => _x( 'al-faiha', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-QADISIYA' => _x( 'al-qadisiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-QIBLA' => _x( 'al-qibla', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MURQAB' => _x( 'al-murqab', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MANSOURIYA' => _x( 'al-mansouriya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-NUZHA' => _x( 'al-nuzha', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSEA_FRONT' => _x( 'sea front', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-YARMOUK' => _x( 'al-yarmouk', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWBENEID_AL-QAR' => _x( 'beneid al-qar', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWJABER_AL-AHMAD' => _x( 'jaber al-ahmad', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWDASMAN' => _x( 'dasman', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSHARQ' => _x( 'sharq', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWABDULLA_AL-SALEM' => _x( 'abdulla al-salem', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWGARNATA' => _x( 'garnata', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWFAILAKA' => _x( 'failaka', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWQURTOBA' => _x( 'qurtoba', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWKEEFAN' => _x( 'keefan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWMUBARAKIYA_CAMPS' => _x( 'mubarakiya camps', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KWHAWALLI'	 => [
		'KWAL-JABRIYA' => _x( 'al-jabriya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-RIMAITHIYA' => _x( 'al-rimaithiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ZAHRAA' => _x( 'al-zahraa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SALMIYA' => _x( 'al-salmiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SALAM' => _x( 'al-salam', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SHAAB' => _x( 'al-shaab', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SHUHADA' => _x( 'al-shuhada', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SEDEEQ' => _x( 'al-sedeeq', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWANJEFA' => _x( 'anjefa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWBAYAN' => _x( 'bayan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWHATEEN' => _x( 'hateen', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWHAWALLI' => _x( 'hawalli', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSALWA' => _x( 'salwa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWMUBARAK_AL-ABDULLA' => _x( 'mubarak al-abdulla', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWMESHRIF' => _x( 'meshrif', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KWAL-AHMADI' => [
		'KWABU_HULIFA' => _x( 'abu hulifa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-KHEERAN_AND_AL-KHEERAN_PEARL' => _x( 'al-kheeran and al-kheeran pearl', 'KW-cities', 'cities-shipping-zones-for-woce' ),
		'KWAL-REQA' => _x( 'al-reqa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ZOUR' => _x( 'al-zour', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSOUTHERN_COASTAL_STRIP' => _x( 'southern coastal strip', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSOUTH_OF_AL-SHUAIBA-AL-SHUAIBA_PORT' => _x( 'south of al-shuaiba - al-shuaiba port', 'KW-cities', 'cities-shipping-zo-woocommerce' ),
		'KWNORTH_OF_AL-SHUAIBA-AL-AHMADI_PORT' => _x( 'north of al-shuaiba -al-ahmadi port', 'KW-cities', 'cities-shipping-zonesocommerce' ),
		'KWAL-SABAHIYA' => _x( 'al-sabahiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-DAHAR' => _x( 'al-dahar', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-AQUEILAH' => _x( 'al-aqueilah', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FEHEHEEL' => _x( 'al-feheheel', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FUNTAS' => _x( 'al-funtas', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MOQAWA' => _x( 'al-moqawa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MANGAF' => _x( 'al-mangaf', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MAHBOOLA' => _x( 'al-mahboola', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-NWAISEEB' => _x( 'al-nwaiseeb', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-AHMADI_DESERT_GOVERNORATE' => _x( 'al-ahmadi desert governorate', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWJABER_AL-ALI' => _x( 'jaber al-ali', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSOUTH_AL-SABAHIYA' => _x( 'south al-sabahiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-WAFRA_FARMS-BARNS' => _x( 'al-wafra farms - barns', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWALI_SABAH_AL-SALEM' => _x( 'ali sabah al-salem (om al-heman)', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWFAHAD_AL-AHMAD' => _x( 'fahad al-ahmad', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-AHMADI_CITY' => _x( 'al-ahmadi city', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWNEW_AL-KHAEERAN_CITY' => _x( 'new al-khaeeran city', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWNEW_AL-WAFRA_CITY' => _x( 'new al-wafra city', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSABAH_AL-AHMAD_CITY' => _x( 'sabah al-ahmad city', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-WAFRA_FARMS' => _x( 'al-wafra farms', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWABDULLA_PORT_AND_INDUSTRIAL_SHUAIBA' => _x( 'abdulla port and industrial shuaiba', 'KW-cities', 'cities-shipping-zoneoocommerce' ),
		'KWHADIYA' => _x( 'hadiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KWAL-JAHRA' => [
		'KWAL-JAHRA' => _x( 'al-jahra', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SALMEY' => _x( 'al-salmey', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWJUNK_YARD' => _x( 'junk yard', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SUBIA-OM_QASSER' => _x( 'al-subia - om qasser', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SULAIBIA' => _x( 'al-sulaibia', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ABDILEE' => _x( 'al-abdilee', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-OYOON' => _x( 'al-oyoon', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-QASSER' => _x( 'al-qasser', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-SULAIBIA_TRADITIONAL_ACCOMMODATIONS' => _x( 'al-sulaibia traditional accommodations', 'KW-cities', 'cities-shippin-for-woocommerce' ),
		'KWAL-NASEEM' => _x( 'al-naseem', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-NAEEM' => _x( 'al-naeem', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-NAHDA - EAST SULAIBIKHAT' => _x( 'al-nahda - east sulaibikhat', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-WAHA' => _x( 'al-waha', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAMGARA' => _x( 'amgara', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-JAHRA_DESERT_GOVERNORATE' => _x( 'al-jahra desert governorate', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWTAYMAA' => _x( 'taymaa', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSOUTH_AL-DOHA-AL-QAIRAWAN' => _x( 'south al-doha -al-qairawan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ), 
		'KWSOUTHEAST_AL-JAHRA' => _x( 'southeast al-jahra', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWWEST_AL-JAHRA' => _x( 'west al-jahra', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWKABD' => _x( 'kabd', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSAAD_AL-ABDULLA_CITY' => _x( 'saad al-abdulla city', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSULAIBIKHAT_TOMBS' => _x( 'sulaibikhat tombs', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KWAL-FARWANIYA' => [
		'KWASHBELIAH' => _x( 'ashbeliah', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ANDALOOS' => _x( 'al-andaloos', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-RABIYA' => _x( 'al-rabiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-REHAB' => _x( 'al-rehab', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-RIQAI' => _x( 'al-riqai', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-RAI' => _x( 'al-rai', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-DHAJEEJ' => _x( 'al-dhajeej', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ARDIYA' => _x( 'al-ardiya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-OMARIYA' => _x( 'al-omariya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FERDOUS' => _x( 'al-ferdous', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FARWANIYA' => _x( 'al-farwaniya', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWINTERNATIONAL_AIRPORT' => _x( 'international airport', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWJALEEB_AL-SHYUKH' => _x( 'jaleeb al-shyukh', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWKHAITAN' => _x( 'khaitan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWCAMEL_AND_HORSE_RACE' => _x( 'camel and horse race', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSABAH_AL-NASSER' => _x( 'sabah al-nasser', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWABDULLA_AL-MUBARAK' => _x( 'abdulla al-mubarak', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KWMUBARAK_AL-KABEER' => [
		'KWABU_AL-HASANIA' => _x( 'abu al-hasania', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWABU_FATERA' => _x( 'abu fatera', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-ADDAN' => _x( 'al-addan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-FUNITEES' => _x( 'al-funitees', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-QURAIN' => _x( 'al-qurain', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-QOSOUR' => _x( 'al-qosour', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWAL-MESSILA' => _x( 'al-messila', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSABAH_AL-SALEM' => _x( 'sabah al-salem', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWINDUSTRIAL_SUBHAN' => _x( 'industrial subhan', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSUBHAN_AL-WISTA' => _x( 'subhan al-wista', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWSABHAN_SOUTH_CENTRAL' => _x( 'sabhan south central', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
		'KWMUBARAK_AL-KABEER' => _x( 'mubarak al-kabeer', 'KW-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
