<?php

/**
 * List of cities for: Kenya
 * Source: https://africacheck.org/wp-content/uploads/2020/03/2019-KPHC-Volume-II_.pdf
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['KE']; // List should be synced

$country_cities = [
	'KE1' => [
		'KE101' => 'CHANGAMWE',
		'KE102' => 'JOMVU',
		'KE103' => 'KISAUNI',
		'KE104' => 'LIKONI',
		'KE105' => 'MVITA',
		'KE106' => 'NYALI',
	],
	'KE2' => [
		'KE201' => 'KINANGO',
		'KE202' => 'LUNGA LUNGA',
		'KE203' => 'MATUGA',
		'KE204' => 'MSAMBWENI',
		'KE205' => 'SAMBURU',
	],
	'KE3' => [
		'KE301' => 'CHONYI',
		'KE302' => 'GANZE',
		'KE303' => 'KALOLENI',
		'KE304' => 'KAUMA',
		'KE305' => 'KILIFI NORTH',
		'KE306' => 'KILIFI SOUTH',
		'KE307' => 'MAGARINI',
		'KE308' => 'MALINDI',
		'KE309' => 'RABAI',
	],
	'KE4' => [
		'KE401' => 'TANA DELTA',
		'KE402' => 'TANA NORTH',
		'KE403' => 'TANA RIVER',
	],
	'KE5' => [
		'KE501' => 'LAMU EAST',
		'KE502' => 'LAMU WEST',
	],
	'KE6' => [
		'KE601' => 'MWATATE',
		'KE602' => 'TAITA',
		'KE603' => 'TAVETA',
		'KE604' => 'VOI',
	],
	'KE7' => [
		'KE701' => 'BALAMBALA',
		'KE702' => 'DADAAB',
		'KE703' => 'FAFI',
		'KE704' => 'GARISSA',
		'KE705' => 'HULUGHO',
		'KE706' => 'IJARA',
		'KE707' => 'LAGDERA',
	],
	'KE8' => [
		'KE801' => 'BUNA',
		'KE802' => 'ELDAS',
		'KE803' => 'HABASWEIN',
		'KE804' => 'TARBAJ',
		'KE805' => 'WAJIR EAST',
		'KE806' => 'WAJIR NORTH',
		'KE807' => 'WAJIR SOUTH',
		'KE808' => 'WAJIR WEST',
	],
	'KE9' => [
		'KE901' => 'MANDERA WEST',
		'KE902' => 'BANISA',
		'KE903' => 'KOTULO',
		'KE904' => 'LAFEY',
		'KE905' => 'MANDERA CENTRAL',
		'KE906' => 'MANDERA EAST',
		'KE907' => 'MANDERA NORTH',
	],
	'KE10' => [
		'KE1001' => 'LOIYANGALANI',
		'KE1002' => 'MARSABIT CENTRAL',
		'KE1003' => 'MARSABIT NORTH',
		'KE1004' => 'MARSABIT SOUTH',
		'KE1005' => 'MOYALE',
		'KE1006' => 'NORTH HORR',
		'KE1007' => 'SOLOLO',
	],
	'KE11' => [
		'KE1101' => 'GARBATULLA',
		'KE1102' => 'ISIOLO',
		'KE1103' => 'MERTI',
	],
	'KE12' => [
		'KE1201' => 'BUURI EAST',
		'KE1202' => 'BUURI WEST',
		'KE1203' => 'IGEMBE CENTRAL',
		'KE1204' => 'IGEMBE NORTH',
		'KE1205' => 'IGEMBE SOUTH',
		'KE1206' => 'IMENTI NORTH',
		'KE1207' => 'IMENTI SOUTH',
		'KE1208' => 'MERU CENTRAL',
		'KE1209' => 'TIGANIA CENTRAL',
		'KE1210' => 'TIGANIA EAST',
		'KE1211' => 'TIGANIA WEST',
	],
	'KE13' => [
		'KE1301' => 'IGAMBANGOMBE',
		'KE1302' => 'MAARA',
		'KE1303' => 'MERU SOUTH',
		'KE1304' => 'THARAKA NORTH',
		'KE1305' => 'THARAKA SOUTH',
	],
	'KE14' => [
		'KE1401' => 'EMBU EAST',
		'KE1402' => 'EMBU NORTH',
		'KE1403' => 'EMBU WEST',
		'KE1404' => 'MBEERE SOUTH',
		'KE1405' => 'MBEERE NORTH',
	],
	'KE15' => [
		'KE1501' => 'IKUTHA',
		'KE1502' => 'KATULANI',
		'KE1503' => 'KISASI',
		'KE1504' => 'KITUI CENTRAL',
		'KE1505' => 'KITUI WEST',
		'KE1506' => 'KYUSO',
		'KE1507' => 'LOWER YATTA',
		'KE1508' => 'MATINYANI',
		'KE1509' => 'MIGWANI',
		'KE1510' => 'MUMONI',
		'KE1511' => 'MUTITU',
		'KE1512' => 'MUTITU NORTH',
		'KE1513' => 'MUTOMO',
		'KE1514' => 'MWINGI CENTRAL',
		'KE1515' => 'MWINGI EAST',
		'KE1516' => 'NZAMBANI',
		'KE1517' => 'THAGICU',
		'KE1518' => 'TSEIKURU',
	],
	'KE16' => [
		'KE1601' => 'ATHI RIVER',
		'KE1602' => 'KALAMA',
		'KE1603' => 'KANGUNDO',
		'KE1604' => 'KATHIANI',
		'KE1605' => 'MACHAKOS',
		'KE1606' => 'MASINGA',
		'KE1607' => 'MATUNGULU',
		'KE1608' => 'MWALA',
		'KE1609' => 'YATTA',
	],
	'KE17' => [
		'KE1701' => 'KATHONZWENI',
		'KE1702' => 'KIBWEZI',
		'KE1703' => 'KILUNGU',
		'KE1704' => 'MAKINDU',
		'KE1705' => 'MAKUENI',
		'KE1706' => 'MBOONI EAST',
		'KE1707' => 'MBOONI WEST',
		'KE1708' => 'MUKAA',
		'KE1709' => 'NZAUI',
	],
	'KE18' => [
		'KE1801' => 'KINANGOP',
		'KE1802' => 'NYANDARUA SOUTH',
		'KE1803' => 'MIRANGINE',
		'KE1804' => 'KIPIPIRI',
		'KE1805' => 'NYANDARUA CENTRAL',
		'KE1806' => 'NYANDARUA WEST',
		'KE1807' => 'NYANDARUA NORTH',
	],
	'KE19' => [
		'KE1901' => 'TETU',
		'KE1902' => 'KIENI EAST',
		'KE1903' => 'KIENI WEST',
		'KE1904' => 'MATHIRA EAST',
		'KE1905' => 'MATHIRA WEST',
		'KE1906' => 'NYERI SOUTH',
		'KE1907' => 'MUKURWE-INI',
		'KE1908' => 'NYERI CENTRAL',
	],
	'KE20' => [
		'KE2001' => 'KIRINYAGA CENTRAL',
		'KE2002' => 'KIRINYAGA EAST',
		'KE2003' => 'KIRINYAGA WEST',
		'KE2004' => 'MWEA EAST',
		'KE2005' => 'MWEA WEST',
	],
	'KE21' => [
		'KE2101' => 'MURANGA EAST',
		'KE2102' => 'KANGEMA',
		'KE2103' => 'MATHIOYA',
		'KE2104' => 'KAHURO',
		'KE2105' => 'MURANGA SOUTH',
		'KE2106' => 'GATANGA',
		'KE2107' => 'KIGUMO',
		'KE2108' => 'KANDARA',
	],
	'KE22' => [
		'KE2201' => 'GATUNDU NORTH',
		'KE2202' => 'GATUNDU SOUTH',
		'KE2203' => 'GITHUNGURI',
		'KE2204' => 'JUJA',
		'KE2205' => 'KABETE',
		'KE2206' => 'KIAMBAA',
		'KE2207' => 'KIAMBU',
		'KE2208' => 'KIKUYU',
		'KE2209' => 'LARI',
		'KE2210' => 'LIMURU',
		'KE2211' => 'RUIRU',
		'KE2212' => 'THIKA EAST',
		'KE2213' => 'THIKA WEST',
	],
	'KE23' => [
		'KE2301' => 'KIBISH',
		'KE2302' => 'LOIMA',
		'KE2303' => 'TURKANA CENTRAL',
		'KE2304' => 'TURKANA EAST',
		'KE2305' => 'TURKANA NORTH',
		'KE2306' => 'TURKANA SOUTH',
		'KE2307' => 'TURKANA WEST',
	],
	'KE24' => [
		'KE2401' => 'KIPKOMO',
		'KE2402' => 'POKOT CENTRAL',
		'KE2403' => 'POKOT NORTH',
		'KE2404' => 'POKOT SOUTH',
		'KE2405' => 'WEST POKOT',
	],
	'KE25' => [
		'KE2501' => 'SAMBURU CENTRAL',
		'KE2502' => 'SAMBURU EAST',
		'KE2503' => 'SAMBURU NORTH',
	],
	'KE26' => [
		'KE2601' => 'TRANS NZOIA WEST',
		'KE2602' => 'TRANS NZOIA EAST',
		'KE2603' => 'KWANZA',
		'KE2604' => 'ENDEBESS',
		'KE2605' => 'KIMININI',
	],
	'KE27' => [
		'KE2701' => 'AINABKOI',
		'KE2702' => 'KAPSERET',
		'KE2703' => 'KESSES',
		'KE2704' => 'MOIBEN',
		'KE2705' => 'SOY',
		'KE2706' => 'TURBO',
	],
	'KE28' => [
		'KE2801' => 'KEIYO NORTH',
		'KE2802' => 'KEIYO SOUTH',
		'KE2803' => 'MARAKWET EAST',
		'KE2804' => 'MARAKWET WEST',
	],
	'KE29' => [
		'KE2901' => 'CHESUMEI',
		'KE2902' => 'NANDI CENTRAL',
		'KE2903' => 'NANDI EAST',
		'KE2904' => 'NANDI NORTH',
		'KE2905' => 'NANDI SOUTH',
		'KE2906' => 'TINDERET',
	],
	'KE30' => [
		'KE3001' => 'BARINGO CENTRAL',
		'KE3002' => 'BARINGO NORTH',
		'KE3003' => 'EAST POKOT',
		'KE3004' => 'KOIBATEK',
		'KE3005' => 'MARIGAT',
		'KE3006' => 'MOGOTIO',
		'KE3007' => 'TIATY EAST',
		'KE3008' => 'LAKE BARINGO',
	],
	'KE31' => [
		'KE3101' => 'LAIKIPIA CENTRAL',
		'KE3102' => 'LAIKIPIA EAST',
		'KE3103' => 'LAIKIPIA NORTH',
		'KE3104' => 'LAIKIPIA WEST',
		'KE3105' => 'NYAHURURU',
	],
	'KE32' => [
		'KE3201' => 'GILGIL',
		'KE3202' => 'KURESOI NORTH',
		'KE3203' => 'KURESOI SOUTH',
		'KE3204' => 'MOLO',
		'KE3205' => 'NAIVASHA',
		'KE3206' => 'NAKURU EAST',
		'KE3207' => 'NAKURU NORTH',
		'KE3208' => 'NAKURU WEST',
		'KE3209' => 'NJORO',
		'KE3210' => 'RONGAI',
		'KE3211' => 'SUBUKIA',
	],
	'KE33' => [
		'KE3301' => 'NAROK EAST',
		'KE3302' => 'NAROK NORTH',
		'KE3303' => 'NAROK SOUTH',
		'KE3304' => 'NAROK WEST',
		'KE3305' => 'TRANS MARA EAST',
		'KE3306' => 'TRANS MARA WEST',
	],
	'KE34' => [
		'KE3401' => 'ISINYA',
		'KE3402' => 'KAJIADO CENTRAL',
		'KE3403' => 'KAJIADO NORTH',
		'KE3404' => 'KAJIADO WEST',
		'KE3405' => 'LOITOKITOK',
		'KE3406' => 'MASHUURU',
	],
	'KE35' => [
		'KE3501' => 'BELGUT',
		'KE3502' => 'BURETI',
		'KE3503' => 'KERICHO EAST',
		'KE3504' => 'KIPKELION',
		'KE3505' => 'LONDIANI',
		'KE3506' => 'SOIN SIGOWET',
	],
	'KE36' => [
		'KE3601' => 'BOMET EAST',
		'KE3602' => 'CHEPALUNGU',
		'KE3603' => 'KONOIN',
		'KE3604' => 'SOTIK',
		'KE3605' => 'BOMET CENTRAL',
	],
	'KE37' => [
		'KE3701' => 'BUTERE',
		'KE3702' => 'KAKAMEGA CENTRAL',
		'KE3703' => 'KAKAMEGA EAST',
		'KE3704' => 'KAKAMEGA NORTH',
		'KE3705' => 'KAKAMEGA SOUTH',
		'KE3706' => 'KHWISERO',
		'KE3707' => 'LIKUYANI',
		'KE3708' => 'LUGARI',
		'KE3709' => 'MATETE',
		'KE3710' => 'MATUNGU',
		'KE3711' => 'MUMIAS EAST',
		'KE3712' => 'MUMIAS WEST',
		'KE3713' => 'NAVAKHOLO',
	],
	'KE38' => [
		'KE3801' => 'EMUHAYA',
		'KE3802' => 'VIHIGA',
		'KE3803' => 'SABATIA',
		'KE3804' => 'LUANDA',
		'KE3805' => 'HAMISI',
	],
	'KE39' => [
		'KE3901' => 'BUMULA',
		'KE3902' => 'BUNGOMA CENTRAL',
		'KE3903' => 'BUNGOMA EAST',
		'KE3904' => 'BUNGOMA NORTH',
		'KE3905' => 'BUNGOMA SOUTH',
		'KE3906' => 'CHEPTAIS',
		'KE3907' => 'KIMILILI',
		'KE3909' => 'BUNGOMA WEST',
		'KE3910' => 'TONGAREN',
		'KE3911' => 'WEBUYE WEST',
		'KE3912' => 'MT ELGON FOREST',
	],
	'KE40' => [
		'KE4001' => 'BUNYALA',
		'KE4002' => 'BUSIA',
		'KE4003' => 'BUTULA',
		'KE4004' => 'NAMBALE',
		'KE4005' => 'SAMIA',
		'KE4006' => 'TESO NORTH',
		'KE4007' => 'TESO SOUTH',
	],
	'KE41' => [
		'KE4101' => 'SIAYA',
		'KE4102' => 'GEM',
		'KE4103' => 'UGENYA',
		'KE4104' => 'UGUNJA',
		'KE4105' => 'BONDO',
		'KE4106' => 'RARIEDA',
	],
	'KE42' => [
		'KE4201' => 'KISUMU EAST',
		'KE4202' => 'KISUMU CENTRAL',
		'KE4203' => 'KISUMU WEST',
		'KE4204' => 'SEME',
		'KE4205' => 'MUHORONI',
		'KE4206' => 'NYANDO',
		'KE4207' => 'NYAKACH',
	],
	'KE43' => [
		'KE4301' => 'HOMA BAY',
		'KE4302' => 'NDHIWA',
		'KE4303' => 'RACHUONYO NORTH',
		'KE4304' => 'RACHUONYO EAST',
		'KE4305' => 'RACHUONYO SOUTH',
		'KE4306' => 'RANGWE',
		'KE4307' => 'SUBA NORTH',
		'KE4308' => 'SUBA SOUTH',
	],
	'KE44' => [
		'KE4401' => 'AWENDO',
		'KE4402' => 'KURIA EAST',
		'KE4403' => 'KURIA WEST',
		'KE4404' => 'NYATIKE',
		'KE4405' => 'RONGO',
		'KE4406' => 'SUNA EAST',
		'KE4407' => 'SUNA WEST',
		'KE4408' => 'URIRI',
	],
	'KE45' => [
		'KE4501' => 'ETAGO',
		'KE4502' => 'GUCHA',
		'KE4503' => 'GUCHA SOUTH',
		'KE4504' => 'KENYENYA',
		'KE4505' => 'KISII CENTRAL',
		'KE4506' => 'KISII SOUTH',
		'KE4507' => 'KITUTU CENTRAL',
		'KE4508' => 'MARANI',
		'KE4509' => 'MASABA SOUTH',
		'KE4510' => 'NYAMACHE',
		'KE4511' => 'SAMETA',
	],
	'KE46' => [
		'KE4601' => 'BORABU',
		'KE4602' => 'MANGA',
		'KE4603' => 'MASABA NORTH',
		'KE4604' => 'NYAMIRA NORTH',
		'KE4605' => 'NYAMIRA SOUTH',
	],
	'KE47' => [
		'KE4701' => 'DAGORETTI',
		'KE4702' => 'EMBAKASI',
		'KE4703' => 'KAMUKUNJI',
		'KE4704' => 'KASARANI',
		'KE4705' => 'KIBRA',
		'KE4706' => 'LANGATA',
		'KE4707' => 'MAKADARA',
		'KE4708' => 'MATHARE',
		'KE4709' => 'NJIRU',
		'KE4710' => 'STAREHE',
		'KE4711' => 'WESTLANDS',
	]
];
