<?php

/**
 * List of cities for: Italy
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['IT'];

$country_cities = [
	'TO' => [
		'IT001001' => 'Agliè',
		'IT001002' => 'Airasca',
		'IT001003' => 'Ala di Stura',
		'IT001004' => 'Albiano dIvrea',
		'IT001006' => 'Almese',
		'IT001007' => 'Alpette',
		'IT001008' => 'Alpignano',
		'IT001009' => 'Andezeno',
		'IT001010' => 'Andrate',
		'IT001011' => 'Angrogna',
		'IT001012' => 'Arignano',
		'IT001013' => 'Avigliana',
		'IT001014' => 'Azeglio',
		'IT001015' => 'Bairo',
		'IT001016' => 'Balangero',
		'IT001017' => 'Baldissero Canavese',
		'IT001018' => 'Baldissero Torinese',
		'IT001019' => 'Balme',
		'IT001020' => 'Banchette',
		'IT001021' => 'Barbania',
		'IT001022' => 'Bardonecchia',
		'IT001023' => 'Barone Canavese',
		'IT001024' => 'Beinasco',
		'IT001025' => 'Bibiana',
		'IT001026' => 'Bobbio Pellice',
		'IT001027' => 'Bollengo',
		'IT001028' => 'Borgaro Torinese',
		'IT001029' => 'Borgiallo',
		'IT001030' => 'Borgofranco dIvrea',
		'IT001031' => 'Borgomasino',
		'IT001032' => 'Borgone Susa',
		'IT001033' => 'Bosconero',
		'IT001034' => 'Brandizzo',
		'IT001035' => 'Bricherasio',
		'IT001036' => 'Brosso',
		'IT001037' => 'Brozolo',
		'IT001038' => 'Bruino',
		'IT001039' => 'Brusasco',
		'IT001040' => 'Bruzolo',
		'IT001041' => 'Buriasco',
		'IT001042' => 'Burolo',
		'IT001043' => 'Busano',
		'IT001044' => 'Bussoleno',
		'IT001045' => 'Buttigliera Alta',
		'IT001046' => 'Cafasse',
		'IT001047' => 'Caluso',
		'IT001048' => 'Cambiano',
		'IT001049' => 'Campiglione Fenile',
		'IT001050' => 'Candia Canavese',
		'IT001051' => 'Candiolo',
		'IT001052' => 'Canischio',
		'IT001053' => 'Cantalupa',
		'IT001054' => 'Cantoira',
		'IT001055' => 'Caprie',
		'IT001056' => 'Caravino',
		'IT001057' => 'Carema',
		'IT001058' => 'Carignano',
		'IT001059' => 'Carmagnola',
		'IT001060' => 'Casalborgone',
		'IT001061' => 'Cascinette dIvrea',
		'IT001062' => 'Caselette',
		'IT001063' => 'Caselle Torinese',
		'IT001064' => 'Castagneto Po',
		'IT001065' => 'Castagnole Piemonte',
		'IT001066' => 'Castellamonte',
		'IT001067' => 'Castelnuovo Nigra',
		'IT001068' => 'Castiglione Torinese',
		'IT001069' => 'Cavagnolo',
		'IT001070' => 'Cavour',
		'IT001071' => 'Cercenasco',
		'IT001072' => 'Ceres',
		'IT001073' => 'Ceresole Reale',
		'IT001074' => 'Cesana Torinese',
		'IT001075' => 'Chialamberto',
		'IT001076' => 'Chianocco',
		'IT001077' => 'Chiaverano',
		'IT001078' => 'Chieri',
		'IT001079' => 'Chiesanuova',
		'IT001080' => 'Chiomonte',
		'IT001081' => 'Chiusa di San Michele',
		'IT001082' => 'Chivasso',
		'IT001083' => 'Ciconio',
		'IT001084' => 'Cintano',
		'IT001085' => 'Cinzano',
		'IT001086' => 'Ciriè',
		'IT001087' => 'Claviere',
		'IT001088' => 'Coassolo Torinese',
		'IT001089' => 'Coazze',
		'IT001090' => 'Collegno',
		'IT001091' => 'Colleretto Castelnuovo',
		'IT001092' => 'Colleretto Giacosa',
		'IT001093' => 'Condove',
		'IT001094' => 'Corio',
		'IT001095' => 'Cossano Canavese',
		'IT001096' => 'Cuceglio',
		'IT001097' => 'Cumiana',
		'IT001098' => 'Cuorgnè',
		'IT001099' => 'Druento',
		'IT001100' => 'Exilles',
		'IT001101' => 'Favria',
		'IT001102' => 'Feletto',
		'IT001103' => 'Fenestrelle',
		'IT001104' => 'Fiano',
		'IT001105' => 'Fiorano Canavese',
		'IT001106' => 'Foglizzo',
		'IT001107' => 'Forno Canavese',
		'IT001108' => 'Frassinetto',
		'IT001109' => 'Front',
		'IT001110' => 'Frossasco',
		'IT001111' => 'Garzigliana',
		'IT001112' => 'Gassino Torinese',
		'IT001113' => 'Germagnano',
		'IT001114' => 'Giaglione',
		'IT001115' => 'Giaveno',
		'IT001116' => 'Givoletto',
		'IT001117' => 'Gravere',
		'IT001118' => 'Groscavallo',
		'IT001119' => 'Grosso',
		'IT001120' => 'Grugliasco',
		'IT001121' => 'Ingria',
		'IT001122' => 'Inverso Pinasca',
		'IT001123' => 'Isolabella',
		'IT001124' => 'Issiglio',
		'IT001125' => 'Ivrea',
		'IT001126' => 'La Cassa',
		'IT001127' => 'La Loggia',
		'IT001128' => 'Lanzo Torinese',
		'IT001129' => 'Lauriano',
		'IT001130' => 'Leini',
		'IT001131' => 'Lemie',
		'IT001132' => 'Lessolo',
		'IT001133' => 'Levone',
		'IT001134' => 'Locana',
		'IT001135' => 'Lombardore',
		'IT001136' => 'Lombriasco',
		'IT001137' => 'Loranzè',
		'IT001139' => 'Luserna San Giovanni',
		'IT001140' => 'Lusernetta',
		'IT001141' => 'Lusigliè',
		'IT001142' => 'Macello',
		'IT001143' => 'Maglione',
		'IT001144' => 'Marentino',
		'IT001145' => 'Massello',
		'IT001146' => 'Mathi',
		'IT001147' => 'Mattie',
		'IT001148' => 'Mazzè',
		'IT001149' => 'Meana di Susa',
		'IT001150' => 'Mercenasco',
		'IT001152' => 'Mezzenile',
		'IT001153' => 'Mombello di Torino',
		'IT001154' => 'Mompantero',
		'IT001155' => 'Monastero di Lanzo',
		'IT001156' => 'Moncalieri',
		'IT001157' => 'Moncenisio',
		'IT001158' => 'Montaldo Torinese',
		'IT001159' => 'Montalenghe',
		'IT001160' => 'Montalto Dora',
		'IT001161' => 'Montanaro',
		'IT001162' => 'Monteu da Po',
		'IT001163' => 'Moriondo Torinese',
		'IT001164' => 'Nichelino',
		'IT001165' => 'Noasca',
		'IT001166' => 'Nole',
		'IT001167' => 'Nomaglio',
		'IT001168' => 'None',
		'IT001169' => 'Novalesa',
		'IT001170' => 'Oglianico',
		'IT001171' => 'Orbassano',
		'IT001172' => 'Orio Canavese',
		'IT001173' => 'Osasco',
		'IT001174' => 'Osasio',
		'IT001175' => 'Oulx',
		'IT001176' => 'Ozegna',
		'IT001177' => 'Palazzo Canavese',
		'IT001178' => 'Pancalieri',
		'IT001179' => 'Parella',
		'IT001180' => 'Pavarolo',
		'IT001181' => 'Pavone Canavese',
		'IT001183' => 'Pecetto Torinese',
		'IT001184' => 'Perosa Argentina',
		'IT001185' => 'Perosa Canavese',
		'IT001186' => 'Perrero',
		'IT001187' => 'Pertusio',
		'IT001188' => 'Pessinetto',
		'IT001189' => 'Pianezza',
		'IT001190' => 'Pinasca',
		'IT001191' => 'Pinerolo',
		'IT001192' => 'Pino Torinese',
		'IT001193' => 'Piobesi Torinese',
		'IT001194' => 'Piossasco',
		'IT001195' => 'Piscina',
		'IT001196' => 'Piverone',
		'IT001197' => 'Poirino',
		'IT001198' => 'Pomaretto',
		'IT001199' => 'Pont-Canavese',
		'IT001200' => 'Porte',
		'IT001201' => 'Pragelato',
		'IT001202' => 'Prali',
		'IT001203' => 'Pralormo',
		'IT001204' => 'Pramollo',
		'IT001205' => 'Prarostino',
		'IT001206' => 'Prascorsano',
		'IT001207' => 'Pratiglione',
		'IT001208' => 'Quagliuzzo',
		'IT001209' => 'Quassolo',
		'IT001210' => 'Quincinetto',
		'IT001211' => 'Reano',
		'IT001212' => 'Ribordone',
		'IT001213' => 'Rivalba',
		'IT001214' => 'Rivalta di Torino',
		'IT001215' => 'Riva presso Chieri',
		'IT001216' => 'Rivara',
		'IT001217' => 'Rivarolo Canavese',
		'IT001218' => 'Rivarossa',
		'IT001219' => 'Rivoli',
		'IT001220' => 'Robassomero',
		'IT001221' => 'Rocca Canavese',
		'IT001222' => 'Roletto',
		'IT001223' => 'Romano Canavese',
		'IT001224' => 'Ronco Canavese',
		'IT001225' => 'Rondissone',
		'IT001226' => 'Rorà',
		'IT001227' => 'Roure',
		'IT001228' => 'Rosta',
		'IT001229' => 'Rubiana',
		'IT001230' => 'Rueglio',
		'IT001231' => 'Salassa',
		'IT001232' => 'Salbertrand',
		'IT001233' => 'Salerano Canavese',
		'IT001234' => 'Salza di Pinerolo',
		'IT001235' => 'Samone',
		'IT001236' => 'San Benigno Canavese',
		'IT001237' => 'San Carlo Canavese',
		'IT001238' => 'San Colombano Belmonte',
		'IT001239' => 'San Didero',
		'IT001240' => 'San Francesco al Campo',
		'IT001241' => 'Sangano',
		'IT001242' => 'San Germano Chisone',
		'IT001243' => 'San Gillio',
		'IT001244' => 'San Giorgio Canavese',
		'IT001245' => 'San Giorio di Susa',
		'IT001246' => 'San Giusto Canavese',
		'IT001247' => 'San Martino Canavese',
		'IT001248' => 'San Maurizio Canavese',
		'IT001249' => 'San Mauro Torinese',
		'IT001250' => 'San Pietro Val Lemina',
		'IT001251' => 'San Ponso',
		'IT001252' => 'San Raffaele Cimena',
		'IT001253' => 'San Sebastiano da Po',
		'IT001254' => 'San Secondo di Pinerolo',
		'IT001255' => 'SantAmbrogio di Torino',
		'IT001256' => 'SantAntonino di Susa',
		'IT001257' => 'Santena',
		'IT001258' => 'Sauze di Cesana',
		'IT001259' => 'Sauze dOulx',
		'IT001260' => 'Scalenghe',
		'IT001261' => 'Scarmagno',
		'IT001262' => 'Sciolze',
		'IT001263' => 'Sestriere',
		'IT001264' => 'Settimo Rottaro',
		'IT001265' => 'Settimo Torinese',
		'IT001266' => 'Settimo Vittone',
		'IT001267' => 'Sparone',
		'IT001268' => 'Strambinello',
		'IT001269' => 'Strambino',
		'IT001270' => 'Susa',
		'IT001271' => 'Tavagnasco',
		'IT001272' => 'Torino',
		'IT001273' => 'Torrazza Piemonte',
		'IT001274' => 'Torre Canavese',
		'IT001275' => 'Torre Pellice',
		'IT001276' => 'Trana',
		'IT001278' => 'Traversella',
		'IT001279' => 'Traves',
		'IT001280' => 'Trofarello',
		'IT001281' => 'Usseaux',
		'IT001282' => 'Usseglio',
		'IT001283' => 'Vaie',
		'IT001284' => 'Val della Torre',
		'IT001285' => 'Valgioie',
		'IT001286' => 'Vallo Torinese',
		'IT001287' => 'Valperga',
		'IT001288' => 'Valprato Soana',
		'IT001289' => 'Varisella',
		'IT001290' => 'Vauda Canavese',
		'IT001291' => 'Venaus',
		'IT001292' => 'Venaria Reale',
		'IT001293' => 'Verolengo',
		'IT001294' => 'Verrua Savoia',
		'IT001295' => 'Vestignè',
		'IT001296' => 'Vialfrè',
		'IT001298' => 'Vidracco',
		'IT001299' => 'Vigone',
		'IT001300' => 'Villafranca Piemonte',
		'IT001301' => 'Villanova Canavese',
		'IT001302' => 'Villarbasse',
		'IT001303' => 'Villar Dora',
		'IT001304' => 'Villareggia',
		'IT001305' => 'Villar Focchiardo',
		'IT001306' => 'Villar Pellice',
		'IT001307' => 'Villar Perosa',
		'IT001308' => 'Villastellone',
		'IT001309' => 'Vinovo',
		'IT001310' => 'Virle Piemonte',
		'IT001311' => 'Vische',
		'IT001312' => 'Vistrorio',
		'IT001313' => 'Viù',
		'IT001314' => 'Volpiano',
		'IT001315' => 'Volvera',
		'IT001316' => 'Mappano',
		'IT001317' => 'Val di Chy',
		'IT001318' => 'Valchiusa',
	],
	'VC' => [
		'IT002002' => 'Alagna Valsesia',
		'IT002003' => 'Albano Vercellese',
		'IT002004' => 'Alice Castello',
		'IT002006' => 'Arborio',
		'IT002007' => 'Asigliano Vercellese',
		'IT002008' => 'Balmuccia',
		'IT002009' => 'Balocco',
		'IT002011' => 'Bianzè',
		'IT002014' => 'Boccioleto',
		'IT002015' => 'Borgo dAle',
		'IT002016' => 'Borgosesia',
		'IT002017' => 'Borgo Vercelli',
		'IT002021' => 'Buronzo',
		'IT002025' => 'Campertogno',
		'IT002029' => 'Carcoforo',
		'IT002030' => 'Caresana',
		'IT002031' => 'Caresanablot',
		'IT002032' => 'Carisio',
		'IT002033' => 'Casanova Elvo',
		'IT002035' => 'San Giacomo Vercellese',
		'IT002041' => 'Cervatto',
		'IT002042' => 'Cigliano',
		'IT002043' => 'Civiasco',
		'IT002045' => 'Collobiano',
		'IT002047' => 'Costanzana',
		'IT002048' => 'Cravagliana',
		'IT002049' => 'Crescentino',
		'IT002052' => 'Crova',
		'IT002054' => 'Desana',
		'IT002057' => 'Fobello',
		'IT002058' => 'Fontanetto Po',
		'IT002059' => 'Formigliana',
		'IT002061' => 'Gattinara',
		'IT002062' => 'Ghislarengo',
		'IT002065' => 'Greggio',
		'IT002066' => 'Guardabosone',
		'IT002067' => 'Lamporo',
		'IT002068' => 'Lenta',
		'IT002070' => 'Lignana',
		'IT002071' => 'Livorno Ferraris',
		'IT002072' => 'Lozzolo',
		'IT002078' => 'Mollia',
		'IT002079' => 'Moncrivello',
		'IT002082' => 'Motta de Conti',
		'IT002088' => 'Olcenengo',
		'IT002089' => 'Oldenico',
		'IT002090' => 'Palazzolo Vercellese',
		'IT002091' => 'Pertengo',
		'IT002093' => 'Pezzana',
		'IT002096' => 'Pila',
		'IT002097' => 'Piode',
		'IT002102' => 'Postua',
		'IT002104' => 'Prarolo',
		'IT002107' => 'Quarona',
		'IT002108' => 'Quinto Vercellese',
		'IT002110' => 'Rassa',
		'IT002113' => 'Rimella',
		'IT002115' => 'Rive',
		'IT002116' => 'Roasio',
		'IT002118' => 'Ronsecco',
		'IT002121' => 'Rossa',
		'IT002122' => 'Rovasenda',
		'IT002126' => 'Salasco',
		'IT002127' => 'Sali Vercellese',
		'IT002128' => 'Saluggia',
		'IT002131' => 'San Germano Vercellese',
		'IT002133' => 'Santhià',
		'IT002134' => 'Scopa',
		'IT002135' => 'Scopello',
		'IT002137' => 'Serravalle Sesia',
		'IT002142' => 'Stroppiana',
		'IT002147' => 'Tricerro',
		'IT002148' => 'Trino',
		'IT002150' => 'Tronzano Vercellese',
		'IT002152' => 'Valduggia',
		'IT002156' => 'Varallo',
		'IT002158' => 'Vercelli',
		'IT002163' => 'Villarboit',
		'IT002164' => 'Villata',
		'IT002166' => 'Vocca',
		'IT002170' => 'Alto Sermenza',
		'IT002171' => 'Cellio con Breia',
	],
	'NO' => [
		'IT003001' => 'Agrate Conturbia',
		'IT003002' => 'Ameno',
		'IT003006' => 'Armeno',
		'IT003008' => 'Arona',
		'IT003012' => 'Barengo',
		'IT003016' => 'Bellinzago Novarese',
		'IT003018' => 'Biandrate',
		'IT003019' => 'Boca',
		'IT003021' => 'Bogogno',
		'IT003022' => 'Bolzano Novarese',
		'IT003023' => 'Borgolavezzaro',
		'IT003024' => 'Borgomanero',
		'IT003025' => 'Borgo Ticino',
		'IT003026' => 'Briga Novarese',
		'IT003027' => 'Briona',
		'IT003030' => 'Caltignaga',
		'IT003032' => 'Cameri',
		'IT003036' => 'Carpignano Sesia',
		'IT003037' => 'Casalbeltrame',
		'IT003039' => 'Casaleggio Novara',
		'IT003040' => 'Casalino',
		'IT003041' => 'Casalvolone',
		'IT003042' => 'Castellazzo Novarese',
		'IT003043' => 'Castelletto sopra Ticino',
		'IT003044' => 'Cavaglietto',
		'IT003045' => 'Cavaglio dAgogna',
		'IT003047' => 'Cavallirio',
		'IT003049' => 'Cerano',
		'IT003051' => 'Colazza',
		'IT003052' => 'Comignago',
		'IT003055' => 'Cressa',
		'IT003058' => 'Cureggio',
		'IT003060' => 'Divignano',
		'IT003062' => 'Dormelletto',
		'IT003065' => 'Fara Novarese',
		'IT003066' => 'Fontaneto dAgogna',
		'IT003068' => 'Galliate',
		'IT003069' => 'Garbagna Novarese',
		'IT003070' => 'Gargallo',
		'IT003073' => 'Ghemme',
		'IT003076' => 'Gozzano',
		'IT003077' => 'Granozzo con Monticello',
		'IT003079' => 'Grignasco',
		'IT003082' => 'Invorio',
		'IT003083' => 'Landiona',
		'IT003084' => 'Lesa',
		'IT003088' => 'Maggiora',
		'IT003090' => 'Mandello Vitta',
		'IT003091' => 'Marano Ticino',
		'IT003093' => 'Massino Visconti',
		'IT003095' => 'Meina',
		'IT003097' => 'Mezzomerico',
		'IT003098' => 'Miasino',
		'IT003100' => 'Momo',
		'IT003103' => 'Nebbiuno',
		'IT003104' => 'Nibbiola',
		'IT003106' => 'Novara',
		'IT003108' => 'Oleggio',
		'IT003109' => 'Oleggio Castello',
		'IT003112' => 'Orta San Giulio',
		'IT003114' => 'Paruzzaro',
		'IT003115' => 'Pella',
		'IT003116' => 'Pettenasco',
		'IT003119' => 'Pisano',
		'IT003120' => 'Pogno',
		'IT003121' => 'Pombia',
		'IT003122' => 'Prato Sesia',
		'IT003129' => 'Recetto',
		'IT003130' => 'Romagnano Sesia',
		'IT003131' => 'Romentino',
		'IT003133' => 'San Maurizio dOpaglio',
		'IT003134' => 'San Nazzaro Sesia',
		'IT003135' => 'San Pietro Mosezzo',
		'IT003138' => 'Sillavengo',
		'IT003139' => 'Sizzano',
		'IT003140' => 'Soriso',
		'IT003141' => 'Sozzago',
		'IT003143' => 'Suno',
		'IT003144' => 'Terdobbiate',
		'IT003146' => 'Tornaco',
		'IT003149' => 'Trecate',
		'IT003153' => 'Vaprio dAgogna',
		'IT003154' => 'Varallo Pombia',
		'IT003158' => 'Vespolate',
		'IT003159' => 'Vicolungo',
		'IT003164' => 'Vinzaglio',
		'IT003166' => 'Gattico-Veruno',
	],
	'CN' => [
		'IT004001' => 'Acceglio',
		'IT004002' => 'Aisone',
		'IT004003' => 'Alba',
		'IT004004' => 'Albaretto della Torre',
		'IT004005' => 'Alto',
		'IT004006' => 'Argentera',
		'IT004007' => 'Arguello',
		'IT004008' => 'Bagnasco',
		'IT004009' => 'Bagnolo Piemonte',
		'IT004010' => 'Baldissero dAlba',
		'IT004011' => 'Barbaresco',
		'IT004012' => 'Barge',
		'IT004013' => 'Barolo',
		'IT004014' => 'Bastia Mondovì',
		'IT004015' => 'Battifollo',
		'IT004016' => 'Beinette',
		'IT004017' => 'Bellino',
		'IT004018' => 'Belvedere Langhe',
		'IT004019' => 'Bene Vagienna',
		'IT004020' => 'Benevello',
		'IT004021' => 'Bergolo',
		'IT004022' => 'Bernezzo',
		'IT004023' => 'Bonvicino',
		'IT004024' => 'Borgomale',
		'IT004025' => 'Borgo San Dalmazzo',
		'IT004026' => 'Bosia',
		'IT004027' => 'Bossolasco',
		'IT004028' => 'Boves',
		'IT004029' => 'Bra',
		'IT004030' => 'Briaglia',
		'IT004031' => 'Briga Alta',
		'IT004032' => 'Brondello',
		'IT004033' => 'Brossasco',
		'IT004034' => 'Busca',
		'IT004035' => 'Camerana',
		'IT004037' => 'Canale',
		'IT004038' => 'Canosio',
		'IT004039' => 'Caprauna',
		'IT004040' => 'Caraglio',
		'IT004041' => 'Caramagna Piemonte',
		'IT004042' => 'Cardè',
		'IT004043' => 'Carrù',
		'IT004044' => 'Cartignano',
		'IT004045' => 'Casalgrasso',
		'IT004046' => 'Castagnito',
		'IT004047' => 'Casteldelfino',
		'IT004049' => 'Castelletto Stura',
		'IT004050' => 'Castelletto Uzzone',
		'IT004051' => 'Castellinaldo dAlba',
		'IT004052' => 'Castellino Tanaro',
		'IT004053' => 'Castelmagno',
		'IT004054' => 'Castelnuovo di Ceva',
		'IT004055' => 'Castiglione Falletto',
		'IT004056' => 'Castiglione Tinella',
		'IT004057' => 'Castino',
		'IT004058' => 'Cavallerleone',
		'IT004059' => 'Cavallermaggiore',
		'IT004060' => 'Celle di Macra',
		'IT004061' => 'Centallo',
		'IT004062' => 'Ceresole Alba',
		'IT004063' => 'Cerretto Langhe',
		'IT004064' => 'Cervasca',
		'IT004065' => 'Cervere',
		'IT004066' => 'Ceva',
		'IT004067' => 'Cherasco',
		'IT004068' => 'Chiusa di Pesio',
		'IT004069' => 'Cigliè',
		'IT004070' => 'Cissone',
		'IT004071' => 'Clavesana',
		'IT004072' => 'Corneliano dAlba',
		'IT004073' => 'Cortemilia',
		'IT004074' => 'Cossano Belbo',
		'IT004075' => 'Costigliole Saluzzo',
		'IT004076' => 'Cravanzana',
		'IT004077' => 'Crissolo',
		'IT004078' => 'Cuneo',
		'IT004079' => 'Demonte',
		'IT004080' => 'Diano dAlba',
		'IT004081' => 'Dogliani',
		'IT004082' => 'Dronero',
		'IT004083' => 'Elva',
		'IT004084' => 'Entracque',
		'IT004085' => 'Envie',
		'IT004086' => 'Farigliano',
		'IT004087' => 'Faule',
		'IT004088' => 'Feisoglio',
		'IT004089' => 'Fossano',
		'IT004090' => 'Frabosa Soprana',
		'IT004091' => 'Frabosa Sottana',
		'IT004092' => 'Frassino',
		'IT004093' => 'Gaiola',
		'IT004094' => 'Gambasca',
		'IT004095' => 'Garessio',
		'IT004096' => 'Genola',
		'IT004097' => 'Gorzegno',
		'IT004098' => 'Gottasecca',
		'IT004099' => 'Govone',
		'IT004100' => 'Grinzane Cavour',
		'IT004101' => 'Guarene',
		'IT004102' => 'Igliano',
		'IT004103' => 'Isasca',
		'IT004104' => 'Lagnasco',
		'IT004105' => 'La Morra',
		'IT004106' => 'Lequio Berria',
		'IT004107' => 'Lequio Tanaro',
		'IT004108' => 'Lesegno',
		'IT004109' => 'Levice',
		'IT004110' => 'Limone Piemonte',
		'IT004111' => 'Lisio',
		'IT004112' => 'Macra',
		'IT004113' => 'Magliano Alfieri',
		'IT004114' => 'Magliano Alpi',
		'IT004115' => 'Mango',
		'IT004116' => 'Manta',
		'IT004117' => 'Marene',
		'IT004118' => 'Margarita',
		'IT004119' => 'Marmora',
		'IT004120' => 'Marsaglia',
		'IT004121' => 'Martiniana Po',
		'IT004122' => 'Melle',
		'IT004123' => 'Moiola',
		'IT004124' => 'Mombarcaro',
		'IT004125' => 'Mombasiglio',
		'IT004126' => 'Monastero di Vasco',
		'IT004127' => 'Monasterolo Casotto',
		'IT004128' => 'Monasterolo di Savigliano',
		'IT004129' => 'Monchiero',
		'IT004130' => 'Mondovì',
		'IT004131' => 'Monesiglio',
		'IT004132' => 'Monforte dAlba',
		'IT004133' => 'Montà',
		'IT004134' => 'Montaldo di Mondovì',
		'IT004135' => 'Montaldo Roero',
		'IT004136' => 'Montanera',
		'IT004137' => 'Montelupo Albese',
		'IT004138' => 'Montemale di Cuneo',
		'IT004139' => 'Monterosso Grana',
		'IT004140' => 'Monteu Roero',
		'IT004141' => 'Montezemolo',
		'IT004142' => 'Monticello dAlba',
		'IT004143' => 'Moretta',
		'IT004144' => 'Morozzo',
		'IT004145' => 'Murazzano',
		'IT004146' => 'Murello',
		'IT004147' => 'Narzole',
		'IT004148' => 'Neive',
		'IT004149' => 'Neviglie',
		'IT004150' => 'Niella Belbo',
		'IT004151' => 'Niella Tanaro',
		'IT004152' => 'Novello',
		'IT004153' => 'Nucetto',
		'IT004154' => 'Oncino',
		'IT004155' => 'Ormea',
		'IT004156' => 'Ostana',
		'IT004157' => 'Paesana',
		'IT004158' => 'Pagno',
		'IT004159' => 'Pamparato',
		'IT004160' => 'Paroldo',
		'IT004161' => 'Perletto',
		'IT004162' => 'Perlo',
		'IT004163' => 'Peveragno',
		'IT004164' => 'Pezzolo Valle Uzzone',
		'IT004165' => 'Pianfei',
		'IT004166' => 'Piasco',
		'IT004167' => 'Pietraporzio',
		'IT004168' => 'Piobesi dAlba',
		'IT004169' => 'Piozzo',
		'IT004170' => 'Pocapaglia',
		'IT004171' => 'Polonghera',
		'IT004172' => 'Pontechianale',
		'IT004173' => 'Pradleves',
		'IT004174' => 'Prazzo',
		'IT004175' => 'Priero',
		'IT004176' => 'Priocca',
		'IT004177' => 'Priola',
		'IT004178' => 'Prunetto',
		'IT004179' => 'Racconigi',
		'IT004180' => 'Revello',
		'IT004181' => 'Rifreddo',
		'IT004182' => 'Rittana',
		'IT004183' => 'Roaschia',
		'IT004184' => 'Roascio',
		'IT004185' => 'Robilante',
		'IT004186' => 'Roburent',
		'IT004187' => 'Roccabruna',
		'IT004188' => 'Rocca Cigliè',
		'IT004189' => 'Rocca de Baldi',
		'IT004190' => 'Roccaforte Mondovì',
		'IT004191' => 'Roccasparvera',
		'IT004192' => 'Roccavione',
		'IT004193' => 'Rocchetta Belbo',
		'IT004194' => 'Roddi',
		'IT004195' => 'Roddino',
		'IT004196' => 'Rodello',
		'IT004197' => 'Rossana',
		'IT004198' => 'Ruffia',
		'IT004199' => 'Sale delle Langhe',
		'IT004200' => 'Sale San Giovanni',
		'IT004201' => 'Saliceto',
		'IT004202' => 'Salmour',
		'IT004203' => 'Saluzzo',
		'IT004204' => 'Sambuco',
		'IT004205' => 'Sampeyre',
		'IT004206' => 'San Benedetto Belbo',
		'IT004207' => 'San Damiano Macra',
		'IT004208' => 'Sanfrè',
		'IT004209' => 'Sanfront',
		'IT004210' => 'San Michele Mondovì',
		'IT004211' => 'SantAlbano Stura',
		'IT004212' => 'Santa Vittoria dAlba',
		'IT004213' => 'Santo Stefano Belbo',
		'IT004214' => 'Santo Stefano Roero',
		'IT004215' => 'Savigliano',
		'IT004216' => 'Scagnello',
		'IT004217' => 'Scarnafigi',
		'IT004218' => 'Serralunga dAlba',
		'IT004219' => 'Serravalle Langhe',
		'IT004220' => 'Sinio',
		'IT004221' => 'Somano',
		'IT004222' => 'Sommariva del Bosco',
		'IT004223' => 'Sommariva Perno',
		'IT004224' => 'Stroppo',
		'IT004225' => 'Tarantasca',
		'IT004226' => 'Torre Bormida',
		'IT004227' => 'Torre Mondovì',
		'IT004228' => 'Torre San Giorgio',
		'IT004229' => 'Torresina',
		'IT004230' => 'Treiso',
		'IT004231' => 'Trezzo Tinella',
		'IT004232' => 'Trinità',
		'IT004233' => 'Valdieri',
		'IT004234' => 'Valgrana',
		'IT004235' => 'Valloriate',
		'IT004237' => 'Venasca',
		'IT004238' => 'Verduno',
		'IT004239' => 'Vernante',
		'IT004240' => 'Verzuolo',
		'IT004241' => 'Vezza dAlba',
		'IT004242' => 'Vicoforte',
		'IT004243' => 'Vignolo',
		'IT004244' => 'Villafalletto',
		'IT004245' => 'Villanova Mondovì',
		'IT004246' => 'Villanova Solaro',
		'IT004247' => 'Villar San Costanzo',
		'IT004248' => 'Vinadio',
		'IT004249' => 'Viola',
		'IT004250' => 'Vottignasco',
	],
	'AT' => [
		'IT005001' => 'Agliano Terme',
		'IT005002' => 'Albugnano',
		'IT005003' => 'Antignano',
		'IT005004' => 'Aramengo',
		'IT005005' => 'Asti',
		'IT005006' => 'Azzano dAsti',
		'IT005007' => 'Baldichieri dAsti',
		'IT005008' => 'Belveglio',
		'IT005009' => 'Berzano di San Pietro',
		'IT005010' => 'Bruno',
		'IT005011' => 'Bubbio',
		'IT005012' => 'Buttigliera dAsti',
		'IT005013' => 'Calamandrana',
		'IT005014' => 'Calliano',
		'IT005015' => 'Calosso',
		'IT005016' => 'Camerano Casasco',
		'IT005017' => 'Canelli',
		'IT005018' => 'Cantarana',
		'IT005019' => 'Capriglio',
		'IT005020' => 'Casorzo',
		'IT005021' => 'Cassinasco',
		'IT005022' => 'Castagnole delle Lanze',
		'IT005023' => 'Castagnole Monferrato',
		'IT005024' => 'Castel Boglione',
		'IT005025' => 'CastellAlfero',
		'IT005026' => 'Castellero',
		'IT005027' => 'Castelletto Molina',
		'IT005028' => 'Castello di Annone',
		'IT005029' => 'Castelnuovo Belbo',
		'IT005030' => 'Castelnuovo Calcea',
		'IT005031' => 'Castelnuovo Don Bosco',
		'IT005032' => 'Castel Rocchero',
		'IT005033' => 'Cellarengo',
		'IT005034' => 'Celle Enomondo',
		'IT005035' => 'Cerreto dAsti',
		'IT005036' => 'Cerro Tanaro',
		'IT005037' => 'Cessole',
		'IT005038' => 'Chiusano dAsti',
		'IT005039' => 'Cinaglio',
		'IT005040' => 'Cisterna dAsti',
		'IT005041' => 'Coazzolo',
		'IT005042' => 'Cocconato',
		'IT005044' => 'Corsione',
		'IT005045' => 'Cortandone',
		'IT005046' => 'Cortanze',
		'IT005047' => 'Cortazzone',
		'IT005048' => 'Cortiglione',
		'IT005049' => 'Cossombrato',
		'IT005050' => 'Costigliole dAsti',
		'IT005051' => 'Cunico',
		'IT005052' => 'Dusino San Michele',
		'IT005053' => 'Ferrere',
		'IT005054' => 'Fontanile',
		'IT005055' => 'Frinco',
		'IT005056' => 'Grana',
		'IT005057' => 'Grazzano Badoglio',
		'IT005058' => 'Incisa Scapaccino',
		'IT005059' => 'Isola dAsti',
		'IT005060' => 'Loazzolo',
		'IT005061' => 'Maranzana',
		'IT005062' => 'Maretto',
		'IT005063' => 'Moasca',
		'IT005064' => 'Mombaldone',
		'IT005065' => 'Mombaruzzo',
		'IT005066' => 'Mombercelli',
		'IT005067' => 'Monale',
		'IT005068' => 'Monastero Bormida',
		'IT005069' => 'Moncalvo',
		'IT005070' => 'Moncucco Torinese',
		'IT005071' => 'Mongardino',
		'IT005072' => 'Montabone',
		'IT005073' => 'Montafia',
		'IT005074' => 'Montaldo Scarampi',
		'IT005075' => 'Montechiaro dAsti',
		'IT005076' => 'Montegrosso dAsti',
		'IT005077' => 'Montemagno',
		'IT005079' => 'Moransengo',
		'IT005080' => 'Nizza Monferrato',
		'IT005081' => 'Olmo Gentile',
		'IT005082' => 'Passerano Marmorito',
		'IT005083' => 'Penango',
		'IT005084' => 'Piea',
		'IT005085' => 'Pino dAsti',
		'IT005086' => 'Piovà Massaia',
		'IT005087' => 'Portacomaro',
		'IT005088' => 'Quaranti',
		'IT005089' => 'Refrancore',
		'IT005090' => 'Revigliasco dAsti',
		'IT005091' => 'Roatto',
		'IT005092' => 'Robella',
		'IT005093' => 'Rocca dArazzo',
		'IT005094' => 'Roccaverano',
		'IT005095' => 'Rocchetta Palafea',
		'IT005096' => 'Rocchetta Tanaro',
		'IT005097' => 'San Damiano dAsti',
		'IT005098' => 'San Giorgio Scarampi',
		'IT005099' => 'San Martino Alfieri',
		'IT005100' => 'San Marzano Oliveto',
		'IT005101' => 'San Paolo Solbrito',
		'IT005103' => 'Scurzolengo',
		'IT005104' => 'Serole',
		'IT005105' => 'Sessame',
		'IT005106' => 'Settime',
		'IT005107' => 'Soglio',
		'IT005108' => 'Tigliole',
		'IT005109' => 'Tonco',
		'IT005110' => 'Tonengo',
		'IT005111' => 'Vaglio Serra',
		'IT005112' => 'Valfenera',
		'IT005113' => 'Vesime',
		'IT005114' => 'Viale',
		'IT005115' => 'Viarigi',
		'IT005116' => 'Vigliano dAsti',
		'IT005117' => 'Villafranca dAsti',
		'IT005118' => 'Villanova dAsti',
		'IT005119' => 'Villa San Secondo',
		'IT005120' => 'Vinchio',
		'IT005121' => 'Montiglio Monferrato',
	],
	'AL' => [
		'IT006001' => 'Acqui Terme',
		'IT006002' => 'Albera Ligure',
		'IT006003' => 'Alessandria',
		'IT006004' => 'Alfiano Natta',
		'IT006005' => 'Alice Bel Colle',
		'IT006007' => 'Altavilla Monferrato',
		'IT006008' => 'Alzano Scrivia',
		'IT006009' => 'Arquata Scrivia',
		'IT006010' => 'Avolasca',
		'IT006011' => 'Balzola',
		'IT006012' => 'Basaluzzo',
		'IT006013' => 'Bassignana',
		'IT006014' => 'Belforte Monferrato',
		'IT006015' => 'Bergamasco',
		'IT006016' => 'Berzano di Tortona',
		'IT006017' => 'Bistagno',
		'IT006018' => 'Borghetto di Borbera',
		'IT006019' => 'Borgoratto Alessandrino',
		'IT006020' => 'Borgo San Martino',
		'IT006021' => 'Bosco Marengo',
		'IT006022' => 'Bosio',
		'IT006023' => 'Bozzole',
		'IT006024' => 'Brignano-Frascata',
		'IT006025' => 'Cabella Ligure',
		'IT006026' => 'Camagna Monferrato',
		'IT006027' => 'Camino',
		'IT006028' => 'Cantalupo Ligure',
		'IT006029' => 'Capriata dOrba',
		'IT006030' => 'Carbonara Scrivia',
		'IT006031' => 'Carentino',
		'IT006032' => 'Carezzano',
		'IT006033' => 'Carpeneto',
		'IT006034' => 'Carrega Ligure',
		'IT006035' => 'Carrosio',
		'IT006036' => 'Cartosio',
		'IT006037' => 'Casal Cermelli',
		'IT006038' => 'Casaleggio Boiro',
		'IT006039' => 'Casale Monferrato',
		'IT006040' => 'Casalnoceto',
		'IT006041' => 'Casasco',
		'IT006043' => 'Cassine',
		'IT006044' => 'Cassinelle',
		'IT006045' => 'Castellania',
		'IT006046' => 'Castellar Guidobono',
		'IT006047' => 'Castellazzo Bormida',
		'IT006048' => 'Castelletto dErro',
		'IT006049' => 'Castelletto dOrba',
		'IT006050' => 'Castelletto Merli',
		'IT006051' => 'Castelletto Monferrato',
		'IT006052' => 'Castelnuovo Bormida',
		'IT006053' => 'Castelnuovo Scrivia',
		'IT006054' => 'Castelspina',
		'IT006055' => 'Cavatore',
		'IT006056' => 'Cella Monte',
		'IT006057' => 'Cereseto',
		'IT006058' => 'Cerreto Grue',
		'IT006059' => 'Cerrina Monferrato',
		'IT006060' => 'Coniolo',
		'IT006061' => 'Conzano',
		'IT006062' => 'Costa Vescovato',
		'IT006063' => 'Cremolino',
		'IT006064' => 'Cuccaro Monferrato',
		'IT006065' => 'Denice',
		'IT006066' => 'Dernice',
		'IT006067' => 'Fabbrica Curone',
		'IT006068' => 'Felizzano',
		'IT006069' => 'Fraconalto',
		'IT006070' => 'Francavilla Bisio',
		'IT006071' => 'Frascaro',
		'IT006072' => 'Frassinello Monferrato',
		'IT006073' => 'Frassineto Po',
		'IT006074' => 'Fresonara',
		'IT006075' => 'Frugarolo',
		'IT006076' => 'Fubine Monferrato',
		'IT006077' => 'Gabiano',
		'IT006078' => 'Gamalero',
		'IT006079' => 'Garbagna',
		'IT006081' => 'Gavi',
		'IT006082' => 'Giarole',
		'IT006083' => 'Gremiasco',
		'IT006084' => 'Grognardo',
		'IT006085' => 'Grondona',
		'IT006086' => 'Guazzora',
		'IT006087' => 'Isola SantAntonio',
		'IT006088' => 'Lerma',
		'IT006089' => 'Lu',
		'IT006090' => 'Malvicino',
		'IT006091' => 'Masio',
		'IT006092' => 'Melazzo',
		'IT006093' => 'Merana',
		'IT006094' => 'Mirabello Monferrato',
		'IT006095' => 'Molare',
		'IT006096' => 'Molino dei Torti',
		'IT006097' => 'Mombello Monferrato',
		'IT006098' => 'Momperone',
		'IT006099' => 'Moncestino',
		'IT006100' => 'Mongiardino Ligure',
		'IT006101' => 'Monleale',
		'IT006102' => 'Montacuto',
		'IT006103' => 'Montaldeo',
		'IT006104' => 'Montaldo Bormida',
		'IT006105' => 'Montecastello',
		'IT006106' => 'Montechiaro dAcqui',
		'IT006107' => 'Montegioco',
		'IT006108' => 'Montemarzino',
		'IT006109' => 'Morano sul Po',
		'IT006110' => 'Morbello',
		'IT006111' => 'Mornese',
		'IT006112' => 'Morsasco',
		'IT006113' => 'Murisengo',
		'IT006114' => 'Novi Ligure',
		'IT006115' => 'Occimiano',
		'IT006116' => 'Odalengo Grande',
		'IT006117' => 'Odalengo Piccolo',
		'IT006118' => 'Olivola',
		'IT006119' => 'Orsara Bormida',
		'IT006120' => 'Ottiglio',
		'IT006121' => 'Ovada',
		'IT006122' => 'Oviglio',
		'IT006123' => 'Ozzano Monferrato',
		'IT006124' => 'Paderna',
		'IT006125' => 'Pareto',
		'IT006126' => 'Parodi Ligure',
		'IT006127' => 'Pasturana',
		'IT006128' => 'Pecetto di Valenza',
		'IT006129' => 'Pietra Marazzi',
		'IT006131' => 'Pomaro Monferrato',
		'IT006132' => 'Pontecurone',
		'IT006133' => 'Pontestura',
		'IT006134' => 'Ponti',
		'IT006135' => 'Ponzano Monferrato',
		'IT006136' => 'Ponzone',
		'IT006137' => 'Pozzol Groppo',
		'IT006138' => 'Pozzolo Formigaro',
		'IT006139' => 'Prasco',
		'IT006140' => 'Predosa',
		'IT006141' => 'Quargnento',
		'IT006142' => 'Quattordio',
		'IT006143' => 'Ricaldone',
		'IT006144' => 'Rivalta Bormida',
		'IT006145' => 'Rivarone',
		'IT006146' => 'Roccaforte Ligure',
		'IT006147' => 'Rocca Grimalda',
		'IT006148' => 'Rocchetta Ligure',
		'IT006149' => 'Rosignano Monferrato',
		'IT006150' => 'Sala Monferrato',
		'IT006151' => 'Sale',
		'IT006152' => 'San Cristoforo',
		'IT006153' => 'San Giorgio Monferrato',
		'IT006154' => 'San Salvatore Monferrato',
		'IT006155' => 'San Sebastiano Curone',
		'IT006156' => 'SantAgata Fossili',
		'IT006157' => 'Sardigliano',
		'IT006158' => 'Sarezzano',
		'IT006159' => 'Serralunga di Crea',
		'IT006160' => 'Serravalle Scrivia',
		'IT006161' => 'Sezzadio',
		'IT006162' => 'Silvano dOrba',
		'IT006163' => 'Solero',
		'IT006164' => 'Solonghello',
		'IT006165' => 'Spigno Monferrato',
		'IT006166' => 'Spineto Scrivia',
		'IT006167' => 'Stazzano',
		'IT006168' => 'Strevi',
		'IT006169' => 'Tagliolo Monferrato',
		'IT006170' => 'Tassarolo',
		'IT006171' => 'Terruggia',
		'IT006172' => 'Terzo',
		'IT006173' => 'Ticineto',
		'IT006174' => 'Tortona',
		'IT006175' => 'Treville',
		'IT006176' => 'Trisobbio',
		'IT006177' => 'Valenza',
		'IT006178' => 'Valmacca',
		'IT006179' => 'Vignale Monferrato',
		'IT006180' => 'Vignole Borbera',
		'IT006181' => 'Viguzzolo',
		'IT006182' => 'Villadeati',
		'IT006183' => 'Villalvernia',
		'IT006184' => 'Villamiroglio',
		'IT006185' => 'Villanova Monferrato',
		'IT006186' => 'Villaromagnano',
		'IT006187' => 'Visone',
		'IT006188' => 'Volpedo',
		'IT006189' => 'Volpeglino',
		'IT006190' => 'Voltaggio',
		'IT006191' => 'Cassano Spinola',
		'IT006192' => 'Alluvioni Piovera',
	],
	'BI' => [
		'IT096001' => 'Ailoche',
		'IT096002' => 'Andorno Micca',
		'IT096003' => 'Benna',
		'IT096004' => 'Biella',
		'IT096005' => 'Bioglio',
		'IT096006' => 'Borriana',
		'IT096007' => 'Brusnengo',
		'IT096008' => 'Callabiana',
		'IT096009' => 'Camandona',
		'IT096010' => 'Camburzano',
		'IT096012' => 'Candelo',
		'IT096013' => 'Caprile',
		'IT096014' => 'Casapinta',
		'IT096015' => 'Castelletto Cervo',
		'IT096016' => 'Cavaglià',
		'IT096018' => 'Cerrione',
		'IT096019' => 'Coggiola',
		'IT096020' => 'Cossato',
		'IT096021' => 'Crevacuore',
		'IT096023' => 'Curino',
		'IT096024' => 'Donato',
		'IT096025' => 'Dorzano',
		'IT096026' => 'Gaglianico',
		'IT096027' => 'Gifflenga',
		'IT096028' => 'Graglia',
		'IT096030' => 'Magnano',
		'IT096031' => 'Massazza',
		'IT096032' => 'Masserano',
		'IT096033' => 'Mezzana Mortigliengo',
		'IT096034' => 'Miagliano',
		'IT096035' => 'Mongrando',
		'IT096037' => 'Mottalciata',
		'IT096038' => 'Muzzano',
		'IT096039' => 'Netro',
		'IT096040' => 'Occhieppo Inferiore',
		'IT096041' => 'Occhieppo Superiore',
		'IT096042' => 'Pettinengo',
		'IT096043' => 'Piatto',
		'IT096044' => 'Piedicavallo',
		'IT096046' => 'Pollone',
		'IT096047' => 'Ponderano',
		'IT096048' => 'Portula',
		'IT096049' => 'Pralungo',
		'IT096050' => 'Pray',
		'IT096053' => 'Ronco Biellese',
		'IT096054' => 'Roppolo',
		'IT096055' => 'Rosazza',
		'IT096056' => 'Sagliano Micca',
		'IT096057' => 'Sala Biellese',
		'IT096058' => 'Salussola',
		'IT096059' => 'Sandigliano',
		'IT096063' => 'Sordevolo',
		'IT096064' => 'Sostegno',
		'IT096065' => 'Strona',
		'IT096066' => 'Tavigliano',
		'IT096067' => 'Ternengo',
		'IT096068' => 'Tollegno',
		'IT096069' => 'Torrazzo',
		'IT096071' => 'Valdengo',
		'IT096072' => 'Vallanzengo',
		'IT096074' => 'Valle San Nicolao',
		'IT096075' => 'Veglio',
		'IT096076' => 'Verrone',
		'IT096077' => 'Vigliano Biellese',
		'IT096078' => 'Villa del Bosco',
		'IT096079' => 'Villanova Biellese',
		'IT096080' => 'Viverone',
		'IT096081' => 'Zimone',
		'IT096082' => 'Zubiena',
		'IT096083' => 'Zumaglia',
		'IT096085' => 'Lessona',
		'IT096086' => 'Campiglia Cervo',
		'IT096087' => 'Quaregna Cerreto',
		'IT096088' => 'Valdilana',
	],
	'VB' => [
		'IT103001' => 'Antrona Schieranco',
		'IT103002' => 'Anzola dOssola',
		'IT103003' => 'Arizzano',
		'IT103004' => 'Arola',
		'IT103005' => 'Aurano',
		'IT103006' => 'Baceno',
		'IT103007' => 'Bannio Anzino',
		'IT103008' => 'Baveno',
		'IT103009' => 'Bee',
		'IT103010' => 'Belgirate',
		'IT103011' => 'Beura-Cardezza',
		'IT103012' => 'Bognanco',
		'IT103013' => 'Brovello-Carpugnino',
		'IT103014' => 'Calasca-Castiglione',
		'IT103015' => 'Cambiasca',
		'IT103016' => 'Cannero Riviera',
		'IT103017' => 'Cannobio',
		'IT103018' => 'Caprezzo',
		'IT103019' => 'Casale Corte Cerro',
		'IT103021' => 'Ceppo Morelli',
		'IT103022' => 'Cesara',
		'IT103023' => 'Cossogno',
		'IT103024' => 'Craveggia',
		'IT103025' => 'Crevoladossola',
		'IT103026' => 'Crodo',
		'IT103028' => 'Domodossola',
		'IT103029' => 'Druogno',
		'IT103031' => 'Formazza',
		'IT103032' => 'Germagno',
		'IT103033' => 'Ghiffa',
		'IT103034' => 'Gignese',
		'IT103035' => 'Gravellona Toce',
		'IT103036' => 'Gurro',
		'IT103037' => 'Intragna',
		'IT103038' => 'Loreglia',
		'IT103039' => 'Macugnaga',
		'IT103040' => 'Madonna del Sasso',
		'IT103041' => 'Malesco',
		'IT103042' => 'Masera',
		'IT103043' => 'Massiola',
		'IT103044' => 'Mergozzo',
		'IT103045' => 'Miazzina',
		'IT103046' => 'Montecrestese',
		'IT103047' => 'Montescheno',
		'IT103048' => 'Nonio',
		'IT103049' => 'Oggebbio',
		'IT103050' => 'Omegna',
		'IT103051' => 'Ornavasso',
		'IT103052' => 'Pallanzeno',
		'IT103053' => 'Piedimulera',
		'IT103054' => 'Pieve Vergonte',
		'IT103055' => 'Premeno',
		'IT103056' => 'Premia',
		'IT103057' => 'Premosello-Chiovenda',
		'IT103058' => 'Quarna Sopra',
		'IT103059' => 'Quarna Sotto',
		'IT103060' => 'Re',
		'IT103061' => 'San Bernardino Verbano',
		'IT103062' => 'Santa Maria Maggiore',
		'IT103064' => 'Stresa',
		'IT103065' => 'Toceno',
		'IT103066' => 'Trarego Viggiona',
		'IT103067' => 'Trasquera',
		'IT103068' => 'Trontano',
		'IT103069' => 'Valstrona',
		'IT103070' => 'Vanzone con San Carlo',
		'IT103071' => 'Varzo',
		'IT103072' => 'Verbania',
		'IT103074' => 'Vignone',
		'IT103075' => 'Villadossola',
		'IT103076' => 'Villette',
		'IT103077' => 'Vogogna',
		'IT103078' => 'Borgomezzavalle',
		'IT103079' => 'Valle Cannobina',
	],
	'AO' => [
		'IT007001' => 'Allein',
		'IT007002' => 'Antey-Saint-André',
		'IT007003' => 'Aosta',
		'IT007004' => 'Arnad',
		'IT007005' => 'Arvier',
		'IT007006' => 'Avise',
		'IT007007' => 'Ayas',
		'IT007008' => 'Aymavilles',
		'IT007009' => 'Bard',
		'IT007010' => 'Bionaz',
		'IT007011' => 'Brissogne',
		'IT007012' => 'Brusson',
		'IT007013' => 'Challand-Saint-Anselme',
		'IT007014' => 'Challand-Saint-Victor',
		'IT007015' => 'Chambave',
		'IT007016' => 'Chamois',
		'IT007017' => 'Champdepraz',
		'IT007018' => 'Champorcher',
		'IT007019' => 'Charvensod',
		'IT007020' => 'Châtillon',
		'IT007021' => 'Cogne',
		'IT007022' => 'Courmayeur',
		'IT007023' => 'Donnas',
		'IT007024' => 'Doues',
		'IT007025' => 'Emarèse',
		'IT007026' => 'Etroubles',
		'IT007027' => 'Fénis',
		'IT007028' => 'Fontainemore',
		'IT007029' => 'Gaby',
		'IT007030' => 'Gignod',
		'IT007031' => 'Gressan',
		'IT007032' => 'Gressoney-La-Trinité',
		'IT007033' => 'Gressoney-Saint-Jean',
		'IT007034' => 'Hône',
		'IT007035' => 'Introd',
		'IT007036' => 'Issime',
		'IT007037' => 'Issogne',
		'IT007038' => 'Jovençan',
		'IT007039' => 'La Magdeleine',
		'IT007040' => 'La Salle',
		'IT007041' => 'La Thuile',
		'IT007042' => 'Lillianes',
		'IT007043' => 'Montjovet',
		'IT007044' => 'Morgex',
		'IT007045' => 'Nus',
		'IT007046' => 'Ollomont',
		'IT007047' => 'Oyace',
		'IT007048' => 'Perloz',
		'IT007049' => 'Pollein',
		'IT007050' => 'Pontboset',
		'IT007051' => 'Pontey',
		'IT007052' => 'Pont-Saint-Martin',
		'IT007053' => 'Pré-Saint-Didier',
		'IT007054' => 'Quart',
		'IT007055' => 'Rhêmes-Notre-Dame',
		'IT007056' => 'Rhêmes-Saint-Georges',
		'IT007057' => 'Roisan',
		'IT007058' => 'Saint-Christophe',
		'IT007059' => 'Saint-Denis',
		'IT007060' => 'Saint-Marcel',
		'IT007061' => 'Saint-Nicolas',
		'IT007062' => 'Saint-Oyen',
		'IT007063' => 'Saint-Pierre',
		'IT007064' => 'Saint-Rhémy-en-Bosses',
		'IT007065' => 'Saint-Vincent',
		'IT007066' => 'Sarre',
		'IT007067' => 'Torgnon',
		'IT007068' => 'Valgrisenche',
		'IT007069' => 'Valpelline',
		'IT007070' => 'Valsavarenche',
		'IT007071' => 'Valtournenche',
		'IT007072' => 'Verrayes',
		'IT007073' => 'Verrès',
		'IT007074' => 'Villeneuve',
	],
	'VA' => [
		'IT012001' => 'Agra',
		'IT012002' => 'Albizzate',
		'IT012003' => 'Angera',
		'IT012004' => 'Arcisate',
		'IT012005' => 'Arsago Seprio',
		'IT012006' => 'Azzate',
		'IT012007' => 'Azzio',
		'IT012008' => 'Barasso',
		'IT012009' => 'Bardello',
		'IT012010' => 'Bedero Valcuvia',
		'IT012011' => 'Besano',
		'IT012012' => 'Besnate',
		'IT012013' => 'Besozzo',
		'IT012014' => 'Biandronno',
		'IT012015' => 'Bisuschio',
		'IT012016' => 'Bodio Lomnago',
		'IT012017' => 'Brebbia',
		'IT012018' => 'Bregano',
		'IT012019' => 'Brenta',
		'IT012020' => 'Brezzo di Bedero',
		'IT012021' => 'Brinzio',
		'IT012022' => 'Brissago-Valtravaglia',
		'IT012023' => 'Brunello',
		'IT012024' => 'Brusimpiano',
		'IT012025' => 'Buguggiate',
		'IT012026' => 'Busto Arsizio',
		'IT012027' => 'Cadegliano-Viconago',
		'IT012028' => 'Cadrezzate',
		'IT012029' => 'Cairate',
		'IT012030' => 'Cantello',
		'IT012031' => 'Caravate',
		'IT012032' => 'Cardano al Campo',
		'IT012033' => 'Carnago',
		'IT012034' => 'Caronno Pertusella',
		'IT012035' => 'Caronno Varesino',
		'IT012036' => 'Casale Litta',
		'IT012037' => 'Casalzuigno',
		'IT012038' => 'Casciago',
		'IT012039' => 'Casorate Sempione',
		'IT012040' => 'Cassano Magnago',
		'IT012041' => 'Cassano Valcuvia',
		'IT012042' => 'Castellanza',
		'IT012043' => 'Castello Cabiaglio',
		'IT012044' => 'Castelseprio',
		'IT012045' => 'Castelveccana',
		'IT012046' => 'Castiglione Olona',
		'IT012047' => 'Castronno',
		'IT012048' => 'Cavaria con Premezzo',
		'IT012049' => 'Cazzago Brabbia',
		'IT012050' => 'Cislago',
		'IT012051' => 'Cittiglio',
		'IT012052' => 'Clivio',
		'IT012053' => 'Cocquio-Trevisago',
		'IT012054' => 'Comabbio',
		'IT012055' => 'Comerio',
		'IT012056' => 'Cremenaga',
		'IT012057' => 'Crosio della Valle',
		'IT012058' => 'Cuasso al Monte',
		'IT012059' => 'Cugliate-Fabiasco',
		'IT012060' => 'Cunardo',
		'IT012061' => 'Curiglia con Monteviasco',
		'IT012062' => 'Cuveglio',
		'IT012063' => 'Cuvio',
		'IT012064' => 'Daverio',
		'IT012065' => 'Dumenza',
		'IT012066' => 'Duno',
		'IT012067' => 'Fagnano Olona',
		'IT012068' => 'Ferno',
		'IT012069' => 'Ferrera di Varese',
		'IT012070' => 'Gallarate',
		'IT012071' => 'Galliate Lombardo',
		'IT012072' => 'Gavirate',
		'IT012073' => 'Gazzada Schianno',
		'IT012074' => 'Gemonio',
		'IT012075' => 'Gerenzano',
		'IT012076' => 'Germignaga',
		'IT012077' => 'Golasecca',
		'IT012078' => 'Gorla Maggiore',
		'IT012079' => 'Gorla Minore',
		'IT012080' => 'Gornate Olona',
		'IT012081' => 'Grantola',
		'IT012082' => 'Inarzo',
		'IT012083' => 'Induno Olona',
		'IT012084' => 'Ispra',
		'IT012085' => 'Jerago con Orago',
		'IT012086' => 'Lavena Ponte Tresa',
		'IT012087' => 'Laveno-Mombello',
		'IT012088' => 'Leggiuno',
		'IT012089' => 'Lonate Ceppino',
		'IT012090' => 'Lonate Pozzolo',
		'IT012091' => 'Lozza',
		'IT012092' => 'Luino',
		'IT012093' => 'Luvinate',
		'IT012095' => 'Malgesso',
		'IT012096' => 'Malnate',
		'IT012097' => 'Marchirolo',
		'IT012098' => 'Marnate',
		'IT012099' => 'Marzio',
		'IT012100' => 'Masciago Primo',
		'IT012101' => 'Mercallo',
		'IT012102' => 'Mesenzana',
		'IT012103' => 'Montegrino Valtravaglia',
		'IT012104' => 'Monvalle',
		'IT012105' => 'Morazzone',
		'IT012106' => 'Mornago',
		'IT012107' => 'Oggiona con Santo Stefano',
		'IT012108' => 'Olgiate Olona',
		'IT012109' => 'Origgio',
		'IT012110' => 'Orino',
		'IT012111' => 'Osmate',
		'IT012113' => 'Porto Ceresio',
		'IT012114' => 'Porto Valtravaglia',
		'IT012115' => 'Rancio Valcuvia',
		'IT012116' => 'Ranco',
		'IT012117' => 'Saltrio',
		'IT012118' => 'Samarate',
		'IT012119' => 'Saronno',
		'IT012120' => 'Sesto Calende',
		'IT012121' => 'Solbiate Arno',
		'IT012122' => 'Solbiate Olona',
		'IT012123' => 'Somma Lombardo',
		'IT012124' => 'Sumirago',
		'IT012125' => 'Taino',
		'IT012126' => 'Ternate',
		'IT012127' => 'Tradate',
		'IT012128' => 'Travedona-Monate',
		'IT012129' => 'Tronzano Lago Maggiore',
		'IT012130' => 'Uboldo',
		'IT012131' => 'Valganna',
		'IT012132' => 'Varano Borghi',
		'IT012133' => 'Varese',
		'IT012134' => 'Vedano Olona',
		'IT012136' => 'Venegono Inferiore',
		'IT012137' => 'Venegono Superiore',
		'IT012138' => 'Vergiate',
		'IT012139' => 'Viggiù',
		'IT012140' => 'Vizzola Ticino',
		'IT012141' => 'Sangiano',
		'IT012142' => 'Maccagno con Pino e Veddasca',
	],
	'CO' => [
		'IT013003' => 'Albavilla',
		'IT013004' => 'Albese con Cassano',
		'IT013005' => 'Albiolo',
		'IT013006' => 'Alserio',
		'IT013007' => 'Alzate Brianza',
		'IT013009' => 'Anzano del Parco',
		'IT013010' => 'Appiano Gentile',
		'IT013011' => 'Argegno',
		'IT013012' => 'Arosio',
		'IT013013' => 'Asso',
		'IT013015' => 'Barni',
		'IT013021' => 'Bene Lario',
		'IT013022' => 'Beregazzo con Figliaro',
		'IT013023' => 'Binago',
		'IT013024' => 'Bizzarone',
		'IT013025' => 'Blessagno',
		'IT013026' => 'Blevio',
		'IT013028' => 'Bregnano',
		'IT013029' => 'Brenna',
		'IT013030' => 'Brienno',
		'IT013032' => 'Brunate',
		'IT013034' => 'Bulgarograsso',
		'IT013035' => 'Cabiate',
		'IT013036' => 'Cadorago',
		'IT013037' => 'Caglio',
		'IT013040' => 'Campione dItalia',
		'IT013041' => 'Cantù',
		'IT013042' => 'Canzo',
		'IT013043' => 'Capiago Intimiano',
		'IT013044' => 'Carate Urio',
		'IT013045' => 'Carbonate',
		'IT013046' => 'Carimate',
		'IT013047' => 'Carlazzo',
		'IT013048' => 'Carugo',
		'IT013052' => 'Caslino dErba',
		'IT013053' => 'Casnate con Bernate',
		'IT013055' => 'Cassina Rizzardi',
		'IT013058' => 'Castelmarte',
		'IT013059' => 'Castelnuovo Bozzente',
		'IT013062' => 'Cavargna',
		'IT013063' => 'Cerano dIntelvi',
		'IT013064' => 'Cermenate',
		'IT013065' => 'Cernobbio',
		'IT013068' => 'Cirimido',
		'IT013071' => 'Claino con Osteno',
		'IT013074' => 'Colonno',
		'IT013075' => 'Como',
		'IT013077' => 'Corrido',
		'IT013083' => 'Cremia',
		'IT013084' => 'Cucciago',
		'IT013085' => 'Cusino',
		'IT013087' => 'Dizzasco',
		'IT013089' => 'Domaso',
		'IT013090' => 'Dongo',
		'IT013092' => 'Dosso del Liro',
		'IT013095' => 'Erba',
		'IT013097' => 'Eupilio',
		'IT013098' => 'Faggeto Lario',
		'IT013099' => 'Faloppio',
		'IT013100' => 'Fenegrò',
		'IT013101' => 'Figino Serenza',
		'IT013102' => 'Fino Mornasco',
		'IT013106' => 'Garzeno',
		'IT013107' => 'Gera Lario',
		'IT013110' => 'Grandate',
		'IT013111' => 'Grandola ed Uniti',
		'IT013113' => 'Griante',
		'IT013114' => 'Guanzate',
		'IT013118' => 'Inverigo',
		'IT013119' => 'Laglio',
		'IT013120' => 'Laino',
		'IT013121' => 'Lambrugo',
		'IT013123' => 'Lasnigo',
		'IT013126' => 'Lezzeno',
		'IT013128' => 'Limido Comasco',
		'IT013129' => 'Lipomo',
		'IT013130' => 'Livo',
		'IT013131' => 'Locate Varesino',
		'IT013133' => 'Lomazzo',
		'IT013134' => 'Longone al Segrino',
		'IT013135' => 'Luisago',
		'IT013136' => 'Lurago dErba',
		'IT013137' => 'Lurago Marinone',
		'IT013138' => 'Lurate Caccivio',
		'IT013139' => 'Magreglio',
		'IT013143' => 'Mariano Comense',
		'IT013144' => 'Maslianico',
		'IT013145' => 'Menaggio',
		'IT013147' => 'Merone',
		'IT013152' => 'Moltrasio',
		'IT013153' => 'Monguzzo',
		'IT013154' => 'Montano Lucino',
		'IT013155' => 'Montemezzo',
		'IT013157' => 'Montorfano',
		'IT013159' => 'Mozzate',
		'IT013160' => 'Musso',
		'IT013161' => 'Nesso',
		'IT013163' => 'Novedrate',
		'IT013165' => 'Olgiate Comasco',
		'IT013169' => 'Oltrona di San Mamette',
		'IT013170' => 'Orsenigo',
		'IT013178' => 'Peglio',
		'IT013183' => 'Pianello del Lario',
		'IT013184' => 'Pigra',
		'IT013185' => 'Plesio',
		'IT013186' => 'Pognana Lario',
		'IT013187' => 'Ponna',
		'IT013188' => 'Ponte Lambro',
		'IT013189' => 'Porlezza',
		'IT013192' => 'Proserpio',
		'IT013193' => 'Pusiano',
		'IT013195' => 'Rezzago',
		'IT013197' => 'Rodero',
		'IT013199' => 'Ronago',
		'IT013201' => 'Rovellasca',
		'IT013202' => 'Rovello Porro',
		'IT013203' => 'Sala Comacina',
		'IT013204' => 'San Bartolomeo Val Cavargna',
		'IT013206' => 'San Fermo della Battaglia',
		'IT013207' => 'San Nazzaro Val Cavargna',
		'IT013211' => 'Schignano',
		'IT013212' => 'Senna Comasco',
		'IT013216' => 'Sorico',
		'IT013217' => 'Sormano',
		'IT013218' => 'Stazzona',
		'IT013222' => 'Tavernerio',
		'IT013223' => 'Torno',
		'IT013226' => 'Trezzone',
		'IT013227' => 'Turate',
		'IT013228' => 'Uggiate-Trevano',
		'IT013229' => 'Valbrona',
		'IT013232' => 'Valmorea',
		'IT013233' => 'Val Rezzo',
		'IT013234' => 'Valsolda',
		'IT013236' => 'Veleso',
		'IT013238' => 'Veniano',
		'IT013239' => 'Vercana',
		'IT013242' => 'Vertemate con Minoprio',
		'IT013245' => 'Villa Guardia',
		'IT013246' => 'Zelbio',
		'IT013248' => 'San Siro',
		'IT013249' => 'Gravedona ed Uniti',
		'IT013250' => 'Bellagio',
		'IT013251' => 'Colverde',
		'IT013252' => 'Tremezzina',
		'IT013253' => 'Alta Valle Intelvi',
		'IT013254' => 'Centro Valle Intelvi',
		'IT013255' => 'Solbiate con Cagno',
	],
	'SO' => [
		'IT014001' => 'Albaredo per San Marco',
		'IT014002' => 'Albosaggia',
		'IT014003' => 'Andalo Valtellino',
		'IT014004' => 'Aprica',
		'IT014005' => 'Ardenno',
		'IT014006' => 'Bema',
		'IT014007' => 'Berbenno di Valtellina',
		'IT014008' => 'Bianzone',
		'IT014009' => 'Bormio',
		'IT014010' => 'Buglio in Monte',
		'IT014011' => 'Caiolo',
		'IT014012' => 'Campodolcino',
		'IT014013' => 'Caspoggio',
		'IT014014' => 'Castello dellAcqua',
		'IT014015' => 'Castione Andevenno',
		'IT014016' => 'Cedrasco',
		'IT014017' => 'Cercino',
		'IT014018' => 'Chiavenna',
		'IT014019' => 'Chiesa in Valmalenco',
		'IT014020' => 'Chiuro',
		'IT014021' => 'Cino',
		'IT014022' => 'Civo',
		'IT014023' => 'Colorina',
		'IT014024' => 'Cosio Valtellino',
		'IT014025' => 'Dazio',
		'IT014026' => 'Delebio',
		'IT014027' => 'Dubino',
		'IT014028' => 'Faedo Valtellino',
		'IT014029' => 'Forcola',
		'IT014030' => 'Fusine',
		'IT014031' => 'Gerola Alta',
		'IT014032' => 'Gordona',
		'IT014033' => 'Grosio',
		'IT014034' => 'Grosotto',
		'IT014035' => 'Madesimo',
		'IT014036' => 'Lanzada',
		'IT014037' => 'Livigno',
		'IT014038' => 'Lovero',
		'IT014039' => 'Mantello',
		'IT014040' => 'Mazzo di Valtellina',
		'IT014041' => 'Mello',
		'IT014043' => 'Mese',
		'IT014044' => 'Montagna in Valtellina',
		'IT014045' => 'Morbegno',
		'IT014046' => 'Novate Mezzola',
		'IT014047' => 'Pedesina',
		'IT014048' => 'Piantedo',
		'IT014049' => 'Piateda',
		'IT014050' => 'Piuro',
		'IT014051' => 'Poggiridenti',
		'IT014052' => 'Ponte in Valtellina',
		'IT014053' => 'Postalesio',
		'IT014054' => 'Prata Camportaccio',
		'IT014055' => 'Rasura',
		'IT014056' => 'Rogolo',
		'IT014057' => 'Samolaco',
		'IT014058' => 'San Giacomo Filippo',
		'IT014059' => 'Sernio',
		'IT014060' => 'Sondalo',
		'IT014061' => 'Sondrio',
		'IT014062' => 'Spriana',
		'IT014063' => 'Talamona',
		'IT014064' => 'Tartano',
		'IT014065' => 'Teglio',
		'IT014066' => 'Tirano',
		'IT014067' => 'Torre di Santa Maria',
		'IT014068' => 'Tovo di SantAgata',
		'IT014069' => 'Traona',
		'IT014070' => 'Tresivio',
		'IT014071' => 'Valdidentro',
		'IT014072' => 'Valdisotto',
		'IT014073' => 'Valfurva',
		'IT014074' => 'Val Masino',
		'IT014075' => 'Verceia',
		'IT014076' => 'Vervio',
		'IT014077' => 'Villa di Chiavenna',
		'IT014078' => 'Villa di Tirano',
	],
	'MI' => [
		'IT015002' => 'Abbiategrasso',
		'IT015005' => 'Albairate',
		'IT015007' => 'Arconate',
		'IT015009' => 'Arese',
		'IT015010' => 'Arluno',
		'IT015011' => 'Assago',
		'IT015012' => 'Bareggio',
		'IT015014' => 'Basiano',
		'IT015015' => 'Basiglio',
		'IT015016' => 'Bellinzago Lombardo',
		'IT015019' => 'Bernate Ticino',
		'IT015022' => 'Besate',
		'IT015024' => 'Binasco',
		'IT015026' => 'Boffalora sopra Ticino',
		'IT015027' => 'Bollate',
		'IT015032' => 'Bresso',
		'IT015035' => 'Bubbiano',
		'IT015036' => 'Buccinasco',
		'IT015038' => 'Buscate',
		'IT015040' => 'Bussero',
		'IT015041' => 'Busto Garolfo',
		'IT015042' => 'Calvignasco',
		'IT015044' => 'Cambiago',
		'IT015046' => 'Canegrate',
		'IT015050' => 'Carpiano',
		'IT015051' => 'Carugate',
		'IT015055' => 'Casarile',
		'IT015058' => 'Casorezzo',
		'IT015059' => 'Cassano dAdda',
		'IT015060' => 'Cassina de Pecchi',
		'IT015061' => 'Cassinetta di Lugagnano',
		'IT015062' => 'Castano Primo',
		'IT015070' => 'Cernusco sul Naviglio',
		'IT015071' => 'Cerro al Lambro',
		'IT015072' => 'Cerro Maggiore',
		'IT015074' => 'Cesano Boscone',
		'IT015076' => 'Cesate',
		'IT015077' => 'Cinisello Balsamo',
		'IT015078' => 'Cisliano',
		'IT015081' => 'Cologno Monzese',
		'IT015082' => 'Colturano',
		'IT015085' => 'Corbetta',
		'IT015086' => 'Cormano',
		'IT015087' => 'Cornaredo',
		'IT015093' => 'Corsico',
		'IT015096' => 'Cuggiono',
		'IT015097' => 'Cusago',
		'IT015098' => 'Cusano Milanino',
		'IT015099' => 'Dairago',
		'IT015101' => 'Dresano',
		'IT015103' => 'Gaggiano',
		'IT015105' => 'Garbagnate Milanese',
		'IT015106' => 'Gessate',
		'IT015108' => 'Gorgonzola',
		'IT015110' => 'Grezzago',
		'IT015112' => 'Gudo Visconti',
		'IT015113' => 'Inveruno',
		'IT015114' => 'Inzago',
		'IT015115' => 'Lacchiarella',
		'IT015116' => 'Lainate',
		'IT015118' => 'Legnano',
		'IT015122' => 'Liscate',
		'IT015125' => 'Locate di Triulzi',
		'IT015130' => 'Magenta',
		'IT015131' => 'Magnago',
		'IT015134' => 'Marcallo con Casone',
		'IT015136' => 'Masate',
		'IT015139' => 'Mediglia',
		'IT015140' => 'Melegnano',
		'IT015142' => 'Melzo',
		'IT015144' => 'Mesero',
		'IT015146' => 'Milano',
		'IT015150' => 'Morimondo',
		'IT015151' => 'Motta Visconti',
		'IT015154' => 'Nerviano',
		'IT015155' => 'Nosate',
		'IT015157' => 'Novate Milanese',
		'IT015158' => 'Noviglio',
		'IT015159' => 'Opera',
		'IT015164' => 'Ossona',
		'IT015165' => 'Ozzero',
		'IT015166' => 'Paderno Dugnano',
		'IT015167' => 'Pantigliate',
		'IT015168' => 'Parabiago',
		'IT015169' => 'Paullo',
		'IT015170' => 'Pero',
		'IT015171' => 'Peschiera Borromeo',
		'IT015172' => 'Pessano con Bornago',
		'IT015173' => 'Pieve Emanuele',
		'IT015175' => 'Pioltello',
		'IT015176' => 'Pogliano Milanese',
		'IT015177' => 'Pozzo dAdda',
		'IT015178' => 'Pozzuolo Martesana',
		'IT015179' => 'Pregnana Milanese',
		'IT015181' => 'Rescaldina',
		'IT015182' => 'Rho',
		'IT015183' => 'Robecchetto con Induno',
		'IT015184' => 'Robecco sul Naviglio',
		'IT015185' => 'Rodano',
		'IT015188' => 'Rosate',
		'IT015189' => 'Rozzano',
		'IT015191' => 'San Colombano al Lambro',
		'IT015192' => 'San Donato Milanese',
		'IT015194' => 'San Giorgio su Legnano',
		'IT015195' => 'San Giuliano Milanese',
		'IT015200' => 'Santo Stefano Ticino',
		'IT015201' => 'San Vittore Olona',
		'IT015202' => 'San Zenone al Lambro',
		'IT015204' => 'Sedriano',
		'IT015205' => 'Segrate',
		'IT015206' => 'Senago',
		'IT015209' => 'Sesto San Giovanni',
		'IT015210' => 'Settala',
		'IT015211' => 'Settimo Milanese',
		'IT015213' => 'Solaro',
		'IT015219' => 'Trezzano Rosa',
		'IT015220' => 'Trezzano sul Naviglio',
		'IT015221' => 'Trezzo sullAdda',
		'IT015222' => 'Tribiano',
		'IT015224' => 'Truccazzano',
		'IT015226' => 'Turbigo',
		'IT015229' => 'Vanzago',
		'IT015230' => 'Vaprio dAdda',
		'IT015235' => 'Vermezzo',
		'IT015236' => 'Vernate',
		'IT015237' => 'Vignate',
		'IT015242' => 'Vimodrone',
		'IT015243' => 'Vittuone',
		'IT015244' => 'Vizzolo Predabissi',
		'IT015246' => 'Zelo Surrigone',
		'IT015247' => 'Zibido San Giacomo',
		'IT015248' => 'Villa Cortese',
		'IT015249' => 'Vanzaghello',
		'IT015250' => 'Baranzate',
	],
	'BG' => [
		'IT016001' => 'Adrara San Martino',
		'IT016002' => 'Adrara San Rocco',
		'IT016003' => 'Albano SantAlessandro',
		'IT016004' => 'Albino',
		'IT016005' => 'Almè',
		'IT016006' => 'Almenno San Bartolomeo',
		'IT016007' => 'Almenno San Salvatore',
		'IT016008' => 'Alzano Lombardo',
		'IT016009' => 'Ambivere',
		'IT016010' => 'Antegnate',
		'IT016011' => 'Arcene',
		'IT016012' => 'Ardesio',
		'IT016013' => 'Arzago dAdda',
		'IT016014' => 'Averara',
		'IT016015' => 'Aviatico',
		'IT016016' => 'Azzano San Paolo',
		'IT016017' => 'Azzone',
		'IT016018' => 'Bagnatica',
		'IT016019' => 'Barbata',
		'IT016020' => 'Bariano',
		'IT016021' => 'Barzana',
		'IT016022' => 'Bedulita',
		'IT016023' => 'Berbenno',
		'IT016024' => 'Bergamo',
		'IT016025' => 'Berzo San Fermo',
		'IT016026' => 'Bianzano',
		'IT016027' => 'Blello',
		'IT016028' => 'Bolgare',
		'IT016029' => 'Boltiere',
		'IT016030' => 'Bonate Sopra',
		'IT016031' => 'Bonate Sotto',
		'IT016032' => 'Borgo di Terzo',
		'IT016033' => 'Bossico',
		'IT016034' => 'Bottanuco',
		'IT016035' => 'Bracca',
		'IT016036' => 'Branzi',
		'IT016037' => 'Brembate',
		'IT016038' => 'Brembate di Sopra',
		'IT016040' => 'Brignano Gera dAdda',
		'IT016041' => 'Brumano',
		'IT016042' => 'Brusaporto',
		'IT016043' => 'Calcinate',
		'IT016044' => 'Calcio',
		'IT016046' => 'Calusco dAdda',
		'IT016047' => 'Calvenzano',
		'IT016048' => 'Camerata Cornello',
		'IT016049' => 'Canonica dAdda',
		'IT016050' => 'Capizzone',
		'IT016051' => 'Capriate San Gervasio',
		'IT016052' => 'Caprino Bergamasco',
		'IT016053' => 'Caravaggio',
		'IT016055' => 'Carobbio degli Angeli',
		'IT016056' => 'Carona',
		'IT016057' => 'Carvico',
		'IT016058' => 'Casazza',
		'IT016059' => 'Casirate dAdda',
		'IT016060' => 'Casnigo',
		'IT016061' => 'Cassiglio',
		'IT016062' => 'Castelli Calepio',
		'IT016063' => 'Castel Rozzone',
		'IT016064' => 'Castione della Presolana',
		'IT016065' => 'Castro',
		'IT016066' => 'Cavernago',
		'IT016067' => 'Cazzano SantAndrea',
		'IT016068' => 'Cenate Sopra',
		'IT016069' => 'Cenate Sotto',
		'IT016070' => 'Cene',
		'IT016071' => 'Cerete',
		'IT016072' => 'Chignolo dIsola',
		'IT016073' => 'Chiuduno',
		'IT016074' => 'Cisano Bergamasco',
		'IT016075' => 'Ciserano',
		'IT016076' => 'Cividate al Piano',
		'IT016077' => 'Clusone',
		'IT016078' => 'Colere',
		'IT016079' => 'Cologno al Serio',
		'IT016080' => 'Colzate',
		'IT016081' => 'Comun Nuovo',
		'IT016082' => 'Corna Imagna',
		'IT016083' => 'Cortenuova',
		'IT016084' => 'Costa di Mezzate',
		'IT016085' => 'Costa Valle Imagna',
		'IT016086' => 'Costa Volpino',
		'IT016087' => 'Covo',
		'IT016088' => 'Credaro',
		'IT016089' => 'Curno',
		'IT016090' => 'Cusio',
		'IT016091' => 'Dalmine',
		'IT016092' => 'Dossena',
		'IT016093' => 'Endine Gaiano',
		'IT016094' => 'Entratico',
		'IT016096' => 'Fara Gera dAdda',
		'IT016097' => 'Fara Olivana con Sola',
		'IT016098' => 'Filago',
		'IT016099' => 'Fino del Monte',
		'IT016100' => 'Fiorano al Serio',
		'IT016101' => 'Fontanella',
		'IT016102' => 'Fonteno',
		'IT016103' => 'Foppolo',
		'IT016104' => 'Foresto Sparso',
		'IT016105' => 'Fornovo San Giovanni',
		'IT016106' => 'Fuipiano Valle Imagna',
		'IT016107' => 'Gandellino',
		'IT016108' => 'Gandino',
		'IT016109' => 'Gandosso',
		'IT016110' => 'Gaverina Terme',
		'IT016111' => 'Gazzaniga',
		'IT016113' => 'Ghisalba',
		'IT016114' => 'Gorlago',
		'IT016115' => 'Gorle',
		'IT016116' => 'Gorno',
		'IT016117' => 'Grassobbio',
		'IT016118' => 'Gromo',
		'IT016119' => 'Grone',
		'IT016120' => 'Grumello del Monte',
		'IT016121' => 'Isola di Fondra',
		'IT016122' => 'Isso',
		'IT016123' => 'Lallio',
		'IT016124' => 'Leffe',
		'IT016125' => 'Lenna',
		'IT016126' => 'Levate',
		'IT016127' => 'Locatello',
		'IT016128' => 'Lovere',
		'IT016129' => 'Lurano',
		'IT016130' => 'Luzzana',
		'IT016131' => 'Madone',
		'IT016132' => 'Mapello',
		'IT016133' => 'Martinengo',
		'IT016134' => 'Mezzoldo',
		'IT016135' => 'Misano di Gera dAdda',
		'IT016136' => 'Moio de Calvi',
		'IT016137' => 'Monasterolo del Castello',
		'IT016139' => 'Montello',
		'IT016140' => 'Morengo',
		'IT016141' => 'Mornico al Serio',
		'IT016142' => 'Mozzanica',
		'IT016143' => 'Mozzo',
		'IT016144' => 'Nembro',
		'IT016145' => 'Olmo al Brembo',
		'IT016146' => 'Oltre il Colle',
		'IT016147' => 'Oltressenda Alta',
		'IT016148' => 'Oneta',
		'IT016149' => 'Onore',
		'IT016150' => 'Orio al Serio',
		'IT016151' => 'Ornica',
		'IT016152' => 'Osio Sopra',
		'IT016153' => 'Osio Sotto',
		'IT016154' => 'Pagazzano',
		'IT016155' => 'Paladina',
		'IT016156' => 'Palazzago',
		'IT016157' => 'Palosco',
		'IT016158' => 'Parre',
		'IT016159' => 'Parzanica',
		'IT016160' => 'Pedrengo',
		'IT016161' => 'Peia',
		'IT016162' => 'Pianico',
		'IT016163' => 'Piario',
		'IT016164' => 'Piazza Brembana',
		'IT016165' => 'Piazzatorre',
		'IT016166' => 'Piazzolo',
		'IT016167' => 'Pognano',
		'IT016168' => 'Ponte Nossa',
		'IT016169' => 'Ponteranica',
		'IT016170' => 'Ponte San Pietro',
		'IT016171' => 'Pontida',
		'IT016172' => 'Pontirolo Nuovo',
		'IT016173' => 'Pradalunga',
		'IT016174' => 'Predore',
		'IT016175' => 'Premolo',
		'IT016176' => 'Presezzo',
		'IT016177' => 'Pumenengo',
		'IT016178' => 'Ranica',
		'IT016179' => 'Ranzanico',
		'IT016180' => 'Riva di Solto',
		'IT016182' => 'Rogno',
		'IT016183' => 'Romano di Lombardia',
		'IT016184' => 'Roncobello',
		'IT016185' => 'Roncola',
		'IT016186' => 'Rota dImagna',
		'IT016187' => 'Rovetta',
		'IT016188' => 'San Giovanni Bianco',
		'IT016189' => 'San Paolo dArgon',
		'IT016190' => 'San Pellegrino Terme',
		'IT016191' => 'Santa Brigida',
		'IT016193' => 'Sarnico',
		'IT016194' => 'Scanzorosciate',
		'IT016195' => 'Schilpario',
		'IT016196' => 'Sedrina',
		'IT016197' => 'Selvino',
		'IT016198' => 'Seriate',
		'IT016199' => 'Serina',
		'IT016200' => 'Solto Collina',
		'IT016201' => 'Songavazzo',
		'IT016202' => 'Sorisole',
		'IT016203' => 'Sotto il Monte Giovanni XXIII',
		'IT016204' => 'Sovere',
		'IT016205' => 'Spinone al Lago',
		'IT016206' => 'Spirano',
		'IT016207' => 'Stezzano',
		'IT016208' => 'Strozza',
		'IT016209' => 'Suisio',
		'IT016210' => 'Taleggio',
		'IT016211' => 'Tavernola Bergamasca',
		'IT016212' => 'Telgate',
		'IT016213' => 'Terno dIsola',
		'IT016214' => 'Torre Boldone',
		'IT016215' => 'Torre de Busi',
		'IT016216' => 'Torre de Roveri',
		'IT016217' => 'Torre Pallavicina',
		'IT016218' => 'Trescore Balneario',
		'IT016219' => 'Treviglio',
		'IT016220' => 'Treviolo',
		'IT016221' => 'Ubiale Clanezzo',
		'IT016222' => 'Urgnano',
		'IT016223' => 'Valbondione',
		'IT016224' => 'Valbrembo',
		'IT016225' => 'Valgoglio',
		'IT016226' => 'Valleve',
		'IT016227' => 'Valnegra',
		'IT016229' => 'Valtorta',
		'IT016230' => 'Vedeseta',
		'IT016232' => 'Verdellino',
		'IT016233' => 'Verdello',
		'IT016234' => 'Vertova',
		'IT016235' => 'Viadanica',
		'IT016236' => 'Vigano San Martino',
		'IT016237' => 'Vigolo',
		'IT016238' => 'Villa dAdda',
		'IT016239' => 'Villa dAlmè',
		'IT016240' => 'Villa di Serio',
		'IT016241' => 'Villa dOgna',
		'IT016242' => 'Villongo',
		'IT016243' => 'Vilminore di Scalve',
		'IT016244' => 'Zandobbio',
		'IT016245' => 'Zanica',
		'IT016246' => 'Zogno',
		'IT016247' => 'Costa Serina',
		'IT016248' => 'Algua',
		'IT016249' => 'Cornalba',
		'IT016250' => 'Medolago',
		'IT016251' => 'Solza',
		'IT016252' => 'SantOmobono Terme',
		'IT016253' => 'Val Brembilla',
	],
	'BS' => [
		'IT017001' => 'Acquafredda',
		'IT017002' => 'Adro',
		'IT017003' => 'Agnosine',
		'IT017004' => 'Alfianello',
		'IT017005' => 'Anfo',
		'IT017006' => 'Angolo Terme',
		'IT017007' => 'Artogne',
		'IT017008' => 'Azzano Mella',
		'IT017009' => 'Bagnolo Mella',
		'IT017010' => 'Bagolino',
		'IT017011' => 'Barbariga',
		'IT017012' => 'Barghe',
		'IT017013' => 'Bassano Bresciano',
		'IT017014' => 'Bedizzole',
		'IT017015' => 'Berlingo',
		'IT017016' => 'Berzo Demo',
		'IT017017' => 'Berzo Inferiore',
		'IT017018' => 'Bienno',
		'IT017019' => 'Bione',
		'IT017020' => 'Borgo San Giacomo',
		'IT017021' => 'Borgosatollo',
		'IT017022' => 'Borno',
		'IT017023' => 'Botticino',
		'IT017024' => 'Bovegno',
		'IT017025' => 'Bovezzo',
		'IT017026' => 'Brandico',
		'IT017027' => 'Braone',
		'IT017028' => 'Breno',
		'IT017029' => 'Brescia',
		'IT017030' => 'Brione',
		'IT017031' => 'Caino',
		'IT017032' => 'Calcinato',
		'IT017033' => 'Calvagese della Riviera',
		'IT017034' => 'Calvisano',
		'IT017035' => 'Capo di Ponte',
		'IT017036' => 'Capovalle',
		'IT017037' => 'Capriano del Colle',
		'IT017038' => 'Capriolo',
		'IT017039' => 'Carpenedolo',
		'IT017040' => 'Castegnato',
		'IT017041' => 'Castelcovati',
		'IT017042' => 'Castel Mella',
		'IT017043' => 'Castenedolo',
		'IT017044' => 'Casto',
		'IT017045' => 'Castrezzato',
		'IT017046' => 'Cazzago San Martino',
		'IT017047' => 'Cedegolo',
		'IT017048' => 'Cellatica',
		'IT017049' => 'Cerveno',
		'IT017050' => 'Ceto',
		'IT017051' => 'Cevo',
		'IT017052' => 'Chiari',
		'IT017053' => 'Cigole',
		'IT017054' => 'Cimbergo',
		'IT017055' => 'Cividate Camuno',
		'IT017056' => 'Coccaglio',
		'IT017057' => 'Collebeato',
		'IT017058' => 'Collio',
		'IT017059' => 'Cologne',
		'IT017060' => 'Comezzano-Cizzago',
		'IT017061' => 'Concesio',
		'IT017062' => 'Corte Franca',
		'IT017063' => 'Corteno Golgi',
		'IT017064' => 'Corzano',
		'IT017065' => 'Darfo Boario Terme',
		'IT017066' => 'Dello',
		'IT017067' => 'Desenzano del Garda',
		'IT017068' => 'Edolo',
		'IT017069' => 'Erbusco',
		'IT017070' => 'Esine',
		'IT017071' => 'Fiesse',
		'IT017072' => 'Flero',
		'IT017073' => 'Gambara',
		'IT017074' => 'Gardone Riviera',
		'IT017075' => 'Gardone Val Trompia',
		'IT017076' => 'Gargnano',
		'IT017077' => 'Gavardo',
		'IT017078' => 'Ghedi',
		'IT017079' => 'Gianico',
		'IT017080' => 'Gottolengo',
		'IT017081' => 'Gussago',
		'IT017082' => 'Idro',
		'IT017083' => 'Incudine',
		'IT017084' => 'Irma',
		'IT017085' => 'Iseo',
		'IT017086' => 'Isorella',
		'IT017087' => 'Lavenone',
		'IT017088' => 'Leno',
		'IT017089' => 'Limone sul Garda',
		'IT017090' => 'Lodrino',
		'IT017091' => 'Lograto',
		'IT017092' => 'Lonato del Garda',
		'IT017093' => 'Longhena',
		'IT017094' => 'Losine',
		'IT017095' => 'Lozio',
		'IT017096' => 'Lumezzane',
		'IT017097' => 'Maclodio',
		'IT017098' => 'Magasa',
		'IT017099' => 'Mairano',
		'IT017100' => 'Malegno',
		'IT017101' => 'Malonno',
		'IT017102' => 'Manerba del Garda',
		'IT017103' => 'Manerbio',
		'IT017104' => 'Marcheno',
		'IT017105' => 'Marmentino',
		'IT017106' => 'Marone',
		'IT017107' => 'Mazzano',
		'IT017108' => 'Milzano',
		'IT017109' => 'Moniga del Garda',
		'IT017110' => 'Monno',
		'IT017111' => 'Monte Isola',
		'IT017112' => 'Monticelli Brusati',
		'IT017113' => 'Montichiari',
		'IT017114' => 'Montirone',
		'IT017115' => 'Mura',
		'IT017116' => 'Muscoline',
		'IT017117' => 'Nave',
		'IT017118' => 'Niardo',
		'IT017119' => 'Nuvolento',
		'IT017120' => 'Nuvolera',
		'IT017121' => 'Odolo',
		'IT017122' => 'Offlaga',
		'IT017123' => 'Ome',
		'IT017124' => 'Ono San Pietro',
		'IT017125' => 'Orzinuovi',
		'IT017126' => 'Orzivecchi',
		'IT017127' => 'Ospitaletto',
		'IT017128' => 'Ossimo',
		'IT017129' => 'Padenghe sul Garda',
		'IT017130' => 'Paderno Franciacorta',
		'IT017131' => 'Paisco Loveno',
		'IT017132' => 'Paitone',
		'IT017133' => 'Palazzolo sullOglio',
		'IT017134' => 'Paratico',
		'IT017135' => 'Paspardo',
		'IT017136' => 'Passirano',
		'IT017137' => 'Pavone del Mella',
		'IT017138' => 'San Paolo',
		'IT017139' => 'Pertica Alta',
		'IT017140' => 'Pertica Bassa',
		'IT017141' => 'Pezzaze',
		'IT017142' => 'Pian Camuno',
		'IT017143' => 'Pisogne',
		'IT017144' => 'Polaveno',
		'IT017145' => 'Polpenazze del Garda',
		'IT017146' => 'Pompiano',
		'IT017147' => 'Poncarale',
		'IT017148' => 'Ponte di Legno',
		'IT017149' => 'Pontevico',
		'IT017150' => 'Pontoglio',
		'IT017151' => 'Pozzolengo',
		'IT017152' => 'Pralboino',
		'IT017153' => 'Preseglie',
		'IT017155' => 'Prevalle',
		'IT017156' => 'Provaglio dIseo',
		'IT017157' => 'Provaglio Val Sabbia',
		'IT017158' => 'Puegnago sul Garda',
		'IT017159' => 'Quinzano dOglio',
		'IT017160' => 'Remedello',
		'IT017161' => 'Rezzato',
		'IT017162' => 'Roccafranca',
		'IT017163' => 'Rodengo Saiano',
		'IT017164' => 'Roè Volciano',
		'IT017165' => 'Roncadelle',
		'IT017166' => 'Rovato',
		'IT017167' => 'Rudiano',
		'IT017168' => 'Sabbio Chiese',
		'IT017169' => 'Sale Marasino',
		'IT017170' => 'Salò',
		'IT017171' => 'San Felice del Benaco',
		'IT017172' => 'San Gervasio Bresciano',
		'IT017173' => 'San Zeno Naviglio',
		'IT017174' => 'Sarezzo',
		'IT017175' => 'Saviore dellAdamello',
		'IT017176' => 'Sellero',
		'IT017177' => 'Seniga',
		'IT017178' => 'Serle',
		'IT017179' => 'Sirmione',
		'IT017180' => 'Soiano del Lago',
		'IT017181' => 'Sonico',
		'IT017182' => 'Sulzano',
		'IT017183' => 'Tavernole sul Mella',
		'IT017184' => 'Temù',
		'IT017185' => 'Tignale',
		'IT017186' => 'Torbole Casaglia',
		'IT017187' => 'Toscolano-Maderno',
		'IT017188' => 'Travagliato',
		'IT017189' => 'Tremosine sul Garda',
		'IT017190' => 'Trenzano',
		'IT017191' => 'Treviso Bresciano',
		'IT017192' => 'Urago dOglio',
		'IT017193' => 'Vallio Terme',
		'IT017194' => 'Valvestino',
		'IT017195' => 'Verolanuova',
		'IT017196' => 'Verolavecchia',
		'IT017197' => 'Vestone',
		'IT017198' => 'Vezza dOglio',
		'IT017199' => 'Villa Carcina',
		'IT017200' => 'Villachiara',
		'IT017201' => 'Villanuova sul Clisi',
		'IT017202' => 'Vione',
		'IT017203' => 'Visano',
		'IT017204' => 'Vobarno',
		'IT017205' => 'Zone',
		'IT017206' => 'Piancogno',
	],
	'PV' => [
		'IT018001' => 'Alagna',
		'IT018002' => 'Albaredo Arnaboldi',
		'IT018003' => 'Albonese',
		'IT018004' => 'Albuzzano',
		'IT018005' => 'Arena Po',
		'IT018006' => 'Badia Pavese',
		'IT018007' => 'Bagnaria',
		'IT018008' => 'Barbianello',
		'IT018009' => 'Bascapè',
		'IT018011' => 'Bastida Pancarana',
		'IT018012' => 'Battuda',
		'IT018013' => 'Belgioioso',
		'IT018014' => 'Bereguardo',
		'IT018015' => 'Borgarello',
		'IT018016' => 'Borgo Priolo',
		'IT018017' => 'Borgoratto Mormorolo',
		'IT018018' => 'Borgo San Siro',
		'IT018019' => 'Bornasco',
		'IT018020' => 'Bosnasco',
		'IT018021' => 'Brallo di Pregola',
		'IT018022' => 'Breme',
		'IT018023' => 'Bressana Bottarone',
		'IT018024' => 'Broni',
		'IT018025' => 'Calvignano',
		'IT018026' => 'Campospinoso',
		'IT018027' => 'Candia Lomellina',
		'IT018029' => 'Canneto Pavese',
		'IT018030' => 'Carbonara al Ticino',
		'IT018031' => 'Casanova Lonati',
		'IT018032' => 'Casatisma',
		'IT018033' => 'Casei Gerola',
		'IT018034' => 'Casorate Primo',
		'IT018035' => 'Cassolnovo',
		'IT018036' => 'Castana',
		'IT018037' => 'Casteggio',
		'IT018038' => 'Castelletto di Branduzzo',
		'IT018039' => 'Castello dAgogna',
		'IT018040' => 'Castelnovetto',
		'IT018041' => 'Cava Manara',
		'IT018042' => 'Cecima',
		'IT018043' => 'Ceranova',
		'IT018044' => 'Ceretto Lomellina',
		'IT018045' => 'Cergnago',
		'IT018046' => 'Certosa di Pavia',
		'IT018047' => 'Cervesina',
		'IT018048' => 'Chignolo Po',
		'IT018049' => 'Cigognola',
		'IT018050' => 'Cilavegna',
		'IT018051' => 'Codevilla',
		'IT018052' => 'Confienza',
		'IT018053' => 'Copiano',
		'IT018054' => 'Corana',
		'IT018057' => 'Corvino San Quirico',
		'IT018058' => 'Costa de Nobili',
		'IT018059' => 'Cozzo',
		'IT018060' => 'Cura Carpignano',
		'IT018061' => 'Dorno',
		'IT018062' => 'Ferrera Erbognone',
		'IT018063' => 'Filighera',
		'IT018064' => 'Fortunago',
		'IT018065' => 'Frascarolo',
		'IT018066' => 'Galliavola',
		'IT018067' => 'Gambarana',
		'IT018068' => 'Gambolò',
		'IT018069' => 'Garlasco',
		'IT018071' => 'Gerenzago',
		'IT018072' => 'Giussago',
		'IT018073' => 'Godiasco Salice Terme',
		'IT018074' => 'Golferenzo',
		'IT018075' => 'Gravellona Lomellina',
		'IT018076' => 'Gropello Cairoli',
		'IT018077' => 'Inverno e Monteleone',
		'IT018078' => 'Landriano',
		'IT018079' => 'Langosco',
		'IT018080' => 'Lardirago',
		'IT018081' => 'Linarolo',
		'IT018082' => 'Lirio',
		'IT018083' => 'Lomello',
		'IT018084' => 'Lungavilla',
		'IT018085' => 'Magherno',
		'IT018086' => 'Marcignago',
		'IT018087' => 'Marzano',
		'IT018088' => 'Mede',
		'IT018089' => 'Menconico',
		'IT018090' => 'Mezzana Bigli',
		'IT018091' => 'Mezzana Rabattone',
		'IT018092' => 'Mezzanino',
		'IT018093' => 'Miradolo Terme',
		'IT018094' => 'Montalto Pavese',
		'IT018095' => 'Montebello della Battaglia',
		'IT018096' => 'Montecalvo Versiggia',
		'IT018097' => 'Montescano',
		'IT018098' => 'Montesegale',
		'IT018099' => 'Monticelli Pavese',
		'IT018100' => 'Montù Beccaria',
		'IT018101' => 'Mornico Losana',
		'IT018102' => 'Mortara',
		'IT018103' => 'Nicorvo',
		'IT018104' => 'Olevano di Lomellina',
		'IT018105' => 'Oliva Gessi',
		'IT018106' => 'Ottobiano',
		'IT018107' => 'Palestro',
		'IT018108' => 'Pancarana',
		'IT018109' => 'Parona',
		'IT018110' => 'Pavia',
		'IT018111' => 'Pietra de Giorgi',
		'IT018112' => 'Pieve Albignola',
		'IT018113' => 'Pieve del Cairo',
		'IT018114' => 'Pieve Porto Morone',
		'IT018115' => 'Pinarolo Po',
		'IT018116' => 'Pizzale',
		'IT018117' => 'Ponte Nizza',
		'IT018118' => 'Portalbera',
		'IT018119' => 'Rea',
		'IT018120' => 'Redavalle',
		'IT018121' => 'Retorbido',
		'IT018122' => 'Rivanazzano Terme',
		'IT018123' => 'Robbio',
		'IT018124' => 'Robecco Pavese',
		'IT018125' => 'Rocca de Giorgi',
		'IT018126' => 'Rocca Susella',
		'IT018127' => 'Rognano',
		'IT018128' => 'Romagnese',
		'IT018129' => 'Roncaro',
		'IT018130' => 'Rosasco',
		'IT018131' => 'Rovescala',
		'IT018133' => 'San Cipriano Po',
		'IT018134' => 'San Damiano al Colle',
		'IT018135' => 'San Genesio ed Uniti',
		'IT018136' => 'San Giorgio di Lomellina',
		'IT018137' => 'San Martino Siccomario',
		'IT018138' => 'Sannazzaro de Burgondi',
		'IT018139' => 'Santa Cristina e Bissone',
		'IT018140' => 'Santa Giuletta',
		'IT018141' => 'SantAlessio con Vialone',
		'IT018142' => 'Santa Margherita di Staffora',
		'IT018143' => 'Santa Maria della Versa',
		'IT018144' => 'SantAngelo Lomellina',
		'IT018145' => 'San Zenone al Po',
		'IT018146' => 'Sartirana Lomellina',
		'IT018147' => 'Scaldasole',
		'IT018148' => 'Semiana',
		'IT018149' => 'Silvano Pietra',
		'IT018150' => 'Siziano',
		'IT018151' => 'Sommo',
		'IT018152' => 'Spessa',
		'IT018153' => 'Stradella',
		'IT018154' => 'Suardi',
		'IT018155' => 'Torrazza Coste',
		'IT018156' => 'Torre Beretti e Castellaro',
		'IT018157' => 'Torre dArese',
		'IT018158' => 'Torre de Negri',
		'IT018159' => 'Torre dIsola',
		'IT018160' => 'Torrevecchia Pia',
		'IT018161' => 'Torricella Verzate',
		'IT018162' => 'Travacò Siccomario',
		'IT018163' => 'Trivolzio',
		'IT018164' => 'Tromello',
		'IT018165' => 'Trovo',
		'IT018166' => 'Val di Nizza',
		'IT018167' => 'Valeggio',
		'IT018168' => 'Valle Lomellina',
		'IT018169' => 'Valle Salimbene',
		'IT018171' => 'Varzi',
		'IT018172' => 'Velezzo Lomellina',
		'IT018173' => 'Vellezzo Bellini',
		'IT018174' => 'Verretto',
		'IT018175' => 'Verrua Po',
		'IT018176' => 'Vidigulfo',
		'IT018177' => 'Vigevano',
		'IT018178' => 'Villa Biscossi',
		'IT018179' => 'Villanova dArdenghi',
		'IT018180' => 'Villanterio',
		'IT018181' => 'Vistarino',
		'IT018182' => 'Voghera',
		'IT018183' => 'Volpara',
		'IT018184' => 'Zavattarello',
		'IT018185' => 'Zeccone',
		'IT018186' => 'Zeme',
		'IT018187' => 'Zenevredo',
		'IT018188' => 'Zerbo',
		'IT018189' => 'Zerbolò',
		'IT018190' => 'Zinasco',
		'IT018191' => 'Cornale e Bastida',
		'IT018192' => 'Corteolona e Genzone',
		'IT018193' => 'Colli Verdi',
	],
	'CR' => [
		'IT019001' => 'Acquanegra Cremonese',
		'IT019002' => 'Agnadello',
		'IT019003' => 'Annicco',
		'IT019004' => 'Azzanello',
		'IT019005' => 'Bagnolo Cremasco',
		'IT019006' => 'Bonemerse',
		'IT019007' => 'Bordolano',
		'IT019009' => 'Calvatone',
		'IT019010' => 'Camisano',
		'IT019011' => 'Campagnola Cremasca',
		'IT019012' => 'Capergnanica',
		'IT019013' => 'Cappella Cantone',
		'IT019014' => 'Cappella de Picenardi',
		'IT019015' => 'Capralba',
		'IT019016' => 'Casalbuttano ed Uniti',
		'IT019017' => 'Casale Cremasco-Vidolasco',
		'IT019018' => 'Casaletto Ceredano',
		'IT019019' => 'Casaletto di Sopra',
		'IT019020' => 'Casaletto Vaprio',
		'IT019021' => 'Casalmaggiore',
		'IT019022' => 'Casalmorano',
		'IT019023' => 'Casteldidone',
		'IT019024' => 'Castel Gabbiano',
		'IT019025' => 'Castelleone',
		'IT019026' => 'Castelverde',
		'IT019027' => 'Castelvisconti',
		'IT019028' => 'Cella Dati',
		'IT019029' => 'Chieve',
		'IT019030' => 'Cicognolo',
		'IT019031' => 'Cingia de Botti',
		'IT019032' => 'Corte de Cortesi con Cignone',
		'IT019033' => 'Corte de Frati',
		'IT019034' => 'Credera Rubbiano',
		'IT019035' => 'Crema',
		'IT019036' => 'Cremona',
		'IT019037' => 'Cremosano',
		'IT019038' => 'Crotta dAdda',
		'IT019039' => 'Cumignano sul Naviglio',
		'IT019040' => 'Derovere',
		'IT019041' => 'Dovera',
		'IT019043' => 'Fiesco',
		'IT019044' => 'Formigara',
		'IT019045' => 'Gabbioneta-Binanuova',
		'IT019046' => 'Gadesco-Pieve Delmona',
		'IT019047' => 'Genivolta',
		'IT019048' => 'Gerre de Caprioli',
		'IT019049' => 'Gombito',
		'IT019050' => 'Grontardo',
		'IT019051' => 'Grumello Cremonese ed Uniti',
		'IT019052' => 'Gussola',
		'IT019053' => 'Isola Dovarese',
		'IT019054' => 'Izano',
		'IT019055' => 'Madignano',
		'IT019056' => 'Malagnino',
		'IT019057' => 'Martignana di Po',
		'IT019058' => 'Monte Cremasco',
		'IT019059' => 'Montodine',
		'IT019060' => 'Moscazzano',
		'IT019061' => 'Motta Baluffi',
		'IT019062' => 'Offanengo',
		'IT019063' => 'Olmeneta',
		'IT019064' => 'Ostiano',
		'IT019065' => 'Paderno Ponchielli',
		'IT019066' => 'Palazzo Pignano',
		'IT019067' => 'Pandino',
		'IT019068' => 'Persico Dosimo',
		'IT019069' => 'Pescarolo ed Uniti',
		'IT019070' => 'Pessina Cremonese',
		'IT019072' => 'Pianengo',
		'IT019073' => 'Pieranica',
		'IT019074' => 'Pieve dOlmi',
		'IT019075' => 'Pieve San Giacomo',
		'IT019076' => 'Pizzighettone',
		'IT019077' => 'Pozzaglio ed Uniti',
		'IT019078' => 'Quintano',
		'IT019079' => 'Ricengo',
		'IT019080' => 'Ripalta Arpina',
		'IT019081' => 'Ripalta Cremasca',
		'IT019082' => 'Ripalta Guerina',
		'IT019083' => 'Rivarolo del Re ed Uniti',
		'IT019084' => 'Rivolta dAdda',
		'IT019085' => 'Robecco dOglio',
		'IT019086' => 'Romanengo',
		'IT019087' => 'Salvirola',
		'IT019088' => 'San Bassano',
		'IT019089' => 'San Daniele Po',
		'IT019090' => 'San Giovanni in Croce',
		'IT019091' => 'San Martino del Lago',
		'IT019092' => 'Scandolara Ravara',
		'IT019093' => 'Scandolara Ripa dOglio',
		'IT019094' => 'Sergnano',
		'IT019095' => 'Sesto ed Uniti',
		'IT019096' => 'Solarolo Rainerio',
		'IT019097' => 'Soncino',
		'IT019098' => 'Soresina',
		'IT019099' => 'Sospiro',
		'IT019100' => 'Spinadesco',
		'IT019101' => 'Spineda',
		'IT019102' => 'Spino dAdda',
		'IT019103' => 'Stagno Lombardo',
		'IT019104' => 'Ticengo',
		'IT019105' => 'Torlino Vimercati',
		'IT019106' => 'Tornata',
		'IT019107' => 'Torre de Picenardi',
		'IT019108' => 'Torricella del Pizzo',
		'IT019109' => 'Trescore Cremasco',
		'IT019110' => 'Trigolo',
		'IT019111' => 'Vaiano Cremasco',
		'IT019112' => 'Vailate',
		'IT019113' => 'Vescovato',
		'IT019114' => 'Volongo',
		'IT019115' => 'Voltido',
		'IT019116' => 'Piadena Drizzona',
	],
	'MN' => [
		'IT020001' => 'Acquanegra sul Chiese',
		'IT020002' => 'Asola',
		'IT020003' => 'Bagnolo San Vito',
		'IT020007' => 'Bozzolo',
		'IT020008' => 'Canneto sullOglio',
		'IT020010' => 'Casalmoro',
		'IT020011' => 'Casaloldo',
		'IT020012' => 'Casalromano',
		'IT020013' => 'Castelbelforte',
		'IT020014' => 'Castel dArio',
		'IT020015' => 'Castel Goffredo',
		'IT020016' => 'Castellucchio',
		'IT020017' => 'Castiglione delle Stiviere',
		'IT020018' => 'Cavriana',
		'IT020019' => 'Ceresara',
		'IT020020' => 'Commessaggio',
		'IT020021' => 'Curtatone',
		'IT020022' => 'Dosolo',
		'IT020024' => 'Gazoldo degli Ippoliti',
		'IT020025' => 'Gazzuolo',
		'IT020026' => 'Goito',
		'IT020027' => 'Gonzaga',
		'IT020028' => 'Guidizzolo',
		'IT020029' => 'Magnacavallo',
		'IT020030' => 'Mantova',
		'IT020031' => 'Marcaria',
		'IT020032' => 'Mariana Mantovana',
		'IT020033' => 'Marmirolo',
		'IT020034' => 'Medole',
		'IT020035' => 'Moglia',
		'IT020036' => 'Monzambano',
		'IT020037' => 'Motteggiana',
		'IT020038' => 'Ostiglia',
		'IT020039' => 'Pegognaga',
		'IT020041' => 'Piubega',
		'IT020042' => 'Poggio Rusco',
		'IT020043' => 'Pomponesco',
		'IT020044' => 'Ponti sul Mincio',
		'IT020045' => 'Porto Mantovano',
		'IT020046' => 'Quingentole',
		'IT020047' => 'Quistello',
		'IT020048' => 'Redondesco',
		'IT020050' => 'Rivarolo Mantovano',
		'IT020051' => 'Rodigo',
		'IT020052' => 'Roncoferraro',
		'IT020053' => 'Roverbella',
		'IT020054' => 'Sabbioneta',
		'IT020055' => 'San Benedetto Po',
		'IT020056' => 'San Giacomo delle Segnate',
		'IT020057' => 'San Giorgio Bigarello',
		'IT020058' => 'San Giovanni del Dosso',
		'IT020059' => 'San Martino dallArgine',
		'IT020060' => 'Schivenoglia',
		'IT020061' => 'Sermide e Felonica',
		'IT020062' => 'Serravalle a Po',
		'IT020063' => 'Solferino',
		'IT020064' => 'Sustinente',
		'IT020065' => 'Suzzara',
		'IT020066' => 'Viadana',
		'IT020068' => 'Villimpenta',
		'IT020070' => 'Volta Mantovana',
		'IT020071' => 'Borgo Virgilio',
		'IT020072' => 'Borgo Mantovano',
		'IT020073' => 'Borgocarbonara',
	],
	'LC' => [
		'IT097001' => 'Abbadia Lariana',
		'IT097002' => 'Airuno',
		'IT097003' => 'Annone di Brianza',
		'IT097004' => 'Ballabio',
		'IT097005' => 'Barzago',
		'IT097006' => 'Barzanò',
		'IT097007' => 'Barzio',
		'IT097008' => 'Bellano',
		'IT097009' => 'Bosisio Parini',
		'IT097010' => 'Brivio',
		'IT097011' => 'Bulciago',
		'IT097012' => 'Calco',
		'IT097013' => 'Calolziocorte',
		'IT097014' => 'Carenno',
		'IT097015' => 'Casargo',
		'IT097016' => 'Casatenovo',
		'IT097017' => 'Cassago Brianza',
		'IT097018' => 'Cassina Valsassina',
		'IT097019' => 'Castello di Brianza',
		'IT097020' => 'Cernusco Lombardone',
		'IT097021' => 'Cesana Brianza',
		'IT097022' => 'Civate',
		'IT097023' => 'Colico',
		'IT097024' => 'Colle Brianza',
		'IT097025' => 'Cortenova',
		'IT097026' => 'Costa Masnaga',
		'IT097027' => 'Crandola Valsassina',
		'IT097028' => 'Cremella',
		'IT097029' => 'Cremeno',
		'IT097030' => 'Dervio',
		'IT097031' => 'Dolzago',
		'IT097032' => 'Dorio',
		'IT097033' => 'Ello',
		'IT097034' => 'Erve',
		'IT097035' => 'Esino Lario',
		'IT097036' => 'Galbiate',
		'IT097037' => 'Garbagnate Monastero',
		'IT097038' => 'Garlate',
		'IT097039' => 'Imbersago',
		'IT097040' => 'Introbio',
		'IT097042' => 'Lecco',
		'IT097043' => 'Lierna',
		'IT097044' => 'Lomagna',
		'IT097045' => 'Malgrate',
		'IT097046' => 'Mandello del Lario',
		'IT097047' => 'Margno',
		'IT097048' => 'Merate',
		'IT097049' => 'Missaglia',
		'IT097050' => 'Moggio',
		'IT097051' => 'Molteno',
		'IT097052' => 'Monte Marenzo',
		'IT097053' => 'Montevecchia',
		'IT097054' => 'Monticello Brianza',
		'IT097055' => 'Morterone',
		'IT097056' => 'Nibionno',
		'IT097057' => 'Oggiono',
		'IT097058' => 'Olgiate Molgora',
		'IT097059' => 'Olginate',
		'IT097060' => 'Oliveto Lario',
		'IT097061' => 'Osnago',
		'IT097062' => 'Paderno dAdda',
		'IT097063' => 'Pagnona',
		'IT097064' => 'Parlasco',
		'IT097065' => 'Pasturo',
		'IT097067' => 'Perledo',
		'IT097068' => 'Pescate',
		'IT097069' => 'Premana',
		'IT097070' => 'Primaluna',
		'IT097071' => 'Robbiate',
		'IT097072' => 'Rogeno',
		'IT097074' => 'Santa Maria Hoè',
		'IT097075' => 'Sirone',
		'IT097076' => 'Sirtori',
		'IT097077' => 'Sueglio',
		'IT097078' => 'Suello',
		'IT097079' => 'Taceno',
		'IT097082' => 'Valgreghentino',
		'IT097083' => 'Valmadrera',
		'IT097084' => 'Varenna',
		'IT097085' => 'Vendrogno',
		'IT097086' => 'Vercurago',
		'IT097090' => 'Viganò',
		'IT097091' => 'Verderio',
		'IT097092' => 'La Valletta Brianza',
		'IT097093' => 'Valvarrone',
	],
	'LO' => [
		'IT098001' => 'Abbadia Cerreto',
		'IT098002' => 'Bertonico',
		'IT098003' => 'Boffalora dAdda',
		'IT098004' => 'Borghetto Lodigiano',
		'IT098005' => 'Borgo San Giovanni',
		'IT098006' => 'Brembio',
		'IT098008' => 'Casaletto Lodigiano',
		'IT098009' => 'Casalmaiocco',
		'IT098010' => 'Casalpusterlengo',
		'IT098011' => 'Caselle Landi',
		'IT098012' => 'Caselle Lurani',
		'IT098013' => 'Castelnuovo Bocca dAdda',
		'IT098014' => 'Castiglione dAdda',
		'IT098015' => 'Castiraga Vidardo',
		'IT098017' => 'Cavenago dAdda',
		'IT098018' => 'Cervignano dAdda',
		'IT098019' => 'Codogno',
		'IT098020' => 'Comazzo',
		'IT098021' => 'Cornegliano Laudense',
		'IT098022' => 'Corno Giovine',
		'IT098023' => 'Cornovecchio',
		'IT098024' => 'Corte Palasio',
		'IT098025' => 'Crespiatica',
		'IT098026' => 'Fombio',
		'IT098027' => 'Galgagnano',
		'IT098028' => 'Graffignana',
		'IT098029' => 'Guardamiglio',
		'IT098030' => 'Livraga',
		'IT098031' => 'Lodi',
		'IT098032' => 'Lodi Vecchio',
		'IT098033' => 'Maccastorna',
		'IT098034' => 'Mairago',
		'IT098035' => 'Maleo',
		'IT098036' => 'Marudo',
		'IT098037' => 'Massalengo',
		'IT098038' => 'Meleti',
		'IT098039' => 'Merlino',
		'IT098040' => 'Montanaso Lombardo',
		'IT098041' => 'Mulazzano',
		'IT098042' => 'Orio Litta',
		'IT098043' => 'Ospedaletto Lodigiano',
		'IT098044' => 'Ossago Lodigiano',
		'IT098045' => 'Pieve Fissiraga',
		'IT098046' => 'Salerano sul Lambro',
		'IT098047' => 'San Fiorano',
		'IT098048' => 'San Martino in Strada',
		'IT098049' => 'San Rocco al Porto',
		'IT098050' => 'SantAngelo Lodigiano',
		'IT098051' => 'Santo Stefano Lodigiano',
		'IT098052' => 'Secugnago',
		'IT098053' => 'Senna Lodigiana',
		'IT098054' => 'Somaglia',
		'IT098055' => 'Sordio',
		'IT098056' => 'Tavazzano con Villavesco',
		'IT098057' => 'Terranova dei Passerini',
		'IT098058' => 'Turano Lodigiano',
		'IT098059' => 'Valera Fratta',
		'IT098060' => 'Villanova del Sillaro',
		'IT098061' => 'Zelo Buon Persico',
		'IT098062' => 'Castelgerundo',
	],
	'MB' => [
		'IT108001' => 'Agrate Brianza',
		'IT108002' => 'Aicurzio',
		'IT108003' => 'Albiate',
		'IT108004' => 'Arcore',
		'IT108005' => 'Barlassina',
		'IT108006' => 'Bellusco',
		'IT108007' => 'Bernareggio',
		'IT108008' => 'Besana in Brianza',
		'IT108009' => 'Biassono',
		'IT108010' => 'Bovisio-Masciago',
		'IT108011' => 'Briosco',
		'IT108012' => 'Brugherio',
		'IT108013' => 'Burago di Molgora',
		'IT108014' => 'Camparada',
		'IT108015' => 'Carate Brianza',
		'IT108016' => 'Carnate',
		'IT108017' => 'Cavenago di Brianza',
		'IT108018' => 'Ceriano Laghetto',
		'IT108019' => 'Cesano Maderno',
		'IT108020' => 'Cogliate',
		'IT108021' => 'Concorezzo',
		'IT108022' => 'Correzzana',
		'IT108023' => 'Desio',
		'IT108024' => 'Giussano',
		'IT108025' => 'Lazzate',
		'IT108026' => 'Lesmo',
		'IT108027' => 'Limbiate',
		'IT108028' => 'Lissone',
		'IT108029' => 'Macherio',
		'IT108030' => 'Meda',
		'IT108031' => 'Mezzago',
		'IT108032' => 'Misinto',
		'IT108033' => 'Monza',
		'IT108034' => 'Muggiò',
		'IT108035' => 'Nova Milanese',
		'IT108036' => 'Ornago',
		'IT108037' => 'Renate',
		'IT108038' => 'Ronco Briantino',
		'IT108039' => 'Seregno',
		'IT108040' => 'Seveso',
		'IT108041' => 'Sovico',
		'IT108042' => 'Sulbiate',
		'IT108043' => 'Triuggio',
		'IT108044' => 'Usmate Velate',
		'IT108045' => 'Varedo',
		'IT108046' => 'Vedano al Lambro',
		'IT108047' => 'Veduggio con Colzano',
		'IT108048' => 'Verano Brianza',
		'IT108049' => 'Villasanta',
		'IT108050' => 'Vimercate',
		'IT108051' => 'Busnago',
		'IT108052' => 'Caponago',
		'IT108053' => 'Cornate dAdda',
		'IT108054' => 'Lentate sul Seveso',
		'IT108055' => 'Roncello',
	],
	'BZ' => [
		'IT021001' => 'Aldino/Aldein',
		'IT021002' => 'Andriano/Andrian',
		'IT021003' => 'Anterivo/Altrei',
		'IT021004' => 'Appiano sulla strada del vino/Eppan an der Weinstraße',
		'IT021005' => 'Avelengo/Hafling',
		'IT021006' => 'Badia/Abtei',
		'IT021007' => 'Barbiano/Barbian',
		'IT021008' => 'Bolzano/Bozen',
		'IT021009' => 'Braies/Prags',
		'IT021010' => 'Brennero/Brenner',
		'IT021011' => 'Bressanone/Brixen',
		'IT021012' => 'Bronzolo/Branzoll',
		'IT021013' => 'Brunico/Bruneck',
		'IT021014' => 'Caines/Kuens',
		'IT021015' => 'Caldaro sulla strada del vino/Kaltern an der Weinstraße',
		'IT021016' => 'Campo di Trens/Freienfeld',
		'IT021017' => 'Campo Tures/Sand in Taufers',
		'IT021018' => 'Castelbello-Ciardes/Kastelbell-Tschars',
		'IT021019' => 'Castelrotto/Kastelruth',
		'IT021020' => 'Cermes/Tscherms',
		'IT021021' => 'Chienes/Kiens',
		'IT021022' => 'Chiusa/Klausen',
		'IT021023' => 'Cornedo allIsarco/Karneid',
		'IT021024' => 'Cortaccia sulla strada del vino/Kurtatsch an der Weinstraße',
		'IT021025' => 'Cortina sulla strada del vino/Kurtinig an der Weinstraße',
		'IT021026' => 'Corvara in Badia/Corvara',
		'IT021027' => 'Curon Venosta/Graun im Vinschgau',
		'IT021028' => 'Dobbiaco/Toblach',
		'IT021029' => 'Egna/Neumarkt',
		'IT021030' => 'Falzes/Pfalzen',
		'IT021031' => 'Fiè allo Sciliar/Völs am Schlern',
		'IT021032' => 'Fortezza/Franzensfeste',
		'IT021033' => 'Funes/Villnöß',
		'IT021034' => 'Gais/Gais',
		'IT021035' => 'Gargazzone/Gargazon',
		'IT021036' => 'Glorenza/Glurns',
		'IT021037' => 'Laces/Latsch',
		'IT021038' => 'Lagundo/Algund',
		'IT021039' => 'Laion/Lajen',
		'IT021040' => 'Laives/Leifers',
		'IT021041' => 'Lana/Lana',
		'IT021042' => 'Lasa/Laas',
		'IT021043' => 'Lauregno/Laurein',
		'IT021044' => 'Luson/Lüsen',
		'IT021045' => 'Magrè sulla strada del vino/Margreid an der Weinstraße',
		'IT021046' => 'Malles Venosta/Mals',
		'IT021047' => 'Marebbe/Enneberg',
		'IT021048' => 'Marlengo/Marling',
		'IT021049' => 'Martello/Martell',
		'IT021050' => 'Meltina/Mölten',
		'IT021051' => 'Merano/Meran',
		'IT021052' => 'Monguelfo-Tesido/Welsberg-Taisten',
		'IT021053' => 'Montagna/Montan',
		'IT021054' => 'Moso in Passiria/Moos in Passeier',
		'IT021055' => 'Nalles/Nals',
		'IT021056' => 'Naturno/Naturns',
		'IT021057' => 'Naz-Sciaves/Natz-Schabs',
		'IT021058' => 'Nova Levante/Welschnofen',
		'IT021059' => 'Nova Ponente/Deutschnofen',
		'IT021060' => 'Ora/Auer',
		'IT021061' => 'Ortisei/St. Ulrich',
		'IT021062' => 'Parcines/Partschins',
		'IT021063' => 'Perca/Percha',
		'IT021064' => 'Plaus/Plaus',
		'IT021065' => 'Ponte Gardena/Waidbruck',
		'IT021066' => 'Postal/Burgstall',
		'IT021067' => 'Prato allo Stelvio/Prad am Stilfserjoch',
		'IT021068' => 'Predoi/Prettau',
		'IT021069' => 'Proves/Proveis',
		'IT021070' => 'Racines/Ratschings',
		'IT021071' => 'Rasun-Anterselva/Rasen-Antholz',
		'IT021072' => 'Renon/Ritten',
		'IT021073' => 'Rifiano/Riffian',
		'IT021074' => 'Rio di Pusteria/Mühlbach',
		'IT021075' => 'Rodengo/Rodeneck',
		'IT021076' => 'Salorno/Salurn',
		'IT021077' => 'San Candido/Innichen',
		'IT021079' => 'San Genesio Atesino/Jenesien',
		'IT021080' => 'San Leonardo in Passiria/St. Leonhard in Passeier',
		'IT021081' => 'San Lorenzo di Sebato/St. Lorenzen',
		'IT021082' => 'San Martino in Badia/St. Martin in Thurn',
		'IT021083' => 'San Martino in Passiria/St. Martin in Passeier',
		'IT021084' => 'San Pancrazio/St. Pankraz',
		'IT021085' => 'Santa Cristina Valgardena/St. Christina in Gröden',
		'IT021086' => 'Sarentino/Sarntal',
		'IT021087' => 'Scena/Schenna',
		'IT021088' => 'Selva dei Molini/Mühlwald',
		'IT021089' => 'Selva di Val Gardena/Wolkenstein in Gröden',
		'IT021091' => 'Senales/Schnals',
		'IT021092' => 'Sesto/Sexten',
		'IT021093' => 'Silandro/Schlanders',
		'IT021094' => 'Sluderno/Schluderns',
		'IT021095' => 'Stelvio/Stilfs',
		'IT021096' => 'Terento/Terenten',
		'IT021097' => 'Terlano/Terlan',
		'IT021098' => 'Termeno sulla strada del vino/Tramin an der Weinstraße',
		'IT021099' => 'Tesimo/Tisens',
		'IT021100' => 'Tires/Tiers',
		'IT021101' => 'Tirolo/Tirol',
		'IT021102' => 'Trodena nel parco naturale/Truden im Naturpark',
		'IT021103' => 'Tubre/Taufers im Münstertal',
		'IT021104' => 'Ultimo/Ulten',
		'IT021105' => 'Vadena/Pfatten',
		'IT021106' => 'Valdaora/Olang',
		'IT021107' => 'Val di Vizze/Pfitsch',
		'IT021108' => 'Valle Aurina/Ahrntal',
		'IT021109' => 'Valle di Casies/Gsies',
		'IT021110' => 'Vandoies/Vintl',
		'IT021111' => 'Varna/Vahrn',
		'IT021112' => 'Verano/Vöran',
		'IT021113' => 'Villabassa/Niederdorf',
		'IT021114' => 'Villandro/Villanders',
		'IT021115' => 'Vipiteno/Sterzing',
		'IT021116' => 'Velturno/Feldthurns',
		'IT021117' => 'La Valle/Wengen',
		'IT021118' => 'Senale-San Felice/Unsere Liebe Frau im Walde-St. Felix',
		'IT022001' => 'Ala',
		'IT022002' => 'Albiano',
		'IT022003' => 'Aldeno',
		'IT022005' => 'Andalo',
		'IT022006' => 'Arco',
		'IT022007' => 'Avio',
		'IT022009' => 'Baselga di Pinè',
		'IT022011' => 'Bedollo',
		'IT022013' => 'Besenello',
		'IT022015' => 'Bieno',
		'IT022017' => 'Bleggio Superiore',
		'IT022018' => 'Bocenago',
		'IT022021' => 'Bondone',
		'IT022022' => 'Borgo Valsugana',
		'IT022025' => 'Brentonico',
		'IT022026' => 'Bresimo',
		'IT022027' => 'Brez',
		'IT022029' => 'Caderzone Terme',
		'IT022030' => 'Cagnò',
		'IT022032' => 'Calceranica al Lago',
		'IT022033' => 'Caldes',
		'IT022034' => 'Caldonazzo',
		'IT022035' => 'Calliano',
		'IT022036' => 'Campitello di Fassa',
		'IT022037' => 'Campodenno',
		'IT022038' => 'Canal San Bovo',
		'IT022039' => 'Canazei',
		'IT022040' => 'Capriana',
		'IT022041' => 'Carano',
		'IT022042' => 'Carisolo',
		'IT022043' => 'Carzano',
		'IT022045' => 'Castel Condino',
		'IT022046' => 'Castelfondo',
		'IT022047' => 'Castello-Molina di Fiemme',
		'IT022048' => 'Castello Tesino',
		'IT022049' => 'Castelnuovo',
		'IT022050' => 'Cavalese',
		'IT022051' => 'Cavareno',
		'IT022052' => 'Cavedago',
		'IT022053' => 'Cavedine',
		'IT022054' => 'Cavizzana',
		'IT022058' => 'Cimone',
		'IT022059' => 'Cinte Tesino',
		'IT022060' => 'Cis',
		'IT022061' => 'Civezzano',
		'IT022062' => 'Cles',
		'IT022063' => 'Cloz',
		'IT022064' => 'Commezzadura',
		'IT022068' => 'Croviana',
		'IT022070' => 'Daiano',
		'IT022071' => 'Dambel',
		'IT022074' => 'Denno',
		'IT022078' => 'Drena',
		'IT022079' => 'Dro',
		'IT022080' => 'Faedo',
		'IT022081' => 'Fai della Paganella',
		'IT022083' => 'Fiavè',
		'IT022085' => 'Fierozzo',
		'IT022087' => 'Folgaria',
		'IT022088' => 'Fondo',
		'IT022089' => 'Fornace',
		'IT022090' => 'Frassilongo',
		'IT022091' => 'Garniga Terme',
		'IT022092' => 'Giovo',
		'IT022093' => 'Giustino',
		'IT022095' => 'Grigno',
		'IT022097' => 'Imer',
		'IT022098' => 'Isera',
		'IT022102' => 'Lavarone',
		'IT022103' => 'Lavis',
		'IT022104' => 'Levico Terme',
		'IT022106' => 'Livo',
		'IT022108' => 'Lona-Lases',
		'IT022109' => 'Luserna',
		'IT022110' => 'Malé',
		'IT022111' => 'Malosco',
		'IT022112' => 'Massimeno',
		'IT022113' => 'Mazzin',
		'IT022114' => 'Mezzana',
		'IT022115' => 'Mezzano',
		'IT022116' => 'Mezzocorona',
		'IT022117' => 'Mezzolombardo',
		'IT022118' => 'Moena',
		'IT022120' => 'Molveno',
		'IT022123' => 'Mori',
		'IT022124' => 'Nago-Torbole',
		'IT022127' => 'Nogaredo',
		'IT022128' => 'Nomi',
		'IT022129' => 'Novaledo',
		'IT022130' => 'Ospedaletto',
		'IT022131' => 'Ossana',
		'IT022133' => 'Palù del Fersina',
		'IT022134' => 'Panchià',
		'IT022135' => 'Ronzo-Chienis',
		'IT022136' => 'Peio',
		'IT022137' => 'Pellizzano',
		'IT022138' => 'Pelugo',
		'IT022139' => 'Pergine Valsugana',
		'IT022142' => 'Pieve Tesino',
		'IT022143' => 'Pinzolo',
		'IT022144' => 'Pomarolo',
		'IT022147' => 'Predazzo',
		'IT022150' => 'Rabbi',
		'IT022152' => 'Revò',
		'IT022153' => 'Riva del Garda',
		'IT022154' => 'Romallo',
		'IT022155' => 'Romeno',
		'IT022156' => 'Roncegno Terme',
		'IT022157' => 'Ronchi Valsugana',
		'IT022159' => 'Ronzone',
		'IT022160' => 'Roverè della Luna',
		'IT022161' => 'Rovereto',
		'IT022162' => 'Ruffrè-Mendola',
		'IT022163' => 'Rumo',
		'IT022164' => 'Sagron Mis',
		'IT022165' => 'Samone',
		'IT022167' => 'San Michele allAdige',
		'IT022168' => 'SantOrsola Terme',
		'IT022169' => 'Sanzeno',
		'IT022170' => 'Sarnonico',
		'IT022171' => 'Scurelle',
		'IT022172' => 'Segonzano',
		'IT022173' => 'Sfruz',
		'IT022176' => 'Soraga di Fassa',
		'IT022177' => 'Sover',
		'IT022179' => 'Spiazzo',
		'IT022180' => 'Spormaggiore',
		'IT022181' => 'Sporminore',
		'IT022182' => 'Stenico',
		'IT022183' => 'Storo',
		'IT022184' => 'Strembo',
		'IT022188' => 'Telve',
		'IT022189' => 'Telve di Sopra',
		'IT022190' => 'Tenna',
		'IT022191' => 'Tenno',
		'IT022193' => 'Terragnolo',
		'IT022195' => 'Terzolas',
		'IT022196' => 'Tesero',
		'IT022199' => 'Tione di Trento',
		'IT022200' => 'Ton',
		'IT022202' => 'Torcegno',
		'IT022203' => 'Trambileno',
		'IT022205' => 'Trento',
		'IT022209' => 'Valfloriana',
		'IT022210' => 'Vallarsa',
		'IT022211' => 'Varena',
		'IT022213' => 'Vermiglio',
		'IT022216' => 'Vignola-Falesina',
		'IT022222' => 'Villa Lagarina',
		'IT022224' => 'Volano',
		'IT022226' => 'Ziano di Fiemme',
		'IT022228' => 'Comano Terme',
		'IT022229' => 'Ledro',
		'IT022230' => 'Predaia',
		'IT022231' => 'San Lorenzo Dorsino',
		'IT022232' => 'Valdaone',
		'IT022233' => 'Dimaro Folgarida',
		'IT022234' => 'Pieve di Bono-Prezzo',
		'IT022235' => 'Altavalle',
		'IT022236' => 'Altopiano della Vigolana',
		'IT022237' => 'Amblar-Don',
		'IT022238' => 'Borgo Chiese',
		'IT022239' => 'Borgo Lares',
		'IT022240' => 'Castel Ivano',
		'IT022241' => 'Cembra Lisignago',
		'IT022242' => 'Contà',
		'IT022243' => 'Madruzzo',
		'IT022244' => 'Porte di Rendena',
		'IT022245' => 'Primiero San Martino di Castrozza',
		'IT022246' => 'Sella Giudicarie',
		'IT022247' => 'Tre Ville',
		'IT022248' => 'Vallelaghi',
		'IT022249' => 'Ville dAnaunia',
		'IT022250' => 'San Giovanni di Fassa-Sèn Jan',
		'IT022251' => 'Terre dAdige',
	],
	'VR' => [
		'IT023001' => 'Affi',
		'IT023002' => 'Albaredo dAdige',
		'IT023003' => 'Angiari',
		'IT023004' => 'Arcole',
		'IT023005' => 'Badia Calavena',
		'IT023006' => 'Bardolino',
		'IT023007' => 'Belfiore',
		'IT023008' => 'Bevilacqua',
		'IT023009' => 'Bonavigo',
		'IT023010' => 'Boschi SantAnna',
		'IT023011' => 'Bosco Chiesanuova',
		'IT023012' => 'Bovolone',
		'IT023013' => 'Brentino Belluno',
		'IT023014' => 'Brenzone sul Garda',
		'IT023015' => 'Bussolengo',
		'IT023016' => 'Buttapietra',
		'IT023017' => 'Caldiero',
		'IT023018' => 'Caprino Veronese',
		'IT023019' => 'Casaleone',
		'IT023020' => 'Castagnaro',
		'IT023021' => 'Castel dAzzano',
		'IT023022' => 'Castelnuovo del Garda',
		'IT023023' => 'Cavaion Veronese',
		'IT023024' => 'Cazzano di Tramigna',
		'IT023025' => 'Cerea',
		'IT023026' => 'Cerro Veronese',
		'IT023027' => 'Cologna Veneta',
		'IT023028' => 'Colognola ai Colli',
		'IT023029' => 'Concamarise',
		'IT023030' => 'Costermano sul Garda',
		'IT023031' => 'Dolcè',
		'IT023032' => 'Erbè',
		'IT023033' => 'Erbezzo',
		'IT023034' => 'Ferrara di Monte Baldo',
		'IT023035' => 'Fumane',
		'IT023036' => 'Garda',
		'IT023037' => 'Gazzo Veronese',
		'IT023038' => 'Grezzana',
		'IT023039' => 'Illasi',
		'IT023040' => 'Isola della Scala',
		'IT023041' => 'Isola Rizza',
		'IT023042' => 'Lavagno',
		'IT023043' => 'Lazise',
		'IT023044' => 'Legnago',
		'IT023045' => 'Malcesine',
		'IT023046' => 'Marano di Valpolicella',
		'IT023047' => 'Mezzane di Sotto',
		'IT023048' => 'Minerbe',
		'IT023049' => 'Montecchia di Crosara',
		'IT023050' => 'Monteforte dAlpone',
		'IT023051' => 'Mozzecane',
		'IT023052' => 'Negrar',
		'IT023053' => 'Nogara',
		'IT023054' => 'Nogarole Rocca',
		'IT023055' => 'Oppeano',
		'IT023056' => 'Palù',
		'IT023057' => 'Pastrengo',
		'IT023058' => 'Pescantina',
		'IT023059' => 'Peschiera del Garda',
		'IT023060' => 'Povegliano Veronese',
		'IT023061' => 'Pressana',
		'IT023062' => 'Rivoli Veronese',
		'IT023063' => 'Roncà',
		'IT023064' => 'Ronco allAdige',
		'IT023065' => 'Roverchiara',
		'IT023066' => 'Roveredo di Guà',
		'IT023067' => 'Roverè Veronese',
		'IT023068' => 'Salizzole',
		'IT023069' => 'San Bonifacio',
		'IT023070' => 'San Giovanni Ilarione',
		'IT023071' => 'San Giovanni Lupatoto',
		'IT023072' => 'Sanguinetto',
		'IT023073' => 'San Martino Buon Albergo',
		'IT023074' => 'San Mauro di Saline',
		'IT023075' => 'San Pietro di Morubio',
		'IT023076' => 'San Pietro in Cariano',
		'IT023077' => 'SantAmbrogio di Valpolicella',
		'IT023078' => 'SantAnna dAlfaedo',
		'IT023079' => 'San Zeno di Montagna',
		'IT023080' => 'Selva di Progno',
		'IT023081' => 'Soave',
		'IT023082' => 'Sommacampagna',
		'IT023083' => 'Sona',
		'IT023084' => 'Sorgà',
		'IT023085' => 'Terrazzo',
		'IT023086' => 'Torri del Benaco',
		'IT023087' => 'Tregnago',
		'IT023088' => 'Trevenzuolo',
		'IT023089' => 'Valeggio sul Mincio',
		'IT023090' => 'Velo Veronese',
		'IT023091' => 'Verona',
		'IT023092' => 'Veronella',
		'IT023093' => 'Vestenanova',
		'IT023094' => 'Vigasio',
		'IT023095' => 'Villa Bartolomea',
		'IT023096' => 'Villafranca di Verona',
		'IT023097' => 'Zevio',
		'IT023098' => 'Zimella',
	],
	'VI' => [
		'IT024001' => 'Agugliaro',
		'IT024002' => 'Albettone',
		'IT024003' => 'Alonte',
		'IT024004' => 'Altavilla Vicentina',
		'IT024005' => 'Altissimo',
		'IT024006' => 'Arcugnano',
		'IT024007' => 'Arsiero',
		'IT024008' => 'Arzignano',
		'IT024009' => 'Asiago',
		'IT024010' => 'Asigliano Veneto',
		'IT024012' => 'Bassano del Grappa',
		'IT024013' => 'Bolzano Vicentino',
		'IT024014' => 'Breganze',
		'IT024015' => 'Brendola',
		'IT024016' => 'Bressanvido',
		'IT024017' => 'Brogliano',
		'IT024018' => 'Caldogno',
		'IT024019' => 'Caltrano',
		'IT024020' => 'Calvene',
		'IT024021' => 'Camisano Vicentino',
		'IT024022' => 'Campiglia dei Berici',
		'IT024023' => 'Campolongo sul Brenta',
		'IT024024' => 'Carrè',
		'IT024025' => 'Cartigliano',
		'IT024026' => 'Cassola',
		'IT024027' => 'Castegnero',
		'IT024028' => 'Castelgomberto',
		'IT024029' => 'Chiampo',
		'IT024030' => 'Chiuppano',
		'IT024031' => 'Cismon del Grappa',
		'IT024032' => 'Cogollo del Cengio',
		'IT024033' => 'Conco',
		'IT024034' => 'Cornedo Vicentino',
		'IT024035' => 'Costabissara',
		'IT024036' => 'Creazzo',
		'IT024037' => 'Crespadoro',
		'IT024038' => 'Dueville',
		'IT024039' => 'Enego',
		'IT024040' => 'Fara Vicentino',
		'IT024041' => 'Foza',
		'IT024042' => 'Gallio',
		'IT024043' => 'Gambellara',
		'IT024044' => 'Gambugliano',
		'IT024046' => 'Grisignano di Zocco',
		'IT024047' => 'Grumolo delle Abbadesse',
		'IT024048' => 'Isola Vicentina',
		'IT024049' => 'Laghi',
		'IT024050' => 'Lastebasse',
		'IT024051' => 'Longare',
		'IT024052' => 'Lonigo',
		'IT024053' => 'Lugo di Vicenza',
		'IT024054' => 'Lusiana',
		'IT024055' => 'Malo',
		'IT024056' => 'Marano Vicentino',
		'IT024057' => 'Marostica',
		'IT024058' => 'Mason Vicentino',
		'IT024059' => 'Molvena',
		'IT024060' => 'Montebello Vicentino',
		'IT024061' => 'Montecchio Maggiore',
		'IT024062' => 'Montecchio Precalcino',
		'IT024063' => 'Monte di Malo',
		'IT024064' => 'Montegalda',
		'IT024065' => 'Montegaldella',
		'IT024066' => 'Monteviale',
		'IT024067' => 'Monticello Conte Otto',
		'IT024068' => 'Montorso Vicentino',
		'IT024070' => 'Mussolente',
		'IT024071' => 'Nanto',
		'IT024072' => 'Nogarole Vicentino',
		'IT024073' => 'Nove',
		'IT024074' => 'Noventa Vicentina',
		'IT024075' => 'Orgiano',
		'IT024076' => 'Pedemonte',
		'IT024077' => 'Pianezze',
		'IT024078' => 'Piovene Rocchette',
		'IT024079' => 'Pojana Maggiore',
		'IT024080' => 'Posina',
		'IT024081' => 'Pove del Grappa',
		'IT024082' => 'Pozzoleone',
		'IT024083' => 'Quinto Vicentino',
		'IT024084' => 'Recoaro Terme',
		'IT024085' => 'Roana',
		'IT024086' => 'Romano dEzzelino',
		'IT024087' => 'Rosà',
		'IT024088' => 'Rossano Veneto',
		'IT024089' => 'Rotzo',
		'IT024090' => 'Salcedo',
		'IT024091' => 'Sandrigo',
		'IT024093' => 'San Nazario',
		'IT024094' => 'San Pietro Mussolino',
		'IT024095' => 'Santorso',
		'IT024096' => 'San Vito di Leguzzano',
		'IT024097' => 'Sarcedo',
		'IT024098' => 'Sarego',
		'IT024099' => 'Schiavon',
		'IT024100' => 'Schio',
		'IT024101' => 'Solagna',
		'IT024102' => 'Sossano',
		'IT024103' => 'Sovizzo',
		'IT024104' => 'Tezze sul Brenta',
		'IT024105' => 'Thiene',
		'IT024106' => 'Tonezza del Cimone',
		'IT024107' => 'Torrebelvicino',
		'IT024108' => 'Torri di Quartesolo',
		'IT024110' => 'Trissino',
		'IT024111' => 'Valdagno',
		'IT024112' => 'Valdastico',
		'IT024113' => 'Valli del Pasubio',
		'IT024114' => 'Valstagna',
		'IT024115' => 'Velo dAstico',
		'IT024116' => 'Vicenza',
		'IT024117' => 'Villaga',
		'IT024118' => 'Villaverla',
		'IT024119' => 'Zanè',
		'IT024120' => 'Zermeghedo',
		'IT024121' => 'Zovencedo',
		'IT024122' => 'Zugliano',
		'IT024123' => 'Val Liona',
		'IT024124' => 'Barbarano Mossano',
	],
	'BL' => [
		'IT025001' => 'Agordo',
		'IT025002' => 'Alano di Piave',
		'IT025003' => 'Alleghe',
		'IT025004' => 'Arsiè',
		'IT025005' => 'Auronzo di Cadore',
		'IT025006' => 'Belluno',
		'IT025007' => 'Borca di Cadore',
		'IT025008' => 'Calalzo di Cadore',
		'IT025010' => 'Cencenighe Agordino',
		'IT025011' => 'Cesiomaggiore',
		'IT025012' => 'Chies dAlpago',
		'IT025013' => 'Cibiana di Cadore',
		'IT025014' => 'Colle Santa Lucia',
		'IT025015' => 'Comelico Superiore',
		'IT025016' => 'Cortina dAmpezzo',
		'IT025017' => 'Danta di Cadore',
		'IT025018' => 'Domegge di Cadore',
		'IT025019' => 'Falcade',
		'IT025021' => 'Feltre',
		'IT025022' => 'Fonzaso',
		'IT025023' => 'Canale dAgordo',
		'IT025025' => 'Gosaldo',
		'IT025026' => 'Lamon',
		'IT025027' => 'La Valle Agordina',
		'IT025028' => 'Lentiai',
		'IT025029' => 'Limana',
		'IT025030' => 'Livinallongo del Col di Lana',
		'IT025032' => 'Lorenzago di Cadore',
		'IT025033' => 'Lozzo di Cadore',
		'IT025034' => 'Mel',
		'IT025035' => 'Ospitale di Cadore',
		'IT025036' => 'Pedavena',
		'IT025037' => 'Perarolo di Cadore',
		'IT025039' => 'Pieve di Cadore',
		'IT025040' => 'Ponte nelle Alpi',
		'IT025043' => 'Rivamonte Agordino',
		'IT025044' => 'Rocca Pietore',
		'IT025045' => 'San Gregorio nelle Alpi',
		'IT025046' => 'San Nicolò di Comelico',
		'IT025047' => 'San Pietro di Cadore',
		'IT025048' => 'Santa Giustina',
		'IT025049' => 'San Tomaso Agordino',
		'IT025050' => 'Santo Stefano di Cadore',
		'IT025051' => 'San Vito di Cadore',
		'IT025053' => 'Sedico',
		'IT025054' => 'Selva di Cadore',
		'IT025055' => 'Seren del Grappa',
		'IT025056' => 'Sospirolo',
		'IT025057' => 'Soverzene',
		'IT025058' => 'Sovramonte',
		'IT025059' => 'Taibon Agordino',
		'IT025060' => 'Tambre',
		'IT025061' => 'Trichiana',
		'IT025062' => 'Vallada Agordina',
		'IT025063' => 'Valle di Cadore',
		'IT025065' => 'Vigo di Cadore',
		'IT025066' => 'Vodo Cadore',
		'IT025067' => 'Voltago Agordino',
		'IT025069' => 'Zoppè di Cadore',
		'IT025070' => 'Quero Vas',
		'IT025071' => 'Longarone',
		'IT025072' => 'Alpago',
		'IT025073' => 'Val di Zoldo',
	],
	'TV' => [
		'IT026001' => 'Altivole',
		'IT026002' => 'Arcade',
		'IT026003' => 'Asolo',
		'IT026004' => 'Borso del Grappa',
		'IT026005' => 'Breda di Piave',
		'IT026006' => 'Caerano di San Marco',
		'IT026007' => 'Cappella Maggiore',
		'IT026008' => 'Carbonera',
		'IT026009' => 'Casale sul Sile',
		'IT026010' => 'Casier',
		'IT026011' => 'Castelcucco',
		'IT026012' => 'Castelfranco Veneto',
		'IT026013' => 'Castello di Godego',
		'IT026014' => 'Cavaso del Tomba',
		'IT026015' => 'Cessalto',
		'IT026016' => 'Chiarano',
		'IT026017' => 'Cimadolmo',
		'IT026018' => 'Cison di Valmarino',
		'IT026019' => 'Codognè',
		'IT026020' => 'Colle Umberto',
		'IT026021' => 'Conegliano',
		'IT026022' => 'Cordignano',
		'IT026023' => 'Cornuda',
		'IT026024' => 'Crespano del Grappa',
		'IT026025' => 'Crocetta del Montello',
		'IT026026' => 'Farra di Soligo',
		'IT026027' => 'Follina',
		'IT026028' => 'Fontanelle',
		'IT026029' => 'Fonte',
		'IT026030' => 'Fregona',
		'IT026031' => 'Gaiarine',
		'IT026032' => 'Giavera del Montello',
		'IT026033' => 'Godega di SantUrbano',
		'IT026034' => 'Gorgo al Monticano',
		'IT026035' => 'Istrana',
		'IT026036' => 'Loria',
		'IT026037' => 'Mansuè',
		'IT026038' => 'Mareno di Piave',
		'IT026039' => 'Maser',
		'IT026040' => 'Maserada sul Piave',
		'IT026041' => 'Meduna di Livenza',
		'IT026042' => 'Miane',
		'IT026043' => 'Mogliano Veneto',
		'IT026044' => 'Monastier di Treviso',
		'IT026045' => 'Monfumo',
		'IT026046' => 'Montebelluna',
		'IT026047' => 'Morgano',
		'IT026048' => 'Moriago della Battaglia',
		'IT026049' => 'Motta di Livenza',
		'IT026050' => 'Nervesa della Battaglia',
		'IT026051' => 'Oderzo',
		'IT026052' => 'Ormelle',
		'IT026053' => 'Orsago',
		'IT026054' => 'Paderno del Grappa',
		'IT026055' => 'Paese',
		'IT026056' => 'Pederobba',
		'IT026057' => 'Pieve di Soligo',
		'IT026058' => 'Ponte di Piave',
		'IT026059' => 'Ponzano Veneto',
		'IT026060' => 'Portobuffolè',
		'IT026061' => 'Possagno',
		'IT026062' => 'Povegliano',
		'IT026063' => 'Preganziol',
		'IT026064' => 'Quinto di Treviso',
		'IT026065' => 'Refrontolo',
		'IT026066' => 'Resana',
		'IT026067' => 'Revine Lago',
		'IT026068' => 'Riese Pio X',
		'IT026069' => 'Roncade',
		'IT026070' => 'Salgareda',
		'IT026071' => 'San Biagio di Callalta',
		'IT026072' => 'San Fior',
		'IT026073' => 'San Pietro di Feletto',
		'IT026074' => 'San Polo di Piave',
		'IT026075' => 'Santa Lucia di Piave',
		'IT026076' => 'San Vendemiano',
		'IT026077' => 'San Zenone degli Ezzelini',
		'IT026078' => 'Sarmede',
		'IT026079' => 'Segusino',
		'IT026080' => 'Sernaglia della Battaglia',
		'IT026081' => 'Silea',
		'IT026082' => 'Spresiano',
		'IT026083' => 'Susegana',
		'IT026084' => 'Tarzo',
		'IT026085' => 'Trevignano',
		'IT026086' => 'Treviso',
		'IT026087' => 'Valdobbiadene',
		'IT026088' => 'Vazzola',
		'IT026089' => 'Vedelago',
		'IT026090' => 'Vidor',
		'IT026091' => 'Villorba',
		'IT026092' => 'Vittorio Veneto',
		'IT026093' => 'Volpago del Montello',
		'IT026094' => 'Zenson di Piave',
		'IT026095' => 'Zero Branco',
	],
	'VE' => [
		'IT027001' => 'Annone Veneto',
		'IT027002' => 'Campagna Lupia',
		'IT027003' => 'Campolongo Maggiore',
		'IT027004' => 'Camponogara',
		'IT027005' => 'Caorle',
		'IT027006' => 'Cavarzere',
		'IT027007' => 'Ceggia',
		'IT027008' => 'Chioggia',
		'IT027009' => 'Cinto Caomaggiore',
		'IT027010' => 'Cona',
		'IT027011' => 'Concordia Sagittaria',
		'IT027012' => 'Dolo',
		'IT027013' => 'Eraclea',
		'IT027014' => 'Fiesso dArtico',
		'IT027015' => 'Fossalta di Piave',
		'IT027016' => 'Fossalta di Portogruaro',
		'IT027017' => 'Fossò',
		'IT027018' => 'Gruaro',
		'IT027019' => 'Jesolo',
		'IT027020' => 'Marcon',
		'IT027021' => 'Martellago',
		'IT027022' => 'Meolo',
		'IT027023' => 'Mira',
		'IT027024' => 'Mirano',
		'IT027025' => 'Musile di Piave',
		'IT027026' => 'Noale',
		'IT027027' => 'Noventa di Piave',
		'IT027028' => 'Pianiga',
		'IT027029' => 'Portogruaro',
		'IT027030' => 'Pramaggiore',
		'IT027031' => 'Quarto dAltino',
		'IT027032' => 'Salzano',
		'IT027033' => 'San Donà di Piave',
		'IT027034' => 'San Michele al Tagliamento',
		'IT027035' => 'Santa Maria di Sala',
		'IT027036' => 'San Stino di Livenza',
		'IT027037' => 'Scorzè',
		'IT027038' => 'Spinea',
		'IT027039' => 'Stra',
		'IT027040' => 'Teglio Veneto',
		'IT027041' => 'Torre di Mosto',
		'IT027042' => 'Venezia',
		'IT027043' => 'Vigonovo',
		'IT027044' => 'Cavallino-Treporti',
	],
	'PD' => [
		'IT028001' => 'Abano Terme',
		'IT028002' => 'Agna',
		'IT028003' => 'Albignasego',
		'IT028004' => 'Anguillara Veneta',
		'IT028005' => 'Arquà Petrarca',
		'IT028006' => 'Arre',
		'IT028007' => 'Arzergrande',
		'IT028008' => 'Bagnoli di Sopra',
		'IT028009' => 'Baone',
		'IT028010' => 'Barbona',
		'IT028011' => 'Battaglia Terme',
		'IT028012' => 'Boara Pisani',
		'IT028013' => 'Borgoricco',
		'IT028014' => 'Bovolenta',
		'IT028015' => 'Brugine',
		'IT028016' => 'Cadoneghe',
		'IT028017' => 'Campodarsego',
		'IT028018' => 'Campodoro',
		'IT028019' => 'Camposampiero',
		'IT028020' => 'Campo San Martino',
		'IT028021' => 'Candiana',
		'IT028022' => 'Carceri',
		'IT028023' => 'Carmignano di Brenta',
		'IT028026' => 'Cartura',
		'IT028027' => 'Casale di Scodosia',
		'IT028028' => 'Casalserugo',
		'IT028029' => 'Castelbaldo',
		'IT028030' => 'Cervarese Santa Croce',
		'IT028031' => 'Cinto Euganeo',
		'IT028032' => 'Cittadella',
		'IT028033' => 'Codevigo',
		'IT028034' => 'Conselve',
		'IT028035' => 'Correzzola',
		'IT028036' => 'Curtarolo',
		'IT028037' => 'Este',
		'IT028038' => 'Fontaniva',
		'IT028039' => 'Galliera Veneta',
		'IT028040' => 'Galzignano Terme',
		'IT028041' => 'Gazzo',
		'IT028042' => 'Grantorto',
		'IT028043' => 'Granze',
		'IT028044' => 'Legnaro',
		'IT028045' => 'Limena',
		'IT028046' => 'Loreggia',
		'IT028047' => 'Lozzo Atestino',
		'IT028048' => 'Maserà di Padova',
		'IT028049' => 'Masi',
		'IT028050' => 'Massanzago',
		'IT028052' => 'Megliadino San Vitale',
		'IT028053' => 'Merlara',
		'IT028054' => 'Mestrino',
		'IT028055' => 'Monselice',
		'IT028056' => 'Montagnana',
		'IT028057' => 'Montegrotto Terme',
		'IT028058' => 'Noventa Padovana',
		'IT028059' => 'Ospedaletto Euganeo',
		'IT028060' => 'Padova',
		'IT028061' => 'Pernumia',
		'IT028062' => 'Piacenza dAdige',
		'IT028063' => 'Piazzola sul Brenta',
		'IT028064' => 'Piombino Dese',
		'IT028065' => 'Piove di Sacco',
		'IT028066' => 'Polverara',
		'IT028067' => 'Ponso',
		'IT028068' => 'Pontelongo',
		'IT028069' => 'Ponte San Nicolò',
		'IT028070' => 'Pozzonovo',
		'IT028071' => 'Rovolon',
		'IT028072' => 'Rubano',
		'IT028073' => 'Saccolongo',
		'IT028075' => 'San Giorgio delle Pertiche',
		'IT028076' => 'San Giorgio in Bosco',
		'IT028077' => 'San Martino di Lupari',
		'IT028078' => 'San Pietro in Gu',
		'IT028079' => 'San Pietro Viminario',
		'IT028080' => 'Santa Giustina in Colle',
		'IT028082' => 'SantAngelo di Piove di Sacco',
		'IT028083' => 'SantElena',
		'IT028084' => 'SantUrbano',
		'IT028085' => 'Saonara',
		'IT028086' => 'Selvazzano Dentro',
		'IT028087' => 'Solesino',
		'IT028088' => 'Stanghella',
		'IT028089' => 'Teolo',
		'IT028090' => 'Terrassa Padovana',
		'IT028091' => 'Tombolo',
		'IT028092' => 'Torreglia',
		'IT028093' => 'Trebaseleghe',
		'IT028094' => 'Tribano',
		'IT028095' => 'Urbana',
		'IT028096' => 'Veggiano',
		'IT028097' => 'Vescovana',
		'IT028098' => 'Vighizzolo dEste',
		'IT028099' => 'Vigodarzere',
		'IT028100' => 'Vigonza',
		'IT028101' => 'Villa del Conte',
		'IT028102' => 'Villa Estense',
		'IT028103' => 'Villafranca Padovana',
		'IT028104' => 'Villanova di Camposampiero',
		'IT028105' => 'Vo',
		'IT028106' => 'Due Carrare',
		'IT028107' => 'Borgo Veneto',
	],
	'RO' => [
		'IT029001' => 'Adria',
		'IT029002' => 'Ariano nel Polesine',
		'IT029003' => 'Arquà Polesine',
		'IT029004' => 'Badia Polesine',
		'IT029005' => 'Bagnolo di Po',
		'IT029006' => 'Bergantino',
		'IT029007' => 'Bosaro',
		'IT029008' => 'Calto',
		'IT029009' => 'Canaro',
		'IT029010' => 'Canda',
		'IT029011' => 'Castelguglielmo',
		'IT029012' => 'Castelmassa',
		'IT029013' => 'Castelnovo Bariano',
		'IT029014' => 'Ceneselli',
		'IT029015' => 'Ceregnano',
		'IT029017' => 'Corbola',
		'IT029018' => 'Costa di Rovigo',
		'IT029019' => 'Crespino',
		'IT029021' => 'Ficarolo',
		'IT029022' => 'Fiesso Umbertiano',
		'IT029023' => 'Frassinelle Polesine',
		'IT029024' => 'Fratta Polesine',
		'IT029025' => 'Gaiba',
		'IT029026' => 'Gavello',
		'IT029027' => 'Giacciano con Baruchella',
		'IT029028' => 'Guarda Veneta',
		'IT029029' => 'Lendinara',
		'IT029030' => 'Loreo',
		'IT029031' => 'Lusia',
		'IT029032' => 'Melara',
		'IT029033' => 'Occhiobello',
		'IT029034' => 'Papozze',
		'IT029035' => 'Pettorazza Grimani',
		'IT029036' => 'Pincara',
		'IT029037' => 'Polesella',
		'IT029038' => 'Pontecchio Polesine',
		'IT029039' => 'Porto Tolle',
		'IT029040' => 'Rosolina',
		'IT029041' => 'Rovigo',
		'IT029042' => 'Salara',
		'IT029043' => 'San Bellino',
		'IT029044' => 'San Martino di Venezze',
		'IT029045' => 'Stienta',
		'IT029046' => 'Taglio di Po',
		'IT029047' => 'Trecenta',
		'IT029048' => 'Villadose',
		'IT029049' => 'Villamarzana',
		'IT029050' => 'Villanova del Ghebbo',
		'IT029051' => 'Villanova Marchesana',
		'IT029052' => 'Porto Viro',
	],
	'UD' => [
		'IT030001' => 'Aiello del Friuli',
		'IT030002' => 'Amaro',
		'IT030003' => 'Ampezzo',
		'IT030004' => 'Aquileia',
		'IT030005' => 'Arta Terme',
		'IT030006' => 'Artegna',
		'IT030007' => 'Attimis',
		'IT030008' => 'Bagnaria Arsa',
		'IT030009' => 'Basiliano',
		'IT030010' => 'Bertiolo',
		'IT030011' => 'Bicinicco',
		'IT030012' => 'Bordano',
		'IT030013' => 'Buja',
		'IT030014' => 'Buttrio',
		'IT030015' => 'Camino al Tagliamento',
		'IT030016' => 'Campoformido',
		'IT030018' => 'Carlino',
		'IT030019' => 'Cassacco',
		'IT030020' => 'Castions di Strada',
		'IT030021' => 'Cavazzo Carnico',
		'IT030022' => 'Cercivento',
		'IT030023' => 'Cervignano del Friuli',
		'IT030024' => 'Chiopris-Viscone',
		'IT030025' => 'Chiusaforte',
		'IT030026' => 'Cividale del Friuli',
		'IT030027' => 'Codroipo',
		'IT030028' => 'Colloredo di Monte Albano',
		'IT030029' => 'Comeglians',
		'IT030030' => 'Corno di Rosazzo',
		'IT030031' => 'Coseano',
		'IT030032' => 'Dignano',
		'IT030033' => 'Dogna',
		'IT030034' => 'Drenchia',
		'IT030035' => 'Enemonzo',
		'IT030036' => 'Faedis',
		'IT030037' => 'Fagagna',
		'IT030039' => 'Flaibano',
		'IT030040' => 'Forni Avoltri',
		'IT030041' => 'Forni di Sopra',
		'IT030042' => 'Forni di Sotto',
		'IT030043' => 'Gemona del Friuli',
		'IT030044' => 'Gonars',
		'IT030045' => 'Grimacco',
		'IT030046' => 'Latisana',
		'IT030047' => 'Lauco',
		'IT030048' => 'Lestizza',
		'IT030049' => 'Lignano Sabbiadoro',
		'IT030051' => 'Lusevera',
		'IT030052' => 'Magnano in Riviera',
		'IT030053' => 'Majano',
		'IT030054' => 'Malborghetto Valbruna',
		'IT030055' => 'Manzano',
		'IT030056' => 'Marano Lagunare',
		'IT030057' => 'Martignacco',
		'IT030058' => 'Mereto di Tomba',
		'IT030059' => 'Moggio Udinese',
		'IT030060' => 'Moimacco',
		'IT030061' => 'Montenars',
		'IT030062' => 'Mortegliano',
		'IT030063' => 'Moruzzo',
		'IT030064' => 'Muzzana del Turgnano',
		'IT030065' => 'Nimis',
		'IT030066' => 'Osoppo',
		'IT030067' => 'Ovaro',
		'IT030068' => 'Pagnacco',
		'IT030069' => 'Palazzolo dello Stella',
		'IT030070' => 'Palmanova',
		'IT030071' => 'Paluzza',
		'IT030072' => 'Pasian di Prato',
		'IT030073' => 'Paularo',
		'IT030074' => 'Pavia di Udine',
		'IT030075' => 'Pocenia',
		'IT030076' => 'Pontebba',
		'IT030077' => 'Porpetto',
		'IT030078' => 'Povoletto',
		'IT030079' => 'Pozzuolo del Friuli',
		'IT030080' => 'Pradamano',
		'IT030081' => 'Prato Carnico',
		'IT030082' => 'Precenicco',
		'IT030083' => 'Premariacco',
		'IT030084' => 'Preone',
		'IT030085' => 'Prepotto',
		'IT030086' => 'Pulfero',
		'IT030087' => 'Ragogna',
		'IT030088' => 'Ravascletto',
		'IT030089' => 'Raveo',
		'IT030090' => 'Reana del Rojale',
		'IT030091' => 'Remanzacco',
		'IT030092' => 'Resia',
		'IT030093' => 'Resiutta',
		'IT030094' => 'Rigolato',
		'IT030095' => 'Rive dArcano',
		'IT030097' => 'Ronchis',
		'IT030098' => 'Ruda',
		'IT030099' => 'San Daniele del Friuli',
		'IT030100' => 'San Giorgio di Nogaro',
		'IT030101' => 'San Giovanni al Natisone',
		'IT030102' => 'San Leonardo',
		'IT030103' => 'San Pietro al Natisone',
		'IT030104' => 'Santa Maria la Longa',
		'IT030105' => 'San Vito al Torre',
		'IT030106' => 'San Vito di Fagagna',
		'IT030107' => 'Sauris',
		'IT030108' => 'Savogna',
		'IT030109' => 'Sedegliano',
		'IT030110' => 'Socchieve',
		'IT030111' => 'Stregna',
		'IT030112' => 'Sutrio',
		'IT030113' => 'Taipana',
		'IT030114' => 'Talmassons',
		'IT030116' => 'Tarcento',
		'IT030117' => 'Tarvisio',
		'IT030118' => 'Tavagnacco',
		'IT030120' => 'Terzo dAquileia',
		'IT030121' => 'Tolmezzo',
		'IT030122' => 'Torreano',
		'IT030123' => 'Torviscosa',
		'IT030124' => 'Trasaghis',
		'IT030126' => 'Treppo Grande',
		'IT030127' => 'Tricesimo',
		'IT030128' => 'Trivignano Udinese',
		'IT030129' => 'Udine',
		'IT030130' => 'Varmo',
		'IT030131' => 'Venzone',
		'IT030132' => 'Verzegnis',
		'IT030133' => 'Villa Santina',
		'IT030135' => 'Visco',
		'IT030136' => 'Zuglio',
		'IT030137' => 'Forgaria nel Friuli',
		'IT030138' => 'Campolongo Tapogliano',
		'IT030188' => 'Rivignano Teor',
		'IT030189' => 'Sappada',
		'IT030190' => 'Fiumicello Villa Vicentina',
		'IT030191' => 'Treppo Ligosullo',
	],
	'GO' => [
		'IT031001' => 'Capriva del Friuli',
		'IT031002' => 'Cormons',
		'IT031003' => 'Doberdò del Lago-Doberdob',
		'IT031004' => 'Dolegna del Collio',
		'IT031005' => 'Farra dIsonzo',
		'IT031006' => 'Fogliano Redipuglia',
		'IT031007' => 'Gorizia',
		'IT031008' => 'Gradisca dIsonzo',
		'IT031009' => 'Grado',
		'IT031010' => 'Mariano del Friuli',
		'IT031011' => 'Medea',
		'IT031012' => 'Monfalcone',
		'IT031013' => 'Moraro',
		'IT031014' => 'Mossa',
		'IT031015' => 'Romans dIsonzo',
		'IT031016' => 'Ronchi dei Legionari',
		'IT031017' => 'Sagrado',
		'IT031018' => 'San Canzian dIsonzo',
		'IT031019' => 'San Floriano del Collio-Števerjan',
		'IT031020' => 'San Lorenzo Isontino',
		'IT031021' => 'San Pier dIsonzo',
		'IT031022' => 'Savogna dIsonzo-Sovodnje ob Soči',
		'IT031023' => 'Staranzano',
		'IT031024' => 'Turriaco',
		'IT031025' => 'Villesse',
	],
	'TS' => [
		'IT032001' => 'Duino Aurisina-Devin Nabrežina',
		'IT032002' => 'Monrupino-Repentabor',
		'IT032003' => 'Muggia',
		'IT032004' => 'San Dorligo della Valle-Dolina',
		'IT032005' => 'Sgonico-Zgonik',
		'IT032006' => 'Trieste',
	],
	'PN' => [
		'IT093001' => 'Andreis',
		'IT093002' => 'Arba',
		'IT093004' => 'Aviano',
		'IT093005' => 'Azzano Decimo',
		'IT093006' => 'Barcis',
		'IT093007' => 'Brugnera',
		'IT093008' => 'Budoia',
		'IT093009' => 'Caneva',
		'IT093010' => 'Casarsa della Delizia',
		'IT093011' => 'Castelnovo del Friuli',
		'IT093012' => 'Cavasso Nuovo',
		'IT093013' => 'Chions',
		'IT093014' => 'Cimolais',
		'IT093015' => 'Claut',
		'IT093016' => 'Clauzetto',
		'IT093017' => 'Cordenons',
		'IT093018' => 'Cordovado',
		'IT093019' => 'Erto e Casso',
		'IT093020' => 'Fanna',
		'IT093021' => 'Fiume Veneto',
		'IT093022' => 'Fontanafredda',
		'IT093024' => 'Frisanco',
		'IT093025' => 'Maniago',
		'IT093026' => 'Meduno',
		'IT093027' => 'Montereale Valcellina',
		'IT093028' => 'Morsano al Tagliamento',
		'IT093029' => 'Pasiano di Pordenone',
		'IT093030' => 'Pinzano al Tagliamento',
		'IT093031' => 'Polcenigo',
		'IT093032' => 'Porcia',
		'IT093033' => 'Pordenone',
		'IT093034' => 'Prata di Pordenone',
		'IT093035' => 'Pravisdomini',
		'IT093036' => 'Roveredo in Piano',
		'IT093037' => 'Sacile',
		'IT093038' => 'San Giorgio della Richinvelda',
		'IT093039' => 'San Martino al Tagliamento',
		'IT093040' => 'San Quirino',
		'IT093041' => 'San Vito al Tagliamento',
		'IT093042' => 'Sequals',
		'IT093043' => 'Sesto al Reghena',
		'IT093044' => 'Spilimbergo',
		'IT093045' => 'Tramonti di Sopra',
		'IT093046' => 'Tramonti di Sotto',
		'IT093047' => 'Travesio',
		'IT093049' => 'Vito dAsio',
		'IT093050' => 'Vivaro',
		'IT093051' => 'Zoppola',
		'IT093052' => 'Vajont',
		'IT093053' => 'Valvasone Arzene',
	],
	'IM' => [
		'IT008001' => 'Airole',
		'IT008002' => 'Apricale',
		'IT008003' => 'Aquila dArroscia',
		'IT008004' => 'Armo',
		'IT008005' => 'Aurigo',
		'IT008006' => 'Badalucco',
		'IT008007' => 'Bajardo',
		'IT008008' => 'Bordighera',
		'IT008009' => 'Borghetto dArroscia',
		'IT008010' => 'Borgomaro',
		'IT008011' => 'Camporosso',
		'IT008012' => 'Caravonica',
		'IT008014' => 'Castellaro',
		'IT008015' => 'Castel Vittorio',
		'IT008016' => 'Ceriana',
		'IT008017' => 'Cervo',
		'IT008018' => 'Cesio',
		'IT008019' => 'Chiusanico',
		'IT008020' => 'Chiusavecchia',
		'IT008021' => 'Cipressa',
		'IT008022' => 'Civezza',
		'IT008023' => 'Cosio dArroscia',
		'IT008024' => 'Costarainera',
		'IT008025' => 'Diano Arentino',
		'IT008026' => 'Diano Castello',
		'IT008027' => 'Diano Marina',
		'IT008028' => 'Diano San Pietro',
		'IT008029' => 'Dolceacqua',
		'IT008030' => 'Dolcedo',
		'IT008031' => 'Imperia',
		'IT008032' => 'Isolabona',
		'IT008033' => 'Lucinasco',
		'IT008034' => 'Mendatica',
		'IT008035' => 'Molini di Triora',
		'IT008037' => 'Montegrosso Pian Latte',
		'IT008038' => 'Olivetta San Michele',
		'IT008039' => 'Ospedaletti',
		'IT008040' => 'Perinaldo',
		'IT008041' => 'Pietrabruna',
		'IT008042' => 'Pieve di Teco',
		'IT008043' => 'Pigna',
		'IT008044' => 'Pompeiana',
		'IT008045' => 'Pontedassio',
		'IT008046' => 'Pornassio',
		'IT008047' => 'Prelà',
		'IT008048' => 'Ranzo',
		'IT008049' => 'Rezzo',
		'IT008050' => 'Riva Ligure',
		'IT008051' => 'Rocchetta Nervina',
		'IT008052' => 'San Bartolomeo al Mare',
		'IT008053' => 'San Biagio della Cima',
		'IT008054' => 'San Lorenzo al Mare',
		'IT008055' => 'Sanremo',
		'IT008056' => 'Santo Stefano al Mare',
		'IT008057' => 'Seborga',
		'IT008058' => 'Soldano',
		'IT008059' => 'Taggia',
		'IT008060' => 'Terzorio',
		'IT008061' => 'Triora',
		'IT008062' => 'Vallebona',
		'IT008063' => 'Vallecrosia',
		'IT008064' => 'Vasia',
		'IT008065' => 'Ventimiglia',
		'IT008066' => 'Vessalico',
		'IT008067' => 'Villa Faraldi',
		'IT008068' => 'Montalto Carpasio',
	],
	'SV' => [
		'IT009001' => 'Alassio',
		'IT009002' => 'Albenga',
		'IT009003' => 'Albissola Marina',
		'IT009004' => 'Albisola Superiore',
		'IT009005' => 'Altare',
		'IT009006' => 'Andora',
		'IT009007' => 'Arnasco',
		'IT009008' => 'Balestrino',
		'IT009009' => 'Bardineto',
		'IT009010' => 'Bergeggi',
		'IT009011' => 'Boissano',
		'IT009012' => 'Borghetto Santo Spirito',
		'IT009013' => 'Borgio Verezzi',
		'IT009014' => 'Bormida',
		'IT009015' => 'Cairo Montenotte',
		'IT009016' => 'Calice Ligure',
		'IT009017' => 'Calizzano',
		'IT009018' => 'Carcare',
		'IT009019' => 'Casanova Lerrone',
		'IT009020' => 'Castelbianco',
		'IT009021' => 'Castelvecchio di Rocca Barbena',
		'IT009022' => 'Celle Ligure',
		'IT009023' => 'Cengio',
		'IT009024' => 'Ceriale',
		'IT009025' => 'Cisano sul Neva',
		'IT009026' => 'Cosseria',
		'IT009027' => 'Dego',
		'IT009028' => 'Erli',
		'IT009029' => 'Finale Ligure',
		'IT009030' => 'Garlenda',
		'IT009031' => 'Giustenice',
		'IT009032' => 'Giusvalla',
		'IT009033' => 'Laigueglia',
		'IT009034' => 'Loano',
		'IT009035' => 'Magliolo',
		'IT009036' => 'Mallare',
		'IT009037' => 'Massimino',
		'IT009038' => 'Millesimo',
		'IT009039' => 'Mioglia',
		'IT009040' => 'Murialdo',
		'IT009041' => 'Nasino',
		'IT009042' => 'Noli',
		'IT009043' => 'Onzo',
		'IT009044' => 'Orco Feglino',
		'IT009045' => 'Ortovero',
		'IT009046' => 'Osiglia',
		'IT009047' => 'Pallare',
		'IT009048' => 'Piana Crixia',
		'IT009049' => 'Pietra Ligure',
		'IT009050' => 'Plodio',
		'IT009051' => 'Pontinvrea',
		'IT009052' => 'Quiliano',
		'IT009053' => 'Rialto',
		'IT009054' => 'Roccavignale',
		'IT009055' => 'Sassello',
		'IT009056' => 'Savona',
		'IT009057' => 'Spotorno',
		'IT009058' => 'Stella',
		'IT009059' => 'Stellanello',
		'IT009060' => 'Testico',
		'IT009061' => 'Toirano',
		'IT009062' => 'Tovo San Giacomo',
		'IT009063' => 'Urbe',
		'IT009064' => 'Vado Ligure',
		'IT009065' => 'Varazze',
		'IT009066' => 'Vendone',
		'IT009067' => 'Vezzi Portio',
		'IT009068' => 'Villanova dAlbenga',
		'IT009069' => 'Zuccarello',
	],
	'GE' => [
		'IT010001' => 'Arenzano',
		'IT010002' => 'Avegno',
		'IT010003' => 'Bargagli',
		'IT010004' => 'Bogliasco',
		'IT010005' => 'Borzonasca',
		'IT010006' => 'Busalla',
		'IT010007' => 'Camogli',
		'IT010008' => 'Campo Ligure',
		'IT010009' => 'Campomorone',
		'IT010010' => 'Carasco',
		'IT010011' => 'Casarza Ligure',
		'IT010012' => 'Casella',
		'IT010013' => 'Castiglione Chiavarese',
		'IT010014' => 'Ceranesi',
		'IT010015' => 'Chiavari',
		'IT010016' => 'Cicagna',
		'IT010017' => 'Cogoleto',
		'IT010018' => 'Cogorno',
		'IT010019' => 'Coreglia Ligure',
		'IT010020' => 'Crocefieschi',
		'IT010021' => 'Davagna',
		'IT010022' => 'Fascia',
		'IT010023' => 'Favale di Malvaro',
		'IT010024' => 'Fontanigorda',
		'IT010025' => 'Genova',
		'IT010026' => 'Gorreto',
		'IT010027' => 'Isola del Cantone',
		'IT010028' => 'Lavagna',
		'IT010029' => 'Leivi',
		'IT010030' => 'Lorsica',
		'IT010031' => 'Lumarzo',
		'IT010032' => 'Masone',
		'IT010033' => 'Mele',
		'IT010034' => 'Mezzanego',
		'IT010035' => 'Mignanego',
		'IT010036' => 'Moconesi',
		'IT010037' => 'Moneglia',
		'IT010038' => 'Montebruno',
		'IT010039' => 'Montoggio',
		'IT010040' => 'Ne',
		'IT010041' => 'Neirone',
		'IT010042' => 'Orero',
		'IT010043' => 'Pieve Ligure',
		'IT010044' => 'Portofino',
		'IT010045' => 'Propata',
		'IT010046' => 'Rapallo',
		'IT010047' => 'Recco',
		'IT010048' => 'Rezzoaglio',
		'IT010049' => 'Ronco Scrivia',
		'IT010050' => 'Rondanina',
		'IT010051' => 'Rossiglione',
		'IT010052' => 'Rovegno',
		'IT010053' => 'San Colombano Certenoli',
		'IT010054' => 'Santa Margherita Ligure',
		'IT010055' => 'SantOlcese',
		'IT010056' => 'Santo Stefano dAveto',
		'IT010057' => 'Savignone',
		'IT010058' => 'Serra Riccò',
		'IT010059' => 'Sestri Levante',
		'IT010060' => 'Sori',
		'IT010061' => 'Tiglieto',
		'IT010062' => 'Torriglia',
		'IT010063' => 'Tribogna',
		'IT010064' => 'Uscio',
		'IT010065' => 'Valbrevenna',
		'IT010066' => 'Vobbia',
		'IT010067' => 'Zoagli',
	],
	'SP' => [
		'IT011001' => 'Ameglia',
		'IT011002' => 'Arcola',
		'IT011003' => 'Beverino',
		'IT011004' => 'Bolano',
		'IT011005' => 'Bonassola',
		'IT011006' => 'Borghetto di Vara',
		'IT011007' => 'Brugnato',
		'IT011008' => 'Calice al Cornoviglio',
		'IT011009' => 'Carro',
		'IT011010' => 'Carrodano',
		'IT011011' => 'Castelnuovo Magra',
		'IT011012' => 'Deiva Marina',
		'IT011013' => 'Follo',
		'IT011014' => 'Framura',
		'IT011015' => 'La Spezia',
		'IT011016' => 'Lerici',
		'IT011017' => 'Levanto',
		'IT011018' => 'Maissana',
		'IT011019' => 'Monterosso al Mare',
		'IT011020' => 'Luni',
		'IT011021' => 'Pignone',
		'IT011022' => 'Portovenere',
		'IT011023' => 'Riccò del Golfo di Spezia',
		'IT011024' => 'Riomaggiore',
		'IT011025' => 'Rocchetta di Vara',
		'IT011026' => 'Santo Stefano di Magra',
		'IT011027' => 'Sarzana',
		'IT011028' => 'Sesta Godano',
		'IT011029' => 'Varese Ligure',
		'IT011030' => 'Vernazza',
		'IT011031' => 'Vezzano Ligure',
		'IT011032' => 'Zignago',
	],
	'PC' => [
		'IT033001' => 'Agazzano',
		'IT033002' => 'Alseno',
		'IT033003' => 'Besenzone',
		'IT033004' => 'Bettola',
		'IT033005' => 'Bobbio',
		'IT033006' => 'Borgonovo Val Tidone',
		'IT033007' => 'Cadeo',
		'IT033008' => 'Calendasco',
		'IT033010' => 'Caorso',
		'IT033011' => 'Carpaneto Piacentino',
		'IT033012' => 'CastellArquato',
		'IT033013' => 'Castel San Giovanni',
		'IT033014' => 'Castelvetro Piacentino',
		'IT033015' => 'Cerignale',
		'IT033016' => 'Coli',
		'IT033017' => 'Corte Brugnatella',
		'IT033018' => 'Cortemaggiore',
		'IT033019' => 'Farini',
		'IT033020' => 'Ferriere',
		'IT033021' => 'Fiorenzuola dArda',
		'IT033022' => 'Gazzola',
		'IT033023' => 'Gossolengo',
		'IT033024' => 'Gragnano Trebbiense',
		'IT033025' => 'Gropparello',
		'IT033026' => 'Lugagnano Val dArda',
		'IT033027' => 'Monticelli dOngina',
		'IT033028' => 'Morfasso',
		'IT033030' => 'Ottone',
		'IT033032' => 'Piacenza',
		'IT033033' => 'Pianello Val Tidone',
		'IT033034' => 'Piozzano',
		'IT033035' => 'Podenzano',
		'IT033036' => 'Ponte dellOlio',
		'IT033037' => 'Pontenure',
		'IT033038' => 'Rivergaro',
		'IT033039' => 'Rottofreno',
		'IT033040' => 'San Giorgio Piacentino',
		'IT033041' => 'San Pietro in Cerro',
		'IT033042' => 'Sarmato',
		'IT033043' => 'Travo',
		'IT033044' => 'Vernasca',
		'IT033045' => 'Vigolzone',
		'IT033046' => 'Villanova sullArda',
		'IT033047' => 'Zerba',
		'IT033048' => 'Ziano Piacentino',
		'IT033049' => 'Alta Val Tidone',
	],
	'PR' => [
		'IT034001' => 'Albareto',
		'IT034002' => 'Bardi',
		'IT034003' => 'Bedonia',
		'IT034004' => 'Berceto',
		'IT034005' => 'Bore',
		'IT034006' => 'Borgo Val di Taro',
		'IT034007' => 'Busseto',
		'IT034008' => 'Calestano',
		'IT034009' => 'Collecchio',
		'IT034010' => 'Colorno',
		'IT034011' => 'Compiano',
		'IT034012' => 'Corniglio',
		'IT034013' => 'Felino',
		'IT034014' => 'Fidenza',
		'IT034015' => 'Fontanellato',
		'IT034016' => 'Fontevivo',
		'IT034017' => 'Fornovo di Taro',
		'IT034018' => 'Langhirano',
		'IT034019' => 'Lesignano de Bagni',
		'IT034020' => 'Medesano',
		'IT034022' => 'Monchio delle Corti',
		'IT034023' => 'Montechiarugolo',
		'IT034024' => 'Neviano degli Arduini',
		'IT034025' => 'Noceto',
		'IT034026' => 'Palanzano',
		'IT034027' => 'Parma',
		'IT034028' => 'Pellegrino Parmense',
		'IT034030' => 'Roccabianca',
		'IT034031' => 'Sala Baganza',
		'IT034032' => 'Salsomaggiore Terme',
		'IT034033' => 'San Secondo Parmense',
		'IT034035' => 'Solignano',
		'IT034036' => 'Soragna',
		'IT034038' => 'Terenzo',
		'IT034039' => 'Tizzano Val Parma',
		'IT034040' => 'Tornolo',
		'IT034041' => 'Torrile',
		'IT034042' => 'Traversetolo',
		'IT034044' => 'Valmozzola',
		'IT034045' => 'Varano de Melegari',
		'IT034046' => 'Varsi',
		'IT034049' => 'Sissa Trecasali',
		'IT034050' => 'Polesine Zibello',
		'IT034051' => 'Sorbolo Mezzani',
	],
	'RE' => [
		'IT035001' => 'Albinea',
		'IT035002' => 'Bagnolo in Piano',
		'IT035003' => 'Baiso',
		'IT035004' => 'Bibbiano',
		'IT035005' => 'Boretto',
		'IT035006' => 'Brescello',
		'IT035008' => 'Cadelbosco di Sopra',
		'IT035009' => 'Campagnola Emilia',
		'IT035010' => 'Campegine',
		'IT035011' => 'Carpineti',
		'IT035012' => 'Casalgrande',
		'IT035013' => 'Casina',
		'IT035014' => 'Castellarano',
		'IT035015' => 'Castelnovo di Sotto',
		'IT035016' => 'Castelnovo ne Monti',
		'IT035017' => 'Cavriago',
		'IT035018' => 'Canossa',
		'IT035020' => 'Correggio',
		'IT035021' => 'Fabbrico',
		'IT035022' => 'Gattatico',
		'IT035023' => 'Gualtieri',
		'IT035024' => 'Guastalla',
		'IT035026' => 'Luzzara',
		'IT035027' => 'Montecchio Emilia',
		'IT035028' => 'Novellara',
		'IT035029' => 'Poviglio',
		'IT035030' => 'Quattro Castella',
		'IT035032' => 'Reggiolo',
		'IT035033' => 'Reggio nellEmilia',
		'IT035034' => 'Rio Saliceto',
		'IT035035' => 'Rolo',
		'IT035036' => 'Rubiera',
		'IT035037' => 'San Martino in Rio',
		'IT035038' => 'San Polo dEnza',
		'IT035039' => 'SantIlario dEnza',
		'IT035040' => 'Scandiano',
		'IT035041' => 'Toano',
		'IT035042' => 'Vetto',
		'IT035043' => 'Vezzano sul Crostolo',
		'IT035044' => 'Viano',
		'IT035045' => 'Villa Minozzo',
		'IT035046' => 'Ventasso',
	],
	'MO' => [
		'IT036001' => 'Bastiglia',
		'IT036002' => 'Bomporto',
		'IT036003' => 'Campogalliano',
		'IT036004' => 'Camposanto',
		'IT036005' => 'Carpi',
		'IT036006' => 'Castelfranco Emilia',
		'IT036007' => 'Castelnuovo Rangone',
		'IT036008' => 'Castelvetro di Modena',
		'IT036009' => 'Cavezzo',
		'IT036010' => 'Concordia sulla Secchia',
		'IT036011' => 'Fanano',
		'IT036012' => 'Finale Emilia',
		'IT036013' => 'Fiorano Modenese',
		'IT036014' => 'Fiumalbo',
		'IT036015' => 'Formigine',
		'IT036016' => 'Frassinoro',
		'IT036017' => 'Guiglia',
		'IT036018' => 'Lama Mocogno',
		'IT036019' => 'Maranello',
		'IT036020' => 'Marano sul Panaro',
		'IT036021' => 'Medolla',
		'IT036022' => 'Mirandola',
		'IT036023' => 'Modena',
		'IT036024' => 'Montecreto',
		'IT036025' => 'Montefiorino',
		'IT036026' => 'Montese',
		'IT036027' => 'Nonantola',
		'IT036028' => 'Novi di Modena',
		'IT036029' => 'Palagano',
		'IT036030' => 'Pavullo nel Frignano',
		'IT036031' => 'Pievepelago',
		'IT036032' => 'Polinago',
		'IT036033' => 'Prignano sulla Secchia',
		'IT036034' => 'Ravarino',
		'IT036035' => 'Riolunato',
		'IT036036' => 'San Cesario sul Panaro',
		'IT036037' => 'San Felice sul Panaro',
		'IT036038' => 'San Possidonio',
		'IT036039' => 'San Prospero',
		'IT036040' => 'Sassuolo',
		'IT036041' => 'Savignano sul Panaro',
		'IT036042' => 'Serramazzoni',
		'IT036043' => 'Sestola',
		'IT036044' => 'Soliera',
		'IT036045' => 'Spilamberto',
		'IT036046' => 'Vignola',
		'IT036047' => 'Zocca',
	],
	'BO' => [
		'IT037001' => 'Anzola dellEmilia',
		'IT037002' => 'Argelato',
		'IT037003' => 'Baricella',
		'IT037005' => 'Bentivoglio',
		'IT037006' => 'Bologna',
		'IT037007' => 'Borgo Tossignano',
		'IT037008' => 'Budrio',
		'IT037009' => 'Calderara di Reno',
		'IT037010' => 'Camugnano',
		'IT037011' => 'Casalecchio di Reno',
		'IT037012' => 'Casalfiumanese',
		'IT037013' => 'Castel dAiano',
		'IT037014' => 'Castel del Rio',
		'IT037015' => 'Castel di Casio',
		'IT037016' => 'Castel Guelfo di Bologna',
		'IT037017' => 'Castello dArgile',
		'IT037019' => 'Castel Maggiore',
		'IT037020' => 'Castel San Pietro Terme',
		'IT037021' => 'Castenaso',
		'IT037022' => 'Castiglione dei Pepoli',
		'IT037024' => 'Crevalcore',
		'IT037025' => 'Dozza',
		'IT037026' => 'Fontanelice',
		'IT037027' => 'Gaggio Montano',
		'IT037028' => 'Galliera',
		'IT037030' => 'Granarolo dellEmilia',
		'IT037031' => 'Grizzana Morandi',
		'IT037032' => 'Imola',
		'IT037033' => 'Lizzano in Belvedere',
		'IT037034' => 'Loiano',
		'IT037035' => 'Malalbergo',
		'IT037036' => 'Marzabotto',
		'IT037037' => 'Medicina',
		'IT037038' => 'Minerbio',
		'IT037039' => 'Molinella',
		'IT037040' => 'Monghidoro',
		'IT037041' => 'Monterenzio',
		'IT037042' => 'Monte San Pietro',
		'IT037044' => 'Monzuno',
		'IT037045' => 'Mordano',
		'IT037046' => 'Ozzano dellEmilia',
		'IT037047' => 'Pianoro',
		'IT037048' => 'Pieve di Cento',
		'IT037050' => 'Sala Bolognese',
		'IT037051' => 'San Benedetto Val di Sambro',
		'IT037052' => 'San Giorgio di Piano',
		'IT037053' => 'San Giovanni in Persiceto',
		'IT037054' => 'San Lazzaro di Savena',
		'IT037055' => 'San Pietro in Casale',
		'IT037056' => 'SantAgata Bolognese',
		'IT037057' => 'Sasso Marconi',
		'IT037059' => 'Vergato',
		'IT037060' => 'Zola Predosa',
		'IT037061' => 'Valsamoggia',
		'IT037062' => 'Alto Reno Terme',
	],
	'FE' => [
		'IT038001' => 'Argenta',
		'IT038003' => 'Bondeno',
		'IT038004' => 'Cento',
		'IT038005' => 'Codigoro',
		'IT038006' => 'Comacchio',
		'IT038007' => 'Copparo',
		'IT038008' => 'Ferrara',
		'IT038010' => 'Jolanda di Savoia',
		'IT038011' => 'Lagosanto',
		'IT038012' => 'Masi Torello',
		'IT038014' => 'Mesola',
		'IT038017' => 'Ostellato',
		'IT038018' => 'Poggio Renatico',
		'IT038019' => 'Portomaggiore',
		'IT038022' => 'Vigarano Mainarda',
		'IT038023' => 'Voghiera',
		'IT038025' => 'Goro',
		'IT038027' => 'Fiscaglia',
		'IT038028' => 'Terre del Reno',
		'IT038029' => 'Riva del Po',
		'IT038030' => 'Tresignana',
	],
	'RA' => [
		'IT039001' => 'Alfonsine',
		'IT039002' => 'Bagnacavallo',
		'IT039003' => 'Bagnara di Romagna',
		'IT039004' => 'Brisighella',
		'IT039005' => 'Casola Valsenio',
		'IT039006' => 'Castel Bolognese',
		'IT039007' => 'Cervia',
		'IT039008' => 'Conselice',
		'IT039009' => 'Cotignola',
		'IT039010' => 'Faenza',
		'IT039011' => 'Fusignano',
		'IT039012' => 'Lugo',
		'IT039013' => 'Massa Lombarda',
		'IT039014' => 'Ravenna',
		'IT039015' => 'Riolo Terme',
		'IT039016' => 'Russi',
		'IT039017' => 'SantAgata sul Santerno',
		'IT039018' => 'Solarolo',
	],
	'FC' => [
		'IT040001' => 'Bagno di Romagna',
		'IT040003' => 'Bertinoro',
		'IT040004' => 'Borghi',
		'IT040005' => 'Castrocaro Terme e Terra del Sole',
		'IT040007' => 'Cesena',
		'IT040008' => 'Cesenatico',
		'IT040009' => 'Civitella di Romagna',
		'IT040011' => 'Dovadola',
		'IT040012' => 'Forlì',
		'IT040013' => 'Forlimpopoli',
		'IT040014' => 'Galeata',
		'IT040015' => 'Gambettola',
		'IT040016' => 'Gatteo',
		'IT040018' => 'Longiano',
		'IT040019' => 'Meldola',
		'IT040020' => 'Mercato Saraceno',
		'IT040022' => 'Modigliana',
		'IT040028' => 'Montiano',
		'IT040031' => 'Portico e San Benedetto',
		'IT040032' => 'Predappio',
		'IT040033' => 'Premilcuore',
		'IT040036' => 'Rocca San Casciano',
		'IT040037' => 'Roncofreddo',
		'IT040041' => 'San Mauro Pascoli',
		'IT040043' => 'Santa Sofia',
		'IT040044' => 'Sarsina',
		'IT040045' => 'Savignano sul Rubicone',
		'IT040046' => 'Sogliano al Rubicone',
		'IT040049' => 'Tredozio',
		'IT040050' => 'Verghereto',
	],
	'RN' => [
		'IT099001' => 'Bellaria-Igea Marina',
		'IT099002' => 'Cattolica',
		'IT099003' => 'Coriano',
		'IT099004' => 'Gemmano',
		'IT099005' => 'Misano Adriatico',
		'IT099006' => 'Mondaino',
		'IT099008' => 'Montefiore Conca',
		'IT099009' => 'Montegridolfo',
		'IT099011' => 'Morciano di Romagna',
		'IT099013' => 'Riccione',
		'IT099014' => 'Rimini',
		'IT099015' => 'Saludecio',
		'IT099016' => 'San Clemente',
		'IT099017' => 'San Giovanni in Marignano',
		'IT099018' => 'Santarcangelo di Romagna',
		'IT099020' => 'Verucchio',
		'IT099021' => 'Casteldelci',
		'IT099022' => 'Maiolo',
		'IT099023' => 'Novafeltria',
		'IT099024' => 'Pennabilli',
		'IT099025' => 'San Leo',
		'IT099026' => 'SantAgata Feltria',
		'IT099027' => 'Talamello',
		'IT099028' => 'Poggio Torriana',
		'IT099029' => 'Montescudo-Monte Colombo',
	],
	'MS' => [
		'IT045001' => 'Aulla',
		'IT045002' => 'Bagnone',
		'IT045003' => 'Carrara',
		'IT045004' => 'Casola in Lunigiana',
		'IT045005' => 'Comano',
		'IT045006' => 'Filattiera',
		'IT045007' => 'Fivizzano',
		'IT045008' => 'Fosdinovo',
		'IT045009' => 'Licciana Nardi',
		'IT045010' => 'Massa',
		'IT045011' => 'Montignoso',
		'IT045012' => 'Mulazzo',
		'IT045013' => 'Podenzana',
		'IT045014' => 'Pontremoli',
		'IT045015' => 'Tresana',
		'IT045016' => 'Villafranca in Lunigiana',
		'IT045017' => 'Zeri',
	],
	'LU' => [
		'IT046001' => 'Altopascio',
		'IT046002' => 'Bagni di Lucca',
		'IT046003' => 'Barga',
		'IT046004' => 'Borgo a Mozzano',
		'IT046005' => 'Camaiore',
		'IT046006' => 'Camporgiano',
		'IT046007' => 'Capannori',
		'IT046008' => 'Careggine',
		'IT046009' => 'Castelnuovo di Garfagnana',
		'IT046010' => 'Castiglione di Garfagnana',
		'IT046011' => 'Coreglia Antelminelli',
		'IT046013' => 'Forte dei Marmi',
		'IT046014' => 'Fosciandora',
		'IT046015' => 'Gallicano',
		'IT046017' => 'Lucca',
		'IT046018' => 'Massarosa',
		'IT046019' => 'Minucciano',
		'IT046020' => 'Molazzana',
		'IT046021' => 'Montecarlo',
		'IT046022' => 'Pescaglia',
		'IT046023' => 'Piazza al Serchio',
		'IT046024' => 'Pietrasanta',
		'IT046025' => 'Pieve Fosciana',
		'IT046026' => 'Porcari',
		'IT046027' => 'San Romano in Garfagnana',
		'IT046028' => 'Seravezza',
		'IT046030' => 'Stazzema',
		'IT046031' => 'Vagli Sotto',
		'IT046033' => 'Viareggio',
		'IT046034' => 'Villa Basilica',
		'IT046035' => 'Villa Collemandina',
		'IT046036' => 'Fabbriche di Vergemoli',
		'IT046037' => 'Sillano Giuncugnano',
	],
	'PT' => [
		'IT047002' => 'Agliana',
		'IT047003' => 'Buggiano',
		'IT047005' => 'Lamporecchio',
		'IT047006' => 'Larciano',
		'IT047007' => 'Marliana',
		'IT047008' => 'Massa e Cozzile',
		'IT047009' => 'Monsummano Terme',
		'IT047010' => 'Montale',
		'IT047011' => 'Montecatini-Terme',
		'IT047012' => 'Pescia',
		'IT047013' => 'Pieve a Nievole',
		'IT047014' => 'Pistoia',
		'IT047016' => 'Ponte Buggianese',
		'IT047017' => 'Quarrata',
		'IT047018' => 'Sambuca Pistoiese',
		'IT047020' => 'Serravalle Pistoiese',
		'IT047021' => 'Uzzano',
		'IT047022' => 'Chiesina Uzzanese',
		'IT047023' => 'Abetone Cutigliano',
		'IT047024' => 'San Marcello Piteglio',
	],
	'FI' => [
		'IT048001' => 'Bagno a Ripoli',
		'IT048002' => 'Barberino di Mugello',
		'IT048004' => 'Borgo San Lorenzo',
		'IT048005' => 'Calenzano',
		'IT048006' => 'Campi Bisenzio',
		'IT048008' => 'Capraia e Limite',
		'IT048010' => 'Castelfiorentino',
		'IT048011' => 'Cerreto Guidi',
		'IT048012' => 'Certaldo',
		'IT048013' => 'Dicomano',
		'IT048014' => 'Empoli',
		'IT048015' => 'Fiesole',
		'IT048017' => 'Firenze',
		'IT048018' => 'Firenzuola',
		'IT048019' => 'Fucecchio',
		'IT048020' => 'Gambassi Terme',
		'IT048021' => 'Greve in Chianti',
		'IT048022' => 'Impruneta',
		'IT048024' => 'Lastra a Signa',
		'IT048025' => 'Londa',
		'IT048026' => 'Marradi',
		'IT048027' => 'Montaione',
		'IT048028' => 'Montelupo Fiorentino',
		'IT048030' => 'Montespertoli',
		'IT048031' => 'Palazzuolo sul Senio',
		'IT048032' => 'Pelago',
		'IT048033' => 'Pontassieve',
		'IT048035' => 'Reggello',
		'IT048036' => 'Rignano sullArno',
		'IT048037' => 'Rufina',
		'IT048038' => 'San Casciano in Val di Pesa',
		'IT048039' => 'San Godenzo',
		'IT048041' => 'Scandicci',
		'IT048043' => 'Sesto Fiorentino',
		'IT048044' => 'Signa',
		'IT048046' => 'Vaglia',
		'IT048049' => 'Vicchio',
		'IT048050' => 'Vinci',
		'IT048052' => 'Figline e Incisa Valdarno',
		'IT048053' => 'Scarperia e San Piero',
		'IT048054' => 'Barberino Tavarnelle',
	],
	'LI' => [
		'IT049001' => 'Bibbona',
		'IT049002' => 'Campiglia Marittima',
		'IT049003' => 'Campo nellElba',
		'IT049004' => 'Capoliveri',
		'IT049005' => 'Capraia Isola',
		'IT049006' => 'Castagneto Carducci',
		'IT049007' => 'Cecina',
		'IT049008' => 'Collesalvetti',
		'IT049009' => 'Livorno',
		'IT049010' => 'Marciana',
		'IT049011' => 'Marciana Marina',
		'IT049012' => 'Piombino',
		'IT049013' => 'Porto Azzurro',
		'IT049014' => 'Portoferraio',
		'IT049017' => 'Rosignano Marittimo',
		'IT049018' => 'San Vincenzo',
		'IT049019' => 'Sassetta',
		'IT049020' => 'Suvereto',
		'IT049021' => 'Rio',
	],
	'PI' => [
		'IT050001' => 'Bientina',
		'IT050002' => 'Buti',
		'IT050003' => 'Calci',
		'IT050004' => 'Calcinaia',
		'IT050005' => 'Capannoli',
		'IT050006' => 'Casale Marittimo',
		'IT050008' => 'Cascina',
		'IT050009' => 'Castelfranco di Sotto',
		'IT050010' => 'Castellina Marittima',
		'IT050011' => 'Castelnuovo di Val di Cecina',
		'IT050012' => 'Chianni',
		'IT050014' => 'Fauglia',
		'IT050015' => 'Guardistallo',
		'IT050016' => 'Lajatico',
		'IT050019' => 'Montecatini Val di Cecina',
		'IT050020' => 'Montescudaio',
		'IT050021' => 'Monteverdi Marittimo',
		'IT050022' => 'Montopoli in Val dArno',
		'IT050023' => 'Orciano Pisano',
		'IT050024' => 'Palaia',
		'IT050025' => 'Peccioli',
		'IT050026' => 'Pisa',
		'IT050027' => 'Pomarance',
		'IT050028' => 'Ponsacco',
		'IT050029' => 'Pontedera',
		'IT050030' => 'Riparbella',
		'IT050031' => 'San Giuliano Terme',
		'IT050032' => 'San Miniato',
		'IT050033' => 'Santa Croce sullArno',
		'IT050034' => 'Santa Luce',
		'IT050035' => 'Santa Maria a Monte',
		'IT050036' => 'Terricciola',
		'IT050037' => 'Vecchiano',
		'IT050038' => 'Vicopisano',
		'IT050039' => 'Volterra',
		'IT050040' => 'Casciana Terme Lari',
		'IT050041' => 'Crespina Lorenzana',
	],
	'AR' => [
		'IT051001' => 'Anghiari',
		'IT051002' => 'Arezzo',
		'IT051003' => 'Badia Tedalda',
		'IT051004' => 'Bibbiena',
		'IT051005' => 'Bucine',
		'IT051006' => 'Capolona',
		'IT051007' => 'Caprese Michelangelo',
		'IT051008' => 'Castel Focognano',
		'IT051010' => 'Castel San Niccolò',
		'IT051011' => 'Castiglion Fibocchi',
		'IT051012' => 'Castiglion Fiorentino',
		'IT051013' => 'Cavriglia',
		'IT051014' => 'Chitignano',
		'IT051015' => 'Chiusi della Verna',
		'IT051016' => 'Civitella in Val di Chiana',
		'IT051017' => 'Cortona',
		'IT051018' => 'Foiano della Chiana',
		'IT051020' => 'Loro Ciuffenna',
		'IT051021' => 'Lucignano',
		'IT051022' => 'Marciano della Chiana',
		'IT051023' => 'Montemignaio',
		'IT051024' => 'Monterchi',
		'IT051025' => 'Monte San Savino',
		'IT051026' => 'Montevarchi',
		'IT051027' => 'Ortignano Raggiolo',
		'IT051030' => 'Pieve Santo Stefano',
		'IT051031' => 'Poppi',
		'IT051033' => 'San Giovanni Valdarno',
		'IT051034' => 'Sansepolcro',
		'IT051035' => 'Sestino',
		'IT051037' => 'Subbiano',
		'IT051038' => 'Talla',
		'IT051039' => 'Terranuova Bracciolini',
		'IT051040' => 'Castelfranco Piandiscò',
		'IT051041' => 'Pratovecchio Stia',
		'IT051042' => 'Laterina Pergine Valdarno',
	],
	'SI' => [
		'IT052001' => 'Abbadia San Salvatore',
		'IT052002' => 'Asciano',
		'IT052003' => 'Buonconvento',
		'IT052004' => 'Casole dElsa',
		'IT052005' => 'Castellina in Chianti',
		'IT052006' => 'Castelnuovo Berardenga',
		'IT052007' => 'Castiglione dOrcia',
		'IT052008' => 'Cetona',
		'IT052009' => 'Chianciano Terme',
		'IT052010' => 'Chiusdino',
		'IT052011' => 'Chiusi',
		'IT052012' => 'Colle di Val dElsa',
		'IT052013' => 'Gaiole in Chianti',
		'IT052015' => 'Montepulciano',
		'IT052016' => 'Monteriggioni',
		'IT052017' => 'Monteroni dArbia',
		'IT052018' => 'Monticiano',
		'IT052019' => 'Murlo',
		'IT052020' => 'Piancastagnaio',
		'IT052021' => 'Pienza',
		'IT052022' => 'Poggibonsi',
		'IT052023' => 'Radda in Chianti',
		'IT052024' => 'Radicofani',
		'IT052025' => 'Radicondoli',
		'IT052026' => 'Rapolano Terme',
		'IT052027' => 'San Casciano dei Bagni',
		'IT052028' => 'San Gimignano',
		'IT052030' => 'San Quirico dOrcia',
		'IT052031' => 'Sarteano',
		'IT052032' => 'Siena',
		'IT052033' => 'Sinalunga',
		'IT052034' => 'Sovicille',
		'IT052035' => 'Torrita di Siena',
		'IT052036' => 'Trequanda',
		'IT052037' => 'Montalcino',
	],
	'GR' => [
		'IT053001' => 'Arcidosso',
		'IT053002' => 'Campagnatico',
		'IT053003' => 'Capalbio',
		'IT053004' => 'Castel del Piano',
		'IT053005' => 'CastellAzzara',
		'IT053006' => 'Castiglione della Pescaia',
		'IT053007' => 'Cinigiano',
		'IT053008' => 'Civitella Paganico',
		'IT053009' => 'Follonica',
		'IT053010' => 'Gavorrano',
		'IT053011' => 'Grosseto',
		'IT053012' => 'Isola del Giglio',
		'IT053013' => 'Magliano in Toscana',
		'IT053014' => 'Manciano',
		'IT053015' => 'Massa Marittima',
		'IT053016' => 'Monte Argentario',
		'IT053017' => 'Montieri',
		'IT053018' => 'Orbetello',
		'IT053019' => 'Pitigliano',
		'IT053020' => 'Roccalbegna',
		'IT053021' => 'Roccastrada',
		'IT053022' => 'Santa Fiora',
		'IT053023' => 'Scansano',
		'IT053024' => 'Scarlino',
		'IT053025' => 'Seggiano',
		'IT053026' => 'Sorano',
		'IT053027' => 'Monterotondo Marittimo',
		'IT053028' => 'Semproniano',
	],
	'PO' => [
		'IT100001' => 'Cantagallo',
		'IT100002' => 'Carmignano',
		'IT100003' => 'Montemurlo',
		'IT100004' => 'Poggio a Caiano',
		'IT100005' => 'Prato',
		'IT100006' => 'Vaiano',
		'IT100007' => 'Vernio',
	],
	'PG' => [
		'IT054001' => 'Assisi',
		'IT054002' => 'Bastia Umbra',
		'IT054003' => 'Bettona',
		'IT054004' => 'Bevagna',
		'IT054005' => 'Campello sul Clitunno',
		'IT054006' => 'Cannara',
		'IT054007' => 'Cascia',
		'IT054008' => 'Castel Ritaldi',
		'IT054009' => 'Castiglione del Lago',
		'IT054010' => 'Cerreto di Spoleto',
		'IT054011' => 'Citerna',
		'IT054012' => 'Città della Pieve',
		'IT054013' => 'Città di Castello',
		'IT054014' => 'Collazzone',
		'IT054015' => 'Corciano',
		'IT054016' => 'Costacciaro',
		'IT054017' => 'Deruta',
		'IT054018' => 'Foligno',
		'IT054019' => 'Fossato di Vico',
		'IT054020' => 'Fratta Todina',
		'IT054021' => 'Giano dellUmbria',
		'IT054022' => 'Gualdo Cattaneo',
		'IT054023' => 'Gualdo Tadino',
		'IT054024' => 'Gubbio',
		'IT054025' => 'Lisciano Niccone',
		'IT054026' => 'Magione',
		'IT054027' => 'Marsciano',
		'IT054028' => 'Massa Martana',
		'IT054029' => 'Monte Castello di Vibio',
		'IT054030' => 'Montefalco',
		'IT054031' => 'Monteleone di Spoleto',
		'IT054032' => 'Monte Santa Maria Tiberina',
		'IT054033' => 'Montone',
		'IT054034' => 'Nocera Umbra',
		'IT054035' => 'Norcia',
		'IT054036' => 'Paciano',
		'IT054037' => 'Panicale',
		'IT054038' => 'Passignano sul Trasimeno',
		'IT054039' => 'Perugia',
		'IT054040' => 'Piegaro',
		'IT054041' => 'Pietralunga',
		'IT054042' => 'Poggiodomo',
		'IT054043' => 'Preci',
		'IT054044' => 'San Giustino',
		'IT054045' => 'SantAnatolia di Narco',
		'IT054046' => 'Scheggia e Pascelupo',
		'IT054047' => 'Scheggino',
		'IT054048' => 'Sellano',
		'IT054049' => 'Sigillo',
		'IT054050' => 'Spello',
		'IT054051' => 'Spoleto',
		'IT054052' => 'Todi',
		'IT054053' => 'Torgiano',
		'IT054054' => 'Trevi',
		'IT054055' => 'Tuoro sul Trasimeno',
		'IT054056' => 'Umbertide',
		'IT054057' => 'Valfabbrica',
		'IT054058' => 'Vallo di Nera',
		'IT054059' => 'Valtopina',
		'IT057001' => 'Accumoli',
		'IT057002' => 'Amatrice',
		'IT057003' => 'Antrodoco',
		'IT057004' => 'Ascrea',
		'IT057005' => 'Belmonte in Sabina',
		'IT057006' => 'Borbona',
		'IT057007' => 'Borgorose',
		'IT057008' => 'Borgo Velino',
		'IT057009' => 'Cantalice',
		'IT057010' => 'Cantalupo in Sabina',
		'IT057011' => 'Casaprota',
		'IT057012' => 'Casperia',
		'IT057013' => 'Castel di Tora',
		'IT057014' => 'Castelnuovo di Farfa',
		'IT057015' => 'Castel SantAngelo',
		'IT057016' => 'Cittaducale',
		'IT057017' => 'Cittareale',
		'IT057018' => 'Collalto Sabino',
		'IT057019' => 'Colle di Tora',
		'IT057020' => 'Collegiove',
		'IT057021' => 'Collevecchio',
		'IT057022' => 'Colli sul Velino',
		'IT057023' => 'Concerviano',
		'IT057024' => 'Configni',
		'IT057025' => 'Contigliano',
		'IT057026' => 'Cottanello',
		'IT057027' => 'Fara in Sabina',
		'IT057028' => 'Fiamignano',
		'IT057029' => 'Forano',
		'IT057030' => 'Frasso Sabino',
		'IT057031' => 'Greccio',
		'IT057032' => 'Labro',
		'IT057033' => 'Leonessa',
		'IT057034' => 'Longone Sabino',
		'IT057035' => 'Magliano Sabina',
		'IT057036' => 'Marcetelli',
		'IT057037' => 'Micigliano',
		'IT057038' => 'Mompeo',
		'IT057039' => 'Montasola',
		'IT057040' => 'Montebuono',
		'IT057041' => 'Monteleone Sabino',
		'IT057042' => 'Montenero Sabino',
		'IT057043' => 'Monte San Giovanni in Sabina',
		'IT057044' => 'Montopoli di Sabina',
		'IT057045' => 'Morro Reatino',
		'IT057046' => 'Nespolo',
		'IT057047' => 'Orvinio',
		'IT057048' => 'Paganico Sabino',
		'IT057049' => 'Pescorocchiano',
		'IT057050' => 'Petrella Salto',
		'IT057051' => 'Poggio Bustone',
		'IT057052' => 'Poggio Catino',
		'IT057053' => 'Poggio Mirteto',
		'IT057054' => 'Poggio Moiano',
		'IT057055' => 'Poggio Nativo',
		'IT057056' => 'Poggio San Lorenzo',
		'IT057057' => 'Posta',
		'IT057058' => 'Pozzaglia Sabina',
		'IT057059' => 'Rieti',
		'IT057060' => 'Rivodutri',
		'IT057061' => 'Roccantica',
		'IT057062' => 'Rocca Sinibalda',
		'IT057063' => 'Salisano',
		'IT057064' => 'Scandriglia',
		'IT057065' => 'Selci',
		'IT057066' => 'Stimigliano',
		'IT057067' => 'Tarano',
		'IT057068' => 'Toffia',
		'IT057069' => 'Torricella in Sabina',
		'IT057070' => 'Torri in Sabina',
		'IT057071' => 'Turania',
		'IT057072' => 'Vacone',
		'IT057073' => 'Varco Sabino',
	],
	'TR' => [
		'IT055001' => 'Acquasparta',
		'IT055002' => 'Allerona',
		'IT055003' => 'Alviano',
		'IT055004' => 'Amelia',
		'IT055005' => 'Arrone',
		'IT055006' => 'Attigliano',
		'IT055007' => 'Baschi',
		'IT055008' => 'Calvi dellUmbria',
		'IT055009' => 'Castel Giorgio',
		'IT055010' => 'Castel Viscardo',
		'IT055011' => 'Fabro',
		'IT055012' => 'Ferentillo',
		'IT055013' => 'Ficulle',
		'IT055014' => 'Giove',
		'IT055015' => 'Guardea',
		'IT055016' => 'Lugnano in Teverina',
		'IT055017' => 'Montecastrilli',
		'IT055018' => 'Montecchio',
		'IT055019' => 'Montefranco',
		'IT055020' => 'Montegabbione',
		'IT055021' => 'Monteleone dOrvieto',
		'IT055022' => 'Narni',
		'IT055023' => 'Orvieto',
		'IT055024' => 'Otricoli',
		'IT055025' => 'Parrano',
		'IT055026' => 'Penna in Teverina',
		'IT055027' => 'Polino',
		'IT055028' => 'Porano',
		'IT055029' => 'San Gemini',
		'IT055030' => 'San Venanzo',
		'IT055031' => 'Stroncone',
		'IT055032' => 'Terni',
		'IT055033' => 'Avigliano Umbro',
	],
	'PU' => [
		'IT041001' => 'Acqualagna',
		'IT041002' => 'Apecchio',
		'IT041005' => 'Belforte allIsauro',
		'IT041006' => 'Borgo Pace',
		'IT041007' => 'Cagli',
		'IT041008' => 'Cantiano',
		'IT041009' => 'Carpegna',
		'IT041010' => 'Cartoceto',
		'IT041013' => 'Fano',
		'IT041014' => 'Fermignano',
		'IT041015' => 'Fossombrone',
		'IT041016' => 'Fratte Rosa',
		'IT041017' => 'Frontino',
		'IT041018' => 'Frontone',
		'IT041019' => 'Gabicce Mare',
		'IT041020' => 'Gradara',
		'IT041021' => 'Isola del Piano',
		'IT041022' => 'Lunano',
		'IT041023' => 'Macerata Feltria',
		'IT041025' => 'Mercatello sul Metauro',
		'IT041026' => 'Mercatino Conca',
		'IT041027' => 'Mombaroccio',
		'IT041028' => 'Mondavio',
		'IT041029' => 'Mondolfo',
		'IT041030' => 'Montecalvo in Foglia',
		'IT041031' => 'Monte Cerignone',
		'IT041032' => 'Monteciccardo',
		'IT041033' => 'Montecopiolo',
		'IT041034' => 'Montefelcino',
		'IT041035' => 'Monte Grimano Terme',
		'IT041036' => 'Montelabbate',
		'IT041038' => 'Monte Porzio',
		'IT041041' => 'Peglio',
		'IT041043' => 'Pergola',
		'IT041044' => 'Pesaro',
		'IT041045' => 'Petriano',
		'IT041047' => 'Piandimeleto',
		'IT041048' => 'Pietrarubbia',
		'IT041049' => 'Piobbico',
		'IT041051' => 'San Costanzo',
		'IT041054' => 'San Lorenzo in Campo',
		'IT041057' => 'SantAngelo in Vado',
		'IT041058' => 'SantIppolito',
		'IT041060' => 'Sassofeltrio',
		'IT041061' => 'Serra SantAbbondio',
		'IT041064' => 'Tavoleto',
		'IT041065' => 'Tavullia',
		'IT041066' => 'Urbania',
		'IT041067' => 'Urbino',
		'IT041068' => 'Vallefoglia',
		'IT041069' => 'Colli al Metauro',
		'IT041070' => 'Terre Roveresche',
		'IT041071' => 'Sassocorvaro Auditore',
	],
	'AN' => [
		'IT042001' => 'Agugliano',
		'IT042002' => 'Ancona',
		'IT042003' => 'Arcevia',
		'IT042004' => 'Barbara',
		'IT042005' => 'Belvedere Ostrense',
		'IT042006' => 'Camerano',
		'IT042007' => 'Camerata Picena',
		'IT042008' => 'Castelbellino',
		'IT042010' => 'Castelfidardo',
		'IT042011' => 'Castelleone di Suasa',
		'IT042012' => 'Castelplanio',
		'IT042013' => 'Cerreto dEsi',
		'IT042014' => 'Chiaravalle',
		'IT042015' => 'Corinaldo',
		'IT042016' => 'Cupramontana',
		'IT042017' => 'Fabriano',
		'IT042018' => 'Falconara Marittima',
		'IT042019' => 'Filottrano',
		'IT042020' => 'Genga',
		'IT042021' => 'Jesi',
		'IT042022' => 'Loreto',
		'IT042023' => 'Maiolati Spontini',
		'IT042024' => 'Mergo',
		'IT042025' => 'Monsano',
		'IT042026' => 'Montecarotto',
		'IT042027' => 'Montemarciano',
		'IT042029' => 'Monte Roberto',
		'IT042030' => 'Monte San Vito',
		'IT042031' => 'Morro dAlba',
		'IT042032' => 'Numana',
		'IT042033' => 'Offagna',
		'IT042034' => 'Osimo',
		'IT042035' => 'Ostra',
		'IT042036' => 'Ostra Vetere',
		'IT042037' => 'Poggio San Marcello',
		'IT042038' => 'Polverigi',
		'IT042040' => 'Rosora',
		'IT042041' => 'San Marcello',
		'IT042042' => 'San Paolo di Jesi',
		'IT042043' => 'Santa Maria Nuova',
		'IT042044' => 'Sassoferrato',
		'IT042045' => 'Senigallia',
		'IT042046' => 'Serra de Conti',
		'IT042047' => 'Serra San Quirico',
		'IT042048' => 'Sirolo',
		'IT042049' => 'Staffolo',
		'IT042050' => 'Trecastelli',
	],
	'MC' => [
		'IT043002' => 'Apiro',
		'IT043003' => 'Appignano',
		'IT043004' => 'Belforte del Chienti',
		'IT043005' => 'Bolognola',
		'IT043006' => 'Caldarola',
		'IT043007' => 'Camerino',
		'IT043008' => 'Camporotondo di Fiastrone',
		'IT043009' => 'Castelraimondo',
		'IT043010' => 'Castelsantangelo sul Nera',
		'IT043011' => 'Cessapalombo',
		'IT043012' => 'Cingoli',
		'IT043013' => 'Civitanova Marche',
		'IT043014' => 'Colmurano',
		'IT043015' => 'Corridonia',
		'IT043016' => 'Esanatoglia',
		'IT043017' => 'Fiastra',
		'IT043019' => 'Fiuminata',
		'IT043020' => 'Gagliole',
		'IT043021' => 'Gualdo',
		'IT043022' => 'Loro Piceno',
		'IT043023' => 'Macerata',
		'IT043024' => 'Matelica',
		'IT043025' => 'Mogliano',
		'IT043026' => 'Montecassiano',
		'IT043027' => 'Monte Cavallo',
		'IT043028' => 'Montecosaro',
		'IT043029' => 'Montefano',
		'IT043030' => 'Montelupone',
		'IT043031' => 'Monte San Giusto',
		'IT043032' => 'Monte San Martino',
		'IT043033' => 'Morrovalle',
		'IT043034' => 'Muccia',
		'IT043035' => 'Penna San Giovanni',
		'IT043036' => 'Petriolo',
		'IT043038' => 'Pieve Torina',
		'IT043039' => 'Pioraco',
		'IT043040' => 'Poggio San Vicino',
		'IT043041' => 'Pollenza',
		'IT043042' => 'Porto Recanati',
		'IT043043' => 'Potenza Picena',
		'IT043044' => 'Recanati',
		'IT043045' => 'Ripe San Ginesio',
		'IT043046' => 'San Ginesio',
		'IT043047' => 'San Severino Marche',
		'IT043048' => 'SantAngelo in Pontano',
		'IT043049' => 'Sarnano',
		'IT043050' => 'Sefro',
		'IT043051' => 'Serrapetrona',
		'IT043052' => 'Serravalle di Chienti',
		'IT043053' => 'Tolentino',
		'IT043054' => 'Treia',
		'IT043055' => 'Urbisaglia',
		'IT043056' => 'Ussita',
		'IT043057' => 'Visso',
		'IT043058' => 'Valfornace',
	],
	'AP' => [
		'IT044001' => 'Acquasanta Terme',
		'IT044002' => 'Acquaviva Picena',
		'IT044005' => 'Appignano del Tronto',
		'IT044006' => 'Arquata del Tronto',
		'IT044007' => 'Ascoli Piceno',
		'IT044010' => 'Carassai',
		'IT044011' => 'Castel di Lama',
		'IT044012' => 'Castignano',
		'IT044013' => 'Castorano',
		'IT044014' => 'Colli del Tronto',
		'IT044015' => 'Comunanza',
		'IT044016' => 'Cossignano',
		'IT044017' => 'Cupra Marittima',
		'IT044020' => 'Folignano',
		'IT044021' => 'Force',
		'IT044023' => 'Grottammare',
		'IT044027' => 'Maltignano',
		'IT044029' => 'Massignano',
		'IT044031' => 'Monsampolo del Tronto',
		'IT044032' => 'Montalto delle Marche',
		'IT044034' => 'Montedinove',
		'IT044036' => 'Montefiore dellAso',
		'IT044038' => 'Montegallo',
		'IT044044' => 'Montemonaco',
		'IT044045' => 'Monteprandone',
		'IT044054' => 'Offida',
		'IT044056' => 'Palmiano',
		'IT044063' => 'Ripatransone',
		'IT044064' => 'Roccafluvione',
		'IT044065' => 'Rotella',
		'IT044066' => 'San Benedetto del Tronto',
		'IT044071' => 'Spinetoli',
		'IT044073' => 'Venarotta',
	],
	'FM' => [
		'IT109001' => 'Altidona',
		'IT109002' => 'Amandola',
		'IT109003' => 'Belmonte Piceno',
		'IT109004' => 'Campofilone',
		'IT109005' => 'Falerone',
		'IT109006' => 'Fermo',
		'IT109007' => 'Francavilla dEte',
		'IT109008' => 'Grottazzolina',
		'IT109009' => 'Lapedona',
		'IT109010' => 'Magliano di Tenna',
		'IT109011' => 'Massa Fermana',
		'IT109012' => 'Monsampietro Morico',
		'IT109013' => 'Montappone',
		'IT109014' => 'Montefalcone Appennino',
		'IT109015' => 'Montefortino',
		'IT109016' => 'Monte Giberto',
		'IT109017' => 'Montegiorgio',
		'IT109018' => 'Montegranaro',
		'IT109019' => 'Monteleone di Fermo',
		'IT109020' => 'Montelparo',
		'IT109021' => 'Monte Rinaldo',
		'IT109022' => 'Monterubbiano',
		'IT109023' => 'Monte San Pietrangeli',
		'IT109024' => 'Monte Urano',
		'IT109025' => 'Monte Vidon Combatte',
		'IT109026' => 'Monte Vidon Corrado',
		'IT109027' => 'Montottone',
		'IT109028' => 'Moresco',
		'IT109029' => 'Ortezzano',
		'IT109030' => 'Pedaso',
		'IT109031' => 'Petritoli',
		'IT109032' => 'Ponzano di Fermo',
		'IT109033' => 'Porto San Giorgio',
		'IT109034' => 'Porto SantElpidio',
		'IT109035' => 'Rapagnano',
		'IT109036' => 'Santa Vittoria in Matenano',
		'IT109037' => 'SantElpidio a Mare',
		'IT109038' => 'Servigliano',
		'IT109039' => 'Smerillo',
		'IT109040' => 'Torre San Patrizio',
	],
	'VT' => [
		'IT056001' => 'Acquapendente',
		'IT056002' => 'Arlena di Castro',
		'IT056003' => 'Bagnoregio',
		'IT056004' => 'Barbarano Romano',
		'IT056005' => 'Bassano Romano',
		'IT056006' => 'Bassano in Teverina',
		'IT056007' => 'Blera',
		'IT056008' => 'Bolsena',
		'IT056009' => 'Bomarzo',
		'IT056010' => 'Calcata',
		'IT056011' => 'Canepina',
		'IT056012' => 'Canino',
		'IT056013' => 'Capodimonte',
		'IT056014' => 'Capranica',
		'IT056015' => 'Caprarola',
		'IT056016' => 'Carbognano',
		'IT056017' => 'Castel SantElia',
		'IT056018' => 'Castiglione in Teverina',
		'IT056019' => 'Celleno',
		'IT056020' => 'Cellere',
		'IT056021' => 'Civita Castellana',
		'IT056022' => 'Civitella dAgliano',
		'IT056023' => 'Corchiano',
		'IT056024' => 'Fabrica di Roma',
		'IT056025' => 'Faleria',
		'IT056026' => 'Farnese',
		'IT056027' => 'Gallese',
		'IT056028' => 'Gradoli',
		'IT056029' => 'Graffignano',
		'IT056030' => 'Grotte di Castro',
		'IT056031' => 'Ischia di Castro',
		'IT056032' => 'Latera',
		'IT056033' => 'Lubriano',
		'IT056034' => 'Marta',
		'IT056035' => 'Montalto di Castro',
		'IT056036' => 'Montefiascone',
		'IT056037' => 'Monte Romano',
		'IT056038' => 'Monterosi',
		'IT056039' => 'Nepi',
		'IT056040' => 'Onano',
		'IT056041' => 'Oriolo Romano',
		'IT056042' => 'Orte',
		'IT056043' => 'Piansano',
		'IT056044' => 'Proceno',
		'IT056045' => 'Ronciglione',
		'IT056046' => 'Villa San Giovanni in Tuscia',
		'IT056047' => 'San Lorenzo Nuovo',
		'IT056048' => 'Soriano nel Cimino',
		'IT056049' => 'Sutri',
		'IT056050' => 'Tarquinia',
		'IT056051' => 'Tessennano',
		'IT056052' => 'Tuscania',
		'IT056053' => 'Valentano',
		'IT056054' => 'Vallerano',
		'IT056055' => 'Vasanello',
		'IT056056' => 'Vejano',
		'IT056057' => 'Vetralla',
		'IT056058' => 'Vignanello',
		'IT056059' => 'Viterbo',
		'IT056060' => 'Vitorchiano',
	],
	'RM' => [
		'IT058001' => 'Affile',
		'IT058002' => 'Agosta',
		'IT058003' => 'Albano Laziale',
		'IT058004' => 'Allumiere',
		'IT058005' => 'Anguillara Sabazia',
		'IT058006' => 'Anticoli Corrado',
		'IT058007' => 'Anzio',
		'IT058008' => 'Arcinazzo Romano',
		'IT058009' => 'Ariccia',
		'IT058010' => 'Arsoli',
		'IT058011' => 'Artena',
		'IT058012' => 'Bellegra',
		'IT058013' => 'Bracciano',
		'IT058014' => 'Camerata Nuova',
		'IT058015' => 'Campagnano di Roma',
		'IT058016' => 'Canale Monterano',
		'IT058017' => 'Canterano',
		'IT058018' => 'Capena',
		'IT058019' => 'Capranica Prenestina',
		'IT058020' => 'Carpineto Romano',
		'IT058021' => 'Casape',
		'IT058022' => 'Castel Gandolfo',
		'IT058023' => 'Castel Madama',
		'IT058024' => 'Castelnuovo di Porto',
		'IT058025' => 'Castel San Pietro Romano',
		'IT058026' => 'Cave',
		'IT058027' => 'Cerreto Laziale',
		'IT058028' => 'Cervara di Roma',
		'IT058029' => 'Cerveteri',
		'IT058030' => 'Ciciliano',
		'IT058031' => 'Cineto Romano',
		'IT058032' => 'Civitavecchia',
		'IT058033' => 'Civitella San Paolo',
		'IT058034' => 'Colleferro',
		'IT058035' => 'Colonna',
		'IT058036' => 'Fiano Romano',
		'IT058037' => 'Filacciano',
		'IT058038' => 'Formello',
		'IT058039' => 'Frascati',
		'IT058040' => 'Gallicano nel Lazio',
		'IT058041' => 'Gavignano',
		'IT058042' => 'Genazzano',
		'IT058043' => 'Genzano di Roma',
		'IT058044' => 'Gerano',
		'IT058045' => 'Gorga',
		'IT058046' => 'Grottaferrata',
		'IT058047' => 'Guidonia Montecelio',
		'IT058048' => 'Jenne',
		'IT058049' => 'Labico',
		'IT058050' => 'Lanuvio',
		'IT058051' => 'Licenza',
		'IT058052' => 'Magliano Romano',
		'IT058053' => 'Mandela',
		'IT058054' => 'Manziana',
		'IT058055' => 'Marano Equo',
		'IT058056' => 'Marcellina',
		'IT058057' => 'Marino',
		'IT058058' => 'Mazzano Romano',
		'IT058059' => 'Mentana',
		'IT058060' => 'Monte Compatri',
		'IT058061' => 'Monteflavio',
		'IT058062' => 'Montelanico',
		'IT058063' => 'Montelibretti',
		'IT058064' => 'Monte Porzio Catone',
		'IT058065' => 'Monterotondo',
		'IT058066' => 'Montorio Romano',
		'IT058067' => 'Moricone',
		'IT058068' => 'Morlupo',
		'IT058069' => 'Nazzano',
		'IT058070' => 'Nemi',
		'IT058071' => 'Nerola',
		'IT058072' => 'Nettuno',
		'IT058073' => 'Olevano Romano',
		'IT058074' => 'Palestrina',
		'IT058075' => 'Palombara Sabina',
		'IT058076' => 'Percile',
		'IT058077' => 'Pisoniano',
		'IT058078' => 'Poli',
		'IT058079' => 'Pomezia',
		'IT058080' => 'Ponzano Romano',
		'IT058081' => 'Riano',
		'IT058082' => 'Rignano Flaminio',
		'IT058083' => 'Riofreddo',
		'IT058084' => 'Rocca Canterano',
		'IT058085' => 'Rocca di Cave',
		'IT058086' => 'Rocca di Papa',
		'IT058087' => 'Roccagiovine',
		'IT058088' => 'Rocca Priora',
		'IT058089' => 'Rocca Santo Stefano',
		'IT058090' => 'Roiate',
		'IT058091' => 'Roma',
		'IT058092' => 'Roviano',
		'IT058093' => 'Sacrofano',
		'IT058094' => 'Sambuci',
		'IT058095' => 'San Gregorio da Sassola',
		'IT058096' => 'San Polo dei Cavalieri',
		'IT058097' => 'Santa Marinella',
		'IT058098' => 'SantAngelo Romano',
		'IT058099' => 'SantOreste',
		'IT058100' => 'San Vito Romano',
		'IT058101' => 'Saracinesco',
		'IT058102' => 'Segni',
		'IT058103' => 'Subiaco',
		'IT058104' => 'Tivoli',
		'IT058105' => 'Tolfa',
		'IT058106' => 'Torrita Tiberina',
		'IT058107' => 'Trevignano Romano',
		'IT058108' => 'Vallepietra',
		'IT058109' => 'Vallinfreda',
		'IT058110' => 'Valmontone',
		'IT058111' => 'Velletri',
		'IT058112' => 'Vicovaro',
		'IT058113' => 'Vivaro Romano',
		'IT058114' => 'Zagarolo',
		'IT058115' => 'Lariano',
		'IT058116' => 'Ladispoli',
		'IT058117' => 'Ardea',
		'IT058118' => 'Ciampino',
		'IT058119' => 'San Cesareo',
		'IT058120' => 'Fiumicino',
		'IT058122' => 'Fonte Nuova',
	],
	'LT' => [
		'IT059001' => 'Aprilia',
		'IT059002' => 'Bassiano',
		'IT059003' => 'Campodimele',
		'IT059004' => 'Castelforte',
		'IT059005' => 'Cisterna di Latina',
		'IT059006' => 'Cori',
		'IT059007' => 'Fondi',
		'IT059008' => 'Formia',
		'IT059009' => 'Gaeta',
		'IT059010' => 'Itri',
		'IT059011' => 'Latina',
		'IT059012' => 'Lenola',
		'IT059013' => 'Maenza',
		'IT059014' => 'Minturno',
		'IT059015' => 'Monte San Biagio',
		'IT059016' => 'Norma',
		'IT059017' => 'Pontinia',
		'IT059018' => 'Ponza',
		'IT059019' => 'Priverno',
		'IT059020' => 'Prossedi',
		'IT059021' => 'Roccagorga',
		'IT059022' => 'Rocca Massima',
		'IT059023' => 'Roccasecca dei Volsci',
		'IT059024' => 'Sabaudia',
		'IT059025' => 'San Felice Circeo',
		'IT059026' => 'Santi Cosma e Damiano',
		'IT059027' => 'Sermoneta',
		'IT059028' => 'Sezze',
		'IT059029' => 'Sonnino',
		'IT059030' => 'Sperlonga',
		'IT059031' => 'Spigno Saturnia',
		'IT059032' => 'Terracina',
		'IT059033' => 'Ventotene',
	],
	'FR' => [
		'IT060001' => 'Acquafondata',
		'IT060002' => 'Acuto',
		'IT060003' => 'Alatri',
		'IT060004' => 'Alvito',
		'IT060005' => 'Amaseno',
		'IT060006' => 'Anagni',
		'IT060007' => 'Aquino',
		'IT060008' => 'Arce',
		'IT060009' => 'Arnara',
		'IT060010' => 'Arpino',
		'IT060011' => 'Atina',
		'IT060012' => 'Ausonia',
		'IT060013' => 'Belmonte Castello',
		'IT060014' => 'Boville Ernica',
		'IT060015' => 'Broccostella',
		'IT060016' => 'Campoli Appennino',
		'IT060017' => 'Casalattico',
		'IT060018' => 'Casalvieri',
		'IT060019' => 'Cassino',
		'IT060020' => 'Castelliri',
		'IT060021' => 'Castelnuovo Parano',
		'IT060022' => 'Castrocielo',
		'IT060023' => 'Castro dei Volsci',
		'IT060024' => 'Ceccano',
		'IT060025' => 'Ceprano',
		'IT060026' => 'Cervaro',
		'IT060027' => 'Colfelice',
		'IT060028' => 'Collepardo',
		'IT060029' => 'Colle San Magno',
		'IT060030' => 'Coreno Ausonio',
		'IT060031' => 'Esperia',
		'IT060032' => 'Falvaterra',
		'IT060033' => 'Ferentino',
		'IT060034' => 'Filettino',
		'IT060035' => 'Fiuggi',
		'IT060036' => 'Fontana Liri',
		'IT060037' => 'Fontechiari',
		'IT060038' => 'Frosinone',
		'IT060039' => 'Fumone',
		'IT060040' => 'Gallinaro',
		'IT060041' => 'Giuliano di Roma',
		'IT060042' => 'Guarcino',
		'IT060043' => 'Isola del Liri',
		'IT060044' => 'Monte San Giovanni Campano',
		'IT060045' => 'Morolo',
		'IT060046' => 'Paliano',
		'IT060047' => 'Pastena',
		'IT060048' => 'Patrica',
		'IT060049' => 'Pescosolido',
		'IT060050' => 'Picinisco',
		'IT060051' => 'Pico',
		'IT060052' => 'Piedimonte San Germano',
		'IT060053' => 'Piglio',
		'IT060054' => 'Pignataro Interamna',
		'IT060055' => 'Pofi',
		'IT060056' => 'Pontecorvo',
		'IT060057' => 'Posta Fibreno',
		'IT060058' => 'Ripi',
		'IT060059' => 'Rocca dArce',
		'IT060060' => 'Roccasecca',
		'IT060061' => 'San Biagio Saracinisco',
		'IT060062' => 'San Donato Val di Comino',
		'IT060063' => 'San Giorgio a Liri',
		'IT060064' => 'San Giovanni Incarico',
		'IT060065' => 'SantAmbrogio sul Garigliano',
		'IT060066' => 'SantAndrea del Garigliano',
		'IT060067' => 'SantApollinare',
		'IT060068' => 'SantElia Fiumerapido',
		'IT060069' => 'Santopadre',
		'IT060070' => 'San Vittore del Lazio',
		'IT060071' => 'Serrone',
		'IT060072' => 'Settefrati',
		'IT060073' => 'Sgurgola',
		'IT060074' => 'Sora',
		'IT060075' => 'Strangolagalli',
		'IT060076' => 'Supino',
		'IT060077' => 'Terelle',
		'IT060078' => 'Torre Cajetani',
		'IT060079' => 'Torrice',
		'IT060080' => 'Trevi nel Lazio',
		'IT060081' => 'Trivigliano',
		'IT060082' => 'Vallecorsa',
		'IT060083' => 'Vallemaio',
		'IT060084' => 'Vallerotonda',
		'IT060085' => 'Veroli',
		'IT060086' => 'Vicalvi',
		'IT060087' => 'Vico nel Lazio',
		'IT060088' => 'Villa Latina',
		'IT060089' => 'Villa Santa Lucia',
		'IT060090' => 'Villa Santo Stefano',
		'IT060091' => 'Viticuso',
	],
	'AQ' => [
		'IT066001' => 'Acciano',
		'IT066002' => 'Aielli',
		'IT066003' => 'Alfedena',
		'IT066004' => 'Anversa degli Abruzzi',
		'IT066005' => 'Ateleta',
		'IT066006' => 'Avezzano',
		'IT066007' => 'Balsorano',
		'IT066008' => 'Barete',
		'IT066009' => 'Barisciano',
		'IT066010' => 'Barrea',
		'IT066011' => 'Bisegna',
		'IT066012' => 'Bugnara',
		'IT066013' => 'Cagnano Amiterno',
		'IT066014' => 'Calascio',
		'IT066015' => 'Campo di Giove',
		'IT066016' => 'Campotosto',
		'IT066017' => 'Canistro',
		'IT066018' => 'Cansano',
		'IT066019' => 'Capestrano',
		'IT066020' => 'Capistrello',
		'IT066021' => 'Capitignano',
		'IT066022' => 'Caporciano',
		'IT066023' => 'Cappadocia',
		'IT066024' => 'Carapelle Calvisio',
		'IT066025' => 'Carsoli',
		'IT066026' => 'Castel del Monte',
		'IT066027' => 'Castel di Ieri',
		'IT066028' => 'Castel di Sangro',
		'IT066029' => 'Castellafiume',
		'IT066030' => 'Castelvecchio Calvisio',
		'IT066031' => 'Castelvecchio Subequo',
		'IT066032' => 'Celano',
		'IT066033' => 'Cerchio',
		'IT066034' => 'Civita dAntino',
		'IT066035' => 'Civitella Alfedena',
		'IT066036' => 'Civitella Roveto',
		'IT066037' => 'Cocullo',
		'IT066038' => 'Collarmele',
		'IT066039' => 'Collelongo',
		'IT066040' => 'Collepietro',
		'IT066041' => 'Corfinio',
		'IT066042' => 'Fagnano Alto',
		'IT066043' => 'Fontecchio',
		'IT066044' => 'Fossa',
		'IT066045' => 'Gagliano Aterno',
		'IT066046' => 'Gioia dei Marsi',
		'IT066047' => 'Goriano Sicoli',
		'IT066048' => 'Introdacqua',
		'IT066049' => 'LAquila',
		'IT066050' => 'Lecce nei Marsi',
		'IT066051' => 'Luco dei Marsi',
		'IT066052' => 'Lucoli',
		'IT066053' => 'Magliano de Marsi',
		'IT066054' => 'Massa dAlbe',
		'IT066055' => 'Molina Aterno',
		'IT066056' => 'Montereale',
		'IT066057' => 'Morino',
		'IT066058' => 'Navelli',
		'IT066059' => 'Ocre',
		'IT066060' => 'Ofena',
		'IT066061' => 'Opi',
		'IT066062' => 'Oricola',
		'IT066063' => 'Ortona dei Marsi',
		'IT066064' => 'Ortucchio',
		'IT066065' => 'Ovindoli',
		'IT066066' => 'Pacentro',
		'IT066067' => 'Pereto',
		'IT066068' => 'Pescasseroli',
		'IT066069' => 'Pescina',
		'IT066070' => 'Pescocostanzo',
		'IT066071' => 'Pettorano sul Gizio',
		'IT066072' => 'Pizzoli',
		'IT066073' => 'Poggio Picenze',
		'IT066074' => 'Prata dAnsidonia',
		'IT066075' => 'Pratola Peligna',
		'IT066076' => 'Prezza',
		'IT066077' => 'Raiano',
		'IT066078' => 'Rivisondoli',
		'IT066079' => 'Roccacasale',
		'IT066080' => 'Rocca di Botte',
		'IT066081' => 'Rocca di Cambio',
		'IT066082' => 'Rocca di Mezzo',
		'IT066083' => 'Rocca Pia',
		'IT066084' => 'Roccaraso',
		'IT066085' => 'San Benedetto dei Marsi',
		'IT066086' => 'San Benedetto in Perillis',
		'IT066087' => 'San Demetrio ne Vestini',
		'IT066088' => 'San Pio delle Camere',
		'IT066089' => 'Sante Marie',
		'IT066090' => 'SantEusanio Forconese',
		'IT066091' => 'Santo Stefano di Sessanio',
		'IT066092' => 'San Vincenzo Valle Roveto',
		'IT066093' => 'Scanno',
		'IT066094' => 'Scontrone',
		'IT066095' => 'Scoppito',
		'IT066096' => 'Scurcola Marsicana',
		'IT066097' => 'Secinaro',
		'IT066098' => 'Sulmona',
		'IT066099' => 'Tagliacozzo',
		'IT066100' => 'Tione degli Abruzzi',
		'IT066101' => 'Tornimparte',
		'IT066102' => 'Trasacco',
		'IT066103' => 'Villalago',
		'IT066104' => 'Villa Santa Lucia degli Abruzzi',
		'IT066105' => 'Villa SantAngelo',
		'IT066106' => 'Villavallelonga',
		'IT066107' => 'Villetta Barrea',
		'IT066108' => 'Vittorito',
	],
	'TE' => [
		'IT067001' => 'Alba Adriatica',
		'IT067002' => 'Ancarano',
		'IT067003' => 'Arsita',
		'IT067004' => 'Atri',
		'IT067005' => 'Basciano',
		'IT067006' => 'Bellante',
		'IT067007' => 'Bisenti',
		'IT067008' => 'Campli',
		'IT067009' => 'Canzano',
		'IT067010' => 'Castel Castagna',
		'IT067011' => 'Castellalto',
		'IT067012' => 'Castelli',
		'IT067013' => 'Castiglione Messer Raimondo',
		'IT067014' => 'Castilenti',
		'IT067015' => 'Cellino Attanasio',
		'IT067016' => 'Cermignano',
		'IT067017' => 'Civitella del Tronto',
		'IT067018' => 'Colledara',
		'IT067019' => 'Colonnella',
		'IT067020' => 'Controguerra',
		'IT067021' => 'Corropoli',
		'IT067022' => 'Cortino',
		'IT067023' => 'Crognaleto',
		'IT067024' => 'Fano Adriano',
		'IT067025' => 'Giulianova',
		'IT067026' => 'Isola del Gran Sasso dItalia',
		'IT067027' => 'Montefino',
		'IT067028' => 'Montorio al Vomano',
		'IT067029' => 'Morro dOro',
		'IT067030' => 'Mosciano SantAngelo',
		'IT067031' => 'Nereto',
		'IT067032' => 'Notaresco',
		'IT067033' => 'Penna SantAndrea',
		'IT067034' => 'Pietracamela',
		'IT067035' => 'Pineto',
		'IT067036' => 'Rocca Santa Maria',
		'IT067037' => 'Roseto degli Abruzzi',
		'IT067038' => 'SantEgidio alla Vibrata',
		'IT067039' => 'SantOmero',
		'IT067040' => 'Silvi',
		'IT067041' => 'Teramo',
		'IT067042' => 'Torano Nuovo',
		'IT067043' => 'Torricella Sicura',
		'IT067044' => 'Tortoreto',
		'IT067045' => 'Tossicia',
		'IT067046' => 'Valle Castellana',
		'IT067047' => 'Martinsicuro',
	],
	'PE' => [
		'IT068001' => 'Abbateggio',
		'IT068002' => 'Alanno',
		'IT068003' => 'Bolognano',
		'IT068004' => 'Brittoli',
		'IT068005' => 'Bussi sul Tirino',
		'IT068006' => 'Cappelle sul Tavo',
		'IT068007' => 'Caramanico Terme',
		'IT068008' => 'Carpineto della Nora',
		'IT068009' => 'Castiglione a Casauria',
		'IT068010' => 'Catignano',
		'IT068011' => 'Cepagatti',
		'IT068012' => 'Città SantAngelo',
		'IT068013' => 'Civitaquana',
		'IT068014' => 'Civitella Casanova',
		'IT068015' => 'Collecorvino',
		'IT068016' => 'Corvara',
		'IT068017' => 'Cugnoli',
		'IT068018' => 'Elice',
		'IT068019' => 'Farindola',
		'IT068020' => 'Lettomanoppello',
		'IT068021' => 'Loreto Aprutino',
		'IT068022' => 'Manoppello',
		'IT068023' => 'Montebello di Bertona',
		'IT068024' => 'Montesilvano',
		'IT068025' => 'Moscufo',
		'IT068026' => 'Nocciano',
		'IT068027' => 'Penne',
		'IT068028' => 'Pescara',
		'IT068029' => 'Pescosansonesco',
		'IT068030' => 'Pianella',
		'IT068031' => 'Picciano',
		'IT068032' => 'Pietranico',
		'IT068033' => 'Popoli',
		'IT068034' => 'Roccamorice',
		'IT068035' => 'Rosciano',
		'IT068036' => 'Salle',
		'IT068037' => 'SantEufemia a Maiella',
		'IT068038' => 'San Valentino in Abruzzo Citeriore',
		'IT068039' => 'Scafa',
		'IT068040' => 'Serramonacesca',
		'IT068041' => 'Spoltore',
		'IT068042' => 'Tocco da Casauria',
		'IT068043' => 'Torre de Passeri',
		'IT068044' => 'Turrivalignani',
		'IT068045' => 'Vicoli',
		'IT068046' => 'Villa Celiera',
	],
	'CH' => [
		'IT069001' => 'Altino',
		'IT069002' => 'Archi',
		'IT069003' => 'Ari',
		'IT069004' => 'Arielli',
		'IT069005' => 'Atessa',
		'IT069006' => 'Bomba',
		'IT069007' => 'Borrello',
		'IT069008' => 'Bucchianico',
		'IT069009' => 'Montebello sul Sangro',
		'IT069010' => 'Canosa Sannita',
		'IT069011' => 'Carpineto Sinello',
		'IT069012' => 'Carunchio',
		'IT069013' => 'Casacanditella',
		'IT069014' => 'Casalanguida',
		'IT069015' => 'Casalbordino',
		'IT069016' => 'Casalincontrada',
		'IT069017' => 'Casoli',
		'IT069018' => 'Castel Frentano',
		'IT069019' => 'Castelguidone',
		'IT069020' => 'Castiglione Messer Marino',
		'IT069021' => 'Celenza sul Trigno',
		'IT069022' => 'Chieti',
		'IT069023' => 'Civitaluparella',
		'IT069024' => 'Civitella Messer Raimondo',
		'IT069025' => 'Colledimacine',
		'IT069026' => 'Colledimezzo',
		'IT069027' => 'Crecchio',
		'IT069028' => 'Cupello',
		'IT069029' => 'Dogliola',
		'IT069030' => 'Fara Filiorum Petri',
		'IT069031' => 'Fara San Martino',
		'IT069032' => 'Filetto',
		'IT069033' => 'Fossacesia',
		'IT069034' => 'Fraine',
		'IT069035' => 'Francavilla al Mare',
		'IT069036' => 'Fresagrandinaria',
		'IT069037' => 'Frisa',
		'IT069038' => 'Furci',
		'IT069039' => 'Gamberale',
		'IT069040' => 'Gessopalena',
		'IT069041' => 'Gissi',
		'IT069042' => 'Giuliano Teatino',
		'IT069043' => 'Guardiagrele',
		'IT069044' => 'Guilmi',
		'IT069045' => 'Lama dei Peligni',
		'IT069046' => 'Lanciano',
		'IT069047' => 'Lentella',
		'IT069048' => 'Lettopalena',
		'IT069049' => 'Liscia',
		'IT069050' => 'Miglianico',
		'IT069051' => 'Montazzoli',
		'IT069052' => 'Monteferrante',
		'IT069053' => 'Montelapiano',
		'IT069054' => 'Montenerodomo',
		'IT069055' => 'Monteodorisio',
		'IT069056' => 'Mozzagrogna',
		'IT069057' => 'Orsogna',
		'IT069058' => 'Ortona',
		'IT069059' => 'Paglieta',
		'IT069060' => 'Palena',
		'IT069061' => 'Palmoli',
		'IT069062' => 'Palombaro',
		'IT069063' => 'Pennadomo',
		'IT069064' => 'Pennapiedimonte',
		'IT069065' => 'Perano',
		'IT069066' => 'Pizzoferrato',
		'IT069067' => 'Poggiofiorito',
		'IT069068' => 'Pollutri',
		'IT069069' => 'Pretoro',
		'IT069070' => 'Quadri',
		'IT069071' => 'Rapino',
		'IT069072' => 'Ripa Teatina',
		'IT069073' => 'Roccamontepiano',
		'IT069074' => 'Rocca San Giovanni',
		'IT069075' => 'Roccascalegna',
		'IT069076' => 'Roccaspinalveti',
		'IT069077' => 'Roio del Sangro',
		'IT069078' => 'Rosello',
		'IT069079' => 'San Buono',
		'IT069080' => 'San Giovanni Lipioni',
		'IT069081' => 'San Giovanni Teatino',
		'IT069082' => 'San Martino sulla Marrucina',
		'IT069083' => 'San Salvo',
		'IT069084' => 'Santa Maria Imbaro',
		'IT069085' => 'SantEusanio del Sangro',
		'IT069086' => 'San Vito Chietino',
		'IT069087' => 'Scerni',
		'IT069088' => 'Schiavi di Abruzzo',
		'IT069089' => 'Taranta Peligna',
		'IT069090' => 'Tollo',
		'IT069091' => 'Torino di Sangro',
		'IT069092' => 'Tornareccio',
		'IT069093' => 'Torrebruna',
		'IT069094' => 'Torrevecchia Teatina',
		'IT069095' => 'Torricella Peligna',
		'IT069096' => 'Treglio',
		'IT069097' => 'Tufillo',
		'IT069098' => 'Vacri',
		'IT069099' => 'Vasto',
		'IT069100' => 'Villalfonsina',
		'IT069101' => 'Villamagna',
		'IT069102' => 'Villa Santa Maria',
		'IT069103' => 'Pietraferrazzana',
		'IT069104' => 'Fallo',
	],
	'CB' => [
		'IT070001' => 'Acquaviva Collecroce',
		'IT070002' => 'Baranello',
		'IT070003' => 'Bojano',
		'IT070004' => 'Bonefro',
		'IT070005' => 'Busso',
		'IT070006' => 'Campobasso',
		'IT070007' => 'Campochiaro',
		'IT070008' => 'Campodipietra',
		'IT070009' => 'Campolieto',
		'IT070010' => 'Campomarino',
		'IT070011' => 'Casacalenda',
		'IT070012' => 'Casalciprano',
		'IT070013' => 'Castelbottaccio',
		'IT070014' => 'Castellino del Biferno',
		'IT070015' => 'Castelmauro',
		'IT070016' => 'Castropignano',
		'IT070017' => 'Cercemaggiore',
		'IT070018' => 'Cercepiccola',
		'IT070019' => 'Civitacampomarano',
		'IT070020' => 'Colle dAnchise',
		'IT070021' => 'Colletorto',
		'IT070022' => 'Duronia',
		'IT070023' => 'Ferrazzano',
		'IT070024' => 'Fossalto',
		'IT070025' => 'Gambatesa',
		'IT070026' => 'Gildone',
		'IT070027' => 'Guardialfiera',
		'IT070028' => 'Guardiaregia',
		'IT070029' => 'Guglionesi',
		'IT070030' => 'Jelsi',
		'IT070031' => 'Larino',
		'IT070032' => 'Limosano',
		'IT070033' => 'Lucito',
		'IT070034' => 'Lupara',
		'IT070035' => 'Macchia Valfortore',
		'IT070036' => 'Mafalda',
		'IT070037' => 'Matrice',
		'IT070038' => 'Mirabello Sannitico',
		'IT070039' => 'Molise',
		'IT070040' => 'Monacilioni',
		'IT070041' => 'Montagano',
		'IT070042' => 'Montecilfone',
		'IT070043' => 'Montefalcone nel Sannio',
		'IT070044' => 'Montelongo',
		'IT070045' => 'Montemitro',
		'IT070046' => 'Montenero di Bisaccia',
		'IT070047' => 'Montorio nei Frentani',
		'IT070048' => 'Morrone del Sannio',
		'IT070049' => 'Oratino',
		'IT070050' => 'Palata',
		'IT070051' => 'Petacciato',
		'IT070052' => 'Petrella Tifernina',
		'IT070053' => 'Pietracatella',
		'IT070054' => 'Pietracupa',
		'IT070055' => 'Portocannone',
		'IT070056' => 'Provvidenti',
		'IT070057' => 'Riccia',
		'IT070058' => 'Ripabottoni',
		'IT070059' => 'Ripalimosani',
		'IT070060' => 'Roccavivara',
		'IT070061' => 'Rotello',
		'IT070062' => 'Salcito',
		'IT070063' => 'San Biase',
		'IT070064' => 'San Felice del Molise',
		'IT070065' => 'San Giacomo degli Schiavoni',
		'IT070066' => 'San Giovanni in Galdo',
		'IT070067' => 'San Giuliano del Sannio',
		'IT070068' => 'San Giuliano di Puglia',
		'IT070069' => 'San Martino in Pensilis',
		'IT070070' => 'San Massimo',
		'IT070071' => 'San Polo Matese',
		'IT070072' => 'Santa Croce di Magliano',
		'IT070073' => 'SantAngelo Limosano',
		'IT070074' => 'SantElia a Pianisi',
		'IT070075' => 'Sepino',
		'IT070076' => 'Spinete',
		'IT070077' => 'Tavenna',
		'IT070078' => 'Termoli',
		'IT070079' => 'Torella del Sannio',
		'IT070080' => 'Toro',
		'IT070081' => 'Trivento',
		'IT070082' => 'Tufara',
		'IT070083' => 'Ururi',
		'IT070084' => 'Vinchiaturo',
	],
	'IS' => [
		'IT094001' => 'Acquaviva dIsernia',
		'IT094002' => 'Agnone',
		'IT094003' => 'Bagnoli del Trigno',
		'IT094004' => 'Belmonte del Sannio',
		'IT094005' => 'Cantalupo nel Sannio',
		'IT094006' => 'Capracotta',
		'IT094007' => 'Carovilli',
		'IT094008' => 'Carpinone',
		'IT094009' => 'Castel del Giudice',
		'IT094010' => 'Castelpetroso',
		'IT094011' => 'Castelpizzuto',
		'IT094012' => 'Castel San Vincenzo',
		'IT094013' => 'Castelverrino',
		'IT094014' => 'Cerro al Volturno',
		'IT094015' => 'Chiauci',
		'IT094016' => 'Civitanova del Sannio',
		'IT094017' => 'Colli a Volturno',
		'IT094018' => 'Conca Casale',
		'IT094019' => 'Filignano',
		'IT094020' => 'Forlì del Sannio',
		'IT094021' => 'Fornelli',
		'IT094022' => 'Frosolone',
		'IT094023' => 'Isernia',
		'IT094024' => 'Longano',
		'IT094025' => 'Macchia dIsernia',
		'IT094026' => 'Macchiagodena',
		'IT094027' => 'Miranda',
		'IT094028' => 'Montaquila',
		'IT094029' => 'Montenero Val Cocchiara',
		'IT094030' => 'Monteroduni',
		'IT094031' => 'Pesche',
		'IT094032' => 'Pescolanciano',
		'IT094033' => 'Pescopennataro',
		'IT094034' => 'Pettoranello del Molise',
		'IT094035' => 'Pietrabbondante',
		'IT094036' => 'Pizzone',
		'IT094037' => 'Poggio Sannita',
		'IT094038' => 'Pozzilli',
		'IT094039' => 'Rionero Sannitico',
		'IT094040' => 'Roccamandolfi',
		'IT094041' => 'Roccasicura',
		'IT094042' => 'Rocchetta a Volturno',
		'IT094043' => 'San Pietro Avellana',
		'IT094044' => 'SantAgapito',
		'IT094045' => 'Santa Maria del Molise',
		'IT094046' => 'SantAngelo del Pesco',
		'IT094047' => 'SantElena Sannita',
		'IT094048' => 'Scapoli',
		'IT094049' => 'Sessano del Molise',
		'IT094050' => 'Sesto Campano',
		'IT094051' => 'Vastogirardi',
		'IT094052' => 'Venafro',
	],
	'CE' => [
		'IT061001' => 'Ailano',
		'IT061002' => 'Alife',
		'IT061003' => 'Alvignano',
		'IT061004' => 'Arienzo',
		'IT061005' => 'Aversa',
		'IT061006' => 'Baia e Latina',
		'IT061007' => 'Bellona',
		'IT061008' => 'Caianello',
		'IT061009' => 'Caiazzo',
		'IT061010' => 'Calvi Risorta',
		'IT061011' => 'Camigliano',
		'IT061012' => 'Cancello ed Arnone',
		'IT061013' => 'Capodrise',
		'IT061014' => 'Capriati a Volturno',
		'IT061015' => 'Capua',
		'IT061016' => 'Carinaro',
		'IT061017' => 'Carinola',
		'IT061018' => 'Casagiove',
		'IT061019' => 'Casal di Principe',
		'IT061020' => 'Casaluce',
		'IT061021' => 'Casapulla',
		'IT061022' => 'Caserta',
		'IT061023' => 'Castel Campagnano',
		'IT061024' => 'Castel di Sasso',
		'IT061025' => 'Castello del Matese',
		'IT061026' => 'Castel Morrone',
		'IT061027' => 'Castel Volturno',
		'IT061028' => 'Cervino',
		'IT061029' => 'Cesa',
		'IT061030' => 'Ciorlano',
		'IT061031' => 'Conca della Campania',
		'IT061032' => 'Curti',
		'IT061033' => 'Dragoni',
		'IT061034' => 'Fontegreca',
		'IT061035' => 'Formicola',
		'IT061036' => 'Francolise',
		'IT061037' => 'Frignano',
		'IT061038' => 'Gallo Matese',
		'IT061039' => 'Galluccio',
		'IT061040' => 'Giano Vetusto',
		'IT061041' => 'Gioia Sannitica',
		'IT061042' => 'Grazzanise',
		'IT061043' => 'Gricignano di Aversa',
		'IT061044' => 'Letino',
		'IT061045' => 'Liberi',
		'IT061046' => 'Lusciano',
		'IT061047' => 'Macerata Campania',
		'IT061048' => 'Maddaloni',
		'IT061049' => 'Marcianise',
		'IT061050' => 'Marzano Appio',
		'IT061051' => 'Mignano Monte Lungo',
		'IT061052' => 'Mondragone',
		'IT061053' => 'Orta di Atella',
		'IT061054' => 'Parete',
		'IT061055' => 'Pastorano',
		'IT061056' => 'Piana di Monte Verna',
		'IT061057' => 'Piedimonte Matese',
		'IT061058' => 'Pietramelara',
		'IT061059' => 'Pietravairano',
		'IT061060' => 'Pignataro Maggiore',
		'IT061061' => 'Pontelatone',
		'IT061062' => 'Portico di Caserta',
		'IT061063' => 'Prata Sannita',
		'IT061064' => 'Pratella',
		'IT061065' => 'Presenzano',
		'IT061066' => 'Raviscanina',
		'IT061067' => 'Recale',
		'IT061068' => 'Riardo',
		'IT061069' => 'Rocca dEvandro',
		'IT061070' => 'Roccamonfina',
		'IT061071' => 'Roccaromana',
		'IT061072' => 'Rocchetta e Croce',
		'IT061073' => 'Ruviano',
		'IT061074' => 'San Cipriano dAversa',
		'IT061075' => 'San Felice a Cancello',
		'IT061076' => 'San Gregorio Matese',
		'IT061077' => 'San Marcellino',
		'IT061078' => 'San Nicola la Strada',
		'IT061079' => 'San Pietro Infine',
		'IT061080' => 'San Potito Sannitico',
		'IT061081' => 'San Prisco',
		'IT061082' => 'Santa Maria a Vico',
		'IT061083' => 'Santa Maria Capua Vetere',
		'IT061084' => 'Santa Maria la Fossa',
		'IT061085' => 'San Tammaro',
		'IT061086' => 'SantAngelo dAlife',
		'IT061087' => 'SantArpino',
		'IT061088' => 'Sessa Aurunca',
		'IT061089' => 'Sparanise',
		'IT061090' => 'Succivo',
		'IT061091' => 'Teano',
		'IT061092' => 'Teverola',
		'IT061093' => 'Tora e Piccilli',
		'IT061094' => 'Trentola Ducenta',
		'IT061095' => 'Vairano Patenora',
		'IT061096' => 'Valle Agricola',
		'IT061097' => 'Valle di Maddaloni',
		'IT061098' => 'Villa di Briano',
		'IT061099' => 'Villa Literno',
		'IT061100' => 'Vitulazio',
		'IT061101' => 'Falciano del Massico',
		'IT061102' => 'Cellole',
		'IT061103' => 'Casapesenna',
		'IT061104' => 'San Marco Evangelista',
	],
	'BN' => [
		'IT062001' => 'Airola',
		'IT062002' => 'Amorosi',
		'IT062003' => 'Apice',
		'IT062004' => 'Apollosa',
		'IT062005' => 'Arpaia',
		'IT062006' => 'Arpaise',
		'IT062007' => 'Baselice',
		'IT062008' => 'Benevento',
		'IT062009' => 'Bonea',
		'IT062010' => 'Bucciano',
		'IT062011' => 'Buonalbergo',
		'IT062012' => 'Calvi',
		'IT062013' => 'Campolattaro',
		'IT062014' => 'Campoli del Monte Taburno',
		'IT062015' => 'Casalduni',
		'IT062016' => 'Castelfranco in Miscano',
		'IT062017' => 'Castelpagano',
		'IT062018' => 'Castelpoto',
		'IT062019' => 'Castelvenere',
		'IT062020' => 'Castelvetere in Val Fortore',
		'IT062021' => 'Cautano',
		'IT062022' => 'Ceppaloni',
		'IT062023' => 'Cerreto Sannita',
		'IT062024' => 'Circello',
		'IT062025' => 'Colle Sannita',
		'IT062026' => 'Cusano Mutri',
		'IT062027' => 'Dugenta',
		'IT062028' => 'Durazzano',
		'IT062029' => 'Faicchio',
		'IT062030' => 'Foglianise',
		'IT062031' => 'Foiano di Val Fortore',
		'IT062032' => 'Forchia',
		'IT062033' => 'Fragneto lAbate',
		'IT062034' => 'Fragneto Monforte',
		'IT062035' => 'Frasso Telesino',
		'IT062036' => 'Ginestra degli Schiavoni',
		'IT062037' => 'Guardia Sanframondi',
		'IT062038' => 'Limatola',
		'IT062039' => 'Melizzano',
		'IT062040' => 'Moiano',
		'IT062041' => 'Molinara',
		'IT062042' => 'Montefalcone di Val Fortore',
		'IT062043' => 'Montesarchio',
		'IT062044' => 'Morcone',
		'IT062045' => 'Paduli',
		'IT062046' => 'Pago Veiano',
		'IT062047' => 'Pannarano',
		'IT062048' => 'Paolisi',
		'IT062049' => 'Paupisi',
		'IT062050' => 'Pesco Sannita',
		'IT062051' => 'Pietraroja',
		'IT062052' => 'Pietrelcina',
		'IT062053' => 'Ponte',
		'IT062054' => 'Pontelandolfo',
		'IT062055' => 'Puglianello',
		'IT062056' => 'Reino',
		'IT062057' => 'San Bartolomeo in Galdo',
		'IT062058' => 'San Giorgio del Sannio',
		'IT062059' => 'San Giorgio La Molara',
		'IT062060' => 'San Leucio del Sannio',
		'IT062061' => 'San Lorenzello',
		'IT062062' => 'San Lorenzo Maggiore',
		'IT062063' => 'San Lupo',
		'IT062064' => 'San Marco dei Cavoti',
		'IT062065' => 'San Martino Sannita',
		'IT062066' => 'San Nazzaro',
		'IT062067' => 'San Nicola Manfredi',
		'IT062068' => 'San Salvatore Telesino',
		'IT062069' => 'Santa Croce del Sannio',
		'IT062070' => 'SantAgata de Goti',
		'IT062071' => 'SantAngelo a Cupolo',
		'IT062072' => 'Sassinoro',
		'IT062073' => 'Solopaca',
		'IT062074' => 'Telese Terme',
		'IT062075' => 'Tocco Caudio',
		'IT062076' => 'Torrecuso',
		'IT062077' => 'Vitulano',
		'IT062078' => 'SantArcangelo Trimonte',
	],
	'NA' => [
		'IT063001' => 'Acerra',
		'IT063002' => 'Afragola',
		'IT063003' => 'Agerola',
		'IT063004' => 'Anacapri',
		'IT063005' => 'Arzano',
		'IT063006' => 'Bacoli',
		'IT063007' => 'Barano dIschia',
		'IT063008' => 'Boscoreale',
		'IT063009' => 'Boscotrecase',
		'IT063010' => 'Brusciano',
		'IT063011' => 'Caivano',
		'IT063012' => 'Calvizzano',
		'IT063013' => 'Camposano',
		'IT063014' => 'Capri',
		'IT063015' => 'Carbonara di Nola',
		'IT063016' => 'Cardito',
		'IT063017' => 'Casalnuovo di Napoli',
		'IT063018' => 'Casamarciano',
		'IT063019' => 'Casamicciola Terme',
		'IT063020' => 'Casandrino',
		'IT063021' => 'Casavatore',
		'IT063022' => 'Casola di Napoli',
		'IT063023' => 'Casoria',
		'IT063024' => 'Castellammare di Stabia',
		'IT063025' => 'Castello di Cisterna',
		'IT063026' => 'Cercola',
		'IT063027' => 'Cicciano',
		'IT063028' => 'Cimitile',
		'IT063029' => 'Comiziano',
		'IT063030' => 'Crispano',
		'IT063031' => 'Forio',
		'IT063032' => 'Frattamaggiore',
		'IT063033' => 'Frattaminore',
		'IT063034' => 'Giugliano in Campania',
		'IT063035' => 'Gragnano',
		'IT063036' => 'Grumo Nevano',
		'IT063037' => 'Ischia',
		'IT063038' => 'Lacco Ameno',
		'IT063039' => 'Lettere',
		'IT063040' => 'Liveri',
		'IT063041' => 'Marano di Napoli',
		'IT063042' => 'Mariglianella',
		'IT063043' => 'Marigliano',
		'IT063044' => 'Massa Lubrense',
		'IT063045' => 'Melito di Napoli',
		'IT063046' => 'Meta',
		'IT063047' => 'Monte di Procida',
		'IT063048' => 'Mugnano di Napoli',
		'IT063049' => 'Napoli',
		'IT063050' => 'Nola',
		'IT063051' => 'Ottaviano',
		'IT063052' => 'Palma Campania',
		'IT063053' => 'Piano di Sorrento',
		'IT063054' => 'Pimonte',
		'IT063055' => 'Poggiomarino',
		'IT063056' => 'Pollena Trocchia',
		'IT063057' => 'Pomigliano dArco',
		'IT063058' => 'Pompei',
		'IT063059' => 'Portici',
		'IT063060' => 'Pozzuoli',
		'IT063061' => 'Procida',
		'IT063062' => 'Qualiano',
		'IT063063' => 'Quarto',
		'IT063064' => 'Ercolano',
		'IT063065' => 'Roccarainola',
		'IT063066' => 'San Gennaro Vesuviano',
		'IT063067' => 'San Giorgio a Cremano',
		'IT063068' => 'San Giuseppe Vesuviano',
		'IT063069' => 'San Paolo Bel Sito',
		'IT063070' => 'San Sebastiano al Vesuvio',
		'IT063071' => 'SantAgnello',
		'IT063072' => 'SantAnastasia',
		'IT063073' => 'SantAntimo',
		'IT063074' => 'SantAntonio Abate',
		'IT063075' => 'San Vitaliano',
		'IT063076' => 'Saviano',
		'IT063077' => 'Scisciano',
		'IT063078' => 'Serrara Fontana',
		'IT063079' => 'Somma Vesuviana',
		'IT063080' => 'Sorrento',
		'IT063081' => 'Striano',
		'IT063082' => 'Terzigno',
		'IT063083' => 'Torre Annunziata',
		'IT063084' => 'Torre del Greco',
		'IT063085' => 'Tufino',
		'IT063086' => 'Vico Equense',
		'IT063087' => 'Villaricca',
		'IT063088' => 'Visciano',
		'IT063089' => 'Volla',
		'IT063090' => 'Santa Maria la Carità',
		'IT063091' => 'Trecase',
		'IT063092' => 'Massa di Somma',
	],
	'AV' => [
		'IT064001' => 'Aiello del Sabato',
		'IT064002' => 'Altavilla Irpina',
		'IT064003' => 'Andretta',
		'IT064004' => 'Aquilonia',
		'IT064005' => 'Ariano Irpino',
		'IT064006' => 'Atripalda',
		'IT064007' => 'Avella',
		'IT064008' => 'Avellino',
		'IT064009' => 'Bagnoli Irpino',
		'IT064010' => 'Baiano',
		'IT064011' => 'Bisaccia',
		'IT064012' => 'Bonito',
		'IT064013' => 'Cairano',
		'IT064014' => 'Calabritto',
		'IT064015' => 'Calitri',
		'IT064016' => 'Candida',
		'IT064017' => 'Caposele',
		'IT064018' => 'Capriglia Irpina',
		'IT064019' => 'Carife',
		'IT064020' => 'Casalbore',
		'IT064021' => 'Cassano Irpino',
		'IT064022' => 'Castel Baronia',
		'IT064023' => 'Castelfranci',
		'IT064024' => 'Castelvetere sul Calore',
		'IT064025' => 'Cervinara',
		'IT064026' => 'Cesinali',
		'IT064027' => 'Chianche',
		'IT064028' => 'Chiusano di San Domenico',
		'IT064029' => 'Contrada',
		'IT064030' => 'Conza della Campania',
		'IT064031' => 'Domicella',
		'IT064032' => 'Flumeri',
		'IT064033' => 'Fontanarosa',
		'IT064034' => 'Forino',
		'IT064035' => 'Frigento',
		'IT064036' => 'Gesualdo',
		'IT064037' => 'Greci',
		'IT064038' => 'Grottaminarda',
		'IT064039' => 'Grottolella',
		'IT064040' => 'Guardia Lombardi',
		'IT064041' => 'Lacedonia',
		'IT064042' => 'Lapio',
		'IT064043' => 'Lauro',
		'IT064044' => 'Lioni',
		'IT064045' => 'Luogosano',
		'IT064046' => 'Manocalzati',
		'IT064047' => 'Marzano di Nola',
		'IT064048' => 'Melito Irpino',
		'IT064049' => 'Mercogliano',
		'IT064050' => 'Mirabella Eclano',
		'IT064051' => 'Montaguto',
		'IT064052' => 'Montecalvo Irpino',
		'IT064053' => 'Montefalcione',
		'IT064054' => 'Monteforte Irpino',
		'IT064055' => 'Montefredane',
		'IT064056' => 'Montefusco',
		'IT064057' => 'Montella',
		'IT064058' => 'Montemarano',
		'IT064059' => 'Montemiletto',
		'IT064060' => 'Monteverde',
		'IT064063' => 'Morra De Sanctis',
		'IT064064' => 'Moschiano',
		'IT064065' => 'Mugnano del Cardinale',
		'IT064066' => 'Nusco',
		'IT064067' => 'Ospedaletto dAlpinolo',
		'IT064068' => 'Pago del Vallo di Lauro',
		'IT064069' => 'Parolise',
		'IT064070' => 'Paternopoli',
		'IT064071' => 'Petruro Irpino',
		'IT064072' => 'Pietradefusi',
		'IT064073' => 'Pietrastornina',
		'IT064074' => 'Prata di Principato Ultra',
		'IT064075' => 'Pratola Serra',
		'IT064076' => 'Quadrelle',
		'IT064077' => 'Quindici',
		'IT064078' => 'Roccabascerana',
		'IT064079' => 'Rocca San Felice',
		'IT064080' => 'Rotondi',
		'IT064081' => 'Salza Irpina',
		'IT064082' => 'San Mango sul Calore',
		'IT064083' => 'San Martino Valle Caudina',
		'IT064084' => 'San Michele di Serino',
		'IT064085' => 'San Nicola Baronia',
		'IT064086' => 'San Potito Ultra',
		'IT064087' => 'San Sossio Baronia',
		'IT064088' => 'Santa Lucia di Serino',
		'IT064089' => 'SantAndrea di Conza',
		'IT064090' => 'SantAngelo allEsca',
		'IT064091' => 'SantAngelo a Scala',
		'IT064092' => 'SantAngelo dei Lombardi',
		'IT064093' => 'Santa Paolina',
		'IT064095' => 'Santo Stefano del Sole',
		'IT064096' => 'Savignano Irpino',
		'IT064097' => 'Scampitella',
		'IT064098' => 'Senerchia',
		'IT064099' => 'Serino',
		'IT064100' => 'Sirignano',
		'IT064101' => 'Solofra',
		'IT064102' => 'Sorbo Serpico',
		'IT064103' => 'Sperone',
		'IT064104' => 'Sturno',
		'IT064105' => 'Summonte',
		'IT064106' => 'Taurano',
		'IT064107' => 'Taurasi',
		'IT064108' => 'Teora',
		'IT064109' => 'Torella dei Lombardi',
		'IT064110' => 'Torre Le Nocelle',
		'IT064111' => 'Torrioni',
		'IT064112' => 'Trevico',
		'IT064113' => 'Tufo',
		'IT064114' => 'Vallata',
		'IT064115' => 'Vallesaccarda',
		'IT064116' => 'Venticano',
		'IT064117' => 'Villamaina',
		'IT064118' => 'Villanova del Battista',
		'IT064119' => 'Volturara Irpina',
		'IT064120' => 'Zungoli',
		'IT064121' => 'Montoro',
	],
	'SA' => [
		'IT065001' => 'Acerno',
		'IT065002' => 'Agropoli',
		'IT065003' => 'Albanella',
		'IT065004' => 'Alfano',
		'IT065005' => 'Altavilla Silentina',
		'IT065006' => 'Amalfi',
		'IT065007' => 'Angri',
		'IT065008' => 'Aquara',
		'IT065009' => 'Ascea',
		'IT065010' => 'Atena Lucana',
		'IT065011' => 'Atrani',
		'IT065012' => 'Auletta',
		'IT065013' => 'Baronissi',
		'IT065014' => 'Battipaglia',
		'IT065015' => 'Bellosguardo',
		'IT065016' => 'Bracigliano',
		'IT065017' => 'Buccino',
		'IT065018' => 'Buonabitacolo',
		'IT065019' => 'Caggiano',
		'IT065020' => 'Calvanico',
		'IT065021' => 'Camerota',
		'IT065022' => 'Campagna',
		'IT065023' => 'Campora',
		'IT065024' => 'Cannalonga',
		'IT065025' => 'Capaccio Paestum',
		'IT065026' => 'Casalbuono',
		'IT065027' => 'Casaletto Spartano',
		'IT065028' => 'Casal Velino',
		'IT065029' => 'Caselle in Pittari',
		'IT065030' => 'Castelcivita',
		'IT065031' => 'Castellabate',
		'IT065032' => 'Castelnuovo Cilento',
		'IT065033' => 'Castelnuovo di Conza',
		'IT065034' => 'Castel San Giorgio',
		'IT065035' => 'Castel San Lorenzo',
		'IT065036' => 'Castiglione del Genovesi',
		'IT065037' => 'Cava de Tirreni',
		'IT065038' => 'Celle di Bulgheria',
		'IT065039' => 'Centola',
		'IT065040' => 'Ceraso',
		'IT065041' => 'Cetara',
		'IT065042' => 'Cicerale',
		'IT065043' => 'Colliano',
		'IT065044' => 'Conca dei Marini',
		'IT065045' => 'Controne',
		'IT065046' => 'Contursi Terme',
		'IT065047' => 'Corbara',
		'IT065048' => 'Corleto Monforte',
		'IT065049' => 'Cuccaro Vetere',
		'IT065050' => 'Eboli',
		'IT065051' => 'Felitto',
		'IT065052' => 'Fisciano',
		'IT065053' => 'Furore',
		'IT065054' => 'Futani',
		'IT065055' => 'Giffoni Sei Casali',
		'IT065056' => 'Giffoni Valle Piana',
		'IT065057' => 'Gioi',
		'IT065058' => 'Giungano',
		'IT065059' => 'Ispani',
		'IT065060' => 'Laureana Cilento',
		'IT065061' => 'Laurino',
		'IT065062' => 'Laurito',
		'IT065063' => 'Laviano',
		'IT065064' => 'Lustra',
		'IT065065' => 'Magliano Vetere',
		'IT065066' => 'Maiori',
		'IT065067' => 'Mercato San Severino',
		'IT065068' => 'Minori',
		'IT065069' => 'Moio della Civitella',
		'IT065070' => 'Montano Antilia',
		'IT065071' => 'Montecorice',
		'IT065072' => 'Montecorvino Pugliano',
		'IT065073' => 'Montecorvino Rovella',
		'IT065074' => 'Monteforte Cilento',
		'IT065075' => 'Monte San Giacomo',
		'IT065076' => 'Montesano sulla Marcellana',
		'IT065077' => 'Morigerati',
		'IT065078' => 'Nocera Inferiore',
		'IT065079' => 'Nocera Superiore',
		'IT065080' => 'Novi Velia',
		'IT065081' => 'Ogliastro Cilento',
		'IT065082' => 'Olevano sul Tusciano',
		'IT065083' => 'Oliveto Citra',
		'IT065084' => 'Omignano',
		'IT065085' => 'Orria',
		'IT065086' => 'Ottati',
		'IT065087' => 'Padula',
		'IT065088' => 'Pagani',
		'IT065089' => 'Palomonte',
		'IT065090' => 'Pellezzano',
		'IT065091' => 'Perdifumo',
		'IT065092' => 'Perito',
		'IT065093' => 'Pertosa',
		'IT065094' => 'Petina',
		'IT065095' => 'Piaggine',
		'IT065096' => 'Pisciotta',
		'IT065097' => 'Polla',
		'IT065098' => 'Pollica',
		'IT065099' => 'Pontecagnano Faiano',
		'IT065100' => 'Positano',
		'IT065101' => 'Postiglione',
		'IT065102' => 'Praiano',
		'IT065103' => 'Prignano Cilento',
		'IT065104' => 'Ravello',
		'IT065105' => 'Ricigliano',
		'IT065106' => 'Roccadaspide',
		'IT065107' => 'Roccagloriosa',
		'IT065108' => 'Roccapiemonte',
		'IT065109' => 'Rofrano',
		'IT065110' => 'Romagnano al Monte',
		'IT065111' => 'Roscigno',
		'IT065112' => 'Rutino',
		'IT065113' => 'Sacco',
		'IT065114' => 'Sala Consilina',
		'IT065115' => 'Salento',
		'IT065116' => 'Salerno',
		'IT065117' => 'Salvitelle',
		'IT065118' => 'San Cipriano Picentino',
		'IT065119' => 'San Giovanni a Piro',
		'IT065120' => 'San Gregorio Magno',
		'IT065121' => 'San Mango Piemonte',
		'IT065122' => 'San Marzano sul Sarno',
		'IT065123' => 'San Mauro Cilento',
		'IT065124' => 'San Mauro la Bruca',
		'IT065125' => 'San Pietro al Tanagro',
		'IT065126' => 'San Rufo',
		'IT065127' => 'Santa Marina',
		'IT065128' => 'SantAngelo a Fasanella',
		'IT065129' => 'SantArsenio',
		'IT065130' => 'SantEgidio del Monte Albino',
		'IT065131' => 'Santomenna',
		'IT065132' => 'San Valentino Torio',
		'IT065133' => 'Sanza',
		'IT065134' => 'Sapri',
		'IT065135' => 'Sarno',
		'IT065136' => 'Sassano',
		'IT065137' => 'Scafati',
		'IT065138' => 'Scala',
		'IT065139' => 'Serramezzana',
		'IT065140' => 'Serre',
		'IT065141' => 'Sessa Cilento',
		'IT065142' => 'Siano',
		'IT065143' => 'Sicignano degli Alburni',
		'IT065144' => 'Stella Cilento',
		'IT065145' => 'Stio',
		'IT065146' => 'Teggiano',
		'IT065147' => 'Torchiara',
		'IT065148' => 'Torraca',
		'IT065149' => 'Torre Orsaia',
		'IT065150' => 'Tortorella',
		'IT065151' => 'Tramonti',
		'IT065152' => 'Trentinara',
		'IT065153' => 'Valle dellAngelo',
		'IT065154' => 'Vallo della Lucania',
		'IT065155' => 'Valva',
		'IT065156' => 'Vibonati',
		'IT065157' => 'Vietri sul Mare',
		'IT065158' => 'Bellizzi',
	],
	'FG' => [
		'IT071001' => 'Accadia',
		'IT071002' => 'Alberona',
		'IT071003' => 'Anzano di Puglia',
		'IT071004' => 'Apricena',
		'IT071005' => 'Ascoli Satriano',
		'IT071006' => 'Biccari',
		'IT071007' => 'Bovino',
		'IT071008' => 'Cagnano Varano',
		'IT071009' => 'Candela',
		'IT071010' => 'Carapelle',
		'IT071011' => 'Carlantino',
		'IT071012' => 'Carpino',
		'IT071013' => 'Casalnuovo Monterotaro',
		'IT071014' => 'Casalvecchio di Puglia',
		'IT071015' => 'Castelluccio dei Sauri',
		'IT071016' => 'Castelluccio Valmaggiore',
		'IT071017' => 'Castelnuovo della Daunia',
		'IT071018' => 'Celenza Valfortore',
		'IT071019' => 'Celle di San Vito',
		'IT071020' => 'Cerignola',
		'IT071021' => 'Chieuti',
		'IT071022' => 'Deliceto',
		'IT071023' => 'Faeto',
		'IT071024' => 'Foggia',
		'IT071025' => 'Ischitella',
		'IT071026' => 'Isole Tremiti',
		'IT071027' => 'Lesina',
		'IT071028' => 'Lucera',
		'IT071029' => 'Manfredonia',
		'IT071031' => 'Mattinata',
		'IT071032' => 'Monteleone di Puglia',
		'IT071033' => 'Monte SantAngelo',
		'IT071034' => 'Motta Montecorvino',
		'IT071035' => 'Orsara di Puglia',
		'IT071036' => 'Orta Nova',
		'IT071037' => 'Panni',
		'IT071038' => 'Peschici',
		'IT071039' => 'Pietramontecorvino',
		'IT071040' => 'Poggio Imperiale',
		'IT071041' => 'Rignano Garganico',
		'IT071042' => 'Rocchetta SantAntonio',
		'IT071043' => 'Rodi Garganico',
		'IT071044' => 'Roseto Valfortore',
		'IT071046' => 'San Giovanni Rotondo',
		'IT071047' => 'San Marco in Lamis',
		'IT071048' => 'San Marco la Catola',
		'IT071049' => 'San Nicandro Garganico',
		'IT071050' => 'San Paolo di Civitate',
		'IT071051' => 'San Severo',
		'IT071052' => 'SantAgata di Puglia',
		'IT071053' => 'Serracapriola',
		'IT071054' => 'Stornara',
		'IT071055' => 'Stornarella',
		'IT071056' => 'Torremaggiore',
		'IT071058' => 'Troia',
		'IT071059' => 'Vico del Gargano',
		'IT071060' => 'Vieste',
		'IT071061' => 'Volturara Appula',
		'IT071062' => 'Volturino',
		'IT071063' => 'Ordona',
		'IT071064' => 'Zapponeta',
	],
	'BA' => [
		'IT072001' => 'Acquaviva delle Fonti',
		'IT072002' => 'Adelfia',
		'IT072003' => 'Alberobello',
		'IT072004' => 'Altamura',
		'IT072006' => 'Bari',
		'IT072008' => 'Binetto',
		'IT072010' => 'Bitetto',
		'IT072011' => 'Bitonto',
		'IT072012' => 'Bitritto',
		'IT072014' => 'Capurso',
		'IT072015' => 'Casamassima',
		'IT072016' => 'Cassano delle Murge',
		'IT072017' => 'Castellana Grotte',
		'IT072018' => 'Cellamare',
		'IT072019' => 'Conversano',
		'IT072020' => 'Corato',
		'IT072021' => 'Gioia del Colle',
		'IT072022' => 'Giovinazzo',
		'IT072023' => 'Gravina in Puglia',
		'IT072024' => 'Grumo Appula',
		'IT072025' => 'Locorotondo',
		'IT072027' => 'Modugno',
		'IT072028' => 'Mola di Bari',
		'IT072029' => 'Molfetta',
		'IT072030' => 'Monopoli',
		'IT072031' => 'Noci',
		'IT072032' => 'Noicattaro',
		'IT072033' => 'Palo del Colle',
		'IT072034' => 'Poggiorsini',
		'IT072035' => 'Polignano a Mare',
		'IT072036' => 'Putignano',
		'IT072037' => 'Rutigliano',
		'IT072038' => 'Ruvo di Puglia',
		'IT072039' => 'Sammichele di Bari',
		'IT072040' => 'Sannicandro di Bari',
		'IT072041' => 'Santeramo in Colle',
		'IT072043' => 'Terlizzi',
		'IT072044' => 'Toritto',
		'IT072046' => 'Triggiano',
		'IT072047' => 'Turi',
		'IT072048' => 'Valenzano',
	],
	'TA' => [
		'IT073001' => 'Avetrana',
		'IT073002' => 'Carosino',
		'IT073003' => 'Castellaneta',
		'IT073004' => 'Crispiano',
		'IT073005' => 'Faggiano',
		'IT073006' => 'Fragagnano',
		'IT073007' => 'Ginosa',
		'IT073008' => 'Grottaglie',
		'IT073009' => 'Laterza',
		'IT073010' => 'Leporano',
		'IT073011' => 'Lizzano',
		'IT073012' => 'Manduria',
		'IT073013' => 'Martina Franca',
		'IT073014' => 'Maruggio',
		'IT073015' => 'Massafra',
		'IT073016' => 'Monteiasi',
		'IT073017' => 'Montemesola',
		'IT073018' => 'Monteparano',
		'IT073019' => 'Mottola',
		'IT073020' => 'Palagianello',
		'IT073021' => 'Palagiano',
		'IT073022' => 'Pulsano',
		'IT073023' => 'Roccaforzata',
		'IT073024' => 'San Giorgio Ionico',
		'IT073025' => 'San Marzano di San Giuseppe',
		'IT073026' => 'Sava',
		'IT073027' => 'Taranto',
		'IT073028' => 'Torricella',
		'IT073029' => 'Statte',
	],
	'BR' => [
		'IT074001' => 'Brindisi',
		'IT074002' => 'Carovigno',
		'IT074003' => 'Ceglie Messapica',
		'IT074004' => 'Cellino San Marco',
		'IT074005' => 'Cisternino',
		'IT074006' => 'Erchie',
		'IT074007' => 'Fasano',
		'IT074008' => 'Francavilla Fontana',
		'IT074009' => 'Latiano',
		'IT074010' => 'Mesagne',
		'IT074011' => 'Oria',
		'IT074012' => 'Ostuni',
		'IT074013' => 'San Donaci',
		'IT074014' => 'San Michele Salentino',
		'IT074015' => 'San Pancrazio Salentino',
		'IT074016' => 'San Pietro Vernotico',
		'IT074017' => 'San Vito dei Normanni',
		'IT074018' => 'Torchiarolo',
		'IT074019' => 'Torre Santa Susanna',
		'IT074020' => 'Villa Castelli',
	],
	'LE' => [
		'IT075001' => 'Acquarica del Capo',
		'IT075002' => 'Alessano',
		'IT075003' => 'Alezio',
		'IT075004' => 'Alliste',
		'IT075005' => 'Andrano',
		'IT075006' => 'Aradeo',
		'IT075007' => 'Arnesano',
		'IT075008' => 'Bagnolo del Salento',
		'IT075009' => 'Botrugno',
		'IT075010' => 'Calimera',
		'IT075011' => 'Campi Salentina',
		'IT075012' => 'Cannole',
		'IT075013' => 'Caprarica di Lecce',
		'IT075014' => 'Carmiano',
		'IT075015' => 'Carpignano Salentino',
		'IT075016' => 'Casarano',
		'IT075017' => 'Castri di Lecce',
		'IT075018' => 'Castrignano de Greci',
		'IT075019' => 'Castrignano del Capo',
		'IT075020' => 'Cavallino',
		'IT075021' => 'Collepasso',
		'IT075022' => 'Copertino',
		'IT075023' => 'Corigliano dOtranto',
		'IT075024' => 'Corsano',
		'IT075025' => 'Cursi',
		'IT075026' => 'Cutrofiano',
		'IT075027' => 'Diso',
		'IT075028' => 'Gagliano del Capo',
		'IT075029' => 'Galatina',
		'IT075030' => 'Galatone',
		'IT075031' => 'Gallipoli',
		'IT075032' => 'Giuggianello',
		'IT075033' => 'Giurdignano',
		'IT075034' => 'Guagnano',
		'IT075035' => 'Lecce',
		'IT075036' => 'Lequile',
		'IT075037' => 'Leverano',
		'IT075038' => 'Lizzanello',
		'IT075039' => 'Maglie',
		'IT075040' => 'Martano',
		'IT075041' => 'Martignano',
		'IT075042' => 'Matino',
		'IT075043' => 'Melendugno',
		'IT075044' => 'Melissano',
		'IT075045' => 'Melpignano',
		'IT075046' => 'Miggiano',
		'IT075047' => 'Minervino di Lecce',
		'IT075048' => 'Monteroni di Lecce',
		'IT075049' => 'Montesano Salentino',
		'IT075050' => 'Morciano di Leuca',
		'IT075051' => 'Muro Leccese',
		'IT075052' => 'Nardò',
		'IT075053' => 'Neviano',
		'IT075054' => 'Nociglia',
		'IT075055' => 'Novoli',
		'IT075056' => 'Ortelle',
		'IT075057' => 'Otranto',
		'IT075058' => 'Palmariggi',
		'IT075059' => 'Parabita',
		'IT075060' => 'Patù',
		'IT075061' => 'Poggiardo',
		'IT075062' => 'Presicce',
		'IT075063' => 'Racale',
		'IT075064' => 'Ruffano',
		'IT075065' => 'Salice Salentino',
		'IT075066' => 'Salve',
		'IT075067' => 'Sanarica',
		'IT075068' => 'San Cesario di Lecce',
		'IT075069' => 'San Donato di Lecce',
		'IT075070' => 'Sannicola',
		'IT075071' => 'San Pietro in Lama',
		'IT075072' => 'Santa Cesarea Terme',
		'IT075073' => 'Scorrano',
		'IT075074' => 'Seclì',
		'IT075075' => 'Sogliano Cavour',
		'IT075076' => 'Soleto',
		'IT075077' => 'Specchia',
		'IT075078' => 'Spongano',
		'IT075079' => 'Squinzano',
		'IT075080' => 'Sternatia',
		'IT075081' => 'Supersano',
		'IT075082' => 'Surano',
		'IT075083' => 'Surbo',
		'IT075084' => 'Taurisano',
		'IT075085' => 'Taviano',
		'IT075086' => 'Tiggiano',
		'IT075087' => 'Trepuzzi',
		'IT075088' => 'Tricase',
		'IT075089' => 'Tuglie',
		'IT075090' => 'Ugento',
		'IT075091' => 'Uggiano la Chiesa',
		'IT075092' => 'Veglie',
		'IT075093' => 'Vernole',
		'IT075094' => 'Zollino',
		'IT075095' => 'San Cassiano',
		'IT075096' => 'Castro',
		'IT075097' => 'Porto Cesareo',
	],
	'BT' => [
		'IT110001' => 'Andria',
		'IT110002' => 'Barletta',
		'IT110003' => 'Bisceglie',
		'IT110004' => 'Canosa di Puglia',
		'IT110005' => 'Margherita di Savoia',
		'IT110006' => 'Minervino Murge',
		'IT110007' => 'San Ferdinando di Puglia',
		'IT110008' => 'Spinazzola',
		'IT110009' => 'Trani',
		'IT110010' => 'Trinitapoli',
	],
	'PZ' => [
		'IT076001' => 'Abriola',
		'IT076002' => 'Acerenza',
		'IT076003' => 'Albano di Lucania',
		'IT076004' => 'Anzi',
		'IT076005' => 'Armento',
		'IT076006' => 'Atella',
		'IT076007' => 'Avigliano',
		'IT076008' => 'Balvano',
		'IT076009' => 'Banzi',
		'IT076010' => 'Baragiano',
		'IT076011' => 'Barile',
		'IT076012' => 'Bella',
		'IT076013' => 'Brienza',
		'IT076014' => 'Brindisi Montagna',
		'IT076015' => 'Calvello',
		'IT076016' => 'Calvera',
		'IT076017' => 'Campomaggiore',
		'IT076018' => 'Cancellara',
		'IT076019' => 'Carbone',
		'IT076020' => 'San Paolo Albanese',
		'IT076021' => 'Castelgrande',
		'IT076022' => 'Castelluccio Inferiore',
		'IT076023' => 'Castelluccio Superiore',
		'IT076024' => 'Castelmezzano',
		'IT076025' => 'Castelsaraceno',
		'IT076026' => 'Castronuovo di SantAndrea',
		'IT076027' => 'Cersosimo',
		'IT076028' => 'Chiaromonte',
		'IT076029' => 'Corleto Perticara',
		'IT076030' => 'Episcopia',
		'IT076031' => 'Fardella',
		'IT076032' => 'Filiano',
		'IT076033' => 'Forenza',
		'IT076034' => 'Francavilla in Sinni',
		'IT076035' => 'Gallicchio',
		'IT076036' => 'Genzano di Lucania',
		'IT076037' => 'Grumento Nova',
		'IT076038' => 'Guardia Perticara',
		'IT076039' => 'Lagonegro',
		'IT076040' => 'Latronico',
		'IT076041' => 'Laurenzana',
		'IT076042' => 'Lauria',
		'IT076043' => 'Lavello',
		'IT076044' => 'Maratea',
		'IT076045' => 'Marsico Nuovo',
		'IT076046' => 'Marsicovetere',
		'IT076047' => 'Maschito',
		'IT076048' => 'Melfi',
		'IT076049' => 'Missanello',
		'IT076050' => 'Moliterno',
		'IT076051' => 'Montemilone',
		'IT076052' => 'Montemurro',
		'IT076053' => 'Muro Lucano',
		'IT076054' => 'Nemoli',
		'IT076055' => 'Noepoli',
		'IT076056' => 'Oppido Lucano',
		'IT076057' => 'Palazzo San Gervasio',
		'IT076058' => 'Pescopagano',
		'IT076059' => 'Picerno',
		'IT076060' => 'Pietragalla',
		'IT076061' => 'Pietrapertosa',
		'IT076062' => 'Pignola',
		'IT076063' => 'Potenza',
		'IT076064' => 'Rapolla',
		'IT076065' => 'Rapone',
		'IT076066' => 'Rionero in Vulture',
		'IT076067' => 'Ripacandida',
		'IT076068' => 'Rivello',
		'IT076069' => 'Roccanova',
		'IT076070' => 'Rotonda',
		'IT076071' => 'Ruoti',
		'IT076072' => 'Ruvo del Monte',
		'IT076073' => 'San Chirico Nuovo',
		'IT076074' => 'San Chirico Raparo',
		'IT076075' => 'San Costantino Albanese',
		'IT076076' => 'San Fele',
		'IT076077' => 'San Martino dAgri',
		'IT076078' => 'San Severino Lucano',
		'IT076079' => 'SantAngelo Le Fratte',
		'IT076080' => 'SantArcangelo',
		'IT076081' => 'Sarconi',
		'IT076082' => 'Sasso di Castalda',
		'IT076083' => 'Satriano di Lucania',
		'IT076084' => 'Savoia di Lucania',
		'IT076085' => 'Senise',
		'IT076086' => 'Spinoso',
		'IT076087' => 'Teana',
		'IT076088' => 'Terranova di Pollino',
		'IT076089' => 'Tito',
		'IT076090' => 'Tolve',
		'IT076091' => 'Tramutola',
		'IT076092' => 'Trecchina',
		'IT076093' => 'Trivigno',
		'IT076094' => 'Vaglio Basilicata',
		'IT076095' => 'Venosa',
		'IT076096' => 'Vietri di Potenza',
		'IT076097' => 'Viggianello',
		'IT076098' => 'Viggiano',
		'IT076099' => 'Ginestra',
		'IT076100' => 'Paterno',
	],
	'MT' => [
		'IT077001' => 'Accettura',
		'IT077002' => 'Aliano',
		'IT077003' => 'Bernalda',
		'IT077004' => 'Calciano',
		'IT077005' => 'Cirigliano',
		'IT077006' => 'Colobraro',
		'IT077007' => 'Craco',
		'IT077008' => 'Ferrandina',
		'IT077009' => 'Garaguso',
		'IT077010' => 'Gorgoglione',
		'IT077011' => 'Grassano',
		'IT077012' => 'Grottole',
		'IT077013' => 'Irsina',
		'IT077014' => 'Matera',
		'IT077015' => 'Miglionico',
		'IT077016' => 'Montalbano Jonico',
		'IT077017' => 'Montescaglioso',
		'IT077018' => 'Nova Siri',
		'IT077019' => 'Oliveto Lucano',
		'IT077020' => 'Pisticci',
		'IT077021' => 'Policoro',
		'IT077022' => 'Pomarico',
		'IT077023' => 'Rotondella',
		'IT077024' => 'Salandra',
		'IT077025' => 'San Giorgio Lucano',
		'IT077026' => 'San Mauro Forte',
		'IT077027' => 'Stigliano',
		'IT077028' => 'Tricarico',
		'IT077029' => 'Tursi',
		'IT077030' => 'Valsinni',
		'IT077031' => 'Scanzano Jonico',
	],
	'CS' => [
		'IT078001' => 'Acquaformosa',
		'IT078002' => 'Acquappesa',
		'IT078003' => 'Acri',
		'IT078004' => 'Aiello Calabro',
		'IT078005' => 'Aieta',
		'IT078006' => 'Albidona',
		'IT078007' => 'Alessandria del Carretto',
		'IT078008' => 'Altilia',
		'IT078009' => 'Altomonte',
		'IT078010' => 'Amantea',
		'IT078011' => 'Amendolara',
		'IT078012' => 'Aprigliano',
		'IT078013' => 'Belmonte Calabro',
		'IT078014' => 'Belsito',
		'IT078015' => 'Belvedere Marittimo',
		'IT078016' => 'Bianchi',
		'IT078017' => 'Bisignano',
		'IT078018' => 'Bocchigliero',
		'IT078019' => 'Bonifati',
		'IT078020' => 'Buonvicino',
		'IT078021' => 'Calopezzati',
		'IT078022' => 'Caloveto',
		'IT078023' => 'Campana',
		'IT078024' => 'Canna',
		'IT078025' => 'Cariati',
		'IT078026' => 'Carolei',
		'IT078027' => 'Carpanzano',
		'IT078029' => 'Cassano allIonio',
		'IT078030' => 'Castiglione Cosentino',
		'IT078031' => 'Castrolibero',
		'IT078032' => 'Castroregio',
		'IT078033' => 'Castrovillari',
		'IT078034' => 'Celico',
		'IT078035' => 'Cellara',
		'IT078036' => 'Cerchiara di Calabria',
		'IT078037' => 'Cerisano',
		'IT078038' => 'Cervicati',
		'IT078039' => 'Cerzeto',
		'IT078040' => 'Cetraro',
		'IT078041' => 'Civita',
		'IT078042' => 'Cleto',
		'IT078043' => 'Colosimi',
		'IT078045' => 'Cosenza',
		'IT078046' => 'Cropalati',
		'IT078047' => 'Crosia',
		'IT078048' => 'Diamante',
		'IT078049' => 'Dipignano',
		'IT078050' => 'Domanico',
		'IT078051' => 'Fagnano Castello',
		'IT078052' => 'Falconara Albanese',
		'IT078053' => 'Figline Vegliaturo',
		'IT078054' => 'Firmo',
		'IT078055' => 'Fiumefreddo Bruzio',
		'IT078056' => 'Francavilla Marittima',
		'IT078057' => 'Frascineto',
		'IT078058' => 'Fuscaldo',
		'IT078059' => 'Grimaldi',
		'IT078060' => 'Grisolia',
		'IT078061' => 'Guardia Piemontese',
		'IT078062' => 'Lago',
		'IT078063' => 'Laino Borgo',
		'IT078064' => 'Laino Castello',
		'IT078065' => 'Lappano',
		'IT078066' => 'Lattarico',
		'IT078067' => 'Longobardi',
		'IT078068' => 'Longobucco',
		'IT078069' => 'Lungro',
		'IT078070' => 'Luzzi',
		'IT078071' => 'Maierà',
		'IT078072' => 'Malito',
		'IT078073' => 'Malvito',
		'IT078074' => 'Mandatoriccio',
		'IT078075' => 'Mangone',
		'IT078076' => 'Marano Marchesato',
		'IT078077' => 'Marano Principato',
		'IT078078' => 'Marzi',
		'IT078079' => 'Mendicino',
		'IT078080' => 'Mongrassano',
		'IT078081' => 'Montalto Uffugo',
		'IT078082' => 'Montegiordano',
		'IT078083' => 'Morano Calabro',
		'IT078084' => 'Mormanno',
		'IT078085' => 'Mottafollone',
		'IT078086' => 'Nocara',
		'IT078087' => 'Oriolo',
		'IT078088' => 'Orsomarso',
		'IT078089' => 'Paludi',
		'IT078090' => 'Panettieri',
		'IT078091' => 'Paola',
		'IT078092' => 'Papasidero',
		'IT078093' => 'Parenti',
		'IT078094' => 'Paterno Calabro',
		'IT078096' => 'Pedivigliano',
		'IT078097' => 'Piane Crati',
		'IT078098' => 'Pietrafitta',
		'IT078099' => 'Pietrapaola',
		'IT078100' => 'Plataci',
		'IT078101' => 'Praia a Mare',
		'IT078102' => 'Rende',
		'IT078103' => 'Rocca Imperiale',
		'IT078104' => 'Roggiano Gravina',
		'IT078105' => 'Rogliano',
		'IT078106' => 'Rose',
		'IT078107' => 'Roseto Capo Spulico',
		'IT078109' => 'Rota Greca',
		'IT078110' => 'Rovito',
		'IT078111' => 'San Basile',
		'IT078112' => 'San Benedetto Ullano',
		'IT078113' => 'San Cosmo Albanese',
		'IT078114' => 'San Demetrio Corone',
		'IT078115' => 'San Donato di Ninea',
		'IT078116' => 'San Fili',
		'IT078117' => 'Sangineto',
		'IT078118' => 'San Giorgio Albanese',
		'IT078119' => 'San Giovanni in Fiore',
		'IT078120' => 'San Lorenzo Bellizzi',
		'IT078121' => 'San Lorenzo del Vallo',
		'IT078122' => 'San Lucido',
		'IT078123' => 'San Marco Argentano',
		'IT078124' => 'San Martino di Finita',
		'IT078125' => 'San Nicola Arcella',
		'IT078126' => 'San Pietro in Amantea',
		'IT078127' => 'San Pietro in Guarano',
		'IT078128' => 'San Sosti',
		'IT078129' => 'Santa Caterina Albanese',
		'IT078130' => 'Santa Domenica Talao',
		'IT078131' => 'SantAgata di Esaro',
		'IT078132' => 'Santa Maria del Cedro',
		'IT078133' => 'Santa Sofia dEpiro',
		'IT078134' => 'Santo Stefano di Rogliano',
		'IT078135' => 'San Vincenzo La Costa',
		'IT078136' => 'Saracena',
		'IT078137' => 'Scala Coeli',
		'IT078138' => 'Scalea',
		'IT078139' => 'Scigliano',
		'IT078140' => 'Serra dAiello',
		'IT078142' => 'Spezzano Albanese',
		'IT078143' => 'Spezzano della Sila',
		'IT078145' => 'Tarsia',
		'IT078146' => 'Terranova da Sibari',
		'IT078147' => 'Terravecchia',
		'IT078148' => 'Torano Castello',
		'IT078149' => 'Tortora',
		'IT078150' => 'Trebisacce',
		'IT078152' => 'Vaccarizzo Albanese',
		'IT078153' => 'Verbicaro',
		'IT078154' => 'Villapiana',
		'IT078155' => 'Zumpano',
		'IT078156' => 'Casali del Manco',
		'IT078157' => 'Corigliano-Rossano',
	],
	'CZ' => [
		'IT079002' => 'Albi',
		'IT079003' => 'Amaroni',
		'IT079004' => 'Amato',
		'IT079005' => 'Andali',
		'IT079007' => 'Argusto',
		'IT079008' => 'Badolato',
		'IT079009' => 'Belcastro',
		'IT079011' => 'Borgia',
		'IT079012' => 'Botricello',
		'IT079017' => 'Caraffa di Catanzaro',
		'IT079018' => 'Cardinale',
		'IT079020' => 'Carlopoli',
		'IT079023' => 'Catanzaro',
		'IT079024' => 'Cenadi',
		'IT079025' => 'Centrache',
		'IT079027' => 'Cerva',
		'IT079029' => 'Chiaravalle Centrale',
		'IT079030' => 'Cicala',
		'IT079033' => 'Conflenti',
		'IT079034' => 'Cortale',
		'IT079036' => 'Cropani',
		'IT079039' => 'Curinga',
		'IT079042' => 'Davoli',
		'IT079043' => 'Decollatura',
		'IT079047' => 'Falerna',
		'IT079048' => 'Feroleto Antico',
		'IT079052' => 'Fossato Serralta',
		'IT079055' => 'Gagliato',
		'IT079056' => 'Gasperina',
		'IT079058' => 'Gimigliano',
		'IT079059' => 'Girifalco',
		'IT079060' => 'Gizzeria',
		'IT079061' => 'Guardavalle',
		'IT079063' => 'Isca sullo Ionio',
		'IT079065' => 'Jacurso',
		'IT079068' => 'Magisano',
		'IT079069' => 'Maida',
		'IT079071' => 'Marcedusa',
		'IT079072' => 'Marcellinara',
		'IT079073' => 'Martirano',
		'IT079074' => 'Martirano Lombardo',
		'IT079077' => 'Miglierina',
		'IT079080' => 'Montauro',
		'IT079081' => 'Montepaone',
		'IT079083' => 'Motta Santa Lucia',
		'IT079087' => 'Nocera Terinese',
		'IT079088' => 'Olivadi',
		'IT079089' => 'Palermiti',
		'IT079092' => 'Pentone',
		'IT079094' => 'Petrizzi',
		'IT079095' => 'Petronà',
		'IT079096' => 'Pianopoli',
		'IT079099' => 'Platania',
		'IT079108' => 'San Floro',
		'IT079110' => 'San Mango dAquino',
		'IT079114' => 'San Pietro a Maida',
		'IT079115' => 'San Pietro Apostolo',
		'IT079116' => 'San Sostene',
		'IT079117' => 'Santa Caterina dello Ionio',
		'IT079118' => 'SantAndrea Apostolo dello Ionio',
		'IT079122' => 'San Vito sullo Ionio',
		'IT079123' => 'Satriano',
		'IT079126' => 'Sellia',
		'IT079127' => 'Sellia Marina',
		'IT079129' => 'Serrastretta',
		'IT079130' => 'Sersale',
		'IT079131' => 'Settingiano',
		'IT079133' => 'Simeri Crichi',
		'IT079134' => 'Sorbo San Basile',
		'IT079137' => 'Soverato',
		'IT079138' => 'Soveria Mannelli',
		'IT079139' => 'Soveria Simeri',
		'IT079142' => 'Squillace',
		'IT079143' => 'Stalettì',
		'IT079146' => 'Taverna',
		'IT079147' => 'Tiriolo',
		'IT079148' => 'Torre di Ruggiero',
		'IT079151' => 'Vallefiorita',
		'IT079157' => 'Zagarise',
		'IT079160' => 'Lamezia Terme',
	],
	'RC' => [
		'IT080001' => 'Africo',
		'IT080002' => 'Agnana Calabra',
		'IT080003' => 'Anoia',
		'IT080004' => 'Antonimina',
		'IT080005' => 'Ardore',
		'IT080006' => 'Bagaladi',
		'IT080007' => 'Bagnara Calabra',
		'IT080008' => 'Benestare',
		'IT080009' => 'Bianco',
		'IT080010' => 'Bivongi',
		'IT080011' => 'Bova',
		'IT080012' => 'Bovalino',
		'IT080013' => 'Bova Marina',
		'IT080014' => 'Brancaleone',
		'IT080015' => 'Bruzzano Zeffirio',
		'IT080016' => 'Calanna',
		'IT080017' => 'Camini',
		'IT080018' => 'Campo Calabro',
		'IT080019' => 'Candidoni',
		'IT080020' => 'Canolo',
		'IT080021' => 'Caraffa del Bianco',
		'IT080022' => 'Cardeto',
		'IT080023' => 'Careri',
		'IT080024' => 'Casignana',
		'IT080025' => 'Caulonia',
		'IT080026' => 'Ciminà',
		'IT080027' => 'Cinquefrondi',
		'IT080028' => 'Cittanova',
		'IT080029' => 'Condofuri',
		'IT080030' => 'Cosoleto',
		'IT080031' => 'Delianuova',
		'IT080032' => 'Feroleto della Chiesa',
		'IT080033' => 'Ferruzzano',
		'IT080034' => 'Fiumara',
		'IT080035' => 'Galatro',
		'IT080036' => 'Gerace',
		'IT080037' => 'Giffone',
		'IT080038' => 'Gioia Tauro',
		'IT080039' => 'Gioiosa Ionica',
		'IT080040' => 'Grotteria',
		'IT080041' => 'Laganadi',
		'IT080042' => 'Laureana di Borrello',
		'IT080043' => 'Locri',
		'IT080044' => 'Mammola',
		'IT080045' => 'Marina di Gioiosa Ionica',
		'IT080046' => 'Maropati',
		'IT080047' => 'Martone',
		'IT080048' => 'Melicuccà',
		'IT080049' => 'Melicucco',
		'IT080050' => 'Melito di Porto Salvo',
		'IT080051' => 'Molochio',
		'IT080052' => 'Monasterace',
		'IT080053' => 'Montebello Jonico',
		'IT080054' => 'Motta San Giovanni',
		'IT080055' => 'Oppido Mamertina',
		'IT080056' => 'Palizzi',
		'IT080057' => 'Palmi',
		'IT080058' => 'Pazzano',
		'IT080059' => 'Placanica',
		'IT080060' => 'Platì',
		'IT080061' => 'Polistena',
		'IT080062' => 'Portigliola',
		'IT080063' => 'Reggio di Calabria',
		'IT080064' => 'Riace',
		'IT080065' => 'Rizziconi',
		'IT080066' => 'Roccaforte del Greco',
		'IT080067' => 'Roccella Ionica',
		'IT080068' => 'Roghudi',
		'IT080069' => 'Rosarno',
		'IT080070' => 'Samo',
		'IT080071' => 'San Giorgio Morgeto',
		'IT080072' => 'San Giovanni di Gerace',
		'IT080073' => 'San Lorenzo',
		'IT080074' => 'San Luca',
		'IT080075' => 'San Pietro di Caridà',
		'IT080076' => 'San Procopio',
		'IT080077' => 'San Roberto',
		'IT080078' => 'Santa Cristina dAspromonte',
		'IT080079' => 'SantAgata del Bianco',
		'IT080080' => 'SantAlessio in Aspromonte',
		'IT080081' => 'SantEufemia dAspromonte',
		'IT080082' => 'SantIlario dello Ionio',
		'IT080083' => 'Santo Stefano in Aspromonte',
		'IT080084' => 'Scido',
		'IT080085' => 'Scilla',
		'IT080086' => 'Seminara',
		'IT080087' => 'Serrata',
		'IT080088' => 'Siderno',
		'IT080089' => 'Sinopoli',
		'IT080090' => 'Staiti',
		'IT080091' => 'Stignano',
		'IT080092' => 'Stilo',
		'IT080093' => 'Taurianova',
		'IT080094' => 'Terranova Sappo Minulio',
		'IT080095' => 'Varapodio',
		'IT080096' => 'Villa San Giovanni',
		'IT080097' => 'San Ferdinando',
	],
	'KR' => [
		'IT101001' => 'Belvedere di Spinello',
		'IT101002' => 'Caccuri',
		'IT101003' => 'Carfizzi',
		'IT101004' => 'Casabona',
		'IT101005' => 'Castelsilano',
		'IT101006' => 'Cerenzia',
		'IT101007' => 'Cirò',
		'IT101008' => 'Cirò Marina',
		'IT101009' => 'Cotronei',
		'IT101010' => 'Crotone',
		'IT101011' => 'Crucoli',
		'IT101012' => 'Cutro',
		'IT101013' => 'Isola di Capo Rizzuto',
		'IT101014' => 'Melissa',
		'IT101015' => 'Mesoraca',
		'IT101016' => 'Pallagorio',
		'IT101017' => 'Petilia Policastro',
		'IT101018' => 'Roccabernarda',
		'IT101019' => 'Rocca di Neto',
		'IT101020' => 'San Mauro Marchesato',
		'IT101021' => 'San Nicola dellAlto',
		'IT101022' => 'Santa Severina',
		'IT101023' => 'Savelli',
		'IT101024' => 'Scandale',
		'IT101025' => 'Strongoli',
		'IT101026' => 'Umbriatico',
		'IT101027' => 'Verzino',
	],
	'VV' => [
		'IT102001' => 'Acquaro',
		'IT102002' => 'Arena',
		'IT102003' => 'Briatico',
		'IT102004' => 'Brognaturo',
		'IT102005' => 'Capistrano',
		'IT102006' => 'Cessaniti',
		'IT102007' => 'Dasà',
		'IT102008' => 'Dinami',
		'IT102009' => 'Drapia',
		'IT102010' => 'Fabrizia',
		'IT102011' => 'Filadelfia',
		'IT102012' => 'Filandari',
		'IT102013' => 'Filogaso',
		'IT102014' => 'Francavilla Angitola',
		'IT102015' => 'Francica',
		'IT102016' => 'Gerocarne',
		'IT102017' => 'Ionadi',
		'IT102018' => 'Joppolo',
		'IT102019' => 'Limbadi',
		'IT102020' => 'Maierato',
		'IT102021' => 'Mileto',
		'IT102022' => 'Mongiana',
		'IT102023' => 'Monterosso Calabro',
		'IT102024' => 'Nardodipace',
		'IT102025' => 'Nicotera',
		'IT102026' => 'Parghelia',
		'IT102027' => 'Pizzo',
		'IT102028' => 'Pizzoni',
		'IT102029' => 'Polia',
		'IT102030' => 'Ricadi',
		'IT102031' => 'Rombiolo',
		'IT102032' => 'San Calogero',
		'IT102033' => 'San Costantino Calabro',
		'IT102034' => 'San Gregorio dIppona',
		'IT102035' => 'San Nicola da Crissa',
		'IT102036' => 'SantOnofrio',
		'IT102037' => 'Serra San Bruno',
		'IT102038' => 'Simbario',
		'IT102039' => 'Sorianello',
		'IT102040' => 'Soriano Calabro',
		'IT102041' => 'Spadola',
		'IT102042' => 'Spilinga',
		'IT102043' => 'Stefanaconi',
		'IT102044' => 'Tropea',
		'IT102045' => 'Vallelonga',
		'IT102046' => 'Vazzano',
		'IT102047' => 'Vibo Valentia',
		'IT102048' => 'Zaccanopoli',
		'IT102049' => 'Zambrone',
		'IT102050' => 'Zungri',
	],
	'TP' => [
		'IT081001' => 'Alcamo',
		'IT081002' => 'Buseto Palizzolo',
		'IT081003' => 'Calatafimi-Segesta',
		'IT081004' => 'Campobello di Mazara',
		'IT081005' => 'Castellammare del Golfo',
		'IT081006' => 'Castelvetrano',
		'IT081007' => 'Custonaci',
		'IT081008' => 'Erice',
		'IT081009' => 'Favignana',
		'IT081010' => 'Gibellina',
		'IT081011' => 'Marsala',
		'IT081012' => 'Mazara del Vallo',
		'IT081013' => 'Paceco',
		'IT081014' => 'Pantelleria',
		'IT081015' => 'Partanna',
		'IT081016' => 'Poggioreale',
		'IT081017' => 'Salaparuta',
		'IT081018' => 'Salemi',
		'IT081019' => 'Santa Ninfa',
		'IT081020' => 'San Vito Lo Capo',
		'IT081021' => 'Trapani',
		'IT081022' => 'Valderice',
		'IT081023' => 'Vita',
		'IT081024' => 'Petrosino',
	],
	'PA' => [
		'IT082001' => 'Alia',
		'IT082002' => 'Alimena',
		'IT082003' => 'Aliminusa',
		'IT082004' => 'Altavilla Milicia',
		'IT082005' => 'Altofonte',
		'IT082006' => 'Bagheria',
		'IT082007' => 'Balestrate',
		'IT082008' => 'Baucina',
		'IT082009' => 'Belmonte Mezzagno',
		'IT082010' => 'Bisacquino',
		'IT082011' => 'Bolognetta',
		'IT082012' => 'Bompietro',
		'IT082013' => 'Borgetto',
		'IT082014' => 'Caccamo',
		'IT082015' => 'Caltavuturo',
		'IT082016' => 'Campofelice di Fitalia',
		'IT082017' => 'Campofelice di Roccella',
		'IT082018' => 'Campofiorito',
		'IT082019' => 'Camporeale',
		'IT082020' => 'Capaci',
		'IT082021' => 'Carini',
		'IT082022' => 'Castelbuono',
		'IT082023' => 'Casteldaccia',
		'IT082024' => 'Castellana Sicula',
		'IT082025' => 'Castronovo di Sicilia',
		'IT082026' => 'Cefalà Diana',
		'IT082027' => 'Cefalù',
		'IT082028' => 'Cerda',
		'IT082029' => 'Chiusa Sclafani',
		'IT082030' => 'Ciminna',
		'IT082031' => 'Cinisi',
		'IT082032' => 'Collesano',
		'IT082033' => 'Contessa Entellina',
		'IT082034' => 'Corleone',
		'IT082035' => 'Ficarazzi',
		'IT082036' => 'Gangi',
		'IT082037' => 'Geraci Siculo',
		'IT082038' => 'Giardinello',
		'IT082039' => 'Giuliana',
		'IT082040' => 'Godrano',
		'IT082041' => 'Gratteri',
		'IT082042' => 'Isnello',
		'IT082043' => 'Isola delle Femmine',
		'IT082044' => 'Lascari',
		'IT082045' => 'Lercara Friddi',
		'IT082046' => 'Marineo',
		'IT082047' => 'Mezzojuso',
		'IT082048' => 'Misilmeri',
		'IT082049' => 'Monreale',
		'IT082050' => 'Montelepre',
		'IT082051' => 'Montemaggiore Belsito',
		'IT082052' => 'Palazzo Adriano',
		'IT082053' => 'Palermo',
		'IT082054' => 'Partinico',
		'IT082055' => 'Petralia Soprana',
		'IT082056' => 'Petralia Sottana',
		'IT082057' => 'Piana degli Albanesi',
		'IT082058' => 'Polizzi Generosa',
		'IT082059' => 'Pollina',
		'IT082060' => 'Prizzi',
		'IT082061' => 'Roccamena',
		'IT082062' => 'Roccapalumba',
		'IT082063' => 'San Cipirello',
		'IT082064' => 'San Giuseppe Jato',
		'IT082065' => 'San Mauro Castelverde',
		'IT082066' => 'Santa Cristina Gela',
		'IT082067' => 'Santa Flavia',
		'IT082068' => 'Sciara',
		'IT082069' => 'Sclafani Bagni',
		'IT082070' => 'Termini Imerese',
		'IT082071' => 'Terrasini',
		'IT082072' => 'Torretta',
		'IT082073' => 'Trabia',
		'IT082074' => 'Trappeto',
		'IT082075' => 'Ustica',
		'IT082076' => 'Valledolmo',
		'IT082077' => 'Ventimiglia di Sicilia',
		'IT082078' => 'Vicari',
		'IT082079' => 'Villabate',
		'IT082080' => 'Villafrati',
		'IT082081' => 'Scillato',
		'IT082082' => 'Blufi',
	],
	'ME' => [
		'IT083001' => 'Alcara li Fusi',
		'IT083002' => 'Alì',
		'IT083003' => 'Alì Terme',
		'IT083004' => 'Antillo',
		'IT083005' => 'Barcellona Pozzo di Gotto',
		'IT083006' => 'Basicò',
		'IT083007' => 'Brolo',
		'IT083008' => 'Capizzi',
		'IT083009' => 'Capo dOrlando',
		'IT083010' => 'Capri Leone',
		'IT083011' => 'Caronia',
		'IT083012' => 'Casalvecchio Siculo',
		'IT083013' => 'Castel di Lucio',
		'IT083014' => 'CastellUmberto',
		'IT083015' => 'Castelmola',
		'IT083016' => 'Castroreale',
		'IT083017' => 'Cesarò',
		'IT083018' => 'Condrò',
		'IT083019' => 'Falcone',
		'IT083020' => 'Ficarra',
		'IT083021' => 'Fiumedinisi',
		'IT083022' => 'Floresta',
		'IT083023' => 'Fondachelli-Fantina',
		'IT083024' => 'Forza dAgrò',
		'IT083025' => 'Francavilla di Sicilia',
		'IT083026' => 'Frazzanò',
		'IT083027' => 'Furci Siculo',
		'IT083028' => 'Furnari',
		'IT083029' => 'Gaggi',
		'IT083030' => 'Galati Mamertino',
		'IT083031' => 'Gallodoro',
		'IT083032' => 'Giardini-Naxos',
		'IT083033' => 'Gioiosa Marea',
		'IT083034' => 'Graniti',
		'IT083035' => 'Gualtieri Sicaminò',
		'IT083036' => 'Itala',
		'IT083037' => 'Leni',
		'IT083038' => 'Letojanni',
		'IT083039' => 'Librizzi',
		'IT083040' => 'Limina',
		'IT083041' => 'Lipari',
		'IT083042' => 'Longi',
		'IT083043' => 'Malfa',
		'IT083044' => 'Malvagna',
		'IT083045' => 'Mandanici',
		'IT083046' => 'Mazzarrà SantAndrea',
		'IT083047' => 'Merì',
		'IT083048' => 'Messina',
		'IT083049' => 'Milazzo',
		'IT083050' => 'Militello Rosmarino',
		'IT083051' => 'Mirto',
		'IT083052' => 'Mistretta',
		'IT083053' => 'Moio Alcantara',
		'IT083054' => 'Monforte San Giorgio',
		'IT083055' => 'Mongiuffi Melia',
		'IT083056' => 'Montagnareale',
		'IT083057' => 'Montalbano Elicona',
		'IT083058' => 'Motta Camastra',
		'IT083059' => 'Motta dAffermo',
		'IT083060' => 'Naso',
		'IT083061' => 'Nizza di Sicilia',
		'IT083062' => 'Novara di Sicilia',
		'IT083063' => 'Oliveri',
		'IT083064' => 'Pace del Mela',
		'IT083065' => 'Pagliara',
		'IT083066' => 'Patti',
		'IT083067' => 'Pettineo',
		'IT083068' => 'Piraino',
		'IT083069' => 'Raccuja',
		'IT083070' => 'Reitano',
		'IT083071' => 'Roccafiorita',
		'IT083072' => 'Roccalumera',
		'IT083073' => 'Roccavaldina',
		'IT083074' => 'Roccella Valdemone',
		'IT083075' => 'Rodì Milici',
		'IT083076' => 'Rometta',
		'IT083077' => 'San Filippo del Mela',
		'IT083078' => 'San Fratello',
		'IT083079' => 'San Marco dAlunzio',
		'IT083080' => 'San Pier Niceto',
		'IT083081' => 'San Piero Patti',
		'IT083082' => 'San Salvatore di Fitalia',
		'IT083083' => 'Santa Domenica Vittoria',
		'IT083084' => 'SantAgata di Militello',
		'IT083085' => 'SantAlessio Siculo',
		'IT083086' => 'Santa Lucia del Mela',
		'IT083087' => 'Santa Marina Salina',
		'IT083088' => 'SantAngelo di Brolo',
		'IT083089' => 'Santa Teresa di Riva',
		'IT083090' => 'San Teodoro',
		'IT083091' => 'Santo Stefano di Camastra',
		'IT083092' => 'Saponara',
		'IT083093' => 'Savoca',
		'IT083094' => 'Scaletta Zanclea',
		'IT083095' => 'Sinagra',
		'IT083096' => 'Spadafora',
		'IT083097' => 'Taormina',
		'IT083098' => 'Torregrotta',
		'IT083099' => 'Tortorici',
		'IT083100' => 'Tripi',
		'IT083101' => 'Tusa',
		'IT083102' => 'Ucria',
		'IT083103' => 'Valdina',
		'IT083104' => 'Venetico',
		'IT083105' => 'Villafranca Tirrena',
		'IT083106' => 'Terme Vigliatore',
		'IT083107' => 'Acquedolci',
		'IT083108' => 'Torrenova',
	],
	'AG' => [
		'IT084001' => 'Agrigento',
		'IT084002' => 'Alessandria della Rocca',
		'IT084003' => 'Aragona',
		'IT084004' => 'Bivona',
		'IT084005' => 'Burgio',
		'IT084006' => 'Calamonaci',
		'IT084007' => 'Caltabellotta',
		'IT084008' => 'Camastra',
		'IT084009' => 'Cammarata',
		'IT084010' => 'Campobello di Licata',
		'IT084011' => 'Canicattì',
		'IT084012' => 'Casteltermini',
		'IT084013' => 'Castrofilippo',
		'IT084014' => 'Cattolica Eraclea',
		'IT084015' => 'Cianciana',
		'IT084016' => 'Comitini',
		'IT084017' => 'Favara',
		'IT084018' => 'Grotte',
		'IT084019' => 'Joppolo Giancaxio',
		'IT084020' => 'Lampedusa e Linosa',
		'IT084021' => 'Licata',
		'IT084022' => 'Lucca Sicula',
		'IT084023' => 'Menfi',
		'IT084024' => 'Montallegro',
		'IT084025' => 'Montevago',
		'IT084026' => 'Naro',
		'IT084027' => 'Palma di Montechiaro',
		'IT084028' => 'Porto Empedocle',
		'IT084029' => 'Racalmuto',
		'IT084030' => 'Raffadali',
		'IT084031' => 'Ravanusa',
		'IT084032' => 'Realmonte',
		'IT084033' => 'Ribera',
		'IT084034' => 'Sambuca di Sicilia',
		'IT084035' => 'San Biagio Platani',
		'IT084036' => 'San Giovanni Gemini',
		'IT084037' => 'Santa Elisabetta',
		'IT084038' => 'Santa Margherita di Belice',
		'IT084039' => 'SantAngelo Muxaro',
		'IT084040' => 'Santo Stefano Quisquina',
		'IT084041' => 'Sciacca',
		'IT084042' => 'Siculiana',
		'IT084043' => 'Villafranca Sicula',
	],
	'CL' => [
		'IT085001' => 'Acquaviva Platani',
		'IT085002' => 'Bompensiere',
		'IT085003' => 'Butera',
		'IT085004' => 'Caltanissetta',
		'IT085005' => 'Campofranco',
		'IT085006' => 'Delia',
		'IT085007' => 'Gela',
		'IT085008' => 'Marianopoli',
		'IT085009' => 'Mazzarino',
		'IT085010' => 'Milena',
		'IT085011' => 'Montedoro',
		'IT085012' => 'Mussomeli',
		'IT085013' => 'Niscemi',
		'IT085014' => 'Resuttano',
		'IT085015' => 'Riesi',
		'IT085016' => 'San Cataldo',
		'IT085017' => 'Santa Caterina Villarmosa',
		'IT085018' => 'Serradifalco',
		'IT085019' => 'Sommatino',
		'IT085020' => 'Sutera',
		'IT085021' => 'Vallelunga Pratameno',
		'IT085022' => 'Villalba',
	],
	'EN' => [
		'IT086001' => 'Agira',
		'IT086002' => 'Aidone',
		'IT086003' => 'Assoro',
		'IT086004' => 'Barrafranca',
		'IT086005' => 'Calascibetta',
		'IT086006' => 'Catenanuova',
		'IT086007' => 'Centuripe',
		'IT086008' => 'Cerami',
		'IT086009' => 'Enna',
		'IT086010' => 'Gagliano Castelferrato',
		'IT086011' => 'Leonforte',
		'IT086012' => 'Nicosia',
		'IT086013' => 'Nissoria',
		'IT086014' => 'Piazza Armerina',
		'IT086015' => 'Pietraperzia',
		'IT086016' => 'Regalbuto',
		'IT086017' => 'Sperlinga',
		'IT086018' => 'Troina',
		'IT086019' => 'Valguarnera Caropepe',
		'IT086020' => 'Villarosa',
	],
	'CT' => [
		'IT087001' => 'Aci Bonaccorsi',
		'IT087002' => 'Aci Castello',
		'IT087003' => 'Aci Catena',
		'IT087004' => 'Acireale',
		'IT087005' => 'Aci SantAntonio',
		'IT087006' => 'Adrano',
		'IT087007' => 'Belpasso',
		'IT087008' => 'Biancavilla',
		'IT087009' => 'Bronte',
		'IT087010' => 'Calatabiano',
		'IT087011' => 'Caltagirone',
		'IT087012' => 'Camporotondo Etneo',
		'IT087013' => 'Castel di Iudica',
		'IT087014' => 'Castiglione di Sicilia',
		'IT087015' => 'Catania',
		'IT087016' => 'Fiumefreddo di Sicilia',
		'IT087017' => 'Giarre',
		'IT087018' => 'Grammichele',
		'IT087019' => 'Gravina di Catania',
		'IT087020' => 'Licodia Eubea',
		'IT087021' => 'Linguaglossa',
		'IT087022' => 'Maletto',
		'IT087023' => 'Mascali',
		'IT087024' => 'Mascalucia',
		'IT087025' => 'Militello in Val di Catania',
		'IT087026' => 'Milo',
		'IT087027' => 'Mineo',
		'IT087028' => 'Mirabella Imbaccari',
		'IT087029' => 'Misterbianco',
		'IT087030' => 'Motta SantAnastasia',
		'IT087031' => 'Nicolosi',
		'IT087032' => 'Palagonia',
		'IT087033' => 'Paternò',
		'IT087034' => 'Pedara',
		'IT087035' => 'Piedimonte Etneo',
		'IT087036' => 'Raddusa',
		'IT087037' => 'Ramacca',
		'IT087038' => 'Randazzo',
		'IT087039' => 'Riposto',
		'IT087040' => 'San Cono',
		'IT087041' => 'San Giovanni la Punta',
		'IT087042' => 'San Gregorio di Catania',
		'IT087043' => 'San Michele di Ganzaria',
		'IT087044' => 'San Pietro Clarenza',
		'IT087045' => 'SantAgata li Battiati',
		'IT087046' => 'SantAlfio',
		'IT087047' => 'Santa Maria di Licodia',
		'IT087048' => 'Santa Venerina',
		'IT087049' => 'Scordia',
		'IT087050' => 'Trecastagni',
		'IT087051' => 'Tremestieri Etneo',
		'IT087052' => 'Valverde',
		'IT087053' => 'Viagrande',
		'IT087054' => 'Vizzini',
		'IT087055' => 'Zafferana Etnea',
		'IT087056' => 'Mazzarrone',
		'IT087057' => 'Maniace',
		'IT087058' => 'Ragalna',
	],
	'RG' => [
		'IT088001' => 'Acate',
		'IT088002' => 'Chiaramonte Gulfi',
		'IT088003' => 'Comiso',
		'IT088004' => 'Giarratana',
		'IT088005' => 'Ispica',
		'IT088006' => 'Modica',
		'IT088007' => 'Monterosso Almo',
		'IT088008' => 'Pozzallo',
		'IT088009' => 'Ragusa',
		'IT088010' => 'Santa Croce Camerina',
		'IT088011' => 'Scicli',
		'IT088012' => 'Vittoria',
	],
	'SR' => [
		'IT089001' => 'Augusta',
		'IT089002' => 'Avola',
		'IT089003' => 'Buccheri',
		'IT089004' => 'Buscemi',
		'IT089005' => 'Canicattini Bagni',
		'IT089006' => 'Carlentini',
		'IT089007' => 'Cassaro',
		'IT089008' => 'Ferla',
		'IT089009' => 'Floridia',
		'IT089010' => 'Francofonte',
		'IT089011' => 'Lentini',
		'IT089012' => 'Melilli',
		'IT089013' => 'Noto',
		'IT089014' => 'Pachino',
		'IT089015' => 'Palazzolo Acreide',
		'IT089016' => 'Rosolini',
		'IT089017' => 'Siracusa',
		'IT089018' => 'Solarino',
		'IT089019' => 'Sortino',
		'IT089020' => 'Portopalo di Capo Passero',
		'IT089021' => 'Priolo Gargallo',
	],
	'SS' => [
		'IT090001' => 'Aggius',
		'IT090002' => 'Alà dei Sardi',
		'IT090003' => 'Alghero',
		'IT090004' => 'Anela',
		'IT090005' => 'Ardara',
		'IT090006' => 'Arzachena',
		'IT090007' => 'Banari',
		'IT090008' => 'Benetutti',
		'IT090009' => 'Berchidda',
		'IT090010' => 'Bessude',
		'IT090011' => 'Bonnanaro',
		'IT090012' => 'Bono',
		'IT090013' => 'Bonorva',
		'IT090014' => 'Bortigiadas',
		'IT090015' => 'Borutta',
		'IT090016' => 'Bottidda',
		'IT090017' => 'Buddusò',
		'IT090018' => 'Bultei',
		'IT090019' => 'Bulzi',
		'IT090020' => 'Burgos',
		'IT090021' => 'Calangianus',
		'IT090022' => 'Cargeghe',
		'IT090023' => 'Castelsardo',
		'IT090024' => 'Cheremule',
		'IT090025' => 'Chiaramonti',
		'IT090026' => 'Codrongianos',
		'IT090027' => 'Cossoine',
		'IT090028' => 'Esporlatu',
		'IT090029' => 'Florinas',
		'IT090030' => 'Giave',
		'IT090031' => 'Illorai',
		'IT090032' => 'Ittireddu',
		'IT090033' => 'Ittiri',
		'IT090034' => 'Laerru',
		'IT090035' => 'La Maddalena',
		'IT090036' => 'Luogosanto',
		'IT090037' => 'Luras',
		'IT090038' => 'Mara',
		'IT090039' => 'Martis',
		'IT090040' => 'Monteleone Rocca Doria',
		'IT090041' => 'Monti',
		'IT090042' => 'Mores',
		'IT090043' => 'Muros',
		'IT090044' => 'Nughedu San Nicolò',
		'IT090045' => 'Nule',
		'IT090046' => 'Nulvi',
		'IT090047' => 'Olbia',
		'IT090048' => 'Olmedo',
		'IT090049' => 'Oschiri',
		'IT090050' => 'Osilo',
		'IT090051' => 'Ossi',
		'IT090052' => 'Ozieri',
		'IT090053' => 'Padria',
		'IT090054' => 'Palau',
		'IT090055' => 'Pattada',
		'IT090056' => 'Perfugas',
		'IT090057' => 'Ploaghe',
		'IT090058' => 'Porto Torres',
		'IT090059' => 'Pozzomaggiore',
		'IT090060' => 'Putifigari',
		'IT090061' => 'Romana',
		'IT090062' => 'Aglientu',
		'IT090063' => 'Santa Teresa Gallura',
		'IT090064' => 'Sassari',
		'IT090065' => 'Sedini',
		'IT090066' => 'Semestene',
		'IT090067' => 'Sennori',
		'IT090068' => 'Siligo',
		'IT090069' => 'Sorso',
		'IT090070' => 'Tempio Pausania',
		'IT090071' => 'Thiesi',
		'IT090072' => 'Tissi',
		'IT090073' => 'Torralba',
		'IT090074' => 'Trinità dAgultu e Vignola',
		'IT090075' => 'Tula',
		'IT090076' => 'Uri',
		'IT090077' => 'Usini',
		'IT090078' => 'Villanova Monteleone',
		'IT090079' => 'Valledoria',
		'IT090080' => 'Telti',
		'IT090081' => 'Badesi',
		'IT090082' => 'Viddalba',
		'IT090083' => 'Golfo Aranci',
		'IT090084' => 'Loiri Porto San Paolo',
		'IT090085' => 'SantAntonio di Gallura',
		'IT090086' => 'Tergu',
		'IT090087' => 'Santa Maria Coghinas',
		'IT090088' => 'Erula',
		'IT090089' => 'Stintino',
		'IT090090' => 'Padru',
		'IT090091' => 'Budoni',
		'IT090092' => 'San Teodoro',
	],
	'NU' => [
		'IT091001' => 'Aritzo',
		'IT091002' => 'Arzana',
		'IT091003' => 'Atzara',
		'IT091004' => 'Austis',
		'IT091005' => 'Bari Sardo',
		'IT091006' => 'Baunei',
		'IT091007' => 'Belvì',
		'IT091008' => 'Birori',
		'IT091009' => 'Bitti',
		'IT091010' => 'Bolotana',
		'IT091011' => 'Borore',
		'IT091012' => 'Bortigali',
		'IT091016' => 'Desulo',
		'IT091017' => 'Dorgali',
		'IT091018' => 'Dualchi',
		'IT091019' => 'Elini',
		'IT091024' => 'Fonni',
		'IT091025' => 'Gadoni',
		'IT091026' => 'Gairo',
		'IT091027' => 'Galtellì',
		'IT091028' => 'Gavoi',
		'IT091031' => 'Girasole',
		'IT091032' => 'Ilbono',
		'IT091033' => 'Irgoli',
		'IT091035' => 'Jerzu',
		'IT091037' => 'Lanusei',
		'IT091038' => 'Lei',
		'IT091039' => 'Loceri',
		'IT091040' => 'Loculi',
		'IT091041' => 'Lodè',
		'IT091042' => 'Lotzorai',
		'IT091043' => 'Lula',
		'IT091044' => 'Macomer',
		'IT091046' => 'Mamoiada',
		'IT091047' => 'Meana Sardo',
		'IT091050' => 'Noragugume',
		'IT091051' => 'Nuoro',
		'IT091055' => 'Oliena',
		'IT091056' => 'Ollolai',
		'IT091057' => 'Olzai',
		'IT091058' => 'Onanì',
		'IT091059' => 'Onifai',
		'IT091060' => 'Oniferi',
		'IT091061' => 'Orani',
		'IT091062' => 'Orgosolo',
		'IT091063' => 'Orosei',
		'IT091064' => 'Orotelli',
		'IT091066' => 'Ortueri',
		'IT091067' => 'Orune',
		'IT091068' => 'Osidda',
		'IT091069' => 'Osini',
		'IT091070' => 'Ottana',
		'IT091071' => 'Ovodda',
		'IT091072' => 'Perdasdefogu',
		'IT091073' => 'Posada',
		'IT091077' => 'Sarule',
		'IT091083' => 'Silanus',
		'IT091084' => 'Sindia',
		'IT091085' => 'Siniscola',
		'IT091086' => 'Sorgono',
		'IT091088' => 'Talana',
		'IT091089' => 'Tertenia',
		'IT091090' => 'Teti',
		'IT091091' => 'Tiana',
		'IT091093' => 'Tonara',
		'IT091094' => 'Torpè',
		'IT091095' => 'Tortolì',
		'IT091097' => 'Triei',
		'IT091098' => 'Ulassai',
		'IT091099' => 'Urzulei',
		'IT091100' => 'Ussassai',
		'IT091101' => 'Villagrande Strisaili',
		'IT091103' => 'Cardedu',
		'IT091104' => 'Lodine',
	],
	'CA' => [
		'IT092003' => 'Assemini',
		'IT092009' => 'Cagliari',
		'IT092011' => 'Capoterra',
		'IT092015' => 'Decimomannu',
		'IT092037' => 'Maracalagonis',
		'IT092050' => 'Pula',
		'IT092051' => 'Quartu SantElena',
		'IT092066' => 'Sarroch',
		'IT092068' => 'Selargius',
		'IT092074' => 'Sestu',
		'IT092075' => 'Settimo San Pietro',
		'IT092080' => 'Sinnai',
		'IT092090' => 'Uta',
		'IT092099' => 'Villa San Pietro',
		'IT092105' => 'Quartucciu',
		'IT092108' => 'Elmas',
		'IT092109' => 'Monserrato',
	],
	'OR' => [
		'IT095001' => 'Abbasanta',
		'IT095002' => 'Aidomaggiore',
		'IT095003' => 'Albagiara',
		'IT095004' => 'Ales',
		'IT095005' => 'Allai',
		'IT095006' => 'Arborea',
		'IT095007' => 'Ardauli',
		'IT095008' => 'Assolo',
		'IT095009' => 'Asuni',
		'IT095010' => 'Baradili',
		'IT095011' => 'Baratili San Pietro',
		'IT095012' => 'Baressa',
		'IT095013' => 'Bauladu',
		'IT095014' => 'Bidonì',
		'IT095015' => 'Bonarcado',
		'IT095016' => 'Boroneddu',
		'IT095017' => 'Busachi',
		'IT095018' => 'Cabras',
		'IT095019' => 'Cuglieri',
		'IT095020' => 'Fordongianus',
		'IT095021' => 'Ghilarza',
		'IT095022' => 'Gonnoscodina',
		'IT095023' => 'Gonnosnò',
		'IT095024' => 'Gonnostramatza',
		'IT095025' => 'Marrubiu',
		'IT095026' => 'Masullas',
		'IT095027' => 'Milis',
		'IT095028' => 'Mogorella',
		'IT095029' => 'Mogoro',
		'IT095030' => 'Morgongiori',
		'IT095031' => 'Narbolia',
		'IT095032' => 'Neoneli',
		'IT095033' => 'Norbello',
		'IT095034' => 'Nughedu Santa Vittoria',
		'IT095035' => 'Nurachi',
		'IT095036' => 'Nureci',
		'IT095037' => 'Ollastra',
		'IT095038' => 'Oristano',
		'IT095039' => 'Palmas Arborea',
		'IT095040' => 'Pau',
		'IT095041' => 'Paulilatino',
		'IT095042' => 'Pompu',
		'IT095043' => 'Riola Sardo',
		'IT095044' => 'Ruinas',
		'IT095045' => 'Samugheo',
		'IT095046' => 'San Nicolò dArcidano',
		'IT095047' => 'Santa Giusta',
		'IT095048' => 'Villa SantAntonio',
		'IT095049' => 'Santu Lussurgiu',
		'IT095050' => 'San Vero Milis',
		'IT095051' => 'Scano di Montiferro',
		'IT095052' => 'Sedilo',
		'IT095053' => 'Seneghe',
		'IT095054' => 'Senis',
		'IT095055' => 'Sennariolo',
		'IT095056' => 'Siamaggiore',
		'IT095057' => 'Siamanna',
		'IT095058' => 'Simala',
		'IT095059' => 'Simaxis',
		'IT095060' => 'Sini',
		'IT095061' => 'Siris',
		'IT095062' => 'Solarussa',
		'IT095063' => 'Sorradile',
		'IT095064' => 'Tadasuni',
		'IT095065' => 'Terralba',
		'IT095066' => 'Tramatza',
		'IT095067' => 'Tresnuraghes',
		'IT095068' => 'Ulà Tirso',
		'IT095069' => 'Uras',
		'IT095070' => 'Usellus',
		'IT095071' => 'Villanova Truschedu',
		'IT095072' => 'Villaurbana',
		'IT095073' => 'Villa Verde',
		'IT095074' => 'Zeddiani',
		'IT095075' => 'Zerfaliu',
		'IT095076' => 'Siapiccia',
		'IT095077' => 'Curcuris',
		'IT095078' => 'Soddì',
		'IT095079' => 'Bosa',
		'IT095080' => 'Flussio',
		'IT095082' => 'Laconi',
		'IT095083' => 'Magomadas',
		'IT095084' => 'Modolo',
		'IT095085' => 'Montresta',
		'IT095086' => 'Sagama',
		'IT095087' => 'Suni',
		'IT095088' => 'Tinnura',
	],
	'SU' => [
		'IT111001' => 'Arbus',
		'IT111002' => 'Armungia',
		'IT111003' => 'Ballao',
		'IT111004' => 'Barrali',
		'IT111005' => 'Barumini',
		'IT111006' => 'Buggerru',
		'IT111007' => 'Burcei',
		'IT111008' => 'Calasetta',
		'IT111009' => 'Carbonia',
		'IT111010' => 'Carloforte',
		'IT111011' => 'Castiadas',
		'IT111012' => 'Collinas',
		'IT111013' => 'Decimoputzu',
		'IT111014' => 'Dolianova',
		'IT111015' => 'Domus de Maria',
		'IT111016' => 'Domusnovas',
		'IT111017' => 'Donori',
		'IT111018' => 'Escalaplano',
		'IT111019' => 'Escolca',
		'IT111020' => 'Esterzili',
		'IT111021' => 'Fluminimaggiore',
		'IT111022' => 'Furtei',
		'IT111023' => 'Genoni',
		'IT111024' => 'Genuri',
		'IT111025' => 'Gergei',
		'IT111026' => 'Gesico',
		'IT111027' => 'Gesturi',
		'IT111028' => 'Giba',
		'IT111029' => 'Goni',
		'IT111030' => 'Gonnesa',
		'IT111031' => 'Gonnosfanadiga',
		'IT111032' => 'Guamaggiore',
		'IT111033' => 'Guasila',
		'IT111034' => 'Guspini',
		'IT111035' => 'Iglesias',
		'IT111036' => 'Isili',
		'IT111037' => 'Las Plassas',
		'IT111038' => 'Lunamatrona',
		'IT111039' => 'Mandas',
		'IT111040' => 'Masainas',
		'IT111041' => 'Monastir',
		'IT111042' => 'Muravera',
		'IT111043' => 'Musei',
		'IT111044' => 'Narcao',
		'IT111045' => 'Nuragus',
		'IT111046' => 'Nurallao',
		'IT111047' => 'Nuraminis',
		'IT111048' => 'Nurri',
		'IT111049' => 'Nuxis',
		'IT111050' => 'Orroli',
		'IT111051' => 'Ortacesus',
		'IT111052' => 'Pabillonis',
		'IT111053' => 'Pauli Arbarei',
		'IT111054' => 'Perdaxius',
		'IT111055' => 'Pimentel',
		'IT111056' => 'Piscinas',
		'IT111057' => 'Portoscuso',
		'IT111058' => 'Sadali',
		'IT111059' => 'Samassi',
		'IT111060' => 'Samatzai',
		'IT111061' => 'San Basilio',
		'IT111062' => 'San Gavino Monreale',
		'IT111063' => 'San Giovanni Suergiu',
		'IT111064' => 'San Nicolò Gerrei',
		'IT111065' => 'San Sperate',
		'IT111066' => 'San Vito',
		'IT111067' => 'Sanluri',
		'IT111068' => 'Santadi',
		'IT111069' => 'SantAndrea Frius',
		'IT111070' => 'SantAnna Arresi',
		'IT111071' => 'SantAntioco',
		'IT111072' => 'Sardara',
		'IT111073' => 'Segariu',
		'IT111074' => 'Selegas',
		'IT111075' => 'Senorbì',
		'IT111076' => 'Serdiana',
		'IT111077' => 'Serramanna',
		'IT111078' => 'Serrenti',
		'IT111079' => 'Serri',
		'IT111080' => 'Setzu',
		'IT111081' => 'Seui',
		'IT111082' => 'Seulo',
		'IT111083' => 'Siddi',
		'IT111084' => 'Siliqua',
		'IT111085' => 'Silius',
		'IT111086' => 'Siurgus Donigala',
		'IT111087' => 'Soleminis',
		'IT111088' => 'Suelli',
		'IT111089' => 'Teulada',
		'IT111090' => 'Tratalias',
		'IT111091' => 'Tuili',
		'IT111092' => 'Turri',
		'IT111093' => 'Ussana',
		'IT111094' => 'Ussaramanna',
		'IT111095' => 'Vallermosa',
		'IT111096' => 'Villacidro',
		'IT111097' => 'Villamar',
		'IT111098' => 'Villamassargia',
		'IT111099' => 'Villanova Tulo',
		'IT111100' => 'Villanovaforru',
		'IT111101' => 'Villanovafranca',
		'IT111102' => 'Villaperuccio',
		'IT111103' => 'Villaputzu',
		'IT111104' => 'Villasalto',
		'IT111105' => 'Villasimius',
		'IT111106' => 'Villasor',
		'IT111107' => 'Villaspeciosa',
	]
];
