<?php

/**
 * List of cities for: Iran
 * Source: https://en.wikipedia.org/wiki/List_of_cities_in_Iran_by_province
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['IR'];

$country_cities = [
	'ABZ' => [
		'IRKARAJ' => _x( 'Karaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARDIS' => _x( 'Fardis', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAMAL' => _x( 'Kamal Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAZARABAD' => _x( 'Nazarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADSHAHR' => _x( 'Mohammadshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASHTGERD' => _x( 'Hashtgerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHDASHT' => _x( 'Mahdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMESHKIN' => _x( 'Meshkin Dasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAHARBAGH' => _x( 'Chaharbagh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR-E' => _x( 'Shahr-e Jadid-e Hashtgerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESHTEHARD' => _x( 'Eshtehard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARMDARREH' => _x( 'Garmdarreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLSAR' => _x( 'Golsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHSAR' => _x( 'Kuhsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTALEQAN' => _x( 'Taleqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASARA' => _x( 'Asara', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTANKAMAN' => _x( 'Tankaman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'ADL' => [
		'IRARDABIL' => _x( 'Ardabil', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARSABAD' => _x( 'Parsabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMESHGINSHAHR' => _x( 'Meshginshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHALKHAL' => _x( 'Khalkhal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGERMI' => _x( 'Germi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBILEH' => _x( 'Bileh Savar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAMIN' => _x( 'Namin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAFARABAD' => _x( 'Jafarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIVI' => _x( 'Kivi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANBARAN' => _x( 'Anbaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABI' => _x( 'Abi Beyglu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIR' => _x( 'Nir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASHATJIN' => _x( 'Hashatjin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAREYN' => _x( 'Sareyn', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASLAN' => _x( 'Aslan Duz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESLAMABAD-E' => _x( 'Eslamabad-e Qadim', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAZEH_QADMIN' => _x( 'Tazeh Kand-e Qadim', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQASABEH' => _x( 'Qasabeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAHRUD' => _x( 'Lahrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHIR' => _x( 'Hir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOLOWR' => _x( 'Kolowr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZEY' => _x( 'Razey', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAZEH_ANGUT' => _x( 'Tazeh Kand-e Angut', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFAKHRABAD' => _x( 'Fakhrabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKURAIM' => _x( 'Kuraim', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMORADLU' => _x( 'Moradlu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'BHR' => [
		'IRBUSHEHR' => _x( 'Bushehr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBORAZJAN' => _x( 'Borazjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_G' => _x( 'Bandar Ganaveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORMOJ' => _x( 'Khormoj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_K' => _x( 'Bandar Kangan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAM' => _x( 'Jam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_D' => _x( 'Bandar Deylam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR-E' => _x( 'Bandar-e Deyr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALI' => _x( 'Ali Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHOGHADAK' => _x( 'Choghadak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAB' => _x( 'Ab Pakhsh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHRAM' => _x( 'Ahram', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVAHDATIYEH' => _x( 'Vahdatiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAKI' => _x( 'Kaki', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANK' => _x( 'Bank', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAKHL' => _x( 'Nakhl Taqi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASALUYEH' => _x( 'Asaluyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHARG' => _x( 'Kharg', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDALAKI' => _x( 'Dalaki', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSADABAD' => _x( 'Sadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHABANKAREH' => _x( 'Shabankareh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABDAN' => _x( 'Abdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_R' => _x( 'Bandar Rig', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARDESTAN' => _x( 'Bardestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBORD' => _x( 'Bord Khun', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDELVAR' => _x( 'Delvar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_S' => _x( 'Bandar Siraf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOWRAHAK' => _x( 'Dowrahak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBADULEH' => _x( 'Baduleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTANG-E' => _x( 'Tang-e Eram', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABAD' => _x( 'Abad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANARESTAN' => _x( 'Anarestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHONBEH' => _x( 'Shonbeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIMAM' => _x( 'Imam Hassan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALAMEH' => _x( 'Kalameh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRIZ' => _x( 'Riz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUSHKAN' => _x( 'Bushkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'CHB' => [
		'IRSHAHR-E' => _x( 'Shahr-e Kord', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBORUJEN' => _x( 'Borujen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARSAN' => _x( 'Farsan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARROKH' => _x( 'Farrokh Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLORDEGAN' => _x( 'Lordegan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAFSHEJAN' => _x( 'Hafshejan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAMAN' => _x( 'Saman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJUNQAN' => _x( 'Junqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIAN' => _x( 'Kian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARADONBEH' => _x( 'Faradonbeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEN' => _x( 'Ben', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSURESHJAN' => _x( 'Sureshjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBABAHEYDAR' => _x( 'Babaheydar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOLDAJI' => _x( 'Boldaji', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARDAL' => _x( 'Ardal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAQNEH' => _x( 'Naqneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARDANJAN' => _x( 'Pardanjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHALAMZAR' => _x( 'Shalamzar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGAHRU' => _x( 'Gahru', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGUJAN' => _x( 'Gujan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEFIDDASHT' => _x( 'Sefiddasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGANDOMAN' => _x( 'Gandoman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAQANAK' => _x( 'Taqanak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDASHT' => _x( 'Sardasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUDJAN' => _x( 'Sudjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAGHAN' => _x( 'Naghan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASTANA' => _x( 'Dastana', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHOLICHEH' => _x( 'Cholicheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARDANJAN' => _x( 'Vardanjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAJ' => _x( 'Kaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASHTAK' => _x( 'Dashtak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAFECH' => _x( 'Nafech', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAL-E' => _x( 'Mal-e Khalifeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHELGARD' => _x( 'Chelgard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALUNI' => _x( 'Aluni', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHARUNI' => _x( 'Haruni', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAR' => _x( 'Sar Khun', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAZOFT' => _x( 'Bazoft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMANJ-E' => _x( 'Manj-e Nesa', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAMSAMI' => _x( 'Samsami', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAZERBAIJAN' => _x( 'Azerbaijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EAZ' => [
		'IRTABRIZ' => _x( 'Tabriz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARAGHEH' => _x( 'Maragheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARAND' => _x( 'Marand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHAR' => _x( 'Ahar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIANEH' => _x( 'Mianeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBONAB' => _x( 'Bonab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAHAND' => _x( 'Sahand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARAB' => _x( 'Sarab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAZARSHAHR' => _x( 'Azarshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHADISHAHR' => _x( 'Hadishahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAJAB' => _x( 'Ajab Shir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDRUD' => _x( 'Sardrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMALEKAN' => _x( 'Malekan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHABESTAR' => _x( 'Shabestar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOSTANABAD' => _x( 'Bostanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASHTRUD' => _x( 'Hashtrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IROSKU' => _x( 'Osku', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRILKHCHI' => _x( 'Ilkhchi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAMQAN' => _x( 'Mamqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOSROWSHAH' => _x( 'Khosrowshah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBASMENJ' => _x( 'Basmenj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGUGAN' => _x( 'Gugan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHERIS' => _x( 'Heris', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRYAMCHI' => _x( 'Yamchi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALEYBAR' => _x( 'Kaleybar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHENDABAD' => _x( 'Shendabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUFIAN' => _x( 'Sufian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOLFA' => _x( 'Jolfa', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOSHKSARAY' => _x( 'Koshksaray', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTASUJ' => _x( 'Tasuj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTORKAMANCHAY' => _x( 'Torkamanchay', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOLVANAQ' => _x( 'Kolvanaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLEYLAN' => _x( 'Leylan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIS' => _x( 'Sis', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAKHSHAYESH' => _x( 'Bakhshayesh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQARAH' => _x( 'Qarah Aghaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHRABAN' => _x( 'Mehraban', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTEYMURLU' => _x( 'Teymurlu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARZAQAN' => _x( 'Varzaqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARNAQ' => _x( 'Zarnaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHURAND' => _x( 'Hurand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAJEH' => _x( 'Khajeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBENAB' => _x( 'Benab e Marand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHARABIAN' => _x( 'Sharabian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVAYQAN' => _x( 'Vayqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOBARAK' => _x( 'Mobarak Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHARAFKHANEH' => _x( 'Sharafkhaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUZEH' => _x( 'Kuzeh Kanan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRACHACHI' => _x( 'Achachi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDUZDUZAN' => _x( 'Duzduzan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHARVANA' => _x( 'Kharvana', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAMANEH' => _x( 'Khamaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTEKMEH' => _x( 'Tekmeh Dash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAQKAND' => _x( 'Aqkand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABISH' => _x( 'Abish Ahmad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZONUZ' => _x( 'Zonuz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTARK' => _x( 'Tark', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOMARLU' => _x( 'Khomarlu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHARAJU' => _x( 'Kharaju', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIAH' => _x( 'Siah Rud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAZARKAHRIZI' => _x( 'Nazarkahrizi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOWAN' => _x( 'Jowan Qaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIAN' => _x( 'Kian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'ESF' => [
		'IRISFAHAN' => _x( 'Isfahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKASHAN' => _x( 'Kashan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOMEYNI' => _x( 'Khomeyni Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAJAFABAD' => _x( 'Najafabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHIN' => _x( 'Shahin Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHREZA' => _x( 'Shahreza', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFULADSHAHR' => _x( 'Fuladshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHARESTAN' => _x( 'Baharestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOBARAKEH' => _x( 'Mobarakeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARAN' => _x( 'Aran va Bidgol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLPAYEGAN' => _x( 'Golpayegan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARRIN' => _x( 'Zarrin Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDORCHEH' => _x( 'Dorcheh Piaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOWLATABAD' => _x( 'Dowlatabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFALAVARJAN' => _x( 'Falavarjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAHDERIJAN' => _x( 'Qahderijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHVORZUQ' => _x( 'Khvorzuq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAIN' => _x( 'Nain', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEMIROM' => _x( 'Semirom', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKELISHAD' => _x( 'Kelishad va Sudarjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLDASHT' => _x( 'Goldasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGAZ' => _x( 'Gaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABRISHAM' => _x( 'Abrisham', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHANSAR' => _x( 'Khansar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTIRAN' => _x( 'Tiran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARAN' => _x( 'Daran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEDEH' => _x( 'Sedeh Lenjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDIZICHEH' => _x( 'Dizicheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARNAMKHAST' => _x( 'Varnamkhast', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHAQAN' => _x( 'Dehaqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASTGERD' => _x( 'Dastgerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARDESTAN' => _x( 'Ardestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAMGARDAN' => _x( 'Chamgardan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBADRUD' => _x( 'Badrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIMANSHAHR' => _x( 'Imanshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNATANZ' => _x( 'Natanz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHERMAHIN' => _x( 'Chermahin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFEREYDUNSHAHR' => _x( 'Fereydunshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPIR' => _x( 'Pir Bakran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUSHK' => _x( 'Kushk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARZANEH' => _x( 'Varzaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNUSHABAD' => _x( 'Nushabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHARAN' => _x( 'Baharan Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAHRIZ' => _x( 'Kahriz Sang', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAGH-E' => _x( 'Bagh-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIBASHAHR' => _x( 'Zibashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHADEGAN' => _x( 'Chadegan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTALKHUNCHEH' => _x( 'Talkhuncheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLSHAHR' => _x( 'Golshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUIN' => _x( 'Buin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAHJAVERESTAN' => _x( 'Qahjaverestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAYANDEH' => _x( 'Zayandeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGORGAB' => _x( 'Gorgab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHABIBABAD' => _x( 'Habibabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAJLESI' => _x( 'Majlesi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAVAREH' => _x( 'Zavareh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHAQ' => _x( 'Dehaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALAVICHEH' => _x( 'Alavicheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAZERAN' => _x( 'Zazeran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMANZARIYEH' => _x( 'Manzariyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKARKEVAND' => _x( 'Karkevand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASGHARABAD' => _x( 'Asgharabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUR' => _x( 'Khur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASRABAD' => _x( 'Nasrabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGUGED' => _x( 'Guged', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHARAND' => _x( 'Harand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOWZDAN' => _x( 'Jowzdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHADPURABAD' => _x( 'Shadpurabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABUZEYDABAD' => _x( 'Abuzeydabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEFIDSHAHR' => _x( 'Sefidshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYMEH' => _x( 'Meymeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARF' => _x( 'Barf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMESHKAT' => _x( 'Meshkat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHANA' => _x( 'Hana', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROZVEH' => _x( 'Rozveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOMESHCHEH' => _x( 'Komeshcheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVAZVAN' => _x( 'Vazvan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHPAYEH' => _x( 'Kuhpayeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIN' => _x( 'Sin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLSHAN' => _x( 'Golshan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAMANEH' => _x( 'Damaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAGZI' => _x( 'Sagzi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASANABAD' => _x( 'Hasanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIKABAD' => _x( 'Nikabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADABAD' => _x( 'Mohammadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHABAD' => _x( 'Mahabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASGARAN' => _x( 'Asgaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJANDAQ' => _x( 'Jandaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAGHSHAD' => _x( 'Baghshad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTUDESHK' => _x( 'Tudeshk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOWSHEQAN' => _x( 'Jowsheqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIAR' => _x( 'Ziar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAMSAR' => _x( 'Qamsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAFUS' => _x( 'Afus', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRREZVANSHAHR' => _x( 'Rezvanshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREZHIYEH' => _x( 'Ezhiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHALEDABAD' => _x( 'Khaledabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARROKHI' => _x( 'Farrokhi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAMU' => _x( 'Kamu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARZOK' => _x( 'Barzok', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTARQ' => _x( 'Tarq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVANAK' => _x( 'Vanak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOMEH' => _x( 'Komeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEYASAR' => _x( 'Neyasar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAFRAN' => _x( 'Bafran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANARAK' => _x( 'Anarak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAY' => _x( 'Lay', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'FRS' => [
		'IRSHIRAZ' => _x( 'Shiraz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARVDASHT' => _x( 'Marvdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAHROM' => _x( 'Jahrom', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFASA' => _x( 'Fasa', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAZERUN' => _x( 'Kazerun', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSADRA' => _x( 'Sadra', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARAB' => _x( 'Darab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRUZABAD' => _x( 'Firuzabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAR' => _x( 'Lar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABADEH' => _x( 'Abadeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNURABAD' => _x( 'Nurabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEYRIZ' => _x( 'Neyriz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREQLID' => _x( 'Eqlid', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESTAHBAN' => _x( 'Estahban', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGERASH' => _x( 'Gerash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARQAN' => _x( 'Zarqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAVAR' => _x( 'Kavar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAMERD' => _x( 'Lamerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAFASHAHR' => _x( 'Safashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAEMIYEH' => _x( 'Qaemiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAJJIABAD' => _x( 'Hajjiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARASHBAND' => _x( 'Farashband', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQIR' => _x( 'Qir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREVAZ' => _x( 'Evaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHONJ' => _x( 'Khonj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHARAMEH' => _x( 'Kharameh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARVESTAN' => _x( 'Sarvestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARSANJAN' => _x( 'Arsanjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAADAT' => _x( 'Saadat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQADERABAD' => _x( 'Qaderabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARDAKAN' => _x( 'Ardakan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOBIRAN' => _x( 'Dobiran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJANNAT' => _x( 'Jannat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGALLEH' => _x( 'Galleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOGHAD' => _x( 'Soghad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYMAND' => _x( 'Meymand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARIAN' => _x( 'Darian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAHEDSHAHR' => _x( 'Zahedshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHESHT' => _x( 'Khesht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSURIAN' => _x( 'Surian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANARUIYEH' => _x( 'Banaruiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMASIRI' => _x( 'Masiri', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAPUI' => _x( 'Lapui', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKARZIN' => _x( 'Karzin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEYYEDAN' => _x( 'Seyyedan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESHKANAN' => _x( 'Eshkanan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR-E' => _x( 'Shahr-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEYRAM' => _x( 'Beyram', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHMAN' => _x( 'Bahman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQOTBABAD' => _x( 'Qotbabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJUYOM' => _x( 'Juyom', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABADEH' => _x( 'Abadeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUR' => _x( 'Khur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHR' => _x( 'Mohr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEYZA' => _x( 'Beyza', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLATIFI' => _x( 'Latifi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAB' => _x( 'Bab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQARAH' => _x( 'Qarah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIJ' => _x( 'Ij', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUMEH' => _x( 'Khumeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKONARTAKHTEH' => _x( 'Konartakhteh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIYANSHAHR' => _x( 'Miyanshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIZADKHAST' => _x( 'Izadkhast', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREMAM' => _x( 'Emam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUNIZ' => _x( 'Runiz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOBARAKABAD' => _x( 'Mobarakabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEDEH' => _x( 'Sedeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHESHDEH' => _x( 'Sheshdeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAVARAN' => _x( 'Khavaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMESHKAN' => _x( 'Meshkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARAVI' => _x( 'Varavi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREMAD' => _x( 'Emad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFADAMI' => _x( 'Fadami', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALAMARVDASHT' => _x( 'Alamarvdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHANEH' => _x( 'Khaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBALADEH' => _x( 'Baladeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNUJIN' => _x( 'Nujin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOREHI' => _x( 'Korehi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEZHKORD' => _x( 'Dezhkord', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSURMAQ' => _x( 'Surmaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAZAYJAN' => _x( 'Mazayjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHRAM' => _x( 'Dehram', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHENJAN' => _x( 'Kuhenjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUZI' => _x( 'Khuzi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUPON' => _x( 'Kupon', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOW' => _x( 'Now', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHEL' => _x( 'Ahel', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHESAMI' => _x( 'Hesami', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHANIMAN' => _x( 'Khaniman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDO' => _x( 'Do', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQATRUYEH' => _x( 'Qatruyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWDAN' => _x( 'Nowdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAMFIRUZ' => _x( 'Kamfiruz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAMASHAHR' => _x( 'Hamashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREFZAR' => _x( 'Efzar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASIR' => _x( 'Asir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAMJERD' => _x( 'Ramjerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASANABAD' => _x( 'Hasanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOLTAN' => _x( 'Soltan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMADAR-E' => _x( 'Madar-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBABA' => _x( 'Baba', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDUZEH' => _x( 'Duzeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GIL' => [
		'IRRASHT' => _x( 'Rasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR-E' => _x( 'Bandar-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAHIJAN' => _x( 'Lahijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLANGARUD' => _x( 'Langarud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASHTPAR' => _x( 'Hashtpar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASTARA' => _x( 'Astara', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOWMEEH' => _x( 'Sowmeeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASTANEH-YE' => _x( 'Astaneh-ye', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDSAR' => _x( 'Rudsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFUMAN' => _x( 'Fuman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOMAM' => _x( 'Khomam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIAHKAL' => _x( 'Siahkal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRREZVANSHAHR' => _x( 'Rezvanshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMANJIL' => _x( 'Manjil', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAMLASH' => _x( 'Amlash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIASHAHR' => _x( 'Kiashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROSTAMABAD' => _x( 'Rostamabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLOWSHAN' => _x( 'Lowshan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDBAR' => _x( 'Rudbar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKELACHAY' => _x( 'Kelachay', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMASAL' => _x( 'Masal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLASHT-E' => _x( 'Lasht-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAVANDEVIL' => _x( 'Lavandevil', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUCHESFAHAN' => _x( 'Kuchesfahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASALEM' => _x( 'Asalem', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAHIMABAD' => _x( 'Rahimabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSANGAR' => _x( 'Sangar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAF' => _x( 'Chaf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHABOKSAR' => _x( 'Chaboksar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAFT' => _x( 'Shaft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPAREH' => _x( 'Pareh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLULEMAN' => _x( 'Luleman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOSHK-E' => _x( 'Khoshk-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARJAGHAL' => _x( 'Marjaghal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUMELEH' => _x( 'Kumeleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHALMAN' => _x( 'Shalman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAZAR' => _x( 'Bazar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHUBAR' => _x( 'Chubar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGURAB' => _x( 'Gurab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVAJARGAH' => _x( 'Vajargah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAVIQ' => _x( 'Haviq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDBONEH' => _x( 'Rudboneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLISAR' => _x( 'Lisar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJIRANDEH' => _x( 'Jirandeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRANKUH' => _x( 'Rankuh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHMADSARGURAB' => _x( 'Ahmadsargurab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAKLAVAN' => _x( 'Maklavan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTUTKABON' => _x( 'Tutkabon', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAREHSAR' => _x( 'Barehsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IROTAQVAR' => _x( 'Otaqvar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEYLAMAN' => _x( 'Deylaman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMASULEH' => _x( 'Masuleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPROVINCE' => _x( 'Province', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GLS' => [
		'IRGORGAN' => _x( 'Gorgan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGONBAD-E' => _x( 'Gonbad-e Kavus', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALIABAD-E' => _x( 'Aliabad-e Katul', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_T' => _x( 'Bandar Torkaman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAZADSHAHR' => _x( 'Azadshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKORDKUY' => _x( 'Kordkuy', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALALEH' => _x( 'Kalaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAQQALA' => _x( 'Aqqala', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMINUDASHT' => _x( 'Minudasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGALIKASH' => _x( 'Galikash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR-E_G' => _x( 'Bandar-e Gaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOMISHAN' => _x( 'Gomishan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIMINSHAHR' => _x( 'Siminshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFAZELABAD' => _x( 'Fazelabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAMIAN' => _x( 'Ramian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAN' => _x( 'Khan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDALAND' => _x( 'Daland', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEGINSHAHR' => _x( 'Neginshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOW' => _x( 'Now', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARKHON' => _x( 'Sarkhon', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJELIN-E' => _x( 'Jelin-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANBAR' => _x( 'Anbar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARAVEH' => _x( 'Maraveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARAGHI' => _x( 'Faraghi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTATAR-E' => _x( 'Tatar-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSANGDEVIN' => _x( 'Sangdevin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAZRAEH' => _x( 'Mazraeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOW' => _x( 'Now', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRINCHEH' => _x( 'Incheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'HDN' => [
		'IRHAMADAN' => _x( 'Hamadan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMALAYER' => _x( 'Malayer', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASADABAD' => _x( 'Asadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAHAVAND' => _x( 'Nahavand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTUYSERKAN' => _x( 'Tuyserkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHAR' => _x( 'Bahar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKABUDARAHANG' => _x( 'Kabudarahang', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLALEJIN' => _x( 'Lalejin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFAMENIN' => _x( 'Famenin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZAN' => _x( 'Razan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARYANAJ' => _x( 'Maryanaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAZANDARIAN' => _x( 'Azandarian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQORVEH-E' => _x( 'Qorveh-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJURAQAN' => _x( 'Juraqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGIYAN' => _x( 'Giyan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAJERAN' => _x( 'Mohajeran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEHABAD' => _x( 'Salehabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARKAN' => _x( 'Sarkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRUZAN' => _x( 'Firuzan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAMEN' => _x( 'Samen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAMAQ' => _x( 'Damaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARZUL' => _x( 'Barzul', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAHAVAND' => _x( 'Qahavand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAJIN' => _x( 'Ajin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHIRIN' => _x( 'Shirin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOWKAR' => _x( 'Jowkar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOL' => _x( 'Gol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARASFAJ' => _x( 'Farasfaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZANGENEH' => _x( 'Zangeneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'HRZ' => [
		'IRBANDAR_AB' => _x( 'Bandar Abbas', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMINAB' => _x( 'Minab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQESHM' => _x( 'Qeshm', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDAN' => _x( 'Rudan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_L' => _x( 'Bandar Lengeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKISH' => _x( 'Kish', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAJJIABAD' => _x( 'Hajjiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKONG' => _x( 'Kong', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARGAHAN' => _x( 'Dargahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_KH' => _x( 'Bandar Khamir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJASK' => _x( 'Jask', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARSIAN' => _x( 'Parsian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBASTAK' => _x( 'Bastak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBIKA' => _x( 'Bika', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJENAH' => _x( 'Jenah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASHT' => _x( 'Hasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUYDAR' => _x( 'Ruydar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHORMUZ' => _x( 'Hormuz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUZA' => _x( 'Suza', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALEH' => _x( 'Qaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIRIK' => _x( 'Sirik', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTIRUR' => _x( 'Tirur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASHTI' => _x( 'Dashti', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAZIAN-E' => _x( 'Tazian-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABU' => _x( 'Abu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR_CH' => _x( 'Bandar Charak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARUK' => _x( 'Garuk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIARAT-E' => _x( 'Ziarat-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIN' => _x( 'Fin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUSHK-E' => _x( 'Kushk-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAKHT' => _x( 'Takht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHESTAK' => _x( 'Kuhestak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAMAZAN' => _x( 'Lamazan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSENDERK' => _x( 'Senderk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFAREGHAN' => _x( 'Fareghan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDASHT' => _x( 'Sardasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOWHARAN' => _x( 'Gowharan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARGAZ' => _x( 'Sargaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'ILM' => [
		'IRILAM' => _x( 'Ilam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABDANAN' => _x( 'Abdanan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREYVAN' => _x( 'Eyvan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHLORAN' => _x( 'Dehloran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARREH' => _x( 'Darreh Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARAKVAZ' => _x( 'Arakvaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHRAN' => _x( 'Mehran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARABLEH' => _x( 'Sarableh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASEMANABAD' => _x( 'Asemanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTOWHID' => _x( 'Towhid', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAVAR' => _x( 'Chavar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBADREH' => _x( 'Badreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHABAB' => _x( 'Shabab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPAHLEH' => _x( 'Pahleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDELGOSHA' => _x( 'Delgosha', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMURMURI' => _x( 'Murmuri', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARNEH' => _x( 'Zarneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLUMAR' => _x( 'Lumar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMUSIAN' => _x( 'Musian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYMEH' => _x( 'Meymeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARABBAGH' => _x( 'Sarabbagh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEHABAD' => _x( 'Salehabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIRZA' => _x( 'Mirza', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHR' => _x( 'Mehr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBALAVAH' => _x( 'Balavah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KRN' => [
		'IRKERMAN' => _x( 'Kerman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIRJAN' => _x( 'Sirjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAFSANJAN' => _x( 'Rafsanjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJIROFT' => _x( 'Jiroft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAM' => _x( 'Bam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARAND' => _x( 'Zarand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAHNUJ' => _x( 'Kahnuj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR-E_B' => _x( 'Shahr-e Babak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAFT' => _x( 'Baft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARDSIR' => _x( 'Bardsir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARAVAT' => _x( 'Baravat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAVAR' => _x( 'Ravar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMADABAD' => _x( 'Mohamadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAJAF' => _x( 'Najaf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHAN' => _x( 'Mahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANBARABAD' => _x( 'Anbarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMANUJAN' => _x( 'Manujan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANAR' => _x( 'Anar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDBAR' => _x( 'Rudbar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRABOR' => _x( 'Rabor', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALEH' => _x( 'Qaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHBANAN' => _x( 'Kuhbanan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARB-E' => _x( 'Darb-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAGHIN' => _x( 'Baghin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAYEN' => _x( 'Rayen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEGAR' => _x( 'Negar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMES-E' => _x( 'Mes-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREKHTIARABAD' => _x( 'Ekhtiarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLBAF' => _x( 'Golbaf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZEYDABAD' => _x( 'Zeydabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZANGIABAD' => _x( 'Zangiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHURSAND' => _x( 'Khursand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARIZ' => _x( 'Pariz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHAJ' => _x( 'Dehaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOSHKUIYEH' => _x( 'Koshkuiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLZAR' => _x( 'Golzar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADABAD-E' => _x( 'Mohammadabad-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFAHRAJ' => _x( 'Fahraj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARZUIYEH' => _x( 'Arzuiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZEH-E' => _x( 'Zeh-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJEBALBAREZ' => _x( 'Jebalbarez', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHATRUD' => _x( 'Chatrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRYAZDAN' => _x( 'Yazdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWDEZH' => _x( 'Nowdezh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARYAB' => _x( 'Faryab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRREYHAN' => _x( 'Reyhan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIAN' => _x( 'Kian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEZENJAN' => _x( 'Bezenjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLALEHZAR' => _x( 'Lalehzar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAMINSHAHR' => _x( 'Aminshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOW' => _x( 'Dow', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOLUK' => _x( 'Boluk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHREMAN' => _x( 'Bahreman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNARMASHIR' => _x( 'Narmashir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHDAD' => _x( 'Shahdad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHATUNABAD' => _x( 'Khatunabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJUPAR' => _x( 'Jupar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBALVARD' => _x( 'Balvard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOWZAM' => _x( 'Jowzam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAZEMABAD' => _x( 'Kazemabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHANUK' => _x( 'Khanuk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHIABAD' => _x( 'Mohiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANDUHJERD' => _x( 'Anduhjerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHVAJU' => _x( 'Khvaju', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAFAYYEH' => _x( 'Safayyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAMASHAHR' => _x( 'Hamashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASHTKAR' => _x( 'Dashtkar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARDEHEK' => _x( 'Mardehek', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEZAMSHAHR' => _x( 'Nezamshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHANZA' => _x( 'Hanza', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHOJEDK' => _x( 'Hojedk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KRH' => [
		'IRKERMANSHAH' => _x( 'Kermanshah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESLAMABAD-E' => _x( 'Eslamabad-e Gharb', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKANGAVAR' => _x( 'Kangavar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHARSIN' => _x( 'Harsin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAVANRUD' => _x( 'Javanrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARPOL-E' => _x( 'Sarpol-e Zahab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSONQOR' => _x( 'Sonqor', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAHNEH' => _x( 'Sahneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGILAN-E' => _x( 'Gilan-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPAVEH' => _x( 'Paveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAVANSAR' => _x( 'Ravansar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQASR-E' => _x( 'Qasr-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAZEHABAD' => _x( 'Tazehabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKEREND-GHARB' => _x( 'Kerend-Gharb', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGAHVAREH' => _x( 'Gahvareh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUZARAN' => _x( 'Kuzaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANEVREH' => _x( 'Banevreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOWDIN' => _x( 'Gowdin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWDESHAH' => _x( 'Nowdeshah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRAK-E' => _x( 'Shahrak-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHU' => _x( 'Shahu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARMAST' => _x( 'Sarmast', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBISOTUN' => _x( 'Bisotun', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAYANGAN' => _x( 'Bayangan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWSUD' => _x( 'Nowsud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREZGELEH' => _x( 'Ezgeleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHOMEYL' => _x( 'Homeyl', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSATAR' => _x( 'Satar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROBAT' => _x( 'Robat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIYAN' => _x( 'Miyan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHALASHI' => _x( 'Halashi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUMAR' => _x( 'Sumar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KHZ' => [
		'IRAHVAZ' => _x( 'Ahvaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEZFUL' => _x( 'Dezful', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABADAN' => _x( 'Abadan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR-E_M' => _x( 'Bandar-e Mahshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANDIMESHK' => _x( 'Andimeshk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORRAMSHAHR' => _x( 'Khorramshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEHBAHAN' => _x( 'Behbahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIZEH' => _x( 'Izeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHUSHTAR' => _x( 'Shushtar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMASJED_S' => _x( 'Masjed Soleyman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IROMIDIYEH' => _x( 'Omidiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANDAR-E_EM' => _x( 'Bandar-e Emam Khomeyni', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUT-E' => _x( 'Kut-e Abdollah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHUSH' => _x( 'Shush', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAMHORMOZ' => _x( 'Ramhormoz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHADEGAN' => _x( 'Shadegan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUSANGERD' => _x( 'Susangerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHENDIJAN' => _x( 'Hendijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAMSHIR' => _x( 'Ramshir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHEYBAN' => _x( 'Sheyban', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAMIDIYEH' => _x( 'Hamidiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOTVAND' => _x( 'Gotvand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAGH-E' => _x( 'Bagh-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAMRAN' => _x( 'Chamran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLALI' => _x( 'Lali', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAFTKEL' => _x( 'Haftkel', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHOVEYZEH' => _x( 'Hoveyzeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVEYS' => _x( 'Veys', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOLLASANI' => _x( 'Mollasani', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAGHAJARI' => _x( 'Aghajari', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHARAFT' => _x( 'Sharaft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEZAB' => _x( 'Dezab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARVANDKENAR' => _x( 'Arvandkenar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAMSABAD' => _x( 'Shamsabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIANRUD' => _x( 'Mianrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALEH' => _x( 'Qaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAFIABAD' => _x( 'Safiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHORR' => _x( 'Horr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHOSSEINABAD' => _x( 'Hosseinabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOSTAN' => _x( 'Bostan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAVIBDEH' => _x( 'Chavibdeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRELHAYI' => _x( 'Elhayi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEYDUN' => _x( 'Seydun', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEH' => _x( 'Saleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDASHT' => _x( 'Sardasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALVAN' => _x( 'Alvan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAMZEH' => _x( 'Hamzeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTORKALAKI' => _x( 'Torkalaki', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARKHOVEYN' => _x( 'Darkhoveyn', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIAH' => _x( 'Siah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJANNAT' => _x( 'Jannat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABU' => _x( 'Abu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHDEZ' => _x( 'Dehdez', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAM' => _x( 'Cham', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMANSURIYEH' => _x( 'Mansuriyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDARAN' => _x( 'Sardaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRAK-E' => _x( 'Shahrak-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUT-E' => _x( 'Kut-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTASHAN' => _x( 'Tashan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHANAFEREH' => _x( 'Khanafereh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAFI' => _x( 'Rafi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYDAVUD' => _x( 'Meydavud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEH' => _x( 'Saleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGURIYEH' => _x( 'Guriyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAYEZAN' => _x( 'Jayezan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALAND' => _x( 'Saland', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMINUSHAHR' => _x( 'Minushahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALEH-YE' => _x( 'Qaleh-ye', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBIDRUBEH' => _x( 'Bidrubeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOSHRAGEH' => _x( 'Moshrageh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHOGHAMISH' => _x( 'Choghamish', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHOSEYNIYEH' => _x( 'Hoseyniyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOMALEH' => _x( 'Somaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABEZHDAN' => _x( 'Abezhdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAHREH' => _x( 'Zahreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLGIR' => _x( 'Golgir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR' => _x( 'Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KBD' => [
		'IRYASUJ' => _x( 'Yasuj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOGONBADAN' => _x( 'Dogonbadan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHDASHT' => _x( 'Dehdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHARAM' => _x( 'Charam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLIKAK' => _x( 'Likak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMADAVAN' => _x( 'Madavan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLANDEH' => _x( 'Landeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBASHT' => _x( 'Basht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSISAKHT' => _x( 'Sisakht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSUQ' => _x( 'Suq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDISHMOK' => _x( 'Dishmok', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALEH' => _x( 'Qaleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARGOWN' => _x( 'Margown', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPATAVEH' => _x( 'Pataveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARFARYAB' => _x( 'Sarfaryab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHITAB' => _x( 'Chitab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARAB-E' => _x( 'Garab-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'KRD' => [
		'IRSANANDAJ' => _x( 'Sanandaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAQQEZ' => _x( 'Saqqez', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQORVEH' => _x( 'Qorveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARIVAN' => _x( 'Marivan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBANEH' => _x( 'Baneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAMYARAN' => _x( 'Kamyaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDIVANDARREH' => _x( 'Divandarreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBIJAR' => _x( 'Bijar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEHGOLAN' => _x( 'Dehgolan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKANI' => _x( 'Kani', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSERISHABAD' => _x( 'Serishabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDELBARAN' => _x( 'Delbaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARVABAD' => _x( 'Sarvabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOLBANABAD' => _x( 'Bolbanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRYASUKAND' => _x( 'Yasukand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMUCHESH' => _x( 'Muchesh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAAVRAMAN' => _x( 'Aavraman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEZEJ' => _x( 'Dezej', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARMARDEH' => _x( 'Armardeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAHEB' => _x( 'Saheb', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARRINEH' => _x( 'Zarrineh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTUP' => _x( 'Tup', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUIN-E' => _x( 'Buin-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHUYESHEH' => _x( 'Shuyesheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKANI' => _x( 'Kani', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPIR' => _x( 'Pir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARDEH' => _x( 'Bardeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBABARASHANI' => _x( 'Babarashani', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHENAREH' => _x( 'Chenareh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'LRS' => [
		'IRKHORRAMABAD' => _x( 'Khorramabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBORUJERD' => _x( 'Borujerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDORUD' => _x( 'Dorud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHDASHT' => _x( 'Kuhdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALIGUDARZ' => _x( 'Aligudarz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNURABAD' => _x( 'Nurabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAZNA' => _x( 'Azna', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALESHTAR' => _x( 'Aleshtar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPOL-E' => _x( 'Pol-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUNANI' => _x( 'Kunani', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAMULAN' => _x( 'Mamulan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAQABOL' => _x( 'Chaqabol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IROSHTORINAN' => _x( 'Oshtorinan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARAB' => _x( 'Garab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEPIDDASHT' => _x( 'Sepiddasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRUZABAD' => _x( 'Firuzabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAGHEH' => _x( 'Zagheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARB-E' => _x( 'Darb-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVEYSIAN' => _x( 'Veysian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAYRANSHAHR' => _x( 'Bayranshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARAB-E' => _x( 'Sarab-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOMENABAD' => _x( 'Momenabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHALANCHULAN' => _x( 'Chalanchulan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHULEHABAD-E' => _x( 'Shulehabad-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAFT' => _x( 'Haft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'MKZ' => [
		'IRARAK' => _x( 'Arak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAVEH' => _x( 'Saveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOMEYN' => _x( 'Khomeyn', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHALLAT' => _x( 'Mahallat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDELIJAN' => _x( 'Delijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAZAND' => _x( 'Shazand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAMUNIYEH' => _x( 'Mamuniyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHAJERAN' => _x( 'Mahajeran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAFRESH' => _x( 'Tafresh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMILAJERD' => _x( 'Milajerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASHTIAN' => _x( 'Ashtian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOMIJAN' => _x( 'Komijan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHONDAB' => _x( 'Khondab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHBAZ' => _x( 'Shahbaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASTANEH' => _x( 'Astaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZAVIYEH' => _x( 'Zaviyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARANDAK' => _x( 'Parandak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIMVAR' => _x( 'Nimvar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARMAHIN' => _x( 'Farmahin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAVUDABAD' => _x( 'Davudabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGHARQABAD' => _x( 'Gharqabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOSHKRUD' => _x( 'Khoshkrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAVERSIYAN' => _x( 'Javersiyan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAVEH' => _x( 'Aveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKARCHAN' => _x( 'Karchan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWBARAN' => _x( 'Nowbaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHENEJIN' => _x( 'Khenejin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNARAQ' => _x( 'Naraq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTUREH' => _x( 'Tureh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARUQ' => _x( 'Saruq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHENDUDUR' => _x( 'Hendudur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQURCHI' => _x( 'Qurchi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZEGHI' => _x( 'Razeghi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'MZN' => [
		'IRSARI' => _x( 'Sari', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBABOL' => _x( 'Babol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAMOL' => _x( 'Amol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAEM' => _x( 'Qaem Shahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEHSHAHR' => _x( 'Behshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHALUS' => _x( 'Chalus', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEKA' => _x( 'Neka', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBABOLSAR' => _x( 'Babolsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTONEKABON' => _x( 'Tonekabon', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOWSHAHR' => _x( 'Nowshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFEREYDUNKENAR' => _x( 'Fereydunkenar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAMSAR' => _x( 'Ramsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJUYBAR' => _x( 'Juybar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHMUDABAD' => _x( 'Mahmudabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAMIRKOLA' => _x( 'Amirkola', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNUR' => _x( 'Nur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGALUGAH' => _x( 'Galugah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKETALEM' => _x( 'Ketalem', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIRAB' => _x( 'Zirab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABBASABAD' => _x( 'Abbasabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKELARDASHT' => _x( 'Kelardasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROSTAMKOLA' => _x( 'Rostamkola', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORRAMABAD' => _x( 'Khorramabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHIRUD' => _x( 'Shirud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAMESTAN' => _x( 'Chamestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHALIL' => _x( 'Khalil', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHACHIRUD' => _x( 'Hachirud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARATEH' => _x( 'Arateh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALMAN' => _x( 'Salman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSURAK' => _x( 'Surak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHIRGAH' => _x( 'Shirgah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPOL' => _x( 'Pol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIAKOLA' => _x( 'Kiakola', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAHNEMIR' => _x( 'Bahnemir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROYAN' => _x( 'Royan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIZADSHAHR' => _x( 'Izadshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGATAB' => _x( 'Gatab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSORKHRUD' => _x( 'Sorkhrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARZANABAD' => _x( 'Marzanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASHTARUD' => _x( 'Nashtarud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKELARABAD' => _x( 'Kelarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGALUGAH' => _x( 'Galugah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKIASAR' => _x( 'Kiasar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALLEH' => _x( 'Kalleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARGARMAHALLEH' => _x( 'Zargarmahalleh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPUL' => _x( 'Pul', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOJUR' => _x( 'Kojur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUSH' => _x( 'Khush', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIMAMZADEH' => _x( 'Imamzadeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHI' => _x( 'Kuhi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBALADEH' => _x( 'Baladeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDABUDASHT' => _x( 'Dabudasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALASHT' => _x( 'Alasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRINEH' => _x( 'Rineh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPAIN' => _x( 'Pain', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARZIKOLA' => _x( 'Marzikola', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGAZANAK' => _x( 'Gazanak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARIM' => _x( 'Farim', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORASAN' => _x( 'Khorasan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'NKH' => [
		'IRBOJNORD' => _x( 'Bojnord', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHIRVAN' => _x( 'Shirvan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESFARAYEN' => _x( 'Esfarayen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAJARM' => _x( 'Jajarm', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARMEH' => _x( 'Garmeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASHKHANEH' => _x( 'Ashkhaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARUJ' => _x( 'Faruj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZ' => _x( 'Raz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARAQ' => _x( 'Daraq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIARAT' => _x( 'Ziarat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAFIABAD' => _x( 'Safiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIVAR' => _x( 'Ivar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRABAD-E' => _x( 'Shahrabad-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTITKANLU' => _x( 'Titkanlu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHENARAN' => _x( 'Chenaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAZI' => _x( 'Qazi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHOQAN' => _x( 'Shoqan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSANKHVAST' => _x( 'Sankhvast', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPISH' => _x( 'Pish', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLUJALI' => _x( 'Lujali', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHESAR-E' => _x( 'Hesar-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQUSHKHANEH' => _x( 'Qushkhaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GZN' => [
		'IRQAZVIN' => _x( 'Qazvin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALVAND' => _x( 'Alvand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREQBALIYEH' => _x( 'Eqbaliyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAKESTAN' => _x( 'Takestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABYEK' => _x( 'Abyek', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADIYEH' => _x( 'Mohammadiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBIDESTAN' => _x( 'Bidestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHMUDABAD' => _x( 'Mahmudabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUIN' => _x( 'Buin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHARIFIYEH' => _x( 'Sharifiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAL' => _x( 'Shal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESFARVARIN' => _x( 'Esfarvarin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDANESFAHAN' => _x( 'Danesfahan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZIAABAD' => _x( 'Ziaabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORRAMDASHT' => _x( 'Khorramdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNARJEH' => _x( 'Narjeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABGARM' => _x( 'Abgarm', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAGZABAD' => _x( 'Sagzabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARDAK' => _x( 'Ardak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAVAJ' => _x( 'Avaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAK-E' => _x( 'Khak-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOALLEM' => _x( 'Moallem', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKUHIN' => _x( 'Kuhin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZMIAN' => _x( 'Razmian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIRDAN' => _x( 'Sirdan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'QHM' => [
		'IRQOM' => _x( 'Qom', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQANAVAT' => _x( 'Qanavat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAFARIYEH' => _x( 'Jafariyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDASTJERD' => _x( 'Dastjerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAHAK' => _x( 'Kahak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALAFCHEGAN' => _x( 'Salafchegan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORASAN' => _x( 'Khorasan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'RKH' => [
		'IRMASHHAD' => _x( 'Mashhad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNISHAPUR' => _x( 'Nishapur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSABZEVAR' => _x( 'Sabzevar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTORBAT-E_H' => _x( 'Torbat-e Heydarieh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKASHMAR' => _x( 'Kashmar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQUCHAN' => _x( 'Quchan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTORBAT-E_J' => _x( 'Torbat-e Jam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAYBAD' => _x( 'Taybad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHENARAN' => _x( 'Chenaran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARAKHS' => _x( 'Sarakhs', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGONABAD' => _x( 'Gonabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARIMAN' => _x( 'Fariman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR_J' => _x( 'Shahr Jadid-e Golbahar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARGAZ' => _x( 'Dargaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHAF' => _x( 'Khaf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARDASKAN' => _x( 'Bardaskan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTORQABEH' => _x( 'Torqabeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFEYZABAD' => _x( 'Feyzabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEQAB' => _x( 'Neqab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHANDIZ' => _x( 'Shandiz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHARV' => _x( 'Kharv', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHALILABAD' => _x( 'Khalilabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSANGAN' => _x( 'Sangan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAJESTAN' => _x( 'Bajestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKARIZ' => _x( 'Kariz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMASHHAD' => _x( 'Mashhad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDOWLATABAD' => _x( 'Dowlatabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAKHARZ' => _x( 'Bakharz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRAZAVIYEH' => _x( 'Razaviyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEHABAD' => _x( 'Salehabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFARHADGERD' => _x( 'Farhadgerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLMAKAN' => _x( 'Golmakan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHMADABAD-E' => _x( 'Ahmadabad-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASRABAD' => _x( 'Nasrabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNILSHAHR' => _x( 'Nilshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASHTIFAN' => _x( 'Nashtifan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALAT' => _x( 'Kalat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJANGAL' => _x( 'Jangal', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALAMI' => _x( 'Salami', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJOGHATAI' => _x( 'Joghatai', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANABAD' => _x( 'Anabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKONDOR' => _x( 'Kondor', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROSHTKHAR' => _x( 'Roshtkhar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRUZEH' => _x( 'Firuzeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARRUD' => _x( 'Darrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEFID' => _x( 'Sefid', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOLTANABAD' => _x( 'Soltanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRIVASH' => _x( 'Rivash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBIDOKHT' => _x( 'Bidokht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQASEMABAD' => _x( 'Qasemabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQALANDARABAD' => _x( 'Qalandarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAKHK' => _x( 'Kakhk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUD' => _x( 'Rud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAR' => _x( 'Bar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHR-E' => _x( 'Shahr-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAYG' => _x( 'Bayg', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRYUNESI' => _x( 'Yunesi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHADMEHR' => _x( 'Shadmehr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKADKAN' => _x( 'Kadkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQADAMGAH' => _x( 'Qadamgah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAVARZAN' => _x( 'Davarzan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOW' => _x( 'Now', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAPESHLU' => _x( 'Chapeshlu', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHESHTOMAD' => _x( 'Sheshtomad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRABAD' => _x( 'Shahrabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLOTFABAD' => _x( 'Lotfabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROBAT-E' => _x( 'Robat-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHEKNEH' => _x( 'Chekneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESHQABAD' => _x( 'Eshqabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHEMMATABAD' => _x( 'Hemmatabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMALEKABAD' => _x( 'Malekabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAZDAVAND' => _x( 'Mazdavand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAJGIRAN' => _x( 'Bajgiran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'SMN' => [
		'IRSEMNAN' => _x( 'Semnan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRUD' => _x( 'Shahrud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAMGHAN' => _x( 'Damghan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARMSAR' => _x( 'Garmsar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHDISHAHR' => _x( 'Mehdishahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARADAN' => _x( 'Aradan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IREYVANKI' => _x( 'Eyvanki', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBASTAM' => _x( 'Bastam', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSORKHEH' => _x( 'Sorkheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHMIRZAD' => _x( 'Shahmirzad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOJEN' => _x( 'Mojen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALATEH' => _x( 'Kalateh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDARJAZIN' => _x( 'Darjazin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYAMI' => _x( 'Meyami', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKALATEH' => _x( 'Kalateh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDIBAJ' => _x( 'Dibaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEYARJOMAND' => _x( 'Beyarjomand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAMIRIYEH' => _x( 'Amiriyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDIAN' => _x( 'Rudian', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKOHANABAD' => _x( 'Kohanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'SBN' => [
		'IRZAHEDAN' => _x( 'Zahedan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZABOL' => _x( 'Zabol', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIRANSHAHR' => _x( 'Iranshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHABAHAR' => _x( 'Chabahar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARAVAN' => _x( 'Saravan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHASH' => _x( 'Khash', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKONARAK' => _x( 'Konarak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJALEQ' => _x( 'Jaleq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIK' => _x( 'Nik', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPISHIN' => _x( 'Pishin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZEHAK' => _x( 'Zehak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQASR-E' => _x( 'Qasr-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSURAN' => _x( 'Suran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFANUJ' => _x( 'Fanuj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAMPUR' => _x( 'Bampur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZABOLI' => _x( 'Zaboli', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMADAN' => _x( 'Mohamadan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGALMURTI' => _x( 'Galmurti', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRASAK' => _x( 'Rasak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIRJAVEH' => _x( 'Mirjaveh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDUST' => _x( 'Dust', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBENT' => _x( 'Bent', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNOSRATABAD' => _x( 'Nosratabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAZMAN' => _x( 'Bazman', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEGUR' => _x( 'Negur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMADI' => _x( 'Mohamadi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBONJAR' => _x( 'Bonjar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOSHT' => _x( 'Gosht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRALI' => _x( 'Ali', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESPAKEH' => _x( 'Espakeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARABAD' => _x( 'Zarabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRADIMI' => _x( 'Adimi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNUKABAD' => _x( 'Nukabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADABAD' => _x( 'Mohammadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIRKAN' => _x( 'Sirkan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHIDUJ' => _x( 'Hiduj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARBAZ' => _x( 'Sarbaz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'SKH' => [
		'IRBIRJAND' => _x( 'Birjand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQAEN' => _x( 'Qaen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTABAS' => _x( 'Tabas', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFERDOWS' => _x( 'Ferdows', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNEHBANDAN' => _x( 'Nehbandan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBOSHRUYEH' => _x( 'Boshruyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARAYAN' => _x( 'Sarayan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARBISHEH' => _x( 'Sarbisheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESLAMIYEH' => _x( 'Eslamiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAYASK' => _x( 'Ayask', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHEZRI' => _x( 'Khezri', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESHQABAD' => _x( 'Eshqabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAJJIABAD' => _x( 'Hajjiabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASADIYEH' => _x( 'Asadiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEH' => _x( 'Seh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIMBELUK' => _x( 'Nimbeluk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTABAS-E' => _x( 'Tabas-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHUSF' => _x( 'Khusf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESFEDEN' => _x( 'Esfeden', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARIANSHAHR' => _x( 'Arianshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDEYHUK' => _x( 'Deyhuk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMUD' => _x( 'Mud', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHUSEF' => _x( 'Shusef', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRERESK' => _x( 'Eresk', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQOHESTAN' => _x( 'Qohestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGAZIK' => _x( 'Gazik', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZOHAN' => _x( 'Zohan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADSHAHR' => _x( 'Mohammadshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'THR' => [
		'IRTEHRAN' => _x( 'Tehran', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRESLAMSHAHR' => _x( 'Eslamshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGOLESTAN' => _x( 'Golestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQODS' => _x( 'Qods', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMALARD' => _x( 'Malard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVARAMIN' => _x( 'Varamin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHRIAR' => _x( 'Shahriar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQARCHAK' => _x( 'Qarchak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASIMSHAHR' => _x( 'Nasimshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPAKDASHT' => _x( 'Pakdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARDIS' => _x( 'Pardis', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRANDISHEH' => _x( 'Andisheh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRROBAT' => _x( 'Robat Karim', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPARAND' => _x( 'Parand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALEHIEH' => _x( 'Salehieh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDAMAVAND' => _x( 'Damavand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAQERSHAHR' => _x( 'Baqershahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAGHESTAN' => _x( 'Baghestan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUMAHEN' => _x( 'Bumahen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAHARDANGEH' => _x( 'Chahardangeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPISHVA' => _x( 'Pishva', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSABASHAHR' => _x( 'Sabashahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKAHRIZAK' => _x( 'Kahrizak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRVAHIDIEH' => _x( 'Vahidieh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNASIRSHAHR' => _x( 'Nasirshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFERDOWSIEH' => _x( 'Ferdowsieh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHASANABAD' => _x( 'Hasanabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAFADASHT' => _x( 'Safadasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRUDEHEN' => _x( 'Rudehen', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHEDSHAHR' => _x( 'Shahedshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFERUNABAD' => _x( 'Ferunabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRLAVASAN' => _x( 'Lavasan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRUZKUH' => _x( 'Firuzkuh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHMADABAD-E' => _x( 'Ahmadabad-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABSARD' => _x( 'Absard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHARIFABAD' => _x( 'Sharifabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFASHAM' => _x( 'Fasham', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRJAVADABAD' => _x( 'Javadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHEMSHAK' => _x( 'Shemshak', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKILAN' => _x( 'Kilan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABALI' => _x( 'Abali', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARJOMAND' => _x( 'Arjomand', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'WAZ' => [
		'IRURMIA' => _x( 'Urmia', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHOY' => _x( 'Khoy', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBUKAN' => _x( 'Bukan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHABAD' => _x( 'Mahabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIANDOAB' => _x( 'Miandoab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSALMAS' => _x( 'Salmas', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPIRANSHAHR' => _x( 'Piranshahr', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAQADEH' => _x( 'Naqadeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAKAB' => _x( 'Takab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAKU' => _x( 'Maku', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IROSHNAVIEH' => _x( 'Oshnavieh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSARDASHT' => _x( 'Sardasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHIN' => _x( 'Shahin Dezh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQARAH' => _x( 'Qarah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHOWT' => _x( 'Showt', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRRABAT' => _x( 'Rabat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIAH' => _x( 'Siah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRPOLDASHT' => _x( 'Poldasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAZARGAN' => _x( 'Bazargan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAZEH' => _x( 'Tazeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMOHAMMADYAR' => _x( 'Mohammadyar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAHAR' => _x( 'Chahar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRFIRURAQ' => _x( 'Firuraq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDIZAJ' => _x( 'Dizaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNUSHIN' => _x( 'Nushin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAHMUDABAD' => _x( 'Mahmudabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMIRABAD' => _x( 'Mirabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQATUR' => _x( 'Qatur', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBARUQ' => _x( 'Baruq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKESHAVARZ' => _x( 'Keshavarz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGERD' => _x( 'Gerd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRIVUGHLI' => _x( 'Ivughli', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNAZOK-E' => _x( 'Nazok-e', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQUSHCHI' => _x( 'Qushchi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNALUS' => _x( 'Nalus', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARGANLAR' => _x( 'Marganlar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAVAJIQ' => _x( 'Avajiq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSEROW' => _x( 'Serow', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSILVANEH' => _x( 'Silvaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSIMMINEH' => _x( 'Simmineh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZURABAD' => _x( 'Zurabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHALIFAN' => _x( 'Khalifan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'YZD' => [
		'IRYAZD' => _x( 'Yazd', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEYBOD' => _x( 'Meybod', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARDAKAN' => _x( 'Ardakan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAFQ' => _x( 'Bafq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHAMIDIYA' => _x( 'Hamidiya', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHRIZ' => _x( 'Mehriz', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABARKUH' => _x( 'Abarkuh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRTAFT' => _x( 'Taft', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSHAHEDIYEH' => _x( 'Shahediyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRASHKEZAR' => _x( 'Ashkezar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHERAT' => _x( 'Herat', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARACH' => _x( 'Zarach', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMARVAST' => _x( 'Marvast', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMEHRDASHT' => _x( 'Mehrdasht', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBEHABAD' => _x( 'Behabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRBAFRUIYEH' => _x( 'Bafruiyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAHMADABAD' => _x( 'Ahmadabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNADUSHAN' => _x( 'Nadushan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAQDA' => _x( 'Aqda', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIR' => _x( 'Nir', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHEZRABAD' => _x( 'Khezrabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'ZJN' => [
		'IRZANJAN' => _x( 'Zanjan', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRABHAR' => _x( 'Abhar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKHORRAMDARREH' => _x( 'Khorramdarreh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRQEYDAR' => _x( 'Qeydar', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHIDAJ' => _x( 'Hidaj', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSAIN' => _x( 'Sain', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOLTANIYEH' => _x( 'Soltaniyeh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOJAS' => _x( 'Sojas', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRSOHREVARD' => _x( 'Sohrevard', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARRIN' => _x( 'Zarrin', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRAB' => _x( 'Ab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRMAH' => _x( 'Mah', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRGARMAB' => _x( 'Garmab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRDANDI' => _x( 'Dandi', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNURABAD' => _x( 'Nurabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRKARASF' => _x( 'Karasf', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRZARRINABAD' => _x( 'Zarrinabad', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRARMAGHANKHANEH' => _x( 'Armaghankhaneh', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRCHAVARZAQ' => _x( 'Chavarzaq', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRHALAB' => _x( 'Halab', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IRNIK' => _x( 'Nik', 'IR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
