<?php

/**
 * List of cities for: India
 * Source: https://censusindia.gov.in/2011census/population_enumeration.html
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['IN'];

$country_cities = [
	'JK' => [
		'IN00001' => 'Kupwara',
		'IN00002' => 'Handwara',
		'IN00003' => 'Karnah',
		'IN00004' => 'Khag',
		'IN00005' => 'Beerwah',
		'IN00006' => 'Khansahib',
		'IN00007' => 'Budgam',
		'IN00008' => 'Chadoora',
		'IN00009' => 'Charar- E- Shrief',
		'IN00010' => 'Leh',
		'IN00011' => 'Nubra',
		'IN00012' => 'Khalsi',
		'IN00013' => 'Kargil',
		'IN00014' => 'Sanku',
		'IN00015' => 'Zanskar',
		'IN00016' => 'Haveli',
		'IN00017' => 'Mandi',
		'IN00018' => 'Mendhar',
		'IN00019' => 'Surankote',
		'IN00020' => 'Thanamandi',
		'IN00021' => 'Darhal',
		'IN00022' => 'Rajauri',
		'IN00023' => 'Budhal',
		'IN00024' => 'Kalakote',
		'IN00025' => 'Nowshehra',
		'IN00026' => 'Sunderbani',
		'IN00027' => 'Billawar',
		'IN00028' => 'Bashohli',
		'IN00029' => 'Bani',
		'IN00030' => 'Kathua',
		'IN00031' => 'Hiranagar',
		'IN00032' => 'Sopore',
		'IN00033' => 'Rafiabad',
		'IN00034' => 'Pattan',
		'IN00035' => 'Baramulla',
		'IN00036' => 'Kreeri',
		'IN00037' => 'Uri',
		'IN00038' => 'Boniyar',
		'IN00039' => 'Tangmarg ',
		'IN00040' => 'Gurez',
		'IN00041' => 'Bandipora',
		'IN00042' => 'Sonawari',
		'IN00043' => 'Srinagar (North)',
		'IN00044' => 'Srinagar (South)',
		'IN00045' => 'Lar',
		'IN00046' => 'Kangan',
		'IN00047' => 'Ganderbal',
		'IN00048' => 'Pampore',
		'IN00049' => 'Awantipora',
		'IN00050' => 'Tral',
		'IN00051' => 'Pulwama',
		'IN00052' => 'Shopian',
		'IN00053' => 'Pahalgam',
		'IN00054' => 'Bijbehara',
		'IN00055' => 'Anantnag',
		'IN00056' => 'Shangus',
		'IN00057' => 'Kokernag',
		'IN00058' => 'Dooru',
		'IN00059' => 'Kulgam',
		'IN00060' => ' Devsar',
		'IN00061' => 'Damhal Hanjipora',
		'IN00062' => 'Doda',
		'IN00063' => 'Thathri',
		'IN00064' => 'Gandoh',
		'IN00065' => 'Bhaderwah',
		'IN00066' => 'Banihal',
		'IN00067' => 'Ramban',
		'IN00068' => 'Kishtwar',
		'IN00069' => 'Marwah',
		'IN00070' => 'Chhatroo',
		'IN00071' => 'Atholi (Paddar)',
		'IN00072' => 'Udhampur',
		'IN00073' => 'Chenani',
		'IN00074' => 'Ramnagar',
		'IN00075' => 'Majalta',
		'IN00076' => 'Gool-Gulabgarh',
		'IN00077' => 'Reasi',
		'IN00078' => 'Akhnoor',
		'IN00079' => 'Jammu',
		'IN00080' => 'Ranbir Singh Pora',
		'IN00081' => 'Bishnah',
		'IN00082' => 'Samba',
	],
	'HP' => [
		'IN00083' => 'Pangi',
		'IN00084' => 'Chaurah',
		'IN00085' => 'Saluni',
		'IN00086' => 'Bhalai',
		'IN00087' => 'Dalhousie',
		'IN00088' => 'Bhattiyat',
		'IN00089' => 'Sihunta',
		'IN00090' => 'Chamba',
		'IN00091' => 'Holi',
		'IN00092' => 'Brahmaur',
		'IN00093' => 'Nurpur',
		'IN00094' => 'Indora',
		'IN00095' => 'Fatehpur',
		'IN00096' => 'Jawali',
		'IN00097' => 'Harchakian',
		'IN00098' => 'Shahpur',
		'IN00099' => 'Dharmsala',
		'IN00100' => 'Kangra',
		'IN00101' => 'Nagrota Bagwan',
		'IN00102' => 'Baroh',
		'IN00103' => 'Dera Gopipur',
		'IN00104' => 'Jawalamukhi',
		'IN00105' => 'Jaswan',
		'IN00106' => 'Rakkar',
		'IN00107' => 'Khundian',
		'IN00108' => 'Thural',
		'IN00109' => 'Dhira',
		'IN00110' => 'Jaisinghpur',
		'IN00111' => 'Palampur',
		'IN00112' => 'Baijnath',
		'IN00113' => 'Multhan',
		'IN00114' => 'Udaipur',
		'IN00115' => 'Lahul',
		'IN00116' => 'Spiti',
		'IN00117' => 'Manali',
		'IN00118' => 'Kullu',
		'IN00119' => 'Sainj',
		'IN00120' => 'Banjar',
		'IN00121' => 'Ani',
		'IN00122' => 'Nermand',
		'IN00123' => 'Padhar',
		'IN00124' => 'Jogindarnagar',
		'IN00125' => 'Lad Bharol',
		'IN00126' => 'Sandhol',
		'IN00127' => 'Dharmpur',
		'IN00128' => 'Kotli',
		'IN00129' => 'Sarkaghat',
		'IN00130' => 'Bhadrota',
		'IN00131' => 'Baldwara',
		'IN00132' => 'Sundarnagar',
		'IN00133' => 'Mandi',
		'IN00134' => 'Aut',
		'IN00135' => 'Bali Chowki',
		'IN00136' => 'Thunag',
		'IN00137' => 'Chachyot',
		'IN00138' => 'Nihri',
		'IN00139' => 'Karsog',
		'IN00140' => 'Tira Sujanpur',
		'IN00141' => 'Nadaun',
		'IN00142' => 'Galore',
		'IN00143' => 'Hamirpur',
		'IN00144' => 'Barsar',
		'IN00145' => 'Dhatwal',
		'IN00146' => 'Bhoranj',
		'IN00147' => 'Bharwain',
		'IN00148' => 'Amb',
		'IN00149' => 'Bangana',
		'IN00150' => 'Una',
		'IN00151' => 'Haroli',
		'IN00152' => 'Ghumarwin',
		'IN00153' => 'Bharari',
		'IN00154' => 'Jhanduta',
		'IN00155' => 'Naina Devi',
		'IN00156' => 'Bilaspur Sadar',
		'IN00157' => 'Namhol',
		'IN00158' => 'Arki',
		'IN00159' => 'Darlaghat',
		'IN00160' => 'Ramshahr',
		'IN00161' => 'Nalagarh',
		'IN00162' => 'Baddi',
		'IN00163' => 'Krishangarh',
		'IN00164' => 'Kasauli',
		'IN00165' => 'Solan',
		'IN00166' => 'Kandaghat',
		'IN00167' => 'Rajgarh',
		'IN00168' => 'Nohra',
		'IN00169' => 'Pachhad',
		'IN00170' => 'Renuka',
		'IN00171' => 'Dadahu',
		'IN00172' => 'Nahan',
		'IN00173' => 'Paonta Sahib',
		'IN00174' => 'Kamrau',
		'IN00175' => 'Shalai',
		'IN00176' => 'Ronhat',
		'IN00177' => 'Rampur',
		'IN00178' => 'Nankhari',
		'IN00179' => 'Kumharsain',
		'IN00180' => 'Seoni',
		'IN00181' => 'Shimla   ( Rural )',
		'IN00182' => 'Shimla (urban)',
		'IN00183' => 'Junga',
		'IN00184' => 'Theog',
		'IN00185' => 'Chaupal',
		'IN00186' => 'Cheta',
		'IN00187' => 'Nerua',
		'IN00188' => 'Jubbal',
		'IN00189' => 'Kotkhai',
		'IN00190' => 'Tikar',
		'IN00191' => 'Rohru',
		'IN00192' => 'Chirgaon',
		'IN00193' => 'Dodra Kwar',
		'IN00194' => 'Hangrang',
		'IN00195' => 'Poo',
		'IN00196' => 'Morang',
		'IN00197' => 'Kalpa',
		'IN00198' => 'Nichar',
		'IN00199' => 'Sangla',
	],
	'PB' => [
		'IN00200' => 'Dhar Kalan',
		'IN00201' => 'Pathankot',
		'IN00202' => 'Gurdaspur',
		'IN00203' => 'Batala',
		'IN00204' => 'Dera Baba Nanak',
		'IN00205' => 'Bhulath',
		'IN00206' => 'Kapurthala',
		'IN00207' => 'Sultanpur Lodhi',
		'IN00208' => 'Phagwara',
		'IN00209' => 'Shahkot',
		'IN00210' => 'Nakodar',
		'IN00211' => 'Phillaur',
		'IN00212' => 'Jalandhar - I',
		'IN00213' => 'Jalandhar - II',
		'IN00214' => 'Dasua',
		'IN00215' => 'Mukerian',
		'IN00216' => 'Hoshiarpur',
		'IN00217' => 'Garhshankar',
		'IN00218' => 'Nawanshahr',
		'IN00219' => 'Balachaur',
		'IN00220' => 'Bassi Pathana',
		'IN00221' => 'Fatehgarh Sahib',
		'IN00222' => 'Amloh',
		'IN00223' => 'Khamanon',
		'IN00224' => 'Samrala',
		'IN00225' => 'Khanna',
		'IN00226' => 'Payal',
		'IN00227' => 'Ludhiana (East)',
		'IN00228' => 'Ludhiana (West)',
		'IN00229' => 'Raikot',
		'IN00230' => 'Jagraon',
		'IN00231' => 'Nihal Singhwala',
		'IN00232' => 'Bagha Purana',
		'IN00233' => 'Moga',
		'IN00234' => 'Zira',
		'IN00235' => 'Firozpur',
		'IN00236' => 'Jalalabad',
		'IN00237' => 'Fazilka',
		'IN00238' => 'Abohar',
		'IN00239' => 'Malout',
		'IN00240' => 'Gidderbaha',
		'IN00241' => 'Muktsar',
		'IN00242' => 'Faridkot',
		'IN00243' => 'Jaitu',
		'IN00244' => 'Rampura Phul',
		'IN00245' => 'Bathinda',
		'IN00246' => 'Talwandi Sabo',
		'IN00247' => 'Sardulgarh',
		'IN00248' => 'Budhlada',
		'IN00249' => 'Mansa',
		'IN00250' => 'Samana',
		'IN00251' => 'Patran',
		'IN00252' => 'Nabha',
		'IN00253' => 'Patiala',
		'IN00254' => 'Rajpura',
		'IN00255' => 'Ajnala',
		'IN00256' => 'Amritsar -I',
		'IN00257' => 'Amritsar- II',
		'IN00258' => 'Baba Bakala',
		'IN00259' => 'Tarn Taran',
		'IN00260' => 'Patti',
		'IN00261' => 'Khadur Sahib',
		'IN00262' => 'Anandpur Sahib',
		'IN00263' => 'Nangal',
		'IN00264' => 'Rup Nagar',
		'IN00265' => 'Chamkaur Sahib',
		'IN00266' => 'Kharar',
		'IN00267' => 'SAS Nagar (Mohali)',
		'IN00268' => 'Dera Bassi',
		'IN00269' => 'Malerkotla',
		'IN00270' => 'Dhuri',
		'IN00271' => 'Sangrur',
		'IN00272' => 'Sunam',
		'IN00273' => 'Lehra',
		'IN00274' => 'Moonak',
		'IN00275' => 'Barnala',
		'IN00276' => 'Tapa',
	],
	'CH' => [
		'IN00277' => 'Chandigarh',
	],
	'UK' => [
		'IN00278' => 'Puraula',
		'IN00279' => 'Mori',
		'IN00280' => 'Rajgarhi',
		'IN00281' => 'Dunda',
		'IN00282' => 'Chinyali Saur',
		'IN00283' => 'Bhatwari',
		'IN00284' => 'Joshimath',
		'IN00285' => 'Chamoli',
		'IN00286' => 'Pokhari',
		'IN00287' => 'Karnaprayag',
		'IN00288' => 'Tharali',
		'IN00289' => 'Gairsain',
		'IN00290' => 'Ukhimath',
		'IN00291' => 'Rudraprayag',
		'IN00292' => 'Jakholi',
		'IN00293' => 'Ghansali',
		'IN00294' => 'Devprayag',
		'IN00295' => 'Pratapnagar',
		'IN00296' => 'Jakhani Dhar',
		'IN00297' => 'Tehri ',
		'IN00298' => 'Dhanaulti',
		'IN00299' => 'Narendra Nagar',
		'IN00300' => 'Chakrata',
		'IN00301' => 'Tyuni',
		'IN00302' => 'Kalsi',
		'IN00303' => 'Vikas Nagar',
		'IN00304' => 'Dehradun',
		'IN00305' => 'Rishikesh',
		'IN00306' => 'Srinagar',
		'IN00307' => 'Pauri',
		'IN00308' => 'Thailisain',
		'IN00309' => 'Dhoomakot',
		'IN00310' => 'Lansdowne',
		'IN00311' => 'Satpuli',
		'IN00312' => 'Chaubatta Khal',
		'IN00313' => 'Kotdwara',
		'IN00314' => 'Yamkeshwar',
		'IN00315' => 'Munsiari',
		'IN00316' => 'Dharchula',
		'IN00317' => 'Didihat',
		'IN00318' => 'Berinag',
		'IN00319' => 'Gangolihat',
		'IN00320' => 'Pithoragarh',
		'IN00321' => 'Kapkot',
		'IN00322' => 'Kanda',
		'IN00323' => 'Bageshwar',
		'IN00324' => 'Garud',
		'IN00325' => 'Bhikiasain',
		'IN00326' => 'Chaukhutiya',
		'IN00327' => 'Sult',
		'IN00328' => 'Ranikhet',
		'IN00329' => 'Dwarahat',
		'IN00330' => 'Almora',
		'IN00331' => 'Someshwar',
		'IN00332' => 'Jainti',
		'IN00333' => 'Bhanoli',
		'IN00334' => 'Champawat',
		'IN00335' => 'Pati',
		'IN00336' => 'Lohaghat',
		'IN00337' => 'Poornagiri',
		'IN00338' => 'Kosya Kutauli',
		'IN00339' => 'Betalghat',
		'IN00340' => 'Nainital',
		'IN00341' => 'Dhari',
		'IN00342' => 'Haldwani',
		'IN00343' => 'Ramnagar',
		'IN00344' => 'Kaladhungi',
		'IN00345' => 'Lalkuan',
		'IN00346' => 'Kashipur',
		'IN00347' => 'Jaspur',
		'IN00348' => 'Bajpur',
		'IN00349' => 'Kichha',
		'IN00350' => 'Gadarpur',
		'IN00351' => 'Sitarganj',
		'IN00352' => 'Khatima',
		'IN00353' => 'Roorkee',
		'IN00354' => 'Hardwar',
		'IN00355' => 'Laksar',
	],
	'HR' => [
		'IN00356' => 'Kalka',
		'IN00357' => 'Panchkula',
		'IN00358' => 'Naraingarh',
		'IN00359' => 'Ambala',
		'IN00360' => 'Barara',
		'IN00361' => 'Jagadhri',
		'IN00362' => 'Bilaspur',
		'IN00363' => 'Chhachhrauli',
		'IN00364' => 'Shahbad',
		'IN00365' => 'Pehowa',
		'IN00366' => 'Thanesar',
		'IN00367' => 'Guhla',
		'IN00368' => 'Kaithal',
		'IN00369' => 'Fatehpur Pundri',
		'IN00370' => 'Nilokheri',
		'IN00371' => 'Indri',
		'IN00372' => 'Karnal',
		'IN00373' => 'Assandh',
		'IN00374' => 'Gharaunda',
		'IN00375' => 'Panipat',
		'IN00376' => 'Israna',
		'IN00377' => 'Samalkha',
		'IN00378' => 'Gohana',
		'IN00379' => 'Ganaur',
		'IN00380' => 'Sonipat',
		'IN00381' => 'Kharkhoda',
		'IN00382' => 'Narwana',
		'IN00383' => 'Jind',
		'IN00384' => 'Julana',
		'IN00385' => 'Safidon',
		'IN00386' => 'Ratia',
		'IN00387' => 'Tohana',
		'IN00388' => 'Fatehabad',
		'IN00389' => 'Dabwali',
		'IN00390' => 'Sirsa',
		'IN00391' => 'Rania',
		'IN00392' => 'Ellenabad',
		'IN00393' => 'Adampur',
		'IN00394' => 'Hisar',
		'IN00395' => 'Narnaund',
		'IN00396' => 'Hansi',
		'IN00397' => 'Bawani Khera',
		'IN00398' => 'Bhiwani',
		'IN00399' => 'Tosham',
		'IN00400' => 'Siwani',
		'IN00401' => 'Loharu',
		'IN00402' => 'Dadri',
		'IN00403' => 'Badhra',
		'IN00404' => 'Maham',
		'IN00405' => 'Rohtak',
		'IN00406' => 'Sampla',
		'IN00407' => 'Beri',
		'IN00408' => 'Bahadurgarh',
		'IN00409' => 'Jhajjar',
		'IN00410' => 'Matenhail',
		'IN00411' => 'Mahendragarh',
		'IN00412' => 'Narnaul',
		'IN00413' => 'Kosli',
		'IN00414' => 'Rewari',
		'IN00415' => 'Bawal',
		'IN00416' => 'Pataudi',
		'IN00417' => 'Gurgaon',
		'IN00418' => 'Farrukhnagar',
		'IN00419' => 'Manesar',
		'IN00420' => 'Sohna',
		'IN00421' => 'Taoru',
		'IN00422' => 'Nuh',
		'IN00423' => 'Ferozepur Jhirka',
		'IN00424' => 'Punahana',
		'IN00425' => 'Faridabad',
		'IN00426' => 'Ballabgarh',
		'IN00427' => 'Palwal',
		'IN00428' => 'Hathin',
		'IN00429' => 'Hodal',
	],
	'DL' => [
		'IN00430' => 'Narela',
		'IN00431' => 'Saraswati Vihar',
		'IN00432' => 'Model Town',
		'IN00433' => 'Civil Lines',
		'IN00434' => 'Sadar Bazar',
		'IN00435' => 'Kotwali',
		'IN00436' => 'Seelam Pur',
		'IN00437' => 'Shahdara',
		'IN00438' => 'Seema Puri',
		'IN00439' => 'Gandhi Nagar',
		'IN00440' => 'Vivek Vihar',
		'IN00441' => 'Preet Vihar',
		'IN00442' => 'Connaught Place',
		'IN00443' => 'Chanakya Puri',
		'IN00444' => 'Parliament Street',
		'IN00445' => 'Darya Ganj',
		'IN00446' => 'Pahar Ganj',
		'IN00447' => 'Karol Bagh',
		'IN00448' => 'Patel Nagar',
		'IN00449' => 'Rajouri Garden',
		'IN00450' => 'Punjabi Bagh',
		'IN00451' => 'Najafgarh',
		'IN00452' => 'Delhi Cantonment',
		'IN00453' => 'Vasant Vihar',
		'IN00454' => 'Hauz Khas',
		'IN00455' => 'Defence Colony',
		'IN00456' => 'Kalkaji',
	],
	'RJ' => [
		'IN00457' => 'Karanpur',
		'IN00458' => 'Ganganagar',
		'IN00459' => 'Sadulshahar',
		'IN00460' => 'Padampur',
		'IN00461' => 'Raisinghnagar',
		'IN00462' => 'Anupgarh',
		'IN00463' => 'Gharsana',
		'IN00464' => 'Vijainagar',
		'IN00465' => 'Suratgarh',
		'IN00466' => 'Sangaria',
		'IN00467' => 'Tibi',
		'IN00468' => 'Hanumangarh',
		'IN00469' => 'Pilibanga',
		'IN00470' => 'Rawatsar',
		'IN00471' => 'Nohar',
		'IN00472' => 'Bhadra',
		'IN00473' => 'Bikaner',
		'IN00474' => 'Poogal',
		'IN00475' => 'Lunkaransar',
		'IN00476' => 'Kolayat',
		'IN00477' => 'Nokha',
		'IN00478' => 'Khajuwala',
		'IN00479' => 'Chhatargarh',
		'IN00480' => 'Sridungargarh',
		'IN00481' => 'Taranagar',
		'IN00482' => 'Rajgarh',
		'IN00483' => 'Sardarshahar',
		'IN00484' => 'Churu',
		'IN00485' => 'Ratangarh',
		'IN00486' => 'Sujangarh',
		'IN00487' => 'Jhunjhunun',
		'IN00488' => 'Chirawa',
		'IN00489' => 'Buhana',
		'IN00490' => 'Khetri',
		'IN00491' => 'Nawalgarh',
		'IN00492' => 'Udaipurwati',
		'IN00493' => 'Behror',
		'IN00494' => 'Mandawar',
		'IN00495' => 'Kotkasim',
		'IN00496' => 'Tijara',
		'IN00497' => 'Kishangarh Bas',
		'IN00498' => 'Ramgarh',
		'IN00499' => 'Alwar',
		'IN00500' => 'Bansur',
		'IN00501' => 'Thanagazi',
		'IN00502' => 'Rajgarh',
		'IN00503' => 'Lachhmangarh',
		'IN00504' => 'Kathumar',
		'IN00505' => 'Pahari',
		'IN00506' => 'Kaman',
		'IN00507' => 'Nagar',
		'IN00508' => 'Deeg',
		'IN00509' => 'Nadbai',
		'IN00510' => 'Kumher',
		'IN00511' => 'Bharatpur',
		'IN00512' => 'Weir',
		'IN00513' => 'Bayana',
		'IN00514' => 'Rupbas',
		'IN00515' => 'Baseri',
		'IN00516' => 'Bari',
		'IN00517' => 'Sepau',
		'IN00518' => 'Dhaulpur',
		'IN00519' => 'Rajakhera',
		'IN00520' => 'Todabhim',
		'IN00521' => 'Nadoti',
		'IN00522' => 'Hindaun',
		'IN00523' => 'Karauli',
		'IN00524' => 'Mandrail',
		'IN00525' => 'Sapotra',
		'IN00526' => 'Gangapur',
		'IN00527' => 'Bamanwas',
		'IN00528' => 'Malarna Doongar',
		'IN00529' => 'Bonli',
		'IN00530' => 'Chauth Ka Barwara',
		'IN00531' => 'Sawai Madhopur',
		'IN00532' => 'Khandar',
		'IN00533' => 'Baswa',
		'IN00534' => 'Mahwa',
		'IN00535' => 'Sikrai',
		'IN00536' => 'Dausa',
		'IN00537' => 'Lalsot',
		'IN00538' => 'Kotputli',
		'IN00539' => 'Viratnagar',
		'IN00540' => 'Shahpura',
		'IN00541' => 'Chomu',
		'IN00542' => 'Phulera (Hq.Sambhar)',
		'IN00543' => 'Mauzamabad',
		'IN00544' => 'Phagi',
		'IN00545' => 'Sanganer',
		'IN00546' => 'Jaipur',
		'IN00547' => 'Amber',
		'IN00548' => 'Jamwa Ramgarh',
		'IN00549' => 'Bassi',
		'IN00550' => 'Chaksu',
		'IN00551' => 'Fatehpur',
		'IN00552' => 'Lachhmangarh',
		'IN00553' => 'Sikar',
		'IN00554' => 'Danta Ramgarh',
		'IN00555' => 'Sri Madhopur',
		'IN00556' => 'Neem-Ka-Thana',
		'IN00557' => 'Ladnu',
		'IN00558' => 'Didwana',
		'IN00559' => 'Jayal',
		'IN00560' => 'Nagaur',
		'IN00561' => 'Kheenvsar',
		'IN00562' => 'Merta',
		'IN00563' => 'Degana',
		'IN00564' => 'Parbatsar',
		'IN00565' => 'Makrana',
		'IN00566' => 'Nawa',
		'IN00567' => 'Phalodi',
		'IN00568' => 'Osian',
		'IN00569' => 'Bhopalgarh',
		'IN00570' => 'Jodhpur',
		'IN00571' => 'Shergarh',
		'IN00572' => 'Luni',
		'IN00573' => 'Bilara',
		'IN00574' => 'Jaisalmer',
		'IN00575' => 'Pokaran',
		'IN00576' => 'Fatehgarh',
		'IN00577' => 'Sheo',
		'IN00578' => 'Baytoo',
		'IN00579' => 'Pachpadra',
		'IN00580' => 'Siwana',
		'IN00581' => 'Gudha Malani',
		'IN00582' => 'Barmer',
		'IN00583' => 'Ramsar',
		'IN00584' => 'Chohtan',
		'IN00585' => 'Sayla',
		'IN00586' => 'Ahore',
		'IN00587' => 'Jalor',
		'IN00588' => 'Bhinmal',
		'IN00589' => 'Bagora',
		'IN00590' => 'Sanchore',
		'IN00591' => 'Raniwara',
		'IN00592' => 'Sheoganj',
		'IN00593' => 'Sirohi',
		'IN00594' => 'Pindwara',
		'IN00595' => 'Abu Road',
		'IN00596' => 'Reodar',
		'IN00597' => 'Jaitaran',
		'IN00598' => 'Raipur',
		'IN00599' => 'Sojat',
		'IN00600' => 'Rohat',
		'IN00601' => 'Pali',
		'IN00602' => 'Marwar Junction',
		'IN00603' => 'Desuri',
		'IN00604' => 'Sumerpur',
		'IN00605' => 'Bali',
		'IN00606' => 'Kishangarh',
		'IN00607' => 'Ajmer',
		'IN00608' => 'Peesangan',
		'IN00609' => 'Beawar',
		'IN00610' => 'Masuda',
		'IN00611' => 'Nasirabad',
		'IN00612' => 'Bhinay',
		'IN00613' => 'Sarwar',
		'IN00614' => 'Kekri',
		'IN00615' => 'Malpura',
		'IN00616' => 'Peeplu',
		'IN00617' => 'Niwai',
		'IN00618' => 'Tonk',
		'IN00619' => 'Todaraisingh',
		'IN00620' => 'Deoli',
		'IN00621' => 'Uniara',
		'IN00622' => 'Hindoli',
		'IN00623' => 'Nainwa',
		'IN00624' => 'Indragarh',
		'IN00625' => 'Keshoraipatan',
		'IN00626' => 'Bundi',
		'IN00627' => 'Asind',
		'IN00628' => 'Hurda',
		'IN00629' => 'Shahpura',
		'IN00630' => 'Banera',
		'IN00631' => 'Mandal',
		'IN00632' => 'Raipur',
		'IN00633' => 'Sahara',
		'IN00634' => 'Bhilwara',
		'IN00635' => 'Kotri',
		'IN00636' => 'Jahazpur',
		'IN00637' => 'Mandalgarh',
		'IN00638' => 'Beejoliya',
		'IN00639' => 'Bhim',
		'IN00640' => 'Deogarh',
		'IN00641' => 'Amet',
		'IN00642' => 'Kumbhalgarh',
		'IN00643' => 'Rajsamand',
		'IN00644' => 'Railmagra',
		'IN00645' => 'Nathdwara',
		'IN00646' => 'Dungarpur',
		'IN00647' => 'Aspur',
		'IN00648' => 'Sagwara',
		'IN00649' => 'Simalwara',
		'IN00650' => 'Ghatol',
		'IN00651' => 'Garhi',
		'IN00652' => 'Banswara',
		'IN00653' => 'Bagidora',
		'IN00654' => 'Kushalgarh',
		'IN00655' => 'Rashmi',
		'IN00656' => 'Gangrar',
		'IN00657' => 'Begun',
		'IN00658' => 'Rawatbhata',
		'IN00659' => 'Chittaurgarh',
		'IN00660' => 'Kapasan',
		'IN00661' => 'Dungla',
		'IN00662' => 'Bhadesar',
		'IN00663' => 'Nimbahera',
		'IN00664' => 'Bari Sadri',
		'IN00665' => 'Pipalda',
		'IN00666' => 'Digod',
		'IN00667' => 'Ladpura',
		'IN00668' => 'Ramganj Mandi',
		'IN00669' => 'Sangod',
		'IN00670' => 'Mangrol',
		'IN00671' => 'Antah',
		'IN00672' => 'Baran',
		'IN00673' => 'Atru',
		'IN00674' => 'Kishanganj',
		'IN00675' => 'Shahbad',
		'IN00676' => 'Chhabra',
		'IN00677' => 'Chhipabarod',
		'IN00678' => 'Khanpur',
		'IN00679' => 'Jhalrapatan',
		'IN00680' => 'Aklera',
		'IN00681' => 'Manohar Thana',
		'IN00682' => 'Pachpahar',
		'IN00683' => 'Pirawa',
		'IN00684' => 'Gangdhar',
		'IN00685' => 'Mavli',
		'IN00686' => 'Gogunda',
		'IN00687' => 'Kotra',
		'IN00688' => 'Jhadol',
		'IN00689' => 'Girwa',
		'IN00690' => 'Vallabhnagar',
		'IN00691' => 'Lasadiya',
		'IN00692' => 'Salumbar',
		'IN00693' => 'Sarada',
		'IN00694' => 'Rishabhdeo',
		'IN00695' => 'Kherwara',
		'IN00696' => 'Dhariawad',
		'IN00697' => 'Peepalkhoont',
		'IN00698' => 'Chhoti Sadri',
		'IN00699' => 'Pratapgarh',
		'IN00700' => 'Arnod',
	],
	'UP' => [
		'IN00701' => 'Behat',
		'IN00702' => 'Saharanpur',
		'IN00703' => 'Nakur',
		'IN00704' => 'Deoband',
		'IN00705' => 'Rampur Maniharan',
		'IN00706' => 'Kairana',
		'IN00707' => 'Shamli',
		'IN00708' => 'Muzaffarnagar',
		'IN00709' => 'Budhana',
		'IN00710' => 'Khatauli',
		'IN00711' => 'Jansath',
		'IN00712' => 'Najibabad',
		'IN00713' => 'Bijnor',
		'IN00714' => 'Nagina',
		'IN00715' => 'Dhampur',
		'IN00716' => 'Chandpur',
		'IN00717' => 'Thakurdwara',
		'IN00718' => 'Kanth',
		'IN00719' => 'Moradabad',
		'IN00720' => 'Bilari',
		'IN00721' => 'Sambhal',
		'IN00722' => 'Chandausi',
		'IN00723' => 'Suar',
		'IN00724' => 'Tanda',
		'IN00725' => 'Bilaspur',
		'IN00726' => 'Rampur',
		'IN00727' => 'Shahabad',
		'IN00728' => 'Milak',
		'IN00729' => 'Dhanaura',
		'IN00730' => 'Amroha',
		'IN00731' => 'Hasanpur',
		'IN00732' => 'Sardhana',
		'IN00733' => 'Mawana',
		'IN00734' => 'Meerut',
		'IN00735' => 'Baraut',
		'IN00736' => 'Baghpat',
		'IN00737' => 'Khekada',
		'IN00738' => 'Modinagar',
		'IN00739' => 'Ghaziabad',
		'IN00740' => 'Hapur',
		'IN00741' => 'Garhmukteshwar',
		'IN00742' => 'Dadri',
		'IN00743' => 'Gautam Buddha Nagar',
		'IN00744' => 'Jewar',
		'IN00745' => 'Sikandrabad',
		'IN00746' => 'Bulandshahr',
		'IN00747' => 'Siana',
		'IN00748' => 'Anupshahr',
		'IN00749' => 'Debai',
		'IN00750' => 'Shikarpur',
		'IN00751' => 'Khurja',
		'IN00752' => 'Khair',
		'IN00753' => 'Gabhana',
		'IN00754' => 'Atrauli',
		'IN00755' => 'Koil',
		'IN00756' => 'Iglas',
		'IN00757' => 'Sasni',
		'IN00758' => 'Sikandra Rao',
		'IN00759' => 'Hathras',
		'IN00760' => 'Sadabad',
		'IN00761' => 'Chhata',
		'IN00762' => 'Mat',
		'IN00763' => 'Mahavan',
		'IN00764' => 'Mathura',
		'IN00765' => 'Etmadpur',
		'IN00766' => 'Agra',
		'IN00767' => 'Kiraoli',
		'IN00768' => 'Kheragarh',
		'IN00769' => 'Fatehabad',
		'IN00770' => 'Bah',
		'IN00771' => 'Tundla',
		'IN00772' => 'Firozabad',
		'IN00773' => 'Jasrana',
		'IN00774' => 'Shikohabad',
		'IN00775' => 'Mainpuri',
		'IN00776' => 'Karhal',
		'IN00777' => 'Bhogaon',
		'IN00778' => 'Gunnaur',
		'IN00779' => 'Bisauli',
		'IN00780' => 'Bilsi',
		'IN00781' => 'Sahaswan',
		'IN00782' => 'Budaun',
		'IN00783' => 'Dataganj',
		'IN00784' => 'Baheri',
		'IN00785' => 'Meerganj',
		'IN00786' => 'Aonla',
		'IN00787' => 'Bareilly',
		'IN00788' => 'Nawabganj',
		'IN00789' => 'Faridpur',
		'IN00790' => 'Pilibhit',
		'IN00791' => 'Bisalpur',
		'IN00792' => 'Puranpur',
		'IN00793' => 'Powayan',
		'IN00794' => 'Tilhar',
		'IN00795' => 'Shahjahanpur',
		'IN00796' => 'Jalalabad',
		'IN00797' => 'Nighasan',
		'IN00798' => 'Palia',
		'IN00799' => 'Gola Gokaran Nath',
		'IN00800' => 'Mohammdi',
		'IN00801' => 'Lakhimpur',
		'IN00802' => 'Dhaurahara',
		'IN00803' => 'Misrikh',
		'IN00804' => 'Sitapur',
		'IN00805' => 'Laharpur',
		'IN00806' => 'Biswan',
		'IN00807' => 'Mahmudabad',
		'IN00808' => 'Sidhauli',
		'IN00809' => 'Shahabad',
		'IN00810' => 'Sawayajpur',
		'IN00811' => 'Hardoi',
		'IN00812' => 'Bilgram',
		'IN00813' => 'Sandila',
		'IN00814' => 'Safipur',
		'IN00815' => 'Hasanganj',
		'IN00816' => 'Unnao',
		'IN00817' => 'Purwa',
		'IN00818' => 'Bighapur',
		'IN00819' => 'Malihabad',
		'IN00820' => 'Bakshi Ka Talab',
		'IN00821' => 'Lucknow',
		'IN00822' => 'Mohanlalganj',
		'IN00823' => 'Maharajganj',
		'IN00824' => 'Tiloi',
		'IN00825' => 'Rae Bareli',
		'IN00826' => 'Lalganj',
		'IN00827' => 'Dalmau',
		'IN00828' => 'Unchahar',
		'IN00829' => 'Salon',
		'IN00830' => 'Kaimganj',
		'IN00831' => 'Amritpur',
		'IN00832' => 'Farrukhabad',
		'IN00833' => 'Chhibramau',
		'IN00834' => 'Kannauj',
		'IN00835' => 'Tirwa',
		'IN00836' => 'Jaswantnagar',
		'IN00837' => 'Saifai',
		'IN00838' => 'Etawah',
		'IN00839' => 'Bharthana',
		'IN00840' => 'Chakarnagar',
		'IN00841' => 'Bidhuna',
		'IN00842' => 'Auraiya',
		'IN00843' => 'Rasulabad',
		'IN00844' => 'Derapur',
		'IN00845' => 'Akbarpur',
		'IN00846' => 'Bhognipur',
		'IN00847' => 'Sikandra',
		'IN00848' => 'Bilhaur',
		'IN00849' => 'Kanpur',
		'IN00850' => 'Ghatampur',
		'IN00851' => 'Madhogarh',
		'IN00852' => 'Jalaun',
		'IN00853' => 'Kalpi',
		'IN00854' => 'Orai',
		'IN00855' => 'Konch',
		'IN00856' => 'Moth',
		'IN00857' => 'Garautha',
		'IN00858' => 'Tahrauli',
		'IN00859' => 'Mauranipur',
		'IN00860' => 'Jhansi',
		'IN00861' => 'Talbehat',
		'IN00862' => 'Lalitpur',
		'IN00863' => 'Mahroni',
		'IN00864' => 'Hamirpur',
		'IN00865' => 'Rath',
		'IN00866' => 'Sarila',
		'IN00867' => 'Maudaha',
		'IN00868' => 'Kulpahar',
		'IN00869' => 'Charkhari',
		'IN00870' => 'Mahoba',
		'IN00871' => 'Banda',
		'IN00872' => 'Baberu',
		'IN00873' => 'Atarra',
		'IN00874' => 'Naraini',
		'IN00875' => 'Karwi',
		'IN00876' => 'Mau',
		'IN00877' => 'Bindki',
		'IN00878' => 'Fatehpur',
		'IN00879' => 'Khaga',
		'IN00880' => 'Lalganj',
		'IN00881' => 'Kunda',
		'IN00882' => 'Pratapgarh',
		'IN00883' => 'Patti',
		'IN00884' => 'Raniganj',
		'IN00885' => 'Sirathu',
		'IN00886' => 'Manjhanpur',
		'IN00887' => 'Chail',
		'IN00888' => 'Soraon',
		'IN00889' => 'Phulpur',
		'IN00890' => 'Allahabad',
		'IN00891' => 'Bara',
		'IN00892' => 'Karchhana',
		'IN00893' => 'Handia',
		'IN00894' => 'Meja',
		'IN00895' => 'Koraon',
		'IN00896' => 'Fatehpur',
		'IN00897' => 'Ramnagar',
		'IN00898' => 'Nawabganj',
		'IN00899' => 'Sirauli Gauspur',
		'IN00900' => 'Ramsanehighat',
		'IN00901' => 'Haidergarh',
		'IN00902' => 'Rudauli',
		'IN00903' => 'Milkipur',
		'IN00904' => 'Sohawal',
		'IN00905' => 'Faizabad',
		'IN00906' => 'Bikapur',
		'IN00907' => 'Tanda',
		'IN00908' => 'Allapur',
		'IN00909' => 'Jalalpur',
		'IN00910' => 'Akbarpur',
		'IN00911' => 'Bhiti',
		'IN00912' => 'Musafirkhana',
		'IN00913' => 'Gauriganj',
		'IN00914' => 'Amethi',
		'IN00915' => 'Sultanpur',
		'IN00916' => 'Jaisinghpur',
		'IN00917' => 'Lambhua',
		'IN00918' => 'Kadipur',
		'IN00919' => 'Nanpara',
		'IN00920' => 'Mahasi',
		'IN00921' => 'Bahraich',
		'IN00922' => 'Kaiserganj',
		'IN00923' => 'Bhinga',
		'IN00924' => 'Ikauna',
		'IN00925' => 'Balrampur',
		'IN00926' => 'Tulsipur',
		'IN00927' => 'Utraula',
		'IN00928' => 'Gonda',
		'IN00929' => 'Colonelganj',
		'IN00930' => 'Tarabganj',
		'IN00931' => 'Mankapur',
		'IN00932' => 'Shohratgarh',
		'IN00933' => 'Naugarh',
		'IN00934' => 'Bansi',
		'IN00935' => 'Itwa',
		'IN00936' => 'Domariyaganj',
		'IN00937' => 'Bhanpur',
		'IN00938' => 'Harraiya',
		'IN00939' => 'Basti',
		'IN00940' => 'Rudhauli',
		'IN00941' => 'Mehdawal',
		'IN00942' => 'Khalilabad',
		'IN00943' => 'Ghanghata',
		'IN00944' => 'Nautanwa',
		'IN00945' => 'Nichlaul',
		'IN00946' => 'Pharenda',
		'IN00947' => 'Maharajganj',
		'IN00948' => 'Campierganj',
		'IN00949' => 'Sahjanwa',
		'IN00950' => 'Gorakhpur',
		'IN00951' => 'Chauri Chaura',
		'IN00952' => 'Bansgaon',
		'IN00953' => 'Khajni',
		'IN00954' => 'Gola',
		'IN00955' => 'Padrauna',
		'IN00956' => 'Hata',
		'IN00957' => 'Kasya',
		'IN00958' => 'Tamkuhi Raj',
		'IN00959' => 'Deoria',
		'IN00960' => 'Rudrapur',
		'IN00961' => 'Barhaj',
		'IN00962' => 'Salempur',
		'IN00963' => 'Bhatpar Rani',
		'IN00964' => 'Burhanpur',
		'IN00965' => 'Sagri',
		'IN00966' => 'Azamgarh',
		'IN00967' => 'Nizamabad',
		'IN00968' => 'Phulpur',
		'IN00969' => 'Lalganj',
		'IN00970' => 'Mehnagar',
		'IN00971' => 'Ghosi',
		'IN00972' => 'Madhuban',
		'IN00973' => 'Maunath Bhanjan',
		'IN00974' => 'Muhammadabad Gohna',
		'IN00975' => 'Belthara Road',
		'IN00976' => 'Sikanderpur',
		'IN00977' => 'Rasra',
		'IN00978' => 'Ballia',
		'IN00979' => 'Bansdih',
		'IN00980' => 'Bairia',
		'IN00981' => 'Shahganj',
		'IN00982' => 'Badlapur',
		'IN00983' => 'Machhlishahr',
		'IN00984' => 'Jaunpur',
		'IN00985' => 'Mariahu',
		'IN00986' => 'Kerakat',
		'IN00987' => 'Jakhania',
		'IN00988' => 'Saidpur',
		'IN00989' => 'Ghazipur',
		'IN00990' => 'Mohammadabad',
		'IN00991' => 'Zamania',
		'IN00992' => 'Sakaldiha',
		'IN00993' => 'Chandauli',
		'IN00994' => 'Chakia',
		'IN00995' => 'Pindra',
		'IN00996' => 'Varanasi',
		'IN00997' => 'Bhadohi',
		'IN00998' => 'Gyanpur',
		'IN00999' => 'Aurai',
		'IN01000' => 'Mirzapur',
		'IN01001' => 'Lalganj',
		'IN01002' => 'Marihan',
		'IN01003' => 'Chunar',
		'IN01004' => 'Ghorawal',
		'IN01005' => 'Robertsganj',
		'IN01006' => 'Dudhi',
		'IN01007' => 'Aliganj',
		'IN01008' => 'Etah',
		'IN01009' => 'Jalesar',
		'IN01010' => 'Kasganj',
		'IN01011' => 'Sahawar',
		'IN01012' => 'Patiyali',
	],
	'BR' => [
		'IN01013' => 'Sidhaw',
		'IN01014' => 'Ramnagar',
		'IN01015' => 'Gaunaha',
		'IN01016' => 'Mainatanr',
		'IN01017' => 'Narkatiaganj',
		'IN01018' => 'Lauriya',
		'IN01019' => 'Bagaha',
		'IN01020' => 'Piprasi',
		'IN01021' => 'Madhubani',
		'IN01022' => 'Bhitaha',
		'IN01023' => 'Thakrahan',
		'IN01024' => 'Jogapatti',
		'IN01025' => 'Chanpatia',
		'IN01026' => 'Sikta',
		'IN01027' => 'Majhaulia',
		'IN01028' => 'Bettiah',
		'IN01029' => 'Bairia',
		'IN01030' => 'Nautan',
		'IN01031' => 'Raxaul',
		'IN01032' => 'Adapur',
		'IN01033' => 'Ramgarhwa',
		'IN01034' => 'Sugauli',
		'IN01035' => 'Banjaria',
		'IN01036' => 'Narkatia',
		'IN01037' => 'Bankatwa',
		'IN01038' => 'Ghorasahan',
		'IN01039' => 'Dhaka',
		'IN01040' => 'Chiraia',
		'IN01041' => 'Motihari',
		'IN01042' => 'Turkaulia',
		'IN01043' => 'Harsidhi',
		'IN01044' => 'Paharpur',
		'IN01045' => 'Areraj',
		'IN01046' => 'Sangrampur',
		'IN01047' => 'Kesaria',
		'IN01048' => 'Kalyanpur',
		'IN01049' => 'Kotwa',
		'IN01050' => 'Piprakothi',
		'IN01051' => 'Chakia(Pipra)',
		'IN01052' => 'Pakri Dayal',
		'IN01053' => 'Patahi',
		'IN01054' => 'Phenhara',
		'IN01055' => 'Madhuban',
		'IN01056' => 'Tetaria',
		'IN01057' => 'Mehsi',
		'IN01058' => 'Purnahiya',
		'IN01059' => 'Piprarhi',
		'IN01060' => 'Sheohar',
		'IN01061' => 'Dumri Katsari',
		'IN01062' => 'Tariani Chowk',
		'IN01063' => 'Bairgania',
		'IN01064' => 'Suppi',
		'IN01065' => 'Majorganj',
		'IN01066' => 'Sonbarsa',
		'IN01067' => 'Parihar',
		'IN01068' => 'Sursand',
		'IN01069' => 'Bathnaha',
		'IN01070' => 'Riga',
		'IN01071' => 'Parsauni',
		'IN01072' => 'Belsand',
		'IN01073' => 'Runisaidpur',
		'IN01074' => 'Dumra',
		'IN01075' => 'Bajpatti',
		'IN01076' => 'Charaut',
		'IN01077' => 'Pupri',
		'IN01078' => 'Nanpur',
		'IN01079' => 'Bokhara',
		'IN01080' => 'Madhwapur',
		'IN01081' => 'Harlakhi',
		'IN01082' => 'Basopatti',
		'IN01083' => 'Jainagar',
		'IN01084' => 'Ladania',
		'IN01085' => 'Laukaha',
		'IN01086' => 'Laukahi',
		'IN01087' => 'Phulparas',
		'IN01088' => 'Babubarhi',
		'IN01089' => 'Khajauli',
		'IN01090' => 'Kaluahi',
		'IN01091' => 'Benipatti',
		'IN01092' => 'Bisfi',
		'IN01093' => 'Madhubani',
		'IN01094' => 'Pandaul',
		'IN01095' => 'Rajnagar',
		'IN01096' => 'Andhratharhi',
		'IN01097' => 'Jhanjharpur',
		'IN01098' => 'Ghoghardiha',
		'IN01099' => 'Lakhnaur',
		'IN01100' => 'Madhepur',
		'IN01101' => 'Nirmali',
		'IN01102' => 'Basantpur',
		'IN01103' => 'Chhatapur',
		'IN01104' => 'Pratapganj',
		'IN01105' => 'Raghopur',
		'IN01106' => 'Saraigarh Bhaptiyahi',
		'IN01107' => 'Kishanpur',
		'IN01108' => 'Marauna',
		'IN01109' => 'Supaul',
		'IN01110' => 'Pipra',
		'IN01111' => 'Tribeniganj',
		'IN01112' => 'Narpatganj',
		'IN01113' => 'Forbesganj',
		'IN01114' => 'Bhargama',
		'IN01115' => 'Raniganj',
		'IN01116' => 'Araria',
		'IN01117' => 'Kursakatta',
		'IN01118' => 'Sikti',
		'IN01119' => 'Palasi',
		'IN01120' => 'Jokihat',
		'IN01121' => 'Terhagachh',
		'IN01122' => 'Dighalbank',
		'IN01123' => 'Thakurganj',
		'IN01124' => 'Pothia',
		'IN01125' => 'Bahadurganj',
		'IN01126' => 'Kochadhamin',
		'IN01127' => 'Kishanganj',
		'IN01128' => 'Banmankhi',
		'IN01129' => 'Barhara',
		'IN01130' => 'Bhawanipur',
		'IN01131' => 'Rupauli',
		'IN01132' => 'Dhamdaha',
		'IN01133' => 'Krityanand Nagar',
		'IN01134' => 'Purnia East',
		'IN01135' => 'Kasba',
		'IN01136' => 'Srinagar',
		'IN01137' => 'Jalalgarh',
		'IN01138' => 'Amour',
		'IN01139' => 'Baisa',
		'IN01140' => 'Baisi',
		'IN01141' => 'Dagarua',
		'IN01142' => 'Falka',
		'IN01143' => 'Korha',
		'IN01144' => 'Hasanganj',
		'IN01145' => 'Kadwa',
		'IN01146' => 'Balrampur',
		'IN01147' => 'Barsoi',
		'IN01148' => 'Azamnagar',
		'IN01149' => 'Pranpur',
		'IN01150' => 'Dandkhora',
		'IN01151' => 'Katihar',
		'IN01152' => 'Mansahi',
		'IN01153' => 'Barari',
		'IN01154' => 'Sameli',
		'IN01155' => 'Kursela',
		'IN01156' => 'Manihari',
		'IN01157' => 'Amdabad',
		'IN01158' => 'Gamharia',
		'IN01159' => 'Singheshwar',
		'IN01160' => 'Ghailarh',
		'IN01161' => 'Madhepura',
		'IN01162' => 'Shankarpur',
		'IN01163' => 'Kumarkhand',
		'IN01164' => 'Murliganj',
		'IN01165' => 'Gwalpara',
		'IN01166' => 'Bihariganj',
		'IN01167' => 'Kishanganj',
		'IN01168' => 'Puraini',
		'IN01169' => 'Alamnagar',
		'IN01170' => 'Chausa',
		'IN01171' => 'Nauhatta',
		'IN01172' => 'Satar Kataiya',
		'IN01173' => 'Mahishi',
		'IN01174' => 'Kahara',
		'IN01175' => 'Saur Bazar',
		'IN01176' => 'Patarghat',
		'IN01177' => 'Sonbarsa',
		'IN01178' => 'Simri Bakhtiarpur',
		'IN01179' => 'Salkhua',
		'IN01180' => 'Banma Itahri',
		'IN01181' => 'Jale',
		'IN01182' => 'Singhwara',
		'IN01183' => 'Keotiranway',
		'IN01184' => 'Darbhanga',
		'IN01185' => 'Manigachhi',
		'IN01186' => 'Tardih',
		'IN01187' => 'Alinagar',
		'IN01188' => 'Benipur',
		'IN01189' => 'Bahadurpur',
		'IN01190' => 'Hanumannagar',
		'IN01191' => 'Hayaghat',
		'IN01192' => 'Baheri',
		'IN01193' => 'Biraul',
		'IN01194' => 'Ghanshyampur',
		'IN01195' => 'Kiratpur',
		'IN01196' => 'Gora Bauram',
		'IN01197' => 'Kusheshwar Asthan',
		'IN01198' => 'Kusheshwar Asthan Purbi',
		'IN01199' => 'Sahebganj',
		'IN01200' => 'Baruraj (Motipur)',
		'IN01201' => 'Paroo',
		'IN01202' => 'Saraiya',
		'IN01203' => 'Marwan',
		'IN01204' => 'Kanti',
		'IN01205' => 'Minapur',
		'IN01206' => 'Bochaha',
		'IN01207' => 'Aurai',
		'IN01208' => 'Katra',
		'IN01209' => 'Gaighat',
		'IN01210' => 'Bandra',
		'IN01211' => 'Dholi (Moraul)',
		'IN01212' => 'Musahri',
		'IN01213' => 'Kurhani',
		'IN01214' => 'Sakra',
		'IN01215' => 'Katiya',
		'IN01216' => 'Bijaipur',
		'IN01217' => 'Bhorey',
		'IN01218' => 'Pach Deuri',
		'IN01219' => 'Kuchaikote',
		'IN01220' => 'Phulwaria',
		'IN01221' => 'Hathua',
		'IN01222' => 'Uchkagaon',
		'IN01223' => 'Thawe',
		'IN01224' => 'Gopalganj',
		'IN01225' => 'Manjha',
		'IN01226' => 'Barauli',
		'IN01227' => 'Sidhwalia',
		'IN01228' => 'Baikunthpur',
		'IN01229' => 'Nautan',
		'IN01230' => 'Siwan',
		'IN01231' => 'Barharia',
		'IN01232' => 'Goriakothi',
		'IN01233' => 'Lakri Nabiganj',
		'IN01234' => 'Basantpur',
		'IN01235' => 'Bhagwanpur Hat',
		'IN01236' => 'Maharajganj',
		'IN01237' => 'Pachrukhi',
		'IN01238' => 'Hussainganj',
		'IN01239' => 'Ziradei',
		'IN01240' => 'Mairwa',
		'IN01241' => 'Guthani',
		'IN01242' => 'Darauli',
		'IN01243' => 'Andar',
		'IN01244' => 'Raghunathpur',
		'IN01245' => 'Hasanpura',
		'IN01246' => 'Daraundha',
		'IN01247' => 'Siswan',
		'IN01248' => 'Mashrakh',
		'IN01249' => 'Panapur',
		'IN01250' => 'Taraiya',
		'IN01251' => 'Ishupur',
		'IN01252' => 'Baniapur',
		'IN01253' => 'Lahladpur',
		'IN01254' => 'Ekma',
		'IN01255' => 'Manjhi',
		'IN01256' => 'Jalalpur',
		'IN01257' => 'Revelganj',
		'IN01258' => 'Chapra',
		'IN01259' => 'Nagra',
		'IN01260' => 'Marhaura',
		'IN01261' => 'Amnour',
		'IN01262' => 'Maker',
		'IN01263' => 'Parsa',
		'IN01264' => 'Dariapur',
		'IN01265' => 'Garkha',
		'IN01266' => 'Dighwara',
		'IN01267' => 'Sonepur',
		'IN01268' => 'Vaishali',
		'IN01269' => 'Paterhi Belsar',
		'IN01270' => 'Lalganj',
		'IN01271' => 'Bhagwanpur',
		'IN01272' => 'Goraul',
		'IN01273' => 'Chehra Kalan',
		'IN01274' => 'Patepur',
		'IN01275' => 'Mahua',
		'IN01276' => 'Jandaha',
		'IN01277' => 'Raja Pakar',
		'IN01278' => 'Hajipur',
		'IN01279' => 'Raghopur',
		'IN01280' => 'Bidupur',
		'IN01281' => 'Desri',
		'IN01282' => 'Sahdai Buzurg',
		'IN01283' => 'Mahnar',
		'IN01284' => 'Kalyanpur',
		'IN01285' => 'Warisnagar',
		'IN01286' => 'Shivaji Nagar',
		'IN01287' => 'Khanpur',
		'IN01288' => 'Samastipur',
		'IN01289' => 'Pusa',
		'IN01290' => 'Tajpur',
		'IN01291' => 'Morwa',
		'IN01292' => 'Patori',
		'IN01293' => 'Mohanpur',
		'IN01294' => 'Mohiuddinagar',
		'IN01295' => 'Sarairanjan',
		'IN01296' => 'Vidyapati Nagar',
		'IN01297' => 'Dalsinghsarai',
		'IN01298' => 'Ujiarpur',
		'IN01299' => 'Bibhutpur',
		'IN01300' => 'Rosera',
		'IN01301' => 'Singhia',
		'IN01302' => 'Hasanpur',
		'IN01303' => 'Bithan',
		'IN01304' => 'Khudabandpur',
		'IN01305' => 'Chhorahi',
		'IN01306' => 'Garhpura',
		'IN01307' => 'Cheria Bariarpur',
		'IN01308' => 'Bhagwanpur',
		'IN01309' => 'Mansurchak',
		'IN01310' => 'Bachhwara',
		'IN01311' => 'Teghra',
		'IN01312' => 'Barauni',
		'IN01313' => 'Birpur',
		'IN01314' => 'Begusarai',
		'IN01315' => 'Naokothi',
		'IN01316' => 'Bakhri',
		'IN01317' => 'Dandari',
		'IN01318' => 'Sahebpur Kamal',
		'IN01319' => 'Balia',
		'IN01320' => 'Matihani',
		'IN01321' => 'Shamho Akha Kurha',
		'IN01322' => 'Alauli',
		'IN01323' => 'Khagaria',
		'IN01324' => 'Mansi',
		'IN01325' => 'Chautham',
		'IN01326' => 'Beldaur',
		'IN01327' => 'Gogri',
		'IN01328' => 'Parbatta',
		'IN01329' => 'Narayanpur',
		'IN01330' => 'Bihpur',
		'IN01331' => 'Kharik',
		'IN01332' => 'Naugachhia',
		'IN01333' => 'Rangra Chowk',
		'IN01334' => 'Gopalpur',
		'IN01335' => 'Pirpainti',
		'IN01336' => 'Colgong',
		'IN01337' => 'Ismailpur',
		'IN01338' => 'Sabour',
		'IN01339' => 'Nathnagar',
		'IN01340' => 'Sultanganj',
		'IN01341' => 'Shahkund',
		'IN01342' => 'Goradih',
		'IN01343' => 'Jagdishpur',
		'IN01344' => 'Sonhaula',
		'IN01345' => 'Shambhuganj',
		'IN01346' => 'Amarpur',
		'IN01347' => 'Rajaun',
		'IN01348' => 'Dhuraiya',
		'IN01349' => 'Barahat',
		'IN01350' => 'Banka',
		'IN01351' => 'Phulidumar',
		'IN01352' => 'Belhar',
		'IN01353' => 'Chanan',
		'IN01354' => 'Katoria',
		'IN01355' => 'Bausi',
		'IN01356' => 'Munger',
		'IN01357' => 'Bariarpur',
		'IN01358' => 'Jamalpur',
		'IN01359' => 'Dharhara',
		'IN01360' => 'Kharagpur',
		'IN01361' => 'Asarganj',
		'IN01362' => 'Tarapur',
		'IN01363' => 'Tetiha Bambor',
		'IN01364' => 'Sangrampur',
		'IN01365' => 'Barahiya',
		'IN01366' => 'Pipariya',
		'IN01367' => 'Surajgarha',
		'IN01368' => 'Lakhisarai',
		'IN01369' => 'Chanan*',
		'IN01370' => 'Ramgarh Chowk',
		'IN01371' => 'Halsi',
		'IN01372' => 'Barbigha',
		'IN01373' => 'Shekhopur Sarai',
		'IN01374' => 'Sheikhpura',
		'IN01375' => 'Ghat Kusumbha',
		'IN01376' => 'Chewara',
		'IN01377' => 'Ariari',
		'IN01378' => 'Karai Parsurai',
		'IN01379' => 'Nagar Nausa',
		'IN01380' => 'Harnaut',
		'IN01381' => 'Chandi',
		'IN01382' => 'Rahui',
		'IN01383' => 'Bind',
		'IN01384' => 'Sarmera',
		'IN01385' => 'Asthawan',
		'IN01386' => 'Bihar',
		'IN01387' => 'Noorsarai',
		'IN01388' => 'Tharthari',
		'IN01389' => 'Parbalpur',
		'IN01390' => 'Hilsa',
		'IN01391' => 'Ekangarsarai',
		'IN01392' => 'Islampur',
		'IN01393' => 'Ben',
		'IN01394' => 'Rajgir',
		'IN01395' => 'Silao',
		'IN01396' => 'Giriak',
		'IN01397' => 'Katrisarai',
		'IN01398' => 'Maner',
		'IN01399' => 'Dinapur-Cum-Khagaul',
		'IN01400' => 'Patna Rural',
		'IN01401' => 'Sampatchak',
		'IN01402' => 'Phulwari',
		'IN01403' => 'Bihta',
		'IN01404' => 'Naubatpur',
		'IN01405' => 'Bikram',
		'IN01406' => 'Dulhin Bazar',
		'IN01407' => 'Paliganj',
		'IN01408' => 'Masaurhi',
		'IN01409' => 'Dhanarua',
		'IN01410' => 'Punpun',
		'IN01411' => 'Fatwah',
		'IN01412' => 'Daniawan',
		'IN01413' => 'Khusrupur',
		'IN01414' => 'Bakhtiarpur',
		'IN01415' => 'Athmalgola',
		'IN01416' => 'Belchhi',
		'IN01417' => 'Barh',
		'IN01418' => 'Pandarak',
		'IN01419' => 'Ghoswari',
		'IN01420' => 'Mokameh',
		'IN01421' => 'Shahpur',
		'IN01422' => 'Arrah',
		'IN01423' => 'Barhara',
		'IN01424' => 'Koilwar',
		'IN01425' => 'Sandesh',
		'IN01426' => 'Udwant Nagar',
		'IN01427' => 'Behea',
		'IN01428' => 'Jagdishpur',
		'IN01429' => 'Piro',
		'IN01430' => 'Charpokhari',
		'IN01431' => 'Garhani',
		'IN01432' => 'Agiaon',
		'IN01433' => 'Tarari',
		'IN01434' => 'Sahar',
		'IN01435' => 'Simri',
		'IN01436' => 'Chakki',
		'IN01437' => 'Barhampur',
		'IN01438' => 'Chaugain',
		'IN01439' => 'Kesath',
		'IN01440' => 'Dumraon',
		'IN01441' => 'Buxar',
		'IN01442' => 'Chausa',
		'IN01443' => 'Rajpur',
		'IN01444' => 'Itarhi',
		'IN01445' => 'Nawanagar',
		'IN01446' => 'Ramgarh',
		'IN01447' => 'Nuaon',
		'IN01448' => 'Kudra',
		'IN01449' => 'Mohania',
		'IN01450' => 'Durgawati',
		'IN01451' => 'Chand',
		'IN01452' => 'Chainpur',
		'IN01453' => 'Bhabua',
		'IN01454' => 'Rampur',
		'IN01455' => 'Bhagwanpur',
		'IN01456' => 'Adhaura',
		'IN01457' => 'Kochas',
		'IN01458' => 'Dinara',
		'IN01459' => 'Dawath',
		'IN01460' => 'Suryapura',
		'IN01461' => 'Bikramganj',
		'IN01462' => 'Karakat',
		'IN01463' => 'Nasriganj',
		'IN01464' => 'Rajpur',
		'IN01465' => 'Sanjhauli',
		'IN01466' => 'Nokha',
		'IN01467' => 'Kargahar',
		'IN01468' => 'Chenari',
		'IN01469' => 'Nauhatta',
		'IN01470' => 'Sheosagar',
		'IN01471' => 'Sasaram',
		'IN01472' => 'Akorhi Gola',
		'IN01473' => 'Dehri',
		'IN01474' => 'Tilouthu',
		'IN01475' => 'Rohtas',
		'IN01476' => 'Daudnagar',
		'IN01477' => 'Haspura',
		'IN01478' => 'Goh',
		'IN01479' => 'Rafiganj',
		'IN01480' => 'Obra',
		'IN01481' => 'Aurangabad',
		'IN01482' => 'Barun',
		'IN01483' => 'Nabinagar',
		'IN01484' => 'Kutumba',
		'IN01485' => 'Deo',
		'IN01486' => 'Madanpur',
		'IN01487' => 'Konch',
		'IN01488' => 'Tikari',
		'IN01489' => 'Belaganj',
		'IN01490' => 'Khizirsarai',
		'IN01491' => 'Neem Chak Bathani',
		'IN01492' => 'Muhra',
		'IN01493' => 'Atri',
		'IN01494' => 'Manpur',
		'IN01495' => 'Gaya Town C.D.Block',
		'IN01496' => 'Paraiya',
		'IN01497' => 'Guraru',
		'IN01498' => 'Gurua',
		'IN01499' => 'Amas',
		'IN01500' => 'Banke Bazar',
		'IN01501' => 'Imamganj',
		'IN01502' => 'Dumaria',
		'IN01503' => 'Sherghati',
		'IN01504' => 'Dobhi',
		'IN01505' => 'Bodh Gaya',
		'IN01506' => 'Tan Kuppa',
		'IN01507' => 'Wazirganj',
		'IN01508' => 'Fatehpur',
		'IN01509' => 'Mohanpur',
		'IN01510' => 'Barachatti',
		'IN01511' => 'Nardiganj',
		'IN01512' => 'Nawada',
		'IN01513' => 'Warisaliganj',
		'IN01514' => 'Kashi Chak',
		'IN01515' => 'Pakribarawan',
		'IN01516' => 'Kawakol',
		'IN01517' => 'Roh',
		'IN01518' => 'Gobindpur',
		'IN01519' => 'Akbarpur',
		'IN01520' => 'Hisua',
		'IN01521' => 'Narhat',
		'IN01522' => 'Meskaur',
		'IN01523' => 'Sirdala',
		'IN01524' => 'Rajauli',
		'IN01525' => 'Islamnagar Aliganj',
		'IN01526' => 'Sikandra',
		'IN01527' => 'Jamui',
		'IN01528' => 'Barhat',
		'IN01529' => 'Lakshmipur',
		'IN01530' => 'Jhajha',
		'IN01531' => 'Gidhaur',
		'IN01532' => 'Khaira',
		'IN01533' => 'Sono',
		'IN01534' => 'Chakai',
		'IN01535' => 'Ratni Faridpur',
		'IN01536' => 'Jehanabad',
		'IN01537' => 'Kako',
		'IN01538' => 'Modanganj',
		'IN01539' => 'Ghoshi',
		'IN01540' => 'Makhdumpur',
		'IN01541' => 'Hulasganj',
		'IN01542' => 'Arwal',
		'IN01543' => 'Kaler',
		'IN01544' => 'Karpi',
		'IN01545' => 'Sonbhadra Banshi Suryapur',
		'IN01546' => 'Kurtha',
	],
	'SK' => [
		'IN01547' => 'Tshungthang',
		'IN01548' => 'Mangan',
		'IN01549' => 'Gyalshing',
		'IN01550' => 'Soreng',
		'IN01551' => 'Namchi',
		'IN01552' => 'Ravong',
		'IN01553' => 'Gangtok',
		'IN01554' => 'Pakyong',
		'IN01555' => 'Rongli',
		'IN01556' => 'Zemithang',
	],
	'AR' => [
		'IN01557' => 'Lumla',
		'IN01558' => 'Dudunghar',
		'IN01559' => 'Tawang',
		'IN01560' => 'Kitpi',
		'IN01561' => 'Jang',
		'IN01562' => 'Lhou',
		'IN01563' => 'Mukto',
		'IN01564' => 'Bongkhar',
		'IN01565' => 'Thingbu',
		'IN01566' => 'Dirang',
		'IN01567' => 'Thembang',
		'IN01568' => 'Nafra',
		'IN01569' => 'Bomdila',
		'IN01570' => 'Kalaktang',
		'IN01571' => 'Shergaon',
		'IN01572' => 'Rupa',
		'IN01573' => 'Singchung',
		'IN01574' => 'Jamiri',
		'IN01575' => 'Thrizino',
		'IN01576' => 'Bhalukpong',
		'IN01577' => 'Kamengbari-Doimara',
		'IN01578' => 'Balemu',
		'IN01579' => 'Seijosa',
		'IN01580' => 'Dissing-Passo',
		'IN01581' => 'Pakke-Kessang',
		'IN01582' => 'Pizirang(Veo)',
		'IN01583' => 'Richukrong',
		'IN01584' => 'Seppa',
		'IN01585' => 'Lada',
		'IN01586' => 'Bameng',
		'IN01587' => 'Pipu-Dipu',
		'IN01588' => 'Gyawe Purang',
		'IN01589' => 'Khenewa',
		'IN01590' => 'Chayangtajo',
		'IN01591' => 'Sawa',
		'IN01592' => 'Balijan',
		'IN01593' => 'Banderdawa',
		'IN01594' => 'Sangdupota (Besar Nello)',
		'IN01595' => 'Taraso',
		'IN01596' => 'Itanagar',
		'IN01597' => 'Naharlagun',
		'IN01598' => 'Doimukh',
		'IN01599' => 'Gumto',
		'IN01600' => 'Toru',
		'IN01601' => 'Sagalee',
		'IN01602' => 'Parang',
		'IN01603' => 'Leporiang',
		'IN01604' => 'Mengio',
		'IN01605' => 'Kimin',
		'IN01606' => 'Kakoi',
		'IN01607' => 'Taksing',
		'IN01608' => 'Limeking',
		'IN01609' => 'Nacho',
		'IN01610' => 'Siyum',
		'IN01611' => 'Taliha',
		'IN01612' => 'Payeng',
		'IN01613' => 'Giba',
		'IN01614' => 'Chetam (Peer Yapu)',
		'IN01615' => 'Daporijo',
		'IN01616' => 'Puchi Geko',
		'IN01617' => 'Dumporijo',
		'IN01618' => 'Gussar',
		'IN01619' => 'Gite-Ripa',
		'IN01620' => 'Baririjo',
		'IN01621' => 'Maro',
		'IN01622' => 'Mechuka',
		'IN01623' => 'Monigong',
		'IN01624' => 'Pidi',
		'IN01625' => 'Payum',
		'IN01626' => 'Tato',
		'IN01627' => 'Kaying',
		'IN01628' => 'Darak',
		'IN01629' => 'Kamba',
		'IN01630' => 'Rumgong',
		'IN01631' => 'Jomlo Mobuk',
		'IN01632' => 'Liromoba',
		'IN01633' => 'Yomcha',
		'IN01634' => 'Aalo',
		'IN01635' => 'Tirbin',
		'IN01636' => 'Basar',
		'IN01637' => 'Daring',
		'IN01638' => 'Gensi',
		'IN01639' => 'Sibe',
		'IN01640' => 'Likabali',
		'IN01641' => 'Kangku',
		'IN01642' => 'Bagra',
		'IN01643' => 'Boleng',
		'IN01644' => 'Riga',
		'IN01645' => 'Pangin',
		'IN01646' => 'Kebang',
		'IN01647' => 'Rebo-Perging',
		'IN01648' => 'Koyu',
		'IN01649' => 'Kora',
		'IN01650' => 'Nari',
		'IN01651' => 'New Seren',
		'IN01652' => 'Bilat',
		'IN01653' => 'Ruksin',
		'IN01654' => 'Sille-Oyan',
		'IN01655' => 'Pasighat',
		'IN01656' => 'Mebo',
		'IN01657' => 'Namsing',
		'IN01658' => 'Tuting',
		'IN01659' => 'Migging',
		'IN01660' => 'Palling',
		'IN01661' => 'Gelling',
		'IN01662' => 'Singa',
		'IN01663' => 'Yingkiong',
		'IN01664' => 'Jengging',
		'IN01665' => 'Geku',
		'IN01666' => 'Mariyang',
		'IN01667' => 'Mopom ( Adipasi )',
		'IN01668' => 'Katan',
		'IN01669' => 'Khimiyong',
		'IN01670' => 'Yatdam',
		'IN01671' => 'Changlang',
		'IN01672' => 'Namtok',
		'IN01673' => 'Manmao',
		'IN01674' => 'Renuk',
		'IN01675' => 'Lyngok-Longtoi',
		'IN01676' => 'Nampong',
		'IN01677' => 'Tikhak Rima Putok',
		'IN01678' => 'Jairampur',
		'IN01679' => 'Vijoynagar',
		'IN01680' => 'Miao',
		'IN01681' => 'Kharsang',
		'IN01682' => 'Diyun',
		'IN01683' => 'Bordumsa',
		'IN01684' => 'Namsang',
		'IN01685' => 'Soha',
		'IN01686' => 'Khonsa',
		'IN01687' => 'Dadam',
		'IN01688' => 'Kanubari',
		'IN01689' => 'Lawnu',
		'IN01690' => 'Longding',
		'IN01691' => 'Pumao',
		'IN01692' => 'Pangchao',
		'IN01693' => 'Wakka',
		'IN01694' => 'Laju',
		'IN01695' => 'Ziro (Sadar)',
		'IN01696' => 'Old Ziro',
		'IN01697' => 'Yachuli',
		'IN01698' => 'Yazali',
		'IN01699' => 'Pistana',
		'IN01700' => 'Kamporijo',
		'IN01701' => 'Dollungmukh',
		'IN01702' => 'Raga',
		'IN01703' => 'Palin',
		'IN01704' => 'Yangte',
		'IN01705' => 'Sangram',
		'IN01706' => 'Nyapin',
		'IN01707' => 'Phassang',
		'IN01708' => 'Koloriang',
		'IN01709' => 'Chambang',
		'IN01710' => 'Gangte',
		'IN01711' => 'Tarak-Lengdi',
		'IN01712' => 'Sarli',
		'IN01713' => 'Parsi-Parlo',
		'IN01714' => 'Damin',
		'IN01715' => 'Longding Koling (Pipsorang)',
		'IN01716' => 'Tali',
		'IN01717' => 'Mipi',
		'IN01718' => 'Anini',
		'IN01719' => 'Etalin',
		'IN01720' => 'Anelih',
		'IN01721' => 'Kronli (Arzoo circle)',
		'IN01722' => 'Hunli',
		'IN01723' => 'Desali',
		'IN01724' => 'Roing',
		'IN01725' => 'Dambuk',
		'IN01726' => 'Tinali ( Paglam )',
		'IN01727' => 'Koronu',
		'IN01728' => 'Sunpura',
		'IN01729' => 'Tezu',
		'IN01730' => 'Wakro',
		'IN01731' => 'Chongkham',
		'IN01732' => 'Namsai',
		'IN01733' => 'Lathao',
		'IN01734' => 'Piyong',
		'IN01735' => 'Lekang (Mahadevpur)',
		'IN01736' => 'Hayuliang',
		'IN01737' => 'Manchal',
		'IN01738' => 'Goiliang',
		'IN01739' => 'Chaglagam',
		'IN01740' => 'Metengliang',
		'IN01741' => 'Kibithoo',
		'IN01742' => 'Walong',
		'IN01743' => 'Hawai',
	],
	'NL' => [
		'IN01744' => 'Naginimora',
		'IN01745' => 'Tizit',
		'IN01746' => 'Hunta',
		'IN01747' => 'Shangnyu',
		'IN01748' => 'Mon Sadar',
		'IN01749' => 'Wakching',
		'IN01750' => 'Aboi',
		'IN01751' => 'Longshen',
		'IN01752' => 'Phomching',
		'IN01753' => 'Chen',
		'IN01754' => 'Angjangyang',
		'IN01755' => 'Mopong',
		'IN01756' => 'Tobu',
		'IN01757' => 'Monyakshu',
		'IN01758' => 'Longchem',
		'IN01759' => 'Alongkima',
		'IN01760' => 'Tuli',
		'IN01761' => 'Changtongya',
		'IN01762' => 'Chuchuyimlang',
		'IN01763' => 'Kubolong',
		'IN01764' => 'Mangkolemba',
		'IN01765' => 'Merangmen',
		'IN01766' => 'Ongpangkong',
		'IN01767' => 'V.K.',
		'IN01768' => 'Akuluto',
		'IN01769' => 'Suruhuto',
		'IN01770' => 'Asuto',
		'IN01771' => 'Aghunato',
		'IN01772' => 'Zunheboto Sadar',
		'IN01773' => 'Atoizu',
		'IN01774' => 'Akuhaito',
		'IN01775' => 'Pughoboto',
		'IN01776' => 'Ghathashi',
		'IN01777' => 'Satakha',
		'IN01778' => 'Saptiqa',
		'IN01779' => 'Satoi',
		'IN01780' => 'Changpang',
		'IN01781' => 'Aitepyong',
		'IN01782' => 'Bhandari',
		'IN01783' => 'Baghty',
		'IN01784' => 'Sungro',
		'IN01785' => 'Sanis',
		'IN01786' => 'Lotsu',
		'IN01787' => 'Ralan',
		'IN01788' => 'Wozhuro',
		'IN01789' => 'Wokha Sadar',
		'IN01790' => 'Englan',
		'IN01791' => 'Chukitong',
		'IN01792' => 'Niuland',
		'IN01793' => 'Aquqhnaqua',
		'IN01794' => 'Kuhoboto',
		'IN01795' => 'Nihokhu',
		'IN01796' => 'Dimapur Sadar',
		'IN01797' => 'Chumukedima',
		'IN01798' => 'Dhansiripar',
		'IN01799' => 'Medziphema',
		'IN01800' => 'Sekruzu',
		'IN01801' => 'Phek Sadar',
		'IN01802' => 'Khuza',
		'IN01803' => 'Meluri',
		'IN01804' => 'Phor',
		'IN01805' => 'Phokhungri',
		'IN01806' => 'Chozuba',
		'IN01807' => 'Chetheba',
		'IN01808' => 'Sakraba',
		'IN01809' => 'Pfutsero',
		'IN01810' => 'Zuketsa',
		'IN01811' => 'Khezhakeno',
		'IN01812' => 'Chizami',
		'IN01813' => 'Razieba',
		'IN01814' => 'Noksen',
		'IN01815' => 'Chare',
		'IN01816' => 'Longkhim',
		'IN01817' => 'Tuensang Sadar',
		'IN01818' => 'Ngoungchung',
		'IN01819' => 'Sangsangnyu',
		'IN01820' => 'Sotokur',
		'IN01821' => 'Noklak',
		'IN01822' => 'Chingmei',
		'IN01823' => 'Nokhu',
		'IN01824' => 'Panso',
		'IN01825' => 'Shamator',
		'IN01826' => 'Tsurungto',
		'IN01827' => 'Chessore',
		'IN01828' => 'Mangko',
		'IN01829' => 'Thonoknyu',
		'IN01830' => 'Tamlu',
		'IN01831' => 'Namsang',
		'IN01832' => 'Yongnyah',
		'IN01833' => 'Longleng',
		'IN01834' => 'Sakshi',
		'IN01835' => 'Seyochung',
		'IN01836' => 'Amahator',
		'IN01837' => 'Kiphire Sadar',
		'IN01838' => 'Kiusam',
		'IN01839' => 'Sitimi',
		'IN01840' => 'Longmatra',
		'IN01841' => 'Pungro',
		'IN01842' => 'Khongsa',
		'IN01843' => 'Tseminyu',
		'IN01844' => 'Tsogin',
		'IN01845' => 'Chiephobozou',
		'IN01846' => 'Botsa',
		'IN01847' => 'Kezocha',
		'IN01848' => 'Jakhama',
		'IN01849' => 'Kohima Sadar',
		'IN01850' => 'Sechu-Zubza',
		'IN01851' => 'Pedi (Ngwalwa)',
		'IN01852' => 'Jalukie',
		'IN01853' => 'Athibung',
		'IN01854' => 'Kebai Khelma',
		'IN01855' => 'Nsong',
		'IN01856' => 'Tening',
		'IN01857' => 'Peren',
	],
	'MN' => [
		'IN01858' => 'Mao-Maram',
		'IN01859' => 'Paomata',
		'IN01860' => 'Purul',
		'IN01861' => 'Sadar Hills West',
		'IN01862' => 'Saitu-Gamphazol',
		'IN01863' => 'Sadar Hills East',
		'IN01864' => 'Tamenglong West',
		'IN01865' => 'Tamenglong North',
		'IN01866' => 'Tamenglong',
		'IN01867' => 'Nungba',
		'IN01868' => 'Tipaimukh',
		'IN01869' => 'Thanlon',
		'IN01870' => 'Churachandpur North',
		'IN01871' => 'Churachandpur',
		'IN01872' => 'Singngat',
		'IN01873' => 'Nambol',
		'IN01874' => 'Bishnupur',
		'IN01875' => 'Moirang',
		'IN01876' => 'Lilong',
		'IN01877' => 'Thoubal',
		'IN01878' => 'Kakching',
		'IN01879' => 'Lamshang',
		'IN01880' => 'Patsoi',
		'IN01881' => 'Lamphelpat',
		'IN01882' => 'Wangoi',
		'IN01883' => 'Jiribam',
		'IN01884' => 'Sawombung',
		'IN01885' => 'Porompat',
		'IN01886' => 'Keirao Bitra',
		'IN01887' => 'Ukhrul North',
		'IN01888' => 'Ukhurl Central',
		'IN01889' => 'Kamjong-Chassad',
		'IN01890' => 'Phungyar-Phaisat',
		'IN01891' => 'Ukhrul South',
		'IN01892' => 'Machi',
		'IN01893' => 'Tengnoupal',
		'IN01894' => 'Chandel',
		'IN01895' => 'Chakpikarong',
	],
	'MZ' => [
		'IN01896' => 'Zawlnuam',
		'IN01897' => 'West Phaileng',
		'IN01898' => 'Reiek',
		'IN01899' => ' N Thingdawl',
		'IN01900' => 'Bilkhawthlir',
		'IN01901' => 'Tlangnuam (Part)',
		'IN01902' => 'Darlawn',
		'IN01903' => 'Phullen',
		'IN01904' => 'Aibawk',
		'IN01901' => 'Tlangnuam (Part)',
		'IN01905' => 'Thingsulthliah (Part)',
		'IN01906' => 'Ngopa',
		'IN01907' => 'Khawzawl',
		'IN01908' => 'Champhai',
		'IN01909' => 'Khawbung',
		'IN01911' => 'East Lungdar (Part)',
		'IN01905' => 'Thingsulthliah (Part)',
		'IN01910' => 'Serchhip',
		'IN01911' => 'East Lungdar (Part)',
		'IN01912' => 'West Bunghmun',
		'IN01913' => 'Lungsen',
		'IN01914' => 'Lunglei',
		'IN01915' => 'Hnahthial',
		'IN01916' => 'Chawngte',
		'IN01917' => 'Lawngtlai',
		'IN01918' => 'S Bungtlang',
		'IN01919' => 'Sangau',
		'IN01920' => 'Tuipang',
		'IN01921' => 'Saiha',
	],
	'TR' => [
		'IN01922' => 'Mohanpur',
		'IN01923' => 'Hezamara',
		'IN01924' => 'Padmabil',
		'IN01925' => 'Khowai',
		'IN01926' => 'Tulashikhar',
		'IN01927' => 'Kalyanpur',
		'IN01928' => 'Teliamura',
		'IN01929' => 'Mungiakumi',
		'IN01930' => 'Mandai',
		'IN01931' => 'Jirania',
		'IN01932' => 'Dukli',
		'IN01933' => 'Jampuijala',
		'IN01934' => 'Bishalgarh',
		'IN01935' => 'Boxanagar',
		'IN01936' => 'Melaghar',
		'IN01937' => 'Kathalia',
		'IN01938' => 'Killa',
		'IN01939' => 'Amarpur',
		'IN01940' => 'Ompi',
		'IN01941' => 'Matarbari',
		'IN01942' => 'Kakraban',
		'IN01943' => 'Rajnagar',
		'IN01944' => 'Hrishyamukh',
		'IN01945' => 'Bokafa',
		'IN01946' => 'Karbuk',
		'IN01947' => 'Rupaichhari',
		'IN01948' => 'Satchand',
		'IN01949' => 'Salema',
		'IN01950' => 'Manu',
		'IN01951' => 'Ambassa',
		'IN01952' => 'Chhamanu',
		'IN01953' => 'Dumburnagar',
		'IN01954' => 'Gournagar',
		'IN01955' => 'Kadamtala',
		'IN01956' => 'Panisagar',
		'IN01957' => 'Damchhara',
		'IN01958' => 'Pencharthal',
		'IN01959' => 'Kumarghat',
		'IN01960' => 'Dasda',
		'IN01961' => 'Jampuii hills',
	],
	'ML' => [
		'IN01962' => 'Selsella',
		'IN01963' => 'Dadenggiri',
		'IN01964' => 'Tikrikilla',
		'IN01965' => 'Rongram',
		'IN01966' => 'Betasing',
		'IN01967' => 'Zikzak',
		'IN01968' => 'Gambegre',
		'IN01969' => 'Dalu',
		'IN01970' => 'Resubelpara',
		'IN01971' => 'Dambo Rongjeng',
		'IN01972' => 'Kharkutta',
		'IN01973' => 'Songsak',
		'IN01974' => 'Samanda',
		'IN01975' => 'Chokpot',
		'IN01976' => 'Gasuapara',
		'IN01977' => 'Baghmara',
		'IN01978' => 'Rongara',
		'IN01979' => 'Mawshynrut',
		'IN01980' => 'Nongstoin',
		'IN01981' => 'Mawthadraishan',
		'IN01982' => 'Mairang',
		'IN01983' => 'Ranikor',
		'IN01984' => 'Mawkyrwat',
		'IN01985' => 'Umling',
		'IN01986' => 'Jirang',
		'IN01987' => 'Umsning',
		'IN01988' => 'Mawphlang',
		'IN01989' => 'Mylliem',
		'IN01990' => 'Mawryngkneng',
		'IN01991' => 'Mawkynrew',
		'IN01992' => 'Khatarshnong Laitkroh',
		'IN01993' => 'Mawsynram',
		'IN01994' => 'Shella Bholaganj',
		'IN01995' => 'Pynursla',
		'IN01996' => 'Thadlaskein',
		'IN01997' => 'Laskein',
		'IN01998' => 'Amlarem',
		'IN01999' => 'Khliehriat',
		'IN02000' => 'Saipung',
	],
	'AS' => [
		'IN02001' => 'Gossaigaon (Pt)',
		'IN02002' => 'Bhowraguri',
		'IN02003' => 'Dotoma',
		'IN02004' => 'Kokrajhar (Pt)',
		'IN02007' => 'Golokganj (Pt)',
		'IN02008' => 'Dhubri (Pt)',
		'IN02005' => 'Bagribari (Pt)',
		'IN02009' => 'Bilasipara (Pt)',
		'IN02010' => 'Chapar (Pt)',
		'IN02001' => 'Gossaigaon (Pt)',
		'IN02006' => 'Agamoni',
		'IN02007' => 'Golokganj (Pt)',
		'IN02008' => 'Dhubri (Pt)',
		'IN02005' => 'Bagribari (Pt)',
		'IN02009' => 'Bilasipara (Pt)',
		'IN02010' => 'Chapar (Pt)',
		'IN02011' => 'South Salmara',
		'IN02012' => 'Mankachar',
		'IN02013' => 'Lakhipur',
		'IN02014' => 'Balijana',
		'IN02015' => 'Matia',
		'IN02016' => 'Dudhnai',
		'IN02017' => 'Rangjuli',
		'IN02018' => 'Barnagar (Pt)',
		'IN02019' => 'Kalgachia',
		'IN02020' => 'Baghbor',
		'IN02021' => 'Chenga',
		'IN02022' => 'Barpeta',
		'IN02023' => 'Sarthebari',
		'IN02024' => 'Bajali (Pt)',
		'IN02025' => 'Sarupeta (Pt)',
		'IN02140' => 'Jalah (Pt)',
		'IN02026' => 'Mayong',
		'IN02027' => 'Bhuragaon',
		'IN02028' => 'Laharighat',
		'IN02029' => 'Marigaon',
		'IN02030' => 'Mikirbheta',
		'IN02031' => 'Kaliabor',
		'IN02032' => 'Samaguri',
		'IN02033' => 'Rupahi',
		'IN02034' => 'Dhing',
		'IN02035' => 'Nagaon',
		'IN02036' => 'Raha',
		'IN02037' => 'Kampur',
		'IN02038' => 'Hojai',
		'IN02039' => 'Doboka',
		'IN02040' => 'Lanka',
		'IN02041' => 'Dhekiajuli (Pt)',
		'IN02042' => 'Chariduar',
		'IN02043' => 'Tezpur',
		'IN02044' => 'Na-Duar',
		'IN02045' => 'Biswanath',
		'IN02046' => 'Helem',
		'IN02047' => 'Gohpur',
		'IN02048' => 'Narayanpur',
		'IN02049' => 'Bihpuria',
		'IN02050' => 'Naobaicha',
		'IN02051' => 'Kadam',
		'IN02052' => 'North Lakhimpur',
		'IN02053' => 'Dhakuakhana (Pt)',
		'IN02054' => 'Subansiri (Pt)',
		'IN02055' => 'Dhemaji',
		'IN02056' => 'Sissibargaon',
		'IN02057' => 'Jonai',
		'IN02053' => 'Dhakuakhana (Pt-I)',
		'IN02054' => 'Subansiri (Pt-I)',
		'IN02058' => 'Gogamukh',
		'IN02059' => 'Sadiya',
		'IN02060' => 'Doom Dooma',
		'IN02061' => 'Tinsukia',
		'IN02062' => 'Margherita',
		'IN02063' => 'Dibrugarh West',
		'IN02064' => 'Dibrugarh East',
		'IN02065' => 'Chabua',
		'IN02066' => 'Tengakhat',
		'IN02067' => 'Moran',
		'IN02068' => 'Tingkhong',
		'IN02069' => 'Naharkatiya',
		'IN02070' => 'Dimow',
		'IN02071' => 'Sibsagar',
		'IN02072' => 'Amguri',
		'IN02073' => 'Nazira',
		'IN02074' => 'Sonari',
		'IN02075' => 'Mahmora',
		'IN02076' => 'Majuli',
		'IN02077' => 'Jorhat West',
		'IN02078' => 'Jorhat East',
		'IN02079' => 'Teok',
		'IN02080' => 'Titabor',
		'IN02081' => 'Mariani',
		'IN02082' => 'Bokakhat',
		'IN02083' => 'Khumtai',
		'IN02084' => 'Dergaon',
		'IN02085' => 'Golaghat',
		'IN02086' => 'Morangi',
		'IN02087' => 'Sarupathar',
		'IN02088' => 'Donka',
		'IN02089' => 'Diphu',
		'IN02090' => 'Phuloni',
		'IN02091' => 'Silonijan',
		'IN02092' => 'Umrangso',
		'IN02093' => 'Haflong',
		'IN02094' => 'Mahur',
		'IN02095' => 'Maibong',
		'IN02096' => 'Katigora',
		'IN02097' => 'Silchar',
		'IN02098' => 'Udarbond',
		'IN02099' => 'Sonai',
		'IN02100' => 'Lakhipur',
		'IN02101' => 'Karimganj',
		'IN02102' => 'Badarpur',
		'IN02103' => 'Nilambazar',
		'IN02104' => 'Patharkandi',
		'IN02105' => 'Ramkrishna Nagar',
		'IN02106' => 'Algapur',
		'IN02107' => 'Hailakandi',
		'IN02108' => 'Lala',
		'IN02109' => 'Katlichara',
		'IN02110' => 'Bongaigaon (Pt)',
		'IN02111' => 'Boitamari',
		'IN02112' => 'Srijangram',
		'IN02115' => 'Bijni (Pt)',
		'IN02114' => 'Sidli (Pt)',
		'IN02004' => 'Kokrajhar (Pt)',
		'IN02113' => 'Bengtol',
		'IN02114' => 'Sidli (Pt)',
		'IN02110' => 'Bongaigaon (Pt)',
		'IN02115' => 'Bijni (Pt)',
		'IN02018' => 'Barnagar (Pt)',
		'IN02141' => 'Goreswar (Pt)',
		'IN02116' => 'Rangia (Pt)',
		'IN02117' => 'Koya',
		'IN02118' => 'Kamalpur',
		'IN02119' => 'Hajo',
		'IN02120' => 'Chhaygaon',
		'IN02121' => 'Goroimari',
		'IN02122' => 'Chamaria',
		'IN02123' => 'Nagarbera',
		'IN02124' => 'Boko',
		'IN02125' => 'Palasbari',
		'IN02126' => 'North Guwahati (Pt)',
		'IN02127' => 'Azara',
		'IN02126' => 'North Guwahati (Pt)',
		'IN02128' => 'Guwahati',
		'IN02129' => 'Dispur',
		'IN02130' => 'Sonapur',
		'IN02131' => 'Chandrapur',
		'IN02142' => 'Barama (Pt)',
		'IN02132' => 'Tihu (Pt)',
		'IN02133' => 'Pachim Nalbari',
		'IN02134' => 'Barkhetri',
		'IN02135' => 'Barbhag',
		'IN02136' => 'Nalbari',
		'IN02137' => 'Banekuchi',
		'IN02138' => 'Ghograpar (Pt)',
		'IN02139' => 'Baganpara (Pt)',
		'IN02018' => 'Barnagar (Pt)',
		'IN02024' => 'Bajali (Pt)',
		'IN02025' => 'Sarupeta (Pt)',
		'IN02140' => 'Jalah (Pt)',
		'IN02141' => 'Goreswar (Pt)',
		'IN02116' => 'Rangia (Pt)',
		'IN02142' => 'Barama (Pt)',
		'IN02132' => 'Tihu (Pt)',
		'IN02138' => 'Ghograpar (Pt)',
		'IN02143' => 'Baska',
		'IN02139' => 'Baganpara (Pt)',
		'IN02144' => 'Tamulpur',
		'IN02146' => 'Pathorighat (Pt)',
		'IN02145' => 'Khoirabari (Pt)',
		'IN02146' => 'Pathorighat (Pt)',
		'IN02147' => 'Sipajhar',
		'IN02148' => 'Mangaldoi (Pt)',
		'IN02150' => 'Kalaigaon (Pt)',
		'IN02149' => 'Dalgaon (Pt)',
		'IN02145' => 'Khoirabari (Pt)',
		'IN02146' => 'Pathorighat (Pt)',
		'IN02148' => 'Mangaldoi (Pt)',
		'IN02150' => 'Kalaigaon (Pt)',
		'IN02149' => 'Dalgaon (Pt)',
		'IN02151' => 'Harisinga',
		'IN02152' => 'Udalguri',
		'IN02153' => 'Mazbat',
		'IN02041' => 'Dhekiajuli (Pt)',
	],
	'WB' => [
		'IN02154' => 'Darjeeling Pulbazar',
		'IN02155' => 'Rangli Rangliot',
		'IN02156' => 'Kalimpong -I',
		'IN02157' => 'Kalimpong - II',
		'IN02158' => 'Gorubathan',
		'IN02159' => 'Jorebunglow Sukiapokhri',
		'IN02160' => 'Mirik',
		'IN02161' => 'Kurseong',
		'IN02162' => 'Matigara',
		'IN02163' => 'Naxalbari',
		'IN02164' => 'Phansidewa',
		'IN02165' => 'Kharibari',
		'IN02166' => 'Rajganj',
		'IN02167' => 'Mal',
		'IN02168' => 'Matiali',
		'IN02169' => 'Nagrakata',
		'IN02170' => 'Madarihat',
		'IN02171' => 'Kalchini',
		'IN02172' => 'Kumargram',
		'IN02173' => 'Alipurduar - I',
		'IN02174' => 'Alipurduar - II',
		'IN02175' => 'Falakata',
		'IN02176' => 'Dhupguri',
		'IN02177' => 'Maynaguri',
		'IN02178' => 'Jalpaiguri',
		'IN02179' => 'Haldibari',
		'IN02180' => 'Mekliganj',
		'IN02181' => 'Mathabhanga - I',
		'IN02182' => 'Mathabhanga - II',
		'IN02183' => 'Cooch Behar - I',
		'IN02184' => 'Cooch Behar - II',
		'IN02185' => 'Tufanganj - I',
		'IN02186' => 'Tufanganj - II',
		'IN02187' => 'Dinhata - I',
		'IN02188' => 'Dinhata - II',
		'IN02189' => 'Sitai',
		'IN02190' => 'Sitalkuchi',
		'IN02191' => 'Chopra',
		'IN02192' => 'Islampur',
		'IN02193' => 'Goalpokhar - I',
		'IN02194' => 'Goalpokhar - II',
		'IN02195' => 'Karandighi',
		'IN02196' => 'Raiganj',
		'IN02197' => 'Hemtabad',
		'IN02198' => 'Kaliaganj',
		'IN02199' => 'Itahar',
		'IN02200' => 'Kushmundi',
		'IN02201' => 'Gangarampur',
		'IN02202' => 'Kumarganj',
		'IN02203' => 'Hilli',
		'IN02204' => 'Balurghat',
		'IN02205' => 'Tapan',
		'IN02206' => 'Bansihari',
		'IN02207' => 'Harirampur',
		'IN02208' => 'Harischandrapur - I',
		'IN02209' => 'Harischandrapur - II',
		'IN02210' => 'Chanchal - I',
		'IN02211' => 'Chanchal - II',
		'IN02212' => 'Ratua - I',
		'IN02213' => 'Ratua - II',
		'IN02214' => 'Gazole',
		'IN02215' => 'Bamangola',
		'IN02216' => 'Habibpur',
		'IN02217' => 'Maldah (Old)',
		'IN02218' => 'English Bazar',
		'IN02219' => 'Manikchak',
		'IN02220' => 'Kaliachak - I',
		'IN02221' => 'Kaliachak - II',
		'IN02222' => 'Kaliachak - III',
		'IN02223' => 'Farakka',
		'IN02224' => 'Samserganj',
		'IN02225' => 'Suti - I',
		'IN02226' => 'Suti - II',
		'IN02227' => 'Raghunathganj - I',
		'IN02228' => 'Raghunathganj - II',
		'IN02229' => 'Lalgola',
		'IN02230' => 'Sagardighi',
		'IN02231' => 'Bhagawangola - I',
		'IN02232' => 'Bhagawangola - II',
		'IN02233' => 'Raninagar - II',
		'IN02234' => 'Jalangi',
		'IN02235' => 'Domkal',
		'IN02236' => 'Raninagar - I',
		'IN02237' => 'Murshidabad Jiaganj',
		'IN02238' => 'Nabagram',
		'IN02239' => 'Khargram',
		'IN02240' => 'Kandi',
		'IN02241' => 'Berhampore',
		'IN02242' => 'Hariharpara',
		'IN02243' => 'Nawda',
		'IN02244' => 'Beldanga - I',
		'IN02245' => 'Beldanga - II',
		'IN02246' => 'Bharatpur - II',
		'IN02247' => 'Bharatpur - I',
		'IN02248' => 'Burwan',
		'IN02249' => 'Murarai - I',
		'IN02250' => 'Murarai - II',
		'IN02251' => 'Nalhati - I',
		'IN02252' => 'Nalhati - II',
		'IN02253' => 'Rampurhat - I',
		'IN02254' => 'Rampurhat - II',
		'IN02255' => 'Mayureswar - I',
		'IN02256' => 'Mayureswar - II',
		'IN02257' => 'Mohammad Bazar',
		'IN02258' => 'Rajnagar',
		'IN02259' => 'Suri - I',
		'IN02260' => 'Suri - II',
		'IN02261' => 'Sainthia',
		'IN02262' => 'Labpur',
		'IN02263' => 'Nanoor',
		'IN02264' => 'Bolpur Sriniketan',
		'IN02265' => 'Illambazar',
		'IN02266' => 'Dubrajpur',
		'IN02267' => 'Khoyrasol',
		'IN02268' => 'Salanpur',
		'IN02269' => 'Barabani',
		'IN02270' => 'Jamuria',
		'IN02271' => 'Raniganj',
		'IN02272' => 'Ondal',
		'IN02273' => 'Pandabeswar',
		'IN02274' => 'Faridpur Durgapur',
		'IN02275' => 'Kanksa',
		'IN02276' => 'Ausgram - II',
		'IN02277' => 'Ausgram - I',
		'IN02278' => 'Mangolkote',
		'IN02279' => 'Ketugram - I',
		'IN02280' => 'Ketugram - II',
		'IN02281' => 'Katwa - I',
		'IN02282' => 'Katwa - II',
		'IN02283' => 'Purbasthali - I',
		'IN02284' => 'Purbasthali - II',
		'IN02285' => 'Manteswar',
		'IN02286' => 'Bhatar',
		'IN02287' => 'Galsi - I',
		'IN02288' => 'Galsi - II',
		'IN02289' => 'Burdwan - I',
		'IN02290' => 'Burdwan - II',
		'IN02291' => 'Memari - I',
		'IN02292' => 'Memari - II',
		'IN02293' => 'Kalna - I',
		'IN02294' => 'Kalna - II',
		'IN02295' => 'Jamalpur',
		'IN02296' => 'Raina - I',
		'IN02297' => 'Khandaghosh',
		'IN02298' => 'Raina - II',
		'IN02299' => 'Karimpur - I',
		'IN02300' => 'Karimpur - II',
		'IN02301' => 'Tehatta - I',
		'IN02302' => 'Tehatta - II',
		'IN02303' => 'Kaliganj',
		'IN02304' => 'Nakashipara',
		'IN02305' => 'Chapra',
		'IN02306' => 'Krishnagar - II',
		'IN02307' => ' Nabadwip',
		'IN02308' => 'Krishnagar - I',
		'IN02309' => 'Krishnaganj',
		'IN02310' => 'Hanskhali',
		'IN02311' => 'Santipur',
		'IN02312' => 'Ranaghat - I',
		'IN02313' => 'Ranaghat - II',
		'IN02314' => 'Chakdah',
		'IN02315' => 'Haringhata',
		'IN02316' => 'Bagda',
		'IN02317' => 'Bongaon',
		'IN02318' => 'Gaighata',
		'IN02319' => 'Swarupnagar',
		'IN02320' => 'Habra - I',
		'IN02321' => 'Habra - II',
		'IN02322' => 'Amdanga',
		'IN02323' => 'Barrackpur - I',
		'IN02324' => 'Barrackpur - II',
		'IN02325' => 'Barasat - I',
		'IN02326' => 'Barasat - II',
		'IN02327' => 'Deganga',
		'IN02328' => 'Baduria',
		'IN02329' => 'Basirhat - I',
		'IN02330' => 'Basirhat - II',
		'IN02331' => 'Haroa',
		'IN02332' => 'Rajarhat',
		'IN02333' => 'Minakhan',
		'IN02334' => 'Sandeshkhali - I',
		'IN02335' => 'Sandeshkhali - II',
		'IN02336' => 'Hasnabad',
		'IN02337' => 'Hingalganj',
		'IN02338' => 'Goghat - I',
		'IN02339' => 'Goghat - II',
		'IN02340' => 'Arambag',
		'IN02341' => 'Pursura',
		'IN02342' => 'Tarakeswar',
		'IN02343' => 'Dhaniakhali',
		'IN02344' => 'Pandua',
		'IN02345' => 'Balagarh',
		'IN02346' => 'Chinsurah - Magra',
		'IN02347' => 'Polba - Dadpur',
		'IN02348' => 'Haripal',
		'IN02349' => 'Singur',
		'IN02350' => 'Serampur Uttarpara',
		'IN02351' => 'Chanditala - I',
		'IN02352' => 'Chanditala - II',
		'IN02353' => 'Jangipara',
		'IN02354' => 'Khanakul - I',
		'IN02355' => 'Khanakul - II',
		'IN02356' => 'Saltora',
		'IN02357' => 'Mejhia',
		'IN02358' => 'Gangajalghati',
		'IN02359' => 'Chhatna',
		'IN02360' => 'Indpur',
		'IN02361' => 'Bankura - I',
		'IN02362' => 'Bankura - II',
		'IN02363' => 'Barjora',
		'IN02364' => 'Sonamukhi',
		'IN02365' => 'Patrasayer',
		'IN02366' => 'Indus',
		'IN02367' => 'Kotulpur',
		'IN02368' => 'Jaypur',
		'IN02369' => 'Vishnupur',
		'IN02370' => 'Onda',
		'IN02371' => 'Taldangra',
		'IN02372' => 'Simlapal',
		'IN02373' => 'Khatra',
		'IN02374' => 'Hirbandh',
		'IN02375' => 'Ranibundh',
		'IN02376' => 'Raipur',
		'IN02377' => 'Sarenga',
		'IN02378' => 'Jaipur',
		'IN02379' => 'Purulia - II',
		'IN02380' => 'Para',
		'IN02381' => 'Raghunathpur - II',
		'IN02382' => 'Raghunathpur - I',
		'IN02383' => 'Neturia',
		'IN02384' => 'Santuri',
		'IN02385' => 'Kashipur',
		'IN02386' => 'Hura',
		'IN02387' => 'Purulia - I',
		'IN02388' => 'Puncha',
		'IN02389' => 'Arsha',
		'IN02390' => 'Jhalda - I',
		'IN02391' => 'Jhalda - II',
		'IN02392' => 'Bagmundi',
		'IN02393' => 'Balarampur',
		'IN02394' => 'Barabazar',
		'IN02395' => 'Manbazar - I',
		'IN02396' => 'Manbazar - II',
		'IN02397' => 'Bundwan',
		'IN02398' => 'Udaynarayanpur',
		'IN02399' => 'Amta - II',
		'IN02400' => 'Amta - I',
		'IN02401' => 'Jagatballavpur',
		'IN02402' => 'Domjur',
		'IN02403' => 'Bally Jagachha',
		'IN02404' => 'Sankrail',
		'IN02405' => 'Panchla',
		'IN02406' => 'Uluberia - II',
		'IN02407' => 'Uluberia - I',
		'IN02408' => 'Bagnan - I',
		'IN02409' => 'Bagnan - II',
		'IN02410' => 'Shyampur - I',
		'IN02411' => 'Shyampur - II',
		'IN02412' => 'Thakurpukur Mahestola',
		'IN02413' => 'Budge Budge - I',
		'IN02414' => 'Budge Budge - II',
		'IN02415' => 'Bishnupur - I',
		'IN02416' => 'Bishnupur - II',
		'IN02417' => 'Sonarpur',
		'IN02418' => 'Bhangar - I',
		'IN02419' => 'Bhangar - II',
		'IN02420' => 'Canning - I',
		'IN02421' => 'Canning - II',
		'IN02422' => 'Baruipur',
		'IN02423' => 'Magrahat - II',
		'IN02424' => 'Magrahat - I',
		'IN02425' => 'Falta',
		'IN02426' => 'Diamond Harbour - I',
		'IN02427' => 'Diamond Harbour - II',
		'IN02428' => 'Kulpi',
		'IN02429' => 'Mandirbazar',
		'IN02430' => 'Mathurapur - I',
		'IN02431' => 'Jaynagar - I',
		'IN02432' => 'Jaynagar - II',
		'IN02433' => 'Kultali',
		'IN02434' => 'Basanti',
		'IN02435' => 'Gosaba',
		'IN02436' => 'Mathurapur - II',
		'IN02437' => 'Kakdwip',
		'IN02438' => 'Sagar',
		'IN02439' => 'Namkhana',
		'IN02440' => 'Patharpratima',
		'IN02441' => 'Binpur - II',
		'IN02442' => 'Binpur - I',
		'IN02443' => 'Garbeta - II',
		'IN02444' => 'Garbeta - I',
		'IN02445' => 'Garbeta - III',
		'IN02446' => 'Chandrakona - I',
		'IN02447' => 'Chandrakona - II',
		'IN02448' => 'Ghatal',
		'IN02449' => 'Daspur - I',
		'IN02450' => 'Daspur - II',
		'IN02451' => 'Keshpur',
		'IN02452' => 'Salbani',
		'IN02453' => 'Midnapore',
		'IN02454' => 'Jhargram',
		'IN02455' => 'Jamboni',
		'IN02456' => 'Gopiballavpur - II',
		'IN02457' => 'Gopiballavpur - I',
		'IN02458' => 'Nayagram',
		'IN02459' => 'Sankrail',
		'IN02460' => 'Kharagpur - I',
		'IN02461' => 'Kharagpur - II',
		'IN02462' => 'Debra',
		'IN02463' => 'Pingla',
		'IN02464' => 'Sabang',
		'IN02465' => 'Narayangarh',
		'IN02466' => 'Keshiary',
		'IN02467' => 'Dantan - I',
		'IN02468' => 'Dantan - II',
		'IN02469' => 'Mohanpur',
		'IN02470' => 'Panskura',
		'IN02471' => 'Kolaghat',
		'IN02472' => 'Tamluk',
		'IN02473' => 'Sahid Matangini',
		'IN02474' => 'Nanda Kumar',
		'IN02475' => 'Mahisadal',
		'IN02476' => 'Moyna',
		'IN02477' => 'Potashpur - I',
		'IN02478' => 'Potashpur - II',
		'IN02479' => 'Bhagawanpur - II',
		'IN02480' => 'Bhagawanpur - I',
		'IN02481' => 'Chandipur',
		'IN02482' => 'Sutahata',
		'IN02483' => 'Haldia',
		'IN02484' => 'Nandigram - I',
		'IN02485' => 'Nandigram - II',
		'IN02486' => 'Khejuri - I',
		'IN02487' => 'Khejuri - II',
		'IN02488' => 'Contai - I',
		'IN02489' => 'Deshopran',
		'IN02490' => 'Contai - III',
		'IN02491' => 'Egra - I',
		'IN02492' => 'Egra - II',
		'IN02493' => 'Ramnagar - I',
		'IN02494' => 'Ramnagar - II',
	],
	'JH' => [
		'IN02495' => 'Kharaundhi',
		'IN02496' => 'Bhawnathpur',
		'IN02497' => 'Ketar',
		'IN02498' => 'Kandi',
		'IN02499' => 'Majhiaon',
		'IN02500' => 'Bardiha',
		'IN02501' => 'Ramna',
		'IN02502' => 'Bishunpura',
		'IN02503' => 'Nagaruntari',
		'IN02504' => 'Dhurki',
		'IN02505' => 'Sagma',
		'IN02506' => 'Dandai',
		'IN02507' => 'Chinia',
		'IN02508' => 'Meral (Pipra Kalan)',
		'IN02509' => 'Garhwa',
		'IN02510' => 'Danda',
		'IN02511' => 'Ranka',
		'IN02512' => 'Ramkanda',
		'IN02513' => 'Bhandaria',
		'IN02514' => 'Shaligram Ram Narayanpur(Hunterganj)',
		'IN02515' => 'Pratappur',
		'IN02516' => 'Kunda',
		'IN02517' => 'Lawalaung',
		'IN02518' => 'Chatra',
		'IN02519' => 'Kanha Chatti',
		'IN02520' => 'Itkhori',
		'IN02521' => 'Mayur Hand',
		'IN02522' => 'Gidhaur',
		'IN02523' => 'Pathalgora',
		'IN02524' => 'Simaria',
		'IN02525' => 'Tandwa',
		'IN02526' => 'Satgawan',
		'IN02527' => 'Kodarma',
		'IN02528' => 'Domchanch',
		'IN02529' => 'Jainagar',
		'IN02530' => 'Chandwara',
		'IN02531' => 'Markacho',
		'IN02532' => 'Gawan',
		'IN02533' => 'Tisri',
		'IN02534' => 'Deori',
		'IN02535' => 'Dhanwar',
		'IN02536' => 'Jamua',
		'IN02537' => 'Bengabad',
		'IN02538' => 'Gande',
		'IN02539' => 'Giridih',
		'IN02540' => 'Birni',
		'IN02541' => 'Bagodar',
		'IN02542' => 'Sariya',
		'IN02543' => 'Dumri',
		'IN02544' => 'Pirtanr',
		'IN02545' => 'Deoghar',
		'IN02546' => 'Mohanpur',
		'IN02547' => 'Sarwan',
		'IN02548' => 'Sona Rai Tharhi',
		'IN02549' => 'Devipur',
		'IN02550' => 'Madhupur',
		'IN02551' => 'Margo Munda',
		'IN02552' => 'Karon',
		'IN02553' => 'Sarath',
		'IN02554' => 'Palojori',
		'IN02555' => 'Meherma',
		'IN02556' => 'Thakurgangti',
		'IN02557' => 'Boarijor',
		'IN02558' => 'Mahagama',
		'IN02559' => 'Pathargama',
		'IN02560' => 'Bashant Rai',
		'IN02561' => 'Godda',
		'IN02562' => 'Poreyahat',
		'IN02563' => 'Sundarpahari',
		'IN02564' => 'Sahibganj',
		'IN02565' => 'Mandro',
		'IN02566' => 'Borio',
		'IN02567' => 'Barhait',
		'IN02568' => 'Taljhari',
		'IN02569' => 'Rajmahal',
		'IN02570' => 'Udhwa',
		'IN02571' => 'Pathna',
		'IN02572' => 'Barharwa',
		'IN02573' => 'Litipara',
		'IN02574' => 'Amrapara',
		'IN02575' => 'Hiranpur',
		'IN02576' => 'Pakaur',
		'IN02577' => 'Maheshpur',
		'IN02578' => 'Pakuria',
		'IN02579' => 'Tundi',
		'IN02580' => 'Purbi Tundi',
		'IN02581' => 'Topchanchi',
		'IN02582' => 'Baghmara-Cum-Katras',
		'IN02583' => 'Gobindpur',
		'IN02584' => 'Dhanbad-Cum-Kenduadih-Cum-Jagata',
		'IN02586' => 'Baliapur',
		'IN02587' => 'Nirsa-Cum-Chirkunda',
		'IN02588' => 'Nawadih',
		'IN02589' => 'Chandrapura',
		'IN02590' => 'Bermo',
		'IN02591' => 'Gumia',
		'IN02592' => 'Peterwar',
		'IN02593' => 'Kasmar',
		'IN02594' => 'Jaridih',
		'IN02595' => 'Chas',
		'IN02596' => 'Chandankiyari',
		'IN02597' => 'Kisko',
		'IN02598' => 'Peshrar',
		'IN02599' => 'Kuru',
		'IN02600' => 'Kairo',
		'IN02601' => 'Lohardaga',
		'IN02602' => 'Senha',
		'IN02603' => 'Bhandra',
		'IN02604' => 'Patamda',
		'IN02605' => 'Boram',
		'IN02606' => 'Golmuri-Cum-Jugsalai',
		'IN02607' => 'Ghatshila',
		'IN02608' => 'Potka',
		'IN02609' => 'Musabani',
		'IN02610' => 'Dumaria',
		'IN02611' => 'Dhalbhumgarh',
		'IN02612' => 'Gurbandha',
		'IN02613' => 'Chakulia',
		'IN02614' => 'Baharagora',
		'IN02615' => 'Hussainabad',
		'IN02616' => 'Haidernagar',
		'IN02617' => 'Mohammad Ganj',
		'IN02618' => 'Hariharganj',
		'IN02619' => 'Pipra',
		'IN02620' => 'Chhatarpur',
		'IN02621' => 'Nawadiha Bazar/Nawadiha',
		'IN02622' => 'Pandu',
		'IN02623' => 'Untari Road',
		'IN02624' => 'Bishrampur',
		'IN02625' => 'Nawa Bazar',
		'IN02626' => 'Patan',
		'IN02627' => 'Padwa',
		'IN02628' => 'Manatu',
		'IN02629' => 'Tarhasi',
		'IN02630' => 'Panki',
		'IN02631' => 'Satbarwa',
		'IN02632' => 'Nilambar-Pitambarpur(Lesliganj)',
		'IN02633' => 'Medininagar(Daltonganj)',
		'IN02634' => 'Chainpur',
		'IN02635' => 'Manika',
		'IN02636' => 'Barwadih',
		'IN02637' => 'Mahuadanr',
		'IN02638' => 'Garu',
		'IN02639' => 'Latehar',
		'IN02640' => 'Balumath',
		'IN02641' => 'Bariyatu',
		'IN02642' => 'Herhanj',
		'IN02643' => 'Chandwa',
		'IN02644' => 'Chauparan',
		'IN02645' => 'Barhi',
		'IN02646' => 'Padma',
		'IN02647' => 'Ichak',
		'IN02648' => 'Tati Jhariya',
		'IN02649' => 'Daru',
		'IN02650' => 'Barkatha',
		'IN02651' => 'Chalkusa',
		'IN02652' => 'Bishungarh',
		'IN02653' => 'Hazaribag',
		'IN02654' => 'Katkamsandi',
		'IN02655' => 'Katamdag',
		'IN02656' => 'Keredari',
		'IN02657' => 'Barkagaon',
		'IN02658' => 'Churchu',
		'IN02659' => 'Dadi',
		'IN02660' => 'Patratu',
		'IN02661' => 'Mandu',
		'IN02662' => 'Ramgarh',
		'IN02663' => 'Dulmi',
		'IN02664' => 'Chitarpur',
		'IN02665' => 'Gola',
		'IN02666' => 'Saraiyahat',
		'IN02667' => 'Jarmundi',
		'IN02668' => 'Ramgarh',
		'IN02669' => 'Gopikandar',
		'IN02670' => 'Kathikund',
		'IN02671' => 'Shikaripara',
		'IN02672' => 'Ranishwar',
		'IN02673' => 'Dumka',
		'IN02674' => 'Jama',
		'IN02675' => 'Masalia',
		'IN02676' => 'Narayanpur',
		'IN02677' => 'Karma Tanr Vidyasagar',
		'IN02678' => 'Jamtara',
		'IN02679' => 'Nala',
		'IN02680' => 'Fatehpur',
		'IN02681' => 'Kundhit',
		'IN02682' => 'Burmu',
		'IN02683' => 'Khelari',
		'IN02684' => 'Kanke',
		'IN02685' => 'Ormanjhi',
		'IN02686' => 'Angara',
		'IN02687' => 'Rahe',
		'IN02688' => 'Silli',
		'IN02689' => 'Sonahatu',
		'IN02690' => 'Namkum',
		'IN02691' => 'Ratu',
		'IN02692' => 'Nagri',
		'IN02693' => 'Mandar',
		'IN02694' => 'Chanho',
		'IN02695' => 'Bero',
		'IN02696' => 'Itki',
		'IN02697' => 'Lapung',
		'IN02698' => 'Bundu',
		'IN02699' => 'Tamar I',
		'IN02700' => 'Karra',
		'IN02701' => 'Torpa',
		'IN02702' => 'Rania',
		'IN02703' => 'Murhu',
		'IN02704' => 'Khunti',
		'IN02705' => 'Erki(Tamar II)',
		'IN02706' => 'Bishunpur',
		'IN02707' => 'Ghaghra',
		'IN02708' => 'Sisai',
		'IN02709' => 'Verno',
		'IN02710' => 'Kamdara',
		'IN02711' => 'Basia',
		'IN02712' => 'Gumla',
		'IN02713' => 'Chainpur',
		'IN02714' => 'Dumri',
		'IN02715' => 'Albert Ekka(Jari)',
		'IN02716' => 'Raidih',
		'IN02717' => 'Palkot',
		'IN02718' => 'Simdega',
		'IN02719' => 'Pakar Tanr',
		'IN02720' => 'Kurdeg',
		'IN02721' => 'Kersai',
		'IN02722' => 'Bolba',
		'IN02723' => 'Thethaitangar',
		'IN02724' => 'Kolebira',
		'IN02725' => 'Jaldega',
		'IN02726' => 'Bansjor',
		'IN02727' => 'Bano',
		'IN02728' => 'Sonua',
		'IN02729' => 'Gudri',
		'IN02730' => 'Bandgaon',
		'IN02731' => 'Chakradharpur',
		'IN02732' => 'Khuntpani',
		'IN02733' => 'Goilkera',
		'IN02734' => 'Anandpur',
		'IN02735' => 'Manoharpur',
		'IN02736' => 'Noamundi',
		'IN02737' => 'Tonto',
		'IN02738' => 'Hat Gamharia',
		'IN02739' => 'Chaibasa',
		'IN02740' => 'Tantnagar',
		'IN02741' => 'Manjhari',
		'IN02742' => 'Jhinkpani',
		'IN02743' => 'Jagannathpur',
		'IN02744' => 'Kumardungi',
		'IN02745' => 'Majhgaon',
		'IN02746' => 'Kuchai',
		'IN02747' => 'Kharsawan',
		'IN02748' => 'Chandil',
		'IN02749' => 'Ichagarh',
		'IN02750' => 'Kukru',
		'IN02751' => 'Nimdih',
		'IN02752' => 'Adityapur(Gamharia)',
		'IN02753' => 'Saraikela',
		'IN02754' => 'Gobindpur(Rajnagar)',
	],
	'OR' => [
		'IN02755' => 'Paikamal',
		'IN02756' => 'Jharbandha',
		'IN02757' => 'Padmapur',
		'IN02758' => 'Burden',
		'IN02759' => 'Gaisilet',
		'IN02760' => 'Melchhamunda',
		'IN02761' => 'Sohela',
		'IN02762' => 'Bijepur',
		'IN02763' => 'Barapali',
		'IN02764' => 'Bheden',
		'IN02765' => 'Bargarh',
		'IN02766' => 'Bargarh Sadar',
		'IN02767' => 'Bhatli',
		'IN02768' => 'Ambabhona',
		'IN02769' => 'Attabira',
		'IN02770' => 'Rengali',
		'IN02771' => 'Lakhanpur',
		'IN02772' => 'Belpahar',
		'IN02773' => 'Banaharapali',
		'IN02774' => 'Orient',
		'IN02775' => 'Brajarajnagar',
		'IN02776' => 'Jharsuguda',
		'IN02777' => 'Badmal',
		'IN02778' => 'Laikera',
		'IN02779' => 'Kolabira',
		'IN02780' => 'Govindpur',
		'IN02781' => 'Mahulpalli',
		'IN02782' => 'Kochinda',
		'IN02783' => 'Katarbaga',
		'IN02784' => 'Thelkoloi',
		'IN02785' => 'Rengali',
		'IN02786' => 'Sasan',
		'IN02787' => 'Hirakud',
		'IN02788' => 'Burla',
		'IN02789' => 'Dhanupali',
		'IN02790' => 'Ainthapali',
		'IN02791' => 'Sadar',
		'IN02792' => 'Jamankira',
		'IN02793' => 'Kisinda',
		'IN02794' => 'Jujomura',
		'IN02795' => 'Dhama',
		'IN02796' => 'Charamal',
		'IN02797' => 'Rairakhol',
		'IN02798' => 'Naktideul',
		'IN02799' => 'Sambalpur (M)',
		'IN02800' => 'Debagarh',
		'IN02801' => 'Barkot',
		'IN02802' => 'Kundheigola',
		'IN02803' => 'Reamal',
		'IN02804' => 'Hemgir',
		'IN02805' => 'Lephripara',
		'IN02806' => 'Bhasma',
		'IN02807' => 'Dharuadihi',
		'IN02808' => 'Sundargarh Town',
		'IN02809' => 'Sundargarh',
		'IN02810' => 'Kinjirkela',
		'IN02811' => 'Talasara',
		'IN02812' => 'Baragaon',
		'IN02813' => 'Kutra',
		'IN02814' => 'Rajagangapur',
		'IN02815' => 'Raiboga',
		'IN02816' => 'Biramitrapur',
		'IN02817' => 'Hatibari',
		'IN02818' => 'Bisra',
		'IN02819' => 'Bondamunda',
		'IN02820' => 'Brahmani Tarang',
		'IN02821' => 'Raghunathapali',
		'IN02822' => 'Tangarapali',
		'IN02823' => 'Lathikata',
		'IN02824' => 'Chandiposh',
		'IN02825' => 'Kamarposh Balang',
		'IN02826' => 'Koida',
		'IN02827' => 'Lahunipara',
		'IN02828' => 'Gurundia',
		'IN02829' => 'Tikaetpali',
		'IN02830' => 'Banei',
		'IN02831' => 'Mahulapada',
		'IN02832' => 'Raurkela (M)',
		'IN02833' => 'Raurkela (ITS)',
		'IN02834' => 'Barbil',
		'IN02835' => 'Bolani',
		'IN02836' => 'Rugudi',
		'IN02837' => 'Joda',
		'IN02838' => 'Bamebari',
		'IN02839' => 'Champua',
		'IN02840' => 'Jhumpura',
		'IN02841' => 'Baria',
		'IN02842' => 'Turumunga',
		'IN02843' => 'Patana',
		'IN02844' => 'Kendujhar Sadar',
		'IN02845' => 'Kendujhar Town',
		'IN02846' => 'Nayakote',
		'IN02847' => 'Kanjipani',
		'IN02848' => 'Telkoi',
		'IN02849' => 'Pandapara',
		'IN02850' => 'Ghatgaon',
		'IN02851' => 'Harichandanpur',
		'IN02852' => 'Daitari',
		'IN02853' => 'Ghasipura',
		'IN02854' => 'Anandapur',
		'IN02855' => 'Soso',
		'IN02856' => 'Nandipada',
		'IN02857' => 'Sainkul',
		'IN02858' => 'Tiring',
		'IN02859' => 'Bahalda',
		'IN02860' => 'Jamda',
		'IN02861' => 'Rairangpur Town',
		'IN02862' => 'Gorumahisani',
		'IN02863' => 'Jharpokharia',
		'IN02864' => 'Bisoi',
		'IN02865' => 'Rairangpur',
		'IN02866' => 'Badampahar',
		'IN02867' => 'Jashipur',
		'IN02868' => 'Raruan',
		'IN02869' => 'Ghagarbeda',
		'IN02870' => 'Karanjia',
		'IN02871' => 'Thakurmunda',
		'IN02872' => 'Baripada Sadar',
		'IN02873' => 'Baripada Town',
		'IN02874' => 'Koliana',
		'IN02875' => 'Bangiriposi',
		'IN02876' => 'Chandua',
		'IN02877' => 'Suliapada',
		'IN02878' => 'Muruda',
		'IN02879' => 'Rasagobindapur',
		'IN02880' => 'Baisinga',
		'IN02881' => 'Betanati',
		'IN02882' => 'Barsahi',
		'IN02883' => 'Khunta',
		'IN02884' => 'Udala',
		'IN02885' => 'Kaptipada',
		'IN02886' => 'Sharata',
		'IN02887' => 'Mahuldiha',
		'IN02888' => 'Baripada (M)',
		'IN02889' => 'Raibania',
		'IN02890' => 'Jaleswar',
		'IN02891' => 'Bhograi',
		'IN02892' => 'Kamarda',
		'IN02893' => 'Baliapal',
		'IN02894' => 'Singla',
		'IN02895' => 'Basta',
		'IN02896' => 'Rupsa',
		'IN02897' => 'Baleshwar Sadar',
		'IN02898' => 'Sahadevkhunta',
		'IN02899' => 'Chandipur',
		'IN02900' => 'Balaramgadi Marine',
		'IN02901' => 'Bampada',
		'IN02902' => 'Remuna',
		'IN02903' => 'Nilagiri',
		'IN02904' => 'Berhampur',
		'IN02905' => 'Oupada',
		'IN02906' => 'Khaira',
		'IN02907' => 'Soro',
		'IN02908' => 'Similia',
		'IN02909' => 'Baleshwar (M)',
		'IN02910' => 'Agarpada',
		'IN02911' => 'Bant',
		'IN02912' => 'Bhandari Pokhari',
		'IN02913' => 'Dhamanagar',
		'IN02914' => 'Bhadrak Rural',
		'IN02915' => 'Basudebpur',
		'IN02916' => 'Naikanidihi',
		'IN02917' => 'Tihidi',
		'IN02918' => 'Dhusuri',
		'IN02919' => 'Chandabali',
		'IN02920' => 'Bansada',
		'IN02921' => 'Dhamara Marine',
		'IN02922' => 'Rajkanika',
		'IN02923' => 'Rajnagar',
		'IN02924' => 'Jamboo Marine',
		'IN02925' => 'Aali',
		'IN02926' => 'Pattamundai',
		'IN02927' => 'Kendrapara',
		'IN02928' => 'Kendrapara Sadar',
		'IN02929' => 'Nikirai',
		'IN02930' => 'Derabish',
		'IN02931' => 'Patkura',
		'IN02932' => 'Marsaghai',
		'IN02933' => 'Mahakalapada',
		'IN02934' => 'Paradip',
		'IN02935' => 'Paradeep Lock',
		'IN02936' => 'Kujang',
		'IN02937' => 'Abhyachandpur',
		'IN02938' => 'Ersama',
		'IN02939' => 'Tirtol',
		'IN02940' => 'Jagatsinghapur',
		'IN02941' => 'Biridi',
		'IN02942' => 'Naugaon',
		'IN02943' => 'Balikuda',
		'IN02944' => 'Narasinghpur',
		'IN02945' => 'Kanpur',
		'IN02946' => 'Badamba',
		'IN02947' => 'Baidyeswar',
		'IN02948' => 'Banki',
		'IN02949' => 'Tigiria',
		'IN02950' => 'Athagad',
		'IN02951' => 'Barang',
		'IN02952' => 'Gurudijhatia',
		'IN02953' => 'Khuntuni',
		'IN02954' => 'Choudwar',
		'IN02955' => 'Tangi',
		'IN02956' => 'Mahanga',
		'IN02957' => 'Salepur',
		'IN02958' => 'Nischintakoili',
		'IN02959' => 'Nemalo',
		'IN02960' => 'Kishannagar',
		'IN02961' => 'Jagatpur',
		'IN02962' => 'Cuttack Sadar',
		'IN02963' => 'Kandarpur',
		'IN02964' => 'C.R.R.I.',
		'IN02965' => 'Gobindpur',
		'IN02966' => 'Olatapur',
		'IN02967' => 'Niali',
		'IN02968' => 'Cuttack (M Corp.)',
		'IN02969' => 'Sukinda',
		'IN02970' => 'Tomka',
		'IN02971' => 'Kaliapani',
		'IN02972' => 'Kalinganagar',
		'IN02973' => 'Jakhapura',
		'IN02974' => 'Jajapur Road',
		'IN02975' => 'Korai',
		'IN02976' => 'Panikoili',
		'IN02977' => 'Jajapur  ',
		'IN02978' => 'Jajpur Sadar',
		'IN02979' => 'Dharmasala',
		'IN02980' => 'Jenapur',
		'IN02981' => 'Kuakhia',
		'IN02982' => 'Badachana',
		'IN02983' => 'Balichandrapur',
		'IN02984' => 'Binjharpur',
		'IN02985' => 'Bari - Ramachandrapur',
		'IN02986' => 'Mangalpur',
		'IN02987' => 'Parajang',
		'IN02988' => 'Kamakshyanagar',
		'IN02989' => 'Kankadahad',
		'IN02990' => 'Bhuban',
		'IN02991' => 'Gandia',
		'IN02992' => 'Nihalprasad',
		'IN02993' => 'Tumusingha',
		'IN02994' => 'Motunga',
		'IN02995' => 'Bhusan Steel Limited',
		'IN02996' => 'Balimi',
		'IN02997' => 'Hindol',
		'IN02998' => 'Rasol',
		'IN02999' => 'Dhenkanal Sadar',
		'IN03000' => 'Palalahada',
		'IN03001' => 'Khamar',
		'IN03002' => 'Rengali Damsite',
		'IN03003' => 'Kaniha',
		'IN03004' => 'N.T.P.C. ',
		'IN03005' => 'Samal Barrage',
		'IN03006' => 'Talcher Sadar',
		'IN03007' => 'Colliery',
		'IN03008' => 'Bikrampur',
		'IN03009' => 'Nalco',
		'IN03010' => 'Banarpal',
		'IN02995' => 'Bhusan Steel Limited',
		'IN03011' => 'Anugul',
		'IN03012' => 'Jarapada',
		'IN03013' => 'Industrial',
		'IN03014' => 'Chhendipada',
		'IN03015' => 'Handapa',
		'IN03016' => 'Kishorenagar',
		'IN03017' => 'Athmallik',
		'IN03018' => 'Kiakata',
		'IN03019' => 'Thakurgarh',
		'IN03020' => 'Purunakot',
		'IN03021' => 'Bantala',
		'IN03022' => 'Gania',
		'IN03023' => 'Dasapalla',
		'IN03024' => 'Banigochha',
		'IN03025' => 'Nuagaon',
		'IN03026' => 'Khandapada',
		'IN03027' => 'Fategarh',
		'IN03028' => 'Nayagarh',
		'IN03029' => 'Itamati',
		'IN03030' => 'Nayagarh Sadar',
		'IN03031' => 'Odagaon',
		'IN03032' => 'Sarankul',
		'IN03033' => 'Ranapur',
		'IN03034' => 'Bolagad',
		'IN03035' => 'Begunia',
		'IN03036' => 'Khordha',
		'IN03037' => 'Khordha Sadar',
		'IN03038' => 'Chandaka',
		'IN03039' => 'Nandankanan',
		'IN03041' => 'Mancheswar',
		'IN03042' => 'Balianta',
		'IN03043' => 'Balipatna',
		'IN03044' => 'Lingaraj',
		'IN03045' => 'Airfield (Kapila Prasad)',
		'IN03046' => 'Uttara',
		'IN03047' => 'Khandagiri',
		'IN03048' => 'Tamando',
		'IN03049' => 'Jatani',
		'IN03050' => 'Jankia',
		'IN03051' => 'Nirakarpur',
		'IN03052' => 'Tangi',
		'IN03053' => 'Balugaon',
		'IN03054' => 'Banapur',
		'IN03055' => 'Bhubaneswar (M.Corp.)',
		'IN03056' => 'Delanga',
		'IN03057' => 'Pipili',
		'IN03058' => 'Nimapada',
		'IN03059' => 'Kakatpur',
		'IN03060' => 'Astaranga',
		'IN03061' => 'Konark',
		'IN03062' => 'Gop',
		'IN03063' => 'Ramachandi',
		'IN03064' => 'Satyabadi',
		'IN03065' => 'Chandanpur',
		'IN03066' => 'Sadar',
		'IN03067' => 'Brahmagiri',
		'IN03068' => 'Gadisagada',
		'IN03069' => 'Krushna Prasad',
		'IN03070' => 'Puri (M)',
		'IN03071' => 'Tarasingi',
		'IN03072' => 'Buguda',
		'IN03073' => 'Jagannath Prasad',
		'IN03074' => 'Bhanjanagar',
		'IN03075' => 'Gangapur',
		'IN03076' => 'Surada',
		'IN03077' => 'Badagada',
		'IN03078' => 'Asika',
		'IN03079' => 'Dharakote',
		'IN03080' => 'Kabisuryanagar',
		'IN03081' => 'Polasara',
		'IN03082' => 'Kodala',
		'IN03083' => 'Khalikote',
		'IN03084' => 'Rambha',
		'IN03085' => 'Chhatrapur',
		'IN03086' => 'Ganjam',
		'IN03087' => 'Chamakhandi',
		'IN03088' => 'Arjyapalli Marine',
		'IN03089' => 'Purusottampur',
		'IN03090' => 'Hinjili',
		'IN03091' => 'Patapur',
		'IN03092' => 'Seragad',
		'IN03093' => 'Brahmapur Sadar',
		'IN03094' => 'Gopalpur',
		'IN03095' => 'Golanthara',
		'IN03096' => 'Digapahandi',
		'IN03097' => 'Nuagaon',
		'IN03098' => 'Jarada',
		'IN03109' => 'Ramagiri',
		'IN03099' => 'Brahmapur (M.Corp.)',
		'IN03100' => 'Adva',
		'IN03101' => 'Mohana',
		'IN03102' => 'R.Udaygiri',
		'IN03103' => 'Serango',
		'IN03104' => 'Kashinagara',
		'IN03105' => 'Parlakhemundi',
		'IN03106' => 'Gurandi',
		'IN03107' => 'Rayagada',
		'IN03108' => 'Garabandha',
		'IN03109' => 'Ramagiri',
		'IN03110' => 'Gochhapada',
		'IN03111' => 'Phulabani',
		'IN03112' => 'Phulabani Town',
		'IN03113' => 'Khajuripada',
		'IN03114' => 'G.Udayagiri',
		'IN03115' => 'Tikabali',
		'IN03116' => 'Chakapada',
		'IN03117' => 'Sarangagarh',
		'IN03118' => 'Phiringia',
		'IN03119' => 'Baliguda',
		'IN03120' => 'Nuagaon',
		'IN03121' => 'Tumudibandha',
		'IN03122' => 'Belaghar',
		'IN03123' => 'Kotagarh',
		'IN03124' => 'Brahmanigaon',
		'IN03125' => 'Daringbadi',
		'IN03126' => 'Raikia',
		'IN03127' => 'Kantamal',
		'IN03128' => 'Manamunda',
		'IN03129' => 'Baunsuni',
		'IN03130' => 'Baudh Sadar',
		'IN03131' => 'Puruna Katak',
		'IN03132' => 'Harbhanga',
		'IN03133' => 'Dunguripali',
		'IN03134' => 'Rampur',
		'IN03135' => 'Binika',
		'IN03136' => 'Ulunda',
		'IN03137' => 'Biramaharajpur',
		'IN03138' => 'Subalaya',
		'IN03139' => 'Sonapur',
		'IN03140' => 'Tarbha',
		'IN03141' => 'Loisinga',
		'IN03142' => 'Balangir',
		'IN03143' => 'Tushura',
		'IN03144' => 'Patnagarh',
		'IN03145' => 'Khaprakhol',
		'IN03146' => 'Turekela',
		'IN03147' => 'Belpara',
		'IN03148' => 'Saintala',
		'IN03149' => 'Kantabanji',
		'IN03150' => 'Bangomunda',
		'IN03151' => 'Sindhekela',
		'IN03152' => 'Titlagarh',
		'IN03153' => 'Jonk',
		'IN03154' => 'Nuapada',
		'IN03155' => 'Komna',
		'IN03156' => 'Khariar',
		'IN03157' => 'Boden',
		'IN03158' => 'Sinapali',
		'IN03159' => 'Kesinga',
		'IN03160' => 'Madanpur Rampur',
		'IN03161' => 'Narala',
		'IN03162' => 'Lanjigarh',
		'IN03163' => 'Biswanathpur',
		'IN03164' => 'Sadar',
		'IN03165' => 'Kegaon',
		'IN03166' => 'Junagarh',
		'IN03167' => 'Golamunda',
		'IN03168' => 'Dharamgarh',
		'IN03169' => 'Kokasara',
		'IN03170' => 'Jayapatna',
		'IN03171' => 'Thuamul Rampur',
		'IN03172' => 'Ambadala',
		'IN03173' => 'Muniguda',
		'IN03174' => 'Chandrapur',
		'IN03175' => 'Bishamakatak',
		'IN03176' => 'Kalyanasingpur',
		'IN03177' => 'Kashipur',
		'IN03178' => 'Andirakanch',
		'IN03179' => 'Tikiri',
		'IN03180' => 'Doraguda',
		'IN03181' => 'Rayagada',
		'IN03182' => 'Seskhal',
		'IN03183' => 'Gunupur',
		'IN03184' => 'Gudari',
		'IN03185' => 'Padmapur',
		'IN03186' => 'Puttasing',
		'IN03187' => 'Raighar',
		'IN03188' => 'Kundei',
		'IN03189' => 'Umarkote',
		'IN03190' => 'Chandahandi',
		'IN03191' => 'Jharigan',
		'IN03192' => 'Dabugan',
		'IN03193' => 'Paparahandi',
		'IN03194' => 'Kodinga',
		'IN03195' => 'Kosagumuda',
		'IN03196' => 'Nabarangapur',
		'IN03197' => 'Tentulikhunti',
		'IN03198' => 'Khatiguda',
		'IN03199' => 'Kotpad',
		'IN03200' => 'Boriguma',
		'IN03201' => 'Bhairabsingipur',
		'IN03202' => 'Dasamantapur',
		'IN03203' => 'Lakshmipur',
		'IN03204' => 'Narayanpatana',
		'IN03205' => 'Bandhugaon',
		'IN03206' => 'Kakiriguma',
		'IN03207' => 'Koraput',
		'IN03208' => 'Koraput Town',
		'IN03209' => 'Jeypore',
		'IN03210' => 'Kundura',
		'IN03211' => 'Boipariguda',
		'IN03212' => 'Machh kund',
		'IN03213' => 'Padua',
		'IN03214' => 'Nandapur',
		'IN03215' => 'Similiguda',
		'IN03216' => 'Sunabeda',
		'IN03217' => 'Damonjodi',
		'IN03218' => 'Pottangi',
		'IN03219' => 'Kotiya',
		'IN03220' => 'Malkangiri',
		'IN03221' => 'Mathili',
		'IN03222' => 'Mudulipada',
		'IN03223' => 'Chitrakonda',
		'IN03224' => 'Paparmetla',
		'IN03225' => 'Jodamba',
		'IN03226' => 'Orkel',
		'IN03227' => 'Kalimela',
		'IN03228' => 'Podia',
		'IN03229' => 'M.V. 79',
		'IN03230' => 'Motu',
	],
	'CT' => [
		'IN03231' => 'Bharatpur',
		'IN03232' => 'Baikunthpur',
		'IN03233' => 'Sonhat',
		'IN03234' => 'Manendragarh',
		'IN03235' => 'Khadganva',
		'IN03236' => 'Ramanujganj',
		'IN03237' => 'Balrampur',
		'IN03238' => 'Wadrafnagar',
		'IN03239' => 'Pratappur',
		'IN03240' => 'Samri(kusmi)',
		'IN03241' => 'Shankargarh',
		'IN03242' => 'Surajpur',
		'IN03243' => 'Oudgi',
		'IN03244' => 'Bhaiyathan',
		'IN03245' => 'Ramanujnagar',
		'IN03246' => 'Premnagar',
		'IN03247' => 'Ambikapur',
		'IN03248' => 'Lakhanpur',
		'IN03249' => 'Udaypur',
		'IN03250' => 'Rajpur',
		'IN03251' => 'Lundra',
		'IN03252' => 'Sitapur',
		'IN03253' => 'Batouli',
		'IN03254' => 'Mainpat',
		'IN03255' => 'Bagicha',
		'IN03256' => 'Kansabel',
		'IN03257' => 'Jashpur',
		'IN03258' => 'Manora',
		'IN03259' => 'Kunkuri',
		'IN03260' => 'Duldula',
		'IN03261' => 'Farsabahar',
		'IN03262' => 'Pathalgaon',
		'IN03263' => 'Udaipur (Dharamjaigarh)',
		'IN03264' => 'Lailunga',
		'IN03265' => 'Gharghoda',
		'IN03266' => 'Tamnar',
		'IN03267' => 'Raigarh',
		'IN03268' => 'Pusour',
		'IN03269' => 'Kharsia',
		'IN03270' => 'Sarangarh',
		'IN03271' => 'Baramkela',
		'IN03272' => 'Katghora',
		'IN03273' => 'Poundi-Uproda',
		'IN03274' => 'Pali',
		'IN03275' => 'Korba',
		'IN03276' => 'Kartala',
		'IN03277' => 'Janjgir',
		'IN03278' => 'Akaltara',
		'IN03279' => 'Baloda',
		'IN03280' => 'Nawagarh',
		'IN03281' => 'Champa',
		'IN03282' => 'Sakti',
		'IN03283' => 'Pamgarh',
		'IN03284' => 'Dabhra',
		'IN03285' => 'Malkharoda',
		'IN03286' => 'Jaijaipur',
		'IN03287' => 'Pendra Road Gorella',
		'IN03288' => 'Marwahi',
		'IN03289' => 'Pendra',
		'IN03290' => 'Lormi',
		'IN03291' => 'Kota',
		'IN03292' => 'Mungeli',
		'IN03293' => 'Pathariya',
		'IN03294' => 'Takhatpur',
		'IN03295' => 'Bilaspur',
		'IN03296' => 'Masturi',
		'IN03297' => 'Bilha',
		'IN03298' => 'Kawardha',
		'IN03299' => 'Bodla',
		'IN03300' => 'Sahaspur Lohara',
		'IN03301' => 'Pandariya',
		'IN03302' => 'Chhuikhadan',
		'IN03303' => 'Khairagarh',
		'IN03304' => 'Dongargarh',
		'IN03305' => 'Rajnandgaon',
		'IN03306' => 'Chhuriya',
		'IN03307' => 'Dongargaon',
		'IN03308' => 'Mohla',
		'IN03309' => 'Manpur',
		'IN03310' => 'Ambagarh',
		'IN03311' => 'Nawagarh',
		'IN03312' => 'Bemetara',
		'IN03313' => 'Saja',
		'IN03314' => 'Thanakhamria',
		'IN03315' => 'Berla',
		'IN03316' => 'Dhamdha',
		'IN03317' => 'Durg',
		'IN03318' => 'Patan',
		'IN03319' => 'Gunderdehi',
		'IN03320' => 'Dondi Luhara',
		'IN03321' => ' Balod',
		'IN03322' => 'Dondi',
		'IN03323' => 'Gurur',
		'IN03324' => 'Simga',
		'IN03325' => 'Bhatapara',
		'IN03326' => 'Baloda Bazar',
		'IN03327' => 'Palari',
		'IN03328' => 'Kasdol',
		'IN03329' => 'Bilaigarh',
		'IN03330' => 'Arang',
		'IN03331' => 'Abhanpur',
		'IN03332' => 'Raipur',
		'IN03333' => 'Rajim',
		'IN03334' => 'Tilda',
		'IN03335' => 'Bindranavagarh(Gariyaband)',
		'IN03336' => 'Chhura',
		'IN03337' => 'Mainpur',
		'IN03338' => 'Deobhog',
		'IN03339' => 'Basna',
		'IN03340' => 'Saraipali',
		'IN03341' => 'Mahasamund',
		'IN03342' => 'Pithora',
		'IN03343' => 'Bagbahra',
		'IN03344' => 'Kurud',
		'IN03345' => 'Magarlod',
		'IN03346' => 'Dhamtari',
		'IN03347' => 'Nagri',
		'IN03348' => 'Charama',
		'IN03349' => 'Bhanupratappur',
		'IN03350' => 'Durgkondal',
		'IN03351' => 'Kanker',
		'IN03352' => 'Narharpur',
		'IN03353' => 'Antagarh',
		'IN03354' => 'Pakhanjur',
		'IN03355' => 'Keskal',
		'IN03356' => 'Bade Rajpur',
		'IN03357' => 'Kondagaon',
		'IN03358' => 'Makdi',
		'IN03359' => 'Farasgaon',
		'IN03360' => 'Jagdalpur',
		'IN03361' => 'Lohandiguda',
		'IN03362' => 'Bastanar',
		'IN03363' => 'Bastar',
		'IN03364' => 'Bakavand',
		'IN03365' => 'Tokapal',
		'IN03366' => 'Darbha',
		'IN03367' => 'Narayanpur',
		'IN03368' => 'Orchha',
		'IN03369' => 'Dantewada',
		'IN03370' => 'Gidam',
		'IN03371' => 'Katekalyan',
		'IN03372' => 'Kuakonda',
		'IN03373' => 'Konta',
		'IN03374' => 'Chhindgarh',
		'IN03375' => 'Sukma',
		'IN03376' => 'Bhopalpattnam',
		'IN03377' => 'Usur',
		'IN03378' => 'Bijapur',
		'IN03379' => 'Bhairamgarh',
	],
	'MP' => [
		'IN03380' => 'Vijaypur',
		'IN03381' => 'Beerpur',
		'IN03382' => 'Sheopur',
		'IN03383' => 'Badoda',
		'IN03384' => 'Karahal',
		'IN03385' => 'Ambah',
		'IN03386' => 'Porsa',
		'IN03387' => 'Morena',
		'IN03388' => 'Joura',
		'IN03389' => 'Kailaras',
		'IN03390' => 'Sabalgarh',
		'IN03391' => 'Ater',
		'IN03392' => 'Bhind',
		'IN03393' => 'Mehgaon',
		'IN03394' => 'Gormi',
		'IN03395' => 'Gohad',
		'IN03396' => 'Ron',
		'IN03397' => 'Mihona',
		'IN03398' => 'Lahar',
		'IN03399' => 'Gwalior (Gird)',
		'IN03400' => 'Dabra (Pichhore)',
		'IN03401' => 'Bhitarwar',
		'IN03402' => 'Chinour',
		'IN03403' => 'Seondha',
		'IN03404' => 'Indergarh',
		'IN03405' => 'Datia',
		'IN03406' => 'Bhander',
		'IN03407' => 'Pohri',
		'IN03408' => 'Shivpuri',
		'IN03409' => 'Narwar',
		'IN03410' => 'Karera',
		'IN03411' => 'Kolaras',
		'IN03412' => 'Badarwas',
		'IN03413' => 'Pichhore',
		'IN03414' => 'Khaniyadhana',
		'IN03415' => 'Niwari',
		'IN03416' => 'Orchha',
		'IN03417' => 'Prithvipur',
		'IN03418' => 'Jatara',
		'IN03419' => 'Mohangarh',
		'IN03420' => 'Palera',
		'IN03421' => 'Baldeogarh',
		'IN03422' => 'Khargapur',
		'IN03423' => 'Tikamgarh',
		'IN03424' => 'Gaurihar',
		'IN03425' => 'Laundi',
		'IN03426' => 'Chandla',
		'IN03427' => 'Nowgong',
		'IN03428' => 'Maharajpur',
		'IN03429' => 'Chhatarpur',
		'IN03430' => 'Rajnagar',
		'IN03431' => 'Bada Malhera',
		'IN03432' => 'Ghuwara',
		'IN03433' => 'Bijawar',
		'IN03434' => 'Buxwaha',
		'IN03435' => 'Ajaigarh',
		'IN03436' => 'Panna',
		'IN03437' => 'Devendranagar',
		'IN03438' => 'Gunnor',
		'IN03439' => 'Amanganj',
		'IN03440' => 'Pawai',
		'IN03441' => 'Shahnagar',
		'IN03442' => 'Raipura',
		'IN03443' => 'Bina',
		'IN03444' => 'Khurai',
		'IN03445' => 'Malthon',
		'IN03446' => 'Banda',
		'IN03447' => 'Shahgarh',
		'IN03448' => 'Rahatgarh',
		'IN03449' => 'Sagar',
		'IN03450' => 'Garhakota',
		'IN03451' => 'Rehli',
		'IN03452' => 'Kesli',
		'IN03453' => 'Deori',
		'IN03454' => 'Hatta',
		'IN03455' => 'Patera',
		'IN03456' => 'Batiyagarh',
		'IN03457' => 'Patharia',
		'IN03458' => 'Damoh',
		'IN03459' => 'Jabera',
		'IN03460' => 'Tendukheda',
		'IN03461' => 'Raghurajnagar',
		'IN03462' => 'Majhgawan',
		'IN03463' => 'Birsinghpur',
		'IN03464' => 'Nagod',
		'IN03465' => 'Unchahara',
		'IN03466' => 'Rampur Baghelan',
		'IN03467' => 'Kotar',
		'IN03468' => 'Amarpatan',
		'IN03469' => 'Ramnagar',
		'IN03470' => 'Maihar',
		'IN03471' => 'Teonthar',
		'IN03472' => 'Jawa',
		'IN03473' => 'Sirmour',
		'IN03474' => 'Mangawan',
		'IN03475' => 'Semaria',
		'IN03476' => 'Hanumana',
		'IN03477' => 'Mauganj',
		'IN03478' => 'Naigarhi',
		'IN03479' => 'Huzur',
		'IN03480' => 'Raipur - Karchuliyan',
		'IN03481' => 'Gurh',
		'IN03482' => 'Bandhogarh',
		'IN03483' => 'Chandia',
		'IN03484' => 'Manpur',
		'IN03485' => 'Pali',
		'IN03486' => 'Nowrozabad',
		'IN03487' => 'Jawad',
		'IN03488' => 'Singoli',
		'IN03489' => 'Neemuch',
		'IN03490' => 'Jiran',
		'IN03491' => 'Manasa',
		'IN03492' => 'Bhanpura',
		'IN03493' => 'Malhargarh',
		'IN03494' => 'Garoth',
		'IN03495' => 'Shamgarh',
		'IN03496' => 'Mandsaur',
		'IN03497' => 'Daloda',
		'IN03498' => 'Sitamau',
		'IN03499' => 'Suwasara',
		'IN03500' => 'Piploda',
		'IN03501' => 'Jaora',
		'IN03502' => 'Alot',
		'IN03503' => 'Tal',
		'IN03504' => 'Sailana',
		'IN03505' => 'Bajna',
		'IN03506' => 'Rawti',
		'IN03507' => 'Ratlam',
		'IN03508' => 'Khacharod',
		'IN03509' => 'Nagda',
		'IN03510' => 'Mahidpur',
		'IN03511' => 'Ghatiya',
		'IN03512' => 'Tarana',
		'IN03513' => 'Ujjain',
		'IN03514' => 'Badnagar',
		'IN03515' => 'Susner',
		'IN03516' => 'Nalkheda',
		'IN03517' => 'Badod',
		'IN03518' => 'Agar',
		'IN03519' => 'Shajapur',
		'IN03520' => 'Gulana',
		'IN03521' => 'Moman Badodiya',
		'IN03522' => 'Shujalpur',
		'IN03523' => 'Kalapipal',
		'IN03524' => 'Tonk Khurd',
		'IN03525' => 'Sonkatch',
		'IN03526' => 'Dewas',
		'IN03527' => 'Kannod',
		'IN03528' => 'Satwas',
		'IN03529' => 'Bagli',
		'IN03530' => 'Hatpiplya',
		'IN03531' => 'Khategaon',
		'IN03532' => 'Badnawar',
		'IN03533' => 'Sardarpur',
		'IN03534' => 'Dhar',
		'IN03535' => 'Gandhwani',
		'IN03536' => 'Kukshi',
		'IN03537' => 'Dahi',
		'IN03538' => 'Manawar',
		'IN03539' => 'Dharampuri',
		'IN03540' => 'Depalpur',
		'IN03541' => 'Hatod',
		'IN03542' => 'Sawer',
		'IN03543' => 'Indore',
		'IN03544' => 'Mhow',
		'IN03545' => 'Barwaha',
		'IN03546' => 'Maheshwar',
		'IN03547' => 'Kasrawad',
		'IN03548' => 'Segaon',
		'IN03549' => 'Bhikangaon',
		'IN03550' => 'Khargone',
		'IN03551' => 'Gogaon',
		'IN03552' => 'Bhagwanpura',
		'IN03553' => 'Jhiranya',
		'IN03554' => 'Barwani',
		'IN03555' => 'Pati',
		'IN03556' => 'Thikri',
		'IN03557' => 'Anjad',
		'IN03558' => 'Rajpur',
		'IN03559' => 'Pansemal',
		'IN03560' => 'Niwali',
		'IN03561' => 'Sendhwa',
		'IN03562' => 'Varla',
		'IN03563' => 'Jirapur',
		'IN03564' => 'Khilchipur',
		'IN03565' => 'Rajgarh',
		'IN03566' => 'Biaora',
		'IN03567' => 'Sarangpur',
		'IN03568' => 'Narsinghgarh',
		'IN03569' => 'Pachore',
		'IN03570' => 'Lateri',
		'IN03571' => 'Sironj',
		'IN03572' => 'Kurwai',
		'IN03573' => 'Basoda',
		'IN03574' => 'Tyonda',
		'IN03575' => 'Nateran',
		'IN03576' => 'Shamshabad',
		'IN03577' => 'Gyaraspur',
		'IN03578' => 'Gulabganj',
		'IN03579' => 'Vidisha',
		'IN03580' => 'Berasia',
		'IN03581' => 'Huzur',
		'IN03582' => 'Sehore',
		'IN03583' => 'Shyampur',
		'IN03584' => 'Ashta',
		'IN03585' => 'Jawar',
		'IN03586' => 'Ichhawar',
		'IN03587' => 'Nasrullaganj',
		'IN03588' => 'Budni',
		'IN03589' => 'Rehti',
		'IN03590' => 'Raisen',
		'IN03591' => 'Gairatganj',
		'IN03592' => 'Begamganj',
		'IN03593' => 'Goharganj',
		'IN03594' => 'Baraily',
		'IN03595' => 'Badi',
		'IN03596' => 'Silwani',
		'IN03597' => 'Udaipura',
		'IN03598' => 'Bhainsdehi',
		'IN03599' => 'Athner',
		'IN03600' => 'Betul',
		'IN03601' => 'Chicholi',
		'IN03602' => 'Ghoda Dongri',
		'IN03603' => 'Shahpur',
		'IN03604' => 'Multai',
		'IN03605' => 'Amla',
		'IN03606' => 'Khirkiya',
		'IN03607' => 'Sirali',
		'IN03608' => 'Harda',
		'IN03609' => 'Handiya',
		'IN03610' => 'Timarni',
		'IN03611' => 'Rehatgaon',
		'IN03612' => 'Seoni-Malwa',
		'IN03613' => 'Itarsi',
		'IN03614' => 'Hoshangabad',
		'IN03615' => 'Dolariya',
		'IN03616' => 'Babai',
		'IN03617' => 'Sohagpur',
		'IN03618' => 'Pipariya',
		'IN03619' => 'Bankhedi',
		'IN03620' => 'Murwara',
		'IN03621' => 'Rithi',
		'IN03622' => 'Barhi',
		'IN03623' => 'Badwara',
		'IN03624' => 'Vijayraghavgarh',
		'IN03625' => 'Bahoriband',
		'IN03626' => 'Dhimarkheda',
		'IN03627' => 'Sihora',
		'IN03628' => 'Majholi',
		'IN03629' => 'Patan',
		'IN03630' => 'Shahpura',
		'IN03631' => 'Jabalpur',
		'IN03632' => 'Panagar',
		'IN03633' => 'Kundam',
		'IN03634' => 'Gotegaon',
		'IN03635' => 'Gadarwara',
		'IN03636' => 'Narsimhapur',
		'IN03637' => 'Kareli',
		'IN03638' => 'Tendukheda',
		'IN03639' => 'Shahpura',
		'IN03640' => 'Dindori',
		'IN03641' => 'Niwas',
		'IN03642' => 'Narayanganj',
		'IN03643' => 'Mandla',
		'IN03644' => 'Ghughari',
		'IN03645' => 'Bichhiya',
		'IN03646' => 'Nainpur',
		'IN03647' => 'Tamia',
		'IN03648' => 'Amarwara',
		'IN03649' => 'Harrai',
		'IN03650' => 'Chaurai',
		'IN03651' => 'Jamai',
		'IN03652' => 'Parasia',
		'IN03653' => 'Umreth',
		'IN03654' => 'Chhindwara',
		'IN03655' => 'Mohkhed',
		'IN03656' => 'Sausar',
		'IN03657' => 'Bichhua',
		'IN03658' => 'Pandhurna',
		'IN03659' => 'Lakhnadon',
		'IN03660' => 'Chhapara',
		'IN03661' => 'Ghansaur',
		'IN03662' => 'Dhanora',
		'IN03663' => 'Keolari',
		'IN03664' => 'Seoni',
		'IN03665' => 'Barghat',
		'IN03666' => 'Kurai',
		'IN03667' => 'Katangi',
		'IN03668' => 'Tirodi',
		'IN03669' => 'Waraseoni',
		'IN03670' => 'Khairlanji',
		'IN03671' => 'Lalbarra',
		'IN03672' => 'Balaghat',
		'IN03673' => 'Kirnapur',
		'IN03674' => 'Baihar',
		'IN03675' => 'Paraswada',
		'IN03676' => 'Lanji',
		'IN03677' => 'Guna',
		'IN03678' => 'Bamori',
		'IN03679' => 'Raghogarh',
		'IN03680' => 'Maksoodangarh',
		'IN03681' => 'Kumbhraj',
		'IN03682' => 'Aron',
		'IN03683' => 'Chachaura',
		'IN03684' => 'Isagarh',
		'IN03685' => 'Chanderi',
		'IN03686' => 'Ashoknagar',
		'IN03687' => 'Shadhora',
		'IN03688' => 'Mungaoli',
		'IN03689' => 'Beohari',
		'IN03690' => 'Jaisinghnagar',
		'IN03691' => 'Sohagpur',
		'IN03692' => 'Jaitpur',
		'IN03693' => 'Kotma',
		'IN03694' => 'Anuppur',
		'IN03695' => 'Jaithari',
		'IN03696' => 'Pushparajgarh',
		'IN03697' => 'Rampur Naikin',
		'IN03698' => 'Churhat',
		'IN03699' => 'Gopadbanas',
		'IN03700' => 'Sihawal',
		'IN03701' => 'Majhauli',
		'IN03702' => 'Kusmi',
		'IN03703' => 'Chitrangi',
		'IN03704' => 'Deosar',
		'IN03705' => 'Singrauli',
		'IN03706' => 'Thandla',
		'IN03707' => 'Petlawad',
		'IN03708' => 'Meghnagar',
		'IN03709' => 'Jhabua',
		'IN03710' => 'Ranapur',
		'IN03711' => 'Bhavra',
		'IN03712' => 'Jobat',
		'IN03713' => 'Alirajpur',
		'IN03714' => 'Harsud',
		'IN03715' => 'Khalwa',
		'IN03716' => 'Khandwa',
		'IN03717' => 'Punasa',
		'IN03718' => 'Pandhana',
		'IN03719' => 'Burhanpur',
		'IN03720' => 'Khaknar',
		'IN03721' => 'Nepanagar',
	],
	'GJ' => [
		'IN03722' => 'Lakhpat',
		'IN03723' => 'Rapar',
		'IN03724' => 'Bhachau',
		'IN03725' => 'Anjar',
		'IN03726' => 'Bhuj',
		'IN03727' => 'Nakhatrana',
		'IN03728' => 'Abdasa',
		'IN03729' => 'Mandvi',
		'IN03730' => 'Mundra',
		'IN03731' => 'Gandhidham',
		'IN03732' => 'Vav',
		'IN03733' => 'Tharad',
		'IN03734' => 'Dhanera',
		'IN03735' => 'Dantiwada',
		'IN03736' => 'Amirgadh',
		'IN03737' => 'Danta',
		'IN03738' => 'Vadgam',
		'IN03739' => 'Palanpur',
		'IN03740' => 'Deesa',
		'IN03741' => 'Deodar',
		'IN03742' => 'Bhabhar',
		'IN03743' => 'Kankrej',
		'IN03744' => 'Santalpur',
		'IN03745' => 'Radhanpur',
		'IN03746' => 'Sidhpur',
		'IN03747' => 'Patan',
		'IN03748' => 'Harij',
		'IN03749' => 'Sami',
		'IN03750' => 'Chanasma',
		'IN03751' => 'Satlasana',
		'IN03752' => 'Kheralu',
		'IN03753' => 'Unjha',
		'IN03754' => 'Visnagar',
		'IN03755' => 'Vadnagar',
		'IN03756' => 'Vijapur',
		'IN03757' => 'Mahesana',
		'IN03758' => 'Becharaji',
		'IN03759' => 'Kadi',
		'IN03760' => 'Khedbrahma',
		'IN03761' => 'Vijaynagar',
		'IN03762' => 'Vadali',
		'IN03763' => 'Idar',
		'IN03764' => 'Bhiloda',
		'IN03765' => 'Meghraj',
		'IN03766' => 'Himatnagar',
		'IN03767' => 'Prantij',
		'IN03768' => 'Talod',
		'IN03769' => 'Modasa',
		'IN03770' => 'Dhansura',
		'IN03771' => 'Malpur',
		'IN03772' => 'Bayad',
		'IN03773' => 'Kalol',
		'IN03774' => 'Mansa',
		'IN03775' => 'Gandhinagar',
		'IN03776' => 'Dehgam',
		'IN03777' => 'Mandal',
		'IN03778' => 'Detroj-Rampura',
		'IN03779' => 'Viramgam',
		'IN03780' => 'Sanand',
		'IN03781' => 'Ahmadabad City',
		'IN03782' => 'Daskroi',
		'IN03783' => 'Dholka',
		'IN03784' => 'Bavla',
		'IN03785' => 'Ranpur',
		'IN03786' => 'Barwala',
		'IN03787' => 'Dhandhuka',
		'IN03788' => 'Halvad',
		'IN03789' => 'Dhrangadhra',
		'IN03790' => 'Dasada',
		'IN03791' => 'Lakhtar',
		'IN03792' => 'Wadhwan',
		'IN03793' => 'Muli',
		'IN03794' => 'Chotila',
		'IN03795' => 'Sayla',
		'IN03796' => 'Chuda',
		'IN03797' => 'Limbdi',
		'IN03798' => 'Maliya',
		'IN03799' => 'Morvi',
		'IN03800' => 'Tankara',
		'IN03801' => 'Wankaner',
		'IN03802' => 'Paddhari',
		'IN03803' => 'Rajkot',
		'IN03804' => 'Lodhika',
		'IN03805' => 'Kotda Sangani',
		'IN03806' => 'Jasdan',
		'IN03807' => 'Gondal',
		'IN03808' => 'Jamkandorna',
		'IN03809' => 'Upleta',
		'IN03810' => 'Dhoraji',
		'IN03811' => 'Jetpur',
		'IN03812' => 'Okhamandal',
		'IN03813' => 'Khambhalia',
		'IN03814' => 'Jamnagar',
		'IN03815' => 'Jodiya',
		'IN03816' => 'Dhrol',
		'IN03817' => 'Kalavad',
		'IN03818' => 'Lalpur',
		'IN03819' => 'Kalyanpur',
		'IN03820' => 'Bhanvad',
		'IN03821' => 'Jamjodhpur',
		'IN03822' => 'Porbandar',
		'IN03823' => 'Ranavav',
		'IN03824' => 'Kutiyana',
		'IN03825' => 'Manavadar',
		'IN03826' => 'Vanthali',
		'IN03827' => 'Junagadh',
		'IN03828' => 'Bhesan',
		'IN03829' => 'Visavadar',
		'IN03830' => 'Mendarda',
		'IN03831' => 'Keshod',
		'IN03832' => 'Mangrol',
		'IN03833' => 'Malia',
		'IN03834' => 'Talala',
		'IN03835' => 'Patan-Veraval',
		'IN03836' => 'Sutrapada',
		'IN03837' => 'Kodinar',
		'IN03838' => 'Una',
		'IN03839' => 'Kunkavav Vadia',
		'IN03840' => 'Babra',
		'IN03841' => 'Lathi',
		'IN03842' => 'Lilia',
		'IN03843' => 'Amreli',
		'IN03844' => 'Bagasara',
		'IN03845' => 'Dhari',
		'IN03846' => 'Savar Kundla',
		'IN03847' => 'Khambha',
		'IN03848' => 'Jafrabad',
		'IN03849' => 'Rajula',
		'IN03850' => 'Botad',
		'IN03851' => 'Vallabhipur',
		'IN03852' => 'Gadhada',
		'IN03853' => 'Umrala',
		'IN03854' => 'Bhavnagar',
		'IN03855' => 'Ghogha',
		'IN03856' => 'Sihor',
		'IN03857' => 'Gariadhar',
		'IN03858' => 'Palitana',
		'IN03859' => 'Talaja',
		'IN03860' => 'Mahuva',
		'IN03861' => 'Tarapur',
		'IN03862' => 'Sojitra',
		'IN03863' => 'Umreth',
		'IN03864' => 'Anand',
		'IN03865' => 'Petlad',
		'IN03866' => 'Khambhat',
		'IN03867' => 'Borsad',
		'IN03868' => 'Anklav',
		'IN03869' => 'Kapadvanj',
		'IN03870' => 'Virpur',
		'IN03871' => 'Balasinor',
		'IN03872' => 'Kathlal',
		'IN03873' => 'Mehmedabad',
		'IN03874' => 'Kheda',
		'IN03875' => 'Matar',
		'IN03876' => 'Nadiad',
		'IN03877' => 'Mahudha',
		'IN03878' => 'Thasra',
		'IN03879' => 'Khanpur',
		'IN03880' => 'Kadana',
		'IN03881' => 'Santrampur',
		'IN03882' => 'Lunawada',
		'IN03883' => 'Shehera',
		'IN03884' => 'Morwa (Hadaf)',
		'IN03885' => 'Godhra',
		'IN03886' => 'Kalol',
		'IN03887' => 'Ghoghamba',
		'IN03888' => 'Halol',
		'IN03889' => 'Jambughoda',
		'IN03890' => 'Fatepura',
		'IN03891' => 'Jhalod',
		'IN03892' => 'Limkheda',
		'IN03893' => 'Dohad',
		'IN03894' => 'Garbada',
		'IN03895' => 'Devgadbaria',
		'IN03896' => 'Dhanpur',
		'IN03897' => 'Savli',
		'IN03898' => 'Vadodara',
		'IN03899' => 'Vaghodia',
		'IN03900' => 'Jetpur Pavi',
		'IN03901' => 'Chhota Udaipur',
		'IN03902' => 'Kavant',
		'IN03903' => 'Nasvadi',
		'IN03904' => 'Sankheda',
		'IN03905' => 'Dabhoi',
		'IN03906' => 'Padra',
		'IN03907' => 'Karjan',
		'IN03908' => 'Sinor',
		'IN03909' => 'Tilakwada',
		'IN03910' => 'Nandod',
		'IN03911' => 'Dediapada',
		'IN03912' => 'Sagbara',
		'IN03913' => 'Jambusar',
		'IN03914' => 'Amod',
		'IN03915' => 'Vagra',
		'IN03916' => 'Bharuch',
		'IN03917' => 'Jhagadia',
		'IN03918' => 'Anklesvar',
		'IN03919' => 'Hansot',
		'IN03920' => 'Valia',
		'IN03921' => 'The Dangs',
		'IN03922' => 'Navsari',
		'IN03923' => 'Jalalpore',
		'IN03924' => 'Gandevi',
		'IN03925' => 'Chikhli',
		'IN03926' => 'Bansda',
		'IN03927' => 'Valsad',
		'IN03928' => 'Dharampur',
		'IN03929' => 'Pardi',
		'IN03930' => 'Kaprada',
		'IN03931' => 'Umbergaon',
		'IN03932' => 'Olpad',
		'IN03933' => 'Mangrol',
		'IN03934' => 'Umarpada',
		'IN03935' => 'Mandvi',
		'IN03936' => 'Kamrej',
		'IN03937' => 'Surat City',
		'IN03938' => 'Chorasi',
		'IN03939' => 'Palsana',
		'IN03940' => 'Bardoli',
		'IN03941' => 'Mahuva',
		'IN03942' => 'Nizar',
		'IN03943' => 'Uchchhal',
		'IN03944' => 'Songadh',
		'IN03945' => 'Vyara',
		'IN03946' => 'Valod',
	],
	'DD' => [
		'IN03947' => 'Diu',
		'IN03948' => 'Daman',
	],
	'DN' => [
		'IN03949' => 'Dadra & Nagar Haveli',
	],
	'MH' => [
		'IN03950' => 'Akkalkuwa',
		'IN03951' => 'Akrani',
		'IN03952' => 'Talode',
		'IN03953' => 'Shahade',
		'IN03954' => 'Nandurbar',
		'IN03955' => 'Nawapur',
		'IN03956' => 'Shirpur',
		'IN03957' => 'Sindkhede',
		'IN03958' => 'Sakri',
		'IN03959' => 'Dhule',
		'IN03960' => 'Chopda',
		'IN03961' => 'Yawal',
		'IN03962' => 'Raver',
		'IN03963' => 'Muktainagar',
		'IN03964' => 'Bodvad',
		'IN03965' => 'Bhusawal',
		'IN03966' => 'Jalgaon',
		'IN03967' => 'Erandol',
		'IN03968' => 'Dharangaon',
		'IN03969' => 'Amalner',
		'IN03970' => 'Parola',
		'IN03971' => 'Bhadgaon',
		'IN03972' => 'Chalisgaon',
		'IN03973' => 'Pachora',
		'IN03974' => 'Jamner',
		'IN03975' => 'Jalgaon (Jamod)',
		'IN03976' => 'Sangrampur',
		'IN03977' => 'Shegaon',
		'IN03978' => 'Nandura',
		'IN03979' => 'Malkapur',
		'IN03980' => 'Motala',
		'IN03981' => 'Khamgaon',
		'IN03982' => 'Mehkar',
		'IN03983' => 'Chikhli',
		'IN03984' => 'Buldana',
		'IN03985' => 'Deolgaon Raja',
		'IN03986' => 'Sindkhed Raja',
		'IN03987' => 'Lonar',
		'IN03988' => 'Telhara',
		'IN03989' => 'Akot',
		'IN03990' => 'Balapur',
		'IN03991' => 'Akola',
		'IN03992' => 'Murtijapur',
		'IN03993' => 'Patur',
		'IN03994' => 'Barshitakli',
		'IN03995' => 'Malegaon',
		'IN03996' => 'Mangrulpir',
		'IN03997' => 'Karanja',
		'IN03998' => 'Manora',
		'IN03999' => 'Washim',
		'IN04000' => 'Risod',
		'IN04001' => 'Dharni',
		'IN04002' => 'Chikhaldara',
		'IN04003' => 'Anjangaon Surji',
		'IN04004' => 'Achalpur',
		'IN04005' => 'Chandurbazar',
		'IN04006' => 'Morshi',
		'IN04007' => 'Warud',
		'IN04008' => 'Teosa',
		'IN04009' => 'Amravati',
		'IN04010' => 'Bhatkuli',
		'IN04011' => 'Daryapur',
		'IN04012' => 'Nandgaon-Khandeshwar',
		'IN04013' => 'Chandur Railway',
		'IN04014' => 'Dhamangaon Railway',
		'IN04015' => 'Ashti',
		'IN04016' => 'Karanja',
		'IN04017' => 'Arvi',
		'IN04018' => 'Seloo',
		'IN04019' => 'Wardha',
		'IN04020' => 'Deoli',
		'IN04021' => 'Hinganghat',
		'IN04022' => 'Samudrapur',
		'IN04023' => 'Narkhed',
		'IN04024' => 'Katol',
		'IN04025' => 'Kalameshwar',
		'IN04026' => 'Savner',
		'IN04027' => 'Parseoni',
		'IN04028' => 'Ramtek',
		'IN04029' => 'Mauda',
		'IN04030' => 'Kamptee',
		'IN04031' => 'Nagpur (Rural)',
		'IN04032' => 'Nagpur (Urban)',
		'IN04033' => 'Hingna',
		'IN04034' => 'Umred',
		'IN04035' => 'Kuhi',
		'IN04036' => 'Bhiwapur',
		'IN04037' => 'Tumsar',
		'IN04038' => 'Mohadi',
		'IN04039' => 'Bhandara',
		'IN04040' => 'Sakoli',
		'IN04041' => 'Lakhani',
		'IN04042' => 'Pauni',
		'IN04043' => 'Lakhandur',
		'IN04044' => 'Tirora',
		'IN04045' => 'Goregaon',
		'IN04046' => 'Gondiya',
		'IN04047' => 'Amgaon',
		'IN04048' => 'Salekasa',
		'IN04049' => 'Sadak-Arjuni',
		'IN04050' => 'Arjuni Morgaon',
		'IN04051' => 'Deori',
		'IN04052' => 'Desaiganj (Vadasa)',
		'IN04053' => 'Armori',
		'IN04054' => 'Kurkheda',
		'IN04055' => 'Korchi',
		'IN04056' => 'Dhanora',
		'IN04057' => 'Gadchiroli',
		'IN04058' => 'Chamorshi',
		'IN04059' => 'Mulchera',
		'IN04060' => 'Etapalli',
		'IN04061' => 'Bhamragad',
		'IN04062' => 'Aheri',
		'IN04063' => 'Sironcha',
		'IN04064' => 'Warora',
		'IN04065' => 'Chimur',
		'IN04066' => 'Nagbhir',
		'IN04067' => 'Brahmapuri',
		'IN04068' => 'Sawali',
		'IN04069' => 'Sindewahi',
		'IN04070' => 'Bhadravati',
		'IN04071' => 'Chandrapur',
		'IN04072' => 'Mul',
		'IN04073' => 'Pombhurna',
		'IN04074' => 'Ballarpur',
		'IN04075' => 'Korpana',
		'IN04076' => 'Jiwati',
		'IN04077' => 'Rajura',
		'IN04078' => 'Gondpipri',
		'IN04079' => 'Ner',
		'IN04080' => 'Babulgaon',
		'IN04081' => 'Kalamb',
		'IN04082' => 'Yavatmal',
		'IN04083' => 'Darwha',
		'IN04084' => 'Digras',
		'IN04085' => 'Pusad',
		'IN04086' => 'Umarkhed',
		'IN04087' => 'Mahagaon',
		'IN04088' => 'Arni',
		'IN04089' => 'Ghatanji',
		'IN04090' => 'Kelapur',
		'IN04091' => 'Ralegaon',
		'IN04092' => 'Maregaon',
		'IN04093' => 'Zari-Jamani',
		'IN04094' => 'Wani',
		'IN04095' => 'Mahoor',
		'IN04096' => 'Kinwat',
		'IN04097' => 'Himayatnagar',
		'IN04098' => 'Hadgaon',
		'IN04099' => 'Ardhapur',
		'IN04100' => 'Nanded',
		'IN04101' => 'Mudkhed',
		'IN04102' => 'Bhokar',
		'IN04103' => 'Umri',
		'IN04104' => 'Dharmabad',
		'IN04105' => 'Biloli',
		'IN04106' => 'Naigaon (Khairgaon)',
		'IN04107' => 'Loha',
		'IN04108' => 'Kandhar',
		'IN04109' => 'Mukhed',
		'IN04110' => 'Deglur',
		'IN04111' => 'Sengaon',
		'IN04112' => 'Hingoli',
		'IN04113' => 'Aundha (Nagnath)',
		'IN04114' => 'Kalamnuri',
		'IN04115' => 'Basmath',
		'IN04116' => 'Sailu',
		'IN04117' => 'Jintur',
		'IN04118' => 'Parbhani',
		'IN04119' => 'Manwath',
		'IN04120' => 'Pathri',
		'IN04121' => 'Sonpeth',
		'IN04122' => 'Gangakhed',
		'IN04123' => 'Palam',
		'IN04124' => 'Purna',
		'IN04125' => 'Bhokardan',
		'IN04126' => 'Jafferabad',
		'IN04127' => 'Jalna',
		'IN04128' => 'Badnapur',
		'IN04129' => 'Ambad',
		'IN04130' => 'Ghansawangi',
		'IN04131' => 'Partur',
		'IN04132' => 'Mantha',
		'IN04133' => 'Kannad',
		'IN04134' => 'Soegaon',
		'IN04135' => 'Sillod',
		'IN04136' => 'Phulambri',
		'IN04137' => 'Aurangabad',
		'IN04138' => 'Khuldabad',
		'IN04139' => 'Vaijapur',
		'IN04140' => 'Gangapur',
		'IN04141' => 'Paithan',
		'IN04142' => 'Surgana',
		'IN04143' => 'Kalwan',
		'IN04144' => 'Deola',
		'IN04145' => 'Baglan',
		'IN04146' => 'Malegaon',
		'IN04147' => 'Nandgaon',
		'IN04148' => 'Chandvad',
		'IN04149' => 'Dindori',
		'IN04150' => 'Peint',
		'IN04151' => 'Trimbakeshwar',
		'IN04152' => 'Nashik',
		'IN04153' => 'Igatpuri',
		'IN04154' => 'Sinnar',
		'IN04155' => 'Niphad',
		'IN04156' => 'Yevla',
		'IN04157' => 'Talasari',
		'IN04158' => 'Dahanu',
		'IN04159' => 'Vikramgad',
		'IN04160' => 'Jawhar',
		'IN04161' => 'Mokhada',
		'IN04162' => 'Vada',
		'IN04163' => 'Palghar',
		'IN04164' => 'Vasai',
		'IN04165' => 'Thane',
		'IN04166' => 'Bhiwandi',
		'IN04167' => 'Shahapur',
		'IN04168' => 'Kalyan',
		'IN04169' => 'Ulhasnagar',
		'IN04170' => 'Ambarnath',
		'IN04171' => 'Murbad',
		'IN04172' => 'Uran',
		'IN04173' => 'Panvel',
		'IN04174' => 'Karjat',
		'IN04175' => 'Khalapur',
		'IN04176' => 'Pen',
		'IN04177' => 'Alibag',
		'IN04178' => 'Murud',
		'IN04179' => 'Roha',
		'IN04180' => 'Sudhagad',
		'IN04181' => 'Mangaon',
		'IN04182' => 'Tala',
		'IN04183' => 'Shrivardhan',
		'IN04184' => 'Mhasla',
		'IN04185' => 'Mahad',
		'IN04186' => 'Poladpur',
		'IN04187' => 'Junnar',
		'IN04188' => 'Ambegaon',
		'IN04189' => 'Shirur',
		'IN04190' => 'Khed',
		'IN04191' => 'Mawal',
		'IN04192' => 'Mulshi',
		'IN04193' => 'Haveli',
		'IN04194' => 'Pune City',
		'IN04195' => 'Daund',
		'IN04196' => 'Purandhar',
		'IN04197' => 'Velhe',
		'IN04198' => 'Bhor',
		'IN04199' => 'Baramati',
		'IN04200' => 'Indapur',
		'IN04201' => 'Akola',
		'IN04202' => 'Sangamner',
		'IN04203' => 'Kopargaon',
		'IN04204' => 'Rahta',
		'IN04205' => 'Shrirampur',
		'IN04206' => 'Nevasa',
		'IN04207' => 'Shevgaon',
		'IN04208' => 'Pathardi',
		'IN04209' => 'Nagar',
		'IN04210' => 'Rahuri',
		'IN04211' => 'Parner',
		'IN04212' => 'Shrigonda',
		'IN04213' => 'Karjat',
		'IN04214' => 'Jamkhed',
		'IN04215' => 'Ashti',
		'IN04216' => 'Patoda',
		'IN04217' => 'Shirur (Kasar)',
		'IN04218' => 'Georai',
		'IN04219' => 'Manjlegaon',
		'IN04220' => 'Wadwani',
		'IN04221' => 'Bid',
		'IN04222' => 'Kaij',
		'IN04223' => 'Dharur',
		'IN04224' => 'Parli',
		'IN04225' => 'Ambejogai',
		'IN04226' => 'Latur',
		'IN04227' => 'Renapur',
		'IN04228' => 'Ahmadpur',
		'IN04229' => 'Jalkot',
		'IN04230' => 'Chakur',
		'IN04231' => 'Shirur-Anantpal',
		'IN04232' => 'Ausa',
		'IN04233' => 'Nilanga',
		'IN04234' => 'Deoni',
		'IN04235' => 'Udgir',
		'IN04236' => 'Paranda',
		'IN04237' => 'Bhum',
		'IN04238' => 'Washi',
		'IN04239' => 'Kalamb',
		'IN04240' => 'Osmanabad',
		'IN04241' => 'Tuljapur',
		'IN04242' => 'Lohara',
		'IN04243' => 'Umarga',
		'IN04244' => 'Karmala',
		'IN04245' => 'Madha',
		'IN04246' => 'Barshi',
		'IN04247' => 'Solapur North',
		'IN04248' => 'Mohol',
		'IN04249' => 'Pandharpur',
		'IN04250' => 'Malshiras',
		'IN04251' => 'Sangole',
		'IN04252' => 'Mangalvedhe',
		'IN04253' => 'Solapur South',
		'IN04254' => 'Akkalkot',
		'IN04255' => 'Mahabaleshwar',
		'IN04256' => 'Wai',
		'IN04257' => 'Khandala',
		'IN04258' => 'Phaltan',
		'IN04259' => 'Man',
		'IN04260' => 'Khatav',
		'IN04261' => 'Koregaon',
		'IN04262' => 'Satara',
		'IN04263' => 'Jaoli',
		'IN04264' => 'Patan',
		'IN04265' => 'Karad',
		'IN04266' => 'Mandangad',
		'IN04267' => 'Dapoli',
		'IN04268' => 'Khed',
		'IN04269' => 'Chiplun',
		'IN04270' => 'Guhagar',
		'IN04271' => 'Ratnagiri',
		'IN04272' => 'Sangameshwar',
		'IN04273' => 'Lanja',
		'IN04274' => 'Rajapur',
		'IN04275' => 'Devgad',
		'IN04276' => 'Vaibhavvadi',
		'IN04277' => 'Kankavli',
		'IN04278' => 'Malwan',
		'IN04279' => 'Vengurla',
		'IN04280' => 'Kudal',
		'IN04281' => 'Sawantwadi',
		'IN04282' => 'Dodamarg',
		'IN04283' => 'Shahuwadi',
		'IN04284' => 'Panhala',
		'IN04285' => 'Hatkanangle',
		'IN04286' => 'Shirol',
		'IN04287' => 'Karvir',
		'IN04288' => 'Bavda',
		'IN04289' => 'Radhanagari',
		'IN04290' => 'Kagal',
		'IN04291' => 'Bhudargad',
		'IN04292' => 'Ajra',
		'IN04293' => 'Gadhinglaj',
		'IN04294' => 'Chandgad',
		'IN04295' => 'Shirala',
		'IN04296' => 'Walwa',
		'IN04297' => 'Palus',
		'IN04298' => 'Kadegaon',
		'IN04299' => 'Khanapur',
		'IN04300' => 'Atpadi',
		'IN04301' => 'Tasgaon',
		'IN04302' => 'Miraj',
		'IN04303' => 'Kavathemahankal',
		'IN04304' => 'Jat',
	],
	'AP' => [
		'IN04305' => 'Tamsi',
		'IN04306' => 'Adilabad',
		'IN04307' => 'Jainad',
		'IN04308' => 'Bela',
		'IN04309' => 'Talamadugu',
		'IN04310' => 'Gudihathnoor',
		'IN04311' => 'Inderavelly',
		'IN04312' => 'Narnoor',
		'IN04313' => 'Kerameri',
		'IN04314' => 'Wankdi',
		'IN04315' => 'Sirpur (T)',
		'IN04316' => 'Kouthala',
		'IN04317' => 'Bejjur',
		'IN04318' => 'Kagaznagar',
		'IN04319' => 'Asifabad',
		'IN04320' => 'Jainoor',
		'IN04321' => 'Utnoor',
		'IN04322' => 'Ichoda',
		'IN04323' => 'Bazarhathnoor',
		'IN04324' => 'Boath',
		'IN04325' => 'Neradigonda',
		'IN04326' => 'Sirpur',
		'IN04327' => 'Rebbana',
		'IN04328' => 'Bhimini',
		'IN04329' => 'Dahegaon',
		'IN04330' => 'Vemanpalle',
		'IN04331' => 'Nennal',
		'IN04332' => 'Tandur',
		'IN04333' => 'Tiryani',
		'IN04334' => 'Jannaram',
		'IN04335' => 'Kaddam (Peddur)',
		'IN04336' => 'Sarangapur',
		'IN04337' => 'Kuntala',
		'IN04338' => 'Kubeer',
		'IN04339' => 'Bhainsa',
		'IN04340' => 'Tanoor',
		'IN04341' => 'Mudhole',
		'IN04342' => 'Lokeswaram',
		'IN04343' => 'Dilawarpur',
		'IN04344' => 'Nirmal',
		'IN04345' => 'Laxmanchanda',
		'IN04346' => 'Mamda',
		'IN04347' => 'Khanapur',
		'IN04348' => 'Dandepalle',
		'IN04349' => 'Kasipet',
		'IN04350' => 'Bellampalle',
		'IN04351' => 'Kotapalle',
		'IN04352' => 'Mandamarri',
		'IN04353' => 'Luxettipet',
		'IN04354' => 'Mancherial',
		'IN04355' => 'Jaipur',
		'IN04356' => 'Chennur',
		'IN04357' => 'Ranjal',
		'IN04358' => 'Navipet',
		'IN04359' => 'Nandipet',
		'IN04360' => 'Armur',
		'IN04361' => 'Balkonda',
		'IN04362' => 'Mortad',
		'IN04363' => 'Kammarpalle',
		'IN04364' => 'Bheemgal',
		'IN04365' => 'Velpur',
		'IN04366' => 'Jakranpalle',
		'IN04367' => 'Makloor',
		'IN04368' => 'Nizamabad',
		'IN04369' => 'Yedpalle',
		'IN04370' => 'Bodhan',
		'IN04371' => 'Kotgiri',
		'IN04372' => 'Madnoor',
		'IN04373' => 'Jukkal',
		'IN04374' => 'Bichkunda',
		'IN04375' => 'Birkoor',
		'IN04376' => 'Varni',
		'IN04377' => 'Dichpalle',
		'IN04378' => 'Dharpalle',
		'IN04379' => 'Sirkonda',
		'IN04380' => 'Machareddy',
		'IN04381' => 'Sadasivanagar',
		'IN04382' => 'Gandhari',
		'IN04383' => 'Banswada',
		'IN04384' => 'Pitlam',
		'IN04385' => 'Nizamsagar',
		'IN04386' => 'Yellareddy',
		'IN04387' => 'Nagareddipet',
		'IN04388' => 'Lingampet',
		'IN04389' => 'Tadwai',
		'IN04390' => 'Kamareddy',
		'IN04391' => 'Bhiknoor',
		'IN04392' => 'Domakonda',
		'IN04393' => 'Ibrahimpatnam',
		'IN04394' => 'Mallapur',
		'IN04395' => 'Raikal',
		'IN04396' => 'Sarangapur',
		'IN04397' => 'Dharmapuri',
		'IN04398' => 'Velgatoor',
		'IN04399' => 'Ramagundam',
		'IN04400' => 'Kamanpur',
		'IN04401' => 'Manthani',
		'IN04402' => 'Kataram',
		'IN04403' => 'Mahadevpur',
		'IN04404' => 'Mutharam (Mahadevpur)',
		'IN04405' => 'Malharrao',
		'IN04406' => 'Mutharam (Manthani)',
		'IN04407' => 'Srirampur',
		'IN04408' => 'Peddapalle',
		'IN04409' => 'Julapalle',
		'IN04410' => 'Elgaid',
		'IN04411' => 'Dharmaram',
		'IN04412' => 'Gollapalle',
		'IN04413' => 'Mallial',
		'IN04414' => 'Jagtial',
		'IN04415' => 'Medipalle',
		'IN04416' => 'Koratla',
		'IN04417' => 'Metpalle',
		'IN04418' => 'Kathlapur',
		'IN04419' => 'Chandurthi',
		'IN04420' => 'Kodimial',
		'IN04421' => 'Pegadapalle',
		'IN04422' => 'Gangadhara',
		'IN04423' => 'Ramadugu',
		'IN04424' => 'Choppadandi',
		'IN04425' => 'Sultanabad',
		'IN04426' => 'Odela',
		'IN04427' => 'Manakondur',
		'IN04428' => 'Karimnagar',
		'IN04429' => 'Boinpalle',
		'IN04430' => 'Vemulawada',
		'IN04431' => 'Konaraopeta',
		'IN04432' => 'Yellareddipet',
		'IN04433' => 'Gambhiraopet',
		'IN04434' => 'Mustabad',
		'IN04435' => 'Sircilla',
		'IN04436' => 'Ellanthakunta',
		'IN04437' => 'Bejjanki',
		'IN04438' => 'Timmapur (LMD Colony)',
		'IN04439' => 'Veenavanka',
		'IN04440' => 'Jammikunta',
		'IN04441' => 'Shankarapatnam',
		'IN04442' => 'Chigurumamidi',
		'IN04443' => 'Koheda',
		'IN04444' => 'Husnabad',
		'IN04445' => 'Saidapur',
		'IN04446' => 'Huzurabad',
		'IN04447' => 'Kamalapur',
		'IN04448' => 'Bheemadevarpalle',
		'IN04449' => 'Elkathurthi',
		'IN04450' => 'Kangti',
		'IN04451' => 'Manoor',
		'IN04452' => 'Narayankhed',
		'IN04453' => 'Kalher',
		'IN04454' => 'Shankarampet (A)',
		'IN04455' => 'Papannapet',
		'IN04456' => 'Medak',
		'IN04457' => 'Ramayampet',
		'IN04458' => 'Dubbak',
		'IN04459' => 'Siddipet',
		'IN04460' => 'Chinnakodur',
		'IN04461' => 'Nangnoor',
		'IN04462' => 'Kondapak',
		'IN04463' => 'Thoguta',
		'IN04464' => 'Mirdoddi',
		'IN04465' => 'Doultabad',
		'IN04466' => 'Chegunta',
		'IN04467' => 'Shankarampet (R)',
		'IN04468' => 'Kulcharam',
		'IN04469' => 'Tekmal',
		'IN04470' => 'Alladurg',
		'IN04471' => 'Regode',
		'IN04472' => 'Raikode',
		'IN04473' => 'Nyalkal',
		'IN04474' => 'Zahirabad',
		'IN04475' => 'Kohir',
		'IN04476' => 'Jharasangam',
		'IN04477' => 'Munpalle',
		'IN04478' => 'Pulkal',
		'IN04479' => 'Andole',
		'IN04480' => 'Kowdipalle',
		'IN04481' => 'Yeldurthy',
		'IN04482' => 'Tupran',
		'IN04483' => 'Gajwel',
		'IN04484' => 'Jagdevpur',
		'IN04485' => 'Wargal',
		'IN04486' => 'Mulug',
		'IN04487' => 'Shivampet',
		'IN04488' => 'Narsapur',
		'IN04489' => 'Hathnoora',
		'IN04490' => 'Sadasivpet',
		'IN04491' => 'Kondapur',
		'IN04492' => 'Sangareddy',
		'IN04493' => 'Jinnaram',
		'IN04494' => 'Patancheru',
		'IN04495' => 'Ramachandrapuram',
		'IN04496' => 'Shaikpet',
		'IN04497' => 'Ameerpet',
		'IN04498' => 'Secunderabad',
		'IN04499' => 'Tirumalagiri',
		'IN04500' => 'Maredpalle',
		'IN04501' => 'Musheerabad',
		'IN04502' => 'Amberpet',
		'IN04503' => 'Himayathnagar',
		'IN04504' => 'Nampally',
		'IN04505' => 'Khairatabad',
		'IN04506' => 'Asifnagar',
		'IN04507' => 'Golconda',
		'IN04508' => 'Bahadurpura',
		'IN04509' => 'Bandlaguda',
		'IN04510' => 'Charminar',
		'IN04511' => 'Saidabad',
		'IN04512' => 'Marpalle',
		'IN04513' => 'Mominpet',
		'IN04514' => 'Nawabpet',
		'IN04515' => 'Shankarpalle',
		'IN04516' => 'Serilingampally',
		'IN04517' => 'Balanagar',
		'IN04518' => 'Qutubullapur',
		'IN04519' => 'Medchal',
		'IN04520' => 'Shamirpet',
		'IN04521' => 'Malkajgiri',
		'IN04522' => 'Keesara',
		'IN04523' => 'Ghatkesar',
		'IN04524' => 'Uppal',
		'IN04525' => 'Hayathnagar',
		'IN04526' => 'Saroornagar',
		'IN04527' => 'Rajendranagar',
		'IN04528' => 'Moinabad',
		'IN04529' => 'Chevella',
		'IN04530' => 'Vicarabad',
		'IN04531' => 'Dharur',
		'IN04532' => 'Bantwaram',
		'IN04533' => 'Peddemul',
		'IN04534' => 'Tandur',
		'IN04535' => 'Basheerabad',
		'IN04536' => 'Yelal',
		'IN04537' => 'Doma',
		'IN04538' => 'Gandeed',
		'IN04539' => 'Kulkacharla',
		'IN04540' => 'Pargi',
		'IN04541' => 'Pudur',
		'IN04542' => 'Shabad',
		'IN04543' => 'Shamshabad',
		'IN04544' => 'Maheswaram',
		'IN04545' => 'Kandukur',
		'IN04546' => 'Ibrahimpatnam',
		'IN04547' => 'Manchal',
		'IN04548' => 'Yacharam',
		'IN04549' => 'Kodangal',
		'IN04550' => 'Bomraspet',
		'IN04551' => 'Kosgi',
		'IN04552' => 'Doulathabad',
		'IN04553' => 'Damaragidda',
		'IN04554' => 'Maddur',
		'IN04555' => 'Hanwada',
		'IN04556' => 'Nawabpet',
		'IN04557' => 'Balanagar',
		'IN04558' => 'Kondurg',
		'IN04559' => 'Farooqnagar',
		'IN04560' => 'Kothur',
		'IN04561' => 'Keshampet',
		'IN04562' => 'Talakondapalle',
		'IN04563' => 'Amangal',
		'IN04564' => 'Madgul',
		'IN04565' => 'Veldanda',
		'IN04566' => 'Midjil',
		'IN04567' => 'Jadcherla',
		'IN04568' => 'Mahbubnagar',
		'IN04569' => 'Koilkonda',
		'IN04570' => 'Narayanpet',
		'IN04571' => 'Utkoor',
		'IN04572' => 'Dhanwada',
		'IN04573' => 'Devarkadra',
		'IN04574' => 'Bhoothpur',
		'IN04575' => 'Thimmajipet',
		'IN04576' => 'Kalwakurthy',
		'IN04577' => 'Vangoor',
		'IN04578' => 'Amrabad',
		'IN04579' => 'Achampet',
		'IN04580' => 'Uppununthala',
		'IN04581' => 'Telkapalle',
		'IN04582' => 'Tadoor',
		'IN04583' => 'Nagarkurnool',
		'IN04584' => 'Bijinapalle',
		'IN04585' => 'Ghanpur',
		'IN04586' => 'Addakal',
		'IN04587' => 'Chinnachintakunta',
		'IN04588' => 'Narva',
		'IN04589' => 'Makthal',
		'IN04590' => 'Maganoor',
		'IN04591' => 'Dharur',
		'IN04592' => 'Atmakur',
		'IN04593' => 'Kothakota',
		'IN04594' => 'Peddamandadi',
		'IN04595' => 'Wanaparthy',
		'IN04596' => 'Gopalpeta',
		'IN04597' => 'Balmoor',
		'IN04598' => 'Lingal',
		'IN04599' => 'Peddakothapalle',
		'IN04600' => 'Kodair',
		'IN04601' => 'Pangal',
		'IN04602' => 'Pebbair',
		'IN04603' => 'Gadwal',
		'IN04604' => 'Maldakal',
		'IN04605' => 'Ghattu',
		'IN04606' => 'Ieej',
		'IN04607' => 'Itikyal',
		'IN04608' => 'Veepangandla',
		'IN04609' => 'Kollapur',
		'IN04610' => 'Waddepalle',
		'IN04611' => 'Manopad',
		'IN04612' => 'Alampur',
		'IN04613' => 'Bommalaramaram',
		'IN04614' => 'M.Turkapalle',
		'IN04615' => 'Rajapet',
		'IN04616' => 'Yadagirigutta',
		'IN04617' => 'Alair',
		'IN04618' => 'Gundala',
		'IN04619' => 'Thirumalgiri',
		'IN04620' => 'Thungathurthi',
		'IN04621' => 'Nuthankal',
		'IN04622' => 'Atmakur (S)',
		'IN04623' => 'Jaji Reddi Gudem',
		'IN04624' => 'Sali Gouraram',
		'IN04625' => 'Mothkur',
		'IN04626' => 'Atmakur (M)',
		'IN04627' => 'Valigonda',
		'IN04628' => 'Bhongir',
		'IN04629' => 'Bibinagar',
		'IN04630' => 'Pochampalle',
		'IN04631' => 'Choutuppal',
		'IN04632' => 'Ramannapeta',
		'IN04633' => 'Chityala',
		'IN04634' => 'Narketpalle',
		'IN04635' => 'Kattangoor',
		'IN04636' => 'Nakrekal',
		'IN04637' => 'Kethe Palle',
		'IN04638' => 'Suryapet',
		'IN04639' => 'Chivvemla',
		'IN04640' => 'Mothey',
		'IN04641' => 'Nadigudem',
		'IN04642' => 'Munagala',
		'IN04643' => 'Penpahad',
		'IN04644' => 'Vemulapalle',
		'IN04645' => 'Thipparthi',
		'IN04646' => 'Nalgonda',
		'IN04647' => 'Munugode',
		'IN04648' => 'Narayanapur',
		'IN04649' => 'Marriguda',
		'IN04650' => 'Chintha Palle',
		'IN04651' => 'Gundla Palle',
		'IN04652' => 'Chandam Pet',
		'IN04653' => 'Devarakonda',
		'IN04654' => 'Nampalle',
		'IN04655' => 'Chandur',
		'IN04656' => 'Kangal',
		'IN04657' => 'Gurrampode',
		'IN04658' => 'Pedda Adiserla Palle',
		'IN04659' => 'Peddavoora',
		'IN04660' => 'Anumula',
		'IN04661' => 'Nidamanur',
		'IN04662' => 'Thripuraram',
		'IN04663' => 'Dameracherla',
		'IN04664' => 'Miryalaguda',
		'IN04665' => 'Neredcherla',
		'IN04666' => 'Garide Palle',
		'IN04667' => 'Chilkur',
		'IN04668' => 'Kodad',
		'IN04669' => 'Huzurnagar',
		'IN04670' => 'Mattam Palle',
		'IN04671' => 'Mella Cheruvu',
		'IN04672' => 'Cherial',
		'IN04673' => 'Maddur',
		'IN04674' => 'Bachannapet',
		'IN04675' => 'Narmetta',
		'IN04676' => 'Ghanpur (Station)',
		'IN04677' => 'Dharmasagar',
		'IN04678' => 'Hasanparthy',
		'IN04679' => 'Parkal',
		'IN04680' => 'Mogullapalle',
		'IN04681' => 'Chityal',
		'IN04682' => 'Bhupalpalle',
		'IN04683' => 'Ghanpur (Mulug)',
		'IN04684' => 'Venkatapur',
		'IN04685' => 'Eturnagaram',
		'IN04686' => 'Mangapet',
		'IN04687' => 'Tadvai',
		'IN04688' => 'Govindaraopet',
		'IN04689' => 'Mulug',
		'IN04690' => 'Regonda',
		'IN04691' => 'Shayampet',
		'IN04692' => 'Nallabelly',
		'IN04693' => 'Duggondi',
		'IN04694' => 'Atmakur',
		'IN04695' => 'Hanamkonda',
		'IN04696' => 'Zaffergadh',
		'IN04697' => 'Palakurthi',
		'IN04698' => 'Raghunathpalle',
		'IN04699' => 'Jangaon',
		'IN04700' => 'Lingalaghanpur',
		'IN04701' => 'Devaruppula',
		'IN04702' => 'Kodakandla',
		'IN04703' => 'Raiparthy',
		'IN04704' => 'Wardhannapet',
		'IN04705' => 'Sangam',
		'IN04706' => 'Warangal',
		'IN04707' => 'Geesugonda',
		'IN04708' => 'Narsampet',
		'IN04709' => 'Khanapur',
		'IN04710' => 'Kothagudem',
		'IN04711' => 'Gudur',
		'IN04712' => 'Chennaraopet',
		'IN04713' => 'Nekkonda',
		'IN04714' => 'Parvathagiri',
		'IN04715' => 'Thorrur',
		'IN04716' => 'Nellikudur',
		'IN04717' => 'Kesamudram',
		'IN04718' => 'Mahabubabad',
		'IN04719' => 'Narsimhulapet',
		'IN04720' => 'Maripeda',
		'IN04721' => 'Kuravi',
		'IN04722' => 'Dornakal',
		'IN04723' => 'Wazeed',
		'IN04724' => 'Venkatapuram',
		'IN04725' => 'Pinapaka',
		'IN04726' => 'Cherla',
		'IN04727' => 'Manuguru',
		'IN04728' => 'Aswapuram',
		'IN04729' => 'Dummugudem',
		'IN04730' => 'Bhadrachalam',
		'IN04731' => 'Kunavaram',
		'IN04732' => 'Chintur',
		'IN04733' => 'Vararamachandrapuram',
		'IN04734' => 'Velairpadu',
		'IN04735' => 'Kukunoor',
		'IN04736' => 'Burgampahad',
		'IN04737' => 'Palwancha',
		'IN04738' => 'Kothagudem',
		'IN04739' => 'Tekulapalle',
		'IN04740' => 'Yellandu',
		'IN04741' => 'Gundala',
		'IN04742' => 'Bayyaram',
		'IN04743' => 'Garla',
		'IN04744' => 'Singareni',
		'IN04745' => 'Kamepalle',
		'IN04746' => 'Julurpad',
		'IN04747' => 'Chandrugonda',
		'IN04748' => 'Mulkalapalle',
		'IN04749' => 'Aswaraopeta',
		'IN04750' => 'Dammapeta',
		'IN04751' => 'Sathupalle',
		'IN04752' => 'Penuballi',
		'IN04753' => 'Enkuru',
		'IN04754' => 'Thirumalayapalem',
		'IN04755' => 'Kusumanchi',
		'IN04756' => 'Khammam (Rural)',
		'IN04757' => 'Khammam (Urban)',
		'IN04758' => 'Mudigonda',
		'IN04759' => 'Nelakondapalle',
		'IN04760' => 'Chinthakani',
		'IN04761' => 'Konijerla',
		'IN04762' => 'Tallada',
		'IN04763' => 'Kallur',
		'IN04764' => 'Wyra',
		'IN04765' => 'Bonakal',
		'IN04766' => 'Madhira',
		'IN04767' => 'Yerrupalem',
		'IN04768' => 'Vemsoor',
		'IN04769' => 'Veeraghattam',
		'IN04770' => 'Seethampeta',
		'IN04771' => 'Bhamini',
		'IN04772' => 'Kothuru',
		'IN04773' => 'Pathapatnam',
		'IN04774' => 'Meliaputti',
		'IN04775' => 'Palasa',
		'IN04776' => 'Mandasa',
		'IN04777' => 'Kanchili',
		'IN04778' => 'Ichchapuram',
		'IN04779' => 'Kaviti',
		'IN04780' => 'Sompeta',
		'IN04781' => 'Vajrapukothuru',
		'IN04782' => 'Nandigam',
		'IN04783' => 'Hiramandalam',
		'IN04784' => 'Palakonda',
		'IN04785' => 'Vangara',
		'IN04786' => 'Regidi Amadalavalasa',
		'IN04787' => 'Lakshminarsupeta',
		'IN04788' => 'Saravakota',
		'IN04789' => 'Tekkali',
		'IN04790' => 'Santhabommali',
		'IN04791' => 'Kotabommali',
		'IN04792' => 'Jalumuru',
		'IN04793' => 'Sarubujjili',
		'IN04794' => 'Burja',
		'IN04795' => 'Santhakaviti',
		'IN04796' => 'Rajam',
		'IN04797' => 'Ganguvarisigadam',
		'IN04798' => 'Amadalavalasa',
		'IN04799' => 'Narasannapeta',
		'IN04800' => 'Polaki',
		'IN04801' => 'Gara',
		'IN04802' => 'Srikakulam',
		'IN04803' => 'Ponduru',
		'IN04804' => 'Laveru',
		'IN04805' => 'Ranastalam',
		'IN04806' => 'Etcherla',
		'IN04807' => 'Komarada',
		'IN04808' => 'Gummalakshmipuram',
		'IN04809' => 'Kurupam',
		'IN04810' => 'Jiyyammavalasa',
		'IN04811' => 'Garugubilli',
		'IN04812' => 'Parvathipuram',
		'IN04813' => 'Makkuva',
		'IN04814' => 'Seethanagaram',
		'IN04815' => 'Balijipeta',
		'IN04816' => 'Bobbili',
		'IN04817' => 'Salur',
		'IN04818' => 'Pachipenta',
		'IN04819' => 'Ramabhadrapuram',
		'IN04820' => 'Badangi',
		'IN04821' => 'Therlam',
		'IN04822' => 'Merakamudidam',
		'IN04823' => 'Dattirajeru',
		'IN04824' => 'Mentada',
		'IN04825' => 'Gajapathinagaram',
		'IN04826' => 'Garividi',
		'IN04827' => 'Cheepurupalle',
		'IN04828' => 'Gurla',
		'IN04829' => 'Bondapalle',
		'IN04830' => 'Gantyada',
		'IN04831' => 'Srungavarapukota',
		'IN04832' => 'Vepada',
		'IN04833' => 'Lakkavarapukota',
		'IN04834' => 'Kothavalasa',
		'IN04835' => 'Jami',
		'IN04836' => 'Vizianagaram',
		'IN04837' => 'Nellimarla',
		'IN04838' => 'Pusapatirega',
		'IN04839' => 'Denkada',
		'IN04840' => 'Bhogapuram',
		'IN04841' => 'Munchingi Puttu',
		'IN04842' => 'Peda Bayalu',
		'IN04843' => 'Dumbriguda',
		'IN04844' => 'Araku Valley',
		'IN04845' => 'Ananthagiri',
		'IN04846' => 'Hukumpeta',
		'IN04847' => 'Paderu',
		'IN04848' => 'G.Madugula',
		'IN04849' => 'Chintapalle',
		'IN04850' => 'Gudem Kotha Veedhi',
		'IN04851' => 'Koyyuru',
		'IN04852' => 'Nathavaram',
		'IN04853' => 'Golugonda',
		'IN04854' => 'Narsipatnam',
		'IN04855' => 'Rolugunta',
		'IN04856' => 'Ravikamatham',
		'IN04857' => 'Madugula',
		'IN04858' => 'Cheedikada',
		'IN04859' => 'Devarapalle',
		'IN04860' => 'K.Kotapadu',
		'IN04861' => 'Sabbavaram',
		'IN04862' => 'Pendurthi',
		'IN04863' => 'Anandapuram',
		'IN04864' => 'Padmanabham',
		'IN04865' => 'Bheemunipatnam',
		'IN04866' => 'Visakhapatnam (Rural)',
		'IN04867' => 'Visakhapatnam (Urban)',
		'IN04868' => 'Pedagantyada',
		'IN04869' => 'Gajuwaka',
		'IN04870' => 'Paravada',
		'IN04871' => 'Anakapalle',
		'IN04872' => 'Chodavaram',
		'IN04873' => 'Butchayyapeta',
		'IN04874' => 'Kotauratla',
		'IN04875' => 'Makavarapalem',
		'IN04876' => 'Kasimkota',
		'IN04877' => 'Munagapaka',
		'IN04878' => 'Atchutapuram',
		'IN04879' => 'Yelamanchili',
		'IN04880' => 'Nakkapalle',
		'IN04881' => 'Payakaraopeta',
		'IN04882' => 'S.Rayavaram',
		'IN04883' => 'Rambilli',
		'IN04884' => 'Maredumilli',
		'IN04885' => 'Devipatnam',
		'IN04886' => 'Y. Ramavaram',
		'IN04887' => 'Addateegala',
		'IN04888' => 'Rajavommangi',
		'IN04889' => 'Kotananduru',
		'IN04890' => 'Tuni',
		'IN04891' => 'Rowthulapudi',
		'IN04892' => 'Sankhavaram',
		'IN04893' => 'Yeleswaram',
		'IN04894' => 'Gangavaram',
		'IN04895' => 'Rampachodavaram',
		'IN04896' => 'Seethanagaram',
		'IN04897' => 'Gokavaram',
		'IN04898' => 'Jaggampeta',
		'IN04899' => 'Kirlampudi',
		'IN04900' => 'Prathipadu',
		'IN04901' => 'Thondangi',
		'IN04902' => 'Gollaprolu',
		'IN04903' => 'Peddapuram',
		'IN04904' => 'Gandepalle',
		'IN04905' => 'Korukonda',
		'IN04906' => 'Rajahmundry (Urban)',
		'IN04907' => 'Rajahmundry Rural',
		'IN04908' => 'Rajanagaram',
		'IN04909' => 'Rangampeta',
		'IN04910' => 'Samalkota',
		'IN04911' => 'Pithapuram',
		'IN04912' => 'Kothapalle',
		'IN04913' => 'Kakinada (Rural)',
		'IN04914' => 'Kakinada (Urban)',
		'IN04915' => 'Pedapudi',
		'IN04916' => 'Biccavolu',
		'IN04917' => 'Anaparthy',
		'IN04918' => 'Kadiam',
		'IN04919' => 'Atreyapuram',
		'IN04920' => 'Mandapeta',
		'IN04921' => 'Rayavaram',
		'IN04922' => 'Karapa',
		'IN04923' => 'Kajuluru',
		'IN04924' => 'Ramachandrapuram',
		'IN04925' => 'Alamuru',
		'IN04926' => 'Ravulapalem',
		'IN04927' => 'Kothapeta',
		'IN04928' => 'Kapileswarapuram',
		'IN04929' => 'Pamarru',
		'IN04930' => 'Thallarevu',
		'IN04931' => 'I. Polavaram',
		'IN04932' => 'Mummidivaram',
		'IN04933' => 'Ainavilli',
		'IN04934' => 'P.Gannavaram',
		'IN04935' => 'Ambajipeta',
		'IN04936' => 'Mamidikuduru',
		'IN04937' => 'Razole',
		'IN04938' => 'Malikipuram',
		'IN04939' => 'Sakhinetipalle',
		'IN04940' => 'Allavaram',
		'IN04941' => 'Amalapuram',
		'IN04942' => 'Uppalaguptam',
		'IN04943' => 'Katrenikona',
		'IN04944' => 'Chintalapudi',
		'IN04945' => 'Lingapalem',
		'IN04946' => 'T.Narasapuram',
		'IN04947' => 'Jeelugu Milli',
		'IN04948' => 'Buttayagudem',
		'IN04949' => 'Polavaram',
		'IN04950' => 'Tallapudi',
		'IN04951' => 'Gopalapuram',
		'IN04952' => 'Koyyalagudem',
		'IN04953' => 'Jangareddigudem',
		'IN04954' => 'Kamavarapukota',
		'IN04955' => 'Dwarakatirumala',
		'IN04956' => 'Nallajerla',
		'IN04957' => 'Devarapalle',
		'IN04958' => 'Kovvur',
		'IN04959' => 'Chagallu',
		'IN04960' => 'Nidadavole',
		'IN04961' => 'Tadepalligudem',
		'IN04962' => 'Unguturu',
		'IN04963' => 'Bhimadole',
		'IN04964' => 'Pedavegi',
		'IN04965' => 'Pedapadu',
		'IN04966' => 'Eluru',
		'IN04967' => 'Denduluru',
		'IN04968' => 'Nidamarru',
		'IN04969' => 'Pentapadu',
		'IN04970' => 'Undrajavaram',
		'IN04971' => 'Peravali',
		'IN04972' => 'Tanuku',
		'IN04973' => 'Attili',
		'IN04974' => 'Ganapavaram',
		'IN04975' => 'Akividu',
		'IN04976' => 'Undi',
		'IN04977' => 'Palacoderu',
		'IN04978' => 'Penumantra',
		'IN04979' => 'Iragavaram',
		'IN04980' => 'Penugonda',
		'IN04981' => 'Achanta',
		'IN04982' => 'Poduru',
		'IN04983' => 'Veeravasaram',
		'IN04984' => 'Bhimavaram',
		'IN04985' => 'Kalla',
		'IN04986' => 'Mogalthur',
		'IN04987' => 'Narasapuram',
		'IN04988' => 'Palacole',
		'IN04989' => 'Yelamanchili',
		'IN04990' => 'Vatsavai',
		'IN04991' => 'Jaggayyapeta',
		'IN04992' => 'Penuganchiprolu',
		'IN04993' => 'Nandigama',
		'IN04994' => 'Veerullapadu',
		'IN04995' => 'Mylavaram',
		'IN04996' => 'Gampalagudem',
		'IN04997' => 'Tiruvuru',
		'IN04998' => 'A.Konduru',
		'IN04999' => 'Reddigudem',
		'IN05000' => 'Vissannapet',
		'IN05001' => 'Chatrai',
		'IN05002' => 'Musunuru',
		'IN05003' => 'Nuzvid',
		'IN05004' => 'Bapulapadu',
		'IN05005' => 'Agiripalle',
		'IN05006' => 'G.Konduru',
		'IN05007' => 'Kanchikacherla',
		'IN05008' => 'Chandarlapadu',
		'IN05009' => 'Ibrahimpatnam',
		'IN05010' => 'Vijayawada (Urban)',
		'IN05011' => 'Vijayawada (Rural)',
		'IN05012' => 'Gannavaram',
		'IN05013' => 'Unguturu',
		'IN05014' => 'Nandivada',
		'IN05015' => 'Mandavalli',
		'IN05016' => 'Kaikalur',
		'IN05017' => 'Kalidindi',
		'IN05018' => 'Kruthivennu',
		'IN05019' => 'Bantumilli',
		'IN05020' => 'Mudinepalle',
		'IN05021' => 'Gudivada',
		'IN05022' => 'Pedaparupudi',
		'IN05023' => 'Kankipadu',
		'IN05024' => 'Penamaluru',
		'IN05025' => 'Thotlavalluru',
		'IN05026' => 'Pamidimukkala',
		'IN05027' => 'Vuyyuru',
		'IN05028' => 'Pamarru',
		'IN05029' => 'Gudlavalleru',
		'IN05030' => 'Pedana',
		'IN05031' => 'Guduru',
		'IN05032' => 'Movva',
		'IN05033' => 'Ghantasala',
		'IN05034' => 'Machilipatnam',
		'IN05035' => 'Challapalle',
		'IN05036' => 'Mopidevi',
		'IN05037' => 'Avanigadda',
		'IN05038' => 'Nagayalanka',
		'IN05039' => 'Koduru',
		'IN05040' => 'Macherla',
		'IN05041' => 'Veldurthi',
		'IN05042' => 'Durgi',
		'IN05043' => 'Rentachintala',
		'IN05044' => 'Gurazala',
		'IN05045' => 'Dachepalle',
		'IN05046' => 'Karempudi',
		'IN05047' => 'Piduguralla',
		'IN05048' => 'Machavaram',
		'IN05049' => 'Bellamkonda',
		'IN05050' => 'Atchampet',
		'IN05051' => 'Krosuru',
		'IN05052' => 'Amaravathi',
		'IN05053' => 'Thullur',
		'IN05054' => 'Tadepalle',
		'IN05055' => 'Mangalagiri',
		'IN05056' => 'Tadikonda',
		'IN05057' => 'Pedakurapadu',
		'IN05058' => 'Sattenapalle',
		'IN05059' => 'Rajupalem',
		'IN05060' => 'Nekarikallu',
		'IN05061' => 'Bollapalle',
		'IN05062' => 'Vinukonda',
		'IN05063' => 'Nuzendla',
		'IN05064' => 'Savalyapuram H/O Kanamarlapudi',
		'IN05065' => 'Ipur',
		'IN05066' => 'Rompicherla',
		'IN05067' => 'Narasaraopet',
		'IN05068' => 'Muppalla',
		'IN05069' => 'Nadendla',
		'IN05070' => 'Chilakaluripet  H/O.Purushotha Patnam',
		'IN05071' => 'Edlapadu',
		'IN05072' => 'Phirangipuram',
		'IN05073' => 'Medikonduru',
		'IN05074' => 'Guntur',
		'IN05075' => 'Pedakakani',
		'IN05076' => 'Duggirala',
		'IN05077' => 'Kollipara',
		'IN05078' => 'Tenali',
		'IN05079' => 'Chebrolu',
		'IN05080' => 'Vatticherukuru',
		'IN05081' => 'Prathipadu',
		'IN05082' => 'Pedanandipadu',
		'IN05083' => 'Kakumanu',
		'IN05084' => 'Ponnur',
		'IN05085' => 'Tsundur',
		'IN05086' => 'Amruthalur',
		'IN05087' => 'Vemuru',
		'IN05088' => 'Kollur',
		'IN05089' => 'Bhattiprolu',
		'IN05090' => 'Cherukupalle H/O Arumbaka',
		'IN05091' => 'Pittalavanipalem',
		'IN05092' => 'Karlapalem',
		'IN05093' => 'Bapatla',
		'IN05094' => 'Nizampatnam',
		'IN05095' => 'Nagaram',
		'IN05096' => 'Repalle',
		'IN05097' => 'Yerragondapalem',
		'IN05098' => 'Pullalacheruvu',
		'IN05099' => 'Tripuranthakam',
		'IN05100' => 'Dornala',
		'IN05101' => 'Peda  Araveedu',
		'IN05102' => 'Donakonda',
		'IN05103' => 'Kurichedu',
		'IN05104' => 'Santhamaguluru',
		'IN05105' => 'Ballikurava',
		'IN05106' => 'Martur',
		'IN05107' => 'Yeddana Pudi',
		'IN05108' => 'Parchur',
		'IN05109' => 'Karamchedu',
		'IN05110' => 'Inkollu',
		'IN05111' => 'Janakavarampanguluru',
		'IN05112' => 'Addanki',
		'IN05113' => 'Mundlamuru',
		'IN05114' => 'Darsi',
		'IN05115' => 'Markapur',
		'IN05116' => 'Ardhaveedu',
		'IN05117' => 'Cumbum',
		'IN05118' => 'Tarlupadu',
		'IN05119' => 'Konakanamitla',
		'IN05120' => 'Podili',
		'IN05121' => 'Thallur',
		'IN05122' => 'Korisapadu',
		'IN05123' => 'Chirala',
		'IN05124' => 'Vetapalem',
		'IN05125' => 'Chinaganjam',
		'IN05126' => 'Naguluppala Padu',
		'IN05127' => 'Maddipadu',
		'IN05128' => 'Chimakurthi',
		'IN05129' => 'Marripudi',
		'IN05130' => 'Hanumanthuni Padu',
		'IN05131' => 'Bestawaripeta',
		'IN05132' => 'Racherla',
		'IN05133' => 'Giddalur',
		'IN05134' => 'Komarolu',
		'IN05135' => 'Veligandla',
		'IN05136' => 'Kanigiri',
		'IN05137' => 'Kondapi',
		'IN05138' => 'Santhanuthala Padu',
		'IN05139' => 'Ongole',
		'IN05140' => 'Kotha Patnam',
		'IN05141' => 'Tangutur',
		'IN05142' => 'Zarugumilli',
		'IN05143' => 'Ponnaluru',
		'IN05144' => 'Pedacherlo Palle',
		'IN05145' => 'Chandra Sekhara Puram',
		'IN05146' => 'Pamur',
		'IN05147' => 'Voletivaripalem',
		'IN05148' => 'Kandukur',
		'IN05149' => 'Singarayakonda',
		'IN05150' => 'Lingasamudram',
		'IN05151' => 'Gudluru',
		'IN05152' => 'Ulavapadu',
		'IN05153' => 'Seetharamapuram',
		'IN05154' => 'Udayagiri',
		'IN05155' => 'Varikuntapadu',
		'IN05156' => 'Kondapuram',
		'IN05157' => 'Jaladanki',
		'IN05158' => 'Kavali',
		'IN05159' => 'Bogole',
		'IN05160' => 'Kaligiri',
		'IN05161' => 'Vinjamur',
		'IN05162' => 'Duttalur',
		'IN05163' => 'Marripadu',
		'IN05164' => 'Atmakur',
		'IN05165' => 'Anumasamudrampeta',
		'IN05166' => 'Dagadarthi',
		'IN05167' => 'Allur',
		'IN05168' => 'Vidavalur',
		'IN05169' => 'Kodavalur',
		'IN05170' => 'Buchireddipalem',
		'IN05171' => 'Sangam',
		'IN05172' => 'Chejerla',
		'IN05173' => 'Ananthasagaram',
		'IN05174' => 'Kaluvoya',
		'IN05175' => 'Rapur',
		'IN05176' => 'Podalakur',
		'IN05177' => 'Nellore',
		'IN05178' => 'Kovur',
		'IN05179' => 'Indukurpet',
		'IN05180' => 'Thotapalligudur',
		'IN05181' => 'Muthukur',
		'IN05182' => 'Venkatachalam',
		'IN05183' => 'Manubolu',
		'IN05184' => 'Gudur',
		'IN05185' => 'Sydapuram',
		'IN05186' => 'Dakkili',
		'IN05187' => 'Venkatagiri',
		'IN05188' => 'Balayapalle',
		'IN05189' => 'Ojili',
		'IN05190' => 'Chillakur',
		'IN05191' => 'Kota',
		'IN05192' => 'Vakadu',
		'IN05193' => 'Chittamur',
		'IN05194' => 'Naidupet',
		'IN05195' => 'Pellakur',
		'IN05196' => 'Doravarisatram',
		'IN05197' => 'Sullurpeta',
		'IN05198' => 'Tada',
		'IN05199' => 'Kondapuram',
		'IN05200' => 'Mylavaram',
		'IN05201' => 'Peddamudium',
		'IN05202' => 'Rajupalem',
		'IN05203' => 'Duvvur',
		'IN05204' => 'S.Mydukur',
		'IN05205' => 'Brahmamgarimattam',
		'IN05206' => 'Sri Avadhutha Kasinayana',
		'IN05207' => 'Kalasapadu',
		'IN05208' => 'Porumamilla',
		'IN05209' => 'B.Kodur',
		'IN05210' => 'Badvel',
		'IN05211' => 'Gopavaram',
		'IN05212' => 'Khajipet',
		'IN05213' => 'Chapad',
		'IN05214' => 'Proddatur',
		'IN05215' => 'Jammalamadugu',
		'IN05216' => 'Muddanur',
		'IN05217' => 'Simhadripuram',
		'IN05218' => 'Lingala',
		'IN05219' => 'Pulivendla',
		'IN05220' => 'Vemula',
		'IN05221' => 'Thondur',
		'IN05222' => 'Veerapunayunipalle',
		'IN05223' => 'Yerraguntla',
		'IN05224' => 'Kamalapuram',
		'IN05225' => 'Vallur',
		'IN05226' => 'Chennur',
		'IN05227' => 'Atlur',
		'IN05228' => 'Vontimitta',
		'IN05229' => 'Sidhout',
		'IN05230' => 'Kadapa',
		'IN05231' => 'Chinthakommadinne',
		'IN05232' => 'Pendlimarri',
		'IN05233' => 'Vempalle',
		'IN05234' => 'Chakrayapet',
		'IN05235' => 'Galiveedu',
		'IN05236' => 'Chinnamandem',
		'IN05237' => 'Sambepalle',
		'IN05238' => 'T Sundupalle',
		'IN05239' => 'Rayachoti',
		'IN05240' => 'Lakkireddipalle',
		'IN05241' => 'Ramapuram',
		'IN05242' => 'Veeraballe',
		'IN05243' => 'Nandalur',
		'IN05244' => 'Penagalur',
		'IN05245' => 'Chitvel',
		'IN05246' => 'Rajampet',
		'IN05247' => 'Pullampeta',
		'IN05248' => 'Obulavaripalle',
		'IN05249' => 'Kodur',
		'IN05250' => 'Mantralayam',
		'IN05251' => 'Kosigi',
		'IN05252' => 'Kowthalam',
		'IN05253' => 'Pedda Kadubur',
		'IN05254' => 'Yemmiganur',
		'IN05255' => 'Nandavaram',
		'IN05256' => 'C.Belagal',
		'IN05257' => 'Gudur',
		'IN05258' => 'Kallur',
		'IN05259' => 'Kurnool',
		'IN05260' => 'Nandikotkur',
		'IN05261' => 'Pagidyala',
		'IN05262' => 'Jupadu Bungalow',
		'IN05263' => 'Kothapalle',
		'IN05264' => 'Srisailam',
		'IN05265' => 'Atmakur',
		'IN05266' => 'Pamulapadu',
		'IN05267' => 'Midthur',
		'IN05268' => 'Orvakal',
		'IN05269' => 'Kodumur',
		'IN05270' => 'Gonegandla',
		'IN05271' => 'Adoni',
		'IN05272' => 'Holagunda',
		'IN05273' => 'Halaharvi',
		'IN05274' => 'Alur',
		'IN05275' => 'Aspari',
		'IN05276' => 'Devanakonda',
		'IN05277' => 'Krishnagiri',
		'IN05278' => 'Veldurthi',
		'IN05279' => 'Bethamcherla',
		'IN05280' => 'Panyam',
		'IN05281' => 'Gadivemula',
		'IN05282' => 'Velgode',
		'IN05283' => 'Bandi Atmakur',
		'IN05284' => 'Nandyal',
		'IN05285' => 'Mahanandi',
		'IN05286' => 'Sirvel',
		'IN05287' => 'Gospadu',
		'IN05288' => 'Banaganapalle',
		'IN05289' => 'Dhone',
		'IN05290' => 'Pattikonda',
		'IN05291' => 'Chippagiri',
		'IN05292' => 'Maddikera (East)',
		'IN05293' => 'Tuggali',
		'IN05294' => 'Peapally',
		'IN05295' => 'Owk',
		'IN05296' => 'Koilkuntla',
		'IN05297' => 'Rudravaram',
		'IN05298' => 'Allagadda',
		'IN05299' => 'Dornipadu',
		'IN05300' => 'Sanjamala',
		'IN05301' => 'Kolimigundla',
		'IN05302' => 'Uyyalawada',
		'IN05303' => 'Chagalamarri',
		'IN05304' => 'D.Hirehal',
		'IN05305' => 'Rayadurg',
		'IN05306' => 'Kanekal',
		'IN05307' => 'Bommanahal',
		'IN05308' => 'Vidapanakal',
		'IN05309' => 'Guntakal',
		'IN05310' => 'Gooty',
		'IN05311' => 'Peddavadugur',
		'IN05312' => 'Yadiki',
		'IN05313' => 'Tadpatri',
		'IN05314' => 'Peddapappur',
		'IN05315' => 'Pamidi',
		'IN05316' => 'Vajrakarur',
		'IN05317' => 'Uravakonda',
		'IN05318' => 'Beluguppa',
		'IN05319' => 'Gummagatta',
		'IN05320' => 'Brahmasamudram',
		'IN05321' => 'Kalyandurg',
		'IN05322' => 'Atmakur',
		'IN05323' => 'Kudair',
		'IN05324' => 'Garladinne',
		'IN05325' => 'Singanamala',
		'IN05326' => 'Putlur',
		'IN05327' => 'Yellanur',
		'IN05328' => 'Narpala',
		'IN05329' => 'Bukkaraya Samudram',
		'IN05330' => 'Anantapur',
		'IN05331' => 'Raptadu',
		'IN05332' => 'Settur',
		'IN05333' => 'Kundurpi',
		'IN05334' => 'Kambadur',
		'IN05335' => 'Kanaganapalle',
		'IN05336' => 'Dharmavaram',
		'IN05337' => 'Bathalapalle',
		'IN05338' => 'Tadimarri',
		'IN05339' => 'Mudigubba',
		'IN05340' => 'Talupula',
		'IN05341' => 'Nambulipulikunta',
		'IN05342' => 'Gandlapenta',
		'IN05343' => 'Kadiri',
		'IN05344' => 'Nallamada',
		'IN05345' => 'Bukkapatnam',
		'IN05346' => 'Kothacheruvu',
		'IN05347' => 'Chennekothapalle',
		'IN05348' => 'Ramagiri',
		'IN05349' => 'Roddam',
		'IN05350' => 'Madakasira',
		'IN05351' => 'Amarapuram',
		'IN05352' => 'Gudibanda',
		'IN05353' => 'Rolla',
		'IN05354' => 'Agali',
		'IN05355' => 'Parigi',
		'IN05356' => 'Penukonda',
		'IN05357' => 'Puttaparthi',
		'IN05358' => 'Obuladevaracheruvu',
		'IN05359' => 'Nallacheruvu',
		'IN05360' => 'Tanakal',
		'IN05361' => 'Amadagur',
		'IN05362' => 'Gorantla',
		'IN05363' => 'Somandepalle',
		'IN05364' => 'Hindupur',
		'IN05365' => 'Lepakshi',
		'IN05366' => 'Chilamathur',
		'IN05367' => 'Mulakalacheruvu',
		'IN05368' => 'Thamballapalle',
		'IN05369' => 'Peddamandyam',
		'IN05370' => 'Gurramkonda',
		'IN05371' => 'Kalakada',
		'IN05372' => 'Kambhamvaripalle',
		'IN05373' => 'Rompicherla',
		'IN05374' => 'Yerravaripalem',
		'IN05375' => 'Tirupati (Rural)',
		'IN05376' => 'Renigunta',
		'IN05377' => 'Yerpedu',
		'IN05378' => 'Srikalahasti',
		'IN05379' => 'Thottambedu',
		'IN05380' => 'Buchinaidu Kandriga',
		'IN05381' => 'Varadaiahpalem',
		'IN05382' => 'K.V.B.Puram',
		'IN05383' => 'Tirupati (Urban)',
		'IN05384' => 'Chandragiri',
		'IN05385' => 'Chinnagottigallu',
		'IN05386' => 'Pileru',
		'IN05387' => 'Kalikiri',
		'IN05388' => 'Valmikipuram',
		'IN05389' => 'Kurabalakota',
		'IN05390' => 'Pedda Thippasamudram',
		'IN05391' => 'B.Kothakota',
		'IN05392' => 'Madanapalle',
		'IN05393' => 'Nimmanapalle',
		'IN05394' => 'Sodam',
		'IN05395' => 'Pulicherla',
		'IN05396' => 'Pakala',
		'IN05397' => 'Vedurukuppam',
		'IN05398' => 'Ramachandrapuram',
		'IN05399' => 'Vadamalapeta',
		'IN05400' => 'Narayanavanam',
		'IN05401' => 'Pichatur',
		'IN05402' => 'Satyavedu',
		'IN05403' => 'Nagalapuram',
		'IN05404' => 'Nindra',
		'IN05405' => 'Vijayapuram',
		'IN05406' => 'Nagari',
		'IN05407' => 'Puttur',
		'IN05408' => 'Karvetinagar',
		'IN05409' => 'Penumuru',
		'IN05410' => 'Puthalapattu',
		'IN05411' => 'Irala',
		'IN05412' => 'Somala',
		'IN05413' => 'Chowdepalle',
		'IN05414' => 'Ramasamudram',
		'IN05415' => 'Punganur',
		'IN05416' => 'Peddapanjani',
		'IN05417' => 'Gangavaram',
		'IN05418' => 'Thavanampalle',
		'IN05419' => 'Srirangarajapuram',
		'IN05420' => 'Gangadhara Nellore',
		'IN05421' => 'Chittoor',
		'IN05422' => 'Palamaner',
		'IN05423' => 'Baireddipalle',
		'IN05424' => 'Venkatagirikota',
		'IN05425' => 'Santhipuram',
		'IN05426' => 'Gudupalle',
		'IN05427' => 'Kuppam',
		'IN05428' => 'Ramakuppam',
		'IN05429' => 'Bangarupalem',
		'IN05430' => 'Yadamarri',
		'IN05431' => 'Gudipala',
		'IN05432' => 'Palasamudram',
	],
	'KA' => [
		'IN05433' => 'Chikodi',
		'IN05434' => 'Athni',
		'IN05435' => 'Raybag',
		'IN05436' => 'Gokak',
		'IN05437' => 'Hukeri',
		'IN05438' => 'Belgaum',
		'IN05439' => 'Khanapur',
		'IN05440' => 'Sampgaon',
		'IN05441' => 'Parasgad',
		'IN05442' => 'Ramdurg',
		'IN05443' => 'Jamkhandi',
		'IN05444' => 'Bilgi',
		'IN05445' => 'Mudhol',
		'IN05446' => 'Badami',
		'IN05447' => 'Bagalkot',
		'IN05448' => 'Hungund',
		'IN05449' => 'Bijapur',
		'IN05450' => 'Indi',
		'IN05451' => 'Sindgi',
		'IN05452' => 'Basavana Bagevadi',
		'IN05453' => 'Muddebihal',
		'IN05454' => 'Basavakalyan',
		'IN05455' => 'Bhalki',
		'IN05456' => 'Aurad',
		'IN05457' => 'Bidar',
		'IN05458' => 'Homnabad',
		'IN05459' => 'Lingsugur',
		'IN05460' => 'Devadurga',
		'IN05461' => 'Raichur',
		'IN05462' => 'Manvi',
		'IN05463' => 'Sindhnur',
		'IN05464' => 'Yelbarga',
		'IN05465' => 'Kushtagi',
		'IN05466' => 'Gangawati',
		'IN05467' => 'Koppal',
		'IN05468' => 'Nargund',
		'IN05469' => 'Ron',
		'IN05470' => 'Gadag',
		'IN05471' => 'Shirhatti',
		'IN05472' => 'Mundargi',
		'IN05473' => 'Dharwad',
		'IN05474' => 'Navalgund',
		'IN05475' => 'Hubli',
		'IN05476' => 'Kalghatgi',
		'IN05477' => 'Kundgol',
		'IN05478' => 'Karwar',
		'IN05479' => 'Supa',
		'IN05480' => 'Haliyal',
		'IN05481' => 'Yellapur',
		'IN05482' => 'Mundgod',
		'IN05483' => 'Sirsi',
		'IN05484' => 'Ankola',
		'IN05485' => 'Kumta',
		'IN05486' => 'Siddapur',
		'IN05487' => 'Honavar',
		'IN05488' => 'Bhatkal',
		'IN05489' => 'Shiggaon',
		'IN05490' => 'Savanur',
		'IN05491' => 'Hangal',
		'IN05492' => 'Haveri',
		'IN05493' => 'Byadgi',
		'IN05494' => 'Hirekerur',
		'IN05495' => 'Ranibennur',
		'IN05496' => 'Hadagalli',
		'IN05497' => 'Hagaribommanahalli',
		'IN05498' => 'Hospet',
		'IN05499' => 'Siruguppa',
		'IN05500' => 'Bellary',
		'IN05501' => 'Sandur',
		'IN05502' => 'Kudligi',
		'IN05503' => 'Molakalmuru',
		'IN05504' => 'Challakere',
		'IN05505' => 'Chitradurga',
		'IN05506' => 'Holalkere',
		'IN05507' => 'Hosdurga',
		'IN05508' => 'Hiriyur',
		'IN05509' => 'Harihar',
		'IN05510' => 'Harapanahalli',
		'IN05511' => 'Jagalur',
		'IN05512' => 'Davanagere',
		'IN05513' => 'Honnali',
		'IN05514' => 'Channagiri',
		'IN05515' => 'Sagar',
		'IN05516' => 'Sorab',
		'IN05517' => 'Shikarpur',
		'IN05518' => 'Hosanagara',
		'IN05519' => 'Tirthahalli',
		'IN05520' => 'Shimoga',
		'IN05521' => 'Bhadravati',
		'IN05522' => 'Kundapura',
		'IN05523' => 'Udupi',
		'IN05524' => 'Karkal',
		'IN05525' => 'Sringeri',
		'IN05526' => 'Koppa',
		'IN05527' => 'Narasimharajapura',
		'IN05528' => 'Tarikere',
		'IN05529' => 'Kadur',
		'IN05530' => 'Chikmagalur',
		'IN05531' => 'Mudigere',
		'IN05532' => 'Chiknayakanhalli',
		'IN05533' => 'Sira',
		'IN05534' => 'Pavagada',
		'IN05535' => 'Madhugiri',
		'IN05536' => 'Koratagere',
		'IN05537' => 'Tumkur',
		'IN05538' => 'Gubbi',
		'IN05539' => 'Tiptur',
		'IN05540' => 'Turuvekere',
		'IN05541' => 'Kunigal',
		'IN05542' => 'Bangalore North',
		'IN05543' => 'Bangalore South',
		'IN05544' => 'Bangalore East',
		'IN05545' => 'Anekal',
		'IN05546' => 'Krishnarajpet',
		'IN05547' => 'Nagamangala',
		'IN05548' => 'Pandavapura',
		'IN05549' => 'Shrirangapattana',
		'IN05550' => 'Mandya',
		'IN05551' => 'Maddur',
		'IN05552' => 'Malavalli',
		'IN05553' => 'Sakleshpur',
		'IN05554' => 'Belur',
		'IN05555' => 'Arsikere',
		'IN05556' => 'Hassan',
		'IN05557' => 'Alur',
		'IN05558' => 'Arkalgud',
		'IN05559' => 'Hole Narsipur',
		'IN05560' => 'Channarayapatna',
		'IN05561' => 'Mangalore',
		'IN05562' => 'Bantval',
		'IN05563' => 'Beltangadi',
		'IN05564' => 'Puttur',
		'IN05565' => 'Sulya',
		'IN05566' => 'Madikeri',
		'IN05567' => 'Somvarpet',
		'IN05568' => 'Virajpet',
		'IN05569' => 'Piriyapatna',
		'IN05570' => 'Hunsur',
		'IN05571' => 'Krishnarajanagara',
		'IN05572' => 'Mysore',
		'IN05573' => 'Heggadadevankote',
		'IN05574' => 'Nanjangud',
		'IN05575' => 'Tirumakudal - Narsipur',
		'IN05576' => 'Gundlupet',
		'IN05577' => 'Chamarajanagar',
		'IN05578' => 'Yelandur',
		'IN05579' => 'Kollegal',
		'IN05580' => 'Aland',
		'IN05581' => 'Afzalpur',
		'IN05582' => 'Gulbarga',
		'IN05583' => 'Chincholi',
		'IN05584' => 'Sedam',
		'IN05585' => 'Chitapur',
		'IN05586' => 'Jevargi',
		'IN05587' => 'Shorapur',
		'IN05588' => 'Shahpur',
		'IN05589' => 'Yadgir',
		'IN05590' => 'Srinivaspur',
		'IN05591' => 'Kolar',
		'IN05592' => 'Malur',
		'IN05593' => 'Bangarapet',
		'IN05594' => 'Mulbagal',
		'IN05595' => 'Gauribidanur',
		'IN05596' => 'Chikkaballapura',
		'IN05597' => 'Gudibanda',
		'IN05598' => 'Bagepalli',
		'IN05599' => 'Sidlaghatta',
		'IN05600' => 'Chintamani',
		'IN05601' => 'Nelamangala',
		'IN05602' => 'Dod Ballapur',
		'IN05603' => 'Devanahalli',
		'IN05604' => 'Hosakote',
		'IN05605' => 'Magadi',
		'IN05606' => 'Ramanagara',
		'IN05607' => 'Channapatna',
		'IN05608' => 'Kanakapura',
	],
	'GA' => [
		'IN05609' => 'Pernem',
		'IN05610' => 'Bardez',
		'IN05611' => 'Tiswadi',
		'IN05612' => 'Bicholim',
		'IN05613' => 'Satari',
		'IN05614' => 'Ponda',
		'IN05615' => 'Mormugao',
		'IN05616' => 'Salcete',
		'IN05617' => 'Quepem',
		'IN05618' => 'Sanguem',
		'IN05619' => 'Canacona',
	],
	'LD' => [
		'IN05620' => 'Amini',
		'IN05621' => 'Bitra',
		'IN05622' => 'Chetlat',
		'IN05623' => 'Kiltan',
		'IN05624' => 'Kadmat',
		'IN05625' => 'Kavaratti',
		'IN05626' => 'Agatti',
		'IN05627' => 'Andrott',
		'IN05628' => 'Kalpeni',
		'IN05629' => 'Minicoy',
		'IN05630' => 'Kasaragod',
		'IN05631' => 'Hosdurg',
	],
	'KL' => [
		'IN05632' => 'Taliparamba',
		'IN05633' => 'Kannur',
		'IN05634' => 'Thalassery',
		'IN05635' => 'Mananthavady',
		'IN05636' => 'Sulthanbathery',
		'IN05637' => 'Vythiri',
		'IN05638' => 'Vadakara',
		'IN05639' => 'Quilandy',
		'IN05640' => 'Kozhikode',
		'IN05641' => 'Ernad',
		'IN05642' => 'Nilambur',
		'IN05643' => 'Perinthalmanna',
		'IN05644' => 'Tirur',
		'IN05645' => 'Tirurangadi',
		'IN05646' => 'Ponnani',
		'IN05647' => 'Ottappalam',
		'IN05648' => 'Mannarkad',
		'IN05649' => 'Palakkad',
		'IN05650' => 'Chittur',
		'IN05651' => 'Alathur',
		'IN05652' => 'Talappilly',
		'IN05653' => 'Chavakkad',
		'IN05654' => 'Thrissur',
		'IN05655' => 'Kodungallur',
		'IN05656' => 'Mukundapuram',
		'IN05657' => 'Kunnathunad',
		'IN05658' => 'Aluva',
		'IN05659' => 'Paravur',
		'IN05660' => 'Kochi',
		'IN05661' => 'Kanayannur',
		'IN05662' => 'Muvattupuzha',
		'IN05663' => 'Kothamangalam',
		'IN05664' => 'Devikulam',
		'IN05665' => 'Udumbanchola',
		'IN05666' => 'Thodupuzha',
		'IN05667' => 'Peerumade',
		'IN05668' => 'Meenachil',
		'IN05669' => 'Vaikom',
		'IN05670' => 'Kottayam',
		'IN05671' => 'Changanassery',
		'IN05672' => 'Kanjirappally',
		'IN05673' => 'Cherthala',
		'IN05674' => 'Ambalappuzha',
		'IN05675' => 'Kuttanad',
		'IN05676' => 'Karthikappally',
		'IN05677' => 'Chengannur',
		'IN05678' => 'Mavelikkara',
		'IN05679' => 'Thiruvalla',
		'IN05680' => 'Mallappally',
		'IN05681' => 'Ranni',
		'IN05682' => 'Kozhenchery',
		'IN05683' => 'Adoor',
		'IN05684' => 'Karunagappally',
		'IN05685' => 'Kunnathur',
		'IN05686' => 'Pathanapuram',
		'IN05687' => 'Kottarakkara',
		'IN05688' => 'Kollam',
		'IN05689' => 'Chirayinkeezhu',
		'IN05690' => 'Nedumangad',
		'IN05691' => 'Thiruvananthapuram',
		'IN05692' => 'Neyyattinkara',
	],
	'TN' => [
		'IN05693' => 'Gummidipoondi',
		'IN05694' => 'Ponneri',
		'IN05695' => 'Uthukkottai',
		'IN05696' => 'Tiruttani',
		'IN05697' => 'Pallipattu',
		'IN05698' => 'Thiruvallur',
		'IN05699' => 'Poonamallee',
		'IN05700' => 'Ambattur',
		'IN05701' => 'Mathavaram',
		'IN05702' => 'Sriperumbudur',
		'IN05703' => 'Tambaram',
		'IN05704' => 'Alandur',
		'IN05705' => 'Sholinganallur',
		'IN05706' => 'Chengalpattu',
		'IN05707' => 'Kancheepuram',
		'IN05708' => 'Uthiramerur',
		'IN05709' => 'Tirukalukundram',
		'IN05710' => 'Maduranthakam',
		'IN05711' => 'Cheyyur',
		'IN05712' => 'Gudiyatham',
		'IN05713' => 'Katpadi',
		'IN05714' => 'Wallajah',
		'IN05715' => 'Arakonam',
		'IN05716' => 'Arcot',
		'IN05717' => 'Vellore',
		'IN05718' => 'Vaniyambadi',
		'IN05719' => 'Ambur',
		'IN05720' => 'Tirupathur',
		'IN05721' => 'Arani',
		'IN05722' => 'Cheyyar',
		'IN05723' => 'Vandavasi',
		'IN05724' => 'Polur',
		'IN05725' => 'Chengam',
		'IN05726' => 'Thandrampet',
		'IN05727' => 'Tiruvannamalai',
		'IN05728' => 'Gingee',
		'IN05729' => 'Tindivanam',
		'IN05730' => 'Vanur',
		'IN05731' => 'Viluppuram',
		'IN05732' => 'Tirukkoyilur',
		'IN05733' => 'Sankarapuram',
		'IN05734' => 'Kallakkurichi',
		'IN05735' => 'Ulundurpettai',
		'IN05736' => 'Mettur',
		'IN05737' => 'Omalur',
		'IN05738' => 'Edappadi',
		'IN05739' => 'Sankari',
		'IN05740' => 'Salem',
		'IN05741' => 'Yercaud',
		'IN05742' => 'Vazhapadi',
		'IN05743' => 'Attur',
		'IN05744' => 'Gangavalli',
		'IN05745' => 'Tiruchengode',
		'IN05746' => 'Rasipuram',
		'IN05747' => 'Namakkal',
		'IN05748' => 'Paramathi-Velur',
		'IN05749' => 'Sathyamangalam',
		'IN05750' => 'Bhavani',
		'IN05751' => 'Gobichettipalayam',
		'IN05752' => 'Perundurai',
		'IN05753' => 'Erode',
		'IN05754' => 'Panthalur',
		'IN05755' => 'Gudalur',
		'IN05756' => 'Udhagamandalam',
		'IN05757' => 'Kotagiri',
		'IN05758' => 'Coonoor',
		'IN05759' => 'Kundah',
		'IN05760' => 'Palani',
		'IN05761' => 'Oddanchatram',
		'IN05762' => 'Vedasandur',
		'IN05763' => 'Natham',
		'IN05764' => 'Dindigul',
		'IN05765' => 'Attur',
		'IN05766' => 'Kodaikanal',
		'IN05767' => 'Nilakkottai',
		'IN05768' => 'Aravakurichi',
		'IN05769' => 'Karur',
		'IN05770' => 'Krishnarayapuram',
		'IN05771' => 'Kulithalai',
		'IN05772' => 'Kadavur',
		'IN05773' => 'Thottiyam',
		'IN05774' => 'Musiri',
		'IN05775' => 'Thuraiyur',
		'IN05776' => 'Manachanallur',
		'IN05777' => 'Lalgudi',
		'IN05778' => 'Srirangam',
		'IN05779' => 'Tiruchirappalli',
		'IN05780' => 'Thiruverumbur',
		'IN05781' => 'Manapparai',
		'IN05782' => 'Veppanthattai',
		'IN05783' => 'Perambalur',
		'IN05784' => 'Kunnam',
		'IN05785' => 'Sendurai',
		'IN05786' => 'Udayarpalayam',
		'IN05787' => 'Ariyalur',
		'IN05788' => 'Panruti',
		'IN05789' => 'Cuddalore',
		'IN05790' => 'Kurinjipadi',
		'IN05791' => 'Chidambaram',
		'IN05792' => 'Kattumannarkoil',
		'IN05793' => 'Virudhachalam',
		'IN05794' => 'Tittakudi',
		'IN05795' => 'Sirkali',
		'IN05796' => 'Mayiladuthurai',
		'IN05797' => 'Kuthalam',
		'IN05798' => 'Tharangambadi',
		'IN05799' => 'Nagapattinam',
		'IN05800' => 'Kilvelur',
		'IN05801' => 'Thirukkuvalai',
		'IN05802' => 'Vedaranyam',
		'IN05803' => 'Valangaiman',
		'IN05804' => 'Kodavasal',
		'IN05805' => 'Nannilam',
		'IN05806' => 'Thiruvarur',
		'IN05807' => 'Needamangalam',
		'IN05808' => 'Mannargudi',
		'IN05809' => 'Thiruthuraipoondi',
		'IN05810' => 'Thiruvidaimarudur',
		'IN05811' => 'Kumbakonam',
		'IN05812' => 'Papanasam',
		'IN05813' => 'Thiruvaiyaru',
		'IN05814' => 'Thanjavur',
		'IN05815' => 'Orathanadu',
		'IN05816' => 'Pattukkottai',
		'IN05817' => 'Peravurani',
		'IN05818' => 'Iluppur',
		'IN05819' => 'Kulathur',
		'IN05820' => 'Gandarvakkottai',
		'IN05821' => 'Pudukkottai',
		'IN05822' => 'Thirumayam',
		'IN05823' => 'Ponnamaravathi',
		'IN05824' => 'Alangudi',
		'IN05825' => 'Karambakudi',
		'IN05826' => 'Aranthangi',
		'IN05827' => 'Manamelkudi',
		'IN05828' => 'Avudayarkoil',
		'IN05829' => 'Tirupathur',
		'IN05830' => 'Karaikkudi',
		'IN05831' => 'Devakottai',
		'IN05832' => 'Sivaganga',
		'IN05833' => 'Manamadurai',
		'IN05834' => 'Ilayangudi',
		'IN05835' => 'Melur',
		'IN05836' => 'Madurai North',
		'IN05837' => 'Vadipatti',
		'IN05838' => 'Usilampatti',
		'IN05839' => 'Peraiyur',
		'IN05840' => 'Thirumangalam',
		'IN05841' => 'Madurai South',
		'IN05842' => 'Bodinayakanur',
		'IN05843' => 'Periyakulam',
		'IN05844' => 'Theni',
		'IN05845' => 'Uthamapalayam',
		'IN05846' => 'Andipatti',
		'IN05847' => 'Rajapalayam',
		'IN05848' => 'Srivilliputhur',
		'IN05849' => 'Sivakasi',
		'IN05850' => 'Virudhunagar',
		'IN05851' => 'Kariapatti',
		'IN05852' => 'Tiruchuli',
		'IN05853' => 'Aruppukkottai',
		'IN05854' => 'Sattur',
		'IN05855' => 'Tiruvadanai',
		'IN05856' => 'Paramakudi',
		'IN05857' => 'Mudukulathur',
		'IN05858' => 'Kamuthi',
		'IN05859' => 'Kadaladi',
		'IN05860' => 'Ramanathapuram',
		'IN05861' => 'Rameswaram',
		'IN05862' => 'Kovilpatti',
		'IN05863' => 'Ettayapuram',
		'IN05864' => 'Vilathikulam',
		'IN05865' => 'Ottapidaram',
		'IN05866' => 'Thoothukkudi',
		'IN05867' => 'Srivaikuntam',
		'IN05868' => 'Tiruchendur',
		'IN05869' => 'Sathankulam',
		'IN05870' => 'Sivagiri',
		'IN05871' => 'Sankarankoil',
		'IN05872' => 'Veerakeralamputhur',
		'IN05873' => 'Tenkasi',
		'IN05874' => 'Shenkottai',
		'IN05875' => 'Alangulam',
		'IN05876' => 'Tirunelveli',
		'IN05877' => 'Palayamkottai',
		'IN05878' => 'Ambasamudram',
		'IN05879' => 'Nanguneri',
		'IN05880' => 'Radhapuram',
		'IN05881' => 'Vilavancode',
		'IN05882' => 'Kalkulam',
		'IN05883' => 'Thovala',
		'IN05884' => 'Agastheeswaram',
		'IN05885' => 'Palakkodu',
		'IN05886' => 'Harur',
		'IN05887' => 'Pappireddipatti',
		'IN05888' => 'Dharmapuri',
		'IN05889' => 'Pennagaram',
		'IN05890' => 'Hosur',
		'IN05891' => 'Krishnagiri',
		'IN05892' => 'Denkanikottai',
		'IN05893' => 'Pochampalli',
		'IN05894' => 'Uthangarai',
		'IN05895' => 'Mettupalayam',
		'IN05896' => 'Sulur',
		'IN05897' => 'Coimbatore North',
		'IN05898' => 'Coimbatore South',
		'IN05899' => 'Pollachi',
		'IN05900' => 'Valparai',
		'IN05901' => 'Kangeyam',
		'IN05902' => 'Dharapuram',
		'IN05903' => 'Avanashi',
		'IN05904' => 'Tiruppur',
		'IN05905' => 'Palladam',
		'IN05906' => 'Udumalaipettai',
		'IN05907' => 'Madathukulam',
	],
	'PY' => [
		'IN05908' => 'Yanam Taluk',
		'IN05909' => 'Puducherry Taluk',
		'IN05910' => 'Ozhukarai Taluk',
		'IN05911' => 'Villianur Taluk',
		'IN05912' => 'Bahour Taluk',
		'IN05913' => 'Mahe Taluk',
		'IN05914' => 'Karaikal Taluk',
		'IN05915' => 'Thirunallar Taluk',
	],
	'AN' => [
		'IN05916' => 'Car Nicobar',
		'IN05917' => 'Nancowry',
		'IN05918' => 'Great Nicobar',
		'IN05919' => 'Diglipur',
		'IN05920' => 'Mayabunder',
		'IN05921' => 'Rangat',
		'IN05922' => 'Ferrargunj',
		'IN05923' => 'Port Blair',
		'IN05924' => 'Little Andaman',
	]
];
