<?php

/**
 * List of cities for: Israel
 * Source: https://data.gov.il/dataset/citiesandsettelments
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'IL011' => _x( 'JERUSALEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL021' => _x( 'ZEFAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL022' => _x( 'KINNERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL023' => _x( 'AFULA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL024' => _x( 'AKKO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL025' => _x( 'NAZARETH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL029' => _x( 'GOLAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL031' => _x( 'HAIFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL032' => _x( 'HADERA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL041' => _x( 'HASHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL042' => _x( 'PETAH TIQWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL043' => _x( 'RAMLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL044' => _x( 'REHOVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL051' => _x( 'TEL AVIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL052' => _x( 'RAMAT GAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL053' => _x( 'HOLON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL061' => _x( 'ASHQELON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL062' => _x( 'BEER SHEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL071' => _x( 'JENIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL072' => _x( 'NABLUS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL073' => _x( 'TULKARM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL074' => _x( 'RAMALLAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL075' => _x( 'JERICHO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL076' => _x( 'BETLEHEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	'IL077' => _x( 'HEBRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'IL011' => [
		'IL1070' => _x( 'AVIEZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1123' => _x( 'ADDERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL886' => _x( 'ETANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL740' => _x( 'ESHTAOL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL751' => _x( 'BET MEIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2610' => _x( 'BET SHEMESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL864' => _x( 'BEQOA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL823' => _x( 'BAR GIYYORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL787' => _x( 'GIVAT YEARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL919' => _x( 'GIVAT YESHAYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL566' => _x( 'GIVAT SHEMESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1043' => _x( 'GIZO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL39' => _x( 'GEFEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL493' => _x( 'DEIR RAFAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL464' => _x( 'HAREL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL799' => _x( 'ZEKHARYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL816' => _x( 'ZANOAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL462' => _x( 'TAL SHAHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL805' => _x( 'YISHI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL859' => _x( 'KESALON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL364' => _x( 'KEFAR URIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1325' => _x( 'KEFAR ZOHARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL52' => _x( 'LUZIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL776' => _x( 'MAHSEYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL822' => _x( 'MATTA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL742' => _x( 'MESILLAT ZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL286' => _x( 'MAALE HAHAMISHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL405' => _x( 'NEWE ILAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1071' => _x( 'NEWE MIKHAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1259' => _x( 'NEWE SHALOM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL59' => _x( 'NEHUSHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL809' => _x( 'NAHAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL777' => _x( 'NAHSHON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1254' => _x( 'NATAF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL825' => _x( 'NES HARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL693' => _x( 'NETIV HALAMED-HE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL794' => _x( 'AGUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL465' => _x( 'ZOVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1113' => _x( 'ZUR HADASSA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL796' => _x( 'ZELAFON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1079' => _x( 'ZAFRIRIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL567' => _x( 'ZORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1137' => _x( 'QIRYAT YEARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2039' => _x( 'QIRYAT YEARIM(INSTI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL78' => _x( 'QIRYAT ANAVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL460' => _x( 'RAMAT RAZIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL27' => _x( 'SEDOT MIKHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL741' => _x( 'SHOEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL456' => _x( 'SHORESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1114' => _x( 'LI-ON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL10' => _x( 'TIROSH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL752' => _x( 'TAOZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL778' => _x( 'TARUM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL472' => _x( 'ABU GHOSH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL783' => _x( 'EVEN SAPPIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL780' => _x( 'ORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL710' => _x( 'BET ZAYIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL672' => _x( 'BET NEQOFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1134' => _x( 'YAD HASHEMONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1144' => _x( 'YEDIDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3000' => _x( 'JERUSALEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL771' => _x( 'MEVO BETAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1015' => _x( 'MEVASSERET ZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL208' => _x( 'MOZA ILLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1056' => _x( 'EN KAREM-B.S.HAQLAI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL521' => _x( 'EIN NAQQUBA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL514' => _x( 'EIN RAFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL779' => _x( 'AMMINADAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL127' => _x( 'RAMAT RAHEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL021' => [
		'IL1115' => _x( 'AVIVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1294' => _x( 'OR HAGANUZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL77' => _x( 'AYYELET HASHAHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL730' => _x( 'ELIFELET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1064' => _x( 'AMIRIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL368' => _x( 'BIRIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL322' => _x( 'BET HILLEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1191' => _x( 'BAR YOHAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL667' => _x( 'BARAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL487' => _x( 'JISH(GUSH HALAV)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL35' => _x( 'GADOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL852' => _x( 'GONEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1067' => _x( 'DOVEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2063' => _x( 'DISHON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL431' => _x( 'DALTON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL303' => _x( 'DAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL302' => _x( 'DAFNA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL356' => _x( 'HAGOSHERIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL253' => _x( 'HULATA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2034' => _x( 'HAZOR HAGELILIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL962' => _x( 'TUBA-ZANGARIYYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2009' => _x( 'YUVAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL29' => _x( 'YESUD HAMAALA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL453' => _x( 'YIFTAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL623' => _x( 'YIRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1338' => _x( 'KADITA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1252' => _x( 'KORAZIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1210' => _x( 'KAHAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL357' => _x( 'KEFAR BLUM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL76' => _x( 'KEFAR GILADI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL443' => _x( 'KEFAR HANASI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL609' => _x( 'KEFAR HOSHEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1297' => _x( 'KEFAR HANANYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL345' => _x( 'KEFAR SZOLD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL605' => _x( 'KEFAR SHAMMAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL664' => _x( 'KEREM BEN ZIMRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL380' => _x( 'LAHAVOT HABASHAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL308' => _x( 'MAHANAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL43' => _x( 'METULA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL607' => _x( 'MERON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL596' => _x( 'MALKIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL347' => _x( 'MENNARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL416' => _x( 'MAYAN BARUKH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL843' => _x( 'MARGALIYYOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL378' => _x( 'MISGAV AM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL732' => _x( 'MISHMAR HAYARDEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL408' => _x( 'NEOT MORDEKHAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL578' => _x( 'SASA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL688' => _x( 'ALMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1212' => _x( 'AMUQQA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL385' => _x( 'AMMIAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL319' => _x( 'AMIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL599' => _x( 'PAROD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1213' => _x( 'ZIVON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8000' => _x( 'ZEFAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2800' => _x( 'QIRYAT SHEMONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL26' => _x( 'ROSH PINNA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL540' => _x( 'REIHANIYYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL372' => _x( 'RAMOT NAFTALI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL324' => _x( 'SHEAR YASHUV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL861' => _x( 'SEDE ELIEZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL329' => _x( 'SEDE NEHEMYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL366' => _x( 'SHAMIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1132' => _x( 'SENIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL846' => _x( 'SHEFER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL022' => [
		'IL49' => _x( 'ILANIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL330' => _x( 'ALUMMOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1125' => _x( 'ALMAGOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1253' => _x( 'AMNUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL176' => _x( 'AFIQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL701' => _x( 'ARBEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL199' => _x( 'ASHDOT YAAQOV(IHUD)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL188' => _x( 'ASHDOT YAAQOV(MEUH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL143' => _x( 'BET ZERA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL365' => _x( 'BET QESHET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1293' => _x( 'GIVAT AVNI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL262' => _x( 'GINNOSAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL305' => _x( 'GESHER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL62' => _x( 'DEGANYA ALEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL79' => _x( 'DEGANYA BET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL702' => _x( 'HAON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1322' => _x( 'HODAYOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL307' => _x( 'HAZOREIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL374' => _x( 'HUQOQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1047' => _x( 'HAZON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL993' => _x( 'HAMAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6700' => _x( 'TIBERIAS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1214' => _x( 'TEFAHOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL46' => _x( 'YAVNEEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL371' => _x( 'KADOORIE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1229' => _x( 'KALLANIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL63' => _x( 'KINNERET(MOSHAVA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL57' => _x( 'KINNERET(QEVUZA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL786' => _x( 'KEFAR ZETIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL255' => _x( 'KEFAR HITTIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL508' => _x( 'KAFAR KAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL388' => _x( 'KEFAR KISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL47' => _x( 'KEFAR TAVOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL38' => _x( 'KARE DESHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL585' => _x( 'LAVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1230' => _x( 'LIVNIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL481' => _x( 'MUGHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL65' => _x( 'MIGDAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL48' => _x( 'MENAHEMYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1258' => _x( 'MASSAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL263' => _x( 'MASSADA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL678' => _x( 'MAAGAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL58' => _x( 'MIZPA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL530' => _x( 'EILABUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL273' => _x( 'EN GEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1104' => _x( 'PORIYYA-KEFAR AVODA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1105' => _x( 'PORIYYA-NEWE OVED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1313' => _x( 'PORIYYA ILLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1211' => _x( 'QADDARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1225' => _x( 'RAVID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL721' => _x( 'SEDE ILAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL306' => _x( 'SHADMOT DEVORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1299' => _x( 'SEORIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL264' => _x( 'SHAAR HAGOLAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL292' => _x( 'SHARONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL719' => _x( 'TEL QAZIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1285' => _x( 'KARKOM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL023' => [
		'IL2052' => _x( 'AVITAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL113' => _x( 'ADDIRIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1108' => _x( 'OMEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1330' => _x( 'AHUZAT BARAK', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL478' => _x( 'IKSAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1182' => _x( 'ALLON HAGALIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL429' => _x( 'ALLONE ABBA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL285' => _x( 'ALLONIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL682' => _x( 'ELYAQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL95' => _x( 'BET ALFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL242' => _x( 'BET HASHITTA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL353' => _x( 'BET ZEID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL265' => _x( 'BET YOSEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL430' => _x( 'BET LEHEM HAGELILIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1162' => _x( 'BET RIMMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9200' => _x( 'BET SHEAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL248' => _x( 'BET SHEARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL94' => _x( 'BALFURIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL944' => _x( 'BASMAT TABUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL141' => _x( 'BARAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL86' => _x( 'GEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1288' => _x( 'GIVAT ELA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL703' => _x( 'GIVAT OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL133' => _x( 'GEVAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL145' => _x( 'GADISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL442' => _x( 'GIDONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL457' => _x( 'GAZIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL92' => _x( 'GINNEGAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL369' => _x( 'EVEN YIZHAQ(GALED)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1274' => _x( 'GAN NER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL146' => _x( 'DEVORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL489' => _x( 'DABBURYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL407' => _x( 'DAVERAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL475' => _x( 'DAHI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL300' => _x( 'DALIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1186' => _x( 'HOSHAAYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL250' => _x( 'HAZOREA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL684' => _x( 'HAYOGEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL677' => _x( 'HASOLELIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1249' => _x( 'HARDUF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL975' => _x( 'ZARZIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1110' => _x( 'HEVER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL343' => _x( 'HAMADYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1257' => _x( 'HANNATON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL90' => _x( 'HEFZI-BAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL497' => _x( 'TAYIBE(BAEMEQ)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL268' => _x( 'TIRAT ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL547' => _x( 'TAMRA (YIZREEL)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL452' => _x( 'YIZREEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1117' => _x( 'YAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL134' => _x( 'YIFAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL241' => _x( 'YOQNEAM(MOSHAVA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL240' => _x( 'YOQNEAM ILLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2026' => _x( 'YARDENA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL132' => _x( 'KEFAR BARUKH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL106' => _x( 'KEFAR GIDON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL192' => _x( 'KEFAR HAHORESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL140' => _x( 'KEFAR YEHOSHUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL85' => _x( 'KEFAR YEHEZQEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL295' => _x( 'KEFAR RUPPIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL874' => _x( 'MIGDAL HAEMEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL586' => _x( 'MEGIDDO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1155' => _x( 'MAGEN SHAUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2029' => _x( 'MIDRAKH OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL269' => _x( 'MOLEDET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL635' => _x( 'MUQEIBLE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL104' => _x( 'MIZRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1413' => _x( 'MAHANE YEHUDIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2054' => _x( 'METAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1282' => _x( 'MERAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL164' => _x( 'MELEA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1154' => _x( 'MALKISHUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL298' => _x( 'MESILLOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL272' => _x( 'MAOZ HAYYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1127' => _x( 'MAALE GILBOA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1190' => _x( 'MIZPE NETOFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL97' => _x( 'MERHAVYA(MOSHAV)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL66' => _x( 'MERHAVYA(QIBBUZ)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL130' => _x( 'MISHMAR HAEMEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL524' => _x( 'NAURA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL80' => _x( 'NAHALAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL590' => _x( 'NEWE UR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL296' => _x( 'NEWE ETAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL833' => _x( 'NURIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL523' => _x( 'NEIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL256' => _x( 'NIR DAWID (TEL AMAL)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL165' => _x( 'NIR YAFE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL526' => _x( 'SULAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL436' => _x( 'EN DOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL383' => _x( 'EN HANAZIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL367' => _x( 'EN HAEMEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL270' => _x( 'EN HASHOFET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL89' => _x( 'EN HAROD (IHUD)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL82' => _x( 'EN HAROD(MEUHAD)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7700' => _x( 'AFULA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2053' => _x( 'PERAZON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL613' => _x( 'ZIPPORI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL636' => _x( 'SANDALA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2016' => _x( 'REWAYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL854' => _x( 'REHOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1069' => _x( 'RAM-ON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL445' => _x( 'RAMOT MENASHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL135' => _x( 'RAMAT DAWID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL335' => _x( 'RAMAT HASHOFET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL122' => _x( 'RAMAT YISHAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL339' => _x( 'RAMAT ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL437' => _x( 'RESHAFIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL913' => _x( 'SHIBLI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL304' => _x( 'SEDE ELIYYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL142' => _x( 'SEDE YAAQOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL259' => _x( 'SEDE NAHUM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2057' => _x( 'SEDE TERUMOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL439' => _x( 'SHELUHOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1337' => _x( 'SHIMSHIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL126' => _x( 'SARID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL84' => _x( 'TEL YOSEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL103' => _x( 'TEL ADASHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1283' => _x( 'TEL TEOMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1244' => _x( 'TIMRAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL024' => [
		'IL1275' => _x( 'AVTALYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1276' => _x( 'NAHAL ESHBAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1188' => _x( 'ESHHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1298' => _x( 'ETGAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL480' => _x( 'BEIT JANN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1204' => _x( 'GILON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1317' => _x( 'DEMEIDE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1203' => _x( 'HARARIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1332' => _x( 'HUSSNIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1272' => _x( 'HALUZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1209' => _x( 'HARASHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1181' => _x( 'TAL-EL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1226' => _x( 'YUVALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1112' => _x( 'YODEFAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1138' => _x( 'YAAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1153' => _x( 'KISHOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1331' => _x( 'KAMANNEH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1201' => _x( 'KAMMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1139' => _x( 'KARMIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1207' => _x( 'LAVON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1171' => _x( 'LOTEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1163' => _x( 'MORAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1178' => _x( 'MORESHET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1202' => _x( 'MIKHMANNIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1174' => _x( 'MANOF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1222' => _x( 'MIZPE AVIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL522' => _x( 'NAHEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL525' => _x( 'SAJUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL989' => _x( 'SAWAID (KAMANE)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1245' => _x( 'SALLAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL917' => _x( 'ATSMON-SEGEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1335' => _x( 'ARRAB AL NAIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1185' => _x( 'PELEKH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1180' => _x( 'ZVIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1221' => _x( 'ZURIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1179' => _x( 'QORANIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL543' => _x( 'RAME', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1334' => _x( 'RAS AL-EIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1228' => _x( 'RAQEFET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1235' => _x( 'SHORASHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1160' => _x( 'SHEKHANYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1172' => _x( 'TUVAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL998' => _x( 'BIR EL-MAKSUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL510' => _x( 'KAFAR MANDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8800' => _x( 'SHEFARAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL473' => _x( 'ABU SINAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1220' => _x( 'ABBIRIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1081' => _x( 'EVEN MENAHEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1068' => _x( 'ADAMIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL785' => _x( 'AHIHUD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL294' => _x( 'ELON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL603' => _x( 'ELQOSH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL529' => _x( 'IBILLIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL313' => _x( 'AFEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1256' => _x( 'ASHERAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL559' => _x( 'BUSTAN HAGALIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL572' => _x( 'BET HAEMEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL712' => _x( 'BEN AMMI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL483' => _x( 'BI NE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL589' => _x( 'BEZET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1292' => _x( 'JUDEIDE-MAKER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL485' => _x( 'JULIS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL755' => _x( 'GOREN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1219' => _x( 'GORNOT HAGALIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1206' => _x( 'GITTA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL463' => _x( 'GATON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL574' => _x( 'GESHER HAZIW', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL490' => _x( 'DEIR AL-ASAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL492' => _x( 'DEIR HANNA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1208' => _x( 'HILLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL948' => _x( 'HUJEIRAT (DAHRA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL662' => _x( 'HOSEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL496' => _x( 'HURFEISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL280' => _x( 'HANITA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1404' => _x( 'HAZROT YASAF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8900' => _x( 'TAMRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1295' => _x( 'YANUH-JAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL409' => _x( 'YEHIAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL575' => _x( 'YASUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL795' => _x( 'YAARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL502' => _x( 'YIRKA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL504' => _x( 'KABUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL505' => _x( 'KAOKAB ABU AL-HIJA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL576' => _x( 'KABRI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1183' => _x( 'KELIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1296' => _x( 'KISRA-SUMEI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1263' => _x( 'KEFAR WERADIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL507' => _x( 'KAFAR YASIF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL297' => _x( 'KEFAR MASARYK', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL579' => _x( 'KEFAR ROSH HANIQRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1130' => _x( 'KEFAR ROZENWALD(ZAR.', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL595' => _x( 'LOHAME HAGETAOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL674' => _x( 'LIMAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1173' => _x( 'LAPPIDOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL516' => _x( 'MAJD AL-KURUM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL517' => _x( 'MAZRAA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1205' => _x( 'MANOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL570' => _x( 'MEONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL518' => _x( 'MIELYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1063' => _x( 'MAALOT-TARSHIHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL325' => _x( 'MAZZUVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1184' => _x( 'MATTAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9100' => _x( 'NAHARIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1314' => _x( 'NEVE ZIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1147' => _x( 'NETUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1143' => _x( 'NES AMMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL792' => _x( 'NETIV HASHAYYARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL942' => _x( 'SAWAID(HAMRIYYE)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7500' => _x( 'SAKHNIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL454' => _x( 'SAAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL892' => _x( 'AVDON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL376' => _x( 'EVRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1199' => _x( 'ADI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL289' => _x( 'EN HAMIFRAZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL813' => _x( 'EN YAAQOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7600' => _x( 'AKKO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL708' => _x( 'AMQA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL531' => _x( 'ARRABE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1246' => _x( 'ARAMSHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL535' => _x( 'FASSUTA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL536' => _x( 'PEQIIN (BUQEIA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL281' => _x( 'PEQIIN HADASHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL774' => _x( 'ZURIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL390' => _x( 'REGBA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL282' => _x( 'SHAVE ZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL614' => _x( 'SHOMERA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL658' => _x( 'SHEIKH DANNUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL812' => _x( 'SHELOMI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL432' => _x( 'SHAMERAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL538' => _x( 'SHAAB', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1045' => _x( 'SHETULA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL546' => _x( 'EIN AL-ASAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL527' => _x( 'SHEZOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL025' => [
		'IL986' => _x( 'KHAWALED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL482' => _x( 'BUEINE-NUJEIDAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL498' => _x( 'TURAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL499' => _x( 'YAFI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL978' => _x( 'KAABIYYE-TABBASH-HA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL509' => _x( 'KAFAR KANNA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL520' => _x( 'MESHHED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1061' => _x( 'NOF HAGALIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7300' => _x( 'NAZARETH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL528' => _x( 'UZEIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL511' => _x( 'ILUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL532' => _x( 'EIN MAHEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL539' => _x( 'RUMMANE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL997' => _x( 'RUMAT HEIB', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL542' => _x( 'REINE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL512' => _x( 'KAFAR MISR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL994' => _x( 'MANSHIYYET ZABDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL029' => [
		'IL4011' => _x( 'AVNE ETAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4013' => _x( 'ORTAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4017' => _x( 'ALLONE HABASHAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4002' => _x( 'ELI AL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4012' => _x( 'ANIAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4301' => _x( 'AFIQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4015' => _x( 'BENE YEHUDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4021' => _x( 'GIVAT YOAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4022' => _x( 'GESHUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4026' => _x( 'HAD-NES', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4005' => _x( 'HASPIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4007' => _x( 'YONATAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4028' => _x( 'KANAF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4004' => _x( 'KEFAR HARUV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4204' => _x( 'MEVO HAMMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4019' => _x( 'MEZAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4008' => _x( 'MAALE GAMLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4551' => _x( 'NEOT GOLAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4304' => _x( 'NOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4014' => _x( 'NATUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4025' => _x( 'QIDMAT ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4024' => _x( 'QELA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4100' => _x( 'QAZRIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4006' => _x( 'QESHET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4702' => _x( 'RAMOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4701' => _x( 'RAMAT MAGSHIMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4009' => _x( 'SHAAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4010' => _x( 'ODEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4003' => _x( 'EL-ROM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4001' => _x( 'BUQATA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4201' => _x( 'MAJDAL SHAMS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4203' => _x( 'MASADE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4101' => _x( 'MEROM GOLAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4303' => _x( 'NEWE ATIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4501' => _x( 'GHAJAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4503' => _x( 'EN ZIWAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4502' => _x( 'EIN QINIYYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL031' => [
		'IL652' => _x( 'IBTIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL882' => _x( 'ORANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL494' => _x( 'DALIYAT AL-KARMEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1321' => _x( 'KHAWALED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4000' => _x( 'HAIFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2100' => _x( 'TIRAT KARMEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL96' => _x( 'YAGUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL220' => _x( 'KEFAR BIALIK', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL427' => _x( 'KEFAR GALLIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL254' => _x( 'KEFAR HAMAKKABI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL890' => _x( 'KEFAR HANOAR HADATI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL112' => _x( 'KEFAR HASIDIM ALEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL889' => _x( 'KEFAR HASIDIM BET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1284' => _x( 'NOFIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2500' => _x( 'NESHER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL534' => _x( 'ISIFYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2300' => _x( 'QIRYAT TIVON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL990' => _x( 'RAS ALI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL237' => _x( 'SHAAR HAAMAQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL278' => _x( 'USHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6800' => _x( 'QIRYAT ATTA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9500' => _x( 'QIRYAT BIALIK', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9600' => _x( 'QIRYAT YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8200' => _x( 'QIRYAT MOTZKIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL922' => _x( 'REKHASIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL178' => _x( 'RAMAT YOHANAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL032' => [
		'IL679' => _x( 'AVIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2024' => _x( 'UMM AL-QUTUF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1020' => _x( 'OR AQIVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1316' => _x( 'AL-ARYAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL868' => _x( 'ALLONE YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6000' => _x( 'BAQA AL-GHARBIYYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL317' => _x( 'BET OREN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL800' => _x( 'BET HANANYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL212' => _x( 'BET ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9800' => _x( 'BINYAMINA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1326' => _x( 'BASMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL617' => _x( 'BARQAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL33' => _x( 'BAT SHELOMO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL541' => _x( 'JISR AZ-ZARQA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL628' => _x( 'JAAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL683' => _x( 'GEVA  KARMEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL360' => _x( 'GIVAT NILI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL225' => _x( 'GAN HASHOMERON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL72' => _x( 'GAN SHEMUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL738' => _x( 'DOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL675' => _x( 'HABONIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL434' => _x( 'HAHOTERIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9300' => _x( 'ZIKHRON YAAQOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6500' => _x( 'HADERA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1247' => _x( 'HARISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL310' => _x( 'KEFAR GLIKSON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL189' => _x( 'KEFAR PINES', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL654' => _x( 'KAFAR QARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL580' => _x( 'KEREM MAHARAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL715' => _x( 'LAHAVOT HAVIVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2055' => _x( 'MAOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL102' => _x( 'MEIR SHEFEYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL689' => _x( 'MEGADIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL375' => _x( 'MAGGAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1128' => _x( 'ME AMMI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL649' => _x( 'MEISER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL694' => _x( 'MAAGAN MIKHAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL290' => _x( 'MAYAN ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL344' => _x( 'MAANIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1370' => _x( 'MITZPE ILAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL648' => _x( 'MEZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL213' => _x( 'MISHMAROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL926' => _x( 'NEWE AVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL312' => _x( 'NEWE YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL433' => _x( 'NAHSHOLIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL769' => _x( 'NIR EZYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL810' => _x( 'OFER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL687' => _x( 'EN AYYALA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL74' => _x( 'EN HOD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1320' => _x( 'EIN HAWD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL426' => _x( 'EN KARMEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL223' => _x( 'EN IRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL139' => _x( 'EN SHEMER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL773' => _x( 'AMMIQAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL637' => _x( 'ARARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL53' => _x( 'ATLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL537' => _x( 'FUREIDIS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7800' => _x( 'PARDES HANNA-KARKUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL612' => _x( 'ZERUFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1167' => _x( 'QESARIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1243' => _x( 'KATZIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL444' => _x( 'REGAVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2008' => _x( 'SEDE YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL327' => _x( 'SEDOT YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL921' => _x( 'SHAAR MENASHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2003' => _x( 'TALME ELAZAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2710' => _x( 'UMM AL-FAHM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1327' => _x( 'MAALE IRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL041' => [
		'IL41' => _x( 'ELYAKHIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL204' => _x( 'ELYASHIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL872' => _x( 'GEULE TEMAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL377' => _x( 'HAMAPIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL205' => _x( 'HOGLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL219' => _x( 'HIBBAT ZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL422' => _x( 'HEREV LEET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL217' => _x( 'KEFAR HAROE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL175' => _x( 'AVIHAYIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL182' => _x( 'EVEN YEHUDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL446' => _x( 'UDIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL680' => _x( 'OMEZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL850' => _x( 'AHITUV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1324' => _x( 'ARSUF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL697' => _x( 'BEEROTAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL698' => _x( 'BURGETA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2043' => _x( 'BAHAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL373' => _x( 'BET HALEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL877' => _x( 'BET HERUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL288' => _x( 'BET YEHOSHUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL200' => _x( 'BET YANNAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL326' => _x( 'BET YIZHAQ-SH. HEFER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL252' => _x( 'BITAN AHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL386' => _x( 'BENE DEROR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL418' => _x( 'BENE ZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL389' => _x( 'BAZRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1361' => _x( 'BAT HEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1319' => _x( 'BAT HEFER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL379' => _x( 'GEULIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2018' => _x( 'GIVAT HAYYIM (IHUD)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL173' => _x( 'GIVAT HAYYIM(MEUHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1077' => _x( 'GIVAT SHAPPIRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL734' => _x( 'GAN YOSHIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL549' => _x( 'GANNOT HADAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL842' => _x( 'GAASH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL191' => _x( 'HADAR AM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL423' => _x( 'HAOGEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1290' => _x( 'ZEMER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL235' => _x( 'HAVAZZELET HASHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL115' => _x( 'HOFIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL162' => _x( 'HERUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL807' => _x( 'HANNIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1409' => _x( 'HAZAR BEEROTAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1024' => _x( 'HARUZIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2730' => _x( 'TAYIBE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2720' => _x( 'TIRE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL758' => _x( 'YAD HANNA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL753' => _x( 'YANUV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1044' => _x( 'YEAF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL417' => _x( 'YAQUM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL187' => _x( 'KEFAR HESS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL190' => _x( 'KEFAR VITKIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL193' => _x( 'KEFAR HAYYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL233' => _x( 'YEDIDYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL168' => _x( 'KEFAR YONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL170' => _x( 'KEFAR YABEZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL387' => _x( 'KEFAR MONASH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL316' => _x( 'KEFAR NETTER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL875' => _x( 'KEFAR AVODA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1318' => _x( 'MEVOOT YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL897' => _x( 'MIDRESHET RUPPIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL382' => _x( 'MIKHMORET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL197' => _x( 'MABAROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL194' => _x( 'MISHMAR HASHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL425' => _x( 'MISHMERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL447' => _x( 'NORDIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL851' => _x( 'NIZZANE OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL186' => _x( 'NEURIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7400' => _x( 'NETANYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL737' => _x( 'OLESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL837' => _x( 'AZRIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL167' => _x( 'EN HAHORESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL157' => _x( 'EN WERED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL880' => _x( 'EN SARID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL767' => _x( 'PORAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL171' => _x( 'PARDESIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1102' => _x( 'SHOSHANNAT HAAMAQIM(', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ), // This should be Zukei yam
		'IL276' => _x( 'ZUR MOSHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL195' => _x( 'QADIMA-ZORAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL638' => _x( 'QALANSAWE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL412' => _x( 'QIRYAT SHELOMO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL247' => _x( 'RISHPON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL224' => _x( 'SHOSHANNAT HAAMAQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL661' => _x( 'SHAAR EFRAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL232' => _x( 'SHEFAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL287' => _x( 'TEL YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL154' => _x( 'TEL MOND', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2002' => _x( 'TENUVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL042' => [
		'IL716' => _x( 'EYAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL841' => _x( 'ELISHAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1076' => _x( 'BET BERL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL627' => _x( 'JALJULYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL207' => _x( 'GIVAT HEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL239' => _x( 'GAN HAYYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL218' => _x( 'GANNE AM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9700' => _x( 'HOD HASHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL718' => _x( 'YARHIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL183' => _x( 'YARQONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1224' => _x( 'KOKHAV YAIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL98' => _x( 'KEFAR MALAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6900' => _x( 'KEFAR SAVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL686' => _x( 'NEWE YAMIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL808' => _x( 'NIR ELIYYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL198' => _x( 'ZOFIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1345' => _x( 'ZUR YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1148' => _x( 'ZUR NATAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL206' => _x( 'RAMOT HASHAVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL184' => _x( 'RAMAT HAKOVESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8700' => _x( 'RAANANA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL284' => _x( 'SEDE WARBURG', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2015' => _x( 'SEDE HEMED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL450' => _x( 'BEEROT YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL448' => _x( 'BENE ATAROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2038' => _x( 'BAREQET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL802' => _x( 'GIVAT KOAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL681' => _x( 'GIVAT SHEMUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL229' => _x( 'GANNE TIQWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL128' => _x( 'GAT RIMMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL717' => _x( 'HAGOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1405' => _x( 'HAZROT KOAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL663' => _x( 'TIRAT YEHUDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9400' => _x( 'YEHUD-MONOSON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL633' => _x( 'KAFAR BARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL249' => _x( 'KEFAR SIRKIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL634' => _x( 'KAFAR QASEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL722' => _x( 'MAGSHIMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL606' => _x( 'MAZOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL230' => _x( 'MAAS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1315' => _x( 'MATTAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL858' => _x( 'NEWE YARAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL257' => _x( 'NOFEKH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL449' => _x( 'NEHALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL705' => _x( 'NAHSHONIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL587' => _x( 'SAVYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2035' => _x( 'ADANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7900' => _x( 'PETAH TIQWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL616' => _x( 'RINNATYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1309' => _x( 'ELAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL870' => _x( 'GIVAT HASHELOSHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL355' => _x( 'HORESHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1236' => _x( 'NIRIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL871' => _x( 'ENAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2640' => _x( 'ROSH HAAYIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL043' => [
		'IL804' => _x( 'AHISAMAKH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL797' => _x( 'AHIEZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2530' => _x( 'BEER YAAQOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL466' => _x( 'BET DAGAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1050' => _x( 'BET HASHMONAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL784' => _x( 'BET NEHEMYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL301' => _x( 'BET UZZIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL604' => _x( 'BET ARIF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1084' => _x( 'BEN SHEMEN(K.NOAR)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2013' => _x( 'BEN SHEMEN (MOSHAV)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL370' => _x( 'GEZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL863' => _x( 'GINNATON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL745' => _x( 'GIMZO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL836' => _x( 'GANNOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1103' => _x( 'GANNE HADAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL788' => _x( 'ZETAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL618' => _x( 'HADID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL160' => _x( 'HULDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL801' => _x( 'HEMED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1402' => _x( 'HAZROT HULDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL798' => _x( 'YAGEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL64' => _x( 'YAD RAMBAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL759' => _x( 'YAZIZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL828' => _x( 'YASHRESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2010' => _x( 'KEFAR BIN NUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL707' => _x( 'KEFAR DANIYYEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL696' => _x( 'KEFAR HABAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL673' => _x( 'KEFAR TRUMAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1166' => _x( 'KEFAR RUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL743' => _x( 'KEFAR SHEMUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL88' => _x( 'KEREM BEN SHEMEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1264' => _x( 'KARME YOSEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7000' => _x( 'LOD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1310' => _x( 'LAPPID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1141' => _x( 'MEVO MODIIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1200' => _x( 'MODIIN-MAKKABBIM-RE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL757' => _x( 'MAZLIAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL670' => _x( 'MISHMAR AYYALON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL563' => _x( 'MISHMAR DAWID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL729' => _x( 'MISHMAR HASHIVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1333' => _x( 'NOF AYALON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL331' => _x( 'NIR ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL158' => _x( 'NAAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL435' => _x( 'NEZER SERENI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL610' => _x( 'SITRIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL711' => _x( 'AZARYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL838' => _x( 'PEDAYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL839' => _x( 'PETAHYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL594' => _x( 'ZAFRIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL735' => _x( 'RAMOT MEIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8500' => _x( 'RAMLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1304' => _x( 'SHOHAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1165' => _x( 'SHILAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL856' => _x( 'SHAALVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL044' => [
		'IL1411' => _x( 'MAHANE HILA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8300' => _x( 'RISHON LEZIYYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL562' => _x( 'BET ELAZARI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL571' => _x( 'BET GAMLIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2033' => _x( 'BET HILQIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL159' => _x( 'BET HANAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL202' => _x( 'BET OVED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL848' => _x( 'BET RABBAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL760' => _x( 'BEN ZAKKAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL592' => _x( 'BENE DAROM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1066' => _x( 'BENE AYISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL588' => _x( 'BENE REEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL685' => _x( 'BENAYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL853' => _x( 'GEALYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL147' => _x( 'GIVAT BRENNER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2550' => _x( 'GEDERA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL196' => _x( 'GIBBETON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1072' => _x( 'GAN HADAROM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL166' => _x( 'GAN YAVNE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL311' => _x( 'GAN SOREQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL144' => _x( 'GAN SHELOMO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1371' => _x( 'GANEI TAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL862' => _x( 'GANNE YOHANAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL363' => _x( 'HAFEZ HAYYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2660' => _x( 'YAVNE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL577' => _x( 'YAD BINYAMIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL440' => _x( 'YESODOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL857' => _x( 'KEFAR AVIV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL177' => _x( 'KEFAR BILU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL582' => _x( 'KEFAR HANAGID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL764' => _x( 'KEFAR MORDEKHAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1094' => _x( 'KEREM YAVNE(YESHIVA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL28' => _x( 'MAZKERET BATYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1412' => _x( 'MAHANE TEL-NOF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL731' => _x( 'MESHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL765' => _x( 'MISGAV DOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL174' => _x( 'NETAIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL720' => _x( 'NIR GALLIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7200' => _x( 'NES ZIYYONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1372' => _x( 'NETZER HAZANI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL156' => _x( 'AYANOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL591' => _x( 'ASERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL597' => _x( 'PALMAHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1111' => _x( 'ZOFIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL334' => _x( 'QEVUZAT YAVNE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL615' => _x( 'QIDRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL469' => _x( 'QIRYAT EQRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8400' => _x( 'REHOVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL555' => _x( 'SHEDEMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL051' => [
		'IL346' => _x( 'GELIL YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6400' => _x( 'HERZELIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL267' => _x( 'KEFAR SHEMARYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2650' => _x( 'RAMAT HASHARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL5000' => _x( 'TEL AVIV - YAFO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL052' => [
		'IL6100' => _x( 'BENE BERAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2400' => _x( 'OR YEHUDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6300' => _x( 'GIVATAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2620' => _x( 'QIRYAT ONO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL8600' => _x( 'RAMAT GAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL053' => [
		'IL565' => _x( 'AZOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6200' => _x( 'BAT YAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL6600' => _x( 'HOLON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL22' => _x( 'MIQWE YISRAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL061' => [
		'IL70' => _x( 'ASHDOD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL819' => _x( 'AVIGEDOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL400' => _x( 'EVEN SHEMUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL67' => _x( 'OR HANER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2012' => _x( 'OROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1157' => _x( 'AHAWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL821' => _x( 'AHUZZAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL338' => _x( 'IBBIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL37' => _x( 'ETAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1339' => _x( 'AL-AZI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1145' => _x( 'ALUMMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL772' => _x( 'EMUNIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL23' => _x( 'AMAZYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL714' => _x( 'EREZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7100' => _x( 'ASHQELON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL155' => _x( 'BEER TUVEYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL234' => _x( 'BIZZARON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL619' => _x( 'BET GUVRIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL16' => _x( 'BET NIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL756' => _x( 'BET EZRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL747' => _x( 'BET SHIQMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1368' => _x( 'BNE DKALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL428' => _x( 'BEROR HAYIL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL746' => _x( 'BEREKHYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1323' => _x( 'BAT HADAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1401' => _x( 'BAT HAZOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL424' => _x( 'GEVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL793' => _x( 'GIVATI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL342' => _x( 'GEVARAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL706' => _x( 'GEA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL393' => _x( 'GALON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL340' => _x( 'GAT(QIBBUZ)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL336' => _x( 'DOROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL726' => _x( 'HODIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1133' => _x( 'WARDON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL815' => _x( 'ZAVDIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL44' => _x( 'ZOHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL584' => _x( 'ZIQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL818' => _x( 'ZERAHYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL820' => _x( 'HELEZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL700' => _x( 'HAZAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL406' => _x( 'HAZOR-ASHDOD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL358' => _x( 'YAD MORDEKHAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL775' => _x( 'YAD NATAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL811' => _x( 'YAKHINI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2011' => _x( 'YINNON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL824' => _x( 'KOKHAV MIKHAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2006' => _x( 'KANNOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL690' => _x( 'KEFAR AHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL888' => _x( 'KEFAR HARIF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL320' => _x( 'KEFAR WARBURG', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL274' => _x( 'KEFAR MENAHEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL107' => _x( 'KEFAR SILVER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL845' => _x( 'KEFAR AZZA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL768' => _x( 'KARMIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL24' => _x( 'LAKHISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL573' => _x( 'MAVQIIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1414' => _x( 'MAHANE MIRYAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2030' => _x( 'MENUHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL668' => _x( 'MEFALLESIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1098' => _x( 'MERKAZ SHAPPIRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL620' => _x( 'MASSUOT YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL791' => _x( 'MASHEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL315' => _x( 'NEGBA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL309' => _x( 'NEHORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL55' => _x( 'NOGAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL827' => _x( 'NEWE MIVTAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL15' => _x( 'NOAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL844' => _x( 'NAHAL OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2045' => _x( 'NAHALA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1369' => _x( 'NETA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL351' => _x( 'NIZZAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1419' => _x( 'NIZZAN B', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL359' => _x( 'NIZZANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL553' => _x( 'NIR BANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL11' => _x( 'NIR HEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL699' => _x( 'NIR YISRAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL348' => _x( 'NIR AM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1242' => _x( 'NETIV HAASARA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2046' => _x( 'SEGULA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL826' => _x( 'UZA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL32' => _x( 'OZEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1149' => _x( 'EZER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL817' => _x( 'AZRIQAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL622' => _x( 'EN ZURIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL593' => _x( 'ARUGOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL392' => _x( 'QEDMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL766' => _x( 'QOMEMIYYUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2630' => _x( 'QIRYAT GAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1034' => _x( 'QIRYAT MALAKHI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL564' => _x( 'REVADIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2051' => _x( 'REWAHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL362' => _x( 'RUHAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL36' => _x( 'SEDE DAWID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL293' => _x( 'SEDE YOAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL18' => _x( 'SEDE MOSHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL739' => _x( 'SEDE UZZIYYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1031' => _x( 'SEDEROT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL7' => _x( 'SHAHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL873' => _x( 'SHALWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL692' => _x( 'SHAFIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1233' => _x( 'SHEQEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL763' => _x( 'SHETULIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL163' => _x( 'TIMMORIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL727' => _x( 'TALME YEHIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL744' => _x( 'TALME YAFE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL814' => _x( 'TELAMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL062' => [
		'IL1126' => _x( 'ELOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2600' => _x( 'ELAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1248' => _x( 'ELIFAZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL21' => _x( 'BEER ORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1129' => _x( 'GEROFIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL13' => _x( 'HAZEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1158' => _x( 'YAHEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL866' => _x( 'YOTVATA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1255' => _x( 'LOTAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1416' => _x( 'MAHANE YOCHEVED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1197' => _x( 'SHIZZAFON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1279' => _x( 'NEWE HARIF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1156' => _x( 'SAMAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1176' => _x( 'SAPPIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1053' => _x( 'EN HAZEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL806' => _x( 'EN YAHAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1151' => _x( 'PARAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1150' => _x( 'ZOFAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1052' => _x( 'QETURA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1266' => _x( 'SHAHARUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1267' => _x( 'NAHAL SHITTIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1376' => _x( 'BEER GANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL967' => _x( 'ABU JUWEIID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL935' => _x( 'ABU SUREIHAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL958' => _x( 'ABU  ABDUN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1042' => _x( 'ABU  AMMAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL932' => _x( 'ABU  AMRE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL968' => _x( 'ABU QUREINAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1342' => _x( 'ABU QUREINAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL966' => _x( 'ABU RUBEIA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL961' => _x( 'ABU RUQAYYEQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1375' => _x( 'ABU TALUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1311' => _x( 'AVSHALOM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1046' => _x( 'OHAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1358' => _x( 'UMM BATIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL31' => _x( 'OFAQIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL403' => _x( 'URIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL965' => _x( 'ATRASH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1359' => _x( 'AL SAYID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL960' => _x( 'ASAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL963' => _x( 'ASAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL959' => _x( 'AFEINISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL71' => _x( 'ESHBOL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2021' => _x( 'ESHEL HANASI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1152' => _x( 'ASHALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1278' => _x( 'BEER MILKA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL9000' => _x( 'BEER SHEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL399' => _x( 'BEERI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL762' => _x( 'BITHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1348' => _x( 'BIR HADAJ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL723' => _x( 'BET HAGADDI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL598' => _x( 'BET QAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1363' => _x( 'BENE NEZARIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2060' => _x( 'BEROSH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL976' => _x( 'JUNNABIB', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL352' => _x( 'GEVULOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2014' => _x( 'GIVOLIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1344' => _x( 'GIVOT BAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL736' => _x( 'GILAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL849' => _x( 'DEVIRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2200' => _x( 'DIMONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1241' => _x( 'DEQEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1349' => _x( 'DRIJAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1169' => _x( 'HAWASHLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL956' => _x( 'HUZAYYEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1261' => _x( 'HAR AMASA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2742' => _x( 'ZABARGA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1065' => _x( 'ZIMRAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2064' => _x( 'ZERUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1239' => _x( 'HOLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1303' => _x( 'HURA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL397' => _x( 'HAZERIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1177' => _x( 'TELALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1232' => _x( 'YEVUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL803' => _x( 'YOSHIVYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL831' => _x( 'YEROHAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL916' => _x( 'YESHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1227' => _x( 'YATED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1329' => _x( 'BEIT YATIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1367' => _x( 'KUKHLEH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL840' => _x( 'KISSUFIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1291' => _x( 'KEMEHIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1059' => _x( 'KUSEIFE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1095' => _x( 'KEFAR MAYMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1085' => _x( 'KEREM SHALOM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1198' => _x( 'KERAMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2023' => _x( 'LAHAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1271' => _x( 'LEHAVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1060' => _x( 'LAQYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1080' => _x( 'MABBUIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL829' => _x( 'MIVTAHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL695' => _x( 'MAGEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1140' => _x( 'MIDRESHET BEN GURION', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1418' => _x( 'MAHANE TALI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1415' => _x( 'MAHANE YAFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1196' => _x( 'MAHANE YATTIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1268' => _x( 'METAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1343' => _x( 'MAKCHUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2044' => _x( 'MELILOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL748' => _x( 'MASLUL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL939' => _x( 'MASUDIN AL-AZAZME', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1082' => _x( 'MAGALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL99' => _x( 'MIZPE RAMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1340' => _x( 'MAHANE YAFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL421' => _x( 'MASHABBE SADE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL395' => _x( 'MISHMAR HANEGEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1124' => _x( 'NEOT HAKIKKAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL396' => _x( 'NEVATIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1366' => _x( 'NAVE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1057' => _x( 'NEWE ZOHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1195' => _x( 'NIZZANA (QEHILAT HIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1280' => _x( 'NIZZANE SINAY', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL402' => _x( 'NIR YIZHAQ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2047' => _x( 'NIR MOSHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL69' => _x( 'NIR OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2048' => _x( 'NIR AQIVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL602' => _x( 'NIRIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1041' => _x( 'NASASRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL246' => _x( 'NETIVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1238' => _x( 'SUFA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1170' => _x( 'SAYYID', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL419' => _x( 'SAAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1360' => _x( 'MULADA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL666' => _x( 'OMER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL957' => _x( 'UQBI (BANU UQBA)', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL328' => _x( 'EZUZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL969' => _x( 'ATAWNE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1175' => _x( 'IDDAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2042' => _x( 'EN GEDI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1240' => _x( 'EN HABESOR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL676' => _x( 'EN HASHELOSHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1251' => _x( 'EN TAMAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1187' => _x( 'IR OVOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1146' => _x( 'ALUMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL318' => _x( 'AMMIOZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2560' => _x( 'ARAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1192' => _x( 'ARARA-BANEGEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL750' => _x( 'PEDUYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL749' => _x( 'PATTISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2059' => _x( 'PAAME TASHAZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1231' => _x( 'PERI GAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL413' => _x( 'ZEELIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1136' => _x( 'TZOHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1262' => _x( 'MAHANE BILDAD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1234' => _x( 'QABBOA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL964' => _x( 'QUDEIRAT AS-SANI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL972' => _x( 'QAWAIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL414' => _x( 'QELAHIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1347' => _x( 'QASR AL-SIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL354' => _x( 'REVIVIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1161' => _x( 'RAHAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1341' => _x( 'RUAH MIDBAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL789' => _x( 'RANNEN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL713' => _x( 'REIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1260' => _x( 'RETAMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1286' => _x( 'SEGEV-SHALOM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL885' => _x( 'SEDE BOQER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1058' => _x( 'SEDE NIZZAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2049' => _x( 'SEDE ZEVI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1223' => _x( 'SEDE AVRAHAM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL761' => _x( 'SHUVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL394' => _x( 'SHOVAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1265' => _x( 'SHOMERIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL415' => _x( 'SHOQEDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL865' => _x( 'SHIBBOLIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1373' => _x( 'SHALVA BAMIDBAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1364' => _x( 'SHLOMIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1287' => _x( 'SHANI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL398' => _x( 'SHARSHERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2062' => _x( 'TEASHUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2061' => _x( 'TIDHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1083' => _x( 'TUSHIYYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1054' => _x( 'TEL SHEVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1051' => _x( 'TALME ELIYYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL2050' => _x( 'TALME BILU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1237' => _x( 'TALME YOSEF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL709' => _x( 'TIFRAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL665' => _x( 'TEQUMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL970' => _x( 'TARABIN AS-SANI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1346' => _x( 'TARABIN AS-SANI TOWN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL071' => [
		'IL3643' => _x( 'HINNANIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3717' => _x( 'HERMESH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3569' => _x( 'MEVO DOTAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3568' => _x( 'REHAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3649' => _x( 'SHAQED', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL072' => [
		'IL3762' => _x( 'ITAMAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3579' => _x( 'ELON MORE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3710' => _x( 'BERAKHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3749' => _x( 'YIZHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3751' => _x( 'MIGDALIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3765' => _x( 'ELI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3795' => _x( 'REVAVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3571' => _x( 'SHAVE SHOMERON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL073' => [
		'IL3570' => _x( 'ARIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3744' => _x( 'BRUKHIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3654' => _x( 'BARQAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3647' => _x( 'YAQIR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3572' => _x( 'KEFAR TAPPUAH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3637' => _x( 'MAALE SHOMERON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3790' => _x( 'NOFIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3727' => _x( 'ALE ZAHAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3768' => _x( 'PEDUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3746' => _x( 'QIRYAT NETAFIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3640' => _x( 'QARNE SHOMERON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3557' => _x( 'QEDUMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3793' => _x( 'AVNE HEFEZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3712' => _x( 'ENAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3567' => _x( 'SALIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3778' => _x( 'EZ EFRAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3791' => _x( 'ZUFIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3760' => _x( 'ORANIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3750' => _x( 'ALFE MENASHE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3560' => _x( 'ELQANA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3660' => _x( 'IMMANUEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3720' => _x( 'SHAARE TIQWA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL074' => [
		'IL3752' => _x( 'MAALE LEVONA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3574' => _x( 'BET EL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3575' => _x( 'BET HORON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3763' => _x( 'GEVA BINYAMIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3644' => _x( 'GIVON HAHADASHA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3730' => _x( 'GIVAT ZEEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3747' => _x( 'DOLEV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3769' => _x( 'HAR ADAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3770' => _x( 'HASHMONAIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3788' => _x( 'TALMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3564' => _x( 'KOKHAV HASHAHAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3779' => _x( 'KOKHAV YAAQOV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3638' => _x( 'KEFAR ADUMMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3796' => _x( 'KEFAR HAORANIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3797' => _x( 'MODIIN ILLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3651' => _x( 'MAALE MIKHMAS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3648' => _x( 'MATTITYAHU', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3573' => _x( 'HALLAMISH', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3767' => _x( 'NAHALIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3787' => _x( 'NAALE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3617' => _x( 'OFRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3658' => _x( 'ATERET', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3715' => _x( 'ALMON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3659' => _x( 'PESAGOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3565' => _x( 'RIMMONIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3641' => _x( 'SHILO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3652' => _x( 'BET ARYE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3709' => _x( 'MEVO HORON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3655' => _x( 'NILI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL075' => [
		'IL3786' => _x( 'AVENAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3556' => _x( 'ALMOG', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3645' => _x( 'BET HAARAVA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3639' => _x( 'WERED YERIHO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3576' => _x( 'MIZPE YERIHO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3610' => _x( 'MIZPE SHALEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3785' => _x( 'MASKIYYOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3713' => _x( 'NAAMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3601' => _x( 'QALYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3782' => _x( 'ROTEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3598' => _x( 'ARGAMAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3612' => _x( 'BEQAOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3613' => _x( 'GITTIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3606' => _x( 'GILGAL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3646' => _x( 'NAHAL HEMDAT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3609' => _x( 'HAMRA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3607' => _x( 'YITAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3566' => _x( 'YAFIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3599' => _x( 'MEHOLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3614' => _x( 'MEKHORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3608' => _x( 'MAALE EFRAYIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3605' => _x( 'MASSUA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3620' => _x( 'NIRAN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3555' => _x( 'NETIV HAGEDUD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3615' => _x( 'PEZAEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3619' => _x( 'ROI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3578' => _x( 'SHADMOT MEHOLA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3558' => _x( 'TOMER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL076' => [
		'IL3604' => _x( 'ALLON SHEVUT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3618' => _x( 'ELAZAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3650' => _x( 'EFRATA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3780' => _x( 'BETAR ILLIT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3794' => _x( 'BAT AYIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3603' => _x( 'HAR GILLO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3488' => _x( 'KEFAR EZYON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3561' => _x( 'MIGDAL OZ', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3616' => _x( 'MAALE ADUMMIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3653' => _x( 'MAALE AMOS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3725' => _x( 'NEWE DANIYYEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3726' => _x( 'NOQEDIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3781' => _x( 'QEDAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3602' => _x( 'ROSH ZURIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3563' => _x( 'TEQOA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'IL077' => [
		'IL3743' => _x( 'TENE', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3759' => _x( 'ADORA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3754' => _x( 'ASEFAR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3722' => _x( 'ESHKOLOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3400' => _x( 'HEBRON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3764' => _x( 'HAGGAI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3766' => _x( 'KARME ZUR', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3656' => _x( 'KARMEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3657' => _x( 'MAON', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3745' => _x( 'MEZADOT YEHUDA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3724' => _x( 'NEGOHOT', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3756' => _x( 'SUSEYA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3748' => _x( 'OTNIEL', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3723' => _x( 'PENE HEVER', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3611' => _x( 'QIRYAT ARBA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3784' => _x( 'SHIMA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3719' => _x( 'TELEM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3822' => _x( 'RAHELIM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1365' => _x( 'ELIAV', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1374' => _x( 'KARMEI KATIF', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3777' => _x( 'SANSANA', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1377' => _x( 'SHAVE DAROM', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL4035' => _x( 'NIMROD', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3823' => _x( 'GANEI MODIIN', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3825' => _x( 'MEVOOT YERIHO', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL3824' => _x( 'AMIHAI', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
		'IL1336' => _x( 'IRUS', 'IL-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
