<?php

/**
 * List of cities for: Indonesia
 * Source: https://github.com/digitalheir/Indonesia-Census-2010
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['ID'];

$country_cities = [
	'AC' => [
		'ID11110' => 'TEUPAH SELATAN',
		'ID11120' => 'SIMEULUE TIMUR',
		'ID11121' => 'TEUPAH BARAT',
		'ID11130' => 'SIMEULUE TENGAH',
		'ID11131' => 'TELUK DALAM',
		'ID11140' => 'SALANG',
		'ID11150' => 'SIMEULUE BARAT',
		'ID11151' => 'ALAFAN',
		'ID11210' => 'PULAU BANYAK',
		'ID11220' => 'SINGKIL',
		'ID11221' => 'SINGKIL UTARA',
		'ID11222' => 'KUALA BARU',
		'ID11230' => 'SIMPANG KANAN',
		'ID11231' => 'GUNUNG MERIAH',
		'ID11232' => 'DANAU PARIS',
		'ID11233' => 'SURO',
		'ID11242' => 'SINGKOHOR',
		'ID11243' => 'KOTA BAHARU',
		'ID11310' => 'TRUMON',
		'ID11311' => 'TRUMON TIMUR',
		'ID11320' => 'BAKONGAN',
		'ID11321' => 'BAKONGAN TIMUR',
		'ID11330' => 'KLUET SELATAN',
		'ID11331' => 'KLUET TIMUR',
		'ID11340' => 'KLUET UTARA',
		'ID11341' => 'PASIE RAJA',
		'ID11342' => 'KLUET TENGAH',
		'ID11350' => 'TAPAK TUAN',
		'ID11360' => 'SAMA DUA',
		'ID11370' => 'SAWANG',
		'ID11380' => 'MEUKEK',
		'ID11390' => 'LABUHAN HAJI',
		'ID11391' => 'LABUHAN HAJI TIMUR',
		'ID11392' => 'LABUHAN HAJI BARAT',
		'ID11410' => 'LAWE ALAS',
		'ID11411' => 'BABUL RAHMAD',
		'ID11412' => 'TANOH ALAS',
		'ID11420' => 'LAWE SIGALA-GALA',
		'ID11421' => 'BABUL MAKMUR',
		'ID11422' => 'SEMADAM',
		'ID11423' => 'LAUSER',
		'ID11430' => 'BAMBEL',
		'ID11431' => 'BUKIT TUSAM',
		'ID11432' => 'LAWE SUMUR',
		'ID11440' => 'BABUSSALAM',
		'ID11441' => 'LAWE BULAN',
		'ID11450' => 'BADAR',
		'ID11451' => 'DARUL HASANAH',
		'ID11452' => 'KETAMBE',
		'ID11453' => 'DELENG POKHKISEN',
		'ID11580' => 'SERBA JADI',
		'ID11581' => 'SIMPANG JERNIH',
		'ID11582' => 'PEUNARON',
		'ID11590' => 'BIREM BAYEUN',
		'ID115100' => 'RANTAU SELAMAT',
		'ID115101' => 'SUNGAI RAYA',
		'ID115110' => 'PEUREULAK',
		'ID115111' => 'PEUREULAK TIMUR',
		'ID115112' => 'PEUREULAK BARAT',
		'ID115120' => 'RANTO PEUREULAK',
		'ID115130' => 'IDI RAYEUK',
		'ID115131' => 'PEUDAWA',
		'ID115132' => 'BANDA ALAM',
		'ID115133' => 'IDI TUNONG',
		'ID115134' => 'DARUL IHSAN',
		'ID115135' => 'IDI TIMUR',
		'ID115140' => 'DARUL AMAN',
		'ID115150' => 'NURUSSALAM',
		'ID115151' => 'DARUL FALAH',
		'ID115160' => 'JULOK',
		'ID115161' => 'INDRA MAKMUR',
		'ID115170' => 'PANTE BIDARI',
		'ID115180' => 'SIMPANG ULIM',
		'ID115181' => 'MADAT',
		'ID11610' => 'LINGE',
		'ID11611' => 'ATU LINTANG',
		'ID11612' => 'JAGONG JEGET',
		'ID11620' => 'BINTANG',
		'ID11631' => 'LUT TAWAR',
		'ID11632' => 'KEBAYAKAN',
		'ID11640' => 'PEGASING',
		'ID11641' => 'BIES',
		'ID11650' => 'BEBESEN',
		'ID11651' => 'KUTE PANANG',
		'ID11660' => 'SILIH NARA',
		'ID11661' => 'KETOL',
		'ID11662' => 'CELALA',
		'ID11663' => 'RUSIP ANTARA',
		'ID11750' => 'JOHAN PAHLAWAN',
		'ID11760' => 'SAMATIGA',
		'ID11761' => 'BUBON',
		'ID11762' => 'ARONGAN LAMBALEK',
		'ID11770' => 'WOYLA',
		'ID11771' => 'WOYLA BARAT',
		'ID11772' => 'WOYLA TIMUR',
		'ID11780' => 'KAWAY XVI',
		'ID11781' => 'MEUREUBO',
		'ID11782' => 'PANTAI CEUREMEN',
		'ID11783' => 'PANTON REU',
		'ID11790' => 'SUNGAI MAS',
		'ID11810' => 'LHOONG',
		'ID11820' => 'LHONGA',
		'ID11821' => 'LEUPUNG',
		'ID11830' => 'INDRAPURI',
		'ID11831' => 'KUTA COT GLIE',
		'ID11840' => 'SEULIMEUM',
		'ID11841' => 'KOTA JANTHO',
		'ID11842' => 'LEMBAH SEULAWAH',
		'ID11850' => 'MESJID RAYA',
		'ID11860' => 'DARUSSALAM',
		'ID11861' => 'BAITUSSALAM',
		'ID11870' => 'KUTA BARO',
		'ID11880' => 'MONTASIK',
		'ID11881' => 'BLANG BINTANG',
		'ID11890' => 'INGIN JAYA',
		'ID11891' => 'KRUENG BARONA JAYA',
		'ID118100' => 'SUKA MAKMUR',
		'ID118101' => 'KUTA MALAKA',
		'ID118102' => 'SIMPANG TIGA',
		'ID118110' => 'DARUL IMARAH',
		'ID118111' => 'DARUL KAMAL',
		'ID118120' => 'PEUKAN BADA',
		'ID118130' => 'PULO ACEH',
		'ID11910' => 'GEUMPANG',
		'ID11911' => 'MANE',
		'ID11970' => 'GLUMPANG TIGA',
		'ID11971' => 'GLUMPANG BARO',
		'ID11980' => 'MUTIARA',
		'ID11981' => 'MUTIARA TIMUR',
		'ID11990' => 'TIRO/TRUSEB',
		'ID119100' => 'TANGSE',
		'ID119111' => 'KEUMALA',
		'ID119112' => 'TITEUE',
		'ID119120' => 'SAKTI',
		'ID119130' => 'MILA',
		'ID119140' => 'PADANG TIJI',
		'ID119150' => 'DELIMA',
		'ID119151' => 'GRONG GRONG',
		'ID119160' => 'INDRAJAYA',
		'ID119170' => 'PEUKAN BARO',
		'ID119180' => 'KEMBANG TANJONG',
		'ID119190' => 'SIMPANG TIGA',
		'ID119200' => 'KOTA SIGLI',
		'ID119210' => 'PIDIE',
		'ID119220' => 'BATEE',
		'ID119230' => 'MUARA TIGA',
		'ID111010' => 'SAMALANGA',
		'ID111011' => 'SIMPANG MAMPLAM',
		'ID111020' => 'PANDRAH',
		'ID111030' => 'JEUNIEB',
		'ID111031' => 'PEULIMBANG',
		'ID111040' => 'PEUDADA',
		'ID111050' => 'JULI',
		'ID111060' => 'JEUMPA',
		'ID111061' => 'KOTA JUANG',
		'ID111062' => 'KUALA',
		'ID111070' => 'JANGKA',
		'ID111080' => 'PEUSANGAN',
		'ID111081' => 'PEUSANGAN SELATAN',
		'ID111082' => 'PEUSANGAN SIBLAH KRUENG',
		'ID111090' => 'MAKMUR',
		'ID1110100' => 'GANDA PURA',
		'ID1110101' => 'KUTA BLANG',
		'ID111110' => 'SAWANG',
		'ID111120' => 'NISAM',
		'ID111121' => 'NISAM ANTARA',
		'ID111122' => 'BANDA BARO',
		'ID111130' => 'KUTA MAKMUR',
		'ID111131' => 'SIMPANG KERAMAT',
		'ID111140' => 'SYAMTALIRA BAYU',
		'ID111141' => 'GEUREUDONG PASE',
		'ID111150' => 'MEURAH MULIA',
		'ID111160' => 'MATANGKULI',
		'ID111161' => 'PAYA BAKONG',
		'ID111162' => 'PIRAK TIMU',
		'ID111170' => 'COT GIREK',
		'ID111180' => 'TANAH JAMBO AYE',
		'ID111181' => 'LANGKAHAN',
		'ID111190' => 'SEUNUDON',
		'ID1111100' => 'BAKTIYA',
		'ID1111101' => 'BAKTIYA BARAT',
		'ID1111110' => 'LHOKSUKON',
		'ID1111120' => 'TANAH LUAS',
		'ID1111121' => 'NIBONG',
		'ID1111130' => 'SAMUDERA',
		'ID1111140' => 'SYAMTALIRA ARON',
		'ID1111150' => 'TANAH PASIR',
		'ID1111151' => 'LAPANG',
		'ID1111160' => 'MUARA BATU',
		'ID1111170' => 'DEWANTARA',
		'ID111210' => 'MANGGENG',
		'ID111211' => 'LEMBAH SABIL',
		'ID111220' => 'TANGAN-TANGAN',
		'ID111221' => 'SETIA',
		'ID111230' => 'BLANG PIDIE',
		'ID111231' => 'JEUMPA',
		'ID111240' => 'SUSOH',
		'ID111250' => 'KUALA BATEE',
		'ID111260' => 'BABAH ROT',
		'ID111310' => 'KUTA PANJANG',
		'ID111311' => 'BLANG JERANGO',
		'ID111320' => 'BLANGKEJEREN',
		'ID111321' => 'PUTRI BETUNG',
		'ID111322' => 'DABUN GELANG',
		'ID111323' => 'BLANG PEGAYON',
		'ID111330' => 'PINING',
		'ID111340' => 'RIKIT GAIB',
		'ID111341' => 'PANTAN CUACA',
		'ID111350' => 'TERANGUN',
		'ID111351' => 'TRIPE JAYA',
		'ID111410' => 'TAMIANG HULU',
		'ID111411' => 'BANDAR PUSAKA',
		'ID111420' => 'KEJURUAN MUDA',
		'ID111421' => 'TENGGULUN',
		'ID111430' => 'RANTAU',
		'ID111440' => 'KOTA KUALA SIMPANG',
		'ID111450' => 'SEURUWAY',
		'ID111460' => 'BENDAHARA',
		'ID111461' => 'BANDA MULIA',
		'ID111470' => 'KARANG BARU',
		'ID111471' => 'SEKERAK',
		'ID111480' => 'MANYAK PAYED',
		'ID111510' => 'DARUL MAKMUR',
		'ID111520' => 'KUALA',
		'ID111521' => 'KUALA PESISIR',
		'ID111522' => 'TADU RAYA',
		'ID111530' => 'BEUTONG',
		'ID111540' => 'SEUNAGAN',
		'ID111541' => 'SUKA MAKMUE',
		'ID111550' => 'SEUNAGAN TIMUR',
		'ID111610' => 'TEUNOM',
		'ID111620' => 'PANGA',
		'ID111630' => 'KRUENG SABEE',
		'ID111640' => 'SETIA BAKTI',
		'ID111650' => 'SAMPOINIET',
		'ID111660' => 'JAYA',
		'ID111710' => 'TIMANG GAJAH',
		'ID111720' => 'PINTU RIME GAYO',
		'ID111730' => 'BUKIT',
		'ID111740' => 'WIH PESAM',
		'ID111750' => 'BANDAR',
		'ID111760' => 'SYIAH UTAMA',
		'ID111770' => 'PERMATA',
		'ID111810' => 'MEUREUDU',
		'ID111820' => 'MEURAH DUA',
		'ID111830' => 'BANDAR DUA',
		'ID111840' => 'JANGKA BUYA',
		'ID111850' => 'ULIM',
		'ID111860' => 'TRIENGGADENG',
		'ID111870' => 'PANTERAJA',
		'ID111880' => 'BANDAR BARU',
		'ID117110' => 'MEURAXA',
		'ID117111' => 'JAYA BARU',
		'ID117112' => 'BANDA RAYA',
		'ID117120' => 'BAITURRAHMAN',
		'ID117121' => 'LUENG BATA',
		'ID117130' => 'KUTA ALAM',
		'ID117131' => 'KUTA RAJA',
		'ID117140' => 'SYIAH KUALA',
		'ID117141' => 'ULEE KARENG',
		'ID117210' => 'SUKAJAYA',
		'ID117220' => 'SUKAKARYA',
		'ID117310' => 'LANGSA TIMUR',
		'ID117311' => 'LANGSA LAMA',
		'ID117320' => 'LANGSA BARAT',
		'ID117321' => 'LANGSA BARO',
		'ID117330' => 'LANGSA KOTA',
		'ID117410' => 'BLANG MANGAT',
		'ID117420' => 'MUARA DUA',
		'ID117421' => 'MUARA SATU',
		'ID117430' => 'BANDA SAKTI',
		'ID117510' => 'SIMPANG KIRI',
		'ID117520' => 'PENANGGALAN',
		'ID117530' => 'RUNDENG',
		'ID117540' => 'SULTAN DAULAT',
		'ID117550' => 'LONGKIB',
	],
	'SU' => [
		'ID12160' => 'IDANO GAWO',
		'ID12161' => 'BAWOLATO',
		'ID12162' => 'ULUGAWO',
		'ID12170' => 'GIDO',
		'ID12181' => 'MA U',
		'ID12182' => 'SOMOLO - MOLO',
		'ID121130' => 'HILIDUHO',
		'ID121131' => 'HILI SERANGKAI',
		'ID121132' => 'BOTOMUZOI',
		'ID12210' => 'BATAHAN',
		'ID12211' => 'SINUNUKAN',
		'ID12220' => 'BATANG NATAL',
		'ID12221' => 'LINGGA BAYU',
		'ID12222' => 'RANTO BAEK',
		'ID12230' => 'KOTANOPAN',
		'ID12231' => 'ULU PUNGKUT',
		'ID12232' => 'TAMBANGAN',
		'ID12233' => 'LEMBAH SORIK MARAPI',
		'ID12234' => 'PUNCAK SORIK MARAPI',
		'ID12240' => 'MUARA SIPONGI',
		'ID12241' => 'PAKANTAN',
		'ID12250' => 'PANYABUNGAN',
		'ID12251' => 'PANYABUNGAN SELATAN',
		'ID12252' => 'PANYABUNGAN BARAT',
		'ID12253' => 'PANYABUNGAN UTARA',
		'ID12254' => 'PANYABUNGAN TIMUR',
		'ID12255' => 'HUTA BARGOT',
		'ID12260' => 'NATAL',
		'ID12270' => 'MUARA BATANG GADIS',
		'ID12280' => 'SIABU',
		'ID12281' => 'BUKIT MALINTANG',
		'ID12282' => 'NAGA JUANG',
		'ID12310' => 'BATANG ANGKOLA',
		'ID12311' => 'SAYUR MATINGGI',
		'ID12370' => 'ANGKOLA TIMUR',
		'ID12380' => 'ANGKOLA SELATAN',
		'ID12390' => 'ANGKOLA BARAT',
		'ID123100' => 'BATANG TORU',
		'ID123101' => 'MARANCAR',
		'ID123102' => 'MUARA BATANG TORU',
		'ID123110' => 'SIPIROK',
		'ID123120' => 'ARSE',
		'ID123160' => 'SAIPAR DOLOK HOLE',
		'ID123161' => 'AEK BILAH',
		'ID12410' => 'PINANG SORI',
		'ID12411' => 'BADIRI',
		'ID12420' => 'SIBABANGUN',
		'ID12421' => 'LUMUT',
		'ID12422' => 'SUKABANGUN',
		'ID12430' => 'PANDAN',
		'ID12431' => 'TUKKA',
		'ID12432' => 'SARUDIK',
		'ID12440' => 'TAPIAN NAULI',
		'ID12441' => 'SITAHUIS',
		'ID12450' => 'KOLANG',
		'ID12460' => 'SORKAM',
		'ID12461' => 'SORKAM BARAT',
		'ID12462' => 'PASARIBU TOBING',
		'ID12470' => 'BARUS',
		'ID12471' => 'SOSOR GADONG',
		'ID12472' => 'ANDAM DEWI',
		'ID12473' => 'BARUS UTARA',
		'ID12480' => 'MANDUAMAS',
		'ID12481' => 'SIRANDORUNG',
		'ID12530' => 'PARMONANGAN',
		'ID12540' => 'ADIAN KOTING',
		'ID12550' => 'SIPOHOLON',
		'ID12560' => 'TARUTUNG',
		'ID12561' => 'SIATAS BARITA',
		'ID12570' => 'PAHAE JULU',
		'ID12580' => 'PAHAE JAE',
		'ID12581' => 'PURBATUA',
		'ID12582' => 'SIMANGUMBAN',
		'ID12590' => 'PANGARIBUAN',
		'ID125100' => 'GAROGA',
		'ID125110' => 'SIPAHUTAR',
		'ID125120' => 'SIBORONG-BORONG',
		'ID125130' => 'PAGARAN',
		'ID125180' => 'MUARA',
		'ID12630' => 'BALIGE',
		'ID12631' => 'TAMPAHAN',
		'ID12640' => 'LAGU BOTI',
		'ID12650' => 'HABINSARAN',
		'ID12651' => 'BORBOR',
		'ID12652' => 'NASSAU',
		'ID12660' => 'SILAEN',
		'ID12661' => 'SIGUMPAR',
		'ID12670' => 'PORSEA',
		'ID12671' => 'PINTU POHAN MERANTI',
		'ID12672' => 'SIANTAR NARUMONDA',
		'ID12673' => 'PARMAKSIAN',
		'ID12680' => 'LUMBAN JULU',
		'ID12681' => 'ULUAN',
		'ID12682' => 'AJIBATA',
		'ID12683' => 'BONATUA LUNASI',
		'ID12750' => 'BILAH HULU',
		'ID12770' => 'PANGKATAN',
		'ID12780' => 'BILAH BARAT',
		'ID127130' => 'BILAH HILIR',
		'ID127140' => 'PANAI HULU',
		'ID127150' => 'PANAI TENGAH',
		'ID127160' => 'PANAI HILIR',
		'ID127210' => 'RANTAU SELATAN',
		'ID127220' => 'RANTAU UTARA',
		'ID12810' => 'BANDAR PASIR MANDOGE',
		'ID12820' => 'BANDAR PULAU',
		'ID12821' => 'AEK SONGSONGAN',
		'ID12822' => 'RAHUNING',
		'ID12830' => 'PULAU RAKYAT',
		'ID12831' => 'AEK KUASAN',
		'ID12832' => 'AEK LEDONG',
		'ID12840' => 'SEI KEPAYANG',
		'ID12841' => 'SEI KEPAYANG BARAT',
		'ID12842' => 'SEI KEPAYANG TIMUR',
		'ID12850' => 'TANJUNG BALAI',
		'ID12860' => 'SIMPANG EMPAT',
		'ID12861' => 'TELUK DALAM',
		'ID12870' => 'AIR BATU',
		'ID12871' => 'SEI DADAP',
		'ID12880' => 'BUNTU PANE',
		'ID12881' => 'TINGGI RAJA',
		'ID12882' => 'SETIA JANJI',
		'ID12890' => 'MERANTI',
		'ID12891' => 'PULO BANDRING',
		'ID12892' => 'RAWANG PANCA ARGA',
		'ID128100' => 'AIR JOMAN',
		'ID128101' => 'SILAU LAUT',
		'ID128160' => 'KISARAN BARAT',
		'ID128170' => 'KISARAN TIMUR',
		'ID12910' => 'SILIMAKUTA',
		'ID12911' => 'PEMATANG SILIMAHUTA',
		'ID12920' => 'PURBA',
		'ID12921' => 'HARANGGAOL HORISON',
		'ID12930' => 'DOLOK PARDAMEAN',
		'ID12940' => 'SIDAMANIK',
		'ID12941' => 'PEMATANG SIDAMANIK',
		'ID12950' => 'GIRSANG SIPANGAN BOLON',
		'ID12960' => 'TANAH JAWA',
		'ID12961' => 'HATONDUHAN',
		'ID12970' => 'DOLOK PANRIBUAN',
		'ID12980' => 'JORLANG HATARAN',
		'ID12990' => 'PANEI',
		'ID12991' => 'PANOMBEAN PANEI',
		'ID129100' => 'RAYA',
		'ID129110' => 'DOLOK SILAU',
		'ID129120' => 'SILAU KAHEAN',
		'ID129130' => 'RAYA KAHEAN',
		'ID129140' => 'TAPIAN DOLOK',
		'ID129150' => 'DOLOK BATU NANGGAR',
		'ID129160' => 'SIANTAR',
		'ID129161' => 'GUNUNG MALELA',
		'ID129162' => 'GUNUNG MALIGAS',
		'ID129170' => 'HUTABAYU RAJA',
		'ID129171' => 'JAWA MARAJA BAH JAMBI',
		'ID129180' => 'PEMATANG BANDAR',
		'ID129181' => 'BANDAR HULUAN',
		'ID129190' => 'BANDAR',
		'ID129191' => 'BANDAR MASILAM',
		'ID129200' => 'BOSAR MALIGAS',
		'ID129210' => 'UJUNG PADANG',
		'ID121030' => 'SIDIKALANG',
		'ID121031' => 'BERAMPU',
		'ID121032' => 'SITINJO',
		'ID121040' => 'PARBULUAN',
		'ID121050' => 'SUMBUL',
		'ID121051' => 'SILAHI SABUNGAN',
		'ID121060' => 'SILIMA PUNGGA-PUNGGA',
		'ID121061' => 'LAE PARIRA',
		'ID121070' => 'SIEMPAT NEMPU',
		'ID121080' => 'SIEMPAT NEMPU HULU',
		'ID121090' => 'SIEMPAT NEMPU HILIR',
		'ID1210100' => 'TIGA LINGGA',
		'ID1210101' => 'GUNUNG SITEMBER',
		'ID1210110' => 'PEGAGAN HILIR',
		'ID1210120' => 'TANAH PINEM',
		'ID121110' => 'MARDINGDING',
		'ID121120' => 'LAUBALENG',
		'ID121130' => 'TIGA BINANGA',
		'ID121140' => 'JUHAR',
		'ID121150' => 'MUNTE',
		'ID121160' => 'KUTA BULUH',
		'ID121170' => 'PAYUNG',
		'ID121171' => 'TIGANDERKET',
		'ID121180' => 'SIMPANG EMPAT',
		'ID121181' => 'NAMAN TERAN',
		'ID121182' => 'MERDEKA',
		'ID121190' => 'KABANJAHE',
		'ID1211100' => 'BERASTAGI',
		'ID1211110' => 'TIGAPANAH',
		'ID1211111' => 'DOLAT RAYAT',
		'ID1211120' => 'MEREK',
		'ID1211130' => 'BARUSJAHE',
		'ID121210' => 'GUNUNG MERIAH',
		'ID121220' => 'SINEMBAH TANJUNG MUDA HULU',
		'ID121230' => 'SIBOLANGIT',
		'ID121240' => 'KUTALIMBARU',
		'ID121250' => 'PANCUR BATU',
		'ID121260' => 'NAMO RAMBE',
		'ID121270' => 'BIRU-BIRU',
		'ID121280' => 'SINEMBAH TANJUNG MUDA HILIR',
		'ID121290' => 'BANGUN PURBA',
		'ID1212190' => 'GALANG',
		'ID1212200' => 'TANJUNG MORAWA',
		'ID1212210' => 'PATUMBAK',
		'ID1212220' => 'DELI TUA',
		'ID1212230' => 'SUNGGAL',
		'ID1212240' => 'HAMPARAN PERAK',
		'ID1212250' => 'LABUHAN DELI',
		'ID1212260' => 'PERCUT SEI TUAN',
		'ID1212270' => 'BATANG KUIS',
		'ID1212280' => 'PANTAI LABU',
		'ID1212290' => 'BERINGIN',
		'ID1212300' => 'LUBUK PAKAM',
		'ID1212310' => 'PAGAR MERBAU',
		'ID121310' => 'BOHOROK',
		'ID121311' => 'SERAPIT',
		'ID121320' => 'SALAPIAN',
		'ID121321' => 'KUTAMBARU',
		'ID121330' => 'SEI BINGAI',
		'ID121340' => 'KUALA',
		'ID121350' => 'SELESAI',
		'ID121360' => 'BINJAI',
		'ID121370' => 'STABAT',
		'ID121380' => 'WAMPU',
		'ID121390' => 'BATANG SERANGAN',
		'ID1213100' => 'SAWIT SEBERANG',
		'ID1213110' => 'PADANG TUALANG',
		'ID1213120' => 'HINAI',
		'ID1213130' => 'SECANGGANG',
		'ID1213140' => 'TANJUNG PURA',
		'ID1213150' => 'GEBANG',
		'ID1213160' => 'BABALAN',
		'ID1213170' => 'SEI LEPAN',
		'ID1213180' => 'BRANDAN BARAT',
		'ID1213190' => 'BESITANG',
		'ID1213200' => 'PANGKALAN SUSU',
		'ID1213201' => 'PEMATANG JAYA',
		'ID121410' => 'HIBALA',
		'ID121420' => 'PULAU-PULAU BATU',
		'ID121421' => 'PULAU-PULAU BATU TIMUR',
		'ID121430' => 'TELUK DALAM',
		'ID121431' => 'FANAYAMA',
		'ID121432' => 'TOMA',
		'ID121433' => 'MANIAMOLO',
		'ID121434' => 'MAZINO',
		'ID121440' => 'AMANDRAYA',
		'ID121441' => 'ARAMO',
		'ID121450' => 'LAHUSA',
		'ID121460' => 'GOMO',
		'ID121461' => 'SUSUA',
		'ID121462' => 'MAZO',
		'ID121463' => 'UMBUNASI',
		'ID121470' => 'LOLOMATUA',
		'ID121480' => 'LOLOWAU',
		'ID121481' => 'HILIMEGAI',
		'ID121510' => 'PAKKAT',
		'ID121520' => 'ONAN GANJANG',
		'ID121530' => 'SIJAMA POLANG',
		'ID121540' => 'DOLOK SANGGUL',
		'ID121550' => 'LINTONG NIHUTA',
		'ID121560' => 'PARANGINAN',
		'ID121570' => 'BAKTI RAJA',
		'ID121580' => 'POLLUNG',
		'ID121590' => 'PARLILITAN',
		'ID1215100' => 'TARA BINTANG',
		'ID121610' => 'SALAK',
		'ID121611' => 'SITELLU TALI URANG JEHE',
		'ID121612' => 'PAGINDAR',
		'ID121613' => 'SITELLU TALI URANG JULU',
		'ID121614' => 'PERGETTENG-GETTENG SENGKUT',
		'ID121620' => 'KERAJAAN',
		'ID121621' => 'TINADA',
		'ID121622' => 'SIEMPAT RUBE',
		'ID121710' => 'SIANJUR MULA MULA',
		'ID121720' => 'HARIAN',
		'ID121730' => 'SITIO-TIO',
		'ID121740' => 'ONAN RUNGGU',
		'ID121750' => 'NAINGGOLAN',
		'ID121760' => 'PALIPI',
		'ID121770' => 'RONGGUR NIHUTA',
		'ID121780' => 'PANGURURAN',
		'ID121790' => 'SIMANINDO',
		'ID121810' => 'KOTARIH',
		'ID121811' => 'SILINDA',
		'ID121812' => 'BINTANG BAYU',
		'ID121820' => 'DOLOK MASIHUL',
		'ID121821' => 'SERBAJADI',
		'ID121830' => 'SIPISPIS',
		'ID121840' => 'DOLOK MERAWAN',
		'ID121850' => 'TEBINGTINGGI',
		'ID121851' => 'TEBING SYAHBANDAR',
		'ID121860' => 'BANDAR KHALIPAH',
		'ID121870' => 'TANJUNG BERINGIN',
		'ID121880' => 'SEI RAMPAH',
		'ID121881' => 'SEI BAMBAN',
		'ID121890' => 'TELUK MENGKUDU',
		'ID1218100' => 'PERBAUNGAN',
		'ID1218101' => 'PEGAJAHAN',
		'ID1218110' => 'PANTAI CERMIN',
		'ID121910' => 'SEI BALAI',
		'ID121920' => 'TANJUNG TIRAM',
		'ID121930' => 'TALAWI',
		'ID121940' => 'LIMAPULUH',
		'ID121950' => 'AIR PUTIH',
		'ID121960' => 'SEI SUKA',
		'ID121970' => 'MEDANG DERAS',
		'ID122010' => 'BATANG ONANG',
		'ID122020' => 'PADANG BOLAK JULU',
		'ID122030' => 'PORTIBI',
		'ID122040' => 'PADANG BOLAK',
		'ID122050' => 'SIMANGAMBAT',
		'ID122060' => 'HALONGONAN',
		'ID122070' => 'DOLOK',
		'ID122080' => 'DOLOK SIGOMPULON',
		'ID122090' => 'HULU SIHAPAS',
		'ID122110' => 'SOSOPAN',
		'ID122120' => 'ULU BARUMUN',
		'ID122130' => 'BARUMUN',
		'ID122140' => 'LUBUK BARUMUN',
		'ID122150' => 'SOSA',
		'ID122160' => 'BATANG LUBU SUTAM',
		'ID122170' => 'HUTA RAJA TINGGI',
		'ID122180' => 'HURISTAK',
		'ID122190' => 'BARUMUN TENGAH',
		'ID122210' => 'SUNGAI KANAN',
		'ID122220' => 'TORGAMBA',
		'ID122230' => 'KOTA PINANG',
		'ID122240' => 'SILANGKITANG',
		'ID122250' => 'KAMPUNG RAKYAT',
		'ID122310' => 'NA IX-X',
		'ID122320' => 'MARBAU',
		'ID122330' => 'AEK KUO',
		'ID122340' => 'AEK NATAS',
		'ID122350' => 'KUALUH SELATAN',
		'ID122360' => 'KUALUH HILIR',
		'ID122370' => 'KUALUH HULU',
		'ID122380' => 'KUALUH LEIDONG',
		'ID122410' => 'TUGALA OYO',
		'ID122420' => 'ALASA',
		'ID122430' => 'ALASA TALU MUZOI',
		'ID122440' => 'NAMOHALU ESIWA',
		'ID122450' => 'SITOLU ORI',
		'ID122460' => 'TUHEMBERUA',
		'ID122470' => 'SAWO',
		'ID122480' => 'LOTU',
		'ID122490' => 'LAHEWA TIMUR',
		'ID1224100' => 'AFULU',
		'ID1224110' => 'LAHEWA',
		'ID122510' => 'SIROMBU',
		'ID122520' => 'LAHOMI',
		'ID122530' => 'ULU MORO O',
		'ID122540' => 'LOLOFITU MOI',
		'ID122550' => 'MANDREHE UTARA',
		'ID122560' => 'MANDREHE',
		'ID122570' => 'MANDREHE BARAT',
		'ID122580' => 'MORO O',
		'ID127110' => 'SIBOLGA UTARA',
		'ID127120' => 'SIBOLGA KOTA',
		'ID127130' => 'SIBOLGA SELATAN',
		'ID127131' => 'SIBOLGA SAMBAS',
		'ID127210' => 'DATUK BANDAR',
		'ID127211' => 'DATUK BANDAR TIMUR',
		'ID127220' => 'TANJUNG BALAI SELATAN',
		'ID127230' => 'TANJUNG BALAI UTARA',
		'ID127240' => 'SEI TUALANG RASO',
		'ID127250' => 'TELUK NIBUNG',
		'ID127310' => 'SIANTAR MARIHAT',
		'ID127311' => 'SIANTAR MARIMBUN',
		'ID127320' => 'SIANTAR SELATAN',
		'ID127330' => 'SIANTAR BARAT',
		'ID127340' => 'SIANTAR UTARA',
		'ID127350' => 'SIANTAR TIMUR',
		'ID127360' => 'SIANTAR MARTOBA',
		'ID127361' => 'SIANTAR SITALASARI',
		'ID127410' => 'PADANG HULU',
		'ID127411' => 'TEBING TINGGI KOTA',
		'ID127420' => 'RAMBUTAN',
		'ID127421' => 'BAJENIS',
		'ID127430' => 'PADANG HILIR',
		'ID127510' => 'MEDAN TUNTUNGAN',
		'ID127520' => 'MEDAN JOHOR',
		'ID127530' => 'MEDAN AMPLAS',
		'ID127540' => 'MEDAN DENAI',
		'ID127550' => 'MEDAN AREA',
		'ID127560' => 'MEDAN KOTA',
		'ID127570' => 'MEDAN MAIMUN',
		'ID127580' => 'MEDAN POLONIA',
		'ID127590' => 'MEDAN BARU',
		'ID1275100' => 'MEDAN SELAYANG',
		'ID1275110' => 'MEDAN SUNGGAL',
		'ID1275120' => 'MEDAN HELVETIA',
		'ID1275130' => 'MEDAN PETISAH',
		'ID1275140' => 'MEDAN BARAT',
		'ID1275150' => 'MEDAN TIMUR',
		'ID1275160' => 'MEDAN PERJUANGAN',
		'ID1275170' => 'MEDAN TEMBUNG',
		'ID1275180' => 'MEDAN DELI',
		'ID1275190' => 'MEDAN LABUHAN',
		'ID1275200' => 'MEDAN MARELAN',
		'ID1275210' => 'MEDAN KOTA BELAWAN',
		'ID127610' => 'BINJAI SELATAN',
		'ID127620' => 'BINJAI KOTA',
		'ID127630' => 'BINJAI TIMUR',
		'ID127640' => 'BINJAI UTARA',
		'ID127650' => 'BINJAI BARAT',
		'ID127710' => 'PADANGSIDIMPUAN TENGGARA',
		'ID127720' => 'PADANGSIDIMPUAN SELATAN',
		'ID127730' => 'PADANGSIDIMPUAN BATUNADUA',
		'ID127740' => 'PADANGSIDIMPUAN UTARA',
		'ID127750' => 'PADANGSIDIMPUAN HUTAIMBARU',
		'ID127751' => 'PADANGSIDIMPUAN ANGKOLA JULU',
		'ID127810' => 'GUNUNGSITOLI IDANOI',
		'ID127820' => 'GUNUNGSITOLI SELATAN',
		'ID127830' => 'GUNUNGSITOLI BARAT',
		'ID127840' => 'GUNUNG SITOLI',
		'ID127850' => 'GUNUNGSITOLI ALO OA',
		'ID127860' => 'GUNUNGSITOLI UTARA',
	],
	'SB' => [
		'ID13111' => 'PAGAI SELATAN',
		'ID13112' => 'SIKAKAP',
		'ID13113' => 'PAGAI UTARA',
		'ID13121' => 'SIPORA SELATAN',
		'ID13122' => 'SIPORA UTARA',
		'ID13130' => 'SIBERUT SELATAN',
		'ID13131' => 'SEBERUT BARAT DAYA',
		'ID13132' => 'SIBERUT TENGAH',
		'ID13140' => 'SIBERUT UTARA',
		'ID13141' => 'SIBERUT BARAT',
		'ID13210' => 'LUNANG SILAUT',
		'ID13220' => 'BASA AMPEK BALAI TAPAN',
		'ID13230' => 'PANCUNG SOAL',
		'ID13240' => 'LINGGO SARI BAGANTI',
		'ID13250' => 'RANAH PESISIR',
		'ID13260' => 'LENGAYANG',
		'ID13270' => 'SUTERA',
		'ID13280' => 'BATANG KAPAS',
		'ID13290' => 'IV JURAI',
		'ID132100' => 'BAYANG',
		'ID132101' => 'IV NAGARI BAYANG UTARA',
		'ID132110' => 'KOTO XI TARUSAN',
		'ID13340' => 'PANTAI CERMIN',
		'ID13350' => 'LEMBAH GUMANTI',
		'ID13351' => 'HILIRAN GUMANTI',
		'ID13360' => 'PAYUNG SEKAKI',
		'ID13361' => 'TIGO LURAH BAJANJANG',
		'ID13370' => 'LEMBANG JAYA',
		'ID13371' => 'DANAU KEMBAR',
		'ID13380' => 'GUNUNG TALANG',
		'ID13390' => 'BUKIT SUNDI',
		'ID133100' => 'IX KOTO SUNGAI LASI',
		'ID133110' => 'KUBUNG',
		'ID133120' => 'X KOTO DIATAS',
		'ID133130' => 'X KOTO SINGKARAK',
		'ID133140' => 'JUNJUNG SIRIH',
		'ID13450' => 'KAMANG BARU',
		'ID13460' => 'TANJUNG GADANG',
		'ID13470' => 'SIJUNJUNG',
		'ID13471' => 'LUBUK TAROK',
		'ID13480' => 'IV NAGARI',
		'ID13490' => 'KUPITAN',
		'ID134100' => 'KOTO TUJUH',
		'ID134110' => 'SUMPUR KUDUS',
		'ID13510' => 'SEPULUH KOTO',
		'ID13520' => 'BATIPUH',
		'ID13521' => 'BATIPUH SELATAN',
		'ID13530' => 'PARIANGAN',
		'ID13540' => 'RAMBATAN',
		'ID13550' => 'LIMA KAUM',
		'ID13560' => 'TANJUNG EMAS',
		'ID13570' => 'PADANG GANTING',
		'ID13580' => 'LINTAU BUO',
		'ID13581' => 'LINTAU BUO UTARA',
		'ID13590' => 'SUNGAYANG',
		'ID135100' => 'SUNGAI TARAB',
		'ID135110' => 'SALIMPAUNG',
		'ID135111' => 'TANJUNG BARU',
		'ID13610' => 'BATANG ANAI',
		'ID13620' => 'LUBUK ALUNG',
		'ID13621' => 'SINTUK TOBOH GADANG',
		'ID13630' => 'ULAKAN TAPAKIS',
		'ID13640' => 'NAN SABARIS',
		'ID13650' => 'ENAM LINGKUNG',
		'ID13652' => 'KAYU TANAM',
		'ID13660' => 'VII KOTO SUNGAI SARIAK',
		'ID13661' => 'PATAMUAN',
		'ID13662' => 'PADANG SAGO',
		'ID13670' => 'V KOTO KP DALAM',
		'ID13671' => 'V KOTO TIMUR',
		'ID13680' => 'SUNGAI LIMAU',
		'ID13681' => 'BATANG GASAN',
		'ID13690' => 'SUNGAI GERINGGING',
		'ID136100' => 'IV KOTO AUR MALINTANG',
		'ID13710' => 'TANJUNG MUTIARA',
		'ID13720' => 'LUBUK BASUNG',
		'ID13721' => 'IV NAGARI',
		'ID13730' => 'TANJUNG RAYA',
		'ID13740' => 'MATUR',
		'ID13750' => 'IV KOTO',
		'ID13751' => 'MALALAK',
		'ID13761' => 'BANUHAMPU',
		'ID13762' => 'SUNGAI PUA',
		'ID13770' => 'IV ANGKAT CANDUNG',
		'ID13771' => 'CANDUANG',
		'ID13780' => 'BASO',
		'ID13790' => 'TILATANG KAMANG',
		'ID13791' => 'KAMANG MAGEK',
		'ID137100' => 'PALEMBAYAN',
		'ID137110' => 'PALUPUH',
		'ID13810' => 'PAYAKUMBUH',
		'ID13811' => 'AKABILURU',
		'ID13820' => 'LUAK',
		'ID13821' => 'LAREH SAGO HALABAN',
		'ID13822' => 'SITUJUAH LIMO NAGARI',
		'ID13830' => 'HARAU',
		'ID13840' => 'GUGUAK',
		'ID13841' => 'MUNGKA',
		'ID13850' => 'SULIKI',
		'ID13851' => 'BUKIK BARISAN',
		'ID13860' => 'GUNUANG OMEH',
		'ID13870' => 'KAPUR IX',
		'ID13880' => 'PANGKALAN KOTO BARU',
		'ID13970' => 'BONJOL',
		'ID13971' => 'TIGO NAGARI',
		'ID13972' => 'SIMPANG ALAHAN MATI',
		'ID13980' => 'LUBUK SIKAPING',
		'ID139100' => 'DUA KOTO',
		'ID139110' => 'PANTI',
		'ID139111' => 'PADANG GELUGUR',
		'ID139121' => 'RAO',
		'ID139122' => 'MAPAT TUNGGUL',
		'ID139123' => 'MAPAT TUNGGUL SELATAN',
		'ID139124' => 'RAO SELATAN',
		'ID139125' => 'RAO UTARA',
		'ID131010' => 'SANGIR',
		'ID131020' => 'SANGIR JUJUAN',
		'ID131021' => 'SANGIR BALAI JANGGO',
		'ID131030' => 'SANGIR BATANG HARI',
		'ID131040' => 'SUNGAI PAGU',
		'ID131041' => 'PAUAH DUO',
		'ID131050' => 'KOTO PARIK GADANG DIATEH',
		'ID131110' => 'SUNGAI RUMBAI',
		'ID131111' => 'KOTO BESAR',
		'ID131112' => 'ASAM JUJUHAN',
		'ID131120' => 'KOTO BARU',
		'ID131121' => 'KOTO SALAK',
		'ID131122' => 'TIUMANG',
		'ID131123' => 'PADANG LAWEH',
		'ID131130' => 'SITIUNG',
		'ID131131' => 'TIMPEH',
		'ID131140' => 'PULAU PUNJUNG',
		'ID131141' => 'IX KOTO',
		'ID131210' => 'SUNGAI BEREMAS',
		'ID131220' => 'RANAH BATAHAN',
		'ID131230' => 'KOTO BALINGKA',
		'ID131240' => 'SUNGAI AUR',
		'ID131250' => 'LEMBAH MALINTANG',
		'ID131260' => 'GUNUNG TULEH',
		'ID131270' => 'TALAMAU',
		'ID131280' => 'PASAMAN',
		'ID131290' => 'LUHAK NAN DUO',
		'ID1312100' => 'SASAK RANAH PASISIE',
		'ID1312110' => 'KINALI',
		'ID137110' => 'BUNGUS TELUK KABUNG',
		'ID137120' => 'LUBUK KILANGAN',
		'ID137130' => 'LUBUK BEGALUNG',
		'ID137140' => 'PADANG SELATAN',
		'ID137150' => 'PADANG TIMUR',
		'ID137160' => 'PADANG BARAT',
		'ID137170' => 'PADANG UTARA',
		'ID137180' => 'NANGGALO',
		'ID137190' => 'KURANJI',
		'ID1371100' => 'PAUH',
		'ID1371110' => 'KOTO TANGAH',
		'ID137210' => 'LUBUK SIKARAH',
		'ID137220' => 'TANJUNG HARAPAN',
		'ID137310' => 'SILUNGKANG',
		'ID137320' => 'LEMBAH SEGAR',
		'ID137330' => 'BARANGIN',
		'ID137340' => 'TALAWI',
		'ID137410' => 'PADANG PANJANG BARAT',
		'ID137420' => 'PADANG PANJANG TIMUR',
		'ID137510' => 'GUGUK PANJANG',
		'ID137520' => 'MANDIANGIN KOTO SELAYAN',
		'ID137530' => 'AUR BIRUGO TIGO BALEH',
		'ID137610' => 'PAYAKUMBUH BARAT',
		'ID137611' => 'PAYAKUMBUH SELATAN',
		'ID137620' => 'PAYAKUMBUH TIMUR',
		'ID137630' => 'PAYAKUMBUH UTARA',
		'ID137631' => 'PAYAKUMBUH LAMPOSI TIGO NAGORI',
		'ID137710' => 'PARIAMAN SELATAN',
		'ID137720' => 'PARIAMAN TENGAH',
		'ID137721' => 'PARIAMAN TIMUR',
		'ID137730' => 'PARIAMAN UTARA',
	],
	'RI' => [
		'ID14110' => 'KUANTAN MUDIK',
		'ID14111' => 'HULU KUANTAN',
		'ID14112' => 'GUNUNG TOAR',
		'ID14120' => 'SINGINGI',
		'ID14121' => 'SINGINGI HILIR',
		'ID14130' => 'KUANTAN TENGAH',
		'ID14140' => 'BENAI',
		'ID14150' => 'KUANTAN HILIR',
		'ID14151' => 'PANGEAN',
		'ID14152' => 'LOGAS TANAH DARAT',
		'ID14160' => 'CERENTI',
		'ID14161' => 'INUMAN',
		'ID14210' => 'PERANAP',
		'ID14211' => 'BATANG PERANAP',
		'ID14220' => 'SEBERIDA',
		'ID14221' => 'BATANG CENAKU',
		'ID14222' => 'BATANG GANSAL',
		'ID14230' => 'KELAYANG',
		'ID14231' => 'RAKIT KULIM',
		'ID14240' => 'PASIR PENYU',
		'ID14241' => 'LIRIK',
		'ID14242' => 'SUNGAI LALA',
		'ID14243' => 'LUBUK BATU JAYA',
		'ID14250' => 'RENGAT BARAT',
		'ID14260' => 'RENGAT',
		'ID14261' => 'KUALA CENAKU',
		'ID14310' => 'KERITANG',
		'ID14311' => 'KEMUNING',
		'ID14320' => 'RETEH',
		'ID14321' => 'SUNGAI BATANG',
		'ID14330' => 'ENOK',
		'ID14340' => 'TANAH MERAH',
		'ID14350' => 'KUALA INDRAGIRI',
		'ID14351' => 'CONCONG',
		'ID14360' => 'TEMBILAHAN',
		'ID14361' => 'TEMBILAHAN HULU',
		'ID14370' => 'TEMPULING',
		'ID14371' => 'KEMPAS',
		'ID14380' => 'BATANG TUAKA',
		'ID14390' => 'GAUNG ANAK SERKA',
		'ID143100' => 'GAUNG',
		'ID143110' => 'MANDAH',
		'ID143120' => 'KATEMAN',
		'ID143121' => 'PELANGIRAN',
		'ID143122' => 'TELUK BELENGKONG',
		'ID143123' => 'PULAU BURUNG',
		'ID14410' => 'LANGGAM',
		'ID14411' => 'PANGKALAN KERINCI',
		'ID14412' => 'BANDAR SEIKIJANG',
		'ID14420' => 'PANGKALAN KURAS',
		'ID14421' => 'UKUI',
		'ID14422' => 'PANGKALAN LESUNG',
		'ID14430' => 'BUNUT',
		'ID14431' => 'PELALAWAN',
		'ID14432' => 'BANDAR PETALANGAN',
		'ID14440' => 'KUALA KAMPAR',
		'ID14441' => 'KERUMUTAN',
		'ID14442' => 'TELUK MERANTI',
		'ID14510' => 'MINAS',
		'ID14511' => 'SUNGAI MANDAU',
		'ID14512' => 'KANDIS',
		'ID14520' => 'SIAK',
		'ID14521' => 'KERINCI KANAN',
		'ID14522' => 'TUALANG',
		'ID14523' => 'DAYUN',
		'ID14524' => 'LUBUK DALAM',
		'ID14525' => 'KOTO GASIB',
		'ID14526' => 'MEMPURA',
		'ID14530' => 'SUNGAI APIT',
		'ID14531' => 'BUNGA RAYA',
		'ID14532' => 'SABAK AUH',
		'ID14533' => 'PUSAKO',
		'ID14610' => 'KAMPAR KIRI',
		'ID14611' => 'KAMPAR KIRI HULU',
		'ID14612' => 'KAMPAR KIRI HILIR',
		'ID14613' => 'GUNUNG SAHILAN',
		'ID14614' => 'KAMPAR KIRI TENGAH',
		'ID14620' => 'XIII KOTO KAMPAR',
		'ID14630' => 'BANGKINANG BARAT',
		'ID14631' => 'SALO',
		'ID14640' => 'TAPUNG',
		'ID14641' => 'TAPUNG HULU',
		'ID14642' => 'TAPUNG HILIR',
		'ID14650' => 'BANGKINANG',
		'ID14651' => 'BANGKINANG SEBERANG',
		'ID14660' => 'KAMPAR',
		'ID14661' => 'KAMPAR TIMUR',
		'ID14662' => 'RUMBIO JAYA',
		'ID14663' => 'KAMPAR UTARA',
		'ID14670' => 'TAMBANG',
		'ID14680' => 'SIAK HULU',
		'ID14681' => 'PERHENTIAN RAJA',
		'ID14710' => 'ROKAN IV KOTO',
		'ID14711' => 'PENDALIAN IV KOTO',
		'ID14720' => 'TANDUN',
		'ID14721' => 'KABUN',
		'ID14722' => 'UJUNG BATU',
		'ID14730' => 'RAMBAH SAMO',
		'ID14740' => 'RAMBAH',
		'ID14741' => 'RAMBAH HILIR',
		'ID14742' => 'BANGUN PURBA',
		'ID14750' => 'TAMBUSAI',
		'ID14751' => 'TAMBUSAI UTARA',
		'ID14760' => 'KEPENUHAN',
		'ID14761' => 'KEPENUHAN HULU',
		'ID14770' => 'KUNTO DARUSSALAM',
		'ID14771' => 'PAGARAN TAPAH DARUSSALAM',
		'ID14772' => 'BONAI DARUSSALAM',
		'ID14810' => 'MANDAU',
		'ID14811' => 'PINGGIR',
		'ID14820' => 'BUKIT BATU',
		'ID14821' => 'SIAK KECIL',
		'ID14830' => 'RUPAT',
		'ID14831' => 'RUPAT UTARA',
		'ID14840' => 'BENGKALIS',
		'ID14850' => 'BANTAN',
		'ID14910' => 'TANAH PUTIH',
		'ID14911' => 'PUJUD',
		'ID14912' => 'TANAH PUTIH TANJUNG MELAWAN',
		'ID14913' => 'RANTAU KOPAR',
		'ID14920' => 'BAGAN SINEMBAH',
		'ID14921' => 'SIMPANG KANAN',
		'ID14930' => 'KUBU',
		'ID14931' => 'PASIR LIMAU KAPAS',
		'ID14940' => 'BANGKO',
		'ID14941' => 'SINABOI',
		'ID14942' => 'BATU HAMPAR',
		'ID14950' => 'RIMBA MELINTANG',
		'ID14951' => 'BANGKO PUSAKO',
		'ID141010' => 'TEBING TINGGI BARAT',
		'ID141020' => 'TEBING TINGGI',
		'ID141030' => 'RANGSANG',
		'ID141040' => 'RANGSANG BARAT',
		'ID141050' => 'MERBAU',
		'ID147110' => 'TAMPAN',
		'ID147111' => 'PAYUNG SEKAKI',
		'ID147120' => 'BUKIT RAYA',
		'ID147121' => 'MARPOYAN DAMAI',
		'ID147122' => 'TENAYAN RAYA',
		'ID147130' => 'LIMAPULUH',
		'ID147140' => 'SAIL',
		'ID147150' => 'PEKANBARU KOTA',
		'ID147160' => 'SUKAJADI',
		'ID147170' => 'SENAPELAN',
		'ID147180' => 'RUMBAI',
		'ID147181' => 'RUMBAI PESISIR',
		'ID147310' => 'BUKIT KAPUR',
		'ID147311' => 'MEDANG KAMPAI',
		'ID147312' => 'SUNGAI SEMBILAN',
		'ID147320' => 'DUMAI BARAT',
		'ID147330' => 'DUMAI TIMUR',
	],
	'JA' => [
		'ID15110' => 'GUNUNG RAYA',
		'ID15120' => 'BATANG MERANGIN',
		'ID15130' => 'KELILING DANAU',
		'ID15140' => 'DANAU KERINCI',
		'ID15150' => 'SITINJAU LAUT',
		'ID15170' => 'AIR HANGAT',
		'ID15171' => 'AIR HANGAT TIMUR',
		'ID15172' => 'DEPATI VII',
		'ID15180' => 'GUNUNG KERINCI',
		'ID15181' => 'SIULAK',
		'ID15190' => 'KAYU ARO',
		'ID15191' => 'GUNUNG TUJUH',
		'ID15210' => 'JANGKAT',
		'ID15211' => 'SUNGAI TENANG',
		'ID15220' => 'MUARA SIAU',
		'ID15221' => 'LEMBAH MASURAI',
		'ID15222' => 'TIANG PUMPUNG',
		'ID15230' => 'PAMENANG',
		'ID15231' => 'PAMENANG BARAT',
		'ID15232' => 'RENAH PAMENANG',
		'ID15233' => 'PAMENANG SELATAN',
		'ID15240' => 'BANGKO',
		'ID15241' => 'BANGKO BARAT',
		'ID15242' => 'NALO TANTAN',
		'ID15243' => 'BATANG MASUMAI',
		'ID15250' => 'SUNGAI MANAU',
		'ID15251' => 'RENAH PEMBARAP',
		'ID15252' => 'PANGKALAN JAMBU',
		'ID15260' => 'TABIR',
		'ID15261' => 'TABIR ULU',
		'ID15262' => 'TABIR SELATAN',
		'ID15263' => 'TABIR ILIR',
		'ID15264' => 'TABIR TIMUR',
		'ID15265' => 'TABIR LINTAS',
		'ID15266' => 'MARGO TABIR',
		'ID15267' => 'TABIR BARAT',
		'ID15310' => 'BATANG ASAI',
		'ID15320' => 'LIMUN',
		'ID15321' => 'CERMIN NAN GEDANG',
		'ID15330' => 'PELAWAN',
		'ID15331' => 'SINGKUT',
		'ID15340' => 'SAROLANGUN',
		'ID15341' => 'BATHIN VIII',
		'ID15350' => 'PAUH',
		'ID15351' => 'AIR HITAM',
		'ID15360' => 'MANDIANGIN',
		'ID15410' => 'MERSAM',
		'ID15411' => 'MARO SEBO ULU',
		'ID15420' => 'BATIN XXIV',
		'ID15430' => 'MUARA TEMBESI',
		'ID15440' => 'MUARA BULIAN',
		'ID15441' => 'BAJUBANG',
		'ID15442' => 'MARO SEBO ILIR',
		'ID15450' => 'PEMAYUNG',
		'ID15510' => 'MESTONG',
		'ID15511' => 'SUNGAI BAHAR',
		'ID15520' => 'KUMPEH ULU',
		'ID15521' => 'SUNGAI GELAM',
		'ID15530' => 'KUMPEH',
		'ID15540' => 'MARO SEBO',
		'ID15550' => 'JAMBI LUAR KOTA',
		'ID15560' => 'SEKERNAN',
		'ID15610' => 'MENDAHARA',
		'ID15611' => 'MENDAHARA ULU',
		'ID15612' => 'GERAGAI',
		'ID15620' => 'DENDANG',
		'ID15631' => 'MUARA SABAK BARAT',
		'ID15632' => 'MUARA SABAK TIMUR',
		'ID15633' => 'KUALA JAMBI',
		'ID15640' => 'RANTAU RASAU',
		'ID15641' => 'BERBAK',
		'ID15650' => 'NIPAH PANJANG',
		'ID15660' => 'SADU',
		'ID15710' => 'TUNGKAL ULU',
		'ID15711' => 'MERLUNG',
		'ID15712' => 'BATANG ASAM',
		'ID15713' => 'TEBING TINGGI',
		'ID15714' => 'RENAH MENDALUH',
		'ID15715' => 'MUARA PAPALIK',
		'ID15720' => 'PENGABUAN',
		'ID15721' => 'SENYERANG',
		'ID15730' => 'TUNGKAL ILIR',
		'ID15731' => 'BRAM ITAM',
		'ID15732' => 'SEBERANG KOTA',
		'ID15740' => 'BETARA',
		'ID15741' => 'KUALA BETARA',
		'ID15810' => 'TEBO ILIR',
		'ID15811' => 'MUARA TABIR',
		'ID15820' => 'TEBO TENGAH',
		'ID15821' => 'SUMAY',
		'ID15822' => 'TENGAH ILIR',
		'ID15830' => 'RIMBO BUJANG',
		'ID15831' => 'RIMBO ULU',
		'ID15832' => 'RIMBO ILIR',
		'ID15840' => 'TEBO ULU',
		'ID15841' => 'VII KOTO',
		'ID15842' => 'SERAI SERUMPUN',
		'ID15843' => 'VII KOTO ILIR',
		'ID15910' => 'PELEPAT',
		'ID15911' => 'PELEPAT ILIR',
		'ID15921' => 'BATHIN II BABEKO',
		'ID15922' => 'RIMBO TENGAH',
		'ID15923' => 'BUNGO DANI',
		'ID15924' => 'PASAR MUARA BUNGO',
		'ID15925' => 'BATHIN III',
		'ID15930' => 'RANTAU PANDAN',
		'ID15931' => 'MUKO-MUKO BATHIN VII',
		'ID15932' => 'BATHIN III ULU',
		'ID15940' => 'TANAH SEPENGGAL',
		'ID15941' => 'TANAH SEPENGGAL LINTAS',
		'ID15950' => 'TANAH TUMBUH',
		'ID15951' => 'LIMBUR LUBUK MENGKUANG',
		'ID15952' => 'BATHIN II PELAYANG',
		'ID15960' => 'JUJUHAN',
		'ID15961' => 'JUJUHAN ILIR',
		'ID157110' => 'KOTA BARU',
		'ID157120' => 'JAMBI SELATAN',
		'ID157130' => 'JELUTUNG',
		'ID157140' => 'PASAR JAMBI',
		'ID157150' => 'TELANAIPURA',
		'ID157160' => 'DANAU TELUK',
		'ID157170' => 'PELAYANGAN',
		'ID157180' => 'JAMBI TIMUR',
		'ID157210' => 'TANAH KAMPUNG',
		'ID157220' => 'KUMUN DEBAI',
		'ID157230' => 'SUNGAI PENUH',
		'ID157240' => 'HAMPARAN RAWANG',
		'ID157250' => 'PESISIR BUKIT',
	],
	'SS' => [
		'ID16152' => 'LENGKITI',
		'ID16170' => 'SOSOH BUAY RAYAP',
		'ID16180' => 'PENGANDONAN',
		'ID16181' => 'SEMIDANG AJI',
		'ID16182' => 'ULU OGAN',
		'ID16183' => 'MUARA JAYA',
		'ID16190' => 'PENINJAUAN',
		'ID16191' => 'LUBUK BATANG',
		'ID16192' => 'SINAR PENINJAUAN',
		'ID161130' => 'BATU RAJA TIMUR',
		'ID161131' => 'LUBUK RAJA',
		'ID161140' => 'BATU RAJA BARAT',
		'ID16210' => 'LEMPUING',
		'ID16211' => 'LEMPUING JAYA',
		'ID16220' => 'MESUJI',
		'ID16221' => 'SUNGAI MENANG',
		'ID16222' => 'MESUJI MAKMUR',
		'ID16223' => 'MESUJI RAYA',
		'ID16230' => 'TULUNG SELAPAN',
		'ID16231' => 'CENGAL',
		'ID16240' => 'PEDAMARAN',
		'ID16241' => 'PEDAMARAN TIMUR',
		'ID16250' => 'TANJUNG LUBUK',
		'ID16251' => 'TELUK GELAM',
		'ID16260' => 'KOTA KAYU AGUNG',
		'ID162120' => 'SIRAH PULAU PADANG',
		'ID162121' => 'JEJAWI',
		'ID162130' => 'PAMPANGAN',
		'ID162131' => 'PANGKALAN LAPAM',
		'ID162140' => 'AIR SUGIHAN',
		'ID16310' => 'SEMENDO DARAT LAUT',
		'ID16311' => 'SEMENDO DARAT ULU',
		'ID16312' => 'SEMENDO DARAT TENGAH',
		'ID16320' => 'TANJUNG AGUNG',
		'ID16331' => 'RAMBANG',
		'ID16332' => 'LUBAI',
		'ID16340' => 'LAWANG KIDUL',
		'ID16350' => 'MUARA ENIM',
		'ID16351' => 'UJAN MAS',
		'ID16360' => 'GUNUNG MEGANG',
		'ID16361' => 'BENAKAT',
		'ID16370' => 'RAMBANG DANGKU',
		'ID16380' => 'TALANG UBI',
		'ID16381' => 'PENUKAL',
		'ID16382' => 'TANAH ABANG',
		'ID16383' => 'PENUKAL UTARA',
		'ID16384' => 'ABAB',
		'ID16390' => 'GELUMBANG',
		'ID16391' => 'LEMBAK',
		'ID16392' => 'SUNGAI ROTAN',
		'ID16393' => 'MUARA BELIDA',
		'ID16394' => 'KELEKAR',
		'ID16411' => 'TANJUNG SAKTI PUMI',
		'ID16412' => 'TANJUNG SAKTI PUMU',
		'ID16440' => 'KOTA AGUNG',
		'ID16441' => 'MULAK ULU',
		'ID16442' => 'TANJUNG TEBAT',
		'ID16450' => 'PULAU PINANG',
		'ID16451' => 'PAGAR GUNUNG',
		'ID16452' => 'GUMAY ULU',
		'ID16460' => 'JARAI',
		'ID16461' => 'PAJAR BULAN',
		'ID16462' => 'MUARA PAYANG',
		'ID164111' => 'KIKIM BARAT',
		'ID164112' => 'KIKIM TIMUR',
		'ID164113' => 'KIKIM SELATAN',
		'ID164114' => 'KIKIM TENGAH',
		'ID164120' => 'LAHAT',
		'ID164121' => 'GUMAY TALANG',
		'ID164122' => 'PSEKSU',
		'ID164131' => 'MERAPI BARAT',
		'ID164132' => 'MERAPI TIMUR',
		'ID164133' => 'MERAPI SELATAN',
		'ID16510' => 'RAWAS ULU',
		'ID16511' => 'ULU RAWAS',
		'ID16520' => 'RUPIT',
		'ID16521' => 'KARANG JAYA',
		'ID16530' => 'SUKU TENGAH LAKITAN ULU',
		'ID16531' => 'SELANGIT',
		'ID16532' => 'SUMBER HARTA',
		'ID16540' => 'TUGU MULYO',
		'ID16541' => 'PURWODADI',
		'ID16550' => 'MUARA BELITI',
		'ID16551' => 'TIANG PUMPUNG KEPUNGUT',
		'ID16560' => 'JAYA LOKA',
		'ID16561' => 'SUKA KARYA',
		'ID16570' => 'MUARA KELINGI',
		'ID16571' => 'BULAN TENGAH SUKU ULU',
		'ID16572' => 'TUAH NEGERI',
		'ID16580' => 'MUARA LAKITAN',
		'ID16590' => 'MEGANG SAKTI',
		'ID165100' => 'RAWAS ILIR',
		'ID165101' => 'KARANG DAPO',
		'ID165102' => 'NIBUNG',
		'ID16610' => 'SANGA DESA',
		'ID16620' => 'BABAT TOMAN',
		'ID16621' => 'BATANGHARI LEKO',
		'ID16622' => 'PLAKAT TINGGI',
		'ID16630' => 'SUNGAI KERUH',
		'ID16640' => 'SEKAYU',
		'ID16641' => 'LAIS',
		'ID16690' => 'SUNGAI LILIN',
		'ID16691' => 'KELUANG',
		'ID166100' => 'BAYUNG LENCIR',
		'ID166101' => 'LALAN',
		'ID16710' => 'RANTAU BAYUR',
		'ID16720' => 'BETUNG',
		'ID16730' => 'PULAU RIMAU',
		'ID16731' => 'TUNGKAL ILIR',
		'ID16740' => 'BANYUASIN III',
		'ID16750' => 'TALANG KELAPA',
		'ID16751' => 'TANJUNG LAGO',
		'ID16760' => 'BANYUASIN I',
		'ID16770' => 'RAMBUTAN',
		'ID16780' => 'MUARA PADANG',
		'ID16781' => 'MUARA SUGIHAN',
		'ID16790' => 'MAKARTI JAYA',
		'ID16791' => 'AIR SALEK',
		'ID167100' => 'BANYUASIN II',
		'ID167110' => 'MUARA TELANG',
		'ID16810' => 'MEKAKAU ILIR',
		'ID16820' => 'BANDING AGUNG',
		'ID16821' => 'WARKUK RANAU SELATAN',
		'ID16822' => 'BUAY PEMATANG RIBU RANAU TENGAH',
		'ID16830' => 'BUAY PEMACA',
		'ID16840' => 'SIMPANG',
		'ID16841' => 'BUANA PEMACA',
		'ID16850' => 'MUARADUA',
		'ID16851' => 'BUAY RAWAN',
		'ID16860' => 'BUAY SANDANG AJI',
		'ID16861' => 'TIGA DIHAJI',
		'ID16870' => 'BUAY RUNJUNG',
		'ID16871' => 'RUNJUNG AGUNG',
		'ID16880' => 'KISAM TINGGI',
		'ID16890' => 'MUARADUA KISAM',
		'ID16891' => 'KISAM ILIR',
		'ID168100' => 'PULAU BERINGIN',
		'ID168101' => 'SINDANG DANAU',
		'ID168102' => 'SUNGAI ARE',
		'ID16910' => 'MARTAPURA',
		'ID16911' => 'BUNGA MAYANG',
		'ID16912' => 'JAYA PURA',
		'ID16920' => 'BUAY PEMUKA PELIUNG',
		'ID16930' => 'BUAY MADANG',
		'ID16931' => 'BUAY MADANG TIMUR',
		'ID16932' => 'BUAY PEMUKA BANGSA RAJA',
		'ID16940' => 'MADANG SUKU II',
		'ID16941' => 'MADANG SUKU III',
		'ID16950' => 'MADANG SUKU I',
		'ID16951' => 'BELITANG MADANG RAYA',
		'ID16960' => 'BELITANG',
		'ID16961' => 'BELITANG JAYA',
		'ID16970' => 'BELITANG III',
		'ID16980' => 'BELITANG II',
		'ID16981' => 'BELITANG MULYA',
		'ID16990' => 'SEMENDAWAI SUKU III',
		'ID16991' => 'SEMENDAWAI TIMUR',
		'ID169100' => 'CEMPAKA',
		'ID169101' => 'SEMENDAWAI BARAT',
		'ID161010' => 'MUARA KUANG',
		'ID161011' => 'RAMBANG KUANG',
		'ID161012' => 'LUBUK KELIAT',
		'ID161020' => 'TANJUNG BATU',
		'ID161021' => 'PAYARAMAN',
		'ID161030' => 'RANTAU ALAI',
		'ID161031' => 'KANDIS',
		'ID161040' => 'TANJUNG RAJA',
		'ID161041' => 'RANTAU PANJANG',
		'ID161042' => 'SUNGAI PINANG',
		'ID161050' => 'PEMULUTAN',
		'ID161051' => 'PEMULUTAN SELATAN',
		'ID161052' => 'PEMULUTAN BARAT',
		'ID161060' => 'INDRALAYA',
		'ID161061' => 'INDRALAYA UTARA',
		'ID161062' => 'INDRALAYA SELATAN',
		'ID161110' => 'MUARA PINANG',
		'ID161120' => 'LINTANG KANAN',
		'ID161130' => 'PENDOPO',
		'ID161140' => 'PASMA AIR KERUH',
		'ID161150' => 'ULU MUSI',
		'ID161160' => 'TALANG PADANG',
		'ID161170' => 'TEBING TINGGI',
		'ID167110' => 'ILIR BARAT II',
		'ID167111' => 'GANDUS',
		'ID167120' => 'SEBERANG ULU I',
		'ID167121' => 'KERTAPATI',
		'ID167130' => 'SEBERANG ULU II',
		'ID167131' => 'PLAJU',
		'ID167140' => 'ILIR BARAT I',
		'ID167141' => 'BUKIT KECIL',
		'ID167150' => 'ILIR TIMUR I',
		'ID167151' => 'KEMUNING',
		'ID167160' => 'ILIR TIMUR II',
		'ID167161' => 'KALIDONI',
		'ID167170' => 'SAKO',
		'ID167171' => 'SEMATANG BORANG',
		'ID167180' => 'SUKARAMI',
		'ID167181' => 'ALANG ALANG LEBAR',
		'ID167210' => 'RAMBANG KAPAK TENGAH',
		'ID167220' => 'PRABUMULIH TIMUR',
		'ID167221' => 'PRABUMULIH SELATAN',
		'ID167230' => 'PRABUMULIH BARAT',
		'ID167231' => 'PRABUMULIH UTARA',
		'ID167240' => 'CAMBAI',
		'ID167310' => 'DEMPO SELATAN',
		'ID167311' => 'DEMPO TENGAH',
		'ID167320' => 'DEMPO UTARA',
		'ID167330' => 'PAGAR ALAM SELATAN',
		'ID167340' => 'PAGAR ALAM UTARA',
		'ID167411' => 'LUBUK LINGGAU BARAT I',
		'ID167412' => 'LUBUK LINGGAU BARAT II',
		'ID167421' => 'LUBUK LINGGAU SELATAN I',
		'ID167422' => 'LUBUK LINGGAU SELATAN II',
		'ID167431' => 'LUBUK LINGGAU TIMUR I',
		'ID167432' => 'LUBUK LINGGAU TIMUR II',
		'ID167441' => 'LUBUK LINGGAU UTARA I',
		'ID167442' => 'LUBUK LINGGAU UTARA II',
	],
	'BE' => [
		'ID17140' => 'MANNA',
		'ID17141' => 'KOTA MANNA',
		'ID17142' => 'KEDURANG',
		'ID17143' => 'BUNGA MAS',
		'ID17144' => 'PASAR MANNA',
		'ID17145' => 'KEDURANG ILIR',
		'ID17150' => 'SEGINIM',
		'ID17151' => 'AIR NIPIS',
		'ID17160' => 'PINO',
		'ID17161' => 'PINORAYA',
		'ID17162' => 'ULU MANNA',
		'ID17220' => 'KOTA PADANG',
		'ID17221' => 'SINDANG BELITI ILIR',
		'ID17230' => 'PADANG ULAK TANDING',
		'ID17231' => 'SINDANG KELINGI',
		'ID17232' => 'BINDU RIANG',
		'ID17233' => 'SINDANG BELITI ULU',
		'ID17234' => 'SINDANG DATARAN',
		'ID17240' => 'CURUP',
		'ID17241' => 'BERMANI ULU',
		'ID17242' => 'SELUPU REJANG',
		'ID17243' => 'CURUP SELATAN',
		'ID17244' => 'CURUP TENGAH',
		'ID17245' => 'BERMANI ULU RAYA',
		'ID17246' => 'CURUP UTARA',
		'ID17247' => 'CURUP TIMUR',
		'ID17310' => 'ENGGANO',
		'ID17350' => 'KERKAP',
		'ID17351' => 'AIR NAPAL',
		'ID17352' => 'AIR BESI',
		'ID17360' => 'ARGA MAKMUR',
		'ID17370' => 'LAIS',
		'ID17371' => 'BATIK NAU',
		'ID17372' => 'GIRI MULYA',
		'ID17380' => 'PADANG JAYA',
		'ID17390' => 'KETAHUN',
		'ID17391' => 'NAPAL PUTIH',
		'ID173100' => 'PUTRI HIJAU',
		'ID17410' => 'NASAL',
		'ID17420' => 'MAJE',
		'ID17430' => 'KAUR SELATAN',
		'ID17431' => 'TETAP',
		'ID17440' => 'KAUR TENGAH',
		'ID17441' => 'LUAS',
		'ID17442' => 'MUARA SAHUNG',
		'ID17450' => 'KINAL',
		'ID17451' => 'SEMIDANG GUMAY',
		'ID17460' => 'TANJUNG KEMUNING',
		'ID17461' => 'KELAM TENGAH',
		'ID17470' => 'KAUR UTARA',
		'ID17471' => 'PADANG GUCI HILIR',
		'ID17472' => 'LUNGKANG KULE',
		'ID17473' => 'PADANG GUCI HULU',
		'ID17510' => 'SEMIDANG ALAS MARAS',
		'ID17520' => 'SEMIDANG ALAS',
		'ID17530' => 'TALO',
		'ID17531' => 'ILIR TALO',
		'ID17532' => 'TALO KECIL',
		'ID17533' => 'ULU TALO',
		'ID17540' => 'SELUMA',
		'ID17541' => 'SELUMA SELATAN',
		'ID17542' => 'SELUMA BARAT',
		'ID17543' => 'SELUMA TIMUR',
		'ID17544' => 'SELUMA UTARA',
		'ID17550' => 'SUKARAJA',
		'ID17551' => 'AIR PERIUKAN',
		'ID17552' => 'LUBUK SANDI',
		'ID17610' => 'IPUH',
		'ID17611' => 'AIR RAMI',
		'ID17612' => 'MALIN DEMAN',
		'ID17620' => 'PONDOK SUGUH',
		'ID17621' => 'SUNGAI RUMBAI',
		'ID17622' => 'TERAMANG JAYA',
		'ID17630' => 'TERAS TERUNJAM',
		'ID17631' => 'PENARIK',
		'ID17632' => 'SELAGAN RAYA',
		'ID17640' => 'KOTA MUKOMUKO',
		'ID17641' => 'AIR DIKIT',
		'ID17642' => 'XIV KOTO',
		'ID17650' => 'LUBUK PINANG',
		'ID17651' => 'AIR MANJUNTO',
		'ID17652' => 'V KOTO',
		'ID17710' => 'RIMBO PENGADANG',
		'ID17711' => 'TOPOS',
		'ID17720' => 'LEBONG SELATAN',
		'ID17721' => 'BINGIN KUNING',
		'ID17730' => 'LEBONG TENGAH',
		'ID17731' => 'LEBONG SAKTI',
		'ID17740' => 'LEBONG ATAS',
		'ID17741' => 'PADANG BANO',
		'ID17742' => 'PELABAI',
		'ID17750' => 'LEBONG UTARA',
		'ID17751' => 'AMEN',
		'ID17752' => 'URAM JAYA',
		'ID17753' => 'PINANG BELAPIS',
		'ID17810' => 'MUARA KEMUMU',
		'ID17820' => 'BERMANI ILIR',
		'ID17830' => 'SEBERANG MUSI',
		'ID17840' => 'TEBAT KARAI',
		'ID17850' => 'KEPAHIANG',
		'ID17860' => 'KABA WETAN',
		'ID17870' => 'UJAN MAS',
		'ID17880' => 'MERIGI',
		'ID17910' => 'TALANG EMPAT',
		'ID17920' => 'KARANG TINGGI',
		'ID17930' => 'TABA PENANJUNG',
		'ID17931' => 'MERIGI KELINDANG',
		'ID17940' => 'PAGAR JATI',
		'ID17941' => 'MERIGI SAKTI',
		'ID17950' => 'PONDOK KELAPA',
		'ID17951' => 'PONDOK KUBANG',
		'ID17960' => 'PEMATANG TIGA',
		'ID17961' => 'BANG HAJI',
		'ID177110' => 'SELEBAR',
		'ID177111' => 'KAMPUNG MELAYU',
		'ID177120' => 'GADING CEMPAKA',
		'ID177121' => 'RATU AGUNG',
		'ID177122' => 'RATU SAMBAN',
		'ID177130' => 'TELUK SEGARA',
		'ID177131' => 'SUNGAI SERUT',
		'ID177140' => 'MUARA BANGKA HULU',
	],
	'LA' => [
		'ID18110' => 'PESISIR SELATAN',
		'ID18111' => 'BENGKUNAT',
		'ID18112' => 'BENGKUNAT BELIMBING',
		'ID18113' => 'NGAMBUR',
		'ID18120' => 'PESISIR TENGAH',
		'ID18121' => 'KARYA PENGGAWA',
		'ID18130' => 'PESISIR UTARA',
		'ID18131' => 'LEMONG',
		'ID18140' => 'BALIK BUKIT',
		'ID18141' => 'SUKAU',
		'ID18150' => 'BELALAU',
		'ID18151' => 'SEKINCAU',
		'ID18152' => 'SUOH',
		'ID18153' => 'BATU BRAK',
		'ID18160' => 'SUMBER JAYA',
		'ID18161' => 'WAY TENONG',
		'ID18162' => 'GEDUNG SURIAN',
		'ID18210' => 'WONOSOBO',
		'ID18211' => 'SEMAKA',
		'ID18212' => 'BANDAR NEGERI SEMUONG',
		'ID18220' => 'KOTA AGUNG',
		'ID18221' => 'PEMATANG SAWA',
		'ID18222' => 'KOTA AGUNG TIMUR',
		'ID18223' => 'KOTA AGUNG BARAT',
		'ID18230' => 'PULAU PANGGUNG',
		'ID18231' => 'ULUBELU',
		'ID18232' => 'AIR NANINGAN',
		'ID18240' => 'TALANG PADANG',
		'ID18241' => 'SUMBEREJO',
		'ID18242' => 'GISTING',
		'ID18243' => 'GUNUNG ALIP',
		'ID18250' => 'PUGUNG',
		'ID182101' => 'BULOK',
		'ID182110' => 'CUKUH BALAK',
		'ID182111' => 'KELUMBAYAN',
		'ID182112' => 'LIMAU',
		'ID182113' => 'KELUMBAYAN BARAT',
		'ID18360' => 'NATAR',
		'ID18370' => 'JATI AGUNG',
		'ID18380' => 'TANJUNG BINTANG',
		'ID18381' => 'TANJUNG SARI',
		'ID18390' => 'KATIBUNG',
		'ID18391' => 'MERBAU MATARAM',
		'ID18392' => 'WAY SULAN',
		'ID183100' => 'SIDOMULYO',
		'ID183101' => 'CANDIPURO',
		'ID183102' => 'WAY PANJI',
		'ID183110' => 'KALIANDA',
		'ID183111' => 'RAJABASA',
		'ID183120' => 'PALAS',
		'ID183121' => 'SRAGI',
		'ID183130' => 'PENENGAHAN',
		'ID183131' => 'KETAPANG',
		'ID183132' => 'BAKAUHENI',
		'ID18410' => 'METRO KIBANG',
		'ID18420' => 'BATANGHARI',
		'ID18430' => 'SEKAMPUNG',
		'ID18440' => 'MARGATIGA',
		'ID18450' => 'SEKAMPUNG UDIK',
		'ID18460' => 'JABUNG',
		'ID18461' => 'PASIR SAKTI',
		'ID18462' => 'WAWAY KARYA',
		'ID18463' => 'MARGA SEKAPUNG',
		'ID18470' => 'LABUHAN MARINGGAI',
		'ID18471' => 'MATARAM BARU',
		'ID18472' => 'BANDAR SRIBAWONO',
		'ID18473' => 'MELINTING',
		'ID18474' => 'GUNUNG PELINDUNG',
		'ID18480' => 'WAY JEPARA',
		'ID18481' => 'BRAJA SLEBAH',
		'ID18482' => 'LABUHAN RATU',
		'ID18490' => 'SUKADANA',
		'ID18491' => 'BUMI AGUNG',
		'ID18492' => 'BATANGHARI NUBAN',
		'ID184100' => 'PEKALONGAN',
		'ID184110' => 'RAMAN UTARA',
		'ID184120' => 'PURBOLINGGO',
		'ID184121' => 'WAY BUNGUR',
		'ID18510' => 'PADANG RATU',
		'ID18511' => 'SELAGAI LINGGA',
		'ID18512' => 'PUBIAN',
		'ID18513' => 'ANAK TUHA',
		'ID18514' => 'ANAK RATU AJI',
		'ID18520' => 'KALIREJO',
		'ID18521' => 'SENDANG AGUNG',
		'ID18530' => 'BANGUNREJO',
		'ID18540' => 'GUNUNG SUGIH',
		'ID18541' => 'BEKRI',
		'ID18542' => 'BUMI RATU NUBAN',
		'ID18550' => 'TRIMURJO',
		'ID18560' => 'PUNGGUR',
		'ID18561' => 'KOTA GAJAH',
		'ID18570' => 'SEPUTIH RAMAN',
		'ID18580' => 'TERBANGGI BESAR',
		'ID18581' => 'SEPUTIH AGUNG',
		'ID18582' => 'WAY PENGUBUAN',
		'ID18590' => 'TERUSAN NUNYAI',
		'ID185100' => 'SEPUTIH MATARAM',
		'ID185101' => 'BANDAR MATARAM',
		'ID185110' => 'SEPUTIH BANYAK',
		'ID185111' => 'WAY SEPUTIH',
		'ID185120' => 'RUMBIA',
		'ID185121' => 'BUMI NABUNG',
		'ID185122' => 'PUTRA RUMBIA',
		'ID185130' => 'SEPUTIH SURABAYA',
		'ID185131' => 'BANDAR SURABAYA',
		'ID18610' => 'BUKIT KEMUNING',
		'ID18611' => 'ABUNG TINGGI',
		'ID18620' => 'TANJUNG RAJA',
		'ID18630' => 'ABUNG BARAT',
		'ID18631' => 'ABUNG TENGAH',
		'ID18632' => 'ABUNG KUNANG',
		'ID18633' => 'ABUNG PEKURUN',
		'ID18640' => 'KOTABUMI',
		'ID18641' => 'KOTABUMI UTARA',
		'ID18642' => 'KOTABUMI SELATAN',
		'ID18650' => 'ABUNG SELATAN',
		'ID18651' => 'ABUNG SEMULI',
		'ID18652' => 'BLAMBANGAN PAGAR',
		'ID18660' => 'ABUNG TIMUR',
		'ID18661' => 'ABUNG SURAKARTA',
		'ID18670' => 'SUNGKAI SELATAN',
		'ID18671' => 'MUARA SUNGKAI',
		'ID18672' => 'BUNGA MAYANG',
		'ID18673' => 'SUNGKAI BARAT',
		'ID18674' => 'SUNGKAI JAYA',
		'ID18680' => 'SUNGKAI UTARA',
		'ID18681' => 'HULUSUNGKAI',
		'ID18682' => 'SUNGKAI TENGAH',
		'ID18710' => 'BANJIT',
		'ID18720' => 'BARADATU',
		'ID18721' => 'GUNUNG LABUHAN',
		'ID18730' => 'KASUI',
		'ID18731' => 'REBANG TANGKAS',
		'ID18740' => 'BLAMBANGAN UMPU',
		'ID18741' => 'WAY TUBA',
		'ID18742' => 'NEGERI AGUNG',
		'ID18750' => 'BAHUGA',
		'ID18751' => 'BUAY BAHUGA',
		'ID18752' => 'BUMI AGUNG',
		'ID18760' => 'PAKUAN RATU',
		'ID18761' => 'NEGARA BATIN',
		'ID18762' => 'NEGERI BESAR',
		'ID18830' => 'BANJAR AGUNG',
		'ID18831' => 'BANJAR MARGO',
		'ID18832' => 'BANJAR BARU',
		'ID18840' => 'GEDUNG AJI',
		'ID18841' => 'PENAWAR AJI',
		'ID18842' => 'MERAKSA AJI',
		'ID18850' => 'MENGGALA',
		'ID18851' => 'PENAWAR TAMA',
		'ID18852' => 'RAWAJITU SELATAN',
		'ID18853' => 'GEDUNG MENENG',
		'ID18854' => 'RAWAJITU TIMUR',
		'ID18855' => 'RAWA PITU',
		'ID18856' => 'GEDUNG AJI BARU',
		'ID18857' => 'DENTE TELADAS',
		'ID18858' => 'MENGGALA TIMUR',
		'ID18910' => 'PUNDUH PIDADA',
		'ID18920' => 'PADANG CERMIN',
		'ID18930' => 'KEDONDONG',
		'ID18940' => 'WAY LIMA',
		'ID18950' => 'GEDUNG TATAAN',
		'ID18960' => 'NEGERI KATON',
		'ID18970' => 'TEGINENENG',
		'ID181010' => 'PARDASUKA',
		'ID181020' => 'AMBARAWA',
		'ID181030' => 'PAGELARAN',
		'ID181040' => 'PRINGSEWU',
		'ID181050' => 'GADING REJO',
		'ID181060' => 'SUKOHARJO',
		'ID181070' => 'BANYUMAS',
		'ID181080' => 'ADI LUWIH',
		'ID181110' => 'WAY SERDANG',
		'ID181120' => 'SIMPANG PEMATANG',
		'ID181130' => 'PANCA JAYA',
		'ID181140' => 'TANJUNG RAYA',
		'ID181150' => 'MESUJI',
		'ID181160' => 'MESUJI TIMUR',
		'ID181170' => 'RAWAJITU UTARA',
		'ID181210' => 'TULANG BAWANG UDIK',
		'ID181220' => 'TUMI JAJAR',
		'ID181230' => 'TULANG BAWANG TENGAH',
		'ID181240' => 'PAGAR DEWA',
		'ID181250' => 'LAMBU KIBANG',
		'ID181260' => 'GUNUNG TERANG',
		'ID181270' => 'GUNUNG AGUNG',
		'ID181280' => 'WAY KENANGA',
		'ID187110' => 'TELUK BETUNG BARAT',
		'ID187120' => 'TELUK BETUNG SELATAN',
		'ID187130' => 'PANJANG',
		'ID187140' => 'TANJUNG KARANG TIMUR',
		'ID187150' => 'TELUK BETUNG UTARA',
		'ID187160' => 'TANJUNG KARANG PUSAT',
		'ID187170' => 'TANJUNG KARANG BARAT',
		'ID187171' => 'KEMILING',
		'ID187180' => 'KEDATON',
		'ID187181' => 'RAJABASA',
		'ID187182' => 'TANJUNG SENANG',
		'ID187190' => 'SUKARAME',
		'ID187191' => 'SUKABUMI',
		'ID187211' => 'METRO SELATAN',
		'ID187212' => 'METRO BARAT',
		'ID187221' => 'METRO TIMUR',
		'ID187222' => 'METRO PUSAT',
		'ID187223' => 'METRO UTARA',
	],
	'BB' => [
		'ID19170' => 'MENDO BARAT',
		'ID19180' => 'MERAWANG',
		'ID19181' => 'PUDING BESAR',
		'ID19190' => 'SUNGAI LIAT',
		'ID19191' => 'PEMALI',
		'ID19192' => 'BAKAM',
		'ID191130' => 'BELINYU',
		'ID191131' => 'RIAU SILIP',
		'ID19210' => 'MEMBALONG',
		'ID19260' => 'TANJUNG PANDAN',
		'ID19261' => 'BADAU',
		'ID19262' => 'SIJUK',
		'ID19263' => 'SELAT NASIK',
		'ID19310' => 'KELAPA',
		'ID19320' => 'TEMPILANG',
		'ID19330' => 'MENTOK',
		'ID19340' => 'SIMPANG TERITIP',
		'ID19350' => 'JEBUS',
		'ID19410' => 'KOBA',
		'ID19411' => 'LUBUK BESAR',
		'ID19420' => 'PANGKALAN BARU',
		'ID19421' => 'NAMANG',
		'ID19430' => 'SUNGAI SELAN',
		'ID19440' => 'SIMPANG KATIS',
		'ID19510' => 'PAYUNG',
		'ID19511' => 'PULAU BESAR',
		'ID19520' => 'SIMPANG RIMBA',
		'ID19530' => 'TOBOALI',
		'ID19531' => 'TUKAK SADAI',
		'ID19540' => 'AIR GEGAS',
		'ID19550' => 'LEPAR PONGOK',
		'ID19610' => 'DENDANG',
		'ID19611' => 'SIMPANG PESAK',
		'ID19620' => 'GANTUNG',
		'ID19621' => 'SIMPANG RENGGIANG',
		'ID19630' => 'MANGGAR',
		'ID19631' => 'DAMAR',
		'ID19640' => 'KELAPA KAMPIT',
		'ID197110' => 'RANGKUI',
		'ID197120' => 'BUKIT INTAN',
		'ID197130' => 'PANGKAL BALAM',
		'ID197140' => 'TAMAN SARI',
		'ID197141' => 'GERUNGGANG',
	],
	'KR' => [
		'ID21110' => 'MORO',
		'ID21111' => 'DURAI',
		'ID21120' => 'KUNDUR',
		'ID21121' => 'KUNDUR UTARA',
		'ID21122' => 'KUNDUR BARAT',
		'ID21130' => 'KARIMUN',
		'ID21131' => 'BURU',
		'ID21132' => 'MERAL',
		'ID21133' => 'TEBING',
		'ID21240' => 'TELUK BINTAN',
		'ID21250' => 'BINTAN UTARA',
		'ID21251' => 'TELUK SEBONG',
		'ID21252' => 'SERI KUALA LOBAM',
		'ID21260' => 'BINTAN TIMUR',
		'ID21261' => 'GUNUNG KIJANG',
		'ID21262' => 'MANTANG',
		'ID21263' => 'BINTAN PESISIR',
		'ID21264' => 'TOAPAYA',
		'ID21270' => 'TAMBELAN',
		'ID21330' => 'MIDAI',
		'ID21340' => 'BUNGURAN BARAT',
		'ID21341' => 'BUNGURAN UTARA',
		'ID21342' => 'PULAU LAUT',
		'ID21343' => 'PULAU TIGA',
		'ID21350' => 'BUNGURAN TIMUR',
		'ID21351' => 'BUNGURAN TIMUR LAUT',
		'ID21352' => 'BUNGURAN TENGAH',
		'ID21353' => 'BUNGURAN SELATAN',
		'ID21360' => 'S E R A S A N',
		'ID21361' => 'SUBI',
		'ID21362' => 'SERASAN TIMUR',
		'ID21410' => 'SINGKEP BARAT',
		'ID21420' => 'SINGKEP',
		'ID21430' => 'LINGGA',
		'ID21440' => 'LINGGA UTARA',
		'ID21450' => 'SENAYANG',
		'ID21510' => 'JEMAJA',
		'ID21520' => 'JEMAJA TIMUR',
		'ID21530' => 'SIANTAN SELATAN',
		'ID21540' => 'SIANTAN',
		'ID21550' => 'SIANTAN TIMUR',
		'ID21560' => 'SIANTAN TENGAH',
		'ID21570' => 'PAL MATAK',
		'ID217110' => 'BELAKANG PADANG',
		'ID217120' => 'BULANG',
		'ID217130' => 'GALANG',
		'ID217140' => 'SEI BEDUK',
		'ID217141' => 'SAGULUNG',
		'ID217150' => 'NONGSA',
		'ID217151' => 'BATAM KOTA',
		'ID217160' => 'SEKUPANG',
		'ID217161' => 'BATU AJI',
		'ID217170' => 'LUBUK BAJA',
		'ID217180' => 'BATU AMPAR',
		'ID217181' => 'BENGKONG',
		'ID217210' => 'BUKIT BESTARI',
		'ID217220' => 'TANJUNGPINANG TIMUR',
		'ID217230' => 'TANJUNGPINANG KOTA',
		'ID217240' => 'TANJUNGPINANG BARAT',
	],
	'JK' => [
		'ID31110' => 'KEPULAUAN SERIBU SELATAN',
		'ID31120' => 'KEPULAUAN SERIBU UTARA',
		'ID317110' => 'JAGAKARSA',
		'ID317120' => 'PASAR MINGGU',
		'ID317130' => 'CILANDAK',
		'ID317140' => 'PESANGGRAHAN',
		'ID317150' => 'KEBAYORAN LAMA',
		'ID317160' => 'KEBAYORAN BARU',
		'ID317170' => 'MAMPANG PRAPATAN',
		'ID317180' => 'PANCORAN',
		'ID317190' => 'TEBET',
		'ID3171100' => 'SETIA BUDI',
		'ID317210' => 'PASAR REBO',
		'ID317220' => 'CIRACAS',
		'ID317230' => 'CIPAYUNG',
		'ID317240' => 'MAKASAR',
		'ID317250' => 'KRAMAT JATI',
		'ID317260' => 'JATINEGARA',
		'ID317270' => 'DUREN SAWIT',
		'ID317280' => 'CAKUNG',
		'ID317290' => 'PULO GADUNG',
		'ID3172100' => 'MATRAMAN',
		'ID317310' => 'TANAH ABANG',
		'ID317320' => 'MENTENG',
		'ID317330' => 'SENEN',
		'ID317340' => 'JOHAR BARU',
		'ID317350' => 'CEMPAKA PUTIH',
		'ID317360' => 'KEMAYORAN',
		'ID317370' => 'SAWAH BESAR',
		'ID317380' => 'GAMBIR',
		'ID317410' => 'KEMBANGAN',
		'ID317420' => 'KEBON JERUK',
		'ID317430' => 'PALMERAH',
		'ID317440' => 'GROGOL PETAMBURAN',
		'ID317450' => 'TAMBORA',
		'ID317460' => 'TAMAN SARI',
		'ID317470' => 'CENGKARENG',
		'ID317480' => 'KALI DERES',
		'ID317510' => 'PENJARINGAN',
		'ID317520' => 'PADEMANGAN',
		'ID317530' => 'TANJUNG PRIOK',
		'ID317540' => 'KOJA',
		'ID317550' => 'KELAPA GADING',
	],
	'JB' => [
		'ID317560' => 'CILINCING',
		'ID32110' => 'NANGGUNG',
		'ID32120' => 'LEUWILIANG',
		'ID32121' => 'LEUWISADENG',
		'ID32130' => 'PAMIJAHAN',
		'ID32140' => 'CIBUNGBULANG',
		'ID32150' => 'CIAMPEA',
		'ID32151' => 'TENJOLAYA',
		'ID32160' => 'DRAMAGA',
		'ID32170' => 'CIOMAS',
		'ID32171' => 'TAMANSARI',
		'ID32180' => 'CIJERUK',
		'ID32181' => 'CIGOMBONG',
		'ID32190' => 'CARINGIN',
		'ID321100' => 'CIAWI',
		'ID321110' => 'CISARUA',
		'ID321120' => 'MEGAMENDUNG',
		'ID321130' => 'SUKARAJA',
		'ID321140' => 'BABAKAN MADANG',
		'ID321150' => 'SUKAMAKMUR',
		'ID321160' => 'CARIU',
		'ID321161' => 'TANJUNGSARI',
		'ID321170' => 'JONGGOL',
		'ID321180' => 'CILEUNGSI',
		'ID321181' => 'KELAPA NUNGGAL',
		'ID321190' => 'GUNUNG PUTRI',
		'ID321200' => 'CITEUREUP',
		'ID321210' => 'CIBINONG',
		'ID321220' => 'BOJONG GEDE',
		'ID321221' => 'TAJUR HALANG',
		'ID321230' => 'KEMANG',
		'ID321231' => 'RANCA BUNGUR',
		'ID321240' => 'PARUNG',
		'ID321241' => 'CISEENG',
		'ID321250' => 'GUNUNG SINDUR',
		'ID321260' => 'RUMPIN',
		'ID321270' => 'CIGUDEG',
		'ID321271' => 'SUKAJAYA',
		'ID321280' => 'JASINGA',
		'ID321290' => 'TENJO',
		'ID321300' => 'PARUNG PANJANG',
		'ID32210' => 'CIEMAS',
		'ID32220' => 'CIRACAP',
		'ID32221' => 'WALURAN',
		'ID32230' => 'SURADE',
		'ID32231' => 'CIBITUNG',
		'ID32240' => 'JAMPANG KULON',
		'ID32241' => 'CIMANGGU',
		'ID32250' => 'KALI BUNDER',
		'ID32260' => 'TEGAL BULEUD',
		'ID32270' => 'CIDOLOG',
		'ID32280' => 'SAGARANTEN',
		'ID32281' => 'CIDADAP',
		'ID32282' => 'CURUGKEMBAR',
		'ID32290' => 'PABUARAN',
		'ID322100' => 'LENGKONG',
		'ID322110' => 'PELABUHAN RATU',
		'ID322111' => 'SIMPENAN',
		'ID322120' => 'WARUNG KIARA',
		'ID322121' => 'BANTARGADUNG',
		'ID322130' => 'JAMPANG TENGAH',
		'ID322131' => 'PURABAYA',
		'ID322140' => 'CIKEMBAR',
		'ID322150' => 'NYALINDUNG',
		'ID322160' => 'GEGER BITUNG',
		'ID322170' => 'SUKARAJA',
		'ID322171' => 'KEBONPEDES',
		'ID322172' => 'CIREUNGHAS',
		'ID322173' => 'SUKALARANG',
		'ID322180' => 'SUKABUMI',
		'ID322190' => 'KADUDAMPIT',
		'ID322200' => 'CISAAT',
		'ID322201' => 'GUNUNGGURUH',
		'ID322210' => 'CIBADAK',
		'ID322211' => 'CICANTAYAN',
		'ID322212' => 'CARINGIN',
		'ID322220' => 'NAGRAK',
		'ID322221' => 'CIAMBAR',
		'ID322230' => 'CICURUG',
		'ID322240' => 'CIDAHU',
		'ID322250' => 'PARAKAN SALAK',
		'ID322260' => 'PARUNG KUDA',
		'ID322261' => 'BOJONG GENTENG',
		'ID322270' => 'KALAPA NUNGGAL',
		'ID322280' => 'CIKIDANG',
		'ID322290' => 'CISOLOK',
		'ID322291' => 'CIKAKAK',
		'ID322300' => 'KABANDUNGAN',
		'ID32310' => 'AGRABINTA',
		'ID32311' => 'LELES',
		'ID32320' => 'SINDANGBARANG',
		'ID32330' => 'CIDAUN',
		'ID32340' => 'NARINGGUL',
		'ID32350' => 'CIBINONG',
		'ID32351' => 'CIKADU',
		'ID32360' => 'TANGGEUNG',
		'ID32361' => 'PASIRKUDA',
		'ID32370' => 'KADUPANDAK',
		'ID32371' => 'CIJATI',
		'ID32380' => 'TAKOKAK',
		'ID32390' => 'SUKANAGARA',
		'ID323100' => 'PAGELARAN',
		'ID323110' => 'CAMPAKA',
		'ID323111' => 'CAMPAKA MULYA',
		'ID323120' => 'CIBEBER',
		'ID323130' => 'WARUNGKONDANG',
		'ID323131' => 'GEKBRONG',
		'ID323140' => 'CILAKU',
		'ID323150' => 'SUKALUYU',
		'ID323160' => 'BOJONGPICUNG',
		'ID323161' => 'HAURWANGI',
		'ID323170' => 'CIRANJANG',
		'ID323180' => 'MANDE',
		'ID323190' => 'KARANGTENGAH',
		'ID323200' => 'CIANJUR',
		'ID323210' => 'CUGENANG',
		'ID323220' => 'PACET',
		'ID323221' => 'CIPANAS',
		'ID323230' => 'SUKARESMI',
		'ID323240' => 'CIKALONGKULON',
		'ID32410' => 'CIWIDEY',
		'ID32411' => 'RANCABALI',
		'ID32420' => 'PASIRJAMBU',
		'ID32430' => 'CIMAUNG',
		'ID32440' => 'PANGALENGAN',
		'ID32450' => 'KERTASARI',
		'ID32460' => 'PACET',
		'ID32470' => 'IBUN',
		'ID32480' => 'PASEH',
		'ID32490' => 'CIKANCUNG',
		'ID324100' => 'CICALENGKA',
		'ID324101' => 'NAGREG',
		'ID324110' => 'RANCAEKEK',
		'ID324120' => 'MAJALAYA',
		'ID324121' => 'SOLOKAN JERUK',
		'ID324130' => 'CIPARAY',
		'ID324140' => 'BALEENDAH',
		'ID324150' => 'ARJASARI',
		'ID324160' => 'BANJARAN',
		'ID324161' => 'CANGKUANG',
		'ID324170' => 'PAMEUNGPEUK',
		'ID324180' => 'KATAPANG',
		'ID324190' => 'SOREANG',
		'ID324191' => 'KUTAWARINGIN',
		'ID324250' => 'MARGAASIH',
		'ID324260' => 'MARGAHAYU',
		'ID324270' => 'DAYEUHKOLOT',
		'ID324280' => 'BOJONGSOANG',
		'ID324290' => 'CILEUNYI',
		'ID324300' => 'CILENGKRANG',
		'ID324310' => 'CIMENYAN',
		'ID32510' => 'CISEWU',
		'ID32511' => 'CARINGIN',
		'ID32520' => 'TALEGONG',
		'ID32530' => 'BUNGBULANG',
		'ID32531' => 'MEKARMUKTI',
		'ID32540' => 'PAMULIHAN',
		'ID32550' => 'PAKENJENG',
		'ID32560' => 'CIKELET',
		'ID32570' => 'PAMEUNGPEUK',
		'ID32580' => 'CIBALONG',
		'ID32590' => 'CISOMPET',
		'ID325100' => 'PEUNDEUY',
		'ID325110' => 'SINGAJAYA',
		'ID325111' => 'CIHURIP',
		'ID325120' => 'CIKAJANG',
		'ID325130' => 'BANJARWANGI',
		'ID325140' => 'CILAWU',
		'ID325150' => 'BAYONGBONG',
		'ID325151' => 'CIGEDUG',
		'ID325160' => 'CISURUPAN',
		'ID325161' => 'SUKARESMI',
		'ID325170' => 'SAMARANG',
		'ID325171' => 'PASIRWANGI',
		'ID325181' => 'TAROGONG KIDUL',
		'ID325182' => 'TAROGONG KALER',
		'ID325190' => 'GARUT KOTA',
		'ID325200' => 'KARANGPAWITAN',
		'ID325210' => 'WANARAJA',
		'ID325211' => 'SUCINARAJA',
		'ID325212' => 'PANGATIKAN',
		'ID325220' => 'SUKAWENING',
		'ID325221' => 'KARANGTENGAH',
		'ID325230' => 'BANYURESMI',
		'ID325240' => 'LELES',
		'ID325250' => 'LEUWIGOONG',
		'ID325260' => 'CIBATU',
		'ID325261' => 'KERSAMANAH',
		'ID325270' => 'CIBIUK',
		'ID325280' => 'KADUNGORA',
		'ID325290' => 'BLUBUR LIMBANGAN',
		'ID325300' => 'SELAAWI',
		'ID325310' => 'MALANGBONG',
		'ID32610' => 'CIPATUJAH',
		'ID32620' => 'KARANGNUNGGAL',
		'ID32630' => 'CIKALONG',
		'ID32640' => 'PANCATENGAH',
		'ID32650' => 'CIKATOMAS',
		'ID32660' => 'CIBALONG',
		'ID32661' => 'PARUNGPONTENG',
		'ID32670' => 'BANTARKALONG',
		'ID32671' => 'BOJONGASIH',
		'ID32672' => 'CULAMEGA',
		'ID32680' => 'BOJONGGAMBIR',
		'ID32690' => 'SODONGHILIR',
		'ID326100' => 'TARAJU',
		'ID326110' => 'SALAWU',
		'ID326111' => 'PUSPAHIANG',
		'ID326120' => 'TANJUNGJAYA',
		'ID326130' => 'SUKARAJA',
		'ID326140' => 'SALOPA',
		'ID326141' => 'JATIWARAS',
		'ID326150' => 'CINEAM',
		'ID326151' => 'KARANGJAYA',
		'ID326160' => 'MANONJAYA',
		'ID326161' => 'GUNUNGTANJUNG',
		'ID326190' => 'SINGAPARNA',
		'ID326191' => 'SUKARAME',
		'ID326192' => 'MANGUNREJA',
		'ID326200' => 'CIGALONTANG',
		'ID326210' => 'LEUWISARI',
		'ID326211' => 'SARIWANGI',
		'ID326212' => 'PADAKEMBANG',
		'ID326221' => 'SUKARATU',
		'ID326230' => 'CISAYONG',
		'ID326231' => 'SUKAHENING',
		'ID326240' => 'RAJAPOLAH',
		'ID326250' => 'JAMANIS',
		'ID326260' => 'CIAWI',
		'ID326261' => 'KADIPATEN',
		'ID326270' => 'PAGERAGEUNG',
		'ID326271' => 'SUKARESIK',
		'ID32710' => 'CIMERAK',
		'ID32720' => 'CIJULANG',
		'ID32730' => 'CIGUGUR',
		'ID32740' => 'LANGKAPLANCAR',
		'ID32750' => 'PARIGI',
		'ID32760' => 'SIDAMULIH',
		'ID32770' => 'PANGANDARAN',
		'ID32780' => 'KALIPUCANG',
		'ID32790' => 'PADAHERANG',
		'ID32791' => 'MANGUNJAYA',
		'ID327100' => 'BANJARSARI',
		'ID327110' => 'LAKBOK',
		'ID327111' => 'PURWADADI',
		'ID327120' => 'PAMARICAN',
		'ID327130' => 'CIDOLOG',
		'ID327140' => 'CIMARAGAS',
		'ID327150' => 'CIJEUNGJING',
		'ID327160' => 'CISAGA',
		'ID327170' => 'TAMBAKSARI',
		'ID327180' => 'RANCAH',
		'ID327190' => 'RAJADESA',
		'ID327200' => 'SUKADANA',
		'ID327210' => 'CIAMIS',
		'ID327211' => 'BAREGBEG',
		'ID327220' => 'CIKONENG',
		'ID327221' => 'SINDANGKASIH',
		'ID327230' => 'CIHAURBEUTI',
		'ID327240' => 'SADANANYA',
		'ID327250' => 'CIPAKU',
		'ID327260' => 'JATINAGARA',
		'ID327270' => 'PANAWANGAN',
		'ID327280' => 'KAWALI',
		'ID327281' => 'LUMBUNG',
		'ID327290' => 'PANJALU',
		'ID327291' => 'SUKAMANTRI',
		'ID327300' => 'PANUMBANGAN',
		'ID32810' => 'DARMA',
		'ID32820' => 'KADUGEDE',
		'ID32821' => 'NUSAHERANG',
		'ID32830' => 'CINIRU',
		'ID32831' => 'HANTARA',
		'ID32840' => 'SELAJAMBE',
		'ID32850' => 'SUBANG',
		'ID32851' => 'CILEBAK',
		'ID32860' => 'CIWARU',
		'ID32861' => 'KARANGKANCANA',
		'ID32870' => 'CIBINGBIN',
		'ID32871' => 'CIBEUREUM',
		'ID32880' => 'LURAGUNG',
		'ID32881' => 'CIMAHI',
		'ID32890' => 'CIDAHU',
		'ID32891' => 'KALIMANGGIS',
		'ID328100' => 'CIAWIGEBANG',
		'ID328101' => 'CIPICUNG',
		'ID328110' => 'LEBAKWANGI',
		'ID328111' => 'MALEBER',
		'ID328120' => 'GARAWANGI',
		'ID328121' => 'SIDANGAGUNG',
		'ID328130' => 'KUNINGAN',
		'ID328140' => 'CIGUGUR',
		'ID328150' => 'KRAMATMULYA',
		'ID328160' => 'JALAKSANA',
		'ID328161' => 'JAPARA',
		'ID328170' => 'CILIMUS',
		'ID328171' => 'CIGANDAMEKAR',
		'ID328180' => 'MANDIRANCAN',
		'ID328181' => 'PANCALANG',
		'ID328190' => 'PASAWAHAN',
		'ID32910' => 'WALED',
		'ID32911' => 'PASALEMAN',
		'ID32920' => 'CILEDUG',
		'ID32921' => 'PABUARAN',
		'ID32930' => 'LOSARI',
		'ID32931' => 'PABEDILAN',
		'ID32940' => 'BABAKAN',
		'ID32941' => 'GEBANG',
		'ID32950' => 'KARANGSEMBUNG',
		'ID32951' => 'KARANGWARENG',
		'ID32960' => 'LEMAHABANG',
		'ID32961' => 'SUSUKANLEBAK',
		'ID32970' => 'SEDONG',
		'ID32980' => 'ASTANAJAPURA',
		'ID32981' => 'PANGENAN',
		'ID32990' => 'MUNDU',
		'ID329100' => 'BEBER',
		'ID329101' => 'GREGED',
		'ID329111' => 'TALUN',
		'ID329120' => 'SUMBER',
		'ID329121' => 'DUKUPUNTANG',
		'ID329130' => 'PALIMANAN',
		'ID329140' => 'PLUMBON',
		'ID329141' => 'DEPOK',
		'ID329150' => 'WERU',
		'ID329151' => 'PLERED',
		'ID329161' => 'TENGAH TANI',
		'ID329162' => 'KEDAWUNG',
		'ID329171' => 'GUNUNGJATI',
		'ID329180' => 'KAPETAKAN',
		'ID329181' => 'SURANENGGALA',
		'ID329190' => 'KLANGENAN',
		'ID329191' => 'JAMBLANG',
		'ID329200' => 'ARJAWINANGUN',
		'ID329201' => 'PANGURAGAN',
		'ID329210' => 'CIWARINGIN',
		'ID329211' => 'GEMPOL',
		'ID329220' => 'SUSUKAN',
		'ID329230' => 'GEGESIK',
		'ID329231' => 'KALIWEDI',
		'ID321010' => 'LEMAHSUGIH',
		'ID321020' => 'BANTARUJEG',
		'ID321021' => 'MALAUSMA',
		'ID321030' => 'CIKIJING',
		'ID321031' => 'CINGAMBUL',
		'ID321040' => 'TALAGA',
		'ID321041' => 'BANJARAN',
		'ID321050' => 'ARGAPURA',
		'ID321060' => 'MAJA',
		'ID321070' => 'MAJALENGKA',
		'ID321080' => 'CIGASONG',
		'ID321090' => 'SUKAHAJI',
		'ID321091' => 'SINDANG',
		'ID3210100' => 'RAJAGALUH',
		'ID3210110' => 'SINDANGWANGI',
		'ID3210120' => 'LEUWIMUNDING',
		'ID3210130' => 'PALASAH',
		'ID3210140' => 'JATIWANGI',
		'ID3210150' => 'DAWUAN',
		'ID3210151' => 'KASOKANDEL',
		'ID3210160' => 'PANYINGKIRAN',
		'ID3210170' => 'KADIPATEN',
		'ID3210180' => 'KERTAJATI',
		'ID3210190' => 'JATITUJUH',
		'ID3210200' => 'LIGUNG',
		'ID3210210' => 'SUMBERJAYA',
		'ID321110' => 'JATINANGOR',
		'ID321120' => 'CIMANGGUNG',
		'ID321130' => 'TANJUNGSARI',
		'ID321131' => 'SUKASARI',
		'ID321132' => 'PAMULIHAN',
		'ID321140' => 'RANCAKALONG',
		'ID321150' => 'SUMEDANG SELATAN',
		'ID321160' => 'SUMEDANG UTARA',
		'ID321161' => 'GANEAS',
		'ID321170' => 'SITURAJA',
		'ID321171' => 'CISITU',
		'ID321180' => 'DARMARAJA',
		'ID321190' => 'CIBUGEL',
		'ID3211100' => 'WADO',
		'ID3211101' => 'JATINUNGGAL',
		'ID3211111' => 'JATIGEDE',
		'ID3211120' => 'TOMO',
		'ID3211130' => 'UJUNG JAYA',
		'ID3211140' => 'CONGGEANG',
		'ID3211150' => 'PASEH',
		'ID3211160' => 'CIMALAKA',
		'ID3211161' => 'CISARUA',
		'ID3211170' => 'TANJUNGKERTA',
		'ID3211171' => 'TANJUNGMEDAR',
		'ID3211180' => 'BUAHDUA',
		'ID3211181' => 'SURIAN',
		'ID321210' => 'HAURGEULIS',
		'ID321211' => 'GANTAR',
		'ID321220' => 'KROYA',
		'ID321230' => 'GABUSWETAN',
		'ID321240' => 'CIKEDUNG',
		'ID321241' => 'TERISI',
		'ID321250' => 'LELEA',
		'ID321260' => 'BANGODUA',
		'ID321261' => 'TUKDANA',
		'ID321270' => 'WIDASARI',
		'ID321280' => 'KERTASEMAYA',
		'ID321281' => 'SUKAGUMIWANG',
		'ID321290' => 'KRANGKENG',
		'ID3212100' => 'KARANGAMPEL',
		'ID3212101' => 'KEDOKAN BUNDER',
		'ID3212110' => 'JUNTINYUAT',
		'ID3212120' => 'SLIYEG',
		'ID3212130' => 'JATIBARANG',
		'ID3212140' => 'BALONGAN',
		'ID3212150' => 'INDRAMAYU',
		'ID3212160' => 'SINDANG',
		'ID3212161' => 'CANTIGI',
		'ID3212162' => 'PASEKAN',
		'ID3212170' => 'LOHBENER',
		'ID3212171' => 'ARAHAN',
		'ID3212180' => 'LOSARANG',
		'ID3212190' => 'KANDANGHAUR',
		'ID3212200' => 'BONGAS',
		'ID3212210' => 'ANJATAN',
		'ID3212220' => 'SUKRA',
		'ID3212221' => 'PATROL',
		'ID321310' => 'SAGALAHERANG',
		'ID321311' => 'SERANGPANJANG',
		'ID321320' => 'JALANCAGAK',
		'ID321321' => 'CIATER',
		'ID321330' => 'CISALAK',
		'ID321331' => 'KASOMALANG',
		'ID321340' => 'TANJUNGSIANG',
		'ID321350' => 'CIJAMBE',
		'ID321360' => 'CIBOGO',
		'ID321370' => 'SUBANG',
		'ID321380' => 'KALIJATI',
		'ID321381' => 'DAWUAN',
		'ID321390' => 'CIPEUNDEUY',
		'ID3213100' => 'PABUARAN',
		'ID3213110' => 'PATOKBEUSI',
		'ID3213120' => 'PURWADADI',
		'ID3213130' => 'CIKAUM',
		'ID3213140' => 'PAGADEN',
		'ID3213141' => 'PAGADEN BARAT',
		'ID3213150' => 'CIPUNAGARA',
		'ID3213160' => 'COMPRENG',
		'ID3213170' => 'BINONG',
		'ID3213171' => 'TAMBAKDAHAN',
		'ID3213180' => 'CIASEM',
		'ID3213190' => 'PAMANUKAN',
		'ID3213191' => 'SUKASARI',
		'ID3213200' => 'PUSAKANAGARA',
		'ID3213201' => 'PUSAKAJAYA',
		'ID3213210' => 'LEGONKULON',
		'ID3213220' => 'BLANAKAN',
		'ID321410' => 'JATILUHUR',
		'ID321411' => 'SUKASARI',
		'ID321420' => 'MANIIS',
		'ID321430' => 'TEGAL WARU',
		'ID321440' => 'PLERED',
		'ID321450' => 'SUKATANI',
		'ID321460' => 'DARANGDAN',
		'ID321470' => 'BOJONG',
		'ID321480' => 'WANAYASA',
		'ID321481' => 'KIARAPEDES',
		'ID321490' => 'PASAWAHAN',
		'ID321491' => 'PONDOK SALAM',
		'ID3214100' => 'PURWAKARTA',
		'ID3214101' => 'BABAKANCIKAO',
		'ID3214110' => 'CAMPAKA',
		'ID3214111' => 'CIBATU',
		'ID3214112' => 'BUNGURSARI',
		'ID321510' => 'PANGKALAN',
		'ID321511' => 'TEGALWARU',
		'ID321520' => 'CIAMPEL',
		'ID321531' => 'TELUKJAMBE TIMUR',
		'ID321532' => 'TELUKJAMBE BARAT',
		'ID321540' => 'KLARI',
		'ID321550' => 'CIKAMPEK',
		'ID321551' => 'PURWASARI',
		'ID321560' => 'TIRTAMULYA',
		'ID321570' => 'JATISARI',
		'ID321571' => 'BANYUSARI',
		'ID321572' => 'KOTABARU',
		'ID321581' => 'CILAMAYA WETAN',
		'ID321582' => 'CILAMAYA KULON',
		'ID321590' => 'LEMAHABANG',
		'ID3215100' => 'TALAGASARI',
		'ID3215111' => 'MAJALAYA',
		'ID3215112' => 'KARAWANG TIMUR',
		'ID3215113' => 'KARAWANG BARAT',
		'ID3215120' => 'RAWAMERTA',
		'ID3215130' => 'TEMPURAN',
		'ID3215140' => 'KUTAWALUYA',
		'ID3215150' => 'RENGASDENGKLOK',
		'ID3215151' => 'JAYAKERTA',
		'ID3215160' => 'PEDES',
		'ID3215161' => 'CILEBAR',
		'ID3215170' => 'CIBUAYA',
		'ID3215180' => 'TIRTAJAYA',
		'ID3215190' => 'BATUJAYA',
		'ID3215200' => 'PAKISJAYA',
		'ID321610' => 'SETU',
		'ID321621' => 'SERANG BARU',
		'ID321622' => 'CIKARANG PUSAT',
		'ID321623' => 'CIKARANG SELATAN',
		'ID321630' => 'CIBARUSAH',
		'ID321631' => 'BOJONGMANGU',
		'ID321641' => 'CIKARANG TIMUR',
		'ID321650' => 'KEDUNGWARINGIN',
		'ID321661' => 'CIKARANG UTARA',
		'ID321662' => 'KARANGBAHAGIA',
		'ID321670' => 'CIBITUNG',
		'ID321671' => 'CIKARANG BARAT',
		'ID321681' => 'TAMBUN SELATAN',
		'ID321682' => 'TAMBUN UTARA',
		'ID321690' => 'BABELAN',
		'ID3216100' => 'TARUMAJAYA',
		'ID3216110' => 'TAMBELANG',
		'ID3216111' => 'SUKAWANGI',
		'ID3216120' => 'SUKATANI',
		'ID3216121' => 'SUKAKARYA',
		'ID3216130' => 'PEBAYURAN',
		'ID3216140' => 'CABANGBUNGIN',
		'ID3216150' => 'MUARA GEMBONG',
		'ID321710' => 'RONGGA',
		'ID321720' => 'GUNUNGHALU',
		'ID321730' => 'SINDANGKERTA',
		'ID321740' => 'CILILIN',
		'ID321750' => 'CIHAMPELAS',
		'ID321760' => 'CIPONGKOR',
		'ID321770' => 'BATUJAJAR',
		'ID321780' => 'CIPATAT',
		'ID321790' => 'PADALARANG',
		'ID3217100' => 'NGAMPRAH',
		'ID3217110' => 'PARONGPONG',
		'ID3217120' => 'LEMBANG',
		'ID3217130' => 'CISARUA',
		'ID3217140' => 'CIKALONG WETAN',
		'ID3217150' => 'CIPEUNDEUY',
		'ID327110' => 'BOGOR SELATAN',
		'ID327120' => 'BOGOR TIMUR',
		'ID327130' => 'BOGOR UTARA',
		'ID327140' => 'BOGOR TENGAH',
		'ID327150' => 'BOGOR BARAT',
		'ID327160' => 'TANAH SEREAL',
		'ID327210' => 'BAROS',
		'ID327211' => 'LEMBURSITU',
		'ID327212' => 'CIBEUREUM',
		'ID327220' => 'CITAMIANG',
		'ID327230' => 'WARUDOYONG',
		'ID327240' => 'GUNUNG PUYUH',
		'ID327250' => 'CIKOLE',
		'ID327310' => 'BANDUNG KULON',
		'ID327320' => 'BABAKAN CIPARAY',
		'ID327330' => 'BOJONGLOA KALER',
		'ID327340' => 'BOJONGLOA KIDUL',
		'ID327350' => 'ASTANAANYAR',
		'ID327360' => 'REGOL',
		'ID327370' => 'LENGKONG',
		'ID327380' => 'BANDUNG KIDUL',
		'ID327390' => 'BUAHBATU',
		'ID3273100' => 'RANCASARI',
		'ID3273101' => 'GEDEBAGE',
		'ID3273110' => 'CIBIRU',
		'ID3273111' => 'PANYILEUKAN',
		'ID3273120' => 'UJUNG BERUNG',
		'ID3273121' => 'CINAMBO',
		'ID3273130' => 'ARCAMANIK',
		'ID3273141' => 'ANTAPANI',
		'ID3273142' => 'MANDALAJATI',
		'ID3273150' => 'KIARACONDONG',
		'ID3273160' => 'BATUNUNGGAL',
		'ID3273170' => 'SUMUR BANDUNG',
		'ID3273180' => 'ANDIR',
		'ID3273190' => 'CICENDO',
		'ID3273200' => 'BANDUNG WETAN',
		'ID3273210' => 'CIBEUNYING KIDUL',
		'ID3273220' => 'CIBEUNYING KALER',
		'ID3273230' => 'COBLONG',
		'ID3273240' => 'SUKAJADI',
		'ID3273250' => 'SUKASARI',
		'ID3273260' => 'CIDADAP',
		'ID327410' => 'HARJAMUKTI',
		'ID327420' => 'LEMAHWUNGKUK',
		'ID327430' => 'PEKALIPAN',
		'ID327440' => 'KESAMBI',
		'ID327450' => 'KEJAKSAN',
		'ID327510' => 'PONDOKGEDE',
		'ID327511' => 'JATISAMPURNA',
		'ID327512' => 'PONDOKMELATI',
		'ID327520' => 'JATIASIH',
		'ID327530' => 'BANTARGEBANG',
		'ID327531' => 'MUSTIKAJAYA',
		'ID327540' => 'BEKASI TIMUR',
		'ID327541' => 'RAWALUMBU',
		'ID327550' => 'BEKASI SELATAN',
		'ID327560' => 'BEKASI BARAT',
		'ID327561' => 'MEDAN SATRIA',
		'ID327570' => 'BEKASI UTARA',
		'ID327610' => 'SAWANGAN',
		'ID327611' => 'BOJONGSARI',
		'ID327620' => 'PANCORAN MAS',
		'ID327621' => 'CIPAYUNG',
		'ID327630' => 'SUKMA JAYA',
		'ID327631' => 'CILODONG',
		'ID327640' => 'CIMANGGIS',
		'ID327641' => 'TAPOS',
		'ID327650' => 'BEJI',
		'ID327660' => 'LIMO',
		'ID327661' => 'CINERE',
		'ID327710' => 'CIMAHI SELATAN',
		'ID327720' => 'CIMAHI TENGAH',
		'ID327730' => 'CIMAHI UTARA',
		'ID327810' => 'KAWALU',
		'ID327820' => 'TAMANSARI',
		'ID327830' => 'CIBEUREUM',
		'ID327831' => 'PURBARATU',
		'ID327840' => 'TAWANG',
		'ID327850' => 'CIHIDEUNG',
		'ID327860' => 'MANGKUBUMI',
		'ID327870' => 'INDIHIANG',
		'ID327871' => 'BUNGURSARI',
		'ID327880' => 'CIPEDES',
		'ID327910' => 'BANJAR',
		'ID327920' => 'PURWAHARJA',
		'ID327930' => 'PATARUMAN',
		'ID327940' => 'LANGENSARI',
	],
	'JT' => [
		'ID33110' => 'DAYEUHLUHUR',
		'ID33120' => 'WANAREJA',
		'ID33130' => 'MAJENANG',
		'ID33140' => 'CIMANGGU',
		'ID33150' => 'KARANGPUCUNG',
		'ID33160' => 'CIPARI',
		'ID33170' => 'SIDAREJA',
		'ID33180' => 'KEDUNGREJA',
		'ID33190' => 'PATIMUAN',
		'ID331100' => 'GANDRUNGMANGU',
		'ID331110' => 'BANTARSARI',
		'ID331120' => 'KAWUNGANTEN',
		'ID331121' => 'KAMPUNG LAUT',
		'ID331130' => 'JERUKLEGI',
		'ID331140' => 'KESUGIHAN',
		'ID331150' => 'ADIPALA',
		'ID331160' => 'MAOS',
		'ID331170' => 'SAMPANG',
		'ID331180' => 'KROYA',
		'ID331190' => 'BINANGUN',
		'ID331200' => 'NUSAWUNGU',
		'ID331710' => 'CILACAP SELATAN',
		'ID331720' => 'CILACAP TENGAH',
		'ID331730' => 'CILACAP UTARA',
		'ID33210' => 'LUMBIR',
		'ID33220' => 'WANGON',
		'ID33230' => 'JATILAWANG',
		'ID33240' => 'RAWALO',
		'ID33250' => 'KEBASEN',
		'ID33260' => 'KEMRANJEN',
		'ID33270' => 'SUMPIUH',
		'ID33280' => 'TAMBAK',
		'ID33290' => 'SOMAGEDE',
		'ID332100' => 'KALIBAGOR',
		'ID332110' => 'BANYUMAS',
		'ID332120' => 'PATIKRAJA',
		'ID332130' => 'PURWOJATI',
		'ID332140' => 'AJIBARANG',
		'ID332150' => 'GUMELAR',
		'ID332160' => 'PEKUNCEN',
		'ID332170' => 'CILONGOK',
		'ID332180' => 'KARANGLEWAS',
		'ID332190' => 'KEDUNG BANTENG',
		'ID332200' => 'BATURRADEN',
		'ID332210' => 'SUMBANG',
		'ID332220' => 'KEMBARAN',
		'ID332230' => 'SOKARAJA',
		'ID332710' => 'PURWOKERTO SELATAN',
		'ID332720' => 'PURWOKERTO BARAT',
		'ID332730' => 'PURWOKERTO TIMUR',
		'ID332740' => 'PURWOKERTO UTARA',
		'ID33310' => 'KEMANGKON',
		'ID33320' => 'BUKATEJA',
		'ID33330' => 'KEJOBONG',
		'ID33340' => 'PENGADEGAN',
		'ID33350' => 'KALIGONDANG',
		'ID33360' => 'PURBALINGGA',
		'ID33370' => 'KALIMANAH',
		'ID33380' => 'PADAMARA',
		'ID33390' => 'KUTASARI',
		'ID333100' => 'BOJONGSARI',
		'ID333110' => 'MREBET',
		'ID333120' => 'BOBOTSARI',
		'ID333130' => 'KARANGREJA',
		'ID333131' => 'KARANGJAMBU',
		'ID333140' => 'KARANGANYAR',
		'ID333141' => 'KERTANEGARA',
		'ID333150' => 'KARANGMONCOL',
		'ID333160' => 'REMBANG',
		'ID33410' => 'SUSUKAN',
		'ID33420' => 'PURWOREJO KLAMPOK',
		'ID33430' => 'MANDIRAJA',
		'ID33440' => 'PURWANEGARA',
		'ID33450' => 'BAWANG',
		'ID33460' => 'BANJARNEGARA',
		'ID33461' => 'PAGEDONGAN',
		'ID33470' => 'SIGALUH',
		'ID33480' => 'MADUKARA',
		'ID33490' => 'BANJARMANGU',
		'ID334100' => 'WANADADI',
		'ID334110' => 'RAKIT',
		'ID334120' => 'PUNGGELAN',
		'ID334130' => 'KARANGKOBAR',
		'ID334140' => 'PAGENTAN',
		'ID334150' => 'PEJAWARAN',
		'ID334160' => 'BATUR',
		'ID334170' => 'WANAYASA',
		'ID334180' => 'KALIBENING',
		'ID334181' => 'PANDANARUM',
		'ID33510' => 'AYAH',
		'ID33520' => 'BUAYAN',
		'ID33530' => 'PURING',
		'ID33540' => 'PETANAHAN',
		'ID33550' => 'KLIRONG',
		'ID33560' => 'BULUSPESANTREN',
		'ID33570' => 'AMBAL',
		'ID33580' => 'MIRIT',
		'ID33581' => 'BONOROWO',
		'ID33590' => 'PREMBUN',
		'ID33591' => 'PADURESO',
		'ID335100' => 'KUTOWINANGUN',
		'ID335110' => 'ALIAN',
		'ID335111' => 'PONCOWARNO',
		'ID335120' => 'KEBUMEN',
		'ID335130' => 'PEJAGOAN',
		'ID335140' => 'SRUWENG',
		'ID335150' => 'ADIMULYO',
		'ID335160' => 'KUWARASAN',
		'ID335170' => 'ROWOKELE',
		'ID335180' => 'SEMPOR',
		'ID335190' => 'GOMBONG',
		'ID335200' => 'KARANGANYAR',
		'ID335210' => 'KARANGGAYAM',
		'ID335220' => 'SADANG',
		'ID335221' => 'KARANGSAMBUNG',
		'ID33610' => 'GRABAG',
		'ID33620' => 'NGOMBOL',
		'ID33630' => 'PURWODADI',
		'ID33640' => 'BAGELEN',
		'ID33650' => 'KALIGESING',
		'ID33660' => 'PURWOREJO',
		'ID33670' => 'BANYU URIP',
		'ID33680' => 'BAYAN',
		'ID33690' => 'KUTOARJO',
		'ID336100' => 'BUTUH',
		'ID336110' => 'PITURUH',
		'ID336120' => 'KEMIRI',
		'ID336130' => 'BRUNO',
		'ID336140' => 'GEBANG',
		'ID336150' => 'LOANO',
		'ID336160' => 'BENER',
		'ID33710' => 'WADASLINTANG',
		'ID33720' => 'KEPIL',
		'ID33730' => 'SAPURAN',
		'ID33731' => 'KALIBAWANG',
		'ID33740' => 'KALIWIRO',
		'ID33750' => 'LEKSONO',
		'ID33751' => 'SUKOHARJO',
		'ID33760' => 'SELOMERTO',
		'ID33770' => 'KALIKAJAR',
		'ID33780' => 'KERTEK',
		'ID33790' => 'WONOSOBO',
		'ID337100' => 'WATUMALANG',
		'ID337110' => 'MOJOTENGAH',
		'ID337120' => 'GARUNG',
		'ID337130' => 'KEJAJAR',
		'ID33810' => 'SALAMAN',
		'ID33820' => 'BOROBUDUR',
		'ID33830' => 'NGLUWAR',
		'ID33840' => 'SALAM',
		'ID33850' => 'SRUMBUNG',
		'ID33860' => 'DUKUN',
		'ID33870' => 'MUNTILAN',
		'ID33880' => 'MUNGKID',
		'ID33890' => 'SAWANGAN',
		'ID338100' => 'CANDIMULYO',
		'ID338110' => 'MERTOYUDAN',
		'ID338120' => 'TEMPURAN',
		'ID338130' => 'KAJORAN',
		'ID338140' => 'KALIANGKRIK',
		'ID338150' => 'BANDONGAN',
		'ID338160' => 'WINDUSARI',
		'ID338170' => 'SECANG',
		'ID338180' => 'TEGALREJO',
		'ID338190' => 'PAKIS',
		'ID338200' => 'GRABAG',
		'ID338210' => 'NGABLAK',
		'ID33910' => 'SELO',
		'ID33920' => 'AMPEL',
		'ID33930' => 'CEPOGO',
		'ID33940' => 'MUSUK',
		'ID33950' => 'BOYOLALI',
		'ID33960' => 'MOJOSONGO',
		'ID33970' => 'TERAS',
		'ID33980' => 'SAWIT',
		'ID33990' => 'BANYUDONO',
		'ID339100' => 'SAMBI',
		'ID339110' => 'NGEMPLAK',
		'ID339120' => 'NOGOSARI',
		'ID339130' => 'SIMO',
		'ID339140' => 'KARANGGEDE',
		'ID339150' => 'KLEGO',
		'ID339160' => 'ANDONG',
		'ID339170' => 'KEMUSU',
		'ID339180' => 'WONOSEGORO',
		'ID339190' => 'JUWANGI',
		'ID331010' => 'PRAMBANAN',
		'ID331020' => 'GANTIWARNO',
		'ID331030' => 'WEDI',
		'ID331040' => 'BAYAT',
		'ID331050' => 'CAWAS',
		'ID331060' => 'TRUCUK',
		'ID331070' => 'KALIKOTES',
		'ID331080' => 'KEBONARUM',
		'ID331090' => 'JOGONALAN',
		'ID3310100' => 'MANISRENGGO',
		'ID3310110' => 'KARANGNONGKO',
		'ID3310120' => 'NGAWEN',
		'ID3310130' => 'CEPER',
		'ID3310140' => 'PEDAN',
		'ID3310150' => 'KARANGDOWO',
		'ID3310160' => 'JUWIRING',
		'ID3310170' => 'WONOSARI',
		'ID3310180' => 'DELANGGU',
		'ID3310190' => 'POLANHARJO',
		'ID3310200' => 'KARANGANOM',
		'ID3310210' => 'TULUNG',
		'ID3310220' => 'JATINOM',
		'ID3310230' => 'KEMALANG',
		'ID3310710' => 'KLATEN SELATAN',
		'ID3310720' => 'KLATEN TENGAH',
		'ID3310730' => 'KLATEN UTARA',
		'ID331110' => 'WERU',
		'ID331120' => 'BULU',
		'ID331130' => 'TAWANGSARI',
		'ID331140' => 'SUKOHARJO',
		'ID331150' => 'NGUTER',
		'ID331160' => 'BENDOSARI',
		'ID331170' => 'POLOKARTO',
		'ID331180' => 'MOJOLABAN',
		'ID331190' => 'GROGOL',
		'ID3311100' => 'BAKI',
		'ID3311110' => 'GATAK',
		'ID3311120' => 'KARTASURA',
		'ID331210' => 'PRACIMANTORO',
		'ID331220' => 'PARANGGUPITO',
		'ID331230' => 'GIRITONTRO',
		'ID331240' => 'GIRIWOYO',
		'ID331250' => 'BATUWARNO',
		'ID331260' => 'KARANGTENGAH',
		'ID331270' => 'TIRTOMOYO',
		'ID331280' => 'NGUNTORONADI',
		'ID331290' => 'BATURETNO',
		'ID3312100' => 'EROMOKO',
		'ID3312110' => 'WURYANTORO',
		'ID3312120' => 'MANYARAN',
		'ID3312130' => 'SELOGIRI',
		'ID3312140' => 'WONOGIRI',
		'ID3312150' => 'NGADIROJO',
		'ID3312160' => 'SIDOHARJO',
		'ID3312170' => 'JATIROTO',
		'ID3312180' => 'KISMANTORO',
		'ID3312190' => 'PURWANTORO',
		'ID3312200' => 'BULUKERTO',
		'ID3312201' => 'PUHPELEM',
		'ID3312210' => 'SLOGOHIMO',
		'ID3312220' => 'JATISRONO',
		'ID3312230' => 'JATIPURNO',
		'ID3312240' => 'GIRIMARTO',
		'ID331310' => 'JATIPURO',
		'ID331320' => 'JATIYOSO',
		'ID331330' => 'JUMAPOLO',
		'ID331340' => 'JUMANTONO',
		'ID331350' => 'MATESIH',
		'ID331360' => 'TAWANGMANGU',
		'ID331370' => 'NGARGOYOSO',
		'ID331380' => 'KARANGPANDAN',
		'ID331390' => 'KARANGANYAR',
		'ID3313100' => 'TASIKMADU',
		'ID3313110' => 'JATEN',
		'ID3313120' => 'COLOMADU',
		'ID3313130' => 'GONDANGREJO',
		'ID3313140' => 'KEBAKKRAMAT',
		'ID3313150' => 'MOJOGEDANG',
		'ID3313160' => 'KERJO',
		'ID3313170' => 'JENAWI',
		'ID331410' => 'KALIJAMBE',
		'ID331420' => 'PLUPUH',
		'ID331430' => 'MASARAN',
		'ID331440' => 'KEDAWUNG',
		'ID331450' => 'SAMBIREJO',
		'ID331460' => 'GONDANG',
		'ID331470' => 'SAMBUNG MACAN',
		'ID331480' => 'NGRAMPAL',
		'ID331490' => 'KARANGMALANG',
		'ID3314100' => 'SRAGEN',
		'ID3314110' => 'SIDOHARJO',
		'ID3314120' => 'TANON',
		'ID3314130' => 'GEMOLONG',
		'ID3314140' => 'MIRI',
		'ID3314150' => 'SUMBERLAWANG',
		'ID3314160' => 'MONDOKAN',
		'ID3314170' => 'SUKODONO',
		'ID3314180' => 'GESI',
		'ID3314190' => 'TANGEN',
		'ID3314200' => 'JENAR',
		'ID331510' => 'KEDUNGJATI',
		'ID331520' => 'KARANGRAYUNG',
		'ID331530' => 'PENAWANGAN',
		'ID331540' => 'TOROH',
		'ID331550' => 'GEYER',
		'ID331560' => 'PULOKULON',
		'ID331570' => 'KRADENAN',
		'ID331580' => 'GABUS',
		'ID331590' => 'NGARINGAN',
		'ID3315100' => 'WIROSARI',
		'ID3315110' => 'TAWANGHARJO',
		'ID3315120' => 'GROBOGAN',
		'ID3315130' => 'PURWODADI',
		'ID3315140' => 'BRATI',
		'ID3315150' => 'KLAMBU',
		'ID3315160' => 'GODONG',
		'ID3315170' => 'GUBUG',
		'ID3315180' => 'TEGOWANU',
		'ID3315190' => 'TANGGUNGHARJO',
		'ID331610' => 'JATI',
		'ID331620' => 'RANDUBLATUNG',
		'ID331630' => 'KRADENAN',
		'ID331640' => 'KEDUNGTUBAN',
		'ID331650' => 'CEPU',
		'ID331660' => 'SAMBONG',
		'ID331670' => 'JIKEN',
		'ID331680' => 'BOGOREJO',
		'ID331690' => 'JEPON',
		'ID3316100' => 'KOTA BLORA',
		'ID3316110' => 'BANJAREJO',
		'ID3316120' => 'TUNJUNGAN',
		'ID3316130' => 'JAPAH',
		'ID3316140' => 'NGAWEN',
		'ID3316150' => 'KUNDURAN',
		'ID3316160' => 'TODANAN',
		'ID331710' => 'SUMBER',
		'ID331720' => 'BULU',
		'ID331730' => 'GUNEM',
		'ID331740' => 'SALE',
		'ID331750' => 'SARANG',
		'ID331760' => 'SEDAN',
		'ID331770' => 'PAMOTAN',
		'ID331780' => 'SULANG',
		'ID331790' => 'KALIORI',
		'ID3317100' => 'REMBANG',
		'ID3317110' => 'PANCUR',
		'ID3317120' => 'KRAGAN',
		'ID3317130' => 'SLUKE',
		'ID3317140' => 'LASEM',
		'ID331810' => 'SUKOLILO',
		'ID331820' => 'KAYEN',
		'ID331830' => 'TAMBAKROMO',
		'ID331840' => 'WINONG',
		'ID331850' => 'PUCAKWANGI',
		'ID331860' => 'JAKEN',
		'ID331870' => 'BATANGAN',
		'ID331880' => 'JUWANA',
		'ID331890' => 'JAKENAN',
		'ID3318100' => 'PATI',
		'ID3318110' => 'GABUS',
		'ID3318120' => 'MARGOREJO',
		'ID3318130' => 'GEMBONG',
		'ID3318140' => 'TLOGOWUNGU',
		'ID3318150' => 'WEDARIJAKSA',
		'ID3318160' => 'TRANGKIL',
		'ID3318170' => 'MARGOYOSO',
		'ID3318180' => 'GUNUNG WUNGKAL',
		'ID3318190' => 'CLUWAK',
		'ID3318200' => 'TAYU',
		'ID3318210' => 'DUKUHSETI',
		'ID331910' => 'KALIWUNGU',
		'ID331920' => 'KOTA KUDUS',
		'ID331930' => 'JATI',
		'ID331940' => 'UNDAAN',
		'ID331950' => 'MEJOBO',
		'ID331960' => 'JEKULO',
		'ID331970' => 'BAE',
		'ID331980' => 'GEBOG',
		'ID331990' => 'DAWE',
		'ID332010' => 'KEDUNG',
		'ID332020' => 'PECANGAAN',
		'ID332021' => 'KALINYAMATAN',
		'ID332030' => 'WELAHAN',
		'ID332040' => 'MAYONG',
		'ID332050' => 'NALUMSARI',
		'ID332060' => 'BATEALIT',
		'ID332070' => 'TAHUNAN',
		'ID332080' => 'JEPARA',
		'ID332090' => 'MLONGGO',
		'ID332091' => 'PAKIS AJI',
		'ID3320100' => 'BANGSRI',
		'ID3320101' => 'KEMBANG',
		'ID3320110' => 'KELING',
		'ID3320111' => 'DONOROJO',
		'ID3320120' => 'KARIMUNJAWA',
		'ID332110' => 'MRANGGEN',
		'ID332120' => 'KARANGAWEN',
		'ID332130' => 'GUNTUR',
		'ID332140' => 'SAYUNG',
		'ID332150' => 'KARANG TENGAH',
		'ID332160' => 'BONANG',
		'ID332170' => 'DEMAK',
		'ID332180' => 'WONOSALAM',
		'ID332190' => 'DEMPET',
		'ID332191' => 'KEBONAGUNG',
		'ID3321100' => 'GAJAH',
		'ID3321110' => 'KARANGANYAR',
		'ID3321120' => 'MIJEN',
		'ID3321130' => 'WEDUNG',
		'ID332210' => 'GETASAN',
		'ID332220' => 'TENGARAN',
		'ID332230' => 'SUSUKAN',
		'ID332231' => 'KALIWUNGU',
		'ID332240' => 'SURUH',
		'ID332250' => 'PABELAN',
		'ID332260' => 'TUNTANG',
		'ID332270' => 'BANYUBIRU',
		'ID332280' => 'JAMBU',
		'ID332290' => 'SUMOWONO',
		'ID3322100' => 'AMBARAWA',
		'ID3322101' => 'BANDUNGAN',
		'ID3322110' => 'BAWEN',
		'ID3322120' => 'BRINGIN',
		'ID3322121' => 'BANCAK',
		'ID3322130' => 'PRINGAPUS',
		'ID3322140' => 'BERGAS',
		'ID3322151' => 'UNGARAN BARAT',
		'ID3322152' => 'UNGARAN TIMUR',
		'ID332310' => 'PARAKAN',
		'ID332311' => 'KLEDUNG',
		'ID332312' => 'BANSARI',
		'ID332320' => 'BULU',
		'ID332330' => 'TEMANGGUNG',
		'ID332331' => 'TLOGOMULYO',
		'ID332340' => 'TEMBARAK',
		'ID332341' => 'SELOPAMPANG',
		'ID332350' => 'KRANGGAN',
		'ID332360' => 'PRINGSURAT',
		'ID332370' => 'KALORAN',
		'ID332380' => 'KANDANGAN',
		'ID332390' => 'KEDU',
		'ID3323100' => 'NGADIREJO',
		'ID3323110' => 'JUMO',
		'ID3323111' => 'GEMAWANG',
		'ID3323120' => 'CANDIROTO',
		'ID3323121' => 'BEJEN',
		'ID3323130' => 'TRETEP',
		'ID3323131' => 'WONOBOYO',
		'ID332410' => 'PLANTUNGAN',
		'ID332420' => 'SUKOREJO',
		'ID332430' => 'PAGERRUYUNG',
		'ID332440' => 'PATEAN',
		'ID332450' => 'SINGOROJO',
		'ID332460' => 'LIMBANGAN',
		'ID332470' => 'BOJA',
		'ID332480' => 'KALIWUNGU',
		'ID332481' => 'KALIWUNGU SELATAN',
		'ID332490' => 'BRANGSONG',
		'ID3324100' => 'PEGANDON',
		'ID3324101' => 'NGAMPEL',
		'ID3324110' => 'GEMUH',
		'ID3324111' => 'RINGINARUM',
		'ID3324120' => 'WELERI',
		'ID3324130' => 'ROWOSARI',
		'ID3324140' => 'KANGKUNG',
		'ID3324150' => 'CEPIRING',
		'ID3324160' => 'PATEBON',
		'ID3324170' => 'KOTA KENDAL',
		'ID332510' => 'WONOTUNGGAL',
		'ID332520' => 'BANDAR',
		'ID332530' => 'BLADO',
		'ID332540' => 'REBAN',
		'ID332550' => 'BAWANG',
		'ID332560' => 'TERSONO',
		'ID332570' => 'GRINGSING',
		'ID332580' => 'LIMPUNG',
		'ID332581' => 'BANYUPUTIH',
		'ID332590' => 'SUBAH',
		'ID332591' => 'PECALUNGAN',
		'ID3325100' => 'TULIS',
		'ID3325101' => 'KANDEMAN',
		'ID3325110' => 'BATANG',
		'ID3325120' => 'WARUNG ASEM',
		'ID332610' => 'KANDANGSERANG',
		'ID332620' => 'PANINGGARAN',
		'ID332630' => 'LEBAKBARANG',
		'ID332640' => 'PETUNGKRIONO',
		'ID332650' => 'TALUN',
		'ID332660' => 'DORO',
		'ID332670' => 'KARANGANYAR',
		'ID332680' => 'KAJEN',
		'ID332690' => 'KESESI',
		'ID3326100' => 'SRAGI',
		'ID3326101' => 'SIWALAN',
		'ID3326110' => 'BOJONG',
		'ID3326120' => 'WONOPRINGGO',
		'ID3326130' => 'KEDUNGWUNI',
		'ID3326131' => 'KARANGDADAP',
		'ID3326140' => 'BUARAN',
		'ID3326150' => 'TIRTO',
		'ID3326160' => 'WIRADESA',
		'ID3326161' => 'WONOKERTO',
		'ID332710' => 'MOGA',
		'ID332711' => 'WARUNGPRING',
		'ID332720' => 'PULOSARI',
		'ID332730' => 'BELIK',
		'ID332740' => 'WATUKUMPUL',
		'ID332750' => 'BODEH',
		'ID332760' => 'BANTARBOLANG',
		'ID332770' => 'RANDUDONGKAL',
		'ID332780' => 'PEMALANG',
		'ID332790' => 'TAMAN',
		'ID3327100' => 'PETARUKAN',
		'ID3327110' => 'AMPELGADING',
		'ID3327120' => 'COMAL',
		'ID3327130' => 'ULUJAMI',
		'ID332810' => 'MARGASARI',
		'ID332820' => 'BUMIJAWA',
		'ID332830' => 'BOJONG',
		'ID332840' => 'BALAPULANG',
		'ID332850' => 'PAGERBARANG',
		'ID332860' => 'LEBAKSIU',
		'ID332870' => 'JATINEGARA',
		'ID332880' => 'KEDUNG BANTENG',
		'ID332890' => 'PANGKAH',
		'ID3328100' => 'SLAWI',
		'ID3328110' => 'DUKUHWARU',
		'ID3328120' => 'ADIWERNA',
		'ID3328130' => 'DUKUHTURI',
		'ID3328140' => 'TALANG',
		'ID3328150' => 'TARUB',
		'ID3328160' => 'KRAMAT',
		'ID3328170' => 'SURADADI',
		'ID3328180' => 'WARUREJA',
		'ID332910' => 'SALEM',
		'ID332920' => 'BANTARKAWUNG',
		'ID332930' => 'BUMIAYU',
		'ID332940' => 'PAGUYANGAN',
		'ID332950' => 'SIRAMPOG',
		'ID332960' => 'TONJONG',
		'ID332970' => 'LARANGAN',
		'ID332980' => 'KETANGGUNGAN',
		'ID332990' => 'BANJARHARJO',
		'ID3329100' => 'LOSARI',
		'ID3329110' => 'TANJUNG',
		'ID3329120' => 'KERSANA',
		'ID3329130' => 'BULAKAMBA',
		'ID3329140' => 'WANASARI',
		'ID3329150' => 'SONGGOM',
		'ID3329160' => 'JATIBARANG',
		'ID3329170' => 'BREBES',
		'ID337110' => 'MAGELANG SELATAN',
		'ID337111' => 'MAGELANG TENGAH',
		'ID337120' => 'MAGELANG UTARA',
		'ID337210' => 'LAWEYAN',
		'ID337220' => 'SERENGAN',
		'ID337230' => 'PASAR KLIWON',
		'ID337240' => 'JEBRES',
		'ID337250' => 'BANJARSARI',
		'ID337310' => 'ARGOMULYO',
		'ID337320' => 'TINGKIR',
		'ID337330' => 'SIDOMUKTI',
		'ID337340' => 'SIDOREJO',
		'ID337410' => 'MIJEN',
		'ID337420' => 'GUNUNG PATI',
		'ID337430' => 'BANYUMANIK',
		'ID337440' => 'GAJAH MUNGKUR',
		'ID337450' => 'SEMARANG SELATAN',
		'ID337460' => 'CANDISARI',
		'ID337470' => 'TEMBALANG',
		'ID337480' => 'PEDURUNGAN',
		'ID337490' => 'GENUK',
		'ID3374100' => 'GAYAMSARI',
		'ID3374110' => 'SEMARANG TIMUR',
		'ID3374120' => 'SEMARANG UTARA',
		'ID3374130' => 'SEMARANG TENGAH',
		'ID3374140' => 'SEMARANG BARAT',
		'ID3374150' => 'TUGU',
		'ID3374160' => 'NGALIYAN',
		'ID337510' => 'PEKALONGAN BARAT',
		'ID337520' => 'PEKALONGAN TIMUR',
		'ID337530' => 'PEKALONGAN SELATAN',
		'ID337540' => 'PEKALONGAN UTARA',
		'ID337610' => 'TEGAL SELATAN',
		'ID337620' => 'TEGAL TIMUR',
		'ID337630' => 'TEGAL BARAT',
		'ID337640' => 'MARGADANA',
	],
	'YO' => [
		'ID34110' => 'TEMON',
		'ID34120' => 'WATES',
		'ID34130' => 'PANJATAN',
		'ID34140' => 'GALUR',
		'ID34150' => 'LENDAH',
		'ID34160' => 'SENTOLO',
		'ID34170' => 'PENGASIH',
		'ID34180' => 'KOKAP',
		'ID34190' => 'GIRIMULYO',
		'ID341100' => 'NANGGULAN',
		'ID341110' => 'KALIBAWANG',
		'ID341120' => 'SAMIGALUH',
		'ID34210' => 'SRANDAKAN',
		'ID34220' => 'SANDEN',
		'ID34230' => 'KRETEK',
		'ID34240' => 'PUNDONG',
		'ID34250' => 'BAMBANG LIPURO',
		'ID34260' => 'PANDAK',
		'ID34270' => 'BANTUL',
		'ID34280' => 'JETIS',
		'ID34290' => 'IMOGIRI',
		'ID342100' => 'DLINGO',
		'ID342110' => 'PLERET',
		'ID342120' => 'PIYUNGAN',
		'ID342130' => 'BANGUNTAPAN',
		'ID342140' => 'SEWON',
		'ID342150' => 'KASIHAN',
		'ID342160' => 'PAJANGAN',
		'ID342170' => 'SEDAYU',
		'ID34310' => 'PANGGANG',
		'ID34311' => 'PURWOSARI',
		'ID34320' => 'PALIYAN',
		'ID34330' => 'SAPTO SARI',
		'ID34340' => 'TEPUS',
		'ID34341' => 'TANJUNGSARI',
		'ID34350' => 'RONGKOP',
		'ID34351' => 'GIRISUBO',
		'ID34360' => 'SEMANU',
		'ID34370' => 'PONJONG',
		'ID34380' => 'KARANGMOJO',
		'ID34390' => 'WONOSARI',
		'ID343100' => 'PLAYEN',
		'ID343110' => 'PATUK',
		'ID343120' => 'GEDANG SARI',
		'ID343130' => 'NGLIPAR',
		'ID343140' => 'NGAWEN',
		'ID343150' => 'SEMIN',
		'ID34410' => 'MOYUDAN',
		'ID34420' => 'MINGGIR',
		'ID34430' => 'SEYEGAN',
		'ID34440' => 'GODEAN',
		'ID34450' => 'GAMPING',
		'ID34460' => 'MLATI',
		'ID34470' => 'DEPOK',
		'ID34480' => 'BERBAH',
		'ID34490' => 'PRAMBANAN',
		'ID344100' => 'KALASAN',
		'ID344110' => 'NGEMPLAK',
		'ID344120' => 'NGAGLIK',
		'ID344130' => 'SLEMAN',
		'ID344140' => 'TEMPEL',
		'ID344150' => 'TURI',
		'ID344160' => 'PAKEM',
		'ID344170' => 'CANGKRINGAN',
		'ID347110' => 'MANTRIJERON',
		'ID347120' => 'KRATON',
		'ID347130' => 'MERGANGSAN',
		'ID347140' => 'UMBULHARJO',
		'ID347150' => 'KOTAGEDE',
		'ID347160' => 'GONDOKUSUMAN',
		'ID347170' => 'DANUREJAN',
		'ID347180' => 'PAKUALAMAN',
		'ID347190' => 'GONDOMANAN',
		'ID3471100' => 'NGAMPILAN',
		'ID3471110' => 'WIROBRAJAN',
		'ID3471120' => 'GEDONG TENGEN',
		'ID3471130' => 'JETIS',
		'ID3471140' => 'TEGALREJO',
	],
	'JI' => [
		'ID35110' => 'DONOROJO',
		'ID35120' => 'PUNUNG',
		'ID35130' => 'PRINGKUKU',
		'ID35140' => 'PACITAN',
		'ID35150' => 'KEBONAGUNG',
		'ID35160' => 'ARJOSARI',
		'ID35170' => 'NAWANGAN',
		'ID35180' => 'BANDAR',
		'ID35190' => 'TEGALOMBO',
		'ID351100' => 'TULAKAN',
		'ID351110' => 'NGADIROJO',
		'ID351120' => 'SUDIMORO',
		'ID35210' => 'NGRAYUN',
		'ID35220' => 'SLAHUNG',
		'ID35230' => 'BUNGKAL',
		'ID35240' => 'SAMBIT',
		'ID35250' => 'SAWOO',
		'ID35260' => 'SOOKO',
		'ID35261' => 'PUDAK',
		'ID35270' => 'PULUNG',
		'ID35280' => 'MLARAK',
		'ID35290' => 'SIMAN',
		'ID352100' => 'JETIS',
		'ID352110' => 'BALONG',
		'ID352120' => 'KAUMAN',
		'ID352130' => 'JAMBON',
		'ID352140' => 'BADEGAN',
		'ID352150' => 'SAMPUNG',
		'ID352160' => 'SUKOREJO',
		'ID352170' => 'PONOROGO',
		'ID352180' => 'BABADAN',
		'ID352190' => 'JENANGAN',
		'ID352200' => 'NGEBEL',
		'ID35310' => 'PANGGUL',
		'ID35320' => 'MUNJUNGAN',
		'ID35330' => 'WATULIMO',
		'ID35340' => 'KAMPAK',
		'ID35350' => 'DONGKO',
		'ID35360' => 'PULE',
		'ID35370' => 'KARANGAN',
		'ID35371' => 'SURUH',
		'ID35380' => 'GANDUSARI',
		'ID35390' => 'DURENAN',
		'ID353100' => 'POGALAN',
		'ID353110' => 'TRENGGALEK',
		'ID353120' => 'TUGU',
		'ID353130' => 'BENDUNGAN',
		'ID35410' => 'BESUKI',
		'ID35420' => 'BANDUNG',
		'ID35430' => 'PAKEL',
		'ID35440' => 'CAMPUR DARAT',
		'ID35450' => 'TANGGUNG GUNUNG',
		'ID35460' => 'KALIDAWIR',
		'ID35470' => 'PUCANG LABAN',
		'ID35480' => 'REJOTANGAN',
		'ID35490' => 'NGUNUT',
		'ID354100' => 'SUMBERGEMPOL',
		'ID354110' => 'BOYOLANGU',
		'ID354120' => 'TULUNGAGUNG',
		'ID354130' => 'KEDUNGWARU',
		'ID354140' => 'NGANTRU',
		'ID354150' => 'KARANGREJO',
		'ID354160' => 'KAUMAN',
		'ID354170' => 'GONDANG',
		'ID354180' => 'PAGER WOJO',
		'ID354190' => 'SENDANG',
		'ID35510' => 'BAKUNG',
		'ID35520' => 'WONOTIRTO',
		'ID35530' => 'PANGGUNGREJO',
		'ID35540' => 'WATES',
		'ID35550' => 'BINANGUN',
		'ID35560' => 'SUTOJAYAN',
		'ID35570' => 'KADEMANGAN',
		'ID35580' => 'KANIGORO',
		'ID35590' => 'TALUN',
		'ID355100' => 'SELOPURO',
		'ID355110' => 'KESAMBEN',
		'ID355120' => 'SELOREJO',
		'ID355130' => 'DOKO',
		'ID355140' => 'WLINGI',
		'ID355150' => 'GANDUSARI',
		'ID355160' => 'GARUM',
		'ID355170' => 'NGLEGOK',
		'ID355180' => 'SANANKULON',
		'ID355190' => 'PONGGOK',
		'ID355200' => 'SRENGAT',
		'ID355210' => 'WONODADI',
		'ID355220' => 'UDANAWU',
		'ID35610' => 'MOJO',
		'ID35620' => 'SEMEN',
		'ID35630' => 'NGADILUWIH',
		'ID35640' => 'KRAS',
		'ID35650' => 'RINGINREJO',
		'ID35660' => 'KANDAT',
		'ID35670' => 'WATES',
		'ID35680' => 'NGANCAR',
		'ID35690' => 'PLOSOKLATEN',
		'ID356100' => 'GURAH',
		'ID356110' => 'PUNCU',
		'ID356120' => 'KEPUNG',
		'ID356130' => 'KANDANGAN',
		'ID356140' => 'PARE',
		'ID356141' => 'BADAS',
		'ID356150' => 'KUNJANG',
		'ID356160' => 'PLEMAHAN',
		'ID356170' => 'PURWOASRI',
		'ID356180' => 'PAPAR',
		'ID356190' => 'PAGU',
		'ID356191' => 'KAYEN KIDUL',
		'ID356200' => 'GAMPENGREJO',
		'ID356201' => 'NGASEM',
		'ID356210' => 'BANYAKAN',
		'ID356220' => 'GROGOL',
		'ID356230' => 'TAROKAN',
		'ID35710' => 'DONOMULYO',
		'ID35720' => 'KALIPARE',
		'ID35730' => 'PAGAK',
		'ID35740' => 'BANTUR',
		'ID35750' => 'GEDANGAN',
		'ID35760' => 'SUMBERMANJING',
		'ID35770' => 'DAMPIT',
		'ID35780' => 'TIRTO YUDO',
		'ID35790' => 'AMPELGADING',
		'ID357100' => 'PONCOKUSUMO',
		'ID357110' => 'WAJAK',
		'ID357120' => 'TUREN',
		'ID357130' => 'BULULAWANG',
		'ID357140' => 'GONDANGLEGI',
		'ID357150' => 'PAGELARAN',
		'ID357160' => 'KEPANJEN',
		'ID357170' => 'SUMBER PUCUNG',
		'ID357180' => 'KROMENGAN',
		'ID357190' => 'NGAJUM',
		'ID357200' => 'WONOSARI',
		'ID357210' => 'WAGIR',
		'ID357220' => 'PAKISAJI',
		'ID357230' => 'TAJINAN',
		'ID357240' => 'TUMPANG',
		'ID357250' => 'PAKIS',
		'ID357260' => 'JABUNG',
		'ID357270' => 'LAWANG',
		'ID357280' => 'SINGOSARI',
		'ID357290' => 'KARANGPLOSO',
		'ID357300' => 'DAU',
		'ID357310' => 'PUJON',
		'ID357320' => 'NGANTANG',
		'ID357330' => 'KASEMBON',
		'ID35810' => 'TEMPURSARI',
		'ID35820' => 'PRONOJIWO',
		'ID35830' => 'CANDIPURO',
		'ID35840' => 'PASIRIAN',
		'ID35850' => 'TEMPEH',
		'ID35860' => 'LUMAJANG',
		'ID35861' => 'SUMBERSUKO',
		'ID35870' => 'TEKUNG',
		'ID35880' => 'KUNIR',
		'ID35890' => 'YOSOWILANGUN',
		'ID358100' => 'ROWOKANGKUNG',
		'ID358110' => 'JATIROTO',
		'ID358120' => 'RANDUAGUNG',
		'ID358130' => 'SUKODONO',
		'ID358140' => 'PADANG',
		'ID358150' => 'PASRUJAMBE',
		'ID358160' => 'SENDURO',
		'ID358170' => 'GUCIALIT',
		'ID358180' => 'KEDUNGJAJANG',
		'ID358190' => 'KLAKAH',
		'ID358200' => 'RANUYOSO',
		'ID35910' => 'KENCONG',
		'ID35920' => 'GUMUK MAS',
		'ID35930' => 'PUGER',
		'ID35940' => 'WULUHAN',
		'ID35950' => 'AMBULU',
		'ID35960' => 'TEMPUREJO',
		'ID35970' => 'SILO',
		'ID35980' => 'MAYANG',
		'ID35990' => 'MUMBULSARI',
		'ID359100' => 'JENGGAWAH',
		'ID359110' => 'AJUNG',
		'ID359120' => 'RAMBIPUJI',
		'ID359130' => 'BALUNG',
		'ID359140' => 'UMBULSARI',
		'ID359150' => 'SEMBORO',
		'ID359160' => 'JOMBANG',
		'ID359170' => 'SUMBER BARU',
		'ID359180' => 'TANGGUL',
		'ID359190' => 'BANGSALSARI',
		'ID359200' => 'PANTI',
		'ID359210' => 'SUKORAMBI',
		'ID359220' => 'ARJASA',
		'ID359230' => 'PAKUSARI',
		'ID359240' => 'KALISAT',
		'ID359250' => 'LEDOKOMBO',
		'ID359260' => 'SUMBERJAMBE',
		'ID359270' => 'SUKOWONO',
		'ID359280' => 'JELBUK',
		'ID359710' => 'KALIWATES',
		'ID359720' => 'SUMBERSARI',
		'ID359730' => 'PATRANG',
		'ID351010' => 'PESANGGARAN',
		'ID351011' => 'SILIRAGUNG',
		'ID351020' => 'BANGOREJO',
		'ID351030' => 'PURWOHARJO',
		'ID351040' => 'TEGALDLIMO',
		'ID351050' => 'MUNCAR',
		'ID351060' => 'CLURING',
		'ID351070' => 'GAMBIRAN',
		'ID351071' => 'TEGALSARI',
		'ID351080' => 'GLENMORE',
		'ID351090' => 'KALIBARU',
		'ID3510100' => 'GENTENG',
		'ID3510110' => 'SRONO',
		'ID3510120' => 'ROGOJAMPI',
		'ID3510130' => 'KABAT',
		'ID3510140' => 'SINGOJURUH',
		'ID3510150' => 'SEMPU',
		'ID3510160' => 'SONGGON',
		'ID3510170' => 'GLAGAH',
		'ID3510171' => 'LICIN',
		'ID3510180' => 'BANYUWANGI',
		'ID3510190' => 'GIRI',
		'ID3510200' => 'KALIPURO',
		'ID3510210' => 'WONGSOREJO',
		'ID351110' => 'MAESAN',
		'ID351120' => 'GRUJUGAN',
		'ID351130' => 'TAMANAN',
		'ID351131' => 'JAMBESARI DARUS SHOLAH',
		'ID351140' => 'PUJER',
		'ID351150' => 'TLOGOSARI',
		'ID351160' => 'SUKOSARI',
		'ID351161' => 'SUMBER WRINGIN',
		'ID351170' => 'TAPEN',
		'ID351180' => 'WONOSARI',
		'ID351190' => 'TENGGARANG',
		'ID3511100' => 'BONDOWOSO',
		'ID3511110' => 'CURAH DAMI',
		'ID3511111' => 'BINAKAL',
		'ID3511120' => 'PAKEM',
		'ID3511130' => 'WRINGIN',
		'ID3511140' => 'TEGALAMPEL',
		'ID3511141' => 'TAMAN KROCOK',
		'ID3511150' => 'KLABANG',
		'ID3511151' => 'SEMPOL',
		'ID3511152' => 'BOTOLINGGO',
		'ID3511160' => 'PRAJEKAN',
		'ID3511170' => 'CERMEE',
		'ID351210' => 'SUMBERMALANG',
		'ID351220' => 'JATIBANTENG',
		'ID351230' => 'BANYUGLUGUR',
		'ID351240' => 'BESUKI',
		'ID351250' => 'SUBOH',
		'ID351260' => 'MLANDINGAN',
		'ID351270' => 'BUNGATAN',
		'ID351280' => 'KENDIT',
		'ID351290' => 'PANARUKAN',
		'ID3512100' => 'SITUBONDO',
		'ID3512110' => 'MANGARAN',
		'ID3512120' => 'PANJI',
		'ID3512130' => 'KAPONGAN',
		'ID3512140' => 'ARJASA',
		'ID3512150' => 'JANGKAR',
		'ID3512160' => 'ASEMBAGUS',
		'ID3512170' => 'BANYUPUTIH',
		'ID351310' => 'SUKAPURA',
		'ID351320' => 'SUMBER',
		'ID351330' => 'KURIPAN',
		'ID351340' => 'BANTARAN',
		'ID351350' => 'LECES',
		'ID351360' => 'TEGALSIWALAN',
		'ID351370' => 'BANYUANYAR',
		'ID351380' => 'TIRIS',
		'ID351390' => 'KRUCIL',
		'ID3513100' => 'GADING',
		'ID3513110' => 'PAKUNIRAN',
		'ID3513120' => 'KOTAANYAR',
		'ID3513130' => 'PAITON',
		'ID3513140' => 'BESUK',
		'ID3513150' => 'KRAKSAAN',
		'ID3513160' => 'KREJENGAN',
		'ID3513170' => 'PAJARAKAN',
		'ID3513180' => 'MARON',
		'ID3513190' => 'GENDING',
		'ID3513200' => 'DRINGU',
		'ID3513210' => 'WONOMERTO',
		'ID3513220' => 'LUMBANG',
		'ID3513230' => 'TONGAS',
		'ID3513240' => 'SUMBERASIH',
		'ID351410' => 'PURWODADI',
		'ID351420' => 'TUTUR',
		'ID351430' => 'PUSPO',
		'ID351440' => 'TOSARI',
		'ID351450' => 'LUMBANG',
		'ID351460' => 'PASREPAN',
		'ID351470' => 'KEJAYAN',
		'ID351480' => 'WONOREJO',
		'ID351490' => 'PURWOSARI',
		'ID3514100' => 'PRIGEN',
		'ID3514110' => 'SUKOREJO',
		'ID3514120' => 'PANDAAN',
		'ID3514130' => 'GEMPOL',
		'ID3514140' => 'BEJI',
		'ID3514150' => 'BANGIL',
		'ID3514160' => 'REMBANG',
		'ID3514170' => 'KRATON',
		'ID3514180' => 'POHJENTREK',
		'ID3514190' => 'GONDANG WETAN',
		'ID3514200' => 'REJOSO',
		'ID3514210' => 'WINONGAN',
		'ID3514220' => 'GRATI',
		'ID3514230' => 'LEKOK',
		'ID3514240' => 'NGULING',
		'ID351510' => 'TARIK',
		'ID351520' => 'PRAMBON',
		'ID351530' => 'KREMBUNG',
		'ID351540' => 'PORONG',
		'ID351550' => 'JABON',
		'ID351560' => 'TANGGULANGIN',
		'ID351570' => 'CANDI',
		'ID351580' => 'TULANGAN',
		'ID351590' => 'WONOAYU',
		'ID3515100' => 'SUKODONO',
		'ID3515110' => 'SIDOARJO',
		'ID3515120' => 'BUDURAN',
		'ID3515130' => 'SEDATI',
		'ID3515140' => 'WARU',
		'ID3515150' => 'GEDANGAN',
		'ID3515160' => 'TAMAN',
		'ID3515170' => 'KRIAN',
		'ID3515180' => 'BALONG BENDO',
		'ID351610' => 'JATIREJO',
		'ID351620' => 'GONDANG',
		'ID351630' => 'PACET',
		'ID351640' => 'TRAWAS',
		'ID351650' => 'NGORO',
		'ID351660' => 'PUNGGING',
		'ID351670' => 'KUTOREJO',
		'ID351680' => 'MOJOSARI',
		'ID351690' => 'BANGSAL',
		'ID351691' => 'MOJOANYAR',
		'ID3516100' => 'DLANGGU',
		'ID3516110' => 'PURI',
		'ID3516120' => 'TROWULAN',
		'ID3516130' => 'SOOKO',
		'ID3516140' => 'GEDEK',
		'ID3516150' => 'KEMLAGI',
		'ID3516160' => 'JETIS',
		'ID3516170' => 'DAWAR BLANDONG',
		'ID351710' => 'BANDAR KEDUNG MULYO',
		'ID351720' => 'PERAK',
		'ID351730' => 'GUDO',
		'ID351740' => 'DIWEK',
		'ID351750' => 'NGORO',
		'ID351760' => 'MOJOWARNO',
		'ID351770' => 'BARENG',
		'ID351780' => 'WONOSALAM',
		'ID351790' => 'MOJOAGUNG',
		'ID3517100' => 'SUMOBITO',
		'ID3517110' => 'JOGO ROTO',
		'ID3517120' => 'PETERONGAN',
		'ID3517130' => 'JOMBANG',
		'ID3517140' => 'MEGALUH',
		'ID3517150' => 'TEMBELANG',
		'ID3517160' => 'KESAMBEN',
		'ID3517170' => 'KUDU',
		'ID3517171' => 'NGUSIKAN',
		'ID3517180' => 'PLOSO',
		'ID3517190' => 'KABUH',
		'ID3517200' => 'PLANDAAN',
		'ID351810' => 'SAWAHAN',
		'ID351820' => 'NGETOS',
		'ID351830' => 'BERBEK',
		'ID351840' => 'LOCERET',
		'ID351850' => 'PACE',
		'ID351860' => 'TANJUNGANOM',
		'ID351870' => 'PRAMBON',
		'ID351880' => 'NGRONGGOT',
		'ID351890' => 'KERTOSONO',
		'ID3518100' => 'PATIANROWO',
		'ID3518110' => 'BARON',
		'ID3518120' => 'GONDANG',
		'ID3518130' => 'SUKOMORO',
		'ID3518140' => 'NGANJUK',
		'ID3518150' => 'BAGOR',
		'ID3518160' => 'WILANGAN',
		'ID3518170' => 'REJOSO',
		'ID3518180' => 'NGLUYU',
		'ID3518190' => 'LENGKONG',
		'ID3518200' => 'JATIKALEN',
		'ID351910' => 'KEBONSARI',
		'ID351920' => 'GEGER',
		'ID351930' => 'DOLOPO',
		'ID351940' => 'DAGANGAN',
		'ID351950' => 'WUNGU',
		'ID351960' => 'KARE',
		'ID351970' => 'GEMARANG',
		'ID351980' => 'SARADAN',
		'ID351990' => 'PILANGKENCENG',
		'ID3519100' => 'MEJAYAN',
		'ID3519110' => 'WONOASRI',
		'ID3519120' => 'BALEREJO',
		'ID3519130' => 'MADIUN',
		'ID3519140' => 'SAWAHAN',
		'ID3519150' => 'JIWAN',
		'ID352010' => 'PONCOL',
		'ID352020' => 'PARANG',
		'ID352030' => 'LEMBEYAN',
		'ID352040' => 'TAKERAN',
		'ID352041' => 'NGUNTORONADI',
		'ID352050' => 'KAWEDANAN',
		'ID352060' => 'MAGETAN',
		'ID352061' => 'NGARIBOYO',
		'ID352070' => 'PLAOSAN',
		'ID352071' => 'SIDOREJO',
		'ID352080' => 'PANEKAN',
		'ID352090' => 'SUKOMORO',
		'ID3520100' => 'BENDO',
		'ID3520110' => 'MAOSPATI',
		'ID3520120' => 'KARANGREJO',
		'ID3520121' => 'KARAS',
		'ID3520130' => 'BARAT',
		'ID3520131' => 'KARTOHARJO',
		'ID352110' => 'SINE',
		'ID352120' => 'NGRAMBE',
		'ID352130' => 'JOGOROGO',
		'ID352140' => 'KENDAL',
		'ID352150' => 'GENENG',
		'ID352151' => 'GERIH',
		'ID352160' => 'KWADUNGAN',
		'ID352170' => 'PANGKUR',
		'ID352180' => 'KARANGJATI',
		'ID352190' => 'BRINGIN',
		'ID3521100' => 'PADAS',
		'ID3521101' => 'KASREMAN',
		'ID3521110' => 'NGAWI',
		'ID3521120' => 'PARON',
		'ID3521130' => 'KEDUNGGALAR',
		'ID3521140' => 'PITU',
		'ID3521150' => 'WIDODAREN',
		'ID3521160' => 'MANTINGAN',
		'ID3521170' => 'KARANGANYAR',
		'ID352210' => 'MARGOMULYO',
		'ID352220' => 'NGRAHO',
		'ID352230' => 'TAMBAKREJO',
		'ID352240' => 'NGAMBON',
		'ID352241' => 'SEKAR',
		'ID352250' => 'BUBULAN',
		'ID352251' => 'GONDANG',
		'ID352260' => 'TEMAYANG',
		'ID352270' => 'SUGIHWARAS',
		'ID352280' => 'KEDUNGADEM',
		'ID352290' => 'KEPOH BARU',
		'ID3522100' => 'BAURENO',
		'ID3522110' => 'KANOR',
		'ID3522120' => 'SUMBEREJO',
		'ID3522130' => 'BALEN',
		'ID3522140' => 'SUKOSEWU',
		'ID3522150' => 'KAPAS',
		'ID3522160' => 'BOJONEGORO',
		'ID3522170' => 'TRUCUK',
		'ID3522180' => 'DANDER',
		'ID3522190' => 'NGASEM',
		'ID3522200' => 'KALITIDU',
		'ID3522210' => 'MALO',
		'ID3522220' => 'PURWOSARI',
		'ID3522230' => 'PADANGAN',
		'ID3522240' => 'KASIMAN',
		'ID3522241' => 'KEDEWAN',
		'ID352310' => 'KENDURUAN',
		'ID352320' => 'BANGILAN',
		'ID352330' => 'SENORI',
		'ID352340' => 'SINGGAHAN',
		'ID352350' => 'MONTONG',
		'ID352360' => 'PARENGAN',
		'ID352370' => 'SOKO',
		'ID352380' => 'RENGEL',
		'ID352381' => 'GRABAGAN',
		'ID352390' => 'PLUMPANG',
		'ID3523100' => 'WIDANG',
		'ID3523110' => 'PALANG',
		'ID3523120' => 'SEMANDING',
		'ID3523130' => 'TUBAN',
		'ID3523140' => 'JENU',
		'ID3523150' => 'MERAKURAK',
		'ID3523160' => 'KEREK',
		'ID3523170' => 'TAMBAKBOYO',
		'ID3523180' => 'JATIROGO',
		'ID3523190' => 'BANCAR',
		'ID352410' => 'SUKORAME',
		'ID352420' => 'BLULUK',
		'ID352430' => 'NGIMBANG',
		'ID352440' => 'SAMBENG',
		'ID352450' => 'MANTUP',
		'ID352460' => 'KEMBANGBAHU',
		'ID352470' => 'SUGIO',
		'ID352480' => 'KEDUNGPRING',
		'ID352490' => 'MODO',
		'ID3524100' => 'BABAT',
		'ID3524110' => 'PUCUK',
		'ID3524120' => 'SUKODADI',
		'ID3524130' => 'LAMONGAN',
		'ID3524140' => 'TIKUNG',
		'ID3524141' => 'SARIREJO',
		'ID3524150' => 'DEKET',
		'ID3524160' => 'GLAGAH',
		'ID3524170' => 'KARANGBINANGUN',
		'ID3524180' => 'TURI',
		'ID3524190' => 'KALITENGAH',
		'ID3524200' => 'KARANG GENENG',
		'ID3524210' => 'SEKARAN',
		'ID3524220' => 'MADURAN',
		'ID3524230' => 'LAREN',
		'ID3524240' => 'SOLOKURO',
		'ID3524250' => 'PACIRAN',
		'ID3524260' => 'BRONDONG',
		'ID352510' => 'WRINGINANOM',
		'ID352520' => 'DRIYOREJO',
		'ID352530' => 'KEDAMEAN',
		'ID352540' => 'MENGANTI',
		'ID352550' => 'CERME',
		'ID352560' => 'BENJENG',
		'ID352570' => 'BALONGPANGGANG',
		'ID352580' => 'DUDUKSAMPEYAN',
		'ID352590' => 'KEBOMAS',
		'ID3525100' => 'GRESIK',
		'ID3525110' => 'MANYAR',
		'ID3525120' => 'BUNGAH',
		'ID3525130' => 'SIDAYU',
		'ID3525140' => 'DUKUN',
		'ID3525150' => 'PANCENG',
		'ID3525160' => 'UJUNGPANGKAH',
		'ID3525170' => 'SANGKAPURA',
		'ID3525180' => 'TAMBAK',
		'ID352610' => 'KAMAL',
		'ID352620' => 'LABANG',
		'ID352630' => 'KWANYAR',
		'ID352640' => 'MODUNG',
		'ID352650' => 'BLEGA',
		'ID352660' => 'KONANG',
		'ID352670' => 'GALIS',
		'ID352680' => 'TANAH MERAH',
		'ID352690' => 'TRAGAH',
		'ID3526100' => 'SOCAH',
		'ID3526110' => 'BANGKALAN',
		'ID3526120' => 'BURNEH',
		'ID3526130' => 'AROSBAYA',
		'ID3526140' => 'GEGER',
		'ID3526150' => 'KOKOP',
		'ID3526160' => 'TANJUNGBUMI',
		'ID3526170' => 'SEPULU',
		'ID3526180' => 'KLAMPIS',
		'ID352710' => 'SRESEH',
		'ID352720' => 'TORJUN',
		'ID352721' => 'PANGARENGAN',
		'ID352730' => 'SAMPANG',
		'ID352740' => 'CAMPLONG',
		'ID352750' => 'OMBEN',
		'ID352760' => 'KEDUNGDUNG',
		'ID352770' => 'JRENGIK',
		'ID352780' => 'TAMBELANGAN',
		'ID352790' => 'BANYUATES',
		'ID3527100' => 'ROBATAL',
		'ID3527101' => 'KARANG PENANG',
		'ID3527110' => 'KETAPANG',
		'ID3527120' => 'SOKOBANAH',
		'ID352810' => 'TLANAKAN',
		'ID352820' => 'PADEMAWU',
		'ID352830' => 'GALIS',
		'ID352840' => 'LARANGAN',
		'ID352850' => 'PAMEKASAN',
		'ID352860' => 'PROPPO',
		'ID352870' => 'PALENGAAN',
		'ID352880' => 'PEGANTENAN',
		'ID352890' => 'KADUR',
		'ID3528100' => 'PAKONG',
		'ID3528110' => 'WARU',
		'ID3528120' => 'BATU MARMAR',
		'ID3528130' => 'PASEAN',
		'ID352910' => 'PRAGAAN',
		'ID352920' => 'BLUTO',
		'ID352930' => 'SARONGGI',
		'ID352940' => 'GILIGENTENG',
		'ID352950' => 'TALANGO',
		'ID352960' => 'KALIANGET',
		'ID352970' => 'KOTA SUMENEP',
		'ID352971' => 'BATUAN',
		'ID352980' => 'LENTENG',
		'ID352990' => 'GANDING',
		'ID3529100' => 'GULUK GULUK',
		'ID3529110' => 'PASONGSONGAN',
		'ID3529120' => 'AMBUNTEN',
		'ID3529130' => 'RUBARU',
		'ID3529140' => 'DASUK',
		'ID3529150' => 'MANDING',
		'ID3529160' => 'BATUPUTIH',
		'ID3529170' => 'GAPURA',
		'ID3529180' => 'BATANG BATANG',
		'ID3529190' => 'DUNGKEK',
		'ID3529200' => 'NONGGUNONG',
		'ID3529210' => 'GAYAM',
		'ID3529220' => 'RAAS',
		'ID3529230' => 'SAPEKEN',
		'ID3529240' => 'ARJASA',
		'ID3529241' => 'KANGAYAN',
		'ID3529250' => 'MASALEMBU',
		'ID357110' => 'MOJOROTO',
		'ID357120' => 'KOTA KEDIRI',
		'ID357130' => 'PESANTREN',
		'ID357210' => 'SUKOREJO',
		'ID357220' => 'KEPANJENKIDUL',
		'ID357230' => 'SANANWETAN',
		'ID357310' => 'KEDUNGKANDANG',
		'ID357320' => 'SUKUN',
		'ID357330' => 'KLOJEN',
		'ID357340' => 'BLIMBING',
		'ID357350' => 'LOWOKWARU',
		'ID357410' => 'KADEMANGAN',
		'ID357411' => 'KEDOPOK',
		'ID357420' => 'WONOASIH',
		'ID357430' => 'MAYANGAN',
		'ID357431' => 'KANIGARAN',
		'ID357510' => 'GADINGREJO',
		'ID357520' => 'PURWOREJO',
		'ID357530' => 'BUGULKIDUL',
		'ID357610' => 'PRAJURIT KULON',
		'ID357620' => 'MAGERSARI',
		'ID357710' => 'MANGU HARJO',
		'ID357720' => 'TAMAN',
		'ID357730' => 'KARTOHARJO',
		'ID357810' => 'KARANG PILANG',
		'ID357820' => 'JAMBANGAN',
		'ID357830' => 'GAYUNGAN',
		'ID357840' => 'WONOCOLO',
		'ID357850' => 'TENGGILIS MEJOYO',
		'ID357860' => 'GUNUNG ANYAR',
		'ID357870' => 'RUNGKUT',
		'ID357880' => 'SUKOLILO',
		'ID357890' => 'MULYOREJO',
		'ID3578100' => 'GUBENG',
		'ID3578110' => 'WONOKROMO',
		'ID3578120' => 'DUKUH PAKIS',
		'ID3578130' => 'WIYUNG',
		'ID3578140' => 'LAKARSANTRI',
		'ID3578141' => 'SAMBIKEREP',
		'ID3578150' => 'TANDES',
		'ID3578160' => 'SUKO MANUNGGAL',
		'ID3578170' => 'SAWAHAN',
		'ID3578180' => 'TEGALSARI',
		'ID3578190' => 'GENTENG',
		'ID3578200' => 'TAMBAKSARI',
		'ID3578210' => 'KENJERAN',
		'ID3578211' => 'BULAK',
		'ID3578220' => 'SIMOKERTO',
		'ID3578230' => 'SEMAMPIR',
		'ID3578240' => 'PABEAN CANTIAN',
		'ID3578250' => 'BUBUTAN',
		'ID3578260' => 'KREMBANGAN',
		'ID3578270' => 'ASEMROWO',
		'ID3578280' => 'BENOWO',
		'ID3578281' => 'PAKAL',
		'ID357910' => 'BATU',
		'ID357920' => 'JUNREJO',
		'ID357930' => 'BUMIAJI',
	],
	'BT' => [
		'ID36110' => 'SUMUR',
		'ID36120' => 'CIMANGGU',
		'ID36130' => 'CIBALIUNG',
		'ID36131' => 'CIBITUNG',
		'ID36140' => 'CIKEUSIK',
		'ID36150' => 'CIGEULIS',
		'ID36160' => 'PANIMBANG',
		'ID36161' => 'SOBANG',
		'ID36170' => 'MUNJUL',
		'ID36171' => 'ANGSANA',
		'ID36172' => 'SINDANGRESMI',
		'ID36180' => 'PICUNG',
		'ID36190' => 'BOJONG',
		'ID361100' => 'SAKETI',
		'ID361101' => 'CISATA',
		'ID361110' => 'PAGELARAN',
		'ID361111' => 'PATIA',
		'ID361112' => 'SUKARESMI',
		'ID361120' => 'LABUAN',
		'ID361121' => 'CARITA',
		'ID361130' => 'JIPUT',
		'ID361131' => 'CIKEDAL',
		'ID361140' => 'MENES',
		'ID361141' => 'PULOSARI',
		'ID361150' => 'MANDALAWANGI',
		'ID361160' => 'CIMANUK',
		'ID361161' => 'CIPEUCANG',
		'ID361170' => 'BANJAR',
		'ID361171' => 'KADUHEJO',
		'ID361172' => 'MEKARJAYA',
		'ID361180' => 'PANDEGLANG',
		'ID361181' => 'MAJASARI',
		'ID361190' => 'CADASARI',
		'ID361191' => 'KARANGTANJUNG',
		'ID361192' => 'KORONCONG',
		'ID36210' => 'MALINGPING',
		'ID36211' => 'WANASALAM',
		'ID36220' => 'PANGGARANGAN',
		'ID36221' => 'CIHARA',
		'ID36230' => 'BAYAH',
		'ID36231' => 'CILOGRANG',
		'ID36240' => 'CIBEBER',
		'ID36250' => 'CIJAKU',
		'ID36251' => 'CIGEMBLONG',
		'ID36260' => 'BANJARSARI',
		'ID36270' => 'CILELES',
		'ID36280' => 'GUNUNG KENCANA',
		'ID36290' => 'BOJONGMANIK',
		'ID36291' => 'CIRINTEN',
		'ID362100' => 'LEUWIDAMAR',
		'ID362110' => 'MUNCANG',
		'ID362111' => 'SOBANG',
		'ID362120' => 'CIPANAS',
		'ID362121' => 'LEBAKGEDONG',
		'ID362130' => 'SAJIRA',
		'ID362140' => 'CIMARGA',
		'ID362150' => 'CIKULUR',
		'ID362160' => 'WARUNGGUNUNG',
		'ID362170' => 'CIBADAK',
		'ID362180' => 'RANGKASBITUNG',
		'ID362181' => 'KALANGANYAR',
		'ID362190' => 'MAJA',
		'ID362191' => 'CURUGBITUNG',
		'ID36310' => 'CISOKA',
		'ID36311' => 'SOLEAR',
		'ID36320' => 'TIGARAKSA',
		'ID36321' => 'JAMBE',
		'ID36330' => 'CIKUPA',
		'ID36340' => 'PANONGAN',
		'ID36350' => 'CURUG',
		'ID36351' => 'KELAPA DUA',
		'ID36360' => 'LEGOK',
		'ID36370' => 'PAGEDANGAN',
		'ID36381' => 'CISAUK',
		'ID363120' => 'PASARKEMIS',
		'ID363121' => 'SINDANG JAYA',
		'ID363130' => 'BALARAJA',
		'ID363131' => 'JAYANTI',
		'ID363132' => 'SUKAMULYA',
		'ID363140' => 'KRESEK',
		'ID363141' => 'GUNUNG KALER',
		'ID363150' => 'KRONJO',
		'ID363151' => 'MEKAR BARU',
		'ID363160' => 'MAUK',
		'ID363161' => 'KEMIRI',
		'ID363162' => 'SUKADIRI',
		'ID363170' => 'RAJEG',
		'ID363180' => 'SEPATAN',
		'ID363181' => 'SEPATAN TIMUR',
		'ID363190' => 'PAKUHAJI',
		'ID363200' => 'TELUKNAGA',
		'ID363210' => 'KOSAMBI',
		'ID36410' => 'CINANGKA',
		'ID36420' => 'PADARINCANG',
		'ID36430' => 'CIOMAS',
		'ID36440' => 'PABUARAN',
		'ID36441' => 'GUNUNG SARI',
		'ID36450' => 'BAROS',
		'ID36460' => 'PETIR',
		'ID36461' => 'TUNJUNG TEJA',
		'ID36480' => 'CIKEUSAL',
		'ID36490' => 'PAMARAYAN',
		'ID36491' => 'BANDUNG',
		'ID364100' => 'JAWILAN',
		'ID364110' => 'KOPO',
		'ID364120' => 'CIKANDE',
		'ID364121' => 'KIBIN',
		'ID364130' => 'KRAGILAN',
		'ID364180' => 'WARINGINKURUNG',
		'ID364190' => 'MANCAK',
		'ID364200' => 'ANYAR',
		'ID364210' => 'BOJONEGARA',
		'ID364211' => 'PULO AMPEL',
		'ID364220' => 'KRAMATWATU',
		'ID364240' => 'CIRUAS',
		'ID364250' => 'PONTANG',
		'ID364260' => 'CARENANG',
		'ID364261' => 'BINUANG',
		'ID364270' => 'TIRTAYASA',
		'ID364271' => 'TANARA',
		'ID367110' => 'CILEDUG',
		'ID367111' => 'LARANGAN',
		'ID367112' => 'KARANG TENGAH',
		'ID367120' => 'CIPONDOH',
		'ID367121' => 'PINANG',
		'ID367130' => 'TANGERANG',
		'ID367131' => 'KARAWACI',
		'ID367140' => 'JATI UWUNG',
		'ID367141' => 'CIBODAS',
		'ID367142' => 'PERIUK',
		'ID367150' => 'BATUCEPER',
		'ID367151' => 'NEGLASARI',
		'ID367160' => 'BENDA',
		'ID367210' => 'CIWANDAN',
		'ID367211' => 'CITANGKIL',
		'ID367220' => 'PULOMERAK',
		'ID367221' => 'PURWAKARTA',
		'ID367222' => 'GROGOL',
		'ID367230' => 'CILEGON',
		'ID367231' => 'JOMBANG',
		'ID367240' => 'CIBEBER',
		'ID367310' => 'CURUG',
		'ID367320' => 'WALANTAKA',
		'ID367330' => 'CIPOCOK JAYA',
		'ID367340' => 'SERANG',
		'ID367350' => 'TAKTAKAN',
		'ID367360' => 'KASEMEN',
		'ID367410' => 'SETU',
		'ID367420' => 'SERPONG',
		'ID367430' => 'PAMULANG',
		'ID367440' => 'CIPUTAT',
		'ID367450' => 'CIPUTAT TIMUR',
		'ID367460' => 'PONDOK AREN',
		'ID367470' => 'SERPONG UTARA',
	],
	'BA' => [
		'ID51110' => 'MELAYA',
		'ID51120' => 'NEGARA',
		'ID51121' => 'JEMBRANA',
		'ID51130' => 'MENDOYO',
		'ID51140' => 'PEKUTATAN',
		'ID51210' => 'SELEMADEG',
		'ID51211' => 'SELEMADEG TIMUR',
		'ID51212' => 'SELEMADEG BARAT',
		'ID51220' => 'KERAMBITAN',
		'ID51230' => 'TABANAN',
		'ID51240' => 'KEDIRI',
		'ID51250' => 'MARGA',
		'ID51260' => 'BATURITI',
		'ID51270' => 'PENEBEL',
		'ID51280' => 'PUPUAN',
		'ID51310' => 'KUTA SELATAN',
		'ID51320' => 'KUTA',
		'ID51330' => 'KUTA UTARA',
		'ID51340' => 'MENGWI',
		'ID51350' => 'ABIANSEMAL',
		'ID51360' => 'PETANG',
		'ID51410' => 'SUKAWATI',
		'ID51420' => 'BLAHBATUH',
		'ID51430' => 'GIANYAR',
		'ID51440' => 'TAMPAKSIRING',
		'ID51450' => 'UBUD',
		'ID51460' => 'TEGALLALANG',
		'ID51470' => 'PAYANGAN',
		'ID51510' => 'NUSAPENIDA',
		'ID51520' => 'BANJARANGKAN',
		'ID51530' => 'KLUNGKUNG',
		'ID51540' => 'DAWAN',
		'ID51610' => 'SUSUT',
		'ID51620' => 'BANGLI',
		'ID51630' => 'TEMBUKU',
		'ID51640' => 'KINTAMANI',
		'ID51710' => 'RENDANG',
		'ID51720' => 'SIDEMEN',
		'ID51730' => 'MANGGIS',
		'ID51740' => 'KARANGASEM',
		'ID51750' => 'ABANG',
		'ID51760' => 'BEBANDEM',
		'ID51770' => 'SELAT',
		'ID51780' => 'KUBU',
		'ID51810' => 'GEROKGAK',
		'ID51820' => 'SERIRIT',
		'ID51830' => 'BUSUNGBIU',
		'ID51840' => 'BANJAR',
		'ID51850' => 'SUKASADA',
		'ID51860' => 'BULELENG',
		'ID51870' => 'SAWAN',
		'ID51880' => 'KUBUTAMBAHAN',
		'ID51890' => 'TEJAKULA',
		'ID517110' => 'DENPASAR SELATAN',
		'ID517120' => 'DENPASAR TIMUR',
		'ID517130' => 'DENPASAR BARAT',
		'ID517131' => 'DENPASAR UTARA',
	],
	'NB' => [
		'ID52110' => 'SEKOTONG TENGAH',
		'ID52111' => 'LEMBAR',
		'ID52120' => 'GERUNG',
		'ID52130' => 'LABU API',
		'ID52140' => 'KEDIRI',
		'ID52141' => 'KURIPAN',
		'ID52150' => 'NARMADA',
		'ID52151' => 'LINGSAR',
		'ID52160' => 'GUNUNG SARI',
		'ID52161' => 'BATU LAYAR',
		'ID521900' => 'LAINNYA',
		'ID52210' => 'PRAYA BARAT',
		'ID52211' => 'PRAYA BARAT DAYA',
		'ID52220' => 'PUJUT',
		'ID52230' => 'PRAYA TIMUR',
		'ID52240' => 'JANAPRIA',
		'ID52250' => 'KOPANG',
		'ID52260' => 'PRAYA',
		'ID52261' => 'PRAYA TENGAH',
		'ID52270' => 'JONGGAT',
		'ID52280' => 'PRINGGARATA',
		'ID52290' => 'BATUKLIANG',
		'ID52291' => 'BATUKLIANG UTARA',
		'ID52310' => 'KERUAK',
		'ID52311' => 'JEROWARU',
		'ID52320' => 'SAKRA',
		'ID52321' => 'SAKRA BARAT',
		'ID52322' => 'SAKRA TIMUR',
		'ID52330' => 'TERARA',
		'ID52331' => 'MONTONG GADING',
		'ID52340' => 'SIKUR',
		'ID52350' => 'MASBAGIK',
		'ID52351' => 'PRINGGASELA',
		'ID52360' => 'SUKAMULIA',
		'ID52361' => 'SURALAGA',
		'ID52370' => 'SELONG',
		'ID52371' => 'LABUHAN HAJI',
		'ID52380' => 'PRINGGABAYA',
		'ID52381' => 'SUELA',
		'ID52390' => 'AIKMEL',
		'ID52391' => 'WANASABA',
		'ID52392' => 'SEMBALUN',
		'ID523100' => 'SAMBELIA',
		'ID52420' => 'LUNYUK',
		'ID52421' => 'ORONG TELU',
		'ID52450' => 'ALAS',
		'ID52451' => 'ALAS BARAT',
		'ID52452' => 'BUER',
		'ID52461' => 'UTAN',
		'ID52462' => 'RHEE',
		'ID52470' => 'BATULANTEH',
		'ID52480' => 'SUMBAWA',
		'ID52481' => 'LABUHAN BADAS',
		'ID52482' => 'UNTER IWES',
		'ID52490' => 'MOYOHILIR',
		'ID52491' => 'MOYO UTARA',
		'ID524100' => 'MOYOHULU',
		'ID524110' => 'ROPANG',
		'ID524111' => 'LENANGGUAR',
		'ID524112' => 'LANTUNG',
		'ID524121' => 'LAPE',
		'ID524122' => 'LOPOK',
		'ID524130' => 'PLAMPANG',
		'ID524131' => 'LABANGKA',
		'ID524132' => 'MARONGE',
		'ID524140' => 'EMPANG',
		'ID524141' => 'TARANO',
		'ID52510' => 'HUU',
		'ID52511' => 'PAJO',
		'ID52520' => 'DOMPU',
		'ID52530' => 'WOJA',
		'ID52540' => 'KILO',
		'ID52550' => 'KEMPO',
		'ID52551' => 'MANGGALEWA',
		'ID52560' => 'PEKAT',
		'ID52610' => 'MONTA',
		'ID52611' => 'PARADO',
		'ID52620' => 'BOLO',
		'ID52621' => 'MADA PANGGA',
		'ID52630' => 'WOHA',
		'ID52640' => 'BELO',
		'ID52641' => 'PALIBELO',
		'ID52650' => 'WAWO',
		'ID52651' => 'LANGGUDU',
		'ID52652' => 'LAMBITU',
		'ID52660' => 'SAPE',
		'ID52661' => 'LAMBU',
		'ID52670' => 'WERA',
		'ID52671' => 'AMBALAWI',
		'ID52680' => 'DONGGO',
		'ID52681' => 'SOROMANDI',
		'ID52690' => 'SANGGAR',
		'ID52691' => 'TAMBORA',
		'ID52710' => 'SEKONGKANG',
		'ID52720' => 'JEREWEH',
		'ID52721' => 'MALUK',
		'ID52730' => 'TALIWANG',
		'ID52731' => 'BRANG ENE',
		'ID52740' => 'BRANG REA',
		'ID52750' => 'SETELUK',
		'ID52751' => 'POTO TANO',
		'ID52810' => 'PEMENANG',
		'ID52820' => 'TANJUNG',
		'ID52830' => 'GANGGA',
		'ID52840' => 'KAYANGAN',
		'ID52850' => 'BAYAN',
		'ID527110' => 'AMPENAN',
		'ID527111' => 'SEKARBELA',
		'ID527120' => 'MATARAM',
		'ID527121' => 'SELAPARANG',
		'ID527130' => 'CAKRANEGARA',
		'ID527131' => 'SANDUBAYA',
		'ID527210' => 'RASANAE BARAT',
		'ID527211' => 'MPUNDA',
		'ID527220' => 'RASANAE TIMUR',
		'ID527221' => 'RABA',
		'ID527230' => 'ASAKOTA',
	],
	'NT' => [
		'ID53121' => 'LAMBOYA',
		'ID53122' => 'WANOKAKA',
		'ID53123' => 'LABOYA BARAT',
		'ID53150' => 'LOLI',
		'ID53160' => 'KOTA WAIKABUBAK',
		'ID53172' => 'TANA RIGHU',
		'ID53210' => 'LEWA',
		'ID53211' => 'NGGAHA ORIANGU',
		'ID53212' => 'LEWA TIDAHU',
		'ID53213' => 'KATALA HAMU LINGU',
		'ID53220' => 'TABUNDUNG',
		'ID53221' => 'PINUPAHAR',
		'ID53230' => 'PABERIWAI',
		'ID53231' => 'KARERA',
		'ID53232' => 'MATAWAI LA PAWU',
		'ID53233' => 'KAHAUNGU ETI',
		'ID53234' => 'MAHU',
		'ID53235' => 'NGADU NGALA',
		'ID53240' => 'PAHUNGA LODU',
		'ID53241' => 'WULA WAIJELU',
		'ID53251' => 'RINDI',
		'ID53252' => 'UMALULU',
		'ID53260' => 'PANDAWAI',
		'ID53261' => 'KAMBATA MAPAMBUHANG',
		'ID53270' => 'KOTA WAINGAPU',
		'ID53271' => 'KAMBERA',
		'ID53280' => 'HAHARU',
		'ID53281' => 'KANATANG',
		'ID533100' => 'SEMAU',
		'ID533101' => 'SEMAU SELATAN',
		'ID533110' => 'KUPANG BARAT',
		'ID533111' => 'NEKAMESE',
		'ID533120' => 'KUPANG TENGAH',
		'ID533121' => 'TAEBENU',
		'ID533130' => 'AMARASI',
		'ID533131' => 'AMARASI BARAT',
		'ID533132' => 'AMARASI SELATAN',
		'ID533133' => 'AMARASI TIMUR',
		'ID533140' => 'KUPANG TIMUR',
		'ID533141' => 'AMABI OEFETO TIMUR',
		'ID533142' => 'AMABI OEFETO',
		'ID533150' => 'SULAMU',
		'ID533160' => 'FATULEU',
		'ID533161' => 'FATULEU TENGAH',
		'ID533162' => 'FATULEU BARAT',
		'ID533170' => 'TAKARI',
		'ID533180' => 'AMFOANG SELATAN',
		'ID533181' => 'AMFOANG BARAT DAYA',
		'ID533182' => 'AMFOANG TENGAH',
		'ID533190' => 'AMFOANG UTARA',
		'ID533191' => 'AMFOANG BARAT LAUT',
		'ID533192' => 'AMFOANG TIMUR',
		'ID53410' => 'MOLLO UTARA',
		'ID53411' => 'FATUMNASI',
		'ID53412' => 'TOBU',
		'ID53413' => 'NUNBENA',
		'ID53420' => 'MOLLO SELATAN',
		'ID53421' => 'POLEN',
		'ID53422' => 'MOLLO BARAT',
		'ID53423' => 'MOLLO TENGAH',
		'ID53430' => 'KOTA SOE',
		'ID53440' => 'AMANUBAN BARAT',
		'ID53441' => 'BATU PUTIH',
		'ID53442' => 'KUATNANA',
		'ID53450' => 'AMANUBAN SELATAN',
		'ID53451' => 'NOEBEBA',
		'ID53460' => 'KUAN FATU',
		'ID53461' => 'KUALIN',
		'ID53470' => 'AMANUBAN TENGAH',
		'ID53471' => 'KOLBANO',
		'ID53472' => 'OENINO',
		'ID53480' => 'AMANUBAN TIMUR',
		'ID53481' => 'FAUTMOLO',
		'ID53482' => 'FATUKOPA',
		'ID53490' => 'KIE',
		'ID53491' => 'KOTOLIN',
		'ID534100' => 'AMANATUN SELATAN',
		'ID534101' => 'BOKING',
		'ID534102' => 'NUNKOLO',
		'ID534103' => 'NOEBANA',
		'ID534104' => 'SANTIAN',
		'ID534110' => 'AMANATUN UTARA',
		'ID534111' => 'TOIANAS',
		'ID534112' => 'KOKBAUN',
		'ID53510' => 'MIOMAFFO BARAT',
		'ID53511' => 'MIOMAFFO TENGAH',
		'ID53512' => 'MUSI',
		'ID53513' => 'MUTIS',
		'ID53520' => 'MIOMAFFO TIMUR',
		'ID53521' => 'NOEMUTI',
		'ID53522' => 'BIKOMI SELATAN',
		'ID53523' => 'BIKOMI TENGAH',
		'ID53524' => 'BIKOMI NILULAT',
		'ID53525' => 'BIKOMI UTARA',
		'ID53526' => 'NAIBENU',
		'ID53527' => 'NOEMUTI TIMUR',
		'ID53530' => 'KOTA KEFAMENANU',
		'ID53540' => 'INSANA',
		'ID53541' => 'INSANA UTARA',
		'ID53542' => 'INSANA BARAT',
		'ID53543' => 'INSANA TENGAH',
		'ID53544' => 'INSANA FAFINESU',
		'ID53550' => 'BIBOKI SELATAN',
		'ID53551' => 'BIBOKI TANPAH',
		'ID53552' => 'BIBOKI MOENLEU',
		'ID53560' => 'BIBOKI UTARA',
		'ID53561' => 'BIBOKI ANLEU',
		'ID53562' => 'BIBOKI FEOTLEU',
		'ID53610' => 'MALAKA BARAT',
		'ID53611' => 'RINHAT',
		'ID53612' => 'WEWIKU',
		'ID53613' => 'WELIMAN',
		'ID53620' => 'MALAKA TENGAH',
		'ID53621' => 'SASITA MEAN',
		'ID53622' => 'BOTIN LEOBELE',
		'ID53623' => 'IO KUFEU',
		'ID53630' => 'MALAKA TIMUR',
		'ID53631' => 'LAEN MANEN',
		'ID53632' => 'RAI MANUK',
		'ID53640' => 'KOBALIMA',
		'ID53641' => 'KOBALIMA TIMUR',
		'ID53650' => 'TASIFETO BARAT',
		'ID53651' => 'KAKULUK MESAK',
		'ID53652' => 'NANAET DUBESI',
		'ID53660' => 'ATAMBUA',
		'ID53661' => 'ATAMBUA BARAT',
		'ID53662' => 'ATAMBUA SELATAN',
		'ID53670' => 'TASIFETO TIMUR',
		'ID53671' => 'RAIHAT',
		'ID53672' => 'LASIOLAT',
		'ID53680' => 'LAMAKNEN',
		'ID53681' => 'LAMAKNEN SELATAN',
		'ID53710' => 'PANTAR',
		'ID53711' => 'PANTAR BARAT',
		'ID53712' => 'PANTAR TIMUR',
		'ID53713' => 'PANTAR BARAT LAUT',
		'ID53714' => 'PANTAR TENGAH',
		'ID53720' => 'ALOR BARAT DAYA',
		'ID53721' => 'MATARU',
		'ID53730' => 'ALOR SELATAN',
		'ID53740' => 'ALOR TIMUR',
		'ID53741' => 'ALOR TIMUR LAUT',
		'ID53742' => 'PUREMAN',
		'ID53750' => 'TELUK MUTIARA',
		'ID53751' => 'KABOLA',
		'ID53760' => 'ALOR BARAT LAUT',
		'ID53761' => 'ALOR TENGAH UTARA',
		'ID53762' => 'PULAU PURA',
		'ID53763' => 'LEMBUR',
		'ID53810' => 'NAGAWUTUNG',
		'ID53811' => 'WULANDONI',
		'ID53820' => 'ATADEI',
		'ID53830' => 'ILE APE',
		'ID53831' => 'ILE APE TIMUR',
		'ID53840' => 'LEBATUKAN',
		'ID53850' => 'NUBATUKAN',
		'ID53860' => 'OMESURI',
		'ID53870' => 'BUYASARI',
		'ID53910' => 'WULANGGITANG',
		'ID53911' => 'TITEHENA',
		'ID53912' => 'ILEBURA',
		'ID53920' => 'TANJUNG BUNGA',
		'ID53921' => 'LEWO LEMA',
		'ID53930' => 'LARANTUKA',
		'ID53931' => 'ILE MANDIRI',
		'ID53932' => 'DEMON PAGONG',
		'ID53940' => 'SOLOR BARAT',
		'ID53941' => 'SOLOR SELATAN',
		'ID53950' => 'SOLOR TIMUR',
		'ID53960' => 'ADONARA BARAT',
		'ID53961' => 'WOTAN ULU MADO',
		'ID53962' => 'ADONARA TENGAH',
		'ID53970' => 'ADONARA TIMUR',
		'ID53971' => 'ILE BOLENG',
		'ID53972' => 'WITIHAMA',
		'ID53973' => 'KELUBAGOLIT',
		'ID53974' => 'ADONARA',
		'ID531010' => 'PAGA',
		'ID531011' => 'MEGO',
		'ID531012' => 'TANA WAWO',
		'ID531020' => 'LELA',
		'ID531030' => 'BOLA',
		'ID531031' => 'DORENG',
		'ID531032' => 'MAPITARA',
		'ID531040' => 'TALIBURA',
		'ID531041' => 'WAIGETE',
		'ID531042' => 'WAIBLAMA',
		'ID531050' => 'KEWAPANTE',
		'ID531051' => 'HEWOKLOANG',
		'ID531052' => 'KANGAE',
		'ID531061' => 'PALUE',
		'ID531062' => 'KOTING',
		'ID531063' => 'NELLE',
		'ID531070' => 'NITA',
		'ID531071' => 'MAGEPANDA',
		'ID531080' => 'ALOK',
		'ID531081' => 'ALOK BARAT',
		'ID531082' => 'ALOK TIMUR',
		'ID531110' => 'NANGAPANDA',
		'ID531111' => 'PULAU ENDE',
		'ID531112' => 'MAUKARO',
		'ID531120' => 'ENDE',
		'ID531130' => 'ENDE SELATAN',
		'ID531131' => 'ENDE TIMUR',
		'ID531132' => 'ENDE TENGAH',
		'ID531133' => 'ENDE UTARA',
		'ID531140' => 'NDONA',
		'ID531141' => 'NDONA TIMUR',
		'ID531150' => 'WOLOWARU',
		'ID531151' => 'WOLOJITA',
		'ID531152' => 'LIO TIMUR',
		'ID531153' => 'KELIMUTU',
		'ID531154' => 'NDORI',
		'ID531160' => 'MAUROLE',
		'ID531161' => 'KOTABARU',
		'ID531162' => 'DETUKELI',
		'ID531170' => 'DETUSOKO',
		'ID531171' => 'WEWARIA',
		'ID531210' => 'AIMERE',
		'ID531211' => 'JEREBUU',
		'ID531220' => 'BAJAWA',
		'ID531230' => 'GOLEWA',
		'ID531270' => 'BAJAWA UTARA',
		'ID531271' => 'SOA',
		'ID531280' => 'RIUNG',
		'ID531281' => 'RIUNG BARAT',
		'ID531282' => 'WOLOMEZE',
		'ID531340' => 'SATAR MESE',
		'ID531341' => 'SATAR MESE BARAT',
		'ID5313110' => 'LANGKE REMBONG',
		'ID5313120' => 'RUTENG',
		'ID5313121' => 'WAE RII',
		'ID5313122' => 'LELAK',
		'ID5313123' => 'RAHONG UTARA',
		'ID5313130' => 'CIBAL',
		'ID5313140' => 'REOK',
		'ID531410' => 'ROTE BARAT DAYA',
		'ID531420' => 'ROTE BARAT LAUT',
		'ID531430' => 'LOBALAIN',
		'ID531440' => 'ROTE TENGAH',
		'ID531441' => 'ROTE SELATAN',
		'ID531450' => 'PANTAI BARU',
		'ID531460' => 'ROTE TIMUR',
		'ID531470' => 'ROTE BARAT',
		'ID531510' => 'KOMODO',
		'ID531511' => 'BOLENG',
		'ID531520' => 'SANO NGGOANG',
		'ID531530' => 'LEMBOR',
		'ID531531' => 'WELAK',
		'ID531540' => 'KUWUS',
		'ID531550' => 'MACANG PACAR',
		'ID531610' => 'KATIKUTANA',
		'ID531611' => 'KATIKUTANA SELATAN',
		'ID531620' => 'UMBU RATU NGGAY BARAT',
		'ID531630' => 'UMBU RATU NGGAY',
		'ID531640' => 'MAMBORO',
		'ID531710' => 'KODI BANGEDO',
		'ID531720' => 'KODI',
		'ID531730' => 'KODI UTARA',
		'ID531740' => 'WEWEWA SELATAN',
		'ID531750' => 'WEWEWA BARAT',
		'ID531760' => 'WEWEWA TIMUR',
		'ID531770' => 'WEWEWA UTARA',
		'ID531780' => 'LOURA',
		'ID531810' => 'MAUPONGGO',
		'ID531820' => 'KEO TENGAH',
		'ID531830' => 'NANGARORO',
		'ID531840' => 'BOAWAE',
		'ID531850' => 'AESESA SELATAN',
		'ID531860' => 'AESESA',
		'ID531870' => 'WOLOWAE',
		'ID531910' => 'BORONG',
		'ID531920' => 'KOTA KOMBA',
		'ID531930' => 'ELAR',
		'ID531940' => 'SAMBI RAMPAS',
		'ID531950' => 'POCO RANAKA',
		'ID531960' => 'LAMBA LEDA',
		'ID532010' => 'RAIJUA',
		'ID532020' => 'HAWU MEHARA',
		'ID532030' => 'SABU LIAE',
		'ID532040' => 'SABU BARAT',
		'ID532050' => 'SABU TENGAH',
		'ID532060' => 'SABU TIMUR',
		'ID537110' => 'ALAK',
		'ID537120' => 'MAULAFA',
		'ID537130' => 'OEBOBO',
		'ID537140' => 'KELAPA LIMA',
	],
	'NB' => [
		'ID61110' => 'SELAKAU',
		'ID61111' => 'SELAKAU TIMUR',
		'ID61120' => 'PEMANGKAT',
		'ID61121' => 'SEMPARUK',
		'ID61122' => 'SALATIGA',
		'ID61130' => 'TEBAS',
		'ID61131' => 'TEKARANG',
		'ID61140' => 'SAMBAS',
		'ID61141' => 'SUBAH',
		'ID61142' => 'SEBAWI',
		'ID61143' => 'SAJAD',
		'ID61150' => 'JAWAI',
		'ID61151' => 'JAWAI SELATAN',
		'ID61160' => 'TELUK KERAMAT',
		'ID61161' => 'GALING',
		'ID61162' => 'TANGARAN',
		'ID61170' => 'SEJANGKUNG',
		'ID61180' => 'SAJINGAN BESAR',
		'ID61190' => 'PALOH',
		'ID61210' => 'SUNGAI RAYA',
		'ID61211' => 'CAPKALA',
		'ID61212' => 'SUNGAI RAYA KEPULAUAN',
		'ID61230' => 'SAMALANTAN',
		'ID61231' => 'MONTERADO',
		'ID61232' => 'LEMBAH BAWANG',
		'ID61240' => 'BENGKAYANG',
		'ID61241' => 'TERIAK',
		'ID61242' => 'SUNGAI BETUNG',
		'ID61250' => 'LEDO',
		'ID61251' => 'SUTI SEMARANG',
		'ID61252' => 'LUMAR',
		'ID61260' => 'SANGGAU LEDO',
		'ID61261' => 'TUJUHBELAS',
		'ID61270' => 'SELUAS',
		'ID61280' => 'JAGOI BABANG',
		'ID61281' => 'SIDING',
		'ID61320' => 'SEBANGKI',
		'ID61330' => 'NGABANG',
		'ID61331' => 'JELIMPO',
		'ID61340' => 'SENGAH TEMILA',
		'ID61350' => 'MANDOR',
		'ID61360' => 'MENJALIN',
		'ID61370' => 'MEMPAWAH HULU',
		'ID61371' => 'SOMPAK',
		'ID61380' => 'MENYUKE',
		'ID61381' => 'BANYUKE HULU',
		'ID61390' => 'MERANTI',
		'ID613100' => 'KUALA BEHE',
		'ID613110' => 'AIR BESAR',
		'ID61480' => 'SIANTAN',
		'ID61481' => 'SEGEDONG',
		'ID61490' => 'SUNGAI PINYUH',
		'ID61491' => 'ANJONGAN',
		'ID614100' => 'MEMPAWAH HILIR',
		'ID614101' => 'MEMPAWAH TIMUR',
		'ID614110' => 'SUNGAI KUNYIT',
		'ID614120' => 'TOHO',
		'ID614121' => 'SADANIANG',
		'ID61510' => 'TOBA',
		'ID61520' => 'MELIAU',
		'ID61560' => 'KAPUAS',
		'ID61570' => 'MUKOK',
		'ID615120' => 'JANGKANG',
		'ID615130' => 'BONTI',
		'ID615140' => 'PARINDU',
		'ID615150' => 'TAYAN HILIR',
		'ID615160' => 'BALAI',
		'ID615170' => 'TAYAN HULU',
		'ID615180' => 'KEMBAYAN',
		'ID615190' => 'BEDUWAI',
		'ID615200' => 'NOYAN',
		'ID615210' => 'SEKAYAM',
		'ID615220' => 'ENTIKONG',
		'ID61610' => 'KENDAWANGAN',
		'ID61620' => 'MANIS MATA',
		'ID61630' => 'MARAU',
		'ID61631' => 'SINGKUP',
		'ID61632' => 'AIR UPAS',
		'ID61640' => 'JELAI HULU',
		'ID61650' => 'TUMBANG TITI',
		'ID61651' => 'PEMAHAN',
		'ID61652' => 'SUNGAI MELAYU RAYAK',
		'ID61660' => 'MATAN HILIR SELATAN',
		'ID61661' => 'BENUA KAYONG',
		'ID61670' => 'MATAN HILIR UTARA',
		'ID61671' => 'DELTA PAWAN',
		'ID61672' => 'MUARA PAWAN',
		'ID61690' => 'NANGA TAYAP',
		'ID616100' => 'SANDAI',
		'ID616101' => 'HULU SUNGAI',
		'ID616110' => 'SUNGAI LAUR',
		'ID616120' => 'SIMPANG HULU',
		'ID616121' => 'SIMPANG DUA',
		'ID61760' => 'SERAWAI',
		'ID61770' => 'AMBALAU',
		'ID61780' => 'KAYAN HULU',
		'ID617110' => 'SEPAUK',
		'ID617120' => 'TEMPUNAK',
		'ID617130' => 'SUNGAI TEBELIAN',
		'ID617140' => 'SINTANG',
		'ID617150' => 'DEDAI',
		'ID617160' => 'KAYAN HILIR',
		'ID617170' => 'KELAM PERMAI',
		'ID617180' => 'BINJAI HULU',
		'ID617190' => 'KETUNGAU HILIR',
		'ID617200' => 'KETUNGAU TENGAH',
		'ID617210' => 'KETUNGAU HULU',
		'ID61810' => 'SILAT HILIR',
		'ID61820' => 'SILAT HULU',
		'ID61830' => 'HULU GURUNG',
		'ID61840' => 'BUNUT HULU',
		'ID61850' => 'MENTEBAH',
		'ID61860' => 'BIKA',
		'ID61870' => 'KALIS',
		'ID61880' => 'PUTUSSIBAU SELATAN',
		'ID61881' => 'HULU KAPUAS',
		'ID61890' => 'EMBALOH HILIR',
		'ID618100' => 'BUNUT HILIR',
		'ID618110' => 'BOYAN TANJUNG',
		'ID618120' => 'PENGKADAN',
		'ID618130' => 'JONGKONG',
		'ID618140' => 'SELIMBAU',
		'ID618141' => 'DANAU SENTARUM',
		'ID618150' => 'SUHAID',
		'ID618160' => 'SEBERUANG',
		'ID618170' => 'SEMITAU',
		'ID618180' => 'EMPANANG',
		'ID618190' => 'PURING KENCANA',
		'ID618200' => 'BADAU',
		'ID618210' => 'BATANG LUPAR',
		'ID618220' => 'EMBALOH HULU',
		'ID618230' => 'PUTUSSIBAU UTARA',
		'ID61910' => 'NANGA MAHAP',
		'ID61920' => 'NANGA TAMAN',
		'ID61930' => 'SEKADAU HULU',
		'ID61940' => 'SEKADAU HILIR',
		'ID61950' => 'BELITANG HILIR',
		'ID61960' => 'BELITANG',
		'ID61970' => 'BELITANG HULU',
		'ID611010' => 'SOKAN',
		'ID611020' => 'TANAH PINOH',
		'ID611021' => 'TANAH PINOH BARAT',
		'ID611030' => 'SAYAN',
		'ID611040' => 'BELIMBING',
		'ID611041' => 'BELIMBING HULU',
		'ID611050' => 'NANGA PINOH',
		'ID611051' => 'PINOH SELATAN',
		'ID611052' => 'PINOH UTARA',
		'ID611060' => 'ELLA HILIR',
		'ID611070' => 'MENUKUNG',
		'ID611110' => 'PULAU MAYA KARIMATA',
		'ID611120' => 'SUKADANA',
		'ID611130' => 'SIMPANG HILIR',
		'ID611140' => 'TELUK BATANG',
		'ID611150' => 'SEPONTI',
		'ID611210' => 'BATU AMPAR',
		'ID611220' => 'TERENTANG',
		'ID611230' => 'KUBU',
		'ID611240' => 'TELOK PAKEDAI',
		'ID611250' => 'SUNGAI KAKAP',
		'ID611260' => 'RASAU JAYA',
		'ID611270' => 'SUNGAI RAYA',
		'ID611280' => 'SUNGAI AMBAWANG',
		'ID611290' => 'KUALA MANDOR-B',
		'ID617110' => 'PONTIANAK SELATAN',
		'ID617111' => 'PONTIANAK TENGGARA',
		'ID617120' => 'PONTIANAK TIMUR',
		'ID617130' => 'PONTIANAK BARAT',
		'ID617131' => 'PONTIANAK KOTA',
		'ID617140' => 'PONTIANAK UTARA',
		'ID617210' => 'SINGKAWANG SELATAN',
		'ID617220' => 'SINGKAWANG TIMUR',
		'ID617230' => 'SINGKAWANG UTARA',
		'ID617240' => 'SINGKAWANG BARAT',
		'ID617250' => 'SINGKAWANG TENGAH',
	],
	'KT' => [
		'ID62140' => 'KOTAWARINGIN LAMA',
		'ID62150' => 'ARUT SELATAN',
		'ID62160' => 'KUMAI',
		'ID62161' => 'PANGKALAN BANTENG',
		'ID62162' => 'PANGKALAN LADA',
		'ID62170' => 'ARUT UTARA',
		'ID62220' => 'MENTAYA HILIR SELATAN',
		'ID62221' => 'TELUK SAMPIT',
		'ID62250' => 'PULAU HANAUT',
		'ID62260' => 'MENTAWA BARU/KETAPANG',
		'ID62261' => 'SERANAU',
		'ID62270' => 'MENTAYA HILIR UTARA',
		'ID622110' => 'KOTA BESI',
		'ID622111' => 'TELAWANG',
		'ID622120' => 'BAAMANG',
		'ID622190' => 'CEMPAGA',
		'ID622191' => 'CEMPAGA HULU',
		'ID622200' => 'PARENGGEAN',
		'ID622210' => 'MENTAYA HULU',
		'ID622211' => 'BUKIT SANTUAI',
		'ID622230' => 'ANTANG KALANG',
		'ID62320' => 'KAPUAS KUALA',
		'ID62321' => 'TAMBAN CATUR',
		'ID62330' => 'KAPUAS TIMUR',
		'ID62340' => 'SELAT',
		'ID62341' => 'BATAGUH',
		'ID62370' => 'BASARANG',
		'ID62380' => 'KAPUAS HILIR',
		'ID62390' => 'PULAU PETAK',
		'ID623100' => 'KAPUAS MURUNG',
		'ID623101' => 'DADAHUP',
		'ID623110' => 'KAPUAS BARAT',
		'ID623150' => 'MANTANGAI',
		'ID623160' => 'TIMPAH',
		'ID623170' => 'KAPUAS TENGAH',
		'ID623171' => 'PASAK TALAWANG',
		'ID623180' => 'KAPUAS HULU',
		'ID623181' => 'MANDAU TALAWANG',
		'ID62410' => 'JENAMAS',
		'ID62420' => 'DUSUN HILIR',
		'ID62430' => 'KARAU KUALA',
		'ID62440' => 'DUSUN SELATAN',
		'ID62450' => 'DUSUN UTARA',
		'ID62460' => 'GUNUNG BINTANG AWAI',
		'ID62510' => 'MONTALAT',
		'ID62520' => 'GUNUNG TIMANG',
		'ID62530' => 'GUNUNG PUREI',
		'ID62540' => 'TEWEH TIMUR',
		'ID62550' => 'TEWEH TENGAH',
		'ID62560' => 'LAHEI',
		'ID62610' => 'JELAI',
		'ID62611' => 'PANTAI LUNCI',
		'ID62620' => 'SUKAMARA',
		'ID62630' => 'BALAI RIAM',
		'ID62631' => 'PERMATA KECUBUNG',
		'ID62710' => 'BULIK',
		'ID62711' => 'SEMATU JAYA',
		'ID62712' => 'MENTHOBI RAYA',
		'ID62713' => 'BULIK TIMUR',
		'ID62720' => 'LAMANDAU',
		'ID62721' => 'BELANTIKAN RAYA',
		'ID62730' => 'DELANG',
		'ID62731' => 'BATANGKAWA',
		'ID62810' => 'SERUYAN HILIR',
		'ID62820' => 'DANAU SEMBULUH',
		'ID62830' => 'HANAU',
		'ID62840' => 'SERUYAN TENGAH',
		'ID62850' => 'SERUYAN HULU',
		'ID62910' => 'KATINGAN KUALA',
		'ID62920' => 'MENDAWAI',
		'ID62930' => 'KAMIPANG',
		'ID62940' => 'TASIK PAYAWAN',
		'ID62950' => 'KATINGAN HILIR',
		'ID62960' => 'TEWANG SANGALANG GARING',
		'ID62970' => 'PULAU MALAN',
		'ID62980' => 'KATINGAN TENGAH',
		'ID62990' => 'SANAMAN MANTIKEI',
		'ID62991' => 'PETAK MALAI',
		'ID629100' => 'MARIKIT',
		'ID629110' => 'KATINGAN HULU',
		'ID629111' => 'BUKIT RAYA',
		'ID621010' => 'KAHAYAN KUALA',
		'ID621011' => 'SEBANGAU KUALA',
		'ID621020' => 'PANDIH BATU',
		'ID621030' => 'MALIKU',
		'ID621040' => 'KAHAYAN HILIR',
		'ID621041' => 'JABIREN RAYA',
		'ID621050' => 'KAHAYAN TENGAH',
		'ID621060' => 'BANAMATINGANG',
		'ID621110' => 'MANUHING',
		'ID621111' => 'MANUHING RAYA',
		'ID621120' => 'RUNGAN',
		'ID621121' => 'RUNGAN HULU',
		'ID621130' => 'SEPANG',
		'ID621131' => 'MIHING RAYA',
		'ID621140' => 'KURUN',
		'ID621150' => 'TEWAH',
		'ID621160' => 'KAHAYAN HULU UTARA',
		'ID621161' => 'DAMANG BATU',
		'ID621162' => 'MIRI MANASA',
		'ID621210' => 'BENUA LIMA',
		'ID621220' => 'DUSUN TIMUR',
		'ID621230' => 'AWANG',
		'ID621240' => 'PATANGKEP TUTUI',
		'ID621250' => 'DUSUN TENGAH',
		'ID621260' => 'PEMATANG KARAU',
		'ID621270' => 'PAJU EPAT',
		'ID621280' => 'RAREN BATUAH',
		'ID621290' => 'PAKU',
		'ID6212100' => 'KARUSEN JANANG',
		'ID621310' => 'PERMATA INTAN',
		'ID621311' => 'SUNGAI BABUAT',
		'ID621320' => 'MURUNG',
		'ID621330' => 'LAUNG TUHUP',
		'ID621331' => 'BARITO TUHUP RAYA',
		'ID621340' => 'TANAH SIANG',
		'ID621341' => 'TANAH SIANG SELATAN',
		'ID621350' => 'SUMBER BARITO',
		'ID621351' => 'SERIBU RIAM',
		'ID621352' => 'UUT MURUNG',
		'ID627110' => 'PAHANDUT',
		'ID627111' => 'SEBANGAU',
		'ID627112' => 'JEKAN RAYA',
		'ID627120' => 'BUKIT BATU',
		'ID627121' => 'RAKUMPIT',
	],
	'KS' => [
		'ID63110' => 'PANYIPATAN',
		'ID63120' => 'TAKISUNG',
		'ID63130' => 'KURAU',
		'ID63131' => 'BUMI MAKMUR',
		'ID63140' => 'BATI - BATI',
		'ID63150' => 'TAMBANG ULANG',
		'ID63160' => 'PELAIHARI',
		'ID63161' => 'BAJUIN',
		'ID63170' => 'BATU AMPAR',
		'ID63180' => 'JORONG',
		'ID63190' => 'KINTAP',
		'ID63210' => 'PULAU SEMBILAN',
		'ID63220' => 'PULAU LAUT BARAT',
		'ID63230' => 'PULAU LAUT SELATAN',
		'ID63231' => 'PULAU LAUT KEPULAUAN',
		'ID63240' => 'PULAU LAUT TIMUR',
		'ID63250' => 'PULAU SEBUKU',
		'ID63260' => 'PULAU LAUT UTARA',
		'ID63261' => 'PULAU LAUT TENGAH',
		'ID632120' => 'KELUMPANG SELATAN',
		'ID632121' => 'KELUMPANG HILIR',
		'ID632130' => 'KELUMPANG HULU',
		'ID632140' => 'HAMPANG',
		'ID632150' => 'SUNGAI DURIAN',
		'ID632160' => 'KELUMPANG TENGAH',
		'ID632161' => 'KELUMPANG BARAT',
		'ID632170' => 'KELUMPANG UTARA',
		'ID632180' => 'PAMUKAN SELATAN',
		'ID632190' => 'SAMPANAHAN',
		'ID632200' => 'PAMUKAN UTARA',
		'ID632210' => 'PAMUKAN BARAT',
		'ID63310' => 'ALUH - ALUH',
		'ID63311' => 'BERUNTUNG BARU',
		'ID63320' => 'GAMBUT',
		'ID63330' => 'KERTAK HANYAR',
		'ID63331' => 'TATAH MAKMUR',
		'ID63340' => 'SUNGAI TABUK',
		'ID63350' => 'MARTAPURA',
		'ID63351' => 'MARTAPURA TIMUR',
		'ID63352' => 'MARTAPURA BARAT',
		'ID63360' => 'ASTAMBUL',
		'ID63370' => 'KARANG INTAN',
		'ID63380' => 'ARANIO',
		'ID63390' => 'SUNGAI PINANG',
		'ID63391' => 'PARAMASAN',
		'ID633100' => 'PENGARON',
		'ID633101' => 'SAMBUNG MAKMUR',
		'ID633110' => 'MATARAMAN',
		'ID633120' => 'SIMPANG EMPAT',
		'ID633121' => 'TELAGA BAUNTUNG',
		'ID63410' => 'TABUNGANEN',
		'ID63420' => 'TAMBAN',
		'ID63430' => 'MEKAR SARI',
		'ID63440' => 'ANJIR PASAR',
		'ID63450' => 'ANJIR MUARA',
		'ID63460' => 'ALALAK',
		'ID63470' => 'MANDASTANA',
		'ID63471' => 'JEJANGKIT',
		'ID63480' => 'BELAWANG',
		'ID63490' => 'WANARAYA',
		'ID634100' => 'BARAMBAI',
		'ID634110' => 'RANTAU BADAUH',
		'ID634120' => 'CERBON',
		'ID634130' => 'BAKUMPAI',
		'ID634140' => 'MARABAHAN',
		'ID634150' => 'TABUKAN',
		'ID634160' => 'KURIPAN',
		'ID63510' => 'BINUANG',
		'ID63511' => 'HATUNGUN',
		'ID63520' => 'TAPIN SELATAN',
		'ID63521' => 'SALAM BABARIS',
		'ID63530' => 'TAPIN TENGAH',
		'ID63540' => 'BUNGUR',
		'ID63550' => 'PIANI',
		'ID63560' => 'LOKPAIKAT',
		'ID63570' => 'TAPIN UTARA',
		'ID63580' => 'BAKARANGAN',
		'ID63590' => 'CANDI LARAS SELATAN',
		'ID635100' => 'CANDI LARAS UTARA',
		'ID63610' => 'PADANG BATUNG',
		'ID63620' => 'LOKSADO',
		'ID63630' => 'TELAGA LANGSAT',
		'ID63640' => 'ANGKINANG',
		'ID63650' => 'KANDANGAN',
		'ID63660' => 'SUNGAI RAYA',
		'ID63670' => 'SIMPUR',
		'ID63680' => 'KALUMPANG',
		'ID63690' => 'DAHA SELATAN',
		'ID63691' => 'DAHA BARAT',
		'ID636100' => 'DAHA UTARA',
		'ID63710' => 'HARUYAN',
		'ID63720' => 'BATU BENAWA',
		'ID63730' => 'HANTAKAN',
		'ID63740' => 'BATANG ALAI SELATAN',
		'ID63741' => 'BATANG ALAI TIMUR',
		'ID63750' => 'BARABAI',
		'ID63760' => 'LABUAN AMAS SELATAN',
		'ID63770' => 'LABUAN AMAS UTARA',
		'ID63780' => 'PANDAWAN',
		'ID63790' => 'BATANG ALAI UTARA',
		'ID63791' => 'LIMPASU',
		'ID63810' => 'DANAU PANGGANG',
		'ID63811' => 'PAMINGGIR',
		'ID63820' => 'BABIRIK',
		'ID63830' => 'SUNGAI PANDAN',
		'ID63831' => 'SUNGAI TABUKAN',
		'ID63840' => 'AMUNTAI SELATAN',
		'ID63850' => 'AMUNTAI TENGAH',
		'ID63860' => 'BANJANG',
		'ID63870' => 'AMUNTAI UTARA',
		'ID63871' => 'HAUR GADING',
		'ID63910' => 'BANUA LAWAS',
		'ID63920' => 'PUGAAN',
		'ID63930' => 'KELUA',
		'ID63940' => 'MUARA HARUS',
		'ID63950' => 'TANTA',
		'ID63960' => 'TANJUNG',
		'ID63970' => 'MURUNG PUDAK',
		'ID63980' => 'HARUAI',
		'ID63981' => 'BINTANG ARA',
		'ID63990' => 'UPAU',
		'ID639100' => 'MUARA UYA',
		'ID639110' => 'JARO',
		'ID631010' => 'KUSAN HILIR',
		'ID631020' => 'SUNGAI LOBAN',
		'ID631030' => 'SATUI',
		'ID631031' => 'ANGSANA',
		'ID631040' => 'KUSAN HULU',
		'ID631041' => 'KURANJI',
		'ID631050' => 'BATU LICIN',
		'ID631051' => 'KARANG BINTANG',
		'ID631052' => 'SIMPANG EMPAT',
		'ID631053' => 'MANTEWE',
		'ID631110' => 'LAMPIHONG',
		'ID631120' => 'BATU MANDI',
		'ID631130' => 'AWAYAN',
		'ID631131' => 'TEBING TINGGI',
		'ID631140' => 'PARINGIN',
		'ID631141' => 'PARINGIN SELATAN',
		'ID631150' => 'JUAI',
		'ID631160' => 'HALONG',
		'ID637110' => 'BANJARMASIN SELATAN',
		'ID637120' => 'BANJARMASIN TIMUR',
		'ID637130' => 'BANJARMASIN BARAT',
		'ID637131' => 'BANJARMASIN TENGAH',
		'ID637140' => 'BANJARMASIN UTARA',
		'ID637210' => 'LANDASAN ULIN',
		'ID637211' => 'LIANG ANGGANG',
		'ID637220' => 'CEMPAKA',
		'ID637231' => 'BANJAR BARU UTARA',
		'ID637232' => 'BANJAR BARU SELATAN',
	],
	'KI' => [
		'ID64110' => 'BATU SOPANG',
		'ID64111' => 'MUARA SAMU',
		'ID64121' => 'BATU ENGAU',
		'ID64122' => 'TANJUNG HARAPAN',
		'ID64130' => 'PASIR BELENGKONG',
		'ID64140' => 'TANAH GROGOT',
		'ID64150' => 'KUARO',
		'ID64160' => 'LONG IKIS',
		'ID64170' => 'MUARA KOMAM',
		'ID64180' => 'LONG KALI',
		'ID64210' => 'BONGAN',
		'ID64220' => 'JEMPANG',
		'ID64230' => 'PENYINGGAHAN',
		'ID64240' => 'MUARA PAHU',
		'ID64241' => 'SILUQ NGURAI',
		'ID64250' => 'MUARA LAWA',
		'ID64251' => 'BENTIAN BESAR',
		'ID64260' => 'DAMAI',
		'ID64261' => 'NYUATAN',
		'ID64270' => 'BARONG TONGKOK',
		'ID64271' => 'LINGGANG BIGUNG',
		'ID64280' => 'MELAK',
		'ID64281' => 'SEKOLAQ DARAT',
		'ID64282' => 'MANOR BULATN',
		'ID64290' => 'LONG IRAM',
		'ID64291' => 'TERING',
		'ID642100' => 'LONG HUBUNG',
		'ID642101' => 'LAHAM',
		'ID642110' => 'LONG BAGUN',
		'ID642120' => 'LONG PAHANGAI',
		'ID642130' => 'LONG APARI',
		'ID64310' => 'SEMBOJA',
		'ID64320' => 'MUARA JAWA',
		'ID64330' => 'SANGA-SANGA',
		'ID64340' => 'LOA JANAN',
		'ID64350' => 'LOA KULU',
		'ID64360' => 'MUARA MUNTAI',
		'ID64370' => 'MUARA WIS',
		'ID64380' => 'KOTABANGUN',
		'ID64390' => 'TENGGARONG',
		'ID643100' => 'SEBULU',
		'ID643110' => 'TENGGARONG SEBERANG',
		'ID643120' => 'ANGGANA',
		'ID643130' => 'MUARA BADAK',
		'ID643140' => 'MARANG KAYU',
		'ID643150' => 'MUARA KAMAN',
		'ID643160' => 'KENOHAN',
		'ID643170' => 'KEMBANG JANGGUT',
		'ID643180' => 'TABANG',
		'ID64410' => 'MUARA ANCALONG',
		'ID64411' => 'BUSANG',
		'ID64412' => 'LONG MESANGAT',
		'ID64420' => 'MUARA WAHAU',
		'ID64421' => 'TELEN',
		'ID64422' => 'KONGBENG',
		'ID64430' => 'MUARA BENGKAL',
		'ID64431' => 'BATU AMPAR',
		'ID64440' => 'SANGATTA UTARA',
		'ID64441' => 'BENGALON',
		'ID64442' => 'TELUK PANDAN',
		'ID64443' => 'SANGATTA SELATAN',
		'ID64444' => 'RANTAU PULUNG',
		'ID64450' => 'SANGKULIRANG',
		'ID64451' => 'KALIORANG',
		'ID64452' => 'SANDARAN',
		'ID64453' => 'KAUBUN',
		'ID64454' => 'KARANGAN',
		'ID64510' => 'KELAY',
		'ID64520' => 'TALISAYAN',
		'ID64521' => 'TABALAR',
		'ID64530' => 'BIDUK BIDUK',
		'ID64540' => 'PULAU DERAWAN',
		'ID64541' => 'MARATUA',
		'ID64550' => 'SAMBALIUNG',
		'ID64560' => 'TANJUNG REDEB',
		'ID64570' => 'GUNUNG TABUR',
		'ID64580' => 'SEGAH',
		'ID64590' => 'TELUK BAYUR',
		'ID645100' => 'BATU PUTIH',
		'ID645110' => 'BIATAN',
		'ID64610' => 'KAYAN HULU',
		'ID64611' => 'SUNGAI BOH',
		'ID64612' => 'KAYAN SELATAN',
		'ID64620' => 'KAYAN HILIR',
		'ID64630' => 'PUJUNGAN',
		'ID64631' => 'BAHAU HULU',
		'ID64640' => 'MALINAU KOTA',
		'ID64641' => 'MALINAU SELATAN',
		'ID64642' => 'MALINAU BARAT',
		'ID64643' => 'MALINAU UTARA',
		'ID64650' => 'MENTARANG',
		'ID64651' => 'MENTARANG HULU',
		'ID64710' => 'PESO',
		'ID64711' => 'PESO HILIR',
		'ID64720' => 'TANJUNG PALAS',
		'ID64721' => 'TANJUNG PALAS BARAT',
		'ID64722' => 'TANJUNG PALAS UTARA',
		'ID64723' => 'TANJUNG PALAS TIMUR',
		'ID64724' => 'TANJUNG SELOR',
		'ID64725' => 'TANJUNG PALAS TENGAH',
		'ID64730' => 'SEKATAK',
		'ID64750' => 'BUNYU',
		'ID64810' => 'KRAYAN',
		'ID64811' => 'KRAYAN SELATAN',
		'ID64820' => 'LUMBIS',
		'ID64830' => 'SEMBAKUNG',
		'ID64840' => 'NUNUKAN',
		'ID64841' => 'SEBUKU',
		'ID64842' => 'NUNUKAN SELATAN',
		'ID64850' => 'SEBATIK',
		'ID64851' => 'SEBATIK BARAT',
		'ID64910' => 'BABULU',
		'ID64920' => 'WARU',
		'ID64930' => 'PENAJAM',
		'ID64940' => 'SEPAKU',
		'ID641010' => 'SESAYAP',
		'ID641020' => 'SESAYAP HILIR',
		'ID641030' => 'TANA LIA',
		'ID647110' => 'BALIKPAPAN SELATAN',
		'ID647120' => 'BALIKPAPAN TIMUR',
		'ID647130' => 'BALIKPAPAN UTARA',
		'ID647140' => 'BALIKPAPAN TENGAH',
		'ID647150' => 'BALIKPAPAN BARAT',
		'ID647210' => 'PALARAN',
		'ID647220' => 'SAMARINDA ILIR',
		'ID647230' => 'SAMARINDA SEBERANG',
		'ID647240' => 'SUNGAI KUNJANG',
		'ID647250' => 'SAMARINDA ULU',
		'ID647260' => 'SAMARINDA UTARA',
		'ID647310' => 'TARAKAN TIMUR',
		'ID647320' => 'TARAKAN TENGAH',
		'ID647330' => 'TARAKAN BARAT',
		'ID647340' => 'TARAKAN UTARA',
		'ID647410' => 'BONTANG SELATAN',
		'ID647420' => 'BONTANG UTARA',
		'ID647430' => 'BONTANG BARAT',
	],
	'SA' => [
		'ID71121' => 'DUMOGA BARAT',
		'ID71122' => 'DUMOGA UTARA',
		'ID71123' => 'DUMOGA TIMUR',
		'ID71160' => 'LOLAYAN',
		'ID71181' => 'PASSI BARAT',
		'ID71182' => 'PASSI TIMUR',
		'ID71183' => 'BILALANG',
		'ID71190' => 'POIGAR',
		'ID711100' => 'BOLAANG',
		'ID711101' => 'BOLAANG TIMUR',
		'ID711110' => 'LOLAK',
		'ID711120' => 'SANGTOMBOLANG',
		'ID71291' => 'LANGOWAN TIMUR',
		'ID71292' => 'LANGOWAN BARAT',
		'ID71293' => 'LANGOWAN SELATAN',
		'ID71294' => 'LANGOWAN UTARA',
		'ID712110' => 'TOMPASO',
		'ID712120' => 'KAWANGKOAN',
		'ID712130' => 'SONDER',
		'ID712160' => 'TOMBARIRI',
		'ID712170' => 'PINELENG',
		'ID712171' => 'TOMBULU',
		'ID712190' => 'TONDANO BARAT',
		'ID712191' => 'TONDANO SELATAN',
		'ID712200' => 'REMBOKEN',
		'ID712210' => 'KAKAS',
		'ID712220' => 'LEMBEAN TIMUR',
		'ID712230' => 'ERIS',
		'ID712240' => 'KOMBI',
		'ID712250' => 'TONDANO TIMUR',
		'ID712251' => 'TONDANO UTARA',
		'ID71340' => 'MANGANITU SELATAN',
		'ID71341' => 'TATOARENG',
		'ID71350' => 'TAMAKO',
		'ID71360' => 'TABUKAN SELATAN',
		'ID71361' => 'TABUKAN SELATAN TENGAH',
		'ID71362' => 'TABUKAN SELATAN TENGGARA',
		'ID71370' => 'TABUKAN TENGAH',
		'ID71380' => 'MANGANITU',
		'ID71390' => 'TAHUNA',
		'ID71391' => 'TAHUNA TIMUR',
		'ID71392' => 'TAHUNA BARAT',
		'ID713100' => 'TABUKAN UTARA',
		'ID713101' => 'NUSA TABUKAN',
		'ID713102' => 'KEPULAUAN MARORE',
		'ID713110' => 'KENDAHE',
		'ID71410' => 'KABARUAN',
		'ID71411' => 'DAMAU',
		'ID71420' => 'LIRUNG',
		'ID71421' => 'SALIBABU',
		'ID71422' => 'KALONGAN',
		'ID71423' => 'MORONGE',
		'ID71430' => 'MELONGUANE',
		'ID71431' => 'MELONGUANE TIMUR',
		'ID71440' => 'BEO',
		'ID71441' => 'BEO UTARA',
		'ID71442' => 'BEO SELATAN',
		'ID71450' => 'RAINIS',
		'ID71451' => 'TAMPA NAMMA',
		'ID71452' => 'PULUTAN',
		'ID71460' => 'ESSANG',
		'ID71461' => 'ESSANG SELATAN',
		'ID71470' => 'GEMEH',
		'ID71480' => 'NANUSA',
		'ID71481' => 'MIANGAS',
		'ID71510' => 'MODOINDING',
		'ID71520' => 'TOMPASO BARU',
		'ID71521' => 'MAESAAN',
		'ID71570' => 'RANOYAPO',
		'ID71580' => 'MOTOLING',
		'ID71581' => 'KUMELEMBUAI',
		'ID71582' => 'MOTOLING BARAT',
		'ID71583' => 'MOTOLING TIMUR',
		'ID71590' => 'SINONSAYANG',
		'ID715100' => 'TENGA',
		'ID715111' => 'AMURANG',
		'ID715112' => 'AMURANG BARAT',
		'ID715113' => 'AMURANG TIMUR',
		'ID715120' => 'TARERAN',
		'ID715121' => 'SULTA',
		'ID715130' => 'TUMPAAN',
		'ID715131' => 'TATAPAAN',
		'ID71610' => 'KEMA',
		'ID71620' => 'KAUDITAN',
		'ID71630' => 'AIRMADIDI',
		'ID71640' => 'KALAWAT',
		'ID71650' => 'DIMEMBE',
		'ID71651' => 'TALAWAAN',
		'ID71660' => 'WORI',
		'ID71670' => 'LIKUPANG BARAT',
		'ID71680' => 'LIKUPANG TIMUR',
		'ID71681' => 'LIKUPANG SELATAN',
		'ID71710' => 'SANGKUB',
		'ID71720' => 'BINTAUNA',
		'ID71730' => 'BOLANG ITANG TIMUR',
		'ID71740' => 'BOLANG ITANG BARAT',
		'ID71750' => 'KAIDIPANG',
		'ID71760' => 'PINOGALUMAN',
		'ID71810' => 'BIARO',
		'ID71820' => 'TAGULANDANG SELATAN',
		'ID71830' => 'TAGULANDANG',
		'ID71840' => 'TAGULANDANG UTARA',
		'ID71850' => 'SIAU BARAT SELATAN',
		'ID71860' => 'SIAU TIMUR SELATAN',
		'ID71870' => 'SIAU BARAT',
		'ID71880' => 'SIAU TENGAH',
		'ID71890' => 'SIAU TIMUR',
		'ID718100' => 'SIAU BARAT UTARA',
		'ID71910' => 'RATATOTOK',
		'ID71920' => 'PUSOMAEN',
		'ID71930' => 'BELANG',
		'ID71940' => 'RATAHAN',
		'ID71941' => 'PASAN',
		'ID71942' => 'RATAHAN TIMUR',
		'ID71950' => 'TOMBATU',
		'ID71951' => 'TOMBATU TIMUR',
		'ID71952' => 'TOMBATU UTARA',
		'ID71960' => 'TOULUAAN',
		'ID71961' => 'TOULUAAN SELATAN',
		'ID71962' => 'SILIAN RAYA',
		'ID711010' => 'POSIGADAN',
		'ID711020' => 'BOLANG UKI',
		'ID711030' => 'PINOLOSIAN',
		'ID711040' => 'PINOLOSIAN TENGAH',
		'ID711050' => 'PINOLOSIAN TIMUR',
		'ID711110' => 'NUANGAN',
		'ID711120' => 'TUTUYAN',
		'ID711130' => 'KOTABUNAN',
		'ID711140' => 'MODAYAG',
		'ID711150' => 'MODAYAG BARAT',
		'ID717110' => 'MALALAYANG',
		'ID717120' => 'SARIO',
		'ID717121' => 'WANEA',
		'ID717130' => 'WENANG',
		'ID717131' => 'TIKALA',
		'ID717140' => 'MAPANGET',
		'ID717151' => 'SINGKIL',
		'ID717152' => 'TUMINTING',
		'ID717153' => 'BUNAKEN',
		'ID717210' => 'MADIDIR',
		'ID717211' => 'MATUARI',
		'ID717212' => 'GIRIAN',
		'ID717221' => 'LEMBEH SELATAN',
		'ID717222' => 'LEMBEH UTARA',
		'ID717230' => 'AERTEMBAGA',
		'ID717231' => 'MAESA',
		'ID717240' => 'RANOWULU',
		'ID717310' => 'TOMOHON SELATAN',
		'ID717320' => 'TOMOHON TENGAH',
		'ID717321' => 'TOMOHON TIMUR',
		'ID717322' => 'TOMOHON BARAT',
		'ID717330' => 'TOMOHON UTARA',
		'ID717410' => 'KOTAMOBAGU SELATAN',
		'ID717420' => 'KOTAMOBAGU TIMUR',
		'ID717430' => 'KOTAMOBAGU BARAT',
		'ID717440' => 'KOTAMOBAGU UTARA',
	],
	'ST' => [
		'ID72110' => 'LABOBO',
		'ID72111' => 'BOKAN KEPULAUAN',
		'ID72112' => 'BANGKURUNG',
		'ID72120' => 'BANGGAI',
		'ID72121' => 'BANGGAI UTARA',
		'ID72122' => 'BANGGAI TENGAH',
		'ID72123' => 'BANGGAI SELATAN',
		'ID72130' => 'TOTIKUM',
		'ID72131' => 'TOTIKUM SELATAN',
		'ID72140' => 'TINANGKUNG',
		'ID72141' => 'TINANGKUNG SELATAN',
		'ID72142' => 'TINANGKUNG UTARA',
		'ID72150' => 'LIANG',
		'ID72151' => 'PELING TENGAH',
		'ID72160' => 'BULAGI',
		'ID72161' => 'BULAGI SELATAN',
		'ID72162' => 'BULAGI UTARA',
		'ID72170' => 'BUKO',
		'ID72171' => 'BUKO SELATAN',
		'ID72210' => 'TOILI',
		'ID72211' => 'TOILI BARAT',
		'ID72212' => 'MOILONG',
		'ID72220' => 'BATUI',
		'ID72221' => 'BATUI SELATAN',
		'ID72230' => 'BUNTA',
		'ID72231' => 'NUHON',
		'ID72232' => 'SIMPANG RAYA',
		'ID72240' => 'KINTOM',
		'ID72250' => 'LUWUK',
		'ID72251' => 'LUWUK TIMUR',
		'ID72260' => 'PAGIMANA',
		'ID72261' => 'BUALEMO',
		'ID72262' => 'LOBU',
		'ID72270' => 'LAMALA',
		'ID72271' => 'MASAMA',
		'ID72280' => 'BALANTAK',
		'ID72281' => 'BALANTAK SELATAN',
		'ID72310' => 'MENUI KEPULAUAN',
		'ID72320' => 'BUNGKU SELATAN',
		'ID72321' => 'BAHODOPI',
		'ID72330' => 'BUNGKU TENGAH',
		'ID72340' => 'BUNGKU BARAT',
		'ID72341' => 'BUMI RAYA',
		'ID72342' => 'WITA PONDA',
		'ID72350' => 'LEMBO',
		'ID72360' => 'MORI ATAS',
		'ID72361' => 'MORI UTARA',
		'ID72370' => 'PETASIA',
		'ID72371' => 'SOYO JAYA',
		'ID72380' => 'BUNGKU UTARA',
		'ID72381' => 'MAMOSALATO',
		'ID72410' => 'PAMONA SELATAN',
		'ID72411' => 'PAMONA BARAT',
		'ID72412' => 'PAMONA TENGGARA',
		'ID72420' => 'LORE SELATAN',
		'ID72421' => 'LORE BARAT',
		'ID72430' => 'PAMONA UTARA',
		'ID72431' => 'PAMONA TIMUR',
		'ID72440' => 'LORE UTARA',
		'ID72441' => 'LORE TENGAH',
		'ID72442' => 'LORE TIMUR',
		'ID72443' => 'LORE PEORE',
		'ID72450' => 'POSO PESISIR',
		'ID72451' => 'POSO PESISIR SELATAN',
		'ID72452' => 'POSO PESISIR UTARA',
		'ID72460' => 'LAGE',
		'ID72470' => 'POSO KOTA',
		'ID72471' => 'POSO KOTA UTARA',
		'ID72472' => 'POSO KOTA SELATAN',
		'ID72541' => 'RIO PAKAVA',
		'ID72551' => 'PINEMBANI',
		'ID72580' => 'BANAWA',
		'ID72581' => 'BANAWA SELATAN',
		'ID72582' => 'BANAWA TENGAH',
		'ID72590' => 'LABUAN',
		'ID72591' => 'TANANTOVEA',
		'ID725100' => 'SINDUE',
		'ID725101' => 'SINDUE TOMBUSABORA',
		'ID725102' => 'SINDUE TOBATA',
		'ID725120' => 'SIRENJA',
		'ID725130' => 'BALAESANG',
		'ID725131' => 'BALAESANG TANJUNG',
		'ID725140' => 'DAMSOL',
		'ID725160' => 'SOJOL',
		'ID725161' => 'SOJOL UTARA',
		'ID72610' => 'DAMPAL SELATAN',
		'ID72620' => 'DAMPAL UTARA',
		'ID72630' => 'DONDO',
		'ID72631' => 'OGODEIDE',
		'ID72632' => 'BASIDONDO',
		'ID72640' => 'BAOLAN',
		'ID72641' => 'LAMPASIO',
		'ID72650' => 'GALANG',
		'ID72660' => 'TOLITOLI UTARA',
		'ID72661' => 'DAKO PAMEAN',
		'ID72710' => 'LAKEA',
		'ID72711' => 'BIAU',
		'ID72712' => 'KARAMAT',
		'ID72720' => 'MOMUNU',
		'ID72721' => 'TILOAN',
		'ID72730' => 'BOKAT',
		'ID72731' => 'BUKAL',
		'ID72740' => 'BUNOBOGU',
		'ID72741' => 'GADUNG',
		'ID72750' => 'PALELEH',
		'ID72751' => 'PALELEH BARAT',
		'ID72810' => 'SAUSU',
		'ID72811' => 'TORUE',
		'ID72812' => 'BALINGGI',
		'ID72820' => 'PARIGI',
		'ID72821' => 'PARIGI SELATAN',
		'ID72822' => 'PARIGI BARAT',
		'ID72823' => 'PARIGI UTARA',
		'ID72824' => 'PARIGI TENGAH',
		'ID72830' => 'AMPIBABO',
		'ID72831' => 'KASIMBAR',
		'ID72832' => 'TORIBULU',
		'ID72833' => 'SINIU',
		'ID72840' => 'TINOMBO',
		'ID72841' => 'TINOMBO SELATAN',
		'ID72850' => 'TOMINI',
		'ID72851' => 'MEPANGA',
		'ID72852' => 'PALASA',
		'ID72860' => 'MOUTONG',
		'ID72861' => 'BOLANO LAMBUNU',
		'ID72862' => 'TAOPA',
		'ID72910' => 'TOJO BARAT',
		'ID72920' => 'TOJO',
		'ID72930' => 'ULUBONGKA',
		'ID72940' => 'AMPANA TETE',
		'ID72950' => 'AMPANA KOTA',
		'ID72960' => 'UNA - UNA',
		'ID72970' => 'TOGEAN',
		'ID72980' => 'WALEA KEPULAUAN',
		'ID72981' => 'WALEA BESAR',
		'ID721010' => 'PIPIKORO',
		'ID721020' => 'KULAWI SELATAN',
		'ID721030' => 'KULAWI',
		'ID721040' => 'LINDU',
		'ID721050' => 'NOKILALAKI',
		'ID721060' => 'PALOLO',
		'ID721070' => 'GUMBASA',
		'ID721080' => 'DOLO SELATAN',
		'ID721090' => 'DOLO BARAT',
		'ID7210100' => 'TANAMBULAVA',
		'ID7210110' => 'DOLO',
		'ID7210120' => 'SIGI BIROMARU',
		'ID7210130' => 'MARAWOLA',
		'ID7210140' => 'MARAWOLA BARAT',
		'ID7210150' => 'KINOVARO',
		'ID727110' => 'PALU BARAT',
		'ID727120' => 'PALU SELATAN',
		'ID727130' => 'PALU TIMUR',
		'ID727140' => 'PALU UTARA',
	],
	'SN' => [
		'ID73110' => 'PASIMARANNU',
		'ID73111' => 'PASILAMBENA',
		'ID73120' => 'PASIMASSUNGGU',
		'ID73121' => 'TAKABONERATE',
		'ID73122' => 'PASIMASSUNGGU TIMUR',
		'ID73130' => 'BONTOSIKUYU',
		'ID73140' => 'BONTOHARU',
		'ID73141' => 'BENTENG',
		'ID73142' => 'BONTOMANAI',
		'ID73150' => 'BONTOMATENE',
		'ID73151' => 'BUKI',
		'ID73210' => 'GANTARANG',
		'ID73220' => 'UJUNG BULU',
		'ID73221' => 'UJUNG LOE',
		'ID73230' => 'BONTO BAHARI',
		'ID73240' => 'BONTOTIRO',
		'ID73250' => 'HERO LANGE-LANGE',
		'ID73260' => 'KAJANG',
		'ID73270' => 'BULUKUMPA',
		'ID73280' => 'RILAU ALE',
		'ID73290' => 'KINDANG',
		'ID73310' => 'BISSAPPU',
		'ID73311' => 'ULUERE',
		'ID73312' => 'SINOA',
		'ID73320' => 'BANTAENG',
		'ID73321' => 'EREMERASA',
		'ID73330' => 'TOMPOBULU',
		'ID73331' => 'PAJUKUKANG',
		'ID73332' => 'GANTARANGKEKE',
		'ID73410' => 'BANGKALA',
		'ID73411' => 'BANGKALA BARAT',
		'ID73420' => 'TAMALATEA',
		'ID73421' => 'BONTORAMBA',
		'ID73430' => 'BINAMU',
		'ID73431' => 'TURATEA',
		'ID73440' => 'BATANG',
		'ID73441' => 'ARUNGKEKE',
		'ID73442' => 'TAROWANG',
		'ID73450' => 'KELARA',
		'ID73451' => 'RUMBIA',
		'ID73510' => 'MANGARA BOMBANG',
		'ID73520' => 'MAPPAKASUNGGU',
		'ID73521' => 'SANROBONE',
		'ID73530' => 'POLOMBANGKENG SELATAN',
		'ID73531' => 'PATTALLASSANG',
		'ID73540' => 'POLOMBANGKENG UTARA',
		'ID73550' => 'GALESONG SELATAN',
		'ID73551' => 'GALESONG',
		'ID73560' => 'GALESONG UTARA',
		'ID73610' => 'BONTONOMPO',
		'ID73611' => 'BONTONOMPO SELATAN',
		'ID73620' => 'BAJENG',
		'ID73621' => 'BAJENG BARAT',
		'ID73630' => 'PALLANGGA',
		'ID73631' => 'BAROMBONG',
		'ID73640' => 'SOMBA OPU',
		'ID73650' => 'BONTOMARANNU',
		'ID73651' => 'PATTALLASSANG',
		'ID73660' => 'PARANGLOE',
		'ID73661' => 'MANUJU',
		'ID73670' => 'TINGGIMONCONG',
		'ID73671' => 'TOMBOLO PAO',
		'ID73672' => 'PARIGI',
		'ID73680' => 'BUNGAYA',
		'ID73681' => 'BONTOLEMPANGAN',
		'ID73690' => 'TOMPOBULU',
		'ID73691' => 'BIRINGBULU',
		'ID73710' => 'SINJAI BARAT',
		'ID73720' => 'SINJAI BORONG',
		'ID73730' => 'SINJAI SELATAN',
		'ID73740' => 'TELLU LIMPOE',
		'ID73750' => 'SINJAI TIMUR',
		'ID73760' => 'SINJAI TENGAH',
		'ID73770' => 'SINJAI UTARA',
		'ID73780' => 'BULUPODDO',
		'ID73790' => 'PULAU SEMBILAN',
		'ID73810' => 'MANDAI',
		'ID73811' => 'MONCONGLOE',
		'ID73820' => 'MAROS BARU',
		'ID73821' => 'MARUSU',
		'ID73822' => 'TURIKALE',
		'ID73823' => 'LAU',
		'ID73830' => 'BONTOA',
		'ID73840' => 'BANTIMURUNG',
		'ID73841' => 'SIMBANG',
		'ID73850' => 'TANRALILI',
		'ID73851' => 'TOMPU BULU',
		'ID73860' => 'CAMBA',
		'ID73861' => 'CENRANA',
		'ID73870' => 'MALLAWA',
		'ID73910' => 'LIUKANG TANGAYA',
		'ID73920' => 'LIUKANG KALMAS',
		'ID73930' => 'LIUKANG TUPABBIRING',
		'ID73931' => 'LIUKANG TUPABBIRING UTARA',
		'ID73940' => 'PANGKAJENE',
		'ID73941' => 'MINASATENE',
		'ID73950' => 'BALOCCI',
		'ID73951' => 'TONDONG TALLASA',
		'ID73960' => 'BUNGORO',
		'ID73970' => 'LABAKKANG',
		'ID73980' => 'MARANG',
		'ID73991' => 'SEGERI',
		'ID73992' => 'MANDALLE',
		'ID731010' => 'TANETE RIAJA',
		'ID731011' => 'PUJANANTING',
		'ID731020' => 'TANETE RILAU',
		'ID731030' => 'BARRU',
		'ID731040' => 'SOPPENG RIAJA',
		'ID731041' => 'BALUSU',
		'ID731050' => 'MALLUSETASI',
		'ID731110' => 'BONTOCANI',
		'ID731120' => 'KAHU',
		'ID731130' => 'KAJUARA',
		'ID731140' => 'SALOMEKKO',
		'ID731150' => 'TONRA',
		'ID731160' => 'PATIMPENG',
		'ID731170' => 'LIBURENG',
		'ID731180' => 'MARE',
		'ID731190' => 'SIBULUE',
		'ID7311100' => 'CINA',
		'ID7311110' => 'BAREBBO',
		'ID7311120' => 'PONRE',
		'ID7311130' => 'LAPPARIAJA',
		'ID7311140' => 'LAMURU',
		'ID7311141' => 'TELLU LIMPOE',
		'ID7311150' => 'BENGO',
		'ID7311160' => 'ULAWENG',
		'ID7311170' => 'PALAKKA',
		'ID7311180' => 'AWANGPONE',
		'ID7311190' => 'TELLU SIATTINGE',
		'ID7311200' => 'AMALI',
		'ID7311210' => 'AJANGALE',
		'ID7311220' => 'DUA BOCCOE',
		'ID7311230' => 'CENRANA',
		'ID7311710' => 'TANETE RIATTANG BARAT',
		'ID7311720' => 'TANETE RIATTANG',
		'ID7311730' => 'TANETE RIATTANG TIMUR',
		'ID731210' => 'MARIO RIWAWO',
		'ID731220' => 'LALABATA',
		'ID731230' => 'LILI RIAJA',
		'ID731231' => 'GANRA',
		'ID731232' => 'CITTA',
		'ID731240' => 'LILI RILAU',
		'ID731250' => 'DONRI DONRI',
		'ID731260' => 'MARIO RIAWA',
		'ID731310' => 'SABBANG PARU',
		'ID731320' => 'TEMPE',
		'ID731330' => 'PAMMANA',
		'ID731340' => 'BOLA',
		'ID731350' => 'TAKKALALLA',
		'ID731360' => 'SAJOANGING',
		'ID731361' => 'PENRANG',
		'ID731370' => 'MAJAULENG',
		'ID731380' => 'TANA SITOLO',
		'ID731390' => 'BELAWA',
		'ID7313100' => 'MANIANG PAJO',
		'ID7313101' => 'GILIRENG',
		'ID7313110' => 'KEERA',
		'ID7313120' => 'PITUMPANUA',
		'ID731410' => 'PANCA LAUTANG',
		'ID731420' => 'TELLULIMPO E',
		'ID731430' => 'WATANG PULU',
		'ID731440' => 'BARANTI',
		'ID731450' => 'PANCA RIJANG',
		'ID731451' => 'KULO',
		'ID731460' => 'MARITENGNGAE',
		'ID731461' => 'WATANG SIDENRENG',
		'ID731470' => 'PITU RIAWA',
		'ID731480' => 'DUAPITUE',
		'ID731481' => 'PITU RIASE',
		'ID731510' => 'SUPPA',
		'ID731520' => 'MATTIROSOMPE',
		'ID731521' => 'LANRISANG',
		'ID731530' => 'MATTIRO BULU',
		'ID731540' => 'WATANG SAWITTO',
		'ID731541' => 'PALETEANG',
		'ID731542' => 'TIROANG',
		'ID731550' => 'PATAMPANUA',
		'ID731560' => 'CEMPA',
		'ID731570' => 'DUAMPANUA',
		'ID731571' => 'BATULAPPA',
		'ID731580' => 'LEMBANG',
		'ID731610' => 'MAIWA',
		'ID731611' => 'BUNGIN',
		'ID731620' => 'ENREKANG',
		'ID731621' => 'CENDANA',
		'ID731630' => 'BARAKA',
		'ID731631' => 'BUNTU BATU',
		'ID731640' => 'ANGGERAJA',
		'ID731641' => 'MALUA',
		'ID731650' => 'ALLA',
		'ID731651' => 'CURIO',
		'ID731652' => 'MASALLE',
		'ID731653' => 'BAROKO',
		'ID731710' => 'LAROMPONG',
		'ID731711' => 'LAROMPONG SELATAN',
		'ID731720' => 'SULI',
		'ID731721' => 'SULI BARAT',
		'ID731730' => 'BELOPA',
		'ID731731' => 'KAMANRE',
		'ID731732' => 'BELOPA UTARA',
		'ID731740' => 'BAJO',
		'ID731741' => 'BAJO BARAT',
		'ID731750' => 'BASSESANGTEMPE',
		'ID731751' => 'LATIMOJONG',
		'ID731760' => 'BUPON',
		'ID731761' => 'PONRANG',
		'ID731762' => 'PONRANG SELATAN',
		'ID731770' => 'BUA',
		'ID731780' => 'WALENRANG',
		'ID731781' => 'WALENRANG TIMUR',
		'ID731790' => 'LAMASI',
		'ID731791' => 'WALENRANG UTARA',
		'ID731792' => 'WALENRANG BARAT',
		'ID731793' => 'LAMASI TIMUR',
		'ID731810' => 'BONGGAKARADENG',
		'ID731811' => 'SIMBUANG',
		'ID731812' => 'RANO',
		'ID731813' => 'MAPPAK',
		'ID731820' => 'MENGKENDEK',
		'ID731821' => 'GANDANG BATU SILANAN',
		'ID731830' => 'SANGALLA',
		'ID731831' => 'SANGALA SELATAN',
		'ID731832' => 'SANGALLA UTARA',
		'ID731840' => 'MAKALE',
		'ID731841' => 'MAKALE SELATAN',
		'ID731842' => 'MAKALE UTARA',
		'ID731850' => 'SALUPUTTI',
		'ID731851' => 'BITTUANG',
		'ID731852' => 'REMBON',
		'ID731853' => 'MASANDA',
		'ID731854' => 'MALIMBONG BALEPE',
		'ID731861' => 'RANTETAYO',
		'ID731867' => 'KURRA',
		'ID732210' => 'SABBANG',
		'ID732220' => 'BAEBUNTA',
		'ID732230' => 'MALANGKE',
		'ID732231' => 'MALANGKE BARAT',
		'ID732240' => 'SUKAMAJU',
		'ID732250' => 'BONE-BONE',
		'ID7322120' => 'MASAMBA',
		'ID7322121' => 'MAPPEDECENG',
		'ID7322122' => 'RAMPI',
		'ID7322130' => 'LIMBONG',
		'ID7322131' => 'SEKO',
		'ID732510' => 'BURAU',
		'ID732520' => 'WOTU',
		'ID732530' => 'TOMONI',
		'ID732531' => 'TOMONI TIMUR',
		'ID732540' => 'ANGKONA',
		'ID732550' => 'MALILI',
		'ID732560' => 'TOWUTI',
		'ID732570' => 'NUHA',
		'ID732571' => 'WASUPONDA',
		'ID732580' => 'MANGKUTANA',
		'ID732581' => 'KALAENA',
		'ID732610' => 'SOPAI',
		'ID732620' => 'KESU',
		'ID732630' => 'SANGGALANGI',
		'ID732640' => 'BUNTAO',
		'ID732650' => 'RANTEBUA',
		'ID732660' => 'NANGGALA',
		'ID732670' => 'TONDON',
		'ID732680' => 'TALLUNGLIPU',
		'ID732690' => 'RANTEPAO',
		'ID7326100' => 'TIKALA',
		'ID7326110' => 'SESEAN',
		'ID7326120' => 'BALUSU',
		'ID7326130' => 'SADAN',
		'ID7326140' => 'BENGKELEKILA',
		'ID7326150' => 'SESEAN SULOARA',
		'ID7326160' => 'KAPALA PITU',
		'ID7326170' => 'DENDE PIONGAN NAPO',
		'ID7326180' => 'AWAN RANTE KARUA',
		'ID7326190' => 'RINDINGALO',
		'ID7326200' => 'BUNTU PEPASAN',
		'ID7326210' => 'BARUPPU',
		'ID737110' => 'MARISO',
		'ID737120' => 'MAMAJANG',
		'ID737130' => 'TAMALATE',
		'ID737131' => 'RAPPOCINI',
		'ID737140' => 'MAKASSAR',
		'ID737150' => 'UJUNG PANDANG',
		'ID737160' => 'WAJO',
		'ID737170' => 'BONTOALA',
		'ID737180' => 'UJUNG TANAH',
		'ID737190' => 'TALLO',
		'ID7371100' => 'PANAKKUKANG',
		'ID7371101' => 'MANGGALA',
		'ID7371110' => 'BIRING KANAYA',
		'ID7371111' => 'TAMALANREA',
		'ID737210' => 'BACUKIKI',
		'ID737211' => 'BACUKIKI BARAT',
		'ID737220' => 'UJUNG',
		'ID737230' => 'SOREANG',
		'ID737310' => 'WARA SELATAN',
		'ID737311' => 'SENDANA',
		'ID737320' => 'WARA',
		'ID737321' => 'WARA TIMUR',
		'ID737322' => 'MUNGKAJANG',
		'ID737330' => 'WARA UTARA',
		'ID737331' => 'BARA',
		'ID737340' => 'TELLUWANUA',
		'ID737341' => 'WARA BARAT',
	],
	'SG' => [
		'ID74150' => 'LASALIMU',
		'ID74151' => 'LASALIMU SELATAN',
		'ID74152' => 'SIONTAPINA',
		'ID74160' => 'PASAR WAJO',
		'ID74161' => 'WOLOWA',
		'ID74162' => 'WABULA',
		'ID74170' => 'SAMPOLAWA',
		'ID74171' => 'BATU ATAS',
		'ID74172' => 'LAPANDEWA',
		'ID74180' => 'BATAUGA',
		'ID74181' => 'SIOMPU',
		'ID74182' => 'KADATUA',
		'ID74183' => 'SIOMPU BARAT',
		'ID741110' => 'KAPONTORI',
		'ID741120' => 'GU',
		'ID741121' => 'SANGIA WAMBULU',
		'ID741130' => 'LAKUDO',
		'ID741140' => 'MAWASANGKA',
		'ID741141' => 'MAWASANGKA TIMUR',
		'ID741142' => 'MAWASANGKA TENGAH',
		'ID741151' => 'TALAGA RAYA',
		'ID74210' => 'TONGKUNO',
		'ID74211' => 'TONGKUNO SELATAN',
		'ID74220' => 'PARIGI',
		'ID74221' => 'BONE',
		'ID74222' => 'MAROBO',
		'ID74230' => 'KABAWO',
		'ID74231' => 'KABANGKA',
		'ID74232' => 'KONTUKOWUNA',
		'ID74240' => 'TIWORO KEPULAUAN',
		'ID74241' => 'MAGINTI',
		'ID74242' => 'TIWORO TENGAH',
		'ID74243' => 'TIWORO SELATAN',
		'ID74244' => 'TIWORO UTARA',
		'ID74250' => 'LAWA',
		'ID74251' => 'SAWERIGADI',
		'ID74252' => 'BARANGKA',
		'ID74253' => 'WA DAGA',
		'ID74260' => 'KUSAMBI',
		'ID74261' => 'KONTUNAGA',
		'ID74262' => 'WATOPUTE',
		'ID74270' => 'KATOBU',
		'ID74271' => 'LOHIA',
		'ID74272' => 'DURUKA',
		'ID74273' => 'BATALAIWORU',
		'ID74280' => 'NAPABALANO',
		'ID74281' => 'LASALEPA',
		'ID74282' => 'NAPANO KUSAMBI',
		'ID74283' => 'TOWEA',
		'ID74290' => 'WAKORUMBA SELATAN',
		'ID74291' => 'PASIR PUTIH',
		'ID74292' => 'PASI KOLAGA',
		'ID742111' => 'MALIGANO',
		'ID742112' => 'BATUKARA',
		'ID74371' => 'WAWONII SELATAN',
		'ID74372' => 'WAWONII BARAT',
		'ID74373' => 'WAWONII TENGAH',
		'ID74374' => 'WAWONII TENGGARA',
		'ID74381' => 'WAWONII TIMUR',
		'ID74382' => 'WAWONII UTARA',
		'ID74383' => 'WAWONII TIMUR LAUT',
		'ID74390' => 'SOROPIA',
		'ID74391' => 'LALONGGASUMEETO',
		'ID743100' => 'SAMPARA',
		'ID743101' => 'BONDOALA',
		'ID743102' => 'BESULUTU',
		'ID743103' => 'KAPOIALA',
		'ID743130' => 'LAMBUYA',
		'ID743131' => 'UEPAI',
		'ID743132' => 'PURIALA',
		'ID743133' => 'ONEMBUTE',
		'ID743140' => 'PONDIDAHA',
		'ID743141' => 'WONGGEDUKU',
		'ID743142' => 'AMONGGEDO',
		'ID743150' => 'WAWOTOBI',
		'ID743151' => 'MELUHU',
		'ID743152' => 'KONAWE',
		'ID743170' => 'UNAAHA',
		'ID743171' => 'ANGGABERI',
		'ID743180' => 'ABUKI',
		'ID743181' => 'LATOMA',
		'ID743182' => 'TONGAUNA',
		'ID743183' => 'ASINUA',
		'ID743193' => 'ROUTA',
		'ID74410' => 'WATUBANGGA',
		'ID74411' => 'TANGGETADA',
		'ID74412' => 'TOARI',
		'ID74413' => 'POLINGGONA',
		'ID74420' => 'POMALAA',
		'ID74430' => 'WUNDULAKO',
		'ID74431' => 'BAULA',
		'ID74440' => 'LADONGI',
		'ID74441' => 'LAMBADIA',
		'ID74442' => 'POLI-POLIA',
		'ID74450' => 'TIRAWUTA',
		'ID74451' => 'LALOLAE',
		'ID74452' => 'LOEA',
		'ID74460' => 'KOLAKA',
		'ID74461' => 'LATAMBAGA',
		'ID74470' => 'WOLO',
		'ID74471' => 'SAMATURU',
		'ID74480' => 'MOWEWE',
		'ID74481' => 'ULUIWOI',
		'ID74482' => 'TINONDO',
		'ID74510' => 'TINANGGEA',
		'ID74511' => 'LALEMBUU',
		'ID74520' => 'ANDOOLO',
		'ID74521' => 'BUKE',
		'ID74530' => 'PALANGGA',
		'ID74531' => 'PALANGGA SELATAN',
		'ID74532' => 'BAITO',
		'ID74540' => 'LAINEA',
		'ID74541' => 'LAEYA',
		'ID74550' => 'KOLONO',
		'ID74560' => 'LAONTI',
		'ID74570' => 'MORAMO',
		'ID74571' => 'MORAMO UTARA',
		'ID74580' => 'KONDA',
		'ID74581' => 'WOLASI',
		'ID74590' => 'RANOMEETO',
		'ID74591' => 'RANOMEETO BARAT',
		'ID745100' => 'LANDONO',
		'ID745101' => 'MOWILA',
		'ID745110' => 'ANGATA',
		'ID745111' => 'BENUA',
		'ID745112' => 'BASALA',
		'ID74610' => 'KABAENA',
		'ID74611' => 'KABAENA UTARA',
		'ID74612' => 'KABAENA SELATAN',
		'ID74613' => 'KABAENA BARAT',
		'ID74620' => 'KABAENA TIMUR',
		'ID74621' => 'KABAENA TENGAH',
		'ID74630' => 'RUMBIA',
		'ID74631' => 'MATA OLEO',
		'ID74632' => 'KEP. MASALOKA RAYA',
		'ID74633' => 'RUMBIA TENGAH',
		'ID74640' => 'RAROWATU',
		'ID74641' => 'RAROWATU UTARA',
		'ID74642' => 'MATA USU',
		'ID74643' => 'LANTARI JAYA',
		'ID74650' => 'POLEANG TIMUR',
		'ID74651' => 'POLEANG UTARA',
		'ID74652' => 'POLEANG SELATAN',
		'ID74653' => 'POLEANG TENGGARA',
		'ID74660' => 'POLEANG',
		'ID74661' => 'POLEANG BARAT',
		'ID74662' => 'TONTONUNU',
		'ID74663' => 'POLEANG TENGAH',
		'ID74710' => 'BINONGKO',
		'ID74711' => 'TOGO BINONGKO',
		'ID74720' => 'TOMIA',
		'ID74721' => 'TOMIA TIMUR',
		'ID74730' => 'KALEDUPA',
		'ID74731' => 'KALEDUPA SELATAN',
		'ID74740' => 'WANGI-WANGI',
		'ID74750' => 'WANGI-WANGI SELATAN',
		'ID74810' => 'RANTEANGIN',
		'ID74811' => 'LAMBAI',
		'ID74812' => 'WAWO',
		'ID74820' => 'LASUSUA',
		'ID74821' => 'KATOI',
		'ID74830' => 'KODEOHA',
		'ID74831' => 'TIWU',
		'ID74840' => 'NGAPA',
		'ID74841' => 'WATUNOHU',
		'ID74850' => 'PAKUE',
		'ID74851' => 'PAKUE UTARA',
		'ID74852' => 'PAKUE TENGAH',
		'ID74860' => 'BATU PUTIH',
		'ID74861' => 'POREHU',
		'ID74862' => 'TOLALA',
		'ID749100' => 'BONEGUNU',
		'ID749101' => 'KAMBOWA',
		'ID749110' => 'WAKORUMBA',
		'ID749120' => 'KULISUSU',
		'ID749121' => 'KULISUSU BARAT',
		'ID749122' => 'KULISUSU UTARA',
		'ID741010' => 'SAWA',
		'ID741020' => 'LEMBO',
		'ID741030' => 'LASOLO',
		'ID741040' => 'MOLAWE',
		'ID741050' => 'ASERA',
		'ID741060' => 'LANGGIKIMA',
		'ID741070' => 'WIWIRANO',
		'ID747110' => 'MANDONGA',
		'ID747111' => 'BARUGA',
		'ID747112' => 'PUUWATU',
		'ID747113' => 'KADIA',
		'ID747114' => 'WUA-WUA',
		'ID747120' => 'POASIA',
		'ID747121' => 'ABELI',
		'ID747122' => 'KAMBU',
		'ID747130' => 'KENDARI',
		'ID747131' => 'KENDARI BARAT',
		'ID747210' => 'BETOAMBARI',
		'ID747211' => 'MURHUM',
		'ID747220' => 'WOLIO',
		'ID747221' => 'KOKALUKUNA',
		'ID747230' => 'SORAWOLIO',
		'ID747240' => 'BUNGI',
		'ID747241' => 'LEA-LEA',
	],
	'GO' => [
		'ID75131' => 'MANANGGU',
		'ID75140' => 'TILAMUTA',
		'ID75141' => 'DULUPI',
		'ID75142' => 'BOTUMOITO',
		'ID75150' => 'PAGUYAMAN',
		'ID75151' => 'WONOSARI',
		'ID75152' => 'PAGUYAMAN PANTAI',
		'ID75210' => 'BATUDAA PANTAI',
		'ID75211' => 'BILUHU',
		'ID75220' => 'BATUDAA',
		'ID75221' => 'BONGOMEME',
		'ID75222' => 'TABONGO',
		'ID75230' => 'TIBAWA',
		'ID75231' => 'PULUBALA',
		'ID75240' => 'BOLIYOHUTO',
		'ID75241' => 'MOOTILANGO',
		'ID75242' => 'TOLANGOHULA',
		'ID75243' => 'ASPARAGA',
		'ID75270' => 'LIMBOTO',
		'ID75271' => 'LIMBOTO BARAT',
		'ID75280' => 'TELAGA',
		'ID75281' => 'TELAGA BIRU',
		'ID75282' => 'TILANGO',
		'ID75283' => 'TELAGA JAYA',
		'ID75310' => 'POPAYATO',
		'ID75311' => 'POPAYATO BARAT',
		'ID75312' => 'POPAYATO TIMUR',
		'ID75320' => 'LEMITO',
		'ID75321' => 'WANGGARASI',
		'ID75330' => 'MARISA',
		'ID75331' => 'PATILANGGIO',
		'ID75332' => 'BUNTULIA',
		'ID75333' => 'DUHIADAA',
		'ID75340' => 'RANDANGAN',
		'ID75341' => 'TALUDITI',
		'ID75350' => 'PAGUAT',
		'ID75351' => 'DENGILO',
		'ID75410' => 'TAPA',
		'ID75411' => 'BULANGO UTARA',
		'ID75412' => 'BULANGO SELATAN',
		'ID75413' => 'BULANGO TIMUR',
		'ID75414' => 'BULANGO ULU',
		'ID75420' => 'KABILA',
		'ID75421' => 'BOTU PINGGE',
		'ID75422' => 'TILONGKABILA',
		'ID75430' => 'SUWAWA',
		'ID75431' => 'SUWAWA SELATAN',
		'ID75432' => 'SUWAWA TIMUR',
		'ID75433' => 'SUWAWA TENGAH',
		'ID75440' => 'BONEPANTAI',
		'ID75441' => 'KABILA BONE',
		'ID75442' => 'BONE RAYA',
		'ID75443' => 'BONE',
		'ID75444' => 'BULAWA',
		'ID75510' => 'ATINGGOLA',
		'ID75511' => 'GENTUMA RAYA',
		'ID75520' => 'KWANDANG',
		'ID75530' => 'ANGGREK',
		'ID75540' => 'SUMALATA',
		'ID75550' => 'TOLINGGULA',
		'ID757110' => 'KOTA BARAT',
		'ID757111' => 'DUNGINGI',
		'ID757120' => 'KOTA SELATAN',
		'ID757121' => 'KOTA TIMUR',
		'ID757130' => 'KOTA UTARA',
		'ID757131' => 'KOTA TENGAH',
	],
	'SR' => [
		'ID76110' => 'BANGGAE',
		'ID76111' => 'BANGGAE TIMUR',
		'ID76120' => 'PAMBOANG',
		'ID76130' => 'SENDANA',
		'ID76131' => 'TAMMERODO',
		'ID76133' => 'TUBO SENDANA',
		'ID76140' => 'MALUNDA',
		'ID76141' => 'ULUMANDA',
		'ID76210' => 'TINAMBUNG',
		'ID76211' => 'BALANIPA',
		'ID76212' => 'LIMBORO',
		'ID76220' => 'TUBBI TARAMANU',
		'ID76221' => 'ALU',
		'ID76230' => 'CAMPALAGIAN',
		'ID76231' => 'LUYO',
		'ID76240' => 'WONOMULYO',
		'ID76241' => 'MAPILLI',
		'ID76242' => 'TAPANGO',
		'ID76243' => 'MATAKALI',
		'ID76244' => 'B U L O',
		'ID76250' => 'POLEWALI',
		'ID76251' => 'BINUANG',
		'ID76252' => 'ANREAPI',
		'ID76261' => 'MATANGNGA',
		'ID76310' => 'SUMARORONG',
		'ID76320' => 'MESSAWA',
		'ID76330' => 'PANA',
		'ID76331' => 'NOSU',
		'ID76340' => 'TABANG',
		'ID76350' => 'MAMASA',
		'ID76360' => 'TANDUK KALUA',
		'ID76361' => 'BALLA',
		'ID76370' => 'SESENAPADANG',
		'ID76371' => 'TAWALIAN',
		'ID76380' => 'MAMBI',
		'ID76381' => 'BAMBANG',
		'ID76382' => 'RANTEBULAHAN TIMUR',
		'ID76383' => 'MEHALAAN',
		'ID76390' => 'ARALLE',
		'ID76391' => 'BUNTU MALANGKA',
		'ID763100' => 'TABULAHAN',
		'ID76410' => 'TAPALANG',
		'ID76411' => 'TAPALANG BARAT',
		'ID76420' => 'MAMUJU',
		'ID76422' => 'SIMBORO',
		'ID76423' => 'BALABALAKANG',
		'ID76430' => 'KALUKKU',
		'ID76431' => 'PAPALANG',
		'ID76432' => 'SAMPAGA',
		'ID76433' => 'TOMMO',
		'ID76440' => 'KALUMPANG',
		'ID76441' => 'BONEHAU',
		'ID76450' => 'BUDONG-BUDONG',
		'ID76451' => 'PANGALE',
		'ID76452' => 'TOPOYO',
		'ID76453' => 'KAROSSA',
		'ID76454' => 'TOBADAK',
		'ID76510' => 'SARUDU',
		'ID76511' => 'DAPURANG',
		'ID76512' => 'DURIPOKU',
		'ID76520' => 'BARAS',
		'ID76521' => 'BULU TABA',
		'ID76522' => 'LARIANG',
		'ID76530' => 'PASANGKAYU',
		'ID76531' => 'TIKKE RAYA',
		'ID76532' => 'PEDONGGA',
		'ID76540' => 'BAMBALAMOTU',
		'ID76541' => 'BAMBAIRA',
		'ID76542' => 'SARJO',
	],
	'MA' => [
		'ID81140' => 'TANIMBAR SELATAN',
		'ID81141' => 'WER TAMRIAN',
		'ID81142' => 'WER MAKTIAN',
		'ID81143' => 'SELARU',
		'ID81150' => 'TANIMBAR UTARA',
		'ID81151' => 'YARU',
		'ID81152' => 'WUAR LABOBAR',
		'ID81153' => 'NIRUNMAS',
		'ID81154' => 'KORMOMOLIN',
		'ID81210' => 'KEI KECIL',
		'ID81212' => 'KEI KECIL BARAT',
		'ID81213' => 'KEI KECIL TIMUR',
		'ID81220' => 'KEI BESAR',
		'ID81221' => 'KEI BESAR UTARA TIMUR',
		'ID81222' => 'KEI BESAR SELATAN',
		'ID81310' => 'BANDA',
		'ID81340' => 'TEHORU',
		'ID81350' => 'AMAHAI',
		'ID81351' => 'KOTA MASOHI',
		'ID81352' => 'TELUK ELPAPUTIH',
		'ID81360' => 'TEON NILA SERUA',
		'ID81380' => 'SAPARUA',
		'ID81381' => 'NUSALAUT',
		'ID81390' => 'P. HARUKU',
		'ID813100' => 'SALAHUTU',
		'ID813110' => 'LEIHITU',
		'ID813111' => 'LEIHITU BARAT',
		'ID813140' => 'SERAM UTARA',
		'ID813141' => 'SERAM UTARA BARAT',
		'ID81420' => 'NAMLEA',
		'ID81421' => 'WAEAPO',
		'ID81422' => 'WAPLAU',
		'ID81423' => 'BATA BUAL',
		'ID81430' => 'AIR BUAYA',
		'ID81510' => 'ARU SELATAN',
		'ID81511' => 'ARU SELATAN TIMUR',
		'ID81520' => 'ARU TENGAH',
		'ID81521' => 'ARU TENGAH TIMUR',
		'ID81522' => 'ARU TENGAH SELATAN',
		'ID81530' => 'PULAU-PULAU ARU',
		'ID81531' => 'ARU UTARA',
		'ID81610' => 'HUAMUAL BELAKANG',
		'ID81620' => 'SERAM BARAT',
		'ID81630' => 'KAIRATU',
		'ID81640' => 'TANIWEL',
		'ID81710' => 'PULAU GOROM',
		'ID81711' => 'WAKATE',
		'ID81720' => 'SERAM TIMUR',
		'ID81721' => 'TUTUK TOLU',
		'ID81730' => 'WERINAMA',
		'ID81740' => 'BULA',
		'ID81810' => 'PP. WETAR',
		'ID81820' => 'PP. TERSELATAN',
		'ID81830' => 'LETI MOA LAKOR',
		'ID81840' => 'MOA LAKOR',
		'ID81850' => 'DAMER',
		'ID81860' => 'MDONA HIERA',
		'ID81870' => 'PP. BABAR',
		'ID81880' => 'BABAR TIMUR',
		'ID81910' => 'KEPALA MADAN',
		'ID81920' => 'LEKSULA',
		'ID81930' => 'NAMROLE',
		'ID81940' => 'WAISAMA',
		'ID81950' => 'AMBALAU',
		'ID817110' => 'NUSANIWE',
		'ID817120' => 'SIRIMAU',
		'ID817130' => 'TELUK AMBON',
		'ID817140' => 'BAGUALA',
		'ID817150' => 'LEITIMUR SELATAN',
		'ID817210' => 'PP. KUR',
		'ID817220' => 'TAYANDO TAM',
		'ID817230' => 'PULAU DULLAH UTARA',
		'ID817240' => 'PULAU DULLAH SELATAN',
	],
	'MU' => [
		'ID82190' => 'JAILOLO',
		'ID82191' => 'JAILOLO SELATAN',
		'ID82192' => 'LAINNYA',
		'ID821100' => 'SAHU',
		'ID821101' => 'SAHU TIMUR',
		'ID821130' => 'IBU',
		'ID821131' => 'IBU SELATAN',
		'ID821132' => 'IBU UTARA',
		'ID821140' => 'LOLODA',
		'ID82230' => 'WEDA',
		'ID82231' => 'WEDA SELATAN',
		'ID82232' => 'WEDA UTARA',
		'ID82233' => 'WEDA TENGAH',
		'ID82241' => 'PULAU GEBE',
		'ID82242' => 'PATANI',
		'ID82243' => 'PATANI UTARA',
		'ID82244' => 'PATANI BARAT',
		'ID82310' => 'SULA BESI BARAT',
		'ID82311' => 'SULABESI SELATAN',
		'ID82320' => 'SANANA',
		'ID82321' => 'SULA BESI TENGAH',
		'ID82322' => 'SULABESI TIMUR',
		'ID82323' => 'SANANA UTARA',
		'ID82330' => 'MANGOLI TIMUR',
		'ID82331' => 'MANGOLI TENGAH',
		'ID82332' => 'MANGOLI UTARA TIMUR',
		'ID82340' => 'MANGOLI BARAT',
		'ID82341' => 'MANGOLI UTARA',
		'ID82342' => 'MANGOLI SELATAN',
		'ID82350' => 'TALIABU TIMUR',
		'ID82351' => 'TALIABU TIMUR SELATAN',
		'ID82360' => 'TALIABU BARAT',
		'ID82361' => 'TALIABU UTARA',
		'ID82362' => 'TALIABU BARAT LAUT',
		'ID82363' => 'LEDE',
		'ID82364' => 'TALIABU SELATAN',
		'ID82410' => 'OBI SELATAN',
		'ID82420' => 'OBI',
		'ID82421' => 'OBI BARAT',
		'ID82422' => 'OBI TIMUR',
		'ID82423' => 'OBI UTARA',
		'ID82430' => 'BACAN',
		'ID82431' => 'MANDIOLI SELATAN',
		'ID82432' => 'MANDIOLI UTARA',
		'ID82433' => 'BACAN SELATAN',
		'ID82434' => 'BATANG LOMANG',
		'ID82440' => 'BACAN TIMUR',
		'ID82441' => 'BACAN TIMUR SELATAN',
		'ID82442' => 'BACAN TIMUR TENGAH',
		'ID82450' => 'BACAN BARAT',
		'ID82451' => 'KASIRUTA BARAT',
		'ID82452' => 'KASIRUTA TIMUR',
		'ID82453' => 'BACAN BARAT UTARA',
		'ID82460' => 'KAYOA',
		'ID82461' => 'KAYOA BARAT',
		'ID82462' => 'KAYOA SELATAN',
		'ID82463' => 'KAYOA UTARA',
		'ID82470' => 'PULAU MAKIAN',
		'ID82471' => 'MAKIAN BARAT',
		'ID82480' => 'GANE BARAT',
		'ID82481' => 'GANE BARAT SELATAN',
		'ID82482' => 'GANE BARAT UTARA',
		'ID82483' => 'KEPULAUAN JORONGA',
		'ID82490' => 'GANE TIMUR',
		'ID82491' => 'GANE TIMUR TENGAH',
		'ID82492' => 'GANE TIMUR SELATAN',
		'ID82510' => 'MALIFUT',
		'ID82511' => 'KAO TELUK',
		'ID82520' => 'KAO',
		'ID82521' => 'KAO BARAT',
		'ID82522' => 'KAO UTARA',
		'ID82530' => 'TOBELO SELATAN',
		'ID82531' => 'TOBELO BARAT',
		'ID82532' => 'TOBELO TIMUR',
		'ID82540' => 'TOBELO',
		'ID82541' => 'TOBELO TENGAH',
		'ID82542' => 'TOBELO UTARA',
		'ID82550' => 'GALELA',
		'ID82551' => 'GALELA SELATAN',
		'ID82552' => 'GALELA BARAT',
		'ID82553' => 'GALELA UTARA',
		'ID82560' => 'LOLODA UTARA',
		'ID82561' => 'LOLODA KEPULAUAN',
		'ID82610' => 'MABA SELATAN',
		'ID82611' => 'KOTA MABA',
		'ID82620' => 'WASILE SELATAN',
		'ID82630' => 'WASILE',
		'ID82631' => 'WASILE TIMUR',
		'ID82632' => 'WASILE TENGAH',
		'ID82633' => 'WASILE UTARA',
		'ID82640' => 'MABA',
		'ID82641' => 'MABA TENGAH',
		'ID82642' => 'MABA UTARA',
		'ID82710' => 'MOROTAI SELATAN',
		'ID82720' => 'MOROTAI TIMUR',
		'ID82730' => 'MOROTAI SELATAN BARAT',
		'ID82740' => 'MOROTAI JAYA',
		'ID82750' => 'MOROTAI UTARA',
		'ID827110' => 'PULAU TERNATE',
		'ID827111' => 'MOTI',
		'ID827112' => 'PULAU BATANG DUA',
		'ID827113' => 'PULAU HIRI',
		'ID827120' => 'TERNATE SELATAN',
		'ID827121' => 'TERNATE TENGAH',
		'ID827130' => 'TERNATE UTARA',
		'ID827210' => 'TIDORE SELATAN',
		'ID827220' => 'TIDORE UTARA',
		'ID827230' => 'TIDORE',
		'ID827231' => 'TIDORE TIMUR',
		'ID827240' => 'OBA',
		'ID827241' => 'OBA SELATAN',
		'ID827250' => 'OBA UTARA',
		'ID827251' => 'OBA TENGAH',
	],
	'PB' => [
		'ID91150' => 'FAKFAK TIMUR',
		'ID91151' => 'KARAS',
		'ID91160' => 'FAKFAK',
		'ID91161' => 'FAKFAK TENGAH',
		'ID91170' => 'FAKFAK BARAT',
		'ID91180' => 'KOKAS',
		'ID91181' => 'TELUK PATIPI',
		'ID91182' => 'KRAMONGMONGGA',
		'ID91183' => 'BOMBERAY',
		'ID91210' => 'BURUWAY',
		'ID91220' => 'TELUK ARGUNI',
		'ID91221' => 'TELUK ARGUNI BAWAH',
		'ID91230' => 'KAIMANA',
		'ID91231' => 'KAMBRAU',
		'ID91240' => 'TELUK ETNA',
		'ID91241' => 'YAMOR',
		'ID91310' => 'NAIKERE',
		'ID91320' => 'WONDIBOY',
		'ID91321' => 'RASIEY',
		'ID91322' => 'KURI WAMESA',
		'ID91330' => 'WASIOR',
		'ID91340' => 'DUAIRI',
		'ID91341' => 'ROON',
		'ID91350' => 'WINDESI',
		'ID91351' => 'NIKIWAR',
		'ID91360' => 'WAMESA',
		'ID91361' => 'ROSWAR',
		'ID91370' => 'RUMBERPON',
		'ID91371' => 'SOUG JAYA',
		'ID91410' => 'IRORUTU / FAFURWAR',
		'ID91420' => 'BABO',
		'ID91421' => 'SUMURI',
		'ID91422' => 'AROBA',
		'ID91423' => 'KAITARO',
		'ID91430' => 'KURI',
		'ID91440' => 'WAMESA',
		'ID91450' => 'BINTUNI',
		'ID91451' => 'MANIMERI',
		'ID91452' => 'TUHIBA',
		'ID91453' => 'DATARAN BEIMES',
		'ID91460' => 'TEMBUNI',
		'ID91470' => 'ARANDAY',
		'ID91471' => 'KOMUNDAN',
		'ID91472' => 'TOMU',
		'ID91473' => 'WERIAGAR',
		'ID91480' => 'MOSKONA SELATAN',
		'ID91481' => 'MEYADO',
		'ID91482' => 'MOSKONA BARAT',
		'ID91490' => 'MERDEY',
		'ID91491' => 'BISCOOP',
		'ID91492' => 'MASYETA',
		'ID914100' => 'MOSKONA UTARA',
		'ID914101' => 'MOSKONA TIMUR',
		'ID91540' => 'RANSIKI',
		'ID91541' => 'MOMI WAREN',
		'ID91542' => 'NENEI',
		'ID91580' => 'SURUREY',
		'ID91590' => 'ANGGI',
		'ID91591' => 'TAIGE',
		'ID91592' => 'MEMBEY',
		'ID915100' => 'ORANSBARI',
		'ID915110' => 'WARMARE',
		'ID915120' => 'PRAFI',
		'ID915130' => 'MENYAMBOUW',
		'ID915131' => 'CATUBOUW',
		'ID915141' => 'MANOKWARI BARAT',
		'ID915142' => 'MANOKWARI TIMUR',
		'ID915143' => 'MANOKWARI UTARA',
		'ID915144' => 'MANOKWARI SELATAN',
		'ID915145' => 'TESTEGA',
		'ID915146' => 'TANAH RUBU',
		'ID915150' => 'KEBAR',
		'ID915151' => 'SENOPI',
		'ID915160' => 'AMBERBAKEN',
		'ID915161' => 'MUBARNI / ARFU',
		'ID915170' => 'MASNI',
		'ID915171' => 'SIDEY',
		'ID915180' => 'TAHOSTA',
		'ID915190' => 'DIDOHU',
		'ID915200' => 'DATARAN ISIM',
		'ID915210' => 'ANGGI GIDA',
		'ID915220' => 'HINGK',
		'ID91610' => 'INANWATAN',
		'ID91611' => 'METEMANI',
		'ID91620' => 'KOKODA',
		'ID91621' => 'KAIS',
		'ID91622' => 'KOKODA UTARA',
		'ID91660' => 'MOSWAREN',
		'ID91670' => 'TEMINABUAN',
		'ID91671' => 'SEREMUK',
		'ID91672' => 'WAYER',
		'ID91673' => 'KONDA',
		'ID91674' => 'SAIFI',
		'ID91680' => 'SAWIAT',
		'ID91681' => 'FOKOUR',
		'ID91760' => 'MORAID',
		'ID91761' => 'KLASO',
		'ID917100' => 'MAKBON',
		'ID917101' => 'KLAYILI',
		'ID917110' => 'BERAUR',
		'ID917111' => 'KLAMONO',
		'ID917112' => 'KLABOT',
		'ID917113' => 'KLAWAK',
		'ID917120' => 'SALAWATI',
		'ID917121' => 'MAYAMUK',
		'ID917122' => 'SALAWATI TIMUR',
		'ID917130' => 'SEGET',
		'ID917131' => 'SEGUN',
		'ID917132' => 'SALAWATI SELATAN',
		'ID917170' => 'AIMAS',
		'ID917171' => 'MARIAT',
		'ID917180' => 'SAYOSA',
		'ID917181' => 'MAUDUS',
		'ID91811' => 'MISOOL SELATAN',
		'ID91812' => 'MISOOL BARAT',
		'ID91820' => 'MISOOL',
		'ID91821' => 'KOFIAU',
		'ID91822' => 'MISOOL TIMUR',
		'ID91823' => 'KEPULAUAN SEMBILAN',
		'ID91831' => 'SALAWATI UTARA',
		'ID91832' => 'SELAT SAGAWIN',
		'ID91840' => 'WAIGEO SELATAN',
		'ID91841' => 'TELUK MAYALIBIT',
		'ID91842' => 'MEOS MANSAR',
		'ID91850' => 'WAIGEO BARAT',
		'ID91851' => 'WAIGEO BARAT KEPULAUAN',
		'ID91860' => 'WAIGEO UTARA',
		'ID91861' => 'WARWARBOMI',
		'ID91870' => 'KEPULAUAN AYAU',
		'ID91880' => 'WAIGEO TIMUR',
		'ID91910' => 'FEF',
		'ID91911' => 'SYUJAK',
		'ID91920' => 'MIYAH',
		'ID91930' => 'ABUN',
		'ID91940' => 'KWOOR',
		'ID91950' => 'SAUSAPOR',
		'ID91960' => 'YEMBUN',
		'ID911010' => 'AITINYO BARAT/ATHABU',
		'ID911020' => 'AITINYO',
		'ID911030' => 'AIFAT SELATAN',
		'ID911040' => 'AIFAT',
		'ID911050' => 'AITINYO UTARA',
		'ID911060' => 'AYAMARU TIMUR',
		'ID911070' => 'AYAMARU',
		'ID911080' => 'AYAMARU UTARA',
		'ID911090' => 'MARE',
		'ID9110100' => 'AIFAT UTARA',
		'ID9110110' => 'AIFAT TIMUR',
		'ID917110' => 'SORONG BARAT',
		'ID917111' => 'SORONG KEPULAUAN',
		'ID917120' => 'SORONG TIMUR',
		'ID917121' => 'SORONG UTARA',
		'ID917122' => 'SORONG',
		'ID917123' => 'SORONG MANOI',
	],
	'PA' => [
		'ID94110' => 'KIMAAM',
		'ID94111' => 'WAAN',
		'ID94112' => 'TABONJI',
		'ID94113' => 'ILYAWAB',
		'ID94120' => 'OKABA',
		'ID94121' => 'TUBANG',
		'ID94122' => 'NGGUTI',
		'ID94123' => 'KAPTEL',
		'ID94130' => 'KURIK',
		'ID94131' => 'MALIND',
		'ID94132' => 'ANIMHA',
		'ID94140' => 'MERAUKE',
		'ID94141' => 'SEMANGGA',
		'ID94142' => 'TANAH MIRING',
		'ID94143' => 'JAGEBOB',
		'ID94144' => 'SOTA',
		'ID94145' => 'NAUKENJERAI',
		'ID94150' => 'MUTING',
		'ID94151' => 'ELIGOBEL',
		'ID94152' => 'ULILIN',
		'ID942110' => 'WAMENA',
		'ID942111' => 'ASOLOKOBAL',
		'ID942112' => 'WALELAGAMA',
		'ID942120' => 'HUBIKOSI',
		'ID942121' => 'PELEBAGA',
		'ID942180' => 'ASOLOGAIMA',
		'ID942181' => 'MUSATFAK',
		'ID942190' => 'KURULU',
		'ID942220' => 'BOLAKME',
		'ID942221' => 'WOLLO',
		'ID942222' => 'YALENGGA',
		'ID94380' => 'KAUREH',
		'ID94381' => 'AIRU',
		'ID94382' => 'YAPSI',
		'ID943140' => 'KEMTUK',
		'ID943150' => 'KEMTUK GRESI',
		'ID943151' => 'GRESI SELATAN',
		'ID943160' => 'NIMBORAN',
		'ID943161' => 'NIMBORAN TIMUR / NAMBLONG',
		'ID943170' => 'NIMBOKRANG',
		'ID943180' => 'UNURUM GUAY',
		'ID943200' => 'DEMTA',
		'ID943201' => 'YOKARI',
		'ID943210' => 'DEPAPRE',
		'ID943211' => 'RAVENIRARA',
		'ID943220' => 'SENTANI BARAT',
		'ID943221' => 'WAIBU',
		'ID943230' => 'SENTANI',
		'ID943231' => 'EBUNGFAU',
		'ID943240' => 'SENTANI TIMUR',
		'ID94450' => 'UWAPA',
		'ID94451' => 'MENOU',
		'ID94452' => 'DIPA',
		'ID94460' => 'YAUR',
		'ID94461' => 'TELUK UMAR',
		'ID94470' => 'WANGGAR',
		'ID94471' => 'NABIRE BARAT',
		'ID94480' => 'NABIRE',
		'ID94481' => 'TELUK KIMI',
		'ID94490' => 'NAPAN',
		'ID94491' => 'MAKIMI',
		'ID94492' => 'WAPOGA',
		'ID944100' => 'SIRIWO',
		'ID944110' => 'YARO',
		'ID94840' => 'YAPEN TIMUR',
		'ID94841' => 'YAPEN UTARA',
		'ID94842' => 'TELUK AMPIMOI',
		'ID94843' => 'RAIMBAWI',
		'ID94850' => 'ANGKAISERA',
		'ID94851' => 'KEP. AMBAI',
		'ID94860' => 'YAPEN SELATAN',
		'ID94861' => 'KOSIWO',
		'ID94870' => 'YAPEN BARAT',
		'ID94871' => 'WONAWA',
		'ID94880' => 'POOM',
		'ID94881' => 'WINDESI',
		'ID94910' => 'NUMFOR BARAT',
		'ID94911' => 'ORKERI',
		'ID94920' => 'NUMFOR TIMUR',
		'ID94921' => 'BRUYADORI',
		'ID94922' => 'POIRU',
		'ID94930' => 'PADAIDO',
		'ID94931' => 'AINANDO PADAIDO',
		'ID94940' => 'BIAK TIMUR',
		'ID94941' => 'ORIDEK',
		'ID94950' => 'BIAK KOTA',
		'ID94960' => 'SAMOFA',
		'ID94970' => 'YENDIDORI',
		'ID94980' => 'BIAK UTARA',
		'ID94981' => 'ANDEY',
		'ID94990' => 'WARSA',
		'ID94991' => 'YAWOSI',
		'ID94992' => 'BONDIFUAR',
		'ID949100' => 'BIAK BARAT',
		'ID949101' => 'SWANDIWE',
		'ID941030' => 'PANIAI TIMUR',
		'ID941031' => 'YATAMO',
		'ID941032' => 'KEBO',
		'ID941040' => 'BIBIDA',
		'ID941041' => 'DUMADAMA',
		'ID941070' => 'ARADIDE',
		'ID941071' => 'EKADIDE',
		'ID941080' => 'PANIAI BARAT',
		'ID941081' => 'SIRIWO',
		'ID941090' => 'BOGOBAIDA',
		'ID941140' => 'FAWI',
		'ID941150' => 'MULIA',
		'ID941151' => 'MEWOLUK',
		'ID941152' => 'YAMO',
		'ID941160' => 'ILU',
		'ID941161' => 'TORERE',
		'ID941162' => 'JIGONIKME',
		'ID941170' => 'TINGGINAMBUT',
		'ID941210' => 'MIMIKA BARAT',
		'ID941211' => 'MIMIKA BARAT JAUH',
		'ID941212' => 'MIMIKA BARAT TENGAH',
		'ID941220' => 'MIMIKA TIMUR',
		'ID941221' => 'MIMIKA TENGAH',
		'ID941222' => 'MIMIKA TIMUR JAUH',
		'ID941230' => 'MIMIKA BARU',
		'ID941231' => 'KUALA KENCANA',
		'ID941232' => 'TEMBAGAPURA',
		'ID941240' => 'AGIMUGA',
		'ID941241' => 'JILA',
		'ID941242' => 'JITA',
		'ID941310' => 'JAIR',
		'ID941311' => 'SUBUR',
		'ID941313' => 'KIA',
		'ID941320' => 'MINDIPTANA',
		'ID941321' => 'INIYANDIT',
		'ID941322' => 'KOMBUT',
		'ID941323' => 'SESNUK',
		'ID941330' => 'MANDOBO',
		'ID941331' => 'FOFI',
		'ID941332' => 'ARIMOP',
		'ID941340' => 'KOUH',
		'ID941341' => 'BOMAKIA',
		'ID941342' => 'FIRIWAGE',
		'ID941343' => 'MANGGELUM',
		'ID941344' => 'YANIRUMA',
		'ID941345' => 'KAWAGIT',
		'ID941346' => 'KOMBAY',
		'ID941350' => 'WAROPKO',
		'ID941351' => 'AMBATKWI',
		'ID941352' => 'NINATI',
		'ID941410' => 'NAMBIOMAN BAPAI',
		'ID941411' => 'MINYAMUR',
		'ID941420' => 'EDERA',
		'ID941421' => 'VENAHA',
		'ID941430' => 'OBAA',
		'ID941431' => 'PASSUE',
		'ID941440' => 'HAJU',
		'ID941450' => 'ASSUE',
		'ID941460' => 'CITAKMITAK',
		'ID941461' => 'KAIBAR',
		'ID941510' => 'PANTAI KASUARI',
		'ID941520' => 'FAYIT',
		'ID941530' => 'ATSY',
		'ID941540' => 'SUATOR',
		'ID941550' => 'AKAT',
		'ID941560' => 'AGATS',
		'ID941570' => 'SAWA ERMA',
		'ID941571' => 'SURU-SURU',
		'ID941610' => 'KURIMA',
		'ID941611' => 'MUSAIK',
		'ID941613' => 'DEKAI',
		'ID941614' => 'OBIO',
		'ID941615' => 'PASEMA',
		'ID941616' => 'AMUMA',
		'ID941617' => 'SURU-SURU',
		'ID941618' => 'WUSAMA',
		'ID941619' => 'SILIMO',
		'ID941620' => 'NINIA',
		'ID941621' => 'HOLUWON',
		'ID941622' => 'LOLAT',
		'ID941623' => 'LANGDA',
		'ID941624' => 'BOMELA',
		'ID941625' => 'SUNTAMON',
		'ID941626' => 'SOBAHAM',
		'ID941627' => 'KORUPUN',
		'ID941628' => 'SELA',
		'ID941629' => 'KWELAMDUA',
		'ID941630' => 'ANGGRUK',
		'ID941631' => 'PANGGEMA',
		'ID941632' => 'WALMA',
		'ID941633' => 'KOSAREK',
		'ID941634' => 'UBAHAK',
		'ID941635' => 'NALCA',
		'ID941636' => 'PULDAMA',
		'ID941637' => 'NIPSAN',
		'ID941641' => 'SAMENAGE',
		'ID941642' => 'TANGMA',
		'ID941643' => 'SOBA',
		'ID941644' => 'MUGI',
		'ID941645' => 'YOGOSEM',
		'ID941646' => 'KAYO',
		'ID941647' => 'SUMO',
		'ID941648' => 'HOGIO',
		'ID941649' => 'UKHA',
		'ID941651' => 'WERIMA',
		'ID941652' => 'SOLOIKMA',
		'ID941653' => 'SERADALA',
		'ID941654' => 'KABIANGGAMA',
		'ID941655' => 'KWIKMA',
		'ID941656' => 'HILIPUK',
		'ID941657' => 'YAHULIAMBUT',
		'ID941658' => 'HEREAPINI',
		'ID941659' => 'UBALIHI',
		'ID941661' => 'TALAMBO',
		'ID941662' => 'PRONGGOLI',
		'ID941663' => 'ENDOMEN',
		'ID941665' => 'KONA',
		'ID941666' => 'DURAM',
		'ID941667' => 'DIRWEMNA',
		'ID941710' => 'IWUR',
		'ID941711' => 'KAWOR',
		'ID941712' => 'TARUP',
		'ID941713' => 'AWINBON',
		'ID941720' => 'OKSIBIL',
		'ID941721' => 'PEPERA',
		'ID941722' => 'ALEMSOM',
		'ID941723' => 'SERAMBAKON',
		'ID941724' => 'KOLOMDOL',
		'ID941725' => 'OKSOP',
		'ID941726' => 'SEBANG',
		'ID941727' => 'OK BAPE',
		'ID941728' => 'OK AON',
		'ID941730' => 'BORME',
		'ID941731' => 'BIME',
		'ID941732' => 'EPUMEK',
		'ID941733' => 'WEIME',
		'ID941734' => 'PAMEK',
		'ID941735' => 'NONGME',
		'ID941736' => 'BATANI',
		'ID941740' => 'OKBI',
		'ID941741' => 'ABOY',
		'ID941742' => 'OKBAB',
		'ID941743' => 'TEIRAPLU',
		'ID941744' => 'YEFTA',
		'ID941750' => 'KIWIROK',
		'ID941751' => 'KIWIROK TIMUR',
		'ID941753' => 'OKHIKA',
		'ID941754' => 'OKLIP',
		'ID941755' => 'WARASAMO',
		'ID941760' => 'BATOM',
		'ID941761' => 'MURKIM',
		'ID941762' => 'MOFINOP',
		'ID941763' => 'OKBEMTA',
		'ID941810' => 'KANGGIME',
		'ID941811' => 'WONIKI',
		'ID941812' => 'NABUNAGE',
		'ID941813' => 'GILUBANDU',
		'ID941814' => 'WAKUO',
		'ID941820' => 'KARUBAGA',
		'ID941821' => 'GOYAGE',
		'ID941822' => 'WUNIN',
		'ID941823' => 'KONDAGA',
		'ID941824' => 'NELAWI',
		'ID941825' => 'KUARI',
		'ID941830' => 'BOKONDINI',
		'ID941831' => 'BOKONERI',
		'ID941832' => 'BEWANI',
		'ID941840' => 'KEMBU',
		'ID941841' => 'WINA',
		'ID941842' => 'UMAGI',
		'ID941843' => 'PANAGA',
		'ID941844' => 'POGANERI',
		'ID941845' => 'KAMBONERI',
		'ID941846' => 'AIR GARAM',
		'ID941847' => 'DOW',
		'ID941848' => 'WARI / TAIYEVE',
		'ID941849' => 'EGIAM',
		'ID941851' => 'NUNGGAWI',
		'ID941860' => 'KUBU',
		'ID941870' => 'GEYA',
		'ID941880' => 'NUMBA',
		'ID941890' => 'DUNDU',
		'ID9418100' => 'GUNDAGI',
		'ID9418110' => 'TIMORI',
		'ID9418121' => 'YUNERI',
		'ID9418122' => 'TAGINERI',
		'ID9418123' => 'DORMAN',
		'ID9418124' => 'SBEY',
		'ID941921' => 'PANTAI TIMUR BAGIAN BARAT',
		'ID941922' => 'PANTAI TIMUR',
		'ID941931' => 'BONGGO',
		'ID941932' => 'BONGGO TIMUR',
		'ID941940' => 'TOR ATAS',
		'ID941950' => 'SARMI',
		'ID941951' => 'SARMI TIMUR',
		'ID941952' => 'SARMI SELATAN',
		'ID941960' => 'PANTAI BARAT',
		'ID941961' => 'APAWER HULU',
		'ID942010' => 'WEB',
		'ID942011' => 'TOWE HITAM',
		'ID942020' => 'SENGGI',
		'ID942030' => 'WARIS',
		'ID942040' => 'ARSO',
		'ID942041' => 'ARSO TIMUR',
		'ID942050' => 'SKANTO',
		'ID942610' => 'WAROPEN BAWAH',
		'ID942611' => 'INGGERUS',
		'ID942612' => 'UREIFAISEI',
		'ID942613' => 'OADATE',
		'ID942614' => 'WAPOGA',
		'ID942620' => 'MASIREI',
		'ID942621' => 'RISEI SAYATI',
		'ID942622' => 'DEMBA',
		'ID942630' => 'WALANI',
		'ID942640' => 'KIRIHI',
		'ID942710' => 'SUPIORI SELATAN',
		'ID942711' => 'KEPULAUAN ARURI',
		'ID942720' => 'SUPIORI UTARA',
		'ID942721' => 'SUPIORI BARAT',
		'ID942730' => 'SUPIORI TIMUR',
		'ID942830' => 'WAROPEN ATAS',
		'ID942831' => 'BENUKI',
		'ID942832' => 'SAWAI',
		'ID942840' => 'MAMBERAMO ILIR',
		'ID942850' => 'MAMBERAMO TENGAH',
		'ID942860' => 'MAMBERAMO TENGAH TIMUR',
		'ID942870' => 'ROFAER',
		'ID942880' => 'MAMBERAMO ULU',
		'ID942910' => 'WOSAK',
		'ID942920' => 'KENYAM',
		'ID942930' => 'GESELMA',
		'ID942940' => 'MAPENDUMA',
		'ID942950' => 'MUGI',
		'ID942960' => 'YIGI',
		'ID942970' => 'MBUWA',
		'ID942980' => 'GEAREK',
		'ID943010' => 'MAKKI',
		'ID943020' => 'PIRIME',
		'ID943030' => 'TIOM',
		'ID943040' => 'BALINGGA',
		'ID943050' => 'KUYAWAGE',
		'ID943060' => 'MALAGAINERI',
		'ID943070' => 'TIOMNERI',
		'ID943080' => 'DIMBA',
		'ID943090' => 'GAMELIA',
		'ID9430100' => 'POGA',
		'ID943110' => 'KOBAKMA',
		'ID943120' => 'ILUGWA',
		'ID943130' => 'KELILA',
		'ID943140' => 'ERAGAYAM',
		'ID943150' => 'MEGAMBILIS',
		'ID943210' => 'WELAREK',
		'ID943220' => 'APALAPSILI',
		'ID943230' => 'ABENAHO',
		'ID943240' => 'ELELIM',
		'ID943250' => 'BENAWA',
		'ID943310' => 'AGADUGUME',
		'ID943320' => 'GOME',
		'ID943330' => 'ILAGA',
		'ID943340' => 'SINAK',
		'ID943350' => 'POGOMA',
		'ID943360' => 'WANGBE',
		'ID943370' => 'BEOGA',
		'ID943380' => 'DOUFO',
		'ID943410' => 'SUKIKAI SELATAN',
		'ID943420' => 'PIYAIYE',
		'ID943430' => 'MAPIA BARAT',
		'ID943440' => 'MAPIA TENGAH',
		'ID943450' => 'MAPIA',
		'ID943460' => 'DOGIYAI',
		'ID943470' => 'KAMU SELATAN',
		'ID943480' => 'KAMU',
		'ID943490' => 'KAMU TIMUR',
		'ID9434100' => 'KAMU UTARA',
		'ID943510' => 'HOMEYO',
		'ID943520' => 'SUGAPA',
		'ID943530' => 'HITADIPA',
		'ID943540' => 'AGISIGA',
		'ID943550' => 'BIANDOGA',
		'ID943560' => 'WANDAI',
		'ID943610' => 'KAPIRAYA',
		'ID943620' => 'TIGI BARAT',
		'ID943630' => 'TIGI',
		'ID943640' => 'TIGI TIMUR',
		'ID943650' => 'BOWOBADO',
		'ID947110' => 'MUARA TAMI',
		'ID947120' => 'ABEPURA',
		'ID947121' => 'HERAM',
		'ID947130' => 'JAYAPURA SELATAN',
		'ID947140' => 'JAYAPURA UTARA',
	]
];
