<?php

/**
 * List of cities for: Hungary
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'HU03009' => 'Szombathely',
	'HU03115' => 'Dunaújváros',
	'HU08518' => 'Sopron',
	'HU11767' => 'Veszprém',
	'HU13578' => 'Budapest',
	'HU14827' => 'Székesfehérvár',
	'HU15130' => 'Debrecen',
	'HU15200' => 'Békéscsaba',
	'HU17206' => 'Nyíregyháza',
	'HU18157' => 'Tatabánya',
	'HU19415' => 'Pécs',
	'HU20473' => 'Kaposvár',
	'HU20491' => 'Eger',
	'HU25584' => 'Győr',
	'HU26684' => 'Kecskemét',
	'HU27854' => 'Szolnok',
	'HU30456' => 'Miskolc',
	'HU30988' => 'Érd',
	'HU32054' => 'Zalaegerszeg',
	'HU33367' => 'Szeged',
	'HU02185' => 'Csopak',
	'HU02219' => 'Balatonfűzfő',
	'HU02307' => 'Kaba',
	'HU02626' => 'Martfű',
	'HU02848' => 'Felsőzsolca',
	'HU02918' => 'Balmazújváros',
	'HU03045' => 'Hajdúböszörmény',
	'HU03276' => 'Füzesabony',
	'HU03300' => 'Iklad',
	'HU03522' => 'Baja',
	'HU03771' => 'Arnót',
	'HU03814' => 'Hévíz',
	'HU04039' => 'Csorna',
	'HU04057' => 'Pécel',
	'HU04075' => 'Ócsa',
	'HU04154' => 'Tárnok',
	'HU04260' => 'Mezőtúr',
	'HU04330' => 'Mátraszőlős',
	'HU04428' => 'Ács',
	'HU04659' => 'Martonvásár',
	'HU04783' => 'Mosonmagyaróvár',
	'HU04808' => 'Domony',
	'HU04862' => 'Paks',
	'HU04880' => 'Ágfalva',
	'HU04905' => 'Pócsmegyer',
	'HU04923' => 'Karcag',
	'HU05032' => 'Gyula',
	'HU05111' => 'Csongrád',
	'HU05120' => 'Sátoraljaújhely',
	'HU05175' => 'Hajdúszoboszló',
	'HU05236' => 'Gyöngyös',
	'HU05449' => 'Komárom',
	'HU05519' => 'Siklós',
	'HU05564' => 'Lovas',
	'HU05573' => 'Derecske',
	'HU05591' => 'Izsófalva',
	'HU05670' => 'Gégény',
	'HU05768' => 'Létavértes',
	'HU05838' => 'Balatonalmádi',
	'HU06187' => 'Nyíradony',
	'HU06266' => 'Hosszúpályi',
	'HU06336' => 'Kozármisleny',
	'HU06372' => 'Pomáz',
	'HU06442' => 'Kalocsa',
	'HU06488' => 'Nagyecsed',
	'HU06497' => 'Bonyhád',
	'HU06628' => 'Szécsény',
	'HU06673' => 'Ajka',
	'HU06691' => 'Kazincbarcika',
	'HU06859' => 'Törökbálint',
	'HU06929' => 'Bekecs',
	'HU07144' => 'Piliscsaba',
	'HU07241' => 'Apc',
	'HU07357' => 'Makó',
	'HU07384' => 'Solymár',
	'HU07409' => 'Pásztó',
	'HU07481' => 'Győrújbarát',
	'HU07597' => 'Tiszavasvári',
	'HU07685' => 'Dombóvár',
	'HU07807' => 'Isaszeg',
	'HU08129' => 'Sajóörös',
	'HU08314' => 'Hódmezővásárhely',
	'HU08545' => 'Őrbottyán',
	'HU08758' => 'Tát',
	'HU08828' => 'Teskánd',
	'HU08864' => 'Bátaszék',
	'HU08891' => 'Biatorbágy',
	'HU09131' => 'Bag',
	'HU09247' => 'Dabas',
	'HU09265' => 'Kisvárda',
	'HU09344' => 'Kiskőrös',
	'HU09469' => 'Jánoshalma',
	'HU09496' => 'Szirmabesenyő',
	'HU09584' => 'Dunaharaszti',
	'HU09593' => 'Tura',
	'HU09690' => 'Halásztelek',
	'HU09760' => 'Békés',
	'HU09821' => 'Pilis',
	'HU09973' => 'Délegyháza',
	'HU09991' => 'Nagykovácsi',
	'HU10162' => 'Püspökladány',
	'HU10278' => 'Sé',
	'HU10296' => 'Gárdony',
	'HU10320' => 'Vizslás',
	'HU10393' => 'Hajdúhadház',
	'HU10481' => 'Bicske',
	'HU10490' => 'Dorog',
	'HU10551' => 'Monor',
	'HU10719' => 'Bácsalmás',
	'HU10728' => 'Edelény',
	'HU10816' => 'Kiskunlacháza',
	'HU10922' => 'Maglód',
	'HU11341' => 'Cegléd',
	'HU11396' => 'Pilisszentiván',
	'HU11439' => 'Várpalota',
	'HU11642' => 'Felsőpáhok',
	'HU11819' => 'Kurityán',
	'HU11934' => 'Üröm',
	'HU12052' => 'Budakeszi',
	'HU12256' => 'Füzesgyarmat',
	'HU12274' => 'Nyírmada',
	'HU12575' => 'Lenti',
	'HU12690' => 'Sződ',
	'HU12788' => 'Berettyóújfalu',
	'HU12803' => 'Hajdúdorog',
	'HU12885' => 'Nyékládháza',
	'HU12894' => 'Üllő',
	'HU12919' => 'Vonyarcvashegy',
	'HU12955' => 'Nyúl',
	'HU13277' => 'Szigethalom',
	'HU13435' => 'Nagykáta',
	'HU13462' => 'Iváncsa',
	'HU13480' => 'Erdőkertes',
	'HU13532' => 'Körmend',
	'HU13657' => 'Balassagyarmat',
	'HU13815' => 'Tiszaföldvár',
	'HU13833' => 'Mezőcsát',
	'HU13860' => 'Pusztadobos',
	'HU13949' => 'Hévízgyörk',
	'HU14155' => 'Tokod',
	'HU14173' => 'Bánd',
	'HU14331' => 'Arló',
	'HU14340' => 'Pilisvörösvár',
	'HU14456' => 'Szentes',
	'HU14492' => 'Ózd',
	'HU14526' => 'Heves',
	'HU14845' => 'Nyírbátor',
	'HU15024' => 'Páty',
	'HU15255' => 'Lábatlan',
	'HU15291' => 'Újszász',
	'HU15307' => 'Kápolna',
	'HU15352' => 'Nyergesújfalu',
	'HU15440' => 'Szentendre',
	'HU15866' => 'Szentlőrinc',
	'HU16054' => 'Sajószentpéter',
	'HU16188' => 'Aszód',
	'HU16434' => 'Tótkomlós',
	'HU16638' => 'Sajópetri',
	'HU16647' => 'Fegyvernek',
	'HU16708' => 'Écs',
	'HU16832' => 'Kőszeg',
	'HU17011' => 'Paloznak',
	'HU17260' => 'Ráckeve',
	'HU17312' => 'Százhalombatta',
	'HU17330' => 'Kisbér',
	'HU17525' => 'Polgárdi',
	'HU17631' => 'Siófok',
	'HU17668' => 'Vácrátót',
	'HU17677' => 'Lajosmizse',
	'HU17756' => 'Demecser',
	'HU17941' => 'Nagyatád',
	'HU18102' => 'Battonya',
	'HU18209' => 'Jászberény',
	'HU18324' => 'Vásárosnamény',
	'HU18342' => 'Veresegyház',
	'HU18421' => 'Keszthely',
	'HU18485' => 'Mór',
	'HU18500' => 'Marcali',
	'HU18616' => 'Dunakeszi',
	'HU18874' => 'Mátészalka',
	'HU18971' => 'Fehérgyarmat',
	'HU19433' => 'Mezőkövesd',
	'HU19503' => 'Galgahévíz',
	'HU19628' => 'Mezőberény',
	'HU19716' => 'Nagykőrös',
	'HU19789' => 'Kecel',
	'HU19983' => 'Soltvadkert',
	'HU20002' => 'Csákvár',
	'HU20127' => 'Tata',
	'HU20297' => 'Kiskunfélegyháza',
	'HU20534' => 'Dunavarsány',
	'HU21032' => 'Alsózsolca',
	'HU21111' => 'Jászladány',
	'HU21175' => 'Balatonfüred',
	'HU21306' => 'Sárvár',
	'HU21351' => 'Szikszó',
	'HU21458' => 'Szada',
	'HU21555' => 'Mindszent',
	'HU21713' => 'Sülysáp',
	'HU21722' => 'Zagyvaszántó',
	'HU21883' => 'Szeghalom',
	'HU21926' => 'Kápolnásnyék',
	'HU22105' => 'Jászárokszállás',
	'HU22202' => 'Jászapáti',
	'HU22309' => 'Hatvan',
	'HU22406' => 'Hajdúnánás',
	'HU22567' => 'Kunhegyes',
	'HU22761' => 'Szekszárd',
	'HU22804' => 'Csömör',
	'HU22859' => 'Jánoshida',
	'HU22886' => 'Kisbajcs',
	'HU23065' => 'Orosháza',
	'HU23117' => 'Polgár',
	'HU23171' => 'Kunmadaras',
	'HU23214' => 'Téglás',
	'HU23278' => 'Budaörs',
	'HU23302' => 'Gyenesdiás',
	'HU23339' => 'Jászfényszaru',
	'HU23409' => 'Nagytarcsa',
	'HU23463' => 'Budakalász',
	'HU23524' => 'Tiszalök',
	'HU23603' => 'Ercsi',
	'HU23649' => 'Göd',
	'HU23658' => 'Herend',
	'HU23694' => 'Sárbogárd',
	'HU23728' => 'Kótaj',
	'HU23852' => 'Ászár',
	'HU23870' => 'Szarvas',
	'HU23959' => 'Mohács',
	'HU23995' => 'Kompolt',
	'HU24013' => 'Diósd',
	'HU24165' => 'Hernádkak',
	'HU24183' => 'Gencsapáti',
	'HU24396' => 'Kiskunmajsa',
	'HU24518' => 'Ecser',
	'HU24563' => 'Tamási',
	'HU24785' => 'Nagykálló',
	'HU24819' => 'Dévaványa',
	'HU24934' => 'Vác',
	'HU25016' => 'Velence',
	'HU25034' => 'Zsámbék',
	'HU25131' => 'Esztergom',
	'HU25274' => 'Tolna',
	'HU25593' => 'Sümeg',
	'HU25627' => 'Gyál',
	'HU25636' => 'Ibrány',
	'HU25788' => 'Salgótarján',
	'HU25919' => 'Kisújszállás',
	'HU26213' => 'Szigetmonostor',
	'HU26408' => 'Komló',
	'HU26499' => 'Zirc',
	'HU26578' => 'Szigetvár',
	'HU26611' => 'Újfehértó',
	'HU26657' => 'Járdánháza',
	'HU26815' => 'Vecsés',
	'HU26949' => 'Sajókeresztúr',
	'HU27094' => 'Celldömölk',
	'HU27173' => 'Sajólád',
	'HU27313' => 'Törökszentmiklós',
	'HU27395' => 'Mályi',
	'HU27410' => 'Putnok',
	'HU27474' => 'Sárospatak',
	'HU27599' => 'Nadap',
	'HU27687' => 'Kosd',
	'HU27872' => 'Abony',
	'HU28103' => 'Nádudvar',
	'HU28130' => 'Kunszentmiklós',
	'HU28228' => 'Túrkeve',
	'HU28334' => 'Kapuvár',
	'HU28352' => 'Tiszaújváros',
	'HU28565' => 'Sarkad',
	'HU28866' => 'Sződliget',
	'HU28954' => 'Szigetszentmiklós',
	'HU29018' => 'Pusztaszabolcs',
	'HU29115' => 'Solt',
	'HU29212' => 'Baj',
	'HU29221' => 'Jánossomorja',
	'HU29434' => 'Tapolca',
	'HU29531' => 'Vésztő',
	'HU29601' => 'Pilisborosjenő',
	'HU29647' => 'Dömsöd',
	'HU29726' => 'Tiszafüred',
	'HU29735' => 'Gyömrő',
	'HU29823' => 'Tököl',
	'HU29878' => 'Torony',
	'HU30322' => 'Mezőkovácsháza',
	'HU30340' => 'Sajószöged',
	'HU30401' => 'Lőrinci',
	'HU30483' => 'Forró',
	'HU30623' => 'Tiszakécske',
	'HU30696' => 'Kartal',
	'HU30720' => 'Taksony',
	'HU30739' => 'Szerencs',
	'HU30766' => 'Oroszlány',
	'HU30809' => 'Leányfalu',
	'HU30933' => 'Nagykanizsa',
	'HU31024' => 'Kistelek',
	'HU31097' => 'Hajdúsámson',
	'HU31200' => 'Hernádnémeti',
	'HU31501' => 'Dunaföldvár',
	'HU31583' => 'Szentgotthárd',
	'HU31653' => 'Albertirsa',
	'HU31705' => 'Sándorfalva',
	'HU31732' => 'Nagymaros',
	'HU31796' => 'Tápiószecső',
	'HU31945' => 'Pápa',
	'HU32045' => 'Táplánszentkereszt',
	'HU32106' => 'Inárcs',
	'HU32230' => 'Kakucs',
	'HU32434' => 'Kiskunhalas',
	'HU32504' => 'Kunszentmárton',
	'HU32559' => 'Gödöllő',
	'HU32610' => 'Fót',
	'HU32799' => 'Barcs',
	'HU33048' => 'Encs',
	'HU33118' => 'Csomád',
	'HU33127' => 'Berhida',
	'HU33455' => 'Gyomaendrőd',
	'HU33534' => 'Bátonyterenye',
	'HU33853' => 'Balatonboglár',
	'HU33862' => 'Balatonlelle',
	'HU33996' => 'Farád',
	'HU34023' => 'Tokodaltáró',
	'HU34069' => 'Ormosbánya',
	'HU34120' => 'Rudolftelep',
	'HU34148' => 'Pilisjászfalu',
	'HU34157' => 'Kistarcsa',
	'HU34166' => 'Kerepes',
	'HU34272' => 'Farkaslyuk',
	'HU34315' => 'Remeteszőlős',
	'HU34333' => 'Csörög',
	'HU01508' => 'Ipolyszög',
	'HU01526' => 'Somoskőújfalu',
	'HU02015' => 'Ráckeresztúr',
	'HU02024' => 'Martonyi',
	'HU02033' => 'Kakasd',
	'HU02042' => 'Narda',
	'HU02051' => 'Sávoly',
	'HU02060' => 'Gönyű',
	'HU02079' => 'Dunaremete',
	'HU02088' => 'Mánd',
	'HU02097' => 'Gutorfölde',
	'HU02103' => 'Maróc',
	'HU02121' => 'Csanádalberti',
	'HU02130' => 'Mihályfa',
	'HU02149' => 'Foktő',
	'HU02158' => 'Muhi',
	'HU02167' => 'Komádi',
	'HU02194' => 'Nemesvámos',
	'HU02200' => 'Isztimér',
	'HU02228' => 'Martonfa',
	'HU02237' => 'Vág',
	'HU02246' => 'Vát',
	'HU02264' => 'Vásárosdombó',
	'HU02273' => 'Abaújvár',
	'HU02282' => 'Hejőkürt',
	'HU02291' => 'Tiszabábolna',
	'HU02316' => 'Etyek',
	'HU02325' => 'Baktalórántháza',
	'HU02343' => 'Kincsesbánya',
	'HU02352' => 'Újkígyós',
	'HU02361' => 'Nagybajcs',
	'HU02370' => 'Rád',
	'HU02389' => 'Bercel',
	'HU02404' => 'Surd',
	'HU02413' => 'Kisbabot',
	'HU02422' => 'Hegyesd',
	'HU02431' => 'Bük',
	'HU02440' => 'Szatta',
	'HU02459' => 'Vajta',
	'HU02468' => 'Hegymeg',
	'HU02477' => 'Csombárd',
	'HU02486' => 'Zalacséb',
	'HU02495' => 'Nagycenk',
	'HU02501' => 'Kisunyom',
	'HU02510' => 'Kocs',
	'HU02529' => 'Várfölde',
	'HU02547' => 'Sumony',
	'HU02556' => 'Mórichida',
	'HU02565' => 'Döbrököz',
	'HU02574' => 'Kenéz',
	'HU02583' => 'Csesztreg',
	'HU02608' => 'Zalaszentiván',
	'HU02617' => 'Sopronnémeti',
	'HU02635' => 'Öttevény',
	'HU02644' => 'Alibánfa',
	'HU02653' => 'Nagyharsány',
	'HU02662' => 'Milejszeg',
	'HU02671' => 'Kántorjánosi',
	'HU02680' => 'Békésszentandrás',
	'HU02699' => 'Sárkeszi',
	'HU02705' => 'Pálmonostora',
	'HU02714' => 'Tótvázsony',
	'HU02723' => 'Sáregres',
	'HU02741' => 'Fáj',
	'HU02750' => 'Vértesacsa',
	'HU02769' => 'Tápiószőlős',
	'HU02778' => 'Ludányhalászi',
	'HU02787' => 'Nemesgulács',
	'HU02796' => 'Nak',
	'HU02802' => 'Enying',
	'HU02811' => 'Miszla',
	'HU02820' => 'Abaújlak',
	'HU02839' => 'Nemeskocs',
	'HU02857' => 'Geresdlak',
	'HU02866' => 'Oszlár',
	'HU02875' => 'Sáta',
	'HU02884' => 'Vasalja',
	'HU02893' => 'Söréd',
	'HU02909' => 'Magyarszentmiklós',
	'HU02927' => 'Duka',
	'HU02936' => 'Dudar',
	'HU02945' => 'Biri',
	'HU02954' => 'Felsőszentiván',
	'HU02963' => 'Bükkszék',
	'HU02972' => 'Zalasárszeg',
	'HU02981' => 'Egerfarmos',
	'HU02990' => 'Bátorliget',
	'HU03018' => 'Szebény',
	'HU03036' => 'Döröske',
	'HU03054' => 'Lickóvadamos',
	'HU03063' => 'Zádorfalva',
	'HU03072' => 'Balatoncsicsó',
	'HU03081' => 'Sajóhídvég',
	'HU03090' => 'Borgáta',
	'HU03106' => 'Kétsoprony',
	'HU03124' => 'Szentkozmadombja',
	'HU03133' => 'Taktaszada',
	'HU03142' => 'Vönöck',
	'HU03151' => 'Kistapolca',
	'HU03160' => 'Szuhafő',
	'HU03188' => 'Iborfia',
	'HU03197' => 'Rábahídvég',
	'HU03203' => 'Nyim',
	'HU03212' => 'Sajóivánka',
	'HU03221' => 'Magyarlak',
	'HU03230' => 'Fajsz',
	'HU03249' => 'Őrhalom',
	'HU03258' => 'Földes',
	'HU03267' => 'Badacsonytördemic',
	'HU03285' => 'Hirics',
	'HU03294' => 'Molnaszecsőd',
	'HU03319' => 'Ártánd',
	'HU03328' => 'Ipolytarnóc',
	'HU03337' => 'Ivánbattyán',
	'HU03346' => 'Ivándárda',
	'HU03355' => 'Nova',
	'HU03364' => 'Szilsárkány',
	'HU03373' => 'Tiszapüspöki',
	'HU03382' => 'Szarvaskő',
	'HU03391' => 'Piricse',
	'HU03407' => 'Budajenő',
	'HU03416' => 'Somogyszil',
	'HU03425' => 'Bogyiszló',
	'HU03434' => 'Lasztonya',
	'HU03443' => 'Mezőzombor',
	'HU03452' => 'Boldog',
	'HU03461' => 'Kétegyháza',
	'HU03470' => 'Meződ',
	'HU03489' => 'Edde',
	'HU03498' => 'Vereb',
	'HU03504' => 'Sajóbábony',
	'HU03513' => 'Visznek',
	'HU03531' => 'Léh',
	'HU03540' => 'Kökény',
	'HU03559' => 'Balatonvilágos',
	'HU03568' => 'Szentantalfa',
	'HU03577' => 'Géderlak',
	'HU03586' => 'Szabolcsveresmart',
	'HU03595' => 'Abaújszántó',
	'HU03601' => 'Sóly',
	'HU03610' => 'Malomsok',
	'HU03629' => 'Géberjén',
	'HU03638' => 'Balatonhenye',
	'HU03647' => 'Döge',
	'HU03656' => 'Bátmonostor',
	'HU03665' => 'Cered',
	'HU03674' => 'Nemeskeresztúr',
	'HU03683' => 'Magyarhomorog',
	'HU03692' => 'Mende',
	'HU03708' => 'Taktabáj',
	'HU03717' => 'Tiszadorogma',
	'HU03726' => 'Zebecke',
	'HU03735' => 'Bárdudvarnok',
	'HU03744' => 'Gagyvendégi',
	'HU03753' => 'Rábcakapi',
	'HU03762' => 'Kiskinizs',
	'HU03780' => 'Ócsárd',
	'HU03799' => 'Csákány',
	'HU03805' => 'Szakáld',
	'HU03823' => 'Ároktő',
	'HU03832' => 'Keszü',
	'HU03841' => 'Bokor',
	'HU03850' => 'Tiszabercel',
	'HU03869' => 'Kistormás',
	'HU03878' => 'Nyírpilis',
	'HU03887' => 'Szerecseny',
	'HU03896' => 'Cserkút',
	'HU03902' => 'Mád',
	'HU03911' => 'Csákánydoroszló',
	'HU03939' => 'Cigánd',
	'HU03948' => 'Raposka',
	'HU03957' => 'Viszló',
	'HU03966' => 'Ruzsa',
	'HU03975' => 'Baksa',
	'HU03984' => 'Nagybudmér',
	'HU03993' => 'Héhalom',
	'HU04002' => 'Zalacsány',
	'HU04020' => 'Himod',
	'HU04048' => 'Tófű',
	'HU04066' => 'Küngös',
	'HU04084' => 'Hevesvezekény',
	'HU04093' => 'Helvécia',
	'HU04109' => 'Dusnok',
	'HU04118' => 'Hortobágy',
	'HU04127' => 'Som',
	'HU04136' => 'Töttös',
	'HU04145' => 'Hort',
	'HU04163' => 'Bödeháza',
	'HU04172' => 'Tárnokréti',
	'HU04181' => 'Perőcsény',
	'HU04190' => 'Köcsk',
	'HU04206' => 'Mezőgyán',
	'HU04215' => 'Nyomár',
	'HU04224' => 'Csörötnek',
	'HU04233' => 'Aszaló',
	'HU04242' => 'Nagykamarás',
	'HU04251' => 'Ecseg',
	'HU04279' => 'Kamut',
	'HU04288' => 'Kispirit',
	'HU04297' => 'Kacsóta',
	'HU04303' => 'Püspökszilágy',
	'HU04312' => 'Tarpa',
	'HU04321' => 'Bodorfa',
	'HU04349' => 'Mórahalom',
	'HU04358' => 'Nógrád',
	'HU04367' => 'Bogyoszló',
	'HU04376' => 'Lázi',
	'HU04385' => 'Magyartelek',
	'HU04394' => 'Makád',
	'HU04400' => 'Bekölce',
	'HU04419' => 'Nyésta',
	'HU04437' => 'Udvar',
	'HU04446' => 'Tiszakerecseny',
	'HU04455' => 'Nagylengyel',
	'HU04464' => 'Szakály',
	'HU04473' => 'Kányavár',
	'HU04482' => 'Oroszló',
	'HU04491' => 'Sényő',
	'HU04507' => 'Szendehely',
	'HU04516' => 'Rózsafa',
	'HU04525' => 'Kecskéd',
	'HU04534' => 'Mindszentkálla',
	'HU04543' => 'Feked',
	'HU04552' => 'Litér',
	'HU04561' => 'Ábrahámhegy',
	'HU04570' => 'Márianosztra',
	'HU04589' => 'Veszkény',
	'HU04598' => 'Kereki',
	'HU04604' => 'Hejőkeresztúr',
	'HU04613' => 'Gelénes',
	'HU04622' => 'Zsira',
	'HU04631' => 'Tüskevár',
	'HU04640' => 'Kám',
	'HU04668' => 'Mihályháza',
	'HU04677' => 'Emőd',
	'HU04686' => 'Dédestapolcsány',
	'HU04695' => 'Vasvár',
	'HU04701' => 'Iregszemcse',
	'HU04710' => 'Nagyar',
	'HU04729' => 'Sály',
	'HU04738' => 'Bak',
	'HU04747' => 'Sárpilis',
	'HU04756' => 'Misefa',
	'HU04765' => 'Borszörcsök',
	'HU04774' => 'Szakoly',
	'HU04792' => 'Rábacsanak',
	'HU04817' => 'Zsáka',
	'HU04826' => 'Kisgyalán',
	'HU04835' => 'Somogyzsitfa',
	'HU04844' => 'Terény',
	'HU04853' => 'Somogyudvarhely',
	'HU04871' => 'Litke',
	'HU04899' => 'Bikal',
	'HU04914' => 'Trizs',
	'HU04932' => 'Taszár',
	'HU04950' => 'Ortaháza',
	'HU04969' => 'Tormafölde',
	'HU04978' => 'Ipolytölgyes',
	'HU04987' => 'Megyer',
	'HU04996' => 'Garbolc',
	'HU05005' => 'Irota',
	'HU05014' => 'Vének',
	'HU05023' => 'Bozsok',
	'HU05041' => 'Nyírderzs',
	'HU05050' => 'Csitár',
	'HU05069' => 'Györgytarló',
	'HU05078' => 'Rinyabesenyő',
	'HU05087' => 'Lovászpatona',
	'HU05096' => 'Viss',
	'HU05102' => 'Balogunyom',
	'HU05139' => 'Birján',
	'HU05148' => 'Balatonkenese',
	'HU05157' => 'Somlójenő',
	'HU05166' => 'Tömörd',
	'HU05184' => 'Csemő',
	'HU05193' => 'Szorosad',
	'HU05209' => 'Villánykövesd',
	'HU05218' => 'Nagygörbő',
	'HU05227' => 'Kisnémedi',
	'HU05245' => 'Nemesbikk',
	'HU05254' => 'Kuncsorba',
	'HU05263' => 'Karád',
	'HU05272' => 'Kánya',
	'HU05281' => 'Örkény',
	'HU05290' => 'Pilisszántó',
	'HU05306' => 'Bőcs',
	'HU05315' => 'Borsodnádasd',
	'HU05324' => 'Herencsény',
	'HU05333' => 'Csobád',
	'HU05342' => 'Tófej',
	'HU05351' => 'Kára',
	'HU05360' => 'Csákberény',
	'HU05379' => 'Csanádpalota',
	'HU05388' => 'Sümegprága',
	'HU05397' => 'Pusztaföldvár',
	'HU05403' => 'Babarc',
	'HU05412' => 'Magyarmecske',
	'HU05421' => 'Királyszentistván',
	'HU05430' => 'Magyarhertelend',
	'HU05458' => 'Kenézlő',
	'HU05476' => 'Bő',
	'HU05485' => 'Baranyaszentgyörgy',
	'HU05494' => 'Gadna',
	'HU05500' => 'Somogyaracs',
	'HU05528' => 'Szörény',
	'HU05537' => 'Kallósd',
	'HU05546' => 'Zákányszék',
	'HU05555' => 'Nemeshany',
	'HU05582' => 'Nagycsécs',
	'HU05607' => 'Szederkény',
	'HU05616' => 'Hetefejércse',
	'HU05625' => 'Révfülöp',
	'HU05634' => 'Káptalantóti',
	'HU05643' => 'Szilvásvárad',
	'HU05652' => 'Nemesgörzsöny',
	'HU05661' => 'Ozora',
	'HU05689' => 'Mezőkomárom',
	'HU05698' => 'Váckisújfalu',
	'HU05704' => 'Pethőhenye',
	'HU05713' => 'Harasztifalu',
	'HU05722' => 'Kisbeszterce',
	'HU05731' => 'Gerjen',
	'HU05740' => 'Kőszegdoroszló',
	'HU05759' => 'Vécs',
	'HU05777' => 'Szászberek',
	'HU05786' => 'Ladánybene',
	'HU05795' => 'Cserkeszőlő',
	'HU05801' => 'Gávavencsellő',
	'HU05810' => 'Szőkedencs',
	'HU05829' => 'Vál',
	'HU05847' => 'Harsány',
	'HU05856' => 'Kunadacs',
	'HU05865' => 'Egerlövő',
	'HU05874' => 'Szajol',
	'HU05883' => 'Palotás',
	'HU05892' => 'Vokány',
	'HU05917' => 'Vácduka',
	'HU05926' => 'Bódvaszilas',
	'HU05935' => 'Karácsond',
	'HU05944' => 'Bakonyszentlászló',
	'HU05953' => 'Kissomlyó',
	'HU05962' => 'Magyarcsanád',
	'HU05971' => 'Csokonyavisonta',
	'HU05980' => 'Egyházasgerge',
	'HU05999' => 'Kárász',
	'HU06008' => 'Zamárdi',
	'HU06017' => 'Magyarkeszi',
	'HU06035' => 'Felsőpakony',
	'HU06044' => 'Kunbaja',
	'HU06053' => 'Ragály',
	'HU06062' => 'Újpetre',
	'HU06071' => 'Keménfa',
	'HU06080' => 'Ádánd',
	'HU06099' => 'Ellend',
	'HU06105' => 'Kálmáncsa',
	'HU06114' => 'Füle',
	'HU06123' => 'Dövény',
	'HU06132' => 'Csapi',
	'HU06141' => 'Patalom',
	'HU06169' => 'Nemesapáti',
	'HU06178' => 'Eszteregnye',
	'HU06196' => 'Barbacs',
	'HU06202' => 'Lakitelek',
	'HU06211' => 'Hollád',
	'HU06220' => 'Bodonhely',
	'HU06239' => 'Vadosfa',
	'HU06248' => 'Pinkamindszent',
	'HU06257' => 'Zsadány',
	'HU06275' => 'Zajta',
	'HU06284' => 'Pitvaros',
	'HU06293' => 'Újhartyán',
	'HU06309' => 'Nagyrábé',
	'HU06318' => 'Nagyrév',
	'HU06327' => 'Bakonypölöske',
	'HU06345' => 'Aldebrő',
	'HU06354' => 'Pusztamérges',
	'HU06363' => 'Dörgicse',
	'HU06381' => 'Tolmács',
	'HU06390' => 'Bozzai',
	'HU06406' => 'Jákfa',
	'HU06415' => 'Kákics',
	'HU06424' => 'Kaposszerdahely',
	'HU06433' => 'Tiszadada',
	'HU06451' => 'Gamás',
	'HU06460' => 'Füzérkajata',
	'HU06479' => 'Lapáncsa',
	'HU06503' => 'Átány',
	'HU06512' => 'Kismányok',
	'HU06521' => 'Gyermely',
	'HU06530' => 'Pusztamagyaród',
	'HU06549' => 'Vindornyalak',
	'HU06558' => 'Bölcske',
	'HU06567' => 'Sormás',
	'HU06576' => 'Mezőszentgyörgy',
	'HU06585' => 'Gálosfa',
	'HU06594' => 'Dömös',
	'HU06600' => 'Somogyszentpál',
	'HU06619' => 'Börcs',
	'HU06637' => 'Varsád',
	'HU06646' => 'Jobaháza',
	'HU06655' => 'Hejőbába',
	'HU06664' => 'Ete',
	'HU06682' => 'Aka',
	'HU06707' => 'Borsodivánka',
	'HU06716' => 'Nádasd',
	'HU06725' => 'Borjád',
	'HU06734' => 'Csősz',
	'HU06743' => 'Diósjenő',
	'HU06761' => 'Nagyszékely',
	'HU06770' => 'Markotabödöge',
	'HU06789' => 'Kemse',
	'HU06798' => 'Hidas',
	'HU06804' => 'Kötegyán',
	'HU06813' => 'Mágocs',
	'HU06822' => 'Csobánka',
	'HU06831' => 'Kishajmás',
	'HU06840' => 'Sóskút',
	'HU06868' => 'Adorjás',
	'HU06877' => 'Visz',
	'HU06886' => 'Aranyosgadány',
	'HU06895' => 'Kópháza',
	'HU06901' => 'Tengelic',
	'HU06910' => 'Bélavár',
	'HU06938' => 'Vállaj',
	'HU06947' => 'Szokolya',
	'HU06956' => 'Fehértó',
	'HU06965' => 'Katádfa',
	'HU06974' => 'Cserépfalu',
	'HU06992' => 'Kővágótöttös',
	'HU07001' => 'Nagykarácsony',
	'HU07010' => 'Páprád',
	'HU07029' => 'Mucsi',
	'HU07038' => 'Lénárddaróc',
	'HU07047' => 'Baracs',
	'HU07056' => 'Öreglak',
	'HU07065' => 'Városlőd',
	'HU07074' => 'Vázsnok',
	'HU07083' => 'Tiszanána',
	'HU07092' => 'Szentbékkálla',
	'HU07108' => 'Tinnye',
	'HU07117' => 'Balatonföldvár',
	'HU07126' => 'Hetvehely',
	'HU07135' => 'Cserszegtomaj',
	'HU07153' => 'Palkonya',
	'HU07162' => 'Pácsony',
	'HU07171' => 'Sorkifalud',
	'HU07180' => 'Sarud',
	'HU07199' => 'Patak',
	'HU07205' => 'Újvárfalva',
	'HU07214' => 'Acsád',
	'HU07223' => 'Vadna',
	'HU07232' => 'Zalaszentlászló',
	'HU07250' => 'Hosztót',
	'HU07269' => 'Lepsény',
	'HU07278' => 'Püspökmolnári',
	'HU07287' => 'Bakonykoppány',
	'HU07296' => 'Bögöte',
	'HU07302' => 'Adásztevel',
	'HU07311' => 'Bokod',
	'HU07320' => 'Debercsény',
	'HU07339' => 'Aszófő',
	'HU07348' => 'Papkeszi',
	'HU07366' => 'Szárász',
	'HU07375' => 'Balatonkeresztúr',
	'HU07393' => 'Gerendás',
	'HU07418' => 'Kengyel',
	'HU07427' => 'Bazsi',
	'HU07436' => 'Parád',
	'HU07445' => 'Kocsord',
	'HU07463' => 'Mérk',
	'HU07472' => 'Berkesz',
	'HU07490' => 'Tószeg',
	'HU07506' => 'Lajoskomárom',
	'HU07515' => 'Domoszló',
	'HU07524' => 'Drágszél',
	'HU07533' => 'Bürüs',
	'HU07542' => 'Szentlőrinckáta',
	'HU07551' => 'Rádóckölked',
	'HU07560' => 'Garé',
	'HU07579' => 'Zalabaksa',
	'HU07588' => 'Felsőregmec',
	'HU07603' => 'Bánfa',
	'HU07612' => 'Dunavecse',
	'HU07621' => 'Alsótold',
	'HU07630' => 'Kömlőd',
	'HU07649' => 'Harka',
	'HU07658' => 'Nemeshetés',
	'HU07667' => 'Oszkó',
	'HU07676' => 'Gyulaháza',
	'HU07694' => 'Szőkéd',
	'HU07700' => 'Szepetnek',
	'HU07719' => 'Dámóc',
	'HU07728' => 'Kunbaracs',
	'HU07737' => 'Merenye',
	'HU07746' => 'Répcevis',
	'HU07755' => 'Óföldeák',
	'HU07764' => 'Kánó',
	'HU07773' => 'Dencsháza',
	'HU07782' => 'Döbröce',
	'HU07816' => 'Kisbodak',
	'HU07825' => 'Monok',
	'HU07834' => 'Derekegyház',
	'HU07843' => 'Jánkmajtis',
	'HU07852' => 'Tiszaszőlős',
	'HU07861' => 'Dunapataj',
	'HU07870' => 'Szigetcsép',
	'HU07889' => 'Szőlősardó',
	'HU07898' => 'Halimba',
	'HU07904' => 'Nyírcsaholy',
	'HU07913' => 'Nemesdéd',
	'HU07922' => 'Szentgál',
	'HU07931' => 'Kisapáti',
	'HU07940' => 'Viszák',
	'HU07959' => 'Szilaspogony',
	'HU07968' => 'Murarátka',
	'HU07977' => 'Ispánk',
	'HU07986' => 'Bucsuta',
	'HU07995' => 'Lövőpetri',
	'HU08004' => 'Hét',
	'HU08013' => 'Felsőjánosfa',
	'HU08022' => 'Bükkszentkereszt',
	'HU08040' => 'Csoma',
	'HU08059' => 'Nemesszentandrás',
	'HU08068' => 'Gellénháza',
	'HU08077' => 'Szendrő',
	'HU08086' => 'Ináncs',
	'HU08095' => 'Imrehegy',
	'HU08101' => 'Sárhida',
	'HU08110' => 'Kórós',
	'HU08138' => 'Várad',
	'HU08147' => 'Szászfa',
	'HU08156' => 'Drégelypalánk',
	'HU08165' => 'Tard',
	'HU08174' => 'Felsőberecki',
	'HU08183' => 'Vése',
	'HU08192' => 'Bordány',
	'HU08217' => 'Alsótelekes',
	'HU08226' => 'Hegyhátszentpéter',
	'HU08244' => 'Nagyszénás',
	'HU08253' => 'Klárafalva',
	'HU08262' => 'Nagygyimót',
	'HU08271' => 'Cák',
	'HU08280' => 'Telki',
	'HU08299' => 'Bakonya',
	'HU08305' => 'Bócsa',
	'HU08323' => 'Gyöngyöspata',
	'HU08332' => 'Táborfalva',
	'HU08341' => 'Okorvölgy',
	'HU08350' => 'Harkakötöny',
	'HU08369' => 'Vöckönd',
	'HU08378' => 'Jászszentlászló',
	'HU08387' => 'Nógrádsáp',
	'HU08396' => 'Boldva',
	'HU08402' => 'Regéc',
	'HU08411' => 'Kastélyosdombó',
	'HU08420' => 'Napkor',
	'HU08439' => 'Bánokszentgyörgy',
	'HU08448' => 'Értény',
	'HU08457' => 'Pilisszentlászló',
	'HU08466' => 'Beloiannisz',
	'HU08475' => 'Szajk',
	'HU08484' => 'Szentistvánbaksa',
	'HU08493' => 'Csenyéte',
	'HU08509' => 'Kishódos',
	'HU08527' => 'Sirok',
	'HU08536' => 'Szany',
	'HU08554' => 'Tiszakanyár',
	'HU08563' => 'Csapod',
	'HU08572' => 'Kétújfalu',
	'HU08581' => 'Baracska',
	'HU08590' => 'Tab',
	'HU08606' => 'Sikátor',
	'HU08615' => 'Szentliszló',
	'HU08624' => 'Bársonyos',
	'HU08633' => 'Tiszapalkonya',
	'HU08642' => 'Kálló',
	'HU08651' => 'Kisszentmárton',
	'HU08660' => 'Demjén',
	'HU08679' => 'Öregcsertő',
	'HU08688' => 'Süttő',
	'HU08697' => 'Bácsszentgyörgy',
	'HU08703' => 'Büssü',
	'HU08712' => 'Jobbágyi',
	'HU08721' => 'Győrasszonyfa',
	'HU08730' => 'Bakonycsernye',
	'HU08749' => 'Karakószörcsök',
	'HU08767' => 'Alsószenterzsébet',
	'HU08776' => 'Ajak',
	'HU08785' => 'Újsolt',
	'HU08794' => 'Tiszakóród',
	'HU08800' => 'Siklósnagyfalu',
	'HU08819' => 'Felsőszentmárton',
	'HU08837' => 'Háromfa',
	'HU08846' => 'Baskó',
	'HU08855' => 'Karancskeszi',
	'HU08873' => 'Apátistvánfalva',
	'HU08882' => 'Peresznye',
	'HU08907' => 'Nagykereki',
	'HU08916' => 'Magyarföld',
	'HU08925' => 'Adony',
	'HU08934' => 'Vámosoroszi',
	'HU08943' => 'Körösszegapáti',
	'HU08952' => 'Tiborszállás',
	'HU08961' => 'Őcsény',
	'HU08970' => 'Sajósenye',
	'HU08989' => 'Vámospércs',
	'HU08998' => 'Túrricse',
	'HU09007' => 'Szalatnak',
	'HU09016' => 'Monaj',
	'HU09025' => 'Őr',
	'HU09034' => 'Berkenye',
	'HU09043' => 'Szente',
	'HU09052' => 'Tarnaszentmária',
	'HU09061' => 'Rápolt',
	'HU09070' => 'Csénye',
	'HU09089' => 'Gelsesziget',
	'HU09098' => 'Kaposfő',
	'HU09104' => 'Vácszentlászló',
	'HU09113' => 'Tiszaeszlár',
	'HU09122' => 'Farmos',
	'HU09140' => 'Lórév',
	'HU09159' => 'Drávakeresztúr',
	'HU09168' => 'Belezna',
	'HU09177' => 'Gige',
	'HU09186' => 'Dunaszekcső',
	'HU09195' => 'Vásárosmiske',
	'HU09201' => 'Detk',
	'HU09210' => 'Földeák',
	'HU09229' => 'Tokorcs',
	'HU09238' => 'Nyírgyulaj',
	'HU09256' => 'Nyírtét',
	'HU09274' => 'Varászló',
	'HU09283' => 'Nagygeresd',
	'HU09292' => 'Gecse',
	'HU09308' => 'Szemely',
	'HU09317' => 'Révleányvár',
	'HU09326' => 'Jágónak',
	'HU09353' => 'Aranyosapáti',
	'HU09362' => 'Aggtelek',
	'HU09371' => 'Pálfa',
	'HU09380' => 'Zalaújlak',
	'HU09399' => 'Hernádcéce',
	'HU09405' => 'Tápióság',
	'HU09414' => 'Várdomb',
	'HU09423' => 'Tiszaadony',
	'HU09432' => 'Ecsegfalva',
	'HU09441' => 'Gomba',
	'HU09450' => 'Márfa',
	'HU09478' => 'Nagyhegyes',
	'HU09487' => 'Fertőendréd',
	'HU09502' => 'Vid',
	'HU09511' => 'Gádoros',
	'HU09520' => 'Gyulakeszi',
	'HU09539' => 'Dunaszentgyörgy',
	'HU09548' => 'Kisvaszar',
	'HU09557' => 'Tomajmonostora',
	'HU09575' => 'Kerkaszentkirály',
	'HU09609' => 'Recsk',
	'HU09618' => 'Pári',
	'HU09627' => 'Tiszatenyő',
	'HU09636' => 'Görcsönydoboka',
	'HU09645' => 'Vörs',
	'HU09654' => 'Ilk',
	'HU09663' => 'Babarcszőlős',
	'HU09672' => 'Nemesrempehollós',
	'HU09681' => 'Cégénydányád',
	'HU09706' => 'Gömörszőlős',
	'HU09715' => 'Császló',
	'HU09724' => 'Győrvár',
	'HU09733' => 'Vigántpetend',
	'HU09742' => 'Felsődobsza',
	'HU09751' => 'Kisszekeres',
	'HU09779' => 'Csór',
	'HU09788' => 'Sárfimizdó',
	'HU09797' => 'Nézsa',
	'HU09803' => 'Szentkatalin',
	'HU09812' => 'Kisgörbő',
	'HU09830' => 'Szemere',
	'HU09849' => 'Hernád',
	'HU09858' => 'Komlósd',
	'HU09867' => 'Pölöske',
	'HU09876' => 'Chernelházadamonya',
	'HU09885' => 'Fertőd',
	'HU09894' => 'Borsosberény',
	'HU09900' => 'Rácalmás',
	'HU09919' => 'Tuzsér',
	'HU09928' => 'Hetes',
	'HU09937' => 'Kenyeri',
	'HU09946' => 'Hencse',
	'HU09955' => 'Kövegy',
	'HU09964' => 'Tófalu',
	'HU09982' => 'Szűcsi',
	'HU10001' => 'Nagydém',
	'HU10010' => 'Lulla',
	'HU10029' => 'Hövej',
	'HU10038' => 'Liptód',
	'HU10047' => 'Csáfordjánosfa',
	'HU10056' => 'Borsfa',
	'HU10065' => 'Szentimrefalva',
	'HU10074' => 'Istenmezeje',
	'HU10083' => 'Szakcs',
	'HU10092' => 'Örvényes',
	'HU10108' => 'Áporka',
	'HU10117' => 'Újkenéz',
	'HU10126' => 'Győrtelek',
	'HU10135' => 'Palotabozsok',
	'HU10144' => 'Varbóc',
	'HU10153' => 'Torvaj',
	'HU10171' => 'Sajógalgóc',
	'HU10180' => 'Bácsbokod',
	'HU10199' => 'Szarvasgede',
	'HU10205' => 'Tiszarád',
	'HU10223' => 'Szalafő',
	'HU10232' => 'Egyházashetye',
	'HU10241' => 'Hevesaranyos',
	'HU10250' => 'Farkasgyepű',
	'HU10269' => 'Hahót',
	'HU10287' => 'Kondoros',
	'HU10302' => 'Vasboldogasszony',
	'HU10311' => 'Pusztacsó',
	'HU10339' => 'Ásotthalom',
	'HU10348' => 'Zalakomár',
	'HU10357' => 'Abod',
	'HU10366' => 'Füzérradvány',
	'HU10375' => 'Tornakápolna',
	'HU10384' => 'Bejcgyertyános',
	'HU10409' => 'Németbánya',
	'HU10418' => 'Nagyút',
	'HU10427' => 'Magyaratád',
	'HU10436' => 'Szamossályi',
	'HU10445' => 'Egyházaskesző',
	'HU10454' => 'Dunasziget',
	'HU10463' => 'Kölesd',
	'HU10472' => 'Császártöltés',
	'HU10506' => 'Bodrog',
	'HU10515' => 'Maroslele',
	'HU10524' => 'Detek',
	'HU10533' => 'Dávod',
	'HU10542' => 'Kémes',
	'HU10560' => 'Bezi',
	'HU10579' => 'Sajtoskál',
	'HU10588' => 'Beled',
	'HU10597' => 'Rum',
	'HU10603' => 'Csurgónagymarton',
	'HU10612' => 'Komjáti',
	'HU10621' => 'Bükkszenterzsébet',
	'HU10630' => 'Őriszentpéter',
	'HU10649' => 'Csertalakos',
	'HU10658' => 'Fertőhomok',
	'HU10667' => 'Városföld',
	'HU10676' => 'Halogy',
	'HU10685' => 'Vállus',
	'HU10694' => 'Bogdása',
	'HU10737' => 'Vámosmikola',
	'HU10746' => 'Kistótfalu',
	'HU10755' => 'Majosháza',
	'HU10764' => 'Körösnagyharsány',
	'HU10773' => 'Tiszabő',
	'HU10782' => 'Boncodfölde',
	'HU10791' => 'Fülesd',
	'HU10807' => 'Nyírparasznya',
	'HU10825' => 'Pécsvárad',
	'HU10834' => 'Olcsvaapáti',
	'HU10843' => 'Nick',
	'HU10852' => 'Érpatak',
	'HU10861' => 'Ecseny',
	'HU10870' => 'Doba',
	'HU10889' => 'Lispeszentadorján',
	'HU10904' => 'Garadna',
	'HU10913' => 'Karakó',
	'HU10931' => 'Hagyárosbörönd',
	'HU10940' => 'Nagykozár',
	'HU10959' => 'Nikla',
	'HU10968' => 'Mogyoróska',
	'HU10977' => 'Tiszavalk',
	'HU10986' => 'Szulok',
	'HU10995' => 'Kerékteleki',
	'HU11004' => 'Jászkarajenő',
	'HU11013' => 'Szihalom',
	'HU11022' => 'Zsujta',
	'HU11031' => 'Tolnanémedi',
	'HU11040' => 'Lakócsa',
	'HU11059' => 'Baglad',
	'HU11068' => 'Röjtökmuzsaj',
	'HU11086' => 'Cún',
	'HU11095' => 'Nyírlövő',
	'HU11101' => 'Szőlősgyörök',
	'HU11110' => 'Szuhakálló',
	'HU11129' => 'Olcsva',
	'HU11138' => 'Vekerd',
	'HU11147' => 'Kisrákos',
	'HU11156' => 'Gór',
	'HU11165' => 'Szentpéterúr',
	'HU11174' => 'Kéthely',
	'HU11183' => 'Kisdér',
	'HU11192' => 'Igal',
	'HU11208' => 'Hosszúvölgy',
	'HU11217' => 'Szűr',
	'HU11226' => 'Hangács',
	'HU11235' => 'Kőtelek',
	'HU11244' => 'Pócspetri',
	'HU11253' => 'Fertőboz',
	'HU11262' => 'Kóny',
	'HU11271' => 'Nyírlugos',
	'HU11280' => 'Katymár',
	'HU11299' => 'Bököny',
	'HU11305' => 'Besenyszög',
	'HU11323' => 'Mezőkeresztes',
	'HU11332' => 'Sajónémeti',
	'HU11350' => 'Damak',
	'HU11369' => 'Szakony',
	'HU11378' => 'Füzérkomlós',
	'HU11387' => 'Ikervár',
	'HU11402' => 'Mecsekpölöske',
	'HU11411' => 'Halmajugra',
	'HU11420' => 'Pula',
	'HU11448' => 'Kisrozvágy',
	'HU11457' => 'Tényő',
	'HU11466' => 'Zala',
	'HU11475' => 'Lendvajakabfa',
	'HU11484' => 'Somogycsicsó',
	'HU11493' => 'Szinpetri',
	'HU11509' => 'Szenta',
	'HU11518' => 'Rádfalva',
	'HU11527' => 'Balaton',
	'HU11536' => 'Magyardombegyház',
	'HU11545' => 'Szentjakabfa',
	'HU11554' => 'Szécsisziget',
	'HU11563' => 'Alsónyék',
	'HU11572' => 'Petőmihályfa',
	'HU11581' => 'Vilmány',
	'HU11590' => 'Piliny',
	'HU11606' => 'Dunaszentbenedek',
	'HU11615' => 'Körösladány',
	'HU11624' => 'Bodmér',
	'HU11633' => 'Vasszentmihály',
	'HU11651' => 'Bögöt',
	'HU11660' => 'Legyesbénye',
	'HU11679' => 'Jánosháza',
	'HU11688' => 'Diósberény',
	'HU11697' => 'Hidasnémeti',
	'HU11703' => 'Vöröstó',
	'HU11712' => 'Báta',
	'HU11730' => 'Orfű',
	'HU11749' => 'Mezőnyárád',
	'HU11758' => 'Meszes',
	'HU11776' => 'Sárszentmihály',
	'HU11785' => 'Zalakaros',
	'HU11794' => 'Szank',
	'HU11800' => 'Vindornyaszőlős',
	'HU11828' => 'Porrog',
	'HU11837' => 'Pocsaj',
	'HU11846' => 'Kétbodony',
	'HU11855' => 'Pápakovácsi',
	'HU11864' => 'Érsekcsanád',
	'HU11873' => 'Mezőhegyes',
	'HU11882' => 'Abda',
	'HU11891' => 'Héreg',
	'HU11907' => 'Tiszamogyorós',
	'HU11916' => 'Balatonőszöd',
	'HU11925' => 'Újtikos',
	'HU11943' => 'Gyöngyösfalu',
	'HU11952' => 'Dinnyeberki',
	'HU11961' => 'Bátya',
	'HU11970' => 'Bikács',
	'HU11989' => 'Murony',
	'HU11998' => 'Csibrák',
	'HU12007' => 'Szatymaz',
	'HU12016' => 'Becske',
	'HU12025' => 'Csólyospálos',
	'HU12034' => 'Kelemér',
	'HU12043' => 'Ölbő',
	'HU12061' => 'Hermánszeg',
	'HU12070' => 'Pétervására',
	'HU12089' => 'Gelse',
	'HU12098' => 'Nyírtura',
	'HU12104' => 'Vasszilvágy',
	'HU12113' => 'Kajárpéc',
	'HU12122' => 'Letenye',
	'HU12131' => 'Nógrádmegyer',
	'HU12140' => 'Csepreg',
	'HU12159' => 'Hejőszalonta',
	'HU12168' => 'Patca',
	'HU12177' => 'Kardoskút',
	'HU12186' => 'Pátroha',
	'HU12195' => 'Romhány',
	'HU12201' => 'Zók',
	'HU12210' => 'Tállya',
	'HU12229' => 'Terpes',
	'HU12238' => 'Balatonederics',
	'HU12247' => 'Kemenesmagasi',
	'HU12265' => 'Székkutas',
	'HU12283' => 'Máriakálnok',
	'HU12292' => 'Zsennye',
	'HU12308' => 'Hédervár',
	'HU12317' => 'Andrásfa',
	'HU12326' => 'Györköny',
	'HU12335' => 'Tompaládony',
	'HU12344' => 'Csengőd',
	'HU12353' => 'Kistamási',
	'HU12362' => 'Pálháza',
	'HU12371' => 'Pamlény',
	'HU12380' => 'Drávapiski',
	'HU12399' => 'Kistokaj',
	'HU12405' => 'Vámosszabadi',
	'HU12414' => 'Fertőrákos',
	'HU12423' => 'Rákócziújfalu',
	'HU12432' => 'Fedémes',
	'HU12441' => 'Abádszalók',
	'HU12450' => 'Csökmő',
	'HU12469' => 'Rátka',
	'HU12478' => 'Kemenesszentpéter',
	'HU12487' => 'Újcsanálos',
	'HU12496' => 'Zalaistvánd',
	'HU12502' => 'Kisnána',
	'HU12511' => 'Dejtár',
	'HU12520' => 'Ságújfalu',
	'HU12539' => 'Gyűrűs',
	'HU12548' => 'Abaliget',
	'HU12557' => 'Fancsal',
	'HU12566' => 'Dunafalva',
	'HU12593' => 'Tiszadob',
	'HU12609' => 'Türje',
	'HU12618' => 'Kertészsziget',
	'HU12627' => 'Sokorópátka',
	'HU12636' => 'Kisapostag',
	'HU12645' => 'Óbánya',
	'HU12654' => 'Zalahaláp',
	'HU12663' => 'Kaposkeresztúr',
	'HU12672' => 'Kisvarsány',
	'HU12681' => 'Telekgerendás',
	'HU12706' => 'Háromhuta',
	'HU12715' => 'Pázmándfalu',
	'HU12724' => 'Csehimindszent',
	'HU12733' => 'Horvátlövő',
	'HU12742' => 'Ganna',
	'HU12751' => 'Gerde',
	'HU12760' => 'Nagybakónak',
	'HU12779' => 'Nagylak',
	'HU12797' => 'Ópusztaszer',
	'HU12812' => 'Mezőörs',
	'HU12821' => 'Egerbakta',
	'HU12830' => 'Bezeréd',
	'HU12849' => 'Kisjakabfalva',
	'HU12858' => 'Nagyhajmás',
	'HU12867' => 'Pereked',
	'HU12876' => 'Somogymeggyes',
	'HU12900' => 'Köröstarcsa',
	'HU12928' => 'Csaholc',
	'HU12937' => 'Hercegszántó',
	'HU12946' => 'Garabonc',
	'HU12964' => 'Püski',
	'HU12973' => 'Szentgáloskér',
	'HU12982' => 'Vilyvitány',
	'HU12991' => 'Galambok',
	'HU13000' => 'Gemzse',
	'HU13019' => 'Hodász',
	'HU13028' => 'Kondorfa',
	'HU13037' => 'Zsurk',
	'HU13046' => 'Szamosszeg',
	'HU13055' => 'Kissziget',
	'HU13064' => 'Magyarszerdahely',
	'HU13082' => 'Kozmadombja',
	'HU13091' => 'Zalaszentmárton',
	'HU13116' => 'Boldogasszonyfa',
	'HU13125' => 'Takácsi',
	'HU13134' => 'Golop',
	'HU13143' => 'Jéke',
	'HU13152' => 'Cece',
	'HU13161' => 'Röszke',
	'HU13170' => 'Csépa',
	'HU13198' => 'Győrladamér',
	'HU13204' => 'Hont',
	'HU13213' => 'Tunyogmatolcs',
	'HU13222' => 'Mihálygerge',
	'HU13231' => 'Szentdomonkos',
	'HU13240' => 'Tarnalelesz',
	'HU13259' => 'Szabadegyháza',
	'HU13268' => 'Sóstófalva',
	'HU13286' => 'Felsőegerszeg',
	'HU13295' => 'Galgagyörk',
	'HU13301' => 'Zalaszentlőrinc',
	'HU13310' => 'Bicsérd',
	'HU13329' => 'Almamellék',
	'HU13338' => 'Gyöngyösoroszi',
	'HU13347' => 'Gerényes',
	'HU13356' => 'Égerszög',
	'HU13365' => 'Botykapeterd',
	'HU13374' => 'Kázsmárk',
	'HU13383' => 'Domaszék',
	'HU13408' => 'Ballószög',
	'HU13426' => 'Kemenesmihályfa',
	'HU13444' => 'Mecseknádasd',
	'HU13453' => 'Őrimagyarósd',
	'HU13471' => 'Bucsa',
	'HU13499' => 'Erzsébet',
	'HU13505' => 'Csikvánd',
	'HU13514' => 'Jászszentandrás',
	'HU13523' => 'Szúcs',
	'HU13541' => 'Tiszaszalka',
	'HU13550' => 'Nyírtelek',
	'HU13569' => 'Gosztola',
	'HU13587' => 'Felsőcsatár',
	'HU13596' => 'Bükkábrány',
	'HU13602' => 'Túristvándi',
	'HU13611' => 'Drávagárdony',
	'HU13620' => 'Mucsfa',
	'HU13639' => 'Besenyőd',
	'HU13648' => 'Egerszólát',
	'HU13666' => 'Királyhegyes',
	'HU13675' => 'Tengeri',
	'HU13684' => 'Perenye',
	'HU13693' => 'Táska',
	'HU13709' => 'Nagyszokoly',
	'HU13718' => 'Horpács',
	'HU13727' => 'Gacsály',
	'HU13736' => 'Zalavár',
	'HU13745' => 'Kőkút',
	'HU13754' => 'Szanda',
	'HU13763' => 'Telkibánya',
	'HU13772' => 'Sáska',
	'HU13781' => 'Kiskorpád',
	'HU13790' => 'Polány',
	'HU13806' => 'Kömpöc',
	'HU13824' => 'Somodor',
	'HU13842' => 'Kozárd',
	'HU13851' => 'Csertő',
	'HU13879' => 'Ivád',
	'HU13888' => 'Tiszakeszi',
	'HU13897' => 'Vértesboglár',
	'HU13903' => 'Nádasdladány',
	'HU13912' => 'Magyarkeresztúr',
	'HU13921' => 'Iklódbördőce',
	'HU13930' => 'Porrogszentkirály',
	'HU13958' => 'Ják',
	'HU13976' => 'Tiszakarád',
	'HU13985' => 'Felsőmocsolád',
	'HU13994' => 'Bolhás',
	'HU14003' => 'Nyíracsád',
	'HU14012' => 'Őrtilos',
	'HU14021' => 'Lukácsháza',
	'HU14030' => 'Nagymányok',
	'HU14058' => 'Fülöpszállás',
	'HU14067' => 'Pápoc',
	'HU14076' => 'Tenk',
	'HU14085' => 'Sénye',
	'HU14094' => 'Tiszaug',
	'HU14100' => 'Kajdacs',
	'HU14119' => 'Bezedek',
	'HU14128' => 'Tarnaörs',
	'HU14137' => 'Bojt',
	'HU14146' => 'Tápiószele',
	'HU14164' => 'Harc',
	'HU14182' => 'Várvölgy',
	'HU14191' => 'Nagyváty',
	'HU14207' => 'Rákóczifalva',
	'HU14225' => 'Szentmargitfalva',
	'HU14234' => 'Buják',
	'HU14243' => 'Somlóvecse',
	'HU14252' => 'Apátfalva',
	'HU14261' => 'Táp',
	'HU14270' => 'Káptalanfa',
	'HU14289' => 'Csokvaomány',
	'HU14298' => 'Ramocsa',
	'HU14304' => 'Závod',
	'HU14313' => 'Sajókaza',
	'HU14322' => 'Vaspör',
	'HU14359' => 'Kékcse',
	'HU14368' => 'Bosta',
	'HU14377' => 'Fülpösdaróc',
	'HU14386' => 'Kercseliget',
	'HU14395' => 'Bakháza',
	'HU14401' => 'Bodrogolaszi',
	'HU14410' => 'Kübekháza',
	'HU14429' => 'Alsógagy',
	'HU14438' => 'Répceszemere',
	'HU14447' => 'Tiszatelek',
	'HU14465' => 'Tabajd',
	'HU14474' => 'Boldogkőváralja',
	'HU14483' => 'Máriakéménd',
	'HU14508' => 'Dombrád',
	'HU14517' => 'Kovácsszénája',
	'HU14535' => 'Kömlő',
	'HU14544' => 'Tataháza',
	'HU14553' => 'Kapolcs',
	'HU14562' => 'Balatonmáriafürdő',
	'HU14571' => 'Tápiószentmárton',
	'HU14580' => 'Vámosgyörk',
	'HU14599' => 'Görgeteg',
	'HU14605' => 'Lápafő',
	'HU14614' => 'Ebes',
	'HU14623' => 'Zákány',
	'HU14632' => 'Fonyód',
	'HU14641' => 'Márkháza',
	'HU14650' => 'Nagynyárád',
	'HU14669' => 'Pilismarót',
	'HU14678' => 'Darvas',
	'HU14687' => 'Pinnye',
	'HU14696' => 'Nyíribrony',
	'HU14702' => 'Kissikátor',
	'HU14711' => 'Szálka',
	'HU14720' => 'Pálfiszeg',
	'HU14739' => 'Rakamaz',
	'HU14748' => 'Kimle',
	'HU14757' => 'Noszlop',
	'HU14766' => 'Dunatetétlen',
	'HU14775' => 'Nagybörzsöny',
	'HU14784' => 'Tardona',
	'HU14793' => 'Rábakecöl',
	'HU14809' => 'Mersevát',
	'HU14818' => 'Bonyhádvarasd',
	'HU14836' => 'Zagyvarékas',
	'HU14854' => 'Szabadi',
	'HU14863' => 'Látrány',
	'HU14872' => 'Mátraderecske',
	'HU14881' => 'Sóshartyán',
	'HU14890' => 'Tomor',
	'HU14906' => 'Sármellék',
	'HU14915' => 'Mályinka',
	'HU14924' => 'Újszentiván',
	'HU14933' => 'Bodony',
	'HU14942' => 'Ságvár',
	'HU14951' => 'Sukoró',
	'HU14960' => 'Zebegény',
	'HU14979' => 'Nagyrécse',
	'HU14988' => 'Pecöl',
	'HU14997' => 'Hegyháthodász',
	'HU15006' => 'Németkér',
	'HU15015' => 'Tápióbicske',
	'HU15033' => 'Enese',
	'HU15042' => 'Babót',
	'HU15051' => 'Matty',
	'HU15060' => 'Nagymizdó',
	'HU15079' => 'Szabadszentkirály',
	'HU15088' => 'Hetyefő',
	'HU15097' => 'Baktüttös',
	'HU15103' => 'Szenna',
	'HU15112' => 'Kerkafalva',
	'HU15121' => 'Osli',
	'HU15149' => 'Vámosújfalu',
	'HU15158' => 'Zsana',
	'HU15167' => 'Bakonszeg',
	'HU15176' => 'Alcsútdoboz',
	'HU15185' => 'Szigetszentmárton',
	'HU15194' => 'Szólád',
	'HU15219' => 'Marócsa',
	'HU15228' => 'Győrzámoly',
	'HU15237' => 'Egyházasfalu',
	'HU15246' => 'Pusztamonostor',
	'HU15264' => 'Kéked',
	'HU15273' => 'Rábaszentandrás',
	'HU15282' => 'Vértessomló',
	'HU15316' => 'Szakadát',
	'HU15325' => 'Szátok',
	'HU15334' => 'Vasegerszeg',
	'HU15343' => 'Fertőszentmiklós',
	'HU15361' => 'Hajmáskér',
	'HU15370' => 'Etes',
	'HU15389' => 'Pécsdevecser',
	'HU15398' => 'Pirtó',
	'HU15404' => 'Szulimán',
	'HU15413' => 'Pusztaradvány',
	'HU15422' => 'Rábatamási',
	'HU15431' => 'Petőfiszállás',
	'HU15459' => 'Regöly',
	'HU15468' => 'Nagyhuta',
	'HU15477' => 'Kismarja',
	'HU15486' => 'Kiszsidány',
	'HU15495' => 'Basal',
	'HU15501' => 'Bősárkány',
	'HU15510' => 'Kőröshegy',
	'HU15529' => 'Pér',
	'HU15538' => 'Kővágószőlős',
	'HU15547' => 'Pénzesgyőr',
	'HU15556' => 'Sand',
	'HU15565' => 'Balatonudvari',
	'HU15574' => 'Nagykörű',
	'HU15583' => 'Pusztazámor',
	'HU15592' => 'Patosfa',
	'HU15608' => 'Gesztely',
	'HU15617' => 'Zalkod',
	'HU15626' => 'Somogysámson',
	'HU15635' => 'Tarrós',
	'HU15644' => 'Tiszacsege',
	'HU15653' => 'Győrszemere',
	'HU15662' => 'Abaújalpár',
	'HU15671' => 'Pósfa',
	'HU15680' => 'Jósvafő',
	'HU15699' => 'Csikéria',
	'HU15705' => 'Vilonya',
	'HU15714' => 'Szárföld',
	'HU15723' => 'Mesteri',
	'HU15732' => 'Kaposújlak',
	'HU15741' => 'Egyek',
	'HU15750' => 'Gánt',
	'HU15769' => 'Esztergályhorváti',
	'HU15778' => 'Barnag',
	'HU15787' => 'Tiszaörs',
	'HU15796' => 'Ludas',
	'HU15802' => 'Nyírbéltek',
	'HU15811' => 'Jászboldogháza',
	'HU15820' => 'Felsőnána',
	'HU15839' => 'Hernádbűd',
	'HU15848' => 'Zengővárkony',
	'HU15857' => 'Lak',
	'HU15875' => 'Dunaszentpál',
	'HU15884' => 'Drávatamási',
	'HU15893' => 'Pácin',
	'HU15909' => 'Nágocs',
	'HU15918' => 'Gyúró',
	'HU15927' => 'Jákó',
	'HU15936' => 'Gönc',
	'HU15945' => 'Sajómercse',
	'HU15954' => 'Cirák',
	'HU15963' => 'Balsa',
	'HU15972' => 'Jenő',
	'HU15981' => 'Somogydöröcske',
	'HU15990' => 'Daraboshegy',
	'HU16009' => 'Dötk',
	'HU16018' => 'Mélykút',
	'HU16027' => 'Monyoród',
	'HU16036' => 'Kisnamény',
	'HU16045' => 'Kunágota',
	'HU16063' => 'Szajla',
	'HU16072' => 'Csajág',
	'HU16081' => 'Kispáli',
	'HU16090' => 'Atkár',
	'HU16106' => 'Mesztegnyő',
	'HU16115' => 'Pellérd',
	'HU16124' => 'Borsodgeszt',
	'HU16133' => 'Rakacaszend',
	'HU16142' => 'Külsővat',
	'HU16151' => 'Dozmat',
	'HU16160' => 'Tarnaszentmiklós',
	'HU16179' => 'Szögliget',
	'HU16197' => 'Ambrózfalva',
	'HU16203' => 'Záhony',
	'HU16212' => 'Tanakajd',
	'HU16221' => 'Lipót',
	'HU16230' => 'Tiszaderzs',
	'HU16249' => 'Kiscsehi',
	'HU16258' => 'Lad',
	'HU16267' => 'Szentkirályszabadja',
	'HU16276' => 'Ordas',
	'HU16285' => 'Mindszentgodisa',
	'HU16294' => 'Uszód',
	'HU16300' => 'Szamoskér',
	'HU16319' => 'Völcsej',
	'HU16328' => 'Felsőtárkány',
	'HU16346' => 'Besnyő',
	'HU16355' => 'Szentlászló',
	'HU16364' => 'Kisvásárhely',
	'HU16373' => 'Csávoly',
	'HU16382' => 'Tótszentmárton',
	'HU16391' => 'Nagybárkány',
	'HU16407' => 'Tótújfalu',
	'HU16416' => 'Császár',
	'HU16425' => 'Alsópetény',
	'HU16443' => 'Markóc',
	'HU16452' => 'Nagyvejke',
	'HU16461' => 'Berkesd',
	'HU16470' => 'Balatonújlak',
	'HU16489' => 'Szápár',
	'HU16498' => 'Egyházasharaszti',
	'HU16504' => 'Szaknyér',
	'HU16513' => 'Nagyrada',
	'HU16522' => 'Nyírvasvári',
	'HU16531' => 'Fűzvölgy',
	'HU16540' => 'Markaz',
	'HU16559' => 'Komlóska',
	'HU16568' => 'Görbeháza',
	'HU16577' => 'Imola',
	'HU16595' => 'Oroszi',
	'HU16601' => 'Balatonszabadi',
	'HU16610' => 'Egercsehi',
	'HU16629' => 'Magy',
	'HU16656' => 'Vászoly',
	'HU16665' => 'Kölcse',
	'HU16674' => 'Töltéstava',
	'HU16683' => 'Káloz',
	'HU16692' => 'Szőc',
	'HU16717' => 'Gic',
	'HU16726' => 'Hedrehely',
	'HU16735' => 'Tarany',
	'HU16744' => 'Bajna',
	'HU16753' => 'Szalonna',
	'HU16762' => 'Váncsod',
	'HU16771' => 'Székelyszabar',
	'HU16780' => 'Hejőpapi',
	'HU16799' => 'Borsodszirák',
	'HU16805' => 'Kékesd',
	'HU16814' => 'Szedres',
	'HU16823' => 'Ordacsehi',
	'HU16841' => 'Csány',
	'HU16850' => 'Pórszombat',
	'HU16869' => 'Zsebeháza',
	'HU16878' => 'Hugyag',
	'HU16887' => 'Horvátzsidány',
	'HU16896' => 'Zalaigrice',
	'HU16902' => 'Tornabarakony',
	'HU16911' => 'Kemeneskápolna',
	'HU16920' => 'Pusztaapáti',
	'HU16939' => 'Orgovány',
	'HU16948' => 'Mátyásdomb',
	'HU16957' => 'Tornyospálca',
	'HU16966' => 'Tiszasziget',
	'HU16975' => 'Kisherend',
	'HU16984' => 'Szellő',
	'HU16993' => 'Furta',
	'HU17002' => 'Balatongyörök',
	'HU17020' => 'Bajánsenye',
	'HU17039' => 'Tagyon',
	'HU17048' => 'Pusztafalu',
	'HU17057' => 'Zalavég',
	'HU17066' => 'Keresztéte',
	'HU17075' => 'Jánd',
	'HU17084' => 'Penészlek',
	'HU17093' => 'Orfalu',
	'HU17109' => 'Füzér',
	'HU17118' => 'Resznek',
	'HU17127' => 'Beleg',
	'HU17136' => 'Hernádszentandrás',
	'HU17145' => 'Kenderes',
	'HU17154' => 'Balatonszepezd',
	'HU17163' => 'Tarnazsadány',
	'HU17172' => 'Dabronc',
	'HU17181' => 'Ecséd',
	'HU17190' => 'Helesfa',
	'HU17215' => 'Porcsalma',
	'HU17224' => 'Petneháza',
	'HU17233' => 'Nagymágocs',
	'HU17242' => 'Pogány',
	'HU17251' => 'Várgesztes',
	'HU17279' => 'Juta',
	'HU17288' => 'Magyarszecsőd',
	'HU17297' => 'Rábaszentmiklós',
	'HU17303' => 'Tápiógyörgye',
	'HU17321' => 'Taliándörögd',
	'HU17349' => 'Kiscsécs',
	'HU17358' => 'Buzsák',
	'HU17367' => 'Nárai',
	'HU17376' => 'Aba',
	'HU17385' => 'Alsómocsolád',
	'HU17394' => 'Geszt',
	'HU17400' => 'Zalaapáti',
	'HU17419' => 'Drávafok',
	'HU17428' => 'Rozsály',
	'HU17437' => 'Jásd',
	'HU17446' => 'Kelevíz',
	'HU17455' => 'Kokad',
	'HU17464' => 'Kásád',
	'HU17473' => 'Hajdúszovát',
	'HU17482' => 'Újbarok',
	'HU17491' => 'Zselicszentpál',
	'HU17507' => 'Románd',
	'HU17516' => 'Gáborjánháza',
	'HU17534' => 'Gyöngyöshalász',
	'HU17543' => 'Bocfölde',
	'HU17552' => 'Mezőfalva',
	'HU17561' => 'Nemesvid',
	'HU17570' => 'Lesencefalu',
	'HU17589' => 'Jármi',
	'HU17598' => 'Valkó',
	'HU17604' => 'Liget',
	'HU17613' => 'Gombosszeg',
	'HU17622' => 'Úrhida',
	'HU17640' => 'Keszőhidegkút',
	'HU17659' => 'Egyházasdengeleg',
	'HU17686' => 'Ágasegyháza',
	'HU17695' => 'Tiszasüly',
	'HU17710' => 'Kisdorog',
	'HU17729' => 'Szarvaskend',
	'HU17738' => 'Igar',
	'HU17747' => 'Zádor',
	'HU17765' => 'Zsombó',
	'HU17774' => 'Pusztavám',
	'HU17783' => 'Mogyoród',
	'HU17792' => 'Patapoklosi',
	'HU17808' => 'Újszilvás',
	'HU17817' => 'Tiszabecs',
	'HU17826' => 'Mándok',
	'HU17835' => 'Fazekasboda',
	'HU17844' => 'Tikos',
	'HU17853' => 'Szilvágy',
	'HU17862' => 'Pusztaberki',
	'HU17871' => 'Lesencetomaj',
	'HU17880' => 'Vásárosfalu',
	'HU17899' => 'Kölked',
	'HU17905' => 'Hegyeshalom',
	'HU17914' => 'Felsőnyék',
	'HU17923' => 'Jakabszállás',
	'HU17932' => 'Fony',
	'HU17950' => 'Fürged',
	'HU17969' => 'Gyalóka',
	'HU17978' => 'Jászdózsa',
	'HU17987' => 'Andornaktálya',
	'HU17996' => 'Rábatöttös',
	'HU18005' => 'Szamosangyalos',
	'HU18023' => 'Nemesrádó',
	'HU18032' => 'Hegyhátszentjakab',
	'HU18041' => 'Karmacs',
	'HU18050' => 'Sámod',
	'HU18078' => 'Somogyfajsz',
	'HU18096' => 'Zalaszentjakab',
	'HU18111' => 'Nagycsány',
	'HU18120' => 'Bolhó',
	'HU18139' => 'Ácsteszér',
	'HU18148' => 'Kötcse',
	'HU18166' => 'Kéleshalom',
	'HU18175' => 'Gáborján',
	'HU18184' => 'Baktakék',
	'HU18193' => 'Gógánfa',
	'HU18218' => 'Soltszentimre',
	'HU18227' => 'Kaposmérő',
	'HU18236' => 'Nemeske',
	'HU18245' => 'Taktaharkány',
	'HU18254' => 'Bodajk',
	'HU18263' => 'Szárazd',
	'HU18272' => 'Csép',
	'HU18281' => 'Kisköre',
	'HU18290' => 'Nyírkarász',
	'HU18306' => 'Tokaj',
	'HU18315' => 'Gyód',
	'HU18333' => 'Gilvánfa',
	'HU18351' => 'Uppony',
	'HU18360' => 'Becsvölgye',
	'HU18379' => 'Mezőnagymihály',
	'HU18388' => 'Nagydorog',
	'HU18397' => 'Dány',
	'HU18403' => 'Hegykő',
	'HU18412' => 'Várbalog',
	'HU18430' => 'Velemér',
	'HU18449' => 'Zalaszentmihály',
	'HU18458' => 'Harta',
	'HU18467' => 'Berekböszörmény',
	'HU18476' => 'Csévharaszt',
	'HU18494' => 'Garáb',
	'HU18519' => 'Vejti',
	'HU18528' => 'Eperjeske',
	'HU18537' => 'Sajópálfala',
	'HU18546' => 'Somogyszob',
	'HU18555' => 'Olasz',
	'HU18564' => 'Zalaszentbalázs',
	'HU18573' => 'Acsa',
	'HU18582' => 'Túrony',
	'HU18591' => 'Vaja',
	'HU18607' => 'Szegerdő',
	'HU18625' => 'Karancsalja',
	'HU18634' => 'Hács',
	'HU18643' => 'Göncruszka',
	'HU18652' => 'Szentgyörgyvölgy',
	'HU18661' => 'Ózdfalu',
	'HU18670' => 'Páhi',
	'HU18689' => 'Penc',
	'HU18698' => 'Bázakerettye',
	'HU18704' => 'Erdősmecske',
	'HU18722' => 'Kupa',
	'HU18731' => 'Pilisszentkereszt',
	'HU18740' => 'Szabadhídvég',
	'HU18759' => 'Hajós',
	'HU18768' => 'Zalaköveskút',
	'HU18777' => 'Bernecebaráti',
	'HU18786' => 'Szügy',
	'HU18795' => 'Darnó',
	'HU18801' => 'Tornanádaska',
	'HU18810' => 'Noszvaj',
	'HU18829' => 'Alsórajk',
	'HU18838' => 'Kisdombegyház',
	'HU18847' => 'Mezősas',
	'HU18856' => 'Lókút',
	'HU18865' => 'Lúzsok',
	'HU18883' => 'Salköveskút',
	'HU18892' => 'Szomolya',
	'HU18908' => 'Kisasszonyfa',
	'HU18917' => 'Murga',
	'HU18926' => 'Csolnok',
	'HU18935' => 'Tarján',
	'HU18944' => 'Boldogkőújfalu',
	'HU18953' => 'Ozmánbük',
	'HU18962' => 'Kaposszekcső',
	'HU18980' => 'Fadd',
	'HU18999' => 'Ferencszállás',
	'HU19008' => 'Belvárdgyula',
	'HU19017' => 'Visnye',
	'HU19026' => 'Pusztakovácsi',
	'HU19035' => 'Tét',
	'HU19044' => 'Szurdokpüspöki',
	'HU19053' => 'Kisasszond',
	'HU19062' => 'Árpádhalom',
	'HU19080' => 'Söjtör',
	'HU19099' => 'Szentpéterszeg',
	'HU19105' => 'Zubogy',
	'HU19114' => 'Lovasberény',
	'HU19123' => 'Gyöngyössolymos',
	'HU19132' => 'Kátoly',
	'HU19141' => 'Kamond',
	'HU19150' => 'Homokszentgyörgy',
	'HU19169' => 'Szabolcs',
	'HU19178' => 'Petrikeresztúr',
	'HU19187' => 'Fityeház',
	'HU19196' => 'Nagyvázsony',
	'HU19202' => 'Dúzs',
	'HU19211' => 'Nábrád',
	'HU19220' => 'Ricse',
	'HU19239' => 'Levél',
	'HU19248' => 'Tésa',
	'HU19257' => 'Okány',
	'HU19266' => 'Szil',
	'HU19275' => 'Ziliz',
	'HU19284' => 'Cikó',
	'HU19293' => 'Galvács',
	'HU19309' => 'Győrsövényház',
	'HU19318' => 'Ősagárd',
	'HU19327' => 'Borota',
	'HU19336' => 'Veszprémgalsa',
	'HU19345' => 'Kétvölgy',
	'HU19354' => 'Perkáta',
	'HU19363' => 'Bábolna',
	'HU19372' => 'Mátranovák',
	'HU19381' => 'Tiszaladány',
	'HU19390' => 'Bélmegyer',
	'HU19406' => 'Bükkmogyorósd',
	'HU19424' => 'Kisar',
	'HU19442' => 'Somogyvár',
	'HU19451' => 'Kutasó',
	'HU19460' => 'Balatonendréd',
	'HU19479' => 'Kustánszeg',
	'HU19488' => 'Csehi',
	'HU19497' => 'Nógrádsipek',
	'HU19512' => 'Alsónemesapáti',
	'HU19521' => 'Szőce',
	'HU19530' => 'Szakmár',
	'HU19549' => 'Szár',
	'HU19558' => 'Gyügye',
	'HU19567' => 'Pély',
	'HU19576' => 'Krasznokvajda',
	'HU19585' => 'Pincehely',
	'HU19594' => 'Pusztaottlaka',
	'HU19600' => 'Makkoshotyka',
	'HU19619' => 'Iharos',
	'HU19637' => 'Páli',
	'HU19646' => 'Ófalu',
	'HU19655' => 'Máriapócs',
	'HU19664' => 'Alsódobsza',
	'HU19673' => 'Újkér',
	'HU19682' => 'Újlengyel',
	'HU19691' => 'Tetétlen',
	'HU19707' => 'Buj',
	'HU19725' => 'Versend',
	'HU19734' => 'Kemeneshőgyész',
	'HU19743' => 'Olaszfa',
	'HU19752' => 'Nyalka',
	'HU19761' => 'Kerkáskápolna',
	'HU19770' => 'Osztopán',
	'HU19798' => 'Szalmatercs',
	'HU19813' => 'Kétpó',
	'HU19831' => 'Szilágy',
	'HU19840' => 'Hernádvécse',
	'HU19859' => 'Nemespátró',
	'HU19868' => 'Pápadereske',
	'HU19877' => 'Nagypall',
	'HU19886' => 'Váchartyán',
	'HU19895' => 'Hernyék',
	'HU19901' => 'Csányoszró',
	'HU19910' => 'Kiskassa',
	'HU19929' => 'Bókaháza',
	'HU19938' => 'Pusztahencse',
	'HU19947' => 'Szalkszentmárton',
	'HU19956' => 'Biharkeresztes',
	'HU19965' => 'Mátraballa',
	'HU19974' => 'Fábiánsebestyén',
	'HU19992' => 'Kemecse',
	'HU20011' => 'Bagamér',
	'HU20039' => 'Gétye',
	'HU20048' => 'Bárna',
	'HU20057' => 'Somogyegres',
	'HU20066' => 'Nyársapát',
	'HU20075' => 'Mátramindszent',
	'HU20084' => 'Kemenesszentmárton',
	'HU20093' => 'Törökkoppány',
	'HU20109' => 'Kőszegszerdahely',
	'HU20118' => 'Erk',
	'HU20136' => 'Rábasebes',
	'HU20145' => 'Csesztve',
	'HU20154' => 'Dáka',
	'HU20163' => 'Naszály',
	'HU20172' => 'Tiszabezdéd',
	'HU20181' => 'Tiszaroff',
	'HU20190' => 'Lucfalva',
	'HU20206' => 'Seregélyes',
	'HU20215' => 'Parádsasvár',
	'HU20233' => 'Jákfalva',
	'HU20242' => 'Heréd',
	'HU20251' => 'Csehbánya',
	'HU20260' => 'Tivadar',
	'HU20279' => 'Véménd',
	'HU20288' => 'Egyed',
	'HU20303' => 'Apagy',
	'HU20312' => 'Kiskutas',
	'HU20321' => 'Rinyaújnép',
	'HU20330' => 'Somogygeszti',
	'HU20349' => 'Vashosszúfalu',
	'HU20358' => 'Előszállás',
	'HU20367' => 'Pornóapáti',
	'HU20376' => 'Almáskeresztúr',
	'HU20385' => 'Mérges',
	'HU20394' => 'Vasasszonyfa',
	'HU20400' => 'Gyömöre',
	'HU20419' => 'Újléta',
	'HU20428' => 'Szelevény',
	'HU20437' => 'Magyarpolány',
	'HU20446' => 'Tiszainoka',
	'HU20455' => 'Csanádapáca',
	'HU20464' => 'Baranyahídvég',
	'HU20482' => 'Alsóberecki',
	'HU20507' => 'Kurd',
	'HU20516' => 'Sárazsadány',
	'HU20525' => 'Tass',
	'HU20543' => 'Szalapa',
	'HU20552' => 'Királyegyháza',
	'HU20561' => 'Újireg',
	'HU20570' => 'Tés',
	'HU20589' => 'Nagykapornak',
	'HU20598' => 'Nagycsepely',
	'HU20604' => 'Ikrény',
	'HU20613' => 'Búcsúszentlászló',
	'HU20622' => 'Rinyaújlak',
	'HU20640' => 'Ceglédbercel',
	'HU20659' => 'Márok',
	'HU20668' => 'Mátyus',
	'HU20677' => 'Beregsurány',
	'HU20686' => 'Okorág',
	'HU20695' => 'Döbörhegy',
	'HU20701' => 'Mórágy',
	'HU20710' => 'Bedegkér',
	'HU20729' => 'Balatonfenyves',
	'HU20738' => 'Sajóvámos',
	'HU20747' => 'Feldebrő',
	'HU20756' => 'Hidegkút',
	'HU20765' => 'Medgyesbodzás',
	'HU20774' => 'Csobaj',
	'HU20783' => 'Simontornya',
	'HU20792' => 'Und',
	'HU20817' => 'Sárszentlőrinc',
	'HU20826' => 'Zánka',
	'HU20835' => 'Orbányosfa',
	'HU20844' => 'Lácacséke',
	'HU20853' => 'Úrkút',
	'HU20862' => 'Sárok',
	'HU20871' => 'Szin',
	'HU20880' => 'Hosszúpereszteg',
	'HU20899' => 'Boda',
	'HU20905' => 'Mike',
	'HU20914' => 'Nagyér',
	'HU20923' => 'Kisigmánd',
	'HU20932' => 'Szakonyfalu',
	'HU20941' => 'Kistolmács',
	'HU20950' => 'Belsősárd',
	'HU20969' => 'Gibárt',
	'HU20978' => 'Téseny',
	'HU20987' => 'Tárkány',
	'HU20996' => 'Kemenespálfa',
	'HU21005' => 'Tordas',
	'HU21014' => 'Molnári',
	'HU21023' => 'Hegyszentmárton',
	'HU21041' => 'Karancslapujtő',
	'HU21050' => 'Pókaszepetk',
	'HU21069' => 'Dunaegyháza',
	'HU21078' => 'Dunaszeg',
	'HU21087' => 'Vizsoly',
	'HU21096' => 'Pécsudvard',
	'HU21102' => 'Nagylóc',
	'HU21120' => 'Szentkirály',
	'HU21139' => 'Börzönce',
	'HU21148' => 'Apostag',
	'HU21157' => 'Vezseny',
	'HU21184' => 'Koppányszántó',
	'HU21193' => 'Radostyán',
	'HU21209' => 'Lőkösháza',
	'HU21218' => 'Karcsa',
	'HU21227' => 'Beszterec',
	'HU21236' => 'Homrogd',
	'HU21245' => 'Sükösd',
	'HU21254' => 'Szentpéterfa',
	'HU21263' => 'Babosdöbréte',
	'HU21272' => 'Prügy',
	'HU21281' => 'Somogyviszló',
	'HU21290' => 'Laskod',
	'HU21315' => 'Csurgó',
	'HU21324' => 'Balatonszentgyörgy',
	'HU21333' => 'Istvándi',
	'HU21342' => 'Kajászó',
	'HU21360' => 'Udvari',
	'HU21379' => 'Kisbucsa',
	'HU21388' => 'Püspökhatvan',
	'HU21397' => 'Sümegcsehi',
	'HU21403' => 'Nagypirit',
	'HU21412' => 'Üllés',
	'HU21421' => 'Szomor',
	'HU21430' => 'Veszprémfajsz',
	'HU21449' => 'Nagyberki',
	'HU21467' => 'Tóalmás',
	'HU21476' => 'Felsőrajk',
	'HU21485' => 'Nagydobos',
	'HU21494' => 'Tiszasas',
	'HU21500' => 'Kálócfa',
	'HU21519' => 'Pécsbagota',
	'HU21528' => 'Harkány',
	'HU21537' => 'Uraiújfalu',
	'HU21546' => 'Múcsony',
	'HU21564' => 'Girincs',
	'HU21573' => 'Rétközberencs',
	'HU21582' => 'Érsekvadkert',
	'HU21591' => 'Csebény',
	'HU21607' => 'Pápasalamon',
	'HU21616' => 'Kislippó',
	'HU21625' => 'Zomba',
	'HU21634' => 'Szirák',
	'HU21643' => 'Zsédeny',
	'HU21652' => 'Nagybajom',
	'HU21661' => 'Zabar',
	'HU21670' => 'Sajókápolna',
	'HU21689' => 'Nagyiván',
	'HU21698' => 'Drávasztára',
	'HU21704' => 'Old',
	'HU21731' => 'Kéty',
	'HU21740' => 'Tarcal',
	'HU21759' => 'Nemesszalók',
	'HU21768' => 'Megyaszó',
	'HU21777' => 'Vanyola',
	'HU21786' => 'Pázmánd',
	'HU21795' => 'Erdőtarcsa',
	'HU21801' => 'Ravazd',
	'HU21810' => 'Varbó',
	'HU21829' => 'Hernádkércs',
	'HU21838' => 'Hegyhátszentmárton',
	'HU21847' => 'Péteri',
	'HU21856' => 'Somogyvámos',
	'HU21865' => 'Darnózseli',
	'HU21874' => 'Piliscsév',
	'HU21892' => 'Bogádmindszent',
	'HU21908' => 'Csókakő',
	'HU21917' => 'Dör',
	'HU21935' => 'Cserháthaláp',
	'HU21944' => 'Akasztó',
	'HU21953' => 'Bánréve',
	'HU21962' => 'Lesenceistvánd',
	'HU21971' => 'Tápszentmiklós',
	'HU21980' => 'Mihályi',
	'HU21999' => 'Izsák',
	'HU22008' => 'Törtel',
	'HU22017' => 'Szamosbecs',
	'HU22026' => 'Fonó',
	'HU22035' => 'Zsámbok',
	'HU22044' => 'Ólmod',
	'HU22053' => 'Szabolcsbáka',
	'HU22062' => 'Bakonypéterd',
	'HU22071' => 'Velény',
	'HU22080' => 'Kerkakutas',
	'HU22099' => 'Bükkszentmárton',
	'HU22114' => 'Szigetújfalu',
	'HU22123' => 'Fulókércs',
	'HU22132' => 'Dombiratos',
	'HU22141' => 'Mikekarácsonyfa',
	'HU22150' => 'Fülöp',
	'HU22169' => 'Szentistván',
	'HU22178' => 'Nagykutas',
	'HU22187' => 'Hejce',
	'HU22196' => 'Poroszló',
	'HU22211' => 'Szőke',
	'HU22220' => 'Marcaltő',
	'HU22239' => 'Botpalád',
	'HU22248' => 'Pánd',
	'HU22257' => 'Szalánta',
	'HU22266' => 'Pócsa',
	'HU22275' => 'Bakóca',
	'HU22284' => 'Ófehértó',
	'HU22293' => 'Csanytelek',
	'HU22318' => 'Nyőgér',
	'HU22327' => 'Badacsonytomaj',
	'HU22336' => 'Komlódtótfalu',
	'HU22345' => 'Kemence',
	'HU22354' => 'Boconád',
	'HU22372' => 'Nagyigmánd',
	'HU22381' => 'Bakonyszombathely',
	'HU22390' => 'Csönge',
	'HU22415' => 'Fényeslitke',
	'HU22424' => 'Tormás',
	'HU22433' => 'Kocsola',
	'HU22442' => 'Edve',
	'HU22451' => 'Pécsely',
	'HU22460' => 'Kisfüzes',
	'HU22479' => 'Sajólászlófalva',
	'HU22488' => 'Verseg',
	'HU22497' => 'Ormándlak',
	'HU22503' => 'Erdőhorváti',
	'HU22512' => 'Monoszló',
	'HU22521' => 'Balajt',
	'HU22530' => 'Kerekegyháza',
	'HU22549' => 'Alsószölnök',
	'HU22558' => 'Onga',
	'HU22576' => 'Csonkamindszent',
	'HU22585' => 'Vasad',
	'HU22594' => 'Cserhátsurány',
	'HU22600' => 'Magyarszék',
	'HU22619' => 'Szomód',
	'HU22628' => 'Ónod',
	'HU22637' => 'Máriahalom',
	'HU22646' => 'Felgyő',
	'HU22655' => 'Erdőkürt',
	'HU22664' => 'Gyöngyösmellék',
	'HU22673' => 'Bonnya',
	'HU22682' => 'Letkés',
	'HU22691' => 'Veszprémvarsány',
	'HU22707' => 'Főnyed',
	'HU22716' => 'Kemestaródfa',
	'HU22725' => 'Alsóújlak',
	'HU22734' => 'Drávapalkonya',
	'HU22743' => 'Nagycserkesz',
	'HU22752' => 'Kaszaper',
	'HU22770' => 'Tiszabura',
	'HU22789' => 'Tiszaszentimre',
	'HU22798' => 'Jászkisér',
	'HU22813' => 'Bakonyszentkirály',
	'HU22822' => 'Balatonszemes',
	'HU22831' => 'Petőháza',
	'HU22840' => 'Kisgyőr',
	'HU22868' => 'Kisbudmér',
	'HU22877' => 'Böde',
	'HU22901' => 'Béb',
	'HU22910' => 'Dág',
	'HU22929' => 'Jászágó',
	'HU22938' => 'Cibakháza',
	'HU22947' => 'Zalaszabar',
	'HU22956' => 'Korlát',
	'HU22965' => 'Kacorlak',
	'HU22974' => 'Lippó',
	'HU22983' => 'Sótony',
	'HU22992' => 'Eperjes',
	'HU23001' => 'Kisszőlős',
	'HU23010' => 'Ukk',
	'HU23029' => 'Rudabánya',
	'HU23038' => 'Nyáregyháza',
	'HU23047' => 'Szécsénke',
	'HU23056' => 'Nyárlőrinc',
	'HU23074' => 'Horváthertelend',
	'HU23083' => 'Pusztavacs',
	'HU23092' => 'Siójut',
	'HU23108' => 'Pankasz',
	'HU23126' => 'Szentgyörgyvár',
	'HU23135' => 'Jásztelek',
	'HU23144' => 'Becsehely',
	'HU23153' => 'Bakonykúti',
	'HU23162' => 'Bükkösd',
	'HU23180' => 'Nagyesztergár',
	'HU23199' => 'Alsónémedi',
	'HU23205' => 'Siklósbodony',
	'HU23223' => 'Alsóregmec',
	'HU23241' => 'Adács',
	'HU23250' => 'Fábiánháza',
	'HU23269' => 'Nyírmeggyes',
	'HU23287' => 'Felsőszölnök',
	'HU23296' => 'Kapospula',
	'HU23311' => 'Pusztaszemes',
	'HU23320' => 'Nemescsó',
	'HU23348' => 'Tarnaméra',
	'HU23357' => 'Madaras',
	'HU23375' => 'Hidegség',
	'HU23384' => 'Almásháza',
	'HU23393' => 'Újiráz',
	'HU23418' => 'Sima',
	'HU23427' => 'Hantos',
	'HU23436' => 'Csatár',
	'HU23445' => 'Zaránk',
	'HU23454' => 'Kővágóörs',
	'HU23472' => 'Somberek',
	'HU23481' => 'Pásztori',
	'HU23490' => 'Mány',
	'HU23506' => 'Piskó',
	'HU23515' => 'Porva',
	'HU23533' => 'Felsővadász',
	'HU23542' => 'Magyarlukafa',
	'HU23551' => 'Nagyacsád',
	'HU23560' => 'Mezőlak',
	'HU23579' => 'Jászfelsőszentgyörgy',
	'HU23588' => 'Nagyveleg',
	'HU23597' => 'Zalaszegvár',
	'HU23612' => 'Kömörő',
	'HU23630' => 'Mernye',
	'HU23676' => 'Balástya',
	'HU23685' => 'Pátyod',
	'HU23700' => 'Kiscsősz',
	'HU23719' => 'Gelej',
	'HU23737' => 'Bodroghalom',
	'HU23746' => 'Bakonybél',
	'HU23755' => 'Semjén',
	'HU23764' => 'Palé',
	'HU23773' => 'Pereszteg',
	'HU23782' => 'Sajópüspöki',
	'HU23791' => 'Kalaznó',
	'HU23807' => 'Somogyapáti',
	'HU23816' => 'Csempeszkopács',
	'HU23825' => 'Rétság',
	'HU23834' => 'Zalaháshágy',
	'HU23843' => 'Gyóró',
	'HU23861' => 'Rátót',
	'HU23889' => 'Sonkád',
	'HU23898' => 'Rezi',
	'HU23904' => 'Gyugy',
	'HU23913' => 'Óbudavár',
	'HU23922' => 'Bakonyszentiván',
	'HU23931' => 'Méhkerék',
	'HU23940' => 'Sárrétudvari',
	'HU23968' => 'Teleki',
	'HU23977' => 'Büttös',
	'HU23986' => 'Nagyoroszi',
	'HU24004' => 'Nyirád',
	'HU24022' => 'Bátor',
	'HU24031' => 'Dombegyház',
	'HU24040' => 'Monostorapáti',
	'HU24059' => 'Nemeskolta',
	'HU24068' => 'Ősi',
	'HU24077' => 'Deszk',
	'HU24086' => 'Jászivány',
	'HU24095' => 'Csengersima',
	'HU24101' => 'Dunaszentmiklós',
	'HU24110' => 'Zselickislak',
	'HU24129' => 'Bakonytamási',
	'HU24138' => 'Rigyác',
	'HU24147' => 'Verpelét',
	'HU24156' => 'Négyes',
	'HU24174' => 'Tereske',
	'HU24192' => 'Fácánkert',
	'HU24208' => 'Sobor',
	'HU24217' => 'Mikepércs',
	'HU24226' => 'Kovácshida',
	'HU24235' => 'Erdőtelek',
	'HU24244' => 'Bakonybánk',
	'HU24253' => 'Mikóháza',
	'HU24262' => 'Egeraracsa',
	'HU24271' => 'Pakod',
	'HU24280' => 'Zalabér',
	'HU24305' => 'Pannonhalma',
	'HU24314' => 'Csököly',
	'HU24323' => 'Felsőpetény',
	'HU24332' => 'Mátraszele',
	'HU24341' => 'Bánk',
	'HU24350' => 'Újszalonta',
	'HU24369' => 'Felsőörs',
	'HU24378' => 'Bár',
	'HU24387' => 'Kisbajom',
	'HU24402' => 'Vékény',
	'HU24411' => 'Lengyel',
	'HU24420' => 'Pere',
	'HU24439' => 'Dorogháza',
	'HU24448' => 'Tiszacsécse',
	'HU24457' => 'Bálványos',
	'HU24466' => 'Mikebuda',
	'HU24475' => 'Timár',
	'HU24484' => 'Kemenessömjén',
	'HU24493' => 'Kisbárapáti',
	'HU24509' => 'Nemesbőd',
	'HU24527' => 'Tök',
	'HU24536' => 'Orci',
	'HU24545' => 'Tiszaalpár',
	'HU24554' => 'Abasár',
	'HU24572' => 'Sámsonháza',
	'HU24581' => 'Rohod',
	'HU24590' => 'Zajk',
	'HU24606' => 'Szuhogy',
	'HU24615' => 'Tapsony',
	'HU24624' => 'Lovászhetény',
	'HU24633' => 'Koroncó',
	'HU24642' => 'Csesznek',
	'HU24651' => 'Vinár',
	'HU24660' => 'Pötréte',
	'HU24679' => 'Kóspallag',
	'HU24703' => 'Tekenye',
	'HU24712' => 'Szilvás',
	'HU24721' => 'Rábapordány',
	'HU24730' => 'Pányok',
	'HU24749' => 'Baranyajenő',
	'HU24758' => 'Egerszalók',
	'HU24767' => 'Ugod',
	'HU24776' => 'Padár',
	'HU24794' => 'Kardos',
	'HU24800' => 'Söpte',
	'HU24828' => 'Biharnagybajom',
	'HU24837' => 'Nagytilaj',
	'HU24846' => 'Heresznye',
	'HU24855' => 'Romonya',
	'HU24864' => 'Batyk',
	'HU24873' => 'Homokkomárom',
	'HU24882' => 'Hernádpetri',
	'HU24891' => 'Szigliget',
	'HU24907' => 'Balatonszárszó',
	'HU24916' => 'Szob',
	'HU24925' => 'Bisse',
	'HU24943' => 'Nagykökényes',
	'HU24952' => 'Vásárosbéc',
	'HU24970' => 'Hernádszurdok',
	'HU24989' => 'Decs',
	'HU24998' => 'Tázlár',
	'HU25007' => 'Sáránd',
	'HU25025' => 'Liszó',
	'HU25043' => 'Somogybükkösd',
	'HU25052' => 'Orosztony',
	'HU25061' => 'Szabadszállás',
	'HU25070' => 'Somogyhatvan',
	'HU25089' => 'Mezőszemere',
	'HU25098' => 'Bénye',
	'HU25104' => 'Hangony',
	'HU25113' => 'Tótszerdahely',
	'HU25122' => 'Zaláta',
	'HU25140' => 'Sárosd',
	'HU25159' => 'Bánhorváti',
	'HU25168' => 'Sarkadkeresztúr',
	'HU25177' => 'Magyarbóly',
	'HU25186' => 'Jászjákóhalma',
	'HU25195' => 'Bogács',
	'HU25201' => 'Nagytevel',
	'HU25210' => 'Murakeresztúr',
	'HU25229' => 'Bakonysárkány',
	'HU25238' => 'Filkeháza',
	'HU25247' => 'Köblény',
	'HU25256' => 'Bihardancsháza',
	'HU25265' => 'Alattyán',
	'HU25283' => 'Alsószentiván',
	'HU25292' => 'Regenye',
	'HU25308' => 'Balatonakali',
	'HU25326' => 'Erdőbénye',
	'HU25335' => 'Rábapatona',
	'HU25344' => 'Sárkeresztúr',
	'HU25353' => 'Kemendollár',
	'HU25362' => 'Dunabogdány',
	'HU25371' => 'Magyaregres',
	'HU25380' => 'Selyeb',
	'HU25399' => 'Igrici',
	'HU25414' => 'Németfalu',
	'HU25423' => 'Magyarszombatfa',
	'HU25432' => 'Tabdi',
	'HU25441' => 'Benk',
	'HU25450' => 'Öskü',
	'HU25469' => 'Esztár',
	'HU25478' => 'Oltárc',
	'HU25487' => 'Leányvár',
	'HU25496' => 'Endrefalva',
	'HU25502' => 'Csárdaszállás',
	'HU25511' => 'Nemeskisfalud',
	'HU25520' => 'Nagyszakácsi',
	'HU25539' => 'Györe',
	'HU25548' => 'Karancsberény',
	'HU25566' => 'Hárskút',
	'HU25575' => 'Cserépváralja',
	'HU25609' => 'Nemessándorháza',
	'HU25618' => 'Méra',
	'HU25645' => 'Sióagárd',
	'HU25654' => 'Kerta',
	'HU25663' => 'Galgaguta',
	'HU25672' => 'Hidvégardó',
	'HU25681' => 'Cserénfa',
	'HU25690' => 'Domaháza',
	'HU25706' => 'Szentbalázs',
	'HU25715' => 'Moha',
	'HU25724' => 'Sopronkövesd',
	'HU25733' => 'Mártély',
	'HU25742' => 'Kány',
	'HU25751' => 'Pákozd',
	'HU25760' => 'Meggyeskovácsi',
	'HU25779' => 'Somlószőlős',
	'HU25797' => 'Vitnyéd',
	'HU25803' => 'Hegymagas',
	'HU25812' => 'Ág',
	'HU25821' => 'Erdősmárok',
	'HU25830' => 'Hajmás',
	'HU25849' => 'Rigács',
	'HU25858' => 'Köveskál',
	'HU25867' => 'Kaposhomok',
	'HU25876' => 'Told',
	'HU25885' => 'Dobri',
	'HU25894' => 'Monostorpályi',
	'HU25900' => 'Tömörkény',
	'HU25928' => 'Nyírkércs',
	'HU25937' => 'Balotaszállás',
	'HU25946' => 'Egyházasrádóc',
	'HU25955' => 'Nagybaracska',
	'HU25964' => 'Konyár',
	'HU25973' => 'Nyírcsászári',
	'HU25982' => 'Vassurány',
	'HU25991' => 'Bakonynána',
	'HU26000' => 'Velem',
	'HU26019' => 'Egerbocs',
	'HU26028' => 'Nagybánhegyes',
	'HU26037' => 'Kékkút',
	'HU26046' => 'Kőszegpaty',
	'HU26055' => 'Hőgyész',
	'HU26064' => 'Csipkerek',
	'HU26073' => 'Rábapaty',
	'HU26082' => 'Cserdi',
	'HU26091' => 'Lónya',
	'HU26107' => 'Csegöld',
	'HU26116' => 'Sáp',
	'HU26125' => 'Aparhant',
	'HU26134' => 'Nagyvenyim',
	'HU26143' => 'Nagysimonyi',
	'HU26152' => 'Gérce',
	'HU26161' => 'Szijártóháza',
	'HU26170' => 'Hajdúbagos',
	'HU26189' => 'Békéssámson',
	'HU26198' => 'Arka',
	'HU26204' => 'Várkesző',
	'HU26222' => 'Gadány',
	'HU26231' => 'Ládbesenyő',
	'HU26240' => 'Nemesládony',
	'HU26259' => 'Szigetbecse',
	'HU26268' => 'Valkonya',
	'HU26277' => 'Bőszénfa',
	'HU26286' => 'Mezőhék',
	'HU26295' => 'Kisbárkány',
	'HU26301' => 'Inke',
	'HU26310' => 'Rém',
	'HU26329' => 'Nyugotszenterzsébet',
	'HU26338' => 'Abaújszolnok',
	'HU26347' => 'Ebergőc',
	'HU26356' => 'Berzék',
	'HU26365' => 'Nyírmihálydi',
	'HU26374' => 'Magyargencs',
	'HU26383' => 'Gátér',
	'HU26392' => 'Pamuk',
	'HU26417' => 'Bakonyszücs',
	'HU26426' => 'Vép',
	'HU26435' => 'Nyíri',
	'HU26444' => 'Maglóca',
	'HU26453' => 'Kadarkút',
	'HU26462' => 'Balatonmagyaród',
	'HU26471' => 'Csátalja',
	'HU26480' => 'Barabás',
	'HU26505' => 'Nagykinizs',
	'HU26514' => 'Olaszfalu',
	'HU26523' => 'Nóráp',
	'HU26532' => 'Böhönye',
	'HU26541' => 'Kup',
	'HU26550' => 'Ömböly',
	'HU26569' => 'Somlóvásárhely',
	'HU26587' => 'Rajka',
	'HU26596' => 'Kercaszomor',
	'HU26602' => 'Köröm',
	'HU26620' => 'Katafa',
	'HU26639' => 'Pusztaszentlászló',
	'HU26648' => 'Vaszar',
	'HU26666' => 'Kiszombor',
	'HU26675' => 'Lengyeltóti',
	'HU26693' => 'Báránd',
	'HU26709' => 'Csorvás',
	'HU26718' => 'Abaújkér',
	'HU26727' => 'Grábóc',
	'HU26736' => 'Rábagyarmat',
	'HU26745' => 'Parasznya',
	'HU26754' => 'Rinyaszentkirály',
	'HU26763' => 'Simaság',
	'HU26772' => 'Csánig',
	'HU26781' => 'Várda',
	'HU26790' => 'Halászi',
	'HU26806' => 'Rönök',
	'HU26824' => 'Alap',
	'HU26833' => 'Iliny',
	'HU26842' => 'Zselickisfalud',
	'HU26851' => 'Csengerújfalu',
	'HU26860' => 'Gyarmat',
	'HU26879' => 'Nagyfüged',
	'HU26888' => 'Kazsok',
	'HU26897' => 'Karancsság',
	'HU26903' => 'Sárisáp',
	'HU26921' => 'Ásványráró',
	'HU26930' => 'Mocsa',
	'HU26958' => 'Balkány',
	'HU26967' => 'Magyargéc',
	'HU26976' => 'Nagyhódos',
	'HU26985' => 'Csővár',
	'HU26994' => 'Tótszentgyörgy',
	'HU27012' => 'Váraszó',
	'HU27021' => 'Kisharsány',
	'HU27030' => 'Gyanógeregye',
	'HU27049' => 'Becskeháza',
	'HU27058' => 'Békás',
	'HU27067' => 'Magyarsarlós',
	'HU27076' => 'Nagysáp',
	'HU27085' => 'Cakóháza',
	'HU27100' => 'Vasmegyer',
	'HU27119' => 'Nemesborzova',
	'HU27128' => 'Galgamácsa',
	'HU27137' => 'Mencshely',
	'HU27146' => 'Komoró',
	'HU27155' => 'Nagyhalász',
	'HU27164' => 'Nagypeterd',
	'HU27182' => 'Nagykónyi',
	'HU27191' => 'Novajidrány',
	'HU27207' => 'Zalagyömörő',
	'HU27216' => 'Ostoros',
	'HU27225' => 'Kálmánháza',
	'HU27234' => 'Bácsborsód',
	'HU27243' => 'Kisbágyon',
	'HU27252' => 'Tiszanagyfalu',
	'HU27261' => 'Tisztaberek',
	'HU27270' => 'Csömend',
	'HU27289' => 'Magyarnádalja',
	'HU27298' => 'Apátvarasd',
	'HU27304' => 'Potyond',
	'HU27322' => 'Vámosatya',
	'HU27331' => 'Sajóecseg',
	'HU27340' => 'Nógrádszakál',
	'HU27359' => 'Mecsér',
	'HU27368' => 'Segesd',
	'HU27377' => 'Balatonberény',
	'HU27386' => 'Tatárszentgyörgy',
	'HU27401' => 'Egyházaskozár',
	'HU27429' => 'Bódvalenke',
	'HU27438' => 'Örménykút',
	'HU27447' => 'Barlahida',
	'HU27456' => 'Szendrőlád',
	'HU27465' => 'Pusztaederics',
	'HU27483' => 'Lendvadedes',
	'HU27492' => 'Csöde',
	'HU27508' => 'Szágy',
	'HU27517' => 'Besenyőtelek',
	'HU27526' => 'Miháld',
	'HU27535' => 'Somogysimonyi',
	'HU27544' => 'Tiszaszentmárton',
	'HU27553' => 'Pogányszentpéter',
	'HU27562' => 'Zalaszombatfa',
	'HU27571' => 'Kelebia',
	'HU27580' => 'Nemti',
	'HU27605' => 'Nagytálya',
	'HU27614' => 'Zimány',
	'HU27623' => 'Újlőrincfalva',
	'HU27632' => 'Úny',
	'HU27641' => 'Álmosd',
	'HU27650' => 'Rózsaszentmárton',
	'HU27669' => 'Dubicsány',
	'HU27678' => 'Magyaralmás',
	'HU27696' => 'Maklár',
	'HU27702' => 'Tékes',
	'HU27711' => 'Izmény',
	'HU27720' => 'Salomvár',
	'HU27739' => 'Dunakiliti',
	'HU27748' => 'Pap',
	'HU27757' => 'Sajóvelezd',
	'HU27766' => 'Kisszékely',
	'HU27775' => 'Óhíd',
	'HU27784' => 'Iharosberény',
	'HU27793' => 'Szergény',
	'HU27809' => 'Mátételke',
	'HU27818' => 'Homokbödöge',
	'HU27827' => 'Káva',
	'HU27836' => 'Tornaszentandrás',
	'HU27845' => 'Homokmégy',
	'HU27863' => 'Majs',
	'HU27881' => 'Hásságy',
	'HU27890' => 'Bükkaranyos',
	'HU27906' => 'Magyarbánhegyes',
	'HU27915' => 'Mohora',
	'HU27924' => 'Ópályi',
	'HU27933' => 'Himesháza',
	'HU27942' => 'Halmaj',
	'HU27951' => 'Tilaj',
	'HU27960' => 'Sorkikápolna',
	'HU27979' => 'Nagyalásony',
	'HU27988' => 'Nagyszekeres',
	'HU27997' => 'Szemenye',
	'HU28006' => 'Öcsöd',
	'HU28015' => 'Iszkáz',
	'HU28024' => 'Villány',
	'HU28033' => 'Nekézseny',
	'HU28051' => 'Tolcsva',
	'HU28060' => 'Nyírtass',
	'HU28079' => 'Kerecsend',
	'HU28088' => 'Gyöngyöstarján',
	'HU28097' => 'Ipolydamásd',
	'HU28112' => 'Öcs',
	'HU28121' => 'Drávacsepely',
	'HU28149' => 'Mosonszolnok',
	'HU28158' => 'Kisszállás',
	'HU28167' => 'Lovászi',
	'HU28185' => 'Perbál',
	'HU28194' => 'Szuha',
	'HU28200' => 'Ligetfalva',
	'HU28219' => 'Litka',
	'HU28237' => 'Dabrony',
	'HU28246' => 'Beregdaróc',
	'HU28255' => 'Mogyorósbánya',
	'HU28264' => 'Gadács',
	'HU28273' => 'Endrőc',
	'HU28282' => 'Nagyvisnyó',
	'HU28291' => 'Lábod',
	'HU28307' => 'Gagybátor',
	'HU28316' => 'Bábonymegyer',
	'HU28325' => 'Hottó',
	'HU28343' => 'Vaskút',
	'HU28361' => 'Potony',
	'HU28370' => 'Apácatorna',
	'HU28389' => 'Kazár',
	'HU28398' => 'Tiszalúc',
	'HU28404' => 'Gyöngyfa',
	'HU28413' => 'Visegrád',
	'HU28422' => 'Nemesvita',
	'HU28431' => 'Kék',
	'HU28440' => 'Nyírgelse',
	'HU28459' => 'Csernely',
	'HU28468' => 'Nagypáli',
	'HU28477' => 'Kisléta',
	'HU28486' => 'Tompa',
	'HU28495' => 'Zalaboldogfa',
	'HU28501' => 'Balatonszőlős',
	'HU28510' => 'Porrogszentpál',
	'HU28529' => 'Varga',
	'HU28538' => 'Vajszló',
	'HU28547' => 'Kovácsvágás',
	'HU28556' => 'Erdőkövesd',
	'HU28574' => 'Szabás',
	'HU28583' => 'Áta',
	'HU28592' => 'Pusztaszer',
	'HU28608' => 'Drávaszabolcs',
	'HU28617' => 'Drávacsehi',
	'HU28626' => 'Répceszentgyörgy',
	'HU28635' => 'Teresztenye',
	'HU28644' => 'Úri',
	'HU28653' => 'Szentmártonkáta',
	'HU28662' => 'Belecska',
	'HU28671' => 'Gyepükaján',
	'HU28699' => 'Tiszaigar',
	'HU28705' => 'Szabadbattyán',
	'HU28714' => 'Andocs',
	'HU28723' => 'Somogysárd',
	'HU28732' => 'Gagyapáti',
	'HU28741' => 'Sellye',
	'HU28750' => 'Zsarolyán',
	'HU28769' => 'Bágyogszovát',
	'HU28778' => 'Dióskál',
	'HU28787' => 'Taktakenéz',
	'HU28796' => 'Egervölgy',
	'HU28802' => 'Nyírbogdány',
	'HU28811' => 'Kaposgyarmat',
	'HU28820' => 'Szeremle',
	'HU28839' => 'Alsószuha',
	'HU28848' => 'Pátka',
	'HU28857' => 'Kutas',
	'HU28875' => 'Kishuta',
	'HU28884' => 'Rimóc',
	'HU28893' => 'Geszteréd',
	'HU28909' => 'Bátaapáti',
	'HU28918' => 'Egerág',
	'HU28927' => 'Nagytótfalu',
	'HU28936' => 'Bakonygyirót',
	'HU28945' => 'Győröcske',
	'HU28963' => 'Somogyjád',
	'HU28972' => 'Pusztamiske',
	'HU28981' => 'Ura',
	'HU28990' => 'Kisláng',
	'HU29009' => 'Nyárád',
	'HU29027' => 'Kunfehértó',
	'HU29036' => 'Mezőszilas',
	'HU29045' => 'Mátraszentimre',
	'HU29054' => 'Tornyosnémeti',
	'HU29063' => 'Nagyberény',
	'HU29072' => 'Kisberzseny',
	'HU29081' => 'Lócs',
	'HU29090' => 'Sopronhorpács',
	'HU29106' => 'Baks',
	'HU29124' => 'Várong',
	'HU29133' => 'Tiszacsermely',
	'HU29142' => 'Somogyhárságy',
	'HU29151' => 'Vágáshuta',
	'HU29160' => 'Páka',
	'HU29179' => 'Nagytőke',
	'HU29188' => 'Nagybarca',
	'HU29197' => 'Péterhida',
	'HU29203' => 'Boba',
	'HU29230' => 'Dalmand',
	'HU29249' => 'Kesznyéten',
	'HU29267' => 'Tác',
	'HU29276' => 'Novaj',
	'HU29294' => 'Marcalgergelyi',
	'HU29300' => 'Kispalád',
	'HU29319' => 'Ipolyvece',
	'HU29328' => 'Nemeskér',
	'HU29337' => 'Madocsa',
	'HU29346' => 'Tiszajenő',
	'HU29355' => 'Bajót',
	'HU29364' => 'Csömödér',
	'HU29373' => 'Vasszécseny',
	'HU29382' => 'Örményes',
	'HU29391' => 'Hencida',
	'HU29407' => 'Agyagosszergény',
	'HU29416' => 'Csaroda',
	'HU29425' => 'Nőtincs',
	'HU29443' => 'Gulács',
	'HU29452' => 'Halastó',
	'HU29461' => 'Balatonfőkajár',
	'HU29470' => 'Döbrönte',
	'HU29489' => 'Kerkabarabás',
	'HU29498' => 'Varsány',
	'HU29504' => 'Iklanberény',
	'HU29513' => 'Bakonyjákó',
	'HU29522' => 'Molvány',
	'HU29540' => 'Mozsgó',
	'HU29559' => 'Panyola',
	'HU29568' => 'Telekes',
	'HU29577' => 'Kesztölc',
	'HU29595' => 'Almáskamarás',
	'HU29610' => 'Biharugra',
	'HU29629' => 'Vértestolna',
	'HU29638' => 'Epöl',
	'HU29656' => 'Pat',
	'HU29665' => 'Alsónána',
	'HU29674' => 'Beret',
	'HU29683' => 'Zalatárnok',
	'HU29692' => 'Sorokpolány',
	'HU29708' => 'Felsőgagy',
	'HU29717' => 'Rakaca',
	'HU29753' => 'Magyaregregy',
	'HU29762' => 'Pettend',
	'HU29771' => 'Gősfa',
	'HU29780' => 'Vízvár',
	'HU29799' => 'Méhtelek',
	'HU29805' => 'Bezenye',
	'HU29814' => 'Alsóvadász',
	'HU29832' => 'Nógrádmarcal',
	'HU29841' => 'Felsőmarác',
	'HU29850' => 'Kisoroszi',
	'HU29869' => 'Nagyrákos',
	'HU29887' => 'Bihartorda',
	'HU29896' => 'Porpác',
	'HU29902' => 'Bakonyság',
	'HU29911' => 'Tákos',
	'HU29920' => 'Maráza',
	'HU29939' => 'Felcsút',
	'HU29948' => 'Ipacsfa',
	'HU29957' => 'Káld',
	'HU29966' => 'Homorúd',
	'HU29975' => 'Anarcs',
	'HU29984' => 'Magosliget',
	'HU29993' => 'Zalaerdőd',
	'HU30003' => 'Vajdácska',
	'HU30012' => 'Réde',
	'HU30021' => 'Sarród',
	'HU30030' => 'Drávaszerdahely',
	'HU30049' => 'Besence',
	'HU30067' => 'Szentpéterfölde',
	'HU30076' => 'Vatta',
	'HU30085' => 'Szamostatárfalva',
	'HU30094' => 'Csikóstőttős',
	'HU30100' => 'Mátraverebély',
	'HU30119' => 'Berzence',
	'HU30128' => 'Medgyesegyháza',
	'HU30137' => 'Hercegkút',
	'HU30146' => 'Szenyér',
	'HU30155' => 'Bácsszőlős',
	'HU30164' => 'Körösújfalu',
	'HU30173' => 'Kislőd',
	'HU30182' => 'Kolontár',
	'HU30191' => 'Csér',
	'HU30207' => 'Borsodszentgyörgy',
	'HU30216' => 'Hegyhátsál',
	'HU30225' => 'Tardos',
	'HU30234' => 'Mesterszállás',
	'HU30243' => 'Zámoly',
	'HU30252' => 'Borzavár',
	'HU30261' => 'Dormánd',
	'HU30270' => 'Csécse',
	'HU30289' => 'Gyönk',
	'HU30298' => 'Tiszatardos',
	'HU30304' => 'Tiszagyenda',
	'HU30313' => 'Zalalövő',
	'HU30331' => 'Vácegres',
	'HU30359' => 'Gyulaj',
	'HU30368' => 'Bagod',
	'HU30377' => 'Tiszatarján',
	'HU30386' => 'Tiszakürt',
	'HU30395' => 'Legénd',
	'HU30410' => 'Bakonyoszlop',
	'HU30429' => 'Egyházashollós',
	'HU30438' => 'Görcsöny',
	'HU30447' => 'Tibolddaróc',
	'HU30465' => 'Tihany',
	'HU30474' => 'Babócsa',
	'HU30492' => 'Mekényes',
	'HU30508' => 'Karos',
	'HU30517' => 'Tornaszentjakab',
	'HU30526' => 'Alsóörs',
	'HU30535' => 'Dóc',
	'HU30544' => 'Csabdi',
	'HU30553' => 'Környe',
	'HU30562' => 'Medina',
	'HU30571' => 'Gölle',
	'HU30580' => 'Somogyacsa',
	'HU30599' => 'Mikosszéplak',
	'HU30605' => 'Kaskantyú',
	'HU30614' => 'Csarnóta',
	'HU30632' => 'Miske',
	'HU30641' => 'Csenger',
	'HU30650' => 'Kőszárhegy',
	'HU30669' => 'Borsodbóta',
	'HU30678' => 'Fenyőfő',
	'HU30702' => 'Vaskeresztes',
	'HU30711' => 'Jászalsószentgyörgy',
	'HU30748' => 'Sitke',
	'HU30757' => 'Petrivente',
	'HU30775' => 'Hosszúvíz',
	'HU30784' => 'Bodrogkeresztúr',
	'HU30793' => 'Salföld',
	'HU30827' => 'Kisberény',
	'HU30836' => 'Hosszúhetény',
	'HU30845' => 'Tiszagyulaháza',
	'HU30854' => 'Mezőcsokonya',
	'HU30863' => 'Ráksi',
	'HU30872' => 'Megyehíd',
	'HU30881' => 'Répcelak',
	'HU30890' => 'Felsőszenterzsébet',
	'HU30906' => 'Gasztony',
	'HU30915' => 'Vanyarc',
	'HU30924' => 'Csabrendek',
	'HU30942' => 'Gersekarát',
	'HU30951' => 'Hegyhátmaróc',
	'HU30960' => 'Gyékényes',
	'HU30979' => 'Levelek',
	'HU30997' => 'Semjénháza',
	'HU31006' => 'Bózsva',
	'HU31015' => 'Szalaszend',
	'HU31033' => 'Mezőpeterd',
	'HU31042' => 'Tépe',
	'HU31051' => 'Vámoscsalád',
	'HU31060' => 'Szava',
	'HU31079' => 'Öttömös',
	'HU31088' => 'Székely',
	'HU31103' => 'Balinka',
	'HU31112' => 'Pölöskefő',
	'HU31121' => 'Sántos',
	'HU31130' => 'Körösszakál',
	'HU31149' => 'Csonkahegyhát',
	'HU31158' => 'Nyírbogát',
	'HU31167' => 'Hollóháza',
	'HU31185' => 'Kisvejke',
	'HU31194' => 'Lövő',
	'HU31219' => 'Somogyaszaló',
	'HU31228' => 'Végegyháza',
	'HU31237' => 'Szatmárcseke',
	'HU31246' => 'Visonta',
	'HU31255' => 'Pápateszér',
	'HU31264' => 'Vértesszőlős',
	'HU31273' => 'Szamosújlak',
	'HU31282' => 'Mikófalva',
	'HU31291' => 'Bocska',
	'HU31307' => 'Adorjánháza',
	'HU31316' => 'Győrság',
	'HU31325' => 'Szabadkígyós',
	'HU31334' => 'Csabacsűd',
	'HU31343' => 'Mosdós',
	'HU31352' => 'Darány',
	'HU31361' => 'Kóka',
	'HU31370' => 'Pusztacsalád',
	'HU31389' => 'Lothárd',
	'HU31398' => 'Tyukod',
	'HU31404' => 'Kállósemjén',
	'HU31413' => 'Keszeg',
	'HU31422' => 'Bana',
	'HU31431' => 'Husztót',
	'HU31440' => 'Fertőszéplak',
	'HU31459' => 'Tevel',
	'HU31468' => 'Fülöpháza',
	'HU31477' => 'Nyírjákó',
	'HU31486' => 'Nagyréde',
	'HU31510' => 'Szegilong',
	'HU31529' => 'Kerecseny',
	'HU31538' => 'Sárszentágota',
	'HU31556' => 'Nemesmedves',
	'HU31565' => 'Mónosbél',
	'HU31574' => 'Kevermes',
	'HU31592' => 'Rédics',
	'HU31608' => 'Zemplénagárd',
	'HU31617' => 'Zalamerenye',
	'HU31626' => 'Kunsziget',
	'HU31635' => 'Iván',
	'HU31644' => 'Fiad',
	'HU31662' => 'Mezőtárkány',
	'HU31671' => 'Felsőtelekes',
	'HU31680' => 'Ivánc',
	'HU31699' => 'Csetény',
	'HU31714' => 'Sósvertike',
	'HU31723' => 'Felsőkelecsény',
	'HU31741' => 'Pacsa',
	'HU31750' => 'Milota',
	'HU31769' => 'Ököritófülpös',
	'HU31778' => 'Olaszliszka',
	'HU31787' => 'Győrújfalu',
	'HU31802' => 'Sárkeresztes',
	'HU31811' => 'Dánszentmiklós',
	'HU31820' => 'Uszka',
	'HU31839' => 'Újrónafő',
	'HU31848' => 'Gara',
	'HU31857' => 'Ramocsaháza',
	'HU31866' => 'Tiszavárkony',
	'HU31875' => 'Mesterháza',
	'HU31884' => 'Répáshuta',
	'HU31893' => 'Kunszállás',
	'HU31909' => 'Rásonysápberencs',
	'HU31918' => 'Kunpeszér',
	'HU31927' => 'Beremend',
	'HU31936' => 'Illocska',
	'HU31954' => 'Debréte',
	'HU31963' => 'Tahitótfalu',
	'HU31972' => 'Paszab',
	'HU31981' => 'Márokföld',
	'HU31990' => 'Súr',
	'HU32009' => 'Szentdénes',
	'HU32018' => 'Iszkaszentgyörgy',
	'HU32027' => 'Bugyi',
	'HU32036' => 'Keléd',
	'HU32063' => 'Kávás',
	'HU32072' => 'Teklafalu',
	'HU32081' => 'Alsópáhok',
	'HU32090' => 'Királd',
	'HU32115' => 'Ötvöskónyi',
	'HU32124' => 'Bérbaltavár',
	'HU32133' => 'Sérsekszőlős',
	'HU32142' => 'Vindornyafok',
	'HU32151' => 'Bogád',
	'HU32160' => 'Sásd',
	'HU32179' => 'Kál',
	'HU32188' => 'Hegyfalu',
	'HU32197' => 'Újudvar',
	'HU32203' => 'Fehérvárcsurgó',
	'HU32212' => 'Márkó',
	'HU32221' => 'Külsősárd',
	'HU32249' => 'Árpás',
	'HU32258' => 'Szakácsi',
	'HU32267' => 'Kilimán',
	'HU32276' => 'Devecser',
	'HU32285' => 'Csengele',
	'HU32294' => 'Nyírábrány',
	'HU32300' => 'Nógrádkövesd',
	'HU32319' => 'Cserhátszentiván',
	'HU32328' => 'Encsencs',
	'HU32337' => 'Baté',
	'HU32346' => 'Almásfüzitő',
	'HU32355' => 'Libickozma',
	'HU32364' => 'Nagylók',
	'HU32373' => 'Diósviszló',
	'HU32382' => 'Nyírmártonfalva',
	'HU32391' => 'Drávaiványi',
	'HU32407' => 'Magyarnándor',
	'HU32416' => 'Tengőd',
	'HU32425' => 'Peterd',
	'HU32452' => 'Nyírkáta',
	'HU32461' => 'Szilvásszentmárton',
	'HU32470' => 'Somogybabod',
	'HU32489' => 'Szegvár',
	'HU32498' => 'Kondó',
	'HU32513' => 'Pördefölde',
	'HU32522' => 'Zalaszentgrót',
	'HU32531' => 'Serényfalva',
	'HU32540' => 'Nemesnádudvar',
	'HU32568' => 'Újszentmargita',
	'HU32577' => 'Papos',
	'HU32586' => 'Vérteskethely',
	'HU32595' => 'Dénesfa',
	'HU32601' => 'Somogytúr',
	'HU32629' => 'Ostffyasszonyfa',
	'HU32638' => 'Tornyiszentmiklós',
	'HU32647' => 'Kerkateskánd',
	'HU32656' => 'Mezőladány',
	'HU32665' => 'Nemesnép',
	'HU32674' => 'Rinyakovácsi',
	'HU32683' => 'Perecse',
	'HU32692' => 'Penyige',
	'HU32708' => 'Dobronhegy',
	'HU32717' => 'Feketeerdő',
	'HU32726' => 'Kisrécse',
	'HU32735' => 'Attala',
	'HU32744' => 'Tésenfa',
	'HU32753' => 'Dég',
	'HU32762' => 'Felsőnyárád',
	'HU32771' => 'Kocsér',
	'HU32780' => 'Simonfa',
	'HU32805' => 'Nagykorpád',
	'HU32814' => 'Csögle',
	'HU32823' => 'Bugac',
	'HU32832' => 'Meszlen',
	'HU32841' => 'Szentborbás',
	'HU32850' => 'Váralja',
	'HU32869' => 'Kérsemjén',
	'HU32878' => 'Csót',
	'HU32887' => 'Bükkzsérc',
	'HU32896' => 'Tar',
	'HU32902' => 'Kehidakustány',
	'HU32911' => 'Bér',
	'HU32920' => 'Nagykölked',
	'HU32939' => 'Nagylózs',
	'HU32948' => 'Nemesbük',
	'HU32957' => 'Elek',
	'HU32966' => 'Tarnabod',
	'HU32975' => 'Kőröstetétlen',
	'HU32984' => 'Bucsu',
	'HU32993' => 'Kács',
	'HU33002' => 'Bodolyabér',
	'HU33011' => 'Szécsényfelfalu',
	'HU33020' => 'Forráskút',
	'HU33039' => 'Zalameggyes',
	'HU33057' => 'Zics',
	'HU33066' => 'Ibafa',
	'HU33075' => 'Tarhos',
	'HU33084' => 'Gordisa',
	'HU33093' => 'Alacska',
	'HU33109' => 'Csatka',
	'HU33136' => 'Zalaszentgyörgy',
	'HU33145' => 'Nyírpazony',
	'HU33154' => 'Bóly',
	'HU33163' => 'Dad',
	'HU33172' => 'Szeleste',
	'HU33181' => 'Nagyrozvágy',
	'HU33190' => 'Doboz',
	'HU33206' => 'Kisecset',
	'HU33215' => 'Kisnyárád',
	'HU33224' => 'Márokpapi',
	'HU33233' => 'Gödre',
	'HU33242' => 'Hollókő',
	'HU33251' => 'Felpéc',
	'HU33260' => 'Bélapátfalva',
	'HU33279' => 'Alsószentmárton',
	'HU33288' => 'Zalaszántó',
	'HU33297' => 'Hunya',
	'HU33303' => 'Bódvarákó',
	'HU33312' => 'Felsőtold',
	'HU33321' => 'Soponya',
	'HU33330' => 'Lánycsók',
	'HU33349' => 'Mőcsény',
	'HU33358' => 'Terem',
	'HU33376' => 'Miklósi',
	'HU33385' => 'Acsalag',
	'HU33394' => 'Kapoly',
	'HU33400' => 'Kishartyán',
	'HU33419' => 'Perkupa',
	'HU33428' => 'Egervár',
	'HU33437' => 'Szerep',
	'HU33446' => 'Bedő',
	'HU33482' => 'Sátorhely',
	'HU33491' => 'Szárliget',
	'HU33516' => 'Szákszend',
	'HU33525' => 'Mátraterenye',
	'HU33543' => 'Nagyszentjános',
	'HU33552' => 'Herceghalom',
	'HU33561' => 'Apaj',
	'HU33570' => 'Pörböly',
	'HU33589' => 'Érsekhalma',
	'HU33598' => 'Felsőlajos',
	'HU33604' => 'Újtelek',
	'HU33613' => 'Szentegát',
	'HU33622' => 'Fülöpjakab',
	'HU33631' => 'Bugacpusztaháza',
	'HU33640' => 'Csém',
	'HU33659' => 'Újdombrád',
	'HU33668' => 'Lébény',
	'HU33677' => 'Mosonszentmiklós',
	'HU33686' => 'Petőfibánya',
	'HU33695' => 'Kisfalud',
	'HU33701' => 'Rábacsécsény',
	'HU33710' => 'Rábaszentmihály',
	'HU33729' => 'Verőce',
	'HU33738' => 'Kismaros',
	'HU33747' => 'Tiszavid',
	'HU33756' => 'Máza',
	'HU33765' => 'Szászvár',
	'HU33774' => 'Gyüre',
	'HU33783' => 'Nagyvarsány',
	'HU33792' => 'Lakhegy',
	'HU33808' => 'Bodrogkisfalud',
	'HU33817' => 'Szegi',
	'HU33826' => 'Neszmély',
	'HU33835' => 'Dunaalmás',
	'HU33844' => 'Balatonrendes',
	'HU33871' => 'Egeralja',
	'HU33880' => 'Patvarc',
	'HU33899' => 'Nagydobsza',
	'HU33905' => 'Kisdobsza',
	'HU33914' => 'Tarjánpuszta',
	'HU33923' => 'Mánfa',
	'HU33932' => 'Hobol',
	'HU33941' => 'Eplény',
	'HU33950' => 'Bőny',
	'HU33969' => 'Rétalap',
	'HU33978' => 'Csörnyeföld',
	'HU33987' => 'Muraszemenye',
	'HU34005' => 'Berekfürdő',
	'HU34014' => 'Folyás',
	'HU34032' => 'Szaporca',
	'HU34041' => 'Pálmajor',
	'HU34050' => 'Hunyadfalva',
	'HU34078' => 'Csabaszabadi',
	'HU34087' => 'Tormásliget',
	'HU34096' => 'Móricgát',
	'HU34102' => 'Bocskaikert',
	'HU34111' => 'Csincse',
	'HU34175' => 'Csataszög',
	'HU34184' => 'Alsóbogát',
	'HU34193' => 'Kaszó',
	'HU34209' => 'Kulcs',
	'HU34218' => 'Uzsa',
	'HU34227' => 'Annavölgy',
	'HU34236' => 'Szántód',
	'HU34245' => 'Algyő',
	'HU34254' => 'Pétfürdő',
	'HU34263' => 'Zichyújfalu',
	'HU34281' => 'Nagykeresztúr',
	'HU34290' => 'Berente',
	'HU34306' => 'Óbarok',
	'HU34324' => 'Pálosvörösmart',
	'HU34342' => 'Daruszentmiklós',
	'HU34351' => 'Károlyháza',
	'HU34360' => 'Rákóczibánya',
	'HU34379' => 'Kerekharaszt',
	'HU34388' => 'Szorgalmatos',
	'HU34397' => 'Monorierdő',
	'HU34403' => 'Zákányfalu',
	'HU34412' => 'Mosonudvar',
	'HU34421' => 'Balatonakarattya',
];
