<?php

/**
 * List of cities for: Greece
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['GR'];

$country_cities = [
	'A'	=> [
		'GR01010101' => _x( 'Komotini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010102' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010103' => _x( 'Gratini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010104' => _x( 'Thrylorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010105' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010106' => _x( 'Kalchas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010107' => _x( 'Karydia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010108' => _x( 'Kikidio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010109' => _x( 'Kosmio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010110' => _x( 'Pandrossos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010111' => _x( 'Sidirades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010112' => _x( 'Stylario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010201' => _x( 'Aegiros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010202' => _x( 'Arogi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010203' => _x( 'Glyfada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010204' => _x( 'Kallisti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010205' => _x( 'Meleti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010206' => _x( 'Messi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010207' => _x( 'Nea Kallisti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010208' => _x( 'Paralia Messis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010209' => _x( 'Porpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010210' => _x( 'Fanari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010301' => _x( 'Neo Sidirochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010302' => _x( 'Aghii Theodori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010303' => _x( 'Megalo Doukato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01010304' => _x( 'Pagouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020101' => _x( 'Fillyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020102' => _x( 'Agra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020103' => _x( 'Ano Drossini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020104' => _x( 'Aratos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020105' => _x( 'Ardia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020106' => _x( 'Archontika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020107' => _x( 'Vragia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020108' => _x( 'Dokos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020109' => _x( 'Drossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020110' => _x( 'Drymi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020111' => _x( 'Essochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020112' => _x( 'Kato Drossini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020113' => _x( 'Labro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020114' => _x( 'Neo Kallyntirio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020115' => _x( 'Nevra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020116' => _x( 'Omiriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020117' => _x( 'Passos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020118' => _x( 'Paterma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020119' => _x( 'Ragada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020120' => _x( 'Skiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020201' => _x( 'Arriana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020202' => _x( 'Aghiochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020203' => _x( 'Darmeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020204' => _x( 'Dilina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020205' => _x( 'Ipio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020206' => _x( 'Kinyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020207' => _x( 'Lykio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020208' => _x( 'Mikro Pisto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020209' => _x( 'Mystakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020210' => _x( 'Neda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020211' => _x( 'Nikites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020212' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020213' => _x( 'Skaloma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020214' => _x( 'Strofi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020301' => _x( 'Kechros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01020401' => _x( 'Organi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030101' => _x( 'Iasmos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030102' => _x( 'Amvrossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030103' => _x( 'Salpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030201' => _x( 'Amaxades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030301' => _x( 'Sostis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030302' => _x( 'Assomati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030303' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030304' => _x( 'Linos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030305' => _x( 'Mega Pisto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030306' => _x( 'Mischos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01030307' => _x( 'Polyantho', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040101' => _x( 'Sapes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040102' => _x( 'Amfia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040103' => _x( 'Arisvi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040104' => _x( 'Evrenos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040105' => _x( 'Iassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040106' => _x( 'Kizario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040107' => _x( 'Krovyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040108' => _x( 'Lofario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040109' => _x( 'Nea Santa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040110' => _x( 'Strymi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040201' => _x( 'Xylagani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040202' => _x( 'Amaranta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040203' => _x( 'Imeros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040204' => _x( 'Maronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040205' => _x( 'Mirana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040206' => _x( 'Pelaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR01040207' => _x( 'Proskynites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010101' => _x( 'Drama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010102' => _x( 'Kallifytos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010103' => _x( 'Kalos Agros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010104' => _x( 'Koudounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010105' => _x( 'Livadero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010106' => _x( 'Makryplagio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010107' => _x( 'Mavrovatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010108' => _x( 'Mikrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010109' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010110' => _x( 'Mylopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010111' => _x( 'Nikotsara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010112' => _x( 'Xiropotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010113' => _x( 'Choristi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010201' => _x( 'Sidironero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02010202' => _x( 'Skaloti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020101' => _x( 'Kalabaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020102' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020103' => _x( 'Kalamonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020104' => _x( 'Nerofraktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020105' => _x( 'Ftelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020201' => _x( 'Kyria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020202' => _x( 'Aghios Athanassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020203' => _x( 'Agora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020204' => _x( 'Doxato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020205' => _x( 'Kefalari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02020206' => _x( 'Pigadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030001' => _x( 'Kato Nevrokopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030002' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030003' => _x( 'Vathytopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030004' => _x( 'Volakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030005' => _x( 'Granitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030006' => _x( 'Dassoto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030007' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030008' => _x( 'Katafyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030009' => _x( 'Kato Vrontou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030010' => _x( 'Lefkogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030011' => _x( 'Mikroklissoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030012' => _x( 'Mikromilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030013' => _x( 'Ochyro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030014' => _x( 'Pagoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030015' => _x( 'Perithorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030016' => _x( 'Potami', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02030017' => _x( 'Chryssokefalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040101' => _x( 'Paranesti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040102' => _x( 'Tholos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040103' => _x( 'Sili', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040201' => _x( 'Nikiforos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040202' => _x( 'Adriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040203' => _x( 'Ano Pyxari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040204' => _x( 'Platania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040205' => _x( 'Platanovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040206' => _x( 'Ptelea Platanias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02040207' => _x( 'Ypsili Rachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050101' => _x( 'Prossotsani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050102' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050103' => _x( 'Grammeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050104' => _x( 'Kali Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050105' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050106' => _x( 'Kokkinogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050107' => _x( 'Mikropoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050108' => _x( 'Panorama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050109' => _x( 'Petroussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050110' => _x( 'Pyrgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050111' => _x( 'Charitomeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050201' => _x( 'Fotolivos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050202' => _x( 'Argyroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050203' => _x( 'Mavrolefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050204' => _x( 'Megalokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050205' => _x( 'Mikrokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050206' => _x( 'Perichora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR02050207' => _x( 'Sitagri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010101' => _x( 'Alexandroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010102' => _x( 'Avas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010103' => _x( 'Aessymi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010104' => _x( 'Kirki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010105' => _x( 'Makri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010106' => _x( 'Sykorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010201' => _x( 'Anthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010202' => _x( 'Doriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010203' => _x( 'Loutros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010204' => _x( 'Nipsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010301' => _x( 'Feres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010302' => _x( 'Ardanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010303' => _x( 'Doriskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010304' => _x( 'Kavissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010305' => _x( 'Peplos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010306' => _x( 'Pylea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03010307' => _x( 'Trifylli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020101' => _x( 'Didymoticho', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020102' => _x( 'Asvestades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020103' => _x( 'Assimenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020104' => _x( 'Ellinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020105' => _x( 'Issaakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020106' => _x( 'Karoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020107' => _x( 'Koufovouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020108' => _x( 'Kyani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020109' => _x( 'Mani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020110' => _x( 'Petrades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020111' => _x( 'Pimeniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020112' => _x( 'Pragi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020113' => _x( 'Pythio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020114' => _x( 'Sitochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020115' => _x( 'Sofiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020201' => _x( 'Metaxades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020202' => _x( 'Alepochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020203' => _x( 'Asproneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020204' => _x( 'Vryssika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020205' => _x( 'Doxa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020206' => _x( 'Elafochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020207' => _x( 'Ladi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03020208' => _x( 'Paliouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030101' => _x( 'Orestiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030102' => _x( 'Abelakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030103' => _x( 'Valtos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030104' => _x( 'Thourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030105' => _x( 'Megali Doxipara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030106' => _x( 'Neo Chimonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030107' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030108' => _x( 'Chandras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030201' => _x( 'Nea Vyssa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030202' => _x( 'Kavyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030203' => _x( 'Kastanies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030204' => _x( 'Rizia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030205' => _x( 'Sterna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030301' => _x( 'Kyprinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030302' => _x( 'Galini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030303' => _x( 'Zoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030304' => _x( 'Fylakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030401' => _x( 'Dikea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030402' => _x( 'Arzos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030403' => _x( 'Elea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030404' => _x( 'Therapio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030405' => _x( 'Komara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030406' => _x( 'Marassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030407' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030408' => _x( 'Ormenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030409' => _x( 'Pentalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030410' => _x( 'Petrota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030411' => _x( 'Plati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030412' => _x( 'Ptelea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03030413' => _x( 'Spileo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03040000' => _x( 'Samothraki (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050101' => _x( 'Soufli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050102' => _x( 'Dadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050103' => _x( 'Kornofolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050104' => _x( 'Lagyna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050105' => _x( 'Lykofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050201' => _x( 'Lavara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050202' => _x( 'Amorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050203' => _x( 'Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050204' => _x( 'Mandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050205' => _x( 'Mavrokklissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050206' => _x( 'Mikro Derio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050207' => _x( 'Protokklissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050301' => _x( 'Tychero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050302' => _x( 'Lefkimmi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050303' => _x( 'Lyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050304' => _x( 'Provatonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR03050305' => _x( 'Fylakto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010001' => _x( 'Thassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010002' => _x( 'Theologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010003' => _x( 'Kallirachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010004' => _x( 'Limenaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010005' => _x( 'Maries', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010006' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010007' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010008' => _x( 'Prinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010009' => _x( 'Rachonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR04010010' => _x( 'Sotiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010101' => _x( 'Kavala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010102' => _x( 'Nea Karvali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010103' => _x( 'Chalkero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010201' => _x( 'Krinides', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010202' => _x( 'Amygdaleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010203' => _x( 'Zygos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010204' => _x( 'Koryfes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010205' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010206' => _x( 'Limnia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010207' => _x( 'Lydia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010208' => _x( 'Palea Kavala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010209' => _x( 'Polynero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010210' => _x( 'Polystylo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05010211' => _x( 'Filippi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020101' => _x( 'Chryssoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020102' => _x( 'Avramylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020103' => _x( 'Gerontas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020104' => _x( 'Gravouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020105' => _x( 'Dialekto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020106' => _x( 'Eratino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020107' => _x( 'Zarkadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020108' => _x( 'Xerias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020109' => _x( 'Paradissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020110' => _x( 'Perni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020111' => _x( 'Petropigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020112' => _x( 'Pontolivado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020113' => _x( 'Chryssochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020201' => _x( 'Keramoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020202' => _x( 'Aghiasma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020203' => _x( 'Nea Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020204' => _x( 'Piges', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020301' => _x( 'Lekani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020302' => _x( 'Aghios Kosmas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020303' => _x( 'Dipotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020304' => _x( 'Dysvato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020305' => _x( 'Elafochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020306' => _x( 'Kechrokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020307' => _x( 'Makrychori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05020308' => _x( 'Platamonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030101' => _x( 'Eleftheroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030102' => _x( 'Amissiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030103' => _x( 'Antifilippi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030104' => _x( 'Kipia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030105' => _x( 'Kokkinochoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030106' => _x( 'Chryssokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030201' => _x( 'Nea Peramos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030202' => _x( 'Aghios Andreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030203' => _x( 'Eleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030204' => _x( 'Eleftheres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030205' => _x( 'Myrtofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030206' => _x( 'Nea Iraklitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030207' => _x( 'Folia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030301' => _x( 'Galipsos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030302' => _x( 'Akropotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030303' => _x( 'Kariani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030304' => _x( 'Orfanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030305' => _x( 'Ofrynio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030306' => _x( 'Podochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030401' => _x( 'Nikissiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030402' => _x( 'Georgiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030403' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030501' => _x( 'Moustheni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030502' => _x( 'Avli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030503' => _x( 'Domatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030504' => _x( 'Melissokomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030505' => _x( 'Messia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030506' => _x( 'Messoropi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030507' => _x( 'Platanotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR05030508' => _x( 'Sidirochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010101' => _x( 'Xanthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010102' => _x( 'Evmiro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010103' => _x( 'Kimmeria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010201' => _x( 'Stavroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010202' => _x( 'Gerakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010203' => _x( 'Dafnonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010204' => _x( 'Karyofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010205' => _x( 'Komnina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010206' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06010207' => _x( 'Paschalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020101' => _x( 'Genissea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020102' => _x( 'Diomidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020103' => _x( 'Koutso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020104' => _x( 'Magiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020105' => _x( 'Pigadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020106' => _x( 'Polyssito', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020107' => _x( 'Selino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020108' => _x( 'Sounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020201' => _x( 'Avdira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020202' => _x( 'Mandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020203' => _x( 'Myrodato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020204' => _x( 'Nea Kessani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06020301' => _x( 'Selero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030101' => _x( 'Myki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030102' => _x( 'Echinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030103' => _x( 'Oreo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030201' => _x( 'Thermes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030301' => _x( 'Kotyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06030401' => _x( 'Satres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040001' => _x( 'Evlalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040002' => _x( 'Avato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040003' => _x( 'Galani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040004' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040005' => _x( 'Erasmio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040006' => _x( 'Magana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040007' => _x( 'Olvio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR06040008' => _x( 'Toxotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'B' => [
		'GR07010100' => _x( 'Thessaloniki (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07010201' => _x( 'Triandria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07020101' => _x( 'Abelokipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07020201' => _x( 'Menemeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030101' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030102' => _x( 'Ano Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030103' => _x( 'Volvi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030201' => _x( 'Asprovalta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030202' => _x( 'Vrasna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030301' => _x( 'Nea Apollonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030302' => _x( 'Melissourgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030303' => _x( 'Nikomidino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030304' => _x( 'Peristerona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030305' => _x( 'Stivos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030401' => _x( 'Arethoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030402' => _x( 'Mavrouda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030403' => _x( 'Skepasto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030404' => _x( 'Stefanina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030405' => _x( 'Filadelfio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030501' => _x( 'Profitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030502' => _x( 'Evaghelismos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030503' => _x( 'Nymfopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030504' => _x( 'Scholario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030601' => _x( 'Nea Madytos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030602' => _x( 'Apollonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07030603' => _x( 'Modio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040101' => _x( 'Sindos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040102' => _x( 'Diavata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040103' => _x( 'Kalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040104' => _x( 'Nea Magnissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040201' => _x( 'Kymina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040202' => _x( 'Vrachia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040203' => _x( 'Nea Malgara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040301' => _x( 'Chalastra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07040302' => _x( 'Anatoliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050101' => _x( 'Perea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050102' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050103' => _x( 'Nei Epivates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050201' => _x( 'Epanomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050202' => _x( 'Messimeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050301' => _x( 'Nea Michaniona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050302' => _x( 'Aghelochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07050303' => _x( 'Nea Kerassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060101' => _x( 'Thermi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060102' => _x( 'Nea Redestos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060103' => _x( 'Neo Ryssio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060104' => _x( 'Tagarades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060201' => _x( 'Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060203' => _x( 'Aghios Antonios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060204' => _x( 'Livadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060205' => _x( 'Peristera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060206' => _x( 'Souroti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060301' => _x( 'Trilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060302' => _x( 'Kardia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060303' => _x( 'Kato Scholari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07060304' => _x( 'Plagiari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07070000' => _x( 'Kalamaria (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07080101' => _x( 'Evosmos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07080201' => _x( 'Eleftherio - Kordelio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090101' => _x( 'Lagadas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090102' => _x( 'Analipsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090103' => _x( 'Iraklio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090104' => _x( 'Kavallari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090105' => _x( 'Kolchiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090106' => _x( 'Lagyna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090107' => _x( 'Perivolaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090108' => _x( 'Chryssavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090201' => _x( 'Assiros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090202' => _x( 'Krithia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090301' => _x( 'Ossa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090302' => _x( 'Vertiskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090303' => _x( 'Exalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090304' => _x( 'Lofiskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090401' => _x( 'Zagliveri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090402' => _x( 'Adam', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090403' => _x( 'Nei Kalindii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090404' => _x( 'Petrokerassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090405' => _x( 'Sarakina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090501' => _x( 'Gerakarou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090502' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090503' => _x( 'Ardameri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090504' => _x( 'Vassiloudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090505' => _x( 'Lagadikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090601' => _x( 'Xylopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090602' => _x( 'Karteres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090603' => _x( 'Lachanas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090604' => _x( 'Lefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090605' => _x( 'Nikopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090701' => _x( 'Sochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090702' => _x( 'Askos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07090703' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07100101' => _x( 'Sykies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07100201' => _x( 'Aghios Pavlos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07100301' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07100401' => _x( 'Pefka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07110101' => _x( 'Stavroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07110201' => _x( 'Efkarpia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07110301' => _x( 'Polichni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120101' => _x( 'Panorama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120201' => _x( 'Pylea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120301' => _x( 'Asvestochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120302' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120303' => _x( 'Filyro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07120304' => _x( 'Chortiatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130101' => _x( 'Koufalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130102' => _x( 'Prochoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130201' => _x( 'Aghios Athanassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130202' => _x( 'Anchialos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130203' => _x( 'Vathylakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130204' => _x( 'Gefyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130205' => _x( 'Nea Messimvria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130206' => _x( 'Xirochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130301' => _x( 'Chalkidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130302' => _x( 'Adendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130303' => _x( 'Valtochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130304' => _x( 'Eleoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130305' => _x( 'Mikro Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07130306' => _x( 'Parthenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140101' => _x( 'Oreokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140201' => _x( 'Pentalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140202' => _x( 'Messeo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140203' => _x( 'Nea Philadelfia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140204' => _x( 'Neochorouda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140301' => _x( 'Liti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140302' => _x( 'Drymos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR07140303' => _x( 'Melissochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010101' => _x( 'Veria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010102' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010103' => _x( 'Ammos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010104' => _x( 'Assomata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010105' => _x( 'Georgiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010106' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010107' => _x( 'Kato Vermio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010108' => _x( 'Koumaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010109' => _x( 'Profitis Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010110' => _x( 'Rachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010111' => _x( 'Tripotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010201' => _x( 'Makrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010202' => _x( 'Diavatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010203' => _x( 'Kouloura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010204' => _x( 'Lykoyanni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010205' => _x( 'Nea Nikomidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010301' => _x( 'Vergina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010302' => _x( 'Metochi Prodromou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010303' => _x( 'Palatitsia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010304' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010401' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010402' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010403' => _x( 'Patrida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010404' => _x( 'Trilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010405' => _x( 'Fytia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010501' => _x( 'Rizomata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010502' => _x( 'Daskio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010503' => _x( 'Polydendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08010504' => _x( 'Sfikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020101' => _x( 'Alexandria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020102' => _x( 'Vryssaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020103' => _x( 'Kabochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020104' => _x( 'Loutros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020105' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020106' => _x( 'Nissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020201' => _x( 'Kavassila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020202' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020203' => _x( 'Kefalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020204' => _x( 'Xechasmeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020205' => _x( 'Paleo Skyllitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020206' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020301' => _x( 'Meliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020302' => _x( 'Agathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020303' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020304' => _x( 'Neokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020305' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020401' => _x( 'Platy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020402' => _x( 'Arachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020403' => _x( 'Klidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020404' => _x( 'Koryfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020405' => _x( 'Lianovergi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020406' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020407' => _x( 'Prassinada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08020408' => _x( 'Trikala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030101' => _x( 'Naoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030102' => _x( 'Arkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030103' => _x( 'Giannakochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030104' => _x( 'Rodochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030105' => _x( 'Stenimachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030201' => _x( 'Kopanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030202' => _x( 'Episkopi Naoussas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030203' => _x( 'Lefkadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030204' => _x( 'Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030205' => _x( 'Monospita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030206' => _x( 'Chariessa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030301' => _x( 'Aghelochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030302' => _x( 'Zervochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR08030303' => _x( 'Polyplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010101' => _x( 'Kilkis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010102' => _x( 'Vaptistis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010103' => _x( 'Kastanies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010104' => _x( 'Kristoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010105' => _x( 'Lipsydrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010106' => _x( 'Megali Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010107' => _x( 'Melanthio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010108' => _x( 'Messiano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010109' => _x( 'Stavrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010110' => _x( 'Chorygio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010201' => _x( 'Kabanis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010202' => _x( 'Gallikos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010203' => _x( 'Mandres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010204' => _x( 'Nea Santa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010205' => _x( 'Pedino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010206' => _x( 'Chryssopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010301' => _x( 'Drossato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010302' => _x( 'Akritas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010303' => _x( 'Amaranta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010401' => _x( 'Terpyllos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010402' => _x( 'Aghios Markos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010403' => _x( 'Anavryto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010404' => _x( 'Antigonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010405' => _x( 'Vathi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010406' => _x( 'Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010407' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010408' => _x( 'Eptalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010409' => _x( 'Efkarpia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010410' => _x( 'Theodossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010411' => _x( 'Issoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010412' => _x( 'Kato Theodorakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010413' => _x( 'Kentriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010414' => _x( 'Kiladio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010415' => _x( 'Kokkinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010416' => _x( 'Koronouda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010417' => _x( 'Pontokerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010418' => _x( 'Tripotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010419' => _x( 'Fyska', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010501' => _x( 'Stathmos Mourion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010502' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010503' => _x( 'Mouries', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010504' => _x( 'Myriofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010601' => _x( 'Mikrokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010602' => _x( 'Anthofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010603' => _x( 'Mavroneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010604' => _x( 'Neo Aghioneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010605' => _x( 'Neo Gynekokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010606' => _x( 'Xylokeratea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010607' => _x( 'Paleo Aghioneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010701' => _x( 'Cherso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010702' => _x( 'Iliolousto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010703' => _x( 'Megali Sterna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09010704' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020101' => _x( 'Polykastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020102' => _x( 'Axiochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020103' => _x( 'Aspros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020104' => _x( 'Vafiochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020105' => _x( 'Eiriniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020106' => _x( 'Evzoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020107' => _x( 'Korona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020108' => _x( 'Limnotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020109' => _x( 'Mikro Dassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020110' => _x( 'Pefkodassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020111' => _x( 'Pontoiraklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020201' => _x( 'Axioupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020202' => _x( 'Gorgopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020203' => _x( 'Eidomeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020204' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020205' => _x( 'Ryzia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020206' => _x( 'Skra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020207' => _x( 'Fanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020301' => _x( 'Goumenissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020302' => _x( 'Griva', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020303' => _x( 'Karpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020304' => _x( 'Kastaneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020305' => _x( 'Pentalofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020306' => _x( 'Stathis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020307' => _x( 'Filyria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020401' => _x( 'Evropos ', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020402' => _x( 'Aghios Petros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020403' => _x( 'Messia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020404' => _x( 'Polypetro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020405' => _x( 'Touba', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR09020501' => _x( 'Livadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010101' => _x( 'Edessa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010102' => _x( 'Agras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010103' => _x( 'Vryta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010104' => _x( 'Karydia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010105' => _x( 'Messimeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010106' => _x( 'Nissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010107' => _x( 'Platani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010108' => _x( 'Rizari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010109' => _x( 'Sotira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010110' => _x( 'Flamouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010201' => _x( 'Arnissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010202' => _x( 'Aghios Athanassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010203' => _x( 'Grammatiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010204' => _x( 'Panagitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10010205' => _x( 'Perea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020101' => _x( 'Aridea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020102' => _x( 'Aloros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020103' => _x( 'Apsalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020104' => _x( 'Vorino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020105' => _x( 'Garefio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020106' => _x( 'Dorothea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020107' => _x( 'Loutraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020108' => _x( 'Lykostomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020109' => _x( 'Megaplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020110' => _x( 'Xifiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020111' => _x( 'Orma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020112' => _x( 'Piperies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020113' => _x( 'Polykarpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020114' => _x( 'Promachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020115' => _x( 'Sarakini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020116' => _x( 'Sossandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020117' => _x( 'Tsaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020201' => _x( 'Exaplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020202' => _x( 'Archaghelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020203' => _x( 'Theodorakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020204' => _x( 'Thiriopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020205' => _x( 'Ida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020206' => _x( 'Konstantia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020207' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020208' => _x( 'Neromyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020209' => _x( 'Notia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020210' => _x( 'Periklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020211' => _x( 'Filotia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020212' => _x( 'Foustani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10020213' => _x( 'Chryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030101' => _x( 'Giannitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030102' => _x( 'Abelies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030103' => _x( 'Melissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030201' => _x( 'Krya Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030202' => _x( 'Aghios Loukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030203' => _x( 'Akrolimni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030204' => _x( 'Essovalta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030301' => _x( 'Mylotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030302' => _x( 'Axos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030303' => _x( 'Aravissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030304' => _x( 'Achladochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030305' => _x( 'Lakka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030306' => _x( 'Paleos Mylotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030307' => _x( 'Plagiari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030401' => _x( 'Galatades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030402' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030403' => _x( 'Drossero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030404' => _x( 'Karyotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030405' => _x( 'Liparo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030406' => _x( 'Palefyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030407' => _x( 'Trifylli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030501' => _x( 'Pella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030502' => _x( 'Agrossykea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030503' => _x( 'Athyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030504' => _x( 'Dytiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030505' => _x( 'Nea Pella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10030506' => _x( 'Rachona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040101' => _x( 'Skydra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040102' => _x( 'Arsenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040103' => _x( 'Aspro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040104' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040105' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040106' => _x( 'Lipochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040107' => _x( 'Mavrovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040108' => _x( 'Nea Zoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040109' => _x( 'Petrea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040110' => _x( 'Rizo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040111' => _x( 'Sevastiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040201' => _x( 'Kali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040202' => _x( 'Anydro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040203' => _x( 'Kallipoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040204' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040205' => _x( 'Mandalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR10040206' => _x( 'Profitis Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010101' => _x( 'Katerini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010102' => _x( 'Ano Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010103' => _x( 'Ganochora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010104' => _x( 'Neokessaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010105' => _x( 'Svoronos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010201' => _x( 'Paleo Keramidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010202' => _x( 'Aronas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010203' => _x( 'Elafos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010204' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010205' => _x( 'Katalonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010206' => _x( 'Lagorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010207' => _x( 'Moschopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010208' => _x( 'Trilofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010301' => _x( 'Korinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010302' => _x( 'Kato Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010303' => _x( 'Koukkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010304' => _x( 'Nea Trapezounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010305' => _x( 'Sevasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010401' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010402' => _x( 'Paralia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010403' => _x( 'Peristassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010501' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010502' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010503' => _x( 'Lofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010504' => _x( 'Moschochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010505' => _x( 'Fotina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010601' => _x( 'Ritini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010602' => _x( 'Vria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11010603' => _x( 'Elatochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020101' => _x( 'Litochoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020201' => _x( 'Leptokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020202' => _x( 'Panteleimonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020203' => _x( 'Platamonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020204' => _x( 'Pori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020205' => _x( 'Skotina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020301' => _x( 'Kontariotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020302' => _x( 'Aghios Spyridonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020303' => _x( 'Vrontou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020304' => _x( 'Dion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020305' => _x( 'Karitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11020306' => _x( 'Nea Efessos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030101' => _x( 'Aeginio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030102' => _x( 'Katachas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030201' => _x( 'Kolindros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030202' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030203' => _x( 'Livadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030204' => _x( 'Ryakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030301' => _x( 'Makrygialos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030302' => _x( 'Methoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030303' => _x( 'Nea Agathoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030304' => _x( 'Paleo Eleftherochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030401' => _x( 'Pydna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030402' => _x( 'Alonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030403' => _x( 'Paleostani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR11030404' => _x( 'Sfendamio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010101' => _x( 'Serres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010102' => _x( 'Eleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010103' => _x( 'Eptamyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010104' => _x( 'Oinoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010201' => _x( 'Ano Vrontou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010301' => _x( 'Provatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010302' => _x( 'Anagennissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010303' => _x( 'Ano Kamila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010304' => _x( 'Vamvakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010305' => _x( 'Mitroussio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010306' => _x( 'Monoklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010401' => _x( 'Lefkonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010402' => _x( 'Kala Dendra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010403' => _x( 'Christos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010501' => _x( 'Orini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010601' => _x( 'Skoutari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010602' => _x( 'Aghia Eleni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010603' => _x( 'Adelfiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010604' => _x( 'Vamvakoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010605' => _x( 'Kato Kamila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010606' => _x( 'Kouvouklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010607' => _x( 'Koumaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010608' => _x( 'Konstantinato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12010609' => _x( 'Peponia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020101' => _x( 'Rodolivos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020102' => _x( 'Domiros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020103' => _x( 'Mikro Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020201' => _x( 'Paleokomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020202' => _x( 'Amfipoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020203' => _x( 'Messolakkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020204' => _x( 'Nea Kerdylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020301' => _x( 'Nea Bafra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020302' => _x( 'Iliokomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020303' => _x( 'Kormista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020304' => _x( 'Symvoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020401' => _x( 'Proti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020402' => _x( 'Aghista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12020403' => _x( 'Krinida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030101' => _x( 'Nigrita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030102' => _x( 'Anthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030103' => _x( 'Therma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030104' => _x( 'Terpni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030105' => _x( 'Flabouro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030201' => _x( 'Sitochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030202' => _x( 'Achinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030203' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030204' => _x( 'Zervochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030205' => _x( 'Lefkotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030206' => _x( 'Patrikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030207' => _x( 'Choumniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030301' => _x( 'Dimitritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030302' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030303' => _x( 'Abeli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030304' => _x( 'Vergi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030305' => _x( 'Lygaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030306' => _x( 'Nikoklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030307' => _x( 'Sissamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030308' => _x( 'Triantafyllia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030401' => _x( 'Mavrothalassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030402' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030403' => _x( 'Aidonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030404' => _x( 'Efkarpia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030405' => _x( 'Ivira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030406' => _x( 'Kastanochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12030407' => _x( 'Traghilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040101' => _x( 'Chrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040102' => _x( 'Aghio Pnevma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040103' => _x( 'Dafnoudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040104' => _x( 'Emmanuel Pappas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040105' => _x( 'Metalla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040106' => _x( 'Neo Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040107' => _x( 'Pentapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040108' => _x( 'Touba', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040201' => _x( 'Neos Skopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040202' => _x( 'Valtotopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040203' => _x( 'Messokomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040204' => _x( 'Monovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040205' => _x( 'Neochori Serron', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040206' => _x( 'Paralimnio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040207' => _x( 'Pethelinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12040208' => _x( 'Psychiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050101' => _x( 'Iraklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050102' => _x( 'Valtero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050103' => _x( 'Dassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050104' => _x( 'Karperi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050105' => _x( 'Kimissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050106' => _x( 'Lithotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050107' => _x( 'Limnochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050108' => _x( 'Pontismeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050109' => _x( 'Chryssochorafa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050201' => _x( 'Skotoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050202' => _x( 'Ammoudia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050203' => _x( 'Gefyroudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050204' => _x( 'Melenikitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050205' => _x( 'Nea Tyroloi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050206' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050301' => _x( 'Strymoniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050302' => _x( 'Zevgolatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050303' => _x( 'Kalokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050304' => _x( 'Livadochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050305' => _x( 'Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12050306' => _x( 'Chimarros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060101' => _x( 'Nea Zichni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060102' => _x( 'Aghios Christoforos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060103' => _x( 'Agriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060104' => _x( 'Anastassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060105' => _x( 'Gazoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060106' => _x( 'Dimitra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060107' => _x( 'Draviskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060108' => _x( 'Tholos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060109' => _x( 'Mavrolofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060110' => _x( 'Messorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060111' => _x( 'Myrkinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060112' => _x( 'Myrrini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060113' => _x( 'Nea Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060114' => _x( 'Sfelinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060201' => _x( 'Alistrati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060202' => _x( 'Aghiochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060203' => _x( 'Lefkothea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060204' => _x( 'Mandilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060205' => _x( 'Skopia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12060206' => _x( 'Stathmos Aghistis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070101' => _x( 'Sidirokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070102' => _x( 'Vamvakofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070103' => _x( 'Kamaroto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070104' => _x( 'Strymonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070105' => _x( 'Charopo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070106' => _x( 'Chortero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070201' => _x( 'Aghistro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070301' => _x( 'Achladochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070302' => _x( 'Kapnofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070401' => _x( 'Rodopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070402' => _x( 'Anatoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070403' => _x( 'Ano Poroia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070404' => _x( 'Kastanoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070405' => _x( 'Kato Poroia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070406' => _x( 'Kerkini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070407' => _x( 'Livadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070408' => _x( 'Makrinitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070409' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070410' => _x( 'Platanakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070501' => _x( 'Neo Petritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070502' => _x( 'Akritochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070503' => _x( 'Vyronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070504' => _x( 'Gonimo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070505' => _x( 'Mandraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070506' => _x( 'Megalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR12070601' => _x( 'Promachonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010101' => _x( 'Polygyros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010102' => _x( 'Aghios Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010103' => _x( 'Vrastama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010104' => _x( 'Olynthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010105' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010106' => _x( 'Sana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010107' => _x( 'Taxiarchis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010201' => _x( 'Galatista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010202' => _x( 'Vavdos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010203' => _x( 'Galarinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010204' => _x( 'Doubia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010301' => _x( 'Paleochora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010302' => _x( 'Geroplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010303' => _x( 'Krimni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010304' => _x( 'Marathoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010305' => _x( 'Riza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010401' => _x( 'Ormylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13010402' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020101' => _x( 'Ierissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020102' => _x( 'Ammouliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020103' => _x( 'Nea Roda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020104' => _x( 'Olympiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020105' => _x( 'Ouranopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020106' => _x( 'Stagira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020107' => _x( 'Stratoniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020108' => _x( 'Stratoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020201' => _x( 'Arnea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020202' => _x( 'Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020203' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020204' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020205' => _x( 'Stanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020301' => _x( 'Megali Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020302' => _x( 'Gomati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13020303' => _x( 'Pyrgadikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030101' => _x( 'Kassandria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030102' => _x( 'Afytos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030103' => _x( 'Kalandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030104' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030105' => _x( 'Kassandrino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030106' => _x( 'Kryopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030107' => _x( 'Nea Fokea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030108' => _x( 'Fourka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030201' => _x( 'Chaniotis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030203' => _x( 'Nea Skioni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030204' => _x( 'Paliouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030205' => _x( 'Pefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13030206' => _x( 'Polychrono', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040101' => _x( 'Nea Moudania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040102' => _x( 'Aghios Mamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040103' => _x( 'Aghios Panteleimonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040104' => _x( 'Dionyssiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040105' => _x( 'Zografou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040106' => _x( 'Nea Potidea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040107' => _x( 'Portaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040108' => _x( 'Simantra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040109' => _x( 'Flogita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040201' => _x( 'Nea Kallikratia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040202' => _x( 'Aghios Pavlos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040203' => _x( 'Lakkoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040204' => _x( 'Nea Gonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040205' => _x( 'Nea Silata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040301' => _x( 'Nea Triglia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040302' => _x( 'Eleochoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040303' => _x( 'Krini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040304' => _x( 'Nea Tenedos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040305' => _x( 'Nea Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13040306' => _x( 'Petralona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050101' => _x( 'Nikiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050102' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050103' => _x( 'Metagitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050104' => _x( 'Neos Marmaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050201' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR13050202' => _x( 'Sarti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'C' => [
		'GR14010101' => _x( 'Kozani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010102' => _x( 'Alonakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010103' => _x( 'Anthotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010104' => _x( 'Argilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010105' => _x( 'Vatero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010106' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010107' => _x( 'Kalamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010108' => _x( 'Karyditsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010109' => _x( 'Kila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010110' => _x( 'Lefkovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010111' => _x( 'Lefkopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010112' => _x( 'Lygeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010113' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010114' => _x( 'Nea Nikopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010115' => _x( 'Xirolimni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010116' => _x( 'Inoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010117' => _x( 'Petrana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010118' => _x( 'Protochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010119' => _x( 'Ptelea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010120' => _x( 'Skiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010121' => _x( 'Charavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010201' => _x( 'Eani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010203' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010204' => _x( 'Ktenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010205' => _x( 'Rodiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010206' => _x( 'Rymnio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010207' => _x( 'Chromio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010301' => _x( 'Mavrodendri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010302' => _x( 'Livera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010303' => _x( 'Pontokomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010304' => _x( 'Sideras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010401' => _x( 'Krokos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010402' => _x( 'Amygdalea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010403' => _x( 'Ano Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010404' => _x( 'Kessaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010405' => _x( 'Kato Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010406' => _x( 'Kontovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010407' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010408' => _x( 'Sparto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010501' => _x( 'Kilada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010502' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010503' => _x( 'Aghios Charalabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010504' => _x( 'Akrini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010505' => _x( 'Avgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010506' => _x( 'Voskochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010507' => _x( 'Drepano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010508' => _x( 'Kapnochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010509' => _x( 'Klitos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010510' => _x( 'Polymylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010511' => _x( 'Ryaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14010512' => _x( 'Tetralofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020101' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020102' => _x( 'Aidonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020103' => _x( 'Aliakmonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020104' => _x( 'Axiokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020105' => _x( 'Asproula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020106' => _x( 'Velanidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020107' => _x( 'Dryovouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020108' => _x( 'Lefkothea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020109' => _x( 'Messologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020110' => _x( 'Molocha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020111' => _x( 'Peponia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020112' => _x( 'Peristera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020113' => _x( 'Platania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020114' => _x( 'Polylakko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020115' => _x( 'Pylorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020116' => _x( 'Simantro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020117' => _x( 'Skalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020118' => _x( 'Trapezitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020119' => _x( 'Chimerino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020120' => _x( 'Chorigos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020201' => _x( 'Kaloneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020202' => _x( 'Galatini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020203' => _x( 'Eratyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020204' => _x( 'Namata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020205' => _x( 'Pelekanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020206' => _x( 'Sissanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020301' => _x( 'Pentalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020302' => _x( 'Aghia Sotira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020303' => _x( 'Vythos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020304' => _x( 'Dilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020401' => _x( 'Siatista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020402' => _x( 'Mikrokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020403' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020501' => _x( 'Tsotyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020502' => _x( 'Aghiasma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020503' => _x( 'Aghii Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020504' => _x( 'Anthoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020505' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020506' => _x( 'Avgerinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020507' => _x( 'Vouchorina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020508' => _x( 'Vronti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020509' => _x( 'Damaskinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020510' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020511' => _x( 'Dichimarro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020512' => _x( 'Dragassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020513' => _x( 'Zoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020514' => _x( 'Klissoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020515' => _x( 'Koryfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020516' => _x( 'Kriminio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020517' => _x( 'Liknades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020518' => _x( 'Louvri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020519' => _x( 'Loukomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020520' => _x( 'Morfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020521' => _x( 'Omali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020522' => _x( 'Plakida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020523' => _x( 'Polykastano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020524' => _x( 'Rodochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020525' => _x( 'Stavrodromi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14020526' => _x( 'Chryssavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030101' => _x( 'Ptolemaida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030102' => _x( 'Asvestopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030103' => _x( 'Galatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030104' => _x( 'Drossero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030105' => _x( 'Kardia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030106' => _x( 'Komanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030107' => _x( 'Mavropigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030108' => _x( 'Olympiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030109' => _x( 'Pentavryssos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030110' => _x( 'Perdikkas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030111' => _x( 'Proastio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030112' => _x( 'Pteleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030201' => _x( 'Aghios Christoforos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030202' => _x( 'Ermakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030203' => _x( 'Karyochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030204' => _x( 'Spilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030301' => _x( 'Komnina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030302' => _x( 'Anatoliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030303' => _x( 'Messovouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030304' => _x( 'Pyrgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030401' => _x( 'Vlasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030501' => _x( 'Emporio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030502' => _x( 'Anarrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030503' => _x( 'Ardassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030504' => _x( 'Milochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14030505' => _x( 'Foufas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040101' => _x( 'Servia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040102' => _x( 'Avles', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040103' => _x( 'Vathylakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040104' => _x( 'Goules', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040105' => _x( 'Imera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040106' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040107' => _x( 'Kranidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040108' => _x( 'Lefkara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040109' => _x( 'Messiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040110' => _x( 'Metaxas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040111' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040112' => _x( 'Platanorrevma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040113' => _x( 'Polyrracho', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040114' => _x( 'Roditis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040115' => _x( 'Trigoniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040201' => _x( 'Velvendos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040202' => _x( 'Aghia Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040203' => _x( 'Katafygio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040204' => _x( 'Polyfyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040301' => _x( 'Tranovalto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040302' => _x( 'Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040303' => _x( 'Mikrovalto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR14040401' => _x( 'Livadero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010101' => _x( 'Grevena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010102' => _x( 'Aghii Theodori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010103' => _x( 'Amygdalies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010104' => _x( 'Vatolakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010105' => _x( 'Elatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010106' => _x( 'Elefthero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010107' => _x( 'Kalochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010108' => _x( 'Kyrakali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010109' => _x( 'Mega Sirinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010110' => _x( 'Myrsina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010111' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010112' => _x( 'Syndendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010113' => _x( 'Fellio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010201' => _x( 'Avdella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010301' => _x( 'Megaro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010302' => _x( 'Aghios Kosmas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010303' => _x( 'Dassylio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010304' => _x( 'Kalirachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010305' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010306' => _x( 'Kydonies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010307' => _x( 'Kyparissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010308' => _x( 'Oropedio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010309' => _x( 'Trikorfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010401' => _x( 'Knidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010402' => _x( 'Exarchos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010403' => _x( 'Kentro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010404' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010405' => _x( 'Pontini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010406' => _x( 'Pylori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010407' => _x( 'Sarakina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010501' => _x( 'Kipourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010502' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010503' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010504' => _x( 'Mikrolivado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010505' => _x( 'Pigaditsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010506' => _x( 'Sitaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010601' => _x( 'Dotsiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010701' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010702' => _x( 'Aidonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010703' => _x( 'Kivotos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010704' => _x( 'Klimataki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010705' => _x( 'Kokkinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010706' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010707' => _x( 'Polydendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010708' => _x( 'Taxiarchis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010801' => _x( 'Mavranei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010802' => _x( 'Alatopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010803' => _x( 'Anavryta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010804' => _x( 'Ziakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010805' => _x( 'Kosmati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010806' => _x( 'Lavdas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010807' => _x( 'Monachitio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010808' => _x( 'Panorama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010809' => _x( 'Polyneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010810' => _x( 'Prosvoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010811' => _x( 'Spileo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010812' => _x( 'Trikomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15010901' => _x( 'Messolourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15011001' => _x( 'Perivoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15011101' => _x( 'Samarina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15011201' => _x( 'Smixi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15011301' => _x( 'Filippei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020101' => _x( 'Deskati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020102' => _x( 'Dassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020103' => _x( 'Paliouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020104' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020105' => _x( 'Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020201' => _x( 'Karpero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020202' => _x( 'Katakali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR15020203' => _x( 'Trikokkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010101' => _x( 'Kastoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010201' => _x( 'Maniaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010202' => _x( 'Avgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010203' => _x( 'Koromilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010204' => _x( 'Lefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010205' => _x( 'Omorfoklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010206' => _x( 'Pentavrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010207' => _x( 'Tsakoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010208' => _x( 'Chiliodendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010301' => _x( 'Korissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010302' => _x( 'Vassiliada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010303' => _x( 'Lithia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010304' => _x( 'Melissotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010401' => _x( 'Tichio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010402' => _x( 'Vyssinea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010403' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010404' => _x( 'Oxya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010405' => _x( 'Polykerasso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010406' => _x( 'Sidirochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010501' => _x( 'Ieropigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010502' => _x( 'Dendrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010601' => _x( 'Klissoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010701' => _x( 'Gavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010702' => _x( 'Aghios Antonios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010703' => _x( 'Kranionas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010704' => _x( 'Makrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010705' => _x( 'Mavrokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010706' => _x( 'Melas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010707' => _x( 'Chalara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010801' => _x( 'Mavrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010802' => _x( 'Dispilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010803' => _x( 'Polykarpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010901' => _x( 'Messopotamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010902' => _x( 'Aghia Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010903' => _x( 'Kalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010904' => _x( 'Inoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16010905' => _x( 'Pteria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020101' => _x( 'Nestorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020102' => _x( 'Kotyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020103' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020104' => _x( 'Ptelea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020201' => _x( 'Dipotamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020202' => _x( 'Komninades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020203' => _x( 'Polyanemo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020204' => _x( 'Chionato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020301' => _x( 'Eptachori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020302' => _x( 'Zouzouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020303' => _x( 'Chryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16020401' => _x( 'Gramos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030101' => _x( 'Argos Orestiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030102' => _x( 'Aghios Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030103' => _x( 'Ammoudara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030104' => _x( 'Asproklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030105' => _x( 'Vrachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030106' => _x( 'Dialekto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030107' => _x( 'Kastanofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030108' => _x( 'Laga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030109' => _x( 'Lakkomata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030110' => _x( 'Melanthio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030111' => _x( 'Nostimo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030112' => _x( 'Spilea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030113' => _x( 'Spilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030201' => _x( 'Vogatsiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030202' => _x( 'Abelokipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030203' => _x( 'Germas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030204' => _x( 'Kostarazi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR16030205' => _x( 'Militsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010101' => _x( 'Florina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010102' => _x( 'Alona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010103' => _x( 'Armenochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010105' => _x( 'Messonissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010106' => _x( 'Proti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010107' => _x( 'Skopia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010109' => _x( 'Simos Ioannidis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010201' => _x( 'Kato Klines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010203' => _x( 'Akritas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010204' => _x( 'Ano Kalliniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010205' => _x( 'Ano Klines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010206' => _x( 'Ethniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010207' => _x( 'Kato Kalliniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010208' => _x( 'Kladorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010209' => _x( 'Kratero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010210' => _x( 'Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010211' => _x( 'Messokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010212' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010213' => _x( 'Neos Kafkasos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010214' => _x( 'Niki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010215' => _x( 'Parorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010216' => _x( 'Polyplatano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010301' => _x( 'Neochoraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010302' => _x( 'Achlada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010303' => _x( 'Vevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010304' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010305' => _x( 'Lofi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010306' => _x( 'Meliti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010307' => _x( 'Palestra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010308' => _x( 'Pappayannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010309' => _x( 'Sitaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010310' => _x( 'Skopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010311' => _x( 'Tripotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010401' => _x( 'Perasma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010402' => _x( 'Aghios Vartholomeos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010403' => _x( 'Ammochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010404' => _x( 'Ano Ydroussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010405' => _x( 'Atrapos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010406' => _x( 'Drossopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010407' => _x( 'Kolchiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010408' => _x( 'Leptokaryes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010409' => _x( 'Polypotamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010410' => _x( 'Triantafyllia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010411' => _x( 'Tropeouchos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010412' => _x( 'Ydroussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17010413' => _x( 'Flabouro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020101' => _x( 'Amynteo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020102' => _x( 'Aghios Panteleimonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020103' => _x( 'Kella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020104' => _x( 'Klidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020105' => _x( 'Xino Nero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020106' => _x( 'Petres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020107' => _x( 'Rodonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020108' => _x( 'Fanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020201' => _x( 'Aetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020202' => _x( 'Agrapidies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020203' => _x( 'Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020204' => _x( 'Asprogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020205' => _x( 'Valtonera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020206' => _x( 'Limnochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020207' => _x( 'Pedino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020208' => _x( 'Sklithro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020301' => _x( 'Variko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020401' => _x( 'Lechovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020501' => _x( 'Nymfeo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020601' => _x( 'Filotas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020602' => _x( 'Antigonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020603' => _x( 'Vegora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020604' => _x( 'Levea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020605' => _x( 'Maniaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020606' => _x( 'Pelargos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17020607' => _x( 'Faragi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030101' => _x( 'Lemos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030102' => _x( 'Aghios Achillios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030103' => _x( 'Aghios Germanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030104' => _x( 'Antartiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030105' => _x( 'Vrontero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030106' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030107' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030108' => _x( 'Lefkonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030109' => _x( 'Mikrolimni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030110' => _x( 'Pissoderi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030111' => _x( 'Platy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030112' => _x( 'Prassino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030113' => _x( 'Psarades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030201' => _x( 'Krystallopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030202' => _x( 'Vatochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR17030203' => _x( 'Kotas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'D' => [
		'GR18010101' => _x( 'Ioannina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010102' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010103' => _x( 'Marmara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010104' => _x( 'Neochoropoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010105' => _x( 'Stavraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010201' => _x( 'Anatoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010202' => _x( 'Bafra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010203' => _x( 'Neokessaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010301' => _x( 'Pedini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010302' => _x( 'Abelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010303' => _x( 'Asvestochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010304' => _x( 'Kontsika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010305' => _x( 'Kosmira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010306' => _x( 'Manoliassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010307' => _x( 'Bizani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010401' => _x( 'Nissos Ioanninon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010501' => _x( 'Katsikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010502' => _x( 'Anatoliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010503' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010504' => _x( 'Dafnoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010505' => _x( 'Drossochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010506' => _x( 'Iliokali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010507' => _x( 'Kastritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010508' => _x( 'Koutselio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010509' => _x( 'Krapsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010510' => _x( 'Logades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010511' => _x( 'Mouzakei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010512' => _x( 'Platania ', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010513' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010514' => _x( 'Charokopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010601' => _x( 'Perama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010602' => _x( 'Amfithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010603' => _x( 'Kranoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010604' => _x( 'Krya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010605' => _x( 'Kryovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010606' => _x( 'Ligiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010607' => _x( 'Mazia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010608' => _x( 'Perivleptos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18010609' => _x( 'Spothi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020101' => _x( 'Pramanta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020102' => _x( 'Abelochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020103' => _x( 'Raftanei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020201' => _x( 'Vathypedo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020301' => _x( 'Kalarrites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020401' => _x( 'Kalentzi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020402' => _x( 'Aetorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020403' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020404' => _x( 'Koritiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020405' => _x( 'Monolithi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020406' => _x( 'Pigadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020407' => _x( 'Plessia Malakasiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020408' => _x( 'Platanoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020409' => _x( 'Fortossio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020501' => _x( 'Matsouki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020601' => _x( 'Syrrako', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020701' => _x( 'Chouliarades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020702' => _x( 'Vaptistis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020703' => _x( 'Kedros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020704' => _x( 'Michalitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020705' => _x( 'Paleochori Sirakou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020706' => _x( 'Petrovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020707' => _x( 'Potistika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18020708' => _x( 'Prossilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030101' => _x( 'Theriakissio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030102' => _x( 'Avgo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030103' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030104' => _x( 'Varlaam', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030105' => _x( 'Vouliasta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030106' => _x( 'Episkopiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030107' => _x( 'Kopani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030108' => _x( 'Kouklessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030109' => _x( 'Kryfovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030110' => _x( 'Melia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030111' => _x( 'Moussiotitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030112' => _x( 'Myrodafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030113' => _x( 'Perdika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030114' => _x( 'Pesta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030115' => _x( 'Ravenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030116' => _x( 'Serviana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030117' => _x( 'Sklivani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030118' => _x( 'Terovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030201' => _x( 'Dodoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030202' => _x( 'Aghia Anastasia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030203' => _x( 'Dragopsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030204' => _x( 'Dramessii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030205' => _x( 'Kostaniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030206' => _x( 'Mantio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030207' => _x( 'Meligi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030208' => _x( 'Polygyros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030209' => _x( 'Psina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030301' => _x( 'Derviziana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030302' => _x( 'Alepochori Botsari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030303' => _x( 'Ardossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030304' => _x( 'Achladies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030305' => _x( 'Vargiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030306' => _x( 'Georgani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030307' => _x( 'Elafos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030308' => _x( 'Bestia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030309' => _x( 'Paleochori Botsari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030310' => _x( 'Pentolakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030311' => _x( 'Romanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030312' => _x( 'Seriziana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030313' => _x( 'Sistrounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030314' => _x( 'Smyrtia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030401' => _x( 'Baoussii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030402' => _x( 'Aghios Andreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030403' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030404' => _x( 'Anthochori Dodonis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030405' => _x( 'Artopoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030406' => _x( 'Asprochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030407' => _x( 'Valanidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030408' => _x( 'Zotiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030409' => _x( 'Katamachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030410' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030411' => _x( 'Koumaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030412' => _x( 'Lippa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030413' => _x( 'Pardalitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030414' => _x( 'Platania ', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18030415' => _x( 'Seniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040101' => _x( 'Asprageli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040102' => _x( 'Aghios Minas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040103' => _x( 'Ano Pedina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040104' => _x( 'Aristi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040105' => _x( 'Vitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040106' => _x( 'Dikoryfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040107' => _x( 'Dilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040108' => _x( 'Dipotamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040109' => _x( 'Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040110' => _x( 'Elafotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040111' => _x( 'Kaloutas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040112' => _x( 'Kato Pedina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040113' => _x( 'Manassis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040114' => _x( 'Messovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040115' => _x( 'Monodendri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040201' => _x( 'Dematio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040203' => _x( 'Anthrakitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040204' => _x( 'Grevenitio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040205' => _x( 'Doliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040206' => _x( 'Elatochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040207' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040208' => _x( 'Kavallari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040209' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040210' => _x( 'Kastanonas Zagoriou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040211' => _x( 'Makrino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040212' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040213' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040214' => _x( 'Tristeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040215' => _x( 'Flabourari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040301' => _x( 'Vovoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040401' => _x( 'Papigo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040501' => _x( 'Tsepelovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040502' => _x( 'Vradeto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040503' => _x( 'Vryssochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040504' => _x( 'Iliochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040505' => _x( 'Kapessovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040506' => _x( 'Kipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040507' => _x( 'Koukkouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040508' => _x( 'Laista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040509' => _x( 'Leptokarya Zagoriou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040510' => _x( 'Negades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040511' => _x( 'Skamnelli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18040512' => _x( 'Fragades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050101' => _x( 'Eleoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050102' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050103' => _x( 'Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050104' => _x( 'Ano Lapsista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050105' => _x( 'Vageniti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050106' => _x( 'Vounoplagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050107' => _x( 'Grammeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050108' => _x( 'Zoodochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050109' => _x( 'Kato Lapsista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050110' => _x( 'Lofiskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050111' => _x( 'Lygos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050112' => _x( 'Mega Gardiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050113' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050114' => _x( 'Peratis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050115' => _x( 'Petralona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050116' => _x( 'Polylofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050117' => _x( 'Rodotopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050201' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050202' => _x( 'Asfaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050203' => _x( 'Vatatades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050204' => _x( 'Vlachatano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050205' => _x( 'Gavrissii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050206' => _x( 'Ligopsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050207' => _x( 'Petsalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050301' => _x( 'Klimatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050302' => _x( 'Vassilopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050303' => _x( 'Delvinakopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050304' => _x( 'Kokkinochoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050305' => _x( 'Lefkothea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050306' => _x( 'Paliouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050307' => _x( 'Raiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050308' => _x( 'Soulopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050401' => _x( 'Zitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050402' => _x( 'Dafnofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050403' => _x( 'Karitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050404' => _x( 'Lithino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050405' => _x( 'Protopappas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050501' => _x( 'Voutsaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050502' => _x( 'Aetopetra Dodonis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050503' => _x( 'Vereniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050504' => _x( 'Vrossina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050505' => _x( 'Vryssoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050506' => _x( 'Giurganista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050507' => _x( 'Gribovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050508' => _x( 'Granitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050509' => _x( 'Granitsopoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050510' => _x( 'Despotiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050511' => _x( 'Dovla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050512' => _x( 'Eklissochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050513' => _x( 'Zalogo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050514' => _x( 'Kalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050515' => _x( 'Kourenta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050516' => _x( 'Polydoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050517' => _x( 'Radovizio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050518' => _x( 'Rizo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050519' => _x( 'Fotino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18050520' => _x( 'Chinka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060101' => _x( 'Konitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060102' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060103' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060104' => _x( 'Aetopetra Konitsas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060105' => _x( 'Aidonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060106' => _x( 'Amarantos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060107' => _x( 'Armata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060108' => _x( 'Ganadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060109' => _x( 'Elefthero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060110' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060111' => _x( 'Iliorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060112' => _x( 'Kavassila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060113' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060114' => _x( 'Klidonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060115' => _x( 'Mazi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060116' => _x( 'Melissopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060117' => _x( 'Molista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060118' => _x( 'Molyvdoskepastos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060119' => _x( 'Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060120' => _x( 'Nikanor', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060121' => _x( 'Pades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060122' => _x( 'Paleosselli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060123' => _x( 'Pigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060124' => _x( 'Pournia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060125' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060201' => _x( 'Aetomilitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060301' => _x( 'Distrato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060401' => _x( 'Pyrsoyanni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060402' => _x( 'Assimochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060403' => _x( 'Vourbiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060404' => _x( 'Gorgopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060405' => _x( 'Drossopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060406' => _x( 'Kastaniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060407' => _x( 'Kefalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060408' => _x( 'Lagada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060409' => _x( 'Oxya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060410' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060411' => _x( 'Plikatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060412' => _x( 'Chionades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18060501' => _x( 'Fourka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070101' => _x( 'Metsovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070102' => _x( 'Anilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070103' => _x( 'Anthochori Metsovou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070104' => _x( 'Votonossio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070201' => _x( 'Mikro Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070202' => _x( 'Megali Gotista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070203' => _x( 'Mega Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070204' => _x( 'Mikri Gotista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070205' => _x( 'Sitsena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070206' => _x( 'Chryssovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18070301' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080101' => _x( 'Kalpaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080102' => _x( 'Ano Ravenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080103' => _x( 'Geroplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080104' => _x( 'Doliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080105' => _x( 'Kato Ravenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080106' => _x( 'Mavrovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080107' => _x( 'Negrades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080108' => _x( 'Chryssorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080201' => _x( 'Parakalamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080202' => _x( 'Areti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080203' => _x( 'Vrontismeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080204' => _x( 'Ieromnimi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080205' => _x( 'Katarraktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080206' => _x( 'Kouklii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080207' => _x( 'Mazaraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080208' => _x( 'Mavronoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080209' => _x( 'Repetista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080210' => _x( 'Riachovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080211' => _x( 'Sitaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080301' => _x( 'Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080302' => _x( 'Aghios Kosmas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080303' => _x( 'Vassiliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080304' => _x( 'Kakolakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080305' => _x( 'Kato Meropi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080306' => _x( 'Meropi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080307' => _x( 'Paleopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080308' => _x( 'Roupsia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080309' => _x( 'Oreokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080401' => _x( 'Delvinaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080402' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080403' => _x( 'Argyrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080404' => _x( 'Vissani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080405' => _x( 'Kastaniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080406' => _x( 'Kerassovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080407' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080408' => _x( 'Ktismata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080409' => _x( 'Limni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080410' => _x( 'Mavropoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080411' => _x( 'Orino Xirovaltou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080412' => _x( 'Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080413' => _x( 'Pontikates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080414' => _x( 'Stratinista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080415' => _x( 'Teriachio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080416' => _x( 'Faragi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080417' => _x( 'Charavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080501' => _x( 'Lavdani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080502' => _x( 'Dimokorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080601' => _x( 'Pogoniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080602' => _x( 'Dolo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080603' => _x( 'Drymades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR18080604' => _x( 'Stavroskiadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010101' => _x( 'Arta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010102' => _x( 'Keramates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010103' => _x( 'Kostakii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010104' => _x( 'Limini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010201' => _x( 'Aneza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010202' => _x( 'Vigla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010203' => _x( 'Gavria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010204' => _x( 'Kalogeriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010205' => _x( 'Koronissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010206' => _x( 'Polydrosso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010207' => _x( 'Rachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010208' => _x( 'Strogyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010209' => _x( 'Psathotopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010301' => _x( 'Grammenitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010302' => _x( 'Vlacherna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010303' => _x( 'Gribovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010304' => _x( 'Korfovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010401' => _x( 'Ammotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010402' => _x( 'Dafnoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010403' => _x( 'Kabi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010404' => _x( 'Pantanassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010405' => _x( 'Pistiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010406' => _x( 'Rodavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010407' => _x( 'Skoupa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010408' => _x( 'Faneromeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010501' => _x( 'Chalkiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010502' => _x( 'Aghios Spyridonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010503' => _x( 'Kalamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010504' => _x( 'Kalovatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010505' => _x( 'Kirkizates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19010506' => _x( 'Rokka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020101' => _x( 'Ano Kalentini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020102' => _x( 'Velentziko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020103' => _x( 'Dichomirio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020104' => _x( 'Retsiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020201' => _x( 'Diassello', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020202' => _x( 'Dimario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020203' => _x( 'Klidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020204' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020205' => _x( 'Skoulikaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020301' => _x( 'Astrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020302' => _x( 'Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020303' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020304' => _x( 'Megalochari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020305' => _x( 'Messopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020306' => _x( 'Miliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19020307' => _x( 'Piges', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030101' => _x( 'Vourgareli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030102' => _x( 'Athamanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030103' => _x( 'Anemorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030104' => _x( 'Distrato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030105' => _x( 'Kato Athamanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030106' => _x( 'Kato Kalentini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030107' => _x( 'Kapsala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030108' => _x( 'Kentriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030109' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030110' => _x( 'Messounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030111' => _x( 'Paleokatouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030112' => _x( 'Tetrakomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030201' => _x( 'Agnanta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030202' => _x( 'Grekiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030203' => _x( 'Katarraktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030204' => _x( 'Koukkoulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030205' => _x( 'Ktistades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030206' => _x( 'Lepiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030207' => _x( 'Mikrospilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030208' => _x( 'Ramia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030301' => _x( 'Theodoriana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19030401' => _x( 'Melissourgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040101' => _x( 'Peta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040102' => _x( 'Markiniada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040103' => _x( 'Megarchi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040201' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040203' => _x( 'Akropotamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040204' => _x( 'Loutrotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040205' => _x( 'Pachykalamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040206' => _x( 'Peranthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040207' => _x( 'Sykies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040301' => _x( 'Kommeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040401' => _x( 'Koboti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040402' => _x( 'Sellades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR19040403' => _x( 'Fotino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010101' => _x( 'Igoumenitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010102' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010103' => _x( 'Aghios Vlassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010104' => _x( 'Grekochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010105' => _x( 'Kastri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010106' => _x( 'Kryovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010107' => _x( 'Ladochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010108' => _x( 'Mavroudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010109' => _x( 'Nea Selefkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010201' => _x( 'Margariti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010202' => _x( 'Eleftherio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010203' => _x( 'Karteri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010204' => _x( 'Katavothra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010205' => _x( 'Mazarakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010206' => _x( 'Messovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010207' => _x( 'Spatharei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010301' => _x( 'Parapotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010302' => _x( 'Geroplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010303' => _x( 'Dramessi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010304' => _x( 'Drimitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010305' => _x( 'Koritiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010401' => _x( 'Perdika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010501' => _x( 'Plataria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010502' => _x( 'Argyrotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010503' => _x( 'Syvota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20010504' => _x( 'Faskomilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020101' => _x( 'Paramythia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020102' => _x( 'Aghia Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020103' => _x( 'Abelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020104' => _x( 'Grika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020105' => _x( 'Elataria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020106' => _x( 'Zervochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020107' => _x( 'Kallithea Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020108' => _x( 'Karvounari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020109' => _x( 'Karioti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020110' => _x( 'Krystallopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020111' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020112' => _x( 'Xirolofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020113' => _x( 'Pagrates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020114' => _x( 'Pente Eklissies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020115' => _x( 'Petoussio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020116' => _x( 'Petrovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020117' => _x( 'Plakoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020118' => _x( 'Polydrosso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020119' => _x( 'Prodromio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020120' => _x( 'Saloniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020121' => _x( 'Sevasto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020122' => _x( 'Chryssavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020123' => _x( 'Psaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020201' => _x( 'Gardiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020202' => _x( 'Glyki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020203' => _x( 'Skandalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020204' => _x( 'Choika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020301' => _x( 'Samonida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020302' => _x( 'Avlotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020303' => _x( 'Koukoulii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020304' => _x( 'Tsagario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20020305' => _x( 'Frossyni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030101' => _x( 'Filiates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030102' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030103' => _x( 'Aghii Pantes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030104' => _x( 'Aetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030105' => _x( 'Abelonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030106' => _x( 'Anavryto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030107' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030108' => _x( 'Vavourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030109' => _x( 'Vryssela', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030110' => _x( 'Gardiki (Aghiou Georgiou) Filiaton', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030111' => _x( 'Giromeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030112' => _x( 'Gola', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030113' => _x( 'Kallithea Filiaton', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030114' => _x( 'Kato Xechoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030115' => _x( 'Keramitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030116' => _x( 'Kerassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030117' => _x( 'Kefalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030118' => _x( 'Kokkinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030119' => _x( 'Kokkinolithari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030120' => _x( 'Kouremadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030121' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030122' => _x( 'Kyparisso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030123' => _x( 'Leptokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030124' => _x( 'Lia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030125' => _x( 'Lista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030126' => _x( 'Malounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030127' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030128' => _x( 'Xechoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030129' => _x( 'Paleoklissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030130' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030131' => _x( 'Palabas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030132' => _x( 'Pigadoulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030133' => _x( 'Plessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030134' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030135' => _x( 'Raveni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030136' => _x( 'Rizo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030137' => _x( 'Sideri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030138' => _x( 'Trikoryfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030139' => _x( 'Tsamantas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030140' => _x( 'Faneromeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030141' => _x( 'Finikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030142' => _x( 'Charavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030201' => _x( 'Asproklissio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030202' => _x( 'Kestrini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030203' => _x( 'Rayo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030204' => _x( 'Sayada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR20030205' => _x( 'Smertos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010101' => _x( 'Preveza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010102' => _x( 'Michalitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010103' => _x( 'Mytikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010104' => _x( 'Nikopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010105' => _x( 'Flaboura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010201' => _x( 'Kanali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010202' => _x( 'Vrachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010203' => _x( 'Eklissies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010204' => _x( 'Kamarina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010205' => _x( 'Kryopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010206' => _x( 'Myrsini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010207' => _x( 'Nea Sampsous', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010208' => _x( 'Nea Sinopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010209' => _x( 'Riza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010210' => _x( 'Chimadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010301' => _x( 'Louros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010302' => _x( 'Ano Rachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010303' => _x( 'Vryssoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010304' => _x( 'Kotsanopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010305' => _x( 'Neo Sfinoto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010306' => _x( 'Revmatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010307' => _x( 'Skiadas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010308' => _x( 'Stefani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010309' => _x( 'Trikastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21010310' => _x( 'Oropos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020101' => _x( 'Filippiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020102' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020103' => _x( 'Gymnotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020104' => _x( 'Dryofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020105' => _x( 'Kerassona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020106' => _x( 'Klissoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020107' => _x( 'Nea Kerassous', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020108' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020109' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020110' => _x( 'Romia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020201' => _x( 'Gorgomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020202' => _x( 'Anogio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020203' => _x( 'Tsagaropoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020301' => _x( 'Thesprotiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020302' => _x( 'Assos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020303' => _x( 'Galatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020304' => _x( 'Meliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020305' => _x( 'Nikolitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020306' => _x( 'Pappadates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020307' => _x( 'Polystafylo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020308' => _x( 'Rizovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21020401' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030101' => _x( 'Kanallaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030102' => _x( 'Aidonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030103' => _x( 'Ammoudia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030104' => _x( 'Ano Skafidoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030105' => _x( 'Acheroussia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030106' => _x( 'Valanidorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030107' => _x( 'Valanidoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030108' => _x( 'Vouvopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030109' => _x( 'Despotiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030110' => _x( 'Themelo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030111' => _x( 'Kastri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030112' => _x( 'Koryfoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030113' => _x( 'Koroni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030114' => _x( 'Koukkouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030115' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030116' => _x( 'Loutsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030117' => _x( 'Messopotamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030118' => _x( 'Mouzakeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030119' => _x( 'Narkissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030120' => _x( 'Skepasto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030121' => _x( 'Stavrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030201' => _x( 'Parga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030202' => _x( 'Aghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030203' => _x( 'Anthoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR21030204' => _x( 'Livadari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'E' => [
		'GR22010100' => _x( 'Larissa (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010105' => _x( 'Terpsithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010201' => _x( 'Yannouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010202' => _x( 'Falanna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010301' => _x( 'Kilada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010302' => _x( 'Amygdalea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010303' => _x( 'Eleftheres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010304' => _x( 'Koutsochero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010305' => _x( 'Loutro Larissas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010306' => _x( 'Mandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22010307' => _x( 'Rachoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020101' => _x( 'Aghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020102' => _x( 'Aetolofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020103' => _x( 'Anavra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020104' => _x( 'Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020105' => _x( 'Elafos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020106' => _x( 'Megalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020107' => _x( 'Metaxochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020108' => _x( 'Neromyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020109' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020201' => _x( 'Stomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020202' => _x( 'Karitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020203' => _x( 'Omolio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020204' => _x( 'Paleopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020301' => _x( 'Dimitra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020302' => _x( 'Amygdali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020303' => _x( 'Anatoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020304' => _x( 'Kastri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020305' => _x( 'Marmarini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020401' => _x( 'Sotiritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020402' => _x( 'Melivia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020403' => _x( 'Skiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22020404' => _x( 'Sklithro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030101' => _x( 'Elassona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030102' => _x( 'Valanida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030103' => _x( 'Galanovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030104' => _x( 'Drymos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030105' => _x( 'Evaghelismos Elassonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030106' => _x( 'Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030107' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030108' => _x( 'Stefanovouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030201' => _x( 'Kranea Elassonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030202' => _x( 'Akri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030203' => _x( 'Loutro Elassonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030301' => _x( 'Verdikoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030401' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030402' => _x( 'Kryovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030403' => _x( 'Sykaminea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030501' => _x( 'Livadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030502' => _x( 'Dolichi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030601' => _x( 'Kallithea Elassonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030602' => _x( 'Kokkinogio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030603' => _x( 'Kokkinopilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030604' => _x( 'Lofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030605' => _x( 'Olympiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030606' => _x( 'Pythio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030607' => _x( 'Flabouro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030701' => _x( 'Vlachoyannio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030702' => _x( 'Amourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030703' => _x( 'Domeniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030704' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030705' => _x( 'Mega Eleftherochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030706' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030707' => _x( 'Pretorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030708' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030801' => _x( 'Sarantaporo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030802' => _x( 'Azoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030803' => _x( 'Gerania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030804' => _x( 'Giannota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030805' => _x( 'Lykoudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030806' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030807' => _x( 'Tsapournia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22030901' => _x( 'Tsaritsani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040101' => _x( 'Nikea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040102' => _x( 'Dilofo Larissas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040103' => _x( 'Zappio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040104' => _x( 'Moschochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040105' => _x( 'Myra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040106' => _x( 'Nea Lefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040107' => _x( 'Nees Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040108' => _x( 'Chara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040201' => _x( 'Armenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040202' => _x( 'Mega Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040203' => _x( 'Niki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040204' => _x( 'Sotirio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040301' => _x( 'Kileler', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040302' => _x( 'Agnanteri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040303' => _x( 'Kalamaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040304' => _x( 'Melissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040305' => _x( 'Neo Perivoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040401' => _x( 'Aghii Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040402' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040403' => _x( 'Vounena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040404' => _x( 'Doxaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040405' => _x( 'Krannonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040406' => _x( 'Kyparissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040407' => _x( 'Mavrovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040408' => _x( 'Mikro Vouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040409' => _x( 'Psychiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040501' => _x( 'Platykabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040502' => _x( 'Galini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040503' => _x( 'Glafki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040504' => _x( 'Eleftherio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040505' => _x( 'Melia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040506' => _x( 'Melissochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040507' => _x( 'Namata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040508' => _x( 'Omorfochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22040509' => _x( 'Chalki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050101' => _x( 'Makrychori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050102' => _x( 'Elatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050103' => _x( 'Evaghelismos Larissas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050104' => _x( 'Parapotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050201' => _x( 'Abelakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050202' => _x( 'Tempi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050301' => _x( 'Gonni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050302' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050303' => _x( 'Kallipefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050401' => _x( 'Pyrgetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050402' => _x( 'Aegani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050403' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050404' => _x( 'Rapsani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050501' => _x( 'Sykourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050502' => _x( 'Kalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050503' => _x( 'Kypselochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050504' => _x( 'Nesson', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050505' => _x( 'Ossa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050506' => _x( 'Pournari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22050507' => _x( 'Spilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060101' => _x( 'Tyrnavos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060102' => _x( 'Argyropoulio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060103' => _x( 'Damassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060104' => _x( 'Dendra Tyrnavou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060201' => _x( 'Abelonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060202' => _x( 'Vryotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060203' => _x( 'Deleria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22060204' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070101' => _x( 'Farsala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070102' => _x( 'Achillio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070103' => _x( 'Vryssia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070201' => _x( 'Mega Evydrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070202' => _x( 'Aghios Georgios Farsalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070203' => _x( 'Vassilis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070204' => _x( 'Katochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070205' => _x( 'Krini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070206' => _x( 'Polyneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070207' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070208' => _x( 'Yperia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070301' => _x( 'Narthakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070302' => _x( 'Dendra Farsalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070303' => _x( 'Dilofo Farsalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070304' => _x( 'Kallithea Farsalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070305' => _x( 'Skopia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070401' => _x( 'Vamvakou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070402' => _x( 'Abelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070403' => _x( 'Dassolofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070404' => _x( 'Eretria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070405' => _x( 'Zoodochos Pigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070406' => _x( 'Kato Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070407' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070408' => _x( 'Polydamio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070409' => _x( 'Revmatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070410' => _x( 'Sitochoro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070411' => _x( 'Skotoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR22070412' => _x( 'Chalkiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010101' => _x( 'Karditsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010102' => _x( 'Aghiopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010103' => _x( 'Artessiano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010104' => _x( 'Karditsomagoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010105' => _x( 'Paleoklissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010106' => _x( 'Rousso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010201' => _x( 'Kallithiro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010202' => _x( 'Amarantos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010203' => _x( 'Abeliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010204' => _x( 'Karoplessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010205' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010206' => _x( 'Katafygio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010207' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010208' => _x( 'Rachoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010301' => _x( 'Kallifonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010302' => _x( 'Apidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010303' => _x( 'Dafnospilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010304' => _x( 'Zaimio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010305' => _x( 'Molocha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010306' => _x( 'Paliouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010401' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010402' => _x( 'Aghios Theodoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010403' => _x( 'Makrychori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010404' => _x( 'Melissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010405' => _x( 'Myrina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010406' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010407' => _x( 'Ptelopoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010501' => _x( 'Mitropoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010502' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010503' => _x( 'Georgiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010504' => _x( 'Krya Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010505' => _x( 'Xinoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010506' => _x( 'Portitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23010507' => _x( 'Frago', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020101' => _x( 'Anthiro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020102' => _x( 'Argithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020103' => _x( 'Ellinika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020104' => _x( 'Therino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020105' => _x( 'Kali Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020106' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020107' => _x( 'Messovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020108' => _x( 'Petroto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020201' => _x( 'Petrilo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020202' => _x( 'Vlassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020203' => _x( 'Drossato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020204' => _x( 'Koubouriana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020205' => _x( 'Leontito', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020206' => _x( 'Petrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020207' => _x( 'Stefanias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020208' => _x( 'Fountoto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020301' => _x( 'Vraghiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020302' => _x( 'Argyrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020303' => _x( 'Katafyllio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23020304' => _x( 'Marathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030101' => _x( 'Morfovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030102' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030103' => _x( 'Labero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030104' => _x( 'Messenikolas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030105' => _x( 'Moschato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030201' => _x( 'Pezoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030202' => _x( 'Karvassaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030203' => _x( 'Karitsa Dolopon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030204' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030205' => _x( 'Belokomiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030206' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23030207' => _x( 'Fylakti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040101' => _x( 'Mouzaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040102' => _x( 'Amygdali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040103' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040104' => _x( 'Vatsounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040105' => _x( 'Gelanthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040106' => _x( 'Drakotrypa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040107' => _x( 'Ellinokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040108' => _x( 'Kryopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040109' => _x( 'Lazarina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040110' => _x( 'Magoulitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040111' => _x( 'Mavrommati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040112' => _x( 'Oxya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040113' => _x( 'Pefkofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040114' => _x( 'Porti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040201' => _x( 'Fanari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040202' => _x( 'Aghios Akakios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040203' => _x( 'Ellinopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040204' => _x( 'Kanalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040205' => _x( 'Kappas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040206' => _x( 'Loxada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040207' => _x( 'Pyrgos Ithomis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040208' => _x( 'Charma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040301' => _x( 'Agnantero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040302' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040303' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040304' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23040305' => _x( 'Rizovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050101' => _x( 'Palamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050102' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050103' => _x( 'Vlochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050104' => _x( 'Gorgovites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050105' => _x( 'Kalyvakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050106' => _x( 'Koskinas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050107' => _x( 'Markos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050108' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050201' => _x( 'Proastio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050202' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050203' => _x( 'Kalogriana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050204' => _x( 'Marathea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050205' => _x( 'Pedino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050301' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050302' => _x( 'Astritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050303' => _x( 'Lefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050304' => _x( 'Orfana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050305' => _x( 'Petrino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050306' => _x( 'Sykies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23050307' => _x( 'Fyllo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060101' => _x( 'Sofades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060102' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060103' => _x( 'Aghios Vissarios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060104' => _x( 'Abelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060105' => _x( 'Anogio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060106' => _x( 'Gefyria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060107' => _x( 'Dassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060108' => _x( 'Kappadokiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060109' => _x( 'Karpochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060110' => _x( 'Mascholouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060111' => _x( 'Mavrachades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060112' => _x( 'Melissochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060113' => _x( 'Paschalitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060114' => _x( 'Filia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060201' => _x( 'Mataraga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060202' => _x( 'Ermitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060203' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060204' => _x( 'Pyrgos Kieriou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060301' => _x( 'Kedros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060302' => _x( 'Aidonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060303' => _x( 'Vathylakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060304' => _x( 'Thrapsimi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060305' => _x( 'Loutropigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060306' => _x( 'Loutro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060401' => _x( 'Rentina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060501' => _x( 'Leontari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060502' => _x( 'Anavra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060503' => _x( 'Assimochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060504' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060505' => _x( 'Grammatiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR23060506' => _x( 'Ktimeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010101' => _x( 'Volos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010201' => _x( 'Agria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010202' => _x( 'Drakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010301' => _x( 'Diminio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010302' => _x( 'Sesklo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010401' => _x( 'Ano Lechonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010402' => _x( 'Aghios Vlassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010403' => _x( 'Aghios Lavrentios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010404' => _x( 'Kato Lechonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010501' => _x( 'Ano Volos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010502' => _x( 'Aghios Onoufrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010503' => _x( 'Anakassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010601' => _x( 'Makrinitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010701' => _x( 'Anchialos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010702' => _x( 'Aidinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010703' => _x( 'Mikrothives', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010801' => _x( 'Nea Ionia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010802' => _x( 'Glafyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010901' => _x( 'Portaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010902' => _x( 'Alli Meria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010903' => _x( 'Katochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24010904' => _x( 'Stayates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020101' => _x( 'Almyros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020102' => _x( 'Anthotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020103' => _x( 'Efxinoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020104' => _x( 'Kokkoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020105' => _x( 'Krokio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020106' => _x( 'Kofi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020107' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020108' => _x( 'Fylaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020201' => _x( 'Anavra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020301' => _x( 'Pteleos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020302' => _x( 'Aghii Theodori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020303' => _x( 'Achillio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020401' => _x( 'Sourpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020402' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020403' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020404' => _x( 'Amaliapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020405' => _x( 'Vrynena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24020406' => _x( 'Drymonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030101' => _x( 'Zagora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030102' => _x( 'Makryrrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030103' => _x( 'Pourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030201' => _x( 'Tsagarada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030202' => _x( 'Aghios Dimitrios Piliou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030203' => _x( 'Anilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030204' => _x( 'Kissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030205' => _x( 'Mouressio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24030206' => _x( 'Xorychti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040101' => _x( 'Argalasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040102' => _x( 'Metochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040103' => _x( 'Xinovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040201' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040202' => _x( 'Afetes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040203' => _x( 'Propan', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040204' => _x( 'Labinou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040205' => _x( 'Syki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040301' => _x( 'Milies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040302' => _x( 'Aghios Georgios Nilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040303' => _x( 'Vyzitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040304' => _x( 'Kala Nera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040305' => _x( 'Pinakates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040401' => _x( 'Lafkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040402' => _x( 'Milina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040403' => _x( 'Promyrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24040501' => _x( 'Trikeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050101' => _x( 'Velestino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050102' => _x( 'Aghios Georgios Feron', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050103' => _x( 'Aerino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050104' => _x( 'Mikro Perivolaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050105' => _x( 'Perivlepto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050201' => _x( 'Stefanovikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050202' => _x( 'Kanalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050203' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050204' => _x( 'Rizomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR24050301' => _x( 'Keramidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR25010000' => _x( 'Skiathos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR25020000' => _x( 'Alonnissos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR25030001' => _x( 'Skopelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR25030002' => _x( 'Glossa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR25030003' => _x( 'Klima', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010101' => _x( 'Trikala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010201' => _x( 'Megalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010202' => _x( 'Logos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010203' => _x( 'Patoulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010204' => _x( 'Chryssavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010301' => _x( 'Valtino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010302' => _x( 'Dendrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010303' => _x( 'Kato Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010304' => _x( 'Fotada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010401' => _x( 'Prinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010402' => _x( 'Genessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010403' => _x( 'Gorgogyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010404' => _x( 'Xylopariko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010405' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010501' => _x( 'Megala Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010502' => _x( 'Aghia Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010503' => _x( 'Glinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010601' => _x( 'Paleopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010602' => _x( 'Agrelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010603' => _x( 'Ardanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010604' => _x( 'Zilefti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010605' => _x( 'Koumaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010606' => _x( 'Krinitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010607' => _x( 'Lioprasso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010701' => _x( 'Rizoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010702' => _x( 'Ellinokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010703' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010704' => _x( 'Raxa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010705' => _x( 'Spathades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010801' => _x( 'Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010802' => _x( 'Dialekto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010803' => _x( 'Dipotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010804' => _x( 'Mega Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26010805' => _x( 'Megarchi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020101' => _x( 'Kalabaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020102' => _x( 'Avra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020103' => _x( 'Vlachava', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020104' => _x( 'Diava', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020105' => _x( 'Kastraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020106' => _x( 'Krya Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020107' => _x( 'Megali Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020108' => _x( 'Orthovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020109' => _x( 'Sarakina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020201' => _x( 'Kallirroi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020203' => _x( 'Anthoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020204' => _x( 'Katafyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020205' => _x( 'Kranea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020206' => _x( 'Polythea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020207' => _x( 'Stefani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020208' => _x( 'Chaliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020301' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020302' => _x( 'Theopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020303' => _x( 'Peristera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020401' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020402' => _x( 'Amaranto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020403' => _x( 'Abelochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020404' => _x( 'Kalomira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020405' => _x( 'Matoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020501' => _x( 'Klino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020502' => _x( 'Aidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020503' => _x( 'Glykomilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020504' => _x( 'Kalogriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020505' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020506' => _x( 'Chryssomilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020601' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020602' => _x( 'Korydallos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020603' => _x( 'Malakassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020604' => _x( 'Pefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020605' => _x( 'Trygona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020701' => _x( 'Koniskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020702' => _x( 'Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020703' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020704' => _x( 'Loga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020705' => _x( 'Mavrelio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020706' => _x( 'Flabouressio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020707' => _x( 'Fotino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020801' => _x( 'Asproklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020802' => _x( 'Aghiofyllo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020803' => _x( 'Agnantia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020804' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020805' => _x( 'Gavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020806' => _x( 'Kakoplevrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020807' => _x( 'Oxynia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26020808' => _x( 'Skepari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030101' => _x( 'Pyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030102' => _x( 'Aghios Vissarionas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030103' => _x( 'Aghios Prokopios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030104' => _x( 'Kotroni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030105' => _x( 'Paleokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030106' => _x( 'Petrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030107' => _x( 'Ropoto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030201' => _x( 'Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030202' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030203' => _x( 'Athamania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030204' => _x( 'Vrontero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030205' => _x( 'Gardiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030206' => _x( 'Dessi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030207' => _x( 'Drossochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030208' => _x( 'Kalogiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030209' => _x( 'Neraidochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030210' => _x( 'Pertouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030211' => _x( 'Pyrra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030301' => _x( 'Lygaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030302' => _x( 'Gomfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030303' => _x( 'Drossero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030304' => _x( 'Mouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030305' => _x( 'Paleomonastiro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030306' => _x( 'Pigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030401' => _x( 'Myrofyllo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030501' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030502' => _x( 'Armatoliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030503' => _x( 'Koryfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030504' => _x( 'Pachtouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030601' => _x( 'Fiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030602' => _x( 'Eleftherochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030603' => _x( 'Parapotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030604' => _x( 'Pialia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030605' => _x( 'Filyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030701' => _x( 'Stournareika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030702' => _x( 'Vathyrrevma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030703' => _x( 'Valkano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030704' => _x( 'Livadochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030705' => _x( 'Messochora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030706' => _x( 'Moschofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030707' => _x( 'Nea Pefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030708' => _x( 'Paramero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26030709' => _x( 'Polyneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040101' => _x( 'Farkadona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040102' => _x( 'Achladochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040103' => _x( 'Grizano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040104' => _x( 'Diasselo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040105' => _x( 'Zarkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040106' => _x( 'Keramidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040107' => _x( 'Panagitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040108' => _x( 'Piniada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040201' => _x( 'Ichalia (Neochori)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040202' => _x( 'Georganades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040203' => _x( 'Klokotos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040204' => _x( 'Krini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040205' => _x( 'Petroto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040301' => _x( 'Taxiarches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040302' => _x( 'Nomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040303' => _x( 'Petroporos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040304' => _x( 'Servota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR26040305' => _x( 'Faneromeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'H' => [
		'GR27010101' => _x( 'Lamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010102' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010103' => _x( 'Anthili', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010104' => _x( 'Divri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010105' => _x( 'Thermopyles', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010106' => _x( 'Kalamaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010107' => _x( 'Komma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010108' => _x( 'Kostalexis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010109' => _x( 'Lygaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010110' => _x( 'Megali Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010111' => _x( 'Roditsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010112' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010113' => _x( 'Frantzis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010201' => _x( 'Moschochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010202' => _x( 'Vardates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010203' => _x( 'Gorgopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010204' => _x( 'Damasta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010205' => _x( 'Delfino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010206' => _x( 'Dyo Vouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010207' => _x( 'Eleftherochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010208' => _x( 'Iraklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010209' => _x( 'Koumaritsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010210' => _x( 'Neo Krikello', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010211' => _x( 'Oiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010301' => _x( 'Lianokladi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010302' => _x( 'Amourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010303' => _x( 'Zilevto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010304' => _x( 'Moschokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010305' => _x( 'Stirfaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010401' => _x( 'Pavliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010501' => _x( 'Ypati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010502' => _x( 'Argyrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010503' => _x( 'Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010504' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010505' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010506' => _x( 'Kobotades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010507' => _x( 'Ladikou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010508' => _x( 'Loutra Ypatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010509' => _x( 'Lychno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010510' => _x( 'Mexiates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010511' => _x( 'Messochori Ypatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010512' => _x( 'Neochori Ypatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010513' => _x( 'Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010514' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010515' => _x( 'Rodonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27010516' => _x( 'Sykas Ypatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020101' => _x( 'Kato Tithorea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020102' => _x( 'Aghia Marina Lokridas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020103' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020104' => _x( 'Modio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020105' => _x( 'Tithorea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020201' => _x( 'Amfiklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020202' => _x( 'Drymea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020203' => _x( 'Bralos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020204' => _x( 'Xyliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020205' => _x( 'Paleochori Dorieon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020206' => _x( 'Tithronio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020301' => _x( 'Elatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020302' => _x( 'Zelio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020303' => _x( 'Lefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020304' => _x( 'Panagitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27020305' => _x( 'Sfaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030101' => _x( 'Domokos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030102' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030103' => _x( 'Vouzio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030104' => _x( 'Geraklio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030105' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030106' => _x( 'Lefka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030107' => _x( 'Makrolivado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030108' => _x( 'Mantassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030109' => _x( 'Melitea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030110' => _x( 'Nea Makrissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030111' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030112' => _x( 'Palamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030113' => _x( 'Petroto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030114' => _x( 'Polydendri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030115' => _x( 'Pournari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030116' => _x( 'Fyliadona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030201' => _x( 'Neo Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030202' => _x( 'Agrapidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030203' => _x( 'Vardali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030204' => _x( 'Velessiotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030205' => _x( 'Gavrakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030206' => _x( 'Ekkara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030207' => _x( 'Thavmako', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030208' => _x( 'Sofiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030301' => _x( 'Omvriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030302' => _x( 'Aghios Georgios Domokou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030303' => _x( 'Aghios Stefanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030304' => _x( 'Koromilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030305' => _x( 'Makryrrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030306' => _x( 'Xiniada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030307' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27030308' => _x( 'Perivoli Domokou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040101' => _x( 'Atalanti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040102' => _x( 'Exarchos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040103' => _x( 'Kalapodio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040104' => _x( 'Kyparissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040105' => _x( 'Kyrtoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040106' => _x( 'Megaplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040107' => _x( 'Tragana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040201' => _x( 'Livanates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040202' => _x( 'Arkitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040203' => _x( 'Goulemio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040301' => _x( 'Malessina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040302' => _x( 'Proskynas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040401' => _x( 'Martino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27040402' => _x( 'Larymna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050101' => _x( 'Sperchiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050102' => _x( 'Aghios Sostis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050103' => _x( 'Anatoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050104' => _x( 'Argyria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050105' => _x( 'Gardikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050106' => _x( 'Kallithea Sperchiadas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050107' => _x( 'Kabia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050108' => _x( 'Kanalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050109' => _x( 'Klonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050110' => _x( 'Kolokythia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050111' => _x( 'Kyriakochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050112' => _x( 'Lefkada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050113' => _x( 'Marmara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050114' => _x( 'Messopotamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050115' => _x( 'Nikolitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050116' => _x( 'Paleovracha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050117' => _x( 'Paleochori Tymfristou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050118' => _x( 'Perivoli Fthiotidas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050119' => _x( 'Pitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050120' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050121' => _x( 'Pougakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050122' => _x( 'Fteri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050201' => _x( 'Aghios Georgios Fthiotidas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050202' => _x( 'Vitoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050203' => _x( 'Dikastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050204' => _x( 'Mavrilo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050205' => _x( 'Megali Kapsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050206' => _x( 'Merkada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050207' => _x( 'Messea Kapsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050208' => _x( 'Neochori Tymfristou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050209' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050210' => _x( 'Perivlepto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050211' => _x( 'Pitsiota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050212' => _x( 'Ptelea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050301' => _x( 'Makrakomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050302' => _x( 'Archanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050303' => _x( 'Asvestio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050304' => _x( 'Giannitsou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050305' => _x( 'Grammeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050306' => _x( 'Kastri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050307' => _x( 'Litosselo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050308' => _x( 'Makri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050309' => _x( 'Palea Yannitsou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050310' => _x( 'Pappas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050311' => _x( 'Platystomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050312' => _x( 'Rovoliari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050313' => _x( 'Trilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050314' => _x( 'Tsoukka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27050401' => _x( 'Tymfristos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060101' => _x( 'Kamena Vourla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060102' => _x( 'Kenourgio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060103' => _x( 'Reginio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060201' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060202' => _x( 'Agnanti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060301' => _x( 'Molos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060302' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060303' => _x( 'Aghios Serafim', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060304' => _x( 'Aghios Charalabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060305' => _x( 'Anavra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060306' => _x( 'Kallidromo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060307' => _x( 'Komnina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060308' => _x( 'Mendenitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27060309' => _x( 'Skarfia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070101' => _x( 'Stylida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070102' => _x( 'Aghia Marina Fthiotidas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070103' => _x( 'Anydro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070104' => _x( 'Avlaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070105' => _x( 'Logitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070106' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070201' => _x( 'Raches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070202' => _x( 'Achinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070203' => _x( 'Achladi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070204' => _x( 'Karavomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070205' => _x( 'Paleokerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070206' => _x( 'Spartia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070301' => _x( 'Pelasghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070302' => _x( 'Vathykilo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070303' => _x( 'Glyfa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR27070304' => _x( 'Myli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010101' => _x( 'Levadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010102' => _x( 'Lafystio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010103' => _x( 'Romeiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010201' => _x( 'Davlia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010202' => _x( 'Mavroneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010203' => _x( 'Parorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010301' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010302' => _x( 'Aghia Anna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010303' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010304' => _x( 'Alalkomenes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010305' => _x( 'Koronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010401' => _x( 'Kyriakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010501' => _x( 'Cheronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010502' => _x( 'Aghios Vlassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010503' => _x( 'Akontio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010504' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010505' => _x( 'Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010506' => _x( 'Thourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010507' => _x( 'Prossilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28010508' => _x( 'Profitis Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020101' => _x( 'Aliartos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020102' => _x( 'Evaghelistria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020103' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020104' => _x( 'Solinario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020105' => _x( 'Ypsilantis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020201' => _x( 'Thespies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020202' => _x( 'Askri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020203' => _x( 'Leontari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020204' => _x( 'Mavrommati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28020205' => _x( 'Neochori Thespion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28030101' => _x( 'Distomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28030102' => _x( 'Stirio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28030201' => _x( 'Antikyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28030301' => _x( 'Arachova', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040101' => _x( 'Thiva', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040102' => _x( 'Abelochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040103' => _x( 'Eleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040104' => _x( 'Mourikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040105' => _x( 'Neochoraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040106' => _x( 'Ypato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040201' => _x( 'Vayia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040301' => _x( 'Domvrena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040302' => _x( 'Ellopia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040303' => _x( 'Thisvi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040304' => _x( 'Xironomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040305' => _x( 'Chostia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040401' => _x( 'Kaparelli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040402' => _x( 'Lefktra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040403' => _x( 'Loutoufio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040404' => _x( 'Melissochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28040405' => _x( 'Platees', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050101' => _x( 'Orchomenos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050102' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050103' => _x( 'Aghios Spyridonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050104' => _x( 'Dionyssos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050105' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050106' => _x( 'Loutsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050107' => _x( 'Pavlos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050108' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050201' => _x( 'Akrefnio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050202' => _x( 'Kastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28050203' => _x( 'Kokkino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060101' => _x( 'Schimatari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060201' => _x( 'Pyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060202' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060203' => _x( 'Skourta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060204' => _x( 'Stefani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060301' => _x( 'Inofyta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060302' => _x( 'Aghios Thomas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060303' => _x( 'Klidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060401' => _x( 'Arma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060402' => _x( 'Assopia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060403' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060404' => _x( 'Tanagra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060501' => _x( 'Dilessi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR28060502' => _x( 'Plaka Dilessi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010101' => _x( 'Chalkida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010201' => _x( 'Drossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010202' => _x( 'Anthidon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010301' => _x( 'Vathy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010302' => _x( 'Kalochori - Pantichi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010303' => _x( 'Paralia Avlidas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010304' => _x( 'Faros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010401' => _x( 'Vassiliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010402' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010403' => _x( 'Afratio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010404' => _x( 'Mytikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010405' => _x( 'Nea Lampsakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010406' => _x( 'Fylla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29010501' => _x( 'Nea Artaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020101' => _x( 'Psachna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020102' => _x( 'Aghia Sofia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020103' => _x( 'Attali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020104' => _x( 'Kamaritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020105' => _x( 'Kastella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020106' => _x( 'Kontodespotio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020107' => _x( 'Kyparissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020108' => _x( 'Makrykapa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020109' => _x( 'Nerotrivia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020110' => _x( 'Pagontas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020111' => _x( 'Politika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020112' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020113' => _x( 'Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020201' => _x( 'Steni Dirfyos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020202' => _x( 'Aghios Athanassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020203' => _x( 'Amfithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020204' => _x( 'Vouni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020205' => _x( 'Glyfada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020206' => _x( 'Theologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020207' => _x( 'Katheni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020208' => _x( 'Kabia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020209' => _x( 'Loutsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020210' => _x( 'Mistros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020211' => _x( 'Paliouras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020212' => _x( 'Pissonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020213' => _x( 'Pournos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29020214' => _x( 'Stropones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030101' => _x( 'Eretria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030201' => _x( 'Amarynthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030202' => _x( 'Ano Vathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030203' => _x( 'Gymno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030204' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29030205' => _x( 'Seta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040101' => _x( 'Istiea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040102' => _x( 'Avgaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040103' => _x( 'Voutas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040104' => _x( 'Galatsades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040105' => _x( 'Galatsona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040106' => _x( 'Kamaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040107' => _x( 'Kokkinomilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040108' => _x( 'Kryoneritis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040109' => _x( 'Milies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040110' => _x( 'Monokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040201' => _x( 'Loutra Aedipsou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040202' => _x( 'Aghios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040203' => _x( 'Gialtra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040301' => _x( 'Artemissio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040302' => _x( 'Agdines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040303' => _x( 'Agriovotano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040304' => _x( 'Asminio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040305' => _x( 'Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040306' => _x( 'Gerakiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040307' => _x( 'Gouves', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040308' => _x( 'Ellinika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040401' => _x( 'Lichada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040501' => _x( 'Orei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040502' => _x( 'Kastaniotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040503' => _x( 'Neos Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29040504' => _x( 'Taxiarchis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050101' => _x( 'Karystos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050102' => _x( 'Aetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050103' => _x( 'Grabia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050104' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050105' => _x( 'Myli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050106' => _x( 'Platanistos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050201' => _x( 'Amygdalea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050202' => _x( 'Komito', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050301' => _x( 'Marmari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050302' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050303' => _x( 'Akteo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050304' => _x( 'Giannitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050305' => _x( 'Kallianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050306' => _x( 'Katsaronio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050307' => _x( 'Melissonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050308' => _x( 'Paradissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050309' => _x( 'Stouppei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050401' => _x( 'Styra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050402' => _x( 'Almyropotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050403' => _x( 'Messochoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050404' => _x( 'Nea Styra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29050405' => _x( 'Polypotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060101' => _x( 'Aliveri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060102' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060103' => _x( 'Aghios Loukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060104' => _x( 'Gavalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060105' => _x( 'Tharounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060106' => _x( 'Parthenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060107' => _x( 'Kalentzi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060108' => _x( 'Trachilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060201' => _x( 'Avlonari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060202' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060203' => _x( 'Achladeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060204' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060205' => _x( 'Oktonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060206' => _x( 'Orio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060207' => _x( 'Pyrgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060208' => _x( 'Orologio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060301' => _x( 'Krieza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060302' => _x( 'Argyro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060303' => _x( 'Velos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060304' => _x( 'Dystos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060305' => _x( 'Zarakes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060306' => _x( 'Koskina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060307' => _x( 'Lepoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060308' => _x( 'Petries', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060401' => _x( 'Konistres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060402' => _x( 'Aghios Vlassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060403' => _x( 'Ano Kourounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060404' => _x( 'Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060405' => _x( 'Kadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060406' => _x( 'Kato Kourounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060407' => _x( 'Kipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060408' => _x( 'Kremastos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060409' => _x( 'Makrychori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060410' => _x( 'Manikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060411' => _x( 'Monodryo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060501' => _x( 'Kymi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060502' => _x( 'Androniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060503' => _x( 'Ano Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060504' => _x( 'Vitala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060505' => _x( 'Enoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060506' => _x( 'Kalimeriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060507' => _x( 'Maletiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060508' => _x( 'Metochi Dirfyon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060509' => _x( 'Oxylithos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060510' => _x( 'Platana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060511' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29060512' => _x( 'Taxiarches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070101' => _x( 'Limni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070102' => _x( 'Kechries', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070103' => _x( 'Kourkouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070104' => _x( 'Rovies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070105' => _x( 'Skepasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070201' => _x( 'Mantoudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070202' => _x( 'Vlachia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070203' => _x( 'Dafnoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070204' => _x( 'Kirinthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070205' => _x( 'Metochi Kireos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070206' => _x( 'Pilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070207' => _x( 'Prokopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070208' => _x( 'Spathario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070209' => _x( 'Strofylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070210' => _x( 'Farakla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070301' => _x( 'Aghia Anna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070302' => _x( 'Amelantes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070303' => _x( 'Achladi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070304' => _x( 'Keramia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070305' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070306' => _x( 'Kotsikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29070307' => _x( 'Pappades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR29080000' => _x( 'Skyros (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010101' => _x( 'Karpenissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010102' => _x( 'Aghia Vlacherna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010103' => _x( 'Aghios Andreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010104' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010105' => _x( 'Voutyro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010106' => _x( 'Kalesmeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010107' => _x( 'Koryschades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010108' => _x( 'Myriki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010109' => _x( 'Papparoussi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010110' => _x( 'Pavlopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010111' => _x( 'Sella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010112' => _x( 'Stenoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010113' => _x( 'Stefani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010114' => _x( 'Fidakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010201' => _x( 'Krikello', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010202' => _x( 'Ampliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010203' => _x( 'Domnista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010204' => _x( 'Messokomi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010205' => _x( 'Roska', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010206' => _x( 'Stavli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010207' => _x( 'Psiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010301' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010302' => _x( 'Aghios Charalabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010303' => _x( 'Domiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010304' => _x( 'Petralona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010305' => _x( 'Chochlia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010401' => _x( 'Megalo Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010402' => _x( 'Aniada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010403' => _x( 'Dermati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010404' => _x( 'Karitsa Karpenissiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010405' => _x( 'Klafsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010406' => _x( 'Mikro Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010407' => _x( 'Mouzilo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010408' => _x( 'Nostimo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010409' => _x( 'Sygrellos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010410' => _x( 'Chelidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010501' => _x( 'Proussos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010502' => _x( 'Alestia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010503' => _x( 'Aspropyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010504' => _x( 'Velota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010505' => _x( 'Essochoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010506' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010507' => _x( 'Katavothra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010508' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010509' => _x( 'Sarkini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010510' => _x( 'Stavrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010511' => _x( 'Tornos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010601' => _x( 'Fourna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010602' => _x( 'Vracha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30010603' => _x( 'Klitso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020101' => _x( 'Kerassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020102' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020103' => _x( 'Viniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020104' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020105' => _x( 'Mavrommata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020106' => _x( 'Chrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020201' => _x( 'Agrafa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020202' => _x( 'Vraghiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020203' => _x( 'Epiniana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020204' => _x( 'Marathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020205' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020206' => _x( 'Tridendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020207' => _x( 'Trovato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020301' => _x( 'Granitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020302' => _x( 'Valaora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020303' => _x( 'Voulpi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020304' => _x( 'Limeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020305' => _x( 'Lithochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020306' => _x( 'Sivista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020307' => _x( 'Topoliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020401' => _x( 'Raptopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020402' => _x( 'Kedra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020403' => _x( 'Lepiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020404' => _x( 'Neo Argyrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020405' => _x( 'Prassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020501' => _x( 'Dytiki Fraghista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020502' => _x( 'Anatoliki Fraghista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020503' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020504' => _x( 'Marathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020505' => _x( 'Paleokatouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020506' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR30020507' => _x( 'Tripotamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010101' => _x( 'Amfissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010102' => _x( 'Aghia Efthymia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010103' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010104' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010105' => _x( 'Drossochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010106' => _x( 'Eleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010107' => _x( 'Prossilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010108' => _x( 'Sernikaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010201' => _x( 'Galaxidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010202' => _x( 'Aghii Pantes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010203' => _x( 'Vounichora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010204' => _x( 'Penteoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010301' => _x( 'Gravia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010302' => _x( 'Apostolias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010303' => _x( 'Vargiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010304' => _x( 'Kaloskopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010305' => _x( 'Kastellia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010306' => _x( 'Mariolata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010307' => _x( 'Oinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010308' => _x( 'Sklithro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010401' => _x( 'Delfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010402' => _x( 'Chrisso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010501' => _x( 'Desfina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010601' => _x( 'Itea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010602' => _x( 'Kirra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010603' => _x( 'Tritea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010701' => _x( 'Mavrolithari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010702' => _x( 'Athanassios Diakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010703' => _x( 'Kastriotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010704' => _x( 'Moussounitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010705' => _x( 'Panourgias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010706' => _x( 'Pyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010707' => _x( 'Stromi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010801' => _x( 'Polydrossos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010802' => _x( 'Eptalofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31010803' => _x( 'Lilea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020101' => _x( 'Efpalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020102' => _x( 'Drossato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020103' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020104' => _x( 'Kastraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020105' => _x( 'Klima Efpaliou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020106' => _x( 'Malamata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020107' => _x( 'Managouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020108' => _x( 'Marathias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020109' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020110' => _x( 'Paleoxari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020111' => _x( 'Potidania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020112' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020113' => _x( 'Sergoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020114' => _x( 'Tichio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020115' => _x( 'Trikorfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020116' => _x( 'Filothei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020201' => _x( 'Krokylio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020202' => _x( 'Alpochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020203' => _x( 'Artotina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020204' => _x( 'Dichori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020205' => _x( 'Zoriano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020206' => _x( 'Kerassies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020207' => _x( 'Kokkino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020208' => _x( 'Koupakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020209' => _x( 'Kriatsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020210' => _x( 'Pentagii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020211' => _x( 'Perivoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020212' => _x( 'Tristeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020213' => _x( 'Ypsilo Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020301' => _x( 'Lidoriki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020302' => _x( 'Avoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020303' => _x( 'Amygdalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020304' => _x( 'Vraila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020305' => _x( 'Dafnos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020306' => _x( 'Diakopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020307' => _x( 'Doriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020308' => _x( 'Kallio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020309' => _x( 'Karoutes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020310' => _x( 'Koniakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020311' => _x( 'Lefkaditio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020312' => _x( 'Malandrino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020313' => _x( 'Pentapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020314' => _x( 'Perithiotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020315' => _x( 'Stilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020316' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020317' => _x( 'Sotena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020401' => _x( 'Eratini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020402' => _x( 'Glyfada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020403' => _x( 'Elea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020404' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020405' => _x( 'Makrini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020406' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020407' => _x( 'Panormos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020408' => _x( 'Tolofon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR31020409' => _x( 'Trizonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'F' => [
		'GR32010101' => _x( 'Kerkyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010102' => _x( 'Alepou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010103' => _x( 'Evropouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010104' => _x( 'Kanali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010201' => _x( 'Agros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010202' => _x( 'Aghios Athanassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010203' => _x( 'Arkadades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010204' => _x( 'Armenades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010205' => _x( 'Afionas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010206' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010207' => _x( 'Drossato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010208' => _x( 'Kavadades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010209' => _x( 'Kastellani Gyrou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010210' => _x( 'Messaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010211' => _x( 'Pagi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010212' => _x( 'Rachtades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010213' => _x( 'Chorepiskopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010301' => _x( 'Gastouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010302' => _x( 'Aghios Prokopios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010303' => _x( 'Aghii Deka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010304' => _x( 'Ano Garouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010305' => _x( 'Varypatades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010306' => _x( 'Viros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010307' => _x( 'Kalafationes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010308' => _x( 'Kamara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010309' => _x( 'Kastellani Messis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010310' => _x( 'Kato Garouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010311' => _x( 'Kouramades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010312' => _x( 'Kynopiastes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010313' => _x( 'Benitses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010314' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010401' => _x( 'Erikoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010501' => _x( 'Velonades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010502' => _x( 'Aghii Douli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010503' => _x( 'Agrafi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010504' => _x( 'Antiperni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010505' => _x( 'Avliotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010506' => _x( 'Valanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010507' => _x( 'Kavallouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010508' => _x( 'Karoussades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010509' => _x( 'Magoulades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010510' => _x( 'Peroulades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010511' => _x( 'Sidari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010601' => _x( 'Aghios Panteleimon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010602' => _x( 'Episkepsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010603' => _x( 'Klimatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010604' => _x( 'Lafkio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010605' => _x( 'Loutses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010606' => _x( 'Nymfes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010607' => _x( 'Xanthates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010608' => _x( 'Perithia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010609' => _x( 'Petalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010610' => _x( 'Sfakera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010701' => _x( 'Gimari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010702' => _x( 'Kassiopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010703' => _x( 'Nissaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010704' => _x( 'Sinies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010801' => _x( 'Argyrades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010802' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010803' => _x( 'Vassilatika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010804' => _x( 'Kouspades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010805' => _x( 'Perivoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010806' => _x( 'Petriti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010901' => _x( 'Lefkimmi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010902' => _x( 'Ano Lefkimmi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010903' => _x( 'Vitalades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32010904' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011001' => _x( 'Mathraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011101' => _x( 'Moraitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011102' => _x( 'Aghios Mattheos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011103' => _x( 'Ano Pavliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011104' => _x( 'Vouniatades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011105' => _x( 'Kato Pavliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011106' => _x( 'Pentati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011107' => _x( 'Strogyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011108' => _x( 'Chlomatiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011109' => _x( 'Chlomos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011201' => _x( 'Othoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011301' => _x( 'Lakones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011302' => _x( 'Alimmatades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011303' => _x( 'Gardelades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011304' => _x( 'Doukades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011305' => _x( 'Krini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011306' => _x( 'Liapades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011307' => _x( 'Makrades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011308' => _x( 'Skripero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011401' => _x( 'Kokkinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011402' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011403' => _x( 'Afra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011404' => _x( 'Vatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011405' => _x( 'Giannades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011406' => _x( 'Kanakades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011407' => _x( 'Kobitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011408' => _x( 'Marmaro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011409' => _x( 'Pelekas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011410' => _x( 'Sinarades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011501' => _x( 'Kato Korakiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011502' => _x( 'Aghios Markos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011503' => _x( 'Ano Korakiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011504' => _x( 'Zygos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011505' => _x( 'Sgourades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011506' => _x( 'Spartylas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32011507' => _x( 'Sokraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32020001' => _x( 'Gaios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32020002' => _x( 'Lakka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32020003' => _x( 'Logos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR32020004' => _x( 'Magazia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010101' => _x( 'Zakynthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010102' => _x( 'Abelokipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010103' => _x( 'Argassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010104' => _x( 'Vassilikos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010105' => _x( 'Gaitani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010106' => _x( 'Bochali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010201' => _x( 'Katastari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010202' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010203' => _x( 'Alikanas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010204' => _x( 'Ano Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010205' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010206' => _x( 'Kato Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010207' => _x( 'Messo Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010208' => _x( 'Pigadakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010209' => _x( 'Skoulikado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010301' => _x( 'Vanato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010302' => _x( 'Aghios Kirykos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010303' => _x( 'Kalipado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010304' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010305' => _x( 'Planos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010306' => _x( 'Sarakinado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010307' => _x( 'Tragaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010401' => _x( 'Macherado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010402' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010403' => _x( 'Aghios Leon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010404' => _x( 'Aghii Pantes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010405' => _x( 'Vouyato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010406' => _x( 'Galaro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010407' => _x( 'Gyrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010408' => _x( 'Kiliomenos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010409' => _x( 'Lagadakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010410' => _x( 'Lagopodo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010411' => _x( 'Loucha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010412' => _x( 'Romiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010413' => _x( 'Fiolitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010501' => _x( 'Volimes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010502' => _x( 'Anafonitria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010503' => _x( 'Ano Volimes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010504' => _x( 'Exo Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010505' => _x( 'Maries', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010506' => _x( 'Orthonies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010601' => _x( 'Pantokratoras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010602' => _x( 'Agalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010603' => _x( 'Kalamaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010604' => _x( 'Keri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010605' => _x( 'Lithakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR33010606' => _x( 'Mouzaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010001' => _x( 'Ithaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010002' => _x( 'Anogi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010003' => _x( 'Exogi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010004' => _x( 'Kioni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010005' => _x( 'Lefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010006' => _x( 'Perachori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010007' => _x( 'Platrithias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR34010008' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010101' => _x( 'Argostoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010102' => _x( 'Agonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010103' => _x( 'Davgata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010104' => _x( 'Dilinata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010105' => _x( 'Zola', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010106' => _x( 'Thinea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010107' => _x( 'Kourouklata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010108' => _x( 'Nyfio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010109' => _x( 'Troianata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010110' => _x( 'Faraklata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010111' => _x( 'Farsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010201' => _x( 'Pastra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010202' => _x( 'Aghia Irini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010203' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010204' => _x( 'Arginia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010205' => _x( 'Valerianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010206' => _x( 'Markopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010207' => _x( 'Mavrata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010208' => _x( 'Xenopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010209' => _x( 'Poros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010210' => _x( 'Skala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010211' => _x( 'Chionata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010301' => _x( 'Vassilikiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010302' => _x( 'Antipata Erissou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010303' => _x( 'Assos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010304' => _x( 'Vary', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010305' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010306' => _x( 'Kothreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010307' => _x( 'Komitata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010308' => _x( 'Messovounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010309' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010310' => _x( 'Patrikata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010311' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010312' => _x( 'Touliata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010313' => _x( 'Fiskardo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010401' => _x( 'Keramies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010402' => _x( 'Vlachata Ikossimias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010403' => _x( 'Karavados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010404' => _x( 'Lakithra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010405' => _x( 'Lourdata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010406' => _x( 'Metaxata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010407' => _x( 'Moussata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010408' => _x( 'Peratata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010409' => _x( 'Pessada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010410' => _x( 'Svoronata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010411' => _x( 'Spartia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010501' => _x( 'Omala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010601' => _x( 'Lixouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010602' => _x( 'Aghia Thekli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010603' => _x( 'Atheras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010604' => _x( 'Damoulianata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010605' => _x( 'Kaminarata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010606' => _x( 'Katogi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010607' => _x( 'Kontogenada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010608' => _x( 'Kouvalata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010609' => _x( 'Monopolata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010610' => _x( 'Rifio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010611' => _x( 'Skineas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010612' => _x( 'Soullari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010613' => _x( 'Favatata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010614' => _x( 'Chavdata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010615' => _x( 'Chavriata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010701' => _x( 'Aghia Efimia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010702' => _x( 'Divarata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010703' => _x( 'Makriotika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010801' => _x( 'Sami', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010802' => _x( 'Grizata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010803' => _x( 'Karavomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010804' => _x( 'Poulata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010805' => _x( 'Pyrgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR35010806' => _x( 'Chaliotata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010101' => _x( 'Lefkada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010102' => _x( 'Aghios Nikitas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010103' => _x( 'Alexandros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010104' => _x( 'Apolpena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010105' => _x( 'Kalamitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010106' => _x( 'Kariotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010107' => _x( 'Katouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010108' => _x( 'Tsoukalades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010201' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010202' => _x( 'Aghios Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010203' => _x( 'Aghios Petros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010204' => _x( 'Athanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010205' => _x( 'Vournikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010206' => _x( 'Dragano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010207' => _x( 'Evgiros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010208' => _x( 'Komilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010209' => _x( 'Kontarena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010210' => _x( 'Marantochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010211' => _x( 'Nikolis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010212' => _x( 'Syvros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010213' => _x( 'Chortata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010301' => _x( 'Nydri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010302' => _x( 'Vafkeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010303' => _x( 'Vlycho', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010304' => _x( 'Katochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010305' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010306' => _x( 'Platystoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010307' => _x( 'Poros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010308' => _x( 'Fterno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010309' => _x( 'Charadiatika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010401' => _x( 'Kalamos (Island)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010501' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010502' => _x( 'Eglouvi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010503' => _x( 'Pigadissani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010601' => _x( 'Kastos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010701' => _x( 'Lazarata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010702' => _x( 'Asprogerakata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010703' => _x( 'Drymonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010704' => _x( 'Exanthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010705' => _x( 'Kavallos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010706' => _x( 'Pinakochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36010707' => _x( 'Spanochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36020001' => _x( 'Katomeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36020002' => _x( 'Vathy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR36020003' => _x( 'Spartochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'G' => [
		'GR37010100' => _x( 'Patra (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010109' => _x( 'Elikistra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010110' => _x( 'Mira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010111' => _x( 'Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010201' => _x( 'Vrachneika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010202' => _x( 'Theriano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010203' => _x( 'Kaminia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010204' => _x( 'Monodendri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010205' => _x( 'Tsoukaleika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010301' => _x( 'Ovria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010302' => _x( 'Thea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010303' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010304' => _x( 'Krini Patron', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010305' => _x( 'Krystallovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010306' => _x( 'Petroto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010307' => _x( 'Saravalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010401' => _x( 'Paralia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010402' => _x( 'Mintilogli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010403' => _x( 'Rogitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010501' => _x( 'Rio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010502' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010503' => _x( 'Akteo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010504' => _x( 'Ano Kastritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010505' => _x( 'Arachovitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010506' => _x( 'Argyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010507' => _x( 'Drepano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010508' => _x( 'Kato Kastritsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010509' => _x( 'Pititsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010510' => _x( 'Platani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010511' => _x( 'Sella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37010512' => _x( 'Psathopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020101' => _x( 'Aegio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020102' => _x( 'Valimitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020103' => _x( 'Dafnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020104' => _x( 'Digeliotika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020105' => _x( 'Kouloura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020106' => _x( 'Koumaris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020107' => _x( 'Kounina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020108' => _x( 'Mavrikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020109' => _x( 'Melissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020110' => _x( 'Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020111' => _x( 'Pteri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020112' => _x( 'Selinous', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020113' => _x( 'Temeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020114' => _x( 'Chatzis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020201' => _x( 'Aegira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020202' => _x( 'Aeges', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020203' => _x( 'Abelokipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020204' => _x( 'Vela', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020205' => _x( 'Exochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020206' => _x( 'Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020207' => _x( 'Oassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020208' => _x( 'Perithorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020209' => _x( 'Seliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020210' => _x( 'Sinevro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020211' => _x( 'Chryssanthio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020301' => _x( 'Akrata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020302' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020303' => _x( 'Abelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020304' => _x( 'Valimi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020305' => _x( 'Voutsimos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020306' => _x( 'Zarouchla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020307' => _x( 'Kalamias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020308' => _x( 'Krathio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020309' => _x( 'Messorougi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020310' => _x( 'Paralia Platanou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020311' => _x( 'Peristera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020312' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020313' => _x( 'Porovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020314' => _x( 'Syliveniotika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020401' => _x( 'Diakopto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020402' => _x( 'Ano Diakopto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020403' => _x( 'Eleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020404' => _x( 'Eliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020405' => _x( 'Zachloritika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020406' => _x( 'Katholiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020407' => _x( 'Kerynia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020408' => _x( 'Mamoussia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020409' => _x( 'Nikoleika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020410' => _x( 'Rizomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020411' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020412' => _x( 'Trapeza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020501' => _x( 'Ziria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020502' => _x( 'Arravonitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020503' => _x( 'Damakinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020504' => _x( 'Kamares', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020505' => _x( 'Neos Erineos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020506' => _x( 'Salmeniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020601' => _x( 'Rododafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020602' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020603' => _x( 'Alsos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020604' => _x( 'Verino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020605' => _x( 'Grekas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020606' => _x( 'Grigoris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020607' => _x( 'Dimitropoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020608' => _x( 'Doukaneika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020609' => _x( 'Krini Aegialias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020610' => _x( 'Lakka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020611' => _x( 'Logos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020612' => _x( 'Magiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020613' => _x( 'Myrovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020614' => _x( 'Nerantzies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020615' => _x( 'Selianitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37020616' => _x( 'Touba', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030101' => _x( 'Kato Achaia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030102' => _x( 'Aghiovlassitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030103' => _x( 'Alissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030104' => _x( 'Ano Achaia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030105' => _x( 'Eleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030106' => _x( 'Kato Alissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030107' => _x( 'Niforeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030108' => _x( 'Petrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030201' => _x( 'Metochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030202' => _x( 'Aghios Nikolaos Spaton', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030203' => _x( 'Apideonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030204' => _x( 'Araxos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030205' => _x( 'Velitses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030206' => _x( 'Kagadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030207' => _x( 'Lakkopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030208' => _x( 'Mataraga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030209' => _x( 'Michoio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030210' => _x( 'Petas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030211' => _x( 'Riolos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030301' => _x( 'Sageika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030302' => _x( 'Kareika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030303' => _x( 'Krinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030304' => _x( 'Limnochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030305' => _x( 'Myrtos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030306' => _x( 'Fraga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030401' => _x( 'Loussika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030402' => _x( 'Aghios Nikolaos Kralis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030403' => _x( 'Aghios Stefanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030404' => _x( 'Ano Soudeneika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030405' => _x( 'Arla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030406' => _x( 'Achaiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030407' => _x( 'Galaneika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030408' => _x( 'Ganeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030409' => _x( 'Kato Mazaraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030410' => _x( 'Mitopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030411' => _x( 'Portes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030412' => _x( 'Santomeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030413' => _x( 'Flokas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030414' => _x( 'Fostena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030415' => _x( 'Charavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37030416' => _x( 'Chaikali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040101' => _x( 'Chalandritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040102' => _x( 'Vassiliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040103' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040104' => _x( 'Issoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040105' => _x( 'Kalanistra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040106' => _x( 'Kalanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040107' => _x( 'Kaloussio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040108' => _x( 'Katarraktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040109' => _x( 'Kritharakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040110' => _x( 'Lakkomata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040111' => _x( 'Miralio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040112' => _x( 'Neo Kobigadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040113' => _x( 'Platanovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040114' => _x( 'Starochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040115' => _x( 'Fares', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040116' => _x( 'Chryssopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040201' => _x( 'Kalentzi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040301' => _x( 'Leontio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040302' => _x( 'Ano Mazaraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040303' => _x( 'Demesticha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040401' => _x( 'Stavrodromi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040402' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040403' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040404' => _x( 'Alepochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040405' => _x( 'Velimachio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040406' => _x( 'Drossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040407' => _x( 'Erymanthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040408' => _x( 'Kalfas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040409' => _x( 'Manessio Patron', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040410' => _x( 'Roupakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040411' => _x( 'Skiadas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040412' => _x( 'Skouras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040413' => _x( 'Spartia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37040414' => _x( 'Chiona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050101' => _x( 'Kalavryta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050102' => _x( 'Ano Vlassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050103' => _x( 'Ano Loussi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050104' => _x( 'Valta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050105' => _x( 'Vilivina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050106' => _x( 'Goumenissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050107' => _x( 'Doumena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050108' => _x( 'Drossato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050109' => _x( 'Kallifonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050110' => _x( 'Kandalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050111' => _x( 'Kato Vlassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050112' => _x( 'Kato Zachlorou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050113' => _x( 'Kato Loussi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050114' => _x( 'Kerpini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050115' => _x( 'Kertezi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050116' => _x( 'Korfes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050117' => _x( 'Kouteli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050118' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050119' => _x( 'Lagovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050120' => _x( 'Lapanagi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050121' => _x( 'Manessio Kalavryton', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050122' => _x( 'Mikros Pontias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050123' => _x( 'Petsaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050124' => _x( 'Plataniotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050125' => _x( 'Priolithos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050126' => _x( 'Profitis Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050127' => _x( 'Rogi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050128' => _x( 'Sigounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050129' => _x( 'Skepasto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050130' => _x( 'Trechlo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050131' => _x( 'Flaboura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050201' => _x( 'Psofis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050202' => _x( 'Agrabela', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050203' => _x( 'Agridio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050204' => _x( 'Alestena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050205' => _x( 'Anastassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050206' => _x( 'Aroania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050207' => _x( 'Dessino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050208' => _x( 'Kameniani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050209' => _x( 'Lechouri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050210' => _x( 'Livartzi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050211' => _x( 'Plaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050212' => _x( 'Sires', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050301' => _x( 'Klitoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050302' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050303' => _x( 'Ano Klitoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050304' => _x( 'Arbounas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050305' => _x( 'Glastra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050306' => _x( 'Drymos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050307' => _x( 'Kastellio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050308' => _x( 'Kastria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050309' => _x( 'Kleitor', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050310' => _x( 'Krinofyta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050311' => _x( 'Lefkassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050312' => _x( 'Lykouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050313' => _x( 'Pagratio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050314' => _x( 'Planitero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050315' => _x( 'Tourlada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050316' => _x( 'Filia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050401' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050402' => _x( 'Amygdalea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050403' => _x( 'Nassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050404' => _x( 'Paos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050405' => _x( 'Pefko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050406' => _x( 'Skotani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR37050407' => _x( 'Chovoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010101' => _x( 'Messologhi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010102' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010103' => _x( 'Aghios Thomas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010104' => _x( 'Ano Koudouni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010105' => _x( 'Ellinika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010106' => _x( 'Evinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010107' => _x( 'Moussoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010108' => _x( 'Retsina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010201' => _x( 'Etoliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010202' => _x( 'Aghios Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010203' => _x( 'Stamna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010204' => _x( 'Fragouleika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010205' => _x( 'Chryssovergi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010301' => _x( 'Neochori Messologhiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010302' => _x( 'Gouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010303' => _x( 'Katochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010304' => _x( 'Lessini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010305' => _x( 'Mastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38010306' => _x( 'Pentalofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020101' => _x( 'Vonitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020102' => _x( 'Aghios Nikolaos Vonitsis & Xiromerou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020103' => _x( 'Drymos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020104' => _x( 'Thyrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020105' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020106' => _x( 'Paliabela', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020201' => _x( 'Katouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020202' => _x( 'Aetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020203' => _x( 'Achyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020204' => _x( 'Koboti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020205' => _x( 'Konopina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020206' => _x( 'Tryfos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020301' => _x( 'Paleros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020302' => _x( 'Vatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020303' => _x( 'Peratia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020304' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38020305' => _x( 'Pogonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030101' => _x( 'Agrinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030102' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030103' => _x( 'Aghios Nikolaos Trichonidos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030104' => _x( 'Dokimio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030105' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030106' => _x( 'Kamaroula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030107' => _x( 'Skoutessiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030201' => _x( 'Aghelokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030202' => _x( 'Klissorevmata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030203' => _x( 'Lyssimachia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030301' => _x( 'Pappadates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030302' => _x( 'Ano Kerassovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030303' => _x( 'Grammatikou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030304' => _x( 'Zevgaraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030305' => _x( 'Kato Kerassovo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030306' => _x( 'Mataraga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030401' => _x( 'Kenourgio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030402' => _x( 'Nea Avorani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030403' => _x( 'Panetolio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030404' => _x( 'Prossilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030501' => _x( 'Gavalou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030502' => _x( 'Aghios Andreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030503' => _x( 'Akres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030504' => _x( 'Dafnias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030505' => _x( 'Kato Makrinou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030506' => _x( 'Kapsorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030507' => _x( 'Makrinou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030508' => _x( 'Messarista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030509' => _x( 'Potamoula Messologhiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030510' => _x( 'Trichonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030601' => _x( 'Eleofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030602' => _x( 'Megali Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030603' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030604' => _x( 'Spolaita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030701' => _x( 'Skoutera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030702' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030703' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030704' => _x( 'Kastanoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030705' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030706' => _x( 'Sitomena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030801' => _x( 'Paravola', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030802' => _x( 'Afrato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030803' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030804' => _x( 'Kyra Vgena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030805' => _x( 'Labiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030806' => _x( 'Neromanna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030807' => _x( 'Paleokarya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030808' => _x( 'Pantanassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030809' => _x( 'Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030810' => _x( 'Spartias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030901' => _x( 'Aghios Vlassios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030902' => _x( 'Agalianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030903' => _x( 'Abelia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030904' => _x( 'Kyparissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030905' => _x( 'Pentakorfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030906' => _x( 'Potamoula Trichonidos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030907' => _x( 'Sargiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030908' => _x( 'Sidira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030909' => _x( 'Chouni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38030910' => _x( 'Psilovrachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031001' => _x( 'Stratos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031002' => _x( 'Gouriotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031003' => _x( 'Kastraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031004' => _x( 'Kypseli (Sfina)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031005' => _x( 'Lepenou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031006' => _x( 'Matsouki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031007' => _x( 'Ochthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38031008' => _x( 'Rigani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040101' => _x( 'Amfilochia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040102' => _x( 'Abelaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040103' => _x( 'Anixiatiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040104' => _x( 'Varetada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040105' => _x( 'Kechrinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040106' => _x( 'Loutro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040107' => _x( 'Megalos Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040108' => _x( 'Sardinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040109' => _x( 'Sparto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040110' => _x( 'Stanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040201' => _x( 'Chalkiopouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040202' => _x( 'Agridio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040203' => _x( 'Alevrada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040204' => _x( 'Amorgiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040205' => _x( 'Vrouviana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040206' => _x( 'Giannopouli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040207' => _x( 'Ebessos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040208' => _x( 'Malessiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040209' => _x( 'Babalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040210' => _x( 'Patiopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040211' => _x( 'Perdikaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040212' => _x( 'Petrona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040213' => _x( 'Podogora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040214' => _x( 'Stathas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040215' => _x( 'Triklino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040301' => _x( 'Menidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38040302' => _x( 'Floriada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050001' => _x( 'Thermo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050002' => _x( 'Avarikos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050003' => _x( 'Aghia Sofia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050004' => _x( 'Aetopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050005' => _x( 'Amvrakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050006' => _x( 'Analipsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050007' => _x( 'Argyro Pigadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050008' => _x( 'Diassellaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050009' => _x( 'Diplatanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050010' => _x( 'Drymonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050011' => _x( 'Kaloudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050012' => _x( 'Kato Chryssovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050013' => _x( 'Kokkinovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050014' => _x( 'Koniska', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050015' => _x( 'Lefko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050016' => _x( 'Myrtia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050017' => _x( 'Nerochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050018' => _x( 'Pamfio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050019' => _x( 'Perkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050020' => _x( 'Petrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050021' => _x( 'Sitaralona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050022' => _x( 'Chaliki Amvrakias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38050023' => _x( 'Chryssovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060101' => _x( 'Nafpaktos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060102' => _x( 'Afroxylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060103' => _x( 'Velvina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060104' => _x( 'Vlachomandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060105' => _x( 'Vomvokou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060106' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060107' => _x( 'Lygias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060108' => _x( 'Mamoulada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060109' => _x( 'Neokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060110' => _x( 'Xiropigado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060111' => _x( 'Paleochoraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060112' => _x( 'Pitsineika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060113' => _x( 'Riganio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060114' => _x( 'Skala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060201' => _x( 'Antirrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060202' => _x( 'Makynia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060203' => _x( 'Molykrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060301' => _x( 'Ano Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060302' => _x( 'Abelakiotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060303' => _x( 'Anavryti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060304' => _x( 'Aspria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060305' => _x( 'Grammeni Oxya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060306' => _x( 'Grigorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060307' => _x( 'Elatovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060308' => _x( 'Elatou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060309' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060310' => _x( 'Katafygio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060311' => _x( 'Kato Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060312' => _x( 'Kentriki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060313' => _x( 'Kokkinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060314' => _x( 'Kryoneria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060315' => _x( 'Kydonea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060316' => _x( 'Lefka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060317' => _x( 'Limnitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060318' => _x( 'Mandrini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060319' => _x( 'Podos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060320' => _x( 'Terpsithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060401' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060402' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060403' => _x( 'Arachova', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060404' => _x( 'Achladokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060405' => _x( 'Dendrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060406' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060407' => _x( 'Klepa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060408' => _x( 'Livadaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060409' => _x( 'Neochori Nafpaktias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060410' => _x( 'Perdikovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060411' => _x( 'Perista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060412' => _x( 'Chomori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060501' => _x( 'Simos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060502' => _x( 'Anthofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060503' => _x( 'Gavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060504' => _x( 'Dorvitsia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060505' => _x( 'Eleftheriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060506' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060507' => _x( 'Paleopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060508' => _x( 'Pokista', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060509' => _x( 'Stranoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060510' => _x( 'Stylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060511' => _x( 'Famila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060601' => _x( 'Trikorfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060602' => _x( 'Ano Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060603' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060604' => _x( 'Gavrolimni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060605' => _x( 'Galatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060606' => _x( 'Kalavrouza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38060607' => _x( 'Perithorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070101' => _x( 'Astakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070102' => _x( 'Agrabela', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070103' => _x( 'Vassilopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070104' => _x( 'Vliziana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070105' => _x( 'Karaiskakis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070106' => _x( 'Macheras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070107' => _x( 'Babini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070108' => _x( 'Paleomanina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070109' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070110' => _x( 'Skourtou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070111' => _x( 'Strogylovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070112' => _x( 'Chryssovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070201' => _x( 'Kandila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070202' => _x( 'Archontochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070203' => _x( 'Varnakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070204' => _x( 'Mytikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070205' => _x( 'Panagoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070301' => _x( 'Fyties', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR38070302' => _x( 'Pappadatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010101' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010102' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010103' => _x( 'Aghios Ilias Pyrgou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010104' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010105' => _x( 'Abelonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010106' => _x( 'Varvassena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010107' => _x( 'Vytineika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010108' => _x( 'Granitseika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010109' => _x( 'Eleonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010110' => _x( 'Katakolo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010111' => _x( 'Kolirio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010112' => _x( 'Korakochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010113' => _x( 'Lasteika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010114' => _x( 'Leventochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010115' => _x( 'Myrtia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010116' => _x( 'Paleovarvassena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010117' => _x( 'Salmoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010118' => _x( 'Skafidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010119' => _x( 'Skourochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010201' => _x( 'Epitalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010202' => _x( 'Agridio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010203' => _x( 'Alfioussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010204' => _x( 'Anemochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010301' => _x( 'Vounargo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010302' => _x( 'Aghii Apostoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010303' => _x( 'Alpochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010304' => _x( 'Vrochitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010305' => _x( 'Katsaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010306' => _x( 'Koryfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010307' => _x( 'Xylokera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010308' => _x( 'Prassino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010309' => _x( 'Fonaitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010401' => _x( 'Karatoulas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010402' => _x( 'Aghia Anna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010403' => _x( 'Arvanitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010404' => _x( 'Goumero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010405' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010406' => _x( 'Klindia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010407' => _x( 'Koutsochera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010408' => _x( 'Lanthio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010409' => _x( 'Latzoio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010410' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010411' => _x( 'Mouzaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010412' => _x( 'Pefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010413' => _x( 'Sopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010414' => _x( 'Charia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010415' => _x( 'Chimadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39010416' => _x( 'Oleni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020101' => _x( 'Amaliada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020102' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020103' => _x( 'Aghios Ilias Piniion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020104' => _x( 'Abelokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020105' => _x( 'Archea Ilida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020106' => _x( 'Avgio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020107' => _x( 'Gerakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020108' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020109' => _x( 'Dafniotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020110' => _x( 'Douneika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020111' => _x( 'Kalyvia Ilidas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020112' => _x( 'Kardamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020113' => _x( 'Kentro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020114' => _x( 'Keramidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020115' => _x( 'Kryonero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020116' => _x( 'Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020117' => _x( 'Roviata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020118' => _x( 'Savalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020119' => _x( 'Sostio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020120' => _x( 'Chavari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020201' => _x( 'Simopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020202' => _x( 'Agnanta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020203' => _x( 'Agrapidochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020204' => _x( 'Anthonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020205' => _x( 'Avgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020206' => _x( 'Velanidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020207' => _x( 'Vouliagmeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020208' => _x( 'Efyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020209' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020210' => _x( 'Laganas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020211' => _x( 'Latas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020212' => _x( 'Loukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020213' => _x( 'Mazaraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020214' => _x( 'Inoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020215' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39020216' => _x( 'Skliva', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030101' => _x( 'Lechena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030102' => _x( 'Aghios Charalabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030103' => _x( 'Areti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030104' => _x( 'Melissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030105' => _x( 'Borsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030106' => _x( 'Myrsini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030201' => _x( 'Andravida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030202' => _x( 'Stafidokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030203' => _x( 'Stroussio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030301' => _x( 'Varda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030302' => _x( 'Aetorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030303' => _x( 'Kapeleto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030304' => _x( 'Kourtessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030305' => _x( 'Manolada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030306' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030307' => _x( 'Nea Manolada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030308' => _x( 'Nissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030309' => _x( 'Xenies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030401' => _x( 'Kyllini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030402' => _x( 'Kastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030403' => _x( 'Kato Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39030404' => _x( 'Neochori Myrtountion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040101' => _x( 'Krestena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040102' => _x( 'Vrina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040103' => _x( 'Grekas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040104' => _x( 'Gryllos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040105' => _x( 'Diassella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040106' => _x( 'Kallikomo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040107' => _x( 'Kalyvakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040108' => _x( 'Kato Samiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040109' => _x( 'Makrissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040110' => _x( 'Platiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040111' => _x( 'Ploutochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040112' => _x( 'Raches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040113' => _x( 'Samiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040114' => _x( 'Skillountia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040115' => _x( 'Trypiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040116' => _x( 'Frixa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040201' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040202' => _x( 'Alifira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040203' => _x( 'Amygdalies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040204' => _x( 'Vresto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040205' => _x( 'Livadaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040206' => _x( 'Myronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040301' => _x( 'Andritsena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040302' => _x( 'Dafnoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040303' => _x( 'Dragogio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040304' => _x( 'Thissoa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040305' => _x( 'Koufopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040306' => _x( 'Linistena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040307' => _x( 'Matessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040308' => _x( 'Rovia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040309' => _x( 'Sekoulas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39040310' => _x( 'Fanari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050101' => _x( 'Archea Olympia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050102' => _x( 'Archea Pissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050103' => _x( 'Aspra Spitia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050104' => _x( 'Vassilaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050105' => _x( 'Iraklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050106' => _x( 'Kamena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050107' => _x( 'Kafkonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050108' => _x( 'Kladeos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050109' => _x( 'Koskinas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050110' => _x( 'Kryonerio Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050111' => _x( 'Linaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050112' => _x( 'Louvro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050113' => _x( 'Magiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050114' => _x( 'Mouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050115' => _x( 'Xirokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050116' => _x( 'Pelopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050117' => _x( 'Pefkes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050118' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050119' => _x( 'Pournari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050120' => _x( 'Smila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050121' => _x( 'Strefi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050122' => _x( 'Flokas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050123' => _x( 'Chelidoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050201' => _x( 'Labia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050202' => _x( 'Astras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050203' => _x( 'Orini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050301' => _x( 'Antronio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050302' => _x( 'Aghia Kyriaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050303' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050304' => _x( 'Kakotari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050305' => _x( 'Kryovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050306' => _x( 'Tsipiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050401' => _x( 'Lalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050402' => _x( 'Achladini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050403' => _x( 'Doukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050404' => _x( 'Koumanis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050405' => _x( 'Milies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050406' => _x( 'Nemouta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050407' => _x( 'Neraida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050408' => _x( 'Persena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39050409' => _x( 'Foloi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060101' => _x( 'Zacharo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060102' => _x( 'Aghios Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060103' => _x( 'Anilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060104' => _x( 'Arini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060105' => _x( 'Artemis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060106' => _x( 'Giannitsochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060107' => _x( 'Kakovatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060108' => _x( 'Kalidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060109' => _x( 'Lepreo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060110' => _x( 'Makistos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060111' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060112' => _x( 'Minthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060113' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060114' => _x( 'Xirochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060115' => _x( 'Prassidaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060116' => _x( 'Rodina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060117' => _x( 'Smerna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060118' => _x( 'Schini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060119' => _x( 'Taxiarches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060120' => _x( 'Chryssochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060201' => _x( 'Nea Figalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060202' => _x( 'Kryonerio Olympias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060203' => _x( 'Perivolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060204' => _x( 'Petralona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060205' => _x( 'Stomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39060206' => _x( 'Figalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070101' => _x( 'Gastouni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070102' => _x( 'Kavassilas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070103' => _x( 'Kardiakaftio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070104' => _x( 'Korivos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070105' => _x( 'Lefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070106' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070107' => _x( 'Roupaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070201' => _x( 'Vartholomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070202' => _x( 'Dimitra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070203' => _x( 'Kalyvia Myrtountion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070204' => _x( 'Lygia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070205' => _x( 'Machos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070301' => _x( 'Tragano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070302' => _x( 'Aghia Mavra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR39070303' => _x( 'Simiza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'J' => [
		'GR40010101' => _x( 'Tripoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010102' => _x( 'Aghios Vassilios Mantinias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010103' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010104' => _x( 'Evandro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010105' => _x( 'Thanas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010106' => _x( 'Makri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010107' => _x( 'Merkovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010108' => _x( 'Pallantio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010109' => _x( 'Pelagos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010110' => _x( 'Perthorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010111' => _x( 'Skopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010201' => _x( 'Assea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010202' => _x( 'Agriakona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010203' => _x( 'Athineo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010204' => _x( 'Abelaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010205' => _x( 'Arachamites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010206' => _x( 'Valtetsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010207' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010208' => _x( 'Dorizas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010209' => _x( 'Kaltezes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010210' => _x( 'Kerastaris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010211' => _x( 'Manaris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010212' => _x( 'Mavroyannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010213' => _x( 'Paleochouni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010214' => _x( 'Paparis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010301' => _x( 'Steno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010302' => _x( 'Aghiorgitika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010303' => _x( 'Eleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010304' => _x( 'Zevgolatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010305' => _x( 'Neochori Mantinias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010306' => _x( 'Parthenio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010401' => _x( 'Levidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010402' => _x( 'Vlacherna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010403' => _x( 'Daras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010404' => _x( 'Kandila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010405' => _x( 'Kardaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010406' => _x( 'Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010407' => _x( 'Limni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010408' => _x( 'Orchomenos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010409' => _x( 'Paleopyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010410' => _x( 'Panagitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010411' => _x( 'Chotoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010501' => _x( 'Nestani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010502' => _x( 'Artemissio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010503' => _x( 'Kapsas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010504' => _x( 'Loukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010505' => _x( 'Pikernis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010506' => _x( 'Sagas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010507' => _x( 'Simiades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010601' => _x( 'Vlachokerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010602' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010603' => _x( 'Alepochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010604' => _x( 'Vourvoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010605' => _x( 'Kerassea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010606' => _x( 'Kollines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010607' => _x( 'Pigadakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010701' => _x( 'Stadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010702' => _x( 'Alea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010703' => _x( 'Vouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010704' => _x( 'Garea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010705' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010706' => _x( 'Kamari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010707' => _x( 'Kandalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010708' => _x( 'Kerassitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010709' => _x( 'Lithovounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010710' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010711' => _x( 'Manthyrea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010712' => _x( 'Mavrikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010713' => _x( 'Rizes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010714' => _x( 'Strigos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010715' => _x( 'Tzivas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010716' => _x( 'Psili Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010801' => _x( 'Tselepakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010802' => _x( 'Alonistena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010803' => _x( 'Menalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010804' => _x( 'Piana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010805' => _x( 'Roino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010806' => _x( 'Silimna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40010807' => _x( 'Chryssovitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020001' => _x( 'Astros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020002' => _x( 'Aghia Sofia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020003' => _x( 'Aghios Andreas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020004' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020005' => _x( 'Aghios Petros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020006' => _x( 'Vervena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020007' => _x( 'Doliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020008' => _x( 'Elatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020009' => _x( 'Karatoulas Kynourias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020010' => _x( 'Kastanitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020011' => _x( 'Kastri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020012' => _x( 'Korakovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020013' => _x( 'Koutroufa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020014' => _x( 'Meligou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020015' => _x( 'Messorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020016' => _x( 'Nea Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020017' => _x( 'Xiropigado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020018' => _x( 'Paralio Astros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020019' => _x( 'Perdikovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020020' => _x( 'Platana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020021' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020022' => _x( 'Prastos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020023' => _x( 'Sitena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020024' => _x( 'Stolos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020025' => _x( 'Charadros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40020026' => _x( 'Oria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030101' => _x( 'Dimitsana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030102' => _x( 'Zatouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030103' => _x( 'Zigovisti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030104' => _x( 'Melissopetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030105' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030106' => _x( 'Rados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030107' => _x( 'Rizospilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030201' => _x( 'Vytina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030202' => _x( 'Elati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030203' => _x( 'Kamenitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030204' => _x( 'Lasta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030205' => _x( 'Magouliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030206' => _x( 'Nymfassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030207' => _x( 'Pyrgaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030301' => _x( 'Palouba', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030302' => _x( 'Aghios Ioannis Archeas Ireas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030303' => _x( 'Arachova', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030304' => _x( 'Kakoureika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030305' => _x( 'Kokkinorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030306' => _x( 'Kokkoras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030307' => _x( 'Liodora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030308' => _x( 'Loutra Ireas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030309' => _x( 'Lykouressis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030310' => _x( 'Lyssarea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030311' => _x( 'Ochthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030312' => _x( 'Pyrris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030313' => _x( 'Raftis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030314' => _x( 'Sarakinio Ireas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030315' => _x( 'Servos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030316' => _x( 'Chryssochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030317' => _x( 'Psari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030401' => _x( 'Mygdalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030402' => _x( 'Agridio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030403' => _x( 'Valtessiniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030404' => _x( 'Drakovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030405' => _x( 'Theoktisto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030406' => _x( 'Kerpini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030407' => _x( 'Xirokaritena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030408' => _x( 'Pournaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030409' => _x( 'Prassino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030501' => _x( 'Kontovazena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030502' => _x( 'Vachlia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030503' => _x( 'Velimachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030504' => _x( 'Vidiakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030505' => _x( 'Voutsis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030506' => _x( 'Dimitra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030507' => _x( 'Kardaritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030508' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030509' => _x( 'Paraloghi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030601' => _x( 'Lagadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030602' => _x( 'Lefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030701' => _x( 'Stemnitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030702' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030703' => _x( 'Palamari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030704' => _x( 'Pavlia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030705' => _x( 'Syrna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030801' => _x( 'Tropea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030802' => _x( 'Aetorrachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030803' => _x( 'Vyzikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030804' => _x( 'Doxa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030805' => _x( 'Kallianio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030806' => _x( 'Kastraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030807' => _x( 'Livadaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030808' => _x( 'Neochori Gortynias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030809' => _x( 'Perdikoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030810' => _x( 'Raches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030811' => _x( 'Spatharis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030812' => _x( 'Stavrodromi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030813' => _x( 'Tripotamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40030814' => _x( 'Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040101' => _x( 'Megalopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040102' => _x( 'Anthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040103' => _x( 'Ano Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040104' => _x( 'Vagos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040105' => _x( 'Vastas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040106' => _x( 'Gefyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040107' => _x( 'Thoknia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040108' => _x( 'Issaris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040109' => _x( 'Issoma Karyon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040110' => _x( 'Karatoulas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040111' => _x( 'Kastanochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040112' => _x( 'Kato Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040113' => _x( 'Lykeo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040114' => _x( 'Lykossoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040115' => _x( 'Lykochia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040116' => _x( 'Makryssio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040117' => _x( 'Mallota', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040118' => _x( 'Marathoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040119' => _x( 'Nea Eklissoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040120' => _x( 'Neochori  Lykossouras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040121' => _x( 'Paradissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040122' => _x( 'Perivolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040123' => _x( 'Plaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040124' => _x( 'Rapsommatis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040125' => _x( 'Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040126' => _x( 'Soulos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040127' => _x( 'Trilofo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040128' => _x( 'Tripotamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040129' => _x( 'Chirades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040130' => _x( 'Chrani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040131' => _x( 'Choremis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040201' => _x( 'Karitena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040202' => _x( 'Atsicholos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040203' => _x( 'Zoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040204' => _x( 'Katsibalis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040205' => _x( 'Kourounios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040206' => _x( 'Kyparissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040207' => _x( 'Kotilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040208' => _x( 'Marathas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040209' => _x( 'Mavria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040210' => _x( 'Sarakinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040301' => _x( 'Leontari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040302' => _x( 'Akovos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040303' => _x( 'Anavryto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040304' => _x( 'Anemodourio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040305' => _x( 'Veligosti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040306' => _x( 'Voutsaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040307' => _x( 'Giannei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040308' => _x( 'Grekos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040309' => _x( 'Dyrrachio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040310' => _x( 'Ellinitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040311' => _x( 'Kamara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040312' => _x( 'Leptinio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040313' => _x( 'Neochori Falessias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040314' => _x( 'Petrina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040315' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040316' => _x( 'Routsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040317' => _x( 'Skortsinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040318' => _x( 'Soulario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040319' => _x( 'Tourkolekas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40040320' => _x( 'Falessia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050101' => _x( 'Leonidio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050102' => _x( 'Aghios Vassilios Kynourias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050103' => _x( 'Vlissidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050104' => _x( 'Kounoupia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050105' => _x( 'Mario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050106' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050107' => _x( 'Peleta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050108' => _x( 'Pigadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050109' => _x( 'Platanaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050110' => _x( 'Poulithra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050111' => _x( 'Pragmateftis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050112' => _x( 'Tsitalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050201' => _x( 'Cosmas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050301' => _x( 'Tyros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050302' => _x( 'Pera Melana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR40050303' => _x( 'Sapounakeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010101' => _x( 'Nafplio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010102' => _x( 'Aria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010103' => _x( 'Lefkakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010104' => _x( 'Pyrgiotika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010201' => _x( 'Drepano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010202' => _x( 'Assini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010203' => _x( 'Iria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010204' => _x( 'Karnezeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010205' => _x( 'Tolo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010301' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010302' => _x( 'Anyfio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010303' => _x( 'Arachneo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010304' => _x( 'Argoliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010305' => _x( 'Ireo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010306' => _x( 'Manessis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010307' => _x( 'Midea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010308' => _x( 'Panaritis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010309' => _x( 'Poullakida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010401' => _x( 'Nea Tiryntha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010402' => _x( 'Aghios Adrianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41010403' => _x( 'Neo Roino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020101' => _x( 'Argos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020102' => _x( 'Dalamanara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020103' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020104' => _x( 'Ira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020105' => _x( 'Inachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020106' => _x( 'Kefalari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020107' => _x( 'Kourtakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020108' => _x( 'Laloukas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020109' => _x( 'Pyrgella', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020201' => _x( 'Skotini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020202' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020203' => _x( 'Alea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020204' => _x( 'Froussiouna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020301' => _x( 'Achladokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020401' => _x( 'Koutsopodi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020402' => _x( 'Vroustio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020403' => _x( 'Malandreni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020404' => _x( 'Schinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020501' => _x( 'Myli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020502' => _x( 'Andritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020503' => _x( 'Kiveri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020504' => _x( 'Skafidaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020601' => _x( 'Lyrkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020602' => _x( 'Gymno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020603' => _x( 'Kaparelli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020604' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020605' => _x( 'Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020606' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020607' => _x( 'Sterna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020608' => _x( 'Fregena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020701' => _x( 'Mykines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020702' => _x( 'Limnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020703' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020704' => _x( 'Borsas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020705' => _x( 'Neo Ireo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020706' => _x( 'Prossymna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020707' => _x( 'Fichti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41020801' => _x( 'Nea Kios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030101' => _x( 'Asklipiio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030102' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030103' => _x( 'Adamio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030104' => _x( 'Arkadiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030201' => _x( 'Archea Epidavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030202' => _x( 'Dimena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030203' => _x( 'Nea Epidavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41030204' => _x( 'Trachia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040101' => _x( 'Kranidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040102' => _x( 'Didyma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040103' => _x( 'Kilada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040104' => _x( 'Portocheli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040105' => _x( 'Fourni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040201' => _x( 'Ermioni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040202' => _x( 'Iliokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR41040203' => _x( 'Thermissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010101' => _x( 'Korinthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010102' => _x( 'Archea Korinthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010103' => _x( 'Examilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010104' => _x( 'Xylokeriza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010105' => _x( 'Solomos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010201' => _x( 'Perigiali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010202' => _x( 'Assos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010203' => _x( 'Kato Assos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010204' => _x( 'Lecheo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010301' => _x( 'Athikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010302' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010303' => _x( 'Galataki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010304' => _x( 'Katakali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010401' => _x( 'Sofiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010402' => _x( 'Aghelokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010403' => _x( 'Korfos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010501' => _x( 'Chiliomodi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010502' => _x( 'Aghionori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010503' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010504' => _x( 'Klenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010505' => _x( 'Koutalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42010506' => _x( 'Stefani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020101' => _x( 'Zevgolatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020102' => _x( 'Vochaiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020103' => _x( 'Vrachati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020104' => _x( 'Evaghelistria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020105' => _x( 'Bolati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020106' => _x( 'Soulinari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020107' => _x( 'Chalkio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020201' => _x( 'Velo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020202' => _x( 'Ellinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020203' => _x( 'Kokkoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020204' => _x( 'Krines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020205' => _x( 'Nerantza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020206' => _x( 'Poullitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020207' => _x( 'Stimaga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42020208' => _x( 'Tarsina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42030101' => _x( 'Loutraki-Perachora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42030102' => _x( 'Isthmia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42030103' => _x( 'Pissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42030201' => _x( 'Aghii Theodori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040001' => _x( 'Nemea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040002' => _x( 'Aidonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040003' => _x( 'Archea Nemea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040004' => _x( 'Archees Kleones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040005' => _x( 'Galatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040006' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040007' => _x( 'Kastraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040008' => _x( 'Koutsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040009' => _x( 'Leontio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42040010' => _x( 'Petri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050101' => _x( 'Xylokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050102' => _x( 'Ano Trikala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050103' => _x( 'Geliniatika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050104' => _x( 'Dendro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050105' => _x( 'Zemeno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050106' => _x( 'Thalero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050107' => _x( 'Throfari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050108' => _x( 'Kamari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050109' => _x( 'Karya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050110' => _x( 'Kato Loutro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050111' => _x( 'Kato Synikia Trikalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050112' => _x( 'Korfiotissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050113' => _x( 'Lagadeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050114' => _x( 'Manna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050115' => _x( 'Melissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050116' => _x( 'Messi Synikia Trikalon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050117' => _x( 'Nees Vryssoules', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050118' => _x( 'Xanthochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050119' => _x( 'Panariti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050120' => _x( 'Pellini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050121' => _x( 'Pitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050122' => _x( 'Rethio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050123' => _x( 'Riza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050124' => _x( 'Sofiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050125' => _x( 'Stylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050126' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050201' => _x( 'Derveni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050202' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050203' => _x( 'Evrostina-Rozena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050204' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050205' => _x( 'Lygia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050206' => _x( 'Lykoporia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050207' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050208' => _x( 'Sarantapicho', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050209' => _x( 'Stomio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42050210' => _x( 'Chelydoreo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060101' => _x( 'Sikyona - Kiato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060102' => _x( 'Velina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060103' => _x( 'Gonoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060104' => _x( 'Diminio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060105' => _x( 'Kato Diminio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060106' => _x( 'Klimenti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060107' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060108' => _x( 'Laliotis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060109' => _x( 'Megas Valtos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060110' => _x( 'Mikros Valtos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060111' => _x( 'Moulki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060112' => _x( 'Bozikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060113' => _x( 'Paradissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060114' => _x( 'Passio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060115' => _x( 'Arhea Sikyona - Vassiliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060116' => _x( 'Souli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060117' => _x( 'Titani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060201' => _x( 'Kaliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060202' => _x( 'Asprokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060203' => _x( 'Drossopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060204' => _x( 'Kessari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060205' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060206' => _x( 'Kefalari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060207' => _x( 'Kyllini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060208' => _x( 'Lafka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060209' => _x( 'Stymfalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060210' => _x( 'Psari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060301' => _x( 'Goura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060302' => _x( 'Archea Feneos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060303' => _x( 'Kato Tarsos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060304' => _x( 'Mati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060305' => _x( 'Messino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060306' => _x( 'Mossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060307' => _x( 'Panorama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060308' => _x( 'Steno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR42060309' => _x( 'Feneos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010101' => _x( 'Sparti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010102' => _x( 'Amykles', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010103' => _x( 'Afissio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010104' => _x( 'Kalyvia Sochas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010105' => _x( 'Kladas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010201' => _x( 'Goritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010202' => _x( 'Aghii Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010203' => _x( 'Agriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010204' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010205' => _x( 'Kefalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010206' => _x( 'Platana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010207' => _x( 'Skoura', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010208' => _x( 'Chryssafa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010301' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010401' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010402' => _x( 'Aghia Irini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010403' => _x( 'Aghios Ioannis Lakedaemonos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010404' => _x( 'Anavryti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010405' => _x( 'Logastra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010406' => _x( 'Mystras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010407' => _x( 'Parorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010408' => _x( 'Soustiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010409' => _x( 'Trypi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010501' => _x( 'Selassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010502' => _x( 'Vamvakou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010503' => _x( 'Varvitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010504' => _x( 'Vassaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010505' => _x( 'Voutiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010506' => _x( 'Vresthena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010507' => _x( 'Theologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010508' => _x( 'Koniditsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010601' => _x( 'Kastorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010602' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010603' => _x( 'Agoriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010604' => _x( 'Alevrou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010605' => _x( 'Vordonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010606' => _x( 'Georgitsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010607' => _x( 'Loganikos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010608' => _x( 'Pellana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010609' => _x( 'Perivolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010701' => _x( 'Xirokabi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010702' => _x( 'Anogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010703' => _x( 'Arna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010704' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010705' => _x( 'Gorani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010706' => _x( 'Kaminia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010707' => _x( 'Lefkochoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010708' => _x( 'Paleopanaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010709' => _x( 'Polovitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010710' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010711' => _x( 'Spartia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43010712' => _x( 'Trapezanti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020101' => _x( 'Gythio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020102' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020103' => _x( 'Aegies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020104' => _x( 'Drossopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020105' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020106' => _x( 'Karvelas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020107' => _x( 'Karyoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020108' => _x( 'Konakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020109' => _x( 'Krini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020110' => _x( 'Lygereas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020111' => _x( 'Marathea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020112' => _x( 'Myrsini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020113' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020114' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020115' => _x( 'Sidirokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020116' => _x( 'Skamnaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020117' => _x( 'Skoutari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020118' => _x( 'Chossiario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020201' => _x( 'Kotronas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020202' => _x( 'Drymos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020203' => _x( 'Exo Nymfio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020204' => _x( 'Kokkala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020205' => _x( 'Lagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020206' => _x( 'Pyrrichos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020301' => _x( 'Areopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020302' => _x( 'Alika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020303' => _x( 'Ano Boularii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020304' => _x( 'Vathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020305' => _x( 'Vachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020306' => _x( 'Germa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020307' => _x( 'Gerolimenas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020308' => _x( 'Dryalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020309' => _x( 'Karea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020310' => _x( 'Kelefa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020311' => _x( 'Kita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020312' => _x( 'Kounos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020313' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020314' => _x( 'Mina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020315' => _x( 'Neo Itylo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020316' => _x( 'Itylo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020317' => _x( 'Pyrgos Dirou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020318' => _x( 'Tsikkalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020401' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020402' => _x( 'Archontiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020403' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020404' => _x( 'Kokkina Louria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020405' => _x( 'Melissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020406' => _x( 'Melitini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020407' => _x( 'Paleovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020408' => _x( 'Petrina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020409' => _x( 'Prossilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43020410' => _x( 'Selegoudi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43030000' => _x( 'Elafonissos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040101' => _x( 'Skala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040102' => _x( 'Vrontamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040103' => _x( 'Gramoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040104' => _x( 'Leimonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040105' => _x( 'Peristeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040106' => _x( 'Stefania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040201' => _x( 'Vlachiotis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040202' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040203' => _x( 'Asteri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040204' => _x( 'Glykovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040205' => _x( 'Gouves', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040206' => _x( 'Elos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040207' => _x( 'Myrtea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040301' => _x( 'Geraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040302' => _x( 'Alepochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040303' => _x( 'Zarafona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040304' => _x( 'Karitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040401' => _x( 'Krokees', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040402' => _x( 'Vassilaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040403' => _x( 'Dafnio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040404' => _x( 'Lagio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040501' => _x( 'Aghios Dimitrios Zaraka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040502' => _x( 'Apidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040503' => _x( 'Kremasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43040504' => _x( 'Niata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050101' => _x( 'Molai', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050102' => _x( 'Elea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050103' => _x( 'Koupia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050104' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050105' => _x( 'Pakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050106' => _x( 'Sykia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050201' => _x( 'Papadianika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050202' => _x( 'Assopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050203' => _x( 'Demonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050204' => _x( 'Finikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050301' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050302' => _x( 'Aghios Georgios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050303' => _x( 'Aghios Nikolaos Voion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050304' => _x( 'Aghii Apostoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050305' => _x( 'Ano Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050306' => _x( 'Velanidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050307' => _x( 'Elika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050308' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050309' => _x( 'Kastania Epidavrou Limiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050310' => _x( 'Lachio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050311' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050312' => _x( 'Pantanassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050313' => _x( 'Faraklo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050401' => _x( 'Richea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050402' => _x( 'Ierax', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050403' => _x( 'Kyparissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050404' => _x( 'Labokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050405' => _x( 'Charakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050501' => _x( 'Monemvassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050502' => _x( 'Aghelona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050503' => _x( 'Aghios Dimitrios Monemvassias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050504' => _x( 'Aghios Ioannis Epidavrou Limiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050505' => _x( 'Aghios Nikolaos Monemvassias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050506' => _x( 'Velies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050507' => _x( 'Koulenti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050508' => _x( 'Lira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050509' => _x( 'Nomia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR43050510' => _x( 'Talanta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010101' => _x( 'Kalamata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010102' => _x( 'Alagonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010103' => _x( 'Antikalamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010104' => _x( 'Artemissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010105' => _x( 'Asprochoma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010106' => _x( 'Verga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010107' => _x( 'Eleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010108' => _x( 'Karveli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010109' => _x( 'Ladas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010110' => _x( 'Leika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010111' => _x( 'Mikri Mantinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010112' => _x( 'Nedoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010113' => _x( 'Piges', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010114' => _x( 'Sperchogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010201' => _x( 'Aris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010202' => _x( 'Alonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010203' => _x( 'Ammos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010204' => _x( 'Anemomylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010205' => _x( 'Ariochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010206' => _x( 'Aspropoulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010301' => _x( 'Arfara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010302' => _x( 'Aghios Floros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010303' => _x( 'Agrilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010304' => _x( 'Velanidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010305' => _x( 'Vromovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010306' => _x( 'Pidima', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010307' => _x( 'Platy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010308' => _x( 'Stamatino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010401' => _x( 'Thouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010402' => _x( 'Aethea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010403' => _x( 'Amfia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010404' => _x( 'Anthia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010405' => _x( 'Mikromani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44010406' => _x( 'Poliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020101' => _x( 'Kardamyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020102' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020103' => _x( 'Aghios Nikon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020104' => _x( 'Exochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020105' => _x( 'Thalames', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020106' => _x( 'Karyovounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020107' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020108' => _x( 'Lagada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020109' => _x( 'Milia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020110' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020111' => _x( 'Nomitsis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020112' => _x( 'Platsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020113' => _x( 'Proastio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020114' => _x( 'Prossilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020115' => _x( 'Pyrgos Kalamon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020116' => _x( 'Riglia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020117' => _x( 'Saidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020118' => _x( 'Trachila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020119' => _x( 'Tseria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020201' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020202' => _x( 'Avia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020203' => _x( 'Altomira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020204' => _x( 'Doli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020205' => _x( 'Kentro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020206' => _x( 'Pigadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020207' => _x( 'Stavropigio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44020208' => _x( 'Sotirianika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030101' => _x( 'Messini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030102' => _x( 'Avramio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030103' => _x( 'Analipsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030104' => _x( 'Velika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030105' => _x( 'Karterolio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030106' => _x( 'Lefkochora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030107' => _x( 'Lykotrafos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030108' => _x( 'Madena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030109' => _x( 'Mavrommati Pamissou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030110' => _x( 'Neochori Aristomenous', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030111' => _x( 'Pilalistra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030112' => _x( 'Piperitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030113' => _x( 'Spitalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030114' => _x( 'Triodos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030201' => _x( 'Loga', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030202' => _x( 'Adriani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030203' => _x( 'Militsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030204' => _x( 'Nea Koroni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030205' => _x( 'Chrani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030301' => _x( 'Androussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030302' => _x( 'Agrilia Messinis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030303' => _x( 'Amfithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030304' => _x( 'Ellinoeklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030305' => _x( 'Eva', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030306' => _x( 'Kalamaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030307' => _x( 'Kalogerorachi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030308' => _x( 'Maganiako', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030309' => _x( 'Polylofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030401' => _x( 'Aristomenis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030402' => _x( 'Voutena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030403' => _x( 'Diodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030404' => _x( 'Kefalovrysso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030405' => _x( 'Koutifaris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030406' => _x( 'Manessis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030407' => _x( 'Pelekanada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030408' => _x( 'Platanovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030409' => _x( 'Poulitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030410' => _x( 'Sterna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030411' => _x( 'Strefi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030501' => _x( 'Chatzis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030502' => _x( 'Vlassis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030503' => _x( 'Kourtakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030504' => _x( 'Miliotio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030505' => _x( 'Petritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030506' => _x( 'Charavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030601' => _x( 'Valyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030602' => _x( 'Aristodimio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030603' => _x( 'Arsinoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030604' => _x( 'Archea Messini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030605' => _x( 'Zerbissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030606' => _x( 'Kefalinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030607' => _x( 'Labena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030608' => _x( 'Revmatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030701' => _x( 'Petalidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030702' => _x( 'Achladochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030703' => _x( 'Daras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030704' => _x( 'Drossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030705' => _x( 'Kalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030706' => _x( 'Karpofora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030707' => _x( 'Kastanies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030708' => _x( 'Kokkino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030709' => _x( 'Lykissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030710' => _x( 'Mathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030711' => _x( 'Neromylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030712' => _x( 'Paniperi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030801' => _x( 'Trikorfo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030802' => _x( 'Draina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030803' => _x( 'Klima', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030804' => _x( 'Koromilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44030805' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040101' => _x( 'Meligalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040102' => _x( 'Anthoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040103' => _x( 'Zevgolatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040104' => _x( 'Kallirroi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040105' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040106' => _x( 'Mila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040107' => _x( 'Neochori Ithomis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040108' => _x( 'Polichni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040109' => _x( 'Skala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040110' => _x( 'Stenyklaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040111' => _x( 'Tsoukaleika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040201' => _x( 'Diavolitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040202' => _x( 'Agrilovouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040203' => _x( 'Ano Melpia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040204' => _x( 'Dassochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040205' => _x( 'Dessylas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040206' => _x( 'Ilektra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040207' => _x( 'Karnassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040208' => _x( 'Kato Melpia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040209' => _x( 'Kentriko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040210' => _x( 'Konstantini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040211' => _x( 'Malta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040212' => _x( 'Mandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040213' => _x( 'Mantzario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040214' => _x( 'Parapougi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040301' => _x( 'Dorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040302' => _x( 'Ano Dorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040303' => _x( 'Vassiliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040304' => _x( 'Koklas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040305' => _x( 'Kouvelas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040306' => _x( 'Malthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040307' => _x( 'Chalkias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040308' => _x( 'Chryssochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040309' => _x( 'Psari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040401' => _x( 'Neda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040402' => _x( 'Aghios Sostis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040403' => _x( 'Abeliona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040404' => _x( 'Kakaletri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040405' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040406' => _x( 'Sklirou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040407' => _x( 'Stassimo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040408' => _x( 'Syrrizo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040501' => _x( 'Meropi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040502' => _x( 'Andania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040503' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040504' => _x( 'Katsarou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040505' => _x( 'Loutro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040506' => _x( 'Ichalia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040507' => _x( 'Pefko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040508' => _x( 'Siamou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040509' => _x( 'Solaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44040510' => _x( 'Filia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050101' => _x( 'Pylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050102' => _x( 'Abelokipi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050103' => _x( 'Glyfada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050104' => _x( 'Iklena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050105' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050106' => _x( 'Kynigos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050107' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050108' => _x( 'Pappoulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050109' => _x( 'Pidassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050110' => _x( 'Pyla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050111' => _x( 'Chomatada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050201' => _x( 'Koroni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050202' => _x( 'Akritochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050203' => _x( 'Vassilitsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050204' => _x( 'Vounaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050205' => _x( 'Kaplani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050206' => _x( 'Kobi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050207' => _x( 'Yamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050208' => _x( 'Falanthi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050209' => _x( 'Charakopio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050210' => _x( 'Chryssokellaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050301' => _x( 'Methoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050302' => _x( 'Evaghelismos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050303' => _x( 'Kenourgio Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050304' => _x( 'Lachanada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050305' => _x( 'Finiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050306' => _x( 'Finikounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050401' => _x( 'Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050402' => _x( 'Abelofyto', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050403' => _x( 'Koryfassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050404' => _x( 'Metaxada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050405' => _x( 'Myrsinochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050406' => _x( 'Paleo Loutro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050407' => _x( 'Romanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050408' => _x( 'Flessiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050501' => _x( 'Vlachopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050502' => _x( 'Maniaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050503' => _x( 'Margelio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050504' => _x( 'Metamorfossi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050505' => _x( 'Papaflessas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050601' => _x( 'Chandrinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050602' => _x( 'Koukkounara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050603' => _x( 'Kremmydia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050604' => _x( 'Messopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44050605' => _x( 'Soulinari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060101' => _x( 'Kyparissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060102' => _x( 'Armenii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060103' => _x( 'Vrysses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060104' => _x( 'Mouriatada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060105' => _x( 'Myro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060106' => _x( 'Xirokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060107' => _x( 'Perdikoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060108' => _x( 'Raches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060109' => _x( 'Spilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060110' => _x( 'Stassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060111' => _x( 'Faraklada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060201' => _x( 'Kopanaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060202' => _x( 'Agrilia Trifylias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060203' => _x( 'Aetos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060204' => _x( 'Artikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060205' => _x( 'Glykorizio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060206' => _x( 'Kamari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060207' => _x( 'Kefalovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060208' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060209' => _x( 'Monastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060210' => _x( 'Polythea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060211' => _x( 'Sitochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060301' => _x( 'Sidirokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060302' => _x( 'Agaliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060303' => _x( 'Avlonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060304' => _x( 'Vanada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060305' => _x( 'Elea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060306' => _x( 'Kalitsena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060307' => _x( 'Kalo Nero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060308' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060309' => _x( 'Platania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060310' => _x( 'Prodromos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060401' => _x( 'Gargaliani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060402' => _x( 'Valta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060403' => _x( 'Lefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060404' => _x( 'Marathopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060405' => _x( 'Mouzaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060406' => _x( 'Pyrgos Trifylias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060407' => _x( 'Floka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060501' => _x( 'Raptopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060502' => _x( 'Kalogeressio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060503' => _x( 'Lantzounato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060504' => _x( 'Lypoudessio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060505' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060506' => _x( 'Sellas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060507' => _x( 'Tripyla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060601' => _x( 'Filiatra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060602' => _x( 'Exochiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060603' => _x( 'Mali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060604' => _x( 'Plati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060605' => _x( 'Chalazonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR44060606' => _x( 'Christianoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'I' => [
		'GR45010000' => _x( 'Athens (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45020000' => _x( 'Vyron (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45030000' => _x( 'Galatsi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45040101' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45040201' => _x( 'Ymittos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45050000' => _x( 'Zografos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45060000' => _x( 'Ilioupoli (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45070000' => _x( 'Kessariani (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45080101' => _x( 'Nea Philadelfia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR45080201' => _x( 'Nea Chalkidona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46010000' => _x( 'Amaroussio (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46020000' => _x( 'Aghia Paraskevi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46030000' => _x( 'Vrilissia (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46040000' => _x( 'Iraklio (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46050101' => _x( 'Kifissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46050201' => _x( 'Ekali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46050301' => _x( 'Nea Erythrea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46060101' => _x( 'Pefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46060201' => _x( 'Lykovryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46070000' => _x( 'Metamorfossi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46080000' => _x( 'Nea Ionia (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46090101' => _x( 'Cholargos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46090201' => _x( 'Papagos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46100101' => _x( 'Melissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46100201' => _x( 'Nea Penteli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46100301' => _x( 'Penteli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46110101' => _x( 'Psychiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46110201' => _x( 'Neo Psychiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46110301' => _x( 'Filothei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR46120000' => _x( 'Chalandri (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47010000' => _x( 'Peristeri (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47020000' => _x( 'Aghia Varvara (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47030101' => _x( 'Aghii Anargyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47030201' => _x( 'Kamatero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47040000' => _x( 'Aegaleo (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47050000' => _x( 'Ilio (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47060000' => _x( 'Petroupoli (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR47070000' => _x( 'Chaidari (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48010000' => _x( 'Kallithea (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48020000' => _x( 'Aghios Dimitrios (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48030000' => _x( 'Alimos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48040000' => _x( 'Glyfada (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48050101' => _x( 'Argyroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48050201' => _x( 'Elliniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48060101' => _x( 'Moschato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48060201' => _x( 'Tavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48070000' => _x( 'Nea Smyrni (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR48080000' => _x( 'Paleo Faliro (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49010101' => _x( 'Acharnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49010201' => _x( 'Thrakomakedones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49020101' => _x( 'Voula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49020201' => _x( 'Vari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49020301' => _x( 'Vouliagmeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030101' => _x( 'Aghios Stefanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030201' => _x( 'Anixi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030301' => _x( 'Dionyssos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030401' => _x( 'Drossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030501' => _x( 'Kryonerio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030601' => _x( 'Rodopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49030701' => _x( 'Stamata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49040000' => _x( 'Koropi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49050101' => _x( 'Lavrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49050201' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49050301' => _x( 'Keratea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49060101' => _x( 'Marathon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49060201' => _x( 'Varnavas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49060301' => _x( 'Grammatiko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49060401' => _x( 'Nea Makri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49070000' => _x( 'Markopoulo Messogheas (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49080101' => _x( 'Peania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49080201' => _x( 'Glyka Nera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49090101' => _x( 'Gerakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49090201' => _x( 'Anthoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49090301' => _x( 'Pallini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49100101' => _x( 'Rafina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49100201' => _x( 'Pikermi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49110101' => _x( 'Kalyvia Thorikou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49110201' => _x( 'Anavyssos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49110301' => _x( 'Kouvaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49110401' => _x( 'Palea Phokea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49110501' => _x( 'Saronida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49120101' => _x( 'Spata - Loutsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49120201' => _x( 'Artemida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130101' => _x( 'Skala Oropou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130102' => _x( 'Nea Palatia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130103' => _x( 'Oropos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130104' => _x( 'Chalkoutsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130201' => _x( 'Avlona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130301' => _x( 'Afidnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130401' => _x( 'Kalamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130501' => _x( 'Kapandriti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130601' => _x( 'Malakassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130701' => _x( 'Markopoulo Oropou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130801' => _x( 'Polydendri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR49130901' => _x( 'Sykamino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50010101' => _x( 'Elefsina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50010201' => _x( 'Magoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50020000' => _x( 'Aspropyrgos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50030101' => _x( 'Mandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50030201' => _x( 'Vilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50030301' => _x( 'Erythres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50030401' => _x( 'Inoi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50040101' => _x( 'Megara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50040102' => _x( 'Kineta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50040201' => _x( 'Nea Peramos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50050101' => _x( 'Ano Liossia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50050201' => _x( 'Zephyri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR50050301' => _x( 'Fyli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51010000' => _x( 'Pireas (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51020101' => _x( 'Keratsini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51020201' => _x( 'Drapetsona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51030000' => _x( 'Korydallos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51040101' => _x( 'Nikea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51040201' => _x( 'Aghios Ioannis Rentis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR51050000' => _x( 'Perama (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52010101' => _x( 'Salamina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52010102' => _x( 'Eantio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52010201' => _x( 'Abelakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52010202' => _x( 'Selinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52020000' => _x( 'Ydra (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52030000' => _x( 'Agistri (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52040001' => _x( 'Aegina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52040002' => _x( 'Vathy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52040003' => _x( 'Kypseli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52040004' => _x( 'Messagros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52040005' => _x( 'Perdika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050101' => _x( 'Kythira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050102' => _x( 'Aroniadika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050103' => _x( 'Karavas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050104' => _x( 'Karvounades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050105' => _x( 'Kontolianika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050106' => _x( 'Livadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050107' => _x( 'Logothetianika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050108' => _x( 'Mitata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050109' => _x( 'Mylopotamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050110' => _x( 'Myrtidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050111' => _x( 'Potamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050112' => _x( 'Fratsia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050113' => _x( 'Friligianika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52050201' => _x( 'Antikythira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52060000' => _x( 'Poros (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52070000' => _x( 'Spetses (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080101' => _x( 'Galatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080102' => _x( 'Ano Fanari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080103' => _x( 'Dryopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080104' => _x( 'Karatzas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080105' => _x( 'Taktikoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080106' => _x( 'Trizina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080201' => _x( 'Loutropoli Methanon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080202' => _x( 'Kounoupitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080203' => _x( 'Kypseli Methanon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR52080204' => _x( 'Megalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'K' => [
		'GR53010101' => _x( 'Mytilini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010102' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010103' => _x( 'Alyfanta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010104' => _x( 'Afalonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010105' => _x( 'Loutra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010106' => _x( 'Moria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010107' => _x( 'Pamfila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010108' => _x( 'Panayouda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010109' => _x( 'Taxiarches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010201' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010202' => _x( 'Napi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010301' => _x( 'Ayassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010401' => _x( 'Pappados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010402' => _x( 'Messagros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010403' => _x( 'Paleokipos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010404' => _x( 'Perama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010405' => _x( 'Plakados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010406' => _x( 'Skopelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010501' => _x( 'Eressos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010502' => _x( 'Antissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010503' => _x( 'Vatoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010504' => _x( 'Messotopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010505' => _x( 'Pterounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010506' => _x( 'Sigri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010507' => _x( 'Chidira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010601' => _x( 'Sykounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010602' => _x( 'Assomatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010603' => _x( 'Ippio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010604' => _x( 'Kato Tritos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010605' => _x( 'Keramia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010606' => _x( 'Labou Myli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010607' => _x( 'Mychos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010701' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010702' => _x( 'Agra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010703' => _x( 'Anemotia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010704' => _x( 'Arisvi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010705' => _x( 'Dafia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010706' => _x( 'Keramio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010707' => _x( 'Parakila', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010708' => _x( 'Skalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010709' => _x( 'Filia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010801' => _x( 'Loutropoli Thermis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010802' => _x( 'Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010803' => _x( 'Mistegna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010804' => _x( 'Nees Kydonies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010805' => _x( 'Pigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010806' => _x( 'Pyrgi Thermis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010901' => _x( 'Mantamados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010902' => _x( 'Kapi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010903' => _x( 'Klio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53010904' => _x( 'Pelopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011001' => _x( 'Mithymna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011002' => _x( 'Argennos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011003' => _x( 'Lepetymnos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011004' => _x( 'Sykaminea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011101' => _x( 'Petra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011102' => _x( 'Lafionas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011103' => _x( 'Skoutaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011104' => _x( 'Stypsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011105' => _x( 'Ypsilometopo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011201' => _x( 'Plomari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011202' => _x( 'Akrassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011203' => _x( 'Abeliko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011204' => _x( 'Megalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011205' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011206' => _x( 'Paleochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011207' => _x( 'Plagia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011208' => _x( 'Trygonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011301' => _x( 'Polichnitos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011302' => _x( 'Vassilika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011303' => _x( 'Vrissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011304' => _x( 'Lisvorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR53011305' => _x( 'Stavros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010101' => _x( 'Aghios Kirykos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010102' => _x( 'Perdiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010103' => _x( 'Chryssostomos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010201' => _x( 'Evdilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010202' => _x( 'Arethoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010203' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010204' => _x( 'Karavostamo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010205' => _x( 'Maganitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010206' => _x( 'Frantato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010301' => _x( 'Raches', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010302' => _x( 'Aghios Polykarpos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54010303' => _x( 'Karkinagrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR54020000' => _x( 'Fourni Korseon (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010101' => _x( 'Myrina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010102' => _x( 'Thanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010103' => _x( 'Kaspakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010104' => _x( 'Kornos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010105' => _x( 'Platy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010201' => _x( 'Atsiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010202' => _x( 'Aghios Dimitrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010203' => _x( 'Varos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010204' => _x( 'Dafni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010205' => _x( 'Karpassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010206' => _x( 'Katalakko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010207' => _x( 'Sardes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010301' => _x( 'Moudros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010302' => _x( 'Kalliopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010303' => _x( 'Kaminia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010304' => _x( 'Kontopoulio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010305' => _x( 'Lychna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010306' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010307' => _x( 'Plaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010308' => _x( 'Repanidi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010309' => _x( 'Roussopoulio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010310' => _x( 'Romano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010311' => _x( 'Skandalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010312' => _x( 'Fissini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010401' => _x( 'Kontias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010402' => _x( 'Agaryones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010403' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010404' => _x( 'Livadochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010405' => _x( 'Nea Koutali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010406' => _x( 'Pedino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010407' => _x( 'Portiano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55010408' => _x( 'Tsimandria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR55020000' => _x( 'Aghios Efstratios (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010101' => _x( 'Samos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010102' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010103' => _x( 'Abelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010104' => _x( 'Vathy', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010105' => _x( 'Vourliotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010106' => _x( 'Kokkari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010107' => _x( 'Manolates', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010108' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010109' => _x( 'Stavrinides', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010201' => _x( 'Karlovassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010202' => _x( 'Aghii Theodori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010203' => _x( 'Drakei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010204' => _x( 'Kastania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010205' => _x( 'Konteika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010206' => _x( 'Kontakeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010207' => _x( 'Kosmadei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010208' => _x( 'Leka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010209' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010210' => _x( 'Ydroussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010301' => _x( 'Marathokabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010302' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010303' => _x( 'Koumeika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010304' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010305' => _x( 'Skoureika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010401' => _x( 'Pythagorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010402' => _x( 'Koumaradei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010403' => _x( 'Mavratzei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010404' => _x( 'Messogio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010405' => _x( 'Myli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010406' => _x( 'Mytilinii', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010407' => _x( 'Pagondas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010408' => _x( 'Pandrosso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010409' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010410' => _x( 'Spatharei', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR56010411' => _x( 'Chora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010101' => _x( 'Chios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010201' => _x( 'Thymiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010202' => _x( 'Neochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010301' => _x( 'Volissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010302' => _x( 'Aghio Gala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010303' => _x( 'Diefcha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010304' => _x( 'Keramos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010305' => _x( 'Kourounia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010306' => _x( 'Leptopoda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010307' => _x( 'Melanios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010308' => _x( 'Nea Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010309' => _x( 'Nenitouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010310' => _x( 'Parparia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010311' => _x( 'Pirama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010312' => _x( 'Pispilounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010313' => _x( 'Trypes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010314' => _x( 'Fyta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010315' => _x( 'Chalandra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010401' => _x( 'Kallimassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010402' => _x( 'Vouno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010403' => _x( 'Exo Didyma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010404' => _x( 'Tholopotamio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010405' => _x( 'Katarraktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010406' => _x( 'Kini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010407' => _x( 'Messa Didyma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010408' => _x( 'Myrmigio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010409' => _x( 'Nenita', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010410' => _x( 'Pagida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010411' => _x( 'Flatsia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010501' => _x( 'Chalkio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010502' => _x( 'Aghios Gheorgios Sykoussis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010503' => _x( 'Vavili', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010504' => _x( 'Vassileoniko', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010505' => _x( 'Ververato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010506' => _x( 'Dafnon', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010507' => _x( 'Zyfias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010601' => _x( 'Kardamyla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010602' => _x( 'Amades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010603' => _x( 'Vikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010604' => _x( 'Kabia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010605' => _x( 'Pityous', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010606' => _x( 'Spartounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010701' => _x( 'Pyrgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010702' => _x( 'Armolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010703' => _x( 'Vessa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010704' => _x( 'Elata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010705' => _x( 'Kalamoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010706' => _x( 'Lithio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010707' => _x( 'Mesta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010708' => _x( 'Olympi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010709' => _x( 'Patrika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010801' => _x( 'Vrontados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010802' => _x( 'Anavatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010803' => _x( 'Avgonyma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010804' => _x( 'Karyes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010805' => _x( 'Lagada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010806' => _x( 'Sidirounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57010807' => _x( 'Sykiada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57020000' => _x( 'Inousses (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR57030000' => _x( 'Psara (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'L' => [
		'GR58010101' => _x( 'Ermoupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010102' => _x( 'Manna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010201' => _x( 'Ano Syros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010202' => _x( 'Galissas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010203' => _x( 'Pagos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010204' => _x( 'Chroussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010301' => _x( 'Possidonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010302' => _x( 'Vari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR58010303' => _x( 'Finikas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010101' => _x( 'Andros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010102' => _x( 'Apikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010103' => _x( 'Vourkoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010104' => _x( 'Lamyra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010105' => _x( 'Messaria Androu', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010106' => _x( 'Pitrofos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010107' => _x( 'Stenies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010201' => _x( 'Ormos Korthiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010202' => _x( 'Kapparia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010203' => _x( 'Korthio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010204' => _x( 'Kochylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010205' => _x( 'Paleokastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010206' => _x( 'Synetio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010301' => _x( 'Gavrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010302' => _x( 'Ammolochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010303' => _x( 'Ano Gavrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010304' => _x( 'Aprovato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010305' => _x( 'Arnas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010306' => _x( 'Vitalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010307' => _x( 'Katakilos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010308' => _x( 'Makrotantalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010309' => _x( 'Batsi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010310' => _x( 'Paleopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR59010311' => _x( 'Fellos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010101' => _x( 'Thira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010102' => _x( 'Akrotiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010103' => _x( 'Vothonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010104' => _x( 'Vourvoulos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010105' => _x( 'Emporio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010106' => _x( 'Exo Gonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010107' => _x( 'Episkopi Gonias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010108' => _x( 'Imerovigli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010109' => _x( 'Karterados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010110' => _x( 'Megalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010111' => _x( 'Messaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010112' => _x( 'Pyrgos Kallistis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010201' => _x( 'Ia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60010202' => _x( 'Thirassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60020000' => _x( 'Anafi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60030000' => _x( 'Ios (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60040000' => _x( 'Sikinos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60050001' => _x( 'Folegandros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR60050002' => _x( 'Ano Meria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61010000' => _x( 'Kalymnos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61020000' => _x( 'Agathonissi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61030000' => _x( 'Astypalea (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61040000' => _x( 'Lipsi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61050000' => _x( 'Leros (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR61060000' => _x( 'Patmos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010101' => _x( 'Karpathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010102' => _x( 'Aperio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010103' => _x( 'Arkassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010104' => _x( 'Volada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010105' => _x( 'Menetes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010106' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010107' => _x( 'Othos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010108' => _x( 'Pyles', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010109' => _x( 'Spoa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62010201' => _x( 'Olympos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR62020000' => _x( 'Kassos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR63010001' => _x( 'Ioulis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR63010002' => _x( 'Korissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR63020001' => _x( 'Kythnos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR63020002' => _x( 'Dryopida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010101' => _x( 'Kos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010201' => _x( 'Asfendiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010202' => _x( 'Pylio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010301' => _x( 'Antimachia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010302' => _x( 'Kardamena', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64010303' => _x( 'Kefalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64020001' => _x( 'Mandraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64020002' => _x( 'Emporios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR64020003' => _x( 'Nikia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65010001' => _x( 'Milos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65010002' => _x( 'Adamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65010003' => _x( 'Peran Triovassalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65010004' => _x( 'Triovassalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65010005' => _x( 'Trypiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65020000' => _x( 'Kimolos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65030000' => _x( 'Serifos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65040001' => _x( 'Apollonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR65040002' => _x( 'Artemonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR66010001' => _x( 'Mykonos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR66010002' => _x( 'Ano Mera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010001' => _x( 'Amorgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010002' => _x( 'Aeghiali', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010003' => _x( 'Arkessini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010004' => _x( 'Vroutsis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010005' => _x( 'Tholaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67010006' => _x( 'Katapola (Amorgos)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020101' => _x( 'Naxos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020102' => _x( 'Aghios Arsenios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020103' => _x( 'Vivlos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020104' => _x( 'Galanado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020105' => _x( 'Galini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020106' => _x( 'Glinado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020107' => _x( 'Egares', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020108' => _x( 'Kinidaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020109' => _x( 'Melanes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020110' => _x( 'Potamia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020111' => _x( 'Sagrio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020201' => _x( 'Donoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020301' => _x( 'Chalkio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020302' => _x( 'Aperathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020303' => _x( 'Damarionas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020304' => _x( 'Danakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020305' => _x( 'Keramoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020306' => _x( 'Koronida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020307' => _x( 'Koronos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020308' => _x( 'Messi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020309' => _x( 'Moni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020310' => _x( 'Skado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020311' => _x( 'Filotio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020401' => _x( 'Iraklia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020501' => _x( 'Koufonissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR67020601' => _x( 'Schinoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010001' => _x( 'Paros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010002' => _x( 'Agheria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010003' => _x( 'Archilochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010004' => _x( 'Kostos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010005' => _x( 'Lefkes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010006' => _x( 'Marpissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68010007' => _x( 'Naoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR68020000' => _x( 'Antiparos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010101' => _x( 'Rodos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010201' => _x( 'Archaghelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010202' => _x( 'Malonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010203' => _x( 'Massari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010301' => _x( 'Ebonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010302' => _x( 'Aghios Issidoros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010303' => _x( 'Kritinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010304' => _x( 'Monolithos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010305' => _x( 'Siana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010401' => _x( 'Afantou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010402' => _x( 'Archipoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010501' => _x( 'Ialyssos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010601' => _x( 'Kalythies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010602' => _x( 'Koskinou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010603' => _x( 'Psinthos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010701' => _x( 'Soroni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010702' => _x( 'Apollona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010703' => _x( 'Dimylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010704' => _x( 'Kalavarda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010705' => _x( 'Platania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010706' => _x( 'Salakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010707' => _x( 'Fanes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010801' => _x( 'Lindos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010802' => _x( 'Kalathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010803' => _x( 'Laerma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010804' => _x( 'Lardos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010805' => _x( 'Pylonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010901' => _x( 'Gennadio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010902' => _x( 'Apolakkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010903' => _x( 'Arnitha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010904' => _x( 'Asklipiio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010905' => _x( 'Vatio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010906' => _x( 'Istrios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010907' => _x( 'Kattavia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010908' => _x( 'Lachania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010909' => _x( 'Messanagros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69010910' => _x( 'Profilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011001' => _x( 'Kremasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011002' => _x( 'Damatria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011003' => _x( 'Theologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011004' => _x( 'Maritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011005' => _x( 'Paradissi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69011006' => _x( 'Pastida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69020000' => _x( 'Megisti (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69030000' => _x( 'Symi (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69040001' => _x( 'Megalo Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69040002' => _x( 'Livadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR69050000' => _x( 'Chalki (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'M' => [
		'GR70010101' => _x( 'Tinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010102' => _x( 'Dyo Choria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010103' => _x( 'Triantaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010201' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010202' => _x( 'Agapi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010203' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010204' => _x( 'Kardiani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010205' => _x( 'Ktikados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010206' => _x( 'Komi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010207' => _x( 'Steni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010208' => _x( 'Ysternia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010209' => _x( 'Falatados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR70010301' => _x( 'Panormos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010100' => _x( 'Iraklio (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010102' => _x( 'Vassilies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010103' => _x( 'Voutes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010104' => _x( 'Dafnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010105' => _x( 'Skalanio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010106' => _x( 'Stavrakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010201' => _x( 'Aghios Myronas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010202' => _x( 'Ano Assites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010203' => _x( 'Kato Assites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010204' => _x( 'Pentamodio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010205' => _x( 'Petrokefalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010206' => _x( 'Pyrgou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010301' => _x( 'Nea Alikarnassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010302' => _x( 'Kallithea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010401' => _x( 'Venerato', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010402' => _x( 'Avgeniki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010403' => _x( 'Kerassia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010404' => _x( 'Siva', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010501' => _x( 'Profitis Ilias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010502' => _x( 'Aghios Syllas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71010503' => _x( 'Kyparissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020101' => _x( 'Peza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020102' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020103' => _x( 'Aghies Paraskies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020104' => _x( 'Alagnio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020105' => _x( 'Astraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020106' => _x( 'Astritsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020107' => _x( 'Damania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020108' => _x( 'Kalloni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020109' => _x( 'Katalagari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020110' => _x( 'Kounavi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020111' => _x( 'Melesses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020112' => _x( 'Metaxochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020113' => _x( 'Myrtia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020114' => _x( 'Choudetsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020201' => _x( 'Archanes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020202' => _x( 'Kato Archanes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020301' => _x( 'Pyrgos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020302' => _x( 'Achentrias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020303' => _x( 'Ethia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020304' => _x( 'Kalyvia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020305' => _x( 'Ligortynos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020306' => _x( 'Messochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020307' => _x( 'Paranymfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020308' => _x( 'Pretoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020309' => _x( 'Tefelio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020310' => _x( 'Charakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71020311' => _x( 'Charakas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030001' => _x( 'Ano Viannos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030002' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030003' => _x( 'Amiras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030004' => _x( 'Afratio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030005' => _x( 'Vachos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030006' => _x( 'Ebaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030007' => _x( 'Kalamio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030008' => _x( 'Kato Viannos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030009' => _x( 'Kato Symi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030010' => _x( 'Kefalovryssio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030011' => _x( 'Martha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030012' => _x( 'Milliarades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030013' => _x( 'Xeniakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030014' => _x( 'Pefkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030015' => _x( 'Sykologos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71030016' => _x( 'Chondros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040101' => _x( 'Aghii Deka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040102' => _x( 'Aghios Kyrillos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040103' => _x( 'Abelouzos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040104' => _x( 'Apessokari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040105' => _x( 'Vayonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040106' => _x( 'Vassiliki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040107' => _x( 'Vassilika Anogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040108' => _x( 'Gagales', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040109' => _x( 'Mitropoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040110' => _x( 'Miamou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040111' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040112' => _x( 'Plora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040113' => _x( 'Choustouliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040201' => _x( 'Aghia Varvara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040202' => _x( 'Aghios Thomas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040203' => _x( 'Ano Moulia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040204' => _x( 'Doulio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040205' => _x( 'Laranio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040206' => _x( 'Megali Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040207' => _x( 'Prinias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040301' => _x( 'Assimio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040302' => _x( 'Ano Akria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040303' => _x( 'Dionyssio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040304' => _x( 'Loures', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040305' => _x( 'Sokaras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040306' => _x( 'Stavies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040307' => _x( 'Sternes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040308' => _x( 'Stoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040401' => _x( 'Gergeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040402' => _x( 'Nyvritos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71040403' => _x( 'Panassos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050101' => _x( 'Gazi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050102' => _x( 'Achlada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050103' => _x( 'Kalessia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050104' => _x( 'Rodia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050105' => _x( 'Fodele', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050201' => _x( 'Kroussonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050202' => _x( 'Korfes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050203' => _x( 'Loutraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050204' => _x( 'Sarchos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050301' => _x( 'Tylissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050302' => _x( 'Aidonochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050303' => _x( 'Astyrakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050304' => _x( 'Gonies Maleviziou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050305' => _x( 'Damasta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050306' => _x( 'Kamari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050307' => _x( 'Kamariotis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050308' => _x( 'Keramoutsio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050309' => _x( 'Marathos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71050310' => _x( 'Moni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060101' => _x( 'Kastelli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060102' => _x( 'Amariano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060103' => _x( 'Apostoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060104' => _x( 'Archaghelos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060105' => _x( 'Aski', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060106' => _x( 'Gerakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060107' => _x( 'Evaghelismos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060108' => _x( 'Karouzana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060109' => _x( 'Kastamonitsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060110' => _x( 'Liliano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060111' => _x( 'Lyttos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060112' => _x( 'Mathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060113' => _x( 'Polythea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060114' => _x( 'Smario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060201' => _x( 'Arkalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060202' => _x( 'Garipa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060203' => _x( 'Dematio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060204' => _x( 'Inio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060205' => _x( 'Karavados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060206' => _x( 'Kassanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060207' => _x( 'Kastelliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060208' => _x( 'Lefkochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060209' => _x( 'Nipiditos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060210' => _x( 'Panaghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060211' => _x( 'Panorama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060212' => _x( 'Partira', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060213' => _x( 'Patsideros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060214' => _x( 'Skinias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060301' => _x( 'Thrapsano', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060302' => _x( 'Voni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060303' => _x( 'Zofori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71060304' => _x( 'Sabas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070101' => _x( 'Mires', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070102' => _x( 'Alithini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070103' => _x( 'Antiskario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070104' => _x( 'Galia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070105' => _x( 'Kastellio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070106' => _x( 'Kousses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070107' => _x( 'Perio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070108' => _x( 'Petrokefalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070109' => _x( 'Pigaidakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070110' => _x( 'Pobia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070111' => _x( 'Roufas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070112' => _x( 'Skourvoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070201' => _x( 'Zaros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070202' => _x( 'Vorizia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070203' => _x( 'Moronio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070301' => _x( 'Tybakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070302' => _x( 'Vori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070303' => _x( 'Grigoria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070304' => _x( 'Kamares', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070305' => _x( 'Kamilario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070306' => _x( 'Klima', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070307' => _x( 'Lagolio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070308' => _x( 'Magarikario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070309' => _x( 'Pitsidia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070310' => _x( 'Sivas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71070311' => _x( 'Faneromeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080101' => _x( 'Anopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080102' => _x( 'Gouves', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080103' => _x( 'Elea', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080104' => _x( 'Epano Vathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080105' => _x( 'Kalo Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080106' => _x( 'Kato Vathia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080107' => _x( 'Koxari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080108' => _x( 'Charasso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080201' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080202' => _x( 'Aitania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080203' => _x( 'Galifa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080204' => _x( 'Kenourgio Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080205' => _x( 'Sgourokefalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080301' => _x( 'Malia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080302' => _x( 'Krassio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080303' => _x( 'Mochos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080401' => _x( 'Limenas Chersonissou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080402' => _x( 'Avdou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080403' => _x( 'Gonies Pediados', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080404' => _x( 'Kera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080405' => _x( 'Potamies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR71080406' => _x( 'Chersonissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010101' => _x( 'Aghios Nikolaos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010102' => _x( 'Vrouchas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010103' => _x( 'Elounta', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010104' => _x( 'Exo Lakkonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010105' => _x( 'Exo Potami', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010106' => _x( 'Zenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010107' => _x( 'Kalo Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010108' => _x( 'Kritsa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010109' => _x( 'Kroustas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010110' => _x( 'Limnes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010111' => _x( 'Loumas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010112' => _x( 'Messa Lakkonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010113' => _x( 'Prina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010114' => _x( 'Skinias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010201' => _x( 'Vrachassi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010301' => _x( 'Neapoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010302' => _x( 'Aghios Antonios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010303' => _x( 'Voulismeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010304' => _x( 'Vrysses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010305' => _x( 'Karydi Mirabellou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010306' => _x( 'Kastelli Fournis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010307' => _x( 'Latsida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010308' => _x( 'Nikithianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010309' => _x( 'Fourni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72010310' => _x( 'Choumeriakos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020101' => _x( 'Ierapetra', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020102' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020103' => _x( 'Anatoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020104' => _x( 'Gdochia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020105' => _x( 'Kavoussio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020106' => _x( 'Kalamafka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020107' => _x( 'Kato Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020108' => _x( 'Makrylia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020109' => _x( 'Males', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020110' => _x( 'Messeleri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020111' => _x( 'Metaxochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020112' => _x( 'Mournies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020113' => _x( 'Mythi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020114' => _x( 'Myrtos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020115' => _x( 'Pachia Ammos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020116' => _x( 'Riza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020117' => _x( 'Christos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020201' => _x( 'Stavrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020202' => _x( 'Aghios Stefanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020204' => _x( 'Orino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72020207' => _x( 'Schinokapsala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030001' => _x( 'Tzermiado', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030002' => _x( 'Avrakontes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030003' => _x( 'Aghios Georgios Lassithiou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030004' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030005' => _x( 'Kaminakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030006' => _x( 'Kato Metochi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030007' => _x( 'Lagou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030008' => _x( 'Marmaketo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030009' => _x( 'Messa Lasithi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030010' => _x( 'Plati', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72030011' => _x( 'Psychro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040101' => _x( 'Sitia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040102' => _x( 'Aghios Georgios Sitias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040103' => _x( 'Achladia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040104' => _x( 'Exo Mouliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040105' => _x( 'Katsidonio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040106' => _x( 'Krya', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040107' => _x( 'Lastros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040108' => _x( 'Maronia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040109' => _x( 'Messa Mouliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040110' => _x( 'Myrsini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040111' => _x( 'Piskokefalo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040112' => _x( 'Pressos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040113' => _x( 'Roussa Eklissia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040114' => _x( 'Skopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040115' => _x( 'Stavromenos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040116' => _x( 'Sfaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040117' => _x( 'Tourloti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040118' => _x( 'Chamezio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040201' => _x( 'Palekastro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040202' => _x( 'Zakros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040203' => _x( 'Karydi Sitias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040301' => _x( 'Ziros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040302' => _x( 'Aghia Triada', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040303' => _x( 'Apidia (Messa Apidio)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040304' => _x( 'Armeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040305' => _x( 'Pappayannades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040306' => _x( 'Chandras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040401' => _x( 'Lithines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040402' => _x( 'Perivolakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040403' => _x( 'Pefki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR72040404' => _x( 'Chryssopigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010101' => _x( 'Rethymno', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010102' => _x( 'Armeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010103' => _x( 'Goulediana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010104' => _x( 'Kares', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010105' => _x( 'Kastellos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010106' => _x( 'Koumi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010107' => _x( 'Maroulas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010108' => _x( 'Oros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010109' => _x( 'Prassies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010110' => _x( 'Roussospiti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010111' => _x( 'Selli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010112' => _x( 'Chromonastiri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010201' => _x( 'Adele', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010202' => _x( 'Amnatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010203' => _x( 'Archea Eleftherna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010204' => _x( 'Eleftherna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010205' => _x( 'Erfi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010206' => _x( 'Kyrianna', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010207' => _x( 'Messi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010208' => _x( 'Pagalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010209' => _x( 'Pigi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010210' => _x( 'Prinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010211' => _x( 'Skouloufia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010212' => _x( 'Chamalevri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010213' => _x( 'Charkia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010301' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010302' => _x( 'Argyroupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010303' => _x( 'Archontiki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010304' => _x( 'Vilandredo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010305' => _x( 'Karoti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010306' => _x( 'Kato Poros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010307' => _x( 'Koufi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010308' => _x( 'Myriokefala', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010401' => _x( 'Gonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010402' => _x( 'Aghios Konstantinos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010403' => _x( 'Ano Valsamonero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010404' => _x( 'Atsipopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010405' => _x( 'Geranio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010406' => _x( 'Zouridio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010407' => _x( 'Kalonyktis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010408' => _x( 'Kato Valsamonero', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010409' => _x( 'Malakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010410' => _x( 'Mountros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010411' => _x( 'Prines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010412' => _x( 'Roustika', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010413' => _x( 'Saitoures', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73010414' => _x( 'Frantzeskiana Metochia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020101' => _x( 'Spilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020102' => _x( 'Aghia Galini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020103' => _x( 'Akoumia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020104' => _x( 'Ardaktos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020105' => _x( 'Drimiskos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020106' => _x( 'Karines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020107' => _x( 'Kentrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020108' => _x( 'Kerames', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020109' => _x( 'Kissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020110' => _x( 'Krya Vryssi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020111' => _x( 'Labini', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020112' => _x( 'Melabes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020113' => _x( 'Mourne', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020114' => _x( 'Myxorrouma', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020115' => _x( 'Orne', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020116' => _x( 'Saktouria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020201' => _x( 'Sellia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020202' => _x( 'Aghios Vassilios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020203' => _x( 'Aghios Ioannis Aghiou Vassiliou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020204' => _x( 'Agousseliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020205' => _x( 'Assomatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020206' => _x( 'Koxare', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020207' => _x( 'Lefkogia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020208' => _x( 'Mariou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020209' => _x( 'Myrthios', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73020210' => _x( 'Rodakino', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030101' => _x( 'Apostoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030102' => _x( 'Amari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030103' => _x( 'Ano Meros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030104' => _x( 'Vistagi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030105' => _x( 'Vrysses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030106' => _x( 'Voleones', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030107' => _x( 'Gerakari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030108' => _x( 'Elenes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030109' => _x( 'Thronos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030110' => _x( 'Kalogeros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030111' => _x( 'Meronas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030112' => _x( 'Monastiraki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030113' => _x( 'Pantanassa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030114' => _x( 'Patsos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030201' => _x( 'Fourfouras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030202' => _x( 'Aghia Paraskevi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030203' => _x( 'Aghios Ioannis Amariou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030204' => _x( 'Apodoulou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030205' => _x( 'Vizario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030206' => _x( 'Kouroutes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030207' => _x( 'Labiotes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030208' => _x( 'Lochria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030209' => _x( 'Nithavris', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030210' => _x( 'Petrochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030211' => _x( 'Platania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73030212' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73040000' => _x( 'Anogia (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050101' => _x( 'Perama', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050102' => _x( 'Agheliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050103' => _x( 'Aghios Mamas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050104' => _x( 'Alfa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050105' => _x( 'Achlades', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050106' => _x( 'Kalandare', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050107' => _x( 'Margarites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050108' => _x( 'Melidoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050109' => _x( 'Melissourgaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050110' => _x( 'Orthes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050111' => _x( 'Panormos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050112' => _x( 'Passalites', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050113' => _x( 'Roumeli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050114' => _x( 'Sisses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050115' => _x( 'Skepasti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050116' => _x( 'Choumeri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050201' => _x( 'Zoniana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050301' => _x( 'Garazo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050302' => _x( 'Aghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050303' => _x( 'Aghios Ioannis Mylopotamou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050304' => _x( 'Aimonas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050305' => _x( 'Aloides', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050306' => _x( 'Axos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050307' => _x( 'Apladiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050308' => _x( 'Venio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050309' => _x( 'Damavolos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050310' => _x( 'Doxaro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050311' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050312' => _x( 'Theodora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050313' => _x( 'Kalyvos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050314' => _x( 'Kryoneri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050315' => _x( 'Livadia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR73050316' => _x( 'Chonos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010101' => _x( 'Chania', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010201' => _x( 'Aronio (Pithari)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010202' => _x( 'Kounoupidiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010203' => _x( 'Mouzouras', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010204' => _x( 'Sternes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010205' => _x( 'Chordaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010301' => _x( 'Mournies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010302' => _x( 'Nerokouros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010401' => _x( 'Vamvakopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010402' => _x( 'Aghia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010403' => _x( 'Varypetro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010404' => _x( 'Therisso', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010405' => _x( 'Perivolia Kydonias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010501' => _x( 'Pappadiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010502' => _x( 'Drakona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010503' => _x( 'Kabi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010504' => _x( 'Kontopoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010505' => _x( 'Malaxa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010506' => _x( 'Platyvola', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010601' => _x( 'Daratsos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010602' => _x( 'Aghia Marina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010603' => _x( 'Galatas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010604' => _x( 'Stalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010701' => _x( 'Souda', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010702' => _x( 'Aptera', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74010703' => _x( 'Tsikalaria', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020101' => _x( 'Vrysses Apokoronou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020102' => _x( 'Alikabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020103' => _x( 'Vafes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020104' => _x( 'Ebrosneros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020105' => _x( 'Maza', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020106' => _x( 'Nipos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020201' => _x( 'Kalyves', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020202' => _x( 'Armeni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020203' => _x( 'Kares Apokoronou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020204' => _x( 'Macheri', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020205' => _x( 'Neo Chorio Apokoronou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020206' => _x( 'Ramni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020207' => _x( 'Stylos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020301' => _x( 'Assi Gonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020401' => _x( 'Vamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020402' => _x( 'Gavalochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020403' => _x( 'Kaina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020404' => _x( 'Kalamitsio Alexandrou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020405' => _x( 'Kefalas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020406' => _x( 'Kokkino Chorio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020407' => _x( 'Xirosterni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020408' => _x( 'Plaka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020409' => _x( 'Sellia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020501' => _x( 'Kournas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020502' => _x( 'Georgioupoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020503' => _x( 'Kalamitsio Amygdalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020504' => _x( 'Kastellos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020505' => _x( 'Fylaki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020601' => _x( 'Fres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020602' => _x( 'Melidoni', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020603' => _x( 'Paidochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020604' => _x( 'Pemonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74020605' => _x( 'Tzitzifes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74030000' => _x( 'Gavdos (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040101' => _x( 'Paleochora', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040102' => _x( 'Vothiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040103' => _x( 'Voutas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040104' => _x( 'Sarakina', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040105' => _x( 'Sklavopoula', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040201' => _x( 'Kabanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040202' => _x( 'Epanochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040203' => _x( 'Rodovani', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040204' => _x( 'Skafi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040205' => _x( 'Sougia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040206' => _x( 'Temenia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040301' => _x( 'Kandanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040302' => _x( 'Kakodikio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74040303' => _x( 'Plemeniana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050101' => _x( 'Kissamos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050102' => _x( 'Gramvoussa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050103' => _x( 'Kalathenes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050104' => _x( 'Kallergiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050105' => _x( 'Koukounara', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050106' => _x( 'Loussakies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050107' => _x( 'Platanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050108' => _x( 'Polyrrinia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050109' => _x( 'Sirikario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050201' => _x( 'Elos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050202' => _x( 'Amygdalokefalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050203' => _x( 'Vathi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050204' => _x( 'Vlatos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050205' => _x( 'Kabos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050206' => _x( 'Kefalio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050207' => _x( 'Perivolia Kissamou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050208' => _x( 'Strovles', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050301' => _x( 'Drapanias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050302' => _x( 'Voulgaro', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050303' => _x( 'Kaloudiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050304' => _x( 'Malathyros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050305' => _x( 'Pervolakia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050306' => _x( 'Potamida', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050307' => _x( 'Rokka', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050308' => _x( 'Sassalos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050309' => _x( 'Sfakopigadi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050310' => _x( 'Topolia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050311' => _x( 'Faleliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74050312' => _x( 'Cherethiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060101' => _x( 'Geranio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060102' => _x( 'Vlacheronitissa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060103' => _x( 'Vrysses Kydonias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060104' => _x( 'Zounakio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060105' => _x( 'Kontomario', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060106' => _x( 'Kyparissos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060107' => _x( 'Maleme', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060108' => _x( 'Manoliopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060109' => _x( 'Modio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060110' => _x( 'Deres', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060111' => _x( 'Xamoudochori', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060112' => _x( 'Platanias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060113' => _x( 'Sirilio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060201' => _x( 'Voukolies', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060202' => _x( 'Anoskeli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060203' => _x( 'Kakopetros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060204' => _x( 'Neo Chorio Kydonias', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060205' => _x( 'Neriana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060206' => _x( 'Palea Roumata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060207' => _x( 'Polemarchio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060208' => _x( 'Tavronitis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060209' => _x( 'Chryssavgi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060301' => _x( 'Kolymvari', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060302' => _x( 'Afrata', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060303' => _x( 'Vassilopoulo', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060304' => _x( 'Vouves', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060305' => _x( 'Glossa', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060306' => _x( 'Deliana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060307' => _x( 'Drakona', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060308' => _x( 'Episkopi', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060309' => _x( 'Zybragos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060310' => _x( 'Kalydonia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060311' => _x( 'Kamissiana', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060312' => _x( 'Kares Kissamou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060313' => _x( 'Nochia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060314' => _x( 'Panethimos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060315' => _x( 'Ravdoucha', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060316' => _x( 'Rodopos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060317' => _x( 'Spilia', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060401' => _x( 'Alikianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060402' => _x( 'Vatolakkos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060403' => _x( 'Karanos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060404' => _x( 'Koufos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060405' => _x( 'Lakki', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060406' => _x( 'Meskla', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060407' => _x( 'Orthounio', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060408' => _x( 'Prasses', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060409' => _x( 'Sebronas', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060410' => _x( 'Skines', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060411' => _x( 'Fournes', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74060412' => _x( 'Psathoyannos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070001' => _x( 'Chora Sfakion', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070002' => _x( 'Aghia Roumeli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070003' => _x( 'Aghios Ioannis', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070004' => _x( 'Anopoli', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070005' => _x( 'Askyfou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070006' => _x( 'Asfendou', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070007' => _x( 'Ibros', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070008' => _x( 'Patsianos', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR74070009' => _x( 'Skaloti', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GR99010000' => _x( 'Aghio Oros (psevdo)', 'GR-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
