<?php

/**
 * List of cities for: Georgia
 * Source: http://census.ge/files/results/Census_release_ENG.pdf
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'GE-TB' => _x( 'Tbilisi', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-AJ' => _x( 'Adjara', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-GU' => _x( 'Guria', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-IM' => _x( 'Imereti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-KA' => _x( 'Kakheti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-MM' => _x( 'Mtsketa-Mtianeti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-RL' => _x( 'Racha-Lechkhumi and Kvemo Svaneti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-SZ' => _x( 'Samegrelo-Zemo Svaneti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-SJ' => _x( 'Samtskhe-Javakheti', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-KK' => _x( 'Kvemo Kartli', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'GE-SK' => _x( 'Shida Kartli', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'GE-TB'	=> [
		'GETBILISI' => _x( 'TBILISI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-AJ'	=> [
		'GEBATUMI' => _x( 'BATUMI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKEDA' => _x( 'KEDA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKOBULETI' => _x( 'KOBULETI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESHUAKHEVI' => _x( 'SHUAKHEVI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHELVACHAURI' => _x( 'KHELVACHAURI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHULO' => _x( 'KHULO', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-GU'	=> [
		'GEOZURGETI_CITY' => _x( 'OZURGETI CITY', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GELANCHKHUTI' => _x( 'LANCHKHUTI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEOZURGETI' => _x( 'OZURGETI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GECHOKHATAURI' => _x( 'CHOKHATAURI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-IM'	=> [
		'GEKUTAISI' => _x( 'KUTAISI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEBAGHDATI' => _x( 'BAGHDATI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEVANI' => _x( 'VANI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEZESTAPONI' => _x( 'ZESTAPONI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETERJOLA' => _x( 'TERJOLA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESAMTREDIA' => _x( 'SAMTREDIA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESACHKHERE' => _x( 'SACHKHERE', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETKIBULI' => _x( 'TKIBULI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETSKALTUBO' => _x( 'TSKALTUBO', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GECHIATURA' => _x( 'CHIATURA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHARAGAULI' => _x( 'KHARAGAULI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHONI' => _x( 'KHONI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-KA'	=> [
		'GETELAVI' => _x( 'TELAVI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEAKHMETA' => _x( 'AKHMETA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEGURJAANI' => _x( 'GURJAANI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEDEDOPLISTSKARO' => _x( 'DEDOPLISTSKARO', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETELAVI' => _x( 'TELAVI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GELAGODEKHI' => _x( 'LAGODEKHI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESAGAREJO' => _x( 'SAGAREJO', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESIGHNAGHI' => _x( 'SIGHNAGHI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKVARELI' => _x( 'KVARELI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-MM'	=> [
		'GEMTSKHETA_CITY' => _x( 'MTSKHETA CITY', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEDUSHETI' => _x( 'DUSHETI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETIANETI' => _x( 'TIANETI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEMTSKHETA' => _x( 'MTSKHETA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKAZBEGI' => _x( 'KAZBEGI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-RL'	=> [
		'GEAMBROLAURI' => _x( 'AMBROLAURI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEAMBROLAURI' => _x( 'AMBROLAURI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GELENTEKHI' => _x( 'LENTEKHI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEONI' => _x( 'ONI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETSAGERI' => _x( 'TSAGERI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-SZ'	=> [
		'GEZUGDIDI' => _x( 'ZUGDIDI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEPOTI' => _x( 'POTI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEABASHA' => _x( 'ABASHA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEZUGDIDI' => _x( 'ZUGDIDI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEMARTVILI' => _x( 'MARTVILI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEMESTIA' => _x( 'MESTIA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GESENAKI' => _x( 'SENAKI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GECHKHOROTSKU' => _x( 'CHKHOROTSKU', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETSALENJIKHA' => _x( 'TSALENJIKHA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHOBI' => _x( 'KHOBI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-SJ'	=> [
		'GEAKHALTSIKHE' => _x( 'AKHALTSIKHE', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEADIGENI' => _x( 'ADIGENI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEASPINDZA' => _x( 'ASPINDZA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEAKHALKALAKI' => _x( 'AKHALKALAKI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEAKHALTSIKHE' => _x( 'AKHALTSIKHE', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEBORJOMI' => _x( 'BORJOMI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GENINOTSMINDA' => _x( 'NINOTSMINDA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-KK'	=> [
		'GERUSTAVI' => _x( 'RUSTAVI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEBOLNISI' => _x( 'BOLNISI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEGARDABANI' => _x( 'GARDABANI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEDMANISI' => _x( 'DMANISI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETETRITSKARO' => _x( 'TETRITSKARO', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEMARNEULI' => _x( 'MARNEULI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GETSALKA' => _x( 'TSALKA', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'GE-SK'	=> [
		'GEGORI_CITY' => _x( 'GORI CITY', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEGORI' => _x( 'GORI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKASPI' => _x( 'KASPI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKARELI' => _x( 'KARELI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'GEKHASHURI' => _x( 'KHASHURI', 'GE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
