<?php

/**
 * List of cities for: France
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'FR01001' => 'LAbergement-Clémenciat',
	'FR01002' => 'LAbergement-de-Varey',
	'FR01004' => 'Ambérieu-en-Bugey',
	'FR01005' => 'Ambérieux-en-Dombes',
	'FR01006' => 'Ambléon',
	'FR01007' => 'Ambronay',
	'FR01008' => 'Ambutrix',
	'FR01009' => 'Andert-et-Condon',
	'FR01010' => 'Anglefort',
	'FR01011' => 'Apremont',
	'FR01012' => 'Aranc',
	'FR01013' => 'Arandas',
	'FR01014' => 'Arbent',
	'FR01015' => 'Arboys en Bugey',
	'FR01016' => 'Arbigny',
	'FR01017' => 'Argis',
	'FR01019' => 'Armix',
	'FR01021' => 'Ars-sur-Formans',
	'FR01022' => 'Artemare',
	'FR01023' => 'Asnières-sur-Saône',
	'FR01024' => 'Attignat',
	'FR01025' => 'Bâgé-Dommartin',
	'FR01026' => 'Bâgé-le-Châtel',
	'FR01027' => 'Balan',
	'FR01028' => 'Baneins',
	'FR01029' => 'Beaupont',
	'FR01030' => 'Beauregard',
	'FR01031' => 'Bellignat',
	'FR01032' => 'Béligneux',
	'FR01033' => 'Valserhône',
	'FR01034' => 'Belley',
	'FR01035' => 'Belleydoux',
	'FR01036' => 'Valromey-sur-Séran',
	'FR01037' => 'Bénonces',
	'FR01038' => 'Bény',
	'FR01039' => 'Béon',
	'FR01040' => 'Béréziat',
	'FR01041' => 'Bettant',
	'FR01042' => 'Bey',
	'FR01043' => 'Beynost',
	'FR01044' => 'Billiat',
	'FR01045' => 'Birieux',
	'FR01046' => 'Biziat',
	'FR01047' => 'Blyes',
	'FR01049' => 'La Boisse',
	'FR01050' => 'Boissey',
	'FR01051' => 'Bolozon',
	'FR01052' => 'Bouligneux',
	'FR01053' => 'Bourg-en-Bresse',
	'FR01054' => 'Bourg-Saint-Christophe',
	'FR01056' => 'Boyeux-Saint-Jérôme',
	'FR01057' => 'Boz',
	'FR01058' => 'Brégnier-Cordon',
	'FR01060' => 'Brénod',
	'FR01061' => 'Brens',
	'FR01062' => 'Bressolles',
	'FR01063' => 'Brion',
	'FR01064' => 'Briord',
	'FR01065' => 'Buellas',
	'FR01066' => 'La Burbanche',
	'FR01067' => 'Ceignes',
	'FR01068' => 'Cerdon',
	'FR01069' => 'Certines',
	'FR01071' => 'Cessy',
	'FR01072' => 'Ceyzériat',
	'FR01073' => 'Ceyzérieu',
	'FR01074' => 'Chalamont',
	'FR01075' => 'Chaleins',
	'FR01076' => 'Chaley',
	'FR01077' => 'Challes-la-Montagne',
	'FR01078' => 'Challex',
	'FR01079' => 'Champagne-en-Valromey',
	'FR01080' => 'Champdor-Corcelles',
	'FR01081' => 'Champfromier',
	'FR01082' => 'Chanay',
	'FR01083' => 'Chaneins',
	'FR01084' => 'Chanoz-Châtenay',
	'FR01085' => 'La Chapelle-du-Châtelard',
	'FR01087' => 'Charix',
	'FR01088' => 'Charnoz-sur-Ain',
	'FR01089' => 'Château-Gaillard',
	'FR01090' => 'Châtenay',
	'FR01092' => 'Châtillon-la-Palud',
	'FR01093' => 'Châtillon-sur-Chalaronne',
	'FR01094' => 'Chavannes-sur-Reyssouze',
	'FR01095' => 'Nivigne et Suran',
	'FR01096' => 'Chaveyriat',
	'FR01098' => 'Chazey-Bons',
	'FR01099' => 'Chazey-sur-Ain',
	'FR01100' => 'Cheignieu-la-Balme',
	'FR01101' => 'Chevillard',
	'FR01102' => 'Chevroux',
	'FR01103' => 'Chevry',
	'FR01104' => 'Chézery-Forens',
	'FR01105' => 'Civrieux',
	'FR01106' => 'Cize',
	'FR01107' => 'Cleyzieu',
	'FR01108' => 'Coligny',
	'FR01109' => 'Collonges',
	'FR01110' => 'Colomieu',
	'FR01111' => 'Conand',
	'FR01112' => 'Condamine',
	'FR01113' => 'Condeissiat',
	'FR01114' => 'Confort',
	'FR01115' => 'Confrançon',
	'FR01116' => 'Contrevoz',
	'FR01117' => 'Conzieu',
	'FR01118' => 'Corbonod',
	'FR01121' => 'Corlier',
	'FR01123' => 'Cormoranche-sur-Saône',
	'FR01124' => 'Cormoz',
	'FR01125' => 'Corveissiat',
	'FR01127' => 'Courmangoux',
	'FR01128' => 'Courtes',
	'FR01129' => 'Crans',
	'FR01130' => 'Bresse Vallons',
	'FR01133' => 'Cressin-Rochefort',
	'FR01134' => 'Crottet',
	'FR01135' => 'Crozet',
	'FR01136' => 'Cruzilles-lès-Mépillat',
	'FR01138' => 'Culoz',
	'FR01139' => 'Curciat-Dongalon',
	'FR01140' => 'Curtafond',
	'FR01141' => 'Cuzieu',
	'FR01142' => 'Dagneux',
	'FR01143' => 'Divonne-les-Bains',
	'FR01145' => 'Dompierre-sur-Veyle',
	'FR01146' => 'Dompierre-sur-Chalaronne',
	'FR01147' => 'Domsure',
	'FR01148' => 'Dortan',
	'FR01149' => 'Douvres',
	'FR01150' => 'Drom',
	'FR01151' => 'Druillat',
	'FR01152' => 'Échallon',
	'FR01153' => 'Échenevex',
	'FR01155' => 'Évosges',
	'FR01156' => 'Faramans',
	'FR01157' => 'Fareins',
	'FR01158' => 'Farges',
	'FR01159' => 'Feillens',
	'FR01160' => 'Ferney-Voltaire',
	'FR01162' => 'Flaxieu',
	'FR01163' => 'Foissiat',
	'FR01165' => 'Francheleins',
	'FR01166' => 'Frans',
	'FR01167' => 'Garnerans',
	'FR01169' => 'Genouilleux',
	'FR01170' => 'Béard-Géovreissiat',
	'FR01171' => 'Géovreisset',
	'FR01173' => 'Gex',
	'FR01174' => 'Giron',
	'FR01175' => 'Gorrevod',
	'FR01177' => 'Grand-Corent',
	'FR01179' => 'Grièges',
	'FR01180' => 'Grilly',
	'FR01181' => 'Groissiat',
	'FR01183' => 'Guéreins',
	'FR01184' => 'Hautecourt-Romanèche',
	'FR01185' => 'Plateau dHauteville',
	'FR01187' => 'Haut Valromey',
	'FR01188' => 'Illiat',
	'FR01189' => 'Injoux-Génissiat',
	'FR01190' => 'Innimond',
	'FR01191' => 'Izenave',
	'FR01192' => 'Izernore',
	'FR01193' => 'Izieu',
	'FR01194' => 'Jassans-Riottier',
	'FR01195' => 'Jasseron',
	'FR01196' => 'Jayat',
	'FR01197' => 'Journans',
	'FR01198' => 'Joyeux',
	'FR01199' => 'Jujurieux',
	'FR01200' => 'Labalme',
	'FR01202' => 'Lagnieu',
	'FR01203' => 'Laiz',
	'FR01204' => 'Le Poizat-Lalleyriat',
	'FR01206' => 'Lantenay',
	'FR01207' => 'Lapeyrouse',
	'FR01208' => 'Lavours',
	'FR01209' => 'Léaz',
	'FR01210' => 'Lélex',
	'FR01211' => 'Lent',
	'FR01212' => 'Lescheroux',
	'FR01213' => 'Leyment',
	'FR01214' => 'Leyssard',
	'FR01215' => 'Surjoux-Lhopital',
	'FR01216' => 'Lhuis',
	'FR01219' => 'Lompnas',
	'FR01224' => 'Loyettes',
	'FR01225' => 'Lurcy',
	'FR01227' => 'Magnieu',
	'FR01228' => 'Maillat',
	'FR01229' => 'Malafretaz',
	'FR01230' => 'Mantenay-Montlin',
	'FR01231' => 'Manziat',
	'FR01232' => 'Marboz',
	'FR01233' => 'Marchamp',
	'FR01234' => 'Marignieu',
	'FR01235' => 'Marlieux',
	'FR01236' => 'Marsonnas',
	'FR01237' => 'Martignat',
	'FR01238' => 'Massieux',
	'FR01239' => 'Massignieu-de-Rives',
	'FR01240' => 'Matafelon-Granges',
	'FR01241' => 'Meillonnas',
	'FR01242' => 'Mérignat',
	'FR01243' => 'Messimy-sur-Saône',
	'FR01244' => 'Meximieux',
	'FR01245' => 'Bohas-Meyriat-Rignat',
	'FR01246' => 'Mézériat',
	'FR01247' => 'Mijoux',
	'FR01248' => 'Mionnay',
	'FR01249' => 'Miribel',
	'FR01250' => 'Misérieux',
	'FR01252' => 'Mogneneins',
	'FR01254' => 'Montagnat',
	'FR01255' => 'Montagnieu',
	'FR01257' => 'Montanges',
	'FR01258' => 'Montceaux',
	'FR01259' => 'Montcet',
	'FR01260' => 'Le Montellier',
	'FR01261' => 'Monthieux',
	'FR01262' => 'Montluel',
	'FR01263' => 'Montmerle-sur-Saône',
	'FR01264' => 'Montracol',
	'FR01265' => 'Montréal-la-Cluse',
	'FR01266' => 'Montrevel-en-Bresse',
	'FR01267' => 'Nurieux-Volognat',
	'FR01268' => 'Murs-et-Gélignieux',
	'FR01269' => 'Nantua',
	'FR01272' => 'Neuville-les-Dames',
	'FR01273' => 'Neuville-sur-Ain',
	'FR01274' => 'Les Neyrolles',
	'FR01275' => 'Neyron',
	'FR01276' => 'Niévroz',
	'FR01277' => 'Nivollet-Montgriffon',
	'FR01279' => 'Oncieu',
	'FR01280' => 'Ordonnaz',
	'FR01281' => 'Ornex',
	'FR01282' => 'Outriaz',
	'FR01283' => 'Oyonnax',
	'FR01284' => 'Ozan',
	'FR01285' => 'Parcieux',
	'FR01286' => 'Parves et Nattages',
	'FR01288' => 'Péron',
	'FR01289' => 'Péronnas',
	'FR01290' => 'Pérouges',
	'FR01291' => 'Perrex',
	'FR01293' => 'Peyriat',
	'FR01294' => 'Peyrieu',
	'FR01295' => 'Peyzieux-sur-Saône',
	'FR01296' => 'Pirajoux',
	'FR01297' => 'Pizay',
	'FR01298' => 'Plagne',
	'FR01299' => 'Le Plantay',
	'FR01301' => 'Polliat',
	'FR01302' => 'Pollieu',
	'FR01303' => 'Poncin',
	'FR01304' => 'Pont-dAin',
	'FR01305' => 'Pont-de-Vaux',
	'FR01306' => 'Pont-de-Veyle',
	'FR01307' => 'Port',
	'FR01308' => 'Pougny',
	'FR01309' => 'Pouillat',
	'FR01310' => 'Prémeyzel',
	'FR01311' => 'Prémillieu',
	'FR01313' => 'Prévessin-Moëns',
	'FR01314' => 'Priay',
	'FR01317' => 'Ramasse',
	'FR01318' => 'Rancé',
	'FR01319' => 'Relevant',
	'FR01320' => 'Replonges',
	'FR01321' => 'Revonnas',
	'FR01322' => 'Reyrieux',
	'FR01323' => 'Reyssouze',
	'FR01325' => 'Rignieux-le-Franc',
	'FR01328' => 'Romans',
	'FR01329' => 'Rossillon',
	'FR01330' => 'Ruffieu',
	'FR01331' => 'Saint-Alban',
	'FR01332' => 'Saint-André-de-Bâgé',
	'FR01333' => 'Saint-André-de-Corcy',
	'FR01334' => 'Saint-André-dHuiriat',
	'FR01335' => 'Saint-André-le-Bouchoux',
	'FR01336' => 'Saint-André-sur-Vieux-Jonc',
	'FR01337' => 'Saint-Bénigne',
	'FR01338' => 'Groslée-Saint-Benoit',
	'FR01339' => 'Saint-Bernard',
	'FR01342' => 'Sainte-Croix',
	'FR01343' => 'Saint-Cyr-sur-Menthon',
	'FR01344' => 'Saint-Denis-lès-Bourg',
	'FR01345' => 'Saint-Denis-en-Bugey',
	'FR01346' => 'Saint-Didier-dAussiat',
	'FR01347' => 'Saint-Didier-de-Formans',
	'FR01348' => 'Saint-Didier-sur-Chalaronne',
	'FR01349' => 'Saint-Éloi',
	'FR01350' => 'Saint-Étienne-du-Bois',
	'FR01351' => 'Saint-Étienne-sur-Chalaronne',
	'FR01352' => 'Saint-Étienne-sur-Reyssouze',
	'FR01353' => 'Sainte-Euphémie',
	'FR01354' => 'Saint-Genis-Pouilly',
	'FR01355' => 'Saint-Genis-sur-Menthon',
	'FR01356' => 'Saint-Georges-sur-Renon',
	'FR01357' => 'Saint-Germain-de-Joux',
	'FR01358' => 'Saint-Germain-les-Paroisses',
	'FR01359' => 'Saint-Germain-sur-Renon',
	'FR01360' => 'Saint-Jean-de-Gonville',
	'FR01361' => 'Saint-Jean-de-Niost',
	'FR01362' => 'Saint-Jean-de-Thurigneux',
	'FR01363' => 'Saint-Jean-le-Vieux',
	'FR01364' => 'Saint-Jean-sur-Reyssouze',
	'FR01365' => 'Saint-Jean-sur-Veyle',
	'FR01366' => 'Sainte-Julie',
	'FR01367' => 'Saint-Julien-sur-Reyssouze',
	'FR01368' => 'Saint-Julien-sur-Veyle',
	'FR01369' => 'Saint-Just',
	'FR01370' => 'Saint-Laurent-sur-Saône',
	'FR01371' => 'Saint-Marcel',
	'FR01372' => 'Saint-Martin-de-Bavel',
	'FR01373' => 'Saint-Martin-du-Frêne',
	'FR01374' => 'Saint-Martin-du-Mont',
	'FR01375' => 'Saint-Martin-le-Châtel',
	'FR01376' => 'Saint-Maurice-de-Beynost',
	'FR01378' => 'Saint-Maurice-de-Gourdans',
	'FR01379' => 'Saint-Maurice-de-Rémens',
	'FR01380' => 'Saint-Nizier-le-Bouchoux',
	'FR01381' => 'Saint-Nizier-le-Désert',
	'FR01382' => 'Sainte-Olive',
	'FR01383' => 'Saint-Paul-de-Varax',
	'FR01384' => 'Saint-Rambert-en-Bugey',
	'FR01385' => 'Saint-Rémy',
	'FR01386' => 'Saint-Sorlin-en-Bugey',
	'FR01387' => 'Saint-Sulpice',
	'FR01388' => 'Saint-Trivier-de-Courtes',
	'FR01389' => 'Saint-Trivier-sur-Moignans',
	'FR01390' => 'Saint-Vulbas',
	'FR01391' => 'Salavre',
	'FR01392' => 'Samognat',
	'FR01393' => 'Sandrans',
	'FR01396' => 'Sault-Brénaz',
	'FR01397' => 'Sauverny',
	'FR01398' => 'Savigneux',
	'FR01399' => 'Ségny',
	'FR01400' => 'Seillonnaz',
	'FR01401' => 'Sergy',
	'FR01402' => 'Sermoyer',
	'FR01403' => 'Serrières-de-Briord',
	'FR01404' => 'Serrières-sur-Ain',
	'FR01405' => 'Servas',
	'FR01406' => 'Servignat',
	'FR01407' => 'Seyssel',
	'FR01408' => 'Simandre-sur-Suran',
	'FR01410' => 'Sonthonnax-la-Montagne',
	'FR01411' => 'Souclin',
	'FR01412' => 'Sulignat',
	'FR01415' => 'Talissieu',
	'FR01416' => 'Tenay',
	'FR01418' => 'Thil',
	'FR01419' => 'Thoiry',
	'FR01420' => 'Thoissey',
	'FR01421' => 'Torcieu',
	'FR01422' => 'Tossiat',
	'FR01423' => 'Toussieux',
	'FR01424' => 'Tramoyes',
	'FR01425' => 'La Tranclière',
	'FR01426' => 'Val-Revermont',
	'FR01427' => 'Trévoux',
	'FR01428' => 'Valeins',
	'FR01429' => 'Vandeins',
	'FR01430' => 'Varambon',
	'FR01431' => 'Vaux-en-Bugey',
	'FR01432' => 'Verjon',
	'FR01433' => 'Vernoux',
	'FR01434' => 'Versailleux',
	'FR01435' => 'Versonnex',
	'FR01436' => 'Vesancy',
	'FR01437' => 'Vescours',
	'FR01439' => 'Vésines',
	'FR01441' => 'Vieu-dIzenave',
	'FR01443' => 'Villars-les-Dombes',
	'FR01444' => 'Villebois',
	'FR01445' => 'Villemotier',
	'FR01446' => 'Villeneuve',
	'FR01447' => 'Villereversure',
	'FR01448' => 'Villes',
	'FR01449' => 'Villette-sur-Ain',
	'FR01450' => 'Villieu-Loyes-Mollon',
	'FR01451' => 'Viriat',
	'FR01452' => 'Virieu-le-Grand',
	'FR01453' => 'Arvière-en-Valromey',
	'FR01454' => 'Virignin',
	'FR01456' => 'Vongnes',
	'FR01457' => 'Vonnas',
	'FR02001' => 'Abbécourt',
	'FR02002' => 'Achery',
	'FR02003' => 'Acy',
	'FR02004' => 'Agnicourt-et-Séchelles',
	'FR02005' => 'Aguilcourt',
	'FR02006' => 'Aisonville-et-Bernoville',
	'FR02007' => 'Aizelles',
	'FR02008' => 'Aizy-Jouy',
	'FR02009' => 'Alaincourt',
	'FR02010' => 'Allemant',
	'FR02011' => 'Ambleny',
	'FR02012' => 'Ambrief',
	'FR02013' => 'Amifontaine',
	'FR02014' => 'Amigny-Rouy',
	'FR02015' => 'Ancienville',
	'FR02016' => 'Andelain',
	'FR02017' => 'Anguilcourt-le-Sart',
	'FR02018' => 'Anizy-le-Grand',
	'FR02019' => 'Annois',
	'FR02020' => 'Any-Martin-Rieux',
	'FR02021' => 'Archon',
	'FR02022' => 'Arcy-Sainte-Restitue',
	'FR02023' => 'Armentières-sur-Ourcq',
	'FR02024' => 'Arrancy',
	'FR02025' => 'Artemps',
	'FR02027' => 'Assis-sur-Serre',
	'FR02028' => 'Athies-sous-Laon',
	'FR02029' => 'Attilly',
	'FR02030' => 'Aubencheul-aux-Bois',
	'FR02031' => 'Aubenton',
	'FR02032' => 'Aubigny-aux-Kaisnes',
	'FR02033' => 'Aubigny-en-Laonnois',
	'FR02034' => 'Audignicourt',
	'FR02035' => 'Audigny',
	'FR02036' => 'Augy',
	'FR02037' => 'Aulnois-sous-Laon',
	'FR02038' => 'Les Autels',
	'FR02039' => 'Autremencourt',
	'FR02040' => 'Autreppes',
	'FR02041' => 'Autreville',
	'FR02042' => 'Azy-sur-Marne',
	'FR02043' => 'Bagneux',
	'FR02044' => 'Bancigny',
	'FR02046' => 'Barenton-Bugny',
	'FR02047' => 'Barenton-Cel',
	'FR02048' => 'Barenton-sur-Serre',
	'FR02049' => 'Barisis-aux-Bois',
	'FR02050' => 'Barzy-en-Thiérache',
	'FR02051' => 'Barzy-sur-Marne',
	'FR02052' => 'Bassoles-Aulers',
	'FR02053' => 'Vallées en Champagne',
	'FR02054' => 'Bazoches-sur-Vesles',
	'FR02055' => 'Beaumé',
	'FR02056' => 'Beaumont-en-Beine',
	'FR02057' => 'Beaurevoir',
	'FR02058' => 'Beaurieux',
	'FR02059' => 'Beautor',
	'FR02060' => 'Beauvois-en-Vermandois',
	'FR02061' => 'Becquigny',
	'FR02062' => 'Belleau',
	'FR02063' => 'Bellenglise',
	'FR02064' => 'Belleu',
	'FR02065' => 'Bellicourt',
	'FR02066' => 'Benay',
	'FR02067' => 'Bergues-sur-Sambre',
	'FR02068' => 'Berlancourt',
	'FR02069' => 'Berlise',
	'FR02070' => 'Bernot',
	'FR02071' => 'Berny-Rivière',
	'FR02072' => 'Berrieux',
	'FR02073' => 'Berry-au-Bac',
	'FR02074' => 'Bertaucourt-Epourdon',
	'FR02075' => 'Berthenicourt',
	'FR02076' => 'Bertricourt',
	'FR02077' => 'Berzy-le-Sec',
	'FR02078' => 'Besmé',
	'FR02079' => 'Besmont',
	'FR02080' => 'Besny-et-Loizy',
	'FR02081' => 'Béthancourt-en-Vaux',
	'FR02082' => 'Beugneux',
	'FR02083' => 'Beuvardes',
	'FR02084' => 'Bézu-le-Guéry',
	'FR02085' => 'Bézu-Saint-Germain',
	'FR02086' => 'Bichancourt',
	'FR02087' => 'Bieuxy',
	'FR02088' => 'Bièvres',
	'FR02089' => 'Billy-sur-Aisne',
	'FR02090' => 'Billy-sur-Ourcq',
	'FR02091' => 'Blanzy-lès-Fismes',
	'FR02093' => 'Blérancourt',
	'FR02094' => 'Blesmes',
	'FR02095' => 'Bohain-en-Vermandois',
	'FR02096' => 'Bois-lès-Pargny',
	'FR02097' => 'Boncourt',
	'FR02098' => 'Bonneil',
	'FR02099' => 'Bonnesvalyn',
	'FR02100' => 'Bony',
	'FR02101' => 'Bosmont-sur-Serre',
	'FR02102' => 'Bouconville-Vauclair',
	'FR02103' => 'Boué',
	'FR02104' => 'Bouffignereux',
	'FR02105' => 'Bouresches',
	'FR02106' => 'Bourg-et-Comin',
	'FR02107' => 'Bourguignon-sous-Coucy',
	'FR02108' => 'Bourguignon-sous-Montbavin',
	'FR02109' => 'La Bouteille',
	'FR02110' => 'Braine',
	'FR02111' => 'Brancourt-en-Laonnois',
	'FR02112' => 'Brancourt-le-Grand',
	'FR02114' => 'Brasles',
	'FR02115' => 'Braye-en-Laonnois',
	'FR02116' => 'Braye-en-Thiérache',
	'FR02117' => 'Bray-Saint-Christophe',
	'FR02118' => 'Braye',
	'FR02119' => 'Brécy',
	'FR02120' => 'Brenelle',
	'FR02121' => 'Breny',
	'FR02122' => 'Brie',
	'FR02123' => 'Brissay-Choigny',
	'FR02124' => 'Brissy-Hamégicourt',
	'FR02125' => 'Brumetz',
	'FR02126' => 'Brunehamel',
	'FR02127' => 'Bruyères-sur-Fère',
	'FR02128' => 'Bruyères-et-Montbérault',
	'FR02129' => 'Bruys',
	'FR02130' => 'Bucilly',
	'FR02131' => 'Bucy-le-Long',
	'FR02132' => 'Bucy-lès-Cerny',
	'FR02133' => 'Bucy-lès-Pierrepont',
	'FR02134' => 'Buire',
	'FR02135' => 'Buironfosse',
	'FR02136' => 'Burelles',
	'FR02137' => 'Bussiares',
	'FR02138' => 'Buzancy',
	'FR02139' => 'Caillouël-Crépigny',
	'FR02140' => 'Camelin',
	'FR02141' => 'La Capelle',
	'FR02142' => 'Castres',
	'FR02143' => 'Le Catelet',
	'FR02144' => 'Caulaincourt',
	'FR02145' => 'Caumont',
	'FR02146' => 'Celles-lès-Condé',
	'FR02148' => 'Celles-sur-Aisne',
	'FR02149' => 'Cerizy',
	'FR02150' => 'Cerny-en-Laonnois',
	'FR02151' => 'Cerny-lès-Bucy',
	'FR02152' => 'Cerseuil',
	'FR02153' => 'Cessières-Suzy',
	'FR02154' => 'Chacrise',
	'FR02155' => 'Chaillevois',
	'FR02156' => 'Chalandry',
	'FR02157' => 'Chambry',
	'FR02158' => 'Chamouille',
	'FR02159' => 'Champs',
	'FR02160' => 'Chaourse',
	'FR02162' => 'La Chapelle-sur-Chézy',
	'FR02163' => 'Charly-sur-Marne',
	'FR02164' => 'Le Charmel',
	'FR02165' => 'Charmes',
	'FR02166' => 'Chartèves',
	'FR02167' => 'Chassemy',
	'FR02168' => 'Château-Thierry',
	'FR02169' => 'Châtillon-lès-Sons',
	'FR02170' => 'Châtillon-sur-Oise',
	'FR02171' => 'Chaudardes',
	'FR02172' => 'Chaudun',
	'FR02173' => 'Chauny',
	'FR02174' => 'Chavignon',
	'FR02175' => 'Chavigny',
	'FR02176' => 'Chavonne',
	'FR02177' => 'Chérêt',
	'FR02178' => 'Chermizy-Ailles',
	'FR02179' => 'Chéry-Chartreuve',
	'FR02180' => 'Chéry-lès-Pouilly',
	'FR02181' => 'Chéry-lès-Rozoy',
	'FR02182' => 'Chevennes',
	'FR02183' => 'Chevregny',
	'FR02184' => 'Chevresis-Monceau',
	'FR02185' => 'Chézy-en-Orxois',
	'FR02186' => 'Chézy-sur-Marne',
	'FR02187' => 'Chierry',
	'FR02188' => 'Chigny',
	'FR02189' => 'Chivres-en-Laonnois',
	'FR02190' => 'Chivres-Val',
	'FR02191' => 'Chivy-lès-Étouvelles',
	'FR02192' => 'Chouy',
	'FR02193' => 'Cierges',
	'FR02194' => 'Cilly',
	'FR02195' => 'Ciry-Salsogne',
	'FR02196' => 'Clacy-et-Thierret',
	'FR02197' => 'Clairfontaine',
	'FR02198' => 'Clamecy',
	'FR02199' => 'Clastres',
	'FR02200' => 'Clermont-les-Fermes',
	'FR02201' => 'Cœuvres-et-Valsery',
	'FR02203' => 'Coincy',
	'FR02204' => 'Coingt',
	'FR02205' => 'Colligis-Crandelain',
	'FR02206' => 'Colonfay',
	'FR02207' => 'Commenchon',
	'FR02208' => 'Concevreux',
	'FR02209' => 'Condé-en-Brie',
	'FR02210' => 'Condé-sur-Aisne',
	'FR02211' => 'Condé-sur-Suippe',
	'FR02212' => 'Condren',
	'FR02213' => 'Connigis',
	'FR02214' => 'Contescourt',
	'FR02215' => 'Corbeny',
	'FR02216' => 'Corcy',
	'FR02217' => 'Coucy-le-Château-Auffrique',
	'FR02218' => 'Coucy-lès-Eppes',
	'FR02219' => 'Coucy-la-Ville',
	'FR02220' => 'Coulonges-Cohan',
	'FR02221' => 'Coupru',
	'FR02222' => 'Courbes',
	'FR02223' => 'Courboin',
	'FR02224' => 'Courcelles-sur-Vesle',
	'FR02225' => 'Courchamps',
	'FR02226' => 'Courmelles',
	'FR02227' => 'Courmont',
	'FR02228' => 'Courtemont-Varennes',
	'FR02229' => 'Courtrizy-et-Fussigny',
	'FR02230' => 'Couvrelles',
	'FR02231' => 'Couvron-et-Aumencourt',
	'FR02232' => 'Coyolles',
	'FR02233' => 'Cramaille',
	'FR02234' => 'Craonne',
	'FR02235' => 'Craonnelle',
	'FR02236' => 'Crécy-au-Mont',
	'FR02237' => 'Crécy-sur-Serre',
	'FR02238' => 'Crépy',
	'FR02239' => 'Crézancy',
	'FR02240' => 'Croix-Fonsomme',
	'FR02241' => 'La Croix-sur-Ourcq',
	'FR02242' => 'Crouttes-sur-Marne',
	'FR02243' => 'Crouy',
	'FR02244' => 'Crupilly',
	'FR02245' => 'Cuffies',
	'FR02246' => 'Cugny',
	'FR02248' => 'Cuirieux',
	'FR02249' => 'Cuiry-Housse',
	'FR02250' => 'Cuiry-lès-Chaudardes',
	'FR02251' => 'Cuiry-lès-Iviers',
	'FR02252' => 'Cuissy-et-Geny',
	'FR02253' => 'Cuisy-en-Almont',
	'FR02254' => 'Cutry',
	'FR02255' => 'Cys-la-Commune',
	'FR02256' => 'Dagny-Lambercy',
	'FR02257' => 'Dallon',
	'FR02258' => 'Dammard',
	'FR02259' => 'Dampleux',
	'FR02260' => 'Danizy',
	'FR02261' => 'Dercy',
	'FR02262' => 'Deuillet',
	'FR02263' => 'Dhuizel',
	'FR02264' => 'Dizy-le-Gros',
	'FR02265' => 'Dohis',
	'FR02266' => 'Dolignon',
	'FR02267' => 'Dommiers',
	'FR02268' => 'Domptin',
	'FR02269' => 'Dorengt',
	'FR02270' => 'Douchy',
	'FR02271' => 'Dravegny',
	'FR02272' => 'Droizy',
	'FR02273' => 'Dury',
	'FR02274' => 'Ébouleau',
	'FR02275' => 'Effry',
	'FR02276' => 'Englancourt',
	'FR02277' => 'Épagny',
	'FR02278' => 'Éparcy',
	'FR02279' => 'Épaux-Bézu',
	'FR02280' => 'Épieds',
	'FR02281' => 'LÉpine-aux-Bois',
	'FR02282' => 'Eppes',
	'FR02283' => 'Erlon',
	'FR02284' => 'Erloy',
	'FR02286' => 'Esquéhéries',
	'FR02287' => 'Essigny-le-Grand',
	'FR02288' => 'Essigny-le-Petit',
	'FR02289' => 'Essises',
	'FR02290' => 'Essômes-sur-Marne',
	'FR02291' => 'Estrées',
	'FR02292' => 'Étampes-sur-Marne',
	'FR02293' => 'Étaves-et-Bocquiaux',
	'FR02294' => 'Étouvelles',
	'FR02295' => 'Étréaupont',
	'FR02296' => 'Étreillers',
	'FR02297' => 'Étrépilly',
	'FR02298' => 'Étreux',
	'FR02299' => 'Évergnicourt',
	'FR02302' => 'Faverolles',
	'FR02303' => 'Fayet',
	'FR02304' => 'La Fère',
	'FR02305' => 'Fère-en-Tardenois',
	'FR02306' => 'La Ferté-Chevresis',
	'FR02307' => 'La Ferté-Milon',
	'FR02308' => 'Fesmy-le-Sart',
	'FR02309' => 'Festieux',
	'FR02310' => 'Fieulaine',
	'FR02311' => 'Filain',
	'FR02312' => 'La Flamengrie',
	'FR02313' => 'Flavigny-le-Grand-et-Beaurain',
	'FR02315' => 'Flavy-le-Martel',
	'FR02316' => 'Fleury',
	'FR02317' => 'Fluquières',
	'FR02318' => 'Folembray',
	'FR02319' => 'Fonsomme',
	'FR02320' => 'Fontaine-lès-Clercs',
	'FR02321' => 'Fontaine-lès-Vervins',
	'FR02322' => 'Fontaine-Notre-Dame',
	'FR02323' => 'Fontaine-Uterte',
	'FR02324' => 'Fontenelle',
	'FR02326' => 'Fontenoy',
	'FR02327' => 'Foreste',
	'FR02328' => 'Fossoy',
	'FR02329' => 'Fourdrain',
	'FR02330' => 'Francilly-Selency',
	'FR02331' => 'Franqueville',
	'FR02332' => 'Fresnes-en-Tardenois',
	'FR02333' => 'Fresnes-sous-Coucy',
	'FR02334' => 'Fresnoy-le-Grand',
	'FR02335' => 'Fressancourt',
	'FR02336' => 'Frières-Faillouël',
	'FR02337' => 'Froidestrées',
	'FR02338' => 'Froidmont-Cohartille',
	'FR02339' => 'Gandelu',
	'FR02340' => 'Gauchy',
	'FR02341' => 'Gercy',
	'FR02342' => 'Gergny',
	'FR02343' => 'Germaine',
	'FR02345' => 'Gibercourt',
	'FR02346' => 'Gizy',
	'FR02347' => 'Gland',
	'FR02349' => 'Goudelancourt-lès-Berrieux',
	'FR02350' => 'Goudelancourt-lès-Pierrepont',
	'FR02351' => 'Goussancourt',
	'FR02352' => 'Gouy',
	'FR02353' => 'Grandlup-et-Fay',
	'FR02354' => 'Grandrieux',
	'FR02355' => 'Gricourt',
	'FR02356' => 'Grisolles',
	'FR02357' => 'Gronard',
	'FR02358' => 'Grougis',
	'FR02359' => 'Grugies',
	'FR02360' => 'Villeneuve-sur-Aisne',
	'FR02361' => 'Guise',
	'FR02362' => 'Guivry',
	'FR02363' => 'Guny',
	'FR02364' => 'Guyencourt',
	'FR02366' => 'Hannapes',
	'FR02367' => 'Happencourt',
	'FR02368' => 'Haramont',
	'FR02369' => 'Harcigny',
	'FR02370' => 'Hargicourt',
	'FR02371' => 'Harly',
	'FR02372' => 'Hartennes-et-Taux',
	'FR02373' => 'Hary',
	'FR02374' => 'Lehaucourt',
	'FR02375' => 'Hautevesnes',
	'FR02376' => 'Hauteville',
	'FR02377' => 'Haution',
	'FR02378' => 'La Hérie',
	'FR02379' => 'Le Hérie-la-Viéville',
	'FR02380' => 'Hinacourt',
	'FR02381' => 'Hirson',
	'FR02382' => 'Holnon',
	'FR02383' => 'Homblières',
	'FR02384' => 'Houry',
	'FR02385' => 'Housset',
	'FR02386' => 'Iron',
	'FR02387' => 'Itancourt',
	'FR02388' => 'Iviers',
	'FR02389' => 'Jaulgonne',
	'FR02390' => 'Jeancourt',
	'FR02391' => 'Jeantes',
	'FR02392' => 'Joncourt',
	'FR02393' => 'Jouaignes',
	'FR02395' => 'Jumencourt',
	'FR02396' => 'Jumigny',
	'FR02397' => 'Jussy',
	'FR02398' => 'Juvigny',
	'FR02399' => 'Juvincourt-et-Damary',
	'FR02400' => 'Laffaux',
	'FR02401' => 'Laigny',
	'FR02402' => 'Lanchy',
	'FR02403' => 'Landifay-et-Bertaignemont',
	'FR02404' => 'Landouzy-la-Cour',
	'FR02405' => 'Landouzy-la-Ville',
	'FR02406' => 'Landricourt',
	'FR02407' => 'Laniscourt',
	'FR02408' => 'Laon',
	'FR02409' => 'Lappion',
	'FR02410' => 'Largny-sur-Automne',
	'FR02411' => 'Latilly',
	'FR02412' => 'Launoy',
	'FR02413' => 'Laval-en-Laonnois',
	'FR02414' => 'Lavaqueresse',
	'FR02415' => 'Laversine',
	'FR02416' => 'Lemé',
	'FR02417' => 'Lempire',
	'FR02418' => 'Lerzy',
	'FR02419' => 'Leschelle',
	'FR02420' => 'Lesdins',
	'FR02421' => 'Lesges',
	'FR02422' => 'Lesquielles-Saint-Germain',
	'FR02423' => 'Leuilly-sous-Coucy',
	'FR02424' => 'Leury',
	'FR02425' => 'Leuze',
	'FR02426' => 'Levergies',
	'FR02427' => 'Lhuys',
	'FR02428' => 'Licy-Clignon',
	'FR02429' => 'Lierval',
	'FR02430' => 'Liesse-Notre-Dame',
	'FR02431' => 'Liez',
	'FR02432' => 'Limé',
	'FR02433' => 'Lislet',
	'FR02435' => 'Logny-lès-Aubenton',
	'FR02438' => 'Longpont',
	'FR02439' => 'Les Septvallons',
	'FR02440' => 'Lor',
	'FR02441' => 'Louâtre',
	'FR02442' => 'Loupeigne',
	'FR02443' => 'Lucy-le-Bocage',
	'FR02444' => 'Lugny',
	'FR02445' => 'Luzoir',
	'FR02446' => 'Ly-Fontaine',
	'FR02447' => 'Maast-et-Violaine',
	'FR02448' => 'Mâchecourt',
	'FR02449' => 'Macogny',
	'FR02450' => 'Macquigny',
	'FR02451' => 'Magny-la-Fosse',
	'FR02452' => 'Maissemy',
	'FR02453' => 'Maizy',
	'FR02454' => 'La Malmaison',
	'FR02455' => 'Malzy',
	'FR02456' => 'Manicamp',
	'FR02457' => 'Marchais',
	'FR02458' => 'Dhuys et Morin-en-Brie',
	'FR02459' => 'Marcy',
	'FR02460' => 'Marcy-sous-Marle',
	'FR02461' => 'Marest-Dampcourt',
	'FR02462' => 'Mareuil-en-Dôle',
	'FR02463' => 'Marfontaine',
	'FR02464' => 'Margival',
	'FR02465' => 'Marigny-en-Orxois',
	'FR02466' => 'Marizy-Sainte-Geneviève',
	'FR02467' => 'Marizy-Saint-Mard',
	'FR02468' => 'Marle',
	'FR02469' => 'Marly-Gomont',
	'FR02470' => 'Martigny',
	'FR02471' => 'Martigny-Courpierre',
	'FR02472' => 'Mauregny-en-Haye',
	'FR02473' => 'Mayot',
	'FR02474' => 'Mennessis',
	'FR02476' => 'Mennevret',
	'FR02477' => 'Mercin-et-Vaux',
	'FR02478' => 'Merlieux-et-Fouquerolles',
	'FR02480' => 'Mesbrecourt-Richecourt',
	'FR02481' => 'Mesnil-Saint-Laurent',
	'FR02482' => 'Meurival',
	'FR02483' => 'Mézières-sur-Oise',
	'FR02484' => 'Mézy-Moulins',
	'FR02485' => 'Missy-aux-Bois',
	'FR02486' => 'Missy-lès-Pierrepont',
	'FR02487' => 'Missy-sur-Aisne',
	'FR02488' => 'Molain',
	'FR02489' => 'Molinchart',
	'FR02490' => 'Monampteuil',
	'FR02491' => 'Monceau-le-Neuf-et-Faucouzy',
	'FR02492' => 'Monceau-lès-Leups',
	'FR02493' => 'Monceau-le-Waast',
	'FR02494' => 'Monceau-sur-Oise',
	'FR02495' => 'Mondrepuis',
	'FR02496' => 'Monnes',
	'FR02497' => 'Mons-en-Laonnois',
	'FR02498' => 'Montaigu',
	'FR02499' => 'Montbavin',
	'FR02500' => 'Montbrehain',
	'FR02501' => 'Montchâlons',
	'FR02502' => 'Montcornet',
	'FR02503' => 'Mont-dOrigny',
	'FR02504' => 'Montescourt-Lizerolles',
	'FR02505' => 'Montfaucon',
	'FR02506' => 'Montgobert',
	'FR02507' => 'Montgru-Saint-Hilaire',
	'FR02508' => 'Monthenault',
	'FR02509' => 'Monthiers',
	'FR02510' => 'Monthurel',
	'FR02511' => 'Montigny-en-Arrouaise',
	'FR02512' => 'Montigny-lAllier',
	'FR02513' => 'Montigny-le-Franc',
	'FR02514' => 'Montigny-Lengrain',
	'FR02515' => 'Montigny-lès-Condé',
	'FR02516' => 'Montigny-sous-Marle',
	'FR02517' => 'Montigny-sur-Crécy',
	'FR02518' => 'Montlevon',
	'FR02519' => 'Montloué',
	'FR02520' => 'Mont-Notre-Dame',
	'FR02521' => 'Montreuil-aux-Lions',
	'FR02522' => 'Mont-Saint-Jean',
	'FR02523' => 'Mont-Saint-Martin',
	'FR02524' => 'Mont-Saint-Père',
	'FR02525' => 'Morcourt',
	'FR02526' => 'Morgny-en-Thiérache',
	'FR02527' => 'Morsain',
	'FR02528' => 'Mortefontaine',
	'FR02529' => 'Mortiers',
	'FR02530' => 'Moulins',
	'FR02531' => 'Moussy-Verneuil',
	'FR02532' => 'Moÿ-de-lAisne',
	'FR02533' => 'Muret-et-Crouttes',
	'FR02534' => 'Muscourt',
	'FR02535' => 'Nampcelles-la-Cour',
	'FR02536' => 'Nampteuil-sous-Muret',
	'FR02537' => 'Nanteuil-la-Fosse',
	'FR02538' => 'Nanteuil-Notre-Dame',
	'FR02539' => 'Nauroy',
	'FR02540' => 'Nesles-la-Montagne',
	'FR02541' => 'Neufchâtel-sur-Aisne',
	'FR02542' => 'Neuflieux',
	'FR02543' => 'Neuilly-Saint-Front',
	'FR02544' => 'Neuve-Maison',
	'FR02545' => 'La Neuville-Bosmont',
	'FR02546' => 'La Neuville-en-Beine',
	'FR02547' => 'La Neuville-Housset',
	'FR02548' => 'La Neuville-lès-Dorengt',
	'FR02549' => 'Neuville-Saint-Amand',
	'FR02550' => 'Neuville-sur-Ailette',
	'FR02551' => 'Neuville-sur-Margival',
	'FR02552' => 'Neuvillette',
	'FR02553' => 'Nizy-le-Comte',
	'FR02554' => 'Nogentel',
	'FR02555' => 'Nogent-lArtaud',
	'FR02556' => 'Noircourt',
	'FR02557' => 'Noroy-sur-Ourcq',
	'FR02558' => 'Le Nouvion-en-Thiérache',
	'FR02559' => 'Nouvion-et-Catillon',
	'FR02560' => 'Nouvion-le-Comte',
	'FR02561' => 'Nouvion-le-Vineux',
	'FR02562' => 'Nouvron-Vingré',
	'FR02563' => 'Noyales',
	'FR02564' => 'Noyant-et-Aconin',
	'FR02565' => 'Œuilly',
	'FR02566' => 'Ognes',
	'FR02567' => 'Ohis',
	'FR02568' => 'Oigny-en-Valois',
	'FR02569' => 'Oisy',
	'FR02570' => 'Ollezy',
	'FR02571' => 'Omissy',
	'FR02572' => 'Orainville',
	'FR02573' => 'Orgeval',
	'FR02574' => 'Origny-en-Thiérache',
	'FR02575' => 'Origny-Sainte-Benoite',
	'FR02576' => 'Osly-Courtil',
	'FR02577' => 'Ostel',
	'FR02578' => 'Oulches-la-Vallée-Foulon',
	'FR02579' => 'Oulchy-la-Ville',
	'FR02580' => 'Oulchy-le-Château',
	'FR02581' => 'Paars',
	'FR02582' => 'Paissy',
	'FR02583' => 'Pancy-Courtecon',
	'FR02584' => 'Papleux',
	'FR02585' => 'Parcy-et-Tigny',
	'FR02586' => 'Parfondeval',
	'FR02587' => 'Parfondru',
	'FR02588' => 'Pargnan',
	'FR02589' => 'Pargny-Filain',
	'FR02590' => 'Pargny-la-Dhuys',
	'FR02591' => 'Pargny-les-Bois',
	'FR02592' => 'Parpeville',
	'FR02593' => 'Pasly',
	'FR02594' => 'Passy-en-Valois',
	'FR02595' => 'Passy-sur-Marne',
	'FR02596' => 'Pavant',
	'FR02598' => 'Pernant',
	'FR02599' => 'Pierremande',
	'FR02600' => 'Pierrepont',
	'FR02601' => 'Pignicourt',
	'FR02602' => 'Pinon',
	'FR02604' => 'Pithon',
	'FR02605' => 'Pleine-Selve',
	'FR02606' => 'Le Plessier-Huleu',
	'FR02607' => 'Ploisy',
	'FR02608' => 'Plomion',
	'FR02609' => 'Ployart-et-Vaurseine',
	'FR02610' => 'Pommiers',
	'FR02612' => 'Pont-Arcy',
	'FR02613' => 'Pontavert',
	'FR02614' => 'Pontru',
	'FR02615' => 'Pontruet',
	'FR02616' => 'Pont-Saint-Mard',
	'FR02617' => 'Pouilly-sur-Serre',
	'FR02618' => 'Prémont',
	'FR02619' => 'Prémontré',
	'FR02620' => 'Presles-et-Boves',
	'FR02621' => 'Presles-et-Thierny',
	'FR02622' => 'Priez',
	'FR02623' => 'Prisces',
	'FR02624' => 'Proisy',
	'FR02625' => 'Proix',
	'FR02626' => 'Prouvais',
	'FR02627' => 'Proviseux-et-Plesnoy',
	'FR02628' => 'Puiseux-en-Retz',
	'FR02629' => 'Puisieux-et-Clanlieu',
	'FR02631' => 'Quierzy',
	'FR02632' => 'Quincy-Basse',
	'FR02633' => 'Quincy-sous-le-Mont',
	'FR02634' => 'Raillimont',
	'FR02635' => 'Ramicourt',
	'FR02636' => 'Regny',
	'FR02637' => 'Remaucourt',
	'FR02638' => 'Remies',
	'FR02639' => 'Remigny',
	'FR02640' => 'Renansart',
	'FR02641' => 'Renneval',
	'FR02642' => 'Résigny',
	'FR02643' => 'Ressons-le-Long',
	'FR02644' => 'Retheuil',
	'FR02645' => 'Reuilly-Sauvigny',
	'FR02647' => 'Ribeauville',
	'FR02648' => 'Ribemont',
	'FR02649' => 'Rocourt-Saint-Martin',
	'FR02650' => 'Rocquigny',
	'FR02651' => 'Rogécourt',
	'FR02652' => 'Rogny',
	'FR02653' => 'Romeny-sur-Marne',
	'FR02654' => 'Romery',
	'FR02655' => 'Ronchères',
	'FR02656' => 'Roucy',
	'FR02657' => 'Rougeries',
	'FR02658' => 'Roupy',
	'FR02659' => 'Rouvroy',
	'FR02660' => 'Rouvroy-sur-Serre',
	'FR02661' => 'Royaucourt-et-Chailvet',
	'FR02662' => 'Rozet-Saint-Albin',
	'FR02663' => 'Rozières-sur-Crise',
	'FR02664' => 'Rozoy-Bellevalle',
	'FR02665' => 'Grand-Rozoy',
	'FR02666' => 'Rozoy-sur-Serre',
	'FR02667' => 'Saconin-et-Breuil',
	'FR02668' => 'Sains-Richaumont',
	'FR02670' => 'Saint-Algis',
	'FR02671' => 'Saint-Aubin',
	'FR02672' => 'Saint-Bandry',
	'FR02673' => 'Saint-Christophe-à-Berry',
	'FR02674' => 'Saint-Clément',
	'FR02675' => 'Sainte-Croix',
	'FR02676' => 'Saint-Erme-Outre-et-Ramecourt',
	'FR02677' => 'Saint-Eugène',
	'FR02678' => 'Sainte-Geneviève',
	'FR02679' => 'Saint-Gengoulph',
	'FR02680' => 'Saint-Gobain',
	'FR02681' => 'Saint-Gobert',
	'FR02682' => 'Saint-Mard',
	'FR02683' => 'Saint-Martin-Rivière',
	'FR02684' => 'Saint-Michel',
	'FR02685' => 'Saint-Nicolas-aux-Bois',
	'FR02686' => 'Saint-Paul-aux-Bois',
	'FR02687' => 'Saint-Pierre-Aigle',
	'FR02688' => 'Saint-Pierre-lès-Franqueville',
	'FR02689' => 'Saint-Pierremont',
	'FR02690' => 'Sainte-Preuve',
	'FR02691' => 'Saint-Quentin',
	'FR02693' => 'Saint-Rémy-Blanzy',
	'FR02694' => 'Saint-Simon',
	'FR02695' => 'Saint-Thibaut',
	'FR02696' => 'Saint-Thomas',
	'FR02697' => 'Samoussy',
	'FR02698' => 'Sancy-les-Cheminots',
	'FR02699' => 'Saponay',
	'FR02701' => 'Saulchery',
	'FR02702' => 'Savy',
	'FR02703' => 'Seboncourt',
	'FR02704' => 'Selens',
	'FR02705' => 'La Selve',
	'FR02706' => 'Septmonts',
	'FR02707' => 'Septvaux',
	'FR02708' => 'Sequehart',
	'FR02709' => 'Serain',
	'FR02710' => 'Seraucourt-le-Grand',
	'FR02711' => 'Serches',
	'FR02712' => 'Sergy',
	'FR02713' => 'Seringes-et-Nesles',
	'FR02714' => 'Sermoise',
	'FR02715' => 'Serval',
	'FR02716' => 'Servais',
	'FR02717' => 'Séry-lès-Mézières',
	'FR02718' => 'Silly-la-Poterie',
	'FR02719' => 'Sinceny',
	'FR02720' => 'Sissonne',
	'FR02721' => 'Sissy',
	'FR02722' => 'Soissons',
	'FR02723' => 'Soize',
	'FR02724' => 'Sommelans',
	'FR02725' => 'Sommeron',
	'FR02726' => 'Sommette-Eaucourt',
	'FR02727' => 'Sons-et-Ronchères',
	'FR02728' => 'Sorbais',
	'FR02729' => 'Soucy',
	'FR02730' => 'Soupir',
	'FR02731' => 'Le Sourd',
	'FR02732' => 'Surfontaine',
	'FR02734' => 'Taillefontaine',
	'FR02735' => 'Tannières',
	'FR02736' => 'Tartiers',
	'FR02737' => 'Tavaux-et-Pontséricourt',
	'FR02738' => 'Tergnier',
	'FR02739' => 'Terny-Sorny',
	'FR02740' => 'Thenailles',
	'FR02741' => 'Thenelles',
	'FR02742' => 'Thiernu',
	'FR02743' => 'Le Thuel',
	'FR02744' => 'Torcy-en-Valois',
	'FR02745' => 'Toulis-et-Attencourt',
	'FR02746' => 'Travecy',
	'FR02747' => 'Trefcon',
	'FR02748' => 'Trélou-sur-Marne',
	'FR02749' => 'Troësnes',
	'FR02750' => 'Trosly-Loire',
	'FR02751' => 'Trucy',
	'FR02752' => 'Tugny-et-Pont',
	'FR02753' => 'Tupigny',
	'FR02754' => 'Ugny-le-Gay',
	'FR02755' => 'Urcel',
	'FR02756' => 'Urvillers',
	'FR02757' => 'Vadencourt',
	'FR02758' => 'Vailly-sur-Aisne',
	'FR02759' => 'La Vallée-au-Blé',
	'FR02760' => 'La Vallée-Mulâtre',
	'FR02761' => 'Variscourt',
	'FR02762' => 'Vassens',
	'FR02763' => 'Vasseny',
	'FR02764' => 'Vassogne',
	'FR02765' => 'Vaucelles-et-Beffecourt',
	'FR02766' => 'Vaudesson',
	'FR02767' => 'Vauxrezis',
	'FR02768' => 'Vauxaillon',
	'FR02769' => 'Vaux-Andigny',
	'FR02770' => 'Vauxbuin',
	'FR02772' => 'Vaux-en-Vermandois',
	'FR02773' => 'Vauxtin',
	'FR02774' => 'Vendelles',
	'FR02775' => 'Vendeuil',
	'FR02776' => 'Vendhuile',
	'FR02777' => 'Vendières',
	'FR02778' => 'Vendresse-Beaulne',
	'FR02779' => 'Vénérolles',
	'FR02780' => 'Venizel',
	'FR02781' => 'Verdilly',
	'FR02782' => 'Le Verguier',
	'FR02783' => 'Grand-Verly',
	'FR02784' => 'Petit-Verly',
	'FR02785' => 'Vermand',
	'FR02786' => 'Verneuil-sous-Coucy',
	'FR02787' => 'Verneuil-sur-Serre',
	'FR02788' => 'Versigny',
	'FR02789' => 'Vervins',
	'FR02790' => 'Vesles-et-Caumont',
	'FR02791' => 'Veslud',
	'FR02792' => 'Veuilly-la-Poterie',
	'FR02793' => 'Vézaponin',
	'FR02794' => 'Vézilly',
	'FR02795' => 'Vic-sur-Aisne',
	'FR02796' => 'Vichel-Nanteuil',
	'FR02797' => 'Viel-Arcy',
	'FR02798' => 'Viels-Maisons',
	'FR02799' => 'Vierzy',
	'FR02800' => 'Viffort',
	'FR02801' => 'Vigneux-Hocquet',
	'FR02802' => 'La Ville-aux-Bois-lès-Dizy',
	'FR02803' => 'La Ville-aux-Bois-lès-Pontavert',
	'FR02804' => 'Villemontoire',
	'FR02805' => 'Villeneuve-Saint-Germain',
	'FR02806' => 'Villeneuve-sur-Fère',
	'FR02807' => 'Villequier-Aumont',
	'FR02808' => 'Villeret',
	'FR02809' => 'Villers-Agron-Aiguizy',
	'FR02810' => 'Villers-Cotterêts',
	'FR02812' => 'Villers-Hélon',
	'FR02813' => 'Villers-le-Sec',
	'FR02814' => 'Villers-lès-Guise',
	'FR02815' => 'Villers-Saint-Christophe',
	'FR02816' => 'Villers-sur-Fère',
	'FR02817' => 'Ville-Savoye',
	'FR02818' => 'Villiers-Saint-Denis',
	'FR02819' => 'Vincy-Reuil-et-Magny',
	'FR02820' => 'Viry-Noureuil',
	'FR02821' => 'Vivaise',
	'FR02822' => 'Vivières',
	'FR02823' => 'Voharies',
	'FR02824' => 'Vorges',
	'FR02826' => 'Voulpaix',
	'FR02827' => 'Voyenne',
	'FR02828' => 'Vregny',
	'FR02829' => 'Vuillery',
	'FR02830' => 'Wassigny',
	'FR02831' => 'Watigny',
	'FR02832' => 'Wiège-Faty',
	'FR02833' => 'Wimy',
	'FR02834' => 'Wissignicourt',
	'FR03001' => 'Abrest',
	'FR03002' => 'Agonges',
	'FR03003' => 'Ainay-le-Château',
	'FR03004' => 'Andelaroche',
	'FR03005' => 'Archignat',
	'FR03006' => 'Arfeuilles',
	'FR03007' => 'Arpheuilles-Saint-Priest',
	'FR03008' => 'Arronnes',
	'FR03009' => 'Aubigny',
	'FR03010' => 'Audes',
	'FR03011' => 'Aurouër',
	'FR03012' => 'Autry-Issards',
	'FR03013' => 'Avermes',
	'FR03014' => 'Avrilly',
	'FR03015' => 'Bagneux',
	'FR03016' => 'Barberier',
	'FR03017' => 'Barrais-Bussolles',
	'FR03018' => 'Bayet',
	'FR03019' => 'Beaulon',
	'FR03020' => 'Beaune-dAllier',
	'FR03021' => 'Bègues',
	'FR03022' => 'Bellenaves',
	'FR03023' => 'Bellerive-sur-Allier',
	'FR03024' => 'Bert',
	'FR03025' => 'Bessay-sur-Allier',
	'FR03026' => 'Besson',
	'FR03027' => 'Bézenet',
	'FR03028' => 'Billezois',
	'FR03029' => 'Billy',
	'FR03030' => 'Biozat',
	'FR03031' => 'Bizeneuille',
	'FR03032' => 'Blomard',
	'FR03033' => 'Bost',
	'FR03034' => 'Boucé',
	'FR03035' => 'Le Bouchaud',
	'FR03036' => 'Bourbon-lArchambault',
	'FR03037' => 'Braize',
	'FR03038' => 'Bransat',
	'FR03039' => 'Bresnay',
	'FR03040' => 'Bressolles',
	'FR03041' => 'Le Brethon',
	'FR03042' => 'Le Breuil',
	'FR03043' => 'Broût-Vernet',
	'FR03044' => 'Brugheas',
	'FR03045' => 'Busset',
	'FR03046' => 'Buxières-les-Mines',
	'FR03047' => 'La Celle',
	'FR03048' => 'Cérilly',
	'FR03049' => 'Cesset',
	'FR03050' => 'La Chabanne',
	'FR03051' => 'Chambérat',
	'FR03052' => 'Chamblet',
	'FR03053' => 'Chantelle',
	'FR03054' => 'Chapeau',
	'FR03055' => 'La Chapelaude',
	'FR03056' => 'La Chapelle',
	'FR03057' => 'La Chapelle-aux-Chasses',
	'FR03058' => 'Chappes',
	'FR03059' => 'Chareil-Cintrat',
	'FR03060' => 'Charmeil',
	'FR03061' => 'Charmes',
	'FR03062' => 'Charroux',
	'FR03063' => 'Chassenard',
	'FR03064' => 'Château-sur-Allier',
	'FR03065' => 'Châtel-de-Neuvre',
	'FR03066' => 'Châtel-Montagne',
	'FR03067' => 'Châtelperron',
	'FR03068' => 'Châtelus',
	'FR03069' => 'Châtillon',
	'FR03070' => 'Chavenon',
	'FR03071' => 'Chavroches',
	'FR03072' => 'Chazemais',
	'FR03073' => 'Chemilly',
	'FR03074' => 'Chevagnes',
	'FR03075' => 'Chezelle',
	'FR03076' => 'Chézy',
	'FR03077' => 'Chirat-lÉglise',
	'FR03078' => 'Chouvigny',
	'FR03079' => 'Cindré',
	'FR03080' => 'Cognat-Lyonne',
	'FR03081' => 'Colombier',
	'FR03082' => 'Commentry',
	'FR03083' => 'Contigny',
	'FR03084' => 'Cosne-dAllier',
	'FR03085' => 'Coulandon',
	'FR03086' => 'Coulanges',
	'FR03087' => 'Couleuvre',
	'FR03088' => 'Courçais',
	'FR03089' => 'Coutansouze',
	'FR03090' => 'Couzon',
	'FR03091' => 'Créchy',
	'FR03092' => 'Cressanges',
	'FR03093' => 'Creuzier-le-Neuf',
	'FR03094' => 'Creuzier-le-Vieux',
	'FR03095' => 'Cusset',
	'FR03096' => 'Deneuille-lès-Chantelle',
	'FR03097' => 'Deneuille-les-Mines',
	'FR03098' => 'Désertines',
	'FR03099' => 'Deux-Chaises',
	'FR03100' => 'Diou',
	'FR03101' => 'Domérat',
	'FR03102' => 'Dompierre-sur-Besbre',
	'FR03103' => 'Le Donjon',
	'FR03104' => 'Doyet',
	'FR03105' => 'Droiturier',
	'FR03106' => 'Durdat-Larequille',
	'FR03107' => 'Ébreuil',
	'FR03108' => 'Échassières',
	'FR03109' => 'Escurolles',
	'FR03110' => 'Espinasse-Vozelle',
	'FR03111' => 'Estivareilles',
	'FR03112' => 'Étroussat',
	'FR03113' => 'Ferrières-sur-Sichon',
	'FR03114' => 'La Ferté-Hauterive',
	'FR03115' => 'Fleuriel',
	'FR03116' => 'Fourilles',
	'FR03117' => 'Franchesse',
	'FR03118' => 'Gannat',
	'FR03119' => 'Gannay-sur-Loire',
	'FR03120' => 'Garnat-sur-Engièvre',
	'FR03121' => 'Gennetines',
	'FR03122' => 'Gipcy',
	'FR03124' => 'Gouise',
	'FR03125' => 'La Guillermie',
	'FR03126' => 'Hauterive',
	'FR03127' => 'Hérisson',
	'FR03128' => 'Huriel',
	'FR03129' => 'Hyds',
	'FR03130' => 'Isle-et-Bardais',
	'FR03131' => 'Isserpent',
	'FR03132' => 'Jaligny-sur-Besbre',
	'FR03133' => 'Jenzat',
	'FR03134' => 'Laféline',
	'FR03135' => 'Lalizolle',
	'FR03136' => 'Lamaids',
	'FR03137' => 'Langy',
	'FR03138' => 'Lapalisse',
	'FR03139' => 'Laprugne',
	'FR03140' => 'Lavault-Sainte-Anne',
	'FR03141' => 'Lavoine',
	'FR03142' => 'Lenax',
	'FR03143' => 'Lételon',
	'FR03144' => 'Liernolles',
	'FR03145' => 'Lignerolles',
	'FR03146' => 'Limoise',
	'FR03147' => 'Loddes',
	'FR03148' => 'Loriges',
	'FR03149' => 'Louchy-Montfand',
	'FR03150' => 'Louroux-Bourbonnais',
	'FR03151' => 'Louroux-de-Beaune',
	'FR03152' => 'Louroux-de-Bouble',
	'FR03154' => 'Luneau',
	'FR03155' => 'Lurcy-Lévis',
	'FR03156' => 'Lusigny',
	'FR03157' => 'Magnet',
	'FR03158' => 'Haut-Bocage',
	'FR03159' => 'Malicorne',
	'FR03160' => 'Marcenat',
	'FR03161' => 'Marcillat-en-Combraille',
	'FR03162' => 'Marigny',
	'FR03163' => 'Mariol',
	'FR03164' => 'Le Mayet-dÉcole',
	'FR03165' => 'Le Mayet-de-Montagne',
	'FR03166' => 'Mazerier',
	'FR03167' => 'Mazirat',
	'FR03168' => 'Meaulne-Vitray',
	'FR03169' => 'Meillard',
	'FR03170' => 'Meillers',
	'FR03171' => 'Mercy',
	'FR03172' => 'Mesples',
	'FR03173' => 'Molinet',
	'FR03174' => 'Molles',
	'FR03175' => 'Monestier',
	'FR03176' => 'Monétay-sur-Allier',
	'FR03177' => 'Monétay-sur-Loire',
	'FR03178' => 'Montaiguët-en-Forez',
	'FR03179' => 'Montaigu-le-Blin',
	'FR03180' => 'Montbeugny',
	'FR03181' => 'Montcombroux-les-Mines',
	'FR03182' => 'Monteignet-sur-lAndelot',
	'FR03183' => 'Le Montet',
	'FR03184' => 'Montilly',
	'FR03185' => 'Montluçon',
	'FR03186' => 'Montmarault',
	'FR03187' => 'Montoldre',
	'FR03188' => 'Montord',
	'FR03189' => 'Montvicq',
	'FR03190' => 'Moulins',
	'FR03191' => 'Murat',
	'FR03192' => 'Nades',
	'FR03193' => 'Nassigny',
	'FR03194' => 'Naves',
	'FR03195' => 'Néris-les-Bains',
	'FR03196' => 'Neuilly-en-Donjon',
	'FR03197' => 'Neuilly-le-Réal',
	'FR03198' => 'Neure',
	'FR03200' => 'Neuvy',
	'FR03201' => 'Nizerolles',
	'FR03202' => 'Noyant-dAllier',
	'FR03203' => 'Paray-le-Frésil',
	'FR03204' => 'Paray-sous-Briailles',
	'FR03205' => 'Périgny',
	'FR03206' => 'La Petite-Marche',
	'FR03207' => 'Pierrefitte-sur-Loire',
	'FR03208' => 'Le Pin',
	'FR03209' => 'Poëzat',
	'FR03210' => 'Pouzy-Mésangy',
	'FR03211' => 'Prémilhat',
	'FR03212' => 'Quinssaines',
	'FR03213' => 'Reugny',
	'FR03214' => 'Rocles',
	'FR03215' => 'Rongères',
	'FR03216' => 'Ronnet',
	'FR03217' => 'Saint-Angel',
	'FR03218' => 'Saint-Aubin-le-Monial',
	'FR03219' => 'Saint-Bonnet-de-Four',
	'FR03220' => 'Saint-Bonnet-de-Rochefort',
	'FR03221' => 'Saint-Bonnet-Tronçais',
	'FR03222' => 'Saint-Caprais',
	'FR03223' => 'Saint-Christophe',
	'FR03224' => 'Saint-Clément',
	'FR03225' => 'Saint-Désiré',
	'FR03226' => 'Saint-Didier-en-Donjon',
	'FR03227' => 'Saint-Didier-la-Forêt',
	'FR03228' => 'Saint-Éloy-dAllier',
	'FR03229' => 'Saint-Ennemond',
	'FR03230' => 'Saint-Étienne-de-Vicq',
	'FR03231' => 'Saint-Fargeol',
	'FR03232' => 'Saint-Félix',
	'FR03233' => 'Saint-Genest',
	'FR03234' => 'Saint-Gérand-de-Vaux',
	'FR03235' => 'Saint-Gérand-le-Puy',
	'FR03236' => 'Saint-Germain-des-Fossés',
	'FR03237' => 'Saint-Germain-de-Salles',
	'FR03238' => 'Saint-Hilaire',
	'FR03239' => 'Saint-Léger-sur-Vouzance',
	'FR03240' => 'Saint-Léon',
	'FR03241' => 'Saint-Léopardin-dAugy',
	'FR03242' => 'Saint-Loup',
	'FR03243' => 'Saint-Marcel-en-Murat',
	'FR03244' => 'Saint-Marcel-en-Marcillat',
	'FR03245' => 'Saint-Martin-des-Lais',
	'FR03246' => 'Saint-Martinien',
	'FR03247' => 'Saint-Menoux',
	'FR03248' => 'Saint-Nicolas-des-Biefs',
	'FR03249' => 'Saint-Palais',
	'FR03250' => 'Saint-Pierre-Laval',
	'FR03251' => 'Saint-Plaisir',
	'FR03252' => 'Saint-Pont',
	'FR03253' => 'Saint-Pourçain-sur-Besbre',
	'FR03254' => 'Saint-Pourçain-sur-Sioule',
	'FR03255' => 'Saint-Priest-dAndelot',
	'FR03256' => 'Saint-Priest-en-Murat',
	'FR03257' => 'Saint-Prix',
	'FR03258' => 'Saint-Rémy-en-Rollat',
	'FR03259' => 'Saint-Sauvier',
	'FR03260' => 'Saint-Sornin',
	'FR03261' => 'Sainte-Thérence',
	'FR03262' => 'Saint-Victor',
	'FR03263' => 'Saint-Voir',
	'FR03264' => 'Saint-Yorre',
	'FR03265' => 'Saligny-sur-Roudon',
	'FR03266' => 'Sanssat',
	'FR03267' => 'Saulcet',
	'FR03268' => 'Saulzet',
	'FR03269' => 'Sauvagny',
	'FR03270' => 'Sazeret',
	'FR03271' => 'Serbannes',
	'FR03272' => 'Servilly',
	'FR03273' => 'Seuillet',
	'FR03274' => 'Sorbier',
	'FR03275' => 'Souvigny',
	'FR03276' => 'Sussat',
	'FR03277' => 'Target',
	'FR03278' => 'Taxat-Senat',
	'FR03279' => 'Teillet-Argenty',
	'FR03280' => 'Terjat',
	'FR03281' => 'Le Theil',
	'FR03282' => 'Theneuille',
	'FR03283' => 'Thiel-sur-Acolin',
	'FR03284' => 'Thionne',
	'FR03285' => 'Tortezais',
	'FR03286' => 'Toulon-sur-Allier',
	'FR03287' => 'Treban',
	'FR03288' => 'Treignat',
	'FR03289' => 'Treteau',
	'FR03290' => 'Trévol',
	'FR03291' => 'Trézelles',
	'FR03292' => 'Tronget',
	'FR03293' => 'Urçay',
	'FR03294' => 'Ussel-dAllier',
	'FR03295' => 'Valignat',
	'FR03296' => 'Valigny',
	'FR03297' => 'Vallon-en-Sully',
	'FR03298' => 'Varennes-sur-Allier',
	'FR03299' => 'Varennes-sur-Tèche',
	'FR03300' => 'Vaumas',
	'FR03301' => 'Vaux',
	'FR03302' => 'Veauce',
	'FR03303' => 'Venas',
	'FR03304' => 'Vendat',
	'FR03305' => 'Verneix',
	'FR03306' => 'Le Vernet',
	'FR03307' => 'Verneuil-en-Bourbonnais',
	'FR03308' => 'Vernusse',
	'FR03309' => 'Le Veurdre',
	'FR03310' => 'Vichy',
	'FR03311' => 'Vicq',
	'FR03312' => 'Vieure',
	'FR03313' => 'Le Vilhain',
	'FR03314' => 'Villebret',
	'FR03315' => 'Villefranche-dAllier',
	'FR03316' => 'Villeneuve-sur-Allier',
	'FR03317' => 'Viplaix',
	'FR03319' => 'Voussac',
	'FR03320' => 'Ygrande',
	'FR03321' => 'Yzeure',
	'FR04001' => 'Aiglun',
	'FR04004' => 'Allemagne-en-Provence',
	'FR04005' => 'Allons',
	'FR04006' => 'Allos',
	'FR04007' => 'Angles',
	'FR04008' => 'Annot',
	'FR04009' => 'Archail',
	'FR04012' => 'Aubenas-les-Alpes',
	'FR04013' => 'Aubignosc',
	'FR04016' => 'Authon',
	'FR04017' => 'Auzet',
	'FR04018' => 'Banon',
	'FR04019' => 'Barcelonnette',
	'FR04020' => 'Barles',
	'FR04021' => 'Barras',
	'FR04022' => 'Barrême',
	'FR04023' => 'Bayons',
	'FR04024' => 'Beaujeu',
	'FR04025' => 'Beauvezer',
	'FR04026' => 'Bellaffaire',
	'FR04027' => 'Bevons',
	'FR04028' => 'Beynes',
	'FR04030' => 'Blieux',
	'FR04031' => 'Bras-dAsse',
	'FR04032' => 'Braux',
	'FR04033' => 'Ubaye-Serre-Ponçon',
	'FR04034' => 'La Brillanne',
	'FR04035' => 'Brunet',
	'FR04036' => 'Le Brusquet',
	'FR04037' => 'Le Caire',
	'FR04039' => 'Castellane',
	'FR04040' => 'Le Castellard-Mélan',
	'FR04041' => 'Le Castellet',
	'FR04042' => 'Castellet-lès-Sausses',
	'FR04043' => 'Val-de-Chalvagne',
	'FR04045' => 'Céreste',
	'FR04046' => 'Le Chaffaut-Saint-Jurson',
	'FR04047' => 'Champtercier',
	'FR04049' => 'Château-Arnoux-Saint-Auban',
	'FR04050' => 'Châteaufort',
	'FR04051' => 'Châteauneuf-Miravail',
	'FR04053' => 'Châteauneuf-Val-Saint-Donat',
	'FR04054' => 'Châteauredon',
	'FR04055' => 'Chaudon-Norante',
	'FR04057' => 'Clamensane',
	'FR04058' => 'Claret',
	'FR04059' => 'Clumanc',
	'FR04061' => 'Colmars',
	'FR04062' => 'La Condamine-Châtelard',
	'FR04063' => 'Corbières-en-Provence',
	'FR04065' => 'Cruis',
	'FR04066' => 'Curbans',
	'FR04067' => 'Curel',
	'FR04068' => 'Dauphin',
	'FR04069' => 'Demandolx',
	'FR04070' => 'Digne-les-Bains',
	'FR04072' => 'Draix',
	'FR04073' => 'Enchastrayes',
	'FR04074' => 'Entrages',
	'FR04075' => 'Entrepierres',
	'FR04076' => 'Entrevaux',
	'FR04077' => 'Entrevennes',
	'FR04079' => 'LEscale',
	'FR04081' => 'Esparron-de-Verdon',
	'FR04084' => 'Estoublon',
	'FR04085' => 'Faucon-du-Caire',
	'FR04086' => 'Faucon-de-Barcelonnette',
	'FR04087' => 'Fontienne',
	'FR04088' => 'Forcalquier',
	'FR04090' => 'Le Fugeret',
	'FR04091' => 'Ganagobie',
	'FR04092' => 'La Garde',
	'FR04093' => 'Gigors',
	'FR04094' => 'Gréoux-les-Bains',
	'FR04095' => 'LHospitalet',
	'FR04096' => 'Jausiers',
	'FR04097' => 'La Javie',
	'FR04099' => 'Lambruisse',
	'FR04101' => 'Lardiers',
	'FR04102' => 'Le Lauzet-Ubaye',
	'FR04104' => 'Limans',
	'FR04106' => 'Lurs',
	'FR04107' => 'Majastres',
	'FR04108' => 'Malijai',
	'FR04109' => 'Mallefougasse-Augès',
	'FR04110' => 'Mallemoisson',
	'FR04111' => 'Mane',
	'FR04112' => 'Manosque',
	'FR04113' => 'Marcoux',
	'FR04115' => 'Méailles',
	'FR04116' => 'Les Mées',
	'FR04118' => 'Melve',
	'FR04120' => 'Val dOronaye',
	'FR04121' => 'Mézel',
	'FR04122' => 'Mirabeau',
	'FR04123' => 'Mison',
	'FR04124' => 'Montagnac-Montpezat',
	'FR04126' => 'Montclar',
	'FR04127' => 'Montfort',
	'FR04128' => 'Montfuron',
	'FR04129' => 'Montjustin',
	'FR04130' => 'Montlaux',
	'FR04132' => 'Montsalier',
	'FR04133' => 'Moriez',
	'FR04134' => 'La Motte-du-Caire',
	'FR04135' => 'Moustiers-Sainte-Marie',
	'FR04136' => 'La Mure-Argens',
	'FR04137' => 'Nibles',
	'FR04138' => 'Niozelles',
	'FR04139' => 'Noyers-sur-Jabron',
	'FR04140' => 'Les Omergues',
	'FR04141' => 'Ongles',
	'FR04142' => 'Oppedette',
	'FR04143' => 'Oraison',
	'FR04144' => 'La Palud-sur-Verdon',
	'FR04145' => 'Peipin',
	'FR04148' => 'Peyroules',
	'FR04149' => 'Peyruis',
	'FR04150' => 'Piégut',
	'FR04151' => 'Pierrerue',
	'FR04152' => 'Pierrevert',
	'FR04154' => 'Pontis',
	'FR04155' => 'Prads-Haute-Bléone',
	'FR04156' => 'Puimichel',
	'FR04157' => 'Puimoisson',
	'FR04158' => 'Quinson',
	'FR04159' => 'Redortiers',
	'FR04160' => 'Reillanne',
	'FR04161' => 'Méolans-Revel',
	'FR04162' => 'Revest-des-Brousses',
	'FR04163' => 'Revest-du-Bion',
	'FR04164' => 'Revest-Saint-Martin',
	'FR04166' => 'Riez',
	'FR04167' => 'La Robine-sur-Galabre',
	'FR04169' => 'La Rochegiron',
	'FR04170' => 'La Rochette',
	'FR04171' => 'Rougon',
	'FR04172' => 'Roumoules',
	'FR04173' => 'Saint-André-les-Alpes',
	'FR04174' => 'Saint-Benoît',
	'FR04175' => 'Sainte-Croix-à-Lauze',
	'FR04176' => 'Sainte-Croix-du-Verdon',
	'FR04177' => 'Hautes-Duyes',
	'FR04178' => 'Saint-Étienne-les-Orgues',
	'FR04179' => 'Saint-Geniez',
	'FR04180' => 'Saint-Jacques',
	'FR04181' => 'Saint-Jeannet',
	'FR04182' => 'Saint-Julien-dAsse',
	'FR04183' => 'Saint-Julien-du-Verdon',
	'FR04184' => 'Saint-Jurs',
	'FR04186' => 'Saint-Laurent-du-Verdon',
	'FR04187' => 'Saint-Lions',
	'FR04188' => 'Saint-Maime',
	'FR04189' => 'Saint-Martin-de-Brômes',
	'FR04190' => 'Saint-Martin-les-Eaux',
	'FR04191' => 'Saint-Martin-lès-Seyne',
	'FR04192' => 'Saint-Michel-lObservatoire',
	'FR04193' => 'Saint-Paul-sur-Ubaye',
	'FR04194' => 'Saint-Pierre',
	'FR04195' => 'Saint-Pons',
	'FR04197' => 'Sainte-Tulle',
	'FR04199' => 'Saint-Vincent-sur-Jabron',
	'FR04200' => 'Salignac',
	'FR04201' => 'Saumane',
	'FR04202' => 'Sausses',
	'FR04203' => 'Selonnet',
	'FR04204' => 'Senez',
	'FR04205' => 'Seyne',
	'FR04206' => 'Sigonce',
	'FR04207' => 'Sigoyer',
	'FR04208' => 'Simiane-la-Rotonde',
	'FR04209' => 'Sisteron',
	'FR04210' => 'Soleilhas',
	'FR04211' => 'Sourribes',
	'FR04214' => 'Tartonne',
	'FR04216' => 'Thèze',
	'FR04217' => 'Thoard',
	'FR04218' => 'Thorame-Basse',
	'FR04219' => 'Thorame-Haute',
	'FR04220' => 'Les Thuiles',
	'FR04222' => 'Turriers',
	'FR04224' => 'Ubraye',
	'FR04226' => 'Uvernet-Fours',
	'FR04227' => 'Vachères',
	'FR04228' => 'Valavoire',
	'FR04229' => 'Valbelle',
	'FR04230' => 'Valensole',
	'FR04231' => 'Valernes',
	'FR04233' => 'Vaumeilh',
	'FR04234' => 'Venterol',
	'FR04235' => 'Verdaches',
	'FR04236' => 'Vergons',
	'FR04237' => 'Le Vernet',
	'FR04240' => 'Villars-Colmars',
	'FR04241' => 'Villemus',
	'FR04242' => 'Villeneuve',
	'FR04244' => 'Volonne',
	'FR04245' => 'Volx',
	'FR05001' => 'Abriès-Ristolas',
	'FR05003' => 'Aiguilles',
	'FR05004' => 'Ancelle',
	'FR05006' => 'LArgentière-la-Bessée',
	'FR05007' => 'Arvieux',
	'FR05008' => 'Aspremont',
	'FR05009' => 'Aspres-lès-Corps',
	'FR05010' => 'Aspres-sur-Buëch',
	'FR05011' => 'Avançon',
	'FR05012' => 'Baratier',
	'FR05013' => 'Barcillonnette',
	'FR05014' => 'Barret-sur-Méouge',
	'FR05016' => 'La Bâtie-Montsaléon',
	'FR05017' => 'La Bâtie-Neuve',
	'FR05018' => 'La Bâtie-Vieille',
	'FR05019' => 'La Beaume',
	'FR05021' => 'Le Bersac',
	'FR05022' => 'Bréziers',
	'FR05023' => 'Briançon',
	'FR05024' => 'Valdoule',
	'FR05025' => 'Buissard',
	'FR05026' => 'Ceillac',
	'FR05027' => 'Cervières',
	'FR05028' => 'Chabestan',
	'FR05029' => 'Chabottes',
	'FR05031' => 'Champcella',
	'FR05032' => 'Champoléon',
	'FR05033' => 'Chanousse',
	'FR05035' => 'Châteauneuf-dOze',
	'FR05036' => 'Châteauroux-les-Alpes',
	'FR05037' => 'Châteauvieux',
	'FR05038' => 'Château-Ville-Vieille',
	'FR05039' => 'Aubessagne',
	'FR05040' => 'Chorges',
	'FR05044' => 'Crévoux',
	'FR05045' => 'Crots',
	'FR05046' => 'Embrun',
	'FR05047' => 'Éourres',
	'FR05048' => 'LÉpine',
	'FR05049' => 'Esparron',
	'FR05050' => 'Espinasses',
	'FR05051' => 'Étoile-Saint-Cyrice',
	'FR05052' => 'Eygliers',
	'FR05053' => 'Garde-Colombe',
	'FR05054' => 'La Fare-en-Champsaur',
	'FR05055' => 'La Faurie',
	'FR05056' => 'Forest-Saint-Julien',
	'FR05057' => 'Fouillouse',
	'FR05058' => 'Freissinières',
	'FR05059' => 'La Freissinouse',
	'FR05060' => 'Furmeyer',
	'FR05061' => 'Gap',
	'FR05062' => 'Le Glaizil',
	'FR05063' => 'La Grave',
	'FR05064' => 'La Chapelle-en-Valgaudémar',
	'FR05065' => 'Guillestre',
	'FR05066' => 'La Haute-Beaume',
	'FR05068' => 'Jarjayes',
	'FR05070' => 'Laragne-Montéglin',
	'FR05071' => 'Lardier-et-Valença',
	'FR05072' => 'Laye',
	'FR05073' => 'Lazer',
	'FR05074' => 'Lettret',
	'FR05075' => 'Manteyer',
	'FR05076' => 'Méreuil',
	'FR05077' => 'Molines-en-Queyras',
	'FR05078' => 'Monêtier-Allemont',
	'FR05079' => 'Le Monêtier-les-Bains',
	'FR05080' => 'Montbrand',
	'FR05081' => 'Montclus',
	'FR05082' => 'Mont-Dauphin',
	'FR05084' => 'Montgardin',
	'FR05085' => 'Montgenèvre',
	'FR05086' => 'Montjay',
	'FR05087' => 'Montmaur',
	'FR05089' => 'Montrond',
	'FR05090' => 'La Motte-en-Champsaur',
	'FR05091' => 'Moydans',
	'FR05092' => 'Neffes',
	'FR05093' => 'Névache',
	'FR05094' => 'Nossage-et-Bénévent',
	'FR05095' => 'Le Noyer',
	'FR05096' => 'Orcières',
	'FR05097' => 'Orpierre',
	'FR05098' => 'Les Orres',
	'FR05099' => 'Oze',
	'FR05100' => 'Pelleautier',
	'FR05101' => 'Vallouise-Pelvoux',
	'FR05102' => 'La Piarre',
	'FR05103' => 'Le Poët',
	'FR05104' => 'Poligny',
	'FR05106' => 'Prunières',
	'FR05107' => 'Puy-Saint-André',
	'FR05108' => 'Puy-Saint-Eusèbe',
	'FR05109' => 'Puy-Saint-Pierre',
	'FR05110' => 'Puy-Saint-Vincent',
	'FR05111' => 'Puy-Sanières',
	'FR05112' => 'Rabou',
	'FR05113' => 'Rambaud',
	'FR05114' => 'Réallon',
	'FR05115' => 'Remollon',
	'FR05116' => 'Réotier',
	'FR05117' => 'Ribeyret',
	'FR05118' => 'Val Buëch-Méouge',
	'FR05119' => 'Risoul',
	'FR05121' => 'Rochebrune',
	'FR05122' => 'La Roche-de-Rame',
	'FR05123' => 'La Roche-des-Arnauds',
	'FR05124' => 'La Rochette',
	'FR05126' => 'Rosans',
	'FR05127' => 'Rousset',
	'FR05128' => 'Saint-André-dEmbrun',
	'FR05129' => 'Saint-André-de-Rosans',
	'FR05130' => 'Saint-Apollinaire',
	'FR05131' => 'Saint-Auban-dOze',
	'FR05132' => 'Saint-Bonnet-en-Champsaur',
	'FR05133' => 'Saint-Chaffrey',
	'FR05134' => 'Saint-Clément-sur-Durance',
	'FR05135' => 'Sainte-Colombe',
	'FR05136' => 'Saint-Crépin',
	'FR05139' => 'Dévoluy',
	'FR05140' => 'Saint-Étienne-le-Laus',
	'FR05142' => 'Saint-Firmin',
	'FR05144' => 'Saint-Jacques-en-Valgodemard',
	'FR05145' => 'Saint-Jean-Saint-Nicolas',
	'FR05146' => 'Saint-Julien-en-Beauchêne',
	'FR05147' => 'Saint-Julien-en-Champsaur',
	'FR05148' => 'Saint-Laurent-du-Cros',
	'FR05149' => 'Saint-Léger-les-Mélèzes',
	'FR05151' => 'Saint-Martin-de-Queyrières',
	'FR05152' => 'Saint-Maurice-en-Valgodemard',
	'FR05153' => 'Saint-Michel-de-Chaillol',
	'FR05154' => 'Saint-Pierre-dArgençon',
	'FR05155' => 'Saint-Pierre-Avez',
	'FR05156' => 'Saint-Sauveur',
	'FR05157' => 'Saint-Véran',
	'FR05158' => 'Le Saix',
	'FR05159' => 'Saléon',
	'FR05160' => 'Salérans',
	'FR05161' => 'La Salle-les-Alpes',
	'FR05162' => 'La Saulce',
	'FR05163' => 'Le Sauze-du-Lac',
	'FR05164' => 'Savines-le-Lac',
	'FR05165' => 'Savournon',
	'FR05166' => 'Serres',
	'FR05167' => 'Sigottier',
	'FR05168' => 'Sigoyer',
	'FR05169' => 'Sorbiers',
	'FR05170' => 'Tallard',
	'FR05171' => 'Théus',
	'FR05172' => 'Trescléoux',
	'FR05173' => 'Upaix',
	'FR05174' => 'Val-des-Prés',
	'FR05176' => 'Valserres',
	'FR05177' => 'Vars',
	'FR05178' => 'Ventavon',
	'FR05179' => 'Veynes',
	'FR05180' => 'Les Vigneaux',
	'FR05181' => 'Villar-dArêne',
	'FR05182' => 'Villar-Loubière',
	'FR05183' => 'Villar-Saint-Pancrace',
	'FR05184' => 'Vitrolles',
	'FR06001' => 'Aiglun',
	'FR06002' => 'Amirat',
	'FR06003' => 'Andon',
	'FR06004' => 'Antibes',
	'FR06005' => 'Ascros',
	'FR06006' => 'Aspremont',
	'FR06007' => 'Auribeau-sur-Siagne',
	'FR06008' => 'Auvare',
	'FR06009' => 'Bairols',
	'FR06010' => 'Le Bar-sur-Loup',
	'FR06011' => 'Beaulieu-sur-Mer',
	'FR06012' => 'Beausoleil',
	'FR06013' => 'Belvédère',
	'FR06014' => 'Bendejun',
	'FR06015' => 'Berre-les-Alpes',
	'FR06016' => 'Beuil',
	'FR06017' => 'Bézaudun-les-Alpes',
	'FR06018' => 'Biot',
	'FR06019' => 'Blausasc',
	'FR06020' => 'La Bollène-Vésubie',
	'FR06021' => 'Bonson',
	'FR06022' => 'Bouyon',
	'FR06023' => 'Breil-sur-Roya',
	'FR06024' => 'Briançonnet',
	'FR06025' => 'Le Broc',
	'FR06026' => 'Cabris',
	'FR06027' => 'Cagnes-sur-Mer',
	'FR06028' => 'Caille',
	'FR06029' => 'Cannes',
	'FR06030' => 'Le Cannet',
	'FR06031' => 'Cantaron',
	'FR06032' => 'Cap-dAil',
	'FR06033' => 'Carros',
	'FR06034' => 'Castagniers',
	'FR06035' => 'Castellar',
	'FR06036' => 'Castillon',
	'FR06037' => 'Caussols',
	'FR06038' => 'Châteauneuf-Grasse',
	'FR06039' => 'Châteauneuf-Villevieille',
	'FR06040' => 'Châteauneuf-dEntraunes',
	'FR06041' => 'Cipières',
	'FR06042' => 'Clans',
	'FR06043' => 'Coaraze',
	'FR06044' => 'La Colle-sur-Loup',
	'FR06045' => 'Collongues',
	'FR06046' => 'Colomars',
	'FR06047' => 'Conségudes',
	'FR06048' => 'Contes',
	'FR06049' => 'Courmes',
	'FR06050' => 'Coursegoules',
	'FR06051' => 'La Croix-sur-Roudoule',
	'FR06052' => 'Cuébris',
	'FR06053' => 'Daluis',
	'FR06054' => 'Drap',
	'FR06055' => 'Duranus',
	'FR06056' => 'Entraunes',
	'FR06057' => 'LEscarène',
	'FR06058' => 'Escragnolles',
	'FR06059' => 'Èze',
	'FR06060' => 'Falicon',
	'FR06061' => 'Les Ferres',
	'FR06062' => 'Fontan',
	'FR06063' => 'Gars',
	'FR06064' => 'Gattières',
	'FR06065' => 'La Gaude',
	'FR06066' => 'Gilette',
	'FR06067' => 'Gorbio',
	'FR06068' => 'Gourdon',
	'FR06069' => 'Grasse',
	'FR06070' => 'Gréolières',
	'FR06071' => 'Guillaumes',
	'FR06072' => 'Ilonse',
	'FR06073' => 'Isola',
	'FR06074' => 'Lantosque',
	'FR06075' => 'Levens',
	'FR06076' => 'Lieuche',
	'FR06077' => 'Lucéram',
	'FR06078' => 'Malaussène',
	'FR06079' => 'Mandelieu-la-Napoule',
	'FR06080' => 'Marie',
	'FR06081' => 'Le Mas',
	'FR06082' => 'Massoins',
	'FR06083' => 'Menton',
	'FR06084' => 'Mouans-Sartoux',
	'FR06085' => 'Mougins',
	'FR06086' => 'Moulinet',
	'FR06087' => 'Les Mujouls',
	'FR06088' => 'Nice',
	'FR06089' => 'Opio',
	'FR06090' => 'Pégomas',
	'FR06091' => 'Peille',
	'FR06092' => 'Peillon',
	'FR06093' => 'La Penne',
	'FR06094' => 'Péone',
	'FR06095' => 'Peymeinade',
	'FR06096' => 'Pierlas',
	'FR06097' => 'Pierrefeu',
	'FR06098' => 'Puget-Rostang',
	'FR06099' => 'Puget-Théniers',
	'FR06100' => 'Revest-les-Roches',
	'FR06101' => 'Rigaud',
	'FR06102' => 'Rimplas',
	'FR06103' => 'Roquebillière',
	'FR06104' => 'Roquebrune-Cap-Martin',
	'FR06105' => 'Roquefort-les-Pins',
	'FR06106' => 'Roquestéron',
	'FR06107' => 'La Roque-en-Provence',
	'FR06108' => 'La Roquette-sur-Siagne',
	'FR06109' => 'La Roquette-sur-Var',
	'FR06110' => 'Roubion',
	'FR06111' => 'Roure',
	'FR06112' => 'Le Rouret',
	'FR06113' => 'Sainte-Agnès',
	'FR06114' => 'Saint-André-de-la-Roche',
	'FR06115' => 'Saint-Antonin',
	'FR06116' => 'Saint-Auban',
	'FR06117' => 'Saint-Blaise',
	'FR06118' => 'Saint-Cézaire-sur-Siagne',
	'FR06119' => 'Saint-Dalmas-le-Selvage',
	'FR06120' => 'Saint-Étienne-de-Tinée',
	'FR06121' => 'Saint-Jean-Cap-Ferrat',
	'FR06122' => 'Saint-Jeannet',
	'FR06123' => 'Saint-Laurent-du-Var',
	'FR06124' => 'Saint-Léger',
	'FR06125' => 'Saint-Martin-dEntraunes',
	'FR06126' => 'Saint-Martin-du-Var',
	'FR06127' => 'Saint-Martin-Vésubie',
	'FR06128' => 'Saint-Paul-de-Vence',
	'FR06129' => 'Saint-Sauveur-sur-Tinée',
	'FR06130' => 'Saint-Vallier-de-Thiey',
	'FR06131' => 'Sallagriffon',
	'FR06132' => 'Saorge',
	'FR06133' => 'Sauze',
	'FR06134' => 'Séranon',
	'FR06135' => 'Sigale',
	'FR06136' => 'Sospel',
	'FR06137' => 'Spéracèdes',
	'FR06138' => 'Théoule-sur-Mer',
	'FR06139' => 'Thiéry',
	'FR06140' => 'Le Tignet',
	'FR06141' => 'Toudon',
	'FR06142' => 'Touët-de-lEscarène',
	'FR06143' => 'Touët-sur-Var',
	'FR06144' => 'La Tour',
	'FR06145' => 'Tourette-du-Château',
	'FR06146' => 'Tournefort',
	'FR06147' => 'Tourrette-Levens',
	'FR06148' => 'Tourrettes-sur-Loup',
	'FR06149' => 'La Trinité',
	'FR06150' => 'La Turbie',
	'FR06151' => 'Utelle',
	'FR06152' => 'Valbonne',
	'FR06153' => 'Valdeblore',
	'FR06154' => 'Valderoure',
	'FR06155' => 'Vallauris',
	'FR06156' => 'Venanson',
	'FR06157' => 'Vence',
	'FR06158' => 'Villars-sur-Var',
	'FR06159' => 'Villefranche-sur-Mer',
	'FR06160' => 'Villeneuve-dEntraunes',
	'FR06161' => 'Villeneuve-Loubet',
	'FR06162' => 'La Brigue',
	'FR06163' => 'Tende',
	'FR07001' => 'Accons',
	'FR07002' => 'Ailhon',
	'FR07003' => 'Aizac',
	'FR07004' => 'Ajoux',
	'FR07005' => 'Alba-la-Romaine',
	'FR07006' => 'Albon-dArdèche',
	'FR07007' => 'Alboussière',
	'FR07008' => 'Alissas',
	'FR07009' => 'Andance',
	'FR07010' => 'Annonay',
	'FR07011' => 'Vallées-dAntraigues-Asperjoc',
	'FR07012' => 'Arcens',
	'FR07013' => 'Ardoix',
	'FR07014' => 'Arlebosc',
	'FR07015' => 'Arras-sur-Rhône',
	'FR07017' => 'Les Assions',
	'FR07018' => 'Astet',
	'FR07019' => 'Aubenas',
	'FR07020' => 'Aubignas',
	'FR07022' => 'Baix',
	'FR07023' => 'Balazuc',
	'FR07024' => 'Banne',
	'FR07025' => 'Barnas',
	'FR07026' => 'Le Béage',
	'FR07027' => 'Beauchastel',
	'FR07028' => 'Beaulieu',
	'FR07029' => 'Beaumont',
	'FR07030' => 'Beauvène',
	'FR07031' => 'Berrias-et-Casteljau',
	'FR07032' => 'Berzème',
	'FR07033' => 'Bessas',
	'FR07034' => 'Bidon',
	'FR07035' => 'Boffres',
	'FR07036' => 'Bogy',
	'FR07037' => 'Borée',
	'FR07038' => 'Borne',
	'FR07039' => 'Bozas',
	'FR07040' => 'Boucieu-le-Roi',
	'FR07041' => 'Boulieu-lès-Annonay',
	'FR07042' => 'Bourg-Saint-Andéol',
	'FR07044' => 'Brossainc',
	'FR07045' => 'Burzet',
	'FR07047' => 'Cellier-du-Luc',
	'FR07048' => 'Chalencon',
	'FR07049' => 'Le Chambon',
	'FR07050' => 'Chambonas',
	'FR07051' => 'Champagne',
	'FR07052' => 'Champis',
	'FR07053' => 'Chandolas',
	'FR07054' => 'Chanéac',
	'FR07055' => 'Charmes-sur-Rhône',
	'FR07056' => 'Charnas',
	'FR07058' => 'Chassiers',
	'FR07059' => 'Châteaubourg',
	'FR07060' => 'Châteauneuf-de-Vernoux',
	'FR07061' => 'Chauzon',
	'FR07062' => 'Chazeaux',
	'FR07063' => 'Cheminas',
	'FR07064' => 'Le Cheylard',
	'FR07065' => 'Chirols',
	'FR07066' => 'Chomérac',
	'FR07067' => 'Colombier-le-Cardinal',
	'FR07068' => 'Colombier-le-Jeune',
	'FR07069' => 'Colombier-le-Vieux',
	'FR07070' => 'Cornas',
	'FR07071' => 'Coucouron',
	'FR07072' => 'Coux',
	'FR07073' => 'Le Crestet',
	'FR07074' => 'Creysseilles',
	'FR07075' => 'Cros-de-Géorand',
	'FR07076' => 'Cruas',
	'FR07077' => 'Darbres',
	'FR07078' => 'Davézieux',
	'FR07079' => 'Désaignes',
	'FR07080' => 'Devesset',
	'FR07081' => 'Dompnac',
	'FR07082' => 'Dornas',
	'FR07083' => 'Dunière-sur-Eyrieux',
	'FR07084' => 'Eclassan',
	'FR07085' => 'Empurany',
	'FR07086' => 'Étables',
	'FR07087' => 'Fabras',
	'FR07088' => 'Faugères',
	'FR07089' => 'Félines',
	'FR07090' => 'Flaviac',
	'FR07091' => 'Fons',
	'FR07092' => 'Freyssenet',
	'FR07093' => 'Genestelle',
	'FR07094' => 'Gilhac-et-Bruzac',
	'FR07095' => 'Gilhoc-sur-Ormèze',
	'FR07096' => 'Gluiras',
	'FR07097' => 'Glun',
	'FR07098' => 'Gourdon',
	'FR07099' => 'Gras',
	'FR07100' => 'Gravières',
	'FR07101' => 'Grospierres',
	'FR07102' => 'Guilherand-Granges',
	'FR07103' => 'Saint-Julien-dIntres',
	'FR07104' => 'Issamoulenc',
	'FR07105' => 'Issanlas',
	'FR07106' => 'Issarlès',
	'FR07107' => 'Jaujac',
	'FR07108' => 'Jaunac',
	'FR07109' => 'Joannas',
	'FR07110' => 'Joyeuse',
	'FR07111' => 'Juvinas',
	'FR07112' => 'Labastide-sur-Bésorgues',
	'FR07113' => 'Labastide-de-Virac',
	'FR07114' => 'Labatie-dAndaure',
	'FR07115' => 'Labeaume',
	'FR07116' => 'Labégude',
	'FR07117' => 'Lablachère',
	'FR07118' => 'Laboule',
	'FR07119' => 'Le Lac-dIssarlès',
	'FR07120' => 'Lachamp-Raphaël',
	'FR07121' => 'Lachapelle-Graillouse',
	'FR07122' => 'Lachapelle-sous-Aubenas',
	'FR07123' => 'Lachapelle-sous-Chanéac',
	'FR07124' => 'Lafarre',
	'FR07126' => 'Lagorce',
	'FR07127' => 'Lalevade-dArdèche',
	'FR07128' => 'Lalouvesc',
	'FR07129' => 'Lamastre',
	'FR07130' => 'Lanarce',
	'FR07131' => 'Lanas',
	'FR07132' => 'Largentière',
	'FR07133' => 'Larnas',
	'FR07134' => 'Laurac-en-Vivarais',
	'FR07136' => 'Laveyrune',
	'FR07137' => 'Lavillatte',
	'FR07138' => 'Lavilledieu',
	'FR07139' => 'Laviolle',
	'FR07140' => 'Lemps',
	'FR07141' => 'Lentillères',
	'FR07142' => 'Lespéron',
	'FR07143' => 'Limony',
	'FR07144' => 'Loubaresse',
	'FR07145' => 'Lussas',
	'FR07146' => 'Lyas',
	'FR07147' => 'Malarce-sur-la-Thines',
	'FR07148' => 'Malbosc',
	'FR07149' => 'Marcols-les-Eaux',
	'FR07150' => 'Mariac',
	'FR07151' => 'Mars',
	'FR07152' => 'Mauves',
	'FR07153' => 'Mayres',
	'FR07154' => 'Mazan-lAbbaye',
	'FR07155' => 'Mercuer',
	'FR07156' => 'Meyras',
	'FR07157' => 'Meysse',
	'FR07158' => 'Mézilhac',
	'FR07159' => 'Mirabel',
	'FR07160' => 'Monestier',
	'FR07161' => 'Montpezat-sous-Bauzon',
	'FR07162' => 'Montréal',
	'FR07163' => 'Montselgues',
	'FR07165' => 'Belsentes',
	'FR07166' => 'Nozières',
	'FR07167' => 'Les Ollières-sur-Eyrieux',
	'FR07168' => 'Orgnac-lAven',
	'FR07169' => 'Ozon',
	'FR07170' => 'Pailharès',
	'FR07171' => 'Payzac',
	'FR07172' => 'Peaugres',
	'FR07173' => 'Péreyres',
	'FR07174' => 'Peyraud',
	'FR07175' => 'Le Plagnal',
	'FR07176' => 'Planzolles',
	'FR07177' => 'Plats',
	'FR07178' => 'Pont-de-Labeaume',
	'FR07179' => 'Pourchères',
	'FR07181' => 'Le Pouzin',
	'FR07182' => 'Prades',
	'FR07183' => 'Pradons',
	'FR07184' => 'Pranles',
	'FR07185' => 'Préaux',
	'FR07186' => 'Privas',
	'FR07187' => 'Prunet',
	'FR07188' => 'Quintenas',
	'FR07189' => 'Ribes',
	'FR07190' => 'Rochecolombe',
	'FR07191' => 'Rochemaure',
	'FR07192' => 'Rochepaule',
	'FR07193' => 'Rocher',
	'FR07194' => 'Rochessauve',
	'FR07195' => 'La Rochette',
	'FR07196' => 'Rocles',
	'FR07197' => 'Roiffieux',
	'FR07198' => 'Rompon',
	'FR07199' => 'Rosières',
	'FR07200' => 'Le Roux',
	'FR07201' => 'Ruoms',
	'FR07202' => 'Sablières',
	'FR07203' => 'Sagnes-et-Goudoulet',
	'FR07204' => 'Saint-Agrève',
	'FR07205' => 'Saint-Alban-dAy',
	'FR07206' => 'Saint-Alban-en-Montagne',
	'FR07207' => 'Saint-Alban-Auriolles',
	'FR07208' => 'Saint-Andéol-de-Berg',
	'FR07209' => 'Saint-Andéol-de-Fourchades',
	'FR07210' => 'Saint-Andéol-de-Vals',
	'FR07211' => 'Saint-André-de-Cruzières',
	'FR07212' => 'Saint-André-en-Vivarais',
	'FR07213' => 'Saint-André-Lachamp',
	'FR07214' => 'Saint-Apollinaire-de-Rias',
	'FR07215' => 'Saint-Barthélemy-le-Meil',
	'FR07216' => 'Saint-Barthélemy-Grozon',
	'FR07217' => 'Saint-Barthélemy-le-Plain',
	'FR07218' => 'Saint-Basile',
	'FR07219' => 'Saint-Bauzile',
	'FR07220' => 'Saint-Christol',
	'FR07221' => 'Saint-Cierge-la-Serre',
	'FR07222' => 'Saint-Cierge-sous-le-Cheylard',
	'FR07223' => 'Saint-Cirgues-de-Prades',
	'FR07224' => 'Saint-Cirgues-en-Montagne',
	'FR07225' => 'Saint-Clair',
	'FR07226' => 'Saint-Clément',
	'FR07227' => 'Saint-Cyr',
	'FR07228' => 'Saint-Désirat',
	'FR07229' => 'Saint-Didier-sous-Aubenas',
	'FR07230' => 'Saint-Étienne-de-Boulogne',
	'FR07231' => 'Saint-Étienne-de-Fontbellon',
	'FR07232' => 'Saint-Étienne-de-Lugdarès',
	'FR07233' => 'Saint-Étienne-de-Serre',
	'FR07234' => 'Saint-Étienne-de-Valoux',
	'FR07235' => 'Sainte-Eulalie',
	'FR07236' => 'Saint-Félicien',
	'FR07237' => 'Saint-Fortunat-sur-Eyrieux',
	'FR07238' => 'Saint-Genest-de-Beauzon',
	'FR07239' => 'Saint-Genest-Lachamp',
	'FR07240' => 'Saint-Georges-les-Bains',
	'FR07241' => 'Saint-Germain',
	'FR07242' => 'Saint-Gineis-en-Coiron',
	'FR07243' => 'Saint-Jacques-dAtticieux',
	'FR07244' => 'Saint-Jean-Chambre',
	'FR07245' => 'Saint-Jean-de-Muzols',
	'FR07247' => 'Saint-Jean-le-Centenier',
	'FR07248' => 'Saint-Jean-Roure',
	'FR07249' => 'Saint-Jeure-dAndaure',
	'FR07250' => 'Saint-Jeure-dAy',
	'FR07251' => 'Saint-Joseph-des-Bancs',
	'FR07253' => 'Saint-Julien-du-Gua',
	'FR07254' => 'Saint-Julien-du-Serre',
	'FR07255' => 'Saint-Julien-en-Saint-Alban',
	'FR07257' => 'Saint-Julien-le-Roux',
	'FR07258' => 'Saint-Julien-Vocance',
	'FR07259' => 'Saint-Just-dArdèche',
	'FR07260' => 'Saint-Lager-Bressac',
	'FR07261' => 'Saint-Laurent-du-Pape',
	'FR07262' => 'Saint-Laurent-les-Bains-Laval-dAurelle',
	'FR07263' => 'Saint-Laurent-sous-Coiron',
	'FR07264' => 'Saint-Marcel-dArdèche',
	'FR07265' => 'Saint-Marcel-lès-Annonay',
	'FR07266' => 'Sainte-Marguerite-Lafigère',
	'FR07267' => 'Saint-Martial',
	'FR07268' => 'Saint-Martin-dArdèche',
	'FR07269' => 'Saint-Martin-de-Valamas',
	'FR07270' => 'Saint-Martin-sur-Lavezon',
	'FR07272' => 'Saint-Maurice-dArdèche',
	'FR07273' => 'Saint-Maurice-dIbie',
	'FR07274' => 'Saint-Maurice-en-Chalencon',
	'FR07275' => 'Saint-Mélany',
	'FR07276' => 'Saint-Michel-dAurance',
	'FR07277' => 'Saint-Michel-de-Boulogne',
	'FR07278' => 'Saint-Michel-de-Chabrillanoux',
	'FR07279' => 'Saint-Montan',
	'FR07280' => 'Saint-Paul-le-Jeune',
	'FR07281' => 'Saint-Péray',
	'FR07282' => 'Saint-Pierre-de-Colombier',
	'FR07283' => 'Saint-Pierre-la-Roche',
	'FR07284' => 'Saint-Pierre-Saint-Jean',
	'FR07285' => 'Saint-Pierre-sur-Doux',
	'FR07286' => 'Saint-Pierreville',
	'FR07287' => 'Saint-Pons',
	'FR07288' => 'Saint-Priest',
	'FR07289' => 'Saint-Privat',
	'FR07290' => 'Saint-Prix',
	'FR07291' => 'Saint-Remèze',
	'FR07292' => 'Saint-Romain-dAy',
	'FR07293' => 'Saint-Romain-de-Lerps',
	'FR07294' => 'Saint-Sauveur-de-Cruzières',
	'FR07295' => 'Saint-Sauveur-de-Montagut',
	'FR07296' => 'Saint-Sernin',
	'FR07297' => 'Saint-Sylvestre',
	'FR07298' => 'Saint-Symphorien-sous-Chomérac',
	'FR07299' => 'Saint-Symphorien-de-Mahun',
	'FR07300' => 'Saint-Thomé',
	'FR07301' => 'Saint-Victor',
	'FR07302' => 'Saint-Vincent-de-Barrès',
	'FR07303' => 'Saint-Vincent-de-Durfort',
	'FR07304' => 'Salavas',
	'FR07305' => 'Les Salelles',
	'FR07306' => 'Sampzon',
	'FR07307' => 'Sanilhac',
	'FR07308' => 'Sarras',
	'FR07309' => 'Satillieu',
	'FR07310' => 'Savas',
	'FR07311' => 'Sceautres',
	'FR07312' => 'Sécheras',
	'FR07313' => 'Serrières',
	'FR07314' => 'Silhac',
	'FR07315' => 'La Souche',
	'FR07316' => 'Soyons',
	'FR07317' => 'Talencieux',
	'FR07318' => 'Tauriers',
	'FR07319' => 'Le Teil',
	'FR07321' => 'Thorrenc',
	'FR07322' => 'Thueyts',
	'FR07323' => 'Toulaud',
	'FR07324' => 'Tournon-sur-Rhône',
	'FR07325' => 'Ucel',
	'FR07326' => 'Usclades-et-Rieutord',
	'FR07327' => 'Uzer',
	'FR07328' => 'Vagnas',
	'FR07329' => 'Valgorge',
	'FR07330' => 'Vallon-Pont-dArc',
	'FR07331' => 'Vals-les-Bains',
	'FR07332' => 'Valvignères',
	'FR07333' => 'Vanosc',
	'FR07334' => 'Les Vans',
	'FR07335' => 'Vaudevant',
	'FR07336' => 'Vernon',
	'FR07337' => 'Vernosc-lès-Annonay',
	'FR07338' => 'Vernoux-en-Vivarais',
	'FR07339' => 'Vesseaux',
	'FR07340' => 'Veyras',
	'FR07341' => 'Villeneuve-de-Berg',
	'FR07342' => 'Villevocance',
	'FR07343' => 'Vinezac',
	'FR07344' => 'Vinzieux',
	'FR07345' => 'Vion',
	'FR07346' => 'Viviers',
	'FR07347' => 'Vocance',
	'FR07348' => 'Vogüé',
	'FR07349' => 'La Voulte-sur-Rhône',
	'FR08001' => 'Acy-Romance',
	'FR08003' => 'Aiglemont',
	'FR08004' => 'Aire',
	'FR08005' => 'Alincourt',
	'FR08006' => 'AllandHuy-et-Sausseuil',
	'FR08008' => 'Amagne',
	'FR08010' => 'Ambly-Fleury',
	'FR08011' => 'Anchamps',
	'FR08013' => 'Angecourt',
	'FR08014' => 'Annelles',
	'FR08015' => 'Antheny',
	'FR08016' => 'Aouste',
	'FR08017' => 'Apremont',
	'FR08018' => 'Ardeuil-et-Montfauxelles',
	'FR08019' => 'Les Grandes-Armoises',
	'FR08020' => 'Les Petites-Armoises',
	'FR08021' => 'Arnicourt',
	'FR08022' => 'Arreux',
	'FR08023' => 'Artaise-le-Vivier',
	'FR08024' => 'Asfeld',
	'FR08025' => 'Attigny',
	'FR08026' => 'Aubigny-les-Pothées',
	'FR08027' => 'Auboncourt-Vauzelles',
	'FR08028' => 'Aubrives',
	'FR08029' => 'Auflance',
	'FR08030' => 'Auge',
	'FR08031' => 'Aure',
	'FR08032' => 'Aussonce',
	'FR08033' => 'Authe',
	'FR08034' => 'Autrecourt-et-Pourron',
	'FR08035' => 'Autruche',
	'FR08036' => 'Autry',
	'FR08037' => 'Auvillers-les-Forges',
	'FR08038' => 'Avançon',
	'FR08039' => 'Avaux',
	'FR08040' => 'Les Ayvelles',
	'FR08041' => 'Baâlons',
	'FR08043' => 'Balan',
	'FR08044' => 'Balham',
	'FR08045' => 'Ballay',
	'FR08046' => 'Banogne-Recouvrance',
	'FR08047' => 'Barbaise',
	'FR08048' => 'Barby',
	'FR08049' => 'Bar-lès-Buzancy',
	'FR08052' => 'Bayonville',
	'FR08053' => 'Bazeilles',
	'FR08055' => 'Beaumont-en-Argonne',
	'FR08056' => 'Beffu-et-le-Morthomme',
	'FR08057' => 'Belleville-et-Châtillon-sur-Bar',
	'FR08058' => 'Belval',
	'FR08059' => 'Belval-Bois-des-Dames',
	'FR08060' => 'Bergnicourt',
	'FR08061' => 'La Berlière',
	'FR08062' => 'Bertoncourt',
	'FR08063' => 'La Besace',
	'FR08064' => 'Biermes',
	'FR08065' => 'Bièvres',
	'FR08066' => 'Bignicourt',
	'FR08067' => 'Blagny',
	'FR08069' => 'Blanchefosse-et-Bay',
	'FR08070' => 'Blanzy-la-Salonnaise',
	'FR08071' => 'Blombay',
	'FR08073' => 'Bossus-lès-Rumigny',
	'FR08074' => 'Bouconville',
	'FR08075' => 'Boult-aux-Bois',
	'FR08076' => 'Boulzicourt',
	'FR08077' => 'Bourcq',
	'FR08078' => 'Bourg-Fidèle',
	'FR08080' => 'Bouvellemont',
	'FR08081' => 'Bogny-sur-Meuse',
	'FR08082' => 'Brécy-Brières',
	'FR08083' => 'Brévilly',
	'FR08084' => 'Brienne-sur-Aisne',
	'FR08085' => 'Brieulles-sur-Bar',
	'FR08086' => 'Briquenay',
	'FR08087' => 'Brognon',
	'FR08088' => 'Bulson',
	'FR08089' => 'Buzancy',
	'FR08090' => 'Carignan',
	'FR08092' => 'Cauroy',
	'FR08094' => 'Cernion',
	'FR08095' => 'Chagny',
	'FR08096' => 'Chalandry-Elaire',
	'FR08097' => 'Challerange',
	'FR08098' => 'Champigneulle',
	'FR08099' => 'Champigneul-sur-Vence',
	'FR08100' => 'Champlin',
	'FR08101' => 'La Chapelle',
	'FR08102' => 'Chappes',
	'FR08103' => 'Charbogne',
	'FR08104' => 'Chardeny',
	'FR08105' => 'Charleville-Mézières',
	'FR08106' => 'Charnois',
	'FR08107' => 'Château-Porcien',
	'FR08109' => 'Chatel-Chéhéry',
	'FR08110' => 'Le Châtelet-sur-Sormonne',
	'FR08111' => 'Le Châtelet-sur-Retourne',
	'FR08113' => 'Chaumont-Porcien',
	'FR08115' => 'Chémery-Chéhéry',
	'FR08116' => 'Bairon et ses environs',
	'FR08117' => 'Chesnois-Auboncourt',
	'FR08119' => 'Cheveuges',
	'FR08120' => 'Chevières',
	'FR08121' => 'Chilly',
	'FR08122' => 'Chooz',
	'FR08123' => 'Chuffilly-Roche',
	'FR08124' => 'Clavy-Warby',
	'FR08125' => 'Cliron',
	'FR08126' => 'Condé-lès-Herpy',
	'FR08128' => 'Condé-lès-Autry',
	'FR08130' => 'Contreuve',
	'FR08131' => 'Cornay',
	'FR08132' => 'Corny-Machéroménil',
	'FR08133' => 'Coucy',
	'FR08134' => 'Coulommes-et-Marqueny',
	'FR08135' => 'La Croix-aux-Bois',
	'FR08136' => 'Daigny',
	'FR08137' => 'Damouzy',
	'FR08138' => 'Les Deux-Villes',
	'FR08139' => 'Deville',
	'FR08140' => 'Dom-le-Mesnil',
	'FR08141' => 'Dommery',
	'FR08142' => 'Donchery',
	'FR08143' => 'Doumely-Bégny',
	'FR08144' => 'Doux',
	'FR08145' => 'Douzy',
	'FR08146' => 'Draize',
	'FR08147' => 'Dricourt',
	'FR08148' => 'LÉcaille',
	'FR08149' => 'LÉchelle',
	'FR08150' => 'Écly',
	'FR08151' => 'Écordal',
	'FR08153' => 'Escombres-et-le-Chesnois',
	'FR08154' => 'Estrebay',
	'FR08155' => 'Étalle',
	'FR08156' => 'Éteignières',
	'FR08158' => 'Étrépigny',
	'FR08159' => 'Euilly-et-Lombut',
	'FR08160' => 'Évigny',
	'FR08161' => 'Exermont',
	'FR08162' => 'Fagnon',
	'FR08163' => 'Faissault',
	'FR08164' => 'Falaise',
	'FR08165' => 'FAUX',
	'FR08166' => 'Fépin',
	'FR08167' => 'La Férée',
	'FR08168' => 'La Ferté-sur-Chiers',
	'FR08169' => 'Flaignes-Havys',
	'FR08170' => 'Fleigneux',
	'FR08171' => 'Fléville',
	'FR08172' => 'Fligny',
	'FR08173' => 'Flize',
	'FR08174' => 'Floing',
	'FR08175' => 'Foisches',
	'FR08176' => 'Fossé',
	'FR08178' => 'Fraillicourt',
	'FR08179' => 'Francheval',
	'FR08180' => 'La Francheville',
	'FR08182' => 'Le Fréty',
	'FR08183' => 'Fromelennes',
	'FR08184' => 'Fromy',
	'FR08185' => 'Fumay',
	'FR08186' => 'Germont',
	'FR08187' => 'Gernelle',
	'FR08188' => 'Gespunsart',
	'FR08189' => 'Girondelle',
	'FR08190' => 'Givet',
	'FR08191' => 'Givonne',
	'FR08192' => 'Givron',
	'FR08193' => 'Givry',
	'FR08194' => 'Glaire',
	'FR08195' => 'Gomont',
	'FR08196' => 'Grandchamp',
	'FR08197' => 'Grandham',
	'FR08198' => 'Grandpré',
	'FR08199' => 'La Grandville',
	'FR08200' => 'Grivy-Loisy',
	'FR08201' => 'Gruyères',
	'FR08202' => 'Gué-dHossus',
	'FR08203' => 'Guignicourt-sur-Vence',
	'FR08204' => 'Guincourt',
	'FR08205' => 'Hagnicourt',
	'FR08206' => 'Ham-les-Moines',
	'FR08207' => 'Ham-sur-Meuse',
	'FR08208' => 'Hannappes',
	'FR08209' => 'Hannogne-Saint-Martin',
	'FR08210' => 'Hannogne-Saint-Rémy',
	'FR08211' => 'Haraucourt',
	'FR08212' => 'Harcy',
	'FR08214' => 'Hargnies',
	'FR08215' => 'Harricourt',
	'FR08216' => 'Haudrecy',
	'FR08217' => 'Haulmé',
	'FR08218' => 'Les Hautes-Rivières',
	'FR08219' => 'Hauteville',
	'FR08220' => 'Hauviné',
	'FR08222' => 'Haybes',
	'FR08223' => 'Herbeuval',
	'FR08225' => 'Herpy-lArlésienne',
	'FR08226' => 'Hierges',
	'FR08228' => 'La Horgne',
	'FR08229' => 'Houdilcourt',
	'FR08230' => 'Houldizy',
	'FR08232' => 'Illy',
	'FR08233' => 'Imécourt',
	'FR08234' => 'Inaumont',
	'FR08235' => 'Issancourt-et-Rumel',
	'FR08236' => 'Jandun',
	'FR08237' => 'Joigny-sur-Meuse',
	'FR08238' => 'Jonval',
	'FR08239' => 'Juniville',
	'FR08240' => 'Justine-Herbigny',
	'FR08242' => 'Laifour',
	'FR08243' => 'Lalobbe',
	'FR08244' => 'Lametz',
	'FR08245' => 'Lançon',
	'FR08246' => 'Landres-et-Saint-Georges',
	'FR08247' => 'Landrichamps',
	'FR08248' => 'Launois-sur-Vence',
	'FR08249' => 'Laval-Morency',
	'FR08250' => 'Leffincourt',
	'FR08251' => 'Lépron-les-Vallées',
	'FR08252' => 'Létanne',
	'FR08254' => 'Liart',
	'FR08255' => 'Linay',
	'FR08256' => 'Liry',
	'FR08257' => 'Logny-Bogny',
	'FR08259' => 'Longwé',
	'FR08260' => 'Lonny',
	'FR08262' => 'Lucquy',
	'FR08263' => 'Lumes',
	'FR08264' => 'Machault',
	'FR08268' => 'Maisoncelle-et-Villers',
	'FR08269' => 'Malandry',
	'FR08271' => 'Manre',
	'FR08272' => 'Maranwez',
	'FR08273' => 'Marby',
	'FR08274' => 'Marcq',
	'FR08275' => 'Margny',
	'FR08276' => 'Margut',
	'FR08277' => 'Marlemont',
	'FR08278' => 'Marquigny',
	'FR08279' => 'Mars-sous-Bourcq',
	'FR08280' => 'Marvaux-Vieux',
	'FR08281' => 'Matton-et-Clémency',
	'FR08282' => 'Maubert-Fontaine',
	'FR08283' => 'Mazerny',
	'FR08284' => 'Les Mazures',
	'FR08286' => 'Ménil-Annelles',
	'FR08287' => 'Ménil-Lépinois',
	'FR08288' => 'Mesmont',
	'FR08289' => 'Messincourt',
	'FR08291' => 'Mogues',
	'FR08293' => 'Moiry',
	'FR08294' => 'La Moncelle',
	'FR08295' => 'Mondigny',
	'FR08296' => 'Montcheutin',
	'FR08297' => 'Montcornet',
	'FR08298' => 'Montcy-Notre-Dame',
	'FR08300' => 'Le Mont-Dieu',
	'FR08301' => 'Montgon',
	'FR08302' => 'Monthermé',
	'FR08303' => 'Monthois',
	'FR08304' => 'Montigny-sur-Meuse',
	'FR08305' => 'Montigny-sur-Vence',
	'FR08306' => 'Mont-Laurent',
	'FR08307' => 'Montmeillant',
	'FR08308' => 'Mont-Saint-Martin',
	'FR08309' => 'Mont-Saint-Remy',
	'FR08310' => 'Mouron',
	'FR08311' => 'Mouzon',
	'FR08312' => 'Murtin-et-Bogny',
	'FR08313' => 'Nanteuil-sur-Aisne',
	'FR08314' => 'Neuflize',
	'FR08315' => 'Neufmaison',
	'FR08316' => 'Neufmanil',
	'FR08317' => 'La Neuville-à-Maire',
	'FR08318' => 'La Neuville-aux-Joûtes',
	'FR08319' => 'Neuville-lez-Beaulieu',
	'FR08320' => 'La Neuville-en-Tourne-à-Fuy',
	'FR08321' => 'Neuville-Day',
	'FR08322' => 'Neuville-lès-This',
	'FR08323' => 'La Neuville-lès-Wasigny',
	'FR08324' => 'Neuvizy',
	'FR08325' => 'Noirval',
	'FR08326' => 'Nouart',
	'FR08327' => 'Nouvion-sur-Meuse',
	'FR08328' => 'Nouzonville',
	'FR08329' => 'Novion-Porcien',
	'FR08330' => 'Novy-Chevrières',
	'FR08331' => 'Noyers-Pont-Maugis',
	'FR08332' => 'Oches',
	'FR08333' => 'Olizy-Primat',
	'FR08334' => 'Omicourt',
	'FR08335' => 'Omont',
	'FR08336' => 'Osnes',
	'FR08338' => 'Pauvres',
	'FR08339' => 'Perthes',
	'FR08340' => 'Poilcourt-Sydney',
	'FR08341' => 'Poix-Terron',
	'FR08342' => 'Pouru-aux-Bois',
	'FR08343' => 'Pouru-Saint-Remy',
	'FR08344' => 'Prez',
	'FR08346' => 'Prix-lès-Mézières',
	'FR08347' => 'Puilly-et-Charbeaux',
	'FR08348' => 'Puiseux',
	'FR08349' => 'Pure',
	'FR08350' => 'Quatre-Champs',
	'FR08351' => 'Quilly',
	'FR08352' => 'Raillicourt',
	'FR08353' => 'Rancennes',
	'FR08354' => 'Raucourt-et-Flaba',
	'FR08355' => 'Regniowez',
	'FR08356' => 'Remaucourt',
	'FR08357' => 'Remilly-Aillicourt',
	'FR08358' => 'Remilly-les-Pothées',
	'FR08360' => 'Renneville',
	'FR08361' => 'Renwez',
	'FR08362' => 'Rethel',
	'FR08363' => 'Revin',
	'FR08364' => 'Rilly-sur-Aisne',
	'FR08365' => 'Rimogne',
	'FR08366' => 'Rocquigny',
	'FR08367' => 'Rocroi',
	'FR08368' => 'Roizy',
	'FR08369' => 'La Romagne',
	'FR08370' => 'Rouvroy-sur-Audry',
	'FR08372' => 'Rubigny',
	'FR08373' => 'Rumigny',
	'FR08374' => 'La Sabotterie',
	'FR08375' => 'Sachy',
	'FR08376' => 'Sailly',
	'FR08377' => 'Saint-Aignan',
	'FR08378' => 'Saint-Clément-à-Arnes',
	'FR08379' => 'Saint-Étienne-à-Arnes',
	'FR08380' => 'Saint-Fergeux',
	'FR08381' => 'Saint-Germainmont',
	'FR08382' => 'Saint-Jean-aux-Bois',
	'FR08383' => 'Saint-Juvin',
	'FR08384' => 'Saint-Lambert-et-Mont-de-Jeux',
	'FR08385' => 'Saint-Laurent',
	'FR08386' => 'Saint-Loup-en-Champagne',
	'FR08387' => 'Saint-Loup-Terrier',
	'FR08388' => 'Saint-Marceau',
	'FR08389' => 'Saint-Marcel',
	'FR08390' => 'Sainte-Marie',
	'FR08391' => 'Saint-Menges',
	'FR08392' => 'Saint-Morel',
	'FR08393' => 'Saint-Pierre-à-Arnes',
	'FR08394' => 'Saint-Pierremont',
	'FR08395' => 'Saint-Pierre-sur-Vence',
	'FR08396' => 'Saint-Quentin-le-Petit',
	'FR08397' => 'Saint-Remy-le-Petit',
	'FR08398' => 'Sainte-Vaubourg',
	'FR08399' => 'Sapogne-sur-Marche',
	'FR08400' => 'Sapogne-et-Feuchères',
	'FR08401' => 'Saulces-Champenoises',
	'FR08402' => 'Saulces-Monclin',
	'FR08403' => 'Sault-lès-Rethel',
	'FR08404' => 'Sault-Saint-Remy',
	'FR08405' => 'Sauville',
	'FR08406' => 'Savigny-sur-Aisne',
	'FR08407' => 'Séchault',
	'FR08408' => 'Sécheval',
	'FR08409' => 'Sedan',
	'FR08410' => 'Semide',
	'FR08411' => 'Semuy',
	'FR08412' => 'Senuc',
	'FR08413' => 'Seraincourt',
	'FR08415' => 'Sery',
	'FR08416' => 'Seuil',
	'FR08417' => 'Sévigny-la-Forêt',
	'FR08418' => 'Sévigny-Waleppe',
	'FR08419' => 'Signy-lAbbaye',
	'FR08420' => 'Signy-le-Petit',
	'FR08421' => 'Signy-Montlibert',
	'FR08422' => 'Singly',
	'FR08424' => 'Sommauthe',
	'FR08425' => 'Sommerance',
	'FR08426' => 'Son',
	'FR08427' => 'Sorbon',
	'FR08428' => 'Sorcy-Bauthémont',
	'FR08429' => 'Sormonne',
	'FR08430' => 'Stonne',
	'FR08431' => 'Sugny',
	'FR08432' => 'Sury',
	'FR08433' => 'Suzanne',
	'FR08434' => 'Sy',
	'FR08435' => 'Tagnon',
	'FR08436' => 'Taillette',
	'FR08437' => 'Tailly',
	'FR08438' => 'Taizy',
	'FR08439' => 'Tannay',
	'FR08440' => 'Tarzy',
	'FR08444' => 'Tétaigne',
	'FR08445' => 'Thelonne',
	'FR08446' => 'Thénorgues',
	'FR08448' => 'Thilay',
	'FR08449' => 'Thin-le-Moutier',
	'FR08450' => 'This',
	'FR08451' => 'Le Thour',
	'FR08452' => 'Thugny-Trugny',
	'FR08453' => 'Toges',
	'FR08454' => 'Touligny',
	'FR08455' => 'Tourcelles-Chaumont',
	'FR08456' => 'Tournavaux',
	'FR08457' => 'Tournes',
	'FR08458' => 'Tourteron',
	'FR08459' => 'Tremblois-lès-Carignan',
	'FR08460' => 'Tremblois-lès-Rocroi',
	'FR08461' => 'Vandy',
	'FR08462' => 'Vaux-Champagne',
	'FR08463' => 'Vaux-en-Dieulet',
	'FR08464' => 'Vaux-lès-Mouron',
	'FR08465' => 'Vaux-lès-Rubigny',
	'FR08466' => 'Vaux-lès-Mouzon',
	'FR08467' => 'Vaux-Montreuil',
	'FR08468' => 'Vaux-Villaine',
	'FR08469' => 'Vendresse',
	'FR08470' => 'Verpel',
	'FR08471' => 'Verrières',
	'FR08472' => 'Viel-Saint-Remy',
	'FR08473' => 'Vieux-lès-Asfeld',
	'FR08476' => 'Villers-devant-le-Thour',
	'FR08477' => 'Villers-devant-Mouzon',
	'FR08478' => 'Villers-le-Tilleul',
	'FR08479' => 'Villers-le-Tourneur',
	'FR08480' => 'Villers-Semeuse',
	'FR08481' => 'Villers-sur-Bar',
	'FR08482' => 'Villers-sur-le-Mont',
	'FR08483' => 'Ville-sur-Lumes',
	'FR08484' => 'Ville-sur-Retourne',
	'FR08485' => 'Villy',
	'FR08486' => 'Vireux-Molhain',
	'FR08487' => 'Vireux-Wallerand',
	'FR08488' => 'Vivier-au-Court',
	'FR08489' => 'Voncq',
	'FR08490' => 'Vouziers',
	'FR08491' => 'Vrigne aux Bois',
	'FR08492' => 'Vrigne-Meuse',
	'FR08494' => 'Wadelincourt',
	'FR08496' => 'Wagnon',
	'FR08497' => 'Warcq',
	'FR08498' => 'Warnécourt',
	'FR08499' => 'Wasigny',
	'FR08500' => 'Wignicourt',
	'FR08501' => 'Williers',
	'FR08502' => 'Yoncq',
	'FR08503' => 'Yvernaumont',
	'FR09001' => 'Aigues-Juntes',
	'FR09002' => 'Aigues-Vives',
	'FR09003' => 'LAiguillon',
	'FR09004' => 'Albiès',
	'FR09005' => 'Aleu',
	'FR09006' => 'Alliat',
	'FR09007' => 'Allières',
	'FR09008' => 'Alos',
	'FR09009' => 'Alzen',
	'FR09011' => 'Antras',
	'FR09012' => 'Appy',
	'FR09013' => 'Arabaux',
	'FR09014' => 'Argein',
	'FR09015' => 'Arignac',
	'FR09016' => 'Arnave',
	'FR09017' => 'Arrien-en-Bethmale',
	'FR09018' => 'Arrout',
	'FR09019' => 'Artigat',
	'FR09020' => 'Artigues',
	'FR09021' => 'Artix',
	'FR09022' => 'Arvigna',
	'FR09023' => 'Ascou',
	'FR09024' => 'Aston',
	'FR09025' => 'Aucazein',
	'FR09026' => 'Audressein',
	'FR09027' => 'Augirein',
	'FR09029' => 'Aulus-les-Bains',
	'FR09030' => 'Auzat',
	'FR09031' => 'Axiat',
	'FR09032' => 'Ax-les-Thermes',
	'FR09033' => 'Bagert',
	'FR09034' => 'Balacet',
	'FR09035' => 'Balaguères',
	'FR09037' => 'Barjac',
	'FR09038' => 'La Bastide-de-Besplas',
	'FR09039' => 'La Bastide-de-Bousignac',
	'FR09040' => 'La Bastide-de-Lordat',
	'FR09041' => 'La Bastide-du-Salat',
	'FR09042' => 'La Bastide-de-Sérou',
	'FR09043' => 'La Bastide-sur-lHers',
	'FR09044' => 'Baulou',
	'FR09045' => 'Bédeilhac-et-Aynat',
	'FR09046' => 'Bédeille',
	'FR09047' => 'Bélesta',
	'FR09048' => 'Belloc',
	'FR09049' => 'Bénac',
	'FR09050' => 'Benagues',
	'FR09051' => 'Bénaix',
	'FR09052' => 'Besset',
	'FR09053' => 'Bestiac',
	'FR09054' => 'Betchat',
	'FR09055' => 'Bethmale',
	'FR09056' => 'Bézac',
	'FR09057' => 'Biert',
	'FR09058' => 'Bompas',
	'FR09059' => 'Bonac-Irazein',
	'FR09060' => 'Bonnac',
	'FR09061' => 'Les Bordes-sur-Arize',
	'FR09062' => 'Bordes-Uchentein',
	'FR09063' => 'Le Bosc',
	'FR09064' => 'Bouan',
	'FR09065' => 'Boussenac',
	'FR09066' => 'Brassac',
	'FR09067' => 'Brie',
	'FR09068' => 'Burret',
	'FR09069' => 'Buzan',
	'FR09070' => 'Les Cabannes',
	'FR09071' => 'Cadarcet',
	'FR09072' => 'Calzan',
	'FR09073' => 'Camarade',
	'FR09074' => 'Camon',
	'FR09075' => 'Campagne-sur-Arize',
	'FR09076' => 'Canté',
	'FR09077' => 'Capoulet-et-Junac',
	'FR09078' => 'Carcanières',
	'FR09079' => 'Carla-Bayle',
	'FR09080' => 'Carla-de-Roquefort',
	'FR09081' => 'Le Carlaret',
	'FR09082' => 'Castelnau-Durban',
	'FR09083' => 'Castéras',
	'FR09084' => 'Castex',
	'FR09085' => 'Castillon-en-Couserans',
	'FR09086' => 'Caumont',
	'FR09087' => 'Caussou',
	'FR09088' => 'Caychax',
	'FR09089' => 'Cazals-des-Baylès',
	'FR09090' => 'Cazaux',
	'FR09091' => 'Cazavet',
	'FR09092' => 'Cazenave-Serres-et-Allens',
	'FR09093' => 'Celles',
	'FR09094' => 'Cérizols',
	'FR09095' => 'Cescau',
	'FR09096' => 'Château-Verdun',
	'FR09097' => 'Clermont',
	'FR09098' => 'Contrazy',
	'FR09099' => 'Cos',
	'FR09100' => 'Couflens',
	'FR09101' => 'Coussa',
	'FR09102' => 'Coutens',
	'FR09103' => 'Crampagna',
	'FR09104' => 'Dalou',
	'FR09105' => 'Daumazan-sur-Arize',
	'FR09106' => 'Dreuilhe',
	'FR09107' => 'Dun',
	'FR09108' => 'Durban-sur-Arize',
	'FR09109' => 'Durfort',
	'FR09110' => 'Encourtiech',
	'FR09111' => 'Engomer',
	'FR09113' => 'Ercé',
	'FR09114' => 'Erp',
	'FR09115' => 'Esclagne',
	'FR09116' => 'Escosse',
	'FR09117' => 'Esplas',
	'FR09118' => 'Esplas-de-Sérou',
	'FR09119' => 'Eycheil',
	'FR09120' => 'Fabas',
	'FR09121' => 'Ferrières-sur-Ariège',
	'FR09122' => 'Foix',
	'FR09123' => 'Fornex',
	'FR09124' => 'Le Fossat',
	'FR09125' => 'Fougax-et-Barrineuf',
	'FR09126' => 'Freychenet',
	'FR09127' => 'Gabre',
	'FR09128' => 'Gajan',
	'FR09129' => 'Galey',
	'FR09130' => 'Ganac',
	'FR09131' => 'Garanou',
	'FR09132' => 'Gaudiès',
	'FR09133' => 'Génat',
	'FR09134' => 'Gestiès',
	'FR09136' => 'Gourbit',
	'FR09137' => 'Gudas',
	'FR09138' => 'LHerm',
	'FR09139' => 'LHospitalet-près-lAndorre',
	'FR09140' => 'Ignaux',
	'FR09141' => 'Illartein',
	'FR09142' => 'Ilhat',
	'FR09143' => 'Illier-et-Laramade',
	'FR09145' => 'Les Issards',
	'FR09146' => 'Justiniac',
	'FR09147' => 'Labatut',
	'FR09148' => 'Lacave',
	'FR09149' => 'Lacourt',
	'FR09150' => 'Lagarde',
	'FR09151' => 'Lanoux',
	'FR09152' => 'Lapège',
	'FR09153' => 'Lapenne',
	'FR09154' => 'Larbont',
	'FR09155' => 'Larcat',
	'FR09156' => 'Larnat',
	'FR09157' => 'Laroque-dOlmes',
	'FR09158' => 'Lasserre',
	'FR09159' => 'Lassur',
	'FR09160' => 'Lavelanet',
	'FR09161' => 'Léran',
	'FR09162' => 'Lercoul',
	'FR09163' => 'Lescousse',
	'FR09164' => 'Lescure',
	'FR09165' => 'Lesparrou',
	'FR09166' => 'Leychert',
	'FR09167' => 'Lézat-sur-Lèze',
	'FR09168' => 'Lieurac',
	'FR09169' => 'Limbrassac',
	'FR09170' => 'Lissac',
	'FR09171' => 'Lordat',
	'FR09172' => 'Loubaut',
	'FR09173' => 'Loubens',
	'FR09174' => 'Loubières',
	'FR09175' => 'Ludiès',
	'FR09176' => 'Luzenac',
	'FR09177' => 'Madière',
	'FR09178' => 'Malegoude',
	'FR09179' => 'Malléon',
	'FR09180' => 'Manses',
	'FR09181' => 'Le Mas-dAzil',
	'FR09182' => 'Massat',
	'FR09183' => 'Mauvezin-de-Prat',
	'FR09184' => 'Mauvezin-de-Sainte-Croix',
	'FR09185' => 'Mazères',
	'FR09186' => 'Méras',
	'FR09187' => 'Mercenac',
	'FR09188' => 'Mercus-Garrabet',
	'FR09189' => 'Mérens-les-Vals',
	'FR09190' => 'Mérigon',
	'FR09192' => 'Miglos',
	'FR09193' => 'Mijanès',
	'FR09194' => 'Mirepoix',
	'FR09195' => 'Monesple',
	'FR09196' => 'Montagagne',
	'FR09197' => 'Montaillou',
	'FR09198' => 'Montardit',
	'FR09199' => 'Montaut',
	'FR09200' => 'Montbel',
	'FR09201' => 'Montégut-en-Couserans',
	'FR09202' => 'Montégut-Plantaurel',
	'FR09203' => 'Montels',
	'FR09204' => 'Montesquieu-Avantès',
	'FR09205' => 'Montfa',
	'FR09206' => 'Montferrier',
	'FR09207' => 'Montgaillard',
	'FR09208' => 'Montgauch',
	'FR09209' => 'Montjoie-en-Couserans',
	'FR09210' => 'Montoulieu',
	'FR09211' => 'Montségur',
	'FR09212' => 'Montseron',
	'FR09213' => 'Moulin-Neuf',
	'FR09214' => 'Moulis',
	'FR09215' => 'Nalzen',
	'FR09216' => 'Nescus',
	'FR09217' => 'Niaux',
	'FR09218' => 'Orgeix',
	'FR09219' => 'Orgibet',
	'FR09220' => 'Orlu',
	'FR09221' => 'Ornolac-Ussat-les-Bains',
	'FR09222' => 'Orus',
	'FR09223' => 'Oust',
	'FR09224' => 'Pailhès',
	'FR09225' => 'Pamiers',
	'FR09226' => 'Pech',
	'FR09227' => 'Péreille',
	'FR09228' => 'Perles-et-Castelet',
	'FR09229' => 'Le Peyrat',
	'FR09230' => 'Le Pla',
	'FR09231' => 'Le Port',
	'FR09232' => 'Prades',
	'FR09233' => 'Pradettes',
	'FR09234' => 'Pradières',
	'FR09235' => 'Prat-Bonrepaux',
	'FR09236' => 'Prayols',
	'FR09237' => 'Le Puch',
	'FR09238' => 'Les Pujols',
	'FR09239' => 'Quérigut',
	'FR09240' => 'Quié',
	'FR09241' => 'Rabat-les-Trois-Seigneurs',
	'FR09242' => 'Raissac',
	'FR09243' => 'Régat',
	'FR09244' => 'Rieucros',
	'FR09245' => 'Rieux-de-Pelleport',
	'FR09246' => 'Rimont',
	'FR09247' => 'Rivèrenert',
	'FR09249' => 'Roquefixade',
	'FR09250' => 'Roquefort-les-Cascades',
	'FR09251' => 'Roumengoux',
	'FR09252' => 'Rouze',
	'FR09253' => 'Sabarat',
	'FR09254' => 'Saint-Amadou',
	'FR09255' => 'Saint-Amans',
	'FR09256' => 'Saint-Bauzeil',
	'FR09257' => 'Sainte-Croix-Volvestre',
	'FR09258' => 'Saint-Félix-de-Rieutord',
	'FR09259' => 'Saint-Félix-de-Tournegat',
	'FR09260' => 'Sainte-Foi',
	'FR09261' => 'Saint-Girons',
	'FR09262' => 'Saint-Jean-dAigues-Vives',
	'FR09263' => 'Saint-Jean-du-Castillonnais',
	'FR09264' => 'Saint-Jean-de-Verges',
	'FR09265' => 'Saint-Jean-du-Falga',
	'FR09266' => 'Saint-Julien-de-Gras-Capou',
	'FR09267' => 'Saint-Lary',
	'FR09268' => 'Saint-Lizier',
	'FR09269' => 'Saint-Martin-de-Caralp',
	'FR09270' => 'Saint-Martin-dOydes',
	'FR09271' => 'Saint-Michel',
	'FR09272' => 'Saint-Paul-de-Jarrat',
	'FR09273' => 'Saint-Pierre-de-Rivière',
	'FR09274' => 'Saint-Quentin-la-Tour',
	'FR09275' => 'Saint-Quirc',
	'FR09276' => 'Saint-Victor-Rouzaud',
	'FR09277' => 'Saint-Ybars',
	'FR09279' => 'Salsein',
	'FR09280' => 'Saurat',
	'FR09281' => 'Sautel',
	'FR09282' => 'Saverdun',
	'FR09283' => 'Savignac-les-Ormeaux',
	'FR09284' => 'Ségura',
	'FR09285' => 'Seix',
	'FR09287' => 'Senconac',
	'FR09289' => 'Lorp-Sentaraille',
	'FR09290' => 'Sentein',
	'FR09291' => 'Sentenac-dOust',
	'FR09292' => 'Sentenac-de-Sérou',
	'FR09293' => 'Serres-sur-Arget',
	'FR09294' => 'Sieuras',
	'FR09295' => 'Siguer',
	'FR09296' => 'Aulos-Sinsat',
	'FR09297' => 'Sor',
	'FR09298' => 'Sorgeat',
	'FR09299' => 'Soueix-Rogalle',
	'FR09300' => 'Soula',
	'FR09301' => 'Soulan',
	'FR09303' => 'Surba',
	'FR09304' => 'Suzan',
	'FR09305' => 'Tabre',
	'FR09306' => 'Tarascon-sur-Ariège',
	'FR09307' => 'Taurignan-Castet',
	'FR09308' => 'Taurignan-Vieux',
	'FR09309' => 'Teilhet',
	'FR09310' => 'Thouars-sur-Arize',
	'FR09311' => 'Tignac',
	'FR09312' => 'La Tour-du-Crieu',
	'FR09313' => 'Tourtouse',
	'FR09314' => 'Tourtrol',
	'FR09315' => 'Trémoulet',
	'FR09316' => 'Troye-dAriège',
	'FR09318' => 'Unac',
	'FR09319' => 'Unzent',
	'FR09320' => 'Urs',
	'FR09321' => 'Ussat',
	'FR09322' => 'Ustou',
	'FR09323' => 'Vals',
	'FR09324' => 'Varilhes',
	'FR09325' => 'Vaychis',
	'FR09326' => 'Vèbre',
	'FR09327' => 'Ventenac',
	'FR09328' => 'Verdun',
	'FR09329' => 'Vernajoul',
	'FR09330' => 'Vernaux',
	'FR09331' => 'Le Vernet',
	'FR09332' => 'Verniolle',
	'FR09334' => 'Val-de-Sos',
	'FR09335' => 'Villeneuve',
	'FR09336' => 'Villeneuve-dOlmes',
	'FR09338' => 'Villeneuve-du-Latou',
	'FR09339' => 'Villeneuve-du-Paréage',
	'FR09340' => 'Vira',
	'FR09341' => 'Viviès',
	'FR09342' => 'Sainte-Suzanne',
	'FR10002' => 'Ailleville',
	'FR10003' => 'Aix-Villemaur-Pâlis',
	'FR10004' => 'Allibaudières',
	'FR10005' => 'Amance',
	'FR10006' => 'Arcis-sur-Aube',
	'FR10007' => 'Arconville',
	'FR10008' => 'Argançon',
	'FR10009' => 'Arrelles',
	'FR10010' => 'Arrembécourt',
	'FR10011' => 'Arrentières',
	'FR10012' => 'Arsonval',
	'FR10013' => 'Assenay',
	'FR10014' => 'Assencières',
	'FR10015' => 'Aubeterre',
	'FR10017' => 'Aulnay',
	'FR10018' => 'Auxon',
	'FR10019' => 'Val-dAuzon',
	'FR10020' => 'Avant-lès-Marcilly',
	'FR10021' => 'Avant-lès-Ramerupt',
	'FR10022' => 'Avirey-Lingey',
	'FR10023' => 'Avon-la-Pèze',
	'FR10024' => 'Avreuil',
	'FR10025' => 'Bagneux-la-Fosse',
	'FR10026' => 'Bailly-le-Franc',
	'FR10027' => 'Balignicourt',
	'FR10028' => 'Balnot-la-Grange',
	'FR10029' => 'Balnot-sur-Laignes',
	'FR10030' => 'Barberey-Saint-Sulpice',
	'FR10031' => 'Barbuise',
	'FR10032' => 'Baroville',
	'FR10033' => 'Bar-sur-Aube',
	'FR10034' => 'Bar-sur-Seine',
	'FR10035' => 'Bayel',
	'FR10037' => 'Bercenay-en-Othe',
	'FR10038' => 'Bercenay-le-Hayer',
	'FR10039' => 'Bergères',
	'FR10040' => 'Bernon',
	'FR10041' => 'Bertignolles',
	'FR10042' => 'Bérulle',
	'FR10043' => 'Bessy',
	'FR10044' => 'Bétignicourt',
	'FR10045' => 'Beurey',
	'FR10046' => 'Blaincourt-sur-Aube',
	'FR10047' => 'Blignicourt',
	'FR10048' => 'Bligny',
	'FR10049' => 'Les Bordes-Aumont',
	'FR10050' => 'Bossancourt',
	'FR10051' => 'Bouilly',
	'FR10052' => 'Boulages',
	'FR10053' => 'Bouranton',
	'FR10054' => 'Bourdenay',
	'FR10055' => 'Bourguignons',
	'FR10056' => 'Bouy-Luxembourg',
	'FR10057' => 'Bouy-sur-Orvin',
	'FR10058' => 'Bragelogne-Beauvoir',
	'FR10059' => 'Braux',
	'FR10060' => 'Bréviandes',
	'FR10061' => 'Brévonnes',
	'FR10062' => 'Briel-sur-Barse',
	'FR10063' => 'Brienne-la-Vieille',
	'FR10064' => 'Brienne-le-Château',
	'FR10065' => 'Brillecourt',
	'FR10066' => 'Bucey-en-Othe',
	'FR10067' => 'Buchères',
	'FR10068' => 'Buxeuil',
	'FR10069' => 'Buxières-sur-Arce',
	'FR10070' => 'Celles-sur-Ource',
	'FR10071' => 'Chacenay',
	'FR10072' => 'La Chaise',
	'FR10073' => 'Chalette-sur-Voire',
	'FR10074' => 'Chamoy',
	'FR10075' => 'Champfleury',
	'FR10076' => 'Champignol-lez-Mondeville',
	'FR10077' => 'Champigny-sur-Aube',
	'FR10078' => 'Champ-sur-Barse',
	'FR10079' => 'Channes',
	'FR10080' => 'Chaource',
	'FR10081' => 'La Chapelle-Saint-Luc',
	'FR10082' => 'Chapelle-Vallon',
	'FR10083' => 'Chappes',
	'FR10084' => 'Charmont-sous-Barbuise',
	'FR10085' => 'Charmoy',
	'FR10086' => 'Charny-le-Bachot',
	'FR10087' => 'Chaserey',
	'FR10089' => 'Châtres',
	'FR10090' => 'Chauchigny',
	'FR10091' => 'Chaudrey',
	'FR10092' => 'Chauffour-lès-Bailly',
	'FR10093' => 'Chaumesnil',
	'FR10094' => 'Chavanges',
	'FR10095' => 'Le Chêne',
	'FR10096' => 'Chennegy',
	'FR10097' => 'Chervey',
	'FR10098' => 'Chesley',
	'FR10099' => 'Chessy-les-Prés',
	'FR10100' => 'Clérey',
	'FR10101' => 'Coclois',
	'FR10102' => 'Colombé-la-Fosse',
	'FR10103' => 'Colombé-le-Sec',
	'FR10104' => 'Cormost',
	'FR10105' => 'Courcelles-sur-Voire',
	'FR10106' => 'Courceroy',
	'FR10107' => 'Coursan-en-Othe',
	'FR10108' => 'Courtaoult',
	'FR10109' => 'Courtenot',
	'FR10110' => 'Courteranges',
	'FR10111' => 'Courteron',
	'FR10112' => 'Coussegrey',
	'FR10113' => 'Couvignon',
	'FR10114' => 'Crancey',
	'FR10115' => 'Creney-près-Troyes',
	'FR10116' => 'Crésantignes',
	'FR10117' => 'Crespy-le-Neuf',
	'FR10118' => 'Les Croûtes',
	'FR10119' => 'Cunfin',
	'FR10120' => 'Cussangy',
	'FR10121' => 'Dampierre',
	'FR10122' => 'Davrey',
	'FR10123' => 'Dienville',
	'FR10124' => 'Dierrey-Saint-Julien',
	'FR10125' => 'Dierrey-Saint-Pierre',
	'FR10126' => 'Dolancourt',
	'FR10127' => 'Dommartin-le-Coq',
	'FR10128' => 'Donnement',
	'FR10129' => 'Dosches',
	'FR10130' => 'Dosnon',
	'FR10131' => 'Droupt-Saint-Basle',
	'FR10132' => 'Droupt-Sainte-Marie',
	'FR10133' => 'Eaux-Puiseaux',
	'FR10134' => 'Échemines',
	'FR10135' => 'Éclance',
	'FR10136' => 'Éguilly-sous-Bois',
	'FR10137' => 'Engente',
	'FR10138' => 'Épagne',
	'FR10139' => 'Épothémont',
	'FR10140' => 'Ervy-le-Châtel',
	'FR10141' => 'Essoyes',
	'FR10142' => 'Estissac',
	'FR10143' => 'Étourvy',
	'FR10144' => 'Étrelles-sur-Aube',
	'FR10145' => 'Faux-Villecerf',
	'FR10146' => 'Fay-lès-Marcilly',
	'FR10147' => 'Fays-la-Chapelle',
	'FR10148' => 'Ferreux-Quincey',
	'FR10149' => 'Feuges',
	'FR10150' => 'Fontaine',
	'FR10151' => 'Fontaine-les-Grès',
	'FR10153' => 'Fontaine-Mâcon',
	'FR10154' => 'Fontenay-de-Bossery',
	'FR10155' => 'Fontette',
	'FR10156' => 'Fontvannes',
	'FR10157' => 'La Fosse-Corduan',
	'FR10158' => 'Fouchères',
	'FR10159' => 'Fralignes',
	'FR10160' => 'Fravaux',
	'FR10161' => 'Fresnay',
	'FR10162' => 'Fresnoy-le-Château',
	'FR10163' => 'Fuligny',
	'FR10164' => 'Gélannes',
	'FR10165' => 'Géraudot',
	'FR10166' => 'Les Grandes-Chapelles',
	'FR10167' => 'Grandville',
	'FR10168' => 'Les Granges',
	'FR10169' => 'Gumery',
	'FR10170' => 'Gyé-sur-Seine',
	'FR10171' => 'Hampigny',
	'FR10172' => 'Herbisse',
	'FR10173' => 'Isle-Aumont',
	'FR10174' => 'Isle-Aubigny',
	'FR10175' => 'Jasseines',
	'FR10176' => 'Jaucourt',
	'FR10177' => 'Javernant',
	'FR10178' => 'Jessains',
	'FR10179' => 'Jeugny',
	'FR10180' => 'Joncreuil',
	'FR10181' => 'Jully-sur-Sarce',
	'FR10182' => 'Juvancourt',
	'FR10183' => 'Juvanzé',
	'FR10184' => 'Juzanvigny',
	'FR10185' => 'Lagesse',
	'FR10186' => 'Laines-aux-Bois',
	'FR10187' => 'Landreville',
	'FR10188' => 'Lantages',
	'FR10189' => 'Lassicourt',
	'FR10190' => 'Laubressel',
	'FR10191' => 'Lavau',
	'FR10192' => 'Lentilles',
	'FR10193' => 'Lesmont',
	'FR10194' => 'Lévigny',
	'FR10195' => 'Lhuître',
	'FR10196' => 'Lignières',
	'FR10197' => 'Lignol-le-Château',
	'FR10198' => 'Lirey',
	'FR10199' => 'Loches-sur-Ource',
	'FR10200' => 'La Loge-aux-Chèvres',
	'FR10201' => 'La Loge-Pomblin',
	'FR10202' => 'Les Loges-Margueron',
	'FR10203' => 'Longchamp-sur-Aujon',
	'FR10204' => 'Longeville-sur-Mogne',
	'FR10205' => 'Longpré-le-Sec',
	'FR10206' => 'Longsols',
	'FR10207' => 'Longueville-sur-Aube',
	'FR10208' => 'La Louptière-Thénard',
	'FR10209' => 'Lusigny-sur-Barse',
	'FR10210' => 'Luyères',
	'FR10211' => 'Macey',
	'FR10212' => 'Machy',
	'FR10213' => 'Magnant',
	'FR10214' => 'Magnicourt',
	'FR10215' => 'Magny-Fouchard',
	'FR10216' => 'Mailly-le-Camp',
	'FR10217' => 'Maison-des-Champs',
	'FR10218' => 'Maisons-lès-Chaource',
	'FR10219' => 'Maisons-lès-Soulaines',
	'FR10220' => 'Maizières-la-Grande-Paroisse',
	'FR10221' => 'Maizières-lès-Brienne',
	'FR10222' => 'Maraye-en-Othe',
	'FR10223' => 'Marcilly-le-Hayer',
	'FR10224' => 'Marigny-le-Châtel',
	'FR10225' => 'Marnay-sur-Seine',
	'FR10226' => 'Marolles-lès-Bailly',
	'FR10227' => 'Marolles-sous-Lignières',
	'FR10228' => 'Mathaux',
	'FR10229' => 'Maupas',
	'FR10230' => 'Mergey',
	'FR10231' => 'Le Mériot',
	'FR10232' => 'Merrey-sur-Arce',
	'FR10233' => 'Méry-sur-Seine',
	'FR10234' => 'Mesgrigny',
	'FR10235' => 'Mesnil-la-Comtesse',
	'FR10236' => 'Mesnil-Lettre',
	'FR10237' => 'Mesnil-Saint-Loup',
	'FR10238' => 'Mesnil-Saint-Père',
	'FR10239' => 'Mesnil-Sellières',
	'FR10240' => 'Messon',
	'FR10241' => 'Metz-Robert',
	'FR10242' => 'Meurville',
	'FR10243' => 'Molins-sur-Aube',
	'FR10245' => 'Montaulin',
	'FR10246' => 'Montceaux-lès-Vaudes',
	'FR10247' => 'Montfey',
	'FR10248' => 'Montgueux',
	'FR10249' => 'Montiéramey',
	'FR10250' => 'Montier-en-lIsle',
	'FR10251' => 'Montigny-les-Monts',
	'FR10252' => 'Montmartin-le-Haut',
	'FR10253' => 'Montmorency-Beaufort',
	'FR10254' => 'Montpothier',
	'FR10255' => 'Montreuil-sur-Barse',
	'FR10256' => 'Montsuzain',
	'FR10257' => 'Morembert',
	'FR10258' => 'Morvilliers',
	'FR10259' => 'La Motte-Tilly',
	'FR10260' => 'Moussey',
	'FR10261' => 'Mussy-sur-Seine',
	'FR10262' => 'Neuville-sur-Seine',
	'FR10263' => 'Neuville-sur-Vanne',
	'FR10264' => 'Noé-les-Mallets',
	'FR10265' => 'Les Noës-près-Troyes',
	'FR10266' => 'Nogent-en-Othe',
	'FR10267' => 'Nogent-sur-Aube',
	'FR10268' => 'Nogent-sur-Seine',
	'FR10269' => 'Nozay',
	'FR10270' => 'Onjon',
	'FR10271' => 'Origny-le-Sec',
	'FR10272' => 'Ormes',
	'FR10273' => 'Ortillon',
	'FR10274' => 'Orvilliers-Saint-Julien',
	'FR10275' => 'Ossey-les-Trois-Maisons',
	'FR10276' => 'Paisy-Cosdon',
	'FR10278' => 'Pargues',
	'FR10279' => 'Pars-lès-Chavanges',
	'FR10280' => 'Pars-lès-Romilly',
	'FR10281' => 'Le Pavillon-Sainte-Julie',
	'FR10282' => 'Payns',
	'FR10283' => 'Pel-et-Der',
	'FR10284' => 'Périgny-la-Rose',
	'FR10285' => 'Perthes-lès-Brienne',
	'FR10286' => 'Petit-Mesnil',
	'FR10287' => 'Piney',
	'FR10288' => 'Plaines-Saint-Lange',
	'FR10289' => 'Plancy-lAbbaye',
	'FR10290' => 'Planty',
	'FR10291' => 'Plessis-Barbuise',
	'FR10293' => 'Poivres',
	'FR10294' => 'Poligny',
	'FR10295' => 'Polisot',
	'FR10296' => 'Polisy',
	'FR10297' => 'Pont-Sainte-Marie',
	'FR10298' => 'Pont-sur-Seine',
	'FR10299' => 'Pouan-les-Vallées',
	'FR10300' => 'Pougy',
	'FR10301' => 'Pouy-sur-Vannes',
	'FR10302' => 'Praslin',
	'FR10303' => 'Précy-Notre-Dame',
	'FR10304' => 'Précy-Saint-Martin',
	'FR10305' => 'Prémierfait',
	'FR10306' => 'Proverville',
	'FR10307' => 'Prugny',
	'FR10308' => 'Prunay-Belleville',
	'FR10309' => 'Prusy',
	'FR10310' => 'Puits-et-Nuisement',
	'FR10312' => 'Racines',
	'FR10313' => 'Radonvilliers',
	'FR10314' => 'Ramerupt',
	'FR10315' => 'Rances',
	'FR10316' => 'Rhèges',
	'FR10317' => 'Les Riceys',
	'FR10318' => 'Rigny-la-Nonneuse',
	'FR10319' => 'Rigny-le-Ferron',
	'FR10320' => 'Rilly-Sainte-Syre',
	'FR10321' => 'La Rivière-de-Corps',
	'FR10323' => 'Romilly-sur-Seine',
	'FR10324' => 'Roncenay',
	'FR10325' => 'Rosières-près-Troyes',
	'FR10326' => 'Rosnay-lHôpital',
	'FR10327' => 'La Rothière',
	'FR10328' => 'Rouilly-Sacey',
	'FR10329' => 'Rouilly-Saint-Loup',
	'FR10330' => 'Rouvres-les-Vignes',
	'FR10331' => 'Rumilly-lès-Vaudes',
	'FR10332' => 'Ruvigny',
	'FR10333' => 'Saint-André-les-Vergers',
	'FR10334' => 'Saint-Aubin',
	'FR10335' => 'Saint-Benoist-sur-Vanne',
	'FR10336' => 'Saint-Benoît-sur-Seine',
	'FR10337' => 'Saint-Christophe-Dodinicourt',
	'FR10338' => 'Saint-Étienne-sous-Barbuise',
	'FR10339' => 'Saint-Flavy',
	'FR10340' => 'Saint-Germain',
	'FR10341' => 'Saint-Hilaire-sous-Romilly',
	'FR10342' => 'Saint-Jean-de-Bonneval',
	'FR10343' => 'Saint-Julien-les-Villas',
	'FR10344' => 'Saint-Léger-près-Troyes',
	'FR10345' => 'Saint-Léger-sous-Brienne',
	'FR10346' => 'Saint-Léger-sous-Margerie',
	'FR10347' => 'Saint-Loup-de-Buffigny',
	'FR10348' => 'Saint-Lupien',
	'FR10349' => 'Saint-Lyé',
	'FR10350' => 'Saint-Mards-en-Othe',
	'FR10351' => 'Saint-Martin-de-Bossenay',
	'FR10352' => 'Sainte-Maure',
	'FR10353' => 'Saint-Mesmin',
	'FR10354' => 'Saint-Nabord-sur-Aube',
	'FR10355' => 'Saint-Nicolas-la-Chapelle',
	'FR10356' => 'Saint-Oulph',
	'FR10357' => 'Saint-Parres-aux-Tertres',
	'FR10358' => 'Saint-Parres-lès-Vaudes',
	'FR10359' => 'Saint-Phal',
	'FR10360' => 'Saint-Pouange',
	'FR10361' => 'Saint-Remy-sous-Barbuise',
	'FR10362' => 'Sainte-Savine',
	'FR10363' => 'Saint-Thibault',
	'FR10364' => 'Saint-Usage',
	'FR10365' => 'Salon',
	'FR10366' => 'Saulcy',
	'FR10367' => 'La Saulsotte',
	'FR10368' => 'Savières',
	'FR10369' => 'Semoine',
	'FR10370' => 'Soligny-les-Étangs',
	'FR10371' => 'Sommeval',
	'FR10372' => 'Soulaines-Dhuys',
	'FR10373' => 'Souligny',
	'FR10374' => 'Spoy',
	'FR10375' => 'Thennelières',
	'FR10376' => 'Thieffrain',
	'FR10377' => 'Thil',
	'FR10378' => 'Thors',
	'FR10379' => 'Torcy-le-Grand',
	'FR10380' => 'Torcy-le-Petit',
	'FR10381' => 'Torvilliers',
	'FR10382' => 'Traînel',
	'FR10383' => 'Trancault',
	'FR10384' => 'Trannes',
	'FR10386' => 'Trouans',
	'FR10387' => 'Troyes',
	'FR10388' => 'Turgy',
	'FR10389' => 'Unienville',
	'FR10390' => 'Urville',
	'FR10391' => 'Vailly',
	'FR10392' => 'Vallant-Saint-Georges',
	'FR10393' => 'Vallentigny',
	'FR10394' => 'Vallières',
	'FR10395' => 'Vanlay',
	'FR10396' => 'Vauchassis',
	'FR10397' => 'Vauchonvilliers',
	'FR10398' => 'Vaucogne',
	'FR10399' => 'Vaudes',
	'FR10400' => 'Vaupoisson',
	'FR10401' => 'Vendeuvre-sur-Barse',
	'FR10402' => 'La Vendue-Mignot',
	'FR10403' => 'Vernonvilliers',
	'FR10404' => 'Verpillières-sur-Ource',
	'FR10405' => 'Verricourt',
	'FR10406' => 'Verrières',
	'FR10408' => 'Viâpres-le-Petit',
	'FR10409' => 'Villacerf',
	'FR10410' => 'Villadin',
	'FR10411' => 'La Ville-aux-Bois',
	'FR10412' => 'Villechétif',
	'FR10414' => 'Villeloup',
	'FR10416' => 'Villemereuil',
	'FR10417' => 'Villemoiron-en-Othe',
	'FR10418' => 'Villemorien',
	'FR10419' => 'Villemoyenne',
	'FR10420' => 'Villenauxe-la-Grande',
	'FR10421' => 'La Villeneuve-au-Châtelot',
	'FR10422' => 'Villeneuve-au-Chemin',
	'FR10423' => 'La Villeneuve-au-Chêne',
	'FR10424' => 'Villeret',
	'FR10425' => 'Villery',
	'FR10426' => 'Ville-sous-la-Ferté',
	'FR10427' => 'Ville-sur-Arce',
	'FR10428' => 'Ville-sur-Terre',
	'FR10429' => 'Villette-sur-Aube',
	'FR10430' => 'Villiers-Herbisse',
	'FR10431' => 'Villiers-le-Bois',
	'FR10432' => 'Villiers-sous-Praslin',
	'FR10433' => 'Villy-en-Trodes',
	'FR10434' => 'Villy-le-Bois',
	'FR10435' => 'Villy-le-Maréchal',
	'FR10436' => 'Vinets',
	'FR10437' => 'Virey-sous-Bar',
	'FR10438' => 'Vitry-le-Croisé',
	'FR10439' => 'Viviers-sur-Artaut',
	'FR10440' => 'Voigny',
	'FR10441' => 'Vosnon',
	'FR10442' => 'Voué',
	'FR10443' => 'Vougrey',
	'FR10444' => 'Vulaines',
	'FR10445' => 'Yèvres-le-Petit',
	'FR11001' => 'Aigues-Vives',
	'FR11002' => 'Airoux',
	'FR11003' => 'Ajac',
	'FR11004' => 'Alaigne',
	'FR11005' => 'Alairac',
	'FR11006' => 'Albas',
	'FR11007' => 'Albières',
	'FR11008' => 'Alet-les-Bains',
	'FR11009' => 'Alzonne',
	'FR11010' => 'Antugnac',
	'FR11011' => 'Aragon',
	'FR11012' => 'Argeliers',
	'FR11013' => 'Argens-Minervois',
	'FR11014' => 'Armissan',
	'FR11015' => 'Arques',
	'FR11016' => 'Arquettes-en-Val',
	'FR11017' => 'Artigues',
	'FR11018' => 'Arzens',
	'FR11019' => 'Aunat',
	'FR11020' => 'Auriac',
	'FR11021' => 'Axat',
	'FR11022' => 'Azille',
	'FR11023' => 'Badens',
	'FR11024' => 'Bages',
	'FR11025' => 'Bagnoles',
	'FR11026' => 'Baraigne',
	'FR11027' => 'Barbaira',
	'FR11028' => 'Belcaire',
	'FR11029' => 'Belcastel-et-Buc',
	'FR11030' => 'Belflou',
	'FR11031' => 'Belfort-sur-Rebenty',
	'FR11032' => 'Bellegarde-du-Razès',
	'FR11033' => 'Belpech',
	'FR11034' => 'Belvèze-du-Razès',
	'FR11035' => 'Belvianes-et-Cavirac',
	'FR11036' => 'Belvis',
	'FR11037' => 'Berriac',
	'FR11038' => 'Bessède-de-Sault',
	'FR11039' => 'La Bezole',
	'FR11040' => 'Bizanet',
	'FR11041' => 'Bize-Minervois',
	'FR11042' => 'Blomac',
	'FR11043' => 'Bouilhonnac',
	'FR11044' => 'Bouisse',
	'FR11045' => 'Bouriège',
	'FR11046' => 'Bourigeole',
	'FR11047' => 'Le Bousquet',
	'FR11048' => 'Boutenac',
	'FR11049' => 'Bram',
	'FR11051' => 'Brézilhac',
	'FR11052' => 'Brousses-et-Villaret',
	'FR11053' => 'Brugairolles',
	'FR11054' => 'Les Brunels',
	'FR11055' => 'Bugarach',
	'FR11056' => 'Cabrespine',
	'FR11057' => 'Cahuzac',
	'FR11058' => 'Cailhau',
	'FR11059' => 'Cailhavel',
	'FR11060' => 'Cailla',
	'FR11061' => 'Cambieure',
	'FR11062' => 'Campagna-de-Sault',
	'FR11063' => 'Campagne-sur-Aude',
	'FR11064' => 'Camplong-dAude',
	'FR11065' => 'Camps-sur-lAgly',
	'FR11066' => 'Camurac',
	'FR11067' => 'Canet',
	'FR11068' => 'Capendu',
	'FR11069' => 'Carcassonne',
	'FR11070' => 'Carlipa',
	'FR11071' => 'Cascastel-des-Corbières',
	'FR11072' => 'La Cassaigne',
	'FR11073' => 'Cassaignes',
	'FR11074' => 'Les Cassés',
	'FR11075' => 'Castans',
	'FR11076' => 'Castelnaudary',
	'FR11077' => 'Castelnau-dAude',
	'FR11078' => 'Castelreng',
	'FR11079' => 'Caudebronde',
	'FR11080' => 'Val de Lambronne',
	'FR11081' => 'Caunes-Minervois',
	'FR11082' => 'Caunette-sur-Lauquet',
	'FR11083' => 'Caunettes-en-Val',
	'FR11084' => 'Caux-et-Sauzens',
	'FR11085' => 'Cavanac',
	'FR11086' => 'Caves',
	'FR11087' => 'Cazalrenoux',
	'FR11088' => 'Cazilhac',
	'FR11089' => 'Cenne-Monestiés',
	'FR11090' => 'Cépie',
	'FR11091' => 'Chalabre',
	'FR11092' => 'Citou',
	'FR11093' => 'Le Clat',
	'FR11094' => 'Clermont-sur-Lauquet',
	'FR11095' => 'Comigne',
	'FR11096' => 'Comus',
	'FR11098' => 'Conilhac-Corbières',
	'FR11099' => 'Conques-sur-Orbiel',
	'FR11100' => 'Corbières',
	'FR11101' => 'Coudons',
	'FR11102' => 'Couffoulens',
	'FR11103' => 'Couiza',
	'FR11104' => 'Counozouls',
	'FR11105' => 'Cournanel',
	'FR11106' => 'Coursan',
	'FR11107' => 'Courtauly',
	'FR11108' => 'La Courtète',
	'FR11109' => 'Coustaussa',
	'FR11110' => 'Coustouge',
	'FR11111' => 'Cruscades',
	'FR11112' => 'Cubières-sur-Cinoble',
	'FR11113' => 'Cucugnan',
	'FR11114' => 'Cumiès',
	'FR11115' => 'Cuxac-Cabardès',
	'FR11116' => 'Cuxac-dAude',
	'FR11117' => 'Davejean',
	'FR11118' => 'Dernacueillette',
	'FR11119' => 'La Digne-dAmont',
	'FR11120' => 'La Digne-dAval',
	'FR11121' => 'Donazac',
	'FR11122' => 'Douzens',
	'FR11123' => 'Duilhac-sous-Peyrepertuse',
	'FR11124' => 'Durban-Corbières',
	'FR11125' => 'Embres-et-Castelmaure',
	'FR11126' => 'Escales',
	'FR11127' => 'Escouloubre',
	'FR11128' => 'Escueillens-et-Saint-Just-de-Bélengard',
	'FR11129' => 'Espéraza',
	'FR11130' => 'Espezel',
	'FR11131' => 'Val-du-Faby',
	'FR11132' => 'Fabrezan',
	'FR11133' => 'Fajac-en-Val',
	'FR11134' => 'Fajac-la-Relenque',
	'FR11135' => 'La Fajolle',
	'FR11136' => 'Fanjeaux',
	'FR11137' => 'Félines-Termenès',
	'FR11138' => 'Fendeille',
	'FR11139' => 'Fenouillet-du-Razès',
	'FR11140' => 'Ferrals-les-Corbières',
	'FR11141' => 'Ferran',
	'FR11142' => 'Festes-et-Saint-André',
	'FR11143' => 'Feuilla',
	'FR11144' => 'Fitou',
	'FR11145' => 'Fleury',
	'FR11146' => 'Floure',
	'FR11147' => 'Fontanès-de-Sault',
	'FR11148' => 'Fontcouverte',
	'FR11149' => 'Fonters-du-Razès',
	'FR11150' => 'Fontiers-Cabardès',
	'FR11151' => 'Fontiès-dAude',
	'FR11152' => 'Fontjoncouse',
	'FR11153' => 'La Force',
	'FR11154' => 'Fournes-Cabardès',
	'FR11155' => 'Fourtou',
	'FR11156' => 'Fraisse-Cabardès',
	'FR11157' => 'Fraissé-des-Corbières',
	'FR11158' => 'Gaja-et-Villedieu',
	'FR11159' => 'Gaja-la-Selve',
	'FR11160' => 'Galinagues',
	'FR11161' => 'Gardie',
	'FR11162' => 'Generville',
	'FR11163' => 'Gincla',
	'FR11164' => 'Ginestas',
	'FR11165' => 'Ginoles',
	'FR11166' => 'Gourvieille',
	'FR11167' => 'Gramazie',
	'FR11168' => 'Granès',
	'FR11169' => 'Greffeil',
	'FR11170' => 'Gruissan',
	'FR11172' => 'Homps',
	'FR11173' => 'Hounoux',
	'FR11174' => 'Les Ilhes',
	'FR11175' => 'Issel',
	'FR11176' => 'Jonquières',
	'FR11177' => 'Joucou',
	'FR11178' => 'Labastide-dAnjou',
	'FR11179' => 'Labastide-en-Val',
	'FR11180' => 'Labastide-Esparbairenque',
	'FR11181' => 'Labécède-Lauragais',
	'FR11182' => 'Lacombe',
	'FR11183' => 'Ladern-sur-Lauquet',
	'FR11184' => 'Lafage',
	'FR11185' => 'Lagrasse',
	'FR11186' => 'Lairière',
	'FR11187' => 'Lanet',
	'FR11188' => 'La Palme',
	'FR11189' => 'Laprade',
	'FR11190' => 'La Redorte',
	'FR11191' => 'Laroque-de-Fa',
	'FR11192' => 'Lasbordes',
	'FR11193' => 'Lasserre-de-Prouille',
	'FR11194' => 'Lastours',
	'FR11195' => 'Laurabuc',
	'FR11196' => 'Laurac',
	'FR11197' => 'Lauraguel',
	'FR11198' => 'Laure-Minervois',
	'FR11199' => 'Lavalette',
	'FR11200' => 'Lespinassière',
	'FR11201' => 'Leuc',
	'FR11202' => 'Leucate',
	'FR11203' => 'Lézignan-Corbières',
	'FR11204' => 'Lignairolles',
	'FR11205' => 'Limousis',
	'FR11206' => 'Limoux',
	'FR11207' => 'Loupia',
	'FR11208' => 'La Louvière-Lauragais',
	'FR11209' => 'Luc-sur-Aude',
	'FR11210' => 'Luc-sur-Orbieu',
	'FR11211' => 'Magrie',
	'FR11212' => 'Mailhac',
	'FR11213' => 'Maisons',
	'FR11214' => 'Malras',
	'FR11215' => 'Malves-en-Minervois',
	'FR11216' => 'Malviès',
	'FR11217' => 'Marcorignan',
	'FR11218' => 'Marquein',
	'FR11219' => 'Marsa',
	'FR11220' => 'Marseillette',
	'FR11221' => 'Les Martys',
	'FR11222' => 'Mas-Cabardès',
	'FR11223' => 'Mas-des-Cours',
	'FR11224' => 'Massac',
	'FR11225' => 'Mas-Saintes-Puelles',
	'FR11226' => 'Mayreville',
	'FR11227' => 'Mayronnes',
	'FR11228' => 'Mazerolles-du-Razès',
	'FR11229' => 'Mazuby',
	'FR11230' => 'Mérial',
	'FR11231' => 'Mézerville',
	'FR11232' => 'Miraval-Cabardès',
	'FR11233' => 'Mirepeisset',
	'FR11234' => 'Mireval-Lauragais',
	'FR11235' => 'Missègre',
	'FR11236' => 'Molandier',
	'FR11238' => 'Molleville',
	'FR11239' => 'Montauriol',
	'FR11240' => 'Montazels',
	'FR11241' => 'Montbrun-des-Corbières',
	'FR11242' => 'Montclar',
	'FR11243' => 'Montferrand',
	'FR11244' => 'Montfort-sur-Boulzane',
	'FR11245' => 'Montgaillard',
	'FR11246' => 'Montgradail',
	'FR11247' => 'Monthaut',
	'FR11248' => 'Montirat',
	'FR11249' => 'Montjardin',
	'FR11250' => 'Montjoi',
	'FR11251' => 'Val-de-Dagne',
	'FR11252' => 'Montmaur',
	'FR11253' => 'Montolieu',
	'FR11254' => 'Montréal',
	'FR11255' => 'Montredon-des-Corbières',
	'FR11256' => 'Montséret',
	'FR11257' => 'Monze',
	'FR11258' => 'Moussan',
	'FR11259' => 'Moussoulens',
	'FR11260' => 'Mouthoumet',
	'FR11261' => 'Moux',
	'FR11262' => 'Narbonne',
	'FR11263' => 'Nébias',
	'FR11264' => 'Névian',
	'FR11265' => 'Niort-de-Sault',
	'FR11266' => 'Port-la-Nouvelle',
	'FR11267' => 'Ornaisons',
	'FR11268' => 'Orsans',
	'FR11269' => 'Ouveillan',
	'FR11270' => 'Padern',
	'FR11271' => 'Palairac',
	'FR11272' => 'Palaja',
	'FR11273' => 'Paraza',
	'FR11274' => 'Pauligne',
	'FR11275' => 'Payra-sur-lHers',
	'FR11276' => 'Paziols',
	'FR11277' => 'Pécharic-et-le-Py',
	'FR11278' => 'Pech-Luna',
	'FR11279' => 'Pennautier',
	'FR11280' => 'Pépieux',
	'FR11281' => 'Pexiora',
	'FR11282' => 'Peyrefitte-du-Razès',
	'FR11283' => 'Peyrefitte-sur-lHers',
	'FR11284' => 'Peyrens',
	'FR11285' => 'Peyriac-de-Mer',
	'FR11286' => 'Peyriac-Minervois',
	'FR11287' => 'Peyrolles',
	'FR11288' => 'Pezens',
	'FR11289' => 'Pieusse',
	'FR11290' => 'Plaigne',
	'FR11291' => 'Plavilla',
	'FR11292' => 'La Pomarède',
	'FR11293' => 'Pomas',
	'FR11294' => 'Pomy',
	'FR11295' => 'Portel-des-Corbières',
	'FR11296' => 'Pouzols-Minervois',
	'FR11297' => 'Pradelles-Cabardès',
	'FR11299' => 'Preixan',
	'FR11300' => 'Puginier',
	'FR11301' => 'Puichéric',
	'FR11302' => 'Puilaurens',
	'FR11303' => 'Puivert',
	'FR11304' => 'Quillan',
	'FR11305' => 'Quintillan',
	'FR11306' => 'Quirbajou',
	'FR11307' => 'Raissac-dAude',
	'FR11308' => 'Raissac-sur-Lampy',
	'FR11309' => 'Rennes-le-Château',
	'FR11310' => 'Rennes-les-Bains',
	'FR11311' => 'Ribaute',
	'FR11312' => 'Ribouisse',
	'FR11313' => 'Ricaud',
	'FR11314' => 'Rieux-en-Val',
	'FR11315' => 'Rieux-Minervois',
	'FR11316' => 'Rivel',
	'FR11317' => 'Rodome',
	'FR11318' => 'Roquecourbe-Minervois',
	'FR11319' => 'Roquefère',
	'FR11320' => 'Roquefeuil',
	'FR11321' => 'Roquefort-de-Sault',
	'FR11322' => 'Roquefort-des-Corbières',
	'FR11323' => 'Roquetaillade-et-Conilhac',
	'FR11324' => 'Roubia',
	'FR11325' => 'Rouffiac-dAude',
	'FR11326' => 'Rouffiac-des-Corbières',
	'FR11327' => 'Roullens',
	'FR11328' => 'Routier',
	'FR11330' => 'Rustiques',
	'FR11331' => 'Saint-Amans',
	'FR11332' => 'Saint-André-de-Roquelongue',
	'FR11333' => 'Saint-Benoît',
	'FR11334' => 'Sainte-Camelle',
	'FR11335' => 'Sainte-Colombe-sur-Guette',
	'FR11336' => 'Sainte-Colombe-sur-lHers',
	'FR11337' => 'Saint-Couat-dAude',
	'FR11338' => 'Saint-Couat-du-Razès',
	'FR11339' => 'Saint-Denis',
	'FR11340' => 'Sainte-Eulalie',
	'FR11341' => 'Saint-Ferriol',
	'FR11342' => 'Saint-Frichoux',
	'FR11343' => 'Saint-Gaudéric',
	'FR11344' => 'Saint-Hilaire',
	'FR11345' => 'Saint-Jean-de-Barrou',
	'FR11346' => 'Saint-Jean-de-Paracol',
	'FR11347' => 'Saint-Julia-de-Bec',
	'FR11348' => 'Saint-Julien-de-Briola',
	'FR11350' => 'Saint-Just-et-le-Bézu',
	'FR11351' => 'Saint-Laurent-de-la-Cabrerisse',
	'FR11352' => 'Saint-Louis-et-Parahou',
	'FR11353' => 'Saint-Marcel-sur-Aude',
	'FR11354' => 'Saint-Martin-des-Puits',
	'FR11355' => 'Saint-Martin-de-Villereglan',
	'FR11356' => 'Saint-Martin-Lalande',
	'FR11357' => 'Saint-Martin-le-Vieil',
	'FR11358' => 'Saint-Martin-Lys',
	'FR11359' => 'Saint-Michel-de-Lanès',
	'FR11360' => 'Saint-Nazaire-dAude',
	'FR11361' => 'Saint-Papoul',
	'FR11362' => 'Saint-Paulet',
	'FR11363' => 'Saint-Pierre-des-Champs',
	'FR11364' => 'Saint-Polycarpe',
	'FR11365' => 'Saint-Sernin',
	'FR11366' => 'Sainte-Valière',
	'FR11367' => 'Saissac',
	'FR11368' => 'Sallèles-Cabardès',
	'FR11369' => 'Sallèles-dAude',
	'FR11370' => 'Salles-dAude',
	'FR11371' => 'Salles-sur-lHers',
	'FR11372' => 'Salsigne',
	'FR11373' => 'Salvezines',
	'FR11374' => 'Salza',
	'FR11375' => 'Seignalens',
	'FR11376' => 'La Serpent',
	'FR11377' => 'Serres',
	'FR11378' => 'Serviès-en-Val',
	'FR11379' => 'Sigean',
	'FR11380' => 'Sonnac-sur-lHers',
	'FR11381' => 'Sougraigne',
	'FR11382' => 'Souilhanels',
	'FR11383' => 'Souilhe',
	'FR11384' => 'Soulatgé',
	'FR11385' => 'Soupex',
	'FR11386' => 'Talairan',
	'FR11387' => 'Taurize',
	'FR11388' => 'Termes',
	'FR11389' => 'Terroles',
	'FR11390' => 'Thézan-des-Corbières',
	'FR11391' => 'La Tourette-Cabardès',
	'FR11392' => 'Tournissan',
	'FR11393' => 'Tourouzelle',
	'FR11394' => 'Tourreilles',
	'FR11395' => 'Trassanel',
	'FR11396' => 'Trausse',
	'FR11397' => 'Trèbes',
	'FR11398' => 'Treilles',
	'FR11399' => 'Tréville',
	'FR11400' => 'Tréziers',
	'FR11401' => 'Tuchan',
	'FR11402' => 'Valmigère',
	'FR11404' => 'Ventenac-Cabardès',
	'FR11405' => 'Ventenac-en-Minervois',
	'FR11406' => 'Véraza',
	'FR11407' => 'Verdun-en-Lauragais',
	'FR11408' => 'Verzeille',
	'FR11409' => 'Vignevieille',
	'FR11410' => 'Villalier',
	'FR11411' => 'Villanière',
	'FR11412' => 'Villardebelle',
	'FR11413' => 'Villardonnel',
	'FR11414' => 'Villar-en-Val',
	'FR11415' => 'Villar-Saint-Anselme',
	'FR11416' => 'Villarzel-Cabardès',
	'FR11417' => 'Villarzel-du-Razès',
	'FR11418' => 'Villasavary',
	'FR11419' => 'Villautou',
	'FR11420' => 'Villebazy',
	'FR11421' => 'Villedaigne',
	'FR11422' => 'Villedubert',
	'FR11423' => 'Villefloure',
	'FR11424' => 'Villefort',
	'FR11425' => 'Villegailhenc',
	'FR11426' => 'Villegly',
	'FR11427' => 'Villelongue-dAude',
	'FR11428' => 'Villemagne',
	'FR11429' => 'Villemoustaussou',
	'FR11430' => 'Villeneuve-la-Comptal',
	'FR11431' => 'Villeneuve-les-Corbières',
	'FR11432' => 'Villeneuve-lès-Montréal',
	'FR11433' => 'Villeneuve-Minervois',
	'FR11434' => 'Villepinte',
	'FR11435' => 'Villerouge-Termenès',
	'FR11436' => 'Villesèque-des-Corbières',
	'FR11437' => 'Villesèquelande',
	'FR11438' => 'Villesiscle',
	'FR11439' => 'Villespy',
	'FR11440' => 'Villetritouls',
	'FR11441' => 'Vinassan',
	'FR12001' => 'Agen-dAveyron',
	'FR12002' => 'Aguessac',
	'FR12003' => 'Les Albres',
	'FR12004' => 'Almont-les-Junies',
	'FR12006' => 'Alrance',
	'FR12007' => 'Ambeyrac',
	'FR12008' => 'Anglars-Saint-Félix',
	'FR12009' => 'Arnac-sur-Dourdou',
	'FR12010' => 'Arques',
	'FR12011' => 'Arvieu',
	'FR12012' => 'Asprières',
	'FR12013' => 'Aubin',
	'FR12015' => 'Auriac-Lagast',
	'FR12016' => 'Auzits',
	'FR12017' => 'Ayssènes',
	'FR12018' => 'Balaguier-dOlt',
	'FR12019' => 'Balaguier-sur-Rance',
	'FR12021' => 'Le Bas Ségala',
	'FR12022' => 'La Bastide-Pradines',
	'FR12023' => 'La Bastide-Solages',
	'FR12024' => 'Belcastel',
	'FR12025' => 'Belmont-sur-Rance',
	'FR12026' => 'Bertholène',
	'FR12027' => 'Bessuéjouls',
	'FR12028' => 'Boisse-Penchot',
	'FR12029' => 'Bor-et-Bar',
	'FR12030' => 'Bouillac',
	'FR12031' => 'Bournazel',
	'FR12032' => 'Boussac',
	'FR12033' => 'Bozouls',
	'FR12034' => 'Brandonnet',
	'FR12035' => 'Brasc',
	'FR12036' => 'Brommat',
	'FR12037' => 'Broquiès',
	'FR12038' => 'Brousse-le-Château',
	'FR12039' => 'Brusque',
	'FR12041' => 'Cabanès',
	'FR12042' => 'Calmels-et-le-Viala',
	'FR12043' => 'Calmont',
	'FR12044' => 'Camarès',
	'FR12045' => 'Camboulazet',
	'FR12046' => 'Camjac',
	'FR12047' => 'Campagnac',
	'FR12048' => 'Campouriez',
	'FR12049' => 'Campuac',
	'FR12050' => 'Canet-de-Salars',
	'FR12051' => 'Cantoin',
	'FR12052' => 'Capdenac-Gare',
	'FR12053' => 'La Capelle-Balaguier',
	'FR12054' => 'La Capelle-Bleys',
	'FR12055' => 'La Capelle-Bonance',
	'FR12056' => 'Baraqueville',
	'FR12057' => 'Cassagnes-Bégonhès',
	'FR12058' => 'Cassuéjouls',
	'FR12059' => 'Castanet',
	'FR12060' => 'Castelmary',
	'FR12061' => 'Castelnau-de-Mandailles',
	'FR12062' => 'Castelnau-Pégayrols',
	'FR12063' => 'La Cavalerie',
	'FR12064' => 'Le Cayrol',
	'FR12065' => 'Centrès',
	'FR12066' => 'Clairvaux-dAveyron',
	'FR12067' => 'Le Clapier',
	'FR12068' => 'Colombiès',
	'FR12069' => 'Combret',
	'FR12070' => 'Compeyre',
	'FR12071' => 'Compolibat',
	'FR12072' => 'Comprégnac',
	'FR12073' => 'Comps-la-Grand-Ville',
	'FR12074' => 'Condom-dAubrac',
	'FR12075' => 'Connac',
	'FR12076' => 'Conques-en-Rouergue',
	'FR12077' => 'Cornus',
	'FR12078' => 'Les Costes-Gozon',
	'FR12079' => 'Coubisou',
	'FR12080' => 'Coupiac',
	'FR12082' => 'La Couvertoirade',
	'FR12083' => 'Cransac',
	'FR12084' => 'Creissels',
	'FR12085' => 'Crespin',
	'FR12086' => 'La Cresse',
	'FR12088' => 'Curières',
	'FR12089' => 'Decazeville',
	'FR12090' => 'Druelle Balsac',
	'FR12091' => 'Drulhe',
	'FR12092' => 'Durenque',
	'FR12093' => 'Le Fel',
	'FR12094' => 'Entraygues-sur-Truyère',
	'FR12095' => 'Escandolières',
	'FR12096' => 'Espalion',
	'FR12097' => 'Espeyrac',
	'FR12098' => 'Estaing',
	'FR12099' => 'Fayet',
	'FR12100' => 'Firmi',
	'FR12101' => 'Flagnac',
	'FR12102' => 'Flavin',
	'FR12103' => 'Florentin-la-Capelle',
	'FR12104' => 'Foissac',
	'FR12105' => 'La Fouillade',
	'FR12106' => 'Gabriac',
	'FR12107' => 'Gaillac-dAveyron',
	'FR12108' => 'Galgan',
	'FR12109' => 'Gissac',
	'FR12110' => 'Golinhac',
	'FR12111' => 'Goutrens',
	'FR12113' => 'Gramond',
	'FR12115' => 'LHospitalet-du-Larzac',
	'FR12116' => 'Huparlac',
	'FR12118' => 'Lacroix-Barrez',
	'FR12119' => 'Laguiole',
	'FR12120' => 'Laissac-Sévérac lÉglise',
	'FR12121' => 'Lanuéjouls',
	'FR12122' => 'Lapanouse-de-Cernon',
	'FR12124' => 'Lassouts',
	'FR12125' => 'Laval-Roquecezière',
	'FR12127' => 'Lédergues',
	'FR12128' => 'Lescure-Jaoul',
	'FR12129' => 'Lestrade-et-Thouels',
	'FR12130' => 'Livinhac-le-Haut',
	'FR12131' => 'La Loubière',
	'FR12133' => 'Luc-la-Primaube',
	'FR12134' => 'Lugan',
	'FR12135' => 'Lunac',
	'FR12136' => 'Maleville',
	'FR12137' => 'Manhac',
	'FR12138' => 'Marcillac-Vallon',
	'FR12139' => 'Marnhagues-et-Latour',
	'FR12140' => 'Martiel',
	'FR12141' => 'Martrin',
	'FR12142' => 'Mayran',
	'FR12143' => 'Mélagues',
	'FR12144' => 'Meljac',
	'FR12145' => 'Millau',
	'FR12146' => 'Le Monastère',
	'FR12147' => 'Montagnol',
	'FR12148' => 'Montbazens',
	'FR12149' => 'Montclar',
	'FR12150' => 'Monteils',
	'FR12151' => 'Montézic',
	'FR12152' => 'Montfranc',
	'FR12153' => 'Montjaux',
	'FR12154' => 'Montlaur',
	'FR12155' => 'Fondamente',
	'FR12156' => 'Montpeyroux',
	'FR12157' => 'Montrozier',
	'FR12158' => 'Montsalès',
	'FR12159' => 'Morlhon-le-Haut',
	'FR12160' => 'Mostuéjouls',
	'FR12161' => 'Mouret',
	'FR12162' => 'Moyrazès',
	'FR12163' => 'Murasson',
	'FR12164' => 'Mur-de-Barrez',
	'FR12165' => 'Muret-le-Château',
	'FR12166' => 'Murols',
	'FR12167' => 'Najac',
	'FR12168' => 'Nant',
	'FR12169' => 'Naucelle',
	'FR12170' => 'Naussac',
	'FR12171' => 'Nauviale',
	'FR12172' => 'Le Nayrac',
	'FR12174' => 'Olemps',
	'FR12175' => 'Ols-et-Rinhodes',
	'FR12176' => 'Onet-le-Château',
	'FR12177' => 'Palmas dAveyron',
	'FR12178' => 'Paulhe',
	'FR12179' => 'Peux-et-Couffouleux',
	'FR12180' => 'Peyreleau',
	'FR12181' => 'Peyrusse-le-Roc',
	'FR12182' => 'Pierrefiche',
	'FR12183' => 'Plaisance',
	'FR12184' => 'Pomayrols',
	'FR12185' => 'Pont-de-Salars',
	'FR12186' => 'Pousthomy',
	'FR12187' => 'Prades-dAubrac',
	'FR12188' => 'Prades-Salars',
	'FR12189' => 'Pradinas',
	'FR12190' => 'Prévinquières',
	'FR12191' => 'Privezac',
	'FR12192' => 'Mounes-Prohencoux',
	'FR12193' => 'Pruines',
	'FR12194' => 'Quins',
	'FR12195' => 'Rebourguil',
	'FR12197' => 'Réquista',
	'FR12198' => 'Rieupeyroux',
	'FR12199' => 'Rignac',
	'FR12200' => 'Rivière-sur-Tarn',
	'FR12201' => 'Rodelle',
	'FR12202' => 'Rodez',
	'FR12203' => 'Roquefort-sur-Soulzon',
	'FR12204' => 'La Roque-Sainte-Marguerite',
	'FR12205' => 'La Rouquette',
	'FR12206' => 'Roussennac',
	'FR12207' => 'Rullac-Saint-Cirq',
	'FR12208' => 'Saint-Affrique',
	'FR12209' => 'Saint-Amans-des-Cots',
	'FR12210' => 'Saint-André-de-Najac',
	'FR12211' => 'Saint-André-de-Vézines',
	'FR12212' => 'Saint-Beaulize',
	'FR12213' => 'Saint-Beauzély',
	'FR12214' => 'Saint-Chély-dAubrac',
	'FR12215' => 'Saint-Christophe-Vallon',
	'FR12216' => 'Saint-Côme-dOlt',
	'FR12217' => 'Sainte-Croix',
	'FR12219' => 'Sainte-Eulalie-dOlt',
	'FR12220' => 'Sainte-Eulalie-de-Cernon',
	'FR12221' => 'Saint-Félix-de-Lunel',
	'FR12222' => 'Saint-Félix-de-Sorgues',
	'FR12223' => 'Argences en Aubrac',
	'FR12224' => 'Saint Geniez dOlt et dAubrac',
	'FR12225' => 'Saint-Georges-de-Luzençon',
	'FR12226' => 'Saint-Hippolyte',
	'FR12227' => 'Saint-Igest',
	'FR12228' => 'Saint-Izaire',
	'FR12229' => 'Saint-Jean-dAlcapiès',
	'FR12230' => 'Saint-Jean-Delnous',
	'FR12231' => 'Saint-Jean-du-Bruel',
	'FR12232' => 'Saint-Jean-et-Saint-Paul',
	'FR12233' => 'Saint-Juéry',
	'FR12234' => 'Sainte-Juliette-sur-Viaur',
	'FR12235' => 'Saint-Just-sur-Viaur',
	'FR12236' => 'Saint-Laurent-de-Lévézou',
	'FR12237' => 'Saint-Laurent-dOlt',
	'FR12238' => 'Saint-Léons',
	'FR12239' => 'Saint-Martin-de-Lenne',
	'FR12240' => 'Saint-Parthem',
	'FR12241' => 'Sainte-Radegonde',
	'FR12242' => 'Saint-Rémy',
	'FR12243' => 'Saint-Rome-de-Cernon',
	'FR12244' => 'Saint-Rome-de-Tarn',
	'FR12246' => 'Saint-Santin',
	'FR12247' => 'Saint-Saturnin-de-Lenne',
	'FR12248' => 'Saint-Sernin-sur-Rance',
	'FR12249' => 'Saint-Sever-du-Moustier',
	'FR12250' => 'Saint-Symphorien-de-Thénières',
	'FR12251' => 'Saint-Victor-et-Melvieu',
	'FR12252' => 'Salles-Courbatiès',
	'FR12253' => 'Salles-Curan',
	'FR12254' => 'Salles-la-Source',
	'FR12255' => 'Salmiech',
	'FR12256' => 'Salvagnac-Cajarc',
	'FR12257' => 'Causse-et-Diège',
	'FR12258' => 'La Salvetat-Peyralès',
	'FR12259' => 'Sanvensa',
	'FR12260' => 'Sauclières',
	'FR12261' => 'Saujac',
	'FR12262' => 'Sauveterre-de-Rouergue',
	'FR12263' => 'Savignac',
	'FR12264' => 'Sébazac-Concourès',
	'FR12265' => 'Sébrazac',
	'FR12266' => 'Ségur',
	'FR12267' => 'La Selve',
	'FR12268' => 'Sénergues',
	'FR12269' => 'La Serre',
	'FR12270' => 'Sévérac dAveyron',
	'FR12272' => 'Sonnac',
	'FR12273' => 'Soulages-Bonneval',
	'FR12274' => 'Sylvanès',
	'FR12275' => 'Tauriac-de-Camarès',
	'FR12276' => 'Tauriac-de-Naucelle',
	'FR12277' => 'Taussac',
	'FR12278' => 'Tayrac',
	'FR12280' => 'Thérondels',
	'FR12281' => 'Toulonjac',
	'FR12282' => 'Tournemire',
	'FR12283' => 'Trémouilles',
	'FR12284' => 'Le Truel',
	'FR12286' => 'Vabres-lAbbaye',
	'FR12287' => 'Vailhourles',
	'FR12288' => 'Valady',
	'FR12289' => 'Valzergues',
	'FR12290' => 'Vaureilles',
	'FR12291' => 'Verrières',
	'FR12292' => 'Versols-et-Lapeyre',
	'FR12293' => 'Veyreau',
	'FR12294' => 'Vézins-de-Lévézou',
	'FR12295' => 'Viala-du-Pas-de-Jaux',
	'FR12296' => 'Viala-du-Tarn',
	'FR12297' => 'Le Vibal',
	'FR12298' => 'Villecomtal',
	'FR12299' => 'Villefranche-de-Panat',
	'FR12300' => 'Villefranche-de-Rouergue',
	'FR12301' => 'Villeneuve',
	'FR12303' => 'Vimenet',
	'FR12305' => 'Viviez',
	'FR12307' => 'Curan',
	'FR13001' => 'Aix-en-Provence',
	'FR13002' => 'Allauch',
	'FR13003' => 'Alleins',
	'FR13004' => 'Arles',
	'FR13005' => 'Aubagne',
	'FR13006' => 'Aureille',
	'FR13007' => 'Auriol',
	'FR13008' => 'Aurons',
	'FR13009' => 'La Barben',
	'FR13010' => 'Barbentane',
	'FR13011' => 'Les Baux-de-Provence',
	'FR13012' => 'Beaurecueil',
	'FR13013' => 'Belcodène',
	'FR13014' => 'Berre-lÉtang',
	'FR13015' => 'Bouc-Bel-Air',
	'FR13016' => 'La Bouilladisse',
	'FR13017' => 'Boulbon',
	'FR13018' => 'Cabannes',
	'FR13019' => 'Cabriès',
	'FR13020' => 'Cadolive',
	'FR13021' => 'Carry-le-Rouet',
	'FR13022' => 'Cassis',
	'FR13023' => 'Ceyreste',
	'FR13024' => 'Charleval',
	'FR13025' => 'Châteauneuf-le-Rouge',
	'FR13026' => 'Châteauneuf-les-Martigues',
	'FR13027' => 'Châteaurenard',
	'FR13028' => 'La Ciotat',
	'FR13029' => 'Cornillon-Confoux',
	'FR13030' => 'Cuges-les-Pins',
	'FR13031' => 'La Destrousse',
	'FR13032' => 'Éguilles',
	'FR13033' => 'Ensuès-la-Redonne',
	'FR13034' => 'Eygalières',
	'FR13035' => 'Eyguières',
	'FR13036' => 'Eyragues',
	'FR13037' => 'La Fare-les-Oliviers',
	'FR13038' => 'Fontvieille',
	'FR13039' => 'Fos-sur-Mer',
	'FR13040' => 'Fuveau',
	'FR13041' => 'Gardanne',
	'FR13042' => 'Gémenos',
	'FR13043' => 'Gignac-la-Nerthe',
	'FR13044' => 'Grans',
	'FR13045' => 'Graveson',
	'FR13046' => 'Gréasque',
	'FR13047' => 'Istres',
	'FR13048' => 'Jouques',
	'FR13049' => 'Lamanon',
	'FR13050' => 'Lambesc',
	'FR13051' => 'Lançon-Provence',
	'FR13052' => 'Maillane',
	'FR13053' => 'Mallemort',
	'FR13054' => 'Marignane',
	'FR13055' => 'Marseille',
	'FR13056' => 'Martigues',
	'FR13057' => 'Mas-Blanc-des-Alpilles',
	'FR13058' => 'Maussane-les-Alpilles',
	'FR13059' => 'Meyrargues',
	'FR13060' => 'Meyreuil',
	'FR13061' => 'Saint-Pierre-de-Mézoargues',
	'FR13062' => 'Mimet',
	'FR13063' => 'Miramas',
	'FR13064' => 'Mollégès',
	'FR13065' => 'Mouriès',
	'FR13066' => 'Noves',
	'FR13067' => 'Orgon',
	'FR13068' => 'Paradou',
	'FR13069' => 'Pélissanne',
	'FR13070' => 'La Penne-sur-Huveaune',
	'FR13071' => 'Les Pennes-Mirabeau',
	'FR13072' => 'Peynier',
	'FR13073' => 'Peypin',
	'FR13074' => 'Peyrolles-en-Provence',
	'FR13075' => 'Plan-de-Cuques',
	'FR13076' => 'Plan-dOrgon',
	'FR13077' => 'Port-de-Bouc',
	'FR13078' => 'Port-Saint-Louis-du-Rhône',
	'FR13079' => 'Puyloubier',
	'FR13080' => 'Le Puy-Sainte-Réparade',
	'FR13081' => 'Rognac',
	'FR13082' => 'Rognes',
	'FR13083' => 'Rognonas',
	'FR13084' => 'La Roque-dAnthéron',
	'FR13085' => 'Roquefort-la-Bédoule',
	'FR13086' => 'Roquevaire',
	'FR13087' => 'Rousset',
	'FR13088' => 'Le Rove',
	'FR13089' => 'Saint-Andiol',
	'FR13090' => 'Saint-Antonin-sur-Bayon',
	'FR13091' => 'Saint-Cannat',
	'FR13092' => 'Saint-Chamas',
	'FR13093' => 'Saint-Estève-Janson',
	'FR13094' => 'Saint-Étienne-du-Grès',
	'FR13095' => 'Saint-Marc-Jaumegarde',
	'FR13096' => 'Saintes-Maries-de-la-Mer',
	'FR13097' => 'Saint-Martin-de-Crau',
	'FR13098' => 'Saint-Mitre-les-Remparts',
	'FR13099' => 'Saint-Paul-lès-Durance',
	'FR13100' => 'Saint-Rémy-de-Provence',
	'FR13101' => 'Saint-Savournin',
	'FR13102' => 'Saint-Victoret',
	'FR13103' => 'Salon-de-Provence',
	'FR13104' => 'Sausset-les-Pins',
	'FR13105' => 'Sénas',
	'FR13106' => 'Septèmes-les-Vallons',
	'FR13107' => 'Simiane-Collongue',
	'FR13108' => 'Tarascon',
	'FR13109' => 'Le Tholonet',
	'FR13110' => 'Trets',
	'FR13111' => 'Vauvenargues',
	'FR13112' => 'Velaux',
	'FR13113' => 'Venelles',
	'FR13114' => 'Ventabren',
	'FR13115' => 'Vernègues',
	'FR13116' => 'Verquières',
	'FR13117' => 'Vitrolles',
	'FR13118' => 'Coudoux',
	'FR13119' => 'Carnoux-en-Provence',
	'FR14001' => 'Ablon',
	'FR14003' => 'Agy',
	'FR14005' => 'Valambray',
	'FR14006' => 'Amayé-sur-Orne',
	'FR14007' => 'Amayé-sur-Seulles',
	'FR14009' => 'Amfreville',
	'FR14011' => 'Aurseulles',
	'FR14012' => 'Angerville',
	'FR14014' => 'Colomby-Anguerny',
	'FR14015' => 'Anisy',
	'FR14016' => 'Annebault',
	'FR14019' => 'Arganchy',
	'FR14020' => 'Argences',
	'FR14021' => 'Arromanches-les-Bains',
	'FR14022' => 'Asnelles',
	'FR14023' => 'Asnières-en-Bessin',
	'FR14024' => 'Auberville',
	'FR14025' => 'Aubigny',
	'FR14026' => 'Audrieu',
	'FR14027' => 'Les Monts dAunay',
	'FR14030' => 'Authie',
	'FR14032' => 'Les Authieux-sur-Calonne',
	'FR14033' => 'Auvillars',
	'FR14034' => 'Avenay',
	'FR14035' => 'Balleroy-sur-Drôme',
	'FR14036' => 'Banneville-la-Campagne',
	'FR14037' => 'Malherbe-sur-Ajon',
	'FR14038' => 'Banville',
	'FR14039' => 'Barbery',
	'FR14040' => 'Barbeville',
	'FR14041' => 'Barneville-la-Bertran',
	'FR14042' => 'Baron-sur-Odon',
	'FR14043' => 'Barou-en-Auge',
	'FR14044' => 'Basly',
	'FR14045' => 'Basseneville',
	'FR14046' => 'Bavent',
	'FR14047' => 'Bayeux',
	'FR14049' => 'Bazenville',
	'FR14050' => 'La Bazoque',
	'FR14053' => 'Beaumais',
	'FR14054' => 'Beaumesnil',
	'FR14055' => 'Beaumont-en-Auge',
	'FR14057' => 'Bellengreville',
	'FR14059' => 'Benerville-sur-Mer',
	'FR14060' => 'Bénouville',
	'FR14061' => 'Souleuvre en Bocage',
	'FR14062' => 'Bény-sur-Mer',
	'FR14063' => 'Bernesq',
	'FR14064' => 'Bernières-dAilly',
	'FR14066' => 'Bernières-sur-Mer',
	'FR14068' => 'Biéville-Beuville',
	'FR14069' => 'Beuvillers',
	'FR14070' => 'Beuvron-en-Auge',
	'FR14076' => 'Blainville-sur-Orne',
	'FR14077' => 'Blangy-le-Château',
	'FR14078' => 'Blay',
	'FR14079' => 'Blonville-sur-Mer',
	'FR14080' => 'Le Bô',
	'FR14082' => 'La Boissière',
	'FR14083' => 'Bonnebosq',
	'FR14084' => 'Bonnemaison',
	'FR14085' => 'Bonneville-la-Louvet',
	'FR14086' => 'Bonneville-sur-Touques',
	'FR14087' => 'Bonnœil',
	'FR14088' => 'Bons-Tassilly',
	'FR14089' => 'Bougy',
	'FR14090' => 'Boulon',
	'FR14091' => 'Bourgeauville',
	'FR14092' => 'Bourguébus',
	'FR14093' => 'Branville',
	'FR14096' => 'Brémoy',
	'FR14097' => 'Bretteville-le-Rabet',
	'FR14098' => 'Thue et Mue',
	'FR14100' => 'Bretteville-sur-Laize',
	'FR14101' => 'Bretteville-sur-Odon',
	'FR14102' => 'Le Breuil-en-Auge',
	'FR14103' => 'Le Breuil-en-Bessin',
	'FR14104' => 'Le Brévedent',
	'FR14106' => 'Bréville-les-Monts',
	'FR14107' => 'Bricqueville',
	'FR14110' => 'Brucourt',
	'FR14111' => 'Bucéels',
	'FR14116' => 'Le Bû-sur-Rouvres',
	'FR14117' => 'Cabourg',
	'FR14118' => 'Caen',
	'FR14119' => 'Cagny',
	'FR14120' => 'Cahagnes',
	'FR14121' => 'Cahagnolles',
	'FR14122' => 'La Caine',
	'FR14123' => 'Cairon',
	'FR14124' => 'La Cambe',
	'FR14125' => 'Cambes-en-Plaine',
	'FR14126' => 'Cambremer',
	'FR14127' => 'Campagnolles',
	'FR14130' => 'Campigny',
	'FR14131' => 'Canapville',
	'FR14132' => 'Canchy',
	'FR14134' => 'Canteloup',
	'FR14135' => 'Carcagny',
	'FR14136' => 'Cardonville',
	'FR14137' => 'Carpiquet',
	'FR14138' => 'Cartigny-lÉpinay',
	'FR14140' => 'Castillon',
	'FR14141' => 'Castillon-en-Auge',
	'FR14143' => 'Caumont-sur-Aure',
	'FR14145' => 'Cauvicourt',
	'FR14146' => 'Cauville',
	'FR14147' => 'Cernay',
	'FR14149' => 'Cesny-aux-Vignes',
	'FR14150' => 'Cesny-les-Sources',
	'FR14159' => 'Chouain',
	'FR14160' => 'Cintheaux',
	'FR14161' => 'Clarbec',
	'FR14162' => 'Clécy',
	'FR14163' => 'Cléville',
	'FR14165' => 'Colleville-sur-Mer',
	'FR14166' => 'Colleville-Montgomery',
	'FR14167' => 'Colombelles',
	'FR14168' => 'Colombières',
	'FR14169' => 'Colombiers-sur-Seulles',
	'FR14171' => 'Combray',
	'FR14172' => 'Commes',
	'FR14173' => 'Condé-sur-Ifs',
	'FR14174' => 'Condé-en-Normandie',
	'FR14175' => 'Condé-sur-Seulles',
	'FR14177' => 'Coquainvilliers',
	'FR14179' => 'Cordebugle',
	'FR14180' => 'Cordey',
	'FR14181' => 'Cormelles-le-Royal',
	'FR14182' => 'Cormolain',
	'FR14183' => 'Cossesseville',
	'FR14184' => 'Cottun',
	'FR14190' => 'Courcy',
	'FR14191' => 'Courseulles-sur-Mer',
	'FR14193' => 'Courtonne-la-Meurdrac',
	'FR14194' => 'Courtonne-les-Deux-Églises',
	'FR14195' => 'Courvaudon',
	'FR14196' => 'Crépon',
	'FR14197' => 'Cresserons',
	'FR14198' => 'Cresseveuille',
	'FR14200' => 'Creully sur Seulles',
	'FR14202' => 'Cricquebœuf',
	'FR14203' => 'Cricqueville-en-Auge',
	'FR14204' => 'Cricqueville-en-Bessin',
	'FR14205' => 'Cristot',
	'FR14206' => 'Crocy',
	'FR14207' => 'Croisilles',
	'FR14209' => 'Crouay',
	'FR14211' => 'Culey-le-Patry',
	'FR14214' => 'Cussy',
	'FR14215' => 'Cuverville',
	'FR14216' => 'Damblainville',
	'FR14218' => 'Danestal',
	'FR14220' => 'Deauville',
	'FR14221' => 'Démouville',
	'FR14223' => 'Le Détroit',
	'FR14224' => 'Deux-Jumeaux',
	'FR14225' => 'Dives-sur-Mer',
	'FR14226' => 'Donnay',
	'FR14227' => 'Douville-en-Auge',
	'FR14228' => 'Douvres-la-Délivrande',
	'FR14229' => 'Dozulé',
	'FR14230' => 'Drubec',
	'FR14231' => 'Beaufour-Druval',
	'FR14232' => 'Ducy-Sainte-Marguerite',
	'FR14236' => 'Ellon',
	'FR14237' => 'Émiéville',
	'FR14238' => 'Englesqueville-en-Auge',
	'FR14239' => 'Englesqueville-la-Percée',
	'FR14240' => 'Épaney',
	'FR14241' => 'Épinay-sur-Odon',
	'FR14242' => 'Épron',
	'FR14243' => 'Équemauville',
	'FR14244' => 'Eraines',
	'FR14245' => 'Ernes',
	'FR14246' => 'Escoville',
	'FR14248' => 'Espins',
	'FR14249' => 'Esquay-Notre-Dame',
	'FR14250' => 'Esquay-sur-Seulles',
	'FR14251' => 'Esson',
	'FR14252' => 'Estrées-la-Campagne',
	'FR14254' => 'Éterville',
	'FR14256' => 'Étréham',
	'FR14257' => 'Évrecy',
	'FR14258' => 'Falaise',
	'FR14260' => 'Fauguernon',
	'FR14261' => 'Le Faulq',
	'FR14266' => 'Feuguerolles-Bully',
	'FR14269' => 'Fierville-les-Parcs',
	'FR14270' => 'Firfol',
	'FR14271' => 'Fleury-sur-Orne',
	'FR14272' => 'La Folie',
	'FR14273' => 'La Folletière-Abenon',
	'FR14274' => 'Fontaine-Étoupefour',
	'FR14275' => 'Fontaine-Henry',
	'FR14276' => 'Fontaine-le-Pin',
	'FR14277' => 'Fontenay-le-Marmion',
	'FR14278' => 'Fontenay-le-Pesnel',
	'FR14280' => 'Formentin',
	'FR14281' => 'Formigny La Bataille',
	'FR14282' => 'Foulognes',
	'FR14283' => 'Fourches',
	'FR14284' => 'Fourneaux-le-Val',
	'FR14285' => 'Le Fournet',
	'FR14286' => 'Fourneville',
	'FR14287' => 'Frénouville',
	'FR14288' => 'Le Fresne-Camilly',
	'FR14289' => 'Fresné-la-Mère',
	'FR14290' => 'Fresney-le-Puceux',
	'FR14291' => 'Fresney-le-Vieux',
	'FR14293' => 'Fumichon',
	'FR14297' => 'Gavrus',
	'FR14298' => 'Géfosse-Fontenay',
	'FR14299' => 'Genneville',
	'FR14300' => 'Gerrots',
	'FR14301' => 'Giberville',
	'FR14302' => 'Glanville',
	'FR14303' => 'Glos',
	'FR14304' => 'Gonneville-sur-Honfleur',
	'FR14305' => 'Gonneville-sur-Mer',
	'FR14306' => 'Gonneville-en-Auge',
	'FR14308' => 'Goustranville',
	'FR14309' => 'Gouvix',
	'FR14310' => 'Grainville-Langannerie',
	'FR14311' => 'Grainville-sur-Odon',
	'FR14312' => 'Grandcamp-Maisy',
	'FR14316' => 'Grangues',
	'FR14318' => 'Graye-sur-Mer',
	'FR14319' => 'Grentheville',
	'FR14320' => 'Grimbosq',
	'FR14322' => 'Guéron',
	'FR14325' => 'Hermanville-sur-Mer',
	'FR14326' => 'Hermival-les-Vaux',
	'FR14327' => 'Hérouville-Saint-Clair',
	'FR14328' => 'Hérouvillette',
	'FR14329' => 'Heuland',
	'FR14332' => 'La Hoguette',
	'FR14333' => 'Honfleur',
	'FR14334' => 'LHôtellerie',
	'FR14335' => 'Hotot-en-Auge',
	'FR14336' => 'Hottot-les-Bagues',
	'FR14337' => 'La Houblonnière',
	'FR14338' => 'Houlgate',
	'FR14341' => 'Ifs',
	'FR14342' => 'Isigny-sur-Mer',
	'FR14343' => 'Les Isles-Bardel',
	'FR14344' => 'Janville',
	'FR14345' => 'Jort',
	'FR14346' => 'Juaye-Mondaye',
	'FR14347' => 'Dialan sur Chaîne',
	'FR14348' => 'Juvigny-sur-Seulles',
	'FR14349' => 'Laize-Clinchamps',
	'FR14352' => 'Landelles-et-Coupigny',
	'FR14353' => 'Landes-sur-Ajon',
	'FR14354' => 'Langrune-sur-Mer',
	'FR14355' => 'Ponts sur Seulles',
	'FR14357' => 'Terres de Druance',
	'FR14358' => 'Léaupartie',
	'FR14360' => 'Leffard',
	'FR14362' => 'Lessard-et-le-Chêne',
	'FR14364' => 'Lingèvres',
	'FR14365' => 'Lion-sur-Mer',
	'FR14366' => 'Lisieux',
	'FR14367' => 'Lison',
	'FR14368' => 'Lisores',
	'FR14369' => 'Litteau',
	'FR14370' => 'Le Molay-Littry',
	'FR14371' => 'Livarot-Pays-dAuge',
	'FR14374' => 'Les Loges',
	'FR14375' => 'Les Loges-Saulces',
	'FR14377' => 'Longues-sur-Mer',
	'FR14378' => 'Longueville',
	'FR14379' => 'Longvillers',
	'FR14380' => 'Loucelles',
	'FR14381' => 'Louvagny',
	'FR14383' => 'Louvigny',
	'FR14384' => 'Luc-sur-Mer',
	'FR14385' => 'Magny-en-Bessin',
	'FR14389' => 'Maisoncelles-Pelvey',
	'FR14390' => 'Maisoncelles-sur-Ajon',
	'FR14391' => 'Maisons',
	'FR14393' => 'Maizet',
	'FR14394' => 'Maizières',
	'FR14396' => 'Maltot',
	'FR14397' => 'Mandeville-en-Bessin',
	'FR14398' => 'Manerbe',
	'FR14399' => 'Manneville-la-Pipard',
	'FR14400' => 'Le Manoir',
	'FR14401' => 'Manvieux',
	'FR14402' => 'Le Marais-la-Chapelle',
	'FR14403' => 'Marolles',
	'FR14404' => 'Martainville',
	'FR14405' => 'Martigny-sur-lAnte',
	'FR14406' => 'Moulins en Bessin',
	'FR14407' => 'Mathieu',
	'FR14408' => 'May-sur-Orne',
	'FR14409' => 'Merville-Franceville-Plage',
	'FR14410' => 'Méry-Bissières-en-Auge',
	'FR14411' => 'Meslay',
	'FR14412' => 'Le Mesnil-au-Grain',
	'FR14419' => 'Le Mesnil-Eudes',
	'FR14421' => 'Le Mesnil-Guillaume',
	'FR14424' => 'Le Mesnil-Robert',
	'FR14425' => 'Le Mesnil-Simon',
	'FR14426' => 'Le Mesnil-sur-Blangy',
	'FR14427' => 'Le Mesnil-Villement',
	'FR14430' => 'Meuvaines',
	'FR14431' => 'Mézidon Vallée dAuge',
	'FR14435' => 'Les Monceaux',
	'FR14436' => 'Monceaux-en-Bessin',
	'FR14437' => 'Mondeville',
	'FR14438' => 'Mondrainville',
	'FR14439' => 'Monfréville',
	'FR14445' => 'Montfiquet',
	'FR14446' => 'Montigny',
	'FR14448' => 'Montreuil-en-Auge',
	'FR14449' => 'Monts-en-Bessin',
	'FR14452' => 'Morteaux-Coulibœuf',
	'FR14453' => 'Mosles',
	'FR14454' => 'Mouen',
	'FR14455' => 'Moulines',
	'FR14456' => 'Moult-Chicheboville',
	'FR14457' => 'Les Moutiers-en-Auge',
	'FR14458' => 'Les Moutiers-en-Cinglais',
	'FR14460' => 'Moyaux',
	'FR14461' => 'Mutrécy',
	'FR14465' => 'Nonant',
	'FR14466' => 'Norolles',
	'FR14467' => 'Noron-lAbbaye',
	'FR14468' => 'Noron-la-Poterie',
	'FR14469' => 'Norrey-en-Auge',
	'FR14473' => 'Notre-Dame-de-Livaye',
	'FR14474' => 'Notre-Dame-dEstrées-Corbon',
	'FR14475' => 'Val dArry',
	'FR14476' => 'Olendon',
	'FR14478' => 'Orbec',
	'FR14480' => 'Osmanville',
	'FR14482' => 'Ouézy',
	'FR14483' => 'Ouffières',
	'FR14484' => 'Ouilly-du-Houley',
	'FR14486' => 'Ouilly-le-Tesson',
	'FR14487' => 'Ouilly-le-Vicomte',
	'FR14488' => 'Ouistreham',
	'FR14491' => 'Parfouru-sur-Odon',
	'FR14492' => 'Pennedepie',
	'FR14494' => 'Périers-en-Auge',
	'FR14495' => 'Périers-sur-le-Dan',
	'FR14496' => 'Périgny',
	'FR14497' => 'Perrières',
	'FR14498' => 'Pertheville-Ners',
	'FR14499' => 'Petiville',
	'FR14500' => 'Pierrefitte-en-Auge',
	'FR14501' => 'Pierrefitte-en-Cinglais',
	'FR14502' => 'Pierrepont',
	'FR14504' => 'Le Pin',
	'FR14506' => 'Planquery',
	'FR14509' => 'Plumetot',
	'FR14510' => 'La Pommeraye',
	'FR14511' => 'Pont-Bellanger',
	'FR14512' => 'Pontécoulant',
	'FR14514' => 'Pont-lÉvêque',
	'FR14515' => 'Port-en-Bessin-Huppain',
	'FR14516' => 'Potigny',
	'FR14519' => 'Préaux-Bocage',
	'FR14520' => 'Le Pré-dAuge',
	'FR14522' => 'Prêtreville',
	'FR14524' => 'Putot-en-Auge',
	'FR14527' => 'Belle Vie en Auge',
	'FR14528' => 'Quetteville',
	'FR14529' => 'Ranchy',
	'FR14530' => 'Ranville',
	'FR14531' => 'Rapilly',
	'FR14533' => 'Repentigny',
	'FR14534' => 'Reux',
	'FR14535' => 'Reviers',
	'FR14536' => 'La Rivière-Saint-Sauveur',
	'FR14538' => 'Castine-en-Plaine',
	'FR14540' => 'Rocques',
	'FR14541' => 'La Roque-Baignard',
	'FR14542' => 'Rosel',
	'FR14543' => 'Rots',
	'FR14546' => 'Rouvres',
	'FR14547' => 'Rubercy',
	'FR14550' => 'Rumesnil',
	'FR14552' => 'Ryes',
	'FR14554' => 'Le Castelet',
	'FR14555' => 'Saint-André-dHébertot',
	'FR14556' => 'Saint-André-sur-Orne',
	'FR14557' => 'Saint-Arnoult',
	'FR14558' => 'Saint-Aubin-dArquenay',
	'FR14559' => 'Saint-Aubin-des-Bois',
	'FR14562' => 'Saint-Aubin-sur-Mer',
	'FR14563' => 'Saint-Benoît-dHébertot',
	'FR14565' => 'Saint-Côme-de-Fresné',
	'FR14566' => 'Saint-Contest',
	'FR14569' => 'Sainte-Croix-sur-Mer',
	'FR14570' => 'Valorbiquet',
	'FR14571' => 'Saint-Denis-de-Mailloc',
	'FR14572' => 'Saint-Denis-de-Méré',
	'FR14574' => 'Saint-Désir',
	'FR14575' => 'Saint-Étienne-la-Thillaye',
	'FR14576' => 'Val-de-Vie',
	'FR14578' => 'Saint-Gatien-des-Bois',
	'FR14579' => 'Seulline',
	'FR14582' => 'Saint-Germain-de-Livet',
	'FR14586' => 'Saint-Germain-du-Pert',
	'FR14587' => 'Saint-Germain-la-Blanche-Herbe',
	'FR14588' => 'Saint-Germain-Langot',
	'FR14589' => 'Saint-Germain-le-Vasson',
	'FR14590' => 'Sainte-Honorine-de-Ducy',
	'FR14591' => 'Aure sur Mer',
	'FR14592' => 'Sainte-Honorine-du-Fay',
	'FR14593' => 'Saint-Hymer',
	'FR14595' => 'Saint-Jean-de-Livet',
	'FR14598' => 'Saint-Jouin',
	'FR14601' => 'Saint-Julien-sur-Calonne',
	'FR14602' => 'Saint-Lambert',
	'FR14603' => 'Saint-Laurent-de-Condel',
	'FR14605' => 'Saint-Laurent-sur-Mer',
	'FR14606' => 'Saint-Léger-Dubosq',
	'FR14607' => 'Saint-Louet-sur-Seulles',
	'FR14609' => 'Saint-Loup-Hors',
	'FR14610' => 'Saint-Manvieu-Norrey',
	'FR14613' => 'Saint-Marcouf',
	'FR14614' => 'Sainte-Marguerite-dElle',
	'FR14619' => 'Sainte-Marie-Outre-lEau',
	'FR14620' => 'Saint-Martin-aux-Chartrains',
	'FR14621' => 'Saint-Martin-de-Bienfaite-la-Cressonnière',
	'FR14622' => 'Saint-Martin-de-Blagny',
	'FR14623' => 'Saint-Martin-de-Fontenay',
	'FR14625' => 'Saint-Martin-de-la-Lieue',
	'FR14626' => 'Saint-Martin-de-Mailloc',
	'FR14627' => 'Saint-Martin-de-Mieux',
	'FR14630' => 'Saint-Martin-des-Entrées',
	'FR14635' => 'Saint-Omer',
	'FR14637' => 'Saint-Ouen-du-Mesnil-Oger',
	'FR14639' => 'Saint-Ouen-le-Pin',
	'FR14640' => 'Saint-Pair',
	'FR14643' => 'Saint-Paul-du-Vernay',
	'FR14644' => 'Saint-Philbert-des-Champs',
	'FR14645' => 'Saint-Pierre-Azif',
	'FR14646' => 'Saint-Pierre-Canivet',
	'FR14648' => 'Saint-Pierre-des-Ifs',
	'FR14649' => 'Saint-Pierre-du-Bû',
	'FR14650' => 'Saint-Pierre-du-Fresne',
	'FR14651' => 'Saint-Pierre-du-Jonquet',
	'FR14652' => 'Saint-Pierre-du-Mont',
	'FR14654' => 'Saint-Pierre-en-Auge',
	'FR14656' => 'Saint-Rémy',
	'FR14657' => 'Saint-Samson',
	'FR14658' => 'Noues de Sienne',
	'FR14659' => 'Saint-Sylvain',
	'FR14660' => 'Saint-Vaast-en-Auge',
	'FR14661' => 'Saint-Vaast-sur-Seulles',
	'FR14663' => 'Saint-Vigor-le-Grand',
	'FR14664' => 'Sallen',
	'FR14665' => 'Sallenelles',
	'FR14667' => 'Saon',
	'FR14668' => 'Saonnet',
	'FR14669' => 'Sassy',
	'FR14672' => 'Val de Drôme',
	'FR14674' => 'Soignolles',
	'FR14675' => 'Soliers',
	'FR14676' => 'Sommervieu',
	'FR14677' => 'Soulangy',
	'FR14678' => 'Soumont-Saint-Quentin',
	'FR14679' => 'Subles',
	'FR14680' => 'Sully',
	'FR14681' => 'Surrain',
	'FR14682' => 'Surville',
	'FR14684' => 'Tessel',
	'FR14685' => 'Thaon',
	'FR14687' => 'Le Theil-en-Auge',
	'FR14689' => 'Le Hom',
	'FR14692' => 'Tilly-sur-Seulles',
	'FR14694' => 'Le Torquesne',
	'FR14698' => 'Touffréville',
	'FR14699' => 'Touques',
	'FR14700' => 'Tour-en-Bessin',
	'FR14701' => 'Tourgéville',
	'FR14705' => 'Tournières',
	'FR14706' => 'Tourville-en-Auge',
	'FR14707' => 'Tourville-sur-Odon',
	'FR14708' => 'Tracy-Bocage',
	'FR14709' => 'Tracy-sur-Mer',
	'FR14710' => 'Tréprel',
	'FR14711' => 'Trévières',
	'FR14712' => 'Saline',
	'FR14713' => 'Montillières-sur-Orne',
	'FR14714' => 'Le Tronquay',
	'FR14715' => 'Trouville-sur-Mer',
	'FR14716' => 'Trungy',
	'FR14719' => 'Urville',
	'FR14720' => 'Ussy',
	'FR14721' => 'Vacognes-Neuilly',
	'FR14723' => 'Valsemé',
	'FR14724' => 'Varaville',
	'FR14726' => 'Valdallière',
	'FR14728' => 'Vaucelles',
	'FR14731' => 'Vauville',
	'FR14732' => 'Vaux-sur-Aure',
	'FR14733' => 'Vaux-sur-Seulles',
	'FR14734' => 'Vendes',
	'FR14735' => 'Vendeuvre',
	'FR14737' => 'Versainville',
	'FR14738' => 'Verson',
	'FR14739' => 'Ver-sur-Mer',
	'FR14740' => 'La Vespière-Friardel',
	'FR14741' => 'Le Vey',
	'FR14742' => 'Vicques',
	'FR14743' => 'Victot-Pontfol',
	'FR14744' => 'Vienne-en-Bessin',
	'FR14745' => 'Vierville-sur-Mer',
	'FR14747' => 'Vieux',
	'FR14748' => 'Vieux-Bourg',
	'FR14751' => 'Vignats',
	'FR14752' => 'Villers-Bocage',
	'FR14753' => 'Villers-Canivet',
	'FR14754' => 'Villers-sur-Mer',
	'FR14755' => 'Villerville',
	'FR14756' => 'La Villette',
	'FR14758' => 'Villons-les-Buissons',
	'FR14759' => 'Villy-lez-Falaise',
	'FR14760' => 'Villy-Bocage',
	'FR14761' => 'Vimont',
	'FR14762' => 'Vire Normandie',
	'FR14764' => 'Pont-dOuilly',
	'FR15001' => 'Allanche',
	'FR15002' => 'Alleuze',
	'FR15003' => 'Ally',
	'FR15004' => 'Andelat',
	'FR15005' => 'Anglards-de-Saint-Flour',
	'FR15006' => 'Anglards-de-Salers',
	'FR15007' => 'Anterrieux',
	'FR15008' => 'Antignac',
	'FR15009' => 'Apchon',
	'FR15010' => 'Arches',
	'FR15011' => 'Arnac',
	'FR15012' => 'Arpajon-sur-Cère',
	'FR15013' => 'Auriac-lÉglise',
	'FR15014' => 'Aurillac',
	'FR15015' => 'Auzers',
	'FR15016' => 'Ayrens',
	'FR15017' => 'Badailhac',
	'FR15018' => 'Barriac-les-Bosquets',
	'FR15019' => 'Bassignac',
	'FR15020' => 'Beaulieu',
	'FR15021' => 'Boisset',
	'FR15022' => 'Bonnac',
	'FR15024' => 'Brageac',
	'FR15025' => 'Albepierre-Bredons',
	'FR15026' => 'Brezons',
	'FR15027' => 'Puycapel',
	'FR15028' => 'Carlat',
	'FR15029' => 'Cassaniouze',
	'FR15030' => 'Cayrols',
	'FR15032' => 'Celoux',
	'FR15033' => 'Cézens',
	'FR15034' => 'Chaliers',
	'FR15036' => 'Chalvignac',
	'FR15037' => 'Champagnac',
	'FR15038' => 'Champs-sur-Tarentaine-Marchal',
	'FR15040' => 'Chanterelle',
	'FR15041' => 'La Chapelle-dAlagnon',
	'FR15042' => 'La Chapelle-Laurent',
	'FR15043' => 'Charmensac',
	'FR15045' => 'Chaudes-Aigues',
	'FR15046' => 'Chaussenac',
	'FR15048' => 'Chazelles',
	'FR15049' => 'Cheylade',
	'FR15050' => 'Le Claux',
	'FR15051' => 'Clavières',
	'FR15052' => 'Collandres',
	'FR15053' => 'Coltines',
	'FR15054' => 'Condat',
	'FR15055' => 'Coren',
	'FR15056' => 'Crandelles',
	'FR15057' => 'Cros-de-Montvert',
	'FR15058' => 'Cros-de-Ronesque',
	'FR15059' => 'Cussac',
	'FR15060' => 'Deux-Verges',
	'FR15061' => 'Dienne',
	'FR15063' => 'Drugeac',
	'FR15064' => 'Escorailles',
	'FR15065' => 'Espinasse',
	'FR15066' => 'Le Falgoux',
	'FR15067' => 'Le Fau',
	'FR15069' => 'Ferrières-Saint-Mary',
	'FR15070' => 'Fontanges',
	'FR15072' => 'Freix-Anglards',
	'FR15073' => 'Fridefont',
	'FR15074' => 'Giou-de-Mamou',
	'FR15075' => 'Girgols',
	'FR15076' => 'Glénat',
	'FR15077' => 'Gourdièges',
	'FR15078' => 'Jabrun',
	'FR15079' => 'Jaleyrac',
	'FR15080' => 'Joursac',
	'FR15081' => 'Jou-sous-Monjou',
	'FR15082' => 'Junhac',
	'FR15083' => 'Jussac',
	'FR15084' => 'Labesserette',
	'FR15085' => 'Labrousse',
	'FR15086' => 'Lacapelle-Barrès',
	'FR15087' => 'Lacapelle-del-Fraisse',
	'FR15088' => 'Lacapelle-Viescamp',
	'FR15089' => 'Ladinhac',
	'FR15090' => 'Lafeuillade-en-Vézie',
	'FR15091' => 'Landeyrat',
	'FR15092' => 'Lanobre',
	'FR15093' => 'Lapeyrugue',
	'FR15094' => 'Laroquebrou',
	'FR15095' => 'Laroquevieille',
	'FR15096' => 'Lascelle',
	'FR15097' => 'Lastic',
	'FR15098' => 'Laurie',
	'FR15100' => 'Laveissenet',
	'FR15101' => 'Laveissière',
	'FR15102' => 'Lavigerie',
	'FR15103' => 'Leucamp',
	'FR15104' => 'Leynhac',
	'FR15105' => 'Leyvaux',
	'FR15106' => 'Lieutadès',
	'FR15107' => 'Lorcières',
	'FR15108' => 'Val dArcomie',
	'FR15110' => 'Lugarde',
	'FR15111' => 'Madic',
	'FR15112' => 'Malbo',
	'FR15113' => 'Mandailles-Saint-Julien',
	'FR15114' => 'Marcenat',
	'FR15116' => 'Marchastel',
	'FR15117' => 'Marcolès',
	'FR15118' => 'Marmanhac',
	'FR15119' => 'Massiac',
	'FR15120' => 'Mauriac',
	'FR15121' => 'Maurines',
	'FR15122' => 'Maurs',
	'FR15123' => 'Méallet',
	'FR15124' => 'Menet',
	'FR15125' => 'Mentières',
	'FR15126' => 'Molèdes',
	'FR15127' => 'Molompize',
	'FR15128' => 'La Monselie',
	'FR15129' => 'Montboudif',
	'FR15130' => 'Montchamp',
	'FR15131' => 'Le Monteil',
	'FR15132' => 'Montgreleix',
	'FR15133' => 'Montmurat',
	'FR15134' => 'Montsalvy',
	'FR15135' => 'Montvert',
	'FR15137' => 'Moussages',
	'FR15138' => 'Murat',
	'FR15139' => 'Narnhac',
	'FR15140' => 'Naucelles',
	'FR15141' => 'Neussargues en Pinatelle',
	'FR15142' => 'Neuvéglise-sur-Truyère',
	'FR15143' => 'Nieudan',
	'FR15144' => 'Omps',
	'FR15146' => 'Pailherols',
	'FR15147' => 'Parlan',
	'FR15148' => 'Paulhac',
	'FR15149' => 'Paulhenc',
	'FR15151' => 'Peyrusse',
	'FR15152' => 'Pierrefort',
	'FR15153' => 'Pleaux',
	'FR15154' => 'Polminhac',
	'FR15155' => 'Pradiers',
	'FR15156' => 'Prunet',
	'FR15157' => 'Quézac',
	'FR15158' => 'Rageade',
	'FR15159' => 'Raulhac',
	'FR15160' => 'Reilhac',
	'FR15161' => 'Rézentières',
	'FR15162' => 'Riom-ès-Montagnes',
	'FR15163' => 'Roannes-Saint-Mary',
	'FR15164' => 'Roffiac',
	'FR15165' => 'Rouffiac',
	'FR15166' => 'Roumégoux',
	'FR15167' => 'Rouziers',
	'FR15168' => 'Ruynes-en-Margeride',
	'FR15169' => 'Saignes',
	'FR15170' => 'Saint-Amandin',
	'FR15172' => 'Saint-Antoine',
	'FR15173' => 'Saint-Bonnet-de-Condat',
	'FR15174' => 'Saint-Bonnet-de-Salers',
	'FR15175' => 'Saint-Cernin',
	'FR15176' => 'Saint-Chamant',
	'FR15178' => 'Saint-Cirgues-de-Jordanne',
	'FR15179' => 'Saint-Cirgues-de-Malbert',
	'FR15180' => 'Saint-Clément',
	'FR15181' => 'Saint-Constant-Fournoulès',
	'FR15182' => 'Saint-Étienne-Cantalès',
	'FR15183' => 'Saint-Étienne-de-Carlat',
	'FR15184' => 'Saint-Étienne-de-Maurs',
	'FR15185' => 'Saint-Étienne-de-Chomeil',
	'FR15186' => 'Sainte-Eulalie',
	'FR15187' => 'Saint-Flour',
	'FR15188' => 'Saint-Georges',
	'FR15189' => 'Saint-Gérons',
	'FR15190' => 'Saint-Hippolyte',
	'FR15191' => 'Saint-Illide',
	'FR15192' => 'Saint-Jacques-des-Blats',
	'FR15194' => 'Saint-Julien-de-Toursac',
	'FR15196' => 'Saint-Mamet-la-Salvetat',
	'FR15198' => 'Sainte-Marie',
	'FR15199' => 'Saint-Martial',
	'FR15200' => 'Saint-Martin-Cantalès',
	'FR15201' => 'Saint-Martin-sous-Vigouroux',
	'FR15202' => 'Saint-Martin-Valmeroux',
	'FR15203' => 'Saint-Mary-le-Plain',
	'FR15204' => 'Saint-Paul-des-Landes',
	'FR15205' => 'Saint-Paul-de-Salers',
	'FR15206' => 'Saint-Pierre',
	'FR15207' => 'Saint-Poncy',
	'FR15208' => 'Saint-Projet-de-Salers',
	'FR15209' => 'Saint-Rémy-de-Chaudes-Aigues',
	'FR15211' => 'Saint-Santin-Cantalès',
	'FR15212' => 'Saint-Santin-de-Maurs',
	'FR15213' => 'Saint-Saturnin',
	'FR15214' => 'Saint-Saury',
	'FR15215' => 'Saint-Simon',
	'FR15216' => 'Saint-Urcize',
	'FR15217' => 'Saint-Victor',
	'FR15218' => 'Saint-Vincent-de-Salers',
	'FR15219' => 'Salers',
	'FR15220' => 'Salins',
	'FR15221' => 'Sansac-de-Marmiesse',
	'FR15222' => 'Sansac-Veinazès',
	'FR15223' => 'Sauvat',
	'FR15224' => 'La Ségalassière',
	'FR15225' => 'Ségur-les-Villas',
	'FR15226' => 'Sénezergues',
	'FR15228' => 'Siran',
	'FR15229' => 'Soulages',
	'FR15230' => 'Sourniac',
	'FR15231' => 'Talizat',
	'FR15232' => 'Tanavelle',
	'FR15233' => 'Teissières-de-Cornet',
	'FR15234' => 'Teissières-lès-Bouliès',
	'FR15235' => 'Les Ternes',
	'FR15236' => 'Thiézac',
	'FR15237' => 'Tiviers',
	'FR15238' => 'Tournemire',
	'FR15240' => 'Trémouille',
	'FR15241' => 'La Trinitat',
	'FR15242' => 'Le Trioulou',
	'FR15243' => 'Trizac',
	'FR15244' => 'Ussel',
	'FR15245' => 'Vabres',
	'FR15246' => 'Valette',
	'FR15247' => 'Valjouze',
	'FR15248' => 'Valuéjols',
	'FR15249' => 'Le Vaulmier',
	'FR15250' => 'Vebret',
	'FR15251' => 'Védrines-Saint-Loup',
	'FR15252' => 'Velzic',
	'FR15253' => 'Vernols',
	'FR15254' => 'Veyrières',
	'FR15255' => 'Vézac',
	'FR15256' => 'Vèze',
	'FR15257' => 'Vezels-Roussy',
	'FR15258' => 'Vic-sur-Cère',
	'FR15259' => 'Vieillespesse',
	'FR15260' => 'Vieillevie',
	'FR15261' => 'Le Vigean',
	'FR15262' => 'Villedieu',
	'FR15263' => 'Virargues',
	'FR15264' => 'Vitrac',
	'FR15265' => 'Ydes',
	'FR15266' => 'Yolet',
	'FR15267' => 'Ytrac',
	'FR15268' => 'Le Rouget-Pers',
	'FR15269' => 'Besse',
	'FR16001' => 'Abzac',
	'FR16002' => 'Les Adjots',
	'FR16003' => 'Agris',
	'FR16005' => 'Aigre',
	'FR16007' => 'Alloue',
	'FR16008' => 'Ambérac',
	'FR16009' => 'Ambernac',
	'FR16010' => 'Ambleville',
	'FR16011' => 'Anais',
	'FR16012' => 'Angeac-Champagne',
	'FR16013' => 'Angeac-Charente',
	'FR16014' => 'Angeduc',
	'FR16015' => 'Angoulême',
	'FR16016' => 'Ansac-sur-Vienne',
	'FR16018' => 'Ars',
	'FR16019' => 'Asnières-sur-Nouère',
	'FR16020' => 'Aubeterre-sur-Dronne',
	'FR16023' => 'Aunac-sur-Charente',
	'FR16024' => 'Aussac-Vadalle',
	'FR16025' => 'Baignes-Sainte-Radegonde',
	'FR16026' => 'Balzac',
	'FR16027' => 'Barbezières',
	'FR16028' => 'Barbezieux-Saint-Hilaire',
	'FR16029' => 'Bardenac',
	'FR16030' => 'Barret',
	'FR16031' => 'Barro',
	'FR16032' => 'Bassac',
	'FR16034' => 'Bazac',
	'FR16035' => 'Beaulieu-sur-Sonnette',
	'FR16036' => 'Bécheresse',
	'FR16037' => 'Bellon',
	'FR16038' => 'Benest',
	'FR16039' => 'Bernac',
	'FR16040' => 'Berneuil',
	'FR16041' => 'Bessac',
	'FR16042' => 'Bessé',
	'FR16044' => 'Bioussac',
	'FR16045' => 'Birac',
	'FR16046' => 'Coteaux-du-Blanzacais',
	'FR16047' => 'Blanzaguet-Saint-Cybard',
	'FR16048' => 'Boisbreteau',
	'FR16049' => 'Bonnes',
	'FR16050' => 'Bonneuil',
	'FR16052' => 'Bors (Canton de Tude-et-Lavalette)',
	'FR16053' => 'Bors (Canton de Charente-Sud)',
	'FR16054' => 'Le Bouchage',
	'FR16055' => 'Bouëx',
	'FR16056' => 'Bourg-Charente',
	'FR16057' => 'Bouteville',
	'FR16058' => 'Boutiers-Saint-Trojan',
	'FR16059' => 'Brettes',
	'FR16060' => 'Bréville',
	'FR16061' => 'Brie',
	'FR16062' => 'Brie-sous-Barbezieux',
	'FR16063' => 'Brie-sous-Chalais',
	'FR16064' => 'Brigueuil',
	'FR16065' => 'Brillac',
	'FR16066' => 'Brossac',
	'FR16067' => 'Bunzac',
	'FR16068' => 'Cellefrouin',
	'FR16069' => 'Cellettes',
	'FR16070' => 'Chabanais',
	'FR16071' => 'Chabrac',
	'FR16072' => 'Chadurie',
	'FR16073' => 'Chalais',
	'FR16074' => 'Challignac',
	'FR16075' => 'Champagne-Vigny',
	'FR16076' => 'Champagne-Mouton',
	'FR16077' => 'Champmillon',
	'FR16078' => 'Champniers',
	'FR16079' => 'Chantillac',
	'FR16081' => 'La Chapelle',
	'FR16082' => 'Boisné-La Tude',
	'FR16083' => 'Charmé',
	'FR16084' => 'Charras',
	'FR16085' => 'Chasseneuil-sur-Bonnieure',
	'FR16086' => 'Chassenon',
	'FR16087' => 'Chassiecq',
	'FR16088' => 'Chassors',
	'FR16089' => 'Châteaubernard',
	'FR16090' => 'Châteauneuf-sur-Charente',
	'FR16091' => 'Châtignac',
	'FR16093' => 'Chazelles',
	'FR16095' => 'Chenon',
	'FR16096' => 'Cherves-Châtelars',
	'FR16097' => 'Cherves-Richemont',
	'FR16098' => 'La Chèvrerie',
	'FR16099' => 'Chillac',
	'FR16100' => 'Chirac',
	'FR16101' => 'Claix',
	'FR16102' => 'Cognac',
	'FR16103' => 'Combiers',
	'FR16104' => 'Condac',
	'FR16105' => 'Condéon',
	'FR16106' => 'Confolens',
	'FR16107' => 'Coulgens',
	'FR16108' => 'Coulonges',
	'FR16109' => 'Courbillac',
	'FR16110' => 'Courcôme',
	'FR16111' => 'Courgeac',
	'FR16112' => 'Courlac',
	'FR16113' => 'La Couronne',
	'FR16114' => 'Couture',
	'FR16116' => 'Criteuil-la-Magdeleine',
	'FR16117' => 'Curac',
	'FR16118' => 'Deviat',
	'FR16119' => 'Dignac',
	'FR16120' => 'Dirac',
	'FR16121' => 'Douzat',
	'FR16122' => 'Ébréon',
	'FR16123' => 'Échallat',
	'FR16124' => 'Écuras',
	'FR16125' => 'Édon',
	'FR16127' => 'Empuré',
	'FR16128' => 'Épenède',
	'FR16130' => 'Les Essards',
	'FR16131' => 'Esse',
	'FR16132' => 'Étagnac',
	'FR16133' => 'Étriac',
	'FR16134' => 'Exideuil-sur-Vienne',
	'FR16135' => 'Eymouthiers',
	'FR16136' => 'La Faye',
	'FR16137' => 'Feuillade',
	'FR16138' => 'Fléac',
	'FR16139' => 'Fleurac',
	'FR16140' => 'Fontclaireau',
	'FR16141' => 'Fontenille',
	'FR16142' => 'La Forêt-de-Tessé',
	'FR16143' => 'Fouquebrune',
	'FR16144' => 'Fouqueure',
	'FR16145' => 'Foussignac',
	'FR16146' => 'Garat',
	'FR16147' => 'Gardes-le-Pontaroux',
	'FR16148' => 'Genac-Bignac',
	'FR16150' => 'Gensac-la-Pallue',
	'FR16151' => 'Genté',
	'FR16152' => 'Gimeux',
	'FR16153' => 'Mainxe-Gondeville',
	'FR16154' => 'Gond-Pontouvre',
	'FR16155' => 'Les Gours',
	'FR16157' => 'Le Grand-Madieu',
	'FR16158' => 'Grassac',
	'FR16160' => 'Guimps',
	'FR16161' => 'Guizengeard',
	'FR16162' => 'Gurat',
	'FR16163' => 'Hiersac',
	'FR16164' => 'Hiesse',
	'FR16165' => 'Houlette',
	'FR16166' => 'LIsle-dEspagnac',
	'FR16167' => 'Jarnac',
	'FR16168' => 'Jauldes',
	'FR16169' => 'Javrezac',
	'FR16170' => 'Juignac',
	'FR16171' => 'Juillac-le-Coq',
	'FR16173' => 'Juillé',
	'FR16174' => 'Julienne',
	'FR16175' => 'Val des Vignes',
	'FR16176' => 'Lachaise',
	'FR16177' => 'Ladiville',
	'FR16178' => 'Lagarde-sur-le-Né',
	'FR16180' => 'Laprade',
	'FR16181' => 'Lessac',
	'FR16182' => 'Lesterps',
	'FR16183' => 'Lésignac-Durand',
	'FR16184' => 'Lichères',
	'FR16185' => 'Ligné',
	'FR16186' => 'Lignières-Sonneville',
	'FR16187' => 'Linars',
	'FR16188' => 'Le Lindois',
	'FR16189' => 'Londigny',
	'FR16190' => 'Longré',
	'FR16191' => 'Lonnes',
	'FR16192' => 'Terres-de-Haute-Charente',
	'FR16193' => 'Louzac-Saint-André',
	'FR16194' => 'Lupsault',
	'FR16195' => 'Lussac',
	'FR16196' => 'Luxé',
	'FR16197' => 'La Magdeleine',
	'FR16198' => 'Magnac-Lavalette-Villars',
	'FR16199' => 'Magnac-sur-Touvre',
	'FR16200' => 'Maine-de-Boixe',
	'FR16203' => 'Mainzac',
	'FR16204' => 'Bellevigne',
	'FR16205' => 'Manot',
	'FR16206' => 'Mansle',
	'FR16207' => 'Marcillac-Lanville',
	'FR16208' => 'Mareuil',
	'FR16209' => 'Marillac-le-Franc',
	'FR16210' => 'Marsac',
	'FR16211' => 'Marthon',
	'FR16212' => 'Massignac',
	'FR16213' => 'Mazerolles',
	'FR16215' => 'Médillac',
	'FR16216' => 'Mérignac',
	'FR16217' => 'Merpins',
	'FR16218' => 'Mesnac',
	'FR16220' => 'Les Métairies',
	'FR16221' => 'Mons',
	'FR16222' => 'Montboyer',
	'FR16223' => 'Montbron',
	'FR16224' => 'Montmérac',
	'FR16225' => 'Montembœuf',
	'FR16226' => 'Montignac-Charente',
	'FR16227' => 'Montignac-le-Coq',
	'FR16229' => 'Montjean',
	'FR16230' => 'Montmoreau',
	'FR16231' => 'Montrollet',
	'FR16232' => 'Mornac',
	'FR16233' => 'Mosnac',
	'FR16234' => 'Moulidars',
	'FR16236' => 'Mouthiers-sur-Boëme',
	'FR16237' => 'Mouton',
	'FR16238' => 'Moutonneau',
	'FR16239' => 'Mouzon',
	'FR16240' => 'Nabinaud',
	'FR16241' => 'Nanclars',
	'FR16242' => 'Nanteuil-en-Vallée',
	'FR16243' => 'Nercillac',
	'FR16244' => 'Nersac',
	'FR16245' => 'Nieuil',
	'FR16246' => 'Nonac',
	'FR16248' => 'Oradour',
	'FR16249' => 'Oradour-Fanais',
	'FR16250' => 'Orgedeuil',
	'FR16251' => 'Oriolles',
	'FR16252' => 'Orival',
	'FR16253' => 'Paizay-Naudouin-Embourie',
	'FR16254' => 'Palluaud',
	'FR16255' => 'Parzac',
	'FR16256' => 'Passirac',
	'FR16258' => 'Pérignac',
	'FR16260' => 'Pillac',
	'FR16261' => 'Les Pins',
	'FR16263' => 'Plassac-Rouffiac',
	'FR16264' => 'Pleuville',
	'FR16267' => 'Poullignac',
	'FR16268' => 'Poursac',
	'FR16269' => 'Pranzac',
	'FR16270' => 'Pressignac',
	'FR16271' => 'Puymoyen',
	'FR16272' => 'Puyréaux',
	'FR16273' => 'Raix',
	'FR16275' => 'Ranville-Breuillaud',
	'FR16276' => 'Reignac',
	'FR16277' => 'Réparsac',
	'FR16279' => 'Rioux-Martin',
	'FR16280' => 'Rivières',
	'FR16281' => 'La Rochefoucauld-en-Angoumois',
	'FR16282' => 'La Rochette',
	'FR16283' => 'Ronsenac',
	'FR16284' => 'Rouffiac',
	'FR16285' => 'Rougnac',
	'FR16286' => 'Rouillac',
	'FR16287' => 'Roullet-Saint-Estèphe',
	'FR16289' => 'Roussines',
	'FR16290' => 'Rouzède',
	'FR16291' => 'Ruelle-sur-Touvre',
	'FR16292' => 'Ruffec',
	'FR16293' => 'Saint-Adjutory',
	'FR16295' => 'Saint-Amant-de-Boixe',
	'FR16297' => 'Graves-Saint-Amant',
	'FR16298' => 'Saint-Amant-de-Nouère',
	'FR16300' => 'Val-de-Bonnieure',
	'FR16301' => 'Saint-Aulais-la-Chapelle',
	'FR16302' => 'Saint-Avit',
	'FR16303' => 'Saint-Bonnet',
	'FR16304' => 'Saint-Brice',
	'FR16306' => 'Saint-Christophe',
	'FR16307' => 'Saint-Ciers-sur-Bonnieure',
	'FR16308' => 'Saint-Claud',
	'FR16310' => 'Saint-Coutant',
	'FR16312' => 'Saint-Cybardeaux',
	'FR16315' => 'Saint-Félix',
	'FR16316' => 'Saint-Fort-sur-le-Né',
	'FR16317' => 'Saint-Fraigne',
	'FR16318' => 'Saint-Front',
	'FR16320' => 'Saint-Genis-dHiersac',
	'FR16321' => 'Saint-Georges',
	'FR16323' => 'Saint-Germain-de-Montbron',
	'FR16325' => 'Saint-Gourson',
	'FR16326' => 'Saint-Groux',
	'FR16329' => 'Saint-Laurent-de-Céris',
	'FR16330' => 'Saint-Laurent-de-Cognac',
	'FR16331' => 'Saint-Laurent-des-Combes',
	'FR16334' => 'Saint-Martial',
	'FR16335' => 'Saint-Martin-du-Clocher',
	'FR16336' => 'Saint-Mary',
	'FR16337' => 'Saint-Maurice-des-Lions',
	'FR16338' => 'Saint-Médard',
	'FR16339' => 'Val-dAuge',
	'FR16340' => 'Saint-Même-les-Carrières',
	'FR16341' => 'Saint-Michel',
	'FR16342' => 'Saint-Palais-du-Né',
	'FR16343' => 'Saint-Preuil',
	'FR16345' => 'Saint-Quentin-sur-Charente',
	'FR16346' => 'Saint-Quentin-de-Chalais',
	'FR16347' => 'Saint-Romain',
	'FR16348' => 'Saint-Saturnin',
	'FR16349' => 'Sainte-Sévère',
	'FR16350' => 'Saint-Séverin',
	'FR16351' => 'Saint-Simeux',
	'FR16352' => 'Saint-Simon',
	'FR16353' => 'Saint-Sornin',
	'FR16354' => 'Sainte-Souline',
	'FR16355' => 'Saint-Sulpice-de-Cognac',
	'FR16356' => 'Saint-Sulpice-de-Ruffec',
	'FR16357' => 'Saint-Vallier',
	'FR16358' => 'Saint-Yrieix-sur-Charente',
	'FR16359' => 'Salles-dAngles',
	'FR16360' => 'Salles-de-Barbezieux',
	'FR16361' => 'Salles-de-Villefagnan',
	'FR16362' => 'Salles-Lavalette',
	'FR16363' => 'Saulgond',
	'FR16364' => 'Sauvagnac',
	'FR16365' => 'Sauvignac',
	'FR16366' => 'Segonzac',
	'FR16368' => 'Sers',
	'FR16369' => 'Sigogne',
	'FR16370' => 'Sireuil',
	'FR16372' => 'Souffrignac',
	'FR16373' => 'Souvigné',
	'FR16374' => 'Soyaux',
	'FR16375' => 'Suaux',
	'FR16377' => 'La Tâche',
	'FR16378' => 'Taizé-Aizie',
	'FR16379' => 'Taponnat-Fleurignac',
	'FR16380' => 'Le Tâtre',
	'FR16381' => 'Theil-Rabier',
	'FR16382' => 'Torsac',
	'FR16383' => 'Tourriers',
	'FR16384' => 'Touvérac',
	'FR16385' => 'Touvre',
	'FR16387' => 'Triac-Lautrait',
	'FR16388' => 'Trois-Palis',
	'FR16389' => 'Turgon',
	'FR16390' => 'Tusson',
	'FR16392' => 'Valence',
	'FR16393' => 'Vars',
	'FR16394' => 'Vaux-Lavalette',
	'FR16395' => 'Vaux-Rouillac',
	'FR16396' => 'Ventouse',
	'FR16397' => 'Verdille',
	'FR16398' => 'Verneuil',
	'FR16399' => 'Verrières',
	'FR16400' => 'Verteuil-sur-Charente',
	'FR16401' => 'Vervant',
	'FR16402' => 'Vibrac',
	'FR16403' => 'Le Vieux-Cérier',
	'FR16404' => 'Vieux-Ruffec',
	'FR16405' => 'Vignolles',
	'FR16406' => 'Moulins-sur-Tardoire',
	'FR16408' => 'Villebois-Lavalette',
	'FR16409' => 'Villefagnan',
	'FR16412' => 'Villejoubert',
	'FR16413' => 'Villiers-le-Roux',
	'FR16414' => 'Villognon',
	'FR16415' => 'Vindelle',
	'FR16416' => 'Vitrac-Saint-Vincent',
	'FR16418' => 'Vœuil-et-Giget',
	'FR16419' => 'Vouharte',
	'FR16420' => 'Voulgézac',
	'FR16421' => 'Vouthon',
	'FR16422' => 'Vouzan',
	'FR16423' => 'Xambes',
	'FR16424' => 'Yviers',
	'FR16425' => 'Yvrac-et-Malleyrand',
	'FR17002' => 'Agudelle',
	'FR17003' => 'Aigrefeuille-dAunis',
	'FR17004' => 'Île-dAix',
	'FR17005' => 'Allas-Bocage',
	'FR17006' => 'Allas-Champagne',
	'FR17007' => 'Anais',
	'FR17008' => 'Andilly',
	'FR17009' => 'Angliers',
	'FR17010' => 'Angoulins',
	'FR17011' => 'Annepont',
	'FR17012' => 'Annezay',
	'FR17013' => 'Antezant-la-Chapelle',
	'FR17015' => 'Arces',
	'FR17016' => 'Archiac',
	'FR17017' => 'Archingeay',
	'FR17018' => 'Ardillières',
	'FR17019' => 'Ars-en-Ré',
	'FR17020' => 'Arthenac',
	'FR17021' => 'Arvert',
	'FR17022' => 'Asnières-la-Giraud',
	'FR17023' => 'Aujac',
	'FR17024' => 'Aulnay',
	'FR17025' => 'Aumagne',
	'FR17026' => 'Authon-Ébéon',
	'FR17027' => 'Avy',
	'FR17028' => 'Aytré',
	'FR17029' => 'Bagnizeau',
	'FR17030' => 'Balanzac',
	'FR17031' => 'Ballans',
	'FR17032' => 'Ballon',
	'FR17033' => 'La Barde',
	'FR17034' => 'Barzan',
	'FR17035' => 'Bazauges',
	'FR17036' => 'Beaugeay',
	'FR17037' => 'Beauvais-sur-Matha',
	'FR17038' => 'Bedenac',
	'FR17039' => 'Belluire',
	'FR17041' => 'Benon',
	'FR17042' => 'Bercloux',
	'FR17043' => 'Bernay-Saint-Martin',
	'FR17044' => 'Berneuil',
	'FR17045' => 'Beurlay',
	'FR17046' => 'Bignay',
	'FR17047' => 'Biron',
	'FR17048' => 'Blanzac-lès-Matha',
	'FR17049' => 'Blanzay-sur-Boutonne',
	'FR17050' => 'Bois',
	'FR17051' => 'Le Bois-Plage-en-Ré',
	'FR17052' => 'Boisredon',
	'FR17053' => 'Bords',
	'FR17054' => 'Boresse-et-Martron',
	'FR17055' => 'Boscamnant',
	'FR17056' => 'Bougneau',
	'FR17057' => 'Bouhet',
	'FR17058' => 'Bourcefranc-le-Chapus',
	'FR17059' => 'Bourgneuf',
	'FR17060' => 'Boutenac-Touvent',
	'FR17061' => 'Bran',
	'FR17062' => 'Bresdon',
	'FR17063' => 'Breuil-la-Réorte',
	'FR17064' => 'Breuillet',
	'FR17065' => 'Breuil-Magné',
	'FR17066' => 'Brie-sous-Archiac',
	'FR17067' => 'Brie-sous-Matha',
	'FR17068' => 'Brie-sous-Mortagne',
	'FR17069' => 'Brives-sur-Charente',
	'FR17070' => 'Brizambourg',
	'FR17071' => 'La Brousse',
	'FR17072' => 'Burie',
	'FR17073' => 'Bussac-sur-Charente',
	'FR17074' => 'Bussac-Forêt',
	'FR17075' => 'Cabariot',
	'FR17076' => 'Celles',
	'FR17077' => 'Cercoux',
	'FR17078' => 'Chadenac',
	'FR17079' => 'Chaillevette',
	'FR17080' => 'Chambon',
	'FR17081' => 'Chamouillac',
	'FR17082' => 'Champagnac',
	'FR17083' => 'Champagne',
	'FR17084' => 'Champagnolles',
	'FR17085' => 'Champdolent',
	'FR17086' => 'Chaniers',
	'FR17087' => 'Chantemerle-sur-la-Soie',
	'FR17089' => 'La Chapelle-des-Pots',
	'FR17091' => 'Charron',
	'FR17092' => 'Chartuzac',
	'FR17093' => 'Le Château-dOléron',
	'FR17094' => 'Châtelaillon-Plage',
	'FR17095' => 'Chatenet',
	'FR17096' => 'Chaunac',
	'FR17097' => 'Le Chay',
	'FR17098' => 'Chenac-Saint-Seurin-dUzet',
	'FR17099' => 'Chepniers',
	'FR17100' => 'Chérac',
	'FR17101' => 'Cherbonnières',
	'FR17102' => 'Chermignac',
	'FR17104' => 'Chevanceaux',
	'FR17105' => 'Chives',
	'FR17106' => 'Cierzac',
	'FR17107' => 'Ciré-dAunis',
	'FR17108' => 'Clam',
	'FR17109' => 'Clavette',
	'FR17110' => 'Clérac',
	'FR17111' => 'Clion',
	'FR17112' => 'La Clisse',
	'FR17113' => 'La Clotte',
	'FR17114' => 'Coivert',
	'FR17115' => 'Colombiers',
	'FR17116' => 'Consac',
	'FR17117' => 'Contré',
	'FR17118' => 'Corignac',
	'FR17119' => 'Corme-Écluse',
	'FR17120' => 'Corme-Royal',
	'FR17121' => 'La Couarde-sur-Mer',
	'FR17122' => 'Coulonges',
	'FR17124' => 'Courant',
	'FR17125' => 'Courcelles',
	'FR17126' => 'Courcerac',
	'FR17127' => 'Courçon',
	'FR17128' => 'Courcoury',
	'FR17129' => 'Courpignac',
	'FR17130' => 'Coux',
	'FR17131' => 'Cozes',
	'FR17132' => 'Cramchaban',
	'FR17133' => 'Cravans',
	'FR17134' => 'Crazannes',
	'FR17135' => 'Cressé',
	'FR17136' => 'Croix-Chapeau',
	'FR17137' => 'La Croix-Comtesse',
	'FR17138' => 'Dampierre-sur-Boutonne',
	'FR17139' => 'Dœuil-sur-le-Mignon',
	'FR17140' => 'Dolus-dOléron',
	'FR17141' => 'Dompierre-sur-Charente',
	'FR17142' => 'Dompierre-sur-Mer',
	'FR17143' => 'Le Douhet',
	'FR17145' => 'Échebrune',
	'FR17146' => 'Échillais',
	'FR17147' => 'Écoyeux',
	'FR17148' => 'Écurat',
	'FR17149' => 'Les Éduts',
	'FR17150' => 'Les Églises-dArgenteuil',
	'FR17151' => 'LÉguille',
	'FR17152' => 'Épargnes',
	'FR17153' => 'Esnandes',
	'FR17154' => 'Les Essards',
	'FR17155' => 'Étaules',
	'FR17156' => 'Expiremont',
	'FR17157' => 'Fenioux',
	'FR17158' => 'Ferrières',
	'FR17159' => 'Fléac-sur-Seugne',
	'FR17160' => 'Floirac',
	'FR17161' => 'La Flotte',
	'FR17162' => 'Fontaine-Chalendray',
	'FR17163' => 'Fontaines-dOzillac',
	'FR17164' => 'Fontcouverte',
	'FR17165' => 'Fontenet',
	'FR17166' => 'Forges',
	'FR17167' => 'Le Fouilloux',
	'FR17168' => 'Fouras',
	'FR17171' => 'Geay',
	'FR17172' => 'Gémozac',
	'FR17173' => 'La Genétouze',
	'FR17174' => 'Genouillé',
	'FR17175' => 'Germignac',
	'FR17176' => 'Gibourne',
	'FR17177' => 'Le Gicq',
	'FR17178' => 'Givrezac',
	'FR17179' => 'Les Gonds',
	'FR17180' => 'Gourvillette',
	'FR17181' => 'Grandjean',
	'FR17182' => 'La Grève-sur-Mignon',
	'FR17183' => 'Grézac',
	'FR17184' => 'La Gripperie-Saint-Symphorien',
	'FR17185' => 'Le Gua',
	'FR17186' => 'Le Gué-dAlleré',
	'FR17187' => 'Guitinières',
	'FR17188' => 'Haimps',
	'FR17190' => 'LHoumeau',
	'FR17191' => 'La Jard',
	'FR17192' => 'Jarnac-Champagne',
	'FR17193' => 'La Jarne',
	'FR17194' => 'La Jarrie',
	'FR17195' => 'La Jarrie-Audouin',
	'FR17196' => 'Jazennes',
	'FR17197' => 'Jonzac',
	'FR17198' => 'Juicq',
	'FR17199' => 'Jussas',
	'FR17200' => 'Lagord',
	'FR17201' => 'La Laigne',
	'FR17202' => 'Landes',
	'FR17203' => 'Landrais',
	'FR17204' => 'Léoville',
	'FR17205' => 'Loire-les-Marais',
	'FR17206' => 'Loiré-sur-Nie',
	'FR17207' => 'Loix',
	'FR17208' => 'Longèves',
	'FR17209' => 'Lonzac',
	'FR17210' => 'Lorignac',
	'FR17211' => 'Loulay',
	'FR17212' => 'Louzignac',
	'FR17213' => 'Lozay',
	'FR17214' => 'Luchat',
	'FR17215' => 'Lussac',
	'FR17216' => 'Lussant',
	'FR17217' => 'Macqueville',
	'FR17218' => 'Marans',
	'FR17219' => 'Marennes-Hiers-Brouage',
	'FR17220' => 'Marignac',
	'FR17221' => 'Marsais',
	'FR17222' => 'Marsilly',
	'FR17223' => 'Massac',
	'FR17224' => 'Matha',
	'FR17225' => 'Les Mathes',
	'FR17226' => 'Mazeray',
	'FR17227' => 'Mazerolles',
	'FR17228' => 'Médis',
	'FR17229' => 'Mérignac',
	'FR17230' => 'Meschers-sur-Gironde',
	'FR17231' => 'Messac',
	'FR17232' => 'Meursac',
	'FR17233' => 'Meux',
	'FR17234' => 'Migré',
	'FR17235' => 'Migron',
	'FR17236' => 'Mirambeau',
	'FR17237' => 'Moëze',
	'FR17239' => 'Mons',
	'FR17240' => 'Montendre',
	'FR17241' => 'Montguyon',
	'FR17242' => 'Montils',
	'FR17243' => 'Montlieu-la-Garde',
	'FR17244' => 'Montpellier-de-Médillan',
	'FR17245' => 'Montroy',
	'FR17246' => 'Moragne',
	'FR17247' => 'Mornac-sur-Seudre',
	'FR17248' => 'Mortagne-sur-Gironde',
	'FR17249' => 'Mortiers',
	'FR17250' => 'Mosnac',
	'FR17252' => 'Le Mung',
	'FR17253' => 'Muron',
	'FR17254' => 'Nachamps',
	'FR17255' => 'Nancras',
	'FR17256' => 'Nantillé',
	'FR17257' => 'Néré',
	'FR17258' => 'Neuillac',
	'FR17259' => 'Neulles',
	'FR17260' => 'Neuvicq',
	'FR17261' => 'Neuvicq-le-Château',
	'FR17262' => 'Nieul-lès-Saintes',
	'FR17263' => 'Nieul-le-Virouil',
	'FR17264' => 'Nieul-sur-Mer',
	'FR17265' => 'Nieulle-sur-Seudre',
	'FR17266' => 'Les Nouillers',
	'FR17267' => 'Nuaillé-dAunis',
	'FR17268' => 'Nuaillé-sur-Boutonne',
	'FR17269' => 'Orignolles',
	'FR17270' => 'Ozillac',
	'FR17271' => 'Paillé',
	'FR17273' => 'Pérignac',
	'FR17274' => 'Périgny',
	'FR17275' => 'Pessines',
	'FR17276' => 'Le Pin',
	'FR17277' => 'Essouvert',
	'FR17278' => 'Pisany',
	'FR17279' => 'Plassac',
	'FR17280' => 'Plassay',
	'FR17281' => 'Polignac',
	'FR17282' => 'Pommiers-Moulons',
	'FR17283' => 'Pons',
	'FR17284' => 'Pont-lAbbé-dArnoult',
	'FR17285' => 'Port-dEnvaux',
	'FR17286' => 'Les Portes-en-Ré',
	'FR17287' => 'Pouillac',
	'FR17288' => 'Poursay-Garnaud',
	'FR17289' => 'Préguillac',
	'FR17290' => 'Prignac',
	'FR17291' => 'Puilboreau',
	'FR17292' => 'Puy-du-Lac',
	'FR17293' => 'Puyravault',
	'FR17294' => 'Puyrolland',
	'FR17295' => 'Réaux sur Trèfle',
	'FR17296' => 'Rétaud',
	'FR17297' => 'Rivedoux-Plage',
	'FR17298' => 'Rioux',
	'FR17299' => 'Rochefort',
	'FR17300' => 'La Rochelle',
	'FR17301' => 'Romazières',
	'FR17302' => 'Romegoux',
	'FR17303' => 'La Ronde',
	'FR17304' => 'Rouffiac',
	'FR17305' => 'Rouffignac',
	'FR17306' => 'Royan',
	'FR17307' => 'Sablonceaux',
	'FR17308' => 'Saint-Agnant',
	'FR17309' => 'Saint-Aigulin',
	'FR17310' => 'Saint-André-de-Lidon',
	'FR17311' => 'Saint-Augustin',
	'FR17312' => 'Saint-Bonnet-sur-Gironde',
	'FR17313' => 'Saint-Bris-des-Bois',
	'FR17314' => 'Saint-Césaire',
	'FR17315' => 'Saint-Christophe',
	'FR17316' => 'Saint-Ciers-Champagne',
	'FR17317' => 'Saint-Ciers-du-Taillon',
	'FR17318' => 'Saint-Clément-des-Baleines',
	'FR17319' => 'Sainte-Colombe',
	'FR17320' => 'Saint-Coutant-le-Grand',
	'FR17321' => 'Saint-Crépin',
	'FR17322' => 'Saint-Cyr-du-Doret',
	'FR17323' => 'Saint-Denis-dOléron',
	'FR17324' => 'Saint-Dizant-du-Bois',
	'FR17325' => 'Saint-Dizant-du-Gua',
	'FR17326' => 'Saint-Eugène',
	'FR17327' => 'Saint-Félix',
	'FR17328' => 'Saint-Fort-sur-Gironde',
	'FR17329' => 'Saint-Froult',
	'FR17330' => 'Sainte-Gemme',
	'FR17331' => 'Saint-Genis-de-Saintonge',
	'FR17332' => 'Saint-Georges-Antignac',
	'FR17333' => 'Saint-Georges-de-Didonne',
	'FR17334' => 'Saint-Georges-de-Longuepierre',
	'FR17335' => 'Saint-Georges-des-Agoûts',
	'FR17336' => 'Saint-Georges-des-Coteaux',
	'FR17337' => 'Saint-Georges-dOléron',
	'FR17338' => 'Saint-Georges-du-Bois',
	'FR17339' => 'Saint-Germain-de-Lusignan',
	'FR17340' => 'Saint-Pierre-La-Noue',
	'FR17341' => 'Saint-Germain-de-Vibrac',
	'FR17342' => 'Saint-Germain-du-Seudre',
	'FR17343' => 'Saint-Grégoire-dArdennes',
	'FR17344' => 'Saint-Hilaire-de-Villefranche',
	'FR17345' => 'Saint-Hilaire-du-Bois',
	'FR17346' => 'Saint-Hippolyte',
	'FR17347' => 'Saint-Jean-dAngély',
	'FR17348' => 'Saint-Jean-dAngle',
	'FR17349' => 'Saint-Jean-de-Liversay',
	'FR17350' => 'Saint-Julien-de-lEscap',
	'FR17351' => 'Saint-Just-Luzac',
	'FR17353' => 'Saint-Laurent-de-la-Prée',
	'FR17354' => 'Saint-Léger',
	'FR17355' => 'Sainte-Lheurine',
	'FR17356' => 'Saint-Loup',
	'FR17357' => 'Saint-Maigrin',
	'FR17358' => 'Saint-Mandé-sur-Brédoire',
	'FR17359' => 'Saint-Mard',
	'FR17360' => 'Sainte-Marie-de-Ré',
	'FR17361' => 'Saint-Martial',
	'FR17362' => 'Saint-Martial-de-Mirambeau',
	'FR17363' => 'Saint-Martial-de-Vitaterne',
	'FR17364' => 'Saint-Martial-sur-Né',
	'FR17365' => 'Saint-Martin-dAry',
	'FR17366' => 'Saint-Martin-de-Coux',
	'FR17367' => 'Saint-Martin-de-Juillers',
	'FR17369' => 'Saint-Martin-de-Ré',
	'FR17372' => 'Saint-Médard',
	'FR17373' => 'Saint-Médard-dAunis',
	'FR17374' => 'Sainte-Même',
	'FR17375' => 'Saint-Nazaire-sur-Charente',
	'FR17376' => 'Saint-Ouen-dAunis',
	'FR17377' => 'Saint-Ouen-la-Thène',
	'FR17378' => 'Saint-Palais-de-Négrignac',
	'FR17379' => 'Saint-Palais-de-Phiolin',
	'FR17380' => 'Saint-Palais-sur-Mer',
	'FR17381' => 'Saint-Pardoult',
	'FR17382' => 'Saint-Pierre-dAmilly',
	'FR17383' => 'Saint-Pierre-de-Juillers',
	'FR17384' => 'Saint-Pierre-de-lIsle',
	'FR17385' => 'Saint-Pierre-dOléron',
	'FR17386' => 'Saint-Pierre-du-Palais',
	'FR17387' => 'Saint-Porchaire',
	'FR17388' => 'Saint-Quantin-de-Rançanne',
	'FR17389' => 'Sainte-Radegonde',
	'FR17390' => 'Sainte-Ramée',
	'FR17391' => 'Saint-Rogatien',
	'FR17393' => 'Saint-Romain-de-Benet',
	'FR17394' => 'Saint-Saturnin-du-Bois',
	'FR17395' => 'Saint-Sauvant',
	'FR17396' => 'Saint-Sauveur-dAunis',
	'FR17397' => 'Saint-Savinien',
	'FR17398' => 'Saint-Seurin-de-Palenne',
	'FR17400' => 'Saint-Sever-de-Saintonge',
	'FR17401' => 'Saint-Séverin-sur-Boutonne',
	'FR17402' => 'Saint-Sigismond-de-Clermont',
	'FR17403' => 'Saint-Simon-de-Bordes',
	'FR17404' => 'Saint-Simon-de-Pellouaille',
	'FR17405' => 'Saint-Sorlin-de-Conac',
	'FR17406' => 'Saint-Sornin',
	'FR17407' => 'Sainte-Soulle',
	'FR17408' => 'Saint-Sulpice-dArnoult',
	'FR17409' => 'Saint-Sulpice-de-Royan',
	'FR17410' => 'Saint-Thomas-de-Conac',
	'FR17411' => 'Saint-Trojan-les-Bains',
	'FR17412' => 'Saint-Vaize',
	'FR17413' => 'Saint-Vivien',
	'FR17414' => 'Saint-Xandre',
	'FR17415' => 'Saintes',
	'FR17416' => 'Saleignes',
	'FR17417' => 'Salignac-de-Mirambeau',
	'FR17418' => 'Salignac-sur-Charente',
	'FR17420' => 'Salles-sur-Mer',
	'FR17421' => 'Saujon',
	'FR17422' => 'Seigné',
	'FR17423' => 'Semillac',
	'FR17424' => 'Semoussac',
	'FR17425' => 'Semussac',
	'FR17426' => 'Le Seure',
	'FR17427' => 'Siecq',
	'FR17428' => 'Sonnac',
	'FR17429' => 'Soubise',
	'FR17430' => 'Soubran',
	'FR17431' => 'Soulignonne',
	'FR17432' => 'Souméras',
	'FR17433' => 'Sousmoulins',
	'FR17434' => 'Surgères',
	'FR17435' => 'Taillant',
	'FR17436' => 'Taillebourg',
	'FR17437' => 'Talmont-sur-Gironde',
	'FR17438' => 'Tanzac',
	'FR17439' => 'Taugon',
	'FR17440' => 'Ternant',
	'FR17441' => 'Tesson',
	'FR17442' => 'Thaims',
	'FR17443' => 'Thairé',
	'FR17444' => 'Thénac',
	'FR17445' => 'Thézac',
	'FR17446' => 'Thors',
	'FR17447' => 'Le Thou',
	'FR17448' => 'Tonnay-Boutonne',
	'FR17449' => 'Tonnay-Charente',
	'FR17450' => 'Torxé',
	'FR17451' => 'Les Touches-de-Périgny',
	'FR17452' => 'La Tremblade',
	'FR17453' => 'Trizay',
	'FR17454' => 'Tugéras-Saint-Maurice',
	'FR17455' => 'La Vallée',
	'FR17457' => 'La Devise',
	'FR17458' => 'Vanzac',
	'FR17459' => 'Varaize',
	'FR17460' => 'Varzay',
	'FR17461' => 'Vaux-sur-Mer',
	'FR17462' => 'Vénérand',
	'FR17463' => 'Vergeroux',
	'FR17464' => 'Vergné',
	'FR17465' => 'La Vergne',
	'FR17466' => 'Vérines',
	'FR17467' => 'Vervant',
	'FR17468' => 'Vibrac',
	'FR17469' => 'Villars-en-Pons',
	'FR17470' => 'Villars-les-Bois',
	'FR17471' => 'La Villedieu',
	'FR17472' => 'Villedoux',
	'FR17473' => 'Villemorin',
	'FR17474' => 'Villeneuve-la-Comtesse',
	'FR17476' => 'Villexavier',
	'FR17477' => 'Villiers-Couture',
	'FR17478' => 'Vinax',
	'FR17479' => 'Virollet',
	'FR17480' => 'Virson',
	'FR17481' => 'Voissay',
	'FR17482' => 'Vouhé',
	'FR17483' => 'Yves',
	'FR17484' => 'Port-des-Barques',
	'FR17485' => 'Le Grand-Village-Plage',
	'FR17486' => 'La Brée-les-Bains',
	'FR18001' => 'Achères',
	'FR18002' => 'Ainay-le-Vieil',
	'FR18003' => 'Les Aix-dAngillon',
	'FR18004' => 'Allogny',
	'FR18005' => 'Allouis',
	'FR18006' => 'Annoix',
	'FR18007' => 'Apremont-sur-Allier',
	'FR18008' => 'Arçay',
	'FR18009' => 'Arcomps',
	'FR18010' => 'Ardenais',
	'FR18011' => 'Argent-sur-Sauldre',
	'FR18012' => 'Argenvières',
	'FR18013' => 'Arpheuilles',
	'FR18014' => 'Assigny',
	'FR18015' => 'Aubigny-sur-Nère',
	'FR18016' => 'Aubinges',
	'FR18017' => 'Augy-sur-Aubois',
	'FR18018' => 'Avord',
	'FR18019' => 'Azy',
	'FR18020' => 'Bannay',
	'FR18021' => 'Bannegon',
	'FR18022' => 'Barlieu',
	'FR18023' => 'Baugy',
	'FR18024' => 'Beddes',
	'FR18025' => 'Beffes',
	'FR18026' => 'Belleville-sur-Loire',
	'FR18027' => 'Bengy-sur-Craon',
	'FR18028' => 'Berry-Bouy',
	'FR18029' => 'Bessais-le-Fromental',
	'FR18030' => 'Blancafort',
	'FR18031' => 'Blet',
	'FR18032' => 'Boulleret',
	'FR18033' => 'Bourges',
	'FR18034' => 'Bouzais',
	'FR18035' => 'Brécy',
	'FR18036' => 'Brinay',
	'FR18037' => 'Brinon-sur-Sauldre',
	'FR18038' => 'Bruère-Allichamps',
	'FR18039' => 'Bué',
	'FR18040' => 'Bussy',
	'FR18041' => 'La Celette',
	'FR18042' => 'La Celle',
	'FR18043' => 'La Celle-Condé',
	'FR18044' => 'Cerbois',
	'FR18045' => 'Chalivoy-Milon',
	'FR18046' => 'Chambon',
	'FR18047' => 'La Chapelle-dAngillon',
	'FR18048' => 'La Chapelle-Hugon',
	'FR18049' => 'La Chapelle-Montlinard',
	'FR18050' => 'La Chapelle-Saint-Ursin',
	'FR18051' => 'La Chapelotte',
	'FR18052' => 'Charenton-du-Cher',
	'FR18053' => 'Charentonnay',
	'FR18054' => 'Charly',
	'FR18055' => 'Chârost',
	'FR18056' => 'Chassy',
	'FR18057' => 'Châteaumeillant',
	'FR18058' => 'Châteauneuf-sur-Cher',
	'FR18059' => 'Le Châtelet',
	'FR18060' => 'Chaumont',
	'FR18061' => 'Chaumoux-Marcilly',
	'FR18062' => 'Le Chautay',
	'FR18063' => 'Chavannes',
	'FR18064' => 'Chéry',
	'FR18065' => 'Chezal-Benoît',
	'FR18066' => 'Civray',
	'FR18067' => 'Clémont',
	'FR18068' => 'Cogny',
	'FR18069' => 'Colombiers',
	'FR18070' => 'Concressault',
	'FR18071' => 'Contres',
	'FR18072' => 'Cornusse',
	'FR18073' => 'Corquoy',
	'FR18074' => 'Couargues',
	'FR18075' => 'Cours-les-Barres',
	'FR18076' => 'Coust',
	'FR18077' => 'Couy',
	'FR18078' => 'Crézançay-sur-Cher',
	'FR18079' => 'Crézancy-en-Sancerre',
	'FR18080' => 'Croisy',
	'FR18081' => 'Crosses',
	'FR18082' => 'Cuffy',
	'FR18083' => 'Culan',
	'FR18084' => 'Dampierre-en-Crot',
	'FR18085' => 'Dampierre-en-Graçay',
	'FR18086' => 'Drevant',
	'FR18087' => 'Dun-sur-Auron',
	'FR18088' => 'Ennordres',
	'FR18089' => 'Épineuil-le-Fleuriel',
	'FR18090' => 'Étréchy',
	'FR18091' => 'Farges-Allichamps',
	'FR18092' => 'Farges-en-Septaine',
	'FR18093' => 'Faverdines',
	'FR18094' => 'Feux',
	'FR18095' => 'Flavigny',
	'FR18096' => 'Foëcy',
	'FR18097' => 'Fussy',
	'FR18098' => 'Gardefort',
	'FR18099' => 'Garigny',
	'FR18100' => 'Genouilly',
	'FR18101' => 'Germigny-lExempt',
	'FR18102' => 'Givardon',
	'FR18103' => 'Graçay',
	'FR18104' => 'Groises',
	'FR18105' => 'Gron',
	'FR18106' => 'Grossouvre',
	'FR18107' => 'La Groutte',
	'FR18108' => 'La Guerche-sur-lAubois',
	'FR18109' => 'Henrichemont',
	'FR18110' => 'Herry',
	'FR18111' => 'Humbligny',
	'FR18112' => 'Ids-Saint-Roch',
	'FR18113' => 'Ignol',
	'FR18114' => 'Ineuil',
	'FR18115' => 'Ivoy-le-Pré',
	'FR18116' => 'Jalognes',
	'FR18117' => 'Jars',
	'FR18118' => 'Jouet-sur-lAubois',
	'FR18119' => 'Jussy-Champagne',
	'FR18120' => 'Jussy-le-Chaudrier',
	'FR18121' => 'Lantan',
	'FR18122' => 'Lapan',
	'FR18124' => 'Lazenay',
	'FR18125' => 'Léré',
	'FR18126' => 'Levet',
	'FR18127' => 'Lignières',
	'FR18128' => 'Limeux',
	'FR18129' => 'Lissay-Lochy',
	'FR18130' => 'Loye-sur-Arnon',
	'FR18131' => 'Lugny-Bourbonnais',
	'FR18132' => 'Lugny-Champagne',
	'FR18133' => 'Lunery',
	'FR18134' => 'Lury-sur-Arnon',
	'FR18135' => 'Maisonnais',
	'FR18136' => 'Marçais',
	'FR18137' => 'Mareuil-sur-Arnon',
	'FR18138' => 'Marmagne',
	'FR18139' => 'Marseilles-lès-Aubigny',
	'FR18140' => 'Massay',
	'FR18141' => 'Mehun-sur-Yèvre',
	'FR18142' => 'Meillant',
	'FR18143' => 'Menetou-Couture',
	'FR18144' => 'Menetou-Râtel',
	'FR18145' => 'Menetou-Salon',
	'FR18146' => 'Ménétréol-sous-Sancerre',
	'FR18147' => 'Ménétréol-sur-Sauldre',
	'FR18148' => 'Méreau',
	'FR18149' => 'Méry-ès-Bois',
	'FR18150' => 'Méry-sur-Cher',
	'FR18151' => 'Montigny',
	'FR18152' => 'Montlouis',
	'FR18153' => 'Morlac',
	'FR18154' => 'Mornay-Berry',
	'FR18155' => 'Mornay-sur-Allier',
	'FR18156' => 'Morogues',
	'FR18157' => 'Morthomiers',
	'FR18158' => 'Moulins-sur-Yèvre',
	'FR18159' => 'Nançay',
	'FR18160' => 'Nérondes',
	'FR18161' => 'Neuilly-en-Dun',
	'FR18162' => 'Neuilly-en-Sancerre',
	'FR18163' => 'Neuvy-Deux-Clochers',
	'FR18164' => 'Neuvy-le-Barrois',
	'FR18165' => 'Neuvy-sur-Barangeon',
	'FR18166' => 'Nohant-en-Goût',
	'FR18167' => 'Nohant-en-Graçay',
	'FR18168' => 'Le Noyer',
	'FR18169' => 'Nozières',
	'FR18170' => 'Oizon',
	'FR18171' => 'Orcenais',
	'FR18172' => 'Orval',
	'FR18173' => 'Osmery',
	'FR18174' => 'Osmoy',
	'FR18175' => 'Ourouer-les-Bourdelins',
	'FR18176' => 'Parassy',
	'FR18177' => 'Parnay',
	'FR18178' => 'La Perche',
	'FR18179' => 'Pigny',
	'FR18180' => 'Plaimpied-Givaudins',
	'FR18181' => 'Plou',
	'FR18182' => 'Poisieux',
	'FR18183' => 'Le Pondy',
	'FR18184' => 'Précy',
	'FR18185' => 'Presly',
	'FR18186' => 'Preuilly',
	'FR18187' => 'Préveranges',
	'FR18188' => 'Primelles',
	'FR18189' => 'Quantilly',
	'FR18190' => 'Quincy',
	'FR18191' => 'Raymond',
	'FR18192' => 'Reigny',
	'FR18193' => 'Rezay',
	'FR18194' => 'Rians',
	'FR18195' => 'Sagonne',
	'FR18196' => 'Saint-Aignan-des-Noyers',
	'FR18197' => 'Saint-Amand-Montrond',
	'FR18198' => 'Saint-Ambroix',
	'FR18199' => 'Saint-Baudel',
	'FR18200' => 'Saint-Bouize',
	'FR18201' => 'Saint-Caprais',
	'FR18202' => 'Saint-Céols',
	'FR18203' => 'Saint-Christophe-le-Chaudry',
	'FR18204' => 'Saint-Denis-de-Palin',
	'FR18205' => 'Saint-Doulchard',
	'FR18206' => 'Saint-Éloy-de-Gy',
	'FR18207' => 'Saint-Florent-sur-Cher',
	'FR18208' => 'Sainte-Gemme-en-Sancerrois',
	'FR18209' => 'Saint-Georges-de-Poisieux',
	'FR18210' => 'Saint-Georges-sur-la-Prée',
	'FR18211' => 'Saint-Georges-sur-Moulon',
	'FR18212' => 'Saint-Germain-des-Bois',
	'FR18213' => 'Saint-Germain-du-Puy',
	'FR18214' => 'Saint-Hilaire-de-Court',
	'FR18215' => 'Saint-Hilaire-de-Gondilly',
	'FR18216' => 'Saint-Hilaire-en-Lignières',
	'FR18217' => 'Saint-Jeanvrin',
	'FR18218' => 'Saint-Just',
	'FR18219' => 'Saint-Laurent',
	'FR18220' => 'Saint-Léger-le-Petit',
	'FR18221' => 'Saint-Loup-des-Chaumes',
	'FR18223' => 'Saint-Martin-dAuxigny',
	'FR18224' => 'Saint-Martin-des-Champs',
	'FR18225' => 'Saint-Maur',
	'FR18226' => 'Saint-Michel-de-Volangis',
	'FR18227' => 'Sainte-Montaine',
	'FR18228' => 'Saint-Outrille',
	'FR18229' => 'Saint-Palais',
	'FR18230' => 'Saint-Pierre-les-Bois',
	'FR18231' => 'Saint-Pierre-les-Étieux',
	'FR18232' => 'Saint-Priest-la-Marche',
	'FR18233' => 'Saint-Satur',
	'FR18234' => 'Saint-Saturnin',
	'FR18235' => 'Sainte-Solange',
	'FR18236' => 'Saint-Symphorien',
	'FR18237' => 'Sainte-Thorette',
	'FR18238' => 'Saint-Vitte',
	'FR18240' => 'Sancergues',
	'FR18241' => 'Sancerre',
	'FR18242' => 'Sancoins',
	'FR18243' => 'Santranges',
	'FR18244' => 'Saugy',
	'FR18245' => 'Saulzais-le-Potier',
	'FR18246' => 'Savigny-en-Sancerre',
	'FR18247' => 'Savigny-en-Septaine',
	'FR18248' => 'Senneçay',
	'FR18249' => 'Sens-Beaujeu',
	'FR18250' => 'Serruelles',
	'FR18251' => 'Sévry',
	'FR18252' => 'Sidiailles',
	'FR18253' => 'Soulangis',
	'FR18254' => 'Soye-en-Septaine',
	'FR18255' => 'Le Subdray',
	'FR18256' => 'Subligny',
	'FR18257' => 'Sury-près-Léré',
	'FR18258' => 'Sury-en-Vaux',
	'FR18259' => 'Sury-ès-Bois',
	'FR18260' => 'Tendron',
	'FR18261' => 'Thaumiers',
	'FR18262' => 'Thauvenay',
	'FR18263' => 'Thénioux',
	'FR18264' => 'Thou',
	'FR18265' => 'Torteron',
	'FR18266' => 'Touchay',
	'FR18267' => 'Trouy',
	'FR18268' => 'Uzay-le-Venon',
	'FR18269' => 'Vailly-sur-Sauldre',
	'FR18270' => 'Vallenay',
	'FR18271' => 'Vasselay',
	'FR18272' => 'Veaugues',
	'FR18273' => 'Venesmes',
	'FR18274' => 'Verdigny',
	'FR18275' => 'Vereaux',
	'FR18276' => 'Vernais',
	'FR18277' => 'Verneuil',
	'FR18278' => 'Vesdun',
	'FR18279' => 'Vierzon',
	'FR18280' => 'Vignoux-sous-les-Aix',
	'FR18281' => 'Vignoux-sur-Barangeon',
	'FR18282' => 'Villabon',
	'FR18283' => 'Villecelin',
	'FR18284' => 'Villegenon',
	'FR18285' => 'Villeneuve-sur-Cher',
	'FR18286' => 'Villequiers',
	'FR18287' => 'Vinon',
	'FR18288' => 'Vorly',
	'FR18289' => 'Vornay',
	'FR18290' => 'Vouzeron',
	'FR19001' => 'Affieux',
	'FR19002' => 'Aix',
	'FR19003' => 'Albignac',
	'FR19004' => 'Albussac',
	'FR19005' => 'Allassac',
	'FR19006' => 'Alleyrat',
	'FR19007' => 'Altillac',
	'FR19008' => 'Ambrugeat',
	'FR19009' => 'Les Angles-sur-Corrèze',
	'FR19010' => 'Argentat-sur-Dordogne',
	'FR19011' => 'Arnac-Pompadour',
	'FR19012' => 'Astaillac',
	'FR19013' => 'Aubazines',
	'FR19014' => 'Auriac',
	'FR19015' => 'Ayen',
	'FR19016' => 'Bar',
	'FR19017' => 'Bassignac-le-Bas',
	'FR19018' => 'Bassignac-le-Haut',
	'FR19019' => 'Beaulieu-sur-Dordogne',
	'FR19020' => 'Beaumont',
	'FR19021' => 'Bellechassagne',
	'FR19022' => 'Benayes',
	'FR19023' => 'Beynat',
	'FR19024' => 'Beyssac',
	'FR19025' => 'Beyssenac',
	'FR19026' => 'Bilhac',
	'FR19027' => 'Bonnefond',
	'FR19028' => 'Bort-les-Orgues',
	'FR19029' => 'Branceilles',
	'FR19030' => 'Brignac-la-Plaine',
	'FR19031' => 'Brive-la-Gaillarde',
	'FR19033' => 'Bugeat',
	'FR19034' => 'Camps-Saint-Mathurin-Léobazel',
	'FR19035' => 'Chabrignac',
	'FR19036' => 'Chamberet',
	'FR19037' => 'Chamboulive',
	'FR19038' => 'Chameyrat',
	'FR19039' => 'Champagnac-la-Noaille',
	'FR19040' => 'Champagnac-la-Prune',
	'FR19041' => 'Chanac-les-Mines',
	'FR19042' => 'Chanteix',
	'FR19043' => 'La Chapelle-aux-Brocs',
	'FR19044' => 'La Chapelle-aux-Saints',
	'FR19045' => 'La Chapelle-Saint-Géraud',
	'FR19046' => 'Chapelle-Spinasse',
	'FR19047' => 'Chartrier-Ferrière',
	'FR19048' => 'Le Chastang',
	'FR19049' => 'Chasteaux',
	'FR19050' => 'Chauffour-sur-Vell',
	'FR19051' => 'Chaumeil',
	'FR19052' => 'Chavanac',
	'FR19053' => 'Chaveroche',
	'FR19054' => 'Chenailler-Mascheix',
	'FR19055' => 'Chirac-Bellevue',
	'FR19056' => 'Clergoux',
	'FR19057' => 'Collonges-la-Rouge',
	'FR19058' => 'Combressol',
	'FR19059' => 'Concèze',
	'FR19060' => 'Condat-sur-Ganaveix',
	'FR19061' => 'Cornil',
	'FR19062' => 'Corrèze',
	'FR19063' => 'Cosnac',
	'FR19064' => 'Couffy-sur-Sarsonne',
	'FR19065' => 'Courteix',
	'FR19066' => 'Cublac',
	'FR19067' => 'Curemonte',
	'FR19068' => 'Dampniat',
	'FR19069' => 'Darazac',
	'FR19070' => 'Darnets',
	'FR19071' => 'Davignac',
	'FR19072' => 'Donzenac',
	'FR19073' => 'Égletons',
	'FR19074' => 'LÉglise-aux-Bois',
	'FR19075' => 'Espagnac',
	'FR19076' => 'Espartignac',
	'FR19077' => 'Estivals',
	'FR19078' => 'Estivaux',
	'FR19079' => 'Eyburie',
	'FR19080' => 'Eygurande',
	'FR19081' => 'Eyrein',
	'FR19082' => 'Favars',
	'FR19083' => 'Feyt',
	'FR19084' => 'Forgès',
	'FR19085' => 'Gimel-les-Cascades',
	'FR19086' => 'Goulles',
	'FR19087' => 'Gourdon-Murat',
	'FR19088' => 'Grandsaigne',
	'FR19089' => 'Gros-Chastang',
	'FR19090' => 'Gumond',
	'FR19091' => 'Hautefage',
	'FR19092' => 'Le Jardin',
	'FR19093' => 'Jugeals-Nazareth',
	'FR19094' => 'Juillac',
	'FR19095' => 'Lacelle',
	'FR19096' => 'Ladignac-sur-Rondelles',
	'FR19097' => 'Lafage-sur-Sombre',
	'FR19098' => 'Lagarde-Marc-la-Tour',
	'FR19099' => 'Lagleygeolle',
	'FR19100' => 'Lagraulière',
	'FR19101' => 'Laguenne-sur-Avalouze',
	'FR19102' => 'Lamazière-Basse',
	'FR19103' => 'Lamazière-Haute',
	'FR19104' => 'Lamongerie',
	'FR19105' => 'Lanteuil',
	'FR19106' => 'Lapleau',
	'FR19107' => 'Larche',
	'FR19108' => 'Laroche-près-Feyt',
	'FR19109' => 'Lascaux',
	'FR19110' => 'Latronche',
	'FR19111' => 'Laval-sur-Luzège',
	'FR19112' => 'Lestards',
	'FR19113' => 'Liginiac',
	'FR19114' => 'Lignareix',
	'FR19115' => 'Ligneyrac',
	'FR19116' => 'Liourdres',
	'FR19117' => 'Lissac-sur-Couze',
	'FR19118' => 'Le Lonzac',
	'FR19119' => 'Lostanges',
	'FR19120' => 'Louignac',
	'FR19121' => 'Lubersac',
	'FR19122' => 'Madranges',
	'FR19123' => 'Malemort',
	'FR19124' => 'Mansac',
	'FR19125' => 'Marcillac-la-Croisille',
	'FR19126' => 'Marcillac-la-Croze',
	'FR19128' => 'Margerides',
	'FR19129' => 'Masseret',
	'FR19130' => 'Maussac',
	'FR19131' => 'Meilhards',
	'FR19132' => 'Ménoire',
	'FR19133' => 'Mercœur',
	'FR19134' => 'Merlines',
	'FR19135' => 'Mestes',
	'FR19136' => 'Meymac',
	'FR19137' => 'Meyrignac-lÉglise',
	'FR19138' => 'Meyssac',
	'FR19139' => 'Millevaches',
	'FR19140' => 'Monceaux-sur-Dordogne',
	'FR19141' => 'Monestier-Merlines',
	'FR19142' => 'Monestier-Port-Dieu',
	'FR19143' => 'Montaignac-Saint-Hippolyte',
	'FR19144' => 'Montgibaud',
	'FR19145' => 'Moustier-Ventadour',
	'FR19146' => 'Naves',
	'FR19147' => 'Nespouls',
	'FR19148' => 'Neuvic',
	'FR19149' => 'Neuville',
	'FR19150' => 'Noailhac',
	'FR19151' => 'Noailles',
	'FR19152' => 'Nonards',
	'FR19153' => 'Objat',
	'FR19154' => 'Orgnac-sur-Vézère',
	'FR19155' => 'Orliac-de-Bar',
	'FR19156' => 'Palazinges',
	'FR19157' => 'Palisse',
	'FR19158' => 'Pandrignes',
	'FR19159' => 'Péret-Bel-Air',
	'FR19160' => 'Pérols-sur-Vézère',
	'FR19161' => 'Perpezac-le-Blanc',
	'FR19162' => 'Perpezac-le-Noir',
	'FR19163' => 'Le Pescher',
	'FR19164' => 'Peyrelevade',
	'FR19165' => 'Peyrissac',
	'FR19166' => 'Pierrefitte',
	'FR19167' => 'Confolent-Port-Dieu',
	'FR19168' => 'Pradines',
	'FR19169' => 'Puy-dArnac',
	'FR19170' => 'Queyssac-les-Vignes',
	'FR19171' => 'Reygade',
	'FR19172' => 'Rilhac-Treignac',
	'FR19173' => 'Rilhac-Xaintrie',
	'FR19174' => 'La Roche-Canillac',
	'FR19175' => 'Roche-le-Peyroux',
	'FR19176' => 'Rosiers-dÉgletons',
	'FR19177' => 'Rosiers-de-Juillac',
	'FR19178' => 'Sadroc',
	'FR19179' => 'Saillac',
	'FR19180' => 'Saint-Angel',
	'FR19181' => 'Saint-Augustin',
	'FR19182' => 'Saint-Aulaire',
	'FR19184' => 'Saint-Bazile-de-Meyssac',
	'FR19186' => 'Saint-Bonnet-Elvert',
	'FR19187' => 'Saint-Bonnet-la-Rivière',
	'FR19188' => 'Saint-Bonnet-lEnfantier',
	'FR19189' => 'Saint-Bonnet-les-Tours-de-Merle',
	'FR19190' => 'Saint-Bonnet-près-Bort',
	'FR19191' => 'Saint-Cernin-de-Larche',
	'FR19192' => 'Saint-Chamant',
	'FR19193' => 'Saint-Cirgues-la-Loutre',
	'FR19194' => 'Saint-Clément',
	'FR19195' => 'Saint-Cyprien',
	'FR19196' => 'Saint-Cyr-la-Roche',
	'FR19198' => 'Saint-Éloy-les-Tuileries',
	'FR19199' => 'Saint-Étienne-aux-Clos',
	'FR19200' => 'Saint-Étienne-la-Geneste',
	'FR19201' => 'Saint-Exupéry-les-Roches',
	'FR19202' => 'Sainte-Féréole',
	'FR19203' => 'Sainte-Fortunade',
	'FR19204' => 'Saint-Fréjoux',
	'FR19205' => 'Saint-Geniez-ô-Merle',
	'FR19206' => 'Saint-Germain-Lavolps',
	'FR19207' => 'Saint-Germain-les-Vergnes',
	'FR19208' => 'Saint-Hilaire-Foissac',
	'FR19209' => 'Saint-Hilaire-les-Courbes',
	'FR19210' => 'Saint-Hilaire-Luc',
	'FR19211' => 'Saint-Hilaire-Peyroux',
	'FR19212' => 'Saint-Hilaire-Taurieux',
	'FR19213' => 'Saint-Jal',
	'FR19214' => 'Saint-Julien-aux-Bois',
	'FR19215' => 'Saint-Julien-le-Pèlerin',
	'FR19216' => 'Saint-Julien-le-Vendômois',
	'FR19217' => 'Saint-Julien-Maumont',
	'FR19219' => 'Sainte-Marie-Lapanouze',
	'FR19220' => 'Saint-Martial-de-Gimel',
	'FR19221' => 'Saint-Martial-Entraygues',
	'FR19222' => 'Saint-Martin-la-Méanne',
	'FR19223' => 'Saint-Martin-Sepert',
	'FR19225' => 'Saint-Merd-de-Lapleau',
	'FR19226' => 'Saint-Merd-les-Oussines',
	'FR19227' => 'Saint-Mexant',
	'FR19228' => 'Saint-Pantaléon-de-Lapleau',
	'FR19229' => 'Saint-Pantaléon-de-Larche',
	'FR19230' => 'Saint-Pardoux-Corbier',
	'FR19231' => 'Saint-Pardoux-la-Croisille',
	'FR19232' => 'Saint-Pardoux-le-Neuf',
	'FR19233' => 'Saint-Pardoux-le-Vieux',
	'FR19234' => 'Saint-Pardoux-lOrtigier',
	'FR19235' => 'Saint-Paul',
	'FR19236' => 'Saint-Priest-de-Gimel',
	'FR19237' => 'Saint-Privat',
	'FR19238' => 'Saint-Rémy',
	'FR19239' => 'Saint-Robert',
	'FR19240' => 'Saint-Salvadour',
	'FR19241' => 'Saint-Setiers',
	'FR19242' => 'Saint-Solve',
	'FR19243' => 'Saint-Sornin-Lavolps',
	'FR19244' => 'Saint-Sulpice-les-Bois',
	'FR19245' => 'Saint-Sylvain',
	'FR19246' => 'Saint-Viance',
	'FR19247' => 'Saint-Victour',
	'FR19248' => 'Saint-Ybard',
	'FR19249' => 'Saint-Yrieix-le-Déjalat',
	'FR19250' => 'Salon-la-Tour',
	'FR19251' => 'Sarran',
	'FR19252' => 'Sarroux - Saint Julien',
	'FR19253' => 'Segonzac',
	'FR19254' => 'Ségur-le-Château',
	'FR19255' => 'Seilhac',
	'FR19256' => 'Sérandon',
	'FR19257' => 'Sérilhac',
	'FR19258' => 'Servières-le-Château',
	'FR19259' => 'Sexcles',
	'FR19260' => 'Sioniac',
	'FR19261' => 'Sornac',
	'FR19262' => 'Soudaine-Lavinadière',
	'FR19263' => 'Soudeilles',
	'FR19264' => 'Soursac',
	'FR19265' => 'Tarnac',
	'FR19266' => 'Thalamy',
	'FR19268' => 'Toy-Viam',
	'FR19269' => 'Treignac',
	'FR19270' => 'Troche',
	'FR19271' => 'Tudeils',
	'FR19272' => 'Tulle',
	'FR19273' => 'Turenne',
	'FR19274' => 'Ussac',
	'FR19275' => 'Ussel',
	'FR19276' => 'Uzerche',
	'FR19277' => 'Valiergues',
	'FR19278' => 'Varetz',
	'FR19279' => 'Vars-sur-Roseix',
	'FR19280' => 'Végennes',
	'FR19281' => 'Veix',
	'FR19283' => 'Veyrières',
	'FR19284' => 'Viam',
	'FR19285' => 'Vigeois',
	'FR19286' => 'Vignols',
	'FR19287' => 'Vitrac-sur-Montane',
	'FR19288' => 'Voutezac',
	'FR19289' => 'Yssandon',
	'FR21001' => 'Agencourt',
	'FR21002' => 'Agey',
	'FR21003' => 'Ahuy',
	'FR21004' => 'Aignay-le-Duc',
	'FR21005' => 'Aiserey',
	'FR21006' => 'Aisey-sur-Seine',
	'FR21007' => 'Aisy-sous-Thil',
	'FR21008' => 'Alise-Sainte-Reine',
	'FR21009' => 'Allerey',
	'FR21010' => 'Aloxe-Corton',
	'FR21011' => 'Ampilly-les-Bordes',
	'FR21012' => 'Ampilly-le-Sec',
	'FR21013' => 'Ancey',
	'FR21014' => 'Antheuil',
	'FR21015' => 'Antigny-la-Ville',
	'FR21016' => 'Arceau',
	'FR21017' => 'Arcenant',
	'FR21018' => 'Arcey',
	'FR21020' => 'Arconcey',
	'FR21021' => 'Arc-sur-Tille',
	'FR21022' => 'Argilly',
	'FR21023' => 'Arnay-le-Duc',
	'FR21024' => 'Arnay-sous-Vitteaux',
	'FR21025' => 'Arrans',
	'FR21026' => 'Asnières-en-Montagne',
	'FR21027' => 'Asnières-lès-Dijon',
	'FR21028' => 'Athée',
	'FR21029' => 'Athie',
	'FR21030' => 'Aubaine',
	'FR21031' => 'Aubigny-en-Plaine',
	'FR21032' => 'Aubigny-la-Ronce',
	'FR21033' => 'Aubigny-lès-Sombernon',
	'FR21034' => 'Autricourt',
	'FR21035' => 'Auvillars-sur-Saône',
	'FR21036' => 'Auxant',
	'FR21037' => 'Auxey-Duresses',
	'FR21038' => 'Auxonne',
	'FR21039' => 'Avelanges',
	'FR21040' => 'Avosnes',
	'FR21041' => 'Avot',
	'FR21042' => 'Bagnot',
	'FR21043' => 'Baigneux-les-Juifs',
	'FR21044' => 'Balot',
	'FR21045' => 'Barbirey-sur-Ouche',
	'FR21046' => 'Bard-le-Régulier',
	'FR21047' => 'Bard-lès-Époisses',
	'FR21048' => 'Barges',
	'FR21049' => 'Barjon',
	'FR21050' => 'Baubigny',
	'FR21051' => 'Baulme-la-Roche',
	'FR21052' => 'Beaulieu',
	'FR21053' => 'Beaumont-sur-Vingeanne',
	'FR21054' => 'Beaune',
	'FR21055' => 'Beaunotte',
	'FR21056' => 'Beire-le-Châtel',
	'FR21057' => 'Beire-le-Fort',
	'FR21058' => 'Belan-sur-Ource',
	'FR21059' => 'Bellefond',
	'FR21060' => 'Belleneuve',
	'FR21061' => 'Bellenod-sur-Seine',
	'FR21062' => 'Bellenot-sous-Pouilly',
	'FR21063' => 'Beneuvre',
	'FR21064' => 'Benoisey',
	'FR21065' => 'Bessey-en-Chaume',
	'FR21066' => 'Bessey-la-Cour',
	'FR21067' => 'Bessey-lès-Cîteaux',
	'FR21068' => 'Beurey-Bauguay',
	'FR21069' => 'Beurizot',
	'FR21070' => 'Bévy',
	'FR21071' => 'Bèze',
	'FR21072' => 'Bézouotte',
	'FR21074' => 'Billey',
	'FR21075' => 'Billy-lès-Chanceaux',
	'FR21076' => 'Binges',
	'FR21077' => 'Bissey-la-Côte',
	'FR21078' => 'Bissey-la-Pierre',
	'FR21079' => 'Blagny-sur-Vingeanne',
	'FR21080' => 'Blaisy-Bas',
	'FR21081' => 'Blaisy-Haut',
	'FR21082' => 'Blancey',
	'FR21083' => 'Blanot',
	'FR21084' => 'Source-Seine',
	'FR21085' => 'Bligny-le-Sec',
	'FR21086' => 'Bligny-lès-Beaune',
	'FR21087' => 'Bligny-sur-Ouche',
	'FR21088' => 'Boncourt-le-Bois',
	'FR21089' => 'Bonnencontre',
	'FR21090' => 'Boudreville',
	'FR21091' => 'Bouhey',
	'FR21092' => 'Bouilland',
	'FR21093' => 'Bouix',
	'FR21094' => 'Bourberain',
	'FR21095' => 'Bousselange',
	'FR21096' => 'Boussenois',
	'FR21097' => 'Boussey',
	'FR21098' => 'Boux-sous-Salmaise',
	'FR21099' => 'Bouze-lès-Beaune',
	'FR21100' => 'Brain',
	'FR21101' => 'Braux',
	'FR21102' => 'Brazey-en-Morvan',
	'FR21103' => 'Brazey-en-Plaine',
	'FR21104' => 'Brémur-et-Vaurois',
	'FR21105' => 'Bressey-sur-Tille',
	'FR21106' => 'Bretenière',
	'FR21107' => 'Bretigny',
	'FR21108' => 'Brianny',
	'FR21109' => 'Brion-sur-Ource',
	'FR21110' => 'Brochon',
	'FR21111' => 'Brognon',
	'FR21112' => 'Broin',
	'FR21113' => 'Broindon',
	'FR21114' => 'Buffon',
	'FR21115' => 'Buncey',
	'FR21116' => 'Bure-les-Templiers',
	'FR21117' => 'Busseaut',
	'FR21118' => 'Busserotte-et-Montenaille',
	'FR21119' => 'Bussières',
	'FR21120' => 'La Bussière-sur-Ouche',
	'FR21121' => 'Bussy-la-Pesle',
	'FR21122' => 'Bussy-le-Grand',
	'FR21123' => 'Buxerolles',
	'FR21124' => 'Censerey',
	'FR21125' => 'Cérilly',
	'FR21126' => 'Cessey-sur-Tille',
	'FR21127' => 'Chaignay',
	'FR21128' => 'Chailly-sur-Armançon',
	'FR21129' => 'Chambain',
	'FR21130' => 'Chambeire',
	'FR21131' => 'Chamblanc',
	'FR21132' => 'Chambœuf',
	'FR21133' => 'Chambolle-Musigny',
	'FR21134' => 'Chamesson',
	'FR21135' => 'Champagne-sur-Vingeanne',
	'FR21136' => 'Champagny',
	'FR21137' => 'Champ-dOiseau',
	'FR21138' => 'Champdôtre',
	'FR21139' => 'Champeau-en-Morvan',
	'FR21140' => 'Champignolles',
	'FR21141' => 'Champrenault',
	'FR21142' => 'Chanceaux',
	'FR21143' => 'Channay',
	'FR21144' => 'Charencey',
	'FR21145' => 'Charigny',
	'FR21146' => 'Charmes',
	'FR21147' => 'Charny',
	'FR21148' => 'Charrey-sur-Saône',
	'FR21149' => 'Charrey-sur-Seine',
	'FR21150' => 'Chassagne-Montrachet',
	'FR21151' => 'Chassey',
	'FR21152' => 'Châteauneuf',
	'FR21153' => 'Châtellenot',
	'FR21154' => 'Châtillon-sur-Seine',
	'FR21155' => 'Chaudenay-la-Ville',
	'FR21156' => 'Chaudenay-le-Château',
	'FR21157' => 'Chaugey',
	'FR21158' => 'Chaume-et-Courchamp',
	'FR21159' => 'La Chaume',
	'FR21160' => 'Chaume-lès-Baigneux',
	'FR21161' => 'Chaumont-le-Bois',
	'FR21162' => 'Chaux',
	'FR21163' => 'Chazeuil',
	'FR21164' => 'Chazilly',
	'FR21165' => 'Chemin-dAisey',
	'FR21166' => 'Chenôve',
	'FR21167' => 'Cheuge',
	'FR21168' => 'Chevannay',
	'FR21169' => 'Chevannes',
	'FR21170' => 'Chevigny-en-Valière',
	'FR21171' => 'Chevigny-Saint-Sauveur',
	'FR21172' => 'Chivres',
	'FR21173' => 'Chorey-les-Beaune',
	'FR21175' => 'Cirey-lès-Pontailler',
	'FR21176' => 'Civry-en-Montagne',
	'FR21177' => 'Clamerey',
	'FR21178' => 'Valforêt',
	'FR21179' => 'Clénay',
	'FR21180' => 'Cléry',
	'FR21181' => 'Clomot',
	'FR21182' => 'Collonges-lès-Bévy',
	'FR21183' => 'Collonges-lès-Premières',
	'FR21184' => 'Colombier',
	'FR21185' => 'Combertault',
	'FR21186' => 'Comblanchien',
	'FR21187' => 'Commarin',
	'FR21189' => 'Corberon',
	'FR21190' => 'Corcelles-les-Arts',
	'FR21191' => 'Corcelles-lès-Cîteaux',
	'FR21192' => 'Corcelles-les-Monts',
	'FR21193' => 'Corgengoux',
	'FR21194' => 'Corgoloin',
	'FR21195' => 'Cormot-Vauchignon',
	'FR21196' => 'Corpeau',
	'FR21197' => 'Corpoyer-la-Chapelle',
	'FR21198' => 'Corrombles',
	'FR21199' => 'Corsaint',
	'FR21200' => 'Couchey',
	'FR21201' => 'Coulmier-le-Sec',
	'FR21202' => 'Courban',
	'FR21203' => 'Courcelles-Frémoy',
	'FR21204' => 'Courcelles-lès-Montbard',
	'FR21205' => 'Courcelles-lès-Semur',
	'FR21207' => 'Courlon',
	'FR21208' => 'Courtivron',
	'FR21209' => 'Couternon',
	'FR21210' => 'Créancey',
	'FR21211' => 'Crécey-sur-Tille',
	'FR21212' => 'Crépand',
	'FR21213' => 'Crimolois',
	'FR21214' => 'Crugey',
	'FR21215' => 'Cuiserey',
	'FR21216' => 'Culètre',
	'FR21217' => 'Curley',
	'FR21218' => 'Curtil-Saint-Seine',
	'FR21219' => 'Curtil-Vergy',
	'FR21220' => 'Cussey-les-Forges',
	'FR21221' => 'Cussy-la-Colonne',
	'FR21222' => 'Cussy-le-Châtel',
	'FR21223' => 'Daix',
	'FR21224' => 'Dampierre-en-Montagne',
	'FR21225' => 'Dampierre-et-Flée',
	'FR21226' => 'Darcey',
	'FR21227' => 'Darois',
	'FR21228' => 'Détain-et-Bruant',
	'FR21229' => 'Diancey',
	'FR21230' => 'Diénay',
	'FR21231' => 'Dijon',
	'FR21232' => 'Dompierre-en-Morvan',
	'FR21233' => 'Drambon',
	'FR21234' => 'Drée',
	'FR21235' => 'Duesme',
	'FR21236' => 'Ébaty',
	'FR21237' => 'Échalot',
	'FR21238' => 'Échannay',
	'FR21239' => 'Échenon',
	'FR21240' => 'Échevannes',
	'FR21241' => 'Échevronne',
	'FR21242' => 'Échigey',
	'FR21243' => 'Écutigny',
	'FR21244' => 'Éguilly',
	'FR21245' => 'Épagny',
	'FR21246' => 'Épernay-sous-Gevrey',
	'FR21247' => 'Époisses',
	'FR21248' => 'Éringes',
	'FR21249' => 'Esbarres',
	'FR21250' => 'Essarois',
	'FR21251' => 'Essey',
	'FR21252' => 'Étais',
	'FR21253' => 'Étalante',
	'FR21254' => 'LÉtang-Vergy',
	'FR21255' => 'Étaules',
	'FR21256' => 'Étevaux',
	'FR21257' => 'Étormay',
	'FR21258' => 'Étrochey',
	'FR21259' => 'Fain-lès-Montbard',
	'FR21260' => 'Fain-lès-Moutiers',
	'FR21261' => 'Fauverney',
	'FR21262' => 'Faverolles-lès-Lucey',
	'FR21263' => 'Fénay',
	'FR21264' => 'Le Fête',
	'FR21265' => 'Fixin',
	'FR21266' => 'Flacey',
	'FR21267' => 'Flagey-Echézeaux',
	'FR21268' => 'Flagey-lès-Auxonne',
	'FR21269' => 'Flammerans',
	'FR21270' => 'Flavignerot',
	'FR21271' => 'Flavigny-sur-Ozerain',
	'FR21272' => 'Le Val-Larrey',
	'FR21273' => 'Fleurey-sur-Ouche',
	'FR21274' => 'Foissy',
	'FR21275' => 'Foncegrive',
	'FR21276' => 'Fontaines-en-Duesmois',
	'FR21277' => 'Fontaine-Française',
	'FR21278' => 'Fontaine-lès-Dijon',
	'FR21279' => 'Fontaines-les-Sèches',
	'FR21280' => 'Fontangy',
	'FR21281' => 'Fontenelle',
	'FR21282' => 'Forléans',
	'FR21283' => 'Fraignot-et-Vesvrotte',
	'FR21284' => 'Francheville',
	'FR21285' => 'Franxault',
	'FR21286' => 'Frénois',
	'FR21287' => 'Fresnes',
	'FR21288' => 'Frôlois',
	'FR21289' => 'Fussey',
	'FR21290' => 'Gemeaux',
	'FR21291' => 'Genay',
	'FR21292' => 'Genlis',
	'FR21293' => 'Gergueil',
	'FR21294' => 'Gerland',
	'FR21295' => 'Gevrey-Chambertin',
	'FR21296' => 'Gevrolles',
	'FR21297' => 'Gilly-lès-Cîteaux',
	'FR21298' => 'Gissey-le-Vieil',
	'FR21299' => 'Gissey-sous-Flavigny',
	'FR21300' => 'Gissey-sur-Ouche',
	'FR21301' => 'Glanon',
	'FR21302' => 'Gomméville',
	'FR21303' => 'Les Goulles',
	'FR21304' => 'Grancey-le-Château-Neuvelle',
	'FR21305' => 'Grancey-sur-Ource',
	'FR21306' => 'Grenant-lès-Sombernon',
	'FR21307' => 'Grésigny-Sainte-Reine',
	'FR21308' => 'Grignon',
	'FR21309' => 'Griselles',
	'FR21310' => 'Grosbois-en-Montagne',
	'FR21311' => 'Grosbois-lès-Tichey',
	'FR21312' => 'Gurgy-la-Ville',
	'FR21313' => 'Gurgy-le-Château',
	'FR21314' => 'Hauteroche',
	'FR21315' => 'Hauteville-lès-Dijon',
	'FR21316' => 'Heuilley-sur-Saône',
	'FR21317' => 'Is-sur-Tille',
	'FR21319' => 'Izeure',
	'FR21320' => 'Izier',
	'FR21321' => 'Jailly-les-Moulins',
	'FR21322' => 'Jallanges',
	'FR21323' => 'Jancigny',
	'FR21324' => 'Jeux-lès-Bard',
	'FR21325' => 'Jouey',
	'FR21326' => 'Jours-lès-Baigneux',
	'FR21327' => 'Val-Mont',
	'FR21328' => 'Juillenay',
	'FR21329' => 'Juilly',
	'FR21330' => 'Labergement-Foigney',
	'FR21331' => 'Labergement-lès-Auxonne',
	'FR21332' => 'Labergement-lès-Seurre',
	'FR21333' => 'Labruyère',
	'FR21334' => 'Lacanche',
	'FR21335' => 'Lacour-dArcenay',
	'FR21336' => 'Laignes',
	'FR21337' => 'Lamarche-sur-Saône',
	'FR21338' => 'Lamargelle',
	'FR21339' => 'Lantenay',
	'FR21340' => 'Lanthes',
	'FR21341' => 'Lantilly',
	'FR21342' => 'Laperrière-sur-Saône',
	'FR21343' => 'Larrey',
	'FR21344' => 'Lechâtelet',
	'FR21345' => 'Léry',
	'FR21346' => 'Leuglay',
	'FR21347' => 'Levernois',
	'FR21348' => 'Licey-sur-Vingeanne',
	'FR21349' => 'Liernais',
	'FR21350' => 'Lignerolles',
	'FR21351' => 'Longchamp',
	'FR21352' => 'Longeault-Pluvault',
	'FR21353' => 'Longecourt-en-Plaine',
	'FR21354' => 'Longecourt-lès-Culêtre',
	'FR21355' => 'Longvic',
	'FR21356' => 'Losne',
	'FR21357' => 'Louesme',
	'FR21358' => 'Lucenay-le-Duc',
	'FR21359' => 'Lucey',
	'FR21360' => 'Lusigny-sur-Ouche',
	'FR21361' => 'Lux',
	'FR21362' => 'Maconge',
	'FR21363' => 'Magnien',
	'FR21364' => 'Magny-Lambert',
	'FR21365' => 'Magny-la-Ville',
	'FR21366' => 'Magny-lès-Aubigny',
	'FR21367' => 'Magny-Montarlot',
	'FR21368' => 'Magny-lès-Villers',
	'FR21369' => 'Magny-Saint-Médard',
	'FR21370' => 'Magny-sur-Tille',
	'FR21371' => 'Les Maillys',
	'FR21372' => 'Maisey-le-Duc',
	'FR21373' => 'Mâlain',
	'FR21374' => 'Maligny',
	'FR21375' => 'Manlay',
	'FR21376' => 'Marandeuil',
	'FR21377' => 'Marcellois',
	'FR21378' => 'Marcenay',
	'FR21379' => 'Marcheseuil',
	'FR21380' => 'Marcigny-sous-Thil',
	'FR21381' => 'Marcilly-et-Dracy',
	'FR21382' => 'Marcilly-Ogny',
	'FR21383' => 'Marcilly-sur-Tille',
	'FR21384' => 'Marey-lès-Fussey',
	'FR21385' => 'Marey-sur-Tille',
	'FR21386' => 'Marigny-le-Cahouët',
	'FR21387' => 'Marigny-lès-Reullée',
	'FR21388' => 'Marliens',
	'FR21389' => 'Marmagne',
	'FR21390' => 'Marsannay-la-Côte',
	'FR21391' => 'Marsannay-le-Bois',
	'FR21392' => 'Martrois',
	'FR21393' => 'Massingy',
	'FR21394' => 'Massingy-lès-Semur',
	'FR21395' => 'Massingy-lès-Vitteaux',
	'FR21396' => 'Mauvilly',
	'FR21397' => 'Mavilly-Mandelot',
	'FR21398' => 'Maxilly-sur-Saône',
	'FR21399' => 'Meilly-sur-Rouvres',
	'FR21400' => 'Le Meix',
	'FR21401' => 'Meloisey',
	'FR21402' => 'Menesble',
	'FR21403' => 'Ménessaire',
	'FR21404' => 'Ménétreux-le-Pitois',
	'FR21405' => 'Merceuil',
	'FR21406' => 'Mesmont',
	'FR21407' => 'Messanges',
	'FR21408' => 'Messigny-et-Vantoux',
	'FR21409' => 'Meuilley',
	'FR21410' => 'Meulson',
	'FR21411' => 'Meursanges',
	'FR21412' => 'Meursault',
	'FR21413' => 'Millery',
	'FR21414' => 'Mimeure',
	'FR21415' => 'Minot',
	'FR21416' => 'Mirebeau-sur-Bèze',
	'FR21417' => 'Missery',
	'FR21418' => 'Moitron',
	'FR21419' => 'Molesme',
	'FR21420' => 'Molinot',
	'FR21421' => 'Moloy',
	'FR21422' => 'Molphey',
	'FR21423' => 'Montagny-lès-Beaune',
	'FR21424' => 'Montagny-lès-Seurre',
	'FR21425' => 'Montbard',
	'FR21426' => 'Montberthault',
	'FR21427' => 'Montceau-et-Écharnant',
	'FR21428' => 'Monthelie',
	'FR21429' => 'Montigny-Montfort',
	'FR21430' => 'Montigny-Saint-Barthélemy',
	'FR21431' => 'Montigny-sur-Armançon',
	'FR21432' => 'Montigny-sur-Aube',
	'FR21433' => 'Montigny-Mornay-Villeneuve-sur-Vingeanne',
	'FR21434' => 'Montlay-en-Auxois',
	'FR21435' => 'Montliot-et-Courcelles',
	'FR21436' => 'Montmain',
	'FR21437' => 'Montmançon',
	'FR21438' => 'Montmoyen',
	'FR21439' => 'Montoillot',
	'FR21440' => 'Montot',
	'FR21441' => 'Mont-Saint-Jean',
	'FR21442' => 'Morey-Saint-Denis',
	'FR21444' => 'Mosson',
	'FR21445' => 'La Motte-Ternant',
	'FR21446' => 'Moutiers-Saint-Jean',
	'FR21447' => 'Musigny',
	'FR21448' => 'Mussy-la-Fosse',
	'FR21449' => 'Nan-sous-Thil',
	'FR21450' => 'Nantoux',
	'FR21451' => 'Nesle-et-Massoult',
	'FR21452' => 'Neuilly-lès-Dijon',
	'FR21454' => 'Nicey',
	'FR21455' => 'Nod-sur-Seine',
	'FR21456' => 'Nogent-lès-Montbard',
	'FR21457' => 'Noidan',
	'FR21458' => 'Noiron-sous-Gevrey',
	'FR21459' => 'Noiron-sur-Bèze',
	'FR21460' => 'Noiron-sur-Seine',
	'FR21461' => 'Nolay',
	'FR21462' => 'Norges-la-Ville',
	'FR21463' => 'Normier',
	'FR21464' => 'Nuits-Saint-Georges',
	'FR21465' => 'Obtrée',
	'FR21466' => 'Oigny',
	'FR21467' => 'Oisilly',
	'FR21468' => 'Orain',
	'FR21469' => 'Orgeux',
	'FR21470' => 'Origny',
	'FR21471' => 'Orret',
	'FR21472' => 'Orville',
	'FR21473' => 'Ouges',
	'FR21474' => 'Pagny-la-Ville',
	'FR21475' => 'Pagny-le-Château',
	'FR21476' => 'Painblanc',
	'FR21477' => 'Panges',
	'FR21478' => 'Pasques',
	'FR21479' => 'Pellerey',
	'FR21480' => 'Pernand-Vergelesses',
	'FR21481' => 'Perrigny-lès-Dijon',
	'FR21482' => 'Perrigny-sur-lOgnon',
	'FR21483' => 'Pichanges',
	'FR21484' => 'Planay',
	'FR21485' => 'Plombières-lès-Dijon',
	'FR21487' => 'Pluvet',
	'FR21488' => 'Poinçon-lès-Larrey',
	'FR21489' => 'Poiseul-la-Grange',
	'FR21490' => 'Poiseul-la-Ville-et-Laperrière',
	'FR21491' => 'Poiseul-lès-Saulx',
	'FR21492' => 'Pommard',
	'FR21493' => 'Poncey-lès-Athée',
	'FR21494' => 'Poncey-sur-lIgnon',
	'FR21495' => 'Pont',
	'FR21496' => 'Pontailler-sur-Saône',
	'FR21497' => 'Pont-et-Massène',
	'FR21498' => 'Posanges',
	'FR21499' => 'Pothières',
	'FR21500' => 'Pouillenay',
	'FR21501' => 'Pouilly-en-Auxois',
	'FR21502' => 'Pouilly-sur-Saône',
	'FR21503' => 'Pouilly-sur-Vingeanne',
	'FR21504' => 'Prâlon',
	'FR21505' => 'Précy-sous-Thil',
	'FR21506' => 'Premeaux-Prissey',
	'FR21507' => 'Premières',
	'FR21508' => 'Prenois',
	'FR21510' => 'Prusly-sur-Ource',
	'FR21511' => 'Puits',
	'FR21512' => 'Puligny-Montrachet',
	'FR21514' => 'Quemigny-sur-Seine',
	'FR21515' => 'Quetigny',
	'FR21516' => 'Quincerot',
	'FR21517' => 'Quincey',
	'FR21518' => 'Quincy-le-Vicomte',
	'FR21519' => 'Recey-sur-Ource',
	'FR21520' => 'Remilly-en-Montagne',
	'FR21521' => 'Remilly-sur-Tille',
	'FR21522' => 'Renève',
	'FR21523' => 'Reulle-Vergy',
	'FR21524' => 'Riel-les-Eaux',
	'FR21525' => 'La Roche-en-Brenil',
	'FR21526' => 'Rochefort-sur-Brévon',
	'FR21527' => 'La Rochepot',
	'FR21528' => 'La Roche-Vanneau',
	'FR21529' => 'Roilly',
	'FR21530' => 'Rougemont',
	'FR21531' => 'Rouvray',
	'FR21532' => 'Rouvres-en-Plaine',
	'FR21533' => 'Rouvres-sous-Meilly',
	'FR21534' => 'Ruffey-lès-Beaune',
	'FR21535' => 'Ruffey-lès-Echirey',
	'FR21536' => 'Sacquenay',
	'FR21537' => 'Saffres',
	'FR21538' => 'Saint-Andeux',
	'FR21539' => 'Saint-Anthot',
	'FR21540' => 'Saint-Apollinaire',
	'FR21541' => 'Saint-Aubin',
	'FR21542' => 'Saint-Bernard',
	'FR21543' => 'Saint-Broing-les-Moines',
	'FR21544' => 'Sainte-Colombe-en-Auxois',
	'FR21545' => 'Sainte-Colombe-sur-Seine',
	'FR21546' => 'Saint-Didier',
	'FR21547' => 'Saint-Euphrône',
	'FR21548' => 'Saint-Germain-de-Modéon',
	'FR21549' => 'Saint-Germain-le-Rocheux',
	'FR21550' => 'Saint-Germain-lès-Senailly',
	'FR21552' => 'Saint-Hélier',
	'FR21553' => 'Saint-Jean-de-Bœuf',
	'FR21554' => 'Saint-Jean-de-Losne',
	'FR21555' => 'Saint-Julien',
	'FR21556' => 'Saint-Léger-Triey',
	'FR21557' => 'Saint-Marc-sur-Seine',
	'FR21558' => 'Sainte-Marie-la-Blanche',
	'FR21559' => 'Sainte-Marie-sur-Ouche',
	'FR21560' => 'Saint-Martin-de-la-Mer',
	'FR21561' => 'Saint-Martin-du-Mont',
	'FR21562' => 'Saint-Maurice-sur-Vingeanne',
	'FR21563' => 'Saint-Mesmin',
	'FR21564' => 'Saint-Nicolas-lès-Cîteaux',
	'FR21565' => 'Saint-Philibert',
	'FR21566' => 'Saint-Pierre-en-Vaux',
	'FR21567' => 'Saint-Prix-lès-Arnay',
	'FR21568' => 'Saint-Rémy',
	'FR21569' => 'Saint-Romain',
	'FR21570' => 'Sainte-Sabine',
	'FR21571' => 'Saint-Sauveur',
	'FR21572' => 'Saint-Seine-en-Bâche',
	'FR21573' => 'Saint-Seine-lAbbaye',
	'FR21574' => 'Saint-Seine-sur-Vingeanne',
	'FR21575' => 'Saint-Symphorien-sur-Saône',
	'FR21576' => 'Saint-Thibault',
	'FR21577' => 'Saint-Usage',
	'FR21578' => 'Saint-Victor-sur-Ouche',
	'FR21579' => 'Salives',
	'FR21580' => 'Salmaise',
	'FR21581' => 'Samerey',
	'FR21582' => 'Santenay',
	'FR21583' => 'Santosse',
	'FR21584' => 'Saulieu',
	'FR21585' => 'Saulon-la-Chapelle',
	'FR21586' => 'Saulon-la-Rue',
	'FR21587' => 'Saulx-le-Duc',
	'FR21588' => 'Saussey',
	'FR21589' => 'Saussy',
	'FR21590' => 'Savigny-lès-Beaune',
	'FR21591' => 'Savigny-le-Sec',
	'FR21592' => 'Savigny-sous-Mâlain',
	'FR21593' => 'Savilly',
	'FR21594' => 'Savoisy',
	'FR21595' => 'Savolles',
	'FR21596' => 'Savouges',
	'FR21597' => 'Segrois',
	'FR21598' => 'Seigny',
	'FR21599' => 'Selongey',
	'FR21600' => 'Semarey',
	'FR21601' => 'Semezanges',
	'FR21602' => 'Semond',
	'FR21603' => 'Semur-en-Auxois',
	'FR21604' => 'Senailly',
	'FR21605' => 'Sennecey-lès-Dijon',
	'FR21606' => 'Ladoix-Serrigny',
	'FR21607' => 'Seurre',
	'FR21608' => 'Sincey-lès-Rouvray',
	'FR21609' => 'Soirans',
	'FR21610' => 'Soissons-sur-Nacey',
	'FR21611' => 'Sombernon',
	'FR21612' => 'Souhey',
	'FR21613' => 'Soussey-sur-Brionne',
	'FR21614' => 'Spoy',
	'FR21615' => 'Sussey',
	'FR21616' => 'Tailly',
	'FR21617' => 'Talant',
	'FR21618' => 'Talmay',
	'FR21619' => 'Tanay',
	'FR21620' => 'Tarsul',
	'FR21622' => 'Tart-le-Bas',
	'FR21623' => 'Tart',
	'FR21624' => 'Tellecey',
	'FR21625' => 'Ternant',
	'FR21626' => 'Terrefondrée',
	'FR21627' => 'Thenissey',
	'FR21628' => 'Thoires',
	'FR21629' => 'Thoisy-la-Berchère',
	'FR21630' => 'Thoisy-le-Désert',
	'FR21631' => 'Thomirey',
	'FR21632' => 'Thorey-en-Plaine',
	'FR21633' => 'Thorey-sous-Charny',
	'FR21634' => 'Thorey-sur-Ouche',
	'FR21635' => 'Thoste',
	'FR21636' => 'Thury',
	'FR21637' => 'Tichey',
	'FR21638' => 'Til-Châtel',
	'FR21639' => 'Tillenay',
	'FR21640' => 'Torcy-et-Pouligny',
	'FR21641' => 'Touillon',
	'FR21642' => 'Toutry',
	'FR21643' => 'Tréclun',
	'FR21644' => 'Trochères',
	'FR21645' => 'Trouhans',
	'FR21646' => 'Trouhaut',
	'FR21647' => 'Trugny',
	'FR21648' => 'Turcey',
	'FR21649' => 'Uncey-le-Franc',
	'FR21650' => 'Urcy',
	'FR21651' => 'Val-Suzon',
	'FR21652' => 'Vandenesse-en-Auxois',
	'FR21653' => 'Vannaire',
	'FR21655' => 'Vanvey',
	'FR21656' => 'Varanges',
	'FR21657' => 'Varois-et-Chaignot',
	'FR21659' => 'Vaux-Saules',
	'FR21660' => 'Veilly',
	'FR21661' => 'Velars-sur-Ouche',
	'FR21662' => 'Velogny',
	'FR21663' => 'Venarey-les-Laumes',
	'FR21664' => 'Verdonnet',
	'FR21665' => 'Vernois-lès-Vesvres',
	'FR21666' => 'Vernot',
	'FR21667' => 'Véronnes',
	'FR21669' => 'Verrey-sous-Drée',
	'FR21670' => 'Verrey-sous-Salmaise',
	'FR21671' => 'Vertault',
	'FR21672' => 'Vesvres',
	'FR21673' => 'Veuvey-sur-Ouche',
	'FR21674' => 'Veuxhaulles-sur-Aube',
	'FR21675' => 'Vianges',
	'FR21676' => 'Vic-de-Chassenay',
	'FR21677' => 'Vic-des-Prés',
	'FR21678' => 'Vic-sous-Thil',
	'FR21679' => 'Vieilmoulin',
	'FR21680' => 'Vielverge',
	'FR21681' => 'Vieux-Château',
	'FR21682' => 'Viévigne',
	'FR21683' => 'Viévy',
	'FR21684' => 'Vignoles',
	'FR21685' => 'Villaines-en-Duesmois',
	'FR21686' => 'Villaines-les-Prévôtes',
	'FR21687' => 'Villargoix',
	'FR21688' => 'Villars-Fontaine',
	'FR21689' => 'Villars-et-Villenotte',
	'FR21690' => 'Villeberny',
	'FR21691' => 'Villebichot',
	'FR21692' => 'Villecomte',
	'FR21693' => 'Villedieu',
	'FR21694' => 'Villeferry',
	'FR21695' => 'La Villeneuve-les-Convers',
	'FR21696' => 'Villeneuve-sous-Charigny',
	'FR21698' => 'Villers-la-Faye',
	'FR21699' => 'Villers-les-Pots',
	'FR21700' => 'Villers-Patras',
	'FR21701' => 'Villers-Rotin',
	'FR21702' => 'Villey-sur-Tille',
	'FR21703' => 'Villiers-en-Morvan',
	'FR21704' => 'Villiers-le-Duc',
	'FR21705' => 'Villotte-Saint-Seine',
	'FR21706' => 'Villotte-sur-Ource',
	'FR21707' => 'Villy-en-Auxois',
	'FR21708' => 'Villy-le-Moutier',
	'FR21709' => 'Viserny',
	'FR21710' => 'Vitteaux',
	'FR21711' => 'Vix',
	'FR21712' => 'Volnay',
	'FR21713' => 'Vonges',
	'FR21714' => 'Vosne-Romanée',
	'FR21715' => 'Voudenay',
	'FR21716' => 'Vougeot',
	'FR21717' => 'Voulaines-les-Templiers',
	'FR22001' => 'Allineuc',
	'FR22002' => 'Andel',
	'FR22003' => 'Aucaleuc',
	'FR22004' => 'Bégard',
	'FR22005' => 'Belle-Isle-en-Terre',
	'FR22006' => 'Berhet',
	'FR22008' => 'Bobital',
	'FR22009' => 'Le Bodéo',
	'FR22011' => 'Boqueho',
	'FR22012' => 'La Bouillie',
	'FR22013' => 'Bourbriac',
	'FR22014' => 'Bourseul',
	'FR22015' => 'Bréhand',
	'FR22016' => 'Île-de-Bréhat',
	'FR22018' => 'Brélidy',
	'FR22019' => 'Bringolo',
	'FR22020' => 'Broons',
	'FR22021' => 'Brusvily',
	'FR22023' => 'Bulat-Pestivien',
	'FR22024' => 'Calanhel',
	'FR22025' => 'Callac',
	'FR22026' => 'Calorguen',
	'FR22027' => 'Le Cambout',
	'FR22028' => 'Camlez',
	'FR22029' => 'Canihuel',
	'FR22030' => 'Caouënnec-Lanvézéac',
	'FR22031' => 'Carnoët',
	'FR22032' => 'Caulnes',
	'FR22033' => 'Caurel',
	'FR22034' => 'Cavan',
	'FR22035' => 'Les Champs-Géraux',
	'FR22036' => 'La Chapelle-Blanche',
	'FR22037' => 'La Chapelle-Neuve',
	'FR22039' => 'La Chèze',
	'FR22040' => 'Coadout',
	'FR22041' => 'Coatascorn',
	'FR22042' => 'Coatréven',
	'FR22043' => 'Coëtlogon',
	'FR22044' => 'Coëtmieux',
	'FR22045' => 'Cohiniac',
	'FR22046' => 'Le Mené',
	'FR22047' => 'Corlay',
	'FR22048' => 'Corseul',
	'FR22049' => 'Créhen',
	'FR22050' => 'Dinan',
	'FR22052' => 'Duault',
	'FR22053' => 'Éréac',
	'FR22054' => 'Erquy',
	'FR22055' => 'Binic-Étables-sur-Mer',
	'FR22056' => 'Évran',
	'FR22057' => 'Le Faouët',
	'FR22059' => 'Le Fœil',
	'FR22060' => 'Gausson',
	'FR22061' => 'Glomel',
	'FR22062' => 'Gomené',
	'FR22063' => 'Gommenech',
	'FR22064' => 'Gouarec',
	'FR22065' => 'Goudelin',
	'FR22067' => 'Grâces',
	'FR22068' => 'Grâce-Uzel',
	'FR22069' => 'Guenroc',
	'FR22070' => 'Guingamp',
	'FR22071' => 'Guitté',
	'FR22072' => 'Gurunhuel',
	'FR22073' => 'La Harmoye',
	'FR22074' => 'Le Haut-Corlay',
	'FR22075' => 'Hémonstoir',
	'FR22076' => 'Hénanbihen',
	'FR22077' => 'Hénansal',
	'FR22079' => 'Hénon',
	'FR22081' => 'Hillion',
	'FR22082' => 'Le Hinglé',
	'FR22083' => 'Illifaut',
	'FR22084' => 'Jugon-les-Lacs - Commune nouvelle',
	'FR22085' => 'Kerbors',
	'FR22086' => 'Kerfot',
	'FR22087' => 'Kergrist-Moëlou',
	'FR22088' => 'Kerien',
	'FR22090' => 'Kermaria-Sulard',
	'FR22091' => 'Kermoroch',
	'FR22092' => 'Kerpert',
	'FR22093' => 'Lamballe-Armor',
	'FR22094' => 'Lancieux',
	'FR22095' => 'Landebaëron',
	'FR22096' => 'Landébia',
	'FR22097' => 'La Landec',
	'FR22098' => 'Landéhen',
	'FR22099' => 'Lanfains',
	'FR22101' => 'Langoat',
	'FR22103' => 'Langrolay-sur-Rance',
	'FR22104' => 'Languédias',
	'FR22105' => 'Languenan',
	'FR22106' => 'Langueux',
	'FR22107' => 'Bon Repos sur Blavet',
	'FR22108' => 'Lanleff',
	'FR22109' => 'Lanloup',
	'FR22110' => 'Lanmérin',
	'FR22111' => 'Lanmodez',
	'FR22112' => 'Lannebert',
	'FR22113' => 'Lannion',
	'FR22114' => 'Lanrelas',
	'FR22115' => 'Lanrivain',
	'FR22116' => 'Lanrodec',
	'FR22117' => 'Lantic',
	'FR22118' => 'Lanvallay',
	'FR22119' => 'Lanvellec',
	'FR22121' => 'Lanvollon',
	'FR22122' => 'Laurenan',
	'FR22124' => 'Lescouët-Gouarec',
	'FR22126' => 'Le Leslay',
	'FR22127' => 'Lézardrieux',
	'FR22128' => 'Locarn',
	'FR22129' => 'Loc-Envel',
	'FR22131' => 'Loguivy-Plougras',
	'FR22132' => 'Lohuec',
	'FR22133' => 'Loscouët-sur-Meu',
	'FR22134' => 'Louannec',
	'FR22135' => 'Louargat',
	'FR22136' => 'Loudéac',
	'FR22137' => 'Maël-Carhaix',
	'FR22138' => 'Maël-Pestivien',
	'FR22139' => 'Magoar',
	'FR22140' => 'La Malhoure',
	'FR22141' => 'Mantallot',
	'FR22143' => 'Matignon',
	'FR22144' => 'La Méaugon',
	'FR22145' => 'Mégrit',
	'FR22146' => 'Mellionnec',
	'FR22147' => 'Merdrignac',
	'FR22148' => 'Mérillac',
	'FR22149' => 'Merléac',
	'FR22150' => 'Le Merzer',
	'FR22152' => 'Minihy-Tréguier',
	'FR22153' => 'Moncontour',
	'FR22155' => 'La Motte',
	'FR22156' => 'Moustéru',
	'FR22157' => 'Le Moustoir',
	'FR22158' => 'Guerlédan',
	'FR22160' => 'Noyal',
	'FR22161' => 'Pabu',
	'FR22162' => 'Paimpol',
	'FR22163' => 'Paule',
	'FR22164' => 'Pédernec',
	'FR22165' => 'Penguily',
	'FR22166' => 'Penvénan',
	'FR22168' => 'Perros-Guirec',
	'FR22169' => 'Peumerit-Quintin',
	'FR22170' => 'Plaine-Haute',
	'FR22171' => 'Plaintel',
	'FR22172' => 'Plancoët',
	'FR22174' => 'Pléboulle',
	'FR22175' => 'Plédéliac',
	'FR22176' => 'Plédran',
	'FR22177' => 'Pléguien',
	'FR22178' => 'Pléhédel',
	'FR22179' => 'Fréhel',
	'FR22180' => 'Plélan-le-Petit',
	'FR22181' => 'Plélauff',
	'FR22182' => 'Plélo',
	'FR22183' => 'Plémet',
	'FR22184' => 'Plémy',
	'FR22185' => 'Plénée-Jugon',
	'FR22186' => 'Pléneuf-Val-André',
	'FR22187' => 'Plérin',
	'FR22188' => 'Plerneuf',
	'FR22189' => 'Plésidy',
	'FR22190' => 'Pleslin-Trigavou',
	'FR22193' => 'Plestan',
	'FR22194' => 'Plestin-les-Grèves',
	'FR22195' => 'Pleubian',
	'FR22196' => 'Pleudaniel',
	'FR22197' => 'Pleudihen-sur-Rance',
	'FR22198' => 'Pleumeur-Bodou',
	'FR22199' => 'Pleumeur-Gautier',
	'FR22200' => 'Pléven',
	'FR22201' => 'Plévenon',
	'FR22202' => 'Plévin',
	'FR22203' => 'Plœuc-LHermitage',
	'FR22204' => 'Ploëzal',
	'FR22205' => 'Plorec-sur-Arguenon',
	'FR22206' => 'Châtelaudren-Plouagat',
	'FR22207' => 'Plouaret',
	'FR22208' => 'Plouasne',
	'FR22209' => 'Beaussais-sur-Mer',
	'FR22210' => 'Ploubazlanec',
	'FR22211' => 'Ploubezre',
	'FR22212' => 'Plouëc-du-Trieux',
	'FR22213' => 'Plouër-sur-Rance',
	'FR22214' => 'Plouézec',
	'FR22215' => 'Ploufragan',
	'FR22216' => 'Plougonver',
	'FR22217' => 'Plougras',
	'FR22218' => 'Plougrescant',
	'FR22219' => 'Plouguenast-Langast',
	'FR22220' => 'Plouguernével',
	'FR22221' => 'Plouguiel',
	'FR22222' => 'Plouha',
	'FR22223' => 'Plouisy',
	'FR22224' => 'Ploulech',
	'FR22225' => 'Ploumagoar',
	'FR22226' => 'Ploumilliau',
	'FR22227' => 'Plounérin',
	'FR22228' => 'Plounévez-Moëdec',
	'FR22229' => 'Plounévez-Quintin',
	'FR22231' => 'Plourach',
	'FR22232' => 'Plourhan',
	'FR22233' => 'Plourivo',
	'FR22234' => 'Plouvara',
	'FR22235' => 'Plouzélambre',
	'FR22236' => 'Pludual',
	'FR22237' => 'Pluduno',
	'FR22238' => 'Plufur',
	'FR22239' => 'Plumaudan',
	'FR22240' => 'Plumaugat',
	'FR22241' => 'Plumieux',
	'FR22242' => 'Plurien',
	'FR22243' => 'Plusquellec',
	'FR22244' => 'Plussulien',
	'FR22245' => 'Pluzunet',
	'FR22246' => 'Pommeret',
	'FR22248' => 'Pommerit-le-Vicomte',
	'FR22249' => 'Pont-Melvez',
	'FR22250' => 'Pontrieux',
	'FR22251' => 'Pordic',
	'FR22254' => 'Prat',
	'FR22255' => 'La Prénessaye',
	'FR22256' => 'Quemper-Guézennec',
	'FR22257' => 'Quemperven',
	'FR22258' => 'Quessoy',
	'FR22259' => 'Quévert',
	'FR22260' => 'Le Quillio',
	'FR22261' => 'Quintenic',
	'FR22262' => 'Quintin',
	'FR22263' => 'Le Quiou',
	'FR22264' => 'La Roche-Jaudy',
	'FR22265' => 'Rospez',
	'FR22266' => 'Rostrenen',
	'FR22267' => 'Rouillac',
	'FR22268' => 'Ruca',
	'FR22269' => 'Runan',
	'FR22271' => 'Saint-Adrien',
	'FR22272' => 'Saint-Agathon',
	'FR22273' => 'Saint-Alban',
	'FR22274' => 'Saint-André-des-Eaux',
	'FR22275' => 'Saint-Barnabé',
	'FR22276' => 'Saint-Bihy',
	'FR22277' => 'Saint-Brandan',
	'FR22278' => 'Saint-Brieuc',
	'FR22279' => 'Saint-Caradec',
	'FR22280' => 'Saint-Carné',
	'FR22281' => 'Saint-Carreuc',
	'FR22282' => 'Saint-Cast-le-Guildo',
	'FR22283' => 'Saint-Clet',
	'FR22284' => 'Saint-Connan',
	'FR22285' => 'Saint-Connec',
	'FR22286' => 'Saint-Denoual',
	'FR22287' => 'Saint-Donan',
	'FR22288' => 'Saint-Étienne-du-Gué-de-lIsle',
	'FR22289' => 'Saint-Fiacre',
	'FR22291' => 'Saint-Gildas',
	'FR22293' => 'Saint-Gilles-les-Bois',
	'FR22294' => 'Saint-Gilles-Pligeaux',
	'FR22295' => 'Saint-Gilles-Vieux-Marché',
	'FR22296' => 'Saint-Glen',
	'FR22299' => 'Saint-Hélen',
	'FR22300' => 'Saint-Hervé',
	'FR22302' => 'Saint-Jacut-de-la-Mer',
	'FR22304' => 'Saint-Jean-Kerdaniel',
	'FR22305' => 'Saint-Jouan-de-lIsle',
	'FR22306' => 'Saint-Judoce',
	'FR22307' => 'Saint-Julien',
	'FR22308' => 'Saint-Juvat',
	'FR22309' => 'Saint-Launeuc',
	'FR22310' => 'Saint-Laurent',
	'FR22311' => 'Saint-Lormel',
	'FR22312' => 'Saint-Maden',
	'FR22313' => 'Saint-Martin-des-Prés',
	'FR22314' => 'Saint-Maudan',
	'FR22315' => 'Saint-Maudez',
	'FR22316' => 'Saint-Mayeux',
	'FR22317' => 'Saint-Méloir-des-Bois',
	'FR22318' => 'Saint-Michel-de-Plélan',
	'FR22319' => 'Saint-Michel-en-Grève',
	'FR22320' => 'Saint-Nicodème',
	'FR22321' => 'Saint-Nicolas-du-Pélem',
	'FR22322' => 'Saint-Péver',
	'FR22323' => 'Saint-Pôtan',
	'FR22324' => 'Saint-Quay-Perros',
	'FR22325' => 'Saint-Quay-Portrieux',
	'FR22326' => 'Saint-Rieul',
	'FR22327' => 'Saint-Samson-sur-Rance',
	'FR22328' => 'Saint-Servais',
	'FR22330' => 'Saint-Thélo',
	'FR22331' => 'Sainte-Tréphine',
	'FR22332' => 'Saint-Trimoël',
	'FR22333' => 'Saint-Vran',
	'FR22334' => 'Saint-Igeaux',
	'FR22335' => 'Senven-Léhart',
	'FR22337' => 'Sévignac',
	'FR22338' => 'Squiffiec',
	'FR22339' => 'Taden',
	'FR22340' => 'Tonquédec',
	'FR22341' => 'Tramain',
	'FR22342' => 'Trébédan',
	'FR22343' => 'Trébeurden',
	'FR22344' => 'Trébrivan',
	'FR22345' => 'Trébry',
	'FR22346' => 'Trédaniel',
	'FR22347' => 'Trédarzec',
	'FR22348' => 'Trédias',
	'FR22349' => 'Trédrez-Locquémeau',
	'FR22350' => 'Tréduder',
	'FR22351' => 'Treffrin',
	'FR22352' => 'Tréfumel',
	'FR22353' => 'Trégastel',
	'FR22354' => 'Tréglamus',
	'FR22356' => 'Trégomeur',
	'FR22358' => 'Trégonneau',
	'FR22359' => 'Trégrom',
	'FR22360' => 'Trégueux',
	'FR22361' => 'Tréguidel',
	'FR22362' => 'Tréguier',
	'FR22363' => 'Trélévern',
	'FR22364' => 'Trélivan',
	'FR22365' => 'Trémargat',
	'FR22366' => 'Trémel',
	'FR22368' => 'Tréméreuc',
	'FR22369' => 'Trémeur',
	'FR22370' => 'Tréméven',
	'FR22371' => 'Trémorel',
	'FR22372' => 'Trémuson',
	'FR22373' => 'Tréogan',
	'FR22375' => 'Tressignaux',
	'FR22376' => 'Trévé',
	'FR22377' => 'Tréveneuc',
	'FR22378' => 'Trévérec',
	'FR22379' => 'Trévou-Tréguignec',
	'FR22380' => 'Trévron',
	'FR22381' => 'Trézény',
	'FR22383' => 'Troguéry',
	'FR22384' => 'Uzel',
	'FR22385' => 'La Vicomté-sur-Rance',
	'FR22386' => 'Le Vieux-Bourg',
	'FR22387' => 'Le Vieux-Marché',
	'FR22388' => 'Vildé-Guingalan',
	'FR22389' => 'Yffiniac',
	'FR22390' => 'Yvias',
	'FR22391' => 'Yvignac-la-Tour',
	'FR23001' => 'Ahun',
	'FR23002' => 'Ajain',
	'FR23003' => 'Alleyrat',
	'FR23004' => 'Anzême',
	'FR23005' => 'Arfeuille-Châtain',
	'FR23006' => 'Arrènes',
	'FR23007' => 'Ars',
	'FR23008' => 'Aubusson',
	'FR23009' => 'Auge',
	'FR23010' => 'Augères',
	'FR23011' => 'Aulon',
	'FR23012' => 'Auriat',
	'FR23013' => 'Auzances',
	'FR23014' => 'Azat-Châtenet',
	'FR23015' => 'Azerables',
	'FR23016' => 'Banize',
	'FR23017' => 'Basville',
	'FR23018' => 'Bazelat',
	'FR23019' => 'Beissat',
	'FR23020' => 'Bellegarde-en-Marche',
	'FR23021' => 'Bénévent-lAbbaye',
	'FR23022' => 'Bétête',
	'FR23023' => 'Blaudeix',
	'FR23024' => 'Blessac',
	'FR23025' => 'Bonnat',
	'FR23026' => 'Bord-Saint-Georges',
	'FR23027' => 'Bosmoreau-les-Mines',
	'FR23028' => 'Bosroger',
	'FR23029' => 'Le Bourg-dHem',
	'FR23030' => 'Bourganeuf',
	'FR23031' => 'Boussac',
	'FR23032' => 'Boussac-Bourg',
	'FR23033' => 'La Brionne',
	'FR23034' => 'Brousse',
	'FR23035' => 'Budelière',
	'FR23036' => 'Bussière-Dunoise',
	'FR23037' => 'Bussière-Nouvelle',
	'FR23038' => 'Bussière-Saint-Georges',
	'FR23039' => 'La Celle-Dunoise',
	'FR23040' => 'La Celle-sous-Gouzon',
	'FR23041' => 'La Cellette',
	'FR23042' => 'Ceyroux',
	'FR23043' => 'Chamberaud',
	'FR23044' => 'Chambon-Sainte-Croix',
	'FR23045' => 'Chambon-sur-Voueize',
	'FR23046' => 'Chambonchard',
	'FR23047' => 'Chamborand',
	'FR23048' => 'Champagnat',
	'FR23049' => 'Champsanglard',
	'FR23050' => 'La Chapelle-Baloue',
	'FR23051' => 'La Chapelle-Saint-Martial',
	'FR23052' => 'La Chapelle-Taillefert',
	'FR23053' => 'Chard',
	'FR23054' => 'Charron',
	'FR23055' => 'Châtelard',
	'FR23056' => 'Châtelus-le-Marcheix',
	'FR23057' => 'Châtelus-Malvaleix',
	'FR23058' => 'Le Chauchet',
	'FR23059' => 'La Chaussade',
	'FR23060' => 'Chavanat',
	'FR23061' => 'Chénérailles',
	'FR23062' => 'Chéniers',
	'FR23063' => 'Clairavaux',
	'FR23064' => 'Clugnat',
	'FR23065' => 'Colondannes',
	'FR23066' => 'Le Compas',
	'FR23067' => 'La Courtine',
	'FR23068' => 'Cressat',
	'FR23069' => 'Crocq',
	'FR23070' => 'Crozant',
	'FR23071' => 'Croze',
	'FR23072' => 'Domeyrot',
	'FR23073' => 'Dontreix',
	'FR23074' => 'Le Donzeil',
	'FR23075' => 'Dun-le-Palestel',
	'FR23076' => 'Évaux-les-Bains',
	'FR23077' => 'Faux-la-Montagne',
	'FR23078' => 'Faux-Mazuras',
	'FR23079' => 'Felletin',
	'FR23080' => 'Féniers',
	'FR23081' => 'Flayat',
	'FR23082' => 'Fleurat',
	'FR23083' => 'Fontanières',
	'FR23084' => 'La Forêt-du-Temple',
	'FR23086' => 'Fransèches',
	'FR23087' => 'Fresselines',
	'FR23088' => 'Gartempe',
	'FR23089' => 'Genouillac',
	'FR23090' => 'Gentioux-Pigerolles',
	'FR23091' => 'Gioux',
	'FR23092' => 'Glénic',
	'FR23093' => 'Gouzon',
	'FR23095' => 'Le Grand-Bourg',
	'FR23096' => 'Guéret',
	'FR23097' => 'Issoudun-Létrieix',
	'FR23098' => 'Jalesches',
	'FR23099' => 'Janaillat',
	'FR23100' => 'Jarnages',
	'FR23101' => 'Jouillat',
	'FR23102' => 'Ladapeyre',
	'FR23103' => 'Lafat',
	'FR23104' => 'Lavaufranche',
	'FR23105' => 'Lavaveix-les-Mines',
	'FR23106' => 'Lépaud',
	'FR23107' => 'Lépinas',
	'FR23108' => 'Leyrat',
	'FR23109' => 'Linard-Malval',
	'FR23110' => 'Lioux-les-Monges',
	'FR23111' => 'Lizières',
	'FR23112' => 'Lourdoueix-Saint-Pierre',
	'FR23113' => 'Lupersat',
	'FR23114' => 'Lussat',
	'FR23115' => 'Magnat-lÉtrange',
	'FR23116' => 'Mainsat',
	'FR23117' => 'Maison-Feyne',
	'FR23118' => 'Maisonnisses',
	'FR23119' => 'Malleret',
	'FR23120' => 'Malleret-Boussac',
	'FR23122' => 'Mansat-la-Courrière',
	'FR23123' => 'Les Mars',
	'FR23124' => 'Marsac',
	'FR23125' => 'Le Mas-dArtige',
	'FR23127' => 'Mautes',
	'FR23128' => 'Mazeirat',
	'FR23129' => 'La Mazière-aux-Bons-Hommes',
	'FR23130' => 'Méasnes',
	'FR23131' => 'Mérinchal',
	'FR23132' => 'Montaigut-le-Blanc',
	'FR23133' => 'Montboucher',
	'FR23134' => 'Le Monteil-au-Vicomte',
	'FR23136' => 'Mortroux',
	'FR23137' => 'Mourioux-Vieilleville',
	'FR23138' => 'Moutier-dAhun',
	'FR23139' => 'Moutier-Malcard',
	'FR23140' => 'Moutier-Rozeille',
	'FR23141' => 'Naillat',
	'FR23142' => 'Néoux',
	'FR23143' => 'Noth',
	'FR23144' => 'La Nouaille',
	'FR23145' => 'Nouhant',
	'FR23146' => 'Nouzerines',
	'FR23147' => 'Nouzerolles',
	'FR23148' => 'Nouziers',
	'FR23149' => 'Parsac-Rimondeix',
	'FR23150' => 'Peyrabout',
	'FR23151' => 'Peyrat-la-Nonière',
	'FR23152' => 'Pierrefitte',
	'FR23154' => 'Pionnat',
	'FR23155' => 'Pontarion',
	'FR23156' => 'Pontcharraud',
	'FR23157' => 'La Pouge',
	'FR23158' => 'Poussanges',
	'FR23159' => 'Puy-Malsignat',
	'FR23160' => 'Reterre',
	'FR23162' => 'Roches',
	'FR23164' => 'Rougnat',
	'FR23165' => 'Royère-de-Vassivière',
	'FR23166' => 'Sagnat',
	'FR23167' => 'Sannat',
	'FR23168' => 'Sardent',
	'FR23169' => 'La Saunière',
	'FR23170' => 'Savennes',
	'FR23171' => 'Sermur',
	'FR23172' => 'La Serre-Bussière-Vieille',
	'FR23173' => 'Soubrebost',
	'FR23174' => 'Soumans',
	'FR23175' => 'Sous-Parsat',
	'FR23176' => 'La Souterraine',
	'FR23177' => 'Saint-Agnant-de-Versillat',
	'FR23178' => 'Saint-Agnant-près-Crocq',
	'FR23179' => 'Saint-Alpinien',
	'FR23180' => 'Saint-Amand',
	'FR23181' => 'Saint-Amand-Jartoudeix',
	'FR23182' => 'Saint-Avit-de-Tardes',
	'FR23183' => 'Saint-Avit-le-Pauvre',
	'FR23184' => 'Saint-Bard',
	'FR23185' => 'Saint-Chabrais',
	'FR23186' => 'Saint-Christophe',
	'FR23187' => 'Saint-Dizier-la-Tour',
	'FR23188' => 'Saint-Dizier-les-Domaines',
	'FR23189' => 'Saint-Dizier-Masbaraud',
	'FR23190' => 'Saint-Domet',
	'FR23191' => 'Saint-Éloi',
	'FR23192' => 'Fursac',
	'FR23193' => 'Sainte-Feyre',
	'FR23194' => 'Sainte-Feyre-la-Montagne',
	'FR23195' => 'Saint-Fiel',
	'FR23196' => 'Saint-Frion',
	'FR23197' => 'Saint-Georges-la-Pouge',
	'FR23198' => 'Saint-Georges-Nigremont',
	'FR23199' => 'Saint-Germain-Beaupré',
	'FR23200' => 'Saint-Goussaud',
	'FR23201' => 'Saint-Hilaire-la-Plaine',
	'FR23202' => 'Saint-Hilaire-le-Château',
	'FR23203' => 'Saint-Julien-la-Genête',
	'FR23204' => 'Saint-Julien-le-Châtel',
	'FR23205' => 'Saint-Junien-la-Bregère',
	'FR23206' => 'Saint-Laurent',
	'FR23207' => 'Saint-Léger-Bridereix',
	'FR23208' => 'Saint-Léger-le-Guérétois',
	'FR23209' => 'Saint-Loup',
	'FR23210' => 'Saint-Maixant',
	'FR23211' => 'Saint-Marc-à-Frongier',
	'FR23212' => 'Saint-Marc-à-Loubaud',
	'FR23213' => 'Saint-Marien',
	'FR23214' => 'Saint-Martial-le-Mont',
	'FR23215' => 'Saint-Martial-le-Vieux',
	'FR23216' => 'Saint-Martin-Château',
	'FR23217' => 'Saint-Martin-Sainte-Catherine',
	'FR23218' => 'Saint-Maurice-près-Crocq',
	'FR23219' => 'Saint-Maurice-la-Souterraine',
	'FR23220' => 'Saint-Médard-la-Rochette',
	'FR23221' => 'Saint-Merd-la-Breuille',
	'FR23222' => 'Saint-Michel-de-Veisse',
	'FR23223' => 'Saint-Moreil',
	'FR23224' => 'Saint-Oradoux-de-Chirouze',
	'FR23225' => 'Saint-Oradoux-près-Crocq',
	'FR23226' => 'Saint-Pardoux-dArnet',
	'FR23227' => 'Saint-Pardoux-Morterolles',
	'FR23228' => 'Saint-Pardoux-le-Neuf',
	'FR23229' => 'Saint-Pardoux-les-Cards',
	'FR23230' => 'Saint-Pierre-Chérignat',
	'FR23232' => 'Saint-Pierre-Bellevue',
	'FR23233' => 'Saint-Pierre-le-Bost',
	'FR23234' => 'Saint-Priest',
	'FR23235' => 'Saint-Priest-la-Feuille',
	'FR23236' => 'Saint-Priest-la-Plaine',
	'FR23237' => 'Saint-Priest-Palus',
	'FR23238' => 'Saint-Quentin-la-Chabanne',
	'FR23239' => 'Saint-Sébastien',
	'FR23240' => 'Saint-Silvain-Bas-le-Roc',
	'FR23241' => 'Saint-Silvain-Bellegarde',
	'FR23242' => 'Saint-Silvain-Montaigut',
	'FR23243' => 'Saint-Silvain-sous-Toulx',
	'FR23244' => 'Saint-Sulpice-le-Dunois',
	'FR23245' => 'Saint-Sulpice-le-Guérétois',
	'FR23246' => 'Saint-Sulpice-les-Champs',
	'FR23247' => 'Saint-Vaury',
	'FR23248' => 'Saint-Victor-en-Marche',
	'FR23249' => 'Saint-Yrieix-la-Montagne',
	'FR23250' => 'Saint-Yrieix-les-Bois',
	'FR23251' => 'Tardes',
	'FR23252' => 'Tercillat',
	'FR23253' => 'Thauron',
	'FR23254' => 'Toulx-Sainte-Croix',
	'FR23255' => 'Trois-Fonds',
	'FR23257' => 'Vallière',
	'FR23258' => 'Vareilles',
	'FR23259' => 'Verneiges',
	'FR23260' => 'Vidaillat',
	'FR23261' => 'Viersat',
	'FR23262' => 'Vigeville',
	'FR23263' => 'Villard',
	'FR23264' => 'La Villedieu',
	'FR23265' => 'La Villeneuve',
	'FR23266' => 'La Villetelle',
	'FR24001' => 'Abjat-sur-Bandiat',
	'FR24002' => 'Agonac',
	'FR24004' => 'Ajat',
	'FR24005' => 'Alles-sur-Dordogne',
	'FR24006' => 'Allas-les-Mines',
	'FR24007' => 'Allemans',
	'FR24008' => 'Angoisse',
	'FR24009' => 'Anlhiac',
	'FR24010' => 'Annesse-et-Beaulieu',
	'FR24011' => 'Antonne-et-Trigonant',
	'FR24012' => 'Archignac',
	'FR24014' => 'Aubas',
	'FR24015' => 'Audrix',
	'FR24016' => 'Augignac',
	'FR24018' => 'Auriac-du-Périgord',
	'FR24019' => 'Azerat',
	'FR24020' => 'La Bachellerie',
	'FR24021' => 'Badefols-dAns',
	'FR24022' => 'Badefols-sur-Dordogne',
	'FR24023' => 'Baneuil',
	'FR24024' => 'Bardou',
	'FR24025' => 'Bars',
	'FR24026' => 'Bassillac et Auberoche',
	'FR24027' => 'Bayac',
	'FR24028' => 'Beaumontois en Périgord',
	'FR24029' => 'Beaupouyet',
	'FR24030' => 'Beauregard-de-Terrasson',
	'FR24031' => 'Beauregard-et-Bassac',
	'FR24032' => 'Beauronne',
	'FR24034' => 'Beleymas',
	'FR24035' => 'Pays de Belvès',
	'FR24036' => 'Berbiguières',
	'FR24037' => 'Bergerac',
	'FR24038' => 'Bertric-Burée',
	'FR24039' => 'Besse',
	'FR24040' => 'Beynac-et-Cazenac',
	'FR24042' => 'Biras',
	'FR24043' => 'Biron',
	'FR24045' => 'Boisse',
	'FR24046' => 'Boisseuilh',
	'FR24048' => 'Bonneville-et-Saint-Avit-de-Fumadières',
	'FR24050' => 'Borrèze',
	'FR24051' => 'Bosset',
	'FR24052' => 'Bouillac',
	'FR24053' => 'Boulazac Isle Manoire',
	'FR24054' => 'Bouniagues',
	'FR24055' => 'Bourdeilles',
	'FR24056' => 'Le Bourdeix',
	'FR24057' => 'Bourg-des-Maisons',
	'FR24058' => 'Bourg-du-Bost',
	'FR24059' => 'Bourgnac',
	'FR24060' => 'Bourniquel',
	'FR24061' => 'Bourrou',
	'FR24062' => 'Bouteilles-Saint-Sébastien',
	'FR24063' => 'Bouzic',
	'FR24064' => 'Brantôme en Périgord',
	'FR24066' => 'Brouchaud',
	'FR24067' => 'Le Bugue',
	'FR24068' => 'Le Buisson-de-Cadouin',
	'FR24069' => 'Bussac',
	'FR24070' => 'Busserolles',
	'FR24071' => 'Bussière-Badil',
	'FR24073' => 'Calès',
	'FR24074' => 'Calviac-en-Périgord',
	'FR24075' => 'Campagnac-lès-Quercy',
	'FR24076' => 'Campagne',
	'FR24077' => 'Campsegret',
	'FR24080' => 'Capdrot',
	'FR24081' => 'Carlux',
	'FR24082' => 'Carsac-Aillac',
	'FR24083' => 'Carsac-de-Gurson',
	'FR24084' => 'Carves',
	'FR24085' => 'La Cassagne',
	'FR24086' => 'Castelnaud-la-Chapelle',
	'FR24087' => 'Castels et Bézenac',
	'FR24088' => 'Cause-de-Clérans',
	'FR24089' => 'Cazoulès',
	'FR24090' => 'Celles',
	'FR24091' => 'Cénac-et-Saint-Julien',
	'FR24094' => 'Chalagnac',
	'FR24095' => 'Chalais',
	'FR24096' => 'Champagnac-de-Belair',
	'FR24097' => 'Champagne-et-Fontaine',
	'FR24098' => 'Champcevinel',
	'FR24100' => 'Champniers-et-Reilhac',
	'FR24101' => 'Champs-Romain',
	'FR24102' => 'Chancelade',
	'FR24104' => 'Chantérac',
	'FR24105' => 'Chapdeuil',
	'FR24106' => 'La Chapelle-Aubareil',
	'FR24107' => 'La Chapelle-Faucher',
	'FR24108' => 'La Chapelle-Gonaguet',
	'FR24109' => 'La Chapelle-Grésignac',
	'FR24110' => 'La Chapelle-Montabourlet',
	'FR24111' => 'La Chapelle-Montmoreau',
	'FR24113' => 'La Chapelle-Saint-Jean',
	'FR24114' => 'Chassaignes',
	'FR24115' => 'Château-lÉvêque',
	'FR24116' => 'Châtres',
	'FR24117' => 'Les Coteaux Périgourdins',
	'FR24119' => 'Cherval',
	'FR24120' => 'Cherveix-Cubas',
	'FR24121' => 'Chourgnac',
	'FR24122' => 'Cladech',
	'FR24123' => 'Clermont-de-Beauregard',
	'FR24124' => 'Clermont-dExcideuil',
	'FR24126' => 'Colombier',
	'FR24128' => 'Comberanche-et-Épeluche',
	'FR24129' => 'Condat-sur-Trincou',
	'FR24130' => 'Condat-sur-Vézère',
	'FR24131' => 'Connezac',
	'FR24132' => 'Conne-de-Labarde',
	'FR24133' => 'La Coquille',
	'FR24134' => 'Corgnac-sur-lIsle',
	'FR24135' => 'Cornille',
	'FR24136' => 'Coubjours',
	'FR24137' => 'Coulaures',
	'FR24138' => 'Coulounieix-Chamiers',
	'FR24139' => 'Coursac',
	'FR24140' => 'Cours-de-Pile',
	'FR24141' => 'Coutures',
	'FR24142' => 'Coux et Bigaroque-Mouzens',
	'FR24143' => 'Couze-et-Saint-Front',
	'FR24144' => 'Creyssac',
	'FR24145' => 'Creysse',
	'FR24146' => 'Creyssensac-et-Pissot',
	'FR24147' => 'Cubjac-Auvézère-Val dAns',
	'FR24148' => 'Cunèges',
	'FR24150' => 'Daglan',
	'FR24151' => 'Doissat',
	'FR24152' => 'Domme',
	'FR24153' => 'La Dornac',
	'FR24154' => 'Douchapt',
	'FR24155' => 'Douville',
	'FR24156' => 'La Douze',
	'FR24157' => 'Douzillac',
	'FR24158' => 'Dussac',
	'FR24159' => 'Échourgnac',
	'FR24160' => 'Église-Neuve-de-Vergt',
	'FR24161' => 'Église-Neuve-dIssac',
	'FR24162' => 'Escoire',
	'FR24163' => 'Étouars',
	'FR24164' => 'Excideuil',
	'FR24165' => 'Eygurande-et-Gardedeuil',
	'FR24167' => 'Eymet',
	'FR24168' => 'Plaisance',
	'FR24171' => 'Eyzerac',
	'FR24172' => 'Les Eyzies',
	'FR24174' => 'Fanlac',
	'FR24175' => 'Les Farges',
	'FR24176' => 'Faurilles',
	'FR24177' => 'FAUX',
	'FR24179' => 'La Feuillade',
	'FR24180' => 'Firbeix',
	'FR24182' => 'Le Fleix',
	'FR24183' => 'Fleurac',
	'FR24184' => 'Florimont-Gaumier',
	'FR24186' => 'Fonroque',
	'FR24188' => 'Fossemagne',
	'FR24189' => 'Fougueyrolles',
	'FR24190' => 'Fouleix',
	'FR24191' => 'Fraisse',
	'FR24192' => 'Gabillou',
	'FR24193' => 'Gageac-et-Rouillac',
	'FR24194' => 'Gardonne',
	'FR24195' => 'Gaugeac',
	'FR24196' => 'Génis',
	'FR24197' => 'Ginestet',
	'FR24199' => 'Gout-Rossignol',
	'FR24200' => 'Grand-Brassac',
	'FR24202' => 'Granges-dAns',
	'FR24205' => 'Grignols',
	'FR24206' => 'Grives',
	'FR24207' => 'Groléjac',
	'FR24208' => 'Grun-Bordas',
	'FR24209' => 'Hautefaye',
	'FR24210' => 'Hautefort',
	'FR24211' => 'Issac',
	'FR24212' => 'Issigeac',
	'FR24213' => 'Jaure',
	'FR24214' => 'Javerlhac-et-la-Chapelle-Saint-Robert',
	'FR24215' => 'Jayac',
	'FR24216' => 'La Jemaye-Ponteyraud',
	'FR24217' => 'Journiac',
	'FR24218' => 'Jumilhac-le-Grand',
	'FR24220' => 'Lacropte',
	'FR24221' => 'Rudeau-Ladosse',
	'FR24222' => 'La Force',
	'FR24223' => 'Lalinde',
	'FR24224' => 'Lamonzie-Montastruc',
	'FR24225' => 'Lamonzie-Saint-Martin',
	'FR24226' => 'Lamothe-Montravel',
	'FR24227' => 'Lanouaille',
	'FR24228' => 'Lanquais',
	'FR24229' => 'Le Lardin-Saint-Lazare',
	'FR24230' => 'Larzac',
	'FR24231' => 'Lavalade',
	'FR24232' => 'Lavaur',
	'FR24234' => 'Les Lèches',
	'FR24236' => 'Léguillac-de-lAuche',
	'FR24237' => 'Lembras',
	'FR24238' => 'Lempzours',
	'FR24240' => 'Limeuil',
	'FR24241' => 'Limeyrat',
	'FR24242' => 'Liorac-sur-Louyre',
	'FR24243' => 'Lisle',
	'FR24244' => 'Lolme',
	'FR24245' => 'Loubejac',
	'FR24246' => 'Lunas',
	'FR24247' => 'Lusignac',
	'FR24248' => 'Lussas-et-Nontronneau',
	'FR24251' => 'Manzac-sur-Vern',
	'FR24252' => 'Marcillac-Saint-Quentin',
	'FR24253' => 'Mareuil en Périgord',
	'FR24254' => 'Marnac',
	'FR24255' => 'Marquay',
	'FR24256' => 'Marsac-sur-lIsle',
	'FR24257' => 'Marsalès',
	'FR24259' => 'Eyraud-Crempse-Maurens',
	'FR24260' => 'Mauzac-et-Grand-Castang',
	'FR24261' => 'Mauzens-et-Miremont',
	'FR24262' => 'Mayac',
	'FR24263' => 'Mazeyrolles',
	'FR24264' => 'Ménesplet',
	'FR24266' => 'Mensignac',
	'FR24267' => 'Mescoules',
	'FR24268' => 'Meyrals',
	'FR24269' => 'Mialet',
	'FR24271' => 'Milhac-de-Nontron',
	'FR24272' => 'Minzac',
	'FR24273' => 'Molières',
	'FR24274' => 'Monbazillac',
	'FR24276' => 'Monestier',
	'FR24277' => 'Monfaucon',
	'FR24278' => 'Monmadalès',
	'FR24279' => 'Monmarvès',
	'FR24280' => 'Monpazier',
	'FR24281' => 'Monsac',
	'FR24282' => 'Monsaguel',
	'FR24284' => 'Montagnac-dAuberoche',
	'FR24285' => 'Montagnac-la-Crempse',
	'FR24286' => 'Montagrier',
	'FR24287' => 'Montaut',
	'FR24288' => 'Montazeau',
	'FR24289' => 'Montcaret',
	'FR24290' => 'Montferrand-du-Périgord',
	'FR24291' => 'Montignac',
	'FR24292' => 'Montpeyroux',
	'FR24293' => 'Monplaisant',
	'FR24294' => 'Montpon-Ménestérol',
	'FR24295' => 'Montrem',
	'FR24296' => 'Mouleydier',
	'FR24297' => 'Moulin-Neuf',
	'FR24299' => 'Mussidan',
	'FR24300' => 'Nabirat',
	'FR24301' => 'Nadaillac',
	'FR24302' => 'Nailhac',
	'FR24303' => 'Nanteuil-Auriac-de-Bourzac',
	'FR24304' => 'Nantheuil',
	'FR24305' => 'Nanthiat',
	'FR24306' => 'Nastringues',
	'FR24307' => 'Naussannes',
	'FR24308' => 'Négrondes',
	'FR24309' => 'Neuvic',
	'FR24311' => 'Nontron',
	'FR24312' => 'Sanilhac',
	'FR24313' => 'Orliac',
	'FR24314' => 'Orliaguet',
	'FR24316' => 'Parcoul-Chenaud',
	'FR24317' => 'Paulin',
	'FR24318' => 'Paunat',
	'FR24319' => 'Paussac-et-Saint-Vivien',
	'FR24320' => 'Payzac',
	'FR24321' => 'Pazayac',
	'FR24322' => 'Périgueux',
	'FR24323' => 'Petit-Bersac',
	'FR24324' => 'Peyrignac',
	'FR24325' => 'Peyrillac-et-Millac',
	'FR24326' => 'Peyzac-le-Moustier',
	'FR24327' => 'Pezuls',
	'FR24328' => 'Piégut-Pluviers',
	'FR24329' => 'Le Pizou',
	'FR24330' => 'Plazac',
	'FR24331' => 'Pomport',
	'FR24334' => 'Pontours',
	'FR24335' => 'Port-Sainte-Foy-et-Ponchapt',
	'FR24336' => 'Prats-de-Carlux',
	'FR24337' => 'Prats-du-Périgord',
	'FR24338' => 'Pressignac-Vicq',
	'FR24339' => 'Preyssac-dExcideuil',
	'FR24340' => 'Prigonrieux',
	'FR24341' => 'Proissans',
	'FR24345' => 'Queyssac',
	'FR24346' => 'Quinsac',
	'FR24347' => 'Rampieux',
	'FR24348' => 'Razac-dEymet',
	'FR24349' => 'Razac-de-Saussignac',
	'FR24350' => 'Razac-sur-lIsle',
	'FR24351' => 'Ribagnac',
	'FR24352' => 'Ribérac',
	'FR24353' => 'La Rochebeaucourt-et-Argentine',
	'FR24354' => 'La Roche-Chalais',
	'FR24355' => 'La Roque-Gageac',
	'FR24356' => 'Rouffignac-Saint-Cernin-de-Reilhac',
	'FR24357' => 'Rouffignac-de-Sigoulès',
	'FR24359' => 'Sadillac',
	'FR24360' => 'Sagelat',
	'FR24361' => 'Saint-Agne',
	'FR24362' => 'Val de Louyre et Caudeau',
	'FR24364' => 'Coly-Saint-Amand',
	'FR24365' => 'Saint-Amand-de-Vergt',
	'FR24366' => 'Saint-André-dAllas',
	'FR24367' => 'Saint-André-de-Double',
	'FR24370' => 'Saint-Antoine-de-Breuilh',
	'FR24371' => 'Saint-Aquilin',
	'FR24372' => 'Saint-Astier',
	'FR24373' => 'Saint-Aubin-de-Cadelech',
	'FR24374' => 'Saint-Aubin-de-Lanquais',
	'FR24375' => 'Saint-Aubin-de-Nabirat',
	'FR24376' => 'Saint Aulaye-Puymangou',
	'FR24377' => 'Saint-Avit-de-Vialard',
	'FR24378' => 'Saint-Avit-Rivière',
	'FR24379' => 'Saint-Avit-Sénieur',
	'FR24380' => 'Saint-Barthélemy-de-Bellegarde',
	'FR24381' => 'Saint-Barthélemy-de-Bussière',
	'FR24382' => 'Saint-Capraise-de-Lalinde',
	'FR24383' => 'Saint-Capraise-dEymet',
	'FR24384' => 'Saint-Cassien',
	'FR24385' => 'Saint-Cernin-de-Labarde',
	'FR24386' => 'Saint-Cernin-de-lHerm',
	'FR24388' => 'Saint-Chamassy',
	'FR24390' => 'Saint-Crépin-dAuberoche',
	'FR24392' => 'Saint-Crépin-et-Carlucet',
	'FR24393' => 'Sainte-Croix',
	'FR24394' => 'Sainte-Croix-de-Mareuil',
	'FR24395' => 'Saint-Cybranet',
	'FR24396' => 'Saint-Cyprien',
	'FR24397' => 'Saint-Cyr-les-Champagnes',
	'FR24398' => 'Saint-Estèphe',
	'FR24399' => 'Saint-Étienne-de-Puycorbier',
	'FR24401' => 'Sainte-Eulalie-dAns',
	'FR24403' => 'Saint-Félix-de-Bourdeilles',
	'FR24404' => 'Saint-Félix-de-Reillac-et-Mortemart',
	'FR24405' => 'Saint-Félix-de-Villadeix',
	'FR24406' => 'Sainte-Foy-de-Belvès',
	'FR24407' => 'Sainte-Foy-de-Longas',
	'FR24408' => 'Saint-Front-dAlemps',
	'FR24409' => 'Saint-Front-de-Pradoux',
	'FR24410' => 'Saint-Front-la-Rivière',
	'FR24411' => 'Saint-Front-sur-Nizonne',
	'FR24412' => 'Saint-Geniès',
	'FR24413' => 'Saint-Georges-Blancaneix',
	'FR24414' => 'Saint-Georges-de-Montclard',
	'FR24415' => 'Saint-Géraud-de-Corps',
	'FR24416' => 'Saint-Germain-de-Belvès',
	'FR24417' => 'Saint-Germain-des-Prés',
	'FR24418' => 'Saint-Germain-du-Salembre',
	'FR24419' => 'Saint-Germain-et-Mons',
	'FR24420' => 'Saint-Géry',
	'FR24421' => 'Saint-Geyrac',
	'FR24422' => 'Saint-Hilaire-dEstissac',
	'FR24423' => 'Saint-Julien-Innocence-Eulalie',
	'FR24424' => 'Saint-Jean-dAtaux',
	'FR24425' => 'Saint-Jean-de-Côle',
	'FR24426' => 'Saint-Jean-dEstissac',
	'FR24428' => 'Saint-Jory-de-Chalais',
	'FR24429' => 'Saint-Jory-las-Bloux',
	'FR24432' => 'Saint-Julien-de-Lampon',
	'FR24434' => 'Saint-Just',
	'FR24436' => 'Saint-Laurent-des-Hommes',
	'FR24437' => 'Saint-Laurent-des-Vignes',
	'FR24438' => 'Saint-Laurent-la-Vallée',
	'FR24441' => 'Saint-Léon-dIssigeac',
	'FR24442' => 'Saint-Léon-sur-lIsle',
	'FR24443' => 'Saint-Léon-sur-Vézère',
	'FR24444' => 'Saint-Louis-en-lIsle',
	'FR24445' => 'Saint-Marcel-du-Périgord',
	'FR24446' => 'Saint-Marcory',
	'FR24448' => 'Saint-Martial-dAlbarède',
	'FR24449' => 'Saint-Martial-dArtenset',
	'FR24450' => 'Saint-Martial-de-Nabirat',
	'FR24451' => 'Saint-Martial-de-Valette',
	'FR24452' => 'Saint-Martial-Viveyrol',
	'FR24453' => 'Saint-Martin-de-Fressengeas',
	'FR24454' => 'Saint-Martin-de-Gurson',
	'FR24455' => 'Saint-Martin-de-Ribérac',
	'FR24456' => 'Saint-Martin-des-Combes',
	'FR24457' => 'Saint-Martin-lAstier',
	'FR24458' => 'Saint-Martin-le-Pin',
	'FR24459' => 'Saint-Maime-de-Péreyrol',
	'FR24460' => 'Saint-Méard-de-Drône',
	'FR24461' => 'Saint-Méard-de-Gurçon',
	'FR24462' => 'Saint-Médard-de-Mussidan',
	'FR24463' => 'Saint-Médard-dExcideuil',
	'FR24464' => 'Saint-Mesmin',
	'FR24465' => 'Saint-Michel-de-Double',
	'FR24466' => 'Saint-Michel-de-Montaigne',
	'FR24468' => 'Saint-Michel-de-Villadeix',
	'FR24470' => 'Sainte-Mondane',
	'FR24471' => 'Sainte-Nathalène',
	'FR24472' => 'Saint-Nexans',
	'FR24473' => 'Sainte-Orse',
	'FR24474' => 'Saint-Pancrace',
	'FR24476' => 'Saint-Pantaly-dExcideuil',
	'FR24477' => 'Saint-Pardoux-de-Drône',
	'FR24478' => 'Saint-Pardoux-et-Vielvic',
	'FR24479' => 'Saint-Pardoux-la-Rivière',
	'FR24480' => 'Saint-Paul-de-Serre',
	'FR24481' => 'Saint-Paul-la-Roche',
	'FR24482' => 'Saint-Paul-Lizonne',
	'FR24483' => 'Saint-Perdoux',
	'FR24484' => 'Saint-Pierre-de-Chignac',
	'FR24485' => 'Saint-Pierre-de-Côle',
	'FR24486' => 'Saint-Pierre-de-Frugie',
	'FR24487' => 'Saint-Pierre-dEyraud',
	'FR24488' => 'Saint-Pompont',
	'FR24489' => 'Saint-Priest-les-Fougères',
	'FR24490' => 'Saint Privat en Périgord',
	'FR24491' => 'Saint-Rabier',
	'FR24492' => 'Sainte-Radegonde',
	'FR24493' => 'Saint-Raphaël',
	'FR24494' => 'Saint-Rémy',
	'FR24495' => 'Saint-Romain-de-Monpazier',
	'FR24496' => 'Saint-Romain-et-Saint-Clément',
	'FR24498' => 'Saint-Saud-Lacoussière',
	'FR24499' => 'Saint-Sauveur',
	'FR24500' => 'Saint-Sauveur-Lalande',
	'FR24501' => 'Saint-Seurin-de-Prats',
	'FR24502' => 'Saint-Séverin-dEstissac',
	'FR24504' => 'Saint-Sulpice-de-Roumagnac',
	'FR24505' => 'Saint-Sulpice-dExcideuil',
	'FR24507' => 'Sainte-Trie',
	'FR24508' => 'Saint-Victor',
	'FR24509' => 'Saint-Vincent-de-Connezac',
	'FR24510' => 'Saint-Vincent-de-Cosse',
	'FR24511' => 'Saint-Vincent-Jalmoutiers',
	'FR24512' => 'Saint-Vincent-le-Paluel',
	'FR24513' => 'Saint-Vincent-sur-lIsle',
	'FR24514' => 'Saint-Vivien',
	'FR24515' => 'Salagnac',
	'FR24516' => 'Salignac-Eyvigues',
	'FR24517' => 'Salles-de-Belvès',
	'FR24518' => 'Salon',
	'FR24519' => 'Sarlande',
	'FR24520' => 'Sarlat-la-Canéda',
	'FR24521' => 'Sarliac-sur-lIsle',
	'FR24522' => 'Sarrazac',
	'FR24523' => 'Saussignac',
	'FR24524' => 'Savignac-de-Miremont',
	'FR24525' => 'Savignac-de-Nontron',
	'FR24526' => 'Savignac-Lédrier',
	'FR24527' => 'Savignac-les-Églises',
	'FR24528' => 'Sceau-Saint-Angel',
	'FR24529' => 'Segonzac',
	'FR24531' => 'Sergeac',
	'FR24532' => 'Serres-et-Montguyard',
	'FR24533' => 'Servanches',
	'FR24534' => 'Sigoulès-et-Flaugeac',
	'FR24535' => 'Simeyrols',
	'FR24536' => 'Singleyrac',
	'FR24537' => 'Siorac-de-Ribérac',
	'FR24538' => 'Siorac-en-Périgord',
	'FR24540' => 'Sorges et Ligueux en Périgord',
	'FR24541' => 'Soudat',
	'FR24542' => 'Soulaures',
	'FR24543' => 'Sourzac',
	'FR24544' => 'Tamniès',
	'FR24545' => 'Teillots',
	'FR24546' => 'Temple-Laguyon',
	'FR24547' => 'Terrasson-Lavilledieu',
	'FR24548' => 'Teyjat',
	'FR24549' => 'Thénac',
	'FR24550' => 'Thenon',
	'FR24551' => 'Thiviers',
	'FR24552' => 'Thonac',
	'FR24553' => 'Tocane-Saint-Apre',
	'FR24554' => 'La Tour-Blanche-Cercles',
	'FR24555' => 'Tourtoirac',
	'FR24557' => 'Trélissac',
	'FR24558' => 'Trémolat',
	'FR24559' => 'Tursac',
	'FR24560' => 'Urval',
	'FR24562' => 'Vallereuil',
	'FR24563' => 'Valojoulx',
	'FR24564' => 'Vanxains',
	'FR24565' => 'Varaignes',
	'FR24566' => 'Varennes',
	'FR24567' => 'Vaunac',
	'FR24568' => 'Vélines',
	'FR24569' => 'Vendoire',
	'FR24570' => 'Verdon',
	'FR24571' => 'Vergt',
	'FR24572' => 'Vergt-de-Biron',
	'FR24573' => 'Verteillac',
	'FR24574' => 'Veyrignac',
	'FR24575' => 'Veyrines-de-Domme',
	'FR24576' => 'Veyrines-de-Vergt',
	'FR24577' => 'Vézac',
	'FR24580' => 'Villac',
	'FR24581' => 'Villamblard',
	'FR24582' => 'Villars',
	'FR24584' => 'Villefranche-de-Lonchat',
	'FR24585' => 'Villefranche-du-Périgord',
	'FR24586' => 'Villetoureix',
	'FR24587' => 'Vitrac',
	'FR25001' => 'Abbans-Dessous',
	'FR25002' => 'Abbans-Dessus',
	'FR25003' => 'Abbenans',
	'FR25004' => 'Abbévillers',
	'FR25005' => 'Accolans',
	'FR25006' => 'Adam-lès-Passavant',
	'FR25007' => 'Adam-lès-Vercel',
	'FR25008' => 'Aibre',
	'FR25009' => 'Aïssey',
	'FR25011' => 'Allenjoie',
	'FR25012' => 'Les Alliés',
	'FR25013' => 'Allondans',
	'FR25014' => 'Amagney',
	'FR25015' => 'Amancey',
	'FR25016' => 'Amathay-Vésigneux',
	'FR25017' => 'Amondans',
	'FR25018' => 'Anteuil',
	'FR25019' => 'Appenans',
	'FR25020' => 'Arbouans',
	'FR25021' => 'Arc-et-Senans',
	'FR25022' => 'Arcey',
	'FR25024' => 'Arçon',
	'FR25025' => 'Arc-sous-Cicon',
	'FR25026' => 'Arc-sous-Montenot',
	'FR25029' => 'Aubonne',
	'FR25030' => 'Audeux',
	'FR25031' => 'Audincourt',
	'FR25032' => 'Autechaux',
	'FR25033' => 'Autechaux-Roide',
	'FR25035' => 'Les Auxons',
	'FR25036' => 'Avanne-Aveney',
	'FR25038' => 'Avilley',
	'FR25039' => 'Avoudrey',
	'FR25040' => 'Badevel',
	'FR25041' => 'Bannans',
	'FR25042' => 'Le Barboux',
	'FR25043' => 'Bart',
	'FR25044' => 'Bartherans',
	'FR25045' => 'Battenans-les-Mines',
	'FR25046' => 'Battenans-Varin',
	'FR25047' => 'Baume-les-Dames',
	'FR25048' => 'Bavans',
	'FR25049' => 'Belfays',
	'FR25050' => 'Le Bélieu',
	'FR25051' => 'Belleherbe',
	'FR25052' => 'Belmont',
	'FR25053' => 'Belvoir',
	'FR25054' => 'Berche',
	'FR25055' => 'Berthelange',
	'FR25056' => 'Besançon',
	'FR25057' => 'Bethoncourt',
	'FR25058' => 'Beure',
	'FR25059' => 'Beutal',
	'FR25060' => 'Bians-les-Usiers',
	'FR25061' => 'Bief',
	'FR25062' => 'Le Bizot',
	'FR25063' => 'Blamont',
	'FR25065' => 'Blarians',
	'FR25066' => 'Blussangeaux',
	'FR25067' => 'Blussans',
	'FR25070' => 'Bolandoz',
	'FR25071' => 'Bondeval',
	'FR25072' => 'Bonnal',
	'FR25073' => 'Bonnay',
	'FR25074' => 'Bonnétage',
	'FR25075' => 'Bonnevaux',
	'FR25077' => 'La Bosse',
	'FR25078' => 'Bouclans',
	'FR25079' => 'Boujailles',
	'FR25082' => 'Bourguignon',
	'FR25083' => 'Bournois',
	'FR25084' => 'Boussières',
	'FR25085' => 'Bouverans',
	'FR25086' => 'Braillans',
	'FR25087' => 'Branne',
	'FR25088' => 'Breconchaux',
	'FR25089' => 'Bremondans',
	'FR25090' => 'Brères',
	'FR25091' => 'Les Bréseux',
	'FR25092' => 'La Bretenière',
	'FR25093' => 'Bretigney',
	'FR25094' => 'Bretigney-Notre-Dame',
	'FR25095' => 'Bretonvillers',
	'FR25096' => 'Brey-et-Maison-du-Bois',
	'FR25097' => 'Brognard',
	'FR25098' => 'Buffard',
	'FR25099' => 'Bugny',
	'FR25100' => 'Bulle',
	'FR25101' => 'Burgille',
	'FR25102' => 'Burnevillers',
	'FR25103' => 'Busy',
	'FR25104' => 'By',
	'FR25105' => 'Byans-sur-Doubs',
	'FR25106' => 'Cademène',
	'FR25107' => 'Cendrey',
	'FR25108' => 'Cernay-lÉglise',
	'FR25109' => 'Cessey',
	'FR25110' => 'Chaffois',
	'FR25111' => 'Chalèze',
	'FR25112' => 'Chalezeule',
	'FR25113' => 'Chamesey',
	'FR25114' => 'Chamesol',
	'FR25115' => 'Champagney',
	'FR25116' => 'Champlive',
	'FR25117' => 'Champoux',
	'FR25119' => 'Champvans-les-Moulins',
	'FR25120' => 'Chantrans',
	'FR25121' => 'Chapelle-des-Bois',
	'FR25122' => 'Chapelle-dHuin',
	'FR25124' => 'Charmauvillers',
	'FR25125' => 'Charmoille',
	'FR25126' => 'Charnay',
	'FR25127' => 'Charquemont',
	'FR25129' => 'Chassagne-Saint-Denis',
	'FR25130' => 'Châteauvieux-les-Fossés',
	'FR25131' => 'Châtelblanc',
	'FR25132' => 'Châtillon-Guyotte',
	'FR25133' => 'Châtillon-le-Duc',
	'FR25134' => 'Châtillon-sur-Lison',
	'FR25136' => 'Chaucenne',
	'FR25138' => 'Les Terres-de-Chaux',
	'FR25139' => 'La Chaux',
	'FR25141' => 'Chaux-lès-Passavant',
	'FR25142' => 'Chaux-Neuve',
	'FR25143' => 'Chay',
	'FR25145' => 'Chazot',
	'FR25147' => 'Chemaudin et Vaux',
	'FR25148' => 'La Chenalotte',
	'FR25149' => 'Chenecey-Buillon',
	'FR25150' => 'Chevigney-sur-lOgnon',
	'FR25151' => 'Chevigney-lès-Vercel',
	'FR25152' => 'La Chevillotte',
	'FR25153' => 'Chevroz',
	'FR25154' => 'Chouzelot',
	'FR25155' => 'Cléron',
	'FR25156' => 'Pays-de-Clerval',
	'FR25157' => 'La Cluse-et-Mijoux',
	'FR25159' => 'Colombier-Fontaine',
	'FR25160' => 'Les Combes',
	'FR25161' => 'Consolation-Maisonnettes',
	'FR25162' => 'Corcelles-Ferrières',
	'FR25163' => 'Corcelle-Mieslot',
	'FR25164' => 'Corcondray',
	'FR25166' => 'Côtebrune',
	'FR25170' => 'Courcelles-lès-Montbéliard',
	'FR25171' => 'Courcelles',
	'FR25172' => 'Courchapon',
	'FR25173' => 'Cour-Saint-Maurice',
	'FR25174' => 'Courtefontaine',
	'FR25175' => 'Courtetain-et-Salans',
	'FR25176' => 'Courvières',
	'FR25177' => 'Crosey-le-Grand',
	'FR25178' => 'Crosey-le-Petit',
	'FR25179' => 'Le Crouzet',
	'FR25180' => 'Crouzet-Migette',
	'FR25181' => 'Cubrial',
	'FR25182' => 'Cubry',
	'FR25183' => 'Cusance',
	'FR25184' => 'Cuse-et-Adrisans',
	'FR25185' => 'Cussey-sur-Lison',
	'FR25186' => 'Cussey-sur-lOgnon',
	'FR25187' => 'Dambelin',
	'FR25188' => 'Dambenois',
	'FR25189' => 'Dammartin-les-Templiers',
	'FR25190' => 'Dampierre-les-Bois',
	'FR25191' => 'Dampierre-sur-le-Doubs',
	'FR25192' => 'Dampjoux',
	'FR25193' => 'Damprichard',
	'FR25194' => 'Dannemarie',
	'FR25195' => 'Dannemarie-sur-Crète',
	'FR25196' => 'Dasle',
	'FR25197' => 'Deluz',
	'FR25198' => 'Désandans',
	'FR25199' => 'Déservillers',
	'FR25200' => 'Devecey',
	'FR25201' => 'Dommartin',
	'FR25202' => 'Dompierre-les-Tilleuls',
	'FR25203' => 'Domprel',
	'FR25204' => 'Doubs',
	'FR25207' => 'Dung',
	'FR25208' => 'Durnes',
	'FR25209' => 'Échay',
	'FR25210' => 'Échenans',
	'FR25211' => 'Échevannes',
	'FR25212' => 'École-Valentin',
	'FR25213' => 'Les Écorces',
	'FR25214' => 'Écot',
	'FR25215' => 'LÉcouvotte',
	'FR25216' => 'Écurcey',
	'FR25217' => 'Émagny',
	'FR25218' => 'Épenouse',
	'FR25219' => 'Épenoy',
	'FR25220' => 'Épeugney',
	'FR25221' => 'Esnans',
	'FR25222' => 'Étalans',
	'FR25223' => 'Éternoz',
	'FR25224' => 'Étouvans',
	'FR25225' => 'Étrabonne',
	'FR25226' => 'Étrappe',
	'FR25227' => 'Étray',
	'FR25228' => 'Étupes',
	'FR25229' => 'Évillers',
	'FR25230' => 'Exincourt',
	'FR25231' => 'Eysson',
	'FR25232' => 'Faimbe',
	'FR25233' => 'Fallerans',
	'FR25234' => 'Ferrières-le-Lac',
	'FR25235' => 'Ferrières-les-Bois',
	'FR25236' => 'Fertans',
	'FR25237' => 'Fesches-le-Châtel',
	'FR25238' => 'Fessevillers',
	'FR25239' => 'Feule',
	'FR25240' => 'Les Fins',
	'FR25241' => 'Flagey',
	'FR25242' => 'Flagey-Rigney',
	'FR25243' => 'Flangebouche',
	'FR25244' => 'Fleurey',
	'FR25245' => 'Fontain',
	'FR25246' => 'Fontaine-lès-Clerval',
	'FR25247' => 'Fontenelle-Montby',
	'FR25248' => 'Les Fontenelles',
	'FR25249' => 'Fontenotte',
	'FR25251' => 'Fourbanne',
	'FR25252' => 'Fourcatier-et-Maison-Neuve',
	'FR25253' => 'Fourg',
	'FR25254' => 'Les Fourgs',
	'FR25255' => 'Fournet-Blancheroche',
	'FR25256' => 'Frambouhans',
	'FR25257' => 'Franey',
	'FR25258' => 'Franois',
	'FR25259' => 'Frasne',
	'FR25261' => 'Froidevaux',
	'FR25262' => 'Fuans',
	'FR25263' => 'Gellin',
	'FR25264' => 'Gémonval',
	'FR25265' => 'Geneuille',
	'FR25266' => 'Geney',
	'FR25267' => 'Gennes',
	'FR25268' => 'Germéfontaine',
	'FR25269' => 'Germondans',
	'FR25270' => 'Gevresin',
	'FR25271' => 'Gilley',
	'FR25273' => 'Glamondans',
	'FR25274' => 'Glay',
	'FR25275' => 'Glère',
	'FR25276' => 'Gondenans-Montby',
	'FR25277' => 'Gondenans-les-Moulins',
	'FR25278' => 'Gonsans',
	'FR25279' => 'Gouhelans',
	'FR25280' => 'Goumois',
	'FR25281' => 'Goux-lès-Dambelin',
	'FR25282' => 'Goux-les-Usiers',
	'FR25283' => 'Goux-sous-Landet',
	'FR25284' => 'Grand-Charmont',
	'FR25285' => 'GrandCombe-Châteleu',
	'FR25286' => 'GrandCombe-des-Bois',
	'FR25287' => 'Grandfontaine',
	'FR25288' => 'Fournets-Luisans',
	'FR25289' => 'Grandfontaine-sur-Creuse',
	'FR25290' => 'La Grange',
	'FR25293' => 'Granges-Narboz',
	'FR25295' => 'Les Grangettes',
	'FR25296' => 'Les Gras',
	'FR25297' => 'Le Gratteris',
	'FR25298' => 'Grosbois',
	'FR25299' => 'Guillon-les-Bains',
	'FR25300' => 'Guyans-Durnes',
	'FR25301' => 'Guyans-Vennes',
	'FR25303' => 'Hauterive-la-Fresse',
	'FR25304' => 'Hérimoncourt',
	'FR25305' => 'LHôpital-du-Grosbois',
	'FR25306' => 'LHôpital-Saint-Lieffroy',
	'FR25307' => 'Les Hôpitaux-Neufs',
	'FR25308' => 'Les Hôpitaux-Vieux',
	'FR25309' => 'Houtaud',
	'FR25310' => 'Huanne-Montmartin',
	'FR25311' => 'Hyémondans',
	'FR25312' => 'Hyèvre-Magny',
	'FR25313' => 'Hyèvre-Paroisse',
	'FR25314' => 'Indevillers',
	'FR25315' => 'LIsle-sur-le-Doubs',
	'FR25316' => 'Issans',
	'FR25317' => 'Jallerange',
	'FR25318' => 'Jougne',
	'FR25320' => 'Labergement-Sainte-Marie',
	'FR25321' => 'Villers-le-Lac',
	'FR25322' => 'Laire',
	'FR25323' => 'Laissey',
	'FR25324' => 'Lanans',
	'FR25325' => 'Landresse',
	'FR25326' => 'Lantenne-Vertière',
	'FR25327' => 'Lanthenans',
	'FR25328' => 'Larnod',
	'FR25329' => 'Laval-le-Prieuré',
	'FR25330' => 'Lavans-Quingey',
	'FR25331' => 'Lavans-Vuillafans',
	'FR25332' => 'Lavernay',
	'FR25333' => 'Laviron',
	'FR25334' => 'Levier',
	'FR25335' => 'Liebvillers',
	'FR25336' => 'Liesle',
	'FR25338' => 'Lizine',
	'FR25339' => 'Lods',
	'FR25340' => 'Lombard',
	'FR25341' => 'Lomont-sur-Crête',
	'FR25342' => 'Longechaux',
	'FR25343' => 'Longemaison',
	'FR25344' => 'Longevelle-lès-Russey',
	'FR25345' => 'Longevelle-sur-Doubs',
	'FR25346' => 'Longeville',
	'FR25347' => 'La Longeville',
	'FR25348' => 'Longevilles-Mont-dOr',
	'FR25349' => 'Loray',
	'FR25350' => 'Lougres',
	'FR25351' => 'Le Luhier',
	'FR25354' => 'Luxiol',
	'FR25355' => 'Magny-Châtelard',
	'FR25356' => 'Maîche',
	'FR25357' => 'Maisons-du-Bois-Lièvremont',
	'FR25359' => 'Malans',
	'FR25360' => 'Malbrans',
	'FR25361' => 'Malbuisson',
	'FR25362' => 'Malpas',
	'FR25364' => 'Mamirolle',
	'FR25365' => 'Mancenans',
	'FR25366' => 'Mancenans-Lizerne',
	'FR25367' => 'Mandeure',
	'FR25368' => 'Marchaux-Chaudefontaine',
	'FR25369' => 'Marvelise',
	'FR25370' => 'Mathay',
	'FR25371' => 'Mazerolles-le-Salin',
	'FR25372' => 'Médière',
	'FR25373' => 'Le Mémont',
	'FR25374' => 'Mercey-le-Grand',
	'FR25375' => 'Mérey-sous-Montrond',
	'FR25376' => 'Mérey-Vieilley',
	'FR25377' => 'Mésandans',
	'FR25378' => 'Meslières',
	'FR25379' => 'Mesmay',
	'FR25380' => 'Métabief',
	'FR25381' => 'Miserey-Salines',
	'FR25382' => 'Moncey',
	'FR25383' => 'Moncley',
	'FR25384' => 'Mondon',
	'FR25385' => 'Montagney-Servigney',
	'FR25386' => 'Montancy',
	'FR25387' => 'Montandon',
	'FR25388' => 'Montbéliard',
	'FR25389' => 'Montbéliardot',
	'FR25390' => 'Montbenoît',
	'FR25391' => 'Mont-de-Laval',
	'FR25392' => 'Mont-de-Vougney',
	'FR25393' => 'Montécheroux',
	'FR25394' => 'Montenois',
	'FR25395' => 'Montfaucon',
	'FR25397' => 'Montferrand-le-Château',
	'FR25398' => 'Montflovin',
	'FR25400' => 'Montgesoye',
	'FR25401' => 'Montivernage',
	'FR25402' => 'Montjoie-le-Château',
	'FR25403' => 'Montlebon',
	'FR25404' => 'Montmahoux',
	'FR25405' => 'Montperreux',
	'FR25406' => 'Montrond-le-Château',
	'FR25408' => 'Montussaint',
	'FR25410' => 'Morre',
	'FR25411' => 'Morteau',
	'FR25413' => 'Mouthe',
	'FR25414' => 'Le Moutherot',
	'FR25415' => 'Mouthier-Haute-Pierre',
	'FR25416' => 'Myon',
	'FR25417' => 'Naisey-les-Granges',
	'FR25418' => 'Nancray',
	'FR25419' => 'Nans',
	'FR25420' => 'Nans-sous-Sainte-Anne',
	'FR25421' => 'Narbief',
	'FR25422' => 'Neuchâtel-Urtière',
	'FR25424' => 'Les Premiers Sapins',
	'FR25425' => 'Noël-Cerneux',
	'FR25426' => 'Noirefontaine',
	'FR25427' => 'Noironte',
	'FR25428' => 'Nommay',
	'FR25429' => 'Novillars',
	'FR25430' => 'Ollans',
	'FR25431' => 'Onans',
	'FR25432' => 'Orchamps-Vennes',
	'FR25433' => 'Orgeans-Blanchefontaine',
	'FR25434' => 'Ornans',
	'FR25435' => 'Orsans',
	'FR25436' => 'Orve',
	'FR25437' => 'Osse',
	'FR25438' => 'Osselle-Routelle',
	'FR25439' => 'Ougney-Douvot',
	'FR25440' => 'Ouhans',
	'FR25441' => 'Ouvans',
	'FR25442' => 'Oye-et-Pallet',
	'FR25443' => 'Palantine',
	'FR25444' => 'Palise',
	'FR25445' => 'Paroy',
	'FR25446' => 'Passavant',
	'FR25447' => 'Passonfontaine',
	'FR25448' => 'Pelousey',
	'FR25449' => 'Péseux',
	'FR25450' => 'Pessans',
	'FR25451' => 'Petite-Chaux',
	'FR25452' => 'Pierrefontaine-lès-Blamont',
	'FR25453' => 'Pierrefontaine-les-Varans',
	'FR25454' => 'Pirey',
	'FR25455' => 'Placey',
	'FR25456' => 'Plaimbois-du-Miroir',
	'FR25457' => 'Plaimbois-Vennes',
	'FR25458' => 'Les Plains-et-Grands-Essarts',
	'FR25459' => 'La Planée',
	'FR25460' => 'Le Val',
	'FR25461' => 'Pompierre-sur-Doubs',
	'FR25462' => 'Pontarlier',
	'FR25463' => 'Pont-de-Roide-Vermondans',
	'FR25464' => 'Les Pontets',
	'FR25465' => 'Pont-les-Moulins',
	'FR25466' => 'Pouilley-Français',
	'FR25467' => 'Pouilley-les-Vignes',
	'FR25468' => 'Pouligney-Lusans',
	'FR25469' => 'Présentevillers',
	'FR25470' => 'La Prétière',
	'FR25471' => 'Provenchère',
	'FR25472' => 'Puessans',
	'FR25473' => 'Pugey',
	'FR25474' => 'Le Puy',
	'FR25475' => 'Quingey',
	'FR25476' => 'Rahon',
	'FR25477' => 'Rancenay',
	'FR25478' => 'Randevillers',
	'FR25479' => 'Rang',
	'FR25481' => 'Raynans',
	'FR25482' => 'Recologne',
	'FR25483' => 'Reculfoz',
	'FR25485' => 'Rémondans-Vaivre',
	'FR25486' => 'Remoray-Boujeons',
	'FR25487' => 'Renédale',
	'FR25488' => 'Rennes-sur-Loue',
	'FR25489' => 'Reugney',
	'FR25490' => 'Rigney',
	'FR25491' => 'Rignosot',
	'FR25492' => 'Rillans',
	'FR25493' => 'La Rivière-Drugeon',
	'FR25494' => 'Rochejean',
	'FR25495' => 'Roche-lez-Beaupré',
	'FR25496' => 'Roche-lès-Clerval',
	'FR25497' => 'Roches-lès-Blamont',
	'FR25498' => 'Rognon',
	'FR25499' => 'Romain',
	'FR25500' => 'Ronchaux',
	'FR25501' => 'Rondefontaine',
	'FR25502' => 'Roset-Fluans',
	'FR25503' => 'Rosières-sur-Barbèche',
	'FR25504' => 'Rosureux',
	'FR25505' => 'Rougemont',
	'FR25506' => 'Rougemontot',
	'FR25507' => 'Rouhe',
	'FR25508' => 'Roulans',
	'FR25510' => 'Ruffey-le-Château',
	'FR25511' => 'Rurey',
	'FR25512' => 'Le Russey',
	'FR25513' => 'Sainte-Anne',
	'FR25514' => 'Saint-Antoine',
	'FR25515' => 'Sainte-Colombe',
	'FR25516' => 'Saint-Georges-Armont',
	'FR25517' => 'Saint-Gorgon-Main',
	'FR25518' => 'Saint-Hilaire',
	'FR25519' => 'Saint-Hippolyte',
	'FR25520' => 'Saint-Juan',
	'FR25521' => 'Saint-Julien-lès-Montbéliard',
	'FR25522' => 'Saint-Julien-lès-Russey',
	'FR25523' => 'Sainte-Marie',
	'FR25524' => 'Saint-Maurice-Colombier',
	'FR25525' => 'Saint-Point-Lac',
	'FR25526' => 'Sainte-Suzanne',
	'FR25527' => 'Saint-Vit',
	'FR25528' => 'Samson',
	'FR25529' => 'Sancey',
	'FR25532' => 'Saône',
	'FR25533' => 'Saraz',
	'FR25534' => 'Sarrageois',
	'FR25535' => 'Saules',
	'FR25536' => 'Sauvagney',
	'FR25537' => 'Scey-Maisières',
	'FR25538' => 'Séchin',
	'FR25539' => 'Seloncourt',
	'FR25540' => 'Semondans',
	'FR25541' => 'Septfontaines',
	'FR25542' => 'Serre-les-Sapins',
	'FR25544' => 'Servin',
	'FR25545' => 'Silley-Amancey',
	'FR25546' => 'Silley-Bléfond',
	'FR25547' => 'Sochaux',
	'FR25548' => 'Solemont',
	'FR25549' => 'Sombacour',
	'FR25550' => 'La Sommette',
	'FR25551' => 'Soulce-Cernay',
	'FR25552' => 'Sourans',
	'FR25553' => 'Soye',
	'FR25554' => 'Surmont',
	'FR25555' => 'Taillecourt',
	'FR25556' => 'Tallans',
	'FR25557' => 'Tallenay',
	'FR25558' => 'Tarcenay-Foucherans',
	'FR25559' => 'Thiébouhans',
	'FR25560' => 'Thise',
	'FR25561' => 'Thoraise',
	'FR25562' => 'Thulay',
	'FR25563' => 'Thurey-le-Mont',
	'FR25564' => 'Torpes',
	'FR25565' => 'Touillon-et-Loutelet',
	'FR25566' => 'La Tour-de-Sçay',
	'FR25567' => 'Tournans',
	'FR25569' => 'Trépot',
	'FR25570' => 'Tressandans',
	'FR25571' => 'Trévillers',
	'FR25572' => 'Trouvans',
	'FR25573' => 'Urtière',
	'FR25574' => 'Uzelle',
	'FR25575' => 'Vaire',
	'FR25578' => 'Valdahon',
	'FR25579' => 'Val-de-Roulans',
	'FR25580' => 'Valentigney',
	'FR25582' => 'Valleroy',
	'FR25583' => 'Valonne',
	'FR25584' => 'Valoreille',
	'FR25586' => 'Vandoncourt',
	'FR25588' => 'Vaucluse',
	'FR25589' => 'Vauclusotte',
	'FR25590' => 'Vaudrivillers',
	'FR25591' => 'Vaufrey',
	'FR25592' => 'Vaux-et-Chantegrue',
	'FR25594' => 'Velesmes-Essarts',
	'FR25595' => 'Vellerot-lès-Belvoir',
	'FR25596' => 'Vellerot-lès-Vercel',
	'FR25597' => 'Vellevans',
	'FR25598' => 'Venise',
	'FR25599' => 'Vennans',
	'FR25600' => 'Vennes',
	'FR25601' => 'Vercel-Villedieu-le-Camp',
	'FR25602' => 'Vergranne',
	'FR25604' => 'Verne',
	'FR25605' => 'Vernierfontaine',
	'FR25607' => 'Vernois-lès-Belvoir',
	'FR25608' => 'Le Vernoy',
	'FR25609' => 'Verrières-de-Joux',
	'FR25611' => 'La Vèze',
	'FR25612' => 'Vieilley',
	'FR25613' => 'Viéthorey',
	'FR25614' => 'Vieux-Charmont',
	'FR25615' => 'Villars-lès-Blamont',
	'FR25616' => 'Villars-Saint-Georges',
	'FR25617' => 'Villars-sous-Dampjoux',
	'FR25618' => 'Villars-sous-Écot',
	'FR25619' => 'Les Villedieu',
	'FR25620' => 'Ville-du-Pont',
	'FR25621' => 'Villeneuve-dAmont',
	'FR25622' => 'Villers-Buzon',
	'FR25623' => 'Villers-Chief',
	'FR25624' => 'Villers-Grélot',
	'FR25625' => 'Villers-la-Combe',
	'FR25626' => 'Villers-Saint-Martin',
	'FR25627' => 'Villers-sous-Chalamont',
	'FR25628' => 'Villers-sous-Montrond',
	'FR25629' => 'Voillans',
	'FR25630' => 'Voires',
	'FR25631' => 'Vorges-les-Pins',
	'FR25632' => 'Voujeaucourt',
	'FR25633' => 'Vuillafans',
	'FR25634' => 'Vuillecin',
	'FR25635' => 'Vyt-lès-Belvoir',
	'FR26001' => 'Solaure en Diois',
	'FR26002' => 'Albon',
	'FR26003' => 'Aleyrac',
	'FR26004' => 'Alixan',
	'FR26005' => 'Allan',
	'FR26006' => 'Allex',
	'FR26007' => 'Ambonil',
	'FR26008' => 'Ancône',
	'FR26009' => 'Andancette',
	'FR26010' => 'Anneyron',
	'FR26011' => 'Aouste-sur-Sye',
	'FR26012' => 'Arnayon',
	'FR26013' => 'Arpavon',
	'FR26014' => 'Arthémonay',
	'FR26015' => 'Aubenasson',
	'FR26016' => 'Aubres',
	'FR26017' => 'Aucelon',
	'FR26018' => 'Aulan',
	'FR26019' => 'Aurel',
	'FR26020' => 'La Répara-Auriples',
	'FR26021' => 'Autichamp',
	'FR26022' => 'Ballons',
	'FR26023' => 'Barbières',
	'FR26024' => 'Barcelonne',
	'FR26025' => 'Barnave',
	'FR26026' => 'Barret-de-Lioure',
	'FR26027' => 'Barsac',
	'FR26028' => 'Bathernay',
	'FR26030' => 'La Bâtie-des-Fonds',
	'FR26031' => 'La Bâtie-Rolland',
	'FR26032' => 'La Baume-Cornillane',
	'FR26033' => 'La Baume-de-Transit',
	'FR26034' => 'La Baume-dHostun',
	'FR26035' => 'Beaufort-sur-Gervanne',
	'FR26036' => 'Beaumont-en-Diois',
	'FR26037' => 'Beaumont-lès-Valence',
	'FR26038' => 'Beaumont-Monteux',
	'FR26039' => 'Beauregard-Baret',
	'FR26040' => 'Beaurières',
	'FR26041' => 'Beausemblant',
	'FR26042' => 'Beauvallon',
	'FR26043' => 'Beauvoisin',
	'FR26045' => 'La Bégude-de-Mazenc',
	'FR26046' => 'Bellecombe-Tarendol',
	'FR26047' => 'Bellegarde-en-Diois',
	'FR26048' => 'Bénivay-Ollon',
	'FR26049' => 'Bésayes',
	'FR26050' => 'Bésignan',
	'FR26051' => 'Bézaudun-sur-Bîne',
	'FR26052' => 'Bonlieu-sur-Roubion',
	'FR26054' => 'Bouchet',
	'FR26055' => 'Boulc',
	'FR26056' => 'Bourdeaux',
	'FR26057' => 'Bourg-de-Péage',
	'FR26058' => 'Bourg-lès-Valence',
	'FR26059' => 'Bouvante',
	'FR26060' => 'Bouvières',
	'FR26061' => 'Bren',
	'FR26062' => 'Brette',
	'FR26063' => 'Buis-les-Baronnies',
	'FR26064' => 'Chabeuil',
	'FR26065' => 'Chabrillan',
	'FR26066' => 'Le Chaffal',
	'FR26067' => 'Chalancon',
	'FR26068' => 'Le Chalon',
	'FR26069' => 'Chamaloc',
	'FR26070' => 'Chamaret',
	'FR26071' => 'Chanos-Curson',
	'FR26072' => 'Chantemerle-les-Blés',
	'FR26073' => 'Chantemerle-lès-Grignan',
	'FR26074' => 'La Chapelle-en-Vercors',
	'FR26075' => 'La Charce',
	'FR26076' => 'Charens',
	'FR26077' => 'Charmes-sur-lHerbasse',
	'FR26078' => 'Charols',
	'FR26079' => 'Charpey',
	'FR26080' => 'Chastel-Arnaud',
	'FR26081' => 'Châteaudouble',
	'FR26082' => 'Châteauneuf-de-Bordette',
	'FR26083' => 'Châteauneuf-de-Galaure',
	'FR26084' => 'Châteauneuf-sur-Isère',
	'FR26085' => 'Châteauneuf-du-Rhône',
	'FR26086' => 'Châtillon-en-Diois',
	'FR26087' => 'Châtillon-Saint-Jean',
	'FR26088' => 'Chatuzange-le-Goubet',
	'FR26089' => 'Chaudebonne',
	'FR26090' => 'La Chaudière',
	'FR26091' => 'Chauvac-Laux-Montaux',
	'FR26092' => 'Chavannes',
	'FR26093' => 'Clansayes',
	'FR26094' => 'Claveyson',
	'FR26095' => 'Cléon-dAndran',
	'FR26096' => 'Clérieux',
	'FR26097' => 'Cliousclat',
	'FR26098' => 'Cobonne',
	'FR26099' => 'Colonzelle',
	'FR26100' => 'Combovin',
	'FR26101' => 'Comps',
	'FR26102' => 'Condillac',
	'FR26103' => 'Condorcet',
	'FR26104' => 'Cornillac',
	'FR26105' => 'Cornillon-sur-lOule',
	'FR26106' => 'La Coucourde',
	'FR26107' => 'Crépol',
	'FR26108' => 'Crest',
	'FR26110' => 'Crozes-Hermitage',
	'FR26111' => 'Crupies',
	'FR26112' => 'Curnier',
	'FR26113' => 'Die',
	'FR26114' => 'Dieulefit',
	'FR26115' => 'Divajeu',
	'FR26116' => 'Donzère',
	'FR26117' => 'Échevis',
	'FR26118' => 'Épinouze',
	'FR26119' => 'Érôme',
	'FR26121' => 'Espeluche',
	'FR26122' => 'Espenel',
	'FR26123' => 'Establet',
	'FR26124' => 'Étoile-sur-Rhône',
	'FR26125' => 'Eurre',
	'FR26126' => 'Eygalayes',
	'FR26127' => 'Eygaliers',
	'FR26128' => 'Eygluy-Escoulin',
	'FR26129' => 'Eymeux',
	'FR26130' => 'Eyroles',
	'FR26131' => 'Eyzahut',
	'FR26133' => 'Fay-le-Clos',
	'FR26134' => 'Félines-sur-Rimandoule',
	'FR26135' => 'Ferrassières',
	'FR26136' => 'Val-Maravel',
	'FR26137' => 'Francillon-sur-Roubion',
	'FR26138' => 'La Garde-Adhémar',
	'FR26139' => 'Génissieux',
	'FR26140' => 'Geyssans',
	'FR26141' => 'Gigors-et-Lozeron',
	'FR26142' => 'Glandage',
	'FR26143' => 'Le Grand-Serre',
	'FR26144' => 'Grane',
	'FR26145' => 'Les Granges-Gontardes',
	'FR26146' => 'Grignan',
	'FR26147' => 'Gumiane',
	'FR26148' => 'Hauterives',
	'FR26149' => 'Hostun',
	'FR26150' => 'Izon-la-Bruisse',
	'FR26152' => 'Jonchères',
	'FR26153' => 'Laborel',
	'FR26154' => 'Lachau',
	'FR26155' => 'Lapeyrouse-Mornay',
	'FR26156' => 'Larnage',
	'FR26157' => 'La Laupie',
	'FR26159' => 'Laval-dAix',
	'FR26160' => 'Laveyron',
	'FR26161' => 'Lemps',
	'FR26162' => 'Lens-Lestang',
	'FR26163' => 'Léoncel',
	'FR26164' => 'Lesches-en-Diois',
	'FR26165' => 'Livron-sur-Drôme',
	'FR26166' => 'Loriol-sur-Drôme',
	'FR26167' => 'Luc-en-Diois',
	'FR26168' => 'Lus-la-Croix-Haute',
	'FR26169' => 'Malataverne',
	'FR26170' => 'Malissard',
	'FR26171' => 'Manas',
	'FR26172' => 'Manthes',
	'FR26173' => 'Marches',
	'FR26174' => 'Margès',
	'FR26175' => 'Marignac-en-Diois',
	'FR26176' => 'Marsanne',
	'FR26177' => 'Marsaz',
	'FR26178' => 'Menglon',
	'FR26179' => 'Mercurol-Veaunes',
	'FR26180' => 'Mérindol-les-Oliviers',
	'FR26181' => 'Mévouillon',
	'FR26182' => 'Mirabel-aux-Baronnies',
	'FR26183' => 'Mirabel-et-Blacons',
	'FR26185' => 'Mirmande',
	'FR26186' => 'Miscon',
	'FR26188' => 'Mollans-sur-Ouvèze',
	'FR26189' => 'Montauban-sur-lOuvèze',
	'FR26190' => 'Montaulieu',
	'FR26191' => 'Montboucher-sur-Jabron',
	'FR26192' => 'Montbrison-sur-Lez',
	'FR26193' => 'Montbrun-les-Bains',
	'FR26194' => 'Montchenu',
	'FR26195' => 'Montclar-sur-Gervanne',
	'FR26196' => 'Montéléger',
	'FR26197' => 'Montélier',
	'FR26198' => 'Montélimar',
	'FR26199' => 'Montferrand-la-Fare',
	'FR26200' => 'Montfroc',
	'FR26201' => 'Montguers',
	'FR26202' => 'Montjoux',
	'FR26203' => 'Montjoyer',
	'FR26204' => 'Montlaur-en-Diois',
	'FR26205' => 'Montmaur-en-Diois',
	'FR26206' => 'Montmeyran',
	'FR26207' => 'Montmiral',
	'FR26208' => 'Montoison',
	'FR26209' => 'Montréal-les-Sources',
	'FR26210' => 'Valherbasse',
	'FR26211' => 'Montségur-sur-Lauzon',
	'FR26212' => 'Montvendre',
	'FR26213' => 'Moras-en-Valloire',
	'FR26214' => 'Mornans',
	'FR26215' => 'La Motte-Chalancon',
	'FR26216' => 'La Motte-de-Galaure',
	'FR26217' => 'La Motte-Fanjas',
	'FR26218' => 'Mours-Saint-Eusèbe',
	'FR26219' => 'Mureils',
	'FR26220' => 'Nyons',
	'FR26221' => 'Omblèze',
	'FR26222' => 'Orcinas',
	'FR26223' => 'Oriol-en-Royans',
	'FR26224' => 'Ourches',
	'FR26225' => 'Parnans',
	'FR26226' => 'Le Pègue',
	'FR26227' => 'Pelonne',
	'FR26228' => 'Pennes-le-Sec',
	'FR26229' => 'La Penne-sur-lOuvèze',
	'FR26231' => 'Peyrins',
	'FR26232' => 'Peyrus',
	'FR26233' => 'Piégon',
	'FR26234' => 'Piégros-la-Clastre',
	'FR26235' => 'Pierrelatte',
	'FR26236' => 'Pierrelongue',
	'FR26238' => 'Les Pilles',
	'FR26239' => 'Plaisians',
	'FR26240' => 'Plan-de-Baix',
	'FR26241' => 'Le Poët-Célard',
	'FR26242' => 'Le Poët-en-Percip',
	'FR26243' => 'Le Poët-Laval',
	'FR26244' => 'Le Poët-Sigillat',
	'FR26245' => 'Pommerol',
	'FR26246' => 'Ponet-et-Saint-Auban',
	'FR26247' => 'Ponsas',
	'FR26248' => 'Pontaix',
	'FR26249' => 'Pont-de-Barret',
	'FR26250' => 'Pont-de-lIsère',
	'FR26251' => 'Portes-en-Valdaine',
	'FR26252' => 'Portes-lès-Valence',
	'FR26253' => 'Poyols',
	'FR26254' => 'Pradelle',
	'FR26255' => 'Les Prés',
	'FR26256' => 'Propiac',
	'FR26257' => 'Puygiron',
	'FR26258' => 'Puy-Saint-Martin',
	'FR26259' => 'Ratières',
	'FR26261' => 'Réauville',
	'FR26262' => 'Recoubeau-Jansac',
	'FR26263' => 'Reilhanette',
	'FR26264' => 'Rémuzat',
	'FR26266' => 'Rimon-et-Savel',
	'FR26267' => 'Rioms',
	'FR26268' => 'Rochebaudin',
	'FR26269' => 'Rochebrune',
	'FR26270' => 'Rochechinard',
	'FR26271' => 'La Roche-de-Glun',
	'FR26272' => 'Rochefort-en-Valdaine',
	'FR26273' => 'Rochefort-Samson',
	'FR26274' => 'Rochefourchat',
	'FR26275' => 'Rochegude',
	'FR26276' => 'Roche-Saint-Secret-Béconne',
	'FR26277' => 'La Roche-sur-Grane',
	'FR26278' => 'La Roche-sur-le-Buis',
	'FR26279' => 'La Rochette-du-Buis',
	'FR26281' => 'Romans-sur-Isère',
	'FR26282' => 'Romeyer',
	'FR26283' => 'Rottier',
	'FR26284' => 'Roussas',
	'FR26285' => 'Rousset-les-Vignes',
	'FR26286' => 'Roussieux',
	'FR26287' => 'Roynac',
	'FR26288' => 'Sahune',
	'FR26289' => 'Saillans',
	'FR26290' => 'Saint-Agnan-en-Vercors',
	'FR26291' => 'Saint-Andéol',
	'FR26292' => 'Saint-Auban-sur-lOuvèze',
	'FR26293' => 'Saint-Avit',
	'FR26294' => 'Saint-Bardoux',
	'FR26295' => 'Saint-Barthélemy-de-Vals',
	'FR26296' => 'Saint-Benoit-en-Diois',
	'FR26298' => 'Saint-Christophe-et-le-Laris',
	'FR26299' => 'Sainte-Croix',
	'FR26300' => 'Saint-Dizier-en-Diois',
	'FR26301' => 'Saint-Donat-sur-lHerbasse',
	'FR26302' => 'Sainte-Eulalie-en-Royans',
	'FR26303' => 'Sainte-Euphémie-sur-Ouvèze',
	'FR26304' => 'Saint-Ferréol-Trente-Pas',
	'FR26305' => 'Saint-Gervais-sur-Roubion',
	'FR26306' => 'Sainte-Jalle',
	'FR26307' => 'Saint-Jean-en-Royans',
	'FR26308' => 'Saint-Julien-en-Quint',
	'FR26309' => 'Saint-Julien-en-Vercors',
	'FR26310' => 'Saint-Laurent-dOnay',
	'FR26311' => 'Saint-Laurent-en-Royans',
	'FR26312' => 'Saint-Marcel-lès-Sauzet',
	'FR26313' => 'Saint-Marcel-lès-Valence',
	'FR26314' => 'Saint-Martin-dAoût',
	'FR26315' => 'Saint-Martin-en-Vercors',
	'FR26316' => 'Saint-Martin-le-Colonel',
	'FR26317' => 'Saint-Maurice-sur-Eygues',
	'FR26318' => 'Saint-May',
	'FR26319' => 'Saint-Michel-sur-Savasse',
	'FR26320' => 'Saint-Nazaire-en-Royans',
	'FR26321' => 'Saint-Nazaire-le-Désert',
	'FR26322' => 'Saint-Pantaléon-les-Vignes',
	'FR26323' => 'Saint-Paul-lès-Romans',
	'FR26324' => 'Saint-Paul-Trois-Châteaux',
	'FR26325' => 'Saint-Rambert-dAlbon',
	'FR26326' => 'Saint-Restitut',
	'FR26327' => 'Saint-Roman',
	'FR26328' => 'Saint-Sauveur-en-Diois',
	'FR26329' => 'Saint-Sauveur-Gouvernet',
	'FR26330' => 'Saint-Sorlin-en-Valloire',
	'FR26331' => 'Saint-Thomas-en-Royans',
	'FR26332' => 'Saint-Uze',
	'FR26333' => 'Saint-Vallier',
	'FR26334' => 'Salettes',
	'FR26335' => 'Salles-sous-Bois',
	'FR26336' => 'Saou',
	'FR26337' => 'Saulce-sur-Rhône',
	'FR26338' => 'Sauzet',
	'FR26339' => 'Savasse',
	'FR26340' => 'Séderon',
	'FR26341' => 'Serves-sur-Rhône',
	'FR26342' => 'Solérieux',
	'FR26343' => 'Souspierre',
	'FR26344' => 'Soyans',
	'FR26345' => 'Suze-la-Rousse',
	'FR26346' => 'Suze',
	'FR26347' => 'Tain-lHermitage',
	'FR26348' => 'Taulignan',
	'FR26349' => 'Tersanne',
	'FR26350' => 'Teyssières',
	'FR26351' => 'Les Tonils',
	'FR26352' => 'La Touche',
	'FR26353' => 'Les Tourrettes',
	'FR26355' => 'Triors',
	'FR26356' => 'Truinas',
	'FR26357' => 'Tulette',
	'FR26358' => 'Upie',
	'FR26359' => 'Vachères-en-Quint',
	'FR26360' => 'Valaurie',
	'FR26361' => 'Valdrôme',
	'FR26362' => 'Valence',
	'FR26363' => 'Valouse',
	'FR26364' => 'Vassieux-en-Vercors',
	'FR26365' => 'Vaunaveys-la-Rochette',
	'FR26367' => 'Venterol',
	'FR26368' => 'Vercheny',
	'FR26369' => 'Verclause',
	'FR26370' => 'Vercoiran',
	'FR26371' => 'Véronne',
	'FR26372' => 'Vers-sur-Méouge',
	'FR26373' => 'Vesc',
	'FR26374' => 'Villebois-les-Pins',
	'FR26375' => 'Villefranche-le-Château',
	'FR26376' => 'Villeperdrix',
	'FR26377' => 'Vinsobres',
	'FR26378' => 'Volvent',
	'FR26379' => 'Granges-les-Beaumont',
	'FR26380' => 'Gervans',
	'FR26381' => 'Jaillans',
	'FR26382' => 'Saint-Vincent-la-Commanderie',
	'FR27001' => 'Aclou',
	'FR27002' => 'Acon',
	'FR27003' => 'Acquigny',
	'FR27004' => 'Aigleville',
	'FR27005' => 'Ailly',
	'FR27006' => 'Aizier',
	'FR27008' => 'Alizay',
	'FR27009' => 'Ambenay',
	'FR27010' => 'Amécourt',
	'FR27011' => 'Amfreville-Saint-Amand',
	'FR27012' => 'Amfreville-les-Champs',
	'FR27013' => 'Amfreville-sous-les-Monts',
	'FR27014' => 'Amfreville-sur-Iton',
	'FR27015' => 'Andé',
	'FR27016' => 'Les Andelys',
	'FR27017' => 'Angerville-la-Campagne',
	'FR27018' => 'Appeville-Annebault',
	'FR27019' => 'Armentières-sur-Avre',
	'FR27020' => 'Arnières-sur-Iton',
	'FR27021' => 'Asnières',
	'FR27022' => 'Le Val dHazey',
	'FR27023' => 'Aulnay-sur-Iton',
	'FR27025' => 'Autheuil-Authouillet',
	'FR27026' => 'Authevernes',
	'FR27027' => 'Les Authieux',
	'FR27028' => 'Authou',
	'FR27031' => 'Aviron',
	'FR27032' => 'Chambois',
	'FR27033' => 'Bacquepuis',
	'FR27034' => 'Bacqueville',
	'FR27035' => 'Bailleul-la-Vallée',
	'FR27036' => 'Bâlines',
	'FR27037' => 'Barc',
	'FR27038' => 'Les Barils',
	'FR27039' => 'Barneville-sur-Seine',
	'FR27040' => 'Barquet',
	'FR27042' => 'Barville',
	'FR27043' => 'Les Baux-de-Breteuil',
	'FR27044' => 'Les Baux-Sainte-Croix',
	'FR27045' => 'Bazincourt-sur-Epte',
	'FR27046' => 'Bazoques',
	'FR27047' => 'Beaubray',
	'FR27048' => 'Beauficel-en-Lyons',
	'FR27049' => 'Mesnil-en-Ouche',
	'FR27050' => 'Beaumontel',
	'FR27051' => 'Beaumont-le-Roger',
	'FR27052' => 'Le Bec-Hellouin',
	'FR27053' => 'Le Bec-Thomas',
	'FR27054' => 'Bémécourt',
	'FR27055' => 'Bérengeville-la-Campagne',
	'FR27056' => 'Bernay',
	'FR27057' => 'Bernienville',
	'FR27059' => 'Bernouville',
	'FR27061' => 'Berthouville',
	'FR27062' => 'Les Monts du Roumois',
	'FR27063' => 'Berville-la-Campagne',
	'FR27064' => 'Berville-sur-Mer',
	'FR27065' => 'Beuzeville',
	'FR27066' => 'Bézu-la-Forêt',
	'FR27067' => 'Bézu-Saint-Éloi',
	'FR27068' => 'Bois-Anzeray',
	'FR27069' => 'Bois-Arnault',
	'FR27070' => 'Frenelles-en-Vexin',
	'FR27071' => 'Le Bois-Hellain',
	'FR27072' => 'Bois-Jérôme-Saint-Ouen',
	'FR27073' => 'Bois-le-Roi',
	'FR27074' => 'Boisney',
	'FR27075' => 'Bois-Normand-près-Lyre',
	'FR27076' => 'Boisset-les-Prévanches',
	'FR27077' => 'Boissey-le-Châtel',
	'FR27078' => 'La Boissière',
	'FR27079' => 'Boissy-Lamberville',
	'FR27081' => 'Boncourt',
	'FR27082' => 'La Bonneville-sur-Iton',
	'FR27083' => 'Bonneville-Aptot',
	'FR27085' => 'Flancourt-Crescy-en-Roumois',
	'FR27089' => 'Thénouville',
	'FR27090' => 'Bosroumois',
	'FR27091' => 'Bosgouet',
	'FR27094' => 'Bosquentin',
	'FR27095' => 'Bosrobert',
	'FR27096' => 'Les Bottereaux',
	'FR27097' => 'Bouafles',
	'FR27098' => 'Bouchevilliers',
	'FR27099' => 'Le Boulay-Morin',
	'FR27100' => 'Boulleville',
	'FR27101' => 'Bouquelon',
	'FR27102' => 'Bouquetot',
	'FR27103' => 'Bourg-Achard',
	'FR27104' => 'Bourg-Beaudouin',
	'FR27105' => 'Grand Bourgtheroulde',
	'FR27106' => 'Bournainville-Faverolles',
	'FR27107' => 'Bourneville-Sainte-Croix',
	'FR27108' => 'Bourth',
	'FR27109' => 'Bray',
	'FR27110' => 'Brestot',
	'FR27111' => 'Bretagnolles',
	'FR27112' => 'Breteuil',
	'FR27113' => 'Brétigny',
	'FR27114' => 'Breuilpont',
	'FR27115' => 'Breux-sur-Avre',
	'FR27116' => 'Brionne',
	'FR27117' => 'Broglie',
	'FR27118' => 'Brosville',
	'FR27119' => 'Bueil',
	'FR27120' => 'Burey',
	'FR27123' => 'Caillouet-Orgeville',
	'FR27124' => 'Cailly-sur-Eure',
	'FR27125' => 'Calleville',
	'FR27126' => 'Campigny',
	'FR27127' => 'Canappeville',
	'FR27129' => 'Caorches-Saint-Nicolas',
	'FR27130' => 'Capelle-les-Grands',
	'FR27132' => 'Caugé',
	'FR27133' => 'Caumont',
	'FR27134' => 'Cauverville-en-Roumois',
	'FR27135' => 'Cesseville',
	'FR27136' => 'Chaignes',
	'FR27137' => 'Chaise-Dieu-du-Theil',
	'FR27138' => 'Chamblac',
	'FR27139' => 'Chambord',
	'FR27140' => 'Chambray',
	'FR27141' => 'Champ-Dolent',
	'FR27142' => 'Champenard',
	'FR27144' => 'Champigny-la-Futelaye',
	'FR27146' => 'La Chapelle-Bayvel',
	'FR27147' => 'La Chapelle-du-Bois-des-Faulx',
	'FR27148' => 'La Chapelle-Gauthier',
	'FR27149' => 'La Chapelle-Hareng',
	'FR27151' => 'Charleval',
	'FR27152' => 'Château-sur-Epte',
	'FR27153' => 'Chauvincourt-Provemont',
	'FR27154' => 'Chavigny-Bailleul',
	'FR27155' => 'Chennebrun',
	'FR27156' => 'Chéronvilliers',
	'FR27157' => 'Marbois',
	'FR27158' => 'Cierrey',
	'FR27161' => 'Claville',
	'FR27162' => 'Collandres-Quincarnon',
	'FR27163' => 'Colletot',
	'FR27164' => 'Combon',
	'FR27165' => 'Conches-en-Ouche',
	'FR27167' => 'Condé-sur-Risle',
	'FR27168' => 'Connelles',
	'FR27169' => 'Conteville',
	'FR27170' => 'Cormeilles',
	'FR27171' => 'Le Cormier',
	'FR27173' => 'Corneville-la-Fouquetière',
	'FR27174' => 'Corneville-sur-Risle',
	'FR27176' => 'Coudray',
	'FR27177' => 'Coudres',
	'FR27179' => 'Courbépine',
	'FR27180' => 'Courcelles-sur-Seine',
	'FR27181' => 'Courdemanche',
	'FR27182' => 'Courteilles',
	'FR27183' => 'La Couture-Boussey',
	'FR27184' => 'Crasville',
	'FR27185' => 'Crestot',
	'FR27187' => 'Criquebeuf-la-Campagne',
	'FR27188' => 'Criquebeuf-sur-Seine',
	'FR27189' => 'La Croisille',
	'FR27190' => 'Croisy-sur-Eure',
	'FR27191' => 'Clef Vallée dEure',
	'FR27192' => 'Crosville-la-Vieille',
	'FR27193' => 'Croth',
	'FR27194' => 'Cuverville',
	'FR27196' => 'Les Damps',
	'FR27198' => 'Mesnils-sur-Iton',
	'FR27199' => 'Dangu',
	'FR27200' => 'Dardez',
	'FR27201' => 'Daubeuf-la-Campagne',
	'FR27202' => 'Daubeuf-près-Vatteville',
	'FR27203' => 'Douains',
	'FR27204' => 'Doudeauville-en-Vexin',
	'FR27205' => 'Douville-sur-Andelle',
	'FR27206' => 'Droisy',
	'FR27207' => 'Drucourt',
	'FR27208' => 'Duranville',
	'FR27209' => 'Écaquelon',
	'FR27210' => 'Écardenville-la-Campagne',
	'FR27212' => 'Écauville',
	'FR27213' => 'Vexin-sur-Epte',
	'FR27214' => 'Écouis',
	'FR27215' => 'Ecquetot',
	'FR27216' => 'Émalleville',
	'FR27217' => 'Émanville',
	'FR27218' => 'Épaignes',
	'FR27219' => 'Épégard',
	'FR27220' => 'Épieds',
	'FR27222' => 'Épreville-en-Lieuvin',
	'FR27224' => 'Épreville-près-le-Neubourg',
	'FR27226' => 'Étrépagny',
	'FR27227' => 'Étréville',
	'FR27228' => 'Éturqueraye',
	'FR27229' => 'Évreux',
	'FR27230' => 'Ézy-sur-Eure',
	'FR27231' => 'Fains',
	'FR27232' => 'Farceaux',
	'FR27233' => 'Fatouville-Grestain',
	'FR27234' => 'Fauville',
	'FR27235' => 'Faverolles-la-Campagne',
	'FR27237' => 'Le Favril',
	'FR27238' => 'Ferrières-Haut-Clocher',
	'FR27239' => 'Ferrières-Saint-Hilaire',
	'FR27240' => 'La Ferrière-sur-Risle',
	'FR27241' => 'Feuguerolles',
	'FR27242' => 'Le Fidelaire',
	'FR27243' => 'Fiquefleur-Équainville',
	'FR27245' => 'Fleury-la-Forêt',
	'FR27246' => 'Fleury-sur-Andelle',
	'FR27247' => 'Flipou',
	'FR27248' => 'Folleville',
	'FR27249' => 'Fontaine-Bellenger',
	'FR27251' => 'Fontaine-lAbbé',
	'FR27252' => 'Fontaine-la-Louvet',
	'FR27254' => 'Fontaine-sous-Jouy',
	'FR27256' => 'La Forêt-du-Parc',
	'FR27258' => 'Fort-Moville',
	'FR27259' => 'Foucrainville',
	'FR27260' => 'Foulbec',
	'FR27261' => 'Fouqueville',
	'FR27263' => 'Le Perrey',
	'FR27266' => 'Franqueville',
	'FR27267' => 'Freneuse-sur-Risle',
	'FR27269' => 'Fresne-Cauverville',
	'FR27271' => 'Fresney',
	'FR27273' => 'Gadencourt',
	'FR27275' => 'Gaillon',
	'FR27276' => 'Gamaches-en-Vexin',
	'FR27277' => 'La Baronnie',
	'FR27278' => 'Garennes-sur-Eure',
	'FR27279' => 'Gasny',
	'FR27280' => 'Gauciel',
	'FR27281' => 'Gaudreville-la-Rivière',
	'FR27282' => 'Gauville-la-Campagne',
	'FR27284' => 'Gisors',
	'FR27285' => 'Giverny',
	'FR27286' => 'Giverville',
	'FR27287' => 'Glisolles',
	'FR27288' => 'Glos-sur-Risle',
	'FR27289' => 'La Goulafrière',
	'FR27290' => 'Goupil-Othon',
	'FR27291' => 'Gournay-le-Guérin',
	'FR27294' => 'Val dOrger',
	'FR27295' => 'Grand-Camp',
	'FR27298' => 'Graveron-Sémerville',
	'FR27299' => 'Gravigny',
	'FR27300' => 'Grosley-sur-Risle',
	'FR27301' => 'Grossœuvre',
	'FR27302' => 'Le Bosc du Theil',
	'FR27304' => 'Guerny',
	'FR27306' => 'Guichainville',
	'FR27307' => 'Guiseniers',
	'FR27309' => 'LHabit',
	'FR27310' => 'Hacqueville',
	'FR27311' => 'Harcourt',
	'FR27312' => 'Hardencourt-Cocherel',
	'FR27313' => 'La Harengère',
	'FR27315' => 'Harquency',
	'FR27316' => 'Hauville',
	'FR27317' => 'La Haye-Aubrée',
	'FR27318' => 'La Haye-de-Calleville',
	'FR27319' => 'La Haye-de-Routot',
	'FR27320' => 'La Haye-du-Theil',
	'FR27321' => 'La Haye-le-Comte',
	'FR27322' => 'La Haye-Malherbe',
	'FR27323' => 'La Haye-Saint-Sylvestre',
	'FR27324' => 'Hébécourt',
	'FR27325' => 'Hecmanville',
	'FR27326' => 'Hécourt',
	'FR27327' => 'Hectomare',
	'FR27329' => 'Hennezis',
	'FR27330' => 'Herqueville',
	'FR27331' => 'Heubécourt-Haricourt',
	'FR27332' => 'Heudebouville',
	'FR27333' => 'Heudicourt',
	'FR27334' => 'Heudreville-en-Lieuvin',
	'FR27335' => 'Heudreville-sur-Eure',
	'FR27336' => 'La Heunière',
	'FR27337' => 'Heuqueville',
	'FR27338' => 'Les Hogues',
	'FR27339' => 'Hondouville',
	'FR27340' => 'Honguemare-Guenouville',
	'FR27341' => 'LHosmes',
	'FR27342' => 'Houetteville',
	'FR27343' => 'Houlbec-Cocherel',
	'FR27345' => 'La Houssaye',
	'FR27346' => 'Houville-en-Vexin',
	'FR27347' => 'Huest',
	'FR27348' => 'Igoville',
	'FR27349' => 'Illeville-sur-Montfort',
	'FR27350' => 'Illiers-lÉvêque',
	'FR27351' => 'Incarville',
	'FR27353' => 'Irreville',
	'FR27354' => 'Iville',
	'FR27355' => 'Ivry-la-Bataille',
	'FR27358' => 'Jouy-sur-Eure',
	'FR27359' => 'Juignettes',
	'FR27360' => 'Jumelles',
	'FR27361' => 'La Lande-Saint-Léger',
	'FR27363' => 'Le Landin',
	'FR27364' => 'Launay',
	'FR27365' => 'Léry',
	'FR27366' => 'Letteguives',
	'FR27367' => 'Lieurey',
	'FR27368' => 'Lignerolles',
	'FR27369' => 'Lilly',
	'FR27370' => 'Lisors',
	'FR27371' => 'Livet-sur-Authou',
	'FR27372' => 'Longchamps',
	'FR27373' => 'Lorleau',
	'FR27374' => 'Louversey',
	'FR27375' => 'Louviers',
	'FR27376' => 'Louye',
	'FR27377' => 'Lyons-la-Forêt',
	'FR27378' => 'La Madeleine-de-Nonancourt',
	'FR27379' => 'Mainneville',
	'FR27380' => 'Malleville-sur-le-Bec',
	'FR27381' => 'Malouy',
	'FR27382' => 'Mandeville',
	'FR27383' => 'Mandres',
	'FR27384' => 'Manneville-la-Raoult',
	'FR27385' => 'Manneville-sur-Risle',
	'FR27386' => 'Le Manoir',
	'FR27388' => 'Marais-Vernier',
	'FR27389' => 'Marbeuf',
	'FR27390' => 'Marcilly-la-Campagne',
	'FR27391' => 'Marcilly-sur-Eure',
	'FR27392' => 'Martagny',
	'FR27393' => 'Martainville',
	'FR27394' => 'Martot',
	'FR27395' => 'Mélicourt',
	'FR27396' => 'Ménesqueville',
	'FR27397' => 'Ménilles',
	'FR27398' => 'Menneval',
	'FR27399' => 'Mercey',
	'FR27400' => 'Merey',
	'FR27401' => 'Le Mesnil-Fuguet',
	'FR27403' => 'Le Mesnil-Jourdain',
	'FR27404' => 'Mesnil-Rousset',
	'FR27405' => 'Mesnil-sous-Vienne',
	'FR27406' => 'Mesnil-sur-lEstrée',
	'FR27407' => 'Mesnil-Verclives',
	'FR27408' => 'Mézières-en-Vexin',
	'FR27410' => 'Miserey',
	'FR27411' => 'Moisville',
	'FR27412' => 'Terres de Bord',
	'FR27413' => 'Montfort-sur-Risle',
	'FR27414' => 'Montreuil-lArgillé',
	'FR27415' => 'Morainville-Jouveaux',
	'FR27417' => 'Morgny',
	'FR27418' => 'Morsan',
	'FR27419' => 'Mouettes',
	'FR27420' => 'Mouflaines',
	'FR27421' => 'Mousseaux-Neuville',
	'FR27422' => 'Muids',
	'FR27423' => 'Muzy',
	'FR27424' => 'Nagel-Séez-Mesnil',
	'FR27425' => 'Nassandres sur Risle',
	'FR27426' => 'Neaufles-Saint-Martin',
	'FR27427' => 'Neaufles-Auvergny',
	'FR27428' => 'Le Neubourg',
	'FR27429' => 'Neuilly',
	'FR27430' => 'La Neuve-Grange',
	'FR27431' => 'La Neuve-Lyre',
	'FR27432' => 'La Neuville-du-Bosc',
	'FR27433' => 'Neuville-sur-Authou',
	'FR27434' => 'Noards',
	'FR27435' => 'La Noë-Poulain',
	'FR27436' => 'Nogent-le-Sec',
	'FR27437' => 'Nojeon-en-Vexin',
	'FR27438' => 'Nonancourt',
	'FR27439' => 'Normanville',
	'FR27440' => 'Notre-Dame-de-lIsle',
	'FR27441' => 'Notre-Dame-dÉpine',
	'FR27442' => 'Notre-Dame-du-Hamel',
	'FR27444' => 'Le Noyer-en-Ouche',
	'FR27445' => 'Noyers',
	'FR27446' => 'Ormes',
	'FR27447' => 'Le Val-Doré',
	'FR27448' => 'Pacy-sur-Eure',
	'FR27451' => 'Parville',
	'FR27453' => 'Perriers-sur-Andelle',
	'FR27454' => 'Perruel',
	'FR27455' => 'Piencourt',
	'FR27456' => 'Pinterville',
	'FR27457' => 'Piseux',
	'FR27458' => 'Pîtres',
	'FR27459' => 'Les Places',
	'FR27460' => 'Plainville',
	'FR27462' => 'Le Planquay',
	'FR27463' => 'Plasnes',
	'FR27464' => 'Le Plessis-Grohan',
	'FR27465' => 'Le Plessis-Hébert',
	'FR27466' => 'Le Plessis-Sainte-Opportune',
	'FR27467' => 'Pont-Audemer',
	'FR27468' => 'Pont-Authou',
	'FR27469' => 'Pont-de-lArche',
	'FR27470' => 'Pont-Saint-Pierre',
	'FR27471' => 'Porte-de-Seine',
	'FR27472' => 'Portes',
	'FR27473' => 'Port-Mort',
	'FR27474' => 'Poses',
	'FR27475' => 'La Poterie-Mathieu',
	'FR27476' => 'Les Préaux',
	'FR27477' => 'Pressagny-lOrgueilleux',
	'FR27478' => 'Prey',
	'FR27480' => 'Puchay',
	'FR27481' => 'Pullay',
	'FR27482' => 'La Pyle',
	'FR27483' => 'Quatremare',
	'FR27485' => 'Quillebeuf-sur-Seine',
	'FR27486' => 'Quittebeuf',
	'FR27487' => 'Radepont',
	'FR27488' => 'Renneville',
	'FR27489' => 'Reuilly',
	'FR27490' => 'Richeville',
	'FR27492' => 'Romilly-la-Puthenaye',
	'FR27493' => 'Romilly-sur-Andelle',
	'FR27495' => 'La Roquette',
	'FR27496' => 'Rosay-sur-Lieure',
	'FR27497' => 'Rougemontiers',
	'FR27498' => 'Rouge-Perriers',
	'FR27500' => 'Routot',
	'FR27501' => 'Rouvray',
	'FR27502' => 'Rugles',
	'FR27504' => 'Sacquenville',
	'FR27505' => 'Saint-Agnan-de-Cernières',
	'FR27507' => 'Saint-André-de-lEure',
	'FR27508' => 'Saint-Antonin-de-Sommaire',
	'FR27511' => 'Saint-Aubin-dÉcrosville',
	'FR27512' => 'Saint-Aubin-de-Scellon',
	'FR27514' => 'Saint-Aubin-du-Thenney',
	'FR27516' => 'Treis-Sants-en-Ouche',
	'FR27517' => 'Saint-Aubin-sur-Gaillon',
	'FR27518' => 'Saint-Aubin-sur-Quillebeuf',
	'FR27520' => 'Saint-Benoît-des-Ombres',
	'FR27521' => 'Saint-Christophe-sur-Avre',
	'FR27522' => 'Saint-Christophe-sur-Condé',
	'FR27524' => 'Sainte-Colombe-la-Commanderie',
	'FR27525' => 'Sainte-Colombe-près-Vernon',
	'FR27527' => 'Saint-Cyr-de-Salerne',
	'FR27528' => 'Le Vaudreuil',
	'FR27529' => 'Saint-Cyr-la-Campagne',
	'FR27530' => 'Saint-Denis-dAugerons',
	'FR27531' => 'Saint-Denis-des-Monts',
	'FR27533' => 'Saint-Denis-le-Ferment',
	'FR27534' => 'Saint-Didier-des-Bois',
	'FR27535' => 'Saint-Élier',
	'FR27536' => 'Saint-Éloi-de-Fourques',
	'FR27537' => 'Saint-Étienne-du-Vauvray',
	'FR27538' => 'Saint-Étienne-lAllier',
	'FR27539' => 'Saint-Étienne-sous-Bailleul',
	'FR27540' => 'Sainte-Geneviève-lès-Gasny',
	'FR27541' => 'Le Mesnil-Saint-Jean',
	'FR27542' => 'Saint-Georges-du-Vièvre',
	'FR27543' => 'Saint-Georges-Motel',
	'FR27544' => 'Saint-Germain-de-Fresney',
	'FR27545' => 'Saint-Germain-de-Pasquier',
	'FR27546' => 'Saint-Germain-des-Angles',
	'FR27547' => 'Saint-Germain-la-Campagne',
	'FR27548' => 'Saint-Germain-sur-Avre',
	'FR27550' => 'Saint-Grégoire-du-Vièvre',
	'FR27552' => 'Saint-Jean-du-Thenney',
	'FR27553' => 'Saint-Julien-de-la-Liègue',
	'FR27554' => 'La Chapelle-Longueville',
	'FR27555' => 'Saint-Laurent-des-Bois',
	'FR27556' => 'Saint-Laurent-du-Tencement',
	'FR27557' => 'Saint-Léger-de-Rôtes',
	'FR27558' => 'Saint-Léger-du-Gennetey',
	'FR27560' => 'Saint-Luc',
	'FR27561' => 'Saint-Maclou',
	'FR27562' => 'Saint-Marcel',
	'FR27563' => 'Saint-Mards-de-Blacarville',
	'FR27564' => 'Saint-Mards-de-Fresne',
	'FR27565' => 'Le Lesme',
	'FR27567' => 'Sainte-Marie-de-Vatimesnil',
	'FR27568' => 'Sainte-Marthe',
	'FR27569' => 'Saint-Martin-du-Tilleul',
	'FR27570' => 'Saint-Martin-la-Campagne',
	'FR27571' => 'Saint-Martin-Saint-Firmin',
	'FR27572' => 'Saint-Meslin-du-Bosc',
	'FR27576' => 'Sainte-Opportune-du-Bosc',
	'FR27577' => 'Sainte-Opportune-la-Mare',
	'FR27578' => 'Sainte-Marie-dAttez',
	'FR27579' => 'Saint-Ouen-de-Pontcheuil',
	'FR27580' => 'Saint-Ouen-de-Thouberville',
	'FR27582' => 'Saint-Ouen-du-Tilleul',
	'FR27584' => 'Saint-Paul-de-Fourques',
	'FR27586' => 'Saint-Philbert-sur-Boissey',
	'FR27587' => 'Saint-Philbert-sur-Risle',
	'FR27589' => 'Saint-Pierre-de-Bailleul',
	'FR27590' => 'Saint-Pierre-de-Cernières',
	'FR27591' => 'Saint-Pierre-de-Cormeilles',
	'FR27592' => 'Saint-Pierre-de-Salerne',
	'FR27593' => 'Saint-Pierre-des-Fleurs',
	'FR27594' => 'Saint-Pierre-des-Ifs',
	'FR27595' => 'Saint-Pierre-du-Bosguérard',
	'FR27597' => 'Saint-Pierre-du-Val',
	'FR27598' => 'Saint-Pierre-du-Vauvray',
	'FR27599' => 'Saint-Pierre-la-Garenne',
	'FR27601' => 'Saint-Samson-de-la-Roque',
	'FR27602' => 'Saint-Sébastien-de-Morsent',
	'FR27603' => 'Saint-Siméon',
	'FR27604' => 'Saint-Sulpice-de-Grimbouville',
	'FR27605' => 'Saint-Sylvestre-de-Cormeilles',
	'FR27606' => 'Saint-Symphorien',
	'FR27608' => 'Saint-Victor-de-Chrétienville',
	'FR27609' => 'Saint-Victor-dÉpine',
	'FR27610' => 'Saint-Victor-sur-Avre',
	'FR27611' => 'Saint-Vigor',
	'FR27612' => 'Saint-Vincent-des-Bois',
	'FR27613' => 'Saint-Vincent-du-Boulay',
	'FR27614' => 'Sancourt',
	'FR27615' => 'Sassey',
	'FR27616' => 'La Saussaye',
	'FR27617' => 'Saussay-la-Campagne',
	'FR27618' => 'Sébécourt',
	'FR27620' => 'Selles',
	'FR27621' => 'Serez',
	'FR27622' => 'Serquigny',
	'FR27623' => 'Surtauville',
	'FR27624' => 'Surville',
	'FR27625' => 'Suzay',
	'FR27627' => 'Le Theil-Nolent',
	'FR27629' => 'Thiberville',
	'FR27630' => 'Thibouville',
	'FR27631' => 'Thierville',
	'FR27632' => 'Le Thil',
	'FR27633' => 'Les Thilliers-en-Vexin',
	'FR27635' => 'Le Thuit',
	'FR27638' => 'Le Thuit de lOison',
	'FR27640' => 'Tilleul-Dame-Agnès',
	'FR27641' => 'Le Tilleul-Lambert',
	'FR27643' => 'Tillières-sur-Avre',
	'FR27644' => 'Tilly',
	'FR27645' => 'Tocqueville',
	'FR27646' => 'Le Torpt',
	'FR27649' => 'Touffreville',
	'FR27650' => 'Tournedos-Bois-Hubert',
	'FR27652' => 'Tourneville',
	'FR27654' => 'Tourville-la-Campagne',
	'FR27655' => 'Tourville-sur-Pont-Audemer',
	'FR27656' => 'Toutainville',
	'FR27658' => 'Le Tremblay-Omonville',
	'FR27659' => 'La Trinité',
	'FR27660' => 'La Trinité-de-Réville',
	'FR27661' => 'La Trinité-de-Thouberville',
	'FR27662' => 'Triqueville',
	'FR27663' => 'Le Troncq',
	'FR27664' => 'Le Tronquay',
	'FR27665' => 'Trouville-la-Haule',
	'FR27666' => 'La Vacherie',
	'FR27667' => 'Valailles',
	'FR27668' => 'Le Val-David',
	'FR27669' => 'Valletot',
	'FR27670' => 'Vandrimare',
	'FR27671' => 'Vannecrocq',
	'FR27672' => 'Vascœuil',
	'FR27673' => 'Vatteville',
	'FR27674' => 'Vaux-sur-Eure',
	'FR27676' => 'Les Trois Lacs',
	'FR27677' => 'Venon',
	'FR27678' => 'Les Ventes',
	'FR27679' => 'Verneuil dAvre et dIton',
	'FR27680' => 'Verneusses',
	'FR27681' => 'Vernon',
	'FR27682' => 'Vesly',
	'FR27683' => 'Vézillon',
	'FR27684' => 'Le Vieil-Évreux',
	'FR27685' => 'La Vieille-Lyre',
	'FR27686' => 'Vieux-Port',
	'FR27689' => 'Villegats',
	'FR27690' => 'Villers-en-Vexin',
	'FR27691' => 'Villers-sur-le-Roule',
	'FR27692' => 'Villettes',
	'FR27693' => 'Sylvains-Lès-Moulins',
	'FR27694' => 'Villez-sous-Bailleul',
	'FR27695' => 'Villez-sur-le-Neubourg',
	'FR27696' => 'Villiers-en-Désœuvre',
	'FR27697' => 'Vironvay',
	'FR27698' => 'Vitot',
	'FR27699' => 'Voiscreville',
	'FR27700' => 'Vraiville',
	'FR27701' => 'Val-de-Reuil',
	'FR28001' => 'Abondant',
	'FR28003' => 'Allainville',
	'FR28004' => 'Allonnes',
	'FR28005' => 'Alluyes',
	'FR28006' => 'Amilly',
	'FR28007' => 'Anet',
	'FR28008' => 'Ardelles',
	'FR28009' => 'Ardelu',
	'FR28010' => 'Argenvilliers',
	'FR28012' => 'Commune nouvelle dArrou',
	'FR28013' => 'Aunay-sous-Auneau',
	'FR28014' => 'Aunay-sous-Crécy',
	'FR28015' => 'Auneau-Bleury-Saint-Symphorien',
	'FR28016' => 'Les Autels-Villevillon',
	'FR28018' => 'Authon-du-Perche',
	'FR28019' => 'Baigneaux',
	'FR28021' => 'Bailleau-le-Pin',
	'FR28022' => 'Bailleau-lÉvêque',
	'FR28023' => 'Bailleau-Armenonville',
	'FR28024' => 'Barjouville',
	'FR28025' => 'Barmainville',
	'FR28026' => 'Baudreville',
	'FR28027' => 'La Bazoche-Gouet',
	'FR28028' => 'Bazoches-en-Dunois',
	'FR28029' => 'Bazoches-les-Hautes',
	'FR28030' => 'Beauche',
	'FR28031' => 'Beaumont-les-Autels',
	'FR28032' => 'Beauvilliers',
	'FR28033' => 'Belhomert-Guéhouville',
	'FR28034' => 'Berchères-Saint-Germain',
	'FR28035' => 'Berchères-les-Pierres',
	'FR28036' => 'Berchères-sur-Vesgre',
	'FR28037' => 'Bérou-la-Mulotière',
	'FR28038' => 'Béthonvilliers',
	'FR28039' => 'Béville-le-Comte',
	'FR28040' => 'Billancelles',
	'FR28041' => 'Blandainville',
	'FR28045' => 'Boissy-en-Drouais',
	'FR28046' => 'Boissy-lès-Perche',
	'FR28047' => 'Boisville-la-Saint-Père',
	'FR28048' => 'La Bourdinière-Saint-Loup',
	'FR28049' => 'Boncé',
	'FR28050' => 'Boncourt',
	'FR28051' => 'Bonneval',
	'FR28052' => 'Bouglainval',
	'FR28053' => 'Le Boullay-les-Deux-Églises',
	'FR28054' => 'Le Boullay-Mivoye',
	'FR28055' => 'Le Boullay-Thierry',
	'FR28056' => 'Boutigny-Prouais',
	'FR28057' => 'Bouville',
	'FR28058' => 'Bréchamps',
	'FR28059' => 'Brezolles',
	'FR28060' => 'Briconville',
	'FR28061' => 'Brou',
	'FR28062' => 'Broué',
	'FR28064' => 'Bû',
	'FR28065' => 'Bullainville',
	'FR28067' => 'Cernay',
	'FR28068' => 'Challet',
	'FR28070' => 'Champhol',
	'FR28071' => 'Champrond-en-Gâtine',
	'FR28072' => 'Champrond-en-Perchet',
	'FR28073' => 'Champseru',
	'FR28074' => 'La Chapelle-dAunainville',
	'FR28075' => 'La Chapelle-du-Noyer',
	'FR28076' => 'La Chapelle-Forainvilliers',
	'FR28077' => 'La Chapelle-Fortin',
	'FR28078' => 'Chapelle-Guillaume',
	'FR28079' => 'Chapelle-Royale',
	'FR28080' => 'Charbonnières',
	'FR28081' => 'Charonville',
	'FR28082' => 'Charpont',
	'FR28084' => 'Chartainvilliers',
	'FR28085' => 'Chartres',
	'FR28086' => 'Chassant',
	'FR28087' => 'Châtaincourt',
	'FR28088' => 'Châteaudun',
	'FR28089' => 'Châteauneuf-en-Thymerais',
	'FR28090' => 'Les Châtelets',
	'FR28091' => 'Les Châtelliers-Notre-Dame',
	'FR28092' => 'Châtenay',
	'FR28094' => 'Chaudon',
	'FR28095' => 'Chauffours',
	'FR28096' => 'La Chaussée-dIvry',
	'FR28098' => 'Cherisy',
	'FR28099' => 'Chuisnes',
	'FR28100' => 'Cintray',
	'FR28102' => 'Clévilliers',
	'FR28103' => 'Cloyes-les-Trois-Rivières',
	'FR28104' => 'Coltainville',
	'FR28105' => 'Combres',
	'FR28106' => 'Conie-Molitard',
	'FR28107' => 'Corancez',
	'FR28108' => 'Cormainville',
	'FR28109' => 'Les Corvées-les-Yys',
	'FR28110' => 'Le Coudray',
	'FR28111' => 'Coudray-au-Perche',
	'FR28113' => 'Coulombs',
	'FR28114' => 'Courbehaye',
	'FR28116' => 'Courville-sur-Eure',
	'FR28117' => 'Crécy-Couvé',
	'FR28118' => 'Croisilles',
	'FR28119' => 'La Croix-du-Perche',
	'FR28120' => 'Crucey-Villages',
	'FR28121' => 'Dambron',
	'FR28122' => 'Dammarie',
	'FR28123' => 'Dampierre-sous-Brou',
	'FR28124' => 'Dampierre-sur-Avre',
	'FR28126' => 'Dancy',
	'FR28127' => 'Dangeau',
	'FR28128' => 'Dangers',
	'FR28129' => 'Denonville',
	'FR28130' => 'Digny',
	'FR28132' => 'Donnemain-Saint-Mamès',
	'FR28134' => 'Dreux',
	'FR28135' => 'Droue-sur-Drouette',
	'FR28136' => 'Écluzelles',
	'FR28137' => 'Écrosnes',
	'FR28139' => 'Épeautrolles',
	'FR28140' => 'Épernon',
	'FR28141' => 'Ermenonville-la-Grande',
	'FR28142' => 'Ermenonville-la-Petite',
	'FR28143' => 'Escorpain',
	'FR28144' => 'Les Étilleux',
	'FR28146' => 'Faverolles',
	'FR28147' => 'Favières',
	'FR28148' => 'Le Favril',
	'FR28149' => 'La Ferté-Vidame',
	'FR28151' => 'Fessanvilliers-Mattanvilliers',
	'FR28153' => 'Flacey',
	'FR28154' => 'Fontaine-la-Guyon',
	'FR28155' => 'Fontaine-les-Ribouts',
	'FR28156' => 'Fontaine-Simon',
	'FR28157' => 'Fontenay-sur-Conie',
	'FR28158' => 'Fontenay-sur-Eure',
	'FR28159' => 'La Framboisière',
	'FR28160' => 'Francourville',
	'FR28161' => 'Frazé',
	'FR28162' => 'Fresnay-le-Comte',
	'FR28163' => 'Fresnay-le-Gilmert',
	'FR28164' => 'Fresnay-lÉvêque',
	'FR28166' => 'Friaize',
	'FR28167' => 'Fruncé',
	'FR28168' => 'Gallardon',
	'FR28169' => 'Garancières-en-Beauce',
	'FR28170' => 'Garancières-en-Drouais',
	'FR28171' => 'Garnay',
	'FR28172' => 'Gas',
	'FR28173' => 'Gasville-Oisème',
	'FR28175' => 'La Gaudaine',
	'FR28176' => 'Le Gault-Saint-Denis',
	'FR28177' => 'Gellainville',
	'FR28178' => 'Germainville',
	'FR28180' => 'Gilles',
	'FR28182' => 'Gohory',
	'FR28183' => 'Gommerville',
	'FR28184' => 'Gouillons',
	'FR28185' => 'Goussainville',
	'FR28187' => 'Guainville',
	'FR28188' => 'Le Gué-de-Longroi',
	'FR28189' => 'Guilleville',
	'FR28190' => 'Guillonville',
	'FR28191' => 'Hanches',
	'FR28192' => 'Happonvilliers',
	'FR28193' => 'Havelu',
	'FR28194' => 'Houville-la-Branche',
	'FR28195' => 'Houx',
	'FR28196' => 'Illiers-Combray',
	'FR28197' => 'Intréville',
	'FR28198' => 'Jallans',
	'FR28199' => 'Janville-en-Beauce',
	'FR28200' => 'Jaudrais',
	'FR28201' => 'Jouy',
	'FR28202' => 'Lamblore',
	'FR28203' => 'Landelles',
	'FR28206' => 'Laons',
	'FR28207' => 'Léthuin',
	'FR28208' => 'Levainville',
	'FR28209' => 'Lèves',
	'FR28210' => 'Levesville-la-Chenard',
	'FR28211' => 'Logron',
	'FR28212' => 'Loigny-la-Bataille',
	'FR28213' => 'Lormaye',
	'FR28214' => 'La Loupe',
	'FR28215' => 'Louville-la-Chenard',
	'FR28216' => 'Louvilliers-en-Drouais',
	'FR28217' => 'Louvilliers-lès-Perche',
	'FR28218' => 'Lucé',
	'FR28219' => 'Luigny',
	'FR28220' => 'Luisant',
	'FR28221' => 'Lumeau',
	'FR28222' => 'Luplanté',
	'FR28223' => 'Luray',
	'FR28225' => 'Magny',
	'FR28226' => 'Maillebois',
	'FR28227' => 'Maintenon',
	'FR28229' => 'Mainvilliers',
	'FR28230' => 'Maisons',
	'FR28231' => 'La Mancelière',
	'FR28232' => 'Manou',
	'FR28233' => 'Marboué',
	'FR28234' => 'Marchéville',
	'FR28235' => 'Marchezais',
	'FR28236' => 'Arcisses',
	'FR28237' => 'Marolles-les-Buis',
	'FR28239' => 'Marville-Moutiers-Brûlé',
	'FR28240' => 'Meaucé',
	'FR28242' => 'Méréglise',
	'FR28243' => 'Mérouville',
	'FR28245' => 'Meslay-le-Grenet',
	'FR28246' => 'Meslay-le-Vidame',
	'FR28247' => 'Le Mesnil-Simon',
	'FR28248' => 'Le Mesnil-Thomas',
	'FR28249' => 'Mévoisins',
	'FR28251' => 'Mézières-en-Drouais',
	'FR28252' => 'Miermaigne',
	'FR28253' => 'Mignières',
	'FR28254' => 'Mittainvilliers-Vérigny',
	'FR28255' => 'Moinville-la-Jeulin',
	'FR28256' => 'Moléans',
	'FR28257' => 'Mondonville-Saint-Jean',
	'FR28259' => 'Montboissier',
	'FR28260' => 'Montharville',
	'FR28261' => 'Montigny-le-Chartif',
	'FR28263' => 'Montigny-sur-Avre',
	'FR28264' => 'Montireau',
	'FR28265' => 'Montlandon',
	'FR28267' => 'Montreuil',
	'FR28268' => 'Morainville',
	'FR28269' => 'Morancez',
	'FR28270' => 'Moriers',
	'FR28271' => 'Morvilliers',
	'FR28272' => 'Mottereau',
	'FR28273' => 'Moulhard',
	'FR28274' => 'Moutiers',
	'FR28275' => 'Néron',
	'FR28276' => 'Neuvy-en-Beauce',
	'FR28277' => 'Neuvy-en-Dunois',
	'FR28278' => 'Nogent-le-Phaye',
	'FR28279' => 'Nogent-le-Roi',
	'FR28280' => 'Nogent-le-Rotrou',
	'FR28281' => 'Nogent-sur-Eure',
	'FR28282' => 'Nonvilliers-Grandhoux',
	'FR28283' => 'Nottonville',
	'FR28284' => 'Oinville-Saint-Liphard',
	'FR28285' => 'Oinville-sous-Auneau',
	'FR28286' => 'Ollé',
	'FR28287' => 'Orgères-en-Beauce',
	'FR28289' => 'Ormoy',
	'FR28290' => 'Orrouer',
	'FR28291' => 'Ouarville',
	'FR28292' => 'Ouerre',
	'FR28293' => 'Oulins',
	'FR28294' => 'Oysonville',
	'FR28296' => 'Péronville',
	'FR28298' => 'Pierres',
	'FR28299' => 'Les Pinthières',
	'FR28300' => 'Poinville',
	'FR28301' => 'Poisvilliers',
	'FR28302' => 'Pontgouin',
	'FR28303' => 'Poupry',
	'FR28304' => 'Prasville',
	'FR28305' => 'Pré-Saint-Évroult',
	'FR28306' => 'Pré-Saint-Martin',
	'FR28308' => 'Prudemanche',
	'FR28309' => 'Prunay-le-Gillon',
	'FR28310' => 'La Puisaye',
	'FR28312' => 'Puiseux',
	'FR28313' => 'Réclainville',
	'FR28314' => 'Les Ressuintes',
	'FR28315' => 'Revercourt',
	'FR28316' => 'Rohaire',
	'FR28317' => 'Roinville',
	'FR28319' => 'Rouvray-Saint-Denis',
	'FR28321' => 'Rouvres',
	'FR28322' => 'Rueil-la-Gadelière',
	'FR28323' => 'Saint-Ange-et-Torçay',
	'FR28324' => 'Saint-Arnoult-des-Bois',
	'FR28325' => 'Saint-Aubin-des-Bois',
	'FR28326' => 'Saint-Avit-les-Guespières',
	'FR28327' => 'Saint-Bomer',
	'FR28329' => 'Saint-Christophe',
	'FR28330' => 'Villemaury',
	'FR28331' => 'Saintigny',
	'FR28332' => 'Sainte-Gemme-Moronval',
	'FR28333' => 'Saint-Denis-des-Puits',
	'FR28334' => 'Saint-Denis-Lanneray',
	'FR28335' => 'Saint-Éliph',
	'FR28336' => 'Saint-Éman',
	'FR28337' => 'Saint-Georges-sur-Eure',
	'FR28339' => 'Saint-Germain-le-Gaillard',
	'FR28341' => 'Saint-Jean-de-Rebervilliers',
	'FR28342' => 'Saint-Jean-Pierre-Fixte',
	'FR28343' => 'Saint-Laurent-la-Gâtine',
	'FR28344' => 'Saint-Léger-des-Aubées',
	'FR28346' => 'Saint-Lubin-de-Cravant',
	'FR28347' => 'Saint-Lubin-de-la-Haye',
	'FR28348' => 'Saint-Lubin-des-Joncherets',
	'FR28349' => 'Saint-Lucien',
	'FR28350' => 'Saint-Luperce',
	'FR28351' => 'Saint-Maixme-Hauterive',
	'FR28352' => 'Saint-Martin-de-Nigelles',
	'FR28353' => 'Saint-Maur-sur-le-Loir',
	'FR28354' => 'Saint-Maurice-Saint-Germain',
	'FR28355' => 'Saint-Ouen-Marchefroy',
	'FR28357' => 'Saint-Piat',
	'FR28358' => 'Saint-Prest',
	'FR28359' => 'Saint-Rémy-sur-Avre',
	'FR28360' => 'Saint-Sauveur-Marville',
	'FR28362' => 'Saint-Victor-de-Buthon',
	'FR28363' => 'Sainville',
	'FR28364' => 'Sancheville',
	'FR28365' => 'Sandarville',
	'FR28366' => 'Santeuil',
	'FR28367' => 'Santilly',
	'FR28368' => 'La Saucelle',
	'FR28369' => 'Saulnières',
	'FR28370' => 'Saumeray',
	'FR28371' => 'Saussay',
	'FR28372' => 'Senantes',
	'FR28373' => 'Senonches',
	'FR28374' => 'Serazereux',
	'FR28375' => 'Serville',
	'FR28377' => 'Sorel-Moussel',
	'FR28378' => 'Souancé-au-Perche',
	'FR28379' => 'Soulaires',
	'FR28380' => 'Sours',
	'FR28382' => 'Terminiers',
	'FR28383' => 'Theuville',
	'FR28385' => 'Le Thieulin',
	'FR28386' => 'Thimert-Gâtelles',
	'FR28387' => 'Thiron-Gardais',
	'FR28388' => 'Thivars',
	'FR28389' => 'Thiville',
	'FR28390' => 'Tillay-le-Péneux',
	'FR28391' => 'Toury',
	'FR28392' => 'Trancrainville',
	'FR28393' => 'Tremblay-les-Villages',
	'FR28394' => 'Tréon',
	'FR28395' => 'Trizay-Coutretot-Saint-Serge',
	'FR28396' => 'Trizay-lès-Bonneval',
	'FR28397' => 'Umpeau',
	'FR28398' => 'Unverre',
	'FR28400' => 'Varize',
	'FR28401' => 'Vaupillon',
	'FR28403' => 'Ver-lès-Chartres',
	'FR28404' => 'Vernouillet',
	'FR28405' => 'Vert-en-Drouais',
	'FR28406' => 'Éole-en-Beauce',
	'FR28407' => 'Vichères',
	'FR28408' => 'Vierville',
	'FR28409' => 'Vieuvicq',
	'FR28410' => 'Villampuy',
	'FR28411' => 'Villars',
	'FR28414' => 'Villebon',
	'FR28415' => 'Villemeux-sur-Eure',
	'FR28417' => 'Villiers-le-Morhier',
	'FR28418' => 'Villiers-Saint-Orien',
	'FR28419' => 'Vitray-en-Beauce',
	'FR28421' => 'Voise',
	'FR28422' => 'Les Villages Vovéens',
	'FR28423' => 'Yermenonville',
	'FR28424' => 'Yèvres',
	'FR28425' => 'Ymeray',
	'FR28426' => 'Ymonville',
	'FR29001' => 'Argol',
	'FR29002' => 'Arzano',
	'FR29003' => 'Audierne',
	'FR29004' => 'Bannalec',
	'FR29005' => 'Baye',
	'FR29006' => 'Bénodet',
	'FR29007' => 'Berrien',
	'FR29008' => 'Beuzec-Cap-Sizun',
	'FR29010' => 'Bodilis',
	'FR29011' => 'Bohars',
	'FR29012' => 'Bolazec',
	'FR29013' => 'Botmeur',
	'FR29014' => 'Botsorhel',
	'FR29015' => 'Bourg-Blanc',
	'FR29016' => 'Brasparts',
	'FR29017' => 'Brélès',
	'FR29018' => 'Brennilis',
	'FR29019' => 'Brest',
	'FR29020' => 'Briec',
	'FR29021' => 'Plounéour-Brignogan-plages',
	'FR29022' => 'Camaret-sur-Mer',
	'FR29023' => 'Carantec',
	'FR29024' => 'Carhaix-Plouguer',
	'FR29025' => 'Cast',
	'FR29026' => 'Châteaulin',
	'FR29027' => 'Châteauneuf-du-Faou',
	'FR29028' => 'Cléden-Cap-Sizun',
	'FR29029' => 'Cléden-Poher',
	'FR29030' => 'Cléder',
	'FR29031' => 'Clohars-Carnoët',
	'FR29032' => 'Clohars-Fouesnant',
	'FR29033' => 'Le Cloître-Pleyben',
	'FR29034' => 'Le Cloître-Saint-Thégonnec',
	'FR29035' => 'Coat-Méal',
	'FR29036' => 'Collorec',
	'FR29037' => 'Combrit',
	'FR29038' => 'Commana',
	'FR29039' => 'Concarneau',
	'FR29040' => 'Le Conquet',
	'FR29041' => 'Coray',
	'FR29042' => 'Crozon',
	'FR29043' => 'Daoulas',
	'FR29044' => 'Dinéault',
	'FR29045' => 'Dirinon',
	'FR29046' => 'Douarnenez',
	'FR29047' => 'Le Drennec',
	'FR29048' => 'Edern',
	'FR29049' => 'Elliant',
	'FR29051' => 'Ergué-Gabéric',
	'FR29053' => 'Le Faou',
	'FR29054' => 'La Feuillée',
	'FR29055' => 'Le Folgoët',
	'FR29056' => 'La Forest-Landerneau',
	'FR29057' => 'La Forêt-Fouesnant',
	'FR29058' => 'Fouesnant',
	'FR29059' => 'Garlan',
	'FR29060' => 'Gouesnach',
	'FR29061' => 'Gouesnou',
	'FR29062' => 'Gouézec',
	'FR29063' => 'Goulien',
	'FR29064' => 'Goulven',
	'FR29065' => 'Gourlizon',
	'FR29066' => 'Guengat',
	'FR29067' => 'Guerlesquin',
	'FR29068' => 'Guiclan',
	'FR29069' => 'Guilers',
	'FR29070' => 'Guiler-sur-Goyen',
	'FR29071' => 'Guilligomarch',
	'FR29072' => 'Guilvinec',
	'FR29073' => 'Guimaëc',
	'FR29074' => 'Guimiliau',
	'FR29075' => 'Guipavas',
	'FR29076' => 'Milizac-Guipronvel',
	'FR29077' => 'Guissény',
	'FR29078' => 'Hanvec',
	'FR29079' => 'Henvic',
	'FR29080' => 'Hôpital-Camfrout',
	'FR29081' => 'Huelgoat',
	'FR29082' => 'Île-de-Batz',
	'FR29083' => 'Île-de-Sein',
	'FR29084' => 'Île-Molène',
	'FR29085' => 'Île-Tudy',
	'FR29086' => 'Irvillac',
	'FR29087' => 'Le Juch',
	'FR29089' => 'Kergloff',
	'FR29090' => 'Kerlaz',
	'FR29091' => 'Kerlouan',
	'FR29093' => 'Kernilis',
	'FR29094' => 'Kernouës',
	'FR29095' => 'Kersaint-Plabennec',
	'FR29097' => 'Lampaul-Guimiliau',
	'FR29098' => 'Lampaul-Plouarzel',
	'FR29099' => 'Lampaul-Ploudalmézeau',
	'FR29100' => 'Lanarvily',
	'FR29101' => 'Landéda',
	'FR29102' => 'Landeleau',
	'FR29103' => 'Landerneau',
	'FR29104' => 'Landévennec',
	'FR29105' => 'Landivisiau',
	'FR29106' => 'Landrévarzec',
	'FR29107' => 'Landudal',
	'FR29108' => 'Landudec',
	'FR29109' => 'Landunvez',
	'FR29110' => 'Langolen',
	'FR29111' => 'Lanhouarneau',
	'FR29112' => 'Lanildut',
	'FR29113' => 'Lanmeur',
	'FR29114' => 'Lannéanou',
	'FR29115' => 'Lannédern',
	'FR29116' => 'Lanneuffret',
	'FR29117' => 'Lannilis',
	'FR29119' => 'Lanrivoaré',
	'FR29120' => 'Lanvéoc',
	'FR29122' => 'Laz',
	'FR29123' => 'Lennon',
	'FR29124' => 'Lesneven',
	'FR29125' => 'Leuhan',
	'FR29126' => 'Loc-Brévalaire',
	'FR29128' => 'Loc-Eguiner',
	'FR29130' => 'Locmaria-Plouzané',
	'FR29131' => 'Locmélar',
	'FR29132' => 'Locquénolé',
	'FR29133' => 'Locquirec',
	'FR29134' => 'Locronan',
	'FR29135' => 'Loctudy',
	'FR29136' => 'Locunolé',
	'FR29137' => 'Logonna-Daoulas',
	'FR29139' => 'Lopérec',
	'FR29140' => 'Loperhet',
	'FR29141' => 'Loqueffret',
	'FR29142' => 'Lothey',
	'FR29143' => 'Mahalon',
	'FR29144' => 'La Martyre',
	'FR29145' => 'Confort-Meilars',
	'FR29146' => 'Melgven',
	'FR29147' => 'Mellac',
	'FR29148' => 'Mespaul',
	'FR29150' => 'Moëlan-sur-Mer',
	'FR29151' => 'Morlaix',
	'FR29152' => 'Motreff',
	'FR29153' => 'Névez',
	'FR29155' => 'Ouessant',
	'FR29156' => 'Pencran',
	'FR29158' => 'Penmarch',
	'FR29159' => 'Peumerit',
	'FR29160' => 'Plabennec',
	'FR29161' => 'Pleuven',
	'FR29162' => 'Pleyben',
	'FR29163' => 'Pleyber-Christ',
	'FR29165' => 'Plobannalec-Lesconil',
	'FR29166' => 'Ploéven',
	'FR29167' => 'Plogastel-Saint-Germain',
	'FR29168' => 'Plogoff',
	'FR29169' => 'Plogonnec',
	'FR29170' => 'Plomelin',
	'FR29171' => 'Plomeur',
	'FR29172' => 'Plomodiern',
	'FR29173' => 'Plonéis',
	'FR29174' => 'Plonéour-Lanvern',
	'FR29175' => 'Plonévez-du-Faou',
	'FR29176' => 'Plonévez-Porzay',
	'FR29177' => 'Plouarzel',
	'FR29178' => 'Ploudalmézeau',
	'FR29179' => 'Ploudaniel',
	'FR29180' => 'Ploudiry',
	'FR29181' => 'Plouédern',
	'FR29182' => 'Plouégat-Guérand',
	'FR29183' => 'Plouégat-Moysan',
	'FR29184' => 'Plouénan',
	'FR29185' => 'Plouescat',
	'FR29186' => 'Plouezoch',
	'FR29187' => 'Plougar',
	'FR29188' => 'Plougasnou',
	'FR29189' => 'Plougastel-Daoulas',
	'FR29190' => 'Plougonvelin',
	'FR29191' => 'Plougonven',
	'FR29192' => 'Plougoulm',
	'FR29193' => 'Plougourvest',
	'FR29195' => 'Plouguerneau',
	'FR29196' => 'Plouguin',
	'FR29197' => 'Plouhinec',
	'FR29198' => 'Plouider',
	'FR29199' => 'Plouigneau',
	'FR29201' => 'Ploumoguer',
	'FR29202' => 'Plounéour-Ménez',
	'FR29204' => 'Plounéventer',
	'FR29205' => 'Plounévézel',
	'FR29206' => 'Plounévez-Lochrist',
	'FR29207' => 'Plourin-lès-Morlaix',
	'FR29208' => 'Plourin',
	'FR29209' => 'Plouvien',
	'FR29210' => 'Plouvorn',
	'FR29211' => 'Plouyé',
	'FR29212' => 'Plouzané',
	'FR29213' => 'Plouzévédé',
	'FR29214' => 'Plovan',
	'FR29215' => 'Plozévet',
	'FR29216' => 'Pluguffan',
	'FR29217' => 'Pont-Aven',
	'FR29218' => 'Pont-Croix',
	'FR29220' => 'Pont-lAbbé',
	'FR29221' => 'Porspoder',
	'FR29222' => 'Port-Launay',
	'FR29224' => 'Pouldergat',
	'FR29225' => 'Pouldreuzic',
	'FR29226' => 'Poullan-sur-Mer',
	'FR29227' => 'Poullaouen',
	'FR29228' => 'Primelin',
	'FR29229' => 'Quéménéven',
	'FR29230' => 'Querrien',
	'FR29232' => 'Quimper',
	'FR29233' => 'Quimperlé',
	'FR29234' => 'Rédené',
	'FR29235' => 'Le Relecq-Kerhuon',
	'FR29236' => 'Riec-sur-Bélon',
	'FR29237' => 'La Roche-Maurice',
	'FR29238' => 'Roscanvel',
	'FR29239' => 'Roscoff',
	'FR29240' => 'Rosnoën',
	'FR29241' => 'Rosporden',
	'FR29243' => 'Saint-Coulitz',
	'FR29244' => 'Saint-Derrien',
	'FR29245' => 'Saint-Divy',
	'FR29246' => 'Saint-Eloy',
	'FR29247' => 'Saint-Évarzec',
	'FR29248' => 'Saint-Frégant',
	'FR29249' => 'Saint-Goazec',
	'FR29250' => 'Saint-Hernin',
	'FR29251' => 'Saint-Jean-du-Doigt',
	'FR29252' => 'Saint-Jean-Trolimon',
	'FR29254' => 'Saint-Martin-des-Champs',
	'FR29255' => 'Saint-Méen',
	'FR29256' => 'Saint-Nic',
	'FR29257' => 'Saint-Pabu',
	'FR29259' => 'Saint-Pol-de-Léon',
	'FR29260' => 'Saint-Renan',
	'FR29261' => 'Saint-Rivoal',
	'FR29262' => 'Saint-Sauveur',
	'FR29263' => 'Saint-Ségal',
	'FR29264' => 'Saint-Servais',
	'FR29265' => 'Sainte-Sève',
	'FR29266' => 'Saint-Thégonnec Loc-Eguiner',
	'FR29267' => 'Saint-Thois',
	'FR29268' => 'Saint-Thonan',
	'FR29269' => 'Saint-Thurien',
	'FR29270' => 'Saint-Urbain',
	'FR29271' => 'Saint-Vougay',
	'FR29272' => 'Saint-Yvi',
	'FR29273' => 'Santec',
	'FR29274' => 'Scaër',
	'FR29275' => 'Scrignac',
	'FR29276' => 'Sibiril',
	'FR29277' => 'Sizun',
	'FR29278' => 'Spézet',
	'FR29279' => 'Taulé',
	'FR29280' => 'Telgruc-sur-Mer',
	'FR29281' => 'Tourch',
	'FR29282' => 'Trébabu',
	'FR29284' => 'Treffiagat',
	'FR29285' => 'Tréflaouénan',
	'FR29286' => 'Tréflévénez',
	'FR29287' => 'Tréflez',
	'FR29288' => 'Trégarantec',
	'FR29289' => 'Trégarvan',
	'FR29290' => 'Tréglonou',
	'FR29291' => 'Trégourez',
	'FR29292' => 'Tréguennec',
	'FR29293' => 'Trégunc',
	'FR29294' => 'Le Tréhou',
	'FR29295' => 'Trémaouézan',
	'FR29296' => 'Tréméoc',
	'FR29297' => 'Tréméven',
	'FR29298' => 'Tréogat',
	'FR29299' => 'Tréouergat',
	'FR29300' => 'Le Trévoux',
	'FR29301' => 'Trézilidé',
	'FR29302' => 'Pont-de-Buis-lès-Quimerch',
	'FR2A001' => 'Afa',
	'FR2A004' => 'Ajaccio',
	'FR2A006' => 'Alata',
	'FR2A008' => 'Albitreccia',
	'FR2A011' => 'Altagène',
	'FR2A014' => 'Ambiegna',
	'FR2A017' => 'Appietto',
	'FR2A018' => 'Arbellara',
	'FR2A019' => 'Arbori',
	'FR2A021' => 'Argiusta-Moriccio',
	'FR2A022' => 'Arro',
	'FR2A024' => 'Aullène',
	'FR2A026' => 'Azilone-Ampaza',
	'FR2A027' => 'Azzana',
	'FR2A028' => 'Balogna',
	'FR2A031' => 'Bastelica',
	'FR2A032' => 'Bastelicaccia',
	'FR2A035' => 'Belvédère-Campomoro',
	'FR2A038' => 'Bilia',
	'FR2A040' => 'Bocognano',
	'FR2A041' => 'Bonifacio',
	'FR2A048' => 'Calcatoggio',
	'FR2A056' => 'Campo',
	'FR2A060' => 'Cannelle',
	'FR2A061' => 'Carbini',
	'FR2A062' => 'Carbuccia',
	'FR2A064' => 'Cardo-Torgia',
	'FR2A065' => 'Cargèse',
	'FR2A066' => 'Cargiaca',
	'FR2A070' => 'Casaglione',
	'FR2A071' => 'Casalabriva',
	'FR2A085' => 'Cauro',
	'FR2A089' => 'Ciamannacce',
	'FR2A090' => 'Coggia',
	'FR2A091' => 'Cognocoli-Monticchi',
	'FR2A092' => 'Conca',
	'FR2A094' => 'Corrano',
	'FR2A098' => 'Coti-Chiavari',
	'FR2A099' => 'Cozzano',
	'FR2A100' => 'Cristinacce',
	'FR2A103' => 'Cuttoli-Corticchiato',
	'FR2A104' => 'Eccica-Suarella',
	'FR2A108' => 'Évisa',
	'FR2A114' => 'Figari',
	'FR2A115' => 'Foce',
	'FR2A117' => 'Forciolo',
	'FR2A118' => 'Fozzano',
	'FR2A119' => 'Frasseto',
	'FR2A127' => 'Giuncheto',
	'FR2A128' => 'Granace',
	'FR2A129' => 'Grossa',
	'FR2A130' => 'Grosseto-Prugna',
	'FR2A131' => 'Guagno',
	'FR2A132' => 'Guargualé',
	'FR2A133' => 'Guitera-les-Bains',
	'FR2A139' => 'Lecci',
	'FR2A141' => 'Letia',
	'FR2A142' => 'Levie',
	'FR2A144' => 'Lopigna',
	'FR2A146' => 'Loreto-di-Tallano',
	'FR2A154' => 'Marignana',
	'FR2A158' => 'Mela',
	'FR2A160' => 'Moca-Croce',
	'FR2A163' => 'Monacia-dAullène',
	'FR2A174' => 'Murzo',
	'FR2A181' => 'Ocana',
	'FR2A186' => 'Olivese',
	'FR2A189' => 'Olmeto',
	'FR2A191' => 'Olmiccia',
	'FR2A196' => 'Orto',
	'FR2A197' => 'Osani',
	'FR2A198' => 'Ota',
	'FR2A200' => 'Palneca',
	'FR2A203' => 'Partinello',
	'FR2A204' => 'Pastricciola',
	'FR2A209' => 'Peri',
	'FR2A211' => 'Petreto-Bicchisano',
	'FR2A212' => 'Piana',
	'FR2A215' => 'Pianottoli-Caldarello',
	'FR2A228' => 'Pietrosella',
	'FR2A232' => 'Pila-Canale',
	'FR2A240' => 'Poggiolo',
	'FR2A247' => 'Porto-Vecchio',
	'FR2A249' => 'Propriano',
	'FR2A253' => 'Quasquara',
	'FR2A254' => 'Quenza',
	'FR2A258' => 'Renno',
	'FR2A259' => 'Rezza',
	'FR2A262' => 'Rosazia',
	'FR2A266' => 'Salice',
	'FR2A268' => 'Sampolo',
	'FR2A269' => 'Sari-Solenzara',
	'FR2A270' => 'Sari-dOrcino',
	'FR2A271' => 'Sarrola-Carcopino',
	'FR2A272' => 'Sartène',
	'FR2A276' => 'Serra-di-Ferro',
	'FR2A278' => 'Serra-di-Scopamène',
	'FR2A279' => 'Serriera',
	'FR2A282' => 'Soccia',
	'FR2A284' => 'Sollacaro',
	'FR2A285' => 'Sorbollano',
	'FR2A288' => 'Sotta',
	'FR2A295' => 'SantAndréa-dOrcino',
	'FR2A300' => 'San-Gavino-di-Carbini',
	'FR2A308' => 'Sainte-Lucie-de-Tallano',
	'FR2A310' => 'Santa-Maria-Figaniella',
	'FR2A312' => 'Santa-Maria-Siché',
	'FR2A322' => 'Tasso',
	'FR2A323' => 'Tavaco',
	'FR2A324' => 'Tavera',
	'FR2A326' => 'Tolla',
	'FR2A330' => 'Ucciani',
	'FR2A331' => 'Urbalacone',
	'FR2A336' => 'Valle-di-Mezzana',
	'FR2A345' => 'Vero',
	'FR2A348' => 'Vico',
	'FR2A349' => 'Viggianello',
	'FR2A351' => 'Villanova',
	'FR2A357' => 'Zérubia',
	'FR2A358' => 'Zévaco',
	'FR2A359' => 'Zicavo',
	'FR2A360' => 'Zigliara',
	'FR2A362' => 'Zonza',
	'FR2A363' => 'Zoza',
	'FR2B002' => 'Aghione',
	'FR2B003' => 'Aiti',
	'FR2B005' => 'Alando',
	'FR2B007' => 'Albertacce',
	'FR2B009' => 'Aléria',
	'FR2B010' => 'Algajola',
	'FR2B012' => 'Altiani',
	'FR2B013' => 'Alzi',
	'FR2B015' => 'Ampriani',
	'FR2B016' => 'Antisanti',
	'FR2B020' => 'Aregno',
	'FR2B023' => 'Asco',
	'FR2B025' => 'Avapessa',
	'FR2B029' => 'Barbaggio',
	'FR2B030' => 'Barrettali',
	'FR2B033' => 'Bastia',
	'FR2B034' => 'Belgodère',
	'FR2B036' => 'Bigorno',
	'FR2B037' => 'Biguglia',
	'FR2B039' => 'Bisinchi',
	'FR2B042' => 'Borgo',
	'FR2B043' => 'Brando',
	'FR2B045' => 'Bustanico',
	'FR2B046' => 'Cagnano',
	'FR2B047' => 'Calacuccia',
	'FR2B049' => 'Calenzana',
	'FR2B050' => 'Calvi',
	'FR2B051' => 'Cambia',
	'FR2B052' => 'Campana',
	'FR2B053' => 'Campi',
	'FR2B054' => 'Campile',
	'FR2B055' => 'Campitello',
	'FR2B057' => 'Canale-di-Verde',
	'FR2B058' => 'Canari',
	'FR2B059' => 'Canavaggia',
	'FR2B063' => 'Carcheto-Brustico',
	'FR2B067' => 'Carpineto',
	'FR2B068' => 'Carticasi',
	'FR2B069' => 'Casabianca',
	'FR2B072' => 'Casalta',
	'FR2B073' => 'Casamaccioli',
	'FR2B074' => 'Casanova',
	'FR2B075' => 'Casevecchie',
	'FR2B077' => 'Castellare-di-Casinca',
	'FR2B078' => 'Castellare-di-Mercurio',
	'FR2B079' => 'Castello-di-Rostino',
	'FR2B080' => 'Castifao',
	'FR2B081' => 'Castiglione',
	'FR2B082' => 'Castineta',
	'FR2B083' => 'Castirla',
	'FR2B084' => 'Cateri',
	'FR2B086' => 'Centuri',
	'FR2B087' => 'Cervione',
	'FR2B088' => 'Chiatra',
	'FR2B093' => 'Corbara',
	'FR2B095' => 'Corscia',
	'FR2B096' => 'Corte',
	'FR2B097' => 'Costa',
	'FR2B101' => 'Croce',
	'FR2B102' => 'Crocicchia',
	'FR2B105' => 'Erbajolo',
	'FR2B106' => 'Érone',
	'FR2B107' => 'Ersa',
	'FR2B109' => 'Farinole',
	'FR2B110' => 'Favalello',
	'FR2B111' => 'Felce',
	'FR2B112' => 'Feliceto',
	'FR2B113' => 'Ficaja',
	'FR2B116' => 'Focicchia',
	'FR2B120' => 'Furiani',
	'FR2B121' => 'Galéria',
	'FR2B122' => 'Gavignano',
	'FR2B123' => 'Ghisonaccia',
	'FR2B124' => 'Ghisoni',
	'FR2B125' => 'Giocatojo',
	'FR2B126' => 'Giuncaggio',
	'FR2B134' => 'LÎle-Rousse',
	'FR2B135' => 'Isolaccio-di-Fiumorbo',
	'FR2B136' => 'Lama',
	'FR2B137' => 'Lano',
	'FR2B138' => 'Lavatoggio',
	'FR2B140' => 'Lento',
	'FR2B143' => 'Linguizzetta',
	'FR2B145' => 'Loreto-di-Casinca',
	'FR2B147' => 'Lozzi',
	'FR2B148' => 'Lucciana',
	'FR2B149' => 'Lugo-di-Nazza',
	'FR2B150' => 'Lumio',
	'FR2B152' => 'Luri',
	'FR2B153' => 'Manso',
	'FR2B155' => 'Matra',
	'FR2B156' => 'Mausoléo',
	'FR2B157' => 'Mazzola',
	'FR2B159' => 'Meria',
	'FR2B161' => 'Moïta',
	'FR2B162' => 'Moltifao',
	'FR2B164' => 'Monacia-dOrezza',
	'FR2B165' => 'Moncale',
	'FR2B166' => 'Monte',
	'FR2B167' => 'Montegrosso',
	'FR2B168' => 'Monticello',
	'FR2B169' => 'Morosaglia',
	'FR2B170' => 'Morsiglia',
	'FR2B171' => 'Muracciole',
	'FR2B172' => 'Murato',
	'FR2B173' => 'Muro',
	'FR2B175' => 'Nessa',
	'FR2B176' => 'Nocario',
	'FR2B177' => 'Noceta',
	'FR2B178' => 'Nonza',
	'FR2B179' => 'Novale',
	'FR2B180' => 'Novella',
	'FR2B182' => 'Occhiatana',
	'FR2B183' => 'Ogliastro',
	'FR2B184' => 'Olcani',
	'FR2B185' => 'Oletta',
	'FR2B187' => 'Olmeta-di-Capocorso',
	'FR2B188' => 'Olmeta-di-Tuda',
	'FR2B190' => 'Olmi-Cappella',
	'FR2B192' => 'Olmo',
	'FR2B193' => 'Omessa',
	'FR2B194' => 'Ortale',
	'FR2B195' => 'Ortiporio',
	'FR2B199' => 'Palasca',
	'FR2B201' => 'Pancheraccia',
	'FR2B202' => 'Parata',
	'FR2B205' => 'Patrimonio',
	'FR2B206' => 'Penta-Acquatella',
	'FR2B207' => 'Penta-di-Casinca',
	'FR2B208' => 'Perelli',
	'FR2B210' => 'Pero-Casevecchie',
	'FR2B213' => 'Pianello',
	'FR2B214' => 'Piano',
	'FR2B216' => 'Piazzali',
	'FR2B217' => 'Piazzole',
	'FR2B218' => 'Piedicorte-di-Gaggio',
	'FR2B219' => 'Piedicroce',
	'FR2B220' => 'Piedigriggio',
	'FR2B221' => 'Piedipartino',
	'FR2B222' => 'Pie-dOrezza',
	'FR2B223' => 'Pietralba',
	'FR2B224' => 'Pietracorbara',
	'FR2B225' => 'Pietra-di-Verde',
	'FR2B226' => 'Pietraserena',
	'FR2B227' => 'Pietricaggio',
	'FR2B229' => 'Pietroso',
	'FR2B230' => 'Piève',
	'FR2B231' => 'Pigna',
	'FR2B233' => 'Pino',
	'FR2B234' => 'Piobetta',
	'FR2B235' => 'Pioggiola',
	'FR2B236' => 'Poggio-di-Nazza',
	'FR2B238' => 'Poggio-di-Venaco',
	'FR2B239' => 'Poggio-dOletta',
	'FR2B241' => 'Poggio-Marinaccio',
	'FR2B242' => 'Poggio-Mezzana',
	'FR2B243' => 'Polveroso',
	'FR2B244' => 'Popolasca',
	'FR2B245' => 'Porri',
	'FR2B246' => 'La Porta',
	'FR2B248' => 'Prato-di-Giovellina',
	'FR2B250' => 'Prunelli-di-Casacconi',
	'FR2B251' => 'Prunelli-di-Fiumorbo',
	'FR2B252' => 'Pruno',
	'FR2B255' => 'Quercitello',
	'FR2B256' => 'Rapaggio',
	'FR2B257' => 'Rapale',
	'FR2B260' => 'Riventosa',
	'FR2B261' => 'Rogliano',
	'FR2B263' => 'Rospigliani',
	'FR2B264' => 'Rusio',
	'FR2B265' => 'Rutali',
	'FR2B267' => 'Saliceto',
	'FR2B273' => 'Scata',
	'FR2B274' => 'Scolca',
	'FR2B275' => 'Sermano',
	'FR2B277' => 'Serra-di-Fiumorbo',
	'FR2B280' => 'Silvareccio',
	'FR2B281' => 'Sisco',
	'FR2B283' => 'Solaro',
	'FR2B286' => 'Sorbo-Ocagnano',
	'FR2B287' => 'Sorio',
	'FR2B289' => 'Soveria',
	'FR2B290' => 'Speloncato',
	'FR2B291' => 'Stazzona',
	'FR2B292' => 'SantAndréa-di-Bozio',
	'FR2B293' => 'SantAndréa-di-Cotone',
	'FR2B296' => 'SantAntonino',
	'FR2B297' => 'San-Damiano',
	'FR2B298' => 'Saint-Florent',
	'FR2B299' => 'San-Gavino-dAmpugnani',
	'FR2B301' => 'San-Gavino-di-Tenda',
	'FR2B302' => 'San-Giovanni-di-Moriani',
	'FR2B303' => 'San-Giuliano',
	'FR2B304' => 'San-Lorenzo',
	'FR2B305' => 'San-Martino-di-Lota',
	'FR2B306' => 'Santa-Lucia-di-Mercurio',
	'FR2B307' => 'Santa-Lucia-di-Moriani',
	'FR2B309' => 'Santa-Maria-di-Lota',
	'FR2B311' => 'Santa-Maria-Poggio',
	'FR2B313' => 'San-Nicolao',
	'FR2B314' => 'Santo-Pietro-di-Tenda',
	'FR2B315' => 'Santo-Pietro-di-Venaco',
	'FR2B316' => 'Santa-Reparata-di-Balagna',
	'FR2B317' => 'Santa-Reparata-di-Moriani',
	'FR2B318' => 'Taglio-Isolaccio',
	'FR2B319' => 'Talasani',
	'FR2B320' => 'Tallone',
	'FR2B321' => 'Tarrano',
	'FR2B327' => 'Tomino',
	'FR2B328' => 'Tox',
	'FR2B329' => 'Tralonca',
	'FR2B332' => 'Urtaca',
	'FR2B333' => 'Vallecalle',
	'FR2B334' => 'Valle-dAlesani',
	'FR2B335' => 'Valle-di-Campoloro',
	'FR2B337' => 'Valle-di-Rostino',
	'FR2B338' => 'Valle-dOrezza',
	'FR2B339' => 'Vallica',
	'FR2B340' => 'Velone-Orneto',
	'FR2B341' => 'Venaco',
	'FR2B342' => 'Ventiseri',
	'FR2B343' => 'Venzolasca',
	'FR2B344' => 'Verdèse',
	'FR2B346' => 'Vescovato',
	'FR2B347' => 'Vezzani',
	'FR2B350' => 'Vignale',
	'FR2B352' => 'Ville-di-Paraso',
	'FR2B353' => 'Ville-di-Pietrabugno',
	'FR2B354' => 'Vivario',
	'FR2B355' => 'Volpajola',
	'FR2B356' => 'Zalana',
	'FR2B361' => 'Zilia',
	'FR2B364' => 'Zuani',
	'FR2B365' => 'San-Gavino-di-Fiumorbo',
	'FR2B366' => 'Chisa',
	'FR30001' => 'Aigaliers',
	'FR30002' => 'Aigremont',
	'FR30003' => 'Aigues-Mortes',
	'FR30004' => 'Aigues-Vives',
	'FR30005' => 'Aiguèze',
	'FR30006' => 'Aimargues',
	'FR30007' => 'Alès',
	'FR30008' => 'Allègre-les-Fumades',
	'FR30009' => 'Alzon',
	'FR30010' => 'Anduze',
	'FR30011' => 'Les Angles',
	'FR30012' => 'Aramon',
	'FR30013' => 'Argilliers',
	'FR30014' => 'Arpaillargues-et-Aureillac',
	'FR30015' => 'Arphy',
	'FR30016' => 'Arre',
	'FR30017' => 'Arrigas',
	'FR30018' => 'Aspères',
	'FR30019' => 'Aubais',
	'FR30020' => 'Aubord',
	'FR30021' => 'Aubussargues',
	'FR30022' => 'Aujac',
	'FR30023' => 'Aujargues',
	'FR30024' => 'Aulas',
	'FR30025' => 'Aumessas',
	'FR30026' => 'Avèze',
	'FR30027' => 'Bagard',
	'FR30028' => 'Bagnols-sur-Cèze',
	'FR30029' => 'Barjac',
	'FR30030' => 'Baron',
	'FR30031' => 'La Bastide-dEngras',
	'FR30032' => 'Beaucaire',
	'FR30033' => 'Beauvoisin',
	'FR30034' => 'Bellegarde',
	'FR30035' => 'Belvézet',
	'FR30036' => 'Bernis',
	'FR30037' => 'Bessèges',
	'FR30038' => 'Bez-et-Esparon',
	'FR30039' => 'Bezouce',
	'FR30040' => 'Blandas',
	'FR30041' => 'Blauzac',
	'FR30042' => 'Boisset-et-Gaujac',
	'FR30043' => 'Boissières',
	'FR30044' => 'Bonnevaux',
	'FR30045' => 'Bordezac',
	'FR30046' => 'Boucoiran-et-Nozières',
	'FR30047' => 'Bouillargues',
	'FR30048' => 'Bouquet',
	'FR30049' => 'Bourdic',
	'FR30050' => 'Bragassargues',
	'FR30051' => 'Branoux-les-Taillades',
	'FR30052' => 'Bréau-Mars',
	'FR30053' => 'Brignon',
	'FR30054' => 'Brouzet-lès-Quissac',
	'FR30055' => 'Brouzet-lès-Alès',
	'FR30056' => 'La Bruguière',
	'FR30057' => 'Cabrières',
	'FR30058' => 'La Cadière-et-Cambo',
	'FR30059' => 'Le Cailar',
	'FR30060' => 'Caissargues',
	'FR30061' => 'La Calmette',
	'FR30062' => 'Calvisson',
	'FR30064' => 'Campestre-et-Luc',
	'FR30065' => 'Canaules-et-Argentières',
	'FR30066' => 'Cannes-et-Clairan',
	'FR30067' => 'La Capelle-et-Masmolène',
	'FR30068' => 'Cardet',
	'FR30069' => 'Carnas',
	'FR30070' => 'Carsan',
	'FR30071' => 'Cassagnoles',
	'FR30072' => 'Castelnau-Valence',
	'FR30073' => 'Castillon-du-Gard',
	'FR30074' => 'Causse-Bégon',
	'FR30075' => 'Caveirac',
	'FR30076' => 'Cavillargues',
	'FR30077' => 'Cendras',
	'FR30079' => 'Chambon',
	'FR30080' => 'Chamborigaud',
	'FR30081' => 'Chusclan',
	'FR30082' => 'Clarensac',
	'FR30083' => 'Codognan',
	'FR30084' => 'Codolet',
	'FR30085' => 'Collias',
	'FR30086' => 'Collorgues',
	'FR30087' => 'Colognac',
	'FR30088' => 'Combas',
	'FR30089' => 'Comps',
	'FR30090' => 'Concoules',
	'FR30091' => 'Congénies',
	'FR30092' => 'Connaux',
	'FR30093' => 'Conqueyrac',
	'FR30094' => 'Corbès',
	'FR30095' => 'Corconne',
	'FR30096' => 'Cornillon',
	'FR30097' => 'Courry',
	'FR30098' => 'Crespian',
	'FR30099' => 'Cros',
	'FR30100' => 'Cruviers-Lascours',
	'FR30101' => 'Deaux',
	'FR30102' => 'Dions',
	'FR30103' => 'Domazan',
	'FR30104' => 'Domessargues',
	'FR30105' => 'Dourbies',
	'FR30106' => 'Durfort-et-Saint-Martin-de-Sossenac',
	'FR30107' => 'Estézargues',
	'FR30108' => 'LEstréchure',
	'FR30109' => 'Euzet',
	'FR30110' => 'Flaux',
	'FR30111' => 'Foissac',
	'FR30112' => 'Fons',
	'FR30113' => 'Fons-sur-Lussan',
	'FR30114' => 'Fontanès',
	'FR30115' => 'Fontarèches',
	'FR30116' => 'Fournès',
	'FR30117' => 'Fourques',
	'FR30119' => 'Fressac',
	'FR30120' => 'Gagnières',
	'FR30121' => 'Gailhan',
	'FR30122' => 'Gajan',
	'FR30123' => 'Gallargues-le-Montueux',
	'FR30124' => 'Le Garn',
	'FR30125' => 'Garons',
	'FR30126' => 'Garrigues-Sainte-Eulalie',
	'FR30127' => 'Gaujac',
	'FR30128' => 'Générac',
	'FR30129' => 'Générargues',
	'FR30130' => 'Génolhac',
	'FR30131' => 'Goudargues',
	'FR30132' => 'La Grand-Combe',
	'FR30133' => 'Le Grau-du-Roi',
	'FR30134' => 'Issirac',
	'FR30135' => 'Jonquières-Saint-Vincent',
	'FR30136' => 'Junas',
	'FR30137' => 'Lamelouze',
	'FR30138' => 'Langlade',
	'FR30139' => 'Lanuéjols',
	'FR30140' => 'Lasalle',
	'FR30141' => 'Laudun-lArdoise',
	'FR30142' => 'Laval-Pradel',
	'FR30143' => 'Laval-Saint-Roman',
	'FR30144' => 'Lecques',
	'FR30145' => 'Lédenon',
	'FR30146' => 'Lédignan',
	'FR30147' => 'Lézan',
	'FR30148' => 'Liouc',
	'FR30149' => 'Lirac',
	'FR30150' => 'Logrian-Florian',
	'FR30151' => 'Lussan',
	'FR30152' => 'Les Mages',
	'FR30153' => 'Malons-et-Elze',
	'FR30154' => 'Mandagout',
	'FR30155' => 'Manduel',
	'FR30156' => 'Marguerittes',
	'FR30158' => 'Martignargues',
	'FR30159' => 'Le Martinet',
	'FR30160' => 'Maruéjols-lès-Gardon',
	'FR30161' => 'Massanes',
	'FR30162' => 'Massillargues-Attuech',
	'FR30163' => 'Mauressargues',
	'FR30164' => 'Méjannes-le-Clap',
	'FR30165' => 'Méjannes-lès-Alès',
	'FR30166' => 'Meynes',
	'FR30167' => 'Meyrannes',
	'FR30168' => 'Mialet',
	'FR30169' => 'Milhaud',
	'FR30170' => 'Molières-Cavaillac',
	'FR30171' => 'Molières-sur-Cèze',
	'FR30172' => 'Monoblet',
	'FR30173' => 'Mons',
	'FR30174' => 'Montaren-et-Saint-Médiers',
	'FR30175' => 'Montclus',
	'FR30176' => 'Montdardier',
	'FR30177' => 'Monteils',
	'FR30178' => 'Montfaucon',
	'FR30179' => 'Montfrin',
	'FR30180' => 'Montignargues',
	'FR30181' => 'Montmirat',
	'FR30182' => 'Montpezat',
	'FR30183' => 'Moulézan',
	'FR30184' => 'Moussac',
	'FR30185' => 'Mus',
	'FR30186' => 'Nages-et-Solorgues',
	'FR30187' => 'Navacelles',
	'FR30188' => 'Ners',
	'FR30189' => 'Nîmes',
	'FR30191' => 'Orsan',
	'FR30192' => 'Orthoux-Sérignac-Quilhan',
	'FR30193' => 'Parignargues',
	'FR30194' => 'Peyremale',
	'FR30195' => 'Peyrolles',
	'FR30196' => 'Le Pin',
	'FR30197' => 'Les Plans',
	'FR30198' => 'Les Plantiers',
	'FR30199' => 'Pommiers',
	'FR30200' => 'Pompignan',
	'FR30201' => 'Ponteils-et-Brésis',
	'FR30202' => 'Pont-Saint-Esprit',
	'FR30203' => 'Portes',
	'FR30204' => 'Potelières',
	'FR30205' => 'Pougnadoresse',
	'FR30206' => 'Poulx',
	'FR30207' => 'Pouzilhac',
	'FR30208' => 'Puechredon',
	'FR30209' => 'Pujaut',
	'FR30210' => 'Quissac',
	'FR30211' => 'Redessan',
	'FR30212' => 'Remoulins',
	'FR30213' => 'Revens',
	'FR30214' => 'Ribaute-les-Tavernes',
	'FR30215' => 'Rivières',
	'FR30216' => 'Robiac-Rochessadoule',
	'FR30217' => 'Rochefort-du-Gard',
	'FR30218' => 'Rochegude',
	'FR30219' => 'Rogues',
	'FR30220' => 'Roquedur',
	'FR30221' => 'Roquemaure',
	'FR30222' => 'La Roque-sur-Cèze',
	'FR30223' => 'Rousson',
	'FR30224' => 'La Rouvière',
	'FR30225' => 'Sabran',
	'FR30226' => 'Saint-Alexandre',
	'FR30227' => 'Saint-Ambroix',
	'FR30228' => 'Sainte-Anastasie',
	'FR30229' => 'Saint-André-de-Majencoules',
	'FR30230' => 'Saint-André-de-Roquepertuis',
	'FR30231' => 'Saint-André-de-Valborgne',
	'FR30232' => 'Saint-André-dOlérargues',
	'FR30233' => 'Saint-Bauzély',
	'FR30234' => 'Saint-Bénézet',
	'FR30235' => 'Saint-Bonnet-du-Gard',
	'FR30236' => 'Saint-Bonnet-de-Salendrinque',
	'FR30237' => 'Saint-Brès',
	'FR30238' => 'Saint-Bresson',
	'FR30239' => 'Sainte-Cécile-dAndorge',
	'FR30240' => 'Saint-Césaire-de-Gauzignan',
	'FR30241' => 'Saint-Chaptes',
	'FR30242' => 'Saint-Christol-de-Rodières',
	'FR30243' => 'Saint-Christol-lez-Alès',
	'FR30244' => 'Saint-Clément',
	'FR30245' => 'Saint-Côme-et-Maruéjols',
	'FR30246' => 'Sainte-Croix-de-Caderle',
	'FR30247' => 'Saint-Denis',
	'FR30248' => 'Saint-Dézéry',
	'FR30249' => 'Saint-Dionisy',
	'FR30250' => 'Saint-Étienne-de-lOlm',
	'FR30251' => 'Saint-Étienne-des-Sorts',
	'FR30252' => 'Saint-Félix-de-Pallières',
	'FR30253' => 'Saint-Florent-sur-Auzonnet',
	'FR30254' => 'Saint-Geniès-de-Comolas',
	'FR30255' => 'Saint-Geniès-de-Malgoirès',
	'FR30256' => 'Saint-Gervais',
	'FR30257' => 'Saint-Gervasy',
	'FR30258' => 'Saint-Gilles',
	'FR30259' => 'Saint-Hilaire-de-Brethmas',
	'FR30260' => 'Saint-Hilaire-dOzilhan',
	'FR30261' => 'Saint-Hippolyte-de-Caton',
	'FR30262' => 'Saint-Hippolyte-de-Montaigu',
	'FR30263' => 'Saint-Hippolyte-du-Fort',
	'FR30264' => 'Saint-Jean-de-Ceyrargues',
	'FR30265' => 'Saint-Jean-de-Crieulon',
	'FR30266' => 'Saint-Jean-de-Maruéjols-et-Avéjan',
	'FR30267' => 'Saint-Jean-de-Serres',
	'FR30268' => 'Saint-Jean-de-Valériscle',
	'FR30269' => 'Saint-Jean-du-Gard',
	'FR30270' => 'Saint-Jean-du-Pin',
	'FR30271' => 'Saint-Julien-de-Cassagnas',
	'FR30272' => 'Saint-Julien-de-la-Nef',
	'FR30273' => 'Saint-Julien-de-Peyrolas',
	'FR30274' => 'Saint-Julien-les-Rosiers',
	'FR30275' => 'Saint-Just-et-Vacquières',
	'FR30276' => 'Saint-Laurent-dAigouze',
	'FR30277' => 'Saint-Laurent-de-Carnols',
	'FR30278' => 'Saint-Laurent-des-Arbres',
	'FR30279' => 'Saint-Laurent-la-Vernède',
	'FR30280' => 'Saint-Laurent-le-Minier',
	'FR30281' => 'Saint-Mamert-du-Gard',
	'FR30282' => 'Saint-Marcel-de-Careiret',
	'FR30283' => 'Saint-Martial',
	'FR30284' => 'Saint-Martin-de-Valgalgues',
	'FR30285' => 'Saint-Maurice-de-Cazevieille',
	'FR30286' => 'Saint-Maximin',
	'FR30287' => 'Saint-Michel-dEuzet',
	'FR30288' => 'Saint-Nazaire',
	'FR30289' => 'Saint-Nazaire-des-Gardies',
	'FR30290' => 'Saint-Paulet-de-Caisson',
	'FR30291' => 'Saint-Paul-la-Coste',
	'FR30292' => 'Saint-Pons-la-Calm',
	'FR30293' => 'Saint-Privat-de-Champclos',
	'FR30294' => 'Saint-Privat-des-Vieux',
	'FR30295' => 'Saint-Quentin-la-Poterie',
	'FR30296' => 'Saint-Roman-de-Codières',
	'FR30297' => 'Saint-Sauveur-Camprieu',
	'FR30298' => 'Saint-Sébastien-dAigrefeuille',
	'FR30299' => 'Saint-Siffret',
	'FR30300' => 'Saint-Théodorit',
	'FR30301' => 'Saint-Victor-des-Oules',
	'FR30302' => 'Saint-Victor-la-Coste',
	'FR30303' => 'Saint-Victor-de-Malcap',
	'FR30304' => 'Salazac',
	'FR30305' => 'Salindres',
	'FR30306' => 'Salinelles',
	'FR30307' => 'Les Salles-du-Gardon',
	'FR30308' => 'Sanilhac-Sagriès',
	'FR30309' => 'Sardan',
	'FR30310' => 'Saumane',
	'FR30311' => 'Sauve',
	'FR30312' => 'Sauveterre',
	'FR30313' => 'Sauzet',
	'FR30314' => 'Savignargues',
	'FR30315' => 'Saze',
	'FR30316' => 'Sénéchas',
	'FR30317' => 'Sernhac',
	'FR30318' => 'Servas',
	'FR30319' => 'Serviers-et-Labaume',
	'FR30320' => 'Seynes',
	'FR30321' => 'Sommières',
	'FR30322' => 'Soudorgues',
	'FR30323' => 'Soustelle',
	'FR30324' => 'Souvignargues',
	'FR30325' => 'Sumène',
	'FR30326' => 'Tavel',
	'FR30327' => 'Tharaux',
	'FR30328' => 'Théziers',
	'FR30329' => 'Thoiras',
	'FR30330' => 'Tornac',
	'FR30331' => 'Tresques',
	'FR30332' => 'Trèves',
	'FR30333' => 'Uchaud',
	'FR30334' => 'Uzès',
	'FR30335' => 'Vabres',
	'FR30336' => 'Vallabrègues',
	'FR30337' => 'Vallabrix',
	'FR30338' => 'Vallérargues',
	'FR30339' => 'Val-dAigoual',
	'FR30340' => 'Valliguières',
	'FR30341' => 'Vauvert',
	'FR30342' => 'Vénéjan',
	'FR30343' => 'Verfeuil',
	'FR30344' => 'Vergèze',
	'FR30345' => 'La Vernarède',
	'FR30346' => 'Vers-Pont-du-Gard',
	'FR30347' => 'Vestric-et-Candiac',
	'FR30348' => 'Vézénobres',
	'FR30349' => 'Vic-le-Fesq',
	'FR30350' => 'Le Vigan',
	'FR30351' => 'Villeneuve-lès-Avignon',
	'FR30352' => 'Villevieille',
	'FR30353' => 'Vissec',
	'FR30354' => 'Montagnac',
	'FR30355' => 'Saint-Paul-les-Fonts',
	'FR30356' => 'Rodilhan',
	'FR31001' => 'Agassac',
	'FR31002' => 'Aignes',
	'FR31003' => 'Aigrefeuille',
	'FR31004' => 'Ayguesvives',
	'FR31005' => 'Alan',
	'FR31006' => 'Albiac',
	'FR31007' => 'Ambax',
	'FR31008' => 'Anan',
	'FR31009' => 'Antichan-de-Frontignes',
	'FR31010' => 'Antignac',
	'FR31011' => 'Arbas',
	'FR31012' => 'Arbon',
	'FR31013' => 'Ardiège',
	'FR31014' => 'Arguenos',
	'FR31015' => 'Argut-Dessous',
	'FR31017' => 'Arlos',
	'FR31018' => 'Arnaud-Guilhem',
	'FR31019' => 'Artigue',
	'FR31020' => 'Aspet',
	'FR31021' => 'Aspret-Sarrat',
	'FR31022' => 'Aucamville',
	'FR31023' => 'Aulon',
	'FR31024' => 'Auragne',
	'FR31025' => 'Aureville',
	'FR31026' => 'Auriac-sur-Vendinelle',
	'FR31027' => 'Auribail',
	'FR31028' => 'Aurignac',
	'FR31029' => 'Aurin',
	'FR31030' => 'Ausseing',
	'FR31031' => 'Ausson',
	'FR31032' => 'Aussonne',
	'FR31033' => 'Auterive',
	'FR31034' => 'Auzas',
	'FR31035' => 'Auzeville-Tolosane',
	'FR31036' => 'Auzielle',
	'FR31037' => 'Avignonet-Lauragais',
	'FR31038' => 'Azas',
	'FR31039' => 'Bachas',
	'FR31040' => 'Bachos',
	'FR31041' => 'Bagiry',
	'FR31042' => 'Bagnères-de-Luchon',
	'FR31043' => 'Balesta',
	'FR31044' => 'Balma',
	'FR31045' => 'Barbazan',
	'FR31046' => 'Baren',
	'FR31047' => 'Bax',
	'FR31048' => 'Baziège',
	'FR31049' => 'Bazus',
	'FR31050' => 'Beauchalot',
	'FR31051' => 'Beaufort',
	'FR31052' => 'Beaumont-sur-Lèze',
	'FR31053' => 'Beaupuy',
	'FR31054' => 'Beauteville',
	'FR31055' => 'Beauville',
	'FR31056' => 'Beauzelle',
	'FR31057' => 'Belberaud',
	'FR31058' => 'Belbèze-de-Lauragais',
	'FR31059' => 'Belbèze-en-Comminges',
	'FR31060' => 'Bélesta-en-Lauragais',
	'FR31061' => 'Bellegarde-Sainte-Marie',
	'FR31062' => 'Bellesserre',
	'FR31063' => 'Benque',
	'FR31064' => 'Benque-Dessous-et-Dessus',
	'FR31065' => 'Bérat',
	'FR31066' => 'Bessières',
	'FR31067' => 'Bezins-Garraux',
	'FR31068' => 'Billière',
	'FR31069' => 'Blagnac',
	'FR31070' => 'Blajan',
	'FR31071' => 'Bois-de-la-Pierre',
	'FR31072' => 'Boissède',
	'FR31073' => 'Bondigoux',
	'FR31074' => 'Bonrepos-Riquet',
	'FR31075' => 'Bonrepos-sur-Aussonnelle',
	'FR31076' => 'Bordes-de-Rivière',
	'FR31077' => 'Le Born',
	'FR31078' => 'Boudrac',
	'FR31079' => 'Bouloc',
	'FR31080' => 'Boulogne-sur-Gesse',
	'FR31081' => 'Bourg-dOueil',
	'FR31082' => 'Bourg-Saint-Bernard',
	'FR31083' => 'Boussan',
	'FR31084' => 'Boussens',
	'FR31085' => 'Boutx',
	'FR31086' => 'Bouzin',
	'FR31087' => 'Bragayrac',
	'FR31088' => 'Brax',
	'FR31089' => 'Bretx',
	'FR31090' => 'Brignemont',
	'FR31091' => 'Bruguières',
	'FR31092' => 'Burgalays',
	'FR31093' => 'Le Burgaud',
	'FR31094' => 'Buzet-sur-Tarn',
	'FR31095' => 'Cabanac-Cazaux',
	'FR31096' => 'Cabanac-Séguenville',
	'FR31097' => 'Le Cabanial',
	'FR31098' => 'Cadours',
	'FR31099' => 'Caignac',
	'FR31100' => 'Calmont',
	'FR31101' => 'Cambernard',
	'FR31102' => 'Cambiac',
	'FR31103' => 'Canens',
	'FR31104' => 'Capens',
	'FR31105' => 'Caragoudes',
	'FR31106' => 'Caraman',
	'FR31107' => 'Carbonne',
	'FR31108' => 'Cardeilhac',
	'FR31109' => 'Cassagnabère-Tournas',
	'FR31110' => 'Cassagne',
	'FR31111' => 'Castagnac',
	'FR31112' => 'Castagnède',
	'FR31113' => 'Castanet-Tolosan',
	'FR31114' => 'Castelbiague',
	'FR31115' => 'Castelgaillard',
	'FR31116' => 'Castelginest',
	'FR31117' => 'Castelmaurou',
	'FR31118' => 'Castelnau-dEstrétefonds',
	'FR31119' => 'Castelnau-Picampeau',
	'FR31120' => 'Le Castéra',
	'FR31121' => 'Castéra-Vignoles',
	'FR31122' => 'Casties-Labrande',
	'FR31123' => 'Castillon-de-Larboust',
	'FR31124' => 'Castillon-de-Saint-Martory',
	'FR31125' => 'Cathervielle',
	'FR31126' => 'Caubiac',
	'FR31127' => 'Caubous',
	'FR31128' => 'Caujac',
	'FR31129' => 'Cazarilh-Laspènes',
	'FR31130' => 'Cazaril-Tambourès',
	'FR31131' => 'Cazaunous',
	'FR31132' => 'Cazaux-Layrisse',
	'FR31133' => 'Cazeaux-de-Larboust',
	'FR31134' => 'Cazeneuve-Montaut',
	'FR31135' => 'Cazères',
	'FR31136' => 'Cépet',
	'FR31137' => 'Cessales',
	'FR31138' => 'Charlas',
	'FR31139' => 'Chaum',
	'FR31140' => 'Chein-Dessus',
	'FR31141' => 'Ciadoux',
	'FR31142' => 'Cier-de-Luchon',
	'FR31143' => 'Cier-de-Rivière',
	'FR31144' => 'Cierp-Gaud',
	'FR31145' => 'Cintegabelle',
	'FR31146' => 'Cirès',
	'FR31147' => 'Clarac',
	'FR31148' => 'Clermont-le-Fort',
	'FR31149' => 'Colomiers',
	'FR31150' => 'Cornebarrieu',
	'FR31151' => 'Corronsac',
	'FR31152' => 'Coueilles',
	'FR31153' => 'Couladère',
	'FR31155' => 'Couret',
	'FR31156' => 'Cox',
	'FR31157' => 'Cugnaux',
	'FR31158' => 'Cuguron',
	'FR31159' => 'Le Cuing',
	'FR31160' => 'Daux',
	'FR31161' => 'Deyme',
	'FR31162' => 'Donneville',
	'FR31163' => 'Drémil-Lafage',
	'FR31164' => 'Drudas',
	'FR31165' => 'Eaunes',
	'FR31166' => 'Empeaux',
	'FR31167' => 'Encausse-les-Thermes',
	'FR31168' => 'Eoux',
	'FR31169' => 'Escalquens',
	'FR31170' => 'Escanecrabe',
	'FR31171' => 'Espanès',
	'FR31172' => 'Esparron',
	'FR31173' => 'Esperce',
	'FR31174' => 'Estadens',
	'FR31175' => 'Estancarbon',
	'FR31176' => 'Esténos',
	'FR31177' => 'Eup',
	'FR31178' => 'Fabas',
	'FR31179' => 'Le Faget',
	'FR31180' => 'Falga',
	'FR31181' => 'Le Fauga',
	'FR31182' => 'Fenouillet',
	'FR31183' => 'Figarol',
	'FR31184' => 'Flourens',
	'FR31185' => 'Folcarde',
	'FR31186' => 'Fonbeauzard',
	'FR31187' => 'Fonsorbes',
	'FR31188' => 'Fontenilles',
	'FR31189' => 'Forgues',
	'FR31190' => 'Fos',
	'FR31191' => 'Fougaron',
	'FR31192' => 'Fourquevaux',
	'FR31193' => 'Le Fousseret',
	'FR31194' => 'Francarville',
	'FR31195' => 'Francazal',
	'FR31196' => 'Francon',
	'FR31197' => 'Franquevielle',
	'FR31198' => 'Le Fréchet',
	'FR31199' => 'Fronsac',
	'FR31200' => 'Frontignan-de-Comminges',
	'FR31201' => 'Frontignan-Savès',
	'FR31202' => 'Fronton',
	'FR31203' => 'Frouzins',
	'FR31204' => 'Fustignac',
	'FR31205' => 'Gagnac-sur-Garonne',
	'FR31206' => 'Gaillac-Toulza',
	'FR31207' => 'Galié',
	'FR31208' => 'Ganties',
	'FR31209' => 'Garac',
	'FR31210' => 'Gardouch',
	'FR31211' => 'Gargas',
	'FR31212' => 'Garidech',
	'FR31213' => 'Garin',
	'FR31215' => 'Gauré',
	'FR31216' => 'Gémil',
	'FR31217' => 'Génos',
	'FR31218' => 'Gensac-de-Boulogne',
	'FR31219' => 'Gensac-sur-Garonne',
	'FR31220' => 'Gibel',
	'FR31221' => 'Gouaux-de-Larboust',
	'FR31222' => 'Gouaux-de-Luchon',
	'FR31223' => 'Goudex',
	'FR31224' => 'Gourdan-Polignan',
	'FR31225' => 'Goutevernisse',
	'FR31226' => 'Gouzens',
	'FR31227' => 'Goyrans',
	'FR31228' => 'Gragnague',
	'FR31229' => 'Gratens',
	'FR31230' => 'Gratentour',
	'FR31231' => 'Grazac',
	'FR31232' => 'Grenade',
	'FR31233' => 'Grépiac',
	'FR31234' => 'Le Grès',
	'FR31235' => 'Guran',
	'FR31236' => 'Herran',
	'FR31237' => 'His',
	'FR31238' => 'Huos',
	'FR31239' => 'LIsle-en-Dodon',
	'FR31240' => 'Issus',
	'FR31241' => 'Izaut-de-lHôtel',
	'FR31242' => 'Jurvielle',
	'FR31243' => 'Juzes',
	'FR31244' => 'Juzet-de-Luchon',
	'FR31245' => 'Juzet-dIzaut',
	'FR31246' => 'Labarthe-Inard',
	'FR31247' => 'Labarthe-Rivière',
	'FR31248' => 'Labarthe-sur-Lèze',
	'FR31249' => 'Labastide-Beauvoir',
	'FR31250' => 'Labastide-Clermont',
	'FR31251' => 'Labastide-Paumès',
	'FR31252' => 'Labastide-Saint-Sernin',
	'FR31253' => 'Labastidette',
	'FR31254' => 'Labège',
	'FR31255' => 'Labroquère',
	'FR31256' => 'Labruyère-Dorsa',
	'FR31258' => 'Lacaugne',
	'FR31259' => 'Lacroix-Falgarde',
	'FR31260' => 'Laffite-Toupière',
	'FR31261' => 'Lafitte-Vigordane',
	'FR31262' => 'Lagarde',
	'FR31263' => 'Lagardelle-sur-Lèze',
	'FR31264' => 'Lagrâce-Dieu',
	'FR31265' => 'Lagraulet-Saint-Nicolas',
	'FR31266' => 'Lahage',
	'FR31267' => 'Lahitère',
	'FR31268' => 'Lalouret-Laffiteau',
	'FR31269' => 'Lamasquère',
	'FR31270' => 'Landorthe',
	'FR31271' => 'Lanta',
	'FR31272' => 'Lapeyrère',
	'FR31273' => 'Lapeyrouse-Fossat',
	'FR31274' => 'Larcan',
	'FR31275' => 'Laréole',
	'FR31276' => 'Larroque',
	'FR31277' => 'Lasserre-Pradère',
	'FR31278' => 'Latoue',
	'FR31279' => 'Latour',
	'FR31280' => 'Latrape',
	'FR31281' => 'Launac',
	'FR31282' => 'Launaguet',
	'FR31283' => 'Lautignac',
	'FR31284' => 'Lauzerville',
	'FR31285' => 'Lavalette',
	'FR31286' => 'Lavelanet-de-Comminges',
	'FR31287' => 'Lavernose-Lacasse',
	'FR31288' => 'Layrac-sur-Tarn',
	'FR31289' => 'Lécussan',
	'FR31290' => 'Lège',
	'FR31291' => 'Léguevin',
	'FR31292' => 'Lescuns',
	'FR31293' => 'Lespinasse',
	'FR31294' => 'Lespiteau',
	'FR31295' => 'Lespugue',
	'FR31296' => 'Lestelle-de-Saint-Martory',
	'FR31297' => 'Lévignac',
	'FR31299' => 'Lherm',
	'FR31300' => 'Lieoux',
	'FR31301' => 'Lilhac',
	'FR31302' => 'Lodes',
	'FR31303' => 'Longages',
	'FR31304' => 'Loubens-Lauragais',
	'FR31305' => 'Loudet',
	'FR31306' => 'Lourde',
	'FR31308' => 'Luscan',
	'FR31309' => 'Lussan-Adeilhac',
	'FR31310' => 'Lux',
	'FR31311' => 'La Magdelaine-sur-Tarn',
	'FR31312' => 'Mailholas',
	'FR31313' => 'Malvezie',
	'FR31314' => 'Mancioux',
	'FR31315' => 'Mane',
	'FR31316' => 'Marignac',
	'FR31317' => 'Marignac-Lasclares',
	'FR31318' => 'Marignac-Laspeyres',
	'FR31319' => 'Marliac',
	'FR31320' => 'Marquefave',
	'FR31321' => 'Marsoulas',
	'FR31322' => 'Martisserre',
	'FR31323' => 'Martres-de-Rivière',
	'FR31324' => 'Martres-Tolosane',
	'FR31325' => 'Mascarville',
	'FR31326' => 'Massabrac',
	'FR31327' => 'Mauran',
	'FR31328' => 'Mauremont',
	'FR31329' => 'Maurens',
	'FR31330' => 'Mauressac',
	'FR31331' => 'Maureville',
	'FR31332' => 'Mauvaisin',
	'FR31333' => 'Mauvezin',
	'FR31334' => 'Mauzac',
	'FR31335' => 'Mayrègne',
	'FR31336' => 'Mazères-sur-Salat',
	'FR31337' => 'Melles',
	'FR31338' => 'Menville',
	'FR31339' => 'Mérenvielle',
	'FR31340' => 'Mervilla',
	'FR31341' => 'Merville',
	'FR31342' => 'Milhas',
	'FR31343' => 'Mirambeau',
	'FR31344' => 'Miramont-de-Comminges',
	'FR31345' => 'Miremont',
	'FR31346' => 'Mirepoix-sur-Tarn',
	'FR31347' => 'Molas',
	'FR31348' => 'Moncaup',
	'FR31349' => 'Mondavezan',
	'FR31350' => 'Mondilhan',
	'FR31351' => 'Mondonville',
	'FR31352' => 'Mondouzil',
	'FR31353' => 'Monès',
	'FR31354' => 'Monestrol',
	'FR31355' => 'Mons',
	'FR31356' => 'Montaigut-sur-Save',
	'FR31357' => 'Montastruc-de-Salies',
	'FR31358' => 'Montastruc-la-Conseillère',
	'FR31359' => 'Montastruc-Savès',
	'FR31360' => 'Montauban-de-Luchon',
	'FR31361' => 'Montaut',
	'FR31362' => 'Montberaud',
	'FR31363' => 'Montbernard',
	'FR31364' => 'Montberon',
	'FR31365' => 'Montbrun-Bocage',
	'FR31366' => 'Montbrun-Lauragais',
	'FR31367' => 'Montclar-de-Comminges',
	'FR31368' => 'Montclar-Lauragais',
	'FR31369' => 'Mont-de-Galié',
	'FR31370' => 'Montégut-Bourjac',
	'FR31371' => 'Montégut-Lauragais',
	'FR31372' => 'Montespan',
	'FR31373' => 'Montesquieu-Guittaut',
	'FR31374' => 'Montesquieu-Lauragais',
	'FR31375' => 'Montesquieu-Volvestre',
	'FR31376' => 'Montgaillard-de-Salies',
	'FR31377' => 'Montgaillard-Lauragais',
	'FR31378' => 'Montgaillard-sur-Save',
	'FR31379' => 'Montgazin',
	'FR31380' => 'Montgeard',
	'FR31381' => 'Montgiscard',
	'FR31382' => 'Montgras',
	'FR31383' => 'Montjoire',
	'FR31384' => 'Montlaur',
	'FR31385' => 'Montmaurin',
	'FR31386' => 'Montoulieu-Saint-Bernard',
	'FR31387' => 'Montoussin',
	'FR31388' => 'Montpitol',
	'FR31389' => 'Montrabé',
	'FR31390' => 'Montréjeau',
	'FR31391' => 'Montsaunès',
	'FR31392' => 'Mourvilles-Basses',
	'FR31393' => 'Mourvilles-Hautes',
	'FR31394' => 'Moustajon',
	'FR31395' => 'Muret',
	'FR31396' => 'Nailloux',
	'FR31397' => 'Nénigan',
	'FR31398' => 'Nizan-Gesse',
	'FR31399' => 'Noé',
	'FR31400' => 'Nogaret',
	'FR31401' => 'Noueilles',
	'FR31402' => 'Odars',
	'FR31403' => 'Ondes',
	'FR31404' => 'Oô',
	'FR31405' => 'Ore',
	'FR31406' => 'Palaminy',
	'FR31407' => 'Paulhac',
	'FR31408' => 'Payssous',
	'FR31409' => 'Péchabou',
	'FR31410' => 'Pechbonnieu',
	'FR31411' => 'Pechbusque',
	'FR31412' => 'Péguilhan',
	'FR31413' => 'Pelleport',
	'FR31414' => 'Peyrissas',
	'FR31415' => 'Peyrouzet',
	'FR31416' => 'Peyssies',
	'FR31417' => 'Pibrac',
	'FR31418' => 'Pin-Balma',
	'FR31419' => 'Le Pin-Murelet',
	'FR31420' => 'Pinsaguel',
	'FR31421' => 'Pins-Justaret',
	'FR31422' => 'Plagne',
	'FR31423' => 'Plagnole',
	'FR31424' => 'Plaisance-du-Touch',
	'FR31425' => 'Le Plan',
	'FR31426' => 'Pointis-de-Rivière',
	'FR31427' => 'Pointis-Inard',
	'FR31428' => 'Polastron',
	'FR31429' => 'Pompertuzat',
	'FR31430' => 'Ponlat-Taillebourg',
	'FR31431' => 'Portet-dAspet',
	'FR31432' => 'Portet-de-Luchon',
	'FR31433' => 'Portet-sur-Garonne',
	'FR31434' => 'Poubeau',
	'FR31435' => 'Poucharramet',
	'FR31436' => 'Pouy-de-Touges',
	'FR31437' => 'Pouze',
	'FR31439' => 'Préserville',
	'FR31440' => 'Proupiary',
	'FR31441' => 'Prunet',
	'FR31442' => 'Puydaniel',
	'FR31443' => 'Puymaurin',
	'FR31444' => 'Puysségur',
	'FR31445' => 'Quint-Fonsegrives',
	'FR31446' => 'Ramonville-Saint-Agne',
	'FR31447' => 'Razecueillé',
	'FR31448' => 'Rebigue',
	'FR31449' => 'Régades',
	'FR31450' => 'Renneville',
	'FR31451' => 'Revel',
	'FR31452' => 'Rieucazé',
	'FR31453' => 'Rieumajou',
	'FR31454' => 'Rieumes',
	'FR31455' => 'Rieux-Volvestre',
	'FR31456' => 'Riolas',
	'FR31457' => 'Roquefort-sur-Garonne',
	'FR31458' => 'Roques',
	'FR31459' => 'Roquesérière',
	'FR31460' => 'Roquettes',
	'FR31461' => 'Rouède',
	'FR31462' => 'Rouffiac-Tolosan',
	'FR31463' => 'Roumens',
	'FR31464' => 'Sabonnères',
	'FR31465' => 'Saccourvielle',
	'FR31466' => 'Saiguède',
	'FR31467' => 'Saint-Alban',
	'FR31468' => 'Saint-André',
	'FR31469' => 'Saint-Araille',
	'FR31470' => 'Saint-Aventin',
	'FR31471' => 'Saint-Béat-Lez',
	'FR31472' => 'Saint-Bertrand-de-Comminges',
	'FR31473' => 'Saint-Cézert',
	'FR31474' => 'Saint-Christaud',
	'FR31475' => 'Saint-Clar-de-Rivière',
	'FR31476' => 'Saint-Élix-le-Château',
	'FR31477' => 'Saint-Élix-Séglan',
	'FR31478' => 'Saint-Félix-Lauragais',
	'FR31479' => 'Saint-Ferréol-de-Comminges',
	'FR31480' => 'Sainte-Foy-dAigrefeuille',
	'FR31481' => 'Sainte-Foy-de-Peyrolières',
	'FR31482' => 'Saint-Frajou',
	'FR31483' => 'Saint-Gaudens',
	'FR31484' => 'Saint-Geniès-Bellevue',
	'FR31485' => 'Saint-Germier',
	'FR31486' => 'Saint-Hilaire',
	'FR31487' => 'Saint-Ignan',
	'FR31488' => 'Saint-Jean',
	'FR31489' => 'Saint-Jean-Lherm',
	'FR31490' => 'Saint-Jory',
	'FR31491' => 'Saint-Julia',
	'FR31492' => 'Saint-Julien-sur-Garonne',
	'FR31493' => 'Saint-Lary-Boujean',
	'FR31494' => 'Saint-Laurent',
	'FR31495' => 'Saint-Léon',
	'FR31496' => 'Sainte-Livrade',
	'FR31497' => 'Saint-Loup-Cammas',
	'FR31498' => 'Saint-Loup-en-Comminges',
	'FR31499' => 'Saint-Lys',
	'FR31500' => 'Saint-Mamet',
	'FR31501' => 'Saint-Marcel-Paulel',
	'FR31502' => 'Saint-Marcet',
	'FR31503' => 'Saint-Martory',
	'FR31504' => 'Saint-Médard',
	'FR31505' => 'Saint-Michel',
	'FR31506' => 'Saint-Orens-de-Gameville',
	'FR31507' => 'Saint-Paul-sur-Save',
	'FR31508' => 'Saint-Paul-dOueil',
	'FR31509' => 'Saint-Pé-dArdet',
	'FR31510' => 'Saint-Pé-Delbosc',
	'FR31511' => 'Saint-Pierre',
	'FR31512' => 'Saint-Pierre-de-Lages',
	'FR31513' => 'Saint-Plancard',
	'FR31514' => 'Saint-Rome',
	'FR31515' => 'Saint-Rustice',
	'FR31516' => 'Saint-Sauveur',
	'FR31517' => 'Saint-Sulpice-sur-Lèze',
	'FR31518' => 'Saint-Thomas',
	'FR31519' => 'Saint-Vincent',
	'FR31520' => 'Sajas',
	'FR31521' => 'Saleich',
	'FR31522' => 'Salerm',
	'FR31523' => 'Salies-du-Salat',
	'FR31524' => 'Salles-et-Pratviel',
	'FR31525' => 'Salles-sur-Garonne',
	'FR31526' => 'La Salvetat-Saint-Gilles',
	'FR31527' => 'La Salvetat-Lauragais',
	'FR31528' => 'Saman',
	'FR31529' => 'Samouillan',
	'FR31530' => 'Sana',
	'FR31531' => 'Sarrecave',
	'FR31532' => 'Sarremezan',
	'FR31533' => 'Saubens',
	'FR31534' => 'Saussens',
	'FR31535' => 'Sauveterre-de-Comminges',
	'FR31536' => 'Saux-et-Pomarède',
	'FR31537' => 'Savarthès',
	'FR31538' => 'Savères',
	'FR31539' => 'Sédeilhac',
	'FR31540' => 'Ségreville',
	'FR31541' => 'Seilh',
	'FR31542' => 'Seilhan',
	'FR31543' => 'Sénarens',
	'FR31544' => 'Sengouagnet',
	'FR31545' => 'Sepx',
	'FR31546' => 'Seyre',
	'FR31547' => 'Seysses',
	'FR31548' => 'Signac',
	'FR31549' => 'Sode',
	'FR31550' => 'Soueich',
	'FR31551' => 'Tarabel',
	'FR31552' => 'Terrebasse',
	'FR31553' => 'Thil',
	'FR31554' => 'Touille',
	'FR31555' => 'Toulouse',
	'FR31556' => 'Les Tourreilles',
	'FR31557' => 'Tournefeuille',
	'FR31558' => 'Toutens',
	'FR31559' => 'Trébons-de-Luchon',
	'FR31560' => 'Trébons-sur-la-Grasse',
	'FR31561' => 'LUnion',
	'FR31562' => 'Urau',
	'FR31563' => 'Vacquiers',
	'FR31564' => 'Valcabrère',
	'FR31565' => 'Valentine',
	'FR31566' => 'Vallègue',
	'FR31567' => 'Vallesvilles',
	'FR31568' => 'Varennes',
	'FR31569' => 'Vaudreuille',
	'FR31570' => 'Vaux',
	'FR31571' => 'Vendine',
	'FR31572' => 'Venerque',
	'FR31573' => 'Verfeil',
	'FR31574' => 'Vernet',
	'FR31575' => 'Vieille-Toulouse',
	'FR31576' => 'Vieillevigne',
	'FR31577' => 'Vignaux',
	'FR31578' => 'Vigoulet-Auzil',
	'FR31579' => 'Villariès',
	'FR31580' => 'Villate',
	'FR31581' => 'Villaudric',
	'FR31582' => 'Villefranche-de-Lauragais',
	'FR31583' => 'Villematier',
	'FR31584' => 'Villemur-sur-Tarn',
	'FR31585' => 'Villeneuve-de-Rivière',
	'FR31586' => 'Villeneuve-Lécussan',
	'FR31587' => 'Villeneuve-lès-Bouloc',
	'FR31588' => 'Villeneuve-Tolosane',
	'FR31589' => 'Villenouvelle',
	'FR31590' => 'Binos',
	'FR31591' => 'Escoulis',
	'FR31592' => 'Larra',
	'FR31593' => 'Cazac',
	'FR32001' => 'Aignan',
	'FR32002' => 'Ansan',
	'FR32003' => 'Antras',
	'FR32004' => 'Arblade-le-Bas',
	'FR32005' => 'Arblade-le-Haut',
	'FR32007' => 'Ardizas',
	'FR32008' => 'Armentieux',
	'FR32009' => 'Armous-et-Cau',
	'FR32010' => 'Arrouède',
	'FR32012' => 'Aubiet',
	'FR32013' => 'Auch',
	'FR32014' => 'Augnax',
	'FR32015' => 'Aujan-Mournède',
	'FR32016' => 'Auradé',
	'FR32017' => 'Aurensan',
	'FR32018' => 'Aurimont',
	'FR32019' => 'Auterive',
	'FR32020' => 'Aux-Aussat',
	'FR32021' => 'Avensac',
	'FR32022' => 'Avéron-Bergelle',
	'FR32023' => 'Avezan',
	'FR32024' => 'Ayguetinte',
	'FR32025' => 'Ayzieu',
	'FR32026' => 'Bajonnette',
	'FR32027' => 'Barcelonne-du-Gers',
	'FR32028' => 'Barcugnan',
	'FR32029' => 'Barran',
	'FR32030' => 'Bars',
	'FR32031' => 'Bascous',
	'FR32032' => 'Bassoues',
	'FR32033' => 'Bazian',
	'FR32034' => 'Bazugues',
	'FR32035' => 'Beaucaire',
	'FR32036' => 'Beaumarchés',
	'FR32037' => 'Beaumont',
	'FR32038' => 'Beaupuy',
	'FR32039' => 'Beccas',
	'FR32040' => 'Bédéchan',
	'FR32041' => 'Bellegarde',
	'FR32042' => 'Belloc-Saint-Clamens',
	'FR32043' => 'Belmont',
	'FR32044' => 'Béraut',
	'FR32045' => 'Berdoues',
	'FR32046' => 'Bernède',
	'FR32047' => 'Berrac',
	'FR32048' => 'Betcave-Aguin',
	'FR32049' => 'Bétous',
	'FR32050' => 'Betplan',
	'FR32051' => 'Bézéril',
	'FR32052' => 'Bezolles',
	'FR32053' => 'Bézues-Bajon',
	'FR32054' => 'Biran',
	'FR32055' => 'Bivès',
	'FR32056' => 'Blanquefort',
	'FR32057' => 'Blaziert',
	'FR32058' => 'Blousson-Sérian',
	'FR32059' => 'Bonas',
	'FR32060' => 'Boucagnères',
	'FR32061' => 'Boulaur',
	'FR32062' => 'Bourrouillan',
	'FR32063' => 'Bouzon-Gellenave',
	'FR32064' => 'Bretagne-dArmagnac',
	'FR32065' => 'Le Brouilh-Monbert',
	'FR32066' => 'Brugnens',
	'FR32067' => 'Cabas-Loumassès',
	'FR32068' => 'Cadeilhan',
	'FR32069' => 'Cadeillan',
	'FR32070' => 'Cahuzac-sur-Adour',
	'FR32071' => 'Caillavet',
	'FR32072' => 'Callian',
	'FR32073' => 'Campagne-dArmagnac',
	'FR32075' => 'Cassaigne',
	'FR32076' => 'Castelnau-Barbarens',
	'FR32077' => 'Castelnau-dAnglès',
	'FR32078' => 'Castelnau-dArbieu',
	'FR32079' => 'Castelnau dAuzan Labarrère',
	'FR32080' => 'Castelnau-sur-lAuvignon',
	'FR32081' => 'Castelnavet',
	'FR32082' => 'Castéra-Lectourois',
	'FR32083' => 'Castéra-Verduzan',
	'FR32084' => 'Castéron',
	'FR32085' => 'Castet-Arrouy',
	'FR32086' => 'Castex',
	'FR32087' => 'Castex-dArmagnac',
	'FR32088' => 'Castillon-Debats',
	'FR32089' => 'Castillon-Massas',
	'FR32090' => 'Castillon-Savès',
	'FR32091' => 'Castin',
	'FR32092' => 'Catonvielle',
	'FR32093' => 'Caumont',
	'FR32094' => 'Caupenne-dArmagnac',
	'FR32095' => 'Caussens',
	'FR32096' => 'Cazaubon',
	'FR32097' => 'Cazaux-dAnglès',
	'FR32098' => 'Cazaux-Savès',
	'FR32099' => 'Cazaux-Villecomtal',
	'FR32100' => 'Cazeneuve',
	'FR32101' => 'Céran',
	'FR32102' => 'Cézan',
	'FR32103' => 'Chélan',
	'FR32104' => 'Clermont-Pouyguillès',
	'FR32105' => 'Clermont-Savès',
	'FR32106' => 'Cologne',
	'FR32107' => 'Condom',
	'FR32108' => 'Corneillan',
	'FR32109' => 'Couloumé-Mondebat',
	'FR32110' => 'Courrensan',
	'FR32111' => 'Courties',
	'FR32112' => 'Crastes',
	'FR32113' => 'Cravencères',
	'FR32114' => 'Cuélas',
	'FR32115' => 'Dému',
	'FR32116' => 'Duffort',
	'FR32117' => 'Duran',
	'FR32118' => 'Durban',
	'FR32119' => 'Eauze',
	'FR32120' => 'Encausse',
	'FR32121' => 'Endoufielle',
	'FR32122' => 'Esclassan-Labastide',
	'FR32123' => 'Escornebœuf',
	'FR32124' => 'Espaon',
	'FR32125' => 'Espas',
	'FR32126' => 'Estampes',
	'FR32127' => 'Estang',
	'FR32128' => 'Estipouy',
	'FR32129' => 'Estramiac',
	'FR32130' => 'Faget-Abbatial',
	'FR32131' => 'Flamarens',
	'FR32132' => 'Fleurance',
	'FR32133' => 'Fourcès',
	'FR32134' => 'Frégouville',
	'FR32135' => 'Fustérouau',
	'FR32136' => 'Galiax',
	'FR32138' => 'Garravet',
	'FR32139' => 'Gaudonville',
	'FR32140' => 'Gaujac',
	'FR32141' => 'Gaujan',
	'FR32142' => 'Gavarret-sur-Aulouste',
	'FR32143' => 'Gazaupouy',
	'FR32144' => 'Gazax-et-Baccarisse',
	'FR32145' => 'Gée-Rivière',
	'FR32146' => 'Gimbrède',
	'FR32147' => 'Gimont',
	'FR32148' => 'Giscaro',
	'FR32149' => 'Gondrin',
	'FR32150' => 'Goutz',
	'FR32151' => 'Goux',
	'FR32152' => 'Haget',
	'FR32153' => 'Haulies',
	'FR32154' => 'Homps',
	'FR32155' => 'Le Houga',
	'FR32156' => 'Idrac-Respaillès',
	'FR32157' => 'LIsle-Arné',
	'FR32158' => 'LIsle-Bouzon',
	'FR32159' => 'LIsle-de-Noé',
	'FR32160' => 'LIsle-Jourdain',
	'FR32161' => 'Izotges',
	'FR32162' => 'Jegun',
	'FR32163' => 'Jû-Belloc',
	'FR32164' => 'Juillac',
	'FR32165' => 'Juilles',
	'FR32166' => 'Justian',
	'FR32167' => 'Laas',
	'FR32169' => 'Labarthe',
	'FR32170' => 'Labarthète',
	'FR32171' => 'Labastide-Savès',
	'FR32172' => 'Labéjan',
	'FR32173' => 'Labrihe',
	'FR32174' => 'Ladevèze-Rivière',
	'FR32175' => 'Ladevèze-Ville',
	'FR32176' => 'Lagarde',
	'FR32177' => 'Lagarde-Hachan',
	'FR32178' => 'Lagardère',
	'FR32180' => 'Lagraulet-du-Gers',
	'FR32181' => 'Laguian-Mazous',
	'FR32182' => 'Lahas',
	'FR32183' => 'Lahitte',
	'FR32184' => 'Lalanne',
	'FR32185' => 'Lalanne-Arqué',
	'FR32186' => 'Lamaguère',
	'FR32187' => 'Lamazère',
	'FR32188' => 'Lamothe-Goas',
	'FR32189' => 'Lannemaignan',
	'FR32190' => 'Lannepax',
	'FR32191' => 'Lanne-Soubiran',
	'FR32192' => 'Lannux',
	'FR32193' => 'Larée',
	'FR32194' => 'Larressingle',
	'FR32195' => 'Larroque-Engalin',
	'FR32196' => 'Larroque-Saint-Sernin',
	'FR32197' => 'Larroque-sur-lOsse',
	'FR32198' => 'Lartigue',
	'FR32199' => 'Lasserade',
	'FR32200' => 'Lasséran',
	'FR32201' => 'Lasseube-Propre',
	'FR32202' => 'Laujuzan',
	'FR32203' => 'Lauraët',
	'FR32204' => 'Lavardens',
	'FR32205' => 'Laveraët',
	'FR32206' => 'Laymont',
	'FR32207' => 'Leboulin',
	'FR32208' => 'Lectoure',
	'FR32209' => 'Lelin-Lapujolle',
	'FR32210' => 'Lias',
	'FR32211' => 'Lias-dArmagnac',
	'FR32212' => 'Ligardes',
	'FR32213' => 'Lombez',
	'FR32214' => 'Loubédat',
	'FR32215' => 'Loubersan',
	'FR32216' => 'Lourties-Monbrun',
	'FR32217' => 'Louslitges',
	'FR32218' => 'Loussous-Débat',
	'FR32219' => 'Lupiac',
	'FR32220' => 'Luppé-Violles',
	'FR32221' => 'Lussan',
	'FR32222' => 'Magnan',
	'FR32223' => 'Magnas',
	'FR32224' => 'Maignaut-Tauzia',
	'FR32225' => 'Malabat',
	'FR32226' => 'Manas-Bastanous',
	'FR32227' => 'Manciet',
	'FR32228' => 'Manent-Montané',
	'FR32229' => 'Mansempuy',
	'FR32230' => 'Mansencôme',
	'FR32231' => 'Marambat',
	'FR32232' => 'Maravat',
	'FR32233' => 'Marciac',
	'FR32234' => 'Marestaing',
	'FR32235' => 'Margouët-Meymes',
	'FR32236' => 'Marguestau',
	'FR32237' => 'Marsan',
	'FR32238' => 'Marseillan',
	'FR32239' => 'Marsolan',
	'FR32240' => 'Mascaras',
	'FR32241' => 'Mas-dAuvignon',
	'FR32242' => 'Masseube',
	'FR32243' => 'Mauléon-dArmagnac',
	'FR32244' => 'Maulichères',
	'FR32245' => 'Maumusson-Laguian',
	'FR32246' => 'Maupas',
	'FR32247' => 'Maurens',
	'FR32248' => 'Mauroux',
	'FR32249' => 'Mauvezin',
	'FR32250' => 'Meilhan',
	'FR32251' => 'Mérens',
	'FR32252' => 'Miélan',
	'FR32253' => 'Miradoux',
	'FR32254' => 'Miramont-dAstarac',
	'FR32255' => 'Miramont-Latour',
	'FR32256' => 'Mirande',
	'FR32257' => 'Mirannes',
	'FR32258' => 'Mirepoix',
	'FR32260' => 'Monbardon',
	'FR32261' => 'Monblanc',
	'FR32262' => 'Monbrun',
	'FR32263' => 'Moncassin',
	'FR32264' => 'Monclar',
	'FR32265' => 'Monclar-sur-Losse',
	'FR32266' => 'Moncorneil-Grazan',
	'FR32267' => 'Monferran-Plavès',
	'FR32268' => 'Monferran-Savès',
	'FR32269' => 'Monfort',
	'FR32270' => 'Mongausy',
	'FR32271' => 'Monguilhem',
	'FR32272' => 'Monlaur-Bernet',
	'FR32273' => 'Monlezun',
	'FR32274' => 'Monlezun-dArmagnac',
	'FR32275' => 'Monpardiac',
	'FR32276' => 'Montadet',
	'FR32277' => 'Montamat',
	'FR32278' => 'Montaut',
	'FR32279' => 'Montaut-les-Créneaux',
	'FR32280' => 'Mont-dAstarac',
	'FR32281' => 'Mont-de-Marrast',
	'FR32282' => 'Montégut',
	'FR32283' => 'Montégut-Arros',
	'FR32284' => 'Montégut-Savès',
	'FR32285' => 'Montesquiou',
	'FR32286' => 'Montestruc-sur-Gers',
	'FR32287' => 'Monties',
	'FR32288' => 'Montiron',
	'FR32289' => 'Montpézat',
	'FR32290' => 'Montréal',
	'FR32291' => 'Mormès',
	'FR32292' => 'Mouchan',
	'FR32293' => 'Mouchès',
	'FR32294' => 'Mourède',
	'FR32295' => 'Nizas',
	'FR32296' => 'Nogaro',
	'FR32297' => 'Noilhan',
	'FR32298' => 'Nougaroulet',
	'FR32299' => 'Noulens',
	'FR32300' => 'Orbessan',
	'FR32301' => 'Ordan-Larroque',
	'FR32302' => 'Ornézan',
	'FR32303' => 'Pallanne',
	'FR32304' => 'Panassac',
	'FR32305' => 'Panjas',
	'FR32306' => 'Pauilhac',
	'FR32307' => 'Pavie',
	'FR32308' => 'Pébées',
	'FR32309' => 'Pellefigue',
	'FR32310' => 'Perchède',
	'FR32311' => 'Pergain-Taillac',
	'FR32312' => 'Pessan',
	'FR32313' => 'Pessoulens',
	'FR32314' => 'Peyrecave',
	'FR32315' => 'Peyrusse-Grande',
	'FR32316' => 'Peyrusse-Massas',
	'FR32317' => 'Peyrusse-Vieille',
	'FR32318' => 'Pis',
	'FR32319' => 'Plaisance',
	'FR32320' => 'Plieux',
	'FR32321' => 'Polastron',
	'FR32322' => 'Pompiac',
	'FR32323' => 'Ponsampère',
	'FR32324' => 'Ponsan-Soubiran',
	'FR32325' => 'Pouydraguin',
	'FR32326' => 'Pouylebon',
	'FR32327' => 'Pouy-Loubrin',
	'FR32328' => 'Pouy-Roquelaure',
	'FR32329' => 'Préchac',
	'FR32330' => 'Préchac-sur-Adour',
	'FR32331' => 'Preignan',
	'FR32332' => 'Préneron',
	'FR32333' => 'Projan',
	'FR32334' => 'Pujaudran',
	'FR32335' => 'Puycasquier',
	'FR32336' => 'Puylausic',
	'FR32337' => 'Puységur',
	'FR32338' => 'Ramouzens',
	'FR32339' => 'Razengues',
	'FR32340' => 'Réans',
	'FR32341' => 'Réjaumont',
	'FR32342' => 'Ricourt',
	'FR32343' => 'Riguepeu',
	'FR32344' => 'Riscle',
	'FR32345' => 'La Romieu',
	'FR32346' => 'Roquebrune',
	'FR32347' => 'Roquefort',
	'FR32348' => 'Roquelaure',
	'FR32349' => 'Roquelaure-Saint-Aubin',
	'FR32350' => 'Roquepine',
	'FR32351' => 'Roques',
	'FR32352' => 'Rozès',
	'FR32353' => 'Sabaillan',
	'FR32354' => 'Sabazan',
	'FR32355' => 'Sadeillan',
	'FR32356' => 'Saint-André',
	'FR32357' => 'Sainte-Anne',
	'FR32358' => 'Saint-Antoine',
	'FR32359' => 'Saint-Antonin',
	'FR32360' => 'Saint-Arailles',
	'FR32361' => 'Saint-Arroman',
	'FR32362' => 'Saint-Aunix-Lengros',
	'FR32363' => 'Sainte-Aurence-Cazaux',
	'FR32364' => 'Saint-Avit-Frandat',
	'FR32365' => 'Saint-Blancard',
	'FR32366' => 'Saint-Brès',
	'FR32367' => 'Saint-Christaud',
	'FR32368' => 'Sainte-Christie',
	'FR32369' => 'Sainte-Christie-dArmagnac',
	'FR32370' => 'Saint-Clar',
	'FR32371' => 'Saint-Créac',
	'FR32372' => 'Saint-Cricq',
	'FR32373' => 'Sainte-Dode',
	'FR32374' => 'Saint-Élix-dAstarac',
	'FR32375' => 'Saint-Élix-Theux',
	'FR32376' => 'Sainte-Gemme',
	'FR32377' => 'Saint-Georges',
	'FR32378' => 'Saint-Germé',
	'FR32379' => 'Saint-Germier',
	'FR32380' => 'Saint-Griède',
	'FR32381' => 'Saint-Jean-le-Comtal',
	'FR32382' => 'Saint-Jean-Poutge',
	'FR32383' => 'Saint-Justin',
	'FR32384' => 'Saint-Lary',
	'FR32385' => 'Saint-Léonard',
	'FR32386' => 'Saint-Lizier-du-Planté',
	'FR32387' => 'Saint-Loube',
	'FR32388' => 'Sainte-Marie',
	'FR32389' => 'Saint-Martin',
	'FR32390' => 'Saint-Martin-dArmagnac',
	'FR32391' => 'Saint-Martin-de-Goyne',
	'FR32392' => 'Saint-Martin-Gimois',
	'FR32393' => 'Saint-Maur',
	'FR32394' => 'Saint-Médard',
	'FR32395' => 'Sainte-Mère',
	'FR32396' => 'Saint-Mézard',
	'FR32397' => 'Saint-Michel',
	'FR32398' => 'Saint-Mont',
	'FR32399' => 'Saint-Orens',
	'FR32400' => 'Saint-Orens-Pouy-Petit',
	'FR32401' => 'Saint-Ost',
	'FR32402' => 'Saint-Paul-de-Baïse',
	'FR32403' => 'Saint-Pierre-dAubézies',
	'FR32404' => 'Saint-Puy',
	'FR32405' => 'Sainte-Radegonde',
	'FR32406' => 'Saint-Sauvy',
	'FR32407' => 'Saint-Soulan',
	'FR32408' => 'Salles-dArmagnac',
	'FR32409' => 'Samaran',
	'FR32410' => 'Samatan',
	'FR32411' => 'Sansan',
	'FR32412' => 'Saramon',
	'FR32413' => 'Sarcos',
	'FR32414' => 'Sarragachies',
	'FR32415' => 'Sarraguzan',
	'FR32416' => 'Sarrant',
	'FR32417' => 'La Sauvetat',
	'FR32418' => 'Sauveterre',
	'FR32419' => 'Sauviac',
	'FR32420' => 'Sauvimont',
	'FR32421' => 'Savignac-Mona',
	'FR32422' => 'Scieurac-et-Flourès',
	'FR32423' => 'Séailles',
	'FR32424' => 'Ségos',
	'FR32425' => 'Ségoufielle',
	'FR32426' => 'Seissan',
	'FR32427' => 'Sembouès',
	'FR32428' => 'Sémézies-Cachan',
	'FR32429' => 'Sempesserre',
	'FR32430' => 'Sère',
	'FR32431' => 'Sérempuy',
	'FR32432' => 'Seysses-Savès',
	'FR32433' => 'Simorre',
	'FR32434' => 'Sion',
	'FR32435' => 'Sirac',
	'FR32436' => 'Solomiac',
	'FR32437' => 'Sorbets',
	'FR32438' => 'Tachoires',
	'FR32439' => 'Tarsac',
	'FR32440' => 'Tasque',
	'FR32441' => 'Taybosc',
	'FR32442' => 'Terraube',
	'FR32443' => 'Termes-dArmagnac',
	'FR32444' => 'Thoux',
	'FR32445' => 'Tieste-Uragnoux',
	'FR32446' => 'Tillac',
	'FR32447' => 'Tirent-Pontéjac',
	'FR32448' => 'Touget',
	'FR32449' => 'Toujouse',
	'FR32450' => 'Tourdun',
	'FR32451' => 'Tournan',
	'FR32452' => 'Tournecoupe',
	'FR32453' => 'Tourrenquets',
	'FR32454' => 'Traversères',
	'FR32455' => 'Troncens',
	'FR32456' => 'Tudelle',
	'FR32457' => 'Urdens',
	'FR32458' => 'Urgosse',
	'FR32459' => 'Valence-sur-Baïse',
	'FR32460' => 'Vergoignan',
	'FR32461' => 'Verlus',
	'FR32462' => 'Vic-Fezensac',
	'FR32463' => 'Viella',
	'FR32464' => 'Villecomtal-sur-Arros',
	'FR32465' => 'Villefranche',
	'FR32466' => 'Viozan',
	'FR32467' => 'Saint-Caprais',
	'FR32468' => 'Aussos',
	'FR33001' => 'Abzac',
	'FR33002' => 'Aillas',
	'FR33003' => 'Ambarès-et-Lagrave',
	'FR33004' => 'Ambès',
	'FR33005' => 'Andernos-les-Bains',
	'FR33006' => 'Anglade',
	'FR33007' => 'Arbanats',
	'FR33008' => 'Porte-de-Benauge',
	'FR33009' => 'Arcachon',
	'FR33010' => 'Arcins',
	'FR33011' => 'Arès',
	'FR33012' => 'Arsac',
	'FR33013' => 'Artigues-près-Bordeaux',
	'FR33014' => 'Les Artigues-de-Lussac',
	'FR33015' => 'Arveyres',
	'FR33016' => 'Asques',
	'FR33017' => 'Aubiac',
	'FR33018' => 'Val de Virvée',
	'FR33019' => 'Audenge',
	'FR33020' => 'Auriolles',
	'FR33021' => 'Auros',
	'FR33022' => 'Avensan',
	'FR33023' => 'Ayguemorte-les-Graves',
	'FR33024' => 'Bagas',
	'FR33025' => 'Baigneaux',
	'FR33026' => 'Balizac',
	'FR33027' => 'Barie',
	'FR33028' => 'Baron',
	'FR33029' => 'Le Barp',
	'FR33030' => 'Barsac',
	'FR33031' => 'Bassanne',
	'FR33032' => 'Bassens',
	'FR33033' => 'Baurech',
	'FR33034' => 'Bayas',
	'FR33035' => 'Bayon-sur-Gironde',
	'FR33036' => 'Bazas',
	'FR33037' => 'Beautiran',
	'FR33038' => 'Bégadan',
	'FR33039' => 'Bègles',
	'FR33040' => 'Béguey',
	'FR33042' => 'Belin-Béliet',
	'FR33043' => 'Bellebat',
	'FR33044' => 'Bellefond',
	'FR33045' => 'Belvès-de-Castillon',
	'FR33046' => 'Bernos-Beaulac',
	'FR33047' => 'Berson',
	'FR33048' => 'Berthez',
	'FR33049' => 'Beychac-et-Caillau',
	'FR33050' => 'Bieujac',
	'FR33051' => 'Biganos',
	'FR33052' => 'Les Billaux',
	'FR33053' => 'Birac',
	'FR33054' => 'Blaignac',
	'FR33055' => 'Blaignan-Prignac',
	'FR33056' => 'Blanquefort',
	'FR33057' => 'Blasimon',
	'FR33058' => 'Blaye',
	'FR33059' => 'Blésignac',
	'FR33060' => 'Bommes',
	'FR33061' => 'Bonnetan',
	'FR33062' => 'Bonzac',
	'FR33063' => 'Bordeaux',
	'FR33064' => 'Bossugan',
	'FR33065' => 'Bouliac',
	'FR33066' => 'Bourdelles',
	'FR33067' => 'Bourg',
	'FR33068' => 'Bourideys',
	'FR33069' => 'Le Bouscat',
	'FR33070' => 'Brach',
	'FR33071' => 'Branne',
	'FR33072' => 'Brannens',
	'FR33073' => 'Braud-et-Saint-Louis',
	'FR33074' => 'Brouqueyran',
	'FR33075' => 'Bruges',
	'FR33076' => 'Budos',
	'FR33077' => 'Cabanac-et-Villagrains',
	'FR33078' => 'Cabara',
	'FR33079' => 'Cadarsac',
	'FR33080' => 'Cadaujac',
	'FR33081' => 'Cadillac',
	'FR33082' => 'Cadillac-en-Fronsadais',
	'FR33083' => 'Camarsac',
	'FR33084' => 'Cambes',
	'FR33085' => 'Camblanes-et-Meynac',
	'FR33086' => 'Camiac-et-Saint-Denis',
	'FR33087' => 'Camiran',
	'FR33088' => 'Camps-sur-lIsle',
	'FR33089' => 'Campugnan',
	'FR33090' => 'Canéjan',
	'FR33093' => 'Capian',
	'FR33094' => 'Caplong',
	'FR33095' => 'Captieux',
	'FR33096' => 'Carbon-Blanc',
	'FR33097' => 'Carcans',
	'FR33098' => 'Cardan',
	'FR33099' => 'Carignan-de-Bordeaux',
	'FR33100' => 'Cars',
	'FR33101' => 'Cartelègue',
	'FR33102' => 'Casseuil',
	'FR33103' => 'Castelmoron-dAlbret',
	'FR33104' => 'Castelnau-de-Médoc',
	'FR33105' => 'Castelviel',
	'FR33106' => 'Castets et Castillon',
	'FR33108' => 'Castillon-la-Bataille',
	'FR33109' => 'Castres-Gironde',
	'FR33111' => 'Caudrot',
	'FR33112' => 'Caumont',
	'FR33113' => 'Cauvignac',
	'FR33114' => 'Cavignac',
	'FR33115' => 'Cazalis',
	'FR33116' => 'Cazats',
	'FR33117' => 'Cazaugitat',
	'FR33118' => 'Cénac',
	'FR33119' => 'Cenon',
	'FR33120' => 'Cérons',
	'FR33121' => 'Cessac',
	'FR33122' => 'Cestas',
	'FR33123' => 'Cézac',
	'FR33124' => 'Chamadelle',
	'FR33125' => 'Cissac-Médoc',
	'FR33126' => 'Civrac-de-Blaye',
	'FR33127' => 'Civrac-sur-Dordogne',
	'FR33128' => 'Civrac-en-Médoc',
	'FR33129' => 'Cleyrac',
	'FR33130' => 'Coimères',
	'FR33131' => 'Coirac',
	'FR33132' => 'Comps',
	'FR33133' => 'Coubeyrac',
	'FR33134' => 'Couquèques',
	'FR33135' => 'Courpiac',
	'FR33136' => 'Cours-de-Monségur',
	'FR33137' => 'Cours-les-Bains',
	'FR33138' => 'Coutras',
	'FR33139' => 'Coutures',
	'FR33140' => 'Créon',
	'FR33141' => 'Croignon',
	'FR33142' => 'Cubnezais',
	'FR33143' => 'Cubzac-les-Ponts',
	'FR33144' => 'Cudos',
	'FR33145' => 'Cursan',
	'FR33146' => 'Cussac-Fort-Médoc',
	'FR33147' => 'Daignac',
	'FR33148' => 'Dardenac',
	'FR33149' => 'Daubèze',
	'FR33150' => 'Dieulivol',
	'FR33151' => 'Donnezac',
	'FR33152' => 'Donzac',
	'FR33153' => 'Doulezon',
	'FR33154' => 'Les Églisottes-et-Chalaures',
	'FR33155' => 'Escaudes',
	'FR33156' => 'Escoussans',
	'FR33157' => 'Espiet',
	'FR33158' => 'Les Esseintes',
	'FR33159' => 'Étauliers',
	'FR33160' => 'Eynesse',
	'FR33161' => 'Eyrans',
	'FR33162' => 'Eysines',
	'FR33163' => 'Faleyras',
	'FR33164' => 'Fargues',
	'FR33165' => 'Fargues-Saint-Hilaire',
	'FR33166' => 'Le Fieu',
	'FR33167' => 'Floirac',
	'FR33168' => 'Flaujagues',
	'FR33169' => 'Floudès',
	'FR33170' => 'Fontet',
	'FR33171' => 'Fossès-et-Baleyssac',
	'FR33172' => 'Fours',
	'FR33173' => 'Francs',
	'FR33174' => 'Fronsac',
	'FR33175' => 'Frontenac',
	'FR33176' => 'Gabarnac',
	'FR33177' => 'Gaillan-en-Médoc',
	'FR33178' => 'Gajac',
	'FR33179' => 'Galgon',
	'FR33180' => 'Gans',
	'FR33181' => 'Gardegan-et-Tourtirac',
	'FR33182' => 'Gauriac',
	'FR33183' => 'Gauriaguet',
	'FR33184' => 'Générac',
	'FR33185' => 'Génissac',
	'FR33186' => 'Gensac',
	'FR33187' => 'Gironde-sur-Dropt',
	'FR33188' => 'Giscos',
	'FR33189' => 'Gornac',
	'FR33190' => 'Goualade',
	'FR33191' => 'Gours',
	'FR33192' => 'Gradignan',
	'FR33193' => 'Grayan-et-lHôpital',
	'FR33194' => 'Grézillac',
	'FR33195' => 'Grignols',
	'FR33196' => 'Guillac',
	'FR33197' => 'Guillos',
	'FR33198' => 'Guîtres',
	'FR33199' => 'Gujan-Mestras',
	'FR33200' => 'Le Haillan',
	'FR33201' => 'Haux',
	'FR33202' => 'Hostens',
	'FR33203' => 'Hourtin',
	'FR33204' => 'Hure',
	'FR33205' => 'Illats',
	'FR33206' => 'Isle-Saint-Georges',
	'FR33207' => 'Izon',
	'FR33208' => 'Jau-Dignac-et-Loirac',
	'FR33209' => 'Jugazan',
	'FR33210' => 'Juillac',
	'FR33211' => 'Labarde',
	'FR33212' => 'Labescau',
	'FR33213' => 'La Brède',
	'FR33214' => 'Lacanau',
	'FR33215' => 'Ladaux',
	'FR33216' => 'Lados',
	'FR33218' => 'Lagorce',
	'FR33219' => 'La Lande-de-Fronsac',
	'FR33220' => 'Lamarque',
	'FR33221' => 'Lamothe-Landerron',
	'FR33222' => 'Lalande-de-Pomerol',
	'FR33223' => 'Landerrouat',
	'FR33224' => 'Landerrouet-sur-Ségur',
	'FR33225' => 'Landiras',
	'FR33226' => 'Langoiran',
	'FR33227' => 'Langon',
	'FR33228' => 'Lansac',
	'FR33229' => 'Lanton',
	'FR33230' => 'Lapouyade',
	'FR33231' => 'Laroque',
	'FR33232' => 'Lartigue',
	'FR33233' => 'Laruscade',
	'FR33234' => 'Latresne',
	'FR33235' => 'Lavazan',
	'FR33236' => 'Lège-Cap-Ferret',
	'FR33237' => 'Léogeats',
	'FR33238' => 'Léognan',
	'FR33239' => 'Lerm-et-Musset',
	'FR33240' => 'Lesparre-Médoc',
	'FR33241' => 'Lestiac-sur-Garonne',
	'FR33242' => 'Les Lèves-et-Thoumeyragues',
	'FR33243' => 'Libourne',
	'FR33244' => 'Lignan-de-Bazas',
	'FR33245' => 'Lignan-de-Bordeaux',
	'FR33246' => 'Ligueux',
	'FR33247' => 'Listrac-de-Durèze',
	'FR33248' => 'Listrac-Médoc',
	'FR33249' => 'Lormont',
	'FR33250' => 'Loubens',
	'FR33251' => 'Louchats',
	'FR33252' => 'Loupes',
	'FR33253' => 'Loupiac',
	'FR33254' => 'Loupiac-de-la-Réole',
	'FR33255' => 'Lucmau',
	'FR33256' => 'Ludon-Médoc',
	'FR33257' => 'Lugaignac',
	'FR33258' => 'Lugasson',
	'FR33259' => 'Lugon-et-lÎle-du-Carnay',
	'FR33260' => 'Lugos',
	'FR33261' => 'Lussac',
	'FR33262' => 'Macau',
	'FR33263' => 'Madirac',
	'FR33264' => 'Maransin',
	'FR33266' => 'Marcenais',
	'FR33268' => 'Margaux-Cantenac',
	'FR33269' => 'Margueron',
	'FR33270' => 'Marimbault',
	'FR33271' => 'Marions',
	'FR33272' => 'Marsas',
	'FR33273' => 'Martignas-sur-Jalle',
	'FR33274' => 'Martillac',
	'FR33275' => 'Martres',
	'FR33276' => 'Masseilles',
	'FR33277' => 'Massugas',
	'FR33278' => 'Mauriac',
	'FR33279' => 'Mazères',
	'FR33280' => 'Mazion',
	'FR33281' => 'Mérignac',
	'FR33282' => 'Mérignas',
	'FR33283' => 'Mesterrieux',
	'FR33284' => 'Mios',
	'FR33285' => 'Mombrier',
	'FR33287' => 'Mongauzy',
	'FR33288' => 'Monprimblanc',
	'FR33289' => 'Monségur',
	'FR33290' => 'Montagne',
	'FR33291' => 'Montagoudin',
	'FR33292' => 'Montignac',
	'FR33293' => 'Montussan',
	'FR33294' => 'Morizès',
	'FR33295' => 'Mouillac',
	'FR33296' => 'Mouliets-et-Villemartin',
	'FR33297' => 'Moulis-en-Médoc',
	'FR33298' => 'Moulon',
	'FR33299' => 'Mourens',
	'FR33300' => 'Naujac-sur-Mer',
	'FR33301' => 'Naujan-et-Postiac',
	'FR33302' => 'Néac',
	'FR33303' => 'Nérigean',
	'FR33304' => 'Neuffons',
	'FR33305' => 'Le Nizan',
	'FR33306' => 'Noaillac',
	'FR33307' => 'Noaillan',
	'FR33308' => 'Omet',
	'FR33309' => 'Ordonnac',
	'FR33310' => 'Origne',
	'FR33311' => 'Paillet',
	'FR33312' => 'Parempuyre',
	'FR33314' => 'Pauillac',
	'FR33315' => 'Les Peintures',
	'FR33316' => 'Pellegrue',
	'FR33317' => 'Périssac',
	'FR33318' => 'Pessac',
	'FR33319' => 'Pessac-sur-Dordogne',
	'FR33320' => 'Petit-Palais-et-Cornemps',
	'FR33321' => 'Peujard',
	'FR33322' => 'Le Pian-Médoc',
	'FR33323' => 'Le Pian-sur-Garonne',
	'FR33324' => 'Pineuilh',
	'FR33325' => 'Plassac',
	'FR33326' => 'Pleine-Selve',
	'FR33327' => 'Podensac',
	'FR33328' => 'Pomerol',
	'FR33329' => 'Pompéjac',
	'FR33330' => 'Pompignac',
	'FR33331' => 'Pondaurat',
	'FR33332' => 'Porchères',
	'FR33333' => 'Le Porge',
	'FR33334' => 'Portets',
	'FR33335' => 'Le Pout',
	'FR33336' => 'Préchac',
	'FR33337' => 'Preignac',
	'FR33339' => 'Prignac-et-Marcamps',
	'FR33341' => 'Pugnac',
	'FR33342' => 'Puisseguin',
	'FR33343' => 'Pujols-sur-Ciron',
	'FR33344' => 'Pujols',
	'FR33345' => 'Le Puy',
	'FR33346' => 'Puybarban',
	'FR33347' => 'Puynormand',
	'FR33348' => 'Queyrac',
	'FR33349' => 'Quinsac',
	'FR33350' => 'Rauzan',
	'FR33351' => 'Reignac',
	'FR33352' => 'La Réole',
	'FR33353' => 'Rimons',
	'FR33354' => 'Riocaud',
	'FR33355' => 'Rions',
	'FR33356' => 'La Rivière',
	'FR33357' => 'Roaillan',
	'FR33358' => 'Romagne',
	'FR33359' => 'Roquebrune',
	'FR33360' => 'La Roquille',
	'FR33361' => 'Ruch',
	'FR33362' => 'Sablons',
	'FR33363' => 'Sadirac',
	'FR33364' => 'Saillans',
	'FR33365' => 'Saint-Aignan',
	'FR33366' => 'Saint-André-de-Cubzac',
	'FR33367' => 'Saint-André-du-Bois',
	'FR33369' => 'Saint-André-et-Appelles',
	'FR33370' => 'Saint-Androny',
	'FR33372' => 'Saint-Antoine-du-Queyret',
	'FR33373' => 'Saint-Antoine-sur-lIsle',
	'FR33374' => 'Saint-Aubin-de-Blaye',
	'FR33375' => 'Saint-Aubin-de-Branne',
	'FR33376' => 'Saint-Aubin-de-Médoc',
	'FR33377' => 'Saint-Avit-de-Soulège',
	'FR33378' => 'Saint-Avit-Saint-Nazaire',
	'FR33379' => 'Saint-Brice',
	'FR33380' => 'Val-de-Livenne',
	'FR33381' => 'Saint-Caprais-de-Bordeaux',
	'FR33382' => 'Saint-Christoly-de-Blaye',
	'FR33383' => 'Saint-Christoly-Médoc',
	'FR33384' => 'Saint-Christophe-des-Bardes',
	'FR33385' => 'Saint-Christophe-de-Double',
	'FR33386' => 'Saint-Cibard',
	'FR33387' => 'Saint-Ciers-dAbzac',
	'FR33388' => 'Saint-Ciers-de-Canesse',
	'FR33389' => 'Saint-Ciers-sur-Gironde',
	'FR33390' => 'Sainte-Colombe',
	'FR33391' => 'Saint-Côme',
	'FR33392' => 'Sainte-Croix-du-Mont',
	'FR33393' => 'Saint-Denis-de-Pile',
	'FR33394' => 'Saint-Émilion',
	'FR33395' => 'Saint-Estèphe',
	'FR33396' => 'Saint-Étienne-de-Lisse',
	'FR33397' => 'Sainte-Eulalie',
	'FR33398' => 'Saint-Exupéry',
	'FR33399' => 'Saint-Félix-de-Foncaude',
	'FR33400' => 'Saint-Ferme',
	'FR33401' => 'Sainte-Florence',
	'FR33402' => 'Sainte-Foy-la-Grande',
	'FR33403' => 'Sainte-Foy-la-Longue',
	'FR33404' => 'Sainte-Gemme',
	'FR33405' => 'Saint-Genès-de-Blaye',
	'FR33406' => 'Saint-Genès-de-Castillon',
	'FR33407' => 'Saint-Genès-de-Fronsac',
	'FR33408' => 'Saint-Genès-de-Lombaud',
	'FR33409' => 'Saint-Genis-du-Bois',
	'FR33411' => 'Saint-Germain-de-Grave',
	'FR33412' => 'Saint-Germain-dEsteuil',
	'FR33413' => 'Saint-Germain-du-Puch',
	'FR33414' => 'Saint-Germain-de-la-Rivière',
	'FR33415' => 'Saint-Gervais',
	'FR33416' => 'Saint-Girons-dAiguevives',
	'FR33417' => 'Sainte-Hélène',
	'FR33418' => 'Saint-Hilaire-de-la-Noaille',
	'FR33419' => 'Saint-Hilaire-du-Bois',
	'FR33420' => 'Saint-Hippolyte',
	'FR33421' => 'Saint-Jean-de-Blaignac',
	'FR33422' => 'Saint-Jean-dIllac',
	'FR33423' => 'Saint-Julien-Beychevelle',
	'FR33424' => 'Saint-Laurent-Médoc',
	'FR33425' => 'Saint-Laurent-dArce',
	'FR33426' => 'Saint-Laurent-des-Combes',
	'FR33427' => 'Saint-Laurent-du-Bois',
	'FR33428' => 'Saint-Laurent-du-Plan',
	'FR33429' => 'Saint-Léger-de-Balson',
	'FR33431' => 'Saint-Léon',
	'FR33432' => 'Saint-Loubert',
	'FR33433' => 'Saint-Loubès',
	'FR33434' => 'Saint-Louis-de-Montferrand',
	'FR33435' => 'Saint-Macaire',
	'FR33436' => 'Saint-Magne',
	'FR33437' => 'Saint-Magne-de-Castillon',
	'FR33438' => 'Saint-Maixant',
	'FR33439' => 'Saint-Mariens',
	'FR33440' => 'Saint-Martial',
	'FR33441' => 'Saint-Martin-Lacaussade',
	'FR33442' => 'Saint-Martin-de-Laye',
	'FR33443' => 'Saint-Martin-de-Lerm',
	'FR33444' => 'Saint-Martin-de-Sescas',
	'FR33445' => 'Saint-Martin-du-Bois',
	'FR33446' => 'Saint-Martin-du-Puy',
	'FR33447' => 'Saint-Médard-de-Guizières',
	'FR33448' => 'Saint-Médard-dEyrans',
	'FR33449' => 'Saint-Médard-en-Jalles',
	'FR33450' => 'Saint-Michel-de-Castelnau',
	'FR33451' => 'Saint-Michel-de-Fronsac',
	'FR33452' => 'Saint-Michel-de-Rieufret',
	'FR33453' => 'Saint-Michel-de-Lapujade',
	'FR33454' => 'Saint-Morillon',
	'FR33456' => 'Saint-Palais',
	'FR33457' => 'Saint-Pardon-de-Conques',
	'FR33458' => 'Saint-Paul',
	'FR33459' => 'Saint-Pey-dArmens',
	'FR33460' => 'Saint-Pey-de-Castets',
	'FR33461' => 'Saint-Philippe-dAiguille',
	'FR33462' => 'Saint-Philippe-du-Seignal',
	'FR33463' => 'Saint-Pierre-dAurillac',
	'FR33464' => 'Saint-Pierre-de-Bat',
	'FR33465' => 'Saint-Pierre-de-Mons',
	'FR33466' => 'Saint-Quentin-de-Baron',
	'FR33467' => 'Saint-Quentin-de-Caplong',
	'FR33468' => 'Sainte-Radegonde',
	'FR33470' => 'Saint-Romain-la-Virvée',
	'FR33471' => 'Saint-Sauveur',
	'FR33472' => 'Saint-Sauveur-de-Puynormand',
	'FR33473' => 'Saint-Savin',
	'FR33474' => 'Saint-Selve',
	'FR33475' => 'Saint-Seurin-de-Bourg',
	'FR33476' => 'Saint-Seurin-de-Cadourne',
	'FR33477' => 'Saint-Seurin-de-Cursac',
	'FR33478' => 'Saint-Seurin-sur-lIsle',
	'FR33479' => 'Saint-Sève',
	'FR33480' => 'Saint-Sulpice-de-Faleyrens',
	'FR33481' => 'Saint-Sulpice-de-Guilleragues',
	'FR33482' => 'Saint-Sulpice-de-Pommiers',
	'FR33483' => 'Saint-Sulpice-et-Cameyrac',
	'FR33484' => 'Saint-Symphorien',
	'FR33485' => 'Sainte-Terre',
	'FR33486' => 'Saint-Trojan',
	'FR33487' => 'Saint-Vincent-de-Paul',
	'FR33488' => 'Saint-Vincent-de-Pertignas',
	'FR33489' => 'Saint-Vivien-de-Blaye',
	'FR33490' => 'Saint-Vivien-de-Médoc',
	'FR33491' => 'Saint-Vivien-de-Monségur',
	'FR33492' => 'Saint-Yzan-de-Soudiac',
	'FR33493' => 'Saint-Yzans-de-Médoc',
	'FR33494' => 'Salaunes',
	'FR33496' => 'Sallebœuf',
	'FR33498' => 'Salles',
	'FR33499' => 'Les Salles-de-Castillon',
	'FR33500' => 'Samonac',
	'FR33501' => 'Saucats',
	'FR33502' => 'Saugon',
	'FR33503' => 'Saumos',
	'FR33504' => 'Sauternes',
	'FR33505' => 'La Sauve',
	'FR33506' => 'Sauveterre-de-Guyenne',
	'FR33507' => 'Sauviac',
	'FR33508' => 'Savignac',
	'FR33509' => 'Savignac-de-lIsle',
	'FR33510' => 'Semens',
	'FR33511' => 'Sendets',
	'FR33512' => 'Sigalens',
	'FR33513' => 'Sillas',
	'FR33514' => 'Soulac-sur-Mer',
	'FR33515' => 'Soulignac',
	'FR33516' => 'Soussac',
	'FR33517' => 'Soussans',
	'FR33518' => 'Tabanac',
	'FR33519' => 'Le Taillan-Médoc',
	'FR33520' => 'Taillecavat',
	'FR33521' => 'Talais',
	'FR33522' => 'Talence',
	'FR33523' => 'Targon',
	'FR33524' => 'Tarnès',
	'FR33525' => 'Tauriac',
	'FR33526' => 'Tayac',
	'FR33527' => 'Le Teich',
	'FR33528' => 'Le Temple',
	'FR33529' => 'La Teste-de-Buch',
	'FR33530' => 'Teuillac',
	'FR33531' => 'Tizac-de-Curton',
	'FR33532' => 'Tizac-de-Lapouyade',
	'FR33533' => 'Toulenne',
	'FR33534' => 'Le Tourne',
	'FR33535' => 'Tresses',
	'FR33536' => 'Le Tuzan',
	'FR33537' => 'Uzeste',
	'FR33538' => 'Valeyrac',
	'FR33539' => 'Vayres',
	'FR33540' => 'Vendays-Montalivet',
	'FR33541' => 'Vensac',
	'FR33542' => 'Vérac',
	'FR33543' => 'Verdelais',
	'FR33544' => 'Le Verdon-sur-Mer',
	'FR33545' => 'Vertheuil',
	'FR33546' => 'Vignonet',
	'FR33547' => 'Villandraut',
	'FR33548' => 'Villegouge',
	'FR33549' => 'Villenave-de-Rions',
	'FR33550' => 'Villenave-dOrnon',
	'FR33551' => 'Villeneuve',
	'FR33552' => 'Virelade',
	'FR33553' => 'Virsac',
	'FR33554' => 'Yvrac',
	'FR33555' => 'Marcheprime',
	'FR34001' => 'Abeilhan',
	'FR34002' => 'Adissan',
	'FR34003' => 'Agde',
	'FR34004' => 'Agel',
	'FR34005' => 'Agonès',
	'FR34006' => 'Aigne',
	'FR34007' => 'Aigues-Vives',
	'FR34008' => 'Les Aires',
	'FR34009' => 'Alignan-du-Vent',
	'FR34010' => 'Aniane',
	'FR34011' => 'Arboras',
	'FR34012' => 'Argelliers',
	'FR34013' => 'Aspiran',
	'FR34014' => 'Assas',
	'FR34015' => 'Assignan',
	'FR34016' => 'Aumelas',
	'FR34017' => 'Aumes',
	'FR34018' => 'Autignac',
	'FR34019' => 'Avène',
	'FR34020' => 'Azillanet',
	'FR34021' => 'Babeau-Bouldoux',
	'FR34022' => 'Baillargues',
	'FR34023' => 'Balaruc-les-Bains',
	'FR34024' => 'Balaruc-le-Vieux',
	'FR34025' => 'Bassan',
	'FR34026' => 'Beaufort',
	'FR34027' => 'Beaulieu',
	'FR34028' => 'Bédarieux',
	'FR34029' => 'Bélarga',
	'FR34030' => 'Berlou',
	'FR34031' => 'Bessan',
	'FR34032' => 'Béziers',
	'FR34033' => 'Boisseron',
	'FR34034' => 'Boisset',
	'FR34035' => 'La Boissière',
	'FR34036' => 'Le Bosc',
	'FR34037' => 'Boujan-sur-Libron',
	'FR34038' => 'Le Bousquet-dOrb',
	'FR34039' => 'Bouzigues',
	'FR34040' => 'Brenas',
	'FR34041' => 'Brignac',
	'FR34042' => 'Brissac',
	'FR34043' => 'Buzignargues',
	'FR34044' => 'Cabrerolles',
	'FR34045' => 'Cabrières',
	'FR34046' => 'Cambon-et-Salvergues',
	'FR34047' => 'Campagnan',
	'FR34048' => 'Campagne',
	'FR34049' => 'Camplong',
	'FR34050' => 'Candillargues',
	'FR34051' => 'Canet',
	'FR34052' => 'Capestang',
	'FR34053' => 'Carlencas-et-Levas',
	'FR34054' => 'Cassagnoles',
	'FR34055' => 'Castanet-le-Haut',
	'FR34056' => 'Castelnau-de-Guers',
	'FR34057' => 'Castelnau-le-Lez',
	'FR34058' => 'Castries',
	'FR34059' => 'La Caunette',
	'FR34060' => 'Causse-de-la-Selle',
	'FR34061' => 'Causses-et-Veyran',
	'FR34062' => 'Caussiniojouls',
	'FR34063' => 'Caux',
	'FR34064' => 'Le Caylar',
	'FR34065' => 'Cazedarnes',
	'FR34066' => 'Cazevieille',
	'FR34067' => 'Cazilhac',
	'FR34068' => 'Cazouls-dHérault',
	'FR34069' => 'Cazouls-lès-Béziers',
	'FR34070' => 'Cébazan',
	'FR34071' => 'Ceilhes-et-Rocozels',
	'FR34072' => 'Celles',
	'FR34073' => 'Cers',
	'FR34074' => 'Cessenon-sur-Orb',
	'FR34075' => 'Cesseras',
	'FR34076' => 'Ceyras',
	'FR34077' => 'Clapiers',
	'FR34078' => 'Claret',
	'FR34079' => 'Clermont-lHérault',
	'FR34080' => 'Colombières-sur-Orb',
	'FR34081' => 'Colombiers',
	'FR34082' => 'Combaillaux',
	'FR34083' => 'Combes',
	'FR34084' => 'Corneilhan',
	'FR34085' => 'Coulobres',
	'FR34086' => 'Courniou',
	'FR34087' => 'Cournonsec',
	'FR34088' => 'Cournonterral',
	'FR34089' => 'Creissan',
	'FR34090' => 'Le Crès',
	'FR34091' => 'Le Cros',
	'FR34092' => 'Cruzy',
	'FR34093' => 'Dio-et-Valquières',
	'FR34094' => 'Espondeilhan',
	'FR34095' => 'Fabrègues',
	'FR34096' => 'Faugères',
	'FR34097' => 'Félines-Minervois',
	'FR34098' => 'Ferrals-les-Montagnes',
	'FR34099' => 'Ferrières-les-Verreries',
	'FR34100' => 'Ferrières-Poussarou',
	'FR34101' => 'Florensac',
	'FR34102' => 'Fontanès',
	'FR34103' => 'Fontès',
	'FR34104' => 'Fos',
	'FR34105' => 'Fouzilhon',
	'FR34106' => 'Fozières',
	'FR34107' => 'Fraisse-sur-Agout',
	'FR34108' => 'Frontignan',
	'FR34109' => 'Gabian',
	'FR34110' => 'Galargues',
	'FR34111' => 'Ganges',
	'FR34112' => 'Garrigues',
	'FR34113' => 'Gigean',
	'FR34114' => 'Gignac',
	'FR34115' => 'Gorniès',
	'FR34116' => 'Grabels',
	'FR34117' => 'Graissessac',
	'FR34118' => 'Guzargues',
	'FR34119' => 'Hérépian',
	'FR34120' => 'Jacou',
	'FR34121' => 'Joncels',
	'FR34122' => 'Jonquières',
	'FR34123' => 'Juvignac',
	'FR34124' => 'Lacoste',
	'FR34125' => 'Lagamas',
	'FR34126' => 'Lamalou-les-Bains',
	'FR34127' => 'Lansargues',
	'FR34128' => 'Laroque',
	'FR34129' => 'Lattes',
	'FR34130' => 'Laurens',
	'FR34131' => 'Lauret',
	'FR34132' => 'Lauroux',
	'FR34133' => 'Lavalette',
	'FR34134' => 'Lavérune',
	'FR34135' => 'Lespignan',
	'FR34136' => 'Lézignan-la-Cèbe',
	'FR34137' => 'Liausson',
	'FR34138' => 'Lieuran-Cabrières',
	'FR34139' => 'Lieuran-lès-Béziers',
	'FR34140' => 'Lignan-sur-Orb',
	'FR34141' => 'La Livinière',
	'FR34142' => 'Lodève',
	'FR34143' => 'Loupian',
	'FR34144' => 'Lunas',
	'FR34145' => 'Lunel',
	'FR34146' => 'Lunel-Viel',
	'FR34147' => 'Magalas',
	'FR34148' => 'Maraussan',
	'FR34149' => 'Margon',
	'FR34150' => 'Marseillan',
	'FR34151' => 'Marsillargues',
	'FR34152' => 'Mas-de-Londres',
	'FR34153' => 'Les Matelles',
	'FR34154' => 'Mauguio',
	'FR34155' => 'Maureilhan',
	'FR34156' => 'Mérifons',
	'FR34157' => 'Mèze',
	'FR34158' => 'Minerve',
	'FR34159' => 'Mireval',
	'FR34160' => 'Mons',
	'FR34161' => 'Montady',
	'FR34162' => 'Montagnac',
	'FR34163' => 'Montarnaud',
	'FR34164' => 'Montaud',
	'FR34165' => 'Montbazin',
	'FR34166' => 'Montblanc',
	'FR34167' => 'Montels',
	'FR34168' => 'Montesquieu',
	'FR34169' => 'Montferrier-sur-Lez',
	'FR34170' => 'Montouliers',
	'FR34171' => 'Montoulieu',
	'FR34172' => 'Montpellier',
	'FR34173' => 'Montpeyroux',
	'FR34174' => 'Moulès-et-Baucels',
	'FR34175' => 'Mourèze',
	'FR34176' => 'Mudaison',
	'FR34177' => 'Murles',
	'FR34178' => 'Murviel-lès-Béziers',
	'FR34179' => 'Murviel-lès-Montpellier',
	'FR34180' => 'Nébian',
	'FR34181' => 'Neffiès',
	'FR34182' => 'Nézignan-lÉvêque',
	'FR34183' => 'Nissan-lez-Enserune',
	'FR34184' => 'Nizas',
	'FR34185' => 'Notre-Dame-de-Londres',
	'FR34186' => 'Octon',
	'FR34187' => 'Olargues',
	'FR34188' => 'Olmet-et-Villecun',
	'FR34189' => 'Olonzac',
	'FR34190' => 'Oupia',
	'FR34191' => 'Pailhès',
	'FR34192' => 'Palavas-les-Flots',
	'FR34193' => 'Pardailhan',
	'FR34194' => 'Paulhan',
	'FR34195' => 'Pégairolles-de-Buèges',
	'FR34196' => 'Pégairolles-de-lEscalette',
	'FR34197' => 'Péret',
	'FR34198' => 'Pérols',
	'FR34199' => 'Pézenas',
	'FR34200' => 'Pézènes-les-Mines',
	'FR34201' => 'Pierrerue',
	'FR34202' => 'Pignan',
	'FR34203' => 'Pinet',
	'FR34204' => 'Plaissan',
	'FR34205' => 'Les Plans',
	'FR34206' => 'Poilhes',
	'FR34207' => 'Pomérols',
	'FR34208' => 'Popian',
	'FR34209' => 'Portiragnes',
	'FR34210' => 'Le Pouget',
	'FR34211' => 'Le Poujol-sur-Orb',
	'FR34212' => 'Poujols',
	'FR34213' => 'Poussan',
	'FR34214' => 'Pouzolles',
	'FR34215' => 'Pouzols',
	'FR34216' => 'Le Pradal',
	'FR34217' => 'Prades-le-Lez',
	'FR34218' => 'Prades-sur-Vernazobre',
	'FR34219' => 'Prémian',
	'FR34220' => 'Le Puech',
	'FR34221' => 'Puéchabon',
	'FR34222' => 'Puilacher',
	'FR34223' => 'Puimisson',
	'FR34224' => 'Puissalicon',
	'FR34225' => 'Puisserguier',
	'FR34226' => 'Quarante',
	'FR34227' => 'Restinclières',
	'FR34228' => 'Rieussec',
	'FR34229' => 'Riols',
	'FR34230' => 'Les Rives',
	'FR34231' => 'Romiguières',
	'FR34232' => 'Roquebrun',
	'FR34233' => 'Roqueredonde',
	'FR34234' => 'Roquessels',
	'FR34235' => 'Rosis',
	'FR34236' => 'Rouet',
	'FR34237' => 'Roujan',
	'FR34238' => 'Saint-André-de-Buèges',
	'FR34239' => 'Saint-André-de-Sangonis',
	'FR34240' => 'Saint-Aunès',
	'FR34241' => 'Saint-Bauzille-de-la-Sylve',
	'FR34242' => 'Saint-Bauzille-de-Montmel',
	'FR34243' => 'Saint-Bauzille-de-Putois',
	'FR34244' => 'Saint-Brès',
	'FR34245' => 'Saint-Chinian',
	'FR34246' => 'Entre-Vignes',
	'FR34247' => 'Saint-Clément-de-Rivière',
	'FR34248' => 'Sainte-Croix-de-Quintillargues',
	'FR34249' => 'Saint-Drézéry',
	'FR34250' => 'Saint-Étienne-dAlbagnan',
	'FR34251' => 'Saint-Étienne-de-Gourgas',
	'FR34252' => 'Saint-Étienne-Estréchoux',
	'FR34253' => 'Saint-Félix-de-lHéras',
	'FR34254' => 'Saint-Félix-de-Lodez',
	'FR34255' => 'Saint-Gély-du-Fesc',
	'FR34256' => 'Saint-Geniès-des-Mourgues',
	'FR34257' => 'Saint-Geniès-de-Varensal',
	'FR34258' => 'Saint-Geniès-de-Fontedit',
	'FR34259' => 'Saint-Georges-dOrques',
	'FR34260' => 'Saint-Gervais-sur-Mare',
	'FR34261' => 'Saint-Guilhem-le-Désert',
	'FR34262' => 'Saint-Guiraud',
	'FR34263' => 'Saint-Hilaire-de-Beauvoir',
	'FR34264' => 'Saint-Jean-de-Buèges',
	'FR34265' => 'Saint-Jean-de-Cornies',
	'FR34266' => 'Saint-Jean-de-Cuculles',
	'FR34267' => 'Saint-Jean-de-Fos',
	'FR34268' => 'Saint-Jean-de-la-Blaquière',
	'FR34269' => 'Saint-Jean-de-Minervois',
	'FR34270' => 'Saint-Jean-de-Védas',
	'FR34271' => 'Saint-Julien',
	'FR34272' => 'Saint-Just',
	'FR34273' => 'Saint-Martin-de-lArçon',
	'FR34274' => 'Saint-Martin-de-Londres',
	'FR34276' => 'Saint-Mathieu-de-Tréviers',
	'FR34277' => 'Saint-Maurice-Navacelles',
	'FR34278' => 'Saint-Michel',
	'FR34279' => 'Saint-Nazaire-de-Ladarez',
	'FR34280' => 'Saint-Nazaire-de-Pézan',
	'FR34281' => 'Saint-Pargoire',
	'FR34282' => 'Saint-Paul-et-Valmalle',
	'FR34283' => 'Saint-Pierre-de-la-Fage',
	'FR34284' => 'Saint-Pons-de-Thomières',
	'FR34285' => 'Saint-Pons-de-Mauchiens',
	'FR34286' => 'Saint-Privat',
	'FR34287' => 'Saint-Saturnin-de-Lucian',
	'FR34288' => 'Saint-Sériès',
	'FR34289' => 'Saint-Thibéry',
	'FR34290' => 'Saint-Vincent-de-Barbeyrargues',
	'FR34291' => 'Saint-Vincent-dOlargues',
	'FR34292' => 'Salasc',
	'FR34293' => 'La Salvetat-sur-Agout',
	'FR34294' => 'Saturargues',
	'FR34295' => 'Saussan',
	'FR34296' => 'Saussines',
	'FR34297' => 'Sauteyrargues',
	'FR34298' => 'Sauvian',
	'FR34299' => 'Sérignan',
	'FR34300' => 'Servian',
	'FR34301' => 'Sète',
	'FR34302' => 'Siran',
	'FR34303' => 'Sorbs',
	'FR34304' => 'Soubès',
	'FR34305' => 'Le Soulié',
	'FR34306' => 'Soumont',
	'FR34307' => 'Sussargues',
	'FR34308' => 'Taussac-la-Billière',
	'FR34309' => 'Teyran',
	'FR34310' => 'Thézan-lès-Béziers',
	'FR34311' => 'Tourbes',
	'FR34312' => 'La Tour-sur-Orb',
	'FR34313' => 'Tressan',
	'FR34314' => 'Le Triadou',
	'FR34315' => 'Usclas-dHérault',
	'FR34316' => 'Usclas-du-Bosc',
	'FR34317' => 'La Vacquerie-et-Saint-Martin-de-Castries',
	'FR34318' => 'Vacquières',
	'FR34319' => 'Vailhan',
	'FR34320' => 'Vailhauquès',
	'FR34321' => 'Valergues',
	'FR34322' => 'Valflaunès',
	'FR34323' => 'Valmascle',
	'FR34324' => 'Valras-Plage',
	'FR34325' => 'Valros',
	'FR34326' => 'Vélieux',
	'FR34327' => 'Vendargues',
	'FR34328' => 'Vendémian',
	'FR34329' => 'Vendres',
	'FR34331' => 'Verreries-de-Moussans',
	'FR34332' => 'Vias',
	'FR34333' => 'Vic-la-Gardiole',
	'FR34334' => 'Vieussan',
	'FR34335' => 'Villemagne-lArgentière',
	'FR34336' => 'Villeneuve-lès-Béziers',
	'FR34337' => 'Villeneuve-lès-Maguelone',
	'FR34338' => 'Villeneuvette',
	'FR34339' => 'Villespassans',
	'FR34340' => 'Villetelle',
	'FR34341' => 'Villeveyrac',
	'FR34342' => 'Viols-en-Laval',
	'FR34343' => 'Viols-le-Fort',
	'FR34344' => 'La Grande-Motte',
	'FR35001' => 'Acigné',
	'FR35002' => 'Amanlis',
	'FR35003' => 'Andouillé-Neuville',
	'FR35004' => 'Val-Couesnon',
	'FR35005' => 'Arbrissel',
	'FR35006' => 'Argentré-du-Plessis',
	'FR35007' => 'Aubigné',
	'FR35008' => 'Availles-sur-Seiche',
	'FR35009' => 'Baguer-Morvan',
	'FR35010' => 'Baguer-Pican',
	'FR35012' => 'Bain-de-Bretagne',
	'FR35013' => 'Bains-sur-Oust',
	'FR35014' => 'Bais',
	'FR35015' => 'Balazé',
	'FR35016' => 'Baulon',
	'FR35017' => 'La Baussaine',
	'FR35018' => 'La Bazouge-du-Désert',
	'FR35019' => 'Bazouges-la-Pérouse',
	'FR35021' => 'Beaucé',
	'FR35022' => 'Bécherel',
	'FR35023' => 'Bédée',
	'FR35024' => 'Betton',
	'FR35025' => 'Billé',
	'FR35026' => 'Bléruais',
	'FR35027' => 'Boisgervilly',
	'FR35028' => 'Boistrudan',
	'FR35029' => 'Bonnemain',
	'FR35030' => 'La Bosse-de-Bretagne',
	'FR35031' => 'La Bouëxière',
	'FR35032' => 'Bourgbarré',
	'FR35033' => 'Bourg-des-Comptes',
	'FR35034' => 'La Boussac',
	'FR35035' => 'Bovel',
	'FR35037' => 'Bréal-sous-Montfort',
	'FR35038' => 'Bréal-sous-Vitré',
	'FR35039' => 'Brécé',
	'FR35040' => 'Breteil',
	'FR35041' => 'Brie',
	'FR35042' => 'Brielles',
	'FR35044' => 'Broualan',
	'FR35045' => 'Bruc-sur-Aff',
	'FR35046' => 'Les Brulais',
	'FR35047' => 'Bruz',
	'FR35049' => 'Cancale',
	'FR35050' => 'Cardroc',
	'FR35051' => 'Cesson-Sévigné',
	'FR35052' => 'Champeaux',
	'FR35054' => 'Chanteloup',
	'FR35055' => 'Chantepie',
	'FR35056' => 'La Chapelle-aux-Filtzméens',
	'FR35057' => 'La Chapelle-Bouëxic',
	'FR35058' => 'La Chapelle-Chaussée',
	'FR35059' => 'La Chapelle-des-Fougeretz',
	'FR35060' => 'La Chapelle du Lou du Lac',
	'FR35061' => 'La Chapelle-Erbrée',
	'FR35062' => 'La Chapelle-Janson',
	'FR35063' => 'La Chapelle-Saint-Aubert',
	'FR35064' => 'La Chapelle-de-Brain',
	'FR35065' => 'La Chapelle-Thouarault',
	'FR35066' => 'Chartres-de-Bretagne',
	'FR35067' => 'Chasné-sur-Illet',
	'FR35068' => 'Châteaubourg',
	'FR35069' => 'Châteaugiron',
	'FR35070' => 'Châteauneuf-dIlle-et-Vilaine',
	'FR35071' => 'Le Châtellier',
	'FR35072' => 'Châtillon-en-Vendelais',
	'FR35075' => 'Chauvigné',
	'FR35076' => 'Chavagne',
	'FR35077' => 'Chelun',
	'FR35078' => 'Cherrueix',
	'FR35079' => 'Chevaigné',
	'FR35080' => 'Cintré',
	'FR35081' => 'Clayes',
	'FR35082' => 'Coësmes',
	'FR35084' => 'Comblessac',
	'FR35085' => 'Combourg',
	'FR35086' => 'Combourtillé',
	'FR35087' => 'Cornillé',
	'FR35088' => 'Corps-Nuds',
	'FR35089' => 'La Couyère',
	'FR35090' => 'Crevin',
	'FR35091' => 'Le Crouais',
	'FR35092' => 'Cuguen',
	'FR35093' => 'Dinard',
	'FR35094' => 'Dingé',
	'FR35095' => 'Dol-de-Bretagne',
	'FR35096' => 'Domagné',
	'FR35097' => 'Domalain',
	'FR35098' => 'La Dominelais',
	'FR35099' => 'Domloup',
	'FR35101' => 'Dourdain',
	'FR35102' => 'Drouges',
	'FR35103' => 'Eancé',
	'FR35104' => 'Epiniac',
	'FR35105' => 'Erbrée',
	'FR35106' => 'Ercé-en-Lamée',
	'FR35107' => 'Ercé-près-Liffré',
	'FR35108' => 'Essé',
	'FR35109' => 'Étrelles',
	'FR35110' => 'Feins',
	'FR35111' => 'Le Ferré',
	'FR35112' => 'Fleurigné',
	'FR35114' => 'Forges-la-Forêt',
	'FR35115' => 'Fougères',
	'FR35116' => 'La Fresnais',
	'FR35117' => 'Gaël',
	'FR35118' => 'Gahard',
	'FR35119' => 'Gennes-sur-Seiche',
	'FR35120' => 'Gévezé',
	'FR35121' => 'Gosné',
	'FR35122' => 'La Gouesnière',
	'FR35123' => 'Goven',
	'FR35124' => 'Grand-Fougeray',
	'FR35125' => 'La Guerche-de-Bretagne',
	'FR35126' => 'Guichen',
	'FR35127' => 'Guignen',
	'FR35128' => 'Guipel',
	'FR35130' => 'Hédé-Bazouges',
	'FR35131' => 'LHermitage',
	'FR35132' => 'Hirel',
	'FR35133' => 'Iffendic',
	'FR35134' => 'Les Iffs',
	'FR35135' => 'Irodouër',
	'FR35136' => 'Janzé',
	'FR35137' => 'Javené',
	'FR35138' => 'Laignelet',
	'FR35139' => 'Laillé',
	'FR35140' => 'Lalleu',
	'FR35141' => 'Landavran',
	'FR35142' => 'Landéan',
	'FR35143' => 'Landujan',
	'FR35144' => 'Langan',
	'FR35145' => 'Langon',
	'FR35146' => 'Langouet',
	'FR35148' => 'Lanrigan',
	'FR35149' => 'Lassy',
	'FR35150' => 'Lécousse',
	'FR35151' => 'Lieuron',
	'FR35152' => 'Liffré',
	'FR35153' => 'Lillemer',
	'FR35154' => 'Livré-sur-Changeon',
	'FR35155' => 'Lohéac',
	'FR35156' => 'Longaulnay',
	'FR35157' => 'Le Loroux',
	'FR35159' => 'Lourmais',
	'FR35160' => 'Loutehel',
	'FR35161' => 'Louvigné-de-Bais',
	'FR35162' => 'Louvigné-du-Désert',
	'FR35163' => 'Luitré-Dompierre',
	'FR35164' => 'Marcillé-Raoul',
	'FR35165' => 'Marcillé-Robert',
	'FR35166' => 'Marpiré',
	'FR35167' => 'Martigné-Ferchaud',
	'FR35168' => 'Val dAnast',
	'FR35169' => 'Maxent',
	'FR35170' => 'Mecé',
	'FR35171' => 'Médréac',
	'FR35172' => 'Meillac',
	'FR35173' => 'Melesse',
	'FR35174' => 'Mellé',
	'FR35175' => 'Mernel',
	'FR35176' => 'Guipry-Messac',
	'FR35177' => 'La Mézière',
	'FR35178' => 'Mézières-sur-Couesnon',
	'FR35179' => 'Miniac-Morvan',
	'FR35180' => 'Miniac-sous-Bécherel',
	'FR35181' => 'Le Minihic-sur-Rance',
	'FR35183' => 'Mondevert',
	'FR35184' => 'Montauban-de-Bretagne',
	'FR35185' => 'Montautour',
	'FR35186' => 'Mont-Dol',
	'FR35187' => 'Monterfil',
	'FR35188' => 'Montfort-sur-Meu',
	'FR35189' => 'Montgermont',
	'FR35190' => 'Monthault',
	'FR35191' => 'Les Portes du Coglais',
	'FR35192' => 'Montreuil-des-Landes',
	'FR35193' => 'Montreuil-le-Gast',
	'FR35194' => 'Montreuil-sous-Pérouse',
	'FR35195' => 'Montreuil-sur-Ille',
	'FR35196' => 'Mordelles',
	'FR35197' => 'Mouazé',
	'FR35198' => 'Moulins',
	'FR35199' => 'Moussé',
	'FR35200' => 'Moutiers',
	'FR35201' => 'Muel',
	'FR35202' => 'La Noë-Blanche',
	'FR35203' => 'La Nouaye',
	'FR35204' => 'Nouvoitou',
	'FR35205' => 'Noyal-sous-Bazouges',
	'FR35206' => 'Noyal-Châtillon-sur-Seiche',
	'FR35207' => 'Noyal-sur-Vilaine',
	'FR35208' => 'Orgères',
	'FR35210' => 'Pacé',
	'FR35211' => 'Paimpont',
	'FR35212' => 'Pancé',
	'FR35214' => 'Parcé',
	'FR35215' => 'Parigné',
	'FR35216' => 'Parthenay-de-Bretagne',
	'FR35217' => 'Le Pertre',
	'FR35218' => 'Le Petit-Fougeray',
	'FR35219' => 'Pipriac',
	'FR35220' => 'Piré-Chancé',
	'FR35221' => 'Pléchâtel',
	'FR35222' => 'Pleine-Fougères',
	'FR35223' => 'Plélan-le-Grand',
	'FR35224' => 'Plerguer',
	'FR35225' => 'Plesder',
	'FR35226' => 'Pleugueneuc',
	'FR35227' => 'Pleumeleuc',
	'FR35228' => 'Pleurtuit',
	'FR35229' => 'Pocé-les-Bois',
	'FR35230' => 'Poilley',
	'FR35231' => 'Poligné',
	'FR35232' => 'Princé',
	'FR35233' => 'Québriac',
	'FR35234' => 'Quédillac',
	'FR35235' => 'Rannée',
	'FR35236' => 'Redon',
	'FR35237' => 'Renac',
	'FR35238' => 'Rennes',
	'FR35239' => 'Retiers',
	'FR35240' => 'Le Rheu',
	'FR35241' => 'La Richardais',
	'FR35242' => 'Rimou',
	'FR35243' => 'Romagné',
	'FR35244' => 'Romazy',
	'FR35245' => 'Romillé',
	'FR35246' => 'Roz-Landrieux',
	'FR35247' => 'Roz-sur-Couesnon',
	'FR35248' => 'Sains',
	'FR35249' => 'Sainte-Anne-sur-Vilaine',
	'FR35250' => 'Saint-Armel',
	'FR35251' => 'Saint-Aubin-dAubigné',
	'FR35252' => 'Saint-Aubin-des-Landes',
	'FR35253' => 'Saint-Aubin-du-Cormier',
	'FR35255' => 'Saint-Benoît-des-Ondes',
	'FR35256' => 'Saint-Briac-sur-Mer',
	'FR35257' => 'Maen Roch',
	'FR35258' => 'Saint-Brieuc-des-Iffs',
	'FR35259' => 'Saint-Broladre',
	'FR35260' => 'Saint-Christophe-des-Bois',
	'FR35261' => 'Saint-Christophe-de-Valains',
	'FR35262' => 'Sainte-Colombe',
	'FR35263' => 'Saint-Coulomb',
	'FR35264' => 'Saint-Didier',
	'FR35265' => 'Saint-Domineuc',
	'FR35266' => 'Saint-Erblon',
	'FR35268' => 'Saint-Ganton',
	'FR35270' => 'Saint-Georges-de-Gréhaigne',
	'FR35271' => 'Saint-Georges-de-Reintembault',
	'FR35272' => 'Saint-Germain-du-Pinel',
	'FR35273' => 'Saint-Germain-en-Coglès',
	'FR35274' => 'Saint-Germain-sur-Ille',
	'FR35275' => 'Saint-Gilles',
	'FR35276' => 'Saint-Gondran',
	'FR35277' => 'Saint-Gonlay',
	'FR35278' => 'Saint-Grégoire',
	'FR35279' => 'Saint-Guinoux',
	'FR35280' => 'Saint-Hilaire-des-Landes',
	'FR35281' => 'Saint-Jacques-de-la-Lande',
	'FR35282' => 'Rives-du-Couesnon',
	'FR35283' => 'Saint-Jean-sur-Vilaine',
	'FR35284' => 'Saint-Jouan-des-Guérets',
	'FR35285' => 'Saint-Just',
	'FR35286' => 'Saint-Léger-des-Prés',
	'FR35287' => 'Saint-Lunaire',
	'FR35288' => 'Saint-Malo',
	'FR35289' => 'Saint-Malo-de-Phily',
	'FR35290' => 'Saint-Malon-sur-Mel',
	'FR35291' => 'Saint-Marcan',
	'FR35292' => 'Saint-Marc-le-Blanc',
	'FR35294' => 'Sainte-Marie',
	'FR35295' => 'Saint-Maugan',
	'FR35296' => 'Saint-Médard-sur-Ille',
	'FR35297' => 'Saint-Méen-le-Grand',
	'FR35299' => 'Saint-Méloir-des-Ondes',
	'FR35300' => 'Saint-MHervé',
	'FR35302' => 'Saint-Onen-la-Chapelle',
	'FR35304' => 'Saint-Ouen-des-Alleux',
	'FR35305' => 'Saint-Péran',
	'FR35306' => 'Saint-Père-Marc-en-Poulet',
	'FR35307' => 'Saint-Pern',
	'FR35308' => 'Mesnil-Roch',
	'FR35309' => 'Saint-Rémy-du-Plain',
	'FR35310' => 'Saint-Sauveur-des-Landes',
	'FR35311' => 'Saint-Séglin',
	'FR35312' => 'Saint-Senoux',
	'FR35314' => 'Saint-Suliac',
	'FR35315' => 'Saint-Sulpice-la-Forêt',
	'FR35316' => 'Saint-Sulpice-des-Landes',
	'FR35317' => 'Saint-Symphorien',
	'FR35318' => 'Saint-Thual',
	'FR35319' => 'Saint-Thurial',
	'FR35320' => 'Saint-Uniac',
	'FR35321' => 'Saulnières',
	'FR35322' => 'Le Sel-de-Bretagne',
	'FR35324' => 'La Selle-en-Luitré',
	'FR35325' => 'La Selle-Guerchaise',
	'FR35326' => 'Sens-de-Bretagne',
	'FR35327' => 'Servon-sur-Vilaine',
	'FR35328' => 'Sixt-sur-Aff',
	'FR35329' => 'Sougéal',
	'FR35330' => 'Taillis',
	'FR35331' => 'Talensac',
	'FR35332' => 'Teillay',
	'FR35333' => 'Le Theil-de-Bretagne',
	'FR35334' => 'Thorigné-Fouillard',
	'FR35335' => 'Thourie',
	'FR35336' => 'Le Tiercent',
	'FR35337' => 'Tinténiac',
	'FR35338' => 'Torcé',
	'FR35339' => 'Trans-la-Forêt',
	'FR35340' => 'Treffendel',
	'FR35342' => 'Trémeheuc',
	'FR35343' => 'Tresbœuf',
	'FR35345' => 'Trévérien',
	'FR35346' => 'Trimer',
	'FR35347' => 'Val-dIzé',
	'FR35350' => 'Vergéal',
	'FR35351' => 'Le Verger',
	'FR35352' => 'Vern-sur-Seiche',
	'FR35353' => 'Vezin-le-Coquet',
	'FR35354' => 'Vieux-Viel',
	'FR35355' => 'Vieux-Vy-sur-Couesnon',
	'FR35356' => 'Vignoc',
	'FR35357' => 'Villamée',
	'FR35358' => 'La Ville-ès-Nonais',
	'FR35359' => 'Visseiche',
	'FR35360' => 'Vitré',
	'FR35361' => 'Le Vivier-sur-Mer',
	'FR35362' => 'Le Tronchet',
	'FR35363' => 'Pont-Péan',
	'FR36001' => 'Aigurande',
	'FR36002' => 'Aize',
	'FR36003' => 'Ambrault',
	'FR36004' => 'Anjouin',
	'FR36005' => 'Ardentes',
	'FR36006' => 'Argenton-sur-Creuse',
	'FR36007' => 'Argy',
	'FR36008' => 'Arpheuilles',
	'FR36009' => 'Arthon',
	'FR36010' => 'Azay-le-Ferron',
	'FR36011' => 'Bagneux',
	'FR36012' => 'Baraize',
	'FR36013' => 'Baudres',
	'FR36014' => 'Bazaiges',
	'FR36015' => 'Beaulieu',
	'FR36016' => 'Bélâbre',
	'FR36017' => 'La Berthenoux',
	'FR36018' => 'Le Blanc',
	'FR36019' => 'Bommiers',
	'FR36020' => 'Bonneuil',
	'FR36021' => 'Les Bordes',
	'FR36022' => 'Bouesse',
	'FR36023' => 'Bouges-le-Château',
	'FR36024' => 'Bretagne',
	'FR36025' => 'Briantes',
	'FR36026' => 'Brion',
	'FR36027' => 'Brives',
	'FR36028' => 'La Buxerette',
	'FR36029' => 'Buxeuil',
	'FR36030' => 'Buxières-dAillac',
	'FR36031' => 'Buzançais',
	'FR36032' => 'Ceaulmont',
	'FR36033' => 'Celon',
	'FR36034' => 'Chabris',
	'FR36035' => 'Chaillac',
	'FR36036' => 'Chalais',
	'FR36037' => 'La Champenoise',
	'FR36038' => 'Champillet',
	'FR36040' => 'La Chapelle-Orthemale',
	'FR36041' => 'La Chapelle-Saint-Laurian',
	'FR36042' => 'Chasseneuil',
	'FR36043' => 'Chassignolles',
	'FR36044' => 'Châteauroux',
	'FR36045' => 'Châtillon-sur-Indre',
	'FR36046' => 'La Châtre',
	'FR36047' => 'La Châtre-Langlin',
	'FR36048' => 'Chavin',
	'FR36049' => 'Chazelet',
	'FR36050' => 'Chezelles',
	'FR36051' => 'Chitray',
	'FR36052' => 'Chouday',
	'FR36053' => 'Ciron',
	'FR36054' => 'Cléré-du-Bois',
	'FR36055' => 'Clion',
	'FR36056' => 'Cluis',
	'FR36057' => 'Coings',
	'FR36058' => 'Concremiers',
	'FR36059' => 'Condé',
	'FR36060' => 'Crevant',
	'FR36061' => 'Crozon-sur-Vauvre',
	'FR36062' => 'Cuzion',
	'FR36063' => 'Déols',
	'FR36064' => 'Diors',
	'FR36065' => 'Diou',
	'FR36066' => 'Douadic',
	'FR36067' => 'Dunet',
	'FR36068' => 'Dun-le-Poëlier',
	'FR36069' => 'Écueillé',
	'FR36070' => 'Éguzon-Chantôme',
	'FR36071' => 'Étrechet',
	'FR36073' => 'Feusines',
	'FR36074' => 'Fléré-la-Rivière',
	'FR36075' => 'Fontenay',
	'FR36076' => 'Fontgombault',
	'FR36077' => 'Fontguenand',
	'FR36078' => 'Fougerolles',
	'FR36079' => 'Francillon',
	'FR36080' => 'Frédille',
	'FR36081' => 'Gargilesse-Dampierre',
	'FR36082' => 'Gehée',
	'FR36083' => 'Giroux',
	'FR36084' => 'Gournay',
	'FR36085' => 'Guilly',
	'FR36086' => 'Heugnes',
	'FR36087' => 'Ingrandes',
	'FR36088' => 'Issoudun',
	'FR36089' => 'Jeu-les-Bois',
	'FR36090' => 'Jeu-Maloches',
	'FR36091' => 'Lacs',
	'FR36092' => 'Langé',
	'FR36093' => 'Levroux',
	'FR36094' => 'Lignac',
	'FR36095' => 'Lignerolles',
	'FR36096' => 'Lingé',
	'FR36097' => 'Liniez',
	'FR36098' => 'Lizeray',
	'FR36099' => 'Lourdoueix-Saint-Michel',
	'FR36100' => 'Lourouer-Saint-Laurent',
	'FR36101' => 'Luant',
	'FR36102' => 'Luçay-le-Libre',
	'FR36103' => 'Luçay-le-Mâle',
	'FR36104' => 'Lurais',
	'FR36105' => 'Lureuil',
	'FR36106' => 'Luzeret',
	'FR36107' => 'Lye',
	'FR36108' => 'Lys-Saint-Georges',
	'FR36109' => 'Le Magny',
	'FR36110' => 'Maillet',
	'FR36111' => 'Malicornay',
	'FR36112' => 'Mâron',
	'FR36113' => 'Martizay',
	'FR36114' => 'Mauvières',
	'FR36115' => 'Menetou-sur-Nahon',
	'FR36116' => 'Ménétréols-sous-Vatan',
	'FR36117' => 'Le Menoux',
	'FR36118' => 'Méobecq',
	'FR36119' => 'Mérigny',
	'FR36120' => 'Mers-sur-Indre',
	'FR36121' => 'Meunet-Planches',
	'FR36122' => 'Meunet-sur-Vatan',
	'FR36123' => 'Mézières-en-Brenne',
	'FR36124' => 'Migné',
	'FR36125' => 'Migny',
	'FR36126' => 'Montchevrier',
	'FR36127' => 'Montgivray',
	'FR36128' => 'Montierchaume',
	'FR36129' => 'Montipouret',
	'FR36130' => 'Montlevicq',
	'FR36131' => 'Mosnay',
	'FR36132' => 'La Motte-Feuilly',
	'FR36133' => 'Mouhers',
	'FR36134' => 'Mouhet',
	'FR36135' => 'Moulins-sur-Céphons',
	'FR36136' => 'Murs',
	'FR36137' => 'Néons-sur-Creuse',
	'FR36138' => 'Néret',
	'FR36139' => 'Neuillay-les-Bois',
	'FR36140' => 'Neuvy-Pailloux',
	'FR36141' => 'Neuvy-Saint-Sépulchre',
	'FR36142' => 'Niherne',
	'FR36143' => 'Nohant-Vic',
	'FR36144' => 'Nuret-le-Ferron',
	'FR36145' => 'Obterre',
	'FR36146' => 'Orsennes',
	'FR36147' => 'Orville',
	'FR36148' => 'Oulches',
	'FR36149' => 'Palluau-sur-Indre',
	'FR36150' => 'Parnac',
	'FR36152' => 'Paudy',
	'FR36153' => 'Paulnay',
	'FR36154' => 'Le Pêchereau',
	'FR36155' => 'Pellevoisin',
	'FR36156' => 'Pérassay',
	'FR36157' => 'La Pérouille',
	'FR36158' => 'Badecon-le-Pin',
	'FR36159' => 'Le Poinçonnet',
	'FR36160' => 'Pommiers',
	'FR36161' => 'Le Pont-Chrétien-Chabenet',
	'FR36162' => 'Poulaines',
	'FR36163' => 'Pouligny-Notre-Dame',
	'FR36164' => 'Pouligny-Saint-Martin',
	'FR36165' => 'Pouligny-Saint-Pierre',
	'FR36166' => 'Préaux',
	'FR36167' => 'Preuilly-la-Ville',
	'FR36168' => 'Prissac',
	'FR36169' => 'Pruniers',
	'FR36170' => 'Reboursin',
	'FR36171' => 'Reuilly',
	'FR36172' => 'Rivarennes',
	'FR36173' => 'Rosnay',
	'FR36174' => 'Roussines',
	'FR36175' => 'Rouvres-les-Bois',
	'FR36176' => 'Ruffec',
	'FR36177' => 'Sacierges-Saint-Martin',
	'FR36178' => 'Saint-Aigny',
	'FR36179' => 'Saint-Aoustrille',
	'FR36180' => 'Saint-Août',
	'FR36181' => 'Saint-Aubin',
	'FR36182' => 'Saint-Benoît-du-Sault',
	'FR36184' => 'Saint-Chartier',
	'FR36185' => 'Saint-Christophe-en-Bazelle',
	'FR36186' => 'Saint-Christophe-en-Boucherie',
	'FR36187' => 'Saint-Civran',
	'FR36188' => 'Saint-Cyran-du-Jambot',
	'FR36189' => 'Saint-Denis-de-Jouhet',
	'FR36190' => 'Sainte-Fauste',
	'FR36191' => 'Saint-Florentin',
	'FR36192' => 'Saint-Gaultier',
	'FR36193' => 'Sainte-Gemme',
	'FR36194' => 'Saint-Genou',
	'FR36195' => 'Saint-Georges-sur-Arnon',
	'FR36196' => 'Saint-Gilles',
	'FR36197' => 'Saint-Hilaire-sur-Benaize',
	'FR36198' => 'Saint-Lactencin',
	'FR36199' => 'Sainte-Lizaigne',
	'FR36200' => 'Saint-Marcel',
	'FR36202' => 'Saint-Maur',
	'FR36203' => 'Saint-Médard',
	'FR36204' => 'Saint-Michel-en-Brenne',
	'FR36205' => 'Saint-Pierre-de-Jards',
	'FR36207' => 'Saint-Plantaire',
	'FR36208' => 'Sainte-Sévère-sur-Indre',
	'FR36209' => 'Saint-Valentin',
	'FR36210' => 'Sarzay',
	'FR36211' => 'Sassierges-Saint-Germain',
	'FR36212' => 'Saulnay',
	'FR36213' => 'Sauzelles',
	'FR36214' => 'Sazeray',
	'FR36215' => 'Ségry',
	'FR36216' => 'Selles-sur-Nahon',
	'FR36217' => 'Sembleçay',
	'FR36218' => 'Sougé',
	'FR36219' => 'Tendu',
	'FR36220' => 'Thenay',
	'FR36221' => 'Thevet-Saint-Julien',
	'FR36222' => 'Thizay',
	'FR36223' => 'Tilly',
	'FR36224' => 'Tournon-Saint-Martin',
	'FR36225' => 'Le Tranger',
	'FR36226' => 'Tranzault',
	'FR36227' => 'Urciers',
	'FR36228' => 'Valençay',
	'FR36229' => 'Val-Fouzon',
	'FR36230' => 'Vatan',
	'FR36231' => 'Velles',
	'FR36232' => 'Vendœuvres',
	'FR36233' => 'La Vernelle',
	'FR36234' => 'Verneuil-sur-Igneraie',
	'FR36235' => 'Veuil',
	'FR36236' => 'Vicq-Exemplet',
	'FR36237' => 'Vicq-sur-Nahon',
	'FR36238' => 'Vigoulant',
	'FR36239' => 'Vigoux',
	'FR36240' => 'Vijon',
	'FR36241' => 'Villedieu-sur-Indre',
	'FR36242' => 'Villegongis',
	'FR36243' => 'Villegouin',
	'FR36244' => 'Villentrois-Faverolles-en-Berry',
	'FR36246' => 'Villiers',
	'FR36247' => 'Vineuil',
	'FR36248' => 'Vouillon',
	'FR37001' => 'Abilly',
	'FR37002' => 'Ambillou',
	'FR37003' => 'Amboise',
	'FR37004' => 'Anché',
	'FR37005' => 'Antogny-le-Tillac',
	'FR37006' => 'Artannes-sur-Indre',
	'FR37007' => 'Assay',
	'FR37008' => 'Athée-sur-Cher',
	'FR37009' => 'Autrèche',
	'FR37010' => 'Auzouer-en-Touraine',
	'FR37011' => 'Avoine',
	'FR37012' => 'Avon-les-Roches',
	'FR37013' => 'Avrillé-les-Ponceaux',
	'FR37014' => 'Azay-le-Rideau',
	'FR37015' => 'Azay-sur-Cher',
	'FR37016' => 'Azay-sur-Indre',
	'FR37018' => 'Ballan-Miré',
	'FR37019' => 'Barrou',
	'FR37020' => 'Beaulieu-lès-Loches',
	'FR37021' => 'Beaumont-Louestault',
	'FR37022' => 'Beaumont-en-Véron',
	'FR37023' => 'Beaumont-Village',
	'FR37024' => 'Benais',
	'FR37025' => 'Berthenay',
	'FR37026' => 'Betz-le-Château',
	'FR37027' => 'Bléré',
	'FR37028' => 'Bossay-sur-Claise',
	'FR37029' => 'Bossée',
	'FR37030' => 'Le Boulay',
	'FR37031' => 'Bourgueil',
	'FR37032' => 'Bournan',
	'FR37033' => 'Boussay',
	'FR37034' => 'Braslou',
	'FR37035' => 'Braye-sous-Faye',
	'FR37036' => 'Braye-sur-Maulne',
	'FR37037' => 'Brèches',
	'FR37038' => 'Bréhémont',
	'FR37039' => 'Bridoré',
	'FR37040' => 'Brizay',
	'FR37041' => 'Bueil-en-Touraine',
	'FR37042' => 'Candes-Saint-Martin',
	'FR37043' => 'Cangey',
	'FR37044' => 'La Celle-Guenand',
	'FR37045' => 'La Celle-Saint-Avant',
	'FR37046' => 'Céré-la-Ronde',
	'FR37047' => 'Cerelles',
	'FR37048' => 'Chambon',
	'FR37049' => 'Chambourg-sur-Indre',
	'FR37050' => 'Chambray-lès-Tours',
	'FR37051' => 'Champigny-sur-Veude',
	'FR37052' => 'Chançay',
	'FR37053' => 'Chanceaux-près-Loches',
	'FR37054' => 'Chanceaux-sur-Choisille',
	'FR37055' => 'Channay-sur-Lathan',
	'FR37056' => 'La Chapelle-aux-Naux',
	'FR37057' => 'La Chapelle-Blanche-Saint-Martin',
	'FR37058' => 'La Chapelle-sur-Loire',
	'FR37059' => 'Charentilly',
	'FR37060' => 'Chargé',
	'FR37061' => 'Charnizay',
	'FR37062' => 'Château-la-Vallière',
	'FR37063' => 'Château-Renault',
	'FR37064' => 'Chaumussay',
	'FR37065' => 'Chaveignes',
	'FR37066' => 'Chédigny',
	'FR37067' => 'Cheillé',
	'FR37068' => 'Chemillé-sur-Dême',
	'FR37069' => 'Chemillé-sur-Indrois',
	'FR37070' => 'Chenonceaux',
	'FR37071' => 'Chezelles',
	'FR37072' => 'Chinon',
	'FR37073' => 'Chisseaux',
	'FR37074' => 'Chouzé-sur-Loire',
	'FR37075' => 'Cigogné',
	'FR37076' => 'Cinais',
	'FR37077' => 'Cinq-Mars-la-Pile',
	'FR37078' => 'Ciran',
	'FR37079' => 'Civray-de-Touraine',
	'FR37080' => 'Civray-sur-Esves',
	'FR37081' => 'Cléré-les-Pins',
	'FR37082' => 'Continvoir',
	'FR37083' => 'Cormery',
	'FR37084' => 'Couesmes',
	'FR37085' => 'Courçay',
	'FR37086' => 'Courcelles-de-Touraine',
	'FR37087' => 'Courcoué',
	'FR37088' => 'Couziers',
	'FR37089' => 'Cravant-les-Côteaux',
	'FR37090' => 'Crissay-sur-Manse',
	'FR37091' => 'La Croix-en-Touraine',
	'FR37092' => 'Crotelles',
	'FR37093' => 'Crouzilles',
	'FR37094' => 'Cussay',
	'FR37095' => 'Dame-Marie-les-Bois',
	'FR37096' => 'Dierre',
	'FR37097' => 'Dolus-le-Sec',
	'FR37098' => 'Draché',
	'FR37099' => 'Druye',
	'FR37100' => 'Épeigné-les-Bois',
	'FR37101' => 'Épeigné-sur-Dême',
	'FR37103' => 'Esves-le-Moutier',
	'FR37104' => 'Esvres',
	'FR37105' => 'Faye-la-Vineuse',
	'FR37106' => 'La Ferrière',
	'FR37107' => 'Ferrière-Larçon',
	'FR37108' => 'Ferrière-sur-Beaulieu',
	'FR37109' => 'Fondettes',
	'FR37110' => 'Francueil',
	'FR37111' => 'Genillé',
	'FR37112' => 'Gizeux',
	'FR37113' => 'Le Grand-Pressigny',
	'FR37114' => 'La Guerche',
	'FR37115' => 'Descartes',
	'FR37116' => 'Les Hermites',
	'FR37117' => 'Hommes',
	'FR37118' => 'Huismes',
	'FR37119' => 'LÎle-Bouchard',
	'FR37121' => 'Jaulnay',
	'FR37122' => 'Joué-lès-Tours',
	'FR37123' => 'Langeais',
	'FR37124' => 'Larçay',
	'FR37125' => 'Lémeré',
	'FR37126' => 'Lerné',
	'FR37127' => 'Le Liège',
	'FR37128' => 'Lignières-de-Touraine',
	'FR37129' => 'Ligré',
	'FR37130' => 'Ligueil',
	'FR37131' => 'Limeray',
	'FR37132' => 'Loches',
	'FR37133' => 'Loché-sur-Indrois',
	'FR37134' => 'Louans',
	'FR37136' => 'Le Louroux',
	'FR37137' => 'Lublé',
	'FR37138' => 'Lussault-sur-Loire',
	'FR37139' => 'Luynes',
	'FR37140' => 'Luzé',
	'FR37141' => 'Luzillé',
	'FR37142' => 'Maillé',
	'FR37143' => 'Manthelan',
	'FR37144' => 'Marçay',
	'FR37145' => 'Marcé-sur-Esves',
	'FR37146' => 'Marcilly-sur-Maulne',
	'FR37147' => 'Marcilly-sur-Vienne',
	'FR37148' => 'Marigny-Marmande',
	'FR37149' => 'Marray',
	'FR37150' => 'Mazières-de-Touraine',
	'FR37151' => 'La Membrolle-sur-Choisille',
	'FR37152' => 'Mettray',
	'FR37153' => 'Monnaie',
	'FR37154' => 'Montbazon',
	'FR37155' => 'Monthodon',
	'FR37156' => 'Montlouis-sur-Loire',
	'FR37157' => 'Montrésor',
	'FR37158' => 'Montreuil-en-Touraine',
	'FR37159' => 'Monts',
	'FR37160' => 'Morand',
	'FR37161' => 'Mosnes',
	'FR37162' => 'Mouzay',
	'FR37163' => 'Nazelles-Négron',
	'FR37165' => 'Neuil',
	'FR37166' => 'Neuillé-le-Lierre',
	'FR37167' => 'Neuillé-Pont-Pierre',
	'FR37168' => 'Neuilly-le-Brignon',
	'FR37169' => 'Neuville-sur-Brenne',
	'FR37170' => 'Neuvy-le-Roi',
	'FR37171' => 'Noizay',
	'FR37172' => 'Notre-Dame-dOé',
	'FR37173' => 'Nouans-les-Fontaines',
	'FR37174' => 'Nouâtre',
	'FR37175' => 'Nouzilly',
	'FR37176' => 'Noyant-de-Touraine',
	'FR37177' => 'Orbigny',
	'FR37178' => 'Panzoult',
	'FR37179' => 'Parçay-Meslay',
	'FR37180' => 'Parçay-sur-Vienne',
	'FR37181' => 'Paulmy',
	'FR37182' => 'Pernay',
	'FR37183' => 'Perrusson',
	'FR37184' => 'Le Petit-Pressigny',
	'FR37185' => 'Pocé-sur-Cisse',
	'FR37186' => 'Pont-de-Ruan',
	'FR37187' => 'Ports',
	'FR37188' => 'Pouzay',
	'FR37189' => 'Preuilly-sur-Claise',
	'FR37190' => 'Pussigny',
	'FR37191' => 'Razines',
	'FR37192' => 'Reignac-sur-Indre',
	'FR37193' => 'Restigné',
	'FR37194' => 'Reugny',
	'FR37195' => 'La Riche',
	'FR37196' => 'Richelieu',
	'FR37197' => 'Rigny-Ussé',
	'FR37198' => 'Rillé',
	'FR37199' => 'Rilly-sur-Vienne',
	'FR37200' => 'Rivarennes',
	'FR37201' => 'Rivière',
	'FR37202' => 'La Roche-Clermault',
	'FR37203' => 'Rochecorbon',
	'FR37204' => 'Rouziers-de-Touraine',
	'FR37205' => 'Saché',
	'FR37206' => 'Saint-Antoine-du-Rocher',
	'FR37207' => 'Saint-Aubin-le-Dépeint',
	'FR37208' => 'Saint-Avertin',
	'FR37210' => 'Saint-Benoît-la-Forêt',
	'FR37211' => 'Saint-Branchs',
	'FR37212' => 'Sainte-Catherine-de-Fierbois',
	'FR37213' => 'Saint-Christophe-sur-le-Nais',
	'FR37214' => 'Saint-Cyr-sur-Loire',
	'FR37216' => 'Saint-Épain',
	'FR37217' => 'Saint-Étienne-de-Chigny',
	'FR37218' => 'Saint-Flovier',
	'FR37219' => 'Saint-Genouph',
	'FR37220' => 'Saint-Germain-sur-Vienne',
	'FR37221' => 'Saint-Hippolyte',
	'FR37222' => 'Saint-Jean-Saint-Germain',
	'FR37223' => 'Saint-Laurent-de-Lin',
	'FR37224' => 'Saint-Laurent-en-Gâtines',
	'FR37225' => 'Saint-Martin-le-Beau',
	'FR37226' => 'Sainte-Maure-de-Touraine',
	'FR37228' => 'Saint-Nicolas-de-Bourgueil',
	'FR37229' => 'Saint-Nicolas-des-Motets',
	'FR37230' => 'Saint-Ouen-les-Vignes',
	'FR37231' => 'Saint-Paterne-Racan',
	'FR37232' => 'Coteaux-sur-Loire',
	'FR37233' => 'Saint-Pierre-des-Corps',
	'FR37234' => 'Saint-Quentin-sur-Indrois',
	'FR37236' => 'Saint-Règle',
	'FR37237' => 'Saint-Roch',
	'FR37238' => 'Saint-Senoch',
	'FR37240' => 'Saunay',
	'FR37241' => 'Savigné-sur-Lathan',
	'FR37242' => 'Savigny-en-Véron',
	'FR37243' => 'Savonnières',
	'FR37244' => 'Sazilly',
	'FR37245' => 'Semblançay',
	'FR37246' => 'Sennevières',
	'FR37247' => 'Sepmes',
	'FR37248' => 'Seuilly',
	'FR37249' => 'Sonzay',
	'FR37250' => 'Sorigny',
	'FR37251' => 'Souvigné',
	'FR37252' => 'Souvigny-de-Touraine',
	'FR37253' => 'Sublaines',
	'FR37254' => 'Tauxigny-Saint-Bauld',
	'FR37255' => 'Tavant',
	'FR37256' => 'Theneuil',
	'FR37257' => 'Thilouze',
	'FR37258' => 'Thizay',
	'FR37259' => 'Tournon-Saint-Pierre',
	'FR37260' => 'La Tour-Saint-Gelin',
	'FR37261' => 'Tours',
	'FR37262' => 'Trogues',
	'FR37263' => 'Truyes',
	'FR37264' => 'Vallères',
	'FR37265' => 'Varennes',
	'FR37266' => 'Veigné',
	'FR37267' => 'Véretz',
	'FR37268' => 'Verneuil-le-Château',
	'FR37269' => 'Verneuil-sur-Indre',
	'FR37270' => 'Vernou-sur-Brenne',
	'FR37271' => 'Villaines-les-Rochers',
	'FR37272' => 'Villandry',
	'FR37273' => 'La Ville-aux-Dames',
	'FR37274' => 'Villebourg',
	'FR37275' => 'Villedômain',
	'FR37276' => 'Villedômer',
	'FR37277' => 'Villeloin-Coulangé',
	'FR37278' => 'Villeperdue',
	'FR37279' => 'Villiers-au-Bouin',
	'FR37280' => 'Vou',
	'FR37281' => 'Vouvray',
	'FR37282' => 'Yzeures-sur-Creuse',
	'FR38001' => 'Les Abrets en Dauphiné',
	'FR38002' => 'Les Adrets',
	'FR38003' => 'Agnin',
	'FR38004' => 'LAlbenc',
	'FR38005' => 'Allemond',
	'FR38006' => 'Allevard',
	'FR38008' => 'Ambel',
	'FR38009' => 'Anjou',
	'FR38010' => 'Annoisin-Chatelans',
	'FR38011' => 'Anthon',
	'FR38012' => 'Aoste',
	'FR38013' => 'Apprieu',
	'FR38015' => 'Artas',
	'FR38017' => 'Assieu',
	'FR38018' => 'Auberives-en-Royans',
	'FR38019' => 'Auberives-sur-Varèze',
	'FR38020' => 'Auris',
	'FR38022' => 'Les Avenières Veyrins-Thuellin',
	'FR38023' => 'Avignonet',
	'FR38026' => 'La Balme-les-Grottes',
	'FR38027' => 'Barraux',
	'FR38029' => 'La Bâtie-Montgascon',
	'FR38030' => 'Beaucroissant',
	'FR38031' => 'Beaufin',
	'FR38032' => 'Beaufort',
	'FR38033' => 'Beaulieu',
	'FR38034' => 'Beaurepaire',
	'FR38035' => 'Beauvoir-de-Marc',
	'FR38036' => 'Beauvoir-en-Royans',
	'FR38037' => 'Bellegarde-Poussieu',
	'FR38038' => 'Belmont',
	'FR38039' => 'Bernin',
	'FR38040' => 'Besse',
	'FR38041' => 'Bessins',
	'FR38042' => 'Bévenais',
	'FR38043' => 'Bilieu',
	'FR38044' => 'Biol',
	'FR38045' => 'Biviers',
	'FR38046' => 'Bizonnes',
	'FR38047' => 'Blandin',
	'FR38048' => 'Bonnefamille',
	'FR38049' => 'Bossieu',
	'FR38050' => 'Le Bouchage',
	'FR38051' => 'Bougé-Chambalud',
	'FR38052' => 'Le Bourg-dOisans',
	'FR38053' => 'Bourgoin-Jallieu',
	'FR38054' => 'Bouvesse-Quirieu',
	'FR38055' => 'Brangues',
	'FR38056' => 'Bressieux',
	'FR38057' => 'Bresson',
	'FR38058' => 'Brézins',
	'FR38059' => 'Brié-et-Angonnes',
	'FR38060' => 'Brion',
	'FR38061' => 'La Buisse',
	'FR38062' => 'La Buissière',
	'FR38063' => 'Burcin',
	'FR38064' => 'Cessieu',
	'FR38065' => 'Châbons',
	'FR38066' => 'Chalon',
	'FR38067' => 'Chamagnieu',
	'FR38068' => 'Champagnier',
	'FR38069' => 'Champier',
	'FR38070' => 'Le Champ-près-Froges',
	'FR38071' => 'Champ-sur-Drac',
	'FR38072' => 'Chanas',
	'FR38073' => 'Chantepérier',
	'FR38074' => 'Chantesse',
	'FR38075' => 'Chapareillan',
	'FR38076' => 'La Chapelle-de-la-Tour',
	'FR38077' => 'La Chapelle-de-Surieu',
	'FR38078' => 'La Chapelle-du-Bard',
	'FR38080' => 'Charancieu',
	'FR38081' => 'Charantonnay',
	'FR38082' => 'Charavines',
	'FR38083' => 'Charette',
	'FR38084' => 'Charnècles',
	'FR38085' => 'Charvieu-Chavagneux',
	'FR38086' => 'Chasselay',
	'FR38087' => 'Chasse-sur-Rhône',
	'FR38089' => 'Chassignieu',
	'FR38090' => 'Château-Bernard',
	'FR38091' => 'Châteauvilain',
	'FR38092' => 'Châtelus',
	'FR38093' => 'Châtenay',
	'FR38094' => 'Châtonnay',
	'FR38095' => 'Chatte',
	'FR38097' => 'Chavanoz',
	'FR38098' => 'Chélieu',
	'FR38099' => 'Chevrières',
	'FR38100' => 'Le Cheylas',
	'FR38101' => 'Cheyssieu',
	'FR38102' => 'Chèzeneuve',
	'FR38103' => 'Chichilianne',
	'FR38104' => 'Chimilin',
	'FR38105' => 'Chirens',
	'FR38106' => 'Cholonge',
	'FR38107' => 'Chonas-lAmballan',
	'FR38108' => 'Choranche',
	'FR38109' => 'Chozeau',
	'FR38110' => 'Chuzelles',
	'FR38111' => 'Claix',
	'FR38112' => 'Clavans-en-Haut-Oisans',
	'FR38113' => 'Clelles',
	'FR38114' => 'Clonas-sur-Varèze',
	'FR38115' => 'Saint-Martin-de-la-Cluze',
	'FR38116' => 'Cognet',
	'FR38117' => 'Cognin-les-Gorges',
	'FR38118' => 'Colombe',
	'FR38120' => 'La Combe-de-Lancey',
	'FR38124' => 'Corbelin',
	'FR38126' => 'Corenc',
	'FR38127' => 'Cornillon-en-Trièves',
	'FR38128' => 'Corps',
	'FR38129' => 'Corrençon-en-Vercors',
	'FR38130' => 'La Côte-Saint-André',
	'FR38131' => 'Les Côtes-dArey',
	'FR38132' => 'Les Côtes-de-Corps',
	'FR38133' => 'Coublevie',
	'FR38134' => 'Cour-et-Buis',
	'FR38135' => 'Courtenay',
	'FR38136' => 'Crachier',
	'FR38137' => 'Cras',
	'FR38138' => 'Crémieu',
	'FR38139' => 'Creys-Mépieu',
	'FR38140' => 'Crolles',
	'FR38141' => 'Culin',
	'FR38144' => 'Diémoz',
	'FR38146' => 'Dizimieu',
	'FR38147' => 'Doissin',
	'FR38148' => 'Dolomieu',
	'FR38149' => 'Domarin',
	'FR38150' => 'Domène',
	'FR38151' => 'Échirolles',
	'FR38152' => 'Eclose-Badinières',
	'FR38153' => 'Engins',
	'FR38154' => 'Entraigues',
	'FR38155' => 'Entre-deux-Guiers',
	'FR38156' => 'Les Éparres',
	'FR38157' => 'Estrablin',
	'FR38158' => 'Eybens',
	'FR38159' => 'Eydoche',
	'FR38160' => 'Eyzin-Pinet',
	'FR38161' => 'Faramans',
	'FR38162' => 'Faverges-de-la-Tour',
	'FR38163' => 'Le Haut-Bréda',
	'FR38166' => 'La Flachère',
	'FR38167' => 'Flachères',
	'FR38169' => 'Fontaine',
	'FR38170' => 'Fontanil-Cornillon',
	'FR38171' => 'La Forteresse',
	'FR38172' => 'Four',
	'FR38173' => 'Le Freney-dOisans',
	'FR38174' => 'La Frette',
	'FR38175' => 'Froges',
	'FR38176' => 'Frontonas',
	'FR38177' => 'La Garde',
	'FR38179' => 'Gières',
	'FR38180' => 'Gillonnay',
	'FR38181' => 'Goncelin',
	'FR38182' => 'Le Grand-Lemps',
	'FR38183' => 'Granieu',
	'FR38184' => 'Grenay',
	'FR38185' => 'Grenoble',
	'FR38186' => 'Gresse-en-Vercors',
	'FR38187' => 'Le Gua',
	'FR38188' => 'Herbeys',
	'FR38189' => 'Heyrieux',
	'FR38190' => 'Hières-sur-Amby',
	'FR38191' => 'Huez',
	'FR38192' => 'Hurtières',
	'FR38193' => 'LIsle-dAbeau',
	'FR38194' => 'Izeaux',
	'FR38195' => 'Izeron',
	'FR38197' => 'Janneyrias',
	'FR38198' => 'Jarcieu',
	'FR38199' => 'Jardin',
	'FR38200' => 'Jarrie',
	'FR38203' => 'Laffrey',
	'FR38204' => 'Lalley',
	'FR38205' => 'Lans-en-Vercors',
	'FR38206' => 'Laval',
	'FR38207' => 'Lavaldens',
	'FR38208' => 'Lavars',
	'FR38209' => 'Lentiol',
	'FR38210' => 'Leyrieu',
	'FR38211' => 'Lieudieu',
	'FR38212' => 'Livet-et-Gavet',
	'FR38213' => 'Longechenal',
	'FR38214' => 'Lumbin',
	'FR38215' => 'Luzinay',
	'FR38216' => 'Malleval-en-Vercors',
	'FR38217' => 'Marcieu',
	'FR38218' => 'Marcilloles',
	'FR38219' => 'Marcollin',
	'FR38221' => 'Marnans',
	'FR38222' => 'Massieu',
	'FR38223' => 'Maubec',
	'FR38224' => 'Mayres-Savel',
	'FR38225' => 'Autrans-Méaudre en Vercors',
	'FR38226' => 'Mens',
	'FR38228' => 'Merlas',
	'FR38229' => 'Meylan',
	'FR38230' => 'Meyrié',
	'FR38231' => 'Meyrieu-les-Étangs',
	'FR38232' => 'Meyssiez',
	'FR38235' => 'Miribel-Lanchâtre',
	'FR38236' => 'Miribel-les-Échelles',
	'FR38237' => 'Mizoën',
	'FR38238' => 'Moidieu-Détourbe',
	'FR38239' => 'Moirans',
	'FR38240' => 'Moissieu-sur-Dolon',
	'FR38241' => 'Monestier-dAmbel',
	'FR38242' => 'Monestier-de-Clermont',
	'FR38243' => 'Le Monestier-du-Percy',
	'FR38244' => 'Monsteroux-Milieu',
	'FR38245' => 'Montagne',
	'FR38246' => 'Montagnieu',
	'FR38247' => 'Montalieu-Vercieu',
	'FR38248' => 'Montaud',
	'FR38249' => 'Montbonnot-Saint-Martin',
	'FR38250' => 'Montcarra',
	'FR38252' => 'Montchaboud',
	'FR38253' => 'Les Deux Alpes',
	'FR38254' => 'Monteynard',
	'FR38255' => 'Montfalcon',
	'FR38256' => 'Montferrat',
	'FR38257' => 'Montrevel',
	'FR38258' => 'Mont-Saint-Martin',
	'FR38259' => 'Montseveroux',
	'FR38260' => 'Moras',
	'FR38261' => 'Morestel',
	'FR38263' => 'Morette',
	'FR38264' => 'La Morte',
	'FR38265' => 'La Motte-dAveillans',
	'FR38266' => 'La Motte-Saint-Martin',
	'FR38267' => 'Mottier',
	'FR38268' => 'Le Moutaret',
	'FR38269' => 'La Mure',
	'FR38270' => 'La Murette',
	'FR38271' => 'Murianette',
	'FR38272' => 'Murinais',
	'FR38273' => 'Nantes-en-Ratier',
	'FR38275' => 'Serre-Nerpol',
	'FR38276' => 'Nivolas-Vermelle',
	'FR38277' => 'Notre-Dame-de-Commiers',
	'FR38278' => 'Notre-Dame-de-lOsier',
	'FR38279' => 'Notre-Dame-de-Mésage',
	'FR38280' => 'Notre-Dame-de-Vaulx',
	'FR38281' => 'Noyarey',
	'FR38282' => 'Optevoz',
	'FR38283' => 'Oris-en-Rattier',
	'FR38284' => 'Ornacieux-Balbins',
	'FR38285' => 'Ornon',
	'FR38286' => 'Oulles',
	'FR38287' => 'Oyeu',
	'FR38288' => 'Oytier-Saint-Oblas',
	'FR38289' => 'Oz',
	'FR38290' => 'Pact',
	'FR38291' => 'Pajay',
	'FR38292' => 'Villages du Lac de Paladru',
	'FR38294' => 'Panossas',
	'FR38295' => 'Parmilieu',
	'FR38296' => 'Le Passage',
	'FR38297' => 'Arandon-Passins',
	'FR38298' => 'Le Péage-de-Roussillon',
	'FR38299' => 'Pellafol',
	'FR38300' => 'Penol',
	'FR38301' => 'Percy',
	'FR38303' => 'La Pierre',
	'FR38304' => 'Pierre-Châtel',
	'FR38307' => 'Pisieu',
	'FR38308' => 'Plan',
	'FR38309' => 'Poisat',
	'FR38310' => 'Poliénas',
	'FR38311' => 'Pommier-de-Beaurepaire',
	'FR38313' => 'Ponsonnas',
	'FR38314' => 'Pontcharra',
	'FR38315' => 'Le Pont-de-Beauvoisin',
	'FR38316' => 'Pont-de-Chéruy',
	'FR38317' => 'Le Pont-de-Claix',
	'FR38318' => 'Pont-Évêque',
	'FR38319' => 'Pont-en-Royans',
	'FR38320' => 'Porcieu-Amblagnieu',
	'FR38321' => 'Prébois',
	'FR38322' => 'Presles',
	'FR38323' => 'Pressins',
	'FR38324' => 'Primarette',
	'FR38325' => 'Proveysieux',
	'FR38326' => 'Prunières',
	'FR38328' => 'Quaix-en-Chartreuse',
	'FR38329' => 'Quet-en-Beaumont',
	'FR38330' => 'Quincieu',
	'FR38331' => 'Réaumont',
	'FR38332' => 'Renage',
	'FR38333' => 'Rencurel',
	'FR38334' => 'Revel',
	'FR38335' => 'Revel-Tourdan',
	'FR38336' => 'Reventin-Vaugris',
	'FR38337' => 'Rives',
	'FR38338' => 'La Rivière',
	'FR38339' => 'Roche',
	'FR38340' => 'Les Roches-de-Condrieu',
	'FR38341' => 'Rochetoirin',
	'FR38342' => 'Roissard',
	'FR38343' => 'Romagnieu',
	'FR38344' => 'Roussillon',
	'FR38345' => 'Rovon',
	'FR38346' => 'Royas',
	'FR38347' => 'Roybon',
	'FR38348' => 'Ruy-Montceau',
	'FR38349' => 'Sablons',
	'FR38350' => 'Sainte-Agnès',
	'FR38351' => 'Saint-Agnin-sur-Bion',
	'FR38352' => 'Saint-Alban-de-Roche',
	'FR38353' => 'Saint-Alban-du-Rhône',
	'FR38354' => 'Saint-Albin-de-Vaulserre',
	'FR38355' => 'Saint-Andéol',
	'FR38356' => 'Saint-André-en-Royans',
	'FR38357' => 'Saint-André-le-Gaz',
	'FR38358' => 'Sainte-Anne-sur-Gervonde',
	'FR38359' => 'Saint Antoine lAbbaye',
	'FR38360' => 'Saint-Appolinard',
	'FR38361' => 'Saint-Arey',
	'FR38362' => 'Saint-Aupre',
	'FR38363' => 'Saint-Barthélemy',
	'FR38364' => 'Saint-Barthélemy-de-Séchilienne',
	'FR38365' => 'Saint-Baudille-de-la-Tour',
	'FR38366' => 'Saint-Baudille-et-Pipet',
	'FR38368' => 'Saint-Blaise-du-Buis',
	'FR38369' => 'Sainte-Blandine',
	'FR38370' => 'Saint-Bonnet-de-Chavagne',
	'FR38372' => 'Saint-Bueil',
	'FR38373' => 'Saint-Cassien',
	'FR38374' => 'Saint-Chef',
	'FR38375' => 'Saint-Christophe-en-Oisans',
	'FR38376' => 'Saint-Christophe-sur-Guiers',
	'FR38377' => 'Saint-Clair-de-la-Tour',
	'FR38378' => 'Saint-Clair-du-Rhône',
	'FR38379' => 'Saint-Clair-sur-Galaure',
	'FR38380' => 'Saint-Didier-de-Bizonnes',
	'FR38381' => 'Saint-Didier-de-la-Tour',
	'FR38382' => 'Saint-Égrève',
	'FR38383' => 'Saint-Étienne-de-Crossey',
	'FR38384' => 'Saint-Étienne-de-Saint-Geoirs',
	'FR38386' => 'Saint-Geoire-en-Valdaine',
	'FR38387' => 'Saint-Geoirs',
	'FR38388' => 'Saint-Georges-de-Commiers',
	'FR38389' => 'Saint-Georges-dEspéranche',
	'FR38390' => 'Saint-Gervais',
	'FR38391' => 'Saint-Guillaume',
	'FR38392' => 'Saint-Hilaire-de-Brens',
	'FR38393' => 'Saint-Hilaire-de-la-Côte',
	'FR38394' => 'Saint-Hilaire-du-Rosier',
	'FR38395' => 'Plateau-des-Petites-Roches',
	'FR38396' => 'Saint-Honoré',
	'FR38397' => 'Saint-Ismier',
	'FR38398' => 'Saint-Jean-dAvelanne',
	'FR38399' => 'Saint-Jean-de-Bournay',
	'FR38400' => 'Saint-Jean-de-Moirans',
	'FR38401' => 'Saint-Jean-de-Soudain',
	'FR38402' => 'Saint-Jean-de-Vaulx',
	'FR38403' => 'Saint-Jean-dHérans',
	'FR38404' => 'Saint-Jean-le-Vieux',
	'FR38405' => 'Saint-Joseph-de-Rivière',
	'FR38406' => 'Saint-Julien-de-lHerms',
	'FR38407' => 'La Sure en Chartreuse',
	'FR38408' => 'Saint-Just-Chaleyssin',
	'FR38409' => 'Saint-Just-de-Claix',
	'FR38410' => 'Saint-Lattier',
	'FR38412' => 'Saint-Laurent-du-Pont',
	'FR38413' => 'Saint-Laurent-en-Beaumont',
	'FR38414' => 'Sainte-Luce',
	'FR38415' => 'Saint-Marcel-Bel-Accueil',
	'FR38416' => 'Saint-Marcellin',
	'FR38417' => 'Sainte-Marie-dAlloix',
	'FR38418' => 'Sainte-Marie-du-Mont',
	'FR38419' => 'Saint-Martin-de-Clelles',
	'FR38420' => 'Saint-Martin-de-Vaulserre',
	'FR38421' => 'Saint-Martin-dHères',
	'FR38422' => 'Saint-Martin-dUriage',
	'FR38423' => 'Saint-Martin-le-Vinoux',
	'FR38424' => 'Saint-Maurice-en-Trièves',
	'FR38425' => 'Saint-Maurice-lExil',
	'FR38426' => 'Saint-Maximin',
	'FR38427' => 'Saint-Michel-de-Saint-Geoirs',
	'FR38428' => 'Saint-Michel-en-Beaumont',
	'FR38429' => 'Saint-Michel-les-Portes',
	'FR38430' => 'Saint-Mury-Monteymond',
	'FR38431' => 'Saint-Nazaire-les-Eymes',
	'FR38432' => 'Saint-Nicolas-de-Macherin',
	'FR38433' => 'Saint-Nizier-du-Moucherotte',
	'FR38434' => 'Saint-Ondras',
	'FR38436' => 'Saint-Paul-de-Varces',
	'FR38437' => 'Saint-Paul-dIzeaux',
	'FR38438' => 'Saint-Paul-lès-Monestier',
	'FR38439' => 'Crêts en Belledonne',
	'FR38440' => 'Saint-Pierre-de-Bressieux',
	'FR38442' => 'Saint-Pierre-de-Chartreuse',
	'FR38443' => 'Saint-Pierre-de-Chérennes',
	'FR38444' => 'Saint-Pierre-de-Méaroz',
	'FR38445' => 'Saint-Pierre-de-Mésage',
	'FR38446' => 'Saint-Pierre-dEntremont',
	'FR38448' => 'Saint-Prim',
	'FR38449' => 'Saint-Quentin-Fallavier',
	'FR38450' => 'Saint-Quentin-sur-Isère',
	'FR38451' => 'Saint-Romain-de-Jalionas',
	'FR38452' => 'Saint-Romain-de-Surieu',
	'FR38453' => 'Saint-Romans',
	'FR38454' => 'Saint-Sauveur',
	'FR38455' => 'Saint-Savin',
	'FR38456' => 'Châtel-en-Trièves',
	'FR38457' => 'Saint-Siméon-de-Bressieux',
	'FR38458' => 'Saint-Sorlin-de-Morestel',
	'FR38459' => 'Saint-Sorlin-de-Vienne',
	'FR38460' => 'Saint-Sulpice-des-Rivoires',
	'FR38462' => 'Saint-Théoffrey',
	'FR38463' => 'Saint-Vérand',
	'FR38464' => 'Saint-Victor-de-Cessieu',
	'FR38465' => 'Saint-Victor-de-Morestel',
	'FR38466' => 'Saint-Vincent-de-Mercuze',
	'FR38467' => 'Salagnon',
	'FR38468' => 'Salaise-sur-Sanne',
	'FR38469' => 'La Salette-Fallavaux',
	'FR38470' => 'La Salle-en-Beaumont',
	'FR38471' => 'Le Sappey-en-Chartreuse',
	'FR38472' => 'Sarcenas',
	'FR38473' => 'Sardieu',
	'FR38474' => 'Sassenage',
	'FR38475' => 'Satolas-et-Bonce',
	'FR38476' => 'Savas-Mépin',
	'FR38478' => 'Séchilienne',
	'FR38479' => 'Porte-des-Bonnevaux',
	'FR38480' => 'Septème',
	'FR38481' => 'Sérézin-de-la-Tour',
	'FR38483' => 'Sermérieu',
	'FR38484' => 'Serpaize',
	'FR38485' => 'Seyssinet-Pariset',
	'FR38486' => 'Seyssins',
	'FR38487' => 'Seyssuel',
	'FR38488' => 'Siccieu-Saint-Julien-et-Carisieu',
	'FR38489' => 'Siévoz',
	'FR38490' => 'Sillans',
	'FR38492' => 'Sinard',
	'FR38494' => 'Soleymieu',
	'FR38495' => 'La Sône',
	'FR38496' => 'Sonnay',
	'FR38497' => 'Sousville',
	'FR38498' => 'Succieu',
	'FR38499' => 'Susville',
	'FR38500' => 'Têche',
	'FR38501' => 'Tencin',
	'FR38503' => 'La Terrasse',
	'FR38504' => 'Theys',
	'FR38505' => 'Thodure',
	'FR38507' => 'Tignieu-Jameyzieu',
	'FR38508' => 'Torchefelon',
	'FR38509' => 'La Tour-du-Pin',
	'FR38511' => 'Le Touvet',
	'FR38512' => 'Tramolé',
	'FR38513' => 'Treffort',
	'FR38514' => 'Tréminis',
	'FR38515' => 'Trept',
	'FR38516' => 'La Tronche',
	'FR38517' => 'Tullins',
	'FR38518' => 'Valbonnais',
	'FR38519' => 'Valencin',
	'FR38520' => 'Valencogne',
	'FR38521' => 'La Valette',
	'FR38522' => 'Valjouffrey',
	'FR38523' => 'Varacieux',
	'FR38524' => 'Varces-Allières-et-Risset',
	'FR38525' => 'Vasselin',
	'FR38526' => 'Vatilieu',
	'FR38527' => 'Vaujany',
	'FR38528' => 'Vaulnaveys-le-Bas',
	'FR38529' => 'Vaulnaveys-le-Haut',
	'FR38530' => 'Vaulx-Milieu',
	'FR38531' => 'Velanne',
	'FR38532' => 'Vénérieu',
	'FR38533' => 'Venon',
	'FR38535' => 'Vernas',
	'FR38536' => 'Vernioz',
	'FR38537' => 'La Verpillière',
	'FR38538' => 'Le Versoud',
	'FR38539' => 'Vertrieu',
	'FR38540' => 'Veurey-Voroize',
	'FR38542' => 'Veyssilieu',
	'FR38543' => 'Vézeronce-Curtin',
	'FR38544' => 'Vienne',
	'FR38545' => 'Vif',
	'FR38546' => 'Vignieu',
	'FR38547' => 'Villard-Bonnot',
	'FR38548' => 'Villard-de-Lans',
	'FR38549' => 'Villard-Notre-Dame',
	'FR38550' => 'Villard-Reculas',
	'FR38551' => 'Villard-Reymond',
	'FR38552' => 'Villard-Saint-Christophe',
	'FR38553' => 'Villefontaine',
	'FR38554' => 'Villemoirieu',
	'FR38555' => 'Villeneuve-de-Marc',
	'FR38556' => 'Ville-sous-Anjou',
	'FR38557' => 'Villette-dAnthon',
	'FR38558' => 'Villette-de-Vienne',
	'FR38559' => 'Vinay',
	'FR38560' => 'Val-de-Virieu',
	'FR38561' => 'Viriville',
	'FR38562' => 'Vizille',
	'FR38563' => 'Voiron',
	'FR38564' => 'Voissant',
	'FR38565' => 'Voreppe',
	'FR38566' => 'Vourey',
	'FR38567' => 'Chamrousse',
	'FR39001' => 'Abergement-la-Ronce',
	'FR39002' => 'Abergement-le-Grand',
	'FR39003' => 'Abergement-le-Petit',
	'FR39004' => 'Abergement-lès-Thésy',
	'FR39006' => 'Aiglepierre',
	'FR39007' => 'Alièze',
	'FR39008' => 'Amange',
	'FR39009' => 'Andelot-en-Montagne',
	'FR39010' => 'Andelot-Morval',
	'FR39011' => 'Annoire',
	'FR39013' => 'Arbois',
	'FR39014' => 'Archelange',
	'FR39015' => 'Ardon',
	'FR39016' => 'Arinthod',
	'FR39017' => 'Arlay',
	'FR39018' => 'Aromas',
	'FR39019' => 'Les Arsures',
	'FR39020' => 'Arsure-Arsurette',
	'FR39021' => 'La Chailleuse',
	'FR39022' => 'Asnans-Beauvoisin',
	'FR39024' => 'Audelange',
	'FR39025' => 'Augea',
	'FR39026' => 'Augerans',
	'FR39027' => 'Augisey',
	'FR39028' => 'Aumont',
	'FR39029' => 'Aumur',
	'FR39030' => 'Authume',
	'FR39031' => 'Auxange',
	'FR39032' => 'Avignon-lès-Saint-Claude',
	'FR39034' => 'Balaiseaux',
	'FR39035' => 'Balanod',
	'FR39037' => 'Bans',
	'FR39038' => 'Barésia-sur-lAin',
	'FR39039' => 'La Barre',
	'FR39040' => 'Barretaine',
	'FR39041' => 'Baume-les-Messieurs',
	'FR39042' => 'Baverans',
	'FR39043' => 'Beaufort-Orbagna',
	'FR39045' => 'Beffia',
	'FR39046' => 'Bellecombe',
	'FR39047' => 'Bellefontaine',
	'FR39048' => 'Belmont',
	'FR39049' => 'Bersaillin',
	'FR39050' => 'Besain',
	'FR39051' => 'Biarne',
	'FR39052' => 'Bief-des-Maisons',
	'FR39053' => 'Bief-du-Fourg',
	'FR39054' => 'Biefmorin',
	'FR39055' => 'Billecul',
	'FR39056' => 'Bletterans',
	'FR39057' => 'Blois-sur-Seille',
	'FR39058' => 'Blye',
	'FR39059' => 'Bois-dAmont',
	'FR39060' => 'Bois-de-Gand',
	'FR39061' => 'Boissia',
	'FR39062' => 'La Boissière',
	'FR39063' => 'Bonlieu',
	'FR39065' => 'Bonnefontaine',
	'FR39066' => 'Bornay',
	'FR39068' => 'Les Bouchoux',
	'FR39070' => 'Bourg-de-Sirod',
	'FR39072' => 'Bracon',
	'FR39073' => 'Brainans',
	'FR39074' => 'Brans',
	'FR39076' => 'La Bretenière',
	'FR39077' => 'Bretenières',
	'FR39078' => 'Brevans',
	'FR39079' => 'Briod',
	'FR39080' => 'Broissia',
	'FR39081' => 'Buvilly',
	'FR39083' => 'Censeau',
	'FR39084' => 'Cernans',
	'FR39085' => 'Cerniébaud',
	'FR39086' => 'Cernon',
	'FR39088' => 'Cesancey',
	'FR39090' => 'Chaînée-des-Coupis',
	'FR39091' => 'Les Chalesmes',
	'FR39092' => 'Chambéria',
	'FR39093' => 'Chamblay',
	'FR39094' => 'Chamole',
	'FR39095' => 'Champagne-sur-Loue',
	'FR39096' => 'Champagney',
	'FR39097' => 'Champagnole',
	'FR39099' => 'Champdivers',
	'FR39100' => 'Champrougier',
	'FR39101' => 'Champvans',
	'FR39102' => 'Chancia',
	'FR39103' => 'La Chapelle-sur-Furieuse',
	'FR39104' => 'Chapelle-Voland',
	'FR39105' => 'Chapois',
	'FR39106' => 'Charchilla',
	'FR39107' => 'Charcier',
	'FR39108' => 'Charency',
	'FR39109' => 'Charézier',
	'FR39110' => 'La Charme',
	'FR39111' => 'Charnod',
	'FR39112' => 'La Chassagne',
	'FR39114' => 'Château-Chalon',
	'FR39116' => 'La Châtelaine',
	'FR39117' => 'Chatelay',
	'FR39118' => 'Châtel-de-Joux',
	'FR39119' => 'Le Chateley',
	'FR39120' => 'Châtelneuf',
	'FR39121' => 'Châtenois',
	'FR39122' => 'Châtillon',
	'FR39124' => 'Chaumergy',
	'FR39126' => 'La Chaumusse',
	'FR39127' => 'Chaussenans',
	'FR39128' => 'Chaussin',
	'FR39129' => 'Chaux-des-Crotenay',
	'FR39130' => 'Nanchez',
	'FR39131' => 'La Chaux-du-Dombief',
	'FR39132' => 'La Chaux-en-Bresse',
	'FR39133' => 'Chaux-Champagny',
	'FR39134' => 'Chavéria',
	'FR39136' => 'Chemenot',
	'FR39137' => 'Saint-Hymetière-sur-Valouse',
	'FR39138' => 'Chemin',
	'FR39139' => 'Chêne-Bernard',
	'FR39140' => 'Chêne-Sec',
	'FR39141' => 'Chevigny',
	'FR39142' => 'Chevreaux',
	'FR39143' => 'Chevrotaine',
	'FR39145' => 'Chille',
	'FR39146' => 'Chilly-le-Vignoble',
	'FR39147' => 'Chilly-sur-Salins',
	'FR39149' => 'Chissey-sur-Loue',
	'FR39150' => 'Choisey',
	'FR39151' => 'Choux',
	'FR39153' => 'Cize',
	'FR39154' => 'Clairvaux-les-Lacs',
	'FR39155' => 'Clucy',
	'FR39156' => 'Cogna',
	'FR39157' => 'Coiserette',
	'FR39159' => 'Colonne',
	'FR39160' => 'Commenailles',
	'FR39162' => 'Condamine',
	'FR39163' => 'Condes',
	'FR39164' => 'Conliège',
	'FR39165' => 'Conte',
	'FR39166' => 'Cornod',
	'FR39167' => 'Cosges',
	'FR39168' => 'Courbette',
	'FR39169' => 'Courbouzon',
	'FR39170' => 'Courlans',
	'FR39171' => 'Courlaoux',
	'FR39172' => 'Courtefontaine',
	'FR39173' => 'Cousance',
	'FR39174' => 'Coyrière',
	'FR39175' => 'Coyron',
	'FR39176' => 'Cramans',
	'FR39177' => 'Hauteroche',
	'FR39178' => 'Crans',
	'FR39179' => 'Crenans',
	'FR39180' => 'Cressia',
	'FR39182' => 'Crissey',
	'FR39183' => 'Crotenay',
	'FR39184' => 'Les Crozets',
	'FR39185' => 'Cuisia',
	'FR39187' => 'Cuvier',
	'FR39188' => 'Dammartin-Marpain',
	'FR39189' => 'Damparis',
	'FR39190' => 'Dampierre',
	'FR39191' => 'Darbonnay',
	'FR39192' => 'Denezières',
	'FR39193' => 'Le Deschaux',
	'FR39194' => 'Desnes',
	'FR39196' => 'Les Deux-Fays',
	'FR39197' => 'Digna',
	'FR39198' => 'Dole',
	'FR39199' => 'Domblans',
	'FR39200' => 'Dompierre-sur-Mont',
	'FR39201' => 'Doucier',
	'FR39202' => 'Dournon',
	'FR39203' => 'Doye',
	'FR39204' => 'Dramelay',
	'FR39205' => 'Éclans-Nenon',
	'FR39206' => 'Écleux',
	'FR39207' => 'Écrille',
	'FR39208' => 'Entre-deux-Monts',
	'FR39209' => 'Val-dÉpy',
	'FR39210' => 'Équevillon',
	'FR39211' => 'Les Essards-Taignevaux',
	'FR39214' => 'Esserval-Tartre',
	'FR39216' => 'Étival',
	'FR39217' => 'LÉtoile',
	'FR39218' => 'Étrepigney',
	'FR39219' => 'Évans',
	'FR39220' => 'Falletans',
	'FR39221' => 'La Favière',
	'FR39222' => 'Fay-en-Montagne',
	'FR39223' => 'La Ferté',
	'FR39225' => 'Le Fied',
	'FR39227' => 'Foncine-le-Bas',
	'FR39228' => 'Foncine-le-Haut',
	'FR39229' => 'Fontainebrux',
	'FR39230' => 'Fontenu',
	'FR39232' => 'Fort-du-Plasne',
	'FR39233' => 'Foucherans',
	'FR39234' => 'Foulenay',
	'FR39235' => 'Fraisans',
	'FR39236' => 'Francheville',
	'FR39237' => 'Fraroz',
	'FR39238' => 'Frasne-les-Meulières',
	'FR39239' => 'La Frasnée',
	'FR39240' => 'Le Frasnois',
	'FR39241' => 'Frébuans',
	'FR39244' => 'Frontenay',
	'FR39245' => 'Gatey',
	'FR39246' => 'Gendrey',
	'FR39247' => 'Genod',
	'FR39248' => 'Geraise',
	'FR39249' => 'Germigney',
	'FR39250' => 'Geruge',
	'FR39251' => 'Gevingey',
	'FR39252' => 'Gevry',
	'FR39253' => 'Gigny',
	'FR39254' => 'Gillois',
	'FR39255' => 'Gizia',
	'FR39258' => 'Grande-Rivière Château',
	'FR39259' => 'Grange-de-Vaivre',
	'FR39261' => 'Graye-et-Charnay',
	'FR39262' => 'Gredisans',
	'FR39263' => 'Grozon',
	'FR39265' => 'Hautecour',
	'FR39266' => 'Les Hays',
	'FR39267' => 'Ivory',
	'FR39268' => 'Ivrey',
	'FR39269' => 'Jeurre',
	'FR39270' => 'Jouhe',
	'FR39271' => 'Lac-des-Rouges-Truites',
	'FR39272' => 'Ladoye-sur-Seille',
	'FR39273' => 'Montlainsia',
	'FR39274' => 'Lajoux',
	'FR39275' => 'Lamoura',
	'FR39277' => 'Le Larderet',
	'FR39278' => 'Largillay-Marsonnay',
	'FR39279' => 'Larnaud',
	'FR39280' => 'Larrivoire',
	'FR39281' => 'Le Latet',
	'FR39282' => 'La Latette',
	'FR39283' => 'Lavancia-Epercy',
	'FR39284' => 'Lavangeot',
	'FR39285' => 'Lavans-lès-Dole',
	'FR39286' => 'Lavans-lès-Saint-Claude',
	'FR39288' => 'Lavigny',
	'FR39289' => 'Lect',
	'FR39290' => 'Valzin en Petite Montagne',
	'FR39291' => 'Lemuy',
	'FR39292' => 'Lent',
	'FR39293' => 'Leschères',
	'FR39295' => 'Loisia',
	'FR39296' => 'Lombard',
	'FR39297' => 'Longchaumois',
	'FR39298' => 'Longcochon',
	'FR39299' => 'Longwy-sur-le-Doubs',
	'FR39300' => 'Lons-le-Saunier',
	'FR39301' => 'Loulle',
	'FR39302' => 'Louvatange',
	'FR39304' => 'Le Louverot',
	'FR39305' => 'La Loye',
	'FR39306' => 'Macornay',
	'FR39307' => 'Maisod',
	'FR39308' => 'Malange',
	'FR39310' => 'Mantry',
	'FR39312' => 'Marigna-sur-Valouse',
	'FR39313' => 'Marigny',
	'FR39314' => 'Marnézia',
	'FR39315' => 'Marnoz',
	'FR39317' => 'La Marre',
	'FR39318' => 'Martigna',
	'FR39319' => 'Mathenay',
	'FR39320' => 'Maynal',
	'FR39321' => 'Menétru-le-Vignoble',
	'FR39322' => 'Menétrux-en-Joux',
	'FR39323' => 'Menotey',
	'FR39324' => 'Mérona',
	'FR39325' => 'Mesnay',
	'FR39326' => 'Mesnois',
	'FR39327' => 'Messia-sur-Sorne',
	'FR39328' => 'Meussia',
	'FR39329' => 'Mièges',
	'FR39330' => 'Miéry',
	'FR39331' => 'Mignovillard',
	'FR39333' => 'Moirans-en-Montagne',
	'FR39334' => 'Moiron',
	'FR39335' => 'Moissey',
	'FR39336' => 'Molain',
	'FR39337' => 'Molamboz',
	'FR39338' => 'Molay',
	'FR39339' => 'Chassal-Molinges',
	'FR39342' => 'Monay',
	'FR39343' => 'Monnetay',
	'FR39344' => 'Monnet-la-Ville',
	'FR39345' => 'Monnières',
	'FR39346' => 'Montagna-le-Reconduit',
	'FR39348' => 'Montaigu',
	'FR39349' => 'Montain',
	'FR39350' => 'Montbarrey',
	'FR39351' => 'Montcusel',
	'FR39352' => 'Monteplain',
	'FR39353' => 'Montfleur',
	'FR39354' => 'Montholier',
	'FR39355' => 'Montigny-lès-Arsures',
	'FR39356' => 'Montigny-sur-lAin',
	'FR39359' => 'Montmarlon',
	'FR39360' => 'Montmirey-la-Ville',
	'FR39361' => 'Montmirey-le-Château',
	'FR39362' => 'Montmorot',
	'FR39363' => 'Montrevel',
	'FR39364' => 'Montrond',
	'FR39365' => 'Mont-sous-Vaudrey',
	'FR39366' => 'Mont-sur-Monnet',
	'FR39367' => 'Morbier',
	'FR39368' => 'Hauts de Bienne',
	'FR39370' => 'Mouchard',
	'FR39372' => 'Mournans-Charbonny',
	'FR39373' => 'Les Moussières',
	'FR39375' => 'Moutonne',
	'FR39376' => 'Moutoux',
	'FR39377' => 'Mutigney',
	'FR39378' => 'Les Trois Châteaux',
	'FR39379' => 'Nance',
	'FR39380' => 'Nancuise',
	'FR39381' => 'Les Nans',
	'FR39385' => 'Neublans-Abergement',
	'FR39386' => 'Neuvilley',
	'FR39387' => 'Nevy-lès-Dole',
	'FR39388' => 'Nevy-sur-Seille',
	'FR39389' => 'Ney',
	'FR39390' => 'Nogna',
	'FR39391' => 'Nozeroy',
	'FR39392' => 'Offlanges',
	'FR39393' => 'Onglières',
	'FR39394' => 'Onoz',
	'FR39396' => 'Orchamps',
	'FR39397' => 'Orgelet',
	'FR39398' => 'Ougney',
	'FR39399' => 'Ounans',
	'FR39400' => 'Our',
	'FR39401' => 'Oussières',
	'FR39402' => 'Pagney',
	'FR39403' => 'Pagnoz',
	'FR39404' => 'Pannessières',
	'FR39405' => 'Parcey',
	'FR39406' => 'Le Pasquier',
	'FR39407' => 'Passenans',
	'FR39408' => 'Patornay',
	'FR39409' => 'Peintre',
	'FR39411' => 'Perrigny',
	'FR39412' => 'Peseux',
	'FR39413' => 'La Pesse',
	'FR39415' => 'Petit-Noir',
	'FR39418' => 'Picarreau',
	'FR39419' => 'Pillemoine',
	'FR39420' => 'Pimorin',
	'FR39421' => 'Le Pin',
	'FR39422' => 'Plainoiseau',
	'FR39423' => 'Plaisia',
	'FR39424' => 'Les Planches-en-Montagne',
	'FR39425' => 'Les Planches-près-Arbois',
	'FR39426' => 'Plasne',
	'FR39427' => 'Plénise',
	'FR39428' => 'Plénisette',
	'FR39429' => 'Pleure',
	'FR39430' => 'Plumont',
	'FR39431' => 'Poids-de-Fiole',
	'FR39432' => 'Pointre',
	'FR39434' => 'Poligny',
	'FR39435' => 'Pont-de-Poitte',
	'FR39436' => 'Pont-dHéry',
	'FR39437' => 'Pont-du-Navoy',
	'FR39439' => 'Port-Lesney',
	'FR39441' => 'Prémanon',
	'FR39443' => 'Présilly',
	'FR39444' => 'Pretin',
	'FR39445' => 'Publy',
	'FR39446' => 'Pupillin',
	'FR39447' => 'Quintigny',
	'FR39448' => 'Rahon',
	'FR39449' => 'Rainans',
	'FR39451' => 'Ranchot',
	'FR39452' => 'Rans',
	'FR39453' => 'Ravilloles',
	'FR39454' => 'Recanoz',
	'FR39455' => 'Reithouse',
	'FR39456' => 'Relans',
	'FR39457' => 'Les Repôts',
	'FR39458' => 'Revigny',
	'FR39460' => 'La Rixouse',
	'FR39461' => 'Rix',
	'FR39462' => 'Rochefort-sur-Nenon',
	'FR39463' => 'Rogna',
	'FR39464' => 'Romain',
	'FR39465' => 'Romange',
	'FR39466' => 'Rosay',
	'FR39467' => 'Rotalier',
	'FR39468' => 'Rothonay',
	'FR39469' => 'Rouffange',
	'FR39470' => 'Les Rousses',
	'FR39471' => 'Ruffey-sur-Seille',
	'FR39472' => 'Rye',
	'FR39473' => 'Saffloz',
	'FR39474' => 'Sainte-Agnès',
	'FR39475' => 'Saint-Amour',
	'FR39476' => 'Saint-Aubin',
	'FR39477' => 'Saint-Baraing',
	'FR39478' => 'Saint-Claude',
	'FR39479' => 'Saint-Cyr-Montmalin',
	'FR39480' => 'Saint-Didier',
	'FR39481' => 'Saint-Germain-en-Montagne',
	'FR39485' => 'Val Suran',
	'FR39486' => 'Saint-Lamain',
	'FR39487' => 'Saint-Laurent-en-Grandvaux',
	'FR39489' => 'Saint-Lothain',
	'FR39490' => 'Saint-Loup',
	'FR39491' => 'Coteaux du Lizon',
	'FR39492' => 'Saint-Maur',
	'FR39493' => 'Saint-Maurice-Crillat',
	'FR39494' => 'Saint-Pierre',
	'FR39495' => 'Saint-Thiébaud',
	'FR39497' => 'Saizenay',
	'FR39498' => 'Salans',
	'FR39499' => 'Saligney',
	'FR39500' => 'Salins-les-Bains',
	'FR39501' => 'Sampans',
	'FR39502' => 'Santans',
	'FR39503' => 'Sapois',
	'FR39504' => 'Sarrogna',
	'FR39505' => 'Saugeot',
	'FR39507' => 'Séligney',
	'FR39508' => 'Sellières',
	'FR39510' => 'Septmoncel les Molunes',
	'FR39511' => 'Sergenaux',
	'FR39512' => 'Sergenon',
	'FR39513' => 'Sermange',
	'FR39514' => 'Serre-les-Moulières',
	'FR39517' => 'Sirod',
	'FR39518' => 'Songeson',
	'FR39519' => 'Soucia',
	'FR39520' => 'Souvans',
	'FR39522' => 'Supt',
	'FR39523' => 'Syam',
	'FR39525' => 'Tassenières',
	'FR39526' => 'Tavaux',
	'FR39527' => 'Taxenne',
	'FR39528' => 'Thervay',
	'FR39529' => 'Thésy',
	'FR39530' => 'Thoirette-Coisia',
	'FR39531' => 'Thoiria',
	'FR39532' => 'Thoissia',
	'FR39533' => 'Toulouse-le-Château',
	'FR39534' => 'La Tour-du-Meix',
	'FR39535' => 'Tourmont',
	'FR39537' => 'Trenal',
	'FR39538' => 'Uxelles',
	'FR39539' => 'Vadans',
	'FR39540' => 'Valempoulières',
	'FR39543' => 'Vannoz',
	'FR39545' => 'Le Vaudioux',
	'FR39546' => 'Vaudrey',
	'FR39547' => 'Vaux-lès-Saint-Claude',
	'FR39548' => 'Vaux-sur-Poligny',
	'FR39550' => 'Verges',
	'FR39551' => 'Véria',
	'FR39552' => 'Vernantois',
	'FR39553' => 'Le Vernois',
	'FR39554' => 'Vers-en-Montagne',
	'FR39555' => 'Vers-sous-Sellières',
	'FR39556' => 'Vertamboz',
	'FR39557' => 'Vescles',
	'FR39558' => 'Vevy',
	'FR39559' => 'La Vieille-Loye',
	'FR39560' => 'Villard-Saint-Sauveur',
	'FR39561' => 'Villards-dHéria',
	'FR39565' => 'Villeneuve-dAval',
	'FR39567' => 'Villeneuve-sous-Pymont',
	'FR39568' => 'Villerserine',
	'FR39569' => 'Villers-Farlay',
	'FR39570' => 'Villers-les-Bois',
	'FR39571' => 'Villers-Robert',
	'FR39572' => 'Villette-lès-Arbois',
	'FR39573' => 'Villette-lès-Dole',
	'FR39574' => 'Villevieux',
	'FR39575' => 'Le Villey',
	'FR39576' => 'Val-Sonnette',
	'FR39577' => 'Vincent-Froideville',
	'FR39579' => 'Viry',
	'FR39581' => 'Vitreux',
	'FR39582' => 'Voiteur',
	'FR39583' => 'Vosbles-Valfin',
	'FR39584' => 'Vriange',
	'FR39585' => 'Vulvoz',
	'FR39586' => 'Aresches',
	'FR40001' => 'Aire-sur-lAdour',
	'FR40002' => 'Amou',
	'FR40003' => 'Angoumé',
	'FR40004' => 'Angresse',
	'FR40005' => 'Arboucave',
	'FR40006' => 'Arengosse',
	'FR40007' => 'Argelos',
	'FR40008' => 'Argelouse',
	'FR40011' => 'Arsague',
	'FR40012' => 'Artassenx',
	'FR40013' => 'Arthez-dArmagnac',
	'FR40014' => 'Arue',
	'FR40015' => 'Arx',
	'FR40016' => 'Aubagnan',
	'FR40017' => 'Audignon',
	'FR40018' => 'Audon',
	'FR40019' => 'Aureilhan',
	'FR40020' => 'Aurice',
	'FR40021' => 'Azur',
	'FR40022' => 'Bahus-Soubiran',
	'FR40023' => 'Baigts',
	'FR40024' => 'Banos',
	'FR40025' => 'Bascons',
	'FR40026' => 'Bas-Mauco',
	'FR40027' => 'Bassercles',
	'FR40028' => 'Bastennes',
	'FR40029' => 'Bats',
	'FR40030' => 'Baudignan',
	'FR40031' => 'Bégaar',
	'FR40032' => 'Belhade',
	'FR40033' => 'Bélis',
	'FR40034' => 'Bélus',
	'FR40035' => 'Bénesse-lès-Dax',
	'FR40036' => 'Bénesse-Maremne',
	'FR40037' => 'Benquet',
	'FR40038' => 'Bergouey',
	'FR40039' => 'Betbezer-dArmagnac',
	'FR40040' => 'Beylongue',
	'FR40041' => 'Beyries',
	'FR40042' => 'Biarrotte',
	'FR40043' => 'Bias',
	'FR40044' => 'Biaudos',
	'FR40046' => 'Biscarrosse',
	'FR40047' => 'Bonnegarde',
	'FR40049' => 'Bordères-et-Lamensans',
	'FR40050' => 'Bostens',
	'FR40051' => 'Bougue',
	'FR40052' => 'Bourdalat',
	'FR40053' => 'Bourriot-Bergonce',
	'FR40054' => 'Brassempouy',
	'FR40055' => 'Bretagne-de-Marsan',
	'FR40056' => 'Brocas',
	'FR40057' => 'Buanes',
	'FR40058' => 'Cachen',
	'FR40059' => 'Cagnotte',
	'FR40060' => 'Callen',
	'FR40061' => 'Campagne',
	'FR40062' => 'Campet-et-Lamolère',
	'FR40063' => 'Candresse',
	'FR40064' => 'Canenx-et-Réaut',
	'FR40065' => 'Capbreton',
	'FR40066' => 'Carcarès-Sainte-Croix',
	'FR40067' => 'Carcen-Ponson',
	'FR40068' => 'Cassen',
	'FR40069' => 'Castaignos-Souslens',
	'FR40070' => 'Castandet',
	'FR40071' => 'Castelnau-Chalosse',
	'FR40072' => 'Castelnau-Tursan',
	'FR40073' => 'Castelner',
	'FR40074' => 'Castel-Sarrazin',
	'FR40075' => 'Castets',
	'FR40076' => 'Cauna',
	'FR40077' => 'Cauneille',
	'FR40078' => 'Caupenne',
	'FR40079' => 'Cazalis',
	'FR40080' => 'Cazères-sur-lAdour',
	'FR40081' => 'Cère',
	'FR40082' => 'Classun',
	'FR40083' => 'Clèdes',
	'FR40084' => 'Clermont',
	'FR40085' => 'Commensacq',
	'FR40086' => 'Coudures',
	'FR40087' => 'Créon-dArmagnac',
	'FR40088' => 'Dax',
	'FR40089' => 'Doazit',
	'FR40090' => 'Donzacq',
	'FR40091' => 'Duhort-Bachen',
	'FR40092' => 'Dumes',
	'FR40093' => 'Escalans',
	'FR40094' => 'Escource',
	'FR40095' => 'Estibeaux',
	'FR40096' => 'Estigarde',
	'FR40097' => 'Eugénie-les-Bains',
	'FR40098' => 'Eyres-Moncube',
	'FR40099' => 'Fargues',
	'FR40100' => 'Le Frêche',
	'FR40101' => 'Gaas',
	'FR40102' => 'Gabarret',
	'FR40103' => 'Gaillères',
	'FR40104' => 'Gamarde-les-Bains',
	'FR40105' => 'Garein',
	'FR40106' => 'Garrey',
	'FR40108' => 'Gastes',
	'FR40109' => 'Gaujacq',
	'FR40110' => 'Geaune',
	'FR40111' => 'Geloux',
	'FR40112' => 'Gibret',
	'FR40113' => 'Goos',
	'FR40114' => 'Gourbera',
	'FR40115' => 'Gousse',
	'FR40116' => 'Gouts',
	'FR40117' => 'Grenade-sur-lAdour',
	'FR40118' => 'Habas',
	'FR40119' => 'Hagetmau',
	'FR40120' => 'Hastingues',
	'FR40121' => 'Hauriet',
	'FR40122' => 'Haut-Mauco',
	'FR40123' => 'Herm',
	'FR40124' => 'Herré',
	'FR40125' => 'Heugas',
	'FR40126' => 'Hinx',
	'FR40127' => 'Hontanx',
	'FR40128' => 'Horsarrieu',
	'FR40129' => 'Josse',
	'FR40130' => 'Labastide-Chalosse',
	'FR40131' => 'Labastide-dArmagnac',
	'FR40132' => 'Labatut',
	'FR40133' => 'Labenne',
	'FR40134' => 'Labouheyre',
	'FR40135' => 'Labrit',
	'FR40136' => 'Lacajunte',
	'FR40137' => 'Lacquy',
	'FR40138' => 'Lacrabe',
	'FR40139' => 'Laglorieuse',
	'FR40140' => 'Lagrange',
	'FR40141' => 'Lahosse',
	'FR40142' => 'Laluque',
	'FR40143' => 'Lamothe',
	'FR40144' => 'Larbey',
	'FR40145' => 'Larrivière-Saint-Savin',
	'FR40146' => 'Latrille',
	'FR40147' => 'Laurède',
	'FR40148' => 'Lauret',
	'FR40149' => 'Lencouacq',
	'FR40150' => 'Léon',
	'FR40151' => 'Lesgor',
	'FR40152' => 'Lesperon',
	'FR40153' => 'Le Leuy',
	'FR40154' => 'Lévignacq',
	'FR40155' => 'Linxe',
	'FR40156' => 'Liposthey',
	'FR40157' => 'Lit-et-Mixe',
	'FR40158' => 'Losse',
	'FR40159' => 'Louer',
	'FR40160' => 'Lourquen',
	'FR40161' => 'Lubbon',
	'FR40162' => 'Lucbardez-et-Bargues',
	'FR40163' => 'Lüe',
	'FR40164' => 'Retjons',
	'FR40165' => 'Luglon',
	'FR40166' => 'Lussagnet',
	'FR40167' => 'Luxey',
	'FR40168' => 'Magescq',
	'FR40169' => 'Maillas',
	'FR40170' => 'Maillères',
	'FR40171' => 'Mano',
	'FR40172' => 'Mant',
	'FR40173' => 'Marpaps',
	'FR40174' => 'Mauries',
	'FR40175' => 'Maurrin',
	'FR40176' => 'Mauvezin-dArmagnac',
	'FR40177' => 'Maylis',
	'FR40178' => 'Mazerolles',
	'FR40179' => 'Mées',
	'FR40180' => 'Meilhan',
	'FR40181' => 'Messanges',
	'FR40182' => 'Mézos',
	'FR40183' => 'Mimbaste',
	'FR40184' => 'Mimizan',
	'FR40185' => 'Miramont-Sensacq',
	'FR40186' => 'Misson',
	'FR40187' => 'Moliets-et-Maa',
	'FR40188' => 'Momuy',
	'FR40189' => 'Monget',
	'FR40190' => 'Monségur',
	'FR40191' => 'Montaut',
	'FR40192' => 'Mont-de-Marsan',
	'FR40193' => 'Montégut',
	'FR40194' => 'Montfort-en-Chalosse',
	'FR40195' => 'Montgaillard',
	'FR40196' => 'Montsoué',
	'FR40197' => 'Morcenx-la-Nouvelle',
	'FR40198' => 'Morganx',
	'FR40199' => 'Mouscardès',
	'FR40200' => 'Moustey',
	'FR40201' => 'Mugron',
	'FR40202' => 'Narrosse',
	'FR40203' => 'Nassiet',
	'FR40204' => 'Nerbis',
	'FR40205' => 'Nousse',
	'FR40206' => 'Oeyregave',
	'FR40207' => 'Oeyreluy',
	'FR40208' => 'Onard',
	'FR40209' => 'Ondres',
	'FR40210' => 'Onesse-Laharie',
	'FR40211' => 'Orist',
	'FR40212' => 'Orthevielle',
	'FR40213' => 'Orx',
	'FR40214' => 'Ossages',
	'FR40215' => 'Ousse-Suzan',
	'FR40216' => 'Ozourt',
	'FR40217' => 'Parentis-en-Born',
	'FR40218' => 'Parleboscq',
	'FR40219' => 'Payros-Cazautets',
	'FR40220' => 'Pécorade',
	'FR40221' => 'Perquie',
	'FR40222' => 'Pey',
	'FR40223' => 'Peyre',
	'FR40224' => 'Peyrehorade',
	'FR40225' => 'Philondenx',
	'FR40226' => 'Pimbo',
	'FR40227' => 'Pissos',
	'FR40228' => 'Pomarez',
	'FR40229' => 'Pontenx-les-Forges',
	'FR40230' => 'Pontonx-sur-lAdour',
	'FR40231' => 'Port-de-Lanne',
	'FR40232' => 'Poudenx',
	'FR40233' => 'Pouillon',
	'FR40234' => 'Pouydesseaux',
	'FR40235' => 'Poyanne',
	'FR40236' => 'Poyartin',
	'FR40237' => 'Préchacq-les-Bains',
	'FR40238' => 'Pujo-le-Plan',
	'FR40239' => 'Puyol-Cazalet',
	'FR40240' => 'Renung',
	'FR40242' => 'Rimbez-et-Baudiets',
	'FR40243' => 'Rion-des-Landes',
	'FR40244' => 'Rivière-Saas-et-Gourby',
	'FR40245' => 'Roquefort',
	'FR40246' => 'Sabres',
	'FR40247' => 'Saint-Agnet',
	'FR40248' => 'Saint-André-de-Seignanx',
	'FR40249' => 'Saint-Aubin',
	'FR40250' => 'Saint-Avit',
	'FR40251' => 'Saint-Barthélemy',
	'FR40252' => 'Sainte-Colombe',
	'FR40253' => 'Saint-Cricq-Chalosse',
	'FR40254' => 'Saint-Cricq-du-Gave',
	'FR40255' => 'Saint-Cricq-Villeneuve',
	'FR40256' => 'Saint-Étienne-dOrthe',
	'FR40257' => 'Sainte-Eulalie-en-Born',
	'FR40258' => 'Sainte-Foy',
	'FR40259' => 'Saint-Gein',
	'FR40260' => 'Saint-Geours-dAuribat',
	'FR40261' => 'Saint-Geours-de-Maremne',
	'FR40262' => 'Saint-Gor',
	'FR40263' => 'Saint-Jean-de-Lier',
	'FR40264' => 'Saint-Jean-de-Marsacq',
	'FR40265' => 'Saint-Julien-dArmagnac',
	'FR40266' => 'Saint-Julien-en-Born',
	'FR40267' => 'Saint-Justin',
	'FR40268' => 'Saint-Laurent-de-Gosse',
	'FR40269' => 'Saint-Lon-les-Mines',
	'FR40270' => 'Saint-Loubouer',
	'FR40271' => 'Sainte-Marie-de-Gosse',
	'FR40272' => 'Saint-Martin-de-Hinx',
	'FR40273' => 'Saint-Martin-de-Seignanx',
	'FR40274' => 'Saint-Martin-dOney',
	'FR40275' => 'Saint-Maurice-sur-Adour',
	'FR40276' => 'Saint-Michel-Escalus',
	'FR40277' => 'Saint-Pandelon',
	'FR40278' => 'Saint-Paul-en-Born',
	'FR40279' => 'Saint-Paul-lès-Dax',
	'FR40280' => 'Saint-Perdon',
	'FR40281' => 'Saint-Pierre-du-Mont',
	'FR40282' => 'Saint-Sever',
	'FR40283' => 'Saint-Vincent-de-Paul',
	'FR40284' => 'Saint-Vincent-de-Tyrosse',
	'FR40285' => 'Saint-Yaguen',
	'FR40286' => 'Samadet',
	'FR40287' => 'Sanguinet',
	'FR40288' => 'Sarbazan',
	'FR40289' => 'Sarraziet',
	'FR40290' => 'Sarron',
	'FR40291' => 'Saubion',
	'FR40292' => 'Saubrigues',
	'FR40293' => 'Saubusse',
	'FR40294' => 'Saugnac-et-Cambran',
	'FR40295' => 'Saugnacq-et-Muret',
	'FR40296' => 'Seignosse',
	'FR40297' => 'Le Sen',
	'FR40298' => 'Serres-Gaston',
	'FR40299' => 'Serreslous-et-Arribans',
	'FR40300' => 'Seyresse',
	'FR40301' => 'Siest',
	'FR40303' => 'Solférino',
	'FR40304' => 'Soorts-Hossegor',
	'FR40305' => 'Sorbets',
	'FR40306' => 'Sorde-lAbbaye',
	'FR40307' => 'Sore',
	'FR40308' => 'Sort-en-Chalosse',
	'FR40309' => 'Souprosse',
	'FR40310' => 'Soustons',
	'FR40311' => 'Taller',
	'FR40312' => 'Tarnos',
	'FR40313' => 'Tartas',
	'FR40314' => 'Tercis-les-Bains',
	'FR40315' => 'Téthieu',
	'FR40316' => 'Tilh',
	'FR40317' => 'Tosse',
	'FR40318' => 'Toulouzette',
	'FR40319' => 'Trensacq',
	'FR40320' => 'Uchacq-et-Parentis',
	'FR40321' => 'Urgons',
	'FR40322' => 'Uza',
	'FR40323' => 'Vert',
	'FR40324' => 'Vicq-dAuribat',
	'FR40325' => 'Vielle-Tursan',
	'FR40326' => 'Vielle-Saint-Girons',
	'FR40327' => 'Vielle-Soubiran',
	'FR40328' => 'Vieux-Boucau-les-Bains',
	'FR40329' => 'Le Vignau',
	'FR40330' => 'Villenave',
	'FR40331' => 'Villeneuve-de-Marsan',
	'FR40332' => 'Ychoux',
	'FR40333' => 'Ygos-Saint-Saturnin',
	'FR40334' => 'Yzosse',
	'FR41001' => 'Ambloy',
	'FR41002' => 'Angé',
	'FR41003' => 'Areines',
	'FR41004' => 'Artins',
	'FR41006' => 'Autainville',
	'FR41007' => 'Authon',
	'FR41008' => 'Avaray',
	'FR41009' => 'Averdon',
	'FR41010' => 'Azé',
	'FR41012' => 'Baillou',
	'FR41013' => 'Bauzy',
	'FR41014' => 'Beauchêne',
	'FR41016' => 'Billy',
	'FR41017' => 'Binas',
	'FR41018' => 'Blois',
	'FR41019' => 'Boisseau',
	'FR41020' => 'Bonneveau',
	'FR41022' => 'Bouffry',
	'FR41024' => 'Boursay',
	'FR41025' => 'Bracieux',
	'FR41026' => 'Brévainville',
	'FR41027' => 'Briou',
	'FR41028' => 'Busloup',
	'FR41029' => 'Candé-sur-Beuvron',
	'FR41030' => 'Cellé',
	'FR41031' => 'Cellettes',
	'FR41032' => 'Chailles',
	'FR41034' => 'Chambord',
	'FR41035' => 'Champigny-en-Beauce',
	'FR41036' => 'Chaon',
	'FR41037' => 'La Chapelle-Enchérie',
	'FR41038' => 'La Chapelle-Montmartin',
	'FR41039' => 'La Chapelle-Saint-Martin-en-Plaine',
	'FR41040' => 'La Chapelle-Vendômoise',
	'FR41041' => 'La Chapelle-Vicomtesse',
	'FR41042' => 'Châteauvieux',
	'FR41043' => 'Châtillon-sur-Cher',
	'FR41044' => 'Châtres-sur-Cher',
	'FR41045' => 'Chaumont-sur-Loire',
	'FR41046' => 'Chaumont-sur-Tharonne',
	'FR41047' => 'La Chaussée-Saint-Victor',
	'FR41048' => 'Chauvigny-du-Perche',
	'FR41049' => 'Chémery',
	'FR41050' => 'Cheverny',
	'FR41051' => 'Chissay-en-Touraine',
	'FR41052' => 'Chitenay',
	'FR41053' => 'Choue',
	'FR41054' => 'Choussy',
	'FR41055' => 'Valloire-sur-Cisse',
	'FR41057' => 'Conan',
	'FR41058' => 'Concriers',
	'FR41059' => 'Le Controis-en-Sologne',
	'FR41060' => 'Cormenon',
	'FR41061' => 'Cormeray',
	'FR41062' => 'Couddes',
	'FR41063' => 'Couffy',
	'FR41065' => 'Coulommiers-la-Tour',
	'FR41066' => 'Courbouzon',
	'FR41067' => 'Cour-Cheverny',
	'FR41068' => 'Courmemin',
	'FR41069' => 'Cour-sur-Loire',
	'FR41070' => 'Vallée-de-Ronsard',
	'FR41071' => 'Crouy-sur-Cosson',
	'FR41072' => 'Crucheray',
	'FR41073' => 'Danzé',
	'FR41074' => 'Dhuizon',
	'FR41075' => 'Droué',
	'FR41077' => 'Épiais',
	'FR41078' => 'Épuisay',
	'FR41079' => 'Les Essarts',
	'FR41080' => 'Faverolles-sur-Cher',
	'FR41081' => 'Faye',
	'FR41083' => 'La Ferté-Beauharnais',
	'FR41084' => 'La Ferté-Imbault',
	'FR41085' => 'La Ferté-Saint-Cyr',
	'FR41086' => 'Fontaines-en-Sologne',
	'FR41087' => 'Fontaine-les-Coteaux',
	'FR41088' => 'Fontaine-Raoul',
	'FR41089' => 'La Fontenelle',
	'FR41090' => 'Fortan',
	'FR41091' => 'Fossé',
	'FR41093' => 'Françay',
	'FR41094' => 'Fresnes',
	'FR41095' => 'Fréteval',
	'FR41096' => 'Le Gault-du-Perche',
	'FR41097' => 'Gièvres',
	'FR41098' => 'Gombergean',
	'FR41099' => 'Gy-en-Sologne',
	'FR41100' => 'Les Hayes',
	'FR41101' => 'Herbault',
	'FR41102' => 'Houssay',
	'FR41103' => 'Huisseau-en-Beauce',
	'FR41104' => 'Huisseau-sur-Cosson',
	'FR41105' => 'Josnes',
	'FR41106' => 'Lamotte-Beuvron',
	'FR41107' => 'Lancé',
	'FR41108' => 'Lancôme',
	'FR41109' => 'Landes-le-Gaulois',
	'FR41110' => 'Langon-sur-Cher',
	'FR41112' => 'Lassay-sur-Croisne',
	'FR41113' => 'Lavardin',
	'FR41114' => 'Lestiou',
	'FR41115' => 'Lignières',
	'FR41116' => 'Lisle',
	'FR41118' => 'Loreux',
	'FR41119' => 'Lorges',
	'FR41120' => 'Lunay',
	'FR41121' => 'La Madeleine-Villefrouin',
	'FR41122' => 'Maray',
	'FR41123' => 'Marchenoir',
	'FR41124' => 'Marcilly-en-Beauce',
	'FR41125' => 'Marcilly-en-Gault',
	'FR41126' => 'Mareuil-sur-Cher',
	'FR41127' => 'La Marolle-en-Sologne',
	'FR41128' => 'Marolles',
	'FR41129' => 'Maslives',
	'FR41130' => 'Maves',
	'FR41131' => 'Mazangé',
	'FR41132' => 'Méhers',
	'FR41134' => 'Menars',
	'FR41135' => 'Mennetou-sur-Cher',
	'FR41136' => 'Mer',
	'FR41137' => 'Mesland',
	'FR41138' => 'Meslay',
	'FR41139' => 'Meusnes',
	'FR41140' => 'Millançay',
	'FR41141' => 'Moisy',
	'FR41142' => 'Valencisse',
	'FR41143' => 'Mondoubleau',
	'FR41144' => 'Monteaux',
	'FR41145' => 'Monthou-sur-Bièvre',
	'FR41146' => 'Monthou-sur-Cher',
	'FR41147' => 'Les Montils',
	'FR41148' => 'Montlivault',
	'FR41149' => 'Montoire-sur-le-Loir',
	'FR41150' => 'Mont-près-Chambord',
	'FR41151' => 'Montrichard Val de Cher',
	'FR41152' => 'Montrieux-en-Sologne',
	'FR41153' => 'Montrouveau',
	'FR41154' => 'Morée',
	'FR41155' => 'Muides-sur-Loire',
	'FR41156' => 'Mulsans',
	'FR41157' => 'Mur-de-Sologne',
	'FR41158' => 'Naveil',
	'FR41159' => 'Neung-sur-Beuvron',
	'FR41160' => 'Neuvy',
	'FR41161' => 'Nouan-le-Fuzelier',
	'FR41163' => 'Nourray',
	'FR41164' => 'Noyers-sur-Cher',
	'FR41166' => 'Oisly',
	'FR41167' => 'Veuzain-sur-Loire',
	'FR41168' => 'Orçay',
	'FR41171' => 'Oucques La Nouvelle',
	'FR41172' => 'Ouzouer-le-Doyen',
	'FR41173' => 'Beauce la Romaine',
	'FR41174' => 'Périgny',
	'FR41175' => 'Pezou',
	'FR41176' => 'Pierrefitte-sur-Sauldre',
	'FR41177' => 'Le Plessis-Dorin',
	'FR41178' => 'Le Plessis-lÉchelle',
	'FR41179' => 'Le Poislay',
	'FR41180' => 'Pontlevoy',
	'FR41181' => 'Pouillé',
	'FR41182' => 'Pray',
	'FR41184' => 'Prunay-Cassereau',
	'FR41185' => 'Pruniers-en-Sologne',
	'FR41186' => 'Rahart',
	'FR41187' => 'Renay',
	'FR41188' => 'Rhodon',
	'FR41189' => 'Rilly-sur-Loire',
	'FR41190' => 'Rocé',
	'FR41191' => 'Roches',
	'FR41192' => 'Les Roches-lÉvêque',
	'FR41193' => 'Romilly',
	'FR41194' => 'Romorantin-Lanthenay',
	'FR41195' => 'Rougeou',
	'FR41196' => 'Ruan-sur-Egvonne',
	'FR41198' => 'Saint-Aignan',
	'FR41199' => 'Saint-Amand-Longpré',
	'FR41200' => 'Sainte-Anne',
	'FR41201' => 'Saint-Arnoult',
	'FR41203' => 'Saint-Bohaire',
	'FR41204' => 'Saint-Claude-de-Diray',
	'FR41205' => 'Saint-Cyr-du-Gault',
	'FR41206' => 'Saint-Denis-sur-Loire',
	'FR41207' => 'Saint-Dyé-sur-Loire',
	'FR41208' => 'Saint-Étienne-des-Guérets',
	'FR41209' => 'Saint-Firmin-des-Prés',
	'FR41211' => 'Saint-Georges-sur-Cher',
	'FR41212' => 'Saint-Gervais-la-Forêt',
	'FR41213' => 'Saint-Gourgon',
	'FR41214' => 'Saint-Hilaire-la-Gravelle',
	'FR41215' => 'Saint-Jacques-des-Guérets',
	'FR41216' => 'Saint-Jean-Froidmentel',
	'FR41217' => 'Saint-Julien-de-Chédon',
	'FR41218' => 'Saint-Julien-sur-Cher',
	'FR41219' => 'Saint-Laurent-des-Bois',
	'FR41220' => 'Saint-Laurent-Nouan',
	'FR41221' => 'Saint-Léonard-en-Beauce',
	'FR41222' => 'Saint-Loup',
	'FR41223' => 'Saint-Lubin-en-Vergonnois',
	'FR41224' => 'Saint-Marc-du-Cor',
	'FR41225' => 'Saint-Martin-des-Bois',
	'FR41226' => 'Saint-Ouen',
	'FR41228' => 'Saint-Rimay',
	'FR41229' => 'Saint-Romain-sur-Cher',
	'FR41230' => 'Saint-Sulpice-de-Pommeray',
	'FR41231' => 'Saint-Viâtre',
	'FR41232' => 'Salbris',
	'FR41233' => 'Sambin',
	'FR41234' => 'Santenay',
	'FR41235' => 'Sargé-sur-Braye',
	'FR41236' => 'Sasnières',
	'FR41237' => 'Sassay',
	'FR41238' => 'Savigny-sur-Braye',
	'FR41239' => 'Seigy',
	'FR41241' => 'Selles-Saint-Denis',
	'FR41242' => 'Selles-sur-Cher',
	'FR41243' => 'Selommes',
	'FR41245' => 'Séris',
	'FR41246' => 'Seur',
	'FR41247' => 'Soings-en-Sologne',
	'FR41248' => 'Couëtron-au-Perche',
	'FR41249' => 'Souesmes',
	'FR41250' => 'Sougé',
	'FR41251' => 'Souvigny-en-Sologne',
	'FR41252' => 'Suèvres',
	'FR41253' => 'Talcy',
	'FR41254' => 'Le Temple',
	'FR41255' => 'Ternay',
	'FR41256' => 'Theillay',
	'FR41258' => 'Thésée',
	'FR41259' => 'Thoré-la-Rochette',
	'FR41260' => 'Thoury',
	'FR41261' => 'Tourailles',
	'FR41262' => 'Tour-en-Sologne',
	'FR41265' => 'Troo',
	'FR41266' => 'Valaire',
	'FR41267' => 'Vallières-les-Grandes',
	'FR41268' => 'Veilleins',
	'FR41269' => 'Vendôme',
	'FR41271' => 'Vernou-en-Sologne',
	'FR41273' => 'Vievy-le-Rayé',
	'FR41274' => 'Villavard',
	'FR41275' => 'La Ville-aux-Clercs',
	'FR41276' => 'Villebarou',
	'FR41277' => 'Villebout',
	'FR41278' => 'Villechauve',
	'FR41279' => 'Villedieu-le-Château',
	'FR41280' => 'Villefranche-sur-Cher',
	'FR41281' => 'Villefrancœur',
	'FR41282' => 'Villeherviers',
	'FR41283' => 'Villemardy',
	'FR41284' => 'Villeneuve-Frouville',
	'FR41285' => 'Villeny',
	'FR41286' => 'Villeporcher',
	'FR41287' => 'Villerable',
	'FR41288' => 'Villerbon',
	'FR41289' => 'Villermain',
	'FR41290' => 'Villeromain',
	'FR41291' => 'Villetrun',
	'FR41292' => 'Villexanton',
	'FR41293' => 'Villiersfaux',
	'FR41294' => 'Villiers-sur-Loir',
	'FR41295' => 'Vineuil',
	'FR41296' => 'Vouzon',
	'FR41297' => 'Yvoy-le-Marron',
	'FR42001' => 'Aboën',
	'FR42002' => 'Ailleux',
	'FR42003' => 'Ambierle',
	'FR42005' => 'Andrézieux-Bouthéon',
	'FR42006' => 'Apinac',
	'FR42007' => 'Arcinges',
	'FR42008' => 'Arcon',
	'FR42009' => 'Arthun',
	'FR42010' => 'Aveizieux',
	'FR42011' => 'Balbigny',
	'FR42012' => 'Bard',
	'FR42013' => 'Bellegarde-en-Forez',
	'FR42014' => 'Belleroche',
	'FR42015' => 'Belmont-de-la-Loire',
	'FR42016' => 'La Bénisson-Dieu',
	'FR42017' => 'Le Bessat',
	'FR42018' => 'Bessey',
	'FR42019' => 'Boën-sur-Lignon',
	'FR42020' => 'Boisset-lès-Montrond',
	'FR42021' => 'Boisset-Saint-Priest',
	'FR42022' => 'Bonson',
	'FR42023' => 'Bourg-Argental',
	'FR42025' => 'Boyer',
	'FR42026' => 'Briennon',
	'FR42027' => 'Bully',
	'FR42028' => 'Burdignes',
	'FR42029' => 'Bussières',
	'FR42030' => 'Bussy-Albieux',
	'FR42031' => 'Caloire',
	'FR42032' => 'Cellieu',
	'FR42033' => 'Le Cergne',
	'FR42034' => 'Cervières',
	'FR42035' => 'Cezay',
	'FR42036' => 'Chagnon',
	'FR42037' => 'Chalain-dUzore',
	'FR42038' => 'Chalain-le-Comtal',
	'FR42039' => 'Chalmazel-Jeansagnière',
	'FR42040' => 'La Chamba',
	'FR42041' => 'Chambéon',
	'FR42042' => 'Chambles',
	'FR42043' => 'Chambœuf',
	'FR42044' => 'Le Chambon-Feugerolles',
	'FR42045' => 'La Chambonie',
	'FR42046' => 'Champdieu',
	'FR42047' => 'Champoly',
	'FR42048' => 'Chandon',
	'FR42049' => 'Changy',
	'FR42050' => 'La Chapelle-en-Lafaye',
	'FR42051' => 'La Chapelle-Villars',
	'FR42052' => 'Charlieu',
	'FR42053' => 'Châteauneuf',
	'FR42054' => 'Châtelneuf',
	'FR42055' => 'Châtelus',
	'FR42056' => 'Chavanay',
	'FR42058' => 'Chazelles-sur-Lavieu',
	'FR42059' => 'Chazelles-sur-Lyon',
	'FR42060' => 'Chenereilles',
	'FR42061' => 'Cherier',
	'FR42062' => 'Chevrières',
	'FR42063' => 'Chirassimont',
	'FR42064' => 'Chuyer',
	'FR42065' => 'Civens',
	'FR42066' => 'Cleppé',
	'FR42067' => 'Colombier',
	'FR42068' => 'Combre',
	'FR42069' => 'Commelle-Vernay',
	'FR42070' => 'Cordelle',
	'FR42071' => 'Le Coteau',
	'FR42072' => 'La Côte-en-Couzan',
	'FR42073' => 'Cottance',
	'FR42074' => 'Coutouvre',
	'FR42075' => 'Craintilleux',
	'FR42076' => 'Cremeaux',
	'FR42077' => 'Croizet-sur-Gand',
	'FR42078' => 'Le Crozet',
	'FR42079' => 'Cuinzier',
	'FR42081' => 'Cuzieu',
	'FR42083' => 'Dargoire',
	'FR42084' => 'Débats-Rivière-dOrpra',
	'FR42085' => 'Doizieux',
	'FR42086' => 'Écoche',
	'FR42087' => 'Écotay-lOlme',
	'FR42088' => 'Épercieux-Saint-Paul',
	'FR42089' => 'Essertines-en-Châtelneuf',
	'FR42090' => 'Essertines-en-Donzy',
	'FR42091' => 'Estivareilles',
	'FR42092' => 'LÉtrat',
	'FR42093' => 'Farnay',
	'FR42094' => 'Feurs',
	'FR42095' => 'Firminy',
	'FR42096' => 'Fontanès',
	'FR42097' => 'La Fouillouse',
	'FR42098' => 'Fourneaux',
	'FR42099' => 'Fraisses',
	'FR42100' => 'La Gimond',
	'FR42101' => 'Graix',
	'FR42102' => 'Grammond',
	'FR42103' => 'La Grand-Croix',
	'FR42104' => 'La Gresle',
	'FR42105' => 'Grézieux-le-Fromental',
	'FR42106' => 'Grézolles',
	'FR42107' => 'Gumières',
	'FR42108' => 'LHôpital-le-Grand',
	'FR42109' => 'LHôpital-sous-Rochefort',
	'FR42110' => 'LHorme',
	'FR42112' => 'Jarnosse',
	'FR42113' => 'Jas',
	'FR42115' => 'Jonzieux',
	'FR42116' => 'Juré',
	'FR42117' => 'Lavieu',
	'FR42118' => 'Lay',
	'FR42119' => 'Leigneux',
	'FR42120' => 'Lentigny',
	'FR42121' => 'Lérigneux',
	'FR42122' => 'Lézigneux',
	'FR42123' => 'Lorette',
	'FR42124' => 'Lupé',
	'FR42125' => 'Luré',
	'FR42126' => 'Luriecq',
	'FR42127' => 'Mably',
	'FR42128' => 'Machézal',
	'FR42129' => 'Maclas',
	'FR42130' => 'Magneux-Haute-Rive',
	'FR42131' => 'Maizilly',
	'FR42132' => 'Malleval',
	'FR42133' => 'Marcenod',
	'FR42134' => 'Marcilly-le-Châtel',
	'FR42135' => 'Marclopt',
	'FR42136' => 'Marcoux',
	'FR42137' => 'Margerie-Chantagret',
	'FR42138' => 'Maringes',
	'FR42139' => 'Marlhes',
	'FR42140' => 'Marols',
	'FR42141' => 'Mars',
	'FR42142' => 'Merle-Leignec',
	'FR42143' => 'Mizérieux',
	'FR42145' => 'Montagny',
	'FR42146' => 'Montarcher',
	'FR42147' => 'Montbrison',
	'FR42148' => 'Montchal',
	'FR42149' => 'Montrond-les-Bains',
	'FR42150' => 'Montverdun',
	'FR42151' => 'Mornand-en-Forez',
	'FR42152' => 'Nandax',
	'FR42153' => 'Neaux',
	'FR42154' => 'Néronde',
	'FR42155' => 'Nervieux',
	'FR42156' => 'Neulise',
	'FR42157' => 'Noailly',
	'FR42158' => 'Les Noës',
	'FR42159' => 'Noirétable',
	'FR42160' => 'Nollieux',
	'FR42161' => 'Notre-Dame-de-Boisset',
	'FR42162' => 'Ouches',
	'FR42163' => 'La Pacaudière',
	'FR42164' => 'Palogneux',
	'FR42165' => 'Panissières',
	'FR42166' => 'Parigny',
	'FR42167' => 'Pavezin',
	'FR42168' => 'Pélussin',
	'FR42169' => 'Périgneux',
	'FR42170' => 'Perreux',
	'FR42171' => 'Pinay',
	'FR42172' => 'Planfoy',
	'FR42173' => 'Pommiers',
	'FR42174' => 'Poncins',
	'FR42175' => 'Pouilly-lès-Feurs',
	'FR42176' => 'Pouilly-les-Nonains',
	'FR42177' => 'Pouilly-sous-Charlieu',
	'FR42178' => 'Pradines',
	'FR42179' => 'Pralong',
	'FR42180' => 'Précieux',
	'FR42181' => 'Régny',
	'FR42182' => 'Renaison',
	'FR42183' => 'La Ricamarie',
	'FR42184' => 'Riorges',
	'FR42185' => 'Rivas',
	'FR42186' => 'Rive-de-Gier',
	'FR42187' => 'Roanne',
	'FR42188' => 'Roche',
	'FR42189' => 'Roche-la-Molière',
	'FR42191' => 'Roisey',
	'FR42192' => 'Rozier-Côtes-dAurec',
	'FR42193' => 'Rozier-en-Donzy',
	'FR42194' => 'Sail-les-Bains',
	'FR42195' => 'Sail-sous-Couzan',
	'FR42196' => 'Sainte-Agathe-en-Donzy',
	'FR42197' => 'Sainte-Agathe-la-Bouteresse',
	'FR42198' => 'Saint-Alban-les-Eaux',
	'FR42199' => 'Saint-André-dApchon',
	'FR42200' => 'Saint-André-le-Puy',
	'FR42201' => 'Saint-Appolinard',
	'FR42202' => 'Saint-Barthélemy-Lestra',
	'FR42203' => 'Saint-Bonnet-des-Quarts',
	'FR42204' => 'Saint-Bonnet-le-Château',
	'FR42205' => 'Saint-Bonnet-le-Courreau',
	'FR42206' => 'Saint-Bonnet-les-Oules',
	'FR42207' => 'Saint-Chamond',
	'FR42208' => 'Saint-Christo-en-Jarez',
	'FR42209' => 'Sainte-Colombe-sur-Gand',
	'FR42210' => 'Sainte-Croix-en-Jarez',
	'FR42211' => 'Saint-Cyprien',
	'FR42212' => 'Saint-Cyr-de-Favières',
	'FR42213' => 'Saint-Cyr-de-Valorges',
	'FR42214' => 'Saint-Cyr-les-Vignes',
	'FR42215' => 'Saint-Denis-de-Cabanne',
	'FR42216' => 'Saint-Denis-sur-Coise',
	'FR42217' => 'Saint-Didier-sur-Rochefort',
	'FR42218' => 'Saint-Étienne',
	'FR42219' => 'Saint-Étienne-le-Molard',
	'FR42220' => 'Saint-Forgeux-Lespinasse',
	'FR42221' => 'Sainte-Foy-Saint-Sulpice',
	'FR42222' => 'Saint-Galmier',
	'FR42223' => 'Saint-Genest-Lerpt',
	'FR42224' => 'Saint-Genest-Malifaux',
	'FR42225' => 'Genilac',
	'FR42226' => 'Saint-Georges-de-Baroille',
	'FR42227' => 'Saint-Georges-en-Couzan',
	'FR42228' => 'Saint-Georges-Haute-Ville',
	'FR42229' => 'Saint-Germain-la-Montagne',
	'FR42230' => 'Saint-Germain-Laval',
	'FR42231' => 'Saint-Germain-Lespinasse',
	'FR42232' => 'Saint-Haon-le-Châtel',
	'FR42233' => 'Saint-Haon-le-Vieux',
	'FR42234' => 'Saint-Héand',
	'FR42235' => 'Saint-Hilaire-Cusson-la-Valmitte',
	'FR42236' => 'Saint-Hilaire-sous-Charlieu',
	'FR42237' => 'Saint-Jean-Bonnefonds',
	'FR42238' => 'Saint-Jean-la-Vêtre',
	'FR42239' => 'Saint-Jean-Saint-Maurice-sur-Loire',
	'FR42240' => 'Saint-Jean-Soleymieux',
	'FR42241' => 'Saint-Jodard',
	'FR42242' => 'Saint-Joseph',
	'FR42243' => 'Saint-Julien-dOddes',
	'FR42245' => 'Vêtre-sur-Anzon',
	'FR42246' => 'Saint-Julien-Molin-Molette',
	'FR42247' => 'Saint-Just-en-Bas',
	'FR42248' => 'Saint-Just-en-Chevalet',
	'FR42249' => 'Saint-Just-la-Pendue',
	'FR42251' => 'Saint-Laurent-la-Conche',
	'FR42252' => 'Saint-Laurent-Rochefort',
	'FR42253' => 'Saint-Léger-sur-Roanne',
	'FR42254' => 'Saint-Marcel-de-Félines',
	'FR42255' => 'Saint-Marcel-dUrfé',
	'FR42256' => 'Saint-Marcellin-en-Forez',
	'FR42257' => 'Saint-Martin-dEstréaux',
	'FR42259' => 'Saint-Martin-la-Plaine',
	'FR42260' => 'Saint-Martin-la-Sauveté',
	'FR42261' => 'Saint-Martin-Lestra',
	'FR42262' => 'Saint-Maurice-en-Gourgois',
	'FR42264' => 'Saint-Médard-en-Forez',
	'FR42265' => 'Saint-Michel-sur-Rhône',
	'FR42266' => 'Saint-Nizier-de-Fornas',
	'FR42267' => 'Saint-Nizier-sous-Charlieu',
	'FR42268' => 'Vézelin-sur-Loire',
	'FR42269' => 'Saint-Paul-dUzore',
	'FR42270' => 'Saint-Paul-en-Cornillon',
	'FR42271' => 'Saint-Paul-en-Jarez',
	'FR42272' => 'Saint-Pierre-de-Bœuf',
	'FR42273' => 'Saint-Pierre-la-Noaille',
	'FR42274' => 'Saint-Polgues',
	'FR42275' => 'Saint-Priest-en-Jarez',
	'FR42276' => 'Saint-Priest-la-Prugne',
	'FR42277' => 'Saint-Priest-la-Roche',
	'FR42278' => 'Saint-Priest-la-Vêtre',
	'FR42279' => 'Saint-Just-Saint-Rambert',
	'FR42280' => 'Saint-Régis-du-Coin',
	'FR42281' => 'Saint-Rirand',
	'FR42282' => 'Saint-Romain-dUrfé',
	'FR42283' => 'Saint-Romain-en-Jarez',
	'FR42284' => 'Saint-Romain-la-Motte',
	'FR42285' => 'Saint-Romain-le-Puy',
	'FR42286' => 'Saint-Romain-les-Atheux',
	'FR42287' => 'Saint-Sauveur-en-Rue',
	'FR42288' => 'Saint-Sixte',
	'FR42289' => 'Saint-Symphorien-de-Lay',
	'FR42290' => 'Saint-Thomas-la-Garde',
	'FR42293' => 'Saint-Victor-sur-Rhins',
	'FR42294' => 'Saint-Vincent-de-Boisset',
	'FR42295' => 'Les Salles',
	'FR42296' => 'Salt-en-Donzy',
	'FR42297' => 'Salvizinet',
	'FR42298' => 'Sauvain',
	'FR42299' => 'Savigneux',
	'FR42300' => 'Sevelinges',
	'FR42301' => 'Soleymieux',
	'FR42302' => 'Sorbiers',
	'FR42303' => 'Souternon',
	'FR42304' => 'Sury-le-Comtal',
	'FR42305' => 'La Talaudière',
	'FR42306' => 'Tarentaise',
	'FR42307' => 'Tartaras',
	'FR42308' => 'La Terrasse-sur-Dorlay',
	'FR42310' => 'Thélis-la-Combe',
	'FR42311' => 'La Tour-en-Jarez',
	'FR42312' => 'La Tourette',
	'FR42313' => 'Trelins',
	'FR42314' => 'La Tuilière',
	'FR42315' => 'Unias',
	'FR42316' => 'Unieux',
	'FR42317' => 'Urbise',
	'FR42318' => 'Usson-en-Forez',
	'FR42319' => 'Valeille',
	'FR42320' => 'Valfleury',
	'FR42321' => 'La Valla-sur-Rochefort',
	'FR42322' => 'La Valla-en-Gier',
	'FR42323' => 'Veauche',
	'FR42324' => 'Veauchette',
	'FR42325' => 'Vendranges',
	'FR42326' => 'Véranne',
	'FR42327' => 'Vérin',
	'FR42328' => 'Verrières-en-Forez',
	'FR42329' => 'La Versanne',
	'FR42330' => 'Villars',
	'FR42331' => 'Villemontais',
	'FR42332' => 'Villerest',
	'FR42333' => 'Villers',
	'FR42334' => 'Violay',
	'FR42335' => 'Viricelles',
	'FR42336' => 'Virigneux',
	'FR42337' => 'Vivans',
	'FR42338' => 'Vougy',
	'FR42339' => 'Chausseterre',
	'FR43001' => 'Agnat',
	'FR43002' => 'Aiguilhe',
	'FR43003' => 'Allègre',
	'FR43004' => 'Alleyrac',
	'FR43005' => 'Alleyras',
	'FR43006' => 'Ally',
	'FR43007' => 'Araules',
	'FR43008' => 'Arlempdes',
	'FR43009' => 'Arlet',
	'FR43010' => 'Arsac-en-Velay',
	'FR43011' => 'Aubazat',
	'FR43012' => 'Aurec-sur-Loire',
	'FR43013' => 'Vissac-Auteyrac',
	'FR43014' => 'Autrac',
	'FR43015' => 'Auvers',
	'FR43016' => 'Auzon',
	'FR43017' => 'Azérat',
	'FR43018' => 'Bains',
	'FR43019' => 'Barges',
	'FR43020' => 'Bas-en-Basset',
	'FR43021' => 'Beaulieu',
	'FR43022' => 'Beaumont',
	'FR43023' => 'Beaune-sur-Arzon',
	'FR43024' => 'Beaux',
	'FR43025' => 'Beauzac',
	'FR43026' => 'Bellevue-la-Montagne',
	'FR43027' => 'Berbezit',
	'FR43028' => 'Bessamorel',
	'FR43029' => 'La Besseyre-Saint-Mary',
	'FR43030' => 'Blanzac',
	'FR43031' => 'Blassac',
	'FR43032' => 'Blavozy',
	'FR43033' => 'Blesle',
	'FR43034' => 'Boisset',
	'FR43035' => 'Bonneval',
	'FR43036' => 'Borne',
	'FR43037' => 'Le Bouchet-Saint-Nicolas',
	'FR43038' => 'Bournoncle-Saint-Pierre',
	'FR43039' => 'Le Brignon',
	'FR43040' => 'Brioude',
	'FR43041' => 'Brives-Charensac',
	'FR43042' => 'Cayres',
	'FR43043' => 'Céaux-dAllègre',
	'FR43044' => 'Cerzat',
	'FR43045' => 'Ceyssac',
	'FR43046' => 'Chadrac',
	'FR43047' => 'Chadron',
	'FR43048' => 'La Chaise-Dieu',
	'FR43049' => 'Chamalières-sur-Loire',
	'FR43050' => 'Chambezon',
	'FR43051' => 'Le Chambon-sur-Lignon',
	'FR43052' => 'Champagnac-le-Vieux',
	'FR43053' => 'Champclause',
	'FR43054' => 'Chanaleilles',
	'FR43055' => 'Chaniat',
	'FR43056' => 'Chanteuges',
	'FR43057' => 'La Chapelle-Bertin',
	'FR43058' => 'La Chapelle-dAurec',
	'FR43059' => 'La Chapelle-Geneste',
	'FR43060' => 'Charraix',
	'FR43061' => 'Chaspinhac',
	'FR43062' => 'Chaspuzac',
	'FR43063' => 'Chassagnes',
	'FR43064' => 'Chassignolles',
	'FR43065' => 'Chastel',
	'FR43066' => 'Chaudeyrolles',
	'FR43067' => 'Chavaniac-Lafayette',
	'FR43068' => 'Chazelles',
	'FR43069' => 'Chenereilles',
	'FR43070' => 'Chilhac',
	'FR43071' => 'Chomelix',
	'FR43072' => 'La Chomette',
	'FR43073' => 'Cistrières',
	'FR43074' => 'Cohade',
	'FR43075' => 'Collat',
	'FR43076' => 'Connangles',
	'FR43077' => 'Costaros',
	'FR43078' => 'Coubon',
	'FR43079' => 'Couteuges',
	'FR43080' => 'Craponne-sur-Arzon',
	'FR43082' => 'Cronce',
	'FR43083' => 'Cubelles',
	'FR43084' => 'Cussac-sur-Loire',
	'FR43085' => 'Desges',
	'FR43086' => 'Domeyrat',
	'FR43087' => 'Dunières',
	'FR43088' => 'Espalem',
	'FR43089' => 'Espaly-Saint-Marcel',
	'FR43090' => 'Esplantas-Vazeilles',
	'FR43091' => 'Les Estables',
	'FR43092' => 'Fay-sur-Lignon',
	'FR43093' => 'Félines',
	'FR43094' => 'Ferrussac',
	'FR43095' => 'Fix-Saint-Geneys',
	'FR43096' => 'Fontannes',
	'FR43097' => 'Freycenet-la-Cuche',
	'FR43098' => 'Freycenet-la-Tour',
	'FR43099' => 'Frugerès-les-Mines',
	'FR43100' => 'Frugières-le-Pin',
	'FR43101' => 'Goudet',
	'FR43102' => 'Grazac',
	'FR43103' => 'Grenier-Montgon',
	'FR43104' => 'Grèzes',
	'FR43105' => 'Javaugues',
	'FR43106' => 'Jax',
	'FR43107' => 'Josat',
	'FR43108' => 'Jullianges',
	'FR43109' => 'Lafarre',
	'FR43110' => 'Lamothe',
	'FR43111' => 'Landos',
	'FR43112' => 'Langeac',
	'FR43113' => 'Lantriac',
	'FR43114' => 'Lapte',
	'FR43115' => 'Laussonne',
	'FR43116' => 'Laval-sur-Doulon',
	'FR43117' => 'Lavaudieu',
	'FR43118' => 'Lavoûte-Chilhac',
	'FR43119' => 'Lavoûte-sur-Loire',
	'FR43120' => 'Lempdes-sur-Allagnon',
	'FR43121' => 'Léotoing',
	'FR43122' => 'Lissac',
	'FR43123' => 'Lorlanges',
	'FR43124' => 'Loudes',
	'FR43125' => 'Lubilhac',
	'FR43126' => 'Malrevers',
	'FR43127' => 'Malvalette',
	'FR43128' => 'Malvières',
	'FR43129' => 'Le Mas-de-Tence',
	'FR43130' => 'Mazet-Saint-Voy',
	'FR43131' => 'Mazerat-Aurouze',
	'FR43132' => 'Mazeyrat-dAllier',
	'FR43133' => 'Mercœur',
	'FR43134' => 'Mézères',
	'FR43135' => 'Le Monastier-sur-Gazeille',
	'FR43136' => 'Monistrol-dAllier',
	'FR43137' => 'Monistrol-sur-Loire',
	'FR43138' => 'Monlet',
	'FR43139' => 'Montclard',
	'FR43140' => 'Le Monteil',
	'FR43141' => 'Montfaucon-en-Velay',
	'FR43142' => 'Montregard',
	'FR43143' => 'Montusclat',
	'FR43144' => 'Moudeyres',
	'FR43145' => 'Ouides',
	'FR43147' => 'Paulhac',
	'FR43148' => 'Paulhaguet',
	'FR43149' => 'Pébrac',
	'FR43150' => 'Le Pertuis',
	'FR43151' => 'Pinols',
	'FR43152' => 'Polignac',
	'FR43153' => 'Pont-Salomon',
	'FR43154' => 'Pradelles',
	'FR43155' => 'Prades',
	'FR43156' => 'Présailles',
	'FR43157' => 'Le Puy-en-Velay',
	'FR43158' => 'Queyrières',
	'FR43159' => 'Raucoules',
	'FR43160' => 'Rauret',
	'FR43162' => 'Retournac',
	'FR43163' => 'Riotord',
	'FR43164' => 'Roche-en-Régnier',
	'FR43165' => 'Rosières',
	'FR43166' => 'Saint-André-de-Chalencon',
	'FR43167' => 'Saint-Arcons-dAllier',
	'FR43168' => 'Saint-Arcons-de-Barges',
	'FR43169' => 'Saint-Austremoine',
	'FR43170' => 'Saint-Beauzire',
	'FR43171' => 'Saint-Bérain',
	'FR43172' => 'Saint-Bonnet-le-Froid',
	'FR43173' => 'Saint-Christophe-dAllier',
	'FR43174' => 'Saint-Christophe-sur-Dolaison',
	'FR43175' => 'Saint-Cirgues',
	'FR43177' => 'Saint-Didier-en-Velay',
	'FR43178' => 'Saint-Didier-sur-Doulon',
	'FR43180' => 'Saint-Étienne-du-Vigan',
	'FR43181' => 'Saint-Étienne-Lardeyrol',
	'FR43182' => 'Saint-Étienne-sur-Blesle',
	'FR43183' => 'Sainte-Eugénie-de-Villeneuve',
	'FR43184' => 'Saint-Ferréol-dAuroure',
	'FR43185' => 'Sainte-Florine',
	'FR43186' => 'Saint-Front',
	'FR43187' => 'Saint-Geneys-près-Saint-Paulien',
	'FR43188' => 'Saint-Georges-dAurac',
	'FR43189' => 'Saint-Georges-Lagricol',
	'FR43190' => 'Saint-Germain-Laprade',
	'FR43191' => 'Saint-Géron',
	'FR43192' => 'Saint-Haon',
	'FR43193' => 'Saint-Hilaire',
	'FR43194' => 'Saint-Hostien',
	'FR43195' => 'Saint-Ilpize',
	'FR43196' => 'Saint-Jean-dAubrigoux',
	'FR43197' => 'Saint-Jean-de-Nay',
	'FR43198' => 'Saint-Jean-Lachalm',
	'FR43199' => 'Saint-Jeures',
	'FR43200' => 'Saint-Julien-Chapteuil',
	'FR43201' => 'Saint-Julien-dAnce',
	'FR43202' => 'Saint-Julien-des-Chazes',
	'FR43203' => 'Saint-Julien-du-Pinet',
	'FR43204' => 'Saint-Julien-Molhesabate',
	'FR43205' => 'Saint-Just-Malmont',
	'FR43206' => 'Saint-Just-près-Brioude',
	'FR43207' => 'Saint-Laurent-Chabreuges',
	'FR43208' => 'Sainte-Marguerite',
	'FR43210' => 'Saint-Martin-de-Fugères',
	'FR43211' => 'Saint-Maurice-de-Lignon',
	'FR43212' => 'Saint-Pal-de-Chalencon',
	'FR43213' => 'Saint-Pal-de-Mons',
	'FR43214' => 'Saint-Pal-de-Senouire',
	'FR43215' => 'Saint-Paul-de-Tartas',
	'FR43216' => 'Saint-Paulien',
	'FR43217' => 'Saint-Pierre-du-Champ',
	'FR43218' => 'Saint-Pierre-Eynac',
	'FR43219' => 'Saint-Préjet-Armandon',
	'FR43220' => 'Saint-Préjet-dAllier',
	'FR43221' => 'Saint-Privat-dAllier',
	'FR43222' => 'Saint-Privat-du-Dragon',
	'FR43223' => 'Saint-Romain-Lachalm',
	'FR43224' => 'Sainte-Sigolène',
	'FR43225' => 'Saint-Vénérand',
	'FR43226' => 'Saint-Vert',
	'FR43227' => 'Saint-Victor-Malescours',
	'FR43228' => 'Saint-Victor-sur-Arlanc',
	'FR43229' => 'Saint-Vidal',
	'FR43230' => 'Saint-Vincent',
	'FR43231' => 'Salettes',
	'FR43232' => 'Salzuit',
	'FR43233' => 'Sanssac-lÉglise',
	'FR43234' => 'Saugues',
	'FR43236' => 'La Séauve-sur-Semène',
	'FR43237' => 'Sembadel',
	'FR43238' => 'Séneujols',
	'FR43239' => 'Siaugues-Sainte-Marie',
	'FR43240' => 'Solignac-sous-Roche',
	'FR43241' => 'Solignac-sur-Loire',
	'FR43242' => 'Tailhac',
	'FR43244' => 'Tence',
	'FR43245' => 'Thoras',
	'FR43246' => 'Tiranges',
	'FR43247' => 'Torsiac',
	'FR43249' => 'Valprivas',
	'FR43250' => 'Vals-le-Chastel',
	'FR43251' => 'Vals-près-le-Puy',
	'FR43252' => 'Varennes-Saint-Honorat',
	'FR43253' => 'Les Vastres',
	'FR43254' => 'Vazeilles-Limandre',
	'FR43256' => 'Venteuges',
	'FR43257' => 'Vergezac',
	'FR43258' => 'Vergongheon',
	'FR43259' => 'Vernassal',
	'FR43260' => 'Le Vernet',
	'FR43261' => 'Vézézoux',
	'FR43262' => 'Vieille-Brioude',
	'FR43263' => 'Vielprat',
	'FR43264' => 'Villeneuve-dAllier',
	'FR43265' => 'Les Villettes',
	'FR43267' => 'Vorey',
	'FR43268' => 'Yssingeaux',
	'FR44001' => 'Abbaretz',
	'FR44002' => 'Aigrefeuille-sur-Maine',
	'FR44003' => 'Ancenis-Saint-Géréon',
	'FR44005' => 'Chaumes-en-Retz',
	'FR44006' => 'Assérac',
	'FR44007' => 'Avessac',
	'FR44009' => 'Basse-Goulaine',
	'FR44010' => 'Batz-sur-Mer',
	'FR44012' => 'La Bernerie-en-Retz',
	'FR44013' => 'Besné',
	'FR44014' => 'Le Bignon',
	'FR44015' => 'Blain',
	'FR44016' => 'La Boissière-du-Doré',
	'FR44018' => 'Bouaye',
	'FR44019' => 'Bouée',
	'FR44020' => 'Bouguenais',
	'FR44021' => 'Villeneuve-en-Retz',
	'FR44022' => 'Boussay',
	'FR44023' => 'Bouvron',
	'FR44024' => 'Brains',
	'FR44025' => 'Campbon',
	'FR44026' => 'Carquefou',
	'FR44027' => 'Casson',
	'FR44028' => 'Le Cellier',
	'FR44029' => 'Divatte-sur-Loire',
	'FR44030' => 'La Chapelle-des-Marais',
	'FR44031' => 'La Chapelle-Glain',
	'FR44032' => 'La Chapelle-Heulin',
	'FR44033' => 'La Chapelle-Launay',
	'FR44035' => 'La Chapelle-sur-Erdre',
	'FR44036' => 'Châteaubriant',
	'FR44037' => 'Château-Thébaud',
	'FR44038' => 'Chauvé',
	'FR44039' => 'Cheix-en-Retz',
	'FR44041' => 'La Chevrolière',
	'FR44043' => 'Clisson',
	'FR44044' => 'Conquereuil',
	'FR44045' => 'Cordemais',
	'FR44046' => 'Corsept',
	'FR44047' => 'Couëron',
	'FR44048' => 'Couffé',
	'FR44049' => 'Le Croisic',
	'FR44050' => 'Crossac',
	'FR44051' => 'Derval',
	'FR44052' => 'Donges',
	'FR44053' => 'Drefféac',
	'FR44054' => 'Erbray',
	'FR44055' => 'La Baule-Escoublac',
	'FR44056' => 'Fay-de-Bretagne',
	'FR44057' => 'Fégréac',
	'FR44058' => 'Fercé',
	'FR44061' => 'Frossay',
	'FR44062' => 'Le Gâvre',
	'FR44063' => 'Gétigné',
	'FR44064' => 'Gorges',
	'FR44065' => 'Grand-Auverné',
	'FR44066' => 'Grandchamps-des-Fontaines',
	'FR44067' => 'Guémené-Penfao',
	'FR44068' => 'Guenrouet',
	'FR44069' => 'Guérande',
	'FR44070' => 'La Haie-Fouassière',
	'FR44071' => 'Haute-Goulaine',
	'FR44072' => 'Herbignac',
	'FR44073' => 'Héric',
	'FR44074' => 'Indre',
	'FR44075' => 'Issé',
	'FR44076' => 'Jans',
	'FR44077' => 'Joué-sur-Erdre',
	'FR44078' => 'Juigné-des-Moutiers',
	'FR44079' => 'Le Landreau',
	'FR44080' => 'Lavau-sur-Loire',
	'FR44081' => 'Legé',
	'FR44082' => 'Ligné',
	'FR44083' => 'La Limouzinière',
	'FR44084' => 'Le Loroux-Bottereau',
	'FR44085' => 'Louisfert',
	'FR44086' => 'Lusanger',
	'FR44087' => 'Machecoul-Saint-Même',
	'FR44088' => 'Maisdon-sur-Sèvre',
	'FR44089' => 'Malville',
	'FR44090' => 'La Marne',
	'FR44091' => 'Marsac-sur-Don',
	'FR44092' => 'Massérac',
	'FR44094' => 'Mauves-sur-Loire',
	'FR44095' => 'La Meilleraye-de-Bretagne',
	'FR44096' => 'Mésanger',
	'FR44097' => 'Mesquer',
	'FR44098' => 'Missillac',
	'FR44099' => 'Moisdon-la-Rivière',
	'FR44100' => 'Monnières',
	'FR44101' => 'La Montagne',
	'FR44102' => 'Montbert',
	'FR44103' => 'Montoir-de-Bretagne',
	'FR44104' => 'Montrelais',
	'FR44105' => 'Mouais',
	'FR44106' => 'Les Moutiers-en-Retz',
	'FR44107' => 'Mouzeil',
	'FR44108' => 'Mouzillon',
	'FR44109' => 'Nantes',
	'FR44110' => 'Nort-sur-Erdre',
	'FR44111' => 'Notre-Dame-des-Landes',
	'FR44112' => 'Noyal-sur-Brutz',
	'FR44113' => 'Nozay',
	'FR44114' => 'Orvault',
	'FR44115' => 'Oudon',
	'FR44116' => 'Paimbœuf',
	'FR44117' => 'Le Pallet',
	'FR44118' => 'Pannecé',
	'FR44119' => 'Paulx',
	'FR44120' => 'Le Pellerin',
	'FR44121' => 'Petit-Auverné',
	'FR44122' => 'Petit-Mars',
	'FR44123' => 'Pierric',
	'FR44124' => 'Le Pin',
	'FR44125' => 'Piriac-sur-Mer',
	'FR44126' => 'La Plaine-sur-Mer',
	'FR44127' => 'La Planche',
	'FR44128' => 'Plessé',
	'FR44129' => 'Pontchâteau',
	'FR44130' => 'Pont-Saint-Martin',
	'FR44131' => 'Pornic',
	'FR44132' => 'Pornichet',
	'FR44133' => 'Port-Saint-Père',
	'FR44134' => 'Pouillé-les-Côteaux',
	'FR44135' => 'Le Pouliguen',
	'FR44136' => 'Préfailles',
	'FR44137' => 'Prinquiau',
	'FR44138' => 'Puceul',
	'FR44139' => 'Quilly',
	'FR44140' => 'La Regrippière',
	'FR44141' => 'La Remaudière',
	'FR44142' => 'Remouillé',
	'FR44143' => 'Rezé',
	'FR44144' => 'Riaillé',
	'FR44145' => 'Rouans',
	'FR44146' => 'Rougé',
	'FR44148' => 'Ruffigné',
	'FR44149' => 'Saffré',
	'FR44150' => 'Saint-Aignan-Grandlieu',
	'FR44151' => 'Saint-André-des-Eaux',
	'FR44152' => 'Sainte-Anne-sur-Brivet',
	'FR44153' => 'Saint-Aubin-des-Châteaux',
	'FR44154' => 'Saint-Brevin-les-Pins',
	'FR44155' => 'Saint-Colomban',
	'FR44156' => 'Corcoué-sur-Logne',
	'FR44157' => 'Saint-Étienne-de-Mer-Morte',
	'FR44158' => 'Saint-Étienne-de-Montluc',
	'FR44159' => 'Saint-Fiacre-sur-Maine',
	'FR44161' => 'Saint-Gildas-des-Bois',
	'FR44162' => 'Saint-Herblain',
	'FR44163' => 'Vair-sur-Loire',
	'FR44164' => 'Saint-Hilaire-de-Chaléons',
	'FR44165' => 'Saint-Hilaire-de-Clisson',
	'FR44166' => 'Saint-Jean-de-Boiseau',
	'FR44168' => 'Saint-Joachim',
	'FR44169' => 'Saint-Julien-de-Concelles',
	'FR44170' => 'Saint-Julien-de-Vouvantes',
	'FR44171' => 'Saint-Léger-les-Vignes',
	'FR44172' => 'Sainte-Luce-sur-Loire',
	'FR44173' => 'Saint-Lumine-de-Clisson',
	'FR44174' => 'Saint-Lumine-de-Coutais',
	'FR44175' => 'Saint-Lyphard',
	'FR44176' => 'Saint-Malo-de-Guersac',
	'FR44178' => 'Saint-Mars-de-Coutais',
	'FR44179' => 'Saint-Mars-du-Désert',
	'FR44180' => 'Vallons-de-lErdre',
	'FR44182' => 'Saint-Michel-Chef-Chef',
	'FR44183' => 'Saint-Molf',
	'FR44184' => 'Saint-Nazaire',
	'FR44185' => 'Saint-Nicolas-de-Redon',
	'FR44186' => 'Sainte-Pazanne',
	'FR44187' => 'Saint-Père-en-Retz',
	'FR44188' => 'Saint-Philbert-de-Grand-Lieu',
	'FR44189' => 'Sainte-Reine-de-Bretagne',
	'FR44190' => 'Saint-Sébastien-sur-Loire',
	'FR44192' => 'Saint-Viaud',
	'FR44193' => 'Saint-Vincent-des-Landes',
	'FR44194' => 'Sautron',
	'FR44195' => 'Savenay',
	'FR44196' => 'Sévérac',
	'FR44197' => 'Sion-les-Mines',
	'FR44198' => 'Les Sorinières',
	'FR44199' => 'Soudan',
	'FR44200' => 'Soulvache',
	'FR44201' => 'Sucé-sur-Erdre',
	'FR44202' => 'Teillé',
	'FR44203' => 'Le Temple-de-Bretagne',
	'FR44204' => 'Thouaré-sur-Loire',
	'FR44205' => 'Les Touches',
	'FR44206' => 'Touvois',
	'FR44207' => 'Trans-sur-Erdre',
	'FR44208' => 'Treffieux',
	'FR44209' => 'Treillières',
	'FR44210' => 'Trignac',
	'FR44211' => 'La Turballe',
	'FR44212' => 'Vallet',
	'FR44213' => 'Loireauxence',
	'FR44214' => 'Vay',
	'FR44215' => 'Vertou',
	'FR44216' => 'Vieillevigne',
	'FR44217' => 'Vigneux-de-Bretagne',
	'FR44218' => 'Villepot',
	'FR44220' => 'Vue',
	'FR44221' => 'La Chevallerais',
	'FR44222' => 'La Roche-Blanche',
	'FR44223' => 'Geneston',
	'FR44224' => 'La Grigonnais',
	'FR45001' => 'Adon',
	'FR45002' => 'Aillant-sur-Milleron',
	'FR45004' => 'Amilly',
	'FR45005' => 'Andonville',
	'FR45006' => 'Ardon',
	'FR45008' => 'Artenay',
	'FR45009' => 'Aschères-le-Marché',
	'FR45010' => 'Ascoux',
	'FR45011' => 'Attray',
	'FR45012' => 'Audeville',
	'FR45013' => 'Augerville-la-Rivière',
	'FR45014' => 'Aulnay-la-Rivière',
	'FR45015' => 'Autruy-sur-Juine',
	'FR45016' => 'Autry-le-Châtel',
	'FR45017' => 'Auvilliers-en-Gâtinais',
	'FR45018' => 'Auxy',
	'FR45019' => 'Baccon',
	'FR45020' => 'Le Bardon',
	'FR45021' => 'Barville-en-Gâtinais',
	'FR45022' => 'Batilly-en-Gâtinais',
	'FR45023' => 'Batilly-en-Puisaye',
	'FR45024' => 'Baule',
	'FR45025' => 'Bazoches-les-Gallerandes',
	'FR45026' => 'Bazoches-sur-le-Betz',
	'FR45027' => 'Beauchamps-sur-Huillard',
	'FR45028' => 'Beaugency',
	'FR45029' => 'Beaulieu-sur-Loire',
	'FR45030' => 'Beaune-la-Rolande',
	'FR45031' => 'Bellegarde',
	'FR45032' => 'Le Bignon-Mirabeau',
	'FR45033' => 'Boësses',
	'FR45034' => 'Boigny-sur-Bionne',
	'FR45035' => 'Boiscommun',
	'FR45036' => 'Boismorand',
	'FR45037' => 'Boisseaux',
	'FR45038' => 'Bondaroy',
	'FR45039' => 'Bonnée',
	'FR45040' => 'Bonny-sur-Loire',
	'FR45041' => 'Bordeaux-en-Gâtinais',
	'FR45042' => 'Les Bordes',
	'FR45043' => 'Bou',
	'FR45044' => 'Bougy-lez-Neuville',
	'FR45045' => 'Bouilly-en-Gâtinais',
	'FR45046' => 'Boulay-les-Barres',
	'FR45047' => 'Bouzonville-aux-Bois',
	'FR45049' => 'Bouzy-la-Forêt',
	'FR45050' => 'Boynes',
	'FR45051' => 'Bray-Saint-Aignan',
	'FR45052' => 'Breteau',
	'FR45053' => 'Briare',
	'FR45054' => 'Briarres-sur-Essonne',
	'FR45055' => 'Bricy',
	'FR45056' => 'Bromeilles',
	'FR45058' => 'Bucy-le-Roi',
	'FR45059' => 'Bucy-Saint-Liphard',
	'FR45060' => 'La Bussière',
	'FR45061' => 'Cepoy',
	'FR45062' => 'Cercottes',
	'FR45063' => 'Cerdon',
	'FR45064' => 'Cernoy-en-Berry',
	'FR45065' => 'Césarville-Dossainville',
	'FR45066' => 'Chailly-en-Gâtinais',
	'FR45067' => 'Chaingy',
	'FR45068' => 'Châlette-sur-Loing',
	'FR45069' => 'Chambon-la-Forêt',
	'FR45070' => 'Champoulet',
	'FR45072' => 'Chanteau',
	'FR45073' => 'Chantecoq',
	'FR45074' => 'La Chapelle-Onzerain',
	'FR45075' => 'La Chapelle-Saint-Mesmin',
	'FR45076' => 'La Chapelle-Saint-Sépulcre',
	'FR45077' => 'La Chapelle-sur-Aveyron',
	'FR45078' => 'Chapelon',
	'FR45079' => 'Le Charme',
	'FR45080' => 'Charmont-en-Beauce',
	'FR45081' => 'Charsonville',
	'FR45082' => 'Châteauneuf-sur-Loire',
	'FR45083' => 'Château-Renard',
	'FR45084' => 'Châtenoy',
	'FR45085' => 'Châtillon-Coligny',
	'FR45086' => 'Châtillon-le-Roi',
	'FR45087' => 'Châtillon-sur-Loire',
	'FR45088' => 'Chaussy',
	'FR45089' => 'Chécy',
	'FR45091' => 'Chevannes',
	'FR45092' => 'Chevillon-sur-Huillard',
	'FR45093' => 'Chevilly',
	'FR45094' => 'Chevry-sous-le-Bignon',
	'FR45095' => 'Chilleurs-aux-Bois',
	'FR45096' => 'Les Choux',
	'FR45097' => 'Chuelles',
	'FR45098' => 'Cléry-Saint-André',
	'FR45099' => 'Coinces',
	'FR45100' => 'Combleux',
	'FR45101' => 'Combreux',
	'FR45102' => 'Conflans-sur-Loing',
	'FR45103' => 'Corbeilles',
	'FR45104' => 'Corquilleroy',
	'FR45105' => 'Cortrat',
	'FR45107' => 'Coudroy',
	'FR45108' => 'Coullons',
	'FR45109' => 'Coulmiers',
	'FR45110' => 'Courcelles-le-Roi',
	'FR45111' => 'Courcy-aux-Loges',
	'FR45112' => 'La Cour-Marigny',
	'FR45113' => 'Courtemaux',
	'FR45114' => 'Courtempierre',
	'FR45115' => 'Courtenay',
	'FR45116' => 'Cravant',
	'FR45118' => 'Crottes-en-Pithiverais',
	'FR45119' => 'Dadonville',
	'FR45120' => 'Dammarie-en-Puisaye',
	'FR45121' => 'Dammarie-sur-Loing',
	'FR45122' => 'Dampierre-en-Burly',
	'FR45123' => 'Darvoy',
	'FR45124' => 'Desmonts',
	'FR45125' => 'Dimancheville',
	'FR45126' => 'Donnery',
	'FR45127' => 'Dordives',
	'FR45129' => 'Douchy-Montcorbon',
	'FR45130' => 'Dry',
	'FR45131' => 'Échilleuses',
	'FR45132' => 'Égry',
	'FR45133' => 'Engenville',
	'FR45134' => 'Épieds-en-Beauce',
	'FR45135' => 'Erceville',
	'FR45136' => 'Ervauville',
	'FR45137' => 'Escrennes',
	'FR45138' => 'Escrignelles',
	'FR45139' => 'Estouy',
	'FR45141' => 'Faverelles',
	'FR45142' => 'Fay-aux-Loges',
	'FR45143' => 'Feins-en-Gâtinais',
	'FR45144' => 'Férolles',
	'FR45145' => 'Ferrières-en-Gâtinais',
	'FR45146' => 'La Ferté-Saint-Aubin',
	'FR45147' => 'Fleury-les-Aubrais',
	'FR45148' => 'Fontenay-sur-Loing',
	'FR45149' => 'Foucherolles',
	'FR45150' => 'Fréville-du-Gâtinais',
	'FR45151' => 'Gaubertin',
	'FR45152' => 'Gémigny',
	'FR45153' => 'Germigny-des-Prés',
	'FR45154' => 'Gidy',
	'FR45155' => 'Gien',
	'FR45156' => 'Girolles',
	'FR45157' => 'Givraines',
	'FR45158' => 'Gondreville',
	'FR45159' => 'Grangermont',
	'FR45160' => 'Greneville-en-Beauce',
	'FR45161' => 'Griselles',
	'FR45162' => 'Guigneville',
	'FR45164' => 'Guilly',
	'FR45165' => 'Gy-les-Nonains',
	'FR45166' => 'Huêtre',
	'FR45167' => 'Huisseau-sur-Mauves',
	'FR45168' => 'Ingrannes',
	'FR45169' => 'Ingré',
	'FR45170' => 'Intville-la-Guétard',
	'FR45171' => 'Isdes',
	'FR45173' => 'Jargeau',
	'FR45174' => 'Jouy-en-Pithiverais',
	'FR45175' => 'Jouy-le-Potier',
	'FR45176' => 'Juranville',
	'FR45177' => 'Laas',
	'FR45178' => 'Ladon',
	'FR45179' => 'Lailly-en-Val',
	'FR45180' => 'Langesse',
	'FR45181' => 'Léouville',
	'FR45182' => 'Ligny-le-Ribault',
	'FR45183' => 'Lion-en-Beauce',
	'FR45184' => 'Lion-en-Sullias',
	'FR45185' => 'Lombreuil',
	'FR45186' => 'Lorcy',
	'FR45187' => 'Lorris',
	'FR45188' => 'Loury',
	'FR45189' => 'Louzouer',
	'FR45191' => 'Le Malesherbois',
	'FR45193' => 'Marcilly-en-Villette',
	'FR45194' => 'Mardié',
	'FR45195' => 'Mareau-aux-Bois',
	'FR45196' => 'Mareau-aux-Prés',
	'FR45197' => 'Marigny-les-Usages',
	'FR45198' => 'Marsainvilliers',
	'FR45199' => 'Melleroy',
	'FR45200' => 'Ménestreau-en-Villette',
	'FR45201' => 'Mérinville',
	'FR45202' => 'Messas',
	'FR45203' => 'Meung-sur-Loire',
	'FR45204' => 'Mézières-lez-Cléry',
	'FR45205' => 'Mézières-en-Gâtinais',
	'FR45206' => 'Mignères',
	'FR45207' => 'Mignerette',
	'FR45208' => 'Montargis',
	'FR45209' => 'Montbarrois',
	'FR45210' => 'Montbouy',
	'FR45212' => 'Montcresson',
	'FR45213' => 'Montereau',
	'FR45214' => 'Montigny',
	'FR45215' => 'Montliard',
	'FR45216' => 'Mormant-sur-Vernisson',
	'FR45217' => 'Morville-en-Beauce',
	'FR45218' => 'Le Moulinet-sur-Solin',
	'FR45219' => 'Moulon',
	'FR45220' => 'Nancray-sur-Rimarde',
	'FR45222' => 'Nargis',
	'FR45223' => 'Nesploy',
	'FR45224' => 'Neuville-aux-Bois',
	'FR45225' => 'La Neuville-sur-Essonne',
	'FR45226' => 'Neuvy-en-Sullias',
	'FR45227' => 'Nevoy',
	'FR45228' => 'Nibelle',
	'FR45229' => 'Nogent-sur-Vernisson',
	'FR45230' => 'Noyers',
	'FR45231' => 'Oison',
	'FR45232' => 'Olivet',
	'FR45233' => 'Ondreville-sur-Essonne',
	'FR45234' => 'Orléans',
	'FR45235' => 'Ormes',
	'FR45237' => 'Orville',
	'FR45238' => 'Ousson-sur-Loire',
	'FR45239' => 'Oussoy-en-Gâtinais',
	'FR45240' => 'Outarville',
	'FR45241' => 'Ouvrouer-les-Champs',
	'FR45242' => 'Ouzouer-des-Champs',
	'FR45243' => 'Ouzouer-sous-Bellegarde',
	'FR45244' => 'Ouzouer-sur-Loire',
	'FR45245' => 'Ouzouer-sur-Trézée',
	'FR45246' => 'Pannecières',
	'FR45247' => 'Pannes',
	'FR45248' => 'Patay',
	'FR45249' => 'Paucourt',
	'FR45250' => 'Pers-en-Gâtinais',
	'FR45251' => 'Pierrefitte-ès-Bois',
	'FR45252' => 'Pithiviers',
	'FR45253' => 'Pithiviers-le-Vieil',
	'FR45254' => 'Poilly-lez-Gien',
	'FR45255' => 'Préfontaines',
	'FR45256' => 'Presnoy',
	'FR45257' => 'Pressigny-les-Pins',
	'FR45258' => 'Puiseaux',
	'FR45259' => 'Quiers-sur-Bézonde',
	'FR45260' => 'Ramoulu',
	'FR45261' => 'Rebréchien',
	'FR45262' => 'Rouvray-Sainte-Croix',
	'FR45263' => 'Rouvres-Saint-Jean',
	'FR45264' => 'Rozières-en-Beauce',
	'FR45265' => 'Rozoy-le-Vieil',
	'FR45266' => 'Ruan',
	'FR45268' => 'Saint-Aignan-le-Jaillard',
	'FR45269' => 'Saint-Ay',
	'FR45270' => 'Saint-Benoît-sur-Loire',
	'FR45271' => 'Saint-Brisson-sur-Loire',
	'FR45272' => 'Saint-Cyr-en-Val',
	'FR45273' => 'Saint-Denis-de-lHôtel',
	'FR45274' => 'Saint-Denis-en-Val',
	'FR45275' => 'Saint-Firmin-des-Bois',
	'FR45276' => 'Saint-Firmin-sur-Loire',
	'FR45277' => 'Saint-Florent',
	'FR45278' => 'Sainte-Geneviève-des-Bois',
	'FR45279' => 'Saint-Germain-des-Prés',
	'FR45280' => 'Saint-Gondon',
	'FR45281' => 'Saint-Hilaire-les-Andrésis',
	'FR45282' => 'Saint-Hilaire-Saint-Mesmin',
	'FR45283' => 'Saint-Hilaire-sur-Puiseaux',
	'FR45284' => 'Saint-Jean-de-Braye',
	'FR45285' => 'Saint-Jean-de-la-Ruelle',
	'FR45286' => 'Saint-Jean-le-Blanc',
	'FR45287' => 'Saint-Loup-de-Gonois',
	'FR45288' => 'Saint-Loup-des-Vignes',
	'FR45289' => 'Saint-Lyé-la-Forêt',
	'FR45290' => 'Saint-Martin-dAbbat',
	'FR45291' => 'Saint-Martin-sur-Ocre',
	'FR45292' => 'Saint-Maurice-sur-Aveyron',
	'FR45293' => 'Saint-Maurice-sur-Fessard',
	'FR45294' => 'Saint-Michel',
	'FR45296' => 'Saint-Péravy-la-Colombe',
	'FR45297' => 'Saint-Père-sur-Loire',
	'FR45298' => 'Saint-Pryvé-Saint-Mesmin',
	'FR45299' => 'Saint-Sigismond',
	'FR45300' => 'Sandillon',
	'FR45301' => 'Santeau',
	'FR45302' => 'Saran',
	'FR45303' => 'Sceaux-du-Gâtinais',
	'FR45305' => 'Seichebrières',
	'FR45306' => 'La Selle-en-Hermoy',
	'FR45307' => 'La Selle-sur-le-Bied',
	'FR45308' => 'Semoy',
	'FR45309' => 'Sennely',
	'FR45310' => 'Sermaises',
	'FR45311' => 'Sigloy',
	'FR45312' => 'Solterre',
	'FR45313' => 'Sougy',
	'FR45314' => 'Sully-la-Chapelle',
	'FR45315' => 'Sully-sur-Loire',
	'FR45316' => 'Sury-aux-Bois',
	'FR45317' => 'Tavers',
	'FR45320' => 'Thignonville',
	'FR45321' => 'Thimory',
	'FR45322' => 'Thorailles',
	'FR45323' => 'Thou',
	'FR45324' => 'Tigy',
	'FR45325' => 'Tivernon',
	'FR45326' => 'Tournoisis',
	'FR45327' => 'Traînou',
	'FR45328' => 'Treilles-en-Gâtinais',
	'FR45329' => 'Triguères',
	'FR45330' => 'Trinay',
	'FR45331' => 'Vannes-sur-Cosson',
	'FR45332' => 'Varennes-Changy',
	'FR45333' => 'Vennecy',
	'FR45334' => 'Vieilles-Maisons-sur-Joudry',
	'FR45335' => 'Vienne-en-Val',
	'FR45336' => 'Viglain',
	'FR45337' => 'Villamblain',
	'FR45338' => 'Villemandeur',
	'FR45339' => 'Villemoutiers',
	'FR45340' => 'Villemurlin',
	'FR45341' => 'Villeneuve-sur-Conie',
	'FR45342' => 'Villereau',
	'FR45343' => 'Villevoques',
	'FR45344' => 'Villorceau',
	'FR45345' => 'Vimory',
	'FR45346' => 'Vitry-aux-Loges',
	'FR45347' => 'Vrigny',
	'FR45348' => 'Yèvre-la-Ville',
	'FR46001' => 'Albas',
	'FR46002' => 'Albiac',
	'FR46003' => 'Alvignac',
	'FR46004' => 'Anglars',
	'FR46005' => 'Anglars-Juillac',
	'FR46006' => 'Anglars-Nozac',
	'FR46007' => 'Arcambal',
	'FR46008' => 'Les Arques',
	'FR46009' => 'Assier',
	'FR46010' => 'Aujols',
	'FR46011' => 'Autoire',
	'FR46012' => 'Aynac',
	'FR46013' => 'Bach',
	'FR46015' => 'Bagnac-sur-Célé',
	'FR46016' => 'Baladou',
	'FR46017' => 'Bannes',
	'FR46018' => 'Le Bastit',
	'FR46020' => 'Beauregard',
	'FR46021' => 'Béduer',
	'FR46022' => 'Bélaye',
	'FR46023' => 'Belfort-du-Quercy',
	'FR46024' => 'Belmont-Bretenoux',
	'FR46026' => 'Belmont-Sainte-Foi',
	'FR46027' => 'Berganty',
	'FR46028' => 'Bétaille',
	'FR46029' => 'Biars-sur-Cère',
	'FR46030' => 'Bio',
	'FR46031' => 'Blars',
	'FR46032' => 'Boissières',
	'FR46033' => 'Porte-du-Quercy',
	'FR46034' => 'Le Bourg',
	'FR46035' => 'Boussac',
	'FR46036' => 'Le Bouyssou',
	'FR46037' => 'Bouziès',
	'FR46038' => 'Bretenoux',
	'FR46039' => 'Brengues',
	'FR46040' => 'Cabrerets',
	'FR46041' => 'Cadrieu',
	'FR46042' => 'Cahors',
	'FR46043' => 'Cahus',
	'FR46044' => 'Caillac',
	'FR46045' => 'Cajarc',
	'FR46046' => 'Calamane',
	'FR46047' => 'Calès',
	'FR46049' => 'Calvignac',
	'FR46050' => 'Cambayrac',
	'FR46051' => 'Cambes',
	'FR46052' => 'Camboulit',
	'FR46053' => 'Camburat',
	'FR46054' => 'Caniac-du-Causse',
	'FR46055' => 'Capdenac',
	'FR46056' => 'Carayac',
	'FR46057' => 'Cardaillac',
	'FR46058' => 'Carennac',
	'FR46059' => 'Carlucet',
	'FR46060' => 'Carnac-Rouffiac',
	'FR46061' => 'Cassagnes',
	'FR46062' => 'Castelfranc',
	'FR46063' => 'Castelnau Montratier-Sainte Alauzie',
	'FR46064' => 'Catus',
	'FR46065' => 'Cavagnac',
	'FR46066' => 'Cazals',
	'FR46068' => 'Cénevières',
	'FR46069' => 'Cézac',
	'FR46070' => 'Cieurac',
	'FR46072' => 'Concorès',
	'FR46073' => 'Concots',
	'FR46074' => 'Condat',
	'FR46075' => 'Corn',
	'FR46076' => 'Cornac',
	'FR46078' => 'Couzou',
	'FR46079' => 'Cras',
	'FR46080' => 'Crayssac',
	'FR46081' => 'Crégols',
	'FR46082' => 'Cremps',
	'FR46083' => 'Cressensac-Sarrazac',
	'FR46084' => 'Creysse',
	'FR46085' => 'Cuzac',
	'FR46086' => 'Cuzance',
	'FR46087' => 'Dégagnac',
	'FR46088' => 'Douelle',
	'FR46089' => 'Duravel',
	'FR46090' => 'Durbans',
	'FR46091' => 'Escamps',
	'FR46092' => 'Esclauzels',
	'FR46093' => 'Espagnac-Sainte-Eulalie',
	'FR46094' => 'Espédaillac',
	'FR46095' => 'Espère',
	'FR46096' => 'Espeyroux',
	'FR46097' => 'Estal',
	'FR46098' => 'Fajoles',
	'FR46100' => 'Faycelles',
	'FR46101' => 'Felzins',
	'FR46102' => 'Figeac',
	'FR46103' => 'Saint-Paul-Flaugnac',
	'FR46104' => 'Flaujac-Gare',
	'FR46105' => 'Flaujac-Poujols',
	'FR46106' => 'Floirac',
	'FR46107' => 'Floressas',
	'FR46108' => 'Fons',
	'FR46109' => 'Fontanes',
	'FR46111' => 'Fourmagnac',
	'FR46112' => 'Francoulès',
	'FR46113' => 'Frayssinet',
	'FR46114' => 'Frayssinet-le-Gélat',
	'FR46115' => 'Frayssinhes',
	'FR46116' => 'Frontenac',
	'FR46117' => 'Gagnac-sur-Cère',
	'FR46118' => 'Gignac',
	'FR46119' => 'Gigouzac',
	'FR46120' => 'Gindou',
	'FR46121' => 'Ginouillac',
	'FR46122' => 'Gintrac',
	'FR46123' => 'Girac',
	'FR46124' => 'Glanes',
	'FR46125' => 'Gorses',
	'FR46126' => 'Goujounac',
	'FR46127' => 'Gourdon',
	'FR46128' => 'Gramat',
	'FR46129' => 'Gréalou',
	'FR46130' => 'Grézels',
	'FR46131' => 'Grèzes',
	'FR46132' => 'Issendolus',
	'FR46133' => 'Issepts',
	'FR46134' => 'Les Junies',
	'FR46135' => 'Labastide-du-Haut-Mont',
	'FR46136' => 'Labastide-du-Vert',
	'FR46137' => 'Labastide-Marnhac',
	'FR46138' => 'Cœur de Causse',
	'FR46139' => 'Labathude',
	'FR46140' => 'Laburgade',
	'FR46142' => 'Lacapelle-Cabanac',
	'FR46143' => 'Lacapelle-Marival',
	'FR46144' => 'Lacave',
	'FR46145' => 'Lachapelle-Auzac',
	'FR46146' => 'Ladirat',
	'FR46147' => 'Lagardelle',
	'FR46148' => 'Lalbenque',
	'FR46149' => 'Lamagdelaine',
	'FR46151' => 'Lamothe-Cassel',
	'FR46152' => 'Lamothe-Fénelon',
	'FR46153' => 'Lanzac',
	'FR46154' => 'Laramière',
	'FR46155' => 'Larnagol',
	'FR46156' => 'Bellefont-La Rauze',
	'FR46157' => 'Larroque-Toirac',
	'FR46159' => 'Latouille-Lentillac',
	'FR46160' => 'Latronquière',
	'FR46161' => 'Lauresses',
	'FR46162' => 'Lauzès',
	'FR46163' => 'Laval-de-Cère',
	'FR46164' => 'Lavercantière',
	'FR46165' => 'Lavergne',
	'FR46167' => 'Lentillac-du-Causse',
	'FR46168' => 'Lentillac-Saint-Blaise',
	'FR46169' => 'Léobard',
	'FR46170' => 'Leyme',
	'FR46171' => 'Lherm',
	'FR46172' => 'Lhospitalet',
	'FR46173' => 'Limogne-en-Quercy',
	'FR46174' => 'Linac',
	'FR46175' => 'Lissac-et-Mouret',
	'FR46176' => 'Livernon',
	'FR46177' => 'Loubressac',
	'FR46178' => 'Loupiac',
	'FR46179' => 'Lugagnac',
	'FR46180' => 'Lunan',
	'FR46181' => 'Lunegarde',
	'FR46182' => 'Luzech',
	'FR46183' => 'Marcilhac-sur-Célé',
	'FR46184' => 'Marminiac',
	'FR46185' => 'Martel',
	'FR46186' => 'Masclat',
	'FR46187' => 'Mauroux',
	'FR46188' => 'Maxou',
	'FR46189' => 'Mayrinhac-Lentour',
	'FR46190' => 'Mechmont',
	'FR46191' => 'Mercuès',
	'FR46192' => 'Meyronne',
	'FR46193' => 'Miers',
	'FR46194' => 'Milhac',
	'FR46195' => 'Molières',
	'FR46196' => 'Montamel',
	'FR46197' => 'Le Montat',
	'FR46198' => 'Montbrun',
	'FR46199' => 'Montcabrier',
	'FR46200' => 'Montcléra',
	'FR46201' => 'Montcuq-en-Quercy-Blanc',
	'FR46202' => 'Montdoumerc',
	'FR46203' => 'Montet-et-Bouxal',
	'FR46204' => 'Montfaucon',
	'FR46205' => 'Montgesty',
	'FR46206' => 'Montlauzun',
	'FR46207' => 'Montredon',
	'FR46208' => 'Montvalent',
	'FR46209' => 'Nadaillac-de-Rouge',
	'FR46210' => 'Nadillac',
	'FR46211' => 'Nuzéjouls',
	'FR46212' => 'Orniac',
	'FR46213' => 'Padirac',
	'FR46214' => 'Parnac',
	'FR46215' => 'Payrac',
	'FR46216' => 'Payrignac',
	'FR46217' => 'Pern',
	'FR46218' => 'Pescadoires',
	'FR46219' => 'Peyrilles',
	'FR46220' => 'Pinsac',
	'FR46221' => 'Planioles',
	'FR46222' => 'Pomarède',
	'FR46223' => 'Pontcirq',
	'FR46224' => 'Pradines',
	'FR46225' => 'Prayssac',
	'FR46226' => 'Prendeignes',
	'FR46227' => 'Promilhanes',
	'FR46228' => 'Prudhomat',
	'FR46229' => 'Puybrun',
	'FR46230' => 'Puyjourdes',
	'FR46231' => 'Puy-lÉvêque',
	'FR46232' => 'Le Vignon-en-Quercy',
	'FR46233' => 'Quissac',
	'FR46234' => 'Rampoux',
	'FR46235' => 'Reilhac',
	'FR46236' => 'Reilhaguet',
	'FR46237' => 'Reyrevignes',
	'FR46238' => 'Rignac',
	'FR46239' => 'Le Roc',
	'FR46240' => 'Rocamadour',
	'FR46241' => 'Rouffilhac',
	'FR46242' => 'Rudelle',
	'FR46243' => 'Rueyres',
	'FR46244' => 'Sabadel-Latronquière',
	'FR46245' => 'Sabadel-Lauzès',
	'FR46246' => 'Saignes',
	'FR46247' => 'Saillac',
	'FR46249' => 'Saint-Bressou',
	'FR46250' => 'Saint-Caprais',
	'FR46251' => 'Saint-Céré',
	'FR46252' => 'Les Pechs du Vers',
	'FR46253' => 'Saint-Chamarand',
	'FR46254' => 'Saint-Chels',
	'FR46255' => 'Saint-Cirgues',
	'FR46256' => 'Saint-Cirq-Lapopie',
	'FR46257' => 'Saint-Cirq-Madelon',
	'FR46258' => 'Saint-Cirq-Souillaguet',
	'FR46259' => 'Saint-Clair',
	'FR46260' => 'Sainte-Colombe',
	'FR46262' => 'Lendou-en-Quercy',
	'FR46263' => 'Barguelonne-en-Quercy',
	'FR46264' => 'Saint-Denis-Catus',
	'FR46265' => 'Saint-Denis-lès-Martel',
	'FR46266' => 'Saint-Félix',
	'FR46267' => 'Saint-Germain-du-Bel-Air',
	'FR46268' => 'Saint Géry-Vers',
	'FR46269' => 'Saint-Hilaire',
	'FR46270' => 'Saint-Jean-de-Laur',
	'FR46271' => 'Saint-Jean-Lespinasse',
	'FR46272' => 'Saint-Jean-Mirabel',
	'FR46273' => 'Saint-Laurent-les-Tours',
	'FR46276' => 'Saint-Martin-Labouval',
	'FR46277' => 'Saint-Martin-le-Redon',
	'FR46279' => 'Saint-Maurice-en-Quercy',
	'FR46280' => 'Saint-Médard',
	'FR46281' => 'Saint-Médard-de-Presque',
	'FR46282' => 'Saint-Médard-Nicourby',
	'FR46283' => 'Saint-Michel-de-Bannières',
	'FR46284' => 'Saint-Michel-Loubéjou',
	'FR46286' => 'Saint-Paul-de-Vern',
	'FR46288' => 'Saint-Perdoux',
	'FR46289' => 'Saint-Pierre-Toirac',
	'FR46290' => 'Saint-Projet',
	'FR46292' => 'Saint-Simon',
	'FR46293' => 'Saint-Sozy',
	'FR46294' => 'Saint-Sulpice',
	'FR46295' => 'Saint-Vincent-du-Pendit',
	'FR46296' => 'Saint-Vincent-Rive-dOlt',
	'FR46297' => 'Salviac',
	'FR46299' => 'Sauliac-sur-Célé',
	'FR46301' => 'Sauzet',
	'FR46302' => 'Sénaillac-Latronquière',
	'FR46303' => 'Sénaillac-Lauzès',
	'FR46304' => 'Séniergues',
	'FR46305' => 'Sérignac',
	'FR46306' => 'Sonac',
	'FR46307' => 'Soturac',
	'FR46308' => 'Soucirac',
	'FR46309' => 'Souillac',
	'FR46310' => 'Soulomès',
	'FR46311' => 'Sousceyrac-en-Quercy',
	'FR46312' => 'Strenquels',
	'FR46313' => 'Tauriac',
	'FR46314' => 'Terrou',
	'FR46315' => 'Teyssieu',
	'FR46316' => 'Thédirac',
	'FR46317' => 'Thégra',
	'FR46318' => 'Thémines',
	'FR46319' => 'Théminettes',
	'FR46320' => 'Tour-de-Faure',
	'FR46321' => 'Touzac',
	'FR46322' => 'Trespoux-Rassiels',
	'FR46323' => 'Ussel',
	'FR46324' => 'Uzech',
	'FR46328' => 'Varaire',
	'FR46329' => 'Vaylats',
	'FR46330' => 'Vayrac',
	'FR46332' => 'Viazac',
	'FR46333' => 'Vidaillac',
	'FR46334' => 'Le Vigan',
	'FR46335' => 'Villesèque',
	'FR46336' => 'Vire-sur-Lot',
	'FR46337' => 'Mayrac',
	'FR46338' => 'Bessonies',
	'FR46339' => 'Saint-Jean-Lagineste',
	'FR46340' => 'Saint-Pierre-Lafeuille',
	'FR47001' => 'Agen',
	'FR47002' => 'Agmé',
	'FR47003' => 'Agnac',
	'FR47004' => 'Aiguillon',
	'FR47005' => 'Allemans-du-Dropt',
	'FR47006' => 'Allez-et-Cazeneuve',
	'FR47007' => 'Allons',
	'FR47008' => 'Ambrus',
	'FR47009' => 'Andiran',
	'FR47010' => 'Antagnac',
	'FR47011' => 'Anthé',
	'FR47012' => 'Anzex',
	'FR47013' => 'Argenton',
	'FR47014' => 'Armillac',
	'FR47015' => 'Astaffort',
	'FR47016' => 'Aubiac',
	'FR47017' => 'Auradou',
	'FR47018' => 'Auriac-sur-Dropt',
	'FR47019' => 'Bajamont',
	'FR47020' => 'Baleyssagues',
	'FR47021' => 'Barbaste',
	'FR47022' => 'Bazens',
	'FR47023' => 'Beaugas',
	'FR47024' => 'Beaupuy',
	'FR47025' => 'Beauville',
	'FR47026' => 'Beauziac',
	'FR47027' => 'Bias',
	'FR47028' => 'Birac-sur-Trec',
	'FR47029' => 'Blanquefort-sur-Briolance',
	'FR47030' => 'Blaymont',
	'FR47031' => 'Boé',
	'FR47032' => 'Bon-Encontre',
	'FR47033' => 'Boudy-de-Beauregard',
	'FR47034' => 'Bouglon',
	'FR47035' => 'Bourgougnague',
	'FR47036' => 'Bourlens',
	'FR47037' => 'Bournel',
	'FR47038' => 'Bourran',
	'FR47039' => 'Boussès',
	'FR47040' => 'Brax',
	'FR47041' => 'Bruch',
	'FR47042' => 'Brugnac',
	'FR47043' => 'Buzet-sur-Baïse',
	'FR47044' => 'Cahuzac',
	'FR47045' => 'Calignac',
	'FR47046' => 'Calonges',
	'FR47047' => 'Cambes',
	'FR47048' => 'Cancon',
	'FR47049' => 'Casseneuil',
	'FR47050' => 'Cassignas',
	'FR47051' => 'Castelculier',
	'FR47052' => 'Casteljaloux',
	'FR47053' => 'Castella',
	'FR47054' => 'Castelmoron-sur-Lot',
	'FR47055' => 'Castelnaud-de-Gratecambe',
	'FR47056' => 'Castelnau-sur-Gupie',
	'FR47057' => 'Castillonnès',
	'FR47058' => 'Caubeyres',
	'FR47059' => 'Caubon-Saint-Sauveur',
	'FR47060' => 'Caudecoste',
	'FR47061' => 'Caumont-sur-Garonne',
	'FR47062' => 'Cauzac',
	'FR47063' => 'Cavarc',
	'FR47064' => 'Cazideroque',
	'FR47065' => 'Clairac',
	'FR47066' => 'Clermont-Dessous',
	'FR47067' => 'Clermont-Soubiran',
	'FR47068' => 'Cocumont',
	'FR47069' => 'Colayrac-Saint-Cirq',
	'FR47070' => 'Condezaygues',
	'FR47071' => 'Coulx',
	'FR47072' => 'Courbiac',
	'FR47073' => 'Cours',
	'FR47074' => 'Couthures-sur-Garonne',
	'FR47075' => 'La Croix-Blanche',
	'FR47076' => 'Cuq',
	'FR47077' => 'Cuzorn',
	'FR47078' => 'Damazan',
	'FR47079' => 'Dausse',
	'FR47080' => 'Dévillac',
	'FR47081' => 'Dolmayrac',
	'FR47082' => 'Dondas',
	'FR47083' => 'Doudrac',
	'FR47084' => 'Douzains',
	'FR47085' => 'Durance',
	'FR47086' => 'Duras',
	'FR47087' => 'Engayrac',
	'FR47088' => 'Escassefort',
	'FR47089' => 'Esclottes',
	'FR47090' => 'Espiens',
	'FR47091' => 'Estillac',
	'FR47092' => 'Fals',
	'FR47093' => 'Fargues-sur-Ourbise',
	'FR47094' => 'Fauguerolles',
	'FR47095' => 'Fauillet',
	'FR47096' => 'Ferrensac',
	'FR47097' => 'Feugarolles',
	'FR47098' => 'Fieux',
	'FR47099' => 'Fongrave',
	'FR47100' => 'Foulayronnes',
	'FR47101' => 'Fourques-sur-Garonne',
	'FR47102' => 'Francescas',
	'FR47103' => 'Fréchou',
	'FR47104' => 'Frégimont',
	'FR47105' => 'Frespech',
	'FR47106' => 'Fumel',
	'FR47107' => 'Galapian',
	'FR47108' => 'Gaujac',
	'FR47109' => 'Gavaudun',
	'FR47110' => 'Gontaud-de-Nogaret',
	'FR47111' => 'Granges-sur-Lot',
	'FR47112' => 'Grateloup-Saint-Gayrand',
	'FR47113' => 'Grayssas',
	'FR47114' => 'Grézet-Cavagnan',
	'FR47115' => 'Guérin',
	'FR47117' => 'Hautefage-la-Tour',
	'FR47118' => 'Hautesvignes',
	'FR47119' => 'Houeillès',
	'FR47120' => 'Jusix',
	'FR47121' => 'Labastide-Castel-Amouroux',
	'FR47122' => 'Labretonie',
	'FR47123' => 'Lacapelle-Biron',
	'FR47124' => 'Lacaussade',
	'FR47125' => 'Lacépède',
	'FR47126' => 'Lachapelle',
	'FR47127' => 'Lafitte-sur-Lot',
	'FR47128' => 'Lafox',
	'FR47129' => 'Lagarrigue',
	'FR47130' => 'Lagruère',
	'FR47131' => 'Lagupie',
	'FR47132' => 'Lalandusse',
	'FR47133' => 'Lamontjoie',
	'FR47134' => 'Lannes',
	'FR47135' => 'Laparade',
	'FR47136' => 'Laperche',
	'FR47137' => 'Laplume',
	'FR47138' => 'Laroque-Timbaut',
	'FR47139' => 'Lasserre',
	'FR47140' => 'Laugnac',
	'FR47141' => 'Laussou',
	'FR47142' => 'Lauzun',
	'FR47143' => 'Lavardac',
	'FR47144' => 'Lavergne',
	'FR47145' => 'Layrac',
	'FR47146' => 'Lédat',
	'FR47147' => 'Lévignac-de-Guyenne',
	'FR47148' => 'Leyritz-Moncassin',
	'FR47150' => 'Longueville',
	'FR47151' => 'Loubès-Bernac',
	'FR47152' => 'Lougratte',
	'FR47154' => 'Lusignan-Petit',
	'FR47155' => 'Madaillan',
	'FR47156' => 'Marcellus',
	'FR47157' => 'Marmande',
	'FR47158' => 'Marmont-Pachas',
	'FR47159' => 'Le Mas-dAgenais',
	'FR47160' => 'Masquières',
	'FR47161' => 'Massels',
	'FR47162' => 'Massoulès',
	'FR47163' => 'Mauvezin-sur-Gupie',
	'FR47164' => 'Mazières-Naresse',
	'FR47165' => 'Meilhan-sur-Garonne',
	'FR47167' => 'Mézin',
	'FR47168' => 'Miramont-de-Guyenne',
	'FR47169' => 'Moirax',
	'FR47170' => 'Monbahus',
	'FR47171' => 'Monbalen',
	'FR47172' => 'Moncaut',
	'FR47173' => 'Monclar',
	'FR47174' => 'Moncrabeau',
	'FR47175' => 'Monflanquin',
	'FR47176' => 'Mongaillard',
	'FR47177' => 'Monheurt',
	'FR47178' => 'Monségur',
	'FR47179' => 'Monsempron-Libos',
	'FR47180' => 'Montagnac-sur-Auvignon',
	'FR47181' => 'Montagnac-sur-Lède',
	'FR47182' => 'Montastruc',
	'FR47183' => 'Montauriol',
	'FR47184' => 'Montaut',
	'FR47185' => 'Montayral',
	'FR47186' => 'Montesquieu',
	'FR47187' => 'Monteton',
	'FR47188' => 'Montignac-de-Lauzun',
	'FR47189' => 'Montignac-Toupinerie',
	'FR47190' => 'Montpezat',
	'FR47191' => 'Montpouillan',
	'FR47192' => 'Monviel',
	'FR47193' => 'Moulinet',
	'FR47194' => 'Moustier',
	'FR47195' => 'Nérac',
	'FR47196' => 'Nicole',
	'FR47197' => 'Nomdieu',
	'FR47198' => 'Pailloles',
	'FR47199' => 'Pardaillan',
	'FR47200' => 'Parranquet',
	'FR47201' => 'Le Passage',
	'FR47202' => 'Paulhiac',
	'FR47203' => 'Penne-dAgenais',
	'FR47204' => 'Peyrière',
	'FR47205' => 'Pindères',
	'FR47206' => 'Pinel-Hauterive',
	'FR47207' => 'Pompiey',
	'FR47208' => 'Pompogne',
	'FR47209' => 'Pont-du-Casse',
	'FR47210' => 'Port-Sainte-Marie',
	'FR47211' => 'Poudenas',
	'FR47212' => 'Poussignac',
	'FR47213' => 'Prayssas',
	'FR47214' => 'Puch-dAgenais',
	'FR47215' => 'Pujols',
	'FR47216' => 'Puymiclan',
	'FR47217' => 'Puymirol',
	'FR47218' => 'Puysserampion',
	'FR47219' => 'Rayet',
	'FR47220' => 'Razimet',
	'FR47221' => 'Réaup-Lisse',
	'FR47222' => 'La Réunion',
	'FR47223' => 'Rives',
	'FR47224' => 'Romestaing',
	'FR47225' => 'Roquefort',
	'FR47226' => 'Roumagne',
	'FR47227' => 'Ruffiac',
	'FR47228' => 'Saint-Antoine-de-Ficalba',
	'FR47229' => 'Saint-Astier',
	'FR47230' => 'Saint-Aubin',
	'FR47231' => 'Saint-Avit',
	'FR47232' => 'Saint-Barthélemy-dAgenais',
	'FR47233' => 'Sainte-Bazeille',
	'FR47234' => 'Saint-Caprais-de-Lerm',
	'FR47235' => 'Saint-Colomb-de-Lauzun',
	'FR47236' => 'Sainte-Colombe-de-Duras',
	'FR47237' => 'Sainte-Colombe-de-Villeneuve',
	'FR47238' => 'Sainte-Colombe-en-Bruilhois',
	'FR47239' => 'Saint-Étienne-de-Fougères',
	'FR47240' => 'Saint-Étienne-de-Villeréal',
	'FR47241' => 'Saint-Eutrope-de-Born',
	'FR47242' => 'Saint-Front-sur-Lémance',
	'FR47244' => 'Sainte-Gemme-Martaillac',
	'FR47245' => 'Saint-Géraud',
	'FR47246' => 'Saint-Hilaire-de-Lusignan',
	'FR47247' => 'Saint-Jean-de-Duras',
	'FR47248' => 'Saint-Jean-de-Thurac',
	'FR47249' => 'Saint-Laurent',
	'FR47250' => 'Saint-Léger',
	'FR47251' => 'Saint-Léon',
	'FR47252' => 'Sainte-Livrade-sur-Lot',
	'FR47253' => 'Sainte-Marthe',
	'FR47254' => 'Saint-Martin-Curton',
	'FR47255' => 'Saint-Martin-de-Beauville',
	'FR47256' => 'Saint-Martin-de-Villeréal',
	'FR47257' => 'Saint-Martin-Petit',
	'FR47258' => 'Sainte-Maure-de-Peyriac',
	'FR47259' => 'Saint-Maurice-de-Lestapel',
	'FR47260' => 'Saint-Maurin',
	'FR47262' => 'Saint-Nicolas-de-la-Balerme',
	'FR47263' => 'Saint-Pardoux-du-Breuil',
	'FR47264' => 'Saint-Pardoux-Isaac',
	'FR47265' => 'Saint-Pastour',
	'FR47266' => 'Saint-Pé-Saint-Simon',
	'FR47267' => 'Saint-Pierre-de-Buzet',
	'FR47269' => 'Saint-Pierre-de-Clairac',
	'FR47271' => 'Saint-Pierre-sur-Dropt',
	'FR47272' => 'Saint-Quentin-du-Dropt',
	'FR47273' => 'Saint-Robert',
	'FR47274' => 'Saint-Romain-le-Noble',
	'FR47275' => 'Saint-Salvy',
	'FR47276' => 'Saint-Sardos',
	'FR47277' => 'Saint-Sauveur-de-Meilhan',
	'FR47278' => 'Saint-Sernin',
	'FR47279' => 'Saint-Sixte',
	'FR47280' => 'Saint-Sylvestre-sur-Lot',
	'FR47281' => 'Saint-Urcisse',
	'FR47282' => 'Saint-Vincent-de-Lamontjoie',
	'FR47283' => 'Saint-Vite',
	'FR47284' => 'Salles',
	'FR47285' => 'Samazan',
	'FR47286' => 'Sauméjan',
	'FR47287' => 'Saumont',
	'FR47288' => 'Sauvagnas',
	'FR47289' => 'La Sauvetat-de-Savères',
	'FR47290' => 'La Sauvetat-du-Dropt',
	'FR47291' => 'La Sauvetat-sur-Lède',
	'FR47292' => 'Sauveterre-la-Lémance',
	'FR47293' => 'Sauveterre-Saint-Denis',
	'FR47294' => 'Savignac-de-Duras',
	'FR47295' => 'Savignac-sur-Leyze',
	'FR47296' => 'Ségalas',
	'FR47297' => 'Sembas',
	'FR47298' => 'Sénestis',
	'FR47299' => 'Sérignac-Péboudou',
	'FR47300' => 'Sérignac-sur-Garonne',
	'FR47301' => 'Seyches',
	'FR47302' => 'Sos',
	'FR47303' => 'Soumensac',
	'FR47304' => 'Taillebourg',
	'FR47305' => 'Tayrac',
	'FR47306' => 'Le Temple-sur-Lot',
	'FR47307' => 'Thézac',
	'FR47308' => 'Thouars-sur-Garonne',
	'FR47309' => 'Tombebœuf',
	'FR47310' => 'Tonneins',
	'FR47311' => 'Tourliac',
	'FR47312' => 'Tournon-dAgenais',
	'FR47313' => 'Tourtrès',
	'FR47314' => 'Trémons',
	'FR47315' => 'Trentels',
	'FR47316' => 'Varès',
	'FR47317' => 'Verteuil-dAgenais',
	'FR47318' => 'Vianne',
	'FR47319' => 'Villebramar',
	'FR47320' => 'Villefranche-du-Queyran',
	'FR47321' => 'Villeneuve-de-Duras',
	'FR47323' => 'Villeneuve-sur-Lot',
	'FR47324' => 'Villeréal',
	'FR47325' => 'Villeton',
	'FR47326' => 'Virazeil',
	'FR47327' => 'Xaintrailles',
	'FR47328' => 'Saint-Georges',
	'FR48001' => 'Albaret-le-Comtal',
	'FR48002' => 'Albaret-Sainte-Marie',
	'FR48003' => 'Allenc',
	'FR48004' => 'Altier',
	'FR48005' => 'Antrenas',
	'FR48007' => 'Arzenc-dApcher',
	'FR48008' => 'Arzenc-de-Randon',
	'FR48009' => 'Peyre en Aubrac',
	'FR48010' => 'Auroux',
	'FR48012' => 'Les Monts-Verts',
	'FR48013' => 'Badaroux',
	'FR48015' => 'Pied-de-Borne',
	'FR48016' => 'Balsièges',
	'FR48017' => 'Banassac-Canilhac',
	'FR48018' => 'Barjac',
	'FR48019' => 'Barre-des-Cévennes',
	'FR48020' => 'Bassurels',
	'FR48021' => 'La Bastide-Puylaurent',
	'FR48025' => 'Les Bessons',
	'FR48026' => 'Blavignac',
	'FR48027' => 'Mont Lozère et Goulet',
	'FR48028' => 'Les Bondons',
	'FR48029' => 'Le Born',
	'FR48030' => 'Brenoux',
	'FR48031' => 'Brion',
	'FR48032' => 'Le Buisson',
	'FR48034' => 'La Canourgue',
	'FR48036' => 'Cassagnas',
	'FR48037' => 'Chadenet',
	'FR48038' => 'Bel-Air-Val-dAnce',
	'FR48039' => 'Chanac',
	'FR48041' => 'Chastanier',
	'FR48042' => 'Chastel-Nouvel',
	'FR48043' => 'Châteauneuf-de-Randon',
	'FR48044' => 'Chauchailles',
	'FR48045' => 'Chaudeyrac',
	'FR48046' => 'Chaulhac',
	'FR48048' => 'Cheylard-lÉvêque',
	'FR48050' => 'Bédouès-Cocurès',
	'FR48051' => 'Le Collet-de-Dèze',
	'FR48053' => 'Cubières',
	'FR48054' => 'Cubiérettes',
	'FR48055' => 'Cultures',
	'FR48056' => 'Esclanèdes',
	'FR48058' => 'La Fage-Montivernoux',
	'FR48059' => 'La Fage-Saint-Julien',
	'FR48061' => 'Florac Trois Rivières',
	'FR48063' => 'Fontans',
	'FR48064' => 'Fournels',
	'FR48065' => 'Fraissinet-de-Fourques',
	'FR48067' => 'Gabriac',
	'FR48068' => 'Gabrias',
	'FR48069' => 'Gatuzières',
	'FR48070' => 'Grandrieu',
	'FR48071' => 'Grandvals',
	'FR48072' => 'Grèzes',
	'FR48073' => 'Les Hermaux',
	'FR48074' => 'Hures-la-Parade',
	'FR48075' => 'Ispagnac',
	'FR48077' => 'Julianges',
	'FR48079' => 'Lajo',
	'FR48080' => 'Langogne',
	'FR48081' => 'Lanuéjols',
	'FR48082' => 'Laubert',
	'FR48083' => 'Les Laubies',
	'FR48085' => 'Laval-du-Tarn',
	'FR48086' => 'Luc',
	'FR48087' => 'Prinsuéjols-Malbouzon',
	'FR48088' => 'La Malène',
	'FR48089' => 'Le Malzieu-Forain',
	'FR48090' => 'Le Malzieu-Ville',
	'FR48091' => 'Marchastel',
	'FR48092' => 'Marvejols',
	'FR48094' => 'Massegros Causses Gorges',
	'FR48095' => 'Mende',
	'FR48096' => 'Meyrueis',
	'FR48097' => 'Moissac-Vallée-Française',
	'FR48098' => 'Molezon',
	'FR48099' => 'Bourgs sur Colagne',
	'FR48100' => 'Montbel',
	'FR48103' => 'Montrodat',
	'FR48104' => 'Nasbinals',
	'FR48105' => 'Naussac-Fontanes',
	'FR48106' => 'Noalhac',
	'FR48107' => 'Palhers',
	'FR48108' => 'La Panouse',
	'FR48110' => 'Paulhac-en-Margeride',
	'FR48111' => 'Pelouse',
	'FR48112' => 'Pierrefiche',
	'FR48115' => 'Le Pompidou',
	'FR48116' => 'Pont de Montvert - Sud Mont Lozère',
	'FR48117' => 'Pourcharesses',
	'FR48119' => 'Prévenchères',
	'FR48121' => 'Prunières',
	'FR48123' => 'Recoules-dAubrac',
	'FR48124' => 'Recoules-de-Fumas',
	'FR48126' => 'Lachamp-Ribennes',
	'FR48127' => 'Monts-de-Randon',
	'FR48128' => 'Rimeize',
	'FR48129' => 'Rocles',
	'FR48130' => 'Rousses',
	'FR48131' => 'Le Rozier',
	'FR48132' => 'Saint-Alban-sur-Limagnole',
	'FR48135' => 'Saint-André-Capcèze',
	'FR48136' => 'Saint-André-de-Lancize',
	'FR48137' => 'Saint-Bauzile',
	'FR48138' => 'Saint-Bonnet-de-Chirac',
	'FR48139' => 'Saint Bonnet-Laval',
	'FR48140' => 'Saint-Chély-dApcher',
	'FR48141' => 'Mas-Saint-Chély',
	'FR48144' => 'Sainte-Croix-Vallée-Française',
	'FR48145' => 'Saint-Denis-en-Margeride',
	'FR48146' => 'Gorges du Tarn Causses',
	'FR48147' => 'Saint-Étienne-du-Valdonnez',
	'FR48148' => 'Saint-Étienne-Vallée-Française',
	'FR48149' => 'Sainte-Eulalie',
	'FR48150' => 'Saint-Flour-de-Mercoire',
	'FR48151' => 'Saint-Frézal-dAlbuges',
	'FR48152' => 'Ventalon en Cévennes',
	'FR48153' => 'Saint-Gal',
	'FR48155' => 'Saint-Germain-de-Calberte',
	'FR48156' => 'Saint-Germain-du-Teil',
	'FR48157' => 'Sainte-Hélène',
	'FR48158' => 'Saint-Hilaire-de-Lavit',
	'FR48160' => 'Saint-Jean-la-Fouillouse',
	'FR48161' => 'Saint-Juéry',
	'FR48163' => 'Saint-Julien-des-Points',
	'FR48165' => 'Saint-Laurent-de-Muret',
	'FR48166' => 'Cans et Cévennes',
	'FR48167' => 'Saint-Laurent-de-Veyrès',
	'FR48168' => 'Saint-Léger-de-Peyre',
	'FR48169' => 'Saint-Léger-du-Malzieu',
	'FR48170' => 'Saint-Martin-de-Boubaux',
	'FR48171' => 'Saint-Martin-de-Lansuscle',
	'FR48173' => 'Saint-Michel-de-Dèze',
	'FR48174' => 'Saint-Paul-le-Froid',
	'FR48175' => 'Saint-Pierre-de-Nogaret',
	'FR48176' => 'Saint-Pierre-des-Tripiers',
	'FR48177' => 'Saint-Pierre-le-Vieux',
	'FR48178' => 'Saint-Privat-de-Vallongue',
	'FR48179' => 'Saint-Privat-du-Fau',
	'FR48181' => 'Saint-Saturnin',
	'FR48182' => 'Saint-Sauveur-de-Ginestoux',
	'FR48185' => 'Les Salelles',
	'FR48187' => 'Les Salces',
	'FR48188' => 'Serverette',
	'FR48190' => 'Termes',
	'FR48191' => 'La Tieule',
	'FR48192' => 'Trélans',
	'FR48193' => 'Vebron',
	'FR48194' => 'Vialas',
	'FR48198' => 'Villefort',
	'FR49002' => 'Allonnes',
	'FR49003' => 'Tuffalun',
	'FR49007' => 'Angers',
	'FR49008' => 'Angrie',
	'FR49009' => 'Antoigné',
	'FR49010' => 'Armaillé',
	'FR49011' => 'Artannes-sur-Thouet',
	'FR49012' => 'Aubigné-sur-Layon',
	'FR49015' => 'Avrillé',
	'FR49017' => 'Baracé',
	'FR49018' => 'Baugé-en-Anjou',
	'FR49020' => 'Beaucouzé',
	'FR49021' => 'Beaufort-en-Anjou',
	'FR49022' => 'Beaulieu-sur-Layon',
	'FR49023' => 'Beaupréau-en-Mauges',
	'FR49026' => 'Bécon-les-Granits',
	'FR49027' => 'Bégrolles-en-Mauges',
	'FR49028' => 'Béhuard',
	'FR49029' => 'Blaison-Saint-Sulpice',
	'FR49030' => 'Blou',
	'FR49035' => 'Bouchemaine',
	'FR49036' => 'Bouillé-Ménard',
	'FR49038' => 'Bourg-lÉvêque',
	'FR49041' => 'Brain-sur-Allonnes',
	'FR49045' => 'La Breille-les-Pins',
	'FR49048' => 'Briollay',
	'FR49050' => 'Brissac Loire Aubance',
	'FR49053' => 'Brossay',
	'FR49054' => 'Candé',
	'FR49055' => 'Cantenay-Épinard',
	'FR49056' => 'Carbay',
	'FR49057' => 'Cernusson',
	'FR49058' => 'Les Cerqueux',
	'FR49060' => 'Bellevigne-les-Châteaux',
	'FR49061' => 'Challain-la-Potherie',
	'FR49063' => 'Chalonnes-sur-Loire',
	'FR49064' => 'Chambellay',
	'FR49067' => 'Chenillé-Champteussé',
	'FR49068' => 'Champtocé-sur-Loire',
	'FR49069' => 'Orée dAnjou',
	'FR49070' => 'Chanteloup-les-Bois',
	'FR49076' => 'La Chapelle-Saint-Laud',
	'FR49080' => 'Les Hauts-dAnjou',
	'FR49082' => 'Chaudefonds-sur-Layon',
	'FR49086' => 'Terranjou',
	'FR49089' => 'Chazé-sur-Argos',
	'FR49090' => 'Cheffes',
	'FR49092' => 'Chemillé-en-Anjou',
	'FR49099' => 'Cholet',
	'FR49100' => 'Cizay-la-Madeleine',
	'FR49102' => 'Cléré-sur-Layon',
	'FR49107' => 'Cornillé-les-Caves',
	'FR49109' => 'Coron',
	'FR49110' => 'Corzé',
	'FR49112' => 'Le Coudray-Macouard',
	'FR49113' => 'Courchamps',
	'FR49114' => 'Courléon',
	'FR49120' => 'Denée',
	'FR49121' => 'Dénezé-sous-Doué',
	'FR49123' => 'Distré',
	'FR49125' => 'Doué-en-Anjou',
	'FR49127' => 'Durtal',
	'FR49129' => 'Écouflant',
	'FR49130' => 'Écuillé',
	'FR49131' => 'Épieds',
	'FR49132' => 'Étriché',
	'FR49135' => 'Feneu',
	'FR49138' => 'Les Bois dAnjou',
	'FR49140' => 'Fontevraud-lAbbaye',
	'FR49155' => 'Grez-Neuville',
	'FR49160' => 'Ingrandes-Le Fresne sur Loire',
	'FR49161' => 'La Jaille-Yvon',
	'FR49163' => 'Jarzé Villages',
	'FR49167' => 'Les Garennes sur Loire',
	'FR49170' => 'Juvardeil',
	'FR49171' => 'La Lande-Chasles',
	'FR49174' => 'Huillé-Lézigné',
	'FR49176' => 'Le Lion-dAngers',
	'FR49178' => 'Loiré',
	'FR49180' => 'Longué-Jumelles',
	'FR49182' => 'Louresse-Rochemenier',
	'FR49183' => 'Val dErdre-Auxence',
	'FR49188' => 'Marcé',
	'FR49192' => 'Maulévrier',
	'FR49193' => 'Le May-sur-Èvre',
	'FR49194' => 'Mazé-Milon',
	'FR49195' => 'Mazières-en-Mauges',
	'FR49200' => 'Longuenée-en-Anjou',
	'FR49201' => 'La Ménitré',
	'FR49205' => 'Miré',
	'FR49209' => 'Montigné-lès-Rairies',
	'FR49211' => 'Montilliers',
	'FR49214' => 'Montreuil-Juigné',
	'FR49215' => 'Montreuil-Bellay',
	'FR49216' => 'Montreuil-sur-Loir',
	'FR49217' => 'Montreuil-sur-Maine',
	'FR49218' => 'Montrevault-sur-Èvre',
	'FR49219' => 'Montsoreau',
	'FR49220' => 'Morannes sur Sarthe-Daumeray',
	'FR49221' => 'Mouliherne',
	'FR49222' => 'Mozé-sur-Louet',
	'FR49223' => 'Mûrs-Erigné',
	'FR49224' => 'Neuillé',
	'FR49228' => 'Noyant-Villages',
	'FR49231' => 'Nuaillé',
	'FR49235' => 'Parnay',
	'FR49236' => 'Passavant-sur-Layon',
	'FR49237' => 'La Pellerine',
	'FR49240' => 'La Plaine',
	'FR49241' => 'Le Plessis-Grammoire',
	'FR49244' => 'Mauges-sur-Loire',
	'FR49246' => 'Les Ponts-de-Cé',
	'FR49247' => 'La Possonnière',
	'FR49248' => 'Ombrée dAnjou',
	'FR49253' => 'Le Puy-Notre-Dame',
	'FR49257' => 'Les Rairies',
	'FR49259' => 'Rochefort-sur-Loire',
	'FR49260' => 'La Romagne',
	'FR49261' => 'Gennes-Val-de-Loire',
	'FR49262' => 'Rou-Marson',
	'FR49266' => 'Saint-Augustin-des-Bois',
	'FR49267' => 'Saint-Barthélemy-dAnjou',
	'FR49269' => 'Saint-Christophe-du-Bois',
	'FR49271' => 'Saint-Clément-de-la-Place',
	'FR49272' => 'Saint-Clément-des-Levées',
	'FR49278' => 'Sainte-Gemmes-sur-Loire',
	'FR49283' => 'Saint-Georges-sur-Loire',
	'FR49284' => 'Saint-Germain-des-Prés',
	'FR49288' => 'Saint-Jean-de-la-Croix',
	'FR49291' => 'Saint-Just-sur-Dive',
	'FR49292' => 'Val-du-Layon',
	'FR49294' => 'Saint-Lambert-la-Potherie',
	'FR49298' => 'Saint-Léger-de-Linières',
	'FR49299' => 'Saint-Léger-sous-Cholet',
	'FR49301' => 'Sèvremoine',
	'FR49302' => 'Saint-Macaire-du-Bois',
	'FR49306' => 'Saint-Martin-du-Fouilloux',
	'FR49307' => 'Loire-Authion',
	'FR49308' => 'Saint-Melaine-sur-Aubance',
	'FR49310' => 'Saint-Paul-du-Bois',
	'FR49311' => 'Saint-Philbert-du-Peuple',
	'FR49321' => 'Saint-Sigismond',
	'FR49323' => 'Verrières-en-Anjou',
	'FR49326' => 'Sarrigné',
	'FR49328' => 'Saumur',
	'FR49329' => 'Savennières',
	'FR49330' => 'Sceaux-dAnjou',
	'FR49331' => 'Segré-en-Anjou Bleu',
	'FR49332' => 'La Séguinière',
	'FR49333' => 'Seiches-sur-le-Loir',
	'FR49334' => 'Sermaise',
	'FR49336' => 'Somloire',
	'FR49338' => 'Soulaines-sur-Aubance',
	'FR49339' => 'Soulaire-et-Bourg',
	'FR49341' => 'Souzay-Champigny',
	'FR49343' => 'La Tessoualle',
	'FR49344' => 'Thorigné-dAnjou',
	'FR49345' => 'Bellevigne-en-Layon',
	'FR49347' => 'Tiercé',
	'FR49352' => 'Toutlemonde',
	'FR49353' => 'Trélazé',
	'FR49355' => 'Trémentines',
	'FR49358' => 'Turquant',
	'FR49359' => 'Les Ulmes',
	'FR49361' => 'Varennes-sur-Loire',
	'FR49362' => 'Varrains',
	'FR49364' => 'Vaudelnay',
	'FR49367' => 'Erdre-en-Anjou',
	'FR49368' => 'Vernantes',
	'FR49369' => 'Vernoil-le-Fourrier',
	'FR49370' => 'Verrie',
	'FR49371' => 'Vezins',
	'FR49373' => 'Lys-Haut-Layon',
	'FR49374' => 'Villebernier',
	'FR49377' => 'Rives-du-Loir-en-Anjou',
	'FR49378' => 'Vivy',
	'FR49381' => 'Yzernay',
	'FR50002' => 'Agneaux',
	'FR50003' => 'Agon-Coutainville',
	'FR50004' => 'Airel',
	'FR50006' => 'Amigny',
	'FR50008' => 'Anctoville-sur-Boscq',
	'FR50013' => 'Anneville-en-Saire',
	'FR50015' => 'Annoville',
	'FR50016' => 'Appeville',
	'FR50019' => 'Aucey-la-Plaine',
	'FR50021' => 'Audouville-la-Hubert',
	'FR50022' => 'Aumeville-Lestre',
	'FR50023' => 'Auvers',
	'FR50024' => 'Auxais',
	'FR50025' => 'Avranches',
	'FR50026' => 'Azeville',
	'FR50027' => 'Bacilly',
	'FR50028' => 'La Baleine',
	'FR50029' => 'Barenton',
	'FR50030' => 'Barfleur',
	'FR50031' => 'Barneville-Carteret',
	'FR50032' => 'La Barre-de-Semilly',
	'FR50033' => 'Baubigny',
	'FR50034' => 'Baudre',
	'FR50036' => 'Baupte',
	'FR50038' => 'Beauchamps',
	'FR50039' => 'Beaucoudray',
	'FR50040' => 'Beauficel',
	'FR50041' => 'La Hague',
	'FR50042' => 'Beauvoir',
	'FR50044' => 'Belval',
	'FR50045' => 'Benoîtville',
	'FR50046' => 'Bérigny',
	'FR50048' => 'Beslon',
	'FR50049' => 'Besneville',
	'FR50050' => 'Beuvrigny',
	'FR50052' => 'Beuzeville-la-Bastille',
	'FR50054' => 'Biéville',
	'FR50055' => 'Biniville',
	'FR50058' => 'Blainville-sur-Mer',
	'FR50059' => 'Blosville',
	'FR50060' => 'La Bloutière',
	'FR50062' => 'Boisyvon',
	'FR50064' => 'La Bonneville',
	'FR50066' => 'Jullouville',
	'FR50069' => 'Bourguenolles',
	'FR50070' => 'Boutteville',
	'FR50072' => 'Brainville',
	'FR50074' => 'Brécey',
	'FR50076' => 'Bréhal',
	'FR50077' => 'Bretteville',
	'FR50078' => 'Bretteville-sur-Ay',
	'FR50079' => 'Breuville',
	'FR50081' => 'Bréville-sur-Mer',
	'FR50082' => 'Bricquebec-en-Cotentin',
	'FR50083' => 'Bricquebosq',
	'FR50084' => 'Bricqueville-la-Blouette',
	'FR50085' => 'Bricqueville-sur-Mer',
	'FR50086' => 'Brillevast',
	'FR50087' => 'Brix',
	'FR50088' => 'Brouains',
	'FR50090' => 'Buais-Les-Monts',
	'FR50092' => 'Cambernon',
	'FR50093' => 'Cametours',
	'FR50094' => 'Camprond',
	'FR50095' => 'Canisy',
	'FR50096' => 'Canteloup',
	'FR50097' => 'Canville-la-Rocque',
	'FR50098' => 'Carantilly',
	'FR50099' => 'Carentan-les-Marais',
	'FR50101' => 'Carneville',
	'FR50102' => 'Carolles',
	'FR50105' => 'Catteville',
	'FR50106' => 'Cavigny',
	'FR50108' => 'Céaux',
	'FR50109' => 'Cérences',
	'FR50110' => 'Cerisy-la-Forêt',
	'FR50111' => 'Cerisy-la-Salle',
	'FR50112' => 'La Chaise-Baudouin',
	'FR50115' => 'Le Grippon',
	'FR50117' => 'Champeaux',
	'FR50118' => 'Champrepus',
	'FR50120' => 'Chanteloup',
	'FR50121' => 'La Chapelle-Cécelin',
	'FR50124' => 'La Chapelle-Urée',
	'FR50126' => 'Chavoy',
	'FR50129' => 'Cherbourg-en-Cotentin',
	'FR50130' => 'Chérencé-le-Héron',
	'FR50135' => 'Clitourps',
	'FR50137' => 'La Colombe',
	'FR50138' => 'Colomby',
	'FR50139' => 'Condé-sur-Vire',
	'FR50142' => 'Vicq-sur-Mer',
	'FR50143' => 'Coudeville-sur-Mer',
	'FR50144' => 'Coulouvray-Boisbenâtre',
	'FR50145' => 'Courcy',
	'FR50146' => 'Courtils',
	'FR50147' => 'Coutances',
	'FR50148' => 'Couvains',
	'FR50149' => 'Couville',
	'FR50150' => 'Crasville',
	'FR50151' => 'Créances',
	'FR50152' => 'Les Cresnays',
	'FR50155' => 'Crollon',
	'FR50156' => 'Crosville-sur-Douve',
	'FR50158' => 'Cuves',
	'FR50159' => 'Dangy',
	'FR50161' => 'Le Dézert',
	'FR50162' => 'Digosville',
	'FR50164' => 'Domjean',
	'FR50165' => 'Donville-les-Bains',
	'FR50166' => 'Doville',
	'FR50167' => 'Dragey-Ronthon',
	'FR50168' => 'Ducey-Les Chéris',
	'FR50169' => 'Écausseville',
	'FR50172' => 'Émondeville',
	'FR50174' => 'Équilly',
	'FR50175' => 'Éroudeville',
	'FR50176' => 'LÉtang-Bertrand',
	'FR50177' => 'Étienville',
	'FR50178' => 'Fermanville',
	'FR50181' => 'Feugères',
	'FR50182' => 'La Feuillie',
	'FR50183' => 'Fierville-les-Mines',
	'FR50184' => 'Flamanville',
	'FR50185' => 'Fleury',
	'FR50186' => 'Flottemanville',
	'FR50188' => 'Folligny',
	'FR50190' => 'Fontenay-sur-Mer',
	'FR50192' => 'Fourneaux',
	'FR50193' => 'Le Fresne-Poret',
	'FR50194' => 'Fresville',
	'FR50195' => 'Gathemo',
	'FR50196' => 'Gatteville-le-Phare',
	'FR50197' => 'Gavray-sur-Sienne',
	'FR50198' => 'Geffosses',
	'FR50199' => 'Genêts',
	'FR50200' => 'Ger',
	'FR50205' => 'La Godefroy',
	'FR50207' => 'Golleville',
	'FR50208' => 'Gonfreville',
	'FR50209' => 'Gonneville-Le Theil',
	'FR50210' => 'Gorges',
	'FR50214' => 'Gouvets',
	'FR50215' => 'Gouville-sur-Mer',
	'FR50216' => 'Graignes-Mesnil-Angot',
	'FR50217' => 'Le Grand-Celland',
	'FR50218' => 'Granville',
	'FR50219' => 'Gratot',
	'FR50221' => 'Grimesnil',
	'FR50222' => 'Grosville',
	'FR50225' => 'Le Guislain',
	'FR50227' => 'Le Ham',
	'FR50228' => 'Hambye',
	'FR50229' => 'Hamelin',
	'FR50230' => 'Hardinvast',
	'FR50231' => 'Hauteville-sur-Mer',
	'FR50232' => 'Hauteville-la-Guichard',
	'FR50233' => 'Hautteville-Bocage',
	'FR50234' => 'La Haye-Bellefond',
	'FR50235' => 'La Haye-dEctot',
	'FR50236' => 'La Haye',
	'FR50237' => 'La Haye-Pesnel',
	'FR50238' => 'Héauville',
	'FR50239' => 'Thèreval',
	'FR50240' => 'Helleville',
	'FR50241' => 'Hémevez',
	'FR50243' => 'Heugueville-sur-Sienne',
	'FR50246' => 'Hiesville',
	'FR50247' => 'Hocquigny',
	'FR50251' => 'Huberville',
	'FR50252' => 'Hudimesnil',
	'FR50253' => 'Huisnes-sur-Mer',
	'FR50256' => 'Isigny-le-Buat',
	'FR50258' => 'Joganville',
	'FR50259' => 'Juilley',
	'FR50260' => 'Juvigny les Vallées',
	'FR50261' => 'Lamberville',
	'FR50262' => 'La Lande-dAirou',
	'FR50263' => 'Lapenty',
	'FR50265' => 'Laulne',
	'FR50266' => 'Lengronne',
	'FR50267' => 'Lessay',
	'FR50268' => 'Lestre',
	'FR50269' => 'Liesville-sur-Douve',
	'FR50270' => 'Lieusaint',
	'FR50271' => 'Lingeard',
	'FR50272' => 'Lingreville',
	'FR50273' => 'Montsenelle',
	'FR50274' => 'Les Loges-Marchis',
	'FR50275' => 'Les Loges-sur-Brécey',
	'FR50276' => 'Lolif',
	'FR50277' => 'Longueville',
	'FR50278' => 'Le Loreur',
	'FR50279' => 'Le Lorey',
	'FR50281' => 'La Lucerne-dOutremer',
	'FR50282' => 'Le Luot',
	'FR50283' => 'La Luzerne',
	'FR50285' => 'Magneville',
	'FR50288' => 'Marcey-les-Grèves',
	'FR50289' => 'Marchésieux',
	'FR50290' => 'Marcilly',
	'FR50291' => 'Margueray',
	'FR50292' => 'Marigny-Le-Lozon',
	'FR50294' => 'Martinvast',
	'FR50295' => 'Maupertuis',
	'FR50296' => 'Maupertus-sur-Mer',
	'FR50297' => 'La Meauffe',
	'FR50298' => 'Méautis',
	'FR50299' => 'Le Mesnil',
	'FR50300' => 'Le Mesnil-Adelée',
	'FR50302' => 'Le Mesnil-Amey',
	'FR50304' => 'Le Mesnil-Aubert',
	'FR50305' => 'Le Mesnil-au-Val',
	'FR50310' => 'Le Mesnil-Eury',
	'FR50311' => 'Le Mesnil-Garnier',
	'FR50312' => 'Le Mesnil-Gilbert',
	'FR50315' => 'Le Mesnillard',
	'FR50317' => 'Le Mesnil-Ozenne',
	'FR50321' => 'Le Mesnil-Rouxelin',
	'FR50324' => 'Le Mesnil-Véneron',
	'FR50326' => 'Le Mesnil-Villeman',
	'FR50327' => 'La Meurdraquière',
	'FR50328' => 'Millières',
	'FR50332' => 'Les Moitiers-dAllonne',
	'FR50334' => 'Montabot',
	'FR50335' => 'Montaigu-la-Brisette',
	'FR50336' => 'Montaigu-les-Bois',
	'FR50338' => 'Montbray',
	'FR50340' => 'Montcuit',
	'FR50341' => 'Montebourg',
	'FR50342' => 'Montfarville',
	'FR50345' => 'Monthuchon',
	'FR50347' => 'Montjoie-Saint-Martin',
	'FR50349' => 'Montmartin-sur-Mer',
	'FR50350' => 'Montpinchon',
	'FR50351' => 'Montrabot',
	'FR50352' => 'Montreuil-sur-Lozon',
	'FR50353' => 'Le Mont-Saint-Michel',
	'FR50356' => 'Moon-sur-Elle',
	'FR50357' => 'Morigny',
	'FR50359' => 'Mortain-Bocage',
	'FR50360' => 'Morville',
	'FR50361' => 'La Mouche',
	'FR50362' => 'Moulines',
	'FR50363' => 'Moyon Villages',
	'FR50364' => 'Muneville-le-Bingard',
	'FR50365' => 'Muneville-sur-Mer',
	'FR50368' => 'Nay',
	'FR50369' => 'Négreville',
	'FR50370' => 'Néhou',
	'FR50371' => 'Le Neufbourg',
	'FR50372' => 'Neufmesnil',
	'FR50373' => 'Neuville-au-Plain',
	'FR50374' => 'Neuville-en-Beaumont',
	'FR50376' => 'Nicorps',
	'FR50378' => 'Notre-Dame-de-Cenilly',
	'FR50379' => 'Notre-Dame-de-Livoye',
	'FR50382' => 'Nouainville',
	'FR50384' => 'Octeville-lAvenel',
	'FR50387' => 'Orglandes',
	'FR50388' => 'Orval sur Sienne',
	'FR50389' => 'Ouville',
	'FR50390' => 'Ozeville',
	'FR50391' => 'Grandparigny',
	'FR50393' => 'Percy-en-Normandie',
	'FR50394' => 'Périers',
	'FR50395' => 'La Pernelle',
	'FR50397' => 'Perriers-en-Beauficel',
	'FR50398' => 'Le Perron',
	'FR50399' => 'Le Petit-Celland',
	'FR50400' => 'Picauville',
	'FR50401' => 'Pierreville',
	'FR50402' => 'Les Pieux',
	'FR50403' => 'Pirou',
	'FR50405' => 'Le Plessis-Lastelle',
	'FR50407' => 'Poilley',
	'FR50408' => 'Pontaubault',
	'FR50409' => 'Pont-Hébert',
	'FR50410' => 'Pontorson',
	'FR50411' => 'Ponts',
	'FR50412' => 'Port-Bail-sur-Mer',
	'FR50413' => 'Précey',
	'FR50417' => 'Quettehou',
	'FR50419' => 'Quettreville-sur-Sienne',
	'FR50420' => 'Quibou',
	'FR50421' => 'Quinéville',
	'FR50422' => 'Raids',
	'FR50423' => 'Rampan',
	'FR50425' => 'Rauville-la-Bigot',
	'FR50426' => 'Rauville-la-Place',
	'FR50428' => 'Reffuveille',
	'FR50429' => 'Regnéville-sur-Mer',
	'FR50430' => 'Reigneville-Bocage',
	'FR50431' => 'Remilly Les Marais',
	'FR50433' => 'Réville',
	'FR50435' => 'Rocheville',
	'FR50436' => 'Romagny Fontenay',
	'FR50437' => 'Roncey',
	'FR50442' => 'Le Rozel',
	'FR50443' => 'Sacey',
	'FR50444' => 'Saint-Amand-Villages',
	'FR50445' => 'Saint-André-de-Bohon',
	'FR50446' => 'Saint-André-de-lÉpine',
	'FR50447' => 'Saint-Aubin-des-Préaux',
	'FR50448' => 'Saint-Aubin-de-Terregatte',
	'FR50450' => 'Saint-Barthélemy',
	'FR50451' => 'Saint-Brice',
	'FR50452' => 'Saint-Brice-de-Landelles',
	'FR50453' => 'Sainte-Cécile',
	'FR50454' => 'Saint-Christophe-du-Foc',
	'FR50455' => 'Saint-Clair-sur-lElle',
	'FR50456' => 'Saint-Clément-Rancoudray',
	'FR50457' => 'Sainte-Colombe',
	'FR50461' => 'Saint-Cyr',
	'FR50462' => 'Saint-Cyr-du-Bailleul',
	'FR50463' => 'Saint-Denis-le-Gast',
	'FR50464' => 'Saint-Denis-le-Vêtu',
	'FR50467' => 'Saint-Floxel',
	'FR50468' => 'Saint-Fromond',
	'FR50469' => 'Sainte-Geneviève',
	'FR50471' => 'Saint-Georges-de-la-Rivière',
	'FR50472' => 'Saint-Georges-de-Livoye',
	'FR50473' => 'Saint-Georges-dElle',
	'FR50474' => 'Saint-Georges-de-Rouelley',
	'FR50475' => 'Saint-Georges-Montcocq',
	'FR50476' => 'Saint-Germain-dElle',
	'FR50478' => 'Saint-Germain-de-Tournebut',
	'FR50479' => 'Saint-Germain-de-Varreville',
	'FR50480' => 'Saint-Germain-le-Gaillard',
	'FR50481' => 'Saint-Germain-sur-Ay',
	'FR50482' => 'Saint-Germain-sur-Sèves',
	'FR50483' => 'Saint-Gilles',
	'FR50484' => 'Saint-Hilaire-du-Harcouët',
	'FR50486' => 'Saint-Jacques-de-Néhou',
	'FR50487' => 'Saint-James',
	'FR50488' => 'Saint-Jean-de-Daye',
	'FR50489' => 'Saint-Jean-de-la-Haize',
	'FR50490' => 'Saint-Jean-de-la-Rivière',
	'FR50491' => 'Saint-Jean-de-Savigny',
	'FR50492' => 'Saint-Jean-dElle',
	'FR50493' => 'Saint-Jean-des-Champs',
	'FR50495' => 'Saint-Jean-du-Corail-des-Bois',
	'FR50496' => 'Saint-Jean-le-Thomas',
	'FR50498' => 'Saint-Joseph',
	'FR50499' => 'Saint-Laurent-de-Cuves',
	'FR50500' => 'Saint-Laurent-de-Terregatte',
	'FR50502' => 'Saint-Lô',
	'FR50504' => 'Saint-Louet-sur-Vire',
	'FR50505' => 'Saint-Loup',
	'FR50506' => 'Saint-Malo-de-la-Lande',
	'FR50507' => 'Saint-Marcouf',
	'FR50509' => 'Sainte-Marie-du-Mont',
	'FR50510' => 'Saint-Martin-dAubigny',
	'FR50511' => 'Saint-Martin-dAudouville',
	'FR50512' => 'Saint-Martin-de-Bonfossé',
	'FR50513' => 'Saint-Martin-de-Cenilly',
	'FR50514' => 'Chaulieu',
	'FR50517' => 'Saint-Martin-de-Varreville',
	'FR50518' => 'Saint-Martin-le-Bouillant',
	'FR50519' => 'Saint-Martin-le-Gréard',
	'FR50521' => 'Saint-Maur-des-Bois',
	'FR50522' => 'Saint-Maurice-en-Cotentin',
	'FR50523' => 'Sainte-Mère-Église',
	'FR50525' => 'Saint-Michel-de-Montjoie',
	'FR50528' => 'Saint-Nicolas-de-Pierrepont',
	'FR50529' => 'Saint-Nicolas-des-Bois',
	'FR50531' => 'Saint-Ovin',
	'FR50532' => 'Saint-Pair-sur-Mer',
	'FR50533' => 'Saint-Patrice-de-Claids',
	'FR50535' => 'Le Parc',
	'FR50536' => 'Saint-Pierre-dArthéglise',
	'FR50537' => 'Saint-Pierre-de-Coutances',
	'FR50538' => 'Saint-Pierre-de-Semilly',
	'FR50539' => 'Saint-Pierre-Église',
	'FR50540' => 'Saint-Pierre-Langers',
	'FR50541' => 'Saint-Planchers',
	'FR50542' => 'Saint-Pois',
	'FR50543' => 'Saint-Quentin-sur-le-Homme',
	'FR50546' => 'Bourgvallées',
	'FR50548' => 'Saint-Sauveur-de-Pierrepont',
	'FR50549' => 'Saint-Sauveur-la-Pommeraye',
	'FR50550' => 'Saint-Sauveur-Villages',
	'FR50551' => 'Saint-Sauveur-le-Vicomte',
	'FR50552' => 'Saint-Sébastien-de-Raids',
	'FR50553' => 'Saint-Senier-de-Beuvron',
	'FR50554' => 'Saint-Senier-sous-Avranches',
	'FR50556' => 'Sainte-Suzanne-sur-Vire',
	'FR50562' => 'Saint-Vaast-la-Hougue',
	'FR50563' => 'Saint-Vigor-des-Monts',
	'FR50564' => 'Terre-et-Marais',
	'FR50565' => 'Sartilly-Baie-Bocage',
	'FR50567' => 'Saussemesnil',
	'FR50568' => 'Saussey',
	'FR50569' => 'Savigny',
	'FR50570' => 'Savigny-le-Vieux',
	'FR50571' => 'Sébeville',
	'FR50572' => 'Sénoville',
	'FR50574' => 'Servon',
	'FR50575' => 'Sideville',
	'FR50576' => 'Siouville-Hague',
	'FR50577' => 'Sortosville-en-Beaumont',
	'FR50578' => 'Sortosville',
	'FR50579' => 'Sottevast',
	'FR50580' => 'Sotteville',
	'FR50582' => 'Sourdeval',
	'FR50584' => 'Subligny',
	'FR50585' => 'Surtainville',
	'FR50587' => 'Taillepied',
	'FR50588' => 'Tamerville',
	'FR50589' => 'Tanis',
	'FR50590' => 'Le Tanu',
	'FR50591' => 'Le Teilleul',
	'FR50592' => 'Tessy-Bocage',
	'FR50593' => 'Teurthéville-Bocage',
	'FR50594' => 'Teurthéville-Hague',
	'FR50596' => 'Théville',
	'FR50597' => 'Tirepied-sur-Sée',
	'FR50598' => 'Tocqueville',
	'FR50599' => 'Tollevast',
	'FR50601' => 'Torigny-les-Villes',
	'FR50603' => 'Tourville-sur-Sienne',
	'FR50604' => 'Tréauville',
	'FR50606' => 'Tribehou',
	'FR50607' => 'La Trinité',
	'FR50609' => 'Turqueville',
	'FR50610' => 'Urville',
	'FR50612' => 'Vains',
	'FR50613' => 'Valcanville',
	'FR50615' => 'Valognes',
	'FR50616' => 'Le Val-Saint-Père',
	'FR50617' => 'Varenguebec',
	'FR50618' => 'Varouville',
	'FR50619' => 'Le Vast',
	'FR50621' => 'Vaudreville',
	'FR50624' => 'La Vendelée',
	'FR50626' => 'Ver',
	'FR50628' => 'Vernix',
	'FR50629' => 'Vesly',
	'FR50633' => 'Le Vicel',
	'FR50634' => 'Videcosville',
	'FR50637' => 'Villebaudon',
	'FR50639' => 'Villedieu-les-Poêles-Rouffigny',
	'FR50641' => 'Villiers-Fossard',
	'FR50643' => 'Virandeville',
	'FR50647' => 'Yquelon',
	'FR50648' => 'Yvetot-Bocage',
	'FR51001' => 'Ablancourt',
	'FR51002' => 'Saint-Martin-dAblois',
	'FR51003' => 'Aigny',
	'FR51004' => 'Allemanche-Launay-et-Soyer',
	'FR51005' => 'Allemant',
	'FR51006' => 'Alliancelles',
	'FR51007' => 'Ambonnay',
	'FR51008' => 'Ambrières',
	'FR51009' => 'Anglure',
	'FR51010' => 'Angluzelles-et-Courcelles',
	'FR51012' => 'Anthenay',
	'FR51013' => 'Aougny',
	'FR51014' => 'Arcis-le-Ponsart',
	'FR51015' => 'Argers',
	'FR51016' => 'Arrigny',
	'FR51017' => 'Arzillières-Neuville',
	'FR51018' => 'Athis',
	'FR51019' => 'Aubérive',
	'FR51020' => 'Aubilly',
	'FR51022' => 'Aulnay-lAître',
	'FR51023' => 'Aulnay-sur-Marne',
	'FR51025' => 'Auménancourt',
	'FR51027' => 'Auve',
	'FR51028' => 'Avenay-Val-dOr',
	'FR51029' => 'Avize',
	'FR51030' => 'Aÿ-Champagne',
	'FR51031' => 'Baconnes',
	'FR51032' => 'Bagneux',
	'FR51033' => 'Le Baizil',
	'FR51034' => 'Bannay',
	'FR51035' => 'Bannes',
	'FR51036' => 'Barbonne-Fayel',
	'FR51037' => 'Baslieux-lès-Fismes',
	'FR51038' => 'Baslieux-sous-Châtillon',
	'FR51039' => 'Bassu',
	'FR51040' => 'Bassuet',
	'FR51041' => 'Baudement',
	'FR51042' => 'Baye',
	'FR51043' => 'Bazancourt',
	'FR51044' => 'Beaumont-sur-Vesle',
	'FR51045' => 'Beaunay',
	'FR51046' => 'Beine-Nauroy',
	'FR51047' => 'Belval-en-Argonne',
	'FR51048' => 'Belval-sous-Châtillon',
	'FR51049' => 'Bergères-lès-Vertus',
	'FR51050' => 'Bergères-sous-Montmirail',
	'FR51051' => 'Berméricourt',
	'FR51052' => 'Berru',
	'FR51053' => 'Berzieux',
	'FR51054' => 'Bétheniville',
	'FR51055' => 'Bétheny',
	'FR51056' => 'Bethon',
	'FR51057' => 'Bettancourt-la-Longue',
	'FR51058' => 'Bezannes',
	'FR51059' => 'Bignicourt-sur-Marne',
	'FR51060' => 'Bignicourt-sur-Saulx',
	'FR51061' => 'Billy-le-Grand',
	'FR51062' => 'Binarville',
	'FR51063' => 'Binson-et-Orquigny',
	'FR51065' => 'Blacy',
	'FR51066' => 'Blaise-sous-Arzillières',
	'FR51068' => 'Blesme',
	'FR51069' => 'Bligny',
	'FR51070' => 'Boissy-le-Repos',
	'FR51071' => 'Bouchy-Saint-Genest',
	'FR51072' => 'Bouilly',
	'FR51073' => 'Bouleuse',
	'FR51074' => 'Boult-sur-Suippe',
	'FR51075' => 'Bourgogne-Fresne',
	'FR51076' => 'Boursault',
	'FR51077' => 'Bouvancourt',
	'FR51078' => 'Bouy',
	'FR51079' => 'Bouzy',
	'FR51080' => 'Brandonvillers',
	'FR51081' => 'Branscourt',
	'FR51082' => 'Braux-Sainte-Cohière',
	'FR51083' => 'Braux-Saint-Remy',
	'FR51084' => 'Bréban',
	'FR51085' => 'Le Breuil',
	'FR51086' => 'Breuil-sur-Vesle',
	'FR51087' => 'Breuvery-sur-Coole',
	'FR51088' => 'Brimont',
	'FR51089' => 'Brouillet',
	'FR51090' => 'Broussy-le-Grand',
	'FR51091' => 'Broussy-le-Petit',
	'FR51092' => 'Broyes',
	'FR51093' => 'Brugny-Vaudancourt',
	'FR51094' => 'Brusson',
	'FR51095' => 'Le Buisson',
	'FR51097' => 'Bussy-le-Château',
	'FR51098' => 'Bussy-le-Repos',
	'FR51099' => 'Bussy-Lettrée',
	'FR51100' => 'La Caure',
	'FR51101' => 'Caurel',
	'FR51102' => 'Cauroy-lès-Hermonville',
	'FR51103' => 'La Celle-sous-Chantemerle',
	'FR51104' => 'Cernay-en-Dormois',
	'FR51105' => 'Cernay-lès-Reims',
	'FR51106' => 'Cernon',
	'FR51107' => 'Chaintrix-Bierges',
	'FR51108' => 'Châlons-en-Champagne',
	'FR51109' => 'Châlons-sur-Vesle',
	'FR51110' => 'Chaltrait',
	'FR51111' => 'Chambrecy',
	'FR51112' => 'Chamery',
	'FR51113' => 'Champaubert',
	'FR51115' => 'Champfleury',
	'FR51116' => 'Champguyon',
	'FR51117' => 'Champigneul-Champagne',
	'FR51118' => 'Champigny',
	'FR51119' => 'Champillon',
	'FR51120' => 'Champlat-et-Boujacourt',
	'FR51121' => 'Champvoisy',
	'FR51122' => 'Changy',
	'FR51124' => 'Chantemerle',
	'FR51125' => 'Chapelaine',
	'FR51126' => 'La Chapelle-Felcourt',
	'FR51127' => 'La Chapelle-Lasson',
	'FR51128' => 'La Chapelle-sous-Orbais',
	'FR51129' => 'Charleville',
	'FR51130' => 'Charmont',
	'FR51132' => 'Les Charmontois',
	'FR51133' => 'Le Châtelier',
	'FR51134' => 'Châtelraould-Saint-Louvent',
	'FR51135' => 'Châtillon-sur-Broué',
	'FR51136' => 'Châtillon-sur-Marne',
	'FR51137' => 'Châtillon-sur-Morin',
	'FR51138' => 'Châtrices',
	'FR51139' => 'Chaudefontaine',
	'FR51140' => 'Chaumuzy',
	'FR51141' => 'La Chaussée-sur-Marne',
	'FR51142' => 'Chavot-Courcourt',
	'FR51143' => 'Le Chemin',
	'FR51144' => 'Cheminon',
	'FR51145' => 'Chenay',
	'FR51146' => 'Cheniers',
	'FR51147' => 'La Cheppe',
	'FR51148' => 'Cheppes-la-Prairie',
	'FR51149' => 'Chepy',
	'FR51150' => 'Cherville',
	'FR51151' => 'Chichey',
	'FR51152' => 'Chigny-les-Roses',
	'FR51153' => 'Chouilly',
	'FR51154' => 'Clamanges',
	'FR51155' => 'Clesles',
	'FR51156' => 'Cloyes-sur-Marne',
	'FR51157' => 'Coizard-Joches',
	'FR51158' => 'Val-des-Marais',
	'FR51160' => 'Compertrix',
	'FR51161' => 'Condé-sur-Marne',
	'FR51162' => 'Conflans-sur-Seine',
	'FR51163' => 'Congy',
	'FR51164' => 'Connantray-Vaurefroy',
	'FR51165' => 'Connantre',
	'FR51166' => 'Contault',
	'FR51167' => 'Coole',
	'FR51168' => 'Coolus',
	'FR51169' => 'Corbeil',
	'FR51170' => 'Corfélix',
	'FR51171' => 'Cormicy',
	'FR51172' => 'Cormontreuil',
	'FR51173' => 'Cormoyeux',
	'FR51174' => 'Corribert',
	'FR51175' => 'Corrobert',
	'FR51176' => 'Corroy',
	'FR51177' => 'Coulommes-la-Montagne',
	'FR51178' => 'Coupetz',
	'FR51179' => 'Coupéville',
	'FR51181' => 'Courcelles-Sapicourt',
	'FR51182' => 'Courcemain',
	'FR51183' => 'Courcy',
	'FR51184' => 'Courdemanges',
	'FR51185' => 'Courgivaux',
	'FR51186' => 'Courjeonnet',
	'FR51187' => 'Courlandon',
	'FR51188' => 'Courmas',
	'FR51190' => 'Courtagnon',
	'FR51191' => 'Courtémont',
	'FR51192' => 'Courthiézy',
	'FR51193' => 'Courtisols',
	'FR51194' => 'Courville',
	'FR51195' => 'Couvrot',
	'FR51196' => 'Cramant',
	'FR51197' => 'La Croix-en-Champagne',
	'FR51198' => 'Crugny',
	'FR51199' => 'Cuchery',
	'FR51200' => 'Cuis',
	'FR51201' => 'Cuisles',
	'FR51202' => 'Cumières',
	'FR51203' => 'Cuperly',
	'FR51204' => 'Damery',
	'FR51205' => 'Dampierre-au-Temple',
	'FR51206' => 'Dampierre-le-Château',
	'FR51208' => 'Dampierre-sur-Moivre',
	'FR51210' => 'Dizy',
	'FR51211' => 'Dommartin-Dampierre',
	'FR51212' => 'Dommartin-Lettrée',
	'FR51213' => 'Dommartin-sous-Hans',
	'FR51214' => 'Dommartin-Varimont',
	'FR51215' => 'Dompremy',
	'FR51216' => 'Dontrien',
	'FR51217' => 'Dormans',
	'FR51218' => 'Val-de-Vière',
	'FR51219' => 'Drosnay',
	'FR51220' => 'Drouilly',
	'FR51222' => 'Éclaires',
	'FR51223' => 'Écollemont',
	'FR51224' => 'Écriennes',
	'FR51225' => 'Écueil',
	'FR51226' => 'Écury-le-Repos',
	'FR51227' => 'Écury-sur-Coole',
	'FR51228' => 'Élise-Daucourt',
	'FR51229' => 'Épense',
	'FR51230' => 'Épernay',
	'FR51231' => 'LÉpine',
	'FR51232' => 'Époye',
	'FR51233' => 'Escardes',
	'FR51234' => 'Esclavolles-Lurey',
	'FR51235' => 'Les Essarts-lès-Sézanne',
	'FR51236' => 'Les Essarts-le-Vicomte',
	'FR51237' => 'Esternay',
	'FR51238' => 'Étoges',
	'FR51239' => 'Étréchy',
	'FR51240' => 'Étrepy',
	'FR51241' => 'Euvy',
	'FR51242' => 'Fagnières',
	'FR51243' => 'Faux-Fresnay',
	'FR51244' => 'Faux-Vésigneul',
	'FR51245' => 'Faverolles-et-Coëmy',
	'FR51246' => 'Favresse',
	'FR51247' => 'Fèrebrianges',
	'FR51248' => 'Fère-Champenoise',
	'FR51249' => 'Festigny',
	'FR51250' => 'Fismes',
	'FR51251' => 'Flavigny',
	'FR51252' => 'Fleury-la-Rivière',
	'FR51253' => 'Florent-en-Argonne',
	'FR51254' => 'Fontaine-Denis-Nuisy',
	'FR51255' => 'Fontaine-en-Dormois',
	'FR51256' => 'Fontaine-sur-Ay',
	'FR51258' => 'La Forestière',
	'FR51259' => 'Francheville',
	'FR51260' => 'Le Fresne',
	'FR51262' => 'Frignicourt',
	'FR51263' => 'Fromentières',
	'FR51264' => 'Le Gault-Soigny',
	'FR51265' => 'Gaye',
	'FR51266' => 'Germaine',
	'FR51267' => 'Germigny',
	'FR51268' => 'Germinon',
	'FR51269' => 'Giffaumont-Champaubert',
	'FR51270' => 'Gigny-Bussy',
	'FR51272' => 'Givry-en-Argonne',
	'FR51273' => 'Givry-lès-Loisy',
	'FR51274' => 'Gizaucourt',
	'FR51275' => 'Glannes',
	'FR51276' => 'Gourgançon',
	'FR51277' => 'Sainte-Marie-du-Lac-Nuisement',
	'FR51278' => 'Les Grandes-Loges',
	'FR51279' => 'Granges-sur-Aube',
	'FR51280' => 'Gratreuil',
	'FR51281' => 'Grauves',
	'FR51282' => 'Gueux',
	'FR51283' => 'Hans',
	'FR51284' => 'Haussignémont',
	'FR51285' => 'Haussimont',
	'FR51286' => 'Hauteville',
	'FR51287' => 'Hautvillers',
	'FR51288' => 'Heiltz-le-Hutier',
	'FR51289' => 'Heiltz-le-Maurupt',
	'FR51290' => 'Heiltz-lÉvêque',
	'FR51291' => 'Hermonville',
	'FR51292' => 'Herpont',
	'FR51293' => 'Heutrégiville',
	'FR51294' => 'Hourges',
	'FR51295' => 'Huiron',
	'FR51296' => 'Humbauville',
	'FR51298' => 'Igny-Comblizy',
	'FR51299' => 'Isles-sur-Suippe',
	'FR51300' => 'Isle-sur-Marne',
	'FR51301' => 'Isse',
	'FR51302' => 'Les Istres-et-Bury',
	'FR51303' => 'Jâlons',
	'FR51304' => 'Janvilliers',
	'FR51305' => 'Janvry',
	'FR51306' => 'Joiselle',
	'FR51307' => 'Jonchery-sur-Suippe',
	'FR51308' => 'Jonchery-sur-Vesle',
	'FR51309' => 'Jonquery',
	'FR51310' => 'Jouy-lès-Reims',
	'FR51311' => 'Jussecourt-Minecourt',
	'FR51312' => 'Juvigny',
	'FR51313' => 'Lachy',
	'FR51314' => 'Lagery',
	'FR51315' => 'Landricourt',
	'FR51316' => 'Larzicourt',
	'FR51317' => 'Laval-sur-Tourbe',
	'FR51318' => 'Lavannes',
	'FR51319' => 'Lenharrée',
	'FR51320' => 'Leuvrigny',
	'FR51321' => 'Lhéry',
	'FR51322' => 'Lignon',
	'FR51323' => 'Linthelles',
	'FR51324' => 'Linthes',
	'FR51325' => 'Lisse-en-Champagne',
	'FR51326' => 'Livry-Louvercy',
	'FR51327' => 'Loisy-en-Brie',
	'FR51328' => 'Loisy-sur-Marne',
	'FR51329' => 'Loivre',
	'FR51333' => 'Ludes',
	'FR51334' => 'Luxémont-et-Villotte',
	'FR51336' => 'Maffrécourt',
	'FR51337' => 'Magneux',
	'FR51338' => 'Mailly-Champagne',
	'FR51339' => 'Mairy-sur-Marne',
	'FR51340' => 'Maisons-en-Champagne',
	'FR51341' => 'Malmy',
	'FR51342' => 'Mancy',
	'FR51343' => 'Marcilly-sur-Seine',
	'FR51344' => 'Mardeuil',
	'FR51345' => 'Mareuil-en-Brie',
	'FR51346' => 'Mareuil-le-Port',
	'FR51348' => 'Marfaux',
	'FR51349' => 'Margerie-Hancourt',
	'FR51350' => 'Margny',
	'FR51351' => 'Marigny',
	'FR51352' => 'Marolles',
	'FR51353' => 'Marsangis',
	'FR51354' => 'Marson',
	'FR51355' => 'Massiges',
	'FR51356' => 'Matignicourt-Goncourt',
	'FR51357' => 'Matougues',
	'FR51358' => 'Maurupt-le-Montois',
	'FR51359' => 'Mécringes',
	'FR51360' => 'Le Meix-Saint-Epoing',
	'FR51361' => 'Le Meix-Tiercelin',
	'FR51362' => 'Merfy',
	'FR51363' => 'Merlaut',
	'FR51364' => 'Méry-Prémecy',
	'FR51365' => 'Les Mesneux',
	'FR51367' => 'Le Mesnil-sur-Oger',
	'FR51368' => 'Minaucourt-le-Mesnil-lès-Hurlus',
	'FR51369' => 'Mœurs-Verdey',
	'FR51370' => 'Moiremont',
	'FR51371' => 'Moivre',
	'FR51372' => 'Moncetz-Longevas',
	'FR51373' => 'Moncetz-lAbbaye',
	'FR51374' => 'Mondement-Montgivroux',
	'FR51375' => 'Montbré',
	'FR51376' => 'Montgenost',
	'FR51377' => 'Montépreux',
	'FR51378' => 'Monthelon',
	'FR51379' => 'Montigny-sur-Vesle',
	'FR51380' => 'Montmirail',
	'FR51381' => 'Montmort-Lucy',
	'FR51382' => 'Mont-sur-Courville',
	'FR51384' => 'Morangis',
	'FR51386' => 'Morsains',
	'FR51387' => 'Moslins',
	'FR51388' => 'Mourmelon-le-Grand',
	'FR51389' => 'Mourmelon-le-Petit',
	'FR51390' => 'Moussy',
	'FR51391' => 'Muizon',
	'FR51392' => 'Mutigny',
	'FR51393' => 'Nanteuil-la-Forêt',
	'FR51395' => 'Nesle-la-Reposte',
	'FR51396' => 'Nesle-le-Repons',
	'FR51397' => 'La Neuville-aux-Bois',
	'FR51398' => 'La Neuville-aux-Larris',
	'FR51399' => 'La Neuville-au-Pont',
	'FR51402' => 'Neuvy',
	'FR51403' => 'Nogent-lAbbesse',
	'FR51404' => 'Noirlieu',
	'FR51406' => 'Norrois',
	'FR51407' => 'La Noue',
	'FR51409' => 'Nuisement-sur-Coole',
	'FR51410' => 'Œuilly',
	'FR51412' => 'Ognes',
	'FR51413' => 'Oiry',
	'FR51414' => 'Olizy',
	'FR51415' => 'Omey',
	'FR51416' => 'Orbais-lAbbaye',
	'FR51417' => 'Orconte',
	'FR51418' => 'Ormes',
	'FR51419' => 'Outines',
	'FR51420' => 'Outrepont',
	'FR51421' => 'Oyes',
	'FR51422' => 'Pargny-lès-Reims',
	'FR51423' => 'Pargny-sur-Saulx',
	'FR51424' => 'Passavant-en-Argonne',
	'FR51425' => 'Passy-Grigny',
	'FR51426' => 'Péas',
	'FR51428' => 'Les Petites-Loges',
	'FR51429' => 'Pévy',
	'FR51430' => 'Pierre-Morains',
	'FR51431' => 'Pierry',
	'FR51432' => 'Pleurs',
	'FR51433' => 'Plichancourt',
	'FR51434' => 'Plivot',
	'FR51435' => 'Pocancy',
	'FR51436' => 'Pogny',
	'FR51437' => 'Poilly',
	'FR51438' => 'Poix',
	'FR51439' => 'Pomacle',
	'FR51440' => 'Pontfaverger-Moronvilliers',
	'FR51441' => 'Ponthion',
	'FR51442' => 'Possesse',
	'FR51443' => 'Potangis',
	'FR51444' => 'Pouillon',
	'FR51445' => 'Pourcy',
	'FR51446' => 'Pringy',
	'FR51447' => 'Prosnes',
	'FR51448' => 'Prouilly',
	'FR51449' => 'Prunay',
	'FR51450' => 'Puisieulx',
	'FR51451' => 'Queudes',
	'FR51452' => 'Rapsécourt',
	'FR51453' => 'Recy',
	'FR51454' => 'Reims',
	'FR51455' => 'Reims-la-Brûlée',
	'FR51456' => 'Remicourt',
	'FR51457' => 'Reuil',
	'FR51458' => 'Reuves',
	'FR51459' => 'Réveillon',
	'FR51460' => 'Rieux',
	'FR51461' => 'Rilly-la-Montagne',
	'FR51463' => 'Les Rivières-Henruel',
	'FR51464' => 'Romain',
	'FR51465' => 'Romery',
	'FR51466' => 'Romigny',
	'FR51468' => 'Rosnay',
	'FR51469' => 'Rouffy',
	'FR51470' => 'Rouvroy-Ripont',
	'FR51471' => 'Sacy',
	'FR51472' => 'Saint-Amand-sur-Fion',
	'FR51473' => 'Saint-Bon',
	'FR51474' => 'Saint-Brice-Courcelles',
	'FR51475' => 'Saint-Chéron',
	'FR51476' => 'Saint-Étienne-au-Temple',
	'FR51477' => 'Saint-Étienne-sur-Suippe',
	'FR51478' => 'Saint-Eulien',
	'FR51479' => 'Saint-Euphraise-et-Clairizet',
	'FR51480' => 'Sainte-Gemme',
	'FR51482' => 'Saint-Germain-la-Ville',
	'FR51483' => 'Saint-Gibrien',
	'FR51484' => 'Saint-Gilles',
	'FR51485' => 'Saint-Hilaire-au-Temple',
	'FR51486' => 'Saint-Hilaire-le-Grand',
	'FR51487' => 'Saint-Hilaire-le-Petit',
	'FR51488' => 'Saint-Imoges',
	'FR51489' => 'Saint-Jean-devant-Possesse',
	'FR51490' => 'Saint-Jean-sur-Moivre',
	'FR51491' => 'Saint-Jean-sur-Tourbe',
	'FR51492' => 'Saint-Just-Sauvage',
	'FR51493' => 'Saint-Léonard',
	'FR51495' => 'Saint-Loup',
	'FR51496' => 'Saint-Lumier-en-Champagne',
	'FR51497' => 'Saint-Lumier-la-Populeuse',
	'FR51498' => 'Saint-Mard-sur-Auve',
	'FR51499' => 'Saint-Mard-lès-Rouffy',
	'FR51500' => 'Saint-Mard-sur-le-Mont',
	'FR51501' => 'Sainte-Marie-à-Py',
	'FR51502' => 'Saint-Martin-aux-Champs',
	'FR51503' => 'Saint-Martin-lHeureux',
	'FR51504' => 'Saint-Martin-sur-le-Pré',
	'FR51505' => 'Saint-Masmes',
	'FR51506' => 'Saint-Memmie',
	'FR51507' => 'Sainte-Menehould',
	'FR51508' => 'Saint-Ouen-Domprot',
	'FR51509' => 'Saint-Pierre',
	'FR51510' => 'Saint-Quentin-les-Marais',
	'FR51511' => 'Saint-Quentin-le-Verger',
	'FR51512' => 'Saint-Quentin-sur-Coole',
	'FR51513' => 'Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson',
	'FR51514' => 'Saint-Remy-sous-Broyes',
	'FR51515' => 'Saint-Remy-sur-Bussy',
	'FR51516' => 'Saint-Saturnin',
	'FR51517' => 'Saint-Souplet-sur-Py',
	'FR51518' => 'Saint-Thierry',
	'FR51519' => 'Saint-Thomas-en-Argonne',
	'FR51520' => 'Saint-Utin',
	'FR51521' => 'Saint-Vrain',
	'FR51522' => 'Sapignicourt',
	'FR51523' => 'Sarcy',
	'FR51524' => 'Saron-sur-Aube',
	'FR51525' => 'Sarry',
	'FR51526' => 'Saudoy',
	'FR51527' => 'Savigny-sur-Ardres',
	'FR51528' => 'Scrupt',
	'FR51529' => 'Selles',
	'FR51530' => 'Sept-Saulx',
	'FR51531' => 'Sermaize-les-Bains',
	'FR51532' => 'Sermiers',
	'FR51533' => 'Servon-Melzicourt',
	'FR51534' => 'Serzy-et-Prin',
	'FR51535' => 'Sézanne',
	'FR51536' => 'Sillery',
	'FR51537' => 'Sivry-Ante',
	'FR51538' => 'Sogny-aux-Moulins',
	'FR51539' => 'Sogny-en-lAngle',
	'FR51542' => 'Soizy-aux-Bois',
	'FR51543' => 'Somme-Bionne',
	'FR51544' => 'Sommepy-Tahure',
	'FR51545' => 'Sommesous',
	'FR51546' => 'Somme-Suippe',
	'FR51547' => 'Somme-Tourbe',
	'FR51548' => 'Somme-Vesle',
	'FR51549' => 'Somme-Yèvre',
	'FR51550' => 'Sompuis',
	'FR51551' => 'Somsois',
	'FR51552' => 'Songy',
	'FR51553' => 'Souain-Perthes-lès-Hurlus',
	'FR51555' => 'Soudé',
	'FR51556' => 'Soudron',
	'FR51557' => 'Soulanges',
	'FR51558' => 'Soulières',
	'FR51559' => 'Suippes',
	'FR51560' => 'Suizy-le-Franc',
	'FR51562' => 'Taissy',
	'FR51563' => 'Talus-Saint-Prix',
	'FR51564' => 'Val de Livre',
	'FR51565' => 'Thaas',
	'FR51566' => 'Thibie',
	'FR51567' => 'Thiéblemont-Farémont',
	'FR51568' => 'Thil',
	'FR51569' => 'Thillois',
	'FR51570' => 'Le Thoult-Trosnay',
	'FR51571' => 'Val-de-Vesle',
	'FR51572' => 'Tilloy-et-Bellay',
	'FR51573' => 'Tinqueux',
	'FR51574' => 'Togny-aux-Bœufs',
	'FR51576' => 'Tours-sur-Marne',
	'FR51577' => 'Tramery',
	'FR51578' => 'Trécon',
	'FR51579' => 'Tréfols',
	'FR51580' => 'Trépail',
	'FR51581' => 'Treslon',
	'FR51582' => 'Trigny',
	'FR51583' => 'Trois-Fontaines-lAbbaye',
	'FR51584' => 'Trois-Puits',
	'FR51585' => 'Troissy',
	'FR51586' => 'Unchair',
	'FR51587' => 'Vadenay',
	'FR51588' => 'Valmy',
	'FR51589' => 'Vanault-le-Châtel',
	'FR51590' => 'Vanault-les-Dames',
	'FR51591' => 'Vandeuil',
	'FR51592' => 'Vandières',
	'FR51594' => 'Vassimont-et-Chapelaine',
	'FR51595' => 'Vatry',
	'FR51596' => 'Vauchamps',
	'FR51597' => 'Vauciennes',
	'FR51598' => 'Vauclerc',
	'FR51599' => 'Vaudemange',
	'FR51600' => 'Vaudesincourt',
	'FR51601' => 'Vavray-le-Grand',
	'FR51602' => 'Vavray-le-Petit',
	'FR51603' => 'Vélye',
	'FR51604' => 'Ventelay',
	'FR51605' => 'Venteuil',
	'FR51607' => 'Verdon',
	'FR51608' => 'Vernancourt',
	'FR51609' => 'Verneuil',
	'FR51610' => 'Verrières',
	'FR51611' => 'Vert-Toulon',
	'FR51612' => 'Blancs-Coteaux',
	'FR51613' => 'Verzenay',
	'FR51614' => 'Verzy',
	'FR51616' => 'Vésigneul-sur-Marne',
	'FR51617' => 'La Veuve',
	'FR51618' => 'Le Vézier',
	'FR51619' => 'Le Vieil-Dampierre',
	'FR51620' => 'Vienne-la-Ville',
	'FR51621' => 'Vienne-le-Château',
	'FR51622' => 'Ville-Dommange',
	'FR51623' => 'Ville-en-Selve',
	'FR51624' => 'Ville-en-Tardenois',
	'FR51625' => 'Villeneuve-la-Lionne',
	'FR51626' => 'La Villeneuve-lès-Charleville',
	'FR51627' => 'Villeneuve-Renneville-Chevigny',
	'FR51628' => 'Villeneuve-Saint-Vistre-et-Villevotte',
	'FR51629' => 'Villers-Allerand',
	'FR51630' => 'Villers-aux-Bois',
	'FR51631' => 'Villers-aux-Nœuds',
	'FR51632' => 'Villers-en-Argonne',
	'FR51633' => 'Villers-Franqueux',
	'FR51634' => 'Villers-le-Château',
	'FR51635' => 'Villers-le-Sec',
	'FR51636' => 'Villers-Marmery',
	'FR51637' => 'Villers-sous-Châtillon',
	'FR51638' => 'Villeseneux',
	'FR51639' => 'La Ville-sous-Orbais',
	'FR51640' => 'Ville-sur-Tourbe',
	'FR51641' => 'Villevenard',
	'FR51642' => 'Villiers-aux-Corneilles',
	'FR51643' => 'Vinay',
	'FR51644' => 'Vincelles',
	'FR51645' => 'Vindey',
	'FR51646' => 'Virginy',
	'FR51647' => 'Vitry-en-Perthois',
	'FR51648' => 'Vitry-la-Ville',
	'FR51649' => 'Vitry-le-François',
	'FR51650' => 'Voilemont',
	'FR51652' => 'Vouarces',
	'FR51654' => 'Vouillers',
	'FR51655' => 'Vouzy',
	'FR51656' => 'Vraux',
	'FR51657' => 'Vrigny',
	'FR51658' => 'Vroil',
	'FR51659' => 'Wargemoulin-Hurlus',
	'FR51660' => 'Warmeriville',
	'FR51662' => 'Witry-lès-Reims',
	'FR51663' => 'Magenta',
	'FR52001' => 'Ageville',
	'FR52002' => 'Aigremont',
	'FR52003' => 'Aillianville',
	'FR52004' => 'Aingoulaincourt',
	'FR52005' => 'Aizanville',
	'FR52006' => 'Allichamps',
	'FR52007' => 'Ambonville',
	'FR52008' => 'Andelot-Blancheville',
	'FR52009' => 'Andilly-en-Bassigny',
	'FR52011' => 'Annéville-la-Prairie',
	'FR52012' => 'Annonville',
	'FR52013' => 'Anrosey',
	'FR52014' => 'Aprey',
	'FR52015' => 'Arbigny-sous-Varennes',
	'FR52016' => 'Arbot',
	'FR52017' => 'Arc-en-Barrois',
	'FR52019' => 'Arnancourt',
	'FR52021' => 'Attancourt',
	'FR52022' => 'Aubepierre-sur-Aube',
	'FR52023' => 'Auberive',
	'FR52025' => 'Audeloncourt',
	'FR52027' => 'Aujeurres',
	'FR52028' => 'Aulnoy-sur-Aube',
	'FR52029' => 'Autigny-le-Grand',
	'FR52030' => 'Autigny-le-Petit',
	'FR52031' => 'Autreville-sur-la-Renne',
	'FR52033' => 'Avrecourt',
	'FR52034' => 'Bailly-aux-Forges',
	'FR52035' => 'Baissey',
	'FR52037' => 'Bannes',
	'FR52038' => 'Bassoncourt',
	'FR52039' => 'Baudrecourt',
	'FR52040' => 'Bay-sur-Aube',
	'FR52042' => 'Beauchemin',
	'FR52043' => 'Belmont',
	'FR52044' => 'Roches-Bettaincourt',
	'FR52045' => 'Bettancourt-la-Ferrée',
	'FR52047' => 'Beurville',
	'FR52050' => 'Biesles',
	'FR52051' => 'Bize',
	'FR52053' => 'Blaisy',
	'FR52055' => 'Blécourt',
	'FR52056' => 'Blessonville',
	'FR52057' => 'Blumeray',
	'FR52058' => 'Bologne',
	'FR52059' => 'Bonnecourt',
	'FR52060' => 'Bourbonne-les-Bains',
	'FR52061' => 'Bourdons-sur-Rognon',
	'FR52062' => 'Bourg',
	'FR52063' => 'Bourg-Sainte-Marie',
	'FR52064' => 'Bourmont-entre-Meuse-et-Mouzon',
	'FR52065' => 'Bouzancourt',
	'FR52066' => 'Brachay',
	'FR52067' => 'Brainville-sur-Meuse',
	'FR52069' => 'Braux-le-Châtel',
	'FR52070' => 'Brennes',
	'FR52072' => 'Brethenay',
	'FR52074' => 'Breuvannes-en-Bassigny',
	'FR52075' => 'Briaucourt',
	'FR52076' => 'Bricon',
	'FR52079' => 'Brousseval',
	'FR52082' => 'Bugnières',
	'FR52083' => 'Champsevraine',
	'FR52084' => 'Busson',
	'FR52085' => 'Buxières-lès-Clefmont',
	'FR52087' => 'Buxières-lès-Villiers',
	'FR52088' => 'Ceffonds',
	'FR52089' => 'Celles-en-Bassigny',
	'FR52090' => 'Celsoy',
	'FR52091' => 'Cerisières',
	'FR52092' => 'Chalancey',
	'FR52093' => 'Chalindrey',
	'FR52094' => 'Vals-des-Tilles',
	'FR52095' => 'Chalvraines',
	'FR52097' => 'Chambroncourt',
	'FR52099' => 'Chamouilley',
	'FR52101' => 'Champigneulles-en-Bassigny',
	'FR52102' => 'Champigny-lès-Langres',
	'FR52103' => 'Champigny-sous-Varennes',
	'FR52104' => 'Chancenay',
	'FR52105' => 'Changey',
	'FR52106' => 'Chanoy',
	'FR52107' => 'Chantraines',
	'FR52108' => 'Charmes',
	'FR52109' => 'Charmes-en-lAngle',
	'FR52110' => 'Charmes-la-Grande',
	'FR52113' => 'Chassigny',
	'FR52114' => 'Châteauvillain',
	'FR52115' => 'Chatenay-Mâcheron',
	'FR52116' => 'Chatenay-Vaudin',
	'FR52118' => 'Chatonrupt-Sommermont',
	'FR52119' => 'Chaudenay',
	'FR52120' => 'Chauffourt',
	'FR52121' => 'Chaumont',
	'FR52122' => 'Chaumont-la-Ville',
	'FR52123' => 'Chevillon',
	'FR52124' => 'Chézeaux',
	'FR52125' => 'Chamarandes-Choignes',
	'FR52126' => 'Choilley-Dardenay',
	'FR52127' => 'Choiseul',
	'FR52128' => 'Cirey-lès-Mareilles',
	'FR52129' => 'Cirey-sur-Blaise',
	'FR52130' => 'Cirfontaines-en-Azois',
	'FR52131' => 'Cirfontaines-en-Ornois',
	'FR52132' => 'Clefmont',
	'FR52133' => 'Clinchamp',
	'FR52134' => 'Cohons',
	'FR52135' => 'Coiffy-le-Bas',
	'FR52136' => 'Coiffy-le-Haut',
	'FR52137' => 'Colmier-le-Bas',
	'FR52138' => 'Colmier-le-Haut',
	'FR52140' => 'Colombey les Deux Églises',
	'FR52141' => 'Condes',
	'FR52142' => 'Consigny',
	'FR52145' => 'Coublanc',
	'FR52146' => 'Coupray',
	'FR52147' => 'Courcelles-en-Montagne',
	'FR52149' => 'Courcelles-sur-Blaise',
	'FR52151' => 'Cour-lÉvêque',
	'FR52155' => 'Culmont',
	'FR52156' => 'Curel',
	'FR52157' => 'Curmont',
	'FR52158' => 'Cusey',
	'FR52159' => 'Cuves',
	'FR52160' => 'Daillancourt',
	'FR52161' => 'Daillecourt',
	'FR52162' => 'Dammartin-sur-Meuse',
	'FR52163' => 'Dampierre',
	'FR52164' => 'Damrémont',
	'FR52165' => 'Dancevoir',
	'FR52167' => 'Darmannes',
	'FR52168' => 'Dinteville',
	'FR52169' => 'Domblain',
	'FR52170' => 'Dommarien',
	'FR52171' => 'Dommartin-le-Franc',
	'FR52172' => 'Dommartin-le-Saint-Père',
	'FR52173' => 'Domremy-Landéville',
	'FR52174' => 'Doncourt-sur-Meuse',
	'FR52175' => 'Donjeux',
	'FR52177' => 'Doulaincourt-Saucourt',
	'FR52178' => 'Doulevant-le-Château',
	'FR52179' => 'Doulevant-le-Petit',
	'FR52181' => 'Échenay',
	'FR52182' => 'Éclaron-Braucourt-Sainte-Livière',
	'FR52183' => 'Ecot-la-Combe',
	'FR52184' => 'Effincourt',
	'FR52185' => 'Enfonvelle',
	'FR52187' => 'Épizon',
	'FR52189' => 'Le Val-dEsnoms',
	'FR52190' => 'Esnouveaux',
	'FR52193' => 'Euffigneix',
	'FR52194' => 'Eurville-Bienville',
	'FR52195' => 'Farincourt',
	'FR52196' => 'Faverolles',
	'FR52197' => 'Fayl-Billot',
	'FR52198' => 'Fays',
	'FR52199' => 'Ferrière-et-Lafolie',
	'FR52200' => 'Flagey',
	'FR52201' => 'Flammerécourt',
	'FR52203' => 'Fontaines-sur-Marne',
	'FR52204' => 'Forcey',
	'FR52205' => 'Foulain',
	'FR52206' => 'Frampas',
	'FR52207' => 'Frécourt',
	'FR52208' => 'Fresnes-sur-Apance',
	'FR52211' => 'Froncles',
	'FR52212' => 'Fronville',
	'FR52213' => 'Genevrières',
	'FR52214' => 'La Genevroye',
	'FR52216' => 'Germaines',
	'FR52217' => 'Germainvilliers',
	'FR52218' => 'Germay',
	'FR52219' => 'Germisay',
	'FR52220' => 'Giey-sur-Aujon',
	'FR52221' => 'Gillancourt',
	'FR52222' => 'Gillaumé',
	'FR52223' => 'Gilley',
	'FR52227' => 'Graffigny-Chemin',
	'FR52228' => 'Grandchamp',
	'FR52229' => 'Grenant',
	'FR52230' => 'Gudmont-Villiers',
	'FR52231' => 'Guindrecourt-aux-Ormes',
	'FR52232' => 'Guindrecourt-sur-Blaise',
	'FR52233' => 'Guyonvelle',
	'FR52234' => 'Hâcourt',
	'FR52235' => 'Hallignicourt',
	'FR52237' => 'Harréville-les-Chanteurs',
	'FR52240' => 'Heuilley-le-Grand',
	'FR52242' => 'Haute-Amance',
	'FR52243' => 'Huilliécourt',
	'FR52244' => 'Humbécourt',
	'FR52245' => 'Humberville',
	'FR52246' => 'Humes-Jorquenay',
	'FR52247' => 'Illoud',
	'FR52248' => 'Is-en-Bassigny',
	'FR52249' => 'Isômes',
	'FR52250' => 'Joinville',
	'FR52251' => 'Jonchery',
	'FR52253' => 'Juzennecourt',
	'FR52254' => 'Lachapelle-en-Blaisy',
	'FR52256' => 'Lafauche',
	'FR52257' => 'Laferté-sur-Amance',
	'FR52258' => 'Laferté-sur-Aube',
	'FR52260' => 'Lamancine',
	'FR52264' => 'Laneuvelle',
	'FR52265' => 'Bayard-sur-Marne',
	'FR52266' => 'Laneuville-à-Rémy',
	'FR52267' => 'Laneuville-au-Pont',
	'FR52269' => 'Langres',
	'FR52271' => 'Lanques-sur-Rognon',
	'FR52272' => 'Lanty-sur-Aube',
	'FR52273' => 'Larivière-Arnoncourt',
	'FR52274' => 'Latrecey-Ormoy-sur-Aube',
	'FR52275' => 'Lavernoy',
	'FR52276' => 'Laville-aux-Bois',
	'FR52277' => 'Lavilleneuve',
	'FR52278' => 'Lavilleneuve-au-Roi',
	'FR52280' => 'Lecey',
	'FR52282' => 'Leffonds',
	'FR52284' => 'Leschères-sur-le-Blaiseron',
	'FR52285' => 'Leuchey',
	'FR52286' => 'Leurville',
	'FR52287' => 'Levécourt',
	'FR52288' => 'Lezéville',
	'FR52289' => 'Liffol-le-Petit',
	'FR52290' => 'Les Loges',
	'FR52291' => 'Longchamp',
	'FR52292' => 'Longeau-Percey',
	'FR52294' => 'Louvemont',
	'FR52295' => 'Louvières',
	'FR52297' => 'Luzy-sur-Marne',
	'FR52298' => 'Maâtz',
	'FR52300' => 'Magneux',
	'FR52301' => 'Maisoncelles',
	'FR52302' => 'Maizières',
	'FR52303' => 'Maizières-sur-Amance',
	'FR52304' => 'Malaincourt-sur-Meuse',
	'FR52305' => 'Mandres-la-Côte',
	'FR52306' => 'Manois',
	'FR52307' => 'Marac',
	'FR52308' => 'Maranville',
	'FR52310' => 'Marbéville',
	'FR52311' => 'Marcilly-en-Bassigny',
	'FR52312' => 'Mardor',
	'FR52313' => 'Mareilles',
	'FR52315' => 'Marnay-sur-Marne',
	'FR52316' => 'Mathons',
	'FR52318' => 'Melay',
	'FR52319' => 'Mennouveaux',
	'FR52320' => 'Merrey',
	'FR52321' => 'Mertrud',
	'FR52322' => 'Meures',
	'FR52325' => 'Millières',
	'FR52326' => 'Mirbel',
	'FR52327' => 'Moëslains',
	'FR52328' => 'Montcharvot',
	'FR52330' => 'Montheries',
	'FR52331' => 'La Porte du Der',
	'FR52332' => 'Val-de-Meuse',
	'FR52335' => 'Montot-sur-Rognon',
	'FR52336' => 'Montreuil-sur-Blaise',
	'FR52337' => 'Montreuil-sur-Thonnance',
	'FR52341' => 'Morancourt',
	'FR52342' => 'Morionvilliers',
	'FR52344' => 'Mouilleron',
	'FR52346' => 'Mussey-sur-Marne',
	'FR52347' => 'Narcy',
	'FR52348' => 'Neuilly-lÉvêque',
	'FR52349' => 'Neuilly-sur-Suize',
	'FR52350' => 'Neuvelle-lès-Voisey',
	'FR52352' => 'Ninville',
	'FR52353' => 'Nogent',
	'FR52354' => 'Noidant-Chatenoy',
	'FR52355' => 'Noidant-le-Rocheux',
	'FR52356' => 'Nomécourt',
	'FR52357' => 'Noncourt-sur-le-Rongeant',
	'FR52358' => 'Noyers',
	'FR52359' => 'Nully',
	'FR52360' => 'Occey',
	'FR52362' => 'Orbigny-au-Mont',
	'FR52363' => 'Orbigny-au-Val',
	'FR52364' => 'Orcevaux',
	'FR52365' => 'Orges',
	'FR52366' => 'Ormancey',
	'FR52367' => 'Ormoy-lès-Sexfontaines',
	'FR52369' => 'Orquevaux',
	'FR52370' => 'Osne-le-Val',
	'FR52371' => 'Oudincourt',
	'FR52372' => 'Outremécourt',
	'FR52373' => 'Ozières',
	'FR52374' => 'Le Pailly',
	'FR52375' => 'Palaiseul',
	'FR52376' => 'Pansey',
	'FR52377' => 'Parnoy-en-Bassigny',
	'FR52378' => 'Paroy-sur-Saulx',
	'FR52380' => 'Peigney',
	'FR52383' => 'Perrancey-les-Vieux-Moulins',
	'FR52384' => 'Perrogney-les-Fontaines',
	'FR52385' => 'Perrusse',
	'FR52386' => 'Perthes',
	'FR52388' => 'Pierremont-sur-Amance',
	'FR52390' => 'Pisseloup',
	'FR52391' => 'Planrupt',
	'FR52392' => 'Plesnoy',
	'FR52393' => 'Poinsenot',
	'FR52394' => 'Poinson-lès-Fayl',
	'FR52395' => 'Poinson-lès-Grancey',
	'FR52396' => 'Poinson-lès-Nogent',
	'FR52397' => 'Poiseul',
	'FR52398' => 'Poissons',
	'FR52399' => 'Pont-la-Ville',
	'FR52400' => 'Le Châtelet-sur-Meuse',
	'FR52401' => 'Poulangy',
	'FR52403' => 'Praslay',
	'FR52405' => 'Le Montsaugeonnais',
	'FR52406' => 'Pressigny',
	'FR52407' => 'Prez-sous-Lafauche',
	'FR52411' => 'Rives Dervoises',
	'FR52413' => 'Rachecourt-Suzémont',
	'FR52414' => 'Rachecourt-sur-Marne',
	'FR52415' => 'Rançonnières',
	'FR52416' => 'Rangecourt',
	'FR52419' => 'Rennepont',
	'FR52420' => 'Reynel',
	'FR52421' => 'Riaucourt',
	'FR52422' => 'Richebourg',
	'FR52423' => 'Rimaucourt',
	'FR52424' => 'Rivières-le-Bois',
	'FR52425' => 'Rivière-les-Fosses',
	'FR52426' => 'Rizaucourt-Buchey',
	'FR52428' => 'Rochefort-sur-la-Côte',
	'FR52429' => 'Roches-sur-Marne',
	'FR52431' => 'Rochetaillée',
	'FR52432' => 'Rolampont',
	'FR52433' => 'Romain-sur-Meuse',
	'FR52436' => 'Rouécourt',
	'FR52437' => 'Rouelles',
	'FR52438' => 'Rougeux',
	'FR52439' => 'Rouvres-sur-Aube',
	'FR52440' => 'Rouvroy-sur-Marne',
	'FR52442' => 'Rupt',
	'FR52443' => 'Sailly',
	'FR52444' => 'Saint-Blin',
	'FR52445' => 'Saint-Broingt-le-Bois',
	'FR52446' => 'Saint-Broingt-les-Fosses',
	'FR52447' => 'Saint-Ciergues',
	'FR52448' => 'Saint-Dizier',
	'FR52449' => 'Saints-Geosmes',
	'FR52450' => 'Saint-Loup-sur-Aujon',
	'FR52452' => 'Saint-Martin-lès-Langres',
	'FR52453' => 'Saint-Maurice',
	'FR52455' => 'Saint-Thiébault',
	'FR52456' => 'Saint-Urbain-Maconcourt',
	'FR52457' => 'Saint-Vallier-sur-Marne',
	'FR52459' => 'Sarcey',
	'FR52461' => 'Sarrey',
	'FR52463' => 'Saudron',
	'FR52464' => 'Saulles',
	'FR52465' => 'Saulxures',
	'FR52467' => 'Savigny',
	'FR52468' => 'Semilly',
	'FR52469' => 'Semoutiers-Montsaon',
	'FR52470' => 'Serqueux',
	'FR52472' => 'Sexfontaines',
	'FR52473' => 'Signéville',
	'FR52474' => 'Silvarouvres',
	'FR52475' => 'Sommancourt',
	'FR52476' => 'Sommerécourt',
	'FR52479' => 'Sommevoire',
	'FR52480' => 'Soncourt-sur-Marne',
	'FR52482' => 'Soulaucourt-sur-Mouzon',
	'FR52483' => 'Soyers',
	'FR52484' => 'Suzannecourt',
	'FR52486' => 'Ternat',
	'FR52487' => 'Thilleux',
	'FR52488' => 'Thivet',
	'FR52489' => 'Thol-lès-Millières',
	'FR52490' => 'Thonnance-lès-Joinville',
	'FR52491' => 'Thonnance-les-Moulins',
	'FR52492' => 'Torcenay',
	'FR52493' => 'Tornay',
	'FR52494' => 'Treix',
	'FR52495' => 'Trémilly',
	'FR52497' => 'Troisfontaines-la-Ville',
	'FR52499' => 'Vaillant',
	'FR52500' => 'Valcourt',
	'FR52502' => 'Valleret',
	'FR52503' => 'Valleroy',
	'FR52504' => 'Varennes-sur-Amance',
	'FR52505' => 'Vaudrecourt',
	'FR52506' => 'Vaudrémont',
	'FR52507' => 'Vauxbons',
	'FR52510' => 'Vaux-sur-Blaise',
	'FR52511' => 'Vaux-sur-Saint-Urbain',
	'FR52512' => 'Vecqueville',
	'FR52513' => 'Velles',
	'FR52514' => 'Verbiesles',
	'FR52515' => 'Verseilles-le-Bas',
	'FR52516' => 'Verseilles-le-Haut',
	'FR52517' => 'Vesaignes-sous-Lafauche',
	'FR52518' => 'Vesaignes-sur-Marne',
	'FR52519' => 'Vesvres-sous-Chalancey',
	'FR52520' => 'Vicq',
	'FR52522' => 'Viéville',
	'FR52523' => 'Vignes-la-Côte',
	'FR52524' => 'Vignory',
	'FR52525' => 'Villars-en-Azois',
	'FR52526' => 'Villars-Santenoge',
	'FR52528' => 'Ville-en-Blaisois',
	'FR52529' => 'Villegusien-le-Lac',
	'FR52534' => 'Villiers-en-Lieu',
	'FR52535' => 'Villiers-le-Sec',
	'FR52536' => 'Villiers-lès-Aprey',
	'FR52538' => 'Villiers-sur-Suize',
	'FR52539' => 'Violot',
	'FR52540' => 'Vitry-en-Montagne',
	'FR52541' => 'Vitry-lès-Nogent',
	'FR52542' => 'Vivey',
	'FR52543' => 'Voillecomte',
	'FR52544' => 'Voisey',
	'FR52545' => 'Voisines',
	'FR52546' => 'Voncourt',
	'FR52547' => 'Vouécourt',
	'FR52548' => 'Vraincourt',
	'FR52549' => 'Vroncourt-la-Côte',
	'FR52550' => 'Wassy',
	'FR53001' => 'Ahuillé',
	'FR53002' => 'Alexain',
	'FR53003' => 'Ambrières-les-Vallées',
	'FR53005' => 'Andouillé',
	'FR53007' => 'Argentré',
	'FR53008' => 'Aron',
	'FR53009' => 'Arquenay',
	'FR53010' => 'Assé-le-Bérenger',
	'FR53011' => 'Astillé',
	'FR53012' => 'Athée',
	'FR53013' => 'Averton',
	'FR53015' => 'La Baconnière',
	'FR53016' => 'Bais',
	'FR53017' => 'Val-du-Maine',
	'FR53018' => 'Ballots',
	'FR53019' => 'Bannes',
	'FR53021' => 'La Bazoge-Montpinçon',
	'FR53022' => 'La Bazouge-de-Chemeré',
	'FR53023' => 'La Bazouge-des-Alleux',
	'FR53025' => 'Bazougers',
	'FR53026' => 'Beaulieu-sur-Oudon',
	'FR53027' => 'Beaumont-Pied-de-Bœuf',
	'FR53028' => 'Belgeard',
	'FR53029' => 'Bierné-les-Villages',
	'FR53030' => 'Le Bignon-du-Maine',
	'FR53031' => 'La Bigottière',
	'FR53033' => 'La Boissière',
	'FR53034' => 'Bonchamp-lès-Laval',
	'FR53035' => 'Bouchamps-lès-Craon',
	'FR53036' => 'Bouère',
	'FR53037' => 'Bouessay',
	'FR53038' => 'Boulay-les-Ifs',
	'FR53039' => 'Le Bourgneuf-la-Forêt',
	'FR53040' => 'Bourgon',
	'FR53041' => 'Brains-sur-les-Marches',
	'FR53042' => 'Brecé',
	'FR53043' => 'Brée',
	'FR53045' => 'La Brûlatte',
	'FR53046' => 'Le Buret',
	'FR53047' => 'Carelles',
	'FR53048' => 'Chailland',
	'FR53049' => 'Châlons-du-Maine',
	'FR53051' => 'Champéon',
	'FR53052' => 'Champfrémont',
	'FR53053' => 'Champgenéteux',
	'FR53054' => 'Changé',
	'FR53055' => 'Chantrigné',
	'FR53056' => 'La Chapelle-Anthenaise',
	'FR53057' => 'La Chapelle-au-Riboul',
	'FR53058' => 'La Chapelle-Craonnaise',
	'FR53059' => 'La Chapelle-Rainsouin',
	'FR53061' => 'Charchigné',
	'FR53062' => 'Château-Gontier-sur-Mayenne',
	'FR53063' => 'Châtelain',
	'FR53064' => 'Châtillon-sur-Colmont',
	'FR53066' => 'Chemazé',
	'FR53067' => 'Chémeré-le-Roi',
	'FR53068' => 'Chérancé',
	'FR53069' => 'Chevaigné-du-Maine',
	'FR53071' => 'Colombiers-du-Plessis',
	'FR53072' => 'Commer',
	'FR53073' => 'Congrier',
	'FR53074' => 'Contest',
	'FR53075' => 'Cosmes',
	'FR53076' => 'Cossé-en-Champagne',
	'FR53077' => 'Cossé-le-Vivien',
	'FR53078' => 'Coudray',
	'FR53079' => 'Couesmes-Vaucé',
	'FR53080' => 'Couptrain',
	'FR53082' => 'Courbeveille',
	'FR53083' => 'Courcité',
	'FR53084' => 'Craon',
	'FR53085' => 'Crennes-sur-Fraubée',
	'FR53086' => 'La Croixille',
	'FR53087' => 'La Cropte',
	'FR53088' => 'Cuillé',
	'FR53089' => 'Daon',
	'FR53090' => 'Denazé',
	'FR53091' => 'Désertines',
	'FR53093' => 'La Dorée',
	'FR53094' => 'Entrammes',
	'FR53096' => 'Ernée',
	'FR53097' => 'Évron',
	'FR53098' => 'Fontaine-Couverte',
	'FR53099' => 'Forcé',
	'FR53100' => 'Fougerolles-du-Plessis',
	'FR53101' => 'Fromentières',
	'FR53102' => 'Gastines',
	'FR53103' => 'Le Genest-Saint-Isle',
	'FR53104' => 'Gennes-Longuefuye',
	'FR53105' => 'Gesnes',
	'FR53106' => 'Gesvres',
	'FR53107' => 'Gorron',
	'FR53108' => 'La Gravelle',
	'FR53109' => 'Grazay',
	'FR53110' => 'Grez-en-Bouère',
	'FR53111' => 'La Haie-Traversaine',
	'FR53112' => 'Le Ham',
	'FR53113' => 'Hambers',
	'FR53114' => 'Hardanges',
	'FR53115' => 'Hercé',
	'FR53116' => 'Le Horps',
	'FR53117' => 'Houssay',
	'FR53118' => 'Le Housseau-Brétignolles',
	'FR53119' => 'LHuisserie',
	'FR53120' => 'Izé',
	'FR53121' => 'Javron-les-Chapelles',
	'FR53122' => 'Jublains',
	'FR53123' => 'Juvigné',
	'FR53124' => 'Prée-dAnjou',
	'FR53125' => 'Landivy',
	'FR53126' => 'Larchamp',
	'FR53127' => 'Lassay-les-Châteaux',
	'FR53128' => 'Laubrières',
	'FR53129' => 'Launay-Villiers',
	'FR53130' => 'Laval',
	'FR53131' => 'Lesbois',
	'FR53132' => 'Levaré',
	'FR53133' => 'Lignières-Orgères',
	'FR53134' => 'Livet',
	'FR53135' => 'Livré-la-Touche',
	'FR53136' => 'La Roche-Neuville',
	'FR53137' => 'Loiron-Ruillé',
	'FR53139' => 'Loupfougères',
	'FR53140' => 'Louverné',
	'FR53141' => 'Louvigné',
	'FR53142' => 'Madré',
	'FR53143' => 'Maisoncelles-du-Maine',
	'FR53144' => 'Marcillé-la-Ville',
	'FR53145' => 'Marigné-Peuton',
	'FR53146' => 'Martigné-sur-Mayenne',
	'FR53147' => 'Mayenne',
	'FR53148' => 'Mée',
	'FR53150' => 'Ménil',
	'FR53151' => 'Méral',
	'FR53152' => 'Meslay-du-Maine',
	'FR53153' => 'Mézangers',
	'FR53154' => 'Montaudin',
	'FR53155' => 'Montenay',
	'FR53156' => 'Montflours',
	'FR53157' => 'Montigné-le-Brillant',
	'FR53158' => 'Montjean',
	'FR53160' => 'Montreuil-Poulay',
	'FR53161' => 'Montsûrs',
	'FR53162' => 'Moulay',
	'FR53163' => 'Neau',
	'FR53164' => 'Neuilly-le-Vendin',
	'FR53165' => 'Niafles',
	'FR53168' => 'Nuillé-sur-Vicoin',
	'FR53169' => 'Olivet',
	'FR53170' => 'Oisseau',
	'FR53172' => 'Origné',
	'FR53173' => 'La Pallu',
	'FR53174' => 'Parigné-sur-Braye',
	'FR53175' => 'Parné-sur-Roc',
	'FR53176' => 'Le Pas',
	'FR53177' => 'La Pellerine',
	'FR53178' => 'Peuton',
	'FR53179' => 'Placé',
	'FR53180' => 'Pommerieux',
	'FR53181' => 'Pontmain',
	'FR53182' => 'Port-Brillet',
	'FR53184' => 'Préaux',
	'FR53185' => 'Pré-en-Pail-Saint-Samson',
	'FR53186' => 'Quelaines-Saint-Gault',
	'FR53187' => 'Ravigny',
	'FR53188' => 'Renazé',
	'FR53189' => 'Rennes-en-Grenouilles',
	'FR53190' => 'Le Ribay',
	'FR53191' => 'La Roë',
	'FR53192' => 'La Rouaudière',
	'FR53193' => 'Ruillé-Froid-Fonds',
	'FR53195' => 'Sacé',
	'FR53196' => 'Saint-Aignan-de-Couptrain',
	'FR53197' => 'Saint-Aignan-sur-Roë',
	'FR53198' => 'Saint-Aubin-du-Désert',
	'FR53199' => 'Saint-Aubin-Fosse-Louvain',
	'FR53200' => 'Saint-Baudelle',
	'FR53201' => 'Saint-Berthevin',
	'FR53202' => 'Saint-Berthevin-la-Tannière',
	'FR53203' => 'Saint-Brice',
	'FR53204' => 'Saint-Calais-du-Désert',
	'FR53206' => 'Saint-Charles-la-Forêt',
	'FR53208' => 'Saint-Cyr-en-Pail',
	'FR53209' => 'Saint-Cyr-le-Gravelais',
	'FR53210' => 'Saint-Denis-dAnjou',
	'FR53211' => 'Saint-Denis-de-Gastines',
	'FR53212' => 'Saint-Denis-du-Maine',
	'FR53213' => 'Saint-Ellier-du-Maine',
	'FR53214' => 'Saint-Erblon',
	'FR53216' => 'Saint-Fraimbault-de-Prières',
	'FR53218' => 'Sainte-Gemmes-le-Robert',
	'FR53219' => 'Saint-Georges-Buttavent',
	'FR53220' => 'Saint-Georges-le-Fléchard',
	'FR53221' => 'Saint-Georges-sur-Erve',
	'FR53222' => 'Saint-Germain-dAnxure',
	'FR53223' => 'Saint-Germain-de-Coulamer',
	'FR53224' => 'Saint-Germain-le-Fouilloux',
	'FR53225' => 'Saint-Germain-le-Guillaume',
	'FR53226' => 'Saint-Hilaire-du-Maine',
	'FR53228' => 'Blandouet-Saint Jean',
	'FR53229' => 'Saint-Jean-sur-Mayenne',
	'FR53230' => 'Saint-Julien-du-Terroux',
	'FR53232' => 'Saint-Léger',
	'FR53233' => 'Saint-Loup-du-Dorat',
	'FR53234' => 'Saint-Loup-du-Gast',
	'FR53235' => 'Sainte-Marie-du-Bois',
	'FR53236' => 'Saint-Mars-du-Désert',
	'FR53237' => 'Saint-Mars-sur-Colmont',
	'FR53238' => 'Saint-Mars-sur-la-Futaie',
	'FR53239' => 'Saint-Martin-de-Connée',
	'FR53240' => 'Saint-Martin-du-Limet',
	'FR53242' => 'Saint-Michel-de-la-Roë',
	'FR53243' => 'Saint-Ouën-des-Toits',
	'FR53245' => 'Saint-Pierre-des-Landes',
	'FR53246' => 'Saint-Pierre-des-Nids',
	'FR53247' => 'Saint-Pierre-la-Cour',
	'FR53248' => 'Saint-Pierre-sur-Erve',
	'FR53249' => 'Saint-Pierre-sur-Orthe',
	'FR53250' => 'Saint-Poix',
	'FR53251' => 'Saint-Quentin-les-Anges',
	'FR53253' => 'Saint-Saturnin-du-Limet',
	'FR53255' => 'Sainte-Suzanne-et-Chammes',
	'FR53256' => 'Saint-Thomas-de-Courceriers',
	'FR53257' => 'Saulges',
	'FR53258' => 'La Selle-Craonnaise',
	'FR53259' => 'Senonnes',
	'FR53260' => 'Simplé',
	'FR53261' => 'Soucé',
	'FR53262' => 'Soulgé-sur-Ouette',
	'FR53263' => 'Thubœuf',
	'FR53264' => 'Thorigné-en-Charnie',
	'FR53265' => 'Torcé-Viviers-en-Charnie',
	'FR53266' => 'Trans',
	'FR53267' => 'Vaiges',
	'FR53269' => 'Vautorte',
	'FR53270' => 'Vieuvy',
	'FR53271' => 'Villaines-la-Juhel',
	'FR53272' => 'Villepail',
	'FR53273' => 'Villiers-Charlemagne',
	'FR53274' => 'Vimarcé',
	'FR53276' => 'Voutré',
	'FR54001' => 'Abaucourt',
	'FR54002' => 'Abbéville-lès-Conflans',
	'FR54003' => 'Aboncourt',
	'FR54004' => 'Affléville',
	'FR54005' => 'Affracourt',
	'FR54006' => 'Agincourt',
	'FR54007' => 'Aingeray',
	'FR54008' => 'Allain',
	'FR54009' => 'Allamont',
	'FR54010' => 'Allamps',
	'FR54011' => 'Allondrelle-la-Malmaison',
	'FR54012' => 'Amance',
	'FR54013' => 'Amenoncourt',
	'FR54014' => 'Ancerviller',
	'FR54015' => 'Anderny',
	'FR54016' => 'Andilly',
	'FR54017' => 'Angomont',
	'FR54018' => 'Anoux',
	'FR54019' => 'Ansauville',
	'FR54020' => 'Anthelupt',
	'FR54021' => 'Armaucourt',
	'FR54022' => 'Arnaville',
	'FR54023' => 'Arracourt',
	'FR54024' => 'Arraye-et-Han',
	'FR54025' => 'Art-sur-Meurthe',
	'FR54026' => 'Athienville',
	'FR54027' => 'Atton',
	'FR54028' => 'Auboué',
	'FR54029' => 'Audun-le-Roman',
	'FR54030' => 'Autrepierre',
	'FR54031' => 'Autreville-sur-Moselle',
	'FR54032' => 'Autrey',
	'FR54033' => 'Avillers',
	'FR54034' => 'Avrainville',
	'FR54035' => 'Avricourt',
	'FR54036' => 'Avril',
	'FR54037' => 'Azelot',
	'FR54038' => 'Azerailles',
	'FR54039' => 'Baccarat',
	'FR54040' => 'Badonviller',
	'FR54041' => 'Bagneux',
	'FR54042' => 'Bainville-aux-Miroirs',
	'FR54043' => 'Bainville-sur-Madon',
	'FR54044' => 'Barbas',
	'FR54045' => 'Barbonville',
	'FR54046' => 'Barisey-au-Plain',
	'FR54047' => 'Barisey-la-Côte',
	'FR54048' => 'Les Baroches',
	'FR54049' => 'Baslieux',
	'FR54050' => 'Bathelémont',
	'FR54051' => 'Batilly',
	'FR54052' => 'Battigny',
	'FR54053' => 'Bauzemont',
	'FR54054' => 'Bayon',
	'FR54055' => 'Bayonville-sur-Mad',
	'FR54056' => 'Bazailles',
	'FR54057' => 'Beaumont',
	'FR54058' => 'Béchamps',
	'FR54059' => 'Belleau',
	'FR54060' => 'Belleville',
	'FR54061' => 'Bénaménil',
	'FR54062' => 'Benney',
	'FR54063' => 'Bernécourt',
	'FR54064' => 'Bertrambois',
	'FR54065' => 'Bertrichamps',
	'FR54066' => 'Bettainvillers',
	'FR54067' => 'Beuveille',
	'FR54068' => 'Beuvezin',
	'FR54069' => 'Beuvillers',
	'FR54070' => 'Bey-sur-Seille',
	'FR54071' => 'Bezange-la-Grande',
	'FR54072' => 'Bezaumont',
	'FR54073' => 'Bicqueley',
	'FR54074' => 'Bienville-la-Petite',
	'FR54075' => 'Bionville',
	'FR54076' => 'Blainville-sur-lEau',
	'FR54077' => 'Blâmont',
	'FR54078' => 'Blémerey',
	'FR54079' => 'Blénod-lès-Pont-à-Mousson',
	'FR54080' => 'Blénod-lès-Toul',
	'FR54081' => 'Boismont',
	'FR54082' => 'Boncourt',
	'FR54083' => 'Bonviller',
	'FR54084' => 'Mont-Bonvillers',
	'FR54085' => 'Borville',
	'FR54086' => 'Boucq',
	'FR54087' => 'Bouillonville',
	'FR54088' => 'Bouvron',
	'FR54089' => 'Bouxières-aux-Chênes',
	'FR54090' => 'Bouxières-aux-Dames',
	'FR54091' => 'Bouxières-sous-Froidmont',
	'FR54092' => 'Bouzanville',
	'FR54093' => 'Brainville',
	'FR54094' => 'Bralleville',
	'FR54095' => 'Bratte',
	'FR54096' => 'Bréhain-la-Ville',
	'FR54097' => 'Bréménil',
	'FR54098' => 'Brémoncourt',
	'FR54099' => 'Val de Briey',
	'FR54100' => 'Brin-sur-Seille',
	'FR54101' => 'Brouville',
	'FR54102' => 'Bruley',
	'FR54103' => 'Bruville',
	'FR54104' => 'Buissoncourt',
	'FR54105' => 'Bulligny',
	'FR54106' => 'Bures',
	'FR54107' => 'Buriville',
	'FR54108' => 'Burthecourt-aux-Chênes',
	'FR54109' => 'Ceintrey',
	'FR54110' => 'Cerville',
	'FR54111' => 'Chaligny',
	'FR54112' => 'Chambley-Bussières',
	'FR54113' => 'Champenoux',
	'FR54114' => 'Champey-sur-Moselle',
	'FR54115' => 'Champigneulles',
	'FR54116' => 'Chanteheux',
	'FR54117' => 'Chaouilley',
	'FR54118' => 'Charency-Vezin',
	'FR54119' => 'Charey',
	'FR54120' => 'Charmes-la-Côte',
	'FR54121' => 'Charmois',
	'FR54122' => 'Chaudeney-sur-Moselle',
	'FR54123' => 'Chavigny',
	'FR54124' => 'Chazelles-sur-Albe',
	'FR54125' => 'Chenevières',
	'FR54126' => 'Chenicourt',
	'FR54127' => 'Chenières',
	'FR54128' => 'Choloy-Ménillot',
	'FR54129' => 'Cirey-sur-Vezouze',
	'FR54130' => 'Clayeures',
	'FR54131' => 'Clémery',
	'FR54132' => 'Clérey-sur-Brenon',
	'FR54133' => 'Coincourt',
	'FR54134' => 'Colmey',
	'FR54135' => 'Colombey-les-Belles',
	'FR54136' => 'Conflans-en-Jarnisy',
	'FR54137' => 'Cons-la-Grandville',
	'FR54138' => 'Cosnes-et-Romain',
	'FR54139' => 'Courbesseaux',
	'FR54140' => 'Courcelles',
	'FR54141' => 'Coyviller',
	'FR54142' => 'Crantenoy',
	'FR54143' => 'Crépey',
	'FR54144' => 'Crévéchamps',
	'FR54145' => 'Crévic',
	'FR54146' => 'Crézilles',
	'FR54147' => 'Crion',
	'FR54148' => 'Croismare',
	'FR54149' => 'Crusnes',
	'FR54150' => 'Custines',
	'FR54151' => 'Cutry',
	'FR54152' => 'Damelevières',
	'FR54153' => 'Dampvitoux',
	'FR54154' => 'Deneuvre',
	'FR54155' => 'Deuxville',
	'FR54156' => 'Diarville',
	'FR54157' => 'Dieulouard',
	'FR54158' => 'Dolcourt',
	'FR54159' => 'Dombasle-sur-Meurthe',
	'FR54160' => 'Domèvre-en-Haye',
	'FR54161' => 'Domèvre-sur-Vezouze',
	'FR54162' => 'Domgermain',
	'FR54163' => 'Domjevin',
	'FR54164' => 'Dommarie-Eulmont',
	'FR54165' => 'Dommartemont',
	'FR54166' => 'Dommartin-la-Chaussée',
	'FR54167' => 'Dommartin-lès-Toul',
	'FR54168' => 'Dommartin-sous-Amance',
	'FR54169' => 'Domprix',
	'FR54170' => 'Domptail-en-lAir',
	'FR54171' => 'Doncourt-lès-Conflans',
	'FR54172' => 'Doncourt-lès-Longuyon',
	'FR54173' => 'Drouville',
	'FR54174' => 'Écrouves',
	'FR54175' => 'Einvaux',
	'FR54176' => 'Einville-au-Jard',
	'FR54177' => 'Emberménil',
	'FR54178' => 'Épiez-sur-Chiers',
	'FR54179' => 'Éply',
	'FR54180' => 'Erbéviller-sur-Amezule',
	'FR54181' => 'Errouville',
	'FR54182' => 'Essey-et-Maizerais',
	'FR54183' => 'Essey-la-Côte',
	'FR54184' => 'Essey-lès-Nancy',
	'FR54185' => 'Étreval',
	'FR54186' => 'Eulmont',
	'FR54187' => 'Euvezin',
	'FR54188' => 'Faulx',
	'FR54189' => 'Favières',
	'FR54190' => 'Fécocourt',
	'FR54191' => 'Fenneviller',
	'FR54192' => 'Ferrières',
	'FR54193' => 'Fey-en-Haye',
	'FR54194' => 'Fillières',
	'FR54195' => 'Flainval',
	'FR54196' => 'Flavigny-sur-Moselle',
	'FR54197' => 'Fléville-devant-Nancy',
	'FR54198' => 'Fléville-Lixières',
	'FR54199' => 'Flin',
	'FR54200' => 'Flirey',
	'FR54201' => 'Fontenoy-la-Joûte',
	'FR54202' => 'Fontenoy-sur-Moselle',
	'FR54203' => 'Forcelles-Saint-Gorgon',
	'FR54204' => 'Forcelles-sous-Gugney',
	'FR54205' => 'Foug',
	'FR54206' => 'Fraimbois',
	'FR54207' => 'Fraisnes-en-Saintois',
	'FR54208' => 'Francheville',
	'FR54209' => 'Franconville',
	'FR54210' => 'Fréménil',
	'FR54211' => 'Frémonville',
	'FR54212' => 'Fresnois-la-Montagne',
	'FR54213' => 'Friauville',
	'FR54214' => 'Frolois',
	'FR54215' => 'Frouard',
	'FR54216' => 'Froville',
	'FR54217' => 'Gélacourt',
	'FR54218' => 'Gélaucourt',
	'FR54219' => 'Gellenoncourt',
	'FR54220' => 'Gémonville',
	'FR54221' => 'Gerbécourt-et-Haplemont',
	'FR54222' => 'Gerbéviller',
	'FR54223' => 'Germiny',
	'FR54224' => 'Germonville',
	'FR54225' => 'Gézoncourt',
	'FR54226' => 'Gibeaumeix',
	'FR54227' => 'Giraumont',
	'FR54228' => 'Giriviller',
	'FR54229' => 'Glonville',
	'FR54230' => 'Gogney',
	'FR54231' => 'Gondrecourt-Aix',
	'FR54232' => 'Gondreville',
	'FR54233' => 'Gondrexon',
	'FR54234' => 'Gorcy',
	'FR54235' => 'Goviller',
	'FR54236' => 'Grand-Failly',
	'FR54237' => 'Grimonviller',
	'FR54238' => 'Gripport',
	'FR54239' => 'Griscourt',
	'FR54240' => 'Grosrouvres',
	'FR54241' => 'Gugney',
	'FR54242' => 'Gye',
	'FR54243' => 'Hablainville',
	'FR54244' => 'Hagéville',
	'FR54245' => 'Haigneville',
	'FR54246' => 'Halloville',
	'FR54247' => 'Hammeville',
	'FR54248' => 'Hamonville',
	'FR54249' => 'Hannonville-Suzémont',
	'FR54250' => 'Haraucourt',
	'FR54251' => 'Harbouey',
	'FR54252' => 'Haroué',
	'FR54253' => 'Hatrize',
	'FR54254' => 'Haucourt-Moulaine',
	'FR54255' => 'Haudonville',
	'FR54256' => 'Haussonville',
	'FR54257' => 'Heillecourt',
	'FR54258' => 'Hénaménil',
	'FR54259' => 'Herbéviller',
	'FR54260' => 'Hériménil',
	'FR54261' => 'Herserange',
	'FR54262' => 'Hoéville',
	'FR54263' => 'Homécourt',
	'FR54264' => 'Houdelmont',
	'FR54265' => 'Houdemont',
	'FR54266' => 'Houdreville',
	'FR54268' => 'Housséville',
	'FR54269' => 'Hudiviller',
	'FR54270' => 'Hussigny-Godbrange',
	'FR54271' => 'Igney',
	'FR54272' => 'Jaillon',
	'FR54273' => 'Jarny',
	'FR54274' => 'Jarville-la-Malgrange',
	'FR54275' => 'Jaulny',
	'FR54276' => 'Jeandelaincourt',
	'FR54277' => 'Jeandelize',
	'FR54278' => 'Jevoncourt',
	'FR54279' => 'Jezainville',
	'FR54280' => 'Jœuf',
	'FR54281' => 'Jolivet',
	'FR54282' => 'Joppécourt',
	'FR54283' => 'Jouaville',
	'FR54284' => 'Joudreville',
	'FR54285' => 'Juvrecourt',
	'FR54286' => 'Labry',
	'FR54287' => 'Lachapelle',
	'FR54288' => 'Lagney',
	'FR54289' => 'Laître-sous-Amance',
	'FR54290' => 'Laix',
	'FR54291' => 'Lalœuf',
	'FR54292' => 'Lamath',
	'FR54293' => 'Landécourt',
	'FR54294' => 'Landremont',
	'FR54295' => 'Landres',
	'FR54296' => 'Laneuvelotte',
	'FR54297' => 'Laneuveville-aux-Bois',
	'FR54298' => 'Laneuveville-derrière-Foug',
	'FR54299' => 'Laneuveville-devant-Bayon',
	'FR54300' => 'Laneuveville-devant-Nancy',
	'FR54301' => 'Lanfroicourt',
	'FR54302' => 'Lantéfontaine',
	'FR54303' => 'Laronxe',
	'FR54304' => 'Laxou',
	'FR54305' => 'Lay-Saint-Christophe',
	'FR54306' => 'Lay-Saint-Remy',
	'FR54307' => 'Lebeuville',
	'FR54308' => 'Leintrey',
	'FR54309' => 'Lemainville',
	'FR54310' => 'Leménil-Mitry',
	'FR54311' => 'Lenoncourt',
	'FR54312' => 'Lesménils',
	'FR54313' => 'Létricourt',
	'FR54314' => 'Lexy',
	'FR54315' => 'Leyr',
	'FR54316' => 'Limey-Remenauville',
	'FR54317' => 'Lironville',
	'FR54318' => 'Liverdun',
	'FR54320' => 'Loisy',
	'FR54321' => 'Longlaville',
	'FR54322' => 'Longuyon',
	'FR54323' => 'Longwy',
	'FR54324' => 'Lorey',
	'FR54325' => 'Loromontzey',
	'FR54326' => 'Lubey',
	'FR54327' => 'Lucey',
	'FR54328' => 'Ludres',
	'FR54329' => 'Lunéville',
	'FR54330' => 'Lupcourt',
	'FR54331' => 'Magnières',
	'FR54332' => 'Maidières',
	'FR54333' => 'Mailly-sur-Seille',
	'FR54334' => 'Mairy-Mainville',
	'FR54335' => 'Maixe',
	'FR54336' => 'Maizières',
	'FR54337' => 'Malavillers',
	'FR54338' => 'Malleloy',
	'FR54339' => 'Malzéville',
	'FR54340' => 'Mamey',
	'FR54343' => 'Mandres-aux-Quatre-Tours',
	'FR54344' => 'Mangonville',
	'FR54345' => 'Manoncourt-en-Vermois',
	'FR54346' => 'Manoncourt-en-Woëvre',
	'FR54348' => 'Manonville',
	'FR54349' => 'Manonviller',
	'FR54350' => 'Marainviller',
	'FR54351' => 'Marbache',
	'FR54352' => 'Maron',
	'FR54353' => 'Mars-la-Tour',
	'FR54354' => 'Marthemont',
	'FR54355' => 'Martincourt',
	'FR54356' => 'Mattexey',
	'FR54357' => 'Maxéville',
	'FR54358' => 'Mazerulles',
	'FR54359' => 'Méhoncourt',
	'FR54360' => 'Ménil-la-Tour',
	'FR54362' => 'Mercy-le-Bas',
	'FR54363' => 'Mercy-le-Haut',
	'FR54364' => 'Méréville',
	'FR54365' => 'Merviller',
	'FR54366' => 'Messein',
	'FR54367' => 'Mexy',
	'FR54368' => 'Mignéville',
	'FR54369' => 'Millery',
	'FR54370' => 'Minorville',
	'FR54371' => 'Moineville',
	'FR54372' => 'Moivrons',
	'FR54373' => 'Moncel-lès-Lunéville',
	'FR54374' => 'Moncel-sur-Seille',
	'FR54375' => 'Montauville',
	'FR54376' => 'Montenoy',
	'FR54377' => 'Montigny',
	'FR54378' => 'Montigny-sur-Chiers',
	'FR54379' => 'Mont-lÉtroit',
	'FR54380' => 'Mont-le-Vignoble',
	'FR54381' => 'Montreux',
	'FR54382' => 'Mont-Saint-Martin',
	'FR54383' => 'Mont-sur-Meurthe',
	'FR54385' => 'Morfontaine',
	'FR54386' => 'Moriviller',
	'FR54387' => 'Morville-sur-Seille',
	'FR54388' => 'Mouacourt',
	'FR54389' => 'Mouaville',
	'FR54390' => 'Mousson',
	'FR54391' => 'Moutiers',
	'FR54392' => 'Moutrot',
	'FR54393' => 'Moyen',
	'FR54394' => 'Murville',
	'FR54395' => 'Nancy',
	'FR54396' => 'Neufmaisons',
	'FR54397' => 'Neuves-Maisons',
	'FR54398' => 'Neuviller-lès-Badonviller',
	'FR54399' => 'Neuviller-sur-Moselle',
	'FR54400' => 'Nomeny',
	'FR54401' => 'Nonhigny',
	'FR54402' => 'Norroy-le-Sec',
	'FR54403' => 'Norroy-lès-Pont-à-Mousson',
	'FR54404' => 'Noviant-aux-Prés',
	'FR54405' => 'Ochey',
	'FR54406' => 'Ogéviller',
	'FR54407' => 'Ognéville',
	'FR54408' => 'Olley',
	'FR54409' => 'Omelmont',
	'FR54410' => 'Onville',
	'FR54411' => 'Ormes-et-Ville',
	'FR54412' => 'Othe',
	'FR54413' => 'Ozerailles',
	'FR54414' => 'Pagney-derrière-Barine',
	'FR54415' => 'Pagny-sur-Moselle',
	'FR54416' => 'Pannes',
	'FR54417' => 'Parey-Saint-Césaire',
	'FR54418' => 'Parroy',
	'FR54419' => 'Parux',
	'FR54420' => 'Petit-Failly',
	'FR54421' => 'Petitmont',
	'FR54422' => 'Pettonville',
	'FR54423' => 'Pexonne',
	'FR54424' => 'Phlin',
	'FR54425' => 'Piennes',
	'FR54426' => 'Pierre-la-Treiche',
	'FR54427' => 'Pierre-Percée',
	'FR54428' => 'Pierrepont',
	'FR54429' => 'Pierreville',
	'FR54430' => 'Pompey',
	'FR54431' => 'Pont-à-Mousson',
	'FR54432' => 'Pont-Saint-Vincent',
	'FR54433' => 'Port-sur-Seille',
	'FR54434' => 'Praye',
	'FR54435' => 'Prény',
	'FR54436' => 'Preutin-Higny',
	'FR54437' => 'Pulligny',
	'FR54438' => 'Pulney',
	'FR54439' => 'Pulnoy',
	'FR54440' => 'Puxe',
	'FR54441' => 'Puxieux',
	'FR54442' => 'Quevilloncourt',
	'FR54443' => 'Raon-lès-Leau',
	'FR54444' => 'Raucourt',
	'FR54445' => 'Raville-sur-Sânon',
	'FR54446' => 'Réchicourt-la-Petite',
	'FR54447' => 'Réclonville',
	'FR54449' => 'Rehainviller',
	'FR54450' => 'Reherrey',
	'FR54451' => 'Réhon',
	'FR54452' => 'Reillon',
	'FR54453' => 'Rembercourt-sur-Mad',
	'FR54455' => 'Remenoville',
	'FR54456' => 'Réméréville',
	'FR54457' => 'Remoncourt',
	'FR54458' => 'Repaix',
	'FR54459' => 'Richardménil',
	'FR54460' => 'Rogéville',
	'FR54461' => 'Romain',
	'FR54462' => 'Rosières-aux-Salines',
	'FR54463' => 'Rosières-en-Haye',
	'FR54464' => 'Rouves',
	'FR54465' => 'Roville-devant-Bayon',
	'FR54466' => 'Royaumeix',
	'FR54467' => 'Rozelieures',
	'FR54468' => 'Saffais',
	'FR54469' => 'Saint-Ail',
	'FR54470' => 'Saint-Baussant',
	'FR54471' => 'Saint-Boingt',
	'FR54472' => 'Saint-Clément',
	'FR54473' => 'Saint-Firmin',
	'FR54474' => 'Sainte-Geneviève',
	'FR54475' => 'Saint-Germain',
	'FR54476' => 'Saint-Jean-lès-Longuyon',
	'FR54477' => 'Saint-Julien-lès-Gorze',
	'FR54478' => 'Saint-Marcel',
	'FR54479' => 'Saint-Mard',
	'FR54480' => 'Saint-Martin',
	'FR54481' => 'Saint-Maurice-aux-Forges',
	'FR54482' => 'Saint-Max',
	'FR54483' => 'Saint-Nicolas-de-Port',
	'FR54484' => 'Sainte-Pôle',
	'FR54485' => 'Saint-Pancré',
	'FR54486' => 'Saint-Remimont',
	'FR54487' => 'Saint-Rémy-aux-Bois',
	'FR54488' => 'Saint-Sauveur',
	'FR54489' => 'Saint-Supplet',
	'FR54490' => 'Saizerais',
	'FR54491' => 'Sancy',
	'FR54492' => 'Sanzey',
	'FR54493' => 'Saulnes',
	'FR54494' => 'Saulxerotte',
	'FR54495' => 'Saulxures-lès-Nancy',
	'FR54496' => 'Saulxures-lès-Vannes',
	'FR54497' => 'Saxon-Sion',
	'FR54498' => 'Seichamps',
	'FR54499' => 'Seicheprey',
	'FR54500' => 'Selaincourt',
	'FR54501' => 'Seranville',
	'FR54502' => 'Serres',
	'FR54504' => 'Serrouville',
	'FR54505' => 'Sexey-aux-Forges',
	'FR54507' => 'Sionviller',
	'FR54508' => 'Sivry',
	'FR54509' => 'Sommerviller',
	'FR54510' => 'Sornéville',
	'FR54511' => 'Sponville',
	'FR54512' => 'Tanconville',
	'FR54513' => 'Tantonville',
	'FR54514' => 'Tellancourt',
	'FR54515' => 'Thélod',
	'FR54516' => 'They-sous-Vaudemont',
	'FR54517' => 'Thézey-Saint-Martin',
	'FR54518' => 'Thiaucourt-Regniéville',
	'FR54519' => 'Thiaville-sur-Meurthe',
	'FR54520' => 'Thiébauménil',
	'FR54521' => 'Thil',
	'FR54522' => 'Thorey-Lyautey',
	'FR54523' => 'Thuilley-aux-Groseilles',
	'FR54524' => 'Thumeréville',
	'FR54525' => 'Tiercelet',
	'FR54526' => 'Tomblaine',
	'FR54527' => 'Tonnoy',
	'FR54528' => 'Toul',
	'FR54529' => 'Tramont-Émy',
	'FR54530' => 'Tramont-Lassus',
	'FR54531' => 'Tramont-Saint-André',
	'FR54532' => 'Tremblecourt',
	'FR54533' => 'Trieux',
	'FR54534' => 'Trondes',
	'FR54535' => 'Tronville',
	'FR54536' => 'Tucquegnieux',
	'FR54537' => 'Ugny',
	'FR54538' => 'Uruffe',
	'FR54539' => 'Vacqueville',
	'FR54540' => 'Val-et-Châtillon',
	'FR54541' => 'Valhey',
	'FR54542' => 'Valleroy',
	'FR54543' => 'Vallois',
	'FR54544' => 'Vandelainville',
	'FR54545' => 'Vandeléville',
	'FR54546' => 'Vandières',
	'FR54547' => 'Vandœuvre-lès-Nancy',
	'FR54548' => 'Vannes-le-Châtel',
	'FR54549' => 'Varangéville',
	'FR54550' => 'Vathiménil',
	'FR54551' => 'Vaucourt',
	'FR54552' => 'Vaudémont',
	'FR54553' => 'Vaudeville',
	'FR54554' => 'Vaudigny',
	'FR54555' => 'Vaxainville',
	'FR54556' => 'Vého',
	'FR54557' => 'Bois-de-Haye',
	'FR54558' => 'Velaine-sous-Amance',
	'FR54559' => 'Velle-sur-Moselle',
	'FR54560' => 'Veney',
	'FR54561' => 'Vennezey',
	'FR54562' => 'Verdenal',
	'FR54563' => 'Vézelise',
	'FR54564' => 'Viéville-en-Haye',
	'FR54565' => 'Vigneulles',
	'FR54566' => 'Vilcey-sur-Trey',
	'FR54567' => 'Villacourt',
	'FR54568' => 'Ville-au-Montois',
	'FR54569' => 'Ville-au-Val',
	'FR54570' => 'Villecey-sur-Mad',
	'FR54571' => 'Ville-en-Vermois',
	'FR54572' => 'Ville-Houdlémont',
	'FR54573' => 'Villers-en-Haye',
	'FR54574' => 'Villers-la-Chèvre',
	'FR54575' => 'Villers-la-Montagne',
	'FR54576' => 'Villers-le-Rond',
	'FR54577' => 'Villers-lès-Moivrons',
	'FR54578' => 'Villers-lès-Nancy',
	'FR54579' => 'Villers-sous-Prény',
	'FR54580' => 'Villerupt',
	'FR54581' => 'Ville-sur-Yron',
	'FR54582' => 'Villette',
	'FR54583' => 'Villey-le-Sec',
	'FR54584' => 'Villey-Saint-Étienne',
	'FR54585' => 'Virecourt',
	'FR54586' => 'Viterne',
	'FR54587' => 'Vitrey',
	'FR54588' => 'Vitrimont',
	'FR54589' => 'Vittonville',
	'FR54590' => 'Viviers-sur-Chiers',
	'FR54591' => 'Voinémont',
	'FR54592' => 'Vroncourt',
	'FR54593' => 'Waville',
	'FR54594' => 'Xammes',
	'FR54595' => 'Xermaménil',
	'FR54596' => 'Xeuilley',
	'FR54597' => 'Xirocourt',
	'FR54598' => 'Xivry-Circourt',
	'FR54599' => 'Xonville',
	'FR54600' => 'Xousse',
	'FR54601' => 'Xures',
	'FR54602' => 'Han-devant-Pierrepont',
	'FR55001' => 'Abainville',
	'FR55002' => 'Abaucourt-Hautecourt',
	'FR55004' => 'Aincreville',
	'FR55005' => 'Amanty',
	'FR55007' => 'Ambly-sur-Meuse',
	'FR55008' => 'Amel-sur-lÉtang',
	'FR55009' => 'Ancemont',
	'FR55010' => 'Ancerville',
	'FR55011' => 'Andernay',
	'FR55012' => 'Apremont-la-Forêt',
	'FR55013' => 'Arrancy-sur-Crusne',
	'FR55014' => 'Aubréville',
	'FR55015' => 'Aulnois-en-Perthois',
	'FR55017' => 'Autrécourt-sur-Aire',
	'FR55018' => 'Autréville-Saint-Lambert',
	'FR55021' => 'Avillers-Sainte-Croix',
	'FR55022' => 'Avioth',
	'FR55023' => 'Avocourt',
	'FR55024' => 'Azannes-et-Soumazannes',
	'FR55025' => 'Baâlon',
	'FR55026' => 'Badonvilliers-Gérauvilliers',
	'FR55027' => 'Bannoncourt',
	'FR55028' => 'Bantheville',
	'FR55029' => 'Bar-le-Duc',
	'FR55031' => 'Baudonvilliers',
	'FR55032' => 'Baudrémont',
	'FR55033' => 'Baulny',
	'FR55034' => 'Bazeilles-sur-Othain',
	'FR55035' => 'Bazincourt-sur-Saulx',
	'FR55036' => 'Beauclair',
	'FR55037' => 'Beaufort-en-Argonne',
	'FR55038' => 'Beaulieu-en-Argonne',
	'FR55039' => 'Beaumont-en-Verdunois',
	'FR55040' => 'Beausite',
	'FR55041' => 'Behonne',
	'FR55042' => 'Belleray',
	'FR55043' => 'Belleville-sur-Meuse',
	'FR55044' => 'Belrain',
	'FR55045' => 'Belrupt-en-Verdunois',
	'FR55046' => 'Beney-en-Woëvre',
	'FR55047' => 'Béthelainville',
	'FR55048' => 'Béthincourt',
	'FR55049' => 'Beurey-sur-Saulx',
	'FR55050' => 'Bezonvaux',
	'FR55051' => 'Biencourt-sur-Orge',
	'FR55053' => 'Billy-sous-Mangiennes',
	'FR55054' => 'Bislée',
	'FR55055' => 'Blanzée',
	'FR55057' => 'Boinville-en-Woëvre',
	'FR55058' => 'Boncourt-sur-Meuse',
	'FR55059' => 'Bonnet',
	'FR55060' => 'Bonzée',
	'FR55061' => 'Le Bouchon-sur-Saulx',
	'FR55062' => 'Bouconville-sur-Madt',
	'FR55063' => 'Bouligny',
	'FR55064' => 'Bouquemont',
	'FR55065' => 'Boureuilles',
	'FR55066' => 'Bovée-sur-Barboure',
	'FR55067' => 'Boviolles',
	'FR55068' => 'Brabant-en-Argonne',
	'FR55069' => 'Brabant-le-Roi',
	'FR55070' => 'Brabant-sur-Meuse',
	'FR55071' => 'Brandeville',
	'FR55072' => 'Braquis',
	'FR55073' => 'Bras-sur-Meuse',
	'FR55075' => 'Brauvilliers',
	'FR55076' => 'Bréhéville',
	'FR55077' => 'Breux',
	'FR55078' => 'Brieulles-sur-Meuse',
	'FR55079' => 'Brillon-en-Barrois',
	'FR55080' => 'Brixey-aux-Chanoines',
	'FR55081' => 'Brizeaux',
	'FR55082' => 'Brocourt-en-Argonne',
	'FR55083' => 'Brouennes',
	'FR55084' => 'Broussey-en-Blois',
	'FR55085' => 'Broussey-Raulecourt',
	'FR55087' => 'Bure',
	'FR55088' => 'Burey-en-Vaux',
	'FR55089' => 'Burey-la-Côte',
	'FR55093' => 'Buxières-sous-les-Côtes',
	'FR55094' => 'Buzy-Darmont',
	'FR55095' => 'Cesse',
	'FR55096' => 'Chaillon',
	'FR55097' => 'Chalaines',
	'FR55099' => 'Champneuville',
	'FR55100' => 'Champougny',
	'FR55101' => 'Chardogne',
	'FR55102' => 'Charny-sur-Meuse',
	'FR55103' => 'Charpentry',
	'FR55104' => 'Chassey-Beaupré',
	'FR55105' => 'Châtillon-sous-les-Côtes',
	'FR55106' => 'Chattancourt',
	'FR55107' => 'Chaumont-devant-Damvillers',
	'FR55108' => 'Chaumont-sur-Aire',
	'FR55109' => 'Chauvency-le-Château',
	'FR55110' => 'Chauvency-Saint-Hubert',
	'FR55111' => 'Chauvoncourt',
	'FR55113' => 'Cheppy',
	'FR55114' => 'Chonville-Malaumont',
	'FR55115' => 'Cierges-sous-Montfaucon',
	'FR55116' => 'Le Claon',
	'FR55117' => 'Clermont-en-Argonne',
	'FR55118' => 'Cléry-le-Grand',
	'FR55119' => 'Cléry-le-Petit',
	'FR55120' => 'Combles-en-Barrois',
	'FR55121' => 'Combres-sous-les-Côtes',
	'FR55122' => 'Commercy',
	'FR55123' => 'Les Hauts-de-Chée',
	'FR55124' => 'Consenvoye',
	'FR55125' => 'Contrisson',
	'FR55127' => 'Courcelles-en-Barrois',
	'FR55128' => 'Courcelles-sur-Aire',
	'FR55129' => 'Courouvre',
	'FR55132' => 'Cousances-les-Forges',
	'FR55133' => 'Couvertpuis',
	'FR55134' => 'Couvonges',
	'FR55137' => 'Cuisy',
	'FR55138' => 'Culey',
	'FR55139' => 'Cumières-le-Mort-Homme',
	'FR55140' => 'Cunel',
	'FR55141' => 'Dagonville',
	'FR55142' => 'Dainville-Bertheléville',
	'FR55143' => 'Damloup',
	'FR55144' => 'Dammarie-sur-Saulx',
	'FR55145' => 'Damvillers',
	'FR55146' => 'Dannevoux',
	'FR55148' => 'Delouze-Rosières',
	'FR55149' => 'Delut',
	'FR55150' => 'Demange-Baudignécourt',
	'FR55153' => 'Dieppe-sous-Douaumont',
	'FR55154' => 'Dieue-sur-Meuse',
	'FR55155' => 'Dombasle-en-Argonne',
	'FR55156' => 'Dombras',
	'FR55157' => 'Dommartin-la-Montagne',
	'FR55158' => 'Dommary-Baroncourt',
	'FR55159' => 'Dompcevrin',
	'FR55160' => 'Dompierre-aux-Bois',
	'FR55162' => 'Domremy-la-Canne',
	'FR55163' => 'Doncourt-aux-Templiers',
	'FR55165' => 'Doulcon',
	'FR55166' => 'Dugny-sur-Meuse',
	'FR55167' => 'Dun-sur-Meuse',
	'FR55168' => 'Duzey',
	'FR55169' => 'Écouviez',
	'FR55170' => 'Écurey-en-Verdunois',
	'FR55171' => 'Eix',
	'FR55172' => 'Les Éparges',
	'FR55173' => 'Épiez-sur-Meuse',
	'FR55174' => 'Épinonville',
	'FR55175' => 'Érize-la-Brûlée',
	'FR55177' => 'Érize-la-Petite',
	'FR55178' => 'Érize-Saint-Dizier',
	'FR55179' => 'Erneville-aux-Bois',
	'FR55180' => 'Esnes-en-Argonne',
	'FR55181' => 'Étain',
	'FR55182' => 'Éton',
	'FR55183' => 'Étraye',
	'FR55184' => 'Euville',
	'FR55185' => 'Èvres',
	'FR55186' => 'Fains-Véel',
	'FR55188' => 'Flassigny',
	'FR55189' => 'Fleury-devant-Douaumont',
	'FR55191' => 'Foameix-Ornel',
	'FR55192' => 'Fontaines-Saint-Clair',
	'FR55193' => 'Forges-sur-Meuse',
	'FR55194' => 'Foucaucourt-sur-Thabas',
	'FR55195' => 'Fouchères-aux-Bois',
	'FR55196' => 'Frémeréville-sous-les-Côtes',
	'FR55197' => 'Fresnes-au-Mont',
	'FR55198' => 'Fresnes-en-Woëvre',
	'FR55199' => 'Froidos',
	'FR55200' => 'Fromeréville-les-Vallons',
	'FR55201' => 'Fromezey',
	'FR55202' => 'Futeau',
	'FR55204' => 'Génicourt-sur-Meuse',
	'FR55206' => 'Gercourt-et-Drillancourt',
	'FR55207' => 'Géry',
	'FR55208' => 'Gesnes-en-Argonne',
	'FR55210' => 'Gimécourt',
	'FR55211' => 'Gincrey',
	'FR55212' => 'Girauvoisin',
	'FR55214' => 'Givrauval',
	'FR55215' => 'Gondrecourt-le-Château',
	'FR55216' => 'Gouraincourt',
	'FR55217' => 'Goussaincourt',
	'FR55218' => 'Gremilly',
	'FR55219' => 'Grimaucourt-en-Woëvre',
	'FR55220' => 'Grimaucourt-près-Sampigny',
	'FR55221' => 'Guerpont',
	'FR55222' => 'Gussainville',
	'FR55224' => 'Haironville',
	'FR55225' => 'Halles-sous-les-Côtes',
	'FR55226' => 'Han-lès-Juvigny',
	'FR55228' => 'Hannonville-sous-les-Côtes',
	'FR55229' => 'Han-sur-Meuse',
	'FR55232' => 'Harville',
	'FR55236' => 'Haudainville',
	'FR55237' => 'Haudiomont',
	'FR55239' => 'Haumont-près-Samogneux',
	'FR55241' => 'Heippes',
	'FR55242' => 'Hennemont',
	'FR55243' => 'Herbeuville',
	'FR55244' => 'Herméville-en-Woëvre',
	'FR55245' => 'Heudicourt-sous-les-Côtes',
	'FR55246' => 'Hévilliers',
	'FR55247' => 'Horville-en-Ornois',
	'FR55248' => 'Houdelaincourt',
	'FR55250' => 'Inor',
	'FR55251' => 'Ippécourt',
	'FR55252' => 'Iré-le-Sec',
	'FR55253' => 'Les Islettes',
	'FR55254' => 'Les Trois-Domaines',
	'FR55255' => 'Jametz',
	'FR55256' => 'Jonville-en-Woëvre',
	'FR55257' => 'Jouy-en-Argonne',
	'FR55258' => 'Geville',
	'FR55260' => 'Julvécourt',
	'FR55261' => 'Juvigny-en-Perthois',
	'FR55262' => 'Juvigny-sur-Loison',
	'FR55263' => 'Kœur-la-Grande',
	'FR55264' => 'Kœur-la-Petite',
	'FR55265' => 'Labeuville',
	'FR55266' => 'Lachalade',
	'FR55267' => 'Lachaussée',
	'FR55268' => 'Lacroix-sur-Meuse',
	'FR55269' => 'Lahaymeix',
	'FR55270' => 'Lahayville',
	'FR55271' => 'Laheycourt',
	'FR55272' => 'Laimont',
	'FR55274' => 'Lamorville',
	'FR55275' => 'Lamouilly',
	'FR55276' => 'Landrecourt-Lempire',
	'FR55278' => 'Laneuville-au-Rupt',
	'FR55279' => 'Laneuville-sur-Meuse',
	'FR55280' => 'Lanhères',
	'FR55281' => 'Latour-en-Woëvre',
	'FR55282' => 'Lavallée',
	'FR55284' => 'Lavincourt',
	'FR55285' => 'Lavoye',
	'FR55286' => 'Lemmes',
	'FR55288' => 'Lérouville',
	'FR55289' => 'Levoncourt',
	'FR55290' => 'Lignières-sur-Aire',
	'FR55291' => 'Ligny-en-Barrois',
	'FR55292' => 'Liny-devant-Dun',
	'FR55293' => 'Lion-devant-Dun',
	'FR55295' => 'Lisle-en-Barrois',
	'FR55296' => 'LIsle-en-Rigault',
	'FR55297' => 'Lissey',
	'FR55298' => 'Loisey',
	'FR55299' => 'Loison',
	'FR55300' => 'Longeaux',
	'FR55301' => 'Longchamps-sur-Aire',
	'FR55302' => 'Longeville-en-Barrois',
	'FR55303' => 'Loupmont',
	'FR55304' => 'Louppy-le-Château',
	'FR55306' => 'Louppy-sur-Loison',
	'FR55307' => 'Louvemont-Côte-du-Poivre',
	'FR55310' => 'Luzy-Saint-Martin',
	'FR55311' => 'Maizeray',
	'FR55312' => 'Maizey',
	'FR55313' => 'Malancourt',
	'FR55315' => 'Mandres-en-Barrois',
	'FR55316' => 'Mangiennes',
	'FR55317' => 'Manheulles',
	'FR55320' => 'Marchéville-en-Woëvre',
	'FR55321' => 'Marre',
	'FR55322' => 'Marson-sur-Barboure',
	'FR55323' => 'Martincourt-sur-Meuse',
	'FR55324' => 'Marville',
	'FR55325' => 'Maucourt-sur-Orne',
	'FR55326' => 'Maulan',
	'FR55327' => 'Mauvages',
	'FR55328' => 'Maxey-sur-Vaise',
	'FR55329' => 'Mécrin',
	'FR55330' => 'Méligny-le-Grand',
	'FR55331' => 'Méligny-le-Petit',
	'FR55332' => 'Menaucourt',
	'FR55333' => 'Ménil-aux-Bois',
	'FR55334' => 'Ménil-la-Horgne',
	'FR55335' => 'Ménil-sur-Saulx',
	'FR55336' => 'Merles-sur-Loison',
	'FR55338' => 'Milly-sur-Bradon',
	'FR55339' => 'Mogeville',
	'FR55340' => 'Mognéville',
	'FR55341' => 'Moirey-Flabas-Crépion',
	'FR55343' => 'Montblainville',
	'FR55344' => 'Montbras',
	'FR55345' => 'Mont-devant-Sassey',
	'FR55346' => 'Montfaucon-dArgonne',
	'FR55347' => 'Les Monthairons',
	'FR55348' => 'Montiers-sur-Saulx',
	'FR55349' => 'Montigny-devant-Sassey',
	'FR55350' => 'Montigny-lès-Vaucouleurs',
	'FR55351' => 'Montmédy',
	'FR55352' => 'Montplonne',
	'FR55353' => 'Montsec',
	'FR55355' => 'Montzéville',
	'FR55356' => 'Moranville',
	'FR55357' => 'Morgemoulin',
	'FR55358' => 'Chanteraine',
	'FR55359' => 'Morley',
	'FR55360' => 'Mouilly',
	'FR55361' => 'Moulainville',
	'FR55362' => 'Moulins-Saint-Hubert',
	'FR55363' => 'Moulotte',
	'FR55364' => 'Mouzay',
	'FR55365' => 'Murvaux',
	'FR55366' => 'Val-dOrnain',
	'FR55367' => 'Muzeray',
	'FR55368' => 'Naives-en-Blois',
	'FR55369' => 'Naives-Rosières',
	'FR55370' => 'Naix-aux-Forges',
	'FR55371' => 'Nançois-le-Grand',
	'FR55372' => 'Nançois-sur-Ornain',
	'FR55373' => 'Nant-le-Grand',
	'FR55374' => 'Nant-le-Petit',
	'FR55375' => 'Nantillois',
	'FR55376' => 'Nantois',
	'FR55377' => 'Nepvant',
	'FR55378' => 'Nettancourt',
	'FR55379' => 'Le Neufour',
	'FR55380' => 'Neuville-en-Verdunois',
	'FR55381' => 'Neuville-lès-Vaucouleurs',
	'FR55382' => 'Neuville-sur-Ornain',
	'FR55383' => 'Neuvilly-en-Argonne',
	'FR55384' => 'Nicey-sur-Aire',
	'FR55385' => 'Nixéville-Blercourt',
	'FR55386' => 'Nonsard-Lamarche',
	'FR55387' => 'Nouillonpont',
	'FR55388' => 'Noyers-Auzécourt',
	'FR55389' => 'Nubécourt',
	'FR55391' => 'Olizy-sur-Chiers',
	'FR55394' => 'Ornes',
	'FR55395' => 'Osches',
	'FR55396' => 'Ourches-sur-Meuse',
	'FR55397' => 'Pagny-la-Blanche-Côte',
	'FR55398' => 'Pagny-sur-Meuse',
	'FR55399' => 'Pareid',
	'FR55400' => 'Parfondrupt',
	'FR55401' => 'Les Paroches',
	'FR55403' => 'Peuvillers',
	'FR55404' => 'Pierrefitte-sur-Aire',
	'FR55405' => 'Pillon',
	'FR55406' => 'Pintheville',
	'FR55407' => 'Pont-sur-Meuse',
	'FR55408' => 'Pouilly-sur-Meuse',
	'FR55409' => 'Pretz-en-Argonne',
	'FR55410' => 'Quincy-Landzécourt',
	'FR55411' => 'Rambluzin-et-Benoite-Vaux',
	'FR55412' => 'Rambucourt',
	'FR55414' => 'Rancourt-sur-Ornain',
	'FR55415' => 'Ranzières',
	'FR55416' => 'Rarécourt',
	'FR55419' => 'Récicourt',
	'FR55420' => 'Récourt-le-Creux',
	'FR55421' => 'Reffroy',
	'FR55422' => 'Regnéville-sur-Meuse',
	'FR55423' => 'Rembercourt-Sommaisne',
	'FR55424' => 'Remennecourt',
	'FR55425' => 'Remoiville',
	'FR55426' => 'Resson',
	'FR55427' => 'Revigny-sur-Ornain',
	'FR55428' => 'Réville-aux-Bois',
	'FR55429' => 'Riaville',
	'FR55430' => 'Ribeaucourt',
	'FR55431' => 'Richecourt',
	'FR55433' => 'Rigny-la-Salle',
	'FR55434' => 'Rigny-Saint-Martin',
	'FR55435' => 'Robert-Espagne',
	'FR55436' => 'Les Roises',
	'FR55437' => 'Romagne-sous-les-Côtes',
	'FR55438' => 'Romagne-sous-Montfaucon',
	'FR55439' => 'Ronvaux',
	'FR55442' => 'Raival',
	'FR55443' => 'Rouvres-en-Woëvre',
	'FR55444' => 'Rouvrois-sur-Meuse',
	'FR55445' => 'Rouvrois-sur-Othain',
	'FR55446' => 'Rumont',
	'FR55447' => 'Rupt-aux-Nonains',
	'FR55448' => 'Rupt-devant-Saint-Mihiel',
	'FR55449' => 'Rupt-en-Woëvre',
	'FR55450' => 'Rupt-sur-Othain',
	'FR55452' => 'Saint-Amand-sur-Ornain',
	'FR55453' => 'Saint-André-en-Barrois',
	'FR55454' => 'Saint-Aubin-sur-Aire',
	'FR55456' => 'Saint-Germain-sur-Meuse',
	'FR55457' => 'Saint-Hilaire-en-Woëvre',
	'FR55458' => 'Saint-Jean-lès-Buzy',
	'FR55459' => 'Saint-Joire',
	'FR55460' => 'Saint-Julien-sous-les-Côtes',
	'FR55461' => 'Saint-Laurent-sur-Othain',
	'FR55462' => 'Saint-Maurice-sous-les-Côtes',
	'FR55463' => 'Saint-Mihiel',
	'FR55464' => 'Saint-Pierrevillers',
	'FR55465' => 'Saint-Remy-la-Calonne',
	'FR55466' => 'Salmagne',
	'FR55467' => 'Sampigny',
	'FR55468' => 'Samogneux',
	'FR55469' => 'Sassey-sur-Meuse',
	'FR55470' => 'Saudrupt',
	'FR55471' => 'Saulmory-Villefranche',
	'FR55472' => 'Saulvaux',
	'FR55473' => 'Saulx-lès-Champlon',
	'FR55474' => 'Sauvigny',
	'FR55475' => 'Sauvoy',
	'FR55476' => 'Savonnières-devant-Bar',
	'FR55477' => 'Savonnières-en-Perthois',
	'FR55479' => 'Seigneulles',
	'FR55481' => 'Senon',
	'FR55482' => 'Senoncourt-les-Maujouy',
	'FR55484' => 'Septsarges',
	'FR55485' => 'Sepvigny',
	'FR55487' => 'Seuzey',
	'FR55488' => 'Silmont',
	'FR55489' => 'Sivry-la-Perche',
	'FR55490' => 'Sivry-sur-Meuse',
	'FR55492' => 'Sommedieue',
	'FR55493' => 'Sommeilles',
	'FR55494' => 'Sommelonne',
	'FR55495' => 'Sorbey',
	'FR55496' => 'Sorcy-Saint-Martin',
	'FR55497' => 'Les Souhesmes-Rampont',
	'FR55498' => 'Souilly',
	'FR55500' => 'Spincourt',
	'FR55501' => 'Stainville',
	'FR55502' => 'Stenay',
	'FR55503' => 'Taillancourt',
	'FR55504' => 'Tannois',
	'FR55505' => 'Thierville-sur-Meuse',
	'FR55506' => 'Thillombois',
	'FR55507' => 'Thillot',
	'FR55508' => 'Thonne-la-Long',
	'FR55509' => 'Thonne-le-Thil',
	'FR55510' => 'Thonne-les-Près',
	'FR55511' => 'Thonnelle',
	'FR55512' => 'Tilly-sur-Meuse',
	'FR55514' => 'Trémont-sur-Saulx',
	'FR55515' => 'Trésauvaux',
	'FR55516' => 'Tréveray',
	'FR55517' => 'Seuil-dArgonne',
	'FR55518' => 'Cousances-lès-Triconville',
	'FR55519' => 'Tronville-en-Barrois',
	'FR55520' => 'Troussey',
	'FR55521' => 'Troyon',
	'FR55522' => 'Ugny-sur-Meuse',
	'FR55523' => 'Vacherauville',
	'FR55525' => 'Vadelaincourt',
	'FR55526' => 'Vadonville',
	'FR55527' => 'Varennes-en-Argonne',
	'FR55528' => 'Varnéville',
	'FR55530' => 'Valbois',
	'FR55531' => 'Vassincourt',
	'FR55532' => 'Vaubecourt',
	'FR55533' => 'Vaucouleurs',
	'FR55534' => 'Vaudeville-le-Haut',
	'FR55535' => 'Vaudoncourt',
	'FR55536' => 'Vauquois',
	'FR55537' => 'Douaumont-Vaux',
	'FR55540' => 'Vaux-lès-Palameix',
	'FR55541' => 'Vavincourt',
	'FR55543' => 'Velaines',
	'FR55544' => 'Velosnes',
	'FR55545' => 'Verdun',
	'FR55546' => 'Verneuil-Grand',
	'FR55547' => 'Verneuil-Petit',
	'FR55549' => 'Véry',
	'FR55551' => 'Vigneulles-lès-Hattonchâtel',
	'FR55552' => 'Vigneul-sous-Montmédy',
	'FR55553' => 'Vignot',
	'FR55554' => 'Villécloye',
	'FR55555' => 'Ville-devant-Belrain',
	'FR55556' => 'Ville-devant-Chaumont',
	'FR55557' => 'Ville-en-Woëvre',
	'FR55559' => 'Villeroy-sur-Méholle',
	'FR55560' => 'Villers-aux-Vents',
	'FR55561' => 'Villers-devant-Dun',
	'FR55562' => 'Villers-le-Sec',
	'FR55563' => 'Villers-lès-Mangiennes',
	'FR55565' => 'Villers-sous-Pareid',
	'FR55566' => 'Villers-sur-Meuse',
	'FR55567' => 'Ville-sur-Cousances',
	'FR55568' => 'Ville-sur-Saulx',
	'FR55569' => 'Villotte-devant-Louppy',
	'FR55570' => 'Villotte-sur-Aire',
	'FR55571' => 'Vilosnes-Haraumont',
	'FR55572' => 'Vittarville',
	'FR55573' => 'Void-Vacon',
	'FR55574' => 'Vouthon-Bas',
	'FR55575' => 'Vouthon-Haut',
	'FR55577' => 'Waly',
	'FR55578' => 'Warcq',
	'FR55579' => 'Watronville',
	'FR55580' => 'Wavrille',
	'FR55581' => 'Willeroncourt',
	'FR55582' => 'Wiseppe',
	'FR55583' => 'Woël',
	'FR55584' => 'Woimbey',
	'FR55586' => 'Xivray-et-Marvoisin',
	'FR56001' => 'Allaire',
	'FR56002' => 'Ambon',
	'FR56003' => 'Arradon',
	'FR56004' => 'Arzal',
	'FR56005' => 'Arzon',
	'FR56006' => 'Augan',
	'FR56007' => 'Auray',
	'FR56008' => 'Baden',
	'FR56009' => 'Bangor',
	'FR56010' => 'Baud',
	'FR56011' => 'Béganne',
	'FR56012' => 'Beignon',
	'FR56013' => 'Belz',
	'FR56014' => 'Berné',
	'FR56015' => 'Berric',
	'FR56017' => 'Bignan',
	'FR56018' => 'Billiers',
	'FR56019' => 'Billio',
	'FR56020' => 'Bohal',
	'FR56021' => 'Brandérion',
	'FR56022' => 'Brandivy',
	'FR56023' => 'Brech',
	'FR56024' => 'Bréhan',
	'FR56025' => 'Brignac',
	'FR56026' => 'Bubry',
	'FR56027' => 'Buléon',
	'FR56028' => 'Caden',
	'FR56029' => 'Calan',
	'FR56030' => 'Camoël',
	'FR56031' => 'Camors',
	'FR56032' => 'Campénéac',
	'FR56033' => 'Carentoir',
	'FR56034' => 'Carnac',
	'FR56035' => 'Caro',
	'FR56036' => 'Caudan',
	'FR56039' => 'La Chapelle-Neuve',
	'FR56040' => 'Cléguer',
	'FR56041' => 'Cléguérec',
	'FR56042' => 'Colpo',
	'FR56043' => 'Concoret',
	'FR56044' => 'Cournon',
	'FR56045' => 'Le Cours',
	'FR56046' => 'Crach',
	'FR56047' => 'Crédin',
	'FR56048' => 'Le Croisty',
	'FR56049' => 'Croixanvec',
	'FR56050' => 'La Croix-Helléan',
	'FR56051' => 'Cruguel',
	'FR56052' => 'Damgan',
	'FR56053' => 'Elven',
	'FR56054' => 'Erdeven',
	'FR56055' => 'Étel',
	'FR56056' => 'Évriguet',
	'FR56057' => 'Le Faouët',
	'FR56058' => 'Férel',
	'FR56060' => 'Les Fougerêts',
	'FR56061' => 'La Gacilly',
	'FR56062' => 'Gâvres',
	'FR56063' => 'Gestel',
	'FR56065' => 'Gourhel',
	'FR56066' => 'Gourin',
	'FR56067' => 'Grand-Champ',
	'FR56068' => 'La Grée-Saint-Laurent',
	'FR56069' => 'Groix',
	'FR56070' => 'Guégon',
	'FR56071' => 'Guéhenno',
	'FR56072' => 'Gueltas',
	'FR56073' => 'Guémené-sur-Scorff',
	'FR56074' => 'Guénin',
	'FR56075' => 'Guer',
	'FR56076' => 'Guern',
	'FR56077' => 'Le Guerno',
	'FR56078' => 'Guidel',
	'FR56079' => 'Guillac',
	'FR56080' => 'Guilliers',
	'FR56081' => 'Guiscriff',
	'FR56082' => 'Helléan',
	'FR56083' => 'Hennebont',
	'FR56084' => 'Le Hézo',
	'FR56085' => 'Hœdic',
	'FR56086' => 'Île-dHouat',
	'FR56087' => 'Île-aux-Moines',
	'FR56088' => 'Île-dArz',
	'FR56089' => 'Inguiniel',
	'FR56090' => 'Inzinzac-Lochrist',
	'FR56091' => 'Josselin',
	'FR56092' => 'Kerfourn',
	'FR56093' => 'Kergrist',
	'FR56094' => 'Kervignac',
	'FR56096' => 'Landaul',
	'FR56097' => 'Landévant',
	'FR56098' => 'Lanester',
	'FR56099' => 'Langoëlan',
	'FR56100' => 'Langonnet',
	'FR56101' => 'Languidic',
	'FR56102' => 'Forges de Lanouée',
	'FR56103' => 'Lantillac',
	'FR56104' => 'Lanvaudan',
	'FR56105' => 'Lanvénégen',
	'FR56106' => 'Larmor-Baden',
	'FR56107' => 'Larmor-Plage',
	'FR56108' => 'Larré',
	'FR56109' => 'Lauzach',
	'FR56110' => 'Lignol',
	'FR56111' => 'Limerzel',
	'FR56112' => 'Lizio',
	'FR56113' => 'Locmalo',
	'FR56114' => 'Locmaria',
	'FR56115' => 'Locmaria-Grand-Champ',
	'FR56116' => 'Locmariaquer',
	'FR56117' => 'Locminé',
	'FR56118' => 'Locmiquélic',
	'FR56119' => 'Locoal-Mendon',
	'FR56120' => 'Locqueltas',
	'FR56121' => 'Lorient',
	'FR56122' => 'Loyat',
	'FR56123' => 'Malansac',
	'FR56124' => 'Malestroit',
	'FR56125' => 'Malguénac',
	'FR56126' => 'Marzan',
	'FR56127' => 'Mauron',
	'FR56128' => 'Melrand',
	'FR56129' => 'Ménéac',
	'FR56130' => 'Merlevenez',
	'FR56131' => 'Meslan',
	'FR56132' => 'Meucon',
	'FR56133' => 'Missiriac',
	'FR56134' => 'Mohon',
	'FR56135' => 'Molac',
	'FR56136' => 'Monteneuf',
	'FR56137' => 'Monterblanc',
	'FR56139' => 'Montertelot',
	'FR56140' => 'Moréac',
	'FR56141' => 'Moustoir-Ac',
	'FR56143' => 'Muzillac',
	'FR56144' => 'Évellys',
	'FR56145' => 'Néant-sur-Yvel',
	'FR56146' => 'Neulliac',
	'FR56147' => 'Nivillac',
	'FR56148' => 'Nostang',
	'FR56149' => 'Noyal-Muzillac',
	'FR56151' => 'Noyal-Pontivy',
	'FR56152' => 'Le Palais',
	'FR56153' => 'Péaule',
	'FR56154' => 'Peillac',
	'FR56155' => 'Pénestin',
	'FR56156' => 'Persquen',
	'FR56157' => 'Plaudren',
	'FR56158' => 'Plescop',
	'FR56159' => 'Pleucadeuc',
	'FR56160' => 'Pleugriffet',
	'FR56161' => 'Ploemel',
	'FR56162' => 'Ploemeur',
	'FR56163' => 'Ploërdut',
	'FR56164' => 'Ploeren',
	'FR56165' => 'Ploërmel',
	'FR56166' => 'Plouay',
	'FR56167' => 'Plougoumelen',
	'FR56168' => 'Plouharnel',
	'FR56169' => 'Plouhinec',
	'FR56170' => 'Plouray',
	'FR56171' => 'Pluherlin',
	'FR56172' => 'Plumelec',
	'FR56173' => 'Pluméliau-Bieuzy',
	'FR56174' => 'Plumelin',
	'FR56175' => 'Plumergat',
	'FR56176' => 'Pluneret',
	'FR56177' => 'Pluvigner',
	'FR56178' => 'Pontivy',
	'FR56179' => 'Pont-Scorff',
	'FR56180' => 'Porcaro',
	'FR56181' => 'Port-Louis',
	'FR56182' => 'Priziac',
	'FR56184' => 'Questembert',
	'FR56185' => 'Quéven',
	'FR56186' => 'Quiberon',
	'FR56188' => 'Quistinic',
	'FR56189' => 'Radenac',
	'FR56190' => 'Réguiny',
	'FR56191' => 'Réminiac',
	'FR56193' => 'Riantec',
	'FR56194' => 'Rieux',
	'FR56195' => 'La Roche-Bernard',
	'FR56196' => 'Rochefort-en-Terre',
	'FR56197' => 'Val dOust',
	'FR56198' => 'Rohan',
	'FR56199' => 'Roudouallec',
	'FR56200' => 'Ruffiac',
	'FR56201' => 'Le Saint',
	'FR56202' => 'Saint-Abraham',
	'FR56203' => 'Saint-Aignan',
	'FR56204' => 'Saint-Allouestre',
	'FR56205' => 'Saint-Armel',
	'FR56206' => 'Saint-Avé',
	'FR56207' => 'Saint-Barthélemy',
	'FR56208' => 'Saint-Brieuc-de-Mauron',
	'FR56209' => 'Sainte-Brigitte',
	'FR56210' => 'Saint-Caradec-Trégomel',
	'FR56211' => 'Saint-Congard',
	'FR56212' => 'Saint-Dolay',
	'FR56213' => 'Saint-Gérand',
	'FR56214' => 'Saint-Gildas-de-Rhuys',
	'FR56215' => 'Saint-Gonnery',
	'FR56216' => 'Saint-Gorgon',
	'FR56218' => 'Saint-Gravé',
	'FR56219' => 'Saint-Guyomard',
	'FR56220' => 'Sainte-Hélène',
	'FR56221' => 'Saint-Jacut-les-Pins',
	'FR56222' => 'Saint-Jean-Brévelay',
	'FR56223' => 'Saint-Jean-la-Poterie',
	'FR56224' => 'Saint-Laurent-sur-Oust',
	'FR56225' => 'Saint-Léry',
	'FR56226' => 'Saint-Malo-de-Beignon',
	'FR56227' => 'Saint-Malo-des-Trois-Fontaines',
	'FR56228' => 'Saint-Marcel',
	'FR56229' => 'Saint-Martin-sur-Oust',
	'FR56230' => 'Saint-Nicolas-du-Tertre',
	'FR56231' => 'Saint-Nolff',
	'FR56232' => 'Saint-Perreux',
	'FR56233' => 'Saint-Philibert',
	'FR56234' => 'Saint-Pierre-Quiberon',
	'FR56236' => 'Saint-Servant',
	'FR56237' => 'Saint-Thuriau',
	'FR56238' => 'Saint-Tugdual',
	'FR56239' => 'Saint-Vincent-sur-Oust',
	'FR56240' => 'Sarzeau',
	'FR56241' => 'Sauzon',
	'FR56242' => 'Séglien',
	'FR56243' => 'Séné',
	'FR56244' => 'Sérent',
	'FR56245' => 'Silfiac',
	'FR56246' => 'Le Sourn',
	'FR56247' => 'Sulniac',
	'FR56248' => 'Surzur',
	'FR56249' => 'Taupont',
	'FR56250' => 'Théhillac',
	'FR56251' => 'Theix-Noyalo',
	'FR56252' => 'Le Tour-du-Parc',
	'FR56253' => 'Tréal',
	'FR56254' => 'Trédion',
	'FR56255' => 'Treffléan',
	'FR56256' => 'Tréhorenteuc',
	'FR56257' => 'La Trinité-Porhoët',
	'FR56258' => 'La Trinité-sur-Mer',
	'FR56259' => 'La Trinité-Surzur',
	'FR56260' => 'Vannes',
	'FR56261' => 'La Vraie-Croix',
	'FR56262' => 'Bono',
	'FR56263' => 'Sainte-Anne-dAuray',
	'FR56264' => 'Kernascléden',
	'FR57001' => 'Aboncourt',
	'FR57002' => 'Aboncourt-sur-Seille',
	'FR57003' => 'Abreschviller',
	'FR57004' => 'Achain',
	'FR57006' => 'Achen',
	'FR57007' => 'Adaincourt',
	'FR57008' => 'Adelange',
	'FR57009' => 'Ajoncourt',
	'FR57010' => 'Alaincourt-la-Côte',
	'FR57011' => 'Albestroff',
	'FR57012' => 'Algrange',
	'FR57013' => 'Alsting',
	'FR57014' => 'Altrippe',
	'FR57015' => 'Altviller',
	'FR57016' => 'Alzing',
	'FR57017' => 'Amanvillers',
	'FR57018' => 'Amelécourt',
	'FR57019' => 'Amnéville',
	'FR57020' => 'Ancerville',
	'FR57021' => 'Ancy-Dornot',
	'FR57022' => 'Angevillers',
	'FR57024' => 'Antilly',
	'FR57025' => 'Anzeling',
	'FR57026' => 'Apach',
	'FR57027' => 'Arraincourt',
	'FR57028' => 'Argancy',
	'FR57029' => 'Arriance',
	'FR57030' => 'Arry',
	'FR57031' => 'Ars-Laquenexy',
	'FR57032' => 'Ars-sur-Moselle',
	'FR57033' => 'Arzviller',
	'FR57034' => 'Aspach',
	'FR57035' => 'Assenoncourt',
	'FR57036' => 'Attilloncourt',
	'FR57037' => 'Aube',
	'FR57038' => 'Audun-le-Tiche',
	'FR57039' => 'Augny',
	'FR57040' => 'Aulnois-sur-Seille',
	'FR57041' => 'Aumetz',
	'FR57042' => 'Avricourt',
	'FR57043' => 'Ay-sur-Moselle',
	'FR57044' => 'Azoudange',
	'FR57045' => 'Bacourt',
	'FR57046' => 'Baerenthal',
	'FR57047' => 'Bambiderstroff',
	'FR57048' => 'Bannay',
	'FR57049' => 'Le Ban-Saint-Martin',
	'FR57050' => 'Barchain',
	'FR57051' => 'Baronville',
	'FR57052' => 'Barst',
	'FR57053' => 'Bassing',
	'FR57054' => 'Baudrecourt',
	'FR57055' => 'Bazoncourt',
	'FR57056' => 'Bébing',
	'FR57057' => 'Béchy',
	'FR57058' => 'Behren-lès-Forbach',
	'FR57059' => 'Bellange',
	'FR57060' => 'Bénestroff',
	'FR57061' => 'Béning-lès-Saint-Avold',
	'FR57062' => 'Berg-sur-Moselle',
	'FR57063' => 'Bérig-Vintrange',
	'FR57064' => 'Berling',
	'FR57065' => 'Bermering',
	'FR57066' => 'Berthelming',
	'FR57067' => 'Bertrange',
	'FR57069' => 'Berviller-en-Moselle',
	'FR57070' => 'Bettange',
	'FR57071' => 'Bettborn',
	'FR57072' => 'Bettelainville',
	'FR57073' => 'Betting',
	'FR57074' => 'Bettviller',
	'FR57075' => 'Beux',
	'FR57076' => 'Beyren-lès-Sierck',
	'FR57077' => 'Bezange-la-Petite',
	'FR57079' => 'Bibiche',
	'FR57080' => 'Bickenholtz',
	'FR57081' => 'Bidestroff',
	'FR57082' => 'Biding',
	'FR57083' => 'Bining',
	'FR57084' => 'Bioncourt',
	'FR57085' => 'Bionville-sur-Nied',
	'FR57086' => 'Belles-Forêts',
	'FR57087' => 'Bisten-en-Lorraine',
	'FR57088' => 'Bistroff',
	'FR57089' => 'Bitche',
	'FR57090' => 'Blanche-Église',
	'FR57091' => 'Bliesbruck',
	'FR57092' => 'Blies-Ébersing',
	'FR57093' => 'Blies-Guersviller',
	'FR57095' => 'Boucheporn',
	'FR57096' => 'Boulange',
	'FR57097' => 'Boulay-Moselle',
	'FR57098' => 'Bourgaltroff',
	'FR57099' => 'Bourdonnay',
	'FR57100' => 'Bourscheid',
	'FR57101' => 'Bousbach',
	'FR57102' => 'Bousse',
	'FR57103' => 'Bousseviller',
	'FR57104' => 'Boust',
	'FR57105' => 'Boustroff',
	'FR57106' => 'Bouzonville',
	'FR57107' => 'Bréhain',
	'FR57108' => 'Breidenbach',
	'FR57109' => 'Breistroff-la-Grande',
	'FR57110' => 'Brettnach',
	'FR57111' => 'Bronvaux',
	'FR57112' => 'Brouck',
	'FR57113' => 'Brouderdorff',
	'FR57114' => 'Brouviller',
	'FR57115' => 'Brulange',
	'FR57116' => 'Buchy',
	'FR57117' => 'Buding',
	'FR57118' => 'Budling',
	'FR57119' => 'Buhl-Lorraine',
	'FR57120' => 'Burlioncourt',
	'FR57121' => 'Burtoncourt',
	'FR57122' => 'Cappel',
	'FR57123' => 'Carling',
	'FR57124' => 'Cattenom',
	'FR57125' => 'Chailly-lès-Ennery',
	'FR57126' => 'Chambrey',
	'FR57127' => 'Chanville',
	'FR57128' => 'Charleville-sous-Bois',
	'FR57129' => 'Charly-Oradour',
	'FR57130' => 'Château-Bréhain',
	'FR57131' => 'Château-Rouge',
	'FR57132' => 'Château-Salins',
	'FR57133' => 'Château-Voué',
	'FR57134' => 'Châtel-Saint-Germain',
	'FR57136' => 'Chémery-les-Deux',
	'FR57137' => 'Cheminot',
	'FR57138' => 'Chenois',
	'FR57139' => 'Chérisey',
	'FR57140' => 'Chesny',
	'FR57141' => 'Chicourt',
	'FR57142' => 'Chieulles',
	'FR57143' => 'Clouange',
	'FR57144' => 'Cocheren',
	'FR57145' => 'Coincy',
	'FR57146' => 'Coin-lès-Cuvry',
	'FR57147' => 'Coin-sur-Seille',
	'FR57148' => 'Colligny-Maizery',
	'FR57149' => 'Colmen',
	'FR57150' => 'Condé-Northen',
	'FR57151' => 'Conthil',
	'FR57152' => 'Contz-les-Bains',
	'FR57153' => 'Corny-sur-Moselle',
	'FR57154' => 'Coume',
	'FR57155' => 'Courcelles-Chaussy',
	'FR57156' => 'Courcelles-sur-Nied',
	'FR57158' => 'Craincourt',
	'FR57159' => 'Créhange',
	'FR57160' => 'Creutzwald',
	'FR57161' => 'Cutting',
	'FR57162' => 'Cuvry',
	'FR57163' => 'Dabo',
	'FR57165' => 'Dalem',
	'FR57166' => 'Dalhain',
	'FR57167' => 'Dalstein',
	'FR57168' => 'Danne-et-Quatre-Vents',
	'FR57169' => 'Dannelbourg',
	'FR57171' => 'Delme',
	'FR57172' => 'Denting',
	'FR57173' => 'Desseling',
	'FR57174' => 'Destry',
	'FR57175' => 'Diane-Capelle',
	'FR57176' => 'Diebling',
	'FR57177' => 'Dieuze',
	'FR57178' => 'Diffembach-lès-Hellimer',
	'FR57179' => 'Distroff',
	'FR57180' => 'Dolving',
	'FR57181' => 'Domnom-lès-Dieuze',
	'FR57182' => 'Donjeux',
	'FR57183' => 'Donnelay',
	'FR57186' => 'Ébersviller',
	'FR57187' => 'Éblange',
	'FR57188' => 'Éguelshardt',
	'FR57189' => 'Eincheville',
	'FR57190' => 'Elvange',
	'FR57191' => 'Elzange',
	'FR57192' => 'Enchenberg',
	'FR57193' => 'Ennery',
	'FR57194' => 'Entrange',
	'FR57195' => 'Epping',
	'FR57196' => 'Erching',
	'FR57197' => 'Ernestviller',
	'FR57198' => 'Erstroff',
	'FR57199' => 'Escherange',
	'FR57200' => 'Les Étangs',
	'FR57201' => 'Etting',
	'FR57202' => 'Etzling',
	'FR57203' => 'Évrange',
	'FR57204' => 'Failly',
	'FR57205' => 'Falck',
	'FR57206' => 'Fameck',
	'FR57207' => 'Farébersviller',
	'FR57208' => 'Farschviller',
	'FR57209' => 'Faulquemont',
	'FR57210' => 'Fénétrange',
	'FR57211' => 'Fèves',
	'FR57212' => 'Féy',
	'FR57213' => 'Filstroff',
	'FR57214' => 'Fixem',
	'FR57215' => 'Flastroff',
	'FR57216' => 'Fleisheim',
	'FR57217' => 'Flétrange',
	'FR57218' => 'Fleury',
	'FR57219' => 'Flévy',
	'FR57220' => 'Flocourt',
	'FR57221' => 'Florange',
	'FR57222' => 'Folkling',
	'FR57224' => 'Folschviller',
	'FR57225' => 'Fonteny',
	'FR57226' => 'Fontoy',
	'FR57227' => 'Forbach',
	'FR57228' => 'Fossieux',
	'FR57229' => 'Foulcrey',
	'FR57230' => 'Fouligny',
	'FR57231' => 'Foville',
	'FR57232' => 'Francaltroff',
	'FR57233' => 'Fraquelfing',
	'FR57234' => 'Frauenberg',
	'FR57235' => 'Freistroff',
	'FR57236' => 'Frémery',
	'FR57237' => 'Frémestroff',
	'FR57238' => 'Fresnes-en-Saulnois',
	'FR57239' => 'Freybouse',
	'FR57240' => 'Freyming-Merlebach',
	'FR57241' => 'Fribourg',
	'FR57242' => 'Gandrange',
	'FR57244' => 'Garrebourg',
	'FR57245' => 'Gavisse',
	'FR57246' => 'Gelucourt',
	'FR57247' => 'Gerbécourt',
	'FR57248' => 'Givrycourt',
	'FR57249' => 'Glatigny',
	'FR57250' => 'Goetzenbruck',
	'FR57251' => 'Goin',
	'FR57252' => 'Gomelange',
	'FR57253' => 'Gondrexange',
	'FR57254' => 'Gorze',
	'FR57255' => 'Gosselming',
	'FR57256' => 'Gravelotte',
	'FR57257' => 'Grémecey',
	'FR57258' => 'Gréning',
	'FR57259' => 'Grindorff-Bizing',
	'FR57260' => 'Grosbliederstroff',
	'FR57261' => 'Gros-Réderching',
	'FR57262' => 'Grostenquin',
	'FR57263' => 'Grundviller',
	'FR57264' => 'Guebenhouse',
	'FR57265' => 'Guébestroff',
	'FR57266' => 'Guéblange-lès-Dieuze',
	'FR57267' => 'Le Val-de-Guéblange',
	'FR57268' => 'Guébling',
	'FR57269' => 'Guénange',
	'FR57270' => 'Val-de-Bride',
	'FR57271' => 'Guenviller',
	'FR57272' => 'Guermange',
	'FR57273' => 'Guerstling',
	'FR57274' => 'Guerting',
	'FR57275' => 'Guessling-Hémering',
	'FR57276' => 'Guinglange',
	'FR57277' => 'Guinkirchen',
	'FR57278' => 'Guinzeling',
	'FR57280' => 'Guntzviller',
	'FR57281' => 'Haboudange',
	'FR57282' => 'Hagen',
	'FR57283' => 'Hagondange',
	'FR57284' => 'Hallering',
	'FR57286' => 'Halstroff',
	'FR57287' => 'Basse-Ham',
	'FR57288' => 'Ham-sous-Varsberg',
	'FR57289' => 'Hambach',
	'FR57290' => 'Hampont',
	'FR57291' => 'Hangviller',
	'FR57292' => 'Hannocourt',
	'FR57293' => 'Han-sur-Nied',
	'FR57294' => 'Hanviller',
	'FR57295' => 'Haraucourt-sur-Seille',
	'FR57296' => 'Hargarten-aux-Mines',
	'FR57297' => 'Harprich',
	'FR57298' => 'Harreberg',
	'FR57299' => 'Hartzviller',
	'FR57300' => 'Haselbourg',
	'FR57301' => 'Haspelschiedt',
	'FR57302' => 'Hattigny',
	'FR57303' => 'Hauconcourt',
	'FR57304' => 'Haut-Clocher',
	'FR57305' => 'Havange',
	'FR57306' => 'Hayange',
	'FR57307' => 'Hayes',
	'FR57308' => 'Hazembourg',
	'FR57309' => 'Heining-lès-Bouzonville',
	'FR57310' => 'Hellering-lès-Fénétrange',
	'FR57311' => 'Hellimer',
	'FR57312' => 'Helstroff',
	'FR57313' => 'Hémilly',
	'FR57314' => 'Héming',
	'FR57315' => 'Henridorff',
	'FR57316' => 'Henriville',
	'FR57317' => 'Hérange',
	'FR57318' => 'Hermelange',
	'FR57319' => 'Herny',
	'FR57320' => 'Hertzing',
	'FR57321' => 'Hesse',
	'FR57322' => 'Hestroff',
	'FR57323' => 'Hettange-Grande',
	'FR57324' => 'Hilbesheim',
	'FR57325' => 'Hilsprich',
	'FR57326' => 'Hinckange',
	'FR57328' => 'Holacourt',
	'FR57329' => 'Holling',
	'FR57330' => 'Holving',
	'FR57331' => 'Hombourg-Budange',
	'FR57332' => 'Hombourg-Haut',
	'FR57333' => 'Hommarting',
	'FR57334' => 'Hommert',
	'FR57335' => 'Honskirch',
	'FR57336' => 'LHôpital',
	'FR57337' => 'Hoste',
	'FR57338' => 'Hottviller',
	'FR57339' => 'Hultehouse',
	'FR57340' => 'Hundling',
	'FR57341' => 'Hunting',
	'FR57342' => 'Ibigny',
	'FR57343' => 'Illange',
	'FR57344' => 'Imling',
	'FR57345' => 'Inglange',
	'FR57346' => 'Insming',
	'FR57347' => 'Insviller',
	'FR57348' => 'Ippling',
	'FR57349' => 'Jallaucourt',
	'FR57350' => 'Jouy-aux-Arches',
	'FR57351' => 'Jury',
	'FR57352' => 'Jussy',
	'FR57353' => 'Juvelize',
	'FR57354' => 'Juville',
	'FR57355' => 'Kalhausen',
	'FR57356' => 'Kanfen',
	'FR57357' => 'Kappelkinger',
	'FR57358' => 'Kédange-sur-Canner',
	'FR57359' => 'Kemplich',
	'FR57360' => 'Kerbach',
	'FR57361' => 'Kerling-lès-Sierck',
	'FR57362' => 'Kerprich-aux-Bois',
	'FR57364' => 'Kirsch-lès-Sierck',
	'FR57365' => 'Kirschnaumen',
	'FR57366' => 'Kirviller',
	'FR57367' => 'Klang',
	'FR57368' => 'Knutange',
	'FR57370' => 'Kœnigsmacker',
	'FR57371' => 'Haute-Kontz',
	'FR57372' => 'Kuntzig',
	'FR57373' => 'Lachambre',
	'FR57374' => 'Lafrimbolle',
	'FR57375' => 'Lagarde',
	'FR57376' => 'Lambach',
	'FR57377' => 'Landange',
	'FR57379' => 'Landroff',
	'FR57380' => 'Laneuveville-lès-Lorquin',
	'FR57381' => 'Laneuveville-en-Saulnois',
	'FR57382' => 'Langatte',
	'FR57383' => 'Languimberg',
	'FR57384' => 'Laning',
	'FR57385' => 'Laquenexy',
	'FR57386' => 'Laudrefang',
	'FR57387' => 'Laumesfeld',
	'FR57388' => 'Launstroff',
	'FR57389' => 'Lelling',
	'FR57390' => 'Lemberg',
	'FR57391' => 'Lemoncourt',
	'FR57392' => 'Lemud',
	'FR57393' => 'Lengelsheim',
	'FR57394' => 'Léning',
	'FR57395' => 'Lesse',
	'FR57396' => 'Lessy',
	'FR57397' => 'Ley',
	'FR57398' => 'Leyviller',
	'FR57399' => 'Lezey',
	'FR57401' => 'Lidrezing',
	'FR57402' => 'Liederschiedt',
	'FR57403' => 'Liéhon',
	'FR57404' => 'Lindre-Basse',
	'FR57405' => 'Lindre-Haute',
	'FR57406' => 'Liocourt',
	'FR57407' => 'Lixheim',
	'FR57408' => 'Lixing-lès-Rouhling',
	'FR57409' => 'Lixing-lès-Saint-Avold',
	'FR57410' => 'Lhor',
	'FR57411' => 'Lommerange',
	'FR57412' => 'Longeville-lès-Metz',
	'FR57413' => 'Longeville-lès-Saint-Avold',
	'FR57414' => 'Lorquin',
	'FR57415' => 'Lorry-lès-Metz',
	'FR57416' => 'Lorry-Mardigny',
	'FR57417' => 'Lostroff',
	'FR57418' => 'Loudrefing',
	'FR57419' => 'Loupershouse',
	'FR57421' => 'Loutzviller',
	'FR57422' => 'Louvigny',
	'FR57423' => 'Lubécourt',
	'FR57424' => 'Lucy',
	'FR57425' => 'Luppy',
	'FR57426' => 'Luttange',
	'FR57427' => 'Lutzelbourg',
	'FR57428' => 'Macheren',
	'FR57430' => 'Mainvillers',
	'FR57431' => 'Maizeroy',
	'FR57433' => 'Maizières-lès-Metz',
	'FR57434' => 'Maizières-lès-Vic',
	'FR57436' => 'Malaucourt-sur-Seille',
	'FR57437' => 'Malling',
	'FR57438' => 'Malroy',
	'FR57439' => 'Manderen-Ritzing',
	'FR57440' => 'Manhoué',
	'FR57441' => 'Manom',
	'FR57442' => 'Many',
	'FR57443' => 'Marange-Silvange',
	'FR57444' => 'Marange-Zondrange',
	'FR57445' => 'Marieulles',
	'FR57446' => 'Marimont-lès-Bénestroff',
	'FR57447' => 'Marly',
	'FR57448' => 'Marsal',
	'FR57449' => 'Marsilly',
	'FR57451' => 'Marthille',
	'FR57452' => 'La Maxe',
	'FR57453' => 'Maxstadt',
	'FR57454' => 'Mécleuves',
	'FR57455' => 'Mégange',
	'FR57456' => 'Meisenthal',
	'FR57457' => 'Menskirch',
	'FR57459' => 'Merschweiller',
	'FR57460' => 'Merten',
	'FR57461' => 'Métairies-Saint-Quirin',
	'FR57462' => 'Metting',
	'FR57463' => 'Metz',
	'FR57464' => 'Metzeresche',
	'FR57465' => 'Metzervisse',
	'FR57466' => 'Metzing',
	'FR57467' => 'Mey',
	'FR57468' => 'Mittelbronn',
	'FR57469' => 'Mittersheim',
	'FR57470' => 'Molring',
	'FR57471' => 'Momerstroff',
	'FR57472' => 'Moncheux',
	'FR57473' => 'Moncourt',
	'FR57474' => 'Mondelange',
	'FR57475' => 'Mondorff',
	'FR57476' => 'Monneren',
	'FR57477' => 'Montbronn',
	'FR57478' => 'Montdidier',
	'FR57479' => 'Montenach',
	'FR57480' => 'Montigny-lès-Metz',
	'FR57481' => 'Montois-la-Montagne',
	'FR57482' => 'Ogy-Montoy-Flanville',
	'FR57483' => 'Morhange',
	'FR57484' => 'Morsbach',
	'FR57485' => 'Morville-lès-Vic',
	'FR57486' => 'Morville-sur-Nied',
	'FR57487' => 'Moulins-lès-Metz',
	'FR57488' => 'Moussey',
	'FR57489' => 'Mouterhouse',
	'FR57490' => 'Moyenvic',
	'FR57491' => 'Moyeuvre-Grande',
	'FR57492' => 'Moyeuvre-Petite',
	'FR57493' => 'Mulcey',
	'FR57494' => 'Munster',
	'FR57495' => 'Narbéfontaine',
	'FR57496' => 'Nébing',
	'FR57497' => 'Nelling',
	'FR57498' => 'Neufchef',
	'FR57499' => 'Neufgrange',
	'FR57500' => 'Neufmoulins',
	'FR57501' => 'Neufvillage',
	'FR57502' => 'Neunkirchen-lès-Bouzonville',
	'FR57504' => 'Niderhoff',
	'FR57505' => 'Niderviller',
	'FR57506' => 'Niederstinzel',
	'FR57507' => 'Niedervisse',
	'FR57508' => 'Nilvange',
	'FR57509' => 'Nitting',
	'FR57510' => 'Noisseville',
	'FR57511' => 'Norroy-le-Veneur',
	'FR57512' => 'Nouilly',
	'FR57513' => 'Nousseviller-lès-Bitche',
	'FR57514' => 'Nousseviller-Saint-Nabor',
	'FR57515' => 'Novéant-sur-Moselle',
	'FR57516' => 'Oberdorff',
	'FR57517' => 'Obergailbach',
	'FR57518' => 'Oberstinzel',
	'FR57519' => 'Obervisse',
	'FR57520' => 'Obreck',
	'FR57521' => 'Œting',
	'FR57524' => 'Ommeray',
	'FR57525' => 'Oriocourt',
	'FR57526' => 'Ormersviller',
	'FR57527' => 'Orny',
	'FR57528' => 'Oron',
	'FR57529' => 'Ottange',
	'FR57530' => 'Ottonville',
	'FR57531' => 'Oudrenne',
	'FR57532' => 'Pagny-lès-Goin',
	'FR57533' => 'Pange',
	'FR57534' => 'Peltre',
	'FR57535' => 'Petit-Réderching',
	'FR57536' => 'Petit-Tenquin',
	'FR57537' => 'Petite-Rosselle',
	'FR57538' => 'Pettoncourt',
	'FR57539' => 'Pévange',
	'FR57540' => 'Phalsbourg',
	'FR57541' => 'Philippsbourg',
	'FR57542' => 'Piblange',
	'FR57543' => 'Pierrevillers',
	'FR57544' => 'Plaine-de-Walsch',
	'FR57545' => 'Plappeville',
	'FR57546' => 'Plesnois',
	'FR57547' => 'Pommérieux',
	'FR57548' => 'Pontoy',
	'FR57549' => 'Pontpierre',
	'FR57550' => 'Porcelette',
	'FR57551' => 'Postroff',
	'FR57552' => 'Pouilly',
	'FR57553' => 'Pournoy-la-Chétive',
	'FR57554' => 'Pournoy-la-Grasse',
	'FR57555' => 'Prévocourt',
	'FR57556' => 'Puttelange-aux-Lacs',
	'FR57557' => 'Puttelange-lès-Thionville',
	'FR57558' => 'Puttigny',
	'FR57559' => 'Puzieux',
	'FR57560' => 'Racrange',
	'FR57561' => 'Rahling',
	'FR57562' => 'Ranguevaux',
	'FR57563' => 'Raville',
	'FR57564' => 'Réchicourt-le-Château',
	'FR57565' => 'Rédange',
	'FR57566' => 'Réding',
	'FR57567' => 'Rémelfang',
	'FR57568' => 'Rémelfing',
	'FR57569' => 'Rémeling',
	'FR57570' => 'Rémering',
	'FR57571' => 'Rémering-lès-Puttelange',
	'FR57572' => 'Rémilly',
	'FR57573' => 'Réning',
	'FR57574' => 'Basse-Rentgen',
	'FR57575' => 'Retonfey',
	'FR57576' => 'Rettel',
	'FR57577' => 'Reyersviller',
	'FR57578' => 'Rezonville-Vionville',
	'FR57579' => 'Rhodes',
	'FR57580' => 'Riche',
	'FR57581' => 'Richeling',
	'FR57582' => 'Richemont',
	'FR57583' => 'Richeval',
	'FR57584' => 'Rimling',
	'FR57586' => 'Rochonvillers',
	'FR57587' => 'Rodalbe',
	'FR57588' => 'Rodemack',
	'FR57589' => 'Rohrbach-lès-Bitche',
	'FR57590' => 'Rolbing',
	'FR57591' => 'Rombas',
	'FR57592' => 'Romelfing',
	'FR57593' => 'Roncourt',
	'FR57594' => 'Roppeviller',
	'FR57595' => 'Rorbach-lès-Dieuze',
	'FR57596' => 'Rosbruck',
	'FR57597' => 'Rosselange',
	'FR57598' => 'Rouhling',
	'FR57599' => 'Roupeldange',
	'FR57600' => 'Roussy-le-Village',
	'FR57601' => 'Rozérieulles',
	'FR57602' => 'Rurange-lès-Thionville',
	'FR57603' => 'Russange',
	'FR57604' => 'Rustroff',
	'FR57605' => 'Sailly-Achâtel',
	'FR57606' => 'Saint-Avold',
	'FR57607' => 'Sainte-Barbe',
	'FR57609' => 'Saint-Epvre',
	'FR57610' => 'Saint-François-Lacroix',
	'FR57611' => 'Saint-Georges',
	'FR57612' => 'Saint-Hubert',
	'FR57613' => 'Saint-Jean-de-Bassel',
	'FR57614' => 'Saint-Jean-Kourtzerode',
	'FR57615' => 'Saint-Jean-Rohrbach',
	'FR57616' => 'Saint-Julien-lès-Metz',
	'FR57617' => 'Saint-Jure',
	'FR57618' => 'Saint-Louis',
	'FR57619' => 'Saint-Louis-lès-Bitche',
	'FR57620' => 'Sainte-Marie-aux-Chênes',
	'FR57621' => 'Saint-Médard',
	'FR57622' => 'Saint-Privat-la-Montagne',
	'FR57623' => 'Saint-Quirin',
	'FR57624' => 'Sainte-Ruffine',
	'FR57625' => 'Salonnes',
	'FR57626' => 'Sanry-lès-Vigy',
	'FR57627' => 'Sanry-sur-Nied',
	'FR57628' => 'Sarralbe',
	'FR57629' => 'Sarraltroff',
	'FR57630' => 'Sarrebourg',
	'FR57631' => 'Sarreguemines',
	'FR57633' => 'Sarreinsming',
	'FR57634' => 'Saulny',
	'FR57635' => 'Schalbach',
	'FR57636' => 'Schmittviller',
	'FR57637' => 'Schneckenbusch',
	'FR57638' => 'Schœneck',
	'FR57639' => 'Schorbach',
	'FR57640' => 'Schwerdorff',
	'FR57641' => 'Schweyen',
	'FR57642' => 'Scy-Chazelles',
	'FR57643' => 'Secourt',
	'FR57644' => 'Seingbouse',
	'FR57645' => 'Semécourt',
	'FR57647' => 'Serémange-Erzange',
	'FR57648' => 'Servigny-lès-Raville',
	'FR57649' => 'Servigny-lès-Sainte-Barbe',
	'FR57650' => 'Sierck-les-Bains',
	'FR57651' => 'Siersthal',
	'FR57652' => 'Sillegny',
	'FR57653' => 'Silly-en-Saulnois',
	'FR57654' => 'Silly-sur-Nied',
	'FR57655' => 'Solgne',
	'FR57656' => 'Sorbey',
	'FR57657' => 'Sotzeling',
	'FR57658' => 'Soucht',
	'FR57659' => 'Spicheren',
	'FR57660' => 'Stiring-Wendel',
	'FR57661' => 'Sturzelbronn',
	'FR57662' => 'Suisse',
	'FR57663' => 'Talange',
	'FR57664' => 'Tarquimpol',
	'FR57665' => 'Tenteling',
	'FR57666' => 'Terville',
	'FR57667' => 'Téterchen',
	'FR57668' => 'Teting-sur-Nied',
	'FR57669' => 'Théding',
	'FR57670' => 'Thicourt',
	'FR57671' => 'Thimonville',
	'FR57672' => 'Thionville',
	'FR57673' => 'Thonville',
	'FR57674' => 'Tincry',
	'FR57675' => 'Torcheville',
	'FR57676' => 'Tragny',
	'FR57677' => 'Trémery',
	'FR57678' => 'Tressange',
	'FR57679' => 'Tritteling-Redlach',
	'FR57680' => 'Troisfontaines',
	'FR57681' => 'Tromborn',
	'FR57682' => 'Turquestein-Blancrupt',
	'FR57683' => 'Uckange',
	'FR57684' => 'Vahl-Ebersing',
	'FR57685' => 'Vahl-lès-Bénestroff',
	'FR57686' => 'Vahl-lès-Faulquemont',
	'FR57687' => 'Vallerange',
	'FR57689' => 'Valmestroff',
	'FR57690' => 'Valmont',
	'FR57691' => 'Valmunster',
	'FR57692' => 'Vannecourt',
	'FR57693' => 'Vantoux',
	'FR57694' => 'Vany',
	'FR57695' => 'Varize-Vaudoncourt',
	'FR57696' => 'Varsberg',
	'FR57697' => 'Vasperviller',
	'FR57698' => 'Vatimont',
	'FR57700' => 'Vaudreching',
	'FR57701' => 'Vaux',
	'FR57702' => 'Vaxy',
	'FR57703' => 'Veckersviller',
	'FR57704' => 'Veckring',
	'FR57705' => 'Velving',
	'FR57706' => 'Vergaville',
	'FR57707' => 'Vernéville',
	'FR57708' => 'Verny',
	'FR57709' => 'Vescheim',
	'FR57711' => 'Vibersviller',
	'FR57712' => 'Vic-sur-Seille',
	'FR57713' => 'Vieux-Lixheim',
	'FR57714' => 'Haute-Vigneulles',
	'FR57715' => 'Vigny',
	'FR57716' => 'Vigy',
	'FR57717' => 'Viller',
	'FR57718' => 'Villers-Stoncourt',
	'FR57719' => 'Villers-sur-Nied',
	'FR57720' => 'Villing',
	'FR57721' => 'Vilsberg',
	'FR57723' => 'Virming',
	'FR57724' => 'Vitry-sur-Orne',
	'FR57725' => 'Vittersbourg',
	'FR57726' => 'Vittoncourt',
	'FR57727' => 'Viviers',
	'FR57728' => 'Voimhaut',
	'FR57730' => 'Volmerange-lès-Boulay',
	'FR57731' => 'Volmerange-les-Mines',
	'FR57732' => 'Volmunster',
	'FR57733' => 'Volstroff',
	'FR57734' => 'Voyer',
	'FR57736' => 'Vry',
	'FR57737' => 'Vulmont',
	'FR57738' => 'Waldhouse',
	'FR57739' => 'Waldweistroff',
	'FR57740' => 'Waldwisse',
	'FR57741' => 'Walschbronn',
	'FR57742' => 'Walscheid',
	'FR57743' => 'Waltembourg',
	'FR57745' => 'Wiesviller',
	'FR57746' => 'Willerwald',
	'FR57747' => 'Wintersbourg',
	'FR57748' => 'Wittring',
	'FR57749' => 'Vœlfling-lès-Bouzonville',
	'FR57750' => 'Wœlfling-lès-Sarreguemines',
	'FR57751' => 'Woippy',
	'FR57752' => 'Woustviller',
	'FR57753' => 'Wuisse',
	'FR57754' => 'Xanrey',
	'FR57755' => 'Xocourt',
	'FR57756' => 'Xouaxange',
	'FR57757' => 'Yutz',
	'FR57759' => 'Zarbeling',
	'FR57760' => 'Zetting',
	'FR57761' => 'Zilling',
	'FR57762' => 'Zimming',
	'FR57763' => 'Zommange',
	'FR57764' => 'Zoufftgen',
	'FR57765' => 'Diesen',
	'FR57767' => 'Stuckange',
	'FR58001' => 'Achun',
	'FR58002' => 'Alligny-Cosne',
	'FR58003' => 'Alligny-en-Morvan',
	'FR58004' => 'Alluy',
	'FR58005' => 'Amazy',
	'FR58006' => 'Anlezy',
	'FR58007' => 'Annay',
	'FR58008' => 'Anthien',
	'FR58009' => 'Arbourse',
	'FR58010' => 'Arleuf',
	'FR58011' => 'Armes',
	'FR58012' => 'Arquian',
	'FR58013' => 'Arthel',
	'FR58014' => 'Arzembouy',
	'FR58015' => 'Asnan',
	'FR58016' => 'Asnois',
	'FR58017' => 'Aunay-en-Bazois',
	'FR58018' => 'Authiou',
	'FR58019' => 'Avrée',
	'FR58020' => 'Avril-sur-Loire',
	'FR58021' => 'Azy-le-Vif',
	'FR58023' => 'Bazoches',
	'FR58024' => 'Bazolles',
	'FR58025' => 'Béard',
	'FR58026' => 'Beaulieu',
	'FR58027' => 'Beaumont-la-Ferrière',
	'FR58028' => 'Beaumont-Sardolles',
	'FR58029' => 'Beuvron',
	'FR58030' => 'Biches',
	'FR58031' => 'Billy-Chevannes',
	'FR58032' => 'Billy-sur-Oisy',
	'FR58033' => 'Bitry',
	'FR58034' => 'Blismes',
	'FR58035' => 'Bona',
	'FR58036' => 'Bouhy',
	'FR58037' => 'Brassy',
	'FR58038' => 'Breugnon',
	'FR58039' => 'Brèves',
	'FR58040' => 'Brinay',
	'FR58041' => 'Brinon-sur-Beuvron',
	'FR58042' => 'Bulcy',
	'FR58043' => 'Bussy-la-Pesle',
	'FR58044' => 'La Celle-sur-Loire',
	'FR58045' => 'La Celle-sur-Nièvre',
	'FR58046' => 'Cercy-la-Tour',
	'FR58047' => 'Cervon',
	'FR58048' => 'Cessy-les-Bois',
	'FR58049' => 'Chalaux',
	'FR58050' => 'Challement',
	'FR58051' => 'Challuy',
	'FR58052' => 'Champallement',
	'FR58053' => 'Champlemy',
	'FR58054' => 'Champlin',
	'FR58055' => 'Champvert',
	'FR58056' => 'Champvoux',
	'FR58057' => 'Chantenay-Saint-Imbert',
	'FR58058' => 'La Chapelle-Saint-André',
	'FR58059' => 'La Charité-sur-Loire',
	'FR58060' => 'Charrin',
	'FR58061' => 'Chasnay',
	'FR58062' => 'Château-Chinon (Ville)',
	'FR58063' => 'Château-Chinon (Campagne)',
	'FR58064' => 'Châteauneuf-Val-de-Bargis',
	'FR58065' => 'Châtillon-en-Bazois',
	'FR58066' => 'Châtin',
	'FR58067' => 'Chaulgnes',
	'FR58068' => 'Chaumard',
	'FR58069' => 'Chaumot',
	'FR58070' => 'Chazeuil',
	'FR58071' => 'Chevannes-Changy',
	'FR58072' => 'Chevenon',
	'FR58073' => 'Chevroches',
	'FR58074' => 'Chiddes',
	'FR58075' => 'Chitry-les-Mines',
	'FR58076' => 'Chougny',
	'FR58077' => 'Ciez',
	'FR58078' => 'Cizely',
	'FR58079' => 'Clamecy',
	'FR58080' => 'La Collancelle',
	'FR58081' => 'Colméry',
	'FR58082' => 'Corancy',
	'FR58083' => 'Corbigny',
	'FR58084' => 'Corvol-dEmbernard',
	'FR58085' => 'Corvol-lOrgueilleux',
	'FR58086' => 'Cosne-Cours-sur-Loire',
	'FR58087' => 'Cossaye',
	'FR58088' => 'Coulanges-lès-Nevers',
	'FR58089' => 'Couloutre',
	'FR58090' => 'Courcelles',
	'FR58092' => 'Crux-la-Ville',
	'FR58093' => 'Cuncy-lès-Varzy',
	'FR58094' => 'Dampierre-sous-Bouhy',
	'FR58095' => 'Decize',
	'FR58096' => 'Devay',
	'FR58097' => 'Diennes-Aubigny',
	'FR58098' => 'Dirol',
	'FR58099' => 'Dommartin',
	'FR58101' => 'Dompierre-sur-Nièvre',
	'FR58102' => 'Donzy',
	'FR58103' => 'Dornecy',
	'FR58104' => 'Dornes',
	'FR58105' => 'Druy-Parigny',
	'FR58106' => 'Dun-les-Places',
	'FR58107' => 'Dun-sur-Grandry',
	'FR58108' => 'Empury',
	'FR58109' => 'Entrains-sur-Nohain',
	'FR58110' => 'Epiry',
	'FR58111' => 'Fâchin',
	'FR58112' => 'La Fermeté',
	'FR58113' => 'Fertrève',
	'FR58114' => 'Fléty',
	'FR58115' => 'Fleury-sur-Loire',
	'FR58116' => 'Flez-Cuzy',
	'FR58117' => 'Fourchambault',
	'FR58118' => 'Fours',
	'FR58119' => 'Frasnay-Reugny',
	'FR58120' => 'Gâcogne',
	'FR58121' => 'Garchizy',
	'FR58122' => 'Garchy',
	'FR58123' => 'Germenay',
	'FR58124' => 'Germigny-sur-Loire',
	'FR58125' => 'Gien-sur-Cure',
	'FR58126' => 'Gimouille',
	'FR58127' => 'Giry',
	'FR58128' => 'Glux-en-Glenne',
	'FR58129' => 'Gouloux',
	'FR58130' => 'Grenois',
	'FR58131' => 'Guérigny',
	'FR58132' => 'Guipy',
	'FR58133' => 'Héry',
	'FR58134' => 'Imphy',
	'FR58135' => 'Isenay',
	'FR58136' => 'Jailly',
	'FR58137' => 'Lamenay-sur-Loire',
	'FR58138' => 'Langeron',
	'FR58139' => 'Lanty',
	'FR58140' => 'Larochemillay',
	'FR58141' => 'Lavault-de-Frétoy',
	'FR58142' => 'Limanton',
	'FR58143' => 'Limon',
	'FR58144' => 'Livry',
	'FR58145' => 'Lormes',
	'FR58146' => 'Lucenay-lès-Aix',
	'FR58147' => 'Lurcy-le-Bourg',
	'FR58148' => 'Luthenay-Uxeloup',
	'FR58149' => 'Luzy',
	'FR58150' => 'Lys',
	'FR58151' => 'La Machine',
	'FR58152' => 'Magny-Cours',
	'FR58153' => 'Magny-Lormes',
	'FR58154' => 'La Maison-Dieu',
	'FR58155' => 'La Marche',
	'FR58156' => 'Marcy',
	'FR58157' => 'Marigny-lÉglise',
	'FR58158' => 'Mars-sur-Allier',
	'FR58159' => 'Marigny-sur-Yonne',
	'FR58160' => 'Marzy',
	'FR58161' => 'Maux',
	'FR58162' => 'Menestreau',
	'FR58163' => 'Menou',
	'FR58164' => 'Mesves-sur-Loire',
	'FR58165' => 'Metz-le-Comte',
	'FR58166' => 'Mhère',
	'FR58168' => 'Millay',
	'FR58169' => 'Moissy-Moulinot',
	'FR58170' => 'Monceaux-le-Comte',
	'FR58171' => 'Montapas',
	'FR58172' => 'Montambert',
	'FR58173' => 'Montaron',
	'FR58174' => 'Montenoison',
	'FR58175' => 'Mont-et-Marré',
	'FR58176' => 'Montigny-aux-Amognes',
	'FR58177' => 'Montigny-en-Morvan',
	'FR58178' => 'Montigny-sur-Canne',
	'FR58179' => 'Montreuillon',
	'FR58180' => 'Montsauche-les-Settons',
	'FR58181' => 'Moraches',
	'FR58182' => 'Moulins-Engilbert',
	'FR58183' => 'Mouron-sur-Yonne',
	'FR58184' => 'Moussy',
	'FR58185' => 'Moux-en-Morvan',
	'FR58186' => 'Murlin',
	'FR58187' => 'Myennes',
	'FR58188' => 'Nannay',
	'FR58189' => 'Narcy',
	'FR58190' => 'Neuffontaines',
	'FR58191' => 'Neuilly',
	'FR58192' => 'Neuville-lès-Decize',
	'FR58193' => 'Neuvy-sur-Loire',
	'FR58194' => 'Nevers',
	'FR58195' => 'La Nocle-Maulaix',
	'FR58196' => 'Nolay',
	'FR58197' => 'Nuars',
	'FR58198' => 'Oisy',
	'FR58199' => 'Onlay',
	'FR58200' => 'Ouagne',
	'FR58201' => 'Oudan',
	'FR58202' => 'Ougny',
	'FR58203' => 'Oulon',
	'FR58204' => 'Vaux dAmognes',
	'FR58205' => 'Ouroux-en-Morvan',
	'FR58206' => 'Parigny-la-Rose',
	'FR58207' => 'Parigny-les-Vaux',
	'FR58208' => 'Pazy',
	'FR58209' => 'Perroy',
	'FR58210' => 'Planchez',
	'FR58211' => 'Poil',
	'FR58212' => 'Poiseux',
	'FR58213' => 'Pougny',
	'FR58214' => 'Pougues-les-Eaux',
	'FR58215' => 'Pouilly-sur-Loire',
	'FR58216' => 'Pouques-Lormes',
	'FR58217' => 'Pousseaux',
	'FR58218' => 'Prémery',
	'FR58219' => 'Préporché',
	'FR58220' => 'Raveau',
	'FR58221' => 'Rémilly',
	'FR58222' => 'Rix',
	'FR58223' => 'Rouy',
	'FR58224' => 'Ruages',
	'FR58225' => 'Saincaize-Meauce',
	'FR58226' => 'Saint-Agnan',
	'FR58227' => 'Saint-Amand-en-Puisaye',
	'FR58228' => 'Saint-Andelain',
	'FR58229' => 'Saint-André-en-Morvan',
	'FR58230' => 'Saint-Aubin-des-Chaumes',
	'FR58231' => 'Saint-Aubin-les-Forges',
	'FR58232' => 'Saint-Benin-dAzy',
	'FR58233' => 'Saint-Benin-des-Bois',
	'FR58234' => 'Saint-Bonnot',
	'FR58235' => 'Saint-Brisson',
	'FR58236' => 'Sainte-Colombe-des-Bois',
	'FR58237' => 'Saint-Didier',
	'FR58238' => 'Saint-Éloi',
	'FR58239' => 'Saint-Firmin',
	'FR58240' => 'Saint-Franchy',
	'FR58241' => 'Saint-Germain-Chassenay',
	'FR58242' => 'Saint-Germain-des-Bois',
	'FR58243' => 'Saint-Gratien-Savigny',
	'FR58244' => 'Saint-Hilaire-en-Morvan',
	'FR58245' => 'Saint-Hilaire-Fontaine',
	'FR58246' => 'Saint-Honoré-les-Bains',
	'FR58247' => 'Saint-Jean-aux-Amognes',
	'FR58248' => 'Saint-Laurent-lAbbaye',
	'FR58249' => 'Saint-Léger-de-Fougeret',
	'FR58250' => 'Saint-Léger-des-Vignes',
	'FR58251' => 'Saint-Loup',
	'FR58252' => 'Saint-Malo-en-Donziois',
	'FR58253' => 'Sainte-Marie',
	'FR58254' => 'Saint-Martin-dHeuille',
	'FR58255' => 'Saint-Martin-du-Puy',
	'FR58256' => 'Saint-Martin-sur-Nohain',
	'FR58257' => 'Saint-Maurice',
	'FR58258' => 'Saint-Ouen-sur-Loire',
	'FR58259' => 'Saint-Parize-en-Viry',
	'FR58260' => 'Saint-Parize-le-Châtel',
	'FR58261' => 'Saint-Père',
	'FR58262' => 'Saint-Péreuse',
	'FR58263' => 'Saint-Pierre-du-Mont',
	'FR58264' => 'Saint-Pierre-le-Moûtier',
	'FR58265' => 'Saint-Quentin-sur-Nohain',
	'FR58266' => 'Saint-Révérien',
	'FR58267' => 'Saint-Saulge',
	'FR58268' => 'Saint-Seine',
	'FR58269' => 'Saint-Sulpice',
	'FR58270' => 'Saint-Vérain',
	'FR58271' => 'Saizy',
	'FR58272' => 'Sardy-lès-Épiry',
	'FR58273' => 'Sauvigny-les-Bois',
	'FR58274' => 'Savigny-Poil-Fol',
	'FR58275' => 'Saxi-Bourdon',
	'FR58276' => 'Sémelay',
	'FR58277' => 'Sermages',
	'FR58278' => 'Sermoise-sur-Loire',
	'FR58279' => 'Sichamps',
	'FR58280' => 'Sougy-sur-Loire',
	'FR58281' => 'Suilly-la-Tour',
	'FR58282' => 'Surgy',
	'FR58283' => 'Taconnay',
	'FR58284' => 'Talon',
	'FR58285' => 'Tamnay-en-Bazois',
	'FR58286' => 'Tannay',
	'FR58287' => 'Tazilly',
	'FR58288' => 'Teigny',
	'FR58289' => 'Ternant',
	'FR58290' => 'Thaix',
	'FR58291' => 'Thianges',
	'FR58292' => 'Tintury',
	'FR58293' => 'Toury-Lurcy',
	'FR58294' => 'Toury-sur-Jour',
	'FR58295' => 'Tracy-sur-Loire',
	'FR58296' => 'Tresnay',
	'FR58297' => 'Trois-Vèvres',
	'FR58298' => 'Tronsanges',
	'FR58299' => 'Trucy-lOrgueilleux',
	'FR58300' => 'Urzy',
	'FR58301' => 'Vandenesse',
	'FR58302' => 'Varennes-lès-Narcy',
	'FR58303' => 'Varennes-Vauzelles',
	'FR58304' => 'Varzy',
	'FR58305' => 'Vauclaix',
	'FR58306' => 'Verneuil',
	'FR58307' => 'Vielmanay',
	'FR58308' => 'Vignol',
	'FR58309' => 'Villapourçon',
	'FR58310' => 'Villiers-le-Sec',
	'FR58311' => 'Ville-Langy',
	'FR58312' => 'Villiers-sur-Yonne',
	'FR58313' => 'Vitry-Laché',
	'FR59001' => 'Abancourt',
	'FR59002' => 'Abscon',
	'FR59003' => 'Aibes',
	'FR59004' => 'Aix-en-Pévèle',
	'FR59005' => 'Allennes-les-Marais',
	'FR59006' => 'Amfroipret',
	'FR59007' => 'Anhiers',
	'FR59008' => 'Aniche',
	'FR59009' => 'Villeneuve-dAscq',
	'FR59010' => 'Anneux',
	'FR59011' => 'Annœullin',
	'FR59012' => 'Anor',
	'FR59013' => 'Anstaing',
	'FR59014' => 'Anzin',
	'FR59015' => 'Arleux',
	'FR59016' => 'Armbouts-Cappel',
	'FR59017' => 'Armentières',
	'FR59018' => 'Arnèke',
	'FR59019' => 'Artres',
	'FR59021' => 'Assevent',
	'FR59022' => 'Attiches',
	'FR59023' => 'Aubencheul-au-Bac',
	'FR59024' => 'Auberchicourt',
	'FR59025' => 'Aubers',
	'FR59026' => 'Aubigny-au-Bac',
	'FR59027' => 'Aubry-du-Hainaut',
	'FR59028' => 'Auby',
	'FR59029' => 'Auchy-lez-Orchies',
	'FR59031' => 'Audignies',
	'FR59032' => 'Aulnoy-lez-Valenciennes',
	'FR59033' => 'Aulnoye-Aymeries',
	'FR59034' => 'Avelin',
	'FR59035' => 'Avesnelles',
	'FR59036' => 'Avesnes-sur-Helpe',
	'FR59037' => 'Avesnes-les-Aubert',
	'FR59038' => 'Avesnes-le-Sec',
	'FR59039' => 'Awoingt',
	'FR59041' => 'Bachant',
	'FR59042' => 'Bachy',
	'FR59043' => 'Bailleul',
	'FR59044' => 'Baisieux',
	'FR59045' => 'Baives',
	'FR59046' => 'Bambecque',
	'FR59047' => 'Banteux',
	'FR59048' => 'Bantigny',
	'FR59049' => 'Bantouzelle',
	'FR59050' => 'Bas-Lieu',
	'FR59051' => 'La Bassée',
	'FR59052' => 'Bauvin',
	'FR59053' => 'Bavay',
	'FR59054' => 'Bavinchove',
	'FR59055' => 'Bazuel',
	'FR59056' => 'Beaucamps-Ligny',
	'FR59057' => 'Beaudignies',
	'FR59058' => 'Beaufort',
	'FR59059' => 'Beaumont-en-Cambrésis',
	'FR59060' => 'Beaurain',
	'FR59061' => 'Beaurepaire-sur-Sambre',
	'FR59062' => 'Beaurieux',
	'FR59063' => 'Beauvois-en-Cambrésis',
	'FR59064' => 'Bellaing',
	'FR59065' => 'Bellignies',
	'FR59066' => 'Bérelles',
	'FR59067' => 'Bergues',
	'FR59068' => 'Berlaimont',
	'FR59069' => 'Bermerain',
	'FR59070' => 'Bermeries',
	'FR59071' => 'Bersée',
	'FR59072' => 'Bersillies',
	'FR59073' => 'Berthen',
	'FR59074' => 'Bertry',
	'FR59075' => 'Béthencourt',
	'FR59076' => 'Bettignies',
	'FR59077' => 'Bettrechies',
	'FR59078' => 'Beugnies',
	'FR59079' => 'Beuvrages',
	'FR59080' => 'Beuvry-la-Forêt',
	'FR59081' => 'Bévillers',
	'FR59082' => 'Bierne',
	'FR59083' => 'Bissezeele',
	'FR59084' => 'Blaringhem',
	'FR59085' => 'Blécourt',
	'FR59086' => 'Boeschepe',
	'FR59087' => 'Boëseghem',
	'FR59088' => 'Bois-Grenier',
	'FR59089' => 'Bollezeele',
	'FR59090' => 'Bondues',
	'FR59091' => 'Borre',
	'FR59092' => 'Bouchain',
	'FR59093' => 'Boulogne-sur-Helpe',
	'FR59094' => 'Bourbourg',
	'FR59096' => 'Bourghelles',
	'FR59097' => 'Boursies',
	'FR59098' => 'Bousbecque',
	'FR59099' => 'Bousies',
	'FR59100' => 'Bousignies',
	'FR59101' => 'Bousignies-sur-Roc',
	'FR59102' => 'Boussières-en-Cambrésis',
	'FR59103' => 'Boussières-sur-Sambre',
	'FR59104' => 'Boussois',
	'FR59105' => 'Bouvignies',
	'FR59106' => 'Bouvines',
	'FR59107' => 'Bray-Dunes',
	'FR59108' => 'Briastre',
	'FR59109' => 'Brillon',
	'FR59110' => 'Brouckerque',
	'FR59111' => 'Broxeele',
	'FR59112' => 'Bruay-sur-lEscaut',
	'FR59113' => 'Bruille-lez-Marchiennes',
	'FR59114' => 'Bruille-Saint-Amand',
	'FR59115' => 'Brunémont',
	'FR59116' => 'Bry',
	'FR59117' => 'Bugnicourt',
	'FR59118' => 'Busigny',
	'FR59119' => 'Buysscheure',
	'FR59120' => 'Caëstre',
	'FR59121' => 'Cagnoncles',
	'FR59122' => 'Cambrai',
	'FR59123' => 'Camphin-en-Carembault',
	'FR59124' => 'Camphin-en-Pévèle',
	'FR59125' => 'Cantaing-sur-Escaut',
	'FR59126' => 'Cantin',
	'FR59127' => 'Capelle',
	'FR59128' => 'Capinghem',
	'FR59129' => 'Cappelle-en-Pévèle',
	'FR59130' => 'Cappelle-Brouck',
	'FR59131' => 'Cappelle-la-Grande',
	'FR59132' => 'Carnières',
	'FR59133' => 'Carnin',
	'FR59134' => 'Cartignies',
	'FR59135' => 'Cassel',
	'FR59136' => 'Le Cateau-Cambrésis',
	'FR59137' => 'Catillon-sur-Sambre',
	'FR59138' => 'Cattenières',
	'FR59139' => 'Caudry',
	'FR59140' => 'Caullery',
	'FR59141' => 'Cauroir',
	'FR59142' => 'Cerfontaine',
	'FR59143' => 'La Chapelle-dArmentières',
	'FR59144' => 'Château-lAbbaye',
	'FR59145' => 'Chemy',
	'FR59146' => 'Chéreng',
	'FR59147' => 'Choisies',
	'FR59148' => 'Clairfayts',
	'FR59149' => 'Clary',
	'FR59150' => 'Cobrieux',
	'FR59151' => 'Colleret',
	'FR59152' => 'Comines',
	'FR59153' => 'Condé-sur-lEscaut',
	'FR59155' => 'Coudekerque-Branche',
	'FR59156' => 'Courchelettes',
	'FR59157' => 'Cousolre',
	'FR59158' => 'Coutiches',
	'FR59159' => 'Craywick',
	'FR59160' => 'Crespin',
	'FR59161' => 'Crèvecœur-sur-lEscaut',
	'FR59162' => 'Crochte',
	'FR59163' => 'Croix',
	'FR59164' => 'Croix-Caluyau',
	'FR59165' => 'Cuincy',
	'FR59166' => 'Curgies',
	'FR59167' => 'Cuvillers',
	'FR59168' => 'Cysoing',
	'FR59169' => 'Damousies',
	'FR59170' => 'Dechy',
	'FR59171' => 'Dehéries',
	'FR59172' => 'Denain',
	'FR59173' => 'Deûlémont',
	'FR59174' => 'Dimechaux',
	'FR59175' => 'Dimont',
	'FR59176' => 'Doignies',
	'FR59177' => 'Dompierre-sur-Helpe',
	'FR59178' => 'Douai',
	'FR59179' => 'Douchy-les-Mines',
	'FR59180' => 'Le Doulieu',
	'FR59181' => 'Dourlers',
	'FR59182' => 'Drincham',
	'FR59183' => 'Dunkerque',
	'FR59184' => 'Ebblinghem',
	'FR59185' => 'Écaillon',
	'FR59186' => 'Eccles',
	'FR59187' => 'Éclaibes',
	'FR59188' => 'Écuélin',
	'FR59189' => 'Eecke',
	'FR59190' => 'Élesmes',
	'FR59191' => 'Élincourt',
	'FR59192' => 'Émerchicourt',
	'FR59193' => 'Emmerin',
	'FR59194' => 'Englefontaine',
	'FR59195' => 'Englos',
	'FR59196' => 'Ennetières-en-Weppes',
	'FR59197' => 'Ennevelin',
	'FR59198' => 'Eppe-Sauvage',
	'FR59199' => 'Erchin',
	'FR59200' => 'Eringhem',
	'FR59201' => 'Erquinghem-le-Sec',
	'FR59202' => 'Erquinghem-Lys',
	'FR59203' => 'Erre',
	'FR59204' => 'Escarmain',
	'FR59205' => 'Escaudain',
	'FR59206' => 'Escaudœuvres',
	'FR59207' => 'Escautpont',
	'FR59208' => 'Escobecques',
	'FR59209' => 'Esnes',
	'FR59210' => 'Esquelbecq',
	'FR59211' => 'Esquerchin',
	'FR59212' => 'Estaires',
	'FR59213' => 'Estourmel',
	'FR59214' => 'Estrées',
	'FR59215' => 'Estreux',
	'FR59216' => 'Eswars',
	'FR59217' => 'Eth',
	'FR59218' => 'Étrœungt',
	'FR59219' => 'Estrun',
	'FR59220' => 'Faches-Thumesnil',
	'FR59221' => 'Famars',
	'FR59222' => 'Faumont',
	'FR59223' => 'Le Favril',
	'FR59224' => 'Féchain',
	'FR59225' => 'Feignies',
	'FR59226' => 'Felleries',
	'FR59227' => 'Fenain',
	'FR59228' => 'Férin',
	'FR59229' => 'Féron',
	'FR59230' => 'Ferrière-la-Grande',
	'FR59231' => 'Ferrière-la-Petite',
	'FR59232' => 'La Flamengrie',
	'FR59233' => 'Flaumont-Waudrechies',
	'FR59234' => 'Flers-en-Escrebieux',
	'FR59236' => 'Flesquières',
	'FR59237' => 'Flêtre',
	'FR59238' => 'Flines-lès-Mortagne',
	'FR59239' => 'Flines-lez-Raches',
	'FR59240' => 'Floursies',
	'FR59241' => 'Floyon',
	'FR59242' => 'Fontaine-au-Bois',
	'FR59243' => 'Fontaine-au-Pire',
	'FR59244' => 'Fontaine-Notre-Dame',
	'FR59246' => 'Forest-en-Cambrésis',
	'FR59247' => 'Forest-sur-Marque',
	'FR59249' => 'Fourmies',
	'FR59250' => 'Fournes-en-Weppes',
	'FR59251' => 'Frasnoy',
	'FR59252' => 'Frelinghien',
	'FR59253' => 'Fresnes-sur-Escaut',
	'FR59254' => 'Fressain',
	'FR59255' => 'Fressies',
	'FR59256' => 'Fretin',
	'FR59257' => 'Fromelles',
	'FR59258' => 'Genech',
	'FR59259' => 'Ghissignies',
	'FR59260' => 'Ghyvelde',
	'FR59261' => 'Glageon',
	'FR59262' => 'Godewaersvelde',
	'FR59263' => 'Gœulzin',
	'FR59264' => 'Gognies-Chaussée',
	'FR59265' => 'Gommegnies',
	'FR59266' => 'Gondecourt',
	'FR59267' => 'Gonnelieu',
	'FR59268' => 'La Gorgue',
	'FR59269' => 'Gouzeaucourt',
	'FR59270' => 'Grand-Fayt',
	'FR59271' => 'Grande-Synthe',
	'FR59272' => 'Grand-Fort-Philippe',
	'FR59273' => 'Gravelines',
	'FR59274' => 'La Groise',
	'FR59275' => 'Gruson',
	'FR59276' => 'Guesnain',
	'FR59277' => 'Gussignies',
	'FR59278' => 'Hallennes-lez-Haubourdin',
	'FR59279' => 'Halluin',
	'FR59280' => 'Hamel',
	'FR59281' => 'Hantay',
	'FR59282' => 'Hardifort',
	'FR59283' => 'Hargnies',
	'FR59284' => 'Hasnon',
	'FR59285' => 'Haspres',
	'FR59286' => 'Haubourdin',
	'FR59287' => 'Haucourt-en-Cambrésis',
	'FR59288' => 'Haulchin',
	'FR59289' => 'Haussy',
	'FR59290' => 'Haut-Lieu',
	'FR59291' => 'Hautmont',
	'FR59292' => 'Haveluy',
	'FR59293' => 'Haverskerque',
	'FR59294' => 'Haynecourt',
	'FR59295' => 'Hazebrouck',
	'FR59296' => 'Hecq',
	'FR59297' => 'Hélesmes',
	'FR59299' => 'Hem',
	'FR59300' => 'Hem-Lenglet',
	'FR59301' => 'Hergnies',
	'FR59302' => 'Hérin',
	'FR59303' => 'Herlies',
	'FR59304' => 'Herrin',
	'FR59305' => 'Herzeele',
	'FR59306' => 'Hestrud',
	'FR59307' => 'Holque',
	'FR59308' => 'Hondeghem',
	'FR59309' => 'Hondschoote',
	'FR59310' => 'Hon-Hergies',
	'FR59311' => 'Honnechy',
	'FR59312' => 'Honnecourt-sur-Escaut',
	'FR59313' => 'Hordain',
	'FR59314' => 'Hornaing',
	'FR59315' => 'Houdain-lez-Bavay',
	'FR59316' => 'Houplin-Ancoisne',
	'FR59317' => 'Houplines',
	'FR59318' => 'Houtkerque',
	'FR59319' => 'Hoymille',
	'FR59320' => 'Illies',
	'FR59321' => 'Inchy',
	'FR59322' => 'Iwuy',
	'FR59323' => 'Jenlain',
	'FR59324' => 'Jeumont',
	'FR59325' => 'Jolimetz',
	'FR59326' => 'Killem',
	'FR59327' => 'Lallaing',
	'FR59328' => 'Lambersart',
	'FR59329' => 'Lambres-lez-Douai',
	'FR59330' => 'Landas',
	'FR59331' => 'Landrecies',
	'FR59332' => 'Lannoy',
	'FR59333' => 'Larouillies',
	'FR59334' => 'Lauwin-Planque',
	'FR59335' => 'Lecelles',
	'FR59336' => 'Lécluse',
	'FR59337' => 'Lederzeele',
	'FR59338' => 'Ledringhem',
	'FR59339' => 'Leers',
	'FR59340' => 'Leffrinckoucke',
	'FR59341' => 'Lesdain',
	'FR59342' => 'Lez-Fontaine',
	'FR59343' => 'Lesquin',
	'FR59344' => 'Leval',
	'FR59345' => 'Lewarde',
	'FR59346' => 'Lezennes',
	'FR59347' => 'Liessies',
	'FR59348' => 'Lieu-Saint-Amand',
	'FR59349' => 'Ligny-en-Cambrésis',
	'FR59350' => 'Lille',
	'FR59351' => 'Limont-Fontaine',
	'FR59352' => 'Linselles',
	'FR59353' => 'Locquignol',
	'FR59354' => 'Loffre',
	'FR59356' => 'Lompret',
	'FR59357' => 'La Longueville',
	'FR59358' => 'Looberghe',
	'FR59359' => 'Loon-Plage',
	'FR59360' => 'Loos',
	'FR59361' => 'Lourches',
	'FR59363' => 'Louvignies-Quesnoy',
	'FR59364' => 'Louvil',
	'FR59365' => 'Louvroil',
	'FR59366' => 'Lynde',
	'FR59367' => 'Lys-lez-Lannoy',
	'FR59368' => 'La Madeleine',
	'FR59369' => 'Maing',
	'FR59370' => 'Mairieux',
	'FR59371' => 'Le Maisnil',
	'FR59372' => 'Malincourt',
	'FR59374' => 'Marbaix',
	'FR59375' => 'Marchiennes',
	'FR59377' => 'Marcoing',
	'FR59378' => 'Marcq-en-Barœul',
	'FR59379' => 'Marcq-en-Ostrevent',
	'FR59381' => 'Maresches',
	'FR59382' => 'Maretz',
	'FR59383' => 'Marly',
	'FR59384' => 'Maroilles',
	'FR59385' => 'Marpent',
	'FR59386' => 'Marquette-lez-Lille',
	'FR59387' => 'Marquette-en-Ostrevant',
	'FR59388' => 'Marquillies',
	'FR59389' => 'Masnières',
	'FR59390' => 'Masny',
	'FR59391' => 'Mastaing',
	'FR59392' => 'Maubeuge',
	'FR59393' => 'Maulde',
	'FR59394' => 'Maurois',
	'FR59395' => 'Mazinghien',
	'FR59396' => 'Mecquignies',
	'FR59397' => 'Merckeghem',
	'FR59398' => 'Mérignies',
	'FR59399' => 'Merris',
	'FR59400' => 'Merville',
	'FR59401' => 'Méteren',
	'FR59402' => 'Millam',
	'FR59403' => 'Millonfosse',
	'FR59405' => 'Mœuvres',
	'FR59406' => 'Monceau-Saint-Waast',
	'FR59407' => 'Monchaux-sur-Écaillon',
	'FR59408' => 'Moncheaux',
	'FR59409' => 'Monchecourt',
	'FR59410' => 'Mons-en-Barœul',
	'FR59411' => 'Mons-en-Pévèle',
	'FR59412' => 'Montay',
	'FR59413' => 'Montigny-en-Cambrésis',
	'FR59414' => 'Montigny-en-Ostrevent',
	'FR59415' => 'Montrécourt',
	'FR59416' => 'Morbecque',
	'FR59418' => 'Mortagne-du-Nord',
	'FR59419' => 'Mouchin',
	'FR59420' => 'Moustier-en-Fagne',
	'FR59421' => 'Mouvaux',
	'FR59422' => 'Naves',
	'FR59423' => 'Neuf-Berquin',
	'FR59424' => 'Neuf-Mesnil',
	'FR59425' => 'Neuville-en-Avesnois',
	'FR59426' => 'Neuville-en-Ferrain',
	'FR59427' => 'La Neuville',
	'FR59428' => 'Neuville-Saint-Rémy',
	'FR59429' => 'Neuville-sur-Escaut',
	'FR59430' => 'Neuvilly',
	'FR59431' => 'Nieppe',
	'FR59432' => 'Niergnies',
	'FR59433' => 'Nieurlet',
	'FR59434' => 'Nivelle',
	'FR59435' => 'Nomain',
	'FR59436' => 'Noordpeene',
	'FR59437' => 'Noyelles-lès-Seclin',
	'FR59438' => 'Noyelles-sur-Escaut',
	'FR59439' => 'Noyelles-sur-Sambre',
	'FR59440' => 'Noyelles-sur-Selle',
	'FR59441' => 'Obies',
	'FR59442' => 'Obrechies',
	'FR59443' => 'Ochtezeele',
	'FR59444' => 'Odomez',
	'FR59445' => 'Ohain',
	'FR59446' => 'Oisy',
	'FR59447' => 'Onnaing',
	'FR59448' => 'Oost-Cappel',
	'FR59449' => 'Orchies',
	'FR59450' => 'Ors',
	'FR59451' => 'Orsinval',
	'FR59452' => 'Ostricourt',
	'FR59453' => 'Oudezeele',
	'FR59454' => 'Oxelaëre',
	'FR59455' => 'Paillencourt',
	'FR59456' => 'Pecquencourt',
	'FR59457' => 'Pérenchies',
	'FR59458' => 'Péronne-en-Mélantois',
	'FR59459' => 'Petite-Forêt',
	'FR59461' => 'Petit-Fayt',
	'FR59462' => 'Phalempin',
	'FR59463' => 'Pitgam',
	'FR59464' => 'Poix-du-Nord',
	'FR59465' => 'Pommereuil',
	'FR59466' => 'Pont-à-Marcq',
	'FR59467' => 'Pont-sur-Sambre',
	'FR59468' => 'Potelle',
	'FR59469' => 'Pradelles',
	'FR59470' => 'Prémesques',
	'FR59471' => 'Préseau',
	'FR59472' => 'Preux-au-Bois',
	'FR59473' => 'Preux-au-Sart',
	'FR59474' => 'Prisches',
	'FR59475' => 'Prouvy',
	'FR59476' => 'Proville',
	'FR59477' => 'Provin',
	'FR59478' => 'Quaëdypre',
	'FR59479' => 'Quarouble',
	'FR59480' => 'Quérénaing',
	'FR59481' => 'Le Quesnoy',
	'FR59482' => 'Quesnoy-sur-Deûle',
	'FR59483' => 'Quiévelon',
	'FR59484' => 'Quiévrechain',
	'FR59485' => 'Quiévy',
	'FR59486' => 'Râches',
	'FR59487' => 'Radinghem-en-Weppes',
	'FR59488' => 'Raillencourt-Sainte-Olle',
	'FR59489' => 'Raimbeaucourt',
	'FR59490' => 'Rainsars',
	'FR59491' => 'Raismes',
	'FR59492' => 'Ramillies',
	'FR59493' => 'Ramousies',
	'FR59494' => 'Raucourt-au-Bois',
	'FR59495' => 'Recquignies',
	'FR59496' => 'Rejet-de-Beaulieu',
	'FR59497' => 'Renescure',
	'FR59498' => 'Reumont',
	'FR59499' => 'Rexpoëde',
	'FR59500' => 'Ribécourt-la-Tour',
	'FR59501' => 'Rieulay',
	'FR59502' => 'Rieux-en-Cambrésis',
	'FR59503' => 'Robersart',
	'FR59504' => 'Rœulx',
	'FR59505' => 'Rombies-et-Marchipont',
	'FR59506' => 'Romeries',
	'FR59507' => 'Ronchin',
	'FR59508' => 'Roncq',
	'FR59509' => 'Roost-Warendin',
	'FR59511' => 'Rosult',
	'FR59512' => 'Roubaix',
	'FR59513' => 'Roucourt',
	'FR59514' => 'Rousies',
	'FR59515' => 'Rouvignies',
	'FR59516' => 'Rubrouck',
	'FR59517' => 'Les Rues-des-Vignes',
	'FR59518' => 'Ruesnes',
	'FR59519' => 'Rumegies',
	'FR59520' => 'Rumilly-en-Cambrésis',
	'FR59521' => 'Sailly-lez-Cambrai',
	'FR59522' => 'Sailly-lez-Lannoy',
	'FR59523' => 'Sainghin-en-Mélantois',
	'FR59524' => 'Sainghin-en-Weppes',
	'FR59525' => 'Sains-du-Nord',
	'FR59526' => 'Saint-Amand-les-Eaux',
	'FR59527' => 'Saint-André-lez-Lille',
	'FR59528' => 'Saint-Aubert',
	'FR59529' => 'Saint-Aubin',
	'FR59530' => 'Saint-Aybert',
	'FR59531' => 'Saint-Benin',
	'FR59532' => 'Saint-Georges-sur-lAa',
	'FR59533' => 'Saint-Hilaire-lez-Cambrai',
	'FR59534' => 'Saint-Hilaire-sur-Helpe',
	'FR59535' => 'Saint-Jans-Cappel',
	'FR59536' => 'Sainte-Marie-Cappel',
	'FR59537' => 'Saint-Martin-sur-Écaillon',
	'FR59538' => 'Saint-Momelin',
	'FR59539' => 'Saint-Pierre-Brouck',
	'FR59541' => 'Saint-Python',
	'FR59542' => 'Saint-Remy-Chaussée',
	'FR59543' => 'Saint-Remy-du-Nord',
	'FR59544' => 'Saint-Saulve',
	'FR59545' => 'Saint-Souplet',
	'FR59546' => 'Saint-Sylvestre-Cappel',
	'FR59547' => 'Saint-Vaast-en-Cambrésis',
	'FR59548' => 'Saint-Waast',
	'FR59549' => 'Salesches',
	'FR59550' => 'Salomé',
	'FR59551' => 'Saméon',
	'FR59552' => 'Sancourt',
	'FR59553' => 'Santes',
	'FR59554' => 'Sars-et-Rosières',
	'FR59555' => 'Sars-Poteries',
	'FR59556' => 'Sassegnies',
	'FR59557' => 'Saultain',
	'FR59558' => 'Saulzoir',
	'FR59559' => 'Sebourg',
	'FR59560' => 'Seclin',
	'FR59562' => 'Sémeries',
	'FR59563' => 'Semousies',
	'FR59564' => 'La Sentinelle',
	'FR59565' => 'Sepmeries',
	'FR59566' => 'Sequedin',
	'FR59567' => 'Séranvillers-Forenville',
	'FR59568' => 'Sercus',
	'FR59569' => 'Sin-le-Noble',
	'FR59570' => 'Socx',
	'FR59571' => 'Solesmes',
	'FR59572' => 'Solre-le-Château',
	'FR59573' => 'Solrinnes',
	'FR59574' => 'Somain',
	'FR59575' => 'Sommaing',
	'FR59576' => 'Spycker',
	'FR59577' => 'Staple',
	'FR59578' => 'Steenbecque',
	'FR59579' => 'Steene',
	'FR59580' => 'Steenvoorde',
	'FR59581' => 'Steenwerck',
	'FR59582' => 'Strazeele',
	'FR59583' => 'Taisnières-en-Thiérache',
	'FR59584' => 'Taisnières-sur-Hon',
	'FR59585' => 'Templemars',
	'FR59586' => 'Templeuve-en-Pévèle',
	'FR59587' => 'Terdeghem',
	'FR59588' => 'Téteghem-Coudekerque-Village',
	'FR59589' => 'Thiant',
	'FR59590' => 'Thiennes',
	'FR59591' => 'Thivencelle',
	'FR59592' => 'Thumeries',
	'FR59593' => 'Thun-lÉvêque',
	'FR59594' => 'Thun-Saint-Amand',
	'FR59595' => 'Thun-Saint-Martin',
	'FR59596' => 'Tilloy-lez-Marchiennes',
	'FR59597' => 'Tilloy-lez-Cambrai',
	'FR59598' => 'Toufflers',
	'FR59599' => 'Tourcoing',
	'FR59600' => 'Tourmignies',
	'FR59601' => 'Trélon',
	'FR59602' => 'Tressin',
	'FR59603' => 'Trith-Saint-Léger',
	'FR59604' => 'Troisvilles',
	'FR59605' => 'Uxem',
	'FR59606' => 'Valenciennes',
	'FR59607' => 'Vendegies-au-Bois',
	'FR59608' => 'Vendegies-sur-Écaillon',
	'FR59609' => 'Vendeville',
	'FR59610' => 'Verchain-Maugré',
	'FR59611' => 'Verlinghem',
	'FR59612' => 'Vertain',
	'FR59613' => 'Vicq',
	'FR59614' => 'Viesly',
	'FR59615' => 'Vieux-Berquin',
	'FR59616' => 'Vieux-Condé',
	'FR59617' => 'Vieux-Mesnil',
	'FR59618' => 'Vieux-Reng',
	'FR59619' => 'Villereau',
	'FR59620' => 'Villers-au-Tertre',
	'FR59622' => 'Villers-en-Cauchies',
	'FR59623' => 'Villers-Guislain',
	'FR59624' => 'Villers-Outréaux',
	'FR59625' => 'Villers-Plouich',
	'FR59626' => 'Villers-Pol',
	'FR59627' => 'Villers-Sire-Nicole',
	'FR59628' => 'Volckerinckhove',
	'FR59629' => 'Vred',
	'FR59630' => 'Wahagnies',
	'FR59631' => 'Walincourt-Selvigny',
	'FR59632' => 'Wallers',
	'FR59633' => 'Wallers-en-Fagne',
	'FR59634' => 'Wallon-Cappel',
	'FR59635' => 'Wambaix',
	'FR59636' => 'Wambrechies',
	'FR59637' => 'Wandignies-Hamage',
	'FR59638' => 'Wannehain',
	'FR59639' => 'Wargnies-le-Grand',
	'FR59640' => 'Wargnies-le-Petit',
	'FR59641' => 'Warhem',
	'FR59642' => 'Warlaing',
	'FR59643' => 'Warneton',
	'FR59645' => 'Wasnes-au-Bac',
	'FR59646' => 'Wasquehal',
	'FR59647' => 'Watten',
	'FR59648' => 'Wattignies',
	'FR59649' => 'Wattignies-la-Victoire',
	'FR59650' => 'Wattrelos',
	'FR59651' => 'Wavrechain-sous-Denain',
	'FR59652' => 'Wavrechain-sous-Faulx',
	'FR59653' => 'Wavrin',
	'FR59654' => 'Waziers',
	'FR59655' => 'Wemaers-Cappel',
	'FR59656' => 'Wervicq-Sud',
	'FR59657' => 'West-Cappel',
	'FR59658' => 'Wicres',
	'FR59659' => 'Wignehies',
	'FR59660' => 'Willems',
	'FR59661' => 'Willies',
	'FR59662' => 'Winnezeele',
	'FR59663' => 'Wormhout',
	'FR59664' => 'Wulverdinghe',
	'FR59665' => 'Wylder',
	'FR59666' => 'Zegerscappel',
	'FR59667' => 'Zermezeele',
	'FR59668' => 'Zuydcoote',
	'FR59669' => 'Zuytpeene',
	'FR59670' => 'Don',
	'FR60001' => 'Abancourt',
	'FR60002' => 'Abbecourt',
	'FR60003' => 'Abbeville-Saint-Lucien',
	'FR60004' => 'Achy',
	'FR60005' => 'Acy-en-Multien',
	'FR60006' => 'Les Ageux',
	'FR60007' => 'Agnetz',
	'FR60008' => 'Airion',
	'FR60009' => 'Allonne',
	'FR60010' => 'Amblainville',
	'FR60011' => 'Amy',
	'FR60012' => 'Andeville',
	'FR60013' => 'Angicourt',
	'FR60014' => 'Angivillers',
	'FR60015' => 'Angy',
	'FR60016' => 'Ansacq',
	'FR60017' => 'Ansauvillers',
	'FR60019' => 'Antheuil-Portes',
	'FR60020' => 'Antilly',
	'FR60021' => 'Appilly',
	'FR60022' => 'Apremont',
	'FR60023' => 'Armancourt',
	'FR60024' => 'Arsy',
	'FR60025' => 'Attichy',
	'FR60026' => 'Auchy-la-Montagne',
	'FR60027' => 'Auger-Saint-Vincent',
	'FR60028' => 'Aumont-en-Halatte',
	'FR60029' => 'Auneuil',
	'FR60030' => 'Auteuil',
	'FR60031' => 'Autheuil-en-Valois',
	'FR60032' => 'Autrêches',
	'FR60033' => 'Avilly-Saint-Léonard',
	'FR60034' => 'Avrechy',
	'FR60035' => 'Avricourt',
	'FR60036' => 'Avrigny',
	'FR60037' => 'Babœuf',
	'FR60039' => 'Bacouël',
	'FR60040' => 'Bailleul-le-Soc',
	'FR60041' => 'Bailleul-sur-Thérain',
	'FR60042' => 'Bailleval',
	'FR60043' => 'Bailly',
	'FR60044' => 'Balagny-sur-Thérain',
	'FR60045' => 'Barbery',
	'FR60046' => 'Bargny',
	'FR60047' => 'Baron',
	'FR60048' => 'Baugy',
	'FR60049' => 'Bazancourt',
	'FR60050' => 'Bazicourt',
	'FR60051' => 'Beaudéduit',
	'FR60052' => 'Beaugies-sous-Bois',
	'FR60053' => 'Beaulieu-les-Fontaines',
	'FR60054' => 'Les Hauts Talican',
	'FR60055' => 'Beaurains-lès-Noyon',
	'FR60056' => 'Beaurepaire',
	'FR60057' => 'Beauvais',
	'FR60058' => 'Beauvoir',
	'FR60059' => 'Béhéricourt',
	'FR60060' => 'Belle-Église',
	'FR60061' => 'Belloy',
	'FR60062' => 'Berlancourt',
	'FR60063' => 'Berneuil-en-Bray',
	'FR60064' => 'Berneuil-sur-Aisne',
	'FR60065' => 'Berthecourt',
	'FR60066' => 'Béthancourt-en-Valois',
	'FR60067' => 'Béthisy-Saint-Martin',
	'FR60068' => 'Béthisy-Saint-Pierre',
	'FR60069' => 'Betz',
	'FR60070' => 'Bienville',
	'FR60071' => 'Biermont',
	'FR60072' => 'Bitry',
	'FR60073' => 'Blacourt',
	'FR60074' => 'Blaincourt-lès-Précy',
	'FR60075' => 'Blancfossé',
	'FR60076' => 'Blargies',
	'FR60077' => 'Blicourt',
	'FR60078' => 'Blincourt',
	'FR60079' => 'Boissy-Fresnoy',
	'FR60081' => 'Bonlier',
	'FR60082' => 'Bonneuil-les-Eaux',
	'FR60083' => 'Bonneuil-en-Valois',
	'FR60084' => 'Bonnières',
	'FR60085' => 'Bonvillers',
	'FR60086' => 'Boran-sur-Oise',
	'FR60087' => 'Borest',
	'FR60088' => 'Bornel',
	'FR60089' => 'Boubiers',
	'FR60090' => 'Bouconvillers',
	'FR60091' => 'Bouillancy',
	'FR60092' => 'Boullarre',
	'FR60093' => 'Boulogne-la-Grasse',
	'FR60094' => 'Boursonne',
	'FR60095' => 'Boury-en-Vexin',
	'FR60097' => 'Boutencourt',
	'FR60098' => 'Bouvresse',
	'FR60099' => 'Braisnes-sur-Aronde',
	'FR60100' => 'Brasseuse',
	'FR60101' => 'Brégy',
	'FR60102' => 'Brenouille',
	'FR60103' => 'Bresles',
	'FR60104' => 'Breteuil',
	'FR60105' => 'Brétigny',
	'FR60106' => 'Breuil-le-Sec',
	'FR60107' => 'Breuil-le-Vert',
	'FR60108' => 'Briot',
	'FR60109' => 'Brombos',
	'FR60110' => 'Broquiers',
	'FR60111' => 'Broyes',
	'FR60112' => 'Brunvillers-la-Motte',
	'FR60113' => 'Bucamps',
	'FR60114' => 'Buicourt',
	'FR60115' => 'Bulles',
	'FR60116' => 'Bury',
	'FR60117' => 'Bussy',
	'FR60118' => 'Caisnes',
	'FR60119' => 'Cambronne-lès-Ribécourt',
	'FR60120' => 'Cambronne-lès-Clermont',
	'FR60121' => 'Campagne',
	'FR60122' => 'Campeaux',
	'FR60123' => 'Campremy',
	'FR60124' => 'Candor',
	'FR60125' => 'Canly',
	'FR60126' => 'Cannectancourt',
	'FR60127' => 'Canny-sur-Matz',
	'FR60128' => 'Canny-sur-Thérain',
	'FR60129' => 'Carlepont',
	'FR60130' => 'Catenoy',
	'FR60131' => 'Catheux',
	'FR60132' => 'Catigny',
	'FR60133' => 'Catillon-Fumechon',
	'FR60134' => 'Cauffry',
	'FR60135' => 'Cauvigny',
	'FR60136' => 'Cempuis',
	'FR60137' => 'Cernoy',
	'FR60138' => 'Chamant',
	'FR60139' => 'Chambly',
	'FR60140' => 'Chambors',
	'FR60141' => 'Chantilly',
	'FR60142' => 'La Chapelle-en-Serval',
	'FR60143' => 'Chaumont-en-Vexin',
	'FR60144' => 'Chavençon',
	'FR60145' => 'Chelles',
	'FR60146' => 'Chepoix',
	'FR60147' => 'Chevincourt',
	'FR60148' => 'Chèvreville',
	'FR60149' => 'Chevrières',
	'FR60150' => 'Chiry-Ourscamp',
	'FR60151' => 'Choisy-au-Bac',
	'FR60152' => 'Choisy-la-Victoire',
	'FR60153' => 'Choqueuse-les-Bénards',
	'FR60154' => 'Cinqueux',
	'FR60155' => 'Cires-lès-Mello',
	'FR60156' => 'Clairoix',
	'FR60157' => 'Clermont',
	'FR60158' => 'Coivrel',
	'FR60159' => 'Compiègne',
	'FR60160' => 'Conchy-les-Pots',
	'FR60161' => 'Conteville',
	'FR60162' => 'Corbeil-Cerf',
	'FR60163' => 'Cormeilles',
	'FR60164' => 'Le Coudray-Saint-Germer',
	'FR60165' => 'Le Coudray-sur-Thelle',
	'FR60166' => 'Coudun',
	'FR60167' => 'Couloisy',
	'FR60168' => 'Courcelles-Epayelles',
	'FR60169' => 'Courcelles-lès-Gisors',
	'FR60170' => 'Courteuil',
	'FR60171' => 'Courtieux',
	'FR60172' => 'Coye-la-Forêt',
	'FR60173' => 'Cramoisy',
	'FR60174' => 'Crapeaumesnil',
	'FR60175' => 'Creil',
	'FR60176' => 'Crépy-en-Valois',
	'FR60177' => 'Cressonsacq',
	'FR60178' => 'Crèvecœur-le-Grand',
	'FR60179' => 'Crèvecœur-le-Petit',
	'FR60180' => 'Crillon',
	'FR60181' => 'Crisolles',
	'FR60182' => 'Le Crocq',
	'FR60183' => 'Croissy-sur-Celle',
	'FR60184' => 'Croutoy',
	'FR60185' => 'Crouy-en-Thelle',
	'FR60186' => 'Cuignières',
	'FR60187' => 'Cuigy-en-Bray',
	'FR60188' => 'Cuise-la-Motte',
	'FR60189' => 'Cuts',
	'FR60190' => 'Cuvergnon',
	'FR60191' => 'Cuvilly',
	'FR60192' => 'Cuy',
	'FR60193' => 'Daméraucourt',
	'FR60194' => 'Dargies',
	'FR60195' => 'Delincourt',
	'FR60196' => 'La Drenne',
	'FR60197' => 'Dieudonné',
	'FR60198' => 'Dives',
	'FR60199' => 'Doméliers',
	'FR60200' => 'Domfront',
	'FR60201' => 'Dompierre',
	'FR60203' => 'Duvy',
	'FR60204' => 'Écuvilly',
	'FR60205' => 'Élencourt',
	'FR60206' => 'Élincourt-Sainte-Marguerite',
	'FR60207' => 'Éméville',
	'FR60208' => 'Énencourt-Léage',
	'FR60209' => 'La Corne en Vexin',
	'FR60210' => 'Épineuse',
	'FR60211' => 'Éragny-sur-Epte',
	'FR60212' => 'Ercuis',
	'FR60213' => 'Ermenonville',
	'FR60214' => 'Ernemont-Boutavent',
	'FR60215' => 'Erquery',
	'FR60216' => 'Erquinvillers',
	'FR60217' => 'Escames',
	'FR60218' => 'Esches',
	'FR60219' => 'Escles-Saint-Pierre',
	'FR60220' => 'Espaubourg',
	'FR60221' => 'Esquennoy',
	'FR60222' => 'Essuiles',
	'FR60223' => 'Estrées-Saint-Denis',
	'FR60224' => 'Étavigny',
	'FR60225' => 'Étouy',
	'FR60226' => 'Ève',
	'FR60227' => 'Évricourt',
	'FR60228' => 'Fay-les-Étangs',
	'FR60229' => 'Le Fayel',
	'FR60230' => 'Le Fay-Saint-Quentin',
	'FR60231' => 'Feigneux',
	'FR60232' => 'Ferrières',
	'FR60233' => 'Feuquières',
	'FR60234' => 'Fitz-James',
	'FR60235' => 'Flavacourt',
	'FR60236' => 'Flavy-le-Meldeux',
	'FR60237' => 'Fléchy',
	'FR60238' => 'Fleurines',
	'FR60239' => 'Fleury',
	'FR60240' => 'Fontaine-Bonneleau',
	'FR60241' => 'Fontaine-Chaalis',
	'FR60242' => 'Fontaine-Lavaganne',
	'FR60243' => 'Fontaine-Saint-Lucien',
	'FR60244' => 'Fontenay-Torcy',
	'FR60245' => 'Formerie',
	'FR60247' => 'Fouilleuse',
	'FR60248' => 'Fouilloy',
	'FR60249' => 'Foulangues',
	'FR60250' => 'Fouquenies',
	'FR60251' => 'Fouquerolles',
	'FR60252' => 'Fournival',
	'FR60253' => 'Francastel',
	'FR60254' => 'Francières',
	'FR60255' => 'Fréniches',
	'FR60256' => 'Montchevreuil',
	'FR60257' => 'Fresne-Léguillon',
	'FR60258' => 'Fresnières',
	'FR60259' => 'Fresnoy-en-Thelle',
	'FR60260' => 'Fresnoy-la-Rivière',
	'FR60261' => 'Fresnoy-le-Luat',
	'FR60262' => 'Le Frestoy-Vaux',
	'FR60263' => 'Frétoy-le-Château',
	'FR60264' => 'Frocourt',
	'FR60265' => 'Froissy',
	'FR60267' => 'Le Gallet',
	'FR60268' => 'Gannes',
	'FR60269' => 'Gaudechart',
	'FR60270' => 'Genvry',
	'FR60271' => 'Gerberoy',
	'FR60272' => 'Gilocourt',
	'FR60273' => 'Giraumont',
	'FR60274' => 'Glaignes',
	'FR60275' => 'Glatigny',
	'FR60276' => 'Godenvillers',
	'FR60277' => 'Goincourt',
	'FR60278' => 'Golancourt',
	'FR60279' => 'Gondreville',
	'FR60280' => 'Gourchelles',
	'FR60281' => 'Gournay-sur-Aronde',
	'FR60282' => 'Gouvieux',
	'FR60283' => 'Gouy-les-Groseillers',
	'FR60284' => 'Grandfresnoy',
	'FR60285' => 'Grandvillers-aux-Bois',
	'FR60286' => 'Grandvilliers',
	'FR60287' => 'Grandrû',
	'FR60288' => 'Grémévillers',
	'FR60289' => 'Grez',
	'FR60290' => 'Guignecourt',
	'FR60291' => 'Guiscard',
	'FR60292' => 'Gury',
	'FR60293' => 'Hadancourt-le-Haut-Clocher',
	'FR60294' => 'Hainvillers',
	'FR60295' => 'Halloy',
	'FR60296' => 'Hannaches',
	'FR60297' => 'Le Hamel',
	'FR60298' => 'Hanvoile',
	'FR60299' => 'Hardivillers',
	'FR60301' => 'Haucourt',
	'FR60302' => 'Haudivillers',
	'FR60303' => 'Hautbos',
	'FR60304' => 'Haute-Épine',
	'FR60305' => 'Hautefontaine',
	'FR60306' => 'Hécourt',
	'FR60307' => 'Heilles',
	'FR60308' => 'Hémévillers',
	'FR60309' => 'Hénonville',
	'FR60310' => 'Herchies',
	'FR60311' => 'La Hérelle',
	'FR60312' => 'Héricourt-sur-Thérain',
	'FR60313' => 'Hermes',
	'FR60314' => 'Hétomesnil',
	'FR60315' => 'Hodenc-en-Bray',
	'FR60316' => 'Hodenc-lÉvêque',
	'FR60317' => 'Hondainville',
	'FR60318' => 'Houdancourt',
	'FR60319' => 'La Houssoye',
	'FR60320' => 'Ivors',
	'FR60321' => 'Ivry-le-Temple',
	'FR60322' => 'Jaméricourt',
	'FR60323' => 'Janville',
	'FR60324' => 'Jaulzy',
	'FR60325' => 'Jaux',
	'FR60326' => 'Jonquières',
	'FR60327' => 'Jouy-sous-Thelle',
	'FR60328' => 'Juvignies',
	'FR60329' => 'Laberlière',
	'FR60330' => 'Laboissière-en-Thelle',
	'FR60331' => 'Labosse',
	'FR60332' => 'Labruyère',
	'FR60333' => 'Lachapelle-aux-Pots',
	'FR60334' => 'Lachapelle-Saint-Pierre',
	'FR60335' => 'Lachapelle-sous-Gerberoy',
	'FR60336' => 'Lachaussée-du-Bois-dÉcu',
	'FR60337' => 'Lachelle',
	'FR60338' => 'Lacroix-Saint-Ouen',
	'FR60339' => 'Lafraye',
	'FR60340' => 'Lagny',
	'FR60341' => 'Lagny-le-Sec',
	'FR60342' => 'Laigneville',
	'FR60343' => 'Lalande-en-Son',
	'FR60344' => 'Lalandelle',
	'FR60345' => 'Lamécourt',
	'FR60346' => 'Lamorlaye',
	'FR60347' => 'Lannoy-Cuillère',
	'FR60348' => 'Larbroye',
	'FR60350' => 'Lassigny',
	'FR60351' => 'Lataule',
	'FR60352' => 'Lattainville',
	'FR60353' => 'Lavacquerie',
	'FR60354' => 'Laverrière',
	'FR60355' => 'Laversines',
	'FR60356' => 'Lavilletertre',
	'FR60357' => 'Léglantiers',
	'FR60358' => 'Lévignen',
	'FR60359' => 'Lhéraule',
	'FR60360' => 'Liancourt',
	'FR60361' => 'Liancourt-Saint-Pierre',
	'FR60362' => 'Libermont',
	'FR60363' => 'Lierville',
	'FR60364' => 'Lieuvillers',
	'FR60365' => 'Lihus',
	'FR60366' => 'Litz',
	'FR60367' => 'Loconville',
	'FR60368' => 'Longueil-Annel',
	'FR60369' => 'Longueil-Sainte-Marie',
	'FR60370' => 'Lormaison',
	'FR60371' => 'Loueuse',
	'FR60372' => 'Luchy',
	'FR60373' => 'Machemont',
	'FR60374' => 'Maignelay-Montigny',
	'FR60375' => 'Maimbeville',
	'FR60376' => 'Maisoncelle-Saint-Pierre',
	'FR60377' => 'Maisoncelle-Tuilerie',
	'FR60378' => 'Marest-sur-Matz',
	'FR60379' => 'Mareuil-la-Motte',
	'FR60380' => 'Mareuil-sur-Ourcq',
	'FR60381' => 'Margny-aux-Cerises',
	'FR60382' => 'Margny-lès-Compiègne',
	'FR60383' => 'Margny-sur-Matz',
	'FR60385' => 'Marolles',
	'FR60386' => 'Marquéglise',
	'FR60387' => 'Marseille-en-Beauvaisis',
	'FR60388' => 'Martincourt',
	'FR60389' => 'Maucourt',
	'FR60390' => 'Maulers',
	'FR60391' => 'Maysel',
	'FR60392' => 'Mélicocq',
	'FR60393' => 'Mello',
	'FR60394' => 'Ménévillers',
	'FR60395' => 'Méru',
	'FR60396' => 'Méry-la-Bataille',
	'FR60397' => 'Le Mesnil-Conteville',
	'FR60398' => 'Le Mesnil-en-Thelle',
	'FR60399' => 'Le Mesnil-Saint-Firmin',
	'FR60400' => 'Le Mesnil-sur-Bulles',
	'FR60401' => 'Le Mesnil-Théribus',
	'FR60402' => 'Le Meux',
	'FR60403' => 'Milly-sur-Thérain',
	'FR60404' => 'Mogneville',
	'FR60405' => 'Moliens',
	'FR60406' => 'Monceaux',
	'FR60407' => 'Monceaux-lAbbaye',
	'FR60408' => 'Monchy-Humières',
	'FR60409' => 'Monchy-Saint-Éloi',
	'FR60410' => 'Mondescourt',
	'FR60411' => 'Monneville',
	'FR60412' => 'Montagny-en-Vexin',
	'FR60413' => 'Montagny-Sainte-Félicité',
	'FR60414' => 'Montataire',
	'FR60415' => 'Montépilloy',
	'FR60416' => 'Montgérain',
	'FR60418' => 'Montiers',
	'FR60420' => 'Montjavoult',
	'FR60421' => 'Mont-lÉvêque',
	'FR60422' => 'Montlognon',
	'FR60423' => 'Montmacq',
	'FR60424' => 'Montmartin',
	'FR60425' => 'Montreuil-sur-Brêche',
	'FR60426' => 'Montreuil-sur-Thérain',
	'FR60427' => 'Monts',
	'FR60428' => 'Le Mont-Saint-Adrien',
	'FR60429' => 'Morangles',
	'FR60430' => 'Morienval',
	'FR60431' => 'Morlincourt',
	'FR60432' => 'Mortefontaine',
	'FR60433' => 'Mortefontaine-en-Thelle',
	'FR60434' => 'Mortemer',
	'FR60435' => 'Morvillers',
	'FR60436' => 'Mory-Montcrux',
	'FR60437' => 'Mouchy-le-Châtel',
	'FR60438' => 'Moulin-sous-Touvent',
	'FR60439' => 'Mouy',
	'FR60440' => 'Moyenneville',
	'FR60441' => 'Moyvillers',
	'FR60442' => 'Muidorge',
	'FR60443' => 'Muirancourt',
	'FR60444' => 'Mureaumont',
	'FR60445' => 'Nampcel',
	'FR60446' => 'Nanteuil-le-Haudouin',
	'FR60447' => 'Néry',
	'FR60448' => 'Neufchelles',
	'FR60449' => 'Neufvy-sur-Aronde',
	'FR60450' => 'Neuilly-en-Thelle',
	'FR60451' => 'Neuilly-sous-Clermont',
	'FR60452' => 'Neuville-Bosc',
	'FR60454' => 'La Neuville-en-Hez',
	'FR60456' => 'La Neuville-Roy',
	'FR60457' => 'La Neuville-Saint-Pierre',
	'FR60458' => 'La Neuville-sur-Oudeuil',
	'FR60459' => 'La Neuville-sur-Ressons',
	'FR60460' => 'La Neuville-Vault',
	'FR60461' => 'Nivillers',
	'FR60462' => 'Noailles',
	'FR60463' => 'Nogent-sur-Oise',
	'FR60464' => 'Nointel',
	'FR60465' => 'Noirémont',
	'FR60466' => 'Noroy',
	'FR60468' => 'Nourard-le-Franc',
	'FR60469' => 'Novillers',
	'FR60470' => 'Noyers-Saint-Martin',
	'FR60471' => 'Noyon',
	'FR60472' => 'Offoy',
	'FR60473' => 'Ognes',
	'FR60474' => 'Ognolles',
	'FR60476' => 'Omécourt',
	'FR60477' => 'Ons-en-Bray',
	'FR60478' => 'Ormoy-le-Davien',
	'FR60479' => 'Ormoy-Villers',
	'FR60480' => 'Oroër',
	'FR60481' => 'Orrouy',
	'FR60482' => 'Orry-la-Ville',
	'FR60483' => 'Orvillers-Sorel',
	'FR60484' => 'Oudeuil',
	'FR60485' => 'Oursel-Maison',
	'FR60486' => 'Paillart',
	'FR60487' => 'Parnes',
	'FR60488' => 'Passel',
	'FR60489' => 'Péroy-les-Gombries',
	'FR60490' => 'Pierrefitte-en-Beauvaisis',
	'FR60491' => 'Pierrefonds',
	'FR60492' => 'Pimprez',
	'FR60493' => 'Pisseleu',
	'FR60494' => 'Plailly',
	'FR60495' => 'Plainval',
	'FR60496' => 'Plainville',
	'FR60497' => 'Le Plessier-sur-Bulles',
	'FR60498' => 'Le Plessier-sur-Saint-Just',
	'FR60499' => 'Plessis-de-Roye',
	'FR60500' => 'Le Plessis-Belleville',
	'FR60501' => 'Le Plessis-Brion',
	'FR60502' => 'Le Plessis-Patte-dOie',
	'FR60503' => 'Le Ployron',
	'FR60504' => 'Ponchon',
	'FR60505' => 'Pontarmé',
	'FR60506' => 'Pont-lÉvêque',
	'FR60507' => 'Pontoise-lès-Noyon',
	'FR60508' => 'Pontpoint',
	'FR60509' => 'Pont-Sainte-Maxence',
	'FR60510' => 'Porcheux',
	'FR60511' => 'Porquéricourt',
	'FR60512' => 'Pouilly',
	'FR60513' => 'Précy-sur-Oise',
	'FR60514' => 'Prévillers',
	'FR60515' => 'Pronleroy',
	'FR60516' => 'Puiseux-en-Bray',
	'FR60517' => 'Puiseux-le-Hauberger',
	'FR60518' => 'Puits-la-Vallée',
	'FR60519' => 'Quesmy',
	'FR60520' => 'Le Quesnel-Aubry',
	'FR60521' => 'Quincampoix-Fleuzy',
	'FR60522' => 'Quinquempoix',
	'FR60523' => 'Rainvillers',
	'FR60524' => 'Rantigny',
	'FR60525' => 'Raray',
	'FR60526' => 'Ravenel',
	'FR60527' => 'Réez-Fosse-Martin',
	'FR60528' => 'Reilly',
	'FR60529' => 'Rémécourt',
	'FR60530' => 'Rémérangles',
	'FR60531' => 'Remy',
	'FR60533' => 'Ressons-sur-Matz',
	'FR60534' => 'Rethondes',
	'FR60535' => 'Reuil-sur-Brêche',
	'FR60536' => 'Rhuis',
	'FR60537' => 'Ribécourt-Dreslincourt',
	'FR60538' => 'Ricquebourg',
	'FR60539' => 'Rieux',
	'FR60540' => 'Rivecourt',
	'FR60541' => 'Roberval',
	'FR60542' => 'Rochy-Condé',
	'FR60543' => 'Rocquemont',
	'FR60544' => 'Rocquencourt',
	'FR60545' => 'Romescamps',
	'FR60546' => 'Rosières',
	'FR60547' => 'Rosoy',
	'FR60548' => 'Rosoy-en-Multien',
	'FR60549' => 'Rotangy',
	'FR60550' => 'Rothois',
	'FR60551' => 'Rousseloy',
	'FR60552' => 'Rouville',
	'FR60553' => 'Rouvillers',
	'FR60554' => 'Rouvres-en-Multien',
	'FR60555' => 'Rouvroy-les-Merles',
	'FR60556' => 'Royaucourt',
	'FR60557' => 'Roy-Boissy',
	'FR60558' => 'Roye-sur-Matz',
	'FR60559' => 'La Rue-Saint-Pierre',
	'FR60560' => 'Rully',
	'FR60561' => 'Russy-Bémont',
	'FR60562' => 'Sacy-le-Grand',
	'FR60563' => 'Sacy-le-Petit',
	'FR60564' => 'Sains-Morainvillers',
	'FR60565' => 'Saint-André-Farivillers',
	'FR60566' => 'Saint-Arnoult',
	'FR60567' => 'Saint-Aubin-en-Bray',
	'FR60568' => 'Saint-Aubin-sous-Erquery',
	'FR60569' => 'Saint-Crépin-aux-Bois',
	'FR60570' => 'Saint-Crépin-Ibouvillers',
	'FR60571' => 'Saint-Deniscourt',
	'FR60572' => 'Saint-Étienne-Roilaye',
	'FR60573' => 'Sainte-Eusoye',
	'FR60574' => 'Saint-Félix',
	'FR60575' => 'Sainte-Geneviève',
	'FR60576' => 'Saint-Germain-la-Poterie',
	'FR60577' => 'Saint-Germer-de-Fly',
	'FR60578' => 'Saintines',
	'FR60579' => 'Saint-Jean-aux-Bois',
	'FR60581' => 'Saint-Just-en-Chaussée',
	'FR60582' => 'Saint-Léger-aux-Bois',
	'FR60583' => 'Saint-Léger-en-Bray',
	'FR60584' => 'Saint-Leu-dEsserent',
	'FR60585' => 'Saint-Martin-aux-Bois',
	'FR60586' => 'Saint-Martin-le-Nœud',
	'FR60587' => 'Saint-Martin-Longueau',
	'FR60588' => 'Saint-Maur',
	'FR60589' => 'Saint-Maximin',
	'FR60590' => 'Saint-Omer-en-Chaussée',
	'FR60591' => 'Saint-Paul',
	'FR60592' => 'Saint-Pierre-es-Champs',
	'FR60593' => 'Saint-Pierre-lès-Bitry',
	'FR60594' => 'Saint-Quentin-des-Prés',
	'FR60595' => 'Saint-Remy-en-lEau',
	'FR60596' => 'Saint-Samson-la-Poterie',
	'FR60597' => 'Saint-Sauveur',
	'FR60598' => 'Saint-Sulpice',
	'FR60599' => 'Saint-Thibault',
	'FR60600' => 'Saint-Vaast-de-Longmont',
	'FR60601' => 'Saint-Vaast-lès-Mello',
	'FR60602' => 'Saint-Valery',
	'FR60603' => 'Salency',
	'FR60604' => 'Sarcus',
	'FR60605' => 'Sarnois',
	'FR60608' => 'Le Saulchoy',
	'FR60609' => 'Savignies',
	'FR60610' => 'Sempigny',
	'FR60611' => 'Senantes',
	'FR60612' => 'Senlis',
	'FR60613' => 'Senots',
	'FR60614' => 'Serans',
	'FR60615' => 'Sérévillers',
	'FR60616' => 'Sérifontaine',
	'FR60617' => 'Sermaize',
	'FR60618' => 'Séry-Magneval',
	'FR60619' => 'Silly-le-Long',
	'FR60620' => 'Silly-Tillard',
	'FR60621' => 'Solente',
	'FR60622' => 'Sommereux',
	'FR60623' => 'Songeons',
	'FR60624' => 'Sully',
	'FR60625' => 'Suzoy',
	'FR60626' => 'Talmontiers',
	'FR60627' => 'Tartigny',
	'FR60628' => 'Therdonne',
	'FR60629' => 'Thérines',
	'FR60630' => 'Thibivillers',
	'FR60631' => 'Thiers-sur-Thève',
	'FR60632' => 'Thiescourt',
	'FR60633' => 'Thieuloy-Saint-Antoine',
	'FR60634' => 'Thieux',
	'FR60635' => 'Thiverny',
	'FR60636' => 'Thourotte',
	'FR60637' => 'Thury-en-Valois',
	'FR60638' => 'Thury-sous-Clermont',
	'FR60639' => 'Tillé',
	'FR60640' => 'Tourly',
	'FR60641' => 'Tracy-le-Mont',
	'FR60642' => 'Tracy-le-Val',
	'FR60643' => 'Tricot',
	'FR60644' => 'Trie-Château',
	'FR60645' => 'Trie-la-Ville',
	'FR60646' => 'Troissereux',
	'FR60647' => 'Trosly-Breuil',
	'FR60648' => 'Troussencourt',
	'FR60650' => 'Trumilly',
	'FR60651' => 'Ully-Saint-Georges',
	'FR60652' => 'Valdampierre',
	'FR60653' => 'Valescourt',
	'FR60654' => 'Vandélicourt',
	'FR60655' => 'Varesnes',
	'FR60656' => 'Varinfroy',
	'FR60657' => 'Vauchelles',
	'FR60658' => 'Vauciennes',
	'FR60659' => 'Vaudancourt',
	'FR60660' => 'Le Vaumain',
	'FR60661' => 'Vaumoise',
	'FR60662' => 'Le Vauroux',
	'FR60663' => 'Velennes',
	'FR60664' => 'Vendeuil-Caply',
	'FR60665' => 'Venette',
	'FR60666' => 'Ver-sur-Launette',
	'FR60667' => 'Verberie',
	'FR60668' => 'Verderel-lès-Sauqueuse',
	'FR60669' => 'Verderonne',
	'FR60670' => 'Verneuil-en-Halatte',
	'FR60671' => 'Versigny',
	'FR60672' => 'Vez',
	'FR60673' => 'Viefvillers',
	'FR60674' => 'Vieux-Moulin',
	'FR60675' => 'Vignemont',
	'FR60676' => 'Ville',
	'FR60677' => 'Villembray',
	'FR60678' => 'Villeneuve-les-Sablons',
	'FR60679' => 'La Villeneuve-sous-Thury',
	'FR60680' => 'Villeneuve-sur-Verberie',
	'FR60681' => 'Villers-Saint-Barthélemy',
	'FR60682' => 'Villers Saint Frambourg-Ognon',
	'FR60683' => 'Villers-Saint-Genest',
	'FR60684' => 'Villers-Saint-Paul',
	'FR60685' => 'Villers-Saint-Sépulcre',
	'FR60686' => 'Villers-sous-Saint-Leu',
	'FR60687' => 'Villers-sur-Auchy',
	'FR60688' => 'Villers-sur-Bonnières',
	'FR60689' => 'Villers-sur-Coudun',
	'FR60691' => 'Villers-Vermont',
	'FR60692' => 'Villers-Vicomte',
	'FR60693' => 'Villeselve',
	'FR60695' => 'Vineuil-Saint-Firmin',
	'FR60697' => 'Vrocourt',
	'FR60698' => 'Wacquemoulin',
	'FR60699' => 'Wambez',
	'FR60700' => 'Warluis',
	'FR60701' => 'Wavignies',
	'FR60702' => 'Welles-Pérennes',
	'FR60703' => 'Aux Marais',
	'FR61001' => 'Alençon',
	'FR61002' => 'Almenêches',
	'FR61005' => 'Appenai-sous-Bellême',
	'FR61006' => 'Argentan',
	'FR61007' => 'Athis-Val de Rouvre',
	'FR61008' => 'Aube',
	'FR61010' => 'Aubry-le-Panthou',
	'FR61011' => 'Aubusson',
	'FR61012' => 'Auguaise',
	'FR61013' => 'Aunay-les-Bois',
	'FR61014' => 'Aunou-le-Faucon',
	'FR61015' => 'Aunou-sur-Orne',
	'FR61017' => 'Les Authieux-du-Puits',
	'FR61018' => 'Avernes-Saint-Gourgon',
	'FR61020' => 'Avoine',
	'FR61021' => 'Avrilly',
	'FR61023' => 'Bailleul',
	'FR61024' => 'Banvou',
	'FR61026' => 'Barville',
	'FR61028' => 'Bazoches-au-Houlme',
	'FR61029' => 'Bazoches-sur-Hoëne',
	'FR61030' => 'La Bazoque',
	'FR61032' => 'Beaufai',
	'FR61034' => 'Beaulieu',
	'FR61035' => 'Beauvain',
	'FR61036' => 'Belfonds',
	'FR61037' => 'Bellavilliers',
	'FR61038' => 'Bellême',
	'FR61039' => 'La Bellière',
	'FR61040' => 'Bellou-en-Houlme',
	'FR61041' => 'Bellou-le-Trichard',
	'FR61043' => 'Berdhuis',
	'FR61044' => 'Berjou',
	'FR61046' => 'Bizou',
	'FR61048' => 'Boëcé',
	'FR61049' => 'Boissei-la-Lande',
	'FR61050' => 'Cour-Maugis sur Huisne',
	'FR61051' => 'Boitron',
	'FR61052' => 'Bonnefoi',
	'FR61053' => 'Bonsmoulins',
	'FR61054' => 'Le Bosc-Renoult',
	'FR61055' => 'Boucé',
	'FR61056' => 'Le Bouillon',
	'FR61060' => 'Brethel',
	'FR61061' => 'Bretoncelles',
	'FR61062' => 'Brieux',
	'FR61063' => 'Briouze',
	'FR61064' => 'Brullemail',
	'FR61066' => 'Buré',
	'FR61067' => 'Bures',
	'FR61068' => 'Bursard',
	'FR61069' => 'Cahan',
	'FR61070' => 'Caligny',
	'FR61071' => 'Camembert',
	'FR61072' => 'Canapville',
	'FR61074' => 'Carrouges',
	'FR61075' => 'Ceaucé',
	'FR61076' => 'Le Cercueil',
	'FR61077' => 'Cerisé',
	'FR61078' => 'Cerisy-Belle-Étoile',
	'FR61079' => 'Ceton',
	'FR61080' => 'Chahains',
	'FR61081' => 'Chailloué',
	'FR61082' => 'Le Chalange',
	'FR61084' => 'Champcerie',
	'FR61085' => 'Le Champ-de-la-Pierre',
	'FR61086' => 'Les Champeaux',
	'FR61087' => 'Champeaux-sur-Sarthe',
	'FR61088' => 'Champ-Haut',
	'FR61089' => 'Champosoult',
	'FR61091' => 'Champsecret',
	'FR61092' => 'Chandai',
	'FR61093' => 'Chanu',
	'FR61094' => 'La Chapelle-au-Moine',
	'FR61095' => 'La Chapelle-Biche',
	'FR61096' => 'Rives dAndaine',
	'FR61097' => 'La Chapelle-Montligeon',
	'FR61098' => 'La Chapelle-près-Sées',
	'FR61099' => 'La Chapelle-Souëf',
	'FR61100' => 'La Chapelle-Viel',
	'FR61101' => 'Le Château-dAlmenêches',
	'FR61102' => 'Le Châtellier',
	'FR61103' => 'Chaumont',
	'FR61104' => 'La Chaux',
	'FR61105' => 'Chemilli',
	'FR61107' => 'Ciral',
	'FR61108' => 'Cisai-Saint-Aubin',
	'FR61111' => 'Colombiers',
	'FR61113' => 'Comblot',
	'FR61114' => 'Commeaux',
	'FR61116' => 'Sablons sur Huisne',
	'FR61117' => 'Condé-sur-Sarthe',
	'FR61118' => 'Corbon',
	'FR61120' => 'Coudehard',
	'FR61121' => 'Coulimer',
	'FR61122' => 'Coulmer',
	'FR61123' => 'Coulonces',
	'FR61124' => 'La Coulonche',
	'FR61126' => 'Coulonges-sur-Sarthe',
	'FR61129' => 'Courgeon',
	'FR61130' => 'Courgeoût',
	'FR61133' => 'Courtomer',
	'FR61137' => 'Craménil',
	'FR61138' => 'Croisilles',
	'FR61139' => 'Crouttes',
	'FR61140' => 'Crulai',
	'FR61141' => 'Cuissai',
	'FR61142' => 'Dame-Marie',
	'FR61143' => 'Damigny',
	'FR61145' => 'Domfront en Poiraie',
	'FR61146' => 'Dompierre',
	'FR61148' => 'Durcet',
	'FR61149' => 'Échalou',
	'FR61150' => 'Échauffour',
	'FR61151' => 'Écorcei',
	'FR61152' => 'Écorches',
	'FR61153' => 'Écouché-les-Vallées',
	'FR61156' => 'Essay',
	'FR61158' => 'Faverolles',
	'FR61159' => 'Fay',
	'FR61160' => 'Feings',
	'FR61162' => 'La Ferrière-au-Doyen',
	'FR61163' => 'La Ferrière-aux-Étangs',
	'FR61164' => 'La Ferrière-Béchet',
	'FR61165' => 'La Ferrière-Bochard',
	'FR61166' => 'Ferrières-la-Verrerie',
	'FR61167' => 'La Ferté-en-Ouche',
	'FR61168' => 'La Ferté Macé',
	'FR61169' => 'Flers',
	'FR61170' => 'Fleuré',
	'FR61171' => 'Fontaine-les-Bassets',
	'FR61176' => 'Francheville',
	'FR61178' => 'La Fresnaie-Fayel',
	'FR61180' => 'Fresnay-le-Samson',
	'FR61181' => 'Gacé',
	'FR61182' => 'Gandelain',
	'FR61183' => 'Gâprée',
	'FR61187' => 'Les Genettes',
	'FR61188' => 'La Genevraie',
	'FR61189' => 'Giel-Courteilles',
	'FR61190' => 'Ginai',
	'FR61192' => 'Godisson',
	'FR61193' => 'La Gonfrière',
	'FR61194' => 'Monts-sur-Orne',
	'FR61195' => 'Le Grais',
	'FR61196' => 'Belforêt-en-Perche',
	'FR61197' => 'Guêprei',
	'FR61198' => 'Guerquesalles',
	'FR61199' => 'Habloville',
	'FR61202' => 'Hauterive',
	'FR61203' => 'Héloup',
	'FR61206' => 'LHôme-Chamondot',
	'FR61207' => 'Igé',
	'FR61208' => 'Irai',
	'FR61209' => 'Joué-du-Bois',
	'FR61210' => 'Joué-du-Plain',
	'FR61211' => 'Juvigny Val dAndaine',
	'FR61212' => 'Juvigny-sur-Orne',
	'FR61213' => 'Lalacelle',
	'FR61214' => 'LAigle',
	'FR61215' => 'Laleu',
	'FR61216' => 'La Lande-de-Goult',
	'FR61217' => 'La Lande-de-Lougé',
	'FR61218' => 'La Lande-Patry',
	'FR61219' => 'La Lande-Saint-Siméon',
	'FR61221' => 'Landigou',
	'FR61222' => 'Landisacq',
	'FR61224' => 'Larré',
	'FR61225' => 'Lignères',
	'FR61227' => 'Lignou',
	'FR61228' => 'LOrée-dÉcouves',
	'FR61229' => 'Loisail',
	'FR61230' => 'Longny les Villages',
	'FR61232' => 'Lonlay-lAbbaye',
	'FR61233' => 'Lonlay-le-Tesson',
	'FR61234' => 'Lonrai',
	'FR61237' => 'Lougé-sur-Maire',
	'FR61238' => 'Louvières-en-Auge',
	'FR61240' => 'Macé',
	'FR61241' => 'La Madeleine-Bouvet',
	'FR61242' => 'Le Mage',
	'FR61243' => 'Magny-le-Désert',
	'FR61244' => 'Mahéru',
	'FR61248' => 'Mantilly',
	'FR61251' => 'Marchemaisons',
	'FR61252' => 'Mardilly',
	'FR61255' => 'Mauves-sur-Huisne',
	'FR61256' => 'Médavy',
	'FR61257' => 'Méhoudin',
	'FR61258' => 'Le Mêle-sur-Sarthe',
	'FR61259' => 'Le Ménil-Bérard',
	'FR61260' => 'Le Ménil-de-Briouze',
	'FR61261' => 'Le Ménil-Broût',
	'FR61262' => 'Le Ménil-Ciboult',
	'FR61263' => 'Ménil-Erreux',
	'FR61264' => 'Ménil-Froger',
	'FR61265' => 'Ménil-Gondouin',
	'FR61266' => 'Le Ménil-Guyon',
	'FR61267' => 'Ménil-Hermei',
	'FR61268' => 'Ménil-Hubert-en-Exmes',
	'FR61269' => 'Ménil-Hubert-sur-Orne',
	'FR61271' => 'Le Ménil-Scelleur',
	'FR61272' => 'Le Ménil-Vicomte',
	'FR61273' => 'Ménil-Vin',
	'FR61274' => 'Les Menus',
	'FR61275' => 'Le Merlerault',
	'FR61276' => 'Merri',
	'FR61277' => 'La Mesnière',
	'FR61278' => 'Messei',
	'FR61279' => 'Mieuxcé',
	'FR61281' => 'Moncy',
	'FR61283' => 'Montabard',
	'FR61284' => 'Montchevrel',
	'FR61286' => 'Montgaudry',
	'FR61287' => 'Montilly-sur-Noireau',
	'FR61288' => 'Montmerrei',
	'FR61289' => 'Mont-Ormel',
	'FR61290' => 'Montreuil-au-Houlme',
	'FR61291' => 'Montreuil-la-Cambe',
	'FR61292' => 'Montsecret-Clairefougère',
	'FR61293' => 'Mortagne-au-Perche',
	'FR61294' => 'Mortrée',
	'FR61295' => 'La Motte-Fouquet',
	'FR61297' => 'Moulins-la-Marche',
	'FR61298' => 'Moulins-sur-Orne',
	'FR61300' => 'Moutiers-au-Perche',
	'FR61301' => 'Neauphe-sous-Essai',
	'FR61302' => 'Neauphe-sur-Dive',
	'FR61303' => 'Nécy',
	'FR61304' => 'Neuilly-le-Bisson',
	'FR61307' => 'Neuville-sur-Touques',
	'FR61308' => 'Neuvy-au-Houlme',
	'FR61309' => 'Perche en Nocé',
	'FR61310' => 'Nonant-le-Pin',
	'FR61314' => 'Occagnes',
	'FR61316' => 'Ommoy',
	'FR61317' => 'Orgères',
	'FR61319' => 'Origny-le-Roux',
	'FR61321' => 'Pacé',
	'FR61322' => 'Parfondeval',
	'FR61323' => 'Le Pas-Saint-lHomer',
	'FR61324' => 'Passais Villages',
	'FR61326' => 'Perrou',
	'FR61327' => 'Pervenchères',
	'FR61328' => 'Le Pin-au-Haras',
	'FR61329' => 'Le Pin-la-Garenne',
	'FR61330' => 'Planches',
	'FR61331' => 'Le Plantis',
	'FR61332' => 'Pointel',
	'FR61333' => 'Pontchardon',
	'FR61336' => 'Pouvrai',
	'FR61339' => 'Putanges-le-Lac',
	'FR61341' => 'Écouves',
	'FR61342' => 'Rai',
	'FR61344' => 'Rânes',
	'FR61345' => 'Rémalard en Perche',
	'FR61346' => 'Le Renouard',
	'FR61347' => 'Résenlieu',
	'FR61348' => 'Réveillon',
	'FR61349' => 'Ri',
	'FR61350' => 'La Roche-Mabile',
	'FR61351' => 'Roiville',
	'FR61352' => 'Rônai',
	'FR61357' => 'Rouperroux',
	'FR61358' => 'Sai',
	'FR61360' => 'Saint-Agnan-sur-Sarthe',
	'FR61361' => 'Saint-André-de-Briouze',
	'FR61362' => 'Saint-André-de-Messei',
	'FR61363' => 'Saint-Aquilin-de-Corbion',
	'FR61365' => 'Saint-Aubin-dAppenai',
	'FR61366' => 'Saint-Aubin-de-Bonneval',
	'FR61367' => 'Saint-Aubin-de-Courteraie',
	'FR61369' => 'Saint-Bômer-les-Forges',
	'FR61370' => 'Saint-Brice',
	'FR61371' => 'Saint-Brice-sous-Rânes',
	'FR61372' => 'Saint-Céneri-le-Gérei',
	'FR61373' => 'Sainte-Céronne-lès-Mortagne',
	'FR61374' => 'Saint-Christophe-de-Chaulieu',
	'FR61375' => 'Boischampré',
	'FR61376' => 'Saint-Clair-de-Halouze',
	'FR61379' => 'Saint-Cyr-la-Rosière',
	'FR61381' => 'Saint-Denis-sur-Huisne',
	'FR61382' => 'Saint-Denis-sur-Sarthon',
	'FR61384' => 'Saint-Ellier-les-Bois',
	'FR61385' => 'Saint-Evroult-de-Montfort',
	'FR61386' => 'Saint-Evroult-Notre-Dame-du-Bois',
	'FR61387' => 'Saint-Fraimbault',
	'FR61388' => 'Saint-Fulgent-des-Ormes',
	'FR61389' => 'Sainte-Gauburge-Sainte-Colombe',
	'FR61390' => 'Saint-Georges-dAnnebecq',
	'FR61391' => 'Saint-Georges-des-Groseillers',
	'FR61392' => 'Saint-Germain-dAunay',
	'FR61393' => 'Saint-Germain-de-Clairefeuille',
	'FR61394' => 'Saint-Germain-de-la-Coudre',
	'FR61395' => 'Saint-Germain-des-Grois',
	'FR61396' => 'Saint-Germain-de-Martigny',
	'FR61397' => 'Saint-Germain-du-Corbéis',
	'FR61398' => 'Saint-Germain-le-Vieux',
	'FR61399' => 'Saint-Gervais-des-Sablons',
	'FR61400' => 'Saint-Gervais-du-Perron',
	'FR61401' => 'Saint-Gilles-des-Marais',
	'FR61402' => 'Saint-Hilaire-de-Briouze',
	'FR61404' => 'Saint-Hilaire-le-Châtel',
	'FR61405' => 'Saint-Hilaire-sur-Erre',
	'FR61406' => 'Saint-Hilaire-sur-Risle',
	'FR61407' => 'Sainte-Honorine-la-Chardonne',
	'FR61408' => 'Sainte-Honorine-la-Guillaume',
	'FR61411' => 'Saint-Jouin-de-Blavou',
	'FR61412' => 'Saint-Julien-sur-Sarthe',
	'FR61413' => 'Saint-Lambert-sur-Dive',
	'FR61414' => 'Saint-Langis-lès-Mortagne',
	'FR61415' => 'Saint-Léger-sur-Sarthe',
	'FR61416' => 'Saint-Léonard-des-Parcs',
	'FR61418' => 'Saint-Mard-de-Réno',
	'FR61419' => 'Sainte-Marguerite-de-Carrouges',
	'FR61420' => 'Sainte-Marie-la-Robert',
	'FR61421' => 'Saint-Mars-dÉgrenne',
	'FR61422' => 'Les Aspres',
	'FR61423' => 'Saint-Martin-dÉcublei',
	'FR61424' => 'Saint-Martin-des-Landes',
	'FR61425' => 'Saint-Martin-des-Pézerits',
	'FR61426' => 'Saint-Martin-du-Vieux-Bellême',
	'FR61427' => 'Saint-Martin-lAiguillon',
	'FR61429' => 'Charencey',
	'FR61432' => 'Saint-Michel-Tubœuf',
	'FR61433' => 'Saint-Nicolas-des-Bois',
	'FR61435' => 'Saint-Nicolas-de-Sommaire',
	'FR61436' => 'Sainte-Opportune',
	'FR61438' => 'Saint-Ouen-de-Sécherouvre',
	'FR61439' => 'Saint-Ouen-le-Brisoult',
	'FR61440' => 'Saint-Ouen-sur-Iton',
	'FR61442' => 'Saint-Patrice-du-Désert',
	'FR61443' => 'Saint-Paul',
	'FR61444' => 'Saint-Philbert-sur-Orne',
	'FR61445' => 'Saint-Pierre-dEntremont',
	'FR61446' => 'Saint-Pierre-des-Loges',
	'FR61447' => 'Saint-Pierre-du-Regard',
	'FR61448' => 'Saint-Pierre-la-Bruyère',
	'FR61450' => 'Saint-Quentin-de-Blavou',
	'FR61451' => 'Saint-Quentin-les-Chardonnets',
	'FR61452' => 'Saint-Roch-sur-Égrenne',
	'FR61453' => 'Saint-Sauveur-de-Carrouges',
	'FR61454' => 'Sainte-Scolasse-sur-Sarthe',
	'FR61456' => 'Saint-Sulpice-sur-Risle',
	'FR61457' => 'Saint-Symphorien-des-Bruyères',
	'FR61459' => 'Saires-la-Verrerie',
	'FR61460' => 'Sap-en-Auge',
	'FR61461' => 'Le Sap-André',
	'FR61462' => 'Sarceaux',
	'FR61463' => 'Les Monts dAndaine',
	'FR61464' => 'Sées',
	'FR61466' => 'La Selle-la-Forge',
	'FR61467' => 'Semallé',
	'FR61472' => 'Sévigny',
	'FR61473' => 'Sevrai',
	'FR61474' => 'Gouffern en Auge',
	'FR61475' => 'Soligny-la-Trappe',
	'FR61476' => 'Suré',
	'FR61479' => 'Tanques',
	'FR61480' => 'Tanville',
	'FR61481' => 'Tellières-le-Plessis',
	'FR61482' => 'Tessé-Froulay',
	'FR61483' => 'Bagnoles de lOrne Normandie',
	'FR61484' => 'Val-au-Perche',
	'FR61485' => 'Ticheville',
	'FR61486' => 'Tinchebray-Bocage',
	'FR61487' => 'Torchamp',
	'FR61488' => 'Touquettes',
	'FR61490' => 'Tournai-sur-Dive',
	'FR61491' => 'Tourouvre au Perche',
	'FR61492' => 'Trémont',
	'FR61493' => 'La Trinité-des-Laitiers',
	'FR61494' => 'Trun',
	'FR61497' => 'Valframbert',
	'FR61498' => 'Vaunoise',
	'FR61499' => 'Les Ventes-de-Bourse',
	'FR61500' => 'La Ventrouze',
	'FR61501' => 'Verrières',
	'FR61502' => 'Vidai',
	'FR61503' => 'Vieux-Pont',
	'FR61505' => 'Villedieu-lès-Bailleul',
	'FR61507' => 'Villiers-sous-Mortagne',
	'FR61508' => 'Vimoutiers',
	'FR61510' => 'Vitrai-sous-Laigle',
	'FR61512' => 'Les Yveteaux',
	'FR62001' => 'Ablain-Saint-Nazaire',
	'FR62002' => 'Ablainzevelle',
	'FR62003' => 'Acheville',
	'FR62004' => 'Achicourt',
	'FR62005' => 'Achiet-le-Grand',
	'FR62006' => 'Achiet-le-Petit',
	'FR62007' => 'Acq',
	'FR62008' => 'Acquin-Westbécourt',
	'FR62009' => 'Adinfer',
	'FR62010' => 'Affringues',
	'FR62011' => 'Agnez-lès-Duisans',
	'FR62012' => 'Agnières',
	'FR62013' => 'Agny',
	'FR62014' => 'Aire-sur-la-Lys',
	'FR62015' => 'Airon-Notre-Dame',
	'FR62016' => 'Airon-Saint-Vaast',
	'FR62017' => 'Aix-en-Ergny',
	'FR62018' => 'Aix-en-Issart',
	'FR62019' => 'Aix-Noulette',
	'FR62020' => 'Alembon',
	'FR62021' => 'Alette',
	'FR62022' => 'Alincthun',
	'FR62023' => 'Allouagne',
	'FR62024' => 'Alquines',
	'FR62025' => 'Ambleteuse',
	'FR62026' => 'Ambricourt',
	'FR62027' => 'Ambrines',
	'FR62028' => 'Ames',
	'FR62029' => 'Amettes',
	'FR62030' => 'Amplier',
	'FR62031' => 'Andres',
	'FR62032' => 'Angres',
	'FR62033' => 'Annay',
	'FR62034' => 'Annequin',
	'FR62035' => 'Annezin',
	'FR62036' => 'Anvin',
	'FR62037' => 'Anzin-Saint-Aubin',
	'FR62038' => 'Ardres',
	'FR62039' => 'Arleux-en-Gohelle',
	'FR62040' => 'Arques',
	'FR62041' => 'Arras',
	'FR62042' => 'Athies',
	'FR62043' => 'Les Attaques',
	'FR62044' => 'Attin',
	'FR62045' => 'Aubigny-en-Artois',
	'FR62046' => 'Aubin-Saint-Vaast',
	'FR62047' => 'Aubrometz',
	'FR62048' => 'Auchel',
	'FR62049' => 'Auchy-au-Bois',
	'FR62050' => 'Auchy-lès-Hesdin',
	'FR62051' => 'Auchy-les-Mines',
	'FR62052' => 'Audembert',
	'FR62053' => 'Audincthun',
	'FR62054' => 'Audinghen',
	'FR62055' => 'Audrehem',
	'FR62056' => 'Audresselles',
	'FR62057' => 'Audruicq',
	'FR62058' => 'Aumerval',
	'FR62059' => 'Autingues',
	'FR62060' => 'Auxi-le-Château',
	'FR62061' => 'Averdoingt',
	'FR62062' => 'Avesnes',
	'FR62063' => 'Avesnes-le-Comte',
	'FR62064' => 'Avesnes-lès-Bapaume',
	'FR62065' => 'Avion',
	'FR62066' => 'Avondance',
	'FR62067' => 'Avroult',
	'FR62068' => 'Ayette',
	'FR62069' => 'Azincourt',
	'FR62070' => 'Bailleul-aux-Cornailles',
	'FR62071' => 'Bailleul-lès-Pernes',
	'FR62072' => 'Bailleulmont',
	'FR62073' => 'Bailleul-Sir-Berthoult',
	'FR62074' => 'Bailleulval',
	'FR62075' => 'Baincthun',
	'FR62076' => 'Bainghen',
	'FR62077' => 'Bajus',
	'FR62078' => 'Balinghem',
	'FR62079' => 'Bancourt',
	'FR62080' => 'Bapaume',
	'FR62081' => 'Baralle',
	'FR62082' => 'Barastre',
	'FR62083' => 'Barlin',
	'FR62084' => 'Barly',
	'FR62085' => 'Basseux',
	'FR62086' => 'Bavincourt',
	'FR62087' => 'Bayenghem-lès-Éperlecques',
	'FR62088' => 'Bayenghem-lès-Seninghem',
	'FR62089' => 'Bazinghen',
	'FR62090' => 'Béalencourt',
	'FR62091' => 'Beaudricourt',
	'FR62092' => 'Beaufort-Blavincourt',
	'FR62093' => 'Beaulencourt',
	'FR62094' => 'Beaumerie-Saint-Martin',
	'FR62095' => 'Beaumetz-lès-Aire',
	'FR62096' => 'Beaumetz-lès-Cambrai',
	'FR62097' => 'Beaumetz-lès-Loges',
	'FR62099' => 'Beaurains',
	'FR62100' => 'Beaurainville',
	'FR62101' => 'Beauvois',
	'FR62102' => 'Bécourt',
	'FR62103' => 'Béhagnies',
	'FR62104' => 'Bellebrune',
	'FR62105' => 'Belle-et-Houllefort',
	'FR62106' => 'Bellonne',
	'FR62107' => 'Bénifontaine',
	'FR62108' => 'Berck',
	'FR62109' => 'Bergueneuse',
	'FR62111' => 'Berlencourt-le-Cauroy',
	'FR62112' => 'Berles-au-Bois',
	'FR62113' => 'Berles-Monchel',
	'FR62114' => 'Bermicourt',
	'FR62115' => 'Berneville',
	'FR62116' => 'Bernieulles',
	'FR62117' => 'Bertincourt',
	'FR62118' => 'Béthonsart',
	'FR62119' => 'Béthune',
	'FR62120' => 'Beugin',
	'FR62121' => 'Beugnâtre',
	'FR62122' => 'Beugny',
	'FR62123' => 'Beussent',
	'FR62124' => 'Beutin',
	'FR62125' => 'Beuvrequen',
	'FR62126' => 'Beuvry',
	'FR62127' => 'Bezinghem',
	'FR62128' => 'Biache-Saint-Vaast',
	'FR62129' => 'Biefvillers-lès-Bapaume',
	'FR62130' => 'Bienvillers-au-Bois',
	'FR62131' => 'Bihucourt',
	'FR62132' => 'Billy-Berclau',
	'FR62133' => 'Billy-Montigny',
	'FR62134' => 'Bimont',
	'FR62135' => 'Blairville',
	'FR62137' => 'Blangerval-Blangermont',
	'FR62138' => 'Blangy-sur-Ternoise',
	'FR62139' => 'Blendecques',
	'FR62140' => 'Bléquin',
	'FR62141' => 'Blessy',
	'FR62142' => 'Blingel',
	'FR62143' => 'Boffles',
	'FR62144' => 'Boiry-Becquerelle',
	'FR62145' => 'Boiry-Notre-Dame',
	'FR62146' => 'Boiry-Saint-Martin',
	'FR62147' => 'Boiry-Sainte-Rictrude',
	'FR62148' => 'Bois-Bernard',
	'FR62149' => 'Boisdinghem',
	'FR62150' => 'Boisjean',
	'FR62151' => 'Boisleux-au-Mont',
	'FR62152' => 'Boisleux-Saint-Marc',
	'FR62153' => 'Bomy',
	'FR62154' => 'Bonnières',
	'FR62155' => 'Bonningues-lès-Ardres',
	'FR62156' => 'Bonningues-lès-Calais',
	'FR62157' => 'Boubers-lès-Hesmond',
	'FR62158' => 'Boubers-sur-Canche',
	'FR62160' => 'Boulogne-sur-Mer',
	'FR62161' => 'Bouquehault',
	'FR62162' => 'Bourecq',
	'FR62163' => 'Bouret-sur-Canche',
	'FR62164' => 'Bourlon',
	'FR62165' => 'Bournonville',
	'FR62166' => 'Bours',
	'FR62167' => 'Boursin',
	'FR62168' => 'Bourthes',
	'FR62169' => 'Bouvelinghem',
	'FR62170' => 'Bouvigny-Boyeffles',
	'FR62171' => 'Boyaval',
	'FR62172' => 'Boyelles',
	'FR62173' => 'Brebières',
	'FR62174' => 'Brêmes',
	'FR62175' => 'Brévillers',
	'FR62176' => 'Bréxent-Énocq',
	'FR62177' => 'Brimeux',
	'FR62178' => 'Bruay-la-Buissière',
	'FR62179' => 'Brunembert',
	'FR62180' => 'Brias',
	'FR62181' => 'Bucquoy',
	'FR62182' => 'Buire-au-Bois',
	'FR62183' => 'Buire-le-Sec',
	'FR62184' => 'Buissy',
	'FR62185' => 'Bullecourt',
	'FR62186' => 'Bully-les-Mines',
	'FR62187' => 'Buneville',
	'FR62188' => 'Burbure',
	'FR62189' => 'Bus',
	'FR62190' => 'Busnes',
	'FR62191' => 'Caffiers',
	'FR62192' => 'Cagnicourt',
	'FR62193' => 'Calais',
	'FR62194' => 'Calonne-Ricouart',
	'FR62195' => 'Calonne-sur-la-Lys',
	'FR62196' => 'La Calotterie',
	'FR62197' => 'Camblain-Châtelain',
	'FR62198' => 'Cambligneul',
	'FR62199' => 'Camblain-lAbbé',
	'FR62200' => 'Cambrin',
	'FR62201' => 'Camiers',
	'FR62202' => 'Campagne-lès-Boulonnais',
	'FR62203' => 'Campagne-lès-Guines',
	'FR62204' => 'Campagne-lès-Hesdin',
	'FR62205' => 'Campagne-lès-Wardrecques',
	'FR62206' => 'Campigneulles-les-Grandes',
	'FR62207' => 'Campigneulles-les-Petites',
	'FR62208' => 'Canettemont',
	'FR62209' => 'Canlers',
	'FR62211' => 'Capelle-Fermont',
	'FR62212' => 'Capelle-lès-Hesdin',
	'FR62213' => 'Carency',
	'FR62214' => 'Carly',
	'FR62215' => 'Carvin',
	'FR62216' => 'La Cauchie',
	'FR62217' => 'Cauchy-à-la-Tour',
	'FR62218' => 'Caucourt',
	'FR62219' => 'Caumont',
	'FR62220' => 'Cavron-Saint-Martin',
	'FR62221' => 'Chelers',
	'FR62222' => 'Chériennes',
	'FR62223' => 'Chérisy',
	'FR62224' => 'Chocques',
	'FR62225' => 'Clairmarais',
	'FR62227' => 'Clenleu',
	'FR62228' => 'Clerques',
	'FR62229' => 'Cléty',
	'FR62230' => 'Colembert',
	'FR62231' => 'Colline-Beaumont',
	'FR62232' => 'La Comté',
	'FR62233' => 'Conchil-le-Temple',
	'FR62234' => 'Conchy-sur-Canche',
	'FR62235' => 'Condette',
	'FR62236' => 'Contes',
	'FR62237' => 'Conteville-lès-Boulogne',
	'FR62238' => 'Conteville-en-Ternois',
	'FR62239' => 'Coquelles',
	'FR62240' => 'Corbehem',
	'FR62241' => 'Cormont',
	'FR62242' => 'Couin',
	'FR62243' => 'Coullemont',
	'FR62244' => 'Coulogne',
	'FR62245' => 'Coulomby',
	'FR62246' => 'Coupelle-Neuve',
	'FR62247' => 'Coupelle-Vieille',
	'FR62248' => 'Courcelles-le-Comte',
	'FR62249' => 'Courcelles-lès-Lens',
	'FR62250' => 'Courrières',
	'FR62251' => 'Courset',
	'FR62252' => 'La Couture',
	'FR62253' => 'Couturelle',
	'FR62254' => 'Coyecques',
	'FR62255' => 'Crémarest',
	'FR62256' => 'Crépy',
	'FR62257' => 'Créquy',
	'FR62258' => 'Croisette',
	'FR62259' => 'Croisilles',
	'FR62260' => 'Croix-en-Ternois',
	'FR62261' => 'Cucq',
	'FR62262' => 'Cuinchy',
	'FR62263' => 'Dainville',
	'FR62264' => 'Dannes',
	'FR62265' => 'Delettes',
	'FR62266' => 'Denier',
	'FR62267' => 'Dennebrœucq',
	'FR62268' => 'Desvres',
	'FR62269' => 'Diéval',
	'FR62270' => 'Divion',
	'FR62271' => 'Dohem',
	'FR62272' => 'Douchy-lès-Ayette',
	'FR62273' => 'Doudeauville',
	'FR62274' => 'Dourges',
	'FR62275' => 'Douriez',
	'FR62276' => 'Douvrin',
	'FR62277' => 'Drocourt',
	'FR62278' => 'Drouvin-le-Marais',
	'FR62279' => 'Duisans',
	'FR62280' => 'Dury',
	'FR62281' => 'Echinghen',
	'FR62282' => 'Éclimeux',
	'FR62283' => 'Écoivres',
	'FR62284' => 'Écourt-Saint-Quentin',
	'FR62285' => 'Écoust-Saint-Mein',
	'FR62286' => 'Ecquedecques',
	'FR62288' => 'Ecques',
	'FR62289' => 'Écuires',
	'FR62290' => 'Écurie',
	'FR62291' => 'Éleu-dit-Leauwette',
	'FR62292' => 'Elnes',
	'FR62293' => 'Embry',
	'FR62295' => 'Enquin-lez-Guinegatte',
	'FR62296' => 'Enquin-sur-Baillons',
	'FR62297' => 'Éperlecques',
	'FR62298' => 'Épinoy',
	'FR62299' => 'Eps',
	'FR62300' => 'Équihen-Plage',
	'FR62301' => 'Équirre',
	'FR62302' => 'Ergny',
	'FR62303' => 'Érin',
	'FR62304' => 'Erny-Saint-Julien',
	'FR62306' => 'Ervillers',
	'FR62307' => 'Escalles',
	'FR62308' => 'Escœuilles',
	'FR62309' => 'Esquerdes',
	'FR62310' => 'Essars',
	'FR62311' => 'Estevelles',
	'FR62312' => 'Estrée',
	'FR62313' => 'Estrée-Blanche',
	'FR62314' => 'Estrée-Cauchy',
	'FR62315' => 'Estréelles',
	'FR62316' => 'Estrée-Wamin',
	'FR62317' => 'Étaing',
	'FR62318' => 'Étaples',
	'FR62319' => 'Éterpigny',
	'FR62320' => 'Étrun',
	'FR62321' => 'Évin-Malmaison',
	'FR62322' => 'Famechon',
	'FR62323' => 'Fampoux',
	'FR62324' => 'Farbus',
	'FR62325' => 'Fauquembergues',
	'FR62326' => 'Favreuil',
	'FR62327' => 'Febvin-Palfart',
	'FR62328' => 'Ferfay',
	'FR62329' => 'Ferques',
	'FR62330' => 'Festubert',
	'FR62331' => 'Feuchy',
	'FR62332' => 'Ficheux',
	'FR62333' => 'Fiefs',
	'FR62334' => 'Fiennes',
	'FR62335' => 'Fillièvres',
	'FR62336' => 'Fléchin',
	'FR62337' => 'Flers',
	'FR62338' => 'Fleurbaix',
	'FR62339' => 'Fleury',
	'FR62340' => 'Floringhem',
	'FR62341' => 'Foncquevillers',
	'FR62342' => 'Fontaine-lès-Boulans',
	'FR62343' => 'Fontaine-lès-Croisilles',
	'FR62344' => 'Fontaine-lès-Hermans',
	'FR62345' => 'Fontaine-lÉtalon',
	'FR62346' => 'Fortel-en-Artois',
	'FR62347' => 'Fosseux',
	'FR62348' => 'Foufflin-Ricametz',
	'FR62349' => 'Fouquereuil',
	'FR62350' => 'Fouquières-lès-Béthune',
	'FR62351' => 'Fouquières-lès-Lens',
	'FR62352' => 'Framecourt',
	'FR62353' => 'Frémicourt',
	'FR62354' => 'Frencq',
	'FR62355' => 'Fresnes-lès-Montauban',
	'FR62356' => 'Fresnicourt-le-Dolmen',
	'FR62357' => 'Fresnoy',
	'FR62358' => 'Fresnoy-en-Gohelle',
	'FR62359' => 'Fressin',
	'FR62360' => 'Fréthun',
	'FR62361' => 'Frévent',
	'FR62362' => 'Frévillers',
	'FR62363' => 'Frévin-Capelle',
	'FR62364' => 'Fruges',
	'FR62365' => 'Galametz',
	'FR62366' => 'Gauchin-Légal',
	'FR62367' => 'Gauchin-Verloingt',
	'FR62368' => 'Gaudiempré',
	'FR62369' => 'Gavrelle',
	'FR62370' => 'Gennes-Ivergny',
	'FR62371' => 'Givenchy-en-Gohelle',
	'FR62372' => 'Givenchy-le-Noble',
	'FR62373' => 'Givenchy-lès-la-Bassée',
	'FR62374' => 'Gomiécourt',
	'FR62375' => 'Gommecourt',
	'FR62376' => 'Gonnehem',
	'FR62377' => 'Gosnay',
	'FR62378' => 'Gouves',
	'FR62379' => 'Gouy-en-Artois',
	'FR62380' => 'Gouy-Servins',
	'FR62381' => 'Gouy-en-Ternois',
	'FR62382' => 'Gouy-Saint-André',
	'FR62383' => 'Gouy-sous-Bellonne',
	'FR62384' => 'Graincourt-lès-Havrincourt',
	'FR62385' => 'Grand-Rullecourt',
	'FR62386' => 'Grenay',
	'FR62387' => 'Grévillers',
	'FR62388' => 'Grigny',
	'FR62389' => 'Grincourt-lès-Pas',
	'FR62390' => 'Groffliers',
	'FR62391' => 'Guarbecque',
	'FR62392' => 'Guémappe',
	'FR62393' => 'Guemps',
	'FR62395' => 'Guigny',
	'FR62396' => 'Guinecourt',
	'FR62397' => 'Guînes',
	'FR62398' => 'Guisy',
	'FR62399' => 'Habarcq',
	'FR62400' => 'Haillicourt',
	'FR62401' => 'Haisnes',
	'FR62402' => 'Halinghen',
	'FR62403' => 'Hallines',
	'FR62404' => 'Halloy',
	'FR62405' => 'Hamblain-les-Prés',
	'FR62406' => 'Hamelincourt',
	'FR62407' => 'Ham-en-Artois',
	'FR62408' => 'Hames-Boucres',
	'FR62409' => 'Hannescamps',
	'FR62410' => 'Haplincourt',
	'FR62411' => 'Haravesnes',
	'FR62412' => 'Hardinghen',
	'FR62413' => 'Harnes',
	'FR62414' => 'Haucourt',
	'FR62415' => 'Haute-Avesnes',
	'FR62416' => 'Hautecloque',
	'FR62418' => 'Hauteville',
	'FR62419' => 'Haut-Loquin',
	'FR62421' => 'Havrincourt',
	'FR62422' => 'Hébuterne',
	'FR62423' => 'Helfaut',
	'FR62424' => 'Hendecourt-lès-Cagnicourt',
	'FR62425' => 'Hendecourt-lès-Ransart',
	'FR62426' => 'Héninel',
	'FR62427' => 'Hénin-Beaumont',
	'FR62428' => 'Hénin-sur-Cojeul',
	'FR62429' => 'Henneveux',
	'FR62430' => 'Hénu',
	'FR62432' => 'Herbinghen',
	'FR62433' => 'Héricourt',
	'FR62434' => 'La Herlière',
	'FR62435' => 'Herlincourt',
	'FR62436' => 'Herlin-le-Sec',
	'FR62437' => 'Herly',
	'FR62438' => 'Hermaville',
	'FR62439' => 'Hermelinghen',
	'FR62440' => 'Hermies',
	'FR62441' => 'Hermin',
	'FR62442' => 'Hernicourt',
	'FR62443' => 'Hersin-Coupigny',
	'FR62444' => 'Hervelinghen',
	'FR62445' => 'Hesdigneul-lès-Béthune',
	'FR62446' => 'Hesdigneul-lès-Boulogne',
	'FR62447' => 'Hesdin',
	'FR62448' => 'Hesdin-lAbbé',
	'FR62449' => 'Hesmond',
	'FR62450' => 'Hestrus',
	'FR62451' => 'Heuchin',
	'FR62452' => 'Heuringhem',
	'FR62453' => 'Hézecques',
	'FR62454' => 'Hinges',
	'FR62455' => 'Hocquinghen',
	'FR62456' => 'Houchin',
	'FR62457' => 'Houdain',
	'FR62458' => 'Houlle',
	'FR62459' => 'Houvin-Houvigneul',
	'FR62460' => 'Hubersent',
	'FR62461' => 'Huby-Saint-Leu',
	'FR62462' => 'Huclier',
	'FR62463' => 'Hucqueliers',
	'FR62464' => 'Hulluch',
	'FR62465' => 'Humbercamps',
	'FR62466' => 'Humbert',
	'FR62467' => 'Humerœuille',
	'FR62468' => 'Humières',
	'FR62469' => 'Inchy-en-Artois',
	'FR62470' => 'Incourt',
	'FR62471' => 'Bellinghem',
	'FR62472' => 'Inxent',
	'FR62473' => 'Isbergues',
	'FR62474' => 'Isques',
	'FR62475' => 'Ivergny',
	'FR62476' => 'Izel-lès-Équerchin',
	'FR62477' => 'Izel-lès-Hameau',
	'FR62478' => 'Journy',
	'FR62479' => 'Labeuvrière',
	'FR62480' => 'Labourse',
	'FR62481' => 'Labroye',
	'FR62483' => 'Lacres',
	'FR62484' => 'Lagnicourt-Marcel',
	'FR62485' => 'Laires',
	'FR62486' => 'Lambres',
	'FR62487' => 'Landrethun-le-Nord',
	'FR62488' => 'Landrethun-lès-Ardres',
	'FR62489' => 'Lapugnoy',
	'FR62490' => 'Lattre-Saint-Quentin',
	'FR62491' => 'Laventie',
	'FR62492' => 'Lebiez',
	'FR62493' => 'Lebucquière',
	'FR62494' => 'Léchelle',
	'FR62495' => 'Ledinghem',
	'FR62496' => 'Lefaux',
	'FR62497' => 'Leforest',
	'FR62498' => 'Lens',
	'FR62499' => 'Lépine',
	'FR62500' => 'Lespesses',
	'FR62501' => 'Lespinoy',
	'FR62502' => 'Lestrem',
	'FR62503' => 'Leubringhen',
	'FR62504' => 'Leulinghem',
	'FR62505' => 'Leulinghen-Bernes',
	'FR62506' => 'Licques',
	'FR62507' => 'Liencourt',
	'FR62508' => 'Lières',
	'FR62509' => 'Liettres',
	'FR62510' => 'Liévin',
	'FR62511' => 'Lignereuil',
	'FR62512' => 'Ligny-lès-Aire',
	'FR62513' => 'Ligny-sur-Canche',
	'FR62514' => 'Ligny-Saint-Flochel',
	'FR62515' => 'Ligny-Thilloy',
	'FR62516' => 'Lillers',
	'FR62517' => 'Linghem',
	'FR62518' => 'Linzeux',
	'FR62519' => 'Lisbourg',
	'FR62520' => 'Locon',
	'FR62521' => 'La Loge',
	'FR62522' => 'Loison-sur-Créquoise',
	'FR62523' => 'Loison-sous-Lens',
	'FR62524' => 'Longfossé',
	'FR62525' => 'Longuenesse',
	'FR62526' => 'Longueville',
	'FR62527' => 'Longvilliers',
	'FR62528' => 'Loos-en-Gohelle',
	'FR62529' => 'Lorgies',
	'FR62530' => 'Lottinghen',
	'FR62531' => 'Louches',
	'FR62532' => 'Lozinghem',
	'FR62533' => 'Lugy',
	'FR62534' => 'Lumbres',
	'FR62535' => 'La Madelaine-sous-Montreuil',
	'FR62536' => 'Magnicourt-en-Comte',
	'FR62537' => 'Magnicourt-sur-Canche',
	'FR62538' => 'Maintenay',
	'FR62539' => 'Maisnil',
	'FR62540' => 'Maisnil-lès-Ruitz',
	'FR62541' => 'Maisoncelle',
	'FR62542' => 'Maizières',
	'FR62543' => 'Mametz',
	'FR62544' => 'Manin',
	'FR62545' => 'Maninghem',
	'FR62546' => 'Maninghen-Henne',
	'FR62547' => 'Marant',
	'FR62548' => 'Marck',
	'FR62549' => 'Marconne',
	'FR62550' => 'Marconnelle',
	'FR62551' => 'Marenla',
	'FR62552' => 'Maresquel-Ecquemicourt',
	'FR62553' => 'Marest',
	'FR62554' => 'Maresville',
	'FR62555' => 'Marles-les-Mines',
	'FR62556' => 'Marles-sur-Canche',
	'FR62557' => 'Marœuil',
	'FR62558' => 'Marquay',
	'FR62559' => 'Marquion',
	'FR62560' => 'Marquise',
	'FR62561' => 'Martinpuich',
	'FR62562' => 'Matringhem',
	'FR62563' => 'Mazingarbe',
	'FR62564' => 'Mazinghem',
	'FR62565' => 'Mencas',
	'FR62566' => 'Menneville',
	'FR62567' => 'Mentque-Nortbécourt',
	'FR62568' => 'Mercatel',
	'FR62569' => 'Merck-Saint-Liévin',
	'FR62570' => 'Méricourt',
	'FR62571' => 'Merlimont',
	'FR62572' => 'Metz-en-Couture',
	'FR62573' => 'Meurchin',
	'FR62574' => 'Mingoval',
	'FR62576' => 'Moncheaux-lès-Frévent',
	'FR62577' => 'Monchel-sur-Canche',
	'FR62578' => 'Monchiet',
	'FR62579' => 'Monchy-au-Bois',
	'FR62580' => 'Monchy-Breton',
	'FR62581' => 'Monchy-Cayeux',
	'FR62582' => 'Monchy-le-Preux',
	'FR62583' => 'Mondicourt',
	'FR62584' => 'Mont-Bernanchon',
	'FR62585' => 'Montcavrel',
	'FR62586' => 'Montenescourt',
	'FR62587' => 'Montigny-en-Gohelle',
	'FR62588' => 'Montreuil',
	'FR62589' => 'Mont-Saint-Éloi',
	'FR62590' => 'Monts-en-Ternois',
	'FR62591' => 'Morchies',
	'FR62592' => 'Moringhem',
	'FR62593' => 'Morval',
	'FR62594' => 'Mory',
	'FR62595' => 'Moulle',
	'FR62596' => 'Mouriez',
	'FR62597' => 'Moyenneville',
	'FR62598' => 'Muncq-Nieurlet',
	'FR62599' => 'Nabringhen',
	'FR62600' => 'Nédon',
	'FR62601' => 'Nédonchel',
	'FR62602' => 'Nempont-Saint-Firmin',
	'FR62603' => 'Nesles',
	'FR62604' => 'Neufchâtel-Hardelot',
	'FR62605' => 'Neulette',
	'FR62606' => 'Neuve-Chapelle',
	'FR62607' => 'Neuville-au-Cornet',
	'FR62608' => 'Neuville-Bourjonval',
	'FR62609' => 'Neuville-Saint-Vaast',
	'FR62610' => 'Neuville-sous-Montreuil',
	'FR62611' => 'Neuville-Vitasse',
	'FR62612' => 'Neuvireuil',
	'FR62613' => 'Nielles-lès-Bléquin',
	'FR62614' => 'Nielles-lès-Ardres',
	'FR62615' => 'Nielles-lès-Calais',
	'FR62616' => 'Nœux-lès-Auxi',
	'FR62617' => 'Nœux-les-Mines',
	'FR62618' => 'Nordausques',
	'FR62619' => 'Noreuil',
	'FR62620' => 'Norrent-Fontes',
	'FR62621' => 'Nortkerque',
	'FR62622' => 'Nort-Leulinghem',
	'FR62623' => 'Nouvelle-Église',
	'FR62624' => 'Noyelles-Godault',
	'FR62625' => 'Noyelles-lès-Humières',
	'FR62626' => 'Noyelles-lès-Vermelles',
	'FR62627' => 'Noyelles-sous-Bellonne',
	'FR62628' => 'Noyelles-sous-Lens',
	'FR62629' => 'Noyellette',
	'FR62630' => 'Noyelle-Vion',
	'FR62631' => 'Nuncq-Hautecôte',
	'FR62632' => 'Oblinghem',
	'FR62633' => 'Œuf-en-Ternois',
	'FR62634' => 'Offekerque',
	'FR62635' => 'Offin',
	'FR62636' => 'Offrethun',
	'FR62637' => 'Oignies',
	'FR62638' => 'Oisy-le-Verger',
	'FR62639' => 'Oppy',
	'FR62640' => 'Orville',
	'FR62641' => 'Ostreville',
	'FR62642' => 'Ourton',
	'FR62643' => 'Outreau',
	'FR62644' => 'Ouve-Wirquin',
	'FR62645' => 'Oye-Plage',
	'FR62646' => 'Palluel',
	'FR62647' => 'Le Parcq',
	'FR62648' => 'Parenty',
	'FR62649' => 'Pas-en-Artois',
	'FR62650' => 'Pelves',
	'FR62651' => 'Penin',
	'FR62652' => 'Pernes',
	'FR62653' => 'Pernes-lès-Boulogne',
	'FR62654' => 'Peuplingues',
	'FR62655' => 'Pierremont',
	'FR62656' => 'Pihem',
	'FR62657' => 'Pihen-lès-Guînes',
	'FR62658' => 'Pittefaux',
	'FR62659' => 'Planques',
	'FR62660' => 'Plouvain',
	'FR62661' => 'Bouin-Plumoison',
	'FR62662' => 'Polincove',
	'FR62663' => 'Pommera',
	'FR62664' => 'Pommier',
	'FR62665' => 'Le Ponchel',
	'FR62666' => 'Pont-à-Vendin',
	'FR62667' => 'Le Portel',
	'FR62668' => 'Prédefin',
	'FR62669' => 'Pressy',
	'FR62670' => 'Preures',
	'FR62671' => 'Pronville-en-Artois',
	'FR62672' => 'Puisieux',
	'FR62673' => 'Quéant',
	'FR62674' => 'Quelmes',
	'FR62675' => 'Quercamps',
	'FR62676' => 'Quernes',
	'FR62677' => 'Le Quesnoy-en-Artois',
	'FR62678' => 'Quesques',
	'FR62679' => 'Questrecques',
	'FR62680' => 'Quiéry-la-Motte',
	'FR62681' => 'Quiestède',
	'FR62682' => 'Quilen',
	'FR62683' => 'Quœux-Haut-Maînil',
	'FR62684' => 'Racquinghem',
	'FR62685' => 'Radinghem',
	'FR62686' => 'Ramecourt',
	'FR62688' => 'Rang-du-Fliers',
	'FR62689' => 'Ransart',
	'FR62690' => 'Raye-sur-Authie',
	'FR62691' => 'Saint-Augustin',
	'FR62692' => 'Rebergues',
	'FR62693' => 'Rebreuve-Ranchicourt',
	'FR62694' => 'Rebreuve-sur-Canche',
	'FR62695' => 'Rebreuviette',
	'FR62696' => 'Reclinghem',
	'FR62697' => 'Récourt',
	'FR62698' => 'Recques-sur-Course',
	'FR62699' => 'Recques-sur-Hem',
	'FR62700' => 'Regnauville',
	'FR62701' => 'Rely',
	'FR62702' => 'Remilly-Wirquin',
	'FR62703' => 'Rémy',
	'FR62704' => 'Renty',
	'FR62705' => 'Rety',
	'FR62706' => 'Richebourg',
	'FR62708' => 'Riencourt-lès-Bapaume',
	'FR62709' => 'Riencourt-lès-Cagnicourt',
	'FR62710' => 'Rimboval',
	'FR62711' => 'Rinxent',
	'FR62712' => 'Rivière',
	'FR62713' => 'Robecq',
	'FR62714' => 'Roclincourt',
	'FR62715' => 'Rocquigny',
	'FR62716' => 'Rodelinghem',
	'FR62717' => 'Roëllecourt',
	'FR62718' => 'Rœux',
	'FR62719' => 'Rollancourt',
	'FR62720' => 'Rombly',
	'FR62721' => 'Roquetoire',
	'FR62722' => 'Rougefay',
	'FR62723' => 'Roussent',
	'FR62724' => 'Rouvroy',
	'FR62725' => 'Royon',
	'FR62726' => 'Ruisseauville',
	'FR62727' => 'Ruitz',
	'FR62728' => 'Rumaucourt',
	'FR62729' => 'Rumilly',
	'FR62730' => 'Ruminghem',
	'FR62731' => 'Ruyaulcourt',
	'FR62732' => 'Sachin',
	'FR62733' => 'Sailly-au-Bois',
	'FR62734' => 'Sailly-en-Ostrevent',
	'FR62735' => 'Sailly-Labourse',
	'FR62736' => 'Sailly-sur-la-Lys',
	'FR62737' => 'Sains-en-Gohelle',
	'FR62738' => 'Sains-lès-Fressin',
	'FR62739' => 'Sains-lès-Marquion',
	'FR62740' => 'Sains-lès-Pernes',
	'FR62741' => 'Saint-Amand',
	'FR62742' => 'Saint-Aubin',
	'FR62743' => 'Sainte-Austreberthe',
	'FR62744' => 'Sainte-Catherine',
	'FR62745' => 'Saint-Denœux',
	'FR62746' => 'Saint-Étienne-au-Mont',
	'FR62747' => 'Saint-Floris',
	'FR62748' => 'Saint-Folquin',
	'FR62749' => 'Saint-Georges',
	'FR62750' => 'Saint-Hilaire-Cottes',
	'FR62751' => 'Saint-Inglevert',
	'FR62752' => 'Saint-Josse',
	'FR62753' => 'Saint-Laurent-Blangy',
	'FR62754' => 'Saint-Léger',
	'FR62755' => 'Saint-Léonard',
	'FR62756' => 'Sainte-Marie-Kerque',
	'FR62757' => 'Saint-Martin-lez-Tatinghem',
	'FR62758' => 'Saint-Martin-Boulogne',
	'FR62759' => 'Saint-Martin-Choquel',
	'FR62760' => 'Saint-Martin-dHardinghem',
	'FR62761' => 'Saint-Martin-sur-Cojeul',
	'FR62762' => 'Saint-Michel-sous-Bois',
	'FR62763' => 'Saint-Michel-sur-Ternoise',
	'FR62764' => 'Saint-Nicolas',
	'FR62765' => 'Saint-Omer',
	'FR62766' => 'Saint-Omer-Capelle',
	'FR62767' => 'Saint-Pol-sur-Ternoise',
	'FR62768' => 'Saint-Rémy-au-Bois',
	'FR62769' => 'Saint-Tricat',
	'FR62770' => 'Saint-Venant',
	'FR62771' => 'Sallaumines',
	'FR62772' => 'Salperwick',
	'FR62773' => 'Samer',
	'FR62774' => 'Sangatte',
	'FR62775' => 'Sanghen',
	'FR62776' => 'Sapignies',
	'FR62777' => 'Le Sars',
	'FR62778' => 'Sars-le-Bois',
	'FR62779' => 'Sarton',
	'FR62780' => 'Sauchy-Cauchy',
	'FR62781' => 'Sauchy-Lestrée',
	'FR62782' => 'Saudemont',
	'FR62783' => 'Saulchoy',
	'FR62784' => 'Saulty',
	'FR62785' => 'Savy-Berlette',
	'FR62786' => 'Selles',
	'FR62787' => 'Sempy',
	'FR62788' => 'Seninghem',
	'FR62789' => 'Senlecques',
	'FR62790' => 'Senlis',
	'FR62791' => 'Séricourt',
	'FR62792' => 'Serques',
	'FR62793' => 'Servins',
	'FR62794' => 'Setques',
	'FR62795' => 'Sibiville',
	'FR62796' => 'Simencourt',
	'FR62797' => 'Siracourt',
	'FR62798' => 'Sombrin',
	'FR62799' => 'Sorrus',
	'FR62800' => 'Souastre',
	'FR62801' => 'Souchez',
	'FR62802' => 'Le Souich',
	'FR62803' => 'Surques',
	'FR62804' => 'Sus-Saint-Léger',
	'FR62805' => 'Tangry',
	'FR62806' => 'Tardinghen',
	'FR62808' => 'Teneur',
	'FR62809' => 'Ternas',
	'FR62810' => 'Thélus',
	'FR62811' => 'Thérouanne',
	'FR62812' => 'Thiembronne',
	'FR62813' => 'La Thieuloye',
	'FR62814' => 'Thièvres',
	'FR62815' => 'Tigny-Noyelle',
	'FR62816' => 'Tilloy-lès-Hermaville',
	'FR62817' => 'Tilloy-lès-Mofflaines',
	'FR62818' => 'Tilly-Capelle',
	'FR62819' => 'Tilques',
	'FR62820' => 'Tincques',
	'FR62821' => 'Tingry',
	'FR62822' => 'Tollent',
	'FR62823' => 'Torcy',
	'FR62824' => 'Tortefontaine',
	'FR62825' => 'Tortequesne',
	'FR62826' => 'Le Touquet-Paris-Plage',
	'FR62827' => 'Tournehem-sur-la-Hem',
	'FR62828' => 'Tramecourt',
	'FR62829' => 'Le Transloy',
	'FR62830' => 'Trescault',
	'FR62831' => 'Troisvaux',
	'FR62832' => 'Tubersent',
	'FR62833' => 'Vacquerie-le-Boucq',
	'FR62834' => 'Vacqueriette-Erquières',
	'FR62835' => 'Valhuon',
	'FR62836' => 'Vaudricourt',
	'FR62837' => 'Vaudringhem',
	'FR62838' => 'Vaulx',
	'FR62839' => 'Vaulx-Vraucourt',
	'FR62840' => 'Vélu',
	'FR62841' => 'Vendin-lès-Béthune',
	'FR62842' => 'Vendin-le-Vieil',
	'FR62843' => 'Verchin',
	'FR62844' => 'Verchocq',
	'FR62845' => 'Verlincthun',
	'FR62846' => 'Vermelles',
	'FR62847' => 'Verquigneul',
	'FR62848' => 'Verquin',
	'FR62849' => 'Verton',
	'FR62850' => 'Vieil-Hesdin',
	'FR62851' => 'Vieille-Chapelle',
	'FR62852' => 'Vieille-Église',
	'FR62853' => 'Vieil-Moutier',
	'FR62854' => 'Villers-au-Bois',
	'FR62855' => 'Villers-au-Flos',
	'FR62856' => 'Villers-Brûlin',
	'FR62857' => 'Villers-Châtel',
	'FR62858' => 'Villers-lès-Cagnicourt',
	'FR62859' => 'Villers-lHôpital',
	'FR62860' => 'Villers-Sir-Simon',
	'FR62861' => 'Vimy',
	'FR62862' => 'Vincly',
	'FR62863' => 'Violaines',
	'FR62864' => 'Vis-en-Artois',
	'FR62865' => 'Vitry-en-Artois',
	'FR62866' => 'Waben',
	'FR62867' => 'Wacquinghen',
	'FR62868' => 'Wail',
	'FR62869' => 'Wailly',
	'FR62870' => 'Wailly-Beaucamp',
	'FR62871' => 'Wambercourt',
	'FR62872' => 'Wamin',
	'FR62873' => 'Wancourt',
	'FR62874' => 'Wanquetin',
	'FR62875' => 'Wardrecques',
	'FR62876' => 'Warlencourt-Eaucourt',
	'FR62877' => 'Warlincourt-lès-Pas',
	'FR62878' => 'Warlus',
	'FR62879' => 'Warluzel',
	'FR62880' => 'Le Wast',
	'FR62881' => 'Beauvoir-Wavans',
	'FR62882' => 'Wavrans-sur-lAa',
	'FR62883' => 'Wavrans-sur-Ternoise',
	'FR62885' => 'Westrehem',
	'FR62886' => 'Wicquinghem',
	'FR62887' => 'Widehem',
	'FR62888' => 'Wierre-au-Bois',
	'FR62889' => 'Wierre-Effroy',
	'FR62890' => 'Willeman',
	'FR62891' => 'Willencourt',
	'FR62892' => 'Willerval',
	'FR62893' => 'Wimereux',
	'FR62894' => 'Wimille',
	'FR62895' => 'Wingles',
	'FR62896' => 'Wirwignes',
	'FR62897' => 'Wismes',
	'FR62898' => 'Wisques',
	'FR62899' => 'Wissant',
	'FR62900' => 'Witternesse',
	'FR62901' => 'Wittes',
	'FR62902' => 'Wizernes',
	'FR62903' => 'Zoteux',
	'FR62904' => 'Zouafques',
	'FR62905' => 'Zudausques',
	'FR62906' => 'Zutkerque',
	'FR62907' => 'Libercourt',
	'FR62908' => 'La Capelle-lès-Boulogne',
	'FR62909' => 'Ytres',
	'FR63001' => 'Aigueperse',
	'FR63002' => 'Aix-la-Fayette',
	'FR63003' => 'Ambert',
	'FR63004' => 'Les Ancizes-Comps',
	'FR63005' => 'Antoingt',
	'FR63006' => 'Anzat-le-Luguet',
	'FR63007' => 'Apchat',
	'FR63008' => 'Arconsat',
	'FR63009' => 'Ardes',
	'FR63010' => 'Arlanc',
	'FR63011' => 'Ars-les-Favets',
	'FR63012' => 'Artonne',
	'FR63013' => 'Aubiat',
	'FR63014' => 'Aubière',
	'FR63015' => 'Aubusson-dAuvergne',
	'FR63016' => 'Augerolles',
	'FR63017' => 'Augnat',
	'FR63019' => 'Aulnat',
	'FR63020' => 'Aurières',
	'FR63021' => 'Authezat',
	'FR63022' => 'Auzat-la-Combelle',
	'FR63023' => 'Auzelles',
	'FR63024' => 'Avèze',
	'FR63025' => 'Ayat-sur-Sioule',
	'FR63026' => 'Aydat',
	'FR63027' => 'Baffie',
	'FR63028' => 'Bagnols',
	'FR63029' => 'Bansat',
	'FR63030' => 'Bas-et-Lezat',
	'FR63031' => 'Beaulieu',
	'FR63032' => 'Beaumont',
	'FR63033' => 'Beaumont-lès-Randan',
	'FR63034' => 'Beauregard-lÉvêque',
	'FR63035' => 'Beauregard-Vendon',
	'FR63036' => 'Bergonne',
	'FR63037' => 'Bertignat',
	'FR63038' => 'Besse-et-Saint-Anastaise',
	'FR63039' => 'Beurières',
	'FR63040' => 'Billom',
	'FR63041' => 'Biollet',
	'FR63042' => 'Blanzat',
	'FR63043' => 'Blot-lÉglise',
	'FR63044' => 'Bongheat',
	'FR63045' => 'Bort-lÉtang',
	'FR63046' => 'Boudes',
	'FR63047' => 'La Bourboule',
	'FR63048' => 'Bourg-Lastic',
	'FR63049' => 'Bouzel',
	'FR63050' => 'Brassac-les-Mines',
	'FR63051' => 'Brenat',
	'FR63052' => 'Le Breuil-sur-Couze',
	'FR63053' => 'Briffons',
	'FR63054' => 'Le Broc',
	'FR63055' => 'Bromont-Lamothe',
	'FR63056' => 'Brousse',
	'FR63057' => 'Le Brugeron',
	'FR63058' => 'Bulhon',
	'FR63059' => 'Busséol',
	'FR63060' => 'Bussières',
	'FR63061' => 'Bussières-et-Pruns',
	'FR63062' => 'Buxières-sous-Montaigut',
	'FR63063' => 'Cébazat',
	'FR63064' => 'La Celle',
	'FR63065' => 'Ceilloux',
	'FR63066' => 'Celles-sur-Durolle',
	'FR63067' => 'La Cellette',
	'FR63069' => 'Le Cendre',
	'FR63070' => 'Ceyrat',
	'FR63071' => 'Ceyssat',
	'FR63072' => 'Chabreloche',
	'FR63073' => 'Chadeleuf',
	'FR63074' => 'Chalus',
	'FR63075' => 'Chamalières',
	'FR63076' => 'Chambon-sur-Dolore',
	'FR63077' => 'Chambon-sur-Lac',
	'FR63079' => 'Champagnat-le-Jeune',
	'FR63080' => 'Champeix',
	'FR63081' => 'Champétières',
	'FR63082' => 'Champs',
	'FR63083' => 'Chanat-la-Mouteyre',
	'FR63084' => 'Chanonat',
	'FR63085' => 'Chapdes-Beaufort',
	'FR63086' => 'La Chapelle-Agnon',
	'FR63087' => 'La Chapelle-Marcousse',
	'FR63088' => 'La Chapelle-sur-Usson',
	'FR63089' => 'Chappes',
	'FR63090' => 'Chaptuzat',
	'FR63091' => 'Charbonnier-les-Mines',
	'FR63092' => 'Charbonnières-les-Varennes',
	'FR63093' => 'Charbonnières-les-Vieilles',
	'FR63094' => 'Charensat',
	'FR63095' => 'Charnat',
	'FR63096' => 'Chas',
	'FR63097' => 'Chassagne',
	'FR63098' => 'Chastreix',
	'FR63099' => 'Châteaugay',
	'FR63100' => 'Châteauneuf-les-Bains',
	'FR63101' => 'Château-sur-Cher',
	'FR63102' => 'Châteldon',
	'FR63103' => 'Châtel-Guyon',
	'FR63104' => 'La Chaulme',
	'FR63105' => 'Chaumont-le-Bourg',
	'FR63106' => 'Chauriat',
	'FR63107' => 'Chavaroux',
	'FR63108' => 'Le Cheix',
	'FR63109' => 'Chidrac',
	'FR63110' => 'Cisternes-la-Forêt',
	'FR63111' => 'Clémensat',
	'FR63112' => 'Clerlande',
	'FR63113' => 'Clermont-Ferrand',
	'FR63114' => 'Collanges',
	'FR63115' => 'Combrailles',
	'FR63116' => 'Combronde',
	'FR63117' => 'Compains',
	'FR63118' => 'Condat-en-Combraille',
	'FR63119' => 'Condat-lès-Montboissier',
	'FR63120' => 'Corent',
	'FR63121' => 'Coudes',
	'FR63122' => 'Courgoul',
	'FR63123' => 'Cournols',
	'FR63124' => 'Cournon-dAuvergne',
	'FR63125' => 'Courpière',
	'FR63126' => 'Le Crest',
	'FR63128' => 'Crevant-Laveine',
	'FR63129' => 'Cros',
	'FR63130' => 'La Crouzille',
	'FR63131' => 'Culhat',
	'FR63132' => 'Cunlhat',
	'FR63134' => 'Dauzat-sur-Vodable',
	'FR63135' => 'Davayat',
	'FR63136' => 'Domaize',
	'FR63137' => 'Doranges',
	'FR63138' => 'Dorat',
	'FR63139' => 'Dore-lÉglise',
	'FR63140' => 'Durmignat',
	'FR63141' => 'Durtol',
	'FR63142' => 'Échandelys',
	'FR63143' => 'Effiat',
	'FR63144' => 'Égliseneuve-dEntraigues',
	'FR63145' => 'Égliseneuve-des-Liards',
	'FR63146' => 'Égliseneuve-près-Billom',
	'FR63147' => 'Églisolles',
	'FR63148' => 'Ennezat',
	'FR63149' => 'Entraigues',
	'FR63150' => 'Enval',
	'FR63151' => 'Escoutoux',
	'FR63152' => 'Espinasse',
	'FR63153' => 'Espinchal',
	'FR63154' => 'Espirat',
	'FR63155' => 'Estandeuil',
	'FR63156' => 'Esteil',
	'FR63157' => 'Fayet-le-Château',
	'FR63158' => 'Fayet-Ronaye',
	'FR63159' => 'Fernoël',
	'FR63160' => 'Aulhat-Flat',
	'FR63161' => 'La Forie',
	'FR63162' => 'Fournols',
	'FR63163' => 'Gelles',
	'FR63164' => 'Gerzat',
	'FR63165' => 'Giat',
	'FR63166' => 'Gignat',
	'FR63167' => 'Gimeaux',
	'FR63168' => 'Glaine-Montaigut',
	'FR63169' => 'La Godivelle',
	'FR63170' => 'La Goutelle',
	'FR63171' => 'Gouttières',
	'FR63172' => 'Grandeyrolles',
	'FR63173' => 'Grandrif',
	'FR63174' => 'Grandval',
	'FR63175' => 'Herment',
	'FR63176' => 'Heume-lÉglise',
	'FR63177' => 'Isserteaux',
	'FR63178' => 'Issoire',
	'FR63179' => 'Job',
	'FR63180' => 'Joze',
	'FR63181' => 'Jozerand',
	'FR63182' => 'Jumeaux',
	'FR63183' => 'Labessette',
	'FR63184' => 'Lachaux',
	'FR63185' => 'Lamontgie',
	'FR63186' => 'Landogne',
	'FR63187' => 'Lapeyrouse',
	'FR63188' => 'Laps',
	'FR63189' => 'Laqueuille',
	'FR63190' => 'Larodde',
	'FR63191' => 'Lastic',
	'FR63192' => 'La Tour-dAuvergne',
	'FR63193' => 'Lempdes',
	'FR63194' => 'Lempty',
	'FR63195' => 'Lezoux',
	'FR63196' => 'Limons',
	'FR63197' => 'Lisseuil',
	'FR63198' => 'Loubeyrat',
	'FR63199' => 'Ludesse',
	'FR63200' => 'Lussat',
	'FR63201' => 'Luzillat',
	'FR63202' => 'Madriat',
	'FR63203' => 'Malauzat',
	'FR63204' => 'Malintrat',
	'FR63205' => 'Manglieu',
	'FR63206' => 'Manzat',
	'FR63207' => 'Marat',
	'FR63208' => 'Marcillat',
	'FR63209' => 'Mareugheol',
	'FR63210' => 'Maringues',
	'FR63211' => 'Marsac-en-Livradois',
	'FR63212' => 'Marsat',
	'FR63213' => 'Les Martres-dArtière',
	'FR63214' => 'Les Martres-de-Veyre',
	'FR63215' => 'Martres-sur-Morge',
	'FR63216' => 'Mauzun',
	'FR63218' => 'Mayres',
	'FR63219' => 'Mazaye',
	'FR63220' => 'Mazoires',
	'FR63221' => 'Medeyrolles',
	'FR63222' => 'Meilhaud',
	'FR63223' => 'Menat',
	'FR63224' => 'Ménétrol',
	'FR63225' => 'Messeix',
	'FR63226' => 'Mur-sur-Allier',
	'FR63227' => 'Mirefleurs',
	'FR63228' => 'Miremont',
	'FR63229' => 'Moissat',
	'FR63230' => 'Le Monestier',
	'FR63231' => 'La Monnerie-le-Montel',
	'FR63232' => 'Mons',
	'FR63233' => 'Montaigut',
	'FR63234' => 'Montaigut-le-Blanc',
	'FR63235' => 'Montcel',
	'FR63236' => 'Mont-Dore',
	'FR63237' => 'Montel-de-Gelat',
	'FR63238' => 'Montfermy',
	'FR63239' => 'Montmorin',
	'FR63240' => 'Montpensier',
	'FR63241' => 'Montpeyroux',
	'FR63242' => 'Moriat',
	'FR63243' => 'Moureuille',
	'FR63244' => 'Chambaron sur Morge',
	'FR63245' => 'Mozac',
	'FR63246' => 'Murat-le-Quaire',
	'FR63247' => 'Murol',
	'FR63248' => 'Nébouzat',
	'FR63249' => 'Néronde-sur-Dore',
	'FR63250' => 'Neschers',
	'FR63251' => 'Neuf-Église',
	'FR63252' => 'Neuville',
	'FR63253' => 'Noalhat',
	'FR63254' => 'Nohanent',
	'FR63255' => 'Nonette-Orsonnette',
	'FR63256' => 'Novacelles',
	'FR63257' => 'Olby',
	'FR63258' => 'Olliergues',
	'FR63259' => 'Olloix',
	'FR63260' => 'Olmet',
	'FR63261' => 'Orbeil',
	'FR63262' => 'Orcet',
	'FR63263' => 'Orcines',
	'FR63264' => 'Orcival',
	'FR63265' => 'Orléat',
	'FR63267' => 'Palladuc',
	'FR63268' => 'Pardines',
	'FR63269' => 'Parent',
	'FR63270' => 'Parentignat',
	'FR63271' => 'Paslières',
	'FR63272' => 'Pérignat-lès-Sarliève',
	'FR63273' => 'Pérignat-sur-Allier',
	'FR63274' => 'Perpezat',
	'FR63275' => 'Perrier',
	'FR63276' => 'Peschadoires',
	'FR63277' => 'Peslières',
	'FR63278' => 'Pessat-Villeneuve',
	'FR63279' => 'Picherande',
	'FR63280' => 'Pignols',
	'FR63281' => 'Pionsat',
	'FR63282' => 'Plauzat',
	'FR63283' => 'Pontaumur',
	'FR63284' => 'Pont-du-Château',
	'FR63285' => 'Pontgibaud',
	'FR63286' => 'Pouzol',
	'FR63287' => 'Les Pradeaux',
	'FR63288' => 'Prompsat',
	'FR63289' => 'Prondines',
	'FR63290' => 'Pulvérières',
	'FR63291' => 'Puy-Guillaume',
	'FR63292' => 'Puy-Saint-Gulmier',
	'FR63293' => 'Le Quartier',
	'FR63294' => 'Queuille',
	'FR63295' => 'Randan',
	'FR63296' => 'Ravel',
	'FR63297' => 'Reignat',
	'FR63298' => 'La Renaudie',
	'FR63299' => 'Rentières',
	'FR63300' => 'Riom',
	'FR63301' => 'Ris',
	'FR63302' => 'La Roche-Blanche',
	'FR63303' => 'Roche-Charles-la-Mayrand',
	'FR63304' => 'Roche-dAgoux',
	'FR63305' => 'Rochefort-Montagne',
	'FR63306' => 'La Roche-Noire',
	'FR63307' => 'Romagnat',
	'FR63308' => 'Royat',
	'FR63309' => 'Saillant',
	'FR63310' => 'Sainte-Agathe',
	'FR63311' => 'Saint-Agoulin',
	'FR63312' => 'Saint-Alyre-dArlanc',
	'FR63313' => 'Saint-Alyre-ès-Montagne',
	'FR63314' => 'Saint-Amant-Roche-Savine',
	'FR63315' => 'Saint-Amant-Tallende',
	'FR63317' => 'Saint-André-le-Coq',
	'FR63318' => 'Saint-Angel',
	'FR63319' => 'Saint-Anthème',
	'FR63320' => 'Saint-Avit',
	'FR63321' => 'Saint-Babel',
	'FR63322' => 'Saint-Beauzire',
	'FR63323' => 'Saint-Bonnet-le-Bourg',
	'FR63324' => 'Saint-Bonnet-le-Chastel',
	'FR63325' => 'Saint-Bonnet-lès-Allier',
	'FR63326' => 'Saint-Bonnet-près-Orcival',
	'FR63327' => 'Saint-Bonnet-près-Riom',
	'FR63328' => 'Sainte-Catherine',
	'FR63329' => 'Sainte-Christine',
	'FR63330' => 'Saint-Cirgues-sur-Couze',
	'FR63331' => 'Saint-Clément-de-Valorgue',
	'FR63332' => 'Saint-Clément-de-Régnat',
	'FR63333' => 'Saint-Denis-Combarnazat',
	'FR63334' => 'Saint-Dier-dAuvergne',
	'FR63335' => 'Saint-Diéry',
	'FR63336' => 'Saint-Donat',
	'FR63337' => 'Saint-Éloy-la-Glacière',
	'FR63338' => 'Saint-Éloy-les-Mines',
	'FR63339' => 'Saint-Étienne-des-Champs',
	'FR63340' => 'Saint-Étienne-sur-Usson',
	'FR63341' => 'Saint-Ferréol-des-Côtes',
	'FR63342' => 'Saint-Floret',
	'FR63343' => 'Saint-Flour',
	'FR63344' => 'Saint-Gal-sur-Sioule',
	'FR63345' => 'Saint-Genès-Champanelle',
	'FR63346' => 'Saint-Genès-Champespe',
	'FR63347' => 'Saint-Genès-du-Retz',
	'FR63348' => 'Saint-Genès-la-Tourette',
	'FR63349' => 'Saint-Georges-de-Mons',
	'FR63350' => 'Saint-Georges-sur-Allier',
	'FR63351' => 'Saint-Germain-près-Herment',
	'FR63352' => 'Saint-Germain-Lembron',
	'FR63353' => 'Saint-Germain-lHerm',
	'FR63354' => 'Saint-Gervais-dAuvergne',
	'FR63355' => 'Saint-Gervais-sous-Meymont',
	'FR63356' => 'Saint-Gervazy',
	'FR63357' => 'Saint-Hérent',
	'FR63358' => 'Saint-Hilaire-la-Croix',
	'FR63359' => 'Saint-Hilaire-les-Monges',
	'FR63360' => 'Saint-Hilaire',
	'FR63362' => 'Saint-Ignat',
	'FR63363' => 'Saint-Jacques-dAmbur',
	'FR63364' => 'Saint-Jean-dHeurs',
	'FR63365' => 'Saint-Jean-des-Ollières',
	'FR63366' => 'Saint-Jean-en-Val',
	'FR63367' => 'Saint-Jean-Saint-Gervais',
	'FR63368' => 'Saint-Julien-de-Coppel',
	'FR63369' => 'Saint-Julien-la-Geneste',
	'FR63370' => 'Saint-Julien-Puy-Lavèze',
	'FR63371' => 'Saint-Just',
	'FR63372' => 'Saint-Laure',
	'FR63373' => 'Saint-Maigner',
	'FR63374' => 'Saint-Martin-des-Olmes',
	'FR63375' => 'Saint-Martin-des-Plains',
	'FR63376' => 'Saint-Martin-dOllières',
	'FR63377' => 'Saint-Maurice-près-Pionsat',
	'FR63378' => 'Saint-Maurice',
	'FR63379' => 'Saint-Myon',
	'FR63380' => 'Saint-Nectaire',
	'FR63381' => 'Saint-Ours',
	'FR63382' => 'Saint-Pardoux',
	'FR63383' => 'Saint-Pierre-Colamine',
	'FR63384' => 'Saint-Pierre-la-Bourlhonne',
	'FR63385' => 'Saint-Pierre-le-Chastel',
	'FR63386' => 'Saint-Pierre-Roche',
	'FR63387' => 'Saint-Priest-Bramefant',
	'FR63388' => 'Saint-Priest-des-Champs',
	'FR63389' => 'Saint-Quentin-sur-Sauxillanges',
	'FR63390' => 'Saint-Quintin-sur-Sioule',
	'FR63391' => 'Saint-Rémy-de-Blot',
	'FR63392' => 'Saint-Rémy-de-Chargnat',
	'FR63393' => 'Saint-Rémy-sur-Durolle',
	'FR63394' => 'Saint-Romain',
	'FR63395' => 'Saint-Sandoux',
	'FR63396' => 'Saint-Saturnin',
	'FR63397' => 'Saint-Sauves-dAuvergne',
	'FR63398' => 'Saint-Sauveur-la-Sagne',
	'FR63399' => 'Saint-Sulpice',
	'FR63400' => 'Saint-Sylvestre-Pragoulin',
	'FR63401' => 'Saint-Victor-la-Rivière',
	'FR63402' => 'Saint-Victor-Montvianeix',
	'FR63403' => 'Saint-Vincent',
	'FR63404' => 'Saint-Yvoine',
	'FR63405' => 'Sallèdes',
	'FR63406' => 'Sardon',
	'FR63407' => 'Saulzet-le-Froid',
	'FR63408' => 'Sauret-Besserve',
	'FR63409' => 'Saurier',
	'FR63410' => 'Sauvagnat',
	'FR63411' => 'Sauvagnat-Sainte-Marthe',
	'FR63412' => 'Sauvessanges',
	'FR63413' => 'La Sauvetat',
	'FR63414' => 'Sauviat',
	'FR63415' => 'Sauxillanges',
	'FR63416' => 'Savennes',
	'FR63417' => 'Sayat',
	'FR63418' => 'Sermentizon',
	'FR63419' => 'Servant',
	'FR63420' => 'Seychalles',
	'FR63421' => 'Singles',
	'FR63422' => 'Solignat',
	'FR63423' => 'Sugères',
	'FR63424' => 'Surat',
	'FR63425' => 'Tallende',
	'FR63426' => 'Tauves',
	'FR63427' => 'Teilhède',
	'FR63428' => 'Teilhet',
	'FR63429' => 'Ternant-les-Eaux',
	'FR63430' => 'Thiers',
	'FR63431' => 'Thiolières',
	'FR63432' => 'Thuret',
	'FR63433' => 'Tortebesse',
	'FR63434' => 'Tours-sur-Meymont',
	'FR63435' => 'Tourzel-Ronzières',
	'FR63436' => 'Tralaigues',
	'FR63437' => 'Trémouille-Saint-Loup',
	'FR63438' => 'Trézioux',
	'FR63439' => 'Usson',
	'FR63440' => 'Valbeleix',
	'FR63441' => 'Valcivières',
	'FR63442' => 'Valz-sous-Châteauneuf',
	'FR63443' => 'Varennes-sur-Morge',
	'FR63444' => 'Varennes-sur-Usson',
	'FR63445' => 'Vassel',
	'FR63446' => 'Vensat',
	'FR63447' => 'Vergheas',
	'FR63448' => 'Le Vernet-Chaméane',
	'FR63449' => 'Le Vernet-Sainte-Marguerite',
	'FR63450' => 'Verneugheol',
	'FR63451' => 'Vernines',
	'FR63452' => 'Verrières',
	'FR63453' => 'Vertaizon',
	'FR63454' => 'Vertolaye',
	'FR63455' => 'Veyre-Monton',
	'FR63456' => 'Vichel',
	'FR63457' => 'Vic-le-Comte',
	'FR63458' => 'Villeneuve',
	'FR63459' => 'Villeneuve-les-Cerfs',
	'FR63460' => 'Villosanges',
	'FR63461' => 'Vinzelles',
	'FR63462' => 'Virlet',
	'FR63463' => 'Viscomtat',
	'FR63464' => 'Vitrac',
	'FR63465' => 'Viverols',
	'FR63466' => 'Vodable',
	'FR63467' => 'Voingt',
	'FR63468' => 'Vollore-Montagne',
	'FR63469' => 'Vollore-Ville',
	'FR63470' => 'Volvic',
	'FR63471' => 'Youx',
	'FR63472' => 'Yronde-et-Buron',
	'FR63473' => 'Yssac-la-Tourette',
	'FR64001' => 'Aast',
	'FR64002' => 'Abère',
	'FR64003' => 'Abidos',
	'FR64004' => 'Abitain',
	'FR64005' => 'Abos',
	'FR64006' => 'Accous',
	'FR64007' => 'Agnos',
	'FR64008' => 'Ahaxe-Alciette-Bascassan',
	'FR64009' => 'Ahetze',
	'FR64010' => 'Aïcirits-Camou-Suhast',
	'FR64011' => 'Aincille',
	'FR64012' => 'Ainharp',
	'FR64013' => 'Ainhice-Mongelos',
	'FR64014' => 'Ainhoa',
	'FR64015' => 'Alçay-Alçabéhéty-Sunharette',
	'FR64016' => 'Aldudes',
	'FR64017' => 'Alos-Sibas-Abense',
	'FR64018' => 'Amendeuix-Oneix',
	'FR64019' => 'Amorots-Succos',
	'FR64021' => 'Andoins',
	'FR64022' => 'Andrein',
	'FR64023' => 'Angaïs',
	'FR64024' => 'Anglet',
	'FR64025' => 'Angous',
	'FR64026' => 'Anhaux',
	'FR64027' => 'Anos',
	'FR64028' => 'Anoye',
	'FR64029' => 'Aramits',
	'FR64031' => 'Arancou',
	'FR64032' => 'Araujuzon',
	'FR64033' => 'Araux',
	'FR64034' => 'Arbérats-Sillègue',
	'FR64035' => 'Arbonne',
	'FR64036' => 'Arbouet-Sussaute',
	'FR64037' => 'Arbus',
	'FR64038' => 'Arcangues',
	'FR64039' => 'Aren',
	'FR64040' => 'Arette',
	'FR64041' => 'Aressy',
	'FR64042' => 'Argagnon',
	'FR64043' => 'Argelos',
	'FR64044' => 'Arget',
	'FR64045' => 'Arhansus',
	'FR64046' => 'Armendarits',
	'FR64047' => 'Arnéguy',
	'FR64048' => 'Arnos',
	'FR64049' => 'Aroue-Ithorots-Olhaïby',
	'FR64050' => 'Arrast-Larrebieu',
	'FR64051' => 'Arraute-Charritte',
	'FR64052' => 'Arricau-Bordes',
	'FR64053' => 'Arrien',
	'FR64054' => 'Arros-de-Nay',
	'FR64056' => 'Arrosès',
	'FR64057' => 'Arthez-de-Béarn',
	'FR64058' => 'Arthez-dAsson',
	'FR64059' => 'Artigueloutan',
	'FR64060' => 'Artiguelouve',
	'FR64061' => 'Artix',
	'FR64062' => 'Arudy',
	'FR64063' => 'Arzacq-Arraziguet',
	'FR64064' => 'Asasp-Arros',
	'FR64065' => 'Ascain',
	'FR64066' => 'Ascarat',
	'FR64067' => 'Assat',
	'FR64068' => 'Asson',
	'FR64069' => 'Aste-Béon',
	'FR64070' => 'Astis',
	'FR64071' => 'Athos-Aspis',
	'FR64072' => 'Aubertin',
	'FR64073' => 'Aubin',
	'FR64074' => 'Aubous',
	'FR64075' => 'Audaux',
	'FR64077' => 'Auga',
	'FR64078' => 'Auriac',
	'FR64079' => 'Aurions-Idernes',
	'FR64080' => 'Aussevielle',
	'FR64081' => 'Aussurucq',
	'FR64082' => 'Auterrive',
	'FR64083' => 'Autevielle-Saint-Martin-Bideren',
	'FR64084' => 'Aydie',
	'FR64085' => 'Aydius',
	'FR64086' => 'Ayherre',
	'FR64087' => 'Baigts-de-Béarn',
	'FR64088' => 'Balansun',
	'FR64089' => 'Baleix',
	'FR64090' => 'Baliracq-Maumusson',
	'FR64091' => 'Baliros',
	'FR64092' => 'Banca',
	'FR64093' => 'Barcus',
	'FR64094' => 'Bardos',
	'FR64095' => 'Barinque',
	'FR64096' => 'Barraute-Camu',
	'FR64097' => 'Barzun',
	'FR64098' => 'Bassillon-Vauzé',
	'FR64099' => 'Bastanès',
	'FR64100' => 'Bassussarry',
	'FR64101' => 'Baudreix',
	'FR64102' => 'Bayonne',
	'FR64103' => 'Bédeille',
	'FR64104' => 'Bedous',
	'FR64105' => 'Béguios',
	'FR64106' => 'Béhasque-Lapiste',
	'FR64107' => 'Béhorléguy',
	'FR64108' => 'Bellocq',
	'FR64109' => 'Bénéjacq',
	'FR64110' => 'Béost',
	'FR64111' => 'Bentayou-Sérée',
	'FR64112' => 'Bérenx',
	'FR64113' => 'Bergouey-Viellenave',
	'FR64114' => 'Bernadets',
	'FR64115' => 'Berrogain-Laruns',
	'FR64116' => 'Bescat',
	'FR64117' => 'Bésingrand',
	'FR64118' => 'Bétracq',
	'FR64119' => 'Beuste',
	'FR64120' => 'Beyrie-sur-Joyeuse',
	'FR64121' => 'Beyrie-en-Béarn',
	'FR64122' => 'Biarritz',
	'FR64123' => 'Bidache',
	'FR64124' => 'Bidarray',
	'FR64125' => 'Bidart',
	'FR64126' => 'Bidos',
	'FR64127' => 'Bielle',
	'FR64128' => 'Bilhères',
	'FR64129' => 'Billère',
	'FR64130' => 'Biriatou',
	'FR64131' => 'Biron',
	'FR64132' => 'Bizanos',
	'FR64133' => 'Boeil-Bezing',
	'FR64134' => 'Bonloc',
	'FR64135' => 'Bonnut',
	'FR64136' => 'Borce',
	'FR64137' => 'Bordères',
	'FR64138' => 'Bordes',
	'FR64139' => 'Bosdarros',
	'FR64140' => 'Boucau',
	'FR64141' => 'Boueilh-Boueilho-Lasque',
	'FR64142' => 'Bougarber',
	'FR64143' => 'Bouillon',
	'FR64144' => 'Boumourt',
	'FR64145' => 'Bourdettes',
	'FR64146' => 'Bournos',
	'FR64147' => 'Briscous',
	'FR64148' => 'Bruges-Capbis-Mifaget',
	'FR64149' => 'Bugnein',
	'FR64150' => 'Bunus',
	'FR64151' => 'Burgaronne',
	'FR64152' => 'Buros',
	'FR64153' => 'Burosse-Mendousse',
	'FR64154' => 'Bussunarits-Sarrasquette',
	'FR64155' => 'Bustince-Iriberry',
	'FR64156' => 'Buziet',
	'FR64157' => 'Buzy',
	'FR64158' => 'Cabidos',
	'FR64159' => 'Cadillon',
	'FR64160' => 'Cambo-les-Bains',
	'FR64161' => 'Came',
	'FR64162' => 'Camou-Cihigue',
	'FR64165' => 'Cardesse',
	'FR64166' => 'Caro',
	'FR64167' => 'Carrère',
	'FR64168' => 'Carresse-Cassaber',
	'FR64170' => 'Castagnède',
	'FR64171' => 'Casteide-Cami',
	'FR64172' => 'Casteide-Candau',
	'FR64173' => 'Casteide-Doat',
	'FR64174' => 'Castéra-Loubix',
	'FR64175' => 'Castet',
	'FR64176' => 'Castetbon',
	'FR64177' => 'Castétis',
	'FR64178' => 'Castetnau-Camblong',
	'FR64179' => 'Castetner',
	'FR64180' => 'Castetpugon',
	'FR64181' => 'Castillon (Canton dArthez-de-Béarn)',
	'FR64182' => 'Castillon (Canton de Lembeye)',
	'FR64183' => 'Caubios-Loos',
	'FR64184' => 'Cescau',
	'FR64185' => 'Cette-Eygun',
	'FR64186' => 'Charre',
	'FR64187' => 'Charritte-de-Bas',
	'FR64188' => 'Chéraute',
	'FR64189' => 'Ciboure',
	'FR64190' => 'Claracq',
	'FR64191' => 'Coarraze',
	'FR64192' => 'Conchez-de-Béarn',
	'FR64193' => 'Corbère-Abères',
	'FR64194' => 'Coslédaà-Lube-Boast',
	'FR64195' => 'Coublucq',
	'FR64196' => 'Crouseilles',
	'FR64197' => 'Cuqueron',
	'FR64198' => 'Denguin',
	'FR64199' => 'Diusse',
	'FR64200' => 'Doazon',
	'FR64201' => 'Dognen',
	'FR64202' => 'Domezain-Berraute',
	'FR64203' => 'Doumy',
	'FR64204' => 'Eaux-Bonnes',
	'FR64205' => 'Escos',
	'FR64206' => 'Escot',
	'FR64207' => 'Escou',
	'FR64208' => 'Escoubès',
	'FR64209' => 'Escout',
	'FR64210' => 'Escurès',
	'FR64211' => 'Eslourenties-Daban',
	'FR64212' => 'Espéchède',
	'FR64213' => 'Espelette',
	'FR64214' => 'Espès-Undurein',
	'FR64215' => 'Espiute',
	'FR64216' => 'Espoey',
	'FR64217' => 'Esquiule',
	'FR64218' => 'Estérençuby',
	'FR64219' => 'Estialescq',
	'FR64220' => 'Estos',
	'FR64221' => 'Etcharry',
	'FR64222' => 'Etchebar',
	'FR64223' => 'Etsaut',
	'FR64224' => 'Eysus',
	'FR64225' => 'Ance Féas',
	'FR64226' => 'Fichous-Riumayou',
	'FR64227' => 'Gabaston',
	'FR64228' => 'Gabat',
	'FR64229' => 'Gamarthe',
	'FR64230' => 'Gan',
	'FR64231' => 'Garindein',
	'FR64232' => 'Garlède-Mondebat',
	'FR64233' => 'Garlin',
	'FR64234' => 'Garos',
	'FR64235' => 'Garris',
	'FR64236' => 'Gayon',
	'FR64237' => 'Gelos',
	'FR64238' => 'Ger',
	'FR64239' => 'Gerderest',
	'FR64240' => 'Gère-Bélesten',
	'FR64241' => 'Géronce',
	'FR64242' => 'Gestas',
	'FR64243' => 'Géus-dArzacq',
	'FR64244' => 'Geüs-dOloron',
	'FR64245' => 'Goès',
	'FR64246' => 'Gomer',
	'FR64247' => 'Gotein-Libarrenx',
	'FR64249' => 'Guéthary',
	'FR64250' => 'Guiche',
	'FR64251' => 'Guinarthe-Parenties',
	'FR64252' => 'Gurmençon',
	'FR64253' => 'Gurs',
	'FR64254' => 'Hagetaubin',
	'FR64255' => 'Halsou',
	'FR64256' => 'Hasparren',
	'FR64257' => 'Haut-de-Bosdarros',
	'FR64258' => 'Haux',
	'FR64259' => 'Hélette',
	'FR64260' => 'Hendaye',
	'FR64261' => 'Herrère',
	'FR64262' => 'Higuères-Souye',
	'FR64263' => 'LHôpital-dOrion',
	'FR64264' => 'LHôpital-Saint-Blaise',
	'FR64265' => 'Hosta',
	'FR64266' => 'Hours',
	'FR64267' => 'Ibarrolle',
	'FR64268' => 'Idaux-Mendy',
	'FR64269' => 'Idron',
	'FR64270' => 'Igon',
	'FR64271' => 'Iholdy',
	'FR64272' => 'Ilharre',
	'FR64273' => 'Irissarry',
	'FR64274' => 'Irouléguy',
	'FR64275' => 'Ispoure',
	'FR64276' => 'Issor',
	'FR64277' => 'Isturits',
	'FR64279' => 'Itxassou',
	'FR64280' => 'Izeste',
	'FR64281' => 'Jasses',
	'FR64282' => 'Jatxou',
	'FR64283' => 'Jaxu',
	'FR64284' => 'Jurançon',
	'FR64285' => 'Juxue',
	'FR64286' => 'Laà-Mondrans',
	'FR64287' => 'Laàs',
	'FR64288' => 'Labastide-Cézéracq',
	'FR64289' => 'La Bastide-Clairence',
	'FR64290' => 'Labastide-Monréjeau',
	'FR64291' => 'Labastide-Villefranche',
	'FR64292' => 'Labatmale',
	'FR64293' => 'Labatut',
	'FR64294' => 'Labets-Biscay',
	'FR64295' => 'Labeyrie',
	'FR64296' => 'Lacadée',
	'FR64297' => 'Lacarre',
	'FR64298' => 'Lacarry-Arhan-Charritte-de-Haut',
	'FR64299' => 'Lacommande',
	'FR64300' => 'Lacq',
	'FR64301' => 'Lagor',
	'FR64302' => 'Lagos',
	'FR64303' => 'Laguinge-Restoue',
	'FR64304' => 'Lahonce',
	'FR64305' => 'Lahontan',
	'FR64306' => 'Lahourcade',
	'FR64307' => 'Lalongue',
	'FR64308' => 'Lalonquette',
	'FR64309' => 'Lamayou',
	'FR64310' => 'Lanne-en-Barétous',
	'FR64311' => 'Lannecaube',
	'FR64312' => 'Lanneplaà',
	'FR64313' => 'Lantabat',
	'FR64314' => 'Larceveau-Arros-Cibits',
	'FR64315' => 'Laroin',
	'FR64316' => 'Larrau',
	'FR64317' => 'Larressore',
	'FR64318' => 'Larreule',
	'FR64319' => 'Larribar-Sorhapuru',
	'FR64320' => 'Laruns',
	'FR64321' => 'Lasclaveries',
	'FR64322' => 'Lasse',
	'FR64323' => 'Lasserre',
	'FR64324' => 'Lasseube',
	'FR64325' => 'Lasseubetat',
	'FR64326' => 'Lay-Lamidou',
	'FR64327' => 'Lecumberry',
	'FR64328' => 'Ledeuix',
	'FR64329' => 'Lée',
	'FR64330' => 'Lées-Athas',
	'FR64331' => 'Lembeye',
	'FR64332' => 'Lème',
	'FR64334' => 'Léren',
	'FR64335' => 'Lescar',
	'FR64336' => 'Lescun',
	'FR64337' => 'Lespielle',
	'FR64338' => 'Lespourcy',
	'FR64339' => 'Lestelle-Bétharram',
	'FR64340' => 'Lichans-Sunhar',
	'FR64341' => 'Lichos',
	'FR64342' => 'Licq-Athérey',
	'FR64343' => 'Limendous',
	'FR64344' => 'Livron',
	'FR64345' => 'Lohitzun-Oyhercq',
	'FR64346' => 'Lombia',
	'FR64347' => 'Lonçon',
	'FR64348' => 'Lons',
	'FR64349' => 'Loubieng',
	'FR64350' => 'Louhossoa',
	'FR64351' => 'Lourdios-Ichère',
	'FR64352' => 'Lourenties',
	'FR64353' => 'Louvie-Juzon',
	'FR64354' => 'Louvie-Soubiron',
	'FR64355' => 'Louvigny',
	'FR64356' => 'Luc-Armau',
	'FR64357' => 'Lucarré',
	'FR64358' => 'Lucgarier',
	'FR64359' => 'Lucq-de-Béarn',
	'FR64360' => 'Lurbe-Saint-Christau',
	'FR64361' => 'Lussagnet-Lusson',
	'FR64362' => 'Luxe-Sumberraute',
	'FR64363' => 'Lys',
	'FR64364' => 'Macaye',
	'FR64365' => 'Malaussanne',
	'FR64366' => 'Mascaraàs-Haron',
	'FR64367' => 'Maslacq',
	'FR64368' => 'Masparraute',
	'FR64369' => 'Maspie-Lalonquère-Juillacq',
	'FR64370' => 'Maucor',
	'FR64371' => 'Mauléon-Licharre',
	'FR64372' => 'Maure',
	'FR64373' => 'Mazères-Lezons',
	'FR64374' => 'Mazerolles',
	'FR64375' => 'Méharin',
	'FR64376' => 'Meillon',
	'FR64377' => 'Mendionde',
	'FR64378' => 'Menditte',
	'FR64379' => 'Mendive',
	'FR64380' => 'Méracq',
	'FR64381' => 'Méritein',
	'FR64382' => 'Mesplède',
	'FR64383' => 'Mialos',
	'FR64385' => 'Miossens-Lanusse',
	'FR64386' => 'Mirepeix',
	'FR64387' => 'Momas',
	'FR64388' => 'Momy',
	'FR64389' => 'Monassut-Audiracq',
	'FR64390' => 'Moncaup',
	'FR64391' => 'Moncayolle-Larrory-Mendibieu',
	'FR64392' => 'Moncla',
	'FR64393' => 'Monein',
	'FR64394' => 'Monpezat',
	'FR64395' => 'Monségur',
	'FR64396' => 'Mont',
	'FR64397' => 'Montagut',
	'FR64398' => 'Montaner',
	'FR64399' => 'Montardon',
	'FR64400' => 'Montaut',
	'FR64401' => 'Mont-Disse',
	'FR64403' => 'Montfort',
	'FR64404' => 'Montory',
	'FR64405' => 'Morlaàs',
	'FR64406' => 'Morlanne',
	'FR64407' => 'Mouguerre',
	'FR64408' => 'Mouhous',
	'FR64409' => 'Moumour',
	'FR64410' => 'Mourenx',
	'FR64411' => 'Musculdy',
	'FR64412' => 'Nabas',
	'FR64413' => 'Narcastet',
	'FR64414' => 'Narp',
	'FR64415' => 'Navailles-Angos',
	'FR64416' => 'Navarrenx',
	'FR64417' => 'Nay',
	'FR64418' => 'Noguères',
	'FR64419' => 'Nousty',
	'FR64420' => 'Ogenne-Camptort',
	'FR64421' => 'Ogeu-les-Bains',
	'FR64422' => 'Oloron-Sainte-Marie',
	'FR64423' => 'Oraàs',
	'FR64424' => 'Ordiarp',
	'FR64425' => 'Orègue',
	'FR64426' => 'Orin',
	'FR64427' => 'Orion',
	'FR64428' => 'Orriule',
	'FR64429' => 'Orsanco',
	'FR64430' => 'Orthez',
	'FR64431' => 'Os-Marsillon',
	'FR64432' => 'Ossas-Suhare',
	'FR64433' => 'Osse-en-Aspe',
	'FR64434' => 'Ossenx',
	'FR64435' => 'Osserain-Rivareyte',
	'FR64436' => 'Ossès',
	'FR64437' => 'Ostabat-Asme',
	'FR64438' => 'Ouillon',
	'FR64439' => 'Ousse',
	'FR64440' => 'Ozenx-Montestrucq',
	'FR64441' => 'Pagolle',
	'FR64442' => 'Parbayse',
	'FR64443' => 'Pardies',
	'FR64444' => 'Pardies-Piétat',
	'FR64445' => 'Pau',
	'FR64446' => 'Peyrelongue-Abos',
	'FR64447' => 'Piets-Plasence-Moustrou',
	'FR64448' => 'Poey-de-Lescar',
	'FR64449' => 'Poey-dOloron',
	'FR64450' => 'Pomps',
	'FR64451' => 'Ponson-Debat-Pouts',
	'FR64452' => 'Ponson-Dessus',
	'FR64453' => 'Pontacq',
	'FR64454' => 'Pontiacq-Viellepinte',
	'FR64455' => 'Portet',
	'FR64456' => 'Pouliacq',
	'FR64457' => 'Poursiugues-Boucoue',
	'FR64458' => 'Préchacq-Josbaig',
	'FR64459' => 'Préchacq-Navarrenx',
	'FR64460' => 'Précilhon',
	'FR64461' => 'Puyoô',
	'FR64462' => 'Ramous',
	'FR64463' => 'Rébénacq',
	'FR64464' => 'Ribarrouy',
	'FR64465' => 'Riupeyrous',
	'FR64466' => 'Rivehaute',
	'FR64467' => 'Rontignon',
	'FR64468' => 'Roquiague',
	'FR64469' => 'Saint-Abit',
	'FR64470' => 'Saint-Armou',
	'FR64471' => 'Saint-Boès',
	'FR64472' => 'Saint-Castin',
	'FR64473' => 'Sainte-Colome',
	'FR64474' => 'Saint-Dos',
	'FR64475' => 'Sainte-Engrâce',
	'FR64476' => 'Saint-Esteben',
	'FR64477' => 'Saint-Étienne-de-Baïgorry',
	'FR64478' => 'Saint-Faust',
	'FR64479' => 'Saint-Girons-en-Béarn',
	'FR64480' => 'Saint-Gladie-Arrive-Munein',
	'FR64481' => 'Saint-Goin',
	'FR64482' => 'Saint-Jammes',
	'FR64483' => 'Saint-Jean-de-Luz',
	'FR64484' => 'Saint-Jean-le-Vieux',
	'FR64485' => 'Saint-Jean-Pied-de-Port',
	'FR64486' => 'Saint-Jean-Poudge',
	'FR64487' => 'Saint-Just-Ibarre',
	'FR64488' => 'Saint-Laurent-Bretagne',
	'FR64489' => 'Saint-Martin-dArberoue',
	'FR64490' => 'Saint-Martin-dArrossa',
	'FR64491' => 'Saint-Médard',
	'FR64492' => 'Saint-Michel',
	'FR64493' => 'Saint-Palais',
	'FR64494' => 'Saint-Pé-de-Léren',
	'FR64495' => 'Saint-Pée-sur-Nivelle',
	'FR64496' => 'Saint-Pierre-dIrube',
	'FR64498' => 'Saint-Vincent',
	'FR64499' => 'Salies-de-Béarn',
	'FR64500' => 'Salles-Mongiscard',
	'FR64501' => 'Sallespisse',
	'FR64502' => 'Sames',
	'FR64503' => 'Samsons-Lion',
	'FR64504' => 'Sare',
	'FR64505' => 'Sarpourenx',
	'FR64506' => 'Sarrance',
	'FR64507' => 'Saubole',
	'FR64508' => 'Saucède',
	'FR64509' => 'Sauguis-Saint-Étienne',
	'FR64510' => 'Sault-de-Navailles',
	'FR64511' => 'Sauvagnon',
	'FR64512' => 'Sauvelade',
	'FR64513' => 'Sauveterre-de-Béarn',
	'FR64514' => 'Séby',
	'FR64515' => 'Sedze-Maubecq',
	'FR64516' => 'Sedzère',
	'FR64517' => 'Séméacq-Blachon',
	'FR64518' => 'Sendets',
	'FR64519' => 'Serres-Castet',
	'FR64520' => 'Serres-Morlaàs',
	'FR64521' => 'Serres-Sainte-Marie',
	'FR64522' => 'Sévignacq-Meyracq',
	'FR64523' => 'Sévignacq',
	'FR64524' => 'Simacourbe',
	'FR64525' => 'Siros',
	'FR64526' => 'Soumoulou',
	'FR64527' => 'Souraïde',
	'FR64528' => 'Suhescun',
	'FR64529' => 'Sus',
	'FR64530' => 'Susmiou',
	'FR64531' => 'Tabaille-Usquain',
	'FR64532' => 'Tadousse-Ussau',
	'FR64533' => 'Tardets-Sorholus',
	'FR64534' => 'Taron-Sadirac-Viellenave',
	'FR64535' => 'Tarsacq',
	'FR64536' => 'Thèze',
	'FR64537' => 'Trois-Villes',
	'FR64538' => 'Uhart-Cize',
	'FR64539' => 'Uhart-Mixe',
	'FR64540' => 'Urcuit',
	'FR64541' => 'Urdès',
	'FR64542' => 'Urdos',
	'FR64543' => 'Urepel',
	'FR64544' => 'Urost',
	'FR64545' => 'Urrugne',
	'FR64546' => 'Urt',
	'FR64547' => 'Ustaritz',
	'FR64548' => 'Uzan',
	'FR64549' => 'Uzein',
	'FR64550' => 'Uzos',
	'FR64551' => 'Verdets',
	'FR64552' => 'Vialer',
	'FR64554' => 'Viellenave-dArthez',
	'FR64555' => 'Viellenave-de-Navarrenx',
	'FR64556' => 'Vielleségure',
	'FR64557' => 'Vignes',
	'FR64558' => 'Villefranque',
	'FR64559' => 'Viodos-Abense-de-Bas',
	'FR64560' => 'Viven',
	'FR65001' => 'Adast',
	'FR65002' => 'Adé',
	'FR65003' => 'Adervielle-Pouchergues',
	'FR65004' => 'Agos-Vidalos',
	'FR65005' => 'Allier',
	'FR65006' => 'Ancizan',
	'FR65007' => 'Andrest',
	'FR65009' => 'Anères',
	'FR65010' => 'Angos',
	'FR65011' => 'Les Angles',
	'FR65012' => 'Anla',
	'FR65013' => 'Ansost',
	'FR65014' => 'Antichan',
	'FR65015' => 'Antin',
	'FR65016' => 'Antist',
	'FR65017' => 'Aragnouet',
	'FR65018' => 'Arbéost',
	'FR65019' => 'Arcizac-Adour',
	'FR65020' => 'Arcizac-ez-Angles',
	'FR65021' => 'Arcizans-Avant',
	'FR65022' => 'Arcizans-Dessus',
	'FR65023' => 'Ardengost',
	'FR65024' => 'Argelès-Bagnères',
	'FR65025' => 'Argelès-Gazost',
	'FR65026' => 'Aries-Espénan',
	'FR65028' => 'Arné',
	'FR65029' => 'Arras-en-Lavedan',
	'FR65031' => 'Arreau',
	'FR65032' => 'Arrens-Marsous',
	'FR65033' => 'Arrodets-ez-Angles',
	'FR65034' => 'Arrodets',
	'FR65035' => 'Artagnan',
	'FR65036' => 'Artalens-Souin',
	'FR65037' => 'Artiguemy',
	'FR65038' => 'Artigues',
	'FR65039' => 'Aspin-Aure',
	'FR65040' => 'Aspin-en-Lavedan',
	'FR65041' => 'Asque',
	'FR65042' => 'Asté',
	'FR65043' => 'Astugue',
	'FR65044' => 'Aubarède',
	'FR65045' => 'Aucun',
	'FR65046' => 'Aulon',
	'FR65047' => 'Aureilhan',
	'FR65048' => 'Aurensan',
	'FR65049' => 'Auriébat',
	'FR65050' => 'Avajan',
	'FR65051' => 'Aventignan',
	'FR65052' => 'Averan',
	'FR65053' => 'Aveux',
	'FR65054' => 'Avezac-Prat-Lahitte',
	'FR65055' => 'Ayros-Arbouix',
	'FR65056' => 'Ayzac-Ost',
	'FR65057' => 'Azereix',
	'FR65058' => 'Azet',
	'FR65059' => 'Bagnères-de-Bigorre',
	'FR65060' => 'Banios',
	'FR65061' => 'Barbachen',
	'FR65062' => 'Barbazan-Debat',
	'FR65063' => 'Barbazan-Dessus',
	'FR65064' => 'Bareilles',
	'FR65065' => 'Barlest',
	'FR65066' => 'Barrancoueu',
	'FR65067' => 'Barry',
	'FR65068' => 'Barthe',
	'FR65069' => 'La Barthe-de-Neste',
	'FR65070' => 'Bartrès',
	'FR65071' => 'Batsère',
	'FR65072' => 'Bazet',
	'FR65073' => 'Bazillac',
	'FR65074' => 'Bazordan',
	'FR65075' => 'Bazus-Aure',
	'FR65076' => 'Bazus-Neste',
	'FR65077' => 'Beaucens',
	'FR65078' => 'Beaudéan',
	'FR65079' => 'Bégole',
	'FR65080' => 'Bénac',
	'FR65081' => 'Benqué-Molère',
	'FR65082' => 'Berbérust-Lias',
	'FR65083' => 'Bernac-Debat',
	'FR65084' => 'Bernac-Dessus',
	'FR65085' => 'Bernadets-Debat',
	'FR65086' => 'Bernadets-Dessus',
	'FR65087' => 'Bertren',
	'FR65088' => 'Betbèze',
	'FR65089' => 'Betpouey',
	'FR65090' => 'Betpouy',
	'FR65091' => 'Bettes',
	'FR65092' => 'Beyrède-Jumet-Camous',
	'FR65093' => 'Bize',
	'FR65094' => 'Bizous',
	'FR65095' => 'Bonnefont',
	'FR65096' => 'Bonnemazon',
	'FR65097' => 'Bonrepos',
	'FR65098' => 'Boô-Silhen',
	'FR65099' => 'Bordères-Louron',
	'FR65100' => 'Bordères-sur-lÉchez',
	'FR65101' => 'Bordes',
	'FR65102' => 'Bouilh-Devant',
	'FR65103' => 'Bouilh-Péreuilh',
	'FR65104' => 'Boulin',
	'FR65105' => 'Bourg-de-Bigorre',
	'FR65106' => 'Bourisp',
	'FR65107' => 'Bourréac',
	'FR65108' => 'Bours',
	'FR65109' => 'Bramevaque',
	'FR65110' => 'Bugard',
	'FR65111' => 'Bulan',
	'FR65112' => 'Bun',
	'FR65113' => 'Burg',
	'FR65114' => 'Buzon',
	'FR65115' => 'Cabanac',
	'FR65116' => 'Cadéac',
	'FR65117' => 'Cadeilhan-Trachère',
	'FR65118' => 'Caharet',
	'FR65119' => 'Caixon',
	'FR65120' => 'Calavanté',
	'FR65121' => 'Camalès',
	'FR65123' => 'Campan',
	'FR65124' => 'Camparan',
	'FR65125' => 'Campistrous',
	'FR65126' => 'Campuzan',
	'FR65127' => 'Capvern',
	'FR65128' => 'Castelbajac',
	'FR65129' => 'Castelnau-Magnoac',
	'FR65130' => 'Castelnau-Rivière-Basse',
	'FR65131' => 'Castelvieilh',
	'FR65132' => 'Castéra-Lanusse',
	'FR65133' => 'Castéra-Lou',
	'FR65134' => 'Casterets',
	'FR65135' => 'Castillon',
	'FR65136' => 'Caubous',
	'FR65137' => 'Caussade-Rivière',
	'FR65138' => 'Cauterets',
	'FR65139' => 'Cazarilh',
	'FR65140' => 'Cazaux-Debat',
	'FR65141' => 'Cazaux-Fréchet-Anéran-Camors',
	'FR65142' => 'Chelle-Debat',
	'FR65143' => 'Chelle-Spou',
	'FR65144' => 'Cheust',
	'FR65145' => 'Chèze',
	'FR65146' => 'Chis',
	'FR65147' => 'Cieutat',
	'FR65148' => 'Cizos',
	'FR65149' => 'Clarac',
	'FR65150' => 'Clarens',
	'FR65151' => 'Collongues',
	'FR65153' => 'Coussan',
	'FR65154' => 'Créchets',
	'FR65155' => 'Devèze',
	'FR65156' => 'Dours',
	'FR65157' => 'Ens',
	'FR65158' => 'Esbareich',
	'FR65159' => 'Escala',
	'FR65160' => 'Escaunets',
	'FR65161' => 'Escondeaux',
	'FR65162' => 'Esconnets',
	'FR65163' => 'Escots',
	'FR65164' => 'Escoubès-Pouts',
	'FR65165' => 'Esparros',
	'FR65166' => 'Espèche',
	'FR65167' => 'Espieilh',
	'FR65168' => 'Esquièze-Sère',
	'FR65169' => 'Estaing',
	'FR65170' => 'Estampures',
	'FR65171' => 'Estarvielle',
	'FR65172' => 'Estensan',
	'FR65173' => 'Esterre',
	'FR65174' => 'Estirac',
	'FR65175' => 'Ferrère',
	'FR65176' => 'Ferrières',
	'FR65177' => 'Fontrailles',
	'FR65178' => 'Fréchède',
	'FR65179' => 'Fréchendets',
	'FR65180' => 'Fréchet-Aure',
	'FR65181' => 'Fréchou-Fréchet',
	'FR65182' => 'Gaillagos',
	'FR65183' => 'Galan',
	'FR65184' => 'Galez',
	'FR65185' => 'Gardères',
	'FR65186' => 'Gaudent',
	'FR65187' => 'Gaussan',
	'FR65189' => 'Gayan',
	'FR65190' => 'Gazave',
	'FR65191' => 'Gazost',
	'FR65192' => 'Gavarnie-Gèdre',
	'FR65193' => 'Gembrie',
	'FR65194' => 'Générest',
	'FR65195' => 'Génos',
	'FR65196' => 'Gensac',
	'FR65197' => 'Ger',
	'FR65198' => 'Gerde',
	'FR65199' => 'Germ',
	'FR65200' => 'Germs-sur-lOussouet',
	'FR65201' => 'Geu',
	'FR65202' => 'Gez',
	'FR65203' => 'Gez-ez-Angles',
	'FR65204' => 'Gonez',
	'FR65205' => 'Gouaux',
	'FR65206' => 'Goudon',
	'FR65207' => 'Gourgue',
	'FR65208' => 'Grailhen',
	'FR65209' => 'Grézian',
	'FR65210' => 'Grust',
	'FR65211' => 'Guchan',
	'FR65212' => 'Guchen',
	'FR65213' => 'Guizerix',
	'FR65214' => 'Hachan',
	'FR65215' => 'Hagedet',
	'FR65216' => 'Hauban',
	'FR65217' => 'Hautaget',
	'FR65218' => 'Hèches',
	'FR65219' => 'Hères',
	'FR65220' => 'Hibarette',
	'FR65221' => 'Hiis',
	'FR65222' => 'Hitte',
	'FR65223' => 'Horgues',
	'FR65224' => 'Houeydets',
	'FR65225' => 'Hourc',
	'FR65226' => 'Ibos',
	'FR65228' => 'Ilhet',
	'FR65229' => 'Ilheu',
	'FR65230' => 'Izaourt',
	'FR65231' => 'Izaux',
	'FR65232' => 'Jacque',
	'FR65233' => 'Jarret',
	'FR65234' => 'Jézeau',
	'FR65235' => 'Juillan',
	'FR65236' => 'Julos',
	'FR65237' => 'Juncalas',
	'FR65238' => 'Labassère',
	'FR65239' => 'Labastide',
	'FR65240' => 'Labatut-Rivière',
	'FR65241' => 'Laborde',
	'FR65242' => 'Lacassagne',
	'FR65243' => 'Lafitole',
	'FR65244' => 'Lagarde',
	'FR65245' => 'Lagrange',
	'FR65247' => 'Arrayou-Lahitte',
	'FR65248' => 'Lahitte-Toupière',
	'FR65249' => 'Lalanne',
	'FR65250' => 'Lalanne-Trie',
	'FR65251' => 'Laloubère',
	'FR65252' => 'Lamarque-Pontacq',
	'FR65253' => 'Lamarque-Rustaing',
	'FR65254' => 'Laméac',
	'FR65255' => 'Lançon',
	'FR65256' => 'Lanespède',
	'FR65257' => 'Lanne',
	'FR65258' => 'Lannemezan',
	'FR65259' => 'Lansac',
	'FR65260' => 'Lapeyre',
	'FR65261' => 'Laran',
	'FR65262' => 'Larreule',
	'FR65263' => 'Larroque',
	'FR65264' => 'Lascazères',
	'FR65265' => 'Laslades',
	'FR65266' => 'Lassales',
	'FR65267' => 'Lau-Balagnas',
	'FR65268' => 'Layrisse',
	'FR65269' => 'Lescurry',
	'FR65270' => 'Lespouey',
	'FR65271' => 'Lézignan',
	'FR65272' => 'Lhez',
	'FR65273' => 'Liac',
	'FR65274' => 'Libaros',
	'FR65275' => 'Lies',
	'FR65276' => 'Lizos',
	'FR65277' => 'Lombrès',
	'FR65278' => 'Lomné',
	'FR65279' => 'Lortet',
	'FR65280' => 'Loubajac',
	'FR65281' => 'Loucrup',
	'FR65282' => 'Loudenvielle',
	'FR65283' => 'Loudervielle',
	'FR65284' => 'Louey',
	'FR65285' => 'Louit',
	'FR65286' => 'Lourdes',
	'FR65287' => 'Loures-Barousse',
	'FR65288' => 'Lubret-Saint-Luc',
	'FR65289' => 'Luby-Betmont',
	'FR65290' => 'Luc',
	'FR65291' => 'Lugagnan',
	'FR65292' => 'Luquet',
	'FR65293' => 'Lustar',
	'FR65294' => 'Lutilhous',
	'FR65295' => 'Luz-Saint-Sauveur',
	'FR65296' => 'Madiran',
	'FR65297' => 'Mansan',
	'FR65298' => 'Marquerie',
	'FR65299' => 'Marsac',
	'FR65300' => 'Marsas',
	'FR65301' => 'Marseillan',
	'FR65303' => 'Mascaras',
	'FR65304' => 'Maubourguet',
	'FR65305' => 'Mauléon-Barousse',
	'FR65306' => 'Mauvezin',
	'FR65307' => 'Mazères-de-Neste',
	'FR65308' => 'Mazerolles',
	'FR65309' => 'Mazouau',
	'FR65310' => 'Mérilheu',
	'FR65311' => 'Mingot',
	'FR65313' => 'Momères',
	'FR65314' => 'Monfaucon',
	'FR65315' => 'Monléon-Magnoac',
	'FR65316' => 'Monlong',
	'FR65317' => 'Mont',
	'FR65318' => 'Montastruc',
	'FR65319' => 'Montégut',
	'FR65320' => 'Montgaillard',
	'FR65321' => 'Montignac',
	'FR65322' => 'Montoussé',
	'FR65323' => 'Montsérié',
	'FR65324' => 'Moulédous',
	'FR65325' => 'Moumoulous',
	'FR65326' => 'Mun',
	'FR65327' => 'Nestier',
	'FR65328' => 'Neuilh',
	'FR65329' => 'Nistos',
	'FR65330' => 'Nouilhan',
	'FR65331' => 'Odos',
	'FR65332' => 'Oléac-Debat',
	'FR65333' => 'Oléac-Dessus',
	'FR65334' => 'Omex',
	'FR65335' => 'Ordizan',
	'FR65336' => 'Organ',
	'FR65337' => 'Orieux',
	'FR65338' => 'Orignac',
	'FR65339' => 'Orincles',
	'FR65340' => 'Orleix',
	'FR65341' => 'Oroix',
	'FR65342' => 'Osmets',
	'FR65343' => 'Ossen',
	'FR65344' => 'Ossun',
	'FR65345' => 'Ossun-ez-Angles',
	'FR65346' => 'Oueilloux',
	'FR65347' => 'Ourde',
	'FR65348' => 'Ourdis-Cotdoussan',
	'FR65349' => 'Ourdon',
	'FR65350' => 'Oursbelille',
	'FR65351' => 'Ousté',
	'FR65352' => 'Ouzous',
	'FR65353' => 'Ozon',
	'FR65354' => 'Pailhac',
	'FR65355' => 'Paréac',
	'FR65356' => 'Péré',
	'FR65357' => 'Peyraube',
	'FR65358' => 'Peyret-Saint-André',
	'FR65359' => 'Peyriguère',
	'FR65360' => 'Peyrouse',
	'FR65361' => 'Peyrun',
	'FR65362' => 'Pierrefitte-Nestalas',
	'FR65363' => 'Pinas',
	'FR65364' => 'Pintac',
	'FR65366' => 'Poueyferré',
	'FR65367' => 'Poumarous',
	'FR65368' => 'Pouy',
	'FR65369' => 'Pouyastruc',
	'FR65370' => 'Pouzac',
	'FR65371' => 'Préchac',
	'FR65372' => 'Pujo',
	'FR65373' => 'Puntous',
	'FR65374' => 'Puydarrieux',
	'FR65375' => 'Rabastens-de-Bigorre',
	'FR65376' => 'Recurt',
	'FR65377' => 'Réjaumont',
	'FR65378' => 'Ricaud',
	'FR65379' => 'Ris',
	'FR65380' => 'Sabalos',
	'FR65381' => 'Sabarros',
	'FR65382' => 'Sacoué',
	'FR65383' => 'Sadournin',
	'FR65384' => 'Sailhan',
	'FR65385' => 'Saint-Arroman',
	'FR65386' => 'Saint-Créac',
	'FR65387' => 'Saint-Lanne',
	'FR65388' => 'Saint-Lary-Soulan',
	'FR65389' => 'Saint-Laurent-de-Neste',
	'FR65390' => 'Saint-Lézer',
	'FR65391' => 'Sainte-Marie',
	'FR65392' => 'Saint-Martin',
	'FR65393' => 'Saint-Pastous',
	'FR65394' => 'Saint-Paul',
	'FR65395' => 'Saint-Pé-de-Bigorre',
	'FR65396' => 'Saint-Savin',
	'FR65397' => 'Saint-Sever-de-Rustan',
	'FR65398' => 'Saléchan',
	'FR65399' => 'Saligos',
	'FR65400' => 'Salles',
	'FR65401' => 'Salles-Adour',
	'FR65402' => 'Samuran',
	'FR65403' => 'Sanous',
	'FR65404' => 'Sariac-Magnoac',
	'FR65405' => 'Sarlabous',
	'FR65406' => 'Sarniguet',
	'FR65407' => 'Sarp',
	'FR65408' => 'Sarrancolin',
	'FR65409' => 'Sarriac-Bigorre',
	'FR65410' => 'Sarrouilles',
	'FR65411' => 'Sassis',
	'FR65412' => 'Sauveterre',
	'FR65413' => 'Sazos',
	'FR65414' => 'Ségalas',
	'FR65415' => 'Ségus',
	'FR65416' => 'Seich',
	'FR65417' => 'Séméac',
	'FR65418' => 'Sénac',
	'FR65419' => 'Sentous',
	'FR65420' => 'Sère-en-Lavedan',
	'FR65421' => 'Sère-Lanso',
	'FR65422' => 'Séron',
	'FR65423' => 'Sère-Rustaing',
	'FR65424' => 'Sers',
	'FR65425' => 'Siarrouy',
	'FR65426' => 'Sinzos',
	'FR65427' => 'Siradan',
	'FR65428' => 'Sireix',
	'FR65429' => 'Sombrun',
	'FR65430' => 'Soréac',
	'FR65431' => 'Sost',
	'FR65432' => 'Soublecause',
	'FR65433' => 'Soues',
	'FR65435' => 'Soulom',
	'FR65436' => 'Souyeaux',
	'FR65437' => 'Tajan',
	'FR65438' => 'Talazac',
	'FR65439' => 'Tarasteix',
	'FR65440' => 'Tarbes',
	'FR65441' => 'Thèbe',
	'FR65442' => 'Thermes-Magnoac',
	'FR65443' => 'Thuy',
	'FR65444' => 'Tibiran-Jaunac',
	'FR65445' => 'Tilhouse',
	'FR65446' => 'Tostat',
	'FR65447' => 'Tournay',
	'FR65448' => 'Tournous-Darré',
	'FR65449' => 'Tournous-Devant',
	'FR65450' => 'Tramezaïgues',
	'FR65451' => 'Trébons',
	'FR65452' => 'Trie-sur-Baïse',
	'FR65453' => 'Troubat',
	'FR65454' => 'Trouley-Labarthe',
	'FR65455' => 'Tuzaguet',
	'FR65456' => 'Uglas',
	'FR65457' => 'Ugnouas',
	'FR65458' => 'Uz',
	'FR65459' => 'Uzer',
	'FR65460' => 'Vic-en-Bigorre',
	'FR65461' => 'Vidou',
	'FR65462' => 'Vidouze',
	'FR65463' => 'Viella',
	'FR65464' => 'Vielle-Adour',
	'FR65465' => 'Vielle-Aure',
	'FR65466' => 'Vielle-Louron',
	'FR65467' => 'Vier-Bordes',
	'FR65468' => 'Vieuzos',
	'FR65469' => 'Viey',
	'FR65470' => 'Viger',
	'FR65471' => 'Vignec',
	'FR65472' => 'Villefranque',
	'FR65473' => 'Villelongue',
	'FR65474' => 'Villembits',
	'FR65475' => 'Villemur',
	'FR65476' => 'Villenave-près-Béarn',
	'FR65477' => 'Villenave-près-Marsac',
	'FR65478' => 'Viscos',
	'FR65479' => 'Visker',
	'FR65481' => 'Barèges',
	'FR65482' => 'Cantaous',
	'FR66001' => 'LAlbère',
	'FR66002' => 'Alénya',
	'FR66003' => 'Amélie-les-Bains-Palalda',
	'FR66004' => 'Les Angles',
	'FR66005' => 'Angoustrine-Villeneuve-des-Escaldes',
	'FR66006' => 'Ansignan',
	'FR66007' => 'Arboussols',
	'FR66008' => 'Argelès-sur-Mer',
	'FR66009' => 'Arles-sur-Tech',
	'FR66010' => 'Ayguatébia-Talau',
	'FR66011' => 'Bages',
	'FR66012' => 'Baho',
	'FR66013' => 'Baillestavy',
	'FR66014' => 'Baixas',
	'FR66015' => 'Banyuls-dels-Aspres',
	'FR66016' => 'Banyuls-sur-Mer',
	'FR66017' => 'Le Barcarès',
	'FR66018' => 'La Bastide',
	'FR66019' => 'Bélesta',
	'FR66020' => 'Bolquère',
	'FR66021' => 'Bompas',
	'FR66022' => 'Boule-dAmont',
	'FR66023' => 'Bouleternère',
	'FR66024' => 'Le Boulou',
	'FR66025' => 'Bourg-Madame',
	'FR66026' => 'Brouilla',
	'FR66027' => 'La Cabanasse',
	'FR66028' => 'Cabestany',
	'FR66029' => 'Caixas',
	'FR66030' => 'Calce',
	'FR66032' => 'Calmeilles',
	'FR66033' => 'Camélas',
	'FR66034' => 'Campôme',
	'FR66035' => 'Campoussy',
	'FR66036' => 'Canaveilles',
	'FR66037' => 'Canet-en-Roussillon',
	'FR66038' => 'Canohès',
	'FR66039' => 'Caramany',
	'FR66040' => 'Casefabre',
	'FR66041' => 'Cases-de-Pène',
	'FR66042' => 'Cassagnes',
	'FR66043' => 'Casteil',
	'FR66044' => 'Castelnou',
	'FR66045' => 'Catllar',
	'FR66046' => 'Caudiès-de-Fenouillèdes',
	'FR66047' => 'Caudiès-de-Conflent',
	'FR66048' => 'Cerbère',
	'FR66049' => 'Céret',
	'FR66050' => 'Claira',
	'FR66051' => 'Clara-Villerach',
	'FR66052' => 'Codalet',
	'FR66053' => 'Collioure',
	'FR66054' => 'Conat',
	'FR66055' => 'Corbère',
	'FR66056' => 'Corbère-les-Cabanes',
	'FR66057' => 'Corneilla-de-Conflent',
	'FR66058' => 'Corneilla-la-Rivière',
	'FR66059' => 'Corneilla-del-Vercol',
	'FR66060' => 'Corsavy',
	'FR66061' => 'Coustouges',
	'FR66062' => 'Dorres',
	'FR66063' => 'Les Cluses',
	'FR66064' => 'Égat',
	'FR66065' => 'Elne',
	'FR66066' => 'Enveitg',
	'FR66067' => 'Err',
	'FR66068' => 'Escaro',
	'FR66069' => 'Espira-de-lAgly',
	'FR66070' => 'Espira-de-Conflent',
	'FR66071' => 'Estagel',
	'FR66072' => 'Estavar',
	'FR66073' => 'Estoher',
	'FR66074' => 'Eus',
	'FR66075' => 'Eyne',
	'FR66076' => 'Felluns',
	'FR66077' => 'Fenouillet',
	'FR66078' => 'Fillols',
	'FR66079' => 'Finestret',
	'FR66080' => 'Fontpédrouse',
	'FR66081' => 'Fontrabiouse',
	'FR66082' => 'Formiguères',
	'FR66083' => 'Fosse',
	'FR66084' => 'Fourques',
	'FR66085' => 'Fuilla',
	'FR66086' => 'Glorianes',
	'FR66088' => 'Ille-sur-Têt',
	'FR66089' => 'Joch',
	'FR66090' => 'Jujols',
	'FR66091' => 'Lamanère',
	'FR66092' => 'Lansac',
	'FR66093' => 'Laroque-des-Albères',
	'FR66094' => 'Latour-Bas-Elne',
	'FR66095' => 'Latour-de-Carol',
	'FR66096' => 'Latour-de-France',
	'FR66097' => 'Lesquerde',
	'FR66098' => 'La Llagonne',
	'FR66099' => 'Llauro',
	'FR66100' => 'Llo',
	'FR66101' => 'Llupia',
	'FR66102' => 'Mantet',
	'FR66103' => 'Marquixanes',
	'FR66104' => 'Los Masos',
	'FR66105' => 'Matemale',
	'FR66106' => 'Maureillas-las-Illas',
	'FR66107' => 'Maury',
	'FR66108' => 'Millas',
	'FR66109' => 'Molitg-les-Bains',
	'FR66111' => 'Montalba-le-Château',
	'FR66112' => 'Montauriol',
	'FR66113' => 'Montbolo',
	'FR66114' => 'Montescot',
	'FR66115' => 'Montesquieu-des-Albères',
	'FR66116' => 'Montferrer',
	'FR66117' => 'Mont-Louis',
	'FR66118' => 'Montner',
	'FR66119' => 'Mosset',
	'FR66120' => 'Nahuja',
	'FR66121' => 'Néfiach',
	'FR66122' => 'Nohèdes',
	'FR66123' => 'Nyer',
	'FR66124' => 'Font-Romeu-Odeillo-Via',
	'FR66125' => 'Olette',
	'FR66126' => 'Oms',
	'FR66127' => 'Opoul-Périllos',
	'FR66128' => 'Oreilla',
	'FR66129' => 'Ortaffa',
	'FR66130' => 'Osséja',
	'FR66132' => 'Palau-de-Cerdagne',
	'FR66133' => 'Palau-del-Vidre',
	'FR66134' => 'Passa',
	'FR66136' => 'Perpignan',
	'FR66137' => 'Le Perthus',
	'FR66138' => 'Peyrestortes',
	'FR66139' => 'Pézilla-de-Conflent',
	'FR66140' => 'Pézilla-la-Rivière',
	'FR66141' => 'Pia',
	'FR66142' => 'Planès',
	'FR66143' => 'Planèzes',
	'FR66144' => 'Pollestres',
	'FR66145' => 'Ponteilla',
	'FR66146' => 'Porta',
	'FR66147' => 'Porté-Puymorens',
	'FR66148' => 'Port-Vendres',
	'FR66149' => 'Prades',
	'FR66150' => 'Prats-de-Mollo-la-Preste',
	'FR66151' => 'Prats-de-Sournia',
	'FR66152' => 'Prugnanes',
	'FR66153' => 'Prunet-et-Belpuig',
	'FR66154' => 'Puyvalador',
	'FR66155' => 'Py',
	'FR66156' => 'Rabouillet',
	'FR66157' => 'Railleu',
	'FR66158' => 'Rasiguères',
	'FR66159' => 'Réal',
	'FR66160' => 'Reynès',
	'FR66161' => 'Ria-Sirach',
	'FR66162' => 'Rigarda',
	'FR66164' => 'Rivesaltes',
	'FR66165' => 'Rodès',
	'FR66166' => 'Sahorre',
	'FR66167' => 'Saillagouse',
	'FR66168' => 'Saint-André',
	'FR66169' => 'Saint-Arnac',
	'FR66170' => 'Sainte-Colombe-de-la-Commanderie',
	'FR66171' => 'Saint-Cyprien',
	'FR66172' => 'Saint-Estève',
	'FR66173' => 'Saint-Féliu-dAmont',
	'FR66174' => 'Saint-Féliu-dAvall',
	'FR66175' => 'Saint-Génis-des-Fontaines',
	'FR66176' => 'Saint-Hippolyte',
	'FR66177' => 'Saint-Jean-Lasseille',
	'FR66178' => 'Saint-Jean-Pla-de-Corts',
	'FR66179' => 'Saint-Laurent-de-Cerdans',
	'FR66180' => 'Saint-Laurent-de-la-Salanque',
	'FR66181' => 'Sainte-Léocadie',
	'FR66182' => 'Sainte-Marie-la-Mer',
	'FR66183' => 'Saint-Marsal',
	'FR66184' => 'Saint-Martin-de-Fenouillet',
	'FR66185' => 'Saint-Michel-de-Llotes',
	'FR66186' => 'Saint-Nazaire',
	'FR66187' => 'Saint-Paul-de-Fenouillet',
	'FR66188' => 'Saint-Pierre-dels-Forcats',
	'FR66189' => 'Saleilles',
	'FR66190' => 'Salses-le-Château',
	'FR66191' => 'Sansa',
	'FR66192' => 'Sauto',
	'FR66193' => 'Serdinya',
	'FR66194' => 'Serralongue',
	'FR66195' => 'Le Soler',
	'FR66196' => 'Sorède',
	'FR66197' => 'Souanyas',
	'FR66198' => 'Sournia',
	'FR66199' => 'Taillet',
	'FR66201' => 'Tarerach',
	'FR66202' => 'Targassonne',
	'FR66203' => 'Taulis',
	'FR66204' => 'Taurinya',
	'FR66205' => 'Tautavel',
	'FR66206' => 'Le Tech',
	'FR66207' => 'Terrats',
	'FR66208' => 'Théza',
	'FR66209' => 'Thuès-Entre-Valls',
	'FR66210' => 'Thuir',
	'FR66211' => 'Tordères',
	'FR66212' => 'Torreilles',
	'FR66213' => 'Toulouges',
	'FR66214' => 'Tresserre',
	'FR66215' => 'Trévillach',
	'FR66216' => 'Trilla',
	'FR66217' => 'Trouillas',
	'FR66218' => 'Ur',
	'FR66219' => 'Urbanya',
	'FR66220' => 'Valcebollère',
	'FR66221' => 'Valmanya',
	'FR66222' => 'Vernet-les-Bains',
	'FR66223' => 'Villefranche-de-Conflent',
	'FR66224' => 'Villelongue-de-la-Salanque',
	'FR66225' => 'Villelongue-dels-Monts',
	'FR66226' => 'Villemolaque',
	'FR66227' => 'Villeneuve-de-la-Raho',
	'FR66228' => 'Villeneuve-la-Rivière',
	'FR66230' => 'Vinça',
	'FR66231' => 'Vingrau',
	'FR66232' => 'Vira',
	'FR66233' => 'Vivès',
	'FR66234' => 'Le Vivier',
	'FR67001' => 'Achenheim',
	'FR67002' => 'Adamswiller',
	'FR67003' => 'Albé',
	'FR67004' => 'Sommerau',
	'FR67005' => 'Alteckendorf',
	'FR67006' => 'Altenheim',
	'FR67008' => 'Altorf',
	'FR67009' => 'Altwiller',
	'FR67010' => 'Andlau',
	'FR67011' => 'Artolsheim',
	'FR67012' => 'Aschbach',
	'FR67013' => 'Asswiller',
	'FR67016' => 'Avolsheim',
	'FR67017' => 'Baerendorf',
	'FR67018' => 'Balbronn',
	'FR67019' => 'Baldenheim',
	'FR67020' => 'Barembach',
	'FR67021' => 'Barr',
	'FR67022' => 'Bassemberg',
	'FR67023' => 'Batzendorf',
	'FR67025' => 'Beinheim',
	'FR67026' => 'Bellefosse',
	'FR67027' => 'Belmont',
	'FR67028' => 'Benfeld',
	'FR67029' => 'Berg',
	'FR67030' => 'Bergbieten',
	'FR67031' => 'Bernardswiller',
	'FR67032' => 'Bernardvillé',
	'FR67033' => 'Bernolsheim',
	'FR67034' => 'Berstett',
	'FR67035' => 'Berstheim',
	'FR67036' => 'Bettwiller',
	'FR67037' => 'Biblisheim',
	'FR67038' => 'Bietlenheim',
	'FR67039' => 'Bilwisheim',
	'FR67040' => 'Bindernheim',
	'FR67043' => 'Bischheim',
	'FR67044' => 'Bischholtz',
	'FR67045' => 'Bischoffsheim',
	'FR67046' => 'Bischwiller',
	'FR67047' => 'Bissert',
	'FR67048' => 'Bitschhoffen',
	'FR67049' => 'Blaesheim',
	'FR67050' => 'Blancherupt',
	'FR67051' => 'Blienschwiller',
	'FR67052' => 'Bœrsch',
	'FR67053' => 'Bœsenbiesen',
	'FR67054' => 'Bolsenheim',
	'FR67055' => 'Boofzheim',
	'FR67056' => 'Bootzheim',
	'FR67057' => 'Bosselshausen',
	'FR67058' => 'Bossendorf',
	'FR67059' => 'Bourg-Bruche',
	'FR67060' => 'Bourgheim',
	'FR67061' => 'Bouxwiller',
	'FR67062' => 'Breitenau',
	'FR67063' => 'Breitenbach',
	'FR67065' => 'Breuschwickersheim',
	'FR67066' => 'La Broque',
	'FR67067' => 'Brumath',
	'FR67068' => 'Buswiller',
	'FR67069' => 'Buhl',
	'FR67070' => 'Burbach',
	'FR67071' => 'Bust',
	'FR67072' => 'Butten',
	'FR67073' => 'Châtenois',
	'FR67074' => 'Cleebourg',
	'FR67075' => 'Climbach',
	'FR67076' => 'Colroy-la-Roche',
	'FR67077' => 'Cosswiller',
	'FR67078' => 'Crastatt',
	'FR67079' => 'Crœttwiller',
	'FR67080' => 'Dachstein',
	'FR67081' => 'Dahlenheim',
	'FR67082' => 'Dalhunden',
	'FR67083' => 'Dambach',
	'FR67084' => 'Dambach-la-Ville',
	'FR67085' => 'Dangolsheim',
	'FR67086' => 'Daubensand',
	'FR67087' => 'Dauendorf',
	'FR67088' => 'Dehlingen',
	'FR67089' => 'Dettwiller',
	'FR67090' => 'Diebolsheim',
	'FR67091' => 'Diedendorf',
	'FR67092' => 'Dieffenbach-au-Val',
	'FR67093' => 'Dieffenbach-lès-Wœrth',
	'FR67094' => 'Dieffenthal',
	'FR67095' => 'Diemeringen',
	'FR67096' => 'Dimbsthal',
	'FR67097' => 'Dingsheim',
	'FR67098' => 'Dinsheim-sur-Bruche',
	'FR67099' => 'Domfessel',
	'FR67100' => 'Donnenheim',
	'FR67101' => 'Dorlisheim',
	'FR67102' => 'Dossenheim-Kochersberg',
	'FR67103' => 'Dossenheim-sur-Zinsel',
	'FR67104' => 'Drachenbronn-Birlenbach',
	'FR67105' => 'Drulingen',
	'FR67106' => 'Drusenheim',
	'FR67107' => 'Duntzenheim',
	'FR67108' => 'Duppigheim',
	'FR67109' => 'Durningen',
	'FR67110' => 'Durrenbach',
	'FR67111' => 'Durstel',
	'FR67112' => 'Duttlenheim',
	'FR67113' => 'Eberbach-Seltz',
	'FR67115' => 'Ebersheim',
	'FR67116' => 'Ebersmunster',
	'FR67117' => 'Eckartswiller',
	'FR67118' => 'Eckbolsheim',
	'FR67119' => 'Eckwersheim',
	'FR67120' => 'Eichhoffen',
	'FR67121' => 'Elsenheim',
	'FR67122' => 'Wangenbourg-Engenthal',
	'FR67123' => 'Engwiller',
	'FR67124' => 'Entzheim',
	'FR67125' => 'Epfig',
	'FR67126' => 'Erckartswiller',
	'FR67127' => 'Ergersheim',
	'FR67128' => 'Ernolsheim-Bruche',
	'FR67129' => 'Ernolsheim-lès-Saverne',
	'FR67130' => 'Erstein',
	'FR67131' => 'Eschau',
	'FR67132' => 'Eschbach',
	'FR67133' => 'Eschbourg',
	'FR67134' => 'Eschwiller',
	'FR67135' => 'Ettendorf',
	'FR67136' => 'Eywiller',
	'FR67137' => 'Fegersheim',
	'FR67138' => 'Fessenheim-le-Bas',
	'FR67139' => 'Flexbourg',
	'FR67140' => 'Forstfeld',
	'FR67141' => 'Forstheim',
	'FR67142' => 'Fort-Louis',
	'FR67143' => 'Fouchy',
	'FR67144' => 'Fouday',
	'FR67145' => 'Friedolsheim',
	'FR67146' => 'Friesenheim',
	'FR67147' => 'Frœschwiller',
	'FR67148' => 'Frohmuhl',
	'FR67149' => 'Furchhausen',
	'FR67150' => 'Furdenheim',
	'FR67151' => 'Gambsheim',
	'FR67152' => 'Geispolsheim',
	'FR67153' => 'Geiswiller-Zœbersdorf',
	'FR67154' => 'Gerstheim',
	'FR67155' => 'Gertwiller',
	'FR67156' => 'Geudertheim',
	'FR67159' => 'Gœrlingen',
	'FR67160' => 'Gœrsdorf',
	'FR67161' => 'Gottenhouse',
	'FR67162' => 'Gottesheim',
	'FR67163' => 'Gougenheim',
	'FR67164' => 'Goxwiller',
	'FR67165' => 'Grandfontaine',
	'FR67166' => 'Grassendorf',
	'FR67167' => 'Grendelbruch',
	'FR67168' => 'Gresswiller',
	'FR67169' => 'Gries',
	'FR67172' => 'Griesheim-près-Molsheim',
	'FR67173' => 'Griesheim-sur-Souffel',
	'FR67174' => 'Gumbrechtshoffen',
	'FR67176' => 'Gundershoffen',
	'FR67177' => 'Gunstett',
	'FR67178' => 'Gungwiller',
	'FR67179' => 'Haegen',
	'FR67180' => 'Haguenau',
	'FR67181' => 'Handschuheim',
	'FR67182' => 'Hangenbieten',
	'FR67183' => 'Harskirchen',
	'FR67184' => 'Hatten',
	'FR67185' => 'Hattmatt',
	'FR67186' => 'Hegeney',
	'FR67187' => 'Heidolsheim',
	'FR67188' => 'Heiligenberg',
	'FR67189' => 'Heiligenstein',
	'FR67190' => 'Hengwiller',
	'FR67191' => 'Herbitzheim',
	'FR67192' => 'Herbsheim',
	'FR67194' => 'Herrlisheim',
	'FR67195' => 'Hessenheim',
	'FR67196' => 'Hilsenheim',
	'FR67197' => 'Hindisheim',
	'FR67198' => 'Hinsbourg',
	'FR67199' => 'Hinsingen',
	'FR67200' => 'Hipsheim',
	'FR67201' => 'Hirschland',
	'FR67202' => 'Hochfelden',
	'FR67203' => 'Hochstett',
	'FR67204' => 'Hœnheim',
	'FR67205' => 'Hœrdt',
	'FR67206' => 'Hoffen',
	'FR67208' => 'Hohengœft',
	'FR67209' => 'Hohfrankenheim',
	'FR67210' => 'Le Hohwald',
	'FR67212' => 'Holtzheim',
	'FR67213' => 'Hunspach',
	'FR67214' => 'Hurtigheim',
	'FR67215' => 'Huttendorf',
	'FR67216' => 'Huttenheim',
	'FR67217' => 'Ichtratzheim',
	'FR67218' => 'Illkirch-Graffenstaden',
	'FR67220' => 'Ingenheim',
	'FR67221' => 'Ingolsheim',
	'FR67222' => 'Ingwiller',
	'FR67223' => 'Innenheim',
	'FR67225' => 'Issenhausen',
	'FR67226' => 'Ittenheim',
	'FR67227' => 'Itterswiller',
	'FR67228' => 'Neugartheim-Ittlenheim',
	'FR67229' => 'Jetterswiller',
	'FR67230' => 'Kaltenhouse',
	'FR67231' => 'Kauffenheim',
	'FR67232' => 'Keffenach',
	'FR67233' => 'Kertzfeld',
	'FR67234' => 'Keskastel',
	'FR67235' => 'Kesseldorf',
	'FR67236' => 'Kienheim',
	'FR67237' => 'Kilstett',
	'FR67238' => 'Kindwiller',
	'FR67239' => 'Kintzheim',
	'FR67240' => 'Kirchheim',
	'FR67241' => 'Kirrberg',
	'FR67242' => 'Kirrwiller',
	'FR67244' => 'Kleingœft',
	'FR67245' => 'Knœrsheim',
	'FR67246' => 'Kogenheim',
	'FR67247' => 'Kolbsheim',
	'FR67248' => 'Krautergersheim',
	'FR67249' => 'Krautwiller',
	'FR67250' => 'Kriegsheim',
	'FR67252' => 'Kurtzenhouse',
	'FR67253' => 'Kuttolsheim',
	'FR67254' => 'Kutzenhausen',
	'FR67255' => 'Lalaye',
	'FR67256' => 'Lampertheim',
	'FR67257' => 'Lampertsloch',
	'FR67258' => 'Landersheim',
	'FR67259' => 'Langensoultzbach',
	'FR67260' => 'Laubach',
	'FR67261' => 'Lauterbourg',
	'FR67263' => 'Lembach',
	'FR67264' => 'Leutenheim',
	'FR67265' => 'Lichtenberg',
	'FR67266' => 'Limersheim',
	'FR67267' => 'Lingolsheim',
	'FR67268' => 'Lipsheim',
	'FR67269' => 'Littenheim',
	'FR67270' => 'Lixhausen',
	'FR67271' => 'Lobsann',
	'FR67272' => 'Lochwiller',
	'FR67273' => 'Lohr',
	'FR67274' => 'Lorentzen',
	'FR67275' => 'Lupstein',
	'FR67276' => 'Lutzelhouse',
	'FR67277' => 'Mackenheim',
	'FR67278' => 'Mackwiller',
	'FR67279' => 'Maennolsheim',
	'FR67280' => 'Maisonsgoutte',
	'FR67281' => 'Marckolsheim',
	'FR67282' => 'Marlenheim',
	'FR67283' => 'Marmoutier',
	'FR67285' => 'Matzenheim',
	'FR67286' => 'Meistratzheim',
	'FR67287' => 'Melsheim',
	'FR67288' => 'Memmelshoffen',
	'FR67289' => 'Menchhoffen',
	'FR67290' => 'Merkwiller-Pechelbronn',
	'FR67291' => 'Mertzwiller',
	'FR67292' => 'Mietesheim',
	'FR67293' => 'Minversheim',
	'FR67295' => 'Mittelbergheim',
	'FR67296' => 'Mittelhausbergen',
	'FR67298' => 'Mittelschaeffolsheim',
	'FR67299' => 'Mollkirch',
	'FR67300' => 'Molsheim',
	'FR67301' => 'Mommenheim',
	'FR67302' => 'Monswiller',
	'FR67303' => 'Morsbronn-les-Bains',
	'FR67304' => 'Morschwiller',
	'FR67305' => 'Mothern',
	'FR67306' => 'Muhlbach-sur-Bruche',
	'FR67307' => 'Mulhausen',
	'FR67308' => 'Munchhausen',
	'FR67309' => 'Mundolsheim',
	'FR67310' => 'Mussig',
	'FR67311' => 'Muttersholtz',
	'FR67312' => 'Mutzenhouse',
	'FR67313' => 'Mutzig',
	'FR67314' => 'Natzwiller',
	'FR67315' => 'Neewiller-près-Lauterbourg',
	'FR67317' => 'Neubois',
	'FR67319' => 'Neuhaeusel',
	'FR67320' => 'Neuve-Église',
	'FR67321' => 'Neuviller-la-Roche',
	'FR67322' => 'Neuwiller-lès-Saverne',
	'FR67324' => 'Niederbronn-les-Bains',
	'FR67325' => 'Niederhaslach',
	'FR67326' => 'Niederhausbergen',
	'FR67327' => 'Niederlauterbach',
	'FR67328' => 'Niedermodern',
	'FR67329' => 'Niedernai',
	'FR67330' => 'Niederrœdern',
	'FR67331' => 'Niederschaeffolsheim',
	'FR67333' => 'Niedersoultzbach',
	'FR67334' => 'Niedersteinbach',
	'FR67335' => 'Nordheim',
	'FR67336' => 'Nordhouse',
	'FR67337' => 'Nothalten',
	'FR67338' => 'Obenheim',
	'FR67339' => 'Betschdorf',
	'FR67340' => 'Oberbronn',
	'FR67341' => 'Oberdorf-Spachbach',
	'FR67342' => 'Oberhaslach',
	'FR67343' => 'Oberhausbergen',
	'FR67344' => 'Oberhoffen-lès-Wissembourg',
	'FR67345' => 'Oberhoffen-sur-Moder',
	'FR67346' => 'Oberlauterbach',
	'FR67347' => 'Obermodern-Zutzendorf',
	'FR67348' => 'Obernai',
	'FR67349' => 'Oberrœdern',
	'FR67350' => 'Oberschaeffolsheim',
	'FR67351' => 'Seebach',
	'FR67352' => 'Obersoultzbach',
	'FR67353' => 'Obersteinbach',
	'FR67354' => 'Odratzheim',
	'FR67355' => 'Oermingen',
	'FR67356' => 'Offendorf',
	'FR67358' => 'Offwiller',
	'FR67359' => 'Ohlungen',
	'FR67360' => 'Ohnenheim',
	'FR67361' => 'Olwisheim',
	'FR67362' => 'Orschwiller',
	'FR67363' => 'Osthoffen',
	'FR67364' => 'Osthouse',
	'FR67365' => 'Ostwald',
	'FR67366' => 'Ottersthal',
	'FR67367' => 'Otterswiller',
	'FR67368' => 'Ottrott',
	'FR67369' => 'Ottwiller',
	'FR67370' => 'Petersbach',
	'FR67371' => 'La Petite-Pierre',
	'FR67372' => 'Val-de-Moder',
	'FR67373' => 'Pfalzweyer',
	'FR67375' => 'Pfulgriesheim',
	'FR67377' => 'Plaine',
	'FR67378' => 'Plobsheim',
	'FR67379' => 'Preuschdorf',
	'FR67380' => 'Printzheim',
	'FR67381' => 'Puberg',
	'FR67382' => 'Quatzenheim',
	'FR67383' => 'Rangen',
	'FR67384' => 'Ranrupt',
	'FR67385' => 'Ratzwiller',
	'FR67386' => 'Rauwiller',
	'FR67387' => 'Reichsfeld',
	'FR67388' => 'Reichshoffen',
	'FR67389' => 'Reichstett',
	'FR67391' => 'Reinhardsmunster',
	'FR67392' => 'Reipertswiller',
	'FR67394' => 'Retschwiller',
	'FR67395' => 'Reutenbourg',
	'FR67396' => 'Rexingen',
	'FR67397' => 'Rhinau',
	'FR67398' => 'Richtolsheim',
	'FR67400' => 'Riedseltz',
	'FR67401' => 'Rimsdorf',
	'FR67403' => 'Ringendorf',
	'FR67404' => 'Rittershoffen',
	'FR67405' => 'Rœschwoog',
	'FR67406' => 'Rohr',
	'FR67407' => 'Rohrwiller',
	'FR67408' => 'Romanswiller',
	'FR67409' => 'Roppenheim',
	'FR67410' => 'Rosenwiller',
	'FR67411' => 'Rosheim',
	'FR67412' => 'Rossfeld',
	'FR67413' => 'Rosteig',
	'FR67414' => 'Rothau',
	'FR67415' => 'Rothbach',
	'FR67416' => 'Rott',
	'FR67417' => 'Rottelsheim',
	'FR67418' => 'Rountzenheim-Auenheim',
	'FR67420' => 'Russ',
	'FR67421' => 'Saales',
	'FR67422' => 'Saasenheim',
	'FR67423' => 'Saessolsheim',
	'FR67424' => 'Saint-Blaise-la-Roche',
	'FR67425' => 'Saint-Jean-Saverne',
	'FR67426' => 'Saint-Martin',
	'FR67427' => 'Saint-Maurice',
	'FR67428' => 'Saint-Nabor',
	'FR67429' => 'Saint-Pierre',
	'FR67430' => 'Saint-Pierre-Bois',
	'FR67432' => 'Salmbach',
	'FR67433' => 'Sand',
	'FR67434' => 'Sarre-Union',
	'FR67435' => 'Sarrewerden',
	'FR67436' => 'Saulxures',
	'FR67437' => 'Saverne',
	'FR67438' => 'Schaeffersheim',
	'FR67440' => 'Schaffhouse-près-Seltz',
	'FR67441' => 'Schalkendorf',
	'FR67442' => 'Scharrachbergheim-Irmstett',
	'FR67443' => 'Scheibenhard',
	'FR67444' => 'Scherlenheim',
	'FR67445' => 'Scherwiller',
	'FR67446' => 'Schillersdorf',
	'FR67447' => 'Schiltigheim',
	'FR67448' => 'Schirmeck',
	'FR67449' => 'Schirrhein',
	'FR67450' => 'Schirrhoffen',
	'FR67451' => 'Schleithal',
	'FR67452' => 'Schnersheim',
	'FR67453' => 'Schœnau',
	'FR67454' => 'Schœnbourg',
	'FR67455' => 'Schœnenbourg',
	'FR67456' => 'Schopperten',
	'FR67458' => 'Schweighouse-sur-Moder',
	'FR67459' => 'Schwenheim',
	'FR67460' => 'Schwindratzheim',
	'FR67461' => 'Schwobsheim',
	'FR67462' => 'Sélestat',
	'FR67463' => 'Seltz',
	'FR67464' => 'Sermersheim',
	'FR67465' => 'Sessenheim',
	'FR67466' => 'Siegen',
	'FR67467' => 'Siewiller',
	'FR67468' => 'Siltzheim',
	'FR67470' => 'Solbach',
	'FR67471' => 'Souffelweyersheim',
	'FR67472' => 'Soufflenheim',
	'FR67473' => 'Soultz-les-Bains',
	'FR67474' => 'Soultz-sous-Forêts',
	'FR67475' => 'Sparsbach',
	'FR67476' => 'Stattmatten',
	'FR67477' => 'Steige',
	'FR67478' => 'Steinbourg',
	'FR67479' => 'Steinseltz',
	'FR67480' => 'Still',
	'FR67481' => 'Stotzheim',
	'FR67482' => 'Strasbourg',
	'FR67483' => 'Struth',
	'FR67484' => 'Stundwiller',
	'FR67485' => 'Stutzheim-Offenheim',
	'FR67486' => 'Sundhouse',
	'FR67487' => 'Surbourg',
	'FR67488' => 'Thal-Drulingen',
	'FR67489' => 'Thal-Marmoutier',
	'FR67490' => 'Thanvillé',
	'FR67491' => 'Tieffenbach',
	'FR67492' => 'Traenheim',
	'FR67493' => 'Triembach-au-Val',
	'FR67494' => 'Trimbach',
	'FR67495' => 'Truchtersheim',
	'FR67497' => 'Uhlwiller',
	'FR67498' => 'Uhrwiller',
	'FR67499' => 'Urbeis',
	'FR67500' => 'Urmatt',
	'FR67501' => 'Uttenheim',
	'FR67502' => 'Uttenhoffen',
	'FR67503' => 'Uttwiller',
	'FR67504' => 'Valff',
	'FR67505' => 'La Vancelle',
	'FR67506' => 'Vendenheim',
	'FR67507' => 'Villé',
	'FR67508' => 'Vœllerdingen',
	'FR67509' => 'Volksberg',
	'FR67510' => 'Wahlenheim',
	'FR67511' => 'Walbourg',
	'FR67513' => 'Waldersbach',
	'FR67514' => 'Waldhambach',
	'FR67515' => 'Waldolwisheim',
	'FR67516' => 'Waltenheim-sur-Zorn',
	'FR67517' => 'Wangen',
	'FR67519' => 'La Wantzenau',
	'FR67520' => 'Wasselonne',
	'FR67521' => 'Weinbourg',
	'FR67522' => 'Weislingen',
	'FR67523' => 'Weitbruch',
	'FR67524' => 'Weiterswiller',
	'FR67525' => 'Westhoffen',
	'FR67526' => 'Westhouse',
	'FR67527' => 'Westhouse-Marmoutier',
	'FR67528' => 'Weyer',
	'FR67529' => 'Weyersheim',
	'FR67530' => 'Wickersheim-Wilshausen',
	'FR67531' => 'Wildersbach',
	'FR67532' => 'Willgottheim',
	'FR67534' => 'Wilwisheim',
	'FR67535' => 'Wimmenau',
	'FR67536' => 'Windstein',
	'FR67537' => 'Wingen',
	'FR67538' => 'Wingen-sur-Moder',
	'FR67539' => 'Wingersheim les Quatre Bans',
	'FR67540' => 'Wintershouse',
	'FR67541' => 'Wintzenbach',
	'FR67542' => 'Wintzenheim-Kochersberg',
	'FR67543' => 'Wisches',
	'FR67544' => 'Wissembourg',
	'FR67545' => 'Witternheim',
	'FR67546' => 'Wittersheim',
	'FR67547' => 'Wittisheim',
	'FR67548' => 'Wiwersheim',
	'FR67550' => 'Wœrth',
	'FR67551' => 'Wolfisheim',
	'FR67552' => 'Wolfskirchen',
	'FR67553' => 'Wolschheim',
	'FR67554' => 'Wolxheim',
	'FR67555' => 'Zehnacker',
	'FR67556' => 'Zeinheim',
	'FR67557' => 'Zellwiller',
	'FR67558' => 'Zinswiller',
	'FR67559' => 'Zittersheim',
	'FR68001' => 'Algolsheim',
	'FR68002' => 'Altenach',
	'FR68004' => 'Altkirch',
	'FR68005' => 'Ammerschwihr',
	'FR68006' => 'Bernwiller',
	'FR68007' => 'Andolsheim',
	'FR68008' => 'Appenwihr',
	'FR68009' => 'Artzenheim',
	'FR68010' => 'Aspach',
	'FR68011' => 'Aspach-le-Bas',
	'FR68012' => 'Aspach-Michelbach',
	'FR68013' => 'Attenschwiller',
	'FR68014' => 'Aubure',
	'FR68015' => 'Baldersheim',
	'FR68016' => 'Balgau',
	'FR68017' => 'Ballersdorf',
	'FR68018' => 'Balschwiller',
	'FR68019' => 'Baltzenheim',
	'FR68020' => 'Bantzenheim',
	'FR68021' => 'Bartenheim',
	'FR68022' => 'Battenheim',
	'FR68023' => 'Beblenheim',
	'FR68024' => 'Bellemagny',
	'FR68025' => 'Bendorf',
	'FR68026' => 'Bennwihr',
	'FR68027' => 'Berentzwiller',
	'FR68028' => 'Bergheim',
	'FR68029' => 'Bergholtz',
	'FR68030' => 'Bergholtzzell',
	'FR68032' => 'Berrwiller',
	'FR68033' => 'Bettendorf',
	'FR68034' => 'Bettlach',
	'FR68035' => 'Biederthal',
	'FR68036' => 'Biesheim',
	'FR68037' => 'Biltzheim',
	'FR68038' => 'Bischwihr',
	'FR68039' => 'Bisel',
	'FR68040' => 'Bitschwiller-lès-Thann',
	'FR68041' => 'Blodelsheim',
	'FR68042' => 'Blotzheim',
	'FR68043' => 'Bollwiller',
	'FR68044' => 'Le Bonhomme',
	'FR68045' => 'Bourbach-le-Bas',
	'FR68046' => 'Bourbach-le-Haut',
	'FR68049' => 'Bouxwiller',
	'FR68050' => 'Bréchaumont',
	'FR68051' => 'Breitenbach-Haut-Rhin',
	'FR68052' => 'Bretten',
	'FR68054' => 'Brinckheim',
	'FR68055' => 'Bruebach',
	'FR68056' => 'Brunstatt-Didenheim',
	'FR68057' => 'Buethwiller',
	'FR68058' => 'Buhl',
	'FR68059' => 'Burnhaupt-le-Bas',
	'FR68060' => 'Burnhaupt-le-Haut',
	'FR68061' => 'Buschwiller',
	'FR68062' => 'Carspach',
	'FR68063' => 'Cernay',
	'FR68064' => 'Chalampé',
	'FR68065' => 'Chavannes-sur-lÉtang',
	'FR68066' => 'Colmar',
	'FR68067' => 'Courtavon',
	'FR68068' => 'Dannemarie',
	'FR68069' => 'Dessenheim',
	'FR68071' => 'Diefmatten',
	'FR68072' => 'Dietwiller',
	'FR68073' => 'Dolleren',
	'FR68074' => 'Durlinsdorf',
	'FR68075' => 'Durmenach',
	'FR68076' => 'Durrenentzen',
	'FR68077' => 'Eglingen',
	'FR68078' => 'Eguisheim',
	'FR68079' => 'Elbach',
	'FR68080' => 'Emlingen',
	'FR68081' => 'Saint-Bernard',
	'FR68082' => 'Ensisheim',
	'FR68083' => 'Eschbach-au-Val',
	'FR68084' => 'Eschentzwiller',
	'FR68085' => 'Eteimbes',
	'FR68086' => 'Falkwiller',
	'FR68087' => 'Feldbach',
	'FR68088' => 'Feldkirch',
	'FR68089' => 'Fellering',
	'FR68090' => 'Ferrette',
	'FR68091' => 'Fessenheim',
	'FR68092' => 'Fislis',
	'FR68093' => 'Flaxlanden',
	'FR68094' => 'Folgensbourg',
	'FR68095' => 'Fortschwihr',
	'FR68096' => 'Franken',
	'FR68097' => 'Fréland',
	'FR68098' => 'Friesen',
	'FR68099' => 'Frœningen',
	'FR68100' => 'Fulleren',
	'FR68101' => 'Galfingue',
	'FR68102' => 'Geishouse',
	'FR68103' => 'Geispitzen',
	'FR68104' => 'Geiswasser',
	'FR68105' => 'Gildwiller',
	'FR68106' => 'Goldbach-Altenbach',
	'FR68107' => 'Gommersdorf',
	'FR68109' => 'Griesbach-au-Val',
	'FR68110' => 'Grussenheim',
	'FR68111' => 'Gueberschwihr',
	'FR68112' => 'Guebwiller',
	'FR68113' => 'Guémar',
	'FR68114' => 'Guevenatten',
	'FR68115' => 'Guewenheim',
	'FR68116' => 'Gundolsheim',
	'FR68117' => 'Gunsbach',
	'FR68118' => 'Habsheim',
	'FR68119' => 'Hagenbach',
	'FR68120' => 'Hagenthal-le-Bas',
	'FR68121' => 'Hagenthal-le-Haut',
	'FR68122' => 'Hartmannswiller',
	'FR68123' => 'Hattstatt',
	'FR68124' => 'Hausgauen',
	'FR68125' => 'Hecken',
	'FR68126' => 'Hégenheim',
	'FR68127' => 'Heidwiller',
	'FR68128' => 'Heimersdorf',
	'FR68129' => 'Heimsbrunn',
	'FR68130' => 'Heiteren',
	'FR68131' => 'Heiwiller',
	'FR68132' => 'Helfrantzkirch',
	'FR68134' => 'Herrlisheim-près-Colmar',
	'FR68135' => 'Hésingue',
	'FR68136' => 'Hettenschlag',
	'FR68137' => 'Hindlingen',
	'FR68138' => 'Hirsingue',
	'FR68139' => 'Hirtzbach',
	'FR68140' => 'Hirtzfelden',
	'FR68141' => 'Hochstatt',
	'FR68142' => 'Hohrod',
	'FR68143' => 'Porte du Ried',
	'FR68144' => 'Hombourg',
	'FR68145' => 'Horbourg-Wihr',
	'FR68146' => 'Houssen',
	'FR68147' => 'Hunawihr',
	'FR68148' => 'Hundsbach',
	'FR68149' => 'Huningue',
	'FR68150' => 'Husseren-les-Châteaux',
	'FR68151' => 'Husseren-Wesserling',
	'FR68152' => 'Illfurth',
	'FR68153' => 'Illhaeusern',
	'FR68154' => 'Illzach',
	'FR68155' => 'Ingersheim',
	'FR68156' => 'Issenheim',
	'FR68157' => 'Jebsheim',
	'FR68158' => 'Jettingen',
	'FR68159' => 'Jungholtz',
	'FR68160' => 'Kappelen',
	'FR68161' => 'Katzenthal',
	'FR68162' => 'Kaysersberg Vignoble',
	'FR68163' => 'Kembs',
	'FR68165' => 'Kiffis',
	'FR68166' => 'Kingersheim',
	'FR68167' => 'Kirchberg',
	'FR68168' => 'Knœringue',
	'FR68169' => 'Kœstlach',
	'FR68170' => 'Kœtzingue',
	'FR68171' => 'Kruth',
	'FR68172' => 'Kunheim',
	'FR68173' => 'Labaroche',
	'FR68174' => 'Landser',
	'FR68175' => 'Lapoutroie',
	'FR68176' => 'Largitzen',
	'FR68177' => 'Lautenbach',
	'FR68178' => 'Lautenbachzell',
	'FR68179' => 'Lauw',
	'FR68180' => 'Leimbach',
	'FR68181' => 'Levoncourt',
	'FR68182' => 'Leymen',
	'FR68183' => 'Liebenswiller',
	'FR68184' => 'Liebsdorf',
	'FR68185' => 'Lièpvre',
	'FR68186' => 'Ligsdorf',
	'FR68187' => 'Linsdorf',
	'FR68188' => 'Linthal',
	'FR68189' => 'Logelheim',
	'FR68190' => 'Lucelle',
	'FR68191' => 'Luemschwiller',
	'FR68192' => 'Valdieu-Lutran',
	'FR68193' => 'Luttenbach-près-Munster',
	'FR68194' => 'Lutter',
	'FR68195' => 'Lutterbach',
	'FR68196' => 'Magny',
	'FR68197' => 'Magstatt-le-Bas',
	'FR68198' => 'Magstatt-le-Haut',
	'FR68199' => 'Malmerspach',
	'FR68200' => 'Manspach',
	'FR68201' => 'Masevaux-Niederbruck',
	'FR68202' => 'Mertzen',
	'FR68203' => 'Merxheim',
	'FR68204' => 'Metzeral',
	'FR68205' => 'Meyenheim',
	'FR68207' => 'Michelbach-le-Bas',
	'FR68208' => 'Michelbach-le-Haut',
	'FR68209' => 'Mittelwihr',
	'FR68210' => 'Mittlach',
	'FR68211' => 'Mitzach',
	'FR68212' => 'Mœrnach',
	'FR68213' => 'Mollau',
	'FR68214' => 'Montreux-Jeune',
	'FR68215' => 'Montreux-Vieux',
	'FR68216' => 'Mooslargue',
	'FR68217' => 'Moosch',
	'FR68218' => 'Morschwiller-le-Bas',
	'FR68219' => 'Le Haut Soultzbach',
	'FR68221' => 'Muespach',
	'FR68222' => 'Muespach-le-Haut',
	'FR68223' => 'Muhlbach-sur-Munster',
	'FR68224' => 'Mulhouse',
	'FR68225' => 'Munchhouse',
	'FR68226' => 'Munster',
	'FR68227' => 'Muntzenheim',
	'FR68228' => 'Munwiller',
	'FR68229' => 'Murbach',
	'FR68230' => 'Nambsheim',
	'FR68231' => 'Neuf-Brisach',
	'FR68232' => 'Neuwiller',
	'FR68234' => 'Niederentzen',
	'FR68235' => 'Niederhergheim',
	'FR68237' => 'Niedermorschwihr',
	'FR68238' => 'Niffer',
	'FR68239' => 'Oberbruck',
	'FR68240' => 'Illtal',
	'FR68241' => 'Oberentzen',
	'FR68242' => 'Oberhergheim',
	'FR68243' => 'Oberlarg',
	'FR68244' => 'Obermorschwihr',
	'FR68245' => 'Obermorschwiller',
	'FR68246' => 'Obersaasheim',
	'FR68247' => 'Oderen',
	'FR68248' => 'Oltingue',
	'FR68249' => 'Orbey',
	'FR68250' => 'Orschwihr',
	'FR68251' => 'Osenbach',
	'FR68252' => 'Ostheim',
	'FR68253' => 'Ottmarsheim',
	'FR68254' => 'Petit-Landau',
	'FR68255' => 'Pfaffenheim',
	'FR68256' => 'Pfastatt',
	'FR68257' => 'Pfetterhouse',
	'FR68258' => 'Pulversheim',
	'FR68259' => 'Raedersdorf',
	'FR68260' => 'Raedersheim',
	'FR68261' => 'Rammersmatt',
	'FR68262' => 'Ranspach',
	'FR68263' => 'Ranspach-le-Bas',
	'FR68264' => 'Ranspach-le-Haut',
	'FR68265' => 'Rantzwiller',
	'FR68266' => 'Réguisheim',
	'FR68267' => 'Reiningue',
	'FR68268' => 'Retzwiller',
	'FR68269' => 'Ribeauvillé',
	'FR68270' => 'Richwiller',
	'FR68271' => 'Riedisheim',
	'FR68273' => 'Riespach',
	'FR68274' => 'Rimbach-près-Guebwiller',
	'FR68275' => 'Rimbach-près-Masevaux',
	'FR68276' => 'Rimbachzell',
	'FR68277' => 'Riquewihr',
	'FR68278' => 'Rixheim',
	'FR68279' => 'Roderen',
	'FR68280' => 'Rodern',
	'FR68281' => 'Roggenhouse',
	'FR68282' => 'Romagny',
	'FR68283' => 'Rombach-le-Franc',
	'FR68284' => 'Roppentzwiller',
	'FR68285' => 'Rorschwihr',
	'FR68286' => 'Rosenau',
	'FR68287' => 'Rouffach',
	'FR68288' => 'Ruederbach',
	'FR68289' => 'Ruelisheim',
	'FR68290' => 'Rustenhart',
	'FR68291' => 'Rumersheim-le-Haut',
	'FR68292' => 'Saint-Amarin',
	'FR68293' => 'Saint-Cosme',
	'FR68294' => 'Sainte-Croix-aux-Mines',
	'FR68295' => 'Sainte-Croix-en-Plaine',
	'FR68296' => 'Saint-Hippolyte',
	'FR68297' => 'Saint-Louis',
	'FR68298' => 'Sainte-Marie-aux-Mines',
	'FR68299' => 'Saint-Ulrich',
	'FR68300' => 'Sausheim',
	'FR68301' => 'Schlierbach',
	'FR68302' => 'Schweighouse-Thann',
	'FR68303' => 'Schwoben',
	'FR68304' => 'Sentheim',
	'FR68305' => 'Seppois-le-Bas',
	'FR68306' => 'Seppois-le-Haut',
	'FR68307' => 'Sewen',
	'FR68308' => 'Sickert',
	'FR68309' => 'Sierentz',
	'FR68311' => 'Sondernach',
	'FR68312' => 'Sondersdorf',
	'FR68313' => 'Soppe-le-Bas',
	'FR68315' => 'Soultz-Haut-Rhin',
	'FR68316' => 'Soultzbach-les-Bains',
	'FR68317' => 'Soultzeren',
	'FR68318' => 'Soultzmatt',
	'FR68320' => 'Spechbach',
	'FR68321' => 'Staffelfelden',
	'FR68322' => 'Steinbach',
	'FR68323' => 'Steinbrunn-le-Bas',
	'FR68324' => 'Steinbrunn-le-Haut',
	'FR68325' => 'Steinsoultz',
	'FR68326' => 'Sternenberg',
	'FR68327' => 'Stetten',
	'FR68328' => 'Storckensohn',
	'FR68329' => 'Stosswihr',
	'FR68330' => 'Strueth',
	'FR68331' => 'Sundhoffen',
	'FR68332' => 'Tagolsheim',
	'FR68333' => 'Tagsdorf',
	'FR68334' => 'Thann',
	'FR68335' => 'Thannenkirch',
	'FR68336' => 'Traubach-le-Bas',
	'FR68337' => 'Traubach-le-Haut',
	'FR68338' => 'Turckheim',
	'FR68340' => 'Ueberstrass',
	'FR68341' => 'Uffheim',
	'FR68342' => 'Uffholtz',
	'FR68343' => 'Ungersheim',
	'FR68344' => 'Urbès',
	'FR68345' => 'Urschenheim',
	'FR68347' => 'Vieux-Ferrette',
	'FR68348' => 'Vieux-Thann',
	'FR68349' => 'Village-Neuf',
	'FR68350' => 'Vœgtlinshoffen',
	'FR68351' => 'Vogelgrun',
	'FR68352' => 'Volgelsheim',
	'FR68353' => 'Wahlbach',
	'FR68354' => 'Walbach',
	'FR68355' => 'Waldighofen',
	'FR68356' => 'Walheim',
	'FR68357' => 'Waltenheim',
	'FR68358' => 'Wasserbourg',
	'FR68359' => 'Wattwiller',
	'FR68360' => 'Weckolsheim',
	'FR68361' => 'Wegscheid',
	'FR68362' => 'Wentzwiller',
	'FR68363' => 'Werentzhouse',
	'FR68364' => 'Westhalten',
	'FR68365' => 'Wettolsheim',
	'FR68366' => 'Wickerschwihr',
	'FR68367' => 'Widensolen',
	'FR68368' => 'Wihr-au-Val',
	'FR68370' => 'Wildenstein',
	'FR68371' => 'Willer',
	'FR68372' => 'Willer-sur-Thur',
	'FR68373' => 'Winkel',
	'FR68374' => 'Wintzenheim',
	'FR68375' => 'Wittelsheim',
	'FR68376' => 'Wittenheim',
	'FR68377' => 'Wittersdorf',
	'FR68378' => 'Wolfersdorf',
	'FR68379' => 'Wolfgantzen',
	'FR68380' => 'Wolschwiller',
	'FR68381' => 'Wuenheim',
	'FR68382' => 'Zaessingue',
	'FR68383' => 'Zellenberg',
	'FR68384' => 'Zillisheim',
	'FR68385' => 'Zimmerbach',
	'FR68386' => 'Zimmersheim',
	'FR69001' => 'Affoux',
	'FR69002' => 'Aigueperse',
	'FR69003' => 'Albigny-sur-Saône',
	'FR69004' => 'Alix',
	'FR69005' => 'Ambérieux',
	'FR69006' => 'Amplepuis',
	'FR69007' => 'Ampuis',
	'FR69008' => 'Ancy',
	'FR69009' => 'Anse',
	'FR69010' => 'LArbresle',
	'FR69012' => 'Les Ardillats',
	'FR69013' => 'Arnas',
	'FR69014' => 'Aveize',
	'FR69016' => 'Azolette',
	'FR69017' => 'Bagnols',
	'FR69018' => 'Beaujeu',
	'FR69019' => 'Belleville-en-Beaujolais',
	'FR69020' => 'Belmont-dAzergues',
	'FR69021' => 'Bessenay',
	'FR69022' => 'Bibost',
	'FR69023' => 'Blacé',
	'FR69024' => 'Val dOingt',
	'FR69026' => 'Le Breuil',
	'FR69027' => 'Brignais',
	'FR69028' => 'Brindas',
	'FR69029' => 'Bron',
	'FR69030' => 'Brullioles',
	'FR69031' => 'Brussieu',
	'FR69032' => 'Bully',
	'FR69033' => 'Cailloux-sur-Fontaines',
	'FR69034' => 'Caluire-et-Cuire',
	'FR69035' => 'Cenves',
	'FR69036' => 'Cercié',
	'FR69037' => 'Chambost-Allières',
	'FR69038' => 'Chambost-Longessaigne',
	'FR69039' => 'Chamelet',
	'FR69040' => 'Champagne-au-Mont-dOr',
	'FR69042' => 'La Chapelle-sur-Coise',
	'FR69043' => 'Chaponost',
	'FR69044' => 'Charbonnières-les-Bains',
	'FR69045' => 'Charentay',
	'FR69046' => 'Charly',
	'FR69047' => 'Charnay',
	'FR69049' => 'Chasselay',
	'FR69050' => 'Châtillon',
	'FR69051' => 'Chaussan',
	'FR69052' => 'Chazay-dAzergues',
	'FR69053' => 'Chénas',
	'FR69054' => 'Chénelette',
	'FR69055' => 'Les Chères',
	'FR69056' => 'Chessy',
	'FR69057' => 'Chevinay',
	'FR69058' => 'Chiroubles',
	'FR69059' => 'Civrieux-dAzergues',
	'FR69060' => 'Claveisolles',
	'FR69061' => 'Cogny',
	'FR69062' => 'Coise',
	'FR69063' => 'Collonges-au-Mont-dOr',
	'FR69064' => 'Condrieu',
	'FR69065' => 'Corcelles-en-Beaujolais',
	'FR69066' => 'Cours',
	'FR69067' => 'Courzieu',
	'FR69068' => 'Couzon-au-Mont-dOr',
	'FR69069' => 'Craponne',
	'FR69070' => 'Cublize',
	'FR69071' => 'Curis-au-Mont-dOr',
	'FR69072' => 'Dardilly',
	'FR69074' => 'Denicé',
	'FR69075' => 'Dième',
	'FR69076' => 'Dommartin',
	'FR69077' => 'Dracé',
	'FR69078' => 'Duerne',
	'FR69080' => 'Échalas',
	'FR69081' => 'Écully',
	'FR69082' => 'Émeringes',
	'FR69083' => 'Éveux',
	'FR69084' => 'Fleurie',
	'FR69085' => 'Fleurieu-sur-Saône',
	'FR69086' => 'Fleurieux-sur-lArbresle',
	'FR69087' => 'Fontaines-Saint-Martin',
	'FR69088' => 'Fontaines-sur-Saône',
	'FR69089' => 'Francheville',
	'FR69090' => 'Frontenas',
	'FR69091' => 'Givors',
	'FR69092' => 'Gleizé',
	'FR69093' => 'Grandris',
	'FR69094' => 'Grézieu-la-Varenne',
	'FR69095' => 'Grézieu-le-Marché',
	'FR69096' => 'Grigny',
	'FR69097' => 'Les Haies',
	'FR69098' => 'Les Halles',
	'FR69099' => 'Haute-Rivoire',
	'FR69100' => 'Irigny',
	'FR69102' => 'Joux',
	'FR69103' => 'Juliénas',
	'FR69104' => 'Jullié',
	'FR69105' => 'Lacenas',
	'FR69106' => 'Lachassagne',
	'FR69107' => 'Lamure-sur-Azergues',
	'FR69108' => 'Lancié',
	'FR69109' => 'Lantignié',
	'FR69110' => 'Larajasse',
	'FR69111' => 'Légny',
	'FR69112' => 'Lentilly',
	'FR69113' => 'Létra',
	'FR69115' => 'Limas',
	'FR69116' => 'Limonest',
	'FR69117' => 'Lissieu',
	'FR69118' => 'Loire-sur-Rhône',
	'FR69119' => 'Longes',
	'FR69120' => 'Longessaigne',
	'FR69121' => 'Lozanne',
	'FR69122' => 'Lucenay',
	'FR69123' => 'Lyon',
	'FR69124' => 'Marchampt',
	'FR69125' => 'Marcilly-dAzergues',
	'FR69126' => 'Marcy',
	'FR69127' => 'Marcy-lÉtoile',
	'FR69130' => 'Meaux-la-Montagne',
	'FR69131' => 'Messimy',
	'FR69132' => 'Meys',
	'FR69133' => 'Millery',
	'FR69134' => 'Moiré',
	'FR69135' => 'Deux-Grosnes',
	'FR69136' => 'Montagny',
	'FR69137' => 'Montmelas-Saint-Sorlin',
	'FR69138' => 'Montromant',
	'FR69139' => 'Montrottier',
	'FR69140' => 'Morancé',
	'FR69141' => 'Mornant',
	'FR69142' => 'La Mulatière',
	'FR69143' => 'Neuville-sur-Saône',
	'FR69145' => 'Odenas',
	'FR69148' => 'Orliénas',
	'FR69149' => 'Oullins',
	'FR69151' => 'Le Perréon',
	'FR69152' => 'Pierre-Bénite',
	'FR69153' => 'Poleymieux-au-Mont-dOr',
	'FR69154' => 'Pollionnay',
	'FR69155' => 'Pomeys',
	'FR69156' => 'Pommiers',
	'FR69157' => 'Vindry-sur-Turdine',
	'FR69159' => 'Porte des Pierres Dorées',
	'FR69160' => 'Poule-les-Écharmeaux',
	'FR69161' => 'Propières',
	'FR69162' => 'Quincié-en-Beaujolais',
	'FR69163' => 'Quincieux',
	'FR69164' => 'Ranchal',
	'FR69165' => 'Régnié-Durette',
	'FR69166' => 'Riverie',
	'FR69167' => 'Rivolet',
	'FR69168' => 'Rochetaillée-sur-Saône',
	'FR69169' => 'Ronno',
	'FR69170' => 'Rontalon',
	'FR69171' => 'Sain-Bel',
	'FR69172' => 'Salles-Arbuissonnas-en-Beaujolais',
	'FR69173' => 'Sarcey',
	'FR69174' => 'Les Sauvages',
	'FR69175' => 'Savigny',
	'FR69176' => 'Soucieu-en-Jarrest',
	'FR69177' => 'Sourcieux-les-Mines',
	'FR69178' => 'Souzy',
	'FR69179' => 'Beauvallon',
	'FR69180' => 'Saint-André-la-Côte',
	'FR69181' => 'Saint-Appolinaire',
	'FR69182' => 'Saint-Bonnet-des-Bruyères',
	'FR69183' => 'Saint-Bonnet-le-Troncy',
	'FR69184' => 'Sainte-Catherine',
	'FR69186' => 'Saint-Clément-de-Vers',
	'FR69187' => 'Saint-Clément-les-Places',
	'FR69188' => 'Saint-Clément-sur-Valsonne',
	'FR69189' => 'Sainte-Colombe',
	'FR69190' => 'Sainte-Consorce',
	'FR69191' => 'Saint-Cyr-au-Mont-dOr',
	'FR69192' => 'Saint-Cyr-le-Chatoux',
	'FR69193' => 'Saint-Cyr-sur-le-Rhône',
	'FR69194' => 'Saint-Didier-au-Mont-dOr',
	'FR69196' => 'Saint-Didier-sur-Beaujeu',
	'FR69197' => 'Saint-Étienne-des-Oullières',
	'FR69198' => 'Saint-Étienne-la-Varenne',
	'FR69199' => 'Saint-Fons',
	'FR69200' => 'Saint-Forgeux',
	'FR69201' => 'Sainte-Foy-lArgentière',
	'FR69202' => 'Sainte-Foy-lès-Lyon',
	'FR69203' => 'Saint-Genis-lArgentière',
	'FR69204' => 'Saint-Genis-Laval',
	'FR69205' => 'Saint-Genis-les-Ollières',
	'FR69206' => 'Saint-Georges-de-Reneins',
	'FR69207' => 'Saint-Germain-au-Mont-dOr',
	'FR69208' => 'Saint-Germain-Nuelles',
	'FR69209' => 'Saint-Igny-de-Vers',
	'FR69212' => 'Saint-Jean-des-Vignes',
	'FR69214' => 'Saint-Jean-la-Bussière',
	'FR69215' => 'Saint-Julien',
	'FR69216' => 'Saint-Julien-sur-Bibost',
	'FR69217' => 'Saint-Just-dAvray',
	'FR69218' => 'Saint-Lager',
	'FR69219' => 'Saint-Laurent-dAgny',
	'FR69220' => 'Saint-Laurent-de-Chamousset',
	'FR69225' => 'Saint-Marcel-lÉclairé',
	'FR69227' => 'Saint-Martin-en-Haut',
	'FR69228' => 'Chabanière',
	'FR69229' => 'Saint-Nizier-dAzergues',
	'FR69230' => 'Sainte-Paule',
	'FR69231' => 'Saint-Pierre-la-Palud',
	'FR69233' => 'Saint-Romain-au-Mont-dOr',
	'FR69234' => 'Saint-Romain-de-Popey',
	'FR69235' => 'Saint-Romain-en-Gal',
	'FR69236' => 'Saint-Romain-en-Gier',
	'FR69238' => 'Saint-Symphorien-sur-Coise',
	'FR69239' => 'Saint-Vérand',
	'FR69240' => 'Saint-Vincent-de-Reins',
	'FR69241' => 'Taluyers',
	'FR69242' => 'Taponas',
	'FR69243' => 'Tarare',
	'FR69244' => 'Tassin-la-Demi-Lune',
	'FR69245' => 'Ternand',
	'FR69246' => 'Theizé',
	'FR69248' => 'Thizy-les-Bourgs',
	'FR69249' => 'Thurins',
	'FR69250' => 'La Tour-de-Salvagny',
	'FR69252' => 'Trèves',
	'FR69253' => 'Tupin-et-Semons',
	'FR69254' => 'Valsonne',
	'FR69255' => 'Vaugneray',
	'FR69256' => 'Vaulx-en-Velin',
	'FR69257' => 'Vaux-en-Beaujolais',
	'FR69258' => 'Vauxrenard',
	'FR69259' => 'Vénissieux',
	'FR69260' => 'Vernaison',
	'FR69261' => 'Vernay',
	'FR69263' => 'Villechenève',
	'FR69264' => 'Villefranche-sur-Saône',
	'FR69265' => 'Ville-sur-Jarnioux',
	'FR69266' => 'Villeurbanne',
	'FR69267' => 'Villié-Morgon',
	'FR69268' => 'Vourles',
	'FR69269' => 'Yzeron',
	'FR69270' => 'Chaponnay',
	'FR69271' => 'Chassieu',
	'FR69272' => 'Communay',
	'FR69273' => 'Corbas',
	'FR69275' => 'Décines-Charpieu',
	'FR69276' => 'Feyzin',
	'FR69277' => 'Genas',
	'FR69278' => 'Genay',
	'FR69279' => 'Jonage',
	'FR69280' => 'Jons',
	'FR69281' => 'Marennes',
	'FR69282' => 'Meyzieu',
	'FR69283' => 'Mions',
	'FR69284' => 'Montanay',
	'FR69285' => 'Pusignan',
	'FR69286' => 'Rillieux-la-Pape',
	'FR69287' => 'Saint-Bonnet-de-Mure',
	'FR69288' => 'Saint-Laurent-de-Mure',
	'FR69289' => 'Saint-Pierre-de-Chandieu',
	'FR69290' => 'Saint-Priest',
	'FR69291' => 'Saint-Symphorien-dOzon',
	'FR69292' => 'Sathonay-Camp',
	'FR69293' => 'Sathonay-Village',
	'FR69294' => 'Sérézin-du-Rhône',
	'FR69295' => 'Simandres',
	'FR69296' => 'Solaize',
	'FR69297' => 'Ternay',
	'FR69298' => 'Toussieu',
	'FR69299' => 'Colombier-Saugnieu',
	'FR70001' => 'Abelcourt',
	'FR70002' => 'Aboncourt-Gesincourt',
	'FR70003' => 'Achey',
	'FR70004' => 'Adelans-et-le-Val-de-Bithaine',
	'FR70005' => 'Aillevans',
	'FR70006' => 'Aillevillers-et-Lyaumont',
	'FR70007' => 'Ailloncourt',
	'FR70008' => 'Ainvelle',
	'FR70009' => 'Aisey-et-Richecourt',
	'FR70010' => 'Alaincourt',
	'FR70011' => 'Amage',
	'FR70012' => 'Amance',
	'FR70013' => 'Ambiévillers',
	'FR70014' => 'Amblans-et-Velotte',
	'FR70015' => 'Amoncourt',
	'FR70016' => 'Amont-et-Effreney',
	'FR70017' => 'Anchenoncourt-et-Chazel',
	'FR70018' => 'Ancier',
	'FR70019' => 'Andelarre',
	'FR70020' => 'Andelarrot',
	'FR70021' => 'Andornay',
	'FR70022' => 'Angirey',
	'FR70023' => 'Anjeux',
	'FR70024' => 'Apremont',
	'FR70025' => 'Arbecey',
	'FR70026' => 'Arc-lès-Gray',
	'FR70027' => 'Argillières',
	'FR70028' => 'Aroz',
	'FR70029' => 'Arpenans',
	'FR70030' => 'Arsans',
	'FR70031' => 'Athesans-Étroitefontaine',
	'FR70032' => 'Attricourt',
	'FR70035' => 'Augicourt',
	'FR70036' => 'Aulx-lès-Cromary',
	'FR70037' => 'Autet',
	'FR70038' => 'Authoison',
	'FR70039' => 'Autoreille',
	'FR70040' => 'Autrey-lès-Cerre',
	'FR70041' => 'Autrey-lès-Gray',
	'FR70042' => 'Autrey-le-Vay',
	'FR70043' => 'Auvet-et-la-Chapelotte',
	'FR70044' => 'Auxon',
	'FR70045' => 'Avrigney-Virey',
	'FR70046' => 'Les Aynans',
	'FR70047' => 'Baignes',
	'FR70048' => 'Bard-lès-Pesmes',
	'FR70049' => 'Barges',
	'FR70050' => 'La Barre',
	'FR70051' => 'La Basse-Vaivre',
	'FR70052' => 'Bassigney',
	'FR70053' => 'Les Bâties',
	'FR70054' => 'Battrans',
	'FR70055' => 'Baudoncourt',
	'FR70056' => 'Baulay',
	'FR70057' => 'Bay',
	'FR70058' => 'Beaujeu-Saint-Vallier-Pierrejux-et-Quitteur',
	'FR70059' => 'Beaumotte-Aubertans',
	'FR70060' => 'Beaumotte-lès-Pin',
	'FR70061' => 'Belfahy',
	'FR70062' => 'Belmont',
	'FR70063' => 'Belonchamp',
	'FR70064' => 'Belverne',
	'FR70065' => 'Besnans',
	'FR70066' => 'Betaucourt',
	'FR70067' => 'Betoncourt-lès-Brotte',
	'FR70069' => 'Betoncourt-Saint-Pancras',
	'FR70070' => 'Betoncourt-sur-Mance',
	'FR70071' => 'Beulotte-Saint-Laurent',
	'FR70072' => 'Beveuge',
	'FR70074' => 'Blondefontaine',
	'FR70075' => 'Bonboillon',
	'FR70076' => 'Bonnevent-Velloreille',
	'FR70077' => 'Borey',
	'FR70078' => 'Bougey',
	'FR70079' => 'Bougnon',
	'FR70080' => 'Bouhans-et-Feurg',
	'FR70081' => 'Bouhans-lès-Lure',
	'FR70082' => 'Bouhans-lès-Montbozon',
	'FR70083' => 'Bouligney',
	'FR70084' => 'Boulot',
	'FR70085' => 'Boult',
	'FR70086' => 'Bourbévelle',
	'FR70087' => 'Bourguignon-lès-Conflans',
	'FR70088' => 'Bourguignon-lès-la-Charité',
	'FR70089' => 'Bourguignon-lès-Morey',
	'FR70090' => 'Boursières',
	'FR70091' => 'Bousseraucourt',
	'FR70092' => 'Bresilley',
	'FR70093' => 'Breuches',
	'FR70094' => 'Breuchotte',
	'FR70095' => 'Breurey-lès-Faverney',
	'FR70096' => 'Brevilliers',
	'FR70097' => 'Briaucourt',
	'FR70098' => 'Brotte-lès-Luxeuil',
	'FR70099' => 'Brotte-lès-Ray',
	'FR70100' => 'Broye-les-Loups-et-Verfontaine',
	'FR70101' => 'Broye-Aubigney-Montseugny',
	'FR70102' => 'Brussey',
	'FR70103' => 'La Bruyère',
	'FR70104' => 'Bucey-lès-Gy',
	'FR70105' => 'Bucey-lès-Traves',
	'FR70106' => 'Buffignécourt',
	'FR70107' => 'Bussières',
	'FR70109' => 'Buthiers',
	'FR70111' => 'Calmoutier',
	'FR70112' => 'Cemboing',
	'FR70113' => 'Cenans',
	'FR70114' => 'Cendrecourt',
	'FR70115' => 'Cerre-lès-Noroy',
	'FR70116' => 'Chagey',
	'FR70117' => 'Châlonvillars',
	'FR70118' => 'Chambornay-lès-Bellevaux',
	'FR70119' => 'Chambornay-lès-Pin',
	'FR70120' => 'Champagney',
	'FR70121' => 'Champey',
	'FR70122' => 'Champlitte',
	'FR70124' => 'Champtonnay',
	'FR70125' => 'Champvans',
	'FR70126' => 'Chancey',
	'FR70127' => 'Chantes',
	'FR70128' => 'La Chapelle-lès-Luxeuil',
	'FR70129' => 'La Chapelle-Saint-Quillain',
	'FR70130' => 'Charcenne',
	'FR70132' => 'Chargey-lès-Gray',
	'FR70133' => 'Chargey-lès-Port',
	'FR70134' => 'Chariez',
	'FR70135' => 'Charmes-Saint-Valbert',
	'FR70136' => 'Charmoille',
	'FR70137' => 'Chassey-lès-Montbozon',
	'FR70138' => 'Chassey-lès-Scey',
	'FR70140' => 'Châteney',
	'FR70141' => 'Châtenois',
	'FR70142' => 'Chaumercenne',
	'FR70143' => 'Chauvirey-le-Châtel',
	'FR70144' => 'Chauvirey-le-Vieil',
	'FR70145' => 'Chaux-la-Lotière',
	'FR70146' => 'Chaux-lès-Port',
	'FR70147' => 'Chavanne',
	'FR70148' => 'Chemilly',
	'FR70149' => 'Chenebier',
	'FR70150' => 'Chenevrey-et-Morogne',
	'FR70151' => 'Chevigney',
	'FR70152' => 'Choye',
	'FR70153' => 'Cintrey',
	'FR70154' => 'Cirey',
	'FR70155' => 'Citers',
	'FR70156' => 'Citey',
	'FR70157' => 'Clairegoutte',
	'FR70158' => 'Clans',
	'FR70159' => 'Cognières',
	'FR70160' => 'Coisevaux',
	'FR70162' => 'Colombe-lès-Vesoul',
	'FR70163' => 'Colombier',
	'FR70164' => 'Colombotte',
	'FR70165' => 'Combeaufontaine',
	'FR70166' => 'Comberjon',
	'FR70167' => 'Conflandey',
	'FR70168' => 'Conflans-sur-Lanterne',
	'FR70169' => 'Confracourt',
	'FR70170' => 'Contréglise',
	'FR70171' => 'Corbenay',
	'FR70172' => 'La Corbière',
	'FR70174' => 'Cordonnet',
	'FR70175' => 'Cornot',
	'FR70176' => 'Corravillers',
	'FR70177' => 'Corre',
	'FR70178' => 'La Côte',
	'FR70179' => 'Coulevon',
	'FR70180' => 'Courchaton',
	'FR70181' => 'Courcuire',
	'FR70182' => 'Courmont',
	'FR70183' => 'Courtesoult-et-Gatey',
	'FR70184' => 'Couthenans',
	'FR70185' => 'Cresancey',
	'FR70186' => 'La Creuse',
	'FR70187' => 'Crevans-et-la-Chapelle-lès-Granges',
	'FR70188' => 'Creveney',
	'FR70189' => 'Cromary',
	'FR70190' => 'Cubry-lès-Faverney',
	'FR70192' => 'Cugney',
	'FR70193' => 'Cult',
	'FR70194' => 'Cuve',
	'FR70195' => 'Dambenoît-lès-Colombe',
	'FR70196' => 'Dampierre-lès-Conflans',
	'FR70197' => 'Dampierre-sur-Linotte',
	'FR70198' => 'Dampierre-sur-Salon',
	'FR70199' => 'Dampvalley-lès-Colombe',
	'FR70200' => 'Dampvalley-Saint-Pancras',
	'FR70201' => 'Delain',
	'FR70202' => 'Demangevelle',
	'FR70203' => 'La Demie',
	'FR70204' => 'Denèvre',
	'FR70205' => 'Échavanne',
	'FR70206' => 'Échenans-sous-Mont-Vaudois',
	'FR70207' => 'Échenoz-la-Méline',
	'FR70208' => 'Échenoz-le-Sec',
	'FR70210' => 'Écromagny',
	'FR70211' => 'Écuelle',
	'FR70213' => 'Éhuns',
	'FR70214' => 'Équevilley',
	'FR70215' => 'Errevet',
	'FR70216' => 'Esboz-Brest',
	'FR70217' => 'Esmoulières',
	'FR70218' => 'Esmoulins',
	'FR70219' => 'Esprels',
	'FR70220' => 'Essertenne-et-Cecey',
	'FR70221' => 'Étobon',
	'FR70222' => 'Étrelles-et-la-Montbleuse',
	'FR70224' => 'Étuz',
	'FR70225' => 'Fahy-lès-Autrey',
	'FR70226' => 'Fallon',
	'FR70227' => 'Faucogney-et-la-Mer',
	'FR70228' => 'Faverney',
	'FR70229' => 'Faymont',
	'FR70230' => 'Fédry',
	'FR70231' => 'Ferrières-lès-Ray',
	'FR70232' => 'Ferrières-lès-Scey',
	'FR70233' => 'Les Fessey',
	'FR70234' => 'Filain',
	'FR70235' => 'Flagy',
	'FR70236' => 'Fleurey-lès-Faverney',
	'FR70237' => 'Fleurey-lès-Lavoncourt',
	'FR70238' => 'Fleurey-lès-Saint-Loup',
	'FR70239' => 'Fondremand',
	'FR70240' => 'Fontaine-lès-Luxeuil',
	'FR70242' => 'Fontenois-la-Ville',
	'FR70243' => 'Fontenois-lès-Montbozon',
	'FR70244' => 'Fouchécourt',
	'FR70245' => 'Fougerolles-Saint-Valbert',
	'FR70247' => 'Fouvent-Saint-Andoche',
	'FR70248' => 'Frahier-et-Chatebier',
	'FR70249' => 'Francalmont',
	'FR70250' => 'Franchevelle',
	'FR70251' => 'Francourt',
	'FR70252' => 'Framont',
	'FR70253' => 'Frasne-le-Château',
	'FR70254' => 'Frédéric-Fontaine',
	'FR70255' => 'Fresne-Saint-Mamès',
	'FR70256' => 'Fresse',
	'FR70257' => 'Fretigney-et-Velloreille',
	'FR70258' => 'Froideconche',
	'FR70259' => 'Froideterre',
	'FR70260' => 'Frotey-lès-Lure',
	'FR70261' => 'Frotey-lès-Vesoul',
	'FR70262' => 'Genevreuille',
	'FR70263' => 'Genevrey',
	'FR70264' => 'Georfans',
	'FR70265' => 'Germigney',
	'FR70267' => 'Gevigney-et-Mercey',
	'FR70268' => 'Gézier-et-Fontenelay',
	'FR70269' => 'Girefontaine',
	'FR70271' => 'Gouhenans',
	'FR70272' => 'Gourgeon',
	'FR70273' => 'Grammont',
	'FR70274' => 'Grandecourt',
	'FR70275' => 'Grandvelle-et-le-Perrenot',
	'FR70276' => 'Granges-la-Ville',
	'FR70277' => 'Granges-le-Bourg',
	'FR70278' => 'Grattery',
	'FR70279' => 'Gray',
	'FR70280' => 'Gray-la-Ville',
	'FR70282' => 'Gy',
	'FR70283' => 'Haut-du-Them-Château-Lambert',
	'FR70284' => 'Hautevelle',
	'FR70285' => 'Héricourt',
	'FR70286' => 'Hugier',
	'FR70287' => 'Hurecourt',
	'FR70288' => 'Hyet',
	'FR70289' => 'Igny',
	'FR70290' => 'Jasney',
	'FR70291' => 'Jonvelle',
	'FR70292' => 'Jussey',
	'FR70293' => 'Lambrey',
	'FR70294' => 'Lantenot',
	'FR70295' => 'La Lanterne-et-les-Armonts',
	'FR70296' => 'Larians-et-Munans',
	'FR70297' => 'Larret',
	'FR70298' => 'Lavigney',
	'FR70299' => 'Lavoncourt',
	'FR70301' => 'Lieffrans',
	'FR70302' => 'Lieucourt',
	'FR70303' => 'Liévans',
	'FR70304' => 'Linexert',
	'FR70305' => 'Lœuilley',
	'FR70306' => 'Lomont',
	'FR70307' => 'Longevelle',
	'FR70308' => 'La Longine',
	'FR70309' => 'Loulans-Verchamp',
	'FR70310' => 'Lure',
	'FR70311' => 'Luxeuil-les-Bains',
	'FR70312' => 'Luze',
	'FR70313' => 'Lyoffans',
	'FR70314' => 'Magnivray',
	'FR70315' => 'Magnoncourt',
	'FR70316' => 'Le Magnoray',
	'FR70317' => 'Les Magny',
	'FR70318' => 'Magny-Danigon',
	'FR70319' => 'Magny-Jobert',
	'FR70320' => 'Magny-lès-Jussey',
	'FR70321' => 'Magny-Vernois',
	'FR70322' => 'Mailleroncourt-Charette',
	'FR70323' => 'Mailleroncourt-Saint-Pancras',
	'FR70324' => 'Mailley-et-Chazelot',
	'FR70325' => 'Maizières',
	'FR70326' => 'La Malachère',
	'FR70327' => 'Malans',
	'FR70328' => 'Malbouhans',
	'FR70329' => 'Malvillers',
	'FR70330' => 'Mandrevillars',
	'FR70331' => 'Mantoche',
	'FR70332' => 'Marast',
	'FR70334' => 'Marnay',
	'FR70335' => 'Maussans',
	'FR70336' => 'Mélecey',
	'FR70337' => 'Melin',
	'FR70338' => 'Melincourt',
	'FR70339' => 'Mélisey',
	'FR70340' => 'Membrey',
	'FR70341' => 'Menoux',
	'FR70342' => 'Mercey-sur-Saône',
	'FR70343' => 'Mersuay',
	'FR70344' => 'Meurcourt',
	'FR70347' => 'Mignavillers',
	'FR70348' => 'Moffans-et-Vacheresse',
	'FR70349' => 'Moimay',
	'FR70350' => 'Molay',
	'FR70351' => 'Mollans',
	'FR70352' => 'La Montagne',
	'FR70353' => 'Montagney',
	'FR70355' => 'Montarlot-lès-Rioz',
	'FR70356' => 'Montboillon',
	'FR70357' => 'Montbozon',
	'FR70358' => 'Montcey',
	'FR70359' => 'Montcourt',
	'FR70360' => 'Montdoré',
	'FR70361' => 'Montessaux',
	'FR70362' => 'Montigny-lès-Cherlieu',
	'FR70363' => 'Montigny-lès-Vesoul',
	'FR70364' => 'Montjustin-et-Velotte',
	'FR70366' => 'Villers-Chemin-et-Mont-lès-Étrelles',
	'FR70367' => 'Mont-le-Vernois',
	'FR70368' => 'Montot',
	'FR70369' => 'Mont-Saint-Léger',
	'FR70371' => 'Montureux-et-Prantigny',
	'FR70372' => 'Montureux-lès-Baulay',
	'FR70373' => 'La Roche-Morey',
	'FR70374' => 'Motey-Besuche',
	'FR70376' => 'Nantilly',
	'FR70378' => 'Navenne',
	'FR70380' => 'Neurey-en-Vaux',
	'FR70381' => 'Neurey-lès-la-Demie',
	'FR70383' => 'Neuvelle-lès-Cromary',
	'FR70384' => 'Neuvelle-lès-la-Charité',
	'FR70385' => 'La Neuvelle-lès-Lure',
	'FR70386' => 'La Neuvelle-lès-Scey',
	'FR70387' => 'Noidans-le-Ferroux',
	'FR70388' => 'Noidans-lès-Vesoul',
	'FR70389' => 'Noiron',
	'FR70390' => 'Noroy-le-Bourg',
	'FR70392' => 'Oigney',
	'FR70393' => 'Oiselay-et-Grachaux',
	'FR70394' => 'Onay',
	'FR70395' => 'Oppenans',
	'FR70396' => 'Oricourt',
	'FR70397' => 'Ormenans',
	'FR70398' => 'Ormoiche',
	'FR70399' => 'Ormoy',
	'FR70400' => 'Ouge',
	'FR70401' => 'Ovanches',
	'FR70402' => 'Oyrières',
	'FR70403' => 'Palante',
	'FR70404' => 'Passavant-la-Rochère',
	'FR70405' => 'Pennesières',
	'FR70406' => 'Percey-le-Grand',
	'FR70407' => 'Perrouse',
	'FR70408' => 'Pesmes',
	'FR70409' => 'Pierrecourt',
	'FR70410' => 'Pin',
	'FR70411' => 'La Pisseure',
	'FR70412' => 'Plainemont',
	'FR70413' => 'Plancher-Bas',
	'FR70414' => 'Plancher-les-Mines',
	'FR70415' => 'Polaincourt-et-Clairefontaine',
	'FR70416' => 'Pomoy',
	'FR70417' => 'Pontcey',
	'FR70418' => 'La Romaine',
	'FR70419' => 'Pont-du-Bois',
	'FR70420' => 'Pont-sur-lOgnon',
	'FR70421' => 'Port-sur-Saône',
	'FR70422' => 'Poyans',
	'FR70423' => 'Preigney',
	'FR70425' => 'La Proiselière-et-Langle',
	'FR70426' => 'Provenchère',
	'FR70427' => 'Purgerot',
	'FR70428' => 'Pusey',
	'FR70429' => 'Pusy-et-Épenoux',
	'FR70430' => 'La Quarte',
	'FR70431' => 'Quenoche',
	'FR70432' => 'Quers',
	'FR70433' => 'Quincey',
	'FR70435' => 'Raddon-et-Chapendu',
	'FR70436' => 'Raincourt',
	'FR70437' => 'Ranzevelle',
	'FR70438' => 'Ray-sur-Saône',
	'FR70439' => 'Raze',
	'FR70440' => 'Recologne',
	'FR70441' => 'Recologne-lès-Rioz',
	'FR70442' => 'Renaucourt',
	'FR70443' => 'La Grande-Résie',
	'FR70444' => 'La Résie-Saint-Martin',
	'FR70445' => 'Rignovelle',
	'FR70446' => 'Rigny',
	'FR70447' => 'Rioz',
	'FR70448' => 'Roche-et-Raucourt',
	'FR70449' => 'Roche-sur-Linotte-et-Sorans-les-Cordiers',
	'FR70450' => 'La Rochelle',
	'FR70451' => 'Ronchamp',
	'FR70452' => 'Rosey',
	'FR70453' => 'La Rosière',
	'FR70454' => 'Rosières-sur-Mance',
	'FR70455' => 'Roye',
	'FR70456' => 'Ruhans',
	'FR70457' => 'Rupt-sur-Saône',
	'FR70459' => 'Saint-Barthélemy',
	'FR70460' => 'Saint-Bresson',
	'FR70461' => 'Saint-Broing',
	'FR70462' => 'Saint-Ferjeux',
	'FR70463' => 'Saint-Gand',
	'FR70464' => 'Saint-Germain',
	'FR70466' => 'Saint-Loup-Nantouard',
	'FR70467' => 'Saint-Loup-sur-Semouse',
	'FR70468' => 'Saint-Marcel',
	'FR70469' => 'Sainte-Marie-en-Chanois',
	'FR70470' => 'Sainte-Marie-en-Chaux',
	'FR70471' => 'Sainte-Reine',
	'FR70472' => 'Saint-Rémy-en-Comté',
	'FR70473' => 'Saint-Sauveur',
	'FR70474' => 'Saint-Sulpice',
	'FR70476' => 'Saponcourt',
	'FR70477' => 'Saulnot',
	'FR70478' => 'Saulx',
	'FR70479' => 'Sauvigney-lès-Gray',
	'FR70480' => 'Sauvigney-lès-Pesmes',
	'FR70481' => 'Savoyeux',
	'FR70482' => 'Scey-sur-Saône-et-Saint-Albin',
	'FR70483' => 'Scye',
	'FR70484' => 'Secenans',
	'FR70485' => 'Selles',
	'FR70486' => 'Semmadon',
	'FR70487' => 'Senargent-Mignafans',
	'FR70488' => 'Senoncourt',
	'FR70489' => 'Servance-Miellin',
	'FR70490' => 'Servigney',
	'FR70491' => 'Seveux-Motey',
	'FR70492' => 'Soing-Cubry-Charentenay',
	'FR70493' => 'Sorans-lès-Breurey',
	'FR70494' => 'Sornay',
	'FR70496' => 'Tartécourt',
	'FR70498' => 'Ternuay-Melay-et-Saint-Hilaire',
	'FR70499' => 'Theuley',
	'FR70500' => 'Thieffrans',
	'FR70501' => 'Thiénans',
	'FR70502' => 'Tincey-et-Pontrebeau',
	'FR70503' => 'Traitiéfontaine',
	'FR70504' => 'Traves',
	'FR70505' => 'Le Tremblois',
	'FR70506' => 'Trémoins',
	'FR70507' => 'Trésilley',
	'FR70509' => 'Tromarey',
	'FR70510' => 'Vadans',
	'FR70511' => 'Vaite',
	'FR70512' => 'La Vaivre',
	'FR70513' => 'Vaivre-et-Montoille',
	'FR70514' => 'Valay',
	'FR70515' => 'Le Val-de-Gouhenans',
	'FR70516' => 'Vallerois-le-Bois',
	'FR70517' => 'Vallerois-Lorioz',
	'FR70518' => 'Le Val-Saint-Éloi',
	'FR70519' => 'Vandelans',
	'FR70520' => 'Vanne',
	'FR70521' => 'Vantoux-et-Longevelle',
	'FR70522' => 'Varogne',
	'FR70523' => 'Vars',
	'FR70524' => 'Vauchoux',
	'FR70525' => 'Vauconcourt-Nervezain',
	'FR70526' => 'Vauvillers',
	'FR70527' => 'Vaux-le-Moncelot',
	'FR70528' => 'Velesmes-Échevanne',
	'FR70529' => 'Velet',
	'FR70530' => 'Vellechevreux-et-Courbenans',
	'FR70531' => 'Velleclaire',
	'FR70532' => 'Vellefaux',
	'FR70533' => 'Vellefrey-et-Vellefrange',
	'FR70534' => 'Vellefrie',
	'FR70535' => 'Velleguindry-et-Levrecey',
	'FR70536' => 'Velle-le-Châtel',
	'FR70537' => 'Velleminfroy',
	'FR70538' => 'Vellemoz',
	'FR70539' => 'Vellexon-Queutrey-et-Vaudey',
	'FR70540' => 'Velloreille-lès-Choye',
	'FR70541' => 'Velorcey',
	'FR70542' => 'Venère',
	'FR70544' => 'La Vergenne',
	'FR70545' => 'Venisey',
	'FR70546' => 'Vereux',
	'FR70547' => 'Verlans',
	'FR70548' => 'Vernois-sur-Mance',
	'FR70549' => 'La Vernotte',
	'FR70550' => 'Vesoul',
	'FR70552' => 'Villafans',
	'FR70553' => 'Villargent',
	'FR70554' => 'Villars-le-Pautel',
	'FR70555' => 'La Villedieu-en-Fontenette',
	'FR70557' => 'Villefrancon',
	'FR70558' => 'La Villeneuve-Bellenoye-et-la-Maize',
	'FR70559' => 'Villeparois',
	'FR70560' => 'Villers-Bouton',
	'FR70561' => 'Villersexel',
	'FR70562' => 'Villers-la-Ville',
	'FR70563' => 'Villers-le-Sec',
	'FR70564' => 'Villers-lès-Luxeuil',
	'FR70565' => 'Villers-Pater',
	'FR70566' => 'Villers-sur-Port',
	'FR70567' => 'Villers-sur-Saulnot',
	'FR70568' => 'Villers-Vaudey',
	'FR70569' => 'Vilory',
	'FR70571' => 'Visoncourt',
	'FR70572' => 'Vitrey-sur-Mance',
	'FR70573' => 'La Voivre',
	'FR70574' => 'Volon',
	'FR70575' => 'Voray-sur-lOgnon',
	'FR70576' => 'Vougécourt',
	'FR70577' => 'Vouhenans',
	'FR70578' => 'Vregille',
	'FR70579' => 'Vyans-le-Val',
	'FR70580' => 'Vy-le-Ferroux',
	'FR70581' => 'Vy-lès-Lure',
	'FR70582' => 'Vy-lès-Rupt',
	'FR70583' => 'Vy-lès-Filain',
	'FR71001' => 'LAbergement-de-Cuisery',
	'FR71002' => 'LAbergement-Sainte-Colombe',
	'FR71003' => 'Allerey-sur-Saône',
	'FR71004' => 'Allériot',
	'FR71005' => 'Aluze',
	'FR71006' => 'Amanzé',
	'FR71007' => 'Ameugny',
	'FR71008' => 'Anglure-sous-Dun',
	'FR71009' => 'Anost',
	'FR71010' => 'Antully',
	'FR71011' => 'Anzy-le-Duc',
	'FR71012' => 'Artaix',
	'FR71013' => 'Authumes',
	'FR71014' => 'Autun',
	'FR71015' => 'Auxy',
	'FR71016' => 'Azé',
	'FR71017' => 'Ballore',
	'FR71018' => 'Bantanges',
	'FR71019' => 'Barizey',
	'FR71020' => 'Barnay',
	'FR71021' => 'Baron',
	'FR71022' => 'Baudemont',
	'FR71023' => 'Baudrières',
	'FR71024' => 'Baugy',
	'FR71025' => 'Beaubery',
	'FR71026' => 'Beaumont-sur-Grosne',
	'FR71027' => 'Beaurepaire-en-Bresse',
	'FR71028' => 'Beauvernois',
	'FR71029' => 'Bellevesvre',
	'FR71030' => 'Bergesserin',
	'FR71031' => 'Berzé-le-Châtel',
	'FR71032' => 'Berzé-la-Ville',
	'FR71033' => 'Bey',
	'FR71034' => 'Bissey-sous-Cruchaud',
	'FR71035' => 'Bissy-la-Mâconnaise',
	'FR71036' => 'Bissy-sous-Uxelles',
	'FR71037' => 'Bissy-sur-Fley',
	'FR71038' => 'Les Bizots',
	'FR71039' => 'Blanot',
	'FR71040' => 'Blanzy',
	'FR71041' => 'Bois-Sainte-Marie',
	'FR71042' => 'Bonnay',
	'FR71043' => 'Les Bordes',
	'FR71044' => 'Bosjean',
	'FR71045' => 'Bouhans',
	'FR71046' => 'La Boulaye',
	'FR71047' => 'Bourbon-Lancy',
	'FR71048' => 'Bourg-le-Comte',
	'FR71050' => 'Bourgvilain',
	'FR71051' => 'Bouzeron',
	'FR71052' => 'Boyer',
	'FR71054' => 'Bragny-sur-Saône',
	'FR71056' => 'Branges',
	'FR71057' => 'Bray',
	'FR71058' => 'Bresse-sur-Grosne',
	'FR71059' => 'Le Breuil',
	'FR71060' => 'Briant',
	'FR71061' => 'Brienne',
	'FR71062' => 'Brion',
	'FR71063' => 'Broye',
	'FR71064' => 'Bruailles',
	'FR71065' => 'Buffières',
	'FR71066' => 'Burgy',
	'FR71067' => 'Burnand',
	'FR71068' => 'Burzy',
	'FR71069' => 'Bussières',
	'FR71070' => 'Buxy',
	'FR71071' => 'Céron',
	'FR71072' => 'Cersot',
	'FR71073' => 'Chagny',
	'FR71074' => 'Chaintré',
	'FR71075' => 'Chalmoux',
	'FR71076' => 'Chalon-sur-Saône',
	'FR71077' => 'Chambilly',
	'FR71078' => 'Chamilly',
	'FR71079' => 'Champagnat',
	'FR71080' => 'Champagny-sous-Uxelles',
	'FR71081' => 'Champforgeuil',
	'FR71082' => 'Champlecy',
	'FR71084' => 'Chânes',
	'FR71085' => 'Change',
	'FR71086' => 'Changy',
	'FR71087' => 'Chapaize',
	'FR71088' => 'La Chapelle-au-Mans',
	'FR71089' => 'La Chapelle-de-Bragny',
	'FR71090' => 'La Chapelle-de-Guinchay',
	'FR71091' => 'La Chapelle-du-Mont-de-France',
	'FR71092' => 'La Chapelle-Naude',
	'FR71093' => 'La Chapelle-Saint-Sauveur',
	'FR71094' => 'La Chapelle-sous-Brancion',
	'FR71095' => 'La Chapelle-sous-Dun',
	'FR71096' => 'La Chapelle-sous-Uchon',
	'FR71097' => 'La Chapelle-Thècle',
	'FR71098' => 'Charbonnat',
	'FR71099' => 'Charbonnières',
	'FR71100' => 'Chardonnay',
	'FR71101' => 'Charette-Varennes',
	'FR71102' => 'La Charmée',
	'FR71103' => 'Charmoy',
	'FR71104' => 'Charnay-lès-Chalon',
	'FR71105' => 'Charnay-lès-Mâcon',
	'FR71106' => 'Charolles',
	'FR71107' => 'Charrecey',
	'FR71108' => 'Chasselas',
	'FR71109' => 'Chassey-le-Camp',
	'FR71110' => 'Chassigny-sous-Dun',
	'FR71111' => 'Chassy',
	'FR71112' => 'Château',
	'FR71113' => 'Châteauneuf',
	'FR71115' => 'Châtel-Moron',
	'FR71116' => 'Châtenay',
	'FR71117' => 'Châtenoy-en-Bresse',
	'FR71118' => 'Châtenoy-le-Royal',
	'FR71119' => 'Chaudenay',
	'FR71120' => 'Chauffailles',
	'FR71121' => 'La Chaux',
	'FR71122' => 'Cheilly-lès-Maranges',
	'FR71123' => 'Chenay-le-Châtel',
	'FR71124' => 'Chenôves',
	'FR71125' => 'Chérizet',
	'FR71126' => 'Chevagny-les-Chevrières',
	'FR71127' => 'Chevagny-sur-Guye',
	'FR71128' => 'Chiddes',
	'FR71129' => 'Chissey-en-Morvan',
	'FR71130' => 'Chissey-lès-Mâcon',
	'FR71131' => 'Ciel',
	'FR71132' => 'Ciry-le-Noble',
	'FR71133' => 'La Clayette',
	'FR71134' => 'Navour-sur-Grosne',
	'FR71135' => 'Clessé',
	'FR71136' => 'Clessy',
	'FR71137' => 'Cluny',
	'FR71139' => 'Collonge-en-Charollais',
	'FR71140' => 'Collonge-la-Madeleine',
	'FR71141' => 'Colombier-en-Brionnais',
	'FR71142' => 'La Comelle',
	'FR71143' => 'Condal',
	'FR71144' => 'Cordesse',
	'FR71145' => 'Cormatin',
	'FR71146' => 'Cortambert',
	'FR71147' => 'Cortevaix',
	'FR71148' => 'Coublanc',
	'FR71149' => 'Couches',
	'FR71150' => 'Crêches-sur-Saône',
	'FR71151' => 'Créot',
	'FR71152' => 'Cressy-sur-Somme',
	'FR71153' => 'Le Creusot',
	'FR71154' => 'Crissey',
	'FR71155' => 'Cronat',
	'FR71156' => 'Cruzille',
	'FR71157' => 'Cuiseaux',
	'FR71158' => 'Cuisery',
	'FR71159' => 'Culles-les-Roches',
	'FR71160' => 'Curbigny',
	'FR71161' => 'Curdin',
	'FR71162' => 'Curgy',
	'FR71163' => 'Curtil-sous-Buffières',
	'FR71164' => 'Curtil-sous-Burnand',
	'FR71165' => 'Cussy-en-Morvan',
	'FR71166' => 'Cuzy',
	'FR71167' => 'Damerey',
	'FR71168' => 'Dampierre-en-Bresse',
	'FR71169' => 'Davayé',
	'FR71170' => 'Demigny',
	'FR71171' => 'Dennevy',
	'FR71172' => 'Dettey',
	'FR71173' => 'Devrouze',
	'FR71174' => 'Dezize-lès-Maranges',
	'FR71175' => 'Diconne',
	'FR71176' => 'Digoin',
	'FR71177' => 'Dommartin-lès-Cuiseaux',
	'FR71178' => 'Dompierre-les-Ormes',
	'FR71179' => 'Dompierre-sous-Sanvignes',
	'FR71181' => 'Donzy-le-Pertuis',
	'FR71182' => 'Dracy-le-Fort',
	'FR71183' => 'Dracy-lès-Couches',
	'FR71184' => 'Dracy-Saint-Loup',
	'FR71185' => 'Dyo',
	'FR71186' => 'Écuelles',
	'FR71187' => 'Écuisses',
	'FR71188' => 'Épertully',
	'FR71189' => 'Épervans',
	'FR71190' => 'Épinac',
	'FR71191' => 'Essertenne',
	'FR71192' => 'Étang-sur-Arroux',
	'FR71193' => 'Étrigny',
	'FR71194' => 'Farges-lès-Chalon',
	'FR71195' => 'Farges-lès-Mâcon',
	'FR71196' => 'Le Fay',
	'FR71198' => 'Flacey-en-Bresse',
	'FR71199' => 'Flagy',
	'FR71200' => 'Fleury-la-Montagne',
	'FR71201' => 'Fley',
	'FR71202' => 'Fontaines',
	'FR71203' => 'Fontenay',
	'FR71204' => 'Fragnes-La Loyère',
	'FR71205' => 'Frangy-en-Bresse',
	'FR71206' => 'La Frette',
	'FR71207' => 'Fretterans',
	'FR71208' => 'Frontenard',
	'FR71209' => 'Frontenaud',
	'FR71210' => 'Fuissé',
	'FR71212' => 'Génelard',
	'FR71213' => 'La Genête',
	'FR71214' => 'Genouilly',
	'FR71215' => 'Gergy',
	'FR71216' => 'Germagny',
	'FR71217' => 'Germolles-sur-Grosne',
	'FR71218' => 'Gibles',
	'FR71219' => 'Gigny-sur-Saône',
	'FR71220' => 'Gilly-sur-Loire',
	'FR71221' => 'Givry',
	'FR71222' => 'Gourdon',
	'FR71223' => 'La Grande-Verrière',
	'FR71224' => 'Grandvaux',
	'FR71225' => 'Granges',
	'FR71226' => 'Grevilly',
	'FR71227' => 'Grury',
	'FR71228' => 'Guerfand',
	'FR71229' => 'Les Guerreaux',
	'FR71230' => 'Gueugnon',
	'FR71231' => 'La Guiche',
	'FR71232' => 'Hautefond',
	'FR71233' => 'LHôpital-le-Mercier',
	'FR71234' => 'Huilly-sur-Seille',
	'FR71235' => 'Hurigny',
	'FR71236' => 'Igé',
	'FR71237' => 'Igornay',
	'FR71238' => 'Iguerande',
	'FR71239' => 'Issy-lÉvêque',
	'FR71240' => 'Jalogny',
	'FR71241' => 'Jambles',
	'FR71242' => 'Joncy',
	'FR71243' => 'Joudes',
	'FR71244' => 'Jouvençon',
	'FR71245' => 'Jugy',
	'FR71246' => 'Juif',
	'FR71247' => 'Jully-lès-Buxy',
	'FR71248' => 'Lacrost',
	'FR71249' => 'Laives',
	'FR71250' => 'Laizé',
	'FR71251' => 'Laizy',
	'FR71252' => 'Lalheue',
	'FR71253' => 'Lans',
	'FR71254' => 'Lays-sur-le-Doubs',
	'FR71255' => 'Lesme',
	'FR71256' => 'Lessard-en-Bresse',
	'FR71257' => 'Lessard-le-National',
	'FR71258' => 'Leynes',
	'FR71259' => 'Ligny-en-Brionnais',
	'FR71261' => 'Loisy',
	'FR71262' => 'Longepierre',
	'FR71263' => 'Louhans',
	'FR71264' => 'Lournand',
	'FR71266' => 'Lucenay-lÉvêque',
	'FR71267' => 'Lugny',
	'FR71268' => 'Lugny-lès-Charolles',
	'FR71269' => 'Lux',
	'FR71270' => 'Mâcon',
	'FR71271' => 'Mailly',
	'FR71272' => 'Malay',
	'FR71273' => 'Maltat',
	'FR71274' => 'Mancey',
	'FR71275' => 'Marcigny',
	'FR71276' => 'Marcilly-la-Gueurce',
	'FR71277' => 'Marcilly-lès-Buxy',
	'FR71278' => 'Marigny',
	'FR71279' => 'Le Rousset-Marizy',
	'FR71280' => 'Marly-sous-Issy',
	'FR71281' => 'Marly-sur-Arroux',
	'FR71282' => 'Marmagne',
	'FR71283' => 'Marnay',
	'FR71284' => 'Martailly-lès-Brancion',
	'FR71285' => 'Martigny-le-Comte',
	'FR71286' => 'Mary',
	'FR71287' => 'Massilly',
	'FR71289' => 'Matour',
	'FR71290' => 'Mazille',
	'FR71291' => 'Melay',
	'FR71292' => 'Mellecey',
	'FR71293' => 'Ménetreuil',
	'FR71294' => 'Mercurey',
	'FR71295' => 'Mervans',
	'FR71296' => 'Messey-sur-Grosne',
	'FR71297' => 'Mesvres',
	'FR71299' => 'Milly-Lamartine',
	'FR71300' => 'Le Miroir',
	'FR71301' => 'Mont',
	'FR71302' => 'Montagny-lès-Buxy',
	'FR71303' => 'Montagny-près-Louhans',
	'FR71305' => 'Montbellet',
	'FR71306' => 'Montceau-les-Mines',
	'FR71307' => 'Montceaux-lÉtoile',
	'FR71308' => 'Montceaux-Ragny',
	'FR71309' => 'Montcenis',
	'FR71310' => 'Montchanin',
	'FR71311' => 'Montcony',
	'FR71312' => 'Montcoy',
	'FR71313' => 'Monthelon',
	'FR71314' => 'Montjay',
	'FR71315' => 'Mont-lès-Seurre',
	'FR71316' => 'Montmelard',
	'FR71317' => 'Montmort',
	'FR71318' => 'Montpont-en-Bresse',
	'FR71319' => 'Montret',
	'FR71320' => 'Mont-Saint-Vincent',
	'FR71321' => 'Morey',
	'FR71322' => 'Morlet',
	'FR71323' => 'Mornay',
	'FR71324' => 'Moroges',
	'FR71325' => 'La Motte-Saint-Jean',
	'FR71326' => 'Mouthier-en-Bresse',
	'FR71327' => 'Mussy-sous-Dun',
	'FR71328' => 'Nanton',
	'FR71329' => 'Navilly',
	'FR71330' => 'Neuvy-Grandchamp',
	'FR71331' => 'Nochize',
	'FR71332' => 'Ormes',
	'FR71333' => 'Oslon',
	'FR71334' => 'Oudry',
	'FR71335' => 'Ouroux-sous-le-Bois-Sainte-Marie',
	'FR71336' => 'Ouroux-sur-Saône',
	'FR71337' => 'Oyé',
	'FR71338' => 'Ozenay',
	'FR71339' => 'Ozolles',
	'FR71340' => 'Palinges',
	'FR71341' => 'Palleau',
	'FR71342' => 'Paray-le-Monial',
	'FR71343' => 'Paris-lHôpital',
	'FR71344' => 'Passy',
	'FR71345' => 'Péronne',
	'FR71346' => 'Perrecy-les-Forges',
	'FR71347' => 'Perreuil',
	'FR71348' => 'Perrigny-sur-Loire',
	'FR71349' => 'La Petite-Verrière',
	'FR71350' => 'Pierreclos',
	'FR71351' => 'Pierre-de-Bresse',
	'FR71352' => 'Le Planois',
	'FR71353' => 'Plottes',
	'FR71354' => 'Poisson',
	'FR71355' => 'Pontoux',
	'FR71356' => 'Pouilloux',
	'FR71357' => 'Pourlans',
	'FR71358' => 'Pressy-sous-Dondin',
	'FR71359' => 'Préty',
	'FR71360' => 'Prissé',
	'FR71361' => 'Prizy',
	'FR71362' => 'Pruzilly',
	'FR71363' => 'Le Puley',
	'FR71364' => 'La Racineuse',
	'FR71365' => 'Rancy',
	'FR71366' => 'Ratenelle',
	'FR71367' => 'Ratte',
	'FR71368' => 'Reclesne',
	'FR71369' => 'Remigny',
	'FR71370' => 'Rigny-sur-Arroux',
	'FR71371' => 'La Roche-Vineuse',
	'FR71372' => 'Romanèche-Thorins',
	'FR71373' => 'Romenay',
	'FR71374' => 'Rosey',
	'FR71376' => 'Roussillon-en-Morvan',
	'FR71377' => 'Royer',
	'FR71378' => 'Rully',
	'FR71379' => 'Sagy',
	'FR71380' => 'Saillenard',
	'FR71381' => 'Sailly',
	'FR71382' => 'Saint-Agnan',
	'FR71383' => 'Saint-Albain',
	'FR71384' => 'Saint-Ambreuil',
	'FR71385' => 'Saint-Amour-Bellevue',
	'FR71386' => 'Saint-André-en-Bresse',
	'FR71387' => 'Saint-André-le-Désert',
	'FR71388' => 'Saint-Aubin-en-Charollais',
	'FR71389' => 'Saint-Aubin-sur-Loire',
	'FR71390' => 'Saint-Berain-sous-Sanvignes',
	'FR71391' => 'Saint-Bérain-sur-Dheune',
	'FR71392' => 'Saint-Boil',
	'FR71393' => 'Saint-Bonnet-de-Cray',
	'FR71394' => 'Saint-Bonnet-de-Joux',
	'FR71395' => 'Saint-Bonnet-de-Vieille-Vigne',
	'FR71396' => 'Saint-Bonnet-en-Bresse',
	'FR71397' => 'Sainte-Cécile',
	'FR71398' => 'Saint-Christophe-en-Bresse',
	'FR71399' => 'Saint-Christophe-en-Brionnais',
	'FR71400' => 'Saint-Clément-sur-Guye',
	'FR71401' => 'Sainte-Croix',
	'FR71402' => 'Saint-Cyr',
	'FR71403' => 'Saint-Denis-de-Vaux',
	'FR71404' => 'Saint-Désert',
	'FR71405' => 'Saint-Didier-en-Bresse',
	'FR71406' => 'Saint-Didier-en-Brionnais',
	'FR71407' => 'Saint-Didier-sur-Arroux',
	'FR71408' => 'Saint-Edmond',
	'FR71409' => 'Saint-Émiland',
	'FR71410' => 'Saint-Étienne-en-Bresse',
	'FR71411' => 'Saint-Eugène',
	'FR71412' => 'Saint-Eusèbe',
	'FR71413' => 'Saint-Firmin',
	'FR71414' => 'Saint-Forgeot',
	'FR71415' => 'Sainte-Foy',
	'FR71416' => 'Saint-Gengoux-de-Scissé',
	'FR71417' => 'Saint-Gengoux-le-National',
	'FR71419' => 'Saint-Germain-du-Bois',
	'FR71420' => 'Saint-Germain-du-Plain',
	'FR71421' => 'Saint-Germain-en-Brionnais',
	'FR71422' => 'Saint-Germain-lès-Buxy',
	'FR71423' => 'Saint-Gervais-en-Vallière',
	'FR71424' => 'Saint-Gervais-sur-Couches',
	'FR71425' => 'Saint-Gilles',
	'FR71426' => 'Sainte-Hélène',
	'FR71427' => 'Saint-Huruge',
	'FR71428' => 'Saint-Igny-de-Roche',
	'FR71430' => 'Saint-Jean-de-Vaux',
	'FR71431' => 'Saint-Jean-de-Trézy',
	'FR71433' => 'Saint-Julien-de-Civry',
	'FR71434' => 'Saint-Julien-de-Jonzy',
	'FR71435' => 'Saint-Julien-sur-Dheune',
	'FR71436' => 'Saint-Laurent-dAndenay',
	'FR71437' => 'Saint-Laurent-en-Brionnais',
	'FR71438' => 'Saint-Léger-du-Bois',
	'FR71439' => 'Saint-Léger-lès-Paray',
	'FR71440' => 'Saint-Léger-sous-Beuvray',
	'FR71441' => 'Saint-Léger-sous-la-Bussière',
	'FR71442' => 'Saint-Léger-sur-Dheune',
	'FR71443' => 'Saint-Loup-Géanges',
	'FR71444' => 'Saint-Loup-de-Varennes',
	'FR71445' => 'Saint-Marcel',
	'FR71446' => 'Saint-Marcelin-de-Cray',
	'FR71447' => 'Saint-Mard-de-Vaux',
	'FR71448' => 'Saint-Martin-Belle-Roche',
	'FR71449' => 'Saint-Martin-dAuxy',
	'FR71450' => 'Saint-Martin-de-Commune',
	'FR71451' => 'Saint-Martin-de-Lixy',
	'FR71452' => 'Saint-Martin-de-Salencey',
	'FR71453' => 'Saint-Martin-du-Lac',
	'FR71454' => 'Saint-Martin-du-Mont',
	'FR71455' => 'Saint-Martin-du-Tartre',
	'FR71456' => 'Saint-Martin-en-Bresse',
	'FR71457' => 'Saint-Martin-en-Gâtinois',
	'FR71458' => 'Saint-Martin-la-Patrouille',
	'FR71459' => 'Saint-Martin-sous-Montaigu',
	'FR71460' => 'Saint-Maurice-de-Satonnay',
	'FR71461' => 'Saint-Maurice-des-Champs',
	'FR71462' => 'Saint-Maurice-en-Rivière',
	'FR71463' => 'Saint-Maurice-lès-Châteauneuf',
	'FR71464' => 'Saint-Maurice-lès-Couches',
	'FR71465' => 'Saint-Micaud',
	'FR71466' => 'Saint-Nizier-sur-Arroux',
	'FR71468' => 'Saint-Pierre-de-Varennes',
	'FR71469' => 'Saint-Pierre-le-Vieux',
	'FR71470' => 'Saint-Point',
	'FR71471' => 'Saint-Privé',
	'FR71472' => 'Saint-Prix',
	'FR71473' => 'Saint-Racho',
	'FR71474' => 'Sainte-Radegonde',
	'FR71475' => 'Saint-Rémy',
	'FR71477' => 'Saint-Romain-sous-Gourdon',
	'FR71478' => 'Saint-Romain-sous-Versigny',
	'FR71479' => 'Saint-Sernin-du-Bois',
	'FR71480' => 'Saint-Sernin-du-Plain',
	'FR71481' => 'Saint-Symphorien-dAncelles',
	'FR71482' => 'Saint-Symphorien-de-Marmagne',
	'FR71483' => 'Saint-Symphorien-des-Bois',
	'FR71484' => 'Saint-Usuge',
	'FR71485' => 'Saint-Vallerin',
	'FR71486' => 'Saint-Vallier',
	'FR71487' => 'Saint-Vérand',
	'FR71488' => 'Saint-Vincent-des-Prés',
	'FR71489' => 'Saint-Vincent-en-Bresse',
	'FR71490' => 'Saint-Vincent-Bragny',
	'FR71491' => 'Saint-Yan',
	'FR71492' => 'Saint-Ythaire',
	'FR71493' => 'Saisy',
	'FR71494' => 'La Salle',
	'FR71495' => 'Salornay-sur-Guye',
	'FR71496' => 'Sampigny-lès-Maranges',
	'FR71497' => 'Sancé',
	'FR71498' => 'Santilly',
	'FR71499' => 'Sanvignes-les-Mines',
	'FR71500' => 'Sarry',
	'FR71501' => 'Sassangy',
	'FR71502' => 'Sassenay',
	'FR71503' => 'Saules',
	'FR71504' => 'Saunières',
	'FR71505' => 'Savianges',
	'FR71506' => 'Savigny-en-Revermont',
	'FR71507' => 'Savigny-sur-Grosne',
	'FR71508' => 'Savigny-sur-Seille',
	'FR71509' => 'La Celle-en-Morvan',
	'FR71510' => 'Semur-en-Brionnais',
	'FR71512' => 'Sennecey-le-Grand',
	'FR71513' => 'Senozan',
	'FR71514' => 'Sens-sur-Seille',
	'FR71515' => 'Sercy',
	'FR71516' => 'Serley',
	'FR71517' => 'Sermesse',
	'FR71518' => 'Serrières',
	'FR71519' => 'Serrigny-en-Bresse',
	'FR71520' => 'Sevrey',
	'FR71521' => 'Sigy-le-Châtel',
	'FR71522' => 'Simandre',
	'FR71523' => 'Simard',
	'FR71524' => 'Sivignon',
	'FR71525' => 'Sologny',
	'FR71526' => 'Solutré-Pouilly',
	'FR71527' => 'Sommant',
	'FR71528' => 'Sornay',
	'FR71529' => 'Suin',
	'FR71530' => 'Sully',
	'FR71531' => 'La Tagnière',
	'FR71532' => 'Taizé',
	'FR71533' => 'Tancon',
	'FR71534' => 'Le Tartre',
	'FR71535' => 'Tavernay',
	'FR71537' => 'Thil-sur-Arroux',
	'FR71538' => 'Thurey',
	'FR71539' => 'Tintry',
	'FR71540' => 'Torcy',
	'FR71541' => 'Torpes',
	'FR71542' => 'Toulon-sur-Arroux',
	'FR71543' => 'Tournus',
	'FR71544' => 'Toutenant',
	'FR71545' => 'Tramayes',
	'FR71546' => 'Trambly',
	'FR71547' => 'Trivy',
	'FR71548' => 'Tronchy',
	'FR71549' => 'La Truchère',
	'FR71550' => 'Uchizy',
	'FR71551' => 'Uchon',
	'FR71552' => 'Uxeau',
	'FR71553' => 'Vareilles',
	'FR71554' => 'Varenne-lArconce',
	'FR71555' => 'Varennes-le-Grand',
	'FR71556' => 'Varennes-lès-Mâcon',
	'FR71557' => 'Varenne-Saint-Germain',
	'FR71558' => 'Varennes-Saint-Sauveur',
	'FR71559' => 'Varennes-sous-Dun',
	'FR71561' => 'Vauban',
	'FR71562' => 'Vaudebarrier',
	'FR71563' => 'Vaux-en-Pré',
	'FR71564' => 'Vendenesse-lès-Charolles',
	'FR71565' => 'Vendenesse-sur-Arroux',
	'FR71566' => 'Verdun-sur-le-Doubs',
	'FR71567' => 'Vergisson',
	'FR71568' => 'Vérissey',
	'FR71570' => 'Verjux',
	'FR71571' => 'Verosvres',
	'FR71572' => 'Vers',
	'FR71573' => 'Versaugues',
	'FR71574' => 'Verzé',
	'FR71576' => 'Le Villars',
	'FR71577' => 'Villegaudin',
	'FR71578' => 'Clux-Villeneuve',
	'FR71579' => 'Villeneuve-en-Montagne',
	'FR71580' => 'Vincelles',
	'FR71581' => 'Vindecy',
	'FR71582' => 'La Vineuse sur Fregande',
	'FR71583' => 'Vinzelles',
	'FR71584' => 'Viré',
	'FR71585' => 'Virey-le-Grand',
	'FR71586' => 'Viry',
	'FR71588' => 'Vitry-en-Charollais',
	'FR71589' => 'Vitry-sur-Loire',
	'FR71590' => 'Volesvres',
	'FR71591' => 'Fleurville',
	'FR72001' => 'Aigné',
	'FR72002' => 'Aillières-Beauvoir',
	'FR72003' => 'Allonnes',
	'FR72004' => 'Amné',
	'FR72005' => 'Ancinnes',
	'FR72006' => 'Arçonnay',
	'FR72007' => 'Ardenay-sur-Mérize',
	'FR72008' => 'Arnage',
	'FR72009' => 'Arthezé',
	'FR72010' => 'Asnières-sur-Vègre',
	'FR72011' => 'Assé-le-Boisne',
	'FR72012' => 'Assé-le-Riboul',
	'FR72013' => 'Aubigné-Racan',
	'FR72015' => 'Les Aulneaux',
	'FR72016' => 'Auvers-le-Hamon',
	'FR72017' => 'Auvers-sous-Montfaucon',
	'FR72018' => 'Avesnes-en-Saosnois',
	'FR72019' => 'Avessé',
	'FR72020' => 'Avezé',
	'FR72021' => 'Avoise',
	'FR72022' => 'Le Bailleul',
	'FR72023' => 'Ballon-Saint Mars',
	'FR72024' => 'La Bazoge',
	'FR72025' => 'Bazouges Cré sur Loir',
	'FR72026' => 'Beaufay',
	'FR72027' => 'Beaumont-sur-Dême',
	'FR72028' => 'Beaumont-Pied-de-Bœuf',
	'FR72029' => 'Beaumont-sur-Sarthe',
	'FR72031' => 'Beillé',
	'FR72032' => 'Berfay',
	'FR72034' => 'Bérus',
	'FR72035' => 'Bessé-sur-Braye',
	'FR72036' => 'Béthon',
	'FR72037' => 'Blèves',
	'FR72038' => 'Boëssé-le-Sec',
	'FR72039' => 'Bonnétable',
	'FR72040' => 'La Bosse',
	'FR72041' => 'Bouër',
	'FR72042' => 'Bouloire',
	'FR72043' => 'Bourg-le-Roi',
	'FR72044' => 'Bousse',
	'FR72045' => 'Brains-sur-Gée',
	'FR72046' => 'Le Breil-sur-Mérize',
	'FR72047' => 'Brette-les-Pins',
	'FR72048' => 'Briosne-lès-Sables',
	'FR72049' => 'La Bruère-sur-Loir',
	'FR72050' => 'Brûlon',
	'FR72051' => 'Cérans-Foulletourte',
	'FR72052' => 'Chahaignes',
	'FR72053' => 'Challes',
	'FR72054' => 'Champagné',
	'FR72056' => 'Champfleur',
	'FR72057' => 'Champrond',
	'FR72058' => 'Changé',
	'FR72059' => 'Chantenay-Villedieu',
	'FR72060' => 'La Chapelle-aux-Choux',
	'FR72061' => 'La Chapelle-dAligné',
	'FR72062' => 'La Chapelle-du-Bois',
	'FR72064' => 'La Chapelle-Huon',
	'FR72065' => 'La Chapelle-Saint-Aubin',
	'FR72066' => 'La Chapelle-Saint-Fray',
	'FR72067' => 'La Chapelle-Saint-Rémy',
	'FR72068' => 'La Chartre-sur-le-Loir',
	'FR72070' => 'Chassillé',
	'FR72071' => 'Montval-sur-Loir',
	'FR72072' => 'Château-lHermitage',
	'FR72073' => 'Chaufour-Notre-Dame',
	'FR72074' => 'Chemiré-en-Charnie',
	'FR72075' => 'Chemiré-le-Gaudin',
	'FR72076' => 'Chenay',
	'FR72077' => 'Chenu',
	'FR72078' => 'Chérancé',
	'FR72079' => 'Chérisay',
	'FR72080' => 'Cherré-Au',
	'FR72083' => 'Chevillé',
	'FR72084' => 'Clermont-Créans',
	'FR72085' => 'Cogners',
	'FR72086' => 'Commerveil',
	'FR72087' => 'Conflans-sur-Anille',
	'FR72088' => 'Congé-sur-Orne',
	'FR72089' => 'Conlie',
	'FR72090' => 'Connerré',
	'FR72091' => 'Contilly',
	'FR72093' => 'Cormes',
	'FR72094' => 'Coudrecieux',
	'FR72095' => 'Coulaines',
	'FR72096' => 'Coulans-sur-Gée',
	'FR72098' => 'Coulongé',
	'FR72099' => 'Courcebœufs',
	'FR72100' => 'Courcelles-la-Forêt',
	'FR72101' => 'Courcemont',
	'FR72102' => 'Courcival',
	'FR72103' => 'Courdemanche',
	'FR72104' => 'Courgains',
	'FR72105' => 'Courgenard',
	'FR72106' => 'Courtillers',
	'FR72107' => 'Crannes-en-Champagne',
	'FR72109' => 'Crissé',
	'FR72110' => 'Crosmières',
	'FR72111' => 'Cures',
	'FR72112' => 'Dangeul',
	'FR72113' => 'Degré',
	'FR72114' => 'Dehault',
	'FR72115' => 'Dissay-sous-Courcillon',
	'FR72118' => 'Dollon',
	'FR72119' => 'Domfront-en-Champagne',
	'FR72120' => 'Doucelles',
	'FR72121' => 'Douillet',
	'FR72122' => 'Duneau',
	'FR72123' => 'Dureil',
	'FR72124' => 'Écommoy',
	'FR72125' => 'Écorpain',
	'FR72126' => 'Épineu-le-Chevreuil',
	'FR72127' => 'Étival-lès-le-Mans',
	'FR72128' => 'Val dÉtangson',
	'FR72129' => 'Fatines',
	'FR72130' => 'Fay',
	'FR72131' => 'Fercé-sur-Sarthe',
	'FR72132' => 'La Ferté-Bernard',
	'FR72133' => 'Fillé',
	'FR72134' => 'Flée',
	'FR72135' => 'La Fontaine-Saint-Martin',
	'FR72136' => 'Fontenay-sur-Vègre',
	'FR72137' => 'Villeneuve-en-Perseigne',
	'FR72138' => 'Fresnay-sur-Sarthe',
	'FR72139' => 'Fyé',
	'FR72141' => 'Gesnes-le-Gandelin',
	'FR72142' => 'Grandchamp',
	'FR72143' => 'Le Grand-Lucé',
	'FR72144' => 'Gréez-sur-Roc',
	'FR72145' => 'Le Grez',
	'FR72146' => 'Guécélard',
	'FR72147' => 'La Guierche',
	'FR72148' => 'Jauzé',
	'FR72149' => 'Joué-en-Charnie',
	'FR72150' => 'Joué-lAbbé',
	'FR72151' => 'Juigné-sur-Sarthe',
	'FR72152' => 'Juillé',
	'FR72153' => 'Jupilles',
	'FR72154' => 'La Flèche',
	'FR72155' => 'Laigné-en-Belin',
	'FR72156' => 'Lamnay',
	'FR72157' => 'Lavardin',
	'FR72158' => 'Lavaré',
	'FR72160' => 'Lavernat',
	'FR72161' => 'Lhomme',
	'FR72163' => 'Ligron',
	'FR72164' => 'Livet-en-Saosnois',
	'FR72165' => 'Lombron',
	'FR72166' => 'Longnes',
	'FR72167' => 'Louailles',
	'FR72168' => 'Loué',
	'FR72169' => 'Louplande',
	'FR72170' => 'Louvigny',
	'FR72171' => 'Louzes',
	'FR72172' => 'Le Luart',
	'FR72173' => 'Luceau',
	'FR72174' => 'Lucé-sous-Ballon',
	'FR72175' => 'Luché-Pringé',
	'FR72176' => 'Le Lude',
	'FR72177' => 'Maigné',
	'FR72178' => 'Maisoncelles',
	'FR72179' => 'Malicorne-sur-Sarthe',
	'FR72180' => 'Mamers',
	'FR72181' => 'Le Mans',
	'FR72182' => 'Mansigné',
	'FR72183' => 'Marçon',
	'FR72184' => 'Mareil-en-Champagne',
	'FR72185' => 'Mareil-sur-Loir',
	'FR72186' => 'Maresché',
	'FR72187' => 'Marigné-Laillé',
	'FR72188' => 'Marollette',
	'FR72189' => 'Marolles-les-Braults',
	'FR72190' => 'Marolles-lès-Saint-Calais',
	'FR72191' => 'Mayet',
	'FR72192' => 'Les Mées',
	'FR72193' => 'Melleray',
	'FR72194' => 'Meurcé',
	'FR72195' => 'Mézeray',
	'FR72196' => 'Mézières-sur-Ponthouin',
	'FR72197' => 'Mézières-sous-Lavardin',
	'FR72198' => 'La Milesse',
	'FR72199' => 'Moitron-sur-Sarthe',
	'FR72200' => 'Moncé-en-Belin',
	'FR72201' => 'Moncé-en-Saosnois',
	'FR72202' => 'Monhoudou',
	'FR72204' => 'Montaillé',
	'FR72205' => 'Montbizot',
	'FR72208' => 'Montmirail',
	'FR72209' => 'Montreuil-le-Chétif',
	'FR72210' => 'Montreuil-le-Henri',
	'FR72211' => 'Mont-Saint-Jean',
	'FR72212' => 'Moulins-le-Carbonnel',
	'FR72213' => 'Mulsanne',
	'FR72214' => 'Nauvay',
	'FR72215' => 'Neufchâtel-en-Saosnois',
	'FR72216' => 'Neuvillalais',
	'FR72217' => 'Neuville-sur-Sarthe',
	'FR72218' => 'Neuvillette-en-Charnie',
	'FR72219' => 'Bernay-Neuvy-en-Champagne',
	'FR72220' => 'Nogent-le-Bernard',
	'FR72221' => 'Nogent-sur-Loir',
	'FR72222' => 'Nouans',
	'FR72223' => 'Noyen-sur-Sarthe',
	'FR72224' => 'Nuillé-le-Jalais',
	'FR72225' => 'Oisseau-le-Petit',
	'FR72226' => 'Oizé',
	'FR72227' => 'Panon',
	'FR72228' => 'Parcé-sur-Sarthe',
	'FR72229' => 'Parennes',
	'FR72230' => 'Parigné-le-Pôlin',
	'FR72231' => 'Parigné-lÉvêque',
	'FR72232' => 'Notre-Dame-du-Pé',
	'FR72233' => 'Peray',
	'FR72234' => 'Pezé-le-Robert',
	'FR72235' => 'Piacé',
	'FR72236' => 'Pincé',
	'FR72237' => 'Pirmil',
	'FR72238' => 'Pizieux',
	'FR72239' => 'Poillé-sur-Vègre',
	'FR72241' => 'Montfort-le-Gesnois',
	'FR72243' => 'Pontvallain',
	'FR72244' => 'Précigné',
	'FR72245' => 'Préval',
	'FR72246' => 'Prévelles',
	'FR72247' => 'Pruillé-le-Chétif',
	'FR72248' => 'Pruillé-lÉguillé',
	'FR72249' => 'La Quinte',
	'FR72250' => 'Rahay',
	'FR72251' => 'René',
	'FR72252' => 'Requeil',
	'FR72253' => 'Roézé-sur-Sarthe',
	'FR72254' => 'Rouessé-Fontaine',
	'FR72255' => 'Rouessé-Vassé',
	'FR72256' => 'Rouez',
	'FR72257' => 'Rouillon',
	'FR72259' => 'Rouperroux-le-Coquet',
	'FR72260' => 'Ruaudin',
	'FR72261' => 'Ruillé-en-Champagne',
	'FR72262' => 'Loir en Vallée',
	'FR72264' => 'Sablé-sur-Sarthe',
	'FR72265' => 'Saint-Aignan',
	'FR72266' => 'Saint-Aubin-de-Locquenay',
	'FR72267' => 'Saint-Aubin-des-Coudrais',
	'FR72268' => 'Saint-Biez-en-Belin',
	'FR72269' => 'Saint-Calais',
	'FR72270' => 'Saint-Calez-en-Saosnois',
	'FR72271' => 'Saint-Célerin',
	'FR72272' => 'Sainte-Cérotte',
	'FR72273' => 'Saint-Christophe-du-Jambet',
	'FR72274' => 'Saint-Christophe-en-Champagne',
	'FR72275' => 'Saint-Corneille',
	'FR72276' => 'Saint-Cosme-en-Vairais',
	'FR72277' => 'Saint-Denis-des-Coudrais',
	'FR72278' => 'Saint-Denis-dOrques',
	'FR72279' => 'Saint-Georges-de-la-Couée',
	'FR72280' => 'Saint-Georges-du-Bois',
	'FR72281' => 'Saint-Georges-du-Rosay',
	'FR72282' => 'Saint-Georges-le-Gaultier',
	'FR72283' => 'Saint-Germain-dArcé',
	'FR72286' => 'Saint-Gervais-de-Vic',
	'FR72287' => 'Saint-Gervais-en-Belin',
	'FR72289' => 'Sainte-Jamme-sur-Sarthe',
	'FR72290' => 'Saint-Jean-dAssé',
	'FR72291' => 'Saint-Jean-de-la-Motte',
	'FR72292' => 'Saint-Jean-des-Échelles',
	'FR72293' => 'Saint-Jean-du-Bois',
	'FR72294' => 'Saint-Léonard-des-Bois',
	'FR72295' => 'Saint-Longis',
	'FR72296' => 'Saint-Maixent',
	'FR72297' => 'Saint-Marceau',
	'FR72298' => 'Saint-Mars-de-Locquenay',
	'FR72299' => 'Saint-Mars-dOutillé',
	'FR72300' => 'Saint-Mars-la-Brière',
	'FR72302' => 'Saint-Martin-des-Monts',
	'FR72303' => 'Saint-Michel-de-Chavaignes',
	'FR72305' => 'Saint-Ouen-de-Mimbré',
	'FR72306' => 'Saint-Ouen-en-Belin',
	'FR72307' => 'Saint-Ouen-en-Champagne',
	'FR72308' => 'Saint-Paterne - Le Chevain',
	'FR72309' => 'Saint-Paul-le-Gaultier',
	'FR72310' => 'Saint-Pavace',
	'FR72311' => 'Saint-Pierre-de-Chevillé',
	'FR72312' => 'Saint-Pierre-des-Bois',
	'FR72313' => 'Saint-Pierre-des-Ormes',
	'FR72314' => 'Saint-Pierre-du-Lorouër',
	'FR72315' => 'Saint-Rémy-de-Sillé',
	'FR72316' => 'Saint-Rémy-des-Monts',
	'FR72317' => 'Saint-Rémy-du-Val',
	'FR72319' => 'Sainte-Sabine-sur-Longève',
	'FR72320' => 'Saint-Saturnin',
	'FR72321' => 'Saint-Symphorien',
	'FR72322' => 'Saint-Ulphace',
	'FR72323' => 'Saint-Victeur',
	'FR72324' => 'Saint-Vincent-des-Prés',
	'FR72325' => 'Saint-Vincent-du-Lorouër',
	'FR72326' => 'Saosnes',
	'FR72327' => 'Sarcé',
	'FR72328' => 'Sargé-lès-le-Mans',
	'FR72329' => 'Savigné-lÉvêque',
	'FR72330' => 'Savigné-sous-le-Lude',
	'FR72331' => 'Sceaux-sur-Huisne',
	'FR72332' => 'Ségrie',
	'FR72333' => 'Semur-en-Vallon',
	'FR72334' => 'Sillé-le-Guillaume',
	'FR72335' => 'Sillé-le-Philippe',
	'FR72336' => 'Solesmes',
	'FR72337' => 'Sougé-le-Ganelon',
	'FR72338' => 'Souillé',
	'FR72339' => 'Souligné-Flacé',
	'FR72340' => 'Souligné-sous-Ballon',
	'FR72341' => 'Soulitré',
	'FR72342' => 'Souvigné-sur-Même',
	'FR72343' => 'Souvigné-sur-Sarthe',
	'FR72344' => 'Spay',
	'FR72345' => 'Surfonds',
	'FR72346' => 'La Suze-sur-Sarthe',
	'FR72347' => 'Tassé',
	'FR72348' => 'Tassillé',
	'FR72349' => 'Teillé',
	'FR72350' => 'Teloché',
	'FR72351' => 'Tennie',
	'FR72352' => 'Terrehault',
	'FR72353' => 'Théligny',
	'FR72354' => 'Thoigné',
	'FR72355' => 'Thoiré-sous-Contensor',
	'FR72356' => 'Thoiré-sur-Dinan',
	'FR72357' => 'Thorée-les-Pins',
	'FR72358' => 'Thorigné-sur-Dué',
	'FR72359' => 'Torcé-en-Vallée',
	'FR72360' => 'Trangé',
	'FR72361' => 'Tresson',
	'FR72362' => 'Le Tronchet',
	'FR72363' => 'Tuffé Val de la Chéronne',
	'FR72364' => 'Vaas',
	'FR72366' => 'Valennes',
	'FR72367' => 'Vallon-sur-Gée',
	'FR72368' => 'Vancé',
	'FR72369' => 'Verneil-le-Chétif',
	'FR72370' => 'Vernie',
	'FR72372' => 'Vezot',
	'FR72373' => 'Vibraye',
	'FR72374' => 'Villaines-la-Carelle',
	'FR72375' => 'Villaines-la-Gonais',
	'FR72376' => 'Villaines-sous-Lucé',
	'FR72377' => 'Villaines-sous-Malicorne',
	'FR72378' => 'Vion',
	'FR72379' => 'Viré-en-Champagne',
	'FR72380' => 'Vivoin',
	'FR72381' => 'Voivres-lès-le-Mans',
	'FR72382' => 'Volnay',
	'FR72383' => 'Vouvray-sur-Huisne',
	'FR72385' => 'Yvré-le-Pôlin',
	'FR72386' => 'Yvré-lÉvêque',
	'FR73001' => 'Aiguebelette-le-Lac',
	'FR73003' => 'Grand-Aigueblanche',
	'FR73004' => 'Aillon-le-Jeune',
	'FR73005' => 'Aillon-le-Vieux',
	'FR73006' => 'Aime-la-Plagne',
	'FR73007' => 'Aiton',
	'FR73008' => 'Aix-les-Bains',
	'FR73010' => 'Entrelacs',
	'FR73011' => 'Albertville',
	'FR73012' => 'Albiez-le-Jeune',
	'FR73013' => 'Albiez-Montrond',
	'FR73014' => 'Allondaz',
	'FR73015' => 'Les Allues',
	'FR73017' => 'Apremont',
	'FR73018' => 'Arbin',
	'FR73019' => 'Argentine',
	'FR73020' => 'Arith',
	'FR73021' => 'Arvillard',
	'FR73022' => 'Attignat-Oncin',
	'FR73023' => 'Aussois',
	'FR73024' => 'Les Avanchers-Valmorel',
	'FR73025' => 'Avressieux',
	'FR73026' => 'Avrieux',
	'FR73027' => 'Ayn',
	'FR73028' => 'La Balme',
	'FR73029' => 'Barberaz',
	'FR73030' => 'Barby',
	'FR73031' => 'Bassens',
	'FR73032' => 'La Bâthie',
	'FR73033' => 'La Bauche',
	'FR73034' => 'Beaufort',
	'FR73036' => 'Bellecombe-en-Bauges',
	'FR73039' => 'Belmont-Tramonet',
	'FR73040' => 'Bessans',
	'FR73041' => 'Betton-Bettonet',
	'FR73042' => 'Billième',
	'FR73043' => 'La Biolle',
	'FR73047' => 'Bonneval-sur-Arc',
	'FR73048' => 'Bonvillard',
	'FR73049' => 'Bonvillaret',
	'FR73050' => 'Bourdeau',
	'FR73051' => 'Le Bourget-du-Lac',
	'FR73052' => 'Bourget-en-Huile',
	'FR73053' => 'Bourgneuf',
	'FR73054' => 'Bourg-Saint-Maurice',
	'FR73055' => 'Bozel',
	'FR73057' => 'Brides-les-Bains',
	'FR73058' => 'La Bridoire',
	'FR73059' => 'Brison-Saint-Innocent',
	'FR73061' => 'Césarches',
	'FR73063' => 'Cevins',
	'FR73064' => 'Challes-les-Eaux',
	'FR73065' => 'Chambéry',
	'FR73067' => 'La Chambre',
	'FR73068' => 'Chamousset',
	'FR73069' => 'Chamoux-sur-Gelon',
	'FR73070' => 'Champagneux',
	'FR73071' => 'Champagny-en-Vanoise',
	'FR73072' => 'Champ-Laurent',
	'FR73073' => 'Chanaz',
	'FR73074' => 'La Chapelle',
	'FR73075' => 'La Chapelle-Blanche',
	'FR73076' => 'La Chapelle-du-Mont-du-Chat',
	'FR73077' => 'Les Chapelles',
	'FR73078' => 'La Chapelle-Saint-Martin',
	'FR73079' => 'Châteauneuf',
	'FR73081' => 'Le Châtelard',
	'FR73082' => 'La Chavanne',
	'FR73083' => 'Les Chavannes-en-Maurienne',
	'FR73084' => 'Chignin',
	'FR73085' => 'Chindrieux',
	'FR73086' => 'Cléry',
	'FR73087' => 'Cognin',
	'FR73088' => 'Cohennoz',
	'FR73089' => 'Coise-Saint-Jean-Pied-Gauthier',
	'FR73090' => 'La Compôte',
	'FR73091' => 'Conjux',
	'FR73092' => 'Corbel',
	'FR73094' => 'Crest-Voland',
	'FR73095' => 'La Croix-de-la-Rochette',
	'FR73096' => 'Cruet',
	'FR73097' => 'Curienne',
	'FR73098' => 'Les Déserts',
	'FR73099' => 'Détrier',
	'FR73100' => 'Domessin',
	'FR73101' => 'Doucy-en-Bauges',
	'FR73103' => 'Drumettaz-Clarafond',
	'FR73104' => 'Dullin',
	'FR73105' => 'Les Échelles',
	'FR73106' => 'École',
	'FR73107' => 'Entremont-le-Vieux',
	'FR73109' => 'Épierre',
	'FR73110' => 'Esserts-Blay',
	'FR73113' => 'Feissons-sur-Salins',
	'FR73114' => 'Flumet',
	'FR73116' => 'Fontcouverte-la-Toussuire',
	'FR73117' => 'Fourneaux',
	'FR73119' => 'Freney',
	'FR73120' => 'Fréterive',
	'FR73121' => 'Frontenex',
	'FR73122' => 'Gerbaix',
	'FR73123' => 'La Giettaz',
	'FR73124' => 'Gilly-sur-Isère',
	'FR73128' => 'Grésy-sur-Aix',
	'FR73129' => 'Grésy-sur-Isère',
	'FR73130' => 'Grignon',
	'FR73131' => 'Hautecour',
	'FR73132' => 'Hauteluce',
	'FR73133' => 'Hauteville',
	'FR73135' => 'La Tour-en-Maurienne',
	'FR73137' => 'Jacob-Bellecombette',
	'FR73138' => 'Jarrier',
	'FR73139' => 'Jarsy',
	'FR73140' => 'Jongieux',
	'FR73141' => 'Laissaud',
	'FR73142' => 'Landry',
	'FR73145' => 'Lépin-le-Lac',
	'FR73146' => 'Lescheraines',
	'FR73147' => 'Loisieux',
	'FR73149' => 'Lucey',
	'FR73150' => 'La Plagne Tarentaise',
	'FR73151' => 'Porte-de-Savoie',
	'FR73152' => 'Marcieux',
	'FR73153' => 'Marthod',
	'FR73154' => 'Mercury',
	'FR73155' => 'Méry',
	'FR73156' => 'Meyrieux-Trouet',
	'FR73157' => 'Modane',
	'FR73159' => 'Les Mollettes',
	'FR73160' => 'Montagnole',
	'FR73161' => 'Montagny',
	'FR73162' => 'Montailleur',
	'FR73164' => 'Montcel',
	'FR73166' => 'Montendry',
	'FR73168' => 'Montgilbert',
	'FR73170' => 'Monthion',
	'FR73171' => 'Montmélian',
	'FR73173' => 'Montricher-Albanne',
	'FR73175' => 'Montsapey',
	'FR73176' => 'Montvalezan',
	'FR73177' => 'Montvernier',
	'FR73178' => 'La Motte-en-Bauges',
	'FR73179' => 'La Motte-Servolex',
	'FR73180' => 'Motz',
	'FR73181' => 'Moûtiers',
	'FR73182' => 'Mouxy',
	'FR73183' => 'Myans',
	'FR73184' => 'Nances',
	'FR73186' => 'Notre-Dame-de-Bellecombe',
	'FR73187' => 'La Léchère',
	'FR73188' => 'Notre-Dame-des-Millières',
	'FR73189' => 'Notre-Dame-du-Cruet',
	'FR73190' => 'Notre-Dame-du-Pré',
	'FR73191' => 'Novalaise',
	'FR73192' => 'Le Noyer',
	'FR73193' => 'Ontex',
	'FR73194' => 'Orelle',
	'FR73196' => 'Pallud',
	'FR73197' => 'Peisey-Nancroix',
	'FR73200' => 'Planaise',
	'FR73201' => 'Planay',
	'FR73202' => 'Plancherine',
	'FR73204' => 'Le Pont-de-Beauvoisin',
	'FR73205' => 'Le Pontet',
	'FR73206' => 'Pralognan-la-Vanoise',
	'FR73207' => 'Presle',
	'FR73208' => 'Pugny-Chatenod',
	'FR73210' => 'Puygros',
	'FR73211' => 'Queige',
	'FR73212' => 'Val-dArc',
	'FR73213' => 'La Ravoire',
	'FR73214' => 'Rochefort',
	'FR73215' => 'Valgelon-La Rochette',
	'FR73216' => 'Rognaix',
	'FR73217' => 'Rotherens',
	'FR73218' => 'Ruffieux',
	'FR73219' => 'Saint-Alban-de-Montbel',
	'FR73220' => 'Saint-Alban-dHurtières',
	'FR73221' => 'Saint-Alban-des-Villards',
	'FR73222' => 'Saint-Alban-Leysse',
	'FR73223' => 'Saint-André',
	'FR73224' => 'Saint-Avre',
	'FR73225' => 'Saint-Baldoph',
	'FR73226' => 'Saint-Béron',
	'FR73227' => 'Courchevel',
	'FR73228' => 'Saint-Cassin',
	'FR73229' => 'Saint-Christophe',
	'FR73230' => 'Saint-Colomban-des-Villards',
	'FR73231' => 'Saint-Étienne-de-Cuines',
	'FR73232' => 'Sainte-Foy-Tarentaise',
	'FR73233' => 'Saint-Franc',
	'FR73234' => 'Saint-François-de-Sales',
	'FR73235' => 'Saint François Longchamp',
	'FR73236' => 'Saint-Genix-les-Villages',
	'FR73237' => 'Saint-Georges-dHurtières',
	'FR73240' => 'Sainte-Hélène-du-Lac',
	'FR73241' => 'Sainte-Hélène-sur-Isère',
	'FR73242' => 'Saint-Jean-dArves',
	'FR73243' => 'Saint-Jean-dArvey',
	'FR73245' => 'Saint-Jean-de-Chevelu',
	'FR73246' => 'Saint-Jean-de-Couz',
	'FR73247' => 'Saint-Jean-de-la-Porte',
	'FR73248' => 'Saint-Jean-de-Maurienne',
	'FR73249' => 'Saint-Jeoire-Prieuré',
	'FR73250' => 'Saint-Julien-Mont-Denis',
	'FR73252' => 'Saint-Léger',
	'FR73253' => 'Saint-Marcel',
	'FR73254' => 'Sainte-Marie-dAlvey',
	'FR73255' => 'Sainte-Marie-de-Cuines',
	'FR73256' => 'Saint-Martin-dArc',
	'FR73257' => 'Les Belleville',
	'FR73258' => 'Saint-Martin-de-la-Porte',
	'FR73259' => 'Saint-Martin-sur-la-Chambre',
	'FR73261' => 'Saint-Michel-de-Maurienne',
	'FR73262' => 'Saint-Nicolas-la-Chapelle',
	'FR73263' => 'Saint-Offenge',
	'FR73265' => 'Saint-Ours',
	'FR73267' => 'Saint-Pancrace',
	'FR73268' => 'Saint-Paul-sur-Isère',
	'FR73269' => 'Saint-Paul',
	'FR73270' => 'Saint-Pierre-dAlbigny',
	'FR73271' => 'Saint-Pierre-dAlvey',
	'FR73272' => 'Saint-Pierre-de-Belleville',
	'FR73273' => 'Saint-Pierre-de-Curtille',
	'FR73274' => 'Saint-Pierre-dEntremont',
	'FR73275' => 'Saint-Pierre-de-Genebroz',
	'FR73276' => 'Saint-Pierre-de-Soucy',
	'FR73277' => 'Sainte-Reine',
	'FR73278' => 'Saint-Rémy-de-Maurienne',
	'FR73280' => 'Saint-Sorlin-dArves',
	'FR73281' => 'Saint-Sulpice',
	'FR73282' => 'Saint-Thibaud-de-Couz',
	'FR73283' => 'Saint-Vital',
	'FR73284' => 'Salins-Fontaine',
	'FR73285' => 'Séez',
	'FR73286' => 'Serrières-en-Chautagne',
	'FR73288' => 'Sonnaz',
	'FR73289' => 'La Table',
	'FR73290' => 'Val-Cenis',
	'FR73292' => 'Thénésol',
	'FR73293' => 'Thoiry',
	'FR73294' => 'La Thuile',
	'FR73296' => 'Tignes',
	'FR73297' => 'Tournon',
	'FR73298' => 'Tours-en-Savoie',
	'FR73299' => 'Traize',
	'FR73300' => 'Tresserve',
	'FR73301' => 'Trévignin',
	'FR73302' => 'La Trinité',
	'FR73303' => 'Ugine',
	'FR73304' => 'Val-dIsère',
	'FR73306' => 'Valloire',
	'FR73307' => 'Valmeinier',
	'FR73308' => 'Venthon',
	'FR73309' => 'Verel-de-Montbel',
	'FR73310' => 'Verel-Pragondran',
	'FR73311' => 'Le Verneil',
	'FR73312' => 'Verrens-Arvey',
	'FR73313' => 'Verthemex',
	'FR73314' => 'Villard-dHéry',
	'FR73315' => 'Villard-Léger',
	'FR73316' => 'Villard-Sallet',
	'FR73317' => 'Villard-sur-Doron',
	'FR73318' => 'Villarembert',
	'FR73320' => 'Villargondran',
	'FR73322' => 'Villarodin-Bourget',
	'FR73323' => 'Villaroger',
	'FR73324' => 'Villaroux',
	'FR73326' => 'Vimines',
	'FR73327' => 'Vions',
	'FR73328' => 'Viviers-du-Lac',
	'FR73329' => 'Voglans',
	'FR73330' => 'Yenne',
	'FR74001' => 'Abondance',
	'FR74002' => 'Alby-sur-Chéran',
	'FR74003' => 'Alex',
	'FR74004' => 'Allèves',
	'FR74005' => 'Allinges',
	'FR74006' => 'Allonzier-la-Caille',
	'FR74007' => 'Amancy',
	'FR74008' => 'Ambilly',
	'FR74009' => 'Andilly',
	'FR74010' => 'Annecy',
	'FR74012' => 'Annemasse',
	'FR74013' => 'Anthy-sur-Léman',
	'FR74014' => 'Arâches-la-Frasse',
	'FR74015' => 'Arbusigny',
	'FR74016' => 'Archamps',
	'FR74018' => 'Arenthon',
	'FR74019' => 'Argonay',
	'FR74020' => 'Armoy',
	'FR74021' => 'Arthaz-Pont-Notre-Dame',
	'FR74024' => 'Ayse',
	'FR74025' => 'Ballaison',
	'FR74026' => 'La Balme-de-Sillingy',
	'FR74027' => 'La Balme-de-Thuy',
	'FR74029' => 'Bassy',
	'FR74030' => 'La Baume',
	'FR74031' => 'Beaumont',
	'FR74032' => 'Bellevaux',
	'FR74033' => 'Bernex',
	'FR74034' => 'Le Biot',
	'FR74035' => 'Bloye',
	'FR74036' => 'Bluffy',
	'FR74037' => 'Boëge',
	'FR74038' => 'Bogève',
	'FR74040' => 'Bonne',
	'FR74041' => 'Bonnevaux',
	'FR74042' => 'Bonneville',
	'FR74043' => 'Bons-en-Chablais',
	'FR74044' => 'Bossey',
	'FR74045' => 'Le Bouchet-Mont-Charvin',
	'FR74046' => 'Boussy',
	'FR74048' => 'Brenthonne',
	'FR74049' => 'Brizon',
	'FR74050' => 'Burdignin',
	'FR74051' => 'Cercier',
	'FR74052' => 'Cernex',
	'FR74053' => 'Cervens',
	'FR74054' => 'Chainaz-les-Frasses',
	'FR74055' => 'Challonges',
	'FR74056' => 'Chamonix-Mont-Blanc',
	'FR74057' => 'Champanges',
	'FR74058' => 'La Chapelle-dAbondance',
	'FR74059' => 'La Chapelle-Rambaud',
	'FR74060' => 'La Chapelle-Saint-Maurice',
	'FR74061' => 'Chapeiry',
	'FR74062' => 'Charvonnex',
	'FR74063' => 'Châtel',
	'FR74064' => 'Châtillon-sur-Cluses',
	'FR74065' => 'Chaumont',
	'FR74066' => 'Chavannaz',
	'FR74067' => 'Chavanod',
	'FR74068' => 'Chêne-en-Semine',
	'FR74069' => 'Chênex',
	'FR74070' => 'Chens-sur-Léman',
	'FR74071' => 'Chessenaz',
	'FR74072' => 'Chevaline',
	'FR74073' => 'Chevenoz',
	'FR74074' => 'Chevrier',
	'FR74075' => 'Chilly',
	'FR74076' => 'Choisy',
	'FR74077' => 'Clarafond-Arcine',
	'FR74078' => 'Clermont',
	'FR74079' => 'Les Clefs',
	'FR74080' => 'La Clusaz',
	'FR74081' => 'Cluses',
	'FR74082' => 'Collonges-sous-Salève',
	'FR74083' => 'Combloux',
	'FR74085' => 'Les Contamines-Montjoie',
	'FR74086' => 'Contamine-Sarzin',
	'FR74087' => 'Contamine-sur-Arve',
	'FR74088' => 'Copponex',
	'FR74089' => 'Cordon',
	'FR74090' => 'Cornier',
	'FR74091' => 'La Côte-dArbroz',
	'FR74094' => 'Cranves-Sales',
	'FR74095' => 'Crempigny-Bonneguête',
	'FR74096' => 'Cruseilles',
	'FR74097' => 'Cusy',
	'FR74098' => 'Cuvat',
	'FR74099' => 'Demi-Quartier',
	'FR74100' => 'Desingy',
	'FR74101' => 'Dingy-en-Vuache',
	'FR74102' => 'Dingy-Saint-Clair',
	'FR74103' => 'Domancy',
	'FR74104' => 'Doussard',
	'FR74105' => 'Douvaine',
	'FR74106' => 'Draillant',
	'FR74107' => 'Droisy',
	'FR74108' => 'Duingt',
	'FR74109' => 'Éloise',
	'FR74111' => 'Entrevernes',
	'FR74112' => 'Epagny Metz-Tessy',
	'FR74114' => 'Essert-Romand',
	'FR74116' => 'Etaux',
	'FR74117' => 'Étercy',
	'FR74118' => 'Étrembières',
	'FR74119' => 'Évian-les-Bains',
	'FR74121' => 'Excenevex',
	'FR74122' => 'Faucigny',
	'FR74123' => 'Faverges-Seythenex',
	'FR74124' => 'Feigères',
	'FR74126' => 'Fessy',
	'FR74127' => 'Féternes',
	'FR74128' => 'Fillinges',
	'FR74129' => 'La Forclaz',
	'FR74130' => 'Franclens',
	'FR74131' => 'Frangy',
	'FR74133' => 'Gaillard',
	'FR74134' => 'Les Gets',
	'FR74135' => 'Giez',
	'FR74136' => 'Le Grand-Bornand',
	'FR74137' => 'Groisy',
	'FR74138' => 'Gruffy',
	'FR74139' => 'Habère-Lullin',
	'FR74140' => 'Habère-Poche',
	'FR74141' => 'Hauteville-sur-Fier',
	'FR74142' => 'Héry-sur-Alby',
	'FR74143' => 'Les Houches',
	'FR74144' => 'Jonzier-Épagny',
	'FR74145' => 'Juvigny',
	'FR74146' => 'Larringes',
	'FR74147' => 'Lathuile',
	'FR74148' => 'Leschaux',
	'FR74150' => 'Loisin',
	'FR74151' => 'Lornay',
	'FR74152' => 'Lovagny',
	'FR74153' => 'Lucinges',
	'FR74154' => 'Lugrin',
	'FR74155' => 'Lullin',
	'FR74156' => 'Lully',
	'FR74157' => 'Lyaud',
	'FR74158' => 'Machilly',
	'FR74159' => 'Magland',
	'FR74160' => 'Manigod',
	'FR74161' => 'Marcellaz-Albanais',
	'FR74162' => 'Marcellaz',
	'FR74163' => 'Margencel',
	'FR74164' => 'Marignier',
	'FR74165' => 'Marigny-Saint-Marcel',
	'FR74166' => 'Marin',
	'FR74167' => 'Val de Chaise',
	'FR74168' => 'Marlioz',
	'FR74169' => 'Marnaz',
	'FR74170' => 'Massingy',
	'FR74171' => 'Massongy',
	'FR74172' => 'Maxilly-sur-Léman',
	'FR74173' => 'Megève',
	'FR74174' => 'Mégevette',
	'FR74175' => 'Meillerie',
	'FR74176' => 'Menthon-Saint-Bernard',
	'FR74177' => 'Menthonnex-en-Bornes',
	'FR74178' => 'Menthonnex-sous-Clermont',
	'FR74179' => 'Mésigny',
	'FR74180' => 'Messery',
	'FR74183' => 'Mieussy',
	'FR74184' => 'Minzier',
	'FR74185' => 'Monnetier-Mornex',
	'FR74186' => 'Montagny-les-Lanches',
	'FR74188' => 'Montriond',
	'FR74189' => 'Mont-Saxonnex',
	'FR74190' => 'Morillon',
	'FR74191' => 'Morzine',
	'FR74192' => 'Moye',
	'FR74193' => 'La Muraz',
	'FR74194' => 'Mûres',
	'FR74195' => 'Musièges',
	'FR74196' => 'Nancy-sur-Cluses',
	'FR74197' => 'Nangy',
	'FR74198' => 'Nâves-Parmelan',
	'FR74199' => 'Nernier',
	'FR74200' => 'Neuvecelle',
	'FR74201' => 'Neydens',
	'FR74202' => 'Nonglard',
	'FR74203' => 'Novel',
	'FR74205' => 'Onnion',
	'FR74206' => 'Orcier',
	'FR74208' => 'Passy',
	'FR74209' => 'Peillonnex',
	'FR74210' => 'Perrignier',
	'FR74211' => 'Pers-Jussy',
	'FR74212' => 'Glières-Val-de-Borne',
	'FR74213' => 'Poisy',
	'FR74215' => 'Praz-sur-Arly',
	'FR74216' => 'Présilly',
	'FR74218' => 'Publier',
	'FR74219' => 'Quintal',
	'FR74220' => 'Reignier-Ésery',
	'FR74221' => 'Le Reposoir',
	'FR74222' => 'Reyvroz',
	'FR74223' => 'La Rivière-Enverse',
	'FR74224' => 'La Roche-sur-Foron',
	'FR74225' => 'Rumilly',
	'FR74226' => 'Saint-André-de-Boëge',
	'FR74228' => 'Saint-Blaise',
	'FR74229' => 'Saint-Cergues',
	'FR74231' => 'Saint-Eusèbe',
	'FR74232' => 'Saint-Eustache',
	'FR74233' => 'Saint-Félix',
	'FR74234' => 'Saint-Ferréol',
	'FR74235' => 'Saint-Germain-sur-Rhône',
	'FR74236' => 'Saint-Gervais-les-Bains',
	'FR74237' => 'Saint-Gingolph',
	'FR74238' => 'Saint-Jean-dAulps',
	'FR74239' => 'Saint-Jean-de-Sixt',
	'FR74240' => 'Saint-Jean-de-Tholome',
	'FR74241' => 'Saint-Jeoire',
	'FR74242' => 'Saint-Jorioz',
	'FR74243' => 'Saint-Julien-en-Genevois',
	'FR74244' => 'Saint-Laurent',
	'FR74249' => 'Saint-Paul-en-Chablais',
	'FR74250' => 'Saint-Pierre-en-Faucigny',
	'FR74252' => 'Saint-Sigismond',
	'FR74253' => 'Saint-Sixt',
	'FR74254' => 'Saint-Sylvestre',
	'FR74255' => 'Sales',
	'FR74256' => 'Sallanches',
	'FR74257' => 'Sallenôves',
	'FR74258' => 'Samoëns',
	'FR74259' => 'Le Sappey',
	'FR74260' => 'Savigny',
	'FR74261' => 'Saxel',
	'FR74262' => 'Scientrier',
	'FR74263' => 'Sciez',
	'FR74264' => 'Scionzier',
	'FR74265' => 'Serraval',
	'FR74266' => 'Servoz',
	'FR74267' => 'Sevrier',
	'FR74269' => 'Seyssel',
	'FR74271' => 'Seytroux',
	'FR74272' => 'Sillingy',
	'FR74273' => 'Sixt-Fer-à-Cheval',
	'FR74275' => 'Talloires-Montmin',
	'FR74276' => 'Taninges',
	'FR74278' => 'Thyez',
	'FR74279' => 'Thollon-les-Mémises',
	'FR74280' => 'Thônes',
	'FR74281' => 'Thonon-les-Bains',
	'FR74282' => 'Fillière',
	'FR74283' => 'Thusy',
	'FR74284' => 'La Tour',
	'FR74285' => 'Usinens',
	'FR74286' => 'Vacheresse',
	'FR74287' => 'Vailly',
	'FR74288' => 'Valleiry',
	'FR74289' => 'Vallières-sur-Fier',
	'FR74290' => 'Vallorcine',
	'FR74291' => 'Vanzy',
	'FR74292' => 'Vaulx',
	'FR74293' => 'Veigy-Foncenex',
	'FR74294' => 'Verchaix',
	'FR74295' => 'La Vernaz',
	'FR74296' => 'Vers',
	'FR74297' => 'Versonnex',
	'FR74298' => 'Vétraz-Monthoux',
	'FR74299' => 'Veyrier-du-Lac',
	'FR74301' => 'Villard',
	'FR74302' => 'Les Villards-sur-Thônes',
	'FR74303' => 'Villaz',
	'FR74304' => 'Ville-en-Sallaz',
	'FR74305' => 'Ville-la-Grand',
	'FR74306' => 'Villy-le-Bouveret',
	'FR74307' => 'Villy-le-Pelloux',
	'FR74308' => 'Vinzier',
	'FR74309' => 'Viry',
	'FR74310' => 'Viuz-la-Chiésaz',
	'FR74311' => 'Viuz-en-Sallaz',
	'FR74312' => 'Vougy',
	'FR74313' => 'Vovray-en-Bornes',
	'FR74314' => 'Vulbens',
	'FR74315' => 'Yvoire',
	'FR75056' => 'Paris',
	'FR76001' => 'Allouville-Bellefosse',
	'FR76002' => 'Alvimare',
	'FR76004' => 'Ambrumesnil',
	'FR76005' => 'Amfreville-la-Mi-Voie',
	'FR76006' => 'Amfreville-les-Champs',
	'FR76007' => 'Anceaumeville',
	'FR76008' => 'Ancourt',
	'FR76009' => 'Ancourteville-sur-Héricourt',
	'FR76010' => 'Ancretiéville-Saint-Victor',
	'FR76011' => 'Ancretteville-sur-Mer',
	'FR76012' => 'Angerville-Bailleul',
	'FR76013' => 'Angerville-la-Martel',
	'FR76014' => 'Angerville-lOrcher',
	'FR76015' => 'Angiens',
	'FR76016' => 'Anglesqueville-la-Bras-Long',
	'FR76017' => 'Anglesqueville-lEsneval',
	'FR76018' => 'Val-de-Saâne',
	'FR76019' => 'Anneville-sur-Scie',
	'FR76020' => 'Anneville-Ambourville',
	'FR76021' => 'Annouville-Vilmesnil',
	'FR76022' => 'Anquetierville',
	'FR76023' => 'Anvéville',
	'FR76024' => 'Ardouval',
	'FR76025' => 'Argueil',
	'FR76026' => 'Arques-la-Bataille',
	'FR76028' => 'Aubéguimont',
	'FR76029' => 'Aubermesnil-aux-Érables',
	'FR76030' => 'Aubermesnil-Beaumais',
	'FR76032' => 'Auberville-la-Manuel',
	'FR76033' => 'Auberville-la-Renault',
	'FR76034' => 'Val-de-Scie',
	'FR76035' => 'Aumale',
	'FR76036' => 'Auppegard',
	'FR76038' => 'Authieux-Ratiéville',
	'FR76039' => 'Les Authieux-sur-le-Port-Saint-Ouen',
	'FR76040' => 'Autigny',
	'FR76041' => 'Les Hauts-de-Caux',
	'FR76042' => 'Auvilliers',
	'FR76043' => 'Auzebosc',
	'FR76045' => 'Auzouville-lEsneval',
	'FR76046' => 'Auzouville-sur-Ry',
	'FR76047' => 'Auzouville-sur-Saâne',
	'FR76048' => 'Avesnes-en-Bray',
	'FR76049' => 'Avesnes-en-Val',
	'FR76050' => 'Avremesnil',
	'FR76051' => 'Bacqueville-en-Caux',
	'FR76052' => 'Bailleul-Neuville',
	'FR76053' => 'Baillolet',
	'FR76054' => 'Bailly-en-Rivière',
	'FR76055' => 'Baons-le-Comte',
	'FR76056' => 'Bardouville',
	'FR76057' => 'Barentin',
	'FR76058' => 'Baromesnil',
	'FR76059' => 'Bazinval',
	'FR76060' => 'Beaubec-la-Rosière',
	'FR76062' => 'Beaumont-le-Hareng',
	'FR76063' => 'Beauval-en-Caux',
	'FR76064' => 'Beaurepaire',
	'FR76065' => 'Beaussault',
	'FR76066' => 'Beautot',
	'FR76067' => 'Beauvoir-en-Lyons',
	'FR76068' => 'Bec-de-Mortagne',
	'FR76069' => 'Belbeuf',
	'FR76070' => 'Bellencombre',
	'FR76071' => 'Bellengreville',
	'FR76072' => 'Belleville-en-Caux',
	'FR76074' => 'La Bellière',
	'FR76075' => 'Belmesnil',
	'FR76076' => 'Bénarville',
	'FR76077' => 'Bénesville',
	'FR76079' => 'Bénouville',
	'FR76082' => 'Bernières',
	'FR76083' => 'Bertheauville',
	'FR76084' => 'Bertreville',
	'FR76085' => 'Bertreville-Saint-Ouen',
	'FR76086' => 'Bertrimont',
	'FR76087' => 'Berville-en-Caux',
	'FR76088' => 'Berville-sur-Seine',
	'FR76090' => 'Beuzeville-la-Grenier',
	'FR76091' => 'Beuzeville-la-Guérard',
	'FR76092' => 'Beuzevillette',
	'FR76093' => 'Bézancourt',
	'FR76094' => 'Bierville',
	'FR76095' => 'Bihorel',
	'FR76096' => 'Biville-la-Baignarde',
	'FR76097' => 'Biville-la-Rivière',
	'FR76099' => 'Blacqueville',
	'FR76100' => 'Blainville-Crevon',
	'FR76101' => 'Blangy-sur-Bresle',
	'FR76103' => 'Bonsecours',
	'FR76104' => 'Blosseville',
	'FR76105' => 'Le Bocasse',
	'FR76106' => 'Bois-dEnnebourg',
	'FR76107' => 'Bois-Guilbert',
	'FR76108' => 'Bois-Guillaume',
	'FR76109' => 'Bois-Héroult',
	'FR76110' => 'Bois-Himont',
	'FR76111' => 'Bois-lÉvêque',
	'FR76112' => 'Le Bois-Robert',
	'FR76113' => 'Boissay',
	'FR76114' => 'Bolbec',
	'FR76115' => 'Bolleville',
	'FR76116' => 'Boos',
	'FR76117' => 'Bordeaux-Saint-Clair',
	'FR76118' => 'Bornambusc',
	'FR76119' => 'Bosc-Bérenger',
	'FR76120' => 'Bosc-Bordel',
	'FR76121' => 'Bosc-Édeline',
	'FR76122' => 'Callengeville',
	'FR76123' => 'Bosc-Guérard-Saint-Adrien',
	'FR76124' => 'Bosc-Hyons',
	'FR76125' => 'Bosc-le-Hard',
	'FR76126' => 'Bosc-Mesnil',
	'FR76128' => 'Bosville',
	'FR76129' => 'Boudeville',
	'FR76130' => 'Bouelles',
	'FR76131' => 'La Bouille',
	'FR76132' => 'Bourdainville',
	'FR76133' => 'Le Bourg-Dun',
	'FR76134' => 'Bourville',
	'FR76135' => 'Bouville',
	'FR76136' => 'Brachy',
	'FR76138' => 'Bracquetuit',
	'FR76139' => 'Bradiancourt',
	'FR76140' => 'Brametot',
	'FR76141' => 'Bréauté',
	'FR76142' => 'Brémontier-Merval',
	'FR76143' => 'Bretteville-du-Grand-Caux',
	'FR76144' => 'Bretteville-Saint-Laurent',
	'FR76146' => 'Buchy',
	'FR76147' => 'Bully',
	'FR76148' => 'Bures-en-Bray',
	'FR76149' => 'Butot',
	'FR76151' => 'Cailleville',
	'FR76152' => 'Cailly',
	'FR76153' => 'Calleville-les-Deux-Églises',
	'FR76154' => 'Campneuseville',
	'FR76155' => 'Canehan',
	'FR76156' => 'Canouville',
	'FR76157' => 'Canteleu',
	'FR76158' => 'Canville-les-Deux-Églises',
	'FR76159' => 'Cany-Barville',
	'FR76160' => 'Carville-la-Folletière',
	'FR76161' => 'Carville-Pot-de-Fer',
	'FR76162' => 'Le Catelier',
	'FR76163' => 'Catenay',
	'FR76164' => 'Rives-en-Seine',
	'FR76165' => 'Caudebec-lès-Elbeuf',
	'FR76166' => 'Le Caule-Sainte-Beuve',
	'FR76167' => 'Cauville-sur-Mer',
	'FR76168' => 'Les Cent-Acres',
	'FR76169' => 'La Cerlangue',
	'FR76170' => 'La Chapelle-du-Bourgay',
	'FR76171' => 'La Chapelle-Saint-Ouen',
	'FR76172' => 'La Chapelle-sur-Dun',
	'FR76173' => 'La Chaussée',
	'FR76174' => 'Cideville',
	'FR76175' => 'Clais',
	'FR76176' => 'Clasville',
	'FR76177' => 'Claville-Motteville',
	'FR76178' => 'Cléon',
	'FR76179' => 'Clères',
	'FR76180' => 'Cleuville',
	'FR76181' => 'Cléville',
	'FR76182' => 'Cliponville',
	'FR76183' => 'Colleville',
	'FR76184' => 'Colmesnil-Manneville',
	'FR76185' => 'Compainville',
	'FR76186' => 'Conteville',
	'FR76187' => 'Contremoulins',
	'FR76188' => 'Cottévrard',
	'FR76189' => 'Crasville-la-Mallet',
	'FR76190' => 'Crasville-la-Rocquefort',
	'FR76192' => 'Criel-sur-Mer',
	'FR76193' => 'La Crique',
	'FR76194' => 'Criquebeuf-en-Caux',
	'FR76195' => 'Criquetot-le-Mauconduit',
	'FR76196' => 'Criquetot-lEsneval',
	'FR76197' => 'Criquetot-sur-Longueville',
	'FR76198' => 'Criquetot-sur-Ouville',
	'FR76199' => 'Criquiers',
	'FR76200' => 'Critot',
	'FR76201' => 'Croisy-sur-Andelle',
	'FR76202' => 'Croixdalle',
	'FR76203' => 'Croix-Mare',
	'FR76204' => 'Cropus',
	'FR76205' => 'Crosville-sur-Scie',
	'FR76206' => 'Cuverville',
	'FR76207' => 'Cuverville-sur-Yères',
	'FR76208' => 'Cuy-Saint-Fiacre',
	'FR76209' => 'Dampierre-en-Bray',
	'FR76210' => 'Dampierre-Saint-Nicolas',
	'FR76211' => 'Dancourt',
	'FR76212' => 'Darnétal',
	'FR76213' => 'Daubeuf-Serville',
	'FR76214' => 'Dénestanville',
	'FR76216' => 'Déville-lès-Rouen',
	'FR76217' => 'Dieppe',
	'FR76218' => 'Doudeauville',
	'FR76219' => 'Doudeville',
	'FR76220' => 'Douvrend',
	'FR76221' => 'Drosay',
	'FR76222' => 'Duclair',
	'FR76223' => 'Écalles-Alix',
	'FR76224' => 'Écrainville',
	'FR76225' => 'Écretteville-lès-Baons',
	'FR76226' => 'Écretteville-sur-Mer',
	'FR76227' => 'Ectot-lAuber',
	'FR76228' => 'Ectot-lès-Baons',
	'FR76229' => 'Elbeuf-en-Bray',
	'FR76230' => 'Elbeuf-sur-Andelle',
	'FR76231' => 'Elbeuf',
	'FR76232' => 'Életot',
	'FR76233' => 'Ellecourt',
	'FR76234' => 'Émanville',
	'FR76235' => 'Envermeu',
	'FR76236' => 'Envronville',
	'FR76237' => 'Épinay-sur-Duclair',
	'FR76238' => 'Épouville',
	'FR76239' => 'Épretot',
	'FR76240' => 'Épreville',
	'FR76241' => 'Ermenouville',
	'FR76242' => 'Ernemont-la-Villette',
	'FR76243' => 'Ernemont-sur-Buchy',
	'FR76244' => 'Esclavelles',
	'FR76245' => 'Eslettes',
	'FR76247' => 'Esteville',
	'FR76249' => 'Étaimpuis',
	'FR76250' => 'Étainhus',
	'FR76251' => 'Étalleville',
	'FR76252' => 'Étalondes',
	'FR76253' => 'Étoutteville',
	'FR76254' => 'Étretat',
	'FR76255' => 'Eu',
	'FR76257' => 'Fallencourt',
	'FR76258' => 'Terres-de-Caux',
	'FR76259' => 'Fécamp',
	'FR76260' => 'Ferrières-en-Bray',
	'FR76261' => 'La Ferté-Saint-Samson',
	'FR76262' => 'Fesques',
	'FR76263' => 'La Feuillie',
	'FR76264' => 'Flamanville',
	'FR76265' => 'Flamets-Frétils',
	'FR76266' => 'Flocques',
	'FR76268' => 'Fongueusemare',
	'FR76269' => 'Fontaine-en-Bray',
	'FR76270' => 'Fontaine-la-Mallet',
	'FR76271' => 'Fontaine-le-Bourg',
	'FR76272' => 'Fontaine-le-Dun',
	'FR76273' => 'Fontaine-sous-Préaux',
	'FR76274' => 'La Fontelaye',
	'FR76275' => 'Fontenay',
	'FR76276' => 'Forges-les-Eaux',
	'FR76278' => 'Foucarmont',
	'FR76279' => 'Foucart',
	'FR76280' => 'Fréauville',
	'FR76281' => 'La Frénaye',
	'FR76282' => 'Freneuse',
	'FR76283' => 'Fresles',
	'FR76284' => 'Fresnay-le-Long',
	'FR76285' => 'Fresne-le-Plan',
	'FR76286' => 'Fresnoy-Folny',
	'FR76287' => 'Fresquiennes',
	'FR76288' => 'Freulleville',
	'FR76289' => 'Saint Martin de lIf',
	'FR76290' => 'Frichemesnil',
	'FR76291' => 'Froberville',
	'FR76292' => 'Fry',
	'FR76293' => 'Fultot',
	'FR76294' => 'La Gaillarde',
	'FR76295' => 'Gaillefontaine',
	'FR76296' => 'Gainneville',
	'FR76297' => 'Gancourt-Saint-Étienne',
	'FR76298' => 'Ganzeville',
	'FR76299' => 'Gerponville',
	'FR76300' => 'Gerville',
	'FR76302' => 'Goderville',
	'FR76303' => 'Gommerville',
	'FR76304' => 'Gonfreville-Caillot',
	'FR76305' => 'Gonfreville-lOrcher',
	'FR76306' => 'Gonnetot',
	'FR76307' => 'Gonneville-la-Mallet',
	'FR76308' => 'Gonneville-sur-Scie',
	'FR76309' => 'Gonzeville',
	'FR76311' => 'Goupillières',
	'FR76312' => 'Gournay-en-Bray',
	'FR76313' => 'Gouy',
	'FR76314' => 'Graimbouville',
	'FR76315' => 'Grainville-la-Teinturière',
	'FR76316' => 'Grainville-sur-Ry',
	'FR76317' => 'Grainville-Ymauville',
	'FR76318' => 'Grand-Camp',
	'FR76319' => 'Grand-Couronne',
	'FR76320' => 'Grandcourt',
	'FR76321' => 'Les Grandes-Ventes',
	'FR76322' => 'Le Grand-Quevilly',
	'FR76323' => 'Graval',
	'FR76324' => 'Grèges',
	'FR76325' => 'Grémonville',
	'FR76327' => 'Greuville',
	'FR76328' => 'Grigneuseville',
	'FR76329' => 'Gruchet-le-Valasse',
	'FR76330' => 'Gruchet-Saint-Siméon',
	'FR76331' => 'Grugny',
	'FR76332' => 'Grumesnil',
	'FR76333' => 'Guerville',
	'FR76334' => 'Gueures',
	'FR76335' => 'Gueutteville',
	'FR76336' => 'Gueutteville-les-Grès',
	'FR76338' => 'La Hallotière',
	'FR76339' => 'Le Hanouard',
	'FR76340' => 'Harcanville',
	'FR76341' => 'Harfleur',
	'FR76342' => 'Hattenville',
	'FR76343' => 'Haucourt',
	'FR76344' => 'Haudricourt',
	'FR76345' => 'Haussez',
	'FR76346' => 'Hautot-lAuvray',
	'FR76347' => 'Hautot-le-Vatois',
	'FR76348' => 'Hautot-Saint-Sulpice',
	'FR76349' => 'Hautot-sur-Mer',
	'FR76350' => 'Hautot-sur-Seine',
	'FR76351' => 'Le Havre',
	'FR76352' => 'La Haye',
	'FR76353' => 'Héberville',
	'FR76354' => 'Hénouville',
	'FR76355' => 'Héricourt-en-Caux',
	'FR76356' => 'Hermanville',
	'FR76357' => 'Hermeville',
	'FR76358' => 'Le Héron',
	'FR76359' => 'Héronchelles',
	'FR76360' => 'Heugleville-sur-Scie',
	'FR76361' => 'Heuqueville',
	'FR76362' => 'Heurteauville',
	'FR76363' => 'Hodeng-au-Bosc',
	'FR76364' => 'Hodeng-Hodenger',
	'FR76365' => 'Houdetot',
	'FR76366' => 'Le Houlme',
	'FR76367' => 'Houppeville',
	'FR76368' => 'Houquetot',
	'FR76369' => 'La Houssaye-Béranger',
	'FR76370' => 'Hugleville-en-Caux',
	'FR76371' => 'Les Ifs',
	'FR76372' => 'Illois',
	'FR76373' => 'Imbleville',
	'FR76374' => 'Incheville',
	'FR76375' => 'Ingouville',
	'FR76377' => 'Isneauville',
	'FR76378' => 'Jumièges',
	'FR76379' => 'Lamberville',
	'FR76380' => 'Lammerville',
	'FR76381' => 'Landes-Vieilles-et-Neuves',
	'FR76382' => 'Lanquetot',
	'FR76383' => 'Lestanville',
	'FR76384' => 'Lillebonne',
	'FR76385' => 'Limésy',
	'FR76386' => 'Limpiville',
	'FR76387' => 'Lindebeuf',
	'FR76388' => 'Lintot',
	'FR76389' => 'Lintot-les-Bois',
	'FR76390' => 'Les Loges',
	'FR76391' => 'La Londe',
	'FR76392' => 'Londinières',
	'FR76393' => 'Longmesnil',
	'FR76394' => 'Longroy',
	'FR76395' => 'Longueil',
	'FR76396' => 'Longuerue',
	'FR76397' => 'Longueville-sur-Scie',
	'FR76398' => 'Louvetot',
	'FR76399' => 'Lucy',
	'FR76400' => 'Luneray',
	'FR76401' => 'Arelaune-en-Seine',
	'FR76402' => 'Malaunay',
	'FR76403' => 'Malleville-les-Grès',
	'FR76404' => 'Manéglise',
	'FR76405' => 'Manéhouville',
	'FR76406' => 'Maniquerville',
	'FR76407' => 'Manneville-ès-Plains',
	'FR76408' => 'Manneville-la-Goupil',
	'FR76409' => 'Mannevillette',
	'FR76410' => 'Maromme',
	'FR76411' => 'Marques',
	'FR76412' => 'Martainville-Épreville',
	'FR76413' => 'Martigny',
	'FR76414' => 'Martin-Église',
	'FR76415' => 'Massy',
	'FR76416' => 'Mathonville',
	'FR76417' => 'Maucomble',
	'FR76418' => 'Maulévrier-Sainte-Gertrude',
	'FR76419' => 'Mauny',
	'FR76420' => 'Mauquenchy',
	'FR76421' => 'Mélamare',
	'FR76422' => 'Melleville',
	'FR76423' => 'Ménerval',
	'FR76424' => 'Ménonval',
	'FR76425' => 'Mentheville',
	'FR76426' => 'Mésangueville',
	'FR76427' => 'Mesnières-en-Bray',
	'FR76428' => 'Le Mesnil-Durdent',
	'FR76429' => 'Le Mesnil-Esnard',
	'FR76430' => 'Mesnil-Follemprise',
	'FR76431' => 'Le Mesnil-Lieubray',
	'FR76432' => 'Mesnil-Mauger',
	'FR76433' => 'Mesnil-Panneville',
	'FR76434' => 'Mesnil-Raoul',
	'FR76435' => 'Le Mesnil-Réaume',
	'FR76436' => 'Le Mesnil-sous-Jumièges',
	'FR76437' => 'Meulers',
	'FR76438' => 'Millebosc',
	'FR76439' => 'Mirville',
	'FR76440' => 'Molagnies',
	'FR76441' => 'Monchaux-Soreng',
	'FR76442' => 'Monchy-sur-Eu',
	'FR76443' => 'Mont-Cauvaire',
	'FR76445' => 'Montérolier',
	'FR76446' => 'Montigny',
	'FR76447' => 'Montivilliers',
	'FR76448' => 'Montmain',
	'FR76449' => 'Montreuil-en-Caux',
	'FR76450' => 'Montroty',
	'FR76451' => 'Mont-Saint-Aignan',
	'FR76452' => 'Montville',
	'FR76453' => 'Morgny-la-Pommeraye',
	'FR76454' => 'Mortemer',
	'FR76455' => 'Morville-sur-Andelle',
	'FR76456' => 'Motteville',
	'FR76457' => 'Moulineaux',
	'FR76458' => 'Muchedent',
	'FR76459' => 'Nesle-Hodeng',
	'FR76460' => 'Nesle-Normandeuse',
	'FR76461' => 'Neufbosc',
	'FR76462' => 'Neufchâtel-en-Bray',
	'FR76463' => 'Neuf-Marché',
	'FR76464' => 'La Neuville-Chant-dOisel',
	'FR76465' => 'Neuville-Ferrières',
	'FR76467' => 'Néville',
	'FR76468' => 'Nointot',
	'FR76469' => 'Nolléval',
	'FR76470' => 'Normanville',
	'FR76471' => 'Norville',
	'FR76472' => 'Notre-Dame-dAliermont',
	'FR76473' => 'Notre-Dame-de-Bliquetuit',
	'FR76474' => 'Notre-Dame-de-Bondeville',
	'FR76475' => 'Franqueville-Saint-Pierre',
	'FR76476' => 'Port-Jérôme-sur-Seine',
	'FR76477' => 'Notre-Dame-du-Bec',
	'FR76478' => 'Notre-Dame-du-Parc',
	'FR76479' => 'Nullemont',
	'FR76480' => 'Ocqueville',
	'FR76481' => 'Octeville-sur-Mer',
	'FR76482' => 'Offranville',
	'FR76483' => 'Oherville',
	'FR76484' => 'Oissel',
	'FR76485' => 'Omonville',
	'FR76486' => 'Orival',
	'FR76487' => 'Osmoy-Saint-Valery',
	'FR76488' => 'Ouainville',
	'FR76489' => 'Oudalle',
	'FR76490' => 'Ourville-en-Caux',
	'FR76491' => 'Ouville-lAbbaye',
	'FR76492' => 'Ouville-la-Rivière',
	'FR76493' => 'Paluel',
	'FR76494' => 'Parc-dAnxtot',
	'FR76495' => 'Pavilly',
	'FR76497' => 'Petit-Couronne',
	'FR76498' => 'Le Petit-Quevilly',
	'FR76499' => 'Petiville',
	'FR76500' => 'Pierrecourt',
	'FR76501' => 'Pierrefiques',
	'FR76502' => 'Pierreval',
	'FR76503' => 'Pissy-Pôville',
	'FR76504' => 'Pleine-Sève',
	'FR76505' => 'Pommereux',
	'FR76506' => 'Pommeréval',
	'FR76507' => 'Ponts-et-Marais',
	'FR76508' => 'La Poterie-Cap-dAntifer',
	'FR76509' => 'Préaux',
	'FR76510' => 'Prétot-Vicquemare',
	'FR76511' => 'Preuseville',
	'FR76512' => 'Puisenval',
	'FR76513' => 'Quevillon',
	'FR76514' => 'Quévreville-la-Poterie',
	'FR76515' => 'Quiberville',
	'FR76516' => 'Quièvrecourt',
	'FR76517' => 'Quincampoix',
	'FR76518' => 'Raffetot',
	'FR76519' => 'Rainfreville',
	'FR76520' => 'Réalcamp',
	'FR76521' => 'Rebets',
	'FR76522' => 'La Remuée',
	'FR76523' => 'Rétonval',
	'FR76524' => 'Reuville',
	'FR76526' => 'Ricarville-du-Val',
	'FR76527' => 'Richemont',
	'FR76528' => 'Rieux',
	'FR76529' => 'Riville',
	'FR76530' => 'Robertot',
	'FR76531' => 'Rocquefort',
	'FR76532' => 'Rocquemont',
	'FR76533' => 'Rogerville',
	'FR76534' => 'Rolleville',
	'FR76535' => 'Roncherolles-en-Bray',
	'FR76536' => 'Roncherolles-sur-le-Vivier',
	'FR76537' => 'Ronchois',
	'FR76538' => 'Rosay',
	'FR76540' => 'Rouen',
	'FR76541' => 'Roumare',
	'FR76542' => 'Routes',
	'FR76543' => 'Rouville',
	'FR76544' => 'Rouvray-Catillon',
	'FR76545' => 'Rouxmesnil-Bouteilles',
	'FR76546' => 'Royville',
	'FR76547' => 'La Rue-Saint-Pierre',
	'FR76548' => 'Ry',
	'FR76549' => 'Saâne-Saint-Just',
	'FR76550' => 'Sahurs',
	'FR76551' => 'Sainneville',
	'FR76552' => 'Sainte-Adresse',
	'FR76553' => 'Sainte-Agathe-dAliermont',
	'FR76554' => 'Saint-Aignan-sur-Ry',
	'FR76555' => 'Saint-André-sur-Cailly',
	'FR76556' => 'Saint-Antoine-la-Forêt',
	'FR76557' => 'Saint-Arnoult',
	'FR76558' => 'Saint-Aubin-Celloville',
	'FR76559' => 'Saint-Aubin-de-Crétot',
	'FR76560' => 'Saint-Aubin-Épinay',
	'FR76561' => 'Saint-Aubin-lès-Elbeuf',
	'FR76562' => 'Saint-Aubin-le-Cauf',
	'FR76563' => 'Saint-Aubin-Routot',
	'FR76564' => 'Saint-Aubin-sur-Mer',
	'FR76565' => 'Saint-Aubin-sur-Scie',
	'FR76566' => 'Sainte-Austreberthe',
	'FR76567' => 'Sainte-Beuve-en-Rivière',
	'FR76568' => 'Saint-Clair-sur-les-Monts',
	'FR76569' => 'Sainte-Colombe',
	'FR76570' => 'Saint-Crespin',
	'FR76571' => 'Sainte-Croix-sur-Buchy',
	'FR76572' => 'Saint-Denis-dAclon',
	'FR76573' => 'Saint-Denis-le-Thiboult',
	'FR76574' => 'Saint-Denis-sur-Scie',
	'FR76575' => 'Saint-Étienne-du-Rouvray',
	'FR76576' => 'Saint-Eustache-la-Forêt',
	'FR76577' => 'Sainte-Foy',
	'FR76578' => 'Sainte-Geneviève',
	'FR76580' => 'Saint-Georges-sur-Fontaine',
	'FR76581' => 'Saint-Germain-des-Essourts',
	'FR76582' => 'Saint-Germain-dÉtables',
	'FR76583' => 'Saint-Germain-sous-Cailly',
	'FR76584' => 'Saint-Germain-sur-Eaulne',
	'FR76585' => 'Saint-Gilles-de-Crétot',
	'FR76586' => 'Saint-Gilles-de-la-Neuville',
	'FR76587' => 'Sainte-Hélène-Bondeville',
	'FR76588' => 'Saint-Hellier',
	'FR76589' => 'Saint-Honoré',
	'FR76590' => 'Saint-Jacques-dAliermont',
	'FR76591' => 'Saint-Jacques-sur-Darnétal',
	'FR76592' => 'Saint-Jean-de-Folleville',
	'FR76593' => 'Saint-Jean-de-la-Neuville',
	'FR76594' => 'Saint-Jean-du-Cardonnay',
	'FR76595' => 'Saint-Jouin-Bruneval',
	'FR76596' => 'Saint-Laurent-de-Brèvedent',
	'FR76597' => 'Saint-Laurent-en-Caux',
	'FR76598' => 'Saint-Léger-aux-Bois',
	'FR76599' => 'Saint-Léger-du-Bourg-Denis',
	'FR76600' => 'Saint-Léonard',
	'FR76601' => 'Saint-Lucien',
	'FR76602' => 'Saint-Maclou-de-Folleville',
	'FR76603' => 'Saint-Maclou-la-Brière',
	'FR76604' => 'Saint-Mards',
	'FR76605' => 'Sainte-Marguerite-sur-Mer',
	'FR76606' => 'Morienne',
	'FR76608' => 'Sainte-Marguerite-sur-Duclair',
	'FR76609' => 'Sainte-Marie-au-Bosc',
	'FR76610' => 'Sainte-Marie-des-Champs',
	'FR76611' => 'Saint-Martin-aux-Arbres',
	'FR76612' => 'Saint-Martin-au-Bosc',
	'FR76613' => 'Saint-Martin-aux-Buneaux',
	'FR76614' => 'Saint-Martin-de-Boscherville',
	'FR76615' => 'Saint-Martin-du-Bec',
	'FR76616' => 'Saint-Martin-du-Manoir',
	'FR76617' => 'Saint-Martin-du-Vivier',
	'FR76618' => 'Petit-Caux',
	'FR76619' => 'Saint-Martin-le-Gaillard',
	'FR76620' => 'Saint-Martin-lHortier',
	'FR76621' => 'Saint-Martin-Osmonville',
	'FR76622' => 'Saint-Maurice-dÉtelan',
	'FR76623' => 'Saint-Michel-dHalescourt',
	'FR76624' => 'Saint-Nicolas-dAliermont',
	'FR76626' => 'Saint-Nicolas-de-la-Haie',
	'FR76627' => 'Saint-Nicolas-de-la-Taille',
	'FR76628' => 'Saint-Ouen-du-Breuil',
	'FR76629' => 'Saint-Ouen-le-Mauger',
	'FR76630' => 'Saint-Ouen-sous-Bailly',
	'FR76631' => 'Saint-Paër',
	'FR76632' => 'Saint-Pierre-Bénouville',
	'FR76634' => 'Saint-Pierre-de-Manneville',
	'FR76635' => 'Saint-Pierre-des-Jonquières',
	'FR76636' => 'Saint-Pierre-de-Varengeville',
	'FR76637' => 'Saint-Pierre-en-Port',
	'FR76638' => 'Saint-Pierre-en-Val',
	'FR76640' => 'Saint-Pierre-lès-Elbeuf',
	'FR76641' => 'Saint-Pierre-le-Vieux',
	'FR76642' => 'Saint-Pierre-le-Viger',
	'FR76644' => 'Saint-Rémy-Boscrocourt',
	'FR76645' => 'Saint-Riquier-en-Rivière',
	'FR76646' => 'Saint-Riquier-ès-Plains',
	'FR76647' => 'Saint-Romain-de-Colbosc',
	'FR76648' => 'Saint-Saëns',
	'FR76649' => 'Saint-Saire',
	'FR76650' => 'Saint-Sauveur-dÉmalleville',
	'FR76651' => 'Saint-Sylvain',
	'FR76652' => 'Saint-Vaast-dÉquiqueville',
	'FR76653' => 'Saint-Vaast-Dieppedalle',
	'FR76654' => 'Saint-Vaast-du-Val',
	'FR76655' => 'Saint-Valery-en-Caux',
	'FR76656' => 'Saint-Victor-lAbbaye',
	'FR76657' => 'Saint-Vigor-dYmonville',
	'FR76658' => 'Saint-Vincent-Cramesnil',
	'FR76660' => 'Sandouville',
	'FR76662' => 'Sassetot-le-Malgardé',
	'FR76663' => 'Sassetot-le-Mauconduit',
	'FR76664' => 'Sasseville',
	'FR76665' => 'Sauchay',
	'FR76666' => 'Saumont-la-Poterie',
	'FR76667' => 'Sauqueville',
	'FR76668' => 'Saussay',
	'FR76669' => 'Sausseuzemare-en-Caux',
	'FR76670' => 'Senneville-sur-Fécamp',
	'FR76671' => 'Sept-Meules',
	'FR76672' => 'Serqueux',
	'FR76673' => 'Servaville-Salmonville',
	'FR76675' => 'Sierville',
	'FR76676' => 'Sigy-en-Bray',
	'FR76677' => 'Smermesnil',
	'FR76678' => 'Sommery',
	'FR76679' => 'Sommesnil',
	'FR76680' => 'Sorquainville',
	'FR76681' => 'Sotteville-lès-Rouen',
	'FR76682' => 'Sotteville-sous-le-Val',
	'FR76683' => 'Sotteville-sur-Mer',
	'FR76684' => 'Tancarville',
	'FR76685' => 'Thérouldeville',
	'FR76686' => 'Theuville-aux-Maillots',
	'FR76688' => 'Thiergeville',
	'FR76689' => 'Thiétreville',
	'FR76690' => 'Thil-Manneville',
	'FR76691' => 'Le Thil-Riberpré',
	'FR76692' => 'Thiouville',
	'FR76693' => 'Le Tilleul',
	'FR76694' => 'Tocqueville-en-Caux',
	'FR76695' => 'Tocqueville-les-Murs',
	'FR76697' => 'Torcy-le-Grand',
	'FR76698' => 'Torcy-le-Petit',
	'FR76699' => 'Le Torp-Mesnil',
	'FR76700' => 'Tôtes',
	'FR76702' => 'Touffreville-la-Corbeline',
	'FR76703' => 'Touffreville-sur-Eu',
	'FR76705' => 'Tourville-la-Rivière',
	'FR76706' => 'Tourville-les-Ifs',
	'FR76707' => 'Tourville-sur-Arques',
	'FR76708' => 'Toussaint',
	'FR76709' => 'Le Trait',
	'FR76710' => 'Trémauville',
	'FR76711' => 'Le Tréport',
	'FR76712' => 'La Trinité-du-Mont',
	'FR76714' => 'Les Trois-Pierres',
	'FR76715' => 'Trouville',
	'FR76716' => 'Turretot',
	'FR76717' => 'Val-de-la-Haye',
	'FR76718' => 'Valliquerville',
	'FR76719' => 'Valmont',
	'FR76720' => 'Varengeville-sur-Mer',
	'FR76721' => 'Varneville-Bretteville',
	'FR76723' => 'Vassonville',
	'FR76724' => 'Vatierville',
	'FR76725' => 'Vattetot-sous-Beaumont',
	'FR76726' => 'Vattetot-sur-Mer',
	'FR76727' => 'Vatteville-la-Rue',
	'FR76728' => 'La Vaupalière',
	'FR76730' => 'Veauville-lès-Quelles',
	'FR76731' => 'Vénestanville',
	'FR76732' => 'Butot-Vénesville',
	'FR76733' => 'Ventes-Saint-Rémy',
	'FR76734' => 'Vergetot',
	'FR76735' => 'Veules-les-Roses',
	'FR76736' => 'Veulettes-sur-Mer',
	'FR76737' => 'Vibeuf',
	'FR76738' => 'Vieux-Manoir',
	'FR76739' => 'Vieux-Rouen-sur-Bresle',
	'FR76740' => 'La Vieux-Rue',
	'FR76741' => 'Villainville',
	'FR76743' => 'Villers-Écalles',
	'FR76744' => 'Villers-sous-Foucarmont',
	'FR76745' => 'Villy-sur-Yères',
	'FR76746' => 'Vinnemerville',
	'FR76747' => 'Virville',
	'FR76748' => 'Vittefleur',
	'FR76749' => 'Wanchy-Capval',
	'FR76750' => 'Yainville',
	'FR76751' => 'Yébleron',
	'FR76752' => 'Yerville',
	'FR76753' => 'Ymare',
	'FR76754' => 'Yport',
	'FR76755' => 'Ypreville-Biville',
	'FR76756' => 'Yquebeuf',
	'FR76757' => 'Yvecrique',
	'FR76758' => 'Yvetot',
	'FR76759' => 'Yville-sur-Seine',
	'FR77001' => 'Achères-la-Forêt',
	'FR77002' => 'Amillis',
	'FR77003' => 'Amponville',
	'FR77004' => 'Andrezel',
	'FR77005' => 'Annet-sur-Marne',
	'FR77006' => 'Arbonne-la-Forêt',
	'FR77007' => 'Argentières',
	'FR77008' => 'Armentières-en-Brie',
	'FR77009' => 'Arville',
	'FR77010' => 'Aubepierre-Ozouer-le-Repos',
	'FR77011' => 'Aufferville',
	'FR77012' => 'Augers-en-Brie',
	'FR77013' => 'Aulnoy',
	'FR77014' => 'Avon',
	'FR77015' => 'Baby',
	'FR77016' => 'Bagneaux-sur-Loing',
	'FR77018' => 'Bailly-Romainvilliers',
	'FR77019' => 'Balloy',
	'FR77020' => 'Bannost-Villegagnon',
	'FR77021' => 'Barbey',
	'FR77022' => 'Barbizon',
	'FR77023' => 'Barcy',
	'FR77024' => 'Bassevelle',
	'FR77025' => 'Bazoches-lès-Bray',
	'FR77026' => 'Beauchery-Saint-Martin',
	'FR77027' => 'Beaumont-du-Gâtinais',
	'FR77029' => 'Beauvoir',
	'FR77030' => 'Bellot',
	'FR77031' => 'Bernay-Vilbert',
	'FR77032' => 'Beton-Bazoches',
	'FR77033' => 'Bezalles',
	'FR77034' => 'Blandy',
	'FR77035' => 'Blennes',
	'FR77036' => 'Boisdon',
	'FR77037' => 'Bois-le-Roi',
	'FR77038' => 'Boissettes',
	'FR77039' => 'Boissise-la-Bertrand',
	'FR77040' => 'Boissise-le-Roi',
	'FR77041' => 'Boissy-aux-Cailles',
	'FR77042' => 'Boissy-le-Châtel',
	'FR77043' => 'Boitron',
	'FR77044' => 'Bombon',
	'FR77045' => 'Bougligny',
	'FR77046' => 'Boulancourt',
	'FR77047' => 'Bouleurs',
	'FR77048' => 'Bourron-Marlotte',
	'FR77049' => 'Boutigny',
	'FR77050' => 'Bransles',
	'FR77051' => 'Bray-sur-Seine',
	'FR77052' => 'Bréau',
	'FR77053' => 'Brie-Comte-Robert',
	'FR77054' => 'La Brosse-Montceaux',
	'FR77055' => 'Brou-sur-Chantereine',
	'FR77056' => 'Burcy',
	'FR77057' => 'Bussières',
	'FR77058' => 'Bussy-Saint-Georges',
	'FR77059' => 'Bussy-Saint-Martin',
	'FR77060' => 'Buthiers',
	'FR77061' => 'Cannes-Écluse',
	'FR77062' => 'Carnetin',
	'FR77063' => 'La Celle-sur-Morin',
	'FR77065' => 'Cély',
	'FR77066' => 'Cerneux',
	'FR77067' => 'Cesson',
	'FR77068' => 'Cessoy-en-Montois',
	'FR77069' => 'Chailly-en-Bière',
	'FR77070' => 'Chailly-en-Brie',
	'FR77071' => 'Chaintreaux',
	'FR77072' => 'Chalautre-la-Grande',
	'FR77073' => 'Chalautre-la-Petite',
	'FR77075' => 'Chalifert',
	'FR77076' => 'Chalmaison',
	'FR77077' => 'Chambry',
	'FR77078' => 'Chamigny',
	'FR77079' => 'Champagne-sur-Seine',
	'FR77080' => 'Champcenest',
	'FR77081' => 'Champdeuil',
	'FR77082' => 'Champeaux',
	'FR77083' => 'Champs-sur-Marne',
	'FR77084' => 'Changis-sur-Marne',
	'FR77085' => 'Chanteloup-en-Brie',
	'FR77086' => 'La Chapelle-Gauthier',
	'FR77087' => 'La Chapelle-Iger',
	'FR77088' => 'La Chapelle-la-Reine',
	'FR77089' => 'La Chapelle-Rablais',
	'FR77090' => 'La Chapelle-Saint-Sulpice',
	'FR77091' => 'Les Chapelles-Bourbon',
	'FR77093' => 'La Chapelle-Moutils',
	'FR77094' => 'Charmentray',
	'FR77095' => 'Charny',
	'FR77096' => 'Chartrettes',
	'FR77097' => 'Chartronges',
	'FR77098' => 'Châteaubleau',
	'FR77099' => 'Château-Landon',
	'FR77100' => 'Le Châtelet-en-Brie',
	'FR77101' => 'Châtenay-sur-Seine',
	'FR77102' => 'Châtenoy',
	'FR77103' => 'Châtillon-la-Borde',
	'FR77104' => 'Châtres',
	'FR77106' => 'Chauffry',
	'FR77107' => 'Chaumes-en-Brie',
	'FR77108' => 'Chelles',
	'FR77109' => 'Chenoise-Cucharmoy',
	'FR77110' => 'Chenou',
	'FR77111' => 'Chessy',
	'FR77112' => 'Chevrainvilliers',
	'FR77113' => 'Chevru',
	'FR77114' => 'Chevry-Cossigny',
	'FR77115' => 'Chevry-en-Sereine',
	'FR77116' => 'Choisy-en-Brie',
	'FR77117' => 'Citry',
	'FR77118' => 'Claye-Souilly',
	'FR77119' => 'Clos-Fontaine',
	'FR77120' => 'Cocherel',
	'FR77121' => 'Collégien',
	'FR77122' => 'Combs-la-Ville',
	'FR77123' => 'Compans',
	'FR77124' => 'Conches-sur-Gondoire',
	'FR77125' => 'Condé-Sainte-Libiaire',
	'FR77126' => 'Congis-sur-Thérouanne',
	'FR77127' => 'Coubert',
	'FR77128' => 'Couilly-Pont-aux-Dames',
	'FR77129' => 'Coulombs-en-Valois',
	'FR77130' => 'Coulommes',
	'FR77131' => 'Coulommiers',
	'FR77132' => 'Coupvray',
	'FR77133' => 'Courcelles-en-Bassée',
	'FR77134' => 'Courchamp',
	'FR77135' => 'Courpalay',
	'FR77136' => 'Courquetaine',
	'FR77137' => 'Courtacon',
	'FR77138' => 'Courtomer',
	'FR77139' => 'Courtry',
	'FR77140' => 'Coutençon',
	'FR77141' => 'Coutevroult',
	'FR77142' => 'Crécy-la-Chapelle',
	'FR77143' => 'Crégy-lès-Meaux',
	'FR77144' => 'Crèvecœur-en-Brie',
	'FR77145' => 'Crisenoy',
	'FR77146' => 'Croissy-Beaubourg',
	'FR77147' => 'La Croix-en-Brie',
	'FR77148' => 'Crouy-sur-Ourcq',
	'FR77150' => 'Cuisy',
	'FR77151' => 'Dagny',
	'FR77152' => 'Dammarie-les-Lys',
	'FR77153' => 'Dammartin-en-Goële',
	'FR77154' => 'Dammartin-sur-Tigeaux',
	'FR77155' => 'Dampmart',
	'FR77156' => 'Darvault',
	'FR77157' => 'Dhuisy',
	'FR77158' => 'Diant',
	'FR77159' => 'Donnemarie-Dontilly',
	'FR77161' => 'Dormelles',
	'FR77162' => 'Doue',
	'FR77163' => 'Douy-la-Ramée',
	'FR77164' => 'Échouboulains',
	'FR77165' => 'Les Écrennes',
	'FR77167' => 'Égligny',
	'FR77168' => 'Égreville',
	'FR77169' => 'Émerainville',
	'FR77171' => 'Esbly',
	'FR77172' => 'Esmans',
	'FR77173' => 'Étrépilly',
	'FR77174' => 'Everly',
	'FR77175' => 'Évry-Grégy-sur-Yerre',
	'FR77176' => 'Faremoutiers',
	'FR77177' => 'Favières',
	'FR77178' => 'Faÿ-lès-Nemours',
	'FR77179' => 'Féricy',
	'FR77180' => 'Férolles-Attilly',
	'FR77181' => 'Ferrières-en-Brie',
	'FR77182' => 'La Ferté-Gaucher',
	'FR77183' => 'La Ferté-sous-Jouarre',
	'FR77184' => 'Flagy',
	'FR77185' => 'Fleury-en-Bière',
	'FR77186' => 'Fontainebleau',
	'FR77187' => 'Fontaine-Fourches',
	'FR77188' => 'Fontaine-le-Port',
	'FR77190' => 'Fontains',
	'FR77191' => 'Fontenailles',
	'FR77192' => 'Fontenay-Trésigny',
	'FR77193' => 'Forfry',
	'FR77194' => 'Forges',
	'FR77195' => 'Fouju',
	'FR77196' => 'Fresnes-sur-Marne',
	'FR77197' => 'Frétoy',
	'FR77198' => 'Fromont',
	'FR77199' => 'Fublaines',
	'FR77200' => 'Garentreville',
	'FR77201' => 'Gastins',
	'FR77202' => 'La Genevraye',
	'FR77203' => 'Germigny-lÉvêque',
	'FR77204' => 'Germigny-sous-Coulombs',
	'FR77205' => 'Gesvres-le-Chapitre',
	'FR77206' => 'Giremoutiers',
	'FR77207' => 'Gironville',
	'FR77208' => 'Gouaix',
	'FR77209' => 'Gouvernes',
	'FR77210' => 'La Grande-Paroisse',
	'FR77211' => 'Grandpuits-Bailly-Carrois',
	'FR77212' => 'Gravon',
	'FR77214' => 'Gressy',
	'FR77215' => 'Gretz-Armainvilliers',
	'FR77216' => 'Grez-sur-Loing',
	'FR77217' => 'Grisy-Suisnes',
	'FR77218' => 'Grisy-sur-Seine',
	'FR77219' => 'Guérard',
	'FR77220' => 'Guercheville',
	'FR77221' => 'Guermantes',
	'FR77222' => 'Guignes',
	'FR77223' => 'Gurcy-le-Châtel',
	'FR77224' => 'Hautefeuille',
	'FR77225' => 'La Haute-Maison',
	'FR77226' => 'Héricy',
	'FR77227' => 'Hermé',
	'FR77228' => 'Hondevilliers',
	'FR77229' => 'La Houssaye-en-Brie',
	'FR77230' => 'Ichy',
	'FR77231' => 'Isles-les-Meldeuses',
	'FR77232' => 'Isles-lès-Villenoy',
	'FR77233' => 'Iverny',
	'FR77234' => 'Jablines',
	'FR77235' => 'Jaignes',
	'FR77236' => 'Jaulnes',
	'FR77237' => 'Jossigny',
	'FR77238' => 'Jouarre',
	'FR77239' => 'Jouy-le-Châtel',
	'FR77240' => 'Jouy-sur-Morin',
	'FR77241' => 'Juilly',
	'FR77242' => 'Jutigny',
	'FR77243' => 'Lagny-sur-Marne',
	'FR77244' => 'Larchant',
	'FR77245' => 'Laval-en-Brie',
	'FR77246' => 'Léchelle',
	'FR77247' => 'Lescherolles',
	'FR77248' => 'Lesches',
	'FR77249' => 'Lésigny',
	'FR77250' => 'Leudon-en-Brie',
	'FR77251' => 'Lieusaint',
	'FR77252' => 'Limoges-Fourches',
	'FR77253' => 'Lissy',
	'FR77254' => 'Liverdy-en-Brie',
	'FR77255' => 'Livry-sur-Seine',
	'FR77256' => 'Lizines',
	'FR77257' => 'Lizy-sur-Ourcq',
	'FR77258' => 'Lognes',
	'FR77259' => 'Longperrier',
	'FR77260' => 'Longueville',
	'FR77261' => 'Lorrez-le-Bocage-Préaux',
	'FR77262' => 'Louan-Villegruis-Fontaine',
	'FR77263' => 'Luisetaines',
	'FR77264' => 'Lumigny-Nesles-Ormeaux',
	'FR77265' => 'Luzancy',
	'FR77266' => 'Machault',
	'FR77267' => 'La Madeleine-sur-Loing',
	'FR77268' => 'Magny-le-Hongre',
	'FR77269' => 'Maincy',
	'FR77270' => 'Maisoncelles-en-Brie',
	'FR77271' => 'Maisoncelles-en-Gâtinais',
	'FR77272' => 'Maison-Rouge',
	'FR77273' => 'Marchémoret',
	'FR77274' => 'Marcilly',
	'FR77275' => 'Les Marêts',
	'FR77276' => 'Mareuil-lès-Meaux',
	'FR77277' => 'Marles-en-Brie',
	'FR77278' => 'Marolles-en-Brie',
	'FR77279' => 'Marolles-sur-Seine',
	'FR77280' => 'Mary-sur-Marne',
	'FR77281' => 'Mauperthuis',
	'FR77282' => 'Mauregard',
	'FR77283' => 'May-en-Multien',
	'FR77284' => 'Meaux',
	'FR77285' => 'Le Mée-sur-Seine',
	'FR77286' => 'Meigneux',
	'FR77287' => 'Meilleray',
	'FR77288' => 'Melun',
	'FR77289' => 'Melz-sur-Seine',
	'FR77290' => 'Méry-sur-Marne',
	'FR77291' => 'Le Mesnil-Amelot',
	'FR77292' => 'Messy',
	'FR77293' => 'Misy-sur-Yonne',
	'FR77294' => 'Mitry-Mory',
	'FR77295' => 'Moisenay',
	'FR77296' => 'Moissy-Cramayel',
	'FR77297' => 'Mondreville',
	'FR77298' => 'Mons-en-Montois',
	'FR77300' => 'Montceaux-lès-Meaux',
	'FR77301' => 'Montceaux-lès-Provins',
	'FR77302' => 'Montcourt-Fromonville',
	'FR77303' => 'Montdauphin',
	'FR77304' => 'Montenils',
	'FR77305' => 'Montereau-Fault-Yonne',
	'FR77306' => 'Montereau-sur-le-Jard',
	'FR77307' => 'Montévrain',
	'FR77308' => 'Montgé-en-Goële',
	'FR77309' => 'Monthyon',
	'FR77310' => 'Montigny-le-Guesdier',
	'FR77311' => 'Montigny-Lencoup',
	'FR77312' => 'Montigny-sur-Loing',
	'FR77313' => 'Montmachoux',
	'FR77314' => 'Montolivet',
	'FR77315' => 'Montry',
	'FR77316' => 'Moret-Loing-et-Orvanne',
	'FR77317' => 'Mormant',
	'FR77318' => 'Mortcerf',
	'FR77319' => 'Mortery',
	'FR77320' => 'Mouroux',
	'FR77321' => 'Mousseaux-lès-Bray',
	'FR77322' => 'Moussy-le-Neuf',
	'FR77323' => 'Moussy-le-Vieux',
	'FR77325' => 'Mouy-sur-Seine',
	'FR77326' => 'Nandy',
	'FR77327' => 'Nangis',
	'FR77328' => 'Nanteau-sur-Essonne',
	'FR77329' => 'Nanteau-sur-Lunain',
	'FR77330' => 'Nanteuil-lès-Meaux',
	'FR77331' => 'Nanteuil-sur-Marne',
	'FR77332' => 'Nantouillet',
	'FR77333' => 'Nemours',
	'FR77335' => 'Chauconin-Neufmontiers',
	'FR77336' => 'Neufmoutiers-en-Brie',
	'FR77337' => 'Noisiel',
	'FR77338' => 'Noisy-Rudignon',
	'FR77339' => 'Noisy-sur-École',
	'FR77340' => 'Nonville',
	'FR77341' => 'Noyen-sur-Seine',
	'FR77342' => 'Obsonville',
	'FR77343' => 'Ocquerre',
	'FR77344' => 'Oissery',
	'FR77345' => 'Orly-sur-Morin',
	'FR77347' => 'Les Ormes-sur-Voulzie',
	'FR77348' => 'Ormesson',
	'FR77349' => 'Othis',
	'FR77350' => 'Ozoir-la-Ferrière',
	'FR77352' => 'Ozouer-le-Voulgis',
	'FR77353' => 'Paley',
	'FR77354' => 'Pamfou',
	'FR77355' => 'Paroy',
	'FR77356' => 'Passy-sur-Seine',
	'FR77357' => 'Pécy',
	'FR77358' => 'Penchard',
	'FR77359' => 'Perthes',
	'FR77360' => 'Pézarches',
	'FR77361' => 'Pierre-Levée',
	'FR77363' => 'Le Pin',
	'FR77364' => 'Le Plessis-aux-Bois',
	'FR77365' => 'Le Plessis-Feu-Aussoux',
	'FR77366' => 'Le Plessis-lÉvêque',
	'FR77367' => 'Le Plessis-Placy',
	'FR77368' => 'Poigny',
	'FR77369' => 'Poincy',
	'FR77370' => 'Poligny',
	'FR77371' => 'Pommeuse',
	'FR77372' => 'Pomponne',
	'FR77373' => 'Pontault-Combault',
	'FR77374' => 'Pontcarré',
	'FR77376' => 'Précy-sur-Marne',
	'FR77377' => 'Presles-en-Brie',
	'FR77378' => 'Pringy',
	'FR77379' => 'Provins',
	'FR77380' => 'Puisieux',
	'FR77381' => 'Quiers',
	'FR77382' => 'Quincy-Voisins',
	'FR77383' => 'Rampillon',
	'FR77384' => 'Réau',
	'FR77385' => 'Rebais',
	'FR77386' => 'Recloses',
	'FR77387' => 'Remauville',
	'FR77388' => 'Reuil-en-Brie',
	'FR77389' => 'La Rochette',
	'FR77390' => 'Roissy-en-Brie',
	'FR77391' => 'Rouilly',
	'FR77392' => 'Rouvres',
	'FR77393' => 'Rozay-en-Brie',
	'FR77394' => 'Rubelles',
	'FR77395' => 'Rumont',
	'FR77396' => 'Rupéreux',
	'FR77397' => 'Saâcy-sur-Marne',
	'FR77398' => 'Sablonnières',
	'FR77400' => 'Saint-Augustin',
	'FR77401' => 'Sainte-Aulde',
	'FR77402' => 'Saint-Barthélemy',
	'FR77403' => 'Saint-Brice',
	'FR77404' => 'Sainte-Colombe',
	'FR77405' => 'Saint-Cyr-sur-Morin',
	'FR77406' => 'Saint-Denis-lès-Rebais',
	'FR77407' => 'Saint-Fargeau-Ponthierry',
	'FR77408' => 'Saint-Fiacre',
	'FR77409' => 'Saint-Germain-Laval',
	'FR77410' => 'Saint-Germain-Laxis',
	'FR77411' => 'Saint-Germain-sous-Doue',
	'FR77412' => 'Saint-Germain-sur-École',
	'FR77413' => 'Saint-Germain-sur-Morin',
	'FR77414' => 'Saint-Hilliers',
	'FR77415' => 'Saint-Jean-les-Deux-Jumeaux',
	'FR77416' => 'Saint-Just-en-Brie',
	'FR77417' => 'Saint-Léger',
	'FR77418' => 'Saint-Loup-de-Naud',
	'FR77419' => 'Saint-Mammès',
	'FR77420' => 'Saint-Mard',
	'FR77421' => 'Saint-Mars-Vieux-Maisons',
	'FR77423' => 'Saint-Martin-des-Champs',
	'FR77424' => 'Saint-Martin-du-Boschet',
	'FR77425' => 'Saint-Martin-en-Bière',
	'FR77426' => 'Saint-Méry',
	'FR77427' => 'Saint-Mesmes',
	'FR77428' => 'Saint-Ouen-en-Brie',
	'FR77429' => 'Saint-Ouen-sur-Morin',
	'FR77430' => 'Saint-Pathus',
	'FR77431' => 'Saint-Pierre-lès-Nemours',
	'FR77432' => 'Saint-Rémy-la-Vanne',
	'FR77433' => 'Beautheil-Saints',
	'FR77434' => 'Saint-Sauveur-lès-Bray',
	'FR77435' => 'Saint-Sauveur-sur-École',
	'FR77436' => 'Saint-Siméon',
	'FR77437' => 'Saint-Soupplets',
	'FR77438' => 'Saint-Thibault-des-Vignes',
	'FR77439' => 'Salins',
	'FR77440' => 'Sammeron',
	'FR77441' => 'Samois-sur-Seine',
	'FR77442' => 'Samoreau',
	'FR77443' => 'Sancy',
	'FR77444' => 'Sancy-lès-Provins',
	'FR77445' => 'Savigny-le-Temple',
	'FR77446' => 'Savins',
	'FR77447' => 'Seine-Port',
	'FR77448' => 'Sept-Sorts',
	'FR77449' => 'Serris',
	'FR77450' => 'Servon',
	'FR77451' => 'Signy-Signets',
	'FR77452' => 'Sigy',
	'FR77453' => 'Sivry-Courtry',
	'FR77454' => 'Sognolles-en-Montois',
	'FR77455' => 'Soignolles-en-Brie',
	'FR77456' => 'Soisy-Bouy',
	'FR77457' => 'Solers',
	'FR77458' => 'Souppes-sur-Loing',
	'FR77459' => 'Sourdun',
	'FR77460' => 'Tancrou',
	'FR77461' => 'Thénisy',
	'FR77462' => 'Thieux',
	'FR77463' => 'Thomery',
	'FR77464' => 'Thorigny-sur-Marne',
	'FR77465' => 'Thoury-Férottes',
	'FR77466' => 'Tigeaux',
	'FR77467' => 'La Tombe',
	'FR77468' => 'Torcy',
	'FR77469' => 'Touquin',
	'FR77470' => 'Tournan-en-Brie',
	'FR77471' => 'Tousson',
	'FR77472' => 'La Trétoire',
	'FR77473' => 'Treuzy-Levelay',
	'FR77474' => 'Trilbardou',
	'FR77475' => 'Trilport',
	'FR77476' => 'Trocy-en-Multien',
	'FR77477' => 'Ury',
	'FR77478' => 'Ussy-sur-Marne',
	'FR77479' => 'Vaires-sur-Marne',
	'FR77480' => 'Valence-en-Brie',
	'FR77481' => 'Vanvillé',
	'FR77482' => 'Varennes-sur-Seine',
	'FR77483' => 'Varreddes',
	'FR77484' => 'Vaucourtois',
	'FR77485' => 'Le Vaudoué',
	'FR77486' => 'Vaudoy-en-Brie',
	'FR77487' => 'Vaux-le-Pénil',
	'FR77489' => 'Vaux-sur-Lunain',
	'FR77490' => 'Vendrest',
	'FR77492' => 'Verdelot',
	'FR77493' => 'Verneuil-lÉtang',
	'FR77494' => 'Vernou-la-Celle-sur-Seine',
	'FR77495' => 'Vert-Saint-Denis',
	'FR77496' => 'Vieux-Champagne',
	'FR77498' => 'Vignely',
	'FR77500' => 'Villebéon',
	'FR77501' => 'Villecerf',
	'FR77504' => 'Villemaréchal',
	'FR77505' => 'Villemareuil',
	'FR77506' => 'Villemer',
	'FR77507' => 'Villenauxe-la-Petite',
	'FR77508' => 'Villeneuve-le-Comte',
	'FR77509' => 'Villeneuve-les-Bordes',
	'FR77510' => 'Villeneuve-Saint-Denis',
	'FR77511' => 'Villeneuve-sous-Dammartin',
	'FR77512' => 'Villeneuve-sur-Bellot',
	'FR77513' => 'Villenoy',
	'FR77514' => 'Villeparisis',
	'FR77515' => 'Villeroy',
	'FR77516' => 'Ville-Saint-Jacques',
	'FR77517' => 'Villevaudé',
	'FR77518' => 'Villiers-en-Bière',
	'FR77519' => 'Villiers-Saint-Georges',
	'FR77520' => 'Villiers-sous-Grez',
	'FR77521' => 'Villiers-sur-Morin',
	'FR77522' => 'Villiers-sur-Seine',
	'FR77523' => 'Villuis',
	'FR77524' => 'Vimpelles',
	'FR77525' => 'Vinantes',
	'FR77526' => 'Vincy-Manœuvre',
	'FR77527' => 'Voinsles',
	'FR77528' => 'Voisenon',
	'FR77529' => 'Voulangis',
	'FR77530' => 'Voulton',
	'FR77531' => 'Voulx',
	'FR77532' => 'Vulaines-lès-Provins',
	'FR77533' => 'Vulaines-sur-Seine',
	'FR77534' => 'Yèbles',
	'FR78003' => 'Ablis',
	'FR78005' => 'Achères',
	'FR78006' => 'Adainville',
	'FR78007' => 'Aigremont',
	'FR78009' => 'Allainville',
	'FR78010' => 'Les Alluets-le-Roi',
	'FR78013' => 'Andelu',
	'FR78015' => 'Andrésy',
	'FR78020' => 'Arnouville-lès-Mantes',
	'FR78029' => 'Aubergenville',
	'FR78030' => 'Auffargis',
	'FR78031' => 'Auffreville-Brasseuil',
	'FR78033' => 'Aulnay-sur-Mauldre',
	'FR78034' => 'Auteuil',
	'FR78036' => 'Autouillet',
	'FR78043' => 'Bailly',
	'FR78048' => 'Bazainville',
	'FR78049' => 'Bazemont',
	'FR78050' => 'Bazoches-sur-Guyonne',
	'FR78053' => 'Béhoust',
	'FR78057' => 'Bennecourt',
	'FR78062' => 'Beynes',
	'FR78068' => 'Blaru',
	'FR78070' => 'Boinville-en-Mantois',
	'FR78071' => 'Boinville-le-Gaillard',
	'FR78072' => 'Boinvilliers',
	'FR78073' => 'Bois-dArcy',
	'FR78076' => 'Boissets',
	'FR78077' => 'La Boissière-École',
	'FR78082' => 'Boissy-Mauvoisin',
	'FR78084' => 'Boissy-sans-Avoir',
	'FR78087' => 'Bonnelles',
	'FR78089' => 'Bonnières-sur-Seine',
	'FR78090' => 'Bouafle',
	'FR78092' => 'Bougival',
	'FR78096' => 'Bourdonné',
	'FR78104' => 'Breuil-Bois-Robert',
	'FR78107' => 'Bréval',
	'FR78108' => 'Les Bréviaires',
	'FR78113' => 'Brueil-en-Vexin',
	'FR78117' => 'Buc',
	'FR78118' => 'Buchelay',
	'FR78120' => 'Bullion',
	'FR78123' => 'Carrières-sous-Poissy',
	'FR78124' => 'Carrières-sur-Seine',
	'FR78125' => 'La Celle-les-Bordes',
	'FR78126' => 'La Celle-Saint-Cloud',
	'FR78128' => 'Cernay-la-Ville',
	'FR78133' => 'Chambourcy',
	'FR78138' => 'Chanteloup-les-Vignes',
	'FR78140' => 'Chapet',
	'FR78143' => 'Châteaufort',
	'FR78146' => 'Chatou',
	'FR78147' => 'Chaufour-lès-Bonnières',
	'FR78152' => 'Chavenay',
	'FR78158' => 'Le Chesnay-Rocquencourt',
	'FR78160' => 'Chevreuse',
	'FR78162' => 'Choisel',
	'FR78163' => 'Civry-la-Forêt',
	'FR78164' => 'Clairefontaine-en-Yvelines',
	'FR78165' => 'Les Clayes-sous-Bois',
	'FR78168' => 'Coignières',
	'FR78171' => 'Condé-sur-Vesgre',
	'FR78172' => 'Conflans-Sainte-Honorine',
	'FR78185' => 'Courgent',
	'FR78188' => 'Cravent',
	'FR78189' => 'Crespières',
	'FR78190' => 'Croissy-sur-Seine',
	'FR78192' => 'Dammartin-en-Serve',
	'FR78193' => 'Dampierre-en-Yvelines',
	'FR78194' => 'Dannemarie',
	'FR78196' => 'Davron',
	'FR78202' => 'Drocourt',
	'FR78206' => 'Ecquevilly',
	'FR78208' => 'Élancourt',
	'FR78209' => 'Émancé',
	'FR78217' => 'Épône',
	'FR78220' => 'Les Essarts-le-Roi',
	'FR78224' => 'LÉtang-la-Ville',
	'FR78227' => 'Évecquemont',
	'FR78230' => 'La Falaise',
	'FR78231' => 'Favrieux',
	'FR78233' => 'Feucherolles',
	'FR78234' => 'Flacourt',
	'FR78236' => 'Flexanville',
	'FR78237' => 'Flins-Neuve-Église',
	'FR78238' => 'Flins-sur-Seine',
	'FR78239' => 'Follainville-Dennemont',
	'FR78242' => 'Fontenay-le-Fleury',
	'FR78245' => 'Fontenay-Mauvoisin',
	'FR78246' => 'Fontenay-Saint-Père',
	'FR78255' => 'Freneuse',
	'FR78261' => 'Gaillon-sur-Montcient',
	'FR78262' => 'Galluis',
	'FR78263' => 'Gambais',
	'FR78264' => 'Gambaiseuil',
	'FR78265' => 'Garancières',
	'FR78267' => 'Gargenville',
	'FR78269' => 'Gazeran',
	'FR78276' => 'Gommecourt',
	'FR78278' => 'Goupillières',
	'FR78281' => 'Goussonville',
	'FR78283' => 'Grandchamp',
	'FR78285' => 'Gressey',
	'FR78289' => 'Grosrouvre',
	'FR78290' => 'Guernes',
	'FR78291' => 'Guerville',
	'FR78296' => 'Guitrancourt',
	'FR78297' => 'Guyancourt',
	'FR78299' => 'Hardricourt',
	'FR78300' => 'Hargeville',
	'FR78302' => 'La Hauteville',
	'FR78305' => 'Herbeville',
	'FR78307' => 'Hermeray',
	'FR78310' => 'Houdan',
	'FR78311' => 'Houilles',
	'FR78314' => 'Issou',
	'FR78317' => 'Jambville',
	'FR78320' => 'Notre-Dame-de-la-Mer',
	'FR78321' => 'Jouars-Pontchartrain',
	'FR78322' => 'Jouy-en-Josas',
	'FR78324' => 'Jouy-Mauvoisin',
	'FR78325' => 'Jumeauville',
	'FR78327' => 'Juziers',
	'FR78329' => 'Lainville-en-Vexin',
	'FR78334' => 'Lévis-Saint-Nom',
	'FR78335' => 'Limay',
	'FR78337' => 'Limetz-Villez',
	'FR78343' => 'Les Loges-en-Josas',
	'FR78344' => 'Lommoye',
	'FR78346' => 'Longnes',
	'FR78349' => 'Longvilliers',
	'FR78350' => 'Louveciennes',
	'FR78354' => 'Magnanville',
	'FR78356' => 'Magny-les-Hameaux',
	'FR78358' => 'Maisons-Laffitte',
	'FR78361' => 'Mantes-la-Jolie',
	'FR78362' => 'Mantes-la-Ville',
	'FR78364' => 'Marcq',
	'FR78366' => 'Mareil-le-Guyon',
	'FR78367' => 'Mareil-Marly',
	'FR78368' => 'Mareil-sur-Mauldre',
	'FR78372' => 'Marly-le-Roi',
	'FR78380' => 'Maule',
	'FR78381' => 'Maulette',
	'FR78382' => 'Maurecourt',
	'FR78383' => 'Maurepas',
	'FR78384' => 'Médan',
	'FR78385' => 'Ménerville',
	'FR78389' => 'Méré',
	'FR78391' => 'Méricourt',
	'FR78396' => 'Le Mesnil-le-Roi',
	'FR78397' => 'Le Mesnil-Saint-Denis',
	'FR78398' => 'Les Mesnuls',
	'FR78401' => 'Meulan-en-Yvelines',
	'FR78402' => 'Mézières-sur-Seine',
	'FR78403' => 'Mézy-sur-Seine',
	'FR78404' => 'Millemont',
	'FR78406' => 'Milon-la-Chapelle',
	'FR78407' => 'Mittainville',
	'FR78410' => 'Moisson',
	'FR78413' => 'Mondreville',
	'FR78415' => 'Montainville',
	'FR78416' => 'Montalet-le-Bois',
	'FR78417' => 'Montchauvet',
	'FR78418' => 'Montesson',
	'FR78420' => 'Montfort-lAmaury',
	'FR78423' => 'Montigny-le-Bretonneux',
	'FR78431' => 'Morainvilliers',
	'FR78437' => 'Mousseaux-sur-Seine',
	'FR78439' => 'Mulcent',
	'FR78440' => 'Les Mureaux',
	'FR78442' => 'Neauphle-le-Château',
	'FR78443' => 'Neauphle-le-Vieux',
	'FR78444' => 'Neauphlette',
	'FR78451' => 'Nézel',
	'FR78455' => 'Noisy-le-Roi',
	'FR78460' => 'Oinville-sur-Montcient',
	'FR78464' => 'Orcemont',
	'FR78465' => 'Orgerus',
	'FR78466' => 'Orgeval',
	'FR78470' => 'Orphin',
	'FR78472' => 'Orsonville',
	'FR78474' => 'Orvilliers',
	'FR78475' => 'Osmoy',
	'FR78478' => 'Paray-Douaville',
	'FR78481' => 'Le Pecq',
	'FR78484' => 'Perdreauville',
	'FR78486' => 'Le Perray-en-Yvelines',
	'FR78490' => 'Plaisir',
	'FR78497' => 'Poigny-la-Forêt',
	'FR78498' => 'Poissy',
	'FR78499' => 'Ponthévrard',
	'FR78501' => 'Porcheville',
	'FR78502' => 'Le Port-Marly',
	'FR78505' => 'Prunay-le-Temple',
	'FR78506' => 'Prunay-en-Yvelines',
	'FR78513' => 'La Queue-les-Yvelines',
	'FR78516' => 'Raizeux',
	'FR78517' => 'Rambouillet',
	'FR78518' => 'Rennemoulin',
	'FR78520' => 'Richebourg',
	'FR78522' => 'Rochefort-en-Yvelines',
	'FR78528' => 'Rolleboise',
	'FR78530' => 'Rosay',
	'FR78531' => 'Rosny-sur-Seine',
	'FR78536' => 'Sailly',
	'FR78537' => 'Saint-Arnoult-en-Yvelines',
	'FR78545' => 'Saint-Cyr-lÉcole',
	'FR78548' => 'Saint-Forget',
	'FR78550' => 'Saint-Germain-de-la-Grange',
	'FR78551' => 'Saint-Germain-en-Laye',
	'FR78557' => 'Saint-Hilarion',
	'FR78558' => 'Saint-Illiers-la-Ville',
	'FR78559' => 'Saint-Illiers-le-Bois',
	'FR78561' => 'Saint-Lambert',
	'FR78562' => 'Saint-Léger-en-Yvelines',
	'FR78564' => 'Saint-Martin-de-Bréthencourt',
	'FR78565' => 'Saint-Martin-des-Champs',
	'FR78567' => 'Saint-Martin-la-Garenne',
	'FR78569' => 'Sainte-Mesme',
	'FR78571' => 'Saint-Nom-la-Bretèche',
	'FR78575' => 'Saint-Rémy-lès-Chevreuse',
	'FR78576' => 'Saint-Rémy-lHonoré',
	'FR78586' => 'Sartrouville',
	'FR78588' => 'Saulx-Marchais',
	'FR78590' => 'Senlisse',
	'FR78591' => 'Septeuil',
	'FR78597' => 'Soindres',
	'FR78601' => 'Sonchamp',
	'FR78605' => 'Tacoignières',
	'FR78606' => 'Le Tartre-Gaudran',
	'FR78608' => 'Le Tertre-Saint-Denis',
	'FR78609' => 'Tessancourt-sur-Aubette',
	'FR78615' => 'Thiverval-Grignon',
	'FR78616' => 'Thoiry',
	'FR78618' => 'Tilly',
	'FR78620' => 'Toussus-le-Noble',
	'FR78621' => 'Trappes',
	'FR78623' => 'Le Tremblay-sur-Mauldre',
	'FR78624' => 'Triel-sur-Seine',
	'FR78638' => 'Vaux-sur-Seine',
	'FR78640' => 'Vélizy-Villacoublay',
	'FR78642' => 'Verneuil-sur-Seine',
	'FR78643' => 'Vernouillet',
	'FR78644' => 'La Verrière',
	'FR78646' => 'Versailles',
	'FR78647' => 'Vert',
	'FR78650' => 'Le Vésinet',
	'FR78653' => 'Vicq',
	'FR78655' => 'Vieille-Église-en-Yvelines',
	'FR78668' => 'La Villeneuve-en-Chevrie',
	'FR78672' => 'Villennes-sur-Seine',
	'FR78674' => 'Villepreux',
	'FR78677' => 'Villette',
	'FR78681' => 'Villiers-le-Mahieu',
	'FR78683' => 'Villiers-Saint-Frédéric',
	'FR78686' => 'Viroflay',
	'FR78688' => 'Voisins-le-Bretonneux',
	'FR79001' => 'LAbsie',
	'FR79002' => 'Adilly',
	'FR79003' => 'Aiffres',
	'FR79005' => 'Airvault',
	'FR79007' => 'Allonne',
	'FR79008' => 'Amailloux',
	'FR79009' => 'Amuré',
	'FR79010' => 'Arçais',
	'FR79012' => 'Ardin',
	'FR79013' => 'Argentonnay',
	'FR79014' => 'Loretz-dArgenton',
	'FR79015' => 'Asnières-en-Poitou',
	'FR79016' => 'Assais-les-Jumeaux',
	'FR79018' => 'Aubigné',
	'FR79019' => 'Aubigny',
	'FR79020' => 'Augé',
	'FR79022' => 'Availles-Thouarsais',
	'FR79023' => 'Avon',
	'FR79024' => 'Azay-le-Brûlé',
	'FR79025' => 'Azay-sur-Thouet',
	'FR79029' => 'Beaulieu-sous-Parthenay',
	'FR79030' => 'Beaussais-Vitré',
	'FR79031' => 'Beauvoir-sur-Niort',
	'FR79032' => 'Béceleuf',
	'FR79034' => 'Bessines',
	'FR79038' => 'Boismé',
	'FR79040' => 'La Boissière-en-Gâtine',
	'FR79042' => 'Bougon',
	'FR79046' => 'Le Bourdet',
	'FR79047' => 'Boussais',
	'FR79048' => 'La Crèche',
	'FR79049' => 'Bressuire',
	'FR79050' => 'Bretignolles',
	'FR79055' => 'Brieuil-sur-Chizé',
	'FR79056' => 'Brion-près-Thouet',
	'FR79057' => 'Brioux-sur-Boutonne',
	'FR79058' => 'Brûlain',
	'FR79059' => 'Le Busseau',
	'FR79060' => 'Caunay',
	'FR79061' => 'Celles-sur-Belle',
	'FR79062' => 'Cerizay',
	'FR79063' => 'Val en Vignes',
	'FR79064' => 'Fontivillié',
	'FR79066' => 'Champdeniers',
	'FR79069' => 'Chanteloup',
	'FR79070' => 'La Chapelle-Bâton',
	'FR79071' => 'La Chapelle-Bertrand',
	'FR79074' => 'La Chapelle-Pouilloux',
	'FR79076' => 'La Chapelle-Saint-Laurent',
	'FR79077' => 'Beugnon-Thireuil',
	'FR79078' => 'Plaine-dArgenson',
	'FR79079' => 'Mauléon',
	'FR79080' => 'Châtillon-sur-Thouet',
	'FR79081' => 'Chauray',
	'FR79083' => 'Chef-Boutonne',
	'FR79084' => 'Chenay',
	'FR79085' => 'Chérigné',
	'FR79086' => 'Cherveux',
	'FR79087' => 'Chey',
	'FR79088' => 'Chiché',
	'FR79089' => 'Le Chillou',
	'FR79090' => 'Chizé',
	'FR79091' => 'Cirières',
	'FR79092' => 'Clavé',
	'FR79094' => 'Clessé',
	'FR79095' => 'Clussais-la-Pommeraie',
	'FR79096' => 'Combrand',
	'FR79100' => 'Coulon',
	'FR79101' => 'Coulonges-sur-lAutize',
	'FR79102' => 'Coulonges-Thouarsais',
	'FR79103' => 'Courlay',
	'FR79104' => 'Cours',
	'FR79105' => 'Les Châteliers',
	'FR79106' => 'Couture-dArgenson',
	'FR79108' => 'Doux',
	'FR79109' => 'Échiré',
	'FR79111' => 'Ensigné',
	'FR79112' => 'Épannes',
	'FR79114' => 'Exireuil',
	'FR79115' => 'Exoudun',
	'FR79116' => 'Faye-lAbbesse',
	'FR79117' => 'Faye-sur-Ardin',
	'FR79118' => 'Fénery',
	'FR79119' => 'Fenioux',
	'FR79120' => 'La Ferrière-en-Parthenay',
	'FR79121' => 'Fomperron',
	'FR79122' => 'Fontenille-Saint-Martin-dEntraigues',
	'FR79123' => 'La Forêt-sur-Sèvre',
	'FR79124' => 'Les Forges',
	'FR79125' => 'Fors',
	'FR79126' => 'Les Fosses',
	'FR79127' => 'La Foye-Monjault',
	'FR79128' => 'François',
	'FR79129' => 'Fressines',
	'FR79130' => 'Frontenay-Rohan-Rohan',
	'FR79131' => 'Geay',
	'FR79132' => 'Genneton',
	'FR79133' => 'Germond-Rouvre',
	'FR79134' => 'Glénay',
	'FR79135' => 'Gourgé',
	'FR79136' => 'Alloinay',
	'FR79137' => 'Granzay-Gript',
	'FR79139' => 'Les Groseillers',
	'FR79140' => 'Valdelaume',
	'FR79141' => 'Irais',
	'FR79142' => 'Juillé',
	'FR79144' => 'Juscorps',
	'FR79145' => 'Lageon',
	'FR79147' => 'Largeasse',
	'FR79148' => 'Lezay',
	'FR79149' => 'Lhoumois',
	'FR79150' => 'Limalonges',
	'FR79152' => 'Lorigné',
	'FR79153' => 'Loubigné',
	'FR79154' => 'Loubillé',
	'FR79156' => 'Louin',
	'FR79157' => 'Louzy',
	'FR79158' => 'Luché-sur-Brioux',
	'FR79159' => 'Luché-Thouarsais',
	'FR79160' => 'Lusseray',
	'FR79161' => 'Luzay',
	'FR79162' => 'Magné',
	'FR79163' => 'Mairé-Levescault',
	'FR79164' => 'Maisonnay',
	'FR79165' => 'Maisontiers',
	'FR79166' => 'Marigny',
	'FR79167' => 'Marnes',
	'FR79170' => 'Mauzé-sur-le-Mignon',
	'FR79172' => 'Mazières-en-Gâtine',
	'FR79174' => 'Melle',
	'FR79175' => 'Melleran',
	'FR79176' => 'Ménigoute',
	'FR79177' => 'Messé',
	'FR79179' => 'Moncoutant-sur-Sèvre',
	'FR79180' => 'Montalembert',
	'FR79183' => 'Montravers',
	'FR79184' => 'La Mothe-Saint-Héray',
	'FR79185' => 'Aigondigné',
	'FR79189' => 'Nanteuil',
	'FR79190' => 'Neuvy-Bouin',
	'FR79191' => 'Niort',
	'FR79195' => 'Nueil-les-Aubiers',
	'FR79196' => 'Plaine-et-Vallées',
	'FR79197' => 'Oroux',
	'FR79198' => 'Paizay-le-Chapt',
	'FR79200' => 'Pamplie',
	'FR79201' => 'Pamproux',
	'FR79202' => 'Parthenay',
	'FR79203' => 'Pas-de-Jeu',
	'FR79204' => 'Périgné',
	'FR79205' => 'Pers',
	'FR79207' => 'La Petite-Boissière',
	'FR79208' => 'La Peyratte',
	'FR79209' => 'Pierrefitte',
	'FR79210' => 'Le Pin',
	'FR79212' => 'Pliboux',
	'FR79213' => 'Pompaire',
	'FR79215' => 'Pougne-Hérisson',
	'FR79216' => 'Prahecq',
	'FR79217' => 'Prailles-La Couarde',
	'FR79218' => 'Pressigny',
	'FR79220' => 'Prin-Deyrançon',
	'FR79223' => 'Puihardy',
	'FR79225' => 'Reffannes',
	'FR79226' => 'Le Retail',
	'FR79229' => 'La Rochénard',
	'FR79230' => 'Rom',
	'FR79231' => 'Romans',
	'FR79235' => 'Saint-Amand-sur-Sèvre',
	'FR79236' => 'Saint-André-sur-Sèvre',
	'FR79238' => 'Saint-Aubin-du-Plain',
	'FR79239' => 'Saint-Aubin-le-Cloud',
	'FR79241' => 'Saint-Christophe-sur-Roc',
	'FR79242' => 'Voulmentin',
	'FR79243' => 'Saint-Coutant',
	'FR79244' => 'Saint-Cyr-la-Lande',
	'FR79246' => 'Sainte-Eanne',
	'FR79249' => 'Saint-Gelais',
	'FR79250' => 'Sainte-Gemme',
	'FR79251' => 'Marcillé',
	'FR79252' => 'Saint-Généroux',
	'FR79253' => 'Saint-Georges-de-Noisné',
	'FR79254' => 'Saint-Georges-de-Rex',
	'FR79255' => 'Saint-Germain-de-Longue-Chaume',
	'FR79256' => 'Saint-Germier',
	'FR79257' => 'Saint-Hilaire-la-Palud',
	'FR79258' => 'Saint-Jacques-de-Thouars',
	'FR79259' => 'Saint-Jean-de-Thouars',
	'FR79263' => 'Saint-Laurs',
	'FR79265' => 'Saint-Léger-de-Montbrun',
	'FR79267' => 'Saint-Lin',
	'FR79268' => 'Saint-Loup-Lamairé',
	'FR79269' => 'Saint-Maixent-de-Beugné',
	'FR79270' => 'Saint-Maixent-lÉcole',
	'FR79271' => 'Saint-Marc-la-Lande',
	'FR79273' => 'Saint-Martin-de-Bernegoue',
	'FR79274' => 'Saint-Martin-de-Mâcon',
	'FR79276' => 'Saint-Martin-de-Saint-Maixent',
	'FR79277' => 'Saint-Martin-de-Sanzay',
	'FR79278' => 'Saint-Martin-du-Fouilloux',
	'FR79280' => 'Saint Maurice Étusson',
	'FR79281' => 'Saint-Maxire',
	'FR79283' => 'Sainte-Néomaye',
	'FR79284' => 'Sainte-Ouenne',
	'FR79285' => 'Saint-Pardoux-Soutiers',
	'FR79286' => 'Saint-Paul-en-Gâtine',
	'FR79289' => 'Saint-Pierre-des-Échaubrognes',
	'FR79290' => 'Saint-Pompain',
	'FR79293' => 'Saint-Rémy',
	'FR79294' => 'Saint-Romans-des-Champs',
	'FR79295' => 'Saint-Romans-lès-Melle',
	'FR79297' => 'Sainte-Soline',
	'FR79298' => 'Saint-Symphorien',
	'FR79299' => 'Saint-Varent',
	'FR79300' => 'Sainte-Verge',
	'FR79301' => 'Saint-Vincent-la-Châtre',
	'FR79302' => 'Saivres',
	'FR79303' => 'Salles',
	'FR79304' => 'Sansais',
	'FR79306' => 'Saurais',
	'FR79307' => 'Sauzé-Vaussais',
	'FR79308' => 'Sciecq',
	'FR79309' => 'Scillé',
	'FR79310' => 'Secondigné-sur-Belle',
	'FR79311' => 'Secondigny',
	'FR79312' => 'Séligné',
	'FR79313' => 'Sepvret',
	'FR79316' => 'Soudan',
	'FR79319' => 'Souvigné',
	'FR79320' => 'Surin',
	'FR79322' => 'Le Tallud',
	'FR79326' => 'Thénezay',
	'FR79329' => 'Thouars',
	'FR79331' => 'Tourtenay',
	'FR79332' => 'Trayes',
	'FR79334' => 'Val-du-Mignon',
	'FR79335' => 'Vallans',
	'FR79336' => 'Vançais',
	'FR79337' => 'Le Vanneau-Irleau',
	'FR79338' => 'Vanzay',
	'FR79339' => 'Vasles',
	'FR79340' => 'Vausseroux',
	'FR79341' => 'Vautebis',
	'FR79342' => 'Vernoux-en-Gâtine',
	'FR79343' => 'Vernoux-sur-Boutonne',
	'FR79345' => 'Verruyes',
	'FR79346' => 'Le Vert',
	'FR79347' => 'Viennay',
	'FR79348' => 'Villefollet',
	'FR79349' => 'Villemain',
	'FR79350' => 'Villiers-en-Bois',
	'FR79351' => 'Villiers-en-Plaine',
	'FR79352' => 'Villiers-sur-Chizé',
	'FR79354' => 'Vouhé',
	'FR79355' => 'Vouillé',
	'FR79357' => 'Xaintray',
	'FR80001' => 'Abbeville',
	'FR80002' => 'Ablaincourt-Pressoir',
	'FR80003' => 'Acheux-en-Amiénois',
	'FR80004' => 'Acheux-en-Vimeu',
	'FR80005' => 'Agenville',
	'FR80006' => 'Agenvillers',
	'FR80008' => 'Aigneville',
	'FR80009' => 'Ailly-le-Haut-Clocher',
	'FR80010' => 'Ailly-sur-Noye',
	'FR80011' => 'Ailly-sur-Somme',
	'FR80013' => 'Airaines',
	'FR80014' => 'Aizecourt-le-Bas',
	'FR80015' => 'Aizecourt-le-Haut',
	'FR80016' => 'Albert',
	'FR80017' => 'Allaines',
	'FR80018' => 'Allenay',
	'FR80019' => 'Allery',
	'FR80020' => 'Allonville',
	'FR80021' => 'Amiens',
	'FR80022' => 'Andainville',
	'FR80023' => 'Andechy',
	'FR80024' => 'Argœuves',
	'FR80025' => 'Argoules',
	'FR80026' => 'Arguel',
	'FR80027' => 'Armancourt',
	'FR80028' => 'Arquèves',
	'FR80029' => 'Arrest',
	'FR80030' => 'Arry',
	'FR80031' => 'Arvillers',
	'FR80032' => 'Assainvillers',
	'FR80033' => 'Assevillers',
	'FR80034' => 'Athies',
	'FR80035' => 'Aubercourt',
	'FR80036' => 'Aubigny',
	'FR80037' => 'Aubvillers',
	'FR80038' => 'Auchonvillers',
	'FR80039' => 'Ault',
	'FR80040' => 'Aumâtre',
	'FR80041' => 'Aumont',
	'FR80042' => 'Autheux',
	'FR80043' => 'Authie',
	'FR80044' => 'Authieule',
	'FR80045' => 'Authuille',
	'FR80046' => 'Avelesges',
	'FR80047' => 'Aveluy',
	'FR80048' => 'Avesnes-Chaussoy',
	'FR80049' => 'Ayencourt',
	'FR80050' => 'Bacouel-sur-Selle',
	'FR80051' => 'Bailleul',
	'FR80052' => 'Baizieux',
	'FR80053' => 'Balâtre',
	'FR80054' => 'Barleux',
	'FR80055' => 'Barly',
	'FR80056' => 'Bavelincourt',
	'FR80057' => 'Bayencourt',
	'FR80058' => 'Bayonvillers',
	'FR80059' => 'Bazentin',
	'FR80060' => 'Béalcourt',
	'FR80061' => 'Beaucamps-le-Jeune',
	'FR80062' => 'Beaucamps-le-Vieux',
	'FR80063' => 'Beauchamps',
	'FR80064' => 'Beaucourt-en-Santerre',
	'FR80065' => 'Beaucourt-sur-lAncre',
	'FR80066' => 'Beaucourt-sur-lHallue',
	'FR80067' => 'Beaufort-en-Santerre',
	'FR80068' => 'Beaumetz',
	'FR80069' => 'Beaumont-Hamel',
	'FR80070' => 'Beauquesne',
	'FR80071' => 'Beauval',
	'FR80073' => 'Bécordel-Bécourt',
	'FR80074' => 'Becquigny',
	'FR80076' => 'Béhen',
	'FR80077' => 'Béhencourt',
	'FR80078' => 'Bellancourt',
	'FR80079' => 'Belleuse',
	'FR80080' => 'Belloy-en-Santerre',
	'FR80081' => 'Belloy-Saint-Léonard',
	'FR80082' => 'Belloy-sur-Somme',
	'FR80083' => 'Bergicourt',
	'FR80084' => 'Bermesnil',
	'FR80085' => 'Bernâtre',
	'FR80086' => 'Bernaville',
	'FR80087' => 'Bernay-en-Ponthieu',
	'FR80088' => 'Bernes',
	'FR80089' => 'Berneuil',
	'FR80090' => 'Berny-en-Santerre',
	'FR80092' => 'Bertangles',
	'FR80093' => 'Berteaucourt-les-Dames',
	'FR80094' => 'Berteaucourt-lès-Thennes',
	'FR80095' => 'Bertrancourt',
	'FR80096' => 'Béthencourt-sur-Mer',
	'FR80097' => 'Béthencourt-sur-Somme',
	'FR80098' => 'Bettembos',
	'FR80099' => 'Bettencourt-Rivière',
	'FR80100' => 'Bettencourt-Saint-Ouen',
	'FR80101' => 'Beuvraignes',
	'FR80102' => 'Biaches',
	'FR80103' => 'Biarre',
	'FR80104' => 'Biencourt',
	'FR80105' => 'Billancourt',
	'FR80106' => 'Blangy-sous-Poix',
	'FR80107' => 'Blangy-Tronville',
	'FR80108' => 'Boisbergues',
	'FR80109' => 'Le Boisle',
	'FR80110' => 'Boismont',
	'FR80112' => 'Bonnay',
	'FR80113' => 'Bonneville',
	'FR80114' => 'Bosquel',
	'FR80115' => 'Bouchavesnes-Bergen',
	'FR80116' => 'Bouchoir',
	'FR80117' => 'Bouchon',
	'FR80118' => 'Boufflers',
	'FR80119' => 'Bougainville',
	'FR80120' => 'Bouillancourt-en-Séry',
	'FR80121' => 'Bouillancourt-la-Bataille',
	'FR80122' => 'Bouquemaison',
	'FR80123' => 'Bourdon',
	'FR80124' => 'Bourseville',
	'FR80125' => 'Boussicourt',
	'FR80126' => 'Bouttencourt',
	'FR80127' => 'Bouvaincourt-sur-Bresle',
	'FR80128' => 'Bouvincourt-en-Vermandois',
	'FR80129' => 'Bouzincourt',
	'FR80130' => 'Bovelles',
	'FR80131' => 'Boves',
	'FR80132' => 'Braches',
	'FR80133' => 'Brailly-Cornehotte',
	'FR80134' => 'Brassy',
	'FR80135' => 'Bray-lès-Mareuil',
	'FR80136' => 'Bray-sur-Somme',
	'FR80137' => 'Breilly',
	'FR80138' => 'Bresle',
	'FR80139' => 'Breuil',
	'FR80140' => 'Brévillers',
	'FR80141' => 'Brie',
	'FR80142' => 'Briquemesnil-Floxicourt',
	'FR80143' => 'Brocourt',
	'FR80144' => 'Brouchy',
	'FR80145' => 'Brucamps',
	'FR80146' => 'Brutelles',
	'FR80147' => 'Buigny-lAbbé',
	'FR80148' => 'Buigny-lès-Gamaches',
	'FR80149' => 'Buigny-Saint-Maclou',
	'FR80150' => 'Buire-Courcelles',
	'FR80151' => 'Buire-sur-lAncre',
	'FR80152' => 'Bus-la-Mésière',
	'FR80153' => 'Bus-lès-Artois',
	'FR80154' => 'Bussu',
	'FR80155' => 'Bussus-Bussuel',
	'FR80156' => 'Bussy-lès-Daours',
	'FR80157' => 'Bussy-lès-Poix',
	'FR80158' => 'Buverchy',
	'FR80159' => 'Cachy',
	'FR80160' => 'Cagny',
	'FR80161' => 'Cahon',
	'FR80162' => 'Caix',
	'FR80163' => 'Cambron',
	'FR80164' => 'Camon',
	'FR80165' => 'Camps-en-Amiénois',
	'FR80166' => 'Canaples',
	'FR80167' => 'Canchy',
	'FR80168' => 'Candas',
	'FR80169' => 'Cannessières',
	'FR80170' => 'Cantigny',
	'FR80171' => 'Caours',
	'FR80172' => 'Cappy',
	'FR80173' => 'Cardonnette',
	'FR80174' => 'Le Cardonnois',
	'FR80176' => 'Carrépuis',
	'FR80177' => 'Cartigny',
	'FR80179' => 'Caulières',
	'FR80180' => 'Cavillon',
	'FR80181' => 'Cayeux-en-Santerre',
	'FR80182' => 'Cayeux-sur-Mer',
	'FR80183' => 'Cerisy-Buleux',
	'FR80184' => 'Cerisy',
	'FR80185' => 'Champien',
	'FR80186' => 'Chaulnes',
	'FR80187' => 'La Chaussée-Tirancourt',
	'FR80188' => 'Chaussoy-Epagny',
	'FR80189' => 'La Chavatte',
	'FR80190' => 'Chépy',
	'FR80191' => 'Chilly',
	'FR80192' => 'Chipilly',
	'FR80193' => 'Chirmont',
	'FR80194' => 'Chuignes',
	'FR80195' => 'Chuignolles',
	'FR80196' => 'Citerne',
	'FR80197' => 'Cizancourt',
	'FR80198' => 'Clairy-Saulchoix',
	'FR80199' => 'Cléry-sur-Somme',
	'FR80200' => 'Cocquerel',
	'FR80201' => 'Coigneux',
	'FR80202' => 'Coisy',
	'FR80203' => 'Colincamps',
	'FR80204' => 'Combles',
	'FR80205' => 'Condé-Folie',
	'FR80206' => 'Contalmaison',
	'FR80207' => 'Contay',
	'FR80208' => 'Conteville',
	'FR80210' => 'Contre',
	'FR80211' => 'Conty',
	'FR80212' => 'Corbie',
	'FR80213' => 'Cottenchy',
	'FR80214' => 'Coullemelle',
	'FR80215' => 'Coulonvillers',
	'FR80216' => 'Courcelette',
	'FR80217' => 'Courcelles-au-Bois',
	'FR80218' => 'Courcelles-sous-Moyencourt',
	'FR80219' => 'Courcelles-sous-Thoix',
	'FR80220' => 'Courtemanche',
	'FR80221' => 'Cramont',
	'FR80222' => 'Crécy-en-Ponthieu',
	'FR80223' => 'Crémery',
	'FR80224' => 'Cressy-Omencourt',
	'FR80225' => 'Creuse',
	'FR80226' => 'Croix-Moligneaux',
	'FR80227' => 'Croixrault',
	'FR80228' => 'Le Crotoy',
	'FR80229' => 'Crouy-Saint-Pierre',
	'FR80230' => 'Curchy',
	'FR80231' => 'Curlu',
	'FR80232' => 'Damery',
	'FR80233' => 'Dancourt-Popincourt',
	'FR80234' => 'Daours',
	'FR80235' => 'Dargnies',
	'FR80236' => 'Davenescourt',
	'FR80237' => 'Démuin',
	'FR80238' => 'Dernancourt',
	'FR80239' => 'Devise',
	'FR80240' => 'Doingt',
	'FR80241' => 'Domart-en-Ponthieu',
	'FR80242' => 'Domart-sur-la-Luce',
	'FR80243' => 'Domesmont',
	'FR80244' => 'Dominois',
	'FR80245' => 'Domléger-Longvillers',
	'FR80246' => 'Dommartin',
	'FR80247' => 'Dompierre-Becquincourt',
	'FR80248' => 'Dompierre-sur-Authie',
	'FR80249' => 'Domqueur',
	'FR80250' => 'Domvast',
	'FR80251' => 'Doudelainville',
	'FR80252' => 'Douilly',
	'FR80253' => 'Doullens',
	'FR80256' => 'Dreuil-lès-Amiens',
	'FR80258' => 'Driencourt',
	'FR80259' => 'Dromesnil',
	'FR80260' => 'Drucat',
	'FR80261' => 'Dury',
	'FR80262' => 'Eaucourt-sur-Somme',
	'FR80263' => 'LÉchelle-Saint-Aurin',
	'FR80264' => 'Éclusier-Vaux',
	'FR80265' => 'Embreville',
	'FR80266' => 'Englebelmer',
	'FR80267' => 'Ennemain',
	'FR80268' => 'Épagne-Épagnette',
	'FR80269' => 'Épaumesnil',
	'FR80270' => 'Épécamps',
	'FR80271' => 'Épehy',
	'FR80272' => 'Épénancourt',
	'FR80273' => 'Éplessier',
	'FR80274' => 'Eppeville',
	'FR80275' => 'Équancourt',
	'FR80276' => 'Équennes-Éramecourt',
	'FR80278' => 'Erches',
	'FR80279' => 'Ercheu',
	'FR80280' => 'Ercourt',
	'FR80281' => 'Ergnies',
	'FR80282' => 'Érondelle',
	'FR80283' => 'Esclainvillers',
	'FR80284' => 'Esmery-Hallon',
	'FR80285' => 'Essertaux',
	'FR80287' => 'Estrébœuf',
	'FR80288' => 'Estrées-Deniécourt',
	'FR80290' => 'Estrées-lès-Crécy',
	'FR80291' => 'Estrées-sur-Noye',
	'FR80292' => 'Étalon',
	'FR80293' => 'Ételfay',
	'FR80294' => 'Éterpigny',
	'FR80295' => 'Étinehem-Méricourt',
	'FR80296' => 'LÉtoile',
	'FR80297' => 'Étréjust',
	'FR80298' => 'Étricourt-Manancourt',
	'FR80299' => 'La Faloise',
	'FR80300' => 'Falvy',
	'FR80301' => 'Famechon',
	'FR80302' => 'Faverolles',
	'FR80303' => 'Favières',
	'FR80304' => 'Fay',
	'FR80305' => 'Ferrières',
	'FR80306' => 'Fescamps',
	'FR80307' => 'Feuillères',
	'FR80308' => 'Feuquières-en-Vimeu',
	'FR80310' => 'Fienvillers',
	'FR80311' => 'Fignières',
	'FR80312' => 'Fins',
	'FR80313' => 'Flaucourt',
	'FR80314' => 'Flers',
	'FR80315' => 'Flers-sur-Noye',
	'FR80316' => 'Flesselles',
	'FR80317' => 'Fleury',
	'FR80318' => 'Flixecourt',
	'FR80319' => 'Fluy',
	'FR80320' => 'Folies',
	'FR80321' => 'Folleville',
	'FR80322' => 'Fonches-Fonchette',
	'FR80324' => 'Fontaine-le-Sec',
	'FR80325' => 'Fontaine-lès-Cappy',
	'FR80326' => 'Fontaine-sous-Montdidier',
	'FR80327' => 'Fontaine-sur-Maye',
	'FR80328' => 'Fontaine-sur-Somme',
	'FR80329' => 'Forceville',
	'FR80330' => 'Forceville-en-Vimeu',
	'FR80331' => 'Forest-lAbbaye',
	'FR80332' => 'Forest-Montiers',
	'FR80333' => 'Fort-Mahon-Plage',
	'FR80334' => 'Fossemanant',
	'FR80335' => 'Foucaucourt-en-Santerre',
	'FR80336' => 'Foucaucourt-Hors-Nesle',
	'FR80337' => 'Fouencamps',
	'FR80338' => 'Fouilloy',
	'FR80339' => 'Fouquescourt',
	'FR80340' => 'Fourcigny',
	'FR80341' => 'Fourdrinoy',
	'FR80342' => 'Framerville-Rainecourt',
	'FR80343' => 'Framicourt',
	'FR80344' => 'Francières',
	'FR80345' => 'Franleu',
	'FR80346' => 'Franqueville',
	'FR80347' => 'Fransart',
	'FR80348' => 'Fransu',
	'FR80349' => 'Fransures',
	'FR80350' => 'Franvillers',
	'FR80351' => 'Fréchencourt',
	'FR80352' => 'Frémontiers',
	'FR80353' => 'Fresnes-Mazancourt',
	'FR80354' => 'Fresnes-Tilloloy',
	'FR80355' => 'Fresneville',
	'FR80356' => 'Fresnoy-Andainville',
	'FR80357' => 'Fresnoy-au-Val',
	'FR80358' => 'Fresnoy-en-Chaussée',
	'FR80359' => 'Fresnoy-lès-Roye',
	'FR80360' => 'Fressenneville',
	'FR80361' => 'Frettecuisse',
	'FR80362' => 'Frettemeule',
	'FR80364' => 'Friaucourt',
	'FR80365' => 'Fricamps',
	'FR80366' => 'Fricourt',
	'FR80367' => 'Frise',
	'FR80368' => 'Friville-Escarbotin',
	'FR80369' => 'Frohen-sur-Authie',
	'FR80371' => 'Froyelles',
	'FR80372' => 'Frucourt',
	'FR80373' => 'Gamaches',
	'FR80374' => 'Gapennes',
	'FR80375' => 'Gauville',
	'FR80376' => 'Gentelles',
	'FR80377' => 'Gézaincourt',
	'FR80378' => 'Ginchy',
	'FR80379' => 'Glisy',
	'FR80380' => 'Gorenflos',
	'FR80381' => 'Gorges',
	'FR80383' => 'Goyencourt',
	'FR80384' => 'Grandcourt',
	'FR80385' => 'Grand-Laviers',
	'FR80386' => 'Gratibus',
	'FR80387' => 'Grattepanche',
	'FR80388' => 'Grébault-Mesnil',
	'FR80390' => 'Grivesnes',
	'FR80391' => 'Grivillers',
	'FR80392' => 'Grouches-Luchuel',
	'FR80393' => 'Gruny',
	'FR80395' => 'Guerbigny',
	'FR80396' => 'Gueschart',
	'FR80397' => 'Gueudecourt',
	'FR80399' => 'Guignemicourt',
	'FR80400' => 'Guillaucourt',
	'FR80401' => 'Guillemont',
	'FR80402' => 'Guizancourt',
	'FR80403' => 'Guyencourt-sur-Noye',
	'FR80404' => 'Guyencourt-Saulcourt',
	'FR80405' => 'Hailles',
	'FR80406' => 'Hallencourt',
	'FR80407' => 'Hallivillers',
	'FR80408' => 'Halloy-lès-Pernois',
	'FR80409' => 'Hallu',
	'FR80410' => 'Ham',
	'FR80411' => 'Le Hamel',
	'FR80412' => 'Hamelet',
	'FR80413' => 'Hancourt',
	'FR80414' => 'Hangard',
	'FR80415' => 'Hangest-en-Santerre',
	'FR80416' => 'Hangest-sur-Somme',
	'FR80417' => 'Harbonnières',
	'FR80418' => 'Hardecourt-aux-Bois',
	'FR80420' => 'Harponville',
	'FR80421' => 'Hattencourt',
	'FR80422' => 'Hautvillers-Ouville',
	'FR80423' => 'Havernas',
	'FR80424' => 'Hébécourt',
	'FR80425' => 'Hédauville',
	'FR80426' => 'Heilly',
	'FR80427' => 'Hem-Hardinval',
	'FR80428' => 'Hem-Monacu',
	'FR80429' => 'Hénencourt',
	'FR80430' => 'Herbécourt',
	'FR80431' => 'Hérissart',
	'FR80432' => 'Herleville',
	'FR80433' => 'Herly',
	'FR80434' => 'Hervilly',
	'FR80435' => 'Hesbécourt',
	'FR80436' => 'Hescamps',
	'FR80437' => 'Heucourt-Croquoison',
	'FR80438' => 'Heudicourt',
	'FR80439' => 'Heuzecourt',
	'FR80440' => 'Hiermont',
	'FR80442' => 'Hombleux',
	'FR80443' => 'Hornoy-le-Bourg',
	'FR80444' => 'Huchenneville',
	'FR80445' => 'Humbercourt',
	'FR80446' => 'Huppy',
	'FR80449' => 'Ignaucourt',
	'FR80450' => 'Inval-Boiron',
	'FR80451' => 'Irles',
	'FR80452' => 'Jumel',
	'FR80453' => 'Laboissière-en-Santerre',
	'FR80455' => 'Lachapelle',
	'FR80456' => 'Lafresguimont-Saint-Martin',
	'FR80458' => 'Lahoussoye',
	'FR80459' => 'Laleu',
	'FR80460' => 'Lamaronde',
	'FR80461' => 'Lamotte-Brebière',
	'FR80462' => 'Lamotte-Buleux',
	'FR80463' => 'Lamotte-Warfusée',
	'FR80464' => 'Lanchères',
	'FR80465' => 'Languevoisin-Quiquery',
	'FR80466' => 'Lanches-Saint-Hilaire',
	'FR80467' => 'Laucourt',
	'FR80468' => 'Laviéville',
	'FR80469' => 'Lawarde-Mauger-lHortoy',
	'FR80470' => 'Léalvillers',
	'FR80472' => 'Lesbœufs',
	'FR80473' => 'Liancourt-Fosse',
	'FR80474' => 'Licourt',
	'FR80475' => 'Liéramont',
	'FR80476' => 'Liercourt',
	'FR80477' => 'Ligescourt',
	'FR80478' => 'Lignières',
	'FR80479' => 'Lignières-Châtelain',
	'FR80480' => 'Lignières-en-Vimeu',
	'FR80481' => 'Lihons',
	'FR80482' => 'Limeux',
	'FR80484' => 'Liomer',
	'FR80485' => 'Ô-de-Selle',
	'FR80486' => 'Long',
	'FR80487' => 'Longavesnes',
	'FR80488' => 'Longpré-les-Corps-Saints',
	'FR80489' => 'Longueau',
	'FR80490' => 'Longueval',
	'FR80491' => 'Longuevillette',
	'FR80493' => 'Louvencourt',
	'FR80494' => 'Louvrechy',
	'FR80495' => 'Lucheux',
	'FR80496' => 'Machiel',
	'FR80497' => 'Machy',
	'FR80498' => 'Mailly-Maillet',
	'FR80499' => 'Mailly-Raineval',
	'FR80500' => 'Maisnières',
	'FR80501' => 'Maison-Ponthieu',
	'FR80502' => 'Maison-Roland',
	'FR80503' => 'Maizicourt',
	'FR80504' => 'Malpart',
	'FR80505' => 'Carnoy-Mametz',
	'FR80507' => 'Marcelcave',
	'FR80508' => 'Marché-Allouarde',
	'FR80509' => 'Marchélepot-Misery',
	'FR80511' => 'Marestmontiers',
	'FR80512' => 'Mareuil-Caubert',
	'FR80513' => 'Maricourt',
	'FR80514' => 'Marieux',
	'FR80515' => 'Marlers',
	'FR80516' => 'Marquaix',
	'FR80517' => 'Marquivillers',
	'FR80518' => 'Martainneville',
	'FR80519' => 'Matigny',
	'FR80520' => 'Maucourt',
	'FR80521' => 'Maurepas',
	'FR80522' => 'Le Mazis',
	'FR80523' => 'Méaulte',
	'FR80524' => 'Méharicourt',
	'FR80525' => 'Meigneux',
	'FR80526' => 'Le Meillard',
	'FR80527' => 'Méneslies',
	'FR80528' => 'Méréaucourt',
	'FR80529' => 'Mérélessart',
	'FR80530' => 'Méricourt-lAbbé',
	'FR80531' => 'Méricourt-en-Vimeu',
	'FR80533' => 'Mers-les-Bains',
	'FR80535' => 'Le Mesge',
	'FR80536' => 'Mesnil-Bruntel',
	'FR80537' => 'Mesnil-Domqueur',
	'FR80538' => 'Mesnil-en-Arrouaise',
	'FR80540' => 'Mesnil-Martinsart',
	'FR80541' => 'Mesnil-Saint-Georges',
	'FR80542' => 'Mesnil-Saint-Nicaise',
	'FR80543' => 'Métigny',
	'FR80544' => 'Mézerolles',
	'FR80545' => 'Mézières-en-Santerre',
	'FR80546' => 'Miannay',
	'FR80547' => 'Millencourt',
	'FR80548' => 'Millencourt-en-Ponthieu',
	'FR80549' => 'Miraumont',
	'FR80550' => 'Mirvaux',
	'FR80552' => 'Moislains',
	'FR80553' => 'Molliens-au-Bois',
	'FR80554' => 'Molliens-Dreuil',
	'FR80555' => 'Monchy-Lagache',
	'FR80556' => 'Mons-Boubert',
	'FR80557' => 'Estrées-Mons',
	'FR80558' => 'Monsures',
	'FR80559' => 'Montagne-Fayel',
	'FR80560' => 'Montauban-de-Picardie',
	'FR80561' => 'Montdidier',
	'FR80562' => 'Montigny-sur-lHallue',
	'FR80563' => 'Montigny-les-Jongleurs',
	'FR80565' => 'Montonvillers',
	'FR80566' => 'Fieffes-Montrelet',
	'FR80568' => 'Morchain',
	'FR80569' => 'Morcourt',
	'FR80570' => 'Moreuil',
	'FR80571' => 'Morisel',
	'FR80572' => 'Morlancourt',
	'FR80573' => 'Morvillers-Saint-Saturnin',
	'FR80574' => 'Mouflers',
	'FR80575' => 'Mouflières',
	'FR80576' => 'Moyencourt',
	'FR80577' => 'Moyencourt-lès-Poix',
	'FR80578' => 'Moyenneville',
	'FR80579' => 'Muille-Villette',
	'FR80580' => 'Nampont',
	'FR80582' => 'Namps-Maisnil',
	'FR80583' => 'Nampty',
	'FR80584' => 'Naours',
	'FR80585' => 'Nesle',
	'FR80586' => 'Nesle-lHôpital',
	'FR80587' => 'Neslette',
	'FR80588' => 'Neufmoulin',
	'FR80589' => 'Neuilly-le-Dien',
	'FR80590' => 'Neuilly-lHôpital',
	'FR80591' => 'Neuville-au-Bois',
	'FR80592' => 'Neuville-Coppegueule',
	'FR80593' => 'La Neuville-lès-Bray',
	'FR80595' => 'La Neuville-Sire-Bernard',
	'FR80596' => 'Neuvillette',
	'FR80597' => 'Nibas',
	'FR80598' => 'Nouvion',
	'FR80599' => 'Noyelles-en-Chaussée',
	'FR80600' => 'Noyelles-sur-Mer',
	'FR80601' => 'Nurlu',
	'FR80602' => 'Occoches',
	'FR80603' => 'Ochancourt',
	'FR80604' => 'Offignies',
	'FR80605' => 'Offoy',
	'FR80606' => 'Oisemont',
	'FR80607' => 'Oissy',
	'FR80609' => 'Oneux',
	'FR80611' => 'Oresmaux',
	'FR80613' => 'Oust-Marest',
	'FR80614' => 'Outrebois',
	'FR80615' => 'Ovillers-la-Boisselle',
	'FR80616' => 'Pargny',
	'FR80617' => 'Parvillers-le-Quesnoy',
	'FR80618' => 'Pendé',
	'FR80619' => 'Pernois',
	'FR80620' => 'Péronne',
	'FR80621' => 'Hypercourt',
	'FR80622' => 'Picquigny',
	'FR80623' => 'Piennes-Onvillers',
	'FR80624' => 'Pierregot',
	'FR80625' => 'Trois-Rivières',
	'FR80626' => 'Pissy',
	'FR80627' => 'Plachy-Buyon',
	'FR80628' => 'Le Plessier-Rozainvillers',
	'FR80629' => 'Pœuilly',
	'FR80630' => 'Poix-de-Picardie',
	'FR80631' => 'Ponches-Estruval',
	'FR80632' => 'Pont-de-Metz',
	'FR80633' => 'Ponthoile',
	'FR80634' => 'Pont-Noyelles',
	'FR80635' => 'Pont-Remy',
	'FR80637' => 'Port-le-Grand',
	'FR80638' => 'Potte',
	'FR80639' => 'Poulainville',
	'FR80640' => 'Pozières',
	'FR80642' => 'Prouville',
	'FR80643' => 'Prouzel',
	'FR80644' => 'Proyart',
	'FR80645' => 'Puchevillers',
	'FR80646' => 'Punchy',
	'FR80647' => 'Puzeaux',
	'FR80648' => 'Pys',
	'FR80649' => 'Quend',
	'FR80650' => 'Querrieu',
	'FR80651' => 'Le Quesne',
	'FR80652' => 'Le Quesnel',
	'FR80654' => 'Quesnoy-le-Montant',
	'FR80655' => 'Quesnoy-sur-Airaines',
	'FR80656' => 'Quevauvillers',
	'FR80657' => 'Quiry-le-Sec',
	'FR80658' => 'Quivières',
	'FR80659' => 'Raincheval',
	'FR80661' => 'Rainneville',
	'FR80662' => 'Ramburelles',
	'FR80663' => 'Rambures',
	'FR80664' => 'Rancourt',
	'FR80665' => 'Regnière-Écluse',
	'FR80666' => 'Remaisnil',
	'FR80667' => 'Remaugies',
	'FR80668' => 'Remiencourt',
	'FR80669' => 'Rethonvillers',
	'FR80670' => 'Revelles',
	'FR80671' => 'Ribeaucourt',
	'FR80672' => 'Ribemont-sur-Ancre',
	'FR80673' => 'Riencourt',
	'FR80674' => 'Rivery',
	'FR80675' => 'Rogy',
	'FR80676' => 'Roiglise',
	'FR80677' => 'Roisel',
	'FR80678' => 'Rollot',
	'FR80679' => 'Ronssoy',
	'FR80680' => 'Rosières-en-Santerre',
	'FR80681' => 'Rouvrel',
	'FR80682' => 'Rouvroy-en-Santerre',
	'FR80683' => 'Rouy-le-Grand',
	'FR80684' => 'Rouy-le-Petit',
	'FR80685' => 'Roye',
	'FR80686' => 'Rubempré',
	'FR80687' => 'Rubescourt',
	'FR80688' => 'Rue',
	'FR80690' => 'Rumigny',
	'FR80691' => 'Saigneville',
	'FR80692' => 'Sailly-Flibeaucourt',
	'FR80693' => 'Sailly-Laurette',
	'FR80694' => 'Sailly-le-Sec',
	'FR80695' => 'Sailly-Saillisel',
	'FR80696' => 'Sains-en-Amiénois',
	'FR80697' => 'Saint-Acheul',
	'FR80698' => 'Saint-Aubin-Montenoy',
	'FR80699' => 'Saint-Aubin-Rivière',
	'FR80700' => 'Saint-Blimont',
	'FR80701' => 'Saint-Christ-Briost',
	'FR80702' => 'Saint-Fuscien',
	'FR80703' => 'Saint-Germain-sur-Bresle',
	'FR80704' => 'Saint-Gratien',
	'FR80705' => 'Saint-Léger-lès-Authie',
	'FR80706' => 'Saint-Léger-lès-Domart',
	'FR80707' => 'Saint-Léger-sur-Bresle',
	'FR80708' => 'Saint-Mard',
	'FR80709' => 'Saint-Maulvis',
	'FR80710' => 'Saint-Maxent',
	'FR80711' => 'Saint-Ouen',
	'FR80713' => 'Saint-Quentin-en-Tourmont',
	'FR80714' => 'Saint-Quentin-la-Motte-Croix-au-Bailly',
	'FR80716' => 'Saint-Riquier',
	'FR80717' => 'Saint-Sauflieu',
	'FR80718' => 'Saint-Sauveur',
	'FR80719' => 'Sainte-Segrée',
	'FR80721' => 'Saint-Valery-sur-Somme',
	'FR80722' => 'Saint-Vaast-en-Chaussée',
	'FR80723' => 'Saisseval',
	'FR80724' => 'Saleux',
	'FR80725' => 'Salouël',
	'FR80726' => 'Sancourt',
	'FR80728' => 'Saulchoy-sous-Poix',
	'FR80729' => 'Sauvillers-Mongival',
	'FR80730' => 'Saveuse',
	'FR80732' => 'Senarpont',
	'FR80733' => 'Senlis-le-Sec',
	'FR80734' => 'Sentelie',
	'FR80735' => 'Seux',
	'FR80736' => 'Sorel-en-Vimeu',
	'FR80737' => 'Sorel',
	'FR80738' => 'Soues',
	'FR80740' => 'Sourdon',
	'FR80741' => 'Soyécourt',
	'FR80742' => 'Surcamps',
	'FR80743' => 'Suzanne',
	'FR80744' => 'Tailly',
	'FR80746' => 'Talmas',
	'FR80747' => 'Templeux-la-Fosse',
	'FR80748' => 'Templeux-le-Guérard',
	'FR80749' => 'Terramesnil',
	'FR80750' => 'Tertry',
	'FR80751' => 'Thennes',
	'FR80752' => 'Thézy-Glimont',
	'FR80753' => 'Thiepval',
	'FR80754' => 'Thieulloy-lAbbaye',
	'FR80755' => 'Thieulloy-la-Ville',
	'FR80756' => 'Thièvres',
	'FR80757' => 'Thoix',
	'FR80758' => 'Thory',
	'FR80759' => 'Tilloloy',
	'FR80760' => 'Tilloy-Floriville',
	'FR80762' => 'Tincourt-Boucly',
	'FR80763' => 'Le Titre',
	'FR80764' => 'Tœufles',
	'FR80765' => 'Tours-en-Vimeu',
	'FR80766' => 'Toutencourt',
	'FR80767' => 'Le Translay',
	'FR80769' => 'Treux',
	'FR80770' => 'Tully',
	'FR80771' => 'Ugny-lÉquipée',
	'FR80773' => 'Vadencourt',
	'FR80774' => 'Vaire-sous-Corbie',
	'FR80775' => 'Valines',
	'FR80776' => 'Varennes',
	'FR80777' => 'Vauchelles-lès-Authie',
	'FR80778' => 'Vauchelles-lès-Domart',
	'FR80779' => 'Vauchelles-les-Quesnoy',
	'FR80780' => 'Vaudricourt',
	'FR80781' => 'Vauvillers',
	'FR80782' => 'Vaux-en-Amiénois',
	'FR80783' => 'Vaux-Marquenneville',
	'FR80784' => 'Vaux-sur-Somme',
	'FR80785' => 'Vecquemont',
	'FR80786' => 'Velennes',
	'FR80787' => 'Vercourt',
	'FR80788' => 'Vergies',
	'FR80789' => 'Vermandovillers',
	'FR80790' => 'Verpillières',
	'FR80791' => 'Vers-sur-Selle',
	'FR80792' => 'La Vicogne',
	'FR80793' => 'Vignacourt',
	'FR80794' => 'Villecourt',
	'FR80795' => 'Ville-le-Marclet',
	'FR80796' => 'Villeroy',
	'FR80797' => 'Villers-aux-Érables',
	'FR80798' => 'Villers-Bocage',
	'FR80799' => 'Villers-Bretonneux',
	'FR80800' => 'Villers-Campsart',
	'FR80801' => 'Villers-Carbonnel',
	'FR80802' => 'Villers-Faucon',
	'FR80803' => 'Villers-lès-Roye',
	'FR80804' => 'Villers-sous-Ailly',
	'FR80805' => 'Villers-Tournelle',
	'FR80806' => 'Villers-sur-Authie',
	'FR80807' => 'Ville-sur-Ancre',
	'FR80808' => 'Vironchaux',
	'FR80809' => 'Vismes',
	'FR80810' => 'Vitz-sur-Authie',
	'FR80811' => 'Voyennes',
	'FR80812' => 'Vraignes-en-Vermandois',
	'FR80813' => 'Vraignes-lès-Hornoy',
	'FR80814' => 'Vrély',
	'FR80815' => 'Vron',
	'FR80819' => 'Wargnies',
	'FR80820' => 'Warloy-Baillon',
	'FR80821' => 'Warlus',
	'FR80822' => 'Warsy',
	'FR80823' => 'Warvillers',
	'FR80824' => 'Wiencourt-lÉquipée',
	'FR80825' => 'Wiry-au-Mont',
	'FR80826' => 'Woignarue',
	'FR80827' => 'Woincourt',
	'FR80828' => 'Woirel',
	'FR80829' => 'Y',
	'FR80830' => 'Yaucourt-Bussus',
	'FR80832' => 'Yvrench',
	'FR80833' => 'Yvrencheux',
	'FR80834' => 'Yzengremer',
	'FR80835' => 'Yzeux',
	'FR80836' => 'Yonval',
	'FR81001' => 'Aguts',
	'FR81002' => 'Aiguefonde',
	'FR81003' => 'Alban',
	'FR81004' => 'Albi',
	'FR81005' => 'Albine',
	'FR81006' => 'Algans',
	'FR81007' => 'Alos',
	'FR81008' => 'Almayrac',
	'FR81009' => 'Amarens',
	'FR81010' => 'Ambialet',
	'FR81011' => 'Ambres',
	'FR81012' => 'Andillac',
	'FR81013' => 'Andouque',
	'FR81014' => 'Anglès',
	'FR81015' => 'Appelle',
	'FR81016' => 'Arfons',
	'FR81017' => 'Arifat',
	'FR81018' => 'Arthès',
	'FR81019' => 'Assac',
	'FR81020' => 'Aussac',
	'FR81021' => 'Aussillon',
	'FR81022' => 'Bannières',
	'FR81023' => 'Barre',
	'FR81024' => 'Beauvais-sur-Tescou',
	'FR81025' => 'Belcastel',
	'FR81026' => 'Bellegarde-Marsal',
	'FR81027' => 'Belleserre',
	'FR81028' => 'Berlats',
	'FR81029' => 'Bernac',
	'FR81030' => 'Bertre',
	'FR81031' => 'Le Bez',
	'FR81032' => 'Blan',
	'FR81033' => 'Blaye-les-Mines',
	'FR81034' => 'Boissezon',
	'FR81035' => 'Bournazel',
	'FR81036' => 'Bout-du-Pont-de-Larn',
	'FR81037' => 'Brassac',
	'FR81038' => 'Brens',
	'FR81039' => 'Briatexte',
	'FR81040' => 'Brousse',
	'FR81041' => 'Broze',
	'FR81042' => 'Burlats',
	'FR81043' => 'Busque',
	'FR81044' => 'Cabanès',
	'FR81045' => 'Les Cabannes',
	'FR81046' => 'Cadalen',
	'FR81047' => 'Cadix',
	'FR81048' => 'Cagnac-les-Mines',
	'FR81049' => 'Cahuzac',
	'FR81050' => 'Cambon-lès-Lavaur',
	'FR81051' => 'Cahuzac-sur-Vère',
	'FR81052' => 'Cambon',
	'FR81053' => 'Cambounès',
	'FR81054' => 'Cambounet-sur-le-Sor',
	'FR81055' => 'Les Cammazes',
	'FR81056' => 'Campagnac',
	'FR81058' => 'Carbes',
	'FR81059' => 'Carlus',
	'FR81060' => 'Carmaux',
	'FR81061' => 'Castanet',
	'FR81062' => 'Fontrieu',
	'FR81063' => 'Castelnau-de-Lévis',
	'FR81064' => 'Castelnau-de-Montmiral',
	'FR81065' => 'Castres',
	'FR81066' => 'Caucalières',
	'FR81067' => 'Cestayrols',
	'FR81068' => 'Combefa',
	'FR81069' => 'Cordes-sur-Ciel',
	'FR81070' => 'Coufouleux',
	'FR81071' => 'Courris',
	'FR81072' => 'Crespin',
	'FR81073' => 'Crespinet',
	'FR81074' => 'Cunac',
	'FR81075' => 'Cuq',
	'FR81076' => 'Cuq-Toulza',
	'FR81077' => 'Curvalle',
	'FR81078' => 'Damiatte',
	'FR81079' => 'Dénat',
	'FR81080' => 'Donnazac',
	'FR81081' => 'Dourgne',
	'FR81082' => 'Le Dourn',
	'FR81083' => 'Durfort',
	'FR81084' => 'Escoussens',
	'FR81085' => 'Escroux',
	'FR81086' => 'Espérausses',
	'FR81087' => 'Fayssac',
	'FR81088' => 'Fauch',
	'FR81089' => 'Faussergues',
	'FR81090' => 'Fénols',
	'FR81092' => 'Fiac',
	'FR81093' => 'Florentin',
	'FR81094' => 'Fraissines',
	'FR81095' => 'Frausseilles',
	'FR81096' => 'Le Fraysse',
	'FR81097' => 'Fréjairolles',
	'FR81098' => 'Fréjeville',
	'FR81099' => 'Gaillac',
	'FR81100' => 'Garrevaques',
	'FR81101' => 'Le Garric',
	'FR81102' => 'Garrigues',
	'FR81103' => 'Gijounet',
	'FR81104' => 'Giroussens',
	'FR81105' => 'Graulhet',
	'FR81106' => 'Grazac',
	'FR81108' => 'Itzac',
	'FR81109' => 'Jonquières',
	'FR81110' => 'Jouqueviel',
	'FR81111' => 'Labarthe-Bleys',
	'FR81112' => 'Labastide-de-Lévis',
	'FR81114' => 'Labastide-Gabausse',
	'FR81115' => 'Labastide-Rouairoux',
	'FR81116' => 'Labastide-Saint-Georges',
	'FR81117' => 'Labessière-Candeil',
	'FR81118' => 'Laboulbène',
	'FR81119' => 'Laboutarie',
	'FR81120' => 'Labruguière',
	'FR81121' => 'Lacabarède',
	'FR81122' => 'Lacapelle-Pinet',
	'FR81123' => 'Lacapelle-Ségalar',
	'FR81124' => 'Lacaune',
	'FR81125' => 'Lacaze',
	'FR81126' => 'Lacougotte-Cadoul',
	'FR81127' => 'Lacroisille',
	'FR81128' => 'Lacrouzette',
	'FR81129' => 'Lagardiolle',
	'FR81130' => 'Lagarrigue',
	'FR81131' => 'Lagrave',
	'FR81132' => 'Guitalens-LAlbarède',
	'FR81133' => 'Lamillarié',
	'FR81134' => 'Lamontélarié',
	'FR81135' => 'Laparrouquial',
	'FR81136' => 'Larroque',
	'FR81137' => 'Lasfaillades',
	'FR81138' => 'Lasgraisses',
	'FR81139' => 'Lautrec',
	'FR81140' => 'Lavaur',
	'FR81141' => 'Lédas-et-Penthiès',
	'FR81142' => 'Lempaut',
	'FR81143' => 'Lescout',
	'FR81144' => 'Lescure-dAlbigeois',
	'FR81145' => 'Lisle-sur-Tarn',
	'FR81146' => 'Livers-Cazelles',
	'FR81147' => 'Lombers',
	'FR81148' => 'Loubers',
	'FR81149' => 'Loupiac',
	'FR81150' => 'Lugan',
	'FR81151' => 'Magrin',
	'FR81152' => 'Mailhoc',
	'FR81154' => 'Marnaves',
	'FR81156' => 'Marssac-sur-Tarn',
	'FR81157' => 'Marzens',
	'FR81158' => 'Le Masnau-Massuguiès',
	'FR81159' => 'Massac-Séran',
	'FR81160' => 'Massaguel',
	'FR81161' => 'Massals',
	'FR81162' => 'Maurens-Scopont',
	'FR81163' => 'Mazamet',
	'FR81164' => 'Mézens',
	'FR81165' => 'Milhars',
	'FR81166' => 'Milhavet',
	'FR81167' => 'Miolles',
	'FR81168' => 'Mirandol-Bourgnounac',
	'FR81169' => 'Missècle',
	'FR81170' => 'Monestiés',
	'FR81171' => 'Montans',
	'FR81172' => 'Montauriol',
	'FR81173' => 'Montcabrier',
	'FR81174' => 'Montdragon',
	'FR81175' => 'Montdurausse',
	'FR81176' => 'Montels',
	'FR81177' => 'Montfa',
	'FR81178' => 'Montgaillard',
	'FR81179' => 'Montgey',
	'FR81180' => 'Montirat',
	'FR81181' => 'Montpinier',
	'FR81182' => 'Montredon-Labessonnié',
	'FR81183' => 'Mont-Roc',
	'FR81184' => 'Montrosier',
	'FR81185' => 'Montvalen',
	'FR81186' => 'Moularès',
	'FR81187' => 'Moulayrès',
	'FR81188' => 'Moulin-Mage',
	'FR81189' => 'Mouzens',
	'FR81190' => 'Mouzieys-Teulet',
	'FR81191' => 'Mouzieys-Panens',
	'FR81192' => 'Murat-sur-Vèbre',
	'FR81193' => 'Nages',
	'FR81195' => 'Navès',
	'FR81196' => 'Noailhac',
	'FR81197' => 'Noailles',
	'FR81198' => 'Orban',
	'FR81199' => 'Padiès',
	'FR81200' => 'Palleville',
	'FR81201' => 'Pampelonne',
	'FR81202' => 'Parisot',
	'FR81203' => 'Paulinet',
	'FR81204' => 'Payrin-Augmontel',
	'FR81205' => 'Péchaudier',
	'FR81206' => 'Penne',
	'FR81207' => 'Peyregoux',
	'FR81208' => 'Peyrole',
	'FR81209' => 'Pont-de-Larn',
	'FR81210' => 'Poudis',
	'FR81211' => 'Poulan-Pouzols',
	'FR81212' => 'Prades',
	'FR81213' => 'Pratviel',
	'FR81214' => 'Puéchoursi',
	'FR81215' => 'Puybegon',
	'FR81216' => 'Puycalvel',
	'FR81217' => 'Puycelsi',
	'FR81218' => 'Puygouzon',
	'FR81219' => 'Puylaurens',
	'FR81220' => 'Rabastens',
	'FR81221' => 'Rayssac',
	'FR81222' => 'Réalmont',
	'FR81223' => 'Le Rialet',
	'FR81224' => 'Le Riols',
	'FR81225' => 'Rivières',
	'FR81227' => 'Roquecourbe',
	'FR81228' => 'Roquemaure',
	'FR81229' => 'Roquevidal',
	'FR81230' => 'Rosières',
	'FR81231' => 'Rouairoux',
	'FR81232' => 'Rouffiac',
	'FR81233' => 'Terre-de-Bancalié',
	'FR81234' => 'Roussayrolles',
	'FR81235' => 'Saint-Affrique-les-Montagnes',
	'FR81236' => 'Saint-Agnan',
	'FR81237' => 'Saint-Amancet',
	'FR81238' => 'Saint-Amans-Soult',
	'FR81239' => 'Saint-Amans-Valtoret',
	'FR81240' => 'Saint-André',
	'FR81242' => 'Saint-Avit',
	'FR81243' => 'Saint-Beauzile',
	'FR81244' => 'Saint-Benoît-de-Carmaux',
	'FR81245' => 'Saint-Christophe',
	'FR81246' => 'Sainte-Cécile-du-Cayrou',
	'FR81247' => 'Saint-Cirgue',
	'FR81248' => 'Saint-Gauzens',
	'FR81249' => 'Sainte-Gemme',
	'FR81250' => 'Saint-Genest-de-Contest',
	'FR81251' => 'Saint-Germain-des-Prés',
	'FR81252' => 'Saint-Germier',
	'FR81253' => 'Saint-Grégoire',
	'FR81254' => 'Saint-Jean-de-Marcel',
	'FR81255' => 'Saint-Jean-de-Rives',
	'FR81256' => 'Saint-Jean-de-Vals',
	'FR81257' => 'Saint-Juéry',
	'FR81258' => 'Saint-Julien-du-Puy',
	'FR81259' => 'Saint-Julien-Gaulène',
	'FR81261' => 'Saint-Lieux-lès-Lavaur',
	'FR81262' => 'Saint-Marcel-Campes',
	'FR81263' => 'Saint-Martin-Laguépie',
	'FR81264' => 'Saint-Michel-Labadié',
	'FR81265' => 'Saint-Michel-de-Vax',
	'FR81266' => 'Saint-Paul-Cap-de-Joux',
	'FR81267' => 'Saint-Pierre-de-Trivisy',
	'FR81268' => 'Saint-Salvi-de-Carcavès',
	'FR81269' => 'Saint-Salvy-de-la-Balme',
	'FR81270' => 'Saint-Sernin-lès-Lavaur',
	'FR81271' => 'Saint-Sulpice-la-Pointe',
	'FR81272' => 'Saint-Urcisse',
	'FR81273' => 'Saïx',
	'FR81274' => 'Saliès',
	'FR81275' => 'Salles',
	'FR81276' => 'Salvagnac',
	'FR81277' => 'Saussenac',
	'FR81278' => 'Sauveterre',
	'FR81279' => 'La Sauzière-Saint-Jean',
	'FR81280' => 'Le Ségur',
	'FR81281' => 'Sémalens',
	'FR81282' => 'Senaux',
	'FR81283' => 'Senouillac',
	'FR81284' => 'Le Sequestre',
	'FR81285' => 'Sérénac',
	'FR81286' => 'Serviès',
	'FR81287' => 'Sieurac',
	'FR81288' => 'Sorèze',
	'FR81289' => 'Soual',
	'FR81290' => 'Souel',
	'FR81291' => 'Taïx',
	'FR81292' => 'Tanus',
	'FR81293' => 'Tauriac',
	'FR81294' => 'Técou',
	'FR81295' => 'Teillet',
	'FR81297' => 'Terssac',
	'FR81298' => 'Teulat',
	'FR81299' => 'Teyssode',
	'FR81300' => 'Tonnac',
	'FR81302' => 'Tréban',
	'FR81303' => 'Trébas',
	'FR81304' => 'Trévien',
	'FR81305' => 'Vabre',
	'FR81306' => 'Valderiès',
	'FR81307' => 'Valdurenque',
	'FR81308' => 'Valence-dAlbigeois',
	'FR81309' => 'Vaour',
	'FR81310' => 'Veilhes',
	'FR81311' => 'Vénès',
	'FR81312' => 'Verdalle',
	'FR81313' => 'Le Verdier',
	'FR81314' => 'Viane',
	'FR81315' => 'Vielmur-sur-Agout',
	'FR81316' => 'Vieux',
	'FR81317' => 'Villefranche-dAlbigeois',
	'FR81318' => 'Villeneuve-lès-Lavaur',
	'FR81319' => 'Villeneuve-sur-Vère',
	'FR81320' => 'Vindrac-Alayrac',
	'FR81321' => 'Le Vintrou',
	'FR81322' => 'Virac',
	'FR81323' => 'Viterbe',
	'FR81324' => 'Viviers-lès-Lavaur',
	'FR81325' => 'Viviers-lès-Montagnes',
	'FR81326' => 'Sainte-Croix',
	'FR82001' => 'Albefeuille-Lagarde',
	'FR82002' => 'Albias',
	'FR82003' => 'Angeville',
	'FR82004' => 'Asques',
	'FR82005' => 'Aucamville',
	'FR82006' => 'Auterive',
	'FR82007' => 'Auty',
	'FR82008' => 'Auvillar',
	'FR82009' => 'Balignac',
	'FR82010' => 'Bardigues',
	'FR82011' => 'Barry-dIslemade',
	'FR82012' => 'Les Barthes',
	'FR82013' => 'Beaumont-de-Lomagne',
	'FR82014' => 'Beaupuy',
	'FR82015' => 'Belbèze-en-Lomagne',
	'FR82016' => 'Belvèze',
	'FR82017' => 'Bessens',
	'FR82018' => 'Bioule',
	'FR82019' => 'Boudou',
	'FR82020' => 'Bouillac',
	'FR82021' => 'Bouloc-en-Quercy',
	'FR82022' => 'Bourg-de-Visa',
	'FR82023' => 'Bourret',
	'FR82024' => 'Brassac',
	'FR82025' => 'Bressols',
	'FR82026' => 'Bruniquel',
	'FR82027' => 'Campsas',
	'FR82028' => 'Canals',
	'FR82029' => 'Castanet',
	'FR82030' => 'Castelferrus',
	'FR82031' => 'Castelmayran',
	'FR82032' => 'Castelsagrat',
	'FR82033' => 'Castelsarrasin',
	'FR82034' => 'Castéra-Bouzet',
	'FR82035' => 'Caumont',
	'FR82036' => 'Le Causé',
	'FR82037' => 'Caussade',
	'FR82038' => 'Caylus',
	'FR82039' => 'Cayrac',
	'FR82040' => 'Cayriech',
	'FR82041' => 'Cazals',
	'FR82042' => 'Cazes-Mondenard',
	'FR82043' => 'Comberouger',
	'FR82044' => 'Corbarieu',
	'FR82045' => 'Cordes-Tolosannes',
	'FR82046' => 'Coutures',
	'FR82047' => 'Cumont',
	'FR82048' => 'Dieupentale',
	'FR82049' => 'Donzac',
	'FR82050' => 'Dunes',
	'FR82051' => 'Durfort-Lacapelette',
	'FR82052' => 'Escatalens',
	'FR82053' => 'Escazeaux',
	'FR82054' => 'Espalais',
	'FR82055' => 'Esparsac',
	'FR82056' => 'Espinas',
	'FR82057' => 'Fabas',
	'FR82058' => 'Fajolles',
	'FR82059' => 'Faudoas',
	'FR82060' => 'Fauroux',
	'FR82061' => 'Féneyrols',
	'FR82062' => 'Finhan',
	'FR82063' => 'Garganvillar',
	'FR82064' => 'Gariès',
	'FR82065' => 'Gasques',
	'FR82066' => 'Génébrières',
	'FR82067' => 'Gensac',
	'FR82068' => 'Gimat',
	'FR82069' => 'Ginals',
	'FR82070' => 'Glatens',
	'FR82071' => 'Goas',
	'FR82072' => 'Golfech',
	'FR82073' => 'Goudourville',
	'FR82074' => 'Gramont',
	'FR82075' => 'Grisolles',
	'FR82076' => 'LHonor-de-Cos',
	'FR82077' => 'Labarthe',
	'FR82078' => 'Labastide-de-Penne',
	'FR82079' => 'Labastide-Saint-Pierre',
	'FR82080' => 'Labastide-du-Temple',
	'FR82081' => 'Labourgade',
	'FR82082' => 'Lacapelle-Livron',
	'FR82083' => 'Lachapelle',
	'FR82084' => 'Lacour',
	'FR82085' => 'Lacourt-Saint-Pierre',
	'FR82086' => 'Lafitte',
	'FR82087' => 'Lafrançaise',
	'FR82088' => 'Laguépie',
	'FR82089' => 'Lamagistère',
	'FR82090' => 'Lamothe-Capdeville',
	'FR82091' => 'Lamothe-Cumont',
	'FR82092' => 'Lapenche',
	'FR82093' => 'Larrazet',
	'FR82094' => 'Lauzerte',
	'FR82095' => 'Lavaurette',
	'FR82096' => 'La Ville-Dieu-du-Temple',
	'FR82097' => 'Lavit',
	'FR82098' => 'Léojac',
	'FR82099' => 'Lizac',
	'FR82100' => 'Loze',
	'FR82101' => 'Malause',
	'FR82102' => 'Mansonville',
	'FR82103' => 'Marignac',
	'FR82104' => 'Marsac',
	'FR82105' => 'Mas-Grenier',
	'FR82106' => 'Maubec',
	'FR82107' => 'Maumusson',
	'FR82108' => 'Meauzac',
	'FR82109' => 'Merles',
	'FR82110' => 'Mirabel',
	'FR82111' => 'Miramont-de-Quercy',
	'FR82112' => 'Moissac',
	'FR82113' => 'Molières',
	'FR82114' => 'Monbéqui',
	'FR82115' => 'Monclar-de-Quercy',
	'FR82116' => 'Montagudet',
	'FR82117' => 'Montaigu-de-Quercy',
	'FR82118' => 'Montaïn',
	'FR82119' => 'Montalzat',
	'FR82120' => 'Montastruc',
	'FR82121' => 'Montauban',
	'FR82122' => 'Montbarla',
	'FR82123' => 'Montbartier',
	'FR82124' => 'Montbeton',
	'FR82125' => 'Montech',
	'FR82126' => 'Monteils',
	'FR82127' => 'Montesquieu',
	'FR82128' => 'Montfermier',
	'FR82129' => 'Montgaillard',
	'FR82130' => 'Montjoi',
	'FR82131' => 'Montpezat-de-Quercy',
	'FR82132' => 'Montricoux',
	'FR82133' => 'Mouillac',
	'FR82134' => 'Nègrepelisse',
	'FR82135' => 'Nohic',
	'FR82136' => 'Orgueil',
	'FR82137' => 'Parisot',
	'FR82138' => 'Perville',
	'FR82139' => 'Le Pin',
	'FR82140' => 'Piquecos',
	'FR82141' => 'Pommevic',
	'FR82142' => 'Pompignan',
	'FR82143' => 'Poupas',
	'FR82144' => 'Puycornet',
	'FR82145' => 'Puygaillard-de-Quercy',
	'FR82146' => 'Puygaillard-de-Lomagne',
	'FR82147' => 'Puylagarde',
	'FR82148' => 'Puylaroque',
	'FR82149' => 'Réalville',
	'FR82150' => 'Reyniès',
	'FR82151' => 'Roquecor',
	'FR82152' => 'Saint-Aignan',
	'FR82153' => 'Saint-Amans-du-Pech',
	'FR82154' => 'Saint-Amans-de-Pellagal',
	'FR82155' => 'Saint-Antonin-Noble-Val',
	'FR82156' => 'Saint-Arroumex',
	'FR82157' => 'Saint-Beauzeil',
	'FR82158' => 'Saint-Cirice',
	'FR82159' => 'Saint-Cirq',
	'FR82160' => 'Saint-Clair',
	'FR82161' => 'Saint-Étienne-de-Tulmont',
	'FR82162' => 'Saint-Georges',
	'FR82163' => 'Saint-Jean-du-Bouzet',
	'FR82164' => 'Sainte-Juliette',
	'FR82165' => 'Saint-Loup',
	'FR82166' => 'Saint-Michel',
	'FR82167' => 'Saint-Nauphary',
	'FR82168' => 'Saint-Nazaire-de-Valentane',
	'FR82169' => 'Saint-Nicolas-de-la-Grave',
	'FR82170' => 'Saint-Paul-dEspis',
	'FR82171' => 'Saint-Porquier',
	'FR82172' => 'Saint-Projet',
	'FR82173' => 'Saint-Sardos',
	'FR82174' => 'Saint-Vincent-dAutéjac',
	'FR82175' => 'Saint-Vincent-Lespinasse',
	'FR82176' => 'La Salvetat-Belmontet',
	'FR82177' => 'Sauveterre',
	'FR82178' => 'Savenès',
	'FR82179' => 'Septfonds',
	'FR82180' => 'Sérignac',
	'FR82181' => 'Sistels',
	'FR82182' => 'Touffailles',
	'FR82183' => 'Tréjouls',
	'FR82184' => 'Vaïssac',
	'FR82185' => 'Valeilles',
	'FR82186' => 'Valence',
	'FR82187' => 'Varen',
	'FR82188' => 'Varennes',
	'FR82189' => 'Vazerac',
	'FR82190' => 'Verdun-sur-Garonne',
	'FR82191' => 'Verfeil',
	'FR82192' => 'Verlhac-Tescou',
	'FR82193' => 'Vigueron',
	'FR82194' => 'Villebrumier',
	'FR82195' => 'Villemade',
	'FR83001' => 'Les Adrets-de-lEstérel',
	'FR83002' => 'Aiguines',
	'FR83003' => 'Ampus',
	'FR83004' => 'Les Arcs',
	'FR83005' => 'Artignosc-sur-Verdon',
	'FR83006' => 'Artigues',
	'FR83007' => 'Aups',
	'FR83008' => 'Bagnols-en-Forêt',
	'FR83009' => 'Bandol',
	'FR83010' => 'Bargème',
	'FR83011' => 'Bargemon',
	'FR83012' => 'Barjols',
	'FR83013' => 'La Bastide',
	'FR83014' => 'Baudinard-sur-Verdon',
	'FR83015' => 'Bauduen',
	'FR83016' => 'Le Beausset',
	'FR83017' => 'Belgentier',
	'FR83018' => 'Besse-sur-Issole',
	'FR83019' => 'Bormes-les-Mimosas',
	'FR83020' => 'Le Bourguet',
	'FR83021' => 'Bras',
	'FR83022' => 'Brenon',
	'FR83023' => 'Brignoles',
	'FR83025' => 'Brue-Auriac',
	'FR83026' => 'Cabasse',
	'FR83027' => 'La Cadière-dAzur',
	'FR83028' => 'Callas',
	'FR83029' => 'Callian',
	'FR83030' => 'Camps-la-Source',
	'FR83031' => 'Le Cannet-des-Maures',
	'FR83032' => 'Carcès',
	'FR83033' => 'Carnoules',
	'FR83034' => 'Carqueiranne',
	'FR83035' => 'Le Castellet',
	'FR83036' => 'Cavalaire-sur-Mer',
	'FR83037' => 'La Celle',
	'FR83038' => 'Châteaudouble',
	'FR83039' => 'Châteauvert',
	'FR83040' => 'Châteauvieux',
	'FR83041' => 'Claviers',
	'FR83042' => 'Cogolin',
	'FR83043' => 'Collobrières',
	'FR83044' => 'Comps-sur-Artuby',
	'FR83045' => 'Correns',
	'FR83046' => 'Cotignac',
	'FR83047' => 'La Crau',
	'FR83048' => 'La Croix-Valmer',
	'FR83049' => 'Cuers',
	'FR83050' => 'Draguignan',
	'FR83051' => 'Entrecasteaux',
	'FR83052' => 'Esparron',
	'FR83053' => 'Évenos',
	'FR83054' => 'La Farlède',
	'FR83055' => 'Fayence',
	'FR83056' => 'Figanières',
	'FR83057' => 'Flassans-sur-Issole',
	'FR83058' => 'Flayosc',
	'FR83059' => 'Forcalqueiret',
	'FR83060' => 'Fox-Amphoux',
	'FR83061' => 'Fréjus',
	'FR83062' => 'La Garde',
	'FR83063' => 'La Garde-Freinet',
	'FR83064' => 'Garéoult',
	'FR83065' => 'Gassin',
	'FR83066' => 'Ginasservis',
	'FR83067' => 'Gonfaron',
	'FR83068' => 'Grimaud',
	'FR83069' => 'Hyères',
	'FR83070' => 'Le Lavandou',
	'FR83071' => 'La Londe-les-Maures',
	'FR83072' => 'Lorgues',
	'FR83073' => 'Le Luc',
	'FR83074' => 'La Martre',
	'FR83075' => 'Les Mayons',
	'FR83076' => 'Mazaugues',
	'FR83077' => 'Méounes-lès-Montrieux',
	'FR83078' => 'Moissac-Bellevue',
	'FR83079' => 'La Môle',
	'FR83080' => 'Mons',
	'FR83081' => 'Montauroux',
	'FR83082' => 'Montferrat',
	'FR83083' => 'Montfort-sur-Argens',
	'FR83084' => 'Montmeyan',
	'FR83085' => 'La Motte',
	'FR83086' => 'Le Muy',
	'FR83087' => 'Nans-les-Pins',
	'FR83088' => 'Néoules',
	'FR83089' => 'Ollières',
	'FR83090' => 'Ollioules',
	'FR83091' => 'Pierrefeu-du-Var',
	'FR83092' => 'Pignans',
	'FR83093' => 'Plan-dAups-Sainte-Baume',
	'FR83094' => 'Le Plan-de-la-Tour',
	'FR83095' => 'Pontevès',
	'FR83096' => 'Pourcieux',
	'FR83097' => 'Pourrières',
	'FR83098' => 'Le Pradet',
	'FR83099' => 'Puget-sur-Argens',
	'FR83100' => 'Puget-Ville',
	'FR83101' => 'Ramatuelle',
	'FR83102' => 'Régusse',
	'FR83103' => 'Le Revest-les-Eaux',
	'FR83104' => 'Rians',
	'FR83105' => 'Riboux',
	'FR83106' => 'Rocbaron',
	'FR83107' => 'Roquebrune-sur-Argens',
	'FR83108' => 'La Roquebrussanne',
	'FR83109' => 'La Roque-Esclapon',
	'FR83110' => 'Rougiers',
	'FR83111' => 'Sainte-Anastasie-sur-Issole',
	'FR83112' => 'Saint-Cyr-sur-Mer',
	'FR83113' => 'Saint-Julien',
	'FR83114' => 'Saint-Martin-de-Pallières',
	'FR83115' => 'Sainte-Maxime',
	'FR83116' => 'Saint-Maximin-la-Sainte-Baume',
	'FR83117' => 'Saint-Paul-en-Forêt',
	'FR83118' => 'Saint-Raphaël',
	'FR83119' => 'Saint-Tropez',
	'FR83120' => 'Saint-Zacharie',
	'FR83121' => 'Salernes',
	'FR83122' => 'Les Salles-sur-Verdon',
	'FR83123' => 'Sanary-sur-Mer',
	'FR83124' => 'Seillans',
	'FR83125' => 'Seillons-Source-dArgens',
	'FR83126' => 'La Seyne-sur-Mer',
	'FR83127' => 'Signes',
	'FR83128' => 'Sillans-la-Cascade',
	'FR83129' => 'Six-Fours-les-Plages',
	'FR83130' => 'Solliès-Pont',
	'FR83131' => 'Solliès-Toucas',
	'FR83132' => 'Solliès-Ville',
	'FR83133' => 'Tanneron',
	'FR83134' => 'Taradeau',
	'FR83135' => 'Tavernes',
	'FR83136' => 'Le Thoronet',
	'FR83137' => 'Toulon',
	'FR83138' => 'Tourrettes',
	'FR83139' => 'Tourtour',
	'FR83140' => 'Tourves',
	'FR83141' => 'Trans-en-Provence',
	'FR83142' => 'Trigance',
	'FR83143' => 'Le Val',
	'FR83144' => 'La Valette-du-Var',
	'FR83145' => 'Varages',
	'FR83146' => 'La Verdière',
	'FR83147' => 'Vérignon',
	'FR83148' => 'Vidauban',
	'FR83149' => 'Villecroze',
	'FR83150' => 'Vinon-sur-Verdon',
	'FR83151' => 'Vins-sur-Caramy',
	'FR83152' => 'Rayol-Canadel-sur-Mer',
	'FR83153' => 'Saint-Mandrier-sur-Mer',
	'FR83154' => 'Saint-Antonin-du-Var',
	'FR84001' => 'Althen-des-Paluds',
	'FR84002' => 'Ansouis',
	'FR84003' => 'Apt',
	'FR84004' => 'Aubignan',
	'FR84005' => 'Aurel',
	'FR84006' => 'Auribeau',
	'FR84007' => 'Avignon',
	'FR84008' => 'Le Barroux',
	'FR84009' => 'La Bastide-des-Jourdans',
	'FR84010' => 'La Bastidonne',
	'FR84011' => 'Le Beaucet',
	'FR84012' => 'Beaumes-de-Venise',
	'FR84013' => 'Beaumettes',
	'FR84014' => 'Beaumont-de-Pertuis',
	'FR84015' => 'Beaumont-du-Ventoux',
	'FR84016' => 'Bédarrides',
	'FR84017' => 'Bédoin',
	'FR84018' => 'Blauvac',
	'FR84019' => 'Bollène',
	'FR84020' => 'Bonnieux',
	'FR84021' => 'Brantes',
	'FR84022' => 'Buisson',
	'FR84023' => 'Buoux',
	'FR84024' => 'Cabrières-dAigues',
	'FR84025' => 'Cabrières-dAvignon',
	'FR84026' => 'Cadenet',
	'FR84027' => 'Caderousse',
	'FR84028' => 'Cairanne',
	'FR84029' => 'Camaret-sur-Aigues',
	'FR84030' => 'Caromb',
	'FR84031' => 'Carpentras',
	'FR84032' => 'Caseneuve',
	'FR84033' => 'Castellet-en-Luberon',
	'FR84034' => 'Caumont-sur-Durance',
	'FR84035' => 'Cavaillon',
	'FR84036' => 'Châteauneuf-de-Gadagne',
	'FR84037' => 'Châteauneuf-du-Pape',
	'FR84038' => 'Cheval-Blanc',
	'FR84039' => 'Courthézon',
	'FR84040' => 'Crestet',
	'FR84041' => 'Crillon-le-Brave',
	'FR84042' => 'Cucuron',
	'FR84043' => 'Entraigues-sur-la-Sorgue',
	'FR84044' => 'Entrechaux',
	'FR84045' => 'Faucon',
	'FR84046' => 'Flassan',
	'FR84047' => 'Gargas',
	'FR84048' => 'Gignac',
	'FR84049' => 'Gigondas',
	'FR84050' => 'Gordes',
	'FR84051' => 'Goult',
	'FR84052' => 'Grambois',
	'FR84053' => 'Grillon',
	'FR84054' => 'LIsle-sur-la-Sorgue',
	'FR84055' => 'Jonquerettes',
	'FR84056' => 'Jonquières',
	'FR84057' => 'Joucas',
	'FR84058' => 'Lacoste',
	'FR84059' => 'Lafare',
	'FR84060' => 'Lagarde-dApt',
	'FR84061' => 'Lagarde-Paréol',
	'FR84062' => 'Lagnes',
	'FR84063' => 'Lamotte-du-Rhône',
	'FR84064' => 'Lapalud',
	'FR84065' => 'Lauris',
	'FR84066' => 'Lioux',
	'FR84067' => 'Loriol-du-Comtat',
	'FR84068' => 'Lourmarin',
	'FR84069' => 'Malaucène',
	'FR84070' => 'Malemort-du-Comtat',
	'FR84071' => 'Maubec',
	'FR84072' => 'Mazan',
	'FR84073' => 'Ménerbes',
	'FR84074' => 'Mérindol',
	'FR84075' => 'Méthamis',
	'FR84076' => 'Mirabeau',
	'FR84077' => 'Modène',
	'FR84078' => 'Mondragon',
	'FR84079' => 'Monieux',
	'FR84080' => 'Monteux',
	'FR84081' => 'Morières-lès-Avignon',
	'FR84082' => 'Mormoiron',
	'FR84083' => 'Mornas',
	'FR84084' => 'La Motte-dAigues',
	'FR84085' => 'Murs',
	'FR84086' => 'Oppède',
	'FR84087' => 'Orange',
	'FR84088' => 'Pernes-les-Fontaines',
	'FR84089' => 'Pertuis',
	'FR84090' => 'Peypin-dAigues',
	'FR84091' => 'Piolenc',
	'FR84092' => 'Le Pontet',
	'FR84093' => 'Puget',
	'FR84094' => 'Puyméras',
	'FR84095' => 'Puyvert',
	'FR84096' => 'Rasteau',
	'FR84097' => 'Richerenches',
	'FR84098' => 'Roaix',
	'FR84099' => 'Robion',
	'FR84100' => 'La Roque-Alric',
	'FR84101' => 'La Roque-sur-Pernes',
	'FR84102' => 'Roussillon',
	'FR84103' => 'Rustrel',
	'FR84104' => 'Sablet',
	'FR84105' => 'Saignon',
	'FR84106' => 'Sainte-Cécile-les-Vignes',
	'FR84107' => 'Saint-Christol',
	'FR84108' => 'Saint-Didier',
	'FR84109' => 'Saint-Hippolyte-le-Graveyron',
	'FR84110' => 'Saint-Léger-du-Ventoux',
	'FR84111' => 'Saint-Marcellin-lès-Vaison',
	'FR84112' => 'Saint-Martin-de-Castillon',
	'FR84113' => 'Saint-Martin-de-la-Brasque',
	'FR84114' => 'Saint-Pantaléon',
	'FR84115' => 'Saint-Pierre-de-Vassols',
	'FR84116' => 'Saint-Romain-en-Viennois',
	'FR84117' => 'Saint-Roman-de-Malegarde',
	'FR84118' => 'Saint-Saturnin-lès-Apt',
	'FR84119' => 'Saint-Saturnin-lès-Avignon',
	'FR84120' => 'Saint-Trinit',
	'FR84121' => 'Sannes',
	'FR84122' => 'Sarrians',
	'FR84123' => 'Sault',
	'FR84124' => 'Saumane-de-Vaucluse',
	'FR84125' => 'Savoillan',
	'FR84126' => 'Séguret',
	'FR84127' => 'Sérignan-du-Comtat',
	'FR84128' => 'Sivergues',
	'FR84129' => 'Sorgues',
	'FR84130' => 'Suzette',
	'FR84131' => 'Taillades',
	'FR84132' => 'Le Thor',
	'FR84133' => 'La Tour-dAigues',
	'FR84134' => 'Travaillan',
	'FR84135' => 'Uchaux',
	'FR84136' => 'Vacqueyras',
	'FR84137' => 'Vaison-la-Romaine',
	'FR84138' => 'Valréas',
	'FR84139' => 'Fontaine-de-Vaucluse',
	'FR84140' => 'Vaugines',
	'FR84141' => 'Vedène',
	'FR84142' => 'Velleron',
	'FR84143' => 'Venasque',
	'FR84144' => 'Viens',
	'FR84145' => 'Villars',
	'FR84146' => 'Villedieu',
	'FR84147' => 'Villelaure',
	'FR84148' => 'Villes-sur-Auzon',
	'FR84149' => 'Violès',
	'FR84150' => 'Visan',
	'FR84151' => 'Vitrolles-en-Lubéron',
	'FR85001' => 'LAiguillon-sur-Mer',
	'FR85002' => 'LAiguillon-sur-Vie',
	'FR85003' => 'Aizenay',
	'FR85004' => 'Angles',
	'FR85005' => 'Antigny',
	'FR85006' => 'Apremont',
	'FR85008' => 'Aubigny-Les Clouzeaux',
	'FR85009' => 'Auchay-sur-Vendée',
	'FR85010' => 'Avrillé',
	'FR85011' => 'Barbâtre',
	'FR85012' => 'La Barre-de-Monts',
	'FR85013' => 'Bazoges-en-Paillers',
	'FR85014' => 'Bazoges-en-Pareds',
	'FR85015' => 'Beaufou',
	'FR85016' => 'Beaulieu-sous-la-Roche',
	'FR85017' => 'Beaurepaire',
	'FR85018' => 'Beauvoir-sur-Mer',
	'FR85019' => 'Bellevigny',
	'FR85020' => 'Benet',
	'FR85021' => 'La Bernardière',
	'FR85022' => 'Le Bernard',
	'FR85023' => 'Bessay',
	'FR85024' => 'Bois-de-Céné',
	'FR85025' => 'La Boissière-de-Montaigu',
	'FR85026' => 'La Boissière-des-Landes',
	'FR85028' => 'Bouillé-Courdault',
	'FR85029' => 'Bouin',
	'FR85031' => 'Le Boupère',
	'FR85033' => 'Bourneau',
	'FR85034' => 'Bournezeau',
	'FR85035' => 'Bretignolles-sur-Mer',
	'FR85036' => 'La Bretonnière-la-Claye',
	'FR85037' => 'Breuil-Barret',
	'FR85038' => 'Les Brouzils',
	'FR85039' => 'La Bruffière',
	'FR85040' => 'La Caillère-Saint-Hilaire',
	'FR85041' => 'Cezais',
	'FR85042' => 'Chaillé-les-Marais',
	'FR85045' => 'La Chaize-Giraud',
	'FR85046' => 'La Chaize-le-Vicomte',
	'FR85047' => 'Challans',
	'FR85049' => 'Champagné-les-Marais',
	'FR85050' => 'Le Champ-Saint-Père',
	'FR85051' => 'Chantonnay',
	'FR85053' => 'La Chapelle-aux-Lys',
	'FR85054' => 'La Chapelle-Hermier',
	'FR85055' => 'La Chapelle-Palluau',
	'FR85056' => 'La Chapelle-Thémer',
	'FR85058' => 'Chasnais',
	'FR85059' => 'La Châtaigneraie',
	'FR85061' => 'Château-Guibert',
	'FR85062' => 'Châteauneuf',
	'FR85064' => 'Chauché',
	'FR85065' => 'Chavagnes-en-Paillers',
	'FR85066' => 'Chavagnes-les-Redoux',
	'FR85067' => 'Cheffois',
	'FR85070' => 'Coëx',
	'FR85071' => 'Commequiers',
	'FR85072' => 'La Copechagnière',
	'FR85073' => 'Corpe',
	'FR85074' => 'La Couture',
	'FR85076' => 'Cugand',
	'FR85077' => 'Curzon',
	'FR85078' => 'Damvix',
	'FR85080' => 'Doix lès Fontaines',
	'FR85081' => 'Dompierre-sur-Yon',
	'FR85082' => 'Les Epesses',
	'FR85083' => 'LÉpine',
	'FR85084' => 'Essarts en Bocage',
	'FR85086' => 'Falleron',
	'FR85087' => 'Faymoreau',
	'FR85088' => 'Le Fenouiller',
	'FR85089' => 'La Ferrière',
	'FR85090' => 'Sèvremont',
	'FR85092' => 'Fontenay-le-Comte',
	'FR85093' => 'Fougeré',
	'FR85094' => 'Foussais-Payré',
	'FR85095' => 'Froidfond',
	'FR85096' => 'La Garnache',
	'FR85097' => 'La Gaubretière',
	'FR85098' => 'La Genétouze',
	'FR85099' => 'Le Girouard',
	'FR85100' => 'Givrand',
	'FR85101' => 'Le Givre',
	'FR85102' => 'GrandLandes',
	'FR85103' => 'Grosbreuil',
	'FR85104' => 'Grues',
	'FR85105' => 'Le Gué-de-Velluire',
	'FR85106' => 'La Guérinière',
	'FR85108' => 'LHerbergement',
	'FR85109' => 'Les Herbiers',
	'FR85110' => 'LHermenault',
	'FR85111' => 'LÎle-dElle',
	'FR85112' => 'LÎle-dOlonne',
	'FR85113' => 'LÎle-dYeu',
	'FR85114' => 'Jard-sur-Mer',
	'FR85115' => 'La Jaudonnière',
	'FR85116' => 'La Jonchère',
	'FR85117' => 'Lairoux',
	'FR85118' => 'Landeronde',
	'FR85119' => 'Les Landes-Genusson',
	'FR85120' => 'Landevieille',
	'FR85121' => 'Le Langon',
	'FR85123' => 'Liez',
	'FR85125' => 'Loge-Fougereuse',
	'FR85126' => 'Longèves',
	'FR85127' => 'Longeville-sur-Mer',
	'FR85128' => 'Luçon',
	'FR85129' => 'Les Lucs-sur-Boulogne',
	'FR85130' => 'Maché',
	'FR85131' => 'Les Magnils-Reigniers',
	'FR85132' => 'Maillé',
	'FR85133' => 'Maillezais',
	'FR85134' => 'Mallièvre',
	'FR85135' => 'Mareuil-sur-Lay-Dissais',
	'FR85136' => 'Marillet',
	'FR85137' => 'Marsais-Sainte-Radégonde',
	'FR85138' => 'Martinet',
	'FR85139' => 'Le Mazeau',
	'FR85140' => 'La Meilleraie-Tillay',
	'FR85141' => 'Menomblet',
	'FR85142' => 'La Merlatière',
	'FR85143' => 'Mervent',
	'FR85144' => 'Mesnard-la-Barotière',
	'FR85145' => 'Monsireigne',
	'FR85146' => 'Montaigu-Vendée',
	'FR85147' => 'Montournais',
	'FR85148' => 'Montreuil',
	'FR85149' => 'Moreilles',
	'FR85151' => 'Mortagne-sur-Sèvre',
	'FR85152' => 'Les Achards',
	'FR85153' => 'Mouchamps',
	'FR85154' => 'Mouilleron-Saint-Germain',
	'FR85155' => 'Mouilleron-le-Captif',
	'FR85156' => 'Moutiers-les-Mauxfaits',
	'FR85157' => 'Moutiers-sur-le-Lay',
	'FR85158' => 'Mouzeuil-Saint-Martin',
	'FR85159' => 'Nalliers',
	'FR85160' => 'Nesmy',
	'FR85161' => 'Nieul-le-Dolent',
	'FR85162' => 'Rives-dAutise',
	'FR85163' => 'Noirmoutier-en-lÎle',
	'FR85164' => 'Notre-Dame-de-Monts',
	'FR85167' => 'LOrbrie',
	'FR85169' => 'Palluau',
	'FR85171' => 'Péault',
	'FR85172' => 'Le Perrier',
	'FR85174' => 'Petosse',
	'FR85175' => 'Les Pineaux',
	'FR85176' => 'Pissotte',
	'FR85177' => 'Les Velluire-sur-Vendée',
	'FR85178' => 'Le Poiré-sur-Vie',
	'FR85179' => 'Poiroux',
	'FR85181' => 'Pouillé',
	'FR85182' => 'Pouzauges',
	'FR85184' => 'Puy-de-Serre',
	'FR85185' => 'Puyravault',
	'FR85186' => 'La Rabatelière',
	'FR85187' => 'Réaumur',
	'FR85188' => 'La Réorthe',
	'FR85189' => 'Notre-Dame-de-Riez',
	'FR85190' => 'Rocheservière',
	'FR85191' => 'La Roche-sur-Yon',
	'FR85192' => 'Rochetrejoux',
	'FR85193' => 'Rosnay',
	'FR85194' => 'Les Sables-dOlonne',
	'FR85196' => 'Saint-André-Goule-dOie',
	'FR85197' => 'Montréverd',
	'FR85198' => 'Saint-Aubin-des-Ormeaux',
	'FR85199' => 'Saint-Aubin-la-Plaine',
	'FR85200' => 'Saint-Avaugourd-des-Landes',
	'FR85201' => 'Saint-Benoist-sur-Mer',
	'FR85202' => 'Sainte-Cécile',
	'FR85204' => 'Saint-Christophe-du-Ligneron',
	'FR85205' => 'Saint-Cyr-des-Gâts',
	'FR85206' => 'Saint-Cyr-en-Talmondais',
	'FR85207' => 'Saint-Denis-du-Payré',
	'FR85208' => 'Saint-Denis-la-Chevasse',
	'FR85209' => 'Saint-Étienne-de-Brillouet',
	'FR85210' => 'Saint-Étienne-du-Bois',
	'FR85211' => 'Sainte-Flaive-des-Loups',
	'FR85213' => 'Rives de lYon',
	'FR85214' => 'Sainte-Foy',
	'FR85215' => 'Saint-Fulgent',
	'FR85216' => 'Sainte-Gemme-la-Plaine',
	'FR85218' => 'Saint-Georges-de-Pointindoux',
	'FR85220' => 'Saint-Germain-de-Prinçay',
	'FR85221' => 'Saint-Gervais',
	'FR85222' => 'Saint-Gilles-Croix-de-Vie',
	'FR85223' => 'Sainte-Hermine',
	'FR85226' => 'Saint-Hilaire-de-Riez',
	'FR85227' => 'Saint-Hilaire-des-Loges',
	'FR85229' => 'Saint-Hilaire-de-Voust',
	'FR85231' => 'Saint-Hilaire-la-Forêt',
	'FR85232' => 'Saint-Hilaire-le-Vouhis',
	'FR85233' => 'Saint-Jean-de-Beugné',
	'FR85234' => 'Saint-Jean-de-Monts',
	'FR85235' => 'Saint-Juire-Champgillon',
	'FR85236' => 'Saint-Julien-des-Landes',
	'FR85237' => 'Saint-Laurent-de-la-Salle',
	'FR85238' => 'Saint-Laurent-sur-Sèvre',
	'FR85239' => 'Saint-Maixent-sur-Vie',
	'FR85240' => 'Saint-Malô-du-Bois',
	'FR85242' => 'Saint-Mars-la-Réorthe',
	'FR85243' => 'Brem-sur-Mer',
	'FR85244' => 'Saint-Martin-de-Fraigneau',
	'FR85245' => 'Saint-Martin-des-Fontaines',
	'FR85246' => 'Saint-Martin-des-Noyers',
	'FR85247' => 'Saint-Martin-des-Tilleuls',
	'FR85248' => 'Saint-Martin-Lars-en-Sainte-Hermine',
	'FR85250' => 'Saint-Mathurin',
	'FR85251' => 'Saint-Maurice-des-Noues',
	'FR85252' => 'Saint-Maurice-le-Girard',
	'FR85254' => 'Saint-Mesmin',
	'FR85255' => 'Saint-Michel-en-lHerm',
	'FR85256' => 'Saint-Michel-le-Cloucq',
	'FR85259' => 'Saint-Paul-en-Pareds',
	'FR85260' => 'Saint-Paul-Mont-Penit',
	'FR85261' => 'Sainte-Pexine',
	'FR85262' => 'Saint-Philbert-de-Bouaine',
	'FR85264' => 'Saint-Pierre-du-Chemin',
	'FR85265' => 'Saint-Pierre-le-Vieux',
	'FR85266' => 'Saint-Prouant',
	'FR85267' => 'Sainte-Radégonde-des-Noyers',
	'FR85268' => 'Saint-Révérend',
	'FR85269' => 'Saint-Sigismond',
	'FR85271' => 'Saint-Sulpice-en-Pareds',
	'FR85273' => 'Saint-Urbain',
	'FR85274' => 'Saint-Valérien',
	'FR85276' => 'Saint-Vincent-Sterlanges',
	'FR85277' => 'Saint-Vincent-sur-Graon',
	'FR85278' => 'Saint-Vincent-sur-Jard',
	'FR85280' => 'Sallertaine',
	'FR85281' => 'Sérigné',
	'FR85282' => 'Sigournais',
	'FR85284' => 'Soullans',
	'FR85285' => 'Le Tablier',
	'FR85286' => 'La Taillée',
	'FR85287' => 'Tallud-Sainte-Gemme',
	'FR85288' => 'Talmont-Saint-Hilaire',
	'FR85289' => 'La Tardière',
	'FR85290' => 'Thiré',
	'FR85291' => 'Thorigny',
	'FR85292' => 'Thouarsais-Bouildroux',
	'FR85293' => 'Tiffauges',
	'FR85294' => 'La Tranche-sur-Mer',
	'FR85295' => 'Treize-Septiers',
	'FR85296' => 'Treize-Vents',
	'FR85297' => 'Triaize',
	'FR85298' => 'Vairé',
	'FR85300' => 'Venansault',
	'FR85301' => 'Vendrennes',
	'FR85302' => 'Chanverrie',
	'FR85303' => 'Vix',
	'FR85304' => 'Vouillé-les-Marais',
	'FR85305' => 'Vouvant',
	'FR85306' => 'Xanton-Chassenon',
	'FR85307' => 'La Faute-sur-Mer',
	'FR86001' => 'Adriers',
	'FR86002' => 'Amberre',
	'FR86003' => 'Anché',
	'FR86004' => 'Angles-sur-lAnglin',
	'FR86005' => 'Angliers',
	'FR86006' => 'Antigny',
	'FR86007' => 'Antran',
	'FR86008' => 'Arçay',
	'FR86009' => 'Archigny',
	'FR86010' => 'Aslonnes',
	'FR86011' => 'Asnières-sur-Blour',
	'FR86012' => 'Asnois',
	'FR86013' => 'Aulnay',
	'FR86014' => 'Availles-en-Châtellerault',
	'FR86015' => 'Availles-Limouzine',
	'FR86016' => 'Avanton',
	'FR86017' => 'Ayron',
	'FR86018' => 'Basses',
	'FR86019' => 'Beaumont Saint-Cyr',
	'FR86020' => 'Bellefonds',
	'FR86022' => 'Berrie',
	'FR86023' => 'Berthegon',
	'FR86024' => 'Béruges',
	'FR86025' => 'Béthines',
	'FR86026' => 'Beuxes',
	'FR86027' => 'Biard',
	'FR86028' => 'Bignoux',
	'FR86029' => 'Blanzay',
	'FR86031' => 'Bonnes',
	'FR86032' => 'Bonneuil-Matours',
	'FR86034' => 'Bouresse',
	'FR86035' => 'Bourg-Archambault',
	'FR86036' => 'Bournand',
	'FR86037' => 'Brigueil-le-Chantre',
	'FR86038' => 'Brion',
	'FR86039' => 'Brux',
	'FR86040' => 'La Bussière',
	'FR86041' => 'Buxerolles',
	'FR86042' => 'Buxeuil',
	'FR86044' => 'Ceaux-en-Loudun',
	'FR86045' => 'Celle-Lévescault',
	'FR86046' => 'Cenon-sur-Vienne',
	'FR86047' => 'Cernay',
	'FR86048' => 'Chabournay',
	'FR86049' => 'Chalais',
	'FR86050' => 'Chalandray',
	'FR86051' => 'Champagné-le-Sec',
	'FR86052' => 'Champagné-Saint-Hilaire',
	'FR86053' => 'Champigny en Rochereau',
	'FR86054' => 'Champniers',
	'FR86055' => 'La Chapelle-Bâton',
	'FR86058' => 'La Chapelle-Moulière',
	'FR86059' => 'Chapelle-Viviers',
	'FR86061' => 'Charroux',
	'FR86062' => 'Chasseneuil-du-Poitou',
	'FR86063' => 'Chatain',
	'FR86064' => 'Château-Garnier',
	'FR86065' => 'Château-Larcher',
	'FR86066' => 'Châtellerault',
	'FR86068' => 'Chaunay',
	'FR86069' => 'La Chaussée',
	'FR86070' => 'Chauvigny',
	'FR86072' => 'Chenevelles',
	'FR86073' => 'Cherves',
	'FR86074' => 'Chiré-en-Montreuil',
	'FR86075' => 'Chouppes',
	'FR86076' => 'Cissé',
	'FR86077' => 'Civaux',
	'FR86078' => 'Civray',
	'FR86079' => 'La Roche-Rigault',
	'FR86080' => 'Cloué',
	'FR86081' => 'Colombiers',
	'FR86082' => 'Valence-en-Poitou',
	'FR86083' => 'Coulombiers',
	'FR86084' => 'Coulonges',
	'FR86085' => 'Coussay',
	'FR86086' => 'Coussay-les-Bois',
	'FR86087' => 'Craon',
	'FR86088' => 'Croutelle',
	'FR86089' => 'Cuhon',
	'FR86090' => 'Curçay-sur-Dive',
	'FR86091' => 'Curzay-sur-Vonne',
	'FR86092' => 'Dangé-Saint-Romain',
	'FR86093' => 'Dercé',
	'FR86094' => 'Dienné',
	'FR86095' => 'Dissay',
	'FR86096' => 'Doussay',
	'FR86097' => 'La Ferrière-Airoux',
	'FR86098' => 'Fleix',
	'FR86099' => 'Fleuré',
	'FR86100' => 'Fontaine-le-Comte',
	'FR86102' => 'Frozes',
	'FR86103' => 'Gençay',
	'FR86104' => 'Genouillé',
	'FR86105' => 'Gizay',
	'FR86106' => 'Glénouze',
	'FR86107' => 'Gouex',
	'FR86108' => 'La Grimaudière',
	'FR86109' => 'Guesnes',
	'FR86110' => 'Haims',
	'FR86111' => 'Ingrandes',
	'FR86112' => 'LIsle-Jourdain',
	'FR86113' => 'Iteuil',
	'FR86114' => 'Jardres',
	'FR86115' => 'Jaunay-Marigny',
	'FR86116' => 'Jazeneuil',
	'FR86117' => 'Jouhet',
	'FR86118' => 'Journet',
	'FR86119' => 'Joussé',
	'FR86120' => 'Lathus-Saint-Rémy',
	'FR86121' => 'Latillé',
	'FR86122' => 'Lauthiers',
	'FR86123' => 'Boivre-la-Vallée',
	'FR86124' => 'Lavoux',
	'FR86125' => 'Leigné-les-Bois',
	'FR86126' => 'Leignes-sur-Fontaine',
	'FR86127' => 'Leigné-sur-Usseau',
	'FR86128' => 'Lencloître',
	'FR86129' => 'Lésigny',
	'FR86130' => 'Leugny',
	'FR86131' => 'Lhommaizé',
	'FR86132' => 'Liglet',
	'FR86133' => 'Ligugé',
	'FR86134' => 'Linazay',
	'FR86135' => 'Liniers',
	'FR86136' => 'Lizant',
	'FR86137' => 'Loudun',
	'FR86138' => 'Luchapt',
	'FR86139' => 'Lusignan',
	'FR86140' => 'Lussac-les-Châteaux',
	'FR86141' => 'Magné',
	'FR86142' => 'Maillé',
	'FR86143' => 'Mairé',
	'FR86144' => 'Maisonneuve',
	'FR86145' => 'Marçay',
	'FR86147' => 'Marigny-Chemereau',
	'FR86148' => 'Marnay',
	'FR86149' => 'Martaizé',
	'FR86150' => 'Massognes',
	'FR86151' => 'Maulay',
	'FR86152' => 'Mauprévoir',
	'FR86153' => 'Mazerolles',
	'FR86154' => 'Mazeuil',
	'FR86156' => 'Messemé',
	'FR86157' => 'Mignaloux-Beauvoir',
	'FR86158' => 'Migné-Auxances',
	'FR86159' => 'Millac',
	'FR86160' => 'Mirebeau',
	'FR86161' => 'Moncontour',
	'FR86162' => 'Mondion',
	'FR86163' => 'Montamisé',
	'FR86164' => 'Monthoiron',
	'FR86165' => 'Montmorillon',
	'FR86167' => 'Monts-sur-Guesnes',
	'FR86169' => 'Morton',
	'FR86170' => 'Moulismes',
	'FR86171' => 'Moussac',
	'FR86172' => 'Mouterre-sur-Blourde',
	'FR86173' => 'Mouterre-Silly',
	'FR86174' => 'Naintré',
	'FR86175' => 'Nalliers',
	'FR86176' => 'Nérignac',
	'FR86177' => 'Neuville-de-Poitou',
	'FR86178' => 'Nieuil-lEspoir',
	'FR86180' => 'Nouaillé-Maupertuis',
	'FR86181' => 'Nueil-sous-Faye',
	'FR86182' => 'Orches',
	'FR86183' => 'Les Ormes',
	'FR86184' => 'Ouzilly',
	'FR86186' => 'Oyré',
	'FR86187' => 'Paizay-le-Sec',
	'FR86189' => 'Payroux',
	'FR86190' => 'Persac',
	'FR86191' => 'Pindray',
	'FR86192' => 'Plaisance',
	'FR86193' => 'Pleumartin',
	'FR86194' => 'Poitiers',
	'FR86195' => 'Port-de-Piles',
	'FR86196' => 'Pouançay',
	'FR86197' => 'Pouant',
	'FR86198' => 'Pouillé',
	'FR86200' => 'Pressac',
	'FR86201' => 'Prinçay',
	'FR86202' => 'La Puye',
	'FR86203' => 'Queaux',
	'FR86204' => 'Quinçay',
	'FR86205' => 'Ranton',
	'FR86206' => 'Raslay',
	'FR86207' => 'La Roche-Posay',
	'FR86209' => 'Roches-Prémarie-Andillé',
	'FR86210' => 'Roiffé',
	'FR86211' => 'Romagne',
	'FR86213' => 'Rouillé',
	'FR86214' => 'Saint-Benoît',
	'FR86217' => 'Saint-Christophe',
	'FR86218' => 'Saint-Clair',
	'FR86220' => 'Saint-Gaudent',
	'FR86221' => 'Saint-Genest-dAmbière',
	'FR86222' => 'Saint-Georges-lès-Baillargeaux',
	'FR86223' => 'Saint-Germain',
	'FR86224' => 'Saint-Gervais-les-Trois-Clochers',
	'FR86225' => 'Saint-Jean-de-Sauves',
	'FR86226' => 'Saint-Julien-lArs',
	'FR86227' => 'Saint-Laon',
	'FR86228' => 'Saint-Laurent-de-Jourdes',
	'FR86229' => 'Saint-Léger-de-Montbrillais',
	'FR86230' => 'Saint-Léomer',
	'FR86231' => 'Saint-Macoux',
	'FR86233' => 'Valdivienne',
	'FR86234' => 'Saint-Martin-lArs',
	'FR86235' => 'Saint-Maurice-la-Clouère',
	'FR86236' => 'Saint-Pierre-de-Maillé',
	'FR86237' => 'Saint-Pierre-dExideuil',
	'FR86239' => 'Sainte-Radégonde',
	'FR86241' => 'Saint-Rémy-sur-Creuse',
	'FR86242' => 'Saint-Romain',
	'FR86244' => 'Saint-Sauvant',
	'FR86245' => 'Senillé-Saint-Sauveur',
	'FR86246' => 'Saint-Savin',
	'FR86247' => 'Saint-Saviol',
	'FR86248' => 'Saint-Secondin',
	'FR86249' => 'Saires',
	'FR86250' => 'Saix',
	'FR86252' => 'Sammarçolles',
	'FR86253' => 'Sanxay',
	'FR86254' => 'Saulgé',
	'FR86255' => 'Savigné',
	'FR86256' => 'Savigny-Lévescault',
	'FR86257' => 'Savigny-sous-Faye',
	'FR86258' => 'Scorbé-Clairvaux',
	'FR86260' => 'Sérigny',
	'FR86261' => 'Sèvres-Anxaumont',
	'FR86262' => 'Sillars',
	'FR86263' => 'Smarves',
	'FR86264' => 'Sommières-du-Clain',
	'FR86265' => 'Sossais',
	'FR86266' => 'Surin',
	'FR86268' => 'Tercé',
	'FR86269' => 'Ternay',
	'FR86270' => 'Thollet',
	'FR86271' => 'Thurageau',
	'FR86272' => 'Thuré',
	'FR86273' => 'La Trimouille',
	'FR86274' => 'Les Trois-Moutiers',
	'FR86275' => 'Usseau',
	'FR86276' => 'Usson-du-Poitou',
	'FR86279' => 'Vaux-sur-Vienne',
	'FR86280' => 'Vellèches',
	'FR86281' => 'Saint-Martin-la-Pallu',
	'FR86284' => 'Vernon',
	'FR86285' => 'Verrières',
	'FR86286' => 'Verrue',
	'FR86287' => 'Vézières',
	'FR86288' => 'Vicq-sur-Gartempe',
	'FR86289' => 'Le Vigeant',
	'FR86290' => 'La Villedieu-du-Clain',
	'FR86291' => 'Villemort',
	'FR86292' => 'Villiers',
	'FR86293' => 'Vivonne',
	'FR86294' => 'Vouillé',
	'FR86295' => 'Voulême',
	'FR86296' => 'Voulon',
	'FR86297' => 'Vouneuil-sous-Biard',
	'FR86298' => 'Vouneuil-sur-Vienne',
	'FR86299' => 'Vouzailles',
	'FR86300' => 'Yversay',
	'FR87001' => 'Aixe-sur-Vienne',
	'FR87002' => 'Ambazac',
	'FR87003' => 'Arnac-la-Poste',
	'FR87004' => 'Augne',
	'FR87005' => 'Aureil',
	'FR87006' => 'Azat-le-Ris',
	'FR87007' => 'Balledent',
	'FR87008' => 'La Bazeuge',
	'FR87009' => 'Beaumont-du-Lac',
	'FR87011' => 'Bellac',
	'FR87012' => 'Berneuil',
	'FR87013' => 'Bersac-sur-Rivalier',
	'FR87014' => 'Bessines-sur-Gartempe',
	'FR87015' => 'Beynac',
	'FR87016' => 'Les Billanges',
	'FR87017' => 'Blanzac',
	'FR87018' => 'Blond',
	'FR87019' => 'Boisseuil',
	'FR87020' => 'Bonnac-la-Côte',
	'FR87021' => 'Bosmie-lAiguille',
	'FR87022' => 'Breuilaufa',
	'FR87023' => 'Le Buis',
	'FR87024' => 'Bujaleuf',
	'FR87025' => 'Burgnac',
	'FR87027' => 'Bussière-Galant',
	'FR87028' => 'Val-dOire-et-Gartempe',
	'FR87029' => 'Les Cars',
	'FR87030' => 'Chaillac-sur-Vienne',
	'FR87031' => 'Le Chalard',
	'FR87032' => 'Châlus',
	'FR87033' => 'Chamboret',
	'FR87034' => 'Champagnac-la-Rivière',
	'FR87035' => 'Champnétery',
	'FR87036' => 'Champsac',
	'FR87037' => 'La Chapelle-Montbrandeix',
	'FR87038' => 'Chaptelat',
	'FR87039' => 'Château-Chervix',
	'FR87040' => 'Châteauneuf-la-Forêt',
	'FR87041' => 'Châteauponsac',
	'FR87042' => 'Le Châtenet-en-Dognon',
	'FR87043' => 'Cheissoux',
	'FR87044' => 'Chéronnac',
	'FR87045' => 'Cieux',
	'FR87046' => 'Cognac-la-Forêt',
	'FR87047' => 'Compreignac',
	'FR87048' => 'Condat-sur-Vienne',
	'FR87049' => 'Coussac-Bonneval',
	'FR87050' => 'Couzeix',
	'FR87051' => 'La Croisille-sur-Briance',
	'FR87052' => 'La Croix-sur-Gartempe',
	'FR87053' => 'Cromac',
	'FR87054' => 'Cussac',
	'FR87056' => 'Dinsac',
	'FR87057' => 'Dompierre-les-Églises',
	'FR87058' => 'Domps',
	'FR87059' => 'Le Dorat',
	'FR87060' => 'Dournazac',
	'FR87061' => 'Droux',
	'FR87062' => 'Eybouleuf',
	'FR87063' => 'Eyjeaux',
	'FR87064' => 'Eymoutiers',
	'FR87065' => 'Feytiat',
	'FR87066' => 'Flavignac',
	'FR87067' => 'Folles',
	'FR87068' => 'Fromental',
	'FR87069' => 'Gajoubert',
	'FR87070' => 'La Geneytouse',
	'FR87071' => 'Glandon',
	'FR87072' => 'Glanges',
	'FR87073' => 'Gorre',
	'FR87074' => 'Les Grands-Chézeaux',
	'FR87075' => 'Isle',
	'FR87076' => 'Jabreilles-les-Bordes',
	'FR87077' => 'Janailhac',
	'FR87078' => 'Javerdat',
	'FR87079' => 'La Jonchère-Saint-Maurice',
	'FR87080' => 'Jouac',
	'FR87081' => 'Jourgnac',
	'FR87082' => 'Ladignac-le-Long',
	'FR87083' => 'Laurière',
	'FR87084' => 'Lavignac',
	'FR87085' => 'Limoges',
	'FR87086' => 'Linards',
	'FR87087' => 'Lussac-les-Églises',
	'FR87088' => 'Magnac-Bourg',
	'FR87089' => 'Magnac-Laval',
	'FR87090' => 'Mailhac-sur-Benaize',
	'FR87091' => 'Maisonnais-sur-Tardoire',
	'FR87092' => 'Marval',
	'FR87093' => 'Masléon',
	'FR87094' => 'Meilhac',
	'FR87095' => 'Meuzac',
	'FR87096' => 'La Meyze',
	'FR87097' => 'Val dIssoire',
	'FR87099' => 'Moissannes',
	'FR87100' => 'Montrol-Sénard',
	'FR87101' => 'Mortemart',
	'FR87103' => 'Nantiat',
	'FR87104' => 'Nedde',
	'FR87105' => 'Neuvic-Entier',
	'FR87106' => 'Nexon',
	'FR87107' => 'Nieul',
	'FR87108' => 'Nouic',
	'FR87109' => 'Oradour-Saint-Genest',
	'FR87110' => 'Oradour-sur-Glane',
	'FR87111' => 'Oradour-sur-Vayres',
	'FR87112' => 'Pageas',
	'FR87113' => 'Le Palais-sur-Vienne',
	'FR87114' => 'Panazol',
	'FR87115' => 'Pensol',
	'FR87116' => 'Peyrat-de-Bellac',
	'FR87117' => 'Peyrat-le-Château',
	'FR87118' => 'Peyrilhac',
	'FR87119' => 'Pierre-Buffière',
	'FR87120' => 'La Porcherie',
	'FR87121' => 'Rancon',
	'FR87122' => 'Razès',
	'FR87123' => 'Rempnat',
	'FR87124' => 'Rilhac-Lastours',
	'FR87125' => 'Rilhac-Rancon',
	'FR87126' => 'Rochechouart',
	'FR87127' => 'La Roche-lAbeille',
	'FR87128' => 'Saint-Pardoux-le-Lac',
	'FR87129' => 'Royères',
	'FR87130' => 'Roziers-Saint-Georges',
	'FR87131' => 'Saillat-sur-Vienne',
	'FR87132' => 'Saint-Amand-le-Petit',
	'FR87133' => 'Saint-Amand-Magnazeix',
	'FR87134' => 'Sainte-Anne-Saint-Priest',
	'FR87135' => 'Saint-Auvent',
	'FR87137' => 'Saint-Bazile',
	'FR87138' => 'Saint-Bonnet-Briance',
	'FR87139' => 'Saint-Bonnet-de-Bellac',
	'FR87140' => 'Saint-Brice-sur-Vienne',
	'FR87141' => 'Saint-Cyr',
	'FR87142' => 'Saint-Denis-des-Murs',
	'FR87143' => 'Saint-Gence',
	'FR87144' => 'Saint-Genest-sur-Roselle',
	'FR87145' => 'Saint-Georges-les-Landes',
	'FR87146' => 'Saint-Germain-les-Belles',
	'FR87147' => 'Saint-Gilles-les-Forêts',
	'FR87148' => 'Saint-Hilaire-Bonneval',
	'FR87149' => 'Saint-Hilaire-la-Treille',
	'FR87150' => 'Saint-Hilaire-les-Places',
	'FR87151' => 'Saint-Jean-Ligoure',
	'FR87152' => 'Saint-Jouvent',
	'FR87153' => 'Saint-Julien-le-Petit',
	'FR87154' => 'Saint-Junien',
	'FR87155' => 'Saint-Junien-les-Combes',
	'FR87156' => 'Saint-Just-le-Martel',
	'FR87157' => 'Saint-Laurent-les-Églises',
	'FR87158' => 'Saint-Laurent-sur-Gorre',
	'FR87159' => 'Saint-Léger-la-Montagne',
	'FR87160' => 'Saint-Léger-Magnazeix',
	'FR87161' => 'Saint-Léonard-de-Noblat',
	'FR87162' => 'Sainte-Marie-de-Vaux',
	'FR87163' => 'Saint-Martial-sur-Isop',
	'FR87164' => 'Saint-Martin-de-Jussac',
	'FR87165' => 'Saint-Martin-le-Mault',
	'FR87166' => 'Saint-Martin-le-Vieux',
	'FR87167' => 'Saint-Martin-Terressus',
	'FR87168' => 'Saint-Mathieu',
	'FR87169' => 'Saint-Maurice-les-Brousses',
	'FR87170' => 'Saint-Méard',
	'FR87172' => 'Saint-Ouen-sur-Gartempe',
	'FR87174' => 'Saint-Paul',
	'FR87176' => 'Saint-Priest-Ligoure',
	'FR87177' => 'Saint-Priest-sous-Aixe',
	'FR87178' => 'Saint-Priest-Taurion',
	'FR87179' => 'Saint-Sornin-la-Marche',
	'FR87180' => 'Saint-Sornin-Leulac',
	'FR87181' => 'Saint-Sulpice-Laurière',
	'FR87182' => 'Saint-Sulpice-les-Feuilles',
	'FR87183' => 'Saint-Sylvestre',
	'FR87185' => 'Saint-Victurnien',
	'FR87186' => 'Saint-Vitte-sur-Briance',
	'FR87187' => 'Saint-Yrieix-la-Perche',
	'FR87188' => 'Saint-Yrieix-sous-Aixe',
	'FR87189' => 'Les Salles-Lavauguyon',
	'FR87190' => 'Sauviat-sur-Vige',
	'FR87191' => 'Séreilhac',
	'FR87192' => 'Solignac',
	'FR87193' => 'Surdoux',
	'FR87194' => 'Sussac',
	'FR87195' => 'Tersannes',
	'FR87197' => 'Thouron',
	'FR87198' => 'Vaulry',
	'FR87199' => 'Vayres',
	'FR87200' => 'Verneuil-Moustiers',
	'FR87201' => 'Verneuil-sur-Vienne',
	'FR87202' => 'Veyrac',
	'FR87203' => 'Vicq-sur-Breuilh',
	'FR87204' => 'Videix',
	'FR87205' => 'Le Vigen',
	'FR87206' => 'Villefavard',
	'FR88001' => 'Les Ableuvenettes',
	'FR88002' => 'Ahéville',
	'FR88003' => 'Aingeville',
	'FR88004' => 'Ainvelle',
	'FR88005' => 'Allarmont',
	'FR88006' => 'Ambacourt',
	'FR88007' => 'Ameuvelle',
	'FR88008' => 'Anglemont',
	'FR88009' => 'Anould',
	'FR88010' => 'Aouze',
	'FR88011' => 'Arches',
	'FR88012' => 'Archettes',
	'FR88013' => 'Aroffe',
	'FR88014' => 'Arrentès-de-Corcieux',
	'FR88015' => 'Attignéville',
	'FR88016' => 'Attigny',
	'FR88017' => 'Aulnois',
	'FR88019' => 'Autigny-la-Tour',
	'FR88020' => 'Autreville',
	'FR88021' => 'Autrey',
	'FR88022' => 'Auzainvilliers',
	'FR88023' => 'Avillers',
	'FR88024' => 'Avrainville',
	'FR88025' => 'Avranville',
	'FR88026' => 'Aydoilles',
	'FR88027' => 'Badménil-aux-Bois',
	'FR88028' => 'La Baffe',
	'FR88029' => 'La Vôge-les-Bains',
	'FR88030' => 'Bainville-aux-Saules',
	'FR88031' => 'Balléville',
	'FR88032' => 'Ban-de-Laveline',
	'FR88033' => 'Ban-de-Sapt',
	'FR88035' => 'Barbey-Seroux',
	'FR88036' => 'Barville',
	'FR88037' => 'Basse-sur-le-Rupt',
	'FR88038' => 'Battexey',
	'FR88039' => 'Baudricourt',
	'FR88040' => 'Bayecourt',
	'FR88041' => 'Bazegney',
	'FR88042' => 'Bazien',
	'FR88043' => 'Bazoilles-et-Ménil',
	'FR88044' => 'Bazoilles-sur-Meuse',
	'FR88045' => 'Beaufremont',
	'FR88046' => 'Beauménil',
	'FR88047' => 'Begnécourt',
	'FR88048' => 'Bellefontaine',
	'FR88049' => 'Belmont-lès-Darney',
	'FR88050' => 'Belmont-sur-Buttant',
	'FR88051' => 'Belmont-sur-Vair',
	'FR88052' => 'Belrupt',
	'FR88053' => 'Belval',
	'FR88054' => 'Bertrimoutier',
	'FR88055' => 'Bettegney-Saint-Brice',
	'FR88056' => 'Bettoncourt',
	'FR88057' => 'Le Beulay',
	'FR88058' => 'Biécourt',
	'FR88059' => 'Biffontaine',
	'FR88060' => 'Blémerey',
	'FR88061' => 'Bleurville',
	'FR88062' => 'Blevaincourt',
	'FR88063' => 'Bocquegney',
	'FR88064' => 'Bois-de-Champ',
	'FR88065' => 'Bonvillet',
	'FR88066' => 'Boulaincourt',
	'FR88068' => 'La Bourgonce',
	'FR88069' => 'Bouxières-aux-Bois',
	'FR88070' => 'Bouxurulles',
	'FR88071' => 'Bouzemont',
	'FR88073' => 'Brantigny',
	'FR88074' => 'Brechainville',
	'FR88075' => 'La Bresse',
	'FR88076' => 'Brouvelieures',
	'FR88077' => 'Brû',
	'FR88078' => 'Bruyères',
	'FR88079' => 'Bulgnéville',
	'FR88080' => 'Bult',
	'FR88081' => 'Bussang',
	'FR88082' => 'Celles-sur-Plaine',
	'FR88083' => 'Certilleux',
	'FR88084' => 'Chamagne',
	'FR88085' => 'Champdray',
	'FR88086' => 'Champ-le-Duc',
	'FR88087' => 'Chantraine',
	'FR88088' => 'La Chapelle-aux-Bois',
	'FR88089' => 'La Chapelle-devant-Bruyères',
	'FR88090' => 'Charmes',
	'FR88091' => 'Charmois-devant-Bruyères',
	'FR88092' => 'Charmois-lOrgueilleux',
	'FR88093' => 'Châtas',
	'FR88094' => 'Châtel-sur-Moselle',
	'FR88095' => 'Châtenois',
	'FR88096' => 'Châtillon-sur-Saône',
	'FR88097' => 'Chauffecourt',
	'FR88098' => 'Chaumousey',
	'FR88099' => 'Chavelot',
	'FR88100' => 'Chef-Haut',
	'FR88101' => 'Cheniménil',
	'FR88102' => 'Chermisey',
	'FR88103' => 'Circourt',
	'FR88104' => 'Circourt-sur-Mouzon',
	'FR88105' => 'Claudon',
	'FR88106' => 'Ban-sur-Meurthe-Clefcy',
	'FR88107' => 'Clérey-la-Côte',
	'FR88108' => 'Le Clerjus',
	'FR88109' => 'Cleurie',
	'FR88110' => 'Clézentaine',
	'FR88111' => 'Coinches',
	'FR88113' => 'Combrimont',
	'FR88114' => 'Contrexéville',
	'FR88115' => 'Corcieux',
	'FR88116' => 'Cornimont',
	'FR88117' => 'Courcelles-sous-Châtenois',
	'FR88118' => 'Coussey',
	'FR88119' => 'Crainvilliers',
	'FR88120' => 'La Croix-aux-Mines',
	'FR88121' => 'Damas-aux-Bois',
	'FR88122' => 'Damas-et-Bettegney',
	'FR88123' => 'Damblain',
	'FR88124' => 'Darney',
	'FR88125' => 'Darney-aux-Chênes',
	'FR88126' => 'Darnieulles',
	'FR88127' => 'Deinvillers',
	'FR88128' => 'Denipaire',
	'FR88129' => 'Derbamont',
	'FR88130' => 'Destord',
	'FR88131' => 'Deycimont',
	'FR88132' => 'Deyvillers',
	'FR88133' => 'Dignonville',
	'FR88134' => 'Dinozé',
	'FR88135' => 'Docelles',
	'FR88136' => 'Dogneville',
	'FR88137' => 'Dolaincourt',
	'FR88138' => 'Dombasle-devant-Darney',
	'FR88139' => 'Dombasle-en-Xaintois',
	'FR88140' => 'Dombrot-le-Sec',
	'FR88141' => 'Dombrot-sur-Vair',
	'FR88142' => 'Domèvre-sur-Avière',
	'FR88143' => 'Domèvre-sur-Durbion',
	'FR88144' => 'Domèvre-sous-Montfort',
	'FR88145' => 'Domfaing',
	'FR88146' => 'Domjulien',
	'FR88147' => 'Dommartin-aux-Bois',
	'FR88148' => 'Dommartin-lès-Remiremont',
	'FR88149' => 'Dommartin-lès-Vallois',
	'FR88150' => 'Dommartin-sur-Vraine',
	'FR88151' => 'Dompaire',
	'FR88152' => 'Dompierre',
	'FR88153' => 'Domptail',
	'FR88154' => 'Domrémy-la-Pucelle',
	'FR88155' => 'Domvallier',
	'FR88156' => 'Doncières',
	'FR88157' => 'Dounoux',
	'FR88158' => 'Éloyes',
	'FR88159' => 'Entre-deux-Eaux',
	'FR88160' => 'Épinal',
	'FR88161' => 'Escles',
	'FR88162' => 'Esley',
	'FR88163' => 'Essegney',
	'FR88164' => 'Estrennes',
	'FR88165' => 'Étival-Clairefontaine',
	'FR88166' => 'Évaux-et-Ménil',
	'FR88167' => 'Faucompierre',
	'FR88168' => 'Fauconcourt',
	'FR88169' => 'Fays',
	'FR88170' => 'Ferdrupt',
	'FR88171' => 'Fignévelle',
	'FR88172' => 'Fiménil',
	'FR88173' => 'Florémont',
	'FR88174' => 'Fomerey',
	'FR88175' => 'Fontenay',
	'FR88176' => 'Fontenoy-le-Château',
	'FR88177' => 'La Forge',
	'FR88178' => 'Les Forges',
	'FR88179' => 'Fouchécourt',
	'FR88180' => 'Frain',
	'FR88181' => 'Fraize',
	'FR88182' => 'Frapelle',
	'FR88183' => 'Frebécourt',
	'FR88184' => 'Fremifontaine',
	'FR88185' => 'Frenelle-la-Grande',
	'FR88186' => 'Frenelle-la-Petite',
	'FR88187' => 'Frénois',
	'FR88188' => 'Fresse-sur-Moselle',
	'FR88189' => 'Fréville',
	'FR88190' => 'Frizon',
	'FR88192' => 'Gelvécourt-et-Adompt',
	'FR88193' => 'Gemaingoutte',
	'FR88194' => 'Gemmelaincourt',
	'FR88195' => 'Gendreville',
	'FR88196' => 'Gérardmer',
	'FR88197' => 'Gerbamont',
	'FR88198' => 'Gerbépal',
	'FR88199' => 'Gignéville',
	'FR88200' => 'Gigney',
	'FR88201' => 'Girancourt',
	'FR88202' => 'Gircourt-lès-Viéville',
	'FR88203' => 'Girecourt-sur-Durbion',
	'FR88205' => 'Girmont-Val-dAjol',
	'FR88206' => 'Gironcourt-sur-Vraine',
	'FR88208' => 'Godoncourt',
	'FR88209' => 'Golbey',
	'FR88210' => 'Gorhey',
	'FR88212' => 'Grand',
	'FR88213' => 'La Grande-Fosse',
	'FR88214' => 'Grandrupt-de-Bains',
	'FR88215' => 'Grandrupt',
	'FR88216' => 'Grandvillers',
	'FR88218' => 'Granges-Aumontzey',
	'FR88219' => 'Greux',
	'FR88220' => 'Grignoncourt',
	'FR88221' => 'Gruey-lès-Surance',
	'FR88222' => 'Gugnécourt',
	'FR88223' => 'Gugney-aux-Aulx',
	'FR88224' => 'Hadigny-les-Verrières',
	'FR88225' => 'Hadol',
	'FR88226' => 'Hagécourt',
	'FR88227' => 'Hagnéville-et-Roncourt',
	'FR88228' => 'Haillainville',
	'FR88229' => 'Harchéchamp',
	'FR88230' => 'Hardancourt',
	'FR88231' => 'Haréville',
	'FR88232' => 'Harmonville',
	'FR88233' => 'Harol',
	'FR88236' => 'La Haye',
	'FR88237' => 'Hennecourt',
	'FR88238' => 'Hennezel',
	'FR88239' => 'Hergugney',
	'FR88240' => 'Herpelmont',
	'FR88241' => 'Houécourt',
	'FR88242' => 'Houéville',
	'FR88243' => 'Housseras',
	'FR88244' => 'La Houssière',
	'FR88245' => 'Hurbache',
	'FR88246' => 'Hymont',
	'FR88247' => 'Igney',
	'FR88248' => 'Isches',
	'FR88249' => 'Jainvillotte',
	'FR88250' => 'Jarménil',
	'FR88251' => 'Jeanménil',
	'FR88252' => 'Jésonville',
	'FR88253' => 'Jeuxey',
	'FR88254' => 'Jorxey',
	'FR88255' => 'Jubainville',
	'FR88256' => 'Jussarupt',
	'FR88257' => 'Juvaincourt',
	'FR88258' => 'Lamarche',
	'FR88259' => 'Landaville',
	'FR88260' => 'Langley',
	'FR88261' => 'Laval-sur-Vologne',
	'FR88262' => 'Laveline-devant-Bruyères',
	'FR88263' => 'Laveline-du-Houx',
	'FR88264' => 'Légéville-et-Bonfays',
	'FR88265' => 'Lemmecourt',
	'FR88266' => 'Lépanges-sur-Vologne',
	'FR88267' => 'Lerrain',
	'FR88268' => 'Lesseux',
	'FR88269' => 'Liézey',
	'FR88270' => 'Liffol-le-Grand',
	'FR88271' => 'Lignéville',
	'FR88272' => 'Lironcourt',
	'FR88273' => 'Longchamp',
	'FR88274' => 'Longchamp-sous-Châtenois',
	'FR88275' => 'Lubine',
	'FR88276' => 'Lusse',
	'FR88277' => 'Luvigny',
	'FR88278' => 'Maconcourt',
	'FR88279' => 'Madecourt',
	'FR88280' => 'Madegney',
	'FR88281' => 'Madonne-et-Lamerey',
	'FR88283' => 'Malaincourt',
	'FR88284' => 'Mandray',
	'FR88285' => 'Mandres-sur-Vair',
	'FR88286' => 'Marainville-sur-Madon',
	'FR88287' => 'Marey',
	'FR88288' => 'Maroncourt',
	'FR88289' => 'Martigny-les-Bains',
	'FR88290' => 'Martigny-les-Gerbonvaux',
	'FR88291' => 'Martinvelle',
	'FR88292' => 'Mattaincourt',
	'FR88293' => 'Maxey-sur-Meuse',
	'FR88294' => 'Mazeley',