<?php

/**
 * List of cities for: Spain
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'ES01059' => 'Vitoria-Gasteiz',
	'ES02003' => 'Albacete',
	'ES03009' => 'Alcoi',
	'ES03014' => 'Alacant',
	'ES03031' => 'Benidorm',
	'ES03065' => 'Elx',
	'ES03066' => 'Elda',
	'ES03099' => 'Orihuela',
	'ES03122' => 'Sant Vicent del Raspeig',
	'ES03133' => 'Torrevieja',
	'ES04013' => 'Almería',
	'ES04079' => 'Roquetas de Mar',
	'ES04902' => 'Ejido, El',
	'ES05019' => 'Ávila',
	'ES06015' => 'Badajoz',
	'ES06083' => 'Mérida',
	'ES07011' => 'Calvià',
	'ES07040' => 'Palma',
	'ES08015' => 'Badalona',
	'ES08019' => 'Barcelona',
	'ES08056' => 'Castelldefels',
	'ES08073' => 'Cornellà de Llobregat',
	'ES08096' => 'Granollers',
	'ES08101' => 'Hospitalet de Llobregat, L',
	'ES08113' => 'Manresa',
	'ES08121' => 'Mataró',
	'ES08124' => 'Mollet del Vallès',
	'ES08169' => 'Prat de Llobregat, El',
	'ES08184' => 'Rubí',
	'ES08187' => 'Sabadell',
	'ES08200' => 'Sant Boi de Llobregat',
	'ES08205' => 'Sant Cugat del Vallès',
	'ES08245' => 'Santa Coloma de Gramenet',
	'ES08266' => 'Cerdanyola del Vallès',
	'ES08279' => 'Terrassa',
	'ES08301' => 'Viladecans',
	'ES08307' => 'Vilanova i la Geltrú',
	'ES09059' => 'Burgos',
	'ES10037' => 'Cáceres',
	'ES11004' => 'Algeciras',
	'ES11012' => 'Cádiz',
	'ES11015' => 'Chiclana de la Frontera',
	'ES11020' => 'Jerez de la Frontera',
	'ES11022' => 'Línea de la Concepción, La',
	'ES11027' => 'Puerto de Santa María, El',
	'ES11031' => 'San Fernando',
	'ES11032' => 'Sanlúcar de Barrameda',
	'ES12040' => 'Castelló de la Plana',
	'ES12135' => 'Vila-real',
	'ES13034' => 'Ciudad Real',
	'ES14021' => 'Córdoba',
	'ES15030' => 'Coruña, A',
	'ES15036' => 'Ferrol',
	'ES15078' => 'Santiago de Compostela',
	'ES16078' => 'Cuenca',
	'ES17079' => 'Girona',
	'ES18087' => 'Granada',
	'ES18140' => 'Motril',
	'ES19130' => 'Guadalajara',
	'ES20045' => 'Irun',
	'ES20069' => 'San Sebastián',
	'ES21041' => 'Huelva',
	'ES22125' => 'Huesca',
	'ES23050' => 'Jaén',
	'ES23055' => 'Linares',
	'ES24089' => 'León',
	'ES24115' => 'Ponferrada',
	'ES25120' => 'Lleida',
	'ES26089' => 'Logroño',
	'ES27028' => 'Lugo',
	'ES28005' => 'Alcalá de Henares',
	'ES28006' => 'Alcobendas',
	'ES28007' => 'Alcorcón',
	'ES28013' => 'Aranjuez',
	'ES28014' => 'Arganda del Rey',
	'ES28022' => 'Boadilla del Monte',
	'ES28045' => 'Colmenar Viejo',
	'ES28047' => 'Collado Villalba',
	'ES28049' => 'Coslada',
	'ES28058' => 'Fuenlabrada',
	'ES28065' => 'Getafe',
	'ES28074' => 'Leganés',
	'ES28079' => 'Madrid',
	'ES28080' => 'Majadahonda',
	'ES28092' => 'Móstoles',
	'ES28106' => 'Parla',
	'ES28113' => 'Pinto',
	'ES28115' => 'Pozuelo de Alarcón',
	'ES28123' => 'Rivas-Vaciamadrid',
	'ES28127' => 'Rozas de Madrid, Las',
	'ES28134' => 'San Sebastián de los Reyes',
	'ES28148' => 'Torrejón de Ardoz',
	'ES28161' => 'Valdemoro',
	'ES29025' => 'Benalmádena',
	'ES29051' => 'Estepona',
	'ES29054' => 'Fuengirola',
	'ES29067' => 'Málaga',
	'ES29069' => 'Marbella',
	'ES29070' => 'Mijas',
	'ES29094' => 'Vélez-Málaga',
	'ES29901' => 'Torremolinos',
	'ES30016' => 'Cartagena',
	'ES30024' => 'Lorca',
	'ES30027' => 'Molina de Segura',
	'ES30030' => 'Murcia',
	'ES31201' => 'Iruña',
	'ES32054' => 'Ourense',
	'ES33004' => 'Avilés',
	'ES33024' => 'Gijón',
	'ES33044' => 'Oviedo',
	'ES33066' => 'Siero',
	'ES34120' => 'Palencia',
	'ES35004' => 'Arrecife',
	'ES35016' => 'Palmas de Gran Canaria, Las',
	'ES35019' => 'San Bartolomé de Tirajana',
	'ES35022' => 'Santa Lucía de Tirajana',
	'ES35026' => 'Telde',
	'ES36038' => 'Pontevedra',
	'ES36057' => 'Vigo',
	'ES37274' => 'Salamanca',
	'ES38006' => 'Arona',
	'ES38017' => 'Granadilla de Abona',
	'ES38023' => 'San Cristóbal de La Laguna',
	'ES38038' => 'Santa Cruz de Tenerife',
	'ES39075' => 'Santander',
	'ES39087' => 'Torrelavega',
	'ES40194' => 'Segovia',
	'ES41004' => 'Alcalá de Guadaíra',
	'ES41038' => 'Dos Hermanas',
	'ES41091' => 'Sevilla',
	'ES41095' => 'Utrera',
	'ES43123' => 'Reus',
	'ES43148' => 'Tarragona',
	'ES45165' => 'Talavera de la Reina',
	'ES45168' => 'Toledo',
	'ES46131' => 'Gandia',
	'ES46190' => 'Paterna',
	'ES46220' => 'Sagunt',
	'ES46244' => 'Torrent',
	'ES46250' => 'València',
	'ES47186' => 'Valladolid',
	'ES48013' => 'Barakaldo',
	'ES48020' => 'Bilbao',
	'ES48044' => 'Getxo',
	'ES49275' => 'Zamora',
	'ES50297' => 'Zaragoza',
	'ES51001' => 'Ceuta',
	'ES52001' => 'Melilla',
	'ES01002' => 'Amurrio',
	'ES01036' => 'Llodio',
	'ES01051' => 'Salvatierra',
	'ES02009' => 'Almansa',
	'ES02025' => 'Caudete',
	'ES02037' => 'Hellín',
	'ES02069' => 'Roda, La',
	'ES02073' => 'Tarazona de la Mancha',
	'ES02074' => 'Tobarra',
	'ES02081' => 'Villarrobledo',
	'ES03005' => 'Albatera',
	'ES03011' => 'Alfàs del Pi, l',
	'ES03015' => 'Almoradí',
	'ES03018' => 'Altea',
	'ES03019' => 'Aspe',
	'ES03021' => 'Banyeres de Mariola',
	'ES03024' => 'Benejúzar',
	'ES03041' => 'Benissa',
	'ES03044' => 'Bigastro',
	'ES03047' => 'Calp',
	'ES03048' => 'Callosa den Sarrià',
	'ES03049' => 'Callosa de Segura',
	'ES03050' => 'Campello, el',
	'ES03053' => 'Castalla',
	'ES03055' => 'Catral',
	'ES03056' => 'Cocentaina',
	'ES03058' => 'Cox',
	'ES03059' => 'Crevillent',
	'ES03063' => 'Dénia',
	'ES03064' => 'Dolores',
	'ES03069' => 'Finestrat',
	'ES03071' => 'Gata de Gorgos',
	'ES03076' => 'Guardamar del Segura',
	'ES03079' => 'Ibi',
	'ES03082' => 'Xàbia',
	'ES03083' => 'Xixona',
	'ES03088' => 'Monforte del Cid',
	'ES03089' => 'Monòver',
	'ES03090' => 'Mutxamel',
	'ES03092' => 'Muro de Alcoy',
	'ES03093' => 'Novelda',
	'ES03094' => 'Nucia, la',
	'ES03095' => 'Ondara',
	'ES03096' => 'Onil',
	'ES03101' => 'Pedreguer',
	'ES03102' => 'Pego',
	'ES03104' => 'Petrer',
	'ES03105' => 'Pinoso',
	'ES03111' => 'Redován',
	'ES03113' => 'Rojales',
	'ES03118' => 'San Fulgencio',
	'ES03119' => 'Sant Joan dAlacant',
	'ES03120' => 'San Miguel de Salinas',
	'ES03121' => 'Santa Pola',
	'ES03123' => 'Sax',
	'ES03128' => 'Teulada',
	'ES03139' => 'Vila Joiosa, la',
	'ES03140' => 'Villena',
	'ES03902' => 'Pilar de la Horadada',
	'ES04003' => 'Adra',
	'ES04006' => 'Albox',
	'ES04029' => 'Berja',
	'ES04032' => 'Carboneras',
	'ES04035' => 'Cuevas del Almanzora',
	'ES04049' => 'Garrucha',
	'ES04052' => 'Huércal de Almería',
	'ES04053' => 'Huércal-Overa',
	'ES04062' => 'Macael',
	'ES04064' => 'Mojácar',
	'ES04066' => 'Níjar',
	'ES04069' => 'Olula del Río',
	'ES04075' => 'Pulpí',
	'ES04099' => 'Vélez-Rubio',
	'ES04100' => 'Vera',
	'ES04101' => 'Viator',
	'ES04102' => 'Vícar',
	'ES04903' => 'Mojonera, La',
	'ES05014' => 'Arenas de San Pedro',
	'ES05016' => 'Arévalo',
	'ES05047' => 'Candeleda',
	'ES05168' => 'Navas del Marqués, Las',
	'ES06002' => 'Aceuchal',
	'ES06006' => 'Alburquerque',
	'ES06011' => 'Almendralejo',
	'ES06014' => 'Azuaga',
	'ES06025' => 'Calamonte',
	'ES06036' => 'Castuera',
	'ES06044' => 'Don Benito',
	'ES06054' => 'Fuente del Maestre',
	'ES06060' => 'Guareña',
	'ES06070' => 'Jerez de los Caballeros',
	'ES06074' => 'Llerena',
	'ES06088' => 'Montijo',
	'ES06093' => 'Oliva de la Frontera',
	'ES06095' => 'Olivenza',
	'ES06103' => 'Puebla de la Calzada',
	'ES06122' => 'Santos de Maimona, Los',
	'ES06123' => 'San Vicente de Alcántara',
	'ES06128' => 'Talavera la Real',
	'ES06149' => 'Villafranca de los Barros',
	'ES06153' => 'Villanueva de la Serena',
	'ES06158' => 'Zafra',
	'ES07001' => 'Alaró',
	'ES07002' => 'Alaior',
	'ES07003' => 'Alcúdia',
	'ES07004' => 'Algaida',
	'ES07005' => 'Andratx',
	'ES07006' => 'Artà',
	'ES07008' => 'Binissalem',
	'ES07010' => 'Bunyola',
	'ES07013' => 'Campos',
	'ES07014' => 'Capdepera',
	'ES07015' => 'Ciutadella de Menorca',
	'ES07020' => 'Esporles',
	'ES07022' => 'Felanitx',
	'ES07024' => 'Formentera',
	'ES07026' => 'Eivissa',
	'ES07027' => 'Inca',
	'ES07029' => 'Lloseta',
	'ES07031' => 'Llucmajor',
	'ES07032' => 'Maó-Mahón',
	'ES07033' => 'Manacor',
	'ES07036' => 'Marratxí',
	'ES07037' => 'Mercadal, Es',
	'ES07039' => 'Muro',
	'ES07042' => 'Pollença',
	'ES07043' => 'Porreres',
	'ES07044' => 'Pobla, Sa',
	'ES07046' => 'Sant Antoni de Portmany',
	'ES07048' => 'Sant Josep de sa Talaia',
	'ES07050' => 'Sant Joan de Labritja',
	'ES07051' => 'Sant Llorenç des Cardassar',
	'ES07052' => 'Sant Lluís',
	'ES07054' => 'Santa Eulària des Riu',
	'ES07055' => 'Santa Margalida',
	'ES07056' => 'Santa María del Camí',
	'ES07057' => 'Santanyí',
	'ES07061' => 'Sóller',
	'ES07062' => 'Son Servera',
	'ES07064' => 'Castell, Es',
	'ES08001' => 'Abrera',
	'ES08003' => 'Alella',
	'ES08005' => 'Ametlla del Vallès, L',
	'ES08006' => 'Arenys de Mar',
	'ES08007' => 'Arenys de Munt',
	'ES08009' => 'Argentona',
	'ES08010' => 'Artés',
	'ES08020' => 'Begues',
	'ES08022' => 'Berga',
	'ES08023' => 'Bigues i Riells',
	'ES08030' => 'Cabrils',
	'ES08033' => 'Caldes de Montbui',
	'ES08035' => 'Calella',
	'ES08040' => 'Canet de Mar',
	'ES08041' => 'Canovelles',
	'ES08044' => 'Capellades',
	'ES08046' => 'Cardedeu',
	'ES08051' => 'Castellar del Vallès',
	'ES08054' => 'Castellbisbal',
	'ES08067' => 'Centelles',
	'ES08068' => 'Cervelló',
	'ES08072' => 'Corbera de Llobregat',
	'ES08074' => 'Cubelles',
	'ES08075' => 'Dosrius',
	'ES08076' => 'Esparreguera',
	'ES08077' => 'Esplugues de Llobregat',
	'ES08086' => 'Franqueses del Vallès, Les',
	'ES08088' => 'Garriga, La',
	'ES08089' => 'Gavà',
	'ES08091' => 'Gelida',
	'ES08102' => 'Igualada',
	'ES08105' => 'Llagosta, La',
	'ES08106' => 'Llinars del Vallès',
	'ES08107' => 'Lliçà dAmunt',
	'ES08108' => 'Lliçà de Vall',
	'ES08110' => 'Malgrat de Mar',
	'ES08112' => 'Manlleu',
	'ES08114' => 'Martorell',
	'ES08118' => 'Masnou, El',
	'ES08119' => 'Masquefa',
	'ES08120' => 'Matadepera',
	'ES08123' => 'Molins de Rei',
	'ES08125' => 'Montcada i Reixac',
	'ES08126' => 'Montgat',
	'ES08135' => 'Montmeló',
	'ES08136' => 'Montornès del Vallès',
	'ES08138' => 'Moià',
	'ES08140' => 'Navarcles',
	'ES08141' => 'Navàs',
	'ES08147' => 'Olesa de Montserrat',
	'ES08155' => 'Palafolls',
	'ES08156' => 'Palau-solità i Plegamans',
	'ES08157' => 'Pallejà',
	'ES08159' => 'Parets del Vallès',
	'ES08161' => 'Piera',
	'ES08163' => 'Pineda de Mar',
	'ES08167' => 'Polinyà',
	'ES08172' => 'Premià de Mar',
	'ES08180' => 'Ripollet',
	'ES08181' => 'Roca del Vallès, La',
	'ES08183' => 'Roda de Ter',
	'ES08191' => 'Sallent',
	'ES08192' => 'Santpedor',
	'ES08194' => 'Sant Adrià de Besòs',
	'ES08196' => 'Sant Andreu de la Barca',
	'ES08197' => 'Sant Andreu de Llavaneres',
	'ES08198' => 'Sant Antoni de Vilamajor',
	'ES08202' => 'Sant Celoni',
	'ES08208' => 'Sant Esteve Sesrovires',
	'ES08209' => 'Sant Fost de Campsentelles',
	'ES08210' => 'Sant Feliu de Codines',
	'ES08211' => 'Sant Feliu de Llobregat',
	'ES08213' => 'Sant Fruitós de Bages',
	'ES08214' => 'Vilassar de Dalt',
	'ES08217' => 'Sant Joan Despí',
	'ES08218' => 'Sant Joan de Vilatorrada',
	'ES08219' => 'Vilassar de Mar',
	'ES08221' => 'Sant Just Desvern',
	'ES08230' => 'Premià de Dalt',
	'ES08231' => 'Sant Pere de Ribes',
	'ES08235' => 'Sant Pol de Mar',
	'ES08238' => 'Sant Quirze del Vallès',
	'ES08240' => 'Sant Sadurní dAnoia',
	'ES08244' => 'Santa Coloma de Cervelló',
	'ES08248' => 'Santa Eulàlia de Ronçana',
	'ES08250' => 'Santa Margarida de Montbui',
	'ES08251' => 'Santa Margarida i els Monjos',
	'ES08252' => 'Barberà del Vallès',
	'ES08259' => 'Santa Maria de Palautordera',
	'ES08260' => 'Santa Perpètua de Mogoda',
	'ES08262' => 'Sant Vicenç de Castellet',
	'ES08263' => 'Sant Vicenç dels Horts',
	'ES08264' => 'Sant Vicenç de Montalt',
	'ES08267' => 'Sentmenat',
	'ES08270' => 'Sitges',
	'ES08274' => 'Súria',
	'ES08278' => 'Taradell',
	'ES08281' => 'Teià',
	'ES08282' => 'Tiana',
	'ES08283' => 'Tona',
	'ES08284' => 'Tordera',
	'ES08285' => 'Torelló',
	'ES08289' => 'Torrelles de Llobregat',
	'ES08291' => 'Vacarisses',
	'ES08295' => 'Vallirana',
	'ES08298' => 'Vic',
	'ES08300' => 'Viladecavalls',
	'ES08302' => 'Vilanova del Camí',
	'ES08305' => 'Vilafranca del Penedès',
	'ES08902' => 'Vilanova del Vallès',
	'ES08904' => 'Badia del Vallès',
	'ES09018' => 'Aranda de Duero',
	'ES09056' => 'Briviesca',
	'ES09209' => 'Medina de Pomar',
	'ES09219' => 'Miranda de Ebro',
	'ES10021' => 'Arroyo de la Luz',
	'ES10067' => 'Coria',
	'ES10104' => 'Jaraíz de la Vera',
	'ES10121' => 'Miajadas',
	'ES10127' => 'Montehermoso',
	'ES10128' => 'Moraleja',
	'ES10131' => 'Navalmoral de la Mata',
	'ES10148' => 'Plasencia',
	'ES10180' => 'Talayuela',
	'ES10195' => 'Trujillo',
	'ES10203' => 'Valencia de Alcántara',
	'ES11001' => 'Alcalá de los Gazules',
	'ES11002' => 'Alcalá del Valle',
	'ES11005' => 'Algodonales',
	'ES11006' => 'Arcos de la Frontera',
	'ES11007' => 'Barbate',
	'ES11008' => 'Barrios, Los',
	'ES11010' => 'Bornos',
	'ES11014' => 'Conil de la Frontera',
	'ES11016' => 'Chipiona',
	'ES11021' => 'Jimena de la Frontera',
	'ES11023' => 'Medina Sidonia',
	'ES11024' => 'Olvera',
	'ES11025' => 'Paterna de Rivera',
	'ES11026' => 'Prado del Rey',
	'ES11028' => 'Puerto Real',
	'ES11029' => 'Puerto Serrano',
	'ES11030' => 'Rota',
	'ES11033' => 'San Roque',
	'ES11035' => 'Tarifa',
	'ES11037' => 'Trebujena',
	'ES11038' => 'Ubrique',
	'ES11039' => 'Vejer de la Frontera',
	'ES11041' => 'Villamartín',
	'ES11901' => 'Benalup-Casas Viejas',
	'ES12004' => 'Alcalà de Xivert',
	'ES12005' => 'Alcora, l',
	'ES12009' => 'Almassora',
	'ES12011' => 'Almenara',
	'ES12021' => 'Betxí',
	'ES12027' => 'Benicarló',
	'ES12028' => 'Benicàssim',
	'ES12031' => 'Borriol',
	'ES12032' => 'Burriana',
	'ES12077' => 'Moncofa',
	'ES12082' => 'Nules',
	'ES12084' => 'Onda',
	'ES12085' => 'Orpesa',
	'ES12089' => 'Peñíscola',
	'ES12104' => 'Segorbe',
	'ES12117' => 'Torreblanca',
	'ES12126' => 'Vall dUixó, la',
	'ES12138' => 'Vinaròs',
	'ES13005' => 'Alcázar de San Juan',
	'ES13011' => 'Almadén',
	'ES13013' => 'Almagro',
	'ES13015' => 'Almodóvar del Campo',
	'ES13019' => 'Argamasilla de Alba',
	'ES13020' => 'Argamasilla de Calatrava',
	'ES13023' => 'Bolaños de Calatrava',
	'ES13028' => 'Campo de Criptana',
	'ES13039' => 'Daimiel',
	'ES13047' => 'Herencia',
	'ES13052' => 'Malagón',
	'ES13053' => 'Manzanares',
	'ES13054' => 'Membrilla',
	'ES13056' => 'Miguelturra',
	'ES13058' => 'Moral de Calatrava',
	'ES13061' => 'Pedro Muñoz',
	'ES13071' => 'Puertollano',
	'ES13078' => 'Socuéllamos',
	'ES13079' => 'Solana, La',
	'ES13082' => 'Tomelloso',
	'ES13087' => 'Valdepeñas',
	'ES13096' => 'Villarrubia de los Ojos',
	'ES14002' => 'Aguilar de la Frontera',
	'ES14005' => 'Almodóvar del Río',
	'ES14007' => 'Baena',
	'ES14012' => 'Bujalance',
	'ES14013' => 'Cabra',
	'ES14017' => 'Carlota, La',
	'ES14019' => 'Castro del Río',
	'ES14027' => 'Fernán-Núñez',
	'ES14030' => 'Fuente Palmera',
	'ES14035' => 'Hinojosa del Duque',
	'ES14038' => 'Lucena',
	'ES14042' => 'Montilla',
	'ES14043' => 'Montoro',
	'ES14046' => 'Nueva Carteya',
	'ES14049' => 'Palma del Río',
	'ES14052' => 'Peñarroya-Pueblonuevo',
	'ES14053' => 'Posadas',
	'ES14054' => 'Pozoblanco',
	'ES14055' => 'Priego de Córdoba',
	'ES14056' => 'Puente Genil',
	'ES14057' => 'Rambla, La',
	'ES14058' => 'Rute',
	'ES14066' => 'Villa del Río',
	'ES14069' => 'Villanueva de Córdoba',
	'ES15001' => 'Abegondo',
	'ES15002' => 'Ames',
	'ES15004' => 'Ares',
	'ES15005' => 'Arteixo',
	'ES15006' => 'Arzúa',
	'ES15008' => 'Bergondo',
	'ES15009' => 'Betanzos',
	'ES15011' => 'Boiro',
	'ES15013' => 'Brión',
	'ES15016' => 'Camariñas',
	'ES15017' => 'Cambre',
	'ES15019' => 'Carballo',
	'ES15021' => 'Carral',
	'ES15022' => 'Cedeira',
	'ES15023' => 'Cee',
	'ES15024' => 'Cerceda',
	'ES15029' => 'Coristanco',
	'ES15031' => 'Culleredo',
	'ES15035' => 'Fene',
	'ES15041' => 'Laracha, A',
	'ES15043' => 'Malpica de Bergantiños',
	'ES15046' => 'Melide',
	'ES15048' => 'Miño',
	'ES15051' => 'Mugardos',
	'ES15053' => 'Muros',
	'ES15054' => 'Narón',
	'ES15055' => 'Neda',
	'ES15056' => 'Negreira',
	'ES15057' => 'Noia',
	'ES15058' => 'Oleiros',
	'ES15059' => 'Ordes',
	'ES15060' => 'Oroso',
	'ES15061' => 'Ortigueira',
	'ES15062' => 'Outes',
	'ES15065' => 'Padrón',
	'ES15067' => 'Pobra do Caramiñal, A',
	'ES15068' => 'Ponteceso',
	'ES15069' => 'Pontedeume',
	'ES15070' => 'Pontes de García Rodríguez, As',
	'ES15071' => 'Porto do Son',
	'ES15072' => 'Rianxo',
	'ES15073' => 'Ribeira',
	'ES15075' => 'Sada',
	'ES15077' => 'Santa Comba',
	'ES15082' => 'Teo',
	'ES15087' => 'Valdoviño',
	'ES15089' => 'Vedra',
	'ES15092' => 'Vimianzo',
	'ES15902' => 'Oza-Cesuras',
	'ES16133' => 'Mota del Cuervo',
	'ES16134' => 'Motilla del Palancar',
	'ES16154' => 'Pedroñeras, Las',
	'ES16175' => 'Quintanar del Rey',
	'ES16190' => 'San Clemente',
	'ES16203' => 'Tarancón',
	'ES17008' => 'Anglès',
	'ES17009' => 'Arbúcies',
	'ES17015' => 'Banyoles',
	'ES17022' => 'Bisbal dEmpordà, La',
	'ES17023' => 'Blanes',
	'ES17033' => 'Caldes de Malavella',
	'ES17034' => 'Calonge i Sant Antoni',
	'ES17044' => 'Cassà de la Selva',
	'ES17047' => 'Castelló dEmpúries',
	'ES17048' => 'Castell-Platja dAro',
	'ES17049' => 'Celrà',
	'ES17062' => 'Escala, L',
	'ES17066' => 'Figueres',
	'ES17089' => 'Llagostera',
	'ES17095' => 'Lloret de Mar',
	'ES17103' => 'Maçanet de la Selva',
	'ES17114' => 'Olot',
	'ES17117' => 'Palafrugell',
	'ES17118' => 'Palamós',
	'ES17141' => 'Puigcerdà',
	'ES17147' => 'Ripoll',
	'ES17152' => 'Roses',
	'ES17155' => 'Salt',
	'ES17160' => 'Sant Feliu de Guíxols',
	'ES17164' => 'Sant Hilari Sacalm',
	'ES17180' => 'Santa Coloma de Farners',
	'ES17181' => 'Santa Cristina dAro',
	'ES17186' => 'Sarrià de Ter',
	'ES17193' => 'Sils',
	'ES17199' => 'Torroella de Montgrí',
	'ES17202' => 'Tossa de Mar',
	'ES17213' => 'Vidreres',
	'ES17221' => 'Vilafant',
	'ES18003' => 'Albolote',
	'ES18006' => 'Albuñol',
	'ES18011' => 'Alfacar',
	'ES18013' => 'Alhama de Granada',
	'ES18014' => 'Alhendín',
	'ES18017' => 'Almuñécar',
	'ES18021' => 'Armilla',
	'ES18022' => 'Atarfe',
	'ES18023' => 'Baza',
	'ES18036' => 'Cájar',
	'ES18047' => 'Cenes de la Vega',
	'ES18057' => 'Cúllar Vega',
	'ES18059' => 'Chauchina',
	'ES18062' => 'Churriana de la Vega',
	'ES18071' => 'Dúrcal',
	'ES18084' => 'Gójar',
	'ES18089' => 'Guadix',
	'ES18093' => 'Gualchos',
	'ES18098' => 'Huéscar',
	'ES18100' => 'Huétor Tájar',
	'ES18101' => 'Huétor Vega',
	'ES18102' => 'Íllora',
	'ES18105' => 'Iznalloz',
	'ES18122' => 'Loja',
	'ES18127' => 'Maracena',
	'ES18134' => 'Monachil',
	'ES18135' => 'Montefrío',
	'ES18145' => 'Ogíjares',
	'ES18147' => 'Órgiva',
	'ES18149' => 'Villa de Otura',
	'ES18150' => 'Padul',
	'ES18153' => 'Peligros',
	'ES18158' => 'Pinos Puente',
	'ES18165' => 'Pulianas',
	'ES18173' => 'Salobreña',
	'ES18175' => 'Santa Fe',
	'ES18193' => 'Zubia, La',
	'ES18905' => 'Gabias, Las',
	'ES18911' => 'Vegas del Genil',
	'ES19024' => 'Alovera',
	'ES19046' => 'Azuqueca de Henares',
	'ES19058' => 'Cabanillas del Campo',
	'ES19071' => 'Casar, El',
	'ES19171' => 'Marchamalo',
	'ES19280' => 'Torrejón del Rey',
	'ES19319' => 'Villanueva de la Torre',
	'ES20009' => 'Andoain',
	'ES20013' => 'Aretxabaleta',
	'ES20017' => 'Azkoitia',
	'ES20018' => 'Azpeitia',
	'ES20019' => 'Beasain',
	'ES20029' => 'Deba',
	'ES20030' => 'Eibar',
	'ES20032' => 'Elgoibar',
	'ES20036' => 'Hondarribia',
	'ES20040' => 'Hernani',
	'ES20049' => 'Lazkao',
	'ES20051' => 'Legazpi',
	'ES20053' => 'Lezo',
	'ES20055' => 'Mondragón',
	'ES20056' => 'Mutriku',
	'ES20059' => 'Oñati',
	'ES20061' => 'Orio',
	'ES20063' => 'Oiartzun',
	'ES20064' => 'Pasaia',
	'ES20067' => 'Errenteria',
	'ES20071' => 'Tolosa',
	'ES20072' => 'Urnieta',
	'ES20073' => 'Usurbil',
	'ES20074' => 'Bergara',
	'ES20075' => 'Villabona',
	'ES20076' => 'Ordizia',
	'ES20077' => 'Urretxu',
	'ES20079' => 'Zarautz',
	'ES20080' => 'Zumarraga',
	'ES20081' => 'Zumaia',
	'ES20902' => 'Lasarte-Oria',
	'ES20903' => 'Astigarraga',
	'ES21002' => 'Aljaraque',
	'ES21005' => 'Almonte',
	'ES21007' => 'Aracena',
	'ES21010' => 'Ayamonte',
	'ES21013' => 'Bollullos Par del Condado',
	'ES21014' => 'Bonares',
	'ES21021' => 'Cartaya',
	'ES21035' => 'Gibraleón',
	'ES21042' => 'Isla Cristina',
	'ES21044' => 'Lepe',
	'ES21050' => 'Moguer',
	'ES21052' => 'Nerva',
	'ES21054' => 'Palma del Condado, La',
	'ES21055' => 'Palos de la Frontera',
	'ES21060' => 'Punta Umbría',
	'ES21061' => 'Rociana del Condado',
	'ES21064' => 'San Juan del Puerto',
	'ES21070' => 'Trigueros',
	'ES21072' => 'Valverde del Camino',
	'ES22048' => 'Barbastro',
	'ES22061' => 'Binéfar',
	'ES22112' => 'Fraga',
	'ES22130' => 'Jaca',
	'ES22158' => 'Monzón',
	'ES22199' => 'Sabiñánigo',
	'ES23002' => 'Alcalá la Real',
	'ES23003' => 'Alcaudete',
	'ES23005' => 'Andújar',
	'ES23006' => 'Arjona',
	'ES23009' => 'Baeza',
	'ES23010' => 'Bailén',
	'ES23012' => 'Beas de Segura',
	'ES23024' => 'Carolina, La',
	'ES23028' => 'Cazorla',
	'ES23038' => 'Guardia de Jaén, La',
	'ES23044' => 'Huelma',
	'ES23053' => 'Jódar',
	'ES23058' => 'Mancha Real',
	'ES23059' => 'Marmolejo',
	'ES23060' => 'Martos',
	'ES23061' => 'Mengíbar',
	'ES23066' => 'Peal de Becerro',
	'ES23069' => 'Porcuna',
	'ES23073' => 'Quesada',
	'ES23086' => 'Torredelcampo',
	'ES23087' => 'Torredonjimeno',
	'ES23088' => 'Torreperogil',
	'ES23092' => 'Úbeda',
	'ES23095' => 'Villacarrillo',
	'ES23097' => 'Villanueva del Arzobispo',
	'ES23099' => 'Villares, Los',
	'ES24008' => 'Astorga',
	'ES24010' => 'Bañeza, La',
	'ES24014' => 'Bembibre',
	'ES24030' => 'Cacabelos',
	'ES24142' => 'San Andrés del Rabanedo',
	'ES24163' => 'Sariegos',
	'ES24188' => 'Valencia de Don Juan',
	'ES24189' => 'Valverde de la Virgen',
	'ES24202' => 'Villablino',
	'ES24222' => 'Villaquilambre',
	'ES25003' => 'Agramunt',
	'ES25011' => 'Alcarràs',
	'ES25019' => 'Almacelles',
	'ES25023' => 'Alpicat',
	'ES25040' => 'Balaguer',
	'ES25050' => 'Bellpuig',
	'ES25058' => 'Borges Blanques, Les',
	'ES25072' => 'Cervera',
	'ES25110' => 'Guissona',
	'ES25137' => 'Mollerussa',
	'ES25203' => 'Seu dUrgell, La',
	'ES25207' => 'Solsona',
	'ES25217' => 'Tàrrega',
	'ES25234' => 'Tremp',
	'ES25243' => 'Vielha e Mijaran',
	'ES26011' => 'Alfaro',
	'ES26018' => 'Arnedo',
	'ES26036' => 'Calahorra',
	'ES26071' => 'Haro',
	'ES26084' => 'Lardero',
	'ES26102' => 'Nájera',
	'ES26138' => 'Santo Domingo de la Calzada',
	'ES26168' => 'Villamediana de Iregua',
	'ES27010' => 'Castro de Rei',
	'ES27016' => 'Chantada',
	'ES27019' => 'Foz',
	'ES27022' => 'Guitiriz',
	'ES27031' => 'Monforte de Lemos',
	'ES27039' => 'Outeiro de Rei',
	'ES27051' => 'Ribadeo',
	'ES27057' => 'Sarria',
	'ES27065' => 'Vilalba',
	'ES27066' => 'Viveiro',
	'ES27902' => 'Burela',
	'ES28004' => 'Álamo, El',
	'ES28009' => 'Algete',
	'ES28010' => 'Alpedrete',
	'ES28015' => 'Arroyomolinos',
	'ES28018' => 'Becerril de la Sierra',
	'ES28023' => 'Boalo, El',
	'ES28026' => 'Brunete',
	'ES28032' => 'Camarma de Esteruelas',
	'ES28033' => 'Campo Real',
	'ES28038' => 'Cercedilla',
	'ES28040' => 'Ciempozuelos',
	'ES28041' => 'Cobeña',
	'ES28043' => 'Colmenar de Oreja',
	'ES28044' => 'Colmenarejo',
	'ES28046' => 'Collado Mediano',
	'ES28050' => 'Cubas de la Sagra',
	'ES28052' => 'Chinchón',
	'ES28053' => 'Daganzo de Arriba',
	'ES28054' => 'Escorial, El',
	'ES28059' => 'Fuente el Saz de Jarama',
	'ES28061' => 'Galapagar',
	'ES28066' => 'Griñón',
	'ES28067' => 'Guadalix de la Sierra',
	'ES28068' => 'Guadarrama',
	'ES28072' => 'Hoyo de Manzanares',
	'ES28073' => 'Humanes de Madrid',
	'ES28075' => 'Loeches',
	'ES28082' => 'Manzanares el Real',
	'ES28083' => 'Meco',
	'ES28084' => 'Mejorada del Campo',
	'ES28085' => 'Miraflores de la Sierra',
	'ES28086' => 'Molar, El',
	'ES28089' => 'Moraleja de Enmedio',
	'ES28090' => 'Moralzarzal',
	'ES28091' => 'Morata de Tajuña',
	'ES28096' => 'Navalcarnero',
	'ES28100' => 'Nuevo Baztán',
	'ES28104' => 'Paracuellos de Jarama',
	'ES28108' => 'Pedrezuela',
	'ES28129' => 'San Agustín del Guadalix',
	'ES28130' => 'San Fernando de Henares',
	'ES28131' => 'San Lorenzo de El Escorial',
	'ES28132' => 'San Martín de la Vega',
	'ES28133' => 'San Martín de Valdeiglesias',
	'ES28141' => 'Sevilla la Nueva',
	'ES28144' => 'Soto del Real',
	'ES28149' => 'Torrejón de la Calzada',
	'ES28152' => 'Torrelodones',
	'ES28154' => 'Torres de la Alameda',
	'ES28160' => 'Valdemorillo',
	'ES28167' => 'Velilla de San Antonio',
	'ES28171' => 'Villa del Prado',
	'ES28172' => 'Villalbilla',
	'ES28176' => 'Villanueva de la Cañada',
	'ES28177' => 'Villanueva del Pardillo',
	'ES28180' => 'Villarejo de Salvanés',
	'ES28181' => 'Villaviciosa de Odón',
	'ES28903' => 'Tres Cantos',
	'ES29001' => 'Alameda',
	'ES29005' => 'Algarrobo',
	'ES29007' => 'Alhaurín de la Torre',
	'ES29008' => 'Alhaurín el Grande',
	'ES29012' => 'Álora',
	'ES29015' => 'Antequera',
	'ES29017' => 'Archidona',
	'ES29023' => 'Benahavís',
	'ES29032' => 'Campillos',
	'ES29038' => 'Cártama',
	'ES29041' => 'Casares',
	'ES29042' => 'Coín',
	'ES29068' => 'Manilva',
	'ES29072' => 'Mollina',
	'ES29075' => 'Nerja',
	'ES29080' => 'Pizarra',
	'ES29082' => 'Rincón de la Victoria',
	'ES29084' => 'Ronda',
	'ES29091' => 'Torrox',
	'ES29097' => 'Villanueva del Trabuco',
	'ES30001' => 'Abanilla',
	'ES30002' => 'Abarán',
	'ES30003' => 'Águilas',
	'ES30005' => 'Alcantarilla',
	'ES30007' => 'Alguazas',
	'ES30008' => 'Alhama de Murcia',
	'ES30009' => 'Archena',
	'ES30010' => 'Beniel',
	'ES30011' => 'Blanca',
	'ES30012' => 'Bullas',
	'ES30013' => 'Calasparra',
	'ES30015' => 'Caravaca de la Cruz',
	'ES30017' => 'Cehegín',
	'ES30018' => 'Ceutí',
	'ES30019' => 'Cieza',
	'ES30020' => 'Fortuna',
	'ES30021' => 'Fuente Álamo de Murcia',
	'ES30022' => 'Jumilla',
	'ES30023' => 'Librilla',
	'ES30025' => 'Lorquí',
	'ES30026' => 'Mazarrón',
	'ES30028' => 'Moratalla',
	'ES30029' => 'Mula',
	'ES30033' => 'Puerto Lumbreras',
	'ES30035' => 'San Javier',
	'ES30036' => 'San Pedro del Pinatar',
	'ES30037' => 'Torre-Pacheco',
	'ES30038' => 'Torres de Cotillas, Las',
	'ES30039' => 'Totana',
	'ES30041' => 'Unión, La',
	'ES30043' => 'Yecla',
	'ES30901' => 'Santomera',
	'ES30902' => 'Alcázares, Los',
	'ES31010' => 'Alsasua',
	'ES31016' => 'Antsoain',
	'ES31023' => 'Aranguren',
	'ES31050' => 'Baztan',
	'ES31060' => 'Burlata',
	'ES31072' => 'Cintruénigo',
	'ES31077' => 'Corella',
	'ES31086' => 'Eguesibar',
	'ES31088' => 'Noain (Elortzibar)',
	'ES31097' => 'Estella-Lizarra',
	'ES31122' => 'Uharte',
	'ES31202' => 'Azkoien',
	'ES31215' => 'San Adrián',
	'ES31227' => 'Tafalla',
	'ES31232' => 'Tudela',
	'ES31258' => 'Atarrabia',
	'ES31901' => 'Barañain',
	'ES31902' => 'Berriobeiti',
	'ES31903' => 'Berriozar',
	'ES31907' => 'Zizur Nagusia',
	'ES32001' => 'Allariz',
	'ES32008' => 'Barbadás',
	'ES32009' => 'Barco de Valdeorras, O',
	'ES32019' => 'Carballiño, O',
	'ES32024' => 'Celanova',
	'ES32032' => 'Xinzo de Limia',
	'ES32058' => 'Pereiro de Aguiar, O',
	'ES32069' => 'Ribadavia',
	'ES32075' => 'San Cibrao das Viñas',
	'ES32085' => 'Verín',
	'ES33002' => 'Aller',
	'ES33011' => 'Cangas del Narcea',
	'ES33012' => 'Cangas de Onís',
	'ES33014' => 'Carreño',
	'ES33016' => 'Castrillón',
	'ES33020' => 'Corvera de Asturias',
	'ES33025' => 'Gozón',
	'ES33026' => 'Grado',
	'ES33031' => 'Langreo',
	'ES33032' => 'Laviana',
	'ES33033' => 'Lena',
	'ES33034' => 'Valdés',
	'ES33035' => 'Llanera',
	'ES33036' => 'Llanes',
	'ES33037' => 'Mieres',
	'ES33040' => 'Nava',
	'ES33041' => 'Navia',
	'ES33042' => 'Noreña',
	'ES33045' => 'Parres',
	'ES33049' => 'Piloña',
	'ES33051' => 'Pravia',
	'ES33056' => 'Ribadesella',
	'ES33060' => 'San Martín del Rey Aurelio',
	'ES33073' => 'Tineo',
	'ES33076' => 'Villaviciosa',
	'ES34004' => 'Aguilar de Campoo',
	'ES34023' => 'Venta de Baños',
	'ES34080' => 'Guardo',
	'ES34225' => 'Villamuriel de Cerrato',
	'ES35001' => 'Agaete',
	'ES35002' => 'Agüimes',
	'ES35003' => 'Antigua',
	'ES35006' => 'Arucas',
	'ES35008' => 'Firgas',
	'ES35009' => 'Gáldar',
	'ES35010' => 'Haría',
	'ES35011' => 'Ingenio',
	'ES35012' => 'Mogán',
	'ES35013' => 'Moya',
	'ES35014' => 'Oliva, La',
	'ES35015' => 'Pájara',
	'ES35017' => 'Puerto del Rosario',
	'ES35018' => 'San Bartolomé',
	'ES35020' => 'Aldea de San Nicolás, La',
	'ES35021' => 'Santa Brígida',
	'ES35023' => 'Santa María de Guía de Gran Canariae',
	'ES35024' => 'Teguise',
	'ES35027' => 'Teror',
	'ES35028' => 'Tías',
	'ES35029' => 'Tinajo',
	'ES35030' => 'Tuineje',
	'ES35031' => 'Valsequillo de Gran Canaria',
	'ES35033' => 'Vega de San Mateo',
	'ES35034' => 'Yaiza',
	'ES36003' => 'Baiona',
	'ES36004' => 'Bueu',
	'ES36005' => 'Caldas de Reis',
	'ES36006' => 'Cambados',
	'ES36008' => 'Cangas',
	'ES36009' => 'Cañiza, A',
	'ES36017' => 'Estrada, A',
	'ES36021' => 'Gondomar',
	'ES36022' => 'Grove, O',
	'ES36023' => 'Guarda, A',
	'ES36024' => 'Lalín',
	'ES36026' => 'Marín',
	'ES36027' => 'Meaño',
	'ES36029' => 'Moaña',
	'ES36033' => 'Mos',
	'ES36035' => 'Nigrán',
	'ES36039' => 'Porriño, O',
	'ES36041' => 'Poio',
	'ES36042' => 'Ponteareas',
	'ES36043' => 'Ponte Caldelas',
	'ES36045' => 'Redondela',
	'ES36046' => 'Ribadumia',
	'ES36048' => 'Rosal, O',
	'ES36049' => 'Salceda de Caselas',
	'ES36050' => 'Salvaterra de Miño',
	'ES36051' => 'Sanxenxo',
	'ES36052' => 'Silleda',
	'ES36053' => 'Soutomaior',
	'ES36054' => 'Tomiño',
	'ES36055' => 'Tui',
	'ES36056' => 'Valga',
	'ES36058' => 'Vilaboa',
	'ES36059' => 'Vila de Cruces',
	'ES36060' => 'Vilagarcía de Arousa',
	'ES36061' => 'Vilanova de Arousa',
	'ES36902' => 'Cerdedo-Cotobade',
	'ES37008' => 'Alba de Tormes',
	'ES37046' => 'Béjar',
	'ES37085' => 'Carbajosa de la Sagrada',
	'ES37107' => 'Ciudad Rodrigo',
	'ES37156' => 'Guijuelo',
	'ES37246' => 'Peñaranda de Bracamonte',
	'ES37294' => 'Santa Marta de Tormes',
	'ES37354' => 'Villamayor',
	'ES37362' => 'Villares de la Reina',
	'ES38001' => 'Adeje',
	'ES38004' => 'Arafo',
	'ES38005' => 'Arico',
	'ES38008' => 'Breña Alta',
	'ES38009' => 'Breña Baja',
	'ES38011' => 'Candelaria',
	'ES38018' => 'Guancha, La',
	'ES38019' => 'Guía de Isora',
	'ES38020' => 'Güímar',
	'ES38022' => 'Icod de los Vinos',
	'ES38024' => 'Llanos de Aridane, Los',
	'ES38025' => 'Matanza de Acentejo, La',
	'ES38026' => 'Orotava, La',
	'ES38027' => 'Paso, El',
	'ES38028' => 'Puerto de la Cruz',
	'ES38031' => 'Realejos, Los',
	'ES38032' => 'Rosario, El',
	'ES38035' => 'San Miguel de Abona',
	'ES38036' => 'San Sebastián de la Gomera',
	'ES38037' => 'Santa Cruz de la Palma',
	'ES38039' => 'Santa Úrsula',
	'ES38040' => 'Santiago del Teide',
	'ES38041' => 'Sauzal, El',
	'ES38043' => 'Tacoronte',
	'ES38046' => 'Tegueste',
	'ES38048' => 'Valverde',
	'ES38051' => 'Victoria de Acentejo, La',
	'ES39008' => 'Astillero, El',
	'ES39012' => 'Cabezón de la Sal',
	'ES39016' => 'Camargo',
	'ES39018' => 'Cartes',
	'ES39020' => 'Castro-Urdiales',
	'ES39023' => 'Colindres',
	'ES39025' => 'Corrales de Buelna, Los',
	'ES39028' => 'Entrambasaguas',
	'ES39035' => 'Laredo',
	'ES39040' => 'Marina de Cudeyo',
	'ES39042' => 'Medio Cudeyo',
	'ES39052' => 'Piélagos',
	'ES39054' => 'Polanco',
	'ES39059' => 'Reinosa',
	'ES39060' => 'Reocín',
	'ES39073' => 'Santa Cruz de Bezana',
	'ES39074' => 'Santa María de Cayón',
	'ES39079' => 'Santoña',
	'ES39085' => 'Suances',
	'ES40063' => 'Cuéllar',
	'ES40076' => 'Espinar, El',
	'ES40155' => 'Palazuelos de Eresma',
	'ES40181' => 'Real Sitio de San Ildefonso',
	'ES41005' => 'Alcalá del Río',
	'ES41007' => 'Algaba, La',
	'ES41010' => 'Almensilla',
	'ES41011' => 'Arahal',
	'ES41013' => 'Aznalcóllar',
	'ES41015' => 'Benacazón',
	'ES41016' => 'Bollullos de la Mitación',
	'ES41017' => 'Bormujos',
	'ES41018' => 'Brenes',
	'ES41019' => 'Burguillos',
	'ES41020' => 'Cabezas de San Juan, Las',
	'ES41021' => 'Camas',
	'ES41022' => 'Campana, La',
	'ES41023' => 'Cantillana',
	'ES41024' => 'Carmona',
	'ES41026' => 'Casariche',
	'ES41029' => 'Castilleja de la Cuesta',
	'ES41033' => 'Constantina',
	'ES41034' => 'Coria del Río',
	'ES41039' => 'Écija',
	'ES41040' => 'Espartinas',
	'ES41041' => 'Estepa',
	'ES41042' => 'Fuentes de Andalucía',
	'ES41044' => 'Gelves',
	'ES41045' => 'Gerena',
	'ES41047' => 'Gines',
	'ES41049' => 'Guillena',
	'ES41050' => 'Herrera',
	'ES41053' => 'Lebrija',
	'ES41055' => 'Lora del Río',
	'ES41058' => 'Mairena del Alcor',
	'ES41059' => 'Mairena del Aljarafe',
	'ES41060' => 'Marchena',
	'ES41064' => 'Montellano',
	'ES41065' => 'Morón de la Frontera',
	'ES41067' => 'Olivares',
	'ES41068' => 'Osuna',
	'ES41069' => 'Palacios y Villafranca, Los',
	'ES41070' => 'Palomares del Río',
	'ES41071' => 'Paradas',
	'ES41072' => 'Pedrera',
	'ES41075' => 'Pilas',
	'ES41077' => 'Puebla de Cazalla, La',
	'ES41079' => 'Puebla del Río, La',
	'ES41081' => 'Rinconada, La',
	'ES41085' => 'Salteras',
	'ES41086' => 'San Juan de Aznalfarache',
	'ES41087' => 'Sanlúcar la Mayor',
	'ES41089' => 'Santiponce',
	'ES41092' => 'Tocina',
	'ES41093' => 'Tomares',
	'ES41094' => 'Umbrete',
	'ES41096' => 'Valencina de la Concepción',
	'ES41098' => 'Villanueva del Ariscal',
	'ES41101' => 'Villaverde del Río',
	'ES41102' => 'Viso del Alcor, El',
	'ES41902' => 'Isla Mayor',
	'ES41903' => 'Cuervo de Sevilla, El',
	'ES42020' => 'Almazán',
	'ES42173' => 'Soria',
	'ES43004' => 'Alcanar',
	'ES43005' => 'Alcover',
	'ES43012' => 'Altafulla',
	'ES43013' => 'Ametlla de Mar, L',
	'ES43014' => 'Amposta',
	'ES43016' => 'Arboç, L',
	'ES43037' => 'Calafell',
	'ES43038' => 'Cambrils',
	'ES43044' => 'Sénia, La',
	'ES43047' => 'Constantí',
	'ES43051' => 'Cunit',
	'ES43086' => 'Montblanc',
	'ES43092' => 'Mont-roig del Camp',
	'ES43093' => 'Móra dEbre',
	'ES43129' => 'Riudoms',
	'ES43131' => 'Roda de Berà',
	'ES43133' => 'Roquetes',
	'ES43136' => 'Sant Carles de la Ràpita',
	'ES43145' => 'Selva del Camp, La',
	'ES43153' => 'Torredembarra',
	'ES43155' => 'Tortosa',
	'ES43156' => 'Ulldecona',
	'ES43161' => 'Valls',
	'ES43162' => 'Vandellòs i lHospitalet de lInfantce',
	'ES43163' => 'Vendrell, El',
	'ES43171' => 'Vila-seca',
	'ES43901' => 'Deltebre',
	'ES43905' => 'Salou',
	'ES43907' => 'Canonja, La',
	'ES44013' => 'Alcañiz',
	'ES44025' => 'Andorra',
	'ES44216' => 'Teruel',
	'ES45014' => 'Añover de Tajo',
	'ES45016' => 'Argés',
	'ES45019' => 'Bargas',
	'ES45041' => 'Casarrubios del Monte',
	'ES45053' => 'Consuegra',
	'ES45054' => 'Corral de Almaguer',
	'ES45064' => 'Esquivias',
	'ES45066' => 'Fuensalida',
	'ES45081' => 'Illescas',
	'ES45087' => 'Madridejos',
	'ES45099' => 'Méntrida',
	'ES45106' => 'Mora',
	'ES45121' => 'Ocaña',
	'ES45122' => 'Olías del Rey',
	'ES45135' => 'Puebla de Almoradiel, La',
	'ES45136' => 'Puebla de Montalbán, La',
	'ES45142' => 'Quintanar de la Orden',
	'ES45161' => 'Seseña',
	'ES45163' => 'Sonseca',
	'ES45173' => 'Torrijos',
	'ES45176' => 'Ugena',
	'ES45185' => 'Villacañas',
	'ES45200' => 'Yébenes, Los',
	'ES45201' => 'Yeles',
	'ES45202' => 'Yepes',
	'ES45205' => 'Yuncos',
	'ES46005' => 'Alaquàs',
	'ES46006' => 'Albaida',
	'ES46007' => 'Albal',
	'ES46011' => 'Alberic',
	'ES46013' => 'Alboraya',
	'ES46015' => 'Alcàsser',
	'ES46017' => 'Alzira',
	'ES46019' => 'Alcúdia, l',
	'ES46020' => 'Alcúdia de Crespins, l',
	'ES46021' => 'Aldaia',
	'ES46022' => 'Alfafar',
	'ES46029' => 'Algemesí',
	'ES46031' => 'Alginet',
	'ES46032' => 'Almàssera',
	'ES46035' => 'Almussafes',
	'ES46044' => 'Ayora',
	'ES46051' => 'Benaguasil',
	'ES46054' => 'Benetússer',
	'ES46060' => 'Benifaió',
	'ES46062' => 'Benigànim',
	'ES46070' => 'Bétera',
	'ES46077' => 'Buñol',
	'ES46078' => 'Burjassot',
	'ES46081' => 'Canals',
	'ES46082' => 'Canet dEn Berenguer',
	'ES46083' => 'Carcaixent',
	'ES46085' => 'Carlet',
	'ES46094' => 'Catarroja',
	'ES46102' => 'Quart de Poblet',
	'ES46105' => 'Cullera',
	'ES46109' => 'Cheste',
	'ES46110' => 'Xirivella',
	'ES46111' => 'Chiva',
	'ES46116' => 'Eliana, l',
	'ES46126' => 'Foios',
	'ES46135' => 'Godella',
	'ES46139' => 'Guadassuar',
	'ES46143' => 'Xeraco',
	'ES46145' => 'Xàtiva',
	'ES46147' => 'Llíria',
	'ES46159' => 'Manises',
	'ES46164' => 'Massamagrell',
	'ES46165' => 'Massanassa',
	'ES46166' => 'Meliana',
	'ES46169' => 'Mislata',
	'ES46171' => 'Moncada',
	'ES46172' => 'Montserrat',
	'ES46177' => 'Museros',
	'ES46178' => 'Náquera',
	'ES46181' => 'Oliva',
	'ES46183' => 'Olleria, l',
	'ES46184' => 'Ontinyent',
	'ES46186' => 'Paiporta',
	'ES46193' => 'Picanya',
	'ES46194' => 'Picassent',
	'ES46199' => 'Pobla de Farnals, la',
	'ES46202' => 'Pobla de Vallbona, la',
	'ES46204' => 'Puig de Santa Maria, el',
	'ES46205' => 'Puçol',
	'ES46207' => 'Rafelbunyol',
	'ES46213' => 'Requena',
	'ES46214' => 'Riba-roja de Túria',
	'ES46216' => 'Rocafort',
	'ES46223' => 'Sedaví',
	'ES46230' => 'Silla',
	'ES46235' => 'Sueca',
	'ES46237' => 'Tavernes Blanques',
	'ES46238' => 'Tavernes de la Valldigna',
	'ES46248' => 'Turís',
	'ES46249' => 'Utiel',
	'ES46256' => 'Vilamarxant',
	'ES46257' => 'Villanueva de Castellón',
	'ES46903' => 'San Antonio de Benagéber',
	'ES47007' => 'Aldeamayor de San Martín',
	'ES47010' => 'Arroyo de la Encomienda',
	'ES47050' => 'Cigales',
	'ES47052' => 'Cistérniga',
	'ES47075' => 'Íscar',
	'ES47076' => 'Laguna de Duero',
	'ES47085' => 'Medina del Campo',
	'ES47114' => 'Peñafiel',
	'ES47161' => 'Simancas',
	'ES47165' => 'Tordesillas',
	'ES47175' => 'Tudela de Duero',
	'ES47231' => 'Zaratán',
	'ES48001' => 'Abadiño',
	'ES48002' => 'Abanto y Ciérvana-Abanto Zierbena',
	'ES48003' => 'Amorebieta-Etxano',
	'ES48011' => 'Arrigorriaga',
	'ES48015' => 'Basauri',
	'ES48016' => 'Berango',
	'ES48017' => 'Bermeo',
	'ES48027' => 'Durango',
	'ES48029' => 'Etxebarri',
	'ES48032' => 'Elorrio',
	'ES48034' => 'Ermua',
	'ES48036' => 'Galdakao',
	'ES48043' => 'Gorliz',
	'ES48045' => 'Güeñes',
	'ES48046' => 'Gernika-Lumo',
	'ES48054' => 'Leioa',
	'ES48057' => 'Lekeitio',
	'ES48060' => 'Markina-Xemein',
	'ES48069' => 'Mungia',
	'ES48071' => 'Muskiz',
	'ES48073' => 'Ondarroa',
	'ES48078' => 'Portugalete',
	'ES48080' => 'Valle de Trápaga-Trapagaran',
	'ES48082' => 'Santurtzi',
	'ES48083' => 'Ortuella',
	'ES48084' => 'Sestao',
	'ES48085' => 'Sopela',
	'ES48090' => 'Balmaseda',
	'ES48096' => 'Zalla',
	'ES48901' => 'Derio',
	'ES48902' => 'Erandio',
	'ES49021' => 'Benavente',
	'ES49219' => 'Toro',
	'ES50008' => 'Alagón',
	'ES50025' => 'Almunia de Doña Godina, La',
	'ES50067' => 'Calatayud',
	'ES50074' => 'Caspe',
	'ES50089' => 'Cuarte de Huerva',
	'ES50095' => 'Ejea de los Caballeros',
	'ES50163' => 'María de Huerva',
	'ES50182' => 'Muela, La',
	'ES50219' => 'Puebla de Alfindén, La',
	'ES50251' => 'Tarazona',
	'ES50252' => 'Tauste',
	'ES50272' => 'Utebo',
	'ES50298' => 'Zuera',
	'ES01001' => 'Alegría-Dulantzi',
	'ES01003' => 'Aramaio',
	'ES01004' => 'Artziniega',
	'ES01006' => 'Armiñón',
	'ES01008' => 'Arratzua-Ubarrundia',
	'ES01009' => 'Asparrena',
	'ES01010' => 'Aiara',
	'ES01011' => 'Mañueta',
	'ES01013' => 'Barrundia',
	'ES01014' => 'Berantevilla',
	'ES01016' => 'Bernedo',
	'ES01017' => 'Kanpezu',
	'ES01018' => 'Zigoitia',
	'ES01019' => 'Kripan',
	'ES01020' => 'Kuartango',
	'ES01021' => 'Burgelu',
	'ES01022' => 'Elciego',
	'ES01023' => 'Bilar',
	'ES01027' => 'Iruraiz-Gauna',
	'ES01028' => 'Bastida',
	'ES01030' => 'Lagrán',
	'ES01031' => 'Laguardia',
	'ES01032' => 'Lantziego',
	'ES01033' => 'Lapuebla de Labarca',
	'ES01034' => 'Leza',
	'ES01037' => 'Arraia-Maeztu',
	'ES01039' => 'Moreda Araba',
	'ES01041' => 'Navaridas',
	'ES01042' => 'Okondo',
	'ES01043' => 'Oyón-Oion',
	'ES01044' => 'Peñacerrada-Urizaharra',
	'ES01046' => 'Ribera Alta',
	'ES01047' => 'Erriberabeitia',
	'ES01049' => 'Añana',
	'ES01052' => 'Samaniego',
	'ES01053' => 'Donemiliaga',
	'ES01054' => 'Urkabustaiz',
	'ES01055' => 'Gaubea',
	'ES01056' => 'Valle de Arana',
	'ES01057' => 'Eskuernaga',
	'ES01058' => 'Legutio',
	'ES01060' => 'Iekora',
	'ES01061' => 'Zalduondo',
	'ES01062' => 'Zambrana',
	'ES01063' => 'Zuia',
	'ES01901' => 'Iruña de Oca',
	'ES01902' => 'Lantarón',
	'ES02001' => 'Abengibre',
	'ES02002' => 'Alatoz',
	'ES02004' => 'Albatana',
	'ES02005' => 'Alborea',
	'ES02006' => 'Alcadozo',
	'ES02007' => 'Alcalá del Júcar',
	'ES02008' => 'Alcaraz',
	'ES02010' => 'Alpera',
	'ES02011' => 'Ayna',
	'ES02012' => 'Balazote',
	'ES02013' => 'Balsa de Ves',
	'ES02014' => 'Ballestero, El',
	'ES02015' => 'Barrax',
	'ES02016' => 'Bienservida',
	'ES02017' => 'Bogarra',
	'ES02018' => 'Bonete',
	'ES02019' => 'Bonillo, El',
	'ES02020' => 'Carcelén',
	'ES02021' => 'Casas de Juan Núñez',
	'ES02022' => 'Casas de Lázaro',
	'ES02023' => 'Casas de Ves',
	'ES02024' => 'Casas-Ibáñez',
	'ES02026' => 'Cenizate',
	'ES02027' => 'Corral-Rubio',
	'ES02028' => 'Cotillas',
	'ES02029' => 'Chinchilla de Monte-Aragón',
	'ES02030' => 'Elche de la Sierra',
	'ES02031' => 'Férez',
	'ES02032' => 'Fuensanta',
	'ES02033' => 'Fuente-Álamo',
	'ES02034' => 'Fuentealbilla',
	'ES02035' => 'Gineta, La',
	'ES02036' => 'Golosalvo',
	'ES02038' => 'Herrera, La',
	'ES02039' => 'Higueruela',
	'ES02040' => 'Hoya-Gonzalo',
	'ES02041' => 'Jorquera',
	'ES02042' => 'Letur',
	'ES02043' => 'Lezuza',
	'ES02044' => 'Liétor',
	'ES02045' => 'Madrigueras',
	'ES02046' => 'Mahora',
	'ES02047' => 'Masegoso',
	'ES02048' => 'Minaya',
	'ES02049' => 'Molinicos',
	'ES02050' => 'Montalvos',
	'ES02051' => 'Montealegre del Castillo',
	'ES02052' => 'Motilleja',
	'ES02053' => 'Munera',
	'ES02054' => 'Navas de Jorquera',
	'ES02055' => 'Nerpio',
	'ES02056' => 'Ontur',
	'ES02057' => 'Ossa de Montiel',
	'ES02058' => 'Paterna del Madera',
	'ES02059' => 'Peñascosa',
	'ES02060' => 'Peñas de San Pedro',
	'ES02061' => 'Pétrola',
	'ES02062' => 'Povedilla',
	'ES02063' => 'Pozohondo',
	'ES02064' => 'Pozo-Lorente',
	'ES02065' => 'Pozuelo',
	'ES02066' => 'Recueja, La',
	'ES02067' => 'Riópar',
	'ES02068' => 'Robledo',
	'ES02070' => 'Salobre',
	'ES02071' => 'San Pedro',
	'ES02072' => 'Socovos',
	'ES02075' => 'Valdeganga',
	'ES02076' => 'Vianos',
	'ES02077' => 'Villa de Ves',
	'ES02078' => 'Villalgordo del Júcar',
	'ES02079' => 'Villamalea',
	'ES02080' => 'Villapalacios',
	'ES02082' => 'Villatoya',
	'ES02083' => 'Villavaliente',
	'ES02084' => 'Villaverde de Guadalimar',
	'ES02085' => 'Viveros',
	'ES02086' => 'Yeste',
	'ES02901' => 'Pozo Cañada',
	'ES03001' => 'Atzúbia, l',
	'ES03002' => 'Agost',
	'ES03003' => 'Agres',
	'ES03004' => 'Aigües',
	'ES03006' => 'Alcalalí',
	'ES03007' => 'Alcocer de Planes',
	'ES03008' => 'Alcoleja',
	'ES03010' => 'Alfafara',
	'ES03012' => 'Algorfa',
	'ES03013' => 'Algueña',
	'ES03016' => 'Almudaina',
	'ES03017' => 'Alqueria dAsnar, l',
	'ES03020' => 'Balones',
	'ES03022' => 'Benasau',
	'ES03023' => 'Beneixama',
	'ES03025' => 'Benferri',
	'ES03026' => 'Beniarbeig',
	'ES03027' => 'Beniardá',
	'ES03028' => 'Beniarrés',
	'ES03029' => 'Benigembla',
	'ES03030' => 'Benidoleig',
	'ES03032' => 'Benifallim',
	'ES03033' => 'Benifato',
	'ES03034' => 'Benijófar',
	'ES03035' => 'Benilloba',
	'ES03036' => 'Benillup',
	'ES03037' => 'Benimantell',
	'ES03038' => 'Benimarfull',
	'ES03039' => 'Benimassot',
	'ES03040' => 'Benimeli',
	'ES03042' => 'Poble Nou de Benitatxell, el',
	'ES03043' => 'Biar',
	'ES03045' => 'Bolulla',
	'ES03046' => 'Busot',
	'ES03051' => 'Camp de Mirra, el',
	'ES03052' => 'Cañada',
	'ES03054' => 'Castell de Castells',
	'ES03057' => 'Confrides',
	'ES03060' => 'Quatretondeta',
	'ES03061' => 'Daya Nueva',
	'ES03062' => 'Daya Vieja',
	'ES03067' => 'Facheca',
	'ES03068' => 'Famorca',
	'ES03070' => 'Formentera del Segura',
	'ES03072' => 'Gaianes',
	'ES03073' => 'Gorga',
	'ES03074' => 'Granja de Rocamora',
	'ES03075' => 'Castell de Guadalest, el',
	'ES03077' => 'Hondón de las Nieves',
	'ES03078' => 'Hondón de los Frailes',
	'ES03080' => 'Jacarilla',
	'ES03081' => 'Xaló',
	'ES03084' => 'Orxa, l',
	'ES03085' => 'Llíber',
	'ES03086' => 'Millena',
	'ES03091' => 'Murla',
	'ES03097' => 'Orba',
	'ES03098' => 'Orxeta',
	'ES03100' => 'Parcent',
	'ES03103' => 'Penàguila',
	'ES03106' => 'Planes',
	'ES03107' => 'Polop',
	'ES03109' => 'Rafal',
	'ES03110' => 'Ràfol dAlmúnia, el',
	'ES03112' => 'Relleu',
	'ES03114' => 'Romana, la',
	'ES03115' => 'Sagra',
	'ES03116' => 'Salinas',
	'ES03117' => 'Sanet y Negrals',
	'ES03124' => 'Sella',
	'ES03125' => 'Senija',
	'ES03127' => 'Tàrbena',
	'ES03129' => 'Tibi',
	'ES03130' => 'Tollos',
	'ES03131' => 'Tormos',
	'ES03132' => 'Torre de les Maçanes, la',
	'ES03134' => 'Vall dAlcalà, la',
	'ES03135' => 'Vall dEbo, la',
	'ES03136' => 'Vall de Gallinera',
	'ES03137' => 'Vall de Laguar, la',
	'ES03138' => 'Verger, el',
	'ES03901' => 'Poblets, els',
	'ES03903' => 'Montesinos, Los',
	'ES03904' => 'San Isidro',
	'ES04001' => 'Abla',
	'ES04002' => 'Abrucena',
	'ES04004' => 'Albanchez',
	'ES04005' => 'Alboloduy',
	'ES04007' => 'Alcolea',
	'ES04008' => 'Alcóntar',
	'ES04009' => 'Alcudia de Monteagud',
	'ES04010' => 'Alhabia',
	'ES04011' => 'Alhama de Almería',
	'ES04012' => 'Alicún',
	'ES04014' => 'Almócita',
	'ES04015' => 'Alsodux',
	'ES04016' => 'Antas',
	'ES04017' => 'Arboleas',
	'ES04018' => 'Armuña de Almanzora',
	'ES04019' => 'Bacares',
	'ES04020' => 'Bayárcal',
	'ES04021' => 'Bayarque',
	'ES04022' => 'Bédar',
	'ES04023' => 'Beires',
	'ES04024' => 'Benahadux',
	'ES04026' => 'Benitagla',
	'ES04027' => 'Benizalón',
	'ES04028' => 'Bentarique',
	'ES04030' => 'Canjáyar',
	'ES04031' => 'Cantoria',
	'ES04033' => 'Castro de Filabres',
	'ES04034' => 'Cóbdar',
	'ES04036' => 'Chercos',
	'ES04037' => 'Chirivel',
	'ES04038' => 'Dalías',
	'ES04041' => 'Enix',
	'ES04043' => 'Felix',
	'ES04044' => 'Fines',
	'ES04045' => 'Fiñana',
	'ES04046' => 'Fondón',
	'ES04047' => 'Gádor',
	'ES04048' => 'Gallardos, Los',
	'ES04050' => 'Gérgal',
	'ES04051' => 'Huécija',
	'ES04054' => 'Íllar',
	'ES04055' => 'Instinción',
	'ES04056' => 'Laroya',
	'ES04057' => 'Láujar de Andarax',
	'ES04058' => 'Líjar',
	'ES04059' => 'Lubrín',
	'ES04060' => 'Lucainena de las Torres',
	'ES04061' => 'Lúcar',
	'ES04063' => 'María',
	'ES04065' => 'Nacimiento',
	'ES04067' => 'Ohanes',
	'ES04068' => 'Olula de Castro',
	'ES04070' => 'Oria',
	'ES04071' => 'Padules',
	'ES04072' => 'Partaloa',
	'ES04073' => 'Paterna del Río',
	'ES04074' => 'Pechina',
	'ES04076' => 'Purchena',
	'ES04077' => 'Rágol',
	'ES04078' => 'Rioja',
	'ES04080' => 'Santa Cruz de Marchena',
	'ES04081' => 'Santa Fe de Mondújar',
	'ES04082' => 'Senés',
	'ES04083' => 'Serón',
	'ES04084' => 'Sierro',
	'ES04085' => 'Somontín',
	'ES04086' => 'Sorbas',
	'ES04087' => 'Suflí',
	'ES04088' => 'Tabernas',
	'ES04089' => 'Taberno',
	'ES04090' => 'Tahal',
	'ES04091' => 'Terque',
	'ES04092' => 'Tíjola',
	'ES04093' => 'Turre',
	'ES04094' => 'Turrillas',
	'ES04095' => 'Uleila del Campo',
	'ES04096' => 'Urrácal',
	'ES04097' => 'Velefique',
	'ES04098' => 'Vélez-Blanco',
	'ES04103' => 'Zurgena',
	'ES04901' => 'Tres Villas, Las',
	'ES04904' => 'Balanegra',
	'ES05001' => 'Adanero',
	'ES05002' => 'Adrada, La',
	'ES05005' => 'Albornos',
	'ES05007' => 'Aldeanueva de Santa Cruz',
	'ES05008' => 'Aldeaseca',
	'ES05010' => 'Aldehuela, La',
	'ES05012' => 'Amavida',
	'ES05013' => 'Arenal, El',
	'ES05015' => 'Arevalillo',
	'ES05017' => 'Aveinte',
	'ES05018' => 'Avellaneda',
	'ES05021' => 'Barco de Ávila, El',
	'ES05022' => 'Barraco, El',
	'ES05023' => 'Barromán',
	'ES05024' => 'Becedas',
	'ES05025' => 'Becedillas',
	'ES05026' => 'Bercial de Zapardiel',
	'ES05027' => 'Berlanas, Las',
	'ES05029' => 'Bernuy-Zapardiel',
	'ES05030' => 'Berrocalejo de Aragona',
	'ES05033' => 'Blascomillán',
	'ES05034' => 'Blasconuño de Matacabras',
	'ES05035' => 'Blascosancho',
	'ES05036' => 'Bohodón, El',
	'ES05037' => 'Bohoyo',
	'ES05038' => 'Bonilla de la Sierra',
	'ES05039' => 'Brabos',
	'ES05040' => 'Bularros',
	'ES05041' => 'Burgohondo',
	'ES05042' => 'Cabezas de Alambre',
	'ES05043' => 'Cabezas del Pozo',
	'ES05044' => 'Cabezas del Villar',
	'ES05045' => 'Cabizuela',
	'ES05046' => 'Canales',
	'ES05048' => 'Cantiveros',
	'ES05049' => 'Cardeñosa',
	'ES05051' => 'Carrera, La',
	'ES05052' => 'Casas del Puerto',
	'ES05053' => 'Casasola',
	'ES05054' => 'Casavieja',
	'ES05055' => 'Casillas',
	'ES05056' => 'Castellanos de Zapardiel',
	'ES05057' => 'Cebreros',
	'ES05058' => 'Cepeda la Mora',
	'ES05059' => 'Cillán',
	'ES05060' => 'Cisla',
	'ES05061' => 'Colilla, La',
	'ES05062' => 'Collado de Contreras',
	'ES05063' => 'Collado del Mirón',
	'ES05064' => 'Constanzana',
	'ES05065' => 'Crespos',
	'ES05066' => 'Cuevas del Valle',
	'ES05067' => 'Chamartín',
	'ES05069' => 'Donjimeno',
	'ES05070' => 'Donvidas',
	'ES05072' => 'Espinosa de los Caballeros',
	'ES05073' => 'Flores de Ávila',
	'ES05074' => 'Fontiveros',
	'ES05075' => 'Fresnedilla',
	'ES05076' => 'Fresno, El',
	'ES05077' => 'Fuente el Saúz',
	'ES05078' => 'Fuentes de Año',
	'ES05079' => 'Gallegos de Altamiros',
	'ES05080' => 'Gallegos de Sobrinos',
	'ES05081' => 'Garganta del Villar',
	'ES05082' => 'Gavilanes',
	'ES05083' => 'Gemuño',
	'ES05084' => 'Gilbuena',
	'ES05085' => 'Gil García',
	'ES05086' => 'Gimialcón',
	'ES05087' => 'Gotarrendura',
	'ES05088' => 'Grandes y San Martín',
	'ES05089' => 'Guisando',
	'ES05090' => 'Gutierre-Muñoz',
	'ES05092' => 'Hernansancho',
	'ES05093' => 'Herradón de Pinares',
	'ES05094' => 'Herreros de Suso',
	'ES05095' => 'Higuera de las Dueñas',
	'ES05096' => 'Hija de Dios, La',
	'ES05097' => 'Horcajada, La',
	'ES05099' => 'Horcajo de las Torres',
	'ES05100' => 'Hornillo, El',
	'ES05101' => 'Hoyocasero',
	'ES05102' => 'Hoyo de Pinares, El',
	'ES05103' => 'Hoyorredondo',
	'ES05104' => 'Hoyos del Collado',
	'ES05105' => 'Hoyos del Espino',
	'ES05106' => 'Hoyos de Miguel Muñoz',
	'ES05107' => 'Hurtumpascual',
	'ES05108' => 'Junciana',
	'ES05109' => 'Langa',
	'ES05110' => 'Lanzahíta',
	'ES05112' => 'Losar del Barco, El',
	'ES05113' => 'Llanos de Tormes, Los',
	'ES05114' => 'Madrigal de las Altas Torres',
	'ES05115' => 'Maello',
	'ES05116' => 'Malpartida de Corneja',
	'ES05117' => 'Mamblas',
	'ES05118' => 'Mancera de Arriba',
	'ES05119' => 'Manjabálago y Ortigosa de Rioalmar',
	'ES05120' => 'Marlín',
	'ES05121' => 'Martiherrero',
	'ES05122' => 'Martínez',
	'ES05123' => 'Mediana de Voltoya',
	'ES05124' => 'Medinilla',
	'ES05125' => 'Mengamuñoz',
	'ES05126' => 'Mesegar de Corneja',
	'ES05127' => 'Mijares',
	'ES05128' => 'Mingorría',
	'ES05129' => 'Mirón, El',
	'ES05130' => 'Mironcillo',
	'ES05131' => 'Mirueña de los Infanzones',
	'ES05132' => 'Mombeltrán',
	'ES05133' => 'Monsalupe',
	'ES05134' => 'Moraleja de Matacabras',
	'ES05135' => 'Muñana',
	'ES05136' => 'Muñico',
	'ES05138' => 'Muñogalindo',
	'ES05139' => 'Muñogrande',
	'ES05140' => 'Muñomer del Peco',
	'ES05141' => 'Muñopepe',
	'ES05142' => 'Muñosancho',
	'ES05143' => 'Muñotello',
	'ES05144' => 'Narrillos del Álamo',
	'ES05145' => 'Narrillos del Rebollar',
	'ES05147' => 'Narros del Castillo',
	'ES05148' => 'Narros del Puerto',
	'ES05149' => 'Narros de Saldueña',
	'ES05151' => 'Navacepedilla de Corneja',
	'ES05152' => 'Nava de Arévalo',
	'ES05153' => 'Nava del Barco',
	'ES05154' => 'Navadijos',
	'ES05155' => 'Navaescurial',
	'ES05156' => 'Navahondilla',
	'ES05157' => 'Navalacruz',
	'ES05158' => 'Navalmoral',
	'ES05159' => 'Navalonguilla',
	'ES05160' => 'Navalosa',
	'ES05161' => 'Navalperal de Pinares',
	'ES05162' => 'Navalperal de Tormes',
	'ES05163' => 'Navaluenga',
	'ES05164' => 'Navaquesera',
	'ES05165' => 'Navarredonda de Gredos',
	'ES05166' => 'Navarredondilla',
	'ES05167' => 'Navarrevisca',
	'ES05169' => 'Navatalgordo',
	'ES05170' => 'Navatejares',
	'ES05171' => 'Neila de San Miguel',
	'ES05172' => 'Niharra',
	'ES05173' => 'Ojos-Albos',
	'ES05174' => 'Orbita',
	'ES05175' => 'Oso, El',
	'ES05176' => 'Padiernos',
	'ES05177' => 'Pajares de Adaja',
	'ES05178' => 'Palacios de Goda',
	'ES05179' => 'Papatrigo',
	'ES05180' => 'Parral, El',
	'ES05181' => 'Pascualcobo',
	'ES05182' => 'Pedro Bernardo',
	'ES05183' => 'Pedro-Rodríguez',
	'ES05184' => 'Peguerinos',
	'ES05185' => 'Peñalba de Ávila',
	'ES05186' => 'Piedrahíta',
	'ES05187' => 'Piedralaves',
	'ES05188' => 'Poveda',
	'ES05189' => 'Poyales del Hoyo',
	'ES05190' => 'Pozanco',
	'ES05191' => 'Pradosegar',
	'ES05192' => 'Puerto Castilla',
	'ES05193' => 'Rasueros',
	'ES05194' => 'Riocabado',
	'ES05195' => 'Riofrío',
	'ES05196' => 'Rivilla de Barajas',
	'ES05197' => 'Salobral',
	'ES05198' => 'Salvadiós',
	'ES05199' => 'San Bartolomé de Béjar',
	'ES05200' => 'San Bartolomé de Corneja',
	'ES05201' => 'San Bartolomé de Pinares',
	'ES05204' => 'Sanchidrián',
	'ES05205' => 'Sanchorreja',
	'ES05206' => 'San Esteban de los Patos',
	'ES05207' => 'San Esteban del Valle',
	'ES05208' => 'San Esteban de Zapardiel',
	'ES05209' => 'San García de Ingelmos',
	'ES05210' => 'San Juan de la Encinilla',
	'ES05211' => 'San Juan de la Nava',
	'ES05212' => 'San Juan del Molinillo',
	'ES05213' => 'San Juan del Olmo',
	'ES05214' => 'San Lorenzo de Tormes',
	'ES05215' => 'San Martín de la Vega del Alberche',
	'ES05216' => 'San Martín del Pimpollar',
	'ES05217' => 'San Miguel de Corneja',
	'ES05218' => 'San Miguel de Serrezuela',
	'ES05219' => 'San Pascual',
	'ES05220' => 'San Pedro del Arroyo',
	'ES05221' => 'Santa Cruz del Valle',
	'ES05222' => 'Santa Cruz de Pinares',
	'ES05224' => 'Santa María del Arroyo',
	'ES05225' => 'Santa María del Berrocal',
	'ES05226' => 'Santa María de los Caballeros',
	'ES05227' => 'Santa María del Tiétar',
	'ES05228' => 'Santiago del Collado',
	'ES05229' => 'Santo Domingo de las Posadas',
	'ES05230' => 'Santo Tomé de Zabarcos',
	'ES05231' => 'San Vicente de Arévalo',
	'ES05232' => 'Serrada, La',
	'ES05233' => 'Serranillos',
	'ES05234' => 'Sigeres',
	'ES05235' => 'Sinlabajos',
	'ES05236' => 'Solana de Ávila',
	'ES05237' => 'Solana de Rioalmar',
	'ES05238' => 'Solosancho',
	'ES05239' => 'Sotalbo',
	'ES05240' => 'Sotillo de la Adrada',
	'ES05241' => 'Tiemblo, El',
	'ES05242' => 'Tiñosillos',
	'ES05243' => 'Tolbaños',
	'ES05244' => 'Tormellas',
	'ES05245' => 'Tornadizos de Ávila',
	'ES05246' => 'Tórtoles',
	'ES05247' => 'Torre, La',
	'ES05249' => 'Umbrías',
	'ES05251' => 'Vadillo de la Sierra',
	'ES05252' => 'Valdecasa',
	'ES05253' => 'Vega de Santa María',
	'ES05254' => 'Velayos',
	'ES05256' => 'Villaflor',
	'ES05257' => 'Villafranca de la Sierra',
	'ES05258' => 'Villanueva de Gómez',
	'ES05259' => 'Villanueva del Aceral',
	'ES05260' => 'Villanueva del Campillo',
	'ES05261' => 'Villar de Corneja',
	'ES05262' => 'Villarejo del Valle',
	'ES05263' => 'Villatoro',
	'ES05264' => 'Viñegra de Moraña',
	'ES05265' => 'Vita',
	'ES05266' => 'Zapardiel de la Cañada',
	'ES05267' => 'Zapardiel de la Ribera',
	'ES05901' => 'San Juan de Gredos',
	'ES05902' => 'Santa María del Cubillo',
	'ES05903' => 'Diego del Carpio',
	'ES05904' => 'Santiago del Tormes',
	'ES05905' => 'Villanueva de Ávila',
	'ES06001' => 'Acedera',
	'ES06003' => 'Ahillones',
	'ES06004' => 'Alange',
	'ES06005' => 'Albuera, La',
	'ES06007' => 'Alconchel',
	'ES06008' => 'Alconera',
	'ES06009' => 'Aljucén',
	'ES06010' => 'Almendral',
	'ES06012' => 'Arroyo de San Serván',
	'ES06013' => 'Atalaya',
	'ES06016' => 'Barcarrota',
	'ES06017' => 'Baterno',
	'ES06018' => 'Benquerencia de la Serena',
	'ES06019' => 'Berlanga',
	'ES06020' => 'Bienvenida',
	'ES06021' => 'Bodonal de la Sierra',
	'ES06022' => 'Burguillos del Cerro',
	'ES06023' => 'Cabeza del Buey',
	'ES06024' => 'Cabeza la Vaca',
	'ES06026' => 'Calera de León',
	'ES06027' => 'Calzadilla de los Barros',
	'ES06028' => 'Campanario',
	'ES06029' => 'Campillo de Llerena',
	'ES06030' => 'Capilla',
	'ES06031' => 'Carmonita',
	'ES06032' => 'Carrascalejo, El',
	'ES06033' => 'Casas de Don Pedro',
	'ES06034' => 'Casas de Reina',
	'ES06035' => 'Castilblanco',
	'ES06037' => 'Codosera, La',
	'ES06038' => 'Cordobilla de Lácara',
	'ES06039' => 'Coronada, La',
	'ES06040' => 'Corte de Peleas',
	'ES06041' => 'Cristina',
	'ES06042' => 'Cheles',
	'ES06043' => 'Don Álvaro',
	'ES06045' => 'Entrín Bajo',
	'ES06046' => 'Esparragalejo',
	'ES06047' => 'Esparragosa de la Serena',
	'ES06048' => 'Esparragosa de Lares',
	'ES06049' => 'Feria',
	'ES06050' => 'Fregenal de la Sierra',
	'ES06051' => 'Fuenlabrada de los Montes',
	'ES06052' => 'Fuente de Cantos',
	'ES06053' => 'Fuente del Arco',
	'ES06055' => 'Fuentes de León',
	'ES06056' => 'Garbayuela',
	'ES06057' => 'Garlitos',
	'ES06058' => 'Garrovilla, La',
	'ES06059' => 'Granja de Torrehermosa',
	'ES06061' => 'Haba, La',
	'ES06062' => 'Helechosa de los Montes',
	'ES06063' => 'Herrera del Duque',
	'ES06064' => 'Higuera de la Serena',
	'ES06065' => 'Higuera de Llerena',
	'ES06066' => 'Higuera de Vargas',
	'ES06067' => 'Higuera la Real',
	'ES06068' => 'Hinojosa del Valle',
	'ES06069' => 'Hornachos',
	'ES06071' => 'Lapa, La',
	'ES06072' => 'Lobón',
	'ES06073' => 'Llera',
	'ES06075' => 'Magacela',
	'ES06076' => 'Maguilla',
	'ES06077' => 'Malcocinado',
	'ES06078' => 'Malpartida de la Serena',
	'ES06079' => 'Manchita',
	'ES06080' => 'Medellín',
	'ES06081' => 'Medina de las Torres',
	'ES06082' => 'Mengabril',
	'ES06084' => 'Mirandilla',
	'ES06085' => 'Monesterio',
	'ES06086' => 'Montemolín',
	'ES06087' => 'Monterrubio de la Serena',
	'ES06089' => 'Morera, La',
	'ES06090' => 'Nava de Santiago, La',
	'ES06091' => 'Navalvillar de Pela',
	'ES06092' => 'Nogales',
	'ES06094' => 'Oliva de Mérida',
	'ES06096' => 'Orellana de la Sierra',
	'ES06097' => 'Orellana la Vieja',
	'ES06098' => 'Palomas',
	'ES06099' => 'Parra, La',
	'ES06100' => 'Peñalsordo',
	'ES06101' => 'Peraleda del Zaucejo',
	'ES06102' => 'Puebla de Alcocer',
	'ES06104' => 'Puebla de la Reina',
	'ES06105' => 'Puebla del Maestre',
	'ES06106' => 'Puebla del Prior',
	'ES06107' => 'Puebla de Obando',
	'ES06108' => 'Puebla de Sancho Pérez',
	'ES06109' => 'Quintana de la Serena',
	'ES06110' => 'Reina',
	'ES06111' => 'Rena',
	'ES06112' => 'Retamal de Llerena',
	'ES06113' => 'Ribera del Fresno',
	'ES06114' => 'Risco',
	'ES06115' => 'Roca de la Sierra, La',
	'ES06116' => 'Salvaleón',
	'ES06117' => 'Salvatierra de los Barros',
	'ES06118' => 'Sancti-Spíritus',
	'ES06119' => 'San Pedro de Mérida',
	'ES06120' => 'Santa Amalia',
	'ES06121' => 'Santa Marta',
	'ES06124' => 'Segura de León',
	'ES06125' => 'Siruela',
	'ES06126' => 'Solana de los Barros',
	'ES06127' => 'Talarrubias',
	'ES06129' => 'Táliga',
	'ES06130' => 'Tamurejo',
	'ES06131' => 'Torre de Miguel Sesmero',
	'ES06132' => 'Torremayor',
	'ES06133' => 'Torremejía',
	'ES06134' => 'Trasierra',
	'ES06135' => 'Trujillanos',
	'ES06136' => 'Usagre',
	'ES06137' => 'Valdecaballeros',
	'ES06138' => 'Valdetorres',
	'ES06139' => 'Valencia de las Torres',
	'ES06140' => 'Valencia del Mombuey',
	'ES06141' => 'Valencia del Ventoso',
	'ES06142' => 'Valverde de Burguillos',
	'ES06143' => 'Valverde de Leganés',
	'ES06144' => 'Valverde de Llerena',
	'ES06145' => 'Valverde de Mérida',
	'ES06146' => 'Valle de la Serena',
	'ES06147' => 'Valle de Matamoros',
	'ES06148' => 'Valle de Santa Ana',
	'ES06150' => 'Villagarcía de la Torre',
	'ES06151' => 'Villagonzalo',
	'ES06152' => 'Villalba de los Barros',
	'ES06154' => 'Villanueva del Fresno',
	'ES06155' => 'Villar del Rey',
	'ES06156' => 'Villar de Rena',
	'ES06157' => 'Villarta de los Montes',
	'ES06159' => 'Zahínos',
	'ES06160' => 'Zalamea de la Serena',
	'ES06161' => 'Zarza-Capilla',
	'ES06162' => 'Zarza, La',
	'ES06901' => 'Valdelacalzada',
	'ES06902' => 'Pueblonuevo del Guadiana',
	'ES06903' => 'Guadiana del Caudillo',
	'ES07007' => 'Banyalbufar',
	'ES07009' => 'Búger',
	'ES07012' => 'Campanet',
	'ES07016' => 'Consell',
	'ES07017' => 'Costitx',
	'ES07018' => 'Deià',
	'ES07019' => 'Escorca',
	'ES07021' => 'Estellencs',
	'ES07023' => 'Ferreries',
	'ES07025' => 'Fornalutx',
	'ES07028' => 'Lloret de Vistalegre',
	'ES07030' => 'Llubí',
	'ES07034' => 'Mancor de la Vall',
	'ES07035' => 'Maria de la Salut',
	'ES07038' => 'Montuïri',
	'ES07041' => 'Petra',
	'ES07045' => 'Puigpunyent',
	'ES07047' => 'Sencelles',
	'ES07049' => 'Sant Joan',
	'ES07053' => 'Santa Eugènia',
	'ES07058' => 'Selva',
	'ES07059' => 'Salines, Ses',
	'ES07060' => 'Sineu',
	'ES07063' => 'Valldemossa',
	'ES07065' => 'Vilafranca de Bonany',
	'ES07901' => 'Ariany',
	'ES07902' => 'Migjorn Gran, Es',
	'ES08002' => 'Aguilar de Segarra',
	'ES08004' => 'Alpens',
	'ES08008' => 'Argençola',
	'ES08011' => 'Avià',
	'ES08012' => 'Avinyó',
	'ES08013' => 'Avinyonet del Penedès',
	'ES08014' => 'Aiguafreda',
	'ES08016' => 'Bagà',
	'ES08017' => 'Balenyà',
	'ES08018' => 'Balsareny',
	'ES08021' => 'Bellprat',
	'ES08024' => 'Borredà',
	'ES08025' => 'Bruc, El',
	'ES08026' => 'Brull, El',
	'ES08027' => 'Cabanyes, Les',
	'ES08028' => 'Cabrera dAnoia',
	'ES08029' => 'Cabrera de Mar',
	'ES08031' => 'Calaf',
	'ES08032' => 'Caldes dEstrac',
	'ES08034' => 'Calders',
	'ES08036' => 'Calonge de Segarra',
	'ES08037' => 'Calldetenes',
	'ES08038' => 'Callús',
	'ES08039' => 'Campins',
	'ES08042' => 'Cànoves i Samalús',
	'ES08043' => 'Canyelles',
	'ES08045' => 'Capolat',
	'ES08047' => 'Cardona',
	'ES08048' => 'Carme',
	'ES08049' => 'Casserres',
	'ES08050' => 'Castellar del Riu',
	'ES08052' => 'Castellar de nHug',
	'ES08053' => 'Castellbell i el Vilar',
	'ES08055' => 'Castellcir',
	'ES08057' => 'Castell de lAreny',
	'ES08058' => 'Castellet i la Gornal',
	'ES08059' => 'Castellfollit del Boix',
	'ES08060' => 'Castellfollit de Riubregós',
	'ES08061' => 'Castellgalí',
	'ES08062' => 'Castellnou de Bages',
	'ES08063' => 'Castellolí',
	'ES08064' => 'Castellterçol',
	'ES08065' => 'Castellví de la Marca',
	'ES08066' => 'Castellví de Rosanes',
	'ES08069' => 'Collbató',
	'ES08070' => 'Collsuspina',
	'ES08071' => 'Copons',
	'ES08078' => 'Espunyola, L',
	'ES08079' => 'Estany, L',
	'ES08080' => 'Fígols',
	'ES08081' => 'Fogars de Montclús',
	'ES08082' => 'Fogars de la Selva',
	'ES08083' => 'Folgueroles',
	'ES08084' => 'Fonollosa',
	'ES08085' => 'Font-rubí',
	'ES08087' => 'Gallifa',
	'ES08090' => 'Gaià',
	'ES08092' => 'Gironella',
	'ES08093' => 'Gisclareny',
	'ES08094' => 'Granada, La',
	'ES08095' => 'Granera',
	'ES08097' => 'Gualba',
	'ES08098' => 'Sant Salvador de Guardiola',
	'ES08099' => 'Guardiola de Berguedà',
	'ES08100' => 'Gurb',
	'ES08103' => 'Jorba',
	'ES08104' => 'Llacuna, La',
	'ES08109' => 'Lluçà',
	'ES08111' => 'Malla',
	'ES08115' => 'Martorelles',
	'ES08116' => 'Masies de Roda, Les',
	'ES08117' => 'Masies de Voltregà, Les',
	'ES08122' => 'Mediona',
	'ES08127' => 'Monistrol de Montserrat',
	'ES08128' => 'Monistrol de Calders',
	'ES08129' => 'Muntanyola',
	'ES08130' => 'Montclar',
	'ES08131' => 'Montesquiu',
	'ES08132' => 'Montmajor',
	'ES08133' => 'Montmaneu',
	'ES08134' => 'Figaró-Montmany',
	'ES08137' => 'Montseny',
	'ES08139' => 'Mura',
	'ES08142' => 'Nou de Berguedà, La',
	'ES08143' => 'Òdena',
	'ES08144' => 'Olvan',
	'ES08145' => 'Olèrdola',
	'ES08146' => 'Olesa de Bonesvalls',
	'ES08148' => 'Olivella',
	'ES08149' => 'Olost',
	'ES08150' => 'Orís',
	'ES08151' => 'Oristà',
	'ES08152' => 'Orpí',
	'ES08153' => 'Òrrius',
	'ES08154' => 'Pacs del Penedès',
	'ES08158' => 'Papiol, El',
	'ES08160' => 'Perafita',
	'ES08162' => 'Hostalets de Pierola, Els',
	'ES08164' => 'Pla del Penedès, El',
	'ES08165' => 'Pobla de Claramunt, La',
	'ES08166' => 'Pobla de Lillet, La',
	'ES08168' => 'Pontons',
	'ES08170' => 'Prats de Rei, Els',
	'ES08171' => 'Prats de Lluçanès',
	'ES08174' => 'Puigdàlber',
	'ES08175' => 'Puig-reig',
	'ES08176' => 'Pujalt',
	'ES08177' => 'Quar, La',
	'ES08178' => 'Rajadell',
	'ES08179' => 'Rellinars',
	'ES08182' => 'Pont de Vilomara i Rocafort, El,',
	'ES08185' => 'Rubió',
	'ES08188' => 'Sagàs',
	'ES08189' => 'Sant Pere Sallavinera',
	'ES08190' => 'Saldes',
	'ES08193' => 'Sant Iscle de Vallalta',
	'ES08195' => 'Sant Agustí de Lluçanès',
	'ES08199' => 'Sant Bartomeu del Grau',
	'ES08201' => 'Sant Boi de Lluçanès',
	'ES08203' => 'Sant Cebrià de Vallalta',
	'ES08204' => 'Sant Climent de Llobregat',
	'ES08206' => 'Sant Cugat Sesgarrigues',
	'ES08207' => 'Sant Esteve de Palautordera',
	'ES08212' => 'Sant Feliu Sasserra',
	'ES08215' => 'Sant Hipòlit de Voltregà',
	'ES08216' => 'Sant Jaume de Frontanyà',
	'ES08220' => 'Sant Julià de Vilatorta',
	'ES08222' => 'Sant Llorenç dHortons',
	'ES08223' => 'Sant Llorenç Savall',
	'ES08224' => 'Sant Martí de Centelles',
	'ES08225' => 'Sant Martí dAlbars',
	'ES08226' => 'Sant Martí de Tous',
	'ES08227' => 'Sant Martí Sarroca',
	'ES08228' => 'Sant Martí Sesgueioles',
	'ES08229' => 'Sant Mateu de Bages',
	'ES08232' => 'Sant Pere de Riudebitlles',
	'ES08233' => 'Sant Pere de Torelló',
	'ES08234' => 'Sant Pere de Vilamajor',
	'ES08236' => 'Sant Quintí de Mediona',
	'ES08237' => 'Sant Quirze de Besora',
	'ES08239' => 'Sant Quirze Safaja',
	'ES08241' => 'Sant Sadurní dOsormort',
	'ES08242' => 'Marganell',
	'ES08243' => 'Santa Cecília de Voltregà',
	'ES08246' => 'Santa Eugènia de Berga',
	'ES08247' => 'Santa Eulàlia de Riuprimer',
	'ES08249' => 'Santa Fe del Penedès',
	'ES08253' => 'Santa Maria de Besora',
	'ES08254' => 'Esquirol, L',
	'ES08255' => 'Santa Maria de Merlès',
	'ES08256' => 'Santa Maria de Martorelles',
	'ES08257' => 'Santa Maria de Miralles',
	'ES08258' => 'Santa Maria dOló',
	'ES08261' => 'Santa Susanna',
	'ES08265' => 'Sant Vicenç de Torelló',
	'ES08268' => 'Cercs',
	'ES08269' => 'Seva',
	'ES08271' => 'Sobremunt',
	'ES08272' => 'Sora',
	'ES08273' => 'Subirats',
	'ES08275' => 'Tavèrnoles',
	'ES08276' => 'Tagamanent',
	'ES08277' => 'Talamanca',
	'ES08280' => 'Tavertet',
	'ES08286' => 'Torre de Claramunt, La',
	'ES08287' => 'Torrelavit',
	'ES08288' => 'Torrelles de Foix',
	'ES08290' => 'Ullastrell',
	'ES08292' => 'Vallbona dAnoia',
	'ES08293' => 'Vallcebre',
	'ES08294' => 'Vallgorguina',
	'ES08296' => 'Vallromanes',
	'ES08297' => 'Veciana',
	'ES08299' => 'Vilada',
	'ES08303' => 'Vilanova de Sau',
	'ES08304' => 'Vilobí del Penedès',
	'ES08306' => 'Vilalba Sasserra',
	'ES08308' => 'Viver i Serrateix',
	'ES08901' => 'Rupit i Pruit',
	'ES08903' => 'Sant Julià de Cerdanyola',
	'ES08905' => 'Palma de Cervelló, La',
	'ES09001' => 'Abajas',
	'ES09003' => 'Adrada de Haza',
	'ES09006' => 'Aguas Cándidas',
	'ES09007' => 'Aguilar de Bureba',
	'ES09009' => 'Albillos',
	'ES09010' => 'Alcocero de Mola',
	'ES09011' => 'Alfoz de Bricia',
	'ES09012' => 'Alfoz de Santa Gadea',
	'ES09013' => 'Altable',
	'ES09014' => 'Altos, Los',
	'ES09016' => 'Ameyugo',
	'ES09017' => 'Anguix',
	'ES09019' => 'Arandilla',
	'ES09020' => 'Arauzo de Miel',
	'ES09021' => 'Arauzo de Salce',
	'ES09022' => 'Arauzo de Torre',
	'ES09023' => 'Arcos',
	'ES09024' => 'Arenillas de Riopisuerga',
	'ES09025' => 'Arija',
	'ES09026' => 'Arlanzón',
	'ES09027' => 'Arraya de Oca',
	'ES09029' => 'Atapuerca',
	'ES09030' => 'Ausines, Los',
	'ES09032' => 'Avellanosa de Muñó',
	'ES09033' => 'Bahabón de Esgueva',
	'ES09034' => 'Balbases, Los',
	'ES09035' => 'Baños de Valdearados',
	'ES09036' => 'Bañuelos de Bureba',
	'ES09037' => 'Barbadillo de Herreros',
	'ES09038' => 'Barbadillo del Mercado',
	'ES09039' => 'Barbadillo del Pez',
	'ES09041' => 'Barrio de Muñó',
	'ES09043' => 'Barrios de Bureba, Los',
	'ES09044' => 'Barrios de Colina',
	'ES09045' => 'Basconcillos del Tozo',
	'ES09046' => 'Bascuñana',
	'ES09047' => 'Belbimbre',
	'ES09048' => 'Belorado',
	'ES09050' => 'Berberana',
	'ES09051' => 'Berlangas de Roa',
	'ES09052' => 'Berzosa de Bureba',
	'ES09054' => 'Bozoó',
	'ES09055' => 'Brazacorta',
	'ES09057' => 'Bugedo',
	'ES09058' => 'Buniel',
	'ES09060' => 'Busto de Bureba',
	'ES09061' => 'Cabañes de Esgueva',
	'ES09062' => 'Cabezón de la Sierra',
	'ES09063' => 'Cavia',
	'ES09064' => 'Caleruega',
	'ES09065' => 'Campillo de Aranda',
	'ES09066' => 'Campolara',
	'ES09067' => 'Canicosa de la Sierra',
	'ES09068' => 'Cantabrana',
	'ES09070' => 'Carazo',
	'ES09071' => 'Carcedo de Bureba',
	'ES09072' => 'Carcedo de Burgos',
	'ES09073' => 'Cardeñadijo',
	'ES09074' => 'Cardeñajimeno',
	'ES09075' => 'Cardeñuela Riopico',
	'ES09076' => 'Carrias',
	'ES09077' => 'Cascajares de Bureba',
	'ES09078' => 'Cascajares de la Sierra',
	'ES09079' => 'Castellanos de Castro',
	'ES09082' => 'Castildelgado',
	'ES09083' => 'Castil de Peones',
	'ES09084' => 'Castrillo de la Reina',
	'ES09085' => 'Castrillo de la Vega',
	'ES09086' => 'Castrillo del Val',
	'ES09088' => 'Castrillo de Riopisuerga',
	'ES09090' => 'Castrillo Mota de Judíos',
	'ES09091' => 'Castrojeriz',
	'ES09093' => 'Cayuela',
	'ES09094' => 'Cebrecos',
	'ES09095' => 'Celada del Camino',
	'ES09098' => 'Cerezo de Río Tirón',
	'ES09100' => 'Cerratón de Juarros',
	'ES09101' => 'Ciadoncha',
	'ES09102' => 'Cillaperlata',
	'ES09103' => 'Cilleruelo de Abajo',
	'ES09104' => 'Cilleruelo de Arriba',
	'ES09105' => 'Ciruelos de Cervera',
	'ES09108' => 'Cogollos',
	'ES09109' => 'Condado de Treviño',
	'ES09110' => 'Contreras',
	'ES09112' => 'Coruña del Conde',
	'ES09113' => 'Covarrubias',
	'ES09114' => 'Cubillo del Campo',
	'ES09115' => 'Cubo de Bureba',
	'ES09117' => 'Cueva de Roa, La',
	'ES09119' => 'Cuevas de San Clemente',
	'ES09120' => 'Encío',
	'ES09122' => 'Espinosa de Cervera',
	'ES09123' => 'Espinosa del Camino',
	'ES09124' => 'Espinosa de los Monteros',
	'ES09125' => 'Estépar',
	'ES09127' => 'Fontioso',
	'ES09128' => 'Frandovínez',
	'ES09129' => 'Fresneda de la Sierra Tirón',
	'ES09130' => 'Fresneña',
	'ES09131' => 'Fresnillo de las Dueñas',
	'ES09132' => 'Fresno de Río Tirón',
	'ES09133' => 'Fresno de Rodilla',
	'ES09134' => 'Frías',
	'ES09135' => 'Fuentebureba',
	'ES09136' => 'Fuentecén',
	'ES09137' => 'Fuentelcésped',
	'ES09138' => 'Fuentelisendo',
	'ES09139' => 'Fuentemolinos',
	'ES09140' => 'Fuentenebro',
	'ES09141' => 'Fuentespina',
	'ES09143' => 'Galbarros',
	'ES09144' => 'Gallega, La',
	'ES09148' => 'Grijalba',
	'ES09149' => 'Grisaleña',
	'ES09151' => 'Gumiel de Izán',
	'ES09152' => 'Gumiel de Mercado',
	'ES09154' => 'Hacinas',
	'ES09155' => 'Haza',
	'ES09159' => 'Hontanas',
	'ES09160' => 'Hontangas',
	'ES09162' => 'Hontoria de la Cantera',
	'ES09163' => 'Hontoria del Pinar',
	'ES09164' => 'Hontoria de Valdearados',
	'ES09166' => 'Hormazas, Las',
	'ES09167' => 'Hornillos del Camino',
	'ES09168' => 'Horra, La',
	'ES09169' => 'Hortigüela',
	'ES09170' => 'Hoyales de Roa',
	'ES09172' => 'Huérmeces',
	'ES09173' => 'Huerta de Arriba',
	'ES09174' => 'Huerta de Rey',
	'ES09175' => 'Humada',
	'ES09176' => 'Hurones',
	'ES09177' => 'Ibeas de Juarros',
	'ES09178' => 'Ibrillos',
	'ES09179' => 'Iglesiarrubia',
	'ES09180' => 'Iglesias',
	'ES09181' => 'Isar',
	'ES09182' => 'Itero del Castillo',
	'ES09183' => 'Jaramillo de la Fuente',
	'ES09184' => 'Jaramillo Quemado',
	'ES09189' => 'Junta de Traslaloma',
	'ES09190' => 'Junta de Villalba de Losa',
	'ES09191' => 'Jurisdicción de Lara',
	'ES09192' => 'Jurisdicción de San Zadornil',
	'ES09194' => 'Lerma',
	'ES09195' => 'Llano de Bureba',
	'ES09196' => 'Madrigal del Monte',
	'ES09197' => 'Madrigalejo del Monte',
	'ES09198' => 'Mahamud',
	'ES09199' => 'Mambrilla de Castrejón',
	'ES09200' => 'Mambrillas de Lara',
	'ES09201' => 'Mamolar',
	'ES09202' => 'Manciles',
	'ES09206' => 'Mazuela',
	'ES09208' => 'Mecerreyes',
	'ES09211' => 'Melgar de Fernamental',
	'ES09213' => 'Merindad de Cuesta-Urria',
	'ES09214' => 'Merindad de Montija',
	'ES09215' => 'Merindad de Sotoscueva',
	'ES09216' => 'Merindad de Valdeporres',
	'ES09217' => 'Merindad de Valdivielso',
	'ES09218' => 'Milagros',
	'ES09220' => 'Miraveche',
	'ES09221' => 'Modúbar de la Emparedada',
	'ES09223' => 'Monasterio de la Sierra',
	'ES09224' => 'Monasterio de Rodilla',
	'ES09225' => 'Moncalvillo',
	'ES09226' => 'Monterrubio de la Demanda',
	'ES09227' => 'Montorio',
	'ES09228' => 'Moradillo de Roa',
	'ES09229' => 'Nava de Roa',
	'ES09230' => 'Navas de Bureba',
	'ES09231' => 'Nebreda',
	'ES09232' => 'Neila',
	'ES09235' => 'Olmedillo de Roa',
	'ES09236' => 'Olmillos de Muñó',
	'ES09238' => 'Oña',
	'ES09239' => 'Oquillas',
	'ES09241' => 'Orbaneja Riopico',
	'ES09242' => 'Padilla de Abajo',
	'ES09243' => 'Padilla de Arriba',
	'ES09244' => 'Padrones de Bureba',
	'ES09246' => 'Palacios de la Sierra',
	'ES09247' => 'Palacios de Riopisuerga',
	'ES09248' => 'Palazuelos de la Sierra',
	'ES09249' => 'Palazuelos de Muñó',
	'ES09250' => 'Pampliega',
	'ES09251' => 'Pancorbo',
	'ES09253' => 'Pardilla',
	'ES09255' => 'Partido de la Sierra en Tobalina),',
	'ES09256' => 'Pedrosa de Duero',
	'ES09257' => 'Pedrosa del Páramo',
	'ES09258' => 'Pedrosa del Príncipe',
	'ES09259' => 'Pedrosa de Río Úrbel',
	'ES09261' => 'Peñaranda de Duero',
	'ES09262' => 'Peral de Arlanza',
	'ES09265' => 'Piérnigas',
	'ES09266' => 'Pineda de la Sierra',
	'ES09267' => 'Pineda Trasmonte',
	'ES09268' => 'Pinilla de los Barruecos',
	'ES09269' => 'Pinilla de los Moros',
	'ES09270' => 'Pinilla Trasmonte',
	'ES09272' => 'Poza de la Sal',
	'ES09273' => 'Prádanos de Bureba',
	'ES09274' => 'Pradoluengo',
	'ES09275' => 'Presencio',
	'ES09276' => 'Puebla de Arganzón, La',
	'ES09277' => 'Puentedura',
	'ES09279' => 'Quemada',
	'ES09280' => 'Quintanabureba',
	'ES09281' => 'Quintana del Pidio',
	'ES09283' => 'Quintanaélez',
	'ES09287' => 'Quintanaortuño',
	'ES09288' => 'Quintanapalla',
	'ES09289' => 'Quintanar de la Sierra',
	'ES09292' => 'Quintanavides',
	'ES09294' => 'Quintanilla de la Mata',
	'ES09295' => 'Quintanilla del Coco',
	'ES09297' => 'Quintanillas, Las',
	'ES09298' => 'Quintanilla San García',
	'ES09301' => 'Quintanilla Vivar',
	'ES09302' => 'Rabanera del Pinar',
	'ES09303' => 'Rábanos',
	'ES09304' => 'Rabé de las Calzadas',
	'ES09306' => 'Rebolledo de la Torre',
	'ES09307' => 'Redecilla del Camino',
	'ES09308' => 'Redecilla del Campo',
	'ES09309' => 'Regumiel de la Sierra',
	'ES09310' => 'Reinoso',
	'ES09311' => 'Retuerta',
	'ES09312' => 'Revilla y Ahedo, La',
	'ES09314' => 'Revilla del Campo',
	'ES09315' => 'Revillarruz',
	'ES09316' => 'Revilla Vallejera',
	'ES09317' => 'Rezmondo',
	'ES09318' => 'Riocavado de la Sierra',
	'ES09321' => 'Roa',
	'ES09323' => 'Rojas',
	'ES09325' => 'Royuela de Río Franco',
	'ES09326' => 'Rubena',
	'ES09327' => 'Rublacedo de Abajo',
	'ES09328' => 'Rucandio',
	'ES09329' => 'Salas de Bureba',
	'ES09330' => 'Salas de los Infantes',
	'ES09332' => 'Saldaña de Burgos',
	'ES09334' => 'Salinillas de Bureba',
	'ES09335' => 'San Adrián de Juarros',
	'ES09337' => 'San Juan del Monte',
	'ES09338' => 'San Mamés de Burgos',
	'ES09339' => 'San Martín de Rubiales',
	'ES09340' => 'San Millán de Lara',
	'ES09343' => 'Santa Cecilia',
	'ES09345' => 'Santa Cruz de la Salceda',
	'ES09346' => 'Santa Cruz del Valle Urbión',
	'ES09347' => 'Santa Gadea del Cid',
	'ES09348' => 'Santa Inés',
	'ES09350' => 'Santa María del Campo',
	'ES09351' => 'Santa María del Invierno',
	'ES09352' => 'Santa María del Mercadillo',
	'ES09353' => 'Santa María Rivarredonda',
	'ES09354' => 'Santa Olalla de Bureba',
	'ES09355' => 'Santibáñez de Esgueva',
	'ES09356' => 'Santibáñez del Val',
	'ES09358' => 'Santo Domingo de Silos',
	'ES09360' => 'San Vicente del Valle',
	'ES09361' => 'Sargentes de la Lora',
	'ES09362' => 'Sarracín',
	'ES09363' => 'Sasamón',
	'ES09365' => 'Sequera de Haza, La',
	'ES09366' => 'Solarana',
	'ES09368' => 'Sordillos',
	'ES09369' => 'Sotillo de la Ribera',
	'ES09372' => 'Sotragero',
	'ES09373' => 'Sotresgudo',
	'ES09374' => 'Susinos del Páramo',
	'ES09375' => 'Tamarón',
	'ES09377' => 'Tardajos',
	'ES09378' => 'Tejada',
	'ES09380' => 'Terradillos de Esgueva',
	'ES09381' => 'Tinieblas de la Sierra',
	'ES09382' => 'Tobar',
	'ES09384' => 'Tordómar',
	'ES09386' => 'Torrecilla del Monte',
	'ES09387' => 'Torregalindo',
	'ES09388' => 'Torrelara',
	'ES09389' => 'Torrepadre',
	'ES09390' => 'Torresandino',
	'ES09391' => 'Tórtoles de Esgueva',
	'ES09392' => 'Tosantos',
	'ES09394' => 'Trespaderne',
	'ES09395' => 'Tubilla del Agua',
	'ES09396' => 'Tubilla del Lago',
	'ES09398' => 'Úrbel del Castillo',
	'ES09400' => 'Vadocondes',
	'ES09403' => 'Valdeande',
	'ES09405' => 'Valdezate',
	'ES09406' => 'Valdorros',
	'ES09407' => 'Valmala',
	'ES09408' => 'Vallarta de Bureba',
	'ES09409' => 'Valle de Manzanedo',
	'ES09410' => 'Valle de Mena',
	'ES09411' => 'Valle de Oca',
	'ES09412' => 'Valle de Tobalina',
	'ES09413' => 'Valle de Valdebezana',
	'ES09414' => 'Valle de Valdelaguna',
	'ES09415' => 'Valle de Valdelucio',
	'ES09416' => 'Valle de Zamanzas',
	'ES09417' => 'Vallejera',
	'ES09418' => 'Valles de Palenzuela',
	'ES09419' => 'Valluércanes',
	'ES09421' => 'Vid y Barrios, La',
	'ES09422' => 'Vid de Bureba, La',
	'ES09423' => 'Vileña',
	'ES09424' => 'Viloria de Rioja',
	'ES09425' => 'Vilviestre del Pinar',
	'ES09427' => 'Villadiego',
	'ES09428' => 'Villaescusa de Roa',
	'ES09429' => 'Villaescusa la Sombría',
	'ES09430' => 'Villaespasa',
	'ES09431' => 'Villafranca Montes de Oca',
	'ES09432' => 'Villafruela',
	'ES09433' => 'Villagalijo',
	'ES09434' => 'Villagonzalo Pedernales',
	'ES09437' => 'Villahoz',
	'ES09438' => 'Villalba de Duero',
	'ES09439' => 'Villalbilla de Burgos',
	'ES09440' => 'Villalbilla de Gumiel',
	'ES09441' => 'Villaldemiro',
	'ES09442' => 'Villalmanzo',
	'ES09443' => 'Villamayor de los Montes',
	'ES09444' => 'Villamayor de Treviño',
	'ES09445' => 'Villambistia',
	'ES09446' => 'Villamedianilla',
	'ES09447' => 'Villamiel de la Sierra',
	'ES09448' => 'Villangómez',
	'ES09449' => 'Villanueva de Argaño',
	'ES09450' => 'Villanueva de Carazo',
	'ES09451' => 'Villanueva de Gumiel',
	'ES09454' => 'Villanueva de Teba',
	'ES09455' => 'Villaquirán de la Puebla',
	'ES09456' => 'Villaquirán de los Infantes',
	'ES09458' => 'Villariezo',
	'ES09460' => 'Villasandino',
	'ES09463' => 'Villasur de Herreros',
	'ES09464' => 'Villatuelda',
	'ES09466' => 'Villaverde del Monte',
	'ES09467' => 'Villaverde-Mogina',
	'ES09471' => 'Villayerno Morquillas',
	'ES09472' => 'Villazopeque',
	'ES09473' => 'Villegas',
	'ES09476' => 'Villoruebo',
	'ES09478' => 'Vizcaínos',
	'ES09480' => 'Zael',
	'ES09482' => 'Zarzosa de Río Pisuerga',
	'ES09483' => 'Zazuar',
	'ES09485' => 'Zuñeda',
	'ES09901' => 'Quintanilla del Agua y Tordueles),',
	'ES09902' => 'Valle de Santibáñez',
	'ES09903' => 'Villarcayo de Merindad de Castilla la Viejaocommerce',
	'ES09904' => 'Valle de las Navas',
	'ES09905' => 'Valle de Sedano',
	'ES09906' => 'Merindad de Río Ubierna',
	'ES09907' => 'Alfoz de Quintanadueñas',
	'ES09908' => 'Valle de Losa',
	'ES10001' => 'Abadía',
	'ES10002' => 'Abertura',
	'ES10003' => 'Acebo',
	'ES10004' => 'Acehúche',
	'ES10005' => 'Aceituna',
	'ES10006' => 'Ahigal',
	'ES10007' => 'Albalá',
	'ES10008' => 'Alcántara',
	'ES10009' => 'Alcollarín',
	'ES10010' => 'Alcuéscar',
	'ES10011' => 'Aldeacentenera',
	'ES10012' => 'Aldea del Cano',
	'ES10013' => 'Aldea del Obispo, La',
	'ES10014' => 'Aldeanueva de la Vera',
	'ES10015' => 'Aldeanueva del Camino',
	'ES10016' => 'Aldehuela de Jerte',
	'ES10017' => 'Alía',
	'ES10018' => 'Aliseda',
	'ES10019' => 'Almaraz',
	'ES10020' => 'Almoharín',
	'ES10022' => 'Arroyomolinos de la Vera',
	'ES10023' => 'Arroyomolinos',
	'ES10024' => 'Baños de Montemayor',
	'ES10025' => 'Barrado',
	'ES10026' => 'Belvís de Monroy',
	'ES10027' => 'Benquerencia',
	'ES10028' => 'Berrocalejo',
	'ES10029' => 'Berzocana',
	'ES10030' => 'Bohonal de Ibor',
	'ES10031' => 'Botija',
	'ES10032' => 'Brozas',
	'ES10033' => 'Cabañas del Castillo',
	'ES10034' => 'Cabezabellosa',
	'ES10035' => 'Cabezuela del Valle',
	'ES10036' => 'Cabrero',
	'ES10038' => 'Cachorrilla',
	'ES10039' => 'Cadalso',
	'ES10040' => 'Calzadilla',
	'ES10041' => 'Caminomorisco',
	'ES10042' => 'Campillo de Deleitosa',
	'ES10043' => 'Campo Lugar',
	'ES10044' => 'Cañamero',
	'ES10045' => 'Cañaveral',
	'ES10046' => 'Carbajo',
	'ES10047' => 'Carcaboso',
	'ES10048' => 'Carrascalejo',
	'ES10049' => 'Casar de Cáceres',
	'ES10050' => 'Casar de Palomero',
	'ES10051' => 'Casares de las Hurdes',
	'ES10052' => 'Casas de Don Antonio',
	'ES10053' => 'Casas de Don Gómez',
	'ES10054' => 'Casas del Castañar',
	'ES10055' => 'Casas del Monte',
	'ES10056' => 'Casas de Millán',
	'ES10057' => 'Casas de Miravete',
	'ES10058' => 'Casatejada',
	'ES10059' => 'Casillas de Coria',
	'ES10060' => 'Castañar de Ibor',
	'ES10061' => 'Ceclavín',
	'ES10062' => 'Cedillo',
	'ES10063' => 'Cerezo',
	'ES10064' => 'Cilleros',
	'ES10065' => 'Collado de la Vera',
	'ES10066' => 'Conquista de la Sierra',
	'ES10068' => 'Cuacos de Yuste',
	'ES10069' => 'Cumbre, La',
	'ES10070' => 'Deleitosa',
	'ES10071' => 'Descargamaría',
	'ES10072' => 'Eljas',
	'ES10073' => 'Escurial',
	'ES10075' => 'Fresnedoso de Ibor',
	'ES10076' => 'Galisteo',
	'ES10077' => 'Garciaz',
	'ES10078' => 'Garganta, La',
	'ES10079' => 'Garganta la Olla',
	'ES10080' => 'Gargantilla',
	'ES10081' => 'Gargüera',
	'ES10082' => 'Garrovillas de Alconétar',
	'ES10083' => 'Garvín',
	'ES10084' => 'Gata',
	'ES10085' => 'Gordo, El',
	'ES10086' => 'Granja, La',
	'ES10087' => 'Guadalupe',
	'ES10088' => 'Guijo de Coria',
	'ES10089' => 'Guijo de Galisteo',
	'ES10090' => 'Guijo de Granadilla',
	'ES10091' => 'Guijo de Santa Bárbara',
	'ES10092' => 'Herguijuela',
	'ES10093' => 'Hernán-Pérez',
	'ES10094' => 'Herrera de Alcántara',
	'ES10095' => 'Herreruela',
	'ES10096' => 'Hervás',
	'ES10097' => 'Higuera',
	'ES10098' => 'Hinojal',
	'ES10099' => 'Holguera',
	'ES10100' => 'Hoyos',
	'ES10101' => 'Huélaga',
	'ES10102' => 'Ibahernando',
	'ES10103' => 'Jaraicejo',
	'ES10105' => 'Jarandilla de la Vera',
	'ES10106' => 'Jarilla',
	'ES10107' => 'Jerte',
	'ES10108' => 'Ladrillar',
	'ES10109' => 'Logrosán',
	'ES10110' => 'Losar de la Vera',
	'ES10111' => 'Madrigal de la Vera',
	'ES10112' => 'Madrigalejo',
	'ES10113' => 'Madroñera',
	'ES10114' => 'Majadas',
	'ES10115' => 'Malpartida de Cáceres',
	'ES10116' => 'Malpartida de Plasencia',
	'ES10117' => 'Marchagaz',
	'ES10118' => 'Mata de Alcántara',
	'ES10119' => 'Membrío',
	'ES10120' => 'Mesas de Ibor',
	'ES10122' => 'Millanes',
	'ES10123' => 'Mirabel',
	'ES10124' => 'Mohedas de Granadilla',
	'ES10125' => 'Monroy',
	'ES10126' => 'Montánchez',
	'ES10129' => 'Morcillo',
	'ES10130' => 'Navaconcejo',
	'ES10132' => 'Navalvillar de Ibor',
	'ES10133' => 'Navas del Madroño',
	'ES10134' => 'Navezuelas',
	'ES10135' => 'Nuñomoral',
	'ES10136' => 'Oliva de Plasencia',
	'ES10137' => 'Palomero',
	'ES10138' => 'Pasarón de la Vera',
	'ES10139' => 'Pedroso de Acim',
	'ES10140' => 'Peraleda de la Mata',
	'ES10141' => 'Peraleda de San Román',
	'ES10142' => 'Perales del Puerto',
	'ES10143' => 'Pescueza',
	'ES10144' => 'Pesga, La',
	'ES10145' => 'Piedras Albas',
	'ES10146' => 'Pinofranqueado',
	'ES10147' => 'Piornal',
	'ES10149' => 'Plasenzuela',
	'ES10150' => 'Portaje',
	'ES10151' => 'Portezuelo',
	'ES10152' => 'Pozuelo de Zarzón',
	'ES10153' => 'Puerto de Santa Cruz',
	'ES10154' => 'Rebollar',
	'ES10155' => 'Riolobos',
	'ES10156' => 'Robledillo de Gata',
	'ES10157' => 'Robledillo de la Vera',
	'ES10158' => 'Robledillo de Trujillo',
	'ES10159' => 'Robledollano',
	'ES10160' => 'Romangordo',
	'ES10161' => 'Ruanes',
	'ES10162' => 'Salorino',
	'ES10163' => 'Salvatierra de Santiago',
	'ES10164' => 'San Martín de Trevejo',
	'ES10165' => 'Santa Ana',
	'ES10166' => 'Santa Cruz de la Sierra',
	'ES10167' => 'Santa Cruz de Paniagua',
	'ES10168' => 'Santa Marta de Magasca',
	'ES10169' => 'Santiago de Alcántara',
	'ES10170' => 'Santiago del Campo',
	'ES10171' => 'Santibáñez el Alto',
	'ES10172' => 'Santibáñez el Bajo',
	'ES10173' => 'Saucedilla',
	'ES10174' => 'Segura de Toro',
	'ES10175' => 'Serradilla',
	'ES10176' => 'Serrejón',
	'ES10177' => 'Sierra de Fuentes',
	'ES10178' => 'Talaván',
	'ES10179' => 'Talaveruela de la Vera',
	'ES10181' => 'Tejeda de Tiétar',
	'ES10182' => 'Toril',
	'ES10183' => 'Tornavacas',
	'ES10184' => 'Torno, El',
	'ES10185' => 'Torrecilla de los Ángeles',
	'ES10186' => 'Torrecillas de la Tiesa',
	'ES10187' => 'Torre de Don Miguel',
	'ES10188' => 'Torre de Santa María',
	'ES10189' => 'Torrejoncillo',
	'ES10190' => 'Torrejón el Rubio',
	'ES10191' => 'Torremenga',
	'ES10192' => 'Torremocha',
	'ES10193' => 'Torreorgaz',
	'ES10194' => 'Torrequemada',
	'ES10196' => 'Valdastillas',
	'ES10197' => 'Valdecañas de Tajo',
	'ES10198' => 'Valdefuentes',
	'ES10199' => 'Valdehúncar',
	'ES10200' => 'Valdelacasa de Tajo',
	'ES10201' => 'Valdemorales',
	'ES10202' => 'Valdeobispo',
	'ES10204' => 'Valverde de la Vera',
	'ES10205' => 'Valverde del Fresno',
	'ES10206' => 'Viandar de la Vera',
	'ES10207' => 'Villa del Campo',
	'ES10208' => 'Villa del Rey',
	'ES10209' => 'Villamesías',
	'ES10210' => 'Villamiel',
	'ES10211' => 'Villanueva de la Sierra',
	'ES10212' => 'Villanueva de la Vera',
	'ES10213' => 'Villar del Pedroso',
	'ES10214' => 'Villar de Plasencia',
	'ES10215' => 'Villasbuenas de Gata',
	'ES10216' => 'Zarza de Granadilla',
	'ES10217' => 'Zarza de Montánchez',
	'ES10218' => 'Zarza la Mayor',
	'ES10219' => 'Zorita',
	'ES10901' => 'Rosalejo',
	'ES10902' => 'Vegaviana',
	'ES10903' => 'Alagón del Río',
	'ES10904' => 'Tiétar',
	'ES10905' => 'Pueblonuevo de Miramontes',
	'ES11003' => 'Algar',
	'ES11009' => 'Benaocaz',
	'ES11011' => 'Bosque, El',
	'ES11013' => 'Castellar de la Frontera',
	'ES11017' => 'Espera',
	'ES11018' => 'Gastor, El',
	'ES11019' => 'Grazalema',
	'ES11034' => 'Setenil de las Bodegas',
	'ES11036' => 'Torre Alháquime',
	'ES11040' => 'Villaluenga del Rosario',
	'ES11042' => 'Zahara',
	'ES11902' => 'San José del Valle',
	'ES11903' => 'San Martín del Tesorillo',
	'ES12001' => 'Atzeneta del Maestrat',
	'ES12002' => 'Aín',
	'ES12003' => 'Albocàsser',
	'ES12006' => 'Alcudia de Veo',
	'ES12007' => 'Alfondeguilla',
	'ES12008' => 'Algimia de Almonacid',
	'ES12010' => 'Almedíjar',
	'ES12012' => 'Altura',
	'ES12013' => 'Arañuel',
	'ES12014' => 'Ares del Maestrat',
	'ES12015' => 'Argelita',
	'ES12016' => 'Artana',
	'ES12017' => 'Ayódar',
	'ES12018' => 'Azuébar',
	'ES12020' => 'Barracas',
	'ES12022' => 'Bejís',
	'ES12024' => 'Benafer',
	'ES12025' => 'Benafigos',
	'ES12026' => 'Benassal',
	'ES12029' => 'Benlloc',
	'ES12033' => 'Cabanes',
	'ES12034' => 'Càlig',
	'ES12036' => 'Canet lo Roig',
	'ES12037' => 'Castell de Cabres',
	'ES12038' => 'Castellfort',
	'ES12039' => 'Castellnovo',
	'ES12041' => 'Castillo de Villamalefa',
	'ES12042' => 'Catí',
	'ES12043' => 'Caudiel',
	'ES12044' => 'Cervera del Maestre',
	'ES12045' => 'Cinctorres',
	'ES12046' => 'Cirat',
	'ES12048' => 'Cortes de Arenoso',
	'ES12049' => 'Costur',
	'ES12050' => 'Coves de Vinromà, les',
	'ES12051' => 'Culla',
	'ES12052' => 'Xert',
	'ES12053' => 'Xilxes',
	'ES12055' => 'Xodos',
	'ES12056' => 'Chóvar',
	'ES12057' => 'Eslida',
	'ES12058' => 'Espadilla',
	'ES12059' => 'Fanzara',
	'ES12060' => 'Figueroles',
	'ES12061' => 'Forcall',
	'ES12063' => 'Fuente la Reina',
	'ES12064' => 'Fuentes de Ayódar',
	'ES12065' => 'Gaibiel',
	'ES12067' => 'Geldo',
	'ES12068' => 'Herbés',
	'ES12069' => 'Higueras',
	'ES12070' => 'Jana, la',
	'ES12071' => 'Jérica',
	'ES12072' => 'Lucena del Cid',
	'ES12073' => 'Ludiente',
	'ES12074' => 'Llosa, la',
	'ES12075' => 'Mata de Morella, la',
	'ES12076' => 'Matet',
	'ES12078' => 'Montán',
	'ES12079' => 'Montanejos',
	'ES12080' => 'Morella',
	'ES12081' => 'Navajas',
	'ES12083' => 'Olocau del Rey',
	'ES12087' => 'Palanques',
	'ES12088' => 'Pavías',
	'ES12090' => 'Pina de Montalgrao',
	'ES12091' => 'Portell de Morella',
	'ES12092' => 'Puebla de Arenoso',
	'ES12093' => 'Pobla de Benifassà, la',
	'ES12094' => 'Pobla Tornesa, la',
	'ES12095' => 'Ribesalbes',
	'ES12096' => 'Rossell',
	'ES12097' => 'Sacañet',
	'ES12098' => 'Salzadella, la',
	'ES12099' => 'San Jorge',
	'ES12100' => 'Sant Mateu',
	'ES12101' => 'San Rafael del Río',
	'ES12102' => 'Santa Magdalena de Pulpis',
	'ES12103' => 'Serratella, la',
	'ES12105' => 'Sierra Engarcerán',
	'ES12106' => 'Soneja',
	'ES12107' => 'Sot de Ferrer',
	'ES12108' => 'Suera',
	'ES12109' => 'Tales',
	'ES12110' => 'Teresa',
	'ES12111' => 'Tírig',
	'ES12112' => 'Todolella',
	'ES12113' => 'Toga',
	'ES12114' => 'Torás',
	'ES12115' => 'Toro, El',
	'ES12116' => 'Torralba del Pinar',
	'ES12118' => 'Torrechiva',
	'ES12119' => 'Torre dEn Besora, la',
	'ES12120' => 'Torre den Doménec, la',
	'ES12121' => 'Traiguera',
	'ES12122' => 'Useres, les',
	'ES12123' => 'Vallat',
	'ES12124' => 'Vall dAlba',
	'ES12125' => 'Vall de Almonacid',
	'ES12127' => 'Vallibona',
	'ES12128' => 'Vilafamés',
	'ES12129' => 'Villafranca del Cid',
	'ES12130' => 'Villahermosa del Río',
	'ES12131' => 'Villamalur',
	'ES12132' => 'Vilanova dAlcolea',
	'ES12133' => 'Villanueva de Viver',
	'ES12134' => 'Vilar de Canes',
	'ES12136' => 'Vilavella, la',
	'ES12137' => 'Villores',
	'ES12139' => 'Vistabella del Maestrat',
	'ES12140' => 'Viver',
	'ES12141' => 'Zorita del Maestrazgo',
	'ES12142' => 'Zucaina',
	'ES12901' => 'Alquerías del Niño Perdido',
	'ES12902' => 'Sant Joan de Moró',
	'ES13001' => 'Abenójar',
	'ES13002' => 'Agudo',
	'ES13003' => 'Alamillo',
	'ES13004' => 'Albaladejo',
	'ES13006' => 'Alcoba',
	'ES13007' => 'Alcolea de Calatrava',
	'ES13008' => 'Alcubillas',
	'ES13009' => 'Aldea del Rey',
	'ES13010' => 'Alhambra',
	'ES13012' => 'Almadenejos',
	'ES13014' => 'Almedina',
	'ES13016' => 'Almuradiel',
	'ES13017' => 'Anchuras',
	'ES13018' => 'Arenas de San Juan',
	'ES13021' => 'Arroba de los Montes',
	'ES13022' => 'Ballesteros de Calatrava',
	'ES13024' => 'Brazatortas',
	'ES13025' => 'Cabezarados',
	'ES13026' => 'Cabezarrubias del Puerto',
	'ES13027' => 'Calzada de Calatrava',
	'ES13029' => 'Cañada de Calatrava',
	'ES13030' => 'Caracuel de Calatrava',
	'ES13031' => 'Carrión de Calatrava',
	'ES13032' => 'Carrizosa',
	'ES13033' => 'Castellar de Santiago',
	'ES13035' => 'Corral de Calatrava',
	'ES13036' => 'Cortijos, Los',
	'ES13037' => 'Cózar',
	'ES13038' => 'Chillón',
	'ES13040' => 'Fernán Caballero',
	'ES13041' => 'Fontanarejo',
	'ES13042' => 'Fuencaliente',
	'ES13043' => 'Fuenllana',
	'ES13044' => 'Fuente el Fresno',
	'ES13045' => 'Granátula de Calatrava',
	'ES13046' => 'Guadalmez',
	'ES13048' => 'Hinojosas de Calatrava',
	'ES13049' => 'Horcajo de los Montes',
	'ES13050' => 'Labores, Las',
	'ES13051' => 'Luciana',
	'ES13055' => 'Mestanza',
	'ES13057' => 'Montiel',
	'ES13059' => 'Navalpino',
	'ES13060' => 'Navas de Estena',
	'ES13062' => 'Picón',
	'ES13063' => 'Piedrabuena',
	'ES13064' => 'Poblete',
	'ES13065' => 'Porzuna',
	'ES13066' => 'Pozuelo de Calatrava',
	'ES13067' => 'Pozuelos de Calatrava, Los',
	'ES13068' => 'Puebla de Don Rodrigo',
	'ES13069' => 'Puebla del Príncipe',
	'ES13070' => 'Puerto Lápice',
	'ES13072' => 'Retuerta del Bullaque',
	'ES13073' => 'Saceruela',
	'ES13074' => 'San Carlos del Valle',
	'ES13075' => 'San Lorenzo de Calatrava',
	'ES13076' => 'Santa Cruz de los Cáñamos',
	'ES13077' => 'Santa Cruz de Mudela',
	'ES13080' => 'Solana del Pino',
	'ES13081' => 'Terrinches',
	'ES13083' => 'Torralba de Calatrava',
	'ES13084' => 'Torre de Juan Abad',
	'ES13085' => 'Torrenueva',
	'ES13086' => 'Valdemanco del Esteras',
	'ES13088' => 'Valenzuela de Calatrava',
	'ES13089' => 'Villahermosa',
	'ES13090' => 'Villamanrique',
	'ES13091' => 'Villamayor de Calatrava',
	'ES13092' => 'Villanueva de la Fuente',
	'ES13093' => 'Villanueva de los Infantes',
	'ES13094' => 'Villanueva de San Carlos',
	'ES13095' => 'Villar del Pozo',
	'ES13097' => 'Villarta de San Juan',
	'ES13098' => 'Viso del Marqués',
	'ES13901' => 'Robledo, El',
	'ES13902' => 'Ruidera',
	'ES13903' => 'Arenales de San Gregorio',
	'ES13904' => 'Llanos del Caudillo',
	'ES14001' => 'Adamuz',
	'ES14003' => 'Alcaracejos',
	'ES14004' => 'Almedinilla',
	'ES14006' => 'Añora',
	'ES14008' => 'Belalcázar',
	'ES14009' => 'Belmez',
	'ES14010' => 'Benamejí',
	'ES14011' => 'Blázquez, Los',
	'ES14014' => 'Cañete de las Torres',
	'ES14015' => 'Carcabuey',
	'ES14016' => 'Cardeña',
	'ES14018' => 'Carpio, El',
	'ES14020' => 'Conquista',
	'ES14022' => 'Doña Mencía',
	'ES14023' => 'Dos Torres',
	'ES14024' => 'Encinas Reales',
	'ES14025' => 'Espejo',
	'ES14026' => 'Espiel',
	'ES14028' => 'Fuente la Lancha',
	'ES14029' => 'Fuente Obejuna',
	'ES14031' => 'Fuente-Tójar',
	'ES14032' => 'Granjuela, La',
	'ES14033' => 'Guadalcázar',
	'ES14034' => 'Guijo, El',
	'ES14036' => 'Hornachuelos',
	'ES14037' => 'Iznájar',
	'ES14039' => 'Luque',
	'ES14040' => 'Montalbán de Córdoba',
	'ES14041' => 'Montemayor',
	'ES14044' => 'Monturque',
	'ES14045' => 'Moriles',
	'ES14047' => 'Obejo',
	'ES14048' => 'Palenciana',
	'ES14050' => 'Pedro Abad',
	'ES14051' => 'Pedroche',
	'ES14059' => 'San Sebastián de los Ballesteros),',
	'ES14060' => 'Santaella',
	'ES14061' => 'Santa Eufemia',
	'ES14062' => 'Torrecampo',
	'ES14063' => 'Valenzuela',
	'ES14064' => 'Valsequillo',
	'ES14065' => 'Victoria, La',
	'ES14067' => 'Villafranca de Córdoba',
	'ES14068' => 'Villaharta',
	'ES14070' => 'Villanueva del Duque',
	'ES14071' => 'Villanueva del Rey',
	'ES14072' => 'Villaralto',
	'ES14073' => 'Villaviciosa de Córdoba',
	'ES14074' => 'Viso, El',
	'ES14075' => 'Zuheros',
	'ES14901' => 'Fuente Carreteros',
	'ES14902' => 'Guijarrosa, La',
	'ES15003' => 'Aranga',
	'ES15007' => 'Baña, A',
	'ES15010' => 'Boimorto',
	'ES15012' => 'Boqueixón',
	'ES15014' => 'Cabana de Bergantiños',
	'ES15015' => 'Cabanas',
	'ES15018' => 'Capela, A',
	'ES15020' => 'Carnota',
	'ES15025' => 'Cerdido',
	'ES15027' => 'Coirós',
	'ES15028' => 'Corcubión',
	'ES15032' => 'Curtis',
	'ES15033' => 'Dodro',
	'ES15034' => 'Dumbría',
	'ES15037' => 'Fisterra',
	'ES15038' => 'Frades',
	'ES15039' => 'Irixoa',
	'ES15040' => 'Laxe',
	'ES15042' => 'Lousame',
	'ES15044' => 'Mañón',
	'ES15045' => 'Mazaricos',
	'ES15047' => 'Mesía',
	'ES15049' => 'Moeche',
	'ES15050' => 'Monfero',
	'ES15052' => 'Muxía',
	'ES15064' => 'Paderne',
	'ES15066' => 'Pino, O',
	'ES15074' => 'Rois',
	'ES15076' => 'San Sadurniño',
	'ES15079' => 'Santiso',
	'ES15080' => 'Sobrado',
	'ES15081' => 'Somozas, As',
	'ES15083' => 'Toques',
	'ES15084' => 'Tordoia',
	'ES15085' => 'Touro',
	'ES15086' => 'Trazo',
	'ES15088' => 'Val do Dubra',
	'ES15090' => 'Vilasantar',
	'ES15091' => 'Vilarmaior',
	'ES15093' => 'Zas',
	'ES15901' => 'Cariño',
	'ES16001' => 'Abia de la Obispalía',
	'ES16002' => 'Acebrón, El',
	'ES16003' => 'Alarcón',
	'ES16004' => 'Albaladejo del Cuende',
	'ES16005' => 'Albalate de las Nogueras',
	'ES16006' => 'Albendea',
	'ES16007' => 'Alberca de Záncara, La',
	'ES16008' => 'Alcalá de la Vega',
	'ES16009' => 'Alcantud',
	'ES16010' => 'Alcázar del Rey',
	'ES16011' => 'Alcohujate',
	'ES16012' => 'Alconchel de la Estrella',
	'ES16013' => 'Algarra',
	'ES16014' => 'Aliaguilla',
	'ES16015' => 'Almarcha, La',
	'ES16016' => 'Almendros',
	'ES16017' => 'Almodóvar del Pinar',
	'ES16018' => 'Almonacid del Marquesado',
	'ES16019' => 'Altarejos',
	'ES16020' => 'Arandilla del Arroyo',
	'ES16022' => 'Arcos de la Sierra',
	'ES16023' => 'Chillarón de Cuenca',
	'ES16024' => 'Arguisuelas',
	'ES16025' => 'Arrancacepas',
	'ES16026' => 'Atalaya del Cañavate',
	'ES16027' => 'Barajas de Melo',
	'ES16029' => 'Barchín del Hoyo',
	'ES16030' => 'Bascuñana de San Pedro',
	'ES16031' => 'Beamud',
	'ES16032' => 'Belinchón',
	'ES16033' => 'Belmonte',
	'ES16034' => 'Belmontejo',
	'ES16035' => 'Beteta',
	'ES16036' => 'Boniches',
	'ES16038' => 'Buciegas',
	'ES16039' => 'Buenache de Alarcón',
	'ES16040' => 'Buenache de la Sierra',
	'ES16041' => 'Buendía',
	'ES16042' => 'Campillo de Altobuey',
	'ES16043' => 'Campillos-Paravientos',
	'ES16044' => 'Campillos-Sierra',
	'ES16045' => 'Canalejas del Arroyo',
	'ES16046' => 'Cañada del Hoyo',
	'ES16047' => 'Cañada Juncosa',
	'ES16048' => 'Cañamares',
	'ES16049' => 'Cañavate, El',
	'ES16050' => 'Cañaveras',
	'ES16051' => 'Cañaveruelas',
	'ES16052' => 'Cañete',
	'ES16053' => 'Cañizares',
	'ES16055' => 'Carboneras de Guadazaón',
	'ES16056' => 'Cardenete',
	'ES16057' => 'Carrascosa',
	'ES16058' => 'Carrascosa de Haro',
	'ES16060' => 'Casas de Benítez',
	'ES16061' => 'Casas de Fernando Alonso',
	'ES16062' => 'Casas de Garcimolina',
	'ES16063' => 'Casas de Guijarro',
	'ES16064' => 'Casas de Haro',
	'ES16065' => 'Casas de los Pinos',
	'ES16066' => 'Casasimarro',
	'ES16067' => 'Castejón',
	'ES16068' => 'Castillejo de Iniesta',
	'ES16070' => 'Castillejo-Sierra',
	'ES16071' => 'Castillo-Albaráñez',
	'ES16072' => 'Castillo de Garcimuñoz',
	'ES16073' => 'Cervera del Llano',
	'ES16074' => 'Cierva, La',
	'ES16079' => 'Cueva del Hierro',
	'ES16081' => 'Chumillas',
	'ES16082' => 'Enguídanos',
	'ES16083' => 'Fresneda de Altarejos',
	'ES16084' => 'Fresneda de la Sierra',
	'ES16085' => 'Frontera, La',
	'ES16086' => 'Fuente de Pedro Naharro',
	'ES16087' => 'Fuentelespino de Haro',
	'ES16088' => 'Fuentelespino de Moya',
	'ES16089' => 'Fuentes',
	'ES16091' => 'Fuertescusa',
	'ES16092' => 'Gabaldón',
	'ES16093' => 'Garaballa',
	'ES16094' => 'Gascueña',
	'ES16095' => 'Graja de Campalbo',
	'ES16096' => 'Graja de Iniesta',
	'ES16097' => 'Henarejos',
	'ES16098' => 'Herrumblar, El',
	'ES16099' => 'Hinojosa, La',
	'ES16100' => 'Hinojosos, Los',
	'ES16101' => 'Hito, El',
	'ES16102' => 'Honrubia',
	'ES16103' => 'Hontanaya',
	'ES16104' => 'Hontecillas',
	'ES16106' => 'Horcajo de Santiago',
	'ES16107' => 'Huélamo',
	'ES16108' => 'Huelves',
	'ES16109' => 'Huérguina',
	'ES16110' => 'Huerta de la Obispalía',
	'ES16111' => 'Huerta del Marquesado',
	'ES16112' => 'Huete',
	'ES16113' => 'Iniesta',
	'ES16115' => 'Laguna del Marquesado',
	'ES16116' => 'Lagunaseca',
	'ES16117' => 'Landete',
	'ES16118' => 'Ledaña',
	'ES16119' => 'Leganiel',
	'ES16121' => 'Majadas, Las',
	'ES16122' => 'Mariana',
	'ES16123' => 'Masegosa',
	'ES16124' => 'Mesas, Las',
	'ES16125' => 'Minglanilla',
	'ES16126' => 'Mira',
	'ES16128' => 'Monreal del Llano',
	'ES16129' => 'Montalbanejo',
	'ES16130' => 'Montalbo',
	'ES16131' => 'Monteagudo de las Salinas',
	'ES16132' => 'Mota de Altarejos',
	'ES16135' => 'Moya',
	'ES16137' => 'Narboneta',
	'ES16139' => 'Olivares de Júcar',
	'ES16140' => 'Olmeda de la Cuesta',
	'ES16141' => 'Olmeda del Rey',
	'ES16142' => 'Olmedilla de Alarcón',
	'ES16143' => 'Olmedilla de Eliz',
	'ES16145' => 'Osa de la Vega',
	'ES16146' => 'Pajarón',
	'ES16147' => 'Pajaroncillo',
	'ES16148' => 'Palomares del Campo',
	'ES16149' => 'Palomera',
	'ES16150' => 'Paracuellos',
	'ES16151' => 'Paredes',
	'ES16152' => 'Parra de las Vegas, La',
	'ES16153' => 'Pedernoso, El',
	'ES16155' => 'Peral, El',
	'ES16156' => 'Peraleja, La',
	'ES16157' => 'Pesquera, La',
	'ES16158' => 'Picazo, El',
	'ES16159' => 'Pinarejo',
	'ES16160' => 'Pineda de Gigüela',
	'ES16161' => 'Piqueras del Castillo',
	'ES16162' => 'Portalrubio de Guadamejud',
	'ES16163' => 'Portilla',
	'ES16165' => 'Poyatos',
	'ES16166' => 'Pozoamargo',
	'ES16167' => 'Pozorrubio de Santiago',
	'ES16169' => 'Pozuelo, El',
	'ES16170' => 'Priego',
	'ES16171' => 'Provencio, El',
	'ES16172' => 'Puebla de Almenara',
	'ES16173' => 'Valle de Altomira, El',
	'ES16174' => 'Puebla del Salvador',
	'ES16176' => 'Rada de Haro',
	'ES16177' => 'Reíllo',
	'ES16181' => 'Rozalén del Monte',
	'ES16185' => 'Saceda-Trasierra',
	'ES16186' => 'Saelices',
	'ES16187' => 'Salinas del Manzano',
	'ES16188' => 'Salmeroncillos',
	'ES16189' => 'Salvacañete',
	'ES16191' => 'San Lorenzo de la Parrilla',
	'ES16192' => 'San Martín de Boniches',
	'ES16193' => 'San Pedro Palmiches',
	'ES16194' => 'Santa Cruz de Moya',
	'ES16195' => 'Santa María del Campo Rus',
	'ES16196' => 'Santa María de los Llanos',
	'ES16197' => 'Santa María del Val',
	'ES16198' => 'Sisante',
	'ES16199' => 'Solera de Gabaldón',
	'ES16202' => 'Talayuelas',
	'ES16204' => 'Tébar',
	'ES16205' => 'Tejadillos',
	'ES16206' => 'Tinajas',
	'ES16209' => 'Torralba',
	'ES16211' => 'Torrejoncillo del Rey',
	'ES16212' => 'Torrubia del Campo',
	'ES16213' => 'Torrubia del Castillo',
	'ES16215' => 'Tragacete',
	'ES16216' => 'Tresjuncos',
	'ES16217' => 'Tribaldos',
	'ES16218' => 'Uclés',
	'ES16219' => 'Uña',
	'ES16224' => 'Valdemeca',
	'ES16225' => 'Valdemorillo de la Sierra',
	'ES16227' => 'Valdemoro-Sierra',
	'ES16228' => 'Valdeolivas',
	'ES16231' => 'Valhermoso de la Fuente',
	'ES16234' => 'Valsalobre',
	'ES16236' => 'Valverde de Júcar',
	'ES16237' => 'Valverdejo',
	'ES16238' => 'Vara de Rey',
	'ES16239' => 'Vega del Codorno',
	'ES16240' => 'Vellisca',
	'ES16242' => 'Villaconejos de Trabaque',
	'ES16243' => 'Villaescusa de Haro',
	'ES16244' => 'Villagarcía del Llano',
	'ES16245' => 'Villalba de la Sierra',
	'ES16246' => 'Villalba del Rey',
	'ES16247' => 'Villalgordo del Marquesado',
	'ES16248' => 'Villalpardo',
	'ES16249' => 'Villamayor de Santiago',
	'ES16250' => 'Villanueva de Guadamejud',
	'ES16251' => 'Villanueva de la Jara',
	'ES16253' => 'Villar de Cañas',
	'ES16254' => 'Villar de Domingo García',
	'ES16255' => 'Villar de la Encina',
	'ES16258' => 'Villar del Humo',
	'ES16259' => 'Villar del Infantado',
	'ES16263' => 'Villar de Olalla',
	'ES16264' => 'Villarejo de Fuentes',
	'ES16265' => 'Villarejo de la Peñuela',
	'ES16266' => 'Villarejo-Periesteban',
	'ES16269' => 'Villares del Saz',
	'ES16270' => 'Villarrubio',
	'ES16271' => 'Villarta',
	'ES16272' => 'Villas de la Ventosa',
	'ES16273' => 'Villaverde y Pasaconsol',
	'ES16274' => 'Víllora',
	'ES16275' => 'Vindel',
	'ES16276' => 'Yémeda',
	'ES16277' => 'Zafra de Záncara',
	'ES16278' => 'Zafrilla',
	'ES16279' => 'Zarza de Tajo',
	'ES16280' => 'Zarzuela',
	'ES16901' => 'Campos del Paraíso',
	'ES16902' => 'Valdetórtola',
	'ES16903' => 'Valeras, Las',
	'ES16904' => 'Fuentenava de Jábaga',
	'ES16905' => 'Arcas',
	'ES16906' => 'Valdecolmenas, Los',
	'ES16908' => 'Pozorrubielos de la Mancha',
	'ES16909' => 'Sotorribas',
	'ES16910' => 'Villar y Velasco',
	'ES17001' => 'Agullana',
	'ES17002' => 'Aiguaviva',
	'ES17003' => 'Albanyà',
	'ES17004' => 'Albons',
	'ES17005' => 'Far dEmpordà, El',
	'ES17006' => 'Alp',
	'ES17007' => 'Amer',
	'ES17010' => 'Argelaguer',
	'ES17011' => 'Armentera, L',
	'ES17012' => 'Avinyonet de Puigventós',
	'ES17013' => 'Begur',
	'ES17014' => 'Vajol, La',
	'ES17016' => 'Bàscara',
	'ES17018' => 'Bellcaire dEmpordà',
	'ES17019' => 'Besalú',
	'ES17020' => 'Bescanó',
	'ES17021' => 'Beuda',
	'ES17024' => 'Bolvir',
	'ES17025' => 'Bordils',
	'ES17026' => 'Borrassà',
	'ES17027' => 'Breda',
	'ES17028' => 'Brunyola i Sant Martí Sapresa',
	'ES17029' => 'Boadella i les Escaules',
	'ES17030' => 'Cabanes',
	'ES17031' => 'Cabanelles',
	'ES17032' => 'Cadaqués',
	'ES17035' => 'Camós',
	'ES17036' => 'Campdevànol',
	'ES17037' => 'Campelles',
	'ES17038' => 'Campllong',
	'ES17039' => 'Camprodon',
	'ES17040' => 'Canet dAdri',
	'ES17041' => 'Cantallops',
	'ES17042' => 'Capmany',
	'ES17043' => 'Queralbs',
	'ES17046' => 'Castellfollit de la Roca',
	'ES17050' => 'Cervià de Ter',
	'ES17051' => 'Cistella',
	'ES17052' => 'Siurana',
	'ES17054' => 'Colera',
	'ES17055' => 'Colomers',
	'ES17056' => 'Cornellà del Terri',
	'ES17057' => 'Corçà',
	'ES17058' => 'Crespià',
	'ES17060' => 'Darnius',
	'ES17061' => 'Das',
	'ES17063' => 'Espinelves',
	'ES17064' => 'Espolla',
	'ES17065' => 'Esponellà',
	'ES17067' => 'Flaçà',
	'ES17068' => 'Foixà',
	'ES17069' => 'Fontanals de Cerdanya',
	'ES17070' => 'Fontanilles',
	'ES17071' => 'Fontcoberta',
	'ES17073' => 'Fornells de la Selva',
	'ES17074' => 'Fortià',
	'ES17075' => 'Garrigàs',
	'ES17076' => 'Garrigoles',
	'ES17077' => 'Garriguella',
	'ES17078' => 'Ger',
	'ES17080' => 'Gombrèn',
	'ES17081' => 'Gualta',
	'ES17082' => 'Guils de Cerdanya',
	'ES17083' => 'Hostalric',
	'ES17084' => 'Isòvol',
	'ES17085' => 'Jafre',
	'ES17086' => 'Jonquera, La',
	'ES17087' => 'Juià',
	'ES17088' => 'Lladó',
	'ES17090' => 'Llambilles',
	'ES17091' => 'Llanars',
	'ES17092' => 'Llançà',
	'ES17093' => 'Llers',
	'ES17094' => 'Llívia',
	'ES17096' => 'Llosses, Les',
	'ES17097' => 'Madremanya',
	'ES17098' => 'Maià de Montcal',
	'ES17099' => 'Meranges',
	'ES17100' => 'Masarac',
	'ES17101' => 'Massanes',
	'ES17102' => 'Maçanet de Cabrenys',
	'ES17105' => 'Mieres',
	'ES17106' => 'Mollet de Peralada',
	'ES17107' => 'Molló',
	'ES17109' => 'Montagut i Oix',
	'ES17110' => 'Mont-ras',
	'ES17111' => 'Navata',
	'ES17112' => 'Ogassa',
	'ES17115' => 'Ordis',
	'ES17116' => 'Osor',
	'ES17119' => 'Palau de Santa Eulàlia',
	'ES17120' => 'Palau-saverdera',
	'ES17121' => 'Palau-sator',
	'ES17123' => 'Palol de Revardit',
	'ES17124' => 'Pals',
	'ES17125' => 'Pardines',
	'ES17126' => 'Parlavà',
	'ES17128' => 'Pau',
	'ES17129' => 'Pedret i Marzà',
	'ES17130' => 'Pera, La',
	'ES17132' => 'Peralada',
	'ES17133' => 'Planes dHostoles, Les',
	'ES17134' => 'Planoles',
	'ES17135' => 'Pont de Molins',
	'ES17136' => 'Pontós',
	'ES17137' => 'Porqueres',
	'ES17138' => 'Portbou',
	'ES17139' => 'Preses, Les',
	'ES17140' => 'Port de la Selva, El',
	'ES17142' => 'Quart',
	'ES17143' => 'Rabós',
	'ES17144' => 'Regencós',
	'ES17145' => 'Ribes de Freser',
	'ES17146' => 'Riells i Viabrea',
	'ES17148' => 'Riudarenes',
	'ES17149' => 'Riudaura',
	'ES17150' => 'Riudellots de la Selva',
	'ES17151' => 'Riumors',
	'ES17153' => 'Rupià',
	'ES17154' => 'Sales de Llierca',
	'ES17157' => 'Sant Andreu Salou',
	'ES17158' => 'Sant Climent Sescebes',
	'ES17159' => 'Sant Feliu de Buixalleu',
	'ES17161' => 'Sant Feliu de Pallerols',
	'ES17162' => 'Sant Ferriol',
	'ES17163' => 'Sant Gregori',
	'ES17165' => 'Sant Jaume de Llierca',
	'ES17166' => 'Sant Jordi Desvalls',
	'ES17167' => 'Sant Joan de les Abadesses',
	'ES17168' => 'Sant Joan de Mollet',
	'ES17169' => 'Sant Julià de Ramis',
	'ES17170' => 'Vallfogona de Ripollès',
	'ES17171' => 'Sant Llorenç de la Muga',
	'ES17172' => 'Sant Martí de Llémena',
	'ES17173' => 'Sant Martí Vell',
	'ES17174' => 'Sant Miquel de Campmajor',
	'ES17175' => 'Sant Miquel de Fluvià',
	'ES17176' => 'Sant Mori',
	'ES17177' => 'Sant Pau de Segúries',
	'ES17178' => 'Sant Pere Pescador',
	'ES17182' => 'Santa Llogaia dÀlguema',
	'ES17183' => 'Sant Aniol de Finestres',
	'ES17184' => 'Santa Pau',
	'ES17185' => 'Sant Joan les Fonts',
	'ES17187' => 'Saus, Camallera i Llampaies',
	'ES17188' => 'Selva de Mar, La',
	'ES17189' => 'Cellera de Ter, La',
	'ES17190' => 'Serinyà',
	'ES17191' => 'Serra de Daró',
	'ES17192' => 'Setcases',
	'ES17194' => 'Susqueda',
	'ES17195' => 'Tallada dEmpordà, La',
	'ES17196' => 'Terrades',
	'ES17197' => 'Torrent',
	'ES17198' => 'Torroella de Fluvià',
	'ES17200' => 'Tortellà',
	'ES17201' => 'Toses',
	'ES17203' => 'Ultramort',
	'ES17204' => 'Ullà',
	'ES17205' => 'Ullastret',
	'ES17206' => 'Urús',
	'ES17207' => 'Vall den Bas, La',
	'ES17208' => 'Vall de Bianya, La',
	'ES17209' => 'Vall-llobrega',
	'ES17210' => 'Ventalló',
	'ES17211' => 'Verges',
	'ES17212' => 'Vidrà',
	'ES17214' => 'Vilabertran',
	'ES17215' => 'Vilablareix',
	'ES17216' => 'Viladasens',
	'ES17217' => 'Viladamat',
	'ES17218' => 'Vilademuls',
	'ES17220' => 'Viladrau',
	'ES17222' => 'Vilaür',
	'ES17223' => 'Vilajuïga',
	'ES17224' => 'Vilallonga de Ter',
	'ES17225' => 'Vilamacolum',
	'ES17226' => 'Vilamalla',
	'ES17227' => 'Vilamaniscle',
	'ES17228' => 'Vilanant',
	'ES17230' => 'Vila-sacra',
	'ES17232' => 'Vilopriu',
	'ES17233' => 'Vilobí dOnyar',
	'ES17234' => 'Biure',
	'ES17901' => 'Cruïlles, Monells i Sant Sadurní de lHeuraocommerce',
	'ES17902' => 'Forallac',
	'ES17903' => 'Sant Julià del Llor i Bonmatí',
	'ES18001' => 'Agrón',
	'ES18002' => 'Alamedilla',
	'ES18004' => 'Albondón',
	'ES18005' => 'Albuñán',
	'ES18007' => 'Albuñuelas',
	'ES18010' => 'Aldeire',
	'ES18012' => 'Algarinejo',
	'ES18015' => 'Alicún de Ortega',
	'ES18016' => 'Almegíjar',
	'ES18018' => 'Alquife',
	'ES18020' => 'Arenas del Rey',
	'ES18024' => 'Beas de Granada',
	'ES18025' => 'Beas de Guadix',
	'ES18027' => 'Benalúa',
	'ES18028' => 'Benalúa de las Villas',
	'ES18029' => 'Benamaurel',
	'ES18030' => 'Bérchules',
	'ES18032' => 'Bubión',
	'ES18033' => 'Busquístar',
	'ES18034' => 'Cacín',
	'ES18035' => 'Cádiar',
	'ES18037' => 'Calicasas',
	'ES18038' => 'Campotéjar',
	'ES18039' => 'Caniles',
	'ES18040' => 'Cáñar',
	'ES18042' => 'Capileira',
	'ES18043' => 'Carataunas',
	'ES18044' => 'Cástaras',
	'ES18045' => 'Castilléjar',
	'ES18046' => 'Castril',
	'ES18048' => 'Cijuela',
	'ES18049' => 'Cogollos de Guadix',
	'ES18050' => 'Cogollos de la Vega',
	'ES18051' => 'Colomera',
	'ES18053' => 'Cortes de Baza',
	'ES18054' => 'Cortes y Graena',
	'ES18056' => 'Cúllar',
	'ES18061' => 'Chimeneas',
	'ES18063' => 'Darro',
	'ES18064' => 'Dehesas de Guadix',
	'ES18065' => 'Dehesas Viejas',
	'ES18066' => 'Deifontes',
	'ES18067' => 'Diezma',
	'ES18068' => 'Dílar',
	'ES18069' => 'Dólar',
	'ES18070' => 'Dúdar',
	'ES18072' => 'Escúzar',
	'ES18074' => 'Ferreira',
	'ES18076' => 'Fonelas',
	'ES18077' => 'Fornes',
	'ES18078' => 'Freila',
	'ES18079' => 'Fuente Vaqueros',
	'ES18082' => 'Galera',
	'ES18083' => 'Gobernador',
	'ES18085' => 'Gor',
	'ES18086' => 'Gorafe',
	'ES18088' => 'Guadahortuna',
	'ES18094' => 'Güéjar Sierra',
	'ES18095' => 'Güevéjar',
	'ES18096' => 'Huélago',
	'ES18097' => 'Huéneja',
	'ES18099' => 'Huétor de Santillán',
	'ES18103' => 'Ítrabo',
	'ES18106' => 'Játar',
	'ES18107' => 'Jayena',
	'ES18108' => 'Jérez del Marquesado',
	'ES18109' => 'Jete',
	'ES18111' => 'Jun',
	'ES18112' => 'Juviles',
	'ES18114' => 'Calahorra, La',
	'ES18115' => 'Láchar',
	'ES18116' => 'Lanjarón',
	'ES18117' => 'Lanteira',
	'ES18119' => 'Lecrín',
	'ES18120' => 'Lentegí',
	'ES18121' => 'Lobras',
	'ES18123' => 'Lugros',
	'ES18124' => 'Lújar',
	'ES18126' => 'Malahá, La',
	'ES18128' => 'Marchal',
	'ES18132' => 'Moclín',
	'ES18133' => 'Molvízar',
	'ES18136' => 'Montejícar',
	'ES18137' => 'Montillana',
	'ES18138' => 'Moraleda de Zafayona',
	'ES18141' => 'Murtas',
	'ES18143' => 'Nigüelas',
	'ES18144' => 'Nívar',
	'ES18146' => 'Orce',
	'ES18148' => 'Otívar',
	'ES18151' => 'Pampaneira',
	'ES18152' => 'Pedro Martínez',
	'ES18154' => 'Peza, La',
	'ES18157' => 'Pinos Genil',
	'ES18159' => 'Píñar',
	'ES18161' => 'Polícar',
	'ES18162' => 'Polopos',
	'ES18163' => 'Pórtugos',
	'ES18164' => 'Puebla de Don Fadrique',
	'ES18167' => 'Purullena',
	'ES18168' => 'Quéntar',
	'ES18170' => 'Rubite',
	'ES18171' => 'Salar',
	'ES18174' => 'Santa Cruz del Comercio',
	'ES18176' => 'Soportújar',
	'ES18177' => 'Sorvilán',
	'ES18178' => 'Torre-Cardela',
	'ES18179' => 'Torvizcón',
	'ES18180' => 'Trevélez',
	'ES18181' => 'Turón',
	'ES18182' => 'Ugíjar',
	'ES18183' => 'Válor',
	'ES18184' => 'Vélez de Benaudalla',
	'ES18185' => 'Ventas de Huelma',
	'ES18187' => 'Villanueva de las Torres',
	'ES18188' => 'Villanueva Mesía',
	'ES18189' => 'Víznar',
	'ES18192' => 'Zafarraya',
	'ES18194' => 'Zújar',
	'ES18901' => 'Taha, La',
	'ES18902' => 'Valle, El',
	'ES18903' => 'Nevada',
	'ES18904' => 'Alpujarra de la Sierra',
	'ES18906' => 'Guájares, Los',
	'ES18907' => 'Valle del Zalabí',
	'ES18908' => 'Villamena',
	'ES18909' => 'Morelábor',
	'ES18910' => 'Pinar, El',
	'ES18912' => 'Cuevas del Campo',
	'ES18913' => 'Zagra',
	'ES18914' => 'Valderrubio',
	'ES18915' => 'Domingo Pérez de Granada',
	'ES18916' => 'Torrenueva Costa',
	'ES19001' => 'Abánades',
	'ES19002' => 'Ablanque',
	'ES19003' => 'Adobes',
	'ES19004' => 'Alaminos',
	'ES19005' => 'Alarilla',
	'ES19006' => 'Albalate de Zorita',
	'ES19007' => 'Albares',
	'ES19008' => 'Albendiego',
	'ES19009' => 'Alcocer',
	'ES19010' => 'Alcolea de las Peñas',
	'ES19011' => 'Alcolea del Pinar',
	'ES19013' => 'Alcoroches',
	'ES19015' => 'Aldeanueva de Guadalajara',
	'ES19016' => 'Algar de Mesa',
	'ES19017' => 'Algora',
	'ES19018' => 'Alhóndiga',
	'ES19019' => 'Alique',
	'ES19020' => 'Almadrones',
	'ES19021' => 'Almoguera',
	'ES19022' => 'Almonacid de Zorita',
	'ES19023' => 'Alocén',
	'ES19027' => 'Alustante',
	'ES19031' => 'Angón',
	'ES19032' => 'Anguita',
	'ES19033' => 'Anquela del Ducado',
	'ES19034' => 'Anquela del Pedregal',
	'ES19036' => 'Aranzueque',
	'ES19037' => 'Arbancón',
	'ES19038' => 'Arbeteta',
	'ES19039' => 'Argecilla',
	'ES19040' => 'Armallones',
	'ES19041' => 'Armuña de Tajuña',
	'ES19042' => 'Arroyo de las Fraguas',
	'ES19043' => 'Atanzón',
	'ES19044' => 'Atienza',
	'ES19045' => 'Auñón',
	'ES19047' => 'Baides',
	'ES19048' => 'Baños de Tajo',
	'ES19049' => 'Bañuelos',
	'ES19050' => 'Barriopedro',
	'ES19051' => 'Berninches',
	'ES19052' => 'Bodera, La',
	'ES19053' => 'Brihuega',
	'ES19054' => 'Budia',
	'ES19055' => 'Bujalaro',
	'ES19057' => 'Bustares',
	'ES19059' => 'Campillo de Dueñas',
	'ES19060' => 'Campillo de Ranas',
	'ES19061' => 'Campisábalos',
	'ES19064' => 'Canredondo',
	'ES19065' => 'Cantalojas',
	'ES19066' => 'Cañizar',
	'ES19067' => 'Cardoso de la Sierra, El',
	'ES19070' => 'Casa de Uceda',
	'ES19073' => 'Casas de San Galindo',
	'ES19074' => 'Caspueñas',
	'ES19075' => 'Castejón de Henares',
	'ES19076' => 'Castellar de la Muela',
	'ES19078' => 'Castilforte',
	'ES19079' => 'Castilnuevo',
	'ES19080' => 'Cendejas de Enmedio',
	'ES19081' => 'Cendejas de la Torre',
	'ES19082' => 'Centenera',
	'ES19086' => 'Cifuentes',
	'ES19087' => 'Cincovillas',
	'ES19088' => 'Ciruelas',
	'ES19089' => 'Ciruelos del Pinar',
	'ES19090' => 'Cobeta',
	'ES19091' => 'Cogollor',
	'ES19092' => 'Cogolludo',
	'ES19095' => 'Condemios de Abajo',
	'ES19096' => 'Condemios de Arriba',
	'ES19097' => 'Congostrina',
	'ES19098' => 'Copernal',
	'ES19099' => 'Corduente',
	'ES19102' => 'Cubillo de Uceda, El',
	'ES19103' => 'Checa',
	'ES19104' => 'Chequilla',
	'ES19105' => 'Chiloeches',
	'ES19106' => 'Chillarón del Rey',
	'ES19107' => 'Driebes',
	'ES19108' => 'Durón',
	'ES19109' => 'Embid',
	'ES19110' => 'Escamilla',
	'ES19111' => 'Escariche',
	'ES19112' => 'Escopete',
	'ES19113' => 'Espinosa de Henares',
	'ES19114' => 'Esplegares',
	'ES19115' => 'Establés',
	'ES19116' => 'Estriégana',
	'ES19117' => 'Fontanar',
	'ES19118' => 'Fuembellida',
	'ES19119' => 'Fuencemillán',
	'ES19120' => 'Fuentelahiguera de Albatages',
	'ES19121' => 'Fuentelencina',
	'ES19122' => 'Fuentelsaz',
	'ES19123' => 'Fuentelviejo',
	'ES19124' => 'Fuentenovilla',
	'ES19125' => 'Gajanejos',
	'ES19126' => 'Galápagos',
	'ES19127' => 'Galve de Sorbe',
	'ES19129' => 'Gascueña de Bornova',
	'ES19132' => 'Henche',
	'ES19133' => 'Heras de Ayuso',
	'ES19134' => 'Herrería',
	'ES19135' => 'Hiendelaencina',
	'ES19136' => 'Hijes',
	'ES19138' => 'Hita',
	'ES19139' => 'Hombrados',
	'ES19142' => 'Hontoba',
	'ES19143' => 'Horche',
	'ES19145' => 'Hortezuela de Océn',
	'ES19146' => 'Huerce, La',
	'ES19147' => 'Huérmeces del Cerro',
	'ES19148' => 'Huertahernando',
	'ES19150' => 'Hueva',
	'ES19151' => 'Humanes',
	'ES19152' => 'Illana',
	'ES19153' => 'Iniéstola',
	'ES19154' => 'Inviernas, Las',
	'ES19155' => 'Irueste',
	'ES19156' => 'Jadraque',
	'ES19157' => 'Jirueque',
	'ES19159' => 'Ledanca',
	'ES19160' => 'Loranca de Tajuña',
	'ES19161' => 'Lupiana',
	'ES19162' => 'Luzaga',
	'ES19163' => 'Luzón',
	'ES19165' => 'Majaelrayo',
	'ES19166' => 'Málaga del Fresno',
	'ES19167' => 'Malaguilla',
	'ES19168' => 'Mandayona',
	'ES19169' => 'Mantiel',
	'ES19170' => 'Maranchón',
	'ES19172' => 'Masegoso de Tajuña',
	'ES19173' => 'Matarrubia',
	'ES19174' => 'Matillas',
	'ES19175' => 'Mazarete',
	'ES19176' => 'Mazuecos',
	'ES19177' => 'Medranda',
	'ES19178' => 'Megina',
	'ES19179' => 'Membrillera',
	'ES19181' => 'Miedes de Atienza',
	'ES19182' => 'Mierla, La',
	'ES19183' => 'Milmarcos',
	'ES19184' => 'Millana',
	'ES19185' => 'Miñosa, La',
	'ES19186' => 'Mirabueno',
	'ES19187' => 'Miralrío',
	'ES19188' => 'Mochales',
	'ES19189' => 'Mohernando',
	'ES19190' => 'Molina de Aragón',
	'ES19191' => 'Monasterio',
	'ES19192' => 'Mondéjar',
	'ES19193' => 'Montarrón',
	'ES19194' => 'Moratilla de los Meleros',
	'ES19195' => 'Morenilla',
	'ES19196' => 'Muduex',
	'ES19197' => 'Navas de Jadraque, Las',
	'ES19198' => 'Negredo',
	'ES19199' => 'Ocentejo',
	'ES19200' => 'Olivar, El',
	'ES19201' => 'Olmeda de Cobeta',
	'ES19202' => 'Olmeda de Jadraque, La',
	'ES19203' => 'Ordial, El',
	'ES19204' => 'Orea',
	'ES19208' => 'Pálmaces de Jadraque',
	'ES19209' => 'Pardos',
	'ES19210' => 'Paredes de Sigüenza',
	'ES19211' => 'Pareja',
	'ES19212' => 'Pastrana',
	'ES19213' => 'Pedregal, El',
	'ES19214' => 'Peñalén',
	'ES19215' => 'Peñalver',
	'ES19216' => 'Peralejos de las Truchas',
	'ES19217' => 'Peralveche',
	'ES19218' => 'Pinilla de Jadraque',
	'ES19219' => 'Pinilla de Molina',
	'ES19220' => 'Pioz',
	'ES19221' => 'Piqueras',
	'ES19222' => 'Pobo de Dueñas, El',
	'ES19223' => 'Poveda de la Sierra',
	'ES19224' => 'Pozo de Almoguera',
	'ES19225' => 'Pozo de Guadalajara',
	'ES19226' => 'Prádena de Atienza',
	'ES19227' => 'Prados Redondos',
	'ES19228' => 'Puebla de Beleña',
	'ES19229' => 'Puebla de Valles',
	'ES19230' => 'Quer',
	'ES19231' => 'Rebollosa de Jadraque',
	'ES19232' => 'Recuenco, El',
	'ES19233' => 'Renera',
	'ES19234' => 'Retiendas',
	'ES19235' => 'Riba de Saelices',
	'ES19237' => 'Rillo de Gallo',
	'ES19238' => 'Riofrío del Llano',
	'ES19239' => 'Robledillo de Mohernando',
	'ES19240' => 'Robledo de Corpes',
	'ES19241' => 'Romanillos de Atienza',
	'ES19242' => 'Romanones',
	'ES19243' => 'Rueda de la Sierra',
	'ES19244' => 'Sacecorbo',
	'ES19245' => 'Sacedón',
	'ES19246' => 'Saelices de la Sal',
	'ES19247' => 'Salmerón',
	'ES19248' => 'San Andrés del Congosto',
	'ES19249' => 'San Andrés del Rey',
	'ES19250' => 'Santiuste',
	'ES19251' => 'Saúca',
	'ES19252' => 'Sayatón',
	'ES19254' => 'Selas',
	'ES19255' => 'Setiles',
	'ES19256' => 'Sienes',
	'ES19257' => 'Sigüenza',
	'ES19258' => 'Solanillos del Extremo',
	'ES19259' => 'Somolinos',
	'ES19260' => 'Sotillo, El',
	'ES19261' => 'Sotodosos',
	'ES19262' => 'Tamajón',
	'ES19263' => 'Taragudo',
	'ES19264' => 'Taravilla',
	'ES19265' => 'Tartanedo',
	'ES19266' => 'Tendilla',
	'ES19267' => 'Terzaga',
	'ES19268' => 'Tierzo',
	'ES19269' => 'Toba, La',
	'ES19270' => 'Tordelrábano',
	'ES19271' => 'Tordellego',
	'ES19272' => 'Tordesilos',
	'ES19274' => 'Torija',
	'ES19277' => 'Torrecuadrada de Molina',
	'ES19278' => 'Torrecuadradilla',
	'ES19279' => 'Torre del Burgo',
	'ES19281' => 'Torremocha de Jadraque',
	'ES19282' => 'Torremocha del Campo',
	'ES19283' => 'Torremocha del Pinar',
	'ES19284' => 'Torremochuela',
	'ES19285' => 'Torrubia',
	'ES19286' => 'Tórtola de Henares',
	'ES19287' => 'Tortuera',
	'ES19288' => 'Tortuero',
	'ES19289' => 'Traíd',
	'ES19290' => 'Trijueque',
	'ES19291' => 'Trillo',
	'ES19293' => 'Uceda',
	'ES19294' => 'Ujados',
	'ES19296' => 'Utande',
	'ES19297' => 'Valdarachas',
	'ES19298' => 'Valdearenas',
	'ES19299' => 'Valdeavellano',
	'ES19300' => 'Valdeaveruelo',
	'ES19301' => 'Valdeconcha',
	'ES19302' => 'Valdegrudas',
	'ES19303' => 'Valdelcubo',
	'ES19304' => 'Valdenuño Fernández',
	'ES19305' => 'Valdepeñas de la Sierra',
	'ES19306' => 'Valderrebollo',
	'ES19307' => 'Valdesotos',
	'ES19308' => 'Valfermoso de Tajuña',
	'ES19309' => 'Valhermoso',
	'ES19310' => 'Valtablado del Río',
	'ES19311' => 'Valverde de los Arroyos',
	'ES19314' => 'Viana de Jadraque',
	'ES19317' => 'Villanueva de Alcorón',
	'ES19318' => 'Villanueva de Argecilla',
	'ES19321' => 'Villares de Jadraque',
	'ES19322' => 'Villaseca de Henares',
	'ES19323' => 'Villaseca de Uceda',
	'ES19324' => 'Villel de Mesa',
	'ES19325' => 'Viñuelas',
	'ES19326' => 'Yebes',
	'ES19327' => 'Yebra',
	'ES19329' => 'Yélamos de Abajo',
	'ES19330' => 'Yélamos de Arriba',
	'ES19331' => 'Yunquera de Henares',
	'ES19332' => 'Yunta, La',
	'ES19333' => 'Zaorejas',
	'ES19334' => 'Zarzuela de Jadraque',
	'ES19335' => 'Zorita de los Canes',
	'ES19901' => 'Semillas',
	'ES20001' => 'Abaltzisketa',
	'ES20002' => 'Aduna',
	'ES20003' => 'Aizarnazabal',
	'ES20004' => 'Albiztur',
	'ES20005' => 'Alegia',
	'ES20006' => 'Alkiza',
	'ES20007' => 'Altzo',
	'ES20008' => 'Amezketa',
	'ES20010' => 'Anoeta',
	'ES20011' => 'Antzuola',
	'ES20012' => 'Arama',
	'ES20014' => 'Asteasu',
	'ES20015' => 'Ataun',
	'ES20016' => 'Aia',
	'ES20020' => 'Beizama',
	'ES20021' => 'Belauntza',
	'ES20022' => 'Berastegi',
	'ES20023' => 'Berrobi',
	'ES20024' => 'Bidania-Goiatz',
	'ES20025' => 'Zegama',
	'ES20026' => 'Zerain',
	'ES20027' => 'Zestoa',
	'ES20028' => 'Zizurkil',
	'ES20031' => 'Elduain',
	'ES20033' => 'Elgeta',
	'ES20034' => 'Eskoriatza',
	'ES20035' => 'Ezkio-Itsaso',
	'ES20037' => 'Gaintza',
	'ES20038' => 'Gabiria',
	'ES20039' => 'Getaria',
	'ES20041' => 'Hernialde',
	'ES20042' => 'Ibarra',
	'ES20043' => 'Idiazabal',
	'ES20044' => 'Ikaztegieta',
	'ES20046' => 'Irura',
	'ES20047' => 'Itsasondo',
	'ES20048' => 'Larraul',
	'ES20050' => 'Leaburu',
	'ES20052' => 'Legorreta',
	'ES20054' => 'Lizartza',
	'ES20057' => 'Mutiloa',
	'ES20058' => 'Olaberria',
	'ES20060' => 'Orexa',
	'ES20062' => 'Ormaiztegi',
	'ES20065' => 'Soraluze-Placencia de las Armas,',
	'ES20066' => 'Errezil',
	'ES20068' => 'Leintz-Gatzaga',
	'ES20070' => 'Segura',
	'ES20078' => 'Zaldibia',
	'ES20901' => 'Mendaro',
	'ES20904' => 'Baliarrain',
	'ES20905' => 'Orendain',
	'ES20906' => 'Altzaga',
	'ES20907' => 'Gaztelu',
	'ES21001' => 'Alájar',
	'ES21003' => 'Almendro, El',
	'ES21004' => 'Almonaster la Real',
	'ES21006' => 'Alosno',
	'ES21008' => 'Aroche',
	'ES21009' => 'Arroyomolinos de León',
	'ES21011' => 'Beas',
	'ES21012' => 'Berrocal',
	'ES21015' => 'Cabezas Rubias',
	'ES21016' => 'Cala',
	'ES21017' => 'Calañas',
	'ES21018' => 'Campillo, El',
	'ES21019' => 'Campofrío',
	'ES21020' => 'Cañaveral de León',
	'ES21022' => 'Castaño del Robledo',
	'ES21023' => 'Cerro de Andévalo, El',
	'ES21024' => 'Corteconcepción',
	'ES21025' => 'Cortegana',
	'ES21026' => 'Cortelazor',
	'ES21027' => 'Cumbres de Enmedio',
	'ES21028' => 'Cumbres de San Bartolomé',
	'ES21029' => 'Cumbres Mayores',
	'ES21030' => 'Chucena',
	'ES21031' => 'Encinasola',
	'ES21032' => 'Escacena del Campo',
	'ES21033' => 'Fuenteheridos',
	'ES21034' => 'Galaroza',
	'ES21036' => 'Granada de Río-Tinto, La',
	'ES21037' => 'Granado, El',
	'ES21038' => 'Higuera de la Sierra',
	'ES21039' => 'Hinojales',
	'ES21040' => 'Hinojos',
	'ES21043' => 'Jabugo',
	'ES21045' => 'Linares de la Sierra',
	'ES21046' => 'Lucena del Puerto',
	'ES21047' => 'Manzanilla',
	'ES21048' => 'Marines, Los',
	'ES21049' => 'Minas de Riotinto',
	'ES21051' => 'Nava, La',
	'ES21053' => 'Niebla',
	'ES21056' => 'Paterna del Campo',
	'ES21057' => 'Paymogo',
	'ES21058' => 'Puebla de Guzmán',
	'ES21059' => 'Puerto Moral',
	'ES21062' => 'Rosal de la Frontera',
	'ES21063' => 'San Bartolomé de la Torre',
	'ES21065' => 'Sanlúcar de Guadiana',
	'ES21066' => 'San Silvestre de Guzmán',
	'ES21067' => 'Santa Ana la Real',
	'ES21068' => 'Santa Bárbara de Casa',
	'ES21069' => 'Santa Olalla del Cala',
	'ES21071' => 'Valdelarco',
	'ES21073' => 'Villablanca',
	'ES21074' => 'Villalba del Alcor',
	'ES21075' => 'Villanueva de las Cruces',
	'ES21076' => 'Villanueva de los Castillejos',
	'ES21077' => 'Villarrasa',
	'ES21078' => 'Zalamea la Real',
	'ES21079' => 'Zufre',
	'ES21902' => 'Zarza-Perrunal, La',
	'ES22001' => 'Abiego',
	'ES22002' => 'Abizanda',
	'ES22003' => 'Adahuesca',
	'ES22004' => 'Agüero',
	'ES22006' => 'Aisa',
	'ES22007' => 'Albalate de Cinca',
	'ES22008' => 'Albalatillo',
	'ES22009' => 'Albelda',
	'ES22011' => 'Albero Alto',
	'ES22012' => 'Albero Bajo',
	'ES22013' => 'Alberuela de Tubo',
	'ES22014' => 'Alcalá de Gurrea',
	'ES22015' => 'Alcalá del Obispo',
	'ES22016' => 'Alcampell',
	'ES22017' => 'Alcolea de Cinca',
	'ES22018' => 'Alcubierre',
	'ES22019' => 'Alerre',
	'ES22020' => 'Alfántega',
	'ES22021' => 'Almudévar',
	'ES22022' => 'Almunia de San Juan',
	'ES22023' => 'Almuniente',
	'ES22024' => 'Alquézar',
	'ES22025' => 'Altorricón',
	'ES22027' => 'Angüés',
	'ES22028' => 'Ansó',
	'ES22029' => 'Antillón',
	'ES22032' => 'Aragüés del Puerto',
	'ES22035' => 'Arén',
	'ES22036' => 'Argavieso',
	'ES22037' => 'Arguis',
	'ES22039' => 'Ayerbe',
	'ES22040' => 'Azanuy-Alins',
	'ES22041' => 'Azara',
	'ES22042' => 'Azlor',
	'ES22043' => 'Baélls',
	'ES22044' => 'Bailo',
	'ES22045' => 'Baldellou',
	'ES22046' => 'Ballobar',
	'ES22047' => 'Banastás',
	'ES22049' => 'Barbués',
	'ES22050' => 'Barbuñales',
	'ES22051' => 'Bárcabo',
	'ES22052' => 'Belver de Cinca',
	'ES22053' => 'Benabarre',
	'ES22054' => 'Benasque',
	'ES22055' => 'Berbegal',
	'ES22057' => 'Bielsa',
	'ES22058' => 'Bierge',
	'ES22059' => 'Biescas',
	'ES22060' => 'Binaced',
	'ES22062' => 'Bisaurri',
	'ES22063' => 'Biscarrués',
	'ES22064' => 'Blecua y Torres',
	'ES22066' => 'Boltaña',
	'ES22067' => 'Bonansa',
	'ES22068' => 'Borau',
	'ES22069' => 'Broto',
	'ES22072' => 'Caldearenas',
	'ES22074' => 'Campo',
	'ES22075' => 'Camporrélls',
	'ES22076' => 'Canal de Berdún',
	'ES22077' => 'Candasnos',
	'ES22078' => 'Canfranc',
	'ES22079' => 'Capdesaso',
	'ES22080' => 'Capella',
	'ES22081' => 'Casbas de Huesca',
	'ES22082' => 'Castejón del Puente',
	'ES22083' => 'Castejón de Monegros',
	'ES22084' => 'Castejón de Sos',
	'ES22085' => 'Castelflorite',
	'ES22086' => 'Castiello de Jaca',
	'ES22087' => 'Castigaleu',
	'ES22088' => 'Castillazuelo',
	'ES22089' => 'Castillonroy',
	'ES22090' => 'Colungo',
	'ES22094' => 'Chalamera',
	'ES22095' => 'Chía',
	'ES22096' => 'Chimillas',
	'ES22099' => 'Esplús',
	'ES22102' => 'Estada',
	'ES22103' => 'Estadilla',
	'ES22105' => 'Estopiñán del Castillo',
	'ES22106' => 'Fago',
	'ES22107' => 'Fanlo',
	'ES22109' => 'Fiscal',
	'ES22110' => 'Fonz',
	'ES22111' => 'Foradada del Toscar',
	'ES22113' => 'Fueva, La',
	'ES22114' => 'Gistaín',
	'ES22115' => 'Grado, El',
	'ES22116' => 'Grañén',
	'ES22117' => 'Graus',
	'ES22119' => 'Gurrea de Gállego',
	'ES22122' => 'Hoz de Jaca',
	'ES22124' => 'Huerto',
	'ES22126' => 'Ibieca',
	'ES22127' => 'Igriés',
	'ES22128' => 'Ilche',
	'ES22129' => 'Isábena',
	'ES22131' => 'Jasa',
	'ES22133' => 'Labuerda',
	'ES22135' => 'Laluenga',
	'ES22136' => 'Lalueza',
	'ES22137' => 'Lanaja',
	'ES22139' => 'Laperdiguera',
	'ES22141' => 'Lascellas-Ponzano',
	'ES22142' => 'Lascuarre',
	'ES22143' => 'Laspaúles',
	'ES22144' => 'Laspuña',
	'ES22149' => 'Loarre',
	'ES22150' => 'Loporzano',
	'ES22151' => 'Loscorrales',
	'ES22155' => 'Monesma y Cajigar',
	'ES22156' => 'Monflorite-Lascasas',
	'ES22157' => 'Montanuy',
	'ES22160' => 'Naval',
	'ES22162' => 'Novales',
	'ES22163' => 'Nueno',
	'ES22164' => 'Olvena',
	'ES22165' => 'Ontiñena',
	'ES22167' => 'Osso de Cinca',
	'ES22168' => 'Palo',
	'ES22170' => 'Panticosa',
	'ES22172' => 'Peñalba',
	'ES22173' => 'Peñas de Riglos, Las',
	'ES22174' => 'Peralta de Alcofea',
	'ES22175' => 'Peralta de Calasanz',
	'ES22176' => 'Peraltilla',
	'ES22177' => 'Perarrúa',
	'ES22178' => 'Pertusa',
	'ES22181' => 'Piracés',
	'ES22182' => 'Plan',
	'ES22184' => 'Poleñino',
	'ES22186' => 'Pozán de Vero',
	'ES22187' => 'Puebla de Castro, La',
	'ES22188' => 'Puente de Montañana',
	'ES22189' => 'Puértolas',
	'ES22190' => 'Pueyo de Araguás, El',
	'ES22193' => 'Pueyo de Santa Cruz',
	'ES22195' => 'Quicena',
	'ES22197' => 'Robres',
	'ES22200' => 'Sahún',
	'ES22201' => 'Salas Altas',
	'ES22202' => 'Salas Bajas',
	'ES22203' => 'Salillas',
	'ES22204' => 'Sallent de Gállego',
	'ES22205' => 'San Esteban de Litera',
	'ES22206' => 'Sangarrén',
	'ES22207' => 'San Juan de Plan',
	'ES22208' => 'Santa Cilia',
	'ES22209' => 'Santa Cruz de la Serós',
	'ES22212' => 'Santaliestra y San Quílez',
	'ES22213' => 'Sariñena',
	'ES22214' => 'Secastilla',
	'ES22215' => 'Seira',
	'ES22217' => 'Sena',
	'ES22218' => 'Senés de Alcubierre',
	'ES22220' => 'Sesa',
	'ES22221' => 'Sesué',
	'ES22222' => 'Siétamo',
	'ES22223' => 'Sopeira',
	'ES22225' => 'Tamarite de Litera',
	'ES22226' => 'Tardienta',
	'ES22227' => 'Tella-Sin',
	'ES22228' => 'Tierz',
	'ES22229' => 'Tolva',
	'ES22230' => 'Torla-Ordesa',
	'ES22232' => 'Torralba de Aragón',
	'ES22233' => 'Torre la Ribera',
	'ES22234' => 'Torrente de Cinca',
	'ES22235' => 'Torres de Alcanadre',
	'ES22236' => 'Torres de Barbués',
	'ES22239' => 'Tramaced',
	'ES22242' => 'Valfarta',
	'ES22243' => 'Valle de Bardají',
	'ES22244' => 'Valle de Lierp',
	'ES22245' => 'Velilla de Cinca',
	'ES22246' => 'Beranuy',
	'ES22247' => 'Viacamp y Litera',
	'ES22248' => 'Vicién',
	'ES22249' => 'Villanova',
	'ES22250' => 'Villanúa',
	'ES22251' => 'Villanueva de Sigena',
	'ES22252' => 'Yebra de Basa',
	'ES22253' => 'Yésero',
	'ES22254' => 'Zaidín',
	'ES22901' => 'Valle de Hecho',
	'ES22902' => 'Puente la Reina de Jaca',
	'ES22903' => 'San Miguel del Cinca',
	'ES22904' => 'Sotonera, La',
	'ES22905' => 'Lupiñén-Ortilla',
	'ES22906' => 'Santa María de Dulcis',
	'ES22907' => 'Aínsa-Sobrarbe',
	'ES22908' => 'Hoz y Costean',
	'ES22909' => 'Vencillón',
	'ES23001' => 'Albanchez de Mágina',
	'ES23004' => 'Aldeaquemada',
	'ES23007' => 'Arjonilla',
	'ES23008' => 'Arquillos',
	'ES23011' => 'Baños de la Encina',
	'ES23014' => 'Begíjar',
	'ES23015' => 'Bélmez de la Moraleda',
	'ES23016' => 'Benatae',
	'ES23017' => 'Cabra del Santo Cristo',
	'ES23018' => 'Cambil',
	'ES23019' => 'Campillo de Arenas',
	'ES23020' => 'Canena',
	'ES23021' => 'Carboneros',
	'ES23025' => 'Castellar',
	'ES23026' => 'Castillo de Locubín',
	'ES23027' => 'Cazalilla',
	'ES23029' => 'Chiclana de Segura',
	'ES23030' => 'Chilluévar',
	'ES23031' => 'Escañuela',
	'ES23032' => 'Espeluy',
	'ES23033' => 'Frailes',
	'ES23034' => 'Fuensanta de Martos',
	'ES23035' => 'Fuerte del Rey',
	'ES23037' => 'Génave',
	'ES23039' => 'Guarromán',
	'ES23040' => 'Lahiguera',
	'ES23041' => 'Higuera de Calatrava',
	'ES23042' => 'Hinojares',
	'ES23043' => 'Hornos',
	'ES23045' => 'Huesa',
	'ES23046' => 'Ibros',
	'ES23047' => 'Iruela, La',
	'ES23048' => 'Iznatoraf',
	'ES23049' => 'Jabalquinto',
	'ES23051' => 'Jamilena',
	'ES23052' => 'Jimena',
	'ES23054' => 'Larva',
	'ES23056' => 'Lopera',
	'ES23057' => 'Lupión',
	'ES23062' => 'Montizón',
	'ES23063' => 'Navas de San Juan',
	'ES23064' => 'Noalejo',
	'ES23065' => 'Orcera',
	'ES23067' => 'Pegalajar',
	'ES23070' => 'Pozo Alcón',
	'ES23071' => 'Puente de Génave',
	'ES23072' => 'Puerta de Segura, La',
	'ES23074' => 'Rus',
	'ES23075' => 'Sabiote',
	'ES23076' => 'Santa Elena',
	'ES23077' => 'Santiago de Calatrava',
	'ES23079' => 'Santisteban del Puerto',
	'ES23080' => 'Santo Tomé',
	'ES23081' => 'Segura de la Sierra',
	'ES23082' => 'Siles',
	'ES23084' => 'Sorihuela del Guadalimar',
	'ES23085' => 'Torreblascopedro',
	'ES23090' => 'Torres',
	'ES23091' => 'Torres de Albánchez',
	'ES23093' => 'Valdepeñas de Jaén',
	'ES23094' => 'Vilches',
	'ES23096' => 'Villanueva de la Reina',
	'ES23098' => 'Villardompardo',
	'ES23101' => 'Villarrodrigo',
	'ES23901' => 'Cárcheles',
	'ES23902' => 'Bedmar y Garcíez',
	'ES23903' => 'Villatorres',
	'ES23904' => 'Santiago-Pontones',
	'ES23905' => 'Arroyo del Ojanco',
	'ES24001' => 'Acebedo',
	'ES24002' => 'Algadefe',
	'ES24003' => 'Alija del Infantado',
	'ES24004' => 'Almanza',
	'ES24005' => 'Antigua, La',
	'ES24006' => 'Ardón',
	'ES24007' => 'Arganza',
	'ES24009' => 'Balboa',
	'ES24011' => 'Barjas',
	'ES24012' => 'Barrios de Luna, Los',
	'ES24015' => 'Benavides',
	'ES24016' => 'Benuza',
	'ES24017' => 'Bercianos del Páramo',
	'ES24018' => 'Bercianos del Real Camino',
	'ES24019' => 'Berlanga del Bierzo',
	'ES24020' => 'Boca de Huérgano',
	'ES24021' => 'Boñar',
	'ES24022' => 'Borrenes',
	'ES24023' => 'Brazuelo',
	'ES24024' => 'Burgo Ranero, El',
	'ES24025' => 'Burón',
	'ES24026' => 'Bustillo del Páramo',
	'ES24027' => 'Cabañas Raras',
	'ES24028' => 'Cabreros del Río',
	'ES24029' => 'Cabrillanes',
	'ES24031' => 'Calzada del Coto',
	'ES24032' => 'Campazas',
	'ES24033' => 'Campo de Villavidel',
	'ES24034' => 'Camponaraya',
	'ES24036' => 'Candín',
	'ES24037' => 'Cármenes',
	'ES24038' => 'Carracedelo',
	'ES24039' => 'Carrizo',
	'ES24040' => 'Carrocera',
	'ES24041' => 'Carucedo',
	'ES24042' => 'Castilfalé',
	'ES24043' => 'Castrillo de Cabrera',
	'ES24044' => 'Castrillo de la Valduerna',
	'ES24046' => 'Castrocalbón',
	'ES24047' => 'Castrocontrigo',
	'ES24049' => 'Castropodame',
	'ES24050' => 'Castrotierra de Valmadrigal',
	'ES24051' => 'Cea',
	'ES24052' => 'Cebanico',
	'ES24053' => 'Cebrones del Río',
	'ES24054' => 'Cimanes de la Vega',
	'ES24055' => 'Cimanes del Tejar',
	'ES24056' => 'Cistierna',
	'ES24057' => 'Congosto',
	'ES24058' => 'Corbillos de los Oteros',
	'ES24059' => 'Corullón',
	'ES24060' => 'Crémenes',
	'ES24061' => 'Cuadros',
	'ES24062' => 'Cubillas de los Oteros',
	'ES24063' => 'Cubillas de Rueda',
	'ES24064' => 'Cubillos del Sil',
	'ES24065' => 'Chozas de Abajo',
	'ES24066' => 'Destriana',
	'ES24067' => 'Encinedo',
	'ES24068' => 'Ercina, La',
	'ES24069' => 'Escobar de Campos',
	'ES24070' => 'Fabero',
	'ES24071' => 'Folgoso de la Ribera',
	'ES24073' => 'Fresno de la Vega',
	'ES24074' => 'Fuentes de Carbajal',
	'ES24076' => 'Garrafe de Torío',
	'ES24077' => 'Gordaliza del Pino',
	'ES24078' => 'Gordoncillo',
	'ES24079' => 'Gradefes',
	'ES24080' => 'Grajal de Campos',
	'ES24081' => 'Gusendos de los Oteros',
	'ES24082' => 'Hospital de Órbigo',
	'ES24083' => 'Igüeña',
	'ES24084' => 'Izagre',
	'ES24086' => 'Joarilla de las Matas',
	'ES24087' => 'Laguna Dalga',
	'ES24088' => 'Laguna de Negrillos',
	'ES24090' => 'Lucillo',
	'ES24091' => 'Luyego',
	'ES24092' => 'Llamas de la Ribera',
	'ES24093' => 'Magaz de Cepeda',
	'ES24094' => 'Mansilla de las Mulas',
	'ES24095' => 'Mansilla Mayor',
	'ES24096' => 'Maraña',
	'ES24097' => 'Matadeón de los Oteros',
	'ES24098' => 'Matallana de Torío',
	'ES24099' => 'Matanza',
	'ES24100' => 'Molinaseca',
	'ES24101' => 'Murias de Paredes',
	'ES24102' => 'Noceda del Bierzo',
	'ES24103' => 'Oencia',
	'ES24104' => 'Omañas, Las',
	'ES24105' => 'Onzonilla',
	'ES24106' => 'Oseja de Sajambre',
	'ES24107' => 'Pajares de los Oteros',
	'ES24108' => 'Palacios de la Valduerna',
	'ES24109' => 'Palacios del Sil',
	'ES24110' => 'Páramo del Sil',
	'ES24112' => 'Peranzanes',
	'ES24113' => 'Pobladura de Pelayo García',
	'ES24114' => 'Pola de Gordón, La',
	'ES24116' => 'Posada de Valdeón',
	'ES24117' => 'Pozuelo del Páramo',
	'ES24118' => 'Prado de la Guzpeña',
	'ES24119' => 'Priaranza del Bierzo',
	'ES24120' => 'Prioro',
	'ES24121' => 'Puebla de Lillo',
	'ES24122' => 'Puente de Domingo Flórez',
	'ES24123' => 'Quintana del Castillo',
	'ES24124' => 'Quintana del Marco',
	'ES24125' => 'Quintana y Congosto',
	'ES24127' => 'Regueras de Arriba',
	'ES24129' => 'Reyero',
	'ES24130' => 'Riaño',
	'ES24131' => 'Riego de la Vega',
	'ES24132' => 'Riello',
	'ES24133' => 'Rioseco de Tapia',
	'ES24134' => 'Robla, La',
	'ES24136' => 'Roperuelos del Páramo',
	'ES24137' => 'Sabero',
	'ES24139' => 'Sahagún',
	'ES24141' => 'San Adrián del Valle',
	'ES24143' => 'Sancedo',
	'ES24144' => 'San Cristóbal de la Polantera',
	'ES24145' => 'San Emiliano',
	'ES24146' => 'San Esteban de Nogales',
	'ES24148' => 'San Justo de la Vega',
	'ES24149' => 'San Millán de los Caballeros',
	'ES24150' => 'San Pedro Bercianos',
	'ES24151' => 'Santa Colomba de Curueño',
	'ES24152' => 'Santa Colomba de Somoza',
	'ES24153' => 'Santa Cristina de Valmadrigal',
	'ES24154' => 'Santa Elena de Jamuz',
	'ES24155' => 'Santa María de la Isla',
	'ES24156' => 'Santa María del Monte de Cea',
	'ES24157' => 'Santa María del Páramo',
	'ES24158' => 'Santa María de Ordás',
	'ES24159' => 'Santa Marina del Rey',
	'ES24160' => 'Santas Martas',
	'ES24161' => 'Santiago Millas',
	'ES24162' => 'Santovenia de la Valdoncina',
	'ES24164' => 'Sena de Luna',
	'ES24165' => 'Sobrado',
	'ES24166' => 'Soto de la Vega',
	'ES24167' => 'Soto y Amío',
	'ES24168' => 'Toral de los Guzmanes',
	'ES24169' => 'Toreno',
	'ES24170' => 'Torre del Bierzo',
	'ES24171' => 'Trabadelo',
	'ES24172' => 'Truchas',
	'ES24173' => 'Turcia',
	'ES24174' => 'Urdiales del Páramo',
	'ES24175' => 'Valdefresno',
	'ES24176' => 'Valdefuentes del Páramo',
	'ES24177' => 'Valdelugueros',
	'ES24178' => 'Valdemora',
	'ES24179' => 'Valdepiélago',
	'ES24180' => 'Valdepolo',
	'ES24181' => 'Valderas',
	'ES24182' => 'Valderrey',
	'ES24183' => 'Valderrueda',
	'ES24184' => 'Valdesamario',
	'ES24185' => 'Val de San Lorenzo',
	'ES24187' => 'Valdevimbre',
	'ES24190' => 'Valverde-Enrique',
	'ES24191' => 'Vallecillo',
	'ES24193' => 'Vecilla, La',
	'ES24194' => 'Vegacervera',
	'ES24196' => 'Vega de Espinareda',
	'ES24197' => 'Vega de Infanzones',
	'ES24198' => 'Vega de Valcarce',
	'ES24199' => 'Vegaquemada',
	'ES24201' => 'Vegas del Condado',
	'ES24203' => 'Villabraz',
	'ES24205' => 'Villadangos del Páramo',
	'ES24206' => 'Toral de los Vados',
	'ES24207' => 'Villademor de la Vega',
	'ES24209' => 'Villafranca del Bierzo',
	'ES24210' => 'Villagatón',
	'ES24211' => 'Villamandos',
	'ES24212' => 'Villamañán',
	'ES24213' => 'Villamartín de Don Sancho',
	'ES24214' => 'Villamejil',
	'ES24215' => 'Villamol',
	'ES24216' => 'Villamontán de la Valduerna',
	'ES24217' => 'Villamoratiel de las Matas',
	'ES24218' => 'Villanueva de las Manzanas',
	'ES24219' => 'Villaobispo de Otero',
	'ES24221' => 'Villaquejida',
	'ES24223' => 'Villarejo de Órbigo',
	'ES24224' => 'Villares de Órbigo',
	'ES24225' => 'Villasabariego',
	'ES24226' => 'Villaselán',
	'ES24227' => 'Villaturiel',
	'ES24228' => 'Villazala',
	'ES24229' => 'Villazanzo de Valderaduey',
	'ES24230' => 'Zotes del Páramo',
	'ES24901' => 'Villamanín',
	'ES24902' => 'Villaornate y Castro',
	'ES25001' => 'Abella de la Conca',
	'ES25002' => 'Àger',
	'ES25004' => 'Alamús, Els',
	'ES25005' => 'Alàs i Cerc',
	'ES25006' => 'Albagés, L',
	'ES25007' => 'Albatàrrec',
	'ES25008' => 'Albesa',
	'ES25009' => 'Albi, L',
	'ES25010' => 'Alcanó',
	'ES25012' => 'Alcoletge',
	'ES25013' => 'Alfarràs',
	'ES25014' => 'Alfés',
	'ES25015' => 'Algerri',
	'ES25016' => 'Alguaire',
	'ES25017' => 'Alins',
	'ES25020' => 'Almatret',
	'ES25021' => 'Almenar',
	'ES25022' => 'Alòs de Balaguer',
	'ES25024' => 'Alt Àneu',
	'ES25025' => 'Naut Aran',
	'ES25027' => 'Anglesola',
	'ES25029' => 'Arbeca',
	'ES25030' => 'Pont de Bar, El',
	'ES25031' => 'Arres',
	'ES25032' => 'Arsèguel',
	'ES25033' => 'Artesa de Lleida',
	'ES25034' => 'Artesa de Segre',
	'ES25035' => 'Sentiu de Sió, La',
	'ES25036' => 'Aspa',
	'ES25037' => 'Avellanes i Santa Linya, Les',
	'ES25038' => 'Aitona',
	'ES25039' => 'Baix Pallars',
	'ES25041' => 'Barbens',
	'ES25042' => 'Baronia de Rialb, La',
	'ES25043' => 'Vall de Boí, La',
	'ES25044' => 'Bassella',
	'ES25045' => 'Bausen',
	'ES25046' => 'Belianes',
	'ES25047' => 'Bellcaire dUrgell',
	'ES25048' => 'Bell-lloc dUrgell',
	'ES25049' => 'Bellmunt dUrgell',
	'ES25051' => 'Bellver de Cerdanya',
	'ES25052' => 'Bellvís',
	'ES25053' => 'Benavent de Segrià',
	'ES25055' => 'Biosca',
	'ES25056' => 'Bovera',
	'ES25057' => 'Bòrdes, Es',
	'ES25059' => 'Bossòst',
	'ES25060' => 'Cabanabona',
	'ES25061' => 'Cabó',
	'ES25062' => 'Camarasa',
	'ES25063' => 'Canejan',
	'ES25064' => 'Castellar de la Ribera',
	'ES25067' => 'Castelldans',
	'ES25068' => 'Castellnou de Seana',
	'ES25069' => 'Castelló de Farfanya',
	'ES25070' => 'Castellserà',
	'ES25071' => 'Cava',
	'ES25073' => 'Cervià de les Garrigues',
	'ES25074' => 'Ciutadilla',
	'ES25075' => 'Clariana de Cardener',
	'ES25076' => 'Cogul, El',
	'ES25077' => 'Coll de Nargó',
	'ES25078' => 'Corbins',
	'ES25079' => 'Cubells',
	'ES25081' => 'Espluga Calba, L',
	'ES25082' => 'Espot',
	'ES25085' => 'Estaràs',
	'ES25086' => 'Esterri dÀneu',
	'ES25087' => 'Esterri de Cardós',
	'ES25088' => 'Estamariu',
	'ES25089' => 'Farrera',
	'ES25092' => 'Floresta, La',
	'ES25093' => 'Fondarella',
	'ES25094' => 'Foradada',
	'ES25096' => 'Fuliola, La',
	'ES25097' => 'Fulleda',
	'ES25098' => 'Gavet de la Conca',
	'ES25099' => 'Golmés',
	'ES25100' => 'Gósol',
	'ES25101' => 'Granadella, La',
	'ES25102' => 'Granja dEscarp, La',
	'ES25103' => 'Granyanella',
	'ES25104' => 'Granyena de Segarra',
	'ES25105' => 'Granyena de les Garrigues',
	'ES25109' => 'Guimerà',
	'ES25111' => 'Guixers',
	'ES25112' => 'Ivars de Noguera',
	'ES25113' => 'Ivars dUrgell',
	'ES25114' => 'Ivorra',
	'ES25115' => 'Isona i Conca Dellà',
	'ES25118' => 'Juncosa',
	'ES25119' => 'Juneda',
	'ES25121' => 'Les',
	'ES25122' => 'Linyola',
	'ES25123' => 'Lladorre',
	'ES25124' => 'Lladurs',
	'ES25125' => 'Llardecans',
	'ES25126' => 'Llavorsí',
	'ES25127' => 'Lles de Cerdanya',
	'ES25128' => 'Llimiana',
	'ES25129' => 'Llobera',
	'ES25130' => 'Maldà',
	'ES25131' => 'Massalcoreig',
	'ES25132' => 'Massoteres',
	'ES25133' => 'Maials',
	'ES25134' => 'Menàrguens',
	'ES25135' => 'Miralcamp',
	'ES25136' => 'Molsosa, La',
	'ES25138' => 'Montgai',
	'ES25139' => 'Montellà i Martinet',
	'ES25140' => 'Montferrer i Castellbò',
	'ES25141' => 'Montoliu de Segarra',
	'ES25142' => 'Montoliu de Lleida',
	'ES25143' => 'Montornès de Segarra',
	'ES25145' => 'Nalec',
	'ES25146' => 'Navès',
	'ES25148' => 'Odèn',
	'ES25149' => 'Oliana',
	'ES25150' => 'Oliola',
	'ES25151' => 'Olius',
	'ES25152' => 'Oluges, Les',
	'ES25153' => 'Omellons, Els',
	'ES25154' => 'Omells de na Gaia, Els',
	'ES25155' => 'Organyà',
	'ES25156' => 'Os de Balaguer',
	'ES25157' => 'Ossó de Sió',
	'ES25158' => 'Palau dAnglesola, El',
	'ES25161' => 'Conca de Dalt',
	'ES25163' => 'Coma i la Pedra, La',
	'ES25164' => 'Penelles',
	'ES25165' => 'Peramola',
	'ES25166' => 'Pinell de Solsonès',
	'ES25167' => 'Pinós',
	'ES25168' => 'Poal, El',
	'ES25169' => 'Pobla de Cérvoles, La',
	'ES25170' => 'Bellaguarda',
	'ES25171' => 'Pobla de Segur, La',
	'ES25172' => 'Ponts',
	'ES25173' => 'Pont de Suert, El',
	'ES25174' => 'Portella, La',
	'ES25175' => 'Prats i Sansor',
	'ES25176' => 'Preixana',
	'ES25177' => 'Preixens',
	'ES25179' => 'Prullans',
	'ES25180' => 'Puiggròs',
	'ES25181' => 'Puigverd dAgramunt',
	'ES25182' => 'Puigverd de Lleida',
	'ES25183' => 'Rialp',
	'ES25185' => 'Ribera dUrgellet',
	'ES25186' => 'Riner',
	'ES25189' => 'Rosselló',
	'ES25190' => 'Salàs de Pallars',
	'ES25191' => 'Sanaüja',
	'ES25192' => 'Sant Guim de Freixenet',
	'ES25193' => 'Sant Llorenç de Morunys',
	'ES25194' => 'Sant Ramon',
	'ES25196' => 'Sant Esteve de la Sarga',
	'ES25197' => 'Sant Guim de la Plana',
	'ES25200' => 'Sarroca de Lleida',
	'ES25201' => 'Sarroca de Bellera',
	'ES25202' => 'Senterada',
	'ES25204' => 'Seròs',
	'ES25205' => 'Sidamon',
	'ES25206' => 'Soleràs, El',
	'ES25208' => 'Soriguera',
	'ES25209' => 'Sort',
	'ES25210' => 'Soses',
	'ES25211' => 'Sudanell',
	'ES25212' => 'Sunyer',
	'ES25215' => 'Talarn',
	'ES25216' => 'Talavera',
	'ES25218' => 'Tarrés',
	'ES25219' => 'Tarroja de Segarra',
	'ES25220' => 'Térmens',
	'ES25221' => 'Tírvia',
	'ES25222' => 'Tiurana',
	'ES25223' => 'Torà',
	'ES25224' => 'Torms, Els',
	'ES25225' => 'Tornabous',
	'ES25226' => 'Torrebesses',
	'ES25227' => 'Torre de Cabdella, La',
	'ES25228' => 'Torrefarrera',
	'ES25230' => 'Torregrossa',
	'ES25231' => 'Torrelameu',
	'ES25232' => 'Torres de Segre',
	'ES25233' => 'Torre-serona',
	'ES25238' => 'Vallbona de les Monges',
	'ES25239' => 'Valls de Valira, Les',
	'ES25240' => 'Vallfogona de Balaguer',
	'ES25242' => 'Verdú',
	'ES25244' => 'Vilagrassa',
	'ES25245' => 'Vilaller',
	'ES25247' => 'Vilamòs',
	'ES25248' => 'Vilanova de Bellpuig',
	'ES25249' => 'Vilanova de lAguda',
	'ES25250' => 'Vilanova de Meià',
	'ES25251' => 'Vilanova de Segrià',
	'ES25252' => 'Vila-sana',
	'ES25253' => 'Vilosell, El',
	'ES25254' => 'Vilanova de la Barca',
	'ES25255' => 'Vinaixa',
	'ES25901' => 'Vall de Cardós',
	'ES25902' => 'Sant Martí de Riucorb',
	'ES25903' => 'Guingueta dÀneu, La',
	'ES25904' => 'Castell de Mur',
	'ES25905' => 'Ribera dOndara',
	'ES25906' => 'Valls dAguilar, Les',
	'ES25907' => 'Torrefeta i Florejacs',
	'ES25908' => 'Fígols i Alinyà',
	'ES25909' => 'Vansa i Fórnols, La',
	'ES25910' => 'Josa i Tuixén',
	'ES25911' => 'Plans de Sió, Els',
	'ES25912' => 'Gimenells i el Pla de la Font',
	'ES25913' => 'Riu de Cerdanya',
	'ES26001' => 'Ábalos',
	'ES26002' => 'Agoncillo',
	'ES26003' => 'Aguilar del Río Alhama',
	'ES26004' => 'Ajamil de Cameros',
	'ES26005' => 'Albelda de Iregua',
	'ES26006' => 'Alberite',
	'ES26007' => 'Alcanadre',
	'ES26008' => 'Aldeanueva de Ebro',
	'ES26009' => 'Alesanco',
	'ES26010' => 'Alesón',
	'ES26012' => 'Almarza de Cameros',
	'ES26013' => 'Anguciana',
	'ES26014' => 'Anguiano',
	'ES26015' => 'Arenzana de Abajo',
	'ES26016' => 'Arenzana de Arriba',
	'ES26017' => 'Arnedillo',
	'ES26019' => 'Arrúbal',
	'ES26020' => 'Ausejo',
	'ES26021' => 'Autol',
	'ES26022' => 'Azofra',
	'ES26023' => 'Badarán',
	'ES26024' => 'Bañares',
	'ES26025' => 'Baños de Rioja',
	'ES26026' => 'Baños de Río Tobía',
	'ES26027' => 'Berceo',
	'ES26028' => 'Bergasa',
	'ES26029' => 'Bergasillas Bajera',
	'ES26030' => 'Bezares',
	'ES26031' => 'Bobadilla',
	'ES26032' => 'Brieva de Cameros',
	'ES26033' => 'Briñas',
	'ES26034' => 'Briones',
	'ES26035' => 'Cabezón de Cameros',
	'ES26037' => 'Camprovín',
	'ES26038' => 'Canales de la Sierra',
	'ES26039' => 'Canillas de Río Tuerto',
	'ES26040' => 'Cañas',
	'ES26041' => 'Cárdenas',
	'ES26042' => 'Casalarreina',
	'ES26043' => 'Castañares de Rioja',
	'ES26044' => 'Castroviejo',
	'ES26045' => 'Cellorigo',
	'ES26046' => 'Cenicero',
	'ES26047' => 'Cervera del Río Alhama',
	'ES26048' => 'Cidamón',
	'ES26049' => 'Cihuri',
	'ES26050' => 'Cirueña',
	'ES26051' => 'Clavijo',
	'ES26052' => 'Cordovín',
	'ES26053' => 'Corera',
	'ES26054' => 'Cornago',
	'ES26055' => 'Corporales',
	'ES26056' => 'Cuzcurrita de Río Tirón',
	'ES26057' => 'Daroca de Rioja',
	'ES26058' => 'Enciso',
	'ES26059' => 'Entrena',
	'ES26060' => 'Estollo',
	'ES26061' => 'Ezcaray',
	'ES26062' => 'Foncea',
	'ES26063' => 'Fonzaleche',
	'ES26064' => 'Fuenmayor',
	'ES26065' => 'Galbárruli',
	'ES26066' => 'Galilea',
	'ES26067' => 'Gallinero de Cameros',
	'ES26068' => 'Gimileo',
	'ES26069' => 'Grañón',
	'ES26070' => 'Grávalos',
	'ES26072' => 'Herce',
	'ES26073' => 'Herramélluri',
	'ES26074' => 'Hervías',
	'ES26075' => 'Hormilla',
	'ES26076' => 'Hormilleja',
	'ES26077' => 'Hornillos de Cameros',
	'ES26078' => 'Hornos de Moncalvillo',
	'ES26079' => 'Huércanos',
	'ES26080' => 'Igea',
	'ES26081' => 'Jalón de Cameros',
	'ES26082' => 'Laguna de Cameros',
	'ES26083' => 'Lagunilla del Jubera',
	'ES26086' => 'Ledesma de la Cogolla',
	'ES26087' => 'Leiva',
	'ES26088' => 'Leza de Río Leza',
	'ES26091' => 'Lumbreras',
	'ES26092' => 'Manjarrés',
	'ES26093' => 'Mansilla de la Sierra',
	'ES26094' => 'Manzanares de Rioja',
	'ES26095' => 'Matute',
	'ES26096' => 'Medrano',
	'ES26098' => 'Munilla',
	'ES26099' => 'Murillo de Río Leza',
	'ES26100' => 'Muro de Aguas',
	'ES26101' => 'Muro en Cameros',
	'ES26103' => 'Nalda',
	'ES26104' => 'Navajún',
	'ES26105' => 'Navarrete',
	'ES26106' => 'Nestares',
	'ES26107' => 'Nieva de Cameros',
	'ES26108' => 'Ocón',
	'ES26109' => 'Ochánduri',
	'ES26110' => 'Ojacastro',
	'ES26111' => 'Ollauri',
	'ES26112' => 'Ortigosa de Cameros',
	'ES26113' => 'Pazuengos',
	'ES26114' => 'Pedroso',
	'ES26115' => 'Pinillos',
	'ES26117' => 'Pradejón',
	'ES26118' => 'Pradillo',
	'ES26119' => 'Préjano',
	'ES26120' => 'Quel',
	'ES26121' => 'Rabanera',
	'ES26122' => 'Rasillo de Cameros, El',
	'ES26123' => 'Redal, El',
	'ES26124' => 'Ribafrecha',
	'ES26125' => 'Rincón de Soto',
	'ES26126' => 'Robres del Castillo',
	'ES26127' => 'Rodezno',
	'ES26128' => 'Sajazarra',
	'ES26129' => 'San Asensio',
	'ES26130' => 'San Millán de la Cogolla',
	'ES26131' => 'San Millán de Yécora',
	'ES26132' => 'San Román de Cameros',
	'ES26134' => 'Santa Coloma',
	'ES26135' => 'Santa Engracia del Jubera',
	'ES26136' => 'Santa Eulalia Bajera',
	'ES26139' => 'San Torcuato',
	'ES26140' => 'Santurde de Rioja',
	'ES26141' => 'Santurdejo',
	'ES26142' => 'San Vicente de la Sonsierra',
	'ES26143' => 'Sojuela',
	'ES26144' => 'Sorzano',
	'ES26145' => 'Sotés',
	'ES26146' => 'Soto en Cameros',
	'ES26147' => 'Terroba',
	'ES26148' => 'Tirgo',
	'ES26149' => 'Tobía',
	'ES26150' => 'Tormantos',
	'ES26151' => 'Torrecilla en Cameros',
	'ES26152' => 'Torrecilla sobre Alesanco',
	'ES26153' => 'Torre en Cameros',
	'ES26154' => 'Torremontalbo',
	'ES26155' => 'Treviana',
	'ES26157' => 'Tricio',
	'ES26158' => 'Tudelilla',
	'ES26160' => 'Uruñuela',
	'ES26161' => 'Valdemadera',
	'ES26162' => 'Valgañón',
	'ES26163' => 'Ventosa',
	'ES26164' => 'Ventrosa',
	'ES26165' => 'Viguera',
	'ES26166' => 'Villalba de Rioja',
	'ES26167' => 'Villalobar de Rioja',
	'ES26169' => 'Villanueva de Cameros',
	'ES26170' => 'Villar de Arnedo, El',
	'ES26171' => 'Villar de Torre',
	'ES26172' => 'Villarejo',
	'ES26173' => 'Villarroya',
	'ES26174' => 'Villarta-Quintana',
	'ES26175' => 'Villavelayo',
	'ES26176' => 'Villaverde de Rioja',
	'ES26177' => 'Villoslada de Cameros',
	'ES26178' => 'Viniegra de Abajo',
	'ES26179' => 'Viniegra de Arriba',
	'ES26180' => 'Zarratón',
	'ES26181' => 'Zarzosa',
	'ES26183' => 'Zorraquín',
	'ES27001' => 'Abadín',
	'ES27002' => 'Alfoz',
	'ES27003' => 'Antas de Ulla',
	'ES27004' => 'Baleira',
	'ES27005' => 'Barreiros',
	'ES27006' => 'Becerreá',
	'ES27007' => 'Begonte',
	'ES27008' => 'Bóveda',
	'ES27009' => 'Carballedo',
	'ES27011' => 'Castroverde',
	'ES27012' => 'Cervantes',
	'ES27013' => 'Cervo',
	'ES27014' => 'Corgo, O',
	'ES27015' => 'Cospeito',
	'ES27017' => 'Folgoso do Courel',
	'ES27018' => 'Fonsagrada, A',
	'ES27020' => 'Friol',
	'ES27021' => 'Xermade',
	'ES27023' => 'Guntín',
	'ES27024' => 'Incio, O',
	'ES27025' => 'Xove',
	'ES27026' => 'Láncara',
	'ES27027' => 'Lourenzá',
	'ES27029' => 'Meira',
	'ES27030' => 'Mondoñedo',
	'ES27032' => 'Monterroso',
	'ES27033' => 'Muras',
	'ES27034' => 'Navia de Suarna',
	'ES27035' => 'Negueira de Muñiz',
	'ES27037' => 'Nogais, As',
	'ES27038' => 'Ourol',
	'ES27040' => 'Palas de Rei',
	'ES27041' => 'Pantón',
	'ES27042' => 'Paradela',
	'ES27043' => 'Páramo, O',
	'ES27044' => 'Pastoriza, A',
	'ES27045' => 'Pedrafita do Cebreiro',
	'ES27046' => 'Pol',
	'ES27047' => 'Pobra do Brollón, A',
	'ES27048' => 'Pontenova, A',
	'ES27049' => 'Portomarín',
	'ES27050' => 'Quiroga',
	'ES27052' => 'Ribas de Sil',
	'ES27053' => 'Ribeira de Piquín',
	'ES27054' => 'Riotorto',
	'ES27055' => 'Samos',
	'ES27056' => 'Rábade',
	'ES27058' => 'Saviñao, O',
	'ES27059' => 'Sober',
	'ES27060' => 'Taboada',
	'ES27061' => 'Trabada',
	'ES27062' => 'Triacastela',
	'ES27063' => 'Valadouro, O',
	'ES27064' => 'Vicedo, O',
	'ES27901' => 'Baralla',
	'ES28001' => 'Acebeda, La',
	'ES28002' => 'Ajalvir',
	'ES28003' => 'Alameda del Valle',
	'ES28008' => 'Aldea del Fresno',
	'ES28011' => 'Ambite',
	'ES28012' => 'Anchuelo',
	'ES28016' => 'Atazar, El',
	'ES28017' => 'Batres',
	'ES28019' => 'Belmonte de Tajo',
	'ES28020' => 'Berzosa del Lozoya',
	'ES28021' => 'Berrueco, El',
	'ES28024' => 'Braojos',
	'ES28025' => 'Brea de Tajo',
	'ES28027' => 'Buitrago del Lozoya',
	'ES28028' => 'Bustarviejo',
	'ES28029' => 'Cabanillas de la Sierra',
	'ES28030' => 'Cabrera, La',
	'ES28031' => 'Cadalso de los Vidrios',
	'ES28034' => 'Canencia',
	'ES28035' => 'Carabaña',
	'ES28036' => 'Casarrubuelos',
	'ES28037' => 'Cenicientos',
	'ES28039' => 'Cervera de Buitrago',
	'ES28042' => 'Colmenar del Arroyo',
	'ES28048' => 'Corpa',
	'ES28051' => 'Chapinería',
	'ES28055' => 'Estremera',
	'ES28056' => 'Fresnedillas de la Oliva',
	'ES28057' => 'Fresno de Torote',
	'ES28060' => 'Fuentidueña de Tajo',
	'ES28062' => 'Garganta de los Montes',
	'ES28063' => 'Gargantilla del Lozoya y Pinilla de Buitragooocommerce',
	'ES28064' => 'Gascones',
	'ES28069' => 'Hiruela, La',
	'ES28070' => 'Horcajo de la Sierra-Aoslos',
	'ES28071' => 'Horcajuelo de la Sierra',
	'ES28076' => 'Lozoya',
	'ES28078' => 'Madarcos',
	'ES28087' => 'Molinos, Los',
	'ES28088' => 'Montejo de la Sierra',
	'ES28093' => 'Navacerrada',
	'ES28094' => 'Navalafuente',
	'ES28095' => 'Navalagamella',
	'ES28097' => 'Navarredonda y San Mamés',
	'ES28099' => 'Navas del Rey',
	'ES28101' => 'Olmeda de las Fuentes',
	'ES28102' => 'Orusco de Tajuña',
	'ES28107' => 'Patones',
	'ES28109' => 'Pelayos de la Presa',
	'ES28110' => 'Perales de Tajuña',
	'ES28111' => 'Pezuela de las Torres',
	'ES28112' => 'Pinilla del Valle',
	'ES28114' => 'Piñuécar-Gandullas',
	'ES28116' => 'Pozuelo del Rey',
	'ES28117' => 'Prádena del Rincón',
	'ES28118' => 'Puebla de la Sierra',
	'ES28119' => 'Quijorna',
	'ES28120' => 'Rascafría',
	'ES28121' => 'Redueña',
	'ES28122' => 'Ribatejada',
	'ES28124' => 'Robledillo de la Jara',
	'ES28125' => 'Robledo de Chavela',
	'ES28126' => 'Robregordo',
	'ES28128' => 'Rozas de Puerto Real',
	'ES28135' => 'Santa María de la Alameda',
	'ES28136' => 'Santorcaz',
	'ES28137' => 'Santos de la Humosa, Los',
	'ES28138' => 'Serna del Monte, La',
	'ES28140' => 'Serranillos del Valle',
	'ES28143' => 'Somosierra',
	'ES28145' => 'Talamanca de Jarama',
	'ES28146' => 'Tielmes',
	'ES28147' => 'Titulcia',
	'ES28150' => 'Torrejón de Velasco',
	'ES28151' => 'Torrelaguna',
	'ES28153' => 'Torremocha de Jarama',
	'ES28155' => 'Valdaracete',
	'ES28156' => 'Valdeavero',
	'ES28157' => 'Valdelaguna',
	'ES28158' => 'Valdemanco',
	'ES28159' => 'Valdemaqueda',
	'ES28162' => 'Valdeolmos-Alalpardo',
	'ES28163' => 'Valdepiélagos',
	'ES28164' => 'Valdetorres de Jarama',
	'ES28165' => 'Valdilecha',
	'ES28166' => 'Valverde de Alcalá',
	'ES28168' => 'Vellón, El',
	'ES28169' => 'Venturada',
	'ES28170' => 'Villaconejos',
	'ES28173' => 'Villamanrique de Tajo',
	'ES28174' => 'Villamanta',
	'ES28175' => 'Villamantilla',
	'ES28178' => 'Villanueva de Perales',
	'ES28179' => 'Villar del Olmo',
	'ES28182' => 'Villavieja del Lozoya',
	'ES28183' => 'Zarzalejo',
	'ES28901' => 'Lozoyuela-Navas-Sieteiglesias',
	'ES28902' => 'Puentes Viejas',
	'ES29002' => 'Alcaucín',
	'ES29003' => 'Alfarnate',
	'ES29004' => 'Alfarnatejo',
	'ES29006' => 'Algatocín',
	'ES29009' => 'Almáchar',
	'ES29010' => 'Almargen',
	'ES29011' => 'Almogía',
	'ES29013' => 'Alozaina',
	'ES29014' => 'Alpandeire',
	'ES29016' => 'Árchez',
	'ES29018' => 'Ardales',
	'ES29019' => 'Arenas',
	'ES29020' => 'Arriate',
	'ES29021' => 'Atajate',
	'ES29022' => 'Benadalid',
	'ES29024' => 'Benalauría',
	'ES29026' => 'Benamargosa',
	'ES29027' => 'Benamocarra',
	'ES29028' => 'Benaoján',
	'ES29029' => 'Benarrabá',
	'ES29030' => 'Borge, El',
	'ES29031' => 'Burgo, El',
	'ES29033' => 'Canillas de Aceituno',
	'ES29034' => 'Canillas de Albaida',
	'ES29035' => 'Cañete la Real',
	'ES29036' => 'Carratraca',
	'ES29037' => 'Cartajima',
	'ES29039' => 'Casabermeja',
	'ES29040' => 'Casarabonela',
	'ES29043' => 'Colmenar',
	'ES29044' => 'Comares',
	'ES29045' => 'Cómpeta',
	'ES29046' => 'Cortes de la Frontera',
	'ES29047' => 'Cuevas Bajas',
	'ES29048' => 'Cuevas del Becerro',
	'ES29049' => 'Cuevas de San Marcos',
	'ES29050' => 'Cútar',
	'ES29052' => 'Faraján',
	'ES29053' => 'Frigiliana',
	'ES29055' => 'Fuente de Piedra',
	'ES29056' => 'Gaucín',
	'ES29057' => 'Genalguacil',
	'ES29058' => 'Guaro',
	'ES29059' => 'Humilladero',
	'ES29060' => 'Igualeja',
	'ES29061' => 'Istán',
	'ES29062' => 'Iznate',
	'ES29063' => 'Jimera de Líbar',
	'ES29064' => 'Jubrique',
	'ES29065' => 'Júzcar',
	'ES29066' => 'Macharaviaya',
	'ES29071' => 'Moclinejo',
	'ES29073' => 'Monda',
	'ES29074' => 'Montejaque',
	'ES29076' => 'Ojén',
	'ES29077' => 'Parauta',
	'ES29079' => 'Periana',
	'ES29081' => 'Pujerra',
	'ES29083' => 'Riogordo',
	'ES29085' => 'Salares',
	'ES29086' => 'Sayalonga',
	'ES29087' => 'Sedella',
	'ES29088' => 'Sierra de Yeguas',
	'ES29089' => 'Teba',
	'ES29090' => 'Tolox',
	'ES29092' => 'Totalán',
	'ES29093' => 'Valle de Abdalajís',
	'ES29095' => 'Villanueva de Algaidas',
	'ES29096' => 'Villanueva del Rosario',
	'ES29098' => 'Villanueva de Tapia',
	'ES29099' => 'Viñuela',
	'ES29100' => 'Yunquera',
	'ES29902' => 'Villanueva de la Concepción',
	'ES29903' => 'Montecorto',
	'ES29904' => 'Serrato',
	'ES30004' => 'Albudeite',
	'ES30006' => 'Aledo',
	'ES30014' => 'Campos del Río',
	'ES30031' => 'Ojós',
	'ES30032' => 'Pliego',
	'ES30034' => 'Ricote',
	'ES30040' => 'Ulea',
	'ES30042' => 'Villanueva del Río Segura',
	'ES31001' => 'Abáigar',
	'ES31002' => 'Abartzuza',
	'ES31003' => 'Abaurrea Alta',
	'ES31004' => 'Abaurrea Baja',
	'ES31005' => 'Aberin',
	'ES31006' => 'Ablitas',
	'ES31007' => 'Adiós',
	'ES31008' => 'Aguilar de Codés',
	'ES31009' => 'Oibar',
	'ES31011' => 'Allin',
	'ES31012' => 'Allo',
	'ES31013' => 'Améscoa Baja',
	'ES31014' => 'Antzin',
	'ES31015' => 'Andosilla',
	'ES31017' => 'Anue',
	'ES31018' => 'Añorbe',
	'ES31019' => 'Agoitz',
	'ES31020' => 'Araitz',
	'ES31021' => 'Aranaratxe',
	'ES31022' => 'Arantza',
	'ES31024' => 'Arano',
	'ES31025' => 'Arakil',
	'ES31026' => 'Aras',
	'ES31027' => 'Arbizu',
	'ES31028' => 'Artzi',
	'ES31029' => 'Arcos, Los',
	'ES31030' => 'Arellano',
	'ES31031' => 'Areso',
	'ES31032' => 'Arguedas',
	'ES31033' => 'Aria',
	'ES31034' => 'Aribe',
	'ES31035' => 'Armañanzas',
	'ES31036' => 'Arróniz',
	'ES31037' => 'Arruazu',
	'ES31038' => 'Artajona',
	'ES31039' => 'Artazu',
	'ES31040' => 'Atetz',
	'ES31041' => 'Aiegi',
	'ES31042' => 'Azagra',
	'ES31043' => 'Azuelo',
	'ES31044' => 'Bakaiku',
	'ES31045' => 'Barásoain',
	'ES31046' => 'Barbarin',
	'ES31047' => 'Bargota',
	'ES31048' => 'Barillas',
	'ES31049' => 'Basaburua',
	'ES31051' => 'Beire',
	'ES31052' => 'Belascoáin',
	'ES31053' => 'Berbinzana',
	'ES31054' => 'Bertizarana',
	'ES31055' => 'Betelu',
	'ES31056' => 'Biurrun-Olcoz',
	'ES31057' => 'Buñuel',
	'ES31058' => 'Burguete',
	'ES31059' => 'Burgi',
	'ES31061' => 'Busto, El',
	'ES31062' => 'Cabanillas',
	'ES31063' => 'Cabredo',
	'ES31064' => 'Cadreita',
	'ES31065' => 'Caparroso',
	'ES31066' => 'Cárcar',
	'ES31067' => 'Carcastillo',
	'ES31068' => 'Cascante',
	'ES31069' => 'Cáseda',
	'ES31070' => 'Castejón',
	'ES31071' => 'Castillonuevo',
	'ES31073' => 'Ziordia',
	'ES31074' => 'Zirauki',
	'ES31075' => 'Ziritza',
	'ES31076' => 'Cizur',
	'ES31078' => 'Cortes',
	'ES31079' => 'Desojo',
	'ES31080' => 'Dicastillo',
	'ES31081' => 'Donamaria',
	'ES31082' => 'Etxalar',
	'ES31083' => 'Etxarri',
	'ES31084' => 'Etxarri Aranatz',
	'ES31085' => 'Etxauri',
	'ES31087' => 'Elgorriaga',
	'ES31089' => 'Eneritz',
	'ES31090' => 'Eratsun',
	'ES31091' => 'Ergoiena',
	'ES31092' => 'Erro',
	'ES31093' => 'Ezkaroze',
	'ES31094' => 'Eslava',
	'ES31095' => 'Espartza Zaraitzu',
	'ES31096' => 'Espronceda',
	'ES31098' => 'Esteribar',
	'ES31099' => 'Etayo',
	'ES31100' => 'Eulate',
	'ES31101' => 'Ezcabarte',
	'ES31102' => 'Ezkurra',
	'ES31103' => 'Ezprogui',
	'ES31104' => 'Falces',
	'ES31105' => 'Fitero',
	'ES31106' => 'Fontellas',
	'ES31107' => 'Funes',
	'ES31108' => 'Fustiñana',
	'ES31109' => 'Galar',
	'ES31110' => 'Galipentzu',
	'ES31111' => 'Galoze',
	'ES31112' => 'Garaioa',
	'ES31113' => 'Garde',
	'ES31114' => 'Garínoain',
	'ES31115' => 'Garralda',
	'ES31116' => 'Genevilla',
	'ES31117' => 'Goizueta',
	'ES31118' => 'Goñi',
	'ES31119' => 'Gorza',
	'ES31120' => 'Gesalatz',
	'ES31121' => 'Guirguillano',
	'ES31123' => 'Uharte Arakil',
	'ES31124' => 'Ibargoiti',
	'ES31125' => 'Igúzquiza',
	'ES31126' => 'Imotz',
	'ES31127' => 'Irañeta',
	'ES31128' => 'Izaba',
	'ES31129' => 'Ituren',
	'ES31130' => 'Iturmendi',
	'ES31131' => 'Itza',
	'ES31132' => 'Izagaondoa',
	'ES31133' => 'Itzaltzu',
	'ES31134' => 'Jaurrieta',
	'ES31135' => 'Javier',
	'ES31136' => 'Juslapeña',
	'ES31137' => 'Beintza-Labaien',
	'ES31138' => 'Lakuntza',
	'ES31139' => 'Lana',
	'ES31140' => 'Lantz',
	'ES31141' => 'Lapoblación',
	'ES31142' => 'Larraga',
	'ES31143' => 'Larraona',
	'ES31144' => 'Larraun',
	'ES31145' => 'Lazagurría',
	'ES31146' => 'Leatxe',
	'ES31147' => 'Legarda',
	'ES31148' => 'Legaria',
	'ES31149' => 'Leitza',
	'ES31150' => 'Leotz',
	'ES31151' => 'Lerga',
	'ES31152' => 'Lerín',
	'ES31153' => 'Lesaka',
	'ES31154' => 'Lezaun',
	'ES31155' => 'Liédena',
	'ES31156' => 'Lizoáin-Arriasgoiti',
	'ES31157' => 'Lodosa',
	'ES31158' => 'Longida',
	'ES31159' => 'Lumbier',
	'ES31160' => 'Luquin',
	'ES31161' => 'Mañeru',
	'ES31162' => 'Marañón',
	'ES31163' => 'Marcilla',
	'ES31164' => 'Mélida',
	'ES31165' => 'Mendavia',
	'ES31166' => 'Mendaza',
	'ES31167' => 'Mendigorría',
	'ES31168' => 'Metauten',
	'ES31169' => 'Milagro',
	'ES31170' => 'Mirafuentes',
	'ES31171' => 'Miranda de Arga',
	'ES31172' => 'Elo',
	'ES31173' => 'Monteagudo',
	'ES31174' => 'Morentin',
	'ES31175' => 'Mues',
	'ES31176' => 'Murchante',
	'ES31177' => 'Murieta',
	'ES31178' => 'Murillo el Cuende',
	'ES31179' => 'Murillo el Fruto',
	'ES31180' => 'Muruzábal',
	'ES31181' => 'Nabaskoze',
	'ES31182' => 'Nazar',
	'ES31183' => 'Obanos',
	'ES31184' => 'Oco',
	'ES31185' => 'Otsagabia',
	'ES31186' => 'Odieta',
	'ES31187' => 'Oiz',
	'ES31188' => 'Olaibar',
	'ES31189' => 'Olazagutía',
	'ES31190' => 'Olejua',
	'ES31191' => 'Erriberri',
	'ES31192' => 'Oloritz',
	'ES31193' => 'Oltza Zendea',
	'ES31194' => 'Ollaran',
	'ES31195' => 'Orbaizeta',
	'ES31196' => 'Orbara',
	'ES31197' => 'Orísoain',
	'ES31198' => 'Orontze',
	'ES31199' => 'Orotz-Betelu',
	'ES31200' => 'Oteiza',
	'ES31203' => 'Petilla de Aragón',
	'ES31204' => 'Piedramillera',
	'ES31205' => 'Pitillas',
	'ES31206' => 'Gares',
	'ES31207' => 'Pueyo',
	'ES31208' => 'Ribaforada',
	'ES31209' => 'Romanzado',
	'ES31210' => 'Erronkari',
	'ES31211' => 'Roncesvalles',
	'ES31212' => 'Sada',
	'ES31213' => 'Saldías',
	'ES31214' => 'Jaitz',
	'ES31216' => 'Zangoza',
	'ES31217' => 'San Martín de Unx',
	'ES31219' => 'Sansol',
	'ES31220' => 'Santacara',
	'ES31221' => 'Santesteban',
	'ES31222' => 'Sartze',
	'ES31223' => 'Sartaguda',
	'ES31224' => 'Sesma',
	'ES31225' => 'Sorlada',
	'ES31226' => 'Sunbilla',
	'ES31228' => 'Tiebas-Muruarte de Reta',
	'ES31229' => 'Tirapu',
	'ES31230' => 'Torralba del Río',
	'ES31231' => 'Torres del Río',
	'ES31233' => 'Tulebras',
	'ES31234' => 'Ucar',
	'ES31235' => 'Uxue',
	'ES31236' => 'Ultzama',
	'ES31237' => 'Unciti',
	'ES31238' => 'Untzue',
	'ES31239' => 'Urdax',
	'ES31240' => 'Urdiain',
	'ES31241' => 'Urraul Alto',
	'ES31242' => 'Urraul Bajo',
	'ES31243' => 'Urroz-Villa',
	'ES31244' => 'Urroz',
	'ES31245' => 'Urzainki',
	'ES31246' => 'Uterga',
	'ES31247' => 'Uztarroze',
	'ES31248' => 'Valcarlos',
	'ES31249' => 'Valtierra',
	'ES31250' => 'Bera',
	'ES31251' => 'Viana',
	'ES31252' => 'Bidankoze',
	'ES31253' => 'Bidaurreta',
	'ES31254' => 'Villafranca',
	'ES31255' => 'Villamayor de Monjardín',
	'ES31256' => 'Villanueva de Aezkoa',
	'ES31257' => 'Villatuerta',
	'ES31259' => 'Igantzi',
	'ES31260' => 'Deierri',
	'ES31261' => 'Yesa',
	'ES31262' => 'Zabaltza',
	'ES31263' => 'Zubieta',
	'ES31264' => 'Zugarramurdi',
	'ES31265' => 'Zúñiga',
	'ES31904' => 'Irurtzun',
	'ES31905' => 'Beriáin',
	'ES31906' => 'Orkoien',
	'ES31908' => 'Lekunberri',
	'ES32002' => 'Amoeiro',
	'ES32003' => 'Arnoia, A',
	'ES32004' => 'Avión',
	'ES32005' => 'Baltar',
	'ES32006' => 'Bande',
	'ES32007' => 'Baños de Molgas',
	'ES32010' => 'Beade',
	'ES32011' => 'Beariz',
	'ES32012' => 'Blancos, Os',
	'ES32013' => 'Boborás',
	'ES32014' => 'Bola, A',
	'ES32015' => 'Bolo, O',
	'ES32016' => 'Calvos de Randín',
	'ES32017' => 'Carballeda de Valdeorras',
	'ES32018' => 'Carballeda de Avia',
	'ES32020' => 'Cartelle',
	'ES32021' => 'Castrelo do Val',
	'ES32022' => 'Castrelo de Miño',
	'ES32023' => 'Castro Caldelas',
	'ES32025' => 'Cenlle',
	'ES32026' => 'Coles',
	'ES32027' => 'Cortegada',
	'ES32028' => 'Cualedro',
	'ES32029' => 'Chandrexa de Queixa',
	'ES32030' => 'Entrimo',
	'ES32031' => 'Esgos',
	'ES32033' => 'Gomesende',
	'ES32034' => 'Gudiña, A',
	'ES32035' => 'Irixo, O',
	'ES32036' => 'Xunqueira de Ambía',
	'ES32037' => 'Xunqueira de Espadanedo',
	'ES32038' => 'Larouco',
	'ES32039' => 'Laza',
	'ES32040' => 'Leiro',
	'ES32041' => 'Lobeira',
	'ES32042' => 'Lobios',
	'ES32043' => 'Maceda',
	'ES32044' => 'Manzaneda',
	'ES32045' => 'Maside',
	'ES32046' => 'Melón',
	'ES32047' => 'Merca, A',
	'ES32048' => 'Mezquita, A',
	'ES32049' => 'Montederramo',
	'ES32050' => 'Monterrei',
	'ES32051' => 'Muíños',
	'ES32052' => 'Nogueira de Ramuín',
	'ES32053' => 'Oímbra',
	'ES32055' => 'Paderne de Allariz',
	'ES32056' => 'Padrenda',
	'ES32057' => 'Parada de Sil',
	'ES32059' => 'Peroxa, A',
	'ES32060' => 'Petín',
	'ES32061' => 'Piñor',
	'ES32062' => 'Porqueira',
	'ES32063' => 'Pobra de Trives, A',
	'ES32064' => 'Pontedeva',
	'ES32065' => 'Punxín',
	'ES32066' => 'Quintela de Leirado',
	'ES32067' => 'Rairiz de Veiga',
	'ES32068' => 'Ramirás',
	'ES32070' => 'San Xoán de Río',
	'ES32071' => 'Riós',
	'ES32072' => 'Rúa, A',
	'ES32073' => 'Rubiá',
	'ES32074' => 'San Amaro',
	'ES32076' => 'San Cristovo de Cea',
	'ES32077' => 'Sandiás',
	'ES32078' => 'Sarreaus',
	'ES32079' => 'Taboadela',
	'ES32080' => 'Teixeira, A',
	'ES32081' => 'Toén',
	'ES32082' => 'Trasmiras',
	'ES32083' => 'Veiga, A',
	'ES32084' => 'Verea',
	'ES32086' => 'Viana do Bolo',
	'ES32087' => 'Vilamarín',
	'ES32088' => 'Vilamartín de Valdeorras',
	'ES32089' => 'Vilar de Barrio',
	'ES32090' => 'Vilar de Santos',
	'ES32091' => 'Vilardevós',
	'ES32092' => 'Vilariño de Conso',
	'ES33001' => 'Allande',
	'ES33003' => 'Amieva',
	'ES33005' => 'Belmonte de Miranda',
	'ES33006' => 'Bimenes',
	'ES33007' => 'Boal',
	'ES33008' => 'Cabrales',
	'ES33009' => 'Cabranes',
	'ES33010' => 'Candamo',
	'ES33013' => 'Caravia',
	'ES33015' => 'Caso',
	'ES33017' => 'Castropol',
	'ES33018' => 'Coaña',
	'ES33019' => 'Colunga',
	'ES33021' => 'Cudillero',
	'ES33022' => 'Degaña',
	'ES33023' => 'Franco, El',
	'ES33027' => 'Grandas de Salime',
	'ES33028' => 'Ibias',
	'ES33029' => 'Illano',
	'ES33030' => 'Illas',
	'ES33038' => 'Morcín',
	'ES33039' => 'Muros de Nalón',
	'ES33043' => 'Onís',
	'ES33046' => 'Peñamellera Alta',
	'ES33047' => 'Peñamellera Baja',
	'ES33048' => 'Pesoz',
	'ES33050' => 'Ponga',
	'ES33052' => 'Proaza',
	'ES33053' => 'Quirós',
	'ES33054' => 'Regueras, Las',
	'ES33055' => 'Ribadedeva',
	'ES33057' => 'Ribera de Arriba',
	'ES33058' => 'Riosa',
	'ES33059' => 'Salas',
	'ES33061' => 'San Martín de Oscos',
	'ES33062' => 'Santa Eulalia de Oscos',
	'ES33063' => 'San Tirso de Abres',
	'ES33064' => 'Santo Adriano',
	'ES33065' => 'Sariego',
	'ES33067' => 'Sobrescobio',
	'ES33068' => 'Somiedo',
	'ES33069' => 'Soto del Barco',
	'ES33070' => 'Tapia de Casariego',
	'ES33071' => 'Taramundi',
	'ES33072' => 'Teverga',
	'ES33074' => 'Vegadeo',
	'ES33075' => 'Villanueva de Oscos',
	'ES33077' => 'Villayón',
	'ES33078' => 'Yernes y Tameza',
	'ES34001' => 'Abarca de Campos',
	'ES34003' => 'Abia de las Torres',
	'ES34005' => 'Alar del Rey',
	'ES34006' => 'Alba de Cerrato',
	'ES34009' => 'Amayuelas de Arriba',
	'ES34010' => 'Ampudia',
	'ES34011' => 'Amusco',
	'ES34012' => 'Antigüedad',
	'ES34015' => 'Arconada',
	'ES34017' => 'Astudillo',
	'ES34018' => 'Autilla del Pino',
	'ES34019' => 'Autillo de Campos',
	'ES34020' => 'Ayuela',
	'ES34022' => 'Baltanás',
	'ES34024' => 'Baquerín de Campos',
	'ES34025' => 'Bárcena de Campos',
	'ES34027' => 'Barruelo de Santullán',
	'ES34028' => 'Báscones de Ojeda',
	'ES34029' => 'Becerril de Campos',
	'ES34031' => 'Belmonte de Campos',
	'ES34032' => 'Berzosilla',
	'ES34033' => 'Boada de Campos',
	'ES34034' => 'Boadilla del Camino',
	'ES34035' => 'Boadilla de Rioseco',
	'ES34036' => 'Brañosera',
	'ES34037' => 'Buenavista de Valdavia',
	'ES34038' => 'Bustillo de la Vega',
	'ES34039' => 'Bustillo del Páramo de Carrión',
	'ES34041' => 'Calahorra de Boedo',
	'ES34042' => 'Calzada de los Molinos',
	'ES34045' => 'Capillas',
	'ES34046' => 'Cardeñosa de Volpejera',
	'ES34047' => 'Carrión de los Condes',
	'ES34048' => 'Castil de Vela',
	'ES34049' => 'Castrejón de la Peña',
	'ES34050' => 'Castrillo de Don Juan',
	'ES34051' => 'Castrillo de Onielo',
	'ES34052' => 'Castrillo de Villavega',
	'ES34053' => 'Castromocho',
	'ES34055' => 'Cervatos de la Cueza',
	'ES34056' => 'Cervera de Pisuerga',
	'ES34057' => 'Cevico de la Torre',
	'ES34058' => 'Cevico Navero',
	'ES34059' => 'Cisneros',
	'ES34060' => 'Cobos de Cerrato',
	'ES34061' => 'Collazos de Boedo',
	'ES34062' => 'Congosto de Valdavia',
	'ES34063' => 'Cordovilla la Real',
	'ES34066' => 'Cubillas de Cerrato',
	'ES34067' => 'Dehesa de Montejo',
	'ES34068' => 'Dehesa de Romanos',
	'ES34069' => 'Dueñas',
	'ES34070' => 'Espinosa de Cerrato',
	'ES34071' => 'Espinosa de Villagonzalo',
	'ES34072' => 'Frechilla',
	'ES34073' => 'Fresno del Río',
	'ES34074' => 'Frómista',
	'ES34076' => 'Fuentes de Nava',
	'ES34077' => 'Fuentes de Valdepero',
	'ES34079' => 'Grijota',
	'ES34081' => 'Guaza de Campos',
	'ES34082' => 'Hérmedes de Cerrato',
	'ES34083' => 'Herrera de Pisuerga',
	'ES34084' => 'Herrera de Valdecañas',
	'ES34086' => 'Hontoria de Cerrato',
	'ES34087' => 'Hornillos de Cerrato',
	'ES34088' => 'Husillos',
	'ES34089' => 'Itero de la Vega',
	'ES34091' => 'Lagartos',
	'ES34092' => 'Lantadilla',
	'ES34093' => 'Vid de Ojeda, La',
	'ES34094' => 'Ledigos',
	'ES34096' => 'Lomas',
	'ES34098' => 'Magaz de Pisuerga',
	'ES34099' => 'Manquillos',
	'ES34100' => 'Mantinos',
	'ES34101' => 'Marcilla de Campos',
	'ES34102' => 'Mazariegos',
	'ES34103' => 'Mazuecos de Valdeginate',
	'ES34104' => 'Melgar de Yuso',
	'ES34106' => 'Meneses de Campos',
	'ES34107' => 'Micieces de Ojeda',
	'ES34108' => 'Monzón de Campos',
	'ES34109' => 'Moratinos',
	'ES34110' => 'Mudá',
	'ES34112' => 'Nogal de las Huertas',
	'ES34113' => 'Olea de Boedo',
	'ES34114' => 'Olmos de Ojeda',
	'ES34116' => 'Osornillo',
	'ES34121' => 'Palenzuela',
	'ES34122' => 'Páramo de Boedo',
	'ES34123' => 'Paredes de Nava',
	'ES34124' => 'Payo de Ojeda',
	'ES34125' => 'Pedraza de Campos',
	'ES34126' => 'Pedrosa de la Vega',
	'ES34127' => 'Perales',
	'ES34129' => 'Pino del Río',
	'ES34130' => 'Piña de Campos',
	'ES34131' => 'Población de Arroyo',
	'ES34132' => 'Población de Campos',
	'ES34133' => 'Población de Cerrato',
	'ES34134' => 'Polentinos',
	'ES34135' => 'Pomar de Valdivia',
	'ES34136' => 'Poza de la Vega',
	'ES34137' => 'Pozo de Urama',
	'ES34139' => 'Prádanos de Ojeda',
	'ES34140' => 'Puebla de Valdavia, La',
	'ES34141' => 'Quintana del Puente',
	'ES34143' => 'Quintanilla de Onsoña',
	'ES34146' => 'Reinoso de Cerrato',
	'ES34147' => 'Renedo de la Vega',
	'ES34149' => 'Requena de Campos',
	'ES34151' => 'Respenda de la Peña',
	'ES34152' => 'Revenga de Campos',
	'ES34154' => 'Revilla de Collazos',
	'ES34155' => 'Ribas de Campos',
	'ES34156' => 'Riberos de la Cueza',
	'ES34157' => 'Saldaña',
	'ES34158' => 'Salinas de Pisuerga',
	'ES34159' => 'San Cebrián de Campos',
	'ES34160' => 'San Cebrián de Mudá',
	'ES34161' => 'San Cristóbal de Boedo',
	'ES34163' => 'San Mamés de Campos',
	'ES34165' => 'San Román de la Cuba',
	'ES34167' => 'Santa Cecilia del Alcor',
	'ES34168' => 'Santa Cruz de Boedo',
	'ES34169' => 'Santervás de la Vega',
	'ES34170' => 'Santibáñez de Ecla',
	'ES34171' => 'Santibáñez de la Peña',
	'ES34174' => 'Santoyo',
	'ES34175' => 'Serna, La',
	'ES34176' => 'Sotobañado y Priorato',
	'ES34177' => 'Soto de Cerrato',
	'ES34178' => 'Tabanera de Cerrato',
	'ES34179' => 'Tabanera de Valdavia',
	'ES34180' => 'Támara de Campos',
	'ES34181' => 'Tariego de Cerrato',
	'ES34182' => 'Torquemada',
	'ES34184' => 'Torremormojón',
	'ES34185' => 'Triollo',
	'ES34186' => 'Valbuena de Pisuerga',
	'ES34189' => 'Valdeolmillos',
	'ES34190' => 'Valderrábano',
	'ES34192' => 'Valde-Ucieza',
	'ES34196' => 'Valle de Cerrato',
	'ES34199' => 'Velilla del Río Carrión',
	'ES34201' => 'Vertavillo',
	'ES34202' => 'Villabasta de Valdavia',
	'ES34204' => 'Villacidaler',
	'ES34205' => 'Villaconancio',
	'ES34206' => 'Villada',
	'ES34208' => 'Villaeles de Valdavia',
	'ES34210' => 'Villahán',
	'ES34211' => 'Villaherreros',
	'ES34213' => 'Villalaco',
	'ES34214' => 'Villalba de Guardo',
	'ES34215' => 'Villalcázar de Sirga',
	'ES34216' => 'Villalcón',
	'ES34217' => 'Villalobón',
	'ES34218' => 'Villaluenga de la Vega',
	'ES34220' => 'Villamartín de Campos',
	'ES34221' => 'Villamediana',
	'ES34222' => 'Villameriel',
	'ES34223' => 'Villamoronta',
	'ES34224' => 'Villamuera de la Cueza',
	'ES34227' => 'Villanueva del Rebollar',
	'ES34228' => 'Villanuño de Valdavia',
	'ES34229' => 'Villaprovedo',
	'ES34230' => 'Villarmentero de Campos',
	'ES34231' => 'Villarrabé',
	'ES34232' => 'Villarramiel',
	'ES34233' => 'Villasarracino',
	'ES34234' => 'Villasila de Valdavia',
	'ES34236' => 'Villaturde',
	'ES34237' => 'Villaumbrales',
	'ES34238' => 'Villaviudas',
	'ES34240' => 'Villerías de Campos',
	'ES34241' => 'Villodre',
	'ES34242' => 'Villodrigo',
	'ES34243' => 'Villoldo',
	'ES34245' => 'Villota del Páramo',
	'ES34246' => 'Villovieco',
	'ES34901' => 'Osorno la Mayor',
	'ES34902' => 'Valle del Retortillo',
	'ES34903' => 'Loma de Ucieza',
	'ES34904' => 'Pernía, La',
	'ES35005' => 'Artenara',
	'ES35007' => 'Betancuria',
	'ES35025' => 'Tejeda',
	'ES35032' => 'Valleseco',
	'ES36001' => 'Arbo',
	'ES36002' => 'Barro',
	'ES36007' => 'Campo Lameiro',
	'ES36010' => 'Catoira',
	'ES36013' => 'Covelo',
	'ES36014' => 'Crecente',
	'ES36015' => 'Cuntis',
	'ES36016' => 'Dozón',
	'ES36018' => 'Forcarei',
	'ES36019' => 'Fornelos de Montes',
	'ES36020' => 'Agolada',
	'ES36025' => 'Lama, A',
	'ES36028' => 'Meis',
	'ES36030' => 'Mondariz',
	'ES36031' => 'Mondariz-Balneario',
	'ES36032' => 'Moraña',
	'ES36034' => 'Neves, As',
	'ES36036' => 'Oia',
	'ES36037' => 'Pazos de Borbén',
	'ES36040' => 'Portas',
	'ES36044' => 'Pontecesures',
	'ES36047' => 'Rodeiro',
	'ES36901' => 'Illa de Arousa, A',
	'ES37001' => 'Abusejo',
	'ES37002' => 'Agallas',
	'ES37003' => 'Ahigal de los Aceiteros',
	'ES37004' => 'Ahigal de Villarino',
	'ES37005' => 'Alameda de Gardón, La',
	'ES37006' => 'Alamedilla, La',
	'ES37007' => 'Alaraz',
	'ES37009' => 'Alba de Yeltes',
	'ES37010' => 'Alberca, La',
	'ES37011' => 'Alberguería de Argañán, La',
	'ES37012' => 'Alconada',
	'ES37013' => 'Aldeacipreste',
	'ES37014' => 'Aldeadávila de la Ribera',
	'ES37015' => 'Aldea del Obispo',
	'ES37016' => 'Aldealengua',
	'ES37017' => 'Aldeanueva de Figueroa',
	'ES37018' => 'Aldeanueva de la Sierra',
	'ES37019' => 'Aldearrodrigo',
	'ES37020' => 'Aldearrubia',
	'ES37021' => 'Aldeaseca de Alba',
	'ES37022' => 'Aldeaseca de la Frontera',
	'ES37023' => 'Aldeatejada',
	'ES37024' => 'Aldeavieja de Tormes',
	'ES37025' => 'Aldehuela de la Bóveda',
	'ES37026' => 'Aldehuela de Yeltes',
	'ES37027' => 'Almenara de Tormes',
	'ES37028' => 'Almendra',
	'ES37029' => 'Anaya de Alba',
	'ES37030' => 'Añover de Tormes',
	'ES37031' => 'Arabayona de Mógica',
	'ES37032' => 'Arapiles',
	'ES37033' => 'Arcediano',
	'ES37034' => 'Arco, El',
	'ES37035' => 'Armenteros',
	'ES37036' => 'San Miguel del Robledo',
	'ES37037' => 'Atalaya, La',
	'ES37038' => 'Babilafuente',
	'ES37039' => 'Bañobárez',
	'ES37040' => 'Barbadillo',
	'ES37041' => 'Barbalos',
	'ES37042' => 'Barceo',
	'ES37044' => 'Barruecopardo',
	'ES37045' => 'Bastida, La',
	'ES37047' => 'Beleña',
	'ES37049' => 'Bermellar',
	'ES37050' => 'Berrocal de Huebra',
	'ES37051' => 'Berrocal de Salvatierra',
	'ES37052' => 'Boada',
	'ES37054' => 'Bodón, El',
	'ES37055' => 'Bogajo',
	'ES37056' => 'Bouza, La',
	'ES37057' => 'Bóveda del Río Almar',
	'ES37058' => 'Brincones',
	'ES37059' => 'Buenamadre',
	'ES37060' => 'Buenavista',
	'ES37061' => 'Cabaco, El',
	'ES37062' => 'Cabezabellosa de la Calzada',
	'ES37063' => 'Cabeza de Béjar, La',
	'ES37065' => 'Cabeza del Caballo',
	'ES37067' => 'Cabrerizos',
	'ES37068' => 'Cabrillas',
	'ES37069' => 'Calvarrasa de Abajo',
	'ES37070' => 'Calvarrasa de Arriba',
	'ES37071' => 'Calzada de Béjar, La',
	'ES37072' => 'Calzada de Don Diego',
	'ES37073' => 'Calzada de Valdunciel',
	'ES37074' => 'Campillo de Azaba',
	'ES37077' => 'Campo de Peñaranda, El',
	'ES37078' => 'Candelario',
	'ES37079' => 'Canillas de Abajo',
	'ES37080' => 'Cantagallo',
	'ES37081' => 'Cantalapiedra',
	'ES37082' => 'Cantalpino',
	'ES37083' => 'Cantaracillo',
	'ES37086' => 'Carpio de Azaba',
	'ES37087' => 'Carrascal de Barregas',
	'ES37088' => 'Carrascal del Obispo',
	'ES37089' => 'Casafranca',
	'ES37090' => 'Casas del Conde, Las',
	'ES37091' => 'Casillas de Flores',
	'ES37092' => 'Castellanos de Moriscos',
	'ES37096' => 'Castillejo de Martín Viejo',
	'ES37097' => 'Castraz',
	'ES37098' => 'Cepeda',
	'ES37099' => 'Cereceda de la Sierra',
	'ES37100' => 'Cerezal de Peñahorcada',
	'ES37101' => 'Cerralbo',
	'ES37102' => 'Cerro, El',
	'ES37103' => 'Cespedosa de Tormes',
	'ES37104' => 'Cilleros de la Bastida',
	'ES37106' => 'Cipérez',
	'ES37108' => 'Coca de Alba',
	'ES37109' => 'Colmenar de Montemayor',
	'ES37110' => 'Cordovilla',
	'ES37112' => 'Cristóbal',
	'ES37113' => 'Cubo de Don Sancho, El',
	'ES37114' => 'Chagarcía Medianero',
	'ES37115' => 'Dios le Guarde',
	'ES37116' => 'Doñinos de Ledesma',
	'ES37117' => 'Doñinos de Salamanca',
	'ES37118' => 'Éjeme',
	'ES37119' => 'Encina, La',
	'ES37120' => 'Encina de San Silvestre',
	'ES37121' => 'Encinas de Abajo',
	'ES37122' => 'Encinas de Arriba',
	'ES37123' => 'Encinasola de los Comendadores',
	'ES37124' => 'Endrinal',
	'ES37125' => 'Escurial de la Sierra',
	'ES37126' => 'Espadaña',
	'ES37127' => 'Espeja',
	'ES37128' => 'Espino de la Orbada',
	'ES37129' => 'Florida de Liébana',
	'ES37130' => 'Forfoleda',
	'ES37131' => 'Frades de la Sierra',
	'ES37132' => 'Fregeneda, La',
	'ES37133' => 'Fresnedoso',
	'ES37134' => 'Fresno Alhándiga',
	'ES37135' => 'Fuente de San Esteban, La',
	'ES37136' => 'Fuenteguinaldo',
	'ES37137' => 'Fuenteliante',
	'ES37138' => 'Fuenterroble de Salvatierra',
	'ES37139' => 'Fuentes de Béjar',
	'ES37140' => 'Fuentes de Oñoro',
	'ES37141' => 'Gajates',
	'ES37142' => 'Galindo y Perahuy',
	'ES37143' => 'Galinduste',
	'ES37144' => 'Galisancho',
	'ES37145' => 'Gallegos de Argañán',
	'ES37146' => 'Gallegos de Solmirón',
	'ES37147' => 'Garcibuey',
	'ES37148' => 'Garcihernández',
	'ES37149' => 'Garcirrey',
	'ES37150' => 'Gejuelo del Barro',
	'ES37151' => 'Golpejas',
	'ES37152' => 'Gomecello',
	'ES37154' => 'Guadramiro',
	'ES37155' => 'Guijo de Ávila',
	'ES37157' => 'Herguijuela de Ciudad Rodrigo',
	'ES37158' => 'Herguijuela de la Sierra',
	'ES37159' => 'Herguijuela del Campo',
	'ES37160' => 'Hinojosa de Duero',
	'ES37161' => 'Horcajo de Montemayor',
	'ES37162' => 'Horcajo Medianero',
	'ES37163' => 'Hoya, La',
	'ES37164' => 'Huerta',
	'ES37165' => 'Iruelos',
	'ES37166' => 'Ituero de Azaba',
	'ES37167' => 'Juzbado',
	'ES37168' => 'Lagunilla',
	'ES37169' => 'Larrodrigo',
	'ES37170' => 'Ledesma',
	'ES37171' => 'Ledrada',
	'ES37172' => 'Linares de Riofrío',
	'ES37173' => 'Lumbrales',
	'ES37174' => 'Macotera',
	'ES37175' => 'Machacón',
	'ES37176' => 'Madroñal',
	'ES37177' => 'Maíllo, El',
	'ES37178' => 'Malpartida',
	'ES37179' => 'Mancera de Abajo',
	'ES37180' => 'Manzano, El',
	'ES37181' => 'Martiago',
	'ES37182' => 'Martinamor',
	'ES37183' => 'Martín de Yeltes',
	'ES37184' => 'Masueco',
	'ES37185' => 'Castellanos de Villiquera',
	'ES37186' => 'Mata de Ledesma, La',
	'ES37187' => 'Matilla de los Caños del Río',
	'ES37188' => 'Maya, La',
	'ES37189' => 'Membribe de la Sierra',
	'ES37190' => 'Mieza',
	'ES37191' => 'Milano, El',
	'ES37192' => 'Miranda de Azán',
	'ES37193' => 'Miranda del Castañar',
	'ES37194' => 'Mogarraz',
	'ES37195' => 'Molinillo',
	'ES37196' => 'Monforte de la Sierra',
	'ES37197' => 'Monleón',
	'ES37198' => 'Monleras',
	'ES37199' => 'Monsagro',
	'ES37200' => 'Montejo',
	'ES37201' => 'Montemayor del Río',
	'ES37202' => 'Monterrubio de Armuña',
	'ES37203' => 'Monterrubio de la Sierra',
	'ES37204' => 'Morasverdes',
	'ES37205' => 'Morille',
	'ES37206' => 'Moríñigo',
	'ES37207' => 'Moriscos',
	'ES37208' => 'Moronta',
	'ES37209' => 'Mozárbez',
	'ES37211' => 'Narros de Matalayegua',
	'ES37212' => 'Navacarros',
	'ES37213' => 'Nava de Béjar',
	'ES37214' => 'Nava de Francia',
	'ES37215' => 'Nava de Sotrobal',
	'ES37216' => 'Navales',
	'ES37217' => 'Navalmoral de Béjar',
	'ES37218' => 'Navamorales',
	'ES37219' => 'Navarredonda de la Rinconada',
	'ES37221' => 'Navasfrías',
	'ES37222' => 'Negrilla de Palencia',
	'ES37223' => 'Olmedo de Camaces',
	'ES37224' => 'Orbada, La',
	'ES37225' => 'Pajares de la Laguna',
	'ES37226' => 'Palacios del Arzobispo',
	'ES37228' => 'Palaciosrubios',
	'ES37229' => 'Palencia de Negrilla',
	'ES37230' => 'Parada de Arriba',
	'ES37231' => 'Parada de Rubiales',
	'ES37232' => 'Paradinas de San Juan',
	'ES37233' => 'Pastores',
	'ES37234' => 'Payo, El',
	'ES37235' => 'Pedraza de Alba',
	'ES37236' => 'Pedrosillo de Alba',
	'ES37237' => 'Pedrosillo de los Aires',
	'ES37238' => 'Pedrosillo el Ralo',
	'ES37239' => 'Pedroso de la Armuña, El',
	'ES37240' => 'Pelabravo',
	'ES37241' => 'Pelarrodríguez',
	'ES37242' => 'Pelayos',
	'ES37243' => 'Peña, La',
	'ES37244' => 'Peñacaballera',
	'ES37245' => 'Peñaparda',
	'ES37247' => 'Peñarandilla',
	'ES37248' => 'Peralejos de Abajo',
	'ES37249' => 'Peralejos de Arriba',
	'ES37250' => 'Pereña de la Ribera',
	'ES37251' => 'Peromingo',
	'ES37252' => 'Pinedas',
	'ES37253' => 'Pino de Tormes, El',
	'ES37254' => 'Pitiegua',
	'ES37255' => 'Pizarral',
	'ES37256' => 'Poveda de las Cintas',
	'ES37257' => 'Pozos de Hinojo',
	'ES37258' => 'Puebla de Azaba',
	'ES37259' => 'Puebla de San Medel',
	'ES37260' => 'Puebla de Yeltes',
	'ES37261' => 'Puente del Congosto',
	'ES37262' => 'Puertas',
	'ES37263' => 'Puerto de Béjar',
	'ES37264' => 'Puerto Seguro',
	'ES37265' => 'Rágama',
	'ES37266' => 'Redonda, La',
	'ES37267' => 'Retortillo',
	'ES37268' => 'Rinconada de la Sierra, La',
	'ES37269' => 'Robleda',
	'ES37270' => 'Robliza de Cojos',
	'ES37271' => 'Rollán',
	'ES37272' => 'Saelices el Chico',
	'ES37273' => 'Sagrada, La',
	'ES37275' => 'Saldeana',
	'ES37276' => 'Salmoral',
	'ES37277' => 'Salvatierra de Tormes',
	'ES37278' => 'San Cristóbal de la Cuesta',
	'ES37279' => 'Sancti-Spíritus',
	'ES37280' => 'Sanchón de la Ribera',
	'ES37281' => 'Sanchón de la Sagrada',
	'ES37282' => 'Sanchotello',
	'ES37283' => 'Sando',
	'ES37284' => 'San Esteban de la Sierra',
	'ES37285' => 'San Felices de los Gallegos',
	'ES37286' => 'San Martín del Castañar',
	'ES37287' => 'San Miguel de Valero',
	'ES37288' => 'San Morales',
	'ES37289' => 'San Muñoz',
	'ES37290' => 'San Pedro del Valle',
	'ES37291' => 'San Pedro de Rozados',
	'ES37292' => 'San Pelayo de Guareña',
	'ES37293' => 'Santa María de Sando',
	'ES37296' => 'Santiago de la Puebla',
	'ES37297' => 'Santibáñez de Béjar',
	'ES37298' => 'Santibáñez de la Sierra',
	'ES37299' => 'Santiz',
	'ES37300' => 'Santos, Los',
	'ES37301' => 'Sardón de los Frailes',
	'ES37302' => 'Saucelle',
	'ES37303' => 'Sahugo, El',
	'ES37304' => 'Sepulcro-Hilario',
	'ES37305' => 'Sequeros',
	'ES37306' => 'Serradilla del Arroyo',
	'ES37307' => 'Serradilla del Llano',
	'ES37309' => 'Sierpe, La',
	'ES37310' => 'Sieteiglesias de Tormes',
	'ES37311' => 'Sobradillo',
	'ES37312' => 'Sorihuela',
	'ES37313' => 'Sotoserrano',
	'ES37314' => 'Tabera de Abajo',
	'ES37315' => 'Tala, La',
	'ES37316' => 'Tamames',
	'ES37317' => 'Tarazona de Guareña',
	'ES37318' => 'Tardáguila',
	'ES37319' => 'Tejado, El',
	'ES37320' => 'Tejeda y Segoyuela',
	'ES37321' => 'Tenebrón',
	'ES37322' => 'Terradillos',
	'ES37323' => 'Topas',
	'ES37324' => 'Tordillos',
	'ES37325' => 'Tornadizo, El',
	'ES37327' => 'Torresmenudas',
	'ES37328' => 'Trabanca',
	'ES37329' => 'Tremedal de Tormes',
	'ES37330' => 'Valdecarros',
	'ES37331' => 'Valdefuentes de Sangusín',
	'ES37332' => 'Valdehijaderos',
	'ES37333' => 'Valdelacasa',
	'ES37334' => 'Valdelageve',
	'ES37335' => 'Valdelosa',
	'ES37336' => 'Valdemierque',
	'ES37337' => 'Valderrodrigo',
	'ES37338' => 'Valdunciel',
	'ES37339' => 'Valero',
	'ES37340' => 'Valsalabroso',
	'ES37341' => 'Valverde de Valdelacasa',
	'ES37342' => 'Valverdón',
	'ES37343' => 'Vallejera de Riofrío',
	'ES37344' => 'Vecinos',
	'ES37345' => 'Vega de Tirados',
	'ES37346' => 'Veguillas, Las',
	'ES37347' => 'Vellés, La',
	'ES37348' => 'Ventosa del Río Almar',
	'ES37349' => 'Vídola, La',
	'ES37350' => 'Vilvestre',
	'ES37351' => 'Villaflores',
	'ES37352' => 'Villagonzalo de Tormes',
	'ES37353' => 'Villalba de los Llanos',
	'ES37355' => 'Villanueva del Conde',
	'ES37356' => 'Villar de Argañán',
	'ES37357' => 'Villar de Ciervo',
	'ES37358' => 'Villar de Gallimazo',
	'ES37359' => 'Villar de la Yegua',
	'ES37360' => 'Villar de Peralonso',
	'ES37361' => 'Villar de Samaniego',
	'ES37363' => 'Villares de Yeltes',
	'ES37364' => 'Villarino de los Aires',
	'ES37365' => 'Villarmayor',
	'ES37366' => 'Villarmuerto',
	'ES37367' => 'Villasbuenas',
	'ES37368' => 'Villasdardo',
	'ES37369' => 'Villaseco de los Gamitos',
	'ES37370' => 'Villaseco de los Reyes',
	'ES37371' => 'Villasrubias',
	'ES37372' => 'Villaverde de Guareña',
	'ES37373' => 'Villavieja de Yeltes',
	'ES37374' => 'Villoria',
	'ES37375' => 'Villoruela',
	'ES37376' => 'Vitigudino',
	'ES37377' => 'Yecla de Yeltes',
	'ES37378' => 'Zamarra',
	'ES37379' => 'Zamayón',
	'ES37380' => 'Zarapicos',
	'ES37381' => 'Zarza de Pumareda, La',
	'ES37382' => 'Zorita de la Frontera',
	'ES38002' => 'Agulo',
	'ES38003' => 'Alajeró',
	'ES38007' => 'Barlovento',
	'ES38010' => 'Buenavista del Norte',
	'ES38012' => 'Fasnia',
	'ES38013' => 'Frontera',
	'ES38014' => 'Fuencaliente de la Palma',
	'ES38015' => 'Garachico',
	'ES38016' => 'Garafía',
	'ES38021' => 'Hermigua',
	'ES38029' => 'Puntagorda',
	'ES38030' => 'Puntallana',
	'ES38033' => 'San Andrés y Sauces',
	'ES38034' => 'San Juan de la Rambla',
	'ES38042' => 'Silos, Los',
	'ES38044' => 'Tanque, El',
	'ES38045' => 'Tazacorte',
	'ES38047' => 'Tijarafe',
	'ES38049' => 'Valle Gran Rey',
	'ES38050' => 'Vallehermoso',
	'ES38052' => 'Vilaflor de Chasna',
	'ES38053' => 'Villa de Mazo',
	'ES38901' => 'Pinar de El Hierro, El',
	'ES39001' => 'Alfoz de Lloredo',
	'ES39002' => 'Ampuero',
	'ES39003' => 'Anievas',
	'ES39004' => 'Arenas de Iguña',
	'ES39005' => 'Argoños',
	'ES39006' => 'Arnuero',
	'ES39007' => 'Arredondo',
	'ES39009' => 'Bárcena de Cicero',
	'ES39010' => 'Bárcena de Pie de Concha',
	'ES39011' => 'Bareyo',
	'ES39013' => 'Cabezón de Liébana',
	'ES39014' => 'Cabuérniga',
	'ES39015' => 'Camaleño',
	'ES39017' => 'Campoo de Yuso',
	'ES39019' => 'Castañeda',
	'ES39021' => 'Cieza',
	'ES39022' => 'Cillorigo de Liébana',
	'ES39024' => 'Comillas',
	'ES39026' => 'Corvera de Toranzo',
	'ES39027' => 'Campoo de Enmedio',
	'ES39029' => 'Escalante',
	'ES39030' => 'Guriezo',
	'ES39031' => 'Hazas de Cesto',
	'ES39032' => 'Hermandad de Campoo de Suso',
	'ES39033' => 'Herrerías',
	'ES39034' => 'Lamasón',
	'ES39036' => 'Liendo',
	'ES39037' => 'Liérganes',
	'ES39038' => 'Limpias',
	'ES39039' => 'Luena',
	'ES39041' => 'Mazcuerras',
	'ES39043' => 'Meruelo',
	'ES39044' => 'Miengo',
	'ES39045' => 'Miera',
	'ES39046' => 'Molledo',
	'ES39047' => 'Noja',
	'ES39048' => 'Penagos',
	'ES39049' => 'Peñarrubia',
	'ES39050' => 'Pesaguero',
	'ES39051' => 'Pesquera',
	'ES39053' => 'Polaciones',
	'ES39055' => 'Potes',
	'ES39056' => 'Puente Viesgo',
	'ES39057' => 'Ramales de la Victoria',
	'ES39058' => 'Rasines',
	'ES39061' => 'Ribamontán al Mar',
	'ES39062' => 'Ribamontán al Monte',
	'ES39063' => 'Rionansa',
	'ES39064' => 'Riotuerto',
	'ES39065' => 'Rozas de Valdearroyo, Las',
	'ES39066' => 'Ruente',
	'ES39067' => 'Ruesga',
	'ES39068' => 'Ruiloba',
	'ES39069' => 'San Felices de Buelna',
	'ES39070' => 'San Miguel de Aguayo',
	'ES39071' => 'San Pedro del Romeral',
	'ES39072' => 'San Roque de Riomiera',
	'ES39076' => 'Santillana del Mar',
	'ES39077' => 'Santiurde de Reinosa',
	'ES39078' => 'Santiurde de Toranzo',
	'ES39080' => 'San Vicente de la Barquera',
	'ES39081' => 'Saro',
	'ES39082' => 'Selaya',
	'ES39083' => 'Soba',
	'ES39084' => 'Solórzano',
	'ES39086' => 'Tojos, Los',
	'ES39088' => 'Tresviso',
	'ES39089' => 'Tudanca',
	'ES39090' => 'Udías',
	'ES39091' => 'Valdáliga',
	'ES39092' => 'Valdeolea',
	'ES39093' => 'Valdeprado del Río',
	'ES39094' => 'Valderredible',
	'ES39095' => 'Val de San Vicente',
	'ES39096' => 'Vega de Liébana',
	'ES39097' => 'Vega de Pas',
	'ES39098' => 'Villacarriedo',
	'ES39099' => 'Villaescusa',
	'ES39100' => 'Villafufre',
	'ES39101' => 'Valle de Villaverde',
	'ES39102' => 'Voto',
	'ES40001' => 'Abades',
	'ES40002' => 'Adrada de Pirón',
	'ES40003' => 'Adrados',
	'ES40004' => 'Aguilafuente',
	'ES40005' => 'Alconada de Maderuelo',
	'ES40006' => 'Aldealcorvo',
	'ES40007' => 'Aldealengua de Pedraza',
	'ES40008' => 'Aldealengua de Santa María',
	'ES40009' => 'Aldeanueva de la Serrezuela',
	'ES40010' => 'Aldeanueva del Codonal',
	'ES40012' => 'Aldea Real',
	'ES40013' => 'Aldeasoña',
	'ES40014' => 'Aldehorno',
	'ES40015' => 'Aldehuela del Codonal',
	'ES40016' => 'Aldeonte',
	'ES40017' => 'Anaya',
	'ES40018' => 'Añe',
	'ES40019' => 'Arahuetes',
	'ES40020' => 'Arcones',
	'ES40021' => 'Arevalillo de Cega',
	'ES40022' => 'Armuña',
	'ES40024' => 'Ayllón',
	'ES40025' => 'Barbolla',
	'ES40026' => 'Basardilla',
	'ES40028' => 'Bercial',
	'ES40029' => 'Bercimuel',
	'ES40030' => 'Bernardos',
	'ES40031' => 'Bernuy de Porreros',
	'ES40032' => 'Boceguillas',
	'ES40033' => 'Brieva',
	'ES40034' => 'Caballar',
	'ES40035' => 'Cabañas de Polendos',
	'ES40036' => 'Cabezuela',
	'ES40037' => 'Calabazas de Fuentidueña',
	'ES40039' => 'Campo de San Pedro',
	'ES40040' => 'Cantalejo',
	'ES40041' => 'Cantimpalos',
	'ES40043' => 'Carbonero el Mayor',
	'ES40044' => 'Carrascal del Río',
	'ES40045' => 'Casla',
	'ES40046' => 'Castillejo de Mesleón',
	'ES40047' => 'Castro de Fuentidueña',
	'ES40048' => 'Castrojimeno',
	'ES40049' => 'Castroserna de Abajo',
	'ES40051' => 'Castroserracín',
	'ES40052' => 'Cedillo de la Torre',
	'ES40053' => 'Cerezo de Abajo',
	'ES40054' => 'Cerezo de Arriba',
	'ES40055' => 'Cilleruelo de San Mamés',
	'ES40056' => 'Cobos de Fuentidueña',
	'ES40057' => 'Coca',
	'ES40058' => 'Codorniz',
	'ES40059' => 'Collado Hermoso',
	'ES40060' => 'Condado de Castilnovo',
	'ES40061' => 'Corral de Ayllón',
	'ES40062' => 'Cubillo',
	'ES40065' => 'Chañe',
	'ES40068' => 'Domingo García',
	'ES40069' => 'Donhierro',
	'ES40070' => 'Duruelo',
	'ES40071' => 'Encinas',
	'ES40072' => 'Encinillas',
	'ES40073' => 'Escalona del Prado',
	'ES40074' => 'Escarabajosa de Cabezas',
	'ES40075' => 'Escobar de Polendos',
	'ES40077' => 'Espirdo',
	'ES40078' => 'Fresneda de Cuéllar',
	'ES40079' => 'Fresno de Cantespino',
	'ES40080' => 'Fresno de la Fuente',
	'ES40081' => 'Frumales',
	'ES40082' => 'Fuente de Santa Cruz',
	'ES40083' => 'Fuente el Olmo de Fuentidueña',
	'ES40084' => 'Fuente el Olmo de Íscar',
	'ES40086' => 'Fuentepelayo',
	'ES40087' => 'Fuentepiñel',
	'ES40088' => 'Fuenterrebollo',
	'ES40089' => 'Fuentesaúco de Fuentidueña',
	'ES40091' => 'Fuentesoto',
	'ES40092' => 'Fuentidueña',
	'ES40093' => 'Gallegos',
	'ES40094' => 'Garcillán',
	'ES40095' => 'Gomezserracín',
	'ES40097' => 'Grajera',
	'ES40099' => 'Honrubia de la Cuesta',
	'ES40100' => 'Hontalbilla',
	'ES40101' => 'Hontanares de Eresma',
	'ES40103' => 'Huertos, Los',
	'ES40104' => 'Ituero y Lama',
	'ES40105' => 'Juarros de Riomoros',
	'ES40106' => 'Juarros de Voltoya',
	'ES40107' => 'Labajos',
	'ES40108' => 'Laguna de Contreras',
	'ES40109' => 'Languilla',
	'ES40110' => 'Lastras de Cuéllar',
	'ES40111' => 'Lastras del Pozo',
	'ES40112' => 'Lastrilla, La',
	'ES40113' => 'Losa, La',
	'ES40115' => 'Maderuelo',
	'ES40118' => 'Marazuela',
	'ES40119' => 'Martín Miguel',
	'ES40120' => 'Martín Muñoz de la Dehesa',
	'ES40121' => 'Martín Muñoz de las Posadas',
	'ES40122' => 'Marugán',
	'ES40123' => 'Matabuena',
	'ES40124' => 'Mata de Cuéllar',
	'ES40125' => 'Matilla, La',
	'ES40126' => 'Melque de Cercos',
	'ES40127' => 'Membibre de la Hoz',
	'ES40128' => 'Migueláñez',
	'ES40129' => 'Montejo de Arévalo',
	'ES40130' => 'Montejo de la Vega de la Serrezuelae',
	'ES40131' => 'Monterrubio',
	'ES40132' => 'Moral de Hornuez',
	'ES40134' => 'Mozoncillo',
	'ES40135' => 'Muñopedro',
	'ES40136' => 'Muñoveros',
	'ES40138' => 'Nava de la Asunción',
	'ES40139' => 'Navafría',
	'ES40140' => 'Navalilla',
	'ES40141' => 'Navalmanzano',
	'ES40142' => 'Navares de Ayuso',
	'ES40143' => 'Navares de Enmedio',
	'ES40144' => 'Navares de las Cuevas',
	'ES40145' => 'Navas de Oro',
	'ES40146' => 'Navas de San Antonio',
	'ES40148' => 'Nieva',
	'ES40149' => 'Olombrada',
	'ES40150' => 'Orejana',
	'ES40151' => 'Ortigosa de Pestaño',
	'ES40152' => 'Otero de Herreros',
	'ES40154' => 'Pajarejos',
	'ES40156' => 'Pedraza',
	'ES40157' => 'Pelayos del Arroyo',
	'ES40158' => 'Perosillo',
	'ES40159' => 'Pinarejos',
	'ES40160' => 'Pinarnegrillo',
	'ES40161' => 'Carabias',
	'ES40162' => 'Prádena',
	'ES40163' => 'Puebla de Pedraza',
	'ES40164' => 'Rapariegos',
	'ES40165' => 'Rebollo',
	'ES40166' => 'Remondo',
	'ES40168' => 'Riaguas de San Bartolomé',
	'ES40170' => 'Riaza',
	'ES40171' => 'Ribota',
	'ES40172' => 'Riofrío de Riaza',
	'ES40173' => 'Roda de Eresma',
	'ES40174' => 'Sacramenia',
	'ES40176' => 'Samboal',
	'ES40177' => 'San Cristóbal de Cuéllar',
	'ES40178' => 'San Cristóbal de la Vega',
	'ES40179' => 'Sanchonuño',
	'ES40180' => 'Sangarcía',
	'ES40182' => 'San Martín y Mudrián',
	'ES40183' => 'San Miguel de Bernuy',
	'ES40184' => 'San Pedro de Gaíllos',
	'ES40185' => 'Santa María la Real de Nieva',
	'ES40186' => 'Santa Marta del Cerro',
	'ES40188' => 'Santiuste de Pedraza',
	'ES40189' => 'Santiuste de San Juan Bautista',
	'ES40190' => 'Santo Domingo de Pirón',
	'ES40191' => 'Santo Tomé del Puerto',
	'ES40192' => 'Sauquillo de Cabezas',
	'ES40193' => 'Sebúlcor',
	'ES40195' => 'Sepúlveda',
	'ES40196' => 'Sequera de Fresno',
	'ES40198' => 'Sotillo',
	'ES40199' => 'Sotosalbos',
	'ES40200' => 'Tabanera la Luenga',
	'ES40201' => 'Tolocirio',
	'ES40202' => 'Torreadrada',
	'ES40203' => 'Torrecaballeros',
	'ES40204' => 'Torrecilla del Pinar',
	'ES40205' => 'Torreiglesias',
	'ES40206' => 'Torre Val de San Pedro',
	'ES40207' => 'Trescasas',
	'ES40208' => 'Turégano',
	'ES40210' => 'Urueñas',
	'ES40211' => 'Valdeprados',
	'ES40212' => 'Valdevacas de Montejo',
	'ES40213' => 'Valdevacas y Guijar',
	'ES40214' => 'Valseca',
	'ES40215' => 'Valtiendas',
	'ES40216' => 'Valverde del Majano',
	'ES40218' => 'Valle de Tabladillo',
	'ES40219' => 'Vallelado',
	'ES40220' => 'Valleruela de Pedraza',
	'ES40221' => 'Valleruela de Sepúlveda',
	'ES40222' => 'Veganzones',
	'ES40223' => 'Vegas de Matute',
	'ES40224' => 'Ventosilla y Tejadilla',
	'ES40225' => 'Villacastín',
	'ES40228' => 'Villaverde de Íscar',
	'ES40229' => 'Villaverde de Montejo',
	'ES40230' => 'Villeguillo',
	'ES40231' => 'Yanguas de Eresma',
	'ES40233' => 'Zarzuela del Monte',
	'ES40234' => 'Zarzuela del Pinar',
	'ES40901' => 'Ortigosa del Monte',
	'ES40902' => 'Cozuelos de Fuentidueña',
	'ES40903' => 'Marazoleja',
	'ES40904' => 'Navas de Riofrío',
	'ES40905' => 'Cuevas de Provanco',
	'ES40906' => 'San Cristóbal de Segovia',
	'ES41001' => 'Aguadulce',
	'ES41002' => 'Alanís',
	'ES41003' => 'Albaida del Aljarafe',
	'ES41006' => 'Alcolea del Río',
	'ES41008' => 'Algámitas',
	'ES41009' => 'Almadén de la Plata',
	'ES41012' => 'Aznalcázar',
	'ES41014' => 'Badolatosa',
	'ES41025' => 'Carrión de los Céspedes',
	'ES41027' => 'Castilblanco de los Arroyos',
	'ES41028' => 'Castilleja de Guzmán',
	'ES41030' => 'Castilleja del Campo',
	'ES41031' => 'Castillo de las Guardas, El',
	'ES41032' => 'Cazalla de la Sierra',
	'ES41035' => 'Coripe',
	'ES41036' => 'Coronil, El',
	'ES41037' => 'Corrales, Los',
	'ES41043' => 'Garrobo, El',
	'ES41046' => 'Gilena',
	'ES41048' => 'Guadalcanal',
	'ES41051' => 'Huévar del Aljarafe',
	'ES41052' => 'Lantejuela',
	'ES41054' => 'Lora de Estepa',
	'ES41056' => 'Luisiana, La',
	'ES41057' => 'Madroño, El',
	'ES41061' => 'Marinaleda',
	'ES41062' => 'Martín de la Jara',
	'ES41063' => 'Molares, Los',
	'ES41066' => 'Navas de la Concepción, Las',
	'ES41073' => 'Pedroso, El',
	'ES41074' => 'Peñaflor',
	'ES41076' => 'Pruna',
	'ES41078' => 'Puebla de los Infantes, La',
	'ES41080' => 'Real de la Jara, El',
	'ES41082' => 'Roda de Andalucía, La',
	'ES41083' => 'Ronquillo, El',
	'ES41084' => 'Rubio, El',
	'ES41088' => 'San Nicolás del Puerto',
	'ES41090' => 'Saucejo, El',
	'ES41097' => 'Villamanrique de la Condesa',
	'ES41099' => 'Villanueva del Río y Minas',
	'ES41100' => 'Villanueva de San Juan',
	'ES41901' => 'Cañada Rosal',
	'ES41904' => 'Palmar de Troya, El',
	'ES42001' => 'Abejar',
	'ES42003' => 'Adradas',
	'ES42004' => 'Ágreda',
	'ES42006' => 'Alconaba',
	'ES42007' => 'Alcubilla de Avellaneda',
	'ES42008' => 'Alcubilla de las Peñas',
	'ES42009' => 'Aldealafuente',
	'ES42010' => 'Aldealices',
	'ES42011' => 'Aldealpozo',
	'ES42012' => 'Aldealseñor',
	'ES42013' => 'Aldehuela de Periáñez',
	'ES42014' => 'Aldehuelas, Las',
	'ES42015' => 'Alentisque',
	'ES42016' => 'Aliud',
	'ES42017' => 'Almajano',
	'ES42018' => 'Almaluez',
	'ES42019' => 'Almarza',
	'ES42021' => 'Almazul',
	'ES42022' => 'Almenar de Soria',
	'ES42023' => 'Alpanseque',
	'ES42024' => 'Arancón',
	'ES42025' => 'Arcos de Jalón',
	'ES42026' => 'Arenillas',
	'ES42027' => 'Arévalo de la Sierra',
	'ES42028' => 'Ausejo de la Sierra',
	'ES42029' => 'Baraona',
	'ES42030' => 'Barca',
	'ES42031' => 'Barcones',
	'ES42032' => 'Bayubas de Abajo',
	'ES42033' => 'Bayubas de Arriba',
	'ES42034' => 'Beratón',
	'ES42035' => 'Berlanga de Duero',
	'ES42036' => 'Blacos',
	'ES42037' => 'Bliecos',
	'ES42038' => 'Borjabad',
	'ES42039' => 'Borobia',
	'ES42041' => 'Buberos',
	'ES42042' => 'Buitrago',
	'ES42043' => 'Burgo de Osma-Ciudad de Osma',
	'ES42044' => 'Cabrejas del Campo',
	'ES42045' => 'Cabrejas del Pinar',
	'ES42046' => 'Calatañazor',
	'ES42048' => 'Caltojar',
	'ES42049' => 'Candilichera',
	'ES42050' => 'Cañamaque',
	'ES42051' => 'Carabantes',
	'ES42052' => 'Caracena',
	'ES42053' => 'Carrascosa de Abajo',
	'ES42054' => 'Carrascosa de la Sierra',
	'ES42055' => 'Casarejos',
	'ES42056' => 'Castilfrío de la Sierra',
	'ES42057' => 'Castilruiz',
	'ES42058' => 'Castillejo de Robledo',
	'ES42059' => 'Centenera de Andaluz',
	'ES42060' => 'Cerbón',
	'ES42061' => 'Cidones',
	'ES42062' => 'Cigudosa',
	'ES42063' => 'Cihuela',
	'ES42064' => 'Ciria',
	'ES42065' => 'Cirujales del Río',
	'ES42068' => 'Coscurita',
	'ES42069' => 'Covaleda',
	'ES42070' => 'Cubilla',
	'ES42071' => 'Cubo de la Solana',
	'ES42073' => 'Cueva de Ágreda',
	'ES42075' => 'Dévanos',
	'ES42076' => 'Deza',
	'ES42078' => 'Duruelo de la Sierra',
	'ES42079' => 'Escobosa de Almazán',
	'ES42080' => 'Espeja de San Marcelino',
	'ES42081' => 'Espejón',
	'ES42082' => 'Estepa de San Juan',
	'ES42083' => 'Frechilla de Almazán',
	'ES42084' => 'Fresno de Caracena',
	'ES42085' => 'Fuentearmegil',
	'ES42086' => 'Fuentecambrón',
	'ES42087' => 'Fuentecantos',
	'ES42088' => 'Fuentelmonge',
	'ES42089' => 'Fuentelsaz de Soria',
	'ES42090' => 'Fuentepinilla',
	'ES42092' => 'Fuentes de Magaña',
	'ES42093' => 'Fuentestrún',
	'ES42094' => 'Garray',
	'ES42095' => 'Golmayo',
	'ES42096' => 'Gómara',
	'ES42097' => 'Gormaz',
	'ES42098' => 'Herrera de Soria',
	'ES42100' => 'Hinojosa del Campo',
	'ES42103' => 'Langa de Duero',
	'ES42105' => 'Liceras',
	'ES42106' => 'Losilla, La',
	'ES42107' => 'Magaña',
	'ES42108' => 'Maján',
	'ES42110' => 'Matalebreras',
	'ES42111' => 'Matamala de Almazán',
	'ES42113' => 'Medinaceli',
	'ES42115' => 'Miño de Medinaceli',
	'ES42116' => 'Miño de San Esteban',
	'ES42117' => 'Molinos de Duero',
	'ES42118' => 'Momblona',
	'ES42119' => 'Monteagudo de las Vicarías',
	'ES42120' => 'Montejo de Tiermes',
	'ES42121' => 'Montenegro de Cameros',
	'ES42123' => 'Morón de Almazán',
	'ES42124' => 'Muriel de la Fuente',
	'ES42125' => 'Muriel Viejo',
	'ES42127' => 'Nafría de Ucero',
	'ES42128' => 'Narros',
	'ES42129' => 'Navaleno',
	'ES42130' => 'Nepas',
	'ES42131' => 'Nolay',
	'ES42132' => 'Noviercas',
	'ES42134' => 'Ólvega',
	'ES42135' => 'Oncala',
	'ES42139' => 'Pinilla del Campo',
	'ES42140' => 'Portillo de Soria',
	'ES42141' => 'Póveda de Soria, La',
	'ES42142' => 'Pozalmuro',
	'ES42144' => 'Quintana Redonda',
	'ES42145' => 'Quintanas de Gormaz',
	'ES42148' => 'Quiñonería',
	'ES42149' => 'Rábanos, Los',
	'ES42151' => 'Rebollar',
	'ES42152' => 'Recuerda',
	'ES42153' => 'Rello',
	'ES42154' => 'Renieblas',
	'ES42155' => 'Retortillo de Soria',
	'ES42156' => 'Reznos',
	'ES42157' => 'Riba de Escalote, La',
	'ES42158' => 'Rioseco de Soria',
	'ES42159' => 'Rollamienta',
	'ES42160' => 'Royo, El',
	'ES42161' => 'Salduero',
	'ES42162' => 'San Esteban de Gormaz',
	'ES42163' => 'San Felices',
	'ES42164' => 'San Leonardo de Yagüe',
	'ES42165' => 'San Pedro Manrique',
	'ES42166' => 'Santa Cruz de Yanguas',
	'ES42167' => 'Santa María de Huerta',
	'ES42168' => 'Santa María de las Hoyas',
	'ES42171' => 'Serón de Nágima',
	'ES42172' => 'Soliedra',
	'ES42174' => 'Sotillo del Rincón',
	'ES42175' => 'Suellacabras',
	'ES42176' => 'Tajahuerce',
	'ES42177' => 'Tajueco',
	'ES42178' => 'Talveila',
	'ES42181' => 'Tardelcuende',
	'ES42182' => 'Taroda',
	'ES42183' => 'Tejado',
	'ES42184' => 'Torlengua',
	'ES42185' => 'Torreblacos',
	'ES42187' => 'Torrubia de Soria',
	'ES42188' => 'Trévago',
	'ES42189' => 'Ucero',
	'ES42190' => 'Vadillo',
	'ES42191' => 'Valdeavellano de Tera',
	'ES42192' => 'Valdegeña',
	'ES42193' => 'Valdelagua del Cerro',
	'ES42194' => 'Valdemaluque',
	'ES42195' => 'Valdenebro',
	'ES42196' => 'Valdeprado',
	'ES42197' => 'Valderrodilla',
	'ES42198' => 'Valtajeros',
	'ES42200' => 'Velamazán',
	'ES42201' => 'Velilla de la Sierra',
	'ES42202' => 'Velilla de los Ajos',
	'ES42204' => 'Viana de Duero',
	'ES42205' => 'Villaciervos',
	'ES42206' => 'Villanueva de Gormaz',
	'ES42207' => 'Villar del Ala',
	'ES42208' => 'Villar del Campo',
	'ES42209' => 'Villar del Río',
	'ES42211' => 'Villares de Soria, Los',
	'ES42212' => 'Villasayas',
	'ES42213' => 'Villaseca de Arciel',
	'ES42215' => 'Vinuesa',
	'ES42216' => 'Vizmanos',
	'ES42217' => 'Vozmediano',
	'ES42218' => 'Yanguas',
	'ES42219' => 'Yelo',
	'ES43001' => 'Aiguamúrcia',
	'ES43002' => 'Albinyana',
	'ES43003' => 'Albiol, L',
	'ES43006' => 'Aldover',
	'ES43007' => 'Aleixar, L',
	'ES43008' => 'Alfara de Carles',
	'ES43009' => 'Alforja',
	'ES43010' => 'Alió',
	'ES43011' => 'Almoster',
	'ES43015' => 'Arbolí',
	'ES43017' => 'Argentera, L',
	'ES43018' => 'Arnes',
	'ES43019' => 'Ascó',
	'ES43020' => 'Banyeres del Penedès',
	'ES43021' => 'Barberà de la Conca',
	'ES43022' => 'Batea',
	'ES43023' => 'Bellmunt del Priorat',
	'ES43024' => 'Bellvei',
	'ES43025' => 'Benifallet',
	'ES43026' => 'Benissanet',
	'ES43027' => 'Bisbal de Falset, La',
	'ES43028' => 'Bisbal del Penedès, La',
	'ES43029' => 'Blancafort',
	'ES43030' => 'Bonastre',
	'ES43031' => 'Borges del Camp, Les',
	'ES43032' => 'Bot',
	'ES43033' => 'Botarell',
	'ES43034' => 'Bràfim',
	'ES43035' => 'Cabacés',
	'ES43036' => 'Cabra del Camp',
	'ES43039' => 'Capafonts',
	'ES43040' => 'Capçanes',
	'ES43041' => 'Caseres',
	'ES43042' => 'Castellvell del Camp',
	'ES43043' => 'Catllar, El',
	'ES43045' => 'Colldejou',
	'ES43046' => 'Conesa',
	'ES43048' => 'Corbera dEbre',
	'ES43049' => 'Cornudella de Montsant',
	'ES43050' => 'Creixell',
	'ES43052' => 'Xerta',
	'ES43053' => 'Duesaigües',
	'ES43054' => 'Espluga de Francolí, L',
	'ES43055' => 'Falset',
	'ES43056' => 'Fatarella, La',
	'ES43057' => 'Febró, La',
	'ES43058' => 'Figuera, La',
	'ES43059' => 'Figuerola del Camp',
	'ES43060' => 'Flix',
	'ES43061' => 'Forès',
	'ES43062' => 'Freginals',
	'ES43063' => 'Galera, La',
	'ES43064' => 'Gandesa',
	'ES43065' => 'Garcia',
	'ES43066' => 'Garidells, Els',
	'ES43067' => 'Ginestar',
	'ES43068' => 'Godall',
	'ES43069' => 'Gratallops',
	'ES43070' => 'Guiamets, Els',
	'ES43071' => 'Horta de Sant Joan',
	'ES43072' => 'Lloar, El',
	'ES43073' => 'Llorac',
	'ES43074' => 'Llorenç del Penedès',
	'ES43075' => 'Margalef',
	'ES43076' => 'Marçà',
	'ES43077' => 'Mas de Barberans',
	'ES43078' => 'Masdenverge',
	'ES43079' => 'Masllorenç',
	'ES43080' => 'Masó, La',
	'ES43081' => 'Maspujols',
	'ES43082' => 'Masroig, El',
	'ES43083' => 'Milà, El',
	'ES43084' => 'Miravet',
	'ES43085' => 'Molar, El',
	'ES43088' => 'Montbrió del Camp',
	'ES43089' => 'Montferri',
	'ES43090' => 'Montmell, El',
	'ES43091' => 'Mont-ral',
	'ES43094' => 'Móra la Nova',
	'ES43095' => 'Morell, El',
	'ES43096' => 'Morera de Montsant, La',
	'ES43097' => 'Nou de Gaià, La',
	'ES43098' => 'Nulles',
	'ES43099' => 'Palma dEbre, La',
	'ES43100' => 'Pallaresos, Els',
	'ES43101' => 'Passanant i Belltall',
	'ES43102' => 'Paüls',
	'ES43103' => 'Perafort',
	'ES43104' => 'Perelló, El',
	'ES43105' => 'Piles, Les',
	'ES43106' => 'Pinell de Brai, El',
	'ES43107' => 'Pira',
	'ES43108' => 'Pla de Santa Maria, El',
	'ES43109' => 'Pobla de Mafumet, La',
	'ES43110' => 'Pobla de Massaluca, La',
	'ES43111' => 'Pobla de Montornès, La',
	'ES43112' => 'Poboleda',
	'ES43113' => 'Pont dArmentera, El',
	'ES43114' => 'Porrera',
	'ES43115' => 'Pradell de la Teixeta',
	'ES43116' => 'Prades',
	'ES43117' => 'Prat de Comte',
	'ES43118' => 'Pratdip',
	'ES43119' => 'Puigpelat',
	'ES43120' => 'Querol',
	'ES43121' => 'Rasquera',
	'ES43122' => 'Renau',
	'ES43124' => 'Riba, La',
	'ES43125' => 'Riba-roja dEbre',
	'ES43126' => 'Riera de Gaià, La',
	'ES43127' => 'Riudecanyes',
	'ES43128' => 'Riudecols',
	'ES43130' => 'Rocafort de Queralt',
	'ES43132' => 'Rodonyà',
	'ES43134' => 'Rourell, El',
	'ES43135' => 'Salomó',
	'ES43137' => 'Sant Jaume dels Domenys',
	'ES43138' => 'Santa Bàrbara',
	'ES43139' => 'Santa Coloma de Queralt',
	'ES43140' => 'Santa Oliva',
	'ES43141' => 'Pontils',
	'ES43142' => 'Sarral',
	'ES43143' => 'Savallà del Comtat',
	'ES43144' => 'Secuita, La',
	'ES43146' => 'Senan',
	'ES43147' => 'Solivella',
	'ES43149' => 'Tivenys',
	'ES43150' => 'Tivissa',
	'ES43151' => 'Torre de Fontaubella, La',
	'ES43152' => 'Torre de lEspanyol, La',
	'ES43154' => 'Torroja del Priorat',
	'ES43157' => 'Ulldemolins',
	'ES43158' => 'Vallclara',
	'ES43159' => 'Vallfogona de Riucorb',
	'ES43160' => 'Vallmoll',
	'ES43164' => 'Vespella de Gaià',
	'ES43165' => 'Vilabella',
	'ES43166' => 'Vilallonga del Camp',
	'ES43167' => 'Vilanova dEscornalbou',
	'ES43168' => 'Vilanova de Prades',
	'ES43169' => 'Vilaplana',
	'ES43170' => 'Vila-rodona',
	'ES43172' => 'Vilaverd',
	'ES43173' => 'Vilella Alta, La',
	'ES43174' => 'Vilella Baixa, La',
	'ES43175' => 'Vilalba dels Arcs',
	'ES43176' => 'Vimbodí i Poblet',
	'ES43177' => 'Vinebre',
	'ES43178' => 'Vinyols i els Arcs',
	'ES43902' => 'Sant Jaume dEnveja',
	'ES43903' => 'Camarles',
	'ES43904' => 'Aldea, L',
	'ES43906' => 'Ampolla, L',
	'ES44001' => 'Ababuj',
	'ES44002' => 'Abejuela',
	'ES44003' => 'Aguatón',
	'ES44004' => 'Aguaviva',
	'ES44005' => 'Aguilar del Alfambra',
	'ES44006' => 'Alacón',
	'ES44007' => 'Alba',
	'ES44008' => 'Albalate del Arzobispo',
	'ES44009' => 'Albarracín',
	'ES44010' => 'Albentosa',
	'ES44011' => 'Alcaine',
	'ES44012' => 'Alcalá de la Selva',
	'ES44014' => 'Alcorisa',
	'ES44016' => 'Alfambra',
	'ES44017' => 'Aliaga',
	'ES44018' => 'Almohaja',
	'ES44019' => 'Alobras',
	'ES44020' => 'Alpeñés',
	'ES44021' => 'Allepuz',
	'ES44022' => 'Alloza',
	'ES44023' => 'Allueva',
	'ES44024' => 'Anadón',
	'ES44026' => 'Arcos de las Salinas',
	'ES44027' => 'Arens de Lledó',
	'ES44028' => 'Argente',
	'ES44029' => 'Ariño',
	'ES44031' => 'Azaila',
	'ES44032' => 'Bádenas',
	'ES44033' => 'Báguena',
	'ES44034' => 'Bañón',
	'ES44035' => 'Barrachina',
	'ES44036' => 'Bea',
	'ES44037' => 'Beceite',
	'ES44038' => 'Belmonte de San José',
	'ES44039' => 'Bello',
	'ES44040' => 'Berge',
	'ES44041' => 'Bezas',
	'ES44042' => 'Blancas',
	'ES44043' => 'Blesa',
	'ES44044' => 'Bordón',
	'ES44045' => 'Bronchales',
	'ES44046' => 'Bueña',
	'ES44047' => 'Burbáguena',
	'ES44048' => 'Cabra de Mora',
	'ES44049' => 'Calaceite',
	'ES44050' => 'Calamocha',
	'ES44051' => 'Calanda',
	'ES44052' => 'Calomarde',
	'ES44053' => 'Camañas',
	'ES44054' => 'Camarena de la Sierra',
	'ES44055' => 'Camarillas',
	'ES44056' => 'Caminreal',
	'ES44059' => 'Cantavieja',
	'ES44060' => 'Cañada de Benatanduz',
	'ES44061' => 'Cañada de Verich, La',
	'ES44062' => 'Cañada Vellida',
	'ES44063' => 'Cañizar del Olivar',
	'ES44064' => 'Cascante del Río',
	'ES44065' => 'Castejón de Tornos',
	'ES44066' => 'Castel de Cabra',
	'ES44067' => 'Castelnou',
	'ES44068' => 'Castelserás',
	'ES44070' => 'Castellar, El',
	'ES44071' => 'Castellote',
	'ES44074' => 'Cedrillas',
	'ES44075' => 'Celadas',
	'ES44076' => 'Cella',
	'ES44077' => 'Cerollera, La',
	'ES44080' => 'Codoñera, La',
	'ES44082' => 'Corbalán',
	'ES44084' => 'Cortes de Aragón',
	'ES44085' => 'Cosa',
	'ES44086' => 'Cretas',
	'ES44087' => 'Crivillén',
	'ES44088' => 'Cuba, La',
	'ES44089' => 'Cubla',
	'ES44090' => 'Cucalón',
	'ES44092' => 'Cuervo, El',
	'ES44093' => 'Cuevas de Almudén',
	'ES44094' => 'Cuevas Labradas',
	'ES44096' => 'Ejulve',
	'ES44097' => 'Escorihuela',
	'ES44099' => 'Escucha',
	'ES44100' => 'Estercuel',
	'ES44101' => 'Ferreruela de Huerva',
	'ES44102' => 'Fonfría',
	'ES44103' => 'Formiche Alto',
	'ES44105' => 'Fórnoles',
	'ES44106' => 'Fortanete',
	'ES44107' => 'Foz-Calanda',
	'ES44108' => 'Fresneda, La',
	'ES44109' => 'Frías de Albarracín',
	'ES44110' => 'Fuenferrada',
	'ES44111' => 'Fuentes Calientes',
	'ES44112' => 'Fuentes Claras',
	'ES44113' => 'Fuentes de Rubielos',
	'ES44114' => 'Fuentespalda',
	'ES44115' => 'Galve',
	'ES44116' => 'Gargallo',
	'ES44117' => 'Gea de Albarracín',
	'ES44118' => 'Ginebrosa, La',
	'ES44119' => 'Griegos',
	'ES44120' => 'Guadalaviar',
	'ES44121' => 'Gúdar',
	'ES44122' => 'Híjar',
	'ES44123' => 'Hinojosa de Jarque',
	'ES44124' => 'Hoz de la Vieja, La',
	'ES44125' => 'Huesa del Común',
	'ES44126' => 'Iglesuela del Cid, La',
	'ES44127' => 'Jabaloyas',
	'ES44128' => 'Jarque de la Val',
	'ES44129' => 'Jatiel',
	'ES44130' => 'Jorcas',
	'ES44131' => 'Josa',
	'ES44132' => 'Lagueruela',
	'ES44133' => 'Lanzuela',
	'ES44135' => 'Libros',
	'ES44136' => 'Lidón',
	'ES44137' => 'Linares de Mora',
	'ES44138' => 'Loscos',
	'ES44141' => 'Lledó',
	'ES44142' => 'Maicas',
	'ES44143' => 'Manzanera',
	'ES44144' => 'Martín del Río',
	'ES44145' => 'Mas de las Matas',
	'ES44146' => 'Mata de los Olmos, La',
	'ES44147' => 'Mazaleón',
	'ES44148' => 'Mezquita de Jarque',
	'ES44149' => 'Mirambel',
	'ES44150' => 'Miravete de la Sierra',
	'ES44151' => 'Molinos',
	'ES44152' => 'Monforte de Moyuela',
	'ES44153' => 'Monreal del Campo',
	'ES44154' => 'Monroyo',
	'ES44155' => 'Montalbán',
	'ES44156' => 'Monteagudo del Castillo',
	'ES44157' => 'Monterde de Albarracín',
	'ES44158' => 'Mora de Rubielos',
	'ES44159' => 'Moscardón',
	'ES44160' => 'Mosqueruela',
	'ES44161' => 'Muniesa',
	'ES44163' => 'Noguera de Albarracín',
	'ES44164' => 'Nogueras',
	'ES44165' => 'Nogueruelas',
	'ES44167' => 'Obón',
	'ES44168' => 'Odón',
	'ES44169' => 'Ojos Negros',
	'ES44171' => 'Olba',
	'ES44172' => 'Oliete',
	'ES44173' => 'Olmos, Los',
	'ES44174' => 'Orihuela del Tremedal',
	'ES44175' => 'Orrios',
	'ES44176' => 'Palomar de Arroyos',
	'ES44177' => 'Pancrudo',
	'ES44178' => 'Parras de Castellote, Las',
	'ES44179' => 'Peñarroya de Tastavins',
	'ES44180' => 'Peracense',
	'ES44181' => 'Peralejos',
	'ES44182' => 'Perales del Alfambra',
	'ES44183' => 'Pitarque',
	'ES44184' => 'Plou',
	'ES44185' => 'Pobo, El',
	'ES44187' => 'Portellada, La',
	'ES44189' => 'Pozondón',
	'ES44190' => 'Pozuel del Campo',
	'ES44191' => 'Puebla de Híjar, La',
	'ES44192' => 'Puebla de Valverde, La',
	'ES44193' => 'Puertomingalvo',
	'ES44194' => 'Ráfales',
	'ES44195' => 'Rillo',
	'ES44196' => 'Riodeva',
	'ES44197' => 'Ródenas',
	'ES44198' => 'Royuela',
	'ES44199' => 'Rubiales',
	'ES44200' => 'Rubielos de la Cérida',
	'ES44201' => 'Rubielos de Mora',
	'ES44203' => 'Salcedillo',
	'ES44204' => 'Saldón',
	'ES44205' => 'Samper de Calanda',
	'ES44206' => 'San Agustín',
	'ES44207' => 'San Martín del Río',
	'ES44208' => 'Santa Cruz de Nogueras',
	'ES44209' => 'Santa Eulalia',
	'ES44210' => 'Sarrión',
	'ES44211' => 'Segura de los Baños',
	'ES44212' => 'Seno',
	'ES44213' => 'Singra',
	'ES44215' => 'Terriente',
	'ES44217' => 'Toril y Masegoso',
	'ES44218' => 'Tormón',
	'ES44219' => 'Tornos',
	'ES44220' => 'Torralba de los Sisones',
	'ES44221' => 'Torrecilla de Alcañiz',
	'ES44222' => 'Torrecilla del Rebollar',
	'ES44223' => 'Torre de Arcas',
	'ES44224' => 'Torre de las Arcas',
	'ES44225' => 'Torre del Compte',
	'ES44226' => 'Torrelacárcel',
	'ES44227' => 'Torre los Negros',
	'ES44228' => 'Torremocha de Jiloca',
	'ES44229' => 'Torres de Albarracín',
	'ES44230' => 'Torrevelilla',
	'ES44231' => 'Torrijas',
	'ES44232' => 'Torrijo del Campo',
	'ES44234' => 'Tramacastiel',
	'ES44235' => 'Tramacastilla',
	'ES44236' => 'Tronchón',
	'ES44237' => 'Urrea de Gaén',
	'ES44238' => 'Utrillas',
	'ES44239' => 'Valacloche',
	'ES44240' => 'Valbona',
	'ES44241' => 'Valdealgorfa',
	'ES44243' => 'Valdecuenca',
	'ES44244' => 'Valdelinares',
	'ES44245' => 'Valdeltormo',
	'ES44246' => 'Valderrobres',
	'ES44247' => 'Valjunquera',
	'ES44249' => 'Vallecillo, El',
	'ES44250' => 'Veguillas de la Sierra',
	'ES44251' => 'Villafranca del Campo',
	'ES44252' => 'Villahermosa del Campo',
	'ES44256' => 'Villanueva del Rebollar de la Sierrace',
	'ES44257' => 'Villar del Cobo',
	'ES44258' => 'Villar del Salz',
	'ES44260' => 'Villarluengo',
	'ES44261' => 'Villarquemado',
	'ES44262' => 'Villarroya de los Pinares',
	'ES44263' => 'Villastar',
	'ES44264' => 'Villel',
	'ES44265' => 'Vinaceite',
	'ES44266' => 'Visiedo',
	'ES44267' => 'Vivel del Río Martín',
	'ES44268' => 'Zoma, La',
	'ES45001' => 'Ajofrín',
	'ES45002' => 'Alameda de la Sagra',
	'ES45003' => 'Albarreal de Tajo',
	'ES45004' => 'Alcabón',
	'ES45005' => 'Alcañizo',
	'ES45006' => 'Alcaudete de la Jara',
	'ES45007' => 'Alcolea de Tajo',
	'ES45008' => 'Aldea en Cabo',
	'ES45009' => 'Aldeanueva de Barbarroya',
	'ES45010' => 'Aldeanueva de San Bartolomé',
	'ES45011' => 'Almendral de la Cañada',
	'ES45012' => 'Almonacid de Toledo',
	'ES45013' => 'Almorox',
	'ES45015' => 'Arcicóllar',
	'ES45017' => 'Azután',
	'ES45018' => 'Barcience',
	'ES45020' => 'Belvís de la Jara',
	'ES45021' => 'Borox',
	'ES45022' => 'Buenaventura',
	'ES45023' => 'Burguillos de Toledo',
	'ES45024' => 'Burujón',
	'ES45025' => 'Cabañas de la Sagra',
	'ES45026' => 'Cabañas de Yepes',
	'ES45027' => 'Cabezamesada',
	'ES45028' => 'Calera y Chozas',
	'ES45029' => 'Caleruela',
	'ES45030' => 'Calzada de Oropesa',
	'ES45031' => 'Camarena',
	'ES45032' => 'Camarenilla',
	'ES45033' => 'Campillo de la Jara, El',
	'ES45034' => 'Camuñas',
	'ES45035' => 'Cardiel de los Montes',
	'ES45036' => 'Carmena',
	'ES45037' => 'Carpio de Tajo, El',
	'ES45038' => 'Carranque',
	'ES45039' => 'Carriches',
	'ES45040' => 'Casar de Escalona, El',
	'ES45042' => 'Casasbuenas',
	'ES45043' => 'Castillo de Bayuela',
	'ES45045' => 'Cazalegas',
	'ES45046' => 'Cebolla',
	'ES45047' => 'Cedillo del Condado',
	'ES45048' => 'Cerralbos, Los',
	'ES45049' => 'Cervera de los Montes',
	'ES45050' => 'Ciruelos',
	'ES45051' => 'Cobeja',
	'ES45052' => 'Cobisa',
	'ES45055' => 'Cuerva',
	'ES45056' => 'Chozas de Canales',
	'ES45057' => 'Chueca',
	'ES45058' => 'Domingo Pérez',
	'ES45059' => 'Dosbarrios',
	'ES45060' => 'Erustes',
	'ES45061' => 'Escalona',
	'ES45062' => 'Escalonilla',
	'ES45063' => 'Espinoso del Rey',
	'ES45065' => 'Estrella, La',
	'ES45067' => 'Gálvez',
	'ES45068' => 'Garciotum',
	'ES45069' => 'Gerindote',
	'ES45070' => 'Guadamur',
	'ES45071' => 'Guardia, La',
	'ES45072' => 'Herencias, Las',
	'ES45073' => 'Herreruela de Oropesa',
	'ES45074' => 'Hinojosa de San Vicente',
	'ES45075' => 'Hontanar',
	'ES45076' => 'Hormigos',
	'ES45077' => 'Huecas',
	'ES45078' => 'Huerta de Valdecarábanos',
	'ES45079' => 'Iglesuela del Tiétar, La',
	'ES45080' => 'Illán de Vacas',
	'ES45082' => 'Lagartera',
	'ES45083' => 'Layos',
	'ES45084' => 'Lillo',
	'ES45085' => 'Lominchar',
	'ES45086' => 'Lucillos',
	'ES45088' => 'Magán',
	'ES45089' => 'Malpica de Tajo',
	'ES45090' => 'Manzaneque',
	'ES45091' => 'Maqueda',
	'ES45092' => 'Marjaliza',
	'ES45093' => 'Marrupe',
	'ES45094' => 'Mascaraque',
	'ES45095' => 'Mata, La',
	'ES45096' => 'Mazarambroz',
	'ES45097' => 'Mejorada',
	'ES45098' => 'Menasalbas',
	'ES45100' => 'Mesegar de Tajo',
	'ES45101' => 'Miguel Esteban',
	'ES45102' => 'Mocejón',
	'ES45103' => 'Mohedas de la Jara',
	'ES45104' => 'Montearagón',
	'ES45105' => 'Montesclaros',
	'ES45107' => 'Nambroca',
	'ES45108' => 'Nava de Ricomalillo, La',
	'ES45109' => 'Navahermosa',
	'ES45110' => 'Navalcán',
	'ES45111' => 'Navalmoralejo',
	'ES45112' => 'Navalmorales, Los',
	'ES45113' => 'Navalucillos, Los',
	'ES45114' => 'Navamorcuende',
	'ES45115' => 'Noblejas',
	'ES45116' => 'Noez',
	'ES45117' => 'Nombela',
	'ES45118' => 'Novés',
	'ES45119' => 'Numancia de la Sagra',
	'ES45120' => 'Nuño Gómez',
	'ES45123' => 'Ontígola',
	'ES45124' => 'Orgaz',
	'ES45125' => 'Oropesa',
	'ES45126' => 'Otero',
	'ES45127' => 'Palomeque',
	'ES45128' => 'Pantoja',
	'ES45129' => 'Paredes de Escalona',
	'ES45130' => 'Parrillas',
	'ES45131' => 'Pelahustán',
	'ES45132' => 'Pepino',
	'ES45133' => 'Polán',
	'ES45134' => 'Portillo de Toledo',
	'ES45137' => 'Pueblanueva, La',
	'ES45138' => 'Puente del Arzobispo, El',
	'ES45139' => 'Puerto de San Vicente',
	'ES45140' => 'Pulgar',
	'ES45141' => 'Quero',
	'ES45143' => 'Quismondo',
	'ES45144' => 'Real de San Vicente, El',
	'ES45145' => 'Recas',
	'ES45146' => 'Retamoso de la Jara',
	'ES45147' => 'Rielves',
	'ES45148' => 'Robledo del Mazo',
	'ES45149' => 'Romeral, El',
	'ES45150' => 'San Bartolomé de las Abiertas',
	'ES45151' => 'San Martín de Montalbán',
	'ES45152' => 'San Martín de Pusa',
	'ES45153' => 'San Pablo de los Montes',
	'ES45154' => 'San Román de los Montes',
	'ES45155' => 'Santa Ana de Pusa',
	'ES45156' => 'Santa Cruz de la Zarza',
	'ES45157' => 'Santa Cruz del Retamar',
	'ES45158' => 'Santa Olalla',
	'ES45159' => 'Sartajada',
	'ES45160' => 'Segurilla',
	'ES45162' => 'Sevilleja de la Jara',
	'ES45164' => 'Sotillo de las Palomas',
	'ES45166' => 'Tembleque',
	'ES45167' => 'Toboso, El',
	'ES45169' => 'Torralba de Oropesa',
	'ES45170' => 'Torrecilla de la Jara',
	'ES45171' => 'Torre de Esteban Hambrán, La',
	'ES45172' => 'Torrico',
	'ES45174' => 'Totanés',
	'ES45175' => 'Turleque',
	'ES45177' => 'Urda',
	'ES45179' => 'Valdeverdeja',
	'ES45180' => 'Valmojado',
	'ES45181' => 'Velada',
	'ES45182' => 'Ventas con Peña Aguilera, Las',
	'ES45183' => 'Ventas de Retamosa, Las',
	'ES45184' => 'Ventas de San Julián, Las',
	'ES45186' => 'Villa de Don Fadrique, La',
	'ES45187' => 'Villafranca de los Caballeros',
	'ES45188' => 'Villaluenga de la Sagra',
	'ES45189' => 'Villamiel de Toledo',
	'ES45190' => 'Villaminaya',
	'ES45191' => 'Villamuelas',
	'ES45192' => 'Villanueva de Alcardete',
	'ES45193' => 'Villanueva de Bogas',
	'ES45194' => 'Villarejo de Montalbán',
	'ES45195' => 'Villarrubia de Santiago',
	'ES45196' => 'Villaseca de la Sagra',
	'ES45197' => 'Villasequilla',
	'ES45198' => 'Villatobas',
	'ES45199' => 'Viso de San Juan, El',
	'ES45203' => 'Yuncler',
	'ES45204' => 'Yunclillos',
	'ES45901' => 'Santo Domingo-Caudilla',
	'ES46001' => 'Ademuz',
	'ES46002' => 'Ador',
	'ES46003' => 'Atzeneta dAlbaida',
	'ES46004' => 'Agullent',
	'ES46008' => 'Albalat de la Ribera',
	'ES46009' => 'Albalat dels Sorells',
	'ES46010' => 'Albalat dels Tarongers',
	'ES46012' => 'Alborache',
	'ES46014' => 'Albuixech',
	'ES46016' => 'Alcàntera de Xúquer',
	'ES46018' => 'Alcublas',
	'ES46023' => 'Alfauir',
	'ES46024' => 'Alfara de la Baronia',
	'ES46025' => 'Alfara del Patriarca',
	'ES46026' => 'Alfarp',
	'ES46027' => 'Alfarrasí',
	'ES46028' => 'Algar de Palancia',
	'ES46030' => 'Algímia dAlfara',
	'ES46033' => 'Almiserà',
	'ES46034' => 'Almoines',
	'ES46036' => 'Alpuente',
	'ES46037' => 'Alqueria de la Comtessa, l',
	'ES46038' => 'Andilla',
	'ES46039' => 'Anna',
	'ES46040' => 'Antella',
	'ES46041' => 'Aras de los Olmos',
	'ES46042' => 'Aielo de Malferit',
	'ES46043' => 'Aielo de Rugat',
	'ES46045' => 'Barxeta',
	'ES46046' => 'Barx',
	'ES46047' => 'Bèlgida',
	'ES46048' => 'Bellreguard',
	'ES46049' => 'Bellús',
	'ES46050' => 'Benagéber',
	'ES46052' => 'Benavites',
	'ES46053' => 'Beneixida',
	'ES46055' => 'Beniarjó',
	'ES46056' => 'Beniatjar',
	'ES46057' => 'Benicolet',
	'ES46058' => 'Benifairó de les Valls',
	'ES46059' => 'Benifairó de la Valldigna',
	'ES46061' => 'Beniflá',
	'ES46063' => 'Benimodo',
	'ES46064' => 'Benimuslem',
	'ES46065' => 'Beniparrell',
	'ES46066' => 'Benirredrà',
	'ES46067' => 'Benissanó',
	'ES46068' => 'Benissoda',
	'ES46069' => 'Benissuera',
	'ES46071' => 'Bicorp',
	'ES46072' => 'Bocairent',
	'ES46073' => 'Bolbaite',
	'ES46074' => 'Bonrepòs i Mirambell',
	'ES46075' => 'Bufali',
	'ES46076' => 'Bugarra',
	'ES46079' => 'Calles',
	'ES46080' => 'Camporrobles',
	'ES46084' => 'Càrcer',
	'ES46086' => 'Carrícola',
	'ES46087' => 'Casas Altas',
	'ES46088' => 'Casas Bajas',
	'ES46089' => 'Casinos',
	'ES46090' => 'Castelló de Rugat',
	'ES46091' => 'Castellonet de la Conquesta',
	'ES46092' => 'Castielfabib',
	'ES46093' => 'Catadau',
	'ES46095' => 'Caudete de las Fuentes',
	'ES46096' => 'Cerdà',
	'ES46097' => 'Cofrentes',
	'ES46098' => 'Corbera',
	'ES46099' => 'Cortes de Pallás',
	'ES46100' => 'Cotes',
	'ES46101' => 'Quart de les Valls',
	'ES46103' => 'Quartell',
	'ES46104' => 'Quatretonda',
	'ES46106' => 'Chelva',
	'ES46107' => 'Chella',
	'ES46108' => 'Chera',
	'ES46112' => 'Chulilla',
	'ES46113' => 'Daimús',
	'ES46114' => 'Domeño',
	'ES46115' => 'Dos Aguas',
	'ES46117' => 'Emperador',
	'ES46118' => 'Enguera',
	'ES46119' => 'Ènova, l',
	'ES46120' => 'Estivella',
	'ES46121' => 'Estubeny',
	'ES46122' => 'Faura',
	'ES46123' => 'Favara',
	'ES46124' => 'Fontanars dels Alforins',
	'ES46125' => 'Fortaleny',
	'ES46127' => 'Font dEn Carròs, la',
	'ES46128' => 'Font de la Figuera, la',
	'ES46129' => 'Fuenterrobles',
	'ES46130' => 'Gavarda',
	'ES46132' => 'Genovés, el',
	'ES46133' => 'Gestalgar',
	'ES46134' => 'Gilet',
	'ES46136' => 'Godelleta',
	'ES46137' => 'Granja de la Costera, la',
	'ES46138' => 'Guadasséquies',
	'ES46140' => 'Guardamar de la Safor',
	'ES46141' => 'Higueruelas',
	'ES46142' => 'Jalance',
	'ES46144' => 'Jarafuel',
	'ES46146' => 'Xeresa',
	'ES46148' => 'Loriguilla',
	'ES46149' => 'Losa del Obispo',
	'ES46150' => 'Llutxent',
	'ES46151' => 'Llocnou dEn Fenollet',
	'ES46152' => 'Llocnou de la Corona',
	'ES46153' => 'Llocnou de Sant Jeroni',
	'ES46154' => 'Llanera de Ranes',
	'ES46155' => 'Llaurí',
	'ES46156' => 'Llombai',
	'ES46157' => 'Llosa de Ranes, la',
	'ES46158' => 'Macastre',
	'ES46160' => 'Manuel',
	'ES46161' => 'Marines',
	'ES46162' => 'Massalavés',
	'ES46163' => 'Massalfassar',
	'ES46167' => 'Millares',
	'ES46168' => 'Miramar',
	'ES46170' => 'Moixent',
	'ES46173' => 'Montaverner',
	'ES46174' => 'Montesa',
	'ES46175' => 'Montichelvo',
	'ES46176' => 'Montroy',
	'ES46179' => 'Navarrés',
	'ES46180' => 'Novetlè',
	'ES46182' => 'Olocau',
	'ES46185' => 'Otos',
	'ES46187' => 'Palma de Gandía',
	'ES46188' => 'Palmera',
	'ES46189' => 'Palomar, el',
	'ES46191' => 'Pedralba',
	'ES46192' => 'Petrés',
	'ES46195' => 'Piles',
	'ES46196' => 'Pinet',
	'ES46197' => 'Polinyà de Xúquer',
	'ES46198' => 'Potries',
	'ES46200' => 'Pobla del Duc, la',
	'ES46201' => 'Puebla de San Miguel',
	'ES46203' => 'Pobla Llarga, la',
	'ES46206' => 'Quesa',
	'ES46208' => 'Rafelcofer',
	'ES46209' => 'Rafelguaraf',
	'ES46210' => 'Ráfol de Salem',
	'ES46211' => 'Real de Gandia, el',
	'ES46212' => 'Real',
	'ES46215' => 'Riola',
	'ES46217' => 'Rotglà i Corberà',
	'ES46218' => 'Rótova',
	'ES46219' => 'Rugat',
	'ES46221' => 'Salem',
	'ES46222' => 'Sant Joanet',
	'ES46224' => 'Segart',
	'ES46225' => 'Sellent',
	'ES46226' => 'Sempere',
	'ES46227' => 'Senyera',
	'ES46228' => 'Serra',
	'ES46229' => 'Siete Aguas',
	'ES46231' => 'Simat de la Valldigna',
	'ES46232' => 'Sinarcas',
	'ES46233' => 'Sollana',
	'ES46234' => 'Sot de Chera',
	'ES46236' => 'Sumacàrcer',
	'ES46239' => 'Teresa de Cofrentes',
	'ES46240' => 'Terrateig',
	'ES46241' => 'Titaguas',
	'ES46242' => 'Torrebaja',
	'ES46243' => 'Torrella',
	'ES46245' => 'Torres Torres',
	'ES46246' => 'Tous',
	'ES46247' => 'Tuéjar',
	'ES46251' => 'Vallada',
	'ES46252' => 'Vallanca',
	'ES46253' => 'Vallés',
	'ES46254' => 'Venta del Moro',
	'ES46255' => 'Villalonga',
	'ES46258' => 'Villar del Arzobispo',
	'ES46259' => 'Villargordo del Cabriel',
	'ES46260' => 'Vinalesa',
	'ES46261' => 'Yátova',
	'ES46262' => 'Yesa, La',
	'ES46263' => 'Zarra',
	'ES46902' => 'Gátova',
	'ES46904' => 'Benicull de Xúquer',
	'ES47001' => 'Adalia',
	'ES47002' => 'Aguasal',
	'ES47003' => 'Aguilar de Campos',
	'ES47004' => 'Alaejos',
	'ES47005' => 'Alcazarén',
	'ES47006' => 'Aldea de San Miguel',
	'ES47008' => 'Almenara de Adaja',
	'ES47009' => 'Amusquillo',
	'ES47011' => 'Ataquines',
	'ES47012' => 'Bahabón',
	'ES47013' => 'Barcial de la Loma',
	'ES47014' => 'Barruelo del Valle',
	'ES47015' => 'Becilla de Valderaduey',
	'ES47016' => 'Benafarces',
	'ES47017' => 'Bercero',
	'ES47018' => 'Berceruelo',
	'ES47019' => 'Berrueces',
	'ES47020' => 'Bobadilla del Campo',
	'ES47021' => 'Bocigas',
	'ES47022' => 'Bocos de Duero',
	'ES47023' => 'Boecillo',
	'ES47024' => 'Bolaños de Campos',
	'ES47025' => 'Brahojos de Medina',
	'ES47026' => 'Bustillo de Chaves',
	'ES47027' => 'Cabezón de Pisuerga',
	'ES47028' => 'Cabezón de Valderaduey',
	'ES47029' => 'Cabreros del Monte',
	'ES47030' => 'Campaspero',
	'ES47031' => 'Campillo, El',
	'ES47032' => 'Camporredondo',
	'ES47033' => 'Canalejas de Peñafiel',
	'ES47034' => 'Canillas de Esgueva',
	'ES47035' => 'Carpio',
	'ES47036' => 'Casasola de Arión',
	'ES47037' => 'Castrejón de Trabancos',
	'ES47038' => 'Castrillo de Duero',
	'ES47039' => 'Castrillo-Tejeriego',
	'ES47040' => 'Castrobol',
	'ES47041' => 'Castrodeza',
	'ES47042' => 'Castromembibre',
	'ES47043' => 'Castromonte',
	'ES47044' => 'Castronuevo de Esgueva',
	'ES47045' => 'Castronuño',
	'ES47046' => 'Castroponce',
	'ES47047' => 'Castroverde de Cerrato',
	'ES47048' => 'Ceinos de Campos',
	'ES47049' => 'Cervillego de la Cruz',
	'ES47051' => 'Ciguñuela',
	'ES47053' => 'Cogeces de Íscar',
	'ES47054' => 'Cogeces del Monte',
	'ES47055' => 'Corcos',
	'ES47056' => 'Corrales de Duero',
	'ES47057' => 'Cubillas de Santa Marta',
	'ES47058' => 'Cuenca de Campos',
	'ES47059' => 'Curiel de Duero',
	'ES47060' => 'Encinas de Esgueva',
	'ES47061' => 'Esguevillas de Esgueva',
	'ES47062' => 'Fombellida',
	'ES47063' => 'Fompedraza',
	'ES47064' => 'Fontihoyuelo',
	'ES47065' => 'Fresno el Viejo',
	'ES47066' => 'Fuensaldaña',
	'ES47067' => 'Fuente el Sol',
	'ES47068' => 'Fuente-Olmedo',
	'ES47069' => 'Gallegos de Hornija',
	'ES47070' => 'Gatón de Campos',
	'ES47071' => 'Geria',
	'ES47073' => 'Herrín de Campos',
	'ES47074' => 'Hornillos de Eresma',
	'ES47077' => 'Langayo',
	'ES47078' => 'Lomoviejo',
	'ES47079' => 'Llano de Olmedo',
	'ES47080' => 'Manzanillo',
	'ES47081' => 'Marzales',
	'ES47082' => 'Matapozuelos',
	'ES47083' => 'Matilla de los Caños',
	'ES47084' => 'Mayorga',
	'ES47086' => 'Medina de Rioseco',
	'ES47087' => 'Megeces',
	'ES47088' => 'Melgar de Abajo',
	'ES47089' => 'Melgar de Arriba',
	'ES47090' => 'Mojados',
	'ES47091' => 'Monasterio de Vega',
	'ES47092' => 'Montealegre de Campos',
	'ES47093' => 'Montemayor de Pililla',
	'ES47094' => 'Moral de la Reina',
	'ES47095' => 'Moraleja de las Panaderas',
	'ES47096' => 'Morales de Campos',
	'ES47097' => 'Mota del Marqués',
	'ES47098' => 'Mucientes',
	'ES47099' => 'Mudarra, La',
	'ES47100' => 'Muriel',
	'ES47101' => 'Nava del Rey',
	'ES47102' => 'Nueva Villa de las Torres',
	'ES47103' => 'Olivares de Duero',
	'ES47104' => 'Olmedo',
	'ES47105' => 'Olmos de Esgueva',
	'ES47106' => 'Olmos de Peñafiel',
	'ES47109' => 'Palazuelo de Vedija',
	'ES47110' => 'Parrilla, La',
	'ES47111' => 'Pedraja de Portillo, La',
	'ES47112' => 'Pedrajas de San Esteban',
	'ES47113' => 'Pedrosa del Rey',
	'ES47115' => 'Peñaflor de Hornija',
	'ES47116' => 'Pesquera de Duero',
	'ES47117' => 'Piña de Esgueva',
	'ES47118' => 'Piñel de Abajo',
	'ES47119' => 'Piñel de Arriba',
	'ES47121' => 'Pollos',
	'ES47122' => 'Portillo',
	'ES47123' => 'Pozal de Gallinas',
	'ES47124' => 'Pozaldez',
	'ES47125' => 'Pozuelo de la Orden',
	'ES47126' => 'Puras',
	'ES47127' => 'Quintanilla de Arriba',
	'ES47128' => 'Quintanilla del Molar',
	'ES47129' => 'Quintanilla de Onésimo',
	'ES47130' => 'Quintanilla de Trigueros',
	'ES47131' => 'Rábano',
	'ES47132' => 'Ramiro',
	'ES47133' => 'Renedo de Esgueva',
	'ES47134' => 'Roales de Campos',
	'ES47135' => 'Robladillo',
	'ES47137' => 'Roturas',
	'ES47138' => 'Rubí de Bracamonte',
	'ES47139' => 'Rueda',
	'ES47140' => 'Saelices de Mayorga',
	'ES47141' => 'Salvador de Zapardiel',
	'ES47142' => 'San Cebrián de Mazote',
	'ES47143' => 'San Llorente',
	'ES47144' => 'San Martín de Valvení',
	'ES47145' => 'San Miguel del Arroyo',
	'ES47146' => 'San Miguel del Pino',
	'ES47147' => 'San Pablo de la Moraleja',
	'ES47148' => 'San Pedro de Latarce',
	'ES47149' => 'San Pelayo',
	'ES47150' => 'San Román de Hornija',
	'ES47151' => 'San Salvador',
	'ES47152' => 'Santa Eufemia del Arroyo',
	'ES47153' => 'Santervás de Campos',
	'ES47154' => 'Santibáñez de Valcorba',
	'ES47155' => 'Santovenia de Pisuerga',
	'ES47156' => 'San Vicente del Palacio',
	'ES47157' => 'Sardón de Duero',
	'ES47158' => 'Seca, La',
	'ES47159' => 'Serrada',
	'ES47160' => 'Siete Iglesias de Trabancos',
	'ES47162' => 'Tamariz de Campos',
	'ES47163' => 'Tiedra',
	'ES47164' => 'Tordehumos',
	'ES47166' => 'Torrecilla de la Abadesa',
	'ES47167' => 'Torrecilla de la Orden',
	'ES47168' => 'Torrecilla de la Torre',
	'ES47169' => 'Torre de Esgueva',
	'ES47170' => 'Torre de Peñafiel',
	'ES47171' => 'Torrelobatón',
	'ES47172' => 'Torrescárcela',
	'ES47173' => 'Traspinedo',
	'ES47174' => 'Trigueros del Valle',
	'ES47176' => 'Unión de Campos, La',
	'ES47177' => 'Urones de Castroponce',
	'ES47178' => 'Urueña',
	'ES47179' => 'Valbuena de Duero',
	'ES47180' => 'Valdearcos de la Vega',
	'ES47181' => 'Valdenebro de los Valles',
	'ES47182' => 'Valdestillas',
	'ES47183' => 'Valdunquillo',
	'ES47184' => 'Valoria la Buena',
	'ES47185' => 'Valverde de Campos',
	'ES47187' => 'Vega de Ruiponce',
	'ES47188' => 'Vega de Valdetronco',
	'ES47189' => 'Velascálvaro',
	'ES47190' => 'Velilla',
	'ES47191' => 'Velliza',
	'ES47192' => 'Ventosa de la Cuesta',
	'ES47193' => 'Viana de Cega',
	'ES47194' => 'Viloria',
	'ES47195' => 'Villabáñez',
	'ES47196' => 'Villabaruz de Campos',
	'ES47197' => 'Villabrágima',
	'ES47198' => 'Villacarralón',
	'ES47199' => 'Villacid de Campos',
	'ES47200' => 'Villaco',
	'ES47203' => 'Villafrades de Campos',
	'ES47204' => 'Villafranca de Duero',
	'ES47205' => 'Villafrechós',
	'ES47206' => 'Villafuerte',
	'ES47207' => 'Villagarcía de Campos',
	'ES47208' => 'Villagómez la Nueva',
	'ES47209' => 'Villalán de Campos',
	'ES47210' => 'Villalar de los Comuneros',
	'ES47211' => 'Villalba de la Loma',
	'ES47212' => 'Villalba de los Alcores',
	'ES47213' => 'Villalbarba',
	'ES47214' => 'Villalón de Campos',
	'ES47215' => 'Villamuriel de Campos',
	'ES47216' => 'Villán de Tordesillas',
	'ES47217' => 'Villanubla',
	'ES47218' => 'Villanueva de Duero',
	'ES47219' => 'Villanueva de la Condesa',
	'ES47220' => 'Villanueva de los Caballeros',
	'ES47221' => 'Villanueva de los Infantes',
	'ES47222' => 'Villanueva de San Mancio',
	'ES47223' => 'Villardefrades',
	'ES47224' => 'Villarmentero de Esgueva',
	'ES47225' => 'Villasexmir',
	'ES47226' => 'Villavaquerín',
	'ES47227' => 'Villavellid',
	'ES47228' => 'Villaverde de Medina',
	'ES47229' => 'Villavicencio de los Caballeros,',
	'ES47230' => 'Wamba',
	'ES47232' => 'Zarza, La',
	'ES48004' => 'Amoroto',
	'ES48005' => 'Arakaldo',
	'ES48006' => 'Arantzazu',
	'ES48007' => 'Munitibar-Arbatzegi Gerrikaitz',
	'ES48008' => 'Artzentales',
	'ES48009' => 'Arrankudiaga',
	'ES48010' => 'Arrieta',
	'ES48012' => 'Bakio',
	'ES48014' => 'Barrika',
	'ES48018' => 'Berriatua',
	'ES48019' => 'Berriz',
	'ES48021' => 'Busturia',
	'ES48022' => 'Valle de Carranza',
	'ES48023' => 'Artea',
	'ES48024' => 'Zeanuri',
	'ES48025' => 'Zeberio',
	'ES48026' => 'Dima',
	'ES48028' => 'Ea',
	'ES48030' => 'Etxebarria',
	'ES48031' => 'Elantxobe',
	'ES48033' => 'Ereño',
	'ES48035' => 'Fruiz',
	'ES48037' => 'Galdames',
	'ES48038' => 'Gamiz-Fika',
	'ES48039' => 'Garai',
	'ES48040' => 'Gatika',
	'ES48041' => 'Gautegiz Arteaga',
	'ES48042' => 'Gordexola',
	'ES48047' => 'Gizaburuaga',
	'ES48048' => 'Ibarrangelu',
	'ES48049' => 'Ispaster',
	'ES48050' => 'Izurtza',
	'ES48051' => 'Lanestosa',
	'ES48052' => 'Larrabetzu',
	'ES48053' => 'Laukiz',
	'ES48055' => 'Lemoa',
	'ES48056' => 'Lemoiz',
	'ES48058' => 'Mallabia',
	'ES48059' => 'Mañaria',
	'ES48061' => 'Maruri-Jatabe',
	'ES48062' => 'Mendata',
	'ES48063' => 'Mendexa',
	'ES48064' => 'Meñaka',
	'ES48065' => 'Ugao-Miraballes',
	'ES48066' => 'Morga',
	'ES48067' => 'Muxika',
	'ES48068' => 'Mundaka',
	'ES48070' => 'Aulesti',
	'ES48072' => 'Otxandio',
	'ES48074' => 'Orduña',
	'ES48075' => 'Orozko',
	'ES48076' => 'Sukarrieta',
	'ES48077' => 'Plentzia',
	'ES48079' => 'Errigoiti',
	'ES48081' => 'Lezama',
	'ES48086' => 'Sopuerta',
	'ES48087' => 'Trucios-Turtzioz',
	'ES48088' => 'Ubide',
	'ES48089' => 'Urduliz',
	'ES48091' => 'Atxondo',
	'ES48092' => 'Bedia',
	'ES48093' => 'Areatza',
	'ES48094' => 'Igorre',
	'ES48095' => 'Zaldibar',
	'ES48097' => 'Zaratamo',
	'ES48903' => 'Loiu',
	'ES48904' => 'Sondika',
	'ES48905' => 'Zamudio',
	'ES48906' => 'Forua',
	'ES48907' => 'Kortezubi',
	'ES48908' => 'Murueta',
	'ES48909' => 'Nabarniz',
	'ES48910' => 'Iurreta',
	'ES48911' => 'Ajangiz',
	'ES48912' => 'Alonsotegi',
	'ES48913' => 'Zierbena',
	'ES48914' => 'Arratzu',
	'ES48915' => 'Ziortza-Bolibar',
	'ES49002' => 'Abezames',
	'ES49003' => 'Alcañices',
	'ES49004' => 'Alcubilla de Nogales',
	'ES49005' => 'Alfaraz de Sayago',
	'ES49006' => 'Algodre',
	'ES49007' => 'Almaraz de Duero',
	'ES49008' => 'Almeida de Sayago',
	'ES49009' => 'Andavías',
	'ES49010' => 'Arcenillas',
	'ES49011' => 'Arcos de la Polvorosa',
	'ES49012' => 'Argañín',
	'ES49013' => 'Argujillo',
	'ES49014' => 'Arquillinos',
	'ES49015' => 'Arrabalde',
	'ES49016' => 'Aspariegos',
	'ES49017' => 'Asturianos',
	'ES49018' => 'Ayoó de Vidriales',
	'ES49019' => 'Barcial del Barco',
	'ES49020' => 'Belver de los Montes',
	'ES49022' => 'Benegiles',
	'ES49023' => 'Bermillo de Sayago',
	'ES49024' => 'Bóveda de Toro, La',
	'ES49025' => 'Bretó',
	'ES49026' => 'Bretocino',
	'ES49027' => 'Brime de Sog',
	'ES49028' => 'Brime de Urz',
	'ES49029' => 'Burganes de Valverde',
	'ES49030' => 'Bustillo del Oro',
	'ES49031' => 'Cabañas de Sayago',
	'ES49032' => 'Calzadilla de Tera',
	'ES49033' => 'Camarzana de Tera',
	'ES49034' => 'Cañizal',
	'ES49035' => 'Cañizo',
	'ES49036' => 'Carbajales de Alba',
	'ES49037' => 'Carbellino',
	'ES49038' => 'Casaseca de Campeán',
	'ES49039' => 'Casaseca de las Chanas',
	'ES49040' => 'Castrillo de la Guareña',
	'ES49041' => 'Castrogonzalo',
	'ES49042' => 'Castronuevo',
	'ES49043' => 'Castroverde de Campos',
	'ES49044' => 'Cazurra',
	'ES49046' => 'Cerecinos de Campos',
	'ES49047' => 'Cerecinos del Carrizal',
	'ES49048' => 'Cernadilla',
	'ES49050' => 'Cobreros',
	'ES49052' => 'Coomonte',
	'ES49053' => 'Coreses',
	'ES49054' => 'Corrales del Vino',
	'ES49055' => 'Cotanes del Monte',
	'ES49056' => 'Cubillos',
	'ES49057' => 'Cubo de Benavente',
	'ES49058' => 'Cubo de Tierra del Vino, El',
	'ES49059' => 'Cuelgamures',
	'ES49061' => 'Entrala',
	'ES49062' => 'Espadañedo',
	'ES49063' => 'Faramontanos de Tábara',
	'ES49064' => 'Fariza',
	'ES49065' => 'Fermoselle',
	'ES49066' => 'Ferreras de Abajo',
	'ES49067' => 'Ferreras de Arriba',
	'ES49068' => 'Ferreruela',
	'ES49069' => 'Figueruela de Arriba',
	'ES49071' => 'Fonfría',
	'ES49075' => 'Fresno de la Polvorosa',
	'ES49076' => 'Fresno de la Ribera',
	'ES49077' => 'Fresno de Sayago',
	'ES49078' => 'Friera de Valverde',
	'ES49079' => 'Fuente Encalada',
	'ES49080' => 'Fuentelapeña',
	'ES49081' => 'Fuentesaúco',
	'ES49082' => 'Fuentes de Ropel',
	'ES49083' => 'Fuentesecas',
	'ES49084' => 'Fuentespreadas',
	'ES49085' => 'Galende',
	'ES49086' => 'Gallegos del Pan',
	'ES49087' => 'Gallegos del Río',
	'ES49088' => 'Gamones',
	'ES49090' => 'Gema',
	'ES49091' => 'Granja de Moreruela',
	'ES49092' => 'Granucillo',
	'ES49093' => 'Guarrate',
	'ES49094' => 'Hermisende',
	'ES49095' => 'Hiniesta, La',
	'ES49096' => 'Jambrina',
	'ES49097' => 'Justel',
	'ES49098' => 'Losacino',
	'ES49099' => 'Losacio',
	'ES49100' => 'Lubián',
	'ES49101' => 'Luelmo',
	'ES49102' => 'Maderal, El',
	'ES49103' => 'Madridanos',
	'ES49104' => 'Mahide',
	'ES49105' => 'Maire de Castroponce',
	'ES49107' => 'Malva',
	'ES49108' => 'Manganeses de la Lampreana',
	'ES49109' => 'Manganeses de la Polvorosa',
	'ES49110' => 'Manzanal de Arriba',
	'ES49111' => 'Manzanal del Barco',
	'ES49112' => 'Manzanal de los Infantes',
	'ES49113' => 'Matilla de Arzón',
	'ES49114' => 'Matilla la Seca',
	'ES49115' => 'Mayalde',
	'ES49116' => 'Melgar de Tera',
	'ES49117' => 'Micereces de Tera',
	'ES49118' => 'Milles de la Polvorosa',
	'ES49119' => 'Molacillos',
	'ES49120' => 'Molezuelas de la Carballeda',
	'ES49121' => 'Mombuey',
	'ES49122' => 'Monfarracinos',
	'ES49123' => 'Montamarta',
	'ES49124' => 'Moral de Sayago',
	'ES49125' => 'Moraleja del Vino',
	'ES49126' => 'Moraleja de Sayago',
	'ES49127' => 'Morales del Vino',
	'ES49128' => 'Morales de Rey',
	'ES49129' => 'Morales de Toro',
	'ES49130' => 'Morales de Valverde',
	'ES49131' => 'Moralina',
	'ES49132' => 'Moreruela de los Infanzones',
	'ES49133' => 'Moreruela de Tábara',
	'ES49134' => 'Muelas de los Caballeros',
	'ES49135' => 'Muelas del Pan',
	'ES49136' => 'Muga de Sayago',
	'ES49137' => 'Navianos de Valverde',
	'ES49138' => 'Olmillos de Castro',
	'ES49139' => 'Otero de Bodas',
	'ES49141' => 'Pajares de la Lampreana',
	'ES49142' => 'Palacios del Pan',
	'ES49143' => 'Palacios de Sanabria',
	'ES49145' => 'Pedralba de la Pradería',
	'ES49146' => 'Pego, El',
	'ES49147' => 'Peleagonzalo',
	'ES49148' => 'Peleas de Abajo',
	'ES49149' => 'Peñausende',
	'ES49150' => 'Peque',
	'ES49151' => 'Perdigón, El',
	'ES49152' => 'Pereruela',
	'ES49153' => 'Perilla de Castro',
	'ES49154' => 'Pías',
	'ES49155' => 'Piedrahita de Castro',
	'ES49156' => 'Pinilla de Toro',
	'ES49157' => 'Pino del Oro',
	'ES49158' => 'Piñero, El',
	'ES49159' => 'Pobladura del Valle',
	'ES49160' => 'Pobladura de Valderaduey',
	'ES49162' => 'Porto',
	'ES49163' => 'Pozoantiguo',
	'ES49164' => 'Pozuelo de Tábara',
	'ES49165' => 'Prado',
	'ES49166' => 'Puebla de Sanabria',
	'ES49167' => 'Pueblica de Valverde',
	'ES49168' => 'Quintanilla del Monte',
	'ES49169' => 'Quintanilla del Olmo',
	'ES49170' => 'Quintanilla de Urz',
	'ES49171' => 'Quiruelas de Vidriales',
	'ES49172' => 'Rabanales',
	'ES49173' => 'Rábano de Aliste',
	'ES49174' => 'Requejo',
	'ES49175' => 'Revellinos',
	'ES49176' => 'Riofrío de Aliste',
	'ES49177' => 'Rionegro del Puente',
	'ES49178' => 'Roales',
	'ES49179' => 'Robleda-Cervantes',
	'ES49180' => 'Roelos de Sayago',
	'ES49181' => 'Rosinos de la Requejada',
	'ES49183' => 'Salce',
	'ES49184' => 'Samir de los Caños',
	'ES49185' => 'San Agustín del Pozo',
	'ES49186' => 'San Cebrián de Castro',
	'ES49187' => 'San Cristóbal de Entreviñas',
	'ES49188' => 'San Esteban del Molar',
	'ES49189' => 'San Justo',
	'ES49190' => 'San Martín de Valderaduey',
	'ES49191' => 'San Miguel de la Ribera',
	'ES49192' => 'San Miguel del Valle',
	'ES49193' => 'San Pedro de Ceque',
	'ES49194' => 'San Pedro de la Nave-Almendra',
	'ES49197' => 'Santa Clara de Avedillo',
	'ES49199' => 'Santa Colomba de las Monjas',
	'ES49200' => 'Santa Cristina de la Polvorosa',
	'ES49201' => 'Santa Croya de Tera',
	'ES49202' => 'Santa Eufemia del Barco',
	'ES49203' => 'Santa María de la Vega',
	'ES49204' => 'Santa María de Valverde',
	'ES49205' => 'Santibáñez de Tera',
	'ES49206' => 'Santibáñez de Vidriales',
	'ES49207' => 'Santovenia',
	'ES49208' => 'San Vicente de la Cabeza',
	'ES49209' => 'San Vitero',
	'ES49210' => 'Sanzoles',
	'ES49214' => 'Tábara',
	'ES49216' => 'Tapioles',
	'ES49220' => 'Torre del Valle, La',
	'ES49221' => 'Torregamones',
	'ES49222' => 'Torres del Carrizal',
	'ES49223' => 'Trabazos',
	'ES49224' => 'Trefacio',
	'ES49225' => 'Uña de Quintana',
	'ES49226' => 'Vadillo de la Guareña',
	'ES49227' => 'Valcabado',
	'ES49228' => 'Valdefinjas',
	'ES49229' => 'Valdescorriel',
	'ES49230' => 'Vallesa de la Guareña',
	'ES49231' => 'Vega de Tera',
	'ES49232' => 'Vega de Villalobos',
	'ES49233' => 'Vegalatrave',
	'ES49234' => 'Venialbo',
	'ES49235' => 'Vezdemarbán',
	'ES49236' => 'Vidayanes',
	'ES49237' => 'Videmala',
	'ES49238' => 'Villabrázaro',
	'ES49239' => 'Villabuena del Puente',
	'ES49240' => 'Villadepera',
	'ES49241' => 'Villaescusa',
	'ES49242' => 'Villafáfila',
	'ES49243' => 'Villaferrueña',
	'ES49244' => 'Villageriz',
	'ES49245' => 'Villalazán',
	'ES49246' => 'Villalba de la Lampreana',
	'ES49247' => 'Villalcampo',
	'ES49248' => 'Villalobos',
	'ES49249' => 'Villalonso',
	'ES49250' => 'Villalpando',
	'ES49251' => 'Villalube',
	'ES49252' => 'Villamayor de Campos',
	'ES49255' => 'Villamor de los Escuderos',
	'ES49256' => 'Villanázar',
	'ES49257' => 'Villanueva de Azoague',
	'ES49258' => 'Villanueva de Campeán',
	'ES49259' => 'Villanueva de las Peras',
	'ES49260' => 'Villanueva del Campo',
	'ES49261' => 'Villaralbo',
	'ES49262' => 'Villardeciervos',
	'ES49263' => 'Villar de Fallaves',
	'ES49264' => 'Villar del Buey',
	'ES49265' => 'Villardiegua de la Ribera',
	'ES49266' => 'Villárdiga',
	'ES49267' => 'Villardondiego',
	'ES49268' => 'Villarrín de Campos',
	'ES49269' => 'Villaseco del Pan',
	'ES49270' => 'Villavendimio',
	'ES49271' => 'Villaveza del Agua',
	'ES49272' => 'Villaveza de Valverde',
	'ES49273' => 'Viñas',
	'ES50001' => 'Abanto',
	'ES50002' => 'Acered',
	'ES50003' => 'Agón',
	'ES50004' => 'Aguarón',
	'ES50005' => 'Aguilón',
	'ES50006' => 'Ainzón',
	'ES50007' => 'Aladrén',
	'ES50009' => 'Alarba',
	'ES50010' => 'Alberite de San Juan',
	'ES50011' => 'Albeta',
	'ES50012' => 'Alborge',
	'ES50013' => 'Alcalá de Ebro',
	'ES50014' => 'Alcalá de Moncayo',
	'ES50015' => 'Alconchel de Ariza',
	'ES50016' => 'Aldehuela de Liestos',
	'ES50017' => 'Alfajarín',
	'ES50018' => 'Alfamén',
	'ES50019' => 'Alforque',
	'ES50020' => 'Alhama de Aragón',
	'ES50021' => 'Almochuel',
	'ES50022' => 'Almolda, La',
	'ES50023' => 'Almonacid de la Cuba',
	'ES50024' => 'Almonacid de la Sierra',
	'ES50026' => 'Alpartir',
	'ES50027' => 'Ambel',
	'ES50028' => 'Anento',
	'ES50029' => 'Aniñón',
	'ES50030' => 'Añón de Moncayo',
	'ES50031' => 'Aranda de Moncayo',
	'ES50032' => 'Arándiga',
	'ES50033' => 'Ardisa',
	'ES50034' => 'Ariza',
	'ES50035' => 'Artieda',
	'ES50036' => 'Asín',
	'ES50037' => 'Atea',
	'ES50038' => 'Ateca',
	'ES50039' => 'Azuara',
	'ES50040' => 'Badules',
	'ES50041' => 'Bagüés',
	'ES50042' => 'Balconchán',
	'ES50043' => 'Bárboles',
	'ES50044' => 'Bardallur',
	'ES50045' => 'Belchite',
	'ES50046' => 'Belmonte de Gracián',
	'ES50047' => 'Berdejo',
	'ES50048' => 'Berrueco',
	'ES50050' => 'Bijuesca',
	'ES50051' => 'Biota',
	'ES50052' => 'Bisimbre',
	'ES50053' => 'Boquiñeni',
	'ES50054' => 'Bordalba',
	'ES50055' => 'Borja',
	'ES50056' => 'Botorrita',
	'ES50057' => 'Brea de Aragón',
	'ES50058' => 'Bubierca',
	'ES50059' => 'Bujaraloz',
	'ES50060' => 'Bulbuente',
	'ES50061' => 'Bureta',
	'ES50062' => 'Burgo de Ebro, El',
	'ES50063' => 'Buste, El',
	'ES50064' => 'Cabañas de Ebro',
	'ES50065' => 'Cabolafuente',
	'ES50066' => 'Cadrete',
	'ES50068' => 'Calatorao',
	'ES50069' => 'Calcena',
	'ES50070' => 'Calmarza',
	'ES50071' => 'Campillo de Aragón',
	'ES50072' => 'Carenas',
	'ES50073' => 'Cariñena',
	'ES50075' => 'Castejón de Alarba',
	'ES50076' => 'Castejón de las Armas',
	'ES50077' => 'Castejón de Valdejasa',
	'ES50078' => 'Castiliscar',
	'ES50079' => 'Cervera de la Cañada',
	'ES50080' => 'Cerveruela',
	'ES50081' => 'Cetina',
	'ES50082' => 'Cimballa',
	'ES50083' => 'Cinco Olivas',
	'ES50084' => 'Clarés de Ribota',
	'ES50085' => 'Codo',
	'ES50086' => 'Codos',
	'ES50087' => 'Contamina',
	'ES50088' => 'Cosuenda',
	'ES50090' => 'Cubel',
	'ES50091' => 'Cuerlas, Las',
	'ES50092' => 'Chiprana',
	'ES50093' => 'Chodes',
	'ES50094' => 'Daroca',
	'ES50096' => 'Embid de Ariza',
	'ES50098' => 'Encinacorba',
	'ES50099' => 'Épila',
	'ES50100' => 'Erla',
	'ES50101' => 'Escatrón',
	'ES50102' => 'Fabara',
	'ES50104' => 'Farlete',
	'ES50105' => 'Fayón',
	'ES50106' => 'Fayos, Los',
	'ES50107' => 'Figueruelas',
	'ES50108' => 'Fombuena',
	'ES50109' => 'Frago, El',
	'ES50110' => 'Frasno, El',
	'ES50111' => 'Fréscano',
	'ES50113' => 'Fuendejalón',
	'ES50114' => 'Fuendetodos',
	'ES50115' => 'Fuentes de Ebro',
	'ES50116' => 'Fuentes de Jiloca',
	'ES50117' => 'Gallocanta',
	'ES50118' => 'Gallur',
	'ES50119' => 'Gelsa',
	'ES50120' => 'Godojos',
	'ES50121' => 'Gotor',
	'ES50122' => 'Grisel',
	'ES50123' => 'Grisén',
	'ES50124' => 'Herrera de los Navarros',
	'ES50125' => 'Ibdes',
	'ES50126' => 'Illueca',
	'ES50128' => 'Isuerre',
	'ES50129' => 'Jaraba',
	'ES50130' => 'Jarque de Moncayo',
	'ES50131' => 'Jaulín',
	'ES50132' => 'Joyosa, La',
	'ES50133' => 'Lagata',
	'ES50134' => 'Langa del Castillo',
	'ES50135' => 'Layana',
	'ES50136' => 'Lécera',
	'ES50137' => 'Leciñena',
	'ES50138' => 'Lechón',
	'ES50139' => 'Letux',
	'ES50140' => 'Litago',
	'ES50141' => 'Lituénigo',
	'ES50142' => 'Lobera de Onsella',
	'ES50143' => 'Longares',
	'ES50144' => 'Longás',
	'ES50146' => 'Lucena de Jalón',
	'ES50147' => 'Luceni',
	'ES50148' => 'Luesia',
	'ES50149' => 'Luesma',
	'ES50150' => 'Lumpiaque',
	'ES50151' => 'Luna',
	'ES50152' => 'Maella',
	'ES50153' => 'Magallón',
	'ES50154' => 'Mainar',
	'ES50155' => 'Malanquilla',
	'ES50156' => 'Maleján',
	'ES50157' => 'Malón',
	'ES50159' => 'Maluenda',
	'ES50160' => 'Mallén',
	'ES50161' => 'Manchones',
	'ES50162' => 'Mara',
	'ES50164' => 'Mediana de Aragón',
	'ES50165' => 'Mequinenza',
	'ES50166' => 'Mesones de Isuela',
	'ES50167' => 'Mezalocha',
	'ES50168' => 'Mianos',
	'ES50169' => 'Miedes de Aragón',
	'ES50170' => 'Monegrillo',
	'ES50171' => 'Moneva',
	'ES50172' => 'Monreal de Ariza',
	'ES50173' => 'Monterde',
	'ES50174' => 'Montón',
	'ES50175' => 'Morata de Jalón',
	'ES50176' => 'Morata de Jiloca',
	'ES50177' => 'Morés',
	'ES50178' => 'Moros',
	'ES50179' => 'Moyuela',
	'ES50180' => 'Mozota',
	'ES50181' => 'Muel',
	'ES50183' => 'Munébrega',
	'ES50184' => 'Murero',
	'ES50185' => 'Murillo de Gállego',
	'ES50186' => 'Navardún',
	'ES50187' => 'Nigüella',
	'ES50188' => 'Nombrevilla',
	'ES50189' => 'Nonaspe',
	'ES50190' => 'Novallas',
	'ES50191' => 'Novillas',
	'ES50192' => 'Nuévalos',
	'ES50193' => 'Nuez de Ebro',
	'ES50194' => 'Olvés',
	'ES50195' => 'Orcajo',
	'ES50196' => 'Orera',
	'ES50197' => 'Orés',
	'ES50198' => 'Oseja',
	'ES50199' => 'Osera de Ebro',
	'ES50200' => 'Paniza',
	'ES50201' => 'Paracuellos de Jiloca',
	'ES50202' => 'Paracuellos de la Ribera',
	'ES50203' => 'Pastriz',
	'ES50204' => 'Pedrola',
	'ES50205' => 'Pedrosas, Las',
	'ES50206' => 'Perdiguera',
	'ES50207' => 'Piedratajada',
	'ES50208' => 'Pina de Ebro',
	'ES50209' => 'Pinseque',
	'ES50210' => 'Pintanos, Los',
	'ES50211' => 'Plasencia de Jalón',
	'ES50212' => 'Pleitas',
	'ES50213' => 'Plenas',
	'ES50214' => 'Pomer',
	'ES50215' => 'Pozuel de Ariza',
	'ES50216' => 'Pozuelo de Aragón',
	'ES50217' => 'Pradilla de Ebro',
	'ES50218' => 'Puebla de Albortón',
	'ES50220' => 'Puendeluna',
	'ES50221' => 'Purujosa',
	'ES50222' => 'Quinto',
	'ES50223' => 'Remolinos',
	'ES50224' => 'Retascón',
	'ES50225' => 'Ricla',
	'ES50227' => 'Romanos',
	'ES50228' => 'Rueda de Jalón',
	'ES50229' => 'Ruesca',
	'ES50230' => 'Sádaba',
	'ES50231' => 'Salillas de Jalón',
	'ES50232' => 'Salvatierra de Esca',
	'ES50233' => 'Samper del Salz',
	'ES50234' => 'San Martín de la Virgen de Moncayo',
	'ES50235' => 'San Mateo de Gállego',
	'ES50236' => 'Santa Cruz de Grío',
	'ES50237' => 'Santa Cruz de Moncayo',
	'ES50238' => 'Santa Eulalia de Gállego',
	'ES50239' => 'Santed',
	'ES50240' => 'Sástago',
	'ES50241' => 'Sabiñán',
	'ES50242' => 'Sediles',
	'ES50243' => 'Sestrica',
	'ES50244' => 'Sierra de Luna',
	'ES50245' => 'Sigüés',
	'ES50246' => 'Sisamón',
	'ES50247' => 'Sobradiel',
	'ES50248' => 'Sos del Rey Católico',
	'ES50249' => 'Tabuenca',
	'ES50250' => 'Talamantes',
	'ES50253' => 'Terrer',
	'ES50254' => 'Tierga',
	'ES50255' => 'Tobed',
	'ES50256' => 'Torralba de los Frailes',
	'ES50257' => 'Torralba de Ribota',
	'ES50258' => 'Torralbilla',
	'ES50259' => 'Torrehermosa',
	'ES50260' => 'Torrelapaja',
	'ES50261' => 'Torrellas',
	'ES50262' => 'Torres de Berrellén',
	'ES50263' => 'Torrijo de la Cañada',
	'ES50264' => 'Tosos',
	'ES50265' => 'Trasmoz',
	'ES50266' => 'Trasobares',
	'ES50267' => 'Uncastillo',
	'ES50268' => 'Undués de Lerda',
	'ES50269' => 'Urrea de Jalón',
	'ES50270' => 'Urriés',
	'ES50271' => 'Used',
	'ES50273' => 'Valdehorna',
	'ES50274' => 'Val de San Martín',
	'ES50275' => 'Valmadrid',
	'ES50276' => 'Valpalmas',
	'ES50277' => 'Valtorres',
	'ES50278' => 'Velilla de Ebro',
	'ES50279' => 'Velilla de Jiloca',
	'ES50280' => 'Vera de Moncayo',
	'ES50281' => 'Vierlas',
	'ES50282' => 'Vilueña, La',
	'ES50283' => 'Villadoz',
	'ES50284' => 'Villafeliche',
	'ES50285' => 'Villafranca de Ebro',
	'ES50286' => 'Villalba de Perejil',
	'ES50287' => 'Villalengua',
	'ES50288' => 'Villanueva de Gállego',
	'ES50289' => 'Villanueva de Jiloca',
	'ES50290' => 'Villanueva de Huerva',
	'ES50291' => 'Villar de los Navarros',
	'ES50292' => 'Villarreal de Huerva',
	'ES50293' => 'Villarroya de la Sierra',
	'ES50294' => 'Villarroya del Campo',
	'ES50295' => 'Vistabella',
	'ES50296' => 'Zaida, La',
	'ES50901' => 'Biel',
	'ES50902' => 'Marracos',
	'ES50903' => 'Villamayor de Gállego',
];
