<?php

/**
 * List of cities for: Ecuador
 * Source: https://www.ecuadorencifras.gob.ec/documentos/web-inec/Poblacion_y_Demografia/CPV_aplicativos/modulo_cpv/dpa_.xls
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'EC01' => _x( 'AZUAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC02' => _x( 'BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC03' => _x( 'CAÑAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC04' => _x( 'CARCHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC05' => _x( 'COTOPAXI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC06' => _x( 'CHIMBORAZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC07' => _x( 'EL ORO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC08' => _x( 'ESMERALDAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC09' => _x( 'GUAYAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC10' => _x( 'IMBABURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC11' => _x( 'LOJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC12' => _x( 'LOS RIOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC13' => _x( 'MANABI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC14' => _x( 'MORONA SANTIAGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC15' => _x( 'NAPO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC16' => _x( 'PASTAZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC17' => _x( 'PICHINCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC18' => _x( 'TUNGURAHUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC19' => _x( 'ZAMORA CHINCHIPE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC20' => _x( 'GALAPAGOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC21' => _x( 'SUCUMBIOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC22' => _x( 'ORELLANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC23' => _x( 'SANTO DOMINGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC24' => _x( 'SANTA ELENA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	'EC90' => _x( 'ZONAS NO DELIMITADAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'EC01' => [
		'EC010150' => _x( 'CUENCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010151' => _x( 'BAÑOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010152' => _x( 'CUMBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010153' => _x( 'CHAUCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010154' => _x( 'CHECA (JIDCAY)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010155' => _x( 'CHIQUINTAD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010156' => _x( 'LLACAO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010157' => _x( 'MOLLETURO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010158' => _x( 'NULTI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010159' => _x( 'OCTAVIO CORDERO PALACIOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010160' => _x( 'PACCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010161' => _x( 'QUINGEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010162' => _x( 'RICAURTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010163' => _x( 'SAN JOAQUIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010164' => _x( 'SANTA ANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010165' => _x( 'SAYAUSI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010166' => _x( 'SIDCAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010167' => _x( 'SININCAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010168' => _x( 'TARQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010169' => _x( 'TURI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010170' => _x( 'VALLE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010171' => _x( 'VICTORIA DEL PORTETE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010250' => _x( 'GIRON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010251' => _x( 'ASUNCION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010252' => _x( 'SAN GERARDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010350' => _x( 'GUALACEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010352' => _x( 'DANIEL CORDOVA TORAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010353' => _x( 'JADAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010354' => _x( 'MARIANO MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010356' => _x( 'REMIGIO CRESPO TORAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010357' => _x( 'SAN JUAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010358' => _x( 'ZHIDMAD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010359' => _x( 'LUIS CORDERO VEGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010360' => _x( 'SIMON BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010450' => _x( 'NABON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010451' => _x( 'COCHAPATA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010452' => _x( 'EL PROGRESO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010453' => _x( 'LAS NIEVES (CHAYA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010550' => _x( 'PAUTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010552' => _x( 'BULAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010553' => _x( 'CHICAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010554' => _x( 'EL CABO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010556' => _x( 'GUARAINAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010559' => _x( 'SAN CRISTOBAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010561' => _x( 'TOMEBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010562' => _x( 'DUG-DUG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010650' => _x( 'PUCARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010652' => _x( 'SAN RAFAEL DE SHARUG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010750' => _x( 'SAN FERNANDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010751' => _x( 'CHUMBLIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010850' => _x( 'SANTA ISABEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010851' => _x( 'ABDON CALDERON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010853' => _x( 'ZHAGLLI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010950' => _x( 'SIGSIG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010951' => _x( 'CUCHIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010952' => _x( 'GIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010953' => _x( 'GUEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010954' => _x( 'LUDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010955' => _x( 'SAN BARTOLOME', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC010956' => _x( 'SAN JOSE DE RARANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011050' => _x( 'OÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011051' => _x( 'SUSUDEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011150' => _x( 'CHORDELEG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011151' => _x( 'PRINCIPAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011152' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011153' => _x( 'LUIS GALARZA ORELLANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011154' => _x( 'SAN MARTIN DE PUZHIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011250' => _x( 'EL PAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011253' => _x( 'SAN VICENTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011350' => _x( 'SEVILLA DE ORO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011351' => _x( 'AMALUZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011352' => _x( 'PALMAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011450' => _x( 'GUACHAPALA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011550' => _x( 'CAMILO PONCE ENRIQUEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC011551' => _x( 'EL CARMEN DE PIJILI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC02' => [
		'EC020150' => _x( 'GUARANDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020151' => _x( 'FACUNDO VELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020153' => _x( 'JULIO E. MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020155' => _x( 'SALINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020156' => _x( 'SAN LORENZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020157' => _x( 'SAN SIMON (YACOTO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020158' => _x( 'SANTAFE (SANTA FE)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020159' => _x( 'SIMIATUG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020160' => _x( 'SAN LUIS DE PAMBIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020250' => _x( 'CHILLANES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020251' => _x( 'SAN JOSE DEL TAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020350' => _x( 'SAN JOSE DE CHIMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020351' => _x( 'ASUNCION (ASANCOTO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020353' => _x( 'MAGDALENA (CHAPACOTO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020354' => _x( 'SAN SEBASTIAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020355' => _x( 'TELIMBELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020450' => _x( 'ECHEANDIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020550' => _x( 'SAN MIGUEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020551' => _x( 'BALSAPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020552' => _x( 'BILOVAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020553' => _x( 'REGULO DE MORA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020554' => _x( 'SAN PABLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020555' => _x( 'SANTIAGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020556' => _x( 'SAN VICENTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020650' => _x( 'CALUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC020750' => _x( 'LAS NAVES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC03' => [
		'EC030150' => _x( 'AZOGUES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030151' => _x( 'COJITAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030153' => _x( 'GUAPAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030154' => _x( 'JAVIER LOYOLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030155' => _x( 'LUIS CORDERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030156' => _x( 'PINDILIG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030157' => _x( 'RIVERA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030158' => _x( 'SAN MIGUEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030160' => _x( 'TADAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030250' => _x( 'BIBLIAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030251' => _x( 'NAZON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030252' => _x( 'SAN FRANCISCO DE SAGEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030253' => _x( 'TURUPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030254' => _x( 'JERUSALEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030350' => _x( 'CAÑAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030351' => _x( 'CHONTAMARCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030352' => _x( 'CHOROCOPTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030353' => _x( 'GENERAL MORALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030354' => _x( 'GUALLETURO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030355' => _x( 'HONORATO VASQUEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030356' => _x( 'INGAPIRCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030357' => _x( 'JUNCAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030358' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030361' => _x( 'ZHUD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030362' => _x( 'VENTURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030363' => _x( 'DUCUR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030450' => _x( 'LA TRONCAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030451' => _x( 'MANUEL J. CALLE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030452' => _x( 'PANCHO NEGRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030550' => _x( 'EL TAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030650' => _x( 'DELEG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030651' => _x( 'SOLANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC030750' => _x( 'SUSCAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC04' => [
		'EC040150' => _x( 'TULCAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040151' => _x( 'EL CARMELO (EL PUN)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040153' => _x( 'JULIO ANDRADE (OREJUELA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040154' => _x( 'MALDONADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040155' => _x( 'PIOTER', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040156' => _x( 'TOBAR DONOSO (LA BOCANA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040157' => _x( 'TUFIÑO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040158' => _x( 'URBINA (TAYA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040159' => _x( 'EL CHICAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040161' => _x( 'SANTA MARTHA DE CUBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040250' => _x( 'BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040251' => _x( 'GARCIA MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040252' => _x( 'LOS ANDES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040253' => _x( 'MONTE OLIVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040254' => _x( 'SAN VICENTE DE PUSIR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040255' => _x( 'SAN RAFAEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040350' => _x( 'EL ANGEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040351' => _x( 'EL GOALTAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040352' => _x( 'LA LIBERTAD (ALIZO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040353' => _x( 'SAN ISIDRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040450' => _x( 'MIRA (CHONTAHUASI)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040451' => _x( 'CONCEPCION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040452' => _x( 'JIJON Y CAAMAÑO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040453' => _x( 'JUAN MONTALVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040550' => _x( 'SAN GABRIEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040551' => _x( 'CRISTOBAL COLON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040552' => _x( 'CHITAN DE NAVARRETE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040553' => _x( 'FERNANDEZ SALVADOR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040554' => _x( 'LA PAZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040555' => _x( 'PIARTAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040650' => _x( 'HUACA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC040651' => _x( 'MARISCAL SUCRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC05' => [
		'EC050150' => _x( 'LATACUNGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050151' => _x( 'ALAQUES (ALAQUEZ)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050152' => _x( 'BELISARIO QUEVEDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050153' => _x( 'GUAITACAMA (GUAYTACAMA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050154' => _x( 'JOSEGUANGO BAJO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050156' => _x( 'MULALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050157' => _x( '11 DE NOVIEMBRE (ILINCHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050158' => _x( 'POALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050159' => _x( 'SAN JUAN DE PASTOCALLE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050161' => _x( 'TANICUCHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050162' => _x( 'TOACASO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050250' => _x( 'LA MANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050251' => _x( 'GUASAGANDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050252' => _x( 'PUCAYACU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050350' => _x( 'EL CORAZON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050351' => _x( 'MORASPUNGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050352' => _x( 'PINLLOPATA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050353' => _x( 'RAMON CAMPAÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050450' => _x( 'PUJILI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050451' => _x( 'ANGAMARCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050453' => _x( 'GUANGAJE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050455' => _x( 'LA VICTORIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050456' => _x( 'PILALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050457' => _x( 'TINGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050458' => _x( 'ZUMBAHUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050550' => _x( 'SAN MIGUEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050551' => _x( 'ANTONIO JOSE HOLGUIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050552' => _x( 'CUSUBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050553' => _x( 'MULALILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050554' => _x( 'MULLIQUINDIL (SANTA ANA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050555' => _x( 'PANSALEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050650' => _x( 'SAQUISILI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050651' => _x( 'CANCHAGUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050652' => _x( 'CHANTILIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050653' => _x( 'COCHAPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050750' => _x( 'SIGCHOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050751' => _x( 'CHUGCHILAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050752' => _x( 'ISINLIVI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050753' => _x( 'LAS PAMPAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC050754' => _x( 'PALO QUEMADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC06' => [
		'EC060150' => _x( 'RIOBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060151' => _x( 'CACHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060152' => _x( 'CALPI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060153' => _x( 'CUBIJIES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060154' => _x( 'FLORES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060155' => _x( 'LICAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060156' => _x( 'LICTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060157' => _x( 'PUNGALA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060158' => _x( 'PUNIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060159' => _x( 'QUIMIAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060160' => _x( 'SAN JUAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060161' => _x( 'SAN LUIS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060250' => _x( 'ALAUSI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060251' => _x( 'ACHUPALLAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060253' => _x( 'GUASUNTOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060254' => _x( 'HUIGRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060255' => _x( 'MULTITUD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060256' => _x( 'PISTISHI (NARIZ DEL DIABLO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060257' => _x( 'PUMALLACTA (PUMAL-LACTA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060258' => _x( 'SEVILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060259' => _x( 'SIBAMBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060260' => _x( 'TIXAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060350' => _x( 'VILLA LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060351' => _x( 'CAÑI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060352' => _x( 'COLUMBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060353' => _x( 'JUAN DE VELASCO (PANGOR)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060354' => _x( 'SANTIAGO DE QUITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060450' => _x( 'CHAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060550' => _x( 'CHUNCHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060551' => _x( 'CAPZOL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060552' => _x( 'COMPUD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060553' => _x( 'GONZOL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060554' => _x( 'LLAGOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060650' => _x( 'GUAMOTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060651' => _x( 'CEBADAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060652' => _x( 'PALMIRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060750' => _x( 'GUANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060751' => _x( 'GUANANDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060752' => _x( 'ILAPO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060753' => _x( 'LA PROVIDENCIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060754' => _x( 'SAN ANDRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060755' => _x( 'SAN GERARDO DE PACAICAGUAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060756' => _x( 'SAN ISIDRO DE PATULU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060757' => _x( 'SAN JOSE DEL CHAZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060758' => _x( 'SANTA FE DE GALAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060759' => _x( 'VALPARAISO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060850' => _x( 'PALLATANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060950' => _x( 'PENIPE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060951' => _x( 'EL ALTAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060952' => _x( 'MATUS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060953' => _x( 'PUELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060954' => _x( 'SAN ANTONIO DE BAYUSHIG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060955' => _x( 'LA CANDELARIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC060956' => _x( 'BILBAO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC061050' => _x( 'CUMANDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC07' => [
		'EC070150' => _x( 'MACHALA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070152' => _x( 'EL RETIRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070250' => _x( 'ARENILLAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070251' => _x( 'CHACRAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070254' => _x( 'PALMALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070255' => _x( 'CARCABON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070350' => _x( 'PACCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070351' => _x( 'AYAPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070352' => _x( 'CORDONCILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070353' => _x( 'MILAGRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070354' => _x( 'SAN JOSE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070355' => _x( 'CERRO AZUL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070450' => _x( 'BALSAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070451' => _x( 'BELLAMARIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070550' => _x( 'CHILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070650' => _x( 'EL GUABO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070651' => _x( 'BARBONES (SUCRE)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070652' => _x( 'LA IBERIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070653' => _x( 'TENDALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070654' => _x( 'RIO BONITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070750' => _x( 'HUAQUILLAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070850' => _x( 'MARCABELI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070851' => _x( 'EL INGENIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070950' => _x( 'PASAJE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070951' => _x( 'BUENAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070952' => _x( 'CASACAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070953' => _x( 'LA PEAÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070954' => _x( 'PROGRESO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070955' => _x( 'UZHCURRUMI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC070956' => _x( 'CAÑA QUEMADA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071050' => _x( 'PIÑAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071051' => _x( 'CAPIRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071052' => _x( 'LA BOCANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071053' => _x( 'MOROMORO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071054' => _x( 'PIEDRAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071055' => _x( 'SAN ROQUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071056' => _x( 'SARACAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071150' => _x( 'PORTOVELO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071151' => _x( 'CURTINCAPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071152' => _x( 'MORALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071153' => _x( 'SALATI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071250' => _x( 'SANTA ROSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071251' => _x( 'BELLAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071252' => _x( 'JAMBELI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071253' => _x( 'LA AVANZADA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071254' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071255' => _x( 'TORATA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071256' => _x( 'VICTORIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071257' => _x( 'BELLAMARIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071350' => _x( 'ZARUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071351' => _x( 'ABAÑIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071352' => _x( 'ARCAPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071353' => _x( 'GUANAZAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071354' => _x( 'GUIZHAGUIÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071355' => _x( 'HUERTAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071356' => _x( 'MALVAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071357' => _x( 'MULUNCAY GRANDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071358' => _x( 'SINSAO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071359' => _x( 'SALVIAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071450' => _x( 'LA VICTORIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071451' => _x( 'LA LIBERTAD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071452' => _x( 'EL PARAISO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC071453' => _x( 'SAN ISIDRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC08' => [
		'EC080150' => _x( 'ESMERALDAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080152' => _x( 'CAMARONES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080153' => _x( 'CRNEL. CARLOS CONCHA TORRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080154' => _x( 'CHINCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080159' => _x( 'MAJUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080163' => _x( 'SAN MATEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080165' => _x( 'TABIAZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080166' => _x( 'TACHINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080168' => _x( 'VUELTA LARGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080250' => _x( 'VALDEZ (LIMONES)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080251' => _x( 'ANCHAYACU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080252' => _x( 'ATAHUALPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080253' => _x( 'BORBON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080254' => _x( 'LA TOLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080255' => _x( 'LUIS VARGAS TORRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080256' => _x( 'MALDONADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080257' => _x( 'PAMPANAL DE BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080258' => _x( 'SAN FRANCISCO DE ONZOLE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080259' => _x( 'SANTO DOMINGO DE ONZOLE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080260' => _x( 'SELVA ALEGRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080261' => _x( 'TELEMBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080262' => _x( 'COLON ELOY DEL MARIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080263' => _x( 'SAN JOSE DE CAYAPAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080264' => _x( 'TIMBIRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080350' => _x( 'MUISNE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080351' => _x( 'BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080352' => _x( 'DAULE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080353' => _x( 'GALERA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080354' => _x( 'QUINGUE (OLMEDO PERDOMO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080355' => _x( 'SALIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080356' => _x( 'SAN FRANCISCO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080357' => _x( 'SAN GREGORIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080358' => _x( 'SAN JOSE DE CHAMANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080450' => _x( 'ROSA ZARATE (QUININDE)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080451' => _x( 'CUBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080452' => _x( 'CHURA (CHANCAMA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080453' => _x( 'MALIMPIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080454' => _x( 'VICHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080455' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080550' => _x( 'SAN LORENZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080551' => _x( 'ALTO TAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080552' => _x( 'ANCON (PICHANGAL)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080553' => _x( 'CALDERON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080554' => _x( 'CARONDELET', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080555' => _x( '5 DE JUNIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080556' => _x( 'CONCEPCION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080557' => _x( 'MATAJE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080558' => _x( 'SAN JAVIER DE CACHAVI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080559' => _x( 'SANTA RITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080560' => _x( 'TAMBILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080561' => _x( 'TULULBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080562' => _x( 'URBINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080650' => _x( 'ATACAMES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080651' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080652' => _x( 'SUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080653' => _x( 'TONCHIGUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080654' => _x( 'TONSUPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080750' => _x( 'RIOVERDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080751' => _x( 'CHONTADURO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080752' => _x( 'CHUMUNDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080753' => _x( 'LAGARTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080754' => _x( 'MONTALVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080755' => _x( 'ROCAFUERTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC080850' => _x( 'LA CONCORDIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC09' => [
		'EC090150' => _x( 'GUAYAQUIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090152' => _x( 'JUAN GOMEZ RENDON (PROGR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090153' => _x( 'MORRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090156' => _x( 'POSORJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090157' => _x( 'PUNA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090158' => _x( 'TENGUEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090250' => _x( 'ALFREDO BAQUERIZO MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090350' => _x( 'BALAO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090450' => _x( 'BALZAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090550' => _x( 'COLIMES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090551' => _x( 'SAN JACINTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090650' => _x( 'DAULE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090652' => _x( 'JUAN BAUTISTA AGUIRRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090653' => _x( 'LAUREL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090654' => _x( 'LIMONAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090656' => _x( 'LOS LOJAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090750' => _x( 'ELOY ALFARO (DURAN)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090850' => _x( 'VELASCO IBARRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090851' => _x( 'GUAYAS (PUEBLO NUEVO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090852' => _x( 'EL ROSARIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC090950' => _x( 'EL TRIUNFO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091050' => _x( 'MILAGRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091051' => _x( 'CHOBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091053' => _x( 'MARISCAL SUCRE (HUAQUES)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091054' => _x( 'ROBERTO ASTUDILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091150' => _x( 'NARANJAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091151' => _x( 'JESUS MARIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091152' => _x( 'SAN CARLOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091153' => _x( 'SANTA ROSA DE FLANDES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091154' => _x( 'TAURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091250' => _x( 'NARANJITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091350' => _x( 'PALESTINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091450' => _x( 'PEDRO CARBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091451' => _x( 'VALLE DE LA VIRGEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091452' => _x( 'SABANILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091650' => _x( 'SAMBORONDON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091651' => _x( 'TARIFA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091850' => _x( 'SANTA LUCIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091950' => _x( 'EL SALITRE (LAS RAMAS)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091951' => _x( 'GENERAL VERNAZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091952' => _x( 'LA VICTORIA (ÑAUZA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC091953' => _x( 'JUNQUILLAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092050' => _x( 'YAGUACHI NUEVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092053' => _x( 'GRAL. PEDRO J. MONTERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092055' => _x( 'YAGUACHI VIEJO (CONE)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092056' => _x( 'VIRGEN DE FATIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092150' => _x( 'GENERAL VILLAMIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092250' => _x( 'SIMON BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092251' => _x( 'CRNEL.LORENZO DE GARAICOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092350' => _x( 'CORONEL MARCELINO MARIDUEÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092450' => _x( 'LOMAS DE SARGENTILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092550' => _x( 'NARCISA DE JESUS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092750' => _x( 'GENERAL ANTONIO ELIZALDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC092850' => _x( 'ISIDRO AYORA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC10' => [
		'EC100150' => _x( 'IBARRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100151' => _x( 'AMBUQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100152' => _x( 'ANGOCHAGUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100153' => _x( 'CAROLINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100154' => _x( 'LA ESPERANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100155' => _x( 'LITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100156' => _x( 'SALINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100157' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100250' => _x( 'ATUNTAQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100251' => _x( 'IMBAYA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100252' => _x( 'SAN FRANCISCO DE NATABUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100253' => _x( 'SAN JOSE DE CHALTURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100254' => _x( 'SAN ROQUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100350' => _x( 'COTACACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100351' => _x( 'APUELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100352' => _x( 'GARCIA MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100353' => _x( 'IMANTAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100354' => _x( 'PEÑAHERRERA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100355' => _x( 'PLAZA GUTIERREZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100356' => _x( 'QUIROGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100357' => _x( '6 DE JULIO DE CUELLAJE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100358' => _x( 'VACAS GALINDO (EL CHURO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100450' => _x( 'OTAVALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100451' => _x( 'DR. MIGUEL EGAS CABEZAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100452' => _x( 'EUGENIO ESPEJO (CALPAQUI)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100453' => _x( 'GONZALEZ SUAREZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100454' => _x( 'PATAQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100455' => _x( 'SAN JOSE DE QUICHINCHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100456' => _x( 'SAN JUAN DE ILUMAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100457' => _x( 'SAN PABLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100458' => _x( 'SAN RAFAEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100459' => _x( 'SELVA ALEGRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100550' => _x( 'PIMAMPIRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100551' => _x( 'CHUGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100552' => _x( 'MARIANO ACOSTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100553' => _x( 'SAN FRANCISCO DE SIGSIPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100650' => _x( 'URCUQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100651' => _x( 'CAHUASQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100652' => _x( 'LA MERCED DE BUENOS AIRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100653' => _x( 'PABLO ARENAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100654' => _x( 'SAN BLAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC100655' => _x( 'TUMBABIRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC11' => [
		'EC110150' => _x( 'LOJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110151' => _x( 'CHANTACO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110152' => _x( 'CHUQUIRIBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110153' => _x( 'EL CISNE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110154' => _x( 'GUALEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110155' => _x( 'JIMBILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110156' => _x( 'MALACATOS (VALLADOLID)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110157' => _x( 'SAN LUCAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110158' => _x( 'SAN PEDRO DE VILCABAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110159' => _x( 'SANTIAGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110160' => _x( 'TAQUIL (MIGUEL RIOFRIO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110161' => _x( 'VILCABAMBA (VICTORIA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110162' => _x( 'YANGANA (ARSENIO CASTILLO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110163' => _x( 'QUINARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110250' => _x( 'CARIAMANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110251' => _x( 'COLAISACA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110252' => _x( 'EL LUCERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110253' => _x( 'UTUANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110254' => _x( 'SANGILLIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110350' => _x( 'CATAMAYO (LA TOMA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110351' => _x( 'EL TAMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110352' => _x( 'GUAYQUICHUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110353' => _x( 'SAN PEDRO DE LA BENDITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110354' => _x( 'ZAMBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110450' => _x( 'CELICA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110451' => _x( 'CRUZPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110455' => _x( 'POZUL (SAN JUAN DE POZUL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110456' => _x( 'SABANILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110457' => _x( 'TNTE. MAXIMILIANO RODRIG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110550' => _x( 'CHAGUARPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110551' => _x( 'BUENAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110552' => _x( 'EL ROSARIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110553' => _x( 'SANTA RUFINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110554' => _x( 'AMARILLOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110650' => _x( 'AMALUZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110651' => _x( 'BELLAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110652' => _x( 'JIMBURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110653' => _x( 'SANTA TERESITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110654' => _x( '27 DE ABRIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110655' => _x( 'EL INGENIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110656' => _x( 'EL AIRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110750' => _x( 'GONZANAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110751' => _x( 'CHANGAIMINA (LA LIBERTAD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110753' => _x( 'NAMBACOLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110754' => _x( 'PURUNUMA (EGUIGUREN)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110756' => _x( 'SACAPALCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110850' => _x( 'MACARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110851' => _x( 'LARAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110852' => _x( 'LA VICTORIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110853' => _x( 'SABIANGO (LA CAPILLA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110950' => _x( 'CATACOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110951' => _x( 'CANGONAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110952' => _x( 'GUACHANAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110954' => _x( 'LAURO GUERRERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110956' => _x( 'ORIANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110957' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110958' => _x( 'CASANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC110959' => _x( 'YAMANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111050' => _x( 'ALAMOR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111051' => _x( 'CIANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111052' => _x( 'EL ARENAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111053' => _x( 'EL LIMO (MARIANA DE JESUS)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111054' => _x( 'MERCADILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111055' => _x( 'VICENTINO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111150' => _x( 'SARAGURO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111151' => _x( 'EL PARAISO DE CELEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111152' => _x( 'EL TABLON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111153' => _x( 'LLUZHAPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111154' => _x( 'MANU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111155' => _x( 'SAN ANTONIO DE QUMBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111156' => _x( 'SAN PABLO DE TENTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111157' => _x( 'SAN SEBASTIAN DE YULUC', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111158' => _x( 'SELVA ALEGRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111159' => _x( 'URDANETA (PAQUISHAPA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111160' => _x( 'SUMAYPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111250' => _x( 'SOZORANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111251' => _x( 'NUEVA FATIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111252' => _x( 'TACAMOROS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111350' => _x( 'ZAPOTILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111351' => _x( 'CAZADEROS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111352' => _x( 'GARZAREAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111353' => _x( 'LIMONES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111354' => _x( 'PALETILLAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111355' => _x( 'BOLASPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111450' => _x( 'PINDAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111451' => _x( 'CHAQUINAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111452' => _x( '12 DE DICIEMBRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111550' => _x( 'QUILANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111551' => _x( 'FUNDOCHAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111552' => _x( 'SAN ANTONIO DE LAS ARADAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111650' => _x( 'OLMEDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC111651' => _x( 'LA TINGUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC12' => [
		'EC120150' => _x( 'BABAHOYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120152' => _x( 'CARACOL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120153' => _x( 'FEBRES CORDERO (LAS JUNTAS)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120154' => _x( 'PIMOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120155' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120250' => _x( 'BABA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120251' => _x( 'GUARE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120252' => _x( 'ISLA DE BEJUCAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120350' => _x( 'MONTALVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120450' => _x( 'PUEBLOVIEJO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120451' => _x( 'PUERTO PECHICHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120452' => _x( 'SAN JUAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120550' => _x( 'QUEVEDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120553' => _x( 'SAN CARLOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120555' => _x( 'LA ESPERANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120650' => _x( 'CATARAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120651' => _x( 'RICAURTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120750' => _x( 'VENTANAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120752' => _x( 'ZAPOTAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120850' => _x( 'VINCES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120851' => _x( 'ANTONIO SOTOMAYOR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC120950' => _x( 'PALENQUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC121050' => _x( 'SAN JACINTO DE BUENA FE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC121051' => _x( 'PATRICIA PILAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC121150' => _x( 'VALENCIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC121250' => _x( 'MOCACHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC121350' => _x( 'QUINSALOMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC13' => [
		'EC130150' => _x( 'PORTOVIEJO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130151' => _x( 'ABDON CALDERON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130152' => _x( 'ALHAJUELA (BAJO GRANDE)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130153' => _x( 'CRUCITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130154' => _x( 'PUEBLO NUEVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130155' => _x( 'RIOCHICO (RIO CHICO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130156' => _x( 'SAN PLACIDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130157' => _x( 'CHIRIJOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130250' => _x( 'CALCETA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130251' => _x( 'MEMBRILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130252' => _x( 'QUIROGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130350' => _x( 'CHONE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130351' => _x( 'BOYACA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130352' => _x( 'CANUTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130353' => _x( 'CONVENTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130354' => _x( 'CHIBUNGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130355' => _x( 'ELOY ALFARO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130356' => _x( 'RICAURTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130357' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130450' => _x( 'EL CARMEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130451' => _x( 'WILFRIDO LOOR MOREIRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130452' => _x( 'SAN PEDRO DE SUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130550' => _x( 'FLAVIO ALFARO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130551' => _x( 'SAN FRANCISCO DE NOVILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130552' => _x( 'ZAPALLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130650' => _x( 'JIPIJAPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130651' => _x( 'AMERICA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130652' => _x( 'EL ANEGADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130653' => _x( 'JULCUY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130654' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130656' => _x( 'MEMBRILLAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130657' => _x( 'PEDRO PABLO GOMEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130658' => _x( 'PUERTO DE CAYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130750' => _x( 'JUNIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130850' => _x( 'MANTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130851' => _x( 'SAN LORENZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130852' => _x( 'SANTA MARIANITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130950' => _x( 'MONTECRISTI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC130952' => _x( 'LA PILA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131050' => _x( 'PAJAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131051' => _x( 'CAMPOZANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131052' => _x( 'CASCOL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131053' => _x( 'GUALE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131054' => _x( 'LASCANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131150' => _x( 'PICHINCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131151' => _x( 'BARRAGANETE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131152' => _x( 'SAN SEBASTIAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131250' => _x( 'ROCAFUERTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131350' => _x( 'SANTA ANA DE VUELTA LARGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131351' => _x( 'AYACUCHO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131352' => _x( 'HONORATO VASQUEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131353' => _x( 'LA UNION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131355' => _x( 'SAN PABLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131450' => _x( 'BAHIA DE CARAQUEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131453' => _x( 'CHARAPOTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131457' => _x( 'SAN ISIDRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131550' => _x( 'TOSAGUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131551' => _x( 'BACHILLERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131552' => _x( 'ANGEL PEDRO GILER', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131650' => _x( 'SUCRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131651' => _x( 'BELLAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131652' => _x( 'NOBOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131653' => _x( 'ARQ. SIXTO DURAN BALLEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131750' => _x( 'PEDERNALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131751' => _x( 'COJIMIES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131752' => _x( '10 DE AGOSTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131753' => _x( 'ATAHUALPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131850' => _x( 'OLMEDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131950' => _x( 'PUERTO LOPEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131951' => _x( 'MACHALILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC131952' => _x( 'SALANGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC132050' => _x( 'JAMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC132150' => _x( 'JARAMIJO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC132250' => _x( 'SAN VICENTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC132251' => _x( 'CANOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC14' => [
		'EC140150' => _x( 'MACAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140151' => _x( 'ALSHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140153' => _x( 'GENERAL PROAÑO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140156' => _x( 'SAN ISIDRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140157' => _x( 'SEVILLA DON BOSCO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140158' => _x( 'SINAI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140160' => _x( 'ZUÑA (ZUÑAC)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140162' => _x( 'CUCHAENTZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140164' => _x( 'RIO BLANCO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140250' => _x( 'GUALAQUIZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140251' => _x( 'AMAZONAS (ROSARIO DE CUYES)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140252' => _x( 'BERMEJOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140253' => _x( 'BOMBOIZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140254' => _x( 'CHIGUINDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140255' => _x( 'EL ROSARIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140256' => _x( 'NUEVA TARQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140257' => _x( 'SAN MIGUEL DE CUYES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140258' => _x( 'EL IDEAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140350' => _x( 'GENERAL LEONIDAS PLAZA G.', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140351' => _x( 'INDANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140353' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140356' => _x( 'SAN MIGUEL DE CONCHAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140357' => _x( 'SANTA SUSANA DE CHIVIAZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140358' => _x( 'YUNGANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140450' => _x( 'PALORA (METZERA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140451' => _x( 'ARAPICOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140452' => _x( 'CUMANDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140454' => _x( 'SANGAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140455' => _x( '16 DE AGOSTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140550' => _x( 'SANTIAGO DE MENDEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140551' => _x( 'COPAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140552' => _x( 'CHUPIANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140553' => _x( 'PATUCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140554' => _x( 'SAN LUIS DE EL ACHO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140556' => _x( 'SANTIAGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140557' => _x( 'SAN FRANCISCO DE CHINIMB', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140650' => _x( 'SUCUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140651' => _x( 'ASUNCION', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140652' => _x( 'HUAMBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140655' => _x( 'SANTA MARIANITA DE JESUS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140750' => _x( 'HUAMBOYA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140751' => _x( 'CHIGUAZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140850' => _x( 'SAN JUAN BOSCO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140851' => _x( 'PAN DE AZUCAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140852' => _x( 'SAN CARLOS DE LIMON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140853' => _x( 'SAN JACINTO DE WAKAMBEIS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140854' => _x( 'SANTIAGO DE PANANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140950' => _x( 'TAISHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140951' => _x( 'HUASAGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140952' => _x( 'MACUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140953' => _x( 'TUTINENTZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC140954' => _x( 'PUMPUENTSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141050' => _x( 'LOGROÑO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141051' => _x( 'YAUPI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141052' => _x( 'SHIMPIS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141150' => _x( 'PABLO VI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141250' => _x( 'TIWINTZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC141251' => _x( 'SAN JOSE DE MORONA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC15' => [
		'EC150150' => _x( 'TENA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150151' => _x( 'AHUANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150153' => _x( 'CHONTAPUNTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150154' => _x( 'PANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150155' => _x( 'PUERTO MISAHUALLI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150156' => _x( 'PUERTO NAPO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150157' => _x( 'TALAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150350' => _x( 'ARCHIDONA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150352' => _x( 'COTUNDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150354' => _x( 'SAN PABLO DE USHPAYACU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150450' => _x( 'EL CHACO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150451' => _x( 'GONZALO DIAZ DE PINEDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150452' => _x( 'LINARES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150453' => _x( 'OYACACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150454' => _x( 'SANTA ROSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150455' => _x( 'SARDINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150750' => _x( 'BAEZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150751' => _x( 'COSANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150752' => _x( 'CUYUJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150753' => _x( 'PAPALLACTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150754' => _x( 'SAN FRANCISCO DE BORJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150756' => _x( 'SUMACO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC150950' => _x( 'CARLOS JULIO AROSEMENA TOLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC16' => [
		'EC160150' => _x( 'PUYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160152' => _x( 'CANELOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160154' => _x( 'DIEZ DE AGOSTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160155' => _x( 'FATIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160156' => _x( 'MONTALVO (ANDOAS)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160157' => _x( 'POMONA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160158' => _x( 'RIO CORRIENTES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160159' => _x( 'RIO TIGRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160161' => _x( 'SARAYACU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160162' => _x( 'SIMON BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160163' => _x( 'TARQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160164' => _x( 'TENIENTE HUGO ORTIZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160165' => _x( 'VERACRUZ (INDILLAMA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160166' => _x( 'EL TRIUNFO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160250' => _x( 'MERA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160251' => _x( 'MADRE TIERRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160252' => _x( 'SHELL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160350' => _x( 'SANTA CLARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160351' => _x( 'SAN JOSE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160450' => _x( 'ARAJUNO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC160451' => _x( 'CURARAY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC17' => [
		'EC170150' => _x( 'QUITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170151' => _x( 'ALANGASI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170152' => _x( 'AMAGUAÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170153' => _x( 'ATAHUALPA (HABASPAMBA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170154' => _x( 'CALACALI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170155' => _x( 'CALDERON (CARAPUNGO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170156' => _x( 'CONOCOTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170157' => _x( 'CUMBAYA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170158' => _x( 'CHAVEZPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170159' => _x( 'CHECA (CHILPA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170160' => _x( 'EL QUINCHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170161' => _x( 'GUALEA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170162' => _x( 'GUANGOPOLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170163' => _x( 'GUAYLLABAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170164' => _x( 'LA MERCED', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170165' => _x( 'LLANO CHICO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170166' => _x( 'LLOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170168' => _x( 'NANEGAL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170169' => _x( 'NANEGALITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170170' => _x( 'NAYON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170171' => _x( 'NONO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170172' => _x( 'PACTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170174' => _x( 'PERUCHO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170175' => _x( 'PIFO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170176' => _x( 'PINTAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170177' => _x( 'POMASQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170178' => _x( 'PUELLARO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170179' => _x( 'PUEMBO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170180' => _x( 'SAN ANTONIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170181' => _x( 'SAN JOSE DE MINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170183' => _x( 'TABABELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170184' => _x( 'TUMBACO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170185' => _x( 'YARUQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170186' => _x( 'ZAMBIZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170250' => _x( 'CAYAMBE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170251' => _x( 'ASCAZUBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170252' => _x( 'CANGAHUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170253' => _x( 'OLMEDO (PESILLO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170254' => _x( 'OTON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170255' => _x( 'SANTA ROSA DE CUZUBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170350' => _x( 'MACHACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170351' => _x( 'ALOAG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170352' => _x( 'ALOASI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170353' => _x( 'CUTUGLAHUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170354' => _x( 'EL CHAUPI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170355' => _x( 'MANUEL CORNEJO ASTORGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170356' => _x( 'TAMBILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170357' => _x( 'UYUMBICHO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170450' => _x( 'TABACUNDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170451' => _x( 'LA ESPERANZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170452' => _x( 'MALCHINGUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170453' => _x( 'TOCACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170454' => _x( 'TUPIGACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170550' => _x( 'SANGOLQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170551' => _x( 'COTOGCHOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170552' => _x( 'RUMIPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170750' => _x( 'SAN MIGUEL DE LOS BANCOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170751' => _x( 'MINDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170850' => _x( 'PEDRO VICENTE MALDONADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC170950' => _x( 'PUERTO QUITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC18' => [
		'EC180150' => _x( 'AMBATO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180151' => _x( 'AMBATILLO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180152' => _x( 'ATAHUALPA (CHISALATA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180153' => _x( 'AUGUSTO N. MARTINEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180154' => _x( 'CONSTANTINO FERNANDEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180155' => _x( 'HUACHI GRANDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180156' => _x( 'IZAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180157' => _x( 'JUAN BENIGNO VELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180158' => _x( 'MONTALVO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180159' => _x( 'PASA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180160' => _x( 'PICAIGUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180161' => _x( 'PILAGUIN (PILAHUIN)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180162' => _x( 'QUISAPINCHA (QUIZAPINCHA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180163' => _x( 'SAN BARTOLOME DE PINLLOG', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180164' => _x( 'SAN FERNANDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180165' => _x( 'SANTA ROSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180166' => _x( 'TOTORAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180167' => _x( 'CUNCHIBAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180168' => _x( 'UNAMUNCHO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180250' => _x( 'BAÑOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180251' => _x( 'LLIGUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180252' => _x( 'RIO NEGRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180253' => _x( 'RIO VERDE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180254' => _x( 'ULBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180350' => _x( 'CEVALLOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180450' => _x( 'MOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180451' => _x( 'PINGUILI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180550' => _x( 'PATATE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180551' => _x( 'EL TRIUNFO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180552' => _x( 'LOS ANDES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180553' => _x( 'SUCRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180650' => _x( 'QUERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180651' => _x( 'RUMIPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180652' => _x( 'YANAYACU - MOCHAPATA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180750' => _x( 'PELILEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180751' => _x( 'BENITEZ (PACHANLICA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180752' => _x( 'BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180753' => _x( 'COTALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180754' => _x( 'CHIQUICHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180755' => _x( 'EL ROSARIO (RUMICHACA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180756' => _x( 'GARCIA MORENO (CHUMAQUI)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180757' => _x( 'GUAMBALO (HUAMBALO)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180758' => _x( 'SALASACA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180850' => _x( 'PILLARO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180851' => _x( 'BAQUERIZO MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180852' => _x( 'EMILIO MARIA TERAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180853' => _x( 'MARCOS ESPINEL (CHACATA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180854' => _x( 'PRESIDENTE URBINA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180855' => _x( 'SAN ANDRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180856' => _x( 'SAN JOSE DE POALO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180857' => _x( 'SAN MIGUELITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180950' => _x( 'TISALEO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC180951' => _x( 'QUINCHICOTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC19' => [
		'EC190150' => _x( 'ZAMORA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190151' => _x( 'CUMBARATZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190152' => _x( 'GUADALUPE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190153' => _x( 'IMBANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190155' => _x( 'SABANILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190156' => _x( 'TIMBARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190158' => _x( 'SAN CARLOS DE LAS MINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190250' => _x( 'ZUMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190251' => _x( 'CHITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190252' => _x( 'EL CHORRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190254' => _x( 'LA CHONTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190256' => _x( 'PUCAPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190259' => _x( 'SAN ANDRES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190350' => _x( 'GUAYZIMI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190351' => _x( 'ZURMI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190352' => _x( 'NUEVO PARAISO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190450' => _x( '28 DE MAYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190451' => _x( 'LA PAZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190452' => _x( 'TUTUPALI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190550' => _x( 'YANZATZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190551' => _x( 'CHICAÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190553' => _x( 'LOS ENCUENTROS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190650' => _x( 'EL PANGUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190651' => _x( 'EL GUISMI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190652' => _x( 'PACHICUTZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190653' => _x( 'TUNDAYME', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190750' => _x( 'ZUMBI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190850' => _x( 'PALANDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190851' => _x( 'EL PORVENIR DEL CARMEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190852' => _x( 'SAN FRANCISCO DE VERGEL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190853' => _x( 'VALLADOLID', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190854' => _x( 'LA CANELA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190950' => _x( 'PAQUISHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190951' => _x( 'BELLAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC190952' => _x( 'NUEVO QUITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC20' => [
		'EC200150' => _x( 'PUERTO BAQUERIZO MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200151' => _x( 'EL PROGRESO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200152' => _x( 'ISLA SANTA MARIA (FLOREANA)', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200250' => _x( 'PUERTO VILLAMIL', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200251' => _x( 'TOMAS DE BERLANGA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200350' => _x( 'PUERTO AYORA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200351' => _x( 'BELLAVISTA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC200352' => _x( 'SANTA ROSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC21' => [
		'EC210150' => _x( 'NUEVA LOJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210152' => _x( 'DURENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210153' => _x( 'GENERAL FARFAN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210155' => _x( 'EL ENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210156' => _x( 'PACAYACU', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210157' => _x( 'JAMBELI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210158' => _x( 'STA. CECILIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210250' => _x( 'LUMBAQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210251' => _x( 'EL REVENTADOR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210252' => _x( 'GONZALO PIZARRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210254' => _x( 'PUERTO LIBRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210350' => _x( 'PUERTO EL CARMEN DEL PUTUMAYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210351' => _x( 'PALMA ROJA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210352' => _x( 'PUERTO BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210353' => _x( 'PUERTO RODRIGUEZ', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210354' => _x( 'SANTA ELENA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210450' => _x( 'SHUSHUFINDI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210451' => _x( 'LIMONCOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210452' => _x( 'PAÑACOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210453' => _x( 'SAN ROQUE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210454' => _x( 'SAN PEDRO DE LOS COFANES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210455' => _x( 'SIETE DE JULIO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210550' => _x( 'LA BONITA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210551' => _x( 'EL PLAYON DE SAN FRANCIS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210552' => _x( 'LA SOFIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210553' => _x( 'ROSA FLORIDA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210554' => _x( 'SANTA BARBARA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210650' => _x( 'EL DORADO DE CASCALES', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210651' => _x( 'SANTA ROSA DE SUCUMBIOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210652' => _x( 'SEVILLA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210750' => _x( 'TARAPOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210751' => _x( 'CUYABENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC210752' => _x( 'AGUAS NEGRAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC22' => [
		'EC220150' => _x( 'PUERTO FRANCISCO DE ORELLANA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220151' => _x( 'DAYUMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220152' => _x( 'TARACOA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220153' => _x( 'ALEJANDRO LABAKA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220154' => _x( 'EL DORADO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220155' => _x( 'EL EDEN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220156' => _x( 'GARCIA MORENO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220157' => _x( 'INES ARANGO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220158' => _x( 'LA BELLEZA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220159' => _x( 'NUEVO PARAISO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220160' => _x( 'SAN JOSE DE GUAYUSA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220161' => _x( 'SAN LUIS DE ARMENIA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220250' => _x( 'NUEVO ROCAFUERTE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220251' => _x( 'CAPITAN AUGUSTO RIBADENEYRA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220252' => _x( 'CONONACO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220253' => _x( 'SANTA MARIA DE HUIRIRIMA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220254' => _x( 'TIPUTINI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220255' => _x( 'YASUNI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220350' => _x( 'LA JOYA DE LOS SACHAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220351' => _x( 'ENOKANQUI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220352' => _x( 'POMPEYA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220353' => _x( 'SAN CARLOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220354' => _x( 'SAN SEBASTIAN DEL COCA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220355' => _x( 'LAGO SAN PEDRO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220356' => _x( 'RUMIPAMBA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220357' => _x( 'TRES DE NOVIEMBRE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220358' => _x( 'UNION MILAGREÑA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220450' => _x( 'LORETO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220451' => _x( 'AVILA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220452' => _x( 'PUERTO MURIALDO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220453' => _x( 'SAN JOSE DE PAYAMINO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220454' => _x( 'SAN JOSE DE DAHUANO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC220455' => _x( 'SAN VICENTE DE HUATICOCHA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC23' => [
		'EC230150' => _x( 'SANTO DOMINGO DE LOS COLORADOS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230151' => _x( 'ALLURIQUIN', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230152' => _x( 'PUERTO LIMON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230153' => _x( 'LUZ DE AMERICA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230154' => _x( 'SAN JACINTO DEL BUA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230155' => _x( 'VALLE HERMOSO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230156' => _x( 'EL ESFUERZO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC230157' => _x( 'SANTA MARIA DEL TOACHI', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC24' => [
		'EC240150' => _x( 'SANTA ELENA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240151' => _x( 'ATAHUALPA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240152' => _x( 'COLONCHE', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240153' => _x( 'CHANDUY', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240154' => _x( 'MANGLARALTO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240155' => _x( 'SIMON BOLIVAR', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240156' => _x( 'SAN JOSE DE ANCON', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240250' => _x( 'LA LIBERTAD', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240350' => _x( 'SALINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240351' => _x( 'ANCONCITO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC240352' => _x( 'JOSE LUIS TAMAYO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'EC90' => [
		'EC900151' => _x( 'LAS GOLONDRINAS', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC900351' => _x( 'MANGA DEL CURA', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
		'EC900451' => _x( 'EL PIEDRERO', 'EC-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
];
