<?php

/**
 * List of cities for: Germany
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'DE01001000' => 'Flensburg, Stadt',
	'DE01002000' => 'Kiel, Landeshauptstadt',
	'DE01003000' => 'Lübeck, Hansestadt',
	'DE01004000' => 'Neumünster, Stadt',
	'DE01051001' => 'Albersdorf',
	'DE01051002' => 'Arkebek',
	'DE01051003' => 'Averlak',
	'DE01051004' => 'Bargenstedt',
	'DE01051005' => 'Barkenholm',
	'DE01051006' => 'Barlt',
	'DE01051008' => 'Bergewöhrden',
	'DE01051010' => 'Brickeln',
	'DE01051011' => 'Brunsbüttel, Stadt',
	'DE01051012' => 'Buchholz',
	'DE01051013' => 'Büsum',
	'DE01051014' => 'Büsumer Deichhausen',
	'DE01051015' => 'Bunsoh',
	'DE01051016' => 'Burg (Dithmarschen)',
	'DE01051017' => 'Busenwurth',
	'DE01051019' => 'Dellstedt',
	'DE01051020' => 'Delve',
	'DE01051021' => 'Diekhusen-Fahrstedt',
	'DE01051022' => 'Dingen',
	'DE01051023' => 'Dörpling',
	'DE01051024' => 'Eddelak',
	'DE01051026' => 'Eggstedt',
	'DE01051027' => 'Elpersbüttel',
	'DE01051028' => 'Epenwöhrden',
	'DE01051030' => 'Fedderingen',
	'DE01051032' => 'Frestedt',
	'DE01051033' => 'Friedrichsgabekoog',
	'DE01051034' => 'Friedrichskoog',
	'DE01051035' => 'Gaushorn',
	'DE01051036' => 'Glüsing',
	'DE01051037' => 'Großenrade',
	'DE01051038' => 'Groven',
	'DE01051039' => 'Gudendorf',
	'DE01051043' => 'Hedwigenkoog',
	'DE01051044' => 'Heide, Stadt',
	'DE01051045' => 'Hellschen-Heringsand-Unterschaar',
	'DE01051046' => 'Helse',
	'DE01051047' => 'Hemme',
	'DE01051048' => 'Hemmingstedt',
	'DE01051049' => 'Hennstedt',
	'DE01051050' => 'Hillgroven',
	'DE01051051' => 'Hochdonn',
	'DE01051052' => 'Hövede',
	'DE01051053' => 'Hollingstedt',
	'DE01051054' => 'Immenstedt',
	'DE01051057' => 'Kaiser-Wilhelm-Koog',
	'DE01051058' => 'Karolinenkoog',
	'DE01051060' => 'Kleve',
	'DE01051061' => 'Krempel',
	'DE01051062' => 'Kronprinzenkoog',
	'DE01051063' => 'Krumstedt',
	'DE01051064' => 'Kuden',
	'DE01051065' => 'Lehe',
	'DE01051067' => 'Lieth',
	'DE01051068' => 'Linden',
	'DE01051069' => 'Lohe-Rickelshof',
	'DE01051071' => 'Lunden',
	'DE01051072' => 'Marne, Stadt',
	'DE01051073' => 'Marnerdeich',
	'DE01051074' => 'Meldorf, Stadt',
	'DE01051075' => 'Neuenkirchen',
	'DE01051076' => 'Neufeld',
	'DE01051077' => 'Neufelderkoog',
	'DE01051078' => 'Nindorf',
	'DE01051079' => 'Norddeich',
	'DE01051080' => 'Norderheistedt',
	'DE01051081' => 'Norderwöhrden',
	'DE01051082' => 'Nordhastedt',
	'DE01051083' => 'Odderade',
	'DE01051084' => 'Oesterdeichstrich',
	'DE01051085' => 'Offenbüttel',
	'DE01051086' => 'Osterrade',
	'DE01051087' => 'Ostrohe',
	'DE01051088' => 'Pahlen',
	'DE01051089' => 'Quickborn',
	'DE01051090' => 'Ramhusen',
	'DE01051092' => 'Rehm-Flehde-Bargen',
	'DE01051093' => 'Reinsbüttel',
	'DE01051096' => 'Sankt Annen',
	'DE01051097' => 'Sankt Michaelisdonn',
	'DE01051098' => 'Sarzbüttel',
	'DE01051099' => 'Schafstedt',
	'DE01051100' => 'Schalkholz',
	'DE01051102' => 'Schlichting',
	'DE01051103' => 'Schmedeswurth',
	'DE01051104' => 'Schrum',
	'DE01051105' => 'Schülp',
	'DE01051107' => 'Stelle-Wittenwurth',
	'DE01051108' => 'Strübbel',
	'DE01051109' => 'Süderdeich',
	'DE01051110' => 'Süderhastedt',
	'DE01051113' => 'Wöhrden',
	'DE01051114' => 'Tellingstedt',
	'DE01051117' => 'Tielenhemme',
	'DE01051118' => 'Trennewurth',
	'DE01051119' => 'Volsemenhusen',
	'DE01051120' => 'Wallen',
	'DE01051121' => 'Warwerort',
	'DE01051122' => 'Weddingstedt',
	'DE01051125' => 'Welmbüttel',
	'DE01051126' => 'Wennbüttel',
	'DE01051127' => 'Wesselburen, Stadt',
	'DE01051128' => 'Wesselburener Deichhausen',
	'DE01051129' => 'Wesselburenerkoog',
	'DE01051130' => 'Wesseln',
	'DE01051131' => 'Westerborstel',
	'DE01051132' => 'Westerdeichstrich',
	'DE01051133' => 'Wiemerstedt',
	'DE01051134' => 'Windbergen',
	'DE01051135' => 'Wolmersdorf',
	'DE01051136' => 'Wrohm',
	'DE01051137' => 'Nordermeldorf',
	'DE01051138' => 'Tensbüttel-Röst',
	'DE01051139' => 'Süderdorf',
	'DE01051140' => 'Oesterwurth',
	'DE01051141' => 'Süderheistedt',
	'DE01053001' => 'Albsfelde',
	'DE01053002' => 'Alt Mölln',
	'DE01053003' => 'Aumühle',
	'DE01053004' => 'Bäk',
	'DE01053005' => 'Bälau',
	'DE01053006' => 'Basedow',
	'DE01053007' => 'Basthorst',
	'DE01053008' => 'Behlendorf',
	'DE01053009' => 'Berkenthin',
	'DE01053010' => 'Besenthal',
	'DE01053011' => 'Bliestorf',
	'DE01053012' => 'Börnsen',
	'DE01053013' => 'Borstorf',
	'DE01053014' => 'Breitenfelde',
	'DE01053015' => 'Bröthen',
	'DE01053016' => 'Brunsmark',
	'DE01053017' => 'Brunstorf',
	'DE01053018' => 'Buchholz',
	'DE01053019' => 'Buchhorst',
	'DE01053020' => 'Büchen',
	'DE01053021' => 'Dahmker',
	'DE01053022' => 'Dalldorf',
	'DE01053023' => 'Dassendorf',
	'DE01053024' => 'Düchelsdorf',
	'DE01053025' => 'Duvensee',
	'DE01053026' => 'Einhaus',
	'DE01053027' => 'Elmenhorst',
	'DE01053028' => 'Escheburg',
	'DE01053029' => 'Fitzen',
	'DE01053030' => 'Fredeburg',
	'DE01053031' => 'Fuhlenhagen',
	'DE01053032' => 'Geesthacht, Stadt',
	'DE01053033' => 'Giesensdorf',
	'DE01053034' => 'Göldenitz',
	'DE01053035' => 'Göttin',
	'DE01053036' => 'Grabau',
	'DE01053037' => 'Grambek',
	'DE01053038' => 'Grinau',
	'DE01053039' => 'Groß Boden',
	'DE01053040' => 'Groß Disnack',
	'DE01053041' => 'Groß Grönau',
	'DE01053042' => 'Groß Pampau',
	'DE01053043' => 'Groß Sarau',
	'DE01053044' => 'Groß Schenkenberg',
	'DE01053045' => 'Grove',
	'DE01053046' => 'Gudow',
	'DE01053047' => 'Gülzow',
	'DE01053048' => 'Güster',
	'DE01053049' => 'Hamfelde',
	'DE01053050' => 'Hamwarde',
	'DE01053051' => 'Harmsdorf',
	'DE01053052' => 'Havekost',
	'DE01053053' => 'Hohenhorn',
	'DE01053054' => 'Hollenbek',
	'DE01053056' => 'Hornbek',
	'DE01053057' => 'Horst',
	'DE01053058' => 'Juliusburg',
	'DE01053059' => 'Kankelau',
	'DE01053060' => 'Kasseburg',
	'DE01053061' => 'Kastorf',
	'DE01053062' => 'Kittlitz',
	'DE01053064' => 'Klein Pampau',
	'DE01053066' => 'Klein Zecher',
	'DE01053067' => 'Klempau',
	'DE01053068' => 'Klinkrade',
	'DE01053069' => 'Koberg',
	'DE01053070' => 'Köthel',
	'DE01053071' => 'Kollow',
	'DE01053072' => 'Kröppelshagen-Fahrendorf',
	'DE01053073' => 'Krüzen',
	'DE01053074' => 'Krukow',
	'DE01053075' => 'Krummesse',
	'DE01053076' => 'Kuddewörde',
	'DE01053077' => 'Kühsen',
	'DE01053078' => 'Kulpin',
	'DE01053079' => 'Labenz',
	'DE01053080' => 'Langenlehsten',
	'DE01053081' => 'Lankau',
	'DE01053082' => 'Lanze',
	'DE01053083' => 'Lauenburg/ Elbe, Stadt',
	'DE01053084' => 'Lehmrade',
	'DE01053085' => 'Linau',
	'DE01053086' => 'Lüchow',
	'DE01053087' => 'Lütau',
	'DE01053088' => 'Mechow',
	'DE01053089' => 'Möhnsen',
	'DE01053090' => 'Mölln, Stadt',
	'DE01053091' => 'Mühlenrade',
	'DE01053092' => 'Müssen',
	'DE01053093' => 'Mustin',
	'DE01053094' => 'Niendorf bei Berkenthin',
	'DE01053095' => 'Niendorf/ Stecknitz',
	'DE01053096' => 'Nusse',
	'DE01053097' => 'Panten',
	'DE01053098' => 'Pogeez',
	'DE01053099' => 'Poggensee',
	'DE01053100' => 'Ratzeburg, Stadt',
	'DE01053101' => 'Ritzerau',
	'DE01053102' => 'Römnitz',
	'DE01053103' => 'Rondeshagen',
	'DE01053104' => 'Roseburg',
	'DE01053105' => 'Sachsenwald (Forstgutsbez.),gemfr.Geb.',
	'DE01053106' => 'Sahms',
	'DE01053107' => 'Salem',
	'DE01053108' => 'Sandesneben',
	'DE01053109' => 'Schiphorst',
	'DE01053110' => 'Schmilau',
	'DE01053111' => 'Schnakenbek',
	'DE01053112' => 'Schönberg',
	'DE01053113' => 'Schretstaken',
	'DE01053114' => 'Schürensöhlen',
	'DE01053115' => 'Schulendorf',
	'DE01053116' => 'Schwarzenbek, Stadt',
	'DE01053117' => 'Seedorf',
	'DE01053118' => 'Siebenbäumen',
	'DE01053119' => 'Siebeneichen',
	'DE01053120' => 'Sierksrade',
	'DE01053121' => 'Sirksfelde',
	'DE01053122' => 'Steinhorst',
	'DE01053123' => 'Sterley',
	'DE01053124' => 'Stubben',
	'DE01053125' => 'Talkau',
	'DE01053126' => 'Tramm',
	'DE01053127' => 'Walksfelde',
	'DE01053128' => 'Wangelau',
	'DE01053129' => 'Wentorf bei Hamburg',
	'DE01053130' => 'Wentorf (Amt Sandesneben)',
	'DE01053131' => 'Wiershop',
	'DE01053132' => 'Witzeeze',
	'DE01053133' => 'Wohltorf',
	'DE01053134' => 'Woltersdorf',
	'DE01053135' => 'Worth',
	'DE01053136' => 'Ziethen',
	'DE01054001' => 'Achtrup',
	'DE01054002' => 'Ahrenshöft',
	'DE01054003' => 'Ahrenviöl',
	'DE01054004' => 'Ahrenviölfeld',
	'DE01054005' => 'Alkersum',
	'DE01054006' => 'Almdorf',
	'DE01054007' => 'Arlewatt',
	'DE01054009' => 'Aventoft',
	'DE01054010' => 'Bargum',
	'DE01054011' => 'Behrendorf',
	'DE01054012' => 'Bohmstedt',
	'DE01054013' => 'Bondelum',
	'DE01054014' => 'Bordelum',
	'DE01054015' => 'Borgsum',
	'DE01054016' => 'Bosbüll',
	'DE01054017' => 'Braderup',
	'DE01054018' => 'Bramstedtlund',
	'DE01054019' => 'Bredstedt, Stadt',
	'DE01054020' => 'Breklum',
	'DE01054022' => 'Dagebüll',
	'DE01054023' => 'Drage',
	'DE01054024' => 'Drelsdorf',
	'DE01054025' => 'Dunsum',
	'DE01054026' => 'Elisabeth-Sophien-Koog',
	'DE01054027' => 'Ellhöft',
	'DE01054032' => 'Fresendelf',
	'DE01054033' => 'Friedrichstadt, Stadt',
	'DE01054034' => 'Friedrich-Wilhelm-Lübke-Koog',
	'DE01054035' => 'Garding, Kirchspiel',
	'DE01054036' => 'Garding, Stadt',
	'DE01054037' => 'Goldebek',
	'DE01054038' => 'Goldelund',
	'DE01054039' => 'Gröde',
	'DE01054040' => 'Grothusenkoog',
	'DE01054041' => 'Haselund',
	'DE01054042' => 'Hattstedt',
	'DE01054043' => 'Hattstedtermarsch',
	'DE01054045' => 'Högel',
	'DE01054046' => 'Hörnum (Sylt)',
	'DE01054048' => 'Holm',
	'DE01054050' => 'Hallig Hooge',
	'DE01054052' => 'Horstedt',
	'DE01054054' => 'Hude',
	'DE01054055' => 'Humptrup',
	'DE01054056' => 'Husum, Stadt',
	'DE01054057' => 'Immenstedt',
	'DE01054059' => 'Joldelund',
	'DE01054061' => 'Kampen (Sylt)',
	'DE01054062' => 'Karlum',
	'DE01054063' => 'Katharinenheerd',
	'DE01054065' => 'Klanxbüll',
	'DE01054068' => 'Klixbüll',
	'DE01054070' => 'Koldenbüttel',
	'DE01054071' => 'Kolkerheide',
	'DE01054072' => 'Kotzenbüll',
	'DE01054073' => 'Ladelund',
	'DE01054074' => 'Langeneß',
	'DE01054075' => 'Langenhorn',
	'DE01054076' => 'Leck',
	'DE01054077' => 'Lexgaard',
	'DE01054078' => 'List auf Sylt',
	'DE01054079' => 'Löwenstedt',
	'DE01054080' => 'Lütjenholm',
	'DE01054083' => 'Midlum',
	'DE01054084' => 'Mildstedt',
	'DE01054085' => 'Nebel',
	'DE01054086' => 'Neukirchen',
	'DE01054087' => 'Nieblum',
	'DE01054088' => 'Niebüll, Stadt',
	'DE01054089' => 'Norddorf auf Amrum',
	'DE01054090' => 'Norderfriedrichskoog',
	'DE01054091' => 'Nordstrand',
	'DE01054092' => 'Norstedt',
	'DE01054093' => 'Ockholm',
	'DE01054094' => 'Oevenum',
	'DE01054095' => 'Oldenswort',
	'DE01054096' => 'Oldersbek',
	'DE01054097' => 'Olderup',
	'DE01054098' => 'Oldsum',
	'DE01054099' => 'Ostenfeld (Husum)',
	'DE01054100' => 'Osterhever',
	'DE01054101' => 'Oster-Ohrstedt',
	'DE01054103' => 'Pellworm',
	'DE01054104' => 'Poppenbüll',
	'DE01054105' => 'Ramstedt',
	'DE01054106' => 'Rantrum',
	'DE01054108' => 'Reußenköge',
	'DE01054109' => 'Risum-Lindholm',
	'DE01054110' => 'Rodenäs',
	'DE01054113' => 'Sankt Peter-Ording',
	'DE01054116' => 'Schwabstedt',
	'DE01054118' => 'Schwesing',
	'DE01054119' => 'Seeth',
	'DE01054120' => 'Simonsberg',
	'DE01054121' => 'Sönnebüll',
	'DE01054123' => 'Sollwitt',
	'DE01054124' => 'Sprakebüll',
	'DE01054125' => 'Stadum',
	'DE01054126' => 'Stedesand',
	'DE01054128' => 'Struckum',
	'DE01054129' => 'Süderende',
	'DE01054130' => 'Süderhöft',
	'DE01054131' => 'Süderlügum',
	'DE01054132' => 'Südermarsch',
	'DE01054134' => 'Tating',
	'DE01054135' => 'Tetenbüll',
	'DE01054136' => 'Tinningstedt',
	'DE01054138' => 'Tönning, Stadt',
	'DE01054140' => 'Tümlauer Koog',
	'DE01054141' => 'Uelvesbüll',
	'DE01054142' => 'Uphusum',
	'DE01054143' => 'Utersum',
	'DE01054144' => 'Viöl',
	'DE01054145' => 'Vollerwiek',
	'DE01054146' => 'Vollstedt',
	'DE01054148' => 'Welt',
	'DE01054149' => 'Wenningstedt-Braderup (Sylt)',
	'DE01054150' => 'Westerhever',
	'DE01054152' => 'Wester-Ohrstedt',
	'DE01054154' => 'Westre',
	'DE01054156' => 'Winnert',
	'DE01054157' => 'Wisch',
	'DE01054158' => 'Witsum',
	'DE01054159' => 'Wittbek',
	'DE01054160' => 'Wittdün auf Amrum',
	'DE01054161' => 'Witzwort',
	'DE01054162' => 'Wobbenbüll',
	'DE01054163' => 'Wrixum',
	'DE01054164' => 'Wyk auf Föhr, Stadt',
	'DE01054165' => 'Galmsbüll',
	'DE01054166' => 'Emmelsbüll-Horsbüll',
	'DE01054167' => 'Enge-Sande',
	'DE01054168' => 'Sylt',
	'DE01055001' => 'Ahrensbök',
	'DE01055002' => 'Altenkrempe',
	'DE01055004' => 'Bad Schwartau, Stadt',
	'DE01055006' => 'Beschendorf',
	'DE01055007' => 'Bosau',
	'DE01055010' => 'Dahme',
	'DE01055011' => 'Damlos',
	'DE01055012' => 'Eutin, Stadt',
	'DE01055014' => 'Göhl',
	'DE01055015' => 'Gremersdorf',
	'DE01055016' => 'Grömitz',
	'DE01055017' => 'Großenbrode',
	'DE01055018' => 'Grube',
	'DE01055020' => 'Harmsdorf',
	'DE01055021' => 'Heiligenhafen, Stadt',
	'DE01055022' => 'Heringsdorf',
	'DE01055023' => 'Kabelhorst',
	'DE01055024' => 'Kasseedorf',
	'DE01055025' => 'Kellenhusen (Ostsee)',
	'DE01055027' => 'Lensahn',
	'DE01055028' => 'Malente',
	'DE01055029' => 'Manhagen',
	'DE01055031' => 'Neukirchen',
	'DE01055032' => 'Neustadt in Holstein, Stadt',
	'DE01055033' => 'Oldenburg in Holstein, Stadt',
	'DE01055035' => 'Ratekau',
	'DE01055036' => 'Riepsdorf',
	'DE01055037' => 'Schashagen',
	'DE01055038' => 'Schönwalde am Bungsberg',
	'DE01055039' => 'Sierksdorf',
	'DE01055040' => 'Stockelsdorf',
	'DE01055041' => 'Süsel',
	'DE01055042' => 'Timmendorfer Strand',
	'DE01055043' => 'Wangels',
	'DE01055044' => 'Scharbeutz',
	'DE01055046' => 'Fehmarn, Stadt',
	'DE01056001' => 'Appen',
	'DE01056002' => 'Barmstedt, Stadt',
	'DE01056003' => 'Bevern',
	'DE01056004' => 'Bilsen',
	'DE01056005' => 'Bönningstedt',
	'DE01056006' => 'Bokel',
	'DE01056008' => 'Bokholt-Hanredder',
	'DE01056009' => 'Borstel-Hohenraden',
	'DE01056010' => 'Brande-Hörnerkirchen',
	'DE01056011' => 'Bullenkuhlen',
	'DE01056013' => 'Ellerbek',
	'DE01056014' => 'Ellerhoop',
	'DE01056015' => 'Elmshorn, Stadt',
	'DE01056016' => 'Groß Nordende',
	'DE01056017' => 'Groß Offenseth-Aspern',
	'DE01056018' => 'Halstenbek',
	'DE01056019' => 'Haselau',
	'DE01056020' => 'Haseldorf',
	'DE01056021' => 'Hasloh',
	'DE01056022' => 'Heede',
	'DE01056023' => 'Heidgraben',
	'DE01056024' => 'Heist',
	'DE01056025' => 'Helgoland',
	'DE01056026' => 'Hemdingen',
	'DE01056027' => 'Hetlingen',
	'DE01056028' => 'Holm',
	'DE01056029' => 'Klein Nordende',
	'DE01056030' => 'Klein Offenseth-Sparrieshoop',
	'DE01056031' => 'Kölln-Reisiek',
	'DE01056032' => 'Kummerfeld',
	'DE01056033' => 'Seester',
	'DE01056034' => 'Langeln',
	'DE01056035' => 'Lutzhorn',
	'DE01056036' => 'Moorrege',
	'DE01056037' => 'Neuendeich',
	'DE01056038' => 'Osterhorn',
	'DE01056039' => 'Pinneberg, Stadt',
	'DE01056040' => 'Prisdorf',
	'DE01056041' => 'Quickborn, Stadt',
	'DE01056042' => 'Raa-Besenbek',
	'DE01056043' => 'Rellingen',
	'DE01056044' => 'Schenefeld, Stadt',
	'DE01056045' => 'Seestermühe',
	'DE01056046' => 'Seeth-Ekholt',
	'DE01056047' => 'Tangstedt',
	'DE01056048' => 'Tornesch, Stadt',
	'DE01056049' => 'Uetersen, Stadt',
	'DE01056050' => 'Wedel, Stadt',
	'DE01056051' => 'Westerhorn',
	'DE01057001' => 'Ascheberg (Holstein)',
	'DE01057002' => 'Barmissen',
	'DE01057003' => 'Barsbek',
	'DE01057004' => 'Behrensdorf (Ostsee)',
	'DE01057005' => 'Belau',
	'DE01057006' => 'Bendfeld',
	'DE01057007' => 'Blekendorf',
	'DE01057008' => 'Bönebüttel',
	'DE01057009' => 'Bösdorf',
	'DE01057010' => 'Boksee',
	'DE01057011' => 'Bothkamp',
	'DE01057012' => 'Brodersdorf',
	'DE01057013' => 'Dannau',
	'DE01057015' => 'Dersau',
	'DE01057016' => 'Dobersdorf',
	'DE01057017' => 'Dörnick',
	'DE01057018' => 'Fahren',
	'DE01057020' => 'Fiefbergen',
	'DE01057021' => 'Giekau',
	'DE01057022' => 'Grebin',
	'DE01057023' => 'Großbarkau',
	'DE01057024' => 'Großharrie',
	'DE01057025' => 'Heikendorf',
	'DE01057026' => 'Helmstorf',
	'DE01057027' => 'Högsdorf',
	'DE01057028' => 'Höhndorf',
	'DE01057029' => 'Hohenfelde',
	'DE01057030' => 'Hohwacht (Ostsee)',
	'DE01057031' => 'Honigsee',
	'DE01057032' => 'Kalübbe',
	'DE01057033' => 'Kirchbarkau',
	'DE01057034' => 'Kirchnüchel',
	'DE01057035' => 'Klamp',
	'DE01057037' => 'Klein Barkau',
	'DE01057038' => 'Kletkamp',
	'DE01057039' => 'Köhn',
	'DE01057040' => 'Krokau',
	'DE01057041' => 'Krummbek',
	'DE01057042' => 'Kühren',
	'DE01057043' => 'Laboe',
	'DE01057044' => 'Lammershagen',
	'DE01057045' => 'Lebrade',
	'DE01057046' => 'Lehmkuhlen',
	'DE01057047' => 'Löptin',
	'DE01057048' => 'Lütjenburg, Stadt',
	'DE01057049' => 'Lutterbek',
	'DE01057050' => 'Martensrade',
	'DE01057051' => 'Mönkeberg',
	'DE01057052' => 'Mucheln',
	'DE01057053' => 'Nehmten',
	'DE01057054' => 'Nettelsee',
	'DE01057055' => 'Panker',
	'DE01057056' => 'Passade',
	'DE01057057' => 'Plön, Stadt',
	'DE01057058' => 'Pohnsdorf',
	'DE01057059' => 'Postfeld',
	'DE01057060' => 'Prasdorf',
	'DE01057062' => 'Preetz, Stadt',
	'DE01057063' => 'Probsteierhagen',
	'DE01057065' => 'Rantzau',
	'DE01057066' => 'Rastorf',
	'DE01057067' => 'Rathjensdorf',
	'DE01057068' => 'Rendswühren',
	'DE01057069' => 'Ruhwinkel',
	'DE01057070' => 'Schellhorn',
	'DE01057071' => 'Schillsdorf',
	'DE01057072' => 'Schlesen',
	'DE01057073' => 'Schönberg (Holstein)',
	'DE01057074' => 'Schönkirchen',
	'DE01057076' => 'Schwartbuck',
	'DE01057077' => 'Selent',
	'DE01057078' => 'Stakendorf',
	'DE01057079' => 'Stein',
	'DE01057080' => 'Stolpe',
	'DE01057081' => 'Stoltenberg',
	'DE01057082' => 'Tröndel',
	'DE01057083' => 'Tasdorf',
	'DE01057084' => 'Wahlstorf',
	'DE01057085' => 'Wankendorf',
	'DE01057086' => 'Warnau',
	'DE01057087' => 'Wendtorf',
	'DE01057088' => 'Wisch',
	'DE01057089' => 'Wittmoldt',
	'DE01057090' => 'Fargau-Pratjau',
	'DE01057091' => 'Schwentinental, Stadt',
	'DE01058001' => 'Achterwehr',
	'DE01058003' => 'Alt Duvenstedt',
	'DE01058004' => 'Altenhof',
	'DE01058005' => 'Altenholz',
	'DE01058007' => 'Arpsdorf',
	'DE01058008' => 'Ascheffel',
	'DE01058009' => 'Aukrug',
	'DE01058010' => 'Bargstall',
	'DE01058011' => 'Bargstedt',
	'DE01058012' => 'Barkelsby',
	'DE01058013' => 'Beldorf',
	'DE01058014' => 'Bendorf',
	'DE01058015' => 'Beringstedt',
	'DE01058016' => 'Bissee',
	'DE01058018' => 'Blumenthal',
	'DE01058019' => 'Böhnhusen',
	'DE01058021' => 'Bokel',
	'DE01058022' => 'Bordesholm',
	'DE01058023' => 'Borgdorf-Seedorf',
	'DE01058024' => 'Borgstedt',
	'DE01058025' => 'Bornholt',
	'DE01058026' => 'Bovenau',
	'DE01058027' => 'Brammer',
	'DE01058028' => 'Bredenbek',
	'DE01058029' => 'Breiholz',
	'DE01058030' => 'Brekendorf',
	'DE01058031' => 'Brinjahe',
	'DE01058032' => 'Brodersby',
	'DE01058033' => 'Brügge',
	'DE01058034' => 'Büdelsdorf, Stadt',
	'DE01058035' => 'Bünsdorf',
	'DE01058036' => 'Christiansholm',
	'DE01058037' => 'Dänischenhagen',
	'DE01058038' => 'Dätgen',
	'DE01058039' => 'Damendorf',
	'DE01058040' => 'Damp',
	'DE01058042' => 'Dörphof',
	'DE01058043' => 'Eckernförde, Stadt',
	'DE01058044' => 'Ehndorf',
	'DE01058045' => 'Eisendorf',
	'DE01058046' => 'Ellerdorf',
	'DE01058047' => 'Elsdorf-Westermühlen',
	'DE01058048' => 'Embühren',
	'DE01058049' => 'Emkendorf',
	'DE01058050' => 'Felde',
	'DE01058051' => 'Felm',
	'DE01058052' => 'Fleckeby',
	'DE01058053' => 'Flintbek',
	'DE01058054' => 'Fockbek',
	'DE01058055' => 'Friedrichsgraben',
	'DE01058056' => 'Friedrichsholm',
	'DE01058057' => 'Gammelby',
	'DE01058058' => 'Gettorf',
	'DE01058059' => 'Gnutz',
	'DE01058061' => 'Gokels',
	'DE01058062' => 'Grauel',
	'DE01058063' => 'Grevenkrug',
	'DE01058064' => 'Groß Buchwald',
	'DE01058065' => 'Groß Vollstedt',
	'DE01058066' => 'Groß Wittensee',
	'DE01058067' => 'Güby',
	'DE01058068' => 'Haale',
	'DE01058069' => 'Haby',
	'DE01058070' => 'Hamdorf',
	'DE01058071' => 'Hamweddel',
	'DE01058072' => 'Hanerau-Hademarschen',
	'DE01058073' => 'Haßmoor',
	'DE01058074' => 'Heinkenborstel',
	'DE01058075' => 'Hörsten',
	'DE01058076' => 'Hoffeld',
	'DE01058077' => 'Hohenwestedt',
	'DE01058078' => 'Hohn',
	'DE01058080' => 'Holtsee',
	'DE01058081' => 'Holzbunge',
	'DE01058082' => 'Holzdorf',
	'DE01058083' => 'Hütten',
	'DE01058084' => 'Hummelfeld',
	'DE01058085' => 'Jahrsdorf',
	'DE01058086' => 'Jevenstedt',
	'DE01058087' => 'Karby',
	'DE01058088' => 'Klein Wittensee',
	'DE01058089' => 'Königshügel',
	'DE01058090' => 'Kosel',
	'DE01058091' => 'Krogaspe',
	'DE01058092' => 'Kronshagen',
	'DE01058093' => 'Krummwisch',
	'DE01058094' => 'Langwedel',
	'DE01058096' => 'Lindau',
	'DE01058097' => 'Lohe-Föhrden',
	'DE01058098' => 'Loop',
	'DE01058099' => 'Loose',
	'DE01058100' => 'Lütjenwestedt',
	'DE01058101' => 'Luhnstedt',
	'DE01058102' => 'Goosefeld',
	'DE01058103' => 'Meezen',
	'DE01058104' => 'Melsdorf',
	'DE01058105' => 'Mielkendorf',
	'DE01058106' => 'Mörel',
	'DE01058107' => 'Molfsee',
	'DE01058108' => 'Mühbrook',
	'DE01058109' => 'Negenharrie',
	'DE01058110' => 'Neudorf-Bornstein',
	'DE01058111' => 'Neu Duvenstedt',
	'DE01058112' => 'Neuwittenbek',
	'DE01058113' => 'Nienborstel',
	'DE01058115' => 'Nindorf',
	'DE01058116' => 'Noer',
	'DE01058117' => 'Nortorf, Stadt',
	'DE01058118' => 'Nübbel',
	'DE01058119' => 'Oldenbüttel',
	'DE01058120' => 'Oldenhütten',
	'DE01058121' => 'Osdorf',
	'DE01058122' => 'Ostenfeld (Rendsburg)',
	'DE01058123' => 'Osterby',
	'DE01058124' => 'Osterrönfeld',
	'DE01058125' => 'Osterstedt',
	'DE01058126' => 'Ottendorf',
	'DE01058127' => 'Owschlag',
	'DE01058128' => 'Padenstedt',
	'DE01058129' => 'Prinzenmoor',
	'DE01058130' => 'Quarnbek',
	'DE01058131' => 'Rade b. Hohenwestedt',
	'DE01058132' => 'Rade b. Rendsburg',
	'DE01058133' => 'Reesdorf',
	'DE01058134' => 'Remmels',
	'DE01058135' => 'Rendsburg, Stadt',
	'DE01058136' => 'Rickert',
	'DE01058137' => 'Rieseby',
	'DE01058138' => 'Rodenbek',
	'DE01058139' => 'Rumohr',
	'DE01058140' => 'Schacht-Audorf',
	'DE01058141' => 'Schierensee',
	'DE01058142' => 'Schinkel',
	'DE01058143' => 'Schmalstede',
	'DE01058144' => 'Schönbek',
	'DE01058145' => 'Schönhorst',
	'DE01058146' => 'Schülldorf',
	'DE01058147' => 'Schülp b. Nortorf',
	'DE01058148' => 'Schülp b. Rendsburg',
	'DE01058150' => 'Schwedeneck',
	'DE01058151' => 'Seefeld',
	'DE01058152' => 'Sehestedt',
	'DE01058153' => 'Sören',
	'DE01058154' => 'Sophienhamm',
	'DE01058155' => 'Stafstedt',
	'DE01058156' => 'Steenfeld',
	'DE01058157' => 'Strande',
	'DE01058158' => 'Tackesdorf',
	'DE01058159' => 'Tappendorf',
	'DE01058160' => 'Techelsdorf',
	'DE01058161' => 'Thaden',
	'DE01058162' => 'Thumby',
	'DE01058163' => 'Timmaspe',
	'DE01058164' => 'Todenbüttel',
	'DE01058165' => 'Tüttendorf',
	'DE01058166' => 'Waabs',
	'DE01058167' => 'Wapelfeld',
	'DE01058168' => 'Warder',
	'DE01058169' => 'Wasbek',
	'DE01058170' => 'Wattenbek',
	'DE01058171' => 'Westensee',
	'DE01058172' => 'Westerrönfeld',
	'DE01058173' => 'Windeby',
	'DE01058174' => 'Winnemark',
	'DE01058175' => 'Ahlefeld-Bistensee',
	'DE01059001' => 'Alt Bennebek',
	'DE01059002' => 'Arnis, Stadt',
	'DE01059005' => 'Bergenhusen',
	'DE01059006' => 'Böel',
	'DE01059008' => 'Böklund',
	'DE01059009' => 'Börm',
	'DE01059010' => 'Bollingstedt',
	'DE01059012' => 'Borgwedel',
	'DE01059018' => 'Busdorf',
	'DE01059019' => 'Dannewerk',
	'DE01059020' => 'Dörpstedt',
	'DE01059023' => 'Ellingstedt',
	'DE01059024' => 'Erfde',
	'DE01059026' => 'Fahrdorf',
	'DE01059032' => 'Geltorf',
	'DE01059034' => 'Grödersby',
	'DE01059035' => 'Groß Rheide',
	'DE01059037' => 'Havetoft',
	'DE01059039' => 'Hollingstedt',
	'DE01059041' => 'Hüsby',
	'DE01059042' => 'Idstedt',
	'DE01059043' => 'Jagel',
	'DE01059044' => 'Jübek',
	'DE01059045' => 'Kappeln, Stadt',
	'DE01059049' => 'Klappholz',
	'DE01059050' => 'Klein Bennebek',
	'DE01059051' => 'Klein Rheide',
	'DE01059053' => 'Kropp',
	'DE01059055' => 'Loit',
	'DE01059056' => 'Lottorf',
	'DE01059057' => 'Lürschau',
	'DE01059058' => 'Meggerdorf',
	'DE01059060' => 'Mohrkirch',
	'DE01059062' => 'Neuberend',
	'DE01059063' => 'Norderbrarup',
	'DE01059065' => 'Nottfeld',
	'DE01059067' => 'Oersberg',
	'DE01059068' => 'Rabenkirchen-Faulück',
	'DE01059070' => 'Rügge',
	'DE01059072' => 'Saustrup',
	'DE01059073' => 'Schaalby',
	'DE01059074' => 'Scheggerott',
	'DE01059075' => 'Schleswig, Stadt',
	'DE01059076' => 'Schnarup-Thumby',
	'DE01059077' => 'Schuby',
	'DE01059078' => 'Selk',
	'DE01059079' => 'Silberstedt',
	'DE01059080' => 'Steinfeld',
	'DE01059081' => 'Stolk',
	'DE01059082' => 'Struxdorf',
	'DE01059083' => 'Süderbrarup',
	'DE01059084' => 'Süderfahrenstedt',
	'DE01059086' => 'Taarstedt',
	'DE01059087' => 'Tetenhusen',
	'DE01059088' => 'Tielen',
	'DE01059090' => 'Tolk',
	'DE01059092' => 'Treia',
	'DE01059093' => 'Uelsby',
	'DE01059094' => 'Ulsnis',
	'DE01059095' => 'Wagersrott',
	'DE01059096' => 'Wohlde',
	'DE01059097' => 'Twedt',
	'DE01059098' => 'Nübel',
	'DE01059101' => 'Tastrup',
	'DE01059102' => 'Ahneby',
	'DE01059103' => 'Ausacker',
	'DE01059105' => 'Böxlund',
	'DE01059106' => 'Dollerup',
	'DE01059107' => 'Eggebek',
	'DE01059109' => 'Esgrus',
	'DE01059112' => 'Gelting',
	'DE01059113' => 'Glücksburg (Ostsee), Stadt',
	'DE01059115' => 'Großenwiehe',
	'DE01059116' => 'Großsolt',
	'DE01059118' => 'Grundhof',
	'DE01059120' => 'Harrislee',
	'DE01059121' => 'Hasselberg',
	'DE01059123' => 'Hörup',
	'DE01059124' => 'Holt',
	'DE01059126' => 'Hürup',
	'DE01059127' => 'Husby',
	'DE01059128' => 'Janneby',
	'DE01059129' => 'Jardelund',
	'DE01059131' => 'Jerrishoe',
	'DE01059132' => 'Jörl',
	'DE01059136' => 'Kronsgaard',
	'DE01059137' => 'Langballig',
	'DE01059138' => 'Langstedt',
	'DE01059141' => 'Maasbüll',
	'DE01059142' => 'Maasholm',
	'DE01059143' => 'Medelby',
	'DE01059144' => 'Meyn',
	'DE01059145' => 'Munkbrarup',
	'DE01059147' => 'Nieby',
	'DE01059148' => 'Niesgrau',
	'DE01059149' => 'Nordhackstedt',
	'DE01059151' => 'Osterby',
	'DE01059152' => 'Pommerby',
	'DE01059154' => 'Rabel',
	'DE01059155' => 'Rabenholz',
	'DE01059157' => 'Ringsberg',
	'DE01059158' => 'Schafflund',
	'DE01059159' => 'Sieverstedt',
	'DE01059161' => 'Sörup',
	'DE01059162' => 'Sollerup',
	'DE01059163' => 'Stangheck',
	'DE01059164' => 'Steinberg',
	'DE01059167' => 'Sterup',
	'DE01059168' => 'Stoltebüll',
	'DE01059169' => 'Süderhackstedt',
	'DE01059171' => 'Tarp',
	'DE01059173' => 'Wallsbüll',
	'DE01059174' => 'Wanderup',
	'DE01059176' => 'Wees',
	'DE01059177' => 'Weesby',
	'DE01059178' => 'Westerholz',
	'DE01059179' => 'Lindewitt',
	'DE01059182' => 'Freienwill',
	'DE01059183' => 'Handewitt',
	'DE01059184' => 'Oeversee',
	'DE01059185' => 'Mittelangeln',
	'DE01059186' => 'Steinbergkirche',
	'DE01059187' => 'Boren',
	'DE01059188' => 'Stapel',
	'DE01059189' => 'Brodersby-Goltoft',
	'DE01060002' => 'Alveslohe',
	'DE01060003' => 'Armstedt',
	'DE01060004' => 'Bad Bramstedt, Stadt',
	'DE01060005' => 'Bad Segeberg, Stadt',
	'DE01060006' => 'Bahrenhof',
	'DE01060007' => 'Bark',
	'DE01060008' => 'Bebensee',
	'DE01060009' => 'Bimöhlen',
	'DE01060010' => 'Blunk',
	'DE01060011' => 'Boostedt',
	'DE01060012' => 'Bornhöved',
	'DE01060013' => 'Borstel',
	'DE01060014' => 'Buchholz (Forstgutsbez.),gemfr. Gebiet',
	'DE01060015' => 'Bühnsdorf',
	'DE01060016' => 'Daldorf',
	'DE01060017' => 'Damsdorf',
	'DE01060018' => 'Dreggers',
	'DE01060019' => 'Ellerau',
	'DE01060020' => 'Fahrenkrug',
	'DE01060021' => 'Föhrden-Barl',
	'DE01060022' => 'Fredesdorf',
	'DE01060023' => 'Fuhlendorf',
	'DE01060024' => 'Geschendorf',
	'DE01060025' => 'Glasau',
	'DE01060026' => 'Gönnebek',
	'DE01060027' => 'Großenaspe',
	'DE01060028' => 'Groß Kummerfeld',
	'DE01060029' => 'Groß Niendorf',
	'DE01060030' => 'Groß Rönnau',
	'DE01060031' => 'Hagen',
	'DE01060033' => 'Hardebek',
	'DE01060034' => 'Hartenholm',
	'DE01060035' => 'Hasenkrug',
	'DE01060036' => 'Hasenmoor',
	'DE01060037' => 'Heidmoor',
	'DE01060038' => 'Heidmühlen',
	'DE01060039' => 'Henstedt-Ulzburg',
	'DE01060040' => 'Hitzhusen',
	'DE01060041' => 'Högersdorf',
	'DE01060042' => 'Hüttblek',
	'DE01060043' => 'Itzstedt',
	'DE01060044' => 'Kaltenkirchen, Stadt',
	'DE01060045' => 'Kattendorf',
	'DE01060046' => 'Kayhude',
	'DE01060047' => 'Kisdorf',
	'DE01060048' => 'Klein Gladebrügge',
	'DE01060049' => 'Klein Rönnau',
	'DE01060050' => 'Krems II',
	'DE01060051' => 'Kükels',
	'DE01060052' => 'Latendorf',
	'DE01060053' => 'Leezen',
	'DE01060054' => 'Lentföhrden',
	'DE01060056' => 'Mönkloh',
	'DE01060057' => 'Mözen',
	'DE01060058' => 'Nahe',
	'DE01060059' => 'Negernbötel',
	'DE01060060' => 'Nehms',
	'DE01060061' => 'Neuengörs',
	'DE01060062' => 'Neversdorf',
	'DE01060063' => 'Norderstedt, Stadt',
	'DE01060064' => 'Nützen',
	'DE01060065' => 'Oering',
	'DE01060066' => 'Oersdorf',
	'DE01060067' => 'Pronstorf',
	'DE01060068' => 'Rickling',
	'DE01060069' => 'Rohlstorf',
	'DE01060070' => 'Schackendorf',
	'DE01060071' => 'Schieren',
	'DE01060072' => 'Schmalensee',
	'DE01060073' => 'Schmalfeld',
	'DE01060074' => 'Schwissel',
	'DE01060075' => 'Seedorf',
	'DE01060076' => 'Seth',
	'DE01060077' => 'Sievershütten',
	'DE01060079' => 'Stipsdorf',
	'DE01060080' => 'Stocksee',
	'DE01060081' => 'Strukdorf',
	'DE01060082' => 'Struvenhütten',
	'DE01060084' => 'Stuvenborn',
	'DE01060085' => 'Sülfeld',
	'DE01060086' => 'Tarbek',
	'DE01060087' => 'Tensfeld',
	'DE01060088' => 'Todesfelde',
	'DE01060089' => 'Trappenkamp',
	'DE01060090' => 'Travenhorst',
	'DE01060091' => 'Traventhal',
	'DE01060092' => 'Wahlstedt, Stadt',
	'DE01060093' => 'Wakendorf I',
	'DE01060094' => 'Wakendorf II',
	'DE01060095' => 'Weddelbrook',
	'DE01060096' => 'Weede',
	'DE01060097' => 'Wensin',
	'DE01060098' => 'Westerrade',
	'DE01060099' => 'Wiemersdorf',
	'DE01060100' => 'Winsen',
	'DE01060101' => 'Wittenborn',
	'DE01061001' => 'Aasbüttel',
	'DE01061002' => 'Aebtissinwisch',
	'DE01061003' => 'Agethorst',
	'DE01061004' => 'Altenmoor',
	'DE01061005' => 'Auufer',
	'DE01061006' => 'Bahrenfleth',
	'DE01061007' => 'Beidenfleth',
	'DE01061008' => 'Bekdorf',
	'DE01061010' => 'Bekmünde',
	'DE01061011' => 'Besdorf',
	'DE01061012' => 'Blomesche Wildnis',
	'DE01061013' => 'Bokelrehm',
	'DE01061014' => 'Bokhorst',
	'DE01061015' => 'Borsfleth',
	'DE01061016' => 'Breitenberg',
	'DE01061017' => 'Breitenburg',
	'DE01061018' => 'Brokdorf',
	'DE01061019' => 'Brokstedt',
	'DE01061020' => 'Büttel',
	'DE01061021' => 'Christinenthal',
	'DE01061022' => 'Dägeling',
	'DE01061023' => 'Dammfleth',
	'DE01061024' => 'Drage',
	'DE01061025' => 'Ecklak',
	'DE01061026' => 'Elskop',
	'DE01061027' => 'Engelbrechtsche Wildnis',
	'DE01061028' => 'Fitzbek',
	'DE01061029' => 'Glückstadt, Stadt',
	'DE01061030' => 'Grevenkop',
	'DE01061031' => 'Gribbohm',
	'DE01061033' => 'Hadenfeld',
	'DE01061034' => 'Heiligenstedten',
	'DE01061035' => 'Heiligenstedtenerkamp',
	'DE01061036' => 'Hennstedt',
	'DE01061037' => 'Herzhorn',
	'DE01061038' => 'Hingstheide',
	'DE01061039' => 'Hodorf',
	'DE01061040' => 'Hohenaspe',
	'DE01061041' => 'Hohenfelde',
	'DE01061042' => 'Hohenlockstedt',
	'DE01061043' => 'Holstenniendorf',
	'DE01061044' => 'Horst (Holstein)',
	'DE01061045' => 'Huje',
	'DE01061046' => 'Itzehoe, Stadt',
	'DE01061047' => 'Kaaks',
	'DE01061048' => 'Kaisborstel',
	'DE01061049' => 'Kellinghusen, Stadt',
	'DE01061050' => 'Kiebitzreihe',
	'DE01061052' => 'Kleve',
	'DE01061053' => 'Kollmoor',
	'DE01061054' => 'Krempdorf',
	'DE01061055' => 'Krempe, Stadt',
	'DE01061056' => 'Kremperheide',
	'DE01061057' => 'Krempermoor',
	'DE01061058' => 'Kronsmoor',
	'DE01061059' => 'Krummendiek',
	'DE01061060' => 'Kudensee',
	'DE01061061' => 'Lägerdorf',
	'DE01061062' => 'Landrecht',
	'DE01061063' => 'Landscheide',
	'DE01061064' => 'Lockstedt',
	'DE01061065' => 'Lohbarbek',
	'DE01061066' => 'Looft',
	'DE01061067' => 'Mehlbek',
	'DE01061068' => 'Moordiek',
	'DE01061070' => 'Moorhusen',
	'DE01061071' => 'Mühlenbarbek',
	'DE01061072' => 'Münsterdorf',
	'DE01061073' => 'Neuenbrook',
	'DE01061074' => 'Neuendorf b. Elmshorn',
	'DE01061076' => 'Nienbüttel',
	'DE01061077' => 'Nortorf',
	'DE01061078' => 'Nutteln',
	'DE01061079' => 'Oelixdorf',
	'DE01061080' => 'Oeschebüttel',
	'DE01061081' => 'Oldenborstel',
	'DE01061082' => 'Oldendorf',
	'DE01061083' => 'Ottenbüttel',
	'DE01061084' => 'Peissen',
	'DE01061085' => 'Pöschendorf',
	'DE01061086' => 'Poyenberg',
	'DE01061087' => 'Puls',
	'DE01061088' => 'Quarnstedt',
	'DE01061089' => 'Rade',
	'DE01061091' => 'Reher',
	'DE01061092' => 'Rethwisch',
	'DE01061093' => 'Rosdorf',
	'DE01061095' => 'Sankt Margarethen',
	'DE01061096' => 'Sarlhusen',
	'DE01061097' => 'Schenefeld',
	'DE01061098' => 'Schlotfeld',
	'DE01061100' => 'Silzen',
	'DE01061101' => 'Sommerland',
	'DE01061102' => 'Stördorf',
	'DE01061103' => 'Störkathen',
	'DE01061104' => 'Süderau',
	'DE01061105' => 'Vaale',
	'DE01061106' => 'Vaalermoor',
	'DE01061107' => 'Wacken',
	'DE01061108' => 'Warringholz',
	'DE01061109' => 'Westermoor',
	'DE01061110' => 'Wewelsfleth',
	'DE01061111' => 'Wiedenborstel',
	'DE01061112' => 'Willenscharen',
	'DE01061113' => 'Wilster, Stadt',
	'DE01061114' => 'Winseldorf',
	'DE01061115' => 'Wittenbergen',
	'DE01061116' => 'Wrist',
	'DE01061117' => 'Wulfsmoor',
	'DE01061118' => 'Kollmar',
	'DE01061119' => 'Neuendorf-Sachsenbande',
	'DE01062001' => 'Ahrensburg, Stadt',
	'DE01062003' => 'Badendorf',
	'DE01062004' => 'Bad Oldesloe, Stadt',
	'DE01062005' => 'Bargfeld-Stegen',
	'DE01062006' => 'Bargteheide, Stadt',
	'DE01062008' => 'Barnitz',
	'DE01062009' => 'Barsbüttel',
	'DE01062011' => 'Braak',
	'DE01062014' => 'Delingsdorf',
	'DE01062016' => 'Elmenhorst',
	'DE01062018' => 'Glinde, Stadt',
	'DE01062019' => 'Grabau',
	'DE01062020' => 'Grande',
	'DE01062021' => 'Grönwohld',
	'DE01062022' => 'Großensee',
	'DE01062023' => 'Großhansdorf',
	'DE01062025' => 'Hamberge',
	'DE01062026' => 'Hamfelde',
	'DE01062027' => 'Hammoor',
	'DE01062031' => 'Heidekamp',
	'DE01062032' => 'Heilshoop',
	'DE01062033' => 'Hohenfelde',
	'DE01062035' => 'Hoisdorf',
	'DE01062036' => 'Jersbek',
	'DE01062039' => 'Klein Wesenberg',
	'DE01062040' => 'Köthel',
	'DE01062045' => 'Lütjensee',
	'DE01062046' => 'Meddewade',
	'DE01062048' => 'Mönkhagen',
	'DE01062050' => 'Neritz',
	'DE01062051' => 'Nienwohld',
	'DE01062053' => 'Oststeinbek',
	'DE01062056' => 'Pölitz',
	'DE01062058' => 'Rausdorf',
	'DE01062059' => 'Rehhorst',
	'DE01062060' => 'Reinbek, Stadt',
	'DE01062061' => 'Reinfeld (Holstein), Stadt',
	'DE01062062' => 'Rethwisch',
	'DE01062065' => 'Rümpel',
	'DE01062069' => 'Siek',
	'DE01062071' => 'Stapelfeld',
	'DE01062076' => 'Tangstedt',
	'DE01062078' => 'Todendorf',
	'DE01062081' => 'Tremsbüttel',
	'DE01062082' => 'Trittau',
	'DE01062083' => 'Westerau',
	'DE01062086' => 'Witzhave',
	'DE01062087' => 'Zarpen',
	'DE01062088' => 'Brunsbek',
	'DE01062089' => 'Lasbek',
	'DE01062090' => 'Ammersbek',
	'DE01062091' => 'Steinburg',
	'DE01062092' => 'Travenbrück',
	'DE01062093' => 'Feldhorst',
	'DE01062094' => 'Wesenberg',
	'DE02000000' => 'Hamburg, Freie und Hansestadt',
	'DE03101000' => 'Braunschweig, Stadt',
	'DE03102000' => 'Salzgitter, Stadt',
	'DE03103000' => 'Wolfsburg, Stadt',
	'DE03151001' => 'Adenbüttel',
	'DE03151002' => 'Barwedel',
	'DE03151003' => 'Bergfeld',
	'DE03151004' => 'Bokensdorf',
	'DE03151005' => 'Brome, Flecken',
	'DE03151006' => 'Calberlah',
	'DE03151007' => 'Dedelstorf',
	'DE03151008' => 'Ehra-Lessien',
	'DE03151009' => 'Gifhorn, Stadt',
	'DE03151010' => 'Groß Oesingen',
	'DE03151011' => 'Hankensbüttel',
	'DE03151012' => 'Hillerse',
	'DE03151013' => 'Isenbüttel',
	'DE03151014' => 'Jembke',
	'DE03151015' => 'Leiferde',
	'DE03151016' => 'Meine',
	'DE03151017' => 'Meinersen',
	'DE03151018' => 'Müden (Aller)',
	'DE03151019' => 'Obernholz',
	'DE03151020' => 'Osloß',
	'DE03151021' => 'Parsau',
	'DE03151022' => 'Ribbesbüttel',
	'DE03151023' => 'Rötgesbüttel',
	'DE03151024' => 'Rühen',
	'DE03151025' => 'Sassenburg',
	'DE03151026' => 'Schönewörde',
	'DE03151027' => 'Schwülper',
	'DE03151028' => 'Sprakensehl',
	'DE03151029' => 'Steinhorst',
	'DE03151030' => 'Tappenbeck',
	'DE03151031' => 'Tiddische',
	'DE03151032' => 'Tülau',
	'DE03151033' => 'Ummern',
	'DE03151034' => 'Vordorf',
	'DE03151035' => 'Wagenhoff',
	'DE03151036' => 'Wahrenholz',
	'DE03151037' => 'Wasbüttel',
	'DE03151038' => 'Wesendorf',
	'DE03151039' => 'Weyhausen',
	'DE03151040' => 'Wittingen, Stadt',
	'DE03151041' => 'Didderse',
	'DE03151501' => 'Giebel, gemfr. Gebiet',
	'DE03153002' => 'Bad Harzburg, Stadt',
	'DE03153006' => 'Hahausen',
	'DE03153007' => 'Langelsheim, Stadt',
	'DE03153008' => 'Liebenburg',
	'DE03153009' => 'Lutter am Barenberge, Flecken',
	'DE03153012' => 'Seesen, Stadt',
	'DE03153014' => 'Wallmoden',
	'DE03153016' => 'Braunlage, Stadt',
	'DE03153017' => 'Goslar, Stadt',
	'DE03153018' => 'Clausthal-Zellerfeld, Berg- und Universitätsstadt',
	'DE03153504' => 'Harz (Landkreis Goslar), gemfr. Gebiet',
	'DE03154001' => 'Bahrdorf',
	'DE03154002' => 'Beierstedt',
	'DE03154004' => 'Danndorf',
	'DE03154005' => 'Frellstedt',
	'DE03154006' => 'Gevensleben',
	'DE03154007' => 'Grafhorst',
	'DE03154008' => 'Grasleben',
	'DE03154009' => 'Groß Twülpstedt',
	'DE03154012' => 'Jerxheim',
	'DE03154013' => 'Königslutter am Elm, Stadt',
	'DE03154014' => 'Lehre',
	'DE03154015' => 'Mariental',
	'DE03154016' => 'Querenhorst',
	'DE03154017' => 'Räbke',
	'DE03154018' => 'Rennau',
	'DE03154019' => 'Schöningen, Stadt',
	'DE03154021' => 'Süpplingen',
	'DE03154022' => 'Süpplingenburg',
	'DE03154024' => 'Velpke',
	'DE03154025' => 'Warberg',
	'DE03154026' => 'Wolsdorf',
	'DE03154027' => 'Söllingen',
	'DE03154028' => 'Helmstedt, Stadt',
	'DE03154501' => 'Brunsleberfeld, gemfr. Gebiet',
	'DE03154502' => 'Helmstedt, gemfr. Gebiet',
	'DE03154503' => 'Königslutter, gemfr. Gebiet',
	'DE03154504' => 'Mariental, gemfr. Gebiet',
	'DE03154506' => 'Schöningen, gemfr. Gebiet',
	'DE03155001' => 'Bad Gandersheim, Stadt',
	'DE03155002' => 'Bodenfelde, Flecken',
	'DE03155003' => 'Dassel, Stadt',
	'DE03155005' => 'Hardegsen, Stadt',
	'DE03155006' => 'Kalefeld',
	'DE03155007' => 'Katlenburg-Lindau',
	'DE03155009' => 'Moringen, Stadt',
	'DE03155010' => 'Nörten-Hardenberg, Flecken',
	'DE03155011' => 'Northeim, Stadt',
	'DE03155012' => 'Uslar, Stadt',
	'DE03155013' => 'Einbeck, Stadt',
	'DE03155501' => 'Solling (Landkreis Northeim), gemfr. Geb.',
	'DE03157001' => 'Edemissen',
	'DE03157002' => 'Hohenhameln',
	'DE03157005' => 'Lengede',
	'DE03157006' => 'Peine, Stadt',
	'DE03157007' => 'Vechelde',
	'DE03157008' => 'Wendeburg',
	'DE03157009' => 'Ilsede',
	'DE03158002' => 'Baddeckenstedt',
	'DE03158004' => 'Burgdorf',
	'DE03158005' => 'Cramme',
	'DE03158006' => 'Cremlingen',
	'DE03158007' => 'Dahlum',
	'DE03158008' => 'Denkte',
	'DE03158009' => 'Dettum',
	'DE03158010' => 'Dorstadt',
	'DE03158011' => 'Elbe',
	'DE03158012' => 'Erkerode',
	'DE03158013' => 'Evessen',
	'DE03158014' => 'Flöthe',
	'DE03158016' => 'Haverlah',
	'DE03158017' => 'Hedeper',
	'DE03158018' => 'Heere',
	'DE03158019' => 'Heiningen',
	'DE03158021' => 'Kissenbrück',
	'DE03158022' => 'Kneitlingen',
	'DE03158023' => 'Ohrum',
	'DE03158025' => 'Roklum',
	'DE03158027' => 'Schöppenstedt, Stadt',
	'DE03158028' => 'Sehlde',
	'DE03158030' => 'Sickte',
	'DE03158031' => 'Uehrde',
	'DE03158032' => 'Vahlberg',
	'DE03158033' => 'Veltheim (Ohe)',
	'DE03158035' => 'Winnigstedt',
	'DE03158036' => 'Wittmar',
	'DE03158037' => 'Wolfenbüttel, Stadt',
	'DE03158038' => 'Börßum',
	'DE03158039' => 'Schladen-Werla',
	'DE03158040' => 'Remlingen-Semmenstedt',
	'DE03158501' => 'Am Großen Rhode, gemfr. Gebiet',
	'DE03158502' => 'Barnstorf-Warle, gemfr. Gebiet',
	'DE03158503' => 'Voigtsdahlum, gemfr. Gebiet',
	'DE03159001' => 'Adelebsen, Flecken',
	'DE03159002' => 'Bad Grund (Harz)',
	'DE03159003' => 'Bad Lauterberg im Harz, Stadt',
	'DE03159004' => 'Bad Sachsa, Stadt',
	'DE03159005' => 'Bilshausen',
	'DE03159006' => 'Bodensee',
	'DE03159007' => 'Bovenden, Flecken',
	'DE03159008' => 'Bühren',
	'DE03159009' => 'Dransfeld, Stadt',
	'DE03159010' => 'Duderstadt, Stadt',
	'DE03159011' => 'Ebergötzen',
	'DE03159012' => 'Elbingerode',
	'DE03159013' => 'Friedland',
	'DE03159014' => 'Gieboldehausen, Flecken',
	'DE03159015' => 'Gleichen',
	'DE03159016' => 'Göttingen, Stadt',
	'DE03159017' => 'Hann. Münden, Stadt',
	'DE03159018' => 'Hattorf am Harz',
	'DE03159019' => 'Herzberg am Harz, Stadt',
	'DE03159020' => 'Hörden am Harz',
	'DE03159021' => 'Jühnde',
	'DE03159022' => 'Krebeck',
	'DE03159023' => 'Landolfshausen',
	'DE03159024' => 'Niemetal',
	'DE03159025' => 'Obernfeld',
	'DE03159026' => 'Osterode am Harz, Stadt',
	'DE03159027' => 'Rhumspringe',
	'DE03159028' => 'Rollshausen',
	'DE03159029' => 'Rosdorf',
	'DE03159030' => 'Rüdershausen',
	'DE03159031' => 'Scheden',
	'DE03159032' => 'Seeburg',
	'DE03159033' => 'Seulingen',
	'DE03159034' => 'Staufenberg',
	'DE03159035' => 'Waake',
	'DE03159036' => 'Walkenried',
	'DE03159037' => 'Wollbrandshausen',
	'DE03159038' => 'Wollershausen',
	'DE03159039' => 'Wulften am Harz',
	'DE03159501' => 'Harz (Ldkr. Göttingen), gemfr. Geb.',
	'DE03241001' => 'Hannover, Landeshauptstadt',
	'DE03241002' => 'Barsinghausen, Stadt',
	'DE03241003' => 'Burgdorf, Stadt',
	'DE03241004' => 'Burgwedel, Stadt',
	'DE03241005' => 'Garbsen, Stadt',
	'DE03241006' => 'Gehrden, Stadt',
	'DE03241007' => 'Hemmingen, Stadt',
	'DE03241008' => 'Isernhagen',
	'DE03241009' => 'Laatzen, Stadt',
	'DE03241010' => 'Langenhagen, Stadt',
	'DE03241011' => 'Lehrte, Stadt',
	'DE03241012' => 'Neustadt am Rübenberge, Stadt',
	'DE03241013' => 'Pattensen, Stadt',
	'DE03241014' => 'Ronnenberg, Stadt',
	'DE03241015' => 'Seelze, Stadt',
	'DE03241016' => 'Sehnde, Stadt',
	'DE03241017' => 'Springe, Stadt',
	'DE03241018' => 'Uetze',
	'DE03241019' => 'Wedemark',
	'DE03241020' => 'Wennigsen (Deister)',
	'DE03241021' => 'Wunstorf, Stadt',
	'DE03251001' => 'Affinghausen',
	'DE03251002' => 'Asendorf',
	'DE03251003' => 'Bahrenborstel',
	'DE03251004' => 'Barenburg, Flecken',
	'DE03251005' => 'Barnstorf, Flecken',
	'DE03251006' => 'Barver',
	'DE03251007' => 'Bassum, Stadt',
	'DE03251008' => 'Borstel',
	'DE03251009' => 'Brockum',
	'DE03251011' => 'Dickel',
	'DE03251012' => 'Diepholz, Stadt',
	'DE03251013' => 'Drebber',
	'DE03251014' => 'Drentwede',
	'DE03251015' => 'Ehrenburg',
	'DE03251017' => 'Eydelstedt',
	'DE03251018' => 'Freistatt',
	'DE03251019' => 'Hemsloh',
	'DE03251020' => 'Hüde',
	'DE03251021' => 'Kirchdorf',
	'DE03251022' => 'Lembruch',
	'DE03251023' => 'Lemförde, Flecken',
	'DE03251024' => 'Maasen',
	'DE03251025' => 'Marl',
	'DE03251026' => 'Martfeld',
	'DE03251027' => 'Mellinghausen',
	'DE03251028' => 'Neuenkirchen',
	'DE03251029' => 'Quernheim',
	'DE03251030' => 'Rehden',
	'DE03251031' => 'Scholen',
	'DE03251032' => 'Schwaförden',
	'DE03251033' => 'Schwarme',
	'DE03251034' => 'Siedenburg, Flecken',
	'DE03251035' => 'Staffhorst',
	'DE03251036' => 'Stemshorn',
	'DE03251037' => 'Stuhr',
	'DE03251038' => 'Sudwalde',
	'DE03251040' => 'Sulingen, Stadt',
	'DE03251041' => 'Syke, Stadt',
	'DE03251042' => 'Twistringen, Stadt',
	'DE03251043' => 'Varrel',
	'DE03251044' => 'Wagenfeld',
	'DE03251045' => 'Wehrbleck',
	'DE03251046' => 'Wetschen',
	'DE03251047' => 'Weyhe',
	'DE03251049' => 'Bruchhausen-Vilsen, Flecken',
	'DE03252001' => 'Aerzen, Flecken',
	'DE03252002' => 'Bad Münder am Deister, Stadt',
	'DE03252003' => 'Bad Pyrmont, Stadt',
	'DE03252004' => 'Coppenbrügge, Flecken',
	'DE03252005' => 'Emmerthal',
	'DE03252006' => 'Hameln, Stadt',
	'DE03252007' => 'Hessisch Oldendorf, Stadt',
	'DE03252008' => 'Salzhemmendorf, Flecken',
	'DE03254002' => 'Alfeld (Leine), Stadt',
	'DE03254003' => 'Algermissen',
	'DE03254005' => 'Bad Salzdetfurth, Stadt',
	'DE03254008' => 'Bockenem, Stadt',
	'DE03254011' => 'Diekholzen',
	'DE03254013' => 'Eime, Flecken',
	'DE03254014' => 'Elze, Stadt',
	'DE03254017' => 'Giesen',
	'DE03254020' => 'Harsum',
	'DE03254021' => 'Hildesheim, Stadt',
	'DE03254022' => 'Holle',
	'DE03254026' => 'Nordstemmen',
	'DE03254028' => 'Sarstedt, Stadt',
	'DE03254029' => 'Schellerten',
	'DE03254032' => 'Söhlde',
	'DE03254041' => 'Duingen, Flecken',
	'DE03254042' => 'Freden (Leine)',
	'DE03254043' => 'Gronau (Leine), Stadt',
	'DE03254044' => 'Lamspringe',
	'DE03254045' => 'Sibbesse',
	'DE03255001' => 'Arholzen',
	'DE03255002' => 'Bevern, Flecken',
	'DE03255003' => 'Bodenwerder, Münchhausenstadt',
	'DE03255004' => 'Boffzen',
	'DE03255005' => 'Brevörde',
	'DE03255007' => 'Deensen',
	'DE03255008' => 'Delligsen, Flecken',
	'DE03255009' => 'Derental',
	'DE03255010' => 'Dielmissen',
	'DE03255012' => 'Eimen',
	'DE03255013' => 'Eschershausen, Stadt',
	'DE03255014' => 'Fürstenberg',
	'DE03255015' => 'Golmbach',
	'DE03255016' => 'Halle',
	'DE03255017' => 'Hehlen',
	'DE03255018' => 'Heinade',
	'DE03255019' => 'Heinsen',
	'DE03255020' => 'Heyen',
	'DE03255021' => 'Holenberg',
	'DE03255022' => 'Holzen',
	'DE03255023' => 'Holzminden, Stadt',
	'DE03255025' => 'Kirchbrak',
	'DE03255026' => 'Lauenförde, Flecken',
	'DE03255027' => 'Lenne',
	'DE03255028' => 'Lüerdissen',
	'DE03255030' => 'Negenborn',
	'DE03255031' => 'Ottenstein, Flecken',
	'DE03255032' => 'Pegestorf',
	'DE03255033' => 'Polle, Flecken',
	'DE03255034' => 'Stadtoldendorf, Stadt',
	'DE03255035' => 'Vahlbruch',
	'DE03255036' => 'Wangelnstedt',
	'DE03255501' => 'Boffzen, gemfr. Gebiet',
	'DE03255502' => 'Eimen, gemfr. Gebiet',
	'DE03255503' => 'Eschershausen, gemfr. Gebiet',
	'DE03255504' => 'Grünenplan, gemfr. Gebiet',
	'DE03255505' => 'Holzminden, gemfr. Gebiet',
	'DE03255506' => 'Merxhausen, gemfr. Gebiet',
	'DE03255508' => 'Wenzen, gemfr. Gebiet',
	'DE03256001' => 'Balge',
	'DE03256002' => 'Binnen',
	'DE03256003' => 'Bücken, Flecken',
	'DE03256004' => 'Diepenau, Flecken',
	'DE03256005' => 'Drakenburg, Flecken',
	'DE03256006' => 'Estorf',
	'DE03256007' => 'Eystrup',
	'DE03256008' => 'Gandesbergen',
	'DE03256009' => 'Hämelhausen',
	'DE03256010' => 'Hassel (Weser)',
	'DE03256011' => 'Haßbergen',
	'DE03256012' => 'Heemsen',
	'DE03256013' => 'Hilgermissen',
	'DE03256014' => 'Hoya, Stadt',
	'DE03256015' => 'Hoyerhagen',
	'DE03256016' => 'Husum',
	'DE03256017' => 'Landesbergen',
	'DE03256018' => 'Leese',
	'DE03256019' => 'Liebenau, Flecken',
	'DE03256020' => 'Linsburg',
	'DE03256021' => 'Marklohe',
	'DE03256022' => 'Nienburg (Weser), Stadt',
	'DE03256023' => 'Pennigsehl',
	'DE03256024' => 'Raddestorf',
	'DE03256025' => 'Rehburg-Loccum, Stadt',
	'DE03256026' => 'Rodewald',
	'DE03256027' => 'Rohrsen',
	'DE03256028' => 'Schweringen',
	'DE03256029' => 'Steimbke',
	'DE03256030' => 'Steyerberg, Flecken',
	'DE03256031' => 'Stöckse',
	'DE03256032' => 'Stolzenau',
	'DE03256033' => 'Uchte, Flecken',
	'DE03256034' => 'Warmsen',
	'DE03256035' => 'Warpe',
	'DE03256036' => 'Wietzen',
	'DE03257001' => 'Ahnsen',
	'DE03257002' => 'Apelern',
	'DE03257003' => 'Auetal',
	'DE03257004' => 'Auhagen',
	'DE03257005' => 'Bad Eilsen',
	'DE03257006' => 'Bad Nenndorf, Stadt',
	'DE03257007' => 'Beckedorf',
	'DE03257008' => 'Buchholz',
	'DE03257009' => 'Bückeburg, Stadt',
	'DE03257010' => 'Hagenburg, Flecken',
	'DE03257011' => 'Haste',
	'DE03257012' => 'Heeßen',
	'DE03257013' => 'Helpsen',
	'DE03257014' => 'Hespe',
	'DE03257015' => 'Heuerßen',
	'DE03257016' => 'Hohnhorst',
	'DE03257017' => 'Hülsede',
	'DE03257018' => 'Lauenau, Flecken',
	'DE03257019' => 'Lauenhagen',
	'DE03257020' => 'Lindhorst',
	'DE03257021' => 'Lüdersfeld',
	'DE03257022' => 'Luhden',
	'DE03257023' => 'Meerbeck',
	'DE03257024' => 'Messenkamp',
	'DE03257025' => 'Niedernwöhren',
	'DE03257026' => 'Nienstädt',
	'DE03257027' => 'Nordsehl',
	'DE03257028' => 'Obernkirchen, Stadt',
	'DE03257029' => 'Pohle',
	'DE03257030' => 'Pollhagen',
	'DE03257031' => 'Rinteln, Stadt',
	'DE03257032' => 'Rodenberg, Stadt',
	'DE03257033' => 'Sachsenhagen, Stadt',
	'DE03257034' => 'Seggebruch',
	'DE03257035' => 'Stadthagen, Stadt',
	'DE03257036' => 'Suthfeld',
	'DE03257037' => 'Wiedensahl, Flecken',
	'DE03257038' => 'Wölpinghausen',
	'DE03351001' => 'Adelheidsdorf',
	'DE03351002' => 'Ahnsbeck',
	'DE03351003' => 'Beedenbostel',
	'DE03351004' => 'Bergen, Stadt',
	'DE03351005' => 'Bröckel',
	'DE03351006' => 'Celle, Stadt',
	'DE03351007' => 'Eicklingen',
	'DE03351008' => 'Eldingen',
	'DE03351010' => 'Faßberg',
	'DE03351012' => 'Hambühren',
	'DE03351015' => 'Hohne',
	'DE03351016' => 'Lachendorf',
	'DE03351017' => 'Langlingen',
	'DE03351018' => 'Nienhagen',
	'DE03351021' => 'Wathlingen',
	'DE03351022' => 'Wienhausen, Klostergemeinde',
	'DE03351023' => 'Wietze',
	'DE03351024' => 'Winsen (Aller)',
	'DE03351025' => 'Eschede',
	'DE03351026' => 'Südheide',
	'DE03351501' => 'Lohheide, gemfr. Bezirk',
	'DE03352002' => 'Armstorf',
	'DE03352004' => 'Belum',
	'DE03352008' => 'Bülkau',
	'DE03352011' => 'Cuxhaven, Stadt',
	'DE03352020' => 'Hechthausen',
	'DE03352022' => 'Hemmoor, Stadt',
	'DE03352024' => 'Hollnseth',
	'DE03352025' => 'Ihlienworth',
	'DE03352029' => 'Lamstedt',
	'DE03352032' => 'Loxstedt',
	'DE03352036' => 'Mittelstenahe',
	'DE03352038' => 'Neuenkirchen',
	'DE03352039' => 'Neuhaus (Oste), Flecken',
	'DE03352041' => 'Nordleda',
	'DE03352042' => 'Oberndorf',
	'DE03352043' => 'Odisheim',
	'DE03352044' => 'Osten',
	'DE03352045' => 'Osterbruch',
	'DE03352046' => 'Otterndorf, Stadt',
	'DE03352050' => 'Schiffdorf',
	'DE03352051' => 'Steinau',
	'DE03352052' => 'Stinstedt',
	'DE03352055' => 'Wanna',
	'DE03352056' => 'Wingst',
	'DE03352059' => 'Beverstedt',
	'DE03352060' => 'Hagen im Bremischen',
	'DE03352061' => 'Wurster Nordseeküste',
	'DE03352062' => 'Geestland, Stadt',
	'DE03352063' => 'Cadenberge',
	'DE03353001' => 'Appel',
	'DE03353002' => 'Asendorf',
	'DE03353003' => 'Bendestorf',
	'DE03353004' => 'Brackel',
	'DE03353005' => 'Buchholz in der Nordheide, Stadt',
	'DE03353006' => 'Dohren',
	'DE03353007' => 'Drage',
	'DE03353008' => 'Drestedt',
	'DE03353009' => 'Egestorf',
	'DE03353010' => 'Eyendorf',
	'DE03353011' => 'Garlstorf',
	'DE03353012' => 'Garstedt',
	'DE03353013' => 'Gödenstorf',
	'DE03353014' => 'Halvesbostel',
	'DE03353015' => 'Handeloh',
	'DE03353016' => 'Hanstedt',
	'DE03353017' => 'Harmstorf',
	'DE03353018' => 'Heidenau',
	'DE03353019' => 'Hollenstedt',
	'DE03353020' => 'Jesteburg',
	'DE03353021' => 'Kakenstorf',
	'DE03353022' => 'Königsmoor',
	'DE03353023' => 'Marschacht',
	'DE03353024' => 'Marxen',
	'DE03353025' => 'Moisburg',
	'DE03353026' => 'Neu Wulmstorf',
	'DE03353027' => 'Otter',
	'DE03353028' => 'Regesbostel',
	'DE03353029' => 'Rosengarten',
	'DE03353030' => 'Salzhausen',
	'DE03353031' => 'Seevetal',
	'DE03353032' => 'Stelle',
	'DE03353033' => 'Tespe',
	'DE03353034' => 'Toppenstedt',
	'DE03353035' => 'Tostedt',
	'DE03353036' => 'Undeloh',
	'DE03353037' => 'Vierhöfen',
	'DE03353038' => 'Welle',
	'DE03353039' => 'Wenzendorf',
	'DE03353040' => 'Winsen (Luhe), Stadt',
	'DE03353041' => 'Wistedt',
	'DE03353042' => 'Wulfsen',
	'DE03354001' => 'Bergen an der Dumme, Flecken',
	'DE03354002' => 'Clenze, Flecken',
	'DE03354003' => 'Damnatz',
	'DE03354004' => 'Dannenberg (Elbe), Stadt',
	'DE03354005' => 'Gartow, Flecken',
	'DE03354006' => 'Göhrde',
	'DE03354007' => 'Gorleben',
	'DE03354008' => 'Gusborn',
	'DE03354009' => 'Hitzacker (Elbe), Stadt',
	'DE03354010' => 'Höhbeck',
	'DE03354011' => 'Jameln',
	'DE03354012' => 'Karwitz',
	'DE03354013' => 'Küsten',
	'DE03354014' => 'Langendorf',
	'DE03354015' => 'Lemgow',
	'DE03354016' => 'Luckau (Wendland)',
	'DE03354017' => 'Lübbow',
	'DE03354018' => 'Lüchow (Wendland), Stadt',
	'DE03354019' => 'Neu Darchau',
	'DE03354020' => 'Prezelle',
	'DE03354021' => 'Schnackenburg, Stadt',
	'DE03354022' => 'Schnega',
	'DE03354023' => 'Trebel',
	'DE03354024' => 'Waddeweitz',
	'DE03354025' => 'Woltersdorf',
	'DE03354026' => 'Wustrow (Wendland), Stadt',
	'DE03354027' => 'Zernien',
	'DE03354501' => 'Gartow, gemfr. Gebiet',
	'DE03354502' => 'Göhrde, gemfr. Gebiet',
	'DE03355001' => 'Adendorf',
	'DE03355002' => 'Amelinghausen',
	'DE03355003' => 'Artlenburg, Flecken',
	'DE03355004' => 'Bardowick, Flecken',
	'DE03355005' => 'Barendorf',
	'DE03355006' => 'Barnstedt',
	'DE03355007' => 'Barum',
	'DE03355008' => 'Betzendorf',
	'DE03355009' => 'Bleckede, Stadt',
	'DE03355010' => 'Boitze',
	'DE03355011' => 'Brietlingen',
	'DE03355012' => 'Dahlem',
	'DE03355013' => 'Dahlenburg, Flecken',
	'DE03355014' => 'Deutsch Evern',
	'DE03355015' => 'Echem',
	'DE03355016' => 'Embsen',
	'DE03355017' => 'Handorf',
	'DE03355018' => 'Hittbergen',
	'DE03355019' => 'Hohnstorf (Elbe)',
	'DE03355020' => 'Kirchgellersen',
	'DE03355021' => 'Lüdersburg',
	'DE03355022' => 'Lüneburg, Hansestadt',
	'DE03355023' => 'Mechtersen',
	'DE03355024' => 'Melbeck',
	'DE03355025' => 'Nahrendorf',
	'DE03355026' => 'Neetze',
	'DE03355027' => 'Oldendorf (Luhe)',
	'DE03355028' => 'Radbruch',
	'DE03355029' => 'Rehlingen',
	'DE03355030' => 'Reinstorf',
	'DE03355031' => 'Reppenstedt',
	'DE03355032' => 'Rullstorf',
	'DE03355033' => 'Scharnebeck',
	'DE03355034' => 'Soderstorf',
	'DE03355035' => 'Südergellersen',
	'DE03355036' => 'Thomasburg',
	'DE03355037' => 'Tosterglope',
	'DE03355038' => 'Vastorf',
	'DE03355039' => 'Vögelsen',
	'DE03355040' => 'Wendisch Evern',
	'DE03355041' => 'Westergellersen',
	'DE03355042' => 'Wittorf',
	'DE03355049' => 'Amt Neuhaus',
	'DE03356001' => 'Axstedt',
	'DE03356002' => 'Grasberg',
	'DE03356003' => 'Hambergen',
	'DE03356004' => 'Holste',
	'DE03356005' => 'Lilienthal',
	'DE03356006' => 'Lübberstedt',
	'DE03356007' => 'Osterholz-Scharmbeck, Stadt',
	'DE03356008' => 'Ritterhude',
	'DE03356009' => 'Schwanewede',
	'DE03356010' => 'Vollersode',
	'DE03356011' => 'Worpswede',
	'DE03357001' => 'Ahausen',
	'DE03357002' => 'Alfstedt',
	'DE03357003' => 'Anderlingen',
	'DE03357004' => 'Basdahl',
	'DE03357005' => 'Bötersen',
	'DE03357006' => 'Bothel',
	'DE03357007' => 'Breddorf',
	'DE03357008' => 'Bremervörde, Stadt',
	'DE03357009' => 'Brockel',
	'DE03357010' => 'Bülstedt',
	'DE03357011' => 'Deinstedt',
	'DE03357012' => 'Ebersdorf',
	'DE03357013' => 'Elsdorf',
	'DE03357014' => 'Farven',
	'DE03357015' => 'Fintel',
	'DE03357016' => 'Gnarrenburg',
	'DE03357017' => 'Groß Meckelsen',
	'DE03357018' => 'Gyhum',
	'DE03357019' => 'Hamersen',
	'DE03357020' => 'Hassendorf',
	'DE03357021' => 'Heeslingen',
	'DE03357022' => 'Hellwege',
	'DE03357023' => 'Helvesiek',
	'DE03357024' => 'Hemsbünde',
	'DE03357025' => 'Hemslingen',
	'DE03357026' => 'Hepstedt',
	'DE03357027' => 'Hipstedt',
	'DE03357028' => 'Horstedt',
	'DE03357029' => 'Kalbe',
	'DE03357030' => 'Kirchtimke',
	'DE03357031' => 'Kirchwalsede',
	'DE03357032' => 'Klein Meckelsen',
	'DE03357033' => 'Lauenbrück',
	'DE03357034' => 'Lengenbostel',
	'DE03357035' => 'Oerel',
	'DE03357036' => 'Ostereistedt',
	'DE03357037' => 'Reeßum',
	'DE03357038' => 'Rhade',
	'DE03357039' => 'Rotenburg (Wümme), Stadt',
	'DE03357040' => 'Sandbostel',
	'DE03357041' => 'Scheeßel',
	'DE03357042' => 'Seedorf',
	'DE03357043' => 'Selsingen',
	'DE03357044' => 'Sittensen',
	'DE03357045' => 'Sottrum',
	'DE03357046' => 'Stemmen',
	'DE03357047' => 'Tarmstedt',
	'DE03357048' => 'Tiste',
	'DE03357049' => 'Vahlde',
	'DE03357050' => 'Vierden',
	'DE03357051' => 'Visselhövede, Stadt',
	'DE03357052' => 'Vorwerk',
	'DE03357053' => 'Westertimke',
	'DE03357054' => 'Westerwalsede',
	'DE03357055' => 'Wilstedt',
	'DE03357056' => 'Wohnste',
	'DE03357057' => 'Zeven, Stadt',
	'DE03358001' => 'Ahlden (Aller), Flecken',
	'DE03358002' => 'Bispingen',
	'DE03358003' => 'Böhme',
	'DE03358004' => 'Bomlitz',
	'DE03358005' => 'Buchholz (Aller)',
	'DE03358006' => 'Eickeloh',
	'DE03358007' => 'Essel',
	'DE03358008' => 'Bad Fallingbostel, Stadt',
	'DE03358009' => 'Frankenfeld',
	'DE03358010' => 'Gilten',
	'DE03358011' => 'Grethem',
	'DE03358012' => 'Hademstorf',
	'DE03358013' => 'Häuslingen',
	'DE03358014' => 'Hodenhagen',
	'DE03358015' => 'Lindwedel',
	'DE03358016' => 'Munster, Stadt',
	'DE03358017' => 'Neuenkirchen',
	'DE03358018' => 'Rethem (Aller), Stadt',
	'DE03358019' => 'Schneverdingen, Stadt',
	'DE03358020' => 'Schwarmstedt',
	'DE03358021' => 'Soltau, Stadt',
	'DE03358022' => 'Walsrode, Stadt',
	'DE03358023' => 'Wietzendorf',
	'DE03358501' => 'Osterheide, gemfr. Bezirk',
	'DE03359001' => 'Agathenburg',
	'DE03359002' => 'Ahlerstedt',
	'DE03359003' => 'Apensen',
	'DE03359004' => 'Balje',
	'DE03359005' => 'Bargstedt',
	'DE03359006' => 'Beckdorf',
	'DE03359007' => 'Bliedersdorf',
	'DE03359008' => 'Brest',
	'DE03359009' => 'Burweg',
	'DE03359010' => 'Buxtehude, Hansestadt',
	'DE03359011' => 'Deinste',
	'DE03359012' => 'Dollern',
	'DE03359013' => 'Drochtersen',
	'DE03359014' => 'Düdenbüttel',
	'DE03359015' => 'Engelschoff',
	'DE03359016' => 'Estorf',
	'DE03359017' => 'Fredenbeck',
	'DE03359018' => 'Freiburg (Elbe), Flecken',
	'DE03359019' => 'Großenwörden',
	'DE03359020' => 'Grünendeich',
	'DE03359021' => 'Guderhandviertel',
	'DE03359022' => 'Hammah',
	'DE03359023' => 'Harsefeld, Flecken',
	'DE03359024' => 'Heinbockel',
	'DE03359025' => 'Himmelpforten',
	'DE03359026' => 'Hollern-Twielenfleth',
	'DE03359027' => 'Horneburg, Flecken',
	'DE03359028' => 'Jork',
	'DE03359029' => 'Kranenburg',
	'DE03359030' => 'Krummendeich',
	'DE03359031' => 'Kutenholz',
	'DE03359032' => 'Mittelnkirchen',
	'DE03359033' => 'Neuenkirchen',
	'DE03359034' => 'Nottensdorf',
	'DE03359035' => 'Oederquart',
	'DE03359036' => 'Oldendorf',
	'DE03359037' => 'Sauensiek',
	'DE03359038' => 'Stade, Hansestadt',
	'DE03359039' => 'Steinkirchen',
	'DE03359040' => 'Wischhafen',
	'DE03360001' => 'Altenmedingen',
	'DE03360002' => 'Bad Bevensen, Stadt',
	'DE03360003' => 'Barum',
	'DE03360004' => 'Bienenbüttel',
	'DE03360005' => 'Bad Bodenteich, Flecken',
	'DE03360006' => 'Ebstorf,Klosterflecken',
	'DE03360007' => 'Eimke',
	'DE03360008' => 'Emmendorf',
	'DE03360009' => 'Gerdau',
	'DE03360010' => 'Hanstedt',
	'DE03360011' => 'Himbergen',
	'DE03360012' => 'Jelmstorf',
	'DE03360013' => 'Lüder',
	'DE03360014' => 'Natendorf',
	'DE03360015' => 'Oetzen',
	'DE03360016' => 'Rätzlingen',
	'DE03360017' => 'Römstedt',
	'DE03360018' => 'Rosche',
	'DE03360019' => 'Schwienau',
	'DE03360020' => 'Soltendieck',
	'DE03360022' => 'Stoetze',
	'DE03360023' => 'Suderburg',
	'DE03360024' => 'Suhlendorf',
	'DE03360025' => 'Uelzen, Hansestadt',
	'DE03360026' => 'Weste',
	'DE03360029' => 'Wriedel',
	'DE03360030' => 'Wrestedt',
	'DE03361001' => 'Achim, Stadt',
	'DE03361002' => 'Blender',
	'DE03361003' => 'Dörverden',
	'DE03361004' => 'Emtinghausen',
	'DE03361005' => 'Kirchlinteln',
	'DE03361006' => 'Langwedel, Flecken',
	'DE03361008' => 'Ottersberg, Flecken',
	'DE03361009' => 'Oyten',
	'DE03361010' => 'Riede',
	'DE03361012' => 'Verden (Aller), Stadt',
	'DE03361013' => 'Thedinghausen',
	'DE03401000' => 'Delmenhorst, Stadt',
	'DE03402000' => 'Emden, Stadt',
	'DE03403000' => 'Oldenburg (Oldenburg), Stadt',
	'DE03404000' => 'Osnabrück, Stadt',
	'DE03405000' => 'Wilhelmshaven, Stadt',
	'DE03451001' => 'Apen',
	'DE03451002' => 'Bad Zwischenahn',
	'DE03451004' => 'Edewecht',
	'DE03451005' => 'Rastede',
	'DE03451007' => 'Westerstede, Stadt',
	'DE03451008' => 'Wiefelstede',
	'DE03452001' => 'Aurich, Stadt',
	'DE03452002' => 'Baltrum',
	'DE03452003' => 'Berumbur',
	'DE03452006' => 'Großefehn',
	'DE03452007' => 'Großheide',
	'DE03452008' => 'Hage, Flecken',
	'DE03452009' => 'Hagermarsch',
	'DE03452010' => 'Halbemond',
	'DE03452011' => 'Hinte',
	'DE03452012' => 'Ihlow',
	'DE03452013' => 'Juist, Inselgemeinde',
	'DE03452014' => 'Krummhörn',
	'DE03452015' => 'Leezdorf',
	'DE03452016' => 'Lütetsburg',
	'DE03452017' => 'Marienhafe, Flecken',
	'DE03452019' => 'Norden, Stadt',
	'DE03452020' => 'Norderney, Stadt',
	'DE03452021' => 'Osteel',
	'DE03452022' => 'Rechtsupweg',
	'DE03452023' => 'Südbrookmerland',
	'DE03452024' => 'Upgant-Schott',
	'DE03452025' => 'Wiesmoor, Stadt',
	'DE03452026' => 'Wirdum',
	'DE03452027' => 'Dornum',
	'DE03452501' => 'Nordseeinsel Memmert, gemfr. Gebiet',
	'DE03453001' => 'Barßel',
	'DE03453002' => 'Bösel',
	'DE03453003' => 'Cappeln (Oldenburg)',
	'DE03453004' => 'Cloppenburg, Stadt',
	'DE03453005' => 'Emstek',
	'DE03453006' => 'Essen (Oldenburg)',
	'DE03453007' => 'Friesoythe, Stadt',
	'DE03453008' => 'Garrel',
	'DE03453009' => 'Lastrup',
	'DE03453010' => 'Lindern (Oldenburg)',
	'DE03453011' => 'Löningen, Stadt',
	'DE03453012' => 'Molbergen',
	'DE03453013' => 'Saterland',
	'DE03454001' => 'Andervenne',
	'DE03454002' => 'Bawinkel',
	'DE03454003' => 'Beesten',
	'DE03454004' => 'Bockhorst',
	'DE03454005' => 'Börger',
	'DE03454006' => 'Breddenberg',
	'DE03454007' => 'Dersum',
	'DE03454008' => 'Dörpen',
	'DE03454009' => 'Dohren',
	'DE03454010' => 'Emsbüren',
	'DE03454011' => 'Esterwegen',
	'DE03454012' => 'Freren, Stadt',
	'DE03454013' => 'Fresenburg',
	'DE03454014' => 'Geeste',
	'DE03454015' => 'Gersten',
	'DE03454016' => 'Groß Berßen',
	'DE03454017' => 'Handrup',
	'DE03454018' => 'Haren (Ems), Stadt',
	'DE03454019' => 'Haselünne, Stadt',
	'DE03454020' => 'Heede',
	'DE03454021' => 'Herzlake',
	'DE03454022' => 'Hilkenbrook',
	'DE03454023' => 'Hüven',
	'DE03454024' => 'Klein Berßen',
	'DE03454025' => 'Kluse',
	'DE03454026' => 'Lähden',
	'DE03454027' => 'Lahn',
	'DE03454028' => 'Langen',
	'DE03454029' => 'Lathen',
	'DE03454030' => 'Lehe',
	'DE03454031' => 'Lengerich',
	'DE03454032' => 'Lingen (Ems), Stadt',
	'DE03454033' => 'Lorup',
	'DE03454034' => 'Lünne',
	'DE03454035' => 'Meppen, Stadt',
	'DE03454036' => 'Messingen',
	'DE03454037' => 'Neubörger',
	'DE03454038' => 'Neulehe',
	'DE03454039' => 'Niederlangen',
	'DE03454040' => 'Oberlangen',
	'DE03454041' => 'Papenburg, Stadt',
	'DE03454042' => 'Rastdorf',
	'DE03454043' => 'Renkenberge',
	'DE03454044' => 'Rhede (Ems)',
	'DE03454045' => 'Salzbergen',
	'DE03454046' => 'Schapen',
	'DE03454047' => 'Sögel',
	'DE03454048' => 'Spahnharrenstätte',
	'DE03454049' => 'Spelle',
	'DE03454050' => 'Stavern',
	'DE03454051' => 'Surwold',
	'DE03454052' => 'Sustrum',
	'DE03454053' => 'Thuine',
	'DE03454054' => 'Twist',
	'DE03454055' => 'Vrees',
	'DE03454056' => 'Walchum',
	'DE03454057' => 'Werlte, Stadt',
	'DE03454058' => 'Werpeloh',
	'DE03454059' => 'Wettrup',
	'DE03454060' => 'Wippingen',
	'DE03455007' => 'Jever, Stadt',
	'DE03455014' => 'Sande',
	'DE03455015' => 'Schortens, Stadt',
	'DE03455020' => 'Wangerland',
	'DE03455021' => 'Wangerooge, Nordseebad',
	'DE03455025' => 'Bockhorn',
	'DE03455026' => 'Varel, Stadt',
	'DE03455027' => 'Zetel',
	'DE03456001' => 'Bad Bentheim, Stadt',
	'DE03456002' => 'Emlichheim',
	'DE03456003' => 'Engden',
	'DE03456004' => 'Esche',
	'DE03456005' => 'Georgsdorf',
	'DE03456006' => 'Getelo',
	'DE03456007' => 'Gölenkamp',
	'DE03456008' => 'Halle',
	'DE03456009' => 'Hoogstede',
	'DE03456010' => 'Isterberg',
	'DE03456011' => 'Itterbeck',
	'DE03456012' => 'Laar',
	'DE03456013' => 'Lage',
	'DE03456014' => 'Neuenhaus, Stadt',
	'DE03456015' => 'Nordhorn, Stadt',
	'DE03456016' => 'Ohne',
	'DE03456017' => 'Osterwald',
	'DE03456018' => 'Quendorf',
	'DE03456019' => 'Ringe',
	'DE03456020' => 'Samern',
	'DE03456023' => 'Uelsen',
	'DE03456024' => 'Wielen',
	'DE03456025' => 'Wietmarschen',
	'DE03456026' => 'Wilsum',
	'DE03456027' => 'Schüttorf, Stadt',
	'DE03457002' => 'Borkum, Stadt',
	'DE03457003' => 'Brinkum',
	'DE03457006' => 'Detern, Flecken',
	'DE03457008' => 'Filsum',
	'DE03457009' => 'Firrel',
	'DE03457010' => 'Hesel',
	'DE03457011' => 'Holtland',
	'DE03457012' => 'Jemgum',
	'DE03457013' => 'Leer (Ostfriesland), Stadt',
	'DE03457014' => 'Moormerland',
	'DE03457015' => 'Neukamperfehn',
	'DE03457016' => 'Nortmoor',
	'DE03457017' => 'Ostrhauderfehn',
	'DE03457018' => 'Rhauderfehn',
	'DE03457019' => 'Schwerinsdorf',
	'DE03457020' => 'Uplengen',
	'DE03457021' => 'Weener, Stadt',
	'DE03457022' => 'Westoverledingen',
	'DE03457024' => 'Bunde',
	'DE03457501' => 'Insel Lütje Hörn, gemfr. Gebiet',
	'DE03458001' => 'Beckeln',
	'DE03458002' => 'Colnrade',
	'DE03458003' => 'Dötlingen',
	'DE03458004' => 'Dünsen',
	'DE03458005' => 'Ganderkesee',
	'DE03458006' => 'Groß Ippener',
	'DE03458007' => 'Großenkneten',
	'DE03458008' => 'Harpstedt, Flecken',
	'DE03458009' => 'Hatten',
	'DE03458010' => 'Hude (Oldb)',
	'DE03458011' => 'Kirchseelte',
	'DE03458012' => 'Prinzhöfte',
	'DE03458013' => 'Wardenburg',
	'DE03458014' => 'Wildeshausen, Stadt',
	'DE03458015' => 'Winkelsett',
	'DE03459001' => 'Alfhausen',
	'DE03459002' => 'Ankum',
	'DE03459003' => 'Bad Essen',
	'DE03459004' => 'Bad Iburg, Stadt',
	'DE03459005' => 'Bad Laer',
	'DE03459006' => 'Bad Rothenfelde',
	'DE03459007' => 'Badbergen',
	'DE03459008' => 'Belm',
	'DE03459009' => 'Berge',
	'DE03459010' => 'Bersenbrück, Stadt',
	'DE03459011' => 'Bippen',
	'DE03459012' => 'Bissendorf',
	'DE03459013' => 'Bohmte',
	'DE03459014' => 'Bramsche, Stadt',
	'DE03459015' => 'Dissen am Teutoburger Wald, Stadt',
	'DE03459016' => 'Eggermühlen',
	'DE03459017' => 'Fürstenau, Stadt',
	'DE03459018' => 'Gehrde',
	'DE03459019' => 'Georgsmarienhütte, Stadt',
	'DE03459020' => 'Hagen am Teutoburger Wald',
	'DE03459021' => 'Hasbergen',
	'DE03459022' => 'Hilter am Teutoburger Wald',
	'DE03459023' => 'Kettenkamp',
	'DE03459024' => 'Melle, Stadt',
	'DE03459025' => 'Menslage',
	'DE03459026' => 'Merzen',
	'DE03459027' => 'Neuenkirchen',
	'DE03459028' => 'Nortrup',
	'DE03459029' => 'Ostercappeln',
	'DE03459030' => 'Quakenbrück, Stadt',
	'DE03459031' => 'Rieste',
	'DE03459032' => 'Voltlage',
	'DE03459033' => 'Wallenhorst',
	'DE03459034' => 'Glandorf',
	'DE03460001' => 'Bakum',
	'DE03460002' => 'Damme, Stadt',
	'DE03460003' => 'Dinklage, Stadt',
	'DE03460004' => 'Goldenstedt',
	'DE03460005' => 'Holdorf',
	'DE03460006' => 'Lohne (Oldenburg), Stadt',
	'DE03460007' => 'Neuenkirchen-Vörden',
	'DE03460008' => 'Steinfeld (Oldenburg)',
	'DE03460009' => 'Vechta, Stadt',
	'DE03460010' => 'Visbek',
	'DE03461001' => 'Berne',
	'DE03461002' => 'Brake (Unterweser), Stadt',
	'DE03461003' => 'Butjadingen',
	'DE03461004' => 'Elsfleth, Stadt',
	'DE03461005' => 'Jade',
	'DE03461006' => 'Lemwerder',
	'DE03461007' => 'Nordenham, Stadt',
	'DE03461008' => 'Ovelgönne',
	'DE03461009' => 'Stadland',
	'DE03462001' => 'Blomberg',
	'DE03462002' => 'Dunum',
	'DE03462003' => 'Esens, Stadt',
	'DE03462004' => 'Eversmeer',
	'DE03462005' => 'Friedeburg',
	'DE03462006' => 'Holtgast',
	'DE03462007' => 'Langeoog',
	'DE03462008' => 'Moorweg',
	'DE03462009' => 'Nenndorf',
	'DE03462010' => 'Neuharlingersiel',
	'DE03462011' => 'Neuschoo',
	'DE03462012' => 'Ochtersum',
	'DE03462013' => 'Schweindorf',
	'DE03462014' => 'Spiekeroog',
	'DE03462015' => 'Stedesdorf',
	'DE03462016' => 'Utarp',
	'DE03462017' => 'Werdum',
	'DE03462018' => 'Westerholt',
	'DE03462019' => 'Wittmund, Stadt',
	'DE04011000' => 'Bremen, Stadt',
	'DE04012000' => 'Bremerhaven, Stadt',
	'DE05111000' => 'Düsseldorf, Stadt',
	'DE05112000' => 'Duisburg, Stadt',
	'DE05113000' => 'Essen, Stadt',
	'DE05114000' => 'Krefeld, Stadt',
	'DE05116000' => 'Mönchengladbach, Stadt',
	'DE05117000' => 'Mülheim an der Ruhr, Stadt',
	'DE05119000' => 'Oberhausen, Stadt',
	'DE05120000' => 'Remscheid, Stadt',
	'DE05122000' => 'Solingen, Klingenstadt',
	'DE05124000' => 'Wuppertal, Stadt',
	'DE05154004' => 'Bedburg-Hau',
	'DE05154008' => 'Emmerich am Rhein, Stadt',
	'DE05154012' => 'Geldern, Stadt',
	'DE05154016' => 'Goch, Stadt',
	'DE05154020' => 'Issum',
	'DE05154024' => 'Kalkar, Stadt',
	'DE05154028' => 'Kerken',
	'DE05154032' => 'Kevelaer, Stadt',
	'DE05154036' => 'Kleve, Stadt',
	'DE05154040' => 'Kranenburg',
	'DE05154044' => 'Rees, Stadt',
	'DE05154048' => 'Rheurdt',
	'DE05154052' => 'Straelen, Stadt',
	'DE05154056' => 'Uedem',
	'DE05154060' => 'Wachtendonk',
	'DE05154064' => 'Weeze',
	'DE05158004' => 'Erkrath, Fundort des Neanderthalers, Stadt',
	'DE05158008' => 'Haan, Stadt',
	'DE05158012' => 'Heiligenhaus, Stadt',
	'DE05158016' => 'Hilden, Stadt',
	'DE05158020' => 'Langenfeld (Rheinland), Stadt',
	'DE05158024' => 'Mettmann, Stadt',
	'DE05158026' => 'Monheim am Rhein, Stadt',
	'DE05158028' => 'Ratingen, Stadt',
	'DE05158032' => 'Velbert, Stadt',
	'DE05158036' => 'Wülfrath, Stadt',
	'DE05162004' => 'Dormagen, Stadt',
	'DE05162008' => 'Grevenbroich, Stadt',
	'DE05162012' => 'Jüchen',
	'DE05162016' => 'Kaarst, Stadt',
	'DE05162020' => 'Korschenbroich, Stadt',
	'DE05162022' => 'Meerbusch, Stadt',
	'DE05162024' => 'Neuss, Stadt',
	'DE05162028' => 'Rommerskirchen',
	'DE05166004' => 'Brüggen, Burggemeinde',
	'DE05166008' => 'Grefrath, Sport- und Freizeitgemeinde',
	'DE05166012' => 'Kempen, Stadt',
	'DE05166016' => 'Nettetal, Stadt',
	'DE05166020' => 'Niederkrüchten',
	'DE05166024' => 'Schwalmtal',
	'DE05166028' => 'Tönisvorst, Stadt',
	'DE05166032' => 'Viersen, Stadt',
	'DE05166036' => 'Willich, Stadt',
	'DE05170004' => 'Alpen',
	'DE05170008' => 'Dinslaken, Stadt',
	'DE05170012' => 'Hamminkeln, Stadt',
	'DE05170016' => 'Hünxe',
	'DE05170020' => 'Kamp-Lintfort, Stadt',
	'DE05170024' => 'Moers, Stadt',
	'DE05170028' => 'Neukirchen-Vluyn, Stadt',
	'DE05170032' => 'Rheinberg, Stadt',
	'DE05170036' => 'Schermbeck',
	'DE05170040' => 'Sonsbeck',
	'DE05170044' => 'Voerde (Niederrhein), Stadt',
	'DE05170048' => 'Wesel, Stadt',
	'DE05170052' => 'Xanten, Stadt',
	'DE05314000' => 'Bonn, Stadt',
	'DE05315000' => 'Köln, Stadt',
	'DE05316000' => 'Leverkusen, Stadt',
	'DE05334002' => 'Aachen, Stadt',
	'DE05334004' => 'Alsdorf, Stadt',
	'DE05334008' => 'Baesweiler, Stadt',
	'DE05334012' => 'Eschweiler, Stadt',
	'DE05334016' => 'Herzogenrath, Stadt',
	'DE05334020' => 'Monschau, Stadt',
	'DE05334024' => 'Roetgen, Tor zur Eifel',
	'DE05334028' => 'Simmerath',
	'DE05334032' => 'Stolberg (Rhld.), Kupferstadt',
	'DE05334036' => 'Würselen, Stadt',
	'DE05358004' => 'Aldenhoven',
	'DE05358008' => 'Düren, Stadt',
	'DE05358012' => 'Heimbach, Stadt',
	'DE05358016' => 'Hürtgenwald',
	'DE05358020' => 'Inden',
	'DE05358024' => 'Jülich, Stadt',
	'DE05358028' => 'Kreuzau',
	'DE05358032' => 'Langerwehe',
	'DE05358036' => 'Linnich, Stadt',
	'DE05358040' => 'Merzenich',
	'DE05358044' => 'Nideggen, Stadt',
	'DE05358048' => 'Niederzier',
	'DE05358052' => 'Nörvenich',
	'DE05358056' => 'Titz',
	'DE05358060' => 'Vettweiß',
	'DE05362004' => 'Bedburg, Stadt',
	'DE05362008' => 'Bergheim, Stadt',
	'DE05362012' => 'Brühl, Stadt',
	'DE05362016' => 'Elsdorf, Stadt',
	'DE05362020' => 'Erftstadt, Stadt',
	'DE05362024' => 'Frechen, Stadt',
	'DE05362028' => 'Hürth, Stadt',
	'DE05362032' => 'Kerpen, Kolpingstadt',
	'DE05362036' => 'Pulheim, Stadt',
	'DE05362040' => 'Wesseling, Stadt',
	'DE05366004' => 'Bad Münstereifel, Stadt',
	'DE05366008' => 'Blankenheim',
	'DE05366012' => 'Dahlem',
	'DE05366016' => 'Euskirchen, Stadt',
	'DE05366020' => 'Hellenthal',
	'DE05366024' => 'Kall',
	'DE05366028' => 'Mechernich, Stadt',
	'DE05366032' => 'Nettersheim',
	'DE05366036' => 'Schleiden, Stadt',
	'DE05366040' => 'Weilerswist',
	'DE05366044' => 'Zülpich, Stadt',
	'DE05370004' => 'Erkelenz, Stadt',
	'DE05370008' => 'Gangelt',
	'DE05370012' => 'Geilenkirchen, Stadt',
	'DE05370016' => 'Heinsberg, Stadt',
	'DE05370020' => 'Hückelhoven, Stadt',
	'DE05370024' => 'Selfkant',
	'DE05370028' => 'Übach-Palenberg, Stadt',
	'DE05370032' => 'Waldfeucht',
	'DE05370036' => 'Wassenberg, Stadt',
	'DE05370040' => 'Wegberg, Stadt',
	'DE05374004' => 'Bergneustadt, Stadt',
	'DE05374008' => 'Engelskirchen',
	'DE05374012' => 'Gummersbach, Stadt',
	'DE05374016' => 'Hückeswagen, Schloss-Stadt',
	'DE05374020' => 'Lindlar',
	'DE05374024' => 'Marienheide',
	'DE05374028' => 'Morsbach',
	'DE05374032' => 'Nümbrecht',
	'DE05374036' => 'Radevormwald, Stadt auf der Höhe',
	'DE05374040' => 'Reichshof',
	'DE05374044' => 'Waldbröl, Stadt',
	'DE05374048' => 'Wiehl, Stadt',
	'DE05374052' => 'Wipperfürth, Hansestadt',
	'DE05378004' => 'Bergisch Gladbach, Stadt',
	'DE05378008' => 'Burscheid, Stadt',
	'DE05378012' => 'Kürten',
	'DE05378016' => 'Leichlingen (Rheinland), Blütenstadt',
	'DE05378020' => 'Odenthal',
	'DE05378024' => 'Overath, Stadt',
	'DE05378028' => 'Rösrath, Stadt',
	'DE05378032' => 'Wermelskirchen, Stadt',
	'DE05382004' => 'Alfter',
	'DE05382008' => 'Bad Honnef, Stadt',
	'DE05382012' => 'Bornheim, Stadt',
	'DE05382016' => 'Eitorf',
	'DE05382020' => 'Hennef (Sieg), Stadt',
	'DE05382024' => 'Königswinter, Stadt',
	'DE05382028' => 'Lohmar, Stadt',
	'DE05382032' => 'Meckenheim, Stadt',
	'DE05382036' => 'Much',
	'DE05382040' => 'Neunkirchen-Seelscheid',
	'DE05382044' => 'Niederkassel, Stadt',
	'DE05382048' => 'Rheinbach, Stadt',
	'DE05382052' => 'Ruppichteroth',
	'DE05382056' => 'Sankt Augustin, Stadt',
	'DE05382060' => 'Siegburg, Stadt',
	'DE05382064' => 'Swisttal',
	'DE05382068' => 'Troisdorf, Stadt',
	'DE05382072' => 'Wachtberg',
	'DE05382076' => 'Windeck',
	'DE05512000' => 'Bottrop, Stadt',
	'DE05513000' => 'Gelsenkirchen, Stadt',
	'DE05515000' => 'Münster, Stadt',
	'DE05554004' => 'Ahaus, Stadt',
	'DE05554008' => 'Bocholt, Stadt',
	'DE05554012' => 'Borken, Stadt',
	'DE05554016' => 'Gescher, Glockenstadt',
	'DE05554020' => 'Gronau (Westf.), Stadt',
	'DE05554024' => 'Heek',
	'DE05554028' => 'Heiden',
	'DE05554032' => 'Isselburg, Stadt',
	'DE05554036' => 'Legden',
	'DE05554040' => 'Raesfeld',
	'DE05554044' => 'Reken',
	'DE05554048' => 'Rhede, Stadt',
	'DE05554052' => 'Schöppingen',
	'DE05554056' => 'Stadtlohn, Stadt',
	'DE05554060' => 'Südlohn',
	'DE05554064' => 'Velen, Stadt',
	'DE05554068' => 'Vreden, Stadt',
	'DE05558004' => 'Ascheberg',
	'DE05558008' => 'Billerbeck, Stadt',
	'DE05558012' => 'Coesfeld, Stadt',
	'DE05558016' => 'Dülmen, Stadt',
	'DE05558020' => 'Havixbeck',
	'DE05558024' => 'Lüdinghausen, Stadt',
	'DE05558028' => 'Nordkirchen',
	'DE05558032' => 'Nottuln',
	'DE05558036' => 'Olfen, Stadt',
	'DE05558040' => 'Rosendahl',
	'DE05558044' => 'Senden',
	'DE05562004' => 'Castrop-Rauxel, Stadt',
	'DE05562008' => 'Datteln, Stadt',
	'DE05562012' => 'Dorsten, Stadt',
	'DE05562014' => 'Gladbeck, Stadt',
	'DE05562016' => 'Haltern am See, Stadt',
	'DE05562020' => 'Herten, Stadt',
	'DE05562024' => 'Marl, Stadt',
	'DE05562028' => 'Oer-Erkenschwick, Stadt',
	'DE05562032' => 'Recklinghausen, Stadt',
	'DE05562036' => 'Waltrop, Stadt',
	'DE05566004' => 'Altenberge',
	'DE05566008' => 'Emsdetten, Stadt',
	'DE05566012' => 'Greven, Stadt',
	'DE05566016' => 'Hörstel, Stadt',
	'DE05566020' => 'Hopsten',
	'DE05566024' => 'Horstmar, Stadt der Burgmannshöfe',
	'DE05566028' => 'Ibbenbüren, Stadt',
	'DE05566032' => 'Ladbergen',
	'DE05566036' => 'Laer',
	'DE05566040' => 'Lengerich, Stadt',
	'DE05566044' => 'Lienen',
	'DE05566048' => 'Lotte',
	'DE05566052' => 'Metelen',
	'DE05566056' => 'Mettingen',
	'DE05566060' => 'Neuenkirchen',
	'DE05566064' => 'Nordwalde',
	'DE05566068' => 'Ochtrup, Stadt',
	'DE05566072' => 'Recke',
	'DE05566076' => 'Rheine, Stadt',
	'DE05566080' => 'Saerbeck, NRW-Klimakommune',
	'DE05566084' => 'Steinfurt, Stadt',
	'DE05566088' => 'Tecklenburg, Stadt',
	'DE05566092' => 'Westerkappeln',
	'DE05566096' => 'Wettringen',
	'DE05570004' => 'Ahlen, Stadt',
	'DE05570008' => 'Beckum, Stadt',
	'DE05570012' => 'Beelen',
	'DE05570016' => 'Drensteinfurt, Stadt',
	'DE05570020' => 'Ennigerloh, Stadt',
	'DE05570024' => 'Everswinkel',
	'DE05570028' => 'Oelde, Stadt',
	'DE05570032' => 'Ostbevern',
	'DE05570036' => 'Sassenberg, Stadt',
	'DE05570040' => 'Sendenhorst, Stadt',
	'DE05570044' => 'Telgte, Stadt',
	'DE05570048' => 'Wadersloh',
	'DE05570052' => 'Warendorf, Stadt',
	'DE05711000' => 'Bielefeld, Stadt',
	'DE05754004' => 'Borgholzhausen, Stadt',
	'DE05754008' => 'Gütersloh, Stadt',
	'DE05754012' => 'Halle (Westf.), Stadt',
	'DE05754016' => 'Harsewinkel, Die Mähdrescherstadt',
	'DE05754020' => 'Herzebrock-Clarholz',
	'DE05754024' => 'Langenberg',
	'DE05754028' => 'Rheda-Wiedenbrück, Stadt',
	'DE05754032' => 'Rietberg, Stadt',
	'DE05754036' => 'Schloß Holte-Stukenbrock, Stadt',
	'DE05754040' => 'Steinhagen',
	'DE05754044' => 'Verl, Stadt',
	'DE05754048' => 'Versmold, Stadt',
	'DE05754052' => 'Werther (Westf.), Stadt',
	'DE05758004' => 'Bünde, Stadt',
	'DE05758008' => 'Enger, Widukindstadt',
	'DE05758012' => 'Herford, Hansestadt',
	'DE05758016' => 'Hiddenhausen',
	'DE05758020' => 'Kirchlengern',
	'DE05758024' => 'Löhne, Stadt',
	'DE05758028' => 'Rödinghausen',
	'DE05758032' => 'Spenge, Stadt',
	'DE05758036' => 'Vlotho, Stadt',
	'DE05762004' => 'Bad Driburg, Stadt',
	'DE05762008' => 'Beverungen, Stadt',
	'DE05762012' => 'Borgentreich, Orgelstadt',
	'DE05762016' => 'Brakel, Stadt',
	'DE05762020' => 'Höxter, Stadt',
	'DE05762024' => 'Marienmünster, Stadt',
	'DE05762028' => 'Nieheim, Stadt',
	'DE05762032' => 'Steinheim, Stadt',
	'DE05762036' => 'Warburg, Hansestadt',
	'DE05762040' => 'Willebadessen, Stadt',
	'DE05766004' => 'Augustdorf',
	'DE05766008' => 'Bad Salzuflen, Stadt',
	'DE05766012' => 'Barntrup, Stadt',
	'DE05766016' => 'Blomberg, Stadt',
	'DE05766020' => 'Detmold, Stadt',
	'DE05766024' => 'Dörentrup',
	'DE05766028' => 'Extertal',
	'DE05766032' => 'Horn-Bad Meinberg, Stadt',
	'DE05766036' => 'Kalletal',
	'DE05766040' => 'Lage, Stadt',
	'DE05766044' => 'Lemgo, Stadt',
	'DE05766048' => 'Leopoldshöhe',
	'DE05766052' => 'Lügde, Stadt der Osterräder',
	'DE05766056' => 'Oerlinghausen, Stadt',
	'DE05766060' => 'Schieder-Schwalenberg, Stadt',
	'DE05766064' => 'Schlangen',
	'DE05770004' => 'Bad Oeynhausen, Stadt',
	'DE05770008' => 'Espelkamp, Stadt',
	'DE05770012' => 'Hille',
	'DE05770016' => 'Hüllhorst',
	'DE05770020' => 'Lübbecke, Stadt',
	'DE05770024' => 'Minden, Stadt',
	'DE05770028' => 'Petershagen, Stadt',
	'DE05770032' => 'Porta Westfalica, Stadt',
	'DE05770036' => 'Preußisch Oldendorf, Stadt',
	'DE05770040' => 'Rahden, Stadt',
	'DE05770044' => 'Stemwede',
	'DE05774004' => 'Altenbeken',
	'DE05774008' => 'Bad Lippspringe, Stadt',
	'DE05774012' => 'Borchen',
	'DE05774016' => 'Büren, Stadt',
	'DE05774020' => 'Delbrück, Stadt',
	'DE05774024' => 'Hövelhof, Sennegemeinde',
	'DE05774028' => 'Lichtenau, Stadt',
	'DE05774032' => 'Paderborn, Stadt',
	'DE05774036' => 'Salzkotten, Stadt',
	'DE05774040' => 'Bad Wünnenberg, Stadt',
	'DE05911000' => 'Bochum, Stadt',
	'DE05913000' => 'Dortmund, Stadt',
	'DE05914000' => 'Hagen, Stadt der FernUniversität',
	'DE05915000' => 'Hamm, Stadt',
	'DE05916000' => 'Herne, Stadt',
	'DE05954004' => 'Breckerfeld, Hansestadt',
	'DE05954008' => 'Ennepetal, Stadt der Kluterthöhle',
	'DE05954012' => 'Gevelsberg, Stadt',
	'DE05954016' => 'Hattingen, Stadt',
	'DE05954020' => 'Herdecke, Stadt',
	'DE05954024' => 'Schwelm, Stadt',
	'DE05954028' => 'Sprockhövel, Stadt',
	'DE05954032' => 'Wetter (Ruhr), Stadt',
	'DE05954036' => 'Witten, Stadt',
	'DE05958004' => 'Arnsberg, Stadt',
	'DE05958008' => 'Bestwig',
	'DE05958012' => 'Brilon, Stadt',
	'DE05958016' => 'Eslohe (Sauerland)',
	'DE05958020' => 'Hallenberg, Stadt',
	'DE05958024' => 'Marsberg, Stadt',
	'DE05958028' => 'Medebach, Hansestadt',
	'DE05958032' => 'Meschede, Kreis- und Hochschulstadt',
	'DE05958036' => 'Olsberg, Stadt',
	'DE05958040' => 'Schmallenberg, Stadt',
	'DE05958044' => 'Sundern (Sauerland), Stadt',
	'DE05958048' => 'Winterberg, Stadt',
	'DE05962004' => 'Altena, Stadt',
	'DE05962008' => 'Balve, Stadt',
	'DE05962012' => 'Halver, Stadt',
	'DE05962016' => 'Hemer, Stadt',
	'DE05962020' => 'Herscheid',
	'DE05962024' => 'Iserlohn, Stadt',
	'DE05962028' => 'Kierspe, Stadt',
	'DE05962032' => 'Lüdenscheid, Stadt',
	'DE05962036' => 'Meinerzhagen, Stadt',
	'DE05962040' => 'Menden (Sauerland), Stadt',
	'DE05962044' => 'Nachrodt-Wiblingwerde',
	'DE05962048' => 'Neuenrade, Stadt',
	'DE05962052' => 'Plettenberg, Stadt',
	'DE05962056' => 'Schalksmühle',
	'DE05962060' => 'Werdohl, Stadt',
	'DE05966004' => 'Attendorn, Hansestadt',
	'DE05966008' => 'Drolshagen, Stadt',
	'DE05966012' => 'Finnentrop',
	'DE05966016' => 'Kirchhundem',
	'DE05966020' => 'Lennestadt, Stadt',
	'DE05966024' => 'Olpe, Stadt',
	'DE05966028' => 'Wenden',
	'DE05970004' => 'Bad Berleburg, Stadt',
	'DE05970008' => 'Burbach',
	'DE05970012' => 'Erndtebrück',
	'DE05970016' => 'Freudenberg, Stadt',
	'DE05970020' => 'Hilchenbach, Stadt',
	'DE05970024' => 'Kreuztal, Stadt',
	'DE05970028' => 'Bad Laasphe, Stadt',
	'DE05970032' => 'Netphen, Stadt',
	'DE05970036' => 'Neunkirchen',
	'DE05970040' => 'Siegen, Universitätsstadt',
	'DE05970044' => 'Wilnsdorf',
	'DE05974004' => 'Anröchte',
	'DE05974008' => 'Bad Sassendorf',
	'DE05974012' => 'Ense',
	'DE05974016' => 'Erwitte, Stadt',
	'DE05974020' => 'Geseke, Stadt',
	'DE05974024' => 'Lippetal',
	'DE05974028' => 'Lippstadt, Stadt',
	'DE05974032' => 'Möhnesee',
	'DE05974036' => 'Rüthen, Stadt',
	'DE05974040' => 'Soest, Stadt',
	'DE05974044' => 'Warstein, Stadt',
	'DE05974048' => 'Welver',
	'DE05974052' => 'Werl, Stadt',
	'DE05974056' => 'Wickede (Ruhr)',
	'DE05978004' => 'Bergkamen, Stadt',
	'DE05978008' => 'Bönen',
	'DE05978012' => 'Fröndenberg/Ruhr, Stadt',
	'DE05978016' => 'Holzwickede',
	'DE05978020' => 'Kamen, Stadt',
	'DE05978024' => 'Lünen, Stadt',
	'DE05978028' => 'Schwerte, Hansestadt an der Ruhr',
	'DE05978032' => 'Selm, Stadt',
	'DE05978036' => 'Unna, Stadt',
	'DE05978040' => 'Werne, Stadt',
	'DE06411000' => 'Darmstadt, Wissenschaftsstadt',
	'DE06412000' => 'Frankfurt am Main, Stadt',
	'DE06413000' => 'Offenbach am Main, Stadt',
	'DE06414000' => 'Wiesbaden, Landeshauptstadt',
	'DE06431001' => 'Abtsteinach',
	'DE06431002' => 'Bensheim, Stadt',
	'DE06431003' => 'Biblis',
	'DE06431004' => 'Birkenau',
	'DE06431005' => 'Bürstadt, Stadt',
	'DE06431006' => 'Einhausen',
	'DE06431007' => 'Fürth',
	'DE06431008' => 'Gorxheimertal',
	'DE06431009' => 'Grasellenbach',
	'DE06431010' => 'Groß-Rohrheim',
	'DE06431011' => 'Heppenheim (Bergstraße), Kreisstadt',
	'DE06431012' => 'Hirschhorn (Neckar), Stadt',
	'DE06431013' => 'Lampertheim, Stadt',
	'DE06431014' => 'Lautertal (Odenwald)',
	'DE06431015' => 'Lindenfels, Stadt',
	'DE06431016' => 'Lorsch, Karolingerstadt',
	'DE06431017' => 'Mörlenbach',
	'DE06431018' => 'Neckarsteinach, Stadt',
	'DE06431019' => 'Rimbach',
	'DE06431020' => 'Viernheim, Stadt',
	'DE06431021' => 'Wald-Michelbach',
	'DE06431022' => 'Zwingenberg, Stadt',
	'DE06431200' => 'Michelbuch, gemfr. Gebiet',
	'DE06432001' => 'Alsbach-Hähnlein',
	'DE06432002' => 'Babenhausen, Stadt',
	'DE06432003' => 'Bickenbach',
	'DE06432004' => 'Dieburg, Stadt',
	'DE06432005' => 'Eppertshausen',
	'DE06432006' => 'Erzhausen',
	'DE06432007' => 'Fischbachtal',
	'DE06432008' => 'Griesheim, Stadt',
	'DE06432009' => 'Groß-Bieberau, Stadt',
	'DE06432010' => 'Groß-Umstadt, Stadt',
	'DE06432011' => 'Groß-Zimmern',
	'DE06432012' => 'Messel',
	'DE06432013' => 'Modautal',
	'DE06432014' => 'Mühltal',
	'DE06432015' => 'Münster (Hessen)',
	'DE06432016' => 'Ober-Ramstadt, Stadt',
	'DE06432017' => 'Otzberg',
	'DE06432018' => 'Pfungstadt, Stadt',
	'DE06432019' => 'Reinheim, Stadt',
	'DE06432020' => 'Roßdorf',
	'DE06432021' => 'Schaafheim',
	'DE06432022' => 'Seeheim-Jugenheim',
	'DE06432023' => 'Weiterstadt, Stadt',
	'DE06433001' => 'Biebesheim am Rhein',
	'DE06433002' => 'Bischofsheim',
	'DE06433003' => 'Büttelborn',
	'DE06433004' => 'Gernsheim, Schöfferstadt',
	'DE06433005' => 'Ginsheim-Gustavsburg, Stadt',
	'DE06433006' => 'Groß-Gerau, Stadt',
	'DE06433007' => 'Kelsterbach, Stadt',
	'DE06433008' => 'Mörfelden-Walldorf, Stadt',
	'DE06433009' => 'Nauheim',
	'DE06433010' => 'Raunheim, Stadt',
	'DE06433011' => 'Riedstadt, Stadt',
	'DE06433012' => 'Rüsselsheim am Main, Stadt',
	'DE06433013' => 'Stockstadt am Rhein',
	'DE06433014' => 'Trebur',
	'DE06434001' => 'Bad Homburg v. d. Höhe, Stadt',
	'DE06434002' => 'Friedrichsdorf, Stadt',
	'DE06434003' => 'Glashütten',
	'DE06434004' => 'Grävenwiesbach',
	'DE06434005' => 'Königstein im Taunus, Stadt',
	'DE06434006' => 'Kronberg im Taunus, Stadt',
	'DE06434007' => 'Neu-Anspach, Stadt',
	'DE06434008' => 'Oberursel (Taunus), Stadt',
	'DE06434009' => 'Schmitten',
	'DE06434010' => 'Steinbach (Taunus), Stadt',
	'DE06434011' => 'Usingen, Stadt',
	'DE06434012' => 'Wehrheim',
	'DE06434013' => 'Weilrod',
	'DE06435001' => 'Bad Orb, Stadt',
	'DE06435002' => 'Bad Soden-Salmünster, Stadt',
	'DE06435003' => 'Biebergemünd',
	'DE06435004' => 'Birstein',
	'DE06435005' => 'Brachttal',
	'DE06435006' => 'Bruchköbel, Stadt',
	'DE06435007' => 'Erlensee, Stadt',
	'DE06435008' => 'Flörsbachtal',
	'DE06435009' => 'Freigericht',
	'DE06435010' => 'Gelnhausen, Barbarossast., Krst.',
	'DE06435011' => 'Großkrotzenburg',
	'DE06435012' => 'Gründau',
	'DE06435013' => 'Hammersbach',
	'DE06435014' => 'Hanau, Brüder-Grimm-Stadt',
	'DE06435015' => 'Hasselroth',
	'DE06435016' => 'Jossgrund',
	'DE06435017' => 'Langenselbold, Stadt',
	'DE06435018' => 'Linsengericht',
	'DE06435019' => 'Maintal, Stadt',
	'DE06435020' => 'Neuberg',
	'DE06435021' => 'Nidderau, Stadt',
	'DE06435022' => 'Niederdorfelden',
	'DE06435023' => 'Rodenbach',
	'DE06435024' => 'Ronneburg',
	'DE06435025' => 'Schlüchtern, Stadt',
	'DE06435026' => 'Schöneck',
	'DE06435027' => 'Sinntal',
	'DE06435028' => 'Steinau an der Straße, Brüder-Grimm-Stadt',
	'DE06435029' => 'Wächtersbach, Stadt',
	'DE06435200' => 'Gutsbezirk Spessart, gemfr. Gebiet',
	'DE06436001' => 'Bad Soden am Taunus, Stadt',
	'DE06436002' => 'Eppstein, Stadt',
	'DE06436003' => 'Eschborn, Stadt',
	'DE06436004' => 'Flörsheim am Main, Stadt',
	'DE06436005' => 'Hattersheim am Main, Stadt',
	'DE06436006' => 'Hochheim am Main, Stadt',
	'DE06436007' => 'Hofheim am Taunus, Kreisstadt',
	'DE06436008' => 'Kelkheim (Taunus), Stadt',
	'DE06436009' => 'Kriftel',
	'DE06436010' => 'Liederbach am Taunus',
	'DE06436011' => 'Schwalbach am Taunus, Stadt',
	'DE06436012' => 'Sulzbach (Taunus)',
	'DE06437001' => 'Bad König, Stadt',
	'DE06437003' => 'Brensbach',
	'DE06437004' => 'Breuberg, Stadt',
	'DE06437005' => 'Brombachtal',
	'DE06437006' => 'Erbach, Kreisstadt',
	'DE06437007' => 'Fränkisch-Crumbach',
	'DE06437009' => 'Höchst i. Odw.',
	'DE06437010' => 'Lützelbach',
	'DE06437011' => 'Michelstadt, Stadt',
	'DE06437012' => 'Mossautal',
	'DE06437013' => 'Reichelsheim (Odenwald)',
	'DE06437016' => 'Oberzent, Stadt',
	'DE06438001' => 'Dietzenbach, Kreisstadt',
	'DE06438002' => 'Dreieich, Stadt',
	'DE06438003' => 'Egelsbach',
	'DE06438004' => 'Hainburg',
	'DE06438005' => 'Heusenstamm, Stadt',
	'DE06438006' => 'Langen (Hessen), Stadt',
	'DE06438007' => 'Mainhausen',
	'DE06438008' => 'Mühlheim am Main, Stadt',
	'DE06438009' => 'Neu-Isenburg, Stadt',
	'DE06438010' => 'Obertshausen, Stadt',
	'DE06438011' => 'Rodgau, Stadt',
	'DE06438012' => 'Rödermark, Stadt',
	'DE06438013' => 'Seligenstadt, Stadt',
	'DE06439001' => 'Aarbergen',
	'DE06439002' => 'Bad Schwalbach, Kreisstadt',
	'DE06439003' => 'Eltville am Rhein, Stadt',
	'DE06439004' => 'Geisenheim, Hochschulstadt',
	'DE06439005' => 'Heidenrod',
	'DE06439006' => 'Hohenstein',
	'DE06439007' => 'Hünstetten',
	'DE06439008' => 'Idstein, Hochschulstadt',
	'DE06439009' => 'Kiedrich',
	'DE06439010' => 'Lorch, Stadt',
	'DE06439011' => 'Niedernhausen',
	'DE06439012' => 'Oestrich-Winkel, Stadt',
	'DE06439013' => 'Rüdesheim am Rhein, Stadt',
	'DE06439014' => 'Schlangenbad',
	'DE06439015' => 'Taunusstein, Stadt',
	'DE06439016' => 'Waldems',
	'DE06439017' => 'Walluf',
	'DE06440001' => 'Altenstadt',
	'DE06440002' => 'Bad Nauheim, Stadt',
	'DE06440003' => 'Bad Vilbel, Stadt',
	'DE06440004' => 'Büdingen, Stadt',
	'DE06440005' => 'Butzbach, Friedrich-Ludwig-Weidig-Stadt',
	'DE06440006' => 'Echzell',
	'DE06440007' => 'Florstadt, Stadt',
	'DE06440008' => 'Friedberg (Hessen), Kreisstadt',
	'DE06440009' => 'Gedern, Stadt',
	'DE06440010' => 'Glauburg',
	'DE06440011' => 'Hirzenhain',
	'DE06440012' => 'Karben, Stadt',
	'DE06440013' => 'Kefenrod',
	'DE06440014' => 'Limeshain',
	'DE06440015' => 'Münzenberg, Stadt',
	'DE06440016' => 'Nidda, Stadt',
	'DE06440017' => 'Niddatal, Stadt',
	'DE06440018' => 'Ober-Mörlen',
	'DE06440019' => 'Ortenberg, Stadt',
	'DE06440020' => 'Ranstadt',
	'DE06440021' => 'Reichelsheim (Wetterau), Stadt',
	'DE06440022' => 'Rockenberg',
	'DE06440023' => 'Rosbach v. d. Höhe, Stadt',
	'DE06440024' => 'Wölfersheim',
	'DE06440025' => 'Wöllstadt',
	'DE06531001' => 'Allendorf (Lumda), Stadt',
	'DE06531002' => 'Biebertal',
	'DE06531003' => 'Buseck',
	'DE06531004' => 'Fernwald',
	'DE06531005' => 'Gießen, Universitätsstadt',
	'DE06531006' => 'Grünberg, Stadt',
	'DE06531007' => 'Heuchelheim',
	'DE06531008' => 'Hungen, Stadt',
	'DE06531009' => 'Langgöns',
	'DE06531010' => 'Laubach, Stadt',
	'DE06531011' => 'Lich, Stadt',
	'DE06531012' => 'Linden, Stadt',
	'DE06531013' => 'Lollar, Stadt',
	'DE06531014' => 'Pohlheim, Stadt',
	'DE06531015' => 'Rabenau',
	'DE06531016' => 'Reiskirchen',
	'DE06531017' => 'Staufenberg, Stadt',
	'DE06531018' => 'Wettenberg',
	'DE06532001' => 'Aßlar, Stadt',
	'DE06532002' => 'Bischoffen',
	'DE06532003' => 'Braunfels, Stadt',
	'DE06532004' => 'Breitscheid',
	'DE06532005' => 'Dietzhölztal',
	'DE06532006' => 'Dillenburg, Oranienstadt',
	'DE06532007' => 'Driedorf',
	'DE06532008' => 'Ehringshausen',
	'DE06532009' => 'Eschenburg',
	'DE06532010' => 'Greifenstein',
	'DE06532011' => 'Haiger, Stadt',
	'DE06532012' => 'Herborn, Stadt',
	'DE06532013' => 'Hohenahr',
	'DE06532014' => 'Hüttenberg',
	'DE06532015' => 'Lahnau',
	'DE06532016' => 'Leun, Stadt',
	'DE06532017' => 'Mittenaar',
	'DE06532018' => 'Schöffengrund',
	'DE06532019' => 'Siegbach',
	'DE06532020' => 'Sinn',
	'DE06532021' => 'Solms, Stadt',
	'DE06532022' => 'Waldsolms',
	'DE06532023' => 'Wetzlar, Stadt',
	'DE06533001' => 'Beselich',
	'DE06533002' => 'Brechen',
	'DE06533003' => 'Bad Camberg, Stadt',
	'DE06533004' => 'Dornburg',
	'DE06533005' => 'Elbtal',
	'DE06533006' => 'Elz',
	'DE06533007' => 'Hadamar, Stadt',
	'DE06533008' => 'Hünfelden',
	'DE06533009' => 'Limburg a.d. Lahn, Kreisstadt',
	'DE06533010' => 'Löhnberg',
	'DE06533011' => 'Mengerskirchen, Marktflecken',
	'DE06533012' => 'Merenberg, Marktflecken',
	'DE06533013' => 'Runkel, Stadt',
	'DE06533014' => 'Selters (Taunus)',
	'DE06533015' => 'Villmar, Marktflecken',
	'DE06533016' => 'Waldbrunn (Westerwald)',
	'DE06533017' => 'Weilburg, Stadt',
	'DE06533018' => 'Weilmünster, Marktflecken',
	'DE06533019' => 'Weinbach',
	'DE06534001' => 'Amöneburg, Stadt',
	'DE06534002' => 'Angelburg',
	'DE06534003' => 'Bad Endbach',
	'DE06534004' => 'Biedenkopf, Stadt',
	'DE06534005' => 'Breidenbach',
	'DE06534006' => 'Cölbe',
	'DE06534007' => 'Dautphetal',
	'DE06534008' => 'Ebsdorfergrund',
	'DE06534009' => 'Fronhausen',
	'DE06534010' => 'Gladenbach, Stadt',
	'DE06534011' => 'Kirchhain, Stadt',
	'DE06534012' => 'Lahntal',
	'DE06534013' => 'Lohra',
	'DE06534014' => 'Marburg, Universitätsstadt',
	'DE06534015' => 'Münchhausen',
	'DE06534016' => 'Neustadt (Hessen), Stadt',
	'DE06534017' => 'Rauschenberg, Stadt',
	'DE06534018' => 'Stadtallendorf, Stadt',
	'DE06534019' => 'Steffenberg',
	'DE06534020' => 'Weimar (Lahn)',
	'DE06534021' => 'Wetter (Hessen), Stadt',
	'DE06534022' => 'Wohratal',
	'DE06535001' => 'Alsfeld, Stadt',
	'DE06535002' => 'Antrifttal',
	'DE06535003' => 'Feldatal',
	'DE06535004' => 'Freiensteinau',
	'DE06535005' => 'Gemünden (Felda)',
	'DE06535006' => 'Grebenau, Stadt',
	'DE06535007' => 'Grebenhain',
	'DE06535008' => 'Herbstein, Stadt',
	'DE06535009' => 'Homberg (Ohm), Stadt',
	'DE06535010' => 'Kirtorf, Stadt',
	'DE06535011' => 'Lauterbach (Hessen), Kreisstadt',
	'DE06535012' => 'Lautertal (Vogelsberg)',
	'DE06535013' => 'Mücke',
	'DE06535014' => 'Romrod, Stadt',
	'DE06535015' => 'Schlitz, Stadt',
	'DE06535016' => 'Schotten, Stadt',
	'DE06535017' => 'Schwalmtal',
	'DE06535018' => 'Ulrichstein, Stadt',
	'DE06535019' => 'Wartenberg',
	'DE06611000' => 'Kassel, documenta-Stadt',
	'DE06631001' => 'Bad Salzschlirf',
	'DE06631002' => 'Burghaun, Marktgemeinde',
	'DE06631003' => 'Dipperz',
	'DE06631004' => 'Ebersburg',
	'DE06631005' => 'Ehrenberg (Rhön)',
	'DE06631006' => 'Eichenzell',
	'DE06631007' => 'Eiterfeld, Marktgemeinde',
	'DE06631008' => 'Flieden',
	'DE06631009' => 'Fulda, Stadt',
	'DE06631010' => 'Gersfeld (Rhön), Stadt',
	'DE06631011' => 'Großenlüder',
	'DE06631012' => 'Hilders, Marktgemeinde',
	'DE06631013' => 'Hofbieber',
	'DE06631014' => 'Hosenfeld',
	'DE06631015' => 'Hünfeld, Konrad-Zuse-Stadt',
	'DE06631016' => 'Kalbach',
	'DE06631017' => 'Künzell',
	'DE06631018' => 'Neuhof',
	'DE06631019' => 'Nüsttal',
	'DE06631020' => 'Petersberg',
	'DE06631021' => 'Poppenhausen (Wasserkuppe)',
	'DE06631022' => 'Rasdorf, Point-Alpha-Gemeinde',
	'DE06631023' => 'Tann (Rhön), Stadt',
	'DE06632001' => 'Alheim',
	'DE06632002' => 'Bad Hersfeld, Kreisstadt',
	'DE06632003' => 'Bebra, Stadt',
	'DE06632004' => 'Breitenbach a. Herzberg',
	'DE06632005' => 'Cornberg',
	'DE06632006' => 'Friedewald',
	'DE06632007' => 'Hauneck',
	'DE06632008' => 'Haunetal',
	'DE06632009' => 'Heringen (Werra), Stadt',
	'DE06632010' => 'Hohenroda',
	'DE06632011' => 'Kirchheim',
	'DE06632012' => 'Ludwigsau',
	'DE06632013' => 'Nentershausen',
	'DE06632014' => 'Neuenstein',
	'DE06632015' => 'Niederaula, Marktgemeinde',
	'DE06632016' => 'Philippsthal (Werra), Marktgemeinde',
	'DE06632017' => 'Ronshausen',
	'DE06632018' => 'Rotenburg a. d. Fulda, Stadt',
	'DE06632019' => 'Schenklengsfeld',
	'DE06632020' => 'Wildeck',
	'DE06633001' => 'Ahnatal',
	'DE06633002' => 'Bad Karlshafen, Stadt',
	'DE06633003' => 'Baunatal, Stadt',
	'DE06633004' => 'Breuna',
	'DE06633005' => 'Calden',
	'DE06633006' => 'Bad Emstal',
	'DE06633007' => 'Espenau',
	'DE06633008' => 'Fuldabrück',
	'DE06633009' => 'Fuldatal',
	'DE06633010' => 'Grebenstein, Stadt',
	'DE06633011' => 'Habichtswald',
	'DE06633012' => 'Helsa',
	'DE06633013' => 'Hofgeismar, Stadt',
	'DE06633014' => 'Immenhausen, Stadt',
	'DE06633015' => 'Kaufungen',
	'DE06633016' => 'Liebenau, Stadt',
	'DE06633017' => 'Lohfelden',
	'DE06633018' => 'Naumburg, Stadt',
	'DE06633019' => 'Nieste',
	'DE06633020' => 'Niestetal',
	'DE06633021' => 'Oberweser',
	'DE06633022' => 'Reinhardshagen',
	'DE06633023' => 'Schauenburg',
	'DE06633024' => 'Söhrewald',
	'DE06633025' => 'Trendelburg, Stadt',
	'DE06633026' => 'Vellmar, Stadt',
	'DE06633027' => 'Wahlsburg',
	'DE06633028' => 'Wolfhagen, Stadt',
	'DE06633029' => 'Zierenberg, Stadt',
	'DE06633200' => 'Gutsbezirk Reinhardswald, gemfr. Gebiet',
	'DE06634001' => 'Borken (Hessen), Stadt',
	'DE06634002' => 'Edermünde',
	'DE06634003' => 'Felsberg, Stadt',
	'DE06634004' => 'Frielendorf',
	'DE06634005' => 'Fritzlar, Dom- und Kaiserstadt',
	'DE06634006' => 'Gilserberg',
	'DE06634007' => 'Gudensberg, Stadt',
	'DE06634008' => 'Guxhagen',
	'DE06634009' => 'Homberg (Efze), Reformationsstadt, Kreisstadt',
	'DE06634010' => 'Jesberg',
	'DE06634011' => 'Knüllwald',
	'DE06634012' => 'Körle',
	'DE06634013' => 'Malsfeld',
	'DE06634014' => 'Melsungen, Stadt',
	'DE06634015' => 'Morschen',
	'DE06634016' => 'Neuental',
	'DE06634017' => 'Neukirchen, Stadt',
	'DE06634018' => 'Niedenstein, Stadt',
	'DE06634019' => 'Oberaula',
	'DE06634020' => 'Ottrau',
	'DE06634021' => 'Schrecksbach',
	'DE06634022' => 'Schwalmstadt, Konfirmationsstadt',
	'DE06634023' => 'Schwarzenborn, Stadt',
	'DE06634024' => 'Spangenberg, Liebenbachstadt',
	'DE06634025' => 'Wabern',
	'DE06634026' => 'Willingshausen',
	'DE06634027' => 'Bad Zwesten',
	'DE06635001' => 'Allendorf (Eder)',
	'DE06635002' => 'Bad Arolsen, Stadt',
	'DE06635003' => 'Bad Wildungen, Stadt',
	'DE06635004' => 'Battenberg (Eder), Stadt',
	'DE06635005' => 'Bromskirchen',
	'DE06635006' => 'Burgwald',
	'DE06635007' => 'Diemelsee',
	'DE06635008' => 'Diemelstadt, Stadt',
	'DE06635009' => 'Edertal',
	'DE06635010' => 'Frankenau, Stadt',
	'DE06635011' => 'Frankenberg (Eder), Philipp-Soldan-Stadt',
	'DE06635012' => 'Gemünden (Wohra), Stadt',
	'DE06635013' => 'Haina (Kloster)',
	'DE06635014' => 'Hatzfeld (Eder), Stadt',
	'DE06635015' => 'Korbach, Hansestadt, Kreisstadt',
	'DE06635016' => 'Lichtenfels, Stadt',
	'DE06635017' => 'Rosenthal, Stadt',
	'DE06635018' => 'Twistetal',
	'DE06635019' => 'Vöhl',
	'DE06635020' => 'Volkmarsen, Stadt',
	'DE06635021' => 'Waldeck, Stadt',
	'DE06635022' => 'Willingen (Upland)',
	'DE06636001' => 'Bad Sooden-Allendorf, Stadt',
	'DE06636002' => 'Berkatal',
	'DE06636003' => 'Eschwege, Kreisstadt',
	'DE06636004' => 'Großalmerode, Stadt',
	'DE06636005' => 'Herleshausen',
	'DE06636006' => 'Hessisch Lichtenau, Stadt',
	'DE06636007' => 'Meinhard',
	'DE06636008' => 'Meißner',
	'DE06636009' => 'Neu-Eichenberg',
	'DE06636010' => 'Ringgau',
	'DE06636011' => 'Sontra, Stadt',
	'DE06636012' => 'Waldkappel, Stadt',
	'DE06636013' => 'Wanfried, Stadt',
	'DE06636014' => 'Wehretal',
	'DE06636015' => 'Weißenborn',
	'DE06636016' => 'Witzenhausen, Stadt',
	'DE06636200' => 'Gutsbezirk Kaufunger Wald, gemfr. Gebiet',
	'DE07111000' => 'Koblenz, Stadt',
	'DE07131001' => 'Adenau, Stadt',
	'DE07131002' => 'Ahrbrück',
	'DE07131003' => 'Altenahr',
	'DE07131004' => 'Antweiler',
	'DE07131005' => 'Aremberg',
	'DE07131006' => 'Bad Breisig, Stadt',
	'DE07131007' => 'Bad Neuenahr-Ahrweiler, Stadt',
	'DE07131008' => 'Barweiler',
	'DE07131009' => 'Bauler',
	'DE07131011' => 'Berg',
	'DE07131014' => 'Brohl-Lützing',
	'DE07131015' => 'Dankerath',
	'DE07131016' => 'Dedenbach',
	'DE07131017' => 'Dernau',
	'DE07131018' => 'Dorsel',
	'DE07131021' => 'Eichenbach',
	'DE07131022' => 'Fuchshofen',
	'DE07131025' => 'Gönnersdorf',
	'DE07131026' => 'Harscheid',
	'DE07131027' => 'Heckenbach',
	'DE07131028' => 'Herschbroich',
	'DE07131029' => 'Hönningen',
	'DE07131030' => 'Hoffeld',
	'DE07131032' => 'Honerath',
	'DE07131033' => 'Hümmel',
	'DE07131034' => 'Insul',
	'DE07131036' => 'Kalenborn',
	'DE07131037' => 'Kaltenborn',
	'DE07131039' => 'Kesseling',
	'DE07131040' => 'Kirchsahr',
	'DE07131041' => 'Königsfeld',
	'DE07131042' => 'Kottenborn',
	'DE07131044' => 'Leimbach',
	'DE07131047' => 'Lind',
	'DE07131049' => 'Mayschoß',
	'DE07131050' => 'Meuspath',
	'DE07131051' => 'Müllenbach',
	'DE07131052' => 'Müsch',
	'DE07131054' => 'Niederdürenbach',
	'DE07131055' => 'Niederzissen',
	'DE07131058' => 'Nürburg',
	'DE07131059' => 'Oberdürenbach',
	'DE07131060' => 'Oberzissen',
	'DE07131062' => 'Ohlenhard',
	'DE07131065' => 'Pomster',
	'DE07131066' => 'Quiddelbach',
	'DE07131068' => 'Rech',
	'DE07131069' => 'Reifferscheid',
	'DE07131070' => 'Remagen, Stadt',
	'DE07131072' => 'Rodder',
	'DE07131073' => 'Schalkenbach',
	'DE07131074' => 'Schuld',
	'DE07131075' => 'Senscheid',
	'DE07131076' => 'Sierscheid',
	'DE07131077' => 'Sinzig, Stadt',
	'DE07131079' => 'Trierscheid',
	'DE07131081' => 'Waldorf',
	'DE07131082' => 'Wershofen',
	'DE07131083' => 'Wiesemscheid',
	'DE07131084' => 'Wimbach',
	'DE07131085' => 'Winnerath',
	'DE07131086' => 'Wirft',
	'DE07131090' => 'Grafschaft',
	'DE07131201' => 'Brenk',
	'DE07131202' => 'Burgbrohl',
	'DE07131204' => 'Galenberg',
	'DE07131205' => 'Glees',
	'DE07131206' => 'Hohenleimbach',
	'DE07131208' => 'Spessart',
	'DE07131209' => 'Wassenach',
	'DE07131210' => 'Wehr',
	'DE07131211' => 'Weibern',
	'DE07131501' => 'Dümpelfeld',
	'DE07131502' => 'Kempenich',
	'DE07132001' => 'Almersbach',
	'DE07132002' => 'Alsdorf',
	'DE07132004' => 'Bachenberg',
	'DE07132005' => 'Berzhausen',
	'DE07132006' => 'Betzdorf, Stadt',
	'DE07132007' => 'Birkenbeul',
	'DE07132008' => 'Birken-Honigsessen',
	'DE07132009' => 'Birnbach',
	'DE07132010' => 'Bitzen',
	'DE07132011' => 'Mittelhof',
	'DE07132012' => 'Brachbach',
	'DE07132013' => 'Breitscheidt',
	'DE07132014' => 'Bruchertseifen',
	'DE07132015' => 'Bürdenbach',
	'DE07132016' => 'Burglahr',
	'DE07132017' => 'Busenhausen',
	'DE07132018' => 'Daaden, Stadt',
	'DE07132019' => 'Derschen',
	'DE07132020' => 'Dickendorf',
	'DE07132022' => 'Eichelhardt',
	'DE07132023' => 'Eichen',
	'DE07132024' => 'Elben',
	'DE07132025' => 'Elkenroth',
	'DE07132026' => 'Emmerzhausen',
	'DE07132027' => 'Ersfeld',
	'DE07132028' => 'Etzbach',
	'DE07132029' => 'Eulenberg',
	'DE07132030' => 'Fensdorf',
	'DE07132031' => 'Fiersbach',
	'DE07132032' => 'Flammersfeld',
	'DE07132033' => 'Fluterschen',
	'DE07132034' => 'Forst',
	'DE07132035' => 'Forstmehren',
	'DE07132036' => 'Friedewald',
	'DE07132037' => 'Friesenhagen',
	'DE07132038' => 'Fürthen',
	'DE07132039' => 'Gebhardshain',
	'DE07132040' => 'Gieleroth',
	'DE07132041' => 'Giershausen',
	'DE07132042' => 'Grünebach',
	'DE07132043' => 'Güllesheim',
	'DE07132044' => 'Hamm (Sieg)',
	'DE07132045' => 'Harbach',
	'DE07132046' => 'Hasselbach',
	'DE07132047' => 'Helmenzen',
	'DE07132048' => 'Helmeroth',
	'DE07132049' => 'Hemmelzen',
	'DE07132050' => 'Herdorf, Stadt',
	'DE07132051' => 'Heupelzen',
	'DE07132052' => 'Hilgenroth',
	'DE07132053' => 'Hirz-Maulsbach',
	'DE07132054' => 'Hövels',
	'DE07132055' => 'Horhausen (Westerwald)',
	'DE07132056' => 'Idelberg',
	'DE07132057' => 'Ingelbach',
	'DE07132058' => 'Isert',
	'DE07132059' => 'Kausen',
	'DE07132060' => 'Kescheid',
	'DE07132061' => 'Kettenhausen',
	'DE07132062' => 'Kircheib',
	'DE07132063' => 'Kirchen (Sieg), Stadt',
	'DE07132064' => 'Kraam',
	'DE07132065' => 'Krunkel',
	'DE07132066' => 'Malberg',
	'DE07132067' => 'Mammelzen',
	'DE07132068' => 'Mauden',
	'DE07132069' => 'Mehren',
	'DE07132070' => 'Michelbach (Westerwald)',
	'DE07132071' => 'Molzhain',
	'DE07132072' => 'Mudersbach',
	'DE07132073' => 'Nauroth',
	'DE07132074' => 'Neitersen',
	'DE07132075' => 'Niederdreisbach',
	'DE07132076' => 'Niederfischbach',
	'DE07132077' => 'Niederirsen',
	'DE07132078' => 'Niedersteinebach',
	'DE07132079' => 'Nisterberg',
	'DE07132080' => 'Katzwinkel (Sieg)',
	'DE07132081' => 'Obererbach (Westerwald)',
	'DE07132082' => 'Oberirsen',
	'DE07132083' => 'Oberlahr',
	'DE07132084' => 'Obernau',
	'DE07132085' => 'Obersteinebach',
	'DE07132086' => 'Oberwambach',
	'DE07132087' => 'Ölsen',
	'DE07132088' => 'Orfgen',
	'DE07132089' => 'Peterslahr',
	'DE07132090' => 'Pleckhausen',
	'DE07132091' => 'Pracht',
	'DE07132092' => 'Racksen',
	'DE07132093' => 'Reiferscheid',
	'DE07132094' => 'Rettersen',
	'DE07132095' => 'Rosenheim (Landkreis Altenkirchen)',
	'DE07132096' => 'Roth',
	'DE07132097' => 'Rott',
	'DE07132098' => 'Scheuerfeld',
	'DE07132099' => 'Schöneberg',
	'DE07132100' => 'Schürdt',
	'DE07132101' => 'Schutzbach',
	'DE07132102' => 'Seelbach bei Hamm (Sieg)',
	'DE07132103' => 'Seelbach (Westerwald)',
	'DE07132104' => 'Seifen',
	'DE07132105' => 'Selbach (Sieg)',
	'DE07132106' => 'Sörth',
	'DE07132107' => 'Steinebach/ Sieg',
	'DE07132108' => 'Steineroth',
	'DE07132109' => 'Stürzelbach',
	'DE07132110' => 'Volkerzen',
	'DE07132111' => 'Wallmenroth',
	'DE07132112' => 'Walterschen',
	'DE07132113' => 'Weitefeld',
	'DE07132114' => 'Werkhausen',
	'DE07132115' => 'Weyerbusch',
	'DE07132116' => 'Willroth',
	'DE07132117' => 'Wissen, Stadt',
	'DE07132118' => 'Wölmersen',
	'DE07132119' => 'Ziegenhain',
	'DE07132201' => 'Berod bei Hachenburg',
	'DE07132501' => 'Altenkirchen (Westerwald), Stadt',
	'DE07133001' => 'Abtweiler',
	'DE07133002' => 'Allenfeld',
	'DE07133003' => 'Altenbamberg',
	'DE07133004' => 'Argenschwang',
	'DE07133005' => 'Auen',
	'DE07133006' => 'Bad Kreuznach, Stadt',
	'DE07133008' => 'Bärenbach',
	'DE07133009' => 'Bärweiler',
	'DE07133010' => 'Becherbach bei Kirn',
	'DE07133011' => 'Becherbach',
	'DE07133012' => 'Biebelsheim',
	'DE07133013' => 'Bockenau',
	'DE07133014' => 'Boos',
	'DE07133015' => 'Braunweiler',
	'DE07133016' => 'Brauweiler',
	'DE07133017' => 'Breitenheim',
	'DE07133018' => 'Bretzenheim',
	'DE07133019' => 'Burgsponheim',
	'DE07133020' => 'Callbach',
	'DE07133021' => 'Dalberg',
	'DE07133022' => 'Daubach',
	'DE07133023' => 'Daxweiler',
	'DE07133024' => 'Desloch',
	'DE07133025' => 'Dörrebach',
	'DE07133026' => 'Dorsheim',
	'DE07133027' => 'Duchroth',
	'DE07133028' => 'Eckenroth',
	'DE07133030' => 'Feilbingert',
	'DE07133031' => 'Frei-Laubersheim',
	'DE07133032' => 'Fürfeld',
	'DE07133033' => 'Gebroth',
	'DE07133035' => 'Guldental',
	'DE07133036' => 'Gutenberg',
	'DE07133037' => 'Hackenheim',
	'DE07133038' => 'Hahnenbach',
	'DE07133039' => 'Hallgarten',
	'DE07133040' => 'Hargesheim',
	'DE07133041' => 'Heimweiler',
	'DE07133042' => 'Heinzenberg',
	'DE07133043' => 'Hennweiler',
	'DE07133044' => 'Hergenfeld',
	'DE07133045' => 'Hochstätten',
	'DE07133046' => 'Hochstetten-Dhaun',
	'DE07133047' => 'Horbach',
	'DE07133048' => 'Hüffelsheim',
	'DE07133049' => 'Hundsbach',
	'DE07133050' => 'Ippenschied',
	'DE07133051' => 'Jeckenbach',
	'DE07133052' => 'Kirn, Stadt',
	'DE07133053' => 'Kirschroth',
	'DE07133054' => 'Langenlonsheim',
	'DE07133055' => 'Langenthal',
	'DE07133056' => 'Laubenheim',
	'DE07133057' => 'Lauschied',
	'DE07133058' => 'Lettweiler',
	'DE07133059' => 'Limbach',
	'DE07133060' => 'Löllbach',
	'DE07133061' => 'Mandel',
	'DE07133062' => 'Martinstein',
	'DE07133063' => 'Meckenbach',
	'DE07133064' => 'Meddersheim',
	'DE07133065' => 'Meisenheim, Stadt',
	'DE07133066' => 'Merxheim',
	'DE07133067' => 'Monzingen',
	'DE07133068' => 'Münchwald',
	'DE07133069' => 'Neu-Bamberg',
	'DE07133070' => 'Niederhausen',
	'DE07133071' => 'Norheim',
	'DE07133072' => 'Nußbaum',
	'DE07133073' => 'Oberhausen bei Kirn',
	'DE07133074' => 'Oberhausen an der Nahe',
	'DE07133075' => 'Oberstreit',
	'DE07133076' => 'Odernheim am Glan',
	'DE07133077' => 'Otzweiler',
	'DE07133078' => 'Pfaffen-Schwabenheim',
	'DE07133080' => 'Pleitersheim',
	'DE07133081' => 'Raumbach',
	'DE07133082' => 'Rehbach',
	'DE07133083' => 'Rehborn',
	'DE07133084' => 'Reiffelbach',
	'DE07133085' => 'Roth',
	'DE07133086' => 'Roxheim',
	'DE07133087' => 'Rümmelsheim',
	'DE07133088' => 'Sankt Katharinen',
	'DE07133089' => 'Schloßböckelheim',
	'DE07133090' => 'Schmittweiler',
	'DE07133091' => 'Schöneberg',
	'DE07133092' => 'Schweinschied',
	'DE07133093' => 'Schweppenhausen',
	'DE07133094' => 'Seesbach',
	'DE07133095' => 'Seibersbach',
	'DE07133096' => 'Simmertal',
	'DE07133098' => 'Sommerloch',
	'DE07133099' => 'Spabrücken',
	'DE07133100' => 'Spall',
	'DE07133101' => 'Sponheim',
	'DE07133102' => 'Staudernheim',
	'DE07133103' => 'Stromberg, Stadt',
	'DE07133104' => 'Tiefenthal',
	'DE07133105' => 'Traisen',
	'DE07133106' => 'Volxheim',
	'DE07133107' => 'Waldböckelheim',
	'DE07133108' => 'Waldlaubersheim',
	'DE07133109' => 'Wallhausen',
	'DE07133110' => 'Warmsroth',
	'DE07133111' => 'Weiler bei Monzingen',
	'DE07133112' => 'Weinsheim',
	'DE07133113' => 'Weitersborn',
	'DE07133114' => 'Windesheim',
	'DE07133115' => 'Winterbach',
	'DE07133116' => 'Winterburg',
	'DE07133117' => 'Rüdesheim',
	'DE07133201' => 'Bruschied',
	'DE07133202' => 'Kellenbach',
	'DE07133203' => 'Königsau',
	'DE07133204' => 'Schneppenbach',
	'DE07133205' => 'Schwarzerden',
	'DE07133501' => 'Bad Sobernheim, Stadt',
	'DE07134001' => 'Abentheuer',
	'DE07134002' => 'Achtelsbach',
	'DE07134003' => 'Allenbach',
	'DE07134004' => 'Asbach',
	'DE07134005' => 'Baumholder, Stadt',
	'DE07134006' => 'Bergen',
	'DE07134007' => 'Berglangenbach',
	'DE07134008' => 'Berschweiler bei Baumholder',
	'DE07134009' => 'Berschweiler bei Kirn',
	'DE07134010' => 'Birkenfeld, Stadt',
	'DE07134011' => 'Börfink',
	'DE07134012' => 'Bollenbach',
	'DE07134013' => 'Breitenthal',
	'DE07134014' => 'Bruchweiler',
	'DE07134015' => 'Brücken',
	'DE07134016' => 'Buhlenberg',
	'DE07134017' => 'Bundenbach',
	'DE07134018' => 'Dambach',
	'DE07134019' => 'Dickesbach',
	'DE07134020' => 'Dienstweiler',
	'DE07134021' => 'Eckersweiler',
	'DE07134022' => 'Elchweiler',
	'DE07134023' => 'Ellenberg',
	'DE07134024' => 'Ellweiler',
	'DE07134025' => 'Fischbach',
	'DE07134026' => 'Fohren-Linden',
	'DE07134027' => 'Frauenberg',
	'DE07134028' => 'Gerach',
	'DE07134029' => 'Gimbweiler',
	'DE07134030' => 'Gösenroth',
	'DE07134031' => 'Gollenberg',
	'DE07134032' => 'Griebelschied',
	'DE07134033' => 'Hahnweiler',
	'DE07134034' => 'Hattgenstein',
	'DE07134035' => 'Hausen',
	'DE07134036' => 'Heimbach',
	'DE07134037' => 'Hellertshausen',
	'DE07134038' => 'Herborn',
	'DE07134039' => 'Herrstein',
	'DE07134040' => 'Hettenrodt',
	'DE07134041' => 'Hintertiefenbach',
	'DE07134042' => 'Hoppstädten-Weiersbach',
	'DE07134043' => 'Horbruch',
	'DE07134044' => 'Hottenbach',
	'DE07134045' => 'Idar-Oberstein, Stadt',
	'DE07134046' => 'Kempfeld',
	'DE07134047' => 'Kirschweiler',
	'DE07134048' => 'Kronweiler',
	'DE07134049' => 'Krummenau',
	'DE07134050' => 'Leisel',
	'DE07134051' => 'Leitzweiler',
	'DE07134052' => 'Mackenrodt',
	'DE07134053' => 'Meckenbach',
	'DE07134054' => 'Mettweiler',
	'DE07134055' => 'Mittelreidenbach',
	'DE07134056' => 'Mörschied',
	'DE07134057' => 'Niederbrombach',
	'DE07134058' => 'Niederhambach',
	'DE07134059' => 'Niederhosenbach',
	'DE07134060' => 'Niederwörresbach',
	'DE07134061' => 'Nohen',
	'DE07134062' => 'Oberbrombach',
	'DE07134063' => 'Oberhambach',
	'DE07134064' => 'Oberhosenbach',
	'DE07134065' => 'Oberkirn',
	'DE07134066' => 'Oberreidenbach',
	'DE07134067' => 'Oberwörresbach',
	'DE07134068' => 'Reichenbach',
	'DE07134069' => 'Rhaunen',
	'DE07134070' => 'Rimsberg',
	'DE07134071' => 'Rinzenberg',
	'DE07134072' => 'Rötsweiler-Nockenthal',
	'DE07134073' => 'Rohrbach',
	'DE07134074' => 'Rückweiler',
	'DE07134075' => 'Ruschberg',
	'DE07134076' => 'Schauren',
	'DE07134077' => 'Schmidthachenbach',
	'DE07134078' => 'Schmißberg',
	'DE07134079' => 'Schwerbach',
	'DE07134080' => 'Schwollen',
	'DE07134081' => 'Sensweiler',
	'DE07134082' => 'Sien',
	'DE07134083' => 'Sienhachenbach',
	'DE07134084' => 'Siesbach',
	'DE07134085' => 'Sonnenberg-Winnenberg',
	'DE07134086' => 'Sonnschied',
	'DE07134087' => 'Stipshausen',
	'DE07134088' => 'Sulzbach',
	'DE07134089' => 'Veitsrodt',
	'DE07134090' => 'Vollmersbach',
	'DE07134091' => 'Weiden',
	'DE07134092' => 'Weitersbach',
	'DE07134093' => 'Wickenrodt',
	'DE07134094' => 'Wilzenberg-Hußweiler',
	'DE07134095' => 'Wirschweiler',
	'DE07134502' => 'Langweiler',
	'DE07135001' => 'Alf',
	'DE07135002' => 'Alflen',
	'DE07135003' => 'Altlay',
	'DE07135004' => 'Altstrimmig',
	'DE07135005' => 'Auderath',
	'DE07135007' => 'Beilstein',
	'DE07135008' => 'Beuren',
	'DE07135009' => 'Binningen',
	'DE07135010' => 'Blankenrath',
	'DE07135011' => 'Brachtendorf',
	'DE07135012' => 'Bremm',
	'DE07135013' => 'Briedel',
	'DE07135014' => 'Brieden',
	'DE07135015' => 'Briedern',
	'DE07135016' => 'Brohl',
	'DE07135017' => 'Bruttig-Fankel',
	'DE07135018' => 'Büchel',
	'DE07135019' => 'Bullay',
	'DE07135020' => 'Cochem, Stadt',
	'DE07135021' => 'Dohr',
	'DE07135022' => 'Dünfus',
	'DE07135023' => 'Düngenheim',
	'DE07135024' => 'Ediger-Eller',
	'DE07135025' => 'Ellenz-Poltersdorf',
	'DE07135026' => 'Eppenberg',
	'DE07135027' => 'Ernst',
	'DE07135028' => 'Eulgem',
	'DE07135029' => 'Faid',
	'DE07135030' => 'Filz',
	'DE07135031' => 'Forst (Eifel)',
	'DE07135032' => 'Forst (Hunsrück)',
	'DE07135033' => 'Gamlen',
	'DE07135034' => 'Gevenich',
	'DE07135035' => 'Gillenbeuren',
	'DE07135036' => 'Greimersburg',
	'DE07135037' => 'Grenderich',
	'DE07135038' => 'Hambuch',
	'DE07135039' => 'Haserich',
	'DE07135040' => 'Hauroth',
	'DE07135041' => 'Hesweiler',
	'DE07135042' => 'Illerich',
	'DE07135043' => 'Kaifenheim',
	'DE07135044' => 'Kail',
	'DE07135045' => 'Kaisersesch, Stadt',
	'DE07135046' => 'Kalenborn',
	'DE07135048' => 'Kliding',
	'DE07135049' => 'Klotten',
	'DE07135051' => 'Landkern',
	'DE07135052' => 'Laubach',
	'DE07135053' => 'Lieg',
	'DE07135054' => 'Liesenich',
	'DE07135056' => 'Lütz',
	'DE07135057' => 'Lutzerath',
	'DE07135058' => 'Masburg',
	'DE07135060' => 'Mesenich',
	'DE07135061' => 'Mittelstrimmig',
	'DE07135062' => 'Möntenich',
	'DE07135064' => 'Moritzheim',
	'DE07135065' => 'Moselkern',
	'DE07135066' => 'Müden (Mosel)',
	'DE07135067' => 'Müllenbach',
	'DE07135068' => 'Neef',
	'DE07135069' => 'Nehren',
	'DE07135070' => 'Panzweiler',
	'DE07135071' => 'Peterswald-Löffelscheid',
	'DE07135072' => 'Pommern',
	'DE07135073' => 'Pünderich',
	'DE07135074' => 'Reidenhausen',
	'DE07135075' => 'Roes',
	'DE07135076' => 'Sankt Aldegund',
	'DE07135077' => 'Schauren',
	'DE07135078' => 'Schmitt',
	'DE07135079' => 'Senheim',
	'DE07135080' => 'Sosberg',
	'DE07135081' => 'Tellig',
	'DE07135082' => 'Treis-Karden',
	'DE07135083' => 'Ulmen, Stadt',
	'DE07135084' => 'Urmersbach',
	'DE07135085' => 'Urschmitt',
	'DE07135086' => 'Valwig',
	'DE07135087' => 'Wagenhausen',
	'DE07135088' => 'Walhausen',
	'DE07135089' => 'Weiler',
	'DE07135090' => 'Wirfus',
	'DE07135091' => 'Wollmerath',
	'DE07135092' => 'Zell (Mosel), Stadt',
	'DE07135093' => 'Zettingen',
	'DE07135501' => 'Bad Bertrich',
	'DE07135502' => 'Leienkaul',
	'DE07137001' => 'Acht',
	'DE07137003' => 'Andernach, Stadt',
	'DE07137004' => 'Anschau',
	'DE07137006' => 'Arft',
	'DE07137007' => 'Baar',
	'DE07137008' => 'Bell',
	'DE07137011' => 'Bermel',
	'DE07137014' => 'Boos',
	'DE07137019' => 'Ditscheid',
	'DE07137023' => 'Einig',
	'DE07137025' => 'Ettringen',
	'DE07137027' => 'Gappenach',
	'DE07137029' => 'Gering',
	'DE07137030' => 'Gierschnach',
	'DE07137034' => 'Hausten',
	'DE07137035' => 'Herresbach',
	'DE07137036' => 'Hirten',
	'DE07137041' => 'Kalt',
	'DE07137043' => 'Kehrig',
	'DE07137048' => 'Kerben',
	'DE07137049' => 'Kirchwald',
	'DE07137053' => 'Kollig',
	'DE07137055' => 'Kottenheim',
	'DE07137056' => 'Kretz',
	'DE07137057' => 'Kruft',
	'DE07137060' => 'Langenfeld',
	'DE07137061' => 'Langscheid',
	'DE07137063' => 'Lind',
	'DE07137065' => 'Lonnig',
	'DE07137066' => 'Luxem',
	'DE07137068' => 'Mayen, Stadt',
	'DE07137069' => 'Mendig, Stadt',
	'DE07137070' => 'Mertloch',
	'DE07137074' => 'Monreal',
	'DE07137077' => 'Münk',
	'DE07137079' => 'Nachtsheim',
	'DE07137080' => 'Naunheim',
	'DE07137081' => 'Nickenich',
	'DE07137086' => 'Ochtendung',
	'DE07137087' => 'Pillig',
	'DE07137088' => 'Plaidt',
	'DE07137089' => 'Polch, Stadt',
	'DE07137092' => 'Reudelsterz',
	'DE07137093' => 'Rieden',
	'DE07137095' => 'Rüber',
	'DE07137096' => 'Saffig',
	'DE07137097' => 'Sankt Johann',
	'DE07137099' => 'Siebenbach',
	'DE07137101' => 'Thür',
	'DE07137102' => 'Trimbs',
	'DE07137105' => 'Virneburg',
	'DE07137106' => 'Volkesfeld',
	'DE07137110' => 'Weiler',
	'DE07137112' => 'Welling',
	'DE07137113' => 'Welschenbach',
	'DE07137114' => 'Wierschem',
	'DE07137201' => 'Alken',
	'DE07137202' => 'Bassenheim',
	'DE07137203' => 'Bendorf, Stadt',
	'DE07137204' => 'Brey',
	'DE07137205' => 'Brodenbach',
	'DE07137206' => 'Burgen',
	'DE07137207' => 'Dieblich',
	'DE07137208' => 'Hatzenport',
	'DE07137209' => 'Kaltenengers',
	'DE07137211' => 'Kettig',
	'DE07137212' => 'Kobern-Gondorf',
	'DE07137214' => 'Löf',
	'DE07137215' => 'Macken',
	'DE07137216' => 'Mülheim-Kärlich, Stadt',
	'DE07137217' => 'Niederfell',
	'DE07137218' => 'Niederwerth',
	'DE07137219' => 'Nörtershausen',
	'DE07137220' => 'Oberfell',
	'DE07137221' => 'Rhens, Stadt',
	'DE07137222' => 'Sankt Sebastian',
	'DE07137223' => 'Spay',
	'DE07137224' => 'Urbar',
	'DE07137225' => 'Urmitz',
	'DE07137226' => 'Vallendar, Stadt',
	'DE07137227' => 'Waldesch',
	'DE07137228' => 'Weißenthurm, Stadt',
	'DE07137229' => 'Weitersburg',
	'DE07137230' => 'Winningen',
	'DE07137231' => 'Wolken',
	'DE07137501' => 'Münstermaifeld, Stadt',
	'DE07137504' => 'Lehmen',
	'DE07138002' => 'Anhausen',
	'DE07138003' => 'Asbach',
	'DE07138004' => 'Bad Hönningen, Stadt',
	'DE07138005' => 'Bonefeld',
	'DE07138006' => 'Breitscheid',
	'DE07138007' => 'Hausen (Wied)',
	'DE07138008' => 'Bruchhausen',
	'DE07138009' => 'Dattenberg',
	'DE07138010' => 'Datzeroth',
	'DE07138011' => 'Dernbach',
	'DE07138012' => 'Dierdorf, Stadt',
	'DE07138013' => 'Döttesfeld',
	'DE07138014' => 'Dürrholz',
	'DE07138015' => 'Ehlscheid',
	'DE07138019' => 'Erpel',
	'DE07138023' => 'Großmaischeid',
	'DE07138024' => 'Hammerstein',
	'DE07138025' => 'Hanroth',
	'DE07138026' => 'Hardert',
	'DE07138027' => 'Harschbach',
	'DE07138030' => 'Hümmerich',
	'DE07138031' => 'Isenburg',
	'DE07138034' => 'Kleinmaischeid',
	'DE07138036' => 'Kurtscheid',
	'DE07138037' => 'Leubsdorf',
	'DE07138038' => 'Leutesdorf',
	'DE07138040' => 'Linkenbach',
	'DE07138041' => 'Linz am Rhein, Stadt',
	'DE07138042' => 'Meinborn',
	'DE07138043' => 'Melsbach',
	'DE07138044' => 'Neustadt (Wied)',
	'DE07138045' => 'Neuwied, Stadt',
	'DE07138047' => 'Niederbreitbach',
	'DE07138048' => 'Niederhofen',
	'DE07138050' => 'Niederwambach',
	'DE07138052' => 'Oberdreis',
	'DE07138053' => 'Oberhonnefeld-Gierend',
	'DE07138054' => 'Oberraden',
	'DE07138055' => 'Ockenfels',
	'DE07138057' => 'Puderbach',
	'DE07138058' => 'Ratzert',
	'DE07138059' => 'Raubach',
	'DE07138061' => 'Rengsdorf',
	'DE07138062' => 'Rheinbreitbach',
	'DE07138063' => 'Rheinbrohl',
	'DE07138064' => 'Rodenbach bei Puderbach',
	'DE07138065' => 'Roßbach',
	'DE07138066' => 'Rüscheid',
	'DE07138068' => 'Sankt Katharinen (Landkreis Neuwied)',
	'DE07138069' => 'Stebach',
	'DE07138070' => 'Steimel',
	'DE07138071' => 'Straßenhaus',
	'DE07138072' => 'Thalhausen',
	'DE07138073' => 'Unkel, Stadt',
	'DE07138074' => 'Urbach',
	'DE07138075' => 'Vettelschoß',
	'DE07138076' => 'Waldbreitbach',
	'DE07138077' => 'Windhagen',
	'DE07138078' => 'Woldert',
	'DE07138080' => 'Buchholz (Westerwald)',
	'DE07138201' => 'Marienhausen',
	'DE07138501' => 'Kasbach-Ohlenberg',
	'DE07140001' => 'Alterkülz',
	'DE07140002' => 'Altweidelbach',
	'DE07140003' => 'Argenthal',
	'DE07140005' => 'Badenhard',
	'DE07140006' => 'Bärenbach',
	'DE07140007' => 'Belg',
	'DE07140008' => 'Belgweiler',
	'DE07140009' => 'Bell (Hunsrück)',
	'DE07140010' => 'Beltheim',
	'DE07140011' => 'Benzweiler',
	'DE07140012' => 'Bergenhausen',
	'DE07140014' => 'Bickenbach',
	'DE07140015' => 'Biebern',
	'DE07140016' => 'Birkheim',
	'DE07140018' => 'Braunshorn',
	'DE07140020' => 'Bubach',
	'DE07140021' => 'Buch',
	'DE07140023' => 'Budenbach',
	'DE07140024' => 'Büchenbeuren',
	'DE07140025' => 'Damscheid',
	'DE07140027' => 'Dichtelbach',
	'DE07140028' => 'Dickenschied',
	'DE07140029' => 'Dill',
	'DE07140030' => 'Dillendorf',
	'DE07140031' => 'Dörth',
	'DE07140035' => 'Ellern (Hunsrück)',
	'DE07140036' => 'Emmelshausen, Stadt',
	'DE07140037' => 'Erbach',
	'DE07140039' => 'Fronhofen',
	'DE07140040' => 'Gehlweiler',
	'DE07140041' => 'Gemünden',
	'DE07140042' => 'Gödenroth',
	'DE07140043' => 'Gondershausen',
	'DE07140044' => 'Hahn',
	'DE07140045' => 'Halsenbach',
	'DE07140046' => 'Hasselbach',
	'DE07140047' => 'Hausbay',
	'DE07140048' => 'Hecken',
	'DE07140049' => 'Heinzenbach',
	'DE07140050' => 'Henau',
	'DE07140053' => 'Hirschfeld (Hunsrück)',
	'DE07140055' => 'Hollnich',
	'DE07140056' => 'Holzbach',
	'DE07140058' => 'Horn',
	'DE07140060' => 'Hungenroth',
	'DE07140062' => 'Kappel',
	'DE07140063' => 'Karbach',
	'DE07140064' => 'Kastellaun, Stadt',
	'DE07140065' => 'Keidelheim',
	'DE07140067' => 'Kirchberg (Hunsrück), Stadt',
	'DE07140068' => 'Kisselbach',
	'DE07140070' => 'Klosterkumbd',
	'DE07140071' => 'Kludenbach',
	'DE07140073' => 'Korweiler',
	'DE07140075' => 'Kratzenburg',
	'DE07140076' => 'Külz (Hunsrück)',
	'DE07140077' => 'Kümbdchen',
	'DE07140079' => 'Laubach',
	'DE07140080' => 'Laudert',
	'DE07140081' => 'Laufersweiler',
	'DE07140082' => 'Lautzenhausen',
	'DE07140084' => 'Leiningen',
	'DE07140085' => 'Liebshausen',
	'DE07140086' => 'Lindenschied',
	'DE07140087' => 'Lingerhahn',
	'DE07140089' => 'Maisborn',
	'DE07140090' => 'Maitzborn',
	'DE07140092' => 'Mengerschied',
	'DE07140093' => 'Mermuth',
	'DE07140094' => 'Metzenhausen',
	'DE07140095' => 'Michelbach',
	'DE07140096' => 'Mörschbach',
	'DE07140098' => 'Mühlpfad',
	'DE07140099' => 'Mutterschied',
	'DE07140100' => 'Nannhausen',
	'DE07140101' => 'Neuerkirch',
	'DE07140102' => 'Ney',
	'DE07140104' => 'Niederburg',
	'DE07140105' => 'Nieder Kostenz',
	'DE07140106' => 'Niederkumbd',
	'DE07140107' => 'Niedersohren',
	'DE07140108' => 'Niedert',
	'DE07140109' => 'Niederweiler',
	'DE07140110' => 'Norath',
	'DE07140111' => 'Ober Kostenz',
	'DE07140112' => 'Oberwesel, Stadt',
	'DE07140113' => 'Ohlweiler',
	'DE07140115' => 'Oppertshausen',
	'DE07140116' => 'Perscheid',
	'DE07140117' => 'Pfalzfeld',
	'DE07140118' => 'Pleizenhausen',
	'DE07140119' => 'Ravengiersburg',
	'DE07140120' => 'Raversbeuren',
	'DE07140121' => 'Rayerschied',
	'DE07140122' => 'Reckershausen',
	'DE07140123' => 'Reich',
	'DE07140125' => 'Rheinböllen, Stadt',
	'DE07140126' => 'Riegenroth',
	'DE07140127' => 'Riesweiler',
	'DE07140128' => 'Rödelhausen',
	'DE07140129' => 'Rödern',
	'DE07140130' => 'Rohrbach',
	'DE07140131' => 'Roth',
	'DE07140133' => 'Sankt Goar, Stadt',
	'DE07140134' => 'Sargenroth',
	'DE07140135' => 'Schlierschied',
	'DE07140138' => 'Schnorbach',
	'DE07140139' => 'Schönborn',
	'DE07140140' => 'Schwall',
	'DE07140141' => 'Schwarzen',
	'DE07140144' => 'Simmern/ Hunsrück, Stadt',
	'DE07140145' => 'Sohren',
	'DE07140146' => 'Sohrschied',
	'DE07140147' => 'Spesenroth',
	'DE07140148' => 'Steinbach',
	'DE07140149' => 'Thörlingen',
	'DE07140150' => 'Tiefenbach',
	'DE07140151' => 'Todenroth',
	'DE07140153' => 'Uhler',
	'DE07140154' => 'Unzenberg',
	'DE07140155' => 'Urbar',
	'DE07140156' => 'Utzenhain',
	'DE07140158' => 'Wahlbach',
	'DE07140159' => 'Wahlenau',
	'DE07140161' => 'Wiebelsheim',
	'DE07140163' => 'Womrath',
	'DE07140164' => 'Woppenroth',
	'DE07140165' => 'Würrich',
	'DE07140166' => 'Wüschheim',
	'DE07140201' => 'Beulich',
	'DE07140202' => 'Dommershausen',
	'DE07140204' => 'Mastershausen',
	'DE07140205' => 'Morshausen',
	'DE07140501' => 'Boppard, Stadt',
	'DE07140502' => 'Lahr',
	'DE07140503' => 'Mörsdorf',
	'DE07140504' => 'Zilshausen',
	'DE07141001' => 'Allendorf',
	'DE07141002' => 'Altendiez',
	'DE07141003' => 'Attenhausen',
	'DE07141004' => 'Auel',
	'DE07141005' => 'Aull',
	'DE07141006' => 'Bad Ems, Stadt',
	'DE07141008' => 'Becheln',
	'DE07141009' => 'Berg',
	'DE07141010' => 'Berghausen',
	'DE07141011' => 'Berndroth',
	'DE07141012' => 'Bettendorf',
	'DE07141013' => 'Biebrich',
	'DE07141014' => 'Birlenbach',
	'DE07141015' => 'Bogel',
	'DE07141016' => 'Bornich',
	'DE07141018' => 'Bremberg',
	'DE07141019' => 'Buch',
	'DE07141020' => 'Burgschwalbach',
	'DE07141021' => 'Charlottenberg',
	'DE07141022' => 'Cramberg',
	'DE07141023' => 'Dachsenhausen',
	'DE07141024' => 'Dahlheim',
	'DE07141025' => 'Dausenau',
	'DE07141026' => 'Dessighofen',
	'DE07141027' => 'Dienethal',
	'DE07141029' => 'Diez, Stadt',
	'DE07141030' => 'Dörnberg',
	'DE07141031' => 'Dörscheid',
	'DE07141032' => 'Dörsdorf',
	'DE07141033' => 'Dornholzhausen',
	'DE07141034' => 'Ebertshausen',
	'DE07141035' => 'Ehr',
	'DE07141036' => 'Eisighofen',
	'DE07141037' => 'Endlichhofen',
	'DE07141038' => 'Eppenrod',
	'DE07141039' => 'Ergeshausen',
	'DE07141040' => 'Eschbach',
	'DE07141041' => 'Fachbach',
	'DE07141042' => 'Filsen',
	'DE07141043' => 'Flacht',
	'DE07141044' => 'Frücht',
	'DE07141045' => 'Geilnau',
	'DE07141046' => 'Geisig',
	'DE07141047' => 'Gemmerich',
	'DE07141049' => 'Gückingen',
	'DE07141050' => 'Gutenacker',
	'DE07141051' => 'Hahnstätten',
	'DE07141052' => 'Hambach',
	'DE07141053' => 'Heistenbach',
	'DE07141054' => 'Herold',
	'DE07141055' => 'Himmighofen',
	'DE07141057' => 'Hirschberg',
	'DE07141058' => 'Hömberg',
	'DE07141059' => 'Holzappel',
	'DE07141060' => 'Holzhausen an der Haide',
	'DE07141061' => 'Holzheim',
	'DE07141062' => 'Horhausen',
	'DE07141063' => 'Hunzel',
	'DE07141064' => 'Isselbach',
	'DE07141065' => 'Kaltenholzhausen',
	'DE07141066' => 'Kamp-Bornhofen',
	'DE07141067' => 'Kasdorf',
	'DE07141068' => 'Katzenelnbogen, Stadt',
	'DE07141069' => 'Kaub, Stadt',
	'DE07141070' => 'Kehlbach',
	'DE07141071' => 'Kemmenau',
	'DE07141072' => 'Kestert',
	'DE07141073' => 'Klingelbach',
	'DE07141074' => 'Kördorf',
	'DE07141075' => 'Lahnstein, Stadt',
	'DE07141076' => 'Langenscheid',
	'DE07141077' => 'Laurenburg',
	'DE07141078' => 'Lautert',
	'DE07141079' => 'Lierschied',
	'DE07141080' => 'Lipporn',
	'DE07141081' => 'Lohrheim',
	'DE07141082' => 'Lollschied',
	'DE07141083' => 'Lykershausen',
	'DE07141084' => 'Marienfels',
	'DE07141085' => 'Miehlen',
	'DE07141086' => 'Miellen',
	'DE07141087' => 'Misselberg',
	'DE07141088' => 'Mittelfischbach',
	'DE07141089' => 'Mudershausen',
	'DE07141091' => 'Nassau, Stadt',
	'DE07141092' => 'Nastätten, Stadt',
	'DE07141093' => 'Netzbach',
	'DE07141094' => 'Niederbachheim',
	'DE07141095' => 'Niederneisen',
	'DE07141096' => 'Niedertiefenbach',
	'DE07141097' => 'Niederwallmenach',
	'DE07141098' => 'Nievern',
	'DE07141099' => 'Nochern',
	'DE07141100' => 'Oberbachheim',
	'DE07141101' => 'Oberfischbach',
	'DE07141102' => 'Oberneisen',
	'DE07141103' => 'Obernhof',
	'DE07141104' => 'Obertiefenbach',
	'DE07141105' => 'Oberwallmenach',
	'DE07141106' => 'Oberwies',
	'DE07141107' => 'Oelsberg',
	'DE07141108' => 'Osterspai',
	'DE07141109' => 'Patersberg',
	'DE07141110' => 'Hainau',
	'DE07141111' => 'Pohl',
	'DE07141112' => 'Prath',
	'DE07141113' => 'Reckenroth',
	'DE07141114' => 'Reichenberg',
	'DE07141115' => 'Reitzenhain',
	'DE07141116' => 'Rettershain',
	'DE07141117' => 'Rettert',
	'DE07141118' => 'Roth',
	'DE07141120' => 'Ruppertshofen',
	'DE07141121' => 'Sankt Goarshausen, Loreleystadt, Stadt',
	'DE07141122' => 'Sauerthal',
	'DE07141124' => 'Scheidt',
	'DE07141125' => 'Schiesheim',
	'DE07141126' => 'Schönborn',
	'DE07141127' => 'Schweighausen',
	'DE07141128' => 'Seelbach',
	'DE07141129' => 'Singhofen',
	'DE07141130' => 'Steinsberg',
	'DE07141131' => 'Strüth',
	'DE07141132' => 'Sulzbach',
	'DE07141133' => 'Wasenbach',
	'DE07141134' => 'Weidenbach',
	'DE07141135' => 'Weinähr',
	'DE07141136' => 'Weisel',
	'DE07141137' => 'Welterod',
	'DE07141138' => 'Weyer',
	'DE07141139' => 'Winden',
	'DE07141140' => 'Winterwerb',
	'DE07141141' => 'Zimmerschied',
	'DE07141201' => 'Arzbach',
	'DE07141501' => 'Braubach, Stadt',
	'DE07141502' => 'Diethardt',
	'DE07141503' => 'Balduinstein',
	'DE07143001' => 'Alsbach',
	'DE07143003' => 'Bannberscheid',
	'DE07143005' => 'Boden',
	'DE07143006' => 'Breitenau',
	'DE07143007' => 'Caan',
	'DE07143008' => 'Daubach',
	'DE07143009' => 'Deesen',
	'DE07143010' => 'Dernbach (Westerwald)',
	'DE07143011' => 'Dreikirchen',
	'DE07143012' => 'Ebernhahn',
	'DE07143013' => 'Eitelborn',
	'DE07143015' => 'Ellenhausen',
	'DE07143018' => 'Freilingen',
	'DE07143019' => 'Freirachdorf',
	'DE07143020' => 'Gackenbach',
	'DE07143021' => 'Girod',
	'DE07143022' => 'Goddert',
	'DE07143023' => 'Görgeshausen',
	'DE07143024' => 'Großholbach',
	'DE07143025' => 'Hartenfels',
	'DE07143026' => 'Heilberscheid',
	'DE07143027' => 'Heiligenroth',
	'DE07143028' => 'Helferskirchen',
	'DE07143029' => 'Herschbach',
	'DE07143030' => 'Hilgert',
	'DE07143031' => 'Hillscheid',
	'DE07143032' => 'Höhr-Grenzhausen, Stadt',
	'DE07143033' => 'Holler',
	'DE07143034' => 'Horbach',
	'DE07143036' => 'Hübingen',
	'DE07143037' => 'Hundsangen',
	'DE07143038' => 'Hundsdorf',
	'DE07143039' => 'Kadenbach',
	'DE07143040' => 'Kammerforst',
	'DE07143041' => 'Krümmel',
	'DE07143042' => 'Leuterod',
	'DE07143044' => 'Marienrachdorf',
	'DE07143045' => 'Maroth',
	'DE07143046' => 'Maxsain',
	'DE07143047' => 'Mogendorf',
	'DE07143048' => 'Montabaur, Stadt',
	'DE07143049' => 'Moschheim',
	'DE07143050' => 'Nauort',
	'DE07143051' => 'Nentershausen',
	'DE07143052' => 'Neuhäusel',
	'DE07143053' => 'Niederelbert',
	'DE07143054' => 'Niedererbach',
	'DE07143055' => 'Nomborn',
	'DE07143056' => 'Nordhofen',
	'DE07143057' => 'Oberelbert',
	'DE07143058' => 'Obererbach',
	'DE07143059' => 'Oberhaid',
	'DE07143060' => 'Ötzingen',
	'DE07143061' => 'Quirnbach',
	'DE07143062' => 'Ransbach-Baumbach, Stadt',
	'DE07143064' => 'Rückeroth',
	'DE07143065' => 'Ruppach-Goldhausen',
	'DE07143066' => 'Schenkelberg',
	'DE07143067' => 'Selters (Westerwald), Stadt',
	'DE07143068' => 'Sessenbach',
	'DE07143069' => 'Sessenhausen',
	'DE07143070' => 'Siershahn',
	'DE07143071' => 'Simmern',
	'DE07143072' => 'Stahlhofen',
	'DE07143073' => 'Staudt',
	'DE07143074' => 'Steinefrenz',
	'DE07143075' => 'Steinen',
	'DE07143077' => 'Untershausen',
	'DE07143078' => 'Vielbach',
	'DE07143079' => 'Welschneudorf',
	'DE07143080' => 'Weroth',
	'DE07143081' => 'Wirges, Stadt',
	'DE07143082' => 'Wirscheid',
	'DE07143084' => 'Wittgert',
	'DE07143085' => 'Wölferlingen',
	'DE07143200' => 'Ailertchen',
	'DE07143202' => 'Alpenrod',
	'DE07143203' => 'Arnshöfen',
	'DE07143204' => 'Astert',
	'DE07143205' => 'Atzelgift',
	'DE07143206' => 'Bad Marienberg (Westerwald), Stadt',
	'DE07143207' => 'Bellingen',
	'DE07143208' => 'Berod bei Wallmerod',
	'DE07143209' => 'Berzhahn',
	'DE07143210' => 'Bilkheim',
	'DE07143211' => 'Bölsberg',
	'DE07143212' => 'Borod',
	'DE07143213' => 'Brandscheid',
	'DE07143214' => 'Bretthausen',
	'DE07143215' => 'Dreifelden',
	'DE07143216' => 'Dreisbach',
	'DE07143218' => 'Elsoff (Westerwald)',
	'DE07143219' => 'Enspel',
	'DE07143220' => 'Ettinghausen',
	'DE07143221' => 'Ewighausen',
	'DE07143222' => 'Fehl-Ritzhausen',
	'DE07143223' => 'Gehlert',
	'DE07143224' => 'Gemünden',
	'DE07143225' => 'Giesenhausen',
	'DE07143226' => 'Girkenroth',
	'DE07143227' => 'Großseifen',
	'DE07143228' => 'Guckheim',
	'DE07143229' => 'Hachenburg, Stadt',
	'DE07143230' => 'Härtlingen',
	'DE07143231' => 'Hahn bei Marienberg',
	'DE07143232' => 'Hahn am See',
	'DE07143233' => 'Halbs',
	'DE07143234' => 'Hardt',
	'DE07143235' => 'Hattert',
	'DE07143236' => 'Heimborn',
	'DE07143237' => 'Hellenhahn-Schellenberg',
	'DE07143238' => 'Hergenroth',
	'DE07143239' => 'Herschbach (Oberwesterwald)',
	'DE07143240' => 'Heuzert',
	'DE07143241' => 'Höchstenbach',
	'DE07143242' => 'Höhn',
	'DE07143243' => 'Hof',
	'DE07143244' => 'Homberg',
	'DE07143245' => 'Hüblingen',
	'DE07143246' => 'Irmtraut',
	'DE07143247' => 'Kaden',
	'DE07143248' => 'Kirburg',
	'DE07143249' => 'Kölbingen',
	'DE07143250' => 'Kroppach',
	'DE07143251' => 'Kuhnhöfen',
	'DE07143252' => 'Kundert',
	'DE07143253' => 'Langenbach bei Kirburg',
	'DE07143254' => 'Langenhahn',
	'DE07143255' => 'Lautzenbrücken',
	'DE07143256' => 'Liebenscheid',
	'DE07143257' => 'Limbach',
	'DE07143258' => 'Linden',
	'DE07143259' => 'Lochum',
	'DE07143260' => 'Luckenbach',
	'DE07143261' => 'Marzhausen',
	'DE07143262' => 'Merkelbach',
	'DE07143263' => 'Meudt',
	'DE07143264' => 'Mörlen',
	'DE07143265' => 'Mörsbach',
	'DE07143266' => 'Molsberg',
	'DE07143267' => 'Mudenbach',
	'DE07143268' => 'Mündersbach',
	'DE07143269' => 'Müschenbach',
	'DE07143270' => 'Neunkhausen',
	'DE07143271' => 'Neunkirchen',
	'DE07143272' => 'Neustadt/ Westerwald',
	'DE07143273' => 'Niederahr',
	'DE07143274' => 'Niederroßbach',
	'DE07143275' => 'Niedersayn',
	'DE07143276' => 'Nister',
	'DE07143277' => 'Nisterau',
	'DE07143278' => 'Nister-Möhrendorf',
	'DE07143279' => 'Nistertal',
	'DE07143280' => 'Norken',
	'DE07143281' => 'Oberahr',
	'DE07143282' => 'Oberrod',
	'DE07143283' => 'Oberroßbach',
	'DE07143284' => 'Pottum',
	'DE07143285' => 'Rehe',
	'DE07143286' => 'Rennerod, Stadt',
	'DE07143287' => 'Roßbach',
	'DE07143288' => 'Rotenhain',
	'DE07143289' => 'Rothenbach',
	'DE07143290' => 'Salz',
	'DE07143291' => 'Salzburg',
	'DE07143292' => 'Seck',
	'DE07143293' => 'Stahlhofen am Wiesensee',
	'DE07143294' => 'Steinebach an der Wied',
	'DE07143295' => 'Stein-Neukirch',
	'DE07143296' => 'Stein-Wingert',
	'DE07143297' => 'Stockhausen-Illfurth',
	'DE07143298' => 'Stockum-Püschen',
	'DE07143299' => 'Streithausen',
	'DE07143300' => 'Unnau',
	'DE07143301' => 'Wahlrod',
	'DE07143302' => 'Waigandshain',
	'DE07143303' => 'Waldmühlen',
	'DE07143304' => 'Wallmerod',
	'DE07143305' => 'Weidenhahn',
	'DE07143306' => 'Welkenbach',
	'DE07143307' => 'Weltersburg',
	'DE07143308' => 'Westerburg, Stadt',
	'DE07143309' => 'Westernohe',
	'DE07143310' => 'Wied',
	'DE07143311' => 'Willingen',
	'DE07143312' => 'Willmenrod',
	'DE07143313' => 'Winkelbach',
	'DE07143314' => 'Winnen',
	'DE07143315' => 'Zehnhausen bei Rennerod',
	'DE07143316' => 'Zehnhausen bei Wallmerod',
	'DE07143501' => 'Elbingen',
	'DE07143502' => 'Mähren',
	'DE07211000' => 'Trier, Stadt',
	'DE07231001' => 'Altrich',
	'DE07231003' => 'Arenrath',
	'DE07231004' => 'Bausendorf',
	'DE07231005' => 'Bengel',
	'DE07231006' => 'Berglicht',
	'DE07231007' => 'Bergweiler',
	'DE07231008' => 'Bernkastel-Kues, Stadt',
	'DE07231009' => 'Bettenfeld',
	'DE07231010' => 'Binsfeld',
	'DE07231012' => 'Brauneberg',
	'DE07231013' => 'Bruch',
	'DE07231014' => 'Burg (Mosel)',
	'DE07231016' => 'Burgen',
	'DE07231017' => 'Burtscheid',
	'DE07231018' => 'Deuselbach',
	'DE07231019' => 'Dhronecken',
	'DE07231020' => 'Diefenbach',
	'DE07231021' => 'Dierfeld',
	'DE07231022' => 'Dierscheid',
	'DE07231023' => 'Dodenburg',
	'DE07231024' => 'Dreis',
	'DE07231025' => 'Eckfeld',
	'DE07231026' => 'Eisenschmitt',
	'DE07231029' => 'Enkirch',
	'DE07231030' => 'Erden',
	'DE07231031' => 'Esch',
	'DE07231032' => 'Etgert',
	'DE07231033' => 'Flußbach',
	'DE07231035' => 'Gielert',
	'DE07231036' => 'Gipperath',
	'DE07231037' => 'Gladbach',
	'DE07231040' => 'Gornhausen',
	'DE07231041' => 'Graach an der Mosel',
	'DE07231042' => 'Gräfendhron',
	'DE07231044' => 'Greimerath',
	'DE07231046' => 'Großlittgen',
	'DE07231049' => 'Hasborn',
	'DE07231050' => 'Heckenmünster',
	'DE07231051' => 'Heidweiler',
	'DE07231053' => 'Hetzerath',
	'DE07231054' => 'Hilscheid',
	'DE07231056' => 'Hochscheid',
	'DE07231057' => 'Hontheim',
	'DE07231058' => 'Horath',
	'DE07231062' => 'Hupperath',
	'DE07231064' => 'Immert',
	'DE07231065' => 'Karl',
	'DE07231066' => 'Kesten',
	'DE07231067' => 'Kinderbeuern',
	'DE07231068' => 'Kinheim',
	'DE07231069' => 'Klausen',
	'DE07231070' => 'Kleinich',
	'DE07231071' => 'Kommen',
	'DE07231072' => 'Kröv',
	'DE07231074' => 'Laufeld',
	'DE07231075' => 'Lieser',
	'DE07231076' => 'Lösnich',
	'DE07231077' => 'Longkamp',
	'DE07231078' => 'Lückenburg',
	'DE07231079' => 'Malborn',
	'DE07231080' => 'Manderscheid, Stadt',
	'DE07231081' => 'Maring-Noviand',
	'DE07231082' => 'Meerfeld',
	'DE07231083' => 'Merschbach',
	'DE07231085' => 'Minderlittgen',
	'DE07231086' => 'Minheim',
	'DE07231087' => 'Monzelfeld',
	'DE07231090' => 'Mülheim an der Mosel',
	'DE07231091' => 'Musweiler',
	'DE07231092' => 'Neumagen-Dhron',
	'DE07231093' => 'Neunkirchen',
	'DE07231095' => 'Niederöfflingen',
	'DE07231096' => 'Niederscheidweiler',
	'DE07231100' => 'Oberöfflingen',
	'DE07231101' => 'Oberscheidweiler',
	'DE07231103' => 'Osann-Monzel',
	'DE07231104' => 'Pantenburg',
	'DE07231105' => 'Piesport',
	'DE07231107' => 'Platten',
	'DE07231108' => 'Plein',
	'DE07231110' => 'Reil',
	'DE07231111' => 'Rivenich',
	'DE07231112' => 'Rorodt',
	'DE07231113' => 'Salmtal',
	'DE07231114' => 'Schladt',
	'DE07231115' => 'Schönberg',
	'DE07231116' => 'Schwarzenborn',
	'DE07231117' => 'Sehlem',
	'DE07231120' => 'Starkenburg',
	'DE07231122' => 'Talling',
	'DE07231123' => 'Thalfang',
	'DE07231124' => 'Traben-Trarbach, Stadt',
	'DE07231125' => 'Ürzig',
	'DE07231126' => 'Veldenz',
	'DE07231127' => 'Wallscheid',
	'DE07231132' => 'Willwerscheid',
	'DE07231133' => 'Wintrich',
	'DE07231134' => 'Wittlich, Stadt',
	'DE07231136' => 'Zeltingen-Rachtig',
	'DE07231202' => 'Breit',
	'DE07231203' => 'Büdlich',
	'DE07231204' => 'Heidenburg',
	'DE07231206' => 'Lötzbeuren',
	'DE07231501' => 'Irmenach',
	'DE07231502' => 'Morbach',
	'DE07231503' => 'Landscheid',
	'DE07231504' => 'Niersbach',
	'DE07232001' => 'Affler',
	'DE07232002' => 'Alsdorf',
	'DE07232003' => 'Altscheid',
	'DE07232004' => 'Ammeldingen an der Our',
	'DE07232005' => 'Ammeldingen bei Neuerburg',
	'DE07232006' => 'Auw an der Kyll',
	'DE07232007' => 'Badem',
	'DE07232008' => 'Bauler',
	'DE07232009' => 'Baustert',
	'DE07232010' => 'Beilingen',
	'DE07232011' => 'Berkoth',
	'DE07232012' => 'Berscheid',
	'DE07232013' => 'Bettingen',
	'DE07232014' => 'Bickendorf',
	'DE07232015' => 'Biersdorf am See',
	'DE07232016' => 'Biesdorf',
	'DE07232017' => 'Birtlingen',
	'DE07232018' => 'Bitburg, Stadt',
	'DE07232019' => 'Bollendorf',
	'DE07232020' => 'Brecht',
	'DE07232022' => 'Burg',
	'DE07232024' => 'Dahlem',
	'DE07232025' => 'Dauwelshausen',
	'DE07232026' => 'Dockendorf',
	'DE07232027' => 'Dudeldorf',
	'DE07232028' => 'Echternacherbrück',
	'DE07232029' => 'Echtershausen',
	'DE07232030' => 'Ehlenz',
	'DE07232031' => 'Emmelbaum',
	'DE07232032' => 'Enzen',
	'DE07232033' => 'Ernzen',
	'DE07232034' => 'Eßlingen',
	'DE07232035' => 'Etteldorf',
	'DE07232036' => 'Feilsdorf',
	'DE07232037' => 'Ferschweiler',
	'DE07232038' => 'Fischbach-Oberraden',
	'DE07232039' => 'Fließem',
	'DE07232040' => 'Geichlingen',
	'DE07232041' => 'Gemünd',
	'DE07232042' => 'Gentingen',
	'DE07232043' => 'Gindorf',
	'DE07232044' => 'Gondorf',
	'DE07232045' => 'Halsdorf',
	'DE07232046' => 'Hamm',
	'DE07232047' => 'Heilbach',
	'DE07232048' => 'Heilenbach',
	'DE07232049' => 'Herbstmühle',
	'DE07232050' => 'Herforst',
	'DE07232053' => 'Holsthum',
	'DE07232054' => 'Hommerdingen',
	'DE07232055' => 'Hosten',
	'DE07232056' => 'Hütten',
	'DE07232057' => 'Hütterscheid',
	'DE07232058' => 'Hüttingen an der Kyll',
	'DE07232059' => 'Hüttingen bei Lahr',
	'DE07232060' => 'Idenheim',
	'DE07232061' => 'Idesheim',
	'DE07232062' => 'Ingendorf',
	'DE07232063' => 'Irrel',
	'DE07232064' => 'Karlshausen',
	'DE07232065' => 'Kaschenbach',
	'DE07232066' => 'Keppeshausen',
	'DE07232067' => 'Körperich',
	'DE07232068' => 'Koxhausen',
	'DE07232069' => 'Kruchten',
	'DE07232070' => 'Kyllburg, Stadt',
	'DE07232071' => 'Kyllburgweiler',
	'DE07232072' => 'Lahr',
	'DE07232073' => 'Leimbach',
	'DE07232074' => 'Ließem',
	'DE07232075' => 'Malberg',
	'DE07232076' => 'Malbergweich',
	'DE07232077' => 'Meckel',
	'DE07232078' => 'Menningen',
	'DE07232079' => 'Messerich',
	'DE07232080' => 'Mettendorf',
	'DE07232081' => 'Metterich',
	'DE07232082' => 'Minden',
	'DE07232083' => 'Mülbach',
	'DE07232084' => 'Muxerath',
	'DE07232085' => 'Nasingen',
	'DE07232086' => 'Nattenheim',
	'DE07232087' => 'Neidenbach',
	'DE07232088' => 'Neuerburg, Stadt',
	'DE07232089' => 'Niedergeckler',
	'DE07232090' => 'Niederraden',
	'DE07232091' => 'Niederstedem',
	'DE07232092' => 'Niederweiler',
	'DE07232093' => 'Niederweis',
	'DE07232094' => 'Niehl',
	'DE07232095' => 'Nusbaum',
	'DE07232096' => 'Obergeckler',
	'DE07232097' => 'Oberstedem',
	'DE07232098' => 'Oberweiler',
	'DE07232099' => 'Oberweis',
	'DE07232100' => 'Olsdorf',
	'DE07232101' => 'Orsfeld',
	'DE07232102' => 'Utscheid',
	'DE07232103' => 'Peffingen',
	'DE07232104' => 'Philippsheim',
	'DE07232105' => 'Pickließem',
	'DE07232106' => 'Plascheid',
	'DE07232107' => 'Preist',
	'DE07232108' => 'Prümzurlay',
	'DE07232109' => 'Rittersdorf',
	'DE07232110' => 'Rodershausen',
	'DE07232111' => 'Röhl',
	'DE07232112' => 'Roth an der Our',
	'DE07232113' => 'Sankt Thomas',
	'DE07232114' => 'Schankweiler',
	'DE07232115' => 'Scharfbillig',
	'DE07232116' => 'Scheitenkorb',
	'DE07232117' => 'Scheuern',
	'DE07232118' => 'Schleid',
	'DE07232119' => 'Seffern',
	'DE07232120' => 'Sefferweich',
	'DE07232121' => 'Sevenig bei Neuerburg',
	'DE07232122' => 'Sinspelt',
	'DE07232123' => 'Speicher, Stadt',
	'DE07232124' => 'Stockem',
	'DE07232125' => 'Sülm',
	'DE07232126' => 'Trimport',
	'DE07232127' => 'Übereisenbach',
	'DE07232128' => 'Uppershausen',
	'DE07232129' => 'Usch',
	'DE07232130' => 'Waldhof-Falkenstein',
	'DE07232131' => 'Wallendorf',
	'DE07232132' => 'Weidingen',
	'DE07232133' => 'Wettlingen',
	'DE07232134' => 'Wiersdorf',
	'DE07232135' => 'Wilsecker',
	'DE07232137' => 'Wolsfeld',
	'DE07232138' => 'Zweifelscheid',
	'DE07232201' => 'Arzfeld',
	'DE07232202' => 'Auw bei Prüm',
	'DE07232203' => 'Balesfeld',
	'DE07232206' => 'Bleialf',
	'DE07232207' => 'Brandscheid',
	'DE07232208' => 'Buchet',
	'DE07232209' => 'Büdesheim',
	'DE07232210' => 'Burbach',
	'DE07232211' => 'Dackscheid',
	'DE07232212' => 'Dahnen',
	'DE07232213' => 'Daleiden',
	'DE07232214' => 'Dasburg',
	'DE07232216' => 'Dingdorf',
	'DE07232217' => 'Eilscheid',
	'DE07232218' => 'Eisenach',
	'DE07232220' => 'Eschfeld',
	'DE07232221' => 'Euscheid',
	'DE07232222' => 'Feuerscheid',
	'DE07232223' => 'Fleringen',
	'DE07232224' => 'Giesdorf',
	'DE07232225' => 'Gilzem',
	'DE07232226' => 'Weinsheim',
	'DE07232227' => 'Gondenbrett',
	'DE07232228' => 'Gransdorf',
	'DE07232229' => 'Großkampenberg',
	'DE07232230' => 'Großlangenfeld',
	'DE07232231' => 'Habscheid',
	'DE07232233' => 'Hargarten',
	'DE07232234' => 'Harspelt',
	'DE07232236' => 'Heckhuscheid',
	'DE07232238' => 'Heisdorf',
	'DE07232240' => 'Herzfeld',
	'DE07232245' => 'Irrhausen',
	'DE07232246' => 'Jucken',
	'DE07232247' => 'Kesfeld',
	'DE07232248' => 'Kickeshausen',
	'DE07232249' => 'Kinzenburg',
	'DE07232250' => 'Kleinlangenfeld',
	'DE07232253' => 'Krautscheid',
	'DE07232254' => 'Lambertsberg',
	'DE07232255' => 'Lascheid',
	'DE07232256' => 'Lasel',
	'DE07232258' => 'Lauperath',
	'DE07232259' => 'Leidenborn',
	'DE07232260' => 'Lichtenborn',
	'DE07232261' => 'Lierfeld',
	'DE07232262' => 'Lünebach',
	'DE07232263' => 'Lützkampen',
	'DE07232264' => 'Manderscheid',
	'DE07232265' => 'Masthorn',
	'DE07232266' => 'Matzerath',
	'DE07232267' => 'Mauel',
	'DE07232270' => 'Merlscheid',
	'DE07232271' => 'Mützenich',
	'DE07232272' => 'Neuendorf',
	'DE07232273' => 'Neuheilenbach',
	'DE07232276' => 'Niederlauch',
	'DE07232277' => 'Niederpierscheid',
	'DE07232279' => 'Nimshuscheid',
	'DE07232280' => 'Nimsreuland',
	'DE07232282' => 'Oberkail',
	'DE07232283' => 'Oberlascheid',
	'DE07232284' => 'Oberlauch',
	'DE07232285' => 'Oberpierscheid',
	'DE07232287' => 'Olmscheid',
	'DE07232288' => 'Olzheim',
	'DE07232289' => 'Orenhofen',
	'DE07232290' => 'Orlenbach',
	'DE07232291' => 'Pintesfeld',
	'DE07232292' => 'Pittenbach',
	'DE07232293' => 'Plütscheid',
	'DE07232294' => 'Preischeid',
	'DE07232295' => 'Pronsfeld',
	'DE07232296' => 'Prüm, Stadt',
	'DE07232297' => 'Reiff',
	'DE07232298' => 'Reipeldingen',
	'DE07232300' => 'Rommersheim',
	'DE07232301' => 'Roscheid',
	'DE07232302' => 'Roth bei Prüm',
	'DE07232304' => 'Schönecken',
	'DE07232305' => 'Schwirzheim',
	'DE07232306' => 'Seinsfeld',
	'DE07232307' => 'Seiwerath',
	'DE07232308' => 'Sellerich',
	'DE07232309' => 'Sengerich',
	'DE07232310' => 'Sevenig (Our)',
	'DE07232311' => 'Spangdahlem',
	'DE07232313' => 'Steinborn',
	'DE07232315' => 'Strickscheid',
	'DE07232318' => 'Wallersheim',
	'DE07232320' => 'Watzerath',
	'DE07232321' => 'Wawern',
	'DE07232322' => 'Waxweiler',
	'DE07232327' => 'Winringen',
	'DE07232328' => 'Winterscheid',
	'DE07232329' => 'Winterspelt',
	'DE07232331' => 'Zendscheid',
	'DE07232332' => 'Hersdorf',
	'DE07232333' => 'Üttfeld',
	'DE07232501' => 'Wißmannsdorf',
	'DE07232502' => 'Brimingen',
	'DE07233002' => 'Basberg',
	'DE07233003' => 'Beinhausen',
	'DE07233004' => 'Berlingen',
	'DE07233005' => 'Berndorf',
	'DE07233006' => 'Betteldorf',
	'DE07233007' => 'Birgel',
	'DE07233008' => 'Bleckhausen',
	'DE07233010' => 'Boxberg',
	'DE07233011' => 'Brockscheid',
	'DE07233014' => 'Darscheid',
	'DE07233016' => 'Demerath',
	'DE07233017' => 'Deudesfeld',
	'DE07233018' => 'Dockweiler',
	'DE07233019' => 'Dohm-Lammersdorf',
	'DE07233020' => 'Dreis-Brück',
	'DE07233021' => 'Ellscheid',
	'DE07233022' => 'Esch',
	'DE07233023' => 'Feusdorf',
	'DE07233025' => 'Gefell',
	'DE07233026' => 'Gerolstein, Stadt',
	'DE07233027' => 'Gillenfeld',
	'DE07233028' => 'Gönnersdorf',
	'DE07233029' => 'Hillesheim, Stadt',
	'DE07233030' => 'Hinterweiler',
	'DE07233031' => 'Hörscheid',
	'DE07233032' => 'Hörschhausen',
	'DE07233033' => 'Hohenfels-Essingen',
	'DE07233034' => 'Immerath',
	'DE07233035' => 'Jünkerath',
	'DE07233036' => 'Kalenborn-Scheuern',
	'DE07233037' => 'Katzwinkel',
	'DE07233038' => 'Kerpen (Eifel)',
	'DE07233039' => 'Kirchweiler',
	'DE07233040' => 'Kradenbach',
	'DE07233041' => 'Lissendorf',
	'DE07233042' => 'Mehren',
	'DE07233043' => 'Meisburg',
	'DE07233046' => 'Mückeln',
	'DE07233048' => 'Neichen',
	'DE07233049' => 'Nerdlen',
	'DE07233050' => 'Neroth',
	'DE07233052' => 'Niederstadtfeld',
	'DE07233053' => 'Oberbettingen',
	'DE07233054' => 'Oberehe-Stroheich',
	'DE07233055' => 'Oberstadtfeld',
	'DE07233056' => 'Pelm',
	'DE07233058' => 'Rockeskyll',
	'DE07233060' => 'Salm',
	'DE07233061' => 'Sarmersbach',
	'DE07233062' => 'Saxler',
	'DE07233063' => 'Schalkenmehren',
	'DE07233064' => 'Schönbach',
	'DE07233065' => 'Schutz',
	'DE07233067' => 'Steineberg',
	'DE07233068' => 'Steiningen',
	'DE07233070' => 'Strohn',
	'DE07233071' => 'Strotzbüsch',
	'DE07233074' => 'Udler',
	'DE07233075' => 'Üdersdorf',
	'DE07233076' => 'Üxheim',
	'DE07233077' => 'Utzerath',
	'DE07233079' => 'Wallenborn',
	'DE07233080' => 'Walsdorf',
	'DE07233081' => 'Weidenbach',
	'DE07233083' => 'Wiesbaum',
	'DE07233084' => 'Winkel (Eifel)',
	'DE07233201' => 'Arbach',
	'DE07233202' => 'Bereborn',
	'DE07233203' => 'Berenbach',
	'DE07233204' => 'Birresborn',
	'DE07233205' => 'Bodenbach',
	'DE07233206' => 'Bongard',
	'DE07233207' => 'Borler',
	'DE07233208' => 'Brücktal',
	'DE07233209' => 'Densborn',
	'DE07233210' => 'Drees',
	'DE07233211' => 'Duppach',
	'DE07233212' => 'Gelenberg',
	'DE07233213' => 'Gunderath',
	'DE07233214' => 'Hallschlag',
	'DE07233215' => 'Höchstberg',
	'DE07233216' => 'Horperath',
	'DE07233217' => 'Kaperich',
	'DE07233218' => 'Kelberg',
	'DE07233219' => 'Kerschenbach',
	'DE07233220' => 'Kirsbach',
	'DE07233221' => 'Kötterichen',
	'DE07233222' => 'Kolverath',
	'DE07233223' => 'Kopp',
	'DE07233224' => 'Lirstal',
	'DE07233225' => 'Mannebach',
	'DE07233226' => 'Mosbruch',
	'DE07233227' => 'Mürlenbach',
	'DE07233228' => 'Nitz',
	'DE07233229' => 'Nohn',
	'DE07233230' => 'Oberelz',
	'DE07233232' => 'Ormont',
	'DE07233233' => 'Reimerath',
	'DE07233234' => 'Retterath',
	'DE07233235' => 'Reuth',
	'DE07233236' => 'Sassen',
	'DE07233237' => 'Scheid',
	'DE07233239' => 'Schüller',
	'DE07233240' => 'Stadtkyll',
	'DE07233241' => 'Steffeln',
	'DE07233242' => 'Uersfeld',
	'DE07233243' => 'Ueß',
	'DE07233244' => 'Welcherath',
	'DE07233501' => 'Daun, Stadt',
	'DE07235001' => 'Aach',
	'DE07235002' => 'Ayl',
	'DE07235003' => 'Baldringen',
	'DE07235004' => 'Bekond',
	'DE07235005' => 'Bescheid',
	'DE07235008' => 'Beuren (Hochwald)',
	'DE07235010' => 'Bonerath',
	'DE07235014' => 'Damflos',
	'DE07235015' => 'Detzem',
	'DE07235019' => 'Ensch',
	'DE07235021' => 'Farschweiler',
	'DE07235022' => 'Fell',
	'DE07235025' => 'Fisch',
	'DE07235026' => 'Föhren',
	'DE07235027' => 'Franzenheim',
	'DE07235028' => 'Freudenburg',
	'DE07235030' => 'Geisfeld',
	'DE07235033' => 'Greimerath',
	'DE07235035' => 'Grimburg',
	'DE07235036' => 'Gusenburg',
	'DE07235037' => 'Gusterath',
	'DE07235038' => 'Gutweiler',
	'DE07235040' => 'Heddert',
	'DE07235043' => 'Hentern',
	'DE07235044' => 'Herl',
	'DE07235045' => 'Hermeskeil, Stadt',
	'DE07235046' => 'Hinzenburg',
	'DE07235047' => 'Hinzert-Pölert',
	'DE07235048' => 'Hockweiler',
	'DE07235050' => 'Holzerath',
	'DE07235051' => 'Igel',
	'DE07235052' => 'Irsch',
	'DE07235055' => 'Kanzem',
	'DE07235056' => 'Kasel',
	'DE07235057' => 'Kastel-Staadt',
	'DE07235058' => 'Kell am See',
	'DE07235060' => 'Kenn',
	'DE07235062' => 'Kirf',
	'DE07235063' => 'Klüsserath',
	'DE07235067' => 'Köwerich',
	'DE07235068' => 'Konz, Stadt',
	'DE07235069' => 'Kordel',
	'DE07235070' => 'Korlingen',
	'DE07235072' => 'Lampaden',
	'DE07235073' => 'Langsur',
	'DE07235074' => 'Leiwen',
	'DE07235077' => 'Longen',
	'DE07235078' => 'Longuich',
	'DE07235080' => 'Lorscheid',
	'DE07235081' => 'Mandern',
	'DE07235082' => 'Mannebach',
	'DE07235083' => 'Mehring',
	'DE07235085' => 'Mertesdorf',
	'DE07235090' => 'Morscheid',
	'DE07235091' => 'Naurath (Eifel)',
	'DE07235092' => 'Naurath (Wald)',
	'DE07235093' => 'Neuhütten',
	'DE07235094' => 'Newel',
	'DE07235095' => 'Nittel',
	'DE07235096' => 'Oberbillig',
	'DE07235098' => 'Ockfen',
	'DE07235100' => 'Ollmuth',
	'DE07235101' => 'Onsdorf',
	'DE07235103' => 'Osburg',
	'DE07235104' => 'Palzem',
	'DE07235105' => 'Paschel',
	'DE07235106' => 'Pellingen',
	'DE07235107' => 'Pluwig',
	'DE07235108' => 'Pölich',
	'DE07235111' => 'Ralingen',
	'DE07235112' => 'Rascheid',
	'DE07235114' => 'Reinsfeld',
	'DE07235115' => 'Riol',
	'DE07235116' => 'Riveris',
	'DE07235118' => 'Saarburg, Stadt',
	'DE07235119' => 'Schillingen',
	'DE07235120' => 'Schleich',
	'DE07235122' => 'Schoden',
	'DE07235123' => 'Schömerich',
	'DE07235124' => 'Schöndorf',
	'DE07235125' => 'Schweich, Stadt',
	'DE07235126' => 'Serrig',
	'DE07235129' => 'Sommerau',
	'DE07235131' => 'Taben-Rodt',
	'DE07235132' => 'Tawern',
	'DE07235133' => 'Temmels',
	'DE07235134' => 'Thörnich',
	'DE07235135' => 'Thomm',
	'DE07235136' => 'Trassem',
	'DE07235137' => 'Trierweiler',
	'DE07235140' => 'Vierherrenborn',
	'DE07235141' => 'Waldrach',
	'DE07235142' => 'Waldweiler',
	'DE07235143' => 'Wasserliesch',
	'DE07235144' => 'Wawern',
	'DE07235146' => 'Wellen',
	'DE07235148' => 'Wiltingen',
	'DE07235149' => 'Wincheringen',
	'DE07235151' => 'Zemmer',
	'DE07235152' => 'Zerf',
	'DE07235153' => 'Züsch',
	'DE07235154' => 'Merzkirchen',
	'DE07235207' => 'Trittenheim',
	'DE07235501' => 'Welschbillig',
	'DE07311000' => 'Frankenthal (Pfalz), Stadt',
	'DE07312000' => 'Kaiserslautern, Stadt',
	'DE07313000' => 'Landau in der Pfalz, Stadt',
	'DE07314000' => 'Ludwigshafen am Rhein, Stadt',
	'DE07315000' => 'Mainz, Stadt',
	'DE07316000' => 'Neustadt an der Weinstraße, Stadt',
	'DE07317000' => 'Pirmasens, Stadt',
	'DE07318000' => 'Speyer, Stadt',
	'DE07319000' => 'Worms, Stadt',
	'DE07320000' => 'Zweibrücken, Stadt',
	'DE07331001' => 'Albig',
	'DE07331002' => 'Alsheim',
	'DE07331003' => 'Alzey, Stadt',
	'DE07331004' => 'Armsheim',
	'DE07331005' => 'Bechenheim',
	'DE07331006' => 'Bechtheim',
	'DE07331007' => 'Bechtolsheim',
	'DE07331008' => 'Bermersheim vor der Höhe',
	'DE07331009' => 'Bermersheim',
	'DE07331010' => 'Biebelnheim',
	'DE07331011' => 'Hochborn',
	'DE07331012' => 'Bornheim',
	'DE07331014' => 'Dintesheim',
	'DE07331015' => 'Dittelsheim-Heßloch',
	'DE07331017' => 'Eckelsheim',
	'DE07331018' => 'Eich',
	'DE07331019' => 'Ensheim',
	'DE07331020' => 'Eppelsheim',
	'DE07331021' => 'Erbes-Büdesheim',
	'DE07331022' => 'Esselborn',
	'DE07331023' => 'Flörsheim-Dalsheim',
	'DE07331024' => 'Flomborn',
	'DE07331025' => 'Flonheim',
	'DE07331026' => 'Framersheim',
	'DE07331027' => 'Freimersheim',
	'DE07331028' => 'Frettenheim',
	'DE07331029' => 'Gabsheim',
	'DE07331030' => 'Gau-Bickelheim',
	'DE07331031' => 'Gau-Heppenheim',
	'DE07331032' => 'Gau-Odernheim',
	'DE07331033' => 'Gau-Weinheim',
	'DE07331034' => 'Gimbsheim',
	'DE07331035' => 'Gumbsheim',
	'DE07331036' => 'Gundersheim',
	'DE07331037' => 'Gundheim',
	'DE07331038' => 'Hamm am Rhein',
	'DE07331039' => 'Hangen-Weisheim',
	'DE07331041' => 'Hohen-Sülzen',
	'DE07331042' => 'Kettenheim',
	'DE07331043' => 'Lonsheim',
	'DE07331044' => 'Mauchenheim',
	'DE07331045' => 'Mettenheim',
	'DE07331046' => 'Mölsheim',
	'DE07331047' => 'Mörstadt',
	'DE07331048' => 'Monsheim',
	'DE07331049' => 'Monzernheim',
	'DE07331050' => 'Nack',
	'DE07331051' => 'Nieder-Wiesen',
	'DE07331052' => 'Ober-Flörsheim',
	'DE07331053' => 'Offenheim',
	'DE07331054' => 'Offstein',
	'DE07331055' => 'Osthofen, Stadt',
	'DE07331056' => 'Partenheim',
	'DE07331058' => 'Saulheim',
	'DE07331059' => 'Schornsheim',
	'DE07331060' => 'Siefersheim',
	'DE07331061' => 'Spiesheim',
	'DE07331062' => 'Stein-Bockenheim',
	'DE07331063' => 'Sulzheim',
	'DE07331064' => 'Udenheim',
	'DE07331065' => 'Vendersheim',
	'DE07331066' => 'Wachenheim',
	'DE07331067' => 'Wahlheim',
	'DE07331068' => 'Wallertheim',
	'DE07331070' => 'Wendelsheim',
	'DE07331071' => 'Westhofen',
	'DE07331072' => 'Wöllstein',
	'DE07331073' => 'Wörrstadt, Stadt',
	'DE07331075' => 'Wonsheim',
	'DE07332001' => 'Altleiningen',
	'DE07332002' => 'Bad Dürkheim, Stadt',
	'DE07332003' => 'Battenberg (Pfalz)',
	'DE07332004' => 'Bissersheim',
	'DE07332005' => 'Bobenheim am Berg',
	'DE07332006' => 'Bockenheim an der Weinstraße',
	'DE07332007' => 'Carlsberg',
	'DE07332008' => 'Dackenheim',
	'DE07332009' => 'Deidesheim, Stadt',
	'DE07332010' => 'Dirmstein',
	'DE07332012' => 'Ebertsheim',
	'DE07332013' => 'Ellerstadt',
	'DE07332014' => 'Elmstein',
	'DE07332015' => 'Erpolzheim',
	'DE07332016' => 'Esthal',
	'DE07332017' => 'Forst an der Weinstraße',
	'DE07332018' => 'Frankeneck',
	'DE07332019' => 'Freinsheim, Stadt',
	'DE07332020' => 'Friedelsheim',
	'DE07332021' => 'Gerolsheim',
	'DE07332022' => 'Gönnheim',
	'DE07332023' => 'Großkarlbach',
	'DE07332024' => 'Grünstadt, Stadt',
	'DE07332025' => 'Haßloch',
	'DE07332026' => 'Herxheim am Berg',
	'DE07332027' => 'Hettenleidelheim',
	'DE07332028' => 'Kallstadt',
	'DE07332029' => 'Kindenheim',
	'DE07332030' => 'Kirchheim an der Weinstraße',
	'DE07332031' => 'Kleinkarlbach',
	'DE07332032' => 'Lambrecht (Pfalz), Stadt',
	'DE07332033' => 'Laumersheim',
	'DE07332034' => 'Lindenberg',
	'DE07332035' => 'Meckenheim',
	'DE07332036' => 'Mertesheim',
	'DE07332037' => 'Neidenfels',
	'DE07332038' => 'Neuleiningen',
	'DE07332039' => 'Niederkirchen bei Deidesheim',
	'DE07332040' => 'Obersülzen',
	'DE07332041' => 'Obrigheim (Pfalz)',
	'DE07332042' => 'Quirnheim',
	'DE07332043' => 'Ruppertsberg',
	'DE07332044' => 'Tiefenthal',
	'DE07332046' => 'Wachenheim an der Weinstraße, Stadt',
	'DE07332047' => 'Wattenheim',
	'DE07332048' => 'Weidenthal',
	'DE07332049' => 'Weisenheim am Berg',
	'DE07332050' => 'Weisenheim am Sand',
	'DE07333001' => 'Albisheim (Pfrimm)',
	'DE07333003' => 'Alsenz',
	'DE07333004' => 'Bayerfeld-Steckweiler',
	'DE07333005' => 'Bennhausen',
	'DE07333006' => 'Biedesheim',
	'DE07333007' => 'Bischheim',
	'DE07333008' => 'Bisterschied',
	'DE07333009' => 'Börrstadt',
	'DE07333010' => 'Bolanden',
	'DE07333011' => 'Breunigweiler',
	'DE07333012' => 'Bubenheim',
	'DE07333013' => 'Dannenfels',
	'DE07333014' => 'Dielkirchen',
	'DE07333016' => 'Dörrmoschel',
	'DE07333017' => 'Dreisen',
	'DE07333018' => 'Einselthum',
	'DE07333019' => 'Eisenberg (Pfalz), Stadt',
	'DE07333020' => 'Falkenstein',
	'DE07333021' => 'Finkenbach-Gersweiler',
	'DE07333022' => 'Gauersheim',
	'DE07333023' => 'Gaugrehweiler',
	'DE07333024' => 'Gehrweiler',
	'DE07333025' => 'Gerbach',
	'DE07333026' => 'Göllheim',
	'DE07333027' => 'Gonbach',
	'DE07333028' => 'Gundersweiler',
	'DE07333030' => 'Höringen',
	'DE07333031' => 'Ilbesheim',
	'DE07333032' => 'Immesheim',
	'DE07333033' => 'Imsbach',
	'DE07333034' => 'Imsweiler',
	'DE07333035' => 'Jakobsweiler',
	'DE07333036' => 'Kalkofen',
	'DE07333037' => 'Katzenbach',
	'DE07333038' => 'Kerzenheim',
	'DE07333039' => 'Kirchheimbolanden, Stadt',
	'DE07333040' => 'Kriegsfeld',
	'DE07333041' => 'Lautersheim',
	'DE07333042' => 'Lohnsfeld',
	'DE07333043' => 'Mannweiler-Cölln',
	'DE07333045' => 'Marnheim',
	'DE07333046' => 'Mörsfeld',
	'DE07333047' => 'Morschheim',
	'DE07333048' => 'Münchweiler an der Alsenz',
	'DE07333049' => 'Münsterappel',
	'DE07333050' => 'Niederhausen an der Appel',
	'DE07333051' => 'Niedermoschel',
	'DE07333053' => 'Oberhausen an der Appel',
	'DE07333054' => 'Obermoschel, Stadt',
	'DE07333055' => 'Oberndorf',
	'DE07333056' => 'Oberwiesen',
	'DE07333057' => 'Orbis',
	'DE07333058' => 'Ottersheim',
	'DE07333060' => 'Ramsen',
	'DE07333061' => 'Ransweiler',
	'DE07333062' => 'Rittersheim',
	'DE07333064' => 'Rüssingen',
	'DE07333065' => 'Ruppertsecken',
	'DE07333066' => 'Sankt Alban',
	'DE07333067' => 'Schiersfeld',
	'DE07333068' => 'Schönborn',
	'DE07333069' => 'Schweisweiler',
	'DE07333071' => 'Sippersfeld',
	'DE07333072' => 'Sitters',
	'DE07333073' => 'Stahlberg',
	'DE07333074' => 'Standenbühl',
	'DE07333075' => 'Steinbach am Donnersberg',
	'DE07333076' => 'Stetten',
	'DE07333077' => 'Teschenmoschel',
	'DE07333078' => 'Unkenbach',
	'DE07333079' => 'Waldgrehweiler',
	'DE07333080' => 'Wartenberg-Rohrbach',
	'DE07333081' => 'Weitersweiler',
	'DE07333083' => 'Winterborn',
	'DE07333084' => 'Würzweiler',
	'DE07333201' => 'Rathskirchen',
	'DE07333202' => 'Reichsthal',
	'DE07333203' => 'Seelen',
	'DE07333501' => 'Zellertal',
	'DE07333502' => 'Rockenhausen, Stadt',
	'DE07333503' => 'Winnweiler',
	'DE07334001' => 'Bellheim',
	'DE07334002' => 'Berg (Pfalz)',
	'DE07334004' => 'Erlenbach bei Kandel',
	'DE07334005' => 'Freckenfeld',
	'DE07334006' => 'Freisbach',
	'DE07334007' => 'Germersheim, Stadt',
	'DE07334008' => 'Hagenbach, Stadt',
	'DE07334009' => 'Hatzenbühl',
	'DE07334011' => 'Hördt',
	'DE07334012' => 'Jockgrim',
	'DE07334013' => 'Kandel, Stadt',
	'DE07334014' => 'Knittelsheim',
	'DE07334015' => 'Kuhardt',
	'DE07334016' => 'Leimersheim',
	'DE07334017' => 'Lingenfeld',
	'DE07334018' => 'Lustadt',
	'DE07334020' => 'Minfeld',
	'DE07334021' => 'Neuburg am Rhein',
	'DE07334022' => 'Neupotz',
	'DE07334023' => 'Ottersheim bei Landau',
	'DE07334024' => 'Rheinzabern',
	'DE07334025' => 'Rülzheim',
	'DE07334027' => 'Scheibenhardt',
	'DE07334028' => 'Schwegenheim',
	'DE07334030' => 'Steinweiler',
	'DE07334031' => 'Vollmersweiler',
	'DE07334032' => 'Weingarten (Pfalz)',
	'DE07334033' => 'Westheim (Pfalz)',
	'DE07334034' => 'Winden',
	'DE07334036' => 'Zeiskam',
	'DE07334501' => 'Wörth am Rhein, Stadt',
	'DE07335002' => 'Bann',
	'DE07335003' => 'Bruchmühlbach-Miesau',
	'DE07335004' => 'Enkenbach-Alsenborn',
	'DE07335005' => 'Erzenhausen',
	'DE07335006' => 'Eulenbis',
	'DE07335007' => 'Fischbach',
	'DE07335009' => 'Frankelbach',
	'DE07335010' => 'Frankenstein',
	'DE07335011' => 'Gerhardsbrunn',
	'DE07335012' => 'Hauptstuhl',
	'DE07335013' => 'Heiligenmoschel',
	'DE07335014' => 'Hirschhorn/ Pfalz',
	'DE07335015' => 'Hochspeyer',
	'DE07335016' => 'Hütschenhausen',
	'DE07335017' => 'Katzweiler',
	'DE07335018' => 'Kindsbach',
	'DE07335019' => 'Kollweiler',
	'DE07335020' => 'Kottweiler-Schwanden',
	'DE07335021' => 'Krickenbach',
	'DE07335022' => 'Landstuhl, Sickingenstadt, Stadt',
	'DE07335023' => 'Linden',
	'DE07335024' => 'Mackenbach',
	'DE07335025' => 'Mehlbach',
	'DE07335026' => 'Mehlingen',
	'DE07335027' => 'Mittelbrunn',
	'DE07335028' => 'Neuhemsbach',
	'DE07335029' => 'Niederkirchen',
	'DE07335030' => 'Niedermohr',
	'DE07335031' => 'Oberarnbach',
	'DE07335033' => 'Olsbrücken',
	'DE07335034' => 'Otterbach',
	'DE07335035' => 'Otterberg, Stadt',
	'DE07335037' => 'Queidersbach',
	'DE07335038' => 'Ramstein-Miesenbach, Stadt',
	'DE07335040' => 'Rodenbach',
	'DE07335041' => 'Schallodenbach',
	'DE07335042' => 'Schneckenhausen',
	'DE07335043' => 'Schwedelbach',
	'DE07335044' => 'Steinwenden',
	'DE07335045' => 'Stelzenberg',
	'DE07335046' => 'Sulzbachtal',
	'DE07335047' => 'Trippstadt',
	'DE07335048' => 'Waldleiningen',
	'DE07335049' => 'Weilerbach',
	'DE07335201' => 'Lambsborn',
	'DE07335202' => 'Langwieden',
	'DE07335203' => 'Martinshöhe',
	'DE07335204' => 'Schopp',
	'DE07335205' => 'Sembach',
	'DE07335501' => 'Reichenbach-Steegen',
	'DE07336001' => 'Adenbach',
	'DE07336002' => 'Albessen',
	'DE07336003' => 'Altenglan',
	'DE07336004' => 'Altenkirchen',
	'DE07336005' => 'Aschbach',
	'DE07336006' => 'Blaubach',
	'DE07336008' => 'Börsborn',
	'DE07336009' => 'Bosenbach',
	'DE07336010' => 'Breitenbach',
	'DE07336011' => 'Brücken (Pfalz)',
	'DE07336012' => 'Buborn',
	'DE07336013' => 'Cronenberg',
	'DE07336014' => 'Deimberg',
	'DE07336015' => 'Dennweiler-Frohnbach',
	'DE07336016' => 'Dittweiler',
	'DE07336017' => 'Dunzweiler',
	'DE07336018' => 'Ehweiler',
	'DE07336019' => 'Einöllen',
	'DE07336021' => 'Elzweiler',
	'DE07336022' => 'Erdesbach',
	'DE07336023' => 'Eßweiler',
	'DE07336024' => 'Etschberg',
	'DE07336025' => 'Föckelberg',
	'DE07336027' => 'Frohnhofen',
	'DE07336029' => 'Ginsweiler',
	'DE07336030' => 'Glanbrücken',
	'DE07336031' => 'Glan-Münchweiler',
	'DE07336032' => 'Gries',
	'DE07336033' => 'Grumbach',
	'DE07336034' => 'Haschbach am Remigiusberg',
	'DE07336035' => 'Hausweiler',
	'DE07336036' => 'Hefersweiler',
	'DE07336037' => 'Henschtal',
	'DE07336038' => 'Heinzenhausen',
	'DE07336039' => 'Herchweiler',
	'DE07336040' => 'Herren-Sulzbach',
	'DE07336041' => 'Herschweiler-Pettersheim',
	'DE07336042' => 'Hinzweiler',
	'DE07336043' => 'Hohenöllen',
	'DE07336044' => 'Homberg',
	'DE07336045' => 'Hoppstädten',
	'DE07336046' => 'Horschbach',
	'DE07336047' => 'Hüffler',
	'DE07336048' => 'Jettenbach',
	'DE07336049' => 'Kappeln',
	'DE07336050' => 'Kirrweiler',
	'DE07336051' => 'Körborn',
	'DE07336052' => 'Konken',
	'DE07336053' => 'Kreimbach-Kaulbach',
	'DE07336054' => 'Krottelbach',
	'DE07336055' => 'Kusel, Stadt',
	'DE07336056' => 'Langenbach',
	'DE07336057' => 'Langweiler',
	'DE07336058' => 'Lauterecken, Stadt',
	'DE07336060' => 'Lohnweiler',
	'DE07336061' => 'Medard',
	'DE07336062' => 'Merzweiler',
	'DE07336064' => 'Nanzdietschweiler',
	'DE07336065' => 'Nerzweiler',
	'DE07336066' => 'Neunkirchen am Potzberg',
	'DE07336067' => 'Niederalben',
	'DE07336068' => 'Niederstaufenbach',
	'DE07336069' => 'Nußbach',
	'DE07336070' => 'Oberalben',
	'DE07336071' => 'Oberstaufenbach',
	'DE07336072' => 'Oberweiler im Tal',
	'DE07336073' => 'Oberweiler-Tiefenbach',
	'DE07336074' => 'Odenbach',
	'DE07336075' => 'Offenbach-Hundheim',
	'DE07336076' => 'Ohmbach',
	'DE07336077' => 'Pfeffelbach',
	'DE07336079' => 'Rammelsbach',
	'DE07336081' => 'Rathsweiler',
	'DE07336082' => 'Rehweiler',
	'DE07336084' => 'Reichweiler',
	'DE07336085' => 'Reipoltskirchen',
	'DE07336086' => 'Relsberg',
	'DE07336087' => 'Rothselberg',
	'DE07336088' => 'Ruthweiler',
	'DE07336089' => 'Rutsweiler am Glan',
	'DE07336090' => 'Rutsweiler an der Lauter',
	'DE07336091' => 'Schellweiler',
	'DE07336092' => 'Schönenberg-Kübelberg',
	'DE07336094' => 'Selchenbach',
	'DE07336095' => 'Sankt Julian',
	'DE07336096' => 'Steinbach am Glan',
	'DE07336097' => 'Thallichtenberg',
	'DE07336098' => 'Theisbergstegen',
	'DE07336099' => 'Ulmet',
	'DE07336100' => 'Unterjeckenbach',
	'DE07336101' => 'Wahnwegen',
	'DE07336102' => 'Waldmohr',
	'DE07336103' => 'Welchweiler',
	'DE07336104' => 'Wiesweiler',
	'DE07336105' => 'Wolfstein, Stadt',
	'DE07336106' => 'Bedesbach',
	'DE07336107' => 'Matzenbach',
	'DE07336501' => 'Quirnbach/ Pfalz',
	'DE07337001' => 'Albersweiler',
	'DE07337002' => 'Altdorf',
	'DE07337005' => 'Bad Bergzabern, Stadt',
	'DE07337006' => 'Barbelroth',
	'DE07337007' => 'Billigheim-Ingenheim',
	'DE07337008' => 'Birkenhördt',
	'DE07337009' => 'Birkweiler',
	'DE07337011' => 'Böbingen',
	'DE07337012' => 'Böchingen',
	'DE07337013' => 'Böllenborn',
	'DE07337014' => 'Bornheim',
	'DE07337015' => 'Burrweiler',
	'DE07337017' => 'Dernbach',
	'DE07337018' => 'Dierbach',
	'DE07337019' => 'Dörrenbach',
	'DE07337020' => 'Edenkoben, Stadt',
	'DE07337021' => 'Edesheim',
	'DE07337022' => 'Eschbach',
	'DE07337023' => 'Essingen',
	'DE07337024' => 'Eußerthal',
	'DE07337025' => 'Flemlingen',
	'DE07337026' => 'Frankweiler',
	'DE07337027' => 'Freimersheim (Pfalz)',
	'DE07337028' => 'Gleisweiler',
	'DE07337029' => 'Gleiszellen-Gleishorbach',
	'DE07337031' => 'Göcklingen',
	'DE07337032' => 'Gommersheim',
	'DE07337033' => 'Gossersweiler-Stein',
	'DE07337035' => 'Großfischlingen',
	'DE07337036' => 'Hainfeld',
	'DE07337037' => 'Hergersweiler',
	'DE07337038' => 'Herxheim bei Landau/ Pfalz',
	'DE07337039' => 'Herxheimweyher',
	'DE07337040' => 'Heuchelheim-Klingen',
	'DE07337041' => 'Hochstadt (Pfalz)',
	'DE07337042' => 'Ilbesheim bei Landau in der Pfalz',
	'DE07337043' => 'Impflingen',
	'DE07337044' => 'Insheim',
	'DE07337045' => 'Kapellen-Drusweiler',
	'DE07337046' => 'Kapsweyer',
	'DE07337047' => 'Kirrweiler (Pfalz)',
	'DE07337048' => 'Kleinfischlingen',
	'DE07337049' => 'Klingenmünster',
	'DE07337050' => 'Knöringen',
	'DE07337051' => 'Leinsweiler',
	'DE07337052' => 'Maikammer',
	'DE07337054' => 'Münchweiler am Klingbach',
	'DE07337055' => 'Niederhorbach',
	'DE07337056' => 'Niederotterbach',
	'DE07337058' => 'Oberhausen',
	'DE07337059' => 'Oberotterbach',
	'DE07337060' => 'Oberschlettenbach',
	'DE07337061' => 'Offenbach an der Queich',
	'DE07337062' => 'Pleisweiler-Oberhofen',
	'DE07337064' => 'Ramberg',
	'DE07337065' => 'Ranschbach',
	'DE07337066' => 'Rhodt unter Rietburg',
	'DE07337067' => 'Rinnthal',
	'DE07337068' => 'Rohrbach',
	'DE07337069' => 'Roschbach',
	'DE07337070' => 'Sankt Martin',
	'DE07337071' => 'Schweigen-Rechtenbach',
	'DE07337072' => 'Schweighofen',
	'DE07337073' => 'Siebeldingen',
	'DE07337074' => 'Silz',
	'DE07337076' => 'Steinfeld',
	'DE07337077' => 'Venningen',
	'DE07337078' => 'Völkersweiler',
	'DE07337079' => 'Vorderweidenthal',
	'DE07337080' => 'Waldhambach',
	'DE07337081' => 'Waldrohrbach',
	'DE07337082' => 'Walsheim',
	'DE07337083' => 'Wernersberg',
	'DE07337084' => 'Weyher in der Pfalz',
	'DE07337501' => 'Annweiler am Trifels, Stadt',
	'DE07338001' => 'Altrip',
	'DE07338002' => 'Beindersheim',
	'DE07338003' => 'Birkenheide',
	'DE07338004' => 'Bobenheim-Roxheim',
	'DE07338005' => 'Böhl-Iggelheim',
	'DE07338006' => 'Dannstadt-Schauernheim',
	'DE07338007' => 'Dudenhofen',
	'DE07338008' => 'Fußgönheim',
	'DE07338009' => 'Großniedesheim',
	'DE07338010' => 'Hanhofen',
	'DE07338011' => 'Harthausen',
	'DE07338012' => 'Heßheim',
	'DE07338013' => 'Heuchelheim bei Frankenthal',
	'DE07338014' => 'Hochdorf-Assenheim',
	'DE07338015' => 'Kleinniedesheim',
	'DE07338016' => 'Lambsheim',
	'DE07338017' => 'Limburgerhof',
	'DE07338018' => 'Maxdorf',
	'DE07338019' => 'Mutterstadt',
	'DE07338020' => 'Neuhofen',
	'DE07338021' => 'Otterstadt',
	'DE07338022' => 'Rödersheim-Gronau',
	'DE07338023' => 'Römerberg',
	'DE07338025' => 'Schifferstadt, Stadt',
	'DE07338026' => 'Waldsee',
	'DE07339001' => 'Appenheim',
	'DE07339002' => 'Aspisheim',
	'DE07339003' => 'Bacharach, Stadt',
	'DE07339004' => 'Badenheim',
	'DE07339005' => 'Bingen am Rhein, Stadt',
	'DE07339006' => 'Bodenheim',
	'DE07339007' => 'Breitscheid',
	'DE07339008' => 'Bubenheim',
	'DE07339009' => 'Budenheim',
	'DE07339010' => 'Dalheim',
	'DE07339011' => 'Dexheim',
	'DE07339012' => 'Dienheim',
	'DE07339013' => 'Dolgesheim',
	'DE07339015' => 'Eimsheim',
	'DE07339016' => 'Engelstadt',
	'DE07339017' => 'Essenheim',
	'DE07339018' => 'Friesenheim',
	'DE07339019' => 'Gau-Algesheim, Stadt',
	'DE07339020' => 'Gau-Bischofsheim',
	'DE07339021' => 'Gensingen',
	'DE07339022' => 'Grolsheim',
	'DE07339024' => 'Guntersblum',
	'DE07339025' => 'Hahnheim',
	'DE07339026' => 'Harxheim',
	'DE07339027' => 'Heidesheim am Rhein',
	'DE07339028' => 'Hillesheim',
	'DE07339029' => 'Horrweiler',
	'DE07339030' => 'Ingelheim am Rhein, Stadt',
	'DE07339031' => 'Jugenheim in Rheinhessen',
	'DE07339032' => 'Klein-Winternheim',
	'DE07339033' => 'Köngernheim',
	'DE07339034' => 'Lörzweiler',
	'DE07339035' => 'Ludwigshöhe',
	'DE07339036' => 'Manubach',
	'DE07339037' => 'Mommenheim',
	'DE07339038' => 'Münster-Sarmsheim',
	'DE07339039' => 'Nackenheim',
	'DE07339040' => 'Niederheimbach',
	'DE07339041' => 'Nieder-Hilbersheim',
	'DE07339042' => 'Nieder-Olm, Stadt',
	'DE07339043' => 'Nierstein, Stadt',
	'DE07339044' => 'Oberdiebach',
	'DE07339045' => 'Oberheimbach',
	'DE07339046' => 'Ober-Hilbersheim',
	'DE07339047' => 'Ober-Olm',
	'DE07339048' => 'Ockenheim',
	'DE07339049' => 'Oppenheim, Stadt',
	'DE07339050' => 'Sankt Johann',
	'DE07339051' => 'Schwabenheim an der Selz',
	'DE07339053' => 'Selzen',
	'DE07339054' => 'Sörgenloch',
	'DE07339056' => 'Sprendlingen',
	'DE07339057' => 'Stadecken-Elsheim',
	'DE07339058' => 'Trechtingshausen',
	'DE07339059' => 'Uelversheim',
	'DE07339060' => 'Undenheim',
	'DE07339061' => 'Wackernheim',
	'DE07339062' => 'Waldalgesheim',
	'DE07339063' => 'Weiler bei Bingen',
	'DE07339064' => 'Weinolsheim',
	'DE07339065' => 'Welgesheim',
	'DE07339066' => 'Wintersheim',
	'DE07339067' => 'Zornheim',
	'DE07339068' => 'Zotzenheim',
	'DE07339201' => 'Dorn-Dürkheim',
	'DE07339202' => 'Wolfsheim',
	'DE07340001' => 'Bobenthal',
	'DE07340002' => 'Busenberg',
	'DE07340003' => 'Clausen',
	'DE07340004' => 'Dahn, Stadt',
	'DE07340005' => 'Darstein',
	'DE07340006' => 'Dimbach',
	'DE07340007' => 'Donsieders',
	'DE07340008' => 'Eppenbrunn',
	'DE07340009' => 'Erfweiler',
	'DE07340010' => 'Erlenbach bei Dahn',
	'DE07340011' => 'Fischbach bei Dahn',
	'DE07340012' => 'Geiselberg',
	'DE07340014' => 'Hauenstein',
	'DE07340015' => 'Heltersberg',
	'DE07340016' => 'Hermersberg',
	'DE07340017' => 'Herschberg',
	'DE07340018' => 'Hettenhausen',
	'DE07340019' => 'Hilst',
	'DE07340020' => 'Hinterweidenthal',
	'DE07340021' => 'Hirschthal',
	'DE07340022' => 'Höheinöd',
	'DE07340023' => 'Höheischweiler',
	'DE07340024' => 'Höhfröschen',
	'DE07340025' => 'Horbach',
	'DE07340026' => 'Kröppen',
	'DE07340027' => 'Leimen',
	'DE07340028' => 'Lemberg',
	'DE07340029' => 'Ludwigswinkel',
	'DE07340030' => 'Lug',
	'DE07340031' => 'Merzalben',
	'DE07340032' => 'Münchweiler an der Rodalb',
	'DE07340033' => 'Niederschlettenbach',
	'DE07340034' => 'Nothweiler',
	'DE07340035' => 'Nünschweiler',
	'DE07340036' => 'Obersimten',
	'DE07340037' => 'Petersberg',
	'DE07340038' => 'Rodalben, Stadt',
	'DE07340039' => 'Rumbach',
	'DE07340040' => 'Ruppertsweiler',
	'DE07340041' => 'Saalstadt',
	'DE07340042' => 'Schauerberg',
	'DE07340043' => 'Schindhard',
	'DE07340044' => 'Schmalenberg',
	'DE07340045' => 'Schönau (Pfalz)',
	'DE07340047' => 'Schwanheim',
	'DE07340048' => 'Schweix',
	'DE07340049' => 'Spirkelbach',
	'DE07340050' => 'Steinalben',
	'DE07340051' => 'Thaleischweiler-Fröschen',
	'DE07340052' => 'Trulben',
	'DE07340053' => 'Vinningen',
	'DE07340054' => 'Waldfischbach-Burgalben',
	'DE07340055' => 'Weselberg',
	'DE07340057' => 'Wilgartswiesen',
	'DE07340201' => 'Althornbach',
	'DE07340202' => 'Battweiler',
	'DE07340203' => 'Bechhofen',
	'DE07340204' => 'Biedershausen',
	'DE07340205' => 'Bottenbach',
	'DE07340206' => 'Contwig',
	'DE07340207' => 'Dellfeld',
	'DE07340208' => 'Dietrichingen',
	'DE07340209' => 'Großbundenbach',
	'DE07340210' => 'Großsteinhausen',
	'DE07340211' => 'Hornbach, Stadt',
	'DE07340212' => 'Käshofen',
	'DE07340213' => 'Kleinbundenbach',
	'DE07340214' => 'Kleinsteinhausen',
	'DE07340215' => 'Knopp-Labach',
	'DE07340216' => 'Krähenberg',
	'DE07340217' => 'Maßweiler',
	'DE07340218' => 'Mauschbach',
	'DE07340219' => 'Obernheim-Kirchenarnbach',
	'DE07340220' => 'Reifenberg',
	'DE07340221' => 'Riedelberg',
	'DE07340222' => 'Rieschweiler-Mühlbach',
	'DE07340223' => 'Rosenkopf',
	'DE07340224' => 'Schmitshausen',
	'DE07340225' => 'Wallhalben',
	'DE07340226' => 'Walshausen',
	'DE07340227' => 'Wiesbach',
	'DE07340228' => 'Winterbach (Pfalz)',
	'DE07340501' => 'Bruchweiler-Bärenbach',
	'DE07340502' => 'Bundenthal',
	'DE08111000' => 'Stuttgart, Landeshauptstadt',
	'DE08115001' => 'Aidlingen',
	'DE08115002' => 'Altdorf',
	'DE08115003' => 'Böblingen, Stadt',
	'DE08115004' => 'Bondorf',
	'DE08115010' => 'Deckenpfronn',
	'DE08115013' => 'Ehningen',
	'DE08115015' => 'Gärtringen',
	'DE08115016' => 'Gäufelden',
	'DE08115021' => 'Herrenberg, Stadt',
	'DE08115022' => 'Hildrizhausen',
	'DE08115024' => 'Holzgerlingen, Stadt',
	'DE08115028' => 'Leonberg, Stadt',
	'DE08115029' => 'Magstadt',
	'DE08115034' => 'Mötzingen',
	'DE08115037' => 'Nufringen',
	'DE08115041' => 'Renningen, Stadt',
	'DE08115042' => 'Rutesheim, Stadt',
	'DE08115044' => 'Schönaich',
	'DE08115045' => 'Sindelfingen, Stadt',
	'DE08115046' => 'Steinenbronn',
	'DE08115048' => 'Waldenbuch, Stadt',
	'DE08115050' => 'Weil der Stadt, Stadt',
	'DE08115051' => 'Weil im Schönbuch',
	'DE08115052' => 'Weissach',
	'DE08115053' => 'Jettingen',
	'DE08115054' => 'Grafenau',
	'DE08116004' => 'Altbach',
	'DE08116005' => 'Altdorf',
	'DE08116006' => 'Altenriet',
	'DE08116007' => 'Baltmannsweiler',
	'DE08116008' => 'Bempflingen',
	'DE08116011' => 'Beuren',
	'DE08116012' => 'Bissingen an der Teck',
	'DE08116014' => 'Deizisau',
	'DE08116015' => 'Denkendorf',
	'DE08116016' => 'Dettingen unter Teck',
	'DE08116018' => 'Erkenbrechtsweiler',
	'DE08116019' => 'Esslingen am Neckar, Stadt',
	'DE08116020' => 'Frickenhausen',
	'DE08116022' => 'Großbettlingen',
	'DE08116027' => 'Hochdorf',
	'DE08116029' => 'Holzmaden',
	'DE08116033' => 'Kirchheim unter Teck, Stadt',
	'DE08116035' => 'Köngen',
	'DE08116036' => 'Kohlberg',
	'DE08116037' => 'Lichtenwald',
	'DE08116041' => 'Neckartailfingen',
	'DE08116042' => 'Neckartenzlingen',
	'DE08116043' => 'Neidlingen',
	'DE08116046' => 'Neuffen, Stadt',
	'DE08116047' => 'Neuhausen auf den Fildern',
	'DE08116048' => 'Notzingen',
	'DE08116049' => 'Nürtingen, Stadt',
	'DE08116050' => 'Oberboihingen',
	'DE08116053' => 'Ohmden',
	'DE08116054' => 'Owen, Stadt',
	'DE08116056' => 'Plochingen, Stadt',
	'DE08116058' => 'Reichenbach an der Fils',
	'DE08116063' => 'Schlaitdorf',
	'DE08116068' => 'Unterensingen',
	'DE08116070' => 'Weilheim an der Teck, Stadt',
	'DE08116071' => 'Wendlingen am Neckar, Stadt',
	'DE08116072' => 'Wernau (Neckar), Stadt',
	'DE08116073' => 'Wolfschlugen',
	'DE08116076' => 'Aichwald',
	'DE08116077' => 'Filderstadt, Stadt',
	'DE08116078' => 'Leinfelden-Echterdingen, Stadt',
	'DE08116079' => 'Lenningen',
	'DE08116080' => 'Ostfildern, Stadt',
	'DE08116081' => 'Aichtal, Stadt',
	'DE08117001' => 'Adelberg',
	'DE08117002' => 'Aichelberg',
	'DE08117003' => 'Albershausen',
	'DE08117006' => 'Bad Ditzenbach',
	'DE08117007' => 'Bad Überkingen',
	'DE08117009' => 'Birenbach',
	'DE08117010' => 'Böhmenkirch',
	'DE08117011' => 'Börtlingen',
	'DE08117012' => 'Bad Boll',
	'DE08117014' => 'Deggingen',
	'DE08117015' => 'Donzdorf, Stadt',
	'DE08117016' => 'Drackenstein',
	'DE08117017' => 'Dürnau',
	'DE08117018' => 'Ebersbach an der Fils, Stadt',
	'DE08117019' => 'Eislingen/Fils, Stadt',
	'DE08117020' => 'Eschenbach',
	'DE08117023' => 'Gammelshausen',
	'DE08117024' => 'Geislingen an der Steige, Stadt',
	'DE08117025' => 'Gingen an der Fils',
	'DE08117026' => 'Göppingen, Stadt',
	'DE08117028' => 'Gruibingen',
	'DE08117029' => 'Hattenhofen',
	'DE08117030' => 'Heiningen',
	'DE08117031' => 'Hohenstadt',
	'DE08117033' => 'Kuchen',
	'DE08117035' => 'Mühlhausen im Täle',
	'DE08117037' => 'Ottenbach',
	'DE08117038' => 'Rechberghausen',
	'DE08117042' => 'Salach',
	'DE08117043' => 'Schlat',
	'DE08117044' => 'Schlierbach',
	'DE08117049' => 'Süßen, Stadt',
	'DE08117051' => 'Uhingen, Stadt',
	'DE08117053' => 'Wäschenbeuren',
	'DE08117055' => 'Wangen',
	'DE08117058' => 'Wiesensteig, Stadt',
	'DE08117060' => 'Zell unter Aichelberg',
	'DE08117061' => 'Lauterstein, Stadt',
	'DE08118001' => 'Affalterbach',
	'DE08118003' => 'Asperg, Stadt',
	'DE08118006' => 'Benningen am Neckar',
	'DE08118007' => 'Besigheim, Stadt',
	'DE08118010' => 'Bönnigheim, Stadt',
	'DE08118011' => 'Ditzingen, Stadt',
	'DE08118012' => 'Eberdingen',
	'DE08118014' => 'Erdmannhausen',
	'DE08118015' => 'Erligheim',
	'DE08118016' => 'Freudental',
	'DE08118018' => 'Gemmrigheim',
	'DE08118019' => 'Gerlingen, Stadt',
	'DE08118021' => 'Großbottwar, Stadt',
	'DE08118027' => 'Hemmingen',
	'DE08118028' => 'Hessigheim',
	'DE08118040' => 'Kirchheim am Neckar',
	'DE08118046' => 'Kornwestheim, Stadt',
	'DE08118047' => 'Löchgau',
	'DE08118048' => 'Ludwigsburg, Stadt',
	'DE08118049' => 'Marbach am Neckar, Stadt',
	'DE08118050' => 'Markgröningen, Stadt',
	'DE08118051' => 'Möglingen',
	'DE08118053' => 'Mundelsheim',
	'DE08118054' => 'Murr',
	'DE08118059' => 'Oberriexingen, Stadt',
	'DE08118060' => 'Oberstenfeld',
	'DE08118063' => 'Pleidelsheim',
	'DE08118067' => 'Schwieberdingen',
	'DE08118068' => 'Sersheim',
	'DE08118070' => 'Steinheim an der Murr, Stadt',
	'DE08118071' => 'Tamm',
	'DE08118073' => 'Vaihingen an der Enz, Stadt',
	'DE08118074' => 'Walheim',
	'DE08118076' => 'Sachsenheim, Stadt',
	'DE08118077' => 'Ingersheim',
	'DE08118078' => 'Freiberg am Neckar, Stadt',
	'DE08118079' => 'Bietigheim-Bissingen, Stadt',
	'DE08118080' => 'Korntal-Münchingen, Stadt',
	'DE08118081' => 'Remseck am Neckar, Stadt',
	'DE08119001' => 'Alfdorf',
	'DE08119003' => 'Allmersbach im Tal',
	'DE08119004' => 'Althütte',
	'DE08119006' => 'Auenwald',
	'DE08119008' => 'Backnang, Stadt',
	'DE08119018' => 'Burgstetten',
	'DE08119020' => 'Fellbach, Stadt',
	'DE08119024' => 'Großerlach',
	'DE08119037' => 'Kaisersbach',
	'DE08119038' => 'Kirchberg an der Murr',
	'DE08119041' => 'Korb',
	'DE08119042' => 'Leutenbach',
	'DE08119044' => 'Murrhardt, Stadt',
	'DE08119053' => 'Oppenweiler',
	'DE08119055' => 'Plüderhausen',
	'DE08119061' => 'Rudersberg',
	'DE08119067' => 'Schorndorf, Stadt',
	'DE08119068' => 'Schwaikheim',
	'DE08119069' => 'Spiegelberg',
	'DE08119075' => 'Sulzbach an der Murr',
	'DE08119076' => 'Urbach',
	'DE08119079' => 'Waiblingen, Stadt',
	'DE08119083' => 'Weissach im Tal',
	'DE08119084' => 'Welzheim, Stadt',
	'DE08119085' => 'Winnenden, Stadt',
	'DE08119086' => 'Winterbach',
	'DE08119087' => 'Aspach',
	'DE08119089' => 'Berglen',
	'DE08119090' => 'Remshalden',
	'DE08119091' => 'Weinstadt, Stadt',
	'DE08119093' => 'Kernen im Remstal',
	'DE08121000' => 'Heilbronn, Stadt',
	'DE08125001' => 'Abstatt',
	'DE08125005' => 'Bad Friedrichshall, Stadt',
	'DE08125006' => 'Bad Rappenau, Stadt',
	'DE08125007' => 'Bad Wimpfen, Stadt',
	'DE08125008' => 'Beilstein, Stadt',
	'DE08125013' => 'Brackenheim, Stadt',
	'DE08125017' => 'Cleebronn',
	'DE08125021' => 'Eberstadt',
	'DE08125024' => 'Ellhofen',
	'DE08125026' => 'Eppingen, Stadt',
	'DE08125027' => 'Erlenbach',
	'DE08125030' => 'Flein',
	'DE08125034' => 'Gemmingen',
	'DE08125038' => 'Güglingen, Stadt',
	'DE08125039' => 'Gundelsheim, Stadt',
	'DE08125046' => 'Ilsfeld',
	'DE08125047' => 'Ittlingen',
	'DE08125048' => 'Jagsthausen',
	'DE08125049' => 'Kirchardt',
	'DE08125056' => 'Lauffen am Neckar, Stadt',
	'DE08125057' => 'Lehrensteinsfeld',
	'DE08125058' => 'Leingarten',
	'DE08125059' => 'Löwenstein, Stadt',
	'DE08125061' => 'Massenbachhausen',
	'DE08125063' => 'Möckmühl, Stadt',
	'DE08125065' => 'Neckarsulm, Stadt',
	'DE08125066' => 'Neckarwestheim',
	'DE08125068' => 'Neudenau, Stadt',
	'DE08125069' => 'Neuenstadt am Kocher, Stadt',
	'DE08125074' => 'Nordheim',
	'DE08125078' => 'Oedheim',
	'DE08125079' => 'Offenau',
	'DE08125081' => 'Pfaffenhofen',
	'DE08125084' => 'Roigheim',
	'DE08125086' => 'Schwaigern, Stadt',
	'DE08125087' => 'Siegelsbach',
	'DE08125094' => 'Talheim',
	'DE08125096' => 'Untereisesheim',
	'DE08125098' => 'Untergruppenbach',
	'DE08125102' => 'Weinsberg, Stadt',
	'DE08125103' => 'Widdern, Stadt',
	'DE08125107' => 'Wüstenrot',
	'DE08125108' => 'Zaberfeld',
	'DE08125110' => 'Obersulm',
	'DE08125111' => 'Hardthausen am Kocher',
	'DE08125113' => 'Langenbrettach',
	'DE08126011' => 'Bretzfeld',
	'DE08126020' => 'Dörzbach',
	'DE08126028' => 'Forchtenberg, Stadt',
	'DE08126039' => 'Ingelfingen, Stadt',
	'DE08126045' => 'Krautheim, Stadt',
	'DE08126046' => 'Künzelsau, Stadt',
	'DE08126047' => 'Kupferzell',
	'DE08126056' => 'Mulfingen',
	'DE08126058' => 'Neuenstein, Stadt',
	'DE08126060' => 'Niedernhall, Stadt',
	'DE08126066' => 'Öhringen, Stadt',
	'DE08126069' => 'Pfedelbach',
	'DE08126072' => 'Schöntal',
	'DE08126085' => 'Waldenburg, Stadt',
	'DE08126086' => 'Weißbach',
	'DE08126094' => 'Zweiflingen',
	'DE08127008' => 'Blaufelden',
	'DE08127009' => 'Braunsbach',
	'DE08127012' => 'Bühlertann',
	'DE08127013' => 'Bühlerzell',
	'DE08127014' => 'Crailsheim, Stadt',
	'DE08127023' => 'Fichtenberg',
	'DE08127025' => 'Gaildorf, Stadt',
	'DE08127032' => 'Gerabronn, Stadt',
	'DE08127043' => 'Ilshofen, Stadt',
	'DE08127046' => 'Kirchberg an der Jagst, Stadt',
	'DE08127047' => 'Langenburg, Stadt',
	'DE08127052' => 'Mainhardt',
	'DE08127056' => 'Michelbach an der Bilz',
	'DE08127059' => 'Michelfeld',
	'DE08127062' => 'Oberrot',
	'DE08127063' => 'Obersontheim',
	'DE08127071' => 'Rot am See',
	'DE08127073' => 'Satteldorf',
	'DE08127075' => 'Schrozberg, Stadt',
	'DE08127076' => 'Schwäbisch Hall, Stadt',
	'DE08127079' => 'Sulzbach-Laufen',
	'DE08127086' => 'Untermünkheim',
	'DE08127089' => 'Vellberg, Stadt',
	'DE08127091' => 'Wallhausen',
	'DE08127099' => 'Wolpertshausen',
	'DE08127100' => 'Rosengarten',
	'DE08127101' => 'Kreßberg',
	'DE08127102' => 'Fichtenau',
	'DE08127103' => 'Frankenhardt',
	'DE08127104' => 'Stimpfach',
	'DE08128006' => 'Assamstadt',
	'DE08128007' => 'Bad Mergentheim, Stadt',
	'DE08128014' => 'Boxberg, Stadt',
	'DE08128020' => 'Creglingen, Stadt',
	'DE08128039' => 'Freudenberg, Stadt',
	'DE08128045' => 'Großrinderfeld',
	'DE08128047' => 'Grünsfeld, Stadt',
	'DE08128058' => 'Igersheim',
	'DE08128061' => 'Königheim',
	'DE08128064' => 'Külsheim, Stadt',
	'DE08128082' => 'Niederstetten, Stadt',
	'DE08128115' => 'Tauberbischofsheim, Stadt',
	'DE08128126' => 'Weikersheim, Stadt',
	'DE08128128' => 'Werbach',
	'DE08128131' => 'Wertheim, Stadt',
	'DE08128137' => 'Wittighausen',
	'DE08128138' => 'Ahorn',
	'DE08128139' => 'Lauda-Königshofen, Stadt',
	'DE08135010' => 'Dischingen',
	'DE08135015' => 'Gerstetten',
	'DE08135016' => 'Giengen an der Brenz, Stadt',
	'DE08135019' => 'Heidenheim an der Brenz, Stadt',
	'DE08135020' => 'Herbrechtingen, Stadt',
	'DE08135021' => 'Hermaringen',
	'DE08135025' => 'Königsbronn',
	'DE08135026' => 'Nattheim',
	'DE08135027' => 'Niederstotzingen, Stadt',
	'DE08135031' => 'Sontheim an der Brenz',
	'DE08135032' => 'Steinheim am Albuch',
	'DE08136002' => 'Abtsgmünd',
	'DE08136003' => 'Adelmannsfelden',
	'DE08136007' => 'Bartholomä',
	'DE08136009' => 'Böbingen an der Rems',
	'DE08136010' => 'Bopfingen, Stadt',
	'DE08136015' => 'Durlangen',
	'DE08136018' => 'Ellenberg',
	'DE08136019' => 'Ellwangen (Jagst), Stadt',
	'DE08136020' => 'Eschach',
	'DE08136021' => 'Essingen',
	'DE08136024' => 'Göggingen',
	'DE08136027' => 'Gschwend',
	'DE08136028' => 'Heubach, Stadt',
	'DE08136029' => 'Heuchlingen',
	'DE08136033' => 'Hüttlingen',
	'DE08136034' => 'Iggingen',
	'DE08136035' => 'Jagstzell',
	'DE08136037' => 'Kirchheim am Ries',
	'DE08136038' => 'Lauchheim, Stadt',
	'DE08136040' => 'Leinzell',
	'DE08136042' => 'Lorch, Stadt',
	'DE08136043' => 'Mögglingen',
	'DE08136044' => 'Mutlangen',
	'DE08136045' => 'Neresheim, Stadt',
	'DE08136046' => 'Neuler',
	'DE08136049' => 'Obergröningen',
	'DE08136050' => 'Oberkochen, Stadt',
	'DE08136060' => 'Rosenberg',
	'DE08136061' => 'Ruppertshofen',
	'DE08136062' => 'Schechingen',
	'DE08136065' => 'Schwäbisch Gmünd, Stadt',
	'DE08136066' => 'Spraitbach',
	'DE08136068' => 'Stödtlen',
	'DE08136070' => 'Täferrot',
	'DE08136071' => 'Tannhausen',
	'DE08136075' => 'Unterschneidheim',
	'DE08136079' => 'Waldstetten',
	'DE08136082' => 'Westhausen',
	'DE08136084' => 'Wört',
	'DE08136087' => 'Riesbürg',
	'DE08136088' => 'Aalen, Stadt',
	'DE08136089' => 'Rainau',
	'DE08211000' => 'Baden-Baden, Stadt',
	'DE08212000' => 'Karlsruhe, Stadt',
	'DE08215007' => 'Bretten, Stadt',
	'DE08215009' => 'Bruchsal, Stadt',
	'DE08215017' => 'Ettlingen, Stadt',
	'DE08215021' => 'Forst',
	'DE08215025' => 'Gondelsheim',
	'DE08215029' => 'Hambrücken',
	'DE08215039' => 'Kronau',
	'DE08215040' => 'Kürnbach',
	'DE08215046' => 'Malsch',
	'DE08215047' => 'Marxzell',
	'DE08215059' => 'Oberderdingen',
	'DE08215064' => 'Östringen, Stadt',
	'DE08215066' => 'Philippsburg, Stadt',
	'DE08215082' => 'Sulzfeld',
	'DE08215084' => 'Ubstadt-Weiher',
	'DE08215089' => 'Walzbachtal',
	'DE08215090' => 'Weingarten (Baden)',
	'DE08215094' => 'Zaisenhausen',
	'DE08215096' => 'Karlsbad',
	'DE08215097' => 'Kraichtal, Stadt',
	'DE08215099' => 'Graben-Neudorf',
	'DE08215100' => 'Bad Schönborn',
	'DE08215101' => 'Pfinztal',
	'DE08215102' => 'Eggenstein-Leopoldshafen',
	'DE08215103' => 'Karlsdorf-Neuthard',
	'DE08215105' => 'Linkenheim-Hochstetten',
	'DE08215106' => 'Waghäusel, Stadt',
	'DE08215107' => 'Oberhausen-Rheinhausen',
	'DE08215108' => 'Rheinstetten, Stadt',
	'DE08215109' => 'Stutensee, Stadt',
	'DE08215110' => 'Waldbronn',
	'DE08215111' => 'Dettenheim',
	'DE08216002' => 'Au am Rhein',
	'DE08216005' => 'Bietigheim',
	'DE08216006' => 'Bischweier',
	'DE08216007' => 'Bühl, Stadt',
	'DE08216008' => 'Bühlertal',
	'DE08216009' => 'Durmersheim',
	'DE08216012' => 'Elchesheim-Illingen',
	'DE08216013' => 'Forbach',
	'DE08216015' => 'Gaggenau, Stadt',
	'DE08216017' => 'Gernsbach, Stadt',
	'DE08216022' => 'Hügelsheim',
	'DE08216023' => 'Iffezheim',
	'DE08216024' => 'Kuppenheim, Stadt',
	'DE08216028' => 'Lichtenau, Stadt',
	'DE08216029' => 'Loffenau',
	'DE08216033' => 'Muggensturm',
	'DE08216039' => 'Ötigheim',
	'DE08216041' => 'Ottersweier',
	'DE08216043' => 'Rastatt, Stadt',
	'DE08216049' => 'Sinzheim',
	'DE08216052' => 'Steinmauern',
	'DE08216059' => 'Weisenbach',
	'DE08216063' => 'Rheinmünster',
	'DE08221000' => 'Heidelberg, Stadt',
	'DE08222000' => 'Mannheim, Universitätsstadt',
	'DE08225001' => 'Adelsheim, Stadt',
	'DE08225002' => 'Aglasterhausen',
	'DE08225009' => 'Billigheim',
	'DE08225010' => 'Binau',
	'DE08225014' => 'Buchen (Odenwald), Stadt',
	'DE08225024' => 'Fahrenbach',
	'DE08225032' => 'Hardheim',
	'DE08225033' => 'Haßmersheim',
	'DE08225039' => 'Höpfingen',
	'DE08225042' => 'Hüffenhardt',
	'DE08225052' => 'Limbach',
	'DE08225058' => 'Mosbach, Stadt',
	'DE08225060' => 'Mudau',
	'DE08225064' => 'Neckargerach',
	'DE08225067' => 'Neckarzimmern',
	'DE08225068' => 'Neunkirchen',
	'DE08225074' => 'Obrigheim',
	'DE08225075' => 'Osterburken, Stadt',
	'DE08225082' => 'Rosenberg',
	'DE08225091' => 'Seckach',
	'DE08225109' => 'Walldürn, Stadt',
	'DE08225113' => 'Zwingenberg',
	'DE08225114' => 'Ravenstein, Stadt',
	'DE08225115' => 'Schefflenz',
	'DE08225116' => 'Schwarzach',
	'DE08225117' => 'Elztal',
	'DE08225118' => 'Waldbrunn',
	'DE08226003' => 'Altlußheim',
	'DE08226006' => 'Bammental',
	'DE08226009' => 'Brühl',
	'DE08226010' => 'Dielheim',
	'DE08226012' => 'Dossenheim',
	'DE08226013' => 'Eberbach, Stadt',
	'DE08226017' => 'Epfenbach',
	'DE08226018' => 'Eppelheim, Stadt',
	'DE08226020' => 'Eschelbronn',
	'DE08226022' => 'Gaiberg',
	'DE08226027' => 'Heddesbach',
	'DE08226028' => 'Heddesheim',
	'DE08226029' => 'Heiligkreuzsteinach',
	'DE08226031' => 'Hemsbach, Stadt',
	'DE08226032' => 'Hockenheim, Stadt',
	'DE08226036' => 'Ilvesheim',
	'DE08226037' => 'Ketsch',
	'DE08226038' => 'Ladenburg, Stadt',
	'DE08226040' => 'Laudenbach',
	'DE08226041' => 'Leimen, Stadt',
	'DE08226046' => 'Malsch',
	'DE08226048' => 'Mauer',
	'DE08226049' => 'Meckesheim',
	'DE08226054' => 'Mühlhausen',
	'DE08226055' => 'Neckarbischofsheim, Stadt',
	'DE08226056' => 'Neckargemünd, Stadt',
	'DE08226058' => 'Neidenstein',
	'DE08226059' => 'Neulußheim',
	'DE08226060' => 'Nußloch',
	'DE08226062' => 'Oftersheim',
	'DE08226063' => 'Plankstadt',
	'DE08226065' => 'Rauenberg, Stadt',
	'DE08226066' => 'Reichartshausen',
	'DE08226068' => 'Reilingen',
	'DE08226076' => 'Sandhausen',
	'DE08226080' => 'Schönau, Stadt',
	'DE08226081' => 'Schönbrunn',
	'DE08226082' => 'Schriesheim, Stadt',
	'DE08226084' => 'Schwetzingen, Stadt',
	'DE08226085' => 'Sinsheim, Stadt',
	'DE08226086' => 'Spechbach',
	'DE08226091' => 'Waibstadt, Stadt',
	'DE08226095' => 'Walldorf, Stadt',
	'DE08226096' => 'Weinheim, Stadt',
	'DE08226097' => 'Wiesenbach',
	'DE08226098' => 'Wiesloch, Stadt',
	'DE08226099' => 'Wilhelmsfeld',
	'DE08226101' => 'Zuzenhausen',
	'DE08226102' => 'Angelbachtal',
	'DE08226103' => 'St. Leon-Rot',
	'DE08226104' => 'Lobbach',
	'DE08226105' => 'Edingen-Neckarhausen',
	'DE08226106' => 'Helmstadt-Bargen',
	'DE08226107' => 'Hirschberg an der Bergstraße',
	'DE08231000' => 'Pforzheim, Stadt',
	'DE08235006' => 'Altensteig, Stadt',
	'DE08235007' => 'Althengstett',
	'DE08235008' => 'Bad Liebenzell, Stadt',
	'DE08235018' => 'Dobel',
	'DE08235020' => 'Ebhausen',
	'DE08235022' => 'Egenhausen',
	'DE08235025' => 'Enzklösterle',
	'DE08235029' => 'Gechingen',
	'DE08235032' => 'Haiterbach, Stadt',
	'DE08235033' => 'Bad Herrenalb, Stadt',
	'DE08235035' => 'Höfen an der Enz',
	'DE08235046' => 'Nagold, Stadt',
	'DE08235047' => 'Neubulach, Stadt',
	'DE08235050' => 'Neuweiler',
	'DE08235055' => 'Oberreichenbach',
	'DE08235057' => 'Ostelsheim',
	'DE08235060' => 'Rohrdorf',
	'DE08235065' => 'Schömberg',
	'DE08235066' => 'Simmersfeld',
	'DE08235067' => 'Simmozheim',
	'DE08235073' => 'Unterreichenbach',
	'DE08235079' => 'Bad Wildbad, Stadt',
	'DE08235080' => 'Wildberg, Stadt',
	'DE08235084' => 'Bad Teinach-Zavelstein, Stadt',
	'DE08235085' => 'Calw, Stadt',
	'DE08236004' => 'Birkenfeld',
	'DE08236011' => 'Eisingen',
	'DE08236013' => 'Engelsbrand',
	'DE08236019' => 'Friolzheim',
	'DE08236025' => 'Heimsheim, Stadt',
	'DE08236028' => 'Illingen',
	'DE08236030' => 'Ispringen',
	'DE08236031' => 'Kieselbronn',
	'DE08236033' => 'Knittlingen, Stadt',
	'DE08236038' => 'Maulbronn, Stadt',
	'DE08236039' => 'Mönsheim',
	'DE08236040' => 'Mühlacker, Stadt',
	'DE08236043' => 'Neuenbürg, Stadt',
	'DE08236044' => 'Neuhausen',
	'DE08236046' => 'Niefern-Öschelbronn',
	'DE08236050' => 'Ötisheim',
	'DE08236061' => 'Sternenfels',
	'DE08236062' => 'Tiefenbronn',
	'DE08236065' => 'Wiernsheim',
	'DE08236067' => 'Wimsheim',
	'DE08236068' => 'Wurmberg',
	'DE08236070' => 'Keltern',
	'DE08236071' => 'Remchingen',
	'DE08236072' => 'Straubenhardt',
	'DE08236073' => 'Neulingen',
	'DE08236074' => 'Kämpfelbach',
	'DE08236075' => 'Ölbronn-Dürrn',
	'DE08236076' => 'Königsbach-Stein',
	'DE08237002' => 'Alpirsbach, Stadt',
	'DE08237004' => 'Baiersbronn',
	'DE08237019' => 'Dornstetten, Stadt',
	'DE08237024' => 'Empfingen',
	'DE08237027' => 'Eutingen im Gäu',
	'DE08237028' => 'Freudenstadt, Stadt',
	'DE08237030' => 'Glatten',
	'DE08237032' => 'Grömbach',
	'DE08237040' => 'Horb am Neckar, Stadt',
	'DE08237045' => 'Loßburg',
	'DE08237054' => 'Pfalzgrafenweiler',
	'DE08237061' => 'Schopfloch',
	'DE08237072' => 'Wörnersberg',
	'DE08237073' => 'Seewald',
	'DE08237074' => 'Waldachtal',
	'DE08237075' => 'Bad Rippoldsau-Schapbach',
	'DE08311000' => 'Freiburg im Breisgau, Stadt',
	'DE08315003' => 'Au',
	'DE08315004' => 'Auggen',
	'DE08315006' => 'Bad Krozingen, Stadt',
	'DE08315007' => 'Badenweiler',
	'DE08315008' => 'Ballrechten-Dottingen',
	'DE08315013' => 'Bötzingen',
	'DE08315014' => 'Bollschweil',
	'DE08315015' => 'Breisach am Rhein, Stadt',
	'DE08315016' => 'Breitnau',
	'DE08315020' => 'Buchenbach',
	'DE08315022' => 'Buggingen',
	'DE08315028' => 'Ebringen',
	'DE08315030' => 'Eichstetten am Kaiserstuhl',
	'DE08315031' => 'Eisenbach (Hochschwarzwald)',
	'DE08315033' => 'Eschbach',
	'DE08315037' => 'Feldberg (Schwarzwald)',
	'DE08315039' => 'Friedenweiler',
	'DE08315041' => 'Glottertal',
	'DE08315043' => 'Gottenheim',
	'DE08315047' => 'Gundelfingen',
	'DE08315048' => 'Hartheim am Rhein',
	'DE08315050' => 'Heitersheim, Stadt',
	'DE08315051' => 'Heuweiler',
	'DE08315052' => 'Hinterzarten',
	'DE08315056' => 'Horben',
	'DE08315059' => 'Ihringen',
	'DE08315064' => 'Kirchzarten',
	'DE08315068' => 'Lenzkirch',
	'DE08315070' => 'Löffingen, Stadt',
	'DE08315072' => 'Merdingen',
	'DE08315073' => 'Merzhausen',
	'DE08315074' => 'Müllheim, Stadt',
	'DE08315076' => 'Neuenburg am Rhein, Stadt',
	'DE08315084' => 'Oberried',
	'DE08315089' => 'Pfaffenweiler',
	'DE08315094' => 'St. Märgen',
	'DE08315095' => 'St. Peter',
	'DE08315098' => 'Schallstadt',
	'DE08315102' => 'Schluchsee',
	'DE08315107' => 'Sölden',
	'DE08315108' => 'Staufen im Breisgau, Stadt',
	'DE08315109' => 'Stegen',
	'DE08315111' => 'Sulzburg, Stadt',
	'DE08315113' => 'Titisee-Neustadt, Stadt',
	'DE08315115' => 'Umkirch',
	'DE08315125' => 'Wittnau',
	'DE08315130' => 'Münstertal/Schwarzwald',
	'DE08315131' => 'Ehrenkirchen',
	'DE08315132' => 'March',
	'DE08315133' => 'Vogtsburg im Kaiserstuhl, Stadt',
	'DE08316002' => 'Bahlingen am Kaiserstuhl',
	'DE08316003' => 'Biederbach',
	'DE08316009' => 'Denzlingen',
	'DE08316010' => 'Elzach, Stadt',
	'DE08316011' => 'Emmendingen, Stadt',
	'DE08316012' => 'Endingen am Kaiserstuhl, Stadt',
	'DE08316013' => 'Forchheim',
	'DE08316014' => 'Gutach im Breisgau',
	'DE08316017' => 'Herbolzheim, Stadt',
	'DE08316020' => 'Kenzingen, Stadt',
	'DE08316024' => 'Malterdingen',
	'DE08316036' => 'Reute',
	'DE08316037' => 'Riegel am Kaiserstuhl',
	'DE08316038' => 'Sasbach am Kaiserstuhl',
	'DE08316039' => 'Sexau',
	'DE08316042' => 'Simonswald',
	'DE08316043' => 'Teningen',
	'DE08316045' => 'Vörstetten',
	'DE08316049' => 'Weisweil',
	'DE08316051' => 'Wyhl am Kaiserstuhl',
	'DE08316053' => 'Rheinhausen',
	'DE08316054' => 'Freiamt',
	'DE08316055' => 'Winden im Elztal',
	'DE08316056' => 'Waldkirch, Stadt',
	'DE08317001' => 'Achern, Stadt',
	'DE08317005' => 'Appenweier',
	'DE08317008' => 'Bad Peterstal-Griesbach',
	'DE08317009' => 'Berghaupten',
	'DE08317011' => 'Biberach',
	'DE08317021' => 'Durbach',
	'DE08317026' => 'Ettenheim, Stadt',
	'DE08317029' => 'Fischerbach',
	'DE08317031' => 'Friesenheim',
	'DE08317034' => 'Gengenbach, Stadt',
	'DE08317039' => 'Gutach (Schwarzwaldbahn)',
	'DE08317040' => 'Haslach im Kinzigtal, Stadt',
	'DE08317041' => 'Hausach, Stadt',
	'DE08317046' => 'Hofstetten',
	'DE08317047' => 'Hohberg',
	'DE08317051' => 'Hornberg, Stadt',
	'DE08317056' => 'Kappelrodeck',
	'DE08317057' => 'Kehl, Stadt',
	'DE08317059' => 'Kippenheim',
	'DE08317065' => 'Lahr/Schwarzwald, Stadt',
	'DE08317067' => 'Lautenbach',
	'DE08317068' => 'Lauf',
	'DE08317073' => 'Mahlberg, Stadt',
	'DE08317075' => 'Meißenheim',
	'DE08317078' => 'Mühlenbach',
	'DE08317085' => 'Nordrach',
	'DE08317088' => 'Oberharmersbach',
	'DE08317089' => 'Oberkirch, Stadt',
	'DE08317093' => 'Oberwolfach',
	'DE08317096' => 'Offenburg, Stadt',
	'DE08317097' => 'Ohlsbach',
	'DE08317098' => 'Oppenau, Stadt',
	'DE08317100' => 'Ortenberg',
	'DE08317102' => 'Ottenhöfen im Schwarzwald',
	'DE08317110' => 'Renchen, Stadt',
	'DE08317113' => 'Ringsheim',
	'DE08317114' => 'Rust',
	'DE08317116' => 'Sasbach',
	'DE08317118' => 'Sasbachwalden',
	'DE08317121' => 'Schuttertal',
	'DE08317122' => 'Schutterwald',
	'DE08317126' => 'Seebach',
	'DE08317127' => 'Seelbach',
	'DE08317129' => 'Steinach',
	'DE08317141' => 'Willstätt',
	'DE08317145' => 'Wolfach, Stadt',
	'DE08317146' => 'Zell am Harmersbach, Stadt',
	'DE08317150' => 'Schwanau',
	'DE08317151' => 'Neuried',
	'DE08317152' => 'Kappel-Grafenhausen',
	'DE08317153' => 'Rheinau, Stadt',
	'DE08317971' => 'Rheinau, gemeindefreies Gebiet',
	'DE08325001' => 'Aichhalden',
	'DE08325009' => 'Bösingen',
	'DE08325011' => 'Dietingen',
	'DE08325012' => 'Dornhan, Stadt',
	'DE08325014' => 'Dunningen',
	'DE08325015' => 'Epfendorf',
	'DE08325024' => 'Hardt',
	'DE08325036' => 'Lauterbach',
	'DE08325045' => 'Oberndorf am Neckar, Stadt',
	'DE08325049' => 'Rottweil, Stadt',
	'DE08325050' => 'Schenkenzell',
	'DE08325051' => 'Schiltach, Stadt',
	'DE08325053' => 'Schramberg, Stadt',
	'DE08325057' => 'Sulz am Neckar, Stadt',
	'DE08325060' => 'Villingendorf',
	'DE08325061' => 'Vöhringen',
	'DE08325064' => 'Wellendingen',
	'DE08325069' => 'Zimmern ob Rottweil',
	'DE08325070' => 'Fluorn-Winzeln',
	'DE08325071' => 'Eschbronn',
	'DE08325072' => 'Deißlingen',
	'DE08326003' => 'Bad Dürrheim, Stadt',
	'DE08326005' => 'Blumberg, Stadt',
	'DE08326006' => 'Bräunlingen, Stadt',
	'DE08326010' => 'Dauchingen',
	'DE08326012' => 'Donaueschingen, Stadt',
	'DE08326017' => 'Furtwangen im Schwarzwald, Stadt',
	'DE08326020' => 'Gütenbach',
	'DE08326027' => 'Hüfingen, Stadt',
	'DE08326031' => 'Königsfeld im Schwarzwald',
	'DE08326037' => 'Mönchweiler',
	'DE08326041' => 'Niedereschach',
	'DE08326052' => 'St. Georgen im Schwarzwald, Stadt',
	'DE08326054' => 'Schönwald im Schwarzwald',
	'DE08326055' => 'Schonach im Schwarzwald',
	'DE08326060' => 'Triberg im Schwarzwald, Stadt',
	'DE08326061' => 'Tuningen',
	'DE08326065' => 'Unterkirnach',
	'DE08326068' => 'Vöhrenbach, Stadt',
	'DE08326074' => 'Villingen-Schwenningen, Stadt',
	'DE08326075' => 'Brigachtal',
	'DE08327002' => 'Aldingen',
	'DE08327004' => 'Bärenthal',
	'DE08327005' => 'Balgheim',
	'DE08327006' => 'Böttingen',
	'DE08327007' => 'Bubsheim',
	'DE08327008' => 'Buchheim',
	'DE08327009' => 'Deilingen',
	'DE08327010' => 'Denkingen',
	'DE08327011' => 'Dürbheim',
	'DE08327012' => 'Durchhausen',
	'DE08327013' => 'Egesheim',
	'DE08327016' => 'Fridingen an der Donau, Stadt',
	'DE08327017' => 'Frittlingen',
	'DE08327018' => 'Geisingen, Stadt',
	'DE08327019' => 'Gosheim',
	'DE08327020' => 'Gunningen',
	'DE08327023' => 'Hausen ob Verena',
	'DE08327025' => 'Immendingen',
	'DE08327027' => 'Irndorf',
	'DE08327029' => 'Königsheim',
	'DE08327030' => 'Kolbingen',
	'DE08327033' => 'Mahlstetten',
	'DE08327036' => 'Mühlheim an der Donau, Stadt',
	'DE08327038' => 'Neuhausen ob Eck',
	'DE08327040' => 'Reichenbach am Heuberg',
	'DE08327041' => 'Renquishausen',
	'DE08327046' => 'Spaichingen, Stadt',
	'DE08327048' => 'Talheim',
	'DE08327049' => 'Trossingen, Stadt',
	'DE08327050' => 'Tuttlingen, Stadt',
	'DE08327051' => 'Wehingen',
	'DE08327054' => 'Wurmlingen',
	'DE08327055' => 'Seitingen-Oberflacht',
	'DE08327056' => 'Rietheim-Weilheim',
	'DE08327057' => 'Emmingen-Liptingen',
	'DE08335001' => 'Aach, Stadt',
	'DE08335002' => 'Allensbach',
	'DE08335015' => 'Büsingen am Hochrhein',
	'DE08335021' => 'Eigeltingen',
	'DE08335022' => 'Engen, Stadt',
	'DE08335025' => 'Gaienhofen',
	'DE08335026' => 'Gailingen am Hochrhein',
	'DE08335028' => 'Gottmadingen',
	'DE08335035' => 'Hilzingen',
	'DE08335043' => 'Konstanz, Universitätsstadt',
	'DE08335055' => 'Moos',
	'DE08335057' => 'Mühlingen',
	'DE08335061' => 'Öhningen',
	'DE08335063' => 'Radolfzell am Bodensee, Stadt',
	'DE08335066' => 'Reichenau',
	'DE08335075' => 'Singen (Hohentwiel), Stadt',
	'DE08335077' => 'Steißlingen',
	'DE08335079' => 'Stockach, Stadt',
	'DE08335080' => 'Tengen, Stadt',
	'DE08335081' => 'Volkertshausen',
	'DE08335096' => 'Hohenfels',
	'DE08335097' => 'Mühlhausen-Ehingen',
	'DE08335098' => 'Bodman-Ludwigshafen',
	'DE08335099' => 'Orsingen-Nenzingen',
	'DE08335100' => 'Rielasingen-Worblingen',
	'DE08336004' => 'Aitern',
	'DE08336006' => 'Bad Bellingen',
	'DE08336008' => 'Binzen',
	'DE08336010' => 'Böllen',
	'DE08336014' => 'Efringen-Kirchen',
	'DE08336019' => 'Eimeldingen',
	'DE08336024' => 'Fischingen',
	'DE08336025' => 'Fröhnd',
	'DE08336034' => 'Hasel',
	'DE08336036' => 'Hausen im Wiesental',
	'DE08336043' => 'Inzlingen',
	'DE08336045' => 'Kandern, Stadt',
	'DE08336050' => 'Lörrach, Stadt',
	'DE08336057' => 'Maulburg',
	'DE08336069' => 'Rheinfelden (Baden), Stadt',
	'DE08336073' => 'Rümmingen',
	'DE08336075' => 'Schallbach',
	'DE08336078' => 'Schliengen',
	'DE08336079' => 'Schönau im Schwarzwald, Stadt',
	'DE08336080' => 'Schönenberg',
	'DE08336081' => 'Schopfheim, Stadt',
	'DE08336082' => 'Schwörstadt',
	'DE08336084' => 'Steinen',
	'DE08336087' => 'Todtnau, Stadt',
	'DE08336089' => 'Tunau',
	'DE08336090' => 'Utzenfeld',
	'DE08336091' => 'Weil am Rhein, Stadt',
	'DE08336094' => 'Wembach',
	'DE08336096' => 'Wieden',
	'DE08336100' => 'Wittlingen',
	'DE08336103' => 'Zell im Wiesental, Stadt',
	'DE08336104' => 'Malsburg-Marzell',
	'DE08336105' => 'Grenzach-Wyhlen',
	'DE08336106' => 'Häg-Ehrsberg',
	'DE08336107' => 'Kleines Wiesental',
	'DE08337002' => 'Albbruck',
	'DE08337013' => 'Bernau im Schwarzwald',
	'DE08337022' => 'Bonndorf im Schwarzwald, Stadt',
	'DE08337027' => 'Dachsberg (Südschwarzwald)',
	'DE08337030' => 'Dettighofen',
	'DE08337032' => 'Dogern',
	'DE08337038' => 'Görwihl',
	'DE08337039' => 'Grafenhausen',
	'DE08337045' => 'Häusern',
	'DE08337049' => 'Herrischried',
	'DE08337051' => 'Höchenschwand',
	'DE08337053' => 'Hohentengen am Hochrhein',
	'DE08337059' => 'Ibach',
	'DE08337060' => 'Jestetten',
	'DE08337062' => 'Klettgau',
	'DE08337065' => 'Lauchringen',
	'DE08337066' => 'Laufenburg (Baden), Stadt',
	'DE08337070' => 'Lottstetten',
	'DE08337076' => 'Murg',
	'DE08337090' => 'Rickenbach',
	'DE08337096' => 'Bad Säckingen, Stadt',
	'DE08337097' => 'St. Blasien, Stadt',
	'DE08337106' => 'Stühlingen, Stadt',
	'DE08337108' => 'Todtmoos',
	'DE08337116' => 'Wehr, Stadt',
	'DE08337118' => 'Weilheim',
	'DE08337123' => 'Wutöschingen',
	'DE08337124' => 'Eggingen',
	'DE08337125' => 'Küssaberg',
	'DE08337126' => 'Waldshut-Tiengen, Stadt',
	'DE08337127' => 'Wutach',
	'DE08337128' => 'Ühlingen-Birkendorf',
	'DE08415014' => 'Dettingen an der Erms',
	'DE08415019' => 'Eningen unter Achalm',
	'DE08415027' => 'Gomadingen',
	'DE08415028' => 'Grabenstetten',
	'DE08415029' => 'Grafenberg',
	'DE08415034' => 'Hayingen, Stadt',
	'DE08415039' => 'Hülben',
	'DE08415048' => 'Mehrstetten',
	'DE08415050' => 'Metzingen, Stadt',
	'DE08415053' => 'Münsingen, Stadt',
	'DE08415058' => 'Pfronstetten',
	'DE08415059' => 'Pfullingen, Stadt',
	'DE08415060' => 'Pliezhausen',
	'DE08415061' => 'Reutlingen, Stadt',
	'DE08415062' => 'Riederich',
	'DE08415073' => 'Trochtelfingen, Stadt',
	'DE08415078' => 'Bad Urach, Stadt',
	'DE08415080' => 'Wannweil',
	'DE08415085' => 'Zwiefalten',
	'DE08415087' => 'Walddorfhäslach',
	'DE08415088' => 'Römerstein',
	'DE08415089' => 'Engstingen',
	'DE08415090' => 'Hohenstein',
	'DE08415091' => 'Sonnenbühl',
	'DE08415092' => 'Lichtenstein',
	'DE08415093' => 'St. Johann',
	'DE08415971' => 'Gutsbezirk Münsingen, gemeindefreies Gebiet',
	'DE08416006' => 'Bodelshausen',
	'DE08416009' => 'Dettenhausen',
	'DE08416011' => 'Dußlingen',
	'DE08416015' => 'Gomaringen',
	'DE08416018' => 'Hirrlingen',
	'DE08416022' => 'Kirchentellinsfurt',
	'DE08416023' => 'Kusterdingen',
	'DE08416025' => 'Mössingen, Stadt',
	'DE08416026' => 'Nehren',
	'DE08416031' => 'Ofterdingen',
	'DE08416036' => 'Rottenburg am Neckar, Stadt',
	'DE08416041' => 'Tübingen, Universitätsstadt',
	'DE08416048' => 'Ammerbuch',
	'DE08416049' => 'Neustetten',
	'DE08416050' => 'Starzach',
	'DE08417002' => 'Balingen, Stadt',
	'DE08417008' => 'Bisingen',
	'DE08417010' => 'Bitz',
	'DE08417013' => 'Burladingen, Stadt',
	'DE08417014' => 'Dautmergen',
	'DE08417015' => 'Dormettingen',
	'DE08417016' => 'Dotternhausen',
	'DE08417022' => 'Geislingen, Stadt',
	'DE08417023' => 'Grosselfingen',
	'DE08417025' => 'Haigerloch, Stadt',
	'DE08417029' => 'Hausen am Tann',
	'DE08417031' => 'Hechingen, Stadt',
	'DE08417036' => 'Jungingen',
	'DE08417044' => 'Meßstetten, Stadt',
	'DE08417045' => 'Nusplingen',
	'DE08417047' => 'Obernheim',
	'DE08417051' => 'Rangendingen',
	'DE08417052' => 'Ratshausen',
	'DE08417054' => 'Rosenfeld, Stadt',
	'DE08417057' => 'Schömberg, Stadt',
	'DE08417063' => 'Straßberg',
	'DE08417071' => 'Weilen unter den Rinnen',
	'DE08417075' => 'Winterlingen',
	'DE08417078' => 'Zimmern unter der Burg',
	'DE08417079' => 'Albstadt, Stadt',
	'DE08421000' => 'Ulm, Universitätsstadt',
	'DE08425002' => 'Allmendingen',
	'DE08425004' => 'Altheim',
	'DE08425005' => 'Altheim (Alb)',
	'DE08425008' => 'Amstetten',
	'DE08425011' => 'Asselfingen',
	'DE08425013' => 'Ballendorf',
	'DE08425014' => 'Beimerstetten',
	'DE08425017' => 'Berghülen',
	'DE08425019' => 'Bernstadt',
	'DE08425020' => 'Blaubeuren, Stadt',
	'DE08425022' => 'Börslingen',
	'DE08425024' => 'Breitingen',
	'DE08425028' => 'Dietenheim, Stadt',
	'DE08425031' => 'Dornstadt',
	'DE08425033' => 'Ehingen (Donau), Stadt',
	'DE08425035' => 'Emeringen',
	'DE08425036' => 'Emerkingen',
	'DE08425039' => 'Erbach, Stadt',
	'DE08425050' => 'Griesingen',
	'DE08425052' => 'Grundsheim',
	'DE08425055' => 'Hausen am Bussen',
	'DE08425062' => 'Holzkirch',
	'DE08425064' => 'Hüttisheim',
	'DE08425066' => 'Illerrieden',
	'DE08425071' => 'Laichingen, Stadt',
	'DE08425072' => 'Langenau, Stadt',
	'DE08425073' => 'Lauterach',
	'DE08425075' => 'Lonsee',
	'DE08425079' => 'Merklingen',
	'DE08425081' => 'Munderkingen, Stadt',
	'DE08425083' => 'Neenstetten',
	'DE08425084' => 'Nellingen',
	'DE08425085' => 'Nerenstetten',
	'DE08425088' => 'Oberdischingen',
	'DE08425090' => 'Obermarchtal',
	'DE08425091' => 'Oberstadion',
	'DE08425092' => 'Öllingen',
	'DE08425093' => 'Öpfingen',
	'DE08425097' => 'Rammingen',
	'DE08425098' => 'Rechtenstein',
	'DE08425104' => 'Rottenacker',
	'DE08425108' => 'Schelklingen, Stadt',
	'DE08425110' => 'Schnürpflingen',
	'DE08425112' => 'Setzingen',
	'DE08425123' => 'Untermarchtal',
	'DE08425124' => 'Unterstadion',
	'DE08425125' => 'Unterwachingen',
	'DE08425130' => 'Weidenstetten',
	'DE08425134' => 'Westerheim',
	'DE08425135' => 'Westerstetten',
	'DE08425137' => 'Illerkirchberg',
	'DE08425138' => 'Staig',
	'DE08425139' => 'Heroldstatt',
	'DE08425140' => 'Balzheim',
	'DE08425141' => 'Blaustein, Stadt',
	'DE08426001' => 'Achstetten',
	'DE08426005' => 'Alleshausen',
	'DE08426006' => 'Allmannsweiler',
	'DE08426008' => 'Altheim',
	'DE08426011' => 'Attenweiler',
	'DE08426013' => 'Bad Buchau, Stadt',
	'DE08426014' => 'Bad Schussenried, Stadt',
	'DE08426019' => 'Berkheim',
	'DE08426020' => 'Betzenweiler',
	'DE08426021' => 'Biberach an der Riß, Stadt',
	'DE08426028' => 'Burgrieden',
	'DE08426031' => 'Dettingen an der Iller',
	'DE08426035' => 'Dürmentingen',
	'DE08426036' => 'Dürnau',
	'DE08426038' => 'Eberhardzell',
	'DE08426043' => 'Erlenmoos',
	'DE08426044' => 'Erolzheim',
	'DE08426045' => 'Ertingen',
	'DE08426058' => 'Hochdorf',
	'DE08426062' => 'Ingoldingen',
	'DE08426064' => 'Kanzach',
	'DE08426065' => 'Kirchberg an der Iller',
	'DE08426066' => 'Kirchdorf an der Iller',
	'DE08426067' => 'Langenenslingen',
	'DE08426070' => 'Laupheim, Stadt',
	'DE08426071' => 'Maselheim',
	'DE08426073' => 'Mietingen',
	'DE08426074' => 'Mittelbiberach',
	'DE08426078' => 'Moosburg',
	'DE08426087' => 'Ochsenhausen, Stadt',
	'DE08426090' => 'Oggelshausen',
	'DE08426097' => 'Riedlingen, Stadt',
	'DE08426100' => 'Rot an der Rot',
	'DE08426108' => 'Schwendi',
	'DE08426109' => 'Seekirch',
	'DE08426113' => 'Steinhausen an der Rottum',
	'DE08426117' => 'Tannheim',
	'DE08426118' => 'Tiefenbach',
	'DE08426120' => 'Ummendorf',
	'DE08426121' => 'Unlingen',
	'DE08426124' => 'Uttenweiler',
	'DE08426125' => 'Wain',
	'DE08426128' => 'Warthausen',
	'DE08426134' => 'Schemmerhofen',
	'DE08426135' => 'Gutenzell-Hürbel',
	'DE08435005' => 'Bermatingen',
	'DE08435010' => 'Daisendorf',
	'DE08435013' => 'Eriskirch',
	'DE08435015' => 'Frickingen',
	'DE08435016' => 'Friedrichshafen, Stadt',
	'DE08435018' => 'Hagnau am Bodensee',
	'DE08435020' => 'Heiligenberg',
	'DE08435024' => 'Immenstaad am Bodensee',
	'DE08435029' => 'Kressbronn am Bodensee',
	'DE08435030' => 'Langenargen',
	'DE08435034' => 'Markdorf, Stadt',
	'DE08435035' => 'Meckenbeuren',
	'DE08435036' => 'Meersburg, Stadt',
	'DE08435042' => 'Neukirch',
	'DE08435045' => 'Oberteuringen',
	'DE08435047' => 'Owingen',
	'DE08435052' => 'Salem',
	'DE08435053' => 'Sipplingen',
	'DE08435054' => 'Stetten',
	'DE08435057' => 'Tettnang, Stadt',
	'DE08435059' => 'Überlingen, Stadt',
	'DE08435066' => 'Uhldingen-Mühlhofen',
	'DE08435067' => 'Deggenhausertal',
	'DE08436001' => 'Achberg',
	'DE08436003' => 'Aichstetten',
	'DE08436004' => 'Aitrach',
	'DE08436005' => 'Altshausen',
	'DE08436006' => 'Amtzell',
	'DE08436008' => 'Aulendorf, Stadt',
	'DE08436009' => 'Bad Waldsee, Stadt',
	'DE08436010' => 'Bad Wurzach, Stadt',
	'DE08436011' => 'Baienfurt',
	'DE08436012' => 'Baindt',
	'DE08436013' => 'Berg',
	'DE08436014' => 'Bergatreute',
	'DE08436018' => 'Bodnegg',
	'DE08436019' => 'Boms',
	'DE08436024' => 'Ebenweiler',
	'DE08436027' => 'Eichstegen',
	'DE08436032' => 'Fleischwangen',
	'DE08436039' => 'Grünkraut',
	'DE08436040' => 'Guggenhausen',
	'DE08436047' => 'Hoßkirch',
	'DE08436049' => 'Isny im Allgäu, Stadt',
	'DE08436052' => 'Kißlegg',
	'DE08436053' => 'Königseggwald',
	'DE08436055' => 'Leutkirch im Allgäu, Stadt',
	'DE08436064' => 'Ravensburg, Stadt',
	'DE08436067' => 'Riedhausen',
	'DE08436069' => 'Schlier',
	'DE08436077' => 'Unterwaldhausen',
	'DE08436078' => 'Vogt',
	'DE08436079' => 'Waldburg',
	'DE08436081' => 'Wangen im Allgäu, Stadt',
	'DE08436082' => 'Weingarten, Stadt',
	'DE08436083' => 'Wilhelmsdorf',
	'DE08436085' => 'Wolfegg',
	'DE08436087' => 'Wolpertswende',
	'DE08436093' => 'Ebersbach-Musbach',
	'DE08436094' => 'Argenbühl',
	'DE08436095' => 'Horgenzell',
	'DE08436096' => 'Fronreute',
	'DE08437005' => 'Beuron',
	'DE08437008' => 'Bingen',
	'DE08437031' => 'Gammertingen, Stadt',
	'DE08437044' => 'Herbertingen',
	'DE08437047' => 'Hettingen, Stadt',
	'DE08437053' => 'Hohentengen',
	'DE08437056' => 'Illmensee',
	'DE08437059' => 'Inzigkofen',
	'DE08437065' => 'Krauchenwies',
	'DE08437072' => 'Leibertingen',
	'DE08437076' => 'Mengen, Stadt',
	'DE08437078' => 'Meßkirch, Stadt',
	'DE08437082' => 'Neufra',
	'DE08437086' => 'Ostrach',
	'DE08437088' => 'Pfullendorf, Stadt',
	'DE08437100' => 'Bad Saulgau, Stadt',
	'DE08437101' => 'Scheer, Stadt',
	'DE08437102' => 'Schwenningen',
	'DE08437104' => 'Sigmaringen, Stadt',
	'DE08437105' => 'Sigmaringendorf',
	'DE08437107' => 'Stetten am kalten Markt',
	'DE08437114' => 'Veringenstadt, Stadt',
	'DE08437118' => 'Wald',
	'DE08437123' => 'Sauldorf',
	'DE08437124' => 'Herdwangen-Schönach',
	'DE09161000' => 'Ingolstadt',
	'DE09162000' => 'München, Landeshauptstadt',
	'DE09163000' => 'Rosenheim',
	'DE09171111' => 'Altötting, St',
	'DE09171112' => 'Burghausen, St',
	'DE09171113' => 'Burgkirchen a.d.Alz',
	'DE09171114' => 'Emmerting',
	'DE09171115' => 'Erlbach',
	'DE09171116' => 'Feichten a.d.Alz',
	'DE09171117' => 'Garching a.d.Alz',
	'DE09171118' => 'Haiming',
	'DE09171119' => 'Halsbach',
	'DE09171121' => 'Kastl',
	'DE09171122' => 'Kirchweidach',
	'DE09171123' => 'Marktl, M',
	'DE09171124' => 'Mehring',
	'DE09171125' => 'Neuötting, St',
	'DE09171126' => 'Perach',
	'DE09171127' => 'Pleiskirchen',
	'DE09171129' => 'Reischach',
	'DE09171130' => 'Stammham',
	'DE09171131' => 'Teising',
	'DE09171132' => 'Töging a.Inn, St',
	'DE09171133' => 'Tüßling, M',
	'DE09171134' => 'Tyrlaching',
	'DE09171135' => 'Unterneukirchen',
	'DE09171137' => 'Winhöring',
	'DE09172111' => 'Ainring',
	'DE09172112' => 'Anger',
	'DE09172114' => 'Bad Reichenhall, GKSt',
	'DE09172115' => 'Bayerisch Gmain',
	'DE09172116' => 'Berchtesgaden, M',
	'DE09172117' => 'Bischofswiesen',
	'DE09172118' => 'Freilassing, St',
	'DE09172122' => 'Laufen, St',
	'DE09172124' => 'Marktschellenberg, M',
	'DE09172128' => 'Piding',
	'DE09172129' => 'Ramsau b.Berchtesgaden',
	'DE09172130' => 'Saaldorf-Surheim',
	'DE09172131' => 'Schneizlreuth',
	'DE09172132' => 'Schönau a.Königssee',
	'DE09172134' => 'Teisendorf, M',
	'DE09172444' => 'Gdefr. Geb. (Lkr Berchtesgadener Land)',
	'DE09173111' => 'Bad Heilbrunn',
	'DE09173112' => 'Bad Tölz, St',
	'DE09173113' => 'Benediktbeuern',
	'DE09173115' => 'Bichl',
	'DE09173118' => 'Dietramszell',
	'DE09173120' => 'Egling',
	'DE09173123' => 'Eurasburg',
	'DE09173124' => 'Gaißach',
	'DE09173126' => 'Geretsried, St',
	'DE09173127' => 'Greiling',
	'DE09173130' => 'Icking',
	'DE09173131' => 'Jachenau',
	'DE09173133' => 'Kochel a.See',
	'DE09173134' => 'Königsdorf',
	'DE09173135' => 'Lenggries',
	'DE09173137' => 'Münsing',
	'DE09173140' => 'Reichersbeuern',
	'DE09173141' => 'Sachsenkam',
	'DE09173142' => 'Schlehdorf',
	'DE09173145' => 'Wackersberg',
	'DE09173147' => 'Wolfratshausen, St',
	'DE09173444' => 'Gdefr. Geb. (Lkr Bad Tölz-Wolfratshausen)',
	'DE09174111' => 'Altomünster, M',
	'DE09174113' => 'Bergkirchen',
	'DE09174115' => 'Dachau, GKSt',
	'DE09174118' => 'Erdweg',
	'DE09174121' => 'Haimhausen',
	'DE09174122' => 'Hebertshausen',
	'DE09174126' => 'Karlsfeld',
	'DE09174131' => 'Markt Indersdorf, M',
	'DE09174135' => 'Odelzhausen',
	'DE09174136' => 'Petershausen',
	'DE09174137' => 'Pfaffenhofen a.d.Glonn',
	'DE09174141' => 'Röhrmoos',
	'DE09174143' => 'Schwabhausen',
	'DE09174146' => 'Sulzemoos',
	'DE09174147' => 'Hilgertshausen-Tandern',
	'DE09174150' => 'Vierkirchen',
	'DE09174151' => 'Weichs',
	'DE09175111' => 'Anzing',
	'DE09175112' => 'Aßling',
	'DE09175113' => 'Baiern',
	'DE09175114' => 'Bruck',
	'DE09175115' => 'Ebersberg, St',
	'DE09175116' => 'Egmating',
	'DE09175118' => 'Forstinning',
	'DE09175119' => 'Frauenneuharting',
	'DE09175121' => 'Glonn, M',
	'DE09175122' => 'Grafing b.München, St',
	'DE09175123' => 'Hohenlinden',
	'DE09175124' => 'Kirchseeon, M',
	'DE09175127' => 'Markt Schwaben, M',
	'DE09175128' => 'Moosach',
	'DE09175131' => 'Oberpframmern',
	'DE09175132' => 'Vaterstetten',
	'DE09175133' => 'Pliening',
	'DE09175135' => 'Poing',
	'DE09175136' => 'Emmering',
	'DE09175137' => 'Steinhöring',
	'DE09175139' => 'Zorneding',
	'DE09175444' => 'Gdefr. Geb. (Lkr Ebersberg)',
	'DE09176111' => 'Adelschlag',
	'DE09176112' => 'Altmannstein, M',
	'DE09176114' => 'Beilngries, St',
	'DE09176116' => 'Böhmfeld',
	'DE09176118' => 'Buxheim',
	'DE09176120' => 'Denkendorf',
	'DE09176121' => 'Dollnstein, M',
	'DE09176122' => 'Egweil',
	'DE09176123' => 'Eichstätt, GKSt',
	'DE09176124' => 'Eitensheim',
	'DE09176126' => 'Gaimersheim, M',
	'DE09176129' => 'Großmehring',
	'DE09176131' => 'Hepberg',
	'DE09176132' => 'Hitzhofen',
	'DE09176137' => 'Kinding, M',
	'DE09176138' => 'Kipfenberg, M',
	'DE09176139' => 'Kösching, M',
	'DE09176143' => 'Lenting',
	'DE09176147' => 'Mindelstetten',
	'DE09176148' => 'Mörnsheim, M',
	'DE09176149' => 'Nassenfels, M',
	'DE09176150' => 'Oberdolling',
	'DE09176153' => 'Pförring, M',
	'DE09176155' => 'Pollenfeld',
	'DE09176160' => 'Schernfeld',
	'DE09176161' => 'Stammham',
	'DE09176164' => 'Titting, M',
	'DE09176165' => 'Walting',
	'DE09176166' => 'Wellheim, M',
	'DE09176167' => 'Wettstetten',
	'DE09176444' => 'Gdefr. Geb. (Lkr Eichstätt)',
	'DE09177112' => 'Berglern',
	'DE09177113' => 'Bockhorn',
	'DE09177114' => 'Buch a.Buchrain',
	'DE09177115' => 'Dorfen, St',
	'DE09177116' => 'Eitting',
	'DE09177117' => 'Erding, GKSt',
	'DE09177118' => 'Finsing',
	'DE09177119' => 'Forstern',
	'DE09177120' => 'Fraunberg',
	'DE09177121' => 'Hohenpolding',
	'DE09177122' => 'Inning a.Holz',
	'DE09177123' => 'Isen, M',
	'DE09177124' => 'Kirchberg',
	'DE09177126' => 'Langenpreising',
	'DE09177127' => 'Lengdorf',
	'DE09177130' => 'Moosinning',
	'DE09177131' => 'Neuching',
	'DE09177133' => 'Oberding',
	'DE09177134' => 'Ottenhofen',
	'DE09177135' => 'Pastetten',
	'DE09177137' => 'Sankt Wolfgang',
	'DE09177138' => 'Steinkirchen',
	'DE09177139' => 'Taufkirchen (Vils)',
	'DE09177142' => 'Walpertskirchen',
	'DE09177143' => 'Wartenberg, M',
	'DE09177144' => 'Wörth',
	'DE09178113' => 'Allershausen',
	'DE09178115' => 'Attenkirchen',
	'DE09178116' => 'Au i.d.Hallertau, M',
	'DE09178120' => 'Eching',
	'DE09178122' => 'Rudelzhausen',
	'DE09178123' => 'Fahrenzhausen',
	'DE09178124' => 'Freising, GKSt',
	'DE09178125' => 'Gammelsdorf',
	'DE09178129' => 'Haag a.d.Amper',
	'DE09178130' => 'Hallbergmoos',
	'DE09178132' => 'Hörgertshausen',
	'DE09178133' => 'Hohenkammer',
	'DE09178136' => 'Kirchdorf a.d.Amper',
	'DE09178137' => 'Kranzberg',
	'DE09178138' => 'Langenbach',
	'DE09178140' => 'Marzling',
	'DE09178142' => 'Mauern',
	'DE09178143' => 'Moosburg a.d.Isar, St',
	'DE09178144' => 'Nandlstadt, M',
	'DE09178145' => 'Neufahrn b.Freising',
	'DE09178150' => 'Paunzhausen',
	'DE09178155' => 'Wang',
	'DE09178156' => 'Wolfersdorf',
	'DE09178157' => 'Zolling',
	'DE09179111' => 'Adelshofen',
	'DE09179113' => 'Alling',
	'DE09179114' => 'Althegnenberg',
	'DE09179117' => 'Egenhofen',
	'DE09179118' => 'Eichenau',
	'DE09179119' => 'Emmering',
	'DE09179121' => 'Fürstenfeldbruck, GKSt',
	'DE09179123' => 'Germering, GKSt',
	'DE09179125' => 'Grafrath',
	'DE09179126' => 'Gröbenzell',
	'DE09179128' => 'Hattenhofen',
	'DE09179130' => 'Jesenwang',
	'DE09179131' => 'Kottgeisering',
	'DE09179132' => 'Landsberied',
	'DE09179134' => 'Maisach',
	'DE09179136' => 'Mammendorf',
	'DE09179137' => 'Mittelstetten',
	'DE09179138' => 'Moorenweis',
	'DE09179140' => 'Oberschweinbach',
	'DE09179142' => 'Olching, St',
	'DE09179145' => 'Puchheim, St',
	'DE09179147' => 'Schöngeising',
	'DE09179149' => 'Türkenfeld',
	'DE09180112' => 'Bad Kohlgrub',
	'DE09180113' => 'Bad Bayersoien',
	'DE09180114' => 'Eschenlohe',
	'DE09180115' => 'Ettal',
	'DE09180116' => 'Farchant',
	'DE09180117' => 'Garmisch-Partenkirchen, M',
	'DE09180118' => 'Grainau',
	'DE09180119' => 'Großweil',
	'DE09180122' => 'Krün',
	'DE09180123' => 'Mittenwald, M',
	'DE09180124' => 'Murnau a.Staffelsee, M',
	'DE09180125' => 'Oberammergau',
	'DE09180126' => 'Oberau',
	'DE09180127' => 'Ohlstadt',
	'DE09180128' => 'Riegsee',
	'DE09180129' => 'Saulgrub',
	'DE09180131' => 'Schwaigen',
	'DE09180132' => 'Seehausen a.Staffelsee',
	'DE09180133' => 'Spatzenhausen',
	'DE09180134' => 'Uffing a.Staffelsee',
	'DE09180135' => 'Unterammergau',
	'DE09180136' => 'Wallgau',
	'DE09180444' => 'Gdefr. Geb. (Lkr Garmisch-Partenkirchen)',
	'DE09181111' => 'Apfeldorf',
	'DE09181113' => 'Denklingen',
	'DE09181114' => 'Dießen am Ammersee, M',
	'DE09181115' => 'Eching am Ammersee',
	'DE09181116' => 'Egling a.d.Paar',
	'DE09181118' => 'Eresing',
	'DE09181120' => 'Finning',
	'DE09181121' => 'Fuchstal',
	'DE09181122' => 'Geltendorf',
	'DE09181123' => 'Greifenberg',
	'DE09181124' => 'Hofstetten',
	'DE09181126' => 'Hurlach',
	'DE09181127' => 'Igling',
	'DE09181128' => 'Kaufering, M',
	'DE09181129' => 'Kinsau',
	'DE09181130' => 'Landsberg am Lech, GKSt',
	'DE09181131' => 'Obermeitingen',
	'DE09181132' => 'Penzing',
	'DE09181133' => 'Vilgertshofen',
	'DE09181134' => 'Prittriching',
	'DE09181135' => 'Reichling',
	'DE09181137' => 'Rott',
	'DE09181138' => 'Scheuring',
	'DE09181139' => 'Schondorf am Ammersee',
	'DE09181140' => 'Schwifting',
	'DE09181141' => 'Pürgen',
	'DE09181142' => 'Thaining',
	'DE09181143' => 'Unterdießen',
	'DE09181144' => 'Utting am Ammersee',
	'DE09181145' => 'Weil',
	'DE09181146' => 'Windach',
	'DE09181444' => 'Gdefr. Geb. (Lkr Landsberg am Lech)',
	'DE09182111' => 'Bad Wiessee',
	'DE09182112' => 'Bayrischzell',
	'DE09182114' => 'Fischbachau',
	'DE09182116' => 'Gmund a.Tegernsee',
	'DE09182119' => 'Hausham',
	'DE09182120' => 'Holzkirchen, M',
	'DE09182123' => 'Irschenberg',
	'DE09182124' => 'Kreuth',
	'DE09182125' => 'Miesbach, St',
	'DE09182127' => 'Otterfing',
	'DE09182129' => 'Rottach-Egern',
	'DE09182131' => 'Schliersee, M',
	'DE09182132' => 'Tegernsee, St',
	'DE09182133' => 'Valley',
	'DE09182134' => 'Waakirchen',
	'DE09182136' => 'Warngau',
	'DE09182137' => 'Weyarn',
	'DE09183112' => 'Ampfing',
	'DE09183113' => 'Aschau a.Inn',
	'DE09183114' => 'Buchbach, M',
	'DE09183115' => 'Egglkofen',
	'DE09183116' => 'Erharting',
	'DE09183118' => 'Gars a.Inn, M',
	'DE09183119' => 'Haag i.OB, M',
	'DE09183120' => 'Heldenstein',
	'DE09183122' => 'Jettenbach',
	'DE09183123' => 'Kirchdorf',
	'DE09183124' => 'Kraiburg a.Inn, M',
	'DE09183125' => 'Lohkirchen',
	'DE09183126' => 'Maitenbeth',
	'DE09183127' => 'Mettenheim',
	'DE09183128' => 'Mühldorf a.Inn, St',
	'DE09183129' => 'Neumarkt-Sankt Veit, St',
	'DE09183130' => 'Niederbergkirchen',
	'DE09183131' => 'Niedertaufkirchen',
	'DE09183132' => 'Oberbergkirchen',
	'DE09183134' => 'Oberneukirchen',
	'DE09183135' => 'Obertaufkirchen',
	'DE09183136' => 'Polling',
	'DE09183138' => 'Rattenkirchen',
	'DE09183139' => 'Rechtmehring',
	'DE09183140' => 'Reichertsheim',
	'DE09183143' => 'Schönberg',
	'DE09183144' => 'Schwindegg',
	'DE09183145' => 'Taufkirchen',
	'DE09183147' => 'Unterreit',
	'DE09183148' => 'Waldkraiburg, St',
	'DE09183151' => 'Zangberg',
	'DE09183444' => 'Gdefr. Geb. (Lkr Mühldorf a.Inn)',
	'DE09184112' => 'Aschheim',
	'DE09184113' => 'Baierbrunn',
	'DE09184114' => 'Brunnthal',
	'DE09184118' => 'Feldkirchen',
	'DE09184119' => 'Garching b.München, St',
	'DE09184120' => 'Gräfelfing',
	'DE09184121' => 'Grasbrunn',
	'DE09184122' => 'Grünwald',
	'DE09184123' => 'Haar',
	'DE09184127' => 'Höhenkirchen-Siegertsbrunn',
	'DE09184129' => 'Hohenbrunn',
	'DE09184130' => 'Ismaning',
	'DE09184131' => 'Kirchheim b.München',
	'DE09184132' => 'Neuried',
	'DE09184134' => 'Oberhaching',
	'DE09184135' => 'Oberschleißheim',
	'DE09184136' => 'Ottobrunn',
	'DE09184137' => 'Aying',
	'DE09184138' => 'Planegg',
	'DE09184139' => 'Pullach i.Isartal',
	'DE09184140' => 'Putzbrunn',
	'DE09184141' => 'Sauerlach',
	'DE09184142' => 'Schäftlarn',
	'DE09184144' => 'Straßlach-Dingharting',
	'DE09184145' => 'Taufkirchen',
	'DE09184146' => 'Neubiberg',
	'DE09184147' => 'Unterföhring',
	'DE09184148' => 'Unterhaching',
	'DE09184149' => 'Unterschleißheim, St',
	'DE09184444' => 'Gdefr. Geb. (Lkr München)',
	'DE09185113' => 'Aresing',
	'DE09185116' => 'Berg im Gau',
	'DE09185118' => 'Bergheim',
	'DE09185123' => 'Brunnen',
	'DE09185125' => 'Burgheim, M',
	'DE09185127' => 'Ehekirchen',
	'DE09185131' => 'Gachenbach',
	'DE09185139' => 'Karlshuld',
	'DE09185140' => 'Karlskron',
	'DE09185143' => 'Langenmosen',
	'DE09185149' => 'Neuburg a.d.Donau, GKSt',
	'DE09185150' => 'Oberhausen',
	'DE09185153' => 'Rennertshofen, M',
	'DE09185157' => 'Rohrenfels',
	'DE09185158' => 'Schrobenhausen, St',
	'DE09185163' => 'Königsmoos',
	'DE09185166' => 'Waidhofen',
	'DE09185168' => 'Weichering',
	'DE09186113' => 'Baar-Ebenhausen',
	'DE09186116' => 'Ernsgaden',
	'DE09186122' => 'Geisenfeld, St',
	'DE09186125' => 'Gerolsbach',
	'DE09186126' => 'Hettenshausen',
	'DE09186128' => 'Hohenwart, M',
	'DE09186130' => 'Ilmmünster',
	'DE09186132' => 'Jetzendorf',
	'DE09186137' => 'Manching, M',
	'DE09186139' => 'Münchsmünster',
	'DE09186143' => 'Pfaffenhofen a.d.Ilm, St',
	'DE09186144' => 'Pörnbach',
	'DE09186146' => 'Reichertshausen',
	'DE09186147' => 'Reichertshofen, M',
	'DE09186149' => 'Rohrbach',
	'DE09186151' => 'Scheyern',
	'DE09186152' => 'Schweitenkirchen',
	'DE09186158' => 'Vohburg a.d.Donau, St',
	'DE09186162' => 'Wolnzach, M',
	'DE09187113' => 'Amerang',
	'DE09187114' => 'Aschau i.Chiemgau',
	'DE09187116' => 'Babensham',
	'DE09187117' => 'Bad Aibling, St',
	'DE09187118' => 'Bernau a.Chiemsee',
	'DE09187120' => 'Brannenburg',
	'DE09187121' => 'Breitbrunn a.Chiemsee',
	'DE09187122' => 'Bruckmühl, M',
	'DE09187123' => 'Chiemsee',
	'DE09187124' => 'Edling',
	'DE09187125' => 'Eggstätt',
	'DE09187126' => 'Eiselfing',
	'DE09187128' => 'Bad Endorf, M',
	'DE09187129' => 'Bad Feilnbach',
	'DE09187130' => 'Feldkirchen-Westerham',
	'DE09187131' => 'Flintsbach a.Inn',
	'DE09187132' => 'Frasdorf',
	'DE09187134' => 'Griesstätt',
	'DE09187137' => 'Großkarolinenfeld',
	'DE09187138' => 'Gstadt a.Chiemsee',
	'DE09187139' => 'Halfing',
	'DE09187142' => 'Schechen',
	'DE09187145' => 'Höslwang',
	'DE09187148' => 'Kiefersfelden',
	'DE09187150' => 'Kolbermoor, St',
	'DE09187154' => 'Neubeuern, M',
	'DE09187156' => 'Nußdorf a.Inn',
	'DE09187157' => 'Oberaudorf',
	'DE09187159' => 'Pfaffing',
	'DE09187162' => 'Prien a.Chiemsee, M',
	'DE09187163' => 'Prutting',
	'DE09187164' => 'Ramerberg',
	'DE09187165' => 'Raubling',
	'DE09187167' => 'Riedering',
	'DE09187168' => 'Rimsting',
	'DE09187169' => 'Rohrdorf',
	'DE09187170' => 'Rott a.Inn',
	'DE09187172' => 'Samerberg',
	'DE09187173' => 'Schonstett',
	'DE09187174' => 'Söchtenau',
	'DE09187176' => 'Soyen',
	'DE09187177' => 'Stephanskirchen',
	'DE09187179' => 'Tuntenhausen',
	'DE09187181' => 'Vogtareuth',
	'DE09187182' => 'Wasserburg a.Inn, St',
	'DE09187186' => 'Albaching',
	'DE09187444' => 'Gdefr. Geb. (Lkr Rosenheim)',
	'DE09188113' => 'Berg',
	'DE09188117' => 'Andechs',
	'DE09188118' => 'Feldafing',
	'DE09188120' => 'Gauting',
	'DE09188121' => 'Gilching',
	'DE09188124' => 'Herrsching a.Ammersee',
	'DE09188126' => 'Inning a.Ammersee',
	'DE09188127' => 'Krailling',
	'DE09188132' => 'Seefeld',
	'DE09188137' => 'Pöcking',
	'DE09188139' => 'Starnberg, St',
	'DE09188141' => 'Tutzing',
	'DE09188144' => 'Weßling',
	'DE09188145' => 'Wörthsee',
	'DE09188444' => 'Gdefr. Geb. (Lkr Starnberg)',
	'DE09189111' => 'Altenmarkt a.d.Alz',
	'DE09189113' => 'Bergen',
	'DE09189114' => 'Chieming',
	'DE09189115' => 'Engelsberg',
	'DE09189118' => 'Fridolfing',
	'DE09189119' => 'Grabenstätt',
	'DE09189120' => 'Grassau, M',
	'DE09189124' => 'Inzell',
	'DE09189126' => 'Kienberg',
	'DE09189127' => 'Kirchanschöring',
	'DE09189129' => 'Marquartstein',
	'DE09189130' => 'Nußdorf',
	'DE09189133' => 'Obing',
	'DE09189134' => 'Palling',
	'DE09189135' => 'Petting',
	'DE09189137' => 'Pittenhart',
	'DE09189139' => 'Reit im Winkl',
	'DE09189140' => 'Ruhpolding',
	'DE09189141' => 'Schleching',
	'DE09189142' => 'Schnaitsee',
	'DE09189143' => 'Seeon-Seebruck',
	'DE09189145' => 'Siegsdorf',
	'DE09189146' => 'Staudach-Egerndach',
	'DE09189148' => 'Surberg',
	'DE09189149' => 'Tacherting',
	'DE09189150' => 'Taching a.See',
	'DE09189152' => 'Tittmoning, St',
	'DE09189154' => 'Traunreut, St',
	'DE09189155' => 'Traunstein, GKSt',
	'DE09189157' => 'Trostberg, St',
	'DE09189159' => 'Übersee',
	'DE09189160' => 'Unterwössen',
	'DE09189161' => 'Vachendorf',
	'DE09189162' => 'Waging a.See, M',
	'DE09189165' => 'Wonneberg',
	'DE09189444' => 'Gdefr. Geb. (Lkr Traunstein)',
	'DE09190111' => 'Altenstadt',
	'DE09190113' => 'Antdorf',
	'DE09190114' => 'Bernbeuren',
	'DE09190115' => 'Bernried am Starnberger See',
	'DE09190117' => 'Böbing',
	'DE09190118' => 'Burggen',
	'DE09190120' => 'Eberfing',
	'DE09190121' => 'Eglfing',
	'DE09190126' => 'Habach',
	'DE09190129' => 'Hohenfurch',
	'DE09190130' => 'Hohenpeißenberg',
	'DE09190131' => 'Huglfing',
	'DE09190132' => 'Iffeldorf',
	'DE09190133' => 'Ingenried',
	'DE09190135' => 'Oberhausen',
	'DE09190136' => 'Obersöchering',
	'DE09190138' => 'Pähl',
	'DE09190139' => 'Peißenberg, M',
	'DE09190140' => 'Peiting, M',
	'DE09190141' => 'Penzberg, St',
	'DE09190142' => 'Polling',
	'DE09190143' => 'Prem',
	'DE09190144' => 'Raisting',
	'DE09190145' => 'Rottenbuch',
	'DE09190148' => 'Schongau, St',
	'DE09190149' => 'Schwabbruck',
	'DE09190151' => 'Schwabsoien',
	'DE09190152' => 'Seeshaupt',
	'DE09190153' => 'Sindelsdorf',
	'DE09190154' => 'Steingaden',
	'DE09190157' => 'Weilheim i.OB, St',
	'DE09190158' => 'Wessobrunn',
	'DE09190159' => 'Wielenbach',
	'DE09190160' => 'Wildsteig',
	'DE09261000' => 'Landshut',
	'DE09262000' => 'Passau',
	'DE09263000' => 'Straubing',
	'DE09271111' => 'Aholming',
	'DE09271113' => 'Auerbach',
	'DE09271114' => 'Außernzell',
	'DE09271116' => 'Bernried',
	'DE09271118' => 'Buchhofen',
	'DE09271119' => 'Deggendorf, GKSt',
	'DE09271122' => 'Grafling',
	'DE09271123' => 'Grattersdorf',
	'DE09271125' => 'Hengersberg, M',
	'DE09271126' => 'Hunding',
	'DE09271127' => 'Iggensbach',
	'DE09271128' => 'Künzing',
	'DE09271130' => 'Lalling',
	'DE09271132' => 'Metten, M',
	'DE09271135' => 'Moos',
	'DE09271138' => 'Niederalteich',
	'DE09271139' => 'Oberpöring',
	'DE09271140' => 'Offenberg',
	'DE09271141' => 'Osterhofen, St',
	'DE09271143' => 'Otzing',
	'DE09271146' => 'Plattling, St',
	'DE09271148' => 'Schaufling',
	'DE09271149' => 'Schöllnach, M',
	'DE09271151' => 'Stephansposching',
	'DE09271152' => 'Wallerfing',
	'DE09271153' => 'Winzer, M',
	'DE09272116' => 'Eppenschlag',
	'DE09272118' => 'Freyung, St',
	'DE09272119' => 'Fürsteneck',
	'DE09272120' => 'Grafenau, St',
	'DE09272121' => 'Grainet',
	'DE09272122' => 'Haidmühle',
	'DE09272126' => 'Hinterschmiding',
	'DE09272127' => 'Hohenau',
	'DE09272128' => 'Innernzell',
	'DE09272129' => 'Jandelsbrunn',
	'DE09272134' => 'Mauth',
	'DE09272136' => 'Neureichenau',
	'DE09272138' => 'Perlesreut, M',
	'DE09272139' => 'Philippsreut',
	'DE09272140' => 'Ringelai',
	'DE09272141' => 'Röhrnbach, M',
	'DE09272142' => 'Saldenburg',
	'DE09272143' => 'Sankt Oswald-Riedlhütte',
	'DE09272145' => 'Schöfweg',
	'DE09272146' => 'Neuschönau',
	'DE09272147' => 'Schönberg, M',
	'DE09272149' => 'Spiegelau',
	'DE09272150' => 'Thurmansbang',
	'DE09272151' => 'Waldkirchen, St',
	'DE09272152' => 'Zenting',
	'DE09272444' => 'Gdefr. Geb. (Lkr Freyung-Grafenau)',
	'DE09273111' => 'Abensberg, St',
	'DE09273113' => 'Aiglsbach',
	'DE09273115' => 'Attenhofen',
	'DE09273116' => 'Bad Abbach, M',
	'DE09273119' => 'Biburg',
	'DE09273121' => 'Essing, M',
	'DE09273125' => 'Hausen',
	'DE09273127' => 'Herrngiersdorf',
	'DE09273133' => 'Ihrlerstein',
	'DE09273137' => 'Kelheim, St',
	'DE09273139' => 'Kirchdorf',
	'DE09273141' => 'Langquaid, M',
	'DE09273147' => 'Mainburg, St',
	'DE09273152' => 'Neustadt a.d.Donau, St',
	'DE09273159' => 'Painten, M',
	'DE09273163' => 'Elsendorf',
	'DE09273164' => 'Riedenburg, St',
	'DE09273165' => 'Rohr i.NB, M',
	'DE09273166' => 'Saal a.d.Donau',
	'DE09273172' => 'Siegenburg, M',
	'DE09273175' => 'Teugn',
	'DE09273177' => 'Train',
	'DE09273178' => 'Volkenschwand',
	'DE09273181' => 'Wildenberg',
	'DE09273444' => 'Gdefr. Geb. (Lkr Kelheim)',
	'DE09274111' => 'Adlkofen',
	'DE09274112' => 'Aham',
	'DE09274113' => 'Altdorf, M',
	'DE09274114' => 'Altfraunhofen',
	'DE09274118' => 'Baierbach',
	'DE09274119' => 'Bayerbach b.Ergoldsbach',
	'DE09274120' => 'Bodenkirchen',
	'DE09274121' => 'Buch a.Erlbach',
	'DE09274124' => 'Eching',
	'DE09274126' => 'Ergolding, M',
	'DE09274127' => 'Ergoldsbach, M',
	'DE09274128' => 'Essenbach, M',
	'DE09274132' => 'Furth',
	'DE09274134' => 'Geisenhausen, M',
	'DE09274135' => 'Gerzen',
	'DE09274141' => 'Hohenthann',
	'DE09274145' => 'Kröning',
	'DE09274146' => 'Kumhausen',
	'DE09274153' => 'Neufahrn i.NB',
	'DE09274154' => 'Neufraunhofen',
	'DE09274156' => 'Niederaichbach',
	'DE09274165' => 'Obersüßbach',
	'DE09274172' => 'Pfeffenhausen, M',
	'DE09274174' => 'Postau',
	'DE09274176' => 'Rottenburg a.d.Laaber, St',
	'DE09274179' => 'Schalkham',
	'DE09274182' => 'Tiefenbach',
	'DE09274183' => 'Velden, M',
	'DE09274184' => 'Vilsbiburg, St',
	'DE09274185' => 'Vilsheim',
	'DE09274187' => 'Weihmichl',
	'DE09274188' => 'Weng',
	'DE09274191' => 'Wörth a.d.Isar',
	'DE09274193' => 'Wurmsham',
	'DE09274194' => 'Bruckberg',
	'DE09275111' => 'Aicha vorm Wald',
	'DE09275112' => 'Aidenbach, M',
	'DE09275114' => 'Aldersbach',
	'DE09275116' => 'Bad Füssing',
	'DE09275117' => 'Beutelsbach',
	'DE09275118' => 'Breitenberg',
	'DE09275119' => 'Büchlberg',
	'DE09275120' => 'Eging a.See, M',
	'DE09275121' => 'Fürstenstein',
	'DE09275122' => 'Fürstenzell, M',
	'DE09275124' => 'Bad Griesbach i.Rottal, St',
	'DE09275125' => 'Haarbach',
	'DE09275126' => 'Hauzenberg, St',
	'DE09275127' => 'Hofkirchen, M',
	'DE09275128' => 'Hutthurm, M',
	'DE09275130' => 'Kirchham',
	'DE09275131' => 'Kößlarn, M',
	'DE09275132' => 'Malching',
	'DE09275133' => 'Neuburg a.Inn',
	'DE09275134' => 'Neuhaus a.Inn',
	'DE09275135' => 'Neukirchen vorm Wald',
	'DE09275137' => 'Obernzell, M',
	'DE09275138' => 'Ortenburg, M',
	'DE09275141' => 'Pocking, St',
	'DE09275143' => 'Rotthalmünster, M',
	'DE09275144' => 'Ruderting',
	'DE09275145' => 'Ruhstorf a.d.Rott, M',
	'DE09275146' => 'Salzweg',
	'DE09275148' => 'Sonnen',
	'DE09275149' => 'Tettenweis',
	'DE09275150' => 'Thyrnau',
	'DE09275151' => 'Tiefenbach',
	'DE09275152' => 'Tittling, M',
	'DE09275153' => 'Untergriesbach, M',
	'DE09275154' => 'Vilshofen an der Donau, St',
	'DE09275156' => 'Wegscheid, M',
	'DE09275159' => 'Windorf, M',
	'DE09275160' => 'Witzmannsberg',
	'DE09276111' => 'Achslach',
	'DE09276113' => 'Arnbruck',
	'DE09276115' => 'Bayerisch Eisenstein',
	'DE09276116' => 'Bischofsmais',
	'DE09276117' => 'Bodenmais, M',
	'DE09276118' => 'Böbrach',
	'DE09276120' => 'Drachselsried',
	'DE09276121' => 'Frauenau',
	'DE09276122' => 'Geiersthal',
	'DE09276123' => 'Gotteszell',
	'DE09276126' => 'Kirchberg i.Wald',
	'DE09276127' => 'Kirchdorf i.Wald',
	'DE09276128' => 'Kollnburg',
	'DE09276129' => 'Langdorf',
	'DE09276130' => 'Lindberg',
	'DE09276134' => 'Patersdorf',
	'DE09276135' => 'Prackenbach',
	'DE09276138' => 'Regen, St',
	'DE09276139' => 'Rinchnach',
	'DE09276142' => 'Ruhmannsfelden, M',
	'DE09276143' => 'Teisnach, M',
	'DE09276144' => 'Viechtach, St',
	'DE09276146' => 'Zachenberg',
	'DE09276148' => 'Zwiesel, St',
	'DE09277111' => 'Arnstorf, M',
	'DE09277112' => 'Bayerbach',
	'DE09277113' => 'Bad Birnbach, M',
	'DE09277114' => 'Dietersburg',
	'DE09277116' => 'Eggenfelden, St',
	'DE09277117' => 'Egglham',
	'DE09277118' => 'Ering',
	'DE09277119' => 'Falkenberg',
	'DE09277121' => 'Gangkofen, M',
	'DE09277122' => 'Geratskirchen',
	'DE09277124' => 'Hebertsfelden',
	'DE09277126' => 'Johanniskirchen',
	'DE09277127' => 'Julbach',
	'DE09277128' => 'Kirchdorf a.Inn',
	'DE09277131' => 'Malgersdorf',
	'DE09277133' => 'Massing, M',
	'DE09277134' => 'Mitterskirchen',
	'DE09277138' => 'Pfarrkirchen, St',
	'DE09277139' => 'Postmünster',
	'DE09277140' => 'Reut',
	'DE09277141' => 'Rimbach',
	'DE09277142' => 'Roßbach',
	'DE09277144' => 'Schönau',
	'DE09277145' => 'Simbach a.Inn, St',
	'DE09277147' => 'Stubenberg',
	'DE09277148' => 'Tann, M',
	'DE09277149' => 'Triftern, M',
	'DE09277151' => 'Unterdietfurt',
	'DE09277152' => 'Wittibreut',
	'DE09277153' => 'Wurmannsquick, M',
	'DE09277154' => 'Zeilarn',
	'DE09278112' => 'Aholfing',
	'DE09278113' => 'Aiterhofen',
	'DE09278116' => 'Ascha',
	'DE09278117' => 'Atting',
	'DE09278118' => 'Bogen, St',
	'DE09278120' => 'Falkenfels',
	'DE09278121' => 'Feldkirchen',
	'DE09278123' => 'Geiselhöring, St',
	'DE09278129' => 'Haibach',
	'DE09278134' => 'Haselbach',
	'DE09278139' => 'Hunderdorf',
	'DE09278140' => 'Irlbach',
	'DE09278141' => 'Kirchroth',
	'DE09278143' => 'Konzell',
	'DE09278144' => 'Laberweinting',
	'DE09278146' => 'Leiblfing',
	'DE09278147' => 'Loitzendorf',
	'DE09278148' => 'Mallersdorf-Pfaffenberg, M',
	'DE09278149' => 'Mariaposching',
	'DE09278151' => 'Mitterfels, M',
	'DE09278154' => 'Neukirchen',
	'DE09278159' => 'Niederwinkling',
	'DE09278167' => 'Oberschneiding',
	'DE09278170' => 'Parkstetten',
	'DE09278171' => 'Perasdorf',
	'DE09278172' => 'Perkam',
	'DE09278177' => 'Rain',
	'DE09278178' => 'Rattenberg',
	'DE09278179' => 'Rattiszell',
	'DE09278182' => 'Salching',
	'DE09278184' => 'Sankt Englmar',
	'DE09278187' => 'Schwarzach, M',
	'DE09278189' => 'Stallwang',
	'DE09278190' => 'Steinach',
	'DE09278192' => 'Straßkirchen',
	'DE09278197' => 'Wiesenfelden',
	'DE09278198' => 'Windberg',
	'DE09279112' => 'Dingolfing, St',
	'DE09279113' => 'Eichendorf, M',
	'DE09279115' => 'Frontenhausen, M',
	'DE09279116' => 'Gottfrieding',
	'DE09279122' => 'Landau a.d.Isar, St',
	'DE09279124' => 'Loiching',
	'DE09279125' => 'Mamming',
	'DE09279126' => 'Marklkofen',
	'DE09279127' => 'Mengkofen',
	'DE09279128' => 'Moosthenning',
	'DE09279130' => 'Niederviehbach',
	'DE09279132' => 'Pilsting, M',
	'DE09279134' => 'Reisbach, M',
	'DE09279135' => 'Simbach, M',
	'DE09279137' => 'Wallersdorf, M',
	'DE09361000' => 'Amberg',
	'DE09362000' => 'Regensburg',
	'DE09363000' => 'Weiden i.d.OPf.',
	'DE09371111' => 'Ammerthal',
	'DE09371113' => 'Auerbach i.d.OPf., St',
	'DE09371116' => 'Birgland',
	'DE09371118' => 'Ebermannsdorf',
	'DE09371119' => 'Edelsfeld',
	'DE09371120' => 'Ensdorf',
	'DE09371121' => 'Freihung, M',
	'DE09371122' => 'Freudenberg',
	'DE09371123' => 'Gebenbach',
	'DE09371126' => 'Hahnbach, M',
	'DE09371127' => 'Hirschau, St',
	'DE09371128' => 'Hirschbach',
	'DE09371129' => 'Hohenburg, M',
	'DE09371131' => 'Illschwang',
	'DE09371132' => 'Kastl, M',
	'DE09371135' => 'Königstein, M',
	'DE09371136' => 'Kümmersbruck',
	'DE09371140' => 'Etzelwang',
	'DE09371141' => 'Neukirchen b.Sulzbach-Rosenberg',
	'DE09371144' => 'Poppenricht',
	'DE09371146' => 'Rieden, M',
	'DE09371148' => 'Schmidmühlen, M',
	'DE09371150' => 'Schnaittenbach, St',
	'DE09371151' => 'Sulzbach-Rosenberg, St',
	'DE09371154' => 'Ursensollen',
	'DE09371156' => 'Vilseck, St',
	'DE09371157' => 'Weigendorf',
	'DE09371444' => 'Gdefr. Geb. (Lkr Amberg-Sulzbach)',
	'DE09372112' => 'Arnschwang',
	'DE09372113' => 'Arrach',
	'DE09372115' => 'Blaibach',
	'DE09372116' => 'Cham, St',
	'DE09372117' => 'Chamerau',
	'DE09372124' => 'Eschlkam, M',
	'DE09372125' => 'Falkenstein, M',
	'DE09372126' => 'Furth im Wald, St',
	'DE09372128' => 'Gleißenberg',
	'DE09372130' => 'Grafenwiesen',
	'DE09372135' => 'Hohenwarth',
	'DE09372137' => 'Bad Kötzting, St',
	'DE09372138' => 'Lam, M',
	'DE09372142' => 'Michelsneukirchen',
	'DE09372143' => 'Miltach',
	'DE09372144' => 'Neukirchen b.Hl.Blut, M',
	'DE09372146' => 'Pemfling',
	'DE09372147' => 'Pösing',
	'DE09372149' => 'Reichenbach',
	'DE09372150' => 'Rettenbach',
	'DE09372151' => 'Rimbach',
	'DE09372153' => 'Roding, St',
	'DE09372154' => 'Rötz, St',
	'DE09372155' => 'Runding',
	'DE09372157' => 'Schönthal',
	'DE09372158' => 'Schorndorf',
	'DE09372161' => 'Stamsried, M',
	'DE09372163' => 'Tiefenbach',
	'DE09372164' => 'Traitsching',
	'DE09372165' => 'Treffelstein',
	'DE09372167' => 'Zell',
	'DE09372168' => 'Waffenbrunn',
	'DE09372169' => 'Wald',
	'DE09372170' => 'Walderbach',
	'DE09372171' => 'Waldmünchen, St',
	'DE09372174' => 'Weiding',
	'DE09372175' => 'Willmering',
	'DE09372177' => 'Zandt',
	'DE09372178' => 'Lohberg',
	'DE09373112' => 'Berching, St',
	'DE09373113' => 'Berg b.Neumarkt i.d.OPf.',
	'DE09373114' => 'Berngau',
	'DE09373115' => 'Breitenbrunn, M',
	'DE09373119' => 'Deining',
	'DE09373121' => 'Dietfurt a.d.Altmühl, St',
	'DE09373126' => 'Freystadt, St',
	'DE09373134' => 'Hohenfels, M',
	'DE09373140' => 'Lauterhofen, M',
	'DE09373143' => 'Lupburg, M',
	'DE09373146' => 'Mühlhausen',
	'DE09373147' => 'Neumarkt i.d.OPf., GKSt',
	'DE09373151' => 'Parsberg, St',
	'DE09373153' => 'Pilsach',
	'DE09373155' => 'Postbauer-Heng, M',
	'DE09373156' => 'Pyrbaum, M',
	'DE09373159' => 'Sengenthal',
	'DE09373160' => 'Seubersdorf i.d.OPf.',
	'DE09373167' => 'Velburg, St',
	'DE09374111' => 'Altenstadt a.d.Waldnaab',
	'DE09374117' => 'Eschenbach i.d.OPf., St',
	'DE09374118' => 'Eslarn, M',
	'DE09374119' => 'Etzenricht',
	'DE09374121' => 'Floß, M',
	'DE09374122' => 'Flossenbürg',
	'DE09374123' => 'Georgenberg',
	'DE09374124' => 'Grafenwöhr, St',
	'DE09374127' => 'Irchenrieth',
	'DE09374128' => 'Kirchendemenreuth',
	'DE09374129' => 'Kirchenthumbach, M',
	'DE09374131' => 'Kohlberg, M',
	'DE09374132' => 'Leuchtenberg, M',
	'DE09374133' => 'Luhe-Wildenau, M',
	'DE09374134' => 'Mantel, M',
	'DE09374137' => 'Moosbach, M',
	'DE09374139' => 'Neustadt a.d.Waldnaab, St',
	'DE09374140' => 'Neustadt am Kulm, St',
	'DE09374144' => 'Parkstein, M',
	'DE09374146' => 'Pirk',
	'DE09374147' => 'Pleystein, St',
	'DE09374148' => 'Trabitz',
	'DE09374149' => 'Pressath, St',
	'DE09374150' => 'Püchersreuth',
	'DE09374154' => 'Schirmitz',
	'DE09374155' => 'Schlammersdorf',
	'DE09374156' => 'Schwarzenbach',
	'DE09374157' => 'Speinshart',
	'DE09374158' => 'Störnstein',
	'DE09374159' => 'Tännesberg, M',
	'DE09374160' => 'Theisseil',
	'DE09374162' => 'Vohenstrauß, St',
	'DE09374163' => 'Vorbach',
	'DE09374164' => 'Waidhaus, M',
	'DE09374165' => 'Waldthurn, M',
	'DE09374166' => 'Weiherhammer',
	'DE09374168' => 'Windischeschenbach, St',
	'DE09374170' => 'Bechtsrieth',
	'DE09374444' => 'Gdefr. Geb. (Lkr Neustadt a.d.Waldnaab)',
	'DE09375113' => 'Alteglofsheim',
	'DE09375114' => 'Altenthann',
	'DE09375115' => 'Aufhausen',
	'DE09375116' => 'Bach a.d.Donau',
	'DE09375117' => 'Barbing',
	'DE09375118' => 'Beratzhausen, M',
	'DE09375119' => 'Bernhardswald',
	'DE09375120' => 'Brennberg',
	'DE09375122' => 'Brunn',
	'DE09375127' => 'Deuerling',
	'DE09375130' => 'Donaustauf, M',
	'DE09375131' => 'Duggendorf',
	'DE09375143' => 'Hagelstadt',
	'DE09375148' => 'Hemau, St',
	'DE09375153' => 'Holzheim a.Forst',
	'DE09375156' => 'Kallmünz, M',
	'DE09375161' => 'Köfering',
	'DE09375162' => 'Laaber, M',
	'DE09375165' => 'Lappersdorf, M',
	'DE09375170' => 'Mintraching',
	'DE09375171' => 'Mötzing',
	'DE09375174' => 'Neutraubling, St',
	'DE09375175' => 'Nittendorf, M',
	'DE09375179' => 'Obertraubling',
	'DE09375180' => 'Pentling',
	'DE09375181' => 'Pettendorf',
	'DE09375182' => 'Pfakofen',
	'DE09375183' => 'Pfatter',
	'DE09375184' => 'Pielenhofen',
	'DE09375190' => 'Regenstauf, M',
	'DE09375191' => 'Riekofen',
	'DE09375196' => 'Schierling, M',
	'DE09375199' => 'Sinzing',
	'DE09375201' => 'Sünching',
	'DE09375204' => 'Tegernheim',
	'DE09375205' => 'Thalmassing',
	'DE09375208' => 'Wenzenbach',
	'DE09375209' => 'Wiesent',
	'DE09375210' => 'Wörth a.d.Donau, St',
	'DE09375211' => 'Wolfsegg',
	'DE09375213' => 'Zeitlarn',
	'DE09375444' => 'Gdefr. Geb. (Lkr Regensburg)',
	'DE09376112' => 'Altendorf',
	'DE09376116' => 'Bodenwöhr',
	'DE09376117' => 'Bruck i.d.OPf., M',
	'DE09376119' => 'Burglengenfeld, St',
	'DE09376122' => 'Dieterskirchen',
	'DE09376125' => 'Fensterbach',
	'DE09376131' => 'Gleiritsch',
	'DE09376133' => 'Guteneck',
	'DE09376141' => 'Maxhütte-Haidhof, St',
	'DE09376144' => 'Nabburg, St',
	'DE09376146' => 'Neukirchen-Balbini, M',
	'DE09376147' => 'Neunburg vorm Wald, St',
	'DE09376148' => 'Niedermurach',
	'DE09376149' => 'Nittenau, St',
	'DE09376150' => 'Wernberg-Köblitz, M',
	'DE09376151' => 'Oberviechtach, St',
	'DE09376153' => 'Pfreimd, St',
	'DE09376159' => 'Schmidgaden',
	'DE09376160' => 'Schönsee, St',
	'DE09376161' => 'Schwandorf, GKSt',
	'DE09376162' => 'Schwarzach b.Nabburg',
	'DE09376163' => 'Schwarzenfeld, M',
	'DE09376164' => 'Schwarzhofen, M',
	'DE09376167' => 'Stadlern',
	'DE09376168' => 'Steinberg am See',
	'DE09376169' => 'Stulln',
	'DE09376170' => 'Teublitz, St',
	'DE09376171' => 'Teunz',
	'DE09376172' => 'Thanstein',
	'DE09376173' => 'Trausnitz',
	'DE09376175' => 'Wackersdorf',
	'DE09376176' => 'Weiding',
	'DE09376178' => 'Winklarn, M',
	'DE09376444' => 'Gdefr. Geb. (Lkr Schwandorf)',
	'DE09377112' => 'Bärnau, St',
	'DE09377113' => 'Brand',
	'DE09377115' => 'Ebnath',
	'DE09377116' => 'Erbendorf, St',
	'DE09377117' => 'Falkenberg, M',
	'DE09377118' => 'Friedenfels',
	'DE09377119' => 'Fuchsmühl, M',
	'DE09377127' => 'Immenreuth',
	'DE09377128' => 'Kastl',
	'DE09377129' => 'Kemnath, St',
	'DE09377131' => 'Konnersreuth, M',
	'DE09377132' => 'Krummennaab',
	'DE09377133' => 'Kulmain',
	'DE09377137' => 'Leonberg',
	'DE09377139' => 'Mähring, M',
	'DE09377141' => 'Mitterteich, St',
	'DE09377142' => 'Neualbenreuth, M',
	'DE09377143' => 'Neusorg',
	'DE09377145' => 'Pechbrunn',
	'DE09377146' => 'Plößberg, M',
	'DE09377148' => 'Pullenreuth',
	'DE09377149' => 'Reuth b.Erbendorf',
	'DE09377154' => 'Tirschenreuth, St',
	'DE09377157' => 'Waldershof, St',
	'DE09377158' => 'Waldsassen, St',
	'DE09377159' => 'Wiesau, M',
	'DE09461000' => 'Bamberg',
	'DE09462000' => 'Bayreuth',
	'DE09463000' => 'Coburg',
	'DE09464000' => 'Hof',
	'DE09471111' => 'Altendorf',
	'DE09471115' => 'Baunach, St',
	'DE09471117' => 'Bischberg',
	'DE09471119' => 'Breitengüßbach',
	'DE09471120' => 'Burgebrach, M',
	'DE09471122' => 'Burgwindheim, M',
	'DE09471123' => 'Buttenheim, M',
	'DE09471128' => 'Ebrach, M',
	'DE09471131' => 'Frensdorf',
	'DE09471133' => 'Gerach',
	'DE09471137' => 'Gundelsheim',
	'DE09471140' => 'Hallstadt, St',
	'DE09471142' => 'Heiligenstadt i.OFr., M',
	'DE09471145' => 'Hirschaid, M',
	'DE09471150' => 'Kemmern',
	'DE09471151' => 'Königsfeld',
	'DE09471152' => 'Lauter',
	'DE09471154' => 'Lisberg',
	'DE09471155' => 'Litzendorf',
	'DE09471159' => 'Memmelsdorf',
	'DE09471165' => 'Oberhaid',
	'DE09471169' => 'Pettstadt',
	'DE09471172' => 'Pommersfelden',
	'DE09471173' => 'Priesendorf',
	'DE09471174' => 'Rattelsdorf, M',
	'DE09471175' => 'Reckendorf',
	'DE09471185' => 'Scheßlitz, St',
	'DE09471186' => 'Schönbrunn i.Steigerwald',
	'DE09471189' => 'Stadelhofen',
	'DE09471191' => 'Stegaurach',
	'DE09471195' => 'Strullendorf',
	'DE09471207' => 'Viereth-Trunstadt',
	'DE09471208' => 'Walsdorf',
	'DE09471209' => 'Wattendorf',
	'DE09471214' => 'Zapfendorf, M',
	'DE09471220' => 'Schlüsselfeld, St',
	'DE09471444' => 'Gdefr. Geb. (Lkr Bamberg)',
	'DE09472111' => 'Ahorntal',
	'DE09472115' => 'Aufseß',
	'DE09472116' => 'Bad Berneck i.Fichtelgebirge, St',
	'DE09472118' => 'Betzenstein, St',
	'DE09472119' => 'Bindlach',
	'DE09472121' => 'Bischofsgrün',
	'DE09472127' => 'Creußen, St',
	'DE09472131' => 'Eckersdorf',
	'DE09472133' => 'Emtmannsberg',
	'DE09472138' => 'Fichtelberg',
	'DE09472139' => 'Gefrees, St',
	'DE09472140' => 'Gesees',
	'DE09472141' => 'Glashütten',
	'DE09472143' => 'Goldkronach, St',
	'DE09472146' => 'Haag',
	'DE09472150' => 'Heinersreuth',
	'DE09472154' => 'Hollfeld, St',
	'DE09472155' => 'Hummeltal',
	'DE09472156' => 'Kirchenpingarten',
	'DE09472164' => 'Mehlmeisel',
	'DE09472166' => 'Mistelbach',
	'DE09472167' => 'Mistelgau',
	'DE09472175' => 'Pegnitz, St',
	'DE09472176' => 'Plankenfels',
	'DE09472177' => 'Plech, M',
	'DE09472179' => 'Pottenstein, St',
	'DE09472180' => 'Prebitz',
	'DE09472184' => 'Schnabelwaid, M',
	'DE09472188' => 'Seybothenreuth',
	'DE09472190' => 'Speichersdorf',
	'DE09472197' => 'Waischenfeld, St',
	'DE09472198' => 'Warmensteinach',
	'DE09472199' => 'Weidenberg, M',
	'DE09472444' => 'Gdefr. Geb. (Lkr Bayreuth)',
	'DE09473112' => 'Ahorn',
	'DE09473120' => 'Dörfles-Esbach',
	'DE09473121' => 'Ebersdorf b.Coburg',
	'DE09473132' => 'Großheirath',
	'DE09473134' => 'Grub a.Forst',
	'DE09473138' => 'Itzgrund',
	'DE09473141' => 'Lautertal',
	'DE09473144' => 'Meeder',
	'DE09473151' => 'Neustadt b.Coburg, GKSt',
	'DE09473153' => 'Niederfüllbach',
	'DE09473158' => 'Bad Rodach, St',
	'DE09473159' => 'Rödental, St',
	'DE09473165' => 'Seßlach, St',
	'DE09473166' => 'Sonnefeld',
	'DE09473170' => 'Untersiemau',
	'DE09473174' => 'Weidhausen b.Coburg',
	'DE09473175' => 'Weitramsdorf',
	'DE09473444' => 'Gdefr. Geb. (Lkr Coburg)',
	'DE09474119' => 'Dormitz',
	'DE09474121' => 'Ebermannstadt, St',
	'DE09474122' => 'Effeltrich',
	'DE09474123' => 'Eggolsheim, M',
	'DE09474124' => 'Egloffstein, M',
	'DE09474126' => 'Forchheim, GKSt',
	'DE09474129' => 'Gößweinstein, M',
	'DE09474132' => 'Gräfenberg, St',
	'DE09474133' => 'Hallerndorf',
	'DE09474134' => 'Hausen',
	'DE09474135' => 'Heroldsbach',
	'DE09474137' => 'Hetzles',
	'DE09474138' => 'Hiltpoltstein, M',
	'DE09474140' => 'Igensdorf, M',
	'DE09474143' => 'Kirchehrenbach',
	'DE09474144' => 'Kleinsendelbach',
	'DE09474145' => 'Kunreuth',
	'DE09474146' => 'Langensendelbach',
	'DE09474147' => 'Leutenbach',
	'DE09474154' => 'Neunkirchen a.Brand, M',
	'DE09474156' => 'Obertrubach',
	'DE09474158' => 'Pinzberg',
	'DE09474160' => 'Poxdorf',
	'DE09474161' => 'Pretzfeld, M',
	'DE09474168' => 'Unterleinleiter',
	'DE09474171' => 'Weilersbach',
	'DE09474173' => 'Weißenohe',
	'DE09474175' => 'Wiesenthau',
	'DE09474176' => 'Wiesenttal, M',
	'DE09475112' => 'Bad Steben, M',
	'DE09475113' => 'Berg',
	'DE09475120' => 'Döhlau',
	'DE09475123' => 'Feilitzsch',
	'DE09475127' => 'Gattendorf',
	'DE09475128' => 'Geroldsgrün',
	'DE09475136' => 'Helmbrechts, St',
	'DE09475137' => 'Issigau',
	'DE09475141' => 'Köditz',
	'DE09475142' => 'Konradsreuth',
	'DE09475145' => 'Leupoldsgrün',
	'DE09475146' => 'Lichtenberg, St',
	'DE09475154' => 'Münchberg, St',
	'DE09475156' => 'Naila, St',
	'DE09475158' => 'Oberkotzau, M',
	'DE09475161' => 'Regnitzlosau',
	'DE09475162' => 'Rehau, St',
	'DE09475165' => 'Schauenstein, St',
	'DE09475168' => 'Schwarzenbach a.d.Saale, St',
	'DE09475169' => 'Schwarzenbach a.Wald, St',
	'DE09475171' => 'Selbitz, St',
	'DE09475174' => 'Sparneck, M',
	'DE09475175' => 'Stammbach, M',
	'DE09475181' => 'Töpen',
	'DE09475182' => 'Trogen',
	'DE09475184' => 'Weißdorf',
	'DE09475189' => 'Zell im Fichtelgebirge, M',
	'DE09475444' => 'Gdefr. Geb. (Lkr Hof)',
	'DE09476145' => 'Kronach, St',
	'DE09476146' => 'Küps, M',
	'DE09476152' => 'Ludwigsstadt, St',
	'DE09476154' => 'Mitwitz, M',
	'DE09476159' => 'Nordhalben, M',
	'DE09476164' => 'Pressig, M',
	'DE09476166' => 'Reichenbach',
	'DE09476171' => 'Schneckenlohe',
	'DE09476175' => 'Steinbach a.Wald',
	'DE09476177' => 'Steinwiesen, M',
	'DE09476178' => 'Stockheim',
	'DE09476179' => 'Tettau, M',
	'DE09476180' => 'Teuschnitz, St',
	'DE09476182' => 'Tschirn',
	'DE09476183' => 'Marktrodach, M',
	'DE09476184' => 'Wallenfels, St',
	'DE09476185' => 'Weißenbrunn',
	'DE09476189' => 'Wilhelmsthal',
	'DE09476444' => 'Gdefr. Geb. (Lkr Kronach)',
	'DE09477117' => 'Grafengehaig, M',
	'DE09477118' => 'Guttenberg',
	'DE09477119' => 'Harsdorf',
	'DE09477121' => 'Himmelkron',
	'DE09477124' => 'Kasendorf, M',
	'DE09477127' => 'Ködnitz',
	'DE09477128' => 'Kulmbach, GKSt',
	'DE09477129' => 'Kupferberg, St',
	'DE09477135' => 'Ludwigschorgast, M',
	'DE09477136' => 'Mainleus, M',
	'DE09477138' => 'Marktleugast, M',
	'DE09477139' => 'Marktschorgast, M',
	'DE09477142' => 'Neudrossenfeld',
	'DE09477143' => 'Neuenmarkt',
	'DE09477148' => 'Presseck, M',
	'DE09477151' => 'Rugendorf',
	'DE09477156' => 'Stadtsteinach, St',
	'DE09477157' => 'Thurnau, M',
	'DE09477158' => 'Trebgast',
	'DE09477159' => 'Untersteinach',
	'DE09477163' => 'Wirsberg, M',
	'DE09477164' => 'Wonsees, M',
	'DE09478111' => 'Altenkunstadt',
	'DE09478116' => 'Burgkunstadt, St',
	'DE09478120' => 'Ebensfeld, M',
	'DE09478127' => 'Hochstadt a.Main',
	'DE09478139' => 'Lichtenfels, St',
	'DE09478143' => 'Marktgraitz, M',
	'DE09478144' => 'Marktzeuln, M',
	'DE09478145' => 'Michelau i.OFr.',
	'DE09478155' => 'Redwitz a.d.Rodach',
	'DE09478165' => 'Bad Staffelstein, St',
	'DE09478176' => 'Weismain, St',
	'DE09478444' => 'Gdefr. Geb. (Lkr Lichtenfels)',
	'DE09479111' => 'Bad Alexandersbad',
	'DE09479112' => 'Arzberg, St',
	'DE09479126' => 'Höchstädt i.Fichtelgebirge',
	'DE09479127' => 'Hohenberg a.d.Eger, St',
	'DE09479129' => 'Kirchenlamitz, St',
	'DE09479135' => 'Marktleuthen, St',
	'DE09479136' => 'Marktredwitz, GKSt',
	'DE09479138' => 'Nagel',
	'DE09479145' => 'Röslau',
	'DE09479147' => 'Schirnding, M',
	'DE09479150' => 'Schönwald, St',
	'DE09479152' => 'Selb, GKSt',
	'DE09479158' => 'Thiersheim, M',
	'DE09479159' => 'Thierstein, M',
	'DE09479161' => 'Tröstau',
	'DE09479166' => 'Weißenstadt, St',
	'DE09479169' => 'Wunsiedel, St',
	'DE09479444' => 'Gdefr. Geb. (Lkr Wunsiedel i.Fichtelgebirge)',
	'DE09561000' => 'Ansbach',
	'DE09562000' => 'Erlangen',
	'DE09563000' => 'Fürth',
	'DE09564000' => 'Nürnberg',
	'DE09565000' => 'Schwabach',
	'DE09571111' => 'Adelshofen',
	'DE09571113' => 'Arberg, M',
	'DE09571114' => 'Aurach',
	'DE09571115' => 'Bechhofen, M',
	'DE09571122' => 'Bruckberg',
	'DE09571125' => 'Buch a.Wald',
	'DE09571127' => 'Burgoberbach',
	'DE09571128' => 'Burk',
	'DE09571130' => 'Colmberg, M',
	'DE09571132' => 'Dentlein a.Forst, M',
	'DE09571134' => 'Diebach',
	'DE09571135' => 'Dietenhofen, M',
	'DE09571136' => 'Dinkelsbühl, GKSt',
	'DE09571137' => 'Dombühl, M',
	'DE09571139' => 'Dürrwangen, M',
	'DE09571141' => 'Ehingen',
	'DE09571145' => 'Feuchtwangen, St',
	'DE09571146' => 'Flachslanden, M',
	'DE09571152' => 'Gebsattel',
	'DE09571154' => 'Gerolfingen',
	'DE09571155' => 'Geslau',
	'DE09571165' => 'Heilsbronn, St',
	'DE09571166' => 'Herrieden, St',
	'DE09571169' => 'Insingen',
	'DE09571170' => 'Langfurth',
	'DE09571171' => 'Lehrberg, M',
	'DE09571174' => 'Leutershausen, St',
	'DE09571175' => 'Lichtenau, M',
	'DE09571177' => 'Merkendorf, St',
	'DE09571178' => 'Mitteleschenbach',
	'DE09571179' => 'Mönchsroth',
	'DE09571180' => 'Neuendettelsau',
	'DE09571181' => 'Neusitz',
	'DE09571183' => 'Oberdachstetten',
	'DE09571188' => 'Ohrenbach',
	'DE09571189' => 'Ornbau, St',
	'DE09571190' => 'Petersaurach',
	'DE09571192' => 'Röckingen',
	'DE09571193' => 'Rothenburg ob der Tauber, GKSt',
	'DE09571194' => 'Rügland',
	'DE09571196' => 'Sachsen b.Ansbach',
	'DE09571198' => 'Schillingsfürst, St',
	'DE09571199' => 'Schnelldorf',
	'DE09571200' => 'Schopfloch, M',
	'DE09571205' => 'Steinsfeld',
	'DE09571208' => 'Unterschwaningen',
	'DE09571214' => 'Wassertrüdingen, St',
	'DE09571216' => 'Weidenbach, M',
	'DE09571217' => 'Weihenzell',
	'DE09571218' => 'Weiltingen, M',
	'DE09571222' => 'Wettringen',
	'DE09571223' => 'Wieseth',
	'DE09571224' => 'Wilburgstetten',
	'DE09571225' => 'Windelsbach',
	'DE09571226' => 'Windsbach, St',
	'DE09571227' => 'Wittelshofen',
	'DE09571228' => 'Wörnitz',
	'DE09571229' => 'Wolframs-Eschenbach, St',
	'DE09571444' => 'Gdefr. Geb. (Lkr Ansbach)',
	'DE09572111' => 'Adelsdorf',
	'DE09572114' => 'Aurachtal',
	'DE09572115' => 'Baiersdorf, St',
	'DE09572119' => 'Bubenreuth',
	'DE09572120' => 'Buckenhof',
	'DE09572121' => 'Eckental, M',
	'DE09572126' => 'Gremsdorf',
	'DE09572127' => 'Großenseebach',
	'DE09572130' => 'Hemhofen',
	'DE09572131' => 'Heroldsberg, M',
	'DE09572132' => 'Herzogenaurach, St',
	'DE09572133' => 'Heßdorf',
	'DE09572135' => 'Höchstadt a.d.Aisch, St',
	'DE09572137' => 'Kalchreuth',
	'DE09572139' => 'Lonnerstadt, M',
	'DE09572141' => 'Marloffstein',
	'DE09572142' => 'Möhrendorf',
	'DE09572143' => 'Mühlhausen, M',
	'DE09572147' => 'Oberreichenbach',
	'DE09572149' => 'Röttenbach',
	'DE09572154' => 'Spardorf',
	'DE09572158' => 'Uttenreuth',
	'DE09572159' => 'Vestenbergsgreuth, M',
	'DE09572160' => 'Wachenroth, M',
	'DE09572164' => 'Weisendorf, M',
	'DE09572444' => 'Gdefr. Geb. (Lkr Erlangen-Höchstadt)',
	'DE09573111' => 'Ammerndorf, M',
	'DE09573114' => 'Cadolzburg, M',
	'DE09573115' => 'Großhabersdorf',
	'DE09573120' => 'Langenzenn, St',
	'DE09573122' => 'Oberasbach, St',
	'DE09573123' => 'Obermichelbach',
	'DE09573124' => 'Puschendorf',
	'DE09573125' => 'Roßtal, M',
	'DE09573126' => 'Seukendorf',
	'DE09573127' => 'Stein, St',
	'DE09573129' => 'Tuchenbach',
	'DE09573130' => 'Veitsbronn',
	'DE09573133' => 'Wilhermsdorf, M',
	'DE09573134' => 'Zirndorf, St',
	'DE09574111' => 'Alfeld',
	'DE09574112' => 'Altdorf b.Nürnberg, St',
	'DE09574117' => 'Burgthann',
	'DE09574120' => 'Engelthal',
	'DE09574123' => 'Feucht, M',
	'DE09574128' => 'Happurg',
	'DE09574129' => 'Hartenstein',
	'DE09574131' => 'Henfenfeld',
	'DE09574132' => 'Hersbruck, St',
	'DE09574135' => 'Kirchensittenbach',
	'DE09574138' => 'Lauf a.d.Pegnitz, St',
	'DE09574139' => 'Leinburg',
	'DE09574140' => 'Neuhaus a.d.Pegnitz, M',
	'DE09574141' => 'Neunkirchen a.Sand',
	'DE09574145' => 'Offenhausen',
	'DE09574146' => 'Ottensoos',
	'DE09574147' => 'Pommelsbrunn',
	'DE09574150' => 'Reichenschwand',
	'DE09574152' => 'Röthenbach a.d.Pegnitz, St',
	'DE09574154' => 'Rückersdorf',
	'DE09574155' => 'Schnaittach, M',
	'DE09574156' => 'Schwaig b.Nürnberg',
	'DE09574157' => 'Schwarzenbruck',
	'DE09574158' => 'Simmelsdorf',
	'DE09574160' => 'Velden, St',
	'DE09574161' => 'Vorra',
	'DE09574164' => 'Winkelhaid',
	'DE09574444' => 'Gdefr. Geb. (Lkr Nürnberger Land)',
	'DE09575112' => 'Bad Windsheim, St',
	'DE09575113' => 'Baudenbach, M',
	'DE09575115' => 'Burgbernheim, St',
	'DE09575116' => 'Burghaslach, M',
	'DE09575117' => 'Dachsbach, M',
	'DE09575118' => 'Diespeck',
	'DE09575119' => 'Dietersheim',
	'DE09575121' => 'Emskirchen, M',
	'DE09575122' => 'Ergersheim',
	'DE09575124' => 'Gallmersgarten',
	'DE09575125' => 'Gerhardshofen',
	'DE09575127' => 'Gollhofen',
	'DE09575128' => 'Gutenstetten',
	'DE09575129' => 'Hagenbüchach',
	'DE09575130' => 'Hemmersheim',
	'DE09575133' => 'Illesheim',
	'DE09575134' => 'Ippesheim, M',
	'DE09575135' => 'Ipsheim, M',
	'DE09575138' => 'Langenfeld',
	'DE09575143' => 'Marktbergel, M',
	'DE09575144' => 'Markt Bibart, M',
	'DE09575145' => 'Markt Erlbach, M',
	'DE09575146' => 'Markt Nordheim, M',
	'DE09575147' => 'Markt Taschendorf, M',
	'DE09575150' => 'Münchsteinach',
	'DE09575152' => 'Neuhof a.d.Zenn, M',
	'DE09575153' => 'Neustadt a.d.Aisch, St',
	'DE09575155' => 'Oberickelsheim',
	'DE09575156' => 'Obernzenn, M',
	'DE09575157' => 'Oberscheinfeld, M',
	'DE09575161' => 'Scheinfeld, St',
	'DE09575163' => 'Simmershofen',
	'DE09575165' => 'Sugenheim, M',
	'DE09575166' => 'Trautskirchen',
	'DE09575167' => 'Uehlfeld, M',
	'DE09575168' => 'Uffenheim, St',
	'DE09575179' => 'Weigenheim',
	'DE09575181' => 'Wilhelmsdorf',
	'DE09575444' => 'Gdefr. Geb. (Lkr Neustadt a.d.Aisch-Bad Windsheim)',
	'DE09576111' => 'Abenberg, St',
	'DE09576113' => 'Allersberg, M',
	'DE09576117' => 'Büchenbach',
	'DE09576121' => 'Georgensgmünd',
	'DE09576122' => 'Greding, St',
	'DE09576126' => 'Heideck, St',
	'DE09576127' => 'Hilpoltstein, St',
	'DE09576128' => 'Kammerstein',
	'DE09576132' => 'Schwanstetten, M',
	'DE09576137' => 'Rednitzhembach',
	'DE09576141' => 'Röttenbach',
	'DE09576142' => 'Rohr',
	'DE09576143' => 'Roth, St',
	'DE09576147' => 'Spalt, St',
	'DE09576148' => 'Thalmässing, M',
	'DE09576151' => 'Wendelstein, M',
	'DE09576444' => 'Gdefr. Geb. (Lkr Roth)',
	'DE09577111' => 'Absberg, M',
	'DE09577113' => 'Alesheim',
	'DE09577114' => 'Muhr a.See',
	'DE09577115' => 'Bergen',
	'DE09577120' => 'Burgsalach',
	'DE09577122' => 'Dittenheim',
	'DE09577125' => 'Ellingen, St',
	'DE09577127' => 'Ettenstatt',
	'DE09577133' => 'Gnotzheim, M',
	'DE09577136' => 'Gunzenhausen, St',
	'DE09577138' => 'Haundorf',
	'DE09577140' => 'Heidenheim, M',
	'DE09577141' => 'Höttingen',
	'DE09577148' => 'Langenaltheim',
	'DE09577149' => 'Markt Berolzheim, M',
	'DE09577150' => 'Meinheim',
	'DE09577151' => 'Nennslingen, M',
	'DE09577158' => 'Pappenheim, St',
	'DE09577159' => 'Pfofeld',
	'DE09577161' => 'Pleinfeld, M',
	'DE09577162' => 'Polsingen',
	'DE09577163' => 'Raitenbuch',
	'DE09577168' => 'Solnhofen',
	'DE09577172' => 'Theilenhofen',
	'DE09577173' => 'Treuchtlingen, St',
	'DE09577177' => 'Weißenburg i.Bay., GKSt',
	'DE09577179' => 'Westheim',
	'DE09661000' => 'Aschaffenburg',
	'DE09662000' => 'Schweinfurt',
	'DE09663000' => 'Würzburg',
	'DE09671111' => 'Alzenau, St',
	'DE09671112' => 'Bessenbach',
	'DE09671113' => 'Blankenbach',
	'DE09671114' => 'Karlstein a.Main',
	'DE09671119' => 'Geiselbach',
	'DE09671120' => 'Glattbach',
	'DE09671121' => 'Goldbach, M',
	'DE09671122' => 'Großostheim, M',
	'DE09671124' => 'Haibach',
	'DE09671126' => 'Heigenbrücken',
	'DE09671127' => 'Heimbuchenthal',
	'DE09671128' => 'Heinrichsthal',
	'DE09671130' => 'Hösbach, M',
	'DE09671133' => 'Johannesberg',
	'DE09671134' => 'Kahl a.Main',
	'DE09671135' => 'Kleinkahl',
	'DE09671136' => 'Kleinostheim',
	'DE09671138' => 'Krombach',
	'DE09671139' => 'Laufach',
	'DE09671140' => 'Mainaschaff',
	'DE09671141' => 'Mespelbrunn',
	'DE09671143' => 'Mömbris, M',
	'DE09671148' => 'Rothenbuch',
	'DE09671150' => 'Sailauf',
	'DE09671152' => 'Schöllkrippen, M',
	'DE09671153' => 'Sommerkahl',
	'DE09671155' => 'Stockstadt a.Main, M',
	'DE09671156' => 'Waldaschaff',
	'DE09671157' => 'Weibersbrunn',
	'DE09671159' => 'Westerngrund',
	'DE09671160' => 'Dammbach',
	'DE09671162' => 'Wiesen',
	'DE09671444' => 'Gdefr. Geb. (Lkr Aschaffenburg)',
	'DE09672111' => 'Aura a.d.Saale',
	'DE09672112' => 'Bad Bocklet, M',
	'DE09672113' => 'Bad Brückenau, St',
	'DE09672114' => 'Bad Kissingen, GKSt',
	'DE09672117' => 'Burkardroth, M',
	'DE09672121' => 'Elfershausen, M',
	'DE09672122' => 'Euerdorf, M',
	'DE09672124' => 'Fuchsstadt',
	'DE09672126' => 'Geroda, M',
	'DE09672127' => 'Hammelburg, St',
	'DE09672131' => 'Maßbach, M',
	'DE09672134' => 'Motten',
	'DE09672135' => 'Münnerstadt, St',
	'DE09672136' => 'Nüdlingen',
	'DE09672138' => 'Oberleichtersbach',
	'DE09672139' => 'Oberthulba, M',
	'DE09672140' => 'Oerlenbach',
	'DE09672142' => 'Ramsthal',
	'DE09672143' => 'Rannungen',
	'DE09672145' => 'Riedenberg',
	'DE09672149' => 'Schondra, M',
	'DE09672155' => 'Sulzthal, M',
	'DE09672157' => 'Thundorf i.UFr.',
	'DE09672161' => 'Wartmannsroth',
	'DE09672163' => 'Wildflecken, M',
	'DE09672166' => 'Zeitlofs, M',
	'DE09672444' => 'Gdefr. Geb. (Lkr Bad Kissingen)',
	'DE09673113' => 'Aubstadt',
	'DE09673114' => 'Bad Neustadt a.d.Saale, St',
	'DE09673116' => 'Bastheim',
	'DE09673117' => 'Bischofsheim a.d.Rhön, St',
	'DE09673123' => 'Fladungen, St',
	'DE09673126' => 'Großbardorf',
	'DE09673127' => 'Großeibstadt',
	'DE09673129' => 'Hausen',
	'DE09673130' => 'Hendungen',
	'DE09673131' => 'Herbstadt',
	'DE09673133' => 'Heustreu',
	'DE09673134' => 'Höchheim',
	'DE09673135' => 'Hohenroth',
	'DE09673136' => 'Hollstadt',
	'DE09673141' => 'Bad Königshofen i.Grabfeld, St',
	'DE09673142' => 'Mellrichstadt, St',
	'DE09673146' => 'Niederlauer',
	'DE09673147' => 'Nordheim v.d.Rhön',
	'DE09673149' => 'Oberelsbach, M',
	'DE09673151' => 'Oberstreu',
	'DE09673153' => 'Ostheim v.d.Rhön, St',
	'DE09673156' => 'Rödelmaier',
	'DE09673160' => 'Saal a.d.Saale, M',
	'DE09673161' => 'Salz',
	'DE09673162' => 'Sandberg',
	'DE09673163' => 'Schönau a.d.Brend',
	'DE09673167' => 'Sondheim v.d.Rhön',
	'DE09673170' => 'Stockheim',
	'DE09673171' => 'Strahlungen',
	'DE09673172' => 'Sulzdorf a.d.Lederhecke',
	'DE09673173' => 'Sulzfeld',
	'DE09673174' => 'Trappstadt, M',
	'DE09673175' => 'Unsleben',
	'DE09673182' => 'Willmars',
	'DE09673183' => 'Wollbach',
	'DE09673184' => 'Wülfershausen a.d.Saale',
	'DE09673186' => 'Burglauer',
	'DE09673444' => 'Gdefr. Geb. (Lkr Rhön-Grabfeld)',
	'DE09674111' => 'Aidhausen',
	'DE09674118' => 'Breitbrunn',
	'DE09674120' => 'Bundorf',
	'DE09674121' => 'Burgpreppach, M',
	'DE09674129' => 'Ebelsbach',
	'DE09674130' => 'Ebern, St',
	'DE09674133' => 'Eltmann, St',
	'DE09674139' => 'Gädheim',
	'DE09674147' => 'Haßfurt, St',
	'DE09674149' => 'Hofheim i.UFr., St',
	'DE09674153' => 'Riedbach',
	'DE09674159' => 'Oberaurach',
	'DE09674160' => 'Kirchlauter',
	'DE09674163' => 'Knetzgau',
	'DE09674164' => 'Königsberg i.Bay., St',
	'DE09674171' => 'Maroldsweisach, M',
	'DE09674180' => 'Theres',
	'DE09674184' => 'Pfarrweisach',
	'DE09674187' => 'Rauhenebrach',
	'DE09674190' => 'Rentweinsdorf, M',
	'DE09674195' => 'Sand a.Main',
	'DE09674201' => 'Stettfeld',
	'DE09674210' => 'Untermerzbach',
	'DE09674219' => 'Wonfurt',
	'DE09674221' => 'Zeil a.Main, St',
	'DE09674223' => 'Ermershausen',
	'DE09675111' => 'Abtswind, M',
	'DE09675112' => 'Albertshofen',
	'DE09675113' => 'Biebelried',
	'DE09675114' => 'Buchbrunn',
	'DE09675116' => 'Castell',
	'DE09675117' => 'Dettelbach, St',
	'DE09675127' => 'Geiselwind, M',
	'DE09675131' => 'Großlangheim, M',
	'DE09675139' => 'Iphofen, St',
	'DE09675141' => 'Kitzingen, GKSt',
	'DE09675142' => 'Kleinlangheim, M',
	'DE09675144' => 'Mainbernheim, St',
	'DE09675146' => 'Mainstockheim',
	'DE09675147' => 'Marktbreit, St',
	'DE09675148' => 'Markt Einersheim, M',
	'DE09675149' => 'Marktsteft, St',
	'DE09675150' => 'Martinsheim',
	'DE09675155' => 'Nordheim a.Main',
	'DE09675156' => 'Obernbreit, M',
	'DE09675158' => 'Prichsenstadt, St',
	'DE09675161' => 'Rödelsee',
	'DE09675162' => 'Rüdenhausen, M',
	'DE09675165' => 'Schwarzach a.Main, M',
	'DE09675166' => 'Segnitz',
	'DE09675167' => 'Seinsheim, M',
	'DE09675169' => 'Sommerach',
	'DE09675170' => 'Sulzfeld a.Main',
	'DE09675174' => 'Volkach, St',
	'DE09675177' => 'Wiesenbronn',
	'DE09675178' => 'Wiesentheid, M',
	'DE09675179' => 'Willanzheim, M',
	'DE09676111' => 'Altenbuch',
	'DE09676112' => 'Amorbach, St',
	'DE09676116' => 'Bürgstadt, M',
	'DE09676117' => 'Collenberg',
	'DE09676118' => 'Dorfprozelten',
	'DE09676119' => 'Eichenbühl',
	'DE09676121' => 'Elsenfeld, M',
	'DE09676122' => 'Erlenbach a.Main, St',
	'DE09676123' => 'Eschau, M',
	'DE09676124' => 'Faulbach',
	'DE09676125' => 'Großheubach, M',
	'DE09676126' => 'Großwallstadt',
	'DE09676128' => 'Hausen',
	'DE09676131' => 'Kirchzell, M',
	'DE09676132' => 'Kleinheubach, M',
	'DE09676133' => 'Kleinwallstadt, M',
	'DE09676134' => 'Klingenberg a.Main, St',
	'DE09676135' => 'Laudenbach',
	'DE09676136' => 'Leidersbach',
	'DE09676139' => 'Miltenberg, St',
	'DE09676140' => 'Mömlingen',
	'DE09676141' => 'Mönchberg, M',
	'DE09676143' => 'Neunkirchen',
	'DE09676144' => 'Niedernberg',
	'DE09676145' => 'Obernburg a.Main, St',
	'DE09676151' => 'Röllbach',
	'DE09676153' => 'Rüdenau',
	'DE09676156' => 'Schneeberg, M',
	'DE09676158' => 'Stadtprozelten, St',
	'DE09676160' => 'Sulzbach a.Main, M',
	'DE09676165' => 'Weilbach, M',
	'DE09676169' => 'Wörth a.Main, St',
	'DE09676444' => 'Gdefr. Geb. (Lkr Miltenberg)',
	'DE09677114' => 'Arnstein, St',
	'DE09677116' => 'Aura i.Sinngrund',
	'DE09677119' => 'Birkenfeld',
	'DE09677120' => 'Bischbrunn',
	'DE09677122' => 'Burgsinn, M',
	'DE09677125' => 'Erlenbach b.Marktheidenfeld',
	'DE09677126' => 'Esselbach',
	'DE09677127' => 'Eußenheim',
	'DE09677128' => 'Fellen',
	'DE09677129' => 'Frammersbach, M',
	'DE09677131' => 'Gemünden a.Main, St',
	'DE09677132' => 'Gössenheim',
	'DE09677133' => 'Gräfendorf',
	'DE09677135' => 'Hafenlohr',
	'DE09677137' => 'Hasloch',
	'DE09677142' => 'Himmelstadt',
	'DE09677146' => 'Karbach, M',
	'DE09677148' => 'Karlstadt, St',
	'DE09677149' => 'Karsbach',
	'DE09677151' => 'Kreuzwertheim, M',
	'DE09677154' => 'Triefenstein, M',
	'DE09677155' => 'Lohr a.Main, St',
	'DE09677157' => 'Marktheidenfeld, St',
	'DE09677159' => 'Mittelsinn',
	'DE09677164' => 'Neuendorf',
	'DE09677165' => 'Neuhütten',
	'DE09677166' => 'Neustadt a.Main',
	'DE09677169' => 'Obersinn, M',
	'DE09677170' => 'Partenstein',
	'DE09677172' => 'Rechtenbach',
	'DE09677175' => 'Retzstadt',
	'DE09677177' => 'Rieneck, St',
	'DE09677178' => 'Roden',
	'DE09677181' => 'Rothenfels, St',
	'DE09677182' => 'Schollbrunn',
	'DE09677186' => 'Steinfeld',
	'DE09677189' => 'Thüngen, M',
	'DE09677193' => 'Urspringen',
	'DE09677200' => 'Wiesthal',
	'DE09677203' => 'Zellingen, M',
	'DE09677444' => 'Gdefr. Geb. (Lkr Main-Spessart)',
	'DE09678115' => 'Bergrheinfeld',
	'DE09678122' => 'Dingolshausen',
	'DE09678123' => 'Dittelbrunn',
	'DE09678124' => 'Donnersdorf',
	'DE09678128' => 'Euerbach',
	'DE09678130' => 'Frankenwinheim',
	'DE09678132' => 'Geldersheim',
	'DE09678134' => 'Gerolzhofen, St',
	'DE09678135' => 'Gochsheim',
	'DE09678136' => 'Grafenrheinfeld',
	'DE09678138' => 'Grettstadt',
	'DE09678150' => 'Kolitzheim',
	'DE09678153' => 'Lülsfeld',
	'DE09678157' => 'Michelau i.Steigerwald',
	'DE09678160' => 'Niederwerrn',
	'DE09678164' => 'Oberschwarzach, M',
	'DE09678168' => 'Poppenhausen',
	'DE09678170' => 'Röthlein',
	'DE09678174' => 'Schonungen',
	'DE09678175' => 'Schwanfeld',
	'DE09678176' => 'Schwebheim',
	'DE09678178' => 'Sennfeld',
	'DE09678181' => 'Stadtlauringen, M',
	'DE09678183' => 'Sulzheim',
	'DE09678186' => 'Üchtelhausen',
	'DE09678190' => 'Waigolshausen',
	'DE09678192' => 'Wasserlosen',
	'DE09678193' => 'Werneck, M',
	'DE09678196' => 'Wipfeld',
	'DE09678444' => 'Gdefr. Geb. (Lkr Schweinfurt)',
	'DE09679114' => 'Aub, St',
	'DE09679117' => 'Bergtheim',
	'DE09679118' => 'Bieberehren',
	'DE09679122' => 'Bütthard, M',
	'DE09679124' => 'Eibelstadt, St',
	'DE09679126' => 'Eisingen',
	'DE09679128' => 'Erlabrunn',
	'DE09679130' => 'Estenfeld',
	'DE09679131' => 'Frickenhausen a.Main, M',
	'DE09679134' => 'Gaukönigshofen',
	'DE09679135' => 'Gelchsheim, M',
	'DE09679136' => 'Gerbrunn',
	'DE09679137' => 'Geroldshausen',
	'DE09679138' => 'Giebelstadt, M',
	'DE09679141' => 'Greußenheim',
	'DE09679142' => 'Güntersleben',
	'DE09679143' => 'Hausen b.Würzburg',
	'DE09679144' => 'Helmstadt, M',
	'DE09679146' => 'Hettstadt',
	'DE09679147' => 'Höchberg, M',
	'DE09679149' => 'Holzkirchen',
	'DE09679153' => 'Kirchheim',
	'DE09679154' => 'Kist',
	'DE09679155' => 'Kleinrinderfeld',
	'DE09679156' => 'Kürnach',
	'DE09679161' => 'Margetshöchheim',
	'DE09679164' => 'Neubrunn, M',
	'DE09679165' => 'Altertheim',
	'DE09679167' => 'Eisenheim, M',
	'DE09679169' => 'Oberpleichfeld',
	'DE09679170' => 'Ochsenfurt, St',
	'DE09679174' => 'Prosselsheim',
	'DE09679175' => 'Randersacker, M',
	'DE09679176' => 'Reichenberg, M',
	'DE09679177' => 'Remlingen, M',
	'DE09679179' => 'Riedenheim',
	'DE09679180' => 'Rimpar, M',
	'DE09679182' => 'Röttingen, St',
	'DE09679185' => 'Rottendorf',
	'DE09679187' => 'Sommerhausen, M',
	'DE09679188' => 'Sonderhofen',
	'DE09679192' => 'Tauberrettersheim',
	'DE09679193' => 'Theilheim',
	'DE09679194' => 'Thüngersheim',
	'DE09679196' => 'Uettingen',
	'DE09679200' => 'Leinach',
	'DE09679201' => 'Unterpleichfeld',
	'DE09679202' => 'Veitshöchheim',
	'DE09679204' => 'Waldbrunn',
	'DE09679205' => 'Waldbüttelbrunn',
	'DE09679206' => 'Winterhausen, M',
	'DE09679209' => 'Zell a.Main, M',
	'DE09679444' => 'Gdefr. Geb. (Lkr Würzburg)',
	'DE09761000' => 'Augsburg',
	'DE09762000' => 'Kaufbeuren',
	'DE09763000' => 'Kempten (Allgäu)',
	'DE09764000' => 'Memmingen',
	'DE09771111' => 'Adelzhausen',
	'DE09771112' => 'Affing',
	'DE09771113' => 'Aichach, St',
	'DE09771114' => 'Aindling, M',
	'DE09771122' => 'Dasing',
	'DE09771129' => 'Eurasburg',
	'DE09771130' => 'Friedberg, St',
	'DE09771140' => 'Hollenbach',
	'DE09771141' => 'Inchenhofen, M',
	'DE09771142' => 'Kissing',
	'DE09771144' => 'Kühbach, M',
	'DE09771145' => 'Merching',
	'DE09771146' => 'Mering, M',
	'DE09771149' => 'Obergriesbach',
	'DE09771155' => 'Petersdorf',
	'DE09771156' => 'Pöttmes, M',
	'DE09771158' => 'Rehling',
	'DE09771160' => 'Ried',
	'DE09771162' => 'Schiltberg',
	'DE09771163' => 'Schmiechen',
	'DE09771165' => 'Sielenbach',
	'DE09771168' => 'Steindorf',
	'DE09771169' => 'Todtenweis',
	'DE09771176' => 'Baar (Schwaben)',
	'DE09772111' => 'Adelsried',
	'DE09772114' => 'Allmannshofen',
	'DE09772115' => 'Altenmünster',
	'DE09772117' => 'Aystetten',
	'DE09772121' => 'Biberbach, M',
	'DE09772125' => 'Bobingen, St',
	'DE09772126' => 'Bonstetten',
	'DE09772130' => 'Diedorf, M',
	'DE09772131' => 'Dinkelscherben, M',
	'DE09772134' => 'Ehingen',
	'DE09772136' => 'Ellgau',
	'DE09772137' => 'Emersacker',
	'DE09772141' => 'Fischach, M',
	'DE09772145' => 'Gablingen',
	'DE09772147' => 'Gersthofen, St',
	'DE09772148' => 'Gessertshausen',
	'DE09772149' => 'Graben',
	'DE09772151' => 'Großaitingen',
	'DE09772156' => 'Heretsried',
	'DE09772157' => 'Hiltenfingen',
	'DE09772159' => 'Horgau',
	'DE09772160' => 'Kleinaitingen',
	'DE09772162' => 'Klosterlechfeld',
	'DE09772163' => 'Königsbrunn, St',
	'DE09772166' => 'Kühlenthal',
	'DE09772167' => 'Kutzenhausen',
	'DE09772168' => 'Langenneufnach',
	'DE09772170' => 'Langerringen',
	'DE09772171' => 'Langweid a.Lech',
	'DE09772177' => 'Meitingen, M',
	'DE09772178' => 'Mickhausen',
	'DE09772179' => 'Mittelneufnach',
	'DE09772184' => 'Neusäß, St',
	'DE09772185' => 'Nordendorf',
	'DE09772186' => 'Oberottmarshausen',
	'DE09772197' => 'Scherstetten',
	'DE09772200' => 'Schwabmünchen, St',
	'DE09772202' => 'Stadtbergen, St',
	'DE09772207' => 'Thierhaupten, M',
	'DE09772209' => 'Untermeitingen',
	'DE09772211' => 'Ustersbach',
	'DE09772214' => 'Walkertshofen',
	'DE09772215' => 'Wehringen',
	'DE09772216' => 'Welden, M',
	'DE09772217' => 'Westendorf',
	'DE09772223' => 'Zusmarshausen, M',
	'DE09772444' => 'Gdefr. Geb. (Lkr Augsburg)',
	'DE09773111' => 'Aislingen, M',
	'DE09773112' => 'Bachhagel',
	'DE09773113' => 'Bächingen a.d.Brenz',
	'DE09773116' => 'Binswangen',
	'DE09773117' => 'Bissingen, M',
	'DE09773119' => 'Blindheim',
	'DE09773122' => 'Buttenwiesen',
	'DE09773125' => 'Dillingen a.d.Donau, GKSt',
	'DE09773133' => 'Glött',
	'DE09773136' => 'Gundelfingen a.d.Donau, St',
	'DE09773137' => 'Haunsheim',
	'DE09773139' => 'Höchstädt a.d.Donau, St',
	'DE09773140' => 'Holzheim',
	'DE09773143' => 'Laugna',
	'DE09773144' => 'Lauingen (Donau), St',
	'DE09773146' => 'Lutzingen',
	'DE09773147' => 'Mödingen',
	'DE09773150' => 'Finningen',
	'DE09773153' => 'Medlingen',
	'DE09773164' => 'Schwenningen',
	'DE09773170' => 'Syrgenstein',
	'DE09773179' => 'Villenbach',
	'DE09773182' => 'Wertingen, St',
	'DE09773183' => 'Wittislingen, M',
	'DE09773186' => 'Ziertheim',
	'DE09773187' => 'Zöschingen',
	'DE09773188' => 'Zusamaltheim',
	'DE09774111' => 'Aletshausen',
	'DE09774115' => 'Balzhausen',
	'DE09774116' => 'Ursberg',
	'DE09774117' => 'Breitenthal',
	'DE09774118' => 'Bubesheim',
	'DE09774119' => 'Bibertal',
	'DE09774121' => 'Burgau, St',
	'DE09774122' => 'Burtenbach, M',
	'DE09774124' => 'Deisenhausen',
	'DE09774127' => 'Dürrlauingen',
	'DE09774129' => 'Ebershausen',
	'DE09774133' => 'Ellzee',
	'DE09774135' => 'Günzburg, GKSt',
	'DE09774136' => 'Gundremmingen',
	'DE09774140' => 'Haldenwang',
	'DE09774143' => 'Ichenhausen, St',
	'DE09774144' => 'Jettingen-Scheppach, M',
	'DE09774145' => 'Kammeltal',
	'DE09774148' => 'Kötz',
	'DE09774150' => 'Krumbach (Schwaben), St',
	'DE09774151' => 'Landensberg',
	'DE09774155' => 'Leipheim, St',
	'DE09774160' => 'Münsterhausen, M',
	'DE09774162' => 'Neuburg a.d.Kammel, M',
	'DE09774166' => 'Aichen',
	'DE09774171' => 'Offingen, M',
	'DE09774174' => 'Rettenbach',
	'DE09774178' => 'Röfingen',
	'DE09774185' => 'Thannhausen, St',
	'DE09774189' => 'Wiesenbach',
	'DE09774191' => 'Waldstetten, M',
	'DE09774192' => 'Waltenhausen',
	'DE09774196' => 'Winterbach',
	'DE09774198' => 'Ziemetshausen, M',
	'DE09774444' => 'Gdefr. Geb. (Lkr Günzburg)',
	'DE09775111' => 'Altenstadt, M',
	'DE09775115' => 'Bellenberg',
	'DE09775118' => 'Buch, M',
	'DE09775126' => 'Holzheim',
	'DE09775129' => 'Illertissen, St',
	'DE09775132' => 'Kellmünz a.d.Iller, M',
	'DE09775134' => 'Nersingen',
	'DE09775135' => 'Neu-Ulm, GKSt',
	'DE09775139' => 'Elchingen',
	'DE09775141' => 'Oberroth',
	'DE09775142' => 'Osterberg',
	'DE09775143' => 'Pfaffenhofen a.d.Roth, M',
	'DE09775149' => 'Roggenburg',
	'DE09775152' => 'Senden, St',
	'DE09775161' => 'Unterroth',
	'DE09775162' => 'Vöhringen, St',
	'DE09775164' => 'Weißenhorn, St',
	'DE09775444' => 'Gdefr. Geb. (Lkr Neu-Ulm)',
	'DE09776111' => 'Bodolz',
	'DE09776112' => 'Gestratz',
	'DE09776113' => 'Grünenbach',
	'DE09776114' => 'Heimenkirch, M',
	'DE09776115' => 'Hergensweiler',
	'DE09776116' => 'Lindau (Bodensee), GKSt',
	'DE09776117' => 'Lindenberg i.Allgäu, St',
	'DE09776118' => 'Maierhöfen',
	'DE09776120' => 'Nonnenhorn',
	'DE09776121' => 'Oberreute',
	'DE09776122' => 'Opfenbach',
	'DE09776124' => 'Röthenbach (Allgäu)',
	'DE09776125' => 'Scheidegg, M',
	'DE09776126' => 'Sigmarszell',
	'DE09776127' => 'Stiefenhofen',
	'DE09776128' => 'Wasserburg (Bodensee)',
	'DE09776129' => 'Weiler-Simmerberg, M',
	'DE09776130' => 'Weißensberg',
	'DE09776131' => 'Hergatz',
	'DE09777111' => 'Aitrang',
	'DE09777112' => 'Biessenhofen',
	'DE09777114' => 'Baisweil',
	'DE09777118' => 'Bidingen',
	'DE09777121' => 'Buchloe, St',
	'DE09777124' => 'Eggenthal',
	'DE09777125' => 'Eisenberg',
	'DE09777128' => 'Friesenried',
	'DE09777129' => 'Füssen, St',
	'DE09777130' => 'Germaringen',
	'DE09777131' => 'Görisried',
	'DE09777135' => 'Hopferau',
	'DE09777138' => 'Günzach',
	'DE09777139' => 'Irsee, M',
	'DE09777140' => 'Jengen',
	'DE09777141' => 'Kaltental, M',
	'DE09777144' => 'Kraftisried',
	'DE09777145' => 'Lamerdingen',
	'DE09777147' => 'Lechbruck am See',
	'DE09777149' => 'Lengenwang',
	'DE09777151' => 'Marktoberdorf, St',
	'DE09777152' => 'Mauerstetten',
	'DE09777153' => 'Nesselwang, M',
	'DE09777154' => 'Obergünzburg, M',
	'DE09777155' => 'Oberostendorf',
	'DE09777157' => 'Osterzell',
	'DE09777158' => 'Pforzen',
	'DE09777159' => 'Pfronten',
	'DE09777163' => 'Rieden am Forggensee',
	'DE09777164' => 'Rieden',
	'DE09777165' => 'Ronsberg, M',
	'DE09777166' => 'Roßhaupten',
	'DE09777167' => 'Ruderatshofen',
	'DE09777168' => 'Rückholz',
	'DE09777169' => 'Schwangau',
	'DE09777170' => 'Seeg',
	'DE09777171' => 'Stötten a.Auerberg',
	'DE09777172' => 'Stöttwang',
	'DE09777173' => 'Halblech',
	'DE09777175' => 'Unterthingau, M',
	'DE09777176' => 'Untrasried',
	'DE09777177' => 'Waal, M',
	'DE09777179' => 'Wald',
	'DE09777182' => 'Westendorf',
	'DE09777183' => 'Rettenbach a.Auerberg',
	'DE09778111' => 'Amberg',
	'DE09778113' => 'Apfeltrach',
	'DE09778115' => 'Babenhausen, M',
	'DE09778116' => 'Bad Wörishofen, St',
	'DE09778118' => 'Benningen',
	'DE09778119' => 'Böhen',
	'DE09778120' => 'Boos',
	'DE09778121' => 'Breitenbrunn',
	'DE09778123' => 'Buxheim',
	'DE09778127' => 'Dirlewang, M',
	'DE09778130' => 'Egg a.d.Günz',
	'DE09778134' => 'Eppishausen',
	'DE09778136' => 'Erkheim, M',
	'DE09778137' => 'Ettringen',
	'DE09778139' => 'Fellheim',
	'DE09778144' => 'Bad Grönenbach, M',
	'DE09778149' => 'Hawangen',
	'DE09778150' => 'Heimertingen',
	'DE09778151' => 'Holzgünz',
	'DE09778157' => 'Kirchhaslach',
	'DE09778158' => 'Kirchheim i.Schw., M',
	'DE09778161' => 'Kronburg',
	'DE09778162' => 'Lachen',
	'DE09778163' => 'Lauben',
	'DE09778164' => 'Lautrach',
	'DE09778165' => 'Legau, M',
	'DE09778168' => 'Markt Rettenbach, M',
	'DE09778169' => 'Markt Wald, M',
	'DE09778171' => 'Memmingerberg',
	'DE09778173' => 'Mindelheim, St',
	'DE09778177' => 'Niederrieden',
	'DE09778180' => 'Kammlach',
	'DE09778183' => 'Oberrieden',
	'DE09778184' => 'Oberschönegg',
	'DE09778186' => 'Ottobeuren, M',
	'DE09778187' => 'Pfaffenhausen, M',
	'DE09778188' => 'Pleß',
	'DE09778190' => 'Salgen',
	'DE09778196' => 'Sontheim',
	'DE09778199' => 'Stetten',
	'DE09778202' => 'Trunkelsberg',
	'DE09778203' => 'Türkheim, M',
	'DE09778204' => 'Tussenhausen, M',
	'DE09778205' => 'Ungerhausen',
	'DE09778207' => 'Unteregg',
	'DE09778209' => 'Rammingen',
	'DE09778214' => 'Westerheim',
	'DE09778216' => 'Wiedergeltingen',
	'DE09778217' => 'Winterrieden',
	'DE09778218' => 'Wolfertschwenden',
	'DE09778219' => 'Woringen',
	'DE09778221' => 'Kettershausen',
	'DE09778444' => 'Gdefr. Geb. (Lkr Unterallgäu)',
	'DE09779111' => 'Alerheim',
	'DE09779112' => 'Amerdingen',
	'DE09779115' => 'Asbach-Bäumenheim',
	'DE09779117' => 'Auhausen',
	'DE09779126' => 'Buchdorf',
	'DE09779129' => 'Daiting',
	'DE09779130' => 'Deiningen',
	'DE09779131' => 'Donauwörth, GKSt',
	'DE09779136' => 'Ederheim',
	'DE09779138' => 'Ehingen a.Ries',
	'DE09779146' => 'Forheim',
	'DE09779147' => 'Fremdingen',
	'DE09779148' => 'Fünfstetten',
	'DE09779149' => 'Genderkingen',
	'DE09779154' => 'Hainsfarth',
	'DE09779155' => 'Harburg (Schwaben), St',
	'DE09779162' => 'Hohenaltheim',
	'DE09779163' => 'Holzheim',
	'DE09779167' => 'Huisheim',
	'DE09779169' => 'Kaisheim, M',
	'DE09779176' => 'Maihingen',
	'DE09779177' => 'Marktoffingen',
	'DE09779178' => 'Marxheim',
	'DE09779180' => 'Megesheim',
	'DE09779181' => 'Mertingen',
	'DE09779184' => 'Mönchsdeggingen',
	'DE09779185' => 'Möttingen',
	'DE09779186' => 'Monheim, St',
	'DE09779187' => 'Münster',
	'DE09779188' => 'Munningen',
	'DE09779192' => 'Niederschönenfeld',
	'DE09779194' => 'Nördlingen, GKSt',
	'DE09779196' => 'Oberndorf a.Lech',
	'DE09779197' => 'Oettingen i.Bay., St',
	'DE09779198' => 'Otting',
	'DE09779201' => 'Rain, St',
	'DE09779203' => 'Reimlingen',
	'DE09779206' => 'Rögling',
	'DE09779217' => 'Tagmersheim',
	'DE09779218' => 'Tapfheim',
	'DE09779224' => 'Wallerstein, M',
	'DE09779226' => 'Wechingen',
	'DE09779228' => 'Wemding, St',
	'DE09779231' => 'Wolferstadt',
	'DE09779444' => 'Gdefr. Geb. (Lkr Donau-Ries)',
	'DE09780112' => 'Altusried, M',
	'DE09780113' => 'Balderschwang',
	'DE09780114' => 'Betzigau',
	'DE09780115' => 'Blaichach',
	'DE09780116' => 'Bolsterlang',
	'DE09780117' => 'Buchenberg, M',
	'DE09780118' => 'Burgberg i.Allgäu',
	'DE09780119' => 'Dietmannsried, M',
	'DE09780120' => 'Durach',
	'DE09780121' => 'Fischen i.Allgäu',
	'DE09780122' => 'Haldenwang',
	'DE09780123' => 'Bad Hindelang, M',
	'DE09780124' => 'Immenstadt i.Allgäu, St',
	'DE09780125' => 'Lauben',
	'DE09780127' => 'Missen-Wilhams',
	'DE09780128' => 'Oy-Mittelberg',
	'DE09780131' => 'Obermaiselstein',
	'DE09780132' => 'Oberstaufen, M',
	'DE09780133' => 'Oberstdorf, M',
	'DE09780134' => 'Ofterschwang',
	'DE09780137' => 'Rettenberg',
	'DE09780139' => 'Sonthofen, St',
	'DE09780140' => 'Sulzberg, M',
	'DE09780143' => 'Waltenhofen',
	'DE09780144' => 'Weitnau, M',
	'DE09780145' => 'Wertach, M',
	'DE09780146' => 'Wiggensbach, M',
	'DE09780147' => 'Wildpoldsried',
	'DE09780444' => 'Gdefr. Geb. (Lkr Oberallgäu)',
	'DE10041100' => 'Saarbrücken, Landeshauptstadt',
	'DE10041511' => 'Friedrichsthal, Stadt',
	'DE10041512' => 'Großrosseln',
	'DE10041513' => 'Heusweiler',
	'DE10041514' => 'Kleinblittersdorf',
	'DE10041515' => 'Püttlingen, Stadt',
	'DE10041516' => 'Quierschied',
	'DE10041517' => 'Riegelsberg',
	'DE10041518' => 'Sulzbach/ Saar, Stadt',
	'DE10041519' => 'Völklingen, Stadt',
	'DE10042111' => 'Beckingen',
	'DE10042112' => 'Losheim am See',
	'DE10042113' => 'Merzig, Kreisstadt',
	'DE10042114' => 'Mettlach',
	'DE10042115' => 'Perl',
	'DE10042116' => 'Wadern, Stadt',
	'DE10042117' => 'Weiskirchen',
	'DE10043111' => 'Eppelborn',
	'DE10043112' => 'Illingen',
	'DE10043113' => 'Merchweiler',
	'DE10043114' => 'Neunkirchen, Kreisstadt',
	'DE10043115' => 'Ottweiler, Stadt',
	'DE10043116' => 'Schiffweiler',
	'DE10043117' => 'Spiesen-Elversberg',
	'DE10044111' => 'Dillingen/ Saar, Stadt',
	'DE10044112' => 'Lebach, Stadt',
	'DE10044113' => 'Nalbach',
	'DE10044114' => 'Rehlingen-Siersburg',
	'DE10044115' => 'Saarlouis, Kreisstadt',
	'DE10044116' => 'Saarwellingen',
	'DE10044117' => 'Schmelz',
	'DE10044118' => 'Schwalbach',
	'DE10044119' => 'Überherrn',
	'DE10044120' => 'Wadgassen',
	'DE10044121' => 'Wallerfangen',
	'DE10044122' => 'Bous',
	'DE10044123' => 'Ensdorf',
	'DE10045111' => 'Bexbach, Stadt',
	'DE10045112' => 'Blieskastel, Stadt',
	'DE10045113' => 'Gersheim',
	'DE10045114' => 'Homburg, Kreisstadt',
	'DE10045115' => 'Kirkel',
	'DE10045116' => 'Mandelbachtal',
	'DE10045117' => 'St. Ingbert, Stadt',
	'DE10046111' => 'Freisen',
	'DE10046112' => 'Marpingen',
	'DE10046113' => 'Namborn',
	'DE10046114' => 'Nohfelden',
	'DE10046115' => 'Nonnweiler',
	'DE10046116' => 'Oberthal',
	'DE10046117' => 'St. Wendel, Kreisstadt',
	'DE10046118' => 'Tholey',
	'DE11000000' => 'Berlin, Stadt',
	'DE12051000' => 'Brandenburg an der Havel, Stadt',
	'DE12052000' => 'Cottbus, Stadt',
	'DE12053000' => 'Frankfurt (Oder), Stadt',
	'DE12054000' => 'Potsdam, Stadt',
	'DE12060005' => 'Ahrensfelde',
	'DE12060012' => 'Althüttendorf',
	'DE12060020' => 'Bernau bei Berlin, Stadt',
	'DE12060024' => 'Biesenthal, Stadt',
	'DE12060034' => 'Breydin',
	'DE12060036' => 'Britz',
	'DE12060045' => 'Chorin',
	'DE12060052' => 'Eberswalde, Stadt',
	'DE12060068' => 'Friedrichswalde',
	'DE12060092' => 'Hohenfinow',
	'DE12060100' => 'Joachimsthal, Stadt',
	'DE12060128' => 'Liepe',
	'DE12060149' => 'Lunow-Stolzenhagen',
	'DE12060154' => 'Marienwerder',
	'DE12060161' => 'Melchow',
	'DE12060172' => 'Niederfinow',
	'DE12060176' => 'Oderberg, Stadt',
	'DE12060181' => 'Panketal',
	'DE12060185' => 'Parsteinsee',
	'DE12060192' => 'Rüdnitz',
	'DE12060198' => 'Schorfheide',
	'DE12060250' => 'Sydower Fließ',
	'DE12060269' => 'Wandlitz',
	'DE12060280' => 'Werneuchen, Stadt',
	'DE12060296' => 'Ziethen',
	'DE12061005' => 'Alt Zauche-Wußwerk',
	'DE12061017' => 'Bersteland',
	'DE12061020' => 'Bestensee',
	'DE12061061' => 'Byhleguhre-Byhlen',
	'DE12061097' => 'Drahnsdorf',
	'DE12061112' => 'Eichwalde',
	'DE12061164' => 'Golßen, Stadt',
	'DE12061192' => 'Groß Köris',
	'DE12061216' => 'Halbe',
	'DE12061217' => 'Heidesee',
	'DE12061219' => 'Heideblick',
	'DE12061224' => 'Jamlitz',
	'DE12061244' => 'Kasel-Golzig',
	'DE12061260' => 'Königs Wusterhausen, Stadt',
	'DE12061265' => 'Krausnick-Groß Wasserburg',
	'DE12061308' => 'Lieberose, Stadt',
	'DE12061316' => 'Lübben (Spreewald), Stadt',
	'DE12061320' => 'Luckau, Stadt',
	'DE12061328' => 'Märkisch Buchholz, Stadt',
	'DE12061329' => 'Märkische Heide',
	'DE12061332' => 'Mittenwalde, Stadt',
	'DE12061344' => 'Münchehofe',
	'DE12061352' => 'Neu Zauche',
	'DE12061405' => 'Rietzneuendorf-Staakow',
	'DE12061428' => 'Schlepzig',
	'DE12061433' => 'Schönefeld',
	'DE12061435' => 'Schönwald',
	'DE12061444' => 'Schulzendorf',
	'DE12061448' => 'Schwerin',
	'DE12061450' => 'Schwielochsee',
	'DE12061470' => 'Spreewaldheide',
	'DE12061471' => 'Steinreich',
	'DE12061476' => 'Straupitz',
	'DE12061492' => 'Teupitz, Stadt',
	'DE12061510' => 'Unterspreewald',
	'DE12061540' => 'Wildau, Stadt',
	'DE12061572' => 'Zeuthen',
	'DE12062024' => 'Bad Liebenwerda, Stadt',
	'DE12062088' => 'Crinitz',
	'DE12062092' => 'Doberlug-Kirchhain, Stadt',
	'DE12062124' => 'Elsterwerda, Stadt',
	'DE12062128' => 'Falkenberg/Elster, Stadt',
	'DE12062134' => 'Fichtwald',
	'DE12062140' => 'Finsterwalde, Stadt',
	'DE12062177' => 'Gorden-Staupitz',
	'DE12062196' => 'Gröden',
	'DE12062208' => 'Großthiemig',
	'DE12062219' => 'Heideland',
	'DE12062224' => 'Herzberg (Elster), Stadt',
	'DE12062232' => 'Hirschfeld',
	'DE12062237' => 'Hohenbucko',
	'DE12062240' => 'Hohenleipisch',
	'DE12062282' => 'Kremitzaue',
	'DE12062289' => 'Lebusa',
	'DE12062293' => 'Lichterfeld-Schacksdorf',
	'DE12062333' => 'Massen-Niederlausitz',
	'DE12062336' => 'Merzdorf',
	'DE12062341' => 'Mühlberg/Elbe, Stadt',
	'DE12062372' => 'Plessa',
	'DE12062410' => 'Röderland',
	'DE12062417' => 'Rückersdorf',
	'DE12062425' => 'Sallgast',
	'DE12062440' => 'Schilda',
	'DE12062445' => 'Schlieben, Stadt',
	'DE12062453' => 'Schönborn',
	'DE12062461' => 'Schönewalde, Stadt',
	'DE12062464' => 'Schraden',
	'DE12062469' => 'Sonnewalde, Stadt',
	'DE12062492' => 'Tröbitz',
	'DE12062500' => 'Uebigau-Wahrenbrück, Stadt',
	'DE12063036' => 'Brieselang',
	'DE12063056' => 'Dallgow-Döberitz',
	'DE12063080' => 'Falkensee, Stadt',
	'DE12063088' => 'Friesack, Stadt',
	'DE12063094' => 'Gollenberg',
	'DE12063112' => 'Großderschau',
	'DE12063134' => 'Havelaue',
	'DE12063142' => 'Wiesenaue',
	'DE12063148' => 'Ketzin/Havel, Stadt',
	'DE12063161' => 'Kleßen-Görne',
	'DE12063165' => 'Kotzen',
	'DE12063186' => 'Märkisch Luch',
	'DE12063189' => 'Milower Land',
	'DE12063202' => 'Mühlenberge',
	'DE12063208' => 'Nauen, Stadt',
	'DE12063212' => 'Nennhausen',
	'DE12063228' => 'Paulinenaue',
	'DE12063240' => 'Pessin',
	'DE12063244' => 'Premnitz, Stadt',
	'DE12063252' => 'Rathenow, Stadt',
	'DE12063256' => 'Retzow',
	'DE12063260' => 'Rhinow, Stadt',
	'DE12063273' => 'Schönwalde-Glien',
	'DE12063274' => 'Seeblick',
	'DE12063293' => 'Stechow-Ferchesar',
	'DE12063357' => 'Wustermark',
	'DE12064009' => 'Alt Tucheband',
	'DE12064029' => 'Altlandsberg, Stadt',
	'DE12064044' => 'Bad Freienwalde (Oder), Stadt',
	'DE12064053' => 'Beiersdorf-Freudenberg',
	'DE12064057' => 'Bleyen-Genschmar',
	'DE12064061' => 'Bliesdorf',
	'DE12064084' => 'Buckow (Märkische Schweiz), Stadt',
	'DE12064125' => 'Falkenberg',
	'DE12064128' => 'Falkenhagen (Mark)',
	'DE12064130' => 'Fichtenhöhe',
	'DE12064136' => 'Fredersdorf-Vogelsdorf',
	'DE12064153' => 'Garzau-Garzin',
	'DE12064172' => 'Golzow',
	'DE12064190' => 'Gusow-Platkow',
	'DE12064205' => 'Heckelberg-Brunow',
	'DE12064222' => 'Höhenland',
	'DE12064227' => 'Hoppegarten',
	'DE12064266' => 'Küstriner Vorland',
	'DE12064268' => 'Lebus, Stadt',
	'DE12064274' => 'Letschin',
	'DE12064288' => 'Lietzen',
	'DE12064290' => 'Lindendorf',
	'DE12064303' => 'Märkische Höhe',
	'DE12064317' => 'Müncheberg, Stadt',
	'DE12064336' => 'Neuenhagen bei Berlin',
	'DE12064340' => 'Neuhardenberg',
	'DE12064349' => 'Neulewin',
	'DE12064365' => 'Neutrebbin',
	'DE12064370' => 'Oberbarnim',
	'DE12064371' => 'Oderaue',
	'DE12064380' => 'Petershagen/Eggersdorf',
	'DE12064388' => 'Podelzig',
	'DE12064393' => 'Prötzel',
	'DE12064408' => 'Rehfelde',
	'DE12064417' => 'Reichenow-Möglin',
	'DE12064420' => 'Reitwein',
	'DE12064428' => 'Rüdersdorf bei Berlin',
	'DE12064448' => 'Seelow, Stadt',
	'DE12064472' => 'Strausberg, Stadt',
	'DE12064480' => 'Treplin',
	'DE12064482' => 'Vierlinden',
	'DE12064484' => 'Waldsieversdorf',
	'DE12064512' => 'Wriezen, Stadt',
	'DE12064538' => 'Zechin',
	'DE12064539' => 'Zeschdorf',
	'DE12065036' => 'Birkenwerder',
	'DE12065084' => 'Fürstenberg/Havel, Stadt',
	'DE12065096' => 'Glienicke/Nordbahn',
	'DE12065100' => 'Gransee, Stadt',
	'DE12065117' => 'Großwoltersdorf',
	'DE12065136' => 'Hennigsdorf, Stadt',
	'DE12065144' => 'Hohen Neuendorf, Stadt',
	'DE12065165' => 'Kremmen, Stadt',
	'DE12065180' => 'Leegebruch',
	'DE12065193' => 'Liebenwalde, Stadt',
	'DE12065198' => 'Löwenberger Land',
	'DE12065225' => 'Mühlenbecker Land',
	'DE12065251' => 'Oberkrämer',
	'DE12065256' => 'Oranienburg, Stadt',
	'DE12065276' => 'Schönermark',
	'DE12065301' => 'Sonnenberg',
	'DE12065310' => 'Stechlin',
	'DE12065332' => 'Velten, Stadt',
	'DE12065356' => 'Zehdenick, Stadt',
	'DE12066008' => 'Altdöbern',
	'DE12066041' => 'Bronkow',
	'DE12066052' => 'Calau, Stadt',
	'DE12066064' => 'Frauendorf',
	'DE12066104' => 'Großkmehlen',
	'DE12066112' => 'Großräschen, Stadt',
	'DE12066116' => 'Grünewald',
	'DE12066120' => 'Guteborn',
	'DE12066124' => 'Hermsdorf',
	'DE12066132' => 'Hohenbocka',
	'DE12066168' => 'Kroppen',
	'DE12066176' => 'Lauchhammer, Stadt',
	'DE12066188' => 'Lindenau',
	'DE12066196' => 'Lübbenau/Spreewald, Stadt',
	'DE12066202' => 'Luckaitztal',
	'DE12066226' => 'Neu-Seeland',
	'DE12066228' => 'Neupetershain',
	'DE12066240' => 'Ortrand, Stadt',
	'DE12066272' => 'Ruhland, Stadt',
	'DE12066285' => 'Schipkau',
	'DE12066292' => 'Schwarzbach',
	'DE12066296' => 'Schwarzheide, Stadt',
	'DE12066304' => 'Senftenberg, Stadt',
	'DE12066316' => 'Tettau',
	'DE12066320' => 'Vetschau/Spreewald, Stadt',
	'DE12067024' => 'Bad Saarow',
	'DE12067036' => 'Beeskow, Stadt',
	'DE12067040' => 'Berkenbrück',
	'DE12067072' => 'Briesen (Mark)',
	'DE12067076' => 'Brieskow-Finkenheerd',
	'DE12067112' => 'Diensdorf-Radlow',
	'DE12067120' => 'Eisenhüttenstadt, Stadt',
	'DE12067124' => 'Erkner, Stadt',
	'DE12067137' => 'Friedland, Stadt',
	'DE12067144' => 'Fürstenwalde/Spree, Stadt',
	'DE12067173' => 'Gosen-Neu Zittau',
	'DE12067180' => 'Groß Lindow',
	'DE12067201' => 'Grünheide (Mark)',
	'DE12067205' => 'Grunow-Dammendorf',
	'DE12067237' => 'Jacobsdorf',
	'DE12067288' => 'Langewahl',
	'DE12067292' => 'Lawitz',
	'DE12067324' => 'Mixdorf',
	'DE12067336' => 'Müllrose, Stadt',
	'DE12067338' => 'Neißemünde',
	'DE12067357' => 'Neuzelle',
	'DE12067397' => 'Ragow-Merz',
	'DE12067408' => 'Rauen',
	'DE12067413' => 'Reichenwalde',
	'DE12067426' => 'Rietz-Neuendorf',
	'DE12067438' => 'Schlaubetal',
	'DE12067440' => 'Schöneiche bei Berlin',
	'DE12067458' => 'Siehdichum',
	'DE12067469' => 'Spreenhagen',
	'DE12067473' => 'Steinhöfel',
	'DE12067481' => 'Storkow (Mark), Stadt',
	'DE12067493' => 'Tauche',
	'DE12067508' => 'Vogelsang',
	'DE12067520' => 'Wendisch Rietz',
	'DE12067528' => 'Wiesenau',
	'DE12067544' => 'Woltersdorf',
	'DE12067552' => 'Ziltendorf',
	'DE12068052' => 'Breddin',
	'DE12068072' => 'Dabergotz',
	'DE12068109' => 'Dreetz',
	'DE12068117' => 'Fehrbellin',
	'DE12068181' => 'Heiligengrabe',
	'DE12068188' => 'Herzberg (Mark)',
	'DE12068264' => 'Kyritz, Stadt',
	'DE12068280' => 'Lindow (Mark), Stadt',
	'DE12068306' => 'Märkisch Linden',
	'DE12068320' => 'Neuruppin, Stadt',
	'DE12068324' => 'Neustadt (Dosse), Stadt',
	'DE12068353' => 'Rheinsberg, Stadt',
	'DE12068372' => 'Rüthnick',
	'DE12068409' => 'Sieversdorf-Hohenofen',
	'DE12068413' => 'Storbeck-Frankendorf',
	'DE12068417' => 'Stüdenitz-Schönermark',
	'DE12068425' => 'Temnitzquell',
	'DE12068426' => 'Temnitztal',
	'DE12068437' => 'Vielitzsee',
	'DE12068452' => 'Walsleben',
	'DE12068468' => 'Wittstock/Dosse, Stadt',
	'DE12068477' => 'Wusterhausen/Dosse',
	'DE12068501' => 'Zernitz-Lohm',
	'DE12069017' => 'Beelitz, Stadt',
	'DE12069018' => 'Beetzsee',
	'DE12069019' => 'Beetzseeheide',
	'DE12069020' => 'Bad Belzig, Stadt',
	'DE12069028' => 'Bensdorf',
	'DE12069052' => 'Borkheide',
	'DE12069056' => 'Borkwalde',
	'DE12069076' => 'Brück, Stadt',
	'DE12069089' => 'Buckautal',
	'DE12069216' => 'Golzow',
	'DE12069224' => 'Görzke',
	'DE12069232' => 'Gräben',
	'DE12069249' => 'Groß Kreutz (Havel)',
	'DE12069270' => 'Havelsee, Stadt',
	'DE12069304' => 'Kleinmachnow',
	'DE12069306' => 'Kloster Lehnin',
	'DE12069345' => 'Linthe',
	'DE12069397' => 'Michendorf',
	'DE12069402' => 'Mühlenfließ',
	'DE12069448' => 'Niemegk, Stadt',
	'DE12069454' => 'Nuthetal',
	'DE12069460' => 'Päwesin',
	'DE12069470' => 'Planebruch',
	'DE12069474' => 'Planetal',
	'DE12069485' => 'Rabenstein/Fläming',
	'DE12069537' => 'Rosenau',
	'DE12069541' => 'Roskow',
	'DE12069590' => 'Schwielowsee',
	'DE12069596' => 'Seddiner See',
	'DE12069604' => 'Stahnsdorf',
	'DE12069616' => 'Teltow, Stadt',
	'DE12069632' => 'Treuenbrietzen, Stadt',
	'DE12069648' => 'Wenzlow',
	'DE12069656' => 'Werder (Havel), Stadt',
	'DE12069665' => 'Wiesenburg/Mark',
	'DE12069680' => 'Wollin',
	'DE12069688' => 'Wusterwitz',
	'DE12069696' => 'Ziesar, Stadt',
	'DE12070008' => 'Bad Wilsnack, Stadt',
	'DE12070028' => 'Berge',
	'DE12070052' => 'Breese',
	'DE12070060' => 'Cumlosen',
	'DE12070096' => 'Gerdshagen',
	'DE12070125' => 'Groß Pankow (Prignitz)',
	'DE12070145' => 'Gülitz-Reetz',
	'DE12070149' => 'Gumtow',
	'DE12070153' => 'Halenbeck-Rohlsdorf',
	'DE12070173' => 'Karstädt',
	'DE12070222' => 'Kümmernitztal',
	'DE12070236' => 'Lanz',
	'DE12070241' => 'Legde/Quitzöbel',
	'DE12070244' => 'Lenzen (Elbe), Stadt',
	'DE12070246' => 'Lenzerwische',
	'DE12070266' => 'Marienfließ',
	'DE12070280' => 'Meyenburg, Stadt',
	'DE12070296' => 'Perleberg, Stadt',
	'DE12070300' => 'Pirow',
	'DE12070302' => 'Plattenburg',
	'DE12070316' => 'Pritzwalk, Stadt',
	'DE12070325' => 'Putlitz, Stadt',
	'DE12070348' => 'Rühstädt',
	'DE12070393' => 'Triglitz',
	'DE12070416' => 'Weisen',
	'DE12070424' => 'Wittenberge, Stadt',
	'DE12071028' => 'Briesen',
	'DE12071032' => 'Burg (Spreewald)',
	'DE12071041' => 'Dissen-Striesow',
	'DE12071044' => 'Döbern, Stadt',
	'DE12071052' => 'Drachhausen',
	'DE12071057' => 'Drebkau, Stadt',
	'DE12071060' => 'Drehnow',
	'DE12071074' => 'Felixsee',
	'DE12071076' => 'Forst (Lausitz), Stadt',
	'DE12071153' => 'Groß Schacksdorf-Simmersdorf',
	'DE12071160' => 'Guben, Stadt',
	'DE12071164' => 'Guhrow',
	'DE12071176' => 'Heinersbrück',
	'DE12071189' => 'Jämlitz-Klein Düben',
	'DE12071193' => 'Jänschwalde',
	'DE12071244' => 'Kolkwitz',
	'DE12071294' => 'Neiße-Malxetal',
	'DE12071301' => 'Neuhausen/Spree',
	'DE12071304' => 'Peitz, Stadt',
	'DE12071337' => 'Schenkendöbern',
	'DE12071341' => 'Schmogrow-Fehrow',
	'DE12071372' => 'Spremberg, Stadt',
	'DE12071384' => 'Tauer',
	'DE12071386' => 'Teichland',
	'DE12071392' => 'Tschernitz',
	'DE12071401' => 'Turnow-Preilack',
	'DE12071408' => 'Welzow, Stadt',
	'DE12071412' => 'Werben',
	'DE12071414' => 'Wiesengrund',
	'DE12072002' => 'Am Mellensee',
	'DE12072014' => 'Baruth/Mark, Stadt',
	'DE12072017' => 'Blankenfelde-Mahlow',
	'DE12072053' => 'Dahme/Mark, Stadt',
	'DE12072055' => 'Dahmetal',
	'DE12072120' => 'Großbeeren',
	'DE12072157' => 'Ihlow',
	'DE12072169' => 'Jüterbog, Stadt',
	'DE12072232' => 'Luckenwalde, Stadt',
	'DE12072240' => 'Ludwigsfelde, Stadt',
	'DE12072297' => 'Niedergörsdorf',
	'DE12072298' => 'Niederer Fläming',
	'DE12072312' => 'Nuthe-Urstromtal',
	'DE12072340' => 'Rangsdorf',
	'DE12072426' => 'Trebbin, Stadt',
	'DE12072477' => 'Zossen, Stadt',
	'DE12073008' => 'Angermünde, Stadt',
	'DE12073032' => 'Berkholz-Meyenburg',
	'DE12073069' => 'Boitzenburger Land',
	'DE12073085' => 'Brüssow, Stadt',
	'DE12073093' => 'Carmzow-Wallmow',
	'DE12073097' => 'Casekow',
	'DE12073157' => 'Flieth-Stegelitz',
	'DE12073189' => 'Gartz (Oder), Stadt',
	'DE12073201' => 'Gerswalde',
	'DE12073216' => 'Göritz',
	'DE12073225' => 'Gramzow',
	'DE12073261' => 'Grünow',
	'DE12073309' => 'Hohenselchow-Groß Pinnow',
	'DE12073384' => 'Lychen, Stadt',
	'DE12073386' => 'Mark Landin',
	'DE12073393' => 'Mescherin',
	'DE12073396' => 'Milmersdorf',
	'DE12073404' => 'Mittenwalde',
	'DE12073429' => 'Nordwestuckermark',
	'DE12073430' => 'Oberuckersee',
	'DE12073440' => 'Pinnow',
	'DE12073452' => 'Prenzlau, Stadt',
	'DE12073458' => 'Randowtal',
	'DE12073490' => 'Schenkenberg',
	'DE12073505' => 'Schöneberg',
	'DE12073520' => 'Schönfeld',
	'DE12073532' => 'Schwedt/Oder, Stadt',
	'DE12073565' => 'Tantow',
	'DE12073569' => 'Temmen-Ringenwalde',
	'DE12073572' => 'Templin, Stadt',
	'DE12073578' => 'Uckerfelde',
	'DE12073579' => 'Uckerland',
	'DE12073603' => 'Passow',
	'DE12073645' => 'Zichow',
	'DE13003000' => 'Rostock, Hansestadt',
	'DE13004000' => 'Schwerin, Landeshauptstadt',
	'DE13071001' => 'Alt Schwerin',
	'DE13071002' => 'Altenhagen',
	'DE13071003' => 'Altenhof',
	'DE13071004' => 'Altentreptow, Stadt',
	'DE13071005' => 'Ankershagen',
	'DE13071006' => 'Bartow',
	'DE13071007' => 'Basedow',
	'DE13071008' => 'Beggerow',
	'DE13071009' => 'Beseritz',
	'DE13071010' => 'Blankenhof',
	'DE13071011' => 'Blankensee',
	'DE13071012' => 'Blumenholz',
	'DE13071013' => 'Bollewick',
	'DE13071014' => 'Borrentin',
	'DE13071015' => 'Bredenfelde',
	'DE13071016' => 'Breesen',
	'DE13071017' => 'Breest',
	'DE13071018' => 'Briggow',
	'DE13071019' => 'Brunn',
	'DE13071020' => 'Buchholz',
	'DE13071021' => 'Burg Stargard, Stadt',
	'DE13071022' => 'Burow',
	'DE13071023' => 'Bütow',
	'DE13071025' => 'Carpin',
	'DE13071026' => 'Cölpin',
	'DE13071027' => 'Dargun, Stadt',
	'DE13071028' => 'Datzetal',
	'DE13071029' => 'Demmin, Hansestadt',
	'DE13071030' => 'Duckow',
	'DE13071032' => 'Faulenrost',
	'DE13071033' => 'Feldberger Seenlandschaft',
	'DE13071034' => 'Fincken',
	'DE13071035' => 'Friedland, Stadt',
	'DE13071036' => 'Fünfseen',
	'DE13071037' => 'Galenbeck',
	'DE13071038' => 'Genzkow',
	'DE13071039' => 'Gielow',
	'DE13071041' => 'Gnevkow',
	'DE13071042' => 'Godendorf',
	'DE13071043' => 'Göhren-Lebbin',
	'DE13071044' => 'Golchen',
	'DE13071045' => 'Gotthun',
	'DE13071046' => 'Grabow-Below',
	'DE13071047' => 'Grabowhöfe',
	'DE13071048' => 'Grammentin',
	'DE13071049' => 'Grapzow',
	'DE13071050' => 'Grischow',
	'DE13071053' => 'Groß Kelle',
	'DE13071054' => 'Groß Miltzow',
	'DE13071055' => 'Groß Nemerow',
	'DE13071056' => 'Groß Plasten',
	'DE13071057' => 'Groß Teetzleben',
	'DE13071058' => 'Grünow',
	'DE13071059' => 'Gültz',
	'DE13071060' => 'Gülzow',
	'DE13071063' => 'Hohen Wangelin',
	'DE13071064' => 'Hohenbollentin',
	'DE13071065' => 'Hohenmocker',
	'DE13071066' => 'Hohenzieritz',
	'DE13071067' => 'Holldorf',
	'DE13071068' => 'Ivenack',
	'DE13071069' => 'Jabel',
	'DE13071070' => 'Jürgenstorf',
	'DE13071071' => 'Kargow',
	'DE13071072' => 'Kentzlin',
	'DE13071073' => 'Kieve',
	'DE13071074' => 'Kittendorf',
	'DE13071075' => 'Klein Vielen',
	'DE13071076' => 'Kletzin',
	'DE13071077' => 'Klink',
	'DE13071078' => 'Klocksin',
	'DE13071079' => 'Knorrendorf',
	'DE13071080' => 'Kratzeburg',
	'DE13071081' => 'Kriesow',
	'DE13071083' => 'Kublank',
	'DE13071084' => 'Kummerow',
	'DE13071087' => 'Lärz',
	'DE13071088' => 'Leizen',
	'DE13071089' => 'Lindenberg',
	'DE13071090' => 'Lindetal',
	'DE13071091' => 'Ludorf',
	'DE13071092' => 'Malchin, Stadt',
	'DE13071093' => 'Malchow, Stadt',
	'DE13071095' => 'Massow',
	'DE13071096' => 'Meesiger',
	'DE13071097' => 'Melz',
	'DE13071099' => 'Mirow, Stadt',
	'DE13071100' => 'Möllenbeck',
	'DE13071101' => 'Möllenhagen',
	'DE13071102' => 'Mölln',
	'DE13071103' => 'Moltzow',
	'DE13071104' => 'Neddemin',
	'DE13071105' => 'Neetzka',
	'DE13071107' => 'Neubrandenburg, Stadt',
	'DE13071108' => 'Neuenkirchen',
	'DE13071109' => 'Neukalen, Stadt',
	'DE13071110' => 'Neustrelitz, Stadt',
	'DE13071111' => 'Neverin',
	'DE13071112' => 'Nossendorf',
	'DE13071113' => 'Nossentiner Hütte',
	'DE13071114' => 'Penkow',
	'DE13071115' => 'Penzlin, Stadt',
	'DE13071116' => 'Petersdorf',
	'DE13071117' => 'Pragsdorf',
	'DE13071118' => 'Priborn',
	'DE13071119' => 'Priepert',
	'DE13071120' => 'Pripsleben',
	'DE13071122' => 'Rechlin',
	'DE13071123' => 'Ritzerow',
	'DE13071124' => 'Röbel/Müritz, Stadt',
	'DE13071125' => 'Röckwitz',
	'DE13071127' => 'Rosenow',
	'DE13071128' => 'Sarow',
	'DE13071130' => 'Schönbeck',
	'DE13071131' => 'Schönfeld',
	'DE13071132' => 'Schönhausen',
	'DE13071133' => 'Schwarz',
	'DE13071135' => 'Siedenbollentin',
	'DE13071136' => 'Siedenbrünzow',
	'DE13071137' => 'Sietow',
	'DE13071138' => 'Silz',
	'DE13071139' => 'Sommersdorf',
	'DE13071140' => 'Sponholz',
	'DE13071141' => 'Staven',
	'DE13071142' => 'Stavenhagen, Reuterstadt, Stadt',
	'DE13071143' => 'Stuer',
	'DE13071144' => 'Torgelow am See',
	'DE13071145' => 'Trollenhagen',
	'DE13071146' => 'Tützpatz',
	'DE13071147' => 'Userin',
	'DE13071148' => 'Utzedel',
	'DE13071149' => 'Varchentin',
	'DE13071150' => 'Verchen',
	'DE13071152' => 'Vipperow',
	'DE13071153' => 'Voigtsdorf',
	'DE13071154' => 'Vollrathsruhe',
	'DE13071155' => 'Walow',
	'DE13071156' => 'Waren (Müritz), Stadt',
	'DE13071157' => 'Warrenzin',
	'DE13071158' => 'Werder',
	'DE13071159' => 'Wesenberg, Stadt',
	'DE13071160' => 'Wildberg',
	'DE13071161' => 'Woggersin',
	'DE13071162' => 'Wokuhl-Dabelow',
	'DE13071163' => 'Wolde',
	'DE13071164' => 'Woldegk, Stadt',
	'DE13071165' => 'Wredenhagen',
	'DE13071166' => 'Wulkenzin',
	'DE13071167' => 'Wustrow',
	'DE13071168' => 'Zepkow',
	'DE13071169' => 'Zettemin',
	'DE13071170' => 'Zirzow',
	'DE13071171' => 'Zislow',
	'DE13071172' => 'Peenehagen',
	'DE13071173' => 'Kuckssee',
	'DE13071174' => 'Schloen-Dratow',
	'DE13072001' => 'Admannshagen-Bargeshagen',
	'DE13072002' => 'Alt Bukow',
	'DE13072003' => 'Alt Sührkow',
	'DE13072004' => 'Altkalen',
	'DE13072005' => 'Am Salzhaff',
	'DE13072006' => 'Bad Doberan, Stadt',
	'DE13072007' => 'Bartenshagen-Parkentin',
	'DE13072008' => 'Bastorf',
	'DE13072009' => 'Baumgarten',
	'DE13072010' => 'Behren-Lübchin',
	'DE13072011' => 'Benitz',
	'DE13072012' => 'Bentwisch',
	'DE13072013' => 'Bernitt',
	'DE13072014' => 'Biendorf',
	'DE13072015' => 'Blankenhagen',
	'DE13072016' => 'Boddin',
	'DE13072017' => 'Börgerende-Rethwisch',
	'DE13072018' => 'Bröbberow',
	'DE13072019' => 'Broderstorf',
	'DE13072020' => 'Bützow, Stadt',
	'DE13072021' => 'Cammin',
	'DE13072022' => 'Carinerland',
	'DE13072023' => 'Dahmen',
	'DE13072024' => 'Dalkendorf',
	'DE13072025' => 'Diekhof',
	'DE13072026' => 'Dobbin-Linstow',
	'DE13072027' => 'Dolgen am See',
	'DE13072028' => 'Dreetz',
	'DE13072029' => 'Dummerstorf',
	'DE13072030' => 'Elmenhorst/Lichtenhagen',
	'DE13072031' => 'Finkenthal',
	'DE13072032' => 'Gelbensande',
	'DE13072033' => 'Glasewitz',
	'DE13072034' => 'Gnewitz',
	'DE13072035' => 'Gnoien, Stadt',
	'DE13072036' => 'Graal-Müritz',
	'DE13072037' => 'Grammow',
	'DE13072038' => 'Groß Roge',
	'DE13072039' => 'Groß Schwiesow',
	'DE13072040' => 'Groß Wokern',
	'DE13072041' => 'Groß Wüstenfelde',
	'DE13072042' => 'Gülzow-Prüzen',
	'DE13072043' => 'Güstrow, Stadt',
	'DE13072044' => 'Gutow',
	'DE13072045' => 'Hohen Demzin',
	'DE13072046' => 'Hohen Sprenz',
	'DE13072047' => 'Hohenfelde',
	'DE13072048' => 'Hoppenrade',
	'DE13072049' => 'Jördenstorf',
	'DE13072050' => 'Jürgenshagen',
	'DE13072051' => 'Kassow',
	'DE13072052' => 'Kirch Mulsow',
	'DE13072053' => 'Klein Belitz',
	'DE13072055' => 'Klein Upahl',
	'DE13072056' => 'Krakow am See, Stadt',
	'DE13072057' => 'Kritzmow',
	'DE13072058' => 'Kröpelin, Stadt',
	'DE13072059' => 'Kuchelmiß',
	'DE13072060' => 'Kühlungsborn, Stadt',
	'DE13072061' => 'Kuhs',
	'DE13072062' => 'Laage, Stadt',
	'DE13072063' => 'Lalendorf',
	'DE13072064' => 'Lambrechtshagen',
	'DE13072066' => 'Lelkendorf',
	'DE13072067' => 'Lohmen',
	'DE13072068' => 'Lühburg',
	'DE13072069' => 'Lüssow',
	'DE13072071' => 'Mistorf',
	'DE13072072' => 'Mönchhagen',
	'DE13072073' => 'Mühl Rosin',
	'DE13072074' => 'Neubukow, Stadt',
	'DE13072075' => 'Nienhagen',
	'DE13072076' => 'Nustrow',
	'DE13072077' => 'Papendorf',
	'DE13072078' => 'Penzin',
	'DE13072079' => 'Plaaz',
	'DE13072080' => 'Pölchow',
	'DE13072081' => 'Poppendorf',
	'DE13072082' => 'Prebberede',
	'DE13072083' => 'Reddelich',
	'DE13072084' => 'Reimershagen',
	'DE13072085' => 'Rerik, Stadt',
	'DE13072086' => 'Retschow',
	'DE13072087' => 'Roggentin',
	'DE13072088' => 'Rövershagen',
	'DE13072089' => 'Rühn',
	'DE13072090' => 'Rukieten',
	'DE13072091' => 'Sanitz',
	'DE13072092' => 'Sarmstorf',
	'DE13072093' => 'Satow',
	'DE13072094' => 'Schorssow',
	'DE13072095' => 'Schwaan, Stadt',
	'DE13072096' => 'Schwasdorf',
	'DE13072097' => 'Selpin',
	'DE13072098' => 'Stäbelow',
	'DE13072099' => 'Steffenshagen',
	'DE13072101' => 'Steinhagen',
	'DE13072102' => 'Stubbendorf',
	'DE13072103' => 'Sukow-Levitzow',
	'DE13072104' => 'Tarnow',
	'DE13072105' => 'Tessin, Stadt',
	'DE13072106' => 'Teterow, Stadt',
	'DE13072107' => 'Thelkow',
	'DE13072108' => 'Thulendorf',
	'DE13072109' => 'Thürkow',
	'DE13072110' => 'Vorbeck',
	'DE13072111' => 'Walkendorf',
	'DE13072112' => 'Wardow',
	'DE13072113' => 'Warnkenhagen',
	'DE13072114' => 'Warnow',
	'DE13072116' => 'Wiendorf',
	'DE13072117' => 'Wittenbeck',
	'DE13072118' => 'Zarnewanz',
	'DE13072119' => 'Zehna',
	'DE13072120' => 'Zepelin',
	'DE13072121' => 'Ziesendorf',
	'DE13073001' => 'Ahrenshagen-Daskow',
	'DE13073002' => 'Ahrenshoop',
	'DE13073003' => 'Altefähr',
	'DE13073004' => 'Altenkirchen',
	'DE13073005' => 'Altenpleen',
	'DE13073006' => 'Baabe',
	'DE13073007' => 'Bad Sülze, Stadt',
	'DE13073009' => 'Barth, Stadt',
	'DE13073010' => 'Bergen auf Rügen, Stadt',
	'DE13073011' => 'Binz',
	'DE13073012' => 'Born a. Darß',
	'DE13073013' => 'Breege',
	'DE13073014' => 'Buschvitz',
	'DE13073015' => 'Dettmannsdorf',
	'DE13073016' => 'Deyelsdorf',
	'DE13073017' => 'Dierhagen',
	'DE13073018' => 'Divitz-Spoldershagen',
	'DE13073019' => 'Dranske',
	'DE13073020' => 'Drechow',
	'DE13073021' => 'Dreschvitz',
	'DE13073022' => 'Eixen',
	'DE13073023' => 'Elmenhorst',
	'DE13073024' => 'Franzburg, Stadt',
	'DE13073025' => 'Fuhlendorf',
	'DE13073027' => 'Garz/Rügen, Stadt',
	'DE13073028' => 'Gingst',
	'DE13073029' => 'Glewitz',
	'DE13073030' => 'Glowe',
	'DE13073031' => 'Göhren',
	'DE13073032' => 'Grammendorf',
	'DE13073033' => 'Gransebieth',
	'DE13073034' => 'Gremersdorf-Buchholz',
	'DE13073035' => 'Grimmen, Stadt',
	'DE13073036' => 'Groß Kordshagen',
	'DE13073037' => 'Groß Mohrdorf',
	'DE13073038' => 'Gustow',
	'DE13073039' => 'Hugoldsdorf',
	'DE13073040' => 'Insel Hiddensee',
	'DE13073041' => 'Jakobsdorf',
	'DE13073042' => 'Karnin',
	'DE13073043' => 'Kenz-Küstrow',
	'DE13073044' => 'Klausdorf',
	'DE13073045' => 'Kluis',
	'DE13073046' => 'Kramerhof',
	'DE13073047' => 'Kummerow',
	'DE13073048' => 'Lancken-Granitz',
	'DE13073049' => 'Lietzow',
	'DE13073050' => 'Lindholz',
	'DE13073051' => 'Löbnitz',
	'DE13073052' => 'Lohme',
	'DE13073053' => 'Lüdershagen',
	'DE13073054' => 'Lüssow',
	'DE13073055' => 'Marlow, Stadt',
	'DE13073057' => 'Millienhagen-Oebelitz',
	'DE13073058' => 'Neu Bartelshagen',
	'DE13073059' => 'Neuenkirchen',
	'DE13073060' => 'Niepars',
	'DE13073061' => 'Pantelitz',
	'DE13073062' => 'Papenhagen',
	'DE13073063' => 'Parchtitz',
	'DE13073064' => 'Patzig',
	'DE13073065' => 'Poseritz',
	'DE13073066' => 'Preetz',
	'DE13073067' => 'Prerow',
	'DE13073068' => 'Prohn',
	'DE13073069' => 'Pruchten',
	'DE13073070' => 'Putbus, Stadt',
	'DE13073071' => 'Putgarten',
	'DE13073072' => 'Ralswiek',
	'DE13073073' => 'Rambin',
	'DE13073074' => 'Rappin',
	'DE13073075' => 'Ribnitz-Damgarten, Stadt',
	'DE13073076' => 'Richtenberg, Stadt',
	'DE13073077' => 'Saal',
	'DE13073078' => 'Sagard',
	'DE13073079' => 'Samtens',
	'DE13073080' => 'Sassnitz, Stadt',
	'DE13073081' => 'Schaprode',
	'DE13073082' => 'Schlemmin',
	'DE13073083' => 'Sehlen',
	'DE13073084' => 'Sellin',
	'DE13073085' => 'Semlow',
	'DE13073086' => 'Splietsdorf',
	'DE13073087' => 'Steinhagen',
	'DE13073088' => 'Stralsund, Hansestadt',
	'DE13073089' => 'Süderholz',
	'DE13073090' => 'Sundhagen ',
	'DE13073092' => 'Trent',
	'DE13073093' => 'Tribsees, Stadt',
	'DE13073094' => 'Trinwillershagen',
	'DE13073095' => 'Ummanz',
	'DE13073096' => 'Velgast',
	'DE13073097' => 'Weitenhagen',
	'DE13073098' => 'Wendisch Baggendorf',
	'DE13073099' => 'Wendorf',
	'DE13073100' => 'Wieck a. Darß',
	'DE13073101' => 'Wiek',
	'DE13073102' => 'Wittenhagen',
	'DE13073103' => 'Wustrow',
	'DE13073104' => 'Zarrendorf',
	'DE13073105' => 'Zingst',
	'DE13073106' => 'Zirkow',
	'DE13073107' => 'Mönchgut',
	'DE13074001' => 'Alt Meteln',
	'DE13074002' => 'Bad Kleinen',
	'DE13074003' => 'Barnekow',
	'DE13074004' => 'Benz',
	'DE13074005' => 'Bernstorf',
	'DE13074006' => 'Bibow',
	'DE13074007' => 'Blowatz',
	'DE13074008' => 'Bobitz',
	'DE13074009' => 'Boiensdorf',
	'DE13074010' => 'Boltenhagen',
	'DE13074012' => 'Brüsewitz',
	'DE13074013' => 'Carlow',
	'DE13074014' => 'Cramonshagen',
	'DE13074015' => 'Dalberg-Wendelstorf',
	'DE13074016' => 'Damshagen ',
	'DE13074017' => 'Dassow, Stadt',
	'DE13074018' => 'Dechow',
	'DE13074019' => 'Dorf Mecklenburg',
	'DE13074020' => 'Dragun',
	'DE13074021' => 'Gadebusch, Stadt',
	'DE13074022' => 'Gägelow',
	'DE13074023' => 'Glasin',
	'DE13074024' => 'Gottesgabe',
	'DE13074025' => 'Grambow',
	'DE13074026' => 'Grevesmühlen, Stadt',
	'DE13074027' => 'Grieben',
	'DE13074028' => 'Groß Molzahn',
	'DE13074029' => 'Groß Siemz',
	'DE13074030' => 'Groß Stieten',
	'DE13074031' => 'Hohen Viecheln',
	'DE13074032' => 'Hohenkirchen',
	'DE13074033' => 'Holdorf',
	'DE13074034' => 'Hornstorf',
	'DE13074035' => 'Insel Poel',
	'DE13074036' => 'Jesendorf',
	'DE13074037' => 'Kalkhorst',
	'DE13074038' => 'Klein Trebbow',
	'DE13074039' => 'Klütz, Stadt',
	'DE13074040' => 'Kneese',
	'DE13074042' => 'Königsfeld',
	'DE13074043' => 'Krembz',
	'DE13074044' => 'Krusenhagen',
	'DE13074045' => 'Lockwisch',
	'DE13074046' => 'Lübberstorf',
	'DE13074047' => 'Lübow',
	'DE13074048' => 'Lübstorf',
	'DE13074049' => 'Lüdersdorf',
	'DE13074050' => 'Lützow',
	'DE13074052' => 'Menzendorf',
	'DE13074053' => 'Metelsdorf',
	'DE13074054' => 'Mühlen Eichsen',
	'DE13074056' => 'Neuburg',
	'DE13074057' => 'Neukloster, Stadt',
	'DE13074058' => 'Niendorf',
	'DE13074060' => 'Passee',
	'DE13074061' => 'Perlin',
	'DE13074062' => 'Pingelshagen',
	'DE13074063' => 'Plüschow',
	'DE13074064' => 'Pokrent',
	'DE13074065' => 'Rehna, Stadt',
	'DE13074066' => 'Rieps',
	'DE13074067' => 'Roduchelstorf',
	'DE13074068' => 'Roggendorf',
	'DE13074069' => 'Roggenstorf',
	'DE13074070' => 'Rögnitz',
	'DE13074071' => 'Rüting',
	'DE13074072' => 'Schildetal ',
	'DE13074073' => 'Schlagsdorf',
	'DE13074074' => 'Schönberg, Stadt',
	'DE13074075' => 'Seehof',
	'DE13074076' => 'Selmsdorf',
	'DE13074077' => 'Testorf-Steinfort',
	'DE13074078' => 'Thandorf',
	'DE13074079' => 'Upahl',
	'DE13074080' => 'Utecht',
	'DE13074081' => 'Veelböken',
	'DE13074082' => 'Ventschow',
	'DE13074084' => 'Warin, Stadt',
	'DE13074085' => 'Warnow',
	'DE13074087' => 'Wismar, Hansestadt',
	'DE13074088' => 'Zickhusen',
	'DE13074089' => 'Zierow',
	'DE13074090' => 'Zurow',
	'DE13074091' => 'Züsow',
	'DE13074092' => 'Wedendorfersee',
	'DE13074093' => 'Stepenitztal',
	'DE13075001' => 'Ahlbeck',
	'DE13075002' => 'Alt Tellin',
	'DE13075003' => 'Altwarp',
	'DE13075004' => 'Altwigshagen',
	'DE13075005' => 'Anklam, Stadt',
	'DE13075006' => 'Bandelin',
	'DE13075007' => 'Bargischow',
	'DE13075008' => 'Behrenhoff',
	'DE13075009' => 'Bentzin',
	'DE13075010' => 'Benz',
	'DE13075011' => 'Bergholz',
	'DE13075012' => 'Blankensee',
	'DE13075013' => 'Blesewitz',
	'DE13075015' => 'Boldekow',
	'DE13075016' => 'Boock',
	'DE13075017' => 'Brietzig',
	'DE13075018' => 'Brünzow',
	'DE13075020' => 'Bugewitz',
	'DE13075021' => 'Buggenhagen',
	'DE13075022' => 'Butzow',
	'DE13075023' => 'Daberkow',
	'DE13075025' => 'Dargelin',
	'DE13075026' => 'Dargen',
	'DE13075027' => 'Dersekow',
	'DE13075028' => 'Diedrichshagen',
	'DE13075029' => 'Ducherow',
	'DE13075031' => 'Eggesin, Stadt',
	'DE13075032' => 'Fahrenwalde',
	'DE13075033' => 'Ferdinandshof',
	'DE13075034' => 'Garz',
	'DE13075035' => 'Glasow',
	'DE13075036' => 'Görmin',
	'DE13075037' => 'Grambin',
	'DE13075038' => 'Grambow',
	'DE13075039' => 'Greifswald, Hansestadt',
	'DE13075040' => 'Gribow',
	'DE13075041' => 'Groß Kiesow',
	'DE13075042' => 'Groß Luckow',
	'DE13075043' => 'Groß Polzin',
	'DE13075044' => 'Gützkow, Stadt',
	'DE13075045' => 'Hammer a.d. Uecker',
	'DE13075046' => 'Hanshagen',
	'DE13075048' => 'Heinrichswalde',
	'DE13075049' => 'Heringsdorf',
	'DE13075050' => 'Hinrichshagen',
	'DE13075051' => 'Hintersee',
	'DE13075053' => 'Iven',
	'DE13075054' => 'Jarmen, Stadt',
	'DE13075055' => 'Jatznick',
	'DE13075056' => 'Kamminke',
	'DE13075057' => 'Karlsburg',
	'DE13075058' => 'Karlshagen',
	'DE13075059' => 'Katzow',
	'DE13075060' => 'Kemnitz',
	'DE13075061' => 'Klein Bünzow',
	'DE13075063' => 'Koblentz',
	'DE13075065' => 'Korswandt',
	'DE13075066' => 'Koserow',
	'DE13075067' => 'Krackow',
	'DE13075068' => 'Krien',
	'DE13075069' => 'Kröslin',
	'DE13075070' => 'Kruckow',
	'DE13075071' => 'Krugsdorf',
	'DE13075072' => 'Krummin',
	'DE13075073' => 'Krusenfelde',
	'DE13075074' => 'Lassan, Stadt',
	'DE13075075' => 'Leopoldshagen',
	'DE13075076' => 'Levenhagen',
	'DE13075078' => 'Liepgarten',
	'DE13075079' => 'Löcknitz',
	'DE13075080' => 'Loddin',
	'DE13075081' => 'Loissin',
	'DE13075082' => 'Loitz, Stadt',
	'DE13075083' => 'Lubmin',
	'DE13075084' => 'Lübs',
	'DE13075085' => 'Luckow',
	'DE13075086' => 'Lühmannsdorf',
	'DE13075087' => 'Lütow',
	'DE13075088' => 'Medow',
	'DE13075089' => 'Meiersberg',
	'DE13075090' => 'Mellenthin',
	'DE13075091' => 'Mesekenhagen',
	'DE13075092' => 'Mölschow',
	'DE13075093' => 'Mönkebude',
	'DE13075094' => 'Murchin',
	'DE13075095' => 'Nadrensee',
	'DE13075097' => 'Neu Boltenhagen',
	'DE13075098' => 'Neu Kosenow',
	'DE13075101' => 'Neuenkirchen',
	'DE13075102' => 'Neuenkirchen',
	'DE13075103' => 'Nieden',
	'DE13075104' => 'Papendorf',
	'DE13075105' => 'Pasewalk, Stadt',
	'DE13075106' => 'Peenemünde',
	'DE13075107' => 'Penkun, Stadt',
	'DE13075108' => 'Plöwen',
	'DE13075109' => 'Polzow',
	'DE13075110' => 'Postlow',
	'DE13075111' => 'Pudagla',
	'DE13075113' => 'Ramin',
	'DE13075114' => 'Rankwitz',
	'DE13075115' => 'Rollwitz',
	'DE13075116' => 'Rossin',
	'DE13075117' => 'Rossow',
	'DE13075118' => 'Rothemühl',
	'DE13075119' => 'Rothenklempenow',
	'DE13075120' => 'Rubenow',
	'DE13075121' => 'Rubkow',
	'DE13075122' => 'Sarnow',
	'DE13075123' => 'Sassen-Trantow',
	'DE13075124' => 'Sauzin',
	'DE13075125' => 'Schmatzin',
	'DE13075126' => 'Schönwalde',
	'DE13075127' => 'Spantekow',
	'DE13075128' => 'Stolpe an der Peene',
	'DE13075129' => 'Stolpe auf Usedom',
	'DE13075130' => 'Strasburg (Uckermark), Stadt',
	'DE13075131' => 'Torgelow, Stadt',
	'DE13075133' => 'Trassenheide',
	'DE13075134' => 'Tutow',
	'DE13075135' => 'Ückeritz',
	'DE13075136' => 'Ueckermünde, Stadt',
	'DE13075137' => 'Usedom, Stadt',
	'DE13075138' => 'Viereck',
	'DE13075139' => 'Vogelsang-Warsin',
	'DE13075140' => 'Völschow',
	'DE13075141' => 'Wackerow',
	'DE13075142' => 'Weitenhagen',
	'DE13075143' => 'Wilhelmsburg',
	'DE13075144' => 'Wolgast, Stadt',
	'DE13075145' => 'Wrangelsburg',
	'DE13075146' => 'Wusterhusen',
	'DE13075147' => 'Zemitz',
	'DE13075148' => 'Zempin',
	'DE13075149' => 'Zerrenthin',
	'DE13075150' => 'Ziethen',
	'DE13075151' => 'Zinnowitz',
	'DE13075152' => 'Zirchow',
	'DE13075154' => 'Züssow',
	'DE13075155' => 'Neetzow-Liepen',
	'DE13076001' => 'Alt Krenzlin',
	'DE13076002' => 'Alt Zachun',
	'DE13076003' => 'Balow',
	'DE13076004' => 'Bandenitz',
	'DE13076005' => 'Banzkow',
	'DE13076006' => 'Barkhagen',
	'DE13076007' => 'Barnin',
	'DE13076008' => 'Belsch',
	'DE13076009' => 'Bengerstorf',
	'DE13076010' => 'Besitz',
	'DE13076011' => 'Blankenberg',
	'DE13076012' => 'Blievenstorf',
	'DE13076013' => 'Bobzin',
	'DE13076014' => 'Boizenburg/ Elbe, Stadt',
	'DE13076015' => 'Borkow',
	'DE13076016' => 'Brahlstorf',
	'DE13076017' => 'Brenz',
	'DE13076018' => 'Bresegard bei Eldena',
	'DE13076019' => 'Bresegard bei Picher',
	'DE13076020' => 'Brüel, Stadt',
	'DE13076021' => 'Brunow',
	'DE13076023' => 'Bülow',
	'DE13076024' => 'Cambs',
	'DE13076025' => 'Crivitz, Stadt',
	'DE13076026' => 'Dabel',
	'DE13076027' => 'Dambeck',
	'DE13076029' => 'Demen',
	'DE13076030' => 'Dersenow',
	'DE13076032' => 'Dobbertin',
	'DE13076033' => 'Dobin am See',
	'DE13076034' => 'Dömitz, Stadt',
	'DE13076035' => 'Domsühl',
	'DE13076036' => 'Dümmer',
	'DE13076037' => 'Eldena',
	'DE13076038' => 'Friedrichsruhe',
	'DE13076039' => 'Gallin',
	'DE13076040' => 'Gallin-Kuppentin',
	'DE13076041' => 'Gammelin',
	'DE13076043' => 'Gischow',
	'DE13076044' => 'Gneven',
	'DE13076046' => 'Göhlen',
	'DE13076048' => 'Goldberg, Stadt',
	'DE13076049' => 'Gorlosen',
	'DE13076050' => 'Grabow, Stadt',
	'DE13076051' => 'Granzin',
	'DE13076053' => 'Grebs-Niendorf',
	'DE13076054' => 'Gresse',
	'DE13076055' => 'Greven',
	'DE13076056' => 'Groß Godems',
	'DE13076057' => 'Groß Krams',
	'DE13076058' => 'Groß Laasch',
	'DE13076060' => 'Hagenow, Stadt',
	'DE13076062' => 'Hohen Pritz',
	'DE13076063' => 'Holthusen',
	'DE13076064' => 'Hoort',
	'DE13076065' => 'Hülseburg',
	'DE13076067' => 'Karenz',
	'DE13076068' => 'Karrenzin',
	'DE13076069' => 'Karstädt',
	'DE13076070' => 'Kirch Jesar',
	'DE13076071' => 'Klein Rogahn',
	'DE13076072' => 'Kobrow',
	'DE13076073' => 'Kogel',
	'DE13076075' => 'Kreien',
	'DE13076076' => 'Kremmin',
	'DE13076077' => 'Kritzow',
	'DE13076078' => 'Kuhlen-Wendorf',
	'DE13076079' => 'Kuhstorf',
	'DE13076080' => 'Langen Brütz',
	'DE13076082' => 'Leezen',
	'DE13076084' => 'Leussow',
	'DE13076085' => 'Lewitzrand ',
	'DE13076086' => 'Lübesse',
	'DE13076087' => 'Lüblow',
	'DE13076088' => 'Lübtheen, Stadt',
	'DE13076089' => 'Lübz, Stadt',
	'DE13076090' => 'Ludwigslust, Stadt',
	'DE13076092' => 'Lüttow-Valluhn',
	'DE13076093' => 'Malk Göhren',
	'DE13076094' => 'Malliß',
	'DE13076095' => 'Marnitz',
	'DE13076096' => 'Mestlin',
	'DE13076097' => 'Milow',
	'DE13076098' => 'Möllenbeck',
	'DE13076099' => 'Moraas',
	'DE13076100' => 'Muchow',
	'DE13076101' => 'Mustin',
	'DE13076102' => 'Neu Gülze',
	'DE13076103' => 'Neu Kaliß',
	'DE13076104' => 'Neu Poserin',
	'DE13076105' => 'Neustadt-Glewe, Stadt',
	'DE13076106' => 'Nostorf',
	'DE13076107' => 'Pampow',
	'DE13076108' => 'Parchim, Stadt',
	'DE13076109' => 'Passow',
	'DE13076110' => 'Pätow-Steegen',
	'DE13076111' => 'Picher',
	'DE13076112' => 'Pinnow',
	'DE13076113' => 'Plate',
	'DE13076114' => 'Plau am See, Stadt',
	'DE13076115' => 'Prislich',
	'DE13076116' => 'Pritzier',
	'DE13076117' => 'Raben Steinfeld',
	'DE13076118' => 'Rastow',
	'DE13076119' => 'Redefin',
	'DE13076120' => 'Rom',
	'DE13076121' => 'Schossin',
	'DE13076122' => 'Schwanheide',
	'DE13076123' => 'Setzin',
	'DE13076125' => 'Siggelkow',
	'DE13076126' => 'Spornitz',
	'DE13076128' => 'Sternberg, Stadt',
	'DE13076129' => 'Stolpe',
	'DE13076130' => 'Stralendorf',
	'DE13076131' => 'Strohkirchen',
	'DE13076132' => 'Suckow',
	'DE13076133' => 'Sukow',
	'DE13076134' => 'Sülstorf',
	'DE13076135' => 'Techentin ',
	'DE13076136' => 'Teldau',
	'DE13076137' => 'Tessenow',
	'DE13076138' => 'Tessin b. Boizenburg',
	'DE13076139' => 'Toddin',
	'DE13076140' => 'Tramm',
	'DE13076141' => 'Uelitz',
	'DE13076142' => 'Vellahn',
	'DE13076143' => 'Vielank',
	'DE13076145' => 'Warlitz',
	'DE13076146' => 'Warlow',
	'DE13076147' => 'Warsow',
	'DE13076148' => 'Weitendorf',
	'DE13076151' => 'Werder',
	'DE13076152' => 'Wittenburg, Stadt',
	'DE13076153' => 'Wittendörp',
	'DE13076154' => 'Wittenförden',
	'DE13076155' => 'Witzin',
	'DE13076156' => 'Wöbbelin',
	'DE13076158' => 'Zapel',
	'DE13076159' => 'Zarrentin am Schaalsee, Stadt',
	'DE13076160' => 'Ziegendorf',
	'DE13076161' => 'Zierzow',
	'DE13076162' => 'Zölkow',
	'DE13076163' => 'Zülow',
	'DE13076164' => 'Obere Warnow',
	'DE13076165' => 'Gehlsbach',
	'DE13076166' => 'Ganzlin',
	'DE13076167' => 'Kloster Tempzin',
	'DE14511000' => 'Chemnitz, Stadt',
	'DE14521010' => 'Amtsberg',
	'DE14521020' => 'Annaberg-Buchholz, Stadt',
	'DE14521030' => 'Aue, Stadt',
	'DE14521040' => 'Auerbach',
	'DE14521050' => 'Bad Schlema',
	'DE14521060' => 'Bärenstein',
	'DE14521080' => 'Bockau',
	'DE14521090' => 'Börnichen/Erzgeb.',
	'DE14521110' => 'Breitenbrunn/Erzgeb.',
	'DE14521120' => 'Burkhardtsdorf',
	'DE14521130' => 'Crottendorf',
	'DE14521140' => 'Deutschneudorf',
	'DE14521150' => 'Drebach',
	'DE14521160' => 'Ehrenfriedersdorf, Stadt',
	'DE14521170' => 'Eibenstock, Stadt',
	'DE14521180' => 'Elterlein, Stadt',
	'DE14521200' => 'Gelenau/Erzgeb.',
	'DE14521210' => 'Geyer, Stadt',
	'DE14521220' => 'Gornau/Erzgeb.',
	'DE14521230' => 'Gornsdorf',
	'DE14521240' => 'Großolbersdorf',
	'DE14521250' => 'Großrückerswalde',
	'DE14521260' => 'Grünhain-Beierfeld, Stadt',
	'DE14521270' => 'Grünhainichen',
	'DE14521280' => 'Heidersdorf',
	'DE14521290' => 'Hohndorf',
	'DE14521310' => 'Jahnsdorf/Erzgeb.',
	'DE14521320' => 'Johanngeorgenstadt, Stadt',
	'DE14521330' => 'Jöhstadt, Stadt',
	'DE14521340' => 'Königswalde',
	'DE14521355' => 'Lauter-Bernsbach, Stadt',
	'DE14521370' => 'Lößnitz, Stadt',
	'DE14521380' => 'Lugau/Erzgeb., Stadt',
	'DE14521390' => 'Marienberg, Stadt',
	'DE14521400' => 'Mildenau',
	'DE14521410' => 'Neukirchen/Erzgeb.',
	'DE14521420' => 'Niederdorf',
	'DE14521430' => 'Niederwürschnitz',
	'DE14521440' => 'Oberwiesenthal, Kurort, Stadt',
	'DE14521450' => 'Oelsnitz/Erzgeb., Stadt',
	'DE14521460' => 'Olbernhau, Stadt',
	'DE14521495' => 'Pockau-Lengefeld, Stadt',
	'DE14521500' => 'Raschau-Markersbach',
	'DE14521510' => 'Scheibenberg, Stadt',
	'DE14521520' => 'Schlettau, Stadt',
	'DE14521530' => 'Schneeberg, Stadt',
	'DE14521540' => 'Schönheide',
	'DE14521550' => 'Schwarzenberg/Erzgeb., Stadt',
	'DE14521560' => 'Sehmatal',
	'DE14521570' => 'Seiffen/Erzgeb., Kurort',
	'DE14521590' => 'Stollberg/Erzgeb., Stadt',
	'DE14521600' => 'Stützengrün',
	'DE14521610' => 'Tannenberg',
	'DE14521620' => 'Thalheim/Erzgeb., Stadt',
	'DE14521630' => 'Thermalbad Wiesenbad',
	'DE14521640' => 'Thum, Stadt',
	'DE14521670' => 'Wolkenstein, Stadt',
	'DE14521690' => 'Zschopau, Stadt',
	'DE14521700' => 'Zschorlau',
	'DE14521710' => 'Zwönitz, Stadt',
	'DE14522010' => 'Altmittweida',
	'DE14522020' => 'Augustusburg, Stadt',
	'DE14522035' => 'Bobritzsch-Hilbersdorf',
	'DE14522050' => 'Brand-Erbisdorf, Stadt',
	'DE14522060' => 'Burgstädt, Stadt',
	'DE14522070' => 'Claußnitz',
	'DE14522080' => 'Döbeln, Stadt',
	'DE14522090' => 'Dorfchemnitz',
	'DE14522110' => 'Eppendorf',
	'DE14522120' => 'Erlau',
	'DE14522140' => 'Flöha, Stadt',
	'DE14522150' => 'Frankenberg/Sa., Stadt',
	'DE14522170' => 'Frauenstein, Stadt',
	'DE14522180' => 'Freiberg, Stadt, Universitätsstadt',
	'DE14522190' => 'Geringswalde, Stadt',
	'DE14522200' => 'Großhartmannsdorf',
	'DE14522210' => 'Großschirma, Stadt',
	'DE14522220' => 'Großweitzschen',
	'DE14522230' => 'Hainichen, Stadt',
	'DE14522240' => 'Halsbrücke',
	'DE14522250' => 'Hartha, Stadt',
	'DE14522260' => 'Hartmannsdorf',
	'DE14522280' => 'Königsfeld',
	'DE14522290' => 'Königshain-Wiederau',
	'DE14522300' => 'Kriebstein',
	'DE14522310' => 'Leisnig, Stadt',
	'DE14522320' => 'Leubsdorf',
	'DE14522330' => 'Lichtenau',
	'DE14522340' => 'Lichtenberg/Erzgeb.',
	'DE14522350' => 'Lunzenau, Stadt',
	'DE14522360' => 'Mittweida, Stadt, Hochschulstadt',
	'DE14522380' => 'Mühlau',
	'DE14522390' => 'Mulda/Sa.',
	'DE14522400' => 'Neuhausen/Erzgeb.',
	'DE14522420' => 'Niederwiesa',
	'DE14522430' => 'Oberschöna',
	'DE14522440' => 'Oederan, Stadt',
	'DE14522450' => 'Ostrau',
	'DE14522460' => 'Penig, Stadt',
	'DE14522470' => 'Rechenberg-Bienenmühle',
	'DE14522480' => 'Reinsberg',
	'DE14522490' => 'Rochlitz, Stadt',
	'DE14522500' => 'Rossau',
	'DE14522510' => 'Roßwein, Stadt',
	'DE14522520' => 'Sayda, Stadt',
	'DE14522530' => 'Seelitz',
	'DE14522540' => 'Striegistal',
	'DE14522550' => 'Taura',
	'DE14522570' => 'Waldheim, Stadt',
	'DE14522580' => 'Wechselburg',
	'DE14522590' => 'Weißenborn/Erzgeb.',
	'DE14522600' => 'Zettlitz',
	'DE14522620' => 'Zschaitz-Ottewig',
	'DE14523010' => 'Adorf/Vogtl., Stadt',
	'DE14523020' => 'Auerbach/Vogtl., Stadt',
	'DE14523030' => 'Bad Brambach',
	'DE14523040' => 'Bad Elster, Stadt',
	'DE14523050' => 'Bergen',
	'DE14523060' => 'Bösenbrunn',
	'DE14523080' => 'Eichigt',
	'DE14523090' => 'Ellefeld',
	'DE14523100' => 'Elsterberg, Stadt',
	'DE14523120' => 'Falkenstein/Vogtl., Stadt',
	'DE14523130' => 'Grünbach',
	'DE14523150' => 'Heinsdorfergrund',
	'DE14523160' => 'Klingenthal, Stadt',
	'DE14523170' => 'Lengenfeld, Stadt',
	'DE14523190' => 'Limbach',
	'DE14523200' => 'Markneukirchen, Stadt',
	'DE14523230' => 'Mühlental',
	'DE14523245' => 'Muldenhammer',
	'DE14523260' => 'Netzschkau, Stadt',
	'DE14523270' => 'Neuensalz',
	'DE14523280' => 'Neumark',
	'DE14523290' => 'Neustadt/Vogtl.',
	'DE14523300' => 'Oelsnitz/Vogtl., Stadt',
	'DE14523310' => 'Pausa-Mühltroff, Stadt',
	'DE14523320' => 'Plauen, Stadt',
	'DE14523330' => 'Pöhl',
	'DE14523340' => 'Reichenbach im Vogtland, Stadt',
	'DE14523360' => 'Rodewisch, Stadt',
	'DE14523365' => 'Rosenbach/Vogtl.',
	'DE14523370' => 'Schöneck/Vogtl., Stadt',
	'DE14523380' => 'Steinberg',
	'DE14523410' => 'Theuma',
	'DE14523420' => 'Tirpersdorf',
	'DE14523430' => 'Treuen, Stadt',
	'DE14523440' => 'Triebel/Vogtl.',
	'DE14523450' => 'Weischlitz',
	'DE14523460' => 'Werda',
	'DE14524010' => 'Bernsdorf',
	'DE14524020' => 'Callenberg',
	'DE14524030' => 'Crimmitschau, Stadt',
	'DE14524040' => 'Crinitzberg',
	'DE14524050' => 'Dennheritz',
	'DE14524060' => 'Fraureuth',
	'DE14524070' => 'Gersdorf',
	'DE14524080' => 'Glauchau, Stadt',
	'DE14524090' => 'Hartenstein, Stadt',
	'DE14524100' => 'Hartmannsdorf b. Kirchberg',
	'DE14524110' => 'Hirschfeld',
	'DE14524120' => 'Hohenstein-Ernstthal, Stadt',
	'DE14524130' => 'Kirchberg, Stadt',
	'DE14524140' => 'Langenbernsdorf',
	'DE14524150' => 'Langenweißbach',
	'DE14524160' => 'Lichtenstein/Sa., Stadt',
	'DE14524170' => 'Lichtentanne',
	'DE14524180' => 'Limbach-Oberfrohna, Stadt',
	'DE14524190' => 'Meerane, Stadt',
	'DE14524200' => 'Mülsen',
	'DE14524210' => 'Neukirchen/Pleiße',
	'DE14524220' => 'Niederfrohna',
	'DE14524230' => 'Oberlungwitz, Stadt',
	'DE14524240' => 'Oberwiera',
	'DE14524250' => 'Reinsdorf',
	'DE14524260' => 'Remse',
	'DE14524270' => 'Schönberg',
	'DE14524280' => 'St. Egidien',
	'DE14524290' => 'Waldenburg, Stadt',
	'DE14524300' => 'Werdau, Stadt',
	'DE14524310' => 'Wildenfels, Stadt',
	'DE14524320' => 'Wilkau-Haßlau, Stadt',
	'DE14524330' => 'Zwickau, Stadt',
	'DE14612000' => 'Dresden, Stadt',
	'DE14625010' => 'Arnsdorf',
	'DE14625020' => 'Bautzen, Stadt',
	'DE14625030' => 'Bernsdorf, Stadt',
	'DE14625040' => 'Bischofswerda, Stadt',
	'DE14625060' => 'Burkau',
	'DE14625080' => 'Crostwitz',
	'DE14625090' => 'Cunewalde',
	'DE14625100' => 'Demitz-Thumitz',
	'DE14625110' => 'Doberschau-Gaußig',
	'DE14625120' => 'Elsterheide',
	'DE14625130' => 'Elstra, Stadt',
	'DE14625140' => 'Frankenthal',
	'DE14625150' => 'Göda',
	'DE14625160' => 'Großdubrau',
	'DE14625170' => 'Großharthau',
	'DE14625180' => 'Großnaundorf',
	'DE14625190' => 'Großpostwitz/O.L.',
	'DE14625200' => 'Großröhrsdorf, Stadt',
	'DE14625220' => 'Haselbachtal',
	'DE14625230' => 'Hochkirch',
	'DE14625240' => 'Hoyerswerda, Stadt',
	'DE14625250' => 'Kamenz, Stadt',
	'DE14625270' => 'Königsbrück, Stadt',
	'DE14625280' => 'Königswartha',
	'DE14625290' => 'Kubschütz',
	'DE14625300' => 'Laußnitz',
	'DE14625310' => 'Lauta, Stadt',
	'DE14625320' => 'Lichtenberg',
	'DE14625330' => 'Lohsa',
	'DE14625340' => 'Malschwitz',
	'DE14625350' => 'Nebelschütz',
	'DE14625360' => 'Neschwitz',
	'DE14625370' => 'Neukirch',
	'DE14625380' => 'Neukirch/Lausitz',
	'DE14625390' => 'Obergurig',
	'DE14625410' => 'Ohorn',
	'DE14625420' => 'Oßling',
	'DE14625430' => 'Ottendorf-Okrilla',
	'DE14625440' => 'Panschwitz-Kuckau',
	'DE14625450' => 'Pulsnitz, Stadt',
	'DE14625460' => 'Puschwitz',
	'DE14625470' => 'Räckelwitz',
	'DE14625480' => 'Radeberg, Stadt',
	'DE14625490' => 'Radibor',
	'DE14625500' => 'Ralbitz-Rosenthal',
	'DE14625510' => 'Rammenau',
	'DE14625525' => 'Schirgiswalde-Kirschau, Stadt',
	'DE14625530' => 'Schmölln-Putzkau',
	'DE14625540' => 'Schönteichen',
	'DE14625550' => 'Schwepnitz',
	'DE14625560' => 'Sohland a. d. Spree',
	'DE14625570' => 'Spreetal',
	'DE14625580' => 'Steina',
	'DE14625590' => 'Steinigtwolmsdorf',
	'DE14625600' => 'Wachau',
	'DE14625610' => 'Weißenberg, Stadt',
	'DE14625630' => 'Wilthen, Stadt',
	'DE14625640' => 'Wittichenau, Stadt',
	'DE14626010' => 'Bad Muskau, Stadt',
	'DE14626020' => 'Beiersdorf',
	'DE14626030' => 'Bernstadt a. d. Eigen, Stadt',
	'DE14626050' => 'Bertsdorf-Hörnitz',
	'DE14626060' => 'Boxberg/O.L.',
	'DE14626070' => 'Dürrhennersdorf',
	'DE14626085' => 'Ebersbach-Neugersdorf, Stadt',
	'DE14626100' => 'Gablenz',
	'DE14626110' => 'Görlitz, Stadt',
	'DE14626120' => 'Groß Düben',
	'DE14626140' => 'Großschönau',
	'DE14626150' => 'Großschweidnitz',
	'DE14626160' => 'Hähnichen',
	'DE14626170' => 'Hainewalde',
	'DE14626180' => 'Herrnhut, Stadt',
	'DE14626190' => 'Hohendubrau',
	'DE14626200' => 'Horka',
	'DE14626210' => 'Jonsdorf, Kurort',
	'DE14626230' => 'Kodersdorf',
	'DE14626240' => 'Königshain',
	'DE14626245' => 'Kottmar',
	'DE14626250' => 'Krauschwitz i.d. O.L.',
	'DE14626260' => 'Kreba-Neudorf',
	'DE14626270' => 'Lawalde',
	'DE14626280' => 'Leutersdorf',
	'DE14626290' => 'Löbau, Stadt',
	'DE14626300' => 'Markersdorf',
	'DE14626310' => 'Mittelherwigsdorf',
	'DE14626320' => 'Mücka',
	'DE14626330' => 'Neißeaue',
	'DE14626350' => 'Neusalza-Spremberg, Stadt',
	'DE14626370' => 'Niesky, Stadt',
	'DE14626390' => 'Oderwitz',
	'DE14626400' => 'Olbersdorf',
	'DE14626410' => 'Oppach',
	'DE14626420' => 'Ostritz, Stadt',
	'DE14626430' => 'Oybin',
	'DE14626440' => 'Quitzdorf am See',
	'DE14626450' => 'Reichenbach/O.L., Stadt',
	'DE14626460' => 'Rietschen',
	'DE14626470' => 'Rosenbach',
	'DE14626480' => 'Rothenburg/O.L., Stadt',
	'DE14626490' => 'Schleife',
	'DE14626500' => 'Schönau-Berzdorf a. d. Eigen',
	'DE14626510' => 'Schönbach',
	'DE14626520' => 'Schöpstal',
	'DE14626530' => 'Seifhennersdorf, Stadt',
	'DE14626560' => 'Trebendorf',
	'DE14626570' => 'Vierkirchen',
	'DE14626580' => 'Waldhufen',
	'DE14626590' => 'Weißkeißel',
	'DE14626600' => 'Weißwasser/O.L., Stadt',
	'DE14626610' => 'Zittau, Stadt',
	'DE14627010' => 'Coswig, Stadt',
	'DE14627020' => 'Diera-Zehren',
	'DE14627030' => 'Ebersbach',
	'DE14627040' => 'Glaubitz',
	'DE14627050' => 'Gröditz, Stadt',
	'DE14627060' => 'Großenhain, Stadt',
	'DE14627070' => 'Hirschstein',
	'DE14627080' => 'Käbschütztal',
	'DE14627100' => 'Klipphausen',
	'DE14627110' => 'Lampertswalde',
	'DE14627130' => 'Lommatzsch, Stadt',
	'DE14627140' => 'Meißen, Stadt',
	'DE14627150' => 'Moritzburg',
	'DE14627170' => 'Niederau',
	'DE14627180' => 'Nossen, Stadt',
	'DE14627190' => 'Nünchritz',
	'DE14627200' => 'Priestewitz',
	'DE14627210' => 'Radebeul, Stadt',
	'DE14627220' => 'Radeburg, Stadt',
	'DE14627230' => 'Riesa, Stadt',
	'DE14627240' => 'Röderaue',
	'DE14627250' => 'Schönfeld',
	'DE14627260' => 'Stauchitz',
	'DE14627270' => 'Strehla, Stadt',
	'DE14627290' => 'Thiendorf',
	'DE14627310' => 'Weinböhla',
	'DE14627340' => 'Wülknitz',
	'DE14627360' => 'Zeithain',
	'DE14628010' => 'Altenberg, Stadt',
	'DE14628020' => 'Bad Gottleuba-Berggießhübel, Stadt',
	'DE14628030' => 'Bad Schandau, Stadt',
	'DE14628040' => 'Bahretal',
	'DE14628050' => 'Bannewitz',
	'DE14628060' => 'Dippoldiswalde, Stadt',
	'DE14628070' => 'Dohma',
	'DE14628080' => 'Dohna, Stadt',
	'DE14628090' => 'Dorfhain',
	'DE14628100' => 'Dürrröhrsdorf-Dittersbach',
	'DE14628110' => 'Freital, Stadt',
	'DE14628130' => 'Glashütte, Stadt',
	'DE14628140' => 'Gohrisch',
	'DE14628150' => 'Hartmannsdorf-Reichenau',
	'DE14628160' => 'Heidenau, Stadt',
	'DE14628170' => 'Hermsdorf/Erzgeb.',
	'DE14628190' => 'Hohnstein, Stadt',
	'DE14628205' => 'Klingenberg',
	'DE14628210' => 'Königstein/Sächs. Schw., Stadt',
	'DE14628220' => 'Kreischa',
	'DE14628230' => 'Liebstadt, Stadt',
	'DE14628240' => 'Lohmen',
	'DE14628250' => 'Müglitztal',
	'DE14628260' => 'Neustadt in Sachsen, Stadt',
	'DE14628270' => 'Pirna, Stadt',
	'DE14628300' => 'Rabenau, Stadt',
	'DE14628310' => 'Rathen, Kurort',
	'DE14628320' => 'Rathmannsdorf',
	'DE14628330' => 'Reinhardtsdorf-Schöna',
	'DE14628340' => 'Rosenthal-Bielatal',
	'DE14628360' => 'Sebnitz, Stadt',
	'DE14628370' => 'Stadt Wehlen, Stadt',
	'DE14628380' => 'Stolpen, Stadt',
	'DE14628390' => 'Struppen',
	'DE14628400' => 'Tharandt, Stadt',
	'DE14628410' => 'Wilsdruff, Stadt',
	'DE14713000' => 'Leipzig, Stadt',
	'DE14729010' => 'Bad Lausick, Stadt',
	'DE14729020' => 'Belgershain',
	'DE14729030' => 'Bennewitz',
	'DE14729040' => 'Böhlen, Stadt',
	'DE14729050' => 'Borna, Stadt',
	'DE14729060' => 'Borsdorf',
	'DE14729070' => 'Brandis, Stadt',
	'DE14729080' => 'Colditz, Stadt',
	'DE14729100' => 'Elstertrebnitz',
	'DE14729140' => 'Frohburg, Stadt',
	'DE14729150' => 'Geithain, Stadt',
	'DE14729160' => 'Grimma, Stadt',
	'DE14729170' => 'Groitzsch, Stadt',
	'DE14729190' => 'Großpösna',
	'DE14729220' => 'Kitzscher, Stadt',
	'DE14729245' => 'Lossatal',
	'DE14729250' => 'Machern',
	'DE14729260' => 'Markkleeberg, Stadt',
	'DE14729270' => 'Markranstädt, Stadt',
	'DE14729300' => 'Naunhof, Stadt',
	'DE14729320' => 'Neukieritzsch',
	'DE14729330' => 'Otterwisch',
	'DE14729340' => 'Parthenstein',
	'DE14729350' => 'Pegau, Stadt',
	'DE14729360' => 'Regis-Breitingen, Stadt',
	'DE14729370' => 'Rötha, Stadt',
	'DE14729380' => 'Thallwitz',
	'DE14729400' => 'Trebsen/Mulde, Stadt',
	'DE14729410' => 'Wurzen, Stadt',
	'DE14729430' => 'Zwenkau, Stadt',
	'DE14730010' => 'Arzberg',
	'DE14730020' => 'Bad Düben, Stadt',
	'DE14730030' => 'Beilrode',
	'DE14730045' => 'Belgern-Schildau, Stadt',
	'DE14730050' => 'Cavertitz',
	'DE14730060' => 'Dahlen, Stadt',
	'DE14730070' => 'Delitzsch, Stadt',
	'DE14730080' => 'Doberschütz',
	'DE14730090' => 'Dommitzsch, Stadt',
	'DE14730100' => 'Dreiheide',
	'DE14730110' => 'Eilenburg, Stadt',
	'DE14730120' => 'Elsnig',
	'DE14730140' => 'Jesewitz',
	'DE14730150' => 'Krostitz',
	'DE14730160' => 'Laußig',
	'DE14730170' => 'Liebschützberg',
	'DE14730180' => 'Löbnitz',
	'DE14730190' => 'Mockrehna',
	'DE14730200' => 'Mügeln, Stadt',
	'DE14730210' => 'Naundorf',
	'DE14730230' => 'Oschatz, Stadt',
	'DE14730250' => 'Rackwitz',
	'DE14730270' => 'Schkeuditz, Stadt',
	'DE14730280' => 'Schönwölkau',
	'DE14730300' => 'Taucha, Stadt',
	'DE14730310' => 'Torgau, Stadt',
	'DE14730320' => 'Trossin',
	'DE14730330' => 'Wermsdorf',
	'DE14730340' => 'Wiedemar',
	'DE14730360' => 'Zschepplin',
	'DE15001000' => 'Dessau-Roßlau, Stadt',
	'DE15002000' => 'Halle (Saale), Stadt',
	'DE15003000' => 'Magdeburg, Landeshauptstadt',
	'DE15081026' => 'Apenburg-Winterfeld, Flecken',
	'DE15081030' => 'Arendsee (Altmark), Stadt',
	'DE15081045' => 'Beetzendorf',
	'DE15081095' => 'Dähre',
	'DE15081105' => 'Diesdorf, Flecken',
	'DE15081135' => 'Gardelegen, Hansestadt',
	'DE15081225' => 'Jübar',
	'DE15081240' => 'Kalbe (Milde), Stadt',
	'DE15081280' => 'Klötze, Stadt',
	'DE15081290' => 'Kuhfelde',
	'DE15081440' => 'Rohrberg',
	'DE15081455' => 'Salzwedel, Hansestadt',
	'DE15081545' => 'Wallstawe ',
	'DE15082005' => 'Aken (Elbe), Stadt',
	'DE15082015' => 'Bitterfeld-Wolfen, Stadt',
	'DE15082180' => 'Köthen (Anhalt), Stadt',
	'DE15082241' => 'Muldestausee',
	'DE15082256' => 'Osternienburger Land',
	'DE15082301' => 'Raguhn-Jeßnitz, Stadt',
	'DE15082340' => 'Sandersdorf-Brehna, Stadt',
	'DE15082377' => 'Südliches Anhalt, Stadt',
	'DE15082430' => 'Zerbst/Anhalt, Stadt',
	'DE15082440' => 'Zörbig, Stadt',
	'DE15083020' => 'Altenhausen',
	'DE15083025' => 'Am Großen Bruch',
	'DE15083030' => 'Angern',
	'DE15083035' => 'Ausleben',
	'DE15083040' => 'Barleben',
	'DE15083060' => 'Beendorf',
	'DE15083115' => 'Bülstringen',
	'DE15083120' => 'Burgstall',
	'DE15083125' => 'Calvörde',
	'DE15083130' => 'Colbitz',
	'DE15083190' => 'Eilsleben',
	'DE15083205' => 'Erxleben',
	'DE15083230' => 'Flechtingen',
	'DE15083245' => 'Gröningen, Stadt',
	'DE15083270' => 'Haldensleben, Stadt',
	'DE15083275' => 'Harbke',
	'DE15083298' => 'Hohe Börde',
	'DE15083320' => 'Hötensleben',
	'DE15083323' => 'Ingersleben',
	'DE15083355' => 'Kroppenstedt, Stadt',
	'DE15083361' => 'Loitsche-Heinrichsberg',
	'DE15083390' => 'Niedere Börde',
	'DE15083411' => 'Oebisfelde-Weferlingen, Stadt',
	'DE15083415' => 'Oschersleben (Bode), Stadt',
	'DE15083440' => 'Rogätz',
	'DE15083485' => 'Sommersdorf',
	'DE15083490' => 'Sülzetal',
	'DE15083505' => 'Ummendorf',
	'DE15083515' => 'Völpke',
	'DE15083531' => 'Wanzleben-Börde, Stadt',
	'DE15083535' => 'Wefensleben',
	'DE15083557' => 'Westheide',
	'DE15083565' => 'Wolmirstedt, Stadt',
	'DE15083580' => 'Zielitz',
	'DE15084012' => 'An der Poststraße ',
	'DE15084013' => 'Meineweh',
	'DE15084015' => 'Bad Bibra, Stadt',
	'DE15084025' => 'Balgstädt',
	'DE15084115' => 'Droyßig',
	'DE15084125' => 'Eckartsberga, Stadt',
	'DE15084130' => 'Elsteraue',
	'DE15084132' => 'Finne ',
	'DE15084133' => 'Finneland ',
	'DE15084135' => 'Freyburg (Unstrut), Stadt',
	'DE15084150' => 'Gleina',
	'DE15084170' => 'Goseck',
	'DE15084207' => 'Gutenborn',
	'DE15084235' => 'Hohenmölsen, Stadt',
	'DE15084246' => 'Kaiserpfalz ',
	'DE15084250' => 'Karsdorf',
	'DE15084275' => 'Kretzschau',
	'DE15084282' => 'Lanitz-Hassel-Tal ',
	'DE15084285' => 'Laucha an der Unstrut, Stadt',
	'DE15084315' => 'Lützen, Stadt',
	'DE15084335' => 'Mertendorf',
	'DE15084341' => 'Molauer Land',
	'DE15084355' => 'Naumburg (Saale), Stadt',
	'DE15084360' => 'Nebra (Unstrut), Stadt',
	'DE15084375' => 'Osterfeld, Stadt',
	'DE15084442' => 'Schnaudertal',
	'DE15084445' => 'Schönburg',
	'DE15084470' => 'Stößen, Stadt',
	'DE15084490' => 'Teuchern, Stadt',
	'DE15084550' => 'Weißenfels, Stadt',
	'DE15084560' => 'Wethau',
	'DE15084565' => 'Wetterzeube',
	'DE15084590' => 'Zeitz, Stadt',
	'DE15085040' => 'Ballenstedt, Stadt',
	'DE15085055' => 'Blankenburg (Harz), Stadt',
	'DE15085090' => 'Ditfurt',
	'DE15085110' => 'Falkenstein/Harz, Stadt',
	'DE15085125' => 'Groß Quenstedt',
	'DE15085135' => 'Halberstadt, Stadt',
	'DE15085140' => 'Harsleben',
	'DE15085145' => 'Harzgerode, Stadt',
	'DE15085160' => 'Hedersleben',
	'DE15085185' => 'Huy',
	'DE15085190' => 'Ilsenburg (Harz), Stadt',
	'DE15085227' => 'Nordharz',
	'DE15085228' => 'Oberharz am Brocken, Stadt',
	'DE15085230' => 'Osterwieck, Stadt',
	'DE15085235' => 'Quedlinburg, Welterbestadt',
	'DE15085285' => 'Schwanebeck, Stadt',
	'DE15085287' => 'Selke-Aue',
	'DE15085330' => 'Thale, Stadt',
	'DE15085365' => 'Wegeleben, Stadt',
	'DE15085370' => 'Wernigerode, Stadt',
	'DE15086005' => 'Biederitz',
	'DE15086015' => 'Burg, Stadt',
	'DE15086035' => 'Elbe-Parey',
	'DE15086040' => 'Genthin, Stadt',
	'DE15086055' => 'Gommern, Stadt',
	'DE15086080' => 'Jerichow, Stadt',
	'DE15086140' => 'Möckern, Stadt',
	'DE15086145' => 'Möser',
	'DE15087010' => 'Ahlsdorf',
	'DE15087015' => 'Allstedt, Stadt',
	'DE15087031' => 'Arnstein, Stadt',
	'DE15087045' => 'Benndorf',
	'DE15087055' => 'Berga',
	'DE15087070' => 'Blankenheim',
	'DE15087075' => 'Bornstedt',
	'DE15087101' => 'Brücken-Hackpfüffel',
	'DE15087125' => 'Edersleben',
	'DE15087130' => 'Eisleben, Lutherstadt',
	'DE15087165' => 'Gerbstedt, Stadt',
	'DE15087205' => 'Helbra',
	'DE15087210' => 'Hergisdorf',
	'DE15087220' => 'Hettstedt, Stadt',
	'DE15087250' => 'Kelbra (Kyffhäuser), Stadt',
	'DE15087260' => 'Klostermansfeld',
	'DE15087275' => 'Mansfeld, Stadt',
	'DE15087370' => 'Sangerhausen, Stadt',
	'DE15087386' => 'Seegebiet Mansfelder Land',
	'DE15087412' => 'Südharz',
	'DE15087440' => 'Wallhausen',
	'DE15087470' => 'Wimmelburg',
	'DE15088020' => 'Bad Dürrenberg, Stadt',
	'DE15088025' => 'Bad Lauchstädt, Goethestadt',
	'DE15088030' => 'Barnstädt',
	'DE15088065' => 'Braunsbedra, Stadt',
	'DE15088100' => 'Farnstädt',
	'DE15088150' => 'Kabelsketal',
	'DE15088195' => 'Landsberg, Stadt',
	'DE15088205' => 'Leuna, Stadt',
	'DE15088216' => 'Wettin-Löbejün, Stadt',
	'DE15088220' => 'Merseburg, Stadt',
	'DE15088235' => 'Mücheln (Geiseltal), Stadt',
	'DE15088250' => 'Nemsdorf-Göhrendorf',
	'DE15088265' => 'Obhausen',
	'DE15088295' => 'Petersberg',
	'DE15088305' => 'Querfurt, Stadt',
	'DE15088319' => 'Salzatal',
	'DE15088330' => 'Schkopau',
	'DE15088340' => 'Schraplau, Stadt',
	'DE15088355' => 'Steigra',
	'DE15088365' => 'Teutschenthal',
	'DE15089005' => 'Alsleben (Saale), Stadt',
	'DE15089015' => 'Aschersleben, Stadt',
	'DE15089026' => 'Barby, Stadt',
	'DE15089030' => 'Bernburg (Saale), Stadt',
	'DE15089041' => 'Bördeaue',
	'DE15089042' => 'Bördeland',
	'DE15089043' => 'Börde-Hakel',
	'DE15089045' => 'Borne',
	'DE15089055' => 'Calbe (Saale), Stadt',
	'DE15089075' => 'Egeln, Stadt',
	'DE15089130' => 'Giersleben',
	'DE15089165' => 'Güsten, Stadt',
	'DE15089175' => 'Hecklingen, Stadt',
	'DE15089185' => 'Ilberstedt',
	'DE15089195' => 'Könnern, Stadt',
	'DE15089235' => 'Nienburg (Saale), Stadt',
	'DE15089245' => 'Plötzkau',
	'DE15089305' => 'Schönebeck (Elbe), Stadt',
	'DE15089307' => 'Seeland, Stadt',
	'DE15089310' => 'Staßfurt, Stadt',
	'DE15089365' => 'Wolmirsleben',
	'DE15090003' => 'Aland',
	'DE15090007' => 'Altmärkische Höhe',
	'DE15090008' => 'Altmärkische Wische',
	'DE15090010' => 'Arneburg, Stadt',
	'DE15090070' => 'Bismark (Altmark), Stadt',
	'DE15090135' => 'Eichstedt (Altmark)',
	'DE15090180' => 'Goldbeck',
	'DE15090220' => 'Hassel',
	'DE15090225' => 'Havelberg, Hansestadt',
	'DE15090245' => 'Hohenberg-Krusemark',
	'DE15090270' => 'Iden',
	'DE15090285' => 'Kamern',
	'DE15090310' => 'Klietz',
	'DE15090415' => 'Osterburg (Altmark), Hansestadt',
	'DE15090435' => 'Rochau',
	'DE15090445' => 'Sandau (Elbe), Stadt',
	'DE15090485' => 'Schollene',
	'DE15090500' => 'Schönhausen (Elbe)',
	'DE15090520' => 'Seehausen (Altmark), Hansestadt',
	'DE15090535' => 'Stendal, Hansestadt',
	'DE15090546' => 'Tangerhütte, Stadt',
	'DE15090550' => 'Tangermünde, Stadt',
	'DE15090610' => 'Werben (Elbe), Hansestadt',
	'DE15090631' => 'Wust-Fischbeck',
	'DE15090635' => 'Zehrental',
	'DE15091010' => 'Annaburg, Stadt',
	'DE15091020' => 'Bad Schmiedeberg, Stadt',
	'DE15091060' => 'Coswig (Anhalt), Stadt',
	'DE15091110' => 'Gräfenhainichen, Stadt',
	'DE15091145' => 'Jessen (Elster), Stadt',
	'DE15091160' => 'Kemberg, Stadt',
	'DE15091241' => 'Oranienbaum-Wörlitz, Stadt',
	'DE15091375' => 'Wittenberg, Lutherstadt',
	'DE15091391' => 'Zahna-Elster, Stadt',
	'DE16051000' => 'Erfurt, Stadt',
	'DE16052000' => 'Gera, Stadt',
	'DE16053000' => 'Jena, Stadt',
	'DE16054000' => 'Suhl, Stadt',
	'DE16055000' => 'Weimar, Stadt',
	'DE16056000' => 'Eisenach, Stadt',
	'DE16061001' => 'Arenshausen',
	'DE16061002' => 'Asbach-Sickenberg',
	'DE16061003' => 'Berlingerode',
	'DE16061004' => 'Bernterode (bei Heilbad Heiligenstadt)',
	'DE16061007' => 'Birkenfelde',
	'DE16061012' => 'Bodenrode-Westhausen',
	'DE16061014' => 'Bornhagen',
	'DE16061015' => 'Brehme',
	'DE16061017' => 'Breitenworbis',
	'DE16061018' => 'Büttstedt',
	'DE16061019' => 'Buhla',
	'DE16061021' => 'Burgwalde',
	'DE16061022' => 'Deuna',
	'DE16061023' => 'Dieterode',
	'DE16061024' => 'Dietzenrode/Vatterode',
	'DE16061025' => 'Dingelstädt, Stadt',
	'DE16061026' => 'Ecklingerode',
	'DE16061027' => 'Effelder',
	'DE16061028' => 'Eichstruth',
	'DE16061031' => 'Ferna',
	'DE16061032' => 'Freienhagen',
	'DE16061033' => 'Fretterode',
	'DE16061034' => 'Geisleden',
	'DE16061035' => 'Geismar',
	'DE16061036' => 'Gerbershausen',
	'DE16061037' => 'Gernrode',
	'DE16061038' => 'Gerterode',
	'DE16061039' => 'Glasehausen',
	'DE16061041' => 'Großbartloff',
	'DE16061043' => 'Hausen',
	'DE16061044' => 'Haynrode',
	'DE16061045' => 'Heilbad Heiligenstadt, Stadt',
	'DE16061046' => 'Helmsdorf',
	'DE16061047' => 'Heuthen',
	'DE16061048' => 'Hohengandern',
	'DE16061049' => 'Hohes Kreuz',
	'DE16061054' => 'Kallmerode',
	'DE16061055' => 'Kefferhausen',
	'DE16061056' => 'Kella',
	'DE16061057' => 'Kirchgandern',
	'DE16061058' => 'Kirchworbis',
	'DE16061059' => 'Kleinbartloff',
	'DE16061061' => 'Kreuzebra',
	'DE16061062' => 'Krombach',
	'DE16061063' => 'Küllstedt',
	'DE16061065' => 'Lenterode',
	'DE16061066' => 'Lindewerra',
	'DE16061067' => 'Lutter',
	'DE16061068' => 'Mackenrode',
	'DE16061069' => 'Marth',
	'DE16061074' => 'Niederorschel',
	'DE16061075' => 'Pfaffschwende',
	'DE16061076' => 'Reinholterode',
	'DE16061077' => 'Röhrig',
	'DE16061078' => 'Rohrberg',
	'DE16061082' => 'Rustenfelde',
	'DE16061083' => 'Schachtebich',
	'DE16061084' => 'Schönhagen',
	'DE16061085' => 'Schwobfeld',
	'DE16061086' => 'Sickerode',
	'DE16061087' => 'Silberhausen',
	'DE16061089' => 'Steinbach',
	'DE16061091' => 'Steinheuterode',
	'DE16061094' => 'Tastungen',
	'DE16061096' => 'Thalwenden',
	'DE16061097' => 'Uder',
	'DE16061098' => 'Volkerode',
	'DE16061101' => 'Wachstedt',
	'DE16061102' => 'Wahlhausen',
	'DE16061103' => 'Wehnde',
	'DE16061105' => 'Wiesenfeld',
	'DE16061107' => 'Wingerode',
	'DE16061111' => 'Wüstheuterode',
	'DE16061113' => 'Schimberg',
	'DE16061114' => 'Teistungen',
	'DE16061115' => 'Leinefelde-Worbis, Stadt',
	'DE16061116' => 'Am Ohmberg',
	'DE16061117' => 'Sonnenstein',
	'DE16062002' => 'Bleicherode, Stadt',
	'DE16062005' => 'Ellrich, Stadt',
	'DE16062006' => 'Etzelsrode',
	'DE16062007' => 'Friedrichsthal',
	'DE16062008' => 'Görsbach',
	'DE16062009' => 'Großlohra',
	'DE16062014' => 'Hainrode/Hainleite',
	'DE16062024' => 'Kehmstedt',
	'DE16062025' => 'Kleinbodungen',
	'DE16062026' => 'Kleinfurra',
	'DE16062029' => 'Kraja',
	'DE16062033' => 'Lipprechterode',
	'DE16062037' => 'Niedergebra',
	'DE16062039' => 'Nohra',
	'DE16062041' => 'Nordhausen, Stadt',
	'DE16062049' => 'Sollstedt',
	'DE16062054' => 'Urbach',
	'DE16062058' => 'Wipperdorf',
	'DE16062059' => 'Wolkramshausen',
	'DE16062062' => 'Hohenstein',
	'DE16062063' => 'Werther',
	'DE16062064' => 'Heringen/Helme, Stadt',
	'DE16062065' => 'Harztor',
	'DE16063003' => 'Bad Salzungen, Stadt',
	'DE16063004' => 'Barchfeld-Immelborn',
	'DE16063006' => 'Berka v. d. Hainich',
	'DE16063007' => 'Berka/Werra, Stadt',
	'DE16063008' => 'Bischofroda',
	'DE16063009' => 'Brunnhartshausen',
	'DE16063011' => 'Buttlar',
	'DE16063013' => 'Creuzburg, Stadt',
	'DE16063014' => 'Dankmarshausen',
	'DE16063015' => 'Dermbach',
	'DE16063016' => 'Diedorf/Rhön',
	'DE16063017' => 'Dippach',
	'DE16063019' => 'Ebenshausen',
	'DE16063023' => 'Empfertshausen',
	'DE16063028' => 'Frankenroda',
	'DE16063032' => 'Geisa, Stadt',
	'DE16063033' => 'Gerstengrund',
	'DE16063036' => 'Großensee',
	'DE16063037' => 'Hallungen',
	'DE16063039' => 'Ifta',
	'DE16063046' => 'Krauthausen',
	'DE16063049' => 'Lauterbach',
	'DE16063051' => 'Leimbach',
	'DE16063055' => 'Mihla',
	'DE16063058' => 'Nazza',
	'DE16063059' => 'Neidhartshausen',
	'DE16063062' => 'Oechsen',
	'DE16063066' => 'Ruhla, Stadt',
	'DE16063068' => 'Schleid',
	'DE16063071' => 'Seebach',
	'DE16063072' => 'Stadtlengsfeld, Stadt',
	'DE16063076' => 'Treffurt, Stadt',
	'DE16063078' => 'Unterbreizbach',
	'DE16063081' => 'Urnshausen',
	'DE16063082' => 'Vacha, Stadt',
	'DE16063084' => 'Weilar',
	'DE16063086' => 'Wiesenthal',
	'DE16063092' => 'Wutha-Farnroda',
	'DE16063093' => 'Zella/Rhön',
	'DE16063094' => 'Moorgrund',
	'DE16063097' => 'Gerstungen',
	'DE16063098' => 'Hörselberg-Hainich',
	'DE16063099' => 'Bad Liebenstein, Stadt',
	'DE16063101' => 'Krayenberggemeinde',
	'DE16063102' => 'Kaltennordheim, Stadt',
	'DE16064001' => 'Altengottern',
	'DE16064003' => 'Bad Langensalza, Stadt',
	'DE16064004' => 'Bad Tennstedt, Stadt',
	'DE16064005' => 'Ballhausen',
	'DE16064007' => 'Blankenburg',
	'DE16064008' => 'Bothenheilingen',
	'DE16064009' => 'Bruchstedt',
	'DE16064014' => 'Dünwald',
	'DE16064017' => 'Flarchheim',
	'DE16064018' => 'Großengottern',
	'DE16064019' => 'Großvargula',
	'DE16064021' => 'Haussömmern',
	'DE16064022' => 'Herbsleben',
	'DE16064023' => 'Heroldishausen',
	'DE16064027' => 'Hornsömmern',
	'DE16064029' => 'Issersheilingen',
	'DE16064032' => 'Kammerforst',
	'DE16064033' => 'Kirchheilingen',
	'DE16064035' => 'Kleinwelsbach',
	'DE16064036' => 'Klettstedt',
	'DE16064037' => 'Körner',
	'DE16064038' => 'Kutzleben',
	'DE16064043' => 'Marolterode',
	'DE16064045' => 'Mittelsömmern',
	'DE16064046' => 'Mühlhausen/Thüringen, Stadt',
	'DE16064047' => 'Mülverstedt',
	'DE16064048' => 'Neunheilingen',
	'DE16064052' => 'Obermehler',
	'DE16064053' => 'Oppershausen',
	'DE16064055' => 'Rodeberg',
	'DE16064057' => 'Schlotheim, Stadt',
	'DE16064058' => 'Schönstedt',
	'DE16064061' => 'Sundhausen',
	'DE16064062' => 'Tottleben',
	'DE16064064' => 'Urleben',
	'DE16064065' => 'Weberstedt',
	'DE16064066' => 'Weinbergen',
	'DE16064071' => 'Unstruttal',
	'DE16064072' => 'Menteroda',
	'DE16064073' => 'Anrode',
	'DE16064074' => 'Südeichsfeld',
	'DE16064075' => 'Vogtei',
	'DE16065001' => 'Abtsbessingen',
	'DE16065002' => 'Artern/Unstrut, Stadt',
	'DE16065003' => 'Bad Frankenhausen/Kyffhäuser, Stadt',
	'DE16065005' => 'Bellstedt',
	'DE16065008' => 'Borxleben',
	'DE16065011' => 'Bretleben',
	'DE16065012' => 'Clingen, Stadt',
	'DE16065013' => 'Donndorf',
	'DE16065014' => 'Ebeleben, Stadt',
	'DE16065016' => 'Etzleben',
	'DE16065018' => 'Freienbessingen',
	'DE16065019' => 'Gehofen',
	'DE16065022' => 'Gorsleben',
	'DE16065023' => 'Greußen, Stadt',
	'DE16065031' => 'Hauteroda',
	'DE16065032' => 'Helbedündorf',
	'DE16065033' => 'Heldrungen, Stadt',
	'DE16065034' => 'Hemleben',
	'DE16065035' => 'Heygendorf',
	'DE16065038' => 'Holzsußra',
	'DE16065039' => 'Ichstedt',
	'DE16065042' => 'Kalbsrieth',
	'DE16065046' => 'Mönchpfiffel-Nikolausrieth',
	'DE16065047' => 'Nausitz',
	'DE16065048' => 'Niederbösa',
	'DE16065051' => 'Oberbösa',
	'DE16065052' => 'Oberheldrungen',
	'DE16065054' => 'Oldisleben',
	'DE16065056' => 'Reinsdorf',
	'DE16065057' => 'Ringleben',
	'DE16065058' => 'Rockstedt',
	'DE16065061' => 'Roßleben, Stadt',
	'DE16065067' => 'Sondershausen, Stadt',
	'DE16065072' => 'Thüringenhausen',
	'DE16065074' => 'Topfstedt',
	'DE16065075' => 'Trebra',
	'DE16065076' => 'Voigtstedt',
	'DE16065077' => 'Wasserthaleben',
	'DE16065079' => 'Westgreußen',
	'DE16065081' => 'Wiehe, Stadt',
	'DE16065082' => 'Wolferschwenda',
	'DE16065084' => 'Großenehrich, Stadt',
	'DE16065085' => 'Kyffhäuserland',
	'DE16066001' => 'Altersbach',
	'DE16066002' => 'Aschenhausen',
	'DE16066005' => 'Belrieth',
	'DE16066006' => 'Benshausen',
	'DE16066008' => 'Bermbach',
	'DE16066012' => 'Birx',
	'DE16066013' => 'Breitungen/Werra',
	'DE16066015' => 'Christes',
	'DE16066016' => 'Dillstädt',
	'DE16066017' => 'Einhausen',
	'DE16066018' => 'Ellingshausen',
	'DE16066019' => 'Erbenhausen',
	'DE16066022' => 'Fambach',
	'DE16066023' => 'Floh-Seligenthal',
	'DE16066024' => 'Frankenheim/Rhön',
	'DE16066025' => 'Friedelshausen',
	'DE16066028' => 'Henneberg',
	'DE16066033' => 'Hümpfershausen',
	'DE16066035' => 'Kaltensundheim',
	'DE16066036' => 'Kaltenwestheim',
	'DE16066038' => 'Kühndorf',
	'DE16066039' => 'Leutersdorf',
	'DE16066041' => 'Mehmels',
	'DE16066042' => 'Meiningen, Stadt',
	'DE16066043' => 'Melpers',
	'DE16066044' => 'Metzels',
	'DE16066045' => 'Neubrunn',
	'DE16066047' => 'Oberhof, Stadt',
	'DE16066048' => 'Oberkatz',
	'DE16066049' => 'Obermaßfeld-Grimmenthal',
	'DE16066051' => 'Oberschönau, Kurort',
	'DE16066052' => 'Oberweid',
	'DE16066053' => 'Oepfershausen',
	'DE16066056' => 'Rippershausen',
	'DE16066057' => 'Ritschenhausen',
	'DE16066058' => 'Rohr',
	'DE16066059' => 'Rosa',
	'DE16066061' => 'Roßdorf',
	'DE16066062' => 'Rotterode',
	'DE16066063' => 'Schmalkalden, Kurort, Stadt',
	'DE16066064' => 'Schwallungen',
	'DE16066065' => 'Schwarza',
	'DE16066069' => 'Steinbach-Hallenberg, Kurort, Stadt',
	'DE16066071' => 'Stepfershausen',
	'DE16066073' => 'Sülzfeld',
	'DE16066074' => 'Brotterode-Trusetal, Stadt',
	'DE16066075' => 'Unterkatz',
	'DE16066076' => 'Untermaßfeld',
	'DE16066077' => 'Unterschönau',
	'DE16066078' => 'Unterweid',
	'DE16066079' => 'Utendorf',
	'DE16066081' => 'Vachdorf',
	'DE16066082' => 'Viernau',
	'DE16066083' => 'Wahns',
	'DE16066084' => 'Wallbach',
	'DE16066085' => 'Walldorf',
	'DE16066086' => 'Wasungen, Stadt',
	'DE16066088' => 'Wölfershausen',
	'DE16066092' => 'Zella-Mehlis, Stadt',
	'DE16066093' => 'Rhönblick',
	'DE16066094' => 'Grabfeld',
	'DE16067003' => 'Ballstädt',
	'DE16067004' => 'Bienstädt',
	'DE16067005' => 'Brüheim',
	'DE16067006' => 'Bufleben',
	'DE16067008' => 'Crawinkel',
	'DE16067009' => 'Dachwig',
	'DE16067011' => 'Döllstädt',
	'DE16067013' => 'Emleben',
	'DE16067016' => 'Eschenbergen',
	'DE16067019' => 'Friedrichroda, Stadt',
	'DE16067021' => 'Friedrichswerth',
	'DE16067022' => 'Friemar',
	'DE16067025' => 'Georgenthal/Thür. Wald',
	'DE16067026' => 'Gierstädt',
	'DE16067027' => 'Goldbach',
	'DE16067029' => 'Gotha, Stadt',
	'DE16067032' => 'Gräfenhain',
	'DE16067033' => 'Großfahner',
	'DE16067035' => 'Haina',
	'DE16067036' => 'Herrenhof',
	'DE16067037' => 'Hochheim',
	'DE16067039' => 'Hohenkirchen',
	'DE16067044' => 'Luisenthal',
	'DE16067047' => 'Molschleben',
	'DE16067052' => 'Nottleben',
	'DE16067053' => 'Ohrdruf, Stadt',
	'DE16067054' => 'Petriroda',
	'DE16067055' => 'Pferdingsleben',
	'DE16067056' => 'Remstädt',
	'DE16067059' => 'Schwabhausen',
	'DE16067063' => 'Sonneborn',
	'DE16067064' => 'Bad Tabarz',
	'DE16067065' => 'Tambach-Dietharz/Thür. Wald, Stadt',
	'DE16067067' => 'Tonna',
	'DE16067068' => 'Tröchtelborn',
	'DE16067071' => 'Tüttleben',
	'DE16067072' => 'Waltershausen, Stadt',
	'DE16067074' => 'Wangenheim',
	'DE16067075' => 'Warza',
	'DE16067078' => 'Westhausen',
	'DE16067081' => 'Wölfis',
	'DE16067082' => 'Zimmernsupra',
	'DE16067083' => 'Leinatal',
	'DE16067087' => 'Nesse-Apfelstädt',
	'DE16067088' => 'Hörsel',
	'DE16067089' => 'Drei Gleichen',
	'DE16068001' => 'Alperstedt',
	'DE16068002' => 'Andisleben',
	'DE16068003' => 'Beichlingen',
	'DE16068004' => 'Bilzingsleben',
	'DE16068005' => 'Büchel',
	'DE16068006' => 'Buttstädt, Stadt',
	'DE16068007' => 'Eckstedt',
	'DE16068008' => 'Ellersleben',
	'DE16068009' => 'Elxleben',
	'DE16068011' => 'Eßleben-Teutleben',
	'DE16068012' => 'Frömmstedt',
	'DE16068013' => 'Gangloffsömmern',
	'DE16068014' => 'Gebesee, Stadt',
	'DE16068015' => 'Griefstedt',
	'DE16068016' => 'Großbrembach',
	'DE16068017' => 'Großmölsen',
	'DE16068019' => 'Großneuhausen',
	'DE16068021' => 'Großrudestedt',
	'DE16068022' => 'Günstedt',
	'DE16068023' => 'Guthmannshausen',
	'DE16068024' => 'Hardisleben',
	'DE16068025' => 'Haßleben',
	'DE16068026' => 'Henschleben',
	'DE16068027' => 'Herrnschwende',
	'DE16068028' => 'Kannawurf',
	'DE16068029' => 'Kindelbrück, Stadt',
	'DE16068031' => 'Kleinbrembach',
	'DE16068032' => 'Kleinmölsen',
	'DE16068033' => 'Kleinneuhausen',
	'DE16068034' => 'Kölleda, Stadt',
	'DE16068035' => 'Mannstedt',
	'DE16068036' => 'Markvippach',
	'DE16068037' => 'Nöda',
	'DE16068038' => 'Olbersleben',
	'DE16068039' => 'Ollendorf',
	'DE16068041' => 'Ostramondra',
	'DE16068042' => 'Rastenberg, Stadt',
	'DE16068043' => 'Riethgen',
	'DE16068044' => 'Riethnordhausen',
	'DE16068045' => 'Ringleben',
	'DE16068046' => 'Rudersdorf',
	'DE16068048' => 'Schloßvippach',
	'DE16068049' => 'Schwerstedt',
	'DE16068051' => 'Sömmerda, Stadt',
	'DE16068052' => 'Sprötau',
	'DE16068053' => 'Straußfurt',
	'DE16068055' => 'Udestedt',
	'DE16068056' => 'Vogelsberg',
	'DE16068057' => 'Walschleben',
	'DE16068058' => 'Weißensee, Stadt',
	'DE16068059' => 'Werningshausen',
	'DE16068061' => 'Witterda',
	'DE16068062' => 'Wundersleben',
	'DE16069001' => 'Ahlstädt',
	'DE16069002' => 'Bad Colberg-Heldburg, Stadt',
	'DE16069003' => 'Beinerstadt',
	'DE16069004' => 'Bischofrod',
	'DE16069006' => 'Brünn/Thür.',
	'DE16069008' => 'Dingsleben',
	'DE16069009' => 'Ehrenberg',
	'DE16069011' => 'Eichenberg',
	'DE16069012' => 'Eisfeld, Stadt',
	'DE16069015' => 'Gompertshausen',
	'DE16069016' => 'Grimmelshausen',
	'DE16069017' => 'Grub',
	'DE16069019' => 'Hellingen',
	'DE16069021' => 'Henfstädt',
	'DE16069024' => 'Hildburghausen, Stadt',
	'DE16069025' => 'Kloster Veßra',
	'DE16069026' => 'Lengfeld',
	'DE16069028' => 'Marisfeld',
	'DE16069035' => 'Oberstadt',
	'DE16069037' => 'Reurieth',
	'DE16069039' => 'Sachsenbrunn',
	'DE16069041' => 'Schlechtsart',
	'DE16069042' => 'Schleusegrund',
	'DE16069043' => 'Schleusingen, Stadt',
	'DE16069044' => 'Schmeheim',
	'DE16069046' => 'Schweickershausen',
	'DE16069047' => 'St.Bernhard',
	'DE16069049' => 'Straufhain',
	'DE16069051' => 'Themar, Stadt',
	'DE16069052' => 'Ummerstadt, Stadt',
	'DE16069053' => 'Veilsdorf',
	'DE16069056' => 'Westhausen',
	'DE16069058' => 'Auengrund',
	'DE16069061' => 'Masserberg',
	'DE16069062' => 'Römhild, Stadt',
	'DE16070001' => 'Alkersleben',
	'DE16070002' => 'Altenfeld',
	'DE16070003' => 'Angelroda',
	'DE16070004' => 'Arnstadt, Stadt',
	'DE16070005' => 'Böhlen',
	'DE16070006' => 'Bösleben-Wüllersleben',
	'DE16070008' => 'Dornheim',
	'DE16070011' => 'Elgersburg',
	'DE16070012' => 'Elleben',
	'DE16070013' => 'Elxleben',
	'DE16070014' => 'Frankenhain',
	'DE16070015' => 'Frauenwald',
	'DE16070016' => 'Friedersdorf',
	'DE16070017' => 'Gehlberg',
	'DE16070019' => 'Geraberg',
	'DE16070021' => 'Geschwenda',
	'DE16070022' => 'Gillersdorf',
	'DE16070023' => 'Gossel',
	'DE16070024' => 'Gräfenroda',
	'DE16070025' => 'Großbreitenbach, Stadt',
	'DE16070027' => 'Herschdorf',
	'DE16070028' => 'Amt Wachsenburg',
	'DE16070029' => 'Ilmenau, Stadt',
	'DE16070031' => 'Kirchheim',
	'DE16070033' => 'Liebenstein',
	'DE16070034' => 'Martinroda',
	'DE16070037' => 'Neusiß',
	'DE16070038' => 'Neustadt am Rennsteig',
	'DE16070041' => 'Osthausen-Wülfershausen',
	'DE16070043' => 'Plaue, Stadt',
	'DE16070044' => 'Rockhausen',
	'DE16070046' => 'Schmiedefeld am Rennsteig',
	'DE16070048' => 'Stadtilm, Stadt',
	'DE16070049' => 'Stützerbach',
	'DE16070052' => 'Wildenspring',
	'DE16070053' => 'Wipfratal',
	'DE16070054' => 'Witzleben',
	'DE16071001' => 'Apolda, Stadt',
	'DE16071003' => 'Bad Berka, Stadt',
	'DE16071004' => 'Bad Sulza, Stadt',
	'DE16071005' => 'Ballstedt',
	'DE16071006' => 'Bechstedtstraß',
	'DE16071007' => 'Berlstedt',
	'DE16071008' => 'Blankenhain, Stadt',
	'DE16071009' => 'Buchfart',
	'DE16071011' => 'Buttelstedt, Stadt',
	'DE16071012' => 'Daasdorf a. Berge',
	'DE16071013' => 'Döbritschen',
	'DE16071015' => 'Eberstedt',
	'DE16071017' => 'Ettersburg',
	'DE16071019' => 'Frankendorf',
	'DE16071022' => 'Großheringen',
	'DE16071023' => 'Großobringen',
	'DE16071025' => 'Großschwabhausen',
	'DE16071027' => 'Hammerstedt',
	'DE16071028' => 'Heichelheim',
	'DE16071031' => 'Hetschburg',
	'DE16071032' => 'Hohenfelden',
	'DE16071034' => 'Hopfgarten',
	'DE16071036' => 'Isseroda',
	'DE16071037' => 'Kapellendorf',
	'DE16071038' => 'Kiliansroda',
	'DE16071039' => 'Kleinobringen',
	'DE16071042' => 'Kleinschwabhausen',
	'DE16071043' => 'Klettbach',
	'DE16071044' => 'Ködderitzsch',
	'DE16071046' => 'Kranichfeld, Stadt',
	'DE16071047' => 'Krautheim',
	'DE16071048' => 'Kromsdorf',
	'DE16071049' => 'Lehnstedt',
	'DE16071051' => 'Leutenthal',
	'DE16071053' => 'Magdala, Stadt',
	'DE16071055' => 'Mechelroda',
	'DE16071056' => 'Mellingen',
	'DE16071057' => 'Mönchenholzhausen',
	'DE16071059' => 'Nauendorf',
	'DE16071061' => 'Neumark, Stadt',
	'DE16071064' => 'Niedertrebra',
	'DE16071065' => 'Niederzimmern',
	'DE16071067' => 'Nohra',
	'DE16071069' => 'Obertrebra',
	'DE16071071' => 'Oettern',
	'DE16071073' => 'Ottstedt a. Berge',
	'DE16071076' => 'Ramsla',
	'DE16071077' => 'Rannstedt',
	'DE16071079' => 'Rittersdorf',
	'DE16071081' => 'Rohrbach',
	'DE16071082' => 'Sachsenhausen',
	'DE16071083' => 'Schmiedehausen',
	'DE16071085' => 'Schwerstedt',
	'DE16071087' => 'Tonndorf',
	'DE16071088' => 'Troistedt',
	'DE16071089' => 'Umpferstedt',
	'DE16071092' => 'Vippachedelhausen',
	'DE16071093' => 'Vollersroda',
	'DE16071095' => 'Wiegendorf',
	'DE16071097' => 'Wohlsborn',
	'DE16071099' => 'Saaleplatte',
	'DE16071101' => 'Ilmtal-Weinstraße',
	'DE16072001' => 'Bachfeld',
	'DE16072006' => 'Goldisthal',
	'DE16072011' => 'Lauscha, Stadt',
	'DE16072013' => 'Neuhaus am Rennweg, Stadt',
	'DE16072015' => 'Schalkau, Stadt',
	'DE16072018' => 'Sonneberg, Stadt',
	'DE16072019' => 'Steinach, Stadt',
	'DE16072023' => 'Frankenblick',
	'DE16072024' => 'Föritztal',
	'DE16073001' => 'Allendorf',
	'DE16073002' => 'Altenbeuthen',
	'DE16073005' => 'Bad Blankenburg, Stadt',
	'DE16073006' => 'Bechstedt',
	'DE16073013' => 'Cursdorf',
	'DE16073014' => 'Deesbach',
	'DE16073017' => 'Döschnitz',
	'DE16073021' => 'Dröbischau',
	'DE16073028' => 'Gräfenthal, Stadt',
	'DE16073035' => 'Hohenwarte',
	'DE16073037' => 'Katzhütte',
	'DE16073038' => 'Kaulsdorf',
	'DE16073046' => 'Lehesten, Stadt',
	'DE16073049' => 'Lichte',
	'DE16073054' => 'Mellenbach-Glasbach',
	'DE16073055' => 'Meura',
	'DE16073056' => 'Meuselbach-Schwarzmühle',
	'DE16073063' => 'Oberhain',
	'DE16073065' => 'Oberweißbach/Thür. Wald, Stadt',
	'DE16073066' => 'Piesau',
	'DE16073067' => 'Probstzella',
	'DE16073068' => 'Reichmannsdorf',
	'DE16073074' => 'Rohrbach',
	'DE16073076' => 'Rudolstadt, Stadt',
	'DE16073077' => 'Saalfeld/Saale, Stadt',
	'DE16073079' => 'Schmiedefeld',
	'DE16073082' => 'Schwarzburg',
	'DE16073084' => 'Sitzendorf',
	'DE16073094' => 'Unterweißbach',
	'DE16073105' => 'Remda-Teichel, Stadt',
	'DE16073106' => 'Leutenberg, Stadt',
	'DE16073107' => 'Drognitz',
	'DE16073109' => 'Uhlstädt-Kirchhasel',
	'DE16073111' => 'Unterwellenborn',
	'DE16073112' => 'Königsee-Rottenbach, Stadt',
	'DE16074001' => 'Albersdorf',
	'DE16074002' => 'Altenberga',
	'DE16074003' => 'Bad Klosterlausnitz',
	'DE16074004' => 'Bibra',
	'DE16074005' => 'Bobeck',
	'DE16074006' => 'Bollberg',
	'DE16074007' => 'Bremsnitz',
	'DE16074008' => 'Bucha',
	'DE16074009' => 'Bürgel, Stadt',
	'DE16074011' => 'Dornburg-Camburg, Stadt',
	'DE16074012' => 'Crossen an der Elster',
	'DE16074016' => 'Eichenberg',
	'DE16074017' => 'Eineborn',
	'DE16074018' => 'Eisenberg, Stadt',
	'DE16074019' => 'Frauenprießnitz',
	'DE16074021' => 'Freienorla',
	'DE16074022' => 'Geisenhain',
	'DE16074024' => 'Gneus',
	'DE16074025' => 'Gösen',
	'DE16074026' => 'Golmsdorf',
	'DE16074028' => 'Graitschen b. Bürgel',
	'DE16074029' => 'Großbockedra',
	'DE16074031' => 'Großeutersdorf',
	'DE16074032' => 'Großlöbichau',
	'DE16074033' => 'Großpürschütz',
	'DE16074034' => 'Gumperda',
	'DE16074036' => 'Hainichen',
	'DE16074037' => 'Hainspitz',
	'DE16074038' => 'Hartmannsdorf',
	'DE16074039' => 'Heideland',
	'DE16074041' => 'Hermsdorf, Stadt',
	'DE16074042' => 'Hummelshain',
	'DE16074043' => 'Jenalöbnitz',
	'DE16074044' => 'Kahla, Stadt',
	'DE16074045' => 'Karlsdorf',
	'DE16074046' => 'Kleinbockedra',
	'DE16074047' => 'Kleinebersdorf',
	'DE16074048' => 'Kleineutersdorf',
	'DE16074049' => 'Laasdorf',
	'DE16074051' => 'Lehesten',
	'DE16074052' => 'Lindig',
	'DE16074053' => 'Lippersdorf-Erdmannsdorf',
	'DE16074054' => 'Löberschütz',
	'DE16074055' => 'Mertendorf',
	'DE16074056' => 'Meusebach',
	'DE16074057' => 'Milda',
	'DE16074058' => 'Möckern',
	'DE16074059' => 'Mörsdorf',
	'DE16074061' => 'Nausnitz',
	'DE16074063' => 'Neuengönna',
	'DE16074064' => 'Oberbodnitz',
	'DE16074065' => 'Orlamünde, Stadt',
	'DE16074066' => 'Ottendorf',
	'DE16074067' => 'Petersberg',
	'DE16074068' => 'Poxdorf',
	'DE16074069' => 'Quirla',
	'DE16074071' => 'Rattelsdorf',
	'DE16074072' => 'Rauda',
	'DE16074073' => 'Rauschwitz',
	'DE16074074' => 'Rausdorf',
	'DE16074075' => 'Reichenbach',
	'DE16074076' => 'Reinstädt',
	'DE16074077' => 'Renthendorf',
	'DE16074079' => 'Rothenstein',
	'DE16074081' => 'Ruttersdorf-Lotschen',
	'DE16074082' => 'Scheiditz',
	'DE16074084' => 'Schleifreisen',
	'DE16074085' => 'Schlöben',
	'DE16074086' => 'Schöngleina',
	'DE16074087' => 'Schöps',
	'DE16074089' => 'Seitenroda',
	'DE16074091' => 'Serba',
	'DE16074092' => 'Silbitz',
	'DE16074093' => 'St.Gangloff',
	'DE16074094' => 'Stadtroda, Stadt',
	'DE16074095' => 'Sulza',
	'DE16074096' => 'Tautenburg',
	'DE16074097' => 'Tautendorf',
	'DE16074098' => 'Tautenhain',
	'DE16074099' => 'Thierschneck',
	'DE16074101' => 'Tissa',
	'DE16074102' => 'Trockenborn-Wolfersdorf',
	'DE16074103' => 'Tröbnitz',
	'DE16074104' => 'Unterbodnitz',
	'DE16074105' => 'Waldeck',
	'DE16074106' => 'Walpernhain',
	'DE16074107' => 'Waltersdorf',
	'DE16074108' => 'Weißbach',
	'DE16074109' => 'Weißenborn',
	'DE16074112' => 'Wichmar',
	'DE16074113' => 'Zimmern',
	'DE16074114' => 'Zöllnitz',
	'DE16074116' => 'Schkölen, Stadt',
	'DE16075002' => 'Birkenhügel',
	'DE16075003' => 'Blankenberg',
	'DE16075004' => 'Blankenstein',
	'DE16075006' => 'Bodelwitz',
	'DE16075008' => 'Bucha',
	'DE16075009' => 'Burgk',
	'DE16075013' => 'Crispendorf',
	'DE16075014' => 'Dittersdorf',
	'DE16075016' => 'Döbritz',
	'DE16075018' => 'Dreba',
	'DE16075019' => 'Dreitzsch',
	'DE16075023' => 'Eßbach',
	'DE16075029' => 'Geroda',
	'DE16075031' => 'Gertewitz',
	'DE16075033' => 'Görkwitz',
	'DE16075034' => 'Göschitz',
	'DE16075035' => 'Gössitz',
	'DE16075039' => 'Grobengereuth',
	'DE16075042' => 'Harra',
	'DE16075046' => 'Hirschberg, Stadt',
	'DE16075047' => 'Keila',
	'DE16075048' => 'Kirschkau',
	'DE16075049' => 'Knau',
	'DE16075051' => 'Kospoda',
	'DE16075054' => 'Langenorla',
	'DE16075056' => 'Lausnitz b. Neustadt an der Orla',
	'DE16075057' => 'Lemnitz',
	'DE16075061' => 'Linda b. Neustadt an der Orla',
	'DE16075062' => 'Bad Lobenstein, Stadt',
	'DE16075063' => 'Löhma',
	'DE16075065' => 'Miesitz',
	'DE16075066' => 'Mittelpöllnitz',
	'DE16075068' => 'Moßbach',
	'DE16075069' => 'Moxa',
	'DE16075071' => 'Neundorf (bei Lobenstein)',
	'DE16075072' => 'Neundorf (bei Schleiz)',
	'DE16075073' => 'Neustadt an der Orla, Stadt',
	'DE16075074' => 'Nimritz',
	'DE16075075' => 'Oberoppurg',
	'DE16075076' => 'Oettersdorf',
	'DE16075077' => 'Oppurg',
	'DE16075079' => 'Paska',
	'DE16075081' => 'Peuschen',
	'DE16075083' => 'Plothen',
	'DE16075084' => 'Pörmitz',
	'DE16075085' => 'Pößneck, Stadt',
	'DE16075086' => 'Pottiga',
	'DE16075087' => 'Quaschwitz',
	'DE16075088' => 'Ranis, Stadt',
	'DE16075093' => 'Rosendorf',
	'DE16075097' => 'Schlegel',
	'DE16075098' => 'Schleiz, Stadt',
	'DE16075099' => 'Schmieritz',
	'DE16075101' => 'Schmorda',
	'DE16075102' => 'Schöndorf',
	'DE16075103' => 'Seisla',
	'DE16075105' => 'Solkwitz',
	'DE16075106' => 'Stanau',
	'DE16075109' => 'Tegau',
	'DE16075114' => 'Tömmelsdorf',
	'DE16075116' => 'Triptis, Stadt',
	'DE16075119' => 'Volkmannsdorf',
	'DE16075121' => 'Weira',
	'DE16075124' => 'Wernburg',
	'DE16075125' => 'Wilhelmsdorf',
	'DE16075127' => 'Ziegenrück, Stadt',
	'DE16075129' => 'Krölpa',
	'DE16075131' => 'Gefell, Stadt',
	'DE16075132' => 'Tanna, Stadt',
	'DE16075133' => 'Wurzbach, Stadt',
	'DE16075134' => 'Remptendorf',
	'DE16075135' => 'Saalburg-Ebersdorf, Stadt',
	'DE16076003' => 'Bad Köstritz, Stadt',
	'DE16076004' => 'Berga/Elster, Stadt',
	'DE16076006' => 'Bethenhausen',
	'DE16076007' => 'Bocka',
	'DE16076008' => 'Brahmenau',
	'DE16076009' => 'Braunichswalde',
	'DE16076012' => 'Caaschwitz',
	'DE16076014' => 'Crimla',
	'DE16076017' => 'Endschütz',
	'DE16076019' => 'Gauern',
	'DE16076022' => 'Greiz, Stadt',
	'DE16076023' => 'Großenstein',
	'DE16076026' => 'Hartmannsdorf',
	'DE16076027' => 'Hilbersdorf',
	'DE16076028' => 'Hirschfeld',
	'DE16076029' => 'Hohenleuben, Stadt',
	'DE16076033' => 'Hundhaupten',
	'DE16076034' => 'Kauern',
	'DE16076036' => 'Korbußen',
	'DE16076038' => 'Kühdorf',
	'DE16076039' => 'Langenwetzendorf',
	'DE16076041' => 'Langenwolschendorf',
	'DE16076042' => 'Lederhose',
	'DE16076043' => 'Linda b. Weida',
	'DE16076044' => 'Lindenkreuz',
	'DE16076049' => 'Münchenbernsdorf, Stadt',
	'DE16076052' => 'Neumühle/Elster',
	'DE16076055' => 'Paitzdorf',
	'DE16076058' => 'Pölzig',
	'DE16076059' => 'Reichstädt',
	'DE16076061' => 'Ronneburg, Stadt',
	'DE16076062' => 'Rückersdorf',
	'DE16076064' => 'Saara',
	'DE16076067' => 'Schwaara',
	'DE16076068' => 'Schwarzbach',
	'DE16076069' => 'Seelingstädt',
	'DE16076074' => 'Teichwitz',
	'DE16076079' => 'Weida, Stadt',
	'DE16076081' => 'Weißendorf',
	'DE16076084' => 'Wünschendorf/Elster',
	'DE16076086' => 'Zedlitz',
	'DE16076087' => 'Zeulenroda-Triebes, Stadt',
	'DE16076088' => 'Harth-Pöllnitz',
	'DE16076089' => 'Kraftsdorf',
	'DE16076092' => 'Auma-Weidatal, Stadt',
	'DE16076093' => 'Mohlsdorf-Teichwolframsdorf',
	'DE16077001' => 'Altenburg, Stadt',
	'DE16077002' => 'Altkirchen',
	'DE16077003' => 'Dobitschen',
	'DE16077004' => 'Drogen',
	'DE16077005' => 'Fockendorf',
	'DE16077007' => 'Gerstenberg',
	'DE16077008' => 'Göhren',
	'DE16077009' => 'Göllnitz',
	'DE16077011' => 'Göpfersdorf',
	'DE16077012' => 'Gößnitz, Stadt',
	'DE16077015' => 'Haselbach',
	'DE16077016' => 'Heukewalde',
	'DE16077017' => 'Heyersdorf',
	'DE16077018' => 'Jonaswalde',
	'DE16077022' => 'Kriebitzsch',
	'DE16077023' => 'Langenleuba-Niederhain',
	'DE16077026' => 'Löbichau',
	'DE16077027' => 'Lödla',
	'DE16077028' => 'Lucka, Stadt',
	'DE16077029' => 'Lumpzig',
	'DE16077031' => 'Mehna',
	'DE16077032' => 'Meuselwitz, Stadt',
	'DE16077034' => 'Monstab',
	'DE16077036' => 'Nobitz',
	'DE16077037' => 'Nöbdenitz',
	'DE16077039' => 'Ponitz',
	'DE16077041' => 'Posterstein',
	'DE16077042' => 'Rositz',
	'DE16077043' => 'Schmölln, Stadt',
	'DE16077044' => 'Starkenberg',
	'DE16077047' => 'Thonhausen',
	'DE16077048' => 'Treben',
	'DE16077049' => 'Vollmershain',
	'DE16077051' => 'Wildenbörten',
	'DE16077052' => 'Windischleuba',
];
