<?php

/**
 * List of cities for: Colombia
 * Source: https://www.dane.gov.co/index.php/estadisticas-por-tema/demografia-y-poblacion/censo-nacional-de-poblacion-y-vivenda-2018/informacion-tecnica
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'CO05'	=> 'Antioquia',
	'CO08'	=> 'Atlántico',
	'CO11'	=> 'Bogotá, D.C.',
	'CO13'	=> 'Bolívar',
	'CO15'	=> 'Boyacá',
	'CO17'	=> 'Caldas',
	'CO18'	=> 'Caquetá',
	'CO19'	=> 'Cauca',
	'CO20'	=> 'Cesar',
	'CO23'	=> 'Córdoba ',
	'CO25'	=> 'Cundinamarca',
	'CO27'	=> 'Chocó',
	'CO41'	=> 'Huila',
	'CO44'	=> 'La Guajira',
	'CO47'	=> 'Magdalena',
	'CO50'	=> 'Meta',
	'CO52'	=> 'Nariño',
	'CO54'	=> 'Norte de Santander',
	'CO63'	=> 'Quindio',
	'CO66'	=> 'Risaralda',
	'CO68'	=> 'Santander',
	'CO70'	=> 'Sucre',
	'CO73'	=> 'Tolima',
	'CO76'	=> 'Valle del Cauca',
	'CO81'	=> 'Arauca',
	'CO85'	=> 'Casanare',
	'CO86'	=> 'Putumayo',
	'CO88'	=> 'Archipiélago de San Andrés',
	'CO91'	=> 'Amazonas',
	'CO94'	=> 'Guainía',
	'CO95'	=> 'Guaviare',
	'CO97'	=> 'Vaupés',
	'CO99'	=> 'Vichada',
];

$country_cities = [
	'CO05' => [
		'CO05001' => 'Medellín',
		'CO05002' => 'Abejorral',
		'CO05004' => 'Abriaquí',
		'CO05021' => 'Alejandría',
		'CO05030' => 'Amagá',
		'CO05031' => 'Amalfi',
		'CO05034' => 'Andes',
		'CO05036' => 'Angelópolis',
		'CO05038' => 'Angostura',
		'CO05040' => 'Anorí',
		'CO05042' => 'Santafé de Antioquia',
		'CO05044' => 'Anza',
		'CO05045' => 'Apartadó',
		'CO05051' => 'Arboletes',
		'CO05055' => 'Argelia',
		'CO05059' => 'Armenia',
		'CO05079' => 'Barbosa',
		'CO05086' => 'Belmira',
		'CO05088' => 'Bello',
		'CO05091' => 'Betania',
		'CO05093' => 'Betulia',
		'CO05101' => 'Ciudad Bolívar',
		'CO05107' => 'Briceño',
		'CO05113' => 'Buriticá',
		'CO05120' => 'Cáceres',
		'CO05125' => 'Caicedo',
		'CO05129' => 'Caldas',
		'CO05134' => 'Campamento',
		'CO05138' => 'Cañasgordas',
		'CO05142' => 'Caracolí',
		'CO05145' => 'Caramanta',
		'CO05147' => 'Carepa',
		'CO05148' => 'El Carmen de Viboral',
		'CO05150' => 'Carolina',
		'CO05154' => 'Caucasia',
		'CO05172' => 'Chigorodó',
		'CO05190' => 'Cisneros',
		'CO05197' => 'Cocorná',
		'CO05206' => 'Concepción',
		'CO05209' => 'Concordia',
		'CO05212' => 'Copacabana',
		'CO05234' => 'Dabeiba',
		'CO05237' => 'Don Matías',
		'CO05240' => 'Ebéjico',
		'CO05250' => 'El Bagre',
		'CO05264' => 'Entrerrios',
		'CO05266' => 'Envigado',
		'CO05282' => 'Fredonia',
		'CO05284' => 'Frontino',
		'CO05306' => 'Giraldo',
		'CO05308' => 'Girardota',
		'CO05310' => 'Gómez Plata',
		'CO05313' => 'Granada',
		'CO05315' => 'Guadalupe',
		'CO05318' => 'Guarne',
		'CO05321' => 'Guatapé',
		'CO05347' => 'Heliconia',
		'CO05353' => 'Hispania',
		'CO05360' => 'Itagui',
		'CO05361' => 'Ituango',
		'CO05364' => 'Jardín',
		'CO05368' => 'Jericó',
		'CO05376' => 'La Ceja',
		'CO05380' => 'La Estrella',
		'CO05390' => 'La Pintada',
		'CO05400' => 'La Unión',
		'CO05411' => 'Liborina',
		'CO05425' => 'Maceo',
		'CO05440' => 'Marinilla',
		'CO05467' => 'Montebello',
		'CO05475' => 'Murindó',
		'CO05480' => 'Mutatá',
		'CO05483' => 'Nariño',
		'CO05490' => 'Necoclí',
		'CO05495' => 'Nechí',
		'CO05501' => 'Olaya',
		'CO05541' => 'Peñol',
		'CO05543' => 'Peque',
		'CO05576' => 'Pueblorrico',
		'CO05579' => 'Puerto Berrío',
		'CO05585' => 'Puerto Nare',
		'CO05591' => 'Puerto Triunfo',
		'CO05604' => 'Remedios',
		'CO05607' => 'Retiro',
		'CO05615' => 'Rionegro',
		'CO05628' => 'Sabanalarga',
		'CO05631' => 'Sabaneta',
		'CO05642' => 'Salgar',
		'CO05647' => 'San Andrés de Cuerquía',
		'CO05649' => 'San Carlos',
		'CO05652' => 'San Francisco',
		'CO05656' => 'San Jerónimo',
		'CO05658' => 'San José de La Montaña',
		'CO05659' => 'San Juan de Urabá',
		'CO05660' => 'San Luis',
		'CO05664' => 'San Pedro',
		'CO05665' => 'San Pedro de Uraba',
		'CO05667' => 'San Rafael',
		'CO05670' => 'San Roque',
		'CO05674' => 'San Vicente',
		'CO05679' => 'Santa Bárbara',
		'CO05686' => 'Santa Rosa de Osos',
		'CO05690' => 'Santo Domingo',
		'CO05697' => 'El Santuario',
		'CO05736' => 'Segovia',
		'CO05756' => 'Sonson',
		'CO05761' => 'Sopetrán',
		'CO05789' => 'Támesis',
		'CO05790' => 'Tarazá',
		'CO05792' => 'Tarso',
		'CO05809' => 'Titiribí',
		'CO05819' => 'Toledo',
		'CO05837' => 'Turbo',
		'CO05842' => 'Uramita',
		'CO05847' => 'Urrao',
		'CO05854' => 'Valdivia',
		'CO05856' => 'Valparaíso',
		'CO05858' => 'Vegachí',
		'CO05861' => 'Venecia',
		'CO05873' => 'Vigía del Fuerte',
		'CO05885' => 'Yalí',
		'CO05887' => 'Yarumal',
		'CO05890' => 'Yolombó',
		'CO05893' => 'Yondó',
		'CO05895' => 'Zaragoza',
	],
	'CO08' => [
		'CO08001' => 'Barranquilla',
		'CO08078' => 'Baranoa',
		'CO08137' => 'Campo de La Cruz',
		'CO08141' => 'Candelaria',
		'CO08296' => 'Galapa',
		'CO08372' => 'Juan de Acosta',
		'CO08421' => 'Luruaco',
		'CO08433' => 'Malambo',
		'CO08436' => 'Manatí',
		'CO08520' => 'Palmar de Varela',
		'CO08549' => 'Piojó',
		'CO08558' => 'Polonuevo',
		'CO08560' => 'Ponedera',
		'CO08573' => 'Puerto Colombia',
		'CO08606' => 'Repelón',
		'CO08634' => 'Sabanagrande',
		'CO08638' => 'Sabanalarga',
		'CO08675' => 'Santa Lucía',
		'CO08685' => 'Santo Tomás',
		'CO08758' => 'Soledad',
		'CO08770' => 'Suan',
		'CO08832' => 'Tubará',
		'CO08849' => 'Usiacurí',
	],
	'CO11' => [
		'CO11001' => 'Bogotá, D.C.',
	],
	'CO13' => [
		'CO13001' => 'Cartagena',
		'CO13006' => 'Achí',
		'CO13030' => 'Altos del Rosario',
		'CO13042' => 'Arenal',
		'CO13052' => 'Arjona',
		'CO13062' => 'Arroyohondo',
		'CO13074' => 'Barranco de Loba',
		'CO13140' => 'Calamar',
		'CO13160' => 'Cantagallo',
		'CO13188' => 'Cicuco',
		'CO13212' => 'Córdoba',
		'CO13222' => 'Clemencia',
		'CO13244' => 'El Carmen de Bolívar',
		'CO13248' => 'El Guamo',
		'CO13268' => 'El Peñón',
		'CO13300' => 'Hatillo de Loba',
		'CO13430' => 'Magangué',
		'CO13433' => 'Mahates',
		'CO13440' => 'Margarita',
		'CO13442' => 'María La Baja',
		'CO13458' => 'Montecristo',
		'CO13468' => 'Mompós',
		'CO13473' => 'Morales',
		'CO13490' => 'Norosí',
		'CO13549' => 'Pinillos',
		'CO13580' => 'Regidor',
		'CO13600' => 'Río Viejo ',
		'CO13620' => 'San Cristóbal',
		'CO13647' => 'San Estanislao',
		'CO13650' => 'San Fernando',
		'CO13654' => 'San Jacinto',
		'CO13655' => 'San Jacinto del Cauca',
		'CO13657' => 'San Juan Nepomuceno',
		'CO13667' => 'San Martín de Loba',
		'CO13670' => 'San Pablo',
		'CO13673' => 'Santa Catalina',
		'CO13683' => 'Santa Rosa',
		'CO13688' => 'Santa Rosa del Sur',
		'CO13744' => 'Simití',
		'CO13760' => 'Soplaviento',
		'CO13780' => 'Talaigua Nuevo',
		'CO13810' => 'Tiquisio',
		'CO13836' => 'Turbaco',
		'CO13838' => 'Turbaná',
		'CO13873' => 'Villanueva',
		'CO13894' => 'Zambrano',
	],
	'CO15' => [
		'CO15001' => 'Tunja',
		'CO15022' => 'Almeida',
		'CO15047' => 'Aquitania',
		'CO15051' => 'Arcabuco',
		'CO15087' => 'Belén',
		'CO15090' => 'Berbeo',
		'CO15092' => 'Betéitiva',
		'CO15097' => 'Boavita',
		'CO15104' => 'Boyacá',
		'CO15106' => 'Briceño',
		'CO15109' => 'Buenavista',
		'CO15114' => 'Busbanzá',
		'CO15131' => 'Caldas',
		'CO15135' => 'Campohermoso',
		'CO15162' => 'Cerinza',
		'CO15172' => 'Chinavita',
		'CO15176' => 'Chiquinquirá',
		'CO15180' => 'Chiscas',
		'CO15183' => 'Chita',
		'CO15185' => 'Chitaraque',
		'CO15187' => 'Chivatá',
		'CO15189' => 'Ciénega',
		'CO15204' => 'Cómbita',
		'CO15212' => 'Coper',
		'CO15215' => 'Corrales',
		'CO15218' => 'Covarachía',
		'CO15223' => 'Cubará',
		'CO15224' => 'Cucaita',
		'CO15226' => 'Cuítiva',
		'CO15232' => 'Chíquiza',
		'CO15236' => 'Chivor',
		'CO15238' => 'Duitama',
		'CO15244' => 'El Cocuy',
		'CO15248' => 'El Espino',
		'CO15272' => 'Firavitoba',
		'CO15276' => 'Floresta',
		'CO15293' => 'Gachantivá',
		'CO15296' => 'Gameza',
		'CO15299' => 'Garagoa',
		'CO15317' => 'Guacamayas',
		'CO15322' => 'Guateque',
		'CO15325' => 'Guayatá',
		'CO15332' => 'Güicán',
		'CO15362' => 'Iza',
		'CO15367' => 'Jenesano',
		'CO15368' => 'Jericó',
		'CO15377' => 'Labranzagrande',
		'CO15380' => 'La Capilla',
		'CO15401' => 'La Victoria',
		'CO15403' => 'La Uvita',
		'CO15407' => 'Villa de Leyva',
		'CO15425' => 'Macanal',
		'CO15442' => 'Maripí',
		'CO15455' => 'Miraflores',
		'CO15464' => 'Mongua',
		'CO15466' => 'Monguí',
		'CO15469' => 'Moniquirá',
		'CO15476' => 'Motavita',
		'CO15480' => 'Muzo',
		'CO15491' => 'Nobsa',
		'CO15494' => 'Nuevo Colón',
		'CO15500' => 'Oicatá',
		'CO15507' => 'Otanche',
		'CO15511' => 'Pachavita',
		'CO15514' => 'Páez',
		'CO15516' => 'Paipa',
		'CO15518' => 'Pajarito',
		'CO15522' => 'Panqueba',
		'CO15531' => 'Pauna',
		'CO15533' => 'Paya',
		'CO15537' => 'Paz de Río',
		'CO15542' => 'Pesca',
		'CO15550' => 'Pisba',
		'CO15572' => 'Puerto Boyacá',
		'CO15580' => 'Quípama',
		'CO15599' => 'Ramiriquí',
		'CO15600' => 'Ráquira',
		'CO15621' => 'Rondón',
		'CO15632' => 'Saboyá',
		'CO15638' => 'Sáchica',
		'CO15646' => 'Samacá',
		'CO15660' => 'San Eduardo',
		'CO15664' => 'San José de Pare',
		'CO15667' => 'San Luis de Gaceno',
		'CO15673' => 'San Mateo',
		'CO15676' => 'San Miguel de Sema',
		'CO15681' => 'San Pablo de Borbur',
		'CO15686' => 'Santana',
		'CO15690' => 'Santa María',
		'CO15693' => 'Santa Rosa de Viterbo',
		'CO15696' => 'Santa Sofía',
		'CO15720' => 'Sativanorte',
		'CO15723' => 'Sativasur',
		'CO15740' => 'Siachoque',
		'CO15753' => 'Soatá',
		'CO15755' => 'Socotá',
		'CO15757' => 'Socha',
		'CO15759' => 'Sogamoso',
		'CO15761' => 'Somondoco',
		'CO15762' => 'Sora',
		'CO15763' => 'Sotaquirá',
		'CO15764' => 'Soracá',
		'CO15774' => 'Susacón',
		'CO15776' => 'Sutamarchán',
		'CO15778' => 'Sutatenza',
		'CO15790' => 'Tasco',
		'CO15798' => 'Tenza',
		'CO15804' => 'Tibaná',
		'CO15806' => 'Tibasosa',
		'CO15808' => 'Tinjacá',
		'CO15810' => 'Tipacoque',
		'CO15814' => 'Toca',
		'CO15816' => 'Togüí',
		'CO15820' => 'Tópaga',
		'CO15822' => 'Tota',
		'CO15832' => 'Tununguá',
		'CO15835' => 'Turmequé',
		'CO15837' => 'Tuta',
		'CO15839' => 'Tutazá',
		'CO15842' => 'Umbita',
		'CO15861' => 'Ventaquemada',
		'CO15879' => 'Viracachá',
		'CO15897' => 'Zetaquira',
	],
	'CO17' => [
		'CO17001' => 'Manizales',
		'CO17013' => 'Aguadas',
		'CO17042' => 'Anserma',
		'CO17050' => 'Aranzazu',
		'CO17088' => 'Belalcázar',
		'CO17174' => 'Chinchiná',
		'CO17272' => 'Filadelfia',
		'CO17380' => 'La Dorada',
		'CO17388' => 'La Merced',
		'CO17433' => 'Manzanares',
		'CO17442' => 'Marmato',
		'CO17444' => 'Marquetalia',
		'CO17446' => 'Marulanda',
		'CO17486' => 'Neira',
		'CO17495' => 'Norcasia',
		'CO17513' => 'Pácora',
		'CO17524' => 'Palestina',
		'CO17541' => 'Pensilvania',
		'CO17614' => 'Riosucio',
		'CO17616' => 'Risaralda',
		'CO17653' => 'Salamina',
		'CO17662' => 'Samaná',
		'CO17665' => 'San José',
		'CO17777' => 'Supía',
		'CO17867' => 'Victoria',
		'CO17873' => 'Villamaría',
		'CO17877' => 'Viterbo',
	],
	'CO18' => [
		'CO18001' => 'Florencia',
		'CO18029' => 'Albania',
		'CO18094' => 'Belén de Los Andaquies',
		'CO18150' => 'Cartagena del Chairá',
		'CO18205' => 'Curillo',
		'CO18247' => 'El Doncello',
		'CO18256' => 'El Paujil',
		'CO18410' => 'La Montañita',
		'CO18460' => 'Milán',
		'CO18479' => 'Morelia',
		'CO18592' => 'Puerto Rico',
		'CO18610' => 'San José del Fragua',
		'CO18753' => 'San Vicente del Caguán',
		'CO18756' => 'Solano',
		'CO18785' => 'Solita',
		'CO18860' => 'Valparaíso',
	],
	'CO19' => [
		'CO19001' => 'Popayán',
		'CO19022' => 'Almaguer',
		'CO19050' => 'Argelia',
		'CO19075' => 'Balboa',
		'CO19100' => 'Bolívar',
		'CO19110' => 'Buenos Aires',
		'CO19130' => 'Cajibío',
		'CO19137' => 'Caldono',
		'CO19142' => 'Caloto',
		'CO19212' => 'Corinto',
		'CO19256' => 'El Tambo',
		'CO19290' => 'Florencia',
		'CO19300' => 'Guachené ',
		'CO19318' => 'Guapi',
		'CO19355' => 'Inzá',
		'CO19364' => 'Jambaló',
		'CO19392' => 'La Sierra',
		'CO19397' => 'La Vega',
		'CO19418' => 'López',
		'CO19450' => 'Mercaderes',
		'CO19455' => 'Miranda',
		'CO19473' => 'Morales',
		'CO19513' => 'Padilla',
		'CO19517' => 'Paez',
		'CO19532' => 'Patía',
		'CO19533' => 'Piamonte',
		'CO19548' => 'Piendamó',
		'CO19573' => 'Puerto Tejada',
		'CO19585' => 'Puracé',
		'CO19622' => 'Rosas',
		'CO19693' => 'San Sebastián',
		'CO19698' => 'Santander de Quilichao',
		'CO19701' => 'Santa Rosa',
		'CO19743' => 'Silvia',
		'CO19760' => 'Sotara',
		'CO19780' => 'Suárez',
		'CO19785' => 'Sucre',
		'CO19807' => 'Timbío',
		'CO19809' => 'Timbiquí',
		'CO19821' => 'Toribio',
		'CO19824' => 'Totoró',
		'CO19845' => 'Villa Rica',
	],
	'CO20' => [
		'CO20001' => 'Valledupar',
		'CO20011' => 'Aguachica',
		'CO20013' => 'Agustín Codazzi',
		'CO20032' => 'Astrea',
		'CO20045' => 'Becerril',
		'CO20060' => 'Bosconia',
		'CO20175' => 'Chimichagua',
		'CO20178' => 'Chiriguaná',
		'CO20228' => 'Curumaní',
		'CO20238' => 'El Copey',
		'CO20250' => 'El Paso',
		'CO20295' => 'Gamarra',
		'CO20310' => 'González',
		'CO20383' => 'La Gloria',
		'CO20400' => 'La Jagua de Ibirico',
		'CO20443' => 'Manaure',
		'CO20517' => 'Pailitas',
		'CO20550' => 'Pelaya',
		'CO20570' => 'Pueblo Bello',
		'CO20614' => 'Río de Oro',
		'CO20621' => 'La Paz',
		'CO20710' => 'San Alberto',
		'CO20750' => 'San Diego',
		'CO20770' => 'San Martín',
		'CO20787' => 'Tamalameque',
	],
	'CO23' => [
		'CO23001' => 'Montería',
		'CO23068' => 'Ayapel',
		'CO23079' => 'Buenavista',
		'CO23090' => 'Canalete',
		'CO23162' => 'Cereté',
		'CO23168' => 'Chimá',
		'CO23182' => 'Chinú',
		'CO23189' => 'Ciénaga de Oro',
		'CO23300' => 'Cotorra',
		'CO23350' => 'La Apartada',
		'CO23417' => 'Lorica',
		'CO23419' => 'Los Córdobas',
		'CO23464' => 'Momil',
		'CO23466' => 'Montelíbano',
		'CO23500' => 'Moñitos',
		'CO23555' => 'Planeta Rica',
		'CO23570' => 'Pueblo Nuevo',
		'CO23574' => 'Puerto Escondido',
		'CO23580' => 'Puerto Libertador',
		'CO23586' => 'Purísima',
		'CO23660' => 'Sahagún',
		'CO23670' => 'San Andrés Sotavento',
		'CO23672' => 'San Antero',
		'CO23675' => 'San Bernardo del Viento',
		'CO23678' => 'San Carlos',
		'CO23682' => 'San José de Uré(1)',
		'CO23686' => 'San Pelayo',
		'CO23807' => 'Tierralta',
		'CO23815' => 'Tuchín',
		'CO23855' => 'Valencia',
	],
	'CO25' => [
		'CO25001' => 'Agua de Dios',
		'CO25019' => 'Albán',
		'CO25035' => 'Anapoima',
		'CO25040' => 'Anolaima',
		'CO25053' => 'Arbeláez',
		'CO25086' => 'Beltrán',
		'CO25095' => 'Bituima',
		'CO25099' => 'Bojacá',
		'CO25120' => 'Cabrera',
		'CO25123' => 'Cachipay',
		'CO25126' => 'Cajicá',
		'CO25148' => 'Caparrapí',
		'CO25151' => 'Caqueza',
		'CO25154' => 'Carmen de Carupa',
		'CO25168' => 'Chaguaní',
		'CO25175' => 'Chía',
		'CO25178' => 'Chipaque',
		'CO25181' => 'Choachí',
		'CO25183' => 'Chocontá',
		'CO25200' => 'Cogua',
		'CO25214' => 'Cota',
		'CO25224' => 'Cucunubá',
		'CO25245' => 'El Colegio',
		'CO25258' => 'El Peñón',
		'CO25260' => 'El Rosal',
		'CO25269' => 'Facatativá',
		'CO25279' => 'Fomeque',
		'CO25281' => 'Fosca',
		'CO25286' => 'Funza',
		'CO25288' => 'Fúquene',
		'CO25290' => 'Fusagasugá',
		'CO25293' => 'Gachala',
		'CO25295' => 'Gachancipá',
		'CO25297' => 'Gachetá',
		'CO25299' => 'Gama',
		'CO25307' => 'Girardot',
		'CO25312' => 'Granada',
		'CO25317' => 'Guachetá',
		'CO25320' => 'Guaduas',
		'CO25322' => 'Guasca',
		'CO25324' => 'Guataquí',
		'CO25326' => 'Guatavita',
		'CO25328' => 'Guayabal de Siquima',
		'CO25335' => 'Guayabetal',
		'CO25339' => 'Gutiérrez',
		'CO25368' => 'Jerusalén',
		'CO25372' => 'Junín',
		'CO25377' => 'La Calera',
		'CO25386' => 'La Mesa',
		'CO25394' => 'La Palma',
		'CO25398' => 'La Peña',
		'CO25402' => 'La Vega',
		'CO25407' => 'Lenguazaque',
		'CO25426' => 'Macheta',
		'CO25430' => 'Madrid',
		'CO25436' => 'Manta',
		'CO25438' => 'Medina',
		'CO25473' => 'Mosquera',
		'CO25483' => 'Nariño',
		'CO25486' => 'Nemocón',
		'CO25488' => 'Nilo',
		'CO25489' => 'Nimaima',
		'CO25491' => 'Nocaima',
		'CO25506' => 'Venecia',
		'CO25513' => 'Pacho',
		'CO25518' => 'Paime',
		'CO25524' => 'Pandi',
		'CO25530' => 'Paratebueno',
		'CO25535' => 'Pasca',
		'CO25572' => 'Puerto Salgar',
		'CO25580' => 'Pulí',
		'CO25592' => 'Quebradanegra',
		'CO25594' => 'Quetame',
		'CO25596' => 'Quipile',
		'CO25599' => 'Apulo',
		'CO25612' => 'Ricaurte',
		'CO25645' => 'San Antonio del Tequendama',
		'CO25649' => 'San Bernardo',
		'CO25653' => 'San Cayetano',
		'CO25658' => 'San Francisco',
		'CO25662' => 'San Juan de Río Seco',
		'CO25718' => 'Sasaima',
		'CO25736' => 'Sesquilé',
		'CO25740' => 'Sibaté',
		'CO25743' => 'Silvania',
		'CO25745' => 'Simijaca',
		'CO25754' => 'Soacha',
		'CO25758' => 'Sopó',
		'CO25769' => 'Subachoque',
		'CO25772' => 'Suesca',
		'CO25777' => 'Supatá',
		'CO25779' => 'Susa',
		'CO25781' => 'Sutatausa',
		'CO25785' => 'Tabio',
		'CO25793' => 'Tausa',
		'CO25797' => 'Tena',
		'CO25799' => 'Tenjo',
		'CO25805' => 'Tibacuy',
		'CO25807' => 'Tibirita',
		'CO25815' => 'Tocaima',
		'CO25817' => 'Tocancipá',
		'CO25823' => 'Topaipí',
		'CO25839' => 'Ubalá',
		'CO25841' => 'Ubaque',
		'CO25843' => 'Villa de San Diego de Ubate',
		'CO25845' => 'Une',
		'CO25851' => 'Útica',
		'CO25862' => 'Vergara',
		'CO25867' => 'Vianí',
		'CO25871' => 'Villagómez',
		'CO25873' => 'Villapinzón',
		'CO25875' => 'Villeta',
		'CO25878' => 'Viotá',
		'CO25885' => 'Yacopí',
		'CO25898' => 'Zipacón',
		'CO25899' => 'Zipaquirá',
	],
	'CO27' => [
		'CO27001' => 'Quibdó',
		'CO27006' => 'Acandí',
		'CO27025' => 'Alto Baudo',
		'CO27050' => 'Atrato',
		'CO27073' => 'Bagadó',
		'CO27075' => 'Bahía Solano',
		'CO27077' => 'Bajo Baudó',
		'CO27099' => 'Bojaya',
		'CO27135' => 'El Cantón del San Pablo',
		'CO27150' => 'Carmen del Darien',
		'CO27160' => 'Cértegui',
		'CO27205' => 'Condoto',
		'CO27245' => 'El Carmen de Atrato',
		'CO27250' => 'El Litoral del San Juan',
		'CO27361' => 'Istmina',
		'CO27372' => 'Juradó',
		'CO27413' => 'Lloró',
		'CO27425' => 'Medio Atrato',
		'CO27430' => 'Medio Baudó',
		'CO27450' => 'Medio San Juan',
		'CO27491' => 'Nóvita',
		'CO27495' => 'Nuquí',
		'CO27580' => 'Río Iro',
		'CO27600' => 'Río Quito',
		'CO27615' => 'Riosucio',
		'CO27660' => 'San José del Palmar',
		'CO27745' => 'Sipí',
		'CO27787' => 'Tadó',
		'CO27800' => 'Unguía',
		'CO27810' => 'Unión Panamericana',
	],
	'CO41' => [
		'CO41001' => 'Neiva',
		'CO41006' => 'Acevedo',
		'CO41013' => 'Agrado',
		'CO41016' => 'Aipe',
		'CO41020' => 'Algeciras',
		'CO41026' => 'Altamira',
		'CO41078' => 'Baraya',
		'CO41132' => 'Campoalegre',
		'CO41206' => 'Colombia',
		'CO41244' => 'Elías',
		'CO41298' => 'Garzón',
		'CO41306' => 'Gigante',
		'CO41319' => 'Guadalupe',
		'CO41349' => 'Hobo',
		'CO41357' => 'Iquira',
		'CO41359' => 'Isnos',
		'CO41378' => 'La Argentina',
		'CO41396' => 'La Plata',
		'CO41483' => 'Nátaga',
		'CO41503' => 'Oporapa',
		'CO41518' => 'Paicol',
		'CO41524' => 'Palermo',
		'CO41530' => 'Palestina',
		'CO41548' => 'Pital',
		'CO41551' => 'Pitalito',
		'CO41615' => 'Rivera',
		'CO41660' => 'Saladoblanco',
		'CO41668' => 'San Agustín',
		'CO41676' => 'Santa María',
		'CO41770' => 'Suaza',
		'CO41791' => 'Tarqui',
		'CO41797' => 'Tesalia',
		'CO41799' => 'Tello',
		'CO41801' => 'Teruel',
		'CO41807' => 'Timaná',
		'CO41872' => 'Villavieja',
		'CO41885' => 'Yaguará',
	],
	'CO44' => [
		'CO44001' => 'Riohacha',
		'CO44035' => 'Albania',
		'CO44078' => 'Barrancas',
		'CO44090' => 'Dibulla',
		'CO44098' => 'Distracción',
		'CO44110' => 'El Molino',
		'CO44279' => 'Fonseca',
		'CO44378' => 'Hatonuevo',
		'CO44420' => 'La Jagua del Pilar',
		'CO44430' => 'Maicao',
		'CO44560' => 'Manaure',
		'CO44650' => 'San Juan del Cesar',
		'CO44847' => 'Uribia',
		'CO44855' => 'Urumita',
		'CO44874' => 'Villanueva',
	],
	'CO47' => [
		'CO47001' => 'Santa Marta',
		'CO47030' => 'Algarrobo',
		'CO47053' => 'Aracataca',
		'CO47058' => 'Ariguaní',
		'CO47161' => 'Cerro San Antonio',
		'CO47170' => 'Chivolo',
		'CO47189' => 'Ciénaga',
		'CO47205' => 'Concordia',
		'CO47245' => 'El Banco',
		'CO47258' => 'El Piñon',
		'CO47268' => 'El Retén',
		'CO47288' => 'Fundación',
		'CO47318' => 'Guamal',
		'CO47460' => 'Nueva Granada',
		'CO47541' => 'Pedraza',
		'CO47545' => 'Pijiño del Carmen',
		'CO47551' => 'Pivijay',
		'CO47555' => 'Plato',
		'CO47570' => 'Puebloviejo',
		'CO47605' => 'Remolino',
		'CO47660' => 'Sabanas de San Angel',
		'CO47675' => 'Salamina',
		'CO47692' => 'San Sebastián de Buenavista',
		'CO47703' => 'San Zenón',
		'CO47707' => 'Santa Ana',
		'CO47720' => 'Santa Bárbara de Pinto',
		'CO47745' => 'Sitionuevo',
		'CO47798' => 'Tenerife',
		'CO47960' => 'Zapayán',
		'CO47980' => 'Zona Bananera',
	],
	'CO50' => [
		'CO50001' => 'Villavicencio',
		'CO50006' => 'Acacías',
		'CO50110' => 'Barranca de Upía',
		'CO50124' => 'Cabuyaro',
		'CO50150' => 'Castilla la Nueva',
		'CO50223' => 'Cubarral',
		'CO50226' => 'Cumaral',
		'CO50245' => 'El Calvario',
		'CO50251' => 'El Castillo',
		'CO50270' => 'El Dorado',
		'CO50287' => 'Fuente de Oro',
		'CO50313' => 'Granada',
		'CO50318' => 'Guamal',
		'CO50325' => 'Mapiripán',
		'CO50330' => 'Mesetas',
		'CO50350' => 'La Macarena',
		'CO50370' => 'Uribe',
		'CO50400' => 'Lejanías',
		'CO50450' => 'Puerto Concordia',
		'CO50568' => 'Puerto Gaitán',
		'CO50573' => 'Puerto López',
		'CO50577' => 'Puerto Lleras',
		'CO50590' => 'Puerto Rico',
		'CO50606' => 'Restrepo',
		'CO50680' => 'San Carlos de Guaroa',
		'CO50683' => 'San Juan de Arama',
		'CO50686' => 'San Juanito',
		'CO50689' => 'San Martín',
		'CO50711' => 'Vistahermosa',
	],
	'CO52' => [
		'CO52001' => 'Pasto',
		'CO52019' => 'Albán',
		'CO52022' => 'Aldana',
		'CO52036' => 'Ancuyá',
		'CO52051' => 'Arboleda',
		'CO52079' => 'Barbacoas',
		'CO52083' => 'Belén',
		'CO52110' => 'Buesaco',
		'CO52203' => 'Colón',
		'CO52207' => 'Consaca',
		'CO52210' => 'Contadero',
		'CO52215' => 'Córdoba',
		'CO52224' => 'Cuaspud',
		'CO52227' => 'Cumbal',
		'CO52233' => 'Cumbitara',
		'CO52240' => 'Chachagüí',
		'CO52250' => 'El Charco',
		'CO52254' => 'El Peñol',
		'CO52256' => 'El Rosario',
		'CO52258' => 'El Tablón de Gómez',
		'CO52260' => 'El Tambo',
		'CO52287' => 'Funes',
		'CO52317' => 'Guachucal',
		'CO52320' => 'Guaitarilla',
		'CO52323' => 'Gualmatán',
		'CO52352' => 'Iles',
		'CO52354' => 'Imués',
		'CO52356' => 'Ipiales',
		'CO52378' => 'La Cruz',
		'CO52381' => 'La Florida',
		'CO52385' => 'La Llanada',
		'CO52390' => 'La Tola',
		'CO52399' => 'La Unión',
		'CO52405' => 'Leiva',
		'CO52411' => 'Linares',
		'CO52418' => 'Los Andes',
		'CO52427' => 'Magüi',
		'CO52435' => 'Mallama',
		'CO52473' => 'Mosquera',
		'CO52480' => 'Nariño',
		'CO52490' => 'Olaya Herrera',
		'CO52506' => 'Ospina',
		'CO52520' => 'Francisco Pizarro',
		'CO52540' => 'Policarpa',
		'CO52560' => 'Potosí',
		'CO52565' => 'Providencia',
		'CO52573' => 'Puerres',
		'CO52585' => 'Pupiales',
		'CO52612' => 'Ricaurte',
		'CO52621' => 'Roberto Payán',
		'CO52678' => 'Samaniego',
		'CO52683' => 'Sandoná',
		'CO52685' => 'San Bernardo',
		'CO52687' => 'San Lorenzo',
		'CO52693' => 'San Pablo',
		'CO52694' => 'San Pedro de Cartago',
		'CO52696' => 'Santa Bárbara',
		'CO52699' => 'Santacruz',
		'CO52720' => 'Sapuyes',
		'CO52786' => 'Taminango',
		'CO52788' => 'Tangua',
		'CO52835' => 'San Andrés de Tumaco',
		'CO52838' => 'Túquerres',
		'CO52885' => 'Yacuanquer',
	],
	'CO54' => [
		'CO54001' => 'Cúcuta',
		'CO54003' => 'Abrego',
		'CO54051' => 'Arboledas',
		'CO54099' => 'Bochalema',
		'CO54109' => 'Bucarasica',
		'CO54125' => 'Cácota',
		'CO54128' => 'Cachirá',
		'CO54172' => 'Chinácota',
		'CO54174' => 'Chitagá',
		'CO54206' => 'Convención',
		'CO54223' => 'Cucutilla',
		'CO54239' => 'Durania',
		'CO54245' => 'El Carmen',
		'CO54250' => 'El Tarra',
		'CO54261' => 'El Zulia',
		'CO54313' => 'Gramalote',
		'CO54344' => 'Hacarí',
		'CO54347' => 'Herrán',
		'CO54377' => 'Labateca',
		'CO54385' => 'La Esperanza',
		'CO54398' => 'La Playa',
		'CO54405' => 'Los Patios',
		'CO54418' => 'Lourdes',
		'CO54480' => 'Mutiscua',
		'CO54498' => 'Ocaña',
		'CO54518' => 'Pamplona',
		'CO54520' => 'Pamplonita',
		'CO54553' => 'Puerto Santander',
		'CO54599' => 'Ragonvalia',
		'CO54660' => 'Salazar',
		'CO54670' => 'San Calixto',
		'CO54673' => 'San Cayetano',
		'CO54680' => 'Santiago',
		'CO54720' => 'Sardinata',
		'CO54743' => 'Silos',
		'CO54800' => 'Teorama',
		'CO54810' => 'Tibú',
		'CO54820' => 'Toledo',
		'CO54871' => 'Villa Caro',
		'CO54874' => 'Villa del Rosario',
	],
	'CO63' => [
		'CO63001' => 'Armenia',
		'CO63111' => 'Buenavista',
		'CO63130' => 'Calarca',
		'CO63190' => 'Circasia',
		'CO63212' => 'Córdoba',
		'CO63272' => 'Filandia',
		'CO63302' => 'Génova',
		'CO63401' => 'La Tebaida',
		'CO63470' => 'Montenegro',
		'CO63548' => 'Pijao',
		'CO63594' => 'Quimbaya',
		'CO63690' => 'Salento',
	],
	'CO66' => [
		'CO66001' => 'Pereira',
		'CO66045' => 'Apía',
		'CO66075' => 'Balboa',
		'CO66088' => 'Belén de Umbría',
		'CO66170' => 'Dosquebradas',
		'CO66318' => 'Guática',
		'CO66383' => 'La Celia',
		'CO66400' => 'La Virginia',
		'CO66440' => 'Marsella',
		'CO66456' => 'Mistrató',
		'CO66572' => 'Pueblo Rico',
		'CO66594' => 'Quinchía',
		'CO66682' => 'Santa Rosa de Cabal',
		'CO66687' => 'Santuario',
	],
	'CO68' => [
		'CO68001' => 'Bucaramanga',
		'CO68013' => 'Aguada',
		'CO68020' => 'Albania',
		'CO68051' => 'Aratoca',
		'CO68077' => 'Barbosa',
		'CO68079' => 'Barichara',
		'CO68081' => 'Barrancabermeja',
		'CO68092' => 'Betulia',
		'CO68101' => 'Bolívar',
		'CO68121' => 'Cabrera',
		'CO68132' => 'California',
		'CO68147' => 'Capitanejo',
		'CO68152' => 'Carcasí',
		'CO68160' => 'Cepitá',
		'CO68162' => 'Cerrito',
		'CO68167' => 'Charalá',
		'CO68169' => 'Charta',
		'CO68176' => 'Chima',
		'CO68179' => 'Chipatá',
		'CO68190' => 'Cimitarra',
		'CO68207' => 'Concepción',
		'CO68209' => 'Confines',
		'CO68211' => 'Contratación',
		'CO68217' => 'Coromoro',
		'CO68229' => 'Curití',
		'CO68235' => 'El Carmen de Chucurí',
		'CO68245' => 'El Guacamayo',
		'CO68250' => 'El Peñón',
		'CO68255' => 'El Playón',
		'CO68264' => 'Encino',
		'CO68266' => 'Enciso',
		'CO68271' => 'Florián',
		'CO68276' => 'Floridablanca',
		'CO68296' => 'Galán',
		'CO68298' => 'Gambita',
		'CO68307' => 'Girón',
		'CO68318' => 'Guaca',
		'CO68320' => 'Guadalupe',
		'CO68322' => 'Guapotá',
		'CO68324' => 'Guavatá',
		'CO68327' => 'Güepsa',
		'CO68344' => 'Hato',
		'CO68368' => 'Jesús María',
		'CO68370' => 'Jordán',
		'CO68377' => 'La Belleza',
		'CO68385' => 'Landázuri',
		'CO68397' => 'La Paz',
		'CO68406' => 'Lebríja',
		'CO68418' => 'Los Santos',
		'CO68425' => 'Macaravita',
		'CO68432' => 'Málaga',
		'CO68444' => 'Matanza',
		'CO68464' => 'Mogotes',
		'CO68468' => 'Molagavita',
		'CO68498' => 'Ocamonte',
		'CO68500' => 'Oiba',
		'CO68502' => 'Onzaga',
		'CO68522' => 'Palmar',
		'CO68524' => 'Palmas del Socorro',
		'CO68533' => 'Páramo',
		'CO68547' => 'Piedecuesta',
		'CO68549' => 'Pinchote',
		'CO68572' => 'Puente Nacional',
		'CO68573' => 'Puerto Parra',
		'CO68575' => 'Puerto Wilches',
		'CO68615' => 'Rionegro',
		'CO68655' => 'Sabana de Torres',
		'CO68669' => 'San Andrés',
		'CO68673' => 'San Benito',
		'CO68679' => 'San Gil',
		'CO68682' => 'San Joaquín',
		'CO68684' => 'San José de Miranda',
		'CO68686' => 'San Miguel',
		'CO68689' => 'San Vicente de Chucurí',
		'CO68705' => 'Santa Bárbara',
		'CO68720' => 'Santa Helena del Opón',
		'CO68745' => 'Simacota',
		'CO68755' => 'Socorro',
		'CO68770' => 'Suaita',
		'CO68773' => 'Sucre',
		'CO68780' => 'Suratá',
		'CO68820' => 'Tona',
		'CO68855' => 'Valle de San José',
		'CO68861' => 'Vélez',
		'CO68867' => 'Vetas',
		'CO68872' => 'Villanueva',
		'CO68895' => 'Zapatoca',
	],
	'CO70' => [
		'CO70001' => 'Sincelejo',
		'CO70110' => 'Buenavista',
		'CO70124' => 'Caimito',
		'CO70204' => 'Coloso',
		'CO70215' => 'Corozal',
		'CO70221' => 'Coveñas',
		'CO70230' => 'Chalán',
		'CO70233' => 'El Roble',
		'CO70235' => 'Galeras',
		'CO70265' => 'Guaranda',
		'CO70400' => 'La Unión',
		'CO70418' => 'Los Palmitos',
		'CO70429' => 'Majagual',
		'CO70473' => 'Morroa',
		'CO70508' => 'Ovejas',
		'CO70523' => 'Palmito',
		'CO70670' => 'Sampués',
		'CO70678' => 'San Benito Abad',
		'CO70702' => 'San Juan de Betulia',
		'CO70708' => 'San Marcos',
		'CO70713' => 'San Onofre',
		'CO70717' => 'San Pedro',
		'CO70742' => 'San Luis de Sincé',
		'CO70771' => 'Sucre',
		'CO70820' => 'Santiago de Tolú',
		'CO70823' => 'Tolú Viejo',
	],
	'CO73' => [
		'CO73001' => 'Ibagué',
		'CO73024' => 'Alpujarra',
		'CO73026' => 'Alvarado',
		'CO73030' => 'Ambalema',
		'CO73043' => 'Anzoátegui',
		'CO73055' => 'Armero',
		'CO73067' => 'Ataco',
		'CO73124' => 'Cajamarca',
		'CO73148' => 'Carmen de Apicalá',
		'CO73152' => 'Casabianca',
		'CO73168' => 'Chaparral',
		'CO73200' => 'Coello',
		'CO73217' => 'Coyaima',
		'CO73226' => 'Cunday',
		'CO73236' => 'Dolores',
		'CO73268' => 'Espinal',
		'CO73270' => 'Falan',
		'CO73275' => 'Flandes',
		'CO73283' => 'Fresno',
		'CO73319' => 'Guamo',
		'CO73347' => 'Herveo',
		'CO73349' => 'Honda',
		'CO73352' => 'Icononzo',
		'CO73408' => 'Lérida',
		'CO73411' => 'Líbano',
		'CO73443' => 'Mariquita',
		'CO73449' => 'Melgar',
		'CO73461' => 'Murillo',
		'CO73483' => 'Natagaima',
		'CO73504' => 'Ortega',
		'CO73520' => 'Palocabildo',
		'CO73547' => 'Piedras',
		'CO73555' => 'Planadas',
		'CO73563' => 'Prado',
		'CO73585' => 'Purificación',
		'CO73616' => 'Rioblanco',
		'CO73622' => 'Roncesvalles',
		'CO73624' => 'Rovira',
		'CO73671' => 'Saldaña',
		'CO73675' => 'San Antonio',
		'CO73678' => 'San Luis',
		'CO73686' => 'Santa Isabel',
		'CO73770' => 'Suárez',
		'CO73854' => 'Valle de San Juan',
		'CO73861' => 'Venadillo',
		'CO73870' => 'Villahermosa',
		'CO73873' => 'Villarrica',
	],
	'CO76' => [
		'CO76001' => 'Cali',
		'CO76020' => 'Alcalá',
		'CO76036' => 'Andalucía',
		'CO76041' => 'Ansermanuevo',
		'CO76054' => 'Argelia',
		'CO76100' => 'Bolívar',
		'CO76109' => 'Buenaventura',
		'CO76111' => 'Guadalajara de Buga',
		'CO76113' => 'Bugalagrande',
		'CO76122' => 'Caicedonia',
		'CO76126' => 'Calima',
		'CO76130' => 'Candelaria',
		'CO76147' => 'Cartago',
		'CO76233' => 'Dagua',
		'CO76243' => 'El Águila',
		'CO76246' => 'El Cairo',
		'CO76248' => 'El Cerrito',
		'CO76250' => 'El Dovio',
		'CO76275' => 'Florida',
		'CO76306' => 'Ginebra',
		'CO76318' => 'Guacarí',
		'CO76364' => 'Jamundí',
		'CO76377' => 'La Cumbre',
		'CO76400' => 'La Unión',
		'CO76403' => 'La Victoria',
		'CO76497' => 'Obando',
		'CO76520' => 'Palmira',
		'CO76563' => 'Pradera',
		'CO76606' => 'Restrepo',
		'CO76616' => 'Riofrío',
		'CO76622' => 'Roldanillo',
		'CO76670' => 'San Pedro',
		'CO76736' => 'Sevilla',
		'CO76823' => 'Toro',
		'CO76828' => 'Trujillo',
		'CO76834' => 'Tuluá',
		'CO76845' => 'Ulloa',
		'CO76863' => 'Versalles',
		'CO76869' => 'Vijes',
		'CO76890' => 'Yotoco',
		'CO76892' => 'Yumbo',
		'CO76895' => 'Zarzal',
	],
	'CO81' => [
		'CO81001' => 'Arauca',
		'CO81065' => 'Arauquita',
		'CO81220' => 'Cravo Norte',
		'CO81300' => 'Fortul',
		'CO81591' => 'Puerto Rondón',
		'CO81736' => 'Saravena',
		'CO81794' => 'Tame',
	],
	'CO85' => [
		'CO85001' => 'Yopal',
		'CO85010' => 'Aguazul',
		'CO85015' => 'Chameza',
		'CO85125' => 'Hato Corozal',
		'CO85136' => 'La Salina',
		'CO85139' => 'Maní',
		'CO85162' => 'Monterrey',
		'CO85225' => 'Nunchía',
		'CO85230' => 'Orocué',
		'CO85250' => 'Paz de Ariporo',
		'CO85263' => 'Pore',
		'CO85279' => 'Recetor',
		'CO85300' => 'Sabanalarga',
		'CO85315' => 'Sácama',
		'CO85325' => 'San Luis de Palenque',
		'CO85400' => 'Támara',
		'CO85410' => 'Tauramena',
		'CO85430' => 'Trinidad',
		'CO85440' => 'Villanueva',
	],
	'CO86' => [
		'CO86001' => 'Mocoa',
		'CO86219' => 'Colón',
		'CO86320' => 'Orito',
		'CO86568' => 'Puerto Asís',
		'CO86569' => 'Puerto Caicedo',
		'CO86571' => 'Puerto Guzmán',
		'CO86573' => 'Leguízamo',
		'CO86749' => 'Sibundoy',
		'CO86755' => 'San Francisco',
		'CO86757' => 'San Miguel',
		'CO86760' => 'Santiago',
		'CO86865' => 'Valle del Guamuez',
		'CO86885' => 'Villagarzón',
	],
	'CO88' => [
		'CO88001' => 'San Andrés',
		'CO88564' => 'Providencia',
	],
	'CO91' => [
		'CO91001' => 'Leticia',
		'CO91263' => 'El Encanto (ANM)',
		'CO91405' => 'La Chorrera (ANM)',
		'CO91407' => 'La Pedrera (ANM)',
		'CO91430' => 'La Victoria (ANM)',
		'CO91460' => 'Miriti - Paraná (ANM)',
		'CO91530' => 'Puerto Alegría (ANM)',
		'CO91536' => 'Puerto Arica (ANM)',
		'CO91540' => 'Puerto Nariño',
		'CO91669' => 'Puerto Santander (ANM)',
		'CO91798' => 'Tarapacá (ANM)',
	],
	'CO94' => [
		'CO94001' => 'Inírida',
		'CO94343' => 'Barranco Minas (ANM)',
		'CO94663' => 'Mapiripana (ANM)',
		'CO94883' => 'San Felipe (ANM)',
		'CO94884' => 'Puerto Colombia (ANM)',
		'CO94885' => 'La Guadalupe (ANM)',
		'CO94886' => 'Cacahual (ANM)',
		'CO94887' => 'Pana Pana (ANM)',
		'CO94888' => 'Morichal (ANM)',
	],
	'CO95' => [
		'CO95001' => 'San José del Guaviare',
		'CO95015' => 'Calamar',
		'CO95025' => 'El Retorno',
		'CO95200' => 'Miraflores',
	],
	'CO97' => [
		'CO97001' => 'Mitú',
		'CO97161' => 'Caruru',
		'CO97511' => 'Pacoa (ANM)',
		'CO97666' => 'Taraira',
		'CO97777' => 'Papunaua (ANM)',
		'CO97889' => 'Yavaraté (ANM)',
	],
	'CO99' => [
		'CO99001' => 'Puerto Carreño',
		'CO99524' => 'La Primavera',
		'CO99624' => 'Santa Rosalía',
		'CO99773' => 'Cumaribo',
	],
];
