<?php

/**
 * List of cities for: Switzerland
 * Source: https://www.bfs.admin.ch/bfs/de/home/statistiken/regionalstatistik/regionale-portraets-kennzahlen/gemeinden.assetdetail.11587763.html
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'CH1' => 'Aeugst am Albis',
	'CH2' => 'Affoltern am Albis',
	'CH3' => 'Bonstetten',
	'CH4' => 'Hausen am Albis',
	'CH5' => 'Hedingen',
	'CH6' => 'Kappel am Albis',
	'CH7' => 'Knonau',
	'CH8' => 'Maschwanden',
	'CH9' => 'Mettmenstetten',
	'CH10' => 'Obfelden',
	'CH11' => 'Ottenbach',
	'CH12' => 'Rifferswil',
	'CH13' => 'Stallikon',
	'CH14' => 'Wettswil am Albis',
	'CH21' => 'Adlikon',
	'CH22' => 'Benken (ZH)',
	'CH23' => 'Berg am Irchel',
	'CH24' => 'Buch am Irchel',
	'CH25' => 'Dachsen',
	'CH26' => 'Dorf',
	'CH27' => 'Feuerthalen',
	'CH28' => 'Flaach',
	'CH29' => 'Flurlingen',
	'CH30' => 'Andelfingen',
	'CH31' => 'Henggart',
	'CH32' => 'Humlikon',
	'CH33' => 'Kleinandelfingen',
	'CH34' => 'Laufen-Uhwiesen',
	'CH35' => 'Marthalen',
	'CH37' => 'Ossingen',
	'CH38' => 'Rheinau',
	'CH39' => 'Thalheim an der Thur',
	'CH40' => 'Trüllikon',
	'CH41' => 'Truttikon',
	'CH43' => 'Volken',
	'CH51' => 'Bachenbülach',
	'CH52' => 'Bassersdorf',
	'CH53' => 'Bülach',
	'CH54' => 'Dietlikon',
	'CH55' => 'Eglisau',
	'CH56' => 'Embrach',
	'CH57' => 'Freienstein-Teufen',
	'CH58' => 'Glattfelden',
	'CH59' => 'Hochfelden',
	'CH60' => 'Höri',
	'CH61' => 'Hüntwangen',
	'CH62' => 'Kloten',
	'CH63' => 'Lufingen',
	'CH64' => 'Nürensdorf',
	'CH65' => 'Oberembrach',
	'CH66' => 'Opfikon',
	'CH67' => 'Rafz',
	'CH68' => 'Rorbas',
	'CH69' => 'Wallisellen',
	'CH70' => 'Wasterkingen',
	'CH71' => 'Wil (ZH)',
	'CH72' => 'Winkel',
	'CH81' => 'Bachs',
	'CH82' => 'Boppelsen',
	'CH83' => 'Buchs (ZH)',
	'CH84' => 'Dällikon',
	'CH85' => 'Dänikon',
	'CH86' => 'Dielsdorf',
	'CH87' => 'Hüttikon',
	'CH88' => 'Neerach',
	'CH89' => 'Niederglatt',
	'CH90' => 'Niederhasli',
	'CH91' => 'Niederweningen',
	'CH92' => 'Oberglatt',
	'CH93' => 'Oberweningen',
	'CH94' => 'Otelfingen',
	'CH95' => 'Regensberg',
	'CH96' => 'Regensdorf',
	'CH97' => 'Rümlang',
	'CH98' => 'Schleinikon',
	'CH99' => 'Schöfflisdorf',
	'CH100' => 'Stadel',
	'CH101' => 'Steinmaur',
	'CH102' => 'Weiach',
	'CH111' => 'Bäretswil',
	'CH112' => 'Bubikon',
	'CH113' => 'Dürnten',
	'CH114' => 'Fischenthal',
	'CH115' => 'Gossau (ZH)',
	'CH116' => 'Grüningen',
	'CH117' => 'Hinwil',
	'CH118' => 'Rüti (ZH)',
	'CH119' => 'Seegräben',
	'CH120' => 'Wald (ZH)',
	'CH121' => 'Wetzikon (ZH)',
	'CH131' => 'Adliswil',
	'CH135' => 'Kilchberg (ZH)',
	'CH136' => 'Langnau am Albis',
	'CH137' => 'Oberrieden',
	'CH138' => 'Richterswil',
	'CH139' => 'Rüschlikon',
	'CH141' => 'Thalwil',
	'CH151' => 'Erlenbach (ZH)',
	'CH152' => 'Herrliberg',
	'CH153' => 'Hombrechtikon',
	'CH154' => 'Küsnacht (ZH)',
	'CH155' => 'Männedorf',
	'CH156' => 'Meilen',
	'CH157' => 'Oetwil am See',
	'CH158' => 'Stäfa',
	'CH159' => 'Uetikon am See',
	'CH160' => 'Zumikon',
	'CH161' => 'Zollikon',
	'CH172' => 'Fehraltorf',
	'CH173' => 'Hittnau',
	'CH176' => 'Lindau',
	'CH177' => 'Pfäffikon',
	'CH178' => 'Russikon',
	'CH180' => 'Weisslingen',
	'CH181' => 'Wila',
	'CH182' => 'Wildberg',
	'CH191' => 'Dübendorf',
	'CH192' => 'Egg',
	'CH193' => 'Fällanden',
	'CH194' => 'Greifensee',
	'CH195' => 'Maur',
	'CH196' => 'Mönchaltorf',
	'CH197' => 'Schwerzenbach',
	'CH198' => 'Uster',
	'CH199' => 'Volketswil',
	'CH200' => 'Wangen-Brüttisellen',
	'CH211' => 'Altikon',
	'CH213' => 'Brütten',
	'CH214' => 'Dägerlen',
	'CH215' => 'Dättlikon',
	'CH216' => 'Dinhard',
	'CH218' => 'Ellikon an der Thur',
	'CH219' => 'Elsau',
	'CH220' => 'Hagenbuch',
	'CH221' => 'Hettlingen',
	'CH223' => 'Neftenbach',
	'CH224' => 'Pfungen',
	'CH225' => 'Rickenbach (ZH)',
	'CH226' => 'Schlatt (ZH)',
	'CH227' => 'Seuzach',
	'CH228' => 'Turbenthal',
	'CH230' => 'Winterthur',
	'CH231' => 'Zell (ZH)',
	'CH241' => 'Aesch (ZH)',
	'CH242' => 'Birmensdorf (ZH)',
	'CH243' => 'Dietikon',
	'CH244' => 'Geroldswil',
	'CH245' => 'Oberengstringen',
	'CH246' => 'Oetwil an der Limmat',
	'CH247' => 'Schlieren',
	'CH248' => 'Uitikon',
	'CH249' => 'Unterengstringen',
	'CH250' => 'Urdorf',
	'CH251' => 'Weiningen (ZH)',
	'CH261' => 'Zürich',
	'CH292' => 'Stammheim',
	'CH293' => 'Wädenswil',
	'CH294' => 'Elgg',
	'CH295' => 'Horgen',
	'CH296' => 'Illnau-Effretikon',
	'CH297' => 'Bauma',
	'CH298' => 'Wiesendangen',
	'CH301' => 'Aarberg',
	'CH302' => 'Bargen (BE)',
	'CH303' => 'Grossaffoltern',
	'CH304' => 'Kallnach',
	'CH305' => 'Kappelen',
	'CH306' => 'Lyss',
	'CH307' => 'Meikirch',
	'CH309' => 'Radelfingen',
	'CH310' => 'Rapperswil (BE)',
	'CH311' => 'Schüpfen',
	'CH312' => 'Seedorf (BE)',
	'CH321' => 'Aarwangen',
	'CH322' => 'Auswil',
	'CH323' => 'Bannwil',
	'CH324' => 'Bleienbach',
	'CH325' => 'Busswil bei Melchnau',
	'CH326' => 'Gondiswil',
	'CH329' => 'Langenthal',
	'CH331' => 'Lotzwil',
	'CH332' => 'Madiswil',
	'CH333' => 'Melchnau',
	'CH334' => 'Obersteckholz',
	'CH335' => 'Oeschenbach',
	'CH336' => 'Reisiswil',
	'CH337' => 'Roggwil (BE)',
	'CH338' => 'Rohrbach',
	'CH339' => 'Rohrbachgraben',
	'CH340' => 'Rütschelen',
	'CH341' => 'Schwarzhäusern',
	'CH342' => 'Thunstetten',
	'CH344' => 'Ursenbach',
	'CH345' => 'Wynau',
	'CH351' => 'Bern',
	'CH352' => 'Bolligen',
	'CH353' => 'Bremgarten bei Bern',
	'CH354' => 'Kirchlindach',
	'CH355' => 'Köniz',
	'CH356' => 'Muri bei Bern',
	'CH357' => 'Oberbalm',
	'CH358' => 'Stettlen',
	'CH359' => 'Vechigen',
	'CH360' => 'Wohlen bei Bern',
	'CH361' => 'Zollikofen',
	'CH362' => 'Ittigen',
	'CH363' => 'Ostermundigen',
	'CH371' => 'Biel/Bienne',
	'CH372' => 'Evilard',
	'CH381' => 'Arch',
	'CH382' => 'Büetigen',
	'CH383' => 'Büren an der Aare',
	'CH385' => 'Diessbach bei Büren',
	'CH386' => 'Dotzigen',
	'CH387' => 'Lengnau (BE)',
	'CH388' => 'Leuzigen',
	'CH389' => 'Meienried',
	'CH390' => 'Meinisberg',
	'CH391' => 'Oberwil bei Büren',
	'CH392' => 'Pieterlen',
	'CH393' => 'Rüti bei Büren',
	'CH394' => 'Wengi',
	'CH401' => 'Aefligen',
	'CH402' => 'Alchenstorf',
	'CH403' => 'Bäriswil',
	'CH404' => 'Burgdorf',
	'CH405' => 'Ersigen',
	'CH406' => 'Hasle bei Burgdorf',
	'CH407' => 'Heimiswil',
	'CH408' => 'Hellsau',
	'CH409' => 'Hindelbank',
	'CH410' => 'Höchstetten',
	'CH411' => 'Kernenried',
	'CH412' => 'Kirchberg (BE)',
	'CH413' => 'Koppigen',
	'CH414' => 'Krauchthal',
	'CH415' => 'Lyssach',
	'CH416' => 'Mötschwil',
	'CH418' => 'Oberburg',
	'CH420' => 'Rüdtligen-Alchenflüh',
	'CH421' => 'Rumendingen',
	'CH422' => 'Rüti bei Lyssach',
	'CH423' => 'Willadingen',
	'CH424' => 'Wynigen',
	'CH431' => 'Corgémont',
	'CH432' => 'Cormoret',
	'CH433' => 'Cortébert',
	'CH434' => 'Courtelary',
	'CH435' => 'La Ferrière',
	'CH437' => 'Mont-Tramelan',
	'CH438' => 'Orvin',
	'CH441' => 'Renan (BE)',
	'CH442' => 'Romont (BE)',
	'CH443' => 'Saint-Imier',
	'CH444' => 'Sonceboz-Sombeval',
	'CH445' => 'Sonvilier',
	'CH446' => 'Tramelan',
	'CH448' => 'Villeret',
	'CH449' => 'Sauge',
	'CH450' => 'Péry-La Heutte',
	'CH491' => 'Brüttelen',
	'CH492' => 'Erlach',
	'CH493' => 'Finsterhennen',
	'CH494' => 'Gals',
	'CH495' => 'Gampelen',
	'CH496' => 'Ins',
	'CH497' => 'Lüscherz',
	'CH498' => 'Müntschemier',
	'CH499' => 'Siselen',
	'CH500' => 'Treiten',
	'CH501' => 'Tschugg',
	'CH502' => 'Vinelz',
	'CH533' => 'Bätterkinden',
	'CH535' => 'Deisswil bei Münchenbuchsee',
	'CH536' => 'Diemerswil',
	'CH538' => 'Fraubrunnen',
	'CH540' => 'Jegenstorf',
	'CH541' => 'Iffwil',
	'CH543' => 'Mattstetten',
	'CH544' => 'Moosseedorf',
	'CH546' => 'Münchenbuchsee',
	'CH551' => 'Urtenen-Schönbühl',
	'CH552' => 'Utzenstorf',
	'CH553' => 'Wiggiswil',
	'CH554' => 'Wiler bei Utzenstorf',
	'CH556' => 'Zielebach',
	'CH557' => 'Zuzwil (BE)',
	'CH561' => 'Adelboden',
	'CH562' => 'Aeschi bei Spiez',
	'CH563' => 'Frutigen',
	'CH564' => 'Kandergrund',
	'CH565' => 'Kandersteg',
	'CH566' => 'Krattigen',
	'CH567' => 'Reichenbach im Kandertal',
	'CH571' => 'Beatenberg',
	'CH572' => 'Bönigen',
	'CH573' => 'Brienz (BE)',
	'CH574' => 'Brienzwiler',
	'CH575' => 'Därligen',
	'CH576' => 'Grindelwald',
	'CH577' => 'Gsteigwiler',
	'CH578' => 'Gündlischwand',
	'CH579' => 'Habkern',
	'CH580' => 'Hofstetten bei Brienz',
	'CH581' => 'Interlaken',
	'CH582' => 'Iseltwald',
	'CH584' => 'Lauterbrunnen',
	'CH585' => 'Leissigen',
	'CH586' => 'Lütschental',
	'CH587' => 'Matten bei Interlaken',
	'CH588' => 'Niederried bei Interlaken',
	'CH589' => 'Oberried am Brienzersee',
	'CH590' => 'Ringgenberg (BE)',
	'CH591' => 'Saxeten',
	'CH592' => 'Schwanden bei Brienz',
	'CH593' => 'Unterseen',
	'CH594' => 'Wilderswil',
	'CH602' => 'Arni (BE)',
	'CH603' => 'Biglen',
	'CH605' => 'Bowil',
	'CH606' => 'Brenzikofen',
	'CH607' => 'Freimettigen',
	'CH608' => 'Grosshöchstetten',
	'CH609' => 'Häutligen',
	'CH610' => 'Herbligen',
	'CH611' => 'Kiesen',
	'CH612' => 'Konolfingen',
	'CH613' => 'Landiswil',
	'CH614' => 'Linden',
	'CH615' => 'Mirchel',
	'CH616' => 'Münsingen',
	'CH617' => 'Niederhünigen',
	'CH619' => 'Oberdiessbach',
	'CH620' => 'Oberthal',
	'CH622' => 'Oppligen',
	'CH623' => 'Rubigen',
	'CH626' => 'Walkringen',
	'CH627' => 'Worb',
	'CH628' => 'Zäziwil',
	'CH629' => 'Oberhünigen',
	'CH630' => 'Allmendingen',
	'CH632' => 'Wichtrach',
	'CH661' => 'Clavaleyres',
	'CH662' => 'Ferenbalm',
	'CH663' => 'Frauenkappelen',
	'CH665' => 'Gurbrü',
	'CH666' => 'Kriechenwil',
	'CH667' => 'Laupen',
	'CH668' => 'Mühleberg',
	'CH669' => 'Münchenwiler',
	'CH670' => 'Neuenegg',
	'CH671' => 'Wileroltigen',
	'CH681' => 'Belprahon',
	'CH683' => 'Champoz',
	'CH687' => 'Corcelles (BE)',
	'CH690' => 'Court',
	'CH691' => 'Crémines',
	'CH692' => 'Eschert',
	'CH694' => 'Grandval',
	'CH696' => 'Loveresse',
	'CH700' => 'Moutier',
	'CH701' => 'Perrefitte',
	'CH703' => 'Reconvilier',
	'CH704' => 'Roches (BE)',
	'CH706' => 'Saicourt',
	'CH707' => 'Saules (BE)',
	'CH708' => 'Schelten',
	'CH709' => 'Seehof',
	'CH711' => 'Sorvilier',
	'CH713' => 'Tavannes',
	'CH715' => 'Rebévelier',
	'CH716' => 'Petit-Val',
	'CH717' => 'Valbirse',
	'CH723' => 'La Neuveville',
	'CH724' => 'Nods',
	'CH726' => 'Plateau de Diesse',
	'CH731' => 'Aegerten',
	'CH732' => 'Bellmund',
	'CH733' => 'Brügg',
	'CH734' => 'Bühl',
	'CH735' => 'Epsach',
	'CH736' => 'Hagneck',
	'CH737' => 'Hermrigen',
	'CH738' => 'Jens',
	'CH739' => 'Ipsach',
	'CH740' => 'Ligerz',
	'CH741' => 'Merzligen',
	'CH742' => 'Mörigen',
	'CH743' => 'Nidau',
	'CH744' => 'Orpund',
	'CH745' => 'Port',
	'CH746' => 'Safnern',
	'CH747' => 'Scheuren',
	'CH748' => 'Schwadernau',
	'CH749' => 'Studen (BE)',
	'CH750' => 'Sutz-Lattrigen',
	'CH751' => 'Täuffelen',
	'CH754' => 'Walperswil',
	'CH755' => 'Worben',
	'CH756' => 'Twann-Tüscherz',
	'CH761' => 'Därstetten',
	'CH762' => 'Diemtigen',
	'CH763' => 'Erlenbach im Simmental',
	'CH766' => 'Oberwil im Simmental',
	'CH767' => 'Reutigen',
	'CH768' => 'Spiez',
	'CH769' => 'Wimmis',
	'CH770' => 'Stocken-Höfen',
	'CH782' => 'Guttannen',
	'CH783' => 'Hasliberg',
	'CH784' => 'Innertkirchen',
	'CH785' => 'Meiringen',
	'CH786' => 'Schattenhalb',
	'CH791' => 'Boltigen',
	'CH792' => 'Lenk',
	'CH793' => 'St. Stephan',
	'CH794' => 'Zweisimmen',
	'CH841' => 'Gsteig',
	'CH842' => 'Lauenen',
	'CH843' => 'Saanen',
	'CH852' => 'Guggisberg',
	'CH853' => 'Rüschegg',
	'CH855' => 'Schwarzenburg',
	'CH861' => 'Belp',
	'CH863' => 'Burgistein',
	'CH866' => 'Gerzensee',
	'CH867' => 'Gurzelen',
	'CH868' => 'Jaberg',
	'CH869' => 'Kaufdorf',
	'CH870' => 'Kehrsatz',
	'CH872' => 'Kirchdorf (BE)',
	'CH877' => 'Niedermuhlern',
	'CH879' => 'Riggisberg',
	'CH880' => 'Rüeggisberg',
	'CH881' => 'Rümligen',
	'CH883' => 'Seftigen',
	'CH884' => 'Toffen',
	'CH885' => 'Uttigen',
	'CH886' => 'Wattenwil',
	'CH888' => 'Wald (BE)',
	'CH889' => 'Thurnen',
	'CH901' => 'Eggiwil',
	'CH902' => 'Langnau im Emmental',
	'CH903' => 'Lauperswil',
	'CH904' => 'Röthenbach im Emmental',
	'CH905' => 'Rüderswil',
	'CH906' => 'Schangnau',
	'CH907' => 'Signau',
	'CH908' => 'Trub',
	'CH909' => 'Trubschachen',
	'CH921' => 'Amsoldingen',
	'CH922' => 'Blumenstein',
	'CH923' => 'Buchholterberg',
	'CH924' => 'Eriz',
	'CH925' => 'Fahrni',
	'CH927' => 'Heiligenschwendi',
	'CH928' => 'Heimberg',
	'CH929' => 'Hilterfingen',
	'CH931' => 'Homberg',
	'CH932' => 'Horrenbach-Buchen',
	'CH934' => 'Oberhofen am Thunersee',
	'CH935' => 'Oberlangenegg',
	'CH936' => 'Pohlern',
	'CH938' => 'Sigriswil',
	'CH939' => 'Steffisburg',
	'CH940' => 'Teuffenthal (BE)',
	'CH941' => 'Thierachern',
	'CH942' => 'Thun',
	'CH943' => 'Uebeschi',
	'CH944' => 'Uetendorf',
	'CH945' => 'Unterlangenegg',
	'CH946' => 'Wachseldorn',
	'CH947' => 'Zwieselberg',
	'CH948' => 'Forst-Längenbühl',
	'CH951' => 'Affoltern im Emmental',
	'CH952' => 'Dürrenroth',
	'CH953' => 'Eriswil',
	'CH954' => 'Huttwil',
	'CH955' => 'Lützelflüh',
	'CH956' => 'Rüegsau',
	'CH957' => 'Sumiswald',
	'CH958' => 'Trachselwald',
	'CH959' => 'Walterswil (BE)',
	'CH960' => 'Wyssachen',
	'CH971' => 'Attiswil',
	'CH972' => 'Berken',
	'CH973' => 'Bettenhausen',
	'CH975' => 'Farnern',
	'CH976' => 'Graben',
	'CH977' => 'Heimenhausen',
	'CH979' => 'Herzogenbuchsee',
	'CH980' => 'Inkwil',
	'CH981' => 'Niederbipp',
	'CH982' => 'Niederönz',
	'CH983' => 'Oberbipp',
	'CH985' => 'Ochlenberg',
	'CH987' => 'Rumisberg',
	'CH988' => 'Seeberg',
	'CH989' => 'Thörigen',
	'CH990' => 'Walliswil bei Niederbipp',
	'CH991' => 'Walliswil bei Wangen',
	'CH992' => 'Wangen an der Aare',
	'CH993' => 'Wangenried',
	'CH995' => 'Wiedlisbach',
	'CH1001' => 'Doppleschwand',
	'CH1002' => 'Entlebuch',
	'CH1004' => 'Flühli',
	'CH1005' => 'Hasle (LU)',
	'CH1007' => 'Romoos',
	'CH1008' => 'Schüpfheim',
	'CH1009' => 'Werthenstein',
	'CH1010' => 'Escholzmatt-Marbach',
	'CH1021' => 'Aesch (LU)',
	'CH1022' => 'Altwis',
	'CH1023' => 'Ballwil',
	'CH1024' => 'Emmen',
	'CH1025' => 'Ermensee',
	'CH1026' => 'Eschenbach (LU)',
	'CH1030' => 'Hitzkirch',
	'CH1031' => 'Hochdorf',
	'CH1032' => 'Hohenrain',
	'CH1033' => 'Inwil',
	'CH1037' => 'Rain',
	'CH1039' => 'Römerswil',
	'CH1040' => 'Rothenburg',
	'CH1041' => 'Schongau',
	'CH1051' => 'Adligenswil',
	'CH1052' => 'Buchrain',
	'CH1053' => 'Dierikon',
	'CH1054' => 'Ebikon',
	'CH1055' => 'Gisikon',
	'CH1056' => 'Greppen',
	'CH1057' => 'Honau',
	'CH1058' => 'Horw',
	'CH1059' => 'Kriens',
	'CH1061' => 'Luzern',
	'CH1062' => 'Malters',
	'CH1063' => 'Meggen',
	'CH1064' => 'Meierskappel',
	'CH1065' => 'Root',
	'CH1066' => 'Schwarzenberg',
	'CH1067' => 'Udligenswil',
	'CH1068' => 'Vitznau',
	'CH1069' => 'Weggis',
	'CH1081' => 'Beromünster',
	'CH1082' => 'Büron',
	'CH1083' => 'Buttisholz',
	'CH1084' => 'Eich',
	'CH1085' => 'Geuensee',
	'CH1086' => 'Grosswangen',
	'CH1088' => 'Hildisrieden',
	'CH1089' => 'Knutwil',
	'CH1091' => 'Mauensee',
	'CH1093' => 'Neuenkirch',
	'CH1094' => 'Nottwil',
	'CH1095' => 'Oberkirch',
	'CH1097' => 'Rickenbach (LU)',
	'CH1098' => 'Ruswil',
	'CH1099' => 'Schenkon',
	'CH1100' => 'Schlierbach',
	'CH1102' => 'Sempach',
	'CH1103' => 'Sursee',
	'CH1104' => 'Triengen',
	'CH1107' => 'Wolhusen',
	'CH1121' => 'Alberswil',
	'CH1122' => 'Altbüron',
	'CH1123' => 'Altishofen',
	'CH1125' => 'Dagmersellen',
	'CH1127' => 'Egolzwil',
	'CH1128' => 'Ettiswil',
	'CH1129' => 'Fischbach',
	'CH1130' => 'Gettnau',
	'CH1131' => 'Grossdietwil',
	'CH1132' => 'Hergiswil bei Willisau',
	'CH1135' => 'Luthern',
	'CH1136' => 'Menznau',
	'CH1137' => 'Nebikon',
	'CH1139' => 'Pfaffnau',
	'CH1140' => 'Reiden',
	'CH1142' => 'Roggliswil',
	'CH1143' => 'Schötz',
	'CH1145' => 'Ufhusen',
	'CH1146' => 'Wauwil',
	'CH1147' => 'Wikon',
	'CH1150' => 'Zell (LU)',
	'CH1151' => 'Willisau',
	'CH1201' => 'Altdorf (UR)',
	'CH1202' => 'Andermatt',
	'CH1203' => 'Attinghausen',
	'CH1204' => 'Bauen',
	'CH1205' => 'Bürglen (UR)',
	'CH1206' => 'Erstfeld',
	'CH1207' => 'Flüelen',
	'CH1208' => 'Göschenen',
	'CH1209' => 'Gurtnellen',
	'CH1210' => 'Hospental',
	'CH1211' => 'Isenthal',
	'CH1212' => 'Realp',
	'CH1213' => 'Schattdorf',
	'CH1214' => 'Seedorf (UR)',
	'CH1215' => 'Seelisberg',
	'CH1216' => 'Silenen',
	'CH1217' => 'Sisikon',
	'CH1218' => 'Spiringen',
	'CH1219' => 'Unterschächen',
	'CH1220' => 'Wassen',
	'CH1301' => 'Einsiedeln',
	'CH1311' => 'Gersau',
	'CH1321' => 'Feusisberg',
	'CH1322' => 'Freienbach',
	'CH1323' => 'Wollerau',
	'CH1331' => 'Küssnacht (SZ)',
	'CH1341' => 'Altendorf',
	'CH1342' => 'Galgenen',
	'CH1343' => 'Innerthal',
	'CH1344' => 'Lachen',
	'CH1345' => 'Reichenburg',
	'CH1346' => 'Schübelbach',
	'CH1347' => 'Tuggen',
	'CH1348' => 'Vorderthal',
	'CH1349' => 'Wangen (SZ)',
	'CH1361' => 'Alpthal',
	'CH1362' => 'Arth',
	'CH1363' => 'Illgau',
	'CH1364' => 'Ingenbohl',
	'CH1365' => 'Lauerz',
	'CH1366' => 'Morschach',
	'CH1367' => 'Muotathal',
	'CH1368' => 'Oberiberg',
	'CH1369' => 'Riemenstalden',
	'CH1370' => 'Rothenthurm',
	'CH1371' => 'Sattel',
	'CH1372' => 'Schwyz',
	'CH1373' => 'Steinen',
	'CH1374' => 'Steinerberg',
	'CH1375' => 'Unteriberg',
	'CH1401' => 'Alpnach',
	'CH1402' => 'Engelberg',
	'CH1403' => 'Giswil',
	'CH1404' => 'Kerns',
	'CH1405' => 'Lungern',
	'CH1406' => 'Sachseln',
	'CH1407' => 'Sarnen',
	'CH1501' => 'Beckenried',
	'CH1502' => 'Buochs',
	'CH1503' => 'Dallenwil',
	'CH1504' => 'Emmetten',
	'CH1505' => 'Ennetbürgen',
	'CH1506' => 'Ennetmoos',
	'CH1507' => 'Hergiswil (NW)',
	'CH1508' => 'Oberdorf (NW)',
	'CH1509' => 'Stans',
	'CH1510' => 'Stansstad',
	'CH1511' => 'Wolfenschiessen',
	'CH1630' => 'Glarus Nord',
	'CH1631' => 'Glarus Süd',
	'CH1632' => 'Glarus',
	'CH1701' => 'Baar',
	'CH1702' => 'Cham',
	'CH1703' => 'Hünenberg',
	'CH1704' => 'Menzingen',
	'CH1705' => 'Neuheim',
	'CH1706' => 'Oberägeri',
	'CH1707' => 'Risch',
	'CH1708' => 'Steinhausen',
	'CH1709' => 'Unterägeri',
	'CH1710' => 'Walchwil',
	'CH1711' => 'Zug',
	'CH2008' => 'Châtillon (FR)',
	'CH2009' => 'Cheiry',
	'CH2011' => 'Cugy (FR)',
	'CH2016' => 'Fétigny',
	'CH2022' => 'Gletterens',
	'CH2025' => 'Lully (FR)',
	'CH2027' => 'Ménières',
	'CH2029' => 'Montagny (FR)',
	'CH2035' => 'Nuvilly',
	'CH2038' => 'Prévondavaux',
	'CH2041' => 'Saint-Aubin (FR)',
	'CH2043' => 'Sévaz',
	'CH2044' => 'Surpierre',
	'CH2045' => 'Vallon',
	'CH2050' => 'Les Montets',
	'CH2051' => 'Delley-Portalban',
	'CH2053' => 'Belmont-Broye',
	'CH2054' => 'Estavayer',
	'CH2055' => 'Cheyres-Châbles',
	'CH2061' => 'Auboranges',
	'CH2063' => 'Billens-Hennens',
	'CH2066' => 'Chapelle (Glâne)',
	'CH2067' => 'Le Châtelard',
	'CH2068' => 'Châtonnaye',
	'CH2072' => 'Ecublens (FR)',
	'CH2079' => 'Grangettes',
	'CH2086' => 'Massonnens',
	'CH2087' => 'Mézières (FR)',
	'CH2089' => 'Montet (Glâne)',
	'CH2096' => 'Romont (FR)',
	'CH2097' => 'Rue',
	'CH2099' => 'Siviriez',
	'CH2102' => 'Ursy',
	'CH2113' => 'Vuisternens-devant-Romont',
	'CH2114' => 'Villorsonnens',
	'CH2115' => 'Torny',
	'CH2117' => 'Villaz',
	'CH2121' => 'Haut-Intyamon',
	'CH2122' => 'Pont-en-Ogoz',
	'CH2123' => 'Botterens',
	'CH2124' => 'Broc',
	'CH2125' => 'Bulle',
	'CH2128' => 'Châtel-sur-Montsalvens',
	'CH2129' => 'Corbières',
	'CH2130' => 'Crésuz',
	'CH2131' => 'Echarlens',
	'CH2134' => 'Grandvillard',
	'CH2135' => 'Gruyères',
	'CH2137' => 'Hauteville',
	'CH2138' => 'Jaun',
	'CH2140' => 'Marsens',
	'CH2143' => 'Morlon',
	'CH2145' => 'Le Pâquier (FR)',
	'CH2147' => 'Pont-la-Ville',
	'CH2148' => 'Riaz',
	'CH2149' => 'La Roche',
	'CH2152' => 'Sâles',
	'CH2153' => 'Sorens',
	'CH2155' => 'Vaulruz',
	'CH2160' => 'Vuadens',
	'CH2162' => 'Bas-Intyamon',
	'CH2163' => 'Val-de-Charmey',
	'CH2171' => 'Arconciel',
	'CH2173' => 'Autigny',
	'CH2174' => 'Avry',
	'CH2175' => 'Belfaux',
	'CH2177' => 'Chénens',
	'CH2183' => 'Corminboeuf',
	'CH2186' => 'Cottens (FR)',
	'CH2189' => 'Ependes (FR)',
	'CH2194' => 'Ferpicloz',
	'CH2196' => 'Fribourg',
	'CH2197' => 'Givisiez',
	'CH2198' => 'Granges-Paccot',
	'CH2200' => 'Grolley',
	'CH2206' => 'Marly',
	'CH2208' => 'Matran',
	'CH2211' => 'Neyruz (FR)',
	'CH2216' => 'Pierrafortscha',
	'CH2217' => 'Ponthaux',
	'CH2220' => 'Le Mouret',
	'CH2225' => 'Senèdes',
	'CH2226' => 'Treyvaux',
	'CH2228' => 'Villars-sur-Glâne',
	'CH2230' => 'Villarsel-sur-Marly',
	'CH2233' => 'Hauterive (FR)',
	'CH2234' => 'La Brillaz',
	'CH2235' => 'La Sonnaz',
	'CH2236' => 'Gibloux',
	'CH2237' => 'Prez',
	'CH2250' => 'Courgevaux',
	'CH2254' => 'Courtepin',
	'CH2257' => 'Cressier (FR)',
	'CH2258' => 'Fräschels',
	'CH2259' => 'Galmiz',
	'CH2260' => 'Gempenach',
	'CH2261' => 'Greng',
	'CH2262' => 'Gurmels',
	'CH2265' => 'Kerzers',
	'CH2266' => 'Kleinbösingen',
	'CH2271' => 'Meyriez',
	'CH2272' => 'Misery-Courtion',
	'CH2274' => 'Muntelier',
	'CH2275' => 'Murten',
	'CH2276' => 'Ried bei Kerzers',
	'CH2278' => 'Ulmiz',
	'CH2284' => 'Mont-Vully',
	'CH2291' => 'Alterswil',
	'CH2292' => 'Brünisried',
	'CH2293' => 'Düdingen',
	'CH2294' => 'Giffers',
	'CH2295' => 'Bösingen',
	'CH2296' => 'Heitenried',
	'CH2299' => 'Plaffeien',
	'CH2300' => 'Plasselb',
	'CH2301' => 'Rechthalten',
	'CH2302' => 'St. Antoni',
	'CH2303' => 'St. Silvester',
	'CH2304' => 'St. Ursen',
	'CH2305' => 'Schmitten (FR)',
	'CH2306' => 'Tafers',
	'CH2307' => 'Tentlingen',
	'CH2308' => 'Ueberstorf',
	'CH2309' => 'Wünnewil-Flamatt',
	'CH2321' => 'Attalens',
	'CH2323' => 'Bossonnens',
	'CH2325' => 'Châtel-Saint-Denis',
	'CH2328' => 'Granges (Veveyse)',
	'CH2333' => 'Remaufens',
	'CH2335' => 'Saint-Martin (FR)',
	'CH2336' => 'Semsales',
	'CH2337' => 'Le Flon',
	'CH2338' => 'La Verrerie',
	'CH2401' => 'Egerkingen',
	'CH2402' => 'Härkingen',
	'CH2403' => 'Kestenholz',
	'CH2404' => 'Neuendorf',
	'CH2405' => 'Niederbuchsiten',
	'CH2406' => 'Oberbuchsiten',
	'CH2407' => 'Oensingen',
	'CH2408' => 'Wolfwil',
	'CH2421' => 'Aedermannsdorf',
	'CH2422' => 'Balsthal',
	'CH2423' => 'Gänsbrunnen',
	'CH2424' => 'Herbetswil',
	'CH2425' => 'Holderbank (SO)',
	'CH2426' => 'Laupersdorf',
	'CH2427' => 'Matzendorf',
	'CH2428' => 'Mümliswil-Ramiswil',
	'CH2429' => 'Welschenrohr',
	'CH2445' => 'Biezwil',
	'CH2455' => 'Lüterkofen-Ichertswil',
	'CH2456' => 'Lüterswil-Gächliwil',
	'CH2457' => 'Messen',
	'CH2461' => 'Schnottwil',
	'CH2463' => 'Unterramsern',
	'CH2464' => 'Lüsslingen-Nennigkofen',
	'CH2465' => 'Buchegg',
	'CH2471' => 'Bättwil',
	'CH2472' => 'Büren (SO)',
	'CH2473' => 'Dornach',
	'CH2474' => 'Gempen',
	'CH2475' => 'Hochwald',
	'CH2476' => 'Hofstetten-Flüh',
	'CH2477' => 'Metzerlen-Mariastein',
	'CH2478' => 'Nuglar-St. Pantaleon',
	'CH2479' => 'Rodersdorf',
	'CH2480' => 'Seewen',
	'CH2481' => 'Witterswil',
	'CH2491' => 'Hauenstein-Ifenthal',
	'CH2492' => 'Kienberg',
	'CH2493' => 'Lostorf',
	'CH2495' => 'Niedergösgen',
	'CH2497' => 'Obergösgen',
	'CH2498' => 'Rohr (SO)',
	'CH2499' => 'Stüsslingen',
	'CH2500' => 'Trimbach',
	'CH2501' => 'Winznau',
	'CH2502' => 'Wisen (SO)',
	'CH2503' => 'Erlinsbach (SO)',
	'CH2511' => 'Aeschi (SO)',
	'CH2513' => 'Biberist',
	'CH2514' => 'Bolken',
	'CH2516' => 'Deitingen',
	'CH2517' => 'Derendingen',
	'CH2518' => 'Etziken',
	'CH2519' => 'Gerlafingen',
	'CH2520' => 'Halten',
	'CH2523' => 'Horriwil',
	'CH2524' => 'Hüniken',
	'CH2525' => 'Kriegstetten',
	'CH2526' => 'Lohn-Ammannsegg',
	'CH2527' => 'Luterbach',
	'CH2528' => 'Obergerlafingen',
	'CH2529' => 'Oekingen',
	'CH2530' => 'Recherswil',
	'CH2532' => 'Subingen',
	'CH2534' => 'Zuchwil',
	'CH2535' => 'Drei Höfe',
	'CH2541' => 'Balm bei Günsberg',
	'CH2542' => 'Bellach',
	'CH2543' => 'Bettlach',
	'CH2544' => 'Feldbrunnen-St. Niklaus',
	'CH2545' => 'Flumenthal',
	'CH2546' => 'Grenchen',
	'CH2547' => 'Günsberg',
	'CH2548' => 'Hubersdorf',
	'CH2549' => 'Kammersrohr',
	'CH2550' => 'Langendorf',
	'CH2551' => 'Lommiswil',
	'CH2553' => 'Oberdorf (SO)',
	'CH2554' => 'Riedholz',
	'CH2555' => 'Rüttenen',
	'CH2556' => 'Selzach',
	'CH2571' => 'Boningen',
	'CH2572' => 'Däniken',
	'CH2573' => 'Dulliken',
	'CH2574' => 'Eppenberg-Wöschnau',
	'CH2575' => 'Fulenbach',
	'CH2576' => 'Gretzenbach',
	'CH2578' => 'Gunzgen',
	'CH2579' => 'Hägendorf',
	'CH2580' => 'Kappel (SO)',
	'CH2581' => 'Olten',
	'CH2582' => 'Rickenbach (SO)',
	'CH2583' => 'Schönenwerd',
	'CH2584' => 'Starrkirch-Wil',
	'CH2585' => 'Walterswil (SO)',
	'CH2586' => 'Wangen bei Olten',
	'CH2601' => 'Solothurn',
	'CH2611' => 'Bärschwil',
	'CH2612' => 'Beinwil (SO)',
	'CH2613' => 'Breitenbach',
	'CH2614' => 'Büsserach',
	'CH2615' => 'Erschwil',
	'CH2616' => 'Fehren',
	'CH2617' => 'Grindel',
	'CH2618' => 'Himmelried',
	'CH2619' => 'Kleinlützel',
	'CH2620' => 'Meltingen',
	'CH2621' => 'Nunningen',
	'CH2622' => 'Zullwil',
	'CH2701' => 'Basel',
	'CH2702' => 'Bettingen',
	'CH2703' => 'Riehen',
	'CH2761' => 'Aesch (BL)',
	'CH2762' => 'Allschwil',
	'CH2763' => 'Arlesheim',
	'CH2764' => 'Biel-Benken',
	'CH2765' => 'Binningen',
	'CH2766' => 'Birsfelden',
	'CH2767' => 'Bottmingen',
	'CH2768' => 'Ettingen',
	'CH2769' => 'Münchenstein',
	'CH2770' => 'Muttenz',
	'CH2771' => 'Oberwil (BL)',
	'CH2772' => 'Pfeffingen',
	'CH2773' => 'Reinach (BL)',
	'CH2774' => 'Schönenbuch',
	'CH2775' => 'Therwil',
	'CH2781' => 'Blauen',
	'CH2782' => 'Brislach',
	'CH2783' => 'Burg im Leimental',
	'CH2784' => 'Dittingen',
	'CH2785' => 'Duggingen',
	'CH2786' => 'Grellingen',
	'CH2787' => 'Laufen',
	'CH2788' => 'Liesberg',
	'CH2789' => 'Nenzlingen',
	'CH2790' => 'Roggenburg',
	'CH2791' => 'Röschenz',
	'CH2792' => 'Wahlen',
	'CH2793' => 'Zwingen',
	'CH2821' => 'Arisdorf',
	'CH2822' => 'Augst',
	'CH2823' => 'Bubendorf',
	'CH2824' => 'Frenkendorf',
	'CH2825' => 'Füllinsdorf',
	'CH2826' => 'Giebenach',
	'CH2827' => 'Hersberg',
	'CH2828' => 'Lausen',
	'CH2829' => 'Liestal',
	'CH2830' => 'Lupsingen',
	'CH2831' => 'Pratteln',
	'CH2832' => 'Ramlinsburg',
	'CH2833' => 'Seltisberg',
	'CH2834' => 'Ziefen',
	'CH2841' => 'Anwil',
	'CH2842' => 'Böckten',
	'CH2843' => 'Buckten',
	'CH2844' => 'Buus',
	'CH2845' => 'Diepflingen',
	'CH2846' => 'Gelterkinden',
	'CH2847' => 'Häfelfingen',
	'CH2848' => 'Hemmiken',
	'CH2849' => 'Itingen',
	'CH2850' => 'Känerkinden',
	'CH2851' => 'Kilchberg (BL)',
	'CH2852' => 'Läufelfingen',
	'CH2853' => 'Maisprach',
	'CH2854' => 'Nusshof',
	'CH2855' => 'Oltingen',
	'CH2856' => 'Ormalingen',
	'CH2857' => 'Rickenbach (BL)',
	'CH2858' => 'Rothenfluh',
	'CH2859' => 'Rümlingen',
	'CH2860' => 'Rünenberg',
	'CH2861' => 'Sissach',
	'CH2862' => 'Tecknau',
	'CH2863' => 'Tenniken',
	'CH2864' => 'Thürnen',
	'CH2865' => 'Wenslingen',
	'CH2866' => 'Wintersingen',
	'CH2867' => 'Wittinsburg',
	'CH2868' => 'Zeglingen',
	'CH2869' => 'Zunzgen',
	'CH2881' => 'Arboldswil',
	'CH2882' => 'Bennwil',
	'CH2883' => 'Bretzwil',
	'CH2884' => 'Diegten',
	'CH2885' => 'Eptingen',
	'CH2886' => 'Hölstein',
	'CH2887' => 'Lampenberg',
	'CH2888' => 'Langenbruck',
	'CH2889' => 'Lauwil',
	'CH2890' => 'Liedertswil',
	'CH2891' => 'Niederdorf',
	'CH2892' => 'Oberdorf (BL)',
	'CH2893' => 'Reigoldswil',
	'CH2894' => 'Titterten',
	'CH2895' => 'Waldenburg',
	'CH2901' => 'Gächlingen',
	'CH2903' => 'Löhningen',
	'CH2904' => 'Neunkirch',
	'CH2914' => 'Büttenhardt',
	'CH2915' => 'Dörflingen',
	'CH2917' => 'Lohn (SH)',
	'CH2919' => 'Stetten (SH)',
	'CH2920' => 'Thayngen',
	'CH2931' => 'Bargen (SH)',
	'CH2932' => 'Beringen',
	'CH2933' => 'Buchberg',
	'CH2936' => 'Merishausen',
	'CH2937' => 'Neuhausen am Rheinfall',
	'CH2938' => 'Rüdlingen',
	'CH2939' => 'Schaffhausen',
	'CH2951' => 'Beggingen',
	'CH2952' => 'Schleitheim',
	'CH2953' => 'Siblingen',
	'CH2961' => 'Buch (SH)',
	'CH2962' => 'Hemishofen',
	'CH2963' => 'Ramsen',
	'CH2964' => 'Stein am Rhein',
	'CH2971' => 'Hallau',
	'CH2972' => 'Oberhallau',
	'CH2973' => 'Trasadingen',
	'CH2974' => 'Wilchingen',
	'CH3001' => 'Herisau',
	'CH3002' => 'Hundwil',
	'CH3003' => 'Schönengrund',
	'CH3004' => 'Schwellbrunn',
	'CH3005' => 'Stein (AR)',
	'CH3006' => 'Urnäsch',
	'CH3007' => 'Waldstatt',
	'CH3021' => 'Bühler',
	'CH3022' => 'Gais',
	'CH3023' => 'Speicher',
	'CH3024' => 'Teufen (AR)',
	'CH3025' => 'Trogen',
	'CH3031' => 'Grub (AR)',
	'CH3032' => 'Heiden',
	'CH3033' => 'Lutzenberg',
	'CH3034' => 'Rehetobel',
	'CH3035' => 'Reute (AR)',
	'CH3036' => 'Wald (AR)',
	'CH3037' => 'Walzenhausen',
	'CH3038' => 'Wolfhalden',
	'CH3101' => 'Appenzell',
	'CH3102' => 'Gonten',
	'CH3103' => 'Rüte',
	'CH3104' => 'Schlatt-Haslen',
	'CH3105' => 'Schwende',
	'CH3111' => 'Oberegg',
	'CH3201' => 'Häggenschwil',
	'CH3202' => 'Muolen',
	'CH3203' => 'St. Gallen',
	'CH3204' => 'Wittenbach',
	'CH3211' => 'Berg (SG)',
	'CH3212' => 'Eggersriet',
	'CH3213' => 'Goldach',
	'CH3214' => 'Mörschwil',
	'CH3215' => 'Rorschach',
	'CH3216' => 'Rorschacherberg',
	'CH3217' => 'Steinach',
	'CH3218' => 'Tübach',
	'CH3219' => 'Untereggen',
	'CH3231' => 'Au (SG)',
	'CH3232' => 'Balgach',
	'CH3233' => 'Berneck',
	'CH3234' => 'Diepoldsau',
	'CH3235' => 'Rheineck',
	'CH3236' => 'St. Margrethen',
	'CH3237' => 'Thal',
	'CH3238' => 'Widnau',
	'CH3251' => 'Altstätten',
	'CH3252' => 'Eichberg',
	'CH3253' => 'Marbach (SG)',
	'CH3254' => 'Oberriet (SG)',
	'CH3255' => 'Rebstein',
	'CH3256' => 'Rüthi (SG)',
	'CH3271' => 'Buchs (SG)',
	'CH3272' => 'Gams',
	'CH3273' => 'Grabs',
	'CH3274' => 'Sennwald',
	'CH3275' => 'Sevelen',
	'CH3276' => 'Wartau',
	'CH3291' => 'Bad Ragaz',
	'CH3292' => 'Flums',
	'CH3293' => 'Mels',
	'CH3294' => 'Pfäfers',
	'CH3295' => 'Quarten',
	'CH3296' => 'Sargans',
	'CH3297' => 'Vilters-Wangs',
	'CH3298' => 'Walenstadt',
	'CH3311' => 'Amden',
	'CH3312' => 'Benken (SG)',
	'CH3313' => 'Kaltbrunn',
	'CH3315' => 'Schänis',
	'CH3316' => 'Weesen',
	'CH3338' => 'Schmerikon',
	'CH3339' => 'Uznach',
	'CH3340' => 'Rapperswil-Jona',
	'CH3341' => 'Gommiswald',
	'CH3342' => 'Eschenbach (SG)',
	'CH3352' => 'Ebnat-Kappel',
	'CH3359' => 'Wildhaus-Alt St. Johann',
	'CH3360' => 'Nesslau',
	'CH3372' => 'Hemberg',
	'CH3374' => 'Lichtensteig',
	'CH3375' => 'Oberhelfenschwil',
	'CH3378' => 'Neckertal',
	'CH3379' => 'Wattwil',
	'CH3392' => 'Kirchberg (SG)',
	'CH3393' => 'Lütisburg',
	'CH3394' => 'Mosnang',
	'CH3395' => 'Bütschwil-Ganterschwil',
	'CH3401' => 'Degersheim',
	'CH3402' => 'Flawil',
	'CH3405' => 'Jonschwil',
	'CH3407' => 'Oberuzwil',
	'CH3408' => 'Uzwil',
	'CH3422' => 'Niederbüren',
	'CH3423' => 'Niederhelfenschwil',
	'CH3424' => 'Oberbüren',
	'CH3426' => 'Zuzwil (SG)',
	'CH3427' => 'Wil (SG)',
	'CH3441' => 'Andwil (SG)',
	'CH3442' => 'Gaiserwald',
	'CH3443' => 'Gossau (SG)',
	'CH3444' => 'Waldkirch',
	'CH3506' => 'Vaz/Obervaz',
	'CH3513' => 'Lantsch/Lenz',
	'CH3514' => 'Schmitten (GR)',
	'CH3542' => 'Albula/Alvra',
	'CH3543' => 'Surses',
	'CH3544' => 'Bergün Filisur',
	'CH3551' => 'Brusio',
	'CH3561' => 'Poschiavo',
	'CH3572' => 'Falera',
	'CH3575' => 'Laax',
	'CH3581' => 'Sagogn',
	'CH3582' => 'Schluein',
	'CH3603' => 'Vals',
	'CH3618' => 'Lumnezia',
	'CH3619' => 'Ilanz/Glion',
	'CH3633' => 'Fürstenau',
	'CH3637' => 'Rothenbrunnen',
	'CH3638' => 'Scharans',
	'CH3640' => 'Sils im Domleschg',
	'CH3661' => 'Cazis',
	'CH3662' => 'Flerden',
	'CH3663' => 'Masein',
	'CH3668' => 'Thusis',
	'CH3669' => 'Tschappina',
	'CH3670' => 'Urmein',
	'CH3672' => 'Safiental',
	'CH3673' => 'Domleschg',
	'CH3681' => 'Avers',
	'CH3695' => 'Sufers',
	'CH3701' => 'Andeer',
	'CH3703' => 'Casti-Wergenstein',
	'CH3705' => 'Donat',
	'CH3707' => 'Lohn (GR)',
	'CH3708' => 'Mathon',
	'CH3711' => 'Rongellen',
	'CH3712' => 'Zillis-Reischen',
	'CH3713' => 'Ferrera',
	'CH3714' => 'Rheinwald',
	'CH3721' => 'Bonaduz',
	'CH3722' => 'Domat/Ems',
	'CH3723' => 'Rhäzüns',
	'CH3731' => 'Felsberg',
	'CH3732' => 'Flims',
	'CH3733' => 'Tamins',
	'CH3734' => 'Trin',
	'CH3746' => 'Zernez',
	'CH3752' => 'Samnaun',
	'CH3762' => 'Scuol',
	'CH3764' => 'Valsot',
	'CH3781' => 'Bever',
	'CH3782' => 'Celerina/Schlarigna',
	'CH3783' => 'Madulain',
	'CH3784' => 'Pontresina',
	'CH3785' => 'La Punt-Chamues-ch',
	'CH3786' => 'Samedan',
	'CH3787' => 'St. Moritz',
	'CH3788' => 'S-chanf',
	'CH3789' => 'Sils im Engadin/Segl',
	'CH3790' => 'Silvaplana',
	'CH3791' => 'Zuoz',
	'CH3792' => 'Bregaglia',
	'CH3804' => 'Buseno',
	'CH3805' => 'Castaneda',
	'CH3808' => 'Rossa',
	'CH3810' => 'Santa Maria in Calanca',
	'CH3821' => 'Lostallo',
	'CH3822' => 'Mesocco',
	'CH3823' => 'Soazza',
	'CH3831' => 'Cama',
	'CH3832' => 'Grono',
	'CH3834' => 'Roveredo (GR)',
	'CH3835' => 'San Vittore',
	'CH3837' => 'Calanca',
	'CH3847' => 'Val Müstair',
	'CH3851' => 'Davos',
	'CH3861' => 'Fideris',
	'CH3862' => 'Furna',
	'CH3863' => 'Jenaz',
	'CH3871' => 'Klosters-Serneus',
	'CH3881' => 'Conters im Prättigau',
	'CH3882' => 'Küblis',
	'CH3891' => 'Luzein',
	'CH3901' => 'Chur',
	'CH3911' => 'Churwalden',
	'CH3921' => 'Arosa',
	'CH3932' => 'Tschiertschen-Praden',
	'CH3941' => 'Haldenstein',
	'CH3945' => 'Trimmis',
	'CH3946' => 'Untervaz',
	'CH3947' => 'Zizers',
	'CH3951' => 'Fläsch',
	'CH3952' => 'Jenins',
	'CH3953' => 'Maienfeld',
	'CH3954' => 'Malans',
	'CH3955' => 'Landquart',
	'CH3961' => 'Grüsch',
	'CH3962' => 'Schiers',
	'CH3972' => 'Seewis im Prättigau',
	'CH3981' => 'Breil/Brigels',
	'CH3982' => 'Disentis/Mustér',
	'CH3983' => 'Medel (Lucmagn)',
	'CH3985' => 'Sumvitg',
	'CH3986' => 'Tujetsch',
	'CH3987' => 'Trun',
	'CH3988' => 'Obersa Mundaun',
	'CH4001' => 'Aarau',
	'CH4002' => 'Biberstein',
	'CH4003' => 'Buchs (AG)',
	'CH4004' => 'Densbüren',
	'CH4005' => 'Erlinsbach (AG)',
	'CH4006' => 'Gränichen',
	'CH4007' => 'Hirschthal',
	'CH4008' => 'Küttigen',
	'CH4009' => 'Muhen',
	'CH4010' => 'Oberentfelden',
	'CH4012' => 'Suhr',
	'CH4013' => 'Unterentfelden',
	'CH4021' => 'Baden',
	'CH4022' => 'Bellikon',
	'CH4023' => 'Bergdietikon',
	'CH4024' => 'Birmenstorf (AG)',
	'CH4026' => 'Ennetbaden',
	'CH4027' => 'Fislisbach',
	'CH4028' => 'Freienwil',
	'CH4029' => 'Gebenstorf',
	'CH4030' => 'Killwangen',
	'CH4031' => 'Künten',
	'CH4032' => 'Mägenwil',
	'CH4033' => 'Mellingen',
	'CH4034' => 'Neuenhof',
	'CH4035' => 'Niederrohrdorf',
	'CH4037' => 'Oberrohrdorf',
	'CH4038' => 'Obersiggenthal',
	'CH4039' => 'Remetschwil',
	'CH4040' => 'Spreitenbach',
	'CH4041' => 'Stetten (AG)',
	'CH4042' => 'Turgi',
	'CH4044' => 'Untersiggenthal',
	'CH4045' => 'Wettingen',
	'CH4046' => 'Wohlenschwil',
	'CH4047' => 'Würenlingen',
	'CH4048' => 'Würenlos',
	'CH4049' => 'Ehrendingen',
	'CH4061' => 'Arni (AG)',
	'CH4062' => 'Berikon',
	'CH4063' => 'Bremgarten (AG)',
	'CH4064' => 'Büttikon',
	'CH4065' => 'Dottikon',
	'CH4066' => 'Eggenwil',
	'CH4067' => 'Fischbach-Göslikon',
	'CH4068' => 'Hägglingen',
	'CH4071' => 'Jonen',
	'CH4072' => 'Niederwil (AG)',
	'CH4073' => 'Oberlunkhofen',
	'CH4074' => 'Oberwil-Lieli',
	'CH4075' => 'Rudolfstetten-Friedlisberg',
	'CH4076' => 'Sarmenstorf',
	'CH4077' => 'Tägerig',
	'CH4078' => 'Uezwil',
	'CH4079' => 'Unterlunkhofen',
	'CH4080' => 'Villmergen',
	'CH4081' => 'Widen',
	'CH4082' => 'Wohlen (AG)',
	'CH4083' => 'Zufikon',
	'CH4084' => 'Islisberg',
	'CH4091' => 'Auenstein',
	'CH4092' => 'Birr',
	'CH4093' => 'Birrhard',
	'CH4094' => 'Bözen',
	'CH4095' => 'Brugg',
	'CH4096' => 'Effingen',
	'CH4097' => 'Elfingen',
	'CH4099' => 'Habsburg',
	'CH4100' => 'Hausen (AG)',
	'CH4104' => 'Lupfig',
	'CH4105' => 'Mandach',
	'CH4106' => 'Mönthal',
	'CH4107' => 'Mülligen',
	'CH4110' => 'Remigen',
	'CH4111' => 'Riniken',
	'CH4112' => 'Rüfenach',
	'CH4117' => 'Thalheim (AG)',
	'CH4120' => 'Veltheim (AG)',
	'CH4121' => 'Villigen',
	'CH4122' => 'Villnachern',
	'CH4123' => 'Windisch',
	'CH4124' => 'Bözberg',
	'CH4125' => 'Schinznach',
	'CH4131' => 'Beinwil am See',
	'CH4132' => 'Birrwil',
	'CH4133' => 'Burg (AG)',
	'CH4134' => 'Dürrenäsch',
	'CH4135' => 'Gontenschwil',
	'CH4136' => 'Holziken',
	'CH4137' => 'Leimbach (AG)',
	'CH4138' => 'Leutwil',
	'CH4139' => 'Menziken',
	'CH4140' => 'Oberkulm',
	'CH4141' => 'Reinach (AG)',
	'CH4142' => 'Schlossrued',
	'CH4143' => 'Schmiedrued',
	'CH4144' => 'Schöftland',
	'CH4145' => 'Teufenthal (AG)',
	'CH4146' => 'Unterkulm',
	'CH4147' => 'Zetzwil',
	'CH4161' => 'Eiken',
	'CH4163' => 'Frick',
	'CH4164' => 'Gansingen',
	'CH4165' => 'Gipf-Oberfrick',
	'CH4166' => 'Herznach',
	'CH4167' => 'Hornussen',
	'CH4169' => 'Kaisten',
	'CH4170' => 'Laufenburg',
	'CH4172' => 'Münchwilen (AG)',
	'CH4173' => 'Oberhof',
	'CH4175' => 'Oeschgen',
	'CH4176' => 'Schwaderloch',
	'CH4177' => 'Sisseln',
	'CH4179' => 'Ueken',
	'CH4181' => 'Wittnau',
	'CH4182' => 'Wölflinswil',
	'CH4183' => 'Zeihen',
	'CH4184' => 'Mettauertal',
	'CH4191' => 'Ammerswil',
	'CH4192' => 'Boniswil',
	'CH4193' => 'Brunegg',
	'CH4194' => 'Dintikon',
	'CH4195' => 'Egliswil',
	'CH4196' => 'Fahrwangen',
	'CH4197' => 'Hallwil',
	'CH4198' => 'Hendschiken',
	'CH4199' => 'Holderbank (AG)',
	'CH4200' => 'Hunzenschwil',
	'CH4201' => 'Lenzburg',
	'CH4202' => 'Meisterschwanden',
	'CH4203' => 'Möriken-Wildegg',
	'CH4204' => 'Niederlenz',
	'CH4205' => 'Othmarsingen',
	'CH4206' => 'Rupperswil',
	'CH4207' => 'Schafisheim',
	'CH4208' => 'Seengen',
	'CH4209' => 'Seon',
	'CH4210' => 'Staufen',
	'CH4221' => 'Abtwil',
	'CH4222' => 'Aristau',
	'CH4223' => 'Auw',
	'CH4224' => 'Beinwil (Freiamt)',
	'CH4226' => 'Besenbüren',
	'CH4227' => 'Bettwil',
	'CH4228' => 'Boswil',
	'CH4229' => 'Bünzen',
	'CH4230' => 'Buttwil',
	'CH4231' => 'Dietwil',
	'CH4232' => 'Geltwil',
	'CH4233' => 'Kallern',
	'CH4234' => 'Merenschwand',
	'CH4235' => 'Mühlau',
	'CH4236' => 'Muri (AG)',
	'CH4237' => 'Oberrüti',
	'CH4238' => 'Rottenschwil',
	'CH4239' => 'Sins',
	'CH4240' => 'Waltenschwil',
	'CH4251' => 'Hellikon',
	'CH4252' => 'Kaiseraugst',
	'CH4253' => 'Magden',
	'CH4254' => 'Möhlin',
	'CH4255' => 'Mumpf',
	'CH4256' => 'Obermumpf',
	'CH4257' => 'Olsberg',
	'CH4258' => 'Rheinfelden',
	'CH4259' => 'Schupfart',
	'CH4260' => 'Stein (AG)',
	'CH4261' => 'Wallbach',
	'CH4262' => 'Wegenstetten',
	'CH4263' => 'Zeiningen',
	'CH4264' => 'Zuzgen',
	'CH4271' => 'Aarburg',
	'CH4273' => 'Bottenwil',
	'CH4274' => 'Brittnau',
	'CH4275' => 'Kirchleerau',
	'CH4276' => 'Kölliken',
	'CH4277' => 'Moosleerau',
	'CH4279' => 'Murgenthal',
	'CH4280' => 'Oftringen',
	'CH4281' => 'Reitnau',
	'CH4282' => 'Rothrist',
	'CH4283' => 'Safenwil',
	'CH4284' => 'Staffelbach',
	'CH4285' => 'Strengelbach',
	'CH4286' => 'Uerkheim',
	'CH4287' => 'Vordemwald',
	'CH4288' => 'Wiliberg',
	'CH4289' => 'Zofingen',
	'CH4301' => 'Baldingen',
	'CH4302' => 'Böbikon',
	'CH4303' => 'Böttstein',
	'CH4304' => 'Döttingen',
	'CH4305' => 'Endingen',
	'CH4306' => 'Fisibach',
	'CH4307' => 'Full-Reuenthal',
	'CH4308' => 'Kaiserstuhl',
	'CH4309' => 'Klingnau',
	'CH4310' => 'Koblenz',
	'CH4311' => 'Leibstadt',
	'CH4312' => 'Lengnau (AG)',
	'CH4313' => 'Leuggern',
	'CH4314' => 'Mellikon',
	'CH4315' => 'Rekingen (AG)',
	'CH4316' => 'Rietheim',
	'CH4317' => 'Rümikon',
	'CH4318' => 'Schneisingen',
	'CH4319' => 'Siglistorf',
	'CH4320' => 'Tegerfelden',
	'CH4322' => 'Wislikofen',
	'CH4323' => 'Bad Zurzach',
	'CH4401' => 'Arbon',
	'CH4406' => 'Dozwil',
	'CH4411' => 'Egnach',
	'CH4416' => 'Hefenhofen',
	'CH4421' => 'Horn',
	'CH4426' => 'Kesswil',
	'CH4431' => 'Roggwil (TG)',
	'CH4436' => 'Romanshorn',
	'CH4441' => 'Salmsach',
	'CH4446' => 'Sommeri',
	'CH4451' => 'Uttwil',
	'CH4461' => 'Amriswil',
	'CH4471' => 'Bischofszell',
	'CH4476' => 'Erlen',
	'CH4486' => 'Hauptwil-Gottshaus',
	'CH4495' => 'Hohentannen',
	'CH4501' => 'Kradolf-Schönenberg',
	'CH4506' => 'Sulgen',
	'CH4511' => 'Zihlschlacht-Sitterdorf',
	'CH4536' => 'Basadingen-Schlattingen',
	'CH4545' => 'Diessenhofen',
	'CH4546' => 'Schlatt (TG)',
	'CH4551' => 'Aadorf',
	'CH4561' => 'Felben-Wellhausen',
	'CH4566' => 'Frauenfeld',
	'CH4571' => 'Gachnang',
	'CH4590' => 'Hüttlingen',
	'CH4591' => 'Matzingen',
	'CH4601' => 'Neunforn',
	'CH4606' => 'Stettfurt',
	'CH4611' => 'Thundorf',
	'CH4616' => 'Uesslingen-Buch',
	'CH4621' => 'Warth-Weiningen',
	'CH4641' => 'Altnau',
	'CH4643' => 'Bottighofen',
	'CH4646' => 'Ermatingen',
	'CH4651' => 'Gottlieben',
	'CH4656' => 'Güttingen',
	'CH4666' => 'Kemmental',
	'CH4671' => 'Kreuzlingen',
	'CH4681' => 'Langrickenbach',
	'CH4683' => 'Lengwil',
	'CH4691' => 'Münsterlingen',
	'CH4696' => 'Tägerwilen',
	'CH4701' => 'Wäldi',
	'CH4711' => 'Affeltrangen',
	'CH4716' => 'Bettwiesen',
	'CH4721' => 'Bichelsee-Balterswil',
	'CH4723' => 'Braunau',
	'CH4724' => 'Eschlikon',
	'CH4726' => 'Fischingen',
	'CH4741' => 'Lommis',
	'CH4746' => 'Münchwilen (TG)',
	'CH4751' => 'Rickenbach (TG)',
	'CH4756' => 'Schönholzerswilen',
	'CH4761' => 'Sirnach',
	'CH4776' => 'Tobel-Tägerschen',
	'CH4781' => 'Wängi',
	'CH4786' => 'Wilen (TG)',
	'CH4791' => 'Wuppenau',
	'CH4801' => 'Berlingen',
	'CH4806' => 'Eschenz',
	'CH4811' => 'Herdern',
	'CH4816' => 'Homburg',
	'CH4821' => 'Hüttwilen',
	'CH4826' => 'Mammern',
	'CH4831' => 'Müllheim',
	'CH4841' => 'Pfyn',
	'CH4846' => 'Raperswilen',
	'CH4851' => 'Salenstein',
	'CH4864' => 'Steckborn',
	'CH4871' => 'Wagenhausen',
	'CH4881' => 'Amlikon-Bissegg',
	'CH4891' => 'Berg (TG)',
	'CH4901' => 'Birwinken',
	'CH4911' => 'Bürglen (TG)',
	'CH4921' => 'Bussnang',
	'CH4941' => 'Märstetten',
	'CH4946' => 'Weinfelden',
	'CH4951' => 'Wigoltingen',
	'CH5001' => 'Arbedo-Castione',
	'CH5002' => 'Bellinzona',
	'CH5003' => 'Cadenazzo',
	'CH5009' => 'Isone',
	'CH5010' => 'Lumino',
	'CH5017' => 'SantAntonino',
	'CH5048' => 'Acquarossa',
	'CH5049' => 'Blenio',
	'CH5050' => 'Serravalle',
	'CH5061' => 'Airolo',
	'CH5063' => 'Bedretto',
	'CH5064' => 'Bodio',
	'CH5071' => 'Dalpe',
	'CH5072' => 'Faido',
	'CH5073' => 'Giornico',
	'CH5076' => 'Personico',
	'CH5077' => 'Pollegio',
	'CH5078' => 'Prato (Leventina)',
	'CH5079' => 'Quinto',
	'CH5091' => 'Ascona',
	'CH5095' => 'Brione (Verzasca)',
	'CH5096' => 'Brione sopra Minusio',
	'CH5097' => 'Brissago',
	'CH5102' => 'Corippo',
	'CH5105' => 'Frasco',
	'CH5108' => 'Gordola',
	'CH5112' => 'Lavertezzo',
	'CH5113' => 'Locarno',
	'CH5115' => 'Losone',
	'CH5117' => 'Mergoscia',
	'CH5118' => 'Minusio',
	'CH5120' => 'Muralto',
	'CH5121' => 'Orselina',
	'CH5125' => 'Ronco sopra Ascona',
	'CH5129' => 'Sonogno',
	'CH5131' => 'Tenero-Contra',
	'CH5135' => 'Vogorno',
	'CH5136' => 'Onsernone',
	'CH5138' => 'Cugnasco-Gerra',
	'CH5141' => 'Agno',
	'CH5143' => 'Aranno',
	'CH5144' => 'Arogno',
	'CH5146' => 'Astano',
	'CH5148' => 'Bedano',
	'CH5149' => 'Bedigliora',
	'CH5151' => 'Bioggio',
	'CH5154' => 'Bissone',
	'CH5160' => 'Brusino Arsizio',
	'CH5161' => 'Cademario',
	'CH5162' => 'Cadempino',
	'CH5167' => 'Canobbio',
	'CH5171' => 'Caslano',
	'CH5176' => 'Comano',
	'CH5178' => 'Croglio',
	'CH5180' => 'Cureglia',
	'CH5181' => 'Curio',
	'CH5186' => 'Grancia',
	'CH5187' => 'Gravesano',
	'CH5189' => 'Lamone',
	'CH5192' => 'Lugano',
	'CH5193' => 'Magliaso',
	'CH5194' => 'Manno',
	'CH5195' => 'Maroggia',
	'CH5196' => 'Massagno',
	'CH5197' => 'Melano',
	'CH5198' => 'Melide',
	'CH5199' => 'Mezzovico-Vira',
	'CH5200' => 'Miglieglia',
	'CH5202' => 'Monteggio',
	'CH5203' => 'Morcote',
	'CH5205' => 'Muzzano',
	'CH5206' => 'Neggio',
	'CH5207' => 'Novaggio',
	'CH5208' => 'Origlio',
	'CH5210' => 'Paradiso',
	'CH5212' => 'Ponte Capriasca',
	'CH5213' => 'Ponte Tresa',
	'CH5214' => 'Porza',
	'CH5216' => 'Pura',
	'CH5219' => 'Rovio',
	'CH5221' => 'Savosa',
	'CH5222' => 'Sessa',
	'CH5225' => 'Sorengo',
	'CH5226' => 'Capriasca',
	'CH5227' => 'Torricella-Taverne',
	'CH5230' => 'Vernate',
	'CH5231' => 'Vezia',
	'CH5233' => 'Vico Morcote',
	'CH5236' => 'Collina dOro',
	'CH5237' => 'Alto Malcantone',
	'CH5238' => 'Monteceneri',
	'CH5242' => 'Balerna',
	'CH5249' => 'Castel San Pietro',
	'CH5250' => 'Chiasso',
	'CH5251' => 'Coldrerio',
	'CH5254' => 'Mendrisio',
	'CH5257' => 'Morbio Inferiore',
	'CH5260' => 'Novazzano',
	'CH5263' => 'Riva San Vitale',
	'CH5266' => 'Stabio',
	'CH5268' => 'Vacallo',
	'CH5269' => 'Breggia',
	'CH5281' => 'Biasca',
	'CH5287' => 'Riviera',
	'CH5304' => 'Bosco/Gurin',
	'CH5307' => 'Campo (Vallemaggia)',
	'CH5309' => 'Cerentino',
	'CH5310' => 'Cevio',
	'CH5315' => 'Linescio',
	'CH5317' => 'Maggia',
	'CH5323' => 'Lavizzara',
	'CH5324' => 'Avegno Gordevio',
	'CH5396' => 'Terre di Pedemonte',
	'CH5397' => 'Centovalli',
	'CH5398' => 'Gambarogno',
	'CH5401' => 'Aigle',
	'CH5402' => 'Bex',
	'CH5403' => 'Chessel',
	'CH5404' => 'Corbeyrier',
	'CH5405' => 'Gryon',
	'CH5406' => 'Lavey-Morcles',
	'CH5407' => 'Leysin',
	'CH5408' => 'Noville',
	'CH5409' => 'Ollon',
	'CH5410' => 'Ormont-Dessous',
	'CH5411' => 'Ormont-Dessus',
	'CH5412' => 'Rennaz',
	'CH5413' => 'Roche (VD)',
	'CH5414' => 'Villeneuve (VD)',
	'CH5415' => 'Yvorne',
	'CH5421' => 'Apples',
	'CH5422' => 'Aubonne',
	'CH5423' => 'Ballens',
	'CH5424' => 'Berolle',
	'CH5425' => 'Bière',
	'CH5426' => 'Bougy-Villars',
	'CH5427' => 'Féchy',
	'CH5428' => 'Gimel',
	'CH5429' => 'Longirod',
	'CH5430' => 'Marchissy',
	'CH5431' => 'Mollens (VD)',
	'CH5432' => 'Montherod',
	'CH5434' => 'Saint-George',
	'CH5435' => 'Saint-Livres',
	'CH5436' => 'Saint-Oyens',
	'CH5437' => 'Saubraz',
	'CH5451' => 'Avenches',
	'CH5456' => 'Cudrefin',
	'CH5458' => 'Faoug',
	'CH5464' => 'Vully-les-Lacs',
	'CH5471' => 'Bettens',
	'CH5472' => 'Bournens',
	'CH5473' => 'Boussens',
	'CH5474' => 'La Chaux (Cossonay)',
	'CH5475' => 'Chavannes-le-Veyron',
	'CH5476' => 'Chevilly',
	'CH5477' => 'Cossonay',
	'CH5478' => 'Cottens (VD)',
	'CH5479' => 'Cuarnens',
	'CH5480' => 'Daillens',
	'CH5481' => 'Dizy',
	'CH5482' => 'Eclépens',
	'CH5483' => 'Ferreyres',
	'CH5484' => 'Gollion',
	'CH5485' => 'Grancy',
	'CH5486' => 'LIsle',
	'CH5487' => 'Lussery-Villars',
	'CH5488' => 'Mauraz',
	'CH5489' => 'Mex (VD)',
	'CH5490' => 'Moiry',
	'CH5491' => 'Mont-la-Ville',
	'CH5492' => 'Montricher',
	'CH5493' => 'Orny',
	'CH5494' => 'Pampigny',
	'CH5495' => 'Penthalaz',
	'CH5496' => 'Penthaz',
	'CH5497' => 'Pompaples',
	'CH5498' => 'La Sarraz',
	'CH5499' => 'Senarclens',
	'CH5500' => 'Sévery',
	'CH5501' => 'Sullens',
	'CH5503' => 'Vufflens-la-Ville',
	'CH5511' => 'Assens',
	'CH5512' => 'Bercher',
	'CH5513' => 'Bioley-Orjulaz',
	'CH5514' => 'Bottens',
	'CH5515' => 'Bretigny-sur-Morrens',
	'CH5516' => 'Cugy (VD)',
	'CH5518' => 'Echallens',
	'CH5520' => 'Essertines-sur-Yverdon',
	'CH5521' => 'Etagnières',
	'CH5522' => 'Fey',
	'CH5523' => 'Froideville',
	'CH5527' => 'Morrens (VD)',
	'CH5529' => 'Oulens-sous-Echallens',
	'CH5530' => 'Pailly',
	'CH5531' => 'Penthéréaz',
	'CH5533' => 'Poliez-Pittet',
	'CH5534' => 'Rueyres',
	'CH5535' => 'Saint-Barthélemy (VD)',
	'CH5537' => 'Villars-le-Terroir',
	'CH5539' => 'Vuarrens',
	'CH5540' => 'Montilliez',
	'CH5541' => 'Goumoëns',
	'CH5551' => 'Bonvillars',
	'CH5552' => 'Bullet',
	'CH5553' => 'Champagne',
	'CH5554' => 'Concise',
	'CH5555' => 'Corcelles-près-Concise',
	'CH5556' => 'Fiez',
	'CH5557' => 'Fontaines-sur-Grandson',
	'CH5559' => 'Giez',
	'CH5560' => 'Grandevent',
	'CH5561' => 'Grandson',
	'CH5562' => 'Mauborget',
	'CH5563' => 'Mutrux',
	'CH5564' => 'Novalles',
	'CH5565' => 'Onnens (VD)',
	'CH5566' => 'Provence',
	'CH5568' => 'Sainte-Croix',
	'CH5571' => 'Tévenon',
	'CH5581' => 'Belmont-sur-Lausanne',
	'CH5582' => 'Cheseaux-sur-Lausanne',
	'CH5583' => 'Crissier',
	'CH5584' => 'Epalinges',
	'CH5585' => 'Jouxtens-Mézery',
	'CH5586' => 'Lausanne',
	'CH5587' => 'Le Mont-sur-Lausanne',
	'CH5588' => 'Paudex',
	'CH5589' => 'Prilly',
	'CH5590' => 'Pully',
	'CH5591' => 'Renens (VD)',
	'CH5592' => 'Romanel-sur-Lausanne',
	'CH5601' => 'Chexbres',
	'CH5604' => 'Forel (Lavaux)',
	'CH5606' => 'Lutry',
	'CH5607' => 'Puidoux',
	'CH5609' => 'Rivaz',
	'CH5610' => 'Saint-Saphorin (Lavaux)',
	'CH5611' => 'Savigny',
	'CH5613' => 'Bourg-en-Lavaux',
	'CH5621' => 'Aclens',
	'CH5622' => 'Bremblens',
	'CH5623' => 'Buchillon',
	'CH5624' => 'Bussigny',
	'CH5625' => 'Bussy-Chardonney',
	'CH5627' => 'Chavannes-près-Renens',
	'CH5628' => 'Chigny',
	'CH5629' => 'Clarmont',
	'CH5631' => 'Denens',
	'CH5632' => 'Denges',
	'CH5633' => 'Echandens',
	'CH5634' => 'Echichens',
	'CH5635' => 'Ecublens (VD)',
	'CH5636' => 'Etoy',
	'CH5637' => 'Lavigny',
	'CH5638' => 'Lonay',
	'CH5639' => 'Lully (VD)',
	'CH5640' => 'Lussy-sur-Morges',
	'CH5642' => 'Morges',
	'CH5643' => 'Préverenges',
	'CH5644' => 'Reverolle',
	'CH5645' => 'Romanel-sur-Morges',
	'CH5646' => 'Saint-Prex',
	'CH5648' => 'Saint-Sulpice (VD)',
	'CH5649' => 'Tolochenaz',
	'CH5650' => 'Vaux-sur-Morges',
	'CH5651' => 'Villars-Sainte-Croix',
	'CH5652' => 'Villars-sous-Yens',
	'CH5653' => 'Vufflens-le-Château',
	'CH5654' => 'Vullierens',
	'CH5655' => 'Yens',
	'CH5661' => 'Boulens',
	'CH5663' => 'Bussy-sur-Moudon',
	'CH5665' => 'Chavannes-sur-Moudon',
	'CH5669' => 'Curtilles',
	'CH5671' => 'Dompierre (VD)',
	'CH5673' => 'Hermenches',
	'CH5674' => 'Lovatens',
	'CH5675' => 'Lucens',
	'CH5678' => 'Moudon',
	'CH5680' => 'Ogens',
	'CH5683' => 'Prévonloup',
	'CH5684' => 'Rossenges',
	'CH5688' => 'Syens',
	'CH5690' => 'Villars-le-Comte',
	'CH5692' => 'Vucherens',
	'CH5693' => 'Montanaire',
	'CH5701' => 'Arnex-sur-Nyon',
	'CH5702' => 'Arzier-Le Muids',
	'CH5703' => 'Bassins',
	'CH5704' => 'Begnins',
	'CH5705' => 'Bogis-Bossey',
	'CH5706' => 'Borex',
	'CH5707' => 'Chavannes-de-Bogis',
	'CH5708' => 'Chavannes-des-Bois',
	'CH5709' => 'Chéserex',
	'CH5710' => 'Coinsins',
	'CH5711' => 'Commugny',
	'CH5712' => 'Coppet',
	'CH5713' => 'Crans-près-Céligny',
	'CH5714' => 'Crassier',
	'CH5715' => 'Duillier',
	'CH5716' => 'Eysins',
	'CH5717' => 'Founex',
	'CH5718' => 'Genolier',
	'CH5719' => 'Gingins',
	'CH5720' => 'Givrins',
	'CH5721' => 'Gland',
	'CH5722' => 'Grens',
	'CH5723' => 'Mies',
	'CH5724' => 'Nyon',
	'CH5725' => 'Prangins',
	'CH5726' => 'La Rippe',
	'CH5727' => 'Saint-Cergue',
	'CH5728' => 'Signy-Avenex',
	'CH5729' => 'Tannay',
	'CH5730' => 'Trélex',
	'CH5731' => 'Le Vaud',
	'CH5732' => 'Vich',
	'CH5741' => 'LAbergement',
	'CH5742' => 'Agiez',
	'CH5743' => 'Arnex-sur-Orbe',
	'CH5744' => 'Ballaigues',
	'CH5745' => 'Baulmes',
	'CH5746' => 'Bavois',
	'CH5747' => 'Bofflens',
	'CH5748' => 'Bretonnières',
	'CH5749' => 'Chavornay',
	'CH5750' => 'Les Clées',
	'CH5752' => 'Croy',
	'CH5754' => 'Juriens',
	'CH5755' => 'Lignerolle',
	'CH5756' => 'Montcherand',
	'CH5757' => 'Orbe',
	'CH5758' => 'La Praz',
	'CH5759' => 'Premier',
	'CH5760' => 'Rances',
	'CH5761' => 'Romainmôtier-Envy',
	'CH5762' => 'Sergey',
	'CH5763' => 'Valeyres-sous-Rances',
	'CH5764' => 'Vallorbe',
	'CH5765' => 'Vaulion',
	'CH5766' => 'Vuiteboeuf',
	'CH5785' => 'Corcelles-le-Jorat',
	'CH5788' => 'Essertes',
	'CH5790' => 'Maracon',
	'CH5792' => 'Montpreveyres',
	'CH5798' => 'Ropraz',
	'CH5799' => 'Servion',
	'CH5803' => 'Vulliens',
	'CH5804' => 'Jorat-Menthue',
	'CH5805' => 'Oron',
	'CH5806' => 'Jorat-Mézières',
	'CH5812' => 'Champtauroz',
	'CH5813' => 'Chevroux',
	'CH5816' => 'Corcelles-près-Payerne',
	'CH5817' => 'Grandcour',
	'CH5819' => 'Henniez',
	'CH5821' => 'Missy',
	'CH5822' => 'Payerne',
	'CH5827' => 'Trey',
	'CH5828' => 'Treytorrens (Payerne)',
	'CH5830' => 'Villarzel',
	'CH5831' => 'Valbroye',
	'CH5841' => 'Château-dOex',
	'CH5842' => 'Rossinière',
	'CH5843' => 'Rougemont',
	'CH5851' => 'Allaman',
	'CH5852' => 'Bursinel',
	'CH5853' => 'Bursins',
	'CH5854' => 'Burtigny',
	'CH5855' => 'Dully',
	'CH5856' => 'Essertines-sur-Rolle',
	'CH5857' => 'Gilly',
	'CH5858' => 'Luins',
	'CH5859' => 'Mont-sur-Rolle',
	'CH5860' => 'Perroy',
	'CH5861' => 'Rolle',
	'CH5862' => 'Tartegnin',
	'CH5863' => 'Vinzel',
	'CH5871' => 'LAbbaye',
	'CH5872' => 'Le Chenit',
	'CH5873' => 'Le Lieu',
	'CH5881' => 'Blonay',
	'CH5882' => 'Chardonne',
	'CH5883' => 'Corseaux',
	'CH5884' => 'Corsier-sur-Vevey',
	'CH5885' => 'Jongny',
	'CH5886' => 'Montreux',
	'CH5888' => 'Saint-Légier-La Chiésaz',
	'CH5889' => 'La Tour-de-Peilz',
	'CH5890' => 'Vevey',
	'CH5891' => 'Veytaux',
	'CH5902' => 'Belmont-sur-Yverdon',
	'CH5903' => 'Bioley-Magnoux',
	'CH5904' => 'Chamblon',
	'CH5905' => 'Champvent',
	'CH5907' => 'Chavannes-le-Chêne',
	'CH5908' => 'Chêne-Pâquier',
	'CH5909' => 'Cheseaux-Noréaz',
	'CH5910' => 'Cronay',
	'CH5911' => 'Cuarny',
	'CH5912' => 'Démoret',
	'CH5913' => 'Donneloye',
	'CH5914' => 'Ependes (VD)',
	'CH5919' => 'Mathod',
	'CH5921' => 'Molondin',
	'CH5922' => 'Montagny-près-Yverdon',
	'CH5923' => 'Oppens',
	'CH5924' => 'Orges',
	'CH5925' => 'Orzens',
	'CH5926' => 'Pomy',
	'CH5928' => 'Rovray',
	'CH5929' => 'Suchy',
	'CH5930' => 'Suscévaz',
	'CH5931' => 'Treycovagnes',
	'CH5932' => 'Ursins',
	'CH5933' => 'Valeyres-sous-Montagny',
	'CH5934' => 'Valeyres-sous-Ursins',
	'CH5935' => 'Villars-Epeney',
	'CH5937' => 'Vugelles-La Mothe',
	'CH5938' => 'Yverdon-les-Bains',
	'CH5939' => 'Yvonand',
	'CH6002' => 'Brig-Glis',
	'CH6004' => 'Eggerberg',
	'CH6007' => 'Naters',
	'CH6008' => 'Ried-Brig',
	'CH6009' => 'Simplon',
	'CH6010' => 'Termen',
	'CH6011' => 'Zwischbergen',
	'CH6021' => 'Ardon',
	'CH6022' => 'Chamoson',
	'CH6023' => 'Conthey',
	'CH6024' => 'Nendaz',
	'CH6025' => 'Vétroz',
	'CH6031' => 'Bagnes',
	'CH6032' => 'Bourg-Saint-Pierre',
	'CH6033' => 'Liddes',
	'CH6034' => 'Orsières',
	'CH6035' => 'Sembrancher',
	'CH6036' => 'Vollèges',
	'CH6052' => 'Bellwald',
	'CH6054' => 'Binn',
	'CH6056' => 'Ernen',
	'CH6057' => 'Fiesch',
	'CH6058' => 'Fieschertal',
	'CH6061' => 'Lax',
	'CH6076' => 'Obergoms',
	'CH6077' => 'Goms',
	'CH6082' => 'Ayent',
	'CH6083' => 'Evolène',
	'CH6084' => 'Hérémence',
	'CH6087' => 'Saint-Martin (VS)',
	'CH6089' => 'Vex',
	'CH6090' => 'Mont-Noble',
	'CH6101' => 'Agarn',
	'CH6102' => 'Albinen',
	'CH6104' => 'Ergisch',
	'CH6109' => 'Inden',
	'CH6110' => 'Leuk',
	'CH6111' => 'Leukerbad',
	'CH6112' => 'Oberems',
	'CH6113' => 'Salgesch',
	'CH6116' => 'Varen',
	'CH6117' => 'Guttet-Feschel',
	'CH6118' => 'Gampel-Bratsch',
	'CH6119' => 'Turtmann-Unterems',
	'CH6131' => 'Bovernier',
	'CH6132' => 'Charrat',
	'CH6133' => 'Fully',
	'CH6134' => 'Isérables',
	'CH6135' => 'Leytron',
	'CH6136' => 'Martigny',
	'CH6137' => 'Martigny-Combe',
	'CH6139' => 'Riddes',
	'CH6140' => 'Saillon',
	'CH6141' => 'Saxon',
	'CH6142' => 'Trient',
	'CH6151' => 'Champéry',
	'CH6152' => 'Collombey-Muraz',
	'CH6153' => 'Monthey',
	'CH6154' => 'Port-Valais',
	'CH6155' => 'Saint-Gingolph',
	'CH6156' => 'Troistorrents',
	'CH6157' => 'Val-dIlliez',
	'CH6158' => 'Vionnaz',
	'CH6159' => 'Vouvry',
	'CH6172' => 'Bister',
	'CH6173' => 'Bitsch',
	'CH6177' => 'Grengiols',
	'CH6181' => 'Riederalp',
	'CH6191' => 'Ausserberg',
	'CH6192' => 'Blatten',
	'CH6193' => 'Bürchen',
	'CH6194' => 'Eischoll',
	'CH6195' => 'Ferden',
	'CH6197' => 'Kippel',
	'CH6198' => 'Niedergesteln',
	'CH6199' => 'Raron',
	'CH6201' => 'Unterbäch',
	'CH6202' => 'Wiler (Lötschen)',
	'CH6203' => 'Mörel-Filet',
	'CH6204' => 'Steg-Hohtenn',
	'CH6205' => 'Bettmeralp',
	'CH6211' => 'Collonges',
	'CH6212' => 'Dorénaz',
	'CH6213' => 'Evionnaz',
	'CH6214' => 'Finhaut',
	'CH6215' => 'Massongex',
	'CH6217' => 'Saint-Maurice',
	'CH6218' => 'Salvan',
	'CH6219' => 'Vernayaz',
	'CH6220' => 'Vérossaz',
	'CH6232' => 'Chalais',
	'CH6235' => 'Chippis',
	'CH6238' => 'Grône',
	'CH6239' => 'Icogne',
	'CH6240' => 'Lens',
	'CH6241' => 'Miège',
	'CH6246' => 'Saint-Léonard',
	'CH6248' => 'Sierre',
	'CH6249' => 'Venthône',
	'CH6250' => 'Veyras',
	'CH6252' => 'Anniviers',
	'CH6253' => 'Crans-Montana',
	'CH6261' => 'Arbaz',
	'CH6263' => 'Grimisuat',
	'CH6265' => 'Savièse',
	'CH6266' => 'Sion',
	'CH6267' => 'Veysonnaz',
	'CH6281' => 'Baltschieder',
	'CH6282' => 'Eisten',
	'CH6283' => 'Embd',
	'CH6285' => 'Grächen',
	'CH6286' => 'Lalden',
	'CH6287' => 'Randa',
	'CH6288' => 'Saas-Almagell',
	'CH6289' => 'Saas-Balen',
	'CH6290' => 'Saas-Fee',
	'CH6291' => 'Saas-Grund',
	'CH6292' => 'St. Niklaus',
	'CH6293' => 'Stalden (VS)',
	'CH6294' => 'Staldenried',
	'CH6295' => 'Täsch',
	'CH6296' => 'Törbel',
	'CH6297' => 'Visp',
	'CH6298' => 'Visperterminen',
	'CH6299' => 'Zeneggen',
	'CH6300' => 'Zermatt',
	'CH6404' => 'Boudry',
	'CH6407' => 'Corcelles-Cormondrèche',
	'CH6408' => 'Cortaillod',
	'CH6412' => 'Peseux',
	'CH6413' => 'Rochefort',
	'CH6416' => 'Milvignes',
	'CH6417' => 'La Grande Béroche',
	'CH6421' => 'La Chaux-de-Fonds',
	'CH6422' => 'Les Planchettes',
	'CH6423' => 'La Sagne',
	'CH6431' => 'Les Brenets',
	'CH6432' => 'La Brévine',
	'CH6433' => 'Brot-Plamboz',
	'CH6434' => 'Le Cerneux-Péquignot',
	'CH6435' => 'La Chaux-du-Milieu',
	'CH6436' => 'Le Locle',
	'CH6437' => 'Les Ponts-de-Martel',
	'CH6451' => 'Cornaux',
	'CH6452' => 'Cressier (NE)',
	'CH6453' => 'Enges',
	'CH6454' => 'Hauterive (NE)',
	'CH6455' => 'Le Landeron',
	'CH6456' => 'Lignières',
	'CH6458' => 'Neuchâtel',
	'CH6459' => 'Saint-Blaise',
	'CH6461' => 'La Tène',
	'CH6485' => 'Valangin',
	'CH6487' => 'Val-de-Ruz',
	'CH6504' => 'La Côte-aux-Fées',
	'CH6511' => 'Les Verrières',
	'CH6512' => 'Val-de-Travers',
	'CH6601' => 'Aire-la-Ville',
	'CH6602' => 'Anières',
	'CH6603' => 'Avully',
	'CH6604' => 'Avusy',
	'CH6605' => 'Bardonnex',
	'CH6606' => 'Bellevue',
	'CH6607' => 'Bernex',
	'CH6608' => 'Carouge (GE)',
	'CH6609' => 'Cartigny',
	'CH6610' => 'Céligny',
	'CH6611' => 'Chancy',
	'CH6612' => 'Chêne-Bougeries',
	'CH6613' => 'Chêne-Bourg',
	'CH6614' => 'Choulex',
	'CH6615' => 'Collex-Bossy',
	'CH6616' => 'Collonge-Bellerive',
	'CH6617' => 'Cologny',
	'CH6618' => 'Confignon',
	'CH6619' => 'Corsier (GE)',
	'CH6620' => 'Dardagny',
	'CH6621' => 'Genève',
	'CH6622' => 'Genthod',
	'CH6623' => 'Le Grand-Saconnex',
	'CH6624' => 'Gy',
	'CH6625' => 'Hermance',
	'CH6626' => 'Jussy',
	'CH6627' => 'Laconnex',
	'CH6628' => 'Lancy',
	'CH6629' => 'Meinier',
	'CH6630' => 'Meyrin',
	'CH6631' => 'Onex',
	'CH6632' => 'Perly-Certoux',
	'CH6633' => 'Plan-les-Ouates',
	'CH6634' => 'Pregny-Chambésy',
	'CH6635' => 'Presinge',
	'CH6636' => 'Puplinge',
	'CH6637' => 'Russin',
	'CH6638' => 'Satigny',
	'CH6639' => 'Soral',
	'CH6640' => 'Thônex',
	'CH6641' => 'Troinex',
	'CH6642' => 'Vandoeuvres',
	'CH6643' => 'Vernier',
	'CH6644' => 'Versoix',
	'CH6645' => 'Veyrier',
	'CH6702' => 'Boécourt',
	'CH6703' => 'Bourrignon',
	'CH6704' => 'Châtillon (JU)',
	'CH6706' => 'Courchapoix',
	'CH6708' => 'Courrendlin',
	'CH6709' => 'Courroux',
	'CH6710' => 'Courtételle',
	'CH6711' => 'Delémont',
	'CH6712' => 'Develier',
	'CH6713' => 'Ederswiler',
	'CH6715' => 'Mervelier',
	'CH6716' => 'Mettembert',
	'CH6718' => 'Movelier',
	'CH6719' => 'Pleigne',
	'CH6721' => 'Rossemaison',
	'CH6722' => 'Saulcy',
	'CH6724' => 'Soyhières',
	'CH6729' => 'Haute-Sorne',
	'CH6730' => 'Val Terbi',
	'CH6741' => 'Le Bémont (JU)',
	'CH6742' => 'Les Bois',
	'CH6743' => 'Les Breuleux',
	'CH6744' => 'La Chaux-des-Breuleux',
	'CH6745' => 'Les Enfers',
	'CH6748' => 'Les Genevez (JU)',
	'CH6750' => 'Lajoux (JU)',
	'CH6751' => 'Montfaucon',
	'CH6753' => 'Muriaux',
	'CH6754' => 'Le Noirmont',
	'CH6757' => 'Saignelégier',
	'CH6758' => 'Saint-Brais',
	'CH6759' => 'Soubey',
	'CH6771' => 'Alle',
	'CH6773' => 'Beurnevésin',
	'CH6774' => 'Boncourt',
	'CH6775' => 'Bonfol',
	'CH6778' => 'Bure',
	'CH6781' => 'Coeuve',
	'CH6782' => 'Cornol',
	'CH6783' => 'Courchavon',
	'CH6784' => 'Courgenay',
	'CH6785' => 'Courtedoux',
	'CH6787' => 'Damphreux',
	'CH6789' => 'Fahy',
	'CH6790' => 'Fontenais',
	'CH6792' => 'Grandfontaine',
	'CH6793' => 'Lugnez',
	'CH6800' => 'Porrentruy',
	'CH6806' => 'Vendlincourt',
	'CH6807' => 'Basse-Allaine',
	'CH6808' => 'Clos du Doubs',
	'CH6809' => 'Haute-Ajoie',
	'CH6810' => 'La Baroche',
];
