<?php

/**
 * List of cities for: Canada
 * Source: https://www12.statcan.gc.ca/census-recensement/2016/dp-pd/hlt-fst/pd-pl/comprehensive.cfm
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['CA'];

$country_cities = [
	'NL' => [
		'CADIVISION_NO.__1,_SUBD._V' => 'Division No.  1, Subd. V',
		'CAPORTUGAL_COVE_SOUTH' => 'Portugal Cove South',
		'CATREPASSEY' => 'Trepassey',
		'CAST._SHOTTS' => 'St. Shotts',
		'CADIVISION_NO.__1,_SUBD._U' => 'Division No.  1, Subd. U',
		'CACAPE_BROYLE' => 'Cape Broyle',
		'CARENEWS-CAPPAHAYDEN' => 'Renews-Cappahayden',
		'CAFERMEUSE' => 'Fermeuse',
		'CAPORT_KIRWAN' => 'Port Kirwan',
		'CAAQUAFORTE' => 'Aquaforte',
		'CAFERRYLAND' => 'Ferryland',
		'CADIVISION_NO.__1,_SUBD._W' => 'Division No.  1, Subd. W',
		'CAST._VINCENTS-ST._STEPHENS-PETERS_RIV' => 'St. Vincents-St. Stephens-Peters River',
		'CAGASKIERS-POINT_LA_HAYE' => 'Gaskiers-Point La Haye',
		'CAST._MARYS' => 'St. Marys',
		'CARIVERHEAD' => 'Riverhead',
		'CAADMIRALS_BEACH' => 'Admirals Beach',
		'CAST._JOSEPHS' => 'St. Josephs',
		'CAMOUNT_CARMEL-MITCHELLS_BROOK-ST._CAT' => 'Mount Carmel-Mitchells Brook-St. Catherines',
		'CADIVISION_NO.__1,_SUBD._X' => 'Division No.  1, Subd. X',
		'CACOLINET' => 'Colinet',
		'CADIVISION_NO.__1,_SUBD._C' => 'Division No.  1, Subd. C',
		'CABRANCH' => 'Branch',
		'CAPOINT_LANCE' => 'Point Lance',
		'CAST._BRIDES' => 'St. Brides',
		'CADIVISION_NO.__1,_SUBD._B' => 'Division No.  1, Subd. B',
		'CAPLACENTIA' => 'Placentia',
		'CAFOX_HARBOUR' => 'Fox Harbour',
		'CADIVISION_NO.__1,_SUBD._A' => 'Division No.  1, Subd. A',
		'CALONG_HARBOUR-MOUNT_ARLINGTON_HEIGHTS' => 'Long Harbour-Mount Arlington Heights',
		'CASOUTHERN_HARBOUR' => 'Southern Harbour',
		'CAARNOLDS_COVE' => 'Arnolds Cove',
		'CACOME_BY_CHANCE' => 'Come By Chance',
		'CASUNNYSIDE' => 'Sunnyside',
		'CACHANCE_COVE' => 'Chance Cove',
		'CANORMANS_COVE-LONG_COVE' => 'Normans Cove-Long Cove',
		'CACHAPEL_ARM' => 'Chapel Arm',
		'CADIVISION_NO.__1,_SUBD._Y' => 'Division No.  1, Subd. Y',
		'CAWHITBOURNE' => 'Whitbourne',
		'CADIVISION_NO.__1,_SUBD._E' => 'Division No.  1, Subd. E',
		'CAWHITEWAY' => 'Whiteway',
		'CAHEARTS_DELIGHT-ISLINGTON' => 'Hearts Delight-Islington',
		'CAHEARTS_DESIRE' => 'Hearts Desire',
		'CADIVISION_NO.__1,_SUBD._F' => 'Division No.  1, Subd. F',
		'CAHEARTS_CONTENT' => 'Hearts Content',
		'CANEW_PERLICAN' => 'New Perlican',
		'CAWINTERTON' => 'Winterton',
		'CAHANTS_HARBOUR' => 'Hants Harbour',
		'CADIVISION_NO.__1,_SUBD._G' => 'Division No.  1, Subd. G',
		'CAOLD_PERLICAN' => 'Old Perlican',
		'CABAY_DE_VERDE' => 'Bay de Verde',
		'CASMALL_POINT-ADAMS_COVE-BLACKHEAD-BRO' => 'Small Point-Adams Cove-Blackhead-Broad Cove',
		'CADIVISION_NO.__1,_SUBD._H' => 'Division No.  1, Subd. H',
		'CASALMON_COVE' => 'Salmon Cove',
		'CAVICTORIA' => 'Victoria',
		'CACARBONEAR' => 'Carbonear',
		'CADIVISION_NO.__1,_SUBD._I' => 'Division No.  1, Subd. I',
		'CABRYANTS_COVE' => 'Bryants Cove',
		'CAHARBOUR_GRACE' => 'Harbour Grace',
		'CAUPPER_ISLAND_COVE' => 'Upper Island Cove',
		'CADIVISION_NO.__1,_SUBD._J' => 'Division No.  1, Subd. J',
		'CABISHOPS_COVE' => 'Bishops Cove',
		'CASPANIARDS_BAY' => 'Spaniards Bay',
		'CADIVISION_NO.__1,_SUBD._K' => 'Division No.  1, Subd. K',
		'CABAY_ROBERTS' => 'Bay Roberts',
		'CADIVISION_NO.__1,_SUBD._L' => 'Division No.  1, Subd. L',
		'CADIVISION_NO.__1,_SUBD._M' => 'Division No.  1, Subd. M',
		'CANORTH_RIVER' => 'North River',
		'CACLARKES_BEACH' => 'Clarkes Beach',
		'CASOUTH_RIVER' => 'South River',
		'CACUPIDS' => 'Cupids',
		'CADIVISION_NO.__1,_SUBD._N' => 'Division No.  1, Subd. N',
		'CABRIGUS' => 'Brigus',
		'CADIVISION_NO.__1,_SUBD._O' => 'Division No.  1, Subd. O',
		'CACOLLIERS' => 'Colliers',
		'CACONCEPTION_HARBOUR' => 'Conception Harbour',
		'CAAVONDALE' => 'Avondale',
		'CAHARBOUR_MAIN-CHAPELS_COVE-LAKEVIEW' => 'Harbour Main-Chapels Cove-Lakeview',
		'CAHOLYROOD' => 'Holyrood',
		'CACONCEPTION_BAY_SOUTH' => 'Conception Bay South',
		'CADIVISION_NO.__1,_SUBD._R' => 'Division No.  1, Subd. R',
		'CAWABANA' => 'Wabana',
		'CAPORTUGAL_COVE-ST._PHILIPS' => 'Portugal Cove-St. Philips',
		'CAPOUCH_COVE' => 'Pouch Cove',
		'CAFLATROCK' => 'Flatrock',
		'CATORBAY' => 'Torbay',
		'CALOGY_BAY-MIDDLE_COVE-OUTER_COVE' => 'Logy Bay-Middle Cove-Outer Cove',
		'CABAULINE' => 'Bauline',
		'CAPARADISE' => 'Paradise',
		'CAST._JOHNS' => 'St. Johns',
		'CAMOUNT_PEARL' => 'Mount Pearl',
		'CAPETTY_HARBOUR-MADDOX_COVE' => 'Petty Harbour-Maddox Cove',
		'CABAY_BULLS' => 'Bay Bulls',
		'CAWITLESS_BAY' => 'Witless Bay',
		'CADIVISION_NO.__1,_SUBD._D' => 'Division No.  1, Subd. D',
		'CADIVISION_NO.__2,_SUBD._E' => 'Division No.  2, Subd. E',
		'CALEWINS_COVE' => 'Lewins Cove',
		'CABURIN' => 'Burin',
		'CADIVISION_NO.__2,_SUBD._F' => 'Division No.  2, Subd. F',
		'CAST._LAWRENCE' => 'St. Lawrence',
		'CADIVISION_NO.__2,_SUBD._G' => 'Division No.  2, Subd. G',
		'CALAWN' => 'Lawn',
		'CALAMALINE' => 'Lamaline',
		'CALORDS_COVE' => 'Lords Cove',
		'CAPOINT_MAY' => 'Point May',
		'CAPOINT_AU_GAUL' => 'Point au Gaul',
		'CADIVISION_NO.__2,_SUBD._H' => 'Division No.  2, Subd. H',
		'CAFRENCHMANS_COVE' => 'Frenchmans Cove',
		'CAFORTUNE' => 'Fortune',
		'CAGRAND_BANK' => 'Grand Bank',
		'CAGARNISH' => 'Garnish',
		'CADIVISION_NO.__2,_SUBD._D' => 'Division No.  2, Subd. D',
		'CAWINTERLAND' => 'Winterland',
		'CAMARYSTOWN' => 'Marystown',
		'CAFOX_COVE-MORTIER' => 'Fox Cove-Mortier',
		'CADIVISION_NO.__2,_SUBD._I' => 'Division No.  2, Subd. I',
		'CABAY_LARGENT' => 'Bay LArgent',
		'CADIVISION_NO.__2,_SUBD._J' => 'Division No.  2, Subd. J',
		'CAGRAND_LE_PIERRE' => 'Grand le Pierre',
		'CADIVISION_NO.__2,_SUBD._C' => 'Division No.  2, Subd. C',
		'CARUSHOON' => 'Rushoon',
		'CAPARKERS_COVE' => 'Parkers Cove',
		'CATERRENCEVILLE' => 'Terrenceville',
		'CARED_HARBOUR' => 'Red Harbour',
		'CAENGLISH_HARBOUR_EAST' => 'English Harbour East',
		'CABAINE_HARBOUR' => 'Baine Harbour',
		'CAST._BERNARDS-JACQUES_FONTAINE' => 'St. Bernards-Jacques Fontaine',
		'CADIVISION_NO.__2,_SUBD._L' => 'Division No.  2, Subd. L',
		'CADIVISION_NO.__2,_SUBD._K' => 'Division No.  2, Subd. K',
		'CALITTLE_BAY_EAST' => 'Little Bay East',
		'CADIVISION_NO.__3,_SUBD._A' => 'Division No.  3, Subd. A',
		'CARENCONTRE_EAST' => 'Rencontre East',
		'CAST._JACQUES-COOMBS_COVE' => 'St. Jacques-Coombs Cove',
		'CABELLEORAM' => 'Belleoram',
		'CAPOOLS_COVE' => 'Pools Cove',
		'CADIVISION_NO.__3,_SUBD._B' => 'Division No.  3, Subd. B',
		'CAHARBOUR_BRETON' => 'Harbour Breton',
		'CADIVISION_NO.__3,_SUBD._C' => 'Division No.  3, Subd. C',
		'CASEAL_COVE_(FORTUNE_BAY)' => 'Seal Cove (Fortune Bay)',
		'CAHERMITAGE-SANDYVILLE' => 'Hermitage-Sandyville',
		'CAGAULTOIS' => 'Gaultois',
		'CADIVISION_NO.__3,_SUBD._D' => 'Division No.  3, Subd. D',
		'CAMILLTOWN-HEAD_OF_BAY_DESPOIR' => 'Milltown-Head of Bay dEspoir',
		'CAST._ALBANS' => 'St. Albans',
		'CAMORRISVILLE' => 'Morrisville',
		'CADIVISION_NO.__3,_SUBD._E' => 'Division No.  3, Subd. E',
		'CADIVISION_NO.__3,_SUBD._F' => 'Division No.  3, Subd. F',
		'CARAMEA' => 'Ramea',
		'CABURGEO' => 'Burgeo',
		'CADIVISION_NO.__3,_SUBD._H' => 'Division No.  3, Subd. H',
		'CAISLE_AUX_MORTS' => 'Isle aux Morts',
		'CABURNT_ISLANDS' => 'Burnt Islands',
		'CACHANNEL-PORT_AUX_BASQUES' => 'Channel-Port aux Basques',
		'CADIVISION_NO.__3,_SUBD._I' => 'Division No.  3, Subd. I',
		'CADIVISION_NO.__3,_SUBD._J' => 'Division No.  3, Subd. J',
		'CAROSE_BLANCHE-HARBOUR_LE_COU' => 'Rose Blanche-Harbour le Cou',
		'CASAMIAJIJ_MIAWPUKEK' => 'Samiajij Miawpukek',
		'CADIVISION_NO.__4,_SUBD._A' => 'Division No.  4, Subd. A',
		'CADIVISION_NO.__4,_SUBD._B' => 'Division No.  4, Subd. B',
		'CADIVISION_NO.__4,_SUBD._C' => 'Division No.  4, Subd. C',
		'CAST._GEORGES' => 'St. Georges',
		'CADIVISION_NO.__4,_SUBD._D' => 'Division No.  4, Subd. D',
		'CAGALLANTS' => 'Gallants',
		'CASTEPHENVILLE_CROSSING' => 'Stephenville Crossing',
		'CASTEPHENVILLE' => 'Stephenville',
		'CAKIPPENS' => 'Kippens',
		'CAPORT_AU_PORT_EAST' => 'Port au Port East',
		'CADIVISION_NO.__4,_SUBD._E' => 'Division No.  4, Subd. E',
		'CACAPE_ST._GEORGE' => 'Cape St. George',
		'CALOURDES' => 'Lourdes',
		'CAPORT_AU_PORT_WEST-AGUATHUNA-FELIX_CO' => 'Port au Port West-Aguathuna-Felix Cove',
		'CADIVISION_NO.__5,_SUBD._A' => 'Division No.  5, Subd. A',
		'CADIVISION_NO.__5,_SUBD._G' => 'Division No.  5, Subd. G',
		'CADEER_LAKE' => 'Deer Lake',
		'CAJACKSONS_ARM' => 'Jacksons Arm',
		'CAHOWLEY' => 'Howley',
		'CADIVISION_NO.__5,_SUBD._E' => 'Division No.  5, Subd. E',
		'CAHAMPDEN' => 'Hampden',
		'CAREIDVILLE' => 'Reidville',
		'CADIVISION_NO.__5,_SUBD._F' => 'Division No.  5, Subd. F',
		'CASTEADY_BROOK' => 'Steady Brook',
		'CAPASADENA' => 'Pasadena',
		'CACORMACK' => 'Cormack',
		'CAGILLAMS' => 'Gillams',
		'CADIVISION_NO.__5,_SUBD._C' => 'Division No.  5, Subd. C',
		'CAMASSEY_DRIVE' => 'Massey Drive',
		'CACORNER_BROOK' => 'Corner Brook',
		'CADIVISION_NO.__5,_SUBD._D' => 'Division No.  5, Subd. D',
		'CAHUMBER_ARM_SOUTH' => 'Humber Arm South',
		'CAMCIVERS' => 'McIvers',
		'CACOXS_COVE' => 'Coxs Cove',
		'CALARK_HARBOUR' => 'Lark Harbour',
		'CAMEADOWS' => 'Meadows',
		'CAHUGHES_BROOK' => 'Hughes Brook',
		'CAIRISHTOWN-SUMMERSIDE' => 'Irishtown-Summerside',
		'CAMOUNT_MORIAH' => 'Mount Moriah',
		'CAYORK_HARBOUR' => 'York Harbour',
		'CADIVISION_NO.__6,_SUBD._D' => 'Division No.  6, Subd. D',
		'CANORRIS_ARM' => 'Norris Arm',
		'CADIVISION_NO.__6,_SUBD._E' => 'Division No.  6, Subd. E',
		'CAGANDER' => 'Gander',
		'CAAPPLETON' => 'Appleton',
		'CAGLENWOOD' => 'Glenwood',
		'CADIVISION_NO.__6,_SUBD._C' => 'Division No.  6, Subd. C',
		'CANORTHERN_ARM' => 'Northern Arm',
		'CAGRAND_FALLS-WINDSOR' => 'Grand Falls-Windsor',
		'CABISHOPS_FALLS' => 'Bishops Falls',
		'CAPETERVIEW' => 'Peterview',
		'CABOTWOOD' => 'Botwood',
		'CABADGER' => 'Badger',
		'CAMILLERTOWN' => 'Millertown',
		'CADIVISION_NO.__6,_SUBD._A' => 'Division No.  6, Subd. A',
		'CABUCHANS' => 'Buchans',
		'CADIVISION_NO.__7,_SUBD._M' => 'Division No.  7, Subd. M',
		'CADIVISION_NO.__7,_SUBD._L' => 'Division No.  7, Subd. L',
		'CADIVISION_NO.__7,_SUBD._K' => 'Division No.  7, Subd. K',
		'CACLARENVILLE' => 'Clarenville',
		'CADIVISION_NO.__7,_SUBD._J' => 'Division No.  7, Subd. J',
		'CATRINITY_(TRINITY_BAY)' => 'Trinity (Trinity Bay)',
		'CAPORT_REXTON' => 'Port Rexton',
		'CADIVISION_NO.__7,_SUBD._I' => 'Division No.  7, Subd. I',
		'CAELLISTON' => 'Elliston',
		'CATRINITY_BAY_NORTH' => 'Trinity Bay North',
		'CABONAVISTA' => 'Bonavista',
		'CADIVISION_NO.__7,_SUBD._G' => 'Division No.  7, Subd. G',
		'CAKEELS' => 'Keels',
		'CADUNTARA' => 'Duntara',
		'CAKINGS_COVE' => 'Kings Cove',
		'CADIVISION_NO.__7,_SUBD._F' => 'Division No.  7, Subd. F',
		'CADIVISION_NO.__7,_SUBD._E' => 'Division No.  7, Subd. E',
		'CAMUSGRAVETOWN' => 'Musgravetown',
		'CAPORT_BLANDFORD' => 'Port Blandford',
		'CATRAYTOWN' => 'Traytown',
		'CADIVISION_NO.__7,_SUBD._D' => 'Division No.  7, Subd. D',
		'CASANDY_COVE' => 'Sandy Cove',
		'CATERRA_NOVA' => 'Terra Nova',
		'CAHAPPY_ADVENTURE' => 'Happy Adventure',
		'CAEASTPORT' => 'Eastport',
		'CASANDRINGHAM' => 'Sandringham',
		'CAGLOVERTOWN' => 'Glovertown',
		'CADIVISION_NO.__7,_SUBD._N' => 'Division No.  7, Subd. N',
		'CASALVAGE' => 'Salvage',
		'CAGAMBO' => 'Gambo',
		'CAST._BRENDANS' => 'St. Brendans',
		'CAHARE_BAY' => 'Hare Bay',
		'CACENTREVILLE-WAREHAM-TRINITY' => 'Centreville-Wareham-Trinity',
		'CADIVISION_NO.__7,_SUBD._B' => 'Division No.  7, Subd. B',
		'CAGREENSPOND' => 'Greenspond',
		'CADIVISION_NO.__7,_SUBD._A' => 'Division No.  7, Subd. A',
		'CADOVER' => 'Dover',
		'CANEW-WES-VALLEY' => 'New-Wes-Valley',
		'CAINDIAN_BAY' => 'Indian Bay',
		'CADIVISION_NO.__8,_SUBD._M' => 'Division No.  8, Subd. M',
		'CALUMSDEN' => 'Lumsden',
		'CAMUSGRAVE_HARBOUR' => 'Musgrave Harbour',
		'CADIVISION_NO.__8,_SUBD._L' => 'Division No.  8, Subd. L',
		'CACARMANVILLE' => 'Carmanville',
		'CACHANGE_ISLANDS' => 'Change Islands',
		'CADIVISION_NO.__8,_SUBD._I' => 'Division No.  8, Subd. I',
		'CACROW_HEAD' => 'Crow Head',
		'CADIVISION_NO.__8,_SUBD._H' => 'Division No.  8, Subd. H',
		'CACOTTLESVILLE' => 'Cottlesville',
		'CASUMMERFORD' => 'Summerford',
		'CATWILLINGATE' => 'Twillingate',
		'CADIVISION_NO.__8,_SUBD._G' => 'Division No.  8, Subd. G',
		'CACAMPBELLTON' => 'Campbellton',
		'CABIRCHY_BAY' => 'Birchy Bay',
		'CACOMFORT_COVE-NEWSTEAD' => 'Comfort Cove-Newstead',
		'CABAYTONA' => 'Baytona',
		'CADIVISION_NO.__8,_SUBD._F' => 'Division No.  8, Subd. F',
		'CAEMBREE' => 'Embree',
		'CALEWISPORTE' => 'Lewisporte',
		'CALITTLE_BURNT_BAY' => 'Little Burnt Bay',
		'CADIVISION_NO.__8,_SUBD._E' => 'Division No.  8, Subd. E',
		'CAPOINT_OF_BAY' => 'Point of Bay',
		'CALEADING_TICKLES' => 'Leading Tickles',
		'CAPOINT_LEAMINGTON' => 'Point Leamington',
		'CADIVISION_NO.__8,_SUBD._D' => 'Division No.  8, Subd. D',
		'CAPILLEYS_ISLAND' => 'Pilleys Island',
		'CATRITON' => 'Triton',
		'CABRIGHTON' => 'Brighton',
		'CALUSHES_BIGHT-BEAUMONT-BEAUMONT_NORTH' => 'Lushes Bight-Beaumont-Beaumont North',
		'CADIVISION_NO.__8,_SUBD._C' => 'Division No.  8, Subd. C',
		'CASOUTH_BROOK' => 'South Brook',
		'CAROBERTS_ARM' => 'Roberts Arm',
		'CASPRINGDALE' => 'Springdale',
		'CAPORT_ANSON' => 'Port Anson',
		'CALITTLE_BAY' => 'Little Bay',
		'CALITTLE_BAY_ISLANDS' => 'Little Bay Islands',
		'CADIVISION_NO.__8,_SUBD._P' => 'Division No.  8, Subd. P',
		'CABEACHSIDE' => 'Beachside',
		'CADIVISION_NO.__8,_SUBD._O' => 'Division No.  8, Subd. O',
		'CAKINGS_POINT' => 'Kings Point',
		'CANIPPERS_HARBOUR' => 'Nippers Harbour',
		'CABURLINGTON' => 'Burlington',
		'CAMIDDLE_ARM' => 'Middle Arm',
		'CATILT_COVE' => 'Tilt Cove',
		'CADIVISION_NO.__8,_SUBD._A' => 'Division No.  8, Subd. A',
		'CAFLEUR_DE_LYS' => 'Fleur de Lys',
		'CALASCIE' => 'LaScie',
		'CABRENTS_COVE' => 'Brents Cove',
		'CAPACQUET' => 'Pacquet',
		'CABAIE_VERTE' => 'Baie Verte',
		'CASEAL_COVE_(WHITE_BAY)' => 'Seal Cove (White Bay)',
		'CACOACHMANS_COVE' => 'Coachmans Cove',
		'CAWESTPORT' => 'Westport',
		'CAMINGS_BIGHT' => 'Mings Bight',
		'CAWOODSTOCK' => 'Woodstock',
		'CAMILES_COVE' => 'Miles Cove',
		'CAFOGO_ISLAND' => 'Fogo Island',
		'CADIVISION_NO.__9,_SUBD._F' => 'Division No.  9, Subd. F',
		'CAENGLEE' => 'Englee',
		'CARODDICKTON-BIDE_ARM' => 'Roddickton-Bide Arm',
		'CACONCHE' => 'Conche',
		'CADIVISION_NO.__9,_SUBD._A' => 'Division No.  9, Subd. A',
		'CATROUT_RIVER' => 'Trout River',
		'CAWOODY_POINT,_BONNE_BAY' => 'Woody Point, Bonne Bay',
		'CANORRIS_POINT' => 'Norris Point',
		'CAROCKY_HARBOUR' => 'Rocky Harbour',
		'CADANIELS_HARBOUR' => 'Daniels Harbour',
		'CACOW_HEAD' => 'Cow Head',
		'CAPARSONS_POND' => 'Parsons Pond',
		'CAHAWKES_BAY' => 'Hawkes Bay',
		'CAPORT_SAUNDERS' => 'Port Saunders',
		'CAST._PAULS' => 'St. Pauls',
		'CADIVISION_NO.__9,_SUBD._C' => 'Division No.  9, Subd. C',
		'CAPORT_AU_CHOIX' => 'Port au Choix',
		'CAANCHOR_POINT' => 'Anchor Point',
		'CAFLOWERS_COVE' => 'Flowers Cove',
		'CABIRD_COVE' => 'Bird Cove',
		'CAMAIN_BROOK' => 'Main Brook',
		'CAST._ANTHONY' => 'St. Anthony',
		'CAGLENBURNIE-BIRCHY_HEAD-SHOAL_BROOK' => 'Glenburnie-Birchy Head-Shoal Brook',
		'CADIVISION_NO.__9,_SUBD._D' => 'Division No.  9, Subd. D',
		'CAST._LUNAIRE-GRIQUET' => 'St. Lunaire-Griquet',
		'CACOOKS_HARBOUR' => 'Cooks Harbour',
		'CARALEIGH' => 'Raleigh',
		'CASALLYS_COVE' => 'Sallys Cove',
		'CAGOOSE_COVE_EAST' => 'Goose Cove East',
		'CADIVISION_NO.__9,_SUBD._H' => 'Division No.  9, Subd. H',
		'CABELLBURNS' => 'Bellburns',
		'CADIVISION_NO.__9,_SUBD._G' => 'Division No.  9, Subd. G',
		'CARIVER_OF_PONDS' => 'River of Ponds',
		'CADIVISION_NO._10,_SUBD._A' => 'Division No. 10, Subd. A',
		'CALANSE_AU_LOUP' => 'LAnse au Loup',
		'CARED_BAY' => 'Red Bay',
		'CALANSE-AU-CLAIR' => 'LAnse-au-Clair',
		'CAFORTEAU' => 'Forteau',
		'CAWEST_ST._MODESTE' => 'West St. Modeste',
		'CAPINWARE' => 'Pinware',
		'CADIVISION_NO._10,_SUBD._B' => 'Division No. 10, Subd. B',
		'CAPORT_HOPE_SIMPSON' => 'Port Hope Simpson',
		'CAST._LEWIS' => 'St. Lewis',
		'CAMARYS_HARBOUR' => 'Marys Harbour',
		'CACARTWRIGHT,_LABRADOR' => 'Cartwright, Labrador',
		'CACHARLOTTETOWN_(LABRADOR)' => 'Charlottetown (Labrador)',
		'CADIVISION_NO._10,_SUBD._C' => 'Division No. 10, Subd. C',
		'CANORTH_WEST_RIVER' => 'North West River',
		'CAHAPPY_VALLEY-GOOSE_BAY' => 'Happy Valley-Goose Bay',
		'CADIVISION_NO._10,_SUBD._D' => 'Division No. 10, Subd. D',
		'CALABRADOR_CITY' => 'Labrador City',
		'CAWABUSH' => 'Wabush',
		'CADIVISION_NO._10,_SUBD._E' => 'Division No. 10, Subd. E',
		'CANATUASHISH__2' => 'Natuashish  2',
		'CASHESHATSHIU_3' => 'Sheshatshiu 3',
		'CADIVISION_NO._11,_SUBD._C' => 'Division No. 11, Subd. C',
		'CARIGOLET' => 'Rigolet',
		'CAPOSTVILLE' => 'Postville',
		'CAMAKKOVIK' => 'Makkovik',
		'CAHOPEDALE' => 'Hopedale',
		'CANAIN' => 'Nain',
		'CADIVISION_NO._11,_SUBD._E' => 'Division No. 11, Subd. E',
	],
	'PE' => [
		'CALOT_64' => 'Lot 64',
		'CAMURRAY_HARBOUR' => 'Murray Harbour',
		'CAMURRAY_RIVER' => 'Murray River',
		'CALOT_63' => 'Lot 63',
		'CALOT_61' => 'Lot 61',
		'CALOT_59' => 'Lot 59',
		'CALOT_66' => 'Lot 66',
		'CALOT_51' => 'Lot 51',
		'CALOT_52' => 'Lot 52',
		'CAMONTAGUE' => 'Montague',
		'CALOT_53' => 'Lot 53',
		'CACARDIGAN' => 'Cardigan',
		'CAKINGS,_ROYALTY' => 'Kings, Royalty',
		'CAGEORGETOWN' => 'Georgetown',
		'CALOT_54' => 'Lot 54',
		'CALOT_55' => 'Lot 55',
		'CALOT_56' => 'Lot 56',
		'CALOT_43' => 'Lot 43',
		'CALOT_44' => 'Lot 44',
		'CALOT_45' => 'Lot 45',
		'CASOURIS' => 'Souris',
		'CALOT_46' => 'Lot 46',
		'CALOT_47' => 'Lot 47',
		'CALOT_42' => 'Lot 42',
		'CALOT_41' => 'Lot 41',
		'CAST._PETERS_BAY' => 'St. Peters Bay',
		'CALOT_40' => 'Lot 40',
		'CAMORELL' => 'Morell',
		'CALOT_39' => 'Lot 39',
		'CAMORELL_2' => 'Morell 2',
		'CALOT_38' => 'Lot 38',
		'CALOT_62' => 'Lot 62',
		'CALOT_60' => 'Lot 60',
		'CALOT_58' => 'Lot 58',
		'CALOT_57' => 'Lot 57',
		'CALOT_50' => 'Lot 50',
		'CALOT_49' => 'Lot 49',
		'CALOT_48' => 'Lot 48',
		'CALOT_31' => 'Lot 31',
		'CALOT_65' => 'Lot 65',
		'CALOT_30' => 'Lot 30',
		'CAROCKY_POINT_3' => 'Rocky Point 3',
		'CALOT_29' => 'Lot 29',
		'CAVICTORIA' => 'Victoria',
		'CAMEADOWBANK' => 'Meadowbank',
		'CACRAPAUD' => 'Crapaud',
		'CALOT_67' => 'Lot 67',
		'CACLYDE_RIVER' => 'Clyde River',
		'CALOT_20' => 'Lot 20',
		'CALOT_21' => 'Lot 21',
		'CAMILTONVALE_PARK' => 'Miltonvale Park',
		'CALOT_22' => 'Lot 22',
		'CALOT_23' => 'Lot 23',
		'CAHUNTER_RIVER' => 'Hunter River',
		'CALOT_24' => 'Lot 24',
		'CARESORT_MUN._STAN.B.-HOPE_R.-BAYV.-CA' => 'Resort Mun. Stan.B.-Hope R.-Bayv.-Cavend.-N.Rust.',
		'CANORTH_RUSTICO' => 'North Rustico',
		'CABRACKLEY' => 'Brackley',
		'CALOT_33' => 'Lot 33',
		'CAUNION_ROAD' => 'Union Road',
		'CABREADALBANE' => 'Breadalbane',
		'CALOT_34' => 'Lot 34',
		'CALOT_35' => 'Lot 35',
		'CALOT_36' => 'Lot 36',
		'CASCOTCHFORT_4' => 'Scotchfort 4',
		'CALOT_37' => 'Lot 37',
		'CAMOUNT_STEWART' => 'Mount Stewart',
		'CAWINSLOE_SOUTH' => 'Winsloe South',
		'CAWARREN_GROVE' => 'Warren Grove',
		'CACHARLOTTETOWN' => 'Charlottetown',
		'CASTRATFORD' => 'Stratford',
		'CACORNWALL' => 'Cornwall',
		'CALOT_28' => 'Lot 28',
		'CABORDEN-CARLETON' => 'Borden-Carleton',
		'CALOT_27' => 'Lot 27',
		'CAKINKORA' => 'Kinkora',
		'CALOT_26' => 'Lot 26',
		'CALOT_25' => 'Lot 25',
		'CALOT_19' => 'Lot 19',
		'CAKENSINGTON' => 'Kensington',
		'CABEDEQUE_AND_AREA' => 'Bedeque and Area',
		'CALOT_18' => 'Lot 18',
		'CASHERBROOKE' => 'Sherbrooke',
		'CALOT_17' => 'Lot 17',
		'CALINKLETTER' => 'Linkletter',
		'CAMISCOUCHE' => 'Miscouche',
		'CASUMMERSIDE' => 'Summerside',
		'CALOT_15' => 'Lot 15',
		'CAABRAMS_VILLAGE' => 'Abrams Village',
		'CALOT_16' => 'Lot 16',
		'CAWELLINGTON' => 'Wellington',
		'CALOT_14' => 'Lot 14',
		'CALOT_13' => 'Lot 13',
		'CATYNE_VALLEY' => 'Tyne Valley',
		'CALOT_12' => 'Lot 12',
		'CALENNOX_ISLAND_1' => 'Lennox Island 1',
		'CALOT_11' => 'Lot 11',
		'CALOT_10' => 'Lot 10',
		'CALOT__6' => 'Lot  6',
		'CAOLEARY' => 'OLeary',
		'CALOT__9' => 'Lot  9',
		'CALOT__8' => 'Lot  8',
		'CALOT__7' => 'Lot  7',
		'CALOT__5' => 'Lot  5',
		'CALOT__4' => 'Lot  4',
		'CAALBERTON' => 'Alberton',
		'CALOT__3' => 'Lot  3',
		'CALOT__2' => 'Lot  2',
		'CAST._LOUIS' => 'St. Louis',
		'CALOT__1' => 'Lot  1',
		'CATIGNISH' => 'Tignish',
		'CAMIMINEGASH' => 'Miminegash',
	],
	'NS' => [
		'CABARRINGTON' => 'Barrington',
		'CACLARKS_HARBOUR' => 'Clarks Harbour',
		'CASHELBURNE' => 'Shelburne',
		'CASHELBURNE' => 'Shelburne',
		'CALOCKEPORT' => 'Lockeport',
		'CAARGYLE' => 'Argyle',
		'CAYARMOUTH' => 'Yarmouth',
		'CAYARMOUTH' => 'Yarmouth',
		'CAYARMOUTH_33' => 'Yarmouth 33',
		'CACLARE' => 'Clare',
		'CADIGBY' => 'Digby',
		'CADIGBY' => 'Digby',
		'CABEAR_RIVER_(PART)_6' => 'Bear River (Part) 6',
		'CAPONHOOK_LAKE_10' => 'Ponhook Lake 10',
		'CAQUEENS' => 'Queens',
		'CAWILDCAT_12' => 'Wildcat 12',
		'CAANNAPOLIS,_SUBD._D' => 'Annapolis, Subd. D',
		'CABEAR_RIVER_(PART)_6' => 'Bear River (Part) 6',
		'CAANNAPOLIS,_SUBD._A' => 'Annapolis, Subd. A',
		'CABEAR_RIVER_6B' => 'Bear River 6B',
		'CAANNAPOLIS_ROYAL' => 'Annapolis Royal',
		'CAANNAPOLIS,_SUBD._B' => 'Annapolis, Subd. B',
		'CAANNAPOLIS,_SUBD._C' => 'Annapolis, Subd. C',
		'CAMIDDLETON' => 'Middleton',
		'CALUNENBURG' => 'Lunenburg',
		'CABRIDGEWATER' => 'Bridgewater',
		'CALUNENBURG' => 'Lunenburg',
		'CAMAHONE_BAY' => 'Mahone Bay',
		'CACHESTER' => 'Chester',
		'CAGOLD_RIVER_21' => 'Gold River 21',
		'CAPENNAL_19' => 'Pennal 19',
		'CANEW_ROSS_20' => 'New Ross 20',
		'CAKINGS,_SUBD._A' => 'Kings, Subd. A',
		'CACAMBRIDGE_32' => 'Cambridge 32',
		'CABERWICK' => 'Berwick',
		'CAKINGS,_SUBD._C' => 'Kings, Subd. C',
		'CAKENTVILLE' => 'Kentville',
		'CAKINGS,_SUBD._B' => 'Kings, Subd. B',
		'CAKINGS,_SUBD._D' => 'Kings, Subd. D',
		'CAWOLFVILLE' => 'Wolfville',
		'CAGLOOSCAP_35' => 'Glooscap 35',
		'CAWEST_HANTS' => 'West Hants',
		'CAWINDSOR' => 'Windsor',
		'CAEAST_HANTS' => 'East Hants',
		'CAINDIAN_BROOK_14' => 'Indian Brook 14',
		'CACOLE_HARBOUR_30' => 'Cole Harbour 30',
		'CASHUBENACADIE_13' => 'Shubenacadie 13',
		'CAHALIFAX' => 'Halifax',
		'CABEAVER_LAKE_17' => 'Beaver Lake 17',
		'CASHEET_HARBOUR_36' => 'Sheet Harbour 36',
		'CAWALLACE_HILLS_14A' => 'Wallace Hills 14A',
		'CACOLCHESTER,_SUBD._C' => 'Colchester, Subd. C',
		'CASTEWIACKE' => 'Stewiacke',
		'CAMILLBROOK_27' => 'Millbrook 27',
		'CATRURO' => 'Truro',
		'CACOLCHESTER,_SUBD._B' => 'Colchester, Subd. B',
		'CACOLCHESTER,_SUBD._A' => 'Colchester, Subd. A',
		'CACUMBERLAND,_SUBD._A' => 'Cumberland, Subd. A',
		'CAPARRSBORO' => 'Parrsboro',
		'CACUMBERLAND,_SUBD._B' => 'Cumberland, Subd. B',
		'CACUMBERLAND,_SUBD._C' => 'Cumberland, Subd. C',
		'CAAMHERST' => 'Amherst',
		'CAOXFORD' => 'Oxford',
		'CACUMBERLAND,_SUBD._D' => 'Cumberland, Subd. D',
		'CAPICTOU,_SUBD._A' => 'Pictou, Subd. A',
		'CAPICTOU' => 'Pictou',
		'CAPICTOU,_SUBD._B' => 'Pictou, Subd. B',
		'CAWESTVILLE' => 'Westville',
		'CASTELLARTON' => 'Stellarton',
		'CAPICTOU,_SUBD._C' => 'Pictou, Subd. C',
		'CANEW_GLASGOW' => 'New Glasgow',
		'CATRENTON' => 'Trenton',
		'CAFISHERS_GRANT_24' => 'Fishers Grant 24',
		'CAMERIGOMISH_HARBOUR_31' => 'Merigomish Harbour 31',
		'CAST._MARYS' => 'St. Marys',
		'CAGUYSBOROUGH' => 'Guysborough',
		'CAMULGRAVE' => 'Mulgrave',
		'CAANTIGONISH,_SUBD._A' => 'Antigonish, Subd. A',
		'CAANTIGONISH' => 'Antigonish',
		'CAANTIGONISH,_SUBD._B' => 'Antigonish, Subd. B',
		'CAPOMQUET_AND_AFTON_23' => 'Pomquet And Afton 23',
		'CAINVERNESS,_SUBD._C' => 'Inverness, Subd. C',
		'CAPORT_HAWKESBURY' => 'Port Hawkesbury',
		'CAINVERNESS,_SUBD._B' => 'Inverness, Subd. B',
		'CAWHYCOCOMAGH_2' => 'Whycocomagh 2',
		'CAINVERNESS,_SUBD._A' => 'Inverness, Subd. A',
		'CARICHMOND,_SUBD._C' => 'Richmond, Subd. C',
		'CARICHMOND,_SUBD._A' => 'Richmond, Subd. A',
		'CARICHMOND,_SUBD._B' => 'Richmond, Subd. B',
		'CACHAPEL_ISLAND_5' => 'Chapel Island 5',
		'CAMEMBERTOU_28B' => 'Membertou 28B',
		'CAESKASONI_3' => 'Eskasoni 3',
		'CACAPE_BRETON' => 'Cape Breton',
		'CAVICTORIA,_SUBD._B' => 'Victoria, Subd. B',
		'CAWAGMATCOOK_1' => 'Wagmatcook 1',
		'CAVICTORIA,_SUBD._A' => 'Victoria, Subd. A',
	],
	'NB' => [
		'CASAINT_MARTINS' => 'Saint Martins',
		'CAST._MARTINS' => 'St. Martins',
		'CASIMONDS' => 'Simonds',
		'CASAINT_JOHN' => 'Saint John',
		'CAMUSQUASH' => 'Musquash',
		'CAGRAND_MANAN' => 'Grand Manan',
		'CACAMPOBELLO_ISLAND' => 'Campobello Island',
		'CAWEST_ISLES' => 'West Isles',
		'CALEPREAU' => 'Lepreau',
		'CAPENNFIELD' => 'Pennfield',
		'CABLACKS_HARBOUR' => 'Blacks Harbour',
		'CACLARENDON' => 'Clarendon',
		'CASAINT_GEORGE' => 'Saint George',
		'CAST._GEORGE' => 'St. George',
		'CASAINT_PATRICK' => 'Saint Patrick',
		'CASAINT_ANDREWS' => 'Saint Andrews',
		'CASAINT_ANDREWS' => 'Saint Andrews',
		'CASAINT_CROIX' => 'Saint Croix',
		'CADUFFERIN' => 'Dufferin',
		'CASAINT_STEPHEN' => 'Saint Stephen',
		'CAST._STEPHEN' => 'St. Stephen',
		'CASAINT_JAMES' => 'Saint James',
		'CASAINT_DAVID' => 'Saint David',
		'CADUMBARTON' => 'Dumbarton',
		'CAGRAND_MANAN' => 'Grand Manan',
		'CABLISSVILLE' => 'Blissville',
		'CAGLADSTONE' => 'Gladstone',
		'CATRACY' => 'Tracy',
		'CAFREDERICTON_JUNCTION' => 'Fredericton Junction',
		'CALINCOLN' => 'Lincoln',
		'CABURTON' => 'Burton',
		'CAOROMOCTO' => 'Oromocto',
		'CAOROMOCTO_26' => 'Oromocto 26',
		'CASHEFFIELD' => 'Sheffield',
		'CAMAUGERVILLE' => 'Maugerville',
		'CANORTHFIELD' => 'Northfield',
		'CAPETERSVILLE' => 'Petersville',
		'CAGAGETOWN' => 'Gagetown',
		'CAGAGETOWN' => 'Gagetown',
		'CAHAMPSTEAD' => 'Hampstead',
		'CAWICKHAM' => 'Wickham',
		'CACAMBRIDGE' => 'Cambridge',
		'CACAMBRIDGE-NARROWS' => 'Cambridge-Narrows',
		'CAJOHNSTON' => 'Johnston',
		'CABRUNSWICK' => 'Brunswick',
		'CAWATERBOROUGH' => 'Waterborough',
		'CACANNING' => 'Canning',
		'CAMINTO' => 'Minto',
		'CACHIPMAN' => 'Chipman',
		'CACHIPMAN' => 'Chipman',
		'CAHAMMOND' => 'Hammond',
		'CAUPHAM' => 'Upham',
		'CAHAMPTON' => 'Hampton',
		'CAHAMPTON' => 'Hampton',
		'CAROTHESAY' => 'Rothesay',
		'CAWESTFIELD' => 'Westfield',
		'CANBKINGSTON' => 'Kingston',
		'CAGRAND_BAY-WESTFIELD' => 'Grand Bay-Westfield',
		'CANORTON' => 'Norton',
		'CANORTON' => 'Norton',
		'CASUSSEX' => 'Sussex',
		'CASUSSEX' => 'Sussex',
		'CASUSSEX_CORNER' => 'Sussex Corner',
		'CAWATERFORD' => 'Waterford',
		'CACARDWELL' => 'Cardwell',
		'CAHAVELOCK' => 'Havelock',
		'CASTUDHOLM' => 'Studholm',
		'CASPRINGFIELD' => 'Springfield',
		'CAKARS' => 'Kars',
		'CAGREENWICH' => 'Greenwich',
		'CAROTHESAY' => 'Rothesay',
		'CAQUISPAMSIS' => 'Quispamsis',
		'CAHOPEWELL' => 'Hopewell',
		'CARIVERSIDE-ALBERT' => 'Riverside-Albert',
		'CAHARVEY' => 'Harvey',
		'CAALMA' => 'Alma',
		'CAALMA' => 'Alma',
		'CAELGIN' => 'Elgin',
		'CAHILLSBOROUGH' => 'Hillsborough',
		'CACOVERDALE' => 'Coverdale',
		'CARIVERVIEW' => 'Riverview',
		'CAHILLSBOROUGH' => 'Hillsborough',
		'CAWESTMORLAND' => 'Westmorland',
		'CAPORT_ELGIN' => 'Port Elgin',
		'CABOTSFORD' => 'Botsford',
		'CABEAUBASSIN_EAST' => 'Beaubassin East',
		'CACAP-PEL' => 'Cap-Pel',
		'CASACKVILLE' => 'Sackville',
		'CASACKVILLE' => 'Sackville',
		'CADORCHESTER' => 'Dorchester',
		'CADORCHESTER' => 'Dorchester',
		'CAMEMRAMCOOK' => 'Memramcook',
		'CAFORT_FOLLY_1' => 'Fort Folly 1',
		'CASHEDIAC' => 'Shediac',
		'CAMONCTON' => 'Moncton',
		'CAMONCTON' => 'Moncton',
		'CASALISBURY' => 'Salisbury',
		'CASALISBURY' => 'Salisbury',
		'CAPETITCODIAC' => 'Petitcodiac',
		'CADIEPPE' => 'Dieppe',
		'CASHEDIAC' => 'Shediac',
		'CADUNDAS' => 'Dundas',
		'CACOCAGNE' => 'Cocagne',
		'CABUCTOUCHE_16' => 'Buctouche 16',
		'CAWELLINGTON' => 'Wellington',
		'CABOUCTOUCHE' => 'Bouctouche',
		'CASAINT_MARY' => 'Saint Mary',
		'CASAINT-ANTOINE' => 'Saint-Antoine',
		'CASAINT-PAUL' => 'Saint-Paul',
		'CAHARCOURT' => 'Harcourt',
		'CAHUSKISSON' => 'Huskisson',
		'CAWELDFORD' => 'Weldford',
		'CARICHIBUCTO_15' => 'Richibucto 15',
		'CARICHIBUCTO' => 'Richibucto',
		'CAREXTON' => 'Rexton',
		'CARICHIBUCTO' => 'Richibucto',
		'CASAINT-CHARLES' => 'Saint-Charles',
		'CAINDIAN_ISLAND_28' => 'Indian Island 28',
		'CASAINT-LOUIS' => 'Saint-Louis',
		'CASAINT-LOUIS_DE_KENT' => 'Saint-Louis de Kent',
		'CAACADIEVILLE' => 'Acadieville',
		'CACARLETON' => 'Carleton',
		'CAHARDWICKE' => 'Hardwicke',
		'CAGLENELG' => 'Glenelg',
		'CACHATHAM' => 'Chatham',
		'CADERBY' => 'Derby',
		'CANELSON' => 'Nelson',
		'CAROGERSVILLE' => 'Rogersville',
		'CAROGERSVILLE' => 'Rogersville',
		'CABLACKVILLE' => 'Blackville',
		'CABLACKVILLE' => 'Blackville',
		'CABLISSFIELD' => 'Blissfield',
		'CADOAKTOWN' => 'Doaktown',
		'CARED_BANK_4' => 'Red Bank 4',
		'CASOUTHESK' => 'Southesk',
		'CAUPPER_MIRAMICHI' => 'Upper Miramichi',
		'CANORTHESK' => 'Northesk',
		'CANEWCASTLE' => 'Newcastle',
		'CABIG_HOLE_TRACT_8_(SOUTH_HALF)' => 'Big Hole Tract 8 (South Half)',
		'CAEEL_GROUND_2' => 'Eel Ground 2',
		'CAALNWICK' => 'Alnwick',
		'CANEGUAC' => 'Neguac',
		'CAESGENOPETITJ_14' => 'Esgenopetitj 14',
		'CATABUSINTAC_9' => 'Tabusintac 9',
		'CAMIRAMICHI' => 'Miramichi',
		'CANEW_MARYLAND' => 'New Maryland',
		'CANEW_MARYLAND' => 'New Maryland',
		'CAMANNERS_SUTTON' => 'Manners Sutton',
		'CAHARVEY' => 'Harvey',
		'CAMCADAM' => 'McAdam',
		'CAMCADAM' => 'McAdam',
		'CANORTH_LAKE' => 'North Lake',
		'CACANTERBURY' => 'Canterbury',
		'CACANTERBURY' => 'Canterbury',
		'CAMEDUCTIC' => 'Meductic',
		'CADUMFRIES' => 'Dumfries',
		'CAPRINCE_WILLIAM' => 'Prince William',
		'CAHANWELL' => 'Hanwell',
		'CAKINGSCLEAR' => 'Kingsclear',
		'CAKINGSCLEAR_6' => 'Kingsclear 6',
		'CAQUEENSBURY' => 'Queensbury',
		'CASOUTHAMPTON' => 'Southampton',
		'CAMILLVILLE' => 'Millville',
		'CABRIGHT' => 'Bright',
		'CADOUGLAS' => 'Douglas',
		'CASAINT_MARYS' => 'Saint Marys',
		'CAFREDERICTON' => 'Fredericton',
		'CADEVON_30' => 'Devon 30',
		'CASTANLEY' => 'Stanley',
		'CASTANLEY' => 'Stanley',
		'CANACKAWIC' => 'Nackawic',
		'CARICHMOND' => 'Richmond',
		'CAWOODSTOCK' => 'Woodstock',
		'CAWOODSTOCK_23' => 'Woodstock 23',
		'CAWOODSTOCK' => 'Woodstock',
		'CANORTHAMPTON' => 'Northampton',
		'CABRIGHTON' => 'Brighton',
		'CAHARTLAND' => 'Hartland',
		'CAWAKEFIELD' => 'Wakefield',
		'CAWILMOT' => 'Wilmot',
		'CACENTREVILLE' => 'Centreville',
		'CASIMONDS' => 'Simonds',
		'CAPEEL' => 'Peel',
		'CAABERDEEN' => 'Aberdeen',
		'CAFLORENCEVILLE-BRISTOL' => 'Florenceville-Bristol',
		'CAKENT' => 'Kent',
		'CABATH' => 'Bath',
		'CAWICKLOW' => 'Wicklow',
		'CAANDOVER' => 'Andover',
		'CAAROOSTOOK' => 'Aroostook',
		'CAPERTH' => 'Perth',
		'CAPERTH-ANDOVER' => 'Perth-Andover',
		'CATOBIQUE_20' => 'Tobique 20',
		'CAGORDON' => 'Gordon',
		'CAPLASTER_ROCK' => 'Plaster Rock',
		'CALORNE' => 'Lorne',
		'CADENMARK' => 'Denmark',
		'CAGRAND_FALLS' => 'Grand Falls',
		'CAGRAND_FALLS' => 'Grand Falls',
		'CADRUMMOND' => 'Drummond',
		'CADRUMMOND' => 'Drummond',
		'CASAINT-ANDR' => 'Saint-Andr',
		'CASAINT-ANDR' => 'Saint-Andr',
		'CASAINT-LONARD' => 'Saint-Lonard',
		'CASAINT-LONARD' => 'Saint-Lonard',
		'CANOTRE-DAME-DE-LOURDES' => 'Notre-Dame-de-Lourdes',
		'CASAINTE-ANNE' => 'Sainte-Anne',
		'CASAINTE-ANNE-DE-MADAWASKA' => 'Sainte-Anne-de-Madawaska',
		'CARIVIRE-VERTE' => 'Rivire-Verte',
		'CARIVIRE-VERTE' => 'Rivire-Verte',
		'CASAINT-BASILE' => 'Saint-Basile',
		'CAST._BASILE_10' => 'St. Basile 10',
		'CASAINT-JOSEPH' => 'Saint-Joseph',
		'CASAINT-JACQUES' => 'Saint-Jacques',
		'CAEDMUNDSTON' => 'Edmundston',
		'CAMADAWASKA' => 'Madawaska',
		'CASAINT-HILAIRE' => 'Saint-Hilaire',
		'CAST._HILAIRE' => 'St. Hilaire',
		'CABAKER_BROOK' => 'Baker Brook',
		'CABAKER-BROOK' => 'Baker-Brook',
		'CALAC-BAKER' => 'Lac-Baker',
		'CALAC_BAKER' => 'Lac Baker',
		'CACLAIR' => 'Clair',
		'CACLAIR' => 'Clair',
		'CASAINT-FRANOIS' => 'Saint-Franois',
		'CASAINT-FRANOIS_DE_MADAWASKA' => 'Saint-Franois de Madawaska',
		'CADURHAM' => 'Durham',
		'CACOLBORNE' => 'Colborne',
		'CACHARLO' => 'Charlo',
		'CABALMORAL' => 'Balmoral',
		'CABALMORAL' => 'Balmoral',
		'CADALHOUSIE' => 'Dalhousie',
		'CAEEL_RIVER_3' => 'Eel River 3',
		'CAEEL_RIVER_CROSSING' => 'Eel River Crossing',
		'CAADDINGTON' => 'Addington',
		'CAATHOLVILLE' => 'Atholville',
		'CACAMPBELLTON' => 'Campbellton',
		'CATIDE_HEAD' => 'Tide Head',
		'CAELDON' => 'Eldon',
		'CADALHOUSIE' => 'Dalhousie',
		'CAKEDGWICK' => 'Kedgwick',
		'CASAINT-QUENTIN' => 'Saint-Quentin',
		'CASAINT-QUENTIN' => 'Saint-Quentin',
		'CABELLEDUNE' => 'Belledune',
		'CAINDIAN_RANCH' => 'Indian Ranch',
		'CATRACADIE' => 'Tracadie',
		'CAALLARDVILLE' => 'Allardville',
		'CABATHURST' => 'Bathurst',
		'CAPABINEAU_11' => 'Pabineau 11',
		'CABATHURST' => 'Bathurst',
		'CABERESFORD' => 'Beresford',
		'CAPOINTE-VERTE' => 'Pointe-Verte',
		'CAPETIT-ROCHER' => 'Petit-Rocher',
		'CABERESFORD' => 'Beresford',
		'CANEW_BANDON' => 'New Bandon',
		'CASAINT-LOLIN' => 'Saint-Lolin',
		'CAPAQUETVILLE' => 'Paquetville',
		'CAPAQUETVILLE' => 'Paquetville',
		'CASAINT-ISIDORE' => 'Saint-Isidore',
		'CASAINT-ISIDORE' => 'Saint-Isidore',
		'CAINKERMAN' => 'Inkerman',
		'CACARAQUET' => 'Caraquet',
		'CABAS-CARAQUET' => 'Bas-Caraquet',
		'CACARAQUET' => 'Caraquet',
		'CASHIPPAGAN' => 'Shippagan',
		'CALE_GOULET' => 'Le Goulet',
		'CASHIPPAGAN' => 'Shippagan',
		'CALAMQUE' => 'Lamque',
		'CASAINTE-MARIE-SAINT-RAPHAL' => 'Sainte-Marie-Saint-Raphal',
		'CABERTRAND' => 'Bertrand',
		'CANIGADOO' => 'Nigadoo',
		'CAGRANDE-ANSE' => 'Grande-Anse',
		'CAMAISONNETTE' => 'Maisonnette',
	],
	'QC' => [
		'CALES_LES-DE-LA-MADELEINE' => 'Les les-de-la-Madeleine',
		'CAGROSSE-LE' => 'Grosse-le',
		'CAPERC' => 'Perc',
		'CASAINTE-THRSE-DE-GASP' => 'Sainte-Thrse-de-Gasp',
		'CAGRANDE-RIVIRE' => 'Grande-Rivire',
		'CACHANDLER' => 'Chandler',
		'CAPORT-DANIEL--GASCONS' => 'Port-Daniel--Gascons',
		'CAMONT-ALEXANDRE' => 'Mont-Alexandre',
		'CAGASP' => 'Gasp',
		'CACLORIDORME' => 'Cloridorme',
		'CAPETITE-VALLE' => 'Petite-Valle',
		'CAGRANDE-VALLE' => 'Grande-Valle',
		'CAMURDOCHVILLE' => 'Murdochville',
		'CARIVIRE-SAINT-JEAN' => 'Rivire-Saint-Jean',
		'CACOLLINES-DU-BASQUE' => 'Collines-du-Basque',
		'CASAINTE-MADELEINE-DE-LA-RIVIRE-MADEL' => 'Sainte-Madeleine-de-la-Rivire-Madeleine',
		'CASAINT-MAXIME-DU-MONT-LOUIS' => 'Saint-Maxime-du-Mont-Louis',
		'CAMONT-SAINT-PIERRE' => 'Mont-Saint-Pierre',
		'CARIVIRE--CLAUDE' => 'Rivire--Claude',
		'CAMARSOUI' => 'Marsoui',
		'CALA_MARTRE' => 'La Martre',
		'CASAINTE-ANNE-DES-MONTS' => 'Sainte-Anne-des-Monts',
		'CACAP-CHAT' => 'Cap-Chat',
		'CAMONT-ALBERT' => 'Mont-Albert',
		'CACOULE-DES-ADOLPHE' => 'Coule-des-Adolphe',
		'CASHIGAWAKE' => 'Shigawake',
		'CASAINT-GODEFROI' => 'Saint-Godefroi',
		'CAHOPE_TOWN' => 'Hope Town',
		'CAHOPE' => 'Hope',
		'CAPASPBIAC' => 'Paspbiac',
		'CANEW_CARLISLE' => 'New Carlisle',
		'CABONAVENTURE' => 'Bonaventure',
		'CASAINT-ELZAR' => 'Saint-Elzar',
		'CASAINT-SIMON' => 'Saint-Simon',
		'CACAPLAN' => 'Caplan',
		'CASAINT-ALPHONSE' => 'Saint-Alphonse',
		'CANEW_RICHMOND' => 'New Richmond',
		'CACASCAPDIA--SAINT-JULES' => 'Cascapdia--Saint-Jules',
		'CARIVIRE-BONAVENTURE' => 'Rivire-Bonaventure',
		'CAMARIA' => 'Maria',
		'CACARLETON-SUR-MER' => 'Carleton-sur-Mer',
		'CANOUVELLE' => 'Nouvelle',
		'CAESCUMINAC' => 'Escuminac',
		'CAPOINTE--LA-CROIX' => 'Pointe--la-Croix',
		'CARISTIGOUCHE-PARTIE-SUD-EST' => 'Ristigouche-Partie-Sud-Est',
		'CASAINT-ANDR-DE-RESTIGOUCHE' => 'Saint-Andr-de-Restigouche',
		'CAMATAPDIA' => 'Matapdia',
		'CASAINT-ALEXIS-DE-MATAPDIA' => 'Saint-Alexis-de-Matapdia',
		'CASAINT-FRANOIS-DASSISE' => 'Saint-Franois-dAssise',
		'CALASCENSION-DE-PATAPDIA' => 'LAscension-de-Patapdia',
		'CAGESGAPEGIAG' => 'Gesgapegiag',
		'CALISTUGUJ' => 'Listuguj',
		'CARIVIRE-NOUVELLE' => 'Rivire-Nouvelle',
		'CARUISSEAU-FERGUSON' => 'Ruisseau-Ferguson',
		'CASAINTE-MARGUERITE-MARIE' => 'Sainte-Marguerite-Marie',
		'CASAINTE-FLORENCE' => 'Sainte-Florence',
		'CACAUSAPSCAL' => 'Causapscal',
		'CAALBERTVILLE' => 'Albertville',
		'CASAINT-LON-LE-GRAND' => 'Saint-Lon-le-Grand',
		'CASAINT-ZNON-DU-LAC-HUMQUI' => 'Saint-Znon-du-Lac-Humqui',
		'CASAINTE-IRNE' => 'Sainte-Irne',
		'CAAMQUI' => 'Amqui',
		'CALAC-AU-SAUMON' => 'Lac-au-Saumon',
		'CASAINT-ALEXANDRE-DES-LACS' => 'Saint-Alexandre-des-Lacs',
		'CASAINT-THARCISIUS' => 'Saint-Tharcisius',
		'CASAINT-VIANNEY' => 'Saint-Vianney',
		'CAVAL-BRILLANT' => 'Val-Brillant',
		'CASAYABEC' => 'Sayabec',
		'CASAINT-CLOPHAS' => 'Saint-Clophas',
		'CASAINT-MOSE' => 'Saint-Mose',
		'CASAINT-NOL' => 'Saint-Nol',
		'CASAINT-DAMASE' => 'Saint-Damase',
		'CAROUTHIERVILLE' => 'Routhierville',
		'CARIVIRE-VASEUSE' => 'Rivire-Vaseuse',
		'CARIVIRE-PATAPDIA-EST' => 'Rivire-Patapdia-Est',
		'CALAC-CASAULT' => 'Lac-Casault',
		'CARUISSEAU-DES-MINEURS' => 'Ruisseau-des-Mineurs',
		'CALAC-ALFRED' => 'Lac-Alfred',
		'CALAC-MATAPDIA' => 'Lac-Matapdia',
		'CALES_MCHINS' => 'Les Mchins',
		'CASAINT-JEAN-DE-CHERBOURG' => 'Saint-Jean-de-Cherbourg',
		'CAGROSSES-ROCHES' => 'Grosses-Roches',
		'CASAINTE-FLICIT' => 'Sainte-Flicit',
		'CASAINT-ADELME' => 'Saint-Adelme',
		'CASAINT-REN-DE-MATANE' => 'Saint-Ren-de-Matane',
		'CASAINTE-PAULE' => 'Sainte-Paule',
		'CAMATANE' => 'Matane',
		'CASAINT-LANDRE' => 'Saint-Landre',
		'CASAINT-ULRIC' => 'Saint-Ulric',
		'CABAIE-DES-SABLES' => 'Baie-des-Sables',
		'CARIVIRE-BONJOUR' => 'Rivire-Bonjour',
		'CALA_RDEMPTION' => 'La Rdemption',
		'CASAINT-CHARLES-GARNIER' => 'Saint-Charles-Garnier',
		'CALES_HAUTEURS' => 'Les Hauteurs',
		'CASAINTE-JEANNE-DARC' => 'Sainte-Jeanne-dArc',
		'CASAINT-GABRIEL-DE-RIMOUSKI' => 'Saint-Gabriel-de-Rimouski',
		'CASAINT-DONAT' => 'Saint-Donat',
		'CASAINTE-ANGLE-DE-MRICI' => 'Sainte-Angle-de-Mrici',
		'CAPADOUE' => 'Padoue',
		'CAMTIS-SUR-MER' => 'Mtis-sur-Mer',
		'CASAINT-OCTAVE-DE-MTIS' => 'Saint-Octave-de-Mtis',
		'CAGRAND-MTIS' => 'Grand-Mtis',
		'CAPRICE' => 'Price',
		'CASAINT-JOSEPH-DE-LEPAGE' => 'Saint-Joseph-de-Lepage',
		'CAMONT-JOLI' => 'Mont-Joli',
		'CASAINTE-FLAVIE' => 'Sainte-Flavie',
		'CASAINTE-LUCE' => 'Sainte-Luce',
		'CALAC-DES-EAUX-MORTES' => 'Lac-des-Eaux-Mortes',
		'CALAC--LA-CROIX' => 'Lac--la-Croix',
		'CAESPRIT-SAINT' => 'Esprit-Saint',
		'CALA_TRINIT-DES-MONTS' => 'La Trinit-des-Monts',
		'CASAINT-NARCISSE-DE-RIMOUSKI' => 'Saint-Narcisse-de-Rimouski',
		'CASAINT-MARCELLIN' => 'Saint-Marcellin',
		'CASAINT-ANACLET-DE-LESSARD' => 'Saint-Anaclet-de-Lessard',
		'CARIMOUSKI' => 'Rimouski',
		'CASAINT-VALRIEN' => 'Saint-Valrien',
		'CASAINT-FABIEN' => 'Saint-Fabien',
		'CASAINT-EUGNE-DE-LADRIRE' => 'Saint-Eugne-de-Ladrire',
		'CALAC-HURON' => 'Lac-Huron',
		'CASAINT-CLMENT' => 'Saint-Clment',
		'CASAINT-JEAN-DE-DIEU' => 'Saint-Jean-de-Dieu',
		'CASAINTE-RITA' => 'Sainte-Rita',
		'CASAINT-GUY' => 'Saint-Guy',
		'CASAINT-MDARD' => 'Saint-Mdard',
		'CASAINTE-FRANOISE' => 'Sainte-Franoise',
		'CASAINT-LOI' => 'Saint-loi',
		'CATROIS-PISTOLES' => 'Trois-Pistoles',
		'CANOTRE-DAME-DES-NEIGES' => 'Notre-Dame-des-Neiges',
		'CASAINT-MATHIEU-DE-RIOUX' => 'Saint-Mathieu-de-Rioux',
		'CASAINT-SIMON' => 'Saint-Simon',
		'CALAC-BOISBOUSCACHE' => 'Lac-Boisbouscache',
		'CASAINT-CYPRIEN' => 'Saint-Cyprien',
		'CASAINT-HUBERT-DE-RIVIRE-DU-LOUP' => 'Saint-Hubert-de-Rivire-du-Loup',
		'CASAINT-ANTONIN' => 'Saint-Antonin',
		'CASAINT-MODESTE' => 'Saint-Modeste',
		'CASAINT-FRANOIS-XAVIER-DE-VIGER' => 'Saint-Franois-Xavier-de-Viger',
		'CASAINT-PIPHANE' => 'Saint-piphane',
		'CASAINT-PAUL-DE-LA-CROIX' => 'Saint-Paul-de-la-Croix',
		'CALISLE-VERTE' => 'LIsle-Verte',
		'CANOTRE-DAME-DES-SEPT-DOULEURS' => 'Notre-Dame-des-Sept-Douleurs',
		'CACACOUNA' => 'Cacouna',
		'CASAINT-ARSNE' => 'Saint-Arsne',
		'CARIVIRE-DU-LOUP' => 'Rivire-du-Loup',
		'CANOTRE-DAME-DU-PORTAGE' => 'Notre-Dame-du-Portage',
		'CADGELIS' => 'Dgelis',
		'CASAINT-JEAN-DE-LA-LANDE' => 'Saint-Jean-de-la-Lande',
		'CAPACKINGTON' => 'Packington',
		'CASAINT-MARC-DU-LAC-LONG' => 'Saint-Marc-du-Lac-Long',
		'CARIVIRE-BLEUE' => 'Rivire-Bleue',
		'CASAINT-EUSBE' => 'Saint-Eusbe',
		'CASAINT-JUSTE-DU-LAC' => 'Saint-Juste-du-Lac',
		'CAAUCLAIR' => 'Auclair',
		'CALEJEUNE' => 'Lejeune',
		'CABIENCOURT' => 'Biencourt',
		'CALAC-DES-AIGLES' => 'Lac-des-Aigles',
		'CASAINT-MICHEL-DU-SQUATEC' => 'Saint-Michel-du-Squatec',
		'CATMISCOUATA-SUR-LE-LAC' => 'Tmiscouata-sur-le-Lac',
		'CASAINT-PIERRE-DE-LAMY' => 'Saint-Pierre-de-Lamy',
		'CASAINT-LOUIS-DU-HA!_HA!' => 'Saint-Louis-du-Ha! Ha!',
		'CASAINT-ELZAR-DE-TMISCOUATA' => 'Saint-Elzar-de-Tmiscouata',
		'CASAINT-HONOR-DE-TMISCOUATA' => 'Saint-Honor-de-Tmiscouata',
		'CAPOHNGAMOOK' => 'Pohngamook',
		'CASAINT-ATHANASE' => 'Saint-Athanase',
		'CAMONT-CARMEL' => 'Mont-Carmel',
		'CASAINT-BRUNO-DE-KAMOURASKA' => 'Saint-Bruno-de-Kamouraska',
		'CASAINT-PASCAL' => 'Saint-Pascal',
		'CASAINTE-HLNE-DE-KAMOURASKA' => 'Sainte-Hlne-de-Kamouraska',
		'CASAINT-JOSEPH-DE-KAMOURASKA' => 'Saint-Joseph-de-Kamouraska',
		'CASAINT-ALEXANDRE-DE-KAMOURASKA' => 'Saint-Alexandre-de-Kamouraska',
		'CASAINT-ANDR' => 'Saint-Andr',
		'CASAINT-GERMAIN' => 'Saint-Germain',
		'CAKAMOURASKA' => 'Kamouraska',
		'CASAINT-DENIS-DE_LA_BOUTEILLERIE' => 'Saint-Denis-De La Bouteillerie',
		'CASAINT-PHILIPPE-DE-NRI' => 'Saint-Philippe-de-Nri',
		'CARIVIRE-OUELLE' => 'Rivire-Ouelle',
		'CASAINT-PACME' => 'Saint-Pacme',
		'CASAINT-GABRIEL-LALEMANT' => 'Saint-Gabriel-Lalemant',
		'CASAINT-ONSIME-DIXWORTH' => 'Saint-Onsime-dIxworth',
		'CALA_POCATIRE' => 'La Pocatire',
		'CASAINTE-ANNE-DE-LA-POCATIRE' => 'Sainte-Anne-de-la-Pocatire',
		'CAPICARD' => 'Picard',
		'CAPETIT-LAC-SAINTE-ANNE' => 'Petit-Lac-Sainte-Anne',
		'CASAINT-IRNE' => 'Saint-Irne',
		'CALA_MALBAIE' => 'La Malbaie',
		'CANOTRE-DAME-DES-MONTS' => 'Notre-Dame-des-Monts',
		'CASAINT-AIM-DES-LACS' => 'Saint-Aim-des-Lacs',
		'CACLERMONT' => 'Clermont',
		'CASAINT-SIMON' => 'Saint-Simon',
		'CABAIE-SAINTE-CATHERINE' => 'Baie-Sainte-Catherine',
		'CAMONT-LIE' => 'Mont-lie',
		'CASAGARD' => 'Sagard',
		'CAPETITE-RIVIRE-SAINT-FRANOIS' => 'Petite-Rivire-Saint-Franois',
		'CABAIE-SAINT-PAUL' => 'Baie-Saint-Paul',
		'CALISLE-AUX-COUDRES' => 'LIsle-aux-Coudres',
		'CALES_BOULEMENTS' => 'Les boulements',
		'CASAINT-HILARION' => 'Saint-Hilarion',
		'CASAINT-URBAIN' => 'Saint-Urbain',
		'CALAC-PIKAUBA' => 'Lac-Pikauba',
		'CASAINT-OMER' => 'Saint-Omer',
		'CASAINT-PAMPHILE' => 'Saint-Pamphile',
		'CASAINT-ADALBERT' => 'Saint-Adalbert',
		'CASAINT-MARCEL' => 'Saint-Marcel',
		'CASAINTE-FLICIT' => 'Sainte-Flicit',
		'CASAINTE-PERPTUE' => 'Sainte-Perptue',
		'CATOURVILLE' => 'Tourville',
		'CASAINT-DAMASE-DE-LISLET' => 'Saint-Damase-de-LIslet',
		'CASAINT-CYRILLE-DE-LESSARD' => 'Saint-Cyrille-de-Lessard',
		'CASAINT-AUBERT' => 'Saint-Aubert',
		'CASAINTE-LOUISE' => 'Sainte-Louise',
		'CASAINT-ROCH-DES-AULNAIES' => 'Saint-Roch-des-Aulnaies',
		'CASAINT-JEAN-PORT-JOLI' => 'Saint-Jean-Port-Joli',
		'CALISLET' => 'LIslet',
		'CASAINT-JUST-DE-BRETENIRES' => 'Saint-Just-de-Bretenires',
		'CALAC-FRONTIRE' => 'Lac-Frontire',
		'CASAINT-FABIEN-DE-PANET' => 'Saint-Fabien-de-Panet',
		'CASAINTE-LUCIE-DE-BEAUREGARD' => 'Sainte-Lucie-de-Beauregard',
		'CASAINTE-APOLLINE-DE-PATTON' => 'Sainte-Apolline-de-Patton',
		'CASAINT-PAUL-DE-MONTMINY' => 'Saint-Paul-de-Montminy',
		'CASAINTE-EUPHMIE-SUR-RIVIRE-DU-SUD' => 'Sainte-Euphmie-sur-Rivire-du-Sud',
		'CANOTRE-DAME-DU-ROSAIRE' => 'Notre-Dame-du-Rosaire',
		'CACAP-SAINT-IGNACE' => 'Cap-Saint-Ignace',
		'CAMONTMAGNY' => 'Montmagny',
		'CASAINT-PIERRE-DE-LA-RIVIRE-DU-SUD' => 'Saint-Pierre-de-la-Rivire-du-Sud',
		'CASAINT-FRANOIS-DE-LA-RIVIRE-DU-SUD' => 'Saint-Franois-de-la-Rivire-du-Sud',
		'CABERTHIER-SUR-MER' => 'Berthier-sur-Mer',
		'CASAINT-ANTOINE-DE-LISLE-AUX-GRUES' => 'Saint-Antoine-de-lIsle-aux-Grues',
		'CASAINT-PHILMON' => 'Saint-Philmon',
		'CANOTRE-DAME-AUXILIATRICE-DE-BUCKLAND' => 'Notre-Dame-Auxiliatrice-de-Buckland',
		'CASAINT-NAZAIRE-DE-DORCHESTER' => 'Saint-Nazaire-de-Dorchester',
		'CASAINT-LON-DE-STANDON' => 'Saint-Lon-de-Standon',
		'CASAINT-MALACHIE' => 'Saint-Malachie',
		'CASAINT-DAMIEN-DE-BUCKLAND' => 'Saint-Damien-de-Buckland',
		'CAARMAGH' => 'Armagh',
		'CASAINT-NRE-DE-BELLECHASSE' => 'Saint-Nre-de-Bellechasse',
		'CASAINT-LAZARE-DE-BELLECHASSE' => 'Saint-Lazare-de-Bellechasse',
		'CASAINTE-CLAIRE' => 'Sainte-Claire',
		'CASAINT-ANSELME' => 'Saint-Anselme',
		'CASAINT-HENRI' => 'Saint-Henri',
		'CAHONFLEUR' => 'Honfleur',
		'CASAINT-GERVAIS' => 'Saint-Gervais',
		'CASAINT-RAPHAL' => 'Saint-Raphal',
		'CALA_DURANTAYE' => 'La Durantaye',
		'CASAINT-CHARLES-DE-BELLECHASSE' => 'Saint-Charles-de-Bellechasse',
		'CABEAUMONT' => 'Beaumont',
		'CASAINT-MICHEL-DE-BELLECHASSE' => 'Saint-Michel-de-Bellechasse',
		'CASAINT-VALLIER' => 'Saint-Vallier',
		'CASAINT-FRANOIS-DE-LLE-DORLANS' => 'Saint-Franois-de-lle-dOrlans',
		'CASAINTE-FAMILLE' => 'Sainte-Famille',
		'CASAINT-JEAN-DE-LLE-DORLANS' => 'Saint-Jean-de-lle-dOrlans',
		'CASAINT-LAURENT-DE-LLE-DORLANS' => 'Saint-Laurent-de-lle-dOrlans',
		'CASAINT-PIERRE-DE-LLE-DORLANS' => 'Saint-Pierre-de-lle-dOrlans',
		'CASAINTE-PTRONILLE' => 'Sainte-Ptronille',
		'CASAINT-TITE-DES-CAPS' => 'Saint-Tite-des-Caps',
		'CASAINT-FERROL-LES-NEIGES' => 'Saint-Ferrol-les-Neiges',
		'CASAINT-LOUIS-DE-GONZAGUE-DU-CAP-TOURM' => 'Saint-Louis-de-Gonzague-du-Cap-Tourmente',
		'CASAINT-JOACHIM' => 'Saint-Joachim',
		'CABEAUPR' => 'Beaupr',
		'CASAINTE-ANNE-DE-BEAUPR' => 'Sainte-Anne-de-Beaupr',
		'CACHTEAU-RICHER' => 'Chteau-Richer',
		'CALANGE-GARDIEN' => 'LAnge-Gardien',
		'CABOISCHATEL' => 'Boischatel',
		'CASAULT-AU-COCHON' => 'Sault-au-Cochon',
		'CALAC-JACQUES-CARTIER' => 'Lac-Jacques-Cartier',
		'CASAINTE-CATHERINE-DE-LA-JACQUES-CARTI' => 'Sainte-Catherine-de-la-Jacques-Cartier',
		'CAFOSSAMBAULT-SUR-LE-LAC' => 'Fossambault-sur-le-Lac',
		'CALAC-SAINT-JOSEPH' => 'Lac-Saint-Joseph',
		'CASHANNON' => 'Shannon',
		'CASAINT-GABRIEL-DE-VALCARTIER' => 'Saint-Gabriel-de-Valcartier',
		'CALAC-DELAGE' => 'Lac-Delage',
		'CASTONEHAM-ET-TEWKESBURY' => 'Stoneham-et-Tewkesbury',
		'CALAC-BEAUPORT' => 'Lac-Beauport',
		'CASAINTE-BRIGITTE-DE-LAVAL' => 'Sainte-Brigitte-de-Laval',
		'CALAC-CROCHE' => 'Lac-Croche',
		'CANOTRE-DAME-DES-ANGES' => 'Notre-Dame-des-Anges',
		'CAQUBEC' => 'Qubec',
		'CALANCIENNE-LORETTE' => 'LAncienne-Lorette',
		'CASAINT-AUGUSTIN-DE-DESMAURES' => 'Saint-Augustin-de-Desmaures',
		'CAWENDAKE' => 'Wendake',
		'CALVIS' => 'Lvis',
		'CAFRAMPTON' => 'Frampton',
		'CASAINTS-ANGES' => 'Saints-Anges',
		'CAVALLE-JONCTION' => 'Valle-Jonction',
		'CASAINT-ELZAR' => 'Saint-Elzar',
		'CASAINTE-MARIE' => 'Sainte-Marie',
		'CASAINTE-MARGUERITE' => 'Sainte-Marguerite',
		'CASAINTE-HNDINE' => 'Sainte-Hndine',
		'CASCOTT' => 'Scott',
		'CASAINT-BERNARD' => 'Saint-Bernard',
		'CASAINT-ISIDORE' => 'Saint-Isidore',
		'CASAINT-LAMBERT-DE-LAUZON' => 'Saint-Lambert-de-Lauzon',
		'CASAINT-VICTOR' => 'Saint-Victor',
		'CASAINT-ALFRED' => 'Saint-Alfred',
		'CABEAUCEVILLE' => 'Beauceville',
		'CASAINT-ODILON-DE-CRANBOURNE' => 'Saint-Odilon-de-Cranbourne',
		'CASAINT-JOSEPH-DE-BEAUCE' => 'Saint-Joseph-de-Beauce',
		'CASAINT-JOSEPH-DES-RABLES' => 'Saint-Joseph-des-rables',
		'CASAINT-JULES' => 'Saint-Jules',
		'CATRING-JONCTION' => 'Tring-Jonction',
		'CASAINT-FRDRIC' => 'Saint-Frdric',
		'CASAINT-SVERIN' => 'Saint-Sverin',
		'CASAINT-ZACHARIE' => 'Saint-Zacharie',
		'CASAINTE-AURLIE' => 'Sainte-Aurlie',
		'CASAINT-PROSPER' => 'Saint-Prosper',
		'CASAINT-BENJAMIN' => 'Saint-Benjamin',
		'CASAINTE-ROSE-DE-WATFORD' => 'Sainte-Rose-de-Watford',
		'CASAINT-LOUIS-DE-GONZAGUE' => 'Saint-Louis-de-Gonzague',
		'CASAINT-CYPRIEN' => 'Saint-Cyprien',
		'CASAINTE-JUSTINE' => 'Sainte-Justine',
		'CALAC-ETCHEMIN' => 'Lac-Etchemin',
		'CASAINT-LUC-DE-BELLECHASSE' => 'Saint-Luc-de-Bellechasse',
		'CASAINTE-SABINE' => 'Sainte-Sabine',
		'CASAINT-CAMILLE-DE-LELLIS' => 'Saint-Camille-de-Lellis',
		'CASAINT-MAGLOIRE' => 'Saint-Magloire',
		'CASAINT-THOPHILE' => 'Saint-Thophile',
		'CASAINT-GDON-DE-BEAUCE' => 'Saint-Gdon-de-Beauce',
		'CASAINT-HILAIRE-DE-DORSET' => 'Saint-Hilaire-de-Dorset',
		'CASAINT-VARISTE-DE-FORSYTH' => 'Saint-variste-de-Forsyth',
		'CALA_GUADELOUPE' => 'La Guadeloupe',
		'CASAINT-HONOR-DE-SHENLEY' => 'Saint-Honor-de-Shenley',
		'CASAINT-MARTIN' => 'Saint-Martin',
		'CASAINT-REN' => 'Saint-Ren',
		'CASAINT-CME--LINIRE' => 'Saint-Cme--Linire',
		'CASAINT-PHILIBERT' => 'Saint-Philibert',
		'CASAINT-GEORGES' => 'Saint-Georges',
		'CALAC-POULIN' => 'Lac-Poulin',
		'CASAINT-BENOT-LABRE' => 'Saint-Benot-Labre',
		'CASAINT-PHREM-DE-BEAUCE' => 'Saint-phrem-de-Beauce',
		'CANOTRE-DAME-DES-PINS' => 'Notre-Dame-des-Pins',
		'CASAINT-SIMON-LES-MINES' => 'Saint-Simon-les-Mines',
		'CASAINT-AUGUSTIN-DE-WOBURN' => 'Saint-Augustin-de-Woburn',
		'CANOTRE-DAME-DES-BOIS' => 'Notre-Dame-des-Bois',
		'CAVAL-RACINE' => 'Val-Racine',
		'CAPIOPOLIS' => 'Piopolis',
		'CAFRONTENAC' => 'Frontenac',
		'CALAC-MGANTIC' => 'Lac-Mgantic',
		'CAMARSTON' => 'Marston',
		'CAMILAN' => 'Milan',
		'CANANTES' => 'Nantes',
		'CASAINTE-CCILE-DE-WHITTON' => 'Sainte-Ccile-de-Whitton',
		'CAAUDET' => 'Audet',
		'CASAINT-ROBERT-BELLARMIN' => 'Saint-Robert-Bellarmin',
		'CASAINT-LUDGER' => 'Saint-Ludger',
		'CALAC-DROLET' => 'Lac-Drolet',
		'CASAINT-SBASTIEN' => 'Saint-Sbastien',
		'CACOURCELLES' => 'Courcelles',
		'CALAMBTON' => 'Lambton',
		'CASAINT-ROMAIN' => 'Saint-Romain',
		'CASTORNOWAY' => 'Stornoway',
		'CASTRATFORD' => 'Stratford',
		'CABEAULAC-GARTHBY' => 'Beaulac-Garthby',
		'CADISRAELI' => 'Disraeli',
		'CADISRAELI' => 'Disraeli',
		'CASAINT-JACQUES-LE-MAJEUR-DE-WOLFESTOW' => 'Saint-Jacques-le-Majeur-de-Wolfestown',
		'CASAINT-FORTUNAT' => 'Saint-Fortunat',
		'CASAINT-JULIEN' => 'Saint-Julien',
		'CAIRLANDE' => 'Irlande',
		'CASAINT-JOSEPH-DE-COLERAINE' => 'Saint-Joseph-de-Coleraine',
		'CASAINTE-PRAXDE' => 'Sainte-Praxde',
		'CAADSTOCK' => 'Adstock',
		'CASAINTE-CLOTILDE-DE-BEAUCE' => 'Sainte-Clotilde-de-Beauce',
		'CATHETFORD_MINES' => 'Thetford Mines',
		'CASAINT-ADRIEN-DIRLANDE' => 'Saint-Adrien-dIrlande',
		'CASAINT-JEAN-DE-BRBEUF' => 'Saint-Jean-de-Brbeuf',
		'CAKINNEARS_MILLS' => 'Kinnears Mills',
		'CAEAST_BROUGHTON' => 'East Broughton',
		'CASACR-COEUR-DE-JSUS' => 'Sacr-Coeur-de-Jsus',
		'CASAINT-PIERRE-DE-BROUGHTON' => 'Saint-Pierre-de-Broughton',
		'CASAINT-JACQUES-DE-LEEDS' => 'Saint-Jacques-de-Leeds',
		'CASAINT-FERDINAND' => 'Saint-Ferdinand',
		'CASAINTE-SOPHIE-DHALIFAX' => 'Sainte-Sophie-dHalifax',
		'CAPRINCEVILLE' => 'Princeville',
		'CAPLESSISVILLE' => 'Plessisville',
		'CAPLESSISVILLE' => 'Plessisville',
		'CASAINT-PIERRE-BAPTISTE' => 'Saint-Pierre-Baptiste',
		'CAINVERNESS' => 'Inverness',
		'CALYSTER' => 'Lyster',
		'CALAURIERVILLE' => 'Laurierville',
		'CANOTRE-DAME-DE-LOURDES' => 'Notre-Dame-de-Lourdes',
		'CAVILLEROY' => 'Villeroy',
		'CASAINT-SYLVESTRE' => 'Saint-Sylvestre',
		'CASAINTE-AGATHE-DE-LOTBINIRE' => 'Sainte-Agathe-de-Lotbinire',
		'CASAINT-PATRICE-DE-BEAURIVAGE' => 'Saint-Patrice-de-Beaurivage',
		'CASAINT-NARCISSE-DE-BEAURIVAGE' => 'Saint-Narcisse-de-Beaurivage',
		'CASAINT-GILLES' => 'Saint-Gilles',
		'CADOSQUET' => 'Dosquet',
		'CASAINT-AGAPIT' => 'Saint-Agapit',
		'CASAINT-FLAVIEN' => 'Saint-Flavien',
		'CALAURIER-STATION' => 'Laurier-Station',
		'CASAINT-JANVIER-DE-JOLY' => 'Saint-Janvier-de-Joly',
		'CAVAL-ALAIN' => 'Val-Alain',
		'CASAINT-DOUARD-DE-LOTBINIRE' => 'Saint-douard-de-Lotbinire',
		'CANOTRE-DAME-DU-SACR-COEUR-DISSOUDUN' => 'Notre-Dame-du-Sacr-Coeur-dIssoudun',
		'CASAINT-APOLLINAIRE' => 'Saint-Apollinaire',
		'CASAINT-ANTOINE-DE-TILLY' => 'Saint-Antoine-de-Tilly',
		'CASAINTE-CROIX' => 'Sainte-Croix',
		'CALOTBINIRE' => 'Lotbinire',
		'CALECLERCVILLE' => 'Leclercville',
		'CANEUVILLE' => 'Neuville',
		'CAPONT-ROUGE' => 'Pont-Rouge',
		'CADONNACONA' => 'Donnacona',
		'CACAP-SANT' => 'Cap-Sant',
		'CASAINT-BASILE' => 'Saint-Basile',
		'CAPORTNEUF' => 'Portneuf',
		'CADESCHAMBAULT-GRONDINES' => 'Deschambault-Grondines',
		'CASAINT-GILBERT' => 'Saint-Gilbert',
		'CASAINT-MARC-DES-CARRIRES' => 'Saint-Marc-des-Carrires',
		'CASAINT-CASIMIR' => 'Saint-Casimir',
		'CASAINT-THURIBE' => 'Saint-Thuribe',
		'CASAINT-UBALDE' => 'Saint-Ubalde',
		'CASAINT-ALBAN' => 'Saint-Alban',
		'CASAINTE-CHRISTINE-DAUVERGNE' => 'Sainte-Christine-dAuvergne',
		'CASAINT-LONARD-DE-PORTNEUF' => 'Saint-Lonard-de-Portneuf',
		'CALAC-SERGENT' => 'Lac-Sergent',
		'CASAINT-RAYMOND' => 'Saint-Raymond',
		'CARIVIRE--PIERRE' => 'Rivire--Pierre',
		'CALAC-BLANC' => 'Lac-Blanc',
		'CALINTON' => 'Linton',
		'CALAC-LAPEYRRE' => 'Lac-Lapeyrre',
		'CANOTRE-DAME-DE-MONTAUBAN' => 'Notre-Dame-de-Montauban',
		'CALAC-AUX-SABLES' => 'Lac-aux-Sables',
		'CASAINT-ADELPHE' => 'Saint-Adelphe',
		'CASAINT-SVERIN' => 'Saint-Sverin',
		'CASAINT-TITE' => 'Saint-Tite',
		'CAHROUXVILLE' => 'Hrouxville',
		'CAGRANDES-PILES' => 'Grandes-Piles',
		'CASAINT-ROCH-DE-MKINAC' => 'Saint-Roch-de-Mkinac',
		'CASAINTE-THCLE' => 'Sainte-Thcle',
		'CATROIS-RIVES' => 'Trois-Rives',
		'CALAC-MASKETSI' => 'Lac-Masketsi',
		'CALAC-NORMAND' => 'Lac-Normand',
		'CARIVIRE-DE-LA-SAVANE' => 'Rivire-de-la-Savane',
		'CALAC-BOUL' => 'Lac-Boul',
		'CASHAWINIGAN' => 'Shawinigan',
		'CATROIS-RIVIRES' => 'Trois-Rivires',
		'CASAINTE-ANNE-DE-LA-PRADE' => 'Sainte-Anne-de-la-Prade',
		'CABATISCAN' => 'Batiscan',
		'CASAINTE-GENEVIVE-DE-BATISCAN' => 'Sainte-Genevive-de-Batiscan',
		'CACHAMPLAIN' => 'Champlain',
		'CASAINT-LUC-DE-VINCENNES' => 'Saint-Luc-de-Vincennes',
		'CASAINT-MAURICE' => 'Saint-Maurice',
		'CANOTRE-DAME-DU-MONT-CARMEL' => 'Notre-Dame-du-Mont-Carmel',
		'CASAINT-NARCISSE' => 'Saint-Narcisse',
		'CASAINT-STANISLAS' => 'Saint-Stanislas',
		'CASAINT-PROSPER-DE-CHAMPLAIN' => 'Saint-Prosper-de-Champlain',
		'CASAINT-SYLVRE' => 'Saint-Sylvre',
		'CABCANCOUR' => 'Bcancour',
		'CASAINTE-MARIE-DE-BLANDFORD' => 'Sainte-Marie-de-Blandford',
		'CALEMIEUX' => 'Lemieux',
		'CAMANSEAU' => 'Manseau',
		'CASAINTE-FRANOISE' => 'Sainte-Franoise',
		'CASAINTE-SOPHIE-DE-LVRARD' => 'Sainte-Sophie-de-Lvrard',
		'CAFORTIERVILLE' => 'Fortierville',
		'CAPARISVILLE' => 'Parisville',
		'CASAINTE-CCILE-DE-LVRARD' => 'Sainte-Ccile-de-Lvrard',
		'CASAINT-PIERRE-LES-BECQUETS' => 'Saint-Pierre-les-Becquets',
		'CADESCHAILLONS-SUR-SAINT-LAURENT' => 'Deschaillons-sur-Saint-Laurent',
		'CAWLINAK' => 'Wlinak',
		'CASAINTS-MARTYRS-CANADIENS' => 'Saints-Martyrs-Canadiens',
		'CAHAM-NORD' => 'Ham-Nord',
		'CANOTRE-DAME-DE-HAM' => 'Notre-Dame-de-Ham',
		'CASAINT-RMI-DE-TINGWICK' => 'Saint-Rmi-de-Tingwick',
		'CATINGWICK' => 'Tingwick',
		'CACHESTERVILLE' => 'Chesterville',
		'CASAINTE-HLNE-DE-CHESTER' => 'Sainte-Hlne-de-Chester',
		'CASAINT-NORBERT-DARTHABASKA' => 'Saint-Norbert-dArthabaska',
		'CASAINT-CHRISTOPHE-DARTHABASKA' => 'Saint-Christophe-dArthabaska',
		'CAVICTORIAVILLE' => 'Victoriaville',
		'CAWARWICK' => 'Warwick',
		'CASAINT-ALBERT' => 'Saint-Albert',
		'CASAINTE-LIZABETH-DE-WARWICK' => 'Sainte-lizabeth-de-Warwick',
		'CAKINGSEY_FALLS' => 'Kingsey Falls',
		'CASAINTE-SRAPHINE' => 'Sainte-Sraphine',
		'CASAINTE-CLOTILDE-DE-HORTON' => 'Sainte-Clotilde-de-Horton',
		'CASAINT-SAMUEL' => 'Saint-Samuel',
		'CASAINT-VALRE' => 'Saint-Valre',
		'CASAINT-ROSAIRE' => 'Saint-Rosaire',
		'CASAINTE-ANNE-DU-SAULT' => 'Sainte-Anne-du-Sault',
		'CADAVELUYVILLE' => 'Daveluyville',
		'CAMADDINGTON_FALLS' => 'Maddington Falls',
		'CASAINT-LOUIS-DE-BLANDFORD' => 'Saint-Louis-de-Blandford',
		'CAHAM-SUD' => 'Ham-Sud',
		'CASAINT-ADRIEN' => 'Saint-Adrien',
		'CAWOTTON' => 'Wotton',
		'CASAINT-CAMILLE' => 'Saint-Camille',
		'CASAINT-GEORGES-DE-WINDSOR' => 'Saint-Georges-de-Windsor',
		'CAASBESTOS' => 'Asbestos',
		'CADANVILLE' => 'Danville',
		'CASAINT-ISIDORE-DE-CLIFTON' => 'Saint-Isidore-de-Clifton',
		'CACHARTIERVILLE' => 'Chartierville',
		'CALA_PATRIE' => 'La Patrie',
		'CANEWPORT' => 'Newport',
		'CACOOKSHIRE-EATON' => 'Cookshire-Eaton',
		'CAASCOT_CORNER' => 'Ascot Corner',
		'CAEAST_ANGUS' => 'East Angus',
		'CAWESTBURY' => 'Westbury',
		'CABURY' => 'Bury',
		'CAHAMPDEN' => 'Hampden',
		'CASCOTSTOWN' => 'Scotstown',
		'CALINGWICK' => 'Lingwick',
		'CAWEEDON' => 'Weedon',
		'CADUDSWELL' => 'Dudswell',
		'CASTOKE' => 'Stoke',
		'CASAINT-FRANOIS-XAVIER-DE-BROMPTON' => 'Saint-Franois-Xavier-de-Brompton',
		'CASAINT-DENIS-DE-BROMPTON' => 'Saint-Denis-de-Brompton',
		'CARACINE' => 'Racine',
		'CABONSECOURS' => 'Bonsecours',
		'CALAWRENCEVILLE' => 'Lawrenceville',
		'CASAINTE-ANNE-DE-LA-ROCHELLE' => 'Sainte-Anne-de-la-Rochelle',
		'CAVALCOURT' => 'Valcourt',
		'CAVALCOURT' => 'Valcourt',
		'CAMARICOURT' => 'Maricourt',
		'CAKINGSBURY' => 'Kingsbury',
		'CAMELBOURNE' => 'Melbourne',
		'CAULVERTON' => 'Ulverton',
		'CAWINDSOR' => 'Windsor',
		'CAVAL-JOLI' => 'Val-Joli',
		'CARICHMOND' => 'Richmond',
		'CASAINT-CLAUDE' => 'Saint-Claude',
		'CACLEVELAND' => 'Cleveland',
		'CASHERBROOKE' => 'Sherbrooke',
		'CASAINT-MALO' => 'Saint-Malo',
		'CASAINT-VENANT-DE-PAQUETTE' => 'Saint-Venant-de-Paquette',
		'CAEAST_HEREFORD' => 'East Hereford',
		'CASAINT-HERMNGILDE' => 'Saint-Hermngilde',
		'CADIXVILLE' => 'Dixville',
		'CACOATICOOK' => 'Coaticook',
		'CABARNSTON-OUEST' => 'Barnston-Ouest',
		'CASTANSTEAD-EST' => 'Stanstead-Est',
		'CASAINTE-EDWIDGE-DE-CLIFTON' => 'Sainte-Edwidge-de-Clifton',
		'CAMARTINVILLE' => 'Martinville',
		'CACOMPTON' => 'Compton',
		'CAWATERVILLE' => 'Waterville',
		'CASTANSTEAD' => 'Stanstead',
		'CAOGDEN' => 'Ogden',
		'CASTANSTEAD' => 'Stanstead',
		'CAPOTTON' => 'Potton',
		'CAAYERS_CLIFF' => 'Ayers Cliff',
		'CAHATLEY' => 'Hatley',
		'CANORTH_HATLEY' => 'North Hatley',
		'CAHATLEY' => 'Hatley',
		'CASAINTE-CATHERINE-DE-HATLEY' => 'Sainte-Catherine-de-Hatley',
		'CAMAGOG' => 'Magog',
		'CASAINT-BENOT-DU-LAC' => 'Saint-Benot-du-Lac',
		'CAAUSTIN' => 'Austin',
		'CAEASTMAN' => 'Eastman',
		'CABOLTON-EST' => 'Bolton-Est',
		'CASAINT-TIENNE-DE-BOLTON' => 'Saint-tienne-de-Bolton',
		'CASTUKELY-SUD' => 'Stukely-Sud',
		'CAORFORD' => 'Orford',
		'CAABERCORN' => 'Abercorn',
		'CAFRELIGHSBURG' => 'Frelighsburg',
		'CASAINT-ARMAND' => 'Saint-Armand',
		'CAPIKE_RIVER' => 'Pike River',
		'CASTANBRIDGE_STATION' => 'Stanbridge Station',
		'CABEDFORD' => 'Bedford',
		'CABEDFORD' => 'Bedford',
		'CASTANBRIDGE_EAST' => 'Stanbridge East',
		'CADUNHAM' => 'Dunham',
		'CASUTTON' => 'Sutton',
		'CABOLTON-OUEST' => 'Bolton-Ouest',
		'CABROME' => 'Brome',
		'CALAC-BROME' => 'Lac-Brome',
		'CABROMONT' => 'Bromont',
		'CACOWANSVILLE' => 'Cowansville',
		'CAEAST_FARNHAM' => 'East Farnham',
		'CABRIGHAM' => 'Brigham',
		'CASAINT-IGNACE-DE-STANBRIDGE' => 'Saint-Ignace-de-Stanbridge',
		'CANOTRE-DAME-DE-STANBRIDGE' => 'Notre-Dame-de-Stanbridge',
		'CASAINTE-SABINE' => 'Sainte-Sabine',
		'CAFARNHAM' => 'Farnham',
		'CASAINT-ALPHONSE-DE-GRANBY' => 'Saint-Alphonse-de-Granby',
		'CAGRANBY' => 'Granby',
		'CAWATERLOO' => 'Waterloo',
		'CAWARDEN' => 'Warden',
		'CASHEFFORD' => 'Shefford',
		'CASAINT-JOACHIM-DE-SHEFFORD' => 'Saint-Joachim-de-Shefford',
		'CAROXTON_POND' => 'Roxton Pond',
		'CASAINTE-CCILE-DE-MILTON' => 'Sainte-Ccile-de-Milton',
		'CABTHANIE' => 'Bthanie',
		'CAROXTON_FALLS' => 'Roxton Falls',
		'CAROXTON' => 'Roxton',
		'CASAINTE-CHRISTINE' => 'Sainte-Christine',
		'CAACTON_VALE' => 'Acton Vale',
		'CAUPTON' => 'Upton',
		'CASAINT-THODORE-DACTON' => 'Saint-Thodore-dActon',
		'CASAINT-NAZAIRE-DACTON' => 'Saint-Nazaire-dActon',
		'CASAINT-FLIX-DE-KINGSEY' => 'Saint-Flix-de-Kingsey',
		'CADURHAM-SUD' => 'Durham-Sud',
		'CALEFEBVRE' => 'Lefebvre',
		'CALAVENIR' => 'LAvenir',
		'CASAINT-LUCIEN' => 'Saint-Lucien',
		'CAWICKHAM' => 'Wickham',
		'CASAINT-GERMAIN-DE-GRANTHAM' => 'Saint-Germain-de-Grantham',
		'CADRUMMONDVILLE' => 'Drummondville',
		'CASAINT-CYRILLE-DE-WENDOVER' => 'Saint-Cyrille-de-Wendover',
		'CANOTRE-DAME-DU-BON-CONSEIL' => 'Notre-Dame-du-Bon-Conseil',
		'CANOTRE-DAME-DU-BON-CONSEIL' => 'Notre-Dame-du-Bon-Conseil',
		'CASAINTE-BRIGITTE-DES-SAULTS' => 'Sainte-Brigitte-des-Saults',
		'CASAINT-MAJORIQUE-DE-GRANTHAM' => 'Saint-Majorique-de-Grantham',
		'CASAINT-EDMOND-DE-GRANTHAM' => 'Saint-Edmond-de-Grantham',
		'CASAINT-EUGNE' => 'Saint-Eugne',
		'CASAINT-GUILLAUME' => 'Saint-Guillaume',
		'CASAINT-BONAVENTURE' => 'Saint-Bonaventure',
		'CASAINT-PIE-DE-GUIRE' => 'Saint-Pie-de-Guire',
		'CASAINTE-EULALIE' => 'Sainte-Eulalie',
		'CAASTON-JONCTION' => 'Aston-Jonction',
		'CASAINT-WENCESLAS' => 'Saint-Wenceslas',
		'CASAINT-CLESTIN' => 'Saint-Clestin',
		'CASAINT-CLESTIN' => 'Saint-Clestin',
		'CASAINT-LONARD-DASTON' => 'Saint-Lonard-dAston',
		'CASAINTE-PERPTUE' => 'Sainte-Perptue',
		'CASAINTE-MONIQUE' => 'Sainte-Monique',
		'CAGRAND-SAINT-ESPRIT' => 'Grand-Saint-Esprit',
		'CANICOLET' => 'Nicolet',
		'CALA_VISITATION-DE-YAMASKA' => 'La Visitation-de-Yamaska',
		'CASAINT-ZPHIRIN-DE-COURVAL' => 'Saint-Zphirin-de-Courval',
		'CASAINT-ELPHGE' => 'Saint-Elphge',
		'CABAIE-DU-FEBVRE' => 'Baie-du-Febvre',
		'CAPIERREVILLE' => 'Pierreville',
		'CASAINT-FRANOIS-DU-LAC' => 'Saint-Franois-du-Lac',
		'CAODANAK' => 'Odanak',
		'CAMASKINONG' => 'Maskinong',
		'CALOUISEVILLE' => 'Louiseville',
		'CAYAMACHICHE' => 'Yamachiche',
		'CASAINT-BARNAB' => 'Saint-Barnab',
		'CASAINT-SVRE' => 'Saint-Svre',
		'CASAINT-LON-LE-GRAND' => 'Saint-Lon-le-Grand',
		'CASAINTE-URSULE' => 'Sainte-Ursule',
		'CASAINT-JUSTIN' => 'Saint-Justin',
		'CASAINT-DOUARD-DE-MASKINONG' => 'Saint-douard-de-Maskinong',
		'CASAINTE-ANGLE-DE-PRMONT' => 'Sainte-Angle-de-Prmont',
		'CASAINT-PAULIN' => 'Saint-Paulin',
		'CASAINT-ALEXIS-DES-MONTS' => 'Saint-Alexis-des-Monts',
		'CASAINT-MATHIEU-DU-PARC' => 'Saint-Mathieu-du-Parc',
		'CASAINT-LIE-DE-CAXTON' => 'Saint-lie-de-Caxton',
		'CACHARETTE' => 'Charette',
		'CASAINT-BONIFACE' => 'Saint-Boniface',
		'CASAINT-TIENNE-DES-GRS' => 'Saint-tienne-des-Grs',
		'CALAVALTRIE' => 'Lavaltrie',
		'CALANORAIE' => 'Lanoraie',
		'CASAINTE-LISABETH' => 'Sainte-lisabeth',
		'CABERTHIERVILLE' => 'Berthierville',
		'CASAINTE-GENEVIVE-DE-BERTHIER' => 'Sainte-Genevive-de-Berthier',
		'CASAINT-IGNACE-DE-LOYOLA' => 'Saint-Ignace-de-Loyola',
		'CALA_VISITATION-DE-LLE-DUPAS' => 'La Visitation-de-lle-Dupas',
		'CASAINT-BARTHLEMY' => 'Saint-Barthlemy',
		'CASAINT-CUTHBERT' => 'Saint-Cuthbert',
		'CASAINT-NORBERT' => 'Saint-Norbert',
		'CASAINT-CLOPHAS-DE-BRANDON' => 'Saint-Clophas-de-Brandon',
		'CASAINT-GABRIEL' => 'Saint-Gabriel',
		'CASAINT-GABRIEL-DE-BRANDON' => 'Saint-Gabriel-de-Brandon',
		'CASAINT-DIDACE' => 'Saint-Didace',
		'CAMANDEVILLE' => 'Mandeville',
		'CASAINT-DAVID' => 'Saint-David',
		'CAMASSUEVILLE' => 'Massueville',
		'CASAINT-AIM' => 'Saint-Aim',
		'CASAINT-ROBERT' => 'Saint-Robert',
		'CASAINTE-VICTOIRE-DE-SOREL' => 'Sainte-Victoire-de-Sorel',
		'CASAINT-OURS' => 'Saint-Ours',
		'CASAINT-ROCH-DE-RICHELIEU' => 'Saint-Roch-de-Richelieu',
		'CASAINT-JOSEPH-DE-SOREL' => 'Saint-Joseph-de-Sorel',
		'CASOREL-TRACY' => 'Sorel-Tracy',
		'CASAINTE-ANNE-DE-SOREL' => 'Sainte-Anne-de-Sorel',
		'CAYAMASKA' => 'Yamaska',
		'CASAINT-GRARD-MAJELLA' => 'Saint-Grard-Majella',
		'CASAINT-PIE' => 'Saint-Pie',
		'CASAINT-DAMASE' => 'Saint-Damase',
		'CASAINTE-MADELEINE' => 'Sainte-Madeleine',
		'CASAINTE-MARIE-MADELEINE' => 'Sainte-Marie-Madeleine',
		'CALA_PRSENTATION' => 'La Prsentation',
		'CASAINT-HYACINTHE' => 'Saint-Hyacinthe',
		'CASAINT-DOMINIQUE' => 'Saint-Dominique',
		'CASAINT-VALRIEN-DE-MILTON' => 'Saint-Valrien-de-Milton',
		'CASAINT-LIBOIRE' => 'Saint-Liboire',
		'CASAINT-SIMON' => 'Saint-Simon',
		'CASAINTE-HLNE-DE-BAGOT' => 'Sainte-Hlne-de-Bagot',
		'CASAINT-HUGUES' => 'Saint-Hugues',
		'CASAINT-BARNAB-SUD' => 'Saint-Barnab-Sud',
		'CASAINT-JUDE' => 'Saint-Jude',
		'CASAINT-BERNARD-DE-MICHAUDVILLE' => 'Saint-Bernard-de-Michaudville',
		'CASAINT-LOUIS' => 'Saint-Louis',
		'CASAINT-MARCEL-DE-RICHELIEU' => 'Saint-Marcel-de-Richelieu',
		'CAANGE-GARDIEN' => 'Ange-Gardien',
		'CASAINT-PAUL-DABBOTSFORD' => 'Saint-Paul-dAbbotsford',
		'CASAINT-CSAIRE' => 'Saint-Csaire',
		'CASAINTE-ANGLE-DE-MONNOIR' => 'Sainte-Angle-de-Monnoir',
		'CAROUGEMONT' => 'Rougemont',
		'CAMARIEVILLE' => 'Marieville',
		'CARICHELIEU' => 'Richelieu',
		'CASAINT-MATHIAS-SUR-RICHELIEU' => 'Saint-Mathias-sur-Richelieu',
		'CAVENISE-EN-QUBEC' => 'Venise-en-Qubec',
		'CASAINT-GEORGES-DE-CLARENCEVILLE' => 'Saint-Georges-de-Clarenceville',
		'CANOYAN' => 'Noyan',
		'CALACOLLE' => 'Lacolle',
		'CASAINT-VALENTIN' => 'Saint-Valentin',
		'CASAINT-PAUL-DE-LLE-AUX-NOIX' => 'Saint-Paul-de-lle-aux-Noix',
		'CAHENRYVILLE' => 'Henryville',
		'CASAINT-SBASTIEN' => 'Saint-Sbastien',
		'CASAINT-ALEXANDRE' => 'Saint-Alexandre',
		'CASAINTE-ANNE-DE-SABREVOIS' => 'Sainte-Anne-de-Sabrevois',
		'CASAINT-BLAISE-SUR-RICHELIEU' => 'Saint-Blaise-sur-Richelieu',
		'CASAINT-JEAN-SUR-RICHELIEU' => 'Saint-Jean-sur-Richelieu',
		'CAMONT-SAINT-GRGOIRE' => 'Mont-Saint-Grgoire',
		'CASAINTE-BRIGIDE-DIBERVILLE' => 'Sainte-Brigide-dIberville',
		'CACHAMBLY' => 'Chambly',
		'CACARIGNAN' => 'Carignan',
		'CASAINT-BASILE-LE-GRAND' => 'Saint-Basile-le-Grand',
		'CAMCMASTERVILLE' => 'McMasterville',
		'CAOTTERBURN_PARK' => 'Otterburn Park',
		'CASAINT-JEAN-BAPTISTE' => 'Saint-Jean-Baptiste',
		'CAMONT-SAINT-HILAIRE' => 'Mont-Saint-Hilaire',
		'CABELOEIL' => 'Beloeil',
		'CASAINT-MATHIEU-DE-BELOEIL' => 'Saint-Mathieu-de-Beloeil',
		'CASAINT-MARC-SUR-RICHELIEU' => 'Saint-Marc-sur-Richelieu',
		'CASAINT-CHARLES-SUR-RICHELIEU' => 'Saint-Charles-sur-Richelieu',
		'CASAINT-DENIS-SUR-RICHELIEU' => 'Saint-Denis-sur-Richelieu',
		'CASAINT-ANTOINE-SUR-RICHELIEU' => 'Saint-Antoine-sur-Richelieu',
		'CABROSSARD' => 'Brossard',
		'CASAINT-LAMBERT' => 'Saint-Lambert',
		'CABOUCHERVILLE' => 'Boucherville',
		'CASAINT-BRUNO-DE-MONTARVILLE' => 'Saint-Bruno-de-Montarville',
		'CALONGUEUIL' => 'Longueuil',
		'CASAINTE-JULIE' => 'Sainte-Julie',
		'CASAINT-AMABLE' => 'Saint-Amable',
		'CAVARENNES' => 'Varennes',
		'CAVERCHRES' => 'Verchres',
		'CACALIXA-LAVALLE' => 'Calixa-Lavalle',
		'CACONTRECOEUR' => 'Contrecoeur',
		'CACHARLEMAGNE' => 'Charlemagne',
		'CAREPENTIGNY' => 'Repentigny',
		'CASAINT-SULPICE' => 'Saint-Sulpice',
		'CALASSOMPTION' => 'LAssomption',
		'CALPIPHANIE' => 'Lpiphanie',
		'CALPIPHANIE' => 'Lpiphanie',
		'CASAINT-PAUL' => 'Saint-Paul',
		'CACRABTREE' => 'Crabtree',
		'CASAINT-PIERRE' => 'Saint-Pierre',
		'CAJOLIETTE' => 'Joliette',
		'CASAINT-THOMAS' => 'Saint-Thomas',
		'CANOTRE-DAME-DES-PRAIRIES' => 'Notre-Dame-des-Prairies',
		'CASAINT-CHARLES-BORROME' => 'Saint-Charles-Borrome',
		'CASAINT-AMBROISE-DE-KILDARE' => 'Saint-Ambroise-de-Kildare',
		'CANOTRE-DAME-DE-LOURDES' => 'Notre-Dame-de-Lourdes',
		'CASAINTE-MLANIE' => 'Sainte-Mlanie',
		'CASAINT-FLIX-DE-VALOIS' => 'Saint-Flix-de-Valois',
		'CASAINT-JEAN-DE-MATHA' => 'Saint-Jean-de-Matha',
		'CASAINTE-BATRIX' => 'Sainte-Batrix',
		'CASAINT-ALPHONSE-RODRIGUEZ' => 'Saint-Alphonse-Rodriguez',
		'CASAINTE-MARCELLINE-DE-KILDARE' => 'Sainte-Marcelline-de-Kildare',
		'CARAWDON' => 'Rawdon',
		'CACHERTSEY' => 'Chertsey',
		'CAENTRELACS' => 'Entrelacs',
		'CANOTRE-DAME-DE-LA-MERCI' => 'Notre-Dame-de-la-Merci',
		'CASAINT-DONAT' => 'Saint-Donat',
		'CASAINT-CME' => 'Saint-Cme',
		'CASAINTE-MLIE-DE-LNERGIE' => 'Sainte-mlie-de-lnergie',
		'CASAINT-DAMIEN' => 'Saint-Damien',
		'CASAINT-ZNON' => 'Saint-Znon',
		'CASAINT-MICHEL-DES-SAINTS' => 'Saint-Michel-des-Saints',
		'CAMANAWAN' => 'Manawan',
		'CALAC-MINAKI' => 'Lac-Minaki',
		'CALAC-DEVENYNS' => 'Lac-Devenyns',
		'CABAIE-DE-LA-BOUTEILLE' => 'Baie-de-la-Bouteille',
		'CALAC-MATAWIN' => 'Lac-Matawin',
		'CALAC-LEGENDRE' => 'Lac-Legendre',
		'CASAINT-GUILLAUME-NORD' => 'Saint-Guillaume-Nord',
		'CALAC-DES-DIX-MILLES' => 'Lac-des-Dix-Milles',
		'CALAC-SANT' => 'Lac-Sant',
		'CABAIE-OBAOCA' => 'Baie-Obaoca',
		'CALAC-CABASTA' => 'Lac-Cabasta',
		'CABAIE-ATIBENNE' => 'Baie-Atibenne',
		'CALAC-DU-TAUREAU' => 'Lac-du-Taureau',
		'CASAINTE-MARIE-SALOM' => 'Sainte-Marie-Salom',
		'CASAINT-JACQUES' => 'Saint-Jacques',
		'CASAINT-ALEXIS' => 'Saint-Alexis',
		'CASAINT-ESPRIT' => 'Saint-Esprit',
		'CASAINT-ROCH-DE-LACHIGAN' => 'Saint-Roch-de-lAchigan',
		'CASAINT-ROCH-OUEST' => 'Saint-Roch-Ouest',
		'CASAINT-LIN--LAURENTIDES' => 'Saint-Lin--Laurentides',
		'CASAINT-CALIXTE' => 'Saint-Calixte',
		'CASAINTE-JULIENNE' => 'Sainte-Julienne',
		'CASAINT-LIGUORI' => 'Saint-Liguori',
		'CATERREBONNE' => 'Terrebonne',
		'CAMASCOUCHE' => 'Mascouche',
		'CALAVAL' => 'Laval',
		'CAMONTRAL-EST' => 'Montral-Est',
		'CAMONTRAL' => 'Montral',
		'CAWESTMOUNT' => 'Westmount',
		'CAMONTRAL-OUEST' => 'Montral-Ouest',
		'CACTE-SAINT-LUC' => 'Cte-Saint-Luc',
		'CAHAMPSTEAD' => 'Hampstead',
		'CAMONT-ROYAL' => 'Mont-Royal',
		'CADORVAL' => 'Dorval',
		'CALLE-DORVAL' => 'Lle-Dorval',
		'CAPOINTE-CLAIRE' => 'Pointe-Claire',
		'CAKIRKLAND' => 'Kirkland',
		'CABEACONSFIELD' => 'Beaconsfield',
		'CABAIE-DURF' => 'Baie-DUrf',
		'CASAINTE-ANNE-DE-BELLEVUE' => 'Sainte-Anne-de-Bellevue',
		'CASENNEVILLE' => 'Senneville',
		'CADOLLARD-DES_ORMEAUX' => 'Dollard-Des Ormeaux',
		'CASAINT-MATHIEU' => 'Saint-Mathieu',
		'CASAINT-PHILIPPE' => 'Saint-Philippe',
		'CALA_PRAIRIE' => 'La Prairie',
		'CACANDIAC' => 'Candiac',
		'CADELSON' => 'Delson',
		'CASAINTE-CATHERINE' => 'Sainte-Catherine',
		'CASAINT-CONSTANT' => 'Saint-Constant',
		'CASAINT-ISIDORE' => 'Saint-Isidore',
		'CAMERCIER' => 'Mercier',
		'CACHTEAUGUAY' => 'Chteauguay',
		'CALRY' => 'Lry',
		'CAKAHNAWAKE' => 'Kahnawake',
		'CASAINT-BERNARD-DE-LACOLLE' => 'Saint-Bernard-de-Lacolle',
		'CAHEMMINGFORD' => 'Hemmingford',
		'CAHEMMINGFORD' => 'Hemmingford',
		'CASAINTE-CLOTILDE' => 'Sainte-Clotilde',
		'CASAINT-PATRICE-DE-SHERRINGTON' => 'Saint-Patrice-de-Sherrington',
		'CANAPIERVILLE' => 'Napierville',
		'CASAINT-CYPRIEN-DE-NAPIERVILLE' => 'Saint-Cyprien-de-Napierville',
		'CASAINT-JACQUES-LE-MINEUR' => 'Saint-Jacques-le-Mineur',
		'CASAINT-DOUARD' => 'Saint-douard',
		'CASAINT-MICHEL' => 'Saint-Michel',
		'CASAINT-RMI' => 'Saint-Rmi',
		'CAHAVELOCK' => 'Havelock',
		'CAFRANKLIN' => 'Franklin',
		'CASAINT-CHRYSOSTOME' => 'Saint-Chrysostome',
		'CAHOWICK' => 'Howick',
		'CATRS-SAINT-SACREMENT' => 'Trs-Saint-Sacrement',
		'CAORMSTOWN' => 'Ormstown',
		'CAHINCHINBROOKE' => 'Hinchinbrooke',
		'CAELGIN' => 'Elgin',
		'CAHUNTINGDON' => 'Huntingdon',
		'CAGODMANCHESTER' => 'Godmanchester',
		'CASAINTE-BARBE' => 'Sainte-Barbe',
		'CASAINT-ANICET' => 'Saint-Anicet',
		'CADUNDEE' => 'Dundee',
		'CAAKWESASNE' => 'Akwesasne',
		'CASAINT-URBAIN-PREMIER' => 'Saint-Urbain-Premier',
		'CASAINTE-MARTINE' => 'Sainte-Martine',
		'CABEAUHARNOIS' => 'Beauharnois',
		'CASAINT-TIENNE-DE-BEAUHARNOIS' => 'Saint-tienne-de-Beauharnois',
		'CASAINT-LOUIS-DE-GONZAGUE' => 'Saint-Louis-de-Gonzague',
		'CASAINT-STANISLAS-DE-KOSTKA' => 'Saint-Stanislas-de-Kostka',
		'CASALABERRY-DE-VALLEYFIELD' => 'Salaberry-de-Valleyfield',
		'CARIVIRE-BEAUDETTE' => 'Rivire-Beaudette',
		'CASAINT-TLESPHORE' => 'Saint-Tlesphore',
		'CASAINT-POLYCARPE' => 'Saint-Polycarpe',
		'CASAINT-ZOTIQUE' => 'Saint-Zotique',
		'CALES_COTEAUX' => 'Les Coteaux',
		'CACOTEAU-DU-LAC' => 'Coteau-du-Lac',
		'CASAINT-CLET' => 'Saint-Clet',
		'CALES_CDRES' => 'Les Cdres',
		'CAPOINTE-DES-CASCADES' => 'Pointe-des-Cascades',
		'CALLE-PERROT' => 'Lle-Perrot',
		'CANOTRE-DAME-DE-LLE-PERROT' => 'Notre-Dame-de-lle-Perrot',
		'CAPINCOURT' => 'Pincourt',
		'CATERRASSE-VAUDREUIL' => 'Terrasse-Vaudreuil',
		'CAVAUDREUIL-DORION' => 'Vaudreuil-Dorion',
		'CAVAUDREUIL-SUR-LE-LAC' => 'Vaudreuil-sur-le-Lac',
		'CALLE-CADIEUX' => 'Lle-Cadieux',
		'CAHUDSON' => 'Hudson',
		'CASAINT-LAZARE' => 'Saint-Lazare',
		'CASAINTE-MARTHE' => 'Sainte-Marthe',
		'CASAINTE-JUSTINE-DE-NEWTON' => 'Sainte-Justine-de-Newton',
		'CATRS-SAINT-RDEMPTEUR' => 'Trs-Saint-Rdempteur',
		'CARIGAUD' => 'Rigaud',
		'CAPOINTE-FORTUNE' => 'Pointe-Fortune',
		'CASAINT-EUSTACHE' => 'Saint-Eustache',
		'CADEUX-MONTAGNES' => 'Deux-Montagnes',
		'CASAINTE-MARTHE-SUR-LE-LAC' => 'Sainte-Marthe-sur-le-Lac',
		'CAPOINTE-CALUMET' => 'Pointe-Calumet',
		'CASAINT-JOSEPH-DU-LAC' => 'Saint-Joseph-du-Lac',
		'CAOKA' => 'Oka',
		'CASAINT-PLACIDE' => 'Saint-Placide',
		'CAKANESATAKE' => 'Kanesatake',
		'CABOISBRIAND' => 'Boisbriand',
		'CASAINTE-THRSE' => 'Sainte-Thrse',
		'CABLAINVILLE' => 'Blainville',
		'CAROSEMRE' => 'Rosemre',
		'CALORRAINE' => 'Lorraine',
		'CABOIS-DES-FILION' => 'Bois-des-Filion',
		'CASAINTE-ANNE-DES-PLAINES' => 'Sainte-Anne-des-Plaines',
		'CAMIRABEL' => 'Mirabel',
		'CASAINT-COLOMBAN' => 'Saint-Colomban',
		'CASAINT-JRME' => 'Saint-Jrme',
		'CASAINTE-SOPHIE' => 'Sainte-Sophie',
		'CAPRVOST' => 'Prvost',
		'CASAINT-HIPPOLYTE' => 'Saint-Hippolyte',
		'CASAINT-ANDR-DARGENTEUIL' => 'Saint-Andr-dArgenteuil',
		'CALACHUTE' => 'Lachute',
		'CAGORE' => 'Gore',
		'CAMILLE-ISLES' => 'Mille-Isles',
		'CAWENTWORTH' => 'Wentworth',
		'CABROWNSBURG-CHATHAM' => 'Brownsburg-Chatham',
		'CAGRENVILLE-SUR-LA-ROUGE' => 'Grenville-sur-la-Rouge',
		'CAGRENVILLE' => 'Grenville',
		'CAHARRINGTON' => 'Harrington',
		'CAESTREL' => 'Estrel',
		'CASAINTE-MARGUERITE-DU-LAC-MASSON' => 'Sainte-Marguerite-du-Lac-Masson',
		'CASAINTE-ADLE' => 'Sainte-Adle',
		'CAPIEDMONT' => 'Piedmont',
		'CASAINTE-ANNE-DES-LACS' => 'Sainte-Anne-des-Lacs',
		'CASAINT-SAUVEUR' => 'Saint-Sauveur',
		'CAMORIN-HEIGHTS' => 'Morin-Heights',
		'CALAC-DES-SEIZE-LES' => 'Lac-des-Seize-les',
		'CAWENTWORTH-NORD' => 'Wentworth-Nord',
		'CASAINT-ADOLPHE-DHOWARD' => 'Saint-Adolphe-dHoward',
		'CAVAL-MORIN' => 'Val-Morin',
		'CAVAL-DAVID' => 'Val-David',
		'CALANTIER' => 'Lantier',
		'CASAINTE-LUCIE-DES-LAURENTIDES' => 'Sainte-Lucie-des-Laurentides',
		'CASAINTE-AGATHE-DES-MONTS' => 'Sainte-Agathe-des-Monts',
		'CAIVRY-SUR-LE-LAC' => 'Ivry-sur-le-Lac',
		'CASAINT-FAUSTIN--LAC-CARR' => 'Saint-Faustin--Lac-Carr',
		'CABARKMERE' => 'Barkmere',
		'CAMONTCALM' => 'Montcalm',
		'CAARUNDEL' => 'Arundel',
		'CAHUBERDEAU' => 'Huberdeau',
		'CAAMHERST' => 'Amherst',
		'CABRBEUF' => 'Brbeuf',
		'CALAC-SUPRIEUR' => 'Lac-Suprieur',
		'CAVAL-DES-LACS' => 'Val-des-Lacs',
		'CAMONT-TREMBLANT' => 'Mont-Tremblant',
		'CALA_CONCEPTION' => 'La Conception',
		'CALABELLE' => 'Labelle',
		'CALAC-TREMBLANT-NORD' => 'Lac-Tremblant-Nord',
		'CALA_MINERVE' => 'La Minerve',
		'CADONCASTER' => 'Doncaster',
		'CANOTRE-DAME-DU-LAUS' => 'Notre-Dame-du-Laus',
		'CANOTRE-DAME-DE-PONTMAIN' => 'Notre-Dame-de-Pontmain',
		'CALAC-DU-CERF' => 'Lac-du-Cerf',
		'CASAINT-AIM-DU-LAC-DES-LES' => 'Saint-Aim-du-Lac-des-les',
		'CAKIAMIKA' => 'Kiamika',
		'CANOMININGUE' => 'Nominingue',
		'CARIVIRE-ROUGE' => 'Rivire-Rouge',
		'CALA_MACAZA' => 'La Macaza',
		'CALASCENSION' => 'LAscension',
		'CALAC-SAGUAY' => 'Lac-Saguay',
		'CACHUTE-SAINT-PHILIPPE' => 'Chute-Saint-Philippe',
		'CALAC-DES-CORCES' => 'Lac-des-corces',
		'CAMONT-LAURIER' => 'Mont-Laurier',
		'CAFERME-NEUVE' => 'Ferme-Neuve',
		'CALAC-SAINT-PAUL' => 'Lac-Saint-Paul',
		'CAMONT-SAINT-MICHEL' => 'Mont-Saint-Michel',
		'CASAINTE-ANNE-DU-LAC' => 'Sainte-Anne-du-Lac',
		'CALAC-DE-LA-POMME' => 'Lac-de-la-Pomme',
		'CALAC-AKONAPWEHIKAN' => 'Lac-Akonapwehikan',
		'CALAC-WAGWABIKA' => 'Lac-Wagwabika',
		'CALAC-BAZINET' => 'Lac-Bazinet',
		'CALAC-DE_LA_BIDIRE' => 'Lac-De La Bidire',
		'CALAC-OSCAR' => 'Lac-Oscar',
		'CALAC-DE-LA-MAISON-DE-PIERRE' => 'Lac-de-la-Maison-de-Pierre',
		'CABAIE-DES-CHALOUPES' => 'Baie-des-Chaloupes',
		'CALAC-DOUAIRE' => 'Lac-Douaire',
		'CALAC-ERNEST' => 'Lac-Ernest',
		'CALAC-MARGUERITE' => 'Lac-Marguerite',
		'CAFASSETT' => 'Fassett',
		'CAMONTEBELLO' => 'Montebello',
		'CANOTRE-DAME-DE-BONSECOURS' => 'Notre-Dame-de-Bonsecours',
		'CANOTRE-DAME-DE-LA-PAIX' => 'Notre-Dame-de-la-Paix',
		'CASAINT-ANDR-AVELLIN' => 'Saint-Andr-Avellin',
		'CAPAPINEAUVILLE' => 'Papineauville',
		'CAPLAISANCE' => 'Plaisance',
		'CATHURSO' => 'Thurso',
		'CALOCHABER' => 'Lochaber',
		'CALOCHABER-PARTIE-OUEST' => 'Lochaber-Partie-Ouest',
		'CAMAYO' => 'Mayo',
		'CASAINT-SIXTE' => 'Saint-Sixte',
		'CARIPON' => 'Ripon',
		'CAMULGRAVE-ET-DERRY' => 'Mulgrave-et-Derry',
		'CAMONTPELLIER' => 'Montpellier',
		'CALAC-SIMON' => 'Lac-Simon',
		'CACHNVILLE' => 'Chnville',
		'CANAMUR' => 'Namur',
		'CABOILEAU' => 'Boileau',
		'CASAINT-MILE-DE-SUFFOLK' => 'Saint-mile-de-Suffolk',
		'CALAC-DES-PLAGES' => 'Lac-des-Plages',
		'CADUHAMEL' => 'Duhamel',
		'CAVAL-DES-BOIS' => 'Val-des-Bois',
		'CABOWMAN' => 'Bowman',
		'CAGATINEAU' => 'Gatineau',
		'CALANGE-GARDIEN' => 'LAnge-Gardien',
		'CANOTRE-DAME-DE-LA-SALETTE' => 'Notre-Dame-de-la-Salette',
		'CAVAL-DES-MONTS' => 'Val-des-Monts',
		'CACANTLEY' => 'Cantley',
		'CACHELSEA' => 'Chelsea',
		'CAPONTIAC' => 'Pontiac',
		'CALA_PCHE' => 'La Pche',
		'CADENHOLM' => 'Denholm',
		'CALOW' => 'Low',
		'CAKAZABAZUA' => 'Kazabazua',
		'CALAC-SAINTE-MARIE' => 'Lac-Sainte-Marie',
		'CAGRACEFIELD' => 'Gracefield',
		'CACAYAMANT' => 'Cayamant',
		'CABLUE_SEA' => 'Blue Sea',
		'CABOUCHETTE' => 'Bouchette',
		'CASAINTE-THRSE-DE-LA-GATINEAU' => 'Sainte-Thrse-de-la-Gatineau',
		'CAMESSINES' => 'Messines',
		'CAMANIWAKI' => 'Maniwaki',
		'CADLAGE' => 'Dlage',
		'CAEGAN-SUD' => 'Egan-Sud',
		'CABOIS-FRANC' => 'Bois-Franc',
		'CAMONTCERF-LYTTON' => 'Montcerf-Lytton',
		'CAAUMOND' => 'Aumond',
		'CAGRAND-REMOUS' => 'Grand-Remous',
		'CAKITIGAN_ZIBI' => 'Kitigan Zibi',
		'CALAC-RAPIDE' => 'Lac-Rapide',
		'CALAC-PYTHONGA' => 'Lac-Pythonga',
		'CACASCADES-MALIGNES' => 'Cascades-Malignes',
		'CALAC-LENTRE' => 'Lac-Lentre',
		'CALAC-MOSELLE' => 'Lac-Moselle',
		'CADPT-CHOUANI' => 'Dpt-chouani',
		'CABRISTOL' => 'Bristol',
		'CASHAWVILLE' => 'Shawville',
		'CACLARENDON' => 'Clarendon',
		'CAPORTAGE-DU-FORT' => 'Portage-du-Fort',
		'CABRYSON' => 'Bryson',
		'CACAMPBELLS_BAY' => 'Campbells Bay',
		'CALLE-DU-GRAND-CALUMET' => 'Lle-du-Grand-Calumet',
		'CALITCHFIELD' => 'Litchfield',
		'CATHORNE' => 'Thorne',
		'CAALLEYN-ET-CAWOOD' => 'Alleyn-et-Cawood',
		'CAOTTER_LAKE' => 'Otter Lake',
		'CAFORT-COULONGE' => 'Fort-Coulonge',
		'CAMANSFIELD-ET-PONTEFRACT' => 'Mansfield-et-Pontefract',
		'CAWALTHAM' => 'Waltham',
		'CALISLE-AUX-ALLUMETTES' => 'LIsle-aux-Allumettes',
		'CACHICHESTER' => 'Chichester',
		'CASHEENBORO' => 'Sheenboro',
		'CARAPIDES-DES-JOACHIMS' => 'Rapides-des-Joachims',
		'CALAC-NILGAUT' => 'Lac-Nilgaut',
		'CATMISCAMING' => 'Tmiscaming',
		'CAKIPAWA' => 'Kipawa',
		'CASAINT-DOUARD-DE-FABRE' => 'Saint-douard-de-Fabre',
		'CABARN' => 'Barn',
		'CAVILLE-MARIE' => 'Ville-Marie',
		'CADUHAMEL-OUEST' => 'Duhamel-Ouest',
		'CALORRAINVILLE' => 'Lorrainville',
		'CASAINT-BRUNO-DE-GUIGUES' => 'Saint-Bruno-de-Guigues',
		'CALAVERLOCHRE' => 'Laverlochre',
		'CAFUGREVILLE' => 'Fugreville',
		'CALATULIPE-ET-GABOURY' => 'Latulipe-et-Gaboury',
		'CABELLETERRE' => 'Belleterre',
		'CALAFORCE' => 'Laforce',
		'CAMOFFET' => 'Moffet',
		'CAANGLIERS' => 'Angliers',
		'CASAINT-EUGNE-DE-GUIGUES' => 'Saint-Eugne-de-Guigues',
		'CANOTRE-DAME-DU-NORD' => 'Notre-Dame-du-Nord',
		'CAGURIN' => 'Gurin',
		'CANDLEC' => 'Ndlec',
		'CARMIGNY' => 'Rmigny',
		'CAKEBAOWEK' => 'Kebaowek',
		'CAHUNTERS_POINT' => 'Hunters Point',
		'CAWINNEWAY' => 'Winneway',
		'CATIMISKAMING' => 'Timiskaming',
		'CALANIEL' => 'Laniel',
		'CALES_LACS-DU-TMISCAMINGUE' => 'Les Lacs-du-Tmiscamingue',
		'CAROUYN-NORANDA' => 'Rouyn-Noranda',
		'CADUPARQUET' => 'Duparquet',
		'CARAPIDE-DANSEUR' => 'Rapide-Danseur',
		'CAROQUEMAURE' => 'Roquemaure',
		'CAGALLICHAN' => 'Gallichan',
		'CAPALMAROLLE' => 'Palmarolle',
		'CASAINTE-GERMAINE-BOUL' => 'Sainte-Germaine-Boul',
		'CAPOULARIES' => 'Poularies',
		'CATASCHEREAU' => 'Taschereau',
		'CAAUTHIER' => 'Authier',
		'CAMACAMIC' => 'Macamic',
		'CASAINTE-HLNE-DE-MANCEBOURG' => 'Sainte-Hlne-de-Mancebourg',
		'CACLERVAL' => 'Clerval',
		'CALA_REINE' => 'La Reine',
		'CADUPUY' => 'Dupuy',
		'CALA_SARRE' => 'La Sarre',
		'CACHAZEL' => 'Chazel',
		'CAAUTHIER-NORD' => 'Authier-Nord',
		'CAVAL-SAINT-GILLES' => 'Val-Saint-Gilles',
		'CACLERMONT' => 'Clermont',
		'CANORMTAL' => 'Normtal',
		'CASAINT-LAMBERT' => 'Saint-Lambert',
		'CALAC-DUPARQUET' => 'Lac-Duparquet',
		'CARIVIRE-OJIMA' => 'Rivire-Ojima',
		'CACHAMPNEUF' => 'Champneuf',
		'CAROCHEBAUCOURT' => 'Rochebaucourt',
		'CALA_MORANDIRE' => 'La Morandire',
		'CABARRAUTE' => 'Barraute',
		'CALA_CORNE' => 'La Corne',
		'CALANDRIENNE' => 'Landrienne',
		'CASAINT-MARC-DE-FIGUERY' => 'Saint-Marc-de-Figuery',
		'CALA_MOTTE' => 'La Motte',
		'CASAINT-MATHIEU-DHARRICANA' => 'Saint-Mathieu-dHarricana',
		'CAAMOS' => 'Amos',
		'CASAINT-FLIX-DE-DALQUIER' => 'Saint-Flix-de-Dalquier',
		'CASAINT-DOMINIQUE-DU-ROSAIRE' => 'Saint-Dominique-du-Rosaire',
		'CABERRY' => 'Berry',
		'CATRCESSON' => 'Trcesson',
		'CALAUNAY' => 'Launay',
		'CASAINTE-GERTRUDE-MANNEVILLE' => 'Sainte-Gertrude-Manneville',
		'CAPREISSAC' => 'Preissac',
		'CAPIKOGAN' => 'Pikogan',
		'CALAC-DESPINASSY' => 'Lac-Despinassy',
		'CALAC-CHICOBI' => 'Lac-Chicobi',
		'CAVAL-DOR' => 'Val-dOr',
		'CARIVIRE-HVA' => 'Rivire-Hva',
		'CAMALARTIC' => 'Malartic',
		'CASENNETERRE' => 'Senneterre',
		'CASENNETERRE' => 'Senneterre',
		'CABELCOURT' => 'Belcourt',
		'CAKITCISAKIK' => 'Kitcisakik',
		'CALAC-SIMON' => 'Lac-Simon',
		'CAMATCHI-MANITOU' => 'Matchi-Manitou',
		'CALAC-METEI' => 'Lac-Metei',
		'CARSERVOIR-DOZOIS' => 'Rservoir-Dozois',
		'CALAC-GRANET' => 'Lac-Granet',
		'CALA_TUQUE' => 'La Tuque',
		'CALA_BOSTONNAIS' => 'La Bostonnais',
		'CALAC-DOUARD' => 'Lac-douard',
		'CAWEMOTACI' => 'Wemotaci',
		'CAOBEDJIWAN' => 'Obedjiwan',
		'CALAC-BOUCHETTE' => 'Lac-Bouchette',
		'CASAINT-ANDR-DU-LAC-SAINT-JEAN' => 'Saint-Andr-du-Lac-Saint-Jean',
		'CASAINT-FRANOIS-DE-SALES' => 'Saint-Franois-de-Sales',
		'CACHAMBORD' => 'Chambord',
		'CAROBERVAL' => 'Roberval',
		'CASAINTE-HEDWIDGE' => 'Sainte-Hedwidge',
		'CASAINT-PRIME' => 'Saint-Prime',
		'CASAINT-FLICIEN' => 'Saint-Flicien',
		'CALA_DOR' => 'La Dor',
		'CAMASHTEUIATSH' => 'Mashteuiatsh',
		'CALAC-ASHUAPMUSHUAN' => 'Lac-Ashuapmushuan',
		'CASAINT-AUGUSTIN' => 'Saint-Augustin',
		'CAPRIBONKA' => 'Pribonka',
		'CASAINTE-JEANNE-DARC' => 'Sainte-Jeanne-dArc',
		'CADOLBEAU-MISTASSINI' => 'Dolbeau-Mistassini',
		'CAALBANEL' => 'Albanel',
		'CANORMANDIN' => 'Normandin',
		'CASAINT-THOMAS-DIDYME' => 'Saint-Thomas-Didyme',
		'CASAINT-EDMOND-LES-PLAINES' => 'Saint-Edmond-les-Plaines',
		'CAGIRARDVILLE' => 'Girardville',
		'CANOTRE-DAME-DE-LORETTE' => 'Notre-Dame-de-Lorette',
		'CASAINT-EUGNE-DARGENTENAY' => 'Saint-Eugne-dArgentenay',
		'CASAINT-STANISLAS' => 'Saint-Stanislas',
		'CAPASSES-DANGEREUSES' => 'Passes-Dangereuses',
		'CARIVIRE-MISTASSINI' => 'Rivire-Mistassini',
		'CADESBIENS' => 'Desbiens',
		'CAMTABETCHOUAN--LAC--LA-CROIX' => 'Mtabetchouan--Lac--la-Croix',
		'CAHBERTVILLE' => 'Hbertville',
		'CAHBERTVILLE-STATION' => 'Hbertville-Station',
		'CASAINT-BRUNO' => 'Saint-Bruno',
		'CASAINT-GDON' => 'Saint-Gdon',
		'CAALMA' => 'Alma',
		'CASAINT-NAZAIRE' => 'Saint-Nazaire',
		'CALABRECQUE' => 'Labrecque',
		'CALAMARCHE' => 'Lamarche',
		'CALASCENSION-DE-NOTRE-SEIGNEUR' => 'LAscension-de-Notre-Seigneur',
		'CASAINT-HENRI-DE-TAILLON' => 'Saint-Henri-de-Taillon',
		'CASAINTE-MONIQUE' => 'Sainte-Monique',
		'CASAINT-LUDGER-DE-MILOT' => 'Saint-Ludger-de-Milot',
		'CAMONT-APICA' => 'Mont-Apica',
		'CALAC-MONCOUCHE' => 'Lac-Moncouche',
		'CALAC-ACHOUAKAN' => 'Lac-Achouakan',
		'CABELLE-RIVIRE' => 'Belle-Rivire',
		'CASAGUENAY' => 'Saguenay',
		'CAPETIT-SAGUENAY' => 'Petit-Saguenay',
		'CALANSE-SAINT-JEAN' => 'LAnse-Saint-Jean',
		'CARIVIRE-TERNIT' => 'Rivire-ternit',
		'CAFERLAND-ET-BOILLEAU' => 'Ferland-et-Boilleau',
		'CASAINT-FLIX-DOTIS' => 'Saint-Flix-dOtis',
		'CASAINTE-ROSE-DU-NORD' => 'Sainte-Rose-du-Nord',
		'CASAINT-FULGENCE' => 'Saint-Fulgence',
		'CASAINT-HONOR' => 'Saint-Honor',
		'CASAINT-DAVID-DE-FALARDEAU' => 'Saint-David-de-Falardeau',
		'CABGIN' => 'Bgin',
		'CASAINT-AMBROISE' => 'Saint-Ambroise',
		'CASAINT-CHARLES-DE-BOURGET' => 'Saint-Charles-de-Bourget',
		'CALAROUCHE' => 'Larouche',
		'CALALEMANT' => 'Lalemant',
		'CALAC-MINISTUK' => 'Lac-Ministuk',
		'CAMONT-VALIN' => 'Mont-Valin',
		'CATADOUSSAC' => 'Tadoussac',
		'CASACR-COEUR' => 'Sacr-Coeur',
		'CALES_BERGERONNES' => 'Les Bergeronnes',
		'CALES_ESCOUMINS' => 'Les Escoumins',
		'CALONGUE-RIVE' => 'Longue-Rive',
		'CAPORTNEUF-SUR-MER' => 'Portneuf-sur-Mer',
		'CAFORESTVILLE' => 'Forestville',
		'CACOLOMBIER' => 'Colombier',
		'CAESSIPIT' => 'Essipit',
		'CALAC-AU-BROCHET' => 'Lac-au-Brochet',
		'CABAIE-TRINIT' => 'Baie-Trinit',
		'CAGODBOUT' => 'Godbout',
		'CAFRANQUELIN' => 'Franquelin',
		'CABAIE-COMEAU' => 'Baie-Comeau',
		'CAPOINTE-LEBEL' => 'Pointe-Lebel',
		'CAPOINTE-AUX-OUTARDES' => 'Pointe-aux-Outardes',
		'CACHUTE-AUX-OUTARDES' => 'Chute-aux-Outardes',
		'CARAGUENEAU' => 'Ragueneau',
		'CAPESSAMIT' => 'Pessamit',
		'CARIVIRE-AUX-OUTARDES' => 'Rivire-aux-Outardes',
		'CASEPT-LES' => 'Sept-les',
		'CAPORT-CARTIER' => 'Port-Cartier',
		'CAFERMONT' => 'Fermont',
		'CASCHEFFERVILLE' => 'Schefferville',
		'CAUASHAT' => 'Uashat',
		'CAMALIOTENAM' => 'Maliotenam',
		'CAKAWAWACHIKAMACH' => 'Kawawachikamach',
		'CAMATIMEKOSH' => 'Matimekosh',
		'CALAC-JOHN' => 'Lac-John',
		'CARIVIRE-NIPISSIS' => 'Rivire-Nipissis',
		'CALAC-WALKER' => 'Lac-Walker',
		'CARIVIRE-MOUCHALAGANE' => 'Rivire-Mouchalagane',
		'CACANIAPISCAU' => 'Caniapiscau',
		'CALAC-JUILLET' => 'Lac-Juillet',
		'CALAC-VACHER' => 'Lac-Vacher',
		'CABLANC-SABLON' => 'Blanc-Sablon',
		'CABONNE-ESPRANCE' => 'Bonne-Esprance',
		'CASAINT-AUGUSTIN' => 'Saint-Augustin',
		'CAGROS-MCATINA' => 'Gros-Mcatina',
		'CACTE-NORD-DU-GOLFE-DU-SAINT-LAURENT' => 'Cte-Nord-du-Golfe-du-Saint-Laurent',
		'CALLE-DANTICOSTI' => 'Lle-dAnticosti',
		'CANATASHQUAN' => 'Natashquan',
		'CAAGUANISH' => 'Aguanish',
		'CABAIE-JOHAN-BEETZ' => 'Baie-Johan-Beetz',
		'CAHAVRE-SAINT-PIERRE' => 'Havre-Saint-Pierre',
		'CALONGUE-POINTE-DE-MINGAN' => 'Longue-Pointe-de-Mingan',
		'CARIVIRE-SAINT-JEAN' => 'Rivire-Saint-Jean',
		'CARIVIRE-AU-TONNERRE' => 'Rivire-au-Tonnerre',
		'CAPAKUASHIPI' => 'Pakuashipi',
		'CALA_ROMAINE' => 'La Romaine',
		'CANATASHQUAN' => 'Natashquan',
		'CAMINGAN' => 'Mingan',
		'CALAC-JRME' => 'Lac-Jrme',
		'CAPETIT-MCATINA' => 'Petit-Mcatina',
		'CALEBEL-SUR-QUVILLON' => 'Lebel-sur-Quvillon',
		'CAWASWANIPI' => 'Waswanipi',
		'CAMATAGAMI' => 'Matagami',
		'CACHAPAIS' => 'Chapais',
		'CACHIBOUGAMAU' => 'Chibougamau',
		'CAMISTISSINI' => 'Mistissini',
		'CAWASKAGANISH' => 'Waskaganish',
		'CANEMASKA' => 'Nemaska',
		'CAEASTMAIN' => 'Eastmain',
		'CAWEMINDJI' => 'Wemindji',
		'CACHISASIBI' => 'Chisasibi',
		'CAEEYOU_ISTCHEE_BAIE-JAMES' => 'Eeyou Istchee Baie-James',
		'CAKAWAWACHIKAMACH' => 'Kawawachikamach',
		'CAWHAPMAGOOSTUI' => 'Whapmagoostui',
		'CAKUUJJUARAPIK' => 'Kuujjuarapik',
		'CAUMIUJAQ' => 'Umiujaq',
		'CAINUKJUAK' => 'Inukjuak',
		'CAKANGIQSUALUJJUAQ' => 'Kangiqsualujjuaq',
		'CAKUUJJUAQ' => 'Kuujjuaq',
		'CATASIUJAQ' => 'Tasiujaq',
		'CAAUPALUK' => 'Aupaluk',
		'CAKANGIRSUK' => 'Kangirsuk',
		'CAQUAQTAQ' => 'Quaqtaq',
		'CAPUVIRNITUQ' => 'Puvirnituq',
		'CAAKULIVIK' => 'Akulivik',
		'CAKANGIQSUJUAQ' => 'Kangiqsujuaq',
		'CASALLUIT' => 'Salluit',
		'CAIVUJIVIK' => 'Ivujivik',
		'CAWASWANIPI' => 'Waswanipi',
		'CAMISTISSINI' => 'Mistissini',
		'CAWASKAGANISH' => 'Waskaganish',
		'CANEMASKA' => 'Nemaska',
		'CAEASTMAIN' => 'Eastmain',
		'CAWEMINDJI' => 'Wemindji',
		'CACHISASIBI' => 'Chisasibi',
		'CAWHAPMAGOOSTUI' => 'Whapmagoostui',
		'CAOUJ-BOUGOUMOU' => 'Ouj-Bougoumou',
		'CAKUUJJUARAPIK' => 'Kuujjuarapik',
		'CAUMIUJAQ' => 'Umiujaq',
		'CAINUKJUAK' => 'Inukjuak',
		'CAAKULIVIK' => 'Akulivik',
		'CASALLUIT' => 'Salluit',
		'CAKANGIQSUJUAQ' => 'Kangiqsujuaq',
		'CAQUAQTAQ' => 'Quaqtaq',
		'CAKANGIRSUK' => 'Kangirsuk',
		'CAAUPALUK' => 'Aupaluk',
		'CATASIUJAQ' => 'Tasiujaq',
		'CAKUUJJUAQ' => 'Kuujjuaq',
		'CAKANGIQSUALUJJUAQ' => 'Kangiqsualujjuaq',
		'CAIVUJIVIK' => 'Ivujivik',
		'CARIVIRE-KOKSOAK' => 'Rivire-Koksoak',
		'CABAIE-DHUDSON' => 'Baie-dHudson',
	],
	'ON' => [
		'CASOUTH_GLENGARRY' => 'South Glengarry',
		'CAAKWESASNE_(PART)_59' => 'Akwesasne (Part) 59',
		'CASOUTH_STORMONT' => 'South Stormont',
		'CACORNWALL' => 'Cornwall',
		'CASOUTH_DUNDAS' => 'South Dundas',
		'CANORTH_DUNDAS' => 'North Dundas',
		'CANORTH_STORMONT' => 'North Stormont',
		'CANORTH_GLENGARRY' => 'North Glengarry',
		'CAEAST_HAWKESBURY' => 'East Hawkesbury',
		'CAHAWKESBURY' => 'Hawkesbury',
		'CACHAMPLAIN' => 'Champlain',
		'CAALFRED_AND_PLANTAGENET' => 'Alfred and Plantagenet',
		'CATHE_NATION' => 'The Nation',
		'CACLARENCE-ROCKLAND' => 'Clarence-Rockland',
		'CACASSELMAN' => 'Casselman',
		'CARUSSELL' => 'Russell',
		'CAOTTAWA' => 'Ottawa',
		'CAEDWARDSBURGH/CARDINAL' => 'Edwardsburgh/Cardinal',
		'CAAUGUSTA' => 'Augusta',
		'CAPRESCOTT' => 'Prescott',
		'CAELIZABETHTOWN-KITLEY' => 'Elizabethtown-Kitley',
		'CABROCKVILLE' => 'Brockville',
		'CAFRONT_OF_YONGE' => 'Front of Yonge',
		'CALEEDS_AND_THE_THOUSAND_ISLANDS' => 'Leeds and the Thousand Islands',
		'CAGANANOQUE' => 'Gananoque',
		'CAWESTPORT' => 'Westport',
		'CARIDEAU_LAKES' => 'Rideau Lakes',
		'CAATHENS' => 'Athens',
		'CAMERRICKVILLE-WOLFORD' => 'Merrickville-Wolford',
		'CANORTH_GRENVILLE' => 'North Grenville',
		'CAMONTAGUE' => 'Montague',
		'CASMITHS_FALLS' => 'Smiths Falls',
		'CADRUMMOND/NORTH_ELMSLEY' => 'Drummond/North Elmsley',
		'CATAY_VALLEY' => 'Tay Valley',
		'CAPERTH' => 'Perth',
		'CABECKWITH' => 'Beckwith',
		'CACARLETON_PLACE' => 'Carleton Place',
		'CAMISSISSIPPI_MILLS' => 'Mississippi Mills',
		'CALANARK_HIGHLANDS' => 'Lanark Highlands',
		'CAFRONTENAC_ISLANDS' => 'Frontenac Islands',
		'CAKINGSTON' => 'Kingston',
		'CASOUTH_FRONTENAC' => 'South Frontenac',
		'CACENTRAL_FRONTENAC' => 'Central Frontenac',
		'CANORTH_FRONTENAC' => 'North Frontenac',
		'CALOYALIST' => 'Loyalist',
		'CAGREATER_NAPANEE' => 'Greater Napanee',
		'CASTONE_MILLS' => 'Stone Mills',
		'CAADDINGTON_HIGHLANDS' => 'Addington Highlands',
		'CATYENDINAGA' => 'Tyendinaga',
		'CADESERONTO' => 'Deseronto',
		'CATYENDINAGA_MOHAWK_TERRITORY' => 'Tyendinaga Mohawk Territory',
		'CABELLEVILLE' => 'Belleville',
		'CAQUINTE_WEST' => 'Quinte West',
		'CASTIRLING-RAWDON' => 'Stirling-Rawdon',
		'CACENTRE_HASTINGS' => 'Centre Hastings',
		'CATWEED' => 'Tweed',
		'CAMADOC' => 'Madoc',
		'CAMARMORA_AND_LAKE' => 'Marmora and Lake',
		'CATUDOR_AND_CASHEL' => 'Tudor and Cashel',
		'CALIMERICK' => 'Limerick',
		'CAWOLLASTON' => 'Wollaston',
		'CAFARADAY' => 'Faraday',
		'CABANCROFT' => 'Bancroft',
		'CACARLOW/MAYO' => 'Carlow/Mayo',
		'CAHASTINGS_HIGHLANDS' => 'Hastings Highlands',
		'CAPRINCE_EDWARD_COUNTY' => 'Prince Edward County',
		'CABRIGHTON' => 'Brighton',
		'CACRAMAHE' => 'Cramahe',
		'CAHAMILTON' => 'Hamilton',
		'CAPORT_HOPE' => 'Port Hope',
		'CACOBOURG' => 'Cobourg',
		'CAALNWICK/HALDIMAND' => 'Alnwick/Haldimand',
		'CAALDERVILLE_FIRST_NATION' => 'Alderville First Nation',
		'CATRENT_HILLS' => 'Trent Hills',
		'CAASPHODEL-NORWOOD' => 'Asphodel-Norwood',
		'CAOTONABEE-SOUTH_MONAGHAN' => 'Otonabee-South Monaghan',
		'CAHIAWATHA_FIRST_NATION' => 'Hiawatha First Nation',
		'CACAVAN_MONAGHAN' => 'Cavan Monaghan',
		'CAPETERBOROUGH' => 'Peterborough',
		'CASELWYN' => 'Selwyn',
		'CACURVE_LAKE_FIRST_NATION_35' => 'Curve Lake First Nation 35',
		'CADOURO-DUMMER' => 'Douro-Dummer',
		'CAHAVELOCK-BELMONT-METHUEN' => 'Havelock-Belmont-Methuen',
		'CANORTH_KAWARTHA' => 'North Kawartha',
		'CATRENT_LAKES' => 'Trent Lakes',
		'CAKAWARTHA_LAKES' => 'Kawartha Lakes',
		'CAPICKERING' => 'Pickering',
		'CAAJAX' => 'Ajax',
		'CAWHITBY' => 'Whitby',
		'CAOSHAWA' => 'Oshawa',
		'CACLARINGTON' => 'Clarington',
		'CASCUGOG' => 'Scugog',
		'CAMISSISSAUGAS_OF_SCUGOG_ISLAND' => 'Mississaugas of Scugog Island',
		'CAUXBRIDGE' => 'Uxbridge',
		'CABROCK' => 'Brock',
		'CAVAUGHAN' => 'Vaughan',
		'CAMARKHAM' => 'Markham',
		'CARICHMOND_HILL' => 'Richmond Hill',
		'CAWHITCHURCH-STOUFFVILLE' => 'Whitchurch-Stouffville',
		'CAAURORA' => 'Aurora',
		'CANEWMARKET' => 'Newmarket',
		'CAKING' => 'King',
		'CAEAST_GWILLIMBURY' => 'East Gwillimbury',
		'CAGEORGINA' => 'Georgina',
		'CACHIPPEWAS_OF_GEORGINA_ISLAND_FIRST_N' => 'Chippewas of Georgina Island First Nation',
		'CATORONTO' => 'Toronto',
		'CAMISSISSAUGA' => 'Mississauga',
		'CABRAMPTON' => 'Brampton',
		'CACALEDON' => 'Caledon',
		'CAEAST_GARAFRAXA' => 'East Garafraxa',
		'CAAMARANTH' => 'Amaranth',
		'CAGRAND_VALLEY' => 'Grand Valley',
		'CAMONO' => 'Mono',
		'CAORANGEVILLE' => 'Orangeville',
		'CAMULMUR' => 'Mulmur',
		'CAMELANCTHON' => 'Melancthon',
		'CASHELBURNE' => 'Shelburne',
		'CAPUSLINCH' => 'Puslinch',
		'CAGUELPH' => 'Guelph',
		'CAGUELPH/ERAMOSA' => 'Guelph/Eramosa',
		'CAERIN' => 'Erin',
		'CACENTRE_WELLINGTON' => 'Centre Wellington',
		'CAMAPLETON' => 'Mapleton',
		'CAMINTO' => 'Minto',
		'CAWELLINGTON_NORTH' => 'Wellington North',
		'CAOAKVILLE' => 'Oakville',
		'CAONBURLINGTON' => 'Burlington',
		'CAMILTON' => 'Milton',
		'CAHALTON_HILLS' => 'Halton Hills',
		'CAHAMILTON' => 'Hamilton',
		'CAFORT_ERIE' => 'Fort Erie',
		'CAPORT_COLBORNE' => 'Port Colborne',
		'CAWAINFLEET' => 'Wainfleet',
		'CAWEST_LINCOLN' => 'West Lincoln',
		'CAPELHAM' => 'Pelham',
		'CAWELLAND' => 'Welland',
		'CATHOROLD' => 'Thorold',
		'CANIAGARA_FALLS' => 'Niagara Falls',
		'CANIAGARA-ON-THE-LAKE' => 'Niagara-on-the-Lake',
		'CAST._CATHARINES' => 'St. Catharines',
		'CALINCOLN' => 'Lincoln',
		'CAGRIMSBY' => 'Grimsby',
		'CAHALDIMAND_COUNTY' => 'Haldimand County',
		'CANEW_CREDIT_(PART)_40A' => 'New Credit (Part) 40A',
		'CASIX_NATIONS_(PART)_40' => 'Six Nations (Part) 40',
		'CANORFOLK_COUNTY' => 'Norfolk County',
		'CABRANT' => 'Brant',
		'CABRANTFORD' => 'Brantford',
		'CASIX_NATIONS_(PART)_40' => 'Six Nations (Part) 40',
		'CANEW_CREDIT_(PART)_40A' => 'New Credit (Part) 40A',
		'CANORTH_DUMFRIES' => 'North Dumfries',
		'CACAMBRIDGE' => 'Cambridge',
		'CAKITCHENER' => 'Kitchener',
		'CAWATERLOO' => 'Waterloo',
		'CAWILMOT' => 'Wilmot',
		'CAWELLESLEY' => 'Wellesley',
		'CAWOOLWICH' => 'Woolwich',
		'CASTRATFORD' => 'Stratford',
		'CAPERTH_SOUTH' => 'Perth South',
		'CAST._MARYS' => 'St. Marys',
		'CAWEST_PERTH' => 'West Perth',
		'CAPERTH_EAST' => 'Perth East',
		'CANORTH_PERTH' => 'North Perth',
		'CANORWICH' => 'Norwich',
		'CATILLSONBURG' => 'Tillsonburg',
		'CASOUTH-WEST_OXFORD' => 'South-West Oxford',
		'CAINGERSOLL' => 'Ingersoll',
		'CAZORRA' => 'Zorra',
		'CAEAST_ZORRA-TAVISTOCK' => 'East Zorra-Tavistock',
		'CAWOODSTOCK' => 'Woodstock',
		'CABLANDFORD-BLENHEIM' => 'Blandford-Blenheim',
		'CABAYHAM' => 'Bayham',
		'CAMALAHIDE' => 'Malahide',
		'CAAYLMER' => 'Aylmer',
		'CACENTRAL_ELGIN' => 'Central Elgin',
		'CAST._THOMAS' => 'St. Thomas',
		'CASOUTHWOLD' => 'Southwold',
		'CADUTTON/DUNWICH' => 'Dutton/Dunwich',
		'CAWEST_ELGIN' => 'West Elgin',
		'CACHATHAM-KENT' => 'Chatham-Kent',
		'CAMORAVIAN_47' => 'Moravian 47',
		'CAPELEE' => 'Pelee',
		'CALEAMINGTON' => 'Leamington',
		'CAKINGSVILLE' => 'Kingsville',
		'CAESSEX' => 'Essex',
		'CAAMHERSTBURG' => 'Amherstburg',
		'CALASALLE' => 'LaSalle',
		'CAWINDSOR' => 'Windsor',
		'CATECUMSEH' => 'Tecumseh',
		'CALAKESHORE' => 'Lakeshore',
		'CAST._CLAIR' => 'St. Clair',
		'CAWALPOLE_ISLAND_46' => 'Walpole Island 46',
		'CADAWN-EUPHEMIA' => 'Dawn-Euphemia',
		'CABROOKE-ALVINSTON' => 'Brooke-Alvinston',
		'CAENNISKILLEN' => 'Enniskillen',
		'CAOIL_SPRINGS' => 'Oil Springs',
		'CAPETROLIA' => 'Petrolia',
		'CASARNIA_45' => 'Sarnia 45',
		'CASARNIA' => 'Sarnia',
		'CAPOINT_EDWARD' => 'Point Edward',
		'CAPLYMPTON-WYOMING' => 'Plympton-Wyoming',
		'CALAMBTON_SHORES' => 'Lambton Shores',
		'CAWARWICK' => 'Warwick',
		'CAKETTLE_POINT_44' => 'Kettle Point 44',
		'CANEWBURY' => 'Newbury',
		'CASOUTHWEST_MIDDLESEX' => 'Southwest Middlesex',
		'CASTRATHROY-CARADOC' => 'Strathroy-Caradoc',
		'CACHIPPEWAS_OF_THE_THAMES_FIRST_NATION' => 'Chippewas of the Thames First Nation 42',
		'CAMUNSEE-DELAWARE_NATION_1' => 'Munsee-Delaware Nation 1',
		'CAONEIDA_41' => 'Oneida 41',
		'CATHAMES_CENTRE' => 'Thames Centre',
		'CAMIDDLESEX_CENTRE' => 'Middlesex Centre',
		'CALONDON' => 'London',
		'CANORTH_MIDDLESEX' => 'North Middlesex',
		'CAADELAIDE-METCALFE' => 'Adelaide-Metcalfe',
		'CALUCAN_BIDDULPH' => 'Lucan Biddulph',
		'CASOUTH_HURON' => 'South Huron',
		'CABLUEWATER' => 'Bluewater',
		'CACENTRAL_HURON' => 'Central Huron',
		'CAGODERICH' => 'Goderich',
		'CAHURON_EAST' => 'Huron East',
		'CAHOWICK' => 'Howick',
		'CAMORRIS-TURNBERRY' => 'Morris-Turnberry',
		'CANORTH_HURON' => 'North Huron',
		'CAASHFIELD-COLBORNE-WAWANOSH' => 'Ashfield-Colborne-Wawanosh',
		'CASOUTH_BRUCE' => 'South Bruce',
		'CAHURON-KINLOSS' => 'Huron-Kinloss',
		'CAKINCARDINE' => 'Kincardine',
		'CABROCKTON' => 'Brockton',
		'CAARRAN-ELDERSLIE' => 'Arran-Elderslie',
		'CASAUGEEN_SHORES' => 'Saugeen Shores',
		'CASOUTH_BRUCE_PENINSULA' => 'South Bruce Peninsula',
		'CACHIEFS_POINT_NO._28' => 'Chiefs Point No. 28',
		'CASAUGEEN_29' => 'Saugeen 29',
		'CANEYAASHIINIGMIING_27' => 'Neyaashiinigmiing 27',
		'CANORTHERN_BRUCE_PENINSULA' => 'Northern Bruce Peninsula',
		'CAWEST_GREY' => 'West Grey',
		'CASOUTHGATE' => 'Southgate',
		'CAGREY_HIGHLANDS' => 'Grey Highlands',
		'CAHANOVER' => 'Hanover',
		'CACHATSWORTH' => 'Chatsworth',
		'CATHE_BLUE_MOUNTAINS' => 'The Blue Mountains',
		'CAMEAFORD' => 'Meaford',
		'CAGEORGIAN_BLUFFS' => 'Georgian Bluffs',
		'CAOWEN_SOUND' => 'Owen Sound',
		'CAADJALA-TOSORONTIO' => 'Adjala-Tosorontio',
		'CACLEARVIEW' => 'Clearview',
		'CANEW_TECUMSETH' => 'New Tecumseth',
		'CASPRINGWATER' => 'Springwater',
		'CABRADFORD_WEST_GWILLIMBURY' => 'Bradford West Gwillimbury',
		'CASEVERN' => 'Severn',
		'CAINNISFIL' => 'Innisfil',
		'CARAMARA' => 'Ramara',
		'CAESSA' => 'Essa',
		'CAORO-MEDONTE' => 'Oro-Medonte',
		'CACOLLINGWOOD' => 'Collingwood',
		'CABARRIE' => 'Barrie',
		'CAMNJIKANING_FIRST_NATION_32' => 'Mnjikaning First Nation 32',
		'CAORILLIA' => 'Orillia',
		'CAWASAGA_BEACH' => 'Wasaga Beach',
		'CATINY' => 'Tiny',
		'CACHRISTIAN_ISLAND_30' => 'Christian Island 30',
		'CACHRISTIAN_ISLAND_30A' => 'Christian Island 30A',
		'CATAY' => 'Tay',
		'CAPENETANGUISHENE' => 'Penetanguishene',
		'CAMIDLAND' => 'Midland',
		'CAGRAVENHURST' => 'Gravenhurst',
		'CABRACEBRIDGE' => 'Bracebridge',
		'CALAKE_OF_BAYS' => 'Lake of Bays',
		'CAHUNTSVILLE' => 'Huntsville',
		'CAMUSKOKA_LAKES' => 'Muskoka Lakes',
		'CAGEORGIAN_BAY' => 'Georgian Bay',
		'CAWAHTA_MOHAWK_TERRITORY' => 'Wahta Mohawk Territory',
		'CAMOOSE_POINT_79' => 'Moose Point 79',
		'CAHIGHLANDS_EAST' => 'Highlands East',
		'CAMINDEN_HILLS' => 'Minden Hills',
		'CAALGONQUIN_HIGHLANDS' => 'Algonquin Highlands',
		'CADYSART_ET_AL' => 'Dysart et al',
		'CAARNPRIOR' => 'Arnprior',
		'CAMCNAB/BRAESIDE' => 'McNab/Braeside',
		'CAGREATER_MADAWASKA' => 'Greater Madawaska',
		'CABRUDENELL,_LYNDOCH_AND_RAGLAN' => 'Brudenell, Lyndoch and Raglan',
		'CAMADAWASKA_VALLEY' => 'Madawaska Valley',
		'CAKILLALOE,_HAGARTY_AND_RICHARDS' => 'Killaloe, Hagarty and Richards',
		'CABONNECHERE_VALLEY' => 'Bonnechere Valley',
		'CAPIKWAKANAGAN_(GOLDEN_LAKE_39)' => 'Pikwakanagan (Golden Lake 39)',
		'CAADMASTON/BROMLEY' => 'Admaston/Bromley',
		'CAHORTON' => 'Horton',
		'CARENFREW' => 'Renfrew',
		'CAWHITEWATER_REGION' => 'Whitewater Region',
		'CAPEMBROKE' => 'Pembroke',
		'CANORTH_ALGONA_WILBERFORCE' => 'North Algona Wilberforce',
		'CALAURENTIAN_VALLEY' => 'Laurentian Valley',
		'CAPETAWAWA' => 'Petawawa',
		'CALAURENTIAN_HILLS' => 'Laurentian Hills',
		'CADEEP_RIVER' => 'Deep River',
		'CAHEAD,_CLARA_AND_MARIA' => 'Head, Clara and Maria',
		'CASOUTH_ALGONQUIN' => 'South Algonquin',
		'CAPAPINEAU-CAMERON' => 'Papineau-Cameron',
		'CAMATTAWAN' => 'Mattawan',
		'CAMATTAWA' => 'Mattawa',
		'CACALVIN' => 'Calvin',
		'CABONFIELD' => 'Bonfield',
		'CACHISHOLM' => 'Chisholm',
		'CAEAST_FERRIS' => 'East Ferris',
		'CANORTH_BAY' => 'North Bay',
		'CAWEST_NIPISSING' => 'West Nipissing',
		'CATEMAGAMI' => 'Temagami',
		'CABEAR_ISLAND_1' => 'Bear Island 1',
		'CANIPISSING_10' => 'Nipissing 10',
		'CANIPISSING,_UNORGANIZED,_SOUTH_PART' => 'Nipissing, Unorganized, South Part',
		'CANIPISSING,_UNORGANIZED,_NORTH_PART' => 'Nipissing, Unorganized, North Part',
		'CASEGUIN' => 'Seguin',
		'CATHE_ARCHIPELAGO' => 'The Archipelago',
		'CAMCMURRICH/MONTEITH' => 'McMurrich/Monteith',
		'CAPERRY' => 'Perry',
		'CAKEARNEY' => 'Kearney',
		'CAARMOUR' => 'Armour',
		'CABURKS_FALLS' => 'Burks Falls',
		'CARYERSON' => 'Ryerson',
		'CAMCKELLAR' => 'McKellar',
		'CAMCDOUGALL' => 'McDougall',
		'CAPARRY_SOUND' => 'Parry Sound',
		'CACARLING' => 'Carling',
		'CAWHITESTONE' => 'Whitestone',
		'CAMAGNETAWAN' => 'Magnetawan',
		'CASTRONG' => 'Strong',
		'CASUNDRIDGE' => 'Sundridge',
		'CAJOLY' => 'Joly',
		'CAMACHAR' => 'Machar',
		'CASOUTH_RIVER' => 'South River',
		'CAPOWASSAN' => 'Powassan',
		'CACALLANDER' => 'Callander',
		'CANIPISSING' => 'Nipissing',
		'CASHAWANAGA_17' => 'Shawanaga 17',
		'CAPARRY_ISLAND_FIRST_NATION' => 'Parry Island First Nation',
		'CAHENVEY_INLET_2' => 'Henvey Inlet 2',
		'CAFRENCH_RIVER_13' => 'French River 13',
		'CADOKIS_9' => 'Dokis 9',
		'CAMAGNETEWAN_1' => 'Magnetewan 1',
		'CAPARRY_SOUND,_UNORGANIZED,_NORTH_EAST' => 'Parry Sound, Unorganized, North East Part',
		'CAPARRY_SOUND,_UNORGANIZED,_CENTRE_PAR' => 'Parry Sound, Unorganized, Centre Part',
		'CATEHKUMMAH' => 'Tehkummah',
		'CACENTRAL_MANITOULIN' => 'Central Manitoulin',
		'CAASSIGINACK' => 'Assiginack',
		'CANORTHEASTERN_MANITOULIN_AND_THE_ISLA' => 'Northeastern Manitoulin and the Islands',
		'CABILLINGS' => 'Billings',
		'CAGORE_BAY' => 'Gore Bay',
		'CAGORDON/BARRIE_ISLAND' => 'Gordon/Barrie Island',
		'CABURPEE_AND_MILLS' => 'Burpee and Mills',
		'CACOCKBURN_ISLAND' => 'Cockburn Island',
		'CAWHITEFISH_RIVER_(PART)_4' => 'Whitefish River (Part) 4',
		'CASUCKER_CREEK_23' => 'Sucker Creek 23',
		'CASHEGUIANDAH_24' => 'Sheguiandah 24',
		'CAWIKWEMIKONG_UNCEDED' => 'Wikwemikong Unceded',
		'CASHESHEGWANING_20' => 'Sheshegwaning 20',
		'CAMCHIGEENG_22_(WEST_BAY_22)' => 'MChigeeng 22 (West Bay 22)',
		'CAMANITOULIN,_UNORGANIZED,_WEST_PART' => 'Manitoulin, Unorganized, West Part',
		'CAZHIIBAAHAASING_19A_(COCKBURN_ISLAND_' => 'Zhiibaahaasing 19A (Cockburn Island 19A)',
		'CAFRENCH_RIVER' => 'French River',
		'CAST.-CHARLES' => 'St.-Charles',
		'CAMARKSTAY-WARREN' => 'Markstay-Warren',
		'CASABLES-SPANISH_RIVERS' => 'Sables-Spanish Rivers',
		'CAESPANOLA' => 'Espanola',
		'CABALDWIN' => 'Baldwin',
		'CANAIRN_AND_HYMAN' => 'Nairn and Hyman',
		'CAKILLARNEY' => 'Killarney',
		'CAWHITEFISH_LAKE_6' => 'Whitefish Lake 6',
		'CAMATTAGAMI_71' => 'Mattagami 71',
		'CACHAPLEAU_74A' => 'Chapleau 74A',
		'CADUCK_LAKE_76B' => 'Duck Lake 76B',
		'CACHAPLEAU_75' => 'Chapleau 75',
		'CACHAPLEAU' => 'Chapleau',
		'CASUDBURY,_UNORGANIZED,_NORTH_PART' => 'Sudbury, Unorganized, North Part',
		'CAGREATER_SUDBURY' => 'Greater Sudbury',
		'CAWAHNAPITEI_11' => 'Wahnapitei 11',
		'CACOLEMAN' => 'Coleman',
		'CALATCHFORD' => 'Latchford',
		'CACOBALT' => 'Cobalt',
		'CAHARRIS' => 'Harris',
		'CATEMISKAMING_SHORES' => 'Temiskaming Shores',
		'CAHUDSON' => 'Hudson',
		'CAKERNS' => 'Kerns',
		'CAHARLEY' => 'Harley',
		'CACASEY' => 'Casey',
		'CABRETHOUR' => 'Brethour',
		'CAHILLIARD' => 'Hilliard',
		'CAARMSTRONG' => 'Armstrong',
		'CATHORNLOE' => 'Thornloe',
		'CAJAMES' => 'James',
		'CACHARLTON_AND_DACK' => 'Charlton and Dack',
		'CAEVANTUREL' => 'Evanturel',
		'CAENGLEHART' => 'Englehart',
		'CACHAMBERLAIN' => 'Chamberlain',
		'CAMATACHEWAN' => 'Matachewan',
		'CAMATACHEWAN_72' => 'Matachewan 72',
		'CAMCGARRY' => 'McGarry',
		'CALARDER_LAKE' => 'Larder Lake',
		'CAGAUTHIER' => 'Gauthier',
		'CAKIRKLAND_LAKE' => 'Kirkland Lake',
		'CATIMISKAMING,_UNORGANIZED,_EAST_PART' => 'Timiskaming, Unorganized, East Part',
		'CATIMISKAMING,_UNORGANIZED,_WEST_PART' => 'Timiskaming, Unorganized, West Part',
		'CABLACK_RIVER-MATHESON' => 'Black River-Matheson',
		'CATIMMINS' => 'Timmins',
		'CAIROQUOIS_FALLS' => 'Iroquois Falls',
		'CAABITIBI_70' => 'Abitibi 70',
		'CACOCHRANE' => 'Cochrane',
		'CASMOOTH_ROCK_FALLS' => 'Smooth Rock Falls',
		'CAFAUQUIER-STRICKLAND' => 'Fauquier-Strickland',
		'CAMOONBEAM' => 'Moonbeam',
		'CAKAPUSKASING' => 'Kapuskasing',
		'CAVAL_RITA-HARTY' => 'Val Rita-Harty',
		'CAOPASATIKA' => 'Opasatika',
		'CAHEARST' => 'Hearst',
		'CAMATTICE-VAL_CT' => 'Mattice-Val Ct',
		'CACOCHRANE,_UNORGANIZED,_SOUTH_WEST_PA' => 'Cochrane, Unorganized, South West Part',
		'CACOCHRANE,_UNORGANIZED,_NORTH_PART' => 'Cochrane, Unorganized, North Part',
		'CAFORT_ALBANY_(PART)_67' => 'Fort Albany (Part) 67',
		'CAFACTORY_ISLAND_1' => 'Factory Island 1',
		'CACONSTANCE_LAKE_92' => 'Constance Lake 92',
		'CAMOOSE_FACTORY_68' => 'Moose Factory 68',
		'CACOCHRANE,_UNORGANIZED,_SOUTH_EAST_PA' => 'Cochrane, Unorganized, South East Part',
		'CAFLYING_POST_73' => 'Flying Post 73',
		'CANEW_POST_69A' => 'New Post 69A',
		'CAMOOSONEE' => 'Moosonee',
		'CAJOCELYN' => 'Jocelyn',
		'CAHILTON' => 'Hilton',
		'CAHILTON_BEACH' => 'Hilton Beach',
		'CAST._JOSEPH' => 'St. Joseph',
		'CALAIRD' => 'Laird',
		'CATARBUTT_AND_TARBUTT_ADDITIONAL' => 'Tarbutt and Tarbutt Additional',
		'CAJOHNSON' => 'Johnson',
		'CAPLUMMER_ADDITIONAL' => 'Plummer Additional',
		'CABRUCE_MINES' => 'Bruce Mines',
		'CATHESSALON_12' => 'Thessalon 12',
		'CATHESSALON' => 'Thessalon',
		'CAHURON_SHORES' => 'Huron Shores',
		'CABLIND_RIVER' => 'Blind River',
		'CASPANISH' => 'Spanish',
		'CATHE_NORTH_SHORE' => 'The North Shore',
		'CAELLIOT_LAKE' => 'Elliot Lake',
		'CAMACDONALD,_MEREDITH_AND_ABERDEEN_ADD' => 'Macdonald, Meredith and Aberdeen Additional',
		'CASAULT_STE._MARIE' => 'Sault Ste. Marie',
		'CAPRINCE' => 'Prince',
		'CASAGAMOK' => 'Sagamok',
		'CASERPENT_RIVER_7' => 'Serpent River 7',
		'CAMISSISSAGI_RIVER_8' => 'Mississagi River 8',
		'CAGARDEN_RIVER_14' => 'Garden River 14',
		'CARANKIN_LOCATION_15D' => 'Rankin Location 15D',
		'CAWAWA' => 'Wawa',
		'CAGOULAIS_BAY_15A' => 'Goulais Bay 15A',
		'CAGROS_CAP_49' => 'Gros Cap 49',
		'CADUBREUILVILLE' => 'Dubreuilville',
		'CAWHITE_RIVER' => 'White River',
		'CAALGOMA,_UNORGANIZED,_SOUTH_EAST_PART' => 'Algoma, Unorganized, South East Part',
		'CAALGOMA,_UNORGANIZED,_NORTH_PART' => 'Algoma, Unorganized, North Part',
		'CAHORNEPAYNE' => 'Hornepayne',
		'CANEEBING' => 'Neebing',
		'CAFORT_WILLIAM_52' => 'Fort William 52',
		'CATHUNDER_BAY' => 'Thunder Bay',
		'CAOLIVER_PAIPOONGE' => 'Oliver Paipoonge',
		'CAGILLIES' => 'Gillies',
		'CAOCONNOR' => 'OConnor',
		'CACONMEE' => 'Conmee',
		'CASHUNIAH' => 'Shuniah',
		'CADORION' => 'Dorion',
		'CARED_ROCK' => 'Red Rock',
		'CANIPIGON' => 'Nipigon',
		'CASCHREIBER' => 'Schreiber',
		'CATERRACE_BAY' => 'Terrace Bay',
		'CAMARATHON' => 'Marathon',
		'CAPIC_MOBERT_NORTH' => 'Pic Mobert North',
		'CAPIC_MOBERT_SOUTH' => 'Pic Mobert South',
		'CAPIC_RIVER_50' => 'Pic River 50',
		'CAPAYS_PLAT_51' => 'Pays Plat 51',
		'CALAKE_HELEN_53A' => 'Lake Helen 53A',
		'CAGULL_RIVER_55' => 'Gull River 55',
		'CAMANITOUWADGE' => 'Manitouwadge',
		'CAGINOOGAMING_FIRST_NATION' => 'Ginoogaming First Nation',
		'CALONG_LAKE_58' => 'Long Lake 58',
		'CAROCKY_BAY_1' => 'Rocky Bay 1',
		'CAGREENSTONE' => 'Greenstone',
		'CAAROLAND_83' => 'Aroland 83',
		'CALAKE_NIPIGON' => 'Lake Nipigon',
		'CAOJIBWAY_NATION_OF_SAUGEEN_(SAVANT_LA' => 'Ojibway Nation of Saugeen (Savant Lake)',
		'CAOSNABURGH_63A' => 'Osnaburgh 63A',
		'CATHUNDER_BAY,_UNORGANIZED' => 'Thunder Bay, Unorganized',
		'CASEINE_RIVER_22A2' => 'Seine River 22A2',
		'CAWHITESAND' => 'Whitesand',
		'CALAC_DES_MILLE_LACS_22A1' => 'Lac des Mille Lacs 22A1',
		'CAATIKOKAN' => 'Atikokan',
		'CAALBERTON' => 'Alberton',
		'CAFORT_FRANCES' => 'Fort Frances',
		'CALA_VALLEE' => 'La Vallee',
		'CAEMO' => 'Emo',
		'CACHAPPLE' => 'Chapple',
		'CAMANITOU_RAPIDS_11' => 'Manitou Rapids 11',
		'CALONG_SAULT_12' => 'Long Sault 12',
		'CAMORLEY' => 'Morley',
		'CADAWSON' => 'Dawson',
		'CARAINY_RIVER' => 'Rainy River',
		'CALAKE_OF_THE_WOODS' => 'Lake of the Woods',
		'CASABASKONG_BAY_(PART)_35C' => 'Sabaskong Bay (Part) 35C',
		'CABIG_GRASSY_RIVER_35G' => 'Big Grassy River 35G',
		'CABIG_ISLAND_MAINLAND_93' => 'Big Island Mainland 93',
		'CASAUG-A-GAW-SING_1' => 'Saug-a-Gaw-Sing 1',
		'CANEGUAGUON_LAKE_25D' => 'Neguaguon Lake 25D',
		'CARAINY_LAKE_18C' => 'Rainy Lake 18C',
		'CAAGENCY_1' => 'Agency 1',
		'CACOUCHICHING_16A' => 'Couchiching 16A',
		'CARAINY_LAKE_26A' => 'Rainy Lake 26A',
		'CASEINE_RIVER_23B' => 'Seine River 23B',
		'CASEINE_RIVER_23A' => 'Seine River 23A',
		'CARAINY_LAKE_17A' => 'Rainy Lake 17A',
		'CARAINY_LAKE_17B' => 'Rainy Lake 17B',
		'CARAINY_RIVER,_UNORGANIZED' => 'Rainy River, Unorganized',
		'CAIGNACE' => 'Ignace',
		'CAWHITEFISH_BAY_32A' => 'Whitefish Bay 32A',
		'CAWHITEFISH_BAY_33A' => 'Whitefish Bay 33A',
		'CASABASKONG_BAY_(PART)_35C' => 'Sabaskong Bay (Part) 35C',
		'CASIOUX_NARROWS-NESTOR_FALLS' => 'Sioux Narrows-Nestor Falls',
		'CAKENORA' => 'Kenora',
		'CAMACHIN' => 'Machin',
		'CAEAGLE_LAKE_27' => 'Eagle Lake 27',
		'CADRYDEN' => 'Dryden',
		'CAEAR_FALLS' => 'Ear Falls',
		'CASIOUX_LOOKOUT' => 'Sioux Lookout',
		'CARED_LAKE' => 'Red Lake',
		'CASLATE_FALLS' => 'Slate Falls',
		'CAPICKLE_LAKE' => 'Pickle Lake',
		'CAFORT_ALBANY_(PART)_67' => 'Fort Albany (Part) 67',
		'CAATTAWAPISKAT_91A' => 'Attawapiskat 91A',
		'CAMARTEN_FALLS_65' => 'Marten Falls 65',
		'CAFORT_HOPE_64' => 'Fort Hope 64',
		'CACAT_LAKE_63C' => 'Cat Lake 63C',
		'CAOSNABURGH_63B' => 'Osnaburgh 63B',
		'CALAC_SEUL_28' => 'Lac Seul 28',
		'CAWABIGOON_LAKE_27' => 'Wabigoon Lake 27',
		'CAENGLISH_RIVER_21' => 'English River 21',
		'CAWEAGAMOW_LAKE_87' => 'Weagamow Lake 87',
		'CANORTHWEST_ANGLE_33B' => 'Northwest Angle 33B',
		'CAWABASEEMOONG' => 'Wabaseemoong',
		'CASABASKONG_BAY_35D' => 'Sabaskong Bay 35D',
		'CASHOAL_LAKE_34B2' => 'Shoal Lake 34B2',
		'CALAKE_OF_THE_WOODS_37' => 'Lake Of The Woods 37',
		'CAKENORA_38B' => 'Kenora 38B',
		'CAPOPLAR_HILL' => 'Poplar Hill',
		'CASHOAL_LAKE_(PART)_39A' => 'Shoal Lake (Part) 39A',
		'CARAT_PORTAGE_38A' => 'Rat Portage 38A',
		'CADEER_LAKE' => 'Deer Lake',
		'CASANDY_LAKE_88' => 'Sandy Lake 88',
		'CAKITCHENUHMAYKOOSIB_AAKI_84_(BIG_TROU' => 'Kitchenuhmaykoosib Aaki 84 (Big Trout Lake)',
		'CASACHIGO_LAKE_1' => 'Sachigo Lake 1',
		'CAPIKANGIKUM_14' => 'Pikangikum 14',
		'CAFORT_SEVERN_89' => 'Fort Severn 89',
		'CAWEBEQUIE' => 'Webequie',
		'CANORTH_SPIRIT_LAKE' => 'North Spirit Lake',
		'CALANSDOWNE_HOUSE' => 'Lansdowne House',
		'CASHOAL_LAKE_(PART)_40' => 'Shoal Lake (Part) 40',
		'CAWHITEFISH_BAY_34A' => 'Whitefish Bay 34A',
		'CAWABAUSKANG_21' => 'Wabauskang 21',
		'CAWUNNUMIN_1' => 'Wunnumin 1',
		'CASUMMER_BEAVER' => 'Summer Beaver',
		'CAWAPEKEKA_2' => 'Wapekeka 2',
		'CATHE_DALLES_38C' => 'The Dalles 38C',
		'CAKENORA,_UNORGANIZED' => 'Kenora, Unorganized',
		'CAPEAWANUCK' => 'Peawanuck',
		'CANESKANTAGA' => 'Neskantaga',
		'CABEARSKIN_LAKE' => 'Bearskin Lake',
		'CAKASABONIKA_LAKE' => 'Kasabonika Lake',
		'CAMUSKRAT_DAM_LAKE' => 'Muskrat Dam Lake',
		'CAKINGFISHER_LAKE_1' => 'Kingfisher Lake 1',
		'CAWAWAKAPEWIN_(LONG_DOG_LAKE)' => 'Wawakapewin (Long Dog Lake)',
		'CAMCDOWELL_LAKE' => 'McDowell Lake',
		'CAKEE-WAY-WIN' => 'Kee-Way-Win',
	],
	'MB' => [
		'CASTUARTBURN' => 'Stuartburn',
		'CAPINEY' => 'Piney',
		'CAREYNOLDS' => 'Reynolds',
		'CAWHITEMOUTH' => 'Whitemouth',
		'CAPINAWA' => 'Pinawa',
		'CALAC_DU_BONNET' => 'Lac du Bonnet',
		'CALAC_DU_BONNET' => 'Lac du Bonnet',
		'CABUFFALO_POINT_36' => 'Buffalo Point 36',
		'CAALEXANDER' => 'Alexander',
		'CAPOWERVIEW-PINE_FALLS' => 'Powerview-Pine Falls',
		'CAVICTORIA_BEACH' => 'Victoria Beach',
		'CASHOAL_LAKE_(PART)_40' => 'Shoal Lake (Part) 40',
		'CASHOAL_LAKE_(PART)_39A' => 'Shoal Lake (Part) 39A',
		'CADIVISION_NO.__1,_UNORGANIZED' => 'Division No.  1, Unorganized',
		'CAEMERSON-FRANKLIN' => 'Emerson-Franklin',
		'CAROSEAU_RAPIDS_2A' => 'Roseau Rapids 2A',
		'CAROSEAU_RIVER_2' => 'Roseau River 2',
		'CADE_SALABERRY' => 'De Salaberry',
		'CAST-PIERRE-JOLYS' => 'St-Pierre-Jolys',
		'CAHANOVER' => 'Hanover',
		'CASTEINBACH' => 'Steinbach',
		'CANIVERVILLE' => 'Niverville',
		'CALA_BROQUERIE' => 'La Broquerie',
		'CASTE._ANNE' => 'Ste. Anne',
		'CASTE._ANNE' => 'Ste. Anne',
		'CATACH' => 'Tach',
		'CARITCHOT' => 'Ritchot',
		'CAMONTCALM' => 'Montcalm',
		'CAALTONA' => 'Altona',
		'CARHINELAND' => 'Rhineland',
		'CASTANLEY' => 'Stanley',
		'CAWINKLER' => 'Winkler',
		'CAMORDEN' => 'Morden',
		'CATHOMPSON' => 'Thompson',
		'CAROLAND' => 'Roland',
		'CAMORRIS' => 'Morris',
		'CAMORRIS' => 'Morris',
		'CADUFFERIN' => 'Dufferin',
		'CACARMAN' => 'Carman',
		'CAPEMBINA' => 'Pembina',
		'CALOUISE' => 'Louise',
		'CACARTWRIGHT-ROBLIN' => 'Cartwright-Roblin',
		'CAARGYLE' => 'Argyle',
		'CALORNE' => 'Lorne',
		'CASWAN_LAKE__7' => 'Swan Lake  7',
		'CAKILLARNEY_-_TURTLE_MOUNTAIN' => 'Killarney - Turtle Mountain',
		'CABOISSEVAIN-MORTON' => 'Boissevain-Morton',
		'CADELORAINE-WINCHESTER' => 'Deloraine-Winchester',
		'CABRENDA-WASKADA' => 'Brenda-Waskada',
		'CAMELITA' => 'Melita',
		'CATWO_BORDERS' => 'Two Borders',
		'CAGRASSLAND' => 'Grassland',
		'CAPRAIRIE_LAKES' => 'Prairie Lakes',
		'CASIFTON' => 'Sifton',
		'CAPIPESTONE' => 'Pipestone',
		'CACANUPAWAKPA_DAKOTA_FIRST_NATION_(OAK' => 'Canupawakpa Dakota First Nation (Oak Lake 59)',
		'CAWALLACE-WOODWORTH' => 'Wallace-Woodworth',
		'CAVIRDEN' => 'Virden',
		'CASIOUX_VALLEY_DAKOTA_NATION' => 'Sioux Valley Dakota Nation',
		'CAGLENBORO-SOUTH_CYPRESS' => 'Glenboro-South Cypress',
		'CAOAKLAND-WAWANESA' => 'Oakland-Wawanesa',
		'CASOURIS-GLENWOOD' => 'Souris-Glenwood',
		'CAWHITEHEAD' => 'Whitehead',
		'CACORNWALLIS' => 'Cornwallis',
		'CABRANDON' => 'Brandon',
		'CANORTH_CYPRESS-LANGFORD' => 'North Cypress-Langford',
		'CACARBERRY' => 'Carberry',
		'CAELTON' => 'Elton',
		'CARIVERDALE' => 'Riverdale',
		'CANORFOLK-TREHERNE' => 'Norfolk-Treherne',
		'CAVICTORIA' => 'Victoria',
		'CANORTH_NORFOLK' => 'North Norfolk',
		'CAGLENELLA-LANSDOWNE' => 'Glenella-Lansdowne',
		'CAWESTLAKE-GLADSTONE' => 'WestLake-Gladstone',
		'CASANDY_BAY_5' => 'Sandy Bay 5',
		'CAGREY' => 'Grey',
		'CAPORTAGE_LA_PRAIRIE' => 'Portage la Prairie',
		'CALONG_PLAIN_(PART)_6' => 'Long Plain (Part) 6',
		'CADAKOTA_PLAINS_6A' => 'Dakota Plains 6A',
		'CADAKOTA_TIPI_1' => 'Dakota Tipi 1',
		'CAPORTAGE_LA_PRAIRIE' => 'Portage la Prairie',
		'CAMACDONALD' => 'Macdonald',
		'CACARTIER' => 'Cartier',
		'CAST._FRANOIS_XAVIER' => 'St. Franois Xavier',
		'CAWINNIPEG' => 'Winnipeg',
		'CAHEADINGLEY' => 'Headingley',
		'CASPRINGFIELD' => 'Springfield',
		'CABROKENHEAD' => 'Brokenhead',
		'CABEAUSEJOUR' => 'Beausejour',
		'CAEAST_ST._PAUL' => 'East St. Paul',
		'CAWEST_ST._PAUL' => 'West St. Paul',
		'CAST._ANDREWS' => 'St. Andrews',
		'CASELKIRK' => 'Selkirk',
		'CADUNNOTTAR' => 'Dunnottar',
		'CAST._CLEMENTS' => 'St. Clements',
		'CABROKENHEAD_4' => 'Brokenhead 4',
		'CAROSSER' => 'Rosser',
		'CAWOODLANDS' => 'Woodlands',
		'CAROCKWOOD' => 'Rockwood',
		'CASTONEWALL' => 'Stonewall',
		'CATEULON' => 'Teulon',
		'CANEEPAWA' => 'Neepawa',
		'CAOAKVIEW' => 'Oakview',
		'CAHAMIOTA' => 'Hamiota',
		'CABIRDTAIL_CREEK_57' => 'Birdtail Creek 57',
		'CAELLICE-ARCHIE' => 'Ellice-Archie',
		'CAGAMBLER_63_(PART)' => 'Gambler 63 (Part)',
		'CAPRAIRIE_VIEW' => 'Prairie View',
		'CAYELLOWHEAD' => 'Yellowhead',
		'CAKEESEEKOOWENIN_61' => 'Keeseekoowenin 61',
		'CAHARRISON_PARK' => 'Harrison Park',
		'CAROLLING_RIVER_67' => 'Rolling River 67',
		'CAROLLING_RIVER_67B' => 'Rolling River 67B',
		'CAMINTO-ODANAH' => 'Minto-Odanah',
		'CAMINNEDOSA' => 'Minnedosa',
		'CAROSEDALE' => 'Rosedale',
		'CACLANWILLIAM-ERICKSON' => 'Clanwilliam-Erickson',
		'CAROSSBURN' => 'Rossburn',
		'CAWAYWAYSEECAPPO_FIRST_NATION' => 'Waywayseecappo First Nation',
		'CARIDING_MOUNTAIN_WEST' => 'Riding Mountain West',
		'CAGAMBLER_63_(PART)' => 'Gambler 63 (Part)',
		'CARUSSELL-BINSCARTH' => 'Russell-Binscarth',
		'CAVALLEY_RIVER_63A' => 'Valley River 63A',
		'CAHILLSBURG-ROBLIN-SHELL_RIVER' => 'Hillsburg-Roblin-Shell River',
		'CAALONSA' => 'Alonsa',
		'CAEBB_AND_FLOW_52' => 'Ebb and Flow 52',
		'CAMCCREARY' => 'McCreary',
		'CASTE._ROSE' => 'Ste. Rose',
		'CADAUPHIN' => 'Dauphin',
		'CADAUPHIN' => 'Dauphin',
		'CAGILBERT_PLAINS' => 'Gilbert Plains',
		'CAGRANDVIEW' => 'Grandview',
		'CAETHELBERT' => 'Ethelbert',
		'CAMOSSEY_RIVER' => 'Mossey River',
		'CALAKESHORE' => 'Lakeshore',
		'CADIVISION_NO._17,_UNORGANIZED' => 'Division No. 17, Unorganized',
		'CAGIMLI' => 'Gimli',
		'CAWINNIPEG_BEACH' => 'Winnipeg Beach',
		'CAARMSTRONG' => 'Armstrong',
		'CAST._LAURENT' => 'St. Laurent',
		'CACOLDWELL' => 'Coldwell',
		'CADOG_CREEK_46' => 'Dog Creek 46',
		'CAWEST_INTERLAKE' => 'West Interlake',
		'CAGRAHAMDALE' => 'Grahamdale',
		'CALITTLE_SASKATCHEWAN_48' => 'Little Saskatchewan 48',
		'CAFAIRFORD_(PART)_50' => 'Fairford (Part) 50',
		'CAFISHER' => 'Fisher',
		'CAARBORG' => 'Arborg',
		'CABIFROST-RIVERTON' => 'Bifrost-Riverton',
		'CADIVISION_NO._18,_UNORGANIZED,_EAST_P' => 'Division No. 18, Unorganized, East Part',
		'CADIVISION_NO._18,_UNORGANIZED,_WEST_P' => 'Division No. 18, Unorganized, West Part',
		'CADIVISION_NO._19,_UNORGANIZED' => 'Division No. 19, Unorganized',
		'CAFORT_ALEXANDER_3' => 'Fort Alexander 3',
		'CALITTLE_GRAND_RAPIDS_14' => 'Little Grand Rapids 14',
		'CABLOODVEIN_12' => 'Bloodvein 12',
		'CAHOLE_OR_HOLLOW_WATER_10' => 'Hole or Hollow Water 10',
		'CABLACK_RIVER_9' => 'Black River 9',
		'CAFISHER_RIVER_44' => 'Fisher River 44',
		'CAFISHER_RIVER_44A' => 'Fisher River 44A',
		'CAPEGUIS_1B' => 'Peguis 1B',
		'CAFAIRFORD_(PART)_50' => 'Fairford (Part) 50',
		'CAJACKHEAD_43' => 'Jackhead 43',
		'CADAUPHIN_RIVER_48A' => 'Dauphin River 48A',
		'CATHE_NARROWS_49' => 'The Narrows 49',
		'CACRANE_RIVER_51' => 'Crane River 51',
		'CAWATERHEN_45' => 'Waterhen 45',
		'CAPINE_CREEK_66A' => 'Pine Creek 66A',
		'CASWAN_LAKE_65C' => 'Swan Lake 65C',
		'CASHOAL_RIVER_INDIAN_RESERVE_65A' => 'Shoal River Indian Reserve 65A',
		'CAPOPLAR_RIVER_16' => 'Poplar River 16',
		'CABERENS_RIVER_13' => 'Berens River 13',
		'CAPAUINGASSI_FIRST_NATION' => 'Pauingassi First Nation',
		'CACHEMAWAWIN_3' => 'Chemawawin 3',
		'CAMOUNTAIN_(SOUTH)' => 'Mountain (South)',
		'CASWAN_VALLEY_WEST' => 'Swan Valley West',
		'CASWAN_RIVER' => 'Swan River',
		'CAMINITONAS-BOWSMAN' => 'Minitonas-Bowsman',
		'CAMOUNTAIN_(NORTH)' => 'Mountain (North)',
		'CADIVISION_NO._20,_UNORGANIZED,_SOUTH_' => 'Division No. 20, Unorganized, South Part',
		'CADIVISION_NO._20,_UNORGANIZED,_NORTH_' => 'Division No. 20, Unorganized, North Part',
		'CAGRAND_RAPIDS' => 'Grand Rapids',
		'CAGRAND_RAPIDS_33' => 'Grand Rapids 33',
		'CACHEMAWAWIN_2' => 'Chemawawin 2',
		'CAOPASKWAYAK_CREE_NATION_21A' => 'Opaskwayak Cree Nation 21A',
		'CAOPASKWAYAK_CREE_NATION_21B' => 'Opaskwayak Cree Nation 21B',
		'CAOPASKWAYAK_CREE_NATION_21C' => 'Opaskwayak Cree Nation 21C',
		'CAOPASKWAYAK_CREE_NATION_21I' => 'Opaskwayak Cree Nation 21I',
		'CAOPASKWAYAK_CREE_NATION_21E' => 'Opaskwayak Cree Nation 21E',
		'CATHE_PAS' => 'The Pas',
		'CAKELSEY' => 'Kelsey',
		'CAMOOSE_LAKE_31A' => 'Moose Lake 31A',
		'CAFLIN_FLON_(PART)' => 'Flin Flon (Part)',
		'CASNOW_LAKE' => 'Snow Lake',
		'CADIVISION_NO._21,_UNORGANIZED' => 'Division No. 21, Unorganized',
		'CAMYSTERY_LAKE' => 'Mystery Lake',
		'CATHOMPSON' => 'Thompson',
		'CADIVISION_NO._22,_UNORGANIZED' => 'Division No. 22, Unorganized',
		'CAGARDEN_HILL_FIRST_NATION' => 'Garden Hill First Nation',
		'CAGODS_LAKE_23' => 'Gods Lake 23',
		'CAOXFORD_HOUSE_24' => 'Oxford House 24',
		'CACROSS_LAKE_19' => 'Cross Lake 19',
		'CACROSS_LAKE_19A' => 'Cross Lake 19A',
		'CAGODS_RIVER_86A' => 'Gods River 86A',
		'CARED_SUCKER_LAKE_1976' => 'Red Sucker Lake 1976',
		'CANORWAY_HOUSE_17' => 'Norway House 17',
		'CANELSON_HOUSE_170' => 'Nelson House 170',
		'CASPLIT_LAKE_(PART)_171' => 'Split Lake (Part) 171',
		'CAILFORD' => 'Ilford',
		'CAYORK_LANDING' => 'York Landing',
		'CACROSS_LAKE_19E' => 'Cross Lake 19E',
		'CAWASAGAMACK' => 'Wasagamack',
		'CAST._THERESA_POINT' => 'St. Theresa Point',
		'CAMOOSEOCOOT' => 'Mooseocoot',
		'CAGILLAM' => 'Gillam',
		'CAGILLAM' => 'Gillam',
		'CAFOX_LAKE_2' => 'Fox Lake 2',
		'CALEAF_RAPIDS' => 'Leaf Rapids',
		'CASOUTH_INDIAN_LAKE' => 'South Indian Lake',
		'CAGRANVILLE_LAKE' => 'Granville Lake',
		'CALYNN_LAKE' => 'Lynn Lake',
		'CACHURCHILL' => 'Churchill',
		'CACHURCHILL_1' => 'Churchill 1',
		'CASPLIT_LAKE_(PART)_171' => 'Split Lake (Part) 171',
		'CADIVISION_NO._23,_UNORGANIZED' => 'Division No. 23, Unorganized',
		'CAPUKATAWAGAN_198' => 'Pukatawagan 198',
		'CABROCHET_197' => 'Brochet 197',
		'CALAC_BROCHET_197A' => 'Lac Brochet 197A',
		'CASHAMATTAWA_1' => 'Shamattawa 1',
		'CABLACK_STURGEON' => 'Black Sturgeon',
	],
	'SK' => [
		'CAARGYLE_NO._1' => 'Argyle No. 1',
		'CAGAINSBOROUGH' => 'Gainsborough',
		'CACARIEVALE' => 'Carievale',
		'CAMOUNT_PLEASANT_NO._2' => 'Mount Pleasant No. 2',
		'CACARNDUFF' => 'Carnduff',
		'CAENNISKILLEN_NO._3' => 'Enniskillen No. 3',
		'CAGLEN_EWEN' => 'Glen Ewen',
		'CAOXBOW' => 'Oxbow',
		'CACOALFIELDS_NO._4' => 'Coalfields No. 4',
		'CAFROBISHER' => 'Frobisher',
		'CANORTH_PORTAL' => 'North Portal',
		'CAROCHE_PERCE' => 'Roche Perce',
		'CABIENFAIT' => 'Bienfait',
		'CAESTEVAN_NO._5' => 'Estevan No. 5',
		'CAESTEVAN' => 'Estevan',
		'CABENSON_NO._35' => 'Benson No. 35',
		'CABROWNING_NO._34' => 'Browning No. 34',
		'CALAMPMAN' => 'Lampman',
		'CAMOOSE_CREEK_NO._33' => 'Moose Creek No. 33',
		'CAALAMEDA' => 'Alameda',
		'CARECIPROCITY_NO._32' => 'Reciprocity No. 32',
		'CAALIDA' => 'Alida',
		'CASTORTHOAKS_NO._31' => 'Storthoaks No. 31',
		'CASTORTHOAKS' => 'Storthoaks',
		'CAANTLER_NO._61' => 'Antler No. 61',
		'CAREDVERS' => 'Redvers',
		'CAMOOSE_MOUNTAIN_NO._63' => 'Moose Mountain No. 63',
		'CAMANOR' => 'Manor',
		'CACARLYLE' => 'Carlyle',
		'CABROCK_NO._64' => 'Brock No. 64',
		'CAARCOLA' => 'Arcola',
		'CAKISBEY' => 'Kisbey',
		'CATECUMSEH_NO._65' => 'Tecumseh No. 65',
		'CAFORGET' => 'Forget',
		'CASTOUGHTON' => 'Stoughton',
		'CAHEWARD' => 'Heward',
		'CAGOLDEN_WEST_NO._95' => 'Golden West No. 95',
		'CAHAZELWOOD_NO._94' => 'Hazelwood No. 94',
		'CAWAWKEN_NO._93' => 'Wawken No. 93',
		'CAKENNEDY' => 'Kennedy',
		'CAWAWOTA' => 'Wawota',
		'CAKENOSEE_LAKE' => 'Kenosee Lake',
		'CAWALPOLE_NO._92' => 'Walpole No. 92',
		'CAMARYFIELD_NO._91' => 'Maryfield No. 91',
		'CAMARYFIELD' => 'Maryfield',
		'CAFAIRLIGHT' => 'Fairlight',
		'CAWHITE_BEAR_70' => 'White Bear 70',
		'CAOCEAN_MAN_69' => 'Ocean Man 69',
		'CAOCEAN_MAN_69A' => 'Ocean Man 69A',
		'CAOCEAN_MAN_69C' => 'Ocean Man 69C',
		'CAOCEAN_MAN_69E' => 'Ocean Man 69E',
		'CAOCEAN_MAN_69F' => 'Ocean Man 69F',
		'CAOCEAN_MAN_69G' => 'Ocean Man 69G',
		'CAOCEAN_MAN_69I' => 'Ocean Man 69I',
		'CAOCEAN_MAN_69H' => 'Ocean Man 69H',
		'CAOCEAN_MAN_69D' => 'Ocean Man 69D',
		'CAPHEASANT_RUMP_NAKOTA_68' => 'Pheasant Rump Nakota 68',
		'CACAMBRIA_NO._6' => 'Cambria No. 6',
		'CATORQUAY' => 'Torquay',
		'CASOURIS_VALLEY_NO._7' => 'Souris Valley No. 7',
		'CATRIBUNE' => 'Tribune',
		'CALAKE_ALMA_NO._8' => 'Lake Alma No. 8',
		'CALAKE_ALMA' => 'Lake Alma',
		'CASURPRISE_VALLEY_NO._9' => 'Surprise Valley No. 9',
		'CAMINTON' => 'Minton',
		'CAHAPPY_VALLEY_NO._10' => 'Happy Valley No. 10',
		'CABENGOUGH' => 'Bengough',
		'CABENGOUGH_NO._40' => 'Bengough No. 40',
		'CATHE_GAP_NO._39' => 'The Gap No. 39',
		'CACEYLON' => 'Ceylon',
		'CALAURIER_NO._38' => 'Laurier No. 38',
		'CARADVILLE' => 'Radville',
		'CALOMOND_NO._37' => 'Lomond No. 37',
		'CAGOODWATER' => 'Goodwater',
		'CACYMRI_NO._36' => 'Cymri No. 36',
		'CAHALBRITE' => 'Halbrite',
		'CAMIDALE' => 'Midale',
		'CAMACOUN' => 'Macoun',
		'CAGRIFFIN_NO._66' => 'Griffin No. 66',
		'CAWEYBURN_NO._67' => 'Weyburn No. 67',
		'CAWEYBURN' => 'Weyburn',
		'CAMCTAGGART' => 'McTaggart',
		'CABROKENSHELL_NO._68' => 'Brokenshell No. 68',
		'CANORTON_NO._69' => 'Norton No. 69',
		'CAPANGMAN' => 'Pangman',
		'CAKEY_WEST_NO._70' => 'Key West No. 70',
		'CAOGEMA' => 'Ogema',
		'CAELMSTHORPE_NO._100' => 'Elmsthorpe No. 100',
		'CAAVONLEA' => 'Avonlea',
		'CACALEDONIA_NO._99' => 'Caledonia No. 99',
		'CAMILESTONE' => 'Milestone',
		'CASCOTT_NO._98' => 'Scott No. 98',
		'CALANG' => 'Lang',
		'CAYELLOW_GRASS' => 'Yellow Grass',
		'CAWELLINGTON_NO._97' => 'Wellington No. 97',
		'CAFILLMORE_NO._96' => 'Fillmore No. 96',
		'CAOSAGE' => 'Osage',
		'CAFILLMORE' => 'Fillmore',
		'CACREELMAN' => 'Creelman',
		'CAPIAPOT_CREE_FIRST_NATION_75H' => 'Piapot Cree First Nation 75H',
		'CAHART_BUTTE_NO._11' => 'Hart Butte No. 11',
		'CACORONACH' => 'Coronach',
		'CAPOPLAR_VALLEY_NO._12' => 'Poplar Valley No. 12',
		'CAROCKGLEN' => 'Rockglen',
		'CAOLD_POST_NO._43' => 'Old Post No. 43',
		'CAWOOD_MOUNTAIN' => 'Wood Mountain',
		'CAGLEN_MCPHERSON_NO._46' => 'Glen McPherson No. 46',
		'CAMANKOTA_NO._45' => 'Mankota No. 45',
		'CAMANKOTA' => 'Mankota',
		'CAWAVERLEY_NO._44' => 'Waverley No. 44',
		'CAWILLOW_BUNCH_NO._42' => 'Willow Bunch No. 42',
		'CAWILLOW_BUNCH' => 'Willow Bunch',
		'CAEXCEL_NO._71' => 'Excel No. 71',
		'CALAKE_OF_THE_RIVERS_NO._72' => 'Lake of the Rivers No. 72',
		'CAASSINIBOIA' => 'Assiniboia',
		'CASTONEHENGE_NO._73' => 'Stonehenge No. 73',
		'CALIMERICK' => 'Limerick',
		'CAWOOD_RIVER_NO._74' => 'Wood River No. 74',
		'CALAFLECHE' => 'Lafleche',
		'CAPINTO_CREEK_NO._75' => 'Pinto Creek No. 75',
		'CAKINCAID' => 'Kincaid',
		'CAHAZENMORE' => 'Hazenmore',
		'CAAUVERGNE_NO._76' => 'Auvergne No. 76',
		'CAPONTEIX' => 'Ponteix',
		'CAWHISKA_CREEK_NO._106' => 'Whiska Creek No. 106',
		'CANEVILLE' => 'Neville',
		'CAVANGUARD' => 'Vanguard',
		'CAGLEN_BAIN_NO._105' => 'Glen Bain No. 105',
		'CAGRAVELBOURG_NO._104' => 'Gravelbourg No. 104',
		'CAGRAVELBOURG' => 'Gravelbourg',
		'CASUTTON_NO._103' => 'Sutton No. 103',
		'CAMOSSBANK' => 'Mossbank',
		'CALAKE_JOHNSTON_NO._102' => 'Lake Johnston No. 102',
		'CATERRELL_NO._101' => 'Terrell No. 101',
		'CAWOOD_MOUNTAIN_160' => 'Wood Mountain 160',
		'CAVAL_MARIE' => 'Val Marie',
		'CAVAL_MARIE_NO._17' => 'Val Marie No. 17',
		'CALONE_TREE_NO._18' => 'Lone Tree No. 18',
		'CABRACKEN' => 'Bracken',
		'CACLIMAX' => 'Climax',
		'CAFRONTIER_NO._19' => 'Frontier No. 19',
		'CAFRONTIER' => 'Frontier',
		'CARENO_NO._51' => 'Reno No. 51',
		'CACONSUL' => 'Consul',
		'CAWHITE_VALLEY_NO._49' => 'White Valley No. 49',
		'CAEASTEND' => 'Eastend',
		'CAWISE_CREEK_NO._77' => 'Wise Creek No. 77',
		'CACADILLAC' => 'Cadillac',
		'CAGRASSY_CREEK_NO._78' => 'Grassy Creek No. 78',
		'CASHAUNAVON' => 'Shaunavon',
		'CAARLINGTON_NO._79' => 'Arlington No. 79',
		'CAMAPLE_CREEK_NO._111' => 'Maple Creek No. 111',
		'CAMAPLE_CREEK' => 'Maple Creek',
		'CAPIAPOT_NO._110' => 'Piapot No. 110',
		'CACARMICHAEL_NO._109' => 'Carmichael No. 109',
		'CACARMICHAEL' => 'Carmichael',
		'CABONE_CREEK_NO._108' => 'Bone Creek No. 108',
		'CALAC_PELLETIER_NO._107' => 'Lac Pelletier No. 107',
		'CANEKANEET_CREE_NATION' => 'Nekaneet Cree Nation',
		'CAMOOSOMIN_NO._121' => 'Moosomin No. 121',
		'CAFLEMING' => 'Fleming',
		'CAMOOSOMIN' => 'Moosomin',
		'CAWELWYN' => 'Welwyn',
		'CAMARTIN_NO._122' => 'Martin No. 122',
		'CAWAPELLA' => 'Wapella',
		'CASILVERWOOD_NO._123' => 'Silverwood No. 123',
		'CAKINGSLEY_NO._124' => 'Kingsley No. 124',
		'CAKIPLING' => 'Kipling',
		'CACHESTER_NO._125' => 'Chester No. 125',
		'CAWINDTHORST' => 'Windthorst',
		'CAGLENAVON' => 'Glenavon',
		'CAWOLSELEY' => 'Wolseley',
		'CAWOLSELEY_NO._155' => 'Wolseley No. 155',
		'CAELCAPO_NO._154' => 'Elcapo No. 154',
		'CAGRENFELL' => 'Grenfell',
		'CABROADVIEW' => 'Broadview',
		'CAWILLOWDALE_NO._153' => 'Willowdale No. 153',
		'CAWHITEWOOD' => 'Whitewood',
		'CAROCANVILLE_NO._151' => 'Rocanville No. 151',
		'CAROCANVILLE' => 'Rocanville',
		'CASPY_HILL_NO._152' => 'Spy Hill No. 152',
		'CATANTALLON' => 'Tantallon',
		'CASPY_HILL' => 'Spy Hill',
		'CAGERALD' => 'Gerald',
		'CALANGENBURG_NO._181' => 'Langenburg No. 181',
		'CALANGENBURG' => 'Langenburg',
		'CAYARBO' => 'Yarbo',
		'CAWEST_END' => 'West End',
		'CAFERTILE_BELT_NO._183' => 'Fertile Belt No. 183',
		'CAESTERHAZY' => 'Esterhazy',
		'CAATWATER' => 'Atwater',
		'CABANGOR' => 'Bangor',
		'CABIRDS_POINT' => 'Birds Point',
		'CASTOCKHOLM' => 'Stockholm',
		'CAGRAYSON_NO._184' => 'Grayson No. 184',
		'CADUBUC' => 'Dubuc',
		'CAGRAYSON' => 'Grayson',
		'CAMELVILLE_BEACH' => 'Melville Beach',
		'CAWALDRON' => 'Waldron',
		'CAKILLALY' => 'Killaly',
		'CAMCLEOD_NO._185' => 'McLeod No. 185',
		'CANEUDORF' => 'Neudorf',
		'CALEMBERG' => 'Lemberg',
		'CASTANLEY_NO._215' => 'Stanley No. 215',
		'CADUFF' => 'Duff',
		'CAGOODEVE' => 'Goodeve',
		'CAFENWOOD' => 'Fenwood',
		'CACANA_NO._214' => 'Cana No. 214',
		'CAMELVILLE' => 'Melville',
		'CASALTCOATS_NO._213' => 'Saltcoats No. 213',
		'CASALTCOATS' => 'Saltcoats',
		'CABREDENBURY' => 'Bredenbury',
		'CACHURCHBRIDGE_NO._211' => 'Churchbridge No. 211',
		'CACHURCHBRIDGE' => 'Churchbridge',
		'CAMACNUTT' => 'MacNutt',
		'CACOWESSESS_73' => 'Cowessess 73',
		'CAKAHKEWISTAHAW_72' => 'Kahkewistahaw 72',
		'CASAKIMAY_74' => 'Sakimay 74',
		'CAOCHAPOWACE_71' => 'Ochapowace 71',
		'CASHESHEEP_74A' => 'Shesheep 74A',
		'CALITTLE_BONE_74B' => 'Little Bone 74B',
		'CAOCHAPOWACE_71-10' => 'Ochapowace 71-10',
		'CAOCHAPOWACE_71-54' => 'Ochapowace 71-54',
		'CAOCHAPOWACE_71-26' => 'Ochapowace 71-26',
		'CAOCHAPOWACE_71-70' => 'Ochapowace 71-70',
		'CAOCHAPOWACE_71-7' => 'Ochapowace 71-7',
		'CAOCHAPOWACE_71-18' => 'Ochapowace 71-18',
		'CAOCHAPOWACE_71-51' => 'Ochapowace 71-51',
		'CAOCHAPOWACE_71-44' => 'Ochapowace 71-44',
		'CAMONTMARTRE_NO._126' => 'Montmartre No. 126',
		'CAMONTMARTRE' => 'Montmartre',
		'CAKENDAL' => 'Kendal',
		'CAFRANCIS_NO._127' => 'Francis No. 127',
		'CAODESSA' => 'Odessa',
		'CAVIBANK' => 'Vibank',
		'CASEDLEY' => 'Sedley',
		'CAFRANCIS' => 'Francis',
		'CALAJORD_NO._128' => 'Lajord No. 128',
		'CABRATTS_LAKE_NO._129' => 'Bratts Lake No. 129',
		'CAWILCOX' => 'Wilcox',
		'CAREDBURN_NO._130' => 'Redburn No. 130',
		'CAROULEAU' => 'Rouleau',
		'CABRIERCREST' => 'Briercrest',
		'CADRINKWATER' => 'Drinkwater',
		'CAPENSE_NO._160' => 'Pense No. 160',
		'CABELLE_PLAINE' => 'Belle Plaine',
		'CAPENSE' => 'Pense',
		'CASHERWOOD_NO._159' => 'Sherwood No. 159',
		'CAREGINA' => 'Regina',
		'CAGRAND_COULEE' => 'Grand Coulee',
		'CAEDENWOLD_NO._158' => 'Edenwold No. 158',
		'CAWHITE_CITY' => 'White City',
		'CAPILOT_BUTTE' => 'Pilot Butte',
		'CABALGONIE' => 'Balgonie',
		'CAEDENWOLD' => 'Edenwold',
		'CASOUTH_QUAPPELLE_NO._157' => 'South QuAppelle No. 157',
		'CAQUAPPELLE' => 'QuAppelle',
		'CAMCLEAN' => 'McLean',
		'CAINDIAN_HEAD_NO._156' => 'Indian Head No. 156',
		'CAINDIAN_HEAD' => 'Indian Head',
		'CASINTALUTA' => 'Sintaluta',
		'CAABERNETHY_NO._186' => 'Abernethy No. 186',
		'CAFORT_SAN' => 'Fort San',
		'CAABERNETHY' => 'Abernethy',
		'CABALCARRES' => 'Balcarres',
		'CANORTH_QUAPPELLE_NO._187' => 'North QuAppelle No. 187',
		'CALEBRET' => 'Lebret',
		'CAKATEPWA' => 'Katepwa',
		'CAFORT_QUAPPELLE' => 'Fort QuAppelle',
		'CAB-SAY-TAH' => 'B-Say-Tah',
		'CALUMSDEN_NO._189' => 'Lumsden No. 189',
		'CADISLEY' => 'Disley',
		'CABUENA_VISTA' => 'Buena Vista',
		'CALUMSDEN' => 'Lumsden',
		'CALUMSDEN_BEACH' => 'Lumsden Beach',
		'CAREGINA_BEACH' => 'Regina Beach',
		'CADUFFERIN_NO._190' => 'Dufferin No. 190',
		'CAWEE_TOO_BEACH' => 'Wee Too Beach',
		'CABETHUNE' => 'Bethune',
		'CAFINDLATER' => 'Findlater',
		'CASARNIA_NO._221' => 'Sarnia No. 221',
		'CACHAMBERLAIN' => 'Chamberlain',
		'CAALICE_BEACH' => 'Alice Beach',
		'CAHOLDFAST' => 'Holdfast',
		'CADILKE' => 'Dilke',
		'CAGRANDVIEW_BEACH' => 'Grandview Beach',
		'CALONGLAKETON_NO._219' => 'Longlaketon No. 219',
		'CAMCKILLOP_NO._220' => 'McKillop No. 220',
		'CASASKATCHEWAN_BEACH' => 'Saskatchewan Beach',
		'CABULYEA' => 'Bulyea',
		'CASTRASBOURG' => 'Strasbourg',
		'CAKANNATA_VALLEY' => 'Kannata Valley',
		'CASUNSET_COVE' => 'Sunset Cove',
		'CASILTON' => 'Silton',
		'CACRAVEN' => 'Craven',
		'CAEARL_GREY' => 'Earl Grey',
		'CAGLEN_HARBOUR' => 'Glen Harbour',
		'CANORTH_GROVE' => 'North Grove',
		'CAPELICAN_POINTE' => 'Pelican Pointe',
		'CAISLAND_VIEW' => 'Island View',
		'CACUPAR_NO._218' => 'Cupar No. 218',
		'CASOUTHEY' => 'Southey',
		'CAMARKINCH' => 'Markinch',
		'CACUPAR' => 'Cupar',
		'CALIPTON_NO._217' => 'Lipton No. 217',
		'CADYSART' => 'Dysart',
		'CALIPTON' => 'Lipton',
		'CATULLYMET_NO._216' => 'Tullymet No. 216',
		'CAPIAPOT_75' => 'Piapot 75',
		'CAASSINIBOINE_76' => 'Assiniboine 76',
		'CASTANDING_BUFFALO_78' => 'Standing Buffalo 78',
		'CAPASQUA_79' => 'Pasqua 79',
		'CAMUSCOWPETUNG_80' => 'Muscowpetung 80',
		'CALITTLE_BLACK_BEAR_84' => 'Little Black Bear 84',
		'CAOKANESE_82' => 'Okanese 82',
		'CAPEEPEEKISIS_81' => 'Peepeekisis 81',
		'CASTAR_BLANKET_83' => 'Star Blanket 83',
		'CAWA-PII_MOOS-TOOSIS_(WHITE_CALF)_83A' => 'Wa-Pii Moos-Toosis (White Calf) 83A',
		'CASTAR_BLANKET_83C' => 'Star Blanket 83C',
		'CATREATY_FOUR_RESERVE_GROUNDS_77' => 'Treaty Four Reserve Grounds 77',
		'CABAILDON_NO._131' => 'Baildon No. 131',
		'CAHILLSBOROUGH_NO._132' => 'Hillsborough No. 132',
		'CARODGERS_NO._133' => 'Rodgers No. 133',
		'CACODERRE' => 'Coderre',
		'CASHAMROCK_NO._134' => 'Shamrock No. 134',
		'CASHAMROCK' => 'Shamrock',
		'CALAWTONIA_NO._135' => 'Lawtonia No. 135',
		'CAHODGEVILLE' => 'Hodgeville',
		'CACOULEE_NO._136' => 'Coulee No. 136',
		'CABEAVER_FLAT' => 'Beaver Flat',
		'CAEXCELSIOR_NO._166' => 'Excelsior No. 166',
		'CAWALDECK' => 'Waldeck',
		'CARUSH_LAKE' => 'Rush Lake',
		'CAMORSE_NO._165' => 'Morse No. 165',
		'CAHERBERT' => 'Herbert',
		'CAMORSE' => 'Morse',
		'CAERNFOLD' => 'Ernfold',
		'CACHAPLIN_NO._164' => 'Chaplin No. 164',
		'CACHAPLIN' => 'Chaplin',
		'CAWHEATLANDS_NO._163' => 'Wheatlands No. 163',
		'CAMORTLACH' => 'Mortlach',
		'CACARON_NO._162' => 'Caron No. 162',
		'CACARONPORT' => 'Caronport',
		'CAMOOSE_JAW_NO._161' => 'Moose Jaw No. 161',
		'CAMOOSE_JAW' => 'Moose Jaw',
		'CAMARQUIS_NO._191' => 'Marquis No. 191',
		'CATUXFORD' => 'Tuxford',
		'CAMARQUIS' => 'Marquis',
		'CASUN_VALLEY' => 'Sun Valley',
		'CAKEELER' => 'Keeler',
		'CAEYEBROW_NO._193' => 'Eyebrow No. 193',
		'CABROWNLEE' => 'Brownlee',
		'CAEYEBROW' => 'Eyebrow',
		'CASOUTH_LAKE' => 'South Lake',
		'CAENFIELD_NO._194' => 'Enfield No. 194',
		'CACENTRAL_BUTTE' => 'Central Butte',
		'CACANAAN_NO._225' => 'Canaan No. 225',
		'CALUCKY_LAKE' => 'Lucky Lake',
		'CABEECHY' => 'Beechy',
		'CAVICTORY_NO._226' => 'Victory No. 226',
		'CAKING_GEORGE_NO._256' => 'King George No. 256',
		'CACOTEAU_NO._255' => 'Coteau No. 255',
		'CACOTEAU_BEACH' => 'Coteau Beach',
		'CAMAPLE_BUSH_NO._224' => 'Maple Bush No. 224',
		'CARIVERHURST' => 'Riverhurst',
		'CAMISTUSINNE' => 'Mistusinne',
		'CAHURON_NO._223' => 'Huron No. 223',
		'CATUGASKE' => 'Tugaske',
		'CACRAIK_NO._222' => 'Craik No. 222',
		'CACRAIK' => 'Craik',
		'CAAYLESBURY' => 'Aylesbury',
		'CASWIFT_CURRENT_NO._137' => 'Swift Current No. 137',
		'CASWIFT_CURRENT' => 'Swift Current',
		'CAWEBB_NO._138' => 'Webb No. 138',
		'CAWEBB' => 'Webb',
		'CAGULL_LAKE_NO._139' => 'Gull Lake No. 139',
		'CAGULL_LAKE' => 'Gull Lake',
		'CATOMPKINS' => 'Tompkins',
		'CABIG_STICK_NO._141' => 'Big Stick No. 141',
		'CAGOLDEN_PRAIRIE' => 'Golden Prairie',
		'CAENTERPRISE_NO._142' => 'Enterprise No. 142',
		'CARICHMOUND' => 'Richmound',
		'CAFOX_VALLEY_NO._171' => 'Fox Valley No. 171',
		'CAFOX_VALLEY' => 'Fox Valley',
		'CAPITTVILLE_NO._169' => 'Pittville No. 169',
		'CAHAZLET' => 'Hazlet',
		'CARIVERSIDE_NO._168' => 'Riverside No. 168',
		'CACABRI' => 'Cabri',
		'CAPENNANT' => 'Pennant',
		'CASUCCESS' => 'Success',
		'CASASKATCHEWAN_LANDING_NO._167' => 'Saskatchewan Landing No. 167',
		'CASTEWART_VALLEY' => 'Stewart Valley',
		'CALACADENA_NO._228' => 'Lacadena No. 228',
		'CAKYLE' => 'Kyle',
		'CAMIRY_CREEK_NO._229' => 'Miry Creek No. 229',
		'CAABBEY' => 'Abbey',
		'CALANCER' => 'Lancer',
		'CACLINWORTH_NO._230' => 'Clinworth No. 230',
		'CASCEPTRE' => 'Sceptre',
		'CAHAPPYLAND_NO._231' => 'Happyland No. 231',
		'CAPRELATE' => 'Prelate',
		'CALEADER' => 'Leader',
		'CAMENDHAM' => 'Mendham',
		'CADEER_FORKS_NO._232' => 'Deer Forks No. 232',
		'CABURSTALL' => 'Burstall',
		'CACHESTERFIELD_NO._261' => 'Chesterfield No. 261',
		'CAEATONIA' => 'Eatonia',
		'CANEWCOMBE_NO._260' => 'Newcombe No. 260',
		'CASNIPE_LAKE_NO._259' => 'Snipe Lake No. 259',
		'CAESTON' => 'Eston',
		'CAMONET_NO._257' => 'Monet No. 257',
		'CAELROSE' => 'Elrose',
		'CACALDER_NO._241' => 'Calder No. 241',
		'CACALDER' => 'Calder',
		'CAWALLACE_NO._243' => 'Wallace No. 243',
		'CARHEIN' => 'Rhein',
		'CAORKNEY_NO._244' => 'Orkney No. 244',
		'CAYORKTON' => 'Yorkton',
		'CAEBENEZER' => 'Ebenezer',
		'CASPRINGSIDE' => 'Springside',
		'CAGARRY_NO._245' => 'Garry No. 245',
		'CAINSINGER_NO._275' => 'Insinger No. 275',
		'CASHEHO' => 'Sheho',
		'CATHEODORE' => 'Theodore',
		'CAGOOD_LAKE_NO._274' => 'Good Lake No. 274',
		'CACANORA' => 'Canora',
		'CASLIDING_HILLS_NO._273' => 'Sliding Hills No. 273',
		'CACOTE_NO._271' => 'Cote No. 271',
		'CATOGO' => 'Togo',
		'CAKAMSACK' => 'Kamsack',
		'CAST._PHILIPS_NO._301' => 'St. Philips No. 301',
		'CAPELLY' => 'Pelly',
		'CAKEYS_NO._303' => 'Keys No. 303',
		'CABUCHANAN_NO._304' => 'Buchanan No. 304',
		'CABUCHANAN' => 'Buchanan',
		'CAINVERMAY_NO._305' => 'Invermay No. 305',
		'CARAMA' => 'Rama',
		'CAINVERMAY' => 'Invermay',
		'CAHAZEL_DELL_NO._335' => 'Hazel Dell No. 335',
		'CALINTLAW' => 'Lintlaw',
		'CAPREECEVILLE_NO._334' => 'Preeceville No. 334',
		'CAPREECEVILLE' => 'Preeceville',
		'CAENDEAVOUR' => 'Endeavour',
		'CASTURGIS' => 'Sturgis',
		'CACLAYTON_NO._333' => 'Clayton No. 333',
		'CASTENEN' => 'Stenen',
		'CAHYAS' => 'Hyas',
		'CANORQUAY' => 'Norquay',
		'CALIVINGSTON_NO._331' => 'Livingston No. 331',
		'CAARRAN' => 'Arran',
		'CACOTE_64' => 'Cote 64',
		'CAKEESEEKOOSE_66' => 'Keeseekoose 66',
		'CATHE_KEY_65' => 'The Key 65',
		'CAKEESEEKOOSE_66A' => 'Keeseekoose 66A',
		'CAKEESEEKOOSE_66-CA-04' => 'Keeseekoose 66-CA-04',
		'CAKEESEEKOOSE_66-CA-05' => 'Keeseekoose 66-CA-05',
		'CAKEESEEKOOSE_66-CA-06' => 'Keeseekoose 66-CA-06',
		'CAKEESEEKOOSE_66-KE-04' => 'Keeseekoose 66-KE-04',
		'CAKEESEEKOOSE_66-KE-05' => 'Keeseekoose 66-KE-05',
		'CAHUBBARD' => 'Hubbard',
		'CAITUNA_BON_ACCORD_NO._246' => 'Ituna Bon Accord No. 246',
		'CAITUNA' => 'Ituna',
		'CAKELLROSS_NO._247' => 'Kellross No. 247',
		'CAKELLIHER' => 'Kelliher',
		'CALEROSS' => 'Leross',
		'CALESTOCK' => 'Lestock',
		'CATOUCHWOOD_NO._248' => 'Touchwood No. 248',
		'CASEMANS' => 'Semans',
		'CAMOUNT_HOPE_NO._279' => 'Mount Hope No. 279',
		'CARAYMORE' => 'Raymore',
		'CAQUINTON' => 'Quinton',
		'CAPUNNICHY' => 'Punnichy',
		'CAEMERALD_NO._277' => 'Emerald No. 277',
		'CACHORNEY_BEACH' => 'Chorney Beach',
		'CALESLIE_BEACH' => 'Leslie Beach',
		'CAFOAM_LAKE_NO._276' => 'Foam Lake No. 276',
		'CAFOAM_LAKE' => 'Foam Lake',
		'CAELFROS_NO._307' => 'Elfros No. 307',
		'CAELFROS' => 'Elfros',
		'CABIG_QUILL_NO._308' => 'Big Quill No. 308',
		'CAWYNYARD' => 'Wynyard',
		'CADAFOE' => 'Dafoe',
		'CAPRAIRIE_ROSE_NO._309' => 'Prairie Rose No. 309',
		'CAJANSEN' => 'Jansen',
		'CALEROY_NO._339' => 'Leroy No. 339',
		'CALEROY' => 'Leroy',
		'CALAKESIDE_NO._338' => 'Lakeside No. 338',
		'CAWATSON' => 'Watson',
		'CAQUILL_LAKE' => 'Quill Lake',
		'CALAKEVIEW_NO._337' => 'Lakeview No. 337',
		'CAWADENA' => 'Wadena',
		'CASASMAN_NO._336' => 'Sasman No. 336',
		'CAMARGO' => 'Margo',
		'CAMUSKOWEKWAN_85' => 'Muskowekwan 85',
		'CAGORDON_86' => 'Gordon 86',
		'CADAY_STAR_87' => 'Day Star 87',
		'CAPOORMAN_88' => 'Poorman 88',
		'CAFISHING_LAKE_89' => 'Fishing Lake 89',
		'CABEARDYS_AND_OKEMASIS_96_AND_97A' => 'Beardys and Okemasis 96 and 97A',
		'CAMUSKOWEKWAN_85-17' => 'Muskowekwan 85-17',
		'CAMUSKOWEKWAN_85-26' => 'Muskowekwan 85-26',
		'CAMUSKOWEKWAN_85-33' => 'Muskowekwan 85-33',
		'CAMUSKOWEKWAN_85-28' => 'Muskowekwan 85-28',
		'CAMUSKOWEKWAN_85-29' => 'Muskowekwan 85-29',
		'CAMUSKOWEKWAN_85-23' => 'Muskowekwan 85-23',
		'CAMUSKOWEKWAN_85-12' => 'Muskowekwan 85-12',
		'CAMUSKOWEKWAN_85-24' => 'Muskowekwan 85-24',
		'CAMUSKOWEKWAN_85-22' => 'Muskowekwan 85-22',
		'CAMUSKOWEKWAN_85-27' => 'Muskowekwan 85-27',
		'CAMUSKOWEKWAN_85-10' => 'Muskowekwan 85-10',
		'CAMUSKOWEKWAN_85-1' => 'Muskowekwan 85-1',
		'CAMUSKOWEKWAN_85-8' => 'Muskowekwan 85-8',
		'CAMUSKOWEKWAN_85-15' => 'Muskowekwan 85-15',
		'CAMUSKOWEKWAN_85-2A' => 'Muskowekwan 85-2A',
		'CAMUSKOWEKWAN_85-31' => 'Muskowekwan 85-31',
		'CAFISHING_LAKE_89A' => 'Fishing Lake 89A',
		'CADUVAL' => 'Duval',
		'CALAST_MOUNTAIN_VALLEY_NO._250' => 'Last Mountain Valley No. 250',
		'CAGOVAN' => 'Govan',
		'CABIG_ARM_NO._251' => 'Big Arm No. 251',
		'CAETTERS_BEACH' => 'Etters Beach',
		'CAIMPERIAL' => 'Imperial',
		'CALIBERTY' => 'Liberty',
		'CAARM_RIVER_NO._252' => 'Arm River No. 252',
		'CADAVIDSON' => 'Davidson',
		'CAWILLNER_NO._253' => 'Willner No. 253',
		'CALOREBURN_NO._254' => 'Loreburn No. 254',
		'CAELBOW' => 'Elbow',
		'CALOREBURN' => 'Loreburn',
		'CASTRONGFIELD' => 'Strongfield',
		'CAHAWARDEN' => 'Hawarden',
		'CARUDY_NO._284' => 'Rudy No. 284',
		'CAOUTLOOK' => 'Outlook',
		'CABRODERICK' => 'Broderick',
		'CAGLENSIDE' => 'Glenside',
		'CAROSEDALE_NO._283' => 'Rosedale No. 283',
		'CAHANLEY' => 'Hanley',
		'CAMCCRANEY_NO._282' => 'McCraney No. 282',
		'CAKENASTON' => 'Kenaston',
		'CABLADWORTH' => 'Bladworth',
		'CAWOOD_CREEK_NO._281' => 'Wood Creek No. 281',
		'CASIMPSON' => 'Simpson',
		'CAWREFORD_NO._280' => 'Wreford No. 280',
		'CANOKOMIS' => 'Nokomis',
		'CAUSBORNE_NO._310' => 'Usborne No. 310',
		'CADRAKE' => 'Drake',
		'CALANIGAN' => 'Lanigan',
		'CAMORRIS_NO._312' => 'Morris No. 312',
		'CAWATROUS' => 'Watrous',
		'CAMANITOU_BEACH' => 'Manitou Beach',
		'CAYOUNG' => 'Young',
		'CAZELMA' => 'Zelma',
		'CALOST_RIVER_NO._313' => 'Lost River No. 313',
		'CATHODE' => 'Thode',
		'CADUNDURN_NO._314' => 'Dundurn No. 314',
		'CADUNDURN' => 'Dundurn',
		'CASHIELDS' => 'Shields',
		'CACORMAN_PARK_NO._344' => 'Corman Park No. 344',
		'CASASKATOON' => 'Saskatoon',
		'CALANGHAM' => 'Langham',
		'CAWARMAN' => 'Warman',
		'CABLUCHER_NO._343' => 'Blucher No. 343',
		'CAMARTENSVILLE' => 'Martensville',
		'CABRADWELL' => 'Bradwell',
		'CAALLAN' => 'Allan',
		'CADALMENY' => 'Dalmeny',
		'CAOSLER' => 'Osler',
		'CACOLONSAY_NO._342' => 'Colonsay No. 342',
		'CACLAVET' => 'Clavet',
		'CAMEACHAM' => 'Meacham',
		'CACOLONSAY' => 'Colonsay',
		'CAVISCOUNT_NO._341' => 'Viscount No. 341',
		'CAVISCOUNT' => 'Viscount',
		'CAPLUNKETT' => 'Plunkett',
		'CAWOLVERINE_NO._340' => 'Wolverine No. 340',
		'CAWHITECAP' => 'Whitecap',
		'CAPLEASANT_VALLEY_NO._288' => 'Pleasant Valley No. 288',
		'CAST._ANDREWS_NO._287' => 'St. Andrews No. 287',
		'CAROSETOWN' => 'Rosetown',
		'CAZEALANDIA' => 'Zealandia',
		'CAMILDEN_NO._286' => 'Milden No. 286',
		'CAMILDEN' => 'Milden',
		'CAWISETON' => 'Wiseton',
		'CADINSMORE' => 'Dinsmore',
		'CAMACRORIE' => 'Macrorie',
		'CAFERTILE_VALLEY_NO._285' => 'Fertile Valley No. 285',
		'CACONQUEST' => 'Conquest',
		'CAMONTROSE_NO._315' => 'Montrose No. 315',
		'CAHARRIS_NO._316' => 'Harris No. 316',
		'CATESSIER' => 'Tessier',
		'CAHARRIS' => 'Harris',
		'CAMARRIOTT_NO._317' => 'Marriott No. 317',
		'CAMOUNTAIN_VIEW_NO._318' => 'Mountain View No. 318',
		'CABIGGAR_NO._347' => 'Biggar No. 347',
		'CABIGGAR' => 'Biggar',
		'CAPERDUE_NO._346' => 'Perdue No. 346',
		'CAPERDUE' => 'Perdue',
		'CAKINLEY' => 'Kinley',
		'CAVANSCOY_NO._345' => 'Vanscoy No. 345',
		'CADELISLE' => 'Delisle',
		'CAVANSCOY' => 'Vanscoy',
		'CAASQUITH' => 'Asquith',
		'CAEAGLE_CREEK_NO._376' => 'Eagle Creek No. 376',
		'CAGLENSIDE_NO._377' => 'Glenside No. 377',
		'CAROSEMOUNT_NO._378' => 'Rosemount No. 378',
		'CABATTLE_RIVER_NO._438' => 'Battle River No. 438',
		'CABATTLEFORD' => 'Battleford',
		'CARED_PHEASANT_108' => 'Red Pheasant 108',
		'CAMOSQUITO_109' => 'Mosquito 109',
		'CAGRIZZLY_BEARS_HEAD_110_AND_LEAN_MAN_' => 'Grizzly Bears Head 110 and Lean Man 111',
		'CASWEET_GRASS_113' => 'Sweet Grass 113',
		'CASWEET_GRASS_113-M16' => 'Sweet Grass 113-M16',
		'CABROCK' => 'Brock',
		'CANETHERHILL' => 'Netherhill',
		'CAKINDERSLEY_NO._290' => 'Kindersley No. 290',
		'CAKINDERSLEY' => 'Kindersley',
		'CAFLAXCOMBE' => 'Flaxcombe',
		'CAMILTON_NO._292' => 'Milton No. 292',
		'CAMARENGO' => 'Marengo',
		'CAANTELOPE_PARK_NO._322' => 'Antelope Park No. 322',
		'CAPRAIRIEDALE_NO._321' => 'Prairiedale No. 321',
		'CAMAJOR' => 'Major',
		'CASMILEY' => 'Smiley',
		'CAOAKDALE_NO._320' => 'Oakdale No. 320',
		'CACOLEVILLE' => 'Coleville',
		'CAWINSLOW_NO._319' => 'Winslow No. 319',
		'CADODSLAND' => 'Dodsland',
		'CAPLENTY' => 'Plenty',
		'CAGRANDVIEW_NO._349' => 'Grandview No. 349',
		'CAMARIPOSA_NO._350' => 'Mariposa No. 350',
		'CATRAMPING_LAKE' => 'Tramping Lake',
		'CAPROGRESS_NO._351' => 'Progress No. 351',
		'CAKERROBERT' => 'Kerrobert',
		'CALUSELAND' => 'Luseland',
		'CAHEARTS_HILL_NO._352' => 'Hearts Hill No. 352',
		'CAEYE_HILL_NO._382' => 'Eye Hill No. 382',
		'CAMACKLIN' => 'Macklin',
		'CAPRIMATE' => 'Primate',
		'CADENZIL' => 'Denzil',
		'CAGRASS_LAKE_NO._381' => 'Grass Lake No. 381',
		'CATRAMPING_LAKE_NO._380' => 'Tramping Lake No. 380',
		'CASCOTT' => 'Scott',
		'CAREFORD_NO._379' => 'Reford No. 379',
		'CALANDIS' => 'Landis',
		'CABUFFALO_NO._409' => 'Buffalo No. 409',
		'CAWILKIE' => 'Wilkie',
		'CAROUND_VALLEY_NO._410' => 'Round Valley No. 410',
		'CAUNITY' => 'Unity',
		'CASENLAC_NO._411' => 'Senlac No. 411',
		'CASENLAC' => 'Senlac',
		'CAMANITOU_LAKE_NO._442' => 'Manitou Lake No. 442',
		'CAMARSDEN' => 'Marsden',
		'CAHILLSDALE_NO._440' => 'Hillsdale No. 440',
		'CANEILBURG' => 'Neilburg',
		'CACUT_KNIFE_NO._439' => 'Cut Knife No. 439',
		'CACUT_KNIFE' => 'Cut Knife',
		'CAPOUNDMAKER_114' => 'Poundmaker 114',
		'CALITTLE_PINE_116' => 'Little Pine 116',
		'CAHUDSON_BAY_NO._394' => 'Hudson Bay No. 394',
		'CAHUDSON_BAY' => 'Hudson Bay',
		'CAPORCUPINE_NO._395' => 'Porcupine No. 395',
		'CAPORCUPINE_PLAIN' => 'Porcupine Plain',
		'CAWEEKES' => 'Weekes',
		'CAKELVINGTON_NO._366' => 'Kelvington No. 366',
		'CAKELVINGTON' => 'Kelvington',
		'CAPONASS_LAKE_NO._367' => 'Ponass Lake No. 367',
		'CAROSE_VALLEY' => 'Rose Valley',
		'CAFOSSTON' => 'Fosston',
		'CASPALDING_NO._368' => 'Spalding No. 368',
		'CASPALDING' => 'Spalding',
		'CAPLEASANTDALE' => 'Pleasantdale',
		'CANAICAM' => 'Naicam',
		'CABARRIER_VALLEY_NO._397' => 'Barrier Valley No. 397',
		'CAPLEASANTDALE_NO._398' => 'Pleasantdale No. 398',
		'CAARCHERWILL' => 'Archerwill',
		'CABJORKDALE_NO._426' => 'Bjorkdale No. 426',
		'CAMISTATIM' => 'Mistatim',
		'CABJORKDALE' => 'Bjorkdale',
		'CATISDALE_NO._427' => 'Tisdale No. 427',
		'CATISDALE' => 'Tisdale',
		'CASTAR_CITY_NO._428' => 'Star City No. 428',
		'CAVALPARAISO' => 'Valparaiso',
		'CASTAR_CITY' => 'Star City',
		'CAMELFORT' => 'Melfort',
		'CAWILLOW_CREEK_NO._458' => 'Willow Creek No. 458',
		'CACONNAUGHT_NO._457' => 'Connaught No. 457',
		'CARIDGEDALE' => 'Ridgedale',
		'CAARBORFIELD_NO._456' => 'Arborfield No. 456',
		'CAZENON_PARK' => 'Zenon Park',
		'CAARBORFIELD' => 'Arborfield',
		'CAMOOSE_RANGE_NO._486' => 'Moose Range No. 486',
		'CATOBIN_LAKE' => 'Tobin Lake',
		'CACARROT_RIVER' => 'Carrot River',
		'CANIPAWIN_NO._487' => 'Nipawin No. 487',
		'CAAYLSHAM' => 'Aylsham',
		'CACODETTE' => 'Codette',
		'CANIPAWIN' => 'Nipawin',
		'CATORCH_RIVER_NO._488' => 'Torch River No. 488',
		'CAWHITE_FOX' => 'White Fox',
		'CALOVE' => 'Love',
		'CACHOICELAND' => 'Choiceland',
		'CASMEATON' => 'Smeaton',
		'CASHOAL_LAKE_28A' => 'Shoal Lake 28A',
		'CARED_EARTH_29' => 'Red Earth 29',
		'CAYELLOWQUILL_90' => 'Yellowquill 90',
		'CAKINISTIN_91' => 'Kinistin 91',
		'CAYELLOW_QUILL_90-9' => 'Yellow Quill 90-9',
		'CACARROT_RIVER_29A' => 'Carrot River 29A',
		'CAOPASKWAYAK_CREE_NATION_27A_(CARROT_R' => 'Opaskwayak Cree Nation 27A (Carrot River)',
		'CAST._PETER_NO._369' => 'St. Peter No. 369',
		'CAENGLEFELD' => 'Englefeld',
		'CAST._GREGOR' => 'St. Gregor',
		'CAMUENSTER' => 'Muenster',
		'CAANNAHEIM' => 'Annaheim',
		'CALAKE_LENORE' => 'Lake Lenore',
		'CAHUMBOLDT_NO._370' => 'Humboldt No. 370',
		'CAHUMBOLDT' => 'Humboldt',
		'CABAYNE_NO._371' => 'Bayne No. 371',
		'CABRUNO' => 'Bruno',
		'CAGRANT_NO._372' => 'Grant No. 372',
		'CAPRUDHOMME' => 'PrudHomme',
		'CAVONDA' => 'Vonda',
		'CAABERDEEN_NO._373' => 'Aberdeen No. 373',
		'CAABERDEEN' => 'Aberdeen',
		'CALAIRD_NO._404' => 'Laird No. 404',
		'CAHEPBURN' => 'Hepburn',
		'CAWALDHEIM' => 'Waldheim',
		'CALAIRD' => 'Laird',
		'CAROSTHERN_NO._403' => 'Rosthern No. 403',
		'CAROSTHERN' => 'Rosthern',
		'CAHAGUE' => 'Hague',
		'CAFISH_CREEK_NO._402' => 'Fish Creek No. 402',
		'CAALVENA' => 'Alvena',
		'CAHOODOO_NO._401' => 'Hoodoo No. 401',
		'CACUDWORTH' => 'Cudworth',
		'CAWAKAW' => 'Wakaw',
		'CAWAKAW_LAKE' => 'Wakaw Lake',
		'CATHREE_LAKES_NO._400' => 'Three Lakes No. 400',
		'CAPILGER' => 'Pilger',
		'CAST._BENEDICT' => 'St. Benedict',
		'CAMIDDLE_LAKE' => 'Middle Lake',
		'CALAKE_LENORE_NO._399' => 'Lake Lenore No. 399',
		'CAST._BRIEUX' => 'St. Brieux',
		'CAFLETTS_SPRINGS_NO._429' => 'Fletts Springs No. 429',
		'CABEATTY' => 'Beatty',
		'CAINVERGORDON_NO._430' => 'Invergordon No. 430',
		'CAST._LOUIS_NO._431' => 'St. Louis No. 431',
		'CAST._LOUIS' => 'St. Louis',
		'CADUCK_LAKE_NO._463' => 'Duck Lake No. 463',
		'CADUCK_LAKE' => 'Duck Lake',
		'CAPRINCE_ALBERT_NO._461' => 'Prince Albert No. 461',
		'CAPRINCE_ALBERT' => 'Prince Albert',
		'CABIRCH_HILLS_NO._460' => 'Birch Hills No. 460',
		'CABIRCH_HILLS' => 'Birch Hills',
		'CACANDLE_LAKE' => 'Candle Lake',
		'CAKINISTINO_NO._459' => 'Kinistino No. 459',
		'CAWELDON' => 'Weldon',
		'CAKINISTINO' => 'Kinistino',
		'CALAKELAND_NO._521' => 'Lakeland No. 521',
		'CACHRISTOPHER_LAKE' => 'Christopher Lake',
		'CAGARDEN_RIVER_NO._490' => 'Garden River No. 490',
		'CAALBERTVILLE' => 'Albertville',
		'CAWEIRDALE' => 'Weirdale',
		'CAMEATH_PARK' => 'Meath Park',
		'CABUCKLAND_NO._491' => 'Buckland No. 491',
		'CAPADDOCKWOOD' => 'Paddockwood',
		'CAPADDOCKWOOD_NO._520' => 'Paddockwood No. 520',
		'CAONE_ARROW_95' => 'One Arrow 95',
		'CABEARDYS_97_AND_OKEMASIS_96' => 'Beardys 97 and Okemasis 96',
		'CAMUSKODAY_FIRST_NATION' => 'Muskoday First Nation',
		'CAWAHPATON_94A' => 'Wahpaton 94A',
		'CAJAMES_SMITH_100' => 'James Smith 100',
		'CACUMBERLAND_100A' => 'Cumberland 100A',
		'CALITTLE_RED_RIVER_106C' => 'Little Red River 106C',
		'CAMONTREAL_LAKE_106B' => 'Montreal Lake 106B',
		'CAONE_ARROW_95-1C' => 'One Arrow 95-1C',
		'CABEARDYS_AND_OKEMASIS_96_AND_97B' => 'Beardys and Okemasis 96 and 97B',
		'CAONE_ARROW_95-1D' => 'One Arrow 95-1D',
		'CAONE_ARROW_95-1A' => 'One Arrow 95-1A',
		'CADENHOLM' => 'Denholm',
		'CARUDDELL' => 'Ruddell',
		'CAMAYMONT' => 'Maymont',
		'CAMAYFIELD_NO._406' => 'Mayfield No. 406',
		'CAGREAT_BEND_NO._405' => 'Great Bend No. 405',
		'CARADISSON' => 'Radisson',
		'CABORDEN' => 'Borden',
		'CABLAINE_LAKE_NO._434' => 'Blaine Lake No. 434',
		'CAMARCELIN' => 'Marcelin',
		'CABLAINE_LAKE' => 'Blaine Lake',
		'CAREDBERRY_NO._435' => 'Redberry No. 435',
		'CAKRYDOR' => 'Krydor',
		'CAHAFFORD' => 'Hafford',
		'CADOUGLAS_NO._436' => 'Douglas No. 436',
		'CASPEERS' => 'Speers',
		'CARICHARD' => 'Richard',
		'CANORTH_BATTLEFORD' => 'North Battleford',
		'CANORTH_BATTLEFORD_NO._437' => 'North Battleford No. 437',
		'CANORTH_BATTLEFORD' => 'North Battleford',
		'CAROUND_HILL_NO._467' => 'Round Hill No. 467',
		'CAMEETING_LAKE_NO._466' => 'Meeting Lake No. 466',
		'CALEASK_NO._464' => 'Leask No. 464',
		'CALEASK' => 'Leask',
		'CAPEBBLE_BAYE' => 'Pebble Baye',
		'CAPARKSIDE' => 'Parkside',
		'CASHELLBROOK_NO._493' => 'Shellbrook No. 493',
		'CASHELLBROOK' => 'Shellbrook',
		'CACANWOOD_NO._494' => 'Canwood No. 494',
		'CACANWOOD' => 'Canwood',
		'CAPRINCE_ALBERT_NATIONAL_PARK' => 'Prince Albert National Park',
		'CADEBDEN' => 'Debden',
		'CASPIRITWOOD_NO._496' => 'Spiritwood No. 496',
		'CASHELL_LAKE' => 'Shell Lake',
		'CASPIRITWOOD' => 'Spiritwood',
		'CABIG_SHELL' => 'Big Shell',
		'CAECHO_BAY' => 'Echo Bay',
		'CALEOVILLE' => 'Leoville',
		'CAMEDSTEAD_NO._497' => 'Medstead No. 497',
		'CAMEDSTEAD' => 'Medstead',
		'CABIG_RIVER' => 'Big River',
		'CABIG_RIVER_NO._555' => 'Big River No. 555',
		'CACHITEK_LAKE' => 'Chitek Lake',
		'CAMUSKEG_LAKE_CREE_NATION_102' => 'Muskeg Lake Cree Nation 102',
		'CAMISTAWASIS_103' => 'Mistawasis 103',
		'CASTURGEON_LAKE_101' => 'Sturgeon Lake 101',
		'CALITTLE_RED_RIVER_106D' => 'Little Red River 106D',
		'CABIG_RIVER_118' => 'Big River 118',
		'CAAHTAHKAKOOP_104' => 'Ahtahkakoop 104',
		'CASAULTEAUX_159A' => 'Saulteaux 159A',
		'CAWITCHEKAN_LAKE_117' => 'Witchekan Lake 117',
		'CACHITEK_LAKE_191' => 'Chitek Lake 191',
		'CALUCKY_MAN' => 'Lucky Man',
		'CAMUSKEG_LAKE_102B' => 'Muskeg Lake 102B',
		'CAPELICAN_LAKE_191B' => 'Pelican Lake 191B',
		'CAWITCHEKAN_LAKE_117D' => 'Witchekan Lake 117D',
		'CAMUSKEG_LAKE_102E' => 'Muskeg Lake 102E',
		'CAMUSKEG_LAKE_102F' => 'Muskeg Lake 102F',
		'CAMUSKEG_LAKE_102G' => 'Muskeg Lake 102G',
		'CAMUSKEG_LAKE_102D' => 'Muskeg Lake 102D',
		'CASWEET_GRASS_113-L6' => 'Sweet Grass 113-L6',
		'CAPELICAN_LAKE_191A' => 'Pelican Lake 191A',
		'CAMEOTA_NO._468' => 'Meota No. 468',
		'CACOCHIN' => 'Cochin',
		'CAMETINOTA' => 'Metinota',
		'CAAQUADEO' => 'Aquadeo',
		'CAMEOTA' => 'Meota',
		'CATURTLE_RIVER_NO._469' => 'Turtle River No. 469',
		'CAEDAM' => 'Edam',
		'CAPAYNTON_NO._470' => 'Paynton No. 470',
		'CAPAYNTON' => 'Paynton',
		'CAELDON_NO._471' => 'Eldon No. 471',
		'CAMAIDSTONE' => 'Maidstone',
		'CAWASECA' => 'Waseca',
		'CAWILTON_NO._472' => 'Wilton No. 472',
		'CALASHBURN' => 'Lashburn',
		'CAMARSHALL' => 'Marshall',
		'CABRITANNIA_NO._502' => 'Britannia No. 502',
		'CALLOYDMINSTER_(PART)' => 'Lloydminster (Part)',
		'CAFRENCHMAN_BUTTE_NO._501' => 'Frenchman Butte No. 501',
		'CAPARADISE_HILL' => 'Paradise Hill',
		'CAST._WALBURG' => 'St. Walburg',
		'CAMERVIN' => 'Mervin',
		'CATURTLEFORD' => 'Turtleford',
		'CAKIVIMAA-MOONLIGHT_BAY' => 'Kivimaa-Moonlight Bay',
		'CAMERVIN_NO._499' => 'Mervin No. 499',
		'CAPARKDALE_NO._498' => 'Parkdale No. 498',
		'CAGLASLYN' => 'Glaslyn',
		'CAMEADOW_LAKE' => 'Meadow Lake',
		'CAGREIG_LAKE' => 'Greig Lake',
		'CAMEADOW_LAKE_NO._588' => 'Meadow Lake No. 588',
		'CADORINTOSH' => 'Dorintosh',
		'CALOON_LAKE_NO._561' => 'Loon Lake No. 561',
		'CAMAKWA' => 'Makwa',
		'CALOON_LAKE' => 'Loon Lake',
		'CABEAVER_RIVER_NO._622' => 'Beaver River No. 622',
		'CAGOODSOIL' => 'Goodsoil',
		'CAPIERCELAND' => 'Pierceland',
		'CASEEKASKOOTCH_119' => 'Seekaskootch 119',
		'CAMAKAOO_(PART)_120' => 'Makaoo (Part) 120',
		'CATHUNDERCHILD_FIRST_NATION_115B' => 'Thunderchild First Nation 115B',
		'CATHUNDERCHILD_FIRST_NATION_115C' => 'Thunderchild First Nation 115C',
		'CAFLYING_DUST_FIRST_NATION_105_(MEADOW' => 'Flying Dust First Nation 105 (Meadow Lake 105)',
		'CAWATERHEN_130' => 'Waterhen 130',
		'CAMAKWA_LAKE_129B' => 'Makwa Lake 129B',
		'CAMAKWA_LAKE_129' => 'Makwa Lake 129',
		'CAMINISTIKWAN_161' => 'Ministikwan 161',
		'CAMINISTIKWAN_161A' => 'Ministikwan 161A',
		'CABIG_ISLAND_LAKE_CREE_TERRITORY' => 'Big Island Lake Cree Territory',
		'CAMOOSOMIN_112B' => 'Moosomin 112B',
		'CASAULTEAUX_159' => 'Saulteaux 159',
		'CAMAKWA_LAKE_129C' => 'Makwa Lake 129C',
		'CAEAGLES_LAKE_165C' => 'Eagles Lake 165C',
		'CAMEADOW_LAKE_105A' => 'Meadow Lake 105A',
		'CAONION_LAKE_119-1' => 'Onion Lake 119-1',
		'CAMIN-A-HE-QUO-SIS_116C' => 'Min-A-He-Quo-Sis 116C',
		'CACUMBERLAND_HOUSE' => 'Cumberland House',
		'CATIMBER_BAY' => 'Timber Bay',
		'CAWEYAKWIN' => 'Weyakwin',
		'CAGREEN_LAKE' => 'Green Lake',
		'CADORE_LAKE' => 'Dore Lake',
		'CACOLE_BAY' => 'Cole Bay',
		'CAJANS_BAY' => 'Jans Bay',
		'CABEAUVAL' => 'Beauval',
		'CALA_RONGE' => 'La Ronge',
		'CAAIR_RONGE' => 'Air Ronge',
		'CADENARE_BEACH' => 'Denare Beach',
		'CACREIGHTON' => 'Creighton',
		'CAFLIN_FLON_(PART)' => 'Flin Flon (Part)',
		'CAPELICAN_NARROWS' => 'Pelican Narrows',
		'CASANDY_BAY' => 'Sandy Bay',
		'CAMISSINIPE' => 'Missinipe',
		'CAPINEHOUSE' => 'Pinehouse',
		'CALE--LA-CROSSE' => 'le--la-Crosse',
		'CAPATUANAK' => 'Patuanak',
		'CABUFFALO_NARROWS' => 'Buffalo Narrows',
		'CAST._GEORGES_HILL' => 'St. Georges Hill',
		'CAMICHEL_VILLAGE' => 'Michel Village',
		'CALA_LOCHE' => 'La Loche',
		'CATURNOR_LAKE' => 'Turnor Lake',
		'CADIVISION_NO._18,_UNORGANIZED' => 'Division No. 18, Unorganized',
		'CASTONY_RAPIDS' => 'Stony Rapids',
		'CACUMBERLAND_HOUSE_CREE_NATION_20' => 'Cumberland House Cree Nation 20',
		'CAMONTREAL_LAKE_106' => 'Montreal Lake 106',
		'CASTANLEY_157' => 'Stanley 157',
		'CAWAPASKOKIMAW_202' => 'Wapaskokimaw 202',
		'CALA_PLONGE_192' => 'La Plonge 192',
		'CAMORIN_LAKE_217' => 'Morin Lake 217',
		'CALAC_LA_RONGE_156' => 'Lac La Ronge 156',
		'CASUCKER_RIVER_156C_(NEMEBIEN_RIVER_15' => 'Sucker River 156C (Nemebien River 156C)',
		'CAKITSAKIE_156B' => 'Kitsakie 156B',
		'CAFOUR_PORTAGES_157C' => 'Four Portages 157C',
		'CAWAPACHEWUNAK_192D' => 'Wapachewunak 192D',
		'CACANOE_LAKE_165' => 'Canoe Lake 165',
		'CABUFFALO_RIVER_DENE_NATION_193_(PETER' => 'Buffalo River Dene Nation 193 (Peter Pond Lake 193)',
		'CATURNOR_LAKE_193B' => 'Turnor Lake 193B',
		'CAPELICAN_NARROWS_184B' => 'Pelican Narrows 184B',
		'CASTURGEON_WEIR_184F' => 'Sturgeon Weir 184F',
		'CASOUTHEND_200' => 'Southend 200',
		'CACHICKEN_225' => 'Chicken 225',
		'CAFOND_DU_LAC_227' => 'Fond du Lac 227',
		'CABRABANT_LAKE' => 'Brabant Lake',
		'CASOUTHEND_NO._200A' => 'Southend No. 200A',
		'CACHICKEN_224' => 'Chicken 224',
		'CACLEARWATER_RIVER_DENE_BAND_223' => 'Clearwater River Dene Band 223',
		'CAGRANDMOTHERS_BAY_219' => 'Grandmothers Bay 219',
		'CALAC_LA_HACHE_220' => 'Lac La Hache 220',
		'CACLEARWATER_RIVER_DENE_222' => 'Clearwater River Dene 222',
		'CALITTLE_HILLS_158' => 'Little Hills 158',
		'CALITTLE_HILLS_158B' => 'Little Hills 158B',
		'CAKIMOSOM_PWATINAHK_203_(DESCHAMBAULT_' => 'Kimosom Pwatinahk 203 (Deschambault Lake)',
		'CAKINOOSAO-THOMAS_CLARK_204' => 'Kinoosao-Thomas Clark 204',
	],
	'AB' => [
		'CACYPRESS_COUNTY' => 'Cypress County',
		'CAMEDICINE_HAT' => 'Medicine Hat',
		'CAFORTY_MILE_COUNTY_NO._8' => 'Forty Mile County No. 8',
		'CAFOREMOST' => 'Foremost',
		'CABOW_ISLAND' => 'Bow Island',
		'CAREDCLIFF' => 'Redcliff',
		'CAWARNER_COUNTY_NO._5' => 'Warner County No. 5',
		'CACOUTTS' => 'Coutts',
		'CAMILK_RIVER' => 'Milk River',
		'CAWARNER' => 'Warner',
		'CARAYMOND' => 'Raymond',
		'CASTIRLING' => 'Stirling',
		'CALETHBRIDGE_COUNTY' => 'Lethbridge County',
		'CALETHBRIDGE' => 'Lethbridge',
		'CACOALHURST' => 'Coalhurst',
		'CANOBLEFORD' => 'Nobleford',
		'CABARONS' => 'Barons',
		'CAPICTURE_BUTTE' => 'Picture Butte',
		'CACOALDALE' => 'Coaldale',
		'CATABER' => 'Taber',
		'CATABER' => 'Taber',
		'CABARNWELL' => 'Barnwell',
		'CAVAUXHALL' => 'Vauxhall',
		'CANEWELL_COUNTY' => 'Newell County',
		'CABROOKS' => 'Brooks',
		'CADUCHESS' => 'Duchess',
		'CAROSEMARY' => 'Rosemary',
		'CABASSANO' => 'Bassano',
		'CACARDSTON_COUNTY' => 'Cardston County',
		'CAMAGRATH' => 'Magrath',
		'CAIMPROVEMENT_DISTRICT_NO.__4_WATERTON' => 'Improvement District No.  4 Waterton',
		'CACARDSTON' => 'Cardston',
		'CAGLENWOOD' => 'Glenwood',
		'CAHILL_SPRING' => 'Hill Spring',
		'CAPINCHER_CREEK_NO._9' => 'Pincher Creek No. 9',
		'CAPINCHER_CREEK' => 'Pincher Creek',
		'CACOWLEY' => 'Cowley',
		'CAWILLOW_CREEK_NO._26' => 'Willow Creek No. 26',
		'CAFORT_MACLEOD' => 'Fort Macleod',
		'CAGRANUM' => 'Granum',
		'CACLARESHOLM' => 'Claresholm',
		'CASTAVELY' => 'Stavely',
		'CANANTON' => 'Nanton',
		'CAPIIKANI_147' => 'Piikani 147',
		'CABLOOD_148' => 'Blood 148',
		'CABLOOD_148A' => 'Blood 148A',
		'CAACADIA_NO._34' => 'Acadia No. 34',
		'CASPECIAL_AREA_NO._2' => 'Special Area No. 2',
		'CAEMPRESS' => 'Empress',
		'CAHANNA' => 'Hanna',
		'CASPECIAL_AREA_NO._3' => 'Special Area No. 3',
		'CAOYEN' => 'Oyen',
		'CACEREAL' => 'Cereal',
		'CAYOUNGSTOWN' => 'Youngstown',
		'CASPECIAL_AREA_NO._4' => 'Special Area No. 4',
		'CAVETERAN' => 'Veteran',
		'CACONSORT' => 'Consort',
		'CAVULCAN_COUNTY' => 'Vulcan County',
		'CACARMANGAY' => 'Carmangay',
		'CACHAMPION' => 'Champion',
		'CAVULCAN' => 'Vulcan',
		'CALOMOND' => 'Lomond',
		'CAMILO' => 'Milo',
		'CAARROWWOOD' => 'Arrowwood',
		'CAWHEATLAND_COUNTY' => 'Wheatland County',
		'CASTRATHMORE' => 'Strathmore',
		'CAHUSSAR' => 'Hussar',
		'CASTANDARD' => 'Standard',
		'CAROCKYFORD' => 'Rockyford',
		'CADRUMHELLER' => 'Drumheller',
		'CASTARLAND_COUNTY' => 'Starland County',
		'CADELIA' => 'Delia',
		'CAMUNSON' => 'Munson',
		'CAMORRIN' => 'Morrin',
		'CAKNEEHILL_COUNTY' => 'Kneehill County',
		'CACARBON' => 'Carbon',
		'CAACME' => 'Acme',
		'CALINDEN' => 'Linden',
		'CATHREE_HILLS' => 'Three Hills',
		'CATROCHU' => 'Trochu',
		'CASIKSIKA_146' => 'Siksika 146',
		'CAFOOTHILLS_NO._31' => 'Foothills No. 31',
		'CAHIGH_RIVER' => 'High River',
		'CALONGVIEW' => 'Longview',
		'CATURNER_VALLEY' => 'Turner Valley',
		'CABLACK_DIAMOND' => 'Black Diamond',
		'CAOKOTOKS' => 'Okotoks',
		'CAROCKY_VIEW_COUNTY' => 'Rocky View County',
		'CACALGARY' => 'Calgary',
		'CACHESTERMERE' => 'Chestermere',
		'CACOCHRANE' => 'Cochrane',
		'CAAIRDRIE' => 'Airdrie',
		'CAIRRICANA' => 'Irricana',
		'CABEISEKER' => 'Beiseker',
		'CACROSSFIELD' => 'Crossfield',
		'CAMOUNTAIN_VIEW_COUNTY' => 'Mountain View County',
		'CACARSTAIRS' => 'Carstairs',
		'CACREMONA' => 'Cremona',
		'CADIDSBURY' => 'Didsbury',
		'CAOLDS' => 'Olds',
		'CASUNDRE' => 'Sundre',
		'CAEDEN_VALLEY_216' => 'Eden Valley 216',
		'CATSUU_TINA_NATION_145_(SARCEE_145)' => 'Tsuu Tina Nation 145 (Sarcee 145)',
		'CAPROVOST_NO._52' => 'Provost No. 52',
		'CAPROVOST' => 'Provost',
		'CACZAR' => 'Czar',
		'CAHUGHENDEN' => 'Hughenden',
		'CAAMISK' => 'Amisk',
		'CAPAINTEARTH_COUNTY_NO._18' => 'Paintearth County No. 18',
		'CACORONATION' => 'Coronation',
		'CACASTOR' => 'Castor',
		'CAHALKIRK' => 'Halkirk',
		'CASTETTLER_COUNTY_NO._6' => 'Stettler County No. 6',
		'CABIG_VALLEY' => 'Big Valley',
		'CAGADSBY' => 'Gadsby',
		'CABOTHA' => 'Botha',
		'CASTETTLER' => 'Stettler',
		'CAWHITE_SANDS' => 'White Sands',
		'CAROCHON_SANDS' => 'Rochon Sands',
		'CADONALDA' => 'Donalda',
		'CAFLAGSTAFF_COUNTY' => 'Flagstaff County',
		'CAALLIANCE' => 'Alliance',
		'CAFORESTBURG' => 'Forestburg',
		'CAHEISLER' => 'Heisler',
		'CADAYSLAND' => 'Daysland',
		'CAKILLAM' => 'Killam',
		'CASEDGEWICK' => 'Sedgewick',
		'CALOUGHEED' => 'Lougheed',
		'CAHARDISTY' => 'Hardisty',
		'CAWAINWRIGHT_NO._61' => 'Wainwright No. 61',
		'CACHAUVIN' => 'Chauvin',
		'CAEDGERTON' => 'Edgerton',
		'CAWAINWRIGHT' => 'Wainwright',
		'CAIRMA' => 'Irma',
		'CARED_DEER_COUNTY' => 'Red Deer County',
		'CAELNORA' => 'Elnora',
		'CADELBURNE' => 'Delburne',
		'CAJARVIS_BAY' => 'Jarvis Bay',
		'CABOWDEN' => 'Bowden',
		'CAINNISFAIL' => 'Innisfail',
		'CAPENHOLD' => 'Penhold',
		'CARED_DEER' => 'Red Deer',
		'CASYLVAN_LAKE' => 'Sylvan Lake',
		'CANORGLENWOLD' => 'Norglenwold',
		'CALACOMBE_COUNTY' => 'Lacombe County',
		'CABIRCHCLIFF' => 'Birchcliff',
		'CAECKVILLE' => 'Eckville',
		'CAHALF_MOON_BAY' => 'Half Moon Bay',
		'CABENTLEY' => 'Bentley',
		'CASUNBREAKER_COVE' => 'Sunbreaker Cove',
		'CAGULL_LAKE' => 'Gull Lake',
		'CABLACKFALDS' => 'Blackfalds',
		'CALACOMBE' => 'Lacombe',
		'CACLIVE' => 'Clive',
		'CAALIX' => 'Alix',
		'CAPONOKA_COUNTY' => 'Ponoka County',
		'CAPONOKA' => 'Ponoka',
		'CAPARKLAND_BEACH' => 'Parkland Beach',
		'CARIMBEY' => 'Rimbey',
		'CASAMSON_137' => 'Samson 137',
		'CASAMSON_137A' => 'Samson 137A',
		'CAMONTANA_139' => 'Montana 139',
		'CACLEARWATER_COUNTY' => 'Clearwater County',
		'CABURNSTICK_LAKE' => 'Burnstick Lake',
		'CACAROLINE' => 'Caroline',
		'CAROCKY_MOUNTAIN_HOUSE' => 'Rocky Mountain House',
		'CAOCHIESE_203' => 'OChiese 203',
		'CASUNCHILD_202' => 'Sunchild 202',
		'CABIG_HORN_144A' => 'Big Horn 144A',
		'CACAMROSE_COUNTY' => 'Camrose County',
		'CABASHAW' => 'Bashaw',
		'CAROSALIND' => 'Rosalind',
		'CAFERINTOSH' => 'Ferintosh',
		'CAEDBERG' => 'Edberg',
		'CABAWLF' => 'Bawlf',
		'CACAMROSE' => 'Camrose',
		'CABITTERN_LAKE' => 'Bittern Lake',
		'CAHAY_LAKES' => 'Hay Lakes',
		'CABEAVER_COUNTY' => 'Beaver County',
		'CATOFIELD' => 'Tofield',
		'CARYLEY' => 'Ryley',
		'CAHOLDEN' => 'Holden',
		'CAVIKING' => 'Viking',
		'CAMINBURN_COUNTY_NO._27' => 'Minburn County No. 27',
		'CAVEGREVILLE' => 'Vegreville',
		'CAINNISFREE' => 'Innisfree',
		'CAMANNVILLE' => 'Mannville',
		'CAVERMILION_RIVER_COUNTY' => 'Vermilion River County',
		'CAPARADISE_VALLEY' => 'Paradise Valley',
		'CALLOYDMINSTER_(PART)' => 'Lloydminster (Part)',
		'CAKITSCOTY' => 'Kitscoty',
		'CAVERMILION' => 'Vermilion',
		'CAMARWAYNE' => 'Marwayne',
		'CADEWBERRY' => 'Dewberry',
		'CATWO_HILLS_COUNTY_NO._21' => 'Two Hills County No. 21',
		'CAMYRNAM' => 'Myrnam',
		'CATWO_HILLS' => 'Two Hills',
		'CAWILLINGDON' => 'Willingdon',
		'CALAMONT_COUNTY' => 'Lamont County',
		'CAANDREW' => 'Andrew',
		'CAMUNDARE' => 'Mundare',
		'CACHIPMAN' => 'Chipman',
		'CALAMONT' => 'Lamont',
		'CABRUDERHEIM' => 'Bruderheim',
		'CAIMPROVEMENT_DISTRICT_NO._13_ELK_ISLA' => 'Improvement District No. 13 Elk Island',
		'CAMAKAOO_(PART)_120' => 'Makaoo (Part) 120',
		'CAWETASKIWIN_COUNTY_NO._10' => 'Wetaskiwin County No. 10',
		'CAWETASKIWIN' => 'Wetaskiwin',
		'CAARGENTIA_BEACH' => 'Argentia Beach',
		'CAGRANDVIEW' => 'Grandview',
		'CAPOPLAR_BAY' => 'Poplar Bay',
		'CACRYSTAL_SPRINGS' => 'Crystal Springs',
		'CANORRIS_BEACH' => 'Norris Beach',
		'CAMA-ME-O_BEACH' => 'Ma-Me-O Beach',
		'CASILVER_BEACH' => 'Silver Beach',
		'CAMILLET' => 'Millet',
		'CALEDUC_COUNTY' => 'Leduc County',
		'CABEAUMONT' => 'Beaumont',
		'CALEDUC' => 'Leduc',
		'CADEVON' => 'Devon',
		'CACALMAR' => 'Calmar',
		'CASUNDANCE_BEACH' => 'Sundance Beach',
		'CATHORSBY' => 'Thorsby',
		'CAITASKA_BEACH' => 'Itaska Beach',
		'CAGOLDEN_DAYS' => 'Golden Days',
		'CAWARBURG' => 'Warburg',
		'CABRETON' => 'Breton',
		'CADRAYTON_VALLEY' => 'Drayton Valley',
		'CABRAZEAU_COUNTY' => 'Brazeau County',
		'CAPARKLAND_COUNTY' => 'Parkland County',
		'CASEBA_BEACH' => 'Seba Beach',
		'CABETULA_BEACH' => 'Betula Beach',
		'CAPOINT_ALISON' => 'Point Alison',
		'CALAKEVIEW' => 'Lakeview',
		'CAKAPASIWIN' => 'Kapasiwin',
		'CAWABAMUN' => 'Wabamun',
		'CASPRING_LAKE' => 'Spring Lake',
		'CASTONY_PLAIN' => 'Stony Plain',
		'CASPRUCE_GROVE' => 'Spruce Grove',
		'CASTRATHCONA_COUNTY' => 'Strathcona County',
		'CAFORT_SASKATCHEWAN' => 'Fort Saskatchewan',
		'CASTURGEON_COUNTY' => 'Sturgeon County',
		'CAEDMONTON' => 'Edmonton',
		'CAST._ALBERT' => 'St. Albert',
		'CAGIBBONS' => 'Gibbons',
		'CAREDWATER' => 'Redwater',
		'CABON_ACCORD' => 'Bon Accord',
		'CAMORINVILLE' => 'Morinville',
		'CALEGAL' => 'Legal',
		'CAERMINESKIN_138' => 'Ermineskin 138',
		'CAPIGEON_LAKE_138A' => 'Pigeon Lake 138A',
		'CALOUIS_BULL_138B' => 'Louis Bull 138B',
		'CASTONY_PLAIN_135' => 'Stony Plain 135',
		'CAALEXANDER_134' => 'Alexander 134',
		'CAWABAMUN_133A' => 'Wabamun 133A',
		'CAWABAMUN_133B' => 'Wabamun 133B',
		'CACOLD_LAKE' => 'Cold Lake',
		'CABONNYVILLE_NO._87' => 'Bonnyville No. 87',
		'CABONNYVILLE' => 'Bonnyville',
		'CABONNYVILLE_BEACH' => 'Bonnyville Beach',
		'CAGLENDON' => 'Glendon',
		'CAPELICAN_NARROWS' => 'Pelican Narrows',
		'CAST._PAUL_COUNTY_NO._19' => 'St. Paul County No. 19',
		'CAELK_POINT' => 'Elk Point',
		'CAST._PAUL' => 'St. Paul',
		'CAHORSESHOE_BAY' => 'Horseshoe Bay',
		'CASMOKY_LAKE_COUNTY' => 'Smoky Lake County',
		'CAVILNA' => 'Vilna',
		'CAWASKATENAU' => 'Waskatenau',
		'CASMOKY_LAKE' => 'Smoky Lake',
		'CALAC_LA_BICHE_COUNTY' => 'Lac la Biche County',
		'CAIMPROVEMENT_DISTRICT_NO._349' => 'Improvement District No. 349',
		'CAUNIPOUHEOS_121' => 'Unipouheos 121',
		'CAPUSKIAKIWENIN_122' => 'Puskiakiwenin 122',
		'CASADDLE_LAKE_125' => 'Saddle Lake 125',
		'CAWHITE_FISH_LAKE_128' => 'White Fish Lake 128',
		'CACOLD_LAKE_149' => 'Cold Lake 149',
		'CAKEHEWIN_123' => 'Kehewin 123',
		'CACOLD_LAKE_149A' => 'Cold Lake 149A',
		'CACOLD_LAKE_149B' => 'Cold Lake 149B',
		'CABEAVER_LAKE_131' => 'Beaver Lake 131',
		'CAHEART_LAKE_167' => 'Heart Lake 167',
		'CALAC_STE._ANNE_COUNTY' => 'Lac Ste. Anne County',
		'CAMAYERTHORPE' => 'Mayerthorpe',
		'CANAKAMUN_PARK' => 'Nakamun Park',
		'CAVAL_QUENTIN' => 'Val Quentin',
		'CAWEST_COVE' => 'West Cove',
		'CAYELLOWSTONE' => 'Yellowstone',
		'CAROSS_HAVEN' => 'Ross Haven',
		'CACASTLE_ISLAND' => 'Castle Island',
		'CASILVER_SANDS' => 'Silver Sands',
		'CASUNSET_POINT' => 'Sunset Point',
		'CAALBERTA_BEACH' => 'Alberta Beach',
		'CABIRCH_COVE' => 'Birch Cove',
		'CAONOWAY' => 'Onoway',
		'CASOUTH_VIEW' => 'South View',
		'CASANDY_BEACH' => 'Sandy Beach',
		'CASUNRISE_BEACH' => 'Sunrise Beach',
		'CABARRHEAD_COUNTY_NO._11' => 'Barrhead County No. 11',
		'CABARRHEAD' => 'Barrhead',
		'CAWESTLOCK_COUNTY' => 'Westlock County',
		'CAWOODLANDS_COUNTY' => 'Woodlands County',
		'CAWHITECOURT' => 'Whitecourt',
		'CAWESTLOCK' => 'Westlock',
		'CACLYDE' => 'Clyde',
		'CALARKSPUR' => 'Larkspur',
		'CATHORHILD_COUNTY' => 'Thorhild County',
		'CAATHABASCA_COUNTY' => 'Athabasca County',
		'CAMEWATHA_BEACH' => 'Mewatha Beach',
		'CABOYLE' => 'Boyle',
		'CASUNSET_BEACH' => 'Sunset Beach',
		'CAATHABASCA' => 'Athabasca',
		'CAISLAND_LAKE' => 'Island Lake',
		'CAISLAND_LAKE_SOUTH' => 'Island Lake South',
		'CABONDISS' => 'Bondiss',
		'CASOUTH_BAPTISTE' => 'South Baptiste',
		'CAWEST_BAPTISTE' => 'West Baptiste',
		'CAWHISPERING_HILLS' => 'Whispering Hills',
		'CAALEXIS_133' => 'Alexis 133',
		'CAYELLOWHEAD_COUNTY' => 'Yellowhead County',
		'CAHINTON' => 'Hinton',
		'CAEDSON' => 'Edson',
		'CAIMPROVEMENT_DISTRICT_NO._25_WILLMORE' => 'Improvement District No. 25 Willmore Wilderness',
		'CACROWSNEST_PASS' => 'Crowsnest Pass',
		'CAKANANASKIS' => 'Kananaskis',
		'CABIGHORN_NO._8' => 'Bighorn No. 8',
		'CACANMORE' => 'Canmore',
		'CAGHOST_LAKE' => 'Ghost Lake',
		'CAWAIPAROUS' => 'Waiparous',
		'CAIMPROVEMENT_DISTRICT_NO.__9_BANFF' => 'Improvement District No.  9 Banff',
		'CAJASPER' => 'Jasper',
		'CABANFF' => 'Banff',
		'CAIMPROVEMENT_DISTRICT_NO._12_JASPER_P' => 'Improvement District No. 12 Jasper Park',
		'CARANCHLAND_NO._66' => 'Ranchland No. 66',
		'CASTONEY_142,_143,_144' => 'Stoney 142, 143, 144',
		'CAWOOD_BUFFALO' => 'Wood Buffalo',
		'CAIMPROVEMENT_DISTRICT_NO._24_WOOD_BUF' => 'Improvement District No. 24 Wood Buffalo',
		'CAJANVIER_194' => 'Janvier 194',
		'CAGREGOIRE_LAKE_176' => 'Gregoire Lake 176',
		'CAGREGOIRE_LAKE_176A' => 'Gregoire Lake 176A',
		'CACHIPEWYAN_201A' => 'Chipewyan 201A',
		'CAOLD_FORT_217' => 'Old Fort 217',
		'CAALLISON_BAY_219' => 'Allison Bay 219',
		'CADOG_HEAD_218' => 'Dog Head 218',
		'CAFORT_MACKAY' => 'Fort Mackay',
		'CATHEBATHI_196' => 'Thebathi 196',
		'CATHABACHA_NRE_196A' => 'Thabacha Nre 196A',
		'CAHIGH_PRAIRIE' => 'High Prairie',
		'CASWAN_HILLS' => 'Swan Hills',
		'CANORTHERN_SUNRISE_COUNTY' => 'Northern Sunrise County',
		'CABIG_LAKES_COUNTY' => 'Big Lakes County',
		'CASLAVE_LAKE' => 'Slave Lake',
		'CAOPPORTUNITY_NO._17' => 'Opportunity No. 17',
		'CALESSER_SLAVE_RIVER_NO.124' => 'Lesser Slave River No.124',
		'CANAMPA' => 'Nampa',
		'CACLEAR_HILLS' => 'Clear Hills',
		'CAHINES_CREEK' => 'Hines Creek',
		'CANORTHERN_LIGHTS_COUNTY' => 'Northern Lights County',
		'CAMANNING' => 'Manning',
		'CAHIGH_LEVEL' => 'High Level',
		'CAMACKENZIE_COUNTY' => 'Mackenzie County',
		'CARAINBOW_LAKE' => 'Rainbow Lake',
		'CAJEAN_BAPTISTE_GAMBLER_183' => 'Jean Baptiste Gambler 183',
		'CAWABASCA_166' => 'Wabasca 166',
		'CAWABASCA_166A' => 'Wabasca 166A',
		'CAWABASCA_166B' => 'Wabasca 166B',
		'CAWABASCA_166C' => 'Wabasca 166C',
		'CAWABASCA_166D' => 'Wabasca 166D',
		'CAUTIKOOMAK_LAKE_155' => 'Utikoomak Lake 155',
		'CACLEAR_HILLS_152C' => 'Clear Hills 152C',
		'CAUTIKOOMAK_LAKE_155A' => 'Utikoomak Lake 155A',
		'CADRIFT_PILE_RIVER_150' => 'Drift Pile River 150',
		'CASUCKER_CREEK_150A' => 'Sucker Creek 150A',
		'CAKAPAWENO_FIRST_NATION_(PAKASHAN_150D' => 'Kapaweno First Nation (Pakashan 150D)',
		'CASWAN_RIVER_150E' => 'Swan River 150E',
		'CASAWRIDGE_150G' => 'Sawridge 150G',
		'CASAWRIDGE_150H' => 'Sawridge 150H',
		'CAFOX_LAKE_162' => 'Fox Lake 162',
		'CAKAPAWENO_FIRST_NATION_(FREEMAN_150B)' => 'Kapaweno First Nation (Freeman 150B)',
		'CAJOHN_DOR_PRAIRIE_215' => 'John dOr Prairie 215',
		'CATALL_CREE_173' => 'Tall Cree 173',
		'CATALL_CREE_173A' => 'Tall Cree 173A',
		'CABEAVER_RANCH_163' => 'Beaver Ranch 163',
		'CABOYER_164' => 'Boyer 164',
		'CACHILD_LAKE_164A' => 'Child Lake 164A',
		'CAHAY_LAKE_209' => 'Hay Lake 209',
		'CABUSHE_RIVER_207' => 'Bushe River 207',
		'CAUPPER_HAY_RIVER_212' => 'Upper Hay River 212',
		'CALITTLE_BUFFALO' => 'Little Buffalo',
		'CACARCAJOU_187' => 'Carcajou 187',
		'CADESMARAIS' => 'Desmarais',
		'CAWOODLAND_CREE_226' => 'Woodland Cree 226',
		'CAWOODLAND_CREE_228' => 'Woodland Cree 228',
		'CAFORT_VERMILION_173B' => 'Fort Vermilion 173B',
		'CALOON_LAKE_235' => 'Loon Lake 235',
		'CAFOX_CREEK' => 'Fox Creek',
		'CAGRANDE_CACHE' => 'Grande Cache',
		'CAGREENVIEW_NO._16' => 'Greenview No. 16',
		'CAVALLEYVIEW' => 'Valleyview',
		'CASTURGEON_LAKE_154' => 'Sturgeon Lake 154',
		'CASTURGEON_LAKE_154A' => 'Sturgeon Lake 154A',
		'CAGRANDE_PRAIRIE_COUNTY_NO._1' => 'Grande Prairie County No. 1',
		'CAHYTHE' => 'Hythe',
		'CABEAVERLODGE' => 'Beaverlodge',
		'CAWEMBLEY' => 'Wembley',
		'CAGRANDE_PRAIRIE' => 'Grande Prairie',
		'CASEXSMITH' => 'Sexsmith',
		'CAPEACE_RIVER' => 'Peace River',
		'CASMOKY_RIVER_NO._130' => 'Smoky River No. 130',
		'CAMCLENNAN' => 'McLennan',
		'CADONNELLY' => 'Donnelly',
		'CAFALHER' => 'Falher',
		'CAGIROUXVILLE' => 'Girouxville',
		'CABIRCH_HILLS_COUNTY' => 'Birch Hills County',
		'CASPIRIT_RIVER_NO._133' => 'Spirit River No. 133',
		'CARYCROFT' => 'Rycroft',
		'CASPIRIT_RIVER' => 'Spirit River',
		'CASADDLE_HILLS_COUNTY' => 'Saddle Hills County',
		'CAFAIRVIEW_NO._136' => 'Fairview No. 136',
		'CAFAIRVIEW' => 'Fairview',
		'CAPEACE_NO._135' => 'Peace No. 135',
		'CABERWYN' => 'Berwyn',
		'CAGRIMSHAW' => 'Grimshaw',
		'CAHORSE_LAKES_152B' => 'Horse Lakes 152B',
		'CADUNCANS_151A' => 'Duncans 151A',
	],
	'BC' => [
		'CAELKFORD' => 'Elkford',
		'CASPARWOOD' => 'Sparwood',
		'CAFERNIE' => 'Fernie',
		'CAEAST_KOOTENAY_A' => 'East Kootenay A',
		'CAEAST_KOOTENAY_B' => 'East Kootenay B',
		'CACRANBROOK' => 'Cranbrook',
		'CAKIMBERLEY' => 'Kimberley',
		'CAEAST_KOOTENAY_C' => 'East Kootenay C',
		'CAEAST_KOOTENAY_E' => 'East Kootenay E',
		'CAINVERMERE' => 'Invermere',
		'CARADIUM_HOT_SPRINGS' => 'Radium Hot Springs',
		'CACANAL_FLATS' => 'Canal Flats',
		'CAEAST_KOOTENAY_F' => 'East Kootenay F',
		'CAEAST_KOOTENAY_G' => 'East Kootenay G',
		'CATOBACCO_PLAINS_2' => 'Tobacco Plains 2',
		'CAISIDORES_RANCH_4' => 'Isidores Ranch 4',
		'CAKOOTENAY_1' => 'Kootenay 1',
		'CACOLUMBIA_LAKE_3' => 'Columbia Lake 3',
		'CACASSIMAYOOKS_(MAYOOK)_5' => 'Cassimayooks (Mayook) 5',
		'CASHUSWAP' => 'Shuswap',
		'CACRESTON' => 'Creston',
		'CACENTRAL_KOOTENAY_A' => 'Central Kootenay A',
		'CASALMO' => 'Salmo',
		'CACENTRAL_KOOTENAY_B' => 'Central Kootenay B',
		'CANELSON' => 'Nelson',
		'CACENTRAL_KOOTENAY_C' => 'Central Kootenay C',
		'CASLOCAN' => 'Slocan',
		'CAKASLO' => 'Kaslo',
		'CASILVERTON' => 'Silverton',
		'CANEW_DENVER' => 'New Denver',
		'CACENTRAL_KOOTENAY_D' => 'Central Kootenay D',
		'CACENTRAL_KOOTENAY_E' => 'Central Kootenay E',
		'CACENTRAL_KOOTENAY_F' => 'Central Kootenay F',
		'CACASTLEGAR' => 'Castlegar',
		'CACENTRAL_KOOTENAY_G' => 'Central Kootenay G',
		'CANAKUSP' => 'Nakusp',
		'CACENTRAL_KOOTENAY_H' => 'Central Kootenay H',
		'CACENTRAL_KOOTENAY_I' => 'Central Kootenay I',
		'CACENTRAL_KOOTENAY_J' => 'Central Kootenay J',
		'CACENTRAL_KOOTENAY_K' => 'Central Kootenay K',
		'CACRESTON_1' => 'Creston 1',
		'CAFRUITVALE' => 'Fruitvale',
		'CAMONTROSE' => 'Montrose',
		'CATRAIL' => 'Trail',
		'CAWARFIELD' => 'Warfield',
		'CAROSSLAND' => 'Rossland',
		'CAKOOTENAY_BOUNDARY_A' => 'Kootenay Boundary A',
		'CAKOOTENAY_BOUNDARY_B_/_LOWER_COLUMBIA' => 'Kootenay Boundary B / Lower Columbia-Old-Glory',
		'CAGRAND_FORKS' => 'Grand Forks',
		'CAMIDWAY' => 'Midway',
		'CAGREENWOOD' => 'Greenwood',
		'CAKOOTENAY_BOUNDARY_C_/_CHRISTINA_LAKE' => 'Kootenay Boundary C / Christina Lake',
		'CAKOOTENAY_BOUNDARY_D_/_RURAL_GRAND_FO' => 'Kootenay Boundary D / Rural Grand Forks',
		'CAKOOTENAY_BOUNDARY_E_/_WEST_BOUNDARY' => 'Kootenay Boundary E / West Boundary',
		'CAOSOYOOS' => 'Osoyoos',
		'CAKEREMEOS' => 'Keremeos',
		'CAOLIVER' => 'Oliver',
		'CAOKANAGAN-SIMILKAMEEN_A' => 'Okanagan-Similkameen A',
		'CAPRINCETON' => 'Princeton',
		'CAOKANAGAN-SIMILKAMEEN_B' => 'Okanagan-Similkameen B',
		'CAOKANAGAN-SIMILKAMEEN_C' => 'Okanagan-Similkameen C',
		'CASUMMERLAND' => 'Summerland',
		'CAPENTICTON' => 'Penticton',
		'CAOKANAGAN-SIMILKAMEEN_D' => 'Okanagan-Similkameen D',
		'CAOKANAGAN-SIMILKAMEEN_E' => 'Okanagan-Similkameen E',
		'CAOKANAGAN-SIMILKAMEEN_F' => 'Okanagan-Similkameen F',
		'CAOKANAGAN-SIMILKAMEEN_G' => 'Okanagan-Similkameen G',
		'CAOKANAGAN-SIMILKAMEEN_H' => 'Okanagan-Similkameen H',
		'CALOWER_SIMILKAMEEN_2' => 'Lower Similkameen 2',
		'CAOSOYOOS_1' => 'Osoyoos 1',
		'CAPENTICTON_1' => 'Penticton 1',
		'CACHOPAKA_7_&_8' => 'Chopaka 7 & 8',
		'CABLIND_CREEK_6' => 'Blind Creek 6',
		'CACHUCHUWAYHA_2' => 'Chuchuwayha 2',
		'CAALEXIS_9' => 'Alexis 9',
		'CAASHNOLA_10' => 'Ashnola 10',
		'CAHOPE' => 'Hope',
		'CAFRASER_VALLEY_A' => 'Fraser Valley A',
		'CAFRASER_VALLEY_B' => 'Fraser Valley B',
		'CACHILLIWACK' => 'Chilliwack',
		'CAHARRISON_HOT_SPRINGS' => 'Harrison Hot Springs',
		'CAKENT' => 'Kent',
		'CAFRASER_VALLEY_D' => 'Fraser Valley D',
		'CAFRASER_VALLEY_H' => 'Fraser Valley H',
		'CAFRASER_VALLEY_E' => 'Fraser Valley E',
		'CAFRASER_VALLEY_C' => 'Fraser Valley C',
		'CAABBOTSFORD' => 'Abbotsford',
		'CAMISSION' => 'Mission',
		'CAFRASER_VALLEY_F' => 'Fraser Valley F',
		'CAFRASER_VALLEY_G' => 'Fraser Valley G',
		'CACHAWATHIL_4' => 'Chawathil 4',
		'CAINKAHTSAPH_6' => 'Inkahtsaph 6',
		'CAKOPCHITCHIN_2' => 'Kopchitchin 2',
		'CAOHAMIL_1' => 'Ohamil 1',
		'CAPUCKATHOLETCHIN_11' => 'Puckatholetchin 11',
		'CASADDLE_ROCK_9' => 'Saddle Rock 9',
		'CALUKSEETSISSUM_9' => 'Lukseetsissum 9',
		'CASCHKAM_2' => 'Schkam 2',
		'CASKAWAHLOOK_1' => 'Skawahlook 1',
		'CASPEYUM_3' => 'Speyum 3',
		'CASPUZZUM_1' => 'Spuzzum 1',
		'CATUCKKWIOWHUM_1' => 'Tuckkwiowhum 1',
		'CAYALE_TOWN_1' => 'Yale Town 1',
		'CAKAHMOOSE_4' => 'Kahmoose 4',
		'CAKWAWKWAWAPILT_6' => 'Kwawkwawapilt 6',
		'CASKWAH_4' => 'Skwah 4',
		'CASKWALI_3' => 'Skwali 3',
		'CASKWAY_5' => 'Skway 5',
		'CASOOWAHLIE_14' => 'Soowahlie 14',
		'CATZEACHTEN_13' => 'Tzeachten 13',
		'CAYAKWEAKWIOOSE_12' => 'Yakweakwioose 12',
		'CASEABIRD_ISLAND' => 'Seabird Island',
		'CASCOWLITZ_1' => 'Scowlitz 1',
		'CATSEATAH_2' => 'Tseatah 2',
		'CAAITCHELITCH_9' => 'Aitchelitch 9',
		'CABOSTON_BAR_1A' => 'Boston Bar 1A',
		'CACHEAM_1' => 'Cheam 1',
		'CASCHELOWAT_1' => 'Schelowat 1',
		'CACHEHALIS_5' => 'Chehalis 5',
		'CASTULLAWHEETS_8' => 'Stullawheets 8',
		'CADOUGLAS_8' => 'Douglas 8',
		'CAPETERS_1' => 'Peters 1',
		'CAPOPKUM_1' => 'Popkum 1',
		'CASKOOKUMCHUCK_4' => 'Skookumchuck 4',
		'CABUCKTUM_4' => 'Bucktum 4',
		'CATIPELLA_7' => 'Tipella 7',
		'CASKWAHLA_2' => 'Skwahla 2',
		'CABOOTHROYD_13' => 'Boothroyd 13',
		'CAPAQULH' => 'Paqulh',
		'CAQALATK7EM' => 'Qalatk7em',
		'CAALBERT_FLAT_5' => 'Albert Flat 5',
		'CAUPPER_SUMAS_6' => 'Upper Sumas 6',
		'CAMATSQUI_MAIN_2' => 'Matsqui Main 2',
		'CAHOLACHTEN_8' => 'Holachten 8',
		'CALAKAHAHMEN_11' => 'Lakahahmen 11',
		'CASKWEAHM_10' => 'Skweahm 10',
		'CASQUAWKUM_CREEK_3' => 'Squawkum Creek 3',
		'CASACHTEEN' => 'Sachteen',
		'CASKOWKALE' => 'Skowkale',
		'CASQUIAALA' => 'Squiaala',
		'CALANGLEY' => 'Langley',
		'CALANGLEY' => 'Langley',
		'CASURREY' => 'Surrey',
		'CAWHITE_ROCK' => 'White Rock',
		'CADELTA' => 'Delta',
		'CARICHMOND' => 'Richmond',
		'CAGREATER_VANCOUVER_A' => 'Greater Vancouver A',
		'CAVANCOUVER' => 'Vancouver',
		'CABURNABY' => 'Burnaby',
		'CANEW_WESTMINSTER' => 'New Westminster',
		'CACOQUITLAM' => 'Coquitlam',
		'CABELCARRA' => 'Belcarra',
		'CAANMORE' => 'Anmore',
		'CAPORT_COQUITLAM' => 'Port Coquitlam',
		'CAPORT_MOODY' => 'Port Moody',
		'CANORTH_VANCOUVER' => 'North Vancouver',
		'CANORTH_VANCOUVER' => 'North Vancouver',
		'CAWEST_VANCOUVER' => 'West Vancouver',
		'CABOWEN_ISLAND' => 'Bowen Island',
		'CALIONS_BAY' => 'Lions Bay',
		'CAPITT_MEADOWS' => 'Pitt Meadows',
		'CAMAPLE_RIDGE' => 'Maple Ridge',
		'CASEMIAHMOO' => 'Semiahmoo',
		'CATSAWWASSEN' => 'Tsawwassen',
		'CAMUSQUEAM_2' => 'Musqueam 2',
		'CACOQUITLAM_2' => 'Coquitlam 2',
		'CACOQUITLAM_1' => 'Coquitlam 1',
		'CABURRARD_INLET_3' => 'Burrard Inlet 3',
		'CAMISSION_1' => 'Mission 1',
		'CACAPILANO_5' => 'Capilano 5',
		'CABARNSTON_ISLAND_3' => 'Barnston Island 3',
		'CAMUSQUEAM_4' => 'Musqueam 4',
		'CASEYMOUR_CREEK_2' => 'Seymour Creek 2',
		'CAKATZIE_2' => 'Katzie 2',
		'CAMCMILLAN_ISLAND_6' => 'McMillan Island 6',
		'CAMATSQUI_4' => 'Matsqui 4',
		'CAKATZIE_1' => 'Katzie 1',
		'CALANGLEY_5' => 'Langley 5',
		'CAWHONNOCK_1' => 'Whonnock 1',
		'CANORTH_SAANICH' => 'North Saanich',
		'CASIDNEY' => 'Sidney',
		'CACENTRAL_SAANICH' => 'Central Saanich',
		'CASAANICH' => 'Saanich',
		'CASALTSPRING_ISLAND' => 'Saltspring Island',
		'CASOUTHERN_GULF_ISLANDS' => 'Southern Gulf Islands',
		'CAOAK_BAY' => 'Oak Bay',
		'CAVICTORIA' => 'Victoria',
		'CAESQUIMALT' => 'Esquimalt',
		'CACOLWOOD' => 'Colwood',
		'CAMETCHOSIN' => 'Metchosin',
		'CALANGFORD' => 'Langford',
		'CAVIEW_ROYAL' => 'View Royal',
		'CAHIGHLANDS' => 'Highlands',
		'CASOOKE' => 'Sooke',
		'CAJUAN_DE_FUCA_(PART_1)' => 'Juan de Fuca (Part 1)',
		'CAJUAN_DE_FUCA_(PART_2)' => 'Juan de Fuca (Part 2)',
		'CACOLE_BAY_3' => 'Cole Bay 3',
		'CAUNION_BAY_4' => 'Union Bay 4',
		'CAEAST_SAANICH_2' => 'East Saanich 2',
		'CASOUTH_SAANICH_1' => 'South Saanich 1',
		'CAGALIANO_ISLAND_9' => 'Galiano Island 9',
		'CABECHER_BAY_1' => 'Becher Bay 1',
		'CAESQUIMALT' => 'Esquimalt',
		'CANEW_SONGHEES_1A' => 'New Songhees 1A',
		'CAGORDON_RIVER_2' => 'Gordon River 2',
		'CATSOU-KE' => 'TSou-ke',
		'CANORTH_COWICHAN' => 'North Cowichan',
		'CADUNCAN' => 'Duncan',
		'CACOWICHAN_VALLEY_D' => 'Cowichan Valley D',
		'CACOWICHAN_VALLEY_G' => 'Cowichan Valley G',
		'CALAKE_COWICHAN' => 'Lake Cowichan',
		'CACOWICHAN_VALLEY_H' => 'Cowichan Valley H',
		'CALADYSMITH' => 'Ladysmith',
		'CACOWICHAN_VALLEY_F' => 'Cowichan Valley F',
		'CACOWICHAN_VALLEY_I' => 'Cowichan Valley I',
		'CACOWICHAN_VALLEY_A' => 'Cowichan Valley A',
		'CACOWICHAN_VALLEY_B' => 'Cowichan Valley B',
		'CACOWICHAN_VALLEY_C' => 'Cowichan Valley C',
		'CACOWICHAN_VALLEY_E' => 'Cowichan Valley E',
		'CAHALALT_2' => 'Halalt 2',
		'CASQUAW-HAY-ONE_11' => 'Squaw-hay-one 11',
		'CATSUSSIE_6' => 'Tsussie 6',
		'CACHEMAINUS_13' => 'Chemainus 13',
		'CAKIL-PAH-LAS_3' => 'Kil-pah-las 3',
		'CAPENELAKUT_ISLAND_7' => 'Penelakut Island 7',
		'CASHINGLE_POINT_4' => 'Shingle Point 4',
		'CACOWICHAN_LAKE' => 'Cowichan Lake',
		'CAMALACHAN_11' => 'Malachan 11',
		'CAMALAHAT_11' => 'Malahat 11',
		'CAOYSTER_BAY_12' => 'Oyster Bay 12',
		'CAPORTIER_PASS_5' => 'Portier Pass 5',
		'CATHEIK_2' => 'Theik 2',
		'CAEST-PATROLAS_4' => 'Est-Patrolas 4',
		'CATZART-LAM_5' => 'Tzart-Lam 5',
		'CACOWICHAN' => 'Cowichan',
		'CANANAIMO' => 'Nanaimo',
		'CALANTZVILLE' => 'Lantzville',
		'CANANAIMO_A' => 'Nanaimo A',
		'CANANAIMO_B' => 'Nanaimo B',
		'CANANAIMO_C' => 'Nanaimo C',
		'CAPARKSVILLE' => 'Parksville',
		'CAQUALICUM_BEACH' => 'Qualicum Beach',
		'CANANAIMO_E' => 'Nanaimo E',
		'CANANAIMO_F' => 'Nanaimo F',
		'CANANAIMO_G' => 'Nanaimo G',
		'CANANAIMO_H' => 'Nanaimo H',
		'CANANAIMO_TOWN_1' => 'Nanaimo Town 1',
		'CANANOOSE' => 'Nanoose',
		'CAQUALICUM' => 'Qualicum',
		'CANANAIMO_RIVER' => 'Nanaimo River',
		'CAPORT_ALBERNI' => 'Port Alberni',
		'CAUCLUELET' => 'Ucluelet',
		'CATOFINO' => 'Tofino',
		'CAALBERNI-CLAYOQUOT_B' => 'Alberni-Clayoquot B',
		'CAALBERNI-CLAYOQUOT_D' => 'Alberni-Clayoquot D',
		'CAALBERNI-CLAYOQUOT_E' => 'Alberni-Clayoquot E',
		'CAALBERNI-CLAYOQUOT_F' => 'Alberni-Clayoquot F',
		'CAALBERNI-CLAYOQUOT_A' => 'Alberni-Clayoquot A',
		'CAALBERNI-CLAYOQUOT_C' => 'Alberni-Clayoquot C',
		'CAAHAHSWINIS_1' => 'Ahahswinis 1',
		'CAALBERNI_2' => 'Alberni 2',
		'CAANACLA_12' => 'Anacla 12',
		'CACLAKAMUCUS_2' => 'Clakamucus 2',
		'CAELHLATEESE_2' => 'Elhlateese 2',
		'CAHESQUIAT_1' => 'Hesquiat 1',
		'CAITTATSOO_1' => 'Ittatsoo 1',
		'CAMARKTOSIS_15' => 'Marktosis 15',
		'CANUMUKAMIS_1' => 'Numukamis 1',
		'CAMACOAH_1' => 'Macoah 1',
		'CAOPITSAT_1' => 'Opitsat 1',
		'CASACHSA_4' => 'Sachsa 4',
		'CATSAHAHEH_1' => 'Tsahaheh 1',
		'CAKLEHKOOT_2' => 'Klehkoot 2',
		'CAESOWISTA_3' => 'Esowista 3',
		'CAREFUGE_COVE_6' => 'Refuge Cove 6',
		'CATIN_WIS_11' => 'Tin Wis 11',
		'CAGOLD_RIVER' => 'Gold River',
		'CAZEBALLOS' => 'Zeballos',
		'CATAHSIS' => 'Tahsis',
		'CACAMPBELL_RIVER' => 'Campbell River',
		'CASAYWARD' => 'Sayward',
		'CASTRATHCONA_D_(OYSTER_BAY_-_BUTTLE_LA' => 'Strathcona D (Oyster Bay - Buttle Lake)',
		'CASTRATHCONA_A' => 'Strathcona A',
		'CASTRATHCONA_B' => 'Strathcona B',
		'CASTRATHCONA_C' => 'Strathcona C',
		'CAAHAMINAQUUS_12' => 'Ahaminaquus 12',
		'CACAMPBELL_RIVER_11' => 'Campbell River 11',
		'CACHENAHKINT_12' => 'Chenahkint 12',
		'CAHOUPSITAS_6' => 'Houpsitas 6',
		'CAQUINSAM_12' => 'Quinsam 12',
		'CAVILLAGE_ISLAND_1' => 'Village Island 1',
		'CAYUQUOT_1' => 'Yuquot 1',
		'CACAPE_MUDGE_10' => 'Cape Mudge 10',
		'CASQUIRREL_COVE_8' => 'Squirrel Cove 8',
		'CATORK_7' => 'Tork 7',
		'CAOCLUCJE_7' => 'Oclucje 7',
		'CATSA_XANA_18' => 'Tsa Xana 18',
		'CAEHATIS_11' => 'Ehatis 11',
		'CAHOMALCO_9' => 'Homalco 9',
		'CACOMOX' => 'Comox',
		'CACOURTENAY' => 'Courtenay',
		'CACUMBERLAND' => 'Cumberland',
		'CACOMOX_VALLEY_A' => 'Comox Valley A',
		'CACOMOX_VALLEY_B_(LAZO_NORTH)' => 'Comox Valley B (Lazo North)',
		'CACOMOX_VALLEY_C_(PUNTLEDGE_-_BLACK_CR' => 'Comox Valley C (Puntledge - Black Creek)',
		'CACOMOX_1' => 'Comox 1',
		'CAPENTLEDGE_2' => 'Pentledge 2',
		'CAPOWELL_RIVER' => 'Powell River',
		'CAPOWELL_RIVER_A' => 'Powell River A',
		'CAPOWELL_RIVER_B' => 'Powell River B',
		'CAPOWELL_RIVER_C' => 'Powell River C',
		'CAPOWELL_RIVER_D' => 'Powell River D',
		'CAPOWELL_RIVER_E' => 'Powell River E',
		'CASLIAMMON_1' => 'Sliammon 1',
		'CASECHELT_(PART)' => 'Sechelt (Part)',
		'CAGIBSONS' => 'Gibsons',
		'CASECHELT' => 'Sechelt',
		'CASUNSHINE_COAST_A' => 'Sunshine Coast A',
		'CASUNSHINE_COAST_B' => 'Sunshine Coast B',
		'CASUNSHINE_COAST_D' => 'Sunshine Coast D',
		'CASUNSHINE_COAST_E' => 'Sunshine Coast E',
		'CASUNSHINE_COAST_F' => 'Sunshine Coast F',
		'CACHEKWELP_26' => 'Chekwelp 26',
		'CASECHELT_(PART)' => 'Sechelt (Part)',
		'CASQUAMISH' => 'Squamish',
		'CAPEMBERTON' => 'Pemberton',
		'CASQUAMISH-LILLOOET_C' => 'Squamish-Lillooet C',
		'CAWHISTLER' => 'Whistler',
		'CASQUAMISH-LILLOOET_D' => 'Squamish-Lillooet D',
		'CALILLOOET' => 'Lillooet',
		'CASQUAMISH-LILLOOET_A' => 'Squamish-Lillooet A',
		'CASQUAMISH-LILLOOET_B' => 'Squamish-Lillooet B',
		'CACHEAKAMUS_11' => 'Cheakamus 11',
		'CAKOWTAIN_17' => 'Kowtain 17',
		'CASEAICHEM_16' => 'Seaichem 16',
		'CASTAWAMUS_24' => 'Stawamus 24',
		'CAWAIWAKUM_14' => 'Waiwakum 14',
		'CAYEKWAUPSUM_18' => 'Yekwaupsum 18',
		'CANESUCH_3' => 'Nesuch 3',
		'CABRIDGE_RIVER_1' => 'Bridge River 1',
		'CACAYOOSH_CREEK_1' => 'Cayoosh Creek 1',
		'CACHILHIL_6' => 'Chilhil 6',
		'CAFOUNTAIN__1' => 'Fountain  1',
		'CAFOUNTAIN__3' => 'Fountain  3',
		'CAFOUNTAIN_10' => 'Fountain 10',
		'CAFOUNTAIN_11' => 'Fountain 11',
		'CAFOUNTAIN_12' => 'Fountain 12',
		'CALILLOOET_1' => 'Lillooet 1',
		'CAFOUNTAIN_CREEK_8' => 'Fountain Creek 8',
		'CAMCCARTNEYS_FLAT_4' => 'McCartneys Flat 4',
		'CASETON_LAKE_5' => 'Seton Lake 5',
		'CANECAIT_6' => 'Necait 6',
		'CANESIKEP_6' => 'Nesikep 6',
		'CAPASHILQUA_2' => 'Pashilqua 2',
		'CAPAVILION_1' => 'Pavilion 1',
		'CASLOSH_1' => 'Slosh 1',
		'CATOWINOCK_2' => 'Towinock 2',
		'CAMISSION_5' => 'Mission 5',
		'CAFOUNTAIN_1B' => 'Fountain 1B',
		'CAMOUNT_CURRIE' => 'Mount Currie',
		'CANEQUATQUE' => 'Nequatque',
		'CAMERRITT' => 'Merritt',
		'CATHOMPSON-NICOLA_M_(BEAUTIFUL_NICOLA_' => 'Thompson-Nicola M (Beautiful Nicola Valley - North)',
		'CATHOMPSON-NICOLA_N_(BEAUTIFUL_NICOLA_' => 'Thompson-Nicola N (Beautiful Nicola Valley - South)',
		'CALYTTON' => 'Lytton',
		'CAASHCROFT' => 'Ashcroft',
		'CACACHE_CREEK' => 'Cache Creek',
		'CACLINTON' => 'Clinton',
		'CATHOMPSON-NICOLA_E_(BONAPARTE_PLATEAU' => 'Thompson-Nicola E (Bonaparte Plateau)',
		'CALOGAN_LAKE' => 'Logan Lake',
		'CATHOMPSON-NICOLA_I_(BLUE_SKY_COUNTRY)' => 'Thompson-Nicola I (Blue Sky Country)',
		'CATHOMPSON-NICOLA_J_(COPPER_DESERT_COU' => 'Thompson-Nicola J (Copper Desert Country)',
		'CAKAMLOOPS' => 'Kamloops',
		'CATHOMPSON-NICOLA_P_(RIVERS_AND_THE_PE' => 'Thompson-Nicola P (Rivers and the Peaks)',
		'CASUN_PEAKS_MOUNTAIN' => 'Sun Peaks Mountain',
		'CACHASE' => 'Chase',
		'CATHOMPSON-NICOLA_L_(GRASSLANDS)' => 'Thompson-Nicola L (Grasslands)',
		'CACLEARWATER' => 'Clearwater',
		'CATHOMPSON-NICOLA_A_(WELLS_GRAY_COUNTR' => 'Thompson-Nicola A (Wells Gray Country)',
		'CATHOMPSON-NICOLA_B_(THOMPSON_HEADWATE' => 'Thompson-Nicola B (Thompson Headwaters)',
		'CATHOMPSON-NICOLA_O_(LOWER_NORTH_THOMP' => 'Thompson-Nicola O (Lower North Thompson)',
		'CABARRIERE' => 'Barriere',
		'CACOLDWATER_1' => 'Coldwater 1',
		'CADOUGLAS_LAKE_3' => 'Douglas Lake 3',
		'CAHAMILTON_CREEK_2' => 'Hamilton Creek 2',
		'CAJOEYASKA_2' => 'Joeyaska 2',
		'CANICOLA_LAKE_1' => 'Nicola Lake 1',
		'CANICOLA_MAMEET_1' => 'Nicola Mameet 1',
		'CANOOAITCH_10' => 'Nooaitch 10',
		'CAPAULS_BASIN_2' => 'Pauls Basin 2',
		'CACHUCHHRAISCHIN' => 'Chuchhraischin',
		'CAZOHT_4' => 'Zoht 4',
		'CABONAPARTE_3' => 'Bonaparte 3',
		'CAHALHALAEDEN' => 'Halhalaeden',
		'CACANOE_CREEK_1' => 'Canoe Creek 1',
		'CASKEETCHESTN' => 'Skeetchestn',
		'CAHIGH_BAR_1' => 'High Bar 1',
		'CACANOE_CREEK_2' => 'Canoe Creek 2',
		'CAKITZOWIT_20' => 'Kitzowit 20',
		'CASKUPPAH_2A' => 'Skuppah 2A',
		'CAINKLYUHKINATKO_2' => 'Inklyuhkinatko 2',
		'CABASQUE_18' => 'Basque 18',
		'CAKLAHKAMICH_17' => 'Klahkamich 17',
		'CAKLEETLEKUT_22' => 'Kleetlekut 22',
		'CAKLICKKUMCHEEN_18' => 'Klickkumcheen 18',
		'CAINKLUCKCHEEN' => 'Inkluckcheen',
		'CAKUMCHEEN_1' => 'Kumcheen 1',
		'CALOWER_HAT_CREEK_2' => 'Lower Hat Creek 2',
		'CAPEQ-PAQ_22' => 'Peq-Paq 22',
		'CALYTTON_4A' => 'Lytton 4A',
		'CALYTTON_4E' => 'Lytton 4E',
		'CALYTTON_9A' => 'Lytton 9A',
		'CALYTTON_9B' => 'Lytton 9B',
		'CAASHCROFT_4' => 'Ashcroft 4',
		'CA105_MILE_POST_2' => '105 Mile Post 2',
		'CAOREGON_JACK_CREEK_5' => 'Oregon Jack Creek 5',
		'CANICKEL_PALM_4' => 'Nickel Palm 4',
		'CASISKA_FLAT' => 'Siska Flat',
		'CANICKEYEAH_25' => 'Nickeyeah 25',
		'CANICOMEN_1' => 'Nicomen 1',
		'CANOHOMEEN_23' => 'Nohomeen 23',
		'CANUUAUTIN_2' => 'Nuuautin 2',
		'CAPASKA_ISLAND_3' => 'Paska Island 3',
		'CAPAPYUM_27' => 'Papyum 27',
		'CAPEMYNOOS_9' => 'Pemynoos 9',
		'CASEAH_5' => 'Seah 5',
		'CASHACKAN_11' => 'Shackan 11',
		'CAKLOKLOWUCK_7' => 'Kloklowuck 7',
		'CASKUPPAH_4' => 'Skuppah 4',
		'CASKWAYAYNOPE_26' => 'Skwayaynope 26',
		'CASPINTLUM_FLAT_3' => 'Spintlum Flat 3',
		'CANKAIH_10' => 'Nkaih 10',
		'CAMARBLE_CANYON_3' => 'Marble Canyon 3',
		'CASTRYEN_9' => 'Stryen 9',
		'CATSAUKAN_12' => 'Tsaukan 12',
		'CAUPPER_HAT_CREEK_1' => 'Upper Hat Creek 1',
		'CAUPPER_NEPA_6' => 'Upper Nepa 6',
		'CAWHISPERING_PINES_4' => 'Whispering Pines 4',
		'CAYAWAUCHT_11' => 'Yawaucht 11',
		'CAZACHT_5' => 'Zacht 5',
		'CAKAMLOOPS_1' => 'Kamloops 1',
		'CASPENCES_BRIDGE' => 'Spences Bridge',
		'CAKANAKA_BAR' => 'Kanaka Bar',
		'CASAHHALTKUM_4' => 'Sahhaltkum 4',
		'CANEKALLISTON_2' => 'Nekalliston 2',
		'CANORTH_THOMPSON_1' => 'North Thompson 1',
		'CALOUIS_CREEK_4' => 'Louis Creek 4',
		'CASQUAAM_2' => 'Squaam 2',
		'CASHAWNIKEN_4B' => 'Shawniken 4B',
		'CANEKLIPTUM__1' => 'Nekliptum  1',
		'CABOOTHROYD_8A_(PART)' => 'Boothroyd 8A (Part)',
		'CANESKONLITH' => 'Neskonlith',
		'CAKELOWNA' => 'Kelowna',
		'CACENTRAL_OKANAGAN' => 'Central Okanagan',
		'CALAKE_COUNTRY' => 'Lake Country',
		'CAPEACHLAND' => 'Peachland',
		'CACENTRAL_OKANAGAN_J' => 'Central Okanagan J',
		'CAWEST_KELOWNA' => 'West Kelowna',
		'CADUCK_LAKE_7' => 'Duck Lake 7',
		'CATSINSTIKEPTUM__9' => 'Tsinstikeptum  9',
		'CATSINSTIKEPTUM_10' => 'Tsinstikeptum 10',
		'CALUMBY' => 'Lumby',
		'CACOLDSTREAM' => 'Coldstream',
		'CAVERNON' => 'Vernon',
		'CANORTH_OKANAGAN_B' => 'North Okanagan B',
		'CANORTH_OKANAGAN_C' => 'North Okanagan C',
		'CANORTH_OKANAGAN_D' => 'North Okanagan D',
		'CANORTH_OKANAGAN_E' => 'North Okanagan E',
		'CASPALLUMCHEEN' => 'Spallumcheen',
		'CAARMSTRONG' => 'Armstrong',
		'CAENDERBY' => 'Enderby',
		'CANORTH_OKANAGAN_F' => 'North Okanagan F',
		'CAOKANAGAN_(PART)_1' => 'Okanagan (Part) 1',
		'CAENDERBY_2' => 'Enderby 2',
		'CAPRIESTS_VALLEY_6' => 'Priests Valley 6',
		'CAHARRIS_3' => 'Harris 3',
		'CAGOLDEN' => 'Golden',
		'CACOLUMBIA-SHUSWAP_A' => 'Columbia-Shuswap A',
		'CAREVELSTOKE' => 'Revelstoke',
		'CACOLUMBIA-SHUSWAP_B' => 'Columbia-Shuswap B',
		'CASALMON_ARM' => 'Salmon Arm',
		'CACOLUMBIA-SHUSWAP_C' => 'Columbia-Shuswap C',
		'CACOLUMBIA-SHUSWAP_D' => 'Columbia-Shuswap D',
		'CACOLUMBIA-SHUSWAP_E' => 'Columbia-Shuswap E',
		'CACOLUMBIA-SHUSWAP_F' => 'Columbia-Shuswap F',
		'CASICAMOUS' => 'Sicamous',
		'CACHUM_CREEK_2' => 'Chum Creek 2',
		'CAHUSTALEN_1' => 'Hustalen 1',
		'CANORTH_BAY_5' => 'North Bay 5',
		'CAOKANAGAN_(PART)_1' => 'Okanagan (Part) 1',
		'CAQUAAOUT_1' => 'Quaaout 1',
		'CASALMON_RIVER_1' => 'Salmon River 1',
		'CASCOTCH_CREEK_4' => 'Scotch Creek 4',
		'CASWITSEMALPH_3' => 'Switsemalph 3',
		'CASWITSEMALPH' => 'Switsemalph',
		'CAONE_HUNDRED_MILE_HOUSE' => 'One Hundred Mile House',
		'CAWILLIAMS_LAKE' => 'Williams Lake',
		'CACARIBOO_D' => 'Cariboo D',
		'CACARIBOO_E' => 'Cariboo E',
		'CAQUESNEL' => 'Quesnel',
		'CACARIBOO_F' => 'Cariboo F',
		'CACARIBOO_G' => 'Cariboo G',
		'CACARIBOO_H' => 'Cariboo H',
		'CACARIBOO_L' => 'Cariboo L',
		'CACARIBOO_A' => 'Cariboo A',
		'CACARIBOO_B' => 'Cariboo B',
		'CAWELLS' => 'Wells',
		'CACARIBOO_C' => 'Cariboo C',
		'CACARIBOO_I' => 'Cariboo I',
		'CACARIBOO_J' => 'Cariboo J',
		'CACARIBOO_K' => 'Cariboo K',
		'CAALKALI_LAKE_1' => 'Alkali Lake 1',
		'CACANIM_LAKE_1' => 'Canim Lake 1',
		'CACANIM_LAKE_4' => 'Canim Lake 4',
		'CACANOE_CREEK_3' => 'Canoe Creek 3',
		'CADEEP_CREEK_2' => 'Deep Creek 2',
		'CADOG_CREEK_1' => 'Dog Creek 1',
		'CADOG_CREEK_2' => 'Dog Creek 2',
		'CALOHBIEE_3' => 'Lohbiee 3',
		'CAQUESNEL_1' => 'Quesnel 1',
		'CASODA_CREEK_1' => 'Soda Creek 1',
		'CAJOHNY_STICKS_2' => 'Johny Sticks 2',
		'CAWILLIAMS_LAKE_1' => 'Williams Lake 1',
		'CACANIM_LAKE_2' => 'Canim Lake 2',
		'CAALEXIS_CREEK_14' => 'Alexis Creek 14',
		'CAALEXIS_CREEK_16' => 'Alexis Creek 16',
		'CAANAHIMS_FLAT_1' => 'Anahims Flat 1',
		'CACHARLEY_BOYS_MEADOW_3' => 'Charley Boys Meadow 3',
		'CACHILCO_LAKE_1' => 'Chilco Lake 1',
		'CACHILCO_LAKE_1A' => 'Chilco Lake 1A',
		'CATANAKUT_4' => 'Tanakut 4',
		'CAKLUSKUS_1' => 'Kluskus 1',
		'CALOUIS_SQUINAS_RANCH_14' => 'Louis Squinas Ranch 14',
		'CACOGLISTIKO_RIVER_29' => 'Coglistiko River 29',
		'CANAZCO_20' => 'Nazco 20',
		'CAPUNTZI_LAKE_2' => 'Puntzi Lake 2',
		'CAREDSTONE_FLAT_1' => 'Redstone Flat 1',
		'CASQUINAS_2' => 'Squinas 2',
		'CASTONE_1' => 'Stone 1',
		'CAAGATS_MEADOW_8' => 'Agats Meadow 8',
		'CATHOMAS_SQUINAS_RANCH_2A' => 'Thomas Squinas Ranch 2A',
		'CAALEXIS_CREEK_21' => 'Alexis Creek 21',
		'CABAPTISTE_MEADOW_2' => 'Baptiste Meadow 2',
		'CATOOSEY_1' => 'Toosey 1',
		'CATOWDYSTAN_LAKE_3' => 'Towdystan Lake 3',
		'CATROUT_LAKE_ALEC_16' => 'Trout Lake Alec 16',
		'CAULKATCHO_13' => 'Ulkatcho 13',
		'CAWINDY_MOUTH_7' => 'Windy Mouth 7',
		'CAALEXIS_CREEK_34' => 'Alexis Creek 34',
		'CACAHOOSE_10' => 'Cahoose 10',
		'CABLACKWATER_MEADOW_11' => 'Blackwater Meadow 11',
		'CACAHOOSE_12' => 'Cahoose 12',
		'CABETTY_CREEK_18' => 'Betty Creek 18',
		'CASALMON_RIVER_MEADOW_7' => 'Salmon River Meadow 7',
		'CATZETZI_LAKE_11' => 'Tzetzi Lake 11',
		'CASUNDAYMANS_MEADOW_3' => 'Sundaymans Meadow 3',
		'CAEUCHINICO_CREEK_17' => 'Euchinico Creek 17',
		'CASANDY_HARRY_4' => 'Sandy Harry 4',
		'CAFISHTRAP_19' => 'Fishtrap 19',
		'CASWAN_LAKE__3' => 'Swan Lake  3',
		'CAALKALI_LAKE_4A' => 'Alkali Lake 4A',
		'CALEZBYE__6' => 'Lezbye  6',
		'CAMICHEL_GARDENS_36' => 'Michel Gardens 36',
		'CAULKATCHO_14A' => 'Ulkatcho 14A',
		'CABAEZAEKO_RIVER_27' => 'Baezaeko River 27',
		'CAALEXANDRIA' => 'Alexandria',
		'CAANAHIMS_MEADOW' => 'Anahims Meadow',
		'CAGARDEN' => 'Garden',
		'CALITTLE_SPRINGS' => 'Little Springs',
		'CAALERT_BAY' => 'Alert Bay',
		'CAPORT_MCNEILL' => 'Port McNeill',
		'CAPORT_ALICE' => 'Port Alice',
		'CAPORT_HARDY' => 'Port Hardy',
		'CAMOUNT_WADDINGTON_B' => 'Mount Waddington B',
		'CAMOUNT_WADDINGTON_C' => 'Mount Waddington C',
		'CAMOUNT_WADDINGTON_D' => 'Mount Waddington D',
		'CAMOUNT_WADDINGTON_A' => 'Mount Waddington A',
		'CAFORT_RUPERT_1' => 'Fort Rupert 1',
		'CATSULQUATE_4' => 'Tsulquate 4',
		'CADEAD_POINT_5' => 'Dead Point 5',
		'CAGWAYASDUMS_1' => 'Gwayasdums 1',
		'CAHOPETOWN_10A' => 'Hopetown 10A',
		'CAQUAEE_7' => 'Quaee 7',
		'CAKIPPASE_2' => 'Kippase 2',
		'CAQUATSINO_SUBDIVISION_18' => 'Quatsino Subdivision 18',
		'CATHOMAS_POINT_5' => 'Thomas Point 5',
		'CANIMPKISH_2' => 'Nimpkish 2',
		'CAHOPE_ISLAND_1' => 'Hope Island 1',
		'CAALERT_BAY' => 'Alert Bay',
		'CACENTRAL_COAST_A' => 'Central Coast A',
		'CACENTRAL_COAST_C' => 'Central Coast C',
		'CACENTRAL_COAST_D' => 'Central Coast D',
		'CACENTRAL_COAST_E' => 'Central Coast E',
		'CABELLA_BELLA_1' => 'Bella Bella 1',
		'CABELLA_COOLA_1' => 'Bella Coola 1',
		'CAKATIT_1' => 'Katit 1',
		'CAPORT_EDWARD' => 'Port Edward',
		'CAPRINCE_RUPERT' => 'Prince Rupert',
		'CASKEENA-QUEEN_CHARLOTTE_A' => 'Skeena-Queen Charlotte A',
		'CASKEENA-QUEEN_CHARLOTTE_C' => 'Skeena-Queen Charlotte C',
		'CAMASSET' => 'Masset',
		'CAQUEEN_CHARLOTTE' => 'Queen Charlotte',
		'CASKEENA-QUEEN_CHARLOTTE_D' => 'Skeena-Queen Charlotte D',
		'CAPORT_CLEMENTS' => 'Port Clements',
		'CASKEENA-QUEEN_CHARLOTTE_E' => 'Skeena-Queen Charlotte E',
		'CAMASSET_1' => 'Masset 1',
		'CASKIDEGATE_1' => 'Skidegate 1',
		'CAKULKAYU_(HARTLEY_BAY)_4' => 'Kulkayu (Hartley Bay) 4',
		'CADOLPHIN_ISLAND_1' => 'Dolphin Island 1',
		'CALAX_KWALAAMS_1' => 'Lax Kwalaams 1',
		'CAS1/2_TSIMPSEAN_2' => 'S1/2 Tsimpsean 2',
		'CAKITIMAT' => 'Kitimat',
		'CATERRACE' => 'Terrace',
		'CAKITIMAT-STIKINE_C_(PART_1)' => 'Kitimat-Stikine C (Part 1)',
		'CAKITIMAT-STIKINE_E' => 'Kitimat-Stikine E',
		'CAKITIMAT-STIKINE_C_(PART_2)' => 'Kitimat-Stikine C (Part 2)',
		'CAHAZELTON' => 'Hazelton',
		'CANEW_HAZELTON' => 'New Hazelton',
		'CAKITIMAT-STIKINE_B' => 'Kitimat-Stikine B',
		'CASTEWART' => 'Stewart',
		'CANISGAA' => 'Nisgaa',
		'CAKITIMAT-STIKINE_F' => 'Kitimat-Stikine F',
		'CAKITIMAT-STIKINE_A' => 'Kitimat-Stikine A',
		'CAKITIMAT-STIKINE_D' => 'Kitimat-Stikine D',
		'CAKITASOO_1' => 'Kitasoo 1',
		'CAKITAMAAT_2' => 'Kitamaat 2',
		'CAKITSUMKAYLUM_1' => 'Kitsumkaylum 1',
		'CAKSHISH_4' => 'Kshish 4',
		'CAKULSPAI_6' => 'Kulspai 6',
		'CACORYATSAQUA_(MORICETOWN)_2' => 'Coryatsaqua (Moricetown) 2',
		'CAHAGWILGET_1' => 'Hagwilget 1',
		'CAGITANMAAX_1' => 'Gitanmaax 1',
		'CAKISPIOX_1' => 'Kispiox 1',
		'CAGITSEGUKLA_1' => 'Gitsegukla 1',
		'CAGITANYOW_1' => 'Gitanyow 1',
		'CAGITWANGAK_1' => 'Gitwangak 1',
		'CAMORICETOWN_1' => 'Moricetown 1',
		'CASIK-E-DAKH_2' => 'Sik-e-dakh 2',
		'CABABINE_17' => 'Babine 17',
		'CABULKLEY_RIVER_19' => 'Bulkley River 19',
		'CAISKUT_6' => 'Iskut 6',
		'CAGUHTHE_TAH_12' => 'Guhthe Tah 12',
		'CAKITSELAS_1' => 'Kitselas 1',
		'CADEASE_LAKE_9' => 'Dease Lake 9',
		'CATAHLTAN_1' => 'Tahltan 1',
		'CATELEGRAPH_CREEK' => 'Telegraph Creek',
		'CAVANDERHOOF' => 'Vanderhoof',
		'CAFRASER_LAKE' => 'Fraser Lake',
		'CAFORT_ST._JAMES' => 'Fort St. James',
		'CABULKLEY-NECHAKO_C' => 'Bulkley-Nechako C',
		'CABULKLEY-NECHAKO_D' => 'Bulkley-Nechako D',
		'CABULKLEY-NECHAKO_F' => 'Bulkley-Nechako F',
		'CABURNS_LAKE' => 'Burns Lake',
		'CABULKLEY-NECHAKO_B' => 'Bulkley-Nechako B',
		'CABULKLEY-NECHAKO_E' => 'Bulkley-Nechako E',
		'CAGRANISLE' => 'Granisle',
		'CAHOUSTON' => 'Houston',
		'CATELKWA' => 'Telkwa',
		'CASMITHERS' => 'Smithers',
		'CABULKLEY-NECHAKO_A' => 'Bulkley-Nechako A',
		'CABULKLEY-NECHAKO_G' => 'Bulkley-Nechako G',
		'CAYE_KOO_CHE_3' => 'Ye Koo Che 3',
		'CANAUTLEY_(FORT_FRASER)_1' => 'Nautley (Fort Fraser) 1',
		'CANAKAZDLI_(NECOSLIE_1)' => 'Nakazdli (Necoslie 1)',
		'CASOWCHEA_3' => 'Sowchea 3',
		'CABINCHE_2_(PINCHIE_2)' => 'Binche 2 (Pinchie 2)',
		'CASEASPUNKUT_4' => 'Seaspunkut 4',
		'CASTELLAQUO_(STELLA)_1' => 'Stellaquo (Stella) 1',
		'CASTONY_CREEK_1' => 'Stony Creek 1',
		'CATACHE_1' => 'Tache 1',
		'CATACLA_LAKE_(FERRY_LANDING)_9' => 'Tacla Lake (Ferry Landing) 9',
		'CALAKETOWN_3' => 'Laketown 3',
		'CADZITLINE_LEE_9' => 'Dzitline Lee 9',
		'CABURNS_LAKE_18' => 'Burns Lake 18',
		'CACHESLATTA_1' => 'Cheslatta 1',
		'CAOMINECA_1' => 'Omineca 1',
		'CAPALLING_1' => 'Palling 1',
		'CADUNCAN_LAKE_2' => 'Duncan Lake 2',
		'CAFRANCOIS_LAKE_7' => 'Francois Lake 7',
		'CASKINS_LAKE_16A' => 'Skins Lake 16A',
		'CASKINS_LAKE_16B' => 'Skins Lake 16B',
		'CATATLA_WEST_11' => 'Tatla West 11',
		'CAUNCHA_LAKE_13A' => 'Uncha Lake 13A',
		'CAWOYENNE_27' => 'Woyenne 27',
		'CABABINE__6' => 'Babine  6',
		'CABABINE_25' => 'Babine 25',
		'CAJEAN_BAPTISTE_28' => 'Jean Baptiste 28',
		'CATATLAT_EAST_2' => 'Tatlat East 2',
		'CAWILLIAMS_PRAIRIE_MEADOW_1A' => 'Williams Prairie Meadow 1A',
		'CAPOISON_CREEK_17A' => 'Poison Creek 17A',
		'CATADINLAY_15' => 'Tadinlay 15',
		'CANEDOATS_11' => 'Nedoats 11',
		'CABABINE_LAKE_21B' => 'Babine Lake 21B',
		'CANORTH_TACLA_LAKE' => 'North Tacla Lake',
		'CAMISSION_LANDS_17' => 'Mission Lands 17',
		'CAVALEMOUNT' => 'Valemount',
		'CAMCBRIDE' => 'McBride',
		'CAFRASER-FORT_GEORGE_H' => 'Fraser-Fort George H',
		'CAPRINCE_GEORGE' => 'Prince George',
		'CAMACKENZIE' => 'Mackenzie',
		'CAFRASER-FORT_GEORGE_A' => 'Fraser-Fort George A',
		'CAFRASER-FORT_GEORGE_C' => 'Fraser-Fort George C',
		'CAFRASER-FORT_GEORGE_D' => 'Fraser-Fort George D',
		'CAFRASER-FORT_GEORGE_E' => 'Fraser-Fort George E',
		'CAFRASER-FORT_GEORGE_F' => 'Fraser-Fort George F',
		'CAFRASER-FORT_GEORGE_G' => 'Fraser-Fort George G',
		'CAFORT_GEORGE_(SHELLEY)_2' => 'Fort George (Shelley) 2',
		'CAMCLEOD_LAKE_1' => 'McLeod Lake 1',
		'CATUMBLER_RIDGE' => 'Tumbler Ridge',
		'CAPOUCE_COUPE' => 'Pouce Coupe',
		'CACHETWYND' => 'Chetwynd',
		'CADAWSON_CREEK' => 'Dawson Creek',
		'CAPEACE_RIVER_D' => 'Peace River D',
		'CAPEACE_RIVER_E' => 'Peace River E',
		'CAHUDSONS_HOPE' => 'Hudsons Hope',
		'CATAYLOR' => 'Taylor',
		'CAFORT_ST._JOHN' => 'Fort St. John',
		'CAPEACE_RIVER_B' => 'Peace River B',
		'CAPEACE_RIVER_C' => 'Peace River C',
		'CAEAST_MOBERLY_LAKE_169' => 'East Moberly Lake 169',
		'CAWEST_MOBERLY_LAKE_168A' => 'West Moberly Lake 168A',
		'CABLUEBERRY_RIVER_205' => 'Blueberry River 205',
		'CADOIG_RIVER_206' => 'Doig River 206',
		'CAFORT_WARE_1' => 'Fort Ware 1',
		'CAHALFWAY_RIVER_168' => 'Halfway River 168',
		'CAINGENIKA_POINT' => 'Ingenika Point',
		'CASTIKINE_REGION' => 'Stikine Region',
		'CAUNNAMED_10' => 'Unnamed 10',
		'CAFIVE_MILE_POINT__3' => 'Five Mile Point  3',
		'CAGOOD_HOPE_LAKE' => 'Good Hope Lake',
		'CALOWER_POST' => 'Lower Post',
		'CALIARD_RIVER_3' => 'Liard River 3',
		'CANORTHERN_ROCKIES' => 'Northern Rockies',
		'CAFONTAS_1' => 'Fontas 1',
		'CAFORT_NELSON_2' => 'Fort Nelson 2',
		'CAKAHNTAH_3' => 'Kahntah 3',
		'CAPROPHET_RIVER_4' => 'Prophet River 4',
	],
	'YT' => [
		'CAWATSON_LAKE' => 'Watson Lake',
		'CAFARO' => 'Faro',
		'CATESLIN' => 'Teslin',
		'CATESLIN_POST_13' => 'Teslin Post 13',
		'CACARCROSS_4' => 'Carcross 4',
		'CAWHITEHORSE' => 'Whitehorse',
		'CALAKE_LABERGE_1' => 'Lake Laberge 1',
		'CACARMACKS' => 'Carmacks',
		'CAKLUKSHU' => 'Klukshu',
		'CAHAINES_JUNCTION' => 'Haines Junction',
		'CAKLOO_LAKE' => 'Kloo Lake',
		'CAMAYO' => 'Mayo',
		'CADAWSON' => 'Dawson',
		'CAMOOSEHIDE_CREEK_2' => 'Moosehide Creek 2',
		'CAUPPER_LIARD' => 'Upper Liard',
		'CATWO_MILE_AND_TWO_AND_ONE-HALF_MILE_V' => 'Two Mile and Two and One-Half Mile Village',
		'CATAGISH' => 'Tagish',
		'CAROSS_RIVER' => 'Ross River',
		'CACHAMPAGNE_LANDING_10' => 'Champagne Landing 10',
		'CABURWASH_LANDING' => 'Burwash Landing',
		'CAPELLY_CROSSING' => 'Pelly Crossing',
		'CABEAVER_CREEK' => 'Beaver Creek',
		'CAOLD_CROW' => 'Old Crow',
		'CAMT._LORNE' => 'Mt. Lorne',
		'CAYUKON,_UNORGANIZED' => 'Yukon, Unorganized',
		'CASWIFT_RIVER' => 'Swift River',
		'CAJOHNSONS_CROSSING' => 'Johnsons Crossing',
		'CACARCROSS' => 'Carcross',
		'CADESTRUCTION_BAY' => 'Destruction Bay',
		'CASTEWART_CROSSING' => 'Stewart Crossing',
		'CAKENO_HILL' => 'Keno Hill',
		'CAIBEX_VALLEY' => 'Ibex Valley',
		'CATESLIN' => 'Teslin',
		'CAMARSH_LAKE' => 'Marsh Lake',
		'CAMACPHERSON-GRIZZLY_VALLEY' => 'Macpherson-Grizzly Valley',
		'CAWHITEHORSE,_UNORGANIZED' => 'Whitehorse, Unorganized',
	],
	'NT' => [
		'CATSIIGEHTCHIC' => 'Tsiigehtchic',
		'CAPAULATUK' => 'Paulatuk',
		'CAFORT_MCPHERSON' => 'Fort McPherson',
		'CAINUVIK' => 'Inuvik',
		'CAAKLAVIK' => 'Aklavik',
		'CATUKTOYAKTUK' => 'Tuktoyaktuk',
		'CASACHS_HARBOUR' => 'Sachs Harbour',
		'CAREGION_1,_UNORGANIZED' => 'Region 1, Unorganized',
		'CAULUKHAKTOK' => 'Ulukhaktok',
		'CADLINE' => 'Dline',
		'CATULITA' => 'Tulita',
		'CANORMAN_WELLS' => 'Norman Wells',
		'CAFORT_GOOD_HOPE' => 'Fort Good Hope',
		'CACOLVILLE_LAKE' => 'Colville Lake',
		'CAREGION_2,_UNORGANIZED' => 'Region 2, Unorganized',
		'CABEHCHOK' => 'Behchok',
		'CAWHAT' => 'What',
		'CAGAMT' => 'Gamt',
		'CAWEKWET' => 'Wekwet',
		'CAREGION_3,_UNORGANIZED' => 'Region 3, Unorganized',
		'CAKAKISA' => 'Kakisa',
		'CASAMBAA_KE' => 'Sambaa Ke',
		'CAFORT_LIARD' => 'Fort Liard',
		'CANAHANNI_BUTTE' => 'Nahanni Butte',
		'CAJEAN_MARIE_RIVER' => 'Jean Marie River',
		'CAFORT_PROVIDENCE' => 'Fort Providence',
		'CAHAY_RIVER_DENE_1' => 'Hay River Dene 1',
		'CAFORT_SIMPSON' => 'Fort Simpson',
		'CAWRIGLEY' => 'Wrigley',
		'CAREGION_4,_UNORGANIZED' => 'Region 4, Unorganized',
		'CAFORT_SMITH' => 'Fort Smith',
		'CAENTERPRISE' => 'Enterprise',
		'CASALT_PLAINS_195' => 'Salt Plains 195',
		'CAHAY_RIVER' => 'Hay River',
		'CAFORT_RESOLUTION' => 'Fort Resolution',
		'CALUTSELKE' => 'Lutselke',
		'CARELIANCE' => 'Reliance',
		'CAREGION_5,_UNORGANIZED' => 'Region 5, Unorganized',
		'CADETAH' => 'Detah',
		'CAYELLOWKNIFE' => 'Yellowknife',
		'CAREGION_6,_UNORGANIZED' => 'Region 6, Unorganized',
	],
	'NU' => [
		'CASANIKILUAQ' => 'Sanikiluaq',
		'CAIQALUIT' => 'Iqaluit',
		'CAKIMMIRUT' => 'Kimmirut',
		'CACAPE_DORSET' => 'Cape Dorset',
		'CAPANGNIRTUNG' => 'Pangnirtung',
		'CAQIKIQTARJUAQ' => 'Qikiqtarjuaq',
		'CAHALL_BEACH' => 'Hall Beach',
		'CAIGLOOLIK' => 'Igloolik',
		'CACLYDE_RIVER' => 'Clyde River',
		'CAARCTIC_BAY' => 'Arctic Bay',
		'CANANISIVIK' => 'Nanisivik',
		'CAPOND_INLET' => 'Pond Inlet',
		'CARESOLUTE' => 'Resolute',
		'CAGRISE_FIORD' => 'Grise Fiord',
		'CABAFFIN,_UNORGANIZED' => 'Baffin, Unorganized',
		'CACORAL_HARBOUR' => 'Coral Harbour',
		'CAARVIAT' => 'Arviat',
		'CAWHALE_COVE' => 'Whale Cove',
		'CARANKIN_INLET' => 'Rankin Inlet',
		'CACHESTERFIELD_INLET' => 'Chesterfield Inlet',
		'CABAKER_LAKE' => 'Baker Lake',
		'CANAUJAAT' => 'Naujaat',
		'CAKEEWATIN,_UNORGANIZED' => 'Keewatin, Unorganized',
		'CAKUGAARUK' => 'Kugaaruk',
		'CAKUGLUKTUK' => 'Kugluktuk',
		'CABATHURST_INLET' => 'Bathurst Inlet',
		'CAUMINGMAKTOK' => 'Umingmaktok',
		'CACAMBRIDGE_BAY' => 'Cambridge Bay',
		'CAGJOA_HAVEN' => 'Gjoa Haven',
		'CATALOYOAK' => 'Taloyoak',
		'CAKITIKMEOT,_UNORGANIZED' => 'Kitikmeot, Unorganized',
	],
];
