<?php

/**
 * List of cities for: Brazil
 * Source: https://www.ibge.gov.br/en/statistics/social/population/18391-2010-population-census.html?edicao=21738&t=resultados
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['BR'];

$country_cities = [
	'AC' => [
		'BR1200435' => 'Santa Rosa do Purus',
		'BR1200054' => 'Assis Brasil',
		'BR1200138' => 'Bujari',
		'BR1200179' => 'Capixaba',
		'BR1200328' => 'Jordão',
		'BR1200344' => 'Manoel Urbano',
		'BR1200393' => 'Porto Walter',
		'BR1200013' => 'Acrelândia',
		'BR1200252' => 'Epitaciolândia',
		'BR1200336' => 'Mâncio Lima',
		'BR1200351' => 'Marechal Thaumaturgo',
		'BR1200385' => 'Plácido de Castro',
		'BR1200807' => 'Porto Acre',
		'BR1200427' => 'Rodrigues Alves',
		'BR1200708' => 'Xapuri',
		'BR1200104' => 'Brasiléia',
		'BR1200302' => 'Feijó',
		'BR1200500' => 'Sena Madureira',
		'BR1200450' => 'Senador Guiomard',
		'BR1200609' => 'Tarauacá',
		'BR1200203' => 'Cruzeiro do Sul',
		'BR1200401' => 'Rio Branco',
	],
	'AL' => [
		'BR2700805' => 'Belém',
		'BR2702702' => 'Feliz Deserto',
		'BR2703908' => 'Jundiá',
		'BR2704906' => 'Mar Vermelho',
		'BR2705903' => 'Olho dÁgua Grande',
		'BR2707008' => 'Pindoba',
		'BR2700607' => 'Barra de São Miguel',
		'BR2700904' => 'Belo Monte',
		'BR2701357' => 'Campestre',
		'BR2701506' => 'Campo Grande',
		'BR2701803' => 'Carneiros',
		'BR2701902' => 'Chã Preta',
		'BR2702207' => 'Coqueiro Seco',
		'BR2703403' => 'Jacaré dos Homens',
		'BR2703502' => 'Jacuípe',
		'BR2703601' => 'Japaratinga',
		'BR2703700' => 'Jaramataia',
		'BR2705309' => 'Minador do Negrão',
		'BR2705408' => 'Monteirópolis',
		'BR2705804' => 'Olho dÁgua do Casado',
		'BR2706208' => 'Palestina',
		'BR2706604' => 'Paulo Jacinto',
		'BR2707404' => 'Porto de Pedras',
		'BR2707800' => 'Roteiro',
		'BR2707909' => 'Santa Luzia do Norte',
		'BR2708204' => 'São Brás',
		'BR2708709' => 'São Miguel dos Milagres',
		'BR2709004' => 'Tanque dArca',
		'BR2700102' => 'Água Branca',
		'BR2700201' => 'Anadia',
		'BR2700508' => 'Barra de Santo Antônio',
		'BR2700706' => 'Batalha',
		'BR2701100' => 'Branquinha',
		'BR2701209' => 'Cacimbinhas',
		'BR2701605' => 'Canapi',
		'BR2701704' => 'Capela',
		'BR2702009' => 'Coité do Nóia',
		'BR2702504' => 'Dois Riachos',
		'BR2702553' => 'Estrela de Alagoas',
		'BR2702801' => 'Flexeiras',
		'BR2703007' => 'Ibateguara',
		'BR2703304' => 'Inhapi',
		'BR2703759' => 'Jequiá da Praia',
		'BR2704104' => 'Lagoa da Canoa',
		'BR2704401' => 'Major Isidoro',
		'BR2704609' => 'Maravilha',
		'BR2704807' => 'Maribondo',
		'BR2705200' => 'Messias',
		'BR2705606' => 'Novo Lino',
		'BR2706000' => 'Olivença',
		'BR2706109' => 'Ouro Branco',
		'BR2706422' => 'Pariconha',
		'BR2706448' => 'Paripueira',
		'BR2706505' => 'Passo de Camaragibe',
		'BR2706802' => 'Piaçabuçu',
		'BR2707206' => 'Poço das Trincheiras',
		'BR2707503' => 'Porto Real do Colégio',
		'BR2707602' => 'Quebrangulo',
		'BR2708105' => 'Santana do Mundaú',
		'BR2708907' => 'Satuba',
		'BR2708956' => 'Senador Rui Palmeira',
		'BR2709103' => 'Taquarana',
		'BR2700409' => 'Atalaia',
		'BR2701001' => 'Boca da Mata',
		'BR2701308' => 'Cajueiro',
		'BR2702108' => 'Colônia Leopoldina',
		'BR2702355' => 'Craíbas',
		'BR2702405' => 'Delmiro Gouveia',
		'BR2702603' => 'Feira Grande',
		'BR2702900' => 'Girau do Ponciano',
		'BR2703106' => 'Igaci',
		'BR2703205' => 'Igreja Nova',
		'BR2703809' => 'Joaquim Gomes',
		'BR2704005' => 'Junqueiro',
		'BR2704203' => 'Limoeiro de Anadia',
		'BR2704500' => 'Maragogi',
		'BR2704708' => 'Marechal Deodoro',
		'BR2705002' => 'Mata Grande',
		'BR2705101' => 'Matriz de Camaragibe',
		'BR2705507' => 'Murici',
		'BR2705705' => 'Olho dÁgua das Flores',
		'BR2706406' => 'Pão de Açúcar',
		'BR2706901' => 'Pilar',
		'BR2707107' => 'Piranhas',
		'BR2707305' => 'Porto Calvo',
		'BR2708006' => 'Santana do Ipanema',
		'BR2708303' => 'São José da Laje',
		'BR2708402' => 'São José da Tapera',
		'BR2708501' => 'São Luís do Quitunde',
		'BR2708808' => 'São Sebastião',
		'BR2709152' => 'Teotônio Vilela',
		'BR2709202' => 'Traipu',
		'BR2709400' => 'Viçosa',
		'BR2701407' => 'Campo Alegre',
		'BR2702306' => 'Coruripe',
		'BR2706307' => 'Palmeira dos Índios',
		'BR2706703' => 'Penedo',
		'BR2707701' => 'Rio Largo',
		'BR2708600' => 'São Miguel dos Campos',
		'BR2709301' => 'União dos Palmares',
		'BR2700300' => 'Arapiraca',
		'BR2704302' => 'Maceió',
	],
	'AM' => [
		'BR1300060' => 'Amaturá',
		'BR1301951' => 'Itamarati',
		'BR1302009' => 'Itapiranga',
		'BR1302108' => 'Japurá',
		'BR1304005' => 'Silves',
		'BR1300029' => 'Alvarães',
		'BR1300086' => 'Anamã',
		'BR1300102' => 'Anori',
		'BR1300144' => 'Apuí',
		'BR1300201' => 'Atalaia do Norte',
		'BR1300631' => 'Beruri',
		'BR1300680' => 'Boa Vista do Ramos',
		'BR1300839' => 'Caapiranga',
		'BR1300904' => 'Canutama',
		'BR1301506' => 'Envira',
		'BR1301654' => 'Guajará',
		'BR1302207' => 'Juruá',
		'BR1302306' => 'Jutaí',
		'BR1302801' => 'Maraã',
		'BR1303007' => 'Nhamundá',
		'BR1303205' => 'Novo Airão',
		'BR1303502' => 'Pauini',
		'BR1303601' => 'Santa Isabel do Rio Negro',
		'BR1303957' => 'São Sebastião do Uatumã',
		'BR1304104' => 'Tapauá',
		'BR1304237' => 'Tonantins',
		'BR1304260' => 'Uarini',
		'BR1304302' => 'Urucará',
		'BR1304401' => 'Urucurituba',
		'BR1300300' => 'Autazes',
		'BR1300409' => 'Barcelos',
		'BR1300508' => 'Barreirinha',
		'BR1300607' => 'Benjamin Constant',
		'BR1300706' => 'Boca do Acre',
		'BR1300805' => 'Borba',
		'BR1301001' => 'Carauari',
		'BR1301100' => 'Careiro',
		'BR1301159' => 'Careiro da Várzea',
		'BR1301308' => 'Codajás',
		'BR1301407' => 'Eirunepé',
		'BR1301605' => 'Fonte Boa',
		'BR1301704' => 'Humaitá',
		'BR1301803' => 'Ipixuna',
		'BR1301852' => 'Iranduba',
		'BR1302405' => 'Lábrea',
		'BR1302553' => 'Manaquiri',
		'BR1302702' => 'Manicoré',
		'BR1303106' => 'Nova Olinda do Norte',
		'BR1303304' => 'Novo Aripuanã',
		'BR1303536' => 'Presidente Figueiredo',
		'BR1303569' => 'Rio Preto da Eva',
		'BR1303700' => 'Santo Antônio do Içá',
		'BR1303809' => 'São Gabriel da Cachoeira',
		'BR1303908' => 'São Paulo de Olivença',
		'BR1301209' => 'Coari',
		'BR1301902' => 'Itacoatiara',
		'BR1302504' => 'Manacapuru',
		'BR1302900' => 'Maués',
		'BR1304062' => 'Tabatinga',
		'BR1304203' => 'Tefé',
		'BR1303403' => 'Parintins',
		'BR1302603' => 'Manaus',
	],
	'AP' => [
		'BR1600212' => 'Cutias',
		'BR1600253' => 'Itaubal',
		'BR1600550' => 'Pracuúba',
		'BR1600055' => 'Serra do Navio',
		'BR1600105' => 'Amapá',
		'BR1600204' => 'Calçoene',
		'BR1600238' => 'Ferreira Gomes',
		'BR1600402' => 'Mazagão',
		'BR1600154' => 'Pedra Branca do Amapari',
		'BR1600535' => 'Porto Grande',
		'BR1600709' => 'Tartarugalzinho',
		'BR1600808' => 'Vitória do Jari',
		'BR1600279' => 'Laranjal do Jari',
		'BR1600501' => 'Oiapoque',
		'BR1600303' => 'Macapá',
		'BR1600600' => 'Santana',
	],
	'BA' => [
		'BR2900603' => 'Aiquara',
		'BR2907400' => 'Catolândia',
		'BR2908804' => 'Contendas do Sincorá',
		'BR2910206' => 'Dom Macedo Costa',
		'BR2911253' => 'Gavião',
		'BR2912608' => 'Ibiquera',
		'BR2918704' => 'Lafaiete Coutinho',
		'BR2918902' => 'Lajedão',
		'BR2919009' => 'Lajedinho',
		'BR2900108' => 'Abaíra',
		'BR2900900' => 'Almadina',
		'BR2901957' => 'Apuarema',
		'BR2902302' => 'Aratuípe',
		'BR2903102' => 'Barra do Rocha',
		'BR2903300' => 'Barro Preto',
		'BR2906105' => 'Canápolis',
		'BR2906402' => 'Candeal',
		'BR2907004' => 'Cardeal da Silva',
		'BR2907558' => 'Caturama',
		'BR2909000' => 'Cordeiros',
		'BR2909505' => 'Cravolândia',
		'BR2910305' => 'Elísio Medrado',
		'BR2910776' => 'Feira da Mata',
		'BR2910909' => 'Firmino Alves',
		'BR2911501' => 'Gongogi',
		'BR2912806' => 'Ibirapuã',
		'BR2913309' => 'Ichu',
		'BR2914109' => 'Ipupiara',
		'BR2914208' => 'Irajuba',
		'BR2915304' => 'Itagimirim',
		'BR2915403' => 'Itaju do Colônia',
		'BR2915700' => 'Itamari',
		'BR2915908' => 'Itanagra',
		'BR2916708' => 'Itaquara',
		'BR2917359' => 'Jaborandi',
		'BR2918555' => 'Jussari',
		'BR2918605' => 'Jussiape',
		'BR2919058' => 'Lajedo do Tabocal',
		'BR2919108' => 'Lamarão',
		'BR2919900' => 'Macururé',
		'BR2919959' => 'Maetinga',
		'BR2920007' => 'Maiquinique',
		'BR2920304' => 'Malhada de Pedras',
		'BR2921609' => 'Morpará',
		'BR2922201' => 'Muniz Ferreira',
		'BR2922730' => 'Nova Fátima',
		'BR2922755' => 'Nova Ibiá',
		'BR2922805' => 'Nova Itarana',
		'BR2922854' => 'Nova Redenção',
		'BR2923308' => 'Ouriçangas',
		'BR2923506' => 'Palmeiras',
		'BR2924108' => 'Pedrão',
		'BR2924678' => 'Piraí do Norte',
		'BR2924900' => 'Planaltino',
		'BR2925402' => 'Potiraguá',
		'BR2925931' => 'Quixabeira',
		'BR2926657' => 'Ribeirão do Largo',
		'BR2927101' => 'Rodelas',
		'BR2927804' => 'Santa Cruz da Vitória',
		'BR2928505' => 'Santa Teresinha',
		'BR2928307' => 'Santanópolis',
		'BR2928950' => 'São Domingos',
		'BR2929354' => 'São José da Vitória',
		'BR2931103' => 'Tanquinho',
		'BR2931400' => 'Teodoro Sampaio',
		'BR2933109' => 'Várzea do Poço',
		'BR2933174' => 'Varzedo',
		'BR2933257' => 'Vereda',
		'BR2933406' => 'Wagner',
		'BR2900207' => 'Abaré',
		'BR2900306' => 'Acajutiba',
		'BR2900355' => 'Adustina',
		'BR2900405' => 'Água Fria',
		'BR2901155' => 'América Dourada',
		'BR2901304' => 'Andaraí',
		'BR2901353' => 'Andorinha',
		'BR2901403' => 'Angical',
		'BR2901502' => 'Anguera',
		'BR2901601' => 'Antas',
		'BR2901700' => 'Antônio Cardoso',
		'BR2901809' => 'Antônio Gonçalves',
		'BR2901908' => 'Aporá',
		'BR2902054' => 'Araças',
		'BR2902005' => 'Aracatu',
		'BR2902203' => 'Aramari',
		'BR2902252' => 'Arataca',
		'BR2902401' => 'Aurelino Leal',
		'BR2902500' => 'Baianópolis',
		'BR2902658' => 'Banzaê',
		'BR2903003' => 'Barra do Mendes',
		'BR2903235' => 'Barro Alto',
		'BR2903276' => 'Barrocas',
		'BR2903508' => 'Belo Campo',
		'BR2903607' => 'Biritinga',
		'BR2903706' => 'Boa Nova',
		'BR2903805' => 'Boa Vista do Tupim',
		'BR2903953' => 'Bom Jesus da Serra',
		'BR2904001' => 'Boninal',
		'BR2904050' => 'Bonito',
		'BR2904209' => 'Botuporã',
		'BR2904308' => 'Brejões',
		'BR2904407' => 'Brejolândia',
		'BR2904506' => 'Brotas de Macaúbas',
		'BR2904704' => 'Buerarema',
		'BR2904753' => 'Buritirama',
		'BR2904803' => 'Caatiba',
		'BR2904852' => 'Cabaceiras do Paraguaçu',
		'BR2905107' => 'Caém',
		'BR2905156' => 'Caetanos',
		'BR2905305' => 'Cafarnaum',
		'BR2905404' => 'Cairu',
		'BR2905503' => 'Caldeirão Grande',
		'BR2906600' => 'Candiba',
		'BR2906824' => 'Canudos',
		'BR2906857' => 'Capela do Alto Alegre',
		'BR2906899' => 'Caraíbas',
		'BR2907608' => 'Central',
		'BR2907707' => 'Chorrochó',
		'BR2907905' => 'Cipó',
		'BR2908101' => 'Cocos',
		'BR2908309' => 'Conceição do Almeida',
		'BR2908705' => 'Condeúba',
		'BR2909109' => 'Coribe',
		'BR2909208' => 'Coronel João Sá',
		'BR2909406' => 'Cotegipe',
		'BR2909703' => 'Cristópolis',
		'BR2910008' => 'Dário Meira',
		'BR2910107' => 'Dom Basílio',
		'BR2900504' => 'Érico Cardoso',
		'BR2910750' => 'Fátima',
		'BR2910859' => 'Filadélfia',
		'BR2911006' => 'Floresta Azul',
		'BR2911303' => 'Gentio do Ouro',
		'BR2911402' => 'Glória',
		'BR2911600' => 'Governador Mangabeira',
		'BR2911659' => 'Guajeru',
		'BR2911857' => 'Heliópolis',
		'BR2912004' => 'Ibiassucê',
		'BR2912202' => 'Ibicoara',
		'BR2912301' => 'Ibicuí',
		'BR2912400' => 'Ibipeba',
		'BR2912509' => 'Ibipitanga',
		'BR2912905' => 'Ibirataia',
		'BR2913002' => 'Ibitiara',
		'BR2913101' => 'Ibititá',
		'BR2913408' => 'Igaporã',
		'BR2913457' => 'Igrapiúna',
		'BR2913804' => 'Ipecaetá',
		'BR2914307' => 'Iramaia',
		'BR2915007' => 'Itaeté',
		'BR2915106' => 'Itagi',
		'BR2915205' => 'Itagibá',
		'BR2915353' => 'Itaguaçu da Bahia',
		'BR2916203' => 'Itapé',
		'BR2916302' => 'Itapebi',
		'BR2916609' => 'Itapitanga',
		'BR2916807' => 'Itarantim',
		'BR2916856' => 'Itatim',
		'BR2916906' => 'Itiruçu',
		'BR2917102' => 'Itororó',
		'BR2917201' => 'Ituaçu',
		'BR2917334' => 'Iuiú',
		'BR2917409' => 'Jacaraci',
		'BR2917805' => 'Jaguaripe',
		'BR2917904' => 'Jandaíra',
		'BR2918209' => 'Jiquiriçá',
		'BR2918308' => 'Jitaúna',
		'BR2918456' => 'Jucuruçu',
		'BR2918506' => 'Jussara',
		'BR2918753' => 'Lagoa Real',
		'BR2919306' => 'Lençóis',
		'BR2919405' => 'Licínio de Almeida',
		'BR2919603' => 'Macajuba',
		'BR2919702' => 'Macarani',
		'BR2919926' => 'Madre de Deus',
		'BR2920106' => 'Mairi',
		'BR2920205' => 'Malhada',
		'BR2920403' => 'Manoel Vitorino',
		'BR2920452' => 'Mansidão',
		'BR2920700' => 'Maraú',
		'BR2920809' => 'Marcionílio Souza',
		'BR2920908' => 'Mascote',
		'BR2921054' => 'Matina',
		'BR2921302' => 'Milagres',
		'BR2921401' => 'Mirangaba',
		'BR2921450' => 'Mirante',
		'BR2921807' => 'Mortugaba',
		'BR2921906' => 'Mucugê',
		'BR2922052' => 'Mulungu do Morro',
		'BR2922250' => 'Muquém de São Francisco',
		'BR2922607' => 'Nilo Peçanha',
		'BR2922656' => 'Nordestina',
		'BR2922706' => 'Nova Canaã',
		'BR2923035' => 'Novo Horizonte',
		'BR2923050' => 'Novo Triunfo',
		'BR2923357' => 'Ourolândia',
		'BR2923902' => 'Pau Brasil',
		'BR2924058' => 'Pé de Serra',
		'BR2924207' => 'Pedro Alexandre',
		'BR2924306' => 'Piatã',
		'BR2924504' => 'Pindaí',
		'BR2924652' => 'Pintadas',
		'BR2924702' => 'Piripá',
		'BR2925253' => 'Ponto Novo',
		'BR2925600' => 'Presidente Dutra',
		'BR2925709' => 'Presidente Jânio Quadros',
		'BR2926103' => 'Retirolândia',
		'BR2926509' => 'Ribeira do Amparo',
		'BR2926707' => 'Rio de Contas',
		'BR2926806' => 'Rio do Antônio',
		'BR2926905' => 'Rio do Pires',
		'BR2927309' => 'Salinas da Margarida',
		'BR2927507' => 'Santa Bárbara',
		'BR2927606' => 'Santa Brígida',
		'BR2927903' => 'Santa Inês',
		'BR2928059' => 'Santa Luzia',
		'BR2929008' => 'São Félix',
		'BR2929057' => 'São Félix do Coribe',
		'BR2929255' => 'São Gabriel',
		'BR2929370' => 'São José do Jacuípe',
		'BR2929404' => 'São Miguel das Matas',
		'BR2929602' => 'Sapeaçu',
		'BR2929701' => 'Sátiro Dias',
		'BR2929750' => 'Saubara',
		'BR2929800' => 'Saúde',
		'BR2930006' => 'Sebastião Laranjeiras',
		'BR2930303' => 'Serra Dourada',
		'BR2930402' => 'Serra Preta',
		'BR2930600' => 'Serrolândia',
		'BR2930758' => 'Sítio do Mato',
		'BR2930766' => 'Sítio do Quinto',
		'BR2930808' => 'Souto Soares',
		'BR2930907' => 'Tabocas do Brejo Velho',
		'BR2931053' => 'Tanque Novo',
		'BR2931202' => 'Taperoá',
		'BR2931301' => 'Tapiramutá',
		'BR2931608' => 'Teolândia',
		'BR2931707' => 'Terra Nova',
		'BR2931806' => 'Tremedal',
		'BR2932101' => 'Ubaíra',
		'BR2932408' => 'Uibaí',
		'BR2932457' => 'Umburanas',
		'BR2932606' => 'Urandi',
		'BR2932705' => 'Uruçuca',
		'BR2932804' => 'Utinga',
		'BR2933059' => 'Várzea da Roça',
		'BR2933158' => 'Várzea Nova',
		'BR2933455' => 'Wanderley',
		'BR2900801' => 'Alcobaça',
		'BR2901007' => 'Amargosa',
		'BR2901106' => 'Amélia Rodrigues',
		'BR2901205' => 'Anagé',
		'BR2902609' => 'Baixa Grande',
		'BR2902708' => 'Barra',
		'BR2902807' => 'Barra da Estiva',
		'BR2902906' => 'Barra do Choça',
		'BR2903409' => 'Belmonte',
		'BR2904100' => 'Boquira',
		'BR2904902' => 'Cachoeira',
		'BR2905008' => 'Caculé',
		'BR2905206' => 'Caetité',
		'BR2905602' => 'Camacan',
		'BR2905800' => 'Camamu',
		'BR2905909' => 'Campo Alegre de Lourdes',
		'BR2906204' => 'Canarana',
		'BR2906303' => 'Canavieiras',
		'BR2906709' => 'Cândido Sales',
		'BR2906808' => 'Cansanção',
		'BR2906873' => 'Capim Grosso',
		'BR2906907' => 'Caravelas',
		'BR2907103' => 'Carinhanha',
		'BR2907301' => 'Castro Alves',
		'BR2907806' => 'Cícero Dantas',
		'BR2908002' => 'Coaraci',
		'BR2908200' => 'Conceição da Feira',
		'BR2908507' => 'Conceição do Jacuípe',
		'BR2908606' => 'Conde',
		'BR2908903' => 'Coração de Maria',
		'BR2909307' => 'Correntina',
		'BR2909604' => 'Crisópolis',
		'BR2909901' => 'Curaçá',
		'BR2910404' => 'Encruzilhada',
		'BR2910503' => 'Entre Rios',
		'BR2910602' => 'Esplanada',
		'BR2911105' => 'Formosa do Rio Preto',
		'BR2911204' => 'Gandu',
		'BR2911808' => 'Guaratinga',
		'BR2911907' => 'Iaçu',
		'BR2912103' => 'Ibicaraí',
		'BR2912707' => 'Ibirapitanga',
		'BR2913200' => 'Ibotirama',
		'BR2913507' => 'Iguaí',
		'BR2913705' => 'Inhambupe',
		'BR2913903' => 'Ipiaú',
		'BR2914406' => 'Iraquara',
		'BR2914505' => 'Irará',
		'BR2914653' => 'Itabela',
		'BR2914901' => 'Itacaré',
		'BR2915502' => 'Itajuípe',
		'BR2915809' => 'Itambé',
		'BR2916005' => 'Itanhém',
		'BR2916104' => 'Itaparica',
		'BR2916500' => 'Itapicuru',
		'BR2917003' => 'Itiúba',
		'BR2917300' => 'Ituberá',
		'BR2917706' => 'Jaguarari',
		'BR2918100' => 'Jeremoabo',
		'BR2918357' => 'João Dourado',
		'BR2918803' => 'Laje',
		'BR2919157' => 'Lapão',
		'BR2919504' => 'Livramento de Nossa Senhora',
		'BR2919801' => 'Macaúbas',
		'BR2920502' => 'Maracás',
		'BR2920601' => 'Maragogipe',
		'BR2921005' => 'Mata de São João',
		'BR2921104' => 'Medeiros Neto',
		'BR2921203' => 'Miguel Calmon',
		'BR2921708' => 'Morro do Chapéu',
		'BR2922003' => 'Mucuri',
		'BR2922102' => 'Mundo Novo',
		'BR2922300' => 'Muritiba',
		'BR2922409' => 'Mutuípe',
		'BR2922508' => 'Nazaré',
		'BR2922904' => 'Nova Soure',
		'BR2923001' => 'Nova Viçosa',
		'BR2923100' => 'Olindina',
		'BR2923209' => 'Oliveira dos Brejinhos',
		'BR2923407' => 'Palmas de Monte Alto',
		'BR2923605' => 'Paramirim',
		'BR2923704' => 'Paratinga',
		'BR2923803' => 'Paripiranga',
		'BR2924405' => 'Pilão Arcado',
		'BR2924603' => 'Pindobaçu',
		'BR2924801' => 'Piritiba',
		'BR2925006' => 'Planalto',
		'BR2925105' => 'Poções',
		'BR2925204' => 'Pojuca',
		'BR2925501' => 'Prado',
		'BR2925758' => 'Presidente Tancredo Neves',
		'BR2925808' => 'Queimadas',
		'BR2925907' => 'Quijingue',
		'BR2925956' => 'Rafael Jambeiro',
		'BR2926004' => 'Remanso',
		'BR2926202' => 'Riachão das Neves',
		'BR2926301' => 'Riachão do Jacuípe',
		'BR2926400' => 'Riacho de Santana',
		'BR2926608' => 'Ribeira do Pombal',
		'BR2927002' => 'Rio Real',
		'BR2927200' => 'Ruy Barbosa',
		'BR2927705' => 'Santa Cruz Cabrália',
		'BR2928109' => 'Santa Maria da Vitória',
		'BR2928406' => 'Santa Rita de Cássia',
		'BR2928000' => 'Santaluz',
		'BR2928208' => 'Santana',
		'BR2928802' => 'Santo Estêvão',
		'BR2928901' => 'São Desidério',
		'BR2929107' => 'São Felipe',
		'BR2929206' => 'São Francisco do Conde',
		'BR2929305' => 'São Gonçalo dos Campos',
		'BR2929503' => 'São Sebastião do Passé',
		'BR2929909' => 'Seabra',
		'BR2930204' => 'Sento Sé',
		'BR2930154' => 'Serra do Ramalho',
		'BR2930774' => 'Sobradinho',
		'BR2931004' => 'Tanhaçu',
		'BR2931509' => 'Teofilândia',
		'BR2932002' => 'Uauá',
		'BR2932200' => 'Ubaitaba',
		'BR2932309' => 'Ubatã',
		'BR2932507' => 'Una',
		'BR2933000' => 'Valente',
		'BR2933208' => 'Vera Cruz',
		'BR2933505' => 'Wenceslau Guimarães',
		'BR2933604' => 'Xique-Xique',
		'BR2902104' => 'Araci',
		'BR2903904' => 'Bom Jesus da Lapa',
		'BR2904605' => 'Brumado',
		'BR2906006' => 'Campo Formoso',
		'BR2906501' => 'Candeias',
		'BR2907202' => 'Casa Nova',
		'BR2907509' => 'Catu',
		'BR2908408' => 'Conceição do Coité',
		'BR2909802' => 'Cruz das Almas',
		'BR2910057' => 'Dias dÁvila',
		'BR2910701' => 'Euclides da Cunha',
		'BR2911709' => 'Guanambi',
		'BR2914000' => 'Ipirá',
		'BR2914604' => 'Irecê',
		'BR2914703' => 'Itaberaba',
		'BR2915601' => 'Itamaraju',
		'BR2916401' => 'Itapetinga',
		'BR2917508' => 'Jacobina',
		'BR2917607' => 'Jaguaquara',
		'BR2919553' => 'Luís Eduardo Magalhães',
		'BR2921500' => 'Monte Santo',
		'BR2928604' => 'Santo Amaro',
		'BR2928703' => 'Santo Antônio de Jesus',
		'BR2930105' => 'Senhor do Bonfim',
		'BR2930501' => 'Serrinha',
		'BR2931905' => 'Tucano',
		'BR2932903' => 'Valença',
		'BR2900702' => 'Alagoinhas',
		'BR2903201' => 'Barreiras',
		'BR2905701' => 'Camaçari',
		'BR2910727' => 'Eunápolis',
		'BR2913606' => 'Ilhéus',
		'BR2914802' => 'Itabuna',
		'BR2918001' => 'Jequié',
		'BR2918407' => 'Juazeiro',
		'BR2919207' => 'Lauro de Freitas',
		'BR2924009' => 'Paulo Afonso',
		'BR2925303' => 'Porto Seguro',
		'BR2930709' => 'Simões Filho',
		'BR2931350' => 'Teixeira de Freitas',
		'BR2933307' => 'Vitória da Conquista',
		'BR2910800' => 'Feira de Santana',
		'BR2927408' => 'Salvador',
	],
	'CE' => [
		'BR2304806' => 'Granjeiro',
		'BR2305100' => 'Guaramiranga',
		'BR2300606' => 'Altaneira',
		'BR2300804' => 'Antonina do Norte',
		'BR2301505' => 'Arneiroz',
		'BR2301802' => 'Baixio',
		'BR2303659' => 'Catunda',
		'BR2304269' => 'Deputado Irapuan Pinheiro',
		'BR2304277' => 'Ererê',
		'BR2304608' => 'General Sampaio',
		'BR2306207' => 'Itaiçaba',
		'BR2307205' => 'Jati',
		'BR2308807' => 'Moraújo',
		'BR2309904' => 'Pacujá',
		'BR2310001' => 'Palhano',
		'BR2310605' => 'Penaforte',
		'BR2311231' => 'Potiretama',
		'BR2312502' => 'São João do Jaguaribe',
		'BR2312809' => 'Senador Sá',
		'BR2313252' => 'Tarrafas',
		'BR2313708' => 'Umari',
		'BR2300101' => 'Abaiara',
		'BR2300150' => 'Acarape',
		'BR2300408' => 'Aiuaba',
		'BR2300507' => 'Alcântaras',
		'BR2300705' => 'Alto Santo',
		'BR2300903' => 'Apuiarés',
		'BR2301257' => 'Ararendá',
		'BR2301406' => 'Aratuba',
		'BR2301851' => 'Banabuiú',
		'BR2301950' => 'Barreira',
		'BR2302057' => 'Barroquinha',
		'BR2302909' => 'Capistrano',
		'BR2303105' => 'Cariré',
		'BR2303303' => 'Cariús',
		'BR2303402' => 'Carnaubal',
		'BR2303600' => 'Catarina',
		'BR2303907' => 'Chaval',
		'BR2303931' => 'Choró',
		'BR2303956' => 'Chorozinho',
		'BR2304236' => 'Croatá',
		'BR2304301' => 'Farias Brito',
		'BR2304459' => 'Fortim',
		'BR2304509' => 'Frecheirinha',
		'BR2304657' => 'Graça',
		'BR2304905' => 'Groaíras',
		'BR2305209' => 'Hidrolândia',
		'BR2305266' => 'Ibaretama',
		'BR2305332' => 'Ibicuitinga',
		'BR2305357' => 'Icapuí',
		'BR2305654' => 'Ipaporanga',
		'BR2305704' => 'Ipaumirim',
		'BR2306009' => 'Iracema',
		'BR2306504' => 'Itapiúna',
		'BR2306603' => 'Itatira',
		'BR2306702' => 'Jaguaretama',
		'BR2306801' => 'Jaguaribara',
		'BR2307254' => 'Jijoca de Jericoacoara',
		'BR2307635' => 'Madalena',
		'BR2307908' => 'Martinópole',
		'BR2308203' => 'Meruoca',
		'BR2308351' => 'Milhã',
		'BR2308377' => 'Miraíma',
		'BR2308609' => 'Monsenhor Tabosa',
		'BR2309003' => 'Mucambo',
		'BR2309102' => 'Mulungu',
		'BR2309201' => 'Nova Olinda',
		'BR2309805' => 'Pacoti',
		'BR2310100' => 'Palmácia',
		'BR2310407' => 'Paramoti',
		'BR2310803' => 'Pereiro',
		'BR2310852' => 'Pindoretama',
		'BR2310902' => 'Piquet Carneiro',
		'BR2310951' => 'Pires Ferreira',
		'BR2311009' => 'Poranga',
		'BR2311108' => 'Porteiras',
		'BR2311207' => 'Potengi',
		'BR2311264' => 'Quiterianópolis',
		'BR2311355' => 'Quixelô',
		'BR2311504' => 'Quixeré',
		'BR2311702' => 'Reriutaba',
		'BR2311900' => 'Saboeiro',
		'BR2311959' => 'Salitre',
		'BR2312106' => 'Santana do Cariri',
		'BR2312601' => 'São Luís do Curu',
		'BR2313005' => 'Solonópole',
		'BR2313351' => 'Tejuçuoca',
		'BR2313559' => 'Tururu',
		'BR2313757' => 'Umirim',
		'BR2313807' => 'Uruburetama',
		'BR2313906' => 'Uruoca',
		'BR2313955' => 'Varjota',
		'BR2300754' => 'Amontada',
		'BR2301208' => 'Aracoiaba',
		'BR2301307' => 'Araripe',
		'BR2301604' => 'Assaré',
		'BR2301703' => 'Aurora',
		'BR2302008' => 'Barro',
		'BR2302107' => 'Baturité',
		'BR2302206' => 'Beberibe',
		'BR2302305' => 'Bela Cruz',
		'BR2302503' => 'Brejo Santo',
		'BR2302701' => 'Campos Sales',
		'BR2303006' => 'Caridade',
		'BR2303204' => 'Caririaçu',
		'BR2303808' => 'Cedro',
		'BR2304004' => 'Coreaú',
		'BR2304251' => 'Cruz',
		'BR2304285' => 'Eusébio',
		'BR2304350' => 'Forquilha',
		'BR2304954' => 'Guaiúba',
		'BR2305001' => 'Guaraciaba do Norte',
		'BR2305308' => 'Ibiapina',
		'BR2305605' => 'Independência',
		'BR2305803' => 'Ipu',
		'BR2305902' => 'Ipueiras',
		'BR2306108' => 'Irauçuba',
		'BR2306256' => 'Itaitinga',
		'BR2306306' => 'Itapagé',
		'BR2306553' => 'Itarema',
		'BR2306900' => 'Jaguaribe',
		'BR2307007' => 'Jaguaruana',
		'BR2307106' => 'Jardim',
		'BR2307403' => 'Jucás',
		'BR2307502' => 'Lavras da Mangabeira',
		'BR2307809' => 'Marco',
		'BR2308005' => 'Massapê',
		'BR2308104' => 'Mauriti',
		'BR2308302' => 'Milagres',
		'BR2308401' => 'Missão Velha',
		'BR2308500' => 'Mombaça',
		'BR2308906' => 'Morrinhos',
		'BR2309300' => 'Nova Russas',
		'BR2309409' => 'Novo Oriente',
		'BR2309458' => 'Ocara',
		'BR2309508' => 'Orós',
		'BR2310209' => 'Paracuru',
		'BR2310258' => 'Paraipaba',
		'BR2310308' => 'Parambu',
		'BR2310506' => 'Pedra Branca',
		'BR2310704' => 'Pentecoste',
		'BR2311603' => 'Redenção',
		'BR2312205' => 'Santa Quitéria',
		'BR2312007' => 'Santana do Acaraú',
		'BR2312304' => 'São Benedito',
		'BR2312403' => 'São Gonçalo do Amarante',
		'BR2312700' => 'Senador Pompeu',
		'BR2313104' => 'Tabuleiro do Norte',
		'BR2313203' => 'Tamboril',
		'BR2313609' => 'Ubajara',
		'BR2314003' => 'Várzea Alegre',
		'BR2300200' => 'Acaraú',
		'BR2300309' => 'Acopiara',
		'BR2301000' => 'Aquiraz',
		'BR2301109' => 'Aracati',
		'BR2301901' => 'Barbalha',
		'BR2302404' => 'Boa Viagem',
		'BR2302602' => 'Camocim',
		'BR2302800' => 'Canindé',
		'BR2303501' => 'Cascavel',
		'BR2304103' => 'Crateús',
		'BR2304707' => 'Granja',
		'BR2305233' => 'Horizonte',
		'BR2305407' => 'Icó',
		'BR2305506' => 'Iguatu',
		'BR2307601' => 'Limoeiro do Norte',
		'BR2308708' => 'Morada Nova',
		'BR2309607' => 'Pacajus',
		'BR2309706' => 'Pacatuba',
		'BR2311306' => 'Quixadá',
		'BR2311405' => 'Quixeramobim',
		'BR2311801' => 'Russas',
		'BR2313302' => 'Tauá',
		'BR2313401' => 'Tianguá',
		'BR2313500' => 'Trairi',
		'BR2314102' => 'Viçosa do Ceará',
		'BR2303709' => 'Caucaia',
		'BR2304202' => 'Crato',
		'BR2306405' => 'Itapipoca',
		'BR2307304' => 'Juazeiro do Norte',
		'BR2307650' => 'Maracanaú',
		'BR2307700' => 'Maranguape',
		'BR2312908' => 'Sobral',
		'BR2304400' => 'Fortaleza',
	],
	'DF' => [
		'BR5300108' => 'Brasília',
	],
	'ES' => [
		'BR3201803' => 'Divino de São Lourenço',
		'BR3200136' => 'Águia Branca',
		'BR3200359' => 'Alto Rio Novo',
		'BR3200508' => 'Apiacá',
		'BR3200706' => 'Atilio Vivacqua',
		'BR3201100' => 'Bom Jesus do Norte',
		'BR3202009' => 'Dores do Rio Preto',
		'BR3202553' => 'Ibitirama',
		'BR3203601' => 'Mucurici',
		'BR3204252' => 'Ponto Belo',
		'BR3204658' => 'São Domingos do Norte',
		'BR3205150' => 'Vila Pavão',
		'BR3200169' => 'Água Doce do Norte',
		'BR3200300' => 'Alfredo Chaves',
		'BR3201001' => 'Boa Esperança',
		'BR3201159' => 'Brejetuba',
		'BR3201704' => 'Conceição do Castelo',
		'BR3202207' => 'Fundão',
		'BR3202256' => 'Governador Lindenberg',
		'BR3202504' => 'Ibiraçu',
		'BR3202603' => 'Iconha',
		'BR3202652' => 'Irupi',
		'BR3202702' => 'Itaguaçu',
		'BR3202900' => 'Itarana',
		'BR3203106' => 'Jerônimo Monteiro',
		'BR3203130' => 'João Neiva',
		'BR3203163' => 'Laranja da Terra',
		'BR3203304' => 'Mantenópolis',
		'BR3203346' => 'Marechal Floriano',
		'BR3203353' => 'Marilândia',
		'BR3203502' => 'Montanha',
		'BR3203700' => 'Muniz Freire',
		'BR3203809' => 'Muqui',
		'BR3204203' => 'Piúma',
		'BR3204302' => 'Presidente Kennedy',
		'BR3204351' => 'Rio Bananal',
		'BR3204401' => 'Rio Novo do Sul',
		'BR3204500' => 'Santa Leopoldina',
		'BR3204807' => 'São José do Calçado',
		'BR3204955' => 'São Roque do Canaã',
		'BR3205036' => 'Vargem Alta',
		'BR3205176' => 'Vila Valério',
		'BR3200102' => 'Afonso Cláudio',
		'BR3200201' => 'Alegre',
		'BR3200409' => 'Anchieta',
		'BR3200805' => 'Baixo Guandu',
		'BR3200904' => 'Barra de São Francisco',
		'BR3201407' => 'Castelo',
		'BR3201605' => 'Conceição da Barra',
		'BR3201902' => 'Domingos Martins',
		'BR3202108' => 'Ecoporanga',
		'BR3202306' => 'Guaçuí',
		'BR3202454' => 'Ibatiba',
		'BR3202801' => 'Itapemirim',
		'BR3203007' => 'Iúna',
		'BR3203056' => 'Jaguaré',
		'BR3203320' => 'Marataízes',
		'BR3203403' => 'Mimoso do Sul',
		'BR3203908' => 'Nova Venécia',
		'BR3204005' => 'Pancas',
		'BR3204054' => 'Pedro Canário',
		'BR3204104' => 'Pinheiros',
		'BR3204559' => 'Santa Maria de Jetibá',
		'BR3204609' => 'Santa Teresa',
		'BR3204708' => 'São Gabriel da Palha',
		'BR3205010' => 'Sooretama',
		'BR3205069' => 'Venda Nova do Imigrante',
		'BR3200607' => 'Aracruz',
		'BR3205101' => 'Viana',
		'BR3201209' => 'Cachoeiro de Itapemirim',
		'BR3201308' => 'Cariacica',
		'BR3201506' => 'Colatina',
		'BR3202405' => 'Guarapari',
		'BR3203205' => 'Linhares',
		'BR3204906' => 'São Mateus',
		'BR3205002' => 'Serra',
		'BR3205200' => 'Vila Velha',
		'BR3205309' => 'Vitória',
	],
	'GO' => [
		'BR5200159' => 'Adelândia',
		'BR5200209' => 'Água Limpa',
		'BR5200506' => 'Aloândia',
		'BR5200555' => 'Alto Horizonte',
		'BR5200829' => 'Amaralina',
		'BR5200902' => 'Amorinópolis',
		'BR5201207' => 'Anhanguera',
		'BR5201454' => 'Aparecida do Rio Doce',
		'BR5201504' => 'Aporé',
		'BR5201603' => 'Araçu',
		'BR5202353' => 'Arenópolis',
		'BR5202601' => 'Aurilândia',
		'BR5202809' => 'Avelinópolis',
		'BR5203104' => 'Baliza',
		'BR5203575' => 'Bonópolis',
		'BR5203609' => 'Brazabrantes',
		'BR5203939' => 'Buriti de Goiás',
		'BR5203962' => 'Buritinópolis',
		'BR5204201' => 'Cachoeira de Goiás',
		'BR5204557' => 'Caldazinha',
		'BR5204607' => 'Campestre de Goiás',
		'BR5204656' => 'Campinaçu',
		'BR5205059' => 'Castelândia',
		'BR5205208' => 'Caturaí',
		'BR5205521' => 'Colinas do Sul',
		'BR5205703' => 'Córrego do Ouro',
		'BR5206305' => 'Cristianópolis',
		'BR5206503' => 'Cromínia',
		'BR5206602' => 'Cumari',
		'BR5206701' => 'Damianópolis',
		'BR5206800' => 'Damolândia',
		'BR5206909' => 'Davinópolis',
		'BR5207105' => 'Diorama',
		'BR5208301' => 'Divinópolis de Goiás',
		'BR5207352' => 'Edealina',
		'BR5207501' => 'Estrela do Norte',
		'BR5208103' => 'Formoso',
		'BR5208152' => 'Gameleira de Goiás',
		'BR5209150' => 'Gouvelândia',
		'BR5209291' => 'Guaraíta',
		'BR5209408' => 'Guarani de Goiás',
		'BR5209457' => 'Guarinos',
		'BR5209606' => 'Heitoraí',
		'BR5209804' => 'Hidrolina',
		'BR5210158' => 'Ipiranga de Goiás',
		'BR5210307' => 'Israelândia',
		'BR5210562' => 'Itaguari',
		'BR5211602' => 'Ivolândia',
		'BR5212006' => 'Jaupaci',
		'BR5212055' => 'Jesúpolis',
		'BR5212253' => 'Lagoa Santa',
		'BR5212600' => 'Mairipotaba',
		'BR5212907' => 'Marzagão',
		'BR5212956' => 'Matrinchã',
		'BR5213053' => 'Mimoso de Goiás',
		'BR5213400' => 'Moiporá',
		'BR5213772' => 'Montividiu do Norte',
		'BR5213855' => 'Morro Agudo de Goiás',
		'BR5214101' => 'Mutunópolis',
		'BR5214705' => 'Nova América',
		'BR5214804' => 'Nova Aurora',
		'BR5214879' => 'Nova Iguaçu de Goiás',
		'BR5214903' => 'Nova Roma',
		'BR5215207' => 'Novo Brasil',
		'BR5215256' => 'Novo Planalto',
		'BR5215405' => 'Ouro Verde de Goiás',
		'BR5215652' => 'Palestina de Goiás',
		'BR5215801' => 'Palmelo',
		'BR5215900' => 'Palminópolis',
		'BR5216007' => 'Panamá',
		'BR5216452' => 'Perolândia',
		'BR5216908' => 'Pilar de Goiás',
		'BR5218052' => 'Porteirão',
		'BR5218102' => 'Portelândia',
		'BR5218391' => 'Professor Jamil',
		'BR5218706' => 'Rianápolis',
		'BR5218789' => 'Rio Quente',
		'BR5219209' => 'Santa Cruz de Goiás',
		'BR5219258' => 'Santa Fé de Goiás',
		'BR5219357' => 'Santa Isabel',
		'BR5219456' => 'Santa Rita do Novo Destino',
		'BR5219506' => 'Santa Rosa de Goiás',
		'BR5219605' => 'Santa Tereza de Goiás',
		'BR5219712' => 'Santo Antônio da Barra',
		'BR5219738' => 'Santo Antônio de Goiás',
		'BR5220058' => 'São João da Paraúna',
		'BR5220157' => 'São Luíz do Norte',
		'BR5220264' => 'São Miguel do Passa Quatro',
		'BR5220280' => 'São Patrício',
		'BR5220702' => 'Sítio dAbadia',
		'BR5221007' => 'Taquaral de Goiás',
		'BR5221080' => 'Teresina de Goiás',
		'BR5221304' => 'Três Ranchos',
		'BR5221452' => 'Trombas',
		'BR5221502' => 'Turvânia',
		'BR5221551' => 'Turvelândia',
		'BR5221577' => 'Uirapuru',
		'BR5221809' => 'Urutaí',
		'BR5221908' => 'Varjão',
		'BR5222203' => 'Vila Boa',
		'BR5200050' => 'Abadia de Goiás',
		'BR5200175' => 'Água Fria de Goiás',
		'BR5200605' => 'Alto Paraíso de Goiás',
		'BR5200803' => 'Alvorada do Norte',
		'BR5200852' => 'Americano do Brasil',
		'BR5201801' => 'Aragoiânia',
		'BR5202155' => 'Araguapaz',
		'BR5202502' => 'Aruanã',
		'BR5203203' => 'Barro Alto',
		'BR5203401' => 'Bom Jardim de Goiás',
		'BR5203559' => 'Bonfinópolis',
		'BR5203807' => 'Britânia',
		'BR5203906' => 'Buriti Alegre',
		'BR5204003' => 'Cabeceiras',
		'BR5204250' => 'Cachoeira Dourada',
		'BR5204805' => 'Campo Alegre de Goiás',
		'BR5204854' => 'Campo Limpo de Goiás',
		'BR5204953' => 'Campos Verdes',
		'BR5205000' => 'Carmo do Rio Verde',
		'BR5205307' => 'Cavalcante',
		'BR5205455' => 'Cezarina',
		'BR5205471' => 'Chapadão do Céu',
		'BR5205901' => 'Corumbaíba',
		'BR5207253' => 'Doverlândia',
		'BR5207535' => 'Faina',
		'BR5207600' => 'Fazenda Nova',
		'BR5208509' => 'Goiandira',
		'BR5209937' => 'Inaciolândia',
		'BR5210604' => 'Itaguaru',
		'BR5210802' => 'Itajá',
		'BR5211008' => 'Itapirapuã',
		'BR5211305' => 'Itarumã',
		'BR5211404' => 'Itauçu',
		'BR5211701' => 'Jandaia',
		'BR5212105' => 'Joviânia',
		'BR5212303' => 'Leopoldo de Bulhões',
		'BR5212709' => 'Mambaí',
		'BR5213509' => 'Monte Alegre de Goiás',
		'BR5213707' => 'Montes Claros de Goiás',
		'BR5213905' => 'Mossâmedes',
		'BR5214051' => 'Mundo Novo',
		'BR5214408' => 'Nazário',
		'BR5214861' => 'Nova Glória',
		'BR5215009' => 'Nova Veneza',
		'BR5215504' => 'Ouvidor',
		'BR5216304' => 'Paranaiguara',
		'BR5219001' => 'Sanclerlândia',
		'BR5219100' => 'Santa Bárbara de Goiás',
		'BR5219407' => 'Santa Rita do Araguaia',
		'BR5219902' => 'São Francisco de Goiás',
		'BR5220504' => 'Serranópolis',
		'BR5220686' => 'Simolândia',
		'BR5221197' => 'Terezópolis de Goiás',
		'BR5222054' => 'Vicentinópolis',
		'BR5222302' => 'Vila Propício',
		'BR5200100' => 'Abadiânia',
		'BR5201702' => 'Aragarças',
		'BR5204102' => 'Cachoeira Alta',
		'BR5204300' => 'Caçu',
		'BR5204409' => 'Caiapônia',
		'BR5204706' => 'Campinorte',
		'BR5204904' => 'Campos Belos',
		'BR5205513' => 'Cocalzinho de Goiás',
		'BR5205802' => 'Corumbá de Goiás',
		'BR5206404' => 'Crixás',
		'BR5207402' => 'Edéia',
		'BR5207808' => 'Firminópolis',
		'BR5207907' => 'Flores de Goiás',
		'BR5208400' => 'Goianápolis',
		'BR5209200' => 'Guapó',
		'BR5209705' => 'Hidrolândia',
		'BR5209903' => 'Iaciara',
		'BR5209952' => 'Indiara',
		'BR5210901' => 'Itapaci',
		'BR5212204' => 'Jussara',
		'BR5212808' => 'Mara Rosa',
		'BR5213004' => 'Maurilândia',
		'BR5213756' => 'Montividiu',
		'BR5214002' => 'Mozarlândia',
		'BR5214838' => 'Nova Crixás',
		'BR5215306' => 'Orizona',
		'BR5216403' => 'Paraúna',
		'BR5216809' => 'Petrolina de Goiás',
		'BR5217203' => 'Piranhas',
		'BR5217708' => 'Pontalina',
		'BR5218607' => 'Rialma',
		'BR5218904' => 'Rubiataba',
		'BR5219704' => 'Santa Terezinha de Goiás',
		'BR5219803' => 'São Domingos',
		'BR5220009' => 'São João dAliança',
		'BR5220405' => 'São Simão',
		'BR5220603' => 'Silvânia',
		'BR5221700' => 'Uruana',
		'BR5222005' => 'Vianópolis',
		'BR5200134' => 'Acreúna',
		'BR5200308' => 'Alexânia',
		'BR5201306' => 'Anicuns',
		'BR5203302' => 'Bela Vista de Goiás',
		'BR5203500' => 'Bom Jesus de Goiás',
		'BR5205406' => 'Ceres',
		'BR5206206' => 'Cristalina',
		'BR5208806' => 'Goianira',
		'BR5208905' => 'Goiás',
		'BR5209101' => 'Goiatuba',
		'BR5210000' => 'Inhumas',
		'BR5210109' => 'Ipameri',
		'BR5210208' => 'Iporá',
		'BR5210406' => 'Itaberaí',
		'BR5211206' => 'Itapuranga',
		'BR5211800' => 'Jaraguá',
		'BR5213087' => 'Minaçu',
		'BR5213806' => 'Morrinhos',
		'BR5214507' => 'Nerópolis',
		'BR5214606' => 'Niquelândia',
		'BR5215603' => 'Padre Bernardo',
		'BR5215702' => 'Palmeiras de Goiás',
		'BR5217104' => 'Piracanjuba',
		'BR5217302' => 'Pirenópolis',
		'BR5217401' => 'Pires do Rio',
		'BR5218003' => 'Porangatu',
		'BR5218300' => 'Posse',
		'BR5218508' => 'Quirinópolis',
		'BR5219308' => 'Santa Helena de Goiás',
		'BR5220108' => 'São Luís de Montes Belos',
		'BR5220207' => 'São Miguel do Araguaia',
		'BR5221601' => 'Uruaçu',
		'BR5204508' => 'Caldas Novas',
		'BR5205109' => 'Catalão',
		'BR5205497' => 'Cidade Ocidental',
		'BR5208608' => 'Goianésia',
		'BR5211503' => 'Itumbiara',
		'BR5211909' => 'Jataí',
		'BR5213103' => 'Mineiros',
		'BR5215231' => 'Novo Gama',
		'BR5217609' => 'Planaltina',
		'BR5219753' => 'Santo Antônio do Descoberto',
		'BR5220454' => 'Senador Canedo',
		'BR5200258' => 'Águas Lindas de Goiás',
		'BR5201108' => 'Anápolis',
		'BR5201405' => 'Aparecida de Goiânia',
		'BR5208004' => 'Formosa',
		'BR5212501' => 'Luziânia',
		'BR5218805' => 'Rio Verde',
		'BR5221403' => 'Trindade',
		'BR5221858' => 'Valparaíso de Goiás',
		'BR5208707' => 'Goiânia',
	],
	'MA' => [
		'BR2105658' => 'Junco do Maranhão',
		'BR2107258' => 'Nova Colinas',
		'BR2107308' => 'Nova Iorque',
		'BR2110807' => 'São Félix de Balsas',
		'BR2111573' => 'São Pedro dos Crentes',
		'BR2111953' => 'Sucupira do Riachão',
		'BR2100105' => 'Afonso Cunha',
		'BR2100550' => 'Amapá do Maranhão',
		'BR2101350' => 'Bacurituba',
		'BR2101731' => 'Belágua',
		'BR2101806' => 'Benedito Leite',
		'BR2101939' => 'Bernardo do Mearim',
		'BR2101970' => 'Boa Vista do Gurupi',
		'BR2102150' => 'Brejo de Areia',
		'BR2102374' => 'Cachoeira Grande',
		'BR2103125' => 'Central do Maranhão',
		'BR2104073' => 'Feira Nova do Maranhão',
		'BR2104081' => 'Fernando Falcão',
		'BR2104628' => 'Governador Luiz Rocha',
		'BR2104701' => 'Graça Aranha',
		'BR2105450' => 'Jatobá',
		'BR2105948' => 'Lago dos Rodrigues',
		'BR2105989' => 'Lajeado Novo',
		'BR2106201' => 'Luís Domingues',
		'BR2106359' => 'Marajá do Sena',
		'BR2106672' => 'Milagres do Maranhão',
		'BR2107001' => 'Montes Altos',
		'BR2109056' => 'Porto Rico do Maranhão',
		'BR2109239' => 'Presidente Médici',
		'BR2109551' => 'Ribamar Fiquene',
		'BR2109700' => 'Sambaíba',
		'BR2109759' => 'Santa Filomena do Maranhão',
		'BR2110658' => 'São Domingos do Azeitão',
		'BR2111250' => 'São José dos Basílios',
		'BR2111631' => 'São Raimundo do Doca Bezerra',
		'BR2111672' => 'São Roberto',
		'BR2112001' => 'Tasso Fragoso',
		'BR2112274' => 'Tufilândia',
		'BR2100154' => 'Água Doce do Maranhão',
		'BR2100402' => 'Altamira do Maranhão',
		'BR2100501' => 'Alto Parnaíba',
		'BR2100808' => 'Anapurus',
		'BR2100832' => 'Apicum-Açu',
		'BR2100873' => 'Araguanã',
		'BR2101103' => 'Axixá',
		'BR2101251' => 'Bacabeira',
		'BR2101301' => 'Bacuri',
		'BR2101509' => 'Barão de Grajaú',
		'BR2101772' => 'Bela Vista do Maranhão',
		'BR2102077' => 'Bom Lugar',
		'BR2102358' => 'Buritirana',
		'BR2102408' => 'Cajapió',
		'BR2102507' => 'Cajari',
		'BR2102556' => 'Campestre do Maranhão',
		'BR2102606' => 'Cândido Mendes',
		'BR2102754' => 'Capinzal do Norte',
		'BR2103109' => 'Cedral',
		'BR2103158' => 'Centro do Guilherme',
		'BR2103174' => 'Centro Novo do Maranhão',
		'BR2103257' => 'Cidelândia',
		'BR2103554' => 'Conceição do Lago-Açu',
		'BR2103752' => 'Davinópolis',
		'BR2103901' => 'Duque Bacelar',
		'BR2104008' => 'Esperantinópolis',
		'BR2104099' => 'Formosa da Serra Negra',
		'BR2104107' => 'Fortaleza dos Nogueiras',
		'BR2104206' => 'Fortuna',
		'BR2104305' => 'Godofredo Viana',
		'BR2104404' => 'Gonçalves Dias',
		'BR2104503' => 'Governador Archer',
		'BR2104552' => 'Governador Edison Lobão',
		'BR2104602' => 'Governador Eugênio Barros',
		'BR2104651' => 'Governador Newton Bello',
		'BR2104909' => 'Guimarães',
		'BR2105153' => 'Igarapé do Meio',
		'BR2105203' => 'Igarapé Grande',
		'BR2105351' => 'Itaipava do Grajaú',
		'BR2105476' => 'Jenipapo dos Vieiras',
		'BR2105609' => 'Joselândia',
		'BR2105807' => 'Lago do Junco',
		'BR2105906' => 'Lago Verde',
		'BR2105922' => 'Lagoa do Mato',
		'BR2105963' => 'Lagoa Grande do Maranhão',
		'BR2106003' => 'Lima Campos',
		'BR2106102' => 'Loreto',
		'BR2106300' => 'Magalhães de Almeida',
		'BR2106326' => 'Maracaçumé',
		'BR2106375' => 'Maranhãozinho',
		'BR2106409' => 'Mata Roma',
		'BR2106631' => 'Matões do Norte',
		'BR2106805' => 'Mirinzal',
		'BR2107100' => 'Morros',
		'BR2107209' => 'Nina Rodrigues',
		'BR2107357' => 'Nova Olinda do Maranhão',
		'BR2107407' => 'Olho dÁgua das Cunhãs',
		'BR2107456' => 'Olinda Nova do Maranhão',
		'BR2107605' => 'Palmeirândia',
		'BR2107902' => 'Passagem Franca',
		'BR2108009' => 'Pastos Bons',
		'BR2108058' => 'Paulino Neves',
		'BR2108405' => 'Peri Mirim',
		'BR2108801' => 'Pirapemas',
		'BR2108900' => 'Poção de Pedras',
		'BR2109205' => 'Presidente Juscelino',
		'BR2109270' => 'Presidente Sarney',
		'BR2109304' => 'Presidente Vargas',
		'BR2109403' => 'Primeira Cruz',
		'BR2110237' => 'Santana do Maranhão',
		'BR2110278' => 'Santo Amaro do Maranhão',
		'BR2110302' => 'Santo Antônio dos Lopes',
		'BR2110401' => 'São Benedito do Rio Preto',
		'BR2110856' => 'São Francisco do Brejão',
		'BR2110906' => 'São Francisco do Maranhão',
		'BR2111003' => 'São João Batista',
		'BR2111029' => 'São João do Carú',
		'BR2111052' => 'São João do Paraíso',
		'BR2111078' => 'São João do Soter',
		'BR2111532' => 'São Pedro da Água Branca',
		'BR2111607' => 'São Raimundo das Mangabeiras',
		'BR2111722' => 'Satubinha',
		'BR2111748' => 'Senador Alexandre Costa',
		'BR2111763' => 'Senador La Rocque',
		'BR2111789' => 'Serrano do Maranhão',
		'BR2111805' => 'Sítio Novo',
		'BR2111904' => 'Sucupira do Norte',
		'BR2112233' => 'Trizidela do Vale',
		'BR2112852' => 'Vila Nova dos Martírios',
		'BR2100204' => 'Alcântara',
		'BR2100303' => 'Aldeias Altas',
		'BR2100436' => 'Alto Alegre do Maranhão',
		'BR2100477' => 'Alto Alegre do Pindaré',
		'BR2100600' => 'Amarante do Maranhão',
		'BR2100709' => 'Anajatuba',
		'BR2100907' => 'Araioses',
		'BR2100956' => 'Arame',
		'BR2101004' => 'Arari',
		'BR2101905' => 'Bequimão',
		'BR2102002' => 'Bom Jardim',
		'BR2102036' => 'Bom Jesus das Selvas',
		'BR2102101' => 'Brejo',
		'BR2102200' => 'Buriti',
		'BR2102309' => 'Buriti Bravo',
		'BR2102705' => 'Cantanhede',
		'BR2102804' => 'Carolina',
		'BR2102903' => 'Carutapera',
		'BR2103406' => 'Coelho Neto',
		'BR2103505' => 'Colinas',
		'BR2103703' => 'Cururupu',
		'BR2103802' => 'Dom Pedro',
		'BR2104057' => 'Estreito',
		'BR2104677' => 'Governador Nunes Freire',
		'BR2105005' => 'Humberto de Campos',
		'BR2105104' => 'Icatu',
		'BR2105427' => 'Itinga do Maranhão',
		'BR2105500' => 'João Lisboa',
		'BR2105708' => 'Lago da Pedra',
		'BR2106508' => 'Matinha',
		'BR2106607' => 'Matões',
		'BR2106706' => 'Mirador',
		'BR2106755' => 'Miranda do Norte',
		'BR2106904' => 'Monção',
		'BR2107704' => 'Paraibano',
		'BR2107803' => 'Parnarama',
		'BR2108108' => 'Paulo Ramos',
		'BR2108207' => 'Pedreiras',
		'BR2108256' => 'Pedro do Rosário',
		'BR2108306' => 'Penalva',
		'BR2108454' => 'Peritoró',
		'BR2108504' => 'Pindaré-Mirim',
		'BR2108702' => 'Pio XII',
		'BR2109007' => 'Porto Franco',
		'BR2109106' => 'Presidente Dutra',
		'BR2109452' => 'Raposa',
		'BR2109502' => 'Riachão',
		'BR2109601' => 'Rosário',
		'BR2109809' => 'Santa Helena',
		'BR2110039' => 'Santa Luzia do Paruá',
		'BR2110104' => 'Santa Quitéria do Maranhão',
		'BR2110203' => 'Santa Rita',
		'BR2110500' => 'São Bento',
		'BR2110609' => 'São Bernardo',
		'BR2110708' => 'São Domingos do Maranhão',
		'BR2111102' => 'São João dos Patos',
		'BR2111409' => 'São Luís Gonzaga do Maranhão',
		'BR2111508' => 'São Mateus do Maranhão',
		'BR2111706' => 'São Vicente Ferrer',
		'BR2112100' => 'Timbiras',
		'BR2112308' => 'Tuntum',
		'BR2112407' => 'Turiaçu',
		'BR2112456' => 'Turilândia',
		'BR2112605' => 'Urbano Santos',
		'BR2112704' => 'Vargem Grande',
		'BR2112803' => 'Viana',
		'BR2112902' => 'Vitória do Mearim',
		'BR2113009' => 'Vitorino Freire',
		'BR2101400' => 'Balsas',
		'BR2101608' => 'Barra do Corda',
		'BR2101707' => 'Barreirinhas',
		'BR2102325' => 'Buriticupu',
		'BR2103208' => 'Chapadinha',
		'BR2103604' => 'Coroatá',
		'BR2104800' => 'Grajaú',
		'BR2105401' => 'Itapecuru Mirim',
		'BR2108603' => 'Pinheiro',
		'BR2109908' => 'Santa Inês',
		'BR2110005' => 'Santa Luzia',
		'BR2112506' => 'Tutóia',
		'BR2114007' => 'Zé Doca',
		'BR2100055' => 'Açailândia',
		'BR2101202' => 'Bacabal',
		'BR2103000' => 'Caxias',
		'BR2103307' => 'Codó',
		'BR2105302' => 'Imperatriz',
		'BR2107506' => 'Paço do Lumiar',
		'BR2111201' => 'São José de Ribamar',
		'BR2112209' => 'Timon',
		'BR2111300' => 'São Luís',
	],
	'MG' => [
		'BR3100401' => 'Acaiaca',
		'BR3100708' => 'Água Comprida',
		'BR3100807' => 'Aguanil',
		'BR3101300' => 'Alagoa',
		'BR3101409' => 'Albertina',
		'BR3102209' => 'Alvarenga',
		'BR3102407' => 'Alvorada de Minas',
		'BR3103108' => 'Antônio Prado de Minas',
		'BR3103207' => 'Araçaí',
		'BR3103306' => 'Aracitaba',
		'BR3103603' => 'Arantina',
		'BR3103801' => 'Arapuá',
		'BR3104403' => 'Argirita',
		'BR3104452' => 'Aricanduva',
		'BR3104809' => 'Augusto de Lima',
		'BR3105202' => 'Bandeira',
		'BR3106101' => 'Belmiro Braga',
		'BR3106655' => 'Berizal',
		'BR3106606' => 'Bertópolis',
		'BR3106804' => 'Bias Fortes',
		'BR3107000' => 'Biquinhas',
		'BR3107604' => 'Bom Jesus da Penha',
		'BR3108701' => 'Brás Pires',
		'BR3109253' => 'Bugre',
		'BR3109600' => 'Cachoeira da Prata',
		'BR3109808' => 'Cachoeira Dourada',
		'BR3110103' => 'Caiana',
		'BR3110202' => 'Cajuri',
		'BR3110400' => 'Camacho',
		'BR3110806' => 'Campanário',
		'BR3111150' => 'Campo Azul',
		'BR3111705' => 'Canaã',
		'BR3112059' => 'Cantagalo',
		'BR3112208' => 'Capela Nova',
		'BR3112653' => 'Capitão Andrade',
		'BR3113107' => 'Caranaíba',
		'BR3113800' => 'Carmésia',
		'BR3114600' => 'Carrancas',
		'BR3114709' => 'Carvalhópolis',
		'BR3114808' => 'Carvalhos',
		'BR3114907' => 'Casa Grande',
		'BR3115003' => 'Cascalho Rico',
		'BR3115359' => 'Catas Altas',
		'BR3115409' => 'Catas Altas da Noruega',
		'BR3115607' => 'Cedro do Abaeté',
		'BR3115904' => 'Chácara',
		'BR3116209' => 'Chiador',
		'BR3116407' => 'Claraval',
		'BR3116902' => 'Comendador Gomes',
		'BR3115201' => 'Conceição da Barra de Minas',
		'BR3117207' => 'Conceição das Pedras',
		'BR3117405' => 'Conceição de Ipanema',
		'BR3118106' => 'Congonhas do Norte',
		'BR3118502' => 'Consolação',
		'BR3119005' => 'Cordislândia',
		'BR3119609' => 'Coronel Pacheco',
		'BR3119708' => 'Coronel Xavier Chaves',
		'BR3119807' => 'Córrego Danta',
		'BR3119906' => 'Córrego do Bom Jesus',
		'BR3120003' => 'Córrego Novo',
		'BR3120102' => 'Couto de Magalhães de Minas',
		'BR3120607' => 'Crucilândia',
		'BR3120706' => 'Cruzeiro da Fortaleza',
		'BR3120839' => 'Cuparaque',
		'BR3121308' => 'Descoberto',
		'BR3121506' => 'Desterro do Melo',
		'BR3121704' => 'Diogo de Vasconcelos',
		'BR3121902' => 'Divinésia',
		'BR3122108' => 'Divino das Laranjeiras',
		'BR3122470' => 'Dom Bosco',
		'BR3122603' => 'Dom Joaquim',
		'BR3122801' => 'Dom Viçoso',
		'BR3123304' => 'Dores do Turvo',
		'BR3123403' => 'Doresópolis',
		'BR3123502' => 'Douradoquara',
		'BR3124401' => 'Espírito Santo do Dourado',
		'BR3124609' => 'Estrela Dalva',
		'BR3124708' => 'Estrela do Indaiá',
		'BR3125002' => 'Ewbank da Câmara',
		'BR3125200' => 'Fama',
		'BR3125309' => 'Faria Lemos',
		'BR3125804' => 'Fernandes Tourinho',
		'BR3126307' => 'Fortaleza de Minas',
		'BR3126406' => 'Fortuna de Minas',
		'BR3126604' => 'Francisco Dumont',
		'BR3126950' => 'Frei Lagonegro',
		'BR3127057' => 'Fronteira dos Vales',
		'BR3127206' => 'Funilândia',
		'BR3127354' => 'Glaucilândia',
		'BR3127370' => 'Goiabeira',
		'BR3127388' => 'Goianá',
		'BR3127404' => 'Gonçalves',
		'BR3127909' => 'Grupiara',
		'BR3128253' => 'Guaraciama',
		'BR3128501' => 'Guarará',
		'BR3129905' => 'Ibitiúra de Minas',
		'BR3130002' => 'Ibituruna',
		'BR3130804' => 'Ingaí',
		'BR3131406' => 'Ipiaçu',
		'BR3132008' => 'Itacambira',
		'BR3132602' => 'Itamarati de Minas',
		'BR3132800' => 'Itambé do Mato Dentro',
		'BR3134509' => 'Itutinga',
		'BR3135001' => 'Jaguaraçu',
		'BR3135308' => 'Japaraíba',
		'BR3135902' => 'Jesuânia',
		'BR3136405' => 'Joaquim Felício',
		'BR3136520' => 'José Gonçalves de Minas',
		'BR3136553' => 'José Raydan',
		'BR3136579' => 'Josenópolis',
		'BR3136801' => 'Juramento',
		'BR3137304' => 'Lagoa dos Patos',
		'BR3137908' => 'Lamim',
		'BR3138302' => 'Leandro Ferreira',
		'BR3138351' => 'Leme do Prado',
		'BR3139102' => 'Madre de Deus de Minas',
		'BR3140100' => 'Marilac',
		'BR3140209' => 'Maripá de Minas',
		'BR3140308' => 'Marliéria',
		'BR3140407' => 'Marmelópolis',
		'BR3140605' => 'Materlândia',
		'BR3171501' => 'Mathias Lobato',
		'BR3141207' => 'Matutina',
		'BR3141306' => 'Medeiros',
		'BR3141900' => 'Minduri',
		'BR3142254' => 'Miravânia',
		'BR3142304' => 'Moeda',
		'BR3142502' => 'Monjolos',
		'BR3143153' => 'Monte Formoso',
		'BR3143609' => 'Morro da Garça',
		'BR3143708' => 'Morro do Pilar',
		'BR3144201' => 'Nacip Raydan',
		'BR3144375' => 'Natalândia',
		'BR3144409' => 'Natércia',
		'BR3144672' => 'Nova Belém',
		'BR3144904' => 'Nova Módica',
		'BR3145372' => 'Novorizonte',
		'BR3145406' => 'Olaria',
		'BR3145505' => 'Olímpio Noronha',
		'BR3145703' => 'Oliveira Fortes',
		'BR3145802' => 'Onça de Pitangui',
		'BR3145851' => 'Oratórios',
		'BR3146404' => 'Paineiras',
		'BR3146602' => 'Paiva',
		'BR3147501' => 'Passabém',
		'BR3147808' => 'Passa-Vinte',
		'BR3148400' => 'Paulistas',
		'BR3148806' => 'Pedra do Anta',
		'BR3148905' => 'Pedra do Indaiá',
		'BR3149002' => 'Pedra Dourada',
		'BR3149200' => 'Pedrinópolis',
		'BR3149408' => 'Pedro Teixeira',
		'BR3149507' => 'Pequeri',
		'BR3149606' => 'Pequi',
		'BR3150000' => 'Pescador',
		'BR3150109' => 'Piau',
		'BR3150208' => 'Piedade de Ponte Nova',
		'BR3150307' => 'Piedade do Rio Grande',
		'BR3150406' => 'Piedade dos Gerais',
		'BR3150539' => 'Pingo-dÁgua',
		'BR3150703' => 'Pirajuba',
		'BR3152131' => 'Ponto Chique',
		'BR3153004' => 'Pratinha',
		'BR3153202' => 'Presidente Juscelino',
		'BR3153301' => 'Presidente Kubitschek',
		'BR3153707' => 'Quartel Geral',
		'BR3153806' => 'Queluzito',
		'BR3154408' => 'Ressaquinha',
		'BR3154705' => 'Ribeirão Vermelho',
		'BR3155009' => 'Rio Doce',
		'BR3156106' => 'Ritápolis',
		'BR3156205' => 'Rochedo de Minas',
		'BR3156403' => 'Romaria',
		'BR3156452' => 'Rosário da Limeira',
		'BR3157278' => 'Santa Bárbara do Monte Verde',
		'BR3157302' => 'Santa Bárbara do Tugúrio',
		'BR3157377' => 'Santa Cruz de Salinas',
		'BR3157401' => 'Santa Cruz do Escalvado',
		'BR3157500' => 'Santa Efigênia de Minas',
		'BR3157609' => 'Santa Fé de Minas',
		'BR3159407' => 'Santa Rita de Ibitipoca',
		'BR3159308' => 'Santa Rita de Jacutinga',
		'BR3159704' => 'Santa Rosa da Serra',
		'BR3158409' => 'Santana de Cataguases',
		'BR3158607' => 'Santana do Deserto',
		'BR3158706' => 'Santana do Garambéu',
		'BR3158805' => 'Santana do Jacaré',
		'BR3159001' => 'Santana do Riacho',
		'BR3159100' => 'Santana dos Montes',
		'BR3160009' => 'Santo Antônio do Aventureiro',
		'BR3160108' => 'Santo Antônio do Grama',
		'BR3160207' => 'Santo Antônio do Itambé',
		'BR3160504' => 'Santo Antônio do Rio Abaixo',
		'BR3160603' => 'Santo Hipólito',
		'BR3160801' => 'São Bento Abade',
		'BR3160900' => 'São Brás do Suaçuí',
		'BR3161056' => 'São Félix de Minas',
		'BR3161601' => 'São Geraldo da Piedade',
		'BR3161650' => 'São Geraldo do Baixio',
		'BR3125507' => 'São Gonçalo do Rio Preto',
		'BR3162252' => 'São João da Lagoa',
		'BR3162302' => 'São João da Mata',
		'BR3162658' => 'São João do Pacuí',
		'BR3163003' => 'São José da Safira',
		'BR3163102' => 'São José da Varginha',
		'BR3163201' => 'São José do Alegre',
		'BR3163300' => 'São José do Divino',
		'BR3163607' => 'São José do Mantimento',
		'BR3164407' => 'São Sebastião da Bela Vista',
		'BR3164431' => 'São Sebastião da Vargem Alegre',
		'BR3164803' => 'São Sebastião do Rio Preto',
		'BR3164902' => 'São Sebastião do Rio Verde',
		'BR3165560' => 'Sem-Peixe',
		'BR3165602' => 'Senador Cortes',
		'BR3165800' => 'Senador José Bento',
		'BR3165909' => 'Senador Modestino Gonçalves',
		'BR3166105' => 'Senhora do Porto',
		'BR3166402' => 'Seritinga',
		'BR3166501' => 'Serra Azul de Minas',
		'BR3166600' => 'Serra da Saudade',
		'BR3166956' => 'Serranópolis de Minas',
		'BR3167004' => 'Serranos',
		'BR3167301' => 'Silveirânia',
		'BR3167509' => 'Simão Pereira',
		'BR3167905' => 'Tabuleiro',
		'BR3168051' => 'Taparuba',
		'BR3168101' => 'Tapira',
		'BR3168200' => 'Tapiraí',
		'BR3168309' => 'Taquaraçu de Minas',
		'BR3169059' => 'Tocos do Moji',
		'BR3169802' => 'Turvolândia',
		'BR3170305' => 'Umburatiba',
		'BR3170438' => 'União de Minas',
		'BR3170479' => 'Uruana de Minas',
		'BR3170602' => 'Vargem Bonita',
		'BR3170651' => 'Vargem Grande do Rio Pardo',
		'BR3171105' => 'Veríssimo',
		'BR3171154' => 'Vermelho Novo',
		'BR3171402' => 'Vieiras',
		'BR3172202' => 'Wenceslau Braz',
		'BR3100104' => 'Abadia dos Dourados',
		'BR3101201' => 'Aiuruoca',
		'BR3101631' => 'Alfredo Vasconcelos',
		'BR3101805' => 'Alpercata',
		'BR3102050' => 'Alto Caparaó',
		'BR3153509' => 'Alto Jequitibá',
		'BR3102506' => 'Amparo do Serra',
		'BR3102852' => 'Angelândia',
		'BR3103009' => 'Antônio Dias',
		'BR3103702' => 'Araponga',
		'BR3103751' => 'Araporã',
		'BR3103900' => 'Araújos',
		'BR3104106' => 'Arceburgo',
		'BR3105004' => 'Baldim',
		'BR3105301' => 'Bandeira do Sul',
		'BR3105509' => 'Barão de Monte Alto',
		'BR3105707' => 'Barra Longa',
		'BR3106408' => 'Belo Vale',
		'BR3107208' => 'Bocaina de Minas',
		'BR3107505' => 'Bom Jardim de Minas',
		'BR3107703' => 'Bom Jesus do Amparo',
		'BR3108107' => 'Bonfim',
		'BR3108206' => 'Bonfinópolis de Minas',
		'BR3108255' => 'Bonito de Minas',
		'BR3108503' => 'Botumirim',
		'BR3108800' => 'Braúnas',
		'BR3109451' => 'Cabeceira Grande',
		'BR3102704' => 'Cachoeira de Pajeú',
		'BR3111408' => 'Campo Florido',
		'BR3111903' => 'Cana Verde',
		'BR3112109' => 'Caparaó',
		'BR3112406' => 'Capetinga',
		'BR3112505' => 'Capim Branco',
		'BR3112802' => 'Capitólio',
		'BR3112901' => 'Caputira',
		'BR3113503' => 'Carbonita',
		'BR3113602' => 'Careaçu',
		'BR3114550' => 'Carneirinho',
		'BR3115458' => 'Catuji',
		'BR3115474' => 'Catuti',
		'BR3115706' => 'Central de Minas',
		'BR3116001' => 'Chalé',
		'BR3116308' => 'Cipotânea',
		'BR3116506' => 'Claro dos Poções',
		'BR3116704' => 'Coimbra',
		'BR3116803' => 'Coluna',
		'BR3117009' => 'Comercinho',
		'BR3117108' => 'Conceição da Aparecida',
		'BR3117603' => 'Conceição do Pará',
		'BR3117836' => 'Cônego Marinho',
		'BR3117876' => 'Confins',
		'BR3118205' => 'Conquista',
		'BR3118700' => 'Coqueiral',
		'BR3118908' => 'Cordisburgo',
		'BR3119500' => 'Coronel Murta',
		'BR3119955' => 'Córrego Fundo',
		'BR3120151' => 'Crisólita',
		'BR3120300' => 'Cristália',
		'BR3120409' => 'Cristiano Otoni',
		'BR3120870' => 'Curral de Dentro',
		'BR3121001' => 'Datas',
		'BR3121100' => 'Delfim Moreira',
		'BR3121209' => 'Delfinópolis',
		'BR3121258' => 'Delta',
		'BR3121407' => 'Desterro de Entre Rios',
		'BR3121803' => 'Dionísio',
		'BR3122207' => 'Divinolândia de Minas',
		'BR3122355' => 'Divisa Alegre',
		'BR3122405' => 'Divisa Nova',
		'BR3122454' => 'Divisópolis',
		'BR3122504' => 'Dom Cavati',
		'BR3122702' => 'Dom Silvério',
		'BR3122900' => 'Dona Eusébia',
		'BR3123007' => 'Dores de Campos',
		'BR3123106' => 'Dores de Guanhães',
		'BR3123528' => 'Durandé',
		'BR3123809' => 'Engenheiro Navarro',
		'BR3123858' => 'Entre Folhas',
		'BR3124807' => 'Estrela do Sul',
		'BR3125408' => 'Felício dos Santos',
		'BR3125606' => 'Felisburgo',
		'BR3126000' => 'Florestal',
		'BR3126208' => 'Formoso',
		'BR3126752' => 'Franciscópolis',
		'BR3126802' => 'Frei Gaspar',
		'BR3126901' => 'Frei Inocêncio',
		'BR3127073' => 'Fruta de Leite',
		'BR3127305' => 'Galiléia',
		'BR3127339' => 'Gameleiras',
		'BR3127503' => 'Gonzaga',
		'BR3128402' => 'Guarani',
		'BR3128600' => 'Guarda-Mor',
		'BR3128808' => 'Guidoval',
		'BR3128907' => 'Guimarânia',
		'BR3129004' => 'Guiricema',
		'BR3129103' => 'Gurinhatã',
		'BR3129202' => 'Heliodora',
		'BR3129400' => 'Ibertioga',
		'BR3129608' => 'Ibiaí',
		'BR3129657' => 'Ibiracatu',
		'BR3130200' => 'Igaratinga',
		'BR3130309' => 'Iguatama',
		'BR3130408' => 'Ijaci',
		'BR3130556' => 'Imbé de Minas',
		'BR3130606' => 'Inconfidentes',
		'BR3130655' => 'Indaiabira',
		'BR3130705' => 'Indianópolis',
		'BR3131000' => 'Inhaúma',
		'BR3131109' => 'Inimutaba',
		'BR3131505' => 'Ipuiúna',
		'BR3131604' => 'Iraí de Minas',
		'BR3133600' => 'Itapeva',
		'BR3133709' => 'Itatiaiuçu',
		'BR3133907' => 'Itaverava',
		'BR3134103' => 'Itueta',
		'BR3134301' => 'Itumirim',
		'BR3134806' => 'Jacuí',
		'BR3135076' => 'Jampruca',
		'BR3135357' => 'Japonvar',
		'BR3135407' => 'Jeceaba',
		'BR3135456' => 'Jenipapo de Minas',
		'BR3135605' => 'Jequitaí',
		'BR3135704' => 'Jequitibá',
		'BR3136108' => 'Joanésia',
		'BR3136900' => 'Juruaia',
		'BR3136959' => 'Juvenília',
		'BR3137106' => 'Lagamar',
		'BR3137536' => 'Lagoa Grande',
		'BR3138005' => 'Laranjal',
		'BR3138104' => 'Lassance',
		'BR3138500' => 'Liberdade',
		'BR3138625' => 'Limeira do Oeste',
		'BR3138658' => 'Lontra',
		'BR3138674' => 'Luisburgo',
		'BR3138682' => 'Luislândia',
		'BR3138708' => 'Luminárias',
		'BR3138906' => 'Machacalis',
		'BR3139250' => 'Mamonas',
		'BR3139706' => 'Maravilhas',
		'BR3140530' => 'Martins Soares',
		'BR3140555' => 'Mata Verde',
		'BR3140852' => 'Matias Cardoso',
		'BR3141504' => 'Mendes Pimentel',
		'BR3141702' => 'Mesquita',
		'BR3142403' => 'Moema',
		'BR3142601' => 'Monsenhor Paulo',
		'BR3143450' => 'Montezuma',
		'BR3143500' => 'Morada Nova de Minas',
		'BR3143807' => 'Munhoz',
		'BR3144359' => 'Naque',
		'BR3144508' => 'Nazareno',
		'BR3144656' => 'Ninheira',
		'BR3145059' => 'Nova Porteirinha',
		'BR3136603' => 'Nova União',
		'BR3145455' => 'Olhos-dÁgua',
		'BR3145877' => 'Orizânia',
		'BR3146206' => 'Ouro Verde de Minas',
		'BR3146255' => 'Padre Carvalho',
		'BR3146552' => 'Pai Pedro',
		'BR3146503' => 'Pains',
		'BR3146701' => 'Palma',
		'BR3146750' => 'Palmópolis',
		'BR3147709' => 'Passa Tempo',
		'BR3147956' => 'Patis',
		'BR3148202' => 'Patrocínio do Muriaé',
		'BR3148301' => 'Paula Cândido',
		'BR3148509' => 'Pavão',
		'BR3148756' => 'Pedra Bonita',
		'BR3149705' => 'Perdigão',
		'BR3149952' => 'Periquito',
		'BR3150158' => 'Piedade de Caratinga',
		'BR3150505' => 'Pimenta',
		'BR3150570' => 'Pintópolis',
		'BR3150604' => 'Piracema',
		'BR3150901' => 'Piranguçu',
		'BR3151008' => 'Piranguinho',
		'BR3151909' => 'Pocrane',
		'BR3152600' => 'Pouso Alto',
		'BR3152709' => 'Prados',
		'BR3152907' => 'Pratápolis',
		'BR3153103' => 'Presidente Bernardes',
		'BR3153608' => 'Prudente de Morais',
		'BR3154150' => 'Reduto',
		'BR3154457' => 'Riachinho',
		'BR3154507' => 'Riacho dos Machados',
		'BR3154804' => 'Rio Acima',
		'BR3155108' => 'Rio do Prado',
		'BR3155207' => 'Rio Espera',
		'BR3155306' => 'Rio Manso',
		'BR3155405' => 'Rio Novo',
		'BR3155900' => 'Rio Preto',
		'BR3156304' => 'Rodeiro',
		'BR3156502' => 'Rubelita',
		'BR3156601' => 'Rubim',
		'BR3157104' => 'Salto da Divisa',
		'BR3157252' => 'Santa Bárbara do Leste',
		'BR3157336' => 'Santa Cruz de Minas',
		'BR3157658' => 'Santa Helena de Minas',
		'BR3158102' => 'Santa Maria do Salto',
		'BR3159209' => 'Santa Rita de Caldas',
		'BR3159357' => 'Santa Rita de Minas',
		'BR3159506' => 'Santa Rita do Itueto',
		'BR3158300' => 'Santana da Vargem',
		'BR3158508' => 'Santana de Pirapama',
		'BR3158904' => 'Santana do Manhuaçu',
		'BR3160454' => 'Santo Antônio do Retiro',
		'BR3160959' => 'São Domingos das Dores',
		'BR3161205' => 'São Francisco de Paula',
		'BR3161304' => 'São Francisco de Sales',
		'BR3161403' => 'São Francisco do Glória',
		'BR3161700' => 'São Gonçalo do Abaeté',
		'BR3161908' => 'São Gonçalo do Rio Abaixo',
		'BR3162203' => 'São João Batista do Glória',
		'BR3162575' => 'São João do Manteninha',
		'BR3162609' => 'São João do Oriente',
		'BR3162948' => 'São José da Barra',
		'BR3163409' => 'São José do Goiabal',
		'BR3163508' => 'São José do Jacuri',
		'BR3163805' => 'São Miguel do Anta',
		'BR3163904' => 'São Pedro da União',
		'BR3164100' => 'São Pedro do Suaçuí',
		'BR3164001' => 'São Pedro dos Ferros',
		'BR3164308' => 'São Roque de Minas',
		'BR3164472' => 'São Sebastião do Anta',
		'BR3164605' => 'São Sebastião do Oeste',
		'BR3165206' => 'São Thomé das Letras',
		'BR3165107' => 'São Tomás de Aquino',
		'BR3165305' => 'São Vicente de Minas',
		'BR3165404' => 'Sapucaí-Mirim',
		'BR3165503' => 'Sardoá',
		'BR3165578' => 'Senador Amaral',
		'BR3165701' => 'Senador Firmino',
		'BR3166006' => 'Senhora de Oliveira',
		'BR3166303' => 'Sericita',
		'BR3166709' => 'Serra dos Aimorés',
		'BR3166907' => 'Serrania',
		'BR3167400' => 'Silvianópolis',
		'BR3167707' => 'Sobrália',
		'BR3167806' => 'Soledade de Minas',
		'BR3168804' => 'Tiradentes',
		'BR3168903' => 'Tiros',
		'BR3169109' => 'Toledo',
		'BR3169208' => 'Tombos',
		'BR3169505' => 'Tumiritinga',
		'BR3170578' => 'Vargem Alegre',
		'BR3170750' => 'Varjão de Minas',
		'BR3171030' => 'Verdelândia',
		'BR3171071' => 'Veredinha',
		'BR3171709' => 'Virgínia',
		'BR3171907' => 'Virgolândia',
		'BR3172103' => 'Volta Grande',
		'BR3100302' => 'Abre Campo',
		'BR3100500' => 'Açucena',
		'BR3100609' => 'Água Boa',
		'BR3100906' => 'Águas Formosas',
		'BR3101003' => 'Águas Vermelhas',
		'BR3101904' => 'Alpinópolis',
		'BR3102001' => 'Alterosa',
		'BR3102100' => 'Alto Rio Doce',
		'BR3102308' => 'Alvinópolis',
		'BR3102803' => 'Andrelândia',
		'BR3102902' => 'Antônio Carlos',
		'BR3104304' => 'Areado',
		'BR3104502' => 'Arinos',
		'BR3104601' => 'Astolfo Dutra',
		'BR3104700' => 'Ataléia',
		'BR3104908' => 'Baependi',
		'BR3105905' => 'Barroso',
		'BR3106002' => 'Bela Vista de Minas',
		'BR3106507' => 'Berilo',
		'BR3106903' => 'Bicas',
		'BR3107802' => 'Bom Jesus do Galho',
		'BR3107901' => 'Bom Repouso',
		'BR3108008' => 'Bom Sucesso',
		'BR3108305' => 'Borda da Mata',
		'BR3108404' => 'Botelhos',
		'BR3108552' => 'Brasilândia de Minas',
		'BR3108909' => 'Brasópolis',
		'BR3109105' => 'Bueno Brandão',
		'BR3109204' => 'Buenópolis',
		'BR3109501' => 'Cabo Verde',
		'BR3109709' => 'Cachoeira de Minas',
		'BR3109907' => 'Caetanópolis',
		'BR3110301' => 'Caldas',
		'BR3110707' => 'Cambuquira',
		'BR3110905' => 'Campanha',
		'BR3111101' => 'Campina Verde',
		'BR3111309' => 'Campo do Meio',
		'BR3111507' => 'Campos Altos',
		'BR3111804' => 'Canápolis',
		'BR3112000' => 'Candeias',
		'BR3112604' => 'Capinópolis',
		'BR3112703' => 'Capitão Enéas',
		'BR3113909' => 'Carmo da Cachoeira',
		'BR3114006' => 'Carmo da Mata',
		'BR3114105' => 'Carmo de Minas',
		'BR3114501' => 'Carmópolis de Minas',
		'BR3115102' => 'Cássia',
		'BR3115805' => 'Centralina',
		'BR3116100' => 'Chapada do Norte',
		'BR3116159' => 'Chapada Gaúcha',
		'BR3117504' => 'Conceição do Mato Dentro',
		'BR3117702' => 'Conceição do Rio Verde',
		'BR3117801' => 'Conceição dos Ouros',
		'BR3117900' => 'Congonhal',
		'BR3119203' => 'Coroaci',
		'BR3120201' => 'Cristais',
		'BR3120508' => 'Cristina',
		'BR3120805' => 'Cruzília',
		'BR3122009' => 'Divino',
		'BR3123205' => 'Dores do Indaiá',
		'BR3123700' => 'Engenheiro Caldas',
		'BR3123908' => 'Entre Rios de Minas',
		'BR3124005' => 'Ervália',
		'BR3124500' => 'Estiva',
		'BR3124906' => 'Eugenópolis',
		'BR3125705' => 'Felixlândia',
		'BR3125903' => 'Ferros',
		'BR3125952' => 'Fervedouro',
		'BR3126505' => 'Francisco Badaró',
		'BR3127008' => 'Fronteira',
		'BR3127602' => 'Gouveia',
		'BR3127800' => 'Grão Mogol',
		'BR3128105' => 'Guapé',
		'BR3128204' => 'Guaraciaba',
		'BR3128303' => 'Guaranésia',
		'BR3129301' => 'Iapu',
		'BR3129707' => 'Ibiraci',
		'BR3130051' => 'Icaraí de Minas',
		'BR3130507' => 'Ilicínea',
		'BR3131158' => 'Ipaba',
		'BR3131208' => 'Ipanema',
		'BR3131802' => 'Itabirinha',
		'BR3132107' => 'Itacarambi',
		'BR3132206' => 'Itaguara',
		'BR3132305' => 'Itaipé',
		'BR3132909' => 'Itamogi',
		'BR3133006' => 'Itamonte',
		'BR3133105' => 'Itanhandu',
		'BR3133204' => 'Itanhomi',
		'BR3133402' => 'Itapagipe',
		'BR3133758' => 'Itaú de Minas',
		'BR3134004' => 'Itinga',
		'BR3134608' => 'Jaboticatubas',
		'BR3134707' => 'Jacinto',
		'BR3135506' => 'Jequeri',
		'BR3136009' => 'Joaíma',
		'BR3136504' => 'Jordânia',
		'BR3137007' => 'Ladainha',
		'BR3137403' => 'Lagoa Dourada',
		'BR3137502' => 'Lagoa Formosa',
		'BR3137700' => 'Lajinha',
		'BR3137809' => 'Lambari',
		'BR3138609' => 'Lima Duarte',
		'BR3138807' => 'Luz',
		'BR3139201' => 'Malacacheta',
		'BR3139300' => 'Manga',
		'BR3139805' => 'Mar de Espanha',
		'BR3139904' => 'Maria da Fé',
		'BR3140159' => 'Mário Campos',
		'BR3140506' => 'Martinho Campos',
		'BR3140803' => 'Matias Barbosa',
		'BR3140902' => 'Matipó',
		'BR3141009' => 'Mato Verde',
		'BR3141603' => 'Mercês',
		'BR3142007' => 'Mirabela',
		'BR3142106' => 'Miradouro',
		'BR3142205' => 'Miraí',
		'BR3142700' => 'Montalvânia',
		'BR3142809' => 'Monte Alegre de Minas',
		'BR3143005' => 'Monte Belo',
		'BR3144706' => 'Nova Era',
		'BR3145000' => 'Nova Ponte',
		'BR3145109' => 'Nova Resende',
		'BR3145356' => 'Novo Oriente de Minas',
		'BR3146305' => 'Padre Paraíso',
		'BR3146909' => 'Papagaios',
		'BR3147303' => 'Paraisópolis',
		'BR3147600' => 'Passa Quatro',
		'BR3148608' => 'Peçanha',
		'BR3149101' => 'Pedralva',
		'BR3149150' => 'Pedras de Maria da Cruz',
		'BR3149804' => 'Perdizes',
		'BR3150802' => 'Piranga',
		'BR3151107' => 'Pirapetinga',
		'BR3151305' => 'Piraúba',
		'BR3151602' => 'Planura',
		'BR3151701' => 'Poço Fundo',
		'BR3152170' => 'Ponto dos Volantes',
		'BR3152303' => 'Porto Firme',
		'BR3152402' => 'Poté',
		'BR3153400' => 'Presidente Olegário',
		'BR3153905' => 'Raposos',
		'BR3154101' => 'Recreio',
		'BR3154200' => 'Resende Costa',
		'BR3154309' => 'Resplendor',
		'BR3154903' => 'Rio Casca',
		'BR3155504' => 'Rio Paranaíba',
		'BR3155702' => 'Rio Piracicaba',
		'BR3155801' => 'Rio Pomba',
		'BR3156007' => 'Rio Vermelho',
		'BR3156809' => 'Sabinópolis',
		'BR3157708' => 'Santa Juliana',
		'BR3157906' => 'Santa Margarida',
		'BR3158003' => 'Santa Maria de Itabira',
		'BR3158201' => 'Santa Maria do Suaçuí',
		'BR3159803' => 'Santa Vitória',
		'BR3159902' => 'Santo Antônio do Amparo',
		'BR3160306' => 'Santo Antônio do Jacinto',
		'BR3161007' => 'São Domingos do Prata',
		'BR3161502' => 'São Geraldo',
		'BR3161809' => 'São Gonçalo do Pará',
		'BR3162450' => 'São João das Missões',
		'BR3162559' => 'São João do Manhuaçu',
		'BR3162807' => 'São João Evangelista',
		'BR3162955' => 'São José da Lapa',
		'BR3164209' => 'São Romão',
		'BR3164506' => 'São Sebastião do Maranhão',
		'BR3165008' => 'São Tiago',
		'BR3166204' => 'Senhora dos Remédios',
		'BR3166808' => 'Serra do Salitre',
		'BR3165552' => 'Setubinha',
		'BR3167608' => 'Simonésia',
		'BR3168408' => 'Tarumirim',
		'BR3168507' => 'Teixeiras',
		'BR3169000' => 'Tocantins',
		'BR3169703' => 'Turmalina',
		'BR3170008' => 'Ubaí',
		'BR3170057' => 'Ubaporanga',
		'BR3170503' => 'Urucânia',
		'BR3170529' => 'Urucuia',
		'BR3170909' => 'Varzelândia',
		'BR3171006' => 'Vazante',
		'BR3171600' => 'Virgem da Lapa',
		'BR3171808' => 'Virginópolis',
		'BR3100203' => 'Abaeté',
		'BR3101102' => 'Aimorés',
		'BR3101508' => 'Além Paraíba',
		'BR3101706' => 'Almenara',
		'BR3102605' => 'Andradas',
		'BR3103405' => 'Araçuaí',
		'BR3104205' => 'Arcos',
		'BR3105103' => 'Bambuí',
		'BR3105400' => 'Barão de Cocais',
		'BR3106309' => 'Belo Oriente',
		'BR3107109' => 'Boa Esperança',
		'BR3107307' => 'Bocaiúva',
		'BR3107406' => 'Bom Despacho',
		'BR3108602' => 'Brasília de Minas',
		'BR3109006' => 'Brumadinho',
		'BR3109303' => 'Buritis',
		'BR3109402' => 'Buritizeiro',
		'BR3110004' => 'Caeté',
		'BR3110509' => 'Camanducaia',
		'BR3110608' => 'Cambuí',
		'BR3111002' => 'Campestre',
		'BR3111606' => 'Campos Gerais',
		'BR3112307' => 'Capelinha',
		'BR3113008' => 'Caraí',
		'BR3113206' => 'Carandaí',
		'BR3113305' => 'Carangola',
		'BR3113701' => 'Carlos Chagas',
		'BR3114204' => 'Carmo do Cajuru',
		'BR3114303' => 'Carmo do Paranaíba',
		'BR3114402' => 'Carmo do Rio Claro',
		'BR3115508' => 'Caxambu',
		'BR3116605' => 'Cláudio',
		'BR3117306' => 'Conceição das Alagoas',
		'BR3118007' => 'Congonhas',
		'BR3118403' => 'Conselheiro Pena',
		'BR3118809' => 'Coração de Jesus',
		'BR3119104' => 'Corinto',
		'BR3119302' => 'Coromandel',
		'BR3121605' => 'Diamantina',
		'BR3123601' => 'Elói Mendes',
		'BR3124203' => 'Espera Feliz',
		'BR3124302' => 'Espinosa',
		'BR3125101' => 'Extrema',
		'BR3126703' => 'Francisco Sá',
		'BR3128006' => 'Guanhães',
		'BR3128709' => 'Guaxupé',
		'BR3129509' => 'Ibiá',
		'BR3130101' => 'Igarapé',
		'BR3130903' => 'Inhapim',
		'BR3131901' => 'Itabirito',
		'BR3132503' => 'Itamarandiba',
		'BR3132701' => 'Itambacuri',
		'BR3133303' => 'Itaobim',
		'BR3133501' => 'Itapecerica',
		'BR3134400' => 'Iturama',
		'BR3134905' => 'Jacutinga',
		'BR3135050' => 'Jaíba',
		'BR3135803' => 'Jequitinhonha',
		'BR3136306' => 'João Pinheiro',
		'BR3136652' => 'Juatuba',
		'BR3137205' => 'Lagoa da Prata',
		'BR3139003' => 'Machado',
		'BR3139508' => 'Manhumirim',
		'BR3139607' => 'Mantena',
		'BR3140704' => 'Mateus Leme',
		'BR3141108' => 'Matozinhos',
		'BR3141405' => 'Medina',
		'BR3141801' => 'Minas Novas',
		'BR3142908' => 'Monte Azul',
		'BR3143104' => 'Monte Carmelo',
		'BR3143203' => 'Monte Santo de Minas',
		'BR3143401' => 'Monte Sião',
		'BR3144003' => 'Mutum',
		'BR3144102' => 'Muzambinho',
		'BR3144300' => 'Nanuque',
		'BR3144607' => 'Nepomuceno',
		'BR3145307' => 'Novo Cruzeiro',
		'BR3145604' => 'Oliveira',
		'BR3145901' => 'Ouro Branco',
		'BR3146008' => 'Ouro Fino',
		'BR3147204' => 'Paraguaçu',
		'BR3147402' => 'Paraopeba',
		'BR3148707' => 'Pedra Azul',
		'BR3149903' => 'Perdões',
		'BR3151404' => 'Pitangui',
		'BR3151503' => 'Piumhi',
		'BR3152006' => 'Pompéu',
		'BR3152204' => 'Porteirinha',
		'BR3152808' => 'Prata',
		'BR3154002' => 'Raul Soares',
		'BR3155603' => 'Rio Pardo de Minas',
		'BR3156908' => 'Sacramento',
		'BR3157005' => 'Salinas',
		'BR3157203' => 'Santa Bárbara',
		'BR3159605' => 'Santa Rita do Sapucaí',
		'BR3158953' => 'Santana do Paraíso',
		'BR3160405' => 'Santo Antônio do Monte',
		'BR3160702' => 'Santos Dumont',
		'BR3162005' => 'São Gonçalo do Sapucaí',
		'BR3162104' => 'São Gotardo',
		'BR3162401' => 'São João da Ponte',
		'BR3162708' => 'São João do Paraíso',
		'BR3162906' => 'São João Nepomuceno',
		'BR3162922' => 'São Joaquim de Bicas',
		'BR3163706' => 'São Lourenço',
		'BR3165537' => 'Sarzedo',
		'BR3167103' => 'Serro',
		'BR3168002' => 'Taiobeiras',
		'BR3169356' => 'Três Marias',
		'BR3169604' => 'Tupaciguara',
		'BR3170800' => 'Várzea da Palma',
		'BR3172004' => 'Visconde do Rio Branco',
		'BR3101607' => 'Alfenas',
		'BR3104007' => 'Araxá',
		'BR3111200' => 'Campo Belo',
		'BR3113404' => 'Caratinga',
		'BR3115300' => 'Cataguases',
		'BR3120904' => 'Curvelo',
		'BR3124104' => 'Esmeraldas',
		'BR3126109' => 'Formiga',
		'BR3127107' => 'Frutal',
		'BR3132404' => 'Itajubá',
		'BR3133808' => 'Itaúna',
		'BR3134202' => 'Ituiutaba',
		'BR3135100' => 'Janaúba',
		'BR3135209' => 'Januária',
		'BR3136207' => 'João Monlevade',
		'BR3137601' => 'Lagoa Santa',
		'BR3138203' => 'Lavras',
		'BR3138401' => 'Leopoldina',
		'BR3139409' => 'Manhuaçu',
		'BR3140001' => 'Mariana',
		'BR3144805' => 'Nova Lima',
		'BR3145208' => 'Nova Serrana',
		'BR3146107' => 'Ouro Preto',
		'BR3147105' => 'Pará de Minas',
		'BR3147006' => 'Paracatu',
		'BR3148103' => 'Patrocínio',
		'BR3149309' => 'Pedro Leopoldo',
		'BR3151206' => 'Pirapora',
		'BR3152105' => 'Ponte Nova',
		'BR3161106' => 'São Francisco',
		'BR3162500' => 'São João del Rei',
		'BR3164704' => 'São Sebastião do Paraíso',
		'BR3168705' => 'Timóteo',
		'BR3169307' => 'Três Corações',
		'BR3169406' => 'Três Pontas',
		'BR3170404' => 'Unaí',
		'BR3171303' => 'Viçosa',
		'BR3103504' => 'Araguari',
		'BR3105608' => 'Barbacena',
		'BR3106705' => 'Betim',
		'BR3118304' => 'Conselheiro Lafaiete',
		'BR3119401' => 'Coronel Fabriciano',
		'BR3122306' => 'Divinópolis',
		'BR3127701' => 'Governador Valadares',
		'BR3129806' => 'Ibirité',
		'BR3131307' => 'Ipatinga',
		'BR3131703' => 'Itabira',
		'BR3143302' => 'Montes Claros',
		'BR3143906' => 'Muriaé',
		'BR3147907' => 'Passos',
		'BR3148004' => 'Patos de Minas',
		'BR3151800' => 'Poços de Caldas',
		'BR3152501' => 'Pouso Alegre',
		'BR3154606' => 'Ribeirão das Neves',
		'BR3156700' => 'Sabará',
		'BR3157807' => 'Santa Luzia',
		'BR3167202' => 'Sete Lagoas',
		'BR3168606' => 'Teófilo Otoni',
		'BR3169901' => 'Ubá',
		'BR3170107' => 'Uberaba',
		'BR3170701' => 'Varginha',
		'BR3171204' => 'Vespasiano',
		'BR3106200' => 'Belo Horizonte',
		'BR3118601' => 'Contagem',
		'BR3136702' => 'Juiz de Fora',
		'BR3170206' => 'Uberlândia',
	],
	'MS' => [
		'BR5000252' => 'Alcinópolis',
		'BR5003108' => 'Corguinho',
		'BR5003900' => 'Figueirão',
		'BR5005103' => 'Jateí',
		'BR5006259' => 'Novo Horizonte do Sul',
		'BR5007505' => 'Rochedo',
		'BR5007976' => 'Taquarussu',
		'BR5000807' => 'Anaurilândia',
		'BR5000856' => 'Angélica',
		'BR5000906' => 'Antônio João',
		'BR5001508' => 'Bandeirantes',
		'BR5002159' => 'Bodoquena',
		'BR5002803' => 'Caracol',
		'BR5003504' => 'Douradina',
		'BR5004007' => 'Glória de Dourados',
		'BR5004403' => 'Inocência',
		'BR5004809' => 'Japorã',
		'BR5004908' => 'Jaraguari',
		'BR5005152' => 'Juti',
		'BR5005251' => 'Laguna Carapã',
		'BR5006408' => 'Pedro Gomes',
		'BR5007307' => 'Rio Negro',
		'BR5007554' => 'Santa Rita do Pardo',
		'BR5007802' => 'Selvíria',
		'BR5008404' => 'Vicentina',
		'BR5000203' => 'Água Clara',
		'BR5001243' => 'Aral Moreira',
		'BR5001904' => 'Bataguassu',
		'BR5002001' => 'Batayporã',
		'BR5002209' => 'Bonito',
		'BR5002308' => 'Brasilândia',
		'BR5002605' => 'Camapuã',
		'BR5002951' => 'Chapadão do Sul',
		'BR5003157' => 'Coronel Sapucaia',
		'BR5003256' => 'Costa Rica',
		'BR5003454' => 'Deodápolis',
		'BR5003488' => 'Dois Irmãos do Buriti',
		'BR5003751' => 'Eldorado',
		'BR5003801' => 'Fátima do Sul',
		'BR5004106' => 'Guia Lopes da Laguna',
		'BR5004304' => 'Iguatemi',
		'BR5004601' => 'Itaquiraí',
		'BR5005202' => 'Ladário',
		'BR5005681' => 'Mundo Novo',
		'BR5005806' => 'Nioaque',
		'BR5006002' => 'Nova Alvorada do Sul',
		'BR5006358' => 'Paranhos',
		'BR5006903' => 'Porto Murtinho',
		'BR5007406' => 'Rio Verde de Mato Grosso',
		'BR5007703' => 'Sete Quedas',
		'BR5007935' => 'Sonora',
		'BR5007950' => 'Tacuru',
		'BR5008008' => 'Terenos',
		'BR5000609' => 'Amambai',
		'BR5000708' => 'Anastácio',
		'BR5001003' => 'Aparecida do Taboado',
		'BR5001102' => 'Aquidauana',
		'BR5002100' => 'Bela Vista',
		'BR5002407' => 'Caarapó',
		'BR5002902' => 'Cassilândia',
		'BR5003306' => 'Coxim',
		'BR5004502' => 'Itaporã',
		'BR5004700' => 'Ivinhema',
		'BR5005004' => 'Jardim',
		'BR5005400' => 'Maracaju',
		'BR5005608' => 'Miranda',
		'BR5005707' => 'Naviraí',
		'BR5006200' => 'Nova Andradina',
		'BR5006309' => 'Paranaíba',
		'BR5007109' => 'Ribas do Rio Pardo',
		'BR5007208' => 'Rio Brilhante',
		'BR5007695' => 'São Gabriel do Oeste',
		'BR5007901' => 'Sidrolândia',
		'BR5006606' => 'Ponta Porã',
		'BR5003207' => 'Corumbá',
		'BR5003702' => 'Dourados',
		'BR5008305' => 'Três Lagoas',
		'BR5002704' => 'Campo Grande',
	],
	'MT' => [
		'BR5101001' => 'Araguaiana',
		'BR5101209' => 'Araguainha',
		'BR5102694' => 'Canabrava do Norte',
		'BR5103361' => 'Conquista DOeste',
		'BR5103437' => 'Curvelândia',
		'BR5103809' => 'Figueirópolis DOeste',
		'BR5103957' => 'Glória DOeste',
		'BR5104500' => 'Indiavaí',
		'BR5104559' => 'Itaúba',
		'BR5105309' => 'Luciara',
		'BR5106208' => 'Nova Brasilândia',
		'BR5108808' => 'Nova Guarita',
		'BR5108857' => 'Nova Marilândia',
		'BR5106174' => 'Nova Nazaré',
		'BR5106190' => 'Nova Santa Helena',
		'BR5106273' => 'Novo Horizonte do Norte',
		'BR5106315' => 'Novo Santo Antônio',
		'BR5106455' => 'Planalto da Serra',
		'BR5106703' => 'Ponte Branca',
		'BR5106851' => 'Porto Estrela',
		'BR5107156' => 'Reserva do Cabaçal',
		'BR5107198' => 'Ribeirãozinho',
		'BR5107578' => 'Rondolândia',
		'BR5107750' => 'Salto do Céu',
		'BR5107248' => 'Santa Carmem',
		'BR5107743' => 'Santa Cruz do Xingu',
		'BR5107768' => 'Santa Rita do Trivelato',
		'BR5107263' => 'Santo Afonso',
		'BR5107792' => 'Santo Antônio do Leste',
		'BR5107297' => 'São José do Povo',
		'BR5107404' => 'São Pedro da Cipa',
		'BR5107883' => 'Serra Nova Dourada',
		'BR5108105' => 'Tesouro',
		'BR5108204' => 'Torixoréu',
		'BR5108303' => 'União do Sul',
		'BR5108352' => 'Vale de São Domingos',
		'BR5100102' => 'Acorizal',
		'BR5100359' => 'Alto Boa Vista',
		'BR5100607' => 'Alto Taquari',
		'BR5100805' => 'Apiacás',
		'BR5101605' => 'Barão de Melgaço',
		'BR5101852' => 'Bom Jesus do Araguaia',
		'BR5102686' => 'Campos de Júlio',
		'BR5102850' => 'Castanheira',
		'BR5103106' => 'Cocalinho',
		'BR5103452' => 'Denise',
		'BR5103601' => 'Dom Aquino',
		'BR5103858' => 'Gaúcha do Norte',
		'BR5103908' => 'General Carneiro',
		'BR5104526' => 'Ipiranga do Norte',
		'BR5104542' => 'Itanhangá',
		'BR5104906' => 'Jangada',
		'BR5105234' => 'Lambari DOeste',
		'BR5106000' => 'Nortelândia',
		'BR5106182' => 'Nova Lacerda',
		'BR5108907' => 'Nova Maringá',
		'BR5108956' => 'Nova Monte Verde',
		'BR5106240' => 'Nova Ubiratã',
		'BR5106265' => 'Novo Mundo',
		'BR5106281' => 'Novo São Joaquim',
		'BR5106653' => 'Pontal do Araguaia',
		'BR5106802' => 'Porto dos Gaúchos',
		'BR5107180' => 'Ribeirão Cascalheira',
		'BR5107206' => 'Rio Branco',
		'BR5107776' => 'Santa Terezinha',
		'BR5107354' => 'São José do Xingu',
		'BR5107941' => 'Tabaporã',
		'BR5100300' => 'Alto Araguaia',
		'BR5100409' => 'Alto Garças',
		'BR5100508' => 'Alto Paraguai',
		'BR5101258' => 'Araputanga',
		'BR5101308' => 'Arenápolis',
		'BR5101407' => 'Aripuanã',
		'BR5101902' => 'Brasnorte',
		'BR5102603' => 'Campinápolis',
		'BR5102702' => 'Canarana',
		'BR5102793' => 'Carlinda',
		'BR5103007' => 'Chapada dos Guimarães',
		'BR5103056' => 'Cláudia',
		'BR5103304' => 'Comodoro',
		'BR5103379' => 'Cotriguaçu',
		'BR5103700' => 'Feliz Natal',
		'BR5104203' => 'Guiratinga',
		'BR5104609' => 'Itiquira',
		'BR5105002' => 'Jauru',
		'BR5105176' => 'Juruena',
		'BR5105200' => 'Juscimeira',
		'BR5105580' => 'Marcelândia',
		'BR5105606' => 'Matupá',
		'BR5105903' => 'Nobres',
		'BR5106109' => 'Nossa Senhora do Livramento',
		'BR5106158' => 'Nova Bandeirantes',
		'BR5106216' => 'Nova Canaã do Norte',
		'BR5106232' => 'Nova Olímpia',
		'BR5106257' => 'Nova Xavantina',
		'BR5106299' => 'Paranaíta',
		'BR5106307' => 'Paranatinga',
		'BR5106372' => 'Pedra Preta',
		'BR5106778' => 'Porto Alegre do Norte',
		'BR5106828' => 'Porto Esperidião',
		'BR5107008' => 'Poxoréo',
		'BR5107065' => 'Querência',
		'BR5107701' => 'Rosário Oeste',
		'BR5107800' => 'Santo Antônio do Leverger',
		'BR5107859' => 'São Félix do Araguaia',
		'BR5107305' => 'São José do Rio Claro',
		'BR5107107' => 'São José dos Quatro Marcos',
		'BR5107875' => 'Sapezal',
		'BR5108006' => 'Tapurah',
		'BR5108055' => 'Terra Nova do Norte',
		'BR5108501' => 'Vera',
		'BR5105507' => 'Vila Bela da Santíssima Trindade',
		'BR5100201' => 'Água Boa',
		'BR5100250' => 'Alta Floresta',
		'BR5101704' => 'Barra do Bugres',
		'BR5102637' => 'Campo Novo do Parecis',
		'BR5102678' => 'Campo Verde',
		'BR5103205' => 'Colíder',
		'BR5103254' => 'Colniza',
		'BR5103353' => 'Confresa',
		'BR5103502' => 'Diamantino',
		'BR5104104' => 'Guarantã do Norte',
		'BR5104807' => 'Jaciara',
		'BR5105101' => 'Juara',
		'BR5105150' => 'Juína',
		'BR5105259' => 'Lucas do Rio Verde',
		'BR5105622' => 'Mirassol dOeste',
		'BR5106224' => 'Nova Mutum',
		'BR5106422' => 'Peixoto de Azevedo',
		'BR5106505' => 'Poconé',
		'BR5106752' => 'Pontes e Lacerda',
		'BR5108600' => 'Vila Rica',
		'BR5101803' => 'Barra do Garças',
		'BR5102504' => 'Cáceres',
		'BR5107040' => 'Primavera do Leste',
		'BR5107925' => 'Sorriso',
		'BR5107958' => 'Tangará da Serra',
		'BR5107602' => 'Rondonópolis',
		'BR5107909' => 'Sinop',
		'BR5108402' => 'Várzea Grande',
		'BR5103403' => 'Cuiabá',
	],
	'PA' => [
		'BR1501253' => 'Bannach',
		'BR1500131' => 'Abel Figueiredo',
		'BR1501758' => 'Brejo Grande do Araguaia',
		'BR1503002' => 'Faro',
		'BR1504109' => 'Magalhães Barata',
		'BR1505494' => 'Palestina do Pará',
		'BR1505551' => 'Pau DArco',
		'BR1505601' => 'Peixe-Boi',
		'BR1506401' => 'Santa Cruz do Arari',
		'BR1506906' => 'Santarém Novo',
		'BR1507466' => 'São João da Ponta',
		'BR1507755' => 'Sapucaia',
		'BR1501006' => 'Aveiro',
		'BR1501451' => 'Belterra',
		'BR1501576' => 'Bom Jesus do Tocantins',
		'BR1501600' => 'Bonito',
		'BR1501725' => 'Brasil Novo',
		'BR1502608' => 'Colares',
		'BR1502764' => 'Cumaru do Norte',
		'BR1502772' => 'Curionópolis',
		'BR1502855' => 'Curuá',
		'BR1503044' => 'Floresta do Araguaia',
		'BR1503408' => 'Inhangapi',
		'BR1503754' => 'Jacareacanga',
		'BR1504976' => 'Nova Ipixuna',
		'BR1505007' => 'Nova Timboteua',
		'BR1505403' => 'Ourém',
		'BR1505635' => 'Piçarra',
		'BR1506104' => 'Primavera',
		'BR1506112' => 'Quatipuru',
		'BR1506161' => 'Rio Maria',
		'BR1506351' => 'Santa Bárbara do Pará',
		'BR1506559' => 'Santa Luzia do Pará',
		'BR1506583' => 'Santa Maria das Barreiras',
		'BR1507102' => 'São Caetano de Odivelas',
		'BR1507409' => 'São Francisco do Pará',
		'BR1507508' => 'São João do Araguaia',
		'BR1507805' => 'Senador José Porfírio',
		'BR1507961' => 'Terra Alta',
		'BR1507979' => 'Terra Santa',
		'BR1508050' => 'Trairão',
		'BR1508357' => 'Vitória do Xingu',
		'BR1500305' => 'Afuá',
		'BR1500347' => 'Água Azul do Norte',
		'BR1500503' => 'Almeirim',
		'BR1500701' => 'Anajás',
		'BR1500859' => 'Anapu',
		'BR1500909' => 'Augusto Corrêa',
		'BR1500958' => 'Aurora do Pará',
		'BR1501105' => 'Bagre',
		'BR1501204' => 'Baião',
		'BR1501907' => 'Bujaru',
		'BR1502004' => 'Cachoeira do Arari',
		'BR1501956' => 'Cachoeira do Piriá',
		'BR1502152' => 'Canaã dos Carajás',
		'BR1502509' => 'Chaves',
		'BR1502707' => 'Conceição do Araguaia',
		'BR1502756' => 'Concórdia do Pará',
		'BR1502806' => 'Curralinho',
		'BR1502905' => 'Curuçá',
		'BR1502954' => 'Eldorado dos Carajás',
		'BR1503077' => 'Garrafão do Norte',
		'BR1503093' => 'Goianésia do Pará',
		'BR1503101' => 'Gurupá',
		'BR1503200' => 'Igarapé-Açu',
		'BR1503507' => 'Irituia',
		'BR1503903' => 'Juruti',
		'BR1504000' => 'Limoeiro do Ajuru',
		'BR1504059' => 'Mãe do Rio',
		'BR1504307' => 'Maracanã',
		'BR1504406' => 'Marapanim',
		'BR1504455' => 'Medicilândia',
		'BR1504505' => 'Melgaço',
		'BR1504604' => 'Mocajuba',
		'BR1504901' => 'Muaná',
		'BR1504950' => 'Nova Esperança do Piriá',
		'BR1505031' => 'Novo Progresso',
		'BR1505106' => 'Óbidos',
		'BR1505205' => 'Oeiras do Pará',
		'BR1505437' => 'Ourilândia do Norte',
		'BR1505486' => 'Pacajá',
		'BR1505650' => 'Placas',
		'BR1505700' => 'Ponta de Pedras',
		'BR1505908' => 'Porto de Moz',
		'BR1506005' => 'Prainha',
		'BR1506187' => 'Rondon do Pará',
		'BR1506195' => 'Rurópolis',
		'BR1506203' => 'Salinópolis',
		'BR1506302' => 'Salvaterra',
		'BR1506609' => 'Santa Maria do Pará',
		'BR1507003' => 'Santo Antônio do Tauá',
		'BR1507151' => 'São Domingos do Araguaia',
		'BR1507201' => 'São Domingos do Capim',
		'BR1507458' => 'São Geraldo do Araguaia',
		'BR1507474' => 'São João de Pirabas',
		'BR1507706' => 'São Sebastião da Boa Vista',
		'BR1507904' => 'Soure',
		'BR1508035' => 'Tracuateua',
		'BR1508084' => 'Tucumã',
		'BR1508126' => 'Ulianópolis',
		'BR1508159' => 'Uruará',
		'BR1508209' => 'Vigia',
		'BR1508407' => 'Xinguara',
		'BR1500206' => 'Acará',
		'BR1500404' => 'Alenquer',
		'BR1500602' => 'Altamira',
		'BR1501303' => 'Barcarena',
		'BR1501501' => 'Benevides',
		'BR1501782' => 'Breu Branco',
		'BR1501808' => 'Breves',
		'BR1502202' => 'Capanema',
		'BR1502301' => 'Capitão Poço',
		'BR1502939' => 'Dom Eliseu',
		'BR1503309' => 'Igarapé-Miri',
		'BR1503457' => 'Ipixuna do Pará',
		'BR1503606' => 'Itaituba',
		'BR1503705' => 'Itupiranga',
		'BR1503804' => 'Jacundá',
		'BR1504703' => 'Moju',
		'BR1504802' => 'Monte Alegre',
		'BR1505064' => 'Novo Repartimento',
		'BR1505304' => 'Oriximiná',
		'BR1505502' => 'Paragominas',
		'BR1505809' => 'Portel',
		'BR1506138' => 'Redenção',
		'BR1506500' => 'Santa Isabel do Pará',
		'BR1506708' => 'Santana do Araguaia',
		'BR1507300' => 'São Félix do Xingu',
		'BR1507607' => 'São Miguel do Guamá',
		'BR1507953' => 'Tailândia',
		'BR1508001' => 'Tomé-Açu',
		'BR1508100' => 'Tucuruí',
		'BR1508308' => 'Viseu',
		'BR1500107' => 'Abaetetuba',
		'BR1500800' => 'Ananindeua',
		'BR1501709' => 'Bragança',
		'BR1502103' => 'Cametá',
		'BR1502400' => 'Castanhal',
		'BR1504208' => 'Marabá',
		'BR1504422' => 'Marituba',
		'BR1505536' => 'Parauapebas',
		'BR1506807' => 'Santarém',
		'BR1501402' => 'Belém',
	],
	'PB' => [
		'BR2500577' => 'Algodão de Jandaíra',
		'BR2500734' => 'Amparo',
		'BR2501153' => 'Areia de Baraúnas',
		'BR2501351' => 'Assunção',
		'BR2501534' => 'Baraúna',
		'BR2502052' => 'Bernardino Batista',
		'BR2502201' => 'Bom Jesus',
		'BR2503407' => 'Cacimba de Areia',
		'BR2503753' => 'Cajazeirinhas',
		'BR2504074' => 'Caraúbas',
		'BR2504108' => 'Carrapateira',
		'BR2504207' => 'Catingueira',
		'BR2504355' => 'Caturité',
		'BR2504702' => 'Congo',
		'BR2504850' => 'Coxixola',
		'BR2505303' => 'Curral Velho',
		'BR2505352' => 'Damião',
		'BR2505808' => 'Duas Estradas',
		'BR2505907' => 'Emas',
		'BR2506202' => 'Frei Martinho',
		'BR2506509' => 'Gurjão',
		'BR2508109' => 'Lagoa',
		'BR2508406' => 'Lastro',
		'BR2508554' => 'Logradouro',
		'BR2508703' => 'Mãe dÁgua',
		'BR2509339' => 'Matinhas',
		'BR2509370' => 'Mato Grosso',
		'BR2509503' => 'Montadas',
		'BR2509602' => 'Monte Horebe',
		'BR2510303' => 'Nova Palmeira',
		'BR2510501' => 'Olivedos',
		'BR2510600' => 'Ouro Velho',
		'BR2510659' => 'Parari',
		'BR2510709' => 'Passagem',
		'BR2511004' => 'Pedra Branca',
		'BR2512036' => 'Poço Dantas',
		'BR2512077' => 'Poço de José de Moura',
		'BR2512200' => 'Prata',
		'BR2512606' => 'Quixabá',
		'BR2512747' => 'Riachão',
		'BR2512754' => 'Riachão do Bacamarte',
		'BR2512762' => 'Riachão do Poço',
		'BR2512788' => 'Riacho de Santo Antônio',
		'BR2513000' => 'Salgadinho',
		'BR2513356' => 'Santa Inês',
		'BR2513802' => 'Santa Teresinha',
		'BR2513653' => 'Santarém',
		'BR2513851' => 'Santo André',
		'BR2513927' => 'São Bentinho',
		'BR2513968' => 'São Domingos',
		'BR2513943' => 'São Domingos do Cariri',
		'BR2513984' => 'São Francisco',
		'BR2514008' => 'São João do Cariri',
		'BR2514107' => 'São João do Tigre',
		'BR2514404' => 'São José de Espinharas',
		'BR2514552' => 'São José de Princesa',
		'BR2514602' => 'São José do Bonfim',
		'BR2514651' => 'São José do Brejo do Cruz',
		'BR2514701' => 'São José do Sabugi',
		'BR2514800' => 'São José dos Cordeiros',
		'BR2515203' => 'São Sebastião do Umbuzeiro',
		'BR2515609' => 'Serra da Raiz',
		'BR2515708' => 'Serra Grande',
		'BR2515930' => 'Sertãozinho',
		'BR2516151' => 'Sossêgo',
		'BR2516755' => 'Tenório',
		'BR2517100' => 'Várzea',
		'BR2505501' => 'Vista Serrana',
		'BR2517407' => 'Zabelê',
		'BR2500106' => 'Água Branca',
		'BR2500205' => 'Aguiar',
		'BR2500536' => 'Alcantil',
		'BR2500775' => 'Aparecida',
		'BR2501203' => 'Areial',
		'BR2501401' => 'Baía da Traição',
		'BR2501575' => 'Barra de Santana',
		'BR2501708' => 'Barra de São Miguel',
		'BR2502003' => 'Belém do Brejo do Cruz',
		'BR2502102' => 'Boa Ventura',
		'BR2502151' => 'Boa Vista',
		'BR2502300' => 'Bom Sucesso',
		'BR2502706' => 'Borborema',
		'BR2502904' => 'Brejo dos Santos',
		'BR2503100' => 'Cabaceiras',
		'BR2503308' => 'Cachoeira dos Índios',
		'BR2503555' => 'Cacimbas',
		'BR2503605' => 'Caiçara',
		'BR2503803' => 'Caldas Brandão',
		'BR2503902' => 'Camalaú',
		'BR2504033' => 'Capim',
		'BR2504157' => 'Casserengue',
		'BR2504504' => 'Condado',
		'BR2505006' => 'Cubati',
		'BR2505238' => 'Cuité de Mamanguape',
		'BR2505204' => 'Cuitegi',
		'BR2505279' => 'Curral de Cima',
		'BR2505402' => 'Desterro',
		'BR2505600' => 'Diamante',
		'BR2506251' => 'Gado Bravo',
		'BR2506608' => 'Ibiara',
		'BR2502607' => 'Igaracy',
		'BR2507408' => 'Jericó',
		'BR2507606' => 'Juarez Távora',
		'BR2507804' => 'Junco do Seridó',
		'BR2508000' => 'Juru',
		'BR2508208' => 'Lagoa de Dentro',
		'BR2508505' => 'Livramento',
		'BR2508802' => 'Malta',
		'BR2509057' => 'Marcação',
		'BR2509156' => 'Marizópolis',
		'BR2509305' => 'Mataraca',
		'BR2509396' => 'Maturéia',
		'BR2509800' => 'Mulungu',
		'BR2510006' => 'Nazarezinho',
		'BR2510204' => 'Nova Olinda',
		'BR2510402' => 'Olho dÁgua',
		'BR2511103' => 'Pedra Lavrada',
		'BR2512721' => 'Pedro Régis',
		'BR2511608' => 'Pilões',
		'BR2511707' => 'Pilõezinhos',
		'BR2512804' => 'Riacho dos Cavalos',
		'BR2513158' => 'Santa Cecília',
		'BR2513208' => 'Santa Cruz',
		'BR2513307' => 'Santa Helena',
		'BR2513505' => 'Santana de Mangueira',
		'BR2513604' => 'Santana dos Garrotes',
		'BR2514206' => 'São José da Lagoa Tapada',
		'BR2514305' => 'São José de Caiana',
		'BR2514453' => 'São José dos Ramos',
		'BR2514909' => 'São Mamede',
		'BR2515005' => 'São Miguel de Taipu',
		'BR2515807' => 'Serra Redonda',
		'BR2515906' => 'Serraria',
		'BR2515971' => 'Sobrado',
		'BR2516805' => 'Triunfo',
		'BR2517001' => 'Umbuzeiro',
		'BR2517209' => 'Vieirópolis',
		'BR2500403' => 'Alagoa Nova',
		'BR2500502' => 'Alagoinha',
		'BR2500601' => 'Alhandra',
		'BR2500809' => 'Araçagi',
		'BR2500908' => 'Arara',
		'BR2501005' => 'Araruna',
		'BR2501302' => 'Aroeiras',
		'BR2501609' => 'Barra de Santa Rosa',
		'BR2501906' => 'Belém',
		'BR2502409' => 'Bonito de Santa Fé',
		'BR2502508' => 'Boqueirão',
		'BR2502805' => 'Brejo do Cruz',
		'BR2503506' => 'Cacimba de Dentro',
		'BR2516409' => 'Campo de Santana',
		'BR2504405' => 'Conceição',
		'BR2504801' => 'Coremas',
		'BR2504900' => 'Cruz do Espírito Santo',
		'BR2505105' => 'Cuité',
		'BR2505709' => 'Dona Inês',
		'BR2506103' => 'Fagundes',
		'BR2506400' => 'Gurinhém',
		'BR2506707' => 'Imaculada',
		'BR2506806' => 'Ingá',
		'BR2507101' => 'Itapororoca',
		'BR2507200' => 'Itatuba',
		'BR2507309' => 'Jacaraú',
		'BR2507705' => 'Juazeirinho',
		'BR2507903' => 'Juripiranga',
		'BR2508604' => 'Lucena',
		'BR2509008' => 'Manaíra',
		'BR2509206' => 'Massaranduba',
		'BR2509404' => 'Mogeiro',
		'BR2509909' => 'Natuba',
		'BR2510105' => 'Nova Floresta',
		'BR2510907' => 'Paulista',
		'BR2511301' => 'Piancó',
		'BR2511400' => 'Picuí',
		'BR2511509' => 'Pilar',
		'BR2511806' => 'Pirpirituba',
		'BR2511905' => 'Pitimbu',
		'BR2512002' => 'Pocinhos',
		'BR2512408' => 'Puxinanã',
		'BR2512705' => 'Remígio',
		'BR2513109' => 'Salgado de São Félix',
		'BR2513406' => 'Santa Luzia',
		'BR2500700' => 'São João do Rio do Peixe',
		'BR2514503' => 'São José de Piranhas',
		'BR2515104' => 'São Sebastião de Lagoa de Roça',
		'BR2515401' => 'Seridó',
		'BR2515500' => 'Serra Branca',
		'BR2516102' => 'Soledade',
		'BR2516300' => 'Sumé',
		'BR2516508' => 'Taperoá',
		'BR2516607' => 'Tavares',
		'BR2516706' => 'Teixeira',
		'BR2516904' => 'Uiraúna',
		'BR2500304' => 'Alagoa Grande',
		'BR2501104' => 'Areia',
		'BR2501500' => 'Bananeiras',
		'BR2503001' => 'Caaporã',
		'BR2504306' => 'Catolé do Rocha',
		'BR2504603' => 'Conde',
		'BR2506004' => 'Esperança',
		'BR2506905' => 'Itabaiana',
		'BR2507002' => 'Itaporanga',
		'BR2508307' => 'Lagoa Seca',
		'BR2508901' => 'Mamanguape',
		'BR2509107' => 'Mari',
		'BR2509701' => 'Monteiro',
		'BR2511202' => 'Pedras de Fogo',
		'BR2512101' => 'Pombal',
		'BR2512309' => 'Princesa Isabel',
		'BR2512507' => 'Queimadas',
		'BR2512903' => 'Rio Tinto',
		'BR2513901' => 'São Bento',
		'BR2516003' => 'Solânea',
		'BR2501807' => 'Bayeux',
		'BR2503209' => 'Cabedelo',
		'BR2503704' => 'Cajazeiras',
		'BR2506301' => 'Guarabira',
		'BR2515302' => 'Sapé',
		'BR2516201' => 'Sousa',
		'BR2504009' => 'Campina Grande',
		'BR2510808' => 'Patos',
		'BR2513703' => 'Santa Rita',
		'BR2507507' => 'João Pessoa',
	],
	'PE' => [
		'BR2605459' => 'Fernando de Noronha',
		'BR2607109' => 'Ingazeira',
		'BR2607406' => 'Itacuruba',
		'BR2602407' => 'Brejão',
		'BR2602506' => 'Brejinho',
		'BR2603405' => 'Calumbi',
		'BR2603603' => 'Camutanga',
		'BR2606309' => 'Granito',
		'BR2606705' => 'Ibirajuba',
		'BR2610103' => 'Palmeirina',
		'BR2611533' => 'Quixaba',
		'BR2612109' => 'Salgadinho',
		'BR2614402' => 'Solidão',
		'BR2615102' => 'Terezinha',
		'BR2615201' => 'Terra Nova',
		'BR2615904' => 'Tuparetama',
		'BR2616100' => 'Verdejante',
		'BR2616183' => 'Vertente do Lério',
		'BR2600203' => 'Afrânio',
		'BR2600609' => 'Alagoinha',
		'BR2601003' => 'Angelim',
		'BR2601052' => 'Araçoiaba',
		'BR2601300' => 'Barra de Guabiraba',
		'BR2601508' => 'Belém de Maria',
		'BR2601805' => 'Betânia',
		'BR2602704' => 'Buenos Aires',
		'BR2603108' => 'Cachoeirinha',
		'BR2603306' => 'Calçado',
		'BR2603504' => 'Camocim de São Félix',
		'BR2603801' => 'Capoeiras',
		'BR2603900' => 'Carnaíba',
		'BR2603926' => 'Carnaubeira da Penha',
		'BR2604155' => 'Casinhas',
		'BR2604304' => 'Cedro',
		'BR2604403' => 'Chã de Alegria',
		'BR2604700' => 'Correntes',
		'BR2604809' => 'Cortês',
		'BR2604908' => 'Cumaru',
		'BR2605152' => 'Dormentes',
		'BR2605509' => 'Ferreiros',
		'BR2605806' => 'Frei Miguelinho',
		'BR2606507' => 'Iati',
		'BR2606903' => 'Iguaraci',
		'BR2607000' => 'Inajá',
		'BR2607703' => 'Itapetim',
		'BR2607802' => 'Itaquitinga',
		'BR2607950' => 'Jaqueira',
		'BR2608008' => 'Jataúba',
		'BR2608057' => 'Jatobá',
		'BR2608206' => 'Joaquim Nabuco',
		'BR2608255' => 'Jucati',
		'BR2608305' => 'Jupi',
		'BR2608404' => 'Jurema',
		'BR2608453' => 'Lagoa do Carro',
		'BR2608602' => 'Lagoa do Ouro',
		'BR2608701' => 'Lagoa dos Gatos',
		'BR2609105' => 'Machados',
		'BR2609154' => 'Manari',
		'BR2609204' => 'Maraial',
		'BR2609303' => 'Mirandiba',
		'BR2614303' => 'Moreilândia',
		'BR2609808' => 'Orocó',
		'BR2610301' => 'Paranatama',
		'BR2611200' => 'Poção',
		'BR2611408' => 'Primavera',
		'BR2611705' => 'Riacho das Almas',
		'BR2612000' => 'Sairé',
		'BR2612307' => 'Saloá',
		'BR2612455' => 'Santa Cruz',
		'BR2612471' => 'Santa Cruz da Baixa Verde',
		'BR2612554' => 'Santa Filomena',
		'BR2612703' => 'Santa Maria do Cambucá',
		'BR2612802' => 'Santa Terezinha',
		'BR2612901' => 'São Benedito do Sul',
		'BR2613404' => 'São José da Coroa Grande',
		'BR2613800' => 'São Vicente Ferrer',
		'BR2614006' => 'Serrita',
		'BR2614709' => 'Tacaimbó',
		'BR2615508' => 'Tracunhaém',
		'BR2615706' => 'Triunfo',
		'BR2616001' => 'Venturosa',
		'BR2616209' => 'Vertentes',
		'BR2616506' => 'Xexéu',
		'BR2600104' => 'Afogados da Ingazeira',
		'BR2600302' => 'Agrestina',
		'BR2600401' => 'Água Preta',
		'BR2600500' => 'Águas Belas',
		'BR2600708' => 'Aliança',
		'BR2600807' => 'Altinho',
		'BR2600906' => 'Amaraji',
		'BR2601409' => 'Barreiros',
		'BR2601607' => 'Belém de São Francisco',
		'BR2602001' => 'Bodocó',
		'BR2602100' => 'Bom Conselho',
		'BR2602209' => 'Bom Jardim',
		'BR2602308' => 'Bonito',
		'BR2602605' => 'Brejo da Madre de Deus',
		'BR2603009' => 'Cabrobó',
		'BR2603207' => 'Caetés',
		'BR2603702' => 'Canhotinho',
		'BR2604205' => 'Catende',
		'BR2604502' => 'Chã Grande',
		'BR2604601' => 'Condado',
		'BR2605004' => 'Cupira',
		'BR2605103' => 'Custódia',
		'BR2605301' => 'Exu',
		'BR2605400' => 'Feira Nova',
		'BR2605608' => 'Flores',
		'BR2605707' => 'Floresta',
		'BR2605905' => 'Gameleira',
		'BR2606101' => 'Glória do Goitá',
		'BR2606606' => 'Ibimirim',
		'BR2607604' => 'Ilha de Itamaracá',
		'BR2607307' => 'Ipubi',
		'BR2607505' => 'Itaíba',
		'BR2607653' => 'Itambé',
		'BR2607752' => 'Itapissuma',
		'BR2608107' => 'João Alfredo',
		'BR2608503' => 'Lagoa do Itaenga',
		'BR2608750' => 'Lagoa Grande',
		'BR2608800' => 'Lajedo',
		'BR2609006' => 'Macaparana',
		'BR2609501' => 'Nazaré da Mata',
		'BR2609709' => 'Orobó',
		'BR2610202' => 'Panelas',
		'BR2610400' => 'Parnamirim',
		'BR2610509' => 'Passira',
		'BR2610806' => 'Pedra',
		'BR2611002' => 'Petrolândia',
		'BR2611309' => 'Pombos',
		'BR2611507' => 'Quipapá',
		'BR2611804' => 'Ribeirão',
		'BR2611903' => 'Rio Formoso',
		'BR2612406' => 'Sanharó',
		'BR2612604' => 'Santa Maria da Boa Vista',
		'BR2613107' => 'São Caitano',
		'BR2613206' => 'São João',
		'BR2613305' => 'São Joaquim do Monte',
		'BR2613503' => 'São José do Belmonte',
		'BR2613602' => 'São José do Egito',
		'BR2614105' => 'Sertânia',
		'BR2614204' => 'Sirinhaém',
		'BR2614600' => 'Tabira',
		'BR2614808' => 'Tacaratu',
		'BR2614857' => 'Tamandaré',
		'BR2615003' => 'Taquaritinga do Norte',
		'BR2615409' => 'Toritama',
		'BR2615607' => 'Trindade',
		'BR2615805' => 'Tupanatinga',
		'BR2616308' => 'Vicência',
		'BR2600054' => 'Abreu e Lima',
		'BR2601102' => 'Araripina',
		'BR2601201' => 'Arcoverde',
		'BR2601706' => 'Belo Jardim',
		'BR2601904' => 'Bezerros',
		'BR2602803' => 'Buíque',
		'BR2604007' => 'Carpina',
		'BR2605202' => 'Escada',
		'BR2606200' => 'Goiana',
		'BR2606408' => 'Gravatá',
		'BR2607208' => 'Ipojuca',
		'BR2608909' => 'Limoeiro',
		'BR2609402' => 'Moreno',
		'BR2609907' => 'Ouricuri',
		'BR2610004' => 'Palmares',
		'BR2610608' => 'Paudalho',
		'BR2610905' => 'Pesqueira',
		'BR2612208' => 'Salgueiro',
		'BR2612505' => 'Santa Cruz do Capibaribe',
		'BR2613008' => 'São Bento do Una',
		'BR2613909' => 'Serra Talhada',
		'BR2614501' => 'Surubim',
		'BR2615300' => 'Timbaúba',
		'BR2602902' => 'Cabo de Santo Agostinho',
		'BR2603454' => 'Camaragibe',
		'BR2604106' => 'Caruaru',
		'BR2606002' => 'Garanhuns',
		'BR2606804' => 'Igarassu',
		'BR2609600' => 'Olinda',
		'BR2610707' => 'Paulista',
		'BR2611101' => 'Petrolina',
		'BR2613701' => 'São Lourenço da Mata',
		'BR2616407' => 'Vitória de Santo Antão',
		'BR2607901' => 'Jaboatão dos Guararapes',
		'BR2611606' => 'Recife',
	],
	'PI' => [
		'BR2200806' => 'Antônio Almeida',
		'BR2200954' => 'Aroeiras do Itaim',
		'BR2201002' => 'Arraial',
		'BR2201176' => 'Barra DAlcântara',
		'BR2201309' => 'Barreiras do Piauí',
		'BR2201556' => 'Bela Vista do Piauí',
		'BR2201572' => 'Belém do Piauí',
		'BR2201804' => 'Bocaina',
		'BR2201988' => 'Brejo do Piauí',
		'BR2202075' => 'Cajazeiras do Piauí',
		'BR2202117' => 'Campo Alegre do Fidalgo',
		'BR2202251' => 'Canavieira',
		'BR2202455' => 'Capitão Gervásio Oliveira',
		'BR2202554' => 'Caridade do Piauí',
		'BR2202711' => 'Cocal de Telha',
		'BR2202737' => 'Coivaras',
		'BR2202802' => 'Conceição do Canindé',
		'BR2202851' => 'Coronel José Dias',
		'BR2203230' => 'Currais',
		'BR2203271' => 'Curral Novo do Piauí',
		'BR2203255' => 'Curralinhos',
		'BR2203420' => 'Domingos Mourão',
		'BR2203602' => 'Eliseu Martins',
		'BR2203800' => 'Flores do Piauí',
		'BR2203859' => 'Floresta do Piauí',
		'BR2204105' => 'Francisco Ayres',
		'BR2204154' => 'Francisco Macedo',
		'BR2204550' => 'Guaribas',
		'BR2204600' => 'Hugo Napoleão',
		'BR2205250' => 'Jardim do Mulato',
		'BR2205276' => 'Jatobá do Piauí',
		'BR2205300' => 'Jerumenha',
		'BR2205359' => 'João Costa',
		'BR2205516' => 'Juazeiro do Piauí',
		'BR2205532' => 'Jurema',
		'BR2205565' => 'Lagoa do Barro do Piauí',
		'BR2205581' => 'Lagoa do Piauí',
		'BR2205599' => 'Lagoa do Sítio',
		'BR2205540' => 'Lagoinha do Piauí',
		'BR2206001' => 'Marcos Parente',
		'BR2206308' => 'Miguel Leão',
		'BR2206654' => 'Morro Cabeça no Tempo',
		'BR2206753' => 'Nossa Senhora de Nazaré',
		'BR2207959' => 'Nova Santa Rita',
		'BR2206951' => 'Novo Santo Antônio',
		'BR2207108' => 'Olho DÁgua do Piauí',
		'BR2207306' => 'Paes Landim',
		'BR2207355' => 'Pajeú do Piauí',
		'BR2207405' => 'Palmeira do Piauí',
		'BR2207553' => 'Paquetá',
		'BR2207751' => 'Passagem Franca do Piauí',
		'BR2207793' => 'Pau DArco do Piauí',
		'BR2207850' => 'Pavussu',
		'BR2207934' => 'Pedro Laurentino',
		'BR2208551' => 'Porto Alegre do Piauí',
		'BR2208601' => 'Prata do Piauí',
		'BR2208858' => 'Riacho Frio',
		'BR2208874' => 'Ribeira do Piauí',
		'BR2209153' => 'Santa Cruz dos Milagres',
		'BR2209351' => 'Santana do Piauí',
		'BR2209450' => 'Santo Antônio dos Milagres',
		'BR2209500' => 'Santo Inácio do Piauí',
		'BR2209559' => 'São Braz do Piauí',
		'BR2209609' => 'São Félix do Piauí',
		'BR2209757' => 'São Gonçalo do Gurguéia',
		'BR2209807' => 'São Gonçalo do Piauí',
		'BR2209856' => 'São João da Canabrava',
		'BR2209955' => 'São João da Varjota',
		'BR2210102' => 'São José do Peixe',
		'BR2210359' => 'São Lourenço do Piauí',
		'BR2210375' => 'São Luis do Piauí',
		'BR2210383' => 'São Miguel da Baixa Grande',
		'BR2210391' => 'São Miguel do Fidalgo',
		'BR2210623' => 'Sebastião Barros',
		'BR2210631' => 'Sebastião Leal',
		'BR2210904' => 'Socorro do Piauí',
		'BR2210953' => 'Tamboril do Piauí',
		'BR2210979' => 'Tanque do Piauí',
		'BR2211357' => 'Várzea Branca',
		'BR2211407' => 'Várzea Grande',
		'BR2211506' => 'Vera Mendes',
		'BR2211605' => 'Vila Nova do Piauí',
		'BR2211704' => 'Wall Ferraz',
		'BR2200053' => 'Acauã',
		'BR2200103' => 'Agricolândia',
		'BR2200251' => 'Alagoinha do Piauí',
		'BR2200277' => 'Alegrete do Piauí',
		'BR2200459' => 'Alvorada do Gurguéia',
		'BR2200608' => 'Angical do Piauí',
		'BR2200707' => 'Anísio de Abreu',
		'BR2200905' => 'Aroazes',
		'BR2201051' => 'Assunção do Piauí',
		'BR2201408' => 'Barro Duro',
		'BR2201606' => 'Beneditinos',
		'BR2201705' => 'Bertolínia',
		'BR2201739' => 'Betânia do Piauí',
		'BR2201770' => 'Boa Hora',
		'BR2201919' => 'Bom Princípio do Piauí',
		'BR2201929' => 'Bonfim do Piauí',
		'BR2201945' => 'Boqueirão do Piauí',
		'BR2201960' => 'Brasileira',
		'BR2202026' => 'Buriti dos Montes',
		'BR2202059' => 'Cabeceiras do Piauí',
		'BR2202083' => 'Cajueiro da Praia',
		'BR2202091' => 'Caldeirão Grande do Piauí',
		'BR2202109' => 'Campinas do Piauí',
		'BR2202133' => 'Campo Grande do Piauí',
		'BR2202174' => 'Campo Largo do Piauí',
		'BR2202539' => 'Caraúbas do Piauí',
		'BR2202653' => 'Caxingó',
		'BR2202729' => 'Cocal dos Alves',
		'BR2202752' => 'Colônia do Gurguéia',
		'BR2202778' => 'Colônia do Piauí',
		'BR2203008' => 'Cristalândia do Piauí',
		'BR2203107' => 'Cristino Castro',
		'BR2203354' => 'Dirceu Arcoverde',
		'BR2203404' => 'Dom Expedito Lopes',
		'BR2203453' => 'Dom Inocêncio',
		'BR2203750' => 'Fartura do Piauí',
		'BR2204006' => 'Francinópolis',
		'BR2204204' => 'Francisco Santos',
		'BR2204352' => 'Geminiano',
		'BR2204659' => 'Ilha Grande',
		'BR2204808' => 'Ipiranga do Piauí',
		'BR2204907' => 'Isaías Coelho',
		'BR2205151' => 'Jacobina do Piauí',
		'BR2205458' => 'Joca Marques',
		'BR2205524' => 'Júlio Borges',
		'BR2205557' => 'Lagoa Alegre',
		'BR2205573' => 'Lagoa de São Francisco',
		'BR2205607' => 'Landri Sales',
		'BR2205854' => 'Madeiro',
		'BR2205904' => 'Manoel Emídio',
		'BR2205953' => 'Marcolândia',
		'BR2206050' => 'Massapê do Piauí',
		'BR2206357' => 'Milton Brandão',
		'BR2206506' => 'Monsenhor Hipólito',
		'BR2206670' => 'Morro do Chapéu do Piauí',
		'BR2206696' => 'Murici dos Portelas',
		'BR2206704' => 'Nazaré do Piauí',
		'BR2206720' => 'Nazária',
		'BR2206803' => 'Nossa Senhora dos Remédios',
		'BR2206902' => 'Novo Oriente do Piauí',
		'BR2207207' => 'Padre Marcos',
		'BR2207777' => 'Patos do Piauí',
		'BR2208650' => 'Queimada Nova',
		'BR2208700' => 'Redenção do Gurguéia',
		'BR2208908' => 'Ribeiro Gonçalves',
		'BR2209005' => 'Rio Grande do Piauí',
		'BR2209104' => 'Santa Cruz do Piauí',
		'BR2209203' => 'Santa Filomena',
		'BR2209302' => 'Santa Luz',
		'BR2209377' => 'Santa Rosa do Piauí',
		'BR2209401' => 'Santo Antônio de Lisboa',
		'BR2209658' => 'São Francisco de Assis do Piauí',
		'BR2209708' => 'São Francisco do Piauí',
		'BR2209872' => 'São João da Fronteira',
		'BR2209906' => 'São João da Serra',
		'BR2209971' => 'São João do Arraial',
		'BR2210052' => 'São José do Divino',
		'BR2210201' => 'São José do Piauí',
		'BR2210300' => 'São Julião',
		'BR2210656' => 'Sigefredo Pacheco',
		'BR2210938' => 'Sussuapara',
		'BR2200202' => 'Água Branca',
		'BR2200301' => 'Alto Longá',
		'BR2200509' => 'Amarante',
		'BR2201101' => 'Avelino Lopes',
		'BR2201150' => 'Baixa Grande do Ribeiro',
		'BR2202000' => 'Buriti dos Lopes',
		'BR2202406' => 'Capitão de Campos',
		'BR2202505' => 'Caracol',
		'BR2202604' => 'Castelo do Piauí',
		'BR2203206' => 'Curimatá',
		'BR2203305' => 'Demerval Lobão',
		'BR2203503' => 'Elesbão Veloso',
		'BR2204303' => 'Fronteiras',
		'BR2204402' => 'Gilbués',
		'BR2204501' => 'Guadalupe',
		'BR2204709' => 'Inhuma',
		'BR2205003' => 'Itainópolis',
		'BR2205102' => 'Itaueira',
		'BR2205201' => 'Jaicós',
		'BR2205409' => 'Joaquim Pires',
		'BR2206100' => 'Matias Olímpio',
		'BR2206407' => 'Monsenhor Gil',
		'BR2206605' => 'Monte Alegre do Piauí',
		'BR2207504' => 'Palmeirais',
		'BR2207603' => 'Parnaguá',
		'BR2207801' => 'Paulistana',
		'BR2208106' => 'Pimenteiras',
		'BR2208205' => 'Pio IX',
		'BR2208502' => 'Porto',
		'BR2208809' => 'Regeneração',
		'BR2210003' => 'São João do Piauí',
		'BR2210409' => 'São Miguel do Tapuio',
		'BR2210508' => 'São Pedro do Piauí',
		'BR2210706' => 'Simões',
		'BR2210805' => 'Simplício Mendes',
		'BR2200400' => 'Altos',
		'BR2201200' => 'Barras',
		'BR2201507' => 'Batalha',
		'BR2201903' => 'Bom Jesus',
		'BR2202208' => 'Campo Maior',
		'BR2202307' => 'Canto do Buriti',
		'BR2202703' => 'Cocal',
		'BR2202901' => 'Corrente',
		'BR2203701' => 'Esperantina',
		'BR2205508' => 'José de Freitas',
		'BR2205706' => 'Luís Correia',
		'BR2205805' => 'Luzilândia',
		'BR2206209' => 'Miguel Alves',
		'BR2207009' => 'Oeiras',
		'BR2207900' => 'Pedro II',
		'BR2208304' => 'Piracuruca',
		'BR2210607' => 'São Raimundo Nonato',
		'BR2211100' => 'União',
		'BR2211209' => 'Uruçuí',
		'BR2211308' => 'Valença do Piauí',
		'BR2203909' => 'Floriano',
		'BR2208007' => 'Picos',
		'BR2208403' => 'Piripiri',
		'BR2207702' => 'Parnaíba',
		'BR2211001' => 'Teresina',
	],
	'PR' => [
		'BR4100459' => 'Altamira do Paraná',
		'BR4128625' => 'Alto Paraíso',
		'BR4101051' => 'Anahy',
		'BR4101150' => 'Ângulo',
		'BR4101655' => 'Arapuã',
		'BR4101853' => 'Ariranha do Ivaí',
		'BR4102208' => 'Atalaia',
		'BR4102703' => 'Barra do Jacaré',
		'BR4102752' => 'Bela Vista da Caroba',
		'BR4103008' => 'Boa Esperança',
		'BR4103024' => 'Boa Esperança do Iguaçu',
		'BR4103156' => 'Bom Jesus do Sul',
		'BR4103222' => 'Bom Sucesso do Sul',
		'BR4103370' => 'Brasilândia do Sul',
		'BR4103404' => 'Cafeara',
		'BR4103479' => 'Cafezal do Sul',
		'BR4103958' => 'Campina do Simão',
		'BR4104055' => 'Campo Bonito',
		'BR4106100' => 'Conselheiro Mairinck',
		'BR4106555' => 'Corumbataí do Sul',
		'BR4106571' => 'Cruzeiro do Iguaçu',
		'BR4106704' => 'Cruzeiro do Sul',
		'BR4106852' => 'Cruzmaltina',
		'BR4107124' => 'Diamante do Sul',
		'BR4107538' => 'Entre Rios do Oeste',
		'BR4107520' => 'Esperança Nova',
		'BR4107546' => 'Espigão Alto do Iguaçu',
		'BR4107553' => 'Farol',
		'BR4107702' => 'Fênix',
		'BR4107850' => 'Flor da Serra do Sul',
		'BR4108106' => 'Flórida',
		'BR4108551' => 'Godoy Moreira',
		'BR4109005' => 'Guapirama',
		'BR4109104' => 'Guaporema',
		'BR4110003' => 'Iguaraçu',
		'BR4110052' => 'Iguatu',
		'BR4110300' => 'Inajá',
		'BR4110409' => 'Indianópolis',
		'BR4110656' => 'Iracema do Oeste',
		'BR4110904' => 'Itaguajé',
		'BR4111308' => 'Itaúna do Sul',
		'BR4111605' => 'Ivatuba',
		'BR4111704' => 'Jaboti',
		'BR4112306' => 'Japira',
		'BR4112603' => 'Jardim Olinda',
		'BR4112900' => 'Jundiaí do Sul',
		'BR4113106' => 'Kaloré',
		'BR4113403' => 'Leópolis',
		'BR4113429' => 'Lidianópolis',
		'BR4113601' => 'Lobato',
		'BR4113809' => 'Lupionópolis',
		'BR4114351' => 'Manfrinópolis',
		'BR4115457' => 'Marquinho',
		'BR4115507' => 'Marumbi',
		'BR4115739' => 'Mato Rico',
		'BR4115903' => 'Mirador',
		'BR4116000' => 'Miraselva',
		'BR4116307' => 'Munhoz de Melo',
		'BR4116406' => 'Nossa Senhora das Graças',
		'BR4116505' => 'Nova Aliança do Ivaí',
		'BR4116604' => 'Nova América da Colina',
		'BR4117214' => 'Nova Santa Bárbara',
		'BR4117297' => 'Novo Itacolomi',
		'BR4117404' => 'Ourizona',
		'BR4118303' => 'Paranapoema',
		'BR4118451' => 'Pato Bragado',
		'BR4119251' => 'Pinhal de São Bento',
		'BR4119657' => 'Pitangueiras',
		'BR4119707' => 'Planaltina do Paraná',
		'BR4120101' => 'Porto Amazonas',
		'BR4120150' => 'Porto Barreiro',
		'BR4120200' => 'Porto Rico',
		'BR4120309' => 'Porto Vitória',
		'BR4120333' => 'Prado Ferreira',
		'BR4120408' => 'Presidente Castelo Branco',
		'BR4120655' => 'Quarto Centenário',
		'BR4120853' => 'Quatro Pontes',
		'BR4121257' => 'Ramilândia',
		'BR4121307' => 'Rancho Alegre',
		'BR4121356' => 'Rancho Alegre DOeste',
		'BR4122107' => 'Rio Bom',
		'BR4122172' => 'Rio Branco do Ivaí',
		'BR4122800' => 'Salgado Filho',
		'BR4123105' => 'Santa Amélia',
		'BR4123204' => 'Santa Cecília do Pavão',
		'BR4123600' => 'Santa Inês',
		'BR4123824' => 'Santa Lúcia',
		'BR4123956' => 'Santa Mônica',
		'BR4124202' => 'Santo Antônio do Caiuá',
		'BR4124301' => 'Santo Antônio do Paraíso',
		'BR4125456' => 'São José das Palmeiras',
		'BR4125555' => 'São Manoel do Paraná',
		'BR4125902' => 'São Pedro do Paraná',
		'BR4126355' => 'Serranópolis do Iguaçu',
		'BR4126652' => 'Sulina',
		'BR4126702' => 'Tamboara',
		'BR4128302' => 'Uniflor',
		'BR4128658' => 'Virmond',
		'BR4100103' => 'Abatiá',
		'BR4100202' => 'Adrianópolis',
		'BR4100301' => 'Agudos do Sul',
		'BR4100905' => 'Amaporã',
		'BR4101309' => 'Antônio Olinto',
		'BR4102604' => 'Barracão',
		'BR4103040' => 'Boa Ventura de São Roque',
		'BR4103057' => 'Boa Vista da Aparecida',
		'BR4103206' => 'Bom Sucesso',
		'BR4103305' => 'Borrazópolis',
		'BR4103354' => 'Braganey',
		'BR4103503' => 'Califórnia',
		'BR4103800' => 'Cambira',
		'BR4104105' => 'Campo do Tenente',
		'BR4106001' => 'Congonhinhas',
		'BR4106456' => 'Coronel Domingos Soares',
		'BR4107108' => 'Diamante do Norte',
		'BR4107157' => 'Diamante DOeste',
		'BR4107256' => 'Douradina',
		'BR4107306' => 'Doutor Camargo',
		'BR4128633' => 'Doutor Ulysses',
		'BR4107405' => 'Enéas Marques',
		'BR4107736' => 'Fernandes Pinheiro',
		'BR4107751' => 'Figueira',
		'BR4107801' => 'Floraí',
		'BR4107900' => 'Floresta',
		'BR4108205' => 'Formosa do Oeste',
		'BR4108452' => 'Foz do Jordão',
		'BR4108320' => 'Francisco Alves',
		'BR4108650' => 'Goioxim',
		'BR4108700' => 'Grandes Rios',
		'BR4108908' => 'Guairaçá',
		'BR4108957' => 'Guamiranga',
		'BR4109203' => 'Guaraci',
		'BR4109500' => 'Guaraqueçaba',
		'BR4109658' => 'Honório Serpa',
		'BR4109757' => 'Ibema',
		'BR4109906' => 'Icaraíma',
		'BR4110953' => 'Itaipulândia',
		'BR4111001' => 'Itambaracá',
		'BR4111100' => 'Itambé',
		'BR4111555' => 'Ivaté',
		'BR4112207' => 'Janiópolis',
		'BR4112405' => 'Japurá',
		'BR4112751' => 'Jesuítas',
		'BR4112959' => 'Juranda',
		'BR4113007' => 'Jussara',
		'BR4113254' => 'Laranjal',
		'BR4113452' => 'Lindoeste',
		'BR4113734' => 'Luiziana',
		'BR4113759' => 'Lunardelli',
		'BR4114708' => 'Maria Helena',
		'BR4114906' => 'Marilândia do Sul',
		'BR4115002' => 'Marilena',
		'BR4115309' => 'Mariópolis',
		'BR4115358' => 'Maripá',
		'BR4115754' => 'Mauá da Serra',
		'BR4115853' => 'Mercedes',
		'BR4116802' => 'Nova Cantu',
		'BR4116950' => 'Nova Esperança do Sudoeste',
		'BR4117008' => 'Nova Fátima',
		'BR4117206' => 'Nova Olímpia',
		'BR4117222' => 'Nova Santa Rosa',
		'BR4117271' => 'Nova Tebas',
		'BR4117453' => 'Ouro Verde do Oeste',
		'BR4118600' => 'Paula Freitas',
		'BR4118709' => 'Paulo Frontin',
		'BR4118857' => 'Perobal',
		'BR4119004' => 'Pérola dOeste',
		'BR4119202' => 'Pinhalão',
		'BR4120358' => 'Pranchita',
		'BR4120705' => 'Quatiguá',
		'BR4121109' => 'Quinta do Sol',
		'BR4121604' => 'Renascença',
		'BR4121752' => 'Reserva do Iguaçu',
		'BR4122602' => 'Rondon',
		'BR4122651' => 'Rosário do Ivaí',
		'BR4122701' => 'Sabáudia',
		'BR4122909' => 'Salto do Itararé',
		'BR4123303' => 'Santa Cruz de Monte Castelo',
		'BR4123709' => 'Santa Isabel do Ivaí',
		'BR4124004' => 'Santana do Itararé',
		'BR4124509' => 'Santo Inácio',
		'BR4124608' => 'São Carlos do Ivaí',
		'BR4124905' => 'São João do Caiuá',
		'BR4125308' => 'São Jorge do Ivaí',
		'BR4125357' => 'São Jorge do Patrocínio',
		'BR4125209' => 'São Jorge dOeste',
		'BR4125407' => 'São José da Boa Vista',
		'BR4125753' => 'São Pedro do Iguaçu',
		'BR4126009' => 'São Sebastião da Amoreira',
		'BR4126108' => 'São Tomé',
		'BR4126207' => 'Sapopema',
		'BR4126272' => 'Saudade do Iguaçu',
		'BR4126405' => 'Sertaneja',
		'BR4126900' => 'Tapira',
		'BR4127809' => 'Tomazina',
		'BR4127882' => 'Tunas do Paraná',
		'BR4127908' => 'Tuneiras do Oeste',
		'BR4127957' => 'Tupãssi',
		'BR4128534' => 'Ventania',
		'BR4128559' => 'Vera Cruz do Oeste',
		'BR4128609' => 'Verê',
		'BR4128708' => 'Vitorino',
		'BR4128807' => 'Xambrê',
		'BR4100608' => 'Alto Paraná',
		'BR4100707' => 'Alto Piquiri',
		'BR4100806' => 'Alvorada do Sul',
		'BR4101002' => 'Ampére',
		'BR4101200' => 'Antonina',
		'BR4101705' => 'Araruna',
		'BR4101903' => 'Assaí',
		'BR4102307' => 'Balsa Nova',
		'BR4102505' => 'Barbosa Ferraz',
		'BR4102802' => 'Bela Vista do Paraíso',
		'BR4102901' => 'Bituruna',
		'BR4103107' => 'Bocaiúva do Sul',
		'BR4103453' => 'Cafelândia',
		'BR4103909' => 'Campina da Lagoa',
		'BR4104402' => 'Cândido de Abreu',
		'BR4104428' => 'Candói',
		'BR4104451' => 'Cantagalo',
		'BR4104501' => 'Capanema',
		'BR4104600' => 'Capitão Leônidas Marques',
		'BR4104659' => 'Carambeí',
		'BR4104709' => 'Carlópolis',
		'BR4105003' => 'Catanduvas',
		'BR4105102' => 'Centenário do Sul',
		'BR4105201' => 'Cerro Azul',
		'BR4105300' => 'Céu Azul',
		'BR4105409' => 'Chopinzinho',
		'BR4105607' => 'Cidade Gaúcha',
		'BR4105706' => 'Clevelândia',
		'BR4106209' => 'Contenda',
		'BR4106308' => 'Corbélia',
		'BR4106803' => 'Cruz Machado',
		'BR4107009' => 'Curiúva',
		'BR4107504' => 'Engenheiro Beltrão',
		'BR4107603' => 'Faxinal',
		'BR4108007' => 'Florestópolis',
		'BR4108502' => 'General Carneiro',
		'BR4109302' => 'Guaraniaçu',
		'BR4110078' => 'Imbaú',
		'BR4110201' => 'Inácio Martins',
		'BR4110508' => 'Ipiranga',
		'BR4110607' => 'Iporã',
		'BR4110805' => 'Iretama',
		'BR4111209' => 'Itapejara dOeste',
		'BR4111407' => 'Ivaí',
		'BR4111902' => 'Jaguapitã',
		'BR4112504' => 'Jardim Alegre',
		'BR4112702' => 'Jataizinho',
		'BR4112801' => 'Joaquim Távora',
		'BR4113908' => 'Mallet',
		'BR4114005' => 'Mamborê',
		'BR4114104' => 'Mandaguaçu',
		'BR4114401' => 'Mangueirinha',
		'BR4114500' => 'Manoel Ribas',
		'BR4115101' => 'Mariluz',
		'BR4115408' => 'Marmeleiro',
		'BR4115606' => 'Matelândia',
		'BR4116059' => 'Missal',
		'BR4116109' => 'Moreira Sales',
		'BR4116208' => 'Morretes',
		'BR4116703' => 'Nova Aurora',
		'BR4117057' => 'Nova Laranjeiras',
		'BR4117107' => 'Nova Londrina',
		'BR4117255' => 'Nova Prata do Iguaçu',
		'BR4117800' => 'Palmital',
		'BR4118006' => 'Paraíso do Norte',
		'BR4118105' => 'Paranacity',
		'BR4118808' => 'Peabiru',
		'BR4118907' => 'Pérola',
		'BR4119103' => 'Piên',
		'BR4119806' => 'Planalto',
		'BR4120002' => 'Porecatu',
		'BR4120507' => 'Primeiro de Maio',
		'BR4120804' => 'Quatro Barras',
		'BR4121000' => 'Querência do Norte',
		'BR4121208' => 'Quitandinha',
		'BR4121406' => 'Realeza',
		'BR4121505' => 'Rebouças',
		'BR4121802' => 'Ribeirão Claro',
		'BR4121901' => 'Ribeirão do Pinhal',
		'BR4122008' => 'Rio Azul',
		'BR4122156' => 'Rio Bonito do Iguaçu',
		'BR4122503' => 'Roncador',
		'BR4123006' => 'Salto do Lontra',
		'BR4123402' => 'Santa Fé',
		'BR4123808' => 'Santa Izabel do Oeste',
		'BR4123857' => 'Santa Maria do Oeste',
		'BR4123907' => 'Santa Mariana',
		'BR4124020' => 'Santa Tereza do Oeste',
		'BR4124400' => 'Santo Antônio do Sudoeste',
		'BR4124707' => 'São Jerônimo da Serra',
		'BR4124806' => 'São João',
		'BR4125001' => 'São João do Ivaí',
		'BR4125100' => 'São João do Triunfo',
		'BR4125803' => 'São Pedro do Ivaí',
		'BR4126306' => 'Sengés',
		'BR4126504' => 'Sertanópolis',
		'BR4126603' => 'Siqueira Campos',
		'BR4126678' => 'Tamarana',
		'BR4126801' => 'Tapejara',
		'BR4127007' => 'Teixeira Soares',
		'BR4127205' => 'Terra Boa',
		'BR4127304' => 'Terra Rica',
		'BR4127403' => 'Terra Roxa',
		'BR4127502' => 'Tibagi',
		'BR4127601' => 'Tijucas do Sul',
		'BR4127858' => 'Três Barras do Paraná',
		'BR4127965' => 'Turvo',
		'BR4128401' => 'Uraí',
		'BR4128500' => 'Wenceslau Braz',
		'BR4100509' => 'Altônia',
		'BR4101101' => 'Andirá',
		'BR4101606' => 'Arapoti',
		'BR4102000' => 'Assis Chateaubriand',
		'BR4102109' => 'Astorga',
		'BR4102406' => 'Bandeirantes',
		'BR4103602' => 'Cambará',
		'BR4104006' => 'Campina Grande do Sul',
		'BR4104253' => 'Campo Magro',
		'BR4105904' => 'Colorado',
		'BR4106407' => 'Cornélio Procópio',
		'BR4106506' => 'Coronel Vivida',
		'BR4106605' => 'Cruzeiro do Oeste',
		'BR4107207' => 'Dois Vizinhos',
		'BR4108601' => 'Goioerê',
		'BR4108809' => 'Guaíra',
		'BR4109609' => 'Guaratuba',
		'BR4109708' => 'Ibaiti',
		'BR4109807' => 'Ibiporã',
		'BR4110102' => 'Imbituva',
		'BR4111258' => 'Itaperuçu',
		'BR4111506' => 'Ivaiporã',
		'BR4111803' => 'Jacarezinho',
		'BR4112009' => 'Jaguariaíva',
		'BR4112108' => 'Jandaia do Sul',
		'BR4113205' => 'Lapa',
		'BR4113304' => 'Laranjeiras do Sul',
		'BR4113502' => 'Loanda',
		'BR4114203' => 'Mandaguari',
		'BR4114302' => 'Mandirituba',
		'BR4114609' => 'Marechal Cândido Rondon',
		'BR4114807' => 'Marialva',
		'BR4115705' => 'Matinhos',
		'BR4115804' => 'Medianeira',
		'BR4116901' => 'Nova Esperança',
		'BR4117305' => 'Ortigueira',
		'BR4117503' => 'Paiçandu',
		'BR4117602' => 'Palmas',
		'BR4117701' => 'Palmeira',
		'BR4117909' => 'Palotina',
		'BR4119301' => 'Pinhão',
		'BR4119400' => 'Piraí do Sul',
		'BR4119608' => 'Pitanga',
		'BR4119954' => 'Pontal do Paraná',
		'BR4120606' => 'Prudentópolis',
		'BR4120903' => 'Quedas do Iguaçu',
		'BR4121703' => 'Reserva',
		'BR4122206' => 'Rio Branco do Sul',
		'BR4122305' => 'Rio Negro',
		'BR4123501' => 'Santa Helena',
		'BR4124053' => 'Santa Terezinha de Itaipu',
		'BR4124103' => 'Santo Antônio da Platina',
		'BR4125605' => 'São Mateus do Sul',
		'BR4125704' => 'São Miguel do Iguaçu',
		'BR4128005' => 'Ubiratã',
		'BR4103701' => 'Cambé',
		'BR4104303' => 'Campo Mourão',
		'BR4104907' => 'Castro',
		'BR4105508' => 'Cianorte',
		'BR4107652' => 'Fazenda Rio Grande',
		'BR4108403' => 'Francisco Beltrão',
		'BR4110706' => 'Irati',
		'BR4118402' => 'Paranavaí',
		'BR4118501' => 'Pato Branco',
		'BR4119509' => 'Piraquara',
		'BR4122404' => 'Rolândia',
		'BR4126256' => 'Sarandi',
		'BR4127106' => 'Telêmaco Borba',
		'BR4128203' => 'União da Vitória',
		'BR4100400' => 'Almirante Tamandaré',
		'BR4101408' => 'Apucarana',
		'BR4101507' => 'Arapongas',
		'BR4101804' => 'Araucária',
		'BR4104204' => 'Campo Largo',
		'BR4104808' => 'Cascavel',
		'BR4105805' => 'Colombo',
		'BR4108304' => 'Foz do Iguaçu',
		'BR4109401' => 'Guarapuava',
		'BR4115200' => 'Maringá',
		'BR4118204' => 'Paranaguá',
		'BR4119152' => 'Pinhais',
		'BR4119905' => 'Ponta Grossa',
		'BR4125506' => 'São José dos Pinhais',
		'BR4127700' => 'Toledo',
		'BR4128104' => 'Umuarama',
		'BR4106902' => 'Curitiba',
		'BR4113700' => 'Londrina',
	],
	'RJ' => [
		'BR3300951' => 'Comendador Levy Gasparian',
		'BR3302304' => 'Laje do Muriaé',
		'BR3302452' => 'Macuco',
		'BR3304508' => 'Rio das Flores',
		'BR3305133' => 'São José de Ubá',
		'BR3305307' => 'São Sebastião do Alto',
		'BR3306156' => 'Varre-Sai',
		'BR3300159' => 'Aperibé',
		'BR3300225' => 'Areal',
		'BR3300902' => 'Cambuci',
		'BR3301108' => 'Cantagalo',
		'BR3300936' => 'Carapebus',
		'BR3301157' => 'Cardoso Moreira',
		'BR3301207' => 'Carmo',
		'BR3301603' => 'Duas Barras',
		'BR3301801' => 'Engenheiro Paulo de Frontin',
		'BR3302056' => 'Italva',
		'BR3302809' => 'Mendes',
		'BR3303104' => 'Natividade',
		'BR3304102' => 'Porciúncula',
		'BR3304110' => 'Porto Real',
		'BR3304128' => 'Quatis',
		'BR3304409' => 'Rio Claro',
		'BR3304607' => 'Santa Maria Madalena',
		'BR3305406' => 'Sapucaia',
		'BR3305703' => 'Sumidouro',
		'BR3305901' => 'Trajano de Moraes',
		'BR3300233' => 'Armação dos Búzios',
		'BR3300258' => 'Arraial do Cabo',
		'BR3300506' => 'Bom Jardim',
		'BR3300605' => 'Bom Jesus do Itabapoana',
		'BR3301306' => 'Casimiro de Abreu',
		'BR3301405' => 'Conceição de Macabu',
		'BR3301504' => 'Cordeiro',
		'BR3301876' => 'Iguaba Grande',
		'BR3302106' => 'Itaocara',
		'BR3302254' => 'Itatiaia',
		'BR3302601' => 'Mangaratiba',
		'BR3302908' => 'Miguel Pereira',
		'BR3303005' => 'Miracema',
		'BR3303609' => 'Paracambi',
		'BR3303708' => 'Paraíba do Sul',
		'BR3303807' => 'Paraty',
		'BR3303856' => 'Paty do Alferes',
		'BR3303955' => 'Pinheiral',
		'BR3304003' => 'Piraí',
		'BR3304151' => 'Quissamã',
		'BR3304706' => 'Santo Antônio de Pádua',
		'BR3304805' => 'São Fidélis',
		'BR3304755' => 'São Francisco de Itabapoana',
		'BR3305000' => 'São João da Barra',
		'BR3305158' => 'São José do Vale do Rio Preto',
		'BR3305604' => 'Silva Jardim',
		'BR3305752' => 'Tanguá',
		'BR3306206' => 'Vassouras',
		'BR3300308' => 'Barra do Piraí',
		'BR3300803' => 'Cachoeiras de Macacu',
		'BR3301850' => 'Guapimirim',
		'BR3302205' => 'Itaperuna',
		'BR3302270' => 'Japeri',
		'BR3304300' => 'Rio Bonito',
		'BR3305208' => 'São Pedro da Aldeia',
		'BR3305505' => 'Saquarema',
		'BR3305554' => 'Seropédica',
		'BR3306008' => 'Três Rios',
		'BR3306107' => 'Valença',
		'BR3300100' => 'Angra dos Reis',
		'BR3300209' => 'Araruama',
		'BR3300407' => 'Barra Mansa',
		'BR3300456' => 'Belford Roxo',
		'BR3300704' => 'Cabo Frio',
		'BR3301009' => 'Campos dos Goytacazes',
		'BR3301900' => 'Itaboraí',
		'BR3302007' => 'Itaguaí',
		'BR3302403' => 'Macaé',
		'BR3302502' => 'Magé',
		'BR3302700' => 'Maricá',
		'BR3302858' => 'Mesquita',
		'BR3303203' => 'Nilópolis',
		'BR3303302' => 'Niterói',
		'BR3303401' => 'Nova Friburgo',
		'BR3303906' => 'Petrópolis',
		'BR3304144' => 'Queimados',
		'BR3304201' => 'Resende',
		'BR3304524' => 'Rio das Ostras',
		'BR3305109' => 'São João de Meriti',
		'BR3305802' => 'Teresópolis',
		'BR3306305' => 'Volta Redonda',
		'BR3301702' => 'Duque de Caxias',
		'BR3303500' => 'Nova Iguaçu',
		'BR3304557' => 'Rio de Janeiro',
		'BR3304904' => 'São Gonçalo',
	],
	'RN' => [
		'BR2400406' => 'Água Nova',
		'BR2400604' => 'Almino Afonso',
		'BR2401503' => 'Barcelona',
		'BR2401651' => 'Bodó',
		'BR2401909' => 'Caiçara do Rio do Vento',
		'BR2402907' => 'Coronel João Pessoa',
		'BR2403756' => 'Fernando Pedroza',
		'BR2403905' => 'Francisco Dantas',
		'BR2404002' => 'Frutuoso Gomes',
		'BR2404101' => 'Galinhos',
		'BR2404804' => 'Ipueira',
		'BR2405504' => 'Jardim de Angicos',
		'BR2405900' => 'João Dias',
		'BR2406155' => 'Jundiá',
		'BR2406403' => 'Lagoa de Velhos',
		'BR2406809' => 'Lajes Pintadas',
		'BR2406908' => 'Lucrécia',
		'BR2407252' => 'Major Sales',
		'BR2407609' => 'Messias Targino',
		'BR2407906' => 'Monte das Gameleiras',
		'BR2408409' => 'Olho-dÁgua do Borges',
		'BR2408508' => 'Ouro Branco',
		'BR2408607' => 'Paraná',
		'BR2408706' => 'Paraú',
		'BR2408805' => 'Parazinho',
		'BR2409209' => 'Passagem',
		'BR2409506' => 'Pedra Grande',
		'BR2409605' => 'Pedra Preta',
		'BR2410009' => 'Pilões',
		'BR2410504' => 'Rafael Fernandes',
		'BR2410603' => 'Rafael Godeiro',
		'BR2410702' => 'Riacho da Cruz',
		'BR2410801' => 'Riacho de Santana',
		'BR2411007' => 'Rodolfo Fernandes',
		'BR2411106' => 'Ruy Barbosa',
		'BR2409332' => 'Santa Maria',
		'BR2411429' => 'Santana do Seridó',
		'BR2411601' => 'São Bento do Norte',
		'BR2411700' => 'São Bento do Trairí',
		'BR2411809' => 'São Fernando',
		'BR2411908' => 'São Francisco do Oeste',
		'BR2412401' => 'São José do Seridó',
		'BR2413201' => 'Senador Georgino Avelino',
		'BR2413557' => 'Serrinha dos Pintos',
		'BR2413805' => 'Taboleiro Grande',
		'BR2411056' => 'Tibau',
		'BR2414308' => 'Timbaúba dos Batistas',
		'BR2414456' => 'Triunfo Potiguar',
		'BR2414753' => 'Venha-Ver',
		'BR2414902' => 'Viçosa',
		'BR2415008' => 'Vila Flor',
		'BR2400901' => 'Antônio Martins',
		'BR2401305' => 'Augusto Severo',
		'BR2401404' => 'Baía Formosa',
		'BR2401602' => 'Bento Fernandes',
		'BR2401701' => 'Bom Jesus',
		'BR2401859' => 'Caiçara do Norte',
		'BR2402402' => 'Carnaúba dos Dantas',
		'BR2402501' => 'Carnaubais',
		'BR2402808' => 'Coronel Ezequiel',
		'BR2403004' => 'Cruzeta',
		'BR2403202' => 'Doutor Severiano',
		'BR2403301' => 'Encanto',
		'BR2403400' => 'Equador',
		'BR2403707' => 'Felipe Guerra',
		'BR2403806' => 'Florânia',
		'BR2404408' => 'Grossos',
		'BR2404853' => 'Itajá',
		'BR2404903' => 'Itaú',
		'BR2405009' => 'Jaçanã',
		'BR2405108' => 'Jandaíra',
		'BR2405207' => 'Janduís',
		'BR2405306' => 'Januário Cicco',
		'BR2405405' => 'Japi',
		'BR2406007' => 'José da Penha',
		'BR2406205' => 'Lagoa dAnta',
		'BR2406304' => 'Lagoa de Pedras',
		'BR2406601' => 'Lagoa Salgada',
		'BR2407005' => 'Luís Gomes',
		'BR2407302' => 'Marcelino Vieira',
		'BR2407401' => 'Martins',
		'BR2409704' => 'Pedro Avelino',
		'BR2410207' => 'Portalegre',
		'BR2410256' => 'Porto do Mangue',
		'BR2410306' => 'Presidente Juscelino',
		'BR2410405' => 'Pureza',
		'BR2410900' => 'Riachuelo',
		'BR2412104' => 'São João do Sabugi',
		'BR2412559' => 'São Miguel do Gostoso',
		'BR2412708' => 'São Pedro',
		'BR2412807' => 'São Rafael',
		'BR2413003' => 'São Vicente',
		'BR2413102' => 'Senador Elói de Souza',
		'BR2413300' => 'Serra de São Bento',
		'BR2413409' => 'Serra Negra do Norte',
		'BR2413508' => 'Serrinha',
		'BR2413607' => 'Severiano Melo',
		'BR2413706' => 'Sítio Novo',
		'BR2414100' => 'Tenente Ananias',
		'BR2414159' => 'Tenente Laurentino Cruz',
		'BR2414704' => 'Várzea',
		'BR2400109' => 'Acari',
		'BR2400307' => 'Afonso Bezerra',
		'BR2400505' => 'Alexandria',
		'BR2400703' => 'Alto do Rodrigues',
		'BR2400802' => 'Angicos',
		'BR2401206' => 'Arês',
		'BR2401800' => 'Brejinho',
		'BR2402105' => 'Campo Redondo',
		'BR2402303' => 'Caraúbas',
		'BR2402709' => 'Cerro Corá',
		'BR2403509' => 'Espírito Santo',
		'BR2404309' => 'Governador Dix-Sept Rosado',
		'BR2404507' => 'Guamaré',
		'BR2404606' => 'Ielmo Marinho',
		'BR2404705' => 'Ipanguaçu',
		'BR2405603' => 'Jardim de Piranhas',
		'BR2405702' => 'Jardim do Seridó',
		'BR2406106' => 'Jucurutu',
		'BR2406502' => 'Lagoa Nova',
		'BR2406700' => 'Lajes',
		'BR2407500' => 'Maxaranguape',
		'BR2407708' => 'Montanhas',
		'BR2409100' => 'Passa e Fica',
		'BR2409308' => 'Patu',
		'BR2409803' => 'Pedro Velho',
		'BR2409902' => 'Pendências',
		'BR2410108' => 'Poço Branco',
		'BR2408953' => 'Rio do Fogo',
		'BR2411403' => 'Santana do Matos',
		'BR2412302' => 'São José do Campestre',
		'BR2412609' => 'São Paulo do Potengi',
		'BR2412906' => 'São Tomé',
		'BR2413359' => 'Serra do Mel',
		'BR2413904' => 'Taipu',
		'BR2414001' => 'Tangará',
		'BR2414209' => 'Tibau do Sul',
		'BR2414506' => 'Umarizal',
		'BR2414605' => 'Upanema',
		'BR2414803' => 'Vera Cruz',
		'BR2401008' => 'Apodi',
		'BR2401107' => 'Areia Branca',
		'BR2401453' => 'Baraúna',
		'BR2402204' => 'Canguaretama',
		'BR2403103' => 'Currais Novos',
		'BR2403608' => 'Extremoz',
		'BR2404200' => 'Goianinha',
		'BR2405801' => 'João Câmara',
		'BR2407203' => 'Macau',
		'BR2407807' => 'Monte Alegre',
		'BR2408201' => 'Nísia Floresta',
		'BR2408300' => 'Nova Cruz',
		'BR2408904' => 'Parelhas',
		'BR2409407' => 'Pau dos Ferros',
		'BR2411205' => 'Santa Cruz',
		'BR2411502' => 'Santo Antônio',
		'BR2412203' => 'São José de Mipibu',
		'BR2412500' => 'São Miguel',
		'BR2414407' => 'Touros',
		'BR2400208' => 'Açu',
		'BR2402006' => 'Caicó',
		'BR2402600' => 'Ceará-Mirim',
		'BR2407104' => 'Macaíba',
		'BR2412005' => 'São Gonçalo do Amarante',
		'BR2408003' => 'Mossoró',
		'BR2403251' => 'Parnamirim',
		'BR2408102' => 'Natal',
	],
	'RO' => [
		'BR1100908' => 'Castanheiras',
		'BR1101450' => 'Parecis',
		'BR1101468' => 'Pimenteiras do Oeste',
		'BR1101476' => 'Primavera de Rondônia',
		'BR1100262' => 'Rio Crespo',
		'BR1101559' => 'Teixeirópolis',
		'BR1100031' => 'Cabixi',
		'BR1100601' => 'Cacaulândia',
		'BR1100924' => 'Chupinguaia',
		'BR1100072' => 'Corumbiara',
		'BR1101104' => 'Itapuã do Oeste',
		'BR1101435' => 'Nova União',
		'BR1100296' => 'Santa Luzia DOeste',
		'BR1101484' => 'São Felipe DOeste',
		'BR1101757' => 'Vale do Anari',
		'BR1101807' => 'Vale do Paraíso',
		'BR1100379' => 'Alto Alegre dos Parecis',
		'BR1100403' => 'Alto Paraíso',
		'BR1100346' => 'Alvorada DOeste',
		'BR1100700' => 'Campo Novo de Rondônia',
		'BR1100809' => 'Candeias do Jamari',
		'BR1100056' => 'Cerejeiras',
		'BR1100064' => 'Colorado do Oeste',
		'BR1100080' => 'Costa Marques',
		'BR1100940' => 'Cujubim',
		'BR1101005' => 'Governador Jorge Teixeira',
		'BR1101203' => 'Ministro Andreazza',
		'BR1101302' => 'Mirante da Serra',
		'BR1101401' => 'Monte Negro',
		'BR1100148' => 'Nova Brasilândia DOeste',
		'BR1100502' => 'Novo Horizonte do Oeste',
		'BR1101492' => 'São Francisco do Guaporé',
		'BR1101500' => 'Seringueiras',
		'BR1101609' => 'Theobroma',
		'BR1101708' => 'Urupá',
		'BR1100015' => 'Alta Floresta DOeste',
		'BR1100452' => 'Buritis',
		'BR1100098' => 'Espigão DOeste',
		'BR1100106' => 'Guajará-Mirim',
		'BR1100130' => 'Machadinho DOeste',
		'BR1100338' => 'Nova Mamoré',
		'BR1100155' => 'Ouro Preto do Oeste',
		'BR1100189' => 'Pimenta Bueno',
		'BR1100254' => 'Presidente Médici',
		'BR1100320' => 'São Miguel do Guaporé',
		'BR1100023' => 'Ariquemes',
		'BR1100049' => 'Cacoal',
		'BR1100114' => 'Jaru',
		'BR1100288' => 'Rolim de Moura',
		'BR1100304' => 'Vilhena',
		'BR1100122' => 'Ji-Paraná',
		'BR1100205' => 'Porto Velho',
	],
	'RR' => [
		'BR1400027' => 'Amajari',
		'BR1400233' => 'Caroebe',
		'BR1400282' => 'Iracema',
		'BR1400407' => 'Normandia',
		'BR1400506' => 'São João da Baliza',
		'BR1400605' => 'São Luiz',
		'BR1400704' => 'Uiramutã',
		'BR1400050' => 'Alto Alegre',
		'BR1400159' => 'Bonfim',
		'BR1400175' => 'Cantá',
		'BR1400209' => 'Caracaraí',
		'BR1400308' => 'Mucajaí',
		'BR1400456' => 'Pacaraima',
		'BR1400472' => 'Rorainópolis',
		'BR1400100' => 'Boa Vista',
	],
	'RS' => [
		'BR4300034' => 'Aceguá',
		'BR4300059' => 'Água Santa',
		'BR4300455' => 'Alegria',
		'BR4300471' => 'Almirante Tamandaré do Sul',
		'BR4300554' => 'Alto Alegre',
		'BR4300570' => 'Alto Feliz',
		'BR4300661' => 'André da Rocha',
		'BR4300851' => 'Arambaré',
		'BR4300877' => 'Araricá',
		'BR4301073' => 'Arroio do Padre',
		'BR4301552' => 'Áurea',
		'BR4301859' => 'Barra do Guarita',
		'BR4301875' => 'Barra do Quaraí',
		'BR4301925' => 'Barra do Rio Azul',
		'BR4301958' => 'Barra Funda',
		'BR4302055' => 'Benjamin Constant do Sul',
		'BR4302154' => 'Boa Vista das Missões',
		'BR4302220' => 'Boa Vista do Cadeado',
		'BR4302238' => 'Boa Vista do Incra',
		'BR4302253' => 'Boa Vista do Sul',
		'BR4302378' => 'Bom Progresso',
		'BR4302584' => 'Bozano',
		'BR4302600' => 'Braga',
		'BR4302659' => 'Brochier',
		'BR4303202' => 'Cacique Doble',
		'BR4303301' => 'Caibaté',
		'BR4303558' => 'Camargo',
		'BR4303673' => 'Campestre da Serra',
		'BR4304101' => 'Campos Borges',
		'BR4304614' => 'Canudos do Vale',
		'BR4304622' => 'Capão Bonito do Sul',
		'BR4304655' => 'Capão do Cipó',
		'BR4304697' => 'Capitão',
		'BR4304671' => 'Capivari do Sul',
		'BR4304853' => 'Carlos Gomes',
		'BR4304952' => 'Caseiros',
		'BR4305116' => 'Centenário',
		'BR4305132' => 'Cerro Branco',
		'BR4305157' => 'Cerro Grande',
		'BR4305371' => 'Charrua',
		'BR4305405' => 'Chiapetta',
		'BR4305447' => 'Chuvisca',
		'BR4305504' => 'Ciríaco',
		'BR4305587' => 'Colinas',
		'BR4305603' => 'Colorado',
		'BR4305835' => 'Coqueiro Baixo',
		'BR4305850' => 'Coqueiros do Sul',
		'BR4305871' => 'Coronel Barros',
		'BR4305934' => 'Coronel Pilar',
		'BR4305959' => 'Cotiporã',
		'BR4305975' => 'Coxilha',
		'BR4306072' => 'Cristal do Sul',
		'BR4306130' => 'Cruzaltense',
		'BR4306304' => 'David Canabarro',
		'BR4306320' => 'Derrubadas',
		'BR4306353' => 'Dezesseis de Novembro',
		'BR4306379' => 'Dilermando de Aguiar',
		'BR4306429' => 'Dois Irmãos das Missões',
		'BR4306452' => 'Dois Lajeados',
		'BR4306551' => 'Dom Pedro de Alcântara',
		'BR4306700' => 'Dona Francisca',
		'BR4306759' => 'Doutor Ricardo',
		'BR4306924' => 'Engenho Velho',
		'BR4306957' => 'Entre Rios do Sul',
		'BR4306973' => 'Erebango',
		'BR4307054' => 'Ernestina',
		'BR4307401' => 'Esmeralda',
		'BR4307450' => 'Esperança do Sul',
		'BR4307815' => 'Estrela Velha',
		'BR4307831' => 'Eugênio de Castro',
		'BR4307864' => 'Fagundes Varela',
		'BR4308052' => 'Faxinalzinho',
		'BR4308078' => 'Fazenda Vilanova',
		'BR4308250' => 'Floriano Peixoto',
		'BR4308433' => 'Forquetinha',
		'BR4308458' => 'Fortaleza dos Valos',
		'BR4308656' => 'Garruchos',
		'BR4308854' => 'Gentil',
		'BR4309126' => 'Gramado dos Loureiros',
		'BR4309159' => 'Gramado Xavier',
		'BR4309258' => 'Guabiju',
		'BR4309555' => 'Harmonia',
		'BR4309571' => 'Herveiras',
		'BR4309704' => 'Humaitá',
		'BR4309753' => 'Ibarama',
		'BR4309803' => 'Ibiaçá',
		'BR4309951' => 'Ibirapuitã',
		'BR4310306' => 'Ilópolis',
		'BR4310363' => 'Imigrante',
		'BR4310413' => 'Inhacorá',
		'BR4310462' => 'Ipiranga do Sul',
		'BR4310553' => 'Itacurubi',
		'BR4310579' => 'Itapuca',
		'BR4310652' => 'Itati',
		'BR4310702' => 'Itatiba do Sul',
		'BR4310751' => 'Ivorá',
		'BR4310850' => 'Jaboticaba',
		'BR4310876' => 'Jacuizinho',
		'BR4310900' => 'Jacutinga',
		'BR4311122' => 'Jaquirana',
		'BR4311130' => 'Jari',
		'BR4311239' => 'Lagoa Bonita do Sul',
		'BR4311270' => 'Lagoa dos Três Cantos',
		'BR4311429' => 'Lajeado do Bugre',
		'BR4311643' => 'Linha Nova',
		'BR4311718' => 'Maçambará',
		'BR4311734' => 'Mampituba',
		'BR4311791' => 'Maratá',
		'BR4311981' => 'Mariana Pimentel',
		'BR4312005' => 'Mariano Moro',
		'BR4312054' => 'Marques de Souza',
		'BR4312138' => 'Mato Castelhano',
		'BR4312153' => 'Mato Leitão',
		'BR4312179' => 'Mato Queimado',
		'BR4312203' => 'Maximiliano de Almeida',
		'BR4312302' => 'Miraguaí',
		'BR4312351' => 'Montauri',
		'BR4312377' => 'Monte Alegre dos Campos',
		'BR4312385' => 'Monte Belo do Sul',
		'BR4312427' => 'Mormaço',
		'BR4312443' => 'Morrinhos do Sul',
		'BR4312609' => 'Muçum',
		'BR4312617' => 'Muitos Capões',
		'BR4312625' => 'Muliterno',
		'BR4312674' => 'Nicolau Vergueiro',
		'BR4312757' => 'Nova Alvorada',
		'BR4312807' => 'Nova Araçá',
		'BR4312955' => 'Nova Boa Vista',
		'BR4313003' => 'Nova Bréscia',
		'BR4313011' => 'Nova Candelária',
		'BR4313037' => 'Nova Esperança do Sul',
		'BR4313086' => 'Nova Pádua',
		'BR4313334' => 'Nova Ramada',
		'BR4313359' => 'Nova Roma do Sul',
		'BR4313490' => 'Novo Barreiro',
		'BR4313391' => 'Novo Cabrais',
		'BR4313425' => 'Novo Machado',
		'BR4313441' => 'Novo Tiradentes',
		'BR4313466' => 'Novo Xingu',
		'BR4313607' => 'Paim Filho',
		'BR4314035' => 'Pareci Novo',
		'BR4314134' => 'Paulo Bento',
		'BR4314175' => 'Pedras Altas',
		'BR4314308' => 'Pejuçara',
		'BR4314456' => 'Pinhal',
		'BR4314464' => 'Pinhal da Serra',
		'BR4314472' => 'Pinhal Grande',
		'BR4314498' => 'Pinheirinho do Vale',
		'BR4314555' => 'Pirapó',
		'BR4314753' => 'Poço das Antas',
		'BR4314779' => 'Pontão',
		'BR4314787' => 'Ponte Preta',
		'BR4315057' => 'Porto Mauá',
		'BR4315073' => 'Porto Vera Cruz',
		'BR4315131' => 'Pouso Novo',
		'BR4315149' => 'Presidente Lucena',
		'BR4315172' => 'Protásio Alves',
		'BR4315206' => 'Putinga',
		'BR4315313' => 'Quatro Irmãos',
		'BR4315321' => 'Quevedos',
		'BR4315354' => 'Quinze de Novembro',
		'BR4315453' => 'Relvado',
		'BR4315552' => 'Rio dos Índios',
		'BR4315750' => 'Riozinho',
		'BR4315958' => 'Rolador',
		'BR4316428' => 'Sagrada Família',
		'BR4316436' => 'Saldanha Marinho',
		'BR4316477' => 'Salvador das Missões',
		'BR4316733' => 'Santa Cecília do Sul',
		'BR4316972' => 'Santa Margarida do Sul',
		'BR4317251' => 'Santa Tereza',
		'BR4317558' => 'Santo Antônio do Palma',
		'BR4317756' => 'Santo Antônio do Planalto',
		'BR4317954' => 'Santo Expedito do Sul',
		'BR4318051' => 'São Domingos do Sul',
		'BR4318424' => 'São João da Urtiga',
		'BR4318432' => 'São João do Polêsine',
		'BR4318440' => 'São Jorge',
		'BR4318457' => 'São José das Missões',
		'BR4318465' => 'São José do Herval',
		'BR4318481' => 'São José do Hortêncio',
		'BR4318499' => 'São José do Inhacorá',
		'BR4318614' => 'São José do Sul',
		'BR4318622' => 'São José dos Ausentes',
		'BR4319125' => 'São Martinho da Serra',
		'BR4319356' => 'São Pedro da Serra',
		'BR4319364' => 'São Pedro das Missões',
		'BR4319372' => 'São Pedro do Butiá',
		'BR4319703' => 'São Valentim',
		'BR4319711' => 'São Valentim do Sul',
		'BR4319737' => 'São Valério do Sul',
		'BR4319752' => 'São Vendelino',
		'BR4320230' => 'Sede Nova',
		'BR4320305' => 'Selbach',
		'BR4320321' => 'Senador Salgado Filho',
		'BR4320453' => 'Sério',
		'BR4320578' => 'Sete de Setembro',
		'BR4320602' => 'Severiano de Almeida',
		'BR4320651' => 'Silveira Martins',
		'BR4320859' => 'Tabaí',
		'BR4321329' => 'Taquaruçu do Sul',
		'BR4321469' => 'Tio Hugo',
		'BR4321493' => 'Toropi',
		'BR4321626' => 'Travesseiro',
		'BR4321634' => 'Três Arroios',
		'BR4321832' => 'Três Forquilhas',
		'BR4321857' => 'Três Palmeiras',
		'BR4322152' => 'Tunas',
		'BR4322186' => 'Tupanci do Sul',
		'BR4322251' => 'Tupandi',
		'BR4322327' => 'Turuçu',
		'BR4322343' => 'Ubiretama',
		'BR4322350' => 'União da Serra',
		'BR4322376' => 'Unistalda',
		'BR4322525' => 'Vale Verde',
		'BR4322558' => 'Vanini',
		'BR4322855' => 'Vespasiano Correa',
		'BR4323200' => 'Victor Graeff',
		'BR4323309' => 'Vila Flores',
		'BR4323358' => 'Vila Lângaro',
		'BR4323408' => 'Vila Maria',
		'BR4323457' => 'Vila Nova do Sul',
		'BR4323507' => 'Vista Alegre',
		'BR4323606' => 'Vista Alegre do Prata',
		'BR4323705' => 'Vista Gaúcha',
		'BR4323754' => 'Vitória das Missões',
		'BR4323770' => 'Westfalia',
		'BR4300208' => 'Ajuricaba',
		'BR4300307' => 'Alecrim',
		'BR4300505' => 'Alpestre',
		'BR4300638' => 'Amaral Ferrador',
		'BR4300646' => 'Ametista do Sul',
		'BR4300703' => 'Anta Gorda',
		'BR4300901' => 'Aratiba',
		'BR4301057' => 'Arroio do Sal',
		'BR4301503' => 'Augusto Pestana',
		'BR4301651' => 'Barão',
		'BR4301701' => 'Barão de Cotegipe',
		'BR4301750' => 'Barão do Triunfo',
		'BR4301800' => 'Barracão',
		'BR4302204' => 'Boa Vista do Buricá',
		'BR4302451' => 'Boqueirão do Leão',
		'BR4302501' => 'Bossoroca',
		'BR4303400' => 'Caiçara',
		'BR4303608' => 'Cambará do Sul',
		'BR4303707' => 'Campina das Missões',
		'BR4303806' => 'Campinas do Sul',
		'BR4304002' => 'Campo Novo',
		'BR4304309' => 'Cândido Godói',
		'BR4304358' => 'Candiota',
		'BR4304713' => 'Caraá',
		'BR4304903' => 'Casca',
		'BR4305009' => 'Catuípe',
		'BR4305124' => 'Cerrito',
		'BR4305306' => 'Chapada',
		'BR4305439' => 'Chuí',
		'BR4305702' => 'Condor',
		'BR4305801' => 'Constantina',
		'BR4305900' => 'Coronel Bicaco',
		'BR4306056' => 'Cristal',
		'BR4306734' => 'Doutor Maurício Cardoso',
		'BR4306932' => 'Entre-Ijuís',
		'BR4307203' => 'Erval Grande',
		'BR4307302' => 'Erval Seco',
		'BR4307559' => 'Estação',
		'BR4308003' => 'Faxinal do Soturno',
		'BR4308409' => 'Formigueiro',
		'BR4308706' => 'Gaurama',
		'BR4308805' => 'General Câmara',
		'BR4309050' => 'Glorinha',
		'BR4309506' => 'Guarani das Missões',
		'BR4307104' => 'Herval',
		'BR4309654' => 'Hulha Negra',
		'BR4309902' => 'Ibiraiaras',
		'BR4310405' => 'Independência',
		'BR4310439' => 'Ipê',
		'BR4310504' => 'Iraí',
		'BR4310538' => 'Itaara',
		'BR4311155' => 'Jóia',
		'BR4311254' => 'Lagoão',
		'BR4311502' => 'Lavras do Sul',
		'BR4311601' => 'Liberato Salzano',
		'BR4311627' => 'Lindolfo Collor',
		'BR4311700' => 'Machadinho',
		'BR4311759' => 'Manoel Viana',
		'BR4311775' => 'Maquiné',
		'BR4311908' => 'Marcelino Ramos',
		'BR4312104' => 'Mata',
		'BR4312252' => 'Minas do Leão',
		'BR4312450' => 'Morro Redondo',
		'BR4312476' => 'Morro Reuter',
		'BR4312906' => 'Nova Bassano',
		'BR4313102' => 'Nova Palma',
		'BR4313805' => 'Palmitinho',
		'BR4313953' => 'Pantano Grande',
		'BR4314001' => 'Paraí',
		'BR4314027' => 'Paraíso do Sul',
		'BR4314068' => 'Passa Sete',
		'BR4314076' => 'Passo do Sobrado',
		'BR4314159' => 'Paverama',
		'BR4314209' => 'Pedro Osório',
		'BR4314423' => 'Picada Café',
		'BR4315008' => 'Porto Lucena',
		'BR4315156' => 'Progresso',
		'BR4315909' => 'Rodeio Bonito',
		'BR4316204' => 'Rondinha',
		'BR4316303' => 'Roque Gonzales',
		'BR4316501' => 'Salvador do Sul',
		'BR4316709' => 'Santa Bárbara do Sul',
		'BR4316758' => 'Santa Clara do Sul',
		'BR4316956' => 'Santa Maria do Herval',
		'BR4317004' => 'Santana da Boa Vista',
		'BR4318606' => 'São José do Ouro',
		'BR4319109' => 'São Martinho',
		'BR4319158' => 'São Miguel das Missões',
		'BR4319208' => 'São Nicolau',
		'BR4319307' => 'São Paulo das Missões',
		'BR4319802' => 'São Vicente do Sul',
		'BR4320263' => 'Segredo',
		'BR4320354' => 'Sentinela do Sul',
		'BR4320503' => 'Sertão',
		'BR4320552' => 'Sertão Santana',
		'BR4321352' => 'Tavares',
		'BR4321436' => 'Terra de Areia',
		'BR4321477' => 'Tiradentes do Sul',
		'BR4321956' => 'Trindade do Sul',
		'BR4322103' => 'Tucunduva',
		'BR4322301' => 'Tuparendi',
		'BR4322541' => 'Vale Real',
		'BR4322905' => 'Viadutos',
		'BR4323101' => 'Vicente Dutra',
		'BR4300109' => 'Agudo',
		'BR4300802' => 'Antônio Prado',
		'BR4301008' => 'Arroio do Meio',
		'BR4301206' => 'Arroio do Tigre',
		'BR4301107' => 'Arroio dos Ratos',
		'BR4301305' => 'Arroio Grande',
		'BR4301404' => 'Arvorezinha',
		'BR4301636' => 'Balneário Pinhal',
		'BR4301909' => 'Barra do Ribeiro',
		'BR4302006' => 'Barros Cassal',
		'BR4302303' => 'Bom Jesus',
		'BR4302352' => 'Bom Princípio',
		'BR4302402' => 'Bom Retiro do Sul',
		'BR4302907' => 'Cacequi',
		'BR4304689' => 'Capela de Santana',
		'BR4305173' => 'Cerro Grande do Sul',
		'BR4305207' => 'Cerro Largo',
		'BR4305454' => 'Cidreira',
		'BR4306007' => 'Crissiumal',
		'BR4306205' => 'Cruzeiro do Sul',
		'BR4306502' => 'Dom Feliciano',
		'BR4307500' => 'Espumoso',
		'BR4308102' => 'Feliz',
		'BR4308300' => 'Fontoura Xavier',
		'BR4308904' => 'Getúlio Vargas',
		'BR4309001' => 'Giruá',
		'BR4309605' => 'Horizontina',
		'BR4310009' => 'Ibirubá',
		'BR4310330' => 'Imbé',
		'BR4310801' => 'Ivoti',
		'BR4311106' => 'Jaguari',
		'BR4311205' => 'Júlio de Castilhos',
		'BR4312500' => 'Mostardas',
		'BR4312658' => 'Não-Me-Toque',
		'BR4312708' => 'Nonoai',
		'BR4313060' => 'Nova Hartz',
		'BR4313201' => 'Nova Petrópolis',
		'BR4313656' => 'Palmares do Sul',
		'BR4314506' => 'Pinheiro Machado',
		'BR4314605' => 'Piratini',
		'BR4314704' => 'Planalto',
		'BR4315107' => 'Porto Xavier',
		'BR4315404' => 'Redentora',
		'BR4315503' => 'Restinga Seca',
		'BR4315800' => 'Roca Sales',
		'BR4316006' => 'Rolante',
		'BR4316105' => 'Ronda Alta',
		'BR4316451' => 'Salto do Jacuí',
		'BR4316600' => 'Sananduva',
		'BR4317707' => 'Santo Antônio das Missões',
		'BR4317806' => 'Santo Augusto',
		'BR4317905' => 'Santo Cristo',
		'BR4318101' => 'São Francisco de Assis',
		'BR4319406' => 'São Pedro do Sul',
		'BR4320206' => 'Seberi',
		'BR4320404' => 'Serafina Corrêa',
		'BR4320677' => 'Sinimbu',
		'BR4320701' => 'Sobradinho',
		'BR4320909' => 'Tapejara',
		'BR4321006' => 'Tapera',
		'BR4321105' => 'Tapes',
		'BR4321402' => 'Tenente Portela',
		'BR4321667' => 'Três Cachoeiras',
		'BR4322533' => 'Vale do Sol',
		'BR4323804' => 'Xangri-lá',
		'BR4302709' => 'Butiá',
		'BR4302808' => 'Caçapava do Sul',
		'BR4304200' => 'Candelária',
		'BR4304408' => 'Canela',
		'BR4304630' => 'Capão da Canoa',
		'BR4304663' => 'Capão do Leão',
		'BR4304804' => 'Carlos Barbosa',
		'BR4305355' => 'Charqueadas',
		'BR4306403' => 'Dois Irmãos',
		'BR4306601' => 'Dom Pedrito',
		'BR4306767' => 'Eldorado do Sul',
		'BR4306809' => 'Encantado',
		'BR4306908' => 'Encruzilhada do Sul',
		'BR4307609' => 'Estância Velha',
		'BR4307807' => 'Estrela',
		'BR4308201' => 'Flores da Cunha',
		'BR4308508' => 'Frederico Westphalen',
		'BR4308607' => 'Garibaldi',
		'BR4309100' => 'Gramado',
		'BR4309407' => 'Guaporé',
		'BR4310108' => 'Igrejinha',
		'BR4310603' => 'Itaqui',
		'BR4311007' => 'Jaguarão',
		'BR4311304' => 'Lagoa Vermelha',
		'BR4311809' => 'Marau',
		'BR4313300' => 'Nova Prata',
		'BR4313375' => 'Nova Santa Rita',
		'BR4313508' => 'Osório',
		'BR4313706' => 'Palmeira das Missões',
		'BR4313904' => 'Panambi',
		'BR4314803' => 'Portão',
		'BR4315305' => 'Quaraí',
		'BR4315701' => 'Rio Pardo',
		'BR4316402' => 'Rosário do Sul',
		'BR4317301' => 'Santa Vitória do Palmar',
		'BR4317400' => 'Santiago',
		'BR4317608' => 'Santo Antônio da Patrulha',
		'BR4318200' => 'São Francisco de Paula',
		'BR4318408' => 'São Jerônimo',
		'BR4318507' => 'São José do Norte',
		'BR4318804' => 'São Lourenço do Sul',
		'BR4318903' => 'São Luiz Gonzaga',
		'BR4319000' => 'São Marcos',
		'BR4319505' => 'São Sebastião do Caí',
		'BR4319604' => 'São Sepé',
		'BR4320107' => 'Sarandi',
		'BR4320800' => 'Soledade',
		'BR4321303' => 'Taquari',
		'BR4321451' => 'Teutônia',
		'BR4321501' => 'Torres',
		'BR4321600' => 'Tramandaí',
		'BR4321709' => 'Três Coroas',
		'BR4321808' => 'Três de Maio',
		'BR4321907' => 'Três Passos',
		'BR4322004' => 'Triunfo',
		'BR4322202' => 'Tupanciretã',
		'BR4322707' => 'Vera Cruz',
		'BR4322806' => 'Veranópolis',
		'BR4300406' => 'Alegrete',
		'BR4303004' => 'Cachoeira do Sul',
		'BR4303509' => 'Camaquã',
		'BR4303905' => 'Campo Bom',
		'BR4304507' => 'Canguçu',
		'BR4304705' => 'Carazinho',
		'BR4306106' => 'Cruz Alta',
		'BR4307005' => 'Erechim',
		'BR4307708' => 'Esteio',
		'BR4307906' => 'Farroupilha',
		'BR4309308' => 'Guaíba',
		'BR4310207' => 'Ijuí',
		'BR4311403' => 'Lajeado',
		'BR4312401' => 'Montenegro',
		'BR4314050' => 'Parobé',
		'BR4317202' => 'Santa Rosa',
		'BR4317103' => 'SantAna do Livramento',
		'BR4317509' => 'Santo Ângelo',
		'BR4318002' => 'São Borja',
		'BR4318309' => 'São Gabriel',
		'BR4319901' => 'Sapiranga',
		'BR4321204' => 'Taquara',
		'BR4322509' => 'Vacaria',
		'BR4322608' => 'Venâncio Aires',
		'BR4300604' => 'Alvorada',
		'BR4301602' => 'Bagé',
		'BR4302105' => 'Bento Gonçalves',
		'BR4303103' => 'Cachoeirinha',
		'BR4304606' => 'Canoas',
		'BR4305108' => 'Caxias do Sul',
		'BR4309209' => 'Gravataí',
		'BR4313409' => 'Novo Hamburgo',
		'BR4314100' => 'Passo Fundo',
		'BR4314407' => 'Pelotas',
		'BR4315602' => 'Rio Grande',
		'BR4316808' => 'Santa Cruz do Sul',
		'BR4316907' => 'Santa Maria',
		'BR4318705' => 'São Leopoldo',
		'BR4320008' => 'Sapucaia do Sul',
		'BR4322400' => 'Uruguaiana',
		'BR4323002' => 'Viamão',
		'BR4314902' => 'Porto Alegre',
	],
	'SC' => [
		'BR4200051' => 'Abdon Batista',
		'BR4200309' => 'Agronômica',
		'BR4200556' => 'Águas Frias',
		'BR4200754' => 'Alto Bela Vista',
		'BR4201109' => 'Anitápolis',
		'BR4201273' => 'Arabutã',
		'BR4201604' => 'Arroio Trinta',
		'BR4201653' => 'Arvoredo',
		'BR4201802' => 'Atalanta',
		'BR4202081' => 'Bandeirante',
		'BR4202099' => 'Barra Bonita',
		'BR4202156' => 'Belmonte',
		'BR4202438' => 'Bocaina do Sul',
		'BR4202503' => 'Bom Jardim da Serra',
		'BR4202537' => 'Bom Jesus',
		'BR4202578' => 'Bom Jesus do Oeste',
		'BR4202701' => 'Botuverá',
		'BR4202859' => 'Braço do Trombudo',
		'BR4202875' => 'Brunópolis',
		'BR4203154' => 'Calmon',
		'BR4203253' => 'Capão Alto',
		'BR4204103' => 'Caxambu do Sul',
		'BR4204152' => 'Celso Ramos',
		'BR4204178' => 'Cerro Negro',
		'BR4204194' => 'Chapadão do Lageado',
		'BR4204350' => 'Cordilheira Alta',
		'BR4204459' => 'Coronel Martins',
		'BR4204756' => 'Cunhataí',
		'BR4205100' => 'Dona Emma',
		'BR4205159' => 'Doutor Pedrinho',
		'BR4205175' => 'Entre Rios',
		'BR4205191' => 'Ermo',
		'BR4205209' => 'Erval Velho',
		'BR4205357' => 'Flor do Sertão',
		'BR4205431' => 'Formosa do Sul',
		'BR4205555' => 'Frei Rogério',
		'BR4205605' => 'Galvão',
		'BR4206603' => 'Guarujá do Sul',
		'BR4206652' => 'Guatambú',
		'BR4206751' => 'Ibiam',
		'BR4206801' => 'Ibicaré',
		'BR4207577' => 'Iomerê',
		'BR4207601' => 'Ipira',
		'BR4207759' => 'Iraceminha',
		'BR4207858' => 'Irati',
		'BR4208609' => 'Jaborá',
		'BR4208955' => 'Jardinópolis',
		'BR4209151' => 'José Boiteux',
		'BR4209177' => 'Jupiá',
		'BR4209201' => 'Lacerdópolis',
		'BR4209458' => 'Lajeado Grande',
		'BR4209805' => 'Leoberto Leal',
		'BR4209854' => 'Lindóia do Sul',
		'BR4210050' => 'Macieira',
		'BR4210209' => 'Major Gercino',
		'BR4210555' => 'Marema',
		'BR4210704' => 'Matos Costa',
		'BR4210852' => 'Mirim Doce',
		'BR4210902' => 'Modelo',
		'BR4211256' => 'Morro Grande',
		'BR4211405' => 'Nova Erechim',
		'BR4211454' => 'Nova Itaberaba',
		'BR4211652' => 'Novo Horizonte',
		'BR4211850' => 'Ouro Verde',
		'BR4211876' => 'Paial',
		'BR4211892' => 'Painel',
		'BR4212056' => 'Palmeira',
		'BR4212239' => 'Paraíso',
		'BR4212270' => 'Passos Maia',
		'BR4212403' => 'Pedras Grandes',
		'BR4212601' => 'Peritiba',
		'BR4213005' => 'Pinheiro Preto',
		'BR4213104' => 'Piratuba',
		'BR4213153' => 'Planalto Alegre',
		'BR4213302' => 'Ponte Alta',
		'BR4213351' => 'Ponte Alta do Norte',
		'BR4213906' => 'Presidente Castello Branco',
		'BR4214102' => 'Presidente Nereu',
		'BR4214151' => 'Princesa',
		'BR4214300' => 'Rancho Queimado',
		'BR4214904' => 'Rio Fortuna',
		'BR4215059' => 'Rio Rufino',
		'BR4215075' => 'Riqueza',
		'BR4215356' => 'Saltinho',
		'BR4215406' => 'Salto Veloso',
		'BR4215554' => 'Santa Helena',
		'BR4215604' => 'Santa Rosa de Lima',
		'BR4215687' => 'Santa Terezinha do Progresso',
		'BR4215695' => 'Santiago do Sul',
		'BR4215752' => 'São Bernardino',
		'BR4215901' => 'São Bonifácio',
		'BR4216354' => 'São João do Itaperiú',
		'BR4217105' => 'São Martinho',
		'BR4217154' => 'São Miguel da Boa Vista',
		'BR4217253' => 'São Pedro de Alcântara',
		'BR4217550' => 'Serra Alta',
		'BR4217758' => 'Sul Brasil',
		'BR4217956' => 'Tigrinhos',
		'BR4218350' => 'Treviso',
		'BR4218756' => 'Tunápolis',
		'BR4218855' => 'União do Oeste',
		'BR4218954' => 'Urupema',
		'BR4219101' => 'Vargeão',
		'BR4219150' => 'Vargem',
		'BR4219176' => 'Vargem Bonita',
		'BR4219408' => 'Witmarsum',
		'BR4219606' => 'Xavantina',
		'BR4219853' => 'Zortéa',
		'BR4200200' => 'Agrolândia',
		'BR4200408' => 'Água Doce',
		'BR4200507' => 'Águas de Chapecó',
		'BR4200606' => 'Águas Mornas',
		'BR4200705' => 'Alfredo Wagner',
		'BR4200804' => 'Anchieta',
		'BR4200903' => 'Angelina',
		'BR4201000' => 'Anita Garibaldi',
		'BR4201208' => 'Antônio Carlos',
		'BR4201257' => 'Apiúna',
		'BR4201505' => 'Armazém',
		'BR4201703' => 'Ascurra',
		'BR4201901' => 'Aurora',
		'BR4201950' => 'Balneário Arroio do Silva',
		'BR4202057' => 'Balneário Barra do Sul',
		'BR4202073' => 'Balneário Gaivota',
		'BR4202131' => 'Bela Vista do Toldo',
		'BR4202602' => 'Bom Retiro',
		'BR4203105' => 'Caibi',
		'BR4203402' => 'Campo Belo do Sul',
		'BR4203501' => 'Campo Erê',
		'BR4204004' => 'Catanduvas',
		'BR4204905' => 'Descanso',
		'BR4206108' => 'Grão Pará',
		'BR4207403' => 'Imbuia',
		'BR4207650' => 'Iporã do Oeste',
		'BR4207684' => 'Ipuaçu',
		'BR4207700' => 'Ipumirim',
		'BR4207809' => 'Irani',
		'BR4208005' => 'Itá',
		'BR4209508' => 'Laurentino',
		'BR4210035' => 'Luzerna',
		'BR4210308' => 'Major Vieira',
		'BR4210407' => 'Maracajá',
		'BR4210803' => 'Meleiro',
		'BR4211058' => 'Monte Carlo',
		'BR4211108' => 'Monte Castelo',
		'BR4211801' => 'Ouro',
		'BR4212007' => 'Palma Sola',
		'BR4212254' => 'Passo de Torres',
		'BR4212304' => 'Paulo Lopes',
		'BR4212700' => 'Petrolândia',
		'BR4213807' => 'Praia Grande',
		'BR4214409' => 'Rio das Antas',
		'BR4214508' => 'Rio do Campo',
		'BR4214607' => 'Rio do Oeste',
		'BR4215208' => 'Romelândia',
		'BR4215307' => 'Salete',
		'BR4215653' => 'Santa Rosa do Sul',
		'BR4215679' => 'Santa Terezinha',
		'BR4216057' => 'São Cristovão do Sul',
		'BR4216107' => 'São Domingos',
		'BR4216255' => 'São João do Oeste',
		'BR4216404' => 'São João do Sul',
		'BR4216800' => 'São José do Cerrito',
		'BR4217303' => 'Saudades',
		'BR4217907' => 'Tangará',
		'BR4218103' => 'Timbé do Sul',
		'BR4218251' => 'Timbó Grande',
		'BR4218400' => 'Treze de Maio',
		'BR4218509' => 'Treze Tílias',
		'BR4218608' => 'Trombudo Central',
		'BR4219200' => 'Vidal Ramos',
		'BR4219358' => 'Vitor Meireles',
		'BR4200101' => 'Abelardo Luz',
		'BR4212809' => 'Balneário Piçarras',
		'BR4202206' => 'Benedito Novo',
		'BR4202453' => 'Bombinhas',
		'BR4203303' => 'Campo Alegre',
		'BR4203709' => 'Canelinha',
		'BR4204251' => 'Cocal do Sul',
		'BR4204400' => 'Coronel Freitas',
		'BR4204558' => 'Correia Pinto',
		'BR4204509' => 'Corupá',
		'BR4204707' => 'Cunha Porã',
		'BR4205001' => 'Dionísio Cerqueira',
		'BR4205308' => 'Faxinal dos Guedes',
		'BR4205704' => 'Garopaba',
		'BR4205803' => 'Garuva',
		'BR4206009' => 'Governador Celso Ramos',
		'BR4206207' => 'Gravatal',
		'BR4206306' => 'Guabiruba',
		'BR4206405' => 'Guaraciaba',
		'BR4206900' => 'Ibirama',
		'BR4207106' => 'Ilhota',
		'BR4207205' => 'Imaruí',
		'BR4207908' => 'Irineópolis',
		'BR4208401' => 'Itapiranga',
		'BR4208450' => 'Itapoá',
		'BR4208708' => 'Jacinto Machado',
		'BR4208807' => 'Jaguaruna',
		'BR4209607' => 'Lauro Muller',
		'BR4209706' => 'Lebon Régis',
		'BR4209904' => 'Lontras',
		'BR4210001' => 'Luiz Alves',
		'BR4210605' => 'Massaranduba',
		'BR4211009' => 'Mondaí',
		'BR4211207' => 'Morro da Fumaça',
		'BR4211504' => 'Nova Trento',
		'BR4211603' => 'Nova Veneza',
		'BR4211751' => 'Otacílio Costa',
		'BR4212106' => 'Palmitos',
		'BR4212205' => 'Papanduva',
		'BR4212908' => 'Pinhalzinho',
		'BR4213401' => 'Ponte Serrada',
		'BR4213500' => 'Porto Belo',
		'BR4213708' => 'Pouso Redondo',
		'BR4214003' => 'Presidente Getúlio',
		'BR4214201' => 'Quilombo',
		'BR4214706' => 'Rio dos Cedros',
		'BR4215109' => 'Rodeio',
		'BR4215455' => 'Sangão',
		'BR4215505' => 'Santa Cecília',
		'BR4215703' => 'Santo Amaro da Imperatriz',
		'BR4216008' => 'São Carlos',
		'BR4216701' => 'São José do Cedro',
		'BR4217006' => 'São Ludgero',
		'BR4217402' => 'Schroeder',
		'BR4217501' => 'Seara',
		'BR4217600' => 'Siderópolis',
		'BR4217808' => 'Taió',
		'BR4218301' => 'Três Barras',
		'BR4218806' => 'Turvo',
		'BR4218905' => 'Urubici',
		'BR4201307' => 'Araquari',
		'BR4202107' => 'Barra Velha',
		'BR4202800' => 'Braço do Norte',
		'BR4203600' => 'Campos Novos',
		'BR4203907' => 'Capinzal',
		'BR4203956' => 'Capivari de Baixo',
		'BR4204806' => 'Curitibanos',
		'BR4205456' => 'Forquilhinha',
		'BR4205506' => 'Fraiburgo',
		'BR4206504' => 'Guaramirim',
		'BR4206702' => 'Herval dOeste',
		'BR4207304' => 'Imbituba',
		'BR4208104' => 'Itaiópolis',
		'BR4208302' => 'Itapema',
		'BR4208500' => 'Ituporanga',
		'BR4209003' => 'Joaçaba',
		'BR4210506' => 'Maravilha',
		'BR4211702' => 'Orleans',
		'BR4212502' => 'Penha',
		'BR4213203' => 'Pomerode',
		'BR4213609' => 'Porto União',
		'BR4215000' => 'Rio Negrinho',
		'BR4216206' => 'São Francisco do Sul',
		'BR4216305' => 'São João Batista',
		'BR4216503' => 'São Joaquim',
		'BR4216909' => 'São Lourenço do Oeste',
		'BR4217204' => 'São Miguel do Oeste',
		'BR4217709' => 'Sombrio',
		'BR4218004' => 'Tijucas',
		'BR4218202' => 'Timbó',
		'BR4219002' => 'Urussanga',
		'BR4219309' => 'Videira',
		'BR4219507' => 'Xanxerê',
		'BR4219705' => 'Xaxim',
		'BR4201406' => 'Araranguá',
		'BR4202305' => 'Biguaçu',
		'BR4203006' => 'Caçador',
		'BR4203204' => 'Camboriú',
		'BR4203808' => 'Canoinhas',
		'BR4204301' => 'Concórdia',
		'BR4205902' => 'Gaspar',
		'BR4207007' => 'Içara',
		'BR4207502' => 'Indaial',
		'BR4209409' => 'Laguna',
		'BR4210100' => 'Mafra',
		'BR4211306' => 'Navegantes',
		'BR4214805' => 'Rio do Sul',
		'BR4215802' => 'São Bento do Sul',
		'BR4218707' => 'Tubarão',
		'BR4202008' => 'Balneário Camboriú',
		'BR4202404' => 'Blumenau',
		'BR4202909' => 'Brusque',
		'BR4204202' => 'Chapecó',
		'BR4204608' => 'Criciúma',
		'BR4205407' => 'Florianópolis',
		'BR4208203' => 'Itajaí',
		'BR4208906' => 'Jaraguá do Sul',
		'BR4209300' => 'Lages',
		'BR4211900' => 'Palhoça',
		'BR4216602' => 'São José',
		'BR4209102' => 'Joinville',
	],
	'SE' => [
		'BR2800100' => 'Amparo de São Francisco',
		'BR2801108' => 'Canhoba',
		'BR2801900' => 'Cumbe',
		'BR2802007' => 'Divina Pastora',
		'BR2802502' => 'General Maynard',
		'BR2803104' => 'Itabi',
		'BR2803807' => 'Malhada dos Bois',
		'BR2805000' => 'Pedra Mole',
		'BR2806503' => 'Santa Rosa de Lima',
		'BR2806909' => 'São Francisco',
		'BR2807006' => 'São Miguel do Aleixo',
		'BR2807303' => 'Telha',
		'BR2800704' => 'Brejo Grande',
		'BR2801603' => 'Cedro de São João',
		'BR2802205' => 'Feira Nova',
		'BR2802601' => 'Gracho Cardoso',
		'BR2802700' => 'Ilha das Flores',
		'BR2803708' => 'Macambira',
		'BR2804300' => 'Muribeca',
		'BR2804458' => 'Nossa Senhora Aparecida',
		'BR2804706' => 'Nossa Senhora de Lourdes',
		'BR2805109' => 'Pedrinhas',
		'BR2805208' => 'Pinhão',
		'BR2805307' => 'Pirambu',
		'BR2805901' => 'Riachuelo',
		'BR2806107' => 'Rosário do Catete',
		'BR2806404' => 'Santana do São Francisco',
		'BR2807204' => 'Siriri',
		'BR2800407' => 'Arauá',
		'BR2800506' => 'Areia Branca',
		'BR2801009' => 'Campo do Brito',
		'BR2801504' => 'Carmópolis',
		'BR2801702' => 'Cristinápolis',
		'BR2802304' => 'Frei Paulo',
		'BR2802403' => 'Gararu',
		'BR2802809' => 'Indiaroba',
		'BR2803302' => 'Japaratuba',
		'BR2803401' => 'Japoatã',
		'BR2803906' => 'Malhador',
		'BR2804003' => 'Maruim',
		'BR2804102' => 'Moita Bonita',
		'BR2804201' => 'Monte Alegre de Sergipe',
		'BR2804409' => 'Neópolis',
		'BR2804904' => 'Pacatuba',
		'BR2805802' => 'Riachão do Dantas',
		'BR2806008' => 'Ribeirópolis',
		'BR2806206' => 'Salgado',
		'BR2806305' => 'Santa Luzia do Itanhy',
		'BR2806602' => 'Santo Amaro das Brotas',
		'BR2806800' => 'São Domingos',
		'BR2807501' => 'Tomar do Geru',
		'BR2800209' => 'Aquidabã',
		'BR2800605' => 'Barra dos Coqueiros',
		'BR2800670' => 'Boquim',
		'BR2801207' => 'Canindé de São Francisco',
		'BR2801306' => 'Capela',
		'BR2801405' => 'Carira',
		'BR2803005' => 'Itabaianinha',
		'BR2803203' => 'Itaporanga dAjuda',
		'BR2803609' => 'Laranjeiras',
		'BR2804508' => 'Nossa Senhora da Glória',
		'BR2804607' => 'Nossa Senhora das Dores',
		'BR2805406' => 'Poço Redondo',
		'BR2805505' => 'Poço Verde',
		'BR2805604' => 'Porto da Folha',
		'BR2805703' => 'Propriá',
		'BR2807105' => 'Simão Dias',
		'BR2807402' => 'Tobias Barreto',
		'BR2807600' => 'Umbaúba',
		'BR2802106' => 'Estância',
		'BR2802908' => 'Itabaiana',
		'BR2803500' => 'Lagarto',
		'BR2806701' => 'São Cristóvão',
		'BR2804805' => 'Nossa Senhora do Socorro',
		'BR2800308' => 'Aracaju',
	],
	'SP' => [
		'BR3500204' => 'Adolfo',
		'BR3500600' => 'Águas de São Pedro',
		'BR3500758' => 'Alambari',
		'BR3500808' => 'Alfredo Marcondes',
		'BR3500907' => 'Altair',
		'BR3501103' => 'Alto Alegre',
		'BR3501202' => 'Álvares Florence',
		'BR3501400' => 'Álvaro de Carvalho',
		'BR3501509' => 'Alvinlândia',
		'BR3502002' => 'Analândia',
		'BR3502408' => 'Anhumas',
		'BR3502606' => 'Aparecida dOeste',
		'BR3503158' => 'Arapeí',
		'BR3503356' => 'Arco-Íris',
		'BR3503505' => 'Areias',
		'BR3503950' => 'Aspásia',
		'BR3504305' => 'Avaí',
		'BR3504701' => 'Balbinos',
		'BR3505005' => 'Barão de Antonina',
		'BR3506201' => 'Bento de Abreu',
		'BR3507159' => 'Bom Sucesso de Itararé',
		'BR3507209' => 'Borá',
		'BR3507308' => 'Boracéia',
		'BR3507456' => 'Borebi',
		'BR3507753' => 'Brejo Alegre',
		'BR3508207' => 'Buritizal',
		'BR3508306' => 'Cabrália Paulista',
		'BR3508900' => 'Caiabu',
		'BR3509809' => 'Campos Novos Paulista',
		'BR3509957' => 'Canas',
		'BR3510104' => 'Cândido Rodrigues',
		'BR3510153' => 'Canitar',
		'BR3510906' => 'Cássia dos Coqueiros',
		'BR3512704' => 'Corumbataí',
		'BR3513306' => 'Cruzália',
		'BR3513850' => 'Dirce Reis',
		'BR3514205' => 'Dolcinópolis',
		'BR3514924' => 'Elisiário',
		'BR3514957' => 'Embaúba',
		'BR3515129' => 'Emilianópolis',
		'BR3515194' => 'Espírito Santo do Turvo',
		'BR3515301' => 'Estrela do Norte',
		'BR3515657' => 'Fernão',
		'BR3515806' => 'Flora Rica',
		'BR3515905' => 'Floreal',
		'BR3516101' => 'Florínia',
		'BR3516507' => 'Gabriel Monteiro',
		'BR3516804' => 'Gastão Vidigal',
		'BR3516853' => 'Gavião Peixoto',
		'BR3517109' => 'Glicério',
		'BR3518008' => 'Guarani dOeste',
		'BR3518909' => 'Guzolândia',
		'BR3520608' => 'Indiana',
		'BR3520707' => 'Indiaporã',
		'BR3520806' => 'Inúbia Paulista',
		'BR3521150' => 'Ipiguá',
		'BR3521200' => 'Iporanga',
		'BR3522000' => 'Itaju',
		'BR3522158' => 'Itaóca',
		'BR3522653' => 'Itapirapuã Paulista',
		'BR3523008' => 'Itapura',
		'BR3525409' => 'Jeriquara',
		'BR3525607' => 'João Ramalho',
		'BR3525805' => 'Júlio Mesquita',
		'BR3525854' => 'Jumirim',
		'BR3526308' => 'Lagoinha',
		'BR3527256' => 'Lourdes',
		'BR3527504' => 'Lucianópolis',
		'BR3527801' => 'Lupércio',
		'BR3527900' => 'Lutécia',
		'BR3528205' => 'Macedônia',
		'BR3528304' => 'Magda',
		'BR3528700' => 'Marabá Paulista',
		'BR3528858' => 'Marapoama',
		'BR3528908' => 'Mariápolis',
		'BR3529104' => 'Marinópolis',
		'BR3529500' => 'Mendonça',
		'BR3529609' => 'Meridiano',
		'BR3529658' => 'Mesópolis',
		'BR3530003' => 'Mira Estrela',
		'BR3530409' => 'Mirassolândia',
		'BR3530904' => 'Mombuca',
		'BR3531001' => 'Monções',
		'BR3531605' => 'Monte Castelo',
		'BR3531704' => 'Monteiro Lobato',
		'BR3532058' => 'Motuca',
		'BR3532108' => 'Murutinga do Sul',
		'BR3532157' => 'Nantes',
		'BR3532207' => 'Narandiba',
		'BR3532702' => 'Nipoã',
		'BR3532843' => 'Nova Canaã Paulista',
		'BR3532868' => 'Nova Castilho',
		'BR3533106' => 'Nova Guataporanga',
		'BR3533205' => 'Nova Independência',
		'BR3533304' => 'Nova Luzitânia',
		'BR3533254' => 'Novais',
		'BR3533700' => 'Ocauçu',
		'BR3533809' => 'Óleo',
		'BR3534005' => 'Onda Verde',
		'BR3534500' => 'Oscar Bressane',
		'BR3535903' => 'Paranapuã',
		'BR3536257' => 'Parisi',
		'BR3536570' => 'Paulistânia',
		'BR3536901' => 'Pedranópolis',
		'BR3537156' => 'Pedrinhas Paulista',
		'BR3538303' => 'Piquerobi',
		'BR3539608' => 'Planalto',
		'BR3539707' => 'Platina',
		'BR3540101' => 'Pongaí',
		'BR3540259' => 'Pontalinda',
		'BR3540309' => 'Pontes Gestal',
		'BR3540408' => 'Populina',
		'BR3540853' => 'Pracinha',
		'BR3541059' => 'Pratânia',
		'BR3541109' => 'Presidente Alves',
		'BR3541653' => 'Quadra',
		'BR3541802' => 'Queiroz',
		'BR3542305' => 'Redenção da Serra',
		'BR3542800' => 'Ribeira',
		'BR3543105' => 'Ribeirão Corrente',
		'BR3543204' => 'Ribeirão do Sul',
		'BR3543238' => 'Ribeirão dos Índios',
		'BR3543600' => 'Rifaina',
		'BR3544400' => 'Rubiácea',
		'BR3544509' => 'Rubinéia',
		'BR3544707' => 'Sagres',
		'BR3545100' => 'Salmourão',
		'BR3545506' => 'Sandovalina',
		'BR3546108' => 'Santa Clara dOeste',
		'BR3546207' => 'Santa Cruz da Conceição',
		'BR3546256' => 'Santa Cruz da Esperança',
		'BR3547106' => 'Santa Mercedes',
		'BR3547403' => 'Santa Rita dOeste',
		'BR3547650' => 'Santa Salete',
		'BR3547205' => 'Santana da Ponte Pensa',
		'BR3548302' => 'Santo Expedito',
		'BR3548401' => 'Santópolis do Aguapeí',
		'BR3549003' => 'São Francisco',
		'BR3549201' => 'São João das Duas Pontes',
		'BR3549250' => 'São João de Iracema',
		'BR3549300' => 'São João do Pau dAlho',
		'BR3549607' => 'São José do Barreiro',
		'BR3551207' => 'Sarutaiá',
		'BR3551306' => 'Sebastianópolis do Sul',
		'BR3552551' => 'Suzanápolis',
		'BR3553658' => 'Taquaral',
		'BR3554201' => 'Tejupá',
		'BR3554607' => 'Timburi',
		'BR3554656' => 'Torre de Pedra',
		'BR3554755' => 'Trabiju',
		'BR3555208' => 'Turiúba',
		'BR3555307' => 'Turmalina',
		'BR3555505' => 'Ubirajara',
		'BR3555703' => 'União Paulista',
		'BR3555901' => 'Uru',
		'BR3556958' => 'Vitória Brasil',
		'BR3557154' => 'Zacarias',
		'BR3500402' => 'Águas da Prata',
		'BR3500550' => 'Águas de Santa Bárbara',
		'BR3501806' => 'Américo de Campos',
		'BR3502309' => 'Anhembi',
		'BR3503000' => 'Aramina',
		'BR3503109' => 'Arandu',
		'BR3503406' => 'Arealva',
		'BR3503703' => 'Ariranha',
		'BR3504800' => 'Bálsamo',
		'BR3505104' => 'Barbosa',
		'BR3505351' => 'Barra do Chapéu',
		'BR3505401' => 'Barra do Turvo',
		'BR3506409' => 'Bilac',
		'BR3506904' => 'Bofete',
		'BR3507704' => 'Braúna',
		'BR3509106' => 'Caiuá',
		'BR3509304' => 'Cajobi',
		'BR3509452' => 'Campina do Monte Alegre',
		'BR3511201' => 'Catiguá',
		'BR3511300' => 'Cedral',
		'BR3511904' => 'Clementina',
		'BR3512100' => 'Colômbia',
		'BR3512506' => 'Coroados',
		'BR3512605' => 'Coronel Macedo',
		'BR3512902' => 'Cosmorama',
		'BR3513207' => 'Cristais Paulista',
		'BR3514007' => 'Dobrada',
		'BR3514304' => 'Dourado',
		'BR3514601' => 'Dumont',
		'BR3514700' => 'Echaporã',
		'BR3515202' => 'Estrela dOeste',
		'BR3515350' => 'Euclides da Cunha Paulista',
		'BR3515608' => 'Fernando Prestes',
		'BR3516606' => 'Gália',
		'BR3517307' => 'Guaimbê',
		'BR3517802' => 'Guaraçaí',
		'BR3517901' => 'Guaraci',
		'BR3518107' => 'Guarantã',
		'BR3518859' => 'Guatapará',
		'BR3519006' => 'Herculândia',
		'BR3519204' => 'Iacri',
		'BR3519253' => 'Iaras',
		'BR3519501' => 'Ibirarema',
		'BR3519808' => 'Icém',
		'BR3519907' => 'Iepê',
		'BR3520202' => 'Igaratá',
		'BR3520426' => 'Ilha Comprida',
		'BR3521101' => 'Ipeúna',
		'BR3521507' => 'Irapuã',
		'BR3521606' => 'Irapuru',
		'BR3523701' => 'Itirapuã',
		'BR3523800' => 'Itobi',
		'BR3524204' => 'Jaborandi',
		'BR3524501' => 'Jaci',
		'BR3524907' => 'Jambeiro',
		'BR3526506' => 'Lavínia',
		'BR3526605' => 'Lavrinhas',
		'BR3527009' => 'Lindóia',
		'BR3527702' => 'Luiziânia',
		'BR3528106' => 'Macaubal',
		'BR3528601' => 'Manduri',
		'BR3531209' => 'Monte Alegre do Sul',
		'BR3532306' => 'Natividade da Serra',
		'BR3532504' => 'Neves Paulista',
		'BR3532801' => 'Nova Aliança',
		'BR3532827' => 'Nova Campina',
		'BR3532900' => 'Nova Europa',
		'BR3533601' => 'Nuporanga',
		'BR3534104' => 'Oriente',
		'BR3534203' => 'Orindiúva',
		'BR3534807' => 'Ouro Verde',
		'BR3534757' => 'Ouroeste',
		'BR3535200' => 'Palmeira dOeste',
		'BR3535705' => 'Paraíso',
		'BR3536109' => 'Pardinho',
		'BR3536406' => 'Paulicéia',
		'BR3536604' => 'Paulo de Faria',
		'BR3536802' => 'Pedra Bela',
		'BR3537503' => 'Pereiras',
		'BR3537701' => 'Piacatu',
		'BR3539905' => 'Poloni',
		'BR3540507' => 'Porangaba',
		'BR3542008' => 'Quintana',
		'BR3542107' => 'Rafard',
		'BR3542503' => 'Reginópolis',
		'BR3542701' => 'Restinga',
		'BR3543253' => 'Ribeirão Grande',
		'BR3543808' => 'Rinópolis',
		'BR3543501' => 'Riversul',
		'BR3544301' => 'Roseira',
		'BR3544608' => 'Sabino',
		'BR3544806' => 'Sales',
		'BR3545159' => 'Saltinho',
		'BR3545407' => 'Salto Grande',
		'BR3545704' => 'Santa Albertina',
		'BR3546504' => 'Santa Ernestina',
		'BR3546900' => 'Santa Lúcia',
		'BR3547007' => 'Santa Maria da Serra',
		'BR3547908' => 'Santo Antônio da Alegria',
		'BR3548054' => 'Santo Antônio do Aracanguá',
		'BR3548104' => 'Santo Antônio do Jardim',
		'BR3548203' => 'Santo Antônio do Pinhal',
		'BR3549508' => 'São José da Bela Vista',
		'BR3550506' => 'São Pedro do Turvo',
		'BR3551108' => 'Sarapuí',
		'BR3552007' => 'Silveiras',
		'BR3552304' => 'Sud Mennucci',
		'BR3552908' => 'Taciba',
		'BR3553104' => 'Taiaçu',
		'BR3553203' => 'Taiúva',
		'BR3553500' => 'Tapiraí',
		'BR3553856' => 'Taquarivaí',
		'BR3553906' => 'Tarabai',
		'BR3554409' => 'Terra Roxa',
		'BR3554706' => 'Torrinha',
		'BR3554904' => 'Três Fronteiras',
		'BR3554953' => 'Tuiuti',
		'BR3555356' => 'Ubarana',
		'BR3555604' => 'Uchoa',
		'BR3555802' => 'Urânia',
		'BR3556354' => 'Vargem',
		'BR3556909' => 'Vista Alegre do Alto',
		'BR3500501' => 'Águas de Lindóia',
		'BR3501004' => 'Altinópolis',
		'BR3501152' => 'Alumínio',
		'BR3502754' => 'Araçariguama',
		'BR3503604' => 'Areiópolis',
		'BR3504206' => 'Auriflama',
		'BR3504404' => 'Avanhandava',
		'BR3504602' => 'Bady Bassitt',
		'BR3504909' => 'Bananal',
		'BR3506300' => 'Bernardino de Campos',
		'BR3506706' => 'Boa Esperança do Sul',
		'BR3506805' => 'Bocaina',
		'BR3507100' => 'Bom Jesus dos Perdões',
		'BR3507407' => 'Borborema',
		'BR3508009' => 'Buri',
		'BR3508108' => 'Buritama',
		'BR3508702' => 'Caconde',
		'BR3508801' => 'Cafelândia',
		'BR3509908' => 'Cananéia',
		'BR3510302' => 'Capela do Alto',
		'BR3510708' => 'Cardoso',
		'BR3511003' => 'Castilho',
		'BR3511409' => 'Cerqueira César',
		'BR3511607' => 'Cesário Lange',
		'BR3511706' => 'Charqueada',
		'BR3557204' => 'Chavantes',
		'BR3512001' => 'Colina',
		'BR3512308' => 'Conchas',
		'BR3513900' => 'Divinolândia',
		'BR3514502' => 'Duartina',
		'BR3514809' => 'Eldorado',
		'BR3514908' => 'Elias Fausto',
		'BR3515152' => 'Engenheiro Coelho',
		'BR3557303' => 'Estiva Gerbi',
		'BR3515400' => 'Fartura',
		'BR3516002' => 'Flórida Paulista',
		'BR3516903' => 'General Salgado',
		'BR3517000' => 'Getulina',
		'BR3517208' => 'Guaiçara',
		'BR3517505' => 'Guapiaçu',
		'BR3517604' => 'Guapiara',
		'BR3517703' => 'Guará',
		'BR3518503' => 'Guareí',
		'BR3519055' => 'Holambra',
		'BR3519105' => 'Iacanga',
		'BR3519402' => 'Ibirá',
		'BR3520905' => 'Ipaussu',
		'BR3521309' => 'Ipuã',
		'BR3521705' => 'Itaberá',
		'BR3521903' => 'Itajobi',
		'BR3522802' => 'Itaporanga',
		'BR3522901' => 'Itapuí',
		'BR3523305' => 'Itariri',
		'BR3523503' => 'Itatinga',
		'BR3523602' => 'Itirapina',
		'BR3524600' => 'Jacupiranga',
		'BR3525508' => 'Joanópolis',
		'BR3526001' => 'Junqueirópolis',
		'BR3526100' => 'Juquiá',
		'BR3527405' => 'Lucélia',
		'BR3527603' => 'Luís Antônio',
		'BR3528007' => 'Macatuba',
		'BR3528809' => 'Maracaí',
		'BR3529807' => 'Mineiros do Tietê',
		'BR3530201' => 'Mirante do Paranapanema',
		'BR3531506' => 'Monte Azul Paulista',
		'BR3532009' => 'Morungaba',
		'BR3532405' => 'Nazaré Paulista',
		'BR3532603' => 'Nhandeara',
		'BR3533007' => 'Nova Granada',
		'BR3534906' => 'Pacaembu',
		'BR3535002' => 'Palestina',
		'BR3535101' => 'Palmares Paulista',
		'BR3535408' => 'Panorama',
		'BR3535606' => 'Paraibuna',
		'BR3535804' => 'Paranapanema',
		'BR3536000' => 'Parapuã',
		'BR3536208' => 'Pariquera-Açu',
		'BR3536307' => 'Patrocínio Paulista',
		'BR3537008' => 'Pedregulho',
		'BR3537206' => 'Pedro de Toledo',
		'BR3538105' => 'Pindorama',
		'BR3538204' => 'Pinhalzinho',
		'BR3538501' => 'Piquete',
		'BR3539004' => 'Pirangi',
		'BR3539103' => 'Pirapora do Bom Jesus',
		'BR3539400' => 'Piratininga',
		'BR3540002' => 'Pompéia',
		'BR3540754' => 'Potim',
		'BR3540804' => 'Potirendaba',
		'BR3540903' => 'Pradópolis',
		'BR3541208' => 'Presidente Bernardes',
		'BR3541703' => 'Quatá',
		'BR3541901' => 'Queluz',
		'BR3542404' => 'Regente Feijó',
		'BR3542909' => 'Ribeirão Bonito',
		'BR3543006' => 'Ribeirão Branco',
		'BR3543709' => 'Rincão',
		'BR3544202' => 'Riolândia',
		'BR3544251' => 'Rosana',
		'BR3544905' => 'Sales Oliveira',
		'BR3545001' => 'Salesópolis',
		'BR3545605' => 'Santa Adélia',
		'BR3546009' => 'Santa Branca',
		'BR3548609' => 'São Bento do Sapucaí',
		'BR3549953' => 'São Lourenço da Serra',
		'BR3550001' => 'São Luís do Paraitinga',
		'BR3550803' => 'São Sebastião da Grama',
		'BR3550902' => 'São Simão',
		'BR3551405' => 'Serra Azul',
		'BR3551801' => 'Sete Barras',
		'BR3551900' => 'Severínia',
		'BR3552601' => 'Tabapuã',
		'BR3552700' => 'Tabatinga',
		'BR3553005' => 'Taguaí',
		'BR3553609' => 'Tapiratiba',
		'BR3553955' => 'Tarumã',
		'BR3555109' => 'Tupi Paulista',
		'BR3556008' => 'Urupês',
		'BR3556107' => 'Valentim Gentil',
		'BR3556602' => 'Vera Cruz',
		'BR3556800' => 'Viradouro',
		'BR3500105' => 'Adamantina',
		'BR3500303' => 'Aguaí',
		'BR3500709' => 'Agudos',
		'BR3501301' => 'Álvares Machado',
		'BR3501707' => 'Américo Brasiliense',
		'BR3502200' => 'Angatuba',
		'BR3502507' => 'Aparecida',
		'BR3502705' => 'Apiaí',
		'BR3502903' => 'Araçoiaba da Serra',
		'BR3503802' => 'Artur Nogueira',
		'BR3505203' => 'Bariri',
		'BR3505302' => 'Barra Bonita',
		'BR3505609' => 'Barrinha',
		'BR3505807' => 'Bastos',
		'BR3506359' => 'Bertioga',
		'BR3506607' => 'Biritiba-Mirim',
		'BR3507001' => 'Boituva',
		'BR3507803' => 'Brodowski',
		'BR3507902' => 'Brotas',
		'BR3508405' => 'Cabreúva',
		'BR3508603' => 'Cachoeira Paulista',
		'BR3509254' => 'Cajati',
		'BR3509403' => 'Cajuru',
		'BR3509700' => 'Campos do Jordão',
		'BR3510005' => 'Cândido Mota',
		'BR3510203' => 'Capão Bonito',
		'BR3510401' => 'Capivari',
		'BR3510807' => 'Casa Branca',
		'BR3511508' => 'Cerquilho',
		'BR3512209' => 'Conchal',
		'BR3512407' => 'Cordeirópolis',
		'BR3513108' => 'Cravinhos',
		'BR3513603' => 'Cunha',
		'BR3513702' => 'Descalvado',
		'BR3514106' => 'Dois Córregos',
		'BR3514403' => 'Dracena',
		'BR3515186' => 'Espírito Santo do Pinhal',
		'BR3516705' => 'Garça',
		'BR3517406' => 'Guaíra',
		'BR3518206' => 'Guararapes',
		'BR3518305' => 'Guararema',
		'BR3518602' => 'Guariba',
		'BR3519303' => 'Ibaté',
		'BR3520004' => 'Igaraçu do Tietê',
		'BR3520103' => 'Igarapava',
		'BR3520301' => 'Iguape',
		'BR3520442' => 'Ilha Solteira',
		'BR3520400' => 'Ilhabela',
		'BR3521002' => 'Iperó',
		'BR3521408' => 'Iracemápolis',
		'BR3521804' => 'Itaí',
		'BR3522703' => 'Itápolis',
		'BR3523206' => 'Itararé',
		'BR3524006' => 'Itupeva',
		'BR3524105' => 'Ituverava',
		'BR3524709' => 'Jaguariúna',
		'BR3524808' => 'Jales',
		'BR3525102' => 'Jardinópolis',
		'BR3525201' => 'Jarinu',
		'BR3525706' => 'José Bonifácio',
		'BR3526209' => 'Juquitiba',
		'BR3526407' => 'Laranjal Paulista',
		'BR3527306' => 'Louveira',
		'BR3528403' => 'Mairinque',
		'BR3529203' => 'Martinópolis',
		'BR3529708' => 'Miguelópolis',
		'BR3529906' => 'Miracatu',
		'BR3530102' => 'Mirandópolis',
		'BR3531100' => 'Mongaguá',
		'BR3531308' => 'Monte Alto',
		'BR3531407' => 'Monte Aprazível',
		'BR3531803' => 'Monte Mor',
		'BR3531902' => 'Morro Agudo',
		'BR3533502' => 'Novo Horizonte',
		'BR3534302' => 'Orlândia',
		'BR3534609' => 'Osvaldo Cruz',
		'BR3535309' => 'Palmital',
		'BR3535507' => 'Paraguaçu Paulista',
		'BR3536703' => 'Pederneiras',
		'BR3537107' => 'Pedreira',
		'BR3537404' => 'Pereira Barreto',
		'BR3537909' => 'Pilar do Sul',
		'BR3538600' => 'Piracaia',
		'BR3538808' => 'Piraju',
		'BR3538907' => 'Pirajuí',
		'BR3539202' => 'Pirapozinho',
		'BR3539509' => 'Pitangueiras',
		'BR3540200' => 'Pontal',
		'BR3540606' => 'Porto Feliz',
		'BR3541307' => 'Presidente Epitácio',
		'BR3541505' => 'Presidente Venceslau',
		'BR3541604' => 'Promissão',
		'BR3542206' => 'Rancharia',
		'BR3544004' => 'Rio das Pedras',
		'BR3544103' => 'Rio Grande da Serra',
		'BR3545308' => 'Salto de Pirapora',
		'BR3546306' => 'Santa Cruz das Palmeiras',
		'BR3546405' => 'Santa Cruz do Rio Pardo',
		'BR3546603' => 'Santa Fé do Sul',
		'BR3546702' => 'Santa Gertrudes',
		'BR3547502' => 'Santa Rita do Passa Quatro',
		'BR3547601' => 'Santa Rosa de Viterbo',
		'BR3547700' => 'Santo Anastácio',
		'BR3548005' => 'Santo Antônio de Posse',
		'BR3549409' => 'São Joaquim da Barra',
		'BR3550100' => 'São Manuel',
		'BR3550209' => 'São Miguel Arcanjo',
		'BR3550407' => 'São Pedro',
		'BR3551603' => 'Serra Negra',
		'BR3551504' => 'Serrana',
		'BR3552106' => 'Socorro',
		'BR3553302' => 'Tambaú',
		'BR3553401' => 'Tanabi',
		'BR3553807' => 'Taquarituba',
		'BR3554300' => 'Teodoro Sampaio',
		'BR3554508' => 'Tietê',
		'BR3554805' => 'Tremembé',
		'BR3556305' => 'Valparaíso',
		'BR3556404' => 'Vargem Grande do Sul',
		'BR3556453' => 'Vargem Grande Paulista',
		'BR3501905' => 'Amparo',
		'BR3502101' => 'Andradina',
		'BR3503901' => 'Arujá',
		'BR3504008' => 'Assis',
		'BR3504503' => 'Avaré',
		'BR3505906' => 'Batatais',
		'BR3506102' => 'Bebedouro',
		'BR3508504' => 'Caçapava',
		'BR3509007' => 'Caieiras',
		'BR3509205' => 'Cajamar',
		'BR3509601' => 'Campo Limpo Paulista',
		'BR3512803' => 'Cosmópolis',
		'BR3513405' => 'Cruzeiro',
		'BR3515103' => 'Embu-Guaçu',
		'BR3515509' => 'Fernandópolis',
		'BR3519600' => 'Ibitinga',
		'BR3519709' => 'Ibiúna',
		'BR3522109' => 'Itanhaém',
		'BR3522406' => 'Itapeva',
		'BR3522604' => 'Itapira',
		'BR3524303' => 'Jaboticabal',
		'BR3526704' => 'Leme',
		'BR3526803' => 'Lençóis Paulista',
		'BR3527108' => 'Lins',
		'BR3527207' => 'Lorena',
		'BR3528502' => 'Mairiporã',
		'BR3529302' => 'Matão',
		'BR3530300' => 'Mirassol',
		'BR3530508' => 'Mococa',
		'BR3530805' => 'Moji Mirim',
		'BR3533403' => 'Nova Odessa',
		'BR3533908' => 'Olímpia',
		'BR3536505' => 'Paulínia',
		'BR3537305' => 'Penápolis',
		'BR3537602' => 'Peruíbe',
		'BR3537800' => 'Piedade',
		'BR3539301' => 'Pirassununga',
		'BR3540705' => 'Porto Ferreira',
		'BR3542602' => 'Registro',
		'BR3546801' => 'Santa Isabel',
		'BR3549102' => 'São João da Boa Vista',
		'BR3549706' => 'São José do Rio Pardo',
		'BR3550605' => 'São Roque',
		'BR3550704' => 'São Sebastião',
		'BR3553708' => 'Taquaritinga',
		'BR3555000' => 'Tupã',
		'BR3555406' => 'Ubatuba',
		'BR3556701' => 'Vinhedo',
		'BR3557105' => 'Votuporanga',
		'BR3501608' => 'Americana',
		'BR3502804' => 'Araçatuba',
		'BR3503208' => 'Araraquara',
		'BR3503307' => 'Araras',
		'BR3504107' => 'Atibaia',
		'BR3505500' => 'Barretos',
		'BR3505708' => 'Barueri',
		'BR3506003' => 'Bauru',
		'BR3506508' => 'Birigui',
		'BR3507506' => 'Botucatu',
		'BR3507605' => 'Bragança Paulista',
		'BR3510500' => 'Caraguatatuba',
		'BR3510609' => 'Carapicuíba',
		'BR3511102' => 'Catanduva',
		'BR3513009' => 'Cotia',
		'BR3513504' => 'Cubatão',
		'BR3513801' => 'Diadema',
		'BR3515004' => 'Embu',
		'BR3515707' => 'Ferraz de Vasconcelos',
		'BR3516200' => 'Franca',
		'BR3516309' => 'Francisco Morato',
		'BR3516408' => 'Franco da Rocha',
		'BR3518404' => 'Guaratinguetá',
		'BR3518701' => 'Guarujá',
		'BR3519071' => 'Hortolândia',
		'BR3520509' => 'Indaiatuba',
		'BR3522208' => 'Itapecerica da Serra',
		'BR3522307' => 'Itapetininga',
		'BR3522505' => 'Itapevi',
		'BR3523107' => 'Itaquaquecetuba',
		'BR3523404' => 'Itatiba',
		'BR3523909' => 'Itu',
		'BR3524402' => 'Jacareí',
		'BR3525003' => 'Jandira',
		'BR3525300' => 'Jaú',
		'BR3525904' => 'Jundiaí',
		'BR3526902' => 'Limeira',
		'BR3529005' => 'Marília',
		'BR3529401' => 'Mauá',
		'BR3530607' => 'Mogi das Cruzes',
		'BR3530706' => 'Mogi Guaçu',
		'BR3534708' => 'Ourinhos',
		'BR3538006' => 'Pindamonhangaba',
		'BR3538709' => 'Piracicaba',
		'BR3539806' => 'Poá',
		'BR3541000' => 'Praia Grande',
		'BR3541406' => 'Presidente Prudente',
		'BR3543303' => 'Ribeirão Pires',
		'BR3543907' => 'Rio Claro',
		'BR3545209' => 'Salto',
		'BR3545803' => 'Santa Bárbara dOeste',
		'BR3547304' => 'Santana de Parnaíba',
		'BR3548500' => 'Santos',
		'BR3548807' => 'São Caetano do Sul',
		'BR3548906' => 'São Carlos',
		'BR3549805' => 'São José do Rio Preto',
		'BR3551009' => 'São Vicente',
		'BR3551702' => 'Sertãozinho',
		'BR3552403' => 'Sumaré',
		'BR3552502' => 'Suzano',
		'BR3552809' => 'Taboão da Serra',
		'BR3554003' => 'Tatuí',
		'BR3554102' => 'Taubaté',
		'BR3556206' => 'Valinhos',
		'BR3556503' => 'Várzea Paulista',
		'BR3557006' => 'Votorantim',
		'BR3509502' => 'Campinas',
		'BR3518800' => 'Guarulhos',
		'BR3534401' => 'Osasco',
		'BR3543402' => 'Ribeirão Preto',
		'BR3547809' => 'Santo André',
		'BR3548708' => 'São Bernardo do Campo',
		'BR3549904' => 'São José dos Campos',
		'BR3550308' => 'São Paulo',
		'BR3552205' => 'Sorocaba',
	],
	'TO' => [
		'BR1700251' => 'Abreulândia',
		'BR1701051' => 'Angico',
		'BR1701101' => 'Aparecida do Rio Negro',
		'BR1702703' => 'Aurora do Tocantins',
		'BR1703057' => 'Bandeirantes do Tocantins',
		'BR1703073' => 'Barra do Ouro',
		'BR1703206' => 'Bernardo Sayão',
		'BR1703305' => 'Bom Jesus do Tocantins',
		'BR1703602' => 'Brasilândia do Tocantins',
		'BR1703826' => 'Cachoeirinha',
		'BR1703867' => 'Cariri do Tocantins',
		'BR1703883' => 'Carmolândia',
		'BR1703891' => 'Carrasco Bonito',
		'BR1703909' => 'Caseara',
		'BR1704105' => 'Centenário',
		'BR1705102' => 'Chapada da Natividade',
		'BR1704600' => 'Chapada de Areia',
		'BR1705557' => 'Combinado',
		'BR1705607' => 'Conceição do Tocantins',
		'BR1706258' => 'Crixás do Tocantins',
		'BR1707306' => 'Dueré',
		'BR1707553' => 'Fátima',
		'BR1708254' => 'Fortaleza do Tabocão',
		'BR1708304' => 'Goianorte',
		'BR1709807' => 'Ipueiras',
		'BR1710904' => 'Itapiratins',
		'BR1711100' => 'Itaporã do Tocantins',
		'BR1711506' => 'Jaú do Tocantins',
		'BR1711803' => 'Juarina',
		'BR1711951' => 'Lagoa do Tocantins',
		'BR1712009' => 'Lajeado',
		'BR1712157' => 'Lavandeira',
		'BR1712405' => 'Lizarda',
		'BR1712454' => 'Luzinópolis',
		'BR1712504' => 'Marianópolis do Tocantins',
		'BR1712702' => 'Mateiros',
		'BR1712801' => 'Maurilândia do Tocantins',
		'BR1713700' => 'Monte Santo do Tocantins',
		'BR1713957' => 'Muricilândia',
		'BR1714302' => 'Nazaré',
		'BR1715002' => 'Nova Rosalândia',
		'BR1715101' => 'Novo Acordo',
		'BR1715150' => 'Novo Alegre',
		'BR1715259' => 'Novo Jardim',
		'BR1715507' => 'Oliveira de Fátima',
		'BR1715705' => 'Palmeirante',
		'BR1716307' => 'Pau DArco',
		'BR1717008' => 'Pindorama do Tocantins',
		'BR1717206' => 'Piraquê',
		'BR1717800' => 'Ponte Alta do Bom Jesus',
		'BR1718006' => 'Porto Alegre do Tocantins',
		'BR1718402' => 'Presidente Kennedy',
		'BR1718451' => 'Pugmil',
		'BR1718501' => 'Recursolândia',
		'BR1718550' => 'Riachinho',
		'BR1718659' => 'Rio da Conceição',
		'BR1718709' => 'Rio dos Bois',
		'BR1718808' => 'Sampaio',
		'BR1718840' => 'Sandolândia',
		'BR1718881' => 'Santa Maria do Tocantins',
		'BR1718899' => 'Santa Rita do Tocantins',
		'BR1718907' => 'Santa Rosa do Tocantins',
		'BR1719004' => 'Santa Tereza do Tocantins',
		'BR1720002' => 'Santa Terezinha do Tocantins',
		'BR1720101' => 'São Bento do Tocantins',
		'BR1720150' => 'São Félix do Tocantins',
		'BR1720259' => 'São Salvador do Tocantins',
		'BR1720309' => 'São Sebastião do Tocantins',
		'BR1720499' => 'São Valério',
		'BR1720853' => 'Sucupira',
		'BR1720937' => 'Taipas do Tocantins',
		'BR1720978' => 'Talismã',
		'BR1721257' => 'Tupirama',
		'BR1721307' => 'Tupiratins',
		'BR1700301' => 'Aguiarnópolis',
		'BR1700350' => 'Aliança do Tocantins',
		'BR1700400' => 'Almas',
		'BR1700707' => 'Alvorada',
		'BR1701002' => 'Ananás',
		'BR1701309' => 'Aragominas',
		'BR1701903' => 'Araguacema',
		'BR1702000' => 'Araguaçu',
		'BR1702158' => 'Araguanã',
		'BR1702307' => 'Arapoema',
		'BR1702901' => 'Axixá do Tocantins',
		'BR1703107' => 'Barrolândia',
		'BR1703701' => 'Brejinho de Nazaré',
		'BR1703800' => 'Buriti do Tocantins',
		'BR1703842' => 'Campos Lindos',
		'BR1716703' => 'Colméia',
		'BR1706001' => 'Couto Magalhães',
		'BR1706100' => 'Cristalândia',
		'BR1706506' => 'Darcinópolis',
		'BR1707108' => 'Divinópolis do Tocantins',
		'BR1707207' => 'Dois Irmãos do Tocantins',
		'BR1707405' => 'Esperantina',
		'BR1707652' => 'Figueirópolis',
		'BR1707702' => 'Filadélfia',
		'BR1710508' => 'Itacajá',
		'BR1710706' => 'Itaguatins',
		'BR1713601' => 'Monte do Carmo',
		'BR1714203' => 'Natividade',
		'BR1713809' => 'Palmeiras do Tocantins',
		'BR1715754' => 'Palmeirópolis',
		'BR1716653' => 'Pequizeiro',
		'BR1717503' => 'Pium',
		'BR1717909' => 'Ponte Alta do Tocantins',
		'BR1718303' => 'Praia Norte',
		'BR1718758' => 'Rio Sono',
		'BR1718865' => 'Santa Fé do Araguaia',
		'BR1720655' => 'Silvanópolis',
		'BR1720804' => 'Sítio Novo do Tocantins',
		'BR1721109' => 'Tocantínia',
		'BR1702406' => 'Arraias',
		'BR1702554' => 'Augustinópolis',
		'BR1703008' => 'Babaçulândia',
		'BR1707009' => 'Dianópolis',
		'BR1708205' => 'Formoso do Araguaia',
		'BR1709005' => 'Goiatins',
		'BR1711902' => 'Lagoa da Confusão',
		'BR1713304' => 'Miranorte',
		'BR1714880' => 'Nova Olinda',
		'BR1716208' => 'Paranã',
		'BR1716505' => 'Pedro Afonso',
		'BR1716604' => 'Peixe',
		'BR1720200' => 'São Miguel do Tocantins',
		'BR1720903' => 'Taguatinga',
		'BR1722081' => 'Wanderlândia',
		'BR1722107' => 'Xambioá',
		'BR1702208' => 'Araguatins',
		'BR1705508' => 'Colinas do Tocantins',
		'BR1709302' => 'Guaraí',
		'BR1713205' => 'Miracema do Tocantins',
		'BR1716109' => 'Paraíso do Tocantins',
		'BR1718204' => 'Porto Nacional',
		'BR1721208' => 'Tocantinópolis',
		'BR1709500' => 'Gurupi',
		'BR1702109' => 'Araguaína',
		'BR1721000' => 'Palmas',
	]
];
