<?php

/**
 * List of cities for: Bolivia
 * Source: https://www.ine.gob.bo/index.php/censos-y-banco-de-datos/censos/
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = ( include WC()->plugin_path() . '/i18n/states.php' )['BO'];

$country_cities = [
	'BO-H' => [
		'BOSUCRE' => 'Sucre',
		'BOYOTALA' => 'Yotala',
		'BOPOROMA' => 'Poroma',
		'BOAZURDUY' => 'Azurduy',
		'BOTARVITA' => 'Tarvita',
		'BOZUDÁÑEZ' => 'Zudáñez',
		'BOPRESTO' => 'Presto',
		'BOMOJOCOYA' => 'Mojocoya',
		'BOICLA' => 'Icla',
		'BOPADILLA' => 'Padilla',
		'BOTOMINA' => 'Tomina',
		'BOSOPACHUY' => 'Sopachuy',
		'BOVILLA_ALCALÁ' => 'Villa Alcalá',
		'BOEL_VILLAR' => 'El Villar',
		'BOMONTEAGUDO' => 'Monteagudo',
		'BOHUACARETA' => 'Huacareta',
		'BOTARABUCO' => 'Tarabuco',
		'BOYAMPARÁEZ' => 'Yamparáez',
		'BOCAMARGO' => 'Camargo',
		'BOSAN_LUCAS' => 'San Lucas',
		'BOINCAHUASI' => 'Incahuasi',
		'BOVILLA_CHARCAS' => 'Villa Charcas',
		'BOVILLA_SERRANO' => 'Villa Serrano',
		'BOVILLA_ABECIA' => 'Villa Abecia',
		'BOCULPINA' => 'Culpina',
		'BOLAS_CARRERAS' => 'Las Carreras',
		'BOMUYUPAMPA' => 'Muyupampa',
		'BOHUACAYA' => 'Huacaya',
		'BOMACHARETÍ' => 'Macharetí',
	],
	'BO-L' => [
		'BOLA_PAZ' => 'La Paz',
		'BOPALCA' => 'Palca',
		'BOMECAPACA' => 'Mecapaca',
		'BOACHOCALLA' => 'Achocalla',
		'BOEL_ALTO' => 'El Alto',
		'BOACHACACHI' => 'Achacachi',
		'BOANCORAIMES' => 'Ancoraimes',
		'BOCHUA_COCANI' => 'Chua Cocani',
		'BOHUARINA' => 'Huarina',
		'BOSANTIAGO_DE_HUATA' => 'Santiago de Huata',
		'BOHUATAJATA' => 'Huatajata',
		'BOCOROCORO' => 'Corocoro',
		'BOCAQUIAVIRI' => 'Caquiaviri',
		'BOCALACOTO' => 'Calacoto',
		'BOCOMANCHE' => 'Comanche',
		'BOCHARAÑA' => 'Charaña',
		'BOWALDO_BALLIVIÁN' => 'Waldo Ballivián',
		'BONAZACARA_DE_PACAJES' => 'Nazacara de Pacajes',
		'BOCALLAPA' => 'Callapa',
		'BOPUERTO_ACOSTA' => 'Puerto Acosta',
		'BOMOCOMOCO' => 'Mocomoco',
		'BOPTO._CARABUCO' => 'Pto. Carabuco',
		'BOHUMANATA' => 'Humanata',
		'BOESCOMA' => 'Escoma',
		'BOCHUMA' => 'Chuma',
		'BOAYATA' => 'Ayata',
		'BOAUCAPATA' => 'Aucapata',
		'BOSORATA' => 'Sorata',
		'BOGUANAY' => 'Guanay',
		'BOTACACOMA' => 'Tacacoma',
		'BOQUIABAYA' => 'Quiabaya',
		'BOCOMBAYA' => 'Combaya',
		'BOTIPUANI' => 'Tipuani',
		'BOMAPIRI' => 'Mapiri',
		'BOTEOPONTE' => 'Teoponte',
		'BOAPOLO' => 'Apolo',
		'BOPELECHUCO' => 'Pelechuco',
		'BOVIACHA' => 'Viacha',
		'BOGUAQUI' => 'Guaqui',
		'BOTIAHUANACU' => 'Tiahuanacu',
		'BODESAGUADERO' => 'Desaguadero',
		'BOSAN_ANDRÉS_DE_MACHACA' => 'San Andrés de Machaca',
		'BOJESÚS_DE_MACHACA' => 'Jesús de Machaca',
		'BOTARACO' => 'Taraco',
		'BOLURIBAY' => 'Luribay',
		'BOSAPAHAQUI' => 'Sapahaqui',
		'BOYACO' => 'Yaco',
		'BOMALLA' => 'Malla',
		'BOCAIROMA' => 'Cairoma',
		'BOINQUISIVI' => 'Inquisivi',
		'BOQUIME' => 'Quime',
		'BOCAJUATA' => 'Cajuata',
		'BOCOLQUIRI' => 'Colquiri',
		'BOICHOCA' => 'Ichoca',
		'BOVILLA_LIBERTAD_LICOMA' => 'Villa Libertad Licoma',
		'BOCHULUMANI' => 'Chulumani',
		'BOIRUPANA' => 'Irupana',
		'BOYANACACHI' => 'Yanacachi',
		'BOPALOS_BLANCOS' => 'Palos Blancos',
		'BOLA_ASUNTA' => 'La Asunta',
		'BOPUCARANI' => 'Pucarani',
		'BOLAJA' => 'Laja',
		'BOBATALLAS' => 'Batallas',
		'BOPUERTO_PÉREZ' => 'Puerto Pérez',
		'BOSICA_SICA' => 'Sica Sica',
		'BOUMALA' => 'Umala',
		'BOAYO_AYO' => 'Ayo Ayo',
		'BOCALAMARCA' => 'Calamarca',
		'BOPATACAMAYA' => 'Patacamaya',
		'BOCOLQUENCHA' => 'Colquencha',
		'BOCOLLANA' => 'Collana',
		'BOCOROICO' => 'Coroico',
		'BOCORIPATA' => 'Coripata',
		'BOIXIAMAS' => 'Ixiamas',
		'BOSAN_BUENAVENTURA' => 'San Buenaventura',
		'BOCHARAZANI' => 'Charazani',
		'BOCURVA' => 'Curva',
		'BOCOPACABANA' => 'Copacabana',
		'BOSAN_PEDRO_DE_TIQUINA' => 'San Pedro de Tiquina',
		'BOTITO_YUPANQUI' => 'Tito Yupanqui',
		'BOSAN_PEDRO_CUARAHUARA' => 'San Pedro Cuarahuara',
		'BOPAPEL_PAMPA' => 'Papel Pampa',
		'BOCHACARILLA' => 'Chacarilla',
		'BOSANTIAGO_DE_MACHACA' => 'Santiago de Machaca',
		'BOCATACORA' => 'Catacora',
		'BOCARANAVI' => 'Caranavi',
		'BOALTO_BENI' => 'Alto Beni',
	],
	'BO-C' => [
		'BOCOCHABAMBA' => 'Cochabamba',
		'BOAIQUILE' => 'Aiquile ',
		'BOPASORAPA' => 'Pasorapa ',
		'BOOMEREQUE' => 'Omereque ',
		'BOINDEPENDENCIA' => 'Independencia',
		'BOMOROCHATA' => 'Morochata ',
		'BOCOCAPATA' => 'Cocapata',
		'BOTARATA' => 'Tarata ',
		'BOANZALDO' => 'Anzaldo ',
		'BOARBIETO' => 'Arbieto ',
		'BOSACABAMBA' => 'Sacabamba ',
		'BOARANI' => 'Arani ',
		'BOVACAS' => 'Vacas ',
		'BOARQUE' => 'Arque ',
		'BOTACOPAYA' => 'Tacopaya ',
		'BOCAPINOTA' => 'Capinota ',
		'BOSANTIVÁÑEZ' => 'Santiváñez ',
		'BOSICAYA' => 'Sicaya ',
		'BOCLIZA' => 'Cliza ',
		'BOTOCO' => 'Toco ',
		'BOTOLATA' => 'Tolata ',
		'BOQUILLACOLLO' => 'Quillacollo ',
		'BOSIPESIPE' => 'Sipesipe ',
		'BOTIQUIPAYA' => 'Tiquipaya ',
		'BOVINTO' => 'Vinto ',
		'BOCOLCAPIRHUA' => 'Colcapirhua ',
		'BOSACABA' => 'Sacaba ',
		'BOCOLOMI' => 'Colomi ',
		'BOVILLATUNARI' => 'Villa Tunari ',
		'BOTAPACARÍ' => 'Tapacarí ',
		'BOTOTORA' => 'Totora ',
		'BOPOJO' => 'Pojo ',
		'BOPOCONA' => 'Pocona ',
		'BOCHIMORÉ' => 'Chimoré ',
		'BOPUERTO_VILLARROEL' => 'Puerto Villarroel ',
		'BOENTRE_RÍOS' => 'Entre Ríos',
		'BOMIZQUE' => 'Mizque ',
		'BOVILA_VILA' => 'Vila Vila ',
		'BOALALAY' => 'Alalay ',
		'BOPUNATA' => 'Punata ',
		'BOVILLA_RIVERO' => 'Villa Rivero ',
		'BOSAN_BENITO' => 'San Benito ',
		'BOTACACHI' => 'Tacachi ',
		'BOCUCHUMUELA' => 'Cuchumuela ',
		'BOBOLÍVAR' => 'Bolívar ',
		'BOTIRAQUE' => 'Tiraque ',
		'BOSHINAHOTA' => 'Shinahota',
	],
	'BO-O' => [
		'BOORURO' => 'Oruro',
		'BOCARACOLLO' => 'Caracollo',
		'BOEL_CHORO' => 'El Choro',
		'BOSORACACHI' => 'Soracachi',
		'BOCHALLAPATA' => 'Challapata',
		'BOQUILLACAS' => 'Quillacas',
		'BOCORQUE' => 'Corque',
		'BOCHOQUE_COTA' => 'Choque Cota',
		'BOCURAHUARA_DE_CARANGAS' => 'Curahuara de Carangas',
		'BOTURCO' => 'Turco',
		'BOHUACHACALLA' => 'Huachacalla',
		'BOESCARA' => 'Escara',
		'BOCRUZ_DE_MACHACAMARCA' => 'Cruz de Machacamarca',
		'BOYUNGUYO_DE_LITORAL' => 'Yunguyo de Litoral',
		'BOESMERALDA' => 'Esmeralda',
		'BOPOOPÓ' => 'Poopó',
		'BOPAZÑA' => 'Pazña',
		'BOANTEQUERA' => 'Antequera',
		'BOHUANUNI' => 'Huanuni',
		'BOMACHACAMARCA' => 'Machacamarca',
		'BOSALINAS_DE_GARCÍA_MENDOZA' => 'Salinas de García Mendoza',
		'BOPAMPA_AULLAGAS' => 'Pampa Aullagas',
		'BOSABAYA' => 'Sabaya',
		'BOCOIPASA' => 'Coipasa',
		'BOCHIPAYA' => 'Chipaya',
		'BOTOLEDO' => 'Toledo',
		'BOEUCALIPTUS' => 'Eucaliptus',
		'BOSANTIAGO_DE_ANDAMARCA' => 'Santiago de Andamarca',
		'BOBELÉN_DE_ANDAMARCA' => 'Belén de Andamarca',
		'BOSAN_PEDRO_DE_TOTORA' => 'San Pedro de Totora',
		'BOHUARI' => 'Huari',
		'BOLA_RIVERA' => 'La Rivera',
		'BOTODOS_SANTOS' => 'Todos Santos',
		'BOCARANGAS' => 'Carangas',
		'BOHUAYLLAMARCA' => 'Huayllamarca',
	],
	'BO-P' => [
		'BOPOTOSÍ' => 'Potosí',
		'BOTINGUIPAYA' => 'Tinguipaya',
		'BOYOCALLA' => 'Yocalla',
		'BOURMIRI' => 'Urmiri',
		'BOUNCÍA' => 'Uncía',
		'BOCHAYANTA' => 'Chayanta',
		'BOLLALLAGUA' => 'Llallagua',
		'BOCHUQUIHUTA_AYLLU_JUCUMANI' => 'Chuquihuta Ayllu Jucumani',
		'BOBETANZOS' => 'Betanzos',
		'BOCHAQUÍ' => 'Chaquí',
		'BOTACOBAMBA' => 'Tacobamba',
		'BOCOLQUECHACA' => 'Colquechaca',
		'BORAVELO' => 'Ravelo',
		'BOPOCOATA' => 'Pocoata',
		'BOOCURÍ' => 'Ocurí',
		'BOS.P._DE_BUENA_VISTA' => 'S.P. De Buena Vista',
		'BOTORO_TORO' => 'Toro Toro',
		'BOCOTAGAITA' => 'Cotagaita',
		'BOVITICHI' => 'Vitichi',
		'BOVILLA_DE_SACACA' => 'Villa de Sacaca',
		'BOCARIPUYO' => 'Caripuyo',
		'BOTUPIZA' => 'Tupiza',
		'BOATOCHA' => 'Atocha',
		'BOCOLCHA_K' => 'Colcha K',
		'BOSAN_PEDRO_DE_QUEMES' => 'San Pedro de Quemes',
		'BOSAN_PABLO_DE_LIPEZ' => 'San Pablo de Lipez',
		'BOMOJINETE' => 'Mojinete',
		'BOSAN_ANTONIO_DE_ESMORUCO' => 'San Antonio de Esmoruco',
		'BOPUNA' => 'Puna',
		'BOCAIZA_D' => 'Caiza D',
		'BOCKOCHAS' => 'Ckochas',
		'BOUYUNI' => 'Uyuni',
		'BOTOMAVE' => 'Tomave',
		'BOPORCO' => 'Porco',
		'BOARAMPAMPA' => 'Arampampa',
		'BOACASIO' => 'Acasio',
		'BOLLICA' => 'Llica',
		'BOTAHUA' => 'Tahua',
		'BOVILLAZÓN' => 'Villazón',
		'BOSAN_AGUSTÍN' => 'San Agustín',
	],
	'BO-T' => [
		'BOTARIJA' => 'Tarija',
		'BOPADCAYA' => 'Padcaya',
		'BOBERMEJO' => 'Bermejo',
		'BOYACUIBA' => 'Yacuiba',
		'BOCARAPARÍ' => 'Caraparí',
		'BOVILLAMONTES' => 'Villamontes',
		'BOURIONDO' => 'Uriondo',
		'BOYUNCHARÁ' => 'Yunchará',
		'BOVILLA_SAN_LORENZO' => 'Villa San Lorenzo',
		'BOEL_PUENTE' => 'El Puente',
		'BOENTRE_RÍOS' => 'Entre Ríos',
	],
	'BO-S' => [
		'BOSANTA_CRUZ_DE_LA_SIERRA' => 'Santa Cruz de la Sierra',
		'BOCOTOCA' => 'Cotoca',
		'BOPORONGO' => 'Porongo',
		'BOLA_GUARDIA' => 'La Guardia',
		'BOEL_TORNO' => 'El Torno',
		'BOWARNES' => 'Warnes',
		'BOOKINAWA_UNO' => 'Okinawa Uno',
		'BOSAN_IGNACIO_DE_VELASCO' => 'San Ignacio de Velasco',
		'BOSAN_MIGUEL_DE_VELASCO' => 'San Miguel de Velasco',
		'BOSAN_RAFAEL' => 'San Rafael',
		'BOBUENA_VISTA' => 'Buena Vista',
		'BOSAN_CARLOS' => 'San Carlos',
		'BOYAPACANÍ' => 'Yapacaní',
		'BOSAN_JUAN' => 'San Juan',
		'BOSAN_JOSÉ_DE_CHIQUITOS' => 'San José de Chiquitos',
		'BOPAILÓN' => 'Pailón',
		'BOROBORÉ' => 'Roboré',
		'BOPORTACHUELO' => 'Portachuelo',
		'BOSANTA_ROSA_DEL_SARA' => 'Santa Rosa del Sara',
		'BOCOLPA_BELGICA' => 'Colpa Belgica',
		'BOLAGUNILLAS' => 'Lagunillas',
		'BOCHARAGUA' => 'Charagua',
		'BOCABEZAS' => 'Cabezas',
		'BOCUEVO' => 'Cuevo',
		'BOGUTIÉRREZ' => 'Gutiérrez',
		'BOCAMIRI' => 'Camiri',
		'BOBOYUIBE' => 'Boyuibe',
		'BOVALLEGRANDE' => 'Vallegrande',
		'BOTRIGAL' => 'Trigal',
		'BOMORO_MORO' => 'Moro Moro',
		'BOPOSTRER_VALLE' => 'Postrer Valle',
		'BOPUCARA' => 'Pucara',
		'BOSAMAIPATA' => 'Samaipata',
		'BOPAMPA_GRANDE' => 'Pampa Grande',
		'BOMAIRANA' => 'Mairana',
		'BOQUIRUSILLAS' => 'Quirusillas',
		'BOMONTERO' => 'Montero',
		'BOGRAL._SAAVEDRA' => 'Gral. Saavedra',
		'BOMINEROS' => 'Mineros',
		'BOFERNÁNDEZ_ALONSO' => 'Fernández Alonso',
		'BOSAN_PEDRO' => 'San Pedro',
		'BOCONCEPCIÓN' => 'Concepción',
		'BOSAN_JAVIER' => 'San Javier',
		'BOSAN_RAMÓN' => 'San Ramón',
		'BOSAN_JULIÁN' => 'San Julián',
		'BOSAN_ANTONIO_DE_LOMERÍO' => 'San Antonio de Lomerío',
		'BOCUATRO_CAÑADAS' => 'Cuatro Cañadas',
		'BOSAN_MATÍAS' => 'San Matías',
		'BOCOMARAPA' => 'Comarapa',
		'BOSAIPINA' => 'Saipina',
		'BOPUERTO_SUAREZ' => 'Puerto Suarez',
		'BOPUERTO_QUIJARRO' => 'Puerto Quijarro',
		'BOCARMEN_RIVERO_TORREZ' => 'Carmen Rivero Torrez',
		'BOASCENSIÓN_DE_GUARAYOS' => 'Ascensión de Guarayos',
		'BOURUBICHÁ' => 'Urubichá',
		'BOEL_PUENTE' => 'El Puente',
	],
	'BO-B' => [
		'BOTRINIDAD' => 'Trinidad ',
		'BOSAN_JAVIER' => 'San Javier ',
		'BORIBERALTA' => 'Riberalta ',
		'BOGUAYARAMERÍN' => 'Guayaramerín ',
		'BOREYES' => 'Reyes ',
		'BOSAN_BORJA' => 'San Borja ',
		'BOSANTA_ROSA' => 'Santa Rosa ',
		'BORURRENABAQUE' => 'Rurrenabaque ',
		'BOSANTA_ANA_DEL_YACUMA' => 'Santa Ana del Yacuma ',
		'BOEXALTACIÓN' => 'Exaltación ',
		'BOSAN_IGNACIO' => 'San Ignacio ',
		'BOLORETO' => 'Loreto',
		'BOSAN_ANDRÉS' => 'San Andrés ',
		'BOSAN_JOAQUÍN' => 'San Joaquín ',
		'BOSAN_RAMÓN' => 'San Ramón ',
		'BOPUERTO_SILES' => 'Puerto Siles ',
		'BOMAGDALENA' => 'Magdalena ',
		'BOBAURES' => 'Baures ',
		'BOHUACARAJE' => 'Huacaraje ',
	],
	'BO-N' => [
		'BOCOBIJA' => 'Cobija',
		'BOPORVENIR' => 'Porvenir',
		'BOBOLPEBRA' => 'Bolpebra',
		'BOBELLA_FLOR' => 'Bella Flor',
		'BOPUERTO_RICO' => 'Puerto Rico',
		'BOSAN_PEDRO' => 'San Pedro',
		'BOFILADELFIA' => 'Filadelfia',
		'BOPUERTO_GONZALES_MORENO' => 'Puerto Gonzales Moreno',
		'BOSAN_LORENZO' => 'San Lorenzo',
		'BOEL_SENA' => 'El Sena',
		'BOSANTA_ROSA' => 'Santa Rosa',
		'BOINGAVI' => 'Ingavi',
		'BONUEVA_ESPERANZA' => 'Nueva Esperanza',
		'BOVILLA_NUEVA_-_LOMA_ALTA' => 'Villa Nueva - Loma Alta',
		'BOSANTOS_MERCADO' => 'Santos Mercado',
	],
];
