<?php

/**
 * List of cities for: Austria
 * Source: https://ec.europa.eu/eurostat/web/nuts/local-administrative-units
 * Version: 1.0
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_cities = [
	'AT10101' => 'Eisenstadt',
	'AT10201' => 'Rust',
	'AT10301' => 'Breitenbrunn am Neusiedler See',
	'AT10302' => 'Donnerskirchen',
	'AT10303' => 'Großhöflein',
	'AT10304' => 'Hornstein',
	'AT10305' => 'Klingenbach',
	'AT10306' => 'Leithaprodersdorf',
	'AT10307' => 'Mörbisch am See',
	'AT10308' => 'Müllendorf',
	'AT10309' => 'Neufeld an der Leitha',
	'AT10310' => 'Oggau am Neusiedler See',
	'AT10311' => 'Oslip',
	'AT10312' => 'Purbach am Neusiedler See',
	'AT10313' => 'Sankt Margarethen im Burgenland',
	'AT10314' => 'Schützen am Gebirge',
	'AT10315' => 'Siegendorf',
	'AT10316' => 'Steinbrunn',
	'AT10317' => 'Trausdorf an der Wulka',
	'AT10318' => 'Wimpassing an der Leitha',
	'AT10319' => 'Wulkaprodersdorf',
	'AT10320' => 'Loretto',
	'AT10321' => 'Stotzing',
	'AT10322' => 'Zillingtal',
	'AT10323' => 'Zagersdorf',
	'AT10401' => 'Bocksdorf',
	'AT10402' => 'Burgauberg-Neudauberg',
	'AT10403' => 'Eberau',
	'AT10404' => 'Gerersdorf-Sulz',
	'AT10405' => 'Güssing',
	'AT10406' => 'Güttenbach',
	'AT10407' => 'Heiligenbrunn',
	'AT10408' => 'Kukmirn',
	'AT10409' => 'Neuberg im Burgenland',
	'AT10410' => 'Neustift bei Güssing',
	'AT10411' => 'Olbendorf',
	'AT10412' => 'Ollersdorf im Burgenland',
	'AT10413' => 'Sankt Michael im Burgenland',
	'AT10414' => 'Stegersbach',
	'AT10415' => 'Stinatz',
	'AT10416' => 'Strem',
	'AT10417' => 'Tobaj',
	'AT10418' => 'Hackerberg',
	'AT10419' => 'Wörterberg',
	'AT10420' => 'Großmürbisch',
	'AT10421' => 'Inzenhof',
	'AT10422' => 'Kleinmürbisch',
	'AT10423' => 'Tschanigraben',
	'AT10424' => 'Heugraben',
	'AT10425' => 'Rohr im Burgenland',
	'AT10426' => 'Bildein',
	'AT10427' => 'Rauchwart',
	'AT10428' => 'Moschendorf',
	'AT10501' => 'Deutsch Kaltenbrunn',
	'AT10502' => 'Eltendorf',
	'AT10503' => 'Heiligenkreuz im Lafnitztal',
	'AT10504' => 'Jennersdorf',
	'AT10505' => 'Minihof-Liebau',
	'AT10506' => 'Mogersdorf',
	'AT10507' => 'Neuhaus am Klausenbach',
	'AT10508' => 'Rudersdorf',
	'AT10509' => 'Sankt Martin an der Raab',
	'AT10510' => 'Weichselbaum',
	'AT10511' => 'Königsdorf',
	'AT10512' => 'Mühlgraben',
	'AT10601' => 'Draßburg',
	'AT10602' => 'Forchtenstein',
	'AT10603' => 'Hirm',
	'AT10604' => 'Loipersbach im Burgenland',
	'AT10605' => 'Marz',
	'AT10606' => 'Mattersburg',
	'AT10607' => 'Neudörfl',
	'AT10608' => 'Pöttelsdorf',
	'AT10609' => 'Pöttsching',
	'AT10610' => 'Rohrbach bei Mattersburg',
	'AT10611' => 'Bad Sauerbrunn',
	'AT10612' => 'Schattendorf',
	'AT10613' => 'Sieggraben',
	'AT10614' => 'Sigleß',
	'AT10615' => 'Wiesen',
	'AT10616' => 'Antau',
	'AT10617' => 'Baumgarten',
	'AT10618' => 'Zemendorf-Stöttera',
	'AT10619' => 'Krensdorf',
	'AT10701' => 'Andau',
	'AT10702' => 'Apetlon',
	'AT10703' => 'Bruckneudorf',
	'AT10704' => 'Deutsch Jahrndorf',
	'AT10705' => 'Frauenkirchen',
	'AT10706' => 'Gattendorf',
	'AT10707' => 'Gols',
	'AT10708' => 'Halbturn',
	'AT10709' => 'Illmitz',
	'AT10710' => 'Jois',
	'AT10711' => 'Kittsee',
	'AT10712' => 'Mönchhof',
	'AT10713' => 'Neusiedl am See',
	'AT10714' => 'Nickelsdorf',
	'AT10715' => 'Pama',
	'AT10716' => 'Pamhagen',
	'AT10717' => 'Parndorf',
	'AT10718' => 'Podersdorf am See',
	'AT10719' => 'Sankt Andrä am Zicksee',
	'AT10720' => 'Tadten',
	'AT10721' => 'Wallern im Burgenland',
	'AT10722' => 'Weiden am See',
	'AT10723' => 'Winden am See',
	'AT10724' => 'Zurndorf',
	'AT10725' => 'Neudorf',
	'AT10726' => 'Potzneusiedl',
	'AT10727' => 'Edelstal',
	'AT10801' => 'Deutschkreutz',
	'AT10802' => 'Draßmarkt',
	'AT10803' => 'Frankenau-Unterpullendorf',
	'AT10804' => 'Großwarasdorf',
	'AT10805' => 'Horitschon',
	'AT10806' => 'Kaisersdorf',
	'AT10807' => 'Kobersdorf',
	'AT10808' => 'Lackenbach',
	'AT10809' => 'Lockenhaus',
	'AT10810' => 'Lutzmannsburg',
	'AT10811' => 'Mannersdorf an der Rabnitz',
	'AT10812' => 'Markt Sankt Martin',
	'AT10813' => 'Neckenmarkt',
	'AT10814' => 'Neutal',
	'AT10815' => 'Nikitsch',
	'AT10816' => 'Oberpullendorf',
	'AT10817' => 'Pilgersdorf',
	'AT10818' => 'Piringsdorf',
	'AT10819' => 'Raiding',
	'AT10820' => 'Ritzing',
	'AT10821' => 'Steinberg-Dörfl',
	'AT10822' => 'Stoob',
	'AT10823' => 'Weppersdorf',
	'AT10824' => 'Lackendorf',
	'AT10825' => 'Unterfrauenhaid',
	'AT10826' => 'Unterrabnitz-Schwendgraben',
	'AT10827' => 'Weingraben',
	'AT10828' => 'Oberloisdorf',
	'AT10901' => 'Bad Tatzmannsdorf',
	'AT10902' => 'Bernstein',
	'AT10903' => 'Deutsch Schützen-Eisenberg',
	'AT10904' => 'Grafenschachen',
	'AT10905' => 'Großpetersdorf',
	'AT10906' => 'Hannersdorf',
	'AT10907' => 'Kemeten',
	'AT10908' => 'Kohfidisch',
	'AT10909' => 'Litzelsdorf',
	'AT10910' => 'Loipersdorf-Kitzladen',
	'AT10911' => 'Mariasdorf',
	'AT10912' => 'Markt Allhau',
	'AT10913' => 'Markt Neuhodis',
	'AT10914' => 'Mischendorf',
	'AT10915' => 'Oberdorf im Burgenland',
	'AT10916' => 'Oberschützen',
	'AT10917' => 'Oberwart',
	'AT10918' => 'Pinkafeld',
	'AT10919' => 'Rechnitz',
	'AT10920' => 'Riedlingsdorf',
	'AT10921' => 'Rotenturm an der Pinka',
	'AT10922' => 'Schachendorf',
	'AT10923' => 'Stadtschlaining',
	'AT10924' => 'Unterkohlstätten',
	'AT10925' => 'Unterwart',
	'AT10926' => 'Weiden bei Rechnitz',
	'AT10927' => 'Wiesfleck',
	'AT10928' => 'Wolfau',
	'AT10929' => 'Neustift an der Lafnitz',
	'AT10930' => 'Jabing',
	'AT10931' => 'Badersdorf',
	'AT10932' => 'Schandorf',
	'AT20101' => 'Klagenfurt am Wörthersee',
	'AT20201' => 'Villach',
	'AT20302' => 'Dellach',
	'AT20305' => 'Hermagor-Pressegger See',
	'AT20306' => 'Kirchbach',
	'AT20307' => 'Kötschach-Mauthen',
	'AT20316' => 'St. Stefan im Gailtal',
	'AT20320' => 'Gitschtal',
	'AT20321' => 'Lesachtal',
	'AT20402' => 'Ebenthal in Kärnten',
	'AT20403' => 'Feistritz im Rosental',
	'AT20405' => 'Ferlach',
	'AT20409' => 'Grafenstein',
	'AT20412' => 'Keutschach am See',
	'AT20414' => 'Köttmannsdorf',
	'AT20415' => 'Krumpendorf am Wörthersee',
	'AT20416' => 'Ludmannsdorf',
	'AT20417' => 'Maria Rain',
	'AT20418' => 'Maria Saal',
	'AT20419' => 'Maria Wörth',
	'AT20421' => 'Moosburg',
	'AT20424' => 'Pörtschach am Wörther See',
	'AT20425' => 'Poggersdorf',
	'AT20428' => 'St. Margareten im Rosental',
	'AT20432' => 'Schiefling am Wörthersee',
	'AT20435' => 'Techelsberg am Wörther See',
	'AT20441' => 'Zell',
	'AT20442' => 'Magdalensberg',
	'AT20501' => 'Althofen',
	'AT20502' => 'Brückl',
	'AT20503' => 'Deutsch-Griffen',
	'AT20504' => 'Eberstein',
	'AT20505' => 'Friesach',
	'AT20506' => 'Glödnitz',
	'AT20508' => 'Gurk',
	'AT20509' => 'Guttaring',
	'AT20511' => 'Hüttenberg',
	'AT20512' => 'Kappel am Krappfeld',
	'AT20513' => 'Klein St. Paul',
	'AT20515' => 'Liebenfels',
	'AT20518' => 'Metnitz',
	'AT20519' => 'Micheldorf',
	'AT20520' => 'Mölbling',
	'AT20523' => 'St. Georgen am Längsee',
	'AT20527' => 'St. Veit an der Glan',
	'AT20530' => 'Straßburg',
	'AT20531' => 'Weitensfeld im Gurktal',
	'AT20534' => 'Frauenstein',
	'AT20601' => 'Bad Kleinkirchheim',
	'AT20602' => 'Baldramsdorf',
	'AT20603' => 'Berg im Drautal',
	'AT20604' => 'Dellach im Drautal',
	'AT20605' => 'Großkirchheim',
	'AT20607' => 'Flattach',
	'AT20608' => 'Gmünd in Kärnten',
	'AT20609' => 'Greifenburg',
	'AT20610' => 'Heiligenblut am Großglockner',
	'AT20611' => 'Irschen',
	'AT20613' => 'Kleblach-Lind',
	'AT20616' => 'Lendorf',
	'AT20618' => 'Mallnitz',
	'AT20619' => 'Malta',
	'AT20620' => 'Millstatt am See',
	'AT20622' => 'Mörtschach',
	'AT20624' => 'Mühldorf',
	'AT20625' => 'Oberdrauburg',
	'AT20627' => 'Obervellach',
	'AT20630' => 'Radenthein',
	'AT20631' => 'Rangersdorf',
	'AT20632' => 'Rennweg am Katschberg',
	'AT20633' => 'Sachsenburg',
	'AT20634' => 'Seeboden am Millstätter See',
	'AT20635' => 'Spittal an der Drau',
	'AT20636' => 'Stall',
	'AT20637' => 'Steinfeld',
	'AT20638' => 'Trebesing',
	'AT20639' => 'Weißensee',
	'AT20640' => 'Winklern',
	'AT20642' => 'Krems in Kärnten',
	'AT20643' => 'Lurnfeld',
	'AT20644' => 'Reißeck',
	'AT20701' => 'Afritz am See',
	'AT20702' => 'Arnoldstein',
	'AT20703' => 'Arriach',
	'AT20705' => 'Bad Bleiberg',
	'AT20707' => 'Feistritz an der Gail',
	'AT20708' => 'Feld am See',
	'AT20710' => 'Ferndorf',
	'AT20711' => 'Finkenstein am Faaker See',
	'AT20712' => 'Fresach',
	'AT20713' => 'Hohenthurn',
	'AT20719' => 'Nötsch im Gailtal',
	'AT20720' => 'Paternion',
	'AT20721' => 'Rosegg',
	'AT20722' => 'St. Jakob im Rosental',
	'AT20723' => 'Stockenboi',
	'AT20724' => 'Treffen am Ossiacher See',
	'AT20725' => 'Velden am Wörther See',
	'AT20726' => 'Weißenstein',
	'AT20727' => 'Wernberg',
	'AT20801' => 'Bleiburg',
	'AT20802' => 'Diex',
	'AT20803' => 'Eberndorf',
	'AT20804' => 'Eisenkappel-Vellach',
	'AT20805' => 'Feistritz ob Bleiburg',
	'AT20806' => 'Gallizien',
	'AT20807' => 'Globasnitz',
	'AT20808' => 'Griffen',
	'AT20810' => 'Neuhaus',
	'AT20812' => 'Ruden',
	'AT20813' => 'St. Kanzian am Klopeiner See',
	'AT20815' => 'Sittersdorf',
	'AT20817' => 'Völkermarkt',
	'AT20901' => 'Bad St. Leonhard im Lavanttal',
	'AT20905' => 'Frantschach-St.Gertraud',
	'AT20909' => 'Lavamünd',
	'AT20911' => 'Preitenegg',
	'AT20912' => 'Reichenfels',
	'AT20913' => 'Sankt Andrä',
	'AT20914' => 'St. Georgen im Lavanttal',
	'AT20918' => 'St. Paul im Lavanttal',
	'AT20923' => 'Wolfsberg',
	'AT21001' => 'Albeck',
	'AT21002' => 'Feldkirchen in Kärnten',
	'AT21003' => 'Glanegg',
	'AT21004' => 'Gnesau',
	'AT21005' => 'Himmelberg',
	'AT21006' => 'Ossiach',
	'AT21007' => 'Reichenau',
	'AT21008' => 'St. Urban',
	'AT21009' => 'Steindorf am Ossiacher See',
	'AT21010' => 'Steuerberg',
	'AT30101' => 'Krems an der Donau',
	'AT30201' => 'St. Pölten',
	'AT30301' => 'Waidhofen an der Ybbs',
	'AT30401' => 'Wiener Neustadt',
	'AT30501' => 'Allhartsberg',
	'AT30502' => 'Amstetten',
	'AT30503' => 'Ardagger',
	'AT30504' => 'Aschbach-Markt',
	'AT30506' => 'Behamberg',
	'AT30507' => 'Biberbach',
	'AT30508' => 'Ennsdorf',
	'AT30509' => 'Ernsthofen',
	'AT30510' => 'Ertl',
	'AT30511' => 'Euratsfeld',
	'AT30512' => 'Ferschnitz',
	'AT30514' => 'Haag',
	'AT30515' => 'Haidershofen',
	'AT30516' => 'Hollenstein an der Ybbs',
	'AT30517' => 'Kematen an der Ybbs',
	'AT30520' => 'Neuhofen an der Ybbs',
	'AT30521' => 'Neustadtl an der Donau',
	'AT30522' => 'Oed-Oehling',
	'AT30524' => 'Opponitz',
	'AT30526' => 'St. Georgen am Reith',
	'AT30527' => 'St. Georgen am Ybbsfelde',
	'AT30529' => 'St. Pantaleon-Erla',
	'AT30530' => 'St. Peter in der Au',
	'AT30531' => 'St. Valentin',
	'AT30532' => 'Seitenstetten',
	'AT30533' => 'Sonntagberg',
	'AT30534' => 'Strengberg',
	'AT30536' => 'Viehdorf',
	'AT30538' => 'Wallsee-Sindelburg',
	'AT30539' => 'Weistrach',
	'AT30541' => 'Winklarn',
	'AT30542' => 'Wolfsbach',
	'AT30543' => 'Ybbsitz',
	'AT30544' => 'Zeillern',
	'AT30601' => 'Alland',
	'AT30602' => 'Altenmarkt an der Triesting',
	'AT30603' => 'Bad Vöslau',
	'AT30604' => 'Baden',
	'AT30605' => 'Berndorf',
	'AT30607' => 'Ebreichsdorf',
	'AT30608' => 'Enzesfeld-Lindabrunn',
	'AT30609' => 'Furth an der Triesting',
	'AT30612' => 'Günselsdorf',
	'AT30613' => 'Heiligenkreuz',
	'AT30614' => 'Hernstein',
	'AT30615' => 'Hirtenberg',
	'AT30616' => 'Klausen-Leopoldsdorf',
	'AT30618' => 'Kottingbrunn',
	'AT30620' => 'Leobersdorf',
	'AT30621' => 'Mitterndorf an der Fischa',
	'AT30623' => 'Oberwaltersdorf',
	'AT30625' => 'Pfaffstätten',
	'AT30626' => 'Pottendorf',
	'AT30627' => 'Pottenstein',
	'AT30629' => 'Reisenberg',
	'AT30631' => 'Schönau an der Triesting',
	'AT30633' => 'Seibersdorf',
	'AT30635' => 'Sooß',
	'AT30636' => 'Tattendorf',
	'AT30637' => 'Teesdorf',
	'AT30639' => 'Traiskirchen',
	'AT30641' => 'Trumau',
	'AT30645' => 'Weissenbach an der Triesting',
	'AT30646' => 'Blumau-Neurißhof',
	'AT30701' => 'Au am Leithaberge',
	'AT30702' => 'Bad Deutsch-Altenburg',
	'AT30703' => 'Berg',
	'AT30704' => 'Bruck an der Leitha',
	'AT30706' => 'Enzersdorf an der Fischa',
	'AT30708' => 'Göttlesbrunn-Arbesthal',
	'AT30709' => 'Götzendorf an der Leitha',
	'AT30710' => 'Hainburg a.d.Donau',
	'AT30711' => 'Haslau-Maria Ellend',
	'AT30712' => 'Höflein',
	'AT30713' => 'Hof am Leithaberge',
	'AT30715' => 'Hundsheim',
	'AT30716' => 'Mannersdorf am Leithagebirge',
	'AT30718' => 'Petronell-Carnuntum',
	'AT30719' => 'Prellenkirchen',
	'AT30721' => 'Rohrau',
	'AT30722' => 'Scharndorf',
	'AT30724' => 'Sommerein',
	'AT30726' => 'Trautmannsdorf an der Leitha',
	'AT30728' => 'Wolfsthal',
	'AT30729' => 'Ebergassing',
	'AT30730' => 'Fischamend',
	'AT30731' => 'Gramatneusiedl',
	'AT30732' => 'Himberg',
	'AT30733' => 'Klein-Neusiedl',
	'AT30734' => 'Lanzendorf',
	'AT30735' => 'Leopoldsdorf',
	'AT30736' => 'Maria-Lanzendorf',
	'AT30737' => 'Moosbrunn',
	'AT30738' => 'Rauchenwarth',
	'AT30739' => 'Schwadorf',
	'AT30740' => 'Schwechat',
	'AT30741' => 'Zwölfaxing',
	'AT30801' => 'Aderklaa',
	'AT30802' => 'Andlersdorf',
	'AT30803' => 'Angern an der March',
	'AT30804' => 'Auersthal',
	'AT30805' => 'Bad Pirawarth',
	'AT30808' => 'Deutsch-Wagram',
	'AT30810' => 'Drösing',
	'AT30811' => 'Dürnkrut',
	'AT30812' => 'Ebenthal',
	'AT30813' => 'Eckartsau',
	'AT30814' => 'Engelhartstetten',
	'AT30817' => 'Gänserndorf',
	'AT30819' => 'Glinzendorf',
	'AT30821' => 'Groß-Enzersdorf',
	'AT30822' => 'Großhofen',
	'AT30824' => 'Groß-Schweinbarth',
	'AT30825' => 'Haringsee',
	'AT30826' => 'Hauskirchen',
	'AT30827' => 'Hohenau an der March',
	'AT30828' => 'Hohenruppersdorf',
	'AT30829' => 'Jedenspeigen',
	'AT30830' => 'Lassee',
	'AT30831' => 'Leopoldsdorf im Marchfelde',
	'AT30834' => 'Mannsdorf an der Donau',
	'AT30835' => 'Marchegg',
	'AT30836' => 'Markgrafneusiedl',
	'AT30838' => 'Matzen-Raggendorf',
	'AT30841' => 'Neusiedl an der Zaya',
	'AT30842' => 'Obersiebenbrunn',
	'AT30844' => 'Orth an der Donau',
	'AT30845' => 'Palterndorf-Dobermannsdorf',
	'AT30846' => 'Parbasdorf',
	'AT30848' => 'Prottes',
	'AT30849' => 'Raasdorf',
	'AT30850' => 'Ringelsdorf-Niederabsdorf',
	'AT30852' => 'Schönkirchen-Reyersdorf',
	'AT30854' => 'Spannberg',
	'AT30856' => 'Strasshof an der Nordbahn',
	'AT30857' => 'Sulz im Weinviertel',
	'AT30858' => 'Untersiebenbrunn',
	'AT30859' => 'Velm-Götzendorf',
	'AT30860' => 'Weikendorf',
	'AT30863' => 'Zistersdorf',
	'AT30865' => 'Weiden an der March',
	'AT30902' => 'Amaliendorf-Aalfang',
	'AT30903' => 'Brand-Nagelberg',
	'AT30904' => 'Eggern',
	'AT30906' => 'Eisgarn',
	'AT30908' => 'Gmünd',
	'AT30909' => 'Großdietmanns',
	'AT30910' => 'Bad Großpertholz',
	'AT30912' => 'Großschönau',
	'AT30913' => 'Moorbad Harbach',
	'AT30915' => 'Haugschlag',
	'AT30916' => 'Heidenreichstein',
	'AT30917' => 'Hirschbach',
	'AT30920' => 'Hoheneich',
	'AT30921' => 'Kirchberg am Walde',
	'AT30925' => 'Litschau',
	'AT30929' => 'Reingers',
	'AT30932' => 'St. Martin',
	'AT30935' => 'Schrems',
	'AT30939' => 'Unserfrau-Altweitra',
	'AT30940' => 'Waldenstein',
	'AT30942' => 'Weitra',
	'AT31001' => 'Alberndorf im Pulkautal',
	'AT31008' => 'Göllersdorf',
	'AT31009' => 'Grabern',
	'AT31014' => 'Guntersdorf',
	'AT31015' => 'Hadres',
	'AT31016' => 'Hardegg',
	'AT31018' => 'Haugsdorf',
	'AT31019' => 'Heldenberg',
	'AT31021' => 'Hohenwarth-Mühlbach a.M.',
	'AT31022' => 'Hollabrunn',
	'AT31025' => 'Mailberg',
	'AT31026' => 'Maissau',
	'AT31028' => 'Nappersdorf-Kammersdorf',
	'AT31033' => 'Pernersdorf',
	'AT31035' => 'Pulkau',
	'AT31036' => 'Ravelsbach',
	'AT31037' => 'Retz',
	'AT31038' => 'Retzbach',
	'AT31041' => 'Schrattenthal',
	'AT31042' => 'Seefeld-Kadolz',
	'AT31043' => 'Sitzendorf an der Schmida',
	'AT31051' => 'Wullersdorf',
	'AT31052' => 'Zellerndorf',
	'AT31053' => 'Ziersdorf',
	'AT31101' => 'Altenburg',
	'AT31102' => 'Brunn an der Wild',
	'AT31103' => 'Burgschleinitz-Kühnring',
	'AT31104' => 'Drosendorf-Zissersdorf',
	'AT31105' => 'Eggenburg',
	'AT31106' => 'Gars am Kamp',
	'AT31107' => 'Geras',
	'AT31109' => 'Horn',
	'AT31110' => 'Irnfritz-Messern',
	'AT31111' => 'Japons',
	'AT31113' => 'Langau',
	'AT31114' => 'Meiseldorf',
	'AT31117' => 'Pernegg',
	'AT31119' => 'Röhrenbach',
	'AT31120' => 'Röschitz',
	'AT31121' => 'Rosenburg-Mold',
	'AT31123' => 'St. Bernhard-Frauenhofen',
	'AT31124' => 'Sigmundsherberg',
	'AT31129' => 'Weitersfeld',
	'AT31130' => 'Straning-Grafenberg',
	'AT31201' => 'Bisamberg',
	'AT31202' => 'Enzersfeld im Weinviertel',
	'AT31203' => 'Ernstbrunn',
	'AT31204' => 'Großmugl',
	'AT31205' => 'Großrußbach',
	'AT31206' => 'Hagenbrunn',
	'AT31207' => 'Harmannsdorf',
	'AT31208' => 'Hausleiten',
	'AT31213' => 'Korneuburg',
	'AT31214' => 'Langenzersdorf',
	'AT31215' => 'Leitzersdorf',
	'AT31216' => 'Leobendorf',
	'AT31224' => 'Rußbach',
	'AT31226' => 'Sierndorf',
	'AT31227' => 'Spillern',
	'AT31228' => 'Stetteldorf am Wagram',
	'AT31229' => 'Stetten',
	'AT31230' => 'Stockerau',
	'AT31234' => 'Niederhollabrunn',
	'AT31235' => 'Gerasdorf bei Wien',
	'AT31301' => 'Aggsbach',
	'AT31302' => 'Albrechtsberg an der Großen Krems',
	'AT31303' => 'Bergern im Dunkelsteinerwald',
	'AT31304' => 'Dürnstein',
	'AT31308' => 'Grafenegg',
	'AT31309' => 'Furth bei Göttweig',
	'AT31310' => 'Gedersdorf',
	'AT31311' => 'Gföhl',
	'AT31315' => 'Hadersdorf-Kammern',
	'AT31319' => 'Jaidhof',
	'AT31321' => 'Krumau am Kamp',
	'AT31322' => 'Langenlois',
	'AT31323' => 'Lengenfeld',
	'AT31324' => 'Lichtenau im Waldviertel',
	'AT31326' => 'Maria Laach am Jauerling',
	'AT31327' => 'Mautern an der Donau',
	'AT31330' => 'Mühldorf',
	'AT31333' => 'Paudorf',
	'AT31336' => 'Rastenfeld',
	'AT31337' => 'Rohrendorf bei Krems',
	'AT31338' => 'Rossatz-Arnsdorf',
	'AT31340' => 'St. Leonhard am Hornerwald',
	'AT31343' => 'Senftenberg',
	'AT31344' => 'Spitz',
	'AT31346' => 'Straß im Straßertale',
	'AT31347' => 'Stratzing',
	'AT31350' => 'Weinzierl am Walde',
	'AT31351' => 'Weißenkirchen in der Wachau',
	'AT31355' => 'Schönberg am Kamp',
	'AT31356' => 'Droß',
	'AT31401' => 'Annaberg',
	'AT31402' => 'Eschenau',
	'AT31403' => 'Hainfeld',
	'AT31404' => 'Hohenberg',
	'AT31405' => 'Kaumberg',
	'AT31406' => 'Kleinzell',
	'AT31407' => 'Lilienfeld',
	'AT31408' => 'Mitterbach am Erlaufsee',
	'AT31409' => 'Ramsau',
	'AT31410' => 'Rohrbach an der Gölsen',
	'AT31411' => 'St. Aegyd am Neuwalde',
	'AT31412' => 'St. Veit an der Gölsen',
	'AT31413' => 'Traisen',
	'AT31414' => 'Türnitz',
	'AT31502' => 'Artstetten-Pöbring',
	'AT31503' => 'Bergland',
	'AT31504' => 'Bischofstetten',
	'AT31505' => 'Blindenmarkt',
	'AT31506' => 'Dorfstetten',
	'AT31507' => 'Dunkelsteinerwald',
	'AT31508' => 'Erlauf',
	'AT31509' => 'Golling an der Erlauf',
	'AT31511' => 'Hofamt Priel',
	'AT31513' => 'Hürm',
	'AT31514' => 'Kilb',
	'AT31515' => 'Kirnberg an der Mank',
	'AT31516' => 'Klein-Pöchlarn',
	'AT31517' => 'Krummnußbaum',
	'AT31519' => 'Leiben',
	'AT31520' => 'Loosdorf',
	'AT31521' => 'Mank',
	'AT31522' => 'Marbach an der Donau',
	'AT31523' => 'Maria Taferl',
	'AT31524' => 'Melk',
	'AT31525' => 'Münichreith-Laimbach',
	'AT31527' => 'Neumarkt an der Ybbs',
	'AT31528' => 'Nöchling',
	'AT31530' => 'Persenbeug-Gottsdorf',
	'AT31531' => 'Petzenkirchen',
	'AT31533' => 'Pöchlarn',
	'AT31534' => 'Pöggstall',
	'AT31535' => 'Raxendorf',
	'AT31537' => 'Ruprechtshofen',
	'AT31539' => 'St. Leonhard am Forst',
	'AT31540' => 'St. Martin-Karlsbach',
	'AT31541' => 'St. Oswald',
	'AT31542' => 'Schönbühel-Aggsbach',
	'AT31543' => 'Schollach',
	'AT31546' => 'Weiten',
	'AT31549' => 'Ybbs an der Donau',
	'AT31550' => 'Zelking-Matzleinsdorf',
	'AT31551' => 'Texingtal',
	'AT31552' => 'Yspertal',
	'AT31553' => 'Emmersdorf an der Donau',
	'AT31601' => 'Altlichtenwarth',
	'AT31603' => 'Asparn an der Zaya',
	'AT31604' => 'Bernhardsthal',
	'AT31605' => 'Bockfließ',
	'AT31606' => 'Drasenhofen',
	'AT31608' => 'Falkenstein',
	'AT31609' => 'Fallbach',
	'AT31611' => 'Gaubitsch',
	'AT31612' => 'Gaweinstal',
	'AT31613' => 'Gnadendorf',
	'AT31614' => 'Großebersdorf',
	'AT31615' => 'Großengersdorf',
	'AT31616' => 'Großharras',
	'AT31617' => 'Großkrut',
	'AT31620' => 'Hausbrunn',
	'AT31621' => 'Herrnbaumgarten',
	'AT31622' => 'Hochleithen',
	'AT31627' => 'Kreuttal',
	'AT31628' => 'Kreuzstetten',
	'AT31629' => 'Laa an der Thaya',
	'AT31630' => 'Ladendorf',
	'AT31633' => 'Mistelbach',
	'AT31634' => 'Neudorf bei Staatz',
	'AT31636' => 'Niederleis',
	'AT31642' => 'Pillichsdorf',
	'AT31644' => 'Poysdorf',
	'AT31645' => 'Rabensburg',
	'AT31646' => 'Schrattenberg',
	'AT31649' => 'Staatz',
	'AT31650' => 'Stronsdorf',
	'AT31651' => 'Ulrichskirchen-Schleinbach',
	'AT31652' => 'Unterstinkenbrunn',
	'AT31653' => 'Wildendürnbach',
	'AT31654' => 'Wilfersdorf',
	'AT31655' => 'Wolkersdorf im Weinviertel',
	'AT31658' => 'Ottenthal',
	'AT31701' => 'Achau',
	'AT31702' => 'Biedermannsdorf',
	'AT31703' => 'Breitenfurt bei Wien',
	'AT31704' => 'Brunn am Gebirge',
	'AT31706' => 'Gaaden',
	'AT31707' => 'Gießhübl',
	'AT31709' => 'Gumpoldskirchen',
	'AT31710' => 'Guntramsdorf',
	'AT31711' => 'Hennersdorf',
	'AT31712' => 'Hinterbrühl',
	'AT31713' => 'Kaltenleutgeben',
	'AT31714' => 'Laab im Walde',
	'AT31715' => 'Laxenburg',
	'AT31716' => 'Maria Enzersdorf',
	'AT31717' => 'Mödling',
	'AT31718' => 'Münchendorf',
	'AT31719' => 'Perchtoldsdorf',
	'AT31723' => 'Vösendorf',
	'AT31725' => 'Wiener Neudorf',
	'AT31726' => 'Wienerwald',
	'AT31801' => 'Altendorf',
	'AT31802' => 'Aspang-Markt',
	'AT31803' => 'Aspangberg-St. Peter',
	'AT31804' => 'Breitenau',
	'AT31805' => 'Breitenstein',
	'AT31806' => 'Buchbach',
	'AT31807' => 'Edlitz',
	'AT31808' => 'Enzenreith',
	'AT31809' => 'Feistritz am Wechsel',
	'AT31810' => 'Gloggnitz',
	'AT31811' => 'Grafenbach-St. Valentin',
	'AT31812' => 'Grimmenstein',
	'AT31813' => 'Grünbach am Schneeberg',
	'AT31814' => 'Kirchberg am Wechsel',
	'AT31815' => 'Mönichkirchen',
	'AT31817' => 'Natschbach-Loipersbach',
	'AT31818' => 'Neunkirchen',
	'AT31820' => 'Otterthal',
	'AT31821' => 'Payerbach',
	'AT31823' => 'Pitten',
	'AT31825' => 'Prigglitz',
	'AT31826' => 'Puchberg am Schneeberg',
	'AT31827' => 'Raach am Hochgebirge',
	'AT31829' => 'Reichenau an der Rax',
	'AT31830' => 'St. Corona am Wechsel',
	'AT31831' => 'St. Egyden am Steinfeld',
	'AT31832' => 'Scheiblingkirchen-Thernberg',
	'AT31833' => 'Schottwien',
	'AT31834' => 'Schrattenbach',
	'AT31835' => 'Schwarzau am Steinfeld',
	'AT31836' => 'Schwarzau im Gebirge',
	'AT31837' => 'Seebenstein',
	'AT31838' => 'Semmering',
	'AT31839' => 'Ternitz',
	'AT31840' => 'Thomasberg',
	'AT31841' => 'Trattenbach',
	'AT31842' => 'Bürg-Vöstenhof',
	'AT31843' => 'Warth',
	'AT31844' => 'Wartmannstetten',
	'AT31845' => 'Willendorf',
	'AT31846' => 'Wimpassing im Schwarzatale',
	'AT31847' => 'Würflach',
	'AT31848' => 'Zöbern',
	'AT31849' => 'Höflein an der Hohen Wand',
	'AT31901' => 'Altlengbach',
	'AT31902' => 'Asperhofen',
	'AT31903' => 'Böheimkirchen',
	'AT31904' => 'Brand-Laaben',
	'AT31905' => 'Eichgraben',
	'AT31906' => 'Frankenfels',
	'AT31907' => 'Gerersdorf',
	'AT31909' => 'Hofstetten-Grünau',
	'AT31910' => 'Hafnerbach',
	'AT31911' => 'Haunoldstein',
	'AT31912' => 'Herzogenburg',
	'AT31913' => 'Inzersdorf-Getzersdorf',
	'AT31915' => 'Kapelln',
	'AT31916' => 'Karlstetten',
	'AT31917' => 'Kasten bei Böheimkirchen',
	'AT31918' => 'Kirchberg an der Pielach',
	'AT31919' => 'Kirchstetten',
	'AT31920' => 'Loich',
	'AT31921' => 'Maria-Anzbach',
	'AT31922' => 'Markersdorf-Haindorf',
	'AT31923' => 'Michelbach',
	'AT31925' => 'Neidling',
	'AT31926' => 'Neulengbach',
	'AT31927' => 'Neustift-Innermanzing',
	'AT31928' => 'Nußdorf ob der Traisen',
	'AT31929' => 'Ober-Grafendorf',
	'AT31930' => 'Obritzberg-Rust',
	'AT31932' => 'Prinzersdorf',
	'AT31934' => 'Pyhra',
	'AT31935' => 'Rabenstein an der Pielach',
	'AT31938' => 'St. Margarethen an der Sierning',
	'AT31939' => 'Schwarzenbach an der Pielach',
	'AT31940' => 'Statzendorf',
	'AT31941' => 'Stössing',
	'AT31943' => 'Traismauer',
	'AT31945' => 'Weinburg',
	'AT31946' => 'Perschling',
	'AT31947' => 'Wilhelmsburg',
	'AT31948' => 'Wölbling',
	'AT31949' => 'Gablitz',
	'AT31950' => 'Mauerbach',
	'AT31951' => 'Pressbaum',
	'AT31952' => 'Purkersdorf',
	'AT31953' => 'Tullnerbach',
	'AT31954' => 'Wolfsgraben',
	'AT32001' => 'Gaming',
	'AT32002' => 'Göstling an der Ybbs',
	'AT32003' => 'Gresten',
	'AT32004' => 'Gresten-Land',
	'AT32005' => 'Lunz am See',
	'AT32006' => 'Oberndorf an der Melk',
	'AT32007' => 'Puchenstuben',
	'AT32008' => 'Purgstall an der Erlauf',
	'AT32009' => 'Randegg',
	'AT32010' => 'Reinsberg',
	'AT32011' => 'St. Anton an der Jeßnitz',
	'AT32012' => 'St. Georgen an der Leys',
	'AT32013' => 'Scheibbs',
	'AT32014' => 'Steinakirchen am Forst',
	'AT32015' => 'Wang',
	'AT32016' => 'Wieselburg',
	'AT32017' => 'Wieselburg-Land',
	'AT32018' => 'Wolfpassing',
	'AT32101' => 'Absdorf',
	'AT32104' => 'Atzenbrugg',
	'AT32106' => 'Fels am Wagram',
	'AT32107' => 'Grafenwörth',
	'AT32109' => 'Großriedenthal',
	'AT32110' => 'Großweikersdorf',
	'AT32112' => 'Judenau-Baumgarten',
	'AT32114' => 'Kirchberg am Wagram',
	'AT32115' => 'Königsbrunn am Wagram',
	'AT32116' => 'Königstetten',
	'AT32119' => 'Langenrohr',
	'AT32120' => 'Michelhausen',
	'AT32131' => 'Sieghartskirchen',
	'AT32132' => 'Sitzenberg-Reidling',
	'AT32134' => 'Tulbing',
	'AT32135' => 'Tulln an der Donau',
	'AT32139' => 'Würmla',
	'AT32140' => 'Zeiselmauer-Wolfpassing',
	'AT32141' => 'Zwentendorf an der Donau',
	'AT32142' => 'Sankt Andrä-Wördern',
	'AT32143' => 'Muckendorf-Wipfing',
	'AT32144' => 'Klosterneuburg',
	'AT32202' => 'Dietmanns',
	'AT32203' => 'Dobersberg',
	'AT32206' => 'Gastern',
	'AT32207' => 'Groß-Siegharts',
	'AT32209' => 'Karlstein an der Thaya',
	'AT32210' => 'Kautzen',
	'AT32212' => 'Ludweis-Aigen',
	'AT32214' => 'Pfaffenschlag bei Waidhofen a.d.Thaya',
	'AT32216' => 'Raabs an der Thaya',
	'AT32217' => 'Thaya',
	'AT32219' => 'Vitis',
	'AT32220' => 'Waidhofen an der Thaya',
	'AT32221' => 'Waidhofen an der Thaya-Land',
	'AT32222' => 'Waldkirchen an der Thaya',
	'AT32223' => 'Windigsteig',
	'AT32301' => 'Bad Fischau-Brunn',
	'AT32302' => 'Bad Schönau',
	'AT32304' => 'Ebenfurth',
	'AT32305' => 'Eggendorf',
	'AT32306' => 'Bad Erlach',
	'AT32307' => 'Felixdorf',
	'AT32308' => 'Gutenstein',
	'AT32309' => 'Hochneukirchen-Gschaidt',
	'AT32310' => 'Hochwolkersdorf',
	'AT32311' => 'Hohe Wand',
	'AT32312' => 'Hollenthon',
	'AT32313' => 'Katzelsdorf',
	'AT32314' => 'Kirchschlag in der Buckligen Welt',
	'AT32315' => 'Krumbach',
	'AT32316' => 'Lanzenkirchen',
	'AT32317' => 'Lichtenegg',
	'AT32318' => 'Lichtenwörth',
	'AT32319' => 'Markt Piesting',
	'AT32320' => 'Matzendorf-Hölles',
	'AT32321' => 'Miesenbach',
	'AT32322' => 'Muggendorf',
	'AT32323' => 'Pernitz',
	'AT32324' => 'Rohr im Gebirge',
	'AT32325' => 'Bromberg',
	'AT32326' => 'Schwarzenbach',
	'AT32327' => 'Sollenau',
	'AT32330' => 'Theresienfeld',
	'AT32331' => 'Waidmannsfeld',
	'AT32332' => 'Waldegg',
	'AT32333' => 'Walpersbach',
	'AT32334' => 'Weikersdorf am Steinfelde',
	'AT32335' => 'Wiesmath',
	'AT32336' => 'Winzendorf-Muthmannsdorf',
	'AT32337' => 'Wöllersdorf-Steinabrückl',
	'AT32338' => 'Zillingdorf',
	'AT32501' => 'Allentsteig',
	'AT32502' => 'Arbesbach',
	'AT32503' => 'Bärnkopf',
	'AT32504' => 'Echsenbach',
	'AT32505' => 'Göpfritz an der Wild',
	'AT32506' => 'Grafenschlag',
	'AT32508' => 'Groß Gerungs',
	'AT32509' => 'Großgöttfritz',
	'AT32511' => 'Gutenbrunn',
	'AT32514' => 'Kirchschlag',
	'AT32515' => 'Kottes-Purk',
	'AT32516' => 'Langschlag',
	'AT32517' => 'Martinsberg',
	'AT32518' => 'Ottenschlag',
	'AT32519' => 'Altmelon',
	'AT32520' => 'Pölla',
	'AT32521' => 'Rappottenstein',
	'AT32522' => 'Sallingberg',
	'AT32523' => 'Schönbach',
	'AT32524' => 'Schwarzenau',
	'AT32525' => 'Schweiggers',
	'AT32528' => 'Bad Traunstein',
	'AT32529' => 'Waldhausen',
	'AT32530' => 'Zwettl-Niederösterreich',
	'AT40101' => 'Linz',
	'AT40201' => 'Steyr',
	'AT40301' => 'Wels',
	'AT40401' => 'Altheim',
	'AT40402' => 'Aspach',
	'AT40403' => 'Auerbach',
	'AT40404' => 'Braunau am Inn',
	'AT40405' => 'Burgkirchen',
	'AT40406' => 'Eggelsberg',
	'AT40407' => 'Feldkirchen bei Mattighofen',
	'AT40408' => 'Franking',
	'AT40409' => 'Geretsberg',
	'AT40410' => 'Gilgenberg am Weilhart',
	'AT40411' => 'Haigermoos',
	'AT40412' => 'Handenberg',
	'AT40413' => 'Helpfau-Uttendorf',
	'AT40414' => 'Hochburg-Ach',
	'AT40415' => 'Höhnhart',
	'AT40416' => 'Jeging',
	'AT40417' => 'Kirchberg bei Mattighofen',
	'AT40418' => 'Lengau',
	'AT40419' => 'Lochen am See',
	'AT40420' => 'Maria Schmolln',
	'AT40421' => 'Mattighofen',
	'AT40422' => 'Mauerkirchen',
	'AT40423' => 'Mining',
	'AT40424' => 'Moosbach',
	'AT40425' => 'Moosdorf',
	'AT40426' => 'Munderfing',
	'AT40427' => 'Neukirchen an der Enknach',
	'AT40428' => 'Ostermiething',
	'AT40429' => 'Palting',
	'AT40430' => 'Perwang am Grabensee',
	'AT40431' => 'Pfaffstätt',
	'AT40432' => 'Pischelsdorf am Engelbach',
	'AT40433' => 'Polling im Innkreis',
	'AT40434' => 'Roßbach',
	'AT40435' => 'St. Georgen am Fillmannsbach',
	'AT40436' => 'St. Johann am Walde',
	'AT40437' => 'St. Pantaleon',
	'AT40438' => 'St. Peter am Hart',
	'AT40439' => 'St. Radegund',
	'AT40440' => 'St. Veit im Innkreis',
	'AT40441' => 'Schalchen',
	'AT40442' => 'Schwand im Innkreis',
	'AT40443' => 'Tarsdorf',
	'AT40444' => 'Treubach',
	'AT40445' => 'Überackern',
	'AT40446' => 'Weng im Innkreis',
	'AT40501' => 'Alkoven',
	'AT40502' => 'Aschach an der Donau',
	'AT40503' => 'Eferding',
	'AT40504' => 'Fraham',
	'AT40505' => 'Haibach ob der Donau',
	'AT40506' => 'Hartkirchen',
	'AT40507' => 'Hinzenbach',
	'AT40508' => 'Prambachkirchen',
	'AT40509' => 'Pupping',
	'AT40510' => 'St. Marienkirchen an der Polsenz',
	'AT40511' => 'Scharten',
	'AT40512' => 'Stroheim',
	'AT40601' => 'Freistadt',
	'AT40602' => 'Grünbach',
	'AT40603' => 'Gutau',
	'AT40604' => 'Hagenberg im Mühlkreis',
	'AT40605' => 'Hirschbach im Mühlkreis',
	'AT40606' => 'Kaltenberg',
	'AT40607' => 'Kefermarkt',
	'AT40608' => 'Königswiesen',
	'AT40609' => 'Lasberg',
	'AT40610' => 'Leopoldschlag',
	'AT40611' => 'Liebenau',
	'AT40612' => 'Neumarkt im Mühlkreis',
	'AT40613' => 'Pierbach',
	'AT40614' => 'Pregarten',
	'AT40615' => 'Rainbach im Mühlkreis',
	'AT40616' => 'Sandl',
	'AT40617' => 'St. Leonhard bei Freistadt',
	'AT40618' => 'St. Oswald bei Freistadt',
	'AT40619' => 'Schönau im Mühlkreis',
	'AT40620' => 'Tragwein',
	'AT40621' => 'Unterweißenbach',
	'AT40622' => 'Unterweitersdorf',
	'AT40623' => 'Waldburg',
	'AT40624' => 'Wartberg ob der Aist',
	'AT40625' => 'Weitersfelden',
	'AT40626' => 'Windhaag bei Freistadt',
	'AT40627' => 'Bad Zell',
	'AT40701' => 'Altmünster',
	'AT40702' => 'Bad Goisern am Hallstättersee',
	'AT40703' => 'Bad Ischl',
	'AT40704' => 'Ebensee am Traunsee',
	'AT40705' => 'Gmunden',
	'AT40706' => 'Gosau',
	'AT40707' => 'Grünau im Almtal',
	'AT40708' => 'Gschwandt',
	'AT40709' => 'Hallstatt',
	'AT40710' => 'Kirchham',
	'AT40711' => 'Laakirchen',
	'AT40712' => 'Obertraun',
	'AT40713' => 'Ohlsdorf',
	'AT40714' => 'Pinsdorf',
	'AT40715' => 'Roitham',
	'AT40716' => 'St. Konrad',
	'AT40717' => 'St. Wolfgang im Salzkammergut',
	'AT40718' => 'Traunkirchen',
	'AT40719' => 'Scharnstein',
	'AT40720' => 'Vorchdorf',
	'AT40801' => 'Aistersheim',
	'AT40802' => 'Bad Schallerbach',
	'AT40804' => 'Eschenau im Hausruckkreis',
	'AT40805' => 'Gallspach',
	'AT40806' => 'Gaspoltshofen',
	'AT40807' => 'Geboltskirchen',
	'AT40808' => 'Grieskirchen',
	'AT40809' => 'Haag am Hausruck',
	'AT40810' => 'Heiligenberg',
	'AT40811' => 'Hofkirchen an der Trattnach',
	'AT40812' => 'Kallham',
	'AT40813' => 'Kematen am Innbach',
	'AT40814' => 'Meggenhofen',
	'AT40815' => 'Michaelnbach',
	'AT40816' => 'Natternbach',
	'AT40817' => 'Neukirchen am Walde',
	'AT40818' => 'Neumarkt im Hausruckkreis',
	'AT40820' => 'Pötting',
	'AT40821' => 'Pollham',
	'AT40822' => 'Pram',
	'AT40823' => 'Rottenbach',
	'AT40824' => 'St. Agatha',
	'AT40825' => 'St. Georgen bei Grieskirchen',
	'AT40826' => 'St. Thomas',
	'AT40827' => 'Schlüßlberg',
	'AT40828' => 'Steegen',
	'AT40829' => 'Taufkirchen an der Trattnach',
	'AT40830' => 'Tollet',
	'AT40831' => 'Waizenkirchen',
	'AT40832' => 'Wallern an der Trattnach',
	'AT40833' => 'Weibern',
	'AT40834' => 'Wendling',
	'AT40835' => 'Peuerbach',
	'AT40901' => 'Edlbach',
	'AT40902' => 'Grünburg',
	'AT40903' => 'Hinterstoder',
	'AT40904' => 'Inzersdorf im Kremstal',
	'AT40905' => 'Kirchdorf an der Krems',
	'AT40906' => 'Klaus an der Pyhrnbahn',
	'AT40907' => 'Kremsmünster',
	'AT40908' => 'Micheldorf in Oberösterreich',
	'AT40909' => 'Molln',
	'AT40910' => 'Nußbach',
	'AT40911' => 'Oberschlierbach',
	'AT40912' => 'Pettenbach',
	'AT40913' => 'Ried im Traunkreis',
	'AT40914' => 'Rosenau am Hengstpaß',
	'AT40915' => 'Roßleithen',
	'AT40916' => 'St. Pankraz',
	'AT40917' => 'Schlierbach',
	'AT40918' => 'Spital am Pyhrn',
	'AT40919' => 'Steinbach am Ziehberg',
	'AT40920' => 'Steinbach an der Steyr',
	'AT40921' => 'Vorderstoder',
	'AT40922' => 'Wartberg an der Krems',
	'AT40923' => 'Windischgarsten',
	'AT41001' => 'Allhaming',
	'AT41002' => 'Ansfelden',
	'AT41003' => 'Asten',
	'AT41004' => 'Eggendorf im Traunkreis',
	'AT41005' => 'Enns',
	'AT41006' => 'Hargelsberg',
	'AT41007' => 'Hörsching',
	'AT41008' => 'Hofkirchen im Traunkreis',
	'AT41009' => 'Kematen an der Krems',
	'AT41010' => 'Kirchberg-Thening',
	'AT41011' => 'Kronstorf',
	'AT41012' => 'Leonding',
	'AT41013' => 'St. Florian',
	'AT41014' => 'Neuhofen an der Krems',
	'AT41015' => 'Niederneukirchen',
	'AT41016' => 'Oftering',
	'AT41017' => 'Pasching',
	'AT41018' => 'Piberbach',
	'AT41019' => 'Pucking',
	'AT41020' => 'St. Marien',
	'AT41021' => 'Traun',
	'AT41022' => 'Wilhering',
	'AT41101' => 'Allerheiligen im Mühlkreis',
	'AT41102' => 'Arbing',
	'AT41103' => 'Baumgartenberg',
	'AT41104' => 'Dimbach',
	'AT41105' => 'Grein',
	'AT41106' => 'Katsdorf',
	'AT41107' => 'Klam',
	'AT41108' => 'Bad Kreuzen',
	'AT41109' => 'Langenstein',
	'AT41110' => 'Luftenberg an der Donau',
	'AT41111' => 'Mauthausen',
	'AT41112' => 'Mitterkirchen im Machland',
	'AT41113' => 'Münzbach',
	'AT41114' => 'Naarn im Machlande',
	'AT41115' => 'Pabneukirchen',
	'AT41116' => 'Perg',
	'AT41117' => 'Rechberg',
	'AT41118' => 'Ried in der Riedmark',
	'AT41119' => 'St. Georgen am Walde',
	'AT41120' => 'St. Georgen an der Gusen',
	'AT41121' => 'St. Nikola an der Donau',
	'AT41122' => 'St. Thomas am Blasenstein',
	'AT41123' => 'Saxen',
	'AT41124' => 'Schwertberg',
	'AT41125' => 'Waldhausen im Strudengau',
	'AT41126' => 'Windhaag bei Perg',
	'AT41201' => 'Andrichsfurt',
	'AT41202' => 'Antiesenhofen',
	'AT41203' => 'Aurolzmünster',
	'AT41204' => 'Eberschwang',
	'AT41205' => 'Eitzing',
	'AT41206' => 'Geiersberg',
	'AT41207' => 'Geinberg',
	'AT41208' => 'Gurten',
	'AT41209' => 'Hohenzell',
	'AT41210' => 'Kirchdorf am Inn',
	'AT41211' => 'Kirchheim im Innkreis',
	'AT41212' => 'Lambrechten',
	'AT41213' => 'Lohnsburg am Kobernaußerwald',
	'AT41214' => 'Mehrnbach',
	'AT41215' => 'Mettmach',
	'AT41216' => 'Mörschwang',
	'AT41217' => 'Mühlheim am Inn',
	'AT41218' => 'Neuhofen im Innkreis',
	'AT41219' => 'Obernberg am Inn',
	'AT41220' => 'Ort im Innkreis',
	'AT41221' => 'Pattigham',
	'AT41222' => 'Peterskirchen',
	'AT41223' => 'Pramet',
	'AT41224' => 'Reichersberg',
	'AT41225' => 'Ried im Innkreis',
	'AT41226' => 'St. Georgen bei Obernberg am Inn',
	'AT41227' => 'St. Marienkirchen am Hausruck',
	'AT41228' => 'St. Martin im Innkreis',
	'AT41229' => 'Schildorn',
	'AT41230' => 'Senftenbach',
	'AT41231' => 'Taiskirchen im Innkreis',
	'AT41232' => 'Tumeltsham',
	'AT41233' => 'Utzenaich',
	'AT41234' => 'Waldzell',
	'AT41235' => 'Weilbach',
	'AT41236' => 'Wippenham',
	'AT41304' => 'Altenfelden',
	'AT41305' => 'Arnreit',
	'AT41306' => 'Atzesberg',
	'AT41307' => 'Auberg',
	'AT41309' => 'Haslach an der Mühl',
	'AT41311' => 'Hörbich',
	'AT41312' => 'Hofkirchen im Mühlkreis',
	'AT41313' => 'Julbach',
	'AT41314' => 'Kirchberg ob der Donau',
	'AT41315' => 'Klaffer am Hochficht',
	'AT41316' => 'Kleinzell im Mühlkreis',
	'AT41317' => 'Kollerschlag',
	'AT41318' => 'Lembach im Mühlkreis',
	'AT41319' => 'Lichtenau im Mühlkreis',
	'AT41320' => 'Nebelberg',
	'AT41321' => 'Neufelden',
	'AT41322' => 'Niederkappel',
	'AT41323' => 'Niederwaldkirchen',
	'AT41324' => 'Oberkappel',
	'AT41325' => 'Oepping',
	'AT41326' => 'Peilstein im Mühlviertel',
	'AT41327' => 'Pfarrkirchen im Mühlkreis',
	'AT41328' => 'Putzleinsdorf',
	'AT41329' => 'Neustift im Mühlkreis',
	'AT41331' => 'St. Johann am Wimberg',
	'AT41332' => 'St. Martin im Mühlkreis',
	'AT41333' => 'St. Oswald bei Haslach',
	'AT41334' => 'St. Peter am Wimberg',
	'AT41336' => 'St. Ulrich im Mühlkreis',
	'AT41337' => 'St. Veit im Mühlkreis',
	'AT41338' => 'Sarleinsbach',
	'AT41341' => 'Schwarzenberg am Böhmerwald',
	'AT41342' => 'Ulrichsberg',
	'AT41343' => 'Aigen-Schlägl',
	'AT41344' => 'Rohrbach-Berg',
	'AT41345' => 'Helfenberg',
	'AT41346' => 'St. Stefan-Afiesl',
	'AT41401' => 'Altschwendt',
	'AT41402' => 'Andorf',
	'AT41403' => 'Brunnenthal',
	'AT41404' => 'Diersbach',
	'AT41405' => 'Dorf an der Pram',
	'AT41406' => 'Eggerding',
	'AT41407' => 'Engelhartszell',
	'AT41408' => 'Enzenkirchen',
	'AT41409' => 'Esternberg',
	'AT41410' => 'Freinberg',
	'AT41411' => 'Kopfing im Innkreis',
	'AT41412' => 'Mayrhof',
	'AT41413' => 'Münzkirchen',
	'AT41414' => 'Raab',
	'AT41415' => 'Rainbach im Innkreis',
	'AT41416' => 'Riedau',
	'AT41417' => 'St. Aegidi',
	'AT41418' => 'St. Florian am Inn',
	'AT41419' => 'St. Marienkirchen bei Schärding',
	'AT41420' => 'St. Roman',
	'AT41421' => 'St. Willibald',
	'AT41422' => 'Schärding',
	'AT41423' => 'Schardenberg',
	'AT41424' => 'Sigharting',
	'AT41425' => 'Suben',
	'AT41426' => 'Taufkirchen an der Pram',
	'AT41427' => 'Vichtenstein',
	'AT41428' => 'Waldkirchen am Wesen',
	'AT41429' => 'Wernstein am Inn',
	'AT41430' => 'Zell an der Pram',
	'AT41501' => 'Adlwang',
	'AT41502' => 'Aschach an der Steyr',
	'AT41503' => 'Bad Hall',
	'AT41504' => 'Dietach',
	'AT41505' => 'Gaflenz',
	'AT41506' => 'Garsten',
	'AT41507' => 'Großraming',
	'AT41508' => 'Laussa',
	'AT41509' => 'Losenstein',
	'AT41510' => 'Maria Neustift',
	'AT41511' => 'Pfarrkirchen bei Bad Hall',
	'AT41512' => 'Reichraming',
	'AT41513' => 'Rohr im Kremstal',
	'AT41514' => 'St. Ulrich bei Steyr',
	'AT41515' => 'Schiedlberg',
	'AT41516' => 'Sierning',
	'AT41517' => 'Ternberg',
	'AT41518' => 'Waldneukirchen',
	'AT41521' => 'Wolfern',
	'AT41522' => 'Weyer',
	'AT41601' => 'Alberndorf in der Riedmark',
	'AT41602' => 'Altenberg bei Linz',
	'AT41603' => 'Bad Leonfelden',
	'AT41604' => 'Eidenberg',
	'AT41605' => 'Engerwitzdorf',
	'AT41606' => 'Feldkirchen an der Donau',
	'AT41607' => 'Gallneukirchen',
	'AT41608' => 'Goldwörth',
	'AT41609' => 'Gramastetten',
	'AT41610' => 'Haibach im Mühlkreis',
	'AT41611' => 'Hellmonsödt',
	'AT41612' => 'Herzogsdorf',
	'AT41613' => 'Kirchschlag bei Linz',
	'AT41614' => 'Lichtenberg',
	'AT41615' => 'Oberneukirchen',
	'AT41616' => 'Ottenschlag im Mühlkreis',
	'AT41617' => 'Ottensheim',
	'AT41618' => 'Puchenau',
	'AT41619' => 'Reichenau im Mühlkreis',
	'AT41620' => 'Reichenthal',
	'AT41621' => 'St. Gotthard im Mühlkreis',
	'AT41622' => 'Schenkenfelden',
	'AT41623' => 'Sonnberg im Mühlkreis',
	'AT41624' => 'Steyregg',
	'AT41626' => 'Walding',
	'AT41627' => 'Zwettl an der Rodl',
	'AT41628' => 'Vorderweißenbach',
	'AT41701' => 'Ampflwang im Hausruckwald',
	'AT41702' => 'Attersee am Attersee',
	'AT41703' => 'Attnang-Puchheim',
	'AT41704' => 'Atzbach',
	'AT41705' => 'Aurach am Hongar',
	'AT41706' => 'Berg im Attergau',
	'AT41707' => 'Desselbrunn',
	'AT41708' => 'Fornach',
	'AT41709' => 'Frankenburg am Hausruck',
	'AT41710' => 'Frankenmarkt',
	'AT41711' => 'Gampern',
	'AT41712' => 'Innerschwand am Mondsee',
	'AT41713' => 'Lenzing',
	'AT41714' => 'Manning',
	'AT41715' => 'Mondsee',
	'AT41716' => 'Neukirchen an der Vöckla',
	'AT41717' => 'Niederthalheim',
	'AT41718' => 'Nußdorf am Attersee',
	'AT41719' => 'Oberhofen am Irrsee',
	'AT41720' => 'Oberndorf bei Schwanenstadt',
	'AT41721' => 'Oberwang',
	'AT41722' => 'Ottnang am Hausruck',
	'AT41723' => 'Pfaffing',
	'AT41724' => 'Pilsbach',
	'AT41725' => 'Pitzenberg',
	'AT41726' => 'Pöndorf',
	'AT41727' => 'Puchkirchen am Trattberg',
	'AT41728' => 'Pühret',
	'AT41729' => 'Redleiten',
	'AT41730' => 'Redlham',
	'AT41731' => 'Regau',
	'AT41732' => 'Rüstorf',
	'AT41733' => 'Rutzenham',
	'AT41734' => 'St. Georgen im Attergau',
	'AT41735' => 'St. Lorenz',
	'AT41736' => 'Schlatt',
	'AT41737' => 'Schörfling am Attersee',
	'AT41738' => 'Schwanenstadt',
	'AT41739' => 'Seewalchen am Attersee',
	'AT41740' => 'Steinbach am Attersee',
	'AT41741' => 'Straß im Attergau',
	'AT41742' => 'Tiefgraben',
	'AT41743' => 'Timelkam',
	'AT41744' => 'Ungenach',
	'AT41745' => 'Unterach am Attersee',
	'AT41746' => 'Vöcklabruck',
	'AT41747' => 'Vöcklamarkt',
	'AT41748' => 'Weißenkirchen im Attergau',
	'AT41749' => 'Weyregg am Attersee',
	'AT41750' => 'Wolfsegg am Hausruck',
	'AT41751' => 'Zell am Moos',
	'AT41752' => 'Zell am Pettenfirst',
	'AT41801' => 'Aichkirchen',
	'AT41802' => 'Bachmanning',
	'AT41803' => 'Bad Wimsbach-Neydharting',
	'AT41804' => 'Buchkirchen',
	'AT41805' => 'Eberstalzell',
	'AT41806' => 'Edt bei Lambach',
	'AT41807' => 'Fischlham',
	'AT41808' => 'Gunskirchen',
	'AT41809' => 'Holzhausen',
	'AT41810' => 'Krenglbach',
	'AT41811' => 'Lambach',
	'AT41812' => 'Marchtrenk',
	'AT41813' => 'Neukirchen bei Lambach',
	'AT41814' => 'Offenhausen',
	'AT41815' => 'Pennewang',
	'AT41816' => 'Pichl bei Wels',
	'AT41817' => 'Sattledt',
	'AT41818' => 'Schleißheim',
	'AT41819' => 'Sipbachzell',
	'AT41820' => 'Stadl-Paura',
	'AT41821' => 'Steinerkirchen an der Traun',
	'AT41822' => 'Steinhaus',
	'AT41823' => 'Thalheim bei Wels',
	'AT41824' => 'Weißkirchen an der Traun',
	'AT50101' => 'Salzburg',
	'AT50201' => 'Abtenau',
	'AT50202' => 'Adnet',
	'AT50203' => 'Annaberg-Lungötz',
	'AT50204' => 'Golling an der Salzach',
	'AT50205' => 'Hallein',
	'AT50206' => 'Krispl',
	'AT50207' => 'Kuchl',
	'AT50208' => 'Oberalm',
	'AT50209' => 'Puch bei Hallein',
	'AT50210' => 'Rußbach am Paß Gschütt',
	'AT50211' => 'Sankt Koloman',
	'AT50212' => 'Scheffau am Tennengebirge',
	'AT50213' => 'Bad Vigaun',
	'AT50301' => 'Anif',
	'AT50302' => 'Anthering',
	'AT50303' => 'Bergheim',
	'AT50304' => 'Berndorf bei Salzburg',
	'AT50305' => 'Bürmoos',
	'AT50306' => 'Dorfbeuern',
	'AT50307' => 'Ebenau',
	'AT50308' => 'Elixhausen',
	'AT50309' => 'Elsbethen',
	'AT50310' => 'Eugendorf',
	'AT50311' => 'Faistenau',
	'AT50312' => 'Fuschl am See',
	'AT50313' => 'Göming',
	'AT50314' => 'Grödig',
	'AT50315' => 'Großgmain',
	'AT50316' => 'Hallwang',
	'AT50317' => 'Henndorf am Wallersee',
	'AT50318' => 'Hintersee',
	'AT50319' => 'Hof bei Salzburg',
	'AT50320' => 'Köstendorf',
	'AT50321' => 'Koppl',
	'AT50322' => 'Lamprechtshausen',
	'AT50323' => 'Mattsee',
	'AT50324' => 'Neumarkt am Wallersee',
	'AT50325' => 'Nußdorf am Haunsberg',
	'AT50326' => 'Oberndorf bei Salzburg',
	'AT50327' => 'Obertrum am See',
	'AT50328' => 'Plainfeld',
	'AT50329' => 'Sankt Georgen bei Salzburg',
	'AT50330' => 'Sankt Gilgen',
	'AT50331' => 'Schleedorf',
	'AT50332' => 'Seeham',
	'AT50335' => 'Straßwalchen',
	'AT50336' => 'Strobl',
	'AT50337' => 'Thalgau',
	'AT50338' => 'Wals-Siezenheim',
	'AT50339' => 'Seekirchen am Wallersee',
	'AT50401' => 'Altenmarkt im Pongau',
	'AT50402' => 'Bad Hofgastein',
	'AT50403' => 'Bad Gastein',
	'AT50404' => 'Bischofshofen',
	'AT50405' => 'Dorfgastein',
	'AT50406' => 'Eben im Pongau',
	'AT50407' => 'Filzmoos',
	'AT50408' => 'Flachau',
	'AT50409' => 'Forstau',
	'AT50410' => 'Goldegg',
	'AT50411' => 'Großarl',
	'AT50412' => 'Hüttau',
	'AT50413' => 'Hüttschlag',
	'AT50414' => 'Kleinarl',
	'AT50415' => 'Mühlbach am Hochkönig',
	'AT50416' => 'Pfarrwerfen',
	'AT50417' => 'Radstadt',
	'AT50418' => 'Sankt Johann im Pongau',
	'AT50419' => 'Sankt Martin am Tennengebirge',
	'AT50420' => 'Sankt Veit im Pongau',
	'AT50421' => 'Schwarzach im Pongau',
	'AT50422' => 'Untertauern',
	'AT50423' => 'Wagrain',
	'AT50424' => 'Werfen',
	'AT50425' => 'Werfenweng',
	'AT50501' => 'Göriach',
	'AT50502' => 'Lessach',
	'AT50503' => 'Mariapfarr',
	'AT50504' => 'Mauterndorf',
	'AT50505' => 'Muhr',
	'AT50506' => 'Ramingstein',
	'AT50507' => 'Sankt Andrä im Lungau',
	'AT50508' => 'Sankt Margarethen im Lungau',
	'AT50509' => 'Sankt Michael im Lungau',
	'AT50510' => 'Tamsweg',
	'AT50511' => 'Thomatal',
	'AT50512' => 'Tweng',
	'AT50513' => 'Unternberg',
	'AT50514' => 'Weißpriach',
	'AT50515' => 'Zederhaus',
	'AT50601' => 'Bramberg am Wildkogel',
	'AT50602' => 'Bruck an der Großglocknerstraße',
	'AT50603' => 'Dienten am Hochkönig',
	'AT50604' => 'Fusch an der Großglocknerstraße',
	'AT50605' => 'Hollersbach im Pinzgau',
	'AT50606' => 'Kaprun',
	'AT50607' => 'Krimml',
	'AT50608' => 'Lend',
	'AT50609' => 'Leogang',
	'AT50610' => 'Lofer',
	'AT50611' => 'Maishofen',
	'AT50612' => 'Maria Alm am Steinernen Meer',
	'AT50613' => 'Mittersill',
	'AT50614' => 'Neukirchen am Großvenediger',
	'AT50615' => 'Niedernsill',
	'AT50616' => 'Piesendorf',
	'AT50617' => 'Rauris',
	'AT50618' => 'Saalbach-Hinterglemm',
	'AT50619' => 'Saalfelden am Steinernen Meer',
	'AT50620' => 'Sankt Martin bei Lofer',
	'AT50621' => 'Stuhlfelden',
	'AT50622' => 'Taxenbach',
	'AT50623' => 'Unken',
	'AT50624' => 'Uttendorf',
	'AT50625' => 'Viehhofen',
	'AT50626' => 'Wald im Pinzgau',
	'AT50627' => 'Weißbach bei Lofer',
	'AT50628' => 'Zell am See',
	'AT60101' => 'Graz',
	'AT60305' => 'Frauental an der Laßnitz',
	'AT60318' => 'Lannach',
	'AT60323' => 'Pölfing-Brunn',
	'AT60324' => 'Preding',
	'AT60326' => 'Sankt Josef (Weststeiermark)',
	'AT60329' => 'Sankt Peter im Sulmtal',
	'AT60341' => 'Wettmannstätten',
	'AT60344' => 'Deutschlandsberg',
	'AT60345' => 'Eibiswald',
	'AT60346' => 'Groß Sankt Florian',
	'AT60347' => 'Sankt Martin im Sulmtal',
	'AT60348' => 'Sankt Stefan ob Stainz',
	'AT60349' => 'Schwanberg',
	'AT60350' => 'Stainz',
	'AT60351' => 'Wies',
	'AT60608' => 'Feldkirchen bei Graz',
	'AT60611' => 'Gössendorf',
	'AT60613' => 'Gratkorn',
	'AT60617' => 'Hart bei Graz',
	'AT60618' => 'Haselsdorf-Tobelbad',
	'AT60619' => 'Hausmannstätten',
	'AT60623' => 'Kainbach bei Graz',
	'AT60624' => 'Kalsdorf bei Graz',
	'AT60626' => 'Kumberg',
	'AT60628' => 'Laßnitzhöhe',
	'AT60629' => 'Lieboch',
	'AT60632' => 'Peggau',
	'AT60639' => 'Sankt Bartholomä',
	'AT60641' => 'Sankt Oswald bei Plankenwarth',
	'AT60642' => 'Sankt Radegund bei Graz',
	'AT60645' => 'Semriach',
	'AT60646' => 'Stattegg',
	'AT60647' => 'Stiwoll',
	'AT60648' => 'Thal',
	'AT60651' => 'Übelbach',
	'AT60653' => 'Vasoldsberg',
	'AT60654' => 'Weinitzen',
	'AT60655' => 'Werndorf',
	'AT60656' => 'Wundschuh',
	'AT60659' => 'Deutschfeistritz',
	'AT60660' => 'Dobl-Zwaring',
	'AT60661' => 'Eggersdorf bei Graz',
	'AT60662' => 'Fernitz-Mellach',
	'AT60663' => 'Frohnleiten',
	'AT60664' => 'Gratwein-Straßengel',
	'AT60665' => 'Hitzendorf',
	'AT60666' => 'Nestelbach bei Graz',
	'AT60667' => 'Raaba-Grambach',
	'AT60668' => 'Sankt Marein bei Graz',
	'AT60669' => 'Seiersberg-Pirka',
	'AT60670' => 'Premstätten',
	'AT61001' => 'Allerheiligen bei Wildon',
	'AT61002' => 'Arnfels',
	'AT61007' => 'Empersdorf',
	'AT61008' => 'Gabersdorf',
	'AT61012' => 'Gralla',
	'AT61013' => 'Großklein',
	'AT61016' => 'Heimschuh',
	'AT61017' => 'Hengsberg',
	'AT61019' => 'Kitzeck im Sausal',
	'AT61020' => 'Lang',
	'AT61021' => 'Lebring-Sankt Margarethen',
	'AT61024' => 'Oberhaag',
	'AT61027' => 'Ragnitz',
	'AT61030' => 'Sankt Andrä-Höch',
	'AT61032' => 'Sankt Johann im Saggautal',
	'AT61033' => 'Sankt Nikolai im Sausal',
	'AT61043' => 'Tillmitsch',
	'AT61045' => 'Wagna',
	'AT61049' => 'Ehrenhausen an der Weinstraße',
	'AT61050' => 'Gamlitz',
	'AT61051' => 'Gleinstätten',
	'AT61052' => 'Heiligenkreuz am Waasen',
	'AT61053' => 'Leibnitz',
	'AT61054' => 'Leutschach an der Weinstraße',
	'AT61055' => 'Sankt Georgen an der Stiefing',
	'AT61056' => 'Sankt Veit in der Südsteiermark',
	'AT61057' => 'Schwarzautal',
	'AT61058' => 'Straß in Steiermark',
	'AT61059' => 'Wildon',
	'AT61101' => 'Eisenerz',
	'AT61105' => 'Kalwang',
	'AT61106' => 'Kammern im Liesingtal',
	'AT61107' => 'Kraubath an der Mur',
	'AT61108' => 'Leoben',
	'AT61109' => 'Mautern in Steiermark',
	'AT61110' => 'Niklasdorf',
	'AT61111' => 'Proleb',
	'AT61112' => 'Radmer',
	'AT61113' => 'Sankt Michael in Obersteiermark',
	'AT61114' => 'Sankt Peter-Freienstein',
	'AT61115' => 'Sankt Stefan ob Leoben',
	'AT61116' => 'Traboch',
	'AT61118' => 'Vordernberg',
	'AT61119' => 'Wald am Schoberpaß',
	'AT61120' => 'Trofaiach',
	'AT61203' => 'Aigen im Ennstal',
	'AT61204' => 'Altaussee',
	'AT61205' => 'Altenmarkt bei Sankt Gallen',
	'AT61206' => 'Ardning',
	'AT61207' => 'Bad Aussee',
	'AT61213' => 'Gröbming',
	'AT61215' => 'Grundlsee',
	'AT61217' => 'Haus',
	'AT61222' => 'Lassing',
	'AT61236' => 'Ramsau am Dachstein',
	'AT61243' => 'Selzthal',
	'AT61247' => 'Trieben',
	'AT61251' => 'Wildalpen',
	'AT61252' => 'Wörschach',
	'AT61253' => 'Admont',
	'AT61254' => 'Aich',
	'AT61255' => 'Bad Mitterndorf',
	'AT61256' => 'Gaishorn am See',
	'AT61257' => 'Irdning-Donnersbachtal',
	'AT61258' => 'Landl',
	'AT61259' => 'Liezen',
	'AT61260' => 'Michaelerberg-Pruggern',
	'AT61261' => 'Mitterberg-Sankt Martin',
	'AT61262' => 'Öblarn',
	'AT61263' => 'Rottenmann',
	'AT61264' => 'Sankt Gallen',
	'AT61265' => 'Schladming',
	'AT61266' => 'Sölk',
	'AT61267' => 'Stainach-Pürgg',
	'AT61410' => 'Mühlen',
	'AT61413' => 'Niederwölz',
	'AT61425' => 'Sankt Peter am Kammersberg',
	'AT61428' => 'Schöder',
	'AT61437' => 'Krakau',
	'AT61438' => 'Murau',
	'AT61439' => 'Neumarkt in der Steiermark',
	'AT61440' => 'Oberwölz ',
	'AT61441' => 'Ranten',
	'AT61442' => 'Sankt Georgen am Kreischberg',
	'AT61443' => 'Sankt Lambrecht',
	'AT61444' => 'Scheifling',
	'AT61445' => 'Stadl-Predlitz',
	'AT61446' => 'Teufenbach-Katsch',
	'AT61611' => 'Krottendorf-Gaisfeld',
	'AT61612' => 'Ligist',
	'AT61615' => 'Mooskirchen',
	'AT61618' => 'Rosental an der Kainach',
	'AT61621' => 'Sankt Martin am Wöllmißberg',
	'AT61624' => 'Stallhofen',
	'AT61625' => 'Voitsberg',
	'AT61626' => 'Bärnbach',
	'AT61627' => 'Edelschrott',
	'AT61628' => 'Geistthal-Södingberg',
	'AT61629' => 'Hirschegg-Pack',
	'AT61630' => 'Kainach bei Voitsberg',
	'AT61631' => 'Köflach',
	'AT61632' => 'Maria Lankowitz',
	'AT61633' => 'Söding-Sankt Johann',
	'AT61701' => 'Albersdorf-Prebuch',
	'AT61708' => 'Fischbach',
	'AT61710' => 'Floing',
	'AT61711' => 'Gasen',
	'AT61716' => 'Markt Hartmannsdorf',
	'AT61719' => 'Hofstätten an der Raab',
	'AT61727' => 'Ludersdorf-Wilfersdorf',
	'AT61728' => 'Miesenbach bei Birkfeld',
	'AT61729' => 'Mitterdorf an der Raab',
	'AT61730' => 'Mortantsch',
	'AT61731' => 'Naas',
	'AT61740' => 'Puch bei Weiz',
	'AT61741' => 'Ratten',
	'AT61743' => 'Rettenegg',
	'AT61744' => 'St. Kathrein am Hauenstein',
	'AT61745' => 'Sankt Kathrein am Offenegg',
	'AT61746' => 'St. Margarethen an der Raab',
	'AT61748' => 'Sinabelkirchen',
	'AT61750' => 'Strallegg',
	'AT61751' => 'Thannhausen',
	'AT61756' => 'Anger',
	'AT61757' => 'Birkfeld',
	'AT61758' => 'Fladnitz an der Teichalm',
	'AT61759' => 'Gersdorf an der Feistritz',
	'AT61760' => 'Gleisdorf',
	'AT61761' => 'Gutenberg-Stenzengreith',
	'AT61762' => 'Ilztal',
	'AT61763' => 'Passail',
	'AT61764' => 'Pischelsdorf am Kulm',
	'AT61765' => 'Sankt Ruprecht an der Raab',
	'AT61766' => 'Weiz',
	'AT62007' => 'Fohnsdorf',
	'AT62008' => 'Gaal',
	'AT62010' => 'Hohentauern',
	'AT62014' => 'Kobenz',
	'AT62021' => 'Pusterwald',
	'AT62026' => 'Sankt Georgen ob Judenburg',
	'AT62032' => 'Sankt Peter ob Judenburg',
	'AT62034' => 'Seckau',
	'AT62036' => 'Unzmarkt-Frauenburg',
	'AT62038' => 'Zeltweg',
	'AT62039' => 'Lobmingtal',
	'AT62040' => 'Judenburg',
	'AT62041' => 'Knittelfeld',
	'AT62042' => 'Obdach',
	'AT62043' => 'Pöls-Oberkurzheim',
	'AT62044' => 'Pölstal',
	'AT62045' => 'Sankt Marein-Feistritz',
	'AT62046' => 'Sankt Margarethen bei Knittelfeld',
	'AT62047' => 'Spielberg',
	'AT62048' => 'Weißkirchen in Steiermark',
	'AT62105' => 'Breitenau am Hochlantsch',
	'AT62115' => 'Krieglach',
	'AT62116' => 'Langenwang',
	'AT62125' => 'Pernegg an der Mur',
	'AT62128' => 'Sankt Lorenzen im Mürztal',
	'AT62131' => 'Spital am Semmering',
	'AT62132' => 'Stanz im Mürztal',
	'AT62135' => 'Turnau',
	'AT62138' => 'Aflenz ',
	'AT62139' => 'Bruck an der Mur',
	'AT62140' => 'Kapfenberg',
	'AT62141' => 'Kindberg',
	'AT62142' => 'Mariazell',
	'AT62143' => 'Mürzzuschlag',
	'AT62144' => 'Neuberg an der Mürz',
	'AT62145' => 'Sankt Barbara im Mürztal',
	'AT62146' => 'Sankt Marein im Mürztal',
	'AT62147' => 'Thörl',
	'AT62148' => 'Tragöß-Sankt Katharein',
	'AT62202' => 'Bad Blumau',
	'AT62205' => 'Buch-St. Magdalena',
	'AT62206' => 'Burgau',
	'AT62209' => 'Ebersdorf',
	'AT62211' => 'Friedberg',
	'AT62214' => 'Greinbach',
	'AT62216' => 'Großsteinbach',
	'AT62219' => 'Hartberg',
	'AT62220' => 'Hartberg Umgebung',
	'AT62226' => 'Lafnitz',
	'AT62232' => 'Ottendorf an der Rittschein',
	'AT62233' => 'Pinggau',
	'AT62235' => 'Pöllauberg',
	'AT62242' => 'Sankt Jakob im Walde',
	'AT62244' => 'Sankt Johann in der Haide',
	'AT62245' => 'Sankt Lorenzen am Wechsel',
	'AT62247' => 'Schäffern',
	'AT62252' => 'Söchau',
	'AT62256' => 'Stubenberg',
	'AT62262' => 'Wenigzell',
	'AT62264' => 'Bad Waltersdorf',
	'AT62265' => 'Dechantskirchen',
	'AT62266' => 'Feistritztal',
	'AT62267' => 'Fürstenfeld',
	'AT62268' => 'Grafendorf bei Hartberg',
	'AT62269' => 'Großwilfersdorf',
	'AT62270' => 'Hartl',
	'AT62271' => 'Ilz',
	'AT62272' => 'Kaindorf',
	'AT62273' => 'Loipersdorf bei Fürstenfeld',
	'AT62274' => 'Neudau',
	'AT62275' => 'Pöllau',
	'AT62276' => 'Rohr bei Hartberg',
	'AT62277' => 'Rohrbach an der Lafnitz',
	'AT62278' => 'Vorau',
	'AT62279' => 'Waldbach-Mönichwald',
	'AT62311' => 'Edelsbach bei Feldbach',
	'AT62314' => 'Eichkögl',
	'AT62326' => 'Halbenrain',
	'AT62330' => 'Jagerberg',
	'AT62332' => 'Kapfenstein',
	'AT62335' => 'Klöch',
	'AT62343' => 'Mettersdorf am Saßbach',
	'AT62347' => 'Murfeld',
	'AT62368' => 'Tieschen',
	'AT62372' => 'Unterlamm',
	'AT62375' => 'Bad Gleichenberg',
	'AT62376' => 'Bad Radkersburg',
	'AT62377' => 'Deutsch Goritz',
	'AT62378' => 'Fehring',
	'AT62379' => 'Feldbach',
	'AT62380' => 'Gnas',
	'AT62381' => 'Kirchbach-Zerlach',
	'AT62382' => 'Kirchberg an der Raab',
	'AT62383' => 'Mureck',
	'AT62384' => 'Paldau',
	'AT62385' => 'Pirching am Traubenberg',
	'AT62386' => 'Riegersburg',
	'AT62387' => 'Sankt Anna am Aigen',
	'AT62388' => 'Sankt Peter am Ottersbach',
	'AT62389' => 'Sankt Stefan im Rosental',
	'AT62390' => 'Straden',
	'AT70101' => 'Innsbruck',
	'AT70201' => 'Arzl im Pitztal',
	'AT70202' => 'Haiming',
	'AT70203' => 'Imst',
	'AT70204' => 'Imsterberg',
	'AT70205' => 'Jerzens',
	'AT70206' => 'Karres',
	'AT70207' => 'Karrösten',
	'AT70208' => 'Längenfeld',
	'AT70209' => 'Mieming',
	'AT70210' => 'Mils bei Imst',
	'AT70211' => 'Mötz',
	'AT70212' => 'Nassereith',
	'AT70213' => 'Obsteig',
	'AT70214' => 'Oetz',
	'AT70215' => 'Rietz',
	'AT70216' => 'Roppen',
	'AT70217' => 'St. Leonhard im Pitztal',
	'AT70218' => 'Sautens',
	'AT70219' => 'Silz',
	'AT70220' => 'Sölden',
	'AT70221' => 'Stams',
	'AT70222' => 'Tarrenz',
	'AT70223' => 'Umhausen',
	'AT70224' => 'Wenns',
	'AT70301' => 'Absam',
	'AT70302' => 'Aldrans',
	'AT70303' => 'Ampass',
	'AT70304' => 'Axams',
	'AT70305' => 'Baumkirchen',
	'AT70306' => 'Birgitz',
	'AT70307' => 'Ellbögen',
	'AT70308' => 'Flaurling',
	'AT70309' => 'Fritzens',
	'AT70310' => 'Fulpmes',
	'AT70311' => 'Gnadenwald',
	'AT70312' => 'Götzens',
	'AT70313' => 'Gries am Brenner',
	'AT70314' => 'Gries im Sellrain',
	'AT70315' => 'Grinzens',
	'AT70317' => 'Gschnitz',
	'AT70318' => 'Hatting',
	'AT70319' => 'Inzing',
	'AT70320' => 'Kematen in Tirol',
	'AT70322' => 'Kolsass',
	'AT70323' => 'Kolsassberg',
	'AT70325' => 'Lans',
	'AT70326' => 'Leutasch',
	'AT70327' => 'Matrei am Brenner',
	'AT70328' => 'Mieders',
	'AT70329' => 'Mils',
	'AT70330' => 'Mühlbachl',
	'AT70331' => 'Mutters',
	'AT70332' => 'Natters',
	'AT70333' => 'Navis',
	'AT70334' => 'Neustift im Stubaital',
	'AT70335' => 'Oberhofen im Inntal',
	'AT70336' => 'Obernberg am Brenner',
	'AT70337' => 'Oberperfuss',
	'AT70338' => 'Patsch',
	'AT70339' => 'Pettnau',
	'AT70340' => 'Pfaffenhofen',
	'AT70341' => 'Pfons',
	'AT70342' => 'Polling in Tirol',
	'AT70343' => 'Ranggen',
	'AT70344' => 'Reith bei Seefeld',
	'AT70345' => 'Rinn',
	'AT70346' => 'Rum',
	'AT70347' => 'St. Sigmund im Sellrain',
	'AT70348' => 'Scharnitz',
	'AT70349' => 'Schmirn',
	'AT70350' => 'Schönberg im Stubaital',
	'AT70351' => 'Seefeld in Tirol',
	'AT70352' => 'Sellrain',
	'AT70353' => 'Sistrans',
	'AT70354' => 'Hall in Tirol',
	'AT70355' => 'Steinach am Brenner',
	'AT70356' => 'Telfes im Stubai',
	'AT70357' => 'Telfs',
	'AT70358' => 'Thaur',
	'AT70359' => 'Trins',
	'AT70360' => 'Tulfes',
	'AT70361' => 'Unterperfuss',
	'AT70362' => 'Vals',
	'AT70364' => 'Völs',
	'AT70365' => 'Volders',
	'AT70366' => 'Wattenberg',
	'AT70367' => 'Wattens',
	'AT70368' => 'Wildermieming',
	'AT70369' => 'Zirl',
	'AT70401' => 'Aurach bei Kitzbühel',
	'AT70402' => 'Brixen im Thale',
	'AT70403' => 'Fieberbrunn',
	'AT70404' => 'Going am Wilden Kaiser',
	'AT70405' => 'Hochfilzen',
	'AT70406' => 'Hopfgarten im Brixental',
	'AT70407' => 'Itter',
	'AT70408' => 'Jochberg',
	'AT70409' => 'Kirchberg in Tirol',
	'AT70410' => 'Kirchdorf in Tirol',
	'AT70411' => 'Kitzbühel',
	'AT70412' => 'Kössen',
	'AT70413' => 'Oberndorf in Tirol',
	'AT70414' => 'Reith bei Kitzbühel',
	'AT70415' => 'St. Jakob in Haus',
	'AT70416' => 'St. Johann in Tirol',
	'AT70417' => 'St. Ulrich am Pillersee',
	'AT70418' => 'Schwendt',
	'AT70419' => 'Waidring',
	'AT70420' => 'Westendorf',
	'AT70501' => 'Alpbach',
	'AT70502' => 'Angath',
	'AT70503' => 'Bad Häring',
	'AT70504' => 'Brandenberg',
	'AT70505' => 'Breitenbach am Inn',
	'AT70506' => 'Brixlegg',
	'AT70508' => 'Ebbs',
	'AT70509' => 'Ellmau',
	'AT70510' => 'Erl',
	'AT70511' => 'Kirchbichl',
	'AT70512' => 'Kramsach',
	'AT70513' => 'Kufstein',
	'AT70514' => 'Kundl',
	'AT70515' => 'Langkampfen',
	'AT70516' => 'Mariastein',
	'AT70517' => 'Münster',
	'AT70518' => 'Niederndorf',
	'AT70519' => 'Niederndorferberg',
	'AT70520' => 'Radfeld',
	'AT70521' => 'Rattenberg',
	'AT70522' => 'Reith im Alpbachtal',
	'AT70523' => 'Rettenschöss',
	'AT70524' => 'Scheffau am Wilden Kaiser',
	'AT70525' => 'Schwoich',
	'AT70526' => 'Söll',
	'AT70527' => 'Thiersee',
	'AT70528' => 'Angerberg',
	'AT70529' => 'Walchsee',
	'AT70530' => 'Wildschönau',
	'AT70531' => 'Wörgl',
	'AT70601' => 'Faggen',
	'AT70602' => 'Fendels',
	'AT70603' => 'Fiss',
	'AT70604' => 'Fließ',
	'AT70605' => 'Flirsch',
	'AT70606' => 'Galtür',
	'AT70607' => 'Grins',
	'AT70608' => 'Ischgl',
	'AT70609' => 'Kappl',
	'AT70610' => 'Kaunerberg',
	'AT70611' => 'Kaunertal',
	'AT70612' => 'Kauns',
	'AT70613' => 'Ladis',
	'AT70614' => 'Landeck',
	'AT70615' => 'Nauders',
	'AT70616' => 'Pettneu am Arlberg',
	'AT70617' => 'Pfunds',
	'AT70618' => 'Pians',
	'AT70619' => 'Prutz',
	'AT70620' => 'Ried im Oberinntal',
	'AT70621' => 'Sankt Anton am Arlberg',
	'AT70622' => 'Schönwies',
	'AT70623' => 'See',
	'AT70624' => 'Serfaus',
	'AT70625' => 'Spiss',
	'AT70626' => 'Stanz bei Landeck',
	'AT70627' => 'Strengen',
	'AT70628' => 'Tobadill',
	'AT70629' => 'Tösens',
	'AT70630' => 'Zams',
	'AT70701' => 'Abfaltersbach',
	'AT70702' => 'Ainet',
	'AT70703' => 'Amlach',
	'AT70704' => 'Anras',
	'AT70705' => 'Assling',
	'AT70706' => 'Außervillgraten',
	'AT70707' => 'Dölsach',
	'AT70708' => 'Gaimberg',
	'AT70709' => 'Hopfgarten in Defereggen',
	'AT70710' => 'Innervillgraten',
	'AT70711' => 'Iselsberg-Stronach',
	'AT70712' => 'Kals am Großglockner',
	'AT70713' => 'Kartitsch',
	'AT70714' => 'Lavant',
	'AT70715' => 'Leisach',
	'AT70716' => 'Lienz',
	'AT70717' => 'Matrei in Osttirol',
	'AT70718' => 'Nikolsdorf',
	'AT70719' => 'Nußdorf-Debant',
	'AT70720' => 'Oberlienz',
	'AT70721' => 'Obertilliach',
	'AT70723' => 'Prägraten am Großvenediger',
	'AT70724' => 'St. Jakob in Defereggen',
	'AT70725' => 'St. Johann im Walde',
	'AT70726' => 'St. Veit in Defereggen',
	'AT70727' => 'Schlaiten',
	'AT70728' => 'Sillian',
	'AT70729' => 'Strassen',
	'AT70731' => 'Thurn',
	'AT70732' => 'Tristach',
	'AT70733' => 'Untertilliach',
	'AT70734' => 'Virgen',
	'AT70735' => 'Heinfels',
	'AT70801' => 'Bach',
	'AT70802' => 'Berwang',
	'AT70803' => 'Biberwier',
	'AT70804' => 'Bichlbach',
	'AT70805' => 'Breitenwang',
	'AT70806' => 'Ehenbichl',
	'AT70807' => 'Ehrwald',
	'AT70808' => 'Elbigenalp',
	'AT70809' => 'Elmen',
	'AT70810' => 'Forchach',
	'AT70811' => 'Grän',
	'AT70812' => 'Gramais',
	'AT70813' => 'Häselgehr',
	'AT70814' => 'Heiterwang',
	'AT70815' => 'Hinterhornbach',
	'AT70816' => 'Höfen',
	'AT70817' => 'Holzgau',
	'AT70818' => 'Jungholz',
	'AT70819' => 'Kaisers',
	'AT70820' => 'Lechaschau',
	'AT70821' => 'Lermoos',
	'AT70822' => 'Musau',
	'AT70823' => 'Namlos',
	'AT70824' => 'Nesselwängle',
	'AT70825' => 'Pfafflar',
	'AT70826' => 'Pflach',
	'AT70827' => 'Pinswang',
	'AT70828' => 'Reutte',
	'AT70829' => 'Schattwald',
	'AT70830' => 'Stanzach',
	'AT70831' => 'Steeg',
	'AT70832' => 'Tannheim',
	'AT70833' => 'Vils',
	'AT70834' => 'Vorderhornbach',
	'AT70835' => 'Wängle',
	'AT70836' => 'Weißenbach am Lech',
	'AT70837' => 'Zöblen',
	'AT70901' => 'Achenkirch',
	'AT70902' => 'Aschau im Zillertal',
	'AT70903' => 'Brandberg',
	'AT70904' => 'Bruck am Ziller',
	'AT70905' => 'Buch in Tirol',
	'AT70907' => 'Eben am Achensee',
	'AT70908' => 'Finkenberg',
	'AT70909' => 'Fügen',
	'AT70910' => 'Fügenberg',
	'AT70911' => 'Gallzein',
	'AT70912' => 'Gerlos',
	'AT70913' => 'Gerlosberg',
	'AT70914' => 'Hainzenberg',
	'AT70915' => 'Hart im Zillertal',
	'AT70916' => 'Hippach',
	'AT70917' => 'Jenbach',
	'AT70918' => 'Kaltenbach',
	'AT70920' => 'Mayrhofen',
	'AT70921' => 'Pill',
	'AT70922' => 'Ramsau im Zillertal',
	'AT70923' => 'Ried im Zillertal',
	'AT70924' => 'Rohrberg',
	'AT70925' => 'Schlitters',
	'AT70926' => 'Schwaz',
	'AT70927' => 'Schwendau',
	'AT70928' => 'Stans',
	'AT70929' => 'Steinberg am Rofan',
	'AT70930' => 'Strass im Zillertal',
	'AT70931' => 'Stumm',
	'AT70932' => 'Stummerberg',
	'AT70933' => 'Terfens',
	'AT70934' => 'Tux',
	'AT70935' => 'Uderns',
	'AT70936' => 'Vomp',
	'AT70937' => 'Weer',
	'AT70938' => 'Weerberg',
	'AT70939' => 'Wiesing',
	'AT70940' => 'Zell am Ziller',
	'AT70941' => 'Zellberg',
	'AT80101' => 'Bartholomäberg',
	'AT80102' => 'Blons',
	'AT80103' => 'Bludenz',
	'AT80104' => 'Bludesch',
	'AT80105' => 'Brand',
	'AT80106' => 'Bürs',
	'AT80107' => 'Bürserberg',
	'AT80108' => 'Dalaas',
	'AT80109' => 'Fontanella',
	'AT80110' => 'Gaschurn',
	'AT80111' => 'Innerbraz',
	'AT80112' => 'Klösterle',
	'AT80113' => 'Lech',
	'AT80114' => 'Lorüns',
	'AT80115' => 'Ludesch',
	'AT80116' => 'Nenzing',
	'AT80117' => 'Nüziders',
	'AT80118' => 'Raggal',
	'AT80119' => 'St. Anton im Montafon',
	'AT80120' => 'St. Gallenkirch',
	'AT80121' => 'St. Gerold',
	'AT80122' => 'Schruns',
	'AT80123' => 'Silbertal',
	'AT80124' => 'Sonntag',
	'AT80125' => 'Stallehr',
	'AT80126' => 'Thüringen',
	'AT80127' => 'Thüringerberg',
	'AT80128' => 'Tschagguns',
	'AT80129' => 'Vandans',
	'AT80201' => 'Alberschwende',
	'AT80202' => 'Andelsbuch',
	'AT80203' => 'Au',
	'AT80204' => 'Bezau',
	'AT80205' => 'Bildstein',
	'AT80206' => 'Bizau',
	'AT80207' => 'Bregenz',
	'AT80208' => 'Buch',
	'AT80209' => 'Damüls',
	'AT80210' => 'Doren',
	'AT80211' => 'Egg',
	'AT80212' => 'Eichenberg',
	'AT80213' => 'Fußach',
	'AT80214' => 'Gaißau',
	'AT80215' => 'Hard',
	'AT80216' => 'Hittisau',
	'AT80217' => 'Höchst',
	'AT80218' => 'Hörbranz',
	'AT80219' => 'Hohenweiler',
	'AT80220' => 'Kennelbach',
	'AT80221' => 'Krumbach',
	'AT80222' => 'Langen bei Bregenz',
	'AT80223' => 'Langenegg',
	'AT80224' => 'Lauterach',
	'AT80225' => 'Lingenau',
	'AT80226' => 'Lochau',
	'AT80227' => 'Mellau',
	'AT80228' => 'Mittelberg',
	'AT80229' => 'Möggers',
	'AT80230' => 'Reuthe',
	'AT80231' => 'Riefensberg',
	'AT80232' => 'Schnepfau',
	'AT80233' => 'Schoppernau',
	'AT80234' => 'Schröcken',
	'AT80235' => 'Schwarzach',
	'AT80236' => 'Schwarzenberg',
	'AT80237' => 'Sibratsgfäll',
	'AT80238' => 'Sulzberg',
	'AT80239' => 'Warth',
	'AT80240' => 'Wolfurt',
	'AT80301' => 'Dornbirn',
	'AT80302' => 'Hohenems',
	'AT80303' => 'Lustenau',
	'AT80401' => 'Altach',
	'AT80402' => 'Düns',
	'AT80403' => 'Dünserberg',
	'AT80404' => 'Feldkirch',
	'AT80405' => 'Frastanz',
	'AT80406' => 'Fraxern',
	'AT80407' => 'Göfis',
	'AT80408' => 'Götzis',
	'AT80409' => 'Klaus',
	'AT80410' => 'Koblach',
	'AT80411' => 'Laterns',
	'AT80412' => 'Mäder',
	'AT80413' => 'Meiningen',
	'AT80414' => 'Rankweil',
	'AT80415' => 'Röns',
	'AT80416' => 'Röthis',
	'AT80417' => 'Satteins',
	'AT80418' => 'Schlins',
	'AT80419' => 'Schnifis',
	'AT80420' => 'Sulz',
	'AT80421' => 'Übersaxen',
	'AT80422' => 'Viktorsberg',
	'AT80423' => 'Weiler',
	'AT80424' => 'Zwischenwasser',
	'AT90001' => 'Wien',
];
