<?php

/**
 * List of cities for: United Arab Emirates
 * Source: https://en.wikipedia.org/wiki/List_of_cities_in_the_United_Arab_Emirates
 * Version: 1.1
 * Author: Condless
 * Author URI: https://www.condless.com/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit;

$country_states = [
	'AEAZ'	=> _x( 'Abu Dhabi', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AEAJ'	=> _x( 'Ajmān', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AEFU'	=> _x( 'Fujairah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AESH'	=> _x( 'Sharjah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AEDU'	=> _x( 'Dubai', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AERK'	=> _x( 'Ras Al Khaimah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	'AEUQ'	=> _x( 'Umm Al Quwain', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
];

$country_cities = [
	'AEAZ' => [
		'AEABU_DHABI'	=> _x( 'Abu Dhabi', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_AIN'	=> _x( 'Al Ain', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMADINAT_ZAYED'	=> _x( 'Madinat Zayed', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AERUWAIS'	=> _x( 'Ruwais', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AELIWA_OASIS'	=> _x( 'Liwa Oasis', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEGHAYATHI'	=> _x( 'Ghayathi', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEABU_AL_ABYAD'	=> _x( 'Abu al Abyad', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_AJBAN'	=> _x( 'Al Ajban', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_ARYAM'	=> _x( 'Al Aryam', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_MIRFA'	=> _x( 'Al Mirfa', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_SHUWAIB'	=> _x( 'Al Shuwaib', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_YAHAR'	=> _x( 'Al Yahar', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDALMA'	=> _x( 'Dalma', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEHABSHAN'	=> _x( 'Habshan', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMARAWAH'	=> _x( 'Marawah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AENAHIL'	=> _x( 'Nahil', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AESILA'	=> _x( 'Sila', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AESIR_BANI_YAS'	=> _x( 'Sir Bani Yas', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AESWEIHAN'	=> _x( 'Sweihan', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_FAQA'	=> _x( 'Al Faqa', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_KHAZNAH'	=> _x( 'Al Khaznah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEABU_SAMRAH'	=> _X( 'Abu Samrah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_QOUA'	=> _X( 'Al Qoua', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_WIQAN'	=> _X( 'Al Wiqan', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_BIHOUTH'	=> _X( 'Al Bihouth', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_SELHA'	=> _X( 'Al Selha', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AEAJ' => [
		'AEAJMAN'	=> _x( 'Ajman', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_MANAMA'	=> _x( 'Al Manama', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMASFUT'	=> _x( 'Masfut', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AEDU' => [
		'AEDUBAI'	=> _x( 'Dubai', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEJEBEL_ALI'	=> _x( 'Jebel Ali', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEHATTA'	=> _x( 'Hatta', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_AWIR'	=> _x( 'Al Awir', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_KHAWANEEJ'	=> _x( 'Al Khawaneej', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_LISAILI'	=> _x( 'Al Lisaili', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AELAHBAB'	=> _x( 'Lahbab', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AEFU' => [
		'AEFUJAIRAH'	=> _x( 'Fujairah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDIBBA_AL-FUJAIRAH'	=> _x( 'Dibba Al-Fujairah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_BADIYAH'	=> _x( 'Al Badiyah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_BITHNAH'	=> _x( 'Al Bithnah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_HALAH'	=> _x( 'Al Halah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDADNA'	=> _x( 'Dadna', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEGHUB'	=> _x( 'Ghub', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMIRBAH'	=> _x( 'Mirbah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEZUBARAH'	=> _x( 'Zubarah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AERK' => [
		'AERAS_AL_KHAIMAH_CITY'	=> _x( 'Ras Al Khaimah City', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAR-RAMS'	=> _x( 'Ar-Rams', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEADHEN'	=> _x( 'Adhen', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_HAMRANIYAH'	=> _x( 'Al Hamraniyah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_JAZIRAH_AL_HAMRA'	=> _x( 'Al Jazirah Al Hamra', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_JEER'	=> _x( 'Al Jeer', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_QUSAIDAT'	=> _x( 'Al Qusaidat', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_QOR'	=> _x( 'Al Qor', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEASIMAH'	=> _x( 'Asimah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDIGDAGA'	=> _x( 'Digdaga', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEGHALILAH'	=> _x( 'Ghalilah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEHUWAYLAT'	=> _x( 'Huwaylat', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEKHATT'	=> _x( 'Khatt', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEKHOR_KHWAIR'	=> _x( 'Khor Khwair', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AESHAAM'	=> _x( 'Shaam', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEWADI_SHAH'	=> _x( 'Wadi Shah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMASAFI'	=> _x( 'Masafi', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AESH' => [
		'AESHARJAH'	=> _x( 'Sharjah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEKHOR_FAKKAN'	=> _x( 'Khor Fakkan', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEKALBA'	=> _x( 'Kalba', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDHAID'	=> _x( 'Dhaid', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEDIBBA_AL-HISN'	=> _x( 'Dibba Al-Hisn', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_MADAM'	=> _x( 'Al Madam', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_BATAEH'	=> _x( 'Al Bataeh', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_HAMRIYAH'	=> _x( 'Al Hamriyah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEMLEIHA'	=> _x( 'Mleiha', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	],
	'AEUQ' => [
		'AEUMM_AL_QUWAIN'	=> _x( 'Umm Al Quwain', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_RAFAAH'	=> _x( 'Al Rafaah', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEAL_RASHIDYA'	=> _x( 'Al Rashidya', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
		'AEFALAJ_AL_MUALLA'	=> _x( 'Falaj Al Mualla', 'AE-cities', 'cities-shipping-zones-for-woocommerce' ),
	]
];
