<?php
if (!defined('WPINC')) {
    die;
}

class ACO_WC_Checkout_Utils {
    public static function get_core_fields() {
        $default_fields = [
            'email' => [
                'id' => 'billing_email',
                'label' => __('Email address', 'woocommerce'),
                'optionalLabel' => __('Email address (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'email',
                'autocapitalize' => 'none',
                'type' => 'email',
                'index' => 0,
                'enable' => true,
                'validation' => 'email',
                'location' => 'contact',
                'is_default' => true,
            ],
            'country' => [
                'id' => 'shipping_country',
                'label' => __('Country/Region', 'woocommerce'),
                'optionalLabel' => __('Country/Region (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'country',
                'index' => 1,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'select',
                'is_default' => true,
            ],
            'first_name' => [
                'id' => 'shipping_first_name',
                'label' => __('First name', 'woocommerce'),
                'optionalLabel' => __('First name (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'given-name',
                'autocapitalize' => 'sentences',
                'index' => 10,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'last_name' => [
                'id' => 'shipping_last_name',
                'label' => __('Last name', 'woocommerce'),
                'optionalLabel' => __('Last name (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'family-name',
                'autocapitalize' => 'sentences',
                'index' => 20,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'company' => [
                'id' => 'shipping_company',
                'label' => __('Company', 'woocommerce'),
                'optionalLabel' => __('Company (optional)', 'woocommerce'),
                'required' => false,
                'hidden' => false,
                'autocomplete' => 'organization',
                'autocapitalize' => 'sentences',
                'index' => 30,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'address_1' => [
                'id' => 'shipping_address_1',
                'label' => __('Address', 'woocommerce'),
                'optionalLabel' => __('Address (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'address-line1',
                'autocapitalize' => 'sentences',
                'index' => 40,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'address_2' => [
                'id' => 'shipping_address_2',
                'label' => __('Apartment, suite, etc.', 'woocommerce'),
                'optionalLabel' => __('Apartment, suite, etc. (optional)', 'woocommerce'),
                'required' => false,
                'hidden' => false,
                'autocomplete' => 'address-line2',
                'autocapitalize' => 'sentences',
                'index' => 50,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'city' => [
                'id' => 'shipping_city',
                'label' => __('City', 'woocommerce'),
                'optionalLabel' => __('City (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'address-level2',
                'autocapitalize' => 'sentences',
                'index' => 70,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'state' => [
                'id' => 'shipping_state',
                'label' => __('State', 'woocommerce'),
                'optionalLabel' => __('State (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'address-level1',
                'autocapitalize' => 'sentences',
                'index' => 80,
                'enable' => true,
                'validation' => '',
                'location' => 'address',
                'type' => 'select',
                'is_default' => true,
            ],
            'postcode' => [
                'id' => 'shipping_postcode',
                'label' => __('Postal code', 'woocommerce'),
                'optionalLabel' => __('Postal code (optional)', 'woocommerce'),
                'required' => true,
                'hidden' => false,
                'autocomplete' => 'postal-code',
                'autocapitalize' => 'characters',
                'index' => 90,
                'enable' => true,
                'validation' => 'postcode',
                'location' => 'address',
                'type' => 'text',
                'is_default' => true,
            ],
            'phone' => [
                'id' => 'billing_phone',
                'label' => __('Phone', 'woocommerce'),
                'optionalLabel' => __('Phone (optional)', 'woocommerce'),
                'required' => false,
                'hidden' => false,
                'type' => 'tel',
                'autocomplete' => 'tel',
                'autocapitalize' => 'characters',
                'index' => 100,
                'enable' => true,
                'validation' => 'phone',
                'location' => 'address',
                'is_default' => true,
            ],
        ];

        // Get customized default fields
        $customized_fields = get_option('aco_wc_checkout_default_fields', []);
        
        // Merge customizations with default fields
        foreach ($customized_fields as $id => $customizations) {
            if (isset($default_fields[$id])) {
                $default_fields[$id] = array_merge($default_fields[$id], $customizations);
            }
        }

        return $default_fields;
    }
}