<?php
$items = $this->db_obj->get_items();

$all_items = CBFunctions()->get_all_charts_count();
$chart_count_per_page = count($items) > 0 ? $all_items/$this->db_obj->get_pagination_count() : 0;
$chart_paged = isset($_GET['paged']) && $_GET['paged'] != '' ? absint( sanitize_text_field(wp_unslash($_GET['paged']))) : '';
$search = $this->db_obj->get_search_value();
$chart_max_id = Chart_Builder_Admin::get_max_id('charts');
$this->settings_obj = new Chart_Builder_Settings_DB_Actions($this->plugin_name);
$chart_title_length = $this->settings_obj->get_listtables_title_length();
$filter_by_type = (isset($_GET['filterbytype']) && $_GET['filterbytype'] != "") ? intval(sanitize_text_field(wp_unslash($_GET['filterbytype']))) : '';
$filter_by_source = (isset($_GET['filterbysource']) && $_GET['filterbysource'] != "") ? intval(sanitize_text_field(wp_unslash($_GET['filterbysource']))) : '';
$filter_by_chart_source = (isset($_GET['filterbychartsource']) && $_GET['filterbychartsource'] != "") ? intval(sanitize_text_field(wp_unslash($_GET['filterbychartsource']))) : '';
$filter_by_date = (isset($_GET['filterbydate']) && $_GET['filterbydate'] != "") ? sanitize_text_field(wp_unslash($_GET['filterbydate'])) : '';
$order_by = (isset($_GET['orderby']) && $_GET['orderby'] != "") ? sanitize_text_field(wp_unslash($_GET['orderby'])) : '';
$order = (isset($_GET['order']) && $_GET['order'] != "") ? sanitize_text_field(wp_unslash($_GET['order'])) : 'desc';
$chart_types = array(
    "Line Chart",
    "Bar Chart",
    "Pie Chart",
    "Column Chart",
    "Org Chart",
    "Donut Chart",
);
$chart_sources = array(
    "Manual",
    "Quiz Maker",
    "File Import",
    "Google Sheet",
    "Database Query",
    "Woocommerce",
);
$chart_source_types = array(
    "Google Charts",
    "Chart.js",
);
$chart_dates = array(
    'today' => __("Today", "chart-builder"),
    'yesterday' => __("Yesterday", "chart-builder"),
    'last_week' => __("Last Week", "chart-builder"),
    'last_month' => __("Last Month", "chart-builder"),
    'last_year' => __("Last Year", "chart-builder"),
);
$order_by_values = array(
    'title' => __("Title", "chart-builder"),
    'date_created' => __("Date created", "chart-builder"),
    'date_modified' => __("Date modified", "chart-builder"),
);
$order_values = array(
    'asc' => __("Ascending", "chart-builder"),
    'desc' => __("Descending", "chart-builder"),
);
$filter_by_author_data = $this->db_obj->get_searched_author_info();

$plus_icon_svg = "<span class=''><img src='". esc_url(plugins_url('/images/icons/plus-icon.svg', dirname(__FILE__, 2))) ."'></span>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
$youtube_icon_svg = "<span class=''><img src='". esc_url(plugins_url('/images/icons/youtube-video-icon.svg', dirname(__FILE__, 2)))  ."'></span>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage

?>
<div class="wrap ays_charts_list_table">
    <div class="ays-chart-heading-box">
        <div class="ays-chart-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-chart-builder-plugin-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                <i class="ays_fa ays_fa_file_text" ></i> 
                <span style="margin-left: 3px;text-decoration: underline;">View Documentation</span>
            </a>
        </div>
    </div>
    <h1 class="wp-heading-inline">
        <?php
        echo esc_html( get_admin_page_title() );
        ?>
    </h1>

    <div class="ays-chart-add-new-button-box" style="margin-top: 10px;">
        <?php
            $svg_sanitize_properties = Chart_Builder_Admin::chart_builder_svg_sanitize_allowed_properties();
            $sanitized_plus_icon_svg = wp_kses($plus_icon_svg, $svg_sanitize_properties);
            echo sprintf( '<a href="?page=%s&action=%s" class="btn btn-primary chart-add-new-bttn chart-add-new-button-new-design"> %s ' . esc_html__( 'Add New', "chart-builder" ) . '</a>', esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page'])) ), 'add',wp_kses_post($sanitized_plus_icon_svg));
        ?>
    </div>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder">
            <div id="post-body-content">
                <div class="meta-box-sortables ui-sortable chart-list-table-container">
                    <form method="post">
                        <div class="ays-chart-table-actions-row">
                            <div class="ays-chart-table-actions-row-section">
                                <div class="ays-chart-delete-button">
                                    <?php wp_nonce_field( $this->plugin_name . '-bulk-delete' ); ?>
                                    <button name="bulk_delete" id="ays-chart-bulk-delete" disabled><i class="ays_fa ays_fa_trash"></i><?php echo esc_html(__( 'Delete', "chart-builder" )); ?></button>
                                    <button type="submit" name="bulk_delete_confirm" id="ays-chart-bulk-delete-confirm" style="display: none;"></button>
                                </div>
                                <div class="ays-chart-filter-section">
                                    <select name="filterbytype" id="ays-chart-filter-select">
                                        <option value=""><?php echo esc_html__( "Select Type", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_types as $k => $v ):
                                            $selected = ( $filter_by_type == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbysource" id="ays-chart-filter-source">
                                        <option value=""><?php echo esc_html__( "Select Source", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_sources as $k => $v ):
                                            $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $filter_by_source == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?> <?php echo esc_attr($disabled); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbychartsource" id="ays-chart-filter-chart-source">
                                        <option value=""><?php echo esc_html__( "Select Chart Source", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_source_types as $k => $v ):
                                            $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $filter_by_chart_source == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?> <?php echo esc_attr($disabled); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbydate" id="ays-chart-filter-date">
                                        <option value=""><?php echo esc_html__( "Select Date", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_dates as $k => $v ):
                                            $selected = ( $filter_by_date == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbyauthor" id="ays-chart-filter-author">
                                        <?php if (isset($filter_by_author_data) && !empty($filter_by_author_data)): ?>
                                            <option value="<?php echo esc_attr($filter_by_author_data['ID'])?>" selected><?php echo esc_html($filter_by_author_data['display_name'])?></option>
                                        <?php endif; ?>
                                    </select>
                                    <select name="orderby" id="ays-chart-order-by">
                                        <option value=""><?php echo esc_html__( "Order by", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $order_by_values as $k => $v ):
                                            // $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $order_by == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="order" id="ays-chart-order">
                                        <?php
                                        foreach ( $order_values as $k => $v ):
                                            $selected = ( $order == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <button type="submit" name="ays_chart_filter" id="ays-chart-filter"><?php echo esc_html(__( 'Filter', "chart-builder" )); ?></button>
                                    <button type="submit" name="ays_chart_filter_clear" id="ays-chart-filter-clear"><?php echo esc_html(__( 'Clear filters', "chart-builder" )); ?></button>
                                </div>
                            </div>
                            <div class="ays-chart-search-block">
                                <input type="text" name="s" id="ays-chart-search-input" value="<?php echo esc_attr($search); ?>">
                                <button type="submit" name="ays_chart_search" id="ays-chart-search"><?php echo esc_html(__( 'Search', "chart-builder" )); ?></button>
                            </div>
                        </div>
                        <table class="chart-list-table table">
                            <thead>
                                <tr>
                                    <th class="column-cb">
                                        <input type="checkbox" class="form-check-input select-all" value="" />
                                    </th>
                                    <th class="column-title"><?php echo esc_html(__( 'Title', "chart-builder" )); ?></th>
                                    <th class="column-type"><?php echo esc_html(__( 'Type', "chart-builder" )); ?></th>
                                    <th class="column-source-type"><?php echo esc_html(__( 'Source', "chart-builder" )); ?></th>
                                    <th class="column-chart-source"><?php echo esc_html(__( 'Chart Source', "chart-builder" )); ?></th>
                                    <th class="column-shortcode"><?php echo esc_html(__( 'Shortcode', "chart-builder" )); ?></th>
                                    <th class="column-author"><?php echo esc_html(__( 'Author', "chart-builder" )); ?></th>
                                    <th class="column-status"><?php echo esc_html(__( 'Status', "chart-builder" )); ?></th>
                                    <th class="column-date"><?php echo esc_html(__( 'Date', "chart-builder" )); ?></th>
                                    <th class="column-id"><?php echo esc_html(__( 'ID', "chart-builder" )); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if ( !empty( $items ) ): ?>
                            <?php foreach ( $items as $key => $item ): ?>
                                <tr>
                                    <td class="column-cb">
                                        <input type="checkbox" class="form-check-input check-current-row" name="bulk-delete[]" value="<?php echo esc_attr($item['id']) ?>" />
                                    </td>
                                    <td class="column-title"><?php
                                        if($item['status'] == 'trashed'){
                                            $delete_nonce = wp_create_nonce( $this->plugin_name . '-trash-item' );
                                        }else{
                                            $delete_nonce = wp_create_nonce( $this->plugin_name . '-delete-item' );
                                        }
                                        $publish_nonce = wp_create_nonce( $this->plugin_name . '-publish-item' );
                                        $unpublish_nonce = wp_create_nonce( $this->plugin_name . '-unpublish-item' );
                                        $duplicate_nonce = wp_create_nonce( $this->plugin_name . '-duplicate-item' );
                                        $chart_title = stripcslashes( $item['title'] );
                                        $q = esc_attr( $chart_title );
                                        $custom_post_id = isset($item['custom_post_id']) && $item['custom_post_id'] != 0 && $item['custom_post_id'] != '' ? esc_attr(intval($item['custom_post_id'])) : 0;
                                        $restitle = Chart_Builder_Admin::ays_restriction_string("word", $chart_title, $chart_title_length); 
                                        $actions = array();
                                        if($item['status'] == 'trashed'){
                                            $title = sprintf( '<strong><a>%s</a></strong>', $restitle );
                                            $actions['restore'] = sprintf( '<a href="?page=%s&action=%s&id=%d&_wpnonce=%s">'. __('Restore', "chart-builder") .'</a>',  esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page']))), 'restore', absint( $item['id'] ), $delete_nonce );
                                            $actions['delete'] = sprintf( '<a class="ays_confirm_del" data-message="%s" href="?page=%s&action=%s&id=%s&_wpnonce=%s">'. esc_html__('Delete Permanently', "chart-builder") .'</a>', $restitle, esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'delete', absint( $item['id'] ), $delete_nonce );
                                        }else{
                                            $actions['edit'] = sprintf( '<a class="btn btn-primary btn-sm" href="?page=%s&action=%s&id=%d" data-bs-toggle="tooltip" title="'. esc_html(__('Edit',"chart-builder")) .'"><i class="ays_fa ays_fa_pen_to_square"></i></a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'edit', absint( $item['id'] ) );
                                            
                                            $draft_text = '';
                                            if( $item['status'] == 'draft' && !( isset( $_GET['fstatus'] ) && $_GET['fstatus'] == 'draft' )){
                                                $draft_text = ' — ' . '<span class="post-state">' . __( "Draft", "chart-builder" ) . '</span>';
                                                $actions['publish'] = sprintf( '<a class="btn btn-primary btn-sm" href="?page=%s&action=%s&id=%s&_wpnonce=%s" data-bs-toggle="tooltip" title="'. esc_html(__('Publish',"chart-builder")) .'"><i class="ays_fa ays_fa_unpublished"></i></a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'publish', absint( $item['id'] ), $publish_nonce );
                                            } else {
                                                $actions['unpublish'] = sprintf( '<a class="btn btn-primary btn-sm" href="?page=%s&action=%s&id=%s&_wpnonce=%s" data-bs-toggle="tooltip" title="'. esc_html(__('Unpublish',"chart-builder")) .'"><i class="ays_fa ays_fa_published"></i></a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'unpublish', absint( $item['id'] ), $unpublish_nonce );
                                            }

                                            $title = sprintf( '<strong><a href="?page=%s&action=%s&id=%d" title="%s">%s</a>%s</strong>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'edit', absint( $item['id'] ), $q, $restitle, $draft_text );
                                            if($custom_post_id > 0){
                                                $actions['custom_posts'] = sprintf( '<a href="%s" class="btn btn-primary btn-sm" target="_blank"><i class="fa fa-eye"></i></a>', esc_url( add_query_arg( 'preview', 'true', get_permalink($custom_post_id) ) ));
                                            }                                                                 
                                            $actions['duplicate'] = sprintf( '<a class="btn btn-primary btn-sm" href="?page=%s&action=%s&id=%s&_wpnonce=%s" data-bs-toggle="tooltip" title="'. esc_html(__('Duplicate',"chart-builder")) .'"><i class="ays_fa ays_fa_copy"></i></a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'duplicate', absint( $item['id'] ), $duplicate_nonce );
                                            
                                            $actions['delete'] = sprintf( '<a class="ays_chart_delete_confirm btn btn-danger btn-sm" href="?page=%s&action=%s&id=%s&_wpnonce=%s" data-bs-toggle="tooltip" title="'. esc_html(__('Delete',"chart-builder")) .'"><i class="ays_fa ays_fa_trash_o"></i></a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'delete', absint( $item['id'] ), $delete_nonce );
                                        }
                                        echo wp_kses_post($title);

                                        echo '<p class="chart-list-table-actions-row">';
                                        foreach ( $actions as $action => $action_html ){
                                            $link_class = '';
                                            // if( $action == 'delete' ){
                                            //     $link_class = 'link-danger';
                                            // }
                                            echo '<span class="chart-list-table-action-link ' . esc_attr( $link_class ) . '">';
                                            echo wp_kses_post( $action_html ); 
                                            echo '</span>';
                                        }
                                        echo '</p>';
                                    ?></td>
                                    <td class="column-type"><?php
		                                switch ($item['source_chart_type']) {
                                            case 'line_chart':
				                                echo "<p><img src='" . esc_url(plugins_url('/images/icons/line-chart.png', dirname(__FILE__, 2))) . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Line Chart', 'chart-builder') . "</span></p>";
				                                break;

			                                case 'bar_chart':
				                                echo "<p><img src='" .  esc_url(plugins_url('/images/icons/bar-chart.png', dirname(__FILE__, 2))) . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Bar Chart', "chart-builder") . "</span></p>";
				                                break;

			                                case 'pie_chart':
				                                echo "<p><img src='" .  esc_url(plugins_url('/images/icons/pie-chart.png', dirname(__FILE__, 2)))  . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Pie Chart', "chart-builder") . "</span></p>";
				                                break;

			                                case 'column_chart':
				                                echo "<p><img src='" .  esc_url(plugins_url('/images/icons/column-chart.png', dirname(__FILE__, 2))) . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Column Chart', "chart-builder") . "</span></p>";
				                                break;
		                                
                                            case 'donut_chart':
                                                echo "<p><img src='" . esc_url(plugins_url('/images/icons/donut-chart.png', dirname(__FILE__, 2))) . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
                                                echo "<span style='margin-left: 8px'>" . esc_html__('Donut Chart', "chart-builder") . "</span></p>";
                                                break;
                                                
                                            case 'org_chart':
                                                echo "<p><img src='" . esc_url(plugins_url('/images/icons/org-chart.png', dirname(__FILE__, 2))) . "' width='20px'>";// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
                                                echo "<span style='margin-left: 8px'>" . esc_html__('Org Chart', 'chart-builder') . "</span></p>";
                                                break;
                                        }
                                    ?></td>
                                    <td class="column-source-type"><?php
		                                switch ($item['source_type']) {
                                            case 'quiz_maker':
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Quiz Maker', 'chart-builder') . "</span>";
				                                break;
                                            case 'manual':
                                            default:
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Manual', 'chart-builder') . "</span>";
				                                break;
		                                }
                                    ?></td>
                                    <td class="column-chart-source"><?php
		                                switch ($item['type']) {
                                            case 'chart-js':
				                                echo "<span style='margin-left: 8px'>" . esc_html__('Chart.js', 'chart-builder') . "</span>";
				                                break;
                                            case 'google-charts':
                                            default:
                                                echo "<span style='margin-left: 8px'>" . esc_html__('Google Charts', 'chart-builder') . "</span>";
                                            break;
		                                }
                                    ?></td>
                                    <td class="column-shortcode">
                                        <div class="ays-chart-shortcode-container">
                                            <div class="ays-chart-copy-image" data-bs-toggle="tooltip" title="<?php echo esc_html(__('Click to copy',"chart-builder"));?>">
                                                <img src='<?php echo esc_url(CHART_BUILDER_ADMIN_URL) . "/images/icons/copy-image.svg" ?>'>
                                            </div>
                                            <!-- <input type="text" class="ays-chart-shortcode-input" onClick="this.setSelectionRange(0, this.value.length)" readonly value="<//?php echo esc_attr('[ays_chart id="'. $item['id'] .'"]') ?>" /> -->
                                            <input type="text" class="ays-chart-shortcode-input" readonly value="<?php echo esc_attr('[ays_chart id="'. $item['id'] .'"]') ?>" />
                                        </div>
                                    </td>
                                    <td class="column-author"><?php
		                                $author = get_user_by("id", $item['author_id']);
                                        if( $author ){
                                            $author_name = $author->data->display_name;
                                            echo esc_html($author_name);
                                        } else {
                                            echo '<span style="color:red">'. esc_html__('Deleted user', 'chart-builder').'</span>';
                                        }
                                    ?></td>
                                    <td class="column-status"><?php
                                        $status = ucfirst( $item['status'] );
                                        $html = "<p style='font-size:14px;margin:0;'>" . $status . "</p>";
                                        
                                		echo wp_kses_post( $html );
                                    ?></td>
                                    <td class="column-date"><?php
                                        $date = gmdate( 'Y/m/d', strtotime( $item['date_modified'] ) );
                                        $title_date = gmdate( 'l jS \of F Y h:i:s A', strtotime( $item['date_modified'] ) );
                                        $html = "<p style='font-size:14px;margin:0;text-decoration: dotted underline;' title='" . $title_date . "'>" . $date . "</p>";
                                        
                                		echo wp_kses_post( $html );
                                    ?></td>
                                    <td class="column-id"><?php echo esc_attr($item['id']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8"><?php echo esc_html(__( 'There are no items yet.', "chart-builder" )); ?></td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                        <div class="ays-chart-table-actions-row">
                            <div class="ays-chart-table-actions-row-section">
                                <div class="ays-chart-delete-button">
                                    <button name="bulk_delete" id="ays-chart-bulk-delete-bottom" disabled><i class="ays_fa ays_fa_trash"></i><?php echo esc_html(__( 'Delete', "chart-builder" )); ?></button>
                                    <button type="submit" name="bulk_delete_confirm" id="ays-chart-bulk-delete-confirm-bottom" style="display: none;"></button>
                                </div>
                                <div class="ays-chart-filter-section">
                                    <select name="filterbytype" id="ays-chart-filter-select-bottom">
                                        <option value=""><?php echo esc_html__( "Select Type", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_types as $k => $v ):
                                            $selected = ( $filter_by_type == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbysource" id="ays-chart-filter-source-bottom">
                                        <option value=""><?php echo esc_html__( "Select Source", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_sources as $k => $v ):
                                            $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $filter_by_source == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?> <?php echo esc_attr($disabled); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbychartsource" id="ays-chart-filter-chart-source-bottom">
                                        <option value=""><?php echo esc_html__( "Select Chart Source", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_source_types as $k => $v ):
                                            $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $filter_by_chart_source == ($k+1) ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k+1); ?>" <?php echo esc_attr($selected); ?> <?php echo esc_attr($disabled); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbydate" id="ays-chart-filter-date-bottom">
                                        <option value=""><?php echo esc_html__( "Select Date", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $chart_dates as $k => $v ):
                                            $selected = ( $filter_by_date == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="filterbyauthor" id="ays-chart-filter-author-bottom">
                                        <?php if (isset($filter_by_author_data) && !empty($filter_by_author_data)): ?>
                                            <option value="<?php echo esc_html($filter_by_author_data['ID'])?>" selected><?php echo esc_html($filter_by_author_data['display_name'])?></option>
                                        <?php endif; ?>
                                    </select>
                                    <select name="orderby" id="ays-chart-order-by-bottom">
                                        <option value=""><?php echo esc_html__( "Order by", "chart-builder" ) ?></option>
                                        <?php
                                        foreach ( $order_by_values as $k => $v ):
                                            // $disabled = $k >= 2 ? 'disabled' : '' ;
                                            $selected = ( $order_by == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <select name="order" id="ays-chart-order-bottom">
                                        <?php
                                        foreach ( $order_values as $k => $v ):
                                            $selected = ( $order == $k ) ? 'selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($k); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($v); ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                    <button type="submit" name="ays_chart_filter" id="ays-chart-filter-bottom"><?php echo esc_html(__( 'Filter', "chart-builder" )); ?></button>
                                    <button type="submit" name="ays_chart_filter_clear" id="ays-chart-filter-clear-bottom"><?php echo esc_html(__( 'Clear filters', "chart-builder" )); ?></button>
                                </div>
                            </div>
                            <?php if($chart_count_per_page > 1):?>
                                <div class>
                                    <nav aria-label="Pagination" class="m-0">
                                        <ul class="pagination m-0 p-2">
                                        <?php for( $i = 0; $i < $chart_count_per_page; $i++ ):
                                            $url = esc_url_raw( remove_query_arg( false ) );
                                            $url = esc_url_raw( add_query_arg( array(
                                                'paged' => $i + 1
                                            ), $url ) );

                                            $active = '';
                                            if( $chart_paged != '' ){
                                                if( $chart_paged == $i + 1 ) {
                                                    $active = 'active';
                                                }
                                            } else {
                                                wp_safe_redirect($_SERVER['REQUEST_URI'] . "&paged=1");
                                            }
                                            ?>
                                            <li class="page-item <?php echo esc_attr($active) ?>">
                                                <a class="page-link" href="<?php echo esc_url($url) ?>"><?php echo esc_attr(absint($i)) + 1; ?></a>
                                            </li>
                                        <?php endfor; ?>
                                        </ul>
                                    </nav>
                                </div>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <br class="clear">
        <div class="ays-chart-add-new-button-box">
            <?php
                $svg_sanitize_properties = Chart_Builder_Admin::chart_builder_svg_sanitize_allowed_properties();
                $sanitized_plus_icon_svg = wp_kses($plus_icon_svg, $svg_sanitize_properties);
                echo sprintf( '<a href="?page=%s&action=%s" class="btn btn-primary chart-add-new-bttn chart-add-new-button-new-design"> %s ' . esc_html__( 'Add New', "chart-builder" ) . '</a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'add', wp_kses_post($plus_icon_svg));
            ?>
        </div>
        <?php if($chart_max_id <= 3): ?>
            <div class="ays-chart-create-chart-video-box" style="margin: 0 auto 30px;">
                <div class="ays-chart-create-chart-title">
                    <h4><?php echo esc_html__( "Create Your First Chart in Under One Minute", 'chart-builder' ); ?></h4>
                </div>
                <div class="ays-chart-create-chart-youtube-video">
                    <div class="ays-chart-youtube-placeholder" data-video-id="ysjUMK0HH3c" style="cursor: pointer">
                        <img src="<?php echo esc_url(CHART_BUILDER_ADMIN_URL .'/images/create-chart-on-wordpress.webp'); ?>" loading="lazy" width="560" height="315">
                    </div>
                </div>
                <div class="ays_chart_small_hint_text_for_message_variables" style="text-align: center;">
                    <?php echo esc_html__( 'Please note that this video will disappear once you created 4 charts.', 'chart-builder' ); ?>
                </div>
                <div class="ays-chart-create-chart-youtube-video-button-box">
                    <?php
                        $svg_sanitize_properties = Chart_Builder_Admin::chart_builder_svg_sanitize_allowed_properties();
                        $sanitized_plus_icon_svg = wp_kses($plus_icon_svg, $svg_sanitize_properties); 
                        echo sprintf( '<a href="?page=%s&action=%s" class="ays-chart-add-new-button-video chart-add-new-button-new-design"> %s ' . esc_html__('Add New', 'chart-builder') . '</a>', esc_attr( sanitize_text_field(wp_unslash($_REQUEST['page'] ))), 'add', wp_kses_post($plus_icon_svg));
                    ?>
                </div>
            </div>
        <?php else: ?>
            <div class="ays-chart-create-chart-video-box ays-chart-create-chart-video-box-only-link" style="margin: auto;">
                <div class="ays-chart-create-chart-youtube-video">
                    <?php
                        $svg_sanitize_properties = Chart_Builder_Admin::chart_builder_svg_sanitize_allowed_properties();
                        $sanitized_youtube_icon_svg = wp_kses($youtube_icon_svg, $svg_sanitize_properties);
                        echo wp_kses_post($sanitized_youtube_icon_svg); ?>
                    <a href="https://www.youtube.com/watch?v=ysjUMK0HH3c" target="_blank" style="color:#2271b1;text-decoration:none" title="YouTube video player"><?php echo esc_html__("How to create chart in one minute?", 'chart-builder'); ?></a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
